

CREATE TABLE `tbl_acledger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `grid` int(11) NOT NULL,
  `sgrid` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(250) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_acledger VALUES("1","200001","2","1","Petty Cash","","Every Days Official Expenses Amount","1","2020-04-22 12:22:21");
INSERT INTO tbl_acledger VALUES("2","200002","2","1","Cash","","Income Form Sales Or Other Income","1","2020-04-22 12:23:22");
INSERT INTO tbl_acledger VALUES("3","100001","1","6","Service Tools &amp; Equipment","","","1","2020-04-22 12:30:58");
INSERT INTO tbl_acledger VALUES("4","100002","1","6","Furniture, Fixture &amp; Interiors","","","1","2020-04-22 12:33:37");
INSERT INTO tbl_acledger VALUES("5","300001","3","30","Capital","","","1","2020-04-22 12:41:21");
INSERT INTO tbl_acledger VALUES("6","300002","3","31","Cash Withdrawal","","","1","2020-04-22 12:41:42");
INSERT INTO tbl_acledger VALUES("7","300003","3","32","Retained Earnings","","","1","2020-04-22 12:42:12");
INSERT INTO tbl_acledger VALUES("8","300004","3","32","VAT Reimbursement Account","","","1","2020-04-22 12:43:15");
INSERT INTO tbl_acledger VALUES("9","500001","5","14","VAT On Commission Payable","","","1","2020-04-22 12:44:09");
INSERT INTO tbl_acledger VALUES("10","500002","5","14","VAT On Sales Payable","","","1","2020-04-22 12:44:48");
INSERT INTO tbl_acledger VALUES("11","700001","7","27","Interest On FDR","","","1","2020-04-22 12:46:31");
INSERT INTO tbl_acledger VALUES("12","700002","7","28","Freight Receipt","","","1","2020-04-22 12:47:09");
INSERT INTO tbl_acledger VALUES("13","900021","9","21","Bank Charges","ব্যাংক চার্জ","","1","2020-04-22 12:48:48");
INSERT INTO tbl_acledger VALUES("14","600001","6","25","Cost Of Good Sold","","","1","2020-04-22 12:50:22");
INSERT INTO tbl_acledger VALUES("15","900032","9","21","Telephones &amp; Mobile Bill","টেলিফোন এবং মোবাইল বিল","","1","2020-04-22 12:48:04");
INSERT INTO tbl_acledger VALUES("16","900022","9","21","Electricity Bills","বিদ্যুৎ বিল","","1","2020-04-22 12:48:32");
INSERT INTO tbl_acledger VALUES("17","900023","9","21","Food, Lunch &amp; Entertainments","খাবার, দুপুরের খাবার এবং অন্যান্য","","1","2020-04-22 12:48:49");
INSERT INTO tbl_acledger VALUES("18","500007","5","16","Supplier Previous Balance","","","1","2020-04-22 12:49:09");
INSERT INTO tbl_acledger VALUES("19","900019","9","21","Conveyances","যাতায়াত খরচ","","1","2020-04-22 12:49:41");
INSERT INTO tbl_acledger VALUES("20","900027","9","21","Office Stationeries","কার্যালয়ের নিশ্চল খরচ","","1","2020-04-22 12:50:34");
INSERT INTO tbl_acledger VALUES("21","900020","9","21","Internet &amp; IT Expenses","ইন্টারনেট ও আইটির খরচ","","1","2020-04-22 12:50:56");
INSERT INTO tbl_acledger VALUES("22","900034","9","21","Sundry Expenses","বিবিধ খরচ","","1","2020-04-22 12:51:20");
INSERT INTO tbl_acledger VALUES("23","900025","9","21","Licences &amp; Renewals","লাইছেঞ্ছ নবায়ন খরচ","","1","2020-04-22 12:51:43");
INSERT INTO tbl_acledger VALUES("24","900029","9","21","Sales Commission","বিক্রয় কমিশন","","1","2020-04-22 12:52:17");
INSERT INTO tbl_acledger VALUES("25","800015","8","20","VAT On Purchase","ক্রয়ের উপর ভ্যাট","","1","2020-04-22 12:53:00");
INSERT INTO tbl_acledger VALUES("26","800014","8","20","Tax On Purchase","ক্রয়ের উপর ট্যাক্স","","1","2020-04-22 12:53:14");
INSERT INTO tbl_acledger VALUES("27","800013","8","20","Other Direct Expenses","অন্যান্য পরিচালন খরচ","","1","2020-04-22 12:53:29");
INSERT INTO tbl_acledger VALUES("28","900033","9","21","Tips &amp; Donations","টিপস এবং ডোনেশন","","1","2020-04-22 12:54:02");
INSERT INTO tbl_acledger VALUES("29","900028","9","21","Personal Expenses","ব্যাক্তিগত খরচ","All personal Expenses of Owner","1","2020-04-22 12:54:48");
INSERT INTO tbl_acledger VALUES("30","900024","9","21","Home Delivery","হোম ডেলিভারি","","1","2020-04-22 01:08:31");
INSERT INTO tbl_acledger VALUES("31","900026","9","21","Office Rent","কার্যালয়ের ভাড়া","","1","2020-04-27 10:35:17");
INSERT INTO tbl_acledger VALUES("32","700003","7","26","Commission Income","","","1","2020-04-27 10:45:27");
INSERT INTO tbl_acledger VALUES("33","100003","1","12","Customer Opening Balance","","","1","2020-04-27 10:54:57");
INSERT INTO tbl_acledger VALUES("34","600002","6","23","Sales Revenue","","","1","2020-04-28 02:20:11");
INSERT INTO tbl_acledger VALUES("35","900031","9","21","Water Bill","পানির বিল","Welcome Test","1","2020-04-29 11:29:35");
INSERT INTO tbl_acledger VALUES("36","800010","8","20","Discount On Sales","বিক্রয়ের ডিসকাউন্ট","","1","2020-06-11 07:58:38");
INSERT INTO tbl_acledger VALUES("37","800009","8","20","Discount On Item","আইটেমে ডিসকাউন্ট","","1","2020-06-11 08:00:10");
INSERT INTO tbl_acledger VALUES("38","500003","5","14","AIT On Sales Payable","","","1","2020-06-11 08:03:40");
INSERT INTO tbl_acledger VALUES("39","700004","7","28","Service Charges Receipts","","","1","2020-06-11 08:06:32");
INSERT INTO tbl_acledger VALUES("40","800011","8","20","Less Given On Sales","বিক্রয়ের উপর কমিশন","","1","2020-06-11 08:09:58");
INSERT INTO tbl_acledger VALUES("41","500005","5","16","Discount Reserves On Purchase","","","1","2020-06-16 11:25:15");
INSERT INTO tbl_acledger VALUES("42","500004","5","16","Discount Item On Purchase","","","1","2020-06-16 11:25:59");
INSERT INTO tbl_acledger VALUES("43","700007","7","28","Less Paid On Purchase","","","1","2020-06-16 11:29:10");
INSERT INTO tbl_acledger VALUES("44","900018","9","21","Labour &amp; Transportation","লেবার এবং ট্রান্সপোর্টেশন","","1","2020-06-16 11:41:50");
INSERT INTO tbl_acledger VALUES("45","800012","8","20","Less Receive On Purchase Return","ক্রয়কৃত পন্য ফেরতের উপর ছাড়","","1","2020-06-17 02:56:32");
INSERT INTO tbl_acledger VALUES("46","700008","7","28","Less Paid On Sales Return","","","1","2020-06-17 11:29:43");
INSERT INTO tbl_acledger VALUES("47","300005","3","30","Receive/Payable Adjustment Account","","Customer And Supplier Opening Balance","1","2020-07-07 12:43:41");
INSERT INTO tbl_acledger VALUES("48","500006","5","33","Salaries,Wages And Allowance","","Employee Salary","1","2020-07-23 11:01:51");
INSERT INTO tbl_acledger VALUES("49","800016","8","20","Product Adjustment","","Product witch are damage, stolen, miss use etc...","1","2020-08-25 01:35:32");
INSERT INTO tbl_acledger VALUES("50","800017","8","37","Cost Of Good Damage","","","1","2020-08-25 02:13:42");
INSERT INTO tbl_acledger VALUES("51","600003","6","38","Damage Revenue","","Product witch are damage, stolen, miss use etc...","1","2020-08-25 02:28:47");
INSERT INTO tbl_acledger VALUES("52","300006","3","31","Cash Withdrawn From Mobile Account","","Cash Withdrawn from Mobile Account","1","2020-10-10 03:49:47");
INSERT INTO tbl_acledger VALUES("53","900037","9","21","Motor Bike Bill","","","1","2020-10-14 08:34:32");
INSERT INTO tbl_acledger VALUES("54","900036","9","21","Entertainment","","","1","2020-11-12 07:46:54");
INSERT INTO tbl_acledger VALUES("55","000001","0","","M/ Jamal &amp; Brother`","","ca","1","2020-12-01 02:10:54");
INSERT INTO tbl_acledger VALUES("56","300007","3","30","13 Cons","","","1","2020-12-17 04:01:12");
INSERT INTO tbl_acledger VALUES("57","300008","3","30","Md. Mohib Ullah (Ripon)","","Md. Mohib Ullah (Ripon), Owners Equity, Share Capital.","1","2020-12-22 11:29:36");
INSERT INTO tbl_acledger VALUES("58","300009","3","30","Karim Khan","","","1","2020-12-23 05:18:17");
INSERT INTO tbl_acledger VALUES("59","300010","3","30","Naimul Hasan","","","1","2020-12-23 05:18:55");
INSERT INTO tbl_acledger VALUES("60","300011","3","30","Akbar Ali","","ownership ","1","2020-12-23 05:19:20");
INSERT INTO tbl_acledger VALUES("61","300012","3","30","Asabul Royen","","If any","1","2021-01-04 04:37:03");
INSERT INTO tbl_acledger VALUES("62","300013","3","30","Ashraful","","owner","1","2021-01-06 01:00:46");
INSERT INTO tbl_acledger VALUES("63","300014","3","30","Abul Kalam","","owner","1","2021-01-06 01:01:38");
INSERT INTO tbl_acledger VALUES("64","900038","9","21","Qwert","qwert","","1","2021-03-16 12:47:14");
INSERT INTO tbl_acledger VALUES("65","800018","8","20","Salary","","","5","2023-03-11 03:54:55");



CREATE TABLE `tbl_acmobile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `mobile` varchar(18) NOT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_bacount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bid` int(11) NOT NULL,
  `branch` varchar(45) DEFAULT NULL,
  `bbranch` varchar(255) DEFAULT NULL,
  `acno` varchar(25) NOT NULL,
  `title` varchar(45) NOT NULL,
  `location` varchar(250) NOT NULL,
  `brcode` varchar(6) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_bacount VALUES("6","7","Elephant road ","","0271020001346","Liberal IT","bata signal","02710","5","2022-01-22 02:28:24");



CREATE TABLE `tbl_bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` varchar(6) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_bank VALUES("7","OBL","one bank ltd","","5","2022-01-22 02:27:10");



CREATE TABLE `tbl_banktra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` double(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_banktrade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `seid` int(11) NOT NULL,
  `brid` int(11) DEFAULT 0,
  `cid` int(11) NOT NULL,
  `cty` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `did` int(11) NOT NULL,
  `dty` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_branch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `address` varchar(250) NOT NULL,
  `baddress` varchar(350) DEFAULT NULL,
  `phone` varchar(18) NOT NULL,
  `email` varchar(45) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(35) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_brand VALUES("1","HP","","","5","2021-11-17 12:53:16");
INSERT INTO tbl_brand VALUES("2","DELL","","","5","2021-11-17 12:53:22");
INSERT INTO tbl_brand VALUES("3","LENOVO","","","5","2021-11-17 12:53:34");
INSERT INTO tbl_brand VALUES("4","ASUS","","","5","2021-11-17 12:53:52");
INSERT INTO tbl_brand VALUES("5","ACER","","","5","2021-11-17 12:54:01");
INSERT INTO tbl_brand VALUES("6","APPLE","","","5","2021-11-17 12:54:08");
INSERT INTO tbl_brand VALUES("7","FUJITSU","","","5","2021-11-17 12:54:24");
INSERT INTO tbl_brand VALUES("8","NEC","","","5","2021-11-17 12:54:50");
INSERT INTO tbl_brand VALUES("9","MICROPACK","","","5","2021-11-17 12:55:43");
INSERT INTO tbl_brand VALUES("10","WD","","","5","2021-11-17 12:56:01");
INSERT INTO tbl_brand VALUES("11","KINGSPACE","","","5","2021-11-17 12:56:38");
INSERT INTO tbl_brand VALUES("12","ESET","","","5","2021-11-17 12:56:57");
INSERT INTO tbl_brand VALUES("13","HOCO","","","5","2021-11-17 12:57:08");
INSERT INTO tbl_brand VALUES("14","SAMSUNG","","","5","2021-11-17 12:57:37");
INSERT INTO tbl_brand VALUES("15","CADDY","","","5","2021-11-17 12:58:00");
INSERT INTO tbl_brand VALUES("16","MICROSOFT","","","5","2021-12-05 04:10:29");
INSERT INTO tbl_brand VALUES("17","SK hynix","","","5","2021-12-05 08:04:19");
INSERT INTO tbl_brand VALUES("18","SANDISK","","","5","2021-12-05 08:21:17");
INSERT INTO tbl_brand VALUES("19","JOHOUR","","","5","2021-12-05 08:24:04");
INSERT INTO tbl_brand VALUES("20","TOSHIBA","","","5","2021-12-08 03:09:39");
INSERT INTO tbl_brand VALUES("21","EMTEC","","","5","2021-12-08 03:17:36");
INSERT INTO tbl_brand VALUES("22","KINGSPEC","","","5","2021-12-08 03:27:21");
INSERT INTO tbl_brand VALUES("23","VALUE TECH","","","5","2021-12-08 04:21:18");
INSERT INTO tbl_brand VALUES("24","SEAGATE","","","5","2021-12-08 04:43:47");
INSERT INTO tbl_brand VALUES("25","HUAWEI","","","5","2021-12-08 04:49:17");
INSERT INTO tbl_brand VALUES("26","LOGITECH","","","5","2021-12-09 11:31:16");
INSERT INTO tbl_brand VALUES("27","MINI USB","","","5","2021-12-09 11:38:20");
INSERT INTO tbl_brand VALUES("28","GLOBAL BRAND","","","5","2021-12-09 11:40:26");
INSERT INTO tbl_brand VALUES("29","CANON","","","5","2021-12-29 11:16:06");
INSERT INTO tbl_brand VALUES("30","one plus ","","mobile phone","5","2022-01-29 01:22:53");
INSERT INTO tbl_brand VALUES("31","LITEON","","","5","2022-03-25 03:37:22");
INSERT INTO tbl_brand VALUES("32","CRUCIAL","","","5","2022-04-22 05:03:22");
INSERT INTO tbl_brand VALUES("33","DAREO","","","5","2022-05-12 02:44:03");
INSERT INTO tbl_brand VALUES("34","GREEDY BLACK","","","5","2022-05-12 07:22:01");
INSERT INTO tbl_brand VALUES("35","Google pixel book ","","","5","2022-09-04 01:46:00");
INSERT INTO tbl_brand VALUES("36","Gate Way","","","5","2022-10-27 01:00:17");
INSERT INTO tbl_brand VALUES("37","Surface ","","","5","2022-11-21 01:48:52");
INSERT INTO tbl_brand VALUES("38","Transcend","","","5","2022-12-21 12:55:51");



CREATE TABLE `tbl_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_category VALUES("2","1","CORE I3","","","5","2021-11-17 01:02:12");
INSERT INTO tbl_category VALUES("3","1","CORE I7","","","5","2021-11-17 01:02:24");
INSERT INTO tbl_category VALUES("5","1","CORE I5","","","5","2021-11-17 01:14:09");
INSERT INTO tbl_category VALUES("6","1","RYZON 3","","","5","2021-11-17 01:14:28");
INSERT INTO tbl_category VALUES("7","1","RYZON 5","","","5","2021-11-17 01:14:42");
INSERT INTO tbl_category VALUES("8","1","RYZON 7","","","5","2021-11-17 01:14:53");
INSERT INTO tbl_category VALUES("9","1","DUAL CORE","","","5","2021-11-17 01:15:18");
INSERT INTO tbl_category VALUES("11","1","CELERON","","","5","2021-11-17 01:15:42");
INSERT INTO tbl_category VALUES("12","1","SURFACE","","","5","2021-11-17 01:16:00");
INSERT INTO tbl_category VALUES("13","1","MAC MINI","","","5","2021-11-17 01:16:12");
INSERT INTO tbl_category VALUES("14","1","I PAD","","","5","2021-11-17 01:16:56");
INSERT INTO tbl_category VALUES("15","1","CORE 2 DUO","","","5","2021-11-17 01:20:30");
INSERT INTO tbl_category VALUES("16","8","i5","","","5","2021-11-18 11:06:38");
INSERT INTO tbl_category VALUES("17","1","CORE M5","","","5","2021-11-29 06:12:12");
INSERT INTO tbl_category VALUES("18","0","OPTICAL WIRELESS ","","","5","2021-12-05 06:21:12");
INSERT INTO tbl_category VALUES("19","0","ONE USER","","","5","2021-12-05 06:23:59");
INSERT INTO tbl_category VALUES("20","0","DDR 3","","","5","2021-12-05 06:25:47");
INSERT INTO tbl_category VALUES("21","0","DDR4","","","5","2021-12-05 06:26:00");
INSERT INTO tbl_category VALUES("22","0","M.2","","","5","2021-12-05 08:17:37");
INSERT INTO tbl_category VALUES("23","0","SATA","","","5","2021-12-05 08:23:46");
INSERT INTO tbl_category VALUES("24","0","1 TB","","","5","2021-12-05 08:25:32");
INSERT INTO tbl_category VALUES("25","0","2 TB","","","5","2021-12-05 08:25:43");
INSERT INTO tbl_category VALUES("26","0","AIR 2","","","5","2021-12-09 11:26:55");
INSERT INTO tbl_category VALUES("27","0","NUMERIC ","","","5","2021-12-09 11:37:52");
INSERT INTO tbl_category VALUES("28","0","HDD CADDY","","","5","2021-12-09 11:42:30");
INSERT INTO tbl_category VALUES("29","0","256 GB ","","","5","2022-01-29 01:28:01");
INSERT INTO tbl_category VALUES("30","33","Mobile ","","ROM 256","5","2022-02-07 01:09:31");
INSERT INTO tbl_category VALUES("31","1","AMD A 10","","","5","2022-03-08 06:20:50");
INSERT INTO tbl_category VALUES("32","1","AMD A8","","","5","2022-03-24 07:40:22");
INSERT INTO tbl_category VALUES("33","1","M1","","","5","2022-03-25 12:17:56");
INSERT INTO tbl_category VALUES("34","4","500 GB","","","5","2022-04-23 05:04:17");
INSERT INTO tbl_category VALUES("35","1","A4","","","5","2022-05-08 02:59:23");
INSERT INTO tbl_category VALUES("36","5","Optical","","","5","2022-05-12 02:43:11");
INSERT INTO tbl_category VALUES("37","33","512 GB","","","5","2022-06-04 12:13:58");
INSERT INTO tbl_category VALUES("38","33","8 GB","","","5","2022-06-09 11:19:46");
INSERT INTO tbl_category VALUES("39","1","Pentium","","","5","2022-08-14 01:05:37");
INSERT INTO tbl_category VALUES("40","1","Core M3","","Core M3","5","2022-09-28 04:30:58");
INSERT INTO tbl_category VALUES("41","1","Pentium 10th gen","","","5","2022-10-15 05:55:34");
INSERT INTO tbl_category VALUES("42","1","Ryzen ","","","5","2022-11-21 11:20:22");
INSERT INTO tbl_category VALUES("43","1","Ryzen 3 ","","","5","2022-11-21 11:20:40");
INSERT INTO tbl_category VALUES("44","1","display","","","5","2023-05-11 06:33:07");
INSERT INTO tbl_category VALUES("45","1","Core i9","","","5","2023-06-21 10:51:23");
INSERT INTO tbl_category VALUES("46","1","AMD PRO A12","","","5","2024-02-10 05:17:06");
INSERT INTO tbl_category VALUES("47","1","Chrome","","","5","2024-04-17 07:12:33");
INSERT INTO tbl_category VALUES("48","1","XEON","","","5","2024-05-06 07:48:03");
INSERT INTO tbl_category VALUES("49","33","12 Pro","","","5","2024-05-08 12:22:21");
INSERT INTO tbl_category VALUES("50","1","Ryzen 5","","","5","2024-07-26 12:29:59");
INSERT INTO tbl_category VALUES("51","1","AMD Ryzen 5","","4650 U","5","2024-07-26 12:33:38");
INSERT INTO tbl_category VALUES("52","1","AMD Ryzen 2500U","","","5","2024-08-01 05:46:24");
INSERT INTO tbl_category VALUES("53","1","Ryzen 7","","","5","2024-08-25 06:59:41");
INSERT INTO tbl_category VALUES("54","1","Ryzen 9","","","5","2024-10-10 05:47:06");



CREATE TABLE `tbl_cgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(35) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_cheqman` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientid` int(11) DEFAULT NULL,
  `type` varchar(2) DEFAULT NULL,
  `chkno` varchar(30) NOT NULL,
  `chkdt` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `acid` int(11) DEFAULT NULL,
  `refinv` varchar(30) DEFAULT NULL,
  `chbnkid` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `ref` varchar(255) DEFAULT NULL,
  `paymod` varchar(5) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `apdate` datetime NOT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) DEFAULT NULL,
  `code` varchar(15) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `cperson` varchar(45) DEFAULT NULL,
  `bcperson` varchar(255) DEFAULT NULL,
  `mname` varchar(45) DEFAULT NULL,
  `cnumber` varchar(18) NOT NULL,
  `cphone` varchar(14) DEFAULT NULL,
  `cemail` varchar(45) DEFAULT NULL,
  `nid` varchar(20) DEFAULT NULL,
  `creditlimit` double DEFAULT 0,
  `crepreiod` int(11) NOT NULL DEFAULT 0,
  `address` varchar(200) DEFAULT NULL,
  `baddress` varchar(350) DEFAULT NULL,
  `saddress` varchar(200) DEFAULT NULL,
  `did` int(11) DEFAULT NULL,
  `zid` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=380 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_customer VALUES("70","","ABA/CU/001","You Tech BD","","Rinko vai","","","01711385849","","","","0","0","Mirpor 10 SA paribahan goli fall potti","","","18","1","0","1","5","2022-02-01 06:08:35");
INSERT INTO tbl_customer VALUES("71","","ABA/CU/002","Computer LAB Omar Vai","","","","","01842517148","","","","0","0","Feni mohipal market
Feni","","","13","","0","1","5","2022-02-06 07:18:46");
INSERT INTO tbl_customer VALUES("72","","ABA/CU/003","Laptop House Pabna","","","","","01711641769","","","","0","0","pabna sadar","","","50","","0","1","5","2022-02-19 12:23:18");
INSERT INTO tbl_customer VALUES("73","","ABA/CU/004","Tariq IT ","","","","","01741660327","","","","0","0","dinajpur sadar","","","53","","0","1","5","2022-02-19 01:14:11");
INSERT INTO tbl_customer VALUES("74","","ABA/CU/005","Yasir Vai Techno World Sell","","","","","01716557055","","","","0","0","estern mollika ","","","18","","0","1","5","2022-02-19 01:15:41");
INSERT INTO tbl_customer VALUES("75","","ABA/CU/006","Brothers Gadget Zahid ","","","","","01955996905","","","","0","0","multiplan ","","","18","","0","1","5","2022-02-19 01:33:50");
INSERT INTO tbl_customer VALUES("76","","ABA/CU/007","RIDGE Computer","","","","","01835488929","","","","0","0","mirpur","","","18","","0","1","5","2022-02-19 01:39:28");
INSERT INTO tbl_customer VALUES("77","","ABA/CU/008","Ripon Technology Kurigram","","","","","01716100450","","","","0","0","kurigram","","","55","","0","1","5","2022-02-19 01:40:53");
INSERT INTO tbl_customer VALUES("78","","ABA/CU/009","Brand Leader Robirul","","","","","01715525485","","","","0","0","multiplan 8th floor ","","","18","","0","1","5","2022-02-19 01:42:34");
INSERT INTO tbl_customer VALUES("79","","ABA/CU/010","Ruhul Fortune","","","","","01681234566","","","","0","0","fortune market mowchak","","","18","","0","1","5","2022-02-19 01:43:43");
INSERT INTO tbl_customer VALUES("80","","ABA/CU/011","SH Computer BD","","","","","01849342649","","","","0","0","Suvastu archid 4th floor","","","18","","0","1","5","2022-02-19 01:44:56");
INSERT INTO tbl_customer VALUES("81","","ABA/CU/012","Shafin Vai Sheiltech ","","","","","01988999920","","","","0","0","dhanmondi 02","","","18","","0","1","5","2022-02-19 01:45:52");
INSERT INTO tbl_customer VALUES("82","","ABA/CU/013","Shoel Tamanna International","","","","","01834977440","","","","0","0","suvastu archid 718","","","18","","0","1","5","2022-02-19 01:51:44");
INSERT INTO tbl_customer VALUES("83","","ABA/CU/014","SWIFT CODE ","","","","","01711027398","","","","0","0","Basundara city ","","","18","","0","1","5","2022-02-19 01:53:44");
INSERT INTO tbl_customer VALUES("84","","ABA/CU/015","Taha IT Link","","","","","01717965582","","","","0","0","suvastu archid 1st floor ","","","18","","0","1","5","2022-02-19 01:56:05");
INSERT INTO tbl_customer VALUES("85","","ABA/CU/016","Tanvir Vai LIT","","","","","01758939092","","","","0","0","Suvastu archid ","","","18","","0","1","5","2022-02-19 01:56:57");
INSERT INTO tbl_customer VALUES("86","","ABA/CU/017","Modina Computer Mahfuz Vai","","","","","01873527333","","","","0","0","HM Plaza uttara ","","","18","","0","1","5","2022-02-19 02:00:18");
INSERT INTO tbl_customer VALUES("87","","ABA/CU/018","Pikter IT","","","","","01623486101","","","","0","0","multiplan ","","","18","","0","1","5","2022-02-19 02:04:06");
INSERT INTO tbl_customer VALUES("88","","ABA/CU/019","Dream Link Gadget Sumon Vai","","","","","01911232993","","","","0","0","shop no 10/A basundara city ","","","18","","0","1","5","2022-02-19 02:07:38");
INSERT INTO tbl_customer VALUES("89","","ABA/CU/020","Computer City Polas Jenidah","","","","","01738668529","","","","0","0","jenidah ","","","34","","0","1","5","2022-02-19 02:14:37");
INSERT INTO tbl_customer VALUES("90","","ABA/CU/021","JR Telecom","","","","","01923119054","","","","0","0","eastern plaza comilla ","","","11","","0","1","5","2022-02-19 02:16:34");
INSERT INTO tbl_customer VALUES("91","","ABA/CU/022","Jisan IT Sohel Vai ","","","","","01832193311","","","","0","0","suvastu archid 2nd floor ","","","18","","0","1","5","2022-02-19 02:19:09");
INSERT INTO tbl_customer VALUES("92","","ABA/CU/023","Kazi Technology Sozib Vai","","","","","01743104708","","","","0","0","sah ali market mirpur ","","","18","","0","1","5","2022-02-19 02:20:28");
INSERT INTO tbl_customer VALUES("93","","ABA/CU/024","AEON Sumon Vai ","","","","","01748988477","","","","0","0","suvastu 6th floor ","","","18","","0","1","5","2022-02-19 02:29:13");
INSERT INTO tbl_customer VALUES("94","","ABA/CU/025","ABS IT Solution ","","","","","01931231352","","","","0","0","bogra sadar","","","45","","0","1","5","2022-02-19 02:31:00");
INSERT INTO tbl_customer VALUES("95","","ABA/CU/026","Gateway Manik Vai","","","","","01714256581","","","","0","0","rangpur ","","","59","","0","1","5","2022-02-19 02:34:43");
INSERT INTO tbl_customer VALUES("96","","ABA/CU/027","Rafiq Vai 843 Suvastu","","","","","01726274360","","","","0","0","suvastu archid 8th floor shop no 843","","","18","","0","1","5","2022-02-20 05:48:33");
INSERT INTO tbl_customer VALUES("97","","ABA/CU/028","Friends Laptop Solution Sisir Vai","","","","","01674945383","","","","0","0","suvastu archid ICT Bhaban 1st floor 101","","","18","4","0","1","5","2022-03-24 07:03:10");
INSERT INTO tbl_customer VALUES("98","","ABA/CU/029","A To Z Uttara Jewel Vai","","jewel vai","","","01915536878","","","","0","0","uttara HM Plaza ","","","18","2","0","1","5","2022-03-24 07:06:52");
INSERT INTO tbl_customer VALUES("99","","ABA/CU/030","Dalim Vai","","","","","01927075716","","","","0","0","suvastu archid ICT Bhaban elephant road ","","","18","4","0","1","5","2022-03-24 07:11:00");
INSERT INTO tbl_customer VALUES("100","","ABA/CU/031","Bablu Vai ","","","","","01713264046","","","","0","0","kjh mention 6th floor ","","","18","3","0","1","5","2022-03-24 07:14:22");
INSERT INTO tbl_customer VALUES("101","","ABA/CU/032","Brothers And Tech Shoel Vai","","shoel vai ","","","01777813178","","","","0","0","multiplan 3rd floor ","","","18","4","0","1","5","2022-03-24 07:16:34");
INSERT INTO tbl_customer VALUES("102","","ABA/CU/033","Laptop Corner","","basu deb","","","01711358275","","","","0","0","kakoli mor borisal","","","","","0","1","5","2022-03-27 11:28:09");
INSERT INTO tbl_customer VALUES("103","","ABA/CU/034","Razasan Technology ","","shohag vai ","","","01704060968","","","","0","0","suvastu archid 6th floor 634","","","18","17","0","1","5","2022-03-27 11:31:32");
INSERT INTO tbl_customer VALUES("104","","ABA/CU/035","Brothers Technology ","","nur mohammad ","","","01713543429","","","","0","0","304 SR Tower house building uttara","","","18","2","0","1","5","2022-03-27 12:41:43");
INSERT INTO tbl_customer VALUES("105","","ABA/CU/036","Chistia Computer ","","mahfuz vai","","","01738668228","","","","0","0","VIP shopping centre shop number ground floor ","","","18","17","0","1","5","2022-03-27 01:57:00");
INSERT INTO tbl_customer VALUES("106","","ABA/CU/037","EDP","","Zafor vai ","","","01716982962","","","","0","0","উপজেলা মুক্তিযোদ্ধা কমপ্লেক্স ভবন 
সিরাজী সড়ক, সিরাজগঞ্জ। ","","","52","","0","1","5","2022-03-27 05:54:03");
INSERT INTO tbl_customer VALUES("107","","ABA/CU/038","Maraya Global","","MD.Sharfuddin ","","","01640936401","","","","0","0","alpona plaza shop no 301 2nd floor ","","","18","17","0","1","5","2022-03-28 02:49:35");
INSERT INTO tbl_customer VALUES("108","","ABA/CU/039","Tanvi IT Park Anayet Vai","","anayet vai","","","01714891574","","","","0","0","suvastu archid 2nd floor shop no 216 elephant road ","","","18","17","0","1","5","2022-03-28 07:18:15");
INSERT INTO tbl_customer VALUES("109","","ABA/CU/040","Argon Technology","","sahriar vai","","","01819415211","","","","0","0","suvastu archid suit no 701 and 702","","","18","17","0","1","5","2022-03-30 11:29:24");
INSERT INTO tbl_customer VALUES("110","","ABA/CU/041","Infinie Jabed CTG Sell","","Jabed vai","","","01819596929","","","","0","0","RF jhohura tower ctg computer city agrabad dewanhat ","","","","","0","1","5","2022-03-31 06:51:25");
INSERT INTO tbl_customer VALUES("111","","ABA/CU/042","LOOP","","Arif vai/tonmoy vai","","","01312135667","01707484777","","","0","0","rangs paramount level 14 house 11 road 17 block k banani dhaka 1213","","","18","","0","1","5","2022-04-02 01:59:22");
INSERT INTO tbl_customer VALUES("112","","ABA/CU/043","Computer Valley LTD","","ripon vai","","","01712746966","","","","0","0","IDB Bhaban 2/3 ","","","18","","0","1","5","2022-04-02 02:47:43");
INSERT INTO tbl_customer VALUES("113","","ABA/CU/044","CS Computers ","","chandan gomes","","","01782077290","","","","0","0","104 green road boro bazar 1st floor shop no 61 farmgate tejgaon dhaka 1215","","","18","","0","1","5","2022-04-02 06:23:43");
INSERT INTO tbl_customer VALUES("114","","ABA/CU/045","Mojib 6th Floor ","","mojib vai","","","01827021383","","","","0","0","suvastu 6th floor","","","18","17","0","1","5","2022-04-03 04:35:52");
INSERT INTO tbl_customer VALUES("115","","ABA/CU/046","Westford Immigration Service","","ahiq vai ","","","01709647354","01771771925","","","0","0","house 28 road 7 block c niketon gulshan","","","18","","0","1","5","2022-04-06 11:44:06");
INSERT INTO tbl_customer VALUES("116","","ABA/CU/047","AVOS TECH","","Sazid ","","","01844259932","","","","0","0","khilgaw dhaka","","","18","","0","1","5","2022-04-07 02:43:05");
INSERT INTO tbl_customer VALUES("117","","ABA/CU/048","Joshim Vai Nahar","","joshim ","","","01726225295","","","","0","0","nahar plaza ","","","18","","0","1","5","2022-04-09 03:47:24");
INSERT INTO tbl_customer VALUES("118","","ABA/CU/049","Taqwa Computer ","","sahin vai ","","","01689135199","","","","0","0","siddik plaza shop no 13","","","18","17","0","1","5","2022-04-10 02:02:46");
INSERT INTO tbl_customer VALUES("119","","ABA/CU/050","GADGET SHOP ","","Kamrul vai ","","","01911486600","","","","0","0","kholna ","","","35","","0","1","5","2022-04-10 03:59:50");
INSERT INTO tbl_customer VALUES("120","","ABA/CU/051","LOOX.com.BD","","","","","01858862838","","","","0","0","House 19 road 27 block J banani dhaka ","","","18","12","0","1","5","2022-04-11 12:40:21");
INSERT INTO tbl_customer VALUES("121","","ABA/CU/052","ESA Computer ","","anis vai ","","","01918885010","","","","0","0","suvastu archid 5th floor ","","","18","17","0","1","5","2022-04-14 09:50:06");
INSERT INTO tbl_customer VALUES("122","","ABA/CU/053","Al Modina Raqib Vai","","raqib vai ","","","01785043499","","","","0","0","komolapur ","","","18","","0","1","5","2022-04-18 12:11:54");
INSERT INTO tbl_customer VALUES("123","","ABA/CU/054","AR Gadget ","","rahman","","","01955129887","","","","0","0","suit 264 multiplan","","","","","0","1","5","2022-04-22 04:48:16");
INSERT INTO tbl_customer VALUES("124","","ABA/CU/055","SR Laptop Zone","","hasan vai ","","","01681295671","","","","0","0","SR Tower uttara ","","","","","0","1","5","2022-04-25 02:10:28");
INSERT INTO tbl_customer VALUES("125","","ABA/CU/056","Finalytics","","tamim vai ","","","01741405833","","","","0","0","green orland 7th floor plot KA 42-4 Progoti sarani RD Dhaka 1229","","","18","","0","1","5","2022-04-26 04:06:04");
INSERT INTO tbl_customer VALUES("126","","ABA/CU/057","Green IT Narayangong","","Monir vai ","","","01764498699","","","","0","0","somobay market chasara narayangong","","","","","0","1","5","2022-04-29 10:38:47");
INSERT INTO tbl_customer VALUES("127","","ABA/CU/058","Dream Watch Event And Logistics ","","murad hasan ","","","01920873393","","","","0","0","house 167/4 gulshan badda link road gulshan 1","","","18","12","0","1","5","2022-05-07 11:27:27");
INSERT INTO tbl_customer VALUES("128","","ABA/CU/059","Laxmi Computer ","","kanchan sharma","","","01715773645","","","","0","0","world college road juri moulvibazar ","","","64","","0","1","5","2022-05-07 11:51:07");
INSERT INTO tbl_customer VALUES("129","","ABA/CU/060","Muben TECH ","","Atiq vai ","","","01817603970","","","","0","0","khilgaw dhaka ","","","18","","0","1","5","2022-05-07 03:07:10");
INSERT INTO tbl_customer VALUES("130","","ABA/CU/061","Bismillah ENG Service ","","MD Razu ","","","01827406220","","","","0","0","lama bazar lama bandarban 
cokoria cox's bazar ","","cokoria cox's bazar ","","","0","1","5","2022-05-07 03:53:08");
INSERT INTO tbl_customer VALUES("131","","ABA/CU/062","Hands Clothing ","","MR. Shoel ","","","01710957341","","","","0","0","433 / 1 nanduain , master bari gazipur","","","18","","0","1","5","2022-05-08 06:08:21");
INSERT INTO tbl_customer VALUES("132","","ABA/CU/063","Laptop Solution ","","polas vai","","","01719943697","","","","0","0","suvastu archid ICT Bhaban elephant road ","","","","","0","1","5","2022-05-09 04:33:43");
INSERT INTO tbl_customer VALUES("133","","ABA/CU/064","GSM IT Shabar","","alamgir vai","","","01673100643","","","","0","0","UTSHAB Plaza shop no 225,232,249 and 250 bazar road savar dhaka","","","18","","0","1","5","2022-05-11 08:00:53");
INSERT INTO tbl_customer VALUES("134","","ABA/CU/065","Laptop World Sahin Vai","","sahin vai","","","01940964775","","","","0","0","9th floor multiplan centre ","","","18","","0","1","5","2022-05-12 12:05:08");
INSERT INTO tbl_customer VALUES("135","","ABA/CU/066","Salauddin Gulshan","","salauddin ","","","01712305514","","","","0","0","gulshan 1 dhaka bangladesh ","","","18","","0","1","5","2022-05-12 02:39:37");
INSERT INTO tbl_customer VALUES("136","","ABA/CU/067","Liveware ","","asif rahman","","","01711978479","","","","0","0","shop 5 1st floor aziz plaza victoria road tangail","","","","","0","1","5","2022-05-16 05:20:21");
INSERT INTO tbl_customer VALUES("137","","ABA/CU/068","SAM Dhanmondi","","SAM","","","01688397010","","","","0","0","Simanto square dhanmondi","","","18","","0","1","5","2022-05-18 01:16:05");
INSERT INTO tbl_customer VALUES("138","","ABA/CU/069","LAIBA TECH BD ","","Bukhary hossain","","","01733666694","","","","0","0","somobay new market chowrongi magura","","","","","0","1","5","2022-05-18 03:32:04");
INSERT INTO tbl_customer VALUES("139","","ABA/CU/070","Uzzal Vai Basundhara City","","uzzal vai ","","","01670171399","","","","0","0","basundhara city mobile floor","","","18","","0","1","5","2022-05-19 11:57:43");
INSERT INTO tbl_customer VALUES("140","","ABA/CU/071","Sakib Vai Kustia","","Sakib vai","","","01314405497","","","","0","0","kustia sadar","","","36","","0","1","5","2022-05-21 02:20:14");
INSERT INTO tbl_customer VALUES("141","","ABA/CU/072","NOVO COMputer-Kawsar Vai","","kawsar vai","","","01682131671","","","","0","0","65/3 ,East Basabo,Sky view Market,Kadantola,Dhaka","","65/3 ,East Basabo,Sky view Market,Kadantola,Dhaka","18","","0","1","5","2022-05-23 01:19:06");
INSERT INTO tbl_customer VALUES("142","","ABA/CU/073","ARS Technology","","sajal vai","","","01823117945","","","","0","0","175/5 5th floor mohakahali school road dhaka","","","18","","0","1","5","2022-05-27 04:36:52");
INSERT INTO tbl_customer VALUES("143","","ABA/CU/074","ABFA","","Monir vai ","","","01601772722","","","","0","0","suvastu archid ICT Bhaban ","","","18","","0","1","5","2022-05-28 05:28:29");
INSERT INTO tbl_customer VALUES("144","","ABA/CU/075","ZEN International LTD","","mozaffur vai","","","01674053026","","","","0","0","plaza AR 5th floor ","","","18","","0","1","5","2022-06-01 04:43:03");
INSERT INTO tbl_customer VALUES("145","","ABA/CU/076","Khan Gadget ","","Shahriar vai","","","01714929107","01714929107","","","0","0","404-405,Level-4,Subastu arcade ICT Bhaban,Elephant Road","","404-405,Level-4,Subastu arcade ICT Bhaban,Elephant Road","18","17","0","1","5","2022-06-02 06:37:39");
INSERT INTO tbl_customer VALUES("146","","ABA/CU/077","Three Sixty Taher Tower","","mohiuddin vai","","","01716603000","","","","0","0","taher tower gulshan 2","","","18","","0","1","5","2022-06-04 04:07:58");
INSERT INTO tbl_customer VALUES("147","","ABA/CU/078","WEB Link ","","rashed vai","","","01727135737","","","","0","0","house no 101 6th floor road 13/A Block C Banani dhaka ","","","18","","0","1","5","2022-06-06 11:40:22");
INSERT INTO tbl_customer VALUES("148","","ABA/CU/079","HELLO FIX","","Shohag","","","01732377500","","","","0","0","basundhara city shopping complex","","","18","","0","1","5","2022-06-09 01:50:34");
INSERT INTO tbl_customer VALUES("149","","ABA/CU/080","ARIF Gazipur","","","","","01987406802","","","","0","0","zorun word 7 konabari gazipur","","","","","0","1","5","2022-06-13 01:27:38");
INSERT INTO tbl_customer VALUES("150","","ABA/CU/081","Panna Vai ","","panna vai","","","01712073797","","","","0","0","garikhana jessore ","","","","","0","1","5","2022-06-13 01:41:40");
INSERT INTO tbl_customer VALUES("151","","ABA/CU/082","Islamia Computer ","","rayhan vai","","","01973037750","","","","0","0","suvastu archid 7th floor ","","","18","","0","1","5","2022-06-15 12:55:24");
INSERT INTO tbl_customer VALUES("152","","ABA/CU/083","RIDOY KHAN","","","","","01402056840","","","","0","0","KJH mension","","","","","0","1","5","2022-06-15 04:29:30");
INSERT INTO tbl_customer VALUES("153","","ABA/CU/084","Tonmoy ULAB","","Tonmoy","","","01616222337","","","","0","0","dhaka","","","","","0","1","5","2022-06-15 06:47:23");
INSERT INTO tbl_customer VALUES("154","","ABA/CU/085","Southland Computer IDB","","Yousuf vai","","","01727705896","","","","0","0","shop 144","","","18","","0","1","5","2022-06-20 05:28:56");
INSERT INTO tbl_customer VALUES("155","","ABA/CU/086","Eleus Vai Laptop Bag","","eleus vai","","","01756873253","","","","0","0","suvastu archid 6th floor 618","","","18","","0","1","5","2022-06-23 06:58:20");
INSERT INTO tbl_customer VALUES("156","","ABA/CU/087","Neptune Tech","","shahin vai ","","","01705582539","","","","0","0","mirpur 10 ","","","18","","0","1","5","2022-06-26 07:43:35");
INSERT INTO tbl_customer VALUES("157","","ABA/CU/088","T Soft ","","chompak","","","01759131460","","","","0","0","suvastu archid 6th 649","","","18","","0","1","5","2022-06-27 06:14:24");
INSERT INTO tbl_customer VALUES("158","","ABA/CU/089","Topesh Otobi","","","","","01847088564","","","","0","0","otobi ","","","18","","0","1","5","2022-07-02 12:19:56");
INSERT INTO tbl_customer VALUES("159","","ABA/CU/090","ZOOM Bangla","","yousuf vai","","","01772159259","","","","0","0","jamuna future park","","","18","","0","1","5","2022-07-03 02:35:16");
INSERT INTO tbl_customer VALUES("160","","ABA/CU/091","Based Vai Motalib Plaza","","based vai","","","+880 1714-812103","","","","0","0","motalib plaza","","","18","","0","1","5","2022-07-03 04:35:32");
INSERT INTO tbl_customer VALUES("161","","ABA/CU/092","Babul Vai ","","","","","01687286184","","","","0","0","suvastu archid 6th floor 664","","","18","","0","1","5","2022-07-07 05:22:17");
INSERT INTO tbl_customer VALUES("162","","ABA/CU/093","Automation Engineering And Controls LTD","","aslam","","","01711374252","","","","0","0","Tikatoli dhaka bangladesh ","","","18","","0","1","5","2022-07-20 07:39:42");
INSERT INTO tbl_customer VALUES("163","","ABA/CU/094","Unicorn System IQBAL","","Iqbal vai","","","01710500163","","","","0","0","suvastu archid shop 407","","","18","","0","1","5","2022-07-21 02:20:00");
INSERT INTO tbl_customer VALUES("164","","ABA/CU/095","Tanisha Computer Khagrachori","","jahangir vai","","","01553600900","","","","0","0","matiranga bazar khagrachori","","","","","0","1","5","2022-07-23 06:51:12");
INSERT INTO tbl_customer VALUES("165","","ABA/CU/096","Sumon Vai Feni","","sumon vai","","","01973448838","","","","0","0","abedin super market 3rd floor trunk road zero point ","","","13","","0","1","5","2022-07-24 04:06:40");
INSERT INTO tbl_customer VALUES("166","","ABA/CU/097","BGD Corporation","","abul kashem","","","01974344929","","","","0","0","road 23 house 4 pallabi panir tanki goli mirpur 11.5","","","18","","0","1","5","2022-07-27 02:49:51");
INSERT INTO tbl_customer VALUES("167","","ABA/CU/098","Shafin Vai","","shafin vai","","","01707777750","","","","0","0","dhanmondi ","","","18","","0","1","5","2022-07-30 06:50:02");
INSERT INTO tbl_customer VALUES("168","","ABA/CU/099","Renesa Nazmul Vai","","nazmul vai","","","01674008200","","","","0","0","asulia ","","","18","","0","1","5","2022-08-01 12:15:10");
INSERT INTO tbl_customer VALUES("169","","ABA/CU/100","Search Tech Multiplan","","pappu vai","","","01952273428","","","","0","0","shop 567 multiplan","","","18","","0","1","5","2022-08-01 06:29:12");
INSERT INTO tbl_customer VALUES("170","","ABA/CU/101","Intense Simanto","","nazmul vai","","","01672394800","","","","0","0","simanto sombar level 3 shop no 3031","","","18","","0","1","5","2022-08-03 03:21:09");
INSERT INTO tbl_customer VALUES("171","","ABA/CU/102","OTOBI Limited ","","otobi","","","01847088837","","","","0","0","otobi centre dhaka bangladesh","","","18","","0","1","5","2022-08-04 04:28:50");
INSERT INTO tbl_customer VALUES("172","","ABA/CU/103","MK Electronics","","limon","","","01923982546","","","","0","0","suvastu archid elephant road ","","","18","","0","1","5","2022-08-04 05:23:37");
INSERT INTO tbl_customer VALUES("173","","ABA/CU/104","Famous Laptop Gallery","","ariful islam","","","01739366592","","","","0","0","suvastu archid shop 117 level 02","","","18","","0","1","5","2022-08-06 12:32:13");
INSERT INTO tbl_customer VALUES("174","","ABA/CU/105","Sabbir Mohakahali","","Sabbir ","","","01710265948","","","","0","0","mohakhali dhaka bangaldesh","","","18","","0","1","5","2022-08-08 11:20:06");
INSERT INTO tbl_customer VALUES("175","","ABA/CU/106","3 Star Computer ","","nazmul islam","","","01736699494","","","","0","0","latif school road sabujbag patuakhali","","","5","","0","1","5","2022-08-13 04:31:08");
INSERT INTO tbl_customer VALUES("176","","ABA/CU/107","Exchange Kori Limited  ","","rasel vai ","","","01719363001","","","","0","0","house 69 1st floor road 8 block D Niketon gulshan","","","18","","0","1","5","2022-08-14 04:13:42");
INSERT INTO tbl_customer VALUES("177","","ABA/CU/108","Learning And Earning ","","adnan vai","","","01832744009","","","","0","0","luxury hasan tower 1st floor purana passport road thanapukurpar jhiltuli faridpur","","","19","","0","1","5","2022-08-20 12:55:28");
INSERT INTO tbl_customer VALUES("178","","ABA/CU/109","Gadget A  To Z","","Jabed vai ","","","01635411829","","","","0","0","alpona plaza","","","","","0","1","5","2022-08-24 04:19:44");
INSERT INTO tbl_customer VALUES("179","","ABA/CU/110","Metronet Data System","","jamil vai","","","01914176050","","","","0","0","suvastu archid ICT Bhaban 601 and 602","","","18","","0","1","5","2022-08-26 03:06:54");
INSERT INTO tbl_customer VALUES("180","","ABA/CU/111","Technology Park","","raymon vai","","","01611444990","","","","0","0","suvastu archid ICT Bhaban ","","","18","","0","1","5","2022-08-26 05:24:09");
INSERT INTO tbl_customer VALUES("181","","ABA/CU/112","Dibos Dada","","dibos vai","","","01750052098","","","","0","0","ab computer ","","","","","0","1","5","2022-09-01 03:42:04");
INSERT INTO tbl_customer VALUES("182","","ABA/CU/113","ETC Computer","","nowshad vai","","","01746303749","","","","0","0","330 and 3301 alpona plaza","","","18","","0","1","5","2022-09-04 05:18:46");
INSERT INTO tbl_customer VALUES("183","","ABA/CU/114","Technocare ","","zahidul vai","","","01711341082","","","","0","0","IDB dhaka bangladesh","","","18","","0","1","5","2022-09-05 05:19:05");
INSERT INTO tbl_customer VALUES("184","","ABA/CU/115","EVAN Tech","","tuhin vai","","","01836550000","","","","0","0","suvastu archid 6th floor ","","","18","","0","1","5","2022-09-07 05:30:20");
INSERT INTO tbl_customer VALUES("185","","ABA/CU/116","GMICT ","","MD. rafiqul islam","","","01712801147","","","","0","0","shia masjid mohammudpur  dhaka","","","18","","0","1","5","2022-09-10 10:56:06");
INSERT INTO tbl_customer VALUES("186","","ABA/CU/117","ROWTECH ","","Zahir vai","","","01878566030","","","","0","0","shop no 341 multiplan","","","18","","0","1","5","2022-09-10 11:40:00");
INSERT INTO tbl_customer VALUES("187","","ABA/CU/118","Laptop Bazar ","","masud vai","","","01711705210","","","","0","0","rajshahi newmarket","","","","","0","1","5","2022-09-10 06:52:21");
INSERT INTO tbl_customer VALUES("188","","ABA/CU/119","Next Future IT","","A B Siddik","","","01920677960","01920677960","","","0","0","332,Level-3,SR Tower,Uttara ,Dhaka","","332,Level-3,SR Tower,Uttara ,Dhaka","18","","0","1","5","2022-09-11 07:06:29");
INSERT INTO tbl_customer VALUES("189","","ABA/CU/120","IT Park Uttara ","","zahirul islam","","","01718545665","","","","0","0","SR Tower shop no 322 and 324","","","18","","0","1","5","2022-09-22 03:55:26");
INSERT INTO tbl_customer VALUES("190","","ABA/CU/121","BM Technology","","shovon vai","","","01611478959","","","","0","0","multiplan","","","","","0","1","5","2022-09-26 02:32:55");
INSERT INTO tbl_customer VALUES("191","","ABA/CU/122","Sinthia Computer And Information","","rasel vai ","","","01716485723","","","","0","0","VIP Shoping centre ground floor 111/1","","","18","","0","1","5","2022-09-29 02:45:35");
INSERT INTO tbl_customer VALUES("192","","ABA/CU/123","Masud Computer Cumilla ","","Masud vai ","","","01842093271","","","","0","0","cumilla","","","","","0","1","5","2022-10-01 01:47:02");
INSERT INTO tbl_customer VALUES("193","","ABA/CU/124","Rifat Vai  Cox Bazar","","sadek","","","01632521703","","","","0","0","cox bazar sadar","","","","","0","1","5","2022-10-01 01:48:48");
INSERT INTO tbl_customer VALUES("194","","ABA/CU/125","Electro Soft ","","zisan vai","","","01913208040","","","","0","0","shop no 102 and 103 multiplan","","","18","","0","1","5","2022-10-09 05:23:32");
INSERT INTO tbl_customer VALUES("195","","ABA/CU/126","HI TECH Technology BD","","Milon vai","","","01711178520","","","","0","0","shop number 234 multiplan centre ","","","18","","0","1","5","2022-10-17 01:26:07");
INSERT INTO tbl_customer VALUES("196","","ABA/CU/127","Pinnacle Computer Technology","","sarowar vai","","","01718241097","","","","0","0","suvastu 6th floor shop number 630","","","18","","0","1","5","2022-10-17 02:07:08");
INSERT INTO tbl_customer VALUES("197","","ABA/CU/128","Rapid IT Solution","","shoel vai","","","01714789594","","","","0","0","gazipur chowrasta ","","","","","0","1","5","2022-10-17 04:33:51");
INSERT INTO tbl_customer VALUES("198","","ABA/CU/129","A 2 Z KJH Mension","","MD Sah alam","","","01778303183","","","","0","0","KJH mension","","","18","","0","1","5","2022-10-19 06:27:11");
INSERT INTO tbl_customer VALUES("199","","ABA/CU/130","Shohag 6th Floor ","","shohag vai","","","01978611001","","","","0","0","suvastu archid 6th floor 636","","","18","","0","1","5","2022-10-20 06:29:48");
INSERT INTO tbl_customer VALUES("200","","ABA/CU/131","Shoel Computer ","","shoel vai ","","","01713534731","","","","0","0","kishorgonj ","","","","","0","1","5","2022-10-21 12:27:49");
INSERT INTO tbl_customer VALUES("201","","ABA/CU/132","ERA Computer ","","era computer ","","","01616256722","","","","0","0","sirajgong","","","","","0","1","5","2022-11-03 01:26:09");
INSERT INTO tbl_customer VALUES("202","","ABA/CU/133","Kashem Vai Mirpur","","kashem vai","","","01977300003","","","","0","0","dewan market 2nd floor shop no 4","","","18","","0","1","5","2022-11-03 06:10:14");
INSERT INTO tbl_customer VALUES("203","","ABA/CU/134","FUN FACT TECH Rashed ","","rashed ","","","01914373437","","","","0","0","ICT Bhaban 7th floor 726","","","18","","0","1","5","2022-11-04 06:50:02");
INSERT INTO tbl_customer VALUES("204","","ABA/CU/135","Nahid Narayangong","","nahid","","","01647658123","","","","0","0","jalkuri siddirgong narayangong","","","18","","0","1","5","2022-11-04 07:22:51");
INSERT INTO tbl_customer VALUES("205","","ABA/CU/136","Eplanet Rana Vai","","masud rana","","","01712619867","","","","0","0","simanto sombar shop no 3077","","","18","","0","1","5","2022-11-09 11:56:17");
INSERT INTO tbl_customer VALUES("206","","ABA/CU/137","Source Raju Vai","","raju vai","","","01923453577","","","","0","0","raju vai","","","18","","0","1","5","2022-11-10 05:43:41");
INSERT INTO tbl_customer VALUES("207","","ABA/CU/138","JM Computer ","","mahin vai","","","01320406625","","","","0","0","ICT bahaban suvastu archid elephant road ","","","18","","0","1","5","2022-11-11 07:37:24");
INSERT INTO tbl_customer VALUES("208","","ABA/CU/139","Computer Park Sankar Dada","","sankar dada","","","01828116741","","","","0","0","kataltali banarupa rangamati ","","","","","0","1","5","2022-11-16 07:05:14");
INSERT INTO tbl_customer VALUES("209","","ABA/CU/140","Komol Uttra ","","komol ","","","01675563470","","","","0","0","uttara ","","","","","0","1","5","2022-11-22 07:20:58");
INSERT INTO tbl_customer VALUES("210","","ABA/CU/141","Nahid Vai Baridhara ","","nahid ","","","01781666859","","","","0","0","baridhara DOSH ","","","18","","0","1","5","2022-11-23 11:30:55");
INSERT INTO tbl_customer VALUES("211","","ABA/CU/142","Wintech Sujon Vai","","sujon vai","","","01912242087","","","","0","0","yousuf mention ","","","18","","0","1","5","2022-11-23 01:27:50");
INSERT INTO tbl_customer VALUES("212","","ABA/CU/143","Oasis Gadget ","","sahadad vai ","","","01711060214","","","","0","0","multiplan 813 level 8","","","18","","0","1","5","2022-11-24 05:05:34");
INSERT INTO tbl_customer VALUES("213","","ABA/CU/144","Laptop Gadget BD","","RAJ ","","","01919546111","","","","0","0","ICT Bhaban suvastu archid level 6 shop no 647","","","18","","0","1","5","2022-11-25 06:20:06");
INSERT INTO tbl_customer VALUES("214","","ABA/CU/145","Click IT Suvastu","","arup dada","","","01735552012","","","","0","0","ICT Bhaban suvastu archid 5th floor 531","","","","","0","1","5","2022-11-30 07:02:00");
INSERT INTO tbl_customer VALUES("215","","ABA/CU/146","Faridpur Computer Rafiq Vai","","rafiq vai ","","","01912441832","","","","0","0","dewan market mirpur ","","","18","","0","1","5","2022-12-01 04:17:55");
INSERT INTO tbl_customer VALUES("216","","ABA/CU/147","Rasel Laptop Gallery","","monir vai ","","","01617703372","","","","0","0","capital tower mirpur shop no 14","","","18","","0","1","5","2022-12-01 05:59:10");
INSERT INTO tbl_customer VALUES("217","","ABA/CU/148","Western Technology ","","fahim vai ","","","01873388866","","","","0","0","ICT Bhaban 1st floor shop no 09 and 10","","","18","","0","1","5","2022-12-01 06:11:05");
INSERT INTO tbl_customer VALUES("218","","ABA/CU/149","Techno Care Computer LTD","","MD. Jahedul Alam","","","01730031940","","","","0","0","IDB Bhaban shop 223/4","","","18","","0","1","5","2022-12-01 07:03:45");
INSERT INTO tbl_customer VALUES("219","","ABA/CU/150","Rainbow Trade International Minto Vai","","minto vai","","","01915693679","","","","0","0","ICT Bhaban suvastu archid ","","","18","","0","1","5","2022-12-03 11:10:51");
INSERT INTO tbl_customer VALUES("220","","ABA/CU/151","Sumon Vai Gulshan","","sumon vai","","","01643049888","","","","0","0","taher tower gulshan ","","","18","","0","1","5","2022-12-05 06:49:07");
INSERT INTO tbl_customer VALUES("221","","ABA/CU/152","SM Computer ","","sanwar vai ","","","01719522919","","","","0","0","multiplan centre ","","","18","","0","1","5","2022-12-08 05:45:21");
INSERT INTO tbl_customer VALUES("222","","ABA/CU/153","Asad Vai Software","","","","","01920-729893","01920-729893","","","0","0","ElephantRoad,Dhaka","","ElephantRoad,Dhaka","18","17","0","1","5","2022-12-09 07:29:48");
INSERT INTO tbl_customer VALUES("223","","ABA/CU/154","SB IT Bappi Vai Uttara","","","","","01775-000771","01775-000771","","","0","0","SHOP-53,LEVEL-2,SYED GRAND CENTRE,UTTARA","","SHOP-53,LEVEL-2,SYED GRAND CENTRE,UTTARA","18","2","0","1","5","2022-12-14 02:18:05");
INSERT INTO tbl_customer VALUES("224","","ABA/CU/155","Amelia IT","","Mamun vai","","","01553800900","","","","0","0","30 mohakahali DOSH Hosue 435 1st floor ","","","18","","0","1","5","2022-12-15 07:36:22");
INSERT INTO tbl_customer VALUES("225","","ABA/CU/156","Computer City Maijdee","","rahmat vai","","","01746543727","","","","0","0","paris plaza town hall main road maijdee court noakhali","","","16","","0","1","5","2022-12-18 05:52:30");
INSERT INTO tbl_customer VALUES("226","","ABA/CU/157","SARBS Communications Ltd","","","","","01844021543","01844021543","asif.hasan@sarbs.net","","0","0","Sazanas level-5,house-4,road-32,gulsan-01,dhaka","","Sazanas level-5,house-4,road-32,gulsan-01,dhaka","18","12","0","1","5","2022-12-19 11:26:06");
INSERT INTO tbl_customer VALUES("227","","ABA/CU/158","Parvej Vai Kishorgonj","","parvej vai","","","01914157904","","","","0","0","kishorgonj ","","","","","0","1","5","2022-12-19 05:40:14");
INSERT INTO tbl_customer VALUES("228","","ABA/CU/159","Wajeehan Computer Mart","","nahid vai","","","01673686454","","","","0","0","ICT Bhaban shop no 20","","","18","","0","1","5","2022-12-21 05:45:05");
INSERT INTO tbl_customer VALUES("229","","ABA/CU/160","UCC ","","","","","01833-331621","01833-331621","","","0","0","Multiplan Centre, Elephant Road,Dhaka","","Multiplan Centre, Elephant Road,Dhaka","18","17","0","1","5","2022-12-25 05:51:04");
INSERT INTO tbl_customer VALUES("230","","ABA/CU/161","Vision Tech ENG","","","","","01737-576281","01737-576281","","","0","0","Shop#321,Level#3,Multiplan Centre,Elephant Road","","Shop#321,Level#3,Multiplan Centre,Elephant Road","18","17","0","1","5","2022-12-29 01:33:43");
INSERT INTO tbl_customer VALUES("231","","ABA/CU/162","Ultra Technology","","","","","01720254546","01720254546","","","0","0","Shop-511-512,Level-5,Multipla Centre,Elephant Road,Dhaka","","Shop-511-512,Level-5,Multipla Centre,Elephant Road,Dhaka","18","17","0","1","5","2023-01-04 04:03:16");
INSERT INTO tbl_customer VALUES("232","","ABA/CU/163","MR. Laptop Wala ","","","","","01873-270551","01873-270551","","","0","0","Sonirakra,jatrabari,Dhaka","","Sonirakra,jatrabari,Dhaka","18","","0","1","5","2023-01-06 04:15:29");
INSERT INTO tbl_customer VALUES("233","","ABA/CU/164","Mahtab Vai","","","","","01611152155","01611152155","","","0","0","level 7,Subastu arcade ICT Bhaban,Elphant road","","level 7,Subastu arcade ICT Bhaban,Elphant road","","","0","1","5","2023-01-15 12:00:11");
INSERT INTO tbl_customer VALUES("234","","ABA/CU/165","IT Gadget Multiplan","","IT gadget ","","","01786651985","","","","0","0","multiplan centre 121 ","","","18","","0","1","5","2023-01-22 07:13:07");
INSERT INTO tbl_customer VALUES("235","","ABA/CU/166","Electrosoft &amp; Liberal IT ( JV)","","","","","01902-915818","01911089010","","","0","0","Ground floor,Multiplan Centre ","","Ground floor,Multiplan Centre ","18","17","0","1","5","2023-01-25 03:48:30");
INSERT INTO tbl_customer VALUES("236","","ABA/CU/167","Zaman Computer Nahar Plaza","","zaman vai","","","01740992887","","","","0","0","nahar palaza shop 343","","","18","","0","1","5","2023-01-26 02:05:20");
INSERT INTO tbl_customer VALUES("237","","ABA/CU/168","SA Laptop Multiplan","","Shohag vai","","","01747821100","01747821100","","","0","0","973,Level 9,Multiplan Centre,Elephanr Road","","973,Level 9,Multiplan Centre,Elephanr Road","18","17","0","1","5","2023-01-27 07:28:45");
INSERT INTO tbl_customer VALUES("238","","ABA/CU/169","Alamin Vai Kishorgonj","","Alamin","","","01911555169","01911555169","","","0","0","Kishorgang","","Kishorgang","22","","0","1","5","2023-01-30 06:07:32");
INSERT INTO tbl_customer VALUES("239","","ABA/CU/170","Bangladesh Laptop Gallery Arif Vai","","arif vai ","","","01687321007","","","","0","0","suvastu archid 731 ","","","18","","0","1","5","2023-02-01 05:25:52");
INSERT INTO tbl_customer VALUES("240","","ABA/CU/171","IQRAH TRADE INTERNATIONAL ","","Omar Vai","","","01817796485","01817796485","","","0","0","SHOP-374 Level-3,Multiplan Centre,
Elephant  Road","","SHOP-374 Level-3,Multiplan Centre,
Elephant  Road","18","17","0","1","5","2023-02-01 05:39:53");
INSERT INTO tbl_customer VALUES("241","","ABA/CU/172","Digi TECH Suvastu","","masudur rahman","","","01822875888","","","","0","0","shop no 527 suvastu archid 5th floor ","","","18","","0","1","5","2023-02-03 05:45:11");
INSERT INTO tbl_customer VALUES("242","","ABA/CU/173","NMB Computer","","Jisan","","","01852013486","01852013486","","","0","0","4th floor,Subastu arcade ICT Bhaban,elephant Road","","4th floor,Subastu arcade ICT Bhaban,elephant Road","18","17","0","1","5","2023-02-05 06:42:16");
INSERT INTO tbl_customer VALUES("243","","ABA/CU/174","SL Computer BD","","SH Sagor","","","01955874624","01955874624","","","0","0","721,Level-7,Subastu arcade ICT Bhaban","","721,Level-7,Subastu arcade ICT Bhaban","18","17","0","1","5","2023-02-05 07:28:01");
INSERT INTO tbl_customer VALUES("244","","ABA/CU/175","Power Land Rajib","","rajib","","","01743496843","","","","0","0","shop no 846,47 and 48 suvastu archid ","","","","","0","1","5","2023-02-06 06:50:00");
INSERT INTO tbl_customer VALUES("245","","ABA/CU/176","Pathao Ltd","","Rakibul ","","","01904488206","01904488206","","","0","0","Gulsan 02","","Gulsan 02","","","0","1","5","2023-02-12 02:28:05");
INSERT INTO tbl_customer VALUES("246","","ABA/CU/177","Micro Fiber Group","","Zaman khaiser","","","01711547549","01711547549","","","0","0","Gulsan ","","Gulsan","","","0","1","5","2023-02-12 02:29:42");
INSERT INTO tbl_customer VALUES("247","","ABA/CU/178","Tusuka Group","","Delwar Hossain","","","01972111965","01972111965","","","0","0","Gazipur Chowrasta","","Gazipur Chowrasta","","","0","1","5","2023-02-12 02:30:47");
INSERT INTO tbl_customer VALUES("248","","ABA/CU/179","Zakaria Trust Link IT","","Zakaria ","","","01919899483","","","","0","0","suvastu archid ICT Bhaban shop no 724","","","","","0","1","5","2023-02-15 12:35:26");
INSERT INTO tbl_customer VALUES("249","","ABA/CU/180","Masum Vai Fredom ","","masum vai","","","01975101050","","","","0","0","seltech seira bata signal","","","18","","0","1","5","2023-02-17 04:59:52");
INSERT INTO tbl_customer VALUES("250","","ABA/CU/181","Ayota","","","","","01869855113","01869855113","","","0","0","Shop-850,Level-8,Subastu Arcade ICT Bhaban,Elephant Road","","Shop-850,Level-8,Subastu Arcade ICT Bhaban,Elephant Road","18","17","0","1","5","2023-02-19 06:34:35");
INSERT INTO tbl_customer VALUES("251","","ABA/CU/182","Asia Computer Bazar","","Riad vai","","","01795-308041","01795-308041","","","0","0","Shop-931-933","","Shop-931-933","18","17","0","1","5","2023-02-25 01:32:38");
INSERT INTO tbl_customer VALUES("252","","ABA/CU/183","Masum IT Cottage","","Masum vai","","","01730898970","01730898970","","","0","0","05,Surtorongo Road,Cheragali,Tongi","","05,Surtorongo Road,Cheragali,Tongi","18","2","0","1","5","2023-02-27 04:07:00");
INSERT INTO tbl_customer VALUES("253","","ABA/CU/184","Rony Electronics ","","ismail vai","","","01721590902","","","","0","0","65,66 club super market mukto mohadal bhaban chapainawabganj ","","","49","","0","1","5","2023-03-18 04:20:11");
INSERT INTO tbl_customer VALUES("254","","ABA/CU/185","Rafiq Vai Vision Tech","","Rafiq vai","","","01737576281","","","","0","0","shop no 321 multiplan centre dhaka bangladesh","","","18","","0","1","5","2023-03-19 01:18:23");
INSERT INTO tbl_customer VALUES("255","","ABA/CU/186","Fast Laptop Imran ","","Imran","","","01615778848","","","","0","0","shop no 648 suvastu archid 6th floor ","","","18","","0","1","5","2023-03-19 06:00:04");
INSERT INTO tbl_customer VALUES("256","","ABA/CU/187","Bangla Computer ","","kader vai ","","","01687422843","","","","0","0","suvastu archid shop no 218-19 dhaka bangladesh","","","","","0","1","5","2023-03-19 06:14:58");
INSERT INTO tbl_customer VALUES("257","","ABA/CU/188","Uzzal Vai Multiplan","","uzzal","","","01971887054","","","","0","0","Multiplan centre 467 ","","","","","0","1","5","2023-03-23 02:38:08");
INSERT INTO tbl_customer VALUES("258","","ABA/CU/189","Ahnaf Vai ","","ahnaf vai","","","01873270551","","","","0","0","shop 27 4th floor ayesha mosharraf shoping complex sonirakhra jatrabari","","","","","0","1","5","2023-03-24 03:46:07");
INSERT INTO tbl_customer VALUES("259","","ABA/CU/190","Computer House","","MD Alamin","","","01689433747","01689433747","","","0","0","725,level-7,Subastu Arcade ICT Bhaban,Elephant Road","","725,level-7,Subastu Arcade ICT Bhaban,Elephant Road","18","17","0","1","5","2023-04-01 12:06:30");
INSERT INTO tbl_customer VALUES("260","","ABA/CU/191","HF Trading International","","momin vai","","","01611467470","","","","0","0","suvastu archid 6th floor shop no 631-633","","","","","0","1","5","2023-04-02 07:04:34");
INSERT INTO tbl_customer VALUES("261","","ABA/CU/192","Gazipur Laptop Corner","","mamun vai","","","01723772013","","","","0","0","akanda mension mosjid road joydupur gazipur 01304-469920","","","","","0","1","5","2023-04-03 01:00:42");
INSERT INTO tbl_customer VALUES("262","","ABA/CU/193","Mokles Vai","","mokles vai","","","01639573867","","","","0","0","479 DIT Road malibag","","","","","0","1","5","2023-04-03 05:02:17");
INSERT INTO tbl_customer VALUES("263","","ABA/CU/194","Shovon Vai","","Shovon","","","01309169233","","","","0","0","level-14,Multiplan Centre ,Elephant Road","","","18","17","","1","5","2023-04-03 05:33:04");
INSERT INTO tbl_customer VALUES("264","","ABA/CU/195","Ideal Computer &amp; Technology ","","Engr. Sultan ","","","01817-703320","01817-703320","","","0","0","211-212,level-2,Multiplan Centre,Elephant Road","","211-212,level-2,Multiplan Centre,Elephant Road","18","17","0","1","5","2023-04-16 12:45:27");
INSERT INTO tbl_customer VALUES("265","","ABA/CU/196","ALPHA TECH","","","","","01717466111","01717466111","","","0","0","Shope no.18 Ground floor ,Press Club Market, Rangpur","","","59","","0","1","5","2023-05-06 06:11:46");
INSERT INTO tbl_customer VALUES("266","","ABA/CU/197","Tech Village","","Tapos","","","0187844525","0187844525","","","0","0","3rd Floor,Syed Ground Centre,Uttara","","3rd Floor,Syed Ground Centre,Uttara","18","2","0","1","5","2023-05-10 04:38:10");
INSERT INTO tbl_customer VALUES("267","","ABA/CU/198","Muscom Rony ","","rony ","","","01686239608","","","","0","0","multiplan shop no 262","","","","","0","1","5","2023-05-11 12:17:58");
INSERT INTO tbl_customer VALUES("268","","ABA/CU/199","MR Computer Sales &amp; Service","","Mamun vai","","","01704446213","01704446213","","","0","0","Fulbari Savar","","Fulbari Savar","18","","0","1","5","2023-05-12 11:51:38");
INSERT INTO tbl_customer VALUES("269","","ABA/CU/200","Wanted Computer","","Ismail Hossain","","","01883-765581","01883-765581","","","0","0","4/49,Level 4,Estern Plus,Santi Nagar ","","4/49,Level 4,Estern Plus,Santi Nagar ","18","","0","1","5","2023-05-19 07:47:30");
INSERT INTO tbl_customer VALUES("270","","ABA/CU/201","Shohel Vai ElephantRoad","","Shohel Vai","","","01683344982","01683344982","","","0","0","Elephant Rad","","Elephant Road","18","17","0","1","5","2023-05-22 05:47:39");
INSERT INTO tbl_customer VALUES("271","","ABA/CU/202","Dream Electronics Ltd","","Yousuf","","","01960403393","01960403393","","","0","0","3rd Floor,Subastu Arcade ICT Bhaban,Elephant Road","","3rd Floor,Subastu Arcade ICT Bhaban,Elephant Road","18","17","0","1","5","2023-05-25 06:28:07");
INSERT INTO tbl_customer VALUES("272","","ABA/CU/203","Arif Vai Jessor","","","","","01913989595","01913989595","","","0","0","Jessor","","","33","","0","1","5","2023-05-31 01:47:07");
INSERT INTO tbl_customer VALUES("273","","ABA/CU/204","Innovation Alert","","Saiful vai","","","01715258529","01715258529","","","0","0","Shop-01,Block-B,Level-5,Basundhara City Shopping Mall,Dhaka","","Shop-01,Block-B,Level-5,Basundhara City Shopping Mall,Dhaka","18","","0","1","5","2023-06-03 01:23:20");
INSERT INTO tbl_customer VALUES("274","","ABA/CU/205","Suzon IT","","Sujon","","","01673652181","","","","0","0","137,Level-2,IDB Bhaban","","137,Level-2,IDB Bhaban","18","1","0","1","5","2023-06-05 06:08:15");
INSERT INTO tbl_customer VALUES("275","","ABA/CU/206","Shakib Vai Mizan Trade","","Shakib Vai","","","01784580505","","","","0","0","1st Floor,Multiplan Centre ,","","","18","17","0","1","5","2023-06-05 07:10:45");
INSERT INTO tbl_customer VALUES("276","","ABA/CU/207","Power Solution  Jony","","Jony","","","01683573199","01683573199","","","0","0","4th floor,Subastu Arcade ICT Bhaban,","","4th floor,Subastu Arcade ICT Bhaban,","18","","0","1","5","2023-06-05 08:10:51");
INSERT INTO tbl_customer VALUES("277","","ABA/CU/208","Farazi Laptop Zone","","Samim ","","","01765732886","01765732886","","","0","0","Monipor school,60ft Road,Mirpur","","Monipor school,60ft Road,Mirpur","18","1","0","1","5","2023-06-12 07:49:27");
INSERT INTO tbl_customer VALUES("278","","ABA/CU/209","Win Technology","","MD ZoherulAlam Sujan","","","01912-242087","01912-242087","","","0","0","40,New Elephant Road,Dhaka","","40,New Elephant Road,Dhaka","18","17","0","1","5","2023-06-22 04:45:03");
INSERT INTO tbl_customer VALUES("279","","ABA/CU/210","Universe Amin Vai","","amin vai","","","01914500241","","","","0","0","suvastu 4th floor ","","","18","17","0","1","5","2023-06-23 07:12:59");
INSERT INTO tbl_customer VALUES("280","","ABA/CU/211","Cox Tech ","","Naimur Rahman","","","01626731952","01626731952","","","0","0","Cox Bazar","","Cox Bazar","12","","0","1","5","2023-07-06 07:46:13");
INSERT INTO tbl_customer VALUES("281","","ABA/CU/212","Two Star","","Rskib Vai","","","01706965655","01706965655","","","0","0","232,Subastu Aracde ICT Bhaban,Elephant Road","","232,Subastu Aracde ICT Bhaban,Elephant Road","18","17","0","1","5","2023-07-07 11:57:51");
INSERT INTO tbl_customer VALUES("282","","ABA/CU/213","OM Electronics Shop","","Proshad","","","01752080000","01752080000","","","0","0","Fulbari,Dinajpur","","Fulbari,Dinajpur","53","","0","1","5","2023-07-07 02:10:23");
INSERT INTO tbl_customer VALUES("284","","ABA/CU/214","JM Technology ","","MD Jane Alom","","","01794642761","01624503318","","","0","0","1st floor,Islamic Shopping Cpmplex Bus Station ,Eidgaoon,Cox's Bazar","","1st floor,Islamic Shopping Cpmplex Bus Station ,Eidgaoon,Cox's Bazar","12","","0","1","5","2023-07-07 04:36:40");
INSERT INTO tbl_customer VALUES("285","","ABA/CU/215","UAE Laptop","","Bahar Vai","","","01770-283681","01770-283681","","","0","0","Bandar,Sylhet","","Bandar,Sylhet","64","","0","1","5","2023-07-07 08:05:26");
INSERT INTO tbl_customer VALUES("286","","ABA/CU/216","Mitho Vai SR Percel","","mitho vai","","","01729983249","","","","0","0","sr percel elephant raod","","","","","0","1","5","2023-07-09 03:01:38");
INSERT INTO tbl_customer VALUES("287","","ABA/CU/217","AS International ","","forhad ","","","01624747495","","","","0","0","multiplan shop no 855","","","18","","0","1","5","2023-07-09 07:32:21");
INSERT INTO tbl_customer VALUES("288","","ABA/CU/218","Message Technology","","babu vai ","","","01814401440","","","","0","0","ICT bhaban shop 511 elephant road dhaka ","","","","","0","1","5","2023-07-10 01:02:10");
INSERT INTO tbl_customer VALUES("289","","ABA/CU/219","MR Gadget ","","ahasan habib","","","01813133889","01303062305","","","0","0","Rajshahi Molla market, binodpur  shop no 02","","","","","0","1","5","2023-07-10 10:48:44");
INSERT INTO tbl_customer VALUES("290","","ABA/CU/220","Al Amin Vai Badda","","al amin vai","","","01823433856","","","","0","0","badda alif nagar road no 11/175 ","","","","","0","1","5","2023-07-19 01:58:19");
INSERT INTO tbl_customer VALUES("291","","ABA/CU/221","Sumiya TECH","","","","","00821064294980","","","","0","0","elephant road ","","","","","0","1","5","2023-08-01 11:07:32");
INSERT INTO tbl_customer VALUES("292","","ABA/CU/222","Detect Technology Alpona Plaza","","salim vai","","","01816371757","","","","0","0","shop no 332 alpona plaza elephant road ","","","18","","0","1","5","2023-08-03 04:00:33");
INSERT INTO tbl_customer VALUES("293","","ABA/CU/223","Tanvir Computer (Gazipur)","","","","","01959799224","01739784834","","","0","0","Gazipur Singboard","","","","","0","1","5","2023-08-04 07:16:33");
INSERT INTO tbl_customer VALUES("294","","ABA/CU/224","Tusher TECH ","","tusher vai","","","01721212524","","","","0","0","chairman super market 2nd floor dupcachia bogra","","","","","0","1","5","2023-08-05 06:14:06");
INSERT INTO tbl_customer VALUES("295","","ABA/CU/225","MM Trading ","","momin vai","","","01712637454","","","","0","0","multiplan 10th floor ","","","","","0","1","5","2023-08-17 11:03:42");
INSERT INTO tbl_customer VALUES("296","","ABA/CU/226","Nazmul Vai Barishal","","Nazmul Vai","","","01712785192","01712785192","","","0","0","Barishal ","","Barishal","2","","0","1","5","2023-08-17 04:19:28");
INSERT INTO tbl_customer VALUES("297","","ABA/CU/227","Sheikh Computer ","","Ariful Islam","","","01714846688","01714846688","","","0","0","Upazila Road,Kashiani,Gopalgang","","Upazila Road,Kashiani,Gopalgang","21","","0","1","5","2023-08-19 04:25:48");
INSERT INTO tbl_customer VALUES("298","","ABA/CU/228","BM Computer Mirpur","","Shohan Vai","","","01712943028","01712943028","","","0","0","Dewon Market,Mirpur 10","","Dewon Market,Mirpur 10","18","1","0","1","5","2023-08-21 04:46:48");
INSERT INTO tbl_customer VALUES("299","","ABA/CU/229","Lyric Computer","","rana vai ","","","01676846332","","","","0","0","suvastu nazar valley ","","","","","0","1","5","2023-08-23 03:30:24");
INSERT INTO tbl_customer VALUES("300","","ABA/CU/230","Laptop World Comilla","","sunny vai","","","01736534564","","","","0","0","shop no 506 3rd floor khandakar hoque tower kandirpar cumilla ","","","11","","0","1","5","2023-08-23 07:55:57");
INSERT INTO tbl_customer VALUES("301","","ABA/CU/231","Akhanda Electronics","","Anik Das","","","01751512127","01751512127","","","0","0","Madabpur,Habigang","","Madabpur,Habigang","64","","0","1","5","2023-08-25 12:14:09");
INSERT INTO tbl_customer VALUES("302","","ABA/CU/232","Exclusive IT Solution","","zakir vai ","","","01794636629","","","","0","0","tongi gazipur wasek mia super market shop no 07","","","","","0","1","5","2023-08-27 02:11:57");
INSERT INTO tbl_customer VALUES("303","","ABA/CU/233","TUHIN","","","","","01912813238","01612813238","","","0","0","21/D NORTH MADARTEK","","","","","0","1","5","2023-10-04 01:01:58");
INSERT INTO tbl_customer VALUES("304","","ABA/CU/234","The Computer Zone Zahid","","Zahid","","","01742117434","","","","0","0","motijil gawsaypac 229 ","","","","","0","1","5","2023-10-14 02:50:05");
INSERT INTO tbl_customer VALUES("305","","ABA/CU/235","Real Tech Computer ","","asraf vai","","","01684134574","01518478373","","","0","0","maymansing ","","","","","0","1","5","2023-10-19 04:30:29");
INSERT INTO tbl_customer VALUES("306","","ABA/CU/236","JUBO Computer","","amarul hossen","","","01778707218","","","","0","0","gause pak bhaban computer shop no 90","","","","","0","1","5","2023-10-19 04:51:26");
INSERT INTO tbl_customer VALUES("307","","ABA/CU/237","Alamgir Vai Dibos Dada","","alamgir vai","","","01736724369","","","","0","0","thakurgaon ","","","","","0","1","5","2023-10-21 05:21:23");
INSERT INTO tbl_customer VALUES("308","","ABA/CU/238","Codeware LTD","","Zaman vai ","","","01717835053","","","","0","0","house 629-685 road 12 adabor mohammadpur ","","","","","0","1","5","2023-11-01 03:21:59");
INSERT INTO tbl_customer VALUES("309","","ABA/CU/239","TECH Village Uttara","","mehedi vai","","","01619149549","","","","0","0","sector 7 sayed grand centre uttara ","","","","","0","1","5","2023-11-15 04:26:46");
INSERT INTO tbl_customer VALUES("310","","ABA/CU/240","Triple A Technology ","","Rony","","","01812000600","01812000600","","","0","0","415,Floor-4,Multiplan Centre.Elephan Road","","415,Floor-4,Multiplan Centre.Elephan Road","18","17","0","1","5","2023-11-19 03:49:20");
INSERT INTO tbl_customer VALUES("311","","ABA/CU/241","3M HITECH ","","MD Yeasin Islam","","","01820953200","01820953200","","","0","0","Shop-50,5th floor,Shah Ali Plaza,Mirpur 10","","Shop-50,5th floor,Shah Ali Plaza,Mirpur 10","18","1","0","1","5","2023-11-27 06:53:54");
INSERT INTO tbl_customer VALUES("312","","ABA/CU/242","Zahir Vai Aroggo","","","","","01896037437","","","","0","0","mirpur ","","","","","0","1","5","2023-12-04 01:10:50");
INSERT INTO tbl_customer VALUES("313","","ABA/CU/243","Shahadat Vai Astrum Tech.","","Shahadat vai","","","01716577923","01401116953","","","0","0","218/c level -2 New Elephant Rd.","","","","","0","1","5","2023-12-13 05:20:29");
INSERT INTO tbl_customer VALUES("314","","ABA/CU/244","Computer Velly","","tariqul vai","","","01711323723","","","","0","0","IDB ","","","","","0","1","5","2024-01-29 08:00:06");
INSERT INTO tbl_customer VALUES("315","","ABA/CU/245","Salim Telecom Jhinidah","","01945233486","","","01945233486","","","","0","0","Horina kundo Jhinaidah","","","","","0","1","5","2024-02-08 03:13:01");
INSERT INTO tbl_customer VALUES("316","","ABA/CU/246","Denco Computer ","","khalilur rahman","","","01970341581","","","","0","0","135 sent peter market sadar road barisal ","","","2","","0","1","5","2024-02-18 02:34:02");
INSERT INTO tbl_customer VALUES("317","","ABA/CU/247","Star Networking Solution","","awal vai","","","01713069178","","","","0","0","lilyrin tower house no 39/1 road no 2 dhanmondi","","","18","","0","1","5","2024-02-19 02:57:53");
INSERT INTO tbl_customer VALUES("318","","ABA/CU/248","CBS Corporation","","parvej vai","","","01733185163","","","","0","0","suvastu archid ICT Bhaban 8th floor shop number 832/843","","","18","","0","1","5","2024-02-24 05:24:00");
INSERT INTO tbl_customer VALUES("319","","ABA/CU/249","Gadget Mart BD Shohag","","shohag","","","01966762875","","","","0","0","multiplan centre shop no 160","","","18","","0","1","5","2024-03-10 12:32:57");
INSERT INTO tbl_customer VALUES("320","","ABA/CU/250","IBM Computer ","","harun vai ","","","01747737174","","","","0","0","maymansing ","","","","","0","1","5","2024-03-10 07:56:02");
INSERT INTO tbl_customer VALUES("321","","ABA/CU/251","Great Way Ferdous Vai","","ferdous vai","","","01721551805","","","","0","0","IDB Bhaban shop number 19 dhaka bangladesh","","","","","0","1","5","2024-03-17 12:19:20");
INSERT INTO tbl_customer VALUES("322","","ABA/CU/252","HR Computer Fair","","hridoy and opu vai","","","01790564925","","","","0","0","suvastu archid ICT Bhaban","","","","","0","1","5","2024-03-20 05:46:05");
INSERT INTO tbl_customer VALUES("323","","ABA/CU/253","Digital Computer Furkan Vai","","furkan vai","","","01609394847","","","","0","0","suvastu archid ICT bhaban shop no 22","","","","","0","1","5","2024-03-23 07:54:30");
INSERT INTO tbl_customer VALUES("324","","ABA/CU/254","Gadget BD 71","","masud vai","","","01711070922","","","","0","0","mirpur fol potti","","","18","1","0","1","5","2024-03-30 03:01:34");
INSERT INTO tbl_customer VALUES("325","","ABA/CU/255","Zeta Byte Alomgir","","Alomgir Vai","","","01977784777","","","","0","0","434,4th floor,Subastu Arcade ICT Bhaban","","434,4th floor,Subastu Arcade ICT Bhaban","","","0","1","5","2024-04-02 11:54:41");
INSERT INTO tbl_customer VALUES("326","","ABA/CU/256","Panaroma Computer","","Panna vai","","","01708452801","01708452801","","","0","0","Multiplan Center 236-237. 69-71 New elephant rd.","","","18","4","0","1","5","2024-04-03 03:46:36");
INSERT INTO tbl_customer VALUES("327","","ABA/CU/257","Alamin Al Modina ","","alamin fotka","","","01641424003","","","","0","0","uttara mahfuz vai","","","","","0","1","5","2024-04-03 05:12:10");
INSERT INTO tbl_customer VALUES("328","","ABA/CU/258","Trusted Laptop Source ","","MD. Ramjan Ali","","","01767277767","","","","0","0","thakurgon sadar","","","","","0","1","5","2024-04-04 02:43:22");
INSERT INTO tbl_customer VALUES("329","","ABA/CU/259","Faith Technology","","rubel","","","01305252019","","","","0","0","suvastu archid ICT Bhaban shop no 231","","","","","0","1","5","2024-04-05 03:30:25");
INSERT INTO tbl_customer VALUES("330","","ABA/CU/260","Dignity Computer (Samir Da)","","Samir da","","","01752721250","","","","0","0","866 Multiplan","","","18","17","0","1","5","2024-04-17 07:48:43");
INSERT INTO tbl_customer VALUES("331","","ABA/CU/261","Dream Touch Computer","",".","","","01719-261168","","","","0","0","Satkhira","","","40","","0","1","5","2024-04-25 06:17:19");
INSERT INTO tbl_customer VALUES("332","","ABA/CU/262","SN Computer ","","Rana vai","","","01815765452","","","","0","0","6th floor,Subastu Arcade ICT Bhaban,Elephant Road,","","","18","17","0","1","5","2024-04-25 06:35:20");
INSERT INTO tbl_customer VALUES("333","","ABA/CU/263","Planet IT BD","","Md Emran Hossain","","","01797345730","01889140127","","","0","0","MA Amena Plaza Mirpur 10","","","18","1","0","1","5","2024-04-27 12:23:43");
INSERT INTO tbl_customer VALUES("334","","ABA/CU/264","J. R.Shaikat","","","","","01793466420","","","","0","0","I C T Bhaban L-6","","","","","0","1","5","2024-04-29 06:59:56");
INSERT INTO tbl_customer VALUES("335","","ABA/CU/265","Succes Computer ","","dulal vai","","","01678570853","","","","0","0","gawsaypac motijil dhaka","","","","","0","1","5","2024-05-02 01:11:16");
INSERT INTO tbl_customer VALUES("336","","ABA/CU/266","Tafsir Computer","","Sohel vai","","","01716123357","","","","0","0","Kushtia","","","","","0","1","5","2024-05-10 02:46:25");
INSERT INTO tbl_customer VALUES("337","","ABA/CU/267","TM Solution BD","","Tusar Vai","","","01916095096","","","","0","0","853,Subastu Arcade ICT Bhaban,Elephant Road,","","","18","17","0","1","5","2024-05-13 05:47:39");
INSERT INTO tbl_customer VALUES("338","","ABA/CU/268","Oliur Tech ","","oliur rahman","","","01827104825","","","","0","0","kodomtoli abdullah  keranigong dhaka 1310","","","","","0","1","5","2024-05-17 06:48:19");
INSERT INTO tbl_customer VALUES("339","","ABA/CU/269","Mehedul IT","","mehedul vai","","","01615347350","","","","0","0","65/6 eastern mollike dhaka ","","","","","0","1","5","2024-05-20 01:17:23");
INSERT INTO tbl_customer VALUES("340","","ABA/CU/270","Laptop Kingdom","","shoel vai","","","01774045540","","","","0","0","alpona plaza 205A and 205B","","","18","","0","1","5","2024-05-20 01:55:23");
INSERT INTO tbl_customer VALUES("341","","ABA/CU/271","AH Computer Solution","","Naim","","","01819806481","","","","0","0","Multiplan","","","","","0","1","5","2024-05-24 07:37:45");
INSERT INTO tbl_customer VALUES("342","","ABA/CU/272","Nexus IT Barishal","","Shohidul Vai","","","01755222000","","","","0","0","Barishal","","","2","","0","1","5","2024-05-26 07:01:11");
INSERT INTO tbl_customer VALUES("343","","ABA/CU/273","Mother IT Solution ","","hasan vai ","","","01724456163","","","","0","0","multiplan centre 10th floor 1059","","","","","0","1","5","2024-05-29 12:18:38");
INSERT INTO tbl_customer VALUES("344","","ABA/CU/274","One Stop Solution TECH","","rezwanul haque ","","","01722885858","","","","0","0","tower 71house 516/3 level 6 ECB dhaka cantorment ","","","","","0","1","5","2024-05-29 04:20:35");
INSERT INTO tbl_customer VALUES("345","","ABA/CU/275","MS Mahian INT","","ENG saiful vai ","","","01911676321","","","","0","0","motijil gawsaypac 2nd floor shop 184","","","","","0","1","5","2024-06-05 03:32:34");
INSERT INTO tbl_customer VALUES("346","","ABA/CU/276","Global TECH HUB BD","","Azim ","","","01783512241","","","","0","0","alpona plaza 2nd floor 243","","","","","0","1","5","2024-06-05 05:37:26");
INSERT INTO tbl_customer VALUES("347","","ABA/CU/277","Enter Computers ","","Mosiur Rahman","","","01789-443043","01684134574","","","0","0","Ram Babu Road,Sadar,Mymensingh","","","42","","0","1","5","2024-06-07 05:50:17");
INSERT INTO tbl_customer VALUES("348","","ABA/CU/278","Present TECH ","","ashraful islam","","","01816237770","","","","0","0","shop no G-13 Sheltech sierra new elephant road","","","","","0","1","5","2024-06-12 06:37:50");
INSERT INTO tbl_customer VALUES("349","","ABA/CU/279","Yasin Vai Uttara ","","yasin vai","","","01914458070","","","","0","0","gudara gat badda link road 63/3 ","","","","","0","1","5","2024-06-13 03:36:46");
INSERT INTO tbl_customer VALUES("350","","ABA/CU/280","Laptop Gadget BC","","Hossain vai ","","","01975155506","","","","0","0","basundhara city block D Shop 89","","","","","0","1","5","2024-06-22 05:32:48");
INSERT INTO tbl_customer VALUES("351","","ABA/CU/281","Zahid Modina Uttara","","zahid ","","","01641368969","","","","0","0","uttara dhaka ","","","","","0","1","5","2024-06-26 02:06:25");
INSERT INTO tbl_customer VALUES("352","","ABA/CU/282","Google Tech","","Sam Vai","","","01718219220","","","","0","0","M.N Plaza,Mordern More,Dinajpur","","","53","","0","1","5","2024-06-28 07:34:38");
INSERT INTO tbl_customer VALUES("353","","ABA/CU/283","Run TECH Computer","","anupam gain","","","01729191920","","","","0","0","new market laboni tower satkhira ","","","","","0","1","5","2024-06-30 03:05:54");
INSERT INTO tbl_customer VALUES("354","","ABA/CU/284","All In One Computer","","MD Masud ","","","01842858841","","","","0","0","nur super market 2nd floor Golden tower ","","","","","0","1","5","2024-07-03 02:40:31");
INSERT INTO tbl_customer VALUES("355","","ABA/CU/285","Enterprise 360 Monir Vai","","monir vai","","","01767695514","","","","0","0","elephant road ","","","","","0","1","5","2024-07-04 07:56:30");
INSERT INTO tbl_customer VALUES("356","","ABA/CU/286","Raj Laptop Gallary","","","","","01748261551","","","","0","0","Bashundhara","","","","","0","1","5","2024-07-05 04:40:47");
INSERT INTO tbl_customer VALUES("357","","ABA/CU/287","E Com ","","ibrahim ","","","01922565358","","","","0","0","multiplane centre 1004","","","","","0","1","5","2024-07-07 12:25:36");
INSERT INTO tbl_customer VALUES("359","","ABA/CU/288","Brothers Computer System","","Mofajjal","","","01724471843","","","","0","0","Barishal","","","","","0","1","5","2024-07-07 08:55:06");
INSERT INTO tbl_customer VALUES("360","","ABA/CU/289","Brothers Computer System Barishal","","","","","01724471843...","","","","0","0","Barishal","","","","","0","1","5","2024-07-07 08:57:32");
INSERT INTO tbl_customer VALUES("361","","ABA/CU/290","NEX ERP","","Monir vai ","","","01919111444","","","","0","0","H-752 L5 Road 10 avenue -4 mirpur DOHS Dhaka 1216","","","","","0","1","5","2024-08-01 01:46:45");
INSERT INTO tbl_customer VALUES("362","","ABA/CU/291","Ankur Computer Tayab","","Tayab","","","01919575496","","","","0","0","Subartu Level 2","","","","","0","1","5","2024-08-02 05:56:14");
INSERT INTO tbl_customer VALUES("363","","ABA/CU/292","Sneha Computer","","","","","01820889234","","","","0","0","Subastu Archade Level 7 (727)","","","","","0","1","5","2024-08-10 06:36:35");
INSERT INTO tbl_customer VALUES("364","","ABA/CU/293","A. Alim Vai (comp Tech)","","","","","01937575499","01973575499","","","0","0","18 Baitun Noor Shopping center New Market Khulna","","","","","0","1","5","2024-08-17 02:15:47");
INSERT INTO tbl_customer VALUES("365","","ABA/CU/294","Quality Fast Rony Vai","","rony vai","","","01911754462","","","","0","0","suvastu archid 5th floor","","","","","0","1","5","2024-08-23 07:48:09");
INSERT INTO tbl_customer VALUES("366","","ABA/CU/295","Rocky Vai Rangpur","","rocky vai","","","01785278773","","","","0","0","rangpur ","","","","","0","1","5","2024-08-25 07:11:59");
INSERT INTO tbl_customer VALUES("367","","ABA/CU/296","Tamim Computer &amp; Servic","","","","","01914818146","","","","0","0","Lily Archad","","","","","0","1","5","2024-08-28 04:02:27");
INSERT INTO tbl_customer VALUES("368","","ABA/CU/297","Right Technologies","","Md. Mizanur Khan","","","01674850160","01914272126","","","0","0","Suvastu Arcad 112","","","","","0","1","5","2024-08-30 11:39:04");
INSERT INTO tbl_customer VALUES("369","","ABA/CU/298","Apon Vai","","","","","01796883638","","","","0","0","165 new Elephant Rd.","","","","","0","1","5","2024-09-01 07:31:15");
INSERT INTO tbl_customer VALUES("371","","ABA/CU/300","Genius IT Lab","","aminul islam","","","01717031497","","","","0","0","ICT Bhaban suvastu archid shop no 218,19","","","","","0","1","5","2024-09-02 07:38:38");
INSERT INTO tbl_customer VALUES("372","","ABA/CU/301","SN Computer Shaker Vai","","Shaker vai","","","01671439245","","","","0","0","Sha Ali Market Mirpur","","","","","0","1","5","2024-09-04 08:28:34");
INSERT INTO tbl_customer VALUES("373","","ABA/CU/302","Hasan Vai MPC 10","","","","","01","","","","0","0","Multiplan Level 10Shop  1059","","","","","0","1","5","2024-09-05 10:45:55");
INSERT INTO tbl_customer VALUES("374","","ABA/CU/303","Source Edge IDB","","Shuvroto dada","","","01780053693","","","","0","0","IDB Bhabhan","","","","","0","1","5","2024-09-09 07:54:04");
INSERT INTO tbl_customer VALUES("375","","ABA/CU/304","Kabir Vai E Soft","","zisan vai ","","","01913208040.","","","","0","0","multiplan centre 1st floor","","","","","0","1","5","2024-09-12 01:38:14");
INSERT INTO tbl_customer VALUES("376","","ABA/CU/305","Silicon Tech","","Jewel Ahmed","","","01756422701","","","","0","0","Multiplan 330","","","","","0","1","5","2024-09-14 08:12:13");
INSERT INTO tbl_customer VALUES("377","","ABA/CU/306","Keya IT","","Subastu Archade","","","01......","","","","0","0","Subastu Market","","","","","0","1","5","2024-09-16 07:16:56");
INSERT INTO tbl_customer VALUES("378","","ABA/CU/307","B-3 Group Rangpur","","humayon vai ","","","01746312376","","","","0","0","samabay bank shopping complex rangpur","","","","","0","1","5","2024-09-20 08:10:30");
INSERT INTO tbl_customer VALUES("379","","ABA/CU/308","SAAD IT SOLUTION","","Md. Azizur Rahman","","","01325886565","01841457675","","","0","0","ja 173/1 Matrichaya , T&amp;T School Road","","","","","0","1","5","2024-09-26 05:43:58");



CREATE TABLE `tbl_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `apdate` datetime NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_expensesde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `expid` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `name` varchar(65) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `prid` int(11) DEFAULT NULL,
  `catid` int(11) DEFAULT NULL,
  `scatid` int(11) DEFAULT NULL,
  `brid` int(11) DEFAULT NULL,
  `manid` int(11) DEFAULT NULL,
  `unid` int(11) DEFAULT NULL,
  `couid` int(11) DEFAULT NULL,
  `minstock` double NOT NULL DEFAULT 0,
  `barcode` varchar(25) DEFAULT NULL,
  `certificate` varchar(150) DEFAULT NULL,
  `modelno` varchar(25) DEFAULT NULL,
  `brandno` varchar(25) DEFAULT NULL,
  `image` varchar(50) DEFAULT NULL,
  `cost` decimal(12,2) NOT NULL DEFAULT 0.00,
  `price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `wday` double NOT NULL DEFAULT 0,
  `pmod` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_item VALUES("1","ABA001P","840 G3 I5 6th 256/8 GB","HP 840 G3 Non Touch","256/8","1","5","1","1","","1","12","0","","","HP Elite book 840 ","","","0.00","0.00","0","1","1","5","2022-02-01 05:50:05");
INSERT INTO tbl_item VALUES("2","ABA002P","840 G3 Touch Screen I5 6th 256/8 GB","HP 840 G3 Touch","256/8","1","5","1","1","","1","11","0","","","HP 840 G3 touch","","","0.00","0.00","0","1","1","5","2022-02-01 05:52:21");
INSERT INTO tbl_item VALUES("3","ABA003P","DELL LAPTOP 7390 CORE I5 8TH GEN DELL Latitude 7390 Touch 360","DELL Latitude 7390 Touch 360","","1","5","3","2","","1","11","0","","","7390","","","0.00","0.00","0","1","1","5","2022-02-01 05:54:08");
INSERT INTO tbl_item VALUES("4","ABA004P","LENOVO LAPTOP T440s  CORE I7 4TH GEN Lenovo T440s Core I7 Touch","Lenovo T440s Core I7 Touch","HDD 500 RAM 4GB display 14 ins touch","1","3","8","3","","1","11","0","","","T440s ","","","0.00","0.00","0","1","1","5","2022-02-01 05:56:18");
INSERT INTO tbl_item VALUES("5","ABA005P","LENOVO LAPTOP T440s CORE I5 4TH GEN T440s Non Touch I5 HDD 500 RA","T440s Non Touch I5 HDD 500 RAM 4 GB ","","1","5","8","3","","1","11","0","","","T440s","","","0.00","0.00","0","1","1","5","2022-02-01 05:57:46");
INSERT INTO tbl_item VALUES("6","ABA006P","HP LAPTOP  CORE I5 7TH GEN HP Elite Book 1030 Touch 360 SSD 256 R","HP Elite Book 1030 Touch 360 SSD 256 RAM 8 GB","","1","5","2","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-02-01 05:59:31");
INSERT INTO tbl_item VALUES("7","ABA007P","DELL LAPTOP  CORE I5 7TH GEN DELL Latitude E 7480 Touch SSD 256 R","DELL Latitude E 7480 Touch SSD 256 RAM 8 GB ","","1","5","2","2","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-02-01 06:02:56");
INSERT INTO tbl_item VALUES("8","ABA008P","840 G4 I5 256/8 GB","840 G4 Non Touch SSD 256 RAM 8 GB ","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-02-01 06:06:12");
INSERT INTO tbl_item VALUES("12","ABA012P","HP LAPTOP  CORE I7 8TH  830 G5  256/ 8 GB","Elite Book 830 G5 SSD 256 RAM 8 GB","","1","3","","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-08 06:16:58");
INSERT INTO tbl_item VALUES("13","ABA013P","HP 850 G3 Touch Screen SSD 256 RAM 8 GB ","HP Elite Book 850 G3 SSD 256 RAM 8 GB ","","1","5","1","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-08 06:19:11");
INSERT INTO tbl_item VALUES("14","ABA014P","745 A10 HDD 500 RAM 4 GB","HP Elitebook 745 AMD A 10 HDD 500 RAM 4 GB","","1","31","16","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-08 06:21:51");
INSERT INTO tbl_item VALUES("15","ABA015P","LENOVO LAPTOP  CORE I5 7TH GEN X1 Carbon 256 And 8 GB","X1 Carbon 256 And 8 GB","","1","5","2","3","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-03-20 02:51:11");
INSERT INTO tbl_item VALUES("16","ABA016P","Latitude 3330 HDD 500 RAM 4","Latitude 3330 HDD 500 RAM 4","","1","5","9","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:21:38");
INSERT INTO tbl_item VALUES("17","ABA017P","HP LAPTOP  CORE I5 3RD GEN Latitude 3360 HDD 500 RAM 4 ","Latitude 3360 HDD 500 RAM 4 ","","1","5","9","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:22:33");
INSERT INTO tbl_item VALUES("18","ABA018P","DELL LAPTOP  CORE I5 5TH GEN Latitude 7450 HDD 500 RAM 4 ","Latitude 7450 HDD 500 RAM 4 ","","1","5","7","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:24:40");
INSERT INTO tbl_item VALUES("19","ABA019P","DELL LAPTOP  CORE I5 6TH GEN 7470 Touch 256 &amp; 8 ","7470 Touch 256 &amp; 8 ","","1","5","1","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:25:51");
INSERT INTO tbl_item VALUES("20","ABA020P","DELL LAPTOP  CORE I5 6TH GEN Inspiron 5459 HDD 500 RAM 4 ","Inspiron 5459 HDD 500 RAM 4 ","","1","5","1","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:27:01");
INSERT INTO tbl_item VALUES("21","ABA021P","DELL LAPTOP  CORE I5 6TH GEN 7470 Non Touch 256 &amp; 8 ","7470 Non Touch 256 &amp; 8 ","","1","5","1","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:27:59");
INSERT INTO tbl_item VALUES("22","ABA022P","DELL LAPTOP  CORE I5 7TH GEN 7480 Touch 256 &amp; 8 GB","7480 Touch 256 &amp; 8 GB","","1","5","2","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:29:43");
INSERT INTO tbl_item VALUES("23","ABA023P","DELL LAPTOP  CORE I5 7TH GEN 7480 Non Touch 256 &amp; 8 GB","7480 Non Touch 256 &amp; 8 GB","","1","5","2","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:30:26");
INSERT INTO tbl_item VALUES("24","ABA024P","DELL LAPTOP  CORE I5 8TH GEN Latitude 7390 SSD 256 RAM 16","Latitude 7390 SSD 256 RAM 16","","1","5","3","2","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:31:26");
INSERT INTO tbl_item VALUES("25","ABA025P","FUJITSU LAPTOP  CORE I5 3RD GEN U772/G HDD 500 RAM 4 ","U772/G HDD 500 RAM 4 ","","1","5","9","7","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:36:44");
INSERT INTO tbl_item VALUES("26","ABA026P","AMD 745 A 10 HDD 500 RAM 4 GB","745 AMD A10 HDD 500 RAM 4 GB","","1","31","16","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:39:20");
INSERT INTO tbl_item VALUES("27","ABA027P","HP LAPTOP  AMD A8 6TH GEN AMD A8 HDD 500 RAM 4 ","AMD A8 HDD 500 RAM 4 ","","1","32","1","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:40:48");
INSERT INTO tbl_item VALUES("28","ABA028P","HP LAPTOP  CORE I3 4TH GEN Probook 430 HDD 500 RAM 4 ","Probook 430 HDD 500 RAM 4 ","","1","2","8","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:41:48");
INSERT INTO tbl_item VALUES("29","ABA029P","HP LAPTOP  CORE I3 4TH GEN Probook 440 HDD 500 RAM 4 ","Probook 440 HDD 500 RAM 4 ","","1","2","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:42:23");
INSERT INTO tbl_item VALUES("30","ABA030P","HP LAPTOP  CORE I5 3RD GEN 8470p HDD 500 RAM 4","8470p HDD 500 RAM 4","","1","5","9","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:43:19");
INSERT INTO tbl_item VALUES("31","ABA031P","HP LAPTOP  CORE I5 4TH GEN Folio 1040 G1 SSD 256 RAM 4 GB","Folio 1040 G1 SSD 256 RAM 4 GB","","1","5","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:44:16");
INSERT INTO tbl_item VALUES("32","ABA032P","HP LAPTOP  CORE I5 6TH GEN 820 G3 256 &amp; 8 GB Touch","820 G3 256 &amp; 8 GB Touch","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:45:00");
INSERT INTO tbl_item VALUES("33","ABA033P","HP LAPTOP  CORE I5 6TH GEN 820 G3 256 &amp; 8 GB Non Touch","820 G3 256 &amp; 8 GB Non Touch","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:45:34");
INSERT INTO tbl_item VALUES("34","ABA034P","HP LAPTOP  CORE I5 6TH GEN 1040 Touch 2k 256 &amp; 8 GB ","1040 Touch 2k 256 &amp; 8 GB ","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:46:07");
INSERT INTO tbl_item VALUES("35","ABA035P","HP LAPTOP  CORE I5 6TH GEN 850 G3 256 &amp; 8 GB ","850 G3 256 &amp; 8 GB ","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:47:15");
INSERT INTO tbl_item VALUES("36","ABA036P","HP LAPTOP  CORE I5 6TH GEN 640 G2 SSD 256 RAM 8 GB","640 G2 SSD 256 RAM 8 GB","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:47:54");
INSERT INTO tbl_item VALUES("37","ABA037P","HP Core I7 7th Generation 1030 G3 512 &amp; 16 GB","1030 G2 512 &amp; 8 GB","","1","3","24","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:48:39");
INSERT INTO tbl_item VALUES("38","ABA038P","840 G4 Core I5  256 &amp; 8 GB ","840 G4 256 &amp; 8 GB Non Touch ","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:49:15");
INSERT INTO tbl_item VALUES("39","ABA039P","840 G4 Touch 256 &amp; 8 GB","840 G4 Touch 256 &amp; 8 GB","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:49:45");
INSERT INTO tbl_item VALUES("40","ABA040P","HP LAPTOP  CORE I7 5TH GEN 810 Revolve 256 &amp; 8 GB","810 Revolve 256 &amp; 8 GB","","1","3","7","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:50:36");
INSERT INTO tbl_item VALUES("41","ABA041P","HP LAPTOP  CORE I7 6TH GEN 650 SSD 256 RAM 8 GB","650 SSD 256 RAM 8 GB","","1","3","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:51:19");
INSERT INTO tbl_item VALUES("42","ABA042P","HP LAPTOP  CORE M5 7TH GEN Elite X2 SSD 256 RAM 8 ","Elite X2 SSD 256 RAM 8 ","","1","17","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:52:11");
INSERT INTO tbl_item VALUES("43","ABA043P","MICROSOFT LAPTOP  CORE I7 10TH GEN Surface Laptop 3 SSD 512 RAM 1","Surface Laptop 3 SSD 512 RAM 16","","1","3","5","16","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:53:40");
INSERT INTO tbl_item VALUES("44","ABA044P","LENOVO LAPTOP  CORE I5 2ND GEN X220 HDD 500 RAM 4 ","X220 HDD 500 RAM 4 ","","1","5","10","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:56:08");
INSERT INTO tbl_item VALUES("45","ABA045P","X230 HDD 500 RAM 4 GB ","X230 HDD 500 RAM 4 GB","","1","5","9","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:56:33");
INSERT INTO tbl_item VALUES("46","ABA046P","LENOVO LAPTOP  CORE I5 4TH GEN T440s HDD 500 RAM 4 GB","T440s HDD 500 RAM 4 GB","","1","5","8","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:57:19");
INSERT INTO tbl_item VALUES("47","ABA047P","LENOVO LAPTOP  CORE I7 4TH GEN T440s Touch HDD 500 RAM 4 GB","T440s Touch HDD 500 RAM 4 GB","","1","3","8","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:57:56");
INSERT INTO tbl_item VALUES("48","ABA048P","LENOVO LAPTOP  CORE I5 4TH GEN X240 HDD 500 RAM 4 GB","X240 HDD 500 RAM 4 GB","","1","5","8","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:58:28");
INSERT INTO tbl_item VALUES("49","ABA049P","LENOVO LAPTOP  CORE I5 5TH GEN T450s HDD 500 RAM 4","T450s HDD 500 RAM 4","","1","5","7","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:58:59");
INSERT INTO tbl_item VALUES("50","ABA050P","X250 HDD 500 RAM 4 GB","X250 HDD 500 RAM 4 GB","","1","5","","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 07:59:31");
INSERT INTO tbl_item VALUES("51","ABA051P","LENOVO LAPTOP  CORE I5 6TH GEN Thinkpad 13 SSD 256 RAM 8 ","Thinkpad 13 SSD 256 RAM 8 ","","1","5","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:00:19");
INSERT INTO tbl_item VALUES("52","ABA052P","LENOVO LAPTOP  CORE I5 6TH GEN T460s 256 &amp; 8","T460s 256 &amp; 8","","1","5","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:00:50");
INSERT INTO tbl_item VALUES("53","ABA053P","LENOVO LAPTOP  CORE I5 7TH GEN T470 SSD 256 RAM 8","T470 SSD 256 RAM 8","","1","5","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:01:25");
INSERT INTO tbl_item VALUES("54","ABA054P","LENOVO LAPTOP  CORE I5 6TH GEN YOGA 260 SSD 256 RAM 8","YOGA 260 SSD 256 RAM 8","","1","5","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:01:55");
INSERT INTO tbl_item VALUES("55","ABA055P","LENOVO LAPTOP  CORE I5 6TH GEN YOGA 460 SSD 256 RAM 8","YOGA 460 SSD 256 RAM 8","","1","5","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:02:27");
INSERT INTO tbl_item VALUES("56","ABA056P","LENOVO LAPTOP  CORE I5 7TH GEN X1 Carbon 256 &amp; 8 ","X1 Carbon 256 &amp; 8 ","","1","5","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:03:18");
INSERT INTO tbl_item VALUES("57","ABA057P","LENOVO LAPTOP  CORE I5 7TH GEN Thinkpad E 470 SSD 256 &amp; 8","Thinkpad E 470 SSD 256 &amp; 8","","1","5","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:04:00");
INSERT INTO tbl_item VALUES("58","ABA058P","LENOVO LAPTOP  CORE I5 7TH GEN X1 Tablet 256 &amp; 8 ","X1 Tablet 256 &amp; 8 ","","1","5","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:05:10");
INSERT INTO tbl_item VALUES("59","ABA059P","LENOVO LAPTOP  CORE I7 3RD GEN X1 Carbon 256 &amp; 8","X1 Carbon 256 &amp; 8","","1","3","9","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:07:48");
INSERT INTO tbl_item VALUES("60","ABA060P","LENOVO LAPTOP  CORE I7 5TH GEN X1 Carbon 256 &amp; 8","X1 Carbon 256 &amp; 8","","1","3","7","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:11:09");
INSERT INTO tbl_item VALUES("61","ABA061P","ACER Core I3 HDD 500 RAM 4 GB ","Travelmate P245-M HDD 500 RAM 4 GB ","","1","2","19","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-24 08:14:50");
INSERT INTO tbl_item VALUES("62","ABA062P","HP CHARGER    Hp Blue Pin","Hp Blue Pin","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-03-24 08:16:51");
INSERT INTO tbl_item VALUES("63","ABA063P","HP LAPTOP  CORE I7 3RD GEN 8470p HDD 500 RAM 4","8470p HDD 500 RAM 4","","1","3","9","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 12:11:20");
INSERT INTO tbl_item VALUES("64","ABA064P","HP LAPTOP  CORE I5 2ND GEN 8460p HDD 500 RAM 4 ","8460p HDD 500 RAM 4 ","","1","5","10","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 12:12:13");
INSERT INTO tbl_item VALUES("65","ABA065P","APPLE LAPTOP  M1 11TH GEN M1 2021 SSD 512 RAM 16","M1 2021 SSD 512 RAM 16","","1","33","6","6","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 12:18:34");
INSERT INTO tbl_item VALUES("66","ABA066P","DELL LAPTOP  CORE I7 6TH GEN 7480 Non Touch 256 &amp; 8 GB","7480 Non Touch 256 &amp; 8 GB","","1","3","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 01:21:23");
INSERT INTO tbl_item VALUES("67","ABA067P","LENOVO LAPTOP  CORE I5 3RD GEN X1 Carbon 256 &amp; 8","X1 Carbon 256 &amp; 8","","1","5","9","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 02:16:06");
INSERT INTO tbl_item VALUES("68","ABA068P","LENOVO LAPTOP  CORE I5 6TH GEN T470 SSD 256 RAM 8","T470 SSD 256 RAM 8","","1","5","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 02:31:22");
INSERT INTO tbl_item VALUES("69","ABA069P","LENOVO LAPTOP  CORE I5 7TH GEN E470 SSD 256 RAM 8 GB","E470 SSD 256 RAM 8 GB","","1","5","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 02:38:37");
INSERT INTO tbl_item VALUES("70","ABA070P","ASUS LAPTOP  CORE I5 7TH GEN UX430Q SSD 256 RAM 8 GB","UX430Q SSD 256 RAM 8 GB","","1","5","2","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 02:46:36");
INSERT INTO tbl_item VALUES("71","ABA071P","HP LAPTOP  CORE I5 8TH GEN ENVY X360 SSD 256 RAM 20 GB","ENVY X360 SSD 256 RAM 20 GB","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 02:48:18");
INSERT INTO tbl_item VALUES("72","ABA072P","LENOVO LAPTOP  CORE I3 2ND GEN X220i 500 &amp; 4 ","X220i 500 &amp; 4 ","","1","2","10","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 03:22:16");
INSERT INTO tbl_item VALUES("74","ABA074P","Inspiron 15-3501 SSD 512 RAM 16 ","Inspiron 15-3501 SSD 512 RAM 16 ","","1","5","","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-25 05:31:28");
INSERT INTO tbl_item VALUES("75","ABA075P","LITEON SSD  M.2 128 GB M.2 SSD ","M.2 SSD ","","4","22","17","31","","1","10","0","","","","","","0.00","0.00","0","0","1","5","2022-03-27 01:40:03");
INSERT INTO tbl_item VALUES("76","ABA076P","APPLE LAPTOP  CORE I5 6TH GEN A 1502 SSD 128 RAM 8 GB","A 1502 SSD 128 RAM 8 GB","","1","5","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-27 04:14:06");
INSERT INTO tbl_item VALUES("77","ABA077P","APPLE LAPTOP  CORE I7 6TH GEN A 1398 SSD 256 RAM 16 GB","A 1398 SSD 256 RAM 16 GB","","1","3","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-27 04:15:15");
INSERT INTO tbl_item VALUES("78","ABA078P","HP Elite Book 840 G2 256/8 GB","840 G2 HDD 500 RAM 4 GB","","1","5","11","1","","1","","0","","","","","HP-Elitebook-840_back_1648407672.jpg","0.00","0.00","0","1","1","5","2022-03-28 01:01:12");
INSERT INTO tbl_item VALUES("79","ABA079P","HP LAPTOP  CORE I5 7TH GEN 820 G4 SSD 256 RAM 8GB","820 G4 SSD 256 RAM 8GB","","1","5","2","1","","1","","0","","","","","WhatsApp Image 2022-02-03 at 10.19.19 PM (2)_16484","0.00","0.00","0","1","1","5","2022-03-28 01:07:01");
INSERT INTO tbl_item VALUES("80","ABA080P","HP LAPTOP  CORE I5 3RD GEN 6470b HDD 500 RAM 4 GB","6470b HDD 500 RAM 4 GB","","1","5","9","1","","1","","0","","","","","WhatsApp Image 2022-01-03 at 11.23.47 AM_164840807","0.00","0.00","0","1","1","5","2022-03-28 01:07:57");
INSERT INTO tbl_item VALUES("81","ABA081P","HP LAPTOP  CORE I7 4TH GEN 850 G1 HDD 500 RAM 4 GB","850 G1 HDD 500 RAM 4 GB","","1","3","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:09:20");
INSERT INTO tbl_item VALUES("82","ABA082P","HP LAPTOP  CORE I5 5TH GEN 850 G2 HDD 500 RAM 4 GB ","850 G2 HDD 500 RAM 4 GB ","","1","5","7","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:09:56");
INSERT INTO tbl_item VALUES("83","ABA083P","HP LAPTOP  CORE I5 3RD GEN 9470m HDD 500 RAM 4 GB ","9470m HDD 500 RAM 4 GB ","","1","5","9","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:10:51");
INSERT INTO tbl_item VALUES("84","ABA084P","HP LAPTOP  CORE I5 4TH GEN 9480m HDD 500 RAM 4 GB ","9480m HDD 500 RAM 4 GB ","","1","5","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:11:17");
INSERT INTO tbl_item VALUES("85","ABA085P","DELL LAPTOP  CORE I5 8TH GEN Latitude 5400 SSD 256 RAM 8 GB","Latitude 5400 SSD 256 RAM 8 GB","","1","5","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:12:15");
INSERT INTO tbl_item VALUES("86","ABA086P","DELL LAPTOP  CORE I5 6TH GEN Latitude 7480 SSD 256 RAM 8 GB","Latitude 7480 SSD 256 RAM 8 GB","","1","5","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:13:00");
INSERT INTO tbl_item VALUES("87","ABA087P","HP LAPTOP  CORE I5 4TH GEN 440 G1 HDD 500 RAM 4 GB","440 G1 HDD 500 RAM 4 GB","","1","5","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:13:44");
INSERT INTO tbl_item VALUES("89","ABA089P","HP LAPTOP  CORE I3 1st Generation 4520s HDD 500 RAM 4 GB","4520s HDD 500 RAM 4 GB","","1","2","18","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:16:33");
INSERT INTO tbl_item VALUES("90","ABA090P","HP LAPTOP  CORE I7 3RD GEN 9470m HDD 500 RAM 4 GB ","9470m HDD 500 RAM 4 GB ","","1","3","9","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:18:47");
INSERT INTO tbl_item VALUES("91","ABA091P","HP LAPTOP  CORE I5 6TH GEN 440 G3 HDD 500 RAM 4 GB TOUCH","440 G3 HDD 500 RAM 4 GB TOUCH","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:19:51");
INSERT INTO tbl_item VALUES("92","ABA092P","DELL LAPTOP  CORE I5 8TH GEN Latitude 5590 SSD 256 RAM 8 GB","Latitude 5590 SSD 256 RAM 8 GB","","1","5","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:20:50");
INSERT INTO tbl_item VALUES("93","ABA093P","LENOVO LAPTOP  CORE I5 8TH GEN X1 YOGA 360 TOUCH SSD 256 RAM 8 GB","X1 YOGA 380 TOUCH SSD 256 RAM 8 GB","","1","5","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-28 01:21:51");
INSERT INTO tbl_item VALUES("94","ABA094P","HP LAPTOP  CORE I5 2ND GEN 6360 HDD 500 RAM 4 GB ","6360 HDD 500 RAM 4 GB ","","1","5","10","1","","1","10","0","","","","","","0.00","0.00","0","1","1","5","2022-03-30 12:27:47");
INSERT INTO tbl_item VALUES("95","ABA095P","LENOVO LAPTOP  CORE I5 8TH GEN X380 SSD 256 RAM 8 GB 360 Touch","X380 SSD 256 RAM 8 GB 360 Touch","","1","5","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-30 12:58:31");
INSERT INTO tbl_item VALUES("96","ABA096P","HP LAPTOP  CORE I5 3RD GEN 2570p HDD 500 RAM 4 GB","2570p HDD 500 RAM 4 GB","","1","5","9","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-30 04:24:10");
INSERT INTO tbl_item VALUES("97","ABA097P","HP LAPTOP  CORE I3 6TH GEN 440 G3 HDD 500 RAM 4 GB","440 G3 HDD 500 RAM 4 GB","","1","2","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-30 04:51:41");
INSERT INTO tbl_item VALUES("98","ABA098P","DELL LAPTOP  CORE I5 7TH GEN 5580 SSD 256 RAM 8 GB","5580 SSD 256 RAM 8 GB","","1","5","2","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-03-31 06:12:18");
INSERT INTO tbl_item VALUES("99","ABA099P","HP LAPTOP  RYZON 7 8TH GEN 745 G5 SSD 256 RAM 8 GB ","745 G5 SSD 256 RAM 8 GB ","","1","8","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-01 12:33:24");
INSERT INTO tbl_item VALUES("101","ABA101P","APPLE MOUSE    Magic Mouse Space Gray","Magic Mouse Space Gray","","5","","","6","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-04-02 01:24:09");
INSERT INTO tbl_item VALUES("102","ABA102P","SAMSUNG Mobile  256 GB  12 GB Note 10 Plus ","Note 10 Plus ","","33","29","15","14","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-04-03 04:20:35");
INSERT INTO tbl_item VALUES("103","ABA103P","840 G1 Core I5 8/256","840 G1","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-07 01:24:59");
INSERT INTO tbl_item VALUES("104","ABA104P","HP LAPTOP  CORE I3 2ND GEN CQ 42 HDD 500 RAM 4 GB ","CQ 42 HDD 500 RAM 4 GB ","","1","2","10","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-09 03:18:58");
INSERT INTO tbl_item VALUES("105","ABA105P","APPLE LAPTOP  CORE I5 3RD GEN MAC Book Pro A 1278","MAC Book Pro A 1278","","1","5","9","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-10 02:20:11");
INSERT INTO tbl_item VALUES("106","ABA106P","HP LAPTOP  CORE I5 10TH GEN Pavilion 15 HDD 1TB RAM 12 GB SSS 128","Pavilion 15 HDD 1TB RAM 12 GB SSS 128 GB","","1","5","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-16 03:22:52");
INSERT INTO tbl_item VALUES("107","ABA107P","DELL LAPTOP  CORE I7 8TH GEN Latitude 5400 SSD Nvme 512 RAM 16 GB","Latitude 5400 SSD Nvme 512 RAM 16 GB","","1","3","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-21 05:05:05");
INSERT INTO tbl_item VALUES("108","ABA108P","DELL LAPTOP  CORE I5 4TH GEN Latitude E 7440 SSD 256 RAM 4 GB","Latitude E 7440 SSD 256 RAM 4 GB","","1","5","8","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-22 04:59:41");
INSERT INTO tbl_item VALUES("109","ABA109P","CRUCIAL RAM  DDR4 8 GB CRUCIAL DDR 4 RAM BUS 2666","CRUCIAL DDR 4 RAM BUS 2666","","22","21","13","32","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-04-22 05:03:34");
INSERT INTO tbl_item VALUES("110","ABA110P","SAMSUNG SSD  500 GB  Nvme 980 Samsung 512 GB","Nvme 980 Samsung 512 GB","","4","34","","14","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-23 05:04:51");
INSERT INTO tbl_item VALUES("111","ABA111P","APPLE LAPTOP  CORE I7 4TH GEN A 1278 SSD 256 RAM 8 GB","A 1278 SSD 256 RAM 8 GB","","1","3","8","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-25 03:45:51");
INSERT INTO tbl_item VALUES("112","ABA112P","ASUS LAPTOP  CORE I7 7TH GEN GL552V HDD 1 TB 256 SSD RAM 16","GL552V HDD 1 TB 256 SSD RAM 16","","1","3","2","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-04-26 06:25:05");
INSERT INTO tbl_item VALUES("113","ABA113P","ACER LAPTOP  A4 9TH GEN AMD A4 SSD 128 RAM 4 GB","AMD A4 SSD 128 RAM 4 GB","","1","35","4","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-08 02:59:40");
INSERT INTO tbl_item VALUES("114","ABA114P","LENOVO LAPTOP  CORE I5 11TH GEN IDEAPAD 3 -15ITL6","IDEAPAD 3 -15ITL6","","1","5","6","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-09 05:49:58");
INSERT INTO tbl_item VALUES("115","ABA115P","LENOVO LAPTOP  CORE I3 10TH GEN V15 HDD 1 TB RAM 4 GB","V15 HDD 1 TB RAM 4 GB","","1","2","5","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-09 05:51:18");
INSERT INTO tbl_item VALUES("116","ABA116P","HP LAPTOP  CORE I3 11TH GEN 14s SSD 256 RAM 8 GB","14s SSD 256 RAM 8 GB","","1","2","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-09 05:52:02");
INSERT INTO tbl_item VALUES("117","ABA117P","HP LAPTOP  CORE I3 10TH GEN 15s SSD 256 RAM 8 GB","15s SSD 256 RAM 8 GB","","1","2","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-09 05:55:02");
INSERT INTO tbl_item VALUES("118","ABA118P","DAREO MOUSE  Optical  DAREO X3","DAREO X3","","5","36","","33","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-05-12 02:44:31");
INSERT INTO tbl_item VALUES("119","ABA119P","DELL LAPTOP  CORE I3 8TH GEN 7390 SSD 256 RAM 4 GB","7390 SSD 256 RAM 4 GB","","1","2","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-12 06:51:38");
INSERT INTO tbl_item VALUES("120","ABA120P","SAMSUNG RAM  DDR 3 4 GB DDR3L 4GB","DDR3L 4GB","","22","20","20","14","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-05-12 07:16:36");
INSERT INTO tbl_item VALUES("121","ABA121P","GREEDY BLACK MOUSE  Optical  GREEDY BLACK","GREEDY BLACK","","5","36","","34","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-05-12 07:22:16");
INSERT INTO tbl_item VALUES("122","ABA122P","APPLE LAPTOP  CORE I5 11TH GEN Mac Book Pro A 2251","Mac Book Pro A 2251","","1","5","6","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-14 02:33:54");
INSERT INTO tbl_item VALUES("123","ABA123P","APPLE LAPTOP  CORE I5 11TH GEN Year 2020 M1 SSD 256 RAM 8GB","Year 2020 M1 SSD 256 RAM 8GB","","1","5","6","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-14 07:15:25");
INSERT INTO tbl_item VALUES("124","ABA124P","HP LAPTOP  CORE I3 7TH GEN Pavilion 2 GB Graphic HDD 1 TB RAM 4 G","Pavilion 2 GB Graphic HDD 1 TB RAM 4 GB","","1","2","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:49:01");
INSERT INTO tbl_item VALUES("125","ABA125P","DELL LAPTOP  CORE I3 10TH GEN Inspiron 3593 Core I3 10th HDD 1 TB","Inspiron 3593 Core I3 10th HDD 1 TB RAM 4 GB","","1","2","5","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:52:15");
INSERT INTO tbl_item VALUES("126","ABA126P","DELL LAPTOP  CORE I3 11TH GEN VOSTRO 3400 Core I3 11th Gen 8 GB 1","VOSTRO 3400 Core I3 11th Gen 8 GB 1 TB 128 GB ","","1","2","6","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:53:16");
INSERT INTO tbl_item VALUES("127","ABA127P","ACER LAPTOP  CORE I5 10TH GEN Aspire 3 Core I5 10th Gen 1 TB 4 GB","Aspire 3 Core I5 10th Gen 1 TB 4 GB ","","1","5","5","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:54:28");
INSERT INTO tbl_item VALUES("128","ABA128P","LENOVO LAPTOP  CORE I5 10TH GEN IDEAPAD S 145 SSD 256 RAM 4 GB ","IDEAPAD S 145 SSD 256 RAM 4 GB ","","1","5","5","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:55:30");
INSERT INTO tbl_item VALUES("129","ABA129P","HP LAPTOP  CORE I7 4TH GEN ENVY 15 Core I7 4th HDD 1 TB RAM 12 GB","ENVY 15 Core I7 4th HDD 1 TB RAM 12 GB ","","1","3","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:56:52");
INSERT INTO tbl_item VALUES("130","ABA130P","HP LAPTOP  CORE I3 8TH GEN HP 15 Core I3 8th Gen HDD 1 TB RAM 4 G","HP 15 Core I3 8th Gen HDD 1 TB RAM 4 GB ","","1","2","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-15 06:59:14");
INSERT INTO tbl_item VALUES("131","ABA131P","APPLE Mobile  256 GB  4 GB I Phone X 256 GB","I Phone X 256 GB","","33","29","20","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-05-19 11:31:38");
INSERT INTO tbl_item VALUES("132","ABA132P","ASUS LAPTOP  CORE I3 8TH GEN Asus Vivobook X543U","Asus Vivobook X543U","","1","2","3","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-19 07:26:28");
INSERT INTO tbl_item VALUES("133","ABA133P","ACER LAPTOP  CORE I5 10TH GEN ACER Aspire 3 HDD 1 TB RAM 8 GB","ACER Aspire 3 HDD 1 TB RAM 8 GB","","1","5","5","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-19 07:27:17");
INSERT INTO tbl_item VALUES("134","ABA134P","840 G5 I5 8th Gen 256/8 GB","HP 840 G5 SSD 256 RAM 8 GB","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-21 02:06:51");
INSERT INTO tbl_item VALUES("135","ABA135P","HP LAPTOP  CORE I5 11TH GEN Victus By HP Nvme 1 TV RAM 16 GB","Victus By HP Nvme 1 TV RAM 16 GB","","1","5","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-21 08:13:21");
INSERT INTO tbl_item VALUES("136","ABA136P","APPLE Mobile  256 GB   XS MAX ","XS MAX ","","33","29","","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-05-22 05:57:54");
INSERT INTO tbl_item VALUES("137","ABA137P","HP LAPTOP  CORE I5 7TH GEN HP Probook 450 HDD 1 TB RAM 8 GB 2GB D","HP Probook 450 HDD 1 TB RAM 8 GB 2GB Dedicated Graphics","","1","5","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-23 03:55:57");
INSERT INTO tbl_item VALUES("138","ABA138P","APPLE Mobile   128 GB I Phone 11 ROM 128","I Phone 11 ROM 128","","33","","17","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-05-23 04:49:10");
INSERT INTO tbl_item VALUES("139","ABA139P","APPLE Mobile  Mobile  64 GB I Phone 11 ROM 64","I Phone 11 ROM 64","","33","30","21","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-05-23 04:50:30");
INSERT INTO tbl_item VALUES("140","ABA140P","LENOVO LAPTOP  CORE I3 11TH GEN V14 SSD 256 RAM 8 GB ","V14 SSD 256 RAM 8 GB ","","1","2","6","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-27 08:06:37");
INSERT INTO tbl_item VALUES("141","ABA141P","ASUS LAPTOP  CORE I3 7TH GEN ASUS VIVO Book 15 Core I3 7th Gen HD","ASUS VIVO Book 15 Core I3 7th Gen HDD 1 TB RAM 4 GB","","1","2","2","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-28 06:56:41");
INSERT INTO tbl_item VALUES("142","ABA142P","SSD  256 GB   NVme 256 GB","NVme 256 GB","","4","29","","11","","1","","0","","","","","","2300.00","2500.00","0","0","1","5","2022-05-28 07:10:39");
INSERT INTO tbl_item VALUES("143","ABA143P","ASUS LAPTOP  CORE I5 8TH GEN Asus Vivo Book S14 Core I5 8th Gen 8","Asus Vivo Book S14 Core I5 8th Gen 8 And 1 TB","","1","5","3","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-05-30 08:21:56");
INSERT INTO tbl_item VALUES("144","ABA144P","APPLE LAPTOP  CORE I5 6TH GEN A 1502 Year 2015 SSD 512 RAM 16 Cor","A 1502 Year 2015 SSD 512 RAM 16 Core I5","","1","5","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-01 05:29:04");
INSERT INTO tbl_item VALUES("145","ABA145P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7390 Touch 256 And 8 G","Dell Latitude 7390 Touch 256 And 8 GB","","1","5","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-03 08:19:38");
INSERT INTO tbl_item VALUES("146","ABA146P","APPLE Mobile  512 GB  XS Max 512 GB","XS Max 512 GB","","33","37","","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-06-04 12:14:15");
INSERT INTO tbl_item VALUES("147","ABA147P","HP LAPTOP  CORE I5 8TH GEN Probook 450 SSD 256 RAM 8 GB","Probook 450 SSD 256 RAM 8 GB","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-06 11:35:08");
INSERT INTO tbl_item VALUES("148","ABA148P","HP LAPTOP  CORE I5 7TH GEN Pavilion 15 SSD 256 RAM 8 GB ","Pavilion 15 SSD 256 RAM 8 GB ","","1","5","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-06 11:35:44");
INSERT INTO tbl_item VALUES("149","ABA149P","SAMSUNG Mobile  8 GB 128 GB Samsung S10 ROM 128 RAM 8 GB","Samsung S10 ROM 128 RAM 8 GB","","33","38","17","14","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-06-09 11:20:04");
INSERT INTO tbl_item VALUES("150","ABA150P","Laptop Bag","Laptop BAG","","41","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-06-13 03:56:31");
INSERT INTO tbl_item VALUES("151","ABA151P","HP14-bs0xx HDD 1 TB RAM 8 GB","HP 14-bs0xx HDD 1 TB RAM 8 GB","","1","2","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-13 04:20:59");
INSERT INTO tbl_item VALUES("152","ABA152P","APPLE LAPTOP  CORE I5 6TH GEN Mac Book Pro A 1502 SSD 512 RAM 8 G","Mac Book Pro A 1502 SSD 512 RAM 8 GB ","","1","5","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-16 06:44:49");
INSERT INTO tbl_item VALUES("153","ABA153P","ASUS LAPTOP  CORE I5 8TH GEN VIVO BOOK S15-X530UA I5 8th Gen 1 TB","VIVO BOOK S15-X530UA I5 8th Gen 1 TB 128 GB 8 GB FHD","","1","5","3","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-18 07:27:07");
INSERT INTO tbl_item VALUES("154","ABA154P","HP LAPTOP  CORE I5 8TH GEN Probook 450 G5 I5 8th Gen 1 TB 4 GB 2 ","Probook 450 G5 I5 8th Gen 1 TB 4 GB 2 GB Dedicated","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-18 07:33:21");
INSERT INTO tbl_item VALUES("155","ABA155P","Power Cable","Laptop Power Cable","","","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-06-20 07:49:40");
INSERT INTO tbl_item VALUES("156","ABA156P","840 G1 Core I7 256/8 GB","840 G1 HDD 500 RAM 8 GB Core I7 ","","1","3","8","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-22 04:43:25");
INSERT INTO tbl_item VALUES("157","ABA157P","ASUS LAPTOP  CORE I5 8TH GEN Asus A510U Core I5 8th Gen 1 TB 4 GB","Asus A510U Core I5 8th Gen 1 TB 4 GB ","","1","5","3","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-22 06:35:41");
INSERT INTO tbl_item VALUES("158","ABA158P","APPLE Mobile   64 GB I Phone 12 Red Color 64 GB","I Phone 12 Red Color 64 GB","","33","","21","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-22 07:37:34");
INSERT INTO tbl_item VALUES("159","ABA159P","HP LAPTOP  CORE I5 6TH GEN HP Probook 440 G3 SSD 256 RAM 8 GB","HP Probook 440 G3 SSD 256 RAM 8 GB","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-27 07:41:55");
INSERT INTO tbl_item VALUES("160","ABA160P","LENOVO LAPTOP  CORE I5 6TH GEN V310 I5 6th HDD 1 TB RAM 4 GB","V310 I5 6th HDD 1 TB RAM 4 GB","","1","5","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-06-27 07:51:33");
INSERT INTO tbl_item VALUES("161","ABA161P","APPLE Mobile   64 GB I Phone 11 ROM 64 GB RAM 4 GB","I Phone 11 ROM 64 GB RAM 4 GB","","33","","21","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-06-30 04:22:33");
INSERT INTO tbl_item VALUES("162","ABA162P","DELL LAPTOP  CORE I5 6TH GEN DELL Inspiron 15 I5 6th Gen 1 TB 4 G","DELL Inspiron 15 I5 6th Gen 1 TB 4 GB 2 GB Graphic","","1","5","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-02 07:10:13");
INSERT INTO tbl_item VALUES("163","ABA163P","DELL LAPTOP  CORE I3 5TH GEN DELL Inspiron 3558 Core I3 5th Gen 1","DELL Inspiron 3558 Core I3 5th Gen 1 TB 4 GB","","1","2","7","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-03 08:14:30");
INSERT INTO tbl_item VALUES("164","ABA164P","HP LAPTOP  CORE I5 6TH GEN Probook 450 G3 Core I5 6th Gen HDD 1 T","Probook 450 G3 Core I5 6th Gen HDD 1 TB RAM 4 GB","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-05 12:52:32");
INSERT INTO tbl_item VALUES("165","ABA165P","HP LAPTOP  CORE I7 6TH GEN 850 G3 Core I7 6th Gen SSD 256 RAM 12 ","850 G3 Core I7 6th Gen SSD 256 RAM 12 GB","","1","3","1","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-07-06 07:42:49");
INSERT INTO tbl_item VALUES("166","ABA166P","one plus  Mobile  256 GB  12 GB One Plus 9 Pro 12 And 256 ","One Plus 9 Pro 12 And 256 ","","33","29","15","30","","1","","0","","","","","","0.00","0.00","0","2","1","5","2022-07-16 06:51:16");
INSERT INTO tbl_item VALUES("167","ABA167P","ACER LAPTOP  CORE I3 6TH GEN ES1-572 Core I3 6th Gen HDD 1TB RAM ","ES1-572 Core I3 6th Gen HDD 1TB RAM 4 GB","","1","2","1","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-23 05:15:39");
INSERT INTO tbl_item VALUES("168","ABA168P","ACER LAPTOP  CORE I3 5TH GEN Aspire E5-573-3041 Core I3 5th HDD 5","Aspire E5-573-3041 Core I3 5th HDD 500 RAM 4 GB","","1","2","7","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-23 05:17:00");
INSERT INTO tbl_item VALUES("169","ABA169P","ACER LAPTOP  CORE I3 7TH GEN E5-576 Core I3 7th Gen HDD 1TB 4GB","E5-576 Core I3 7th Gen HDD 1TB 4GB","","1","2","2","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-24 04:46:50");
INSERT INTO tbl_item VALUES("170","ABA170P","HP LAPTOP  CORE I3 8TH GEN HP 15s Du 8900TU I3 8th 1TB 4 GB","HP 15s Du 8900TU I3 8th 1TB 4 GB","","1","2","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-24 04:48:45");
INSERT INTO tbl_item VALUES("171","ABA171P","840 G3  Touch Screen I7 6th 256/8 GB","840 G3 Core I7 SSD 256 RAM 8 GB Non Touch","256/8","1","3","24","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-07-30 06:46:57");
INSERT INTO tbl_item VALUES("172","ABA172P","APPLE LAPTOP  CORE I5 6TH GEN A 1466 Core I5 Year 2017","A 1466 Core I5 Year 2017","","1","5","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-08-06 11:42:47");
INSERT INTO tbl_item VALUES("173","ABA173P","840 G5 Touch Screen I5 8th 256/8 GB","840 G5 Touch SSD 256 RAM 8 GB Core I5 ","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-08-10 07:22:09");
INSERT INTO tbl_item VALUES("175","ABA174P","LENOVO LAPTOP  CORE I3 7TH GEN Ideapad 310 SSD 120 RAM 8 GB","Ideapad 310 SSD 120 RAM 8 GB","","1","2","2","3","","1","","0","","","","","Lenovo-ideapad-310-Intel-Core-i5-6200U_1660288542.","0.00","0.00","0","1","1","5","2022-08-12 01:15:42");
INSERT INTO tbl_item VALUES("176","ABA175P","LENOVO LAPTOP  CORE I7 6TH GEN X1 Carbon 256 And 8 GB","X1 Carbon 256 And 8 GB","","1","3","1","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-08-12 05:47:14");
INSERT INTO tbl_item VALUES("177","ABA176P","     Laptop Service ","Laptop Service ","","","","","","","","","0","","","","","","0.00","0.00","0","0","1","5","2022-08-13 05:46:57");
INSERT INTO tbl_item VALUES("178","ABA177P","DELL LAPTOP  Pentium 6TH GEN DELL 3189 SSD 128 RAM 4 GB ","DELL 3189 SSD 128 RAM 4 GB ","","1","39","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-08-14 01:05:56");
INSERT INTO tbl_item VALUES("179","ABA178P","A 1707 SSD 256 RAM 8 GB Core I5","Mac Book Pro A 1707 RAM 8 GB SSD 128","","1","5","3","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-08-18 06:30:32");
INSERT INTO tbl_item VALUES("180","ABA179P","DELL LAPTOP  CORE I7 6TH GEN DELL 7470 Core I7 6th Gen SSD 256 RA","DELL 7470 Core I7 6th Gen SSD 256 RAM 8 GB","","1","3","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-01 06:26:51");
INSERT INTO tbl_item VALUES("181","ABA180P","Google pixel book  LAPTOP  CORE I5 7TH GEN Google Pixel Book Core","Google Pixel Book Core I5 7th Gen SSD 128 RAM 8 GB","","1","5","2","35","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-04 01:46:11");
INSERT INTO tbl_item VALUES("182","ABA181P","APPLE LAPTOP  CORE I5 6TH GEN Mac Mini Core I5 SSD 128 RAM 8GB ","Mac Mini Core I5 SSD 128 RAM 8GB ","","1","5","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-07 02:19:30");
INSERT INTO tbl_item VALUES("183","ABA182P","DELL LAPTOP  CORE I5 5TH GEN Inspiron 15 Core I5 5th Gen HDD 1 TB","Inspiron 15 Core I5 5th Gen HDD 1 TB RAM 4 GB 2 GB Dedicated","","1","5","7","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-07 07:56:52");
INSERT INTO tbl_item VALUES("184","ABA183P","840 G5 Core I7 8th 256/8 GB","840 G5 Core I7 8th Gen SSD 256 RAM 8 GB ","","1","3","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-08 04:52:29");
INSERT INTO tbl_item VALUES("185","ABA184P","Color","Laptop Color","","1","","","","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-09 07:58:45");
INSERT INTO tbl_item VALUES("186","ABA185P","APPLE LAPTOP  CORE I7 7TH GEN Mac Book Air Core I7 Year 2015 SSD ","Mac Book Air Core I7 Year 2015 SSD 256 RAM 8 GB","","1","3","2","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-10 06:56:57");
INSERT INTO tbl_item VALUES("187","ABA186P","ACER LAPTOP  Pentium 5TH GEN Acer Mini Atom HDD 320 RAM 2 GB","Acer Mini Atom HDD 320 RAM 2 GB","","1","39","7","5","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-14 06:48:45");
INSERT INTO tbl_item VALUES("188","ABA187P","CORE I5 7TH GEN X1 Carbon Core I5 7th Gen SSD 512 And 16 GB","X1 Carbon Core I5 7th Gen SSD 512 RAM 16 GB","","1","5","","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-15 04:55:19");
INSERT INTO tbl_item VALUES("189","ABA188P","LENOVO LAPTOP  CORE I7 5TH GEN X1 Carbon Core I7 5th Gen SSD 256 ","X1 Carbon Core I7 5th Gen SSD 256 RAM 8 GB","","1","3","7","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-15 04:56:17");
INSERT INTO tbl_item VALUES("190","ABA189P","LENOVO LAPTOP  CORE I7 4TH GEN X1 Carbon Core I7 4th Gen SSD 256 ","X1 Carbon Core I7 4th Gen SSD 256 RAM 8 GB","","1","3","8","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-15 04:58:35");
INSERT INTO tbl_item VALUES("191","ABA190P","LENOVO LAPTOP  CORE I5 5TH GEN X1 Carbon Core I5 5th Gen SSD 256 ","X1 Carbon Core I5 5th Gen SSD 256 RAM 8 GB","","1","5","7","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-16 06:05:46");
INSERT INTO tbl_item VALUES("192","ABA191P","LENOVO LAPTOP  CORE I5 8TH GEN X1 Carbon I5 8th Gen SSD 256 RAM 1","X1 Carbon I5 8th Gen SSD 256 RAM 16 GB","","1","5","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-18 03:53:05");
INSERT INTO tbl_item VALUES("193","ABA192P","DELL LAPTOP  CORE I3 4TH GEN DELL 3340 HDD 500 RAM 4 GB Core I3 4","DELL 3340 HDD 500 RAM 4 GB Core I3 4th Gen ","","1","2","8","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-18 03:55:24");
INSERT INTO tbl_item VALUES("194","ABA193P","HP LAPTOP  CORE I5 7TH GEN HP Elite X2 Core I5 7th Gen SSD 256 RA","HP Elite X2 Core I5 7th Gen SSD 256 RAM 8 GB","","1","5","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-26 02:08:15");
INSERT INTO tbl_item VALUES("195","ABA194P","HP LAPTOP  DUAL CORE 6TH GEN HP Strem Pentium SSD 64 And 4 GB","HP Strem Pentium SSD 64 And 4 GB","","1","9","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-26 02:09:05");
INSERT INTO tbl_item VALUES("196","ABA195P","HP LAPTOP  CORE I7 8TH GEN Zbook Core I7 8th Gen 256 And 16 GB To","Zbook Core I7 8th Gen 256 And 16 GB Touch ","","1","3","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-26 02:20:10");
INSERT INTO tbl_item VALUES("197","ABA196P","HP LAPTOP  Core M3 7TH GEN Probook X360 G2 EE Core M3 7th Gen RAM","Probook X360 G2 EE Core M3 7th Gen RAM 8 SSD 128","","1","40","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-28 04:31:10");
INSERT INTO tbl_item VALUES("198","ABA197P","HP LAPTOP  CORE I3 8TH GEN HP Probook 440 X360 Core I3 8th SSD 25","HP Probook 440 X360 Core I3 8th SSD 256 RAM 8 GB","","1","2","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-28 04:32:49");
INSERT INTO tbl_item VALUES("199","ABA198P","HP LAPTOP  CORE I5 7TH GEN 1040 Core I5 7th Touch Gen SSD 256 RAM","1040 Core I5 7th Touch Gen SSD 256 RAM 16 GB","","1","5","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-28 04:34:35");
INSERT INTO tbl_item VALUES("200","ABA199P","APPLE LAPTOP  CORE I5 7TH GEN Mac Book Air A 1466 Core I5 2015 RA","Mac Book Air A 1466 Core I5 2015 RAM 8 SSD 128","","1","5","2","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-09-30 04:10:11");
INSERT INTO tbl_item VALUES("201","ABA200P","LAPTOP    Adapter ","Adapter ","","41","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-10-04 02:32:16");
INSERT INTO tbl_item VALUES("202","ABA201P","HP LAPTOP  CORE I5 8TH GEN ZBOOK G5 I5 8th Gen 256 And 8 GB","ZBOOK I5 8th Gen 256 And 8 GB","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-08 02:13:03");
INSERT INTO tbl_item VALUES("203","ABA202P","DELL LAPTOP  CORE I5 10TH GEN DELL 5310 I5 10th SSD 256 RAM 8 GB","DELL 5310 I5 10th SSD 256 RAM 8 GB","","1","5","5","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-09 02:06:44");
INSERT INTO tbl_item VALUES("204","ABA203P","DELL LAPTOP  CORE I3 5TH GEN DELL 3350 Core I3 5th Gen HDD 500 RA","DELL 3350 Core I3 5th Gen HDD 500 RAM 4 GB","","1","2","7","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-09 02:07:47");
INSERT INTO tbl_item VALUES("205","ABA204P","HP LAPTOP  CORE I5 7TH GEN HP 850 Core I5 7th Gen 256 And 8 GB","HP 850 Core I5 7th Gen 256 And 8 GB","","1","5","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-13 02:01:51");
INSERT INTO tbl_item VALUES("206","ABA205P","HP LAPTOP  CORE I7 7TH GEN 850 Core I7 7th Gen SSD 256 RAM 8 GB","850 Core I7 7th Gen SSD 256 RAM 8 GB","","1","3","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-14 04:27:14");
INSERT INTO tbl_item VALUES("207","ABA206P","SSD    SSD 256 GB SATA ","SSD 256 GB SATA ","","4","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-10-14 04:36:46");
INSERT INTO tbl_item VALUES("208","ABA207P","HP LAPTOP  CORE I5 7TH GEN 850 Core I5 7th SSD 256 RAM 8 GB","850 Core I5 7th SSD 256 RAM 8 GB","","1","5","2","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-15 01:23:31");
INSERT INTO tbl_item VALUES("209","ABA208P","DELL LAPTOP  CORE I7 6TH GEN DELL Precision 5520 I7 6th Gen SSD 2","DELL Precision 5520 I7 6th Gen SSD 256 RAM 12 GB DDR 5 Graphic","","1","3","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-15 02:09:50");
INSERT INTO tbl_item VALUES("210","ABA209P","HP LAPTOP  Pentium 10th gen 10TH GEN HP 15-DW0 Pentium 10th Gen 1","HP 15-DW0 Pentium 10th Gen 128 And 256 Red Color 15.6","","1","41","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-15 05:55:53");
INSERT INTO tbl_item VALUES("211","ABA210P","ASUS LAPTOP  CORE I7 7TH GEN ASUS ROG Zeprius Core I7 7th Gen 512","ASUS ROG Zeprius Core I7 7th Gen 512 And 16 GB","","1","3","2","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-16 05:35:42");
INSERT INTO tbl_item VALUES("212","ABA211P","Probook 440 I3 6th Gen 500 And 4 GB Touch Screen","Probook 440 Core I3 6th Gen 500 And 4 GB Touch Screen","","1","2","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-19 05:06:24");
INSERT INTO tbl_item VALUES("213","ABA212P","HP LAPTOP  CORE I5 11TH GEN HP 15 Core I5 11th Gen 256 And 8 GB ","HP 15 Core I5 11th Gen 256 And 8 GB ","","1","5","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-26 04:03:05");
INSERT INTO tbl_item VALUES("214","ABA213P","HP LAPTOP  CORE I5 10TH GEN HP 15 Core I5 10th Gen 256 And 8 GB","HP 15 Core I5 10th Gen 256 And 8 GB","","1","5","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-26 04:03:43");
INSERT INTO tbl_item VALUES("215","ABA214P","Gate Way LAPTOP  DUAL CORE 10TH GEN Gate Way Dual Core 10th 64 An","Gate Way Dual Core 10th 64 And 4 GB","","1","9","5","36","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-27 01:00:30");
INSERT INTO tbl_item VALUES("216","ABA215P","DELL LAPTOP  CORE I5 5TH GEN 3350 I5 5th Gen HDD 500 RAM 4 GB Tou","3350 I5 5th Gen HDD 500 RAM 4 GB Touch Screen","","1","5","7","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-29 04:04:21");
INSERT INTO tbl_item VALUES("217","ABA216P"," battery     Battery Dell 3421","Battery Dell 3421","","40","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-10-30 05:49:21");
INSERT INTO tbl_item VALUES("218","ABA217P","HP EliteBook 830 G5 Core I5 7th SSD 256/8 GB","830 Core I5 7th Gen 256 And 8 GB ","","1","5","10","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2022-10-31 06:14:14");
INSERT INTO tbl_item VALUES("219","ABA218P","HP Elitebook 830 G5 256/8 I5 8th","830 G5 Core I5 8th Gen 256 And 8 GB","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-10-31 06:14:57");
INSERT INTO tbl_item VALUES("220","ABA219P","Laptop Spose","Laptop Spuse ","","41","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-11-02 04:13:51");
INSERT INTO tbl_item VALUES("221","ABA220P","840 G5 Core I5 7th Generation 256/8 GB","840 G5 7th Gen SSD 256 RAM 8 GB","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-03 11:59:43");
INSERT INTO tbl_item VALUES("222","ABA221P","DELL LAPTOP  CORE I5 10TH GEN Latitude 5410 I5 10th SSD 256 RAM 8","Latitude 5410 I5 10th SSD 256 RAM 8 GB","","1","5","5","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-03 04:18:09");
INSERT INTO tbl_item VALUES("223","ABA222P","M.2 SSD 180  GB","M.2 SSD 128 GB","","4","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-11-04 02:07:56");
INSERT INTO tbl_item VALUES("224","ABA223P","128 GB  SATA SSD KING SPACE","SATA 128 GB KING SPACE","","4","","","22","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-04 02:08:23");
INSERT INTO tbl_item VALUES("225","ABA224P","APPLE LAPTOP  CORE I5 10TH GEN Mac Book Air 2019 Core I5 SSD 128 ","Mac Book Air 2019 Core I5 SSD 128 And 8 GB","","1","5","5","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-05 11:49:47");
INSERT INTO tbl_item VALUES("226","ABA225P","HP LAPTOP  CORE I5 8TH GEN HP 850 G6 I5 8th Gen 256 And 16 GB ","HP 850 G6 I5 8th Gen 256 And 16 GB ","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-13 12:02:17");
INSERT INTO tbl_item VALUES("227","ABA226P","HP LAPTOP  CORE I5 6TH GEN 1040 Core I5 6th Gen Non Touch 256 And","1040 Core I5 6th Gen Non Touch 256 And 8 GB","","1","5","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-13 12:04:14");
INSERT INTO tbl_item VALUES("228","ABA227P"," battery     Dell 7470 Battery","Dell 7470 Battery","","40","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-11-14 12:04:21");
INSERT INTO tbl_item VALUES("229","ABA228P","840 G6 Core I7 8Gen 8/256","840 G6 Core I7 8th Gen 8 And 256 ","","1","3","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-14 06:14:34");
INSERT INTO tbl_item VALUES("230","ABA229P","HP LAPTOP  CORE I7 6TH GEN 1040 Core I7 6th Gen 256 And 8 GB","1040 Core I7 6th Gen 256 And 8 GB","","1","3","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-14 06:37:50");
INSERT INTO tbl_item VALUES("231","ABA230P","HP LAPTOP  CORE I7 5TH GEN 1040 Core I7 5th Gen 256 And 8 GB","1040 Core I7 5th Gen 256 And 8 GB","","1","3","7","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-17 06:29:59");
INSERT INTO tbl_item VALUES("232","ABA231P","840 G5 Core I5 7th Gen Touch Screen 256/8 GB","840 G5 Touch Screen 256 And 8 GB","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-20 05:01:06");
INSERT INTO tbl_item VALUES("233","ABA232P","HP LAPTOP  Ryzen 3  8TH GEN HP 14 Ryzen 3 SSD 256 RAM 8 GB ","HP 14 Ryzen 3 SSD 256 RAM 8 GB ","","1","43","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-21 11:21:14");
INSERT INTO tbl_item VALUES("234","ABA233P","LENOVO LAPTOP  Ryzen 3  7TH GEN Lenovo V15 Ryzen 3 SSD 256 RAM 8 ","Lenovo V15 Ryzen 3 SSD 256 RAM 8 GB ","","1","43","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-21 11:23:20");
INSERT INTO tbl_item VALUES("235","ABA234P","HP 830 I5 7th Gen SSD 256 RAM 8 GB","HP 830 I5 7th Gen SSD 256 RAM 8 GB","","1","5","10","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-11-21 11:30:33");
INSERT INTO tbl_item VALUES("236","ABA235P","Surface  LAPTOP  CORE I5 8TH GEN Surface Laptop 2 SSD 256 RAM 8 G","Surface Laptop 2 SSD 256 RAM 8 GB ","","1","5","3","37","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-21 01:49:01");
INSERT INTO tbl_item VALUES("237","ABA236P","HP LAPTOP  Pentium 10TH GEN Pentium Silver HP SSD 256 8 GB ","Pentium Silver HP SSD 256 8 GB ","","1","39","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-21 04:03:53");
INSERT INTO tbl_item VALUES("238","ABA237P","APPLE LAPTOP  CORE I5 6TH GEN Mac Book Air 2013 Core I5 SSD 256 R","Mac Book Air 2013 Core I5 SSD 256 RAM 4 GB","","1","5","1","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-25 06:15:13");
INSERT INTO tbl_item VALUES("239","ABA238P","DELL LAPTOP  CORE I5 8TH GEN 5490 I5 8th Gen 256 And 8 GB","5490 I5 8th Gen 256 And 8 GB","","1","5","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-11-26 07:41:37");
INSERT INTO tbl_item VALUES("240","ABA239P","DELL LAPTOP  5490 I5 7th Gen SSD 256 RAM 8 GB","5490 I5 8th Gen SSD 256 RAM 8 GB","","1","5","10","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2022-11-30 06:06:19");
INSERT INTO tbl_item VALUES("241","ABA240P","840 G8 I5 11th Gen 8 And 512 ","840 G8 I5 11th Gen 8 And 512 ","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-04 01:07:49");
INSERT INTO tbl_item VALUES("242","ABA241P","840 G7 Core I5 10th Gen 8 And 512","840 G7 Core I5 10th Gen 8 And 512","","1","5","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-04 01:08:26");
INSERT INTO tbl_item VALUES("243","ABA242P","840 G7 RYZEN 7 Pro 16 And 256 ","840 G7 RYZEN 7 Pro 16 And 256 ","","1","8","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-04 01:10:46");
INSERT INTO tbl_item VALUES("244","ABA243P","HP LAPTOP  CORE I3 11TH GEN HP 15 DW3363ST Core I3 11th Gen 256 A","HP 15 DW3363ST Core I3 11th Gen 256 And 8 GB","","1","2","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-04 06:03:04");
INSERT INTO tbl_item VALUES("245","ABA244P","HP LAPTOP  CORE I5 11TH GEN HP Pavilion X360 I5 11th 8 And 256 To","HP Pavilion X360 I5 11th 8 And 256 Touch Screen","","1","5","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-05 06:18:57");
INSERT INTO tbl_item VALUES("246","ABA245P","HP LAPTOP  RYZON 5 10TH GEN HP 15 RYZEN 5 SSD 256 RAM 8 GB","HP 15 RYZEN 5 SSD 256 RAM 8 GB","","1","7","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-05 06:19:58");
INSERT INTO tbl_item VALUES("247","ABA246P","LENOVO LAPTOP  CORE I7 7TH GEN Lenovo Yoga 910 Core I7 7th Gen SS","Lenovo Yoga 910 Core I7 7th Gen SSD 256 RAM 8 GB ","","1","3","2","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2022-12-08 05:30:26");
INSERT INTO tbl_item VALUES("248","ABA247P"," MOUSE    A4Tech Mouse ","A4Tech Mouse ","","5","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2022-12-09 10:44:50");
INSERT INTO tbl_item VALUES("249","ABA248P","SSD 512 GB   512 GB SSD King Spec","512 GB SSD King Spec","","4","","","","","1","","0","","","512 GB","","","0.00","0.00","1095","1","1","5","2022-12-09 04:26:51");
INSERT INTO tbl_item VALUES("250","ABA249P","KINGSPACE SSD    1TB SSD King Spec","1TB SSD King Spec","","4","","","11","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2022-12-09 04:28:10");
INSERT INTO tbl_item VALUES("251","ABA250P","KINGSPEC SSD    256 GB SSD King Spec","256 GB SSD King Spec","","4","","","22","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2022-12-09 04:39:15");
INSERT INTO tbl_item VALUES("252","ABA251P","KINGSPEC 2280 NGFF SSD  256 GB  M.2 SSD ","256 GB  M.2 SSD King Spec","","4","","","22","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2022-12-09 04:41:48");
INSERT INTO tbl_item VALUES("253","ABA252P","KINGSPEC SSD    128GB Sata SSD KingSpec","128GB Sata SSD KingSpec","","4","","","22","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2022-12-09 04:44:29");
INSERT INTO tbl_item VALUES("254","ABA253P","VALUE TECH SSD    Valutech 256 GB M.2 SSD","Valutech 256 GB M.2 SSD","","4","","","23","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2022-12-09 05:55:28");
INSERT INTO tbl_item VALUES("255","ABA254P","Transcend 512 GB SATA SSD    ","","","4","","","38","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2022-12-21 12:56:23");
INSERT INTO tbl_item VALUES("256","ABA255P","HP Elitebook X360 1030 G8  Core I5-11th Gen","HP Elitebook X360 1030 G8","Core i5-11th Gen
SSD-256GB
RAM-16GB","1","5","","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-12-26 03:28:02");
INSERT INTO tbl_item VALUES("257","ABA256P","HP LAPTOP HP Elitebook X360 1030 G7 CORE I5 10TH GEN HP Elitebook","HP Elitebook X360 1030 G7","Core ii5-10th Gen
SSD-256GB
RAM-16GB","1","5","5","1","","1","11","0","","","HP Elitebook X360 1030 G7","","","0.00","0.00","0","1","1","5","2022-12-26 03:29:24");
INSERT INTO tbl_item VALUES("258","ABA257P","HP Aero-14 I5 11th 8/256 GB","HP PAVILION AERO 13-BE0XXX","","1","5","34","1","","1","11","0","","","HP PAVILION AERO 13-BE0XX","","","0.00","0.00","0","1","1","5","2022-12-26 03:35:21");
INSERT INTO tbl_item VALUES("259","ABA258P","HP LAPTOP  CORE I7 6TH GEN HP Spectre X360 Convertible","HP Spectre X360 Convertible","","1","3","1","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2022-12-29 07:24:59");
INSERT INTO tbl_item VALUES("260","ABA259P","LENOVO LAPTOP  CORE I7 8TH GEN Lenovo X1 Carbon I7-8th  Touch SSD","Lenovo X1 Carbon I7-8th  Touch SSD-256 Ram-16","","1","3","3","3","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-12 02:08:34");
INSERT INTO tbl_item VALUES("261","ABA260P","LENOVO LAPTOP  CORE I7 8TH GEN Lenovo X1 Carbon I7-8th   SSD-256 ","Lenovo X1 Carbon I7-8th   SSD-256 Ram-8","","1","3","3","3","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-12 02:10:07");
INSERT INTO tbl_item VALUES("262","ABA261P","LENOVO LAPTOP  CORE I7 8TH GEN Lenovo X1 Carbon I7-8th   SSD-512 ","Lenovo X1 Carbon I7-8th   SSD-512 Ram-16","","1","3","3","3","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-12 02:11:33");
INSERT INTO tbl_item VALUES("263","ABA262P","LENOVO LAPTOP  CORE I7 7TH GEN Lenovo X1 Carbon I7 7th Ram-16 SSD","Lenovo X1 Carbon I7 7th Ram-16 SSD-256","","1","3","2","3","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-15 11:14:09");
INSERT INTO tbl_item VALUES("264","ABA263P","840 G6 Core I7 512/16 GB","HP Elitebook 840 G6 SSD-512 Ram-16GB","","1","3","","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-22 07:00:01");
INSERT INTO tbl_item VALUES("265","ABA264P","HP LAPTOP  CORE I7 8TH GEN HP ZBook 14U G6","HP ZBook 14U G6","","1","3","3","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 11:51:04");
INSERT INTO tbl_item VALUES("266","ABA265P","ASUS Vivobook LAPTOP  CORE I3 11TH GEN ASUS X515","ASUS X515","","1","2","6","4","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 02:37:00");
INSERT INTO tbl_item VALUES("267","ABA266P","ASUS LAPTOP  CORE I7 8TH GEN ASUS TUF Gaming FX504GM Nvidia GTX10","ASUS TUF Gaming FX504GM Nvidia GTX1060 ","","1","3","3","4","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 02:38:26");
INSERT INTO tbl_item VALUES("268","ABA267P","HP LAPTOP  CORE I5 8TH GEN HP 15-DA0XXX SSD-128Gb HDD-1Tb Ram-8GB","HP 15-DA0XXX SSD-128Gb HDD-1Tb Ram-8GB","","1","5","3","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 02:39:30");
INSERT INTO tbl_item VALUES("269","ABA268P","HP LAPTOP  CORE I5 6TH GEN HP 15-bc012TX GTX960 2GB","HP 15-bc012TX GTX960 2GB","","1","5","1","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 02:41:15");
INSERT INTO tbl_item VALUES("270","ABA269P","ASUS LAPTOP  RYZON 3 8TH GEN Asus Vivo Book ","Asus Vivo Book ","","1","6","3","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 07:24:04");
INSERT INTO tbl_item VALUES("271","ABA270P","HP 850 G5 Core I7 SSD 512 RAM 16 GB ","HP Elitebook 850 G5","","1","3","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-01-26 07:24:45");
INSERT INTO tbl_item VALUES("272","ABA271P","DELL LAPTOP  RYZON 5 11TH GEN Inspiron 15-3525 SSD 512 RAM 8 GB","Inspiron 15-3525 SSD 512 RAM 8 GB","","1","7","6","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-01-29 12:07:17");
INSERT INTO tbl_item VALUES("273","ABA272P","840 G3 I7 6th 256/8 GB","HP Elitebook 840 G3 Touch ","256/8","1","3","24","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-02-01 12:29:06");
INSERT INTO tbl_item VALUES("274","ABA273P","HP LAPTOP  CORE I7 8TH GEN HP Elitebook 1030 G5 Touch 360 ","HP Elitebook 1030 G5 Touch 360 ","SSD-512GB Ram-8GB","1","3","3","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-02-01 12:32:11");
INSERT INTO tbl_item VALUES("275","ABA274P","HP LAPTOP  CORE I7 8TH GEN Elitebook X360 1030 G5  Touch","Elitebook X360 1030 G5  Touch","SSD-512 SSD-8","1","3","3","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-02-01 12:41:15");
INSERT INTO tbl_item VALUES("276","ABA275P","DELL LAPTOP  CORE I5 6TH GEN DELL Inspiron 5559","DELL Inspiron 5559","","1","5","1","2","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-02-09 03:44:38");
INSERT INTO tbl_item VALUES("277","ABA276P","HP CHARGER    Charger -Type C HP","Charger -Type C HP","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-02-12 11:01:53");
INSERT INTO tbl_item VALUES("278","ABA277P","LENOVO CHARGER    Charger -Type C Lenovo","Charger -Type C Lenovo","","29","","","3","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-02-12 11:02:25");
INSERT INTO tbl_item VALUES("279","ABA278P","DELL CHARGER    Charger -Big-Original","Charger -Dell Big Pin","","29","","","2","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-02-12 11:03:05");
INSERT INTO tbl_item VALUES("280","ABA279P","HP CHARGER    Charger -HP Big Pin Copy","Charger -HP Big Pin","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-02-12 11:03:43");
INSERT INTO tbl_item VALUES("281","ABA280P","HP CHARGER    Charger -Original Blue Pin HP","Charger -Original Blue Pin HP","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-02-12 11:04:38");
INSERT INTO tbl_item VALUES("282","ABA281P","HP LAPTOP  CORE I7 11TH GEN HP Elitebook X360 1030 G9 ","HP Elitebook X360 1030 G9 ","","1","3","6","1","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-02-12 01:32:05");
INSERT INTO tbl_item VALUES("283","ABA282P","840 G8 Core I5 8/256","HP Elitebook 840 G8","","1","5","","1","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-02-12 01:33:36");
INSERT INTO tbl_item VALUES("284","ABA283P","LENOVO LAPTOP  CORE I7 11TH GEN Lenovo ThinkPad X1 Carbon ","Lenovo ThinkPad X1 Carbon ","","1","3","6","3","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-02-12 02:09:25");
INSERT INTO tbl_item VALUES("285","ABA284P","LENOVO LAPTOP  CORE I7 11TH GEN Lenovo ThinkPad X1 Carbon Touch","Lenovo ThinkPad X1 Carbon Touch","","1","3","6","3","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-02-12 02:10:03");
INSERT INTO tbl_item VALUES("286","ABA285P","LENOVO LAPTOP  CORE I5 10TH GEN Lenovo ThinkPad Yoga 910","Lenovo ThinkPad Yoga 910","","1","5","5","3","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-02-12 02:11:56");
INSERT INTO tbl_item VALUES("287","ABA286P","HP LAPTOP  CORE I7 9TH GEN HP Zbook Studio G5","HP Zbook Studio G5","SSD-512GB Ram-32GB","1","3","4","1","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-03-04 07:58:07");
INSERT INTO tbl_item VALUES("288","ABA287P","HP LAPTOP  CORE I5 7TH GEN HP 348 G4","HP 348 G5","","1","5","","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-03-09 10:43:43");
INSERT INTO tbl_item VALUES("289","ABA288P","HP LAPTOP  CORE I7 11TH GEN Dell XPS 13-9310","Dell XPS 13-9310","","1","3","","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-03-11 07:39:00");
INSERT INTO tbl_item VALUES("290","ABA289P","HP LAPTOP  CORE I5 11TH GEN HP Pavilion 15-EG0xxx","HP Pavilion 15-EG0xxx","","1","5","6","1","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-03-11 07:43:20");
INSERT INTO tbl_item VALUES("291","ABA290P","HP LAPTOP  CORE I5 11TH GEN Dell Vostro 5301","Dell Vostro 5301","SSD-256GB Ram-8GB","1","5","6","1","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2023-03-13 07:03:40");
INSERT INTO tbl_item VALUES("292","ABA291P","LENOVO LAPTOP  CORE I7 8TH GEN T490s Core I7 8th Gen 16 And 256","T490s Core I7 8th Gen 16 And 256","","1","3","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-03-18 06:16:46");
INSERT INTO tbl_item VALUES("293","ABA292P","LENOVO LAPTOP  CORE I5 8TH GEN T490s Core I5 8th Gen 256 And 8 GB","T490s Core I5 8th Gen 256 And 8 GB","","1","5","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-03-18 06:17:34");
INSERT INTO tbl_item VALUES("294","ABA293P","HP LAPTOP  CORE I3 11TH GEN HP Pavilion X360 I3 11th 256 And 8 GB","HP Pavilion X360 I3 11th 256 And 8 GB ","","1","2","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-03-18 06:19:14");
INSERT INTO tbl_item VALUES("295","ABA294P","HP LAPTOP  CORE I7 8TH GEN Lenovo Thinkpad T480s","Lenovo Thinkpad T480s","SSD-256 Ram-8GB","1","3","","3","","1","11","0","","","","","","0.00","0.00","0","1","1","5","2023-03-24 11:57:05");
INSERT INTO tbl_item VALUES("296","ABA295P","840 G6 Core I5 8th 256/8 GB","HP Elitebook 840 G6","256GB/8GB","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-03-30 02:26:12");
INSERT INTO tbl_item VALUES("297","ABA296P","LENOVO LAPTOP  CORE I7 6TH GEN Lenovo X1 Carbon","Lenovo X1 Carbon","256/16","1","3","1","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-04-01 07:21:21");
INSERT INTO tbl_item VALUES("298","ABA297P","LENOVO LAPTOP  CORE I5 6TH GEN Lenovo Thinlkpad T470S ","Lenovo Thinlkpad T470S ","256/8","1","5","1","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-04-09 10:57:36");
INSERT INTO tbl_item VALUES("299","ABA298P","LENOVO LAPTOP  CORE I7 6TH GEN Lenovo Thinkpad T460s","Lenovo Thinkpad T460s","256/8","1","3","1","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-04-13 10:01:08");
INSERT INTO tbl_item VALUES("300","ABA299P","LENOVO LAPTOP  CORE I7 6TH GEN Lenovo Thinkpad T470s","Lenovo Thinkpad T470s","256/8","1","3","1","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-04-30 07:09:09");
INSERT INTO tbl_item VALUES("301","ABA300P","ASUS LAPTOP  CORE I5 3RD GEN Asus P45 Core I5 3rd Gen 500 And 4 G","Asus P45 Core I5 3rd Gen 500 And 4 GB ","","1","5","9","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-05-04 08:05:59");
INSERT INTO tbl_item VALUES("302","ABA301P","APPLE LAPTOP  CORE I5  Apple Macbook Air A1466 2013","Apple Macbook Air A1466 2013","256/4","1","5","","6","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-06 12:29:31");
INSERT INTO tbl_item VALUES("303","ABA302P","APPLE LAPTOP  CORE I5  Apple Macbook Air A1466 2013","Apple Macbook Air A1466 2013","256/4","1","5","","6","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-06 12:29:34");
INSERT INTO tbl_item VALUES("304","ABA303P","APPLE LAPTOP  CORE I5  Apple MacBook  Pro-Retina A1502  2014","Apple MacBook  Pro-Retina A1502  2014","256/8","1","5","","6","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-06 12:33:39");
INSERT INTO tbl_item VALUES("305","ABA304P","Display 14 Ins","Laptop Display 14 Ins 30 Pin","","1","44","23","","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-05-11 06:34:01");
INSERT INTO tbl_item VALUES("306","ABA305P","HP LAPTOP  RYZON 5 10TH GEN  256/8","HP Pavilion 15-CS3XXX 256/8","","1","7","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-19 11:00:40");
INSERT INTO tbl_item VALUES("308","ABA306P","HP LAPTOP  CORE I5 10TH GEN HP Pavilion 15-CS3XXX","HP Pavilion 15-CS3XXX","SSD-256 Ram-8","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-19 11:10:27");
INSERT INTO tbl_item VALUES("309","ABA307P","APPLE PC  M1  Apple Mac Studio A2615","Apple Mac Studio A2615","32/512","16","33","","6","","1","12","0","","","","","","0.00","0.00","0","0","1","5","2023-05-25 04:27:30");
INSERT INTO tbl_item VALUES("310","ABA308P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7490  8/256","Dell Latitude 7490 Touch","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-25 04:29:53");
INSERT INTO tbl_item VALUES("311","ABA309P","840 G5 256/16 Core I5 8th Gen","HP Elitebook 840 G5 256/16","256/16","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-25 04:32:55");
INSERT INTO tbl_item VALUES("312","ABA310P","ASUS LAPTOP  CORE I3 11TH GEN Asus  Vivobook Flip 14","Asus  Vivobook Flip 14","512/8","1","2","6","4","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-25 04:46:39");
INSERT INTO tbl_item VALUES("313","ABA311P","HP EliteBook 830 Core G5 16/256 GB ","Elite Book 830 G5 256/8 GB","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-05-26 05:27:22");
INSERT INTO tbl_item VALUES("314","ABA312P","LENOVO LAPTOP  CORE I5 8TH GEN Lenovo Thinkpad X1 Yoga 512/16","Lenovo Thinkpad X1 Yoga 256/16","","1","5","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-05-27 03:40:05");
INSERT INTO tbl_item VALUES("315","ABA313P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7490 Touch 8/256","Dell Latitude 7490 Touch 16/256","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-02 06:59:00");
INSERT INTO tbl_item VALUES("316","ABA314P","HP LAPTOP  CORE I7 8TH GEN HP ZBook 15U 16/512","HP ZBook 15U 16/512","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-04 09:45:38");
INSERT INTO tbl_item VALUES("317","ABA315P","HP LAPTOP  CORE I7 6TH GEN HP ZBook Work Station 16/512","HP ZBook Work Station 16/512","","1","3","1","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-04 09:47:17");
INSERT INTO tbl_item VALUES("318","ABA316P","840 G6 16/256","HP Elitebook 840 G6 16/512","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-05 05:33:43");
INSERT INTO tbl_item VALUES("319","ABA317P","LENOVO LAPTOP  CORE I7 8TH GEN Lenovo Thinkpad X1 Carbon 512/16","Lenovo Thinkpad X1 Carbon 512/16","","1","3","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-07 05:04:10");
INSERT INTO tbl_item VALUES("320","ABA318P","LENOVO LAPTOP  CORE I5 8TH GEN Lenovo Thinkpad T480 8/256","Lenovo Thinkpad T480 8/256","","1","5","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-12 02:47:53");
INSERT INTO tbl_item VALUES("321","ABA319P","HP LAPTOP  CORE I5 6TH GEN HP Elitebook 1040 G3 256/8","HP Elitebook 1040 G3 256/8","","1","5","1","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-12 03:04:50");
INSERT INTO tbl_item VALUES("322","ABA320P","HP LAPTOP  CORE I5 10TH GEN HP ZBook Firefly  14 G7 512/16","HP ZBook Firefly  14 G7 512/16","","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-15 02:23:40");
INSERT INTO tbl_item VALUES("323","ABA321P","HP Elite Book 830 G7 Core I5 512/16","HP Elitebook 830 G7 512/16","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-15 02:31:18");
INSERT INTO tbl_item VALUES("324","ABA322P","840 G2 Core I5  256/8","HP Elitebook 840 G2 256/8","","1","5","11","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-18 04:01:31");
INSERT INTO tbl_item VALUES("325","ABA323P","SAMSUNG LAPTOP  CORE I7 10TH GEN Samsung 950XCJ 512/16","Samsung 950XCJ 512/16","","1","3","5","14","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-19 04:06:27");
INSERT INTO tbl_item VALUES("326","ABA324P","HP LAPTOP  CORE I7 8TH GEN HP Spectre X360 Convetible 15-BL1XX 51","HP Spectre X360 Convetible 15-BL1XX 512/6","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-19 04:09:04");
INSERT INTO tbl_item VALUES("327","ABA325P","DELL LAPTOP  Core i9 9TH GEN Dell Precision 5540 512/16","Dell Precision 5540 512/16","","1","45","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-21 10:51:57");
INSERT INTO tbl_item VALUES("328","ABA326P","HP LAPTOP  CORE I5 11TH GEN HP Zbook Firefly 14 G8 16/512","HP Zbook Firefly 14 G8 16/512","","1","5","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-24 04:35:49");
INSERT INTO tbl_item VALUES("329","ABA327P","ACER LAPTOP  CORE I5 10TH GEN Acer Aspire 3 ","Acer Aspire 3 ","","1","5","5","5","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-06-24 04:44:03");
INSERT INTO tbl_item VALUES("330","ABA328P","HP LAPTOP  CORE I7 11TH GEN HP Zbook Firefly 14 G8 16/512","HP Zbook Firefly 14 G8 16/512","","1","3","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-06 04:49:15");
INSERT INTO tbl_item VALUES("331","ABA329P","HP LAPTOP  CORE I7 12th Gen HP Zbook Firefly 14 G8 16/512","HP Zbook Firefly 14 G8 16/512","","1","3","25","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-10 12:10:15");
INSERT INTO tbl_item VALUES("332","ABA330P","HP LAPTOP  CORE I7 11TH GEN HP ZBook 15U 16/512","HP ZBook 15U 16/512","","1","3","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-10 12:10:59");
INSERT INTO tbl_item VALUES("333","ABA331P","LENOVO LAPTOP  CORE I7 11TH GEN Lenovo Thinkpad X1 YOGA 16/256","Lenovo Thinkpad X1 YOGA 16/256","","1","3","6","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-10 12:25:18");
INSERT INTO tbl_item VALUES("334","ABA332P","HP LAPTOP  CORE I5 11TH GEN HP Elitebook 1030 G8 512/16","HP Elitebook 1030 G8 512/16","","1","5","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-10 12:27:19");
INSERT INTO tbl_item VALUES("335","ABA333P","HP LAPTOP  CORE I5 11TH GEN Probook 450 G9 I5 11th GEN","Probook 450 G9 I5 11th GEN","","1","5","6","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-07-13 06:55:08");
INSERT INTO tbl_item VALUES("336","ABA334P","HP LAPTOP  CORE I7 8TH GEN HP Zbook14U Touch 512/16","HP Zbook14U Touch 512/16","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-20 04:29:17");
INSERT INTO tbl_item VALUES("337","ABA335P","HP LAPTOP  CORE I5 10TH GEN HP Probook 640 G7 512/16","HP Probook 640 G7 512/16","","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-20 04:33:38");
INSERT INTO tbl_item VALUES("339","ABA337P","HP LAPTOP  CORE I7 6TH GEN HP Elitebook 1040 G3 512/16","HP Elitebook 1040 G3 512/16","","1","3","1","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-20 05:43:30");
INSERT INTO tbl_item VALUES("340","ABA338P","LENOVO LAPTOP  CORE I5 6TH GEN Lenovo Thinkpad Yoga 480 256/8","Lenovo Thinkpad Yoga 480 256/8","","1","5","1","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-28 01:04:00");
INSERT INTO tbl_item VALUES("341","ABA339P","LENOVO LAPTOP  CORE I7 8TH GEN Lenovo Thinkpad X380 Yoga 512/16","Lenovo Thinkpad X380 Yoga 512/16","","1","3","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-07-28 01:05:21");
INSERT INTO tbl_item VALUES("342","ABA340P","HP CHARGER    HP Charger Blue Pin Copy","HP Charger Blue Pin Copy","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:42:15");
INSERT INTO tbl_item VALUES("343","ABA341P"," CHARGER    Dell Charger Big Copy","Dell Charger Big Copy","","29","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:42:48");
INSERT INTO tbl_item VALUES("344","ABA342P","LENOVO CHARGER    Lenovo Charger USB Copy","Lenovo Charger USB Copy","","29","","","3","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:43:22");
INSERT INTO tbl_item VALUES("345","ABA343P","HP CHARGER    HP Charger Big Original","HP Charger Big Original","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:44:08");
INSERT INTO tbl_item VALUES("346","ABA344P","LENOVO CHARGER    Lenovo Charger USB Origibal","Lenovo Charger USB Origibal","","29","","","3","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:45:33");
INSERT INTO tbl_item VALUES("347","ABA345P","HP CHARGER    HP Charger Type C Copy","HP Charger Type C Copy","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:46:34");
INSERT INTO tbl_item VALUES("348","ABA346P","HP CHARGER    Lenovo Charger Type C","Lenovo Charger Type C","","29","","","1","","1","","0","","","","","","0.00","0.00","0","0","1","5","2023-08-04 01:47:17");
INSERT INTO tbl_item VALUES("349","ABA347P","840 G5 Core I7 8th Gen 256/8 GB","HP Elite Book 840 G5 Core I7 8 And 256","","1","3","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-08-12 07:04:03");
INSERT INTO tbl_item VALUES("350","ABA348P","840 G5 256/8 Core I7 8th Gen","HP ELitebook 840 G5 256/8","","1","3","","1","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2023-08-12 11:57:50");
INSERT INTO tbl_item VALUES("351","ABA349P","DELL LAPTOP 01 CORE I5 4TH GEN Dell Inspiron 5547","Dell Inspiron 5547","","1","5","8","2","","1","12","0","","","01","01","","0.00","0.00","30","1","1","5","2023-08-14 03:06:31");
INSERT INTO tbl_item VALUES("352","ABA350P","LENOVO LAPTOP  CORE I5 7TH GEN Lenovo X1 Tablet","Lenovo X1 Tablet","","1","5","2","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 03:08:23");
INSERT INTO tbl_item VALUES("353","ABA351P","LENOVO LAPTOP  CORE I5 8TH GEN Lenovo Yogabook","Lenovo Yogabook","","1","5","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 03:10:07");
INSERT INTO tbl_item VALUES("354","ABA352P","HP LAPTOP  CORE I5 8TH GEN HP Probook 440 G5","HP Probook 440 G5","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 03:11:45");
INSERT INTO tbl_item VALUES("355","ABA353P","840 G2 Core I5 Touch Screen 256/8","HP Elitebook 840 G2 Touch 256/8","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 06:54:45");
INSERT INTO tbl_item VALUES("356","ABA354P","HP LAPTOP  CORE I5 10TH GEN HP Probook 440 G7 1TB/256/8","HP Probook 440 G7 1TB/256/8","2GB GPU","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 06:56:26");
INSERT INTO tbl_item VALUES("357","ABA355P","HP LAPTOP  RYZON 5 5500U HP 14S-fq1xxx","HP 14S-fq1xxx","","1","7","26","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 06:58:35");
INSERT INTO tbl_item VALUES("358","ABA356P","HP LAPTOP  CORE I3 11TH GEN Asus ExpertBook B1500C 512/8","Asus ExpertBook B1500C 512/8","","1","2","6","4","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 06:59:50");
INSERT INTO tbl_item VALUES("359","ABA357P","APPLE LAPTOP  CORE I5 9TH GEN Mac Book Pro A 1707","Mac Book Pro A 1707","","1","5","4","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-08-14 07:18:09");
INSERT INTO tbl_item VALUES("360","ABA358P","HP LAPTOP  CORE I3 6TH GEN HP 15 Core I3 6th GEN ","HP 15 Core I3 6th GEN ","","1","2","1","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-08-26 04:42:21");
INSERT INTO tbl_item VALUES("361","ABA359P","840 G4 Core I7 256/8","HP Elitebook 840 G4 256/8","","1","3","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-27 02:30:15");
INSERT INTO tbl_item VALUES("362","ABA360P","HP LAPTOP  CORE I7 11TH GEN HP Pavilion 15  16/256","HP Pavilion 15  16/256","","1","3","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-08-28 04:12:58");
INSERT INTO tbl_item VALUES("363","ABA361P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 850 G5 256/8","HP Elitebook 850 G5 256/8","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-09-18 04:14:28");
INSERT INTO tbl_item VALUES("364","ABA362P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 1040 G5 512/16","HP Elitebook 1040 G5 512/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-09-20 01:15:52");
INSERT INTO tbl_item VALUES("365","ABA363P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 1030 G5","HP Elitebook 1030 G5","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-09-20 05:30:45");
INSERT INTO tbl_item VALUES("366","ABA364P","APPLE PC  CORE I7 10TH GEN Apple IMAC 2020 M1","Apple IMAC 2020 M1","","16","3","5","6","","1","12","0","","","","","","0.00","0.00","0","0","1","5","2023-09-21 12:54:59");
INSERT INTO tbl_item VALUES("367","ABA365P","Dell 3190 Pentium Silver 8 And 128","Dell 3190 Pentium Silver ","","1","39","","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-09-25 10:54:22");
INSERT INTO tbl_item VALUES("368","ABA366P","840 G6 Touch 8 And 256 Core I5 ","HP 840 G6 Touch 8 And 256","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-10-06 02:13:28");
INSERT INTO tbl_item VALUES("369","ABA367P"," SSD  M.2  128GB M.2 SSD","128GB M.2 SSD","","4","22","","","","","","0","","","","","","0.00","0.00","0","0","1","5","2023-10-08 04:26:44");
INSERT INTO tbl_item VALUES("370","ABA368P","     Keyboard","Keyboard","","","","","","","","","0","","","","","","0.00","0.00","0","0","1","5","2023-10-08 04:27:35");
INSERT INTO tbl_item VALUES("371","ABA369P","KINGSPEC SSD  SATA  Kingspec 256 GB Sata","Kingspec 256 GB Sata","","4","23","","22","","","","0","","","","","","0.00","0.00","0","0","1","5","2023-10-11 04:32:44");
INSERT INTO tbl_item VALUES("372","ABA370P","840 G6 I7 256/8 GB Touch Screen","Elite Book 840 G6 SSD 256 RAM 8 GB","","1","3","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2023-10-13 12:31:39");
INSERT INTO tbl_item VALUES("373","ABA371P","840 G9 Core I5 512/16","HP EliteBook 840 G9 256/16","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-10-26 07:58:29");
INSERT INTO tbl_item VALUES("374","ABA372P","840 G7 I5 256/16 ","HP EliteBook 840 G7 256/16","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-10-26 08:00:26");
INSERT INTO tbl_item VALUES("375","ABA373P","HP LAPTOP  RYZON 5 2500U HP Elitebook 830 G5 Ryzen","HP Elitebook 830 G5 Ryzen","","1","7","27","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2023-11-12 05:36:37");
INSERT INTO tbl_item VALUES("376","ABA374P","DELL LAPTOP  CORE I5 7TH GEN Dell Latitude 7490","Dell Latitude 7490","","1","5","2","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 12:06:07");
INSERT INTO tbl_item VALUES("377","ABA375P","HP Elitebook 1040 G5 256/8","HP Elitebook 1040 G5 256/8","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 12:07:52");
INSERT INTO tbl_item VALUES("378","ABA376P","HP LAPTOP  CORE I5 10TH GEN HP ZBook Firefly  14 G7 512/8","HP ZBook Firefly  14 G7 512/8","","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 12:12:24");
INSERT INTO tbl_item VALUES("379","ABA377P","Surface  LAPTOP  CORE I5 10TH GEN Microsoft Surface Laptop 3 256/","Microsoft Surface Laptop 3 256/8","","1","5","5","37","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 12:18:13");
INSERT INTO tbl_item VALUES("380","ABA378P","LENOVO LAPTOP  CORE I5 8TH GEN Lenovo ThinkPad T490","Lenovo ThinkPad T490","","1","5","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 12:27:19");
INSERT INTO tbl_item VALUES("381","ABA379P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 1040 G6 256/16","HP Elitebook 1040 G6 256/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 03:54:27");
INSERT INTO tbl_item VALUES("382","ABA380P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 1040 G6 256/8","HP Elitebook 1040 G6 256/8","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-04 04:03:02");
INSERT INTO tbl_item VALUES("383","ABA381P","DELL LAPTOP  CORE I5 7TH GEN Dell Latitude 5480","Dell Latitude 5480","","1","5","2","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-06 03:24:04");
INSERT INTO tbl_item VALUES("384","ABA382P","LENOVO LAPTOP  CORE I7 12th Generation Yoga 9I SSD 1TB RAM 16 GB","Yoga 9I ","","1","3","28","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-01-11 06:55:28");
INSERT INTO tbl_item VALUES("385","ABA383P","LENOVO LAPTOP  CORE I5 8TH GEN  Thinkpad T480s 256/8 Toush","Lenovo Thinkpad T480s 256/8","","1","5","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-13 06:47:50");
INSERT INTO tbl_item VALUES("386","ABA384P","LENOVO LAPTOP  CORE I5 7TH GEN Lenovo Thinkpad T470s","Lenovo Thinkpad T470s","","1","5","2","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-01-13 06:48:49");
INSERT INTO tbl_item VALUES("387","ABA385P","Apple Macbook A1706 2017   Core I7","Macbook","","1","3","","6","","1","12","0","","","A170","Apple","","0.00","0.00","30","1","1","5","2024-01-20 07:19:25");
INSERT INTO tbl_item VALUES("388","ABA386P","LENOVO  X1 Yoga CORE I5 7TH GEN Linovo X1 Yoga   I5 7th Gen 8gb/2","Linovo X1 Yoga   I5 7th Gen 8gb/256gb  360 Tuch","","1","5","","3","","1","12","0","","","x1 yoga","","","22500.00","24500.00","30","1","1","5","2024-02-03 06:23:24");
INSERT INTO tbl_item VALUES("389","ABA387P","HP LAPTOP  RYZON 7 2700U Probook 645 Ryzen 7-2700U G4 SSD 256 RAM","Probook 645 Ryzen 7-2700U G4 SSD 256 RAM 8 GB ","","1","8","29","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-02-07 12:21:46");
INSERT INTO tbl_item VALUES("390","ABA388P","DELL LAPTOP  CORE I7 8TH GEN 7490 Core I7 8th Gen 256/8 GB ","7490 Core I7 8th Gen 256/8 GB ","","1","3","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-02-07 12:40:28");
INSERT INTO tbl_item VALUES("391","ABA389P","DELL LAPTOP  CORE I7 8TH GEN 7490 Touch Core I7 8th Gen 256 And 8","7490 Touch Core I7 8th Gen 256 And 8 GB","","1","3","3","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-02-07 12:41:12");
INSERT INTO tbl_item VALUES("392","ABA390P","HP  640 G3 CORE I5 7TH GEN HP Probook 640 G3","HP Probook 640 G3","","1","5","","1","","19","12","0","","","640 g3","hp","","16000.00","19000.00","30","1","1","5","2024-02-10 03:01:13");
INSERT INTO tbl_item VALUES("393","ABA391P","HP LAPTOP  AMD PRO A12 9800B HP Elitebook 745 G4","HP Elitebook 745 G4","","1","46","30","1","","1","12","0","","","","HP","","0.00","0.00","0","1","1","5","2024-02-10 05:18:17");
INSERT INTO tbl_item VALUES("394","ABA392P","HP Elitebook 830 G5 Touch 256/8 ","HP 830 G5  Tuch","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","30","1","1","5","2024-02-17 10:48:15");
INSERT INTO tbl_item VALUES("395","ABA393P","HP LAPTOP 830 G6  CORE I5 8TH GEN HP 830 G6 Touch","HP 830 G6 Touch","","1","5","3","1","","1","12","0","","HP 830 g6 touch","830 G6 ","","","26000.00","29000.00","30","1","1","5","2024-02-19 12:24:30");
INSERT INTO tbl_item VALUES("396","ABA394P","840 G6 I7 8th 16/256","HP 840 G6 I7 8th","","1","3","","1","","1","12","0","","","i7 8th 16gb 256gb","","","28500.00","31500.00","30","1","1","5","2024-03-01 10:55:52");
INSERT INTO tbl_item VALUES("397","ABA395P","DDR 4 Speed 2666   16 GB","DDR 4 Speed 2666 8 GB","","22","21","","14","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-03-01 03:34:36");
INSERT INTO tbl_item VALUES("398","ABA396P","HP LAPTOP i7 10th 16/500gb CORE I7 10TH GEN HP Z Book Firefly 14g","HP Z Book Firefly 14g7 ","","1","3","5","1","","1","12","0","","","i7 10th 16/500gb","","","47000.00","52000.00","30","0","1","5","2024-03-02 12:14:58");
INSERT INTO tbl_item VALUES("399","ABA397P","HP LAPTOP I7 10th 16/512 Touch CORE I7 10TH  Z Book Firefly 14 G7","Z Book Firefly 14 G7 I7 10th Touch","","1","3","5","1","","1","12","0","","","i7 10th 16/512 touch","","","47000.00","52000.00","30","1","1","5","2024-03-02 12:26:02");
INSERT INTO tbl_item VALUES("400","ABA398P","HP LAPTOP  CORE I7 11TH GEN HP LAPTOP I7 11th 16/512 Touch CORE I","HP LAPTOP I7 11th 16/512 Touch CORE I7 11TH  Z Book Firefly 14 G7","","1","3","6","1","","","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-06 02:13:12");
INSERT INTO tbl_item VALUES("401","ABA399P","HP LAPTOP  CORE I7 11TH GEN HP Zbook Firefly  14 G8 Touch 512/16","HP Zbook Firefly  14 G8 Touch 512/16","","1","3","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-06 02:17:47");
INSERT INTO tbl_item VALUES("402","ABA400P","HP LAPTOP  CORE I3 8TH GEN HP Probook 430 G6 128/8","HP Probook 430 G6 128/8","","1","2","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-06 02:33:57");
INSERT INTO tbl_item VALUES("403","ABA401P","HP LAPTOP  CORE I3 8TH GEN HP Pavilion 15-X360 128/500/8","HP Pavilion 15-X360 128/500/8","","1","2","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-08 11:06:16");
INSERT INTO tbl_item VALUES("404","ABA402P","DELL LAPTOP  Core i9 8TH GEN Dell Precision 5530 I9 8th 512/32 Gb","Dell Precision 5530 I9 8th 512/32 Gb","","1","45","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-13 02:37:10");
INSERT INTO tbl_item VALUES("406","ABA404P","HP LAPTOP  Core I7 12th Gen HP Dragonfly G3 512/32","HP Dragonfly G3 512/32","","1","45","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-15 04:31:46");
INSERT INTO tbl_item VALUES("407","ABA405P","HP LAPTOP  Ryzen 5 4650U HP 845 G7 256/8","HP Elitebook 845 G7 256/8","","1","50","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-15 04:35:01");
INSERT INTO tbl_item VALUES("408","ABA406P","HP LAPTOP  Core I7 13th Gen HP Dragonfly G4 Touch 512/32.","HP Dragonfly G4 Touch 512/32.","","1","45","31","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-15 04:42:35");
INSERT INTO tbl_item VALUES("409","ABA407P","DELL LAPTOP  CORE I7 4TH GEN Dell XPS-13  9333 256/8gb ","Dell XPS-13  9333 256/8gb ","","1","3","8","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-16 01:13:52");
INSERT INTO tbl_item VALUES("410","ABA408P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 830 G6 512/8","HP Elitebook 830 G6 512/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-16 05:13:25");
INSERT INTO tbl_item VALUES("411","ABA409P","DELL LAPTOP  CORE I7 7TH GEN Dell XPS 13  9365 512/16","Dell XPS 13  9365 512/16","","1","3","2","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-17 02:45:57");
INSERT INTO tbl_item VALUES("412","ABA410P","Surface Laptop 3 16/256","Microcoft Surface Laptop 3 256/8","","1","5","","16","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-17 02:48:03");
INSERT INTO tbl_item VALUES("413","ABA411P","DELL LAPTOP  Pentium 8TH GEN Dell Latitude 3190 128/4","Dell Latitude 3190 128/4","","1","39","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-17 02:50:30");
INSERT INTO tbl_item VALUES("414","ABA412P","DELL LAPTOP  CORE I5 11TH GEN Inspiron 15 3511 512/8 Gb","Inspiron 15 3511 512/8 Gb","","1","5","6","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-22 07:08:06");
INSERT INTO tbl_item VALUES("415","ABA413P","840 G7 Core I5 256/8","HP Elitebook 840 G7 256/8","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-24 04:08:09");
INSERT INTO tbl_item VALUES("416","ABA414P","HP LAPTOP  CORE I5 7TH GEN HP Elitebook 850 G5 Touch 256/8 ","HP Elitebook 850 G5 Touch 256/8 ","","1","5","2","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-24 04:12:07");
INSERT INTO tbl_item VALUES("417","ABA415P","HP LAPTOP  CORE I7 8TH GEN HP 850 G6 256/8gb","HP 850 G6 256/8gb","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-27 04:52:09");
INSERT INTO tbl_item VALUES("418","ABA416P","HP LAPTOP  CORE I5 10TH GEN HP 850 G7 256/8 Gb","HP 850 G7 256/8 Gb","","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-27 04:54:07");
INSERT INTO tbl_item VALUES("419","ABA417P","HP LAPTOP  CORE I5 8TH GEN Elite- Dragonfly 512/16 Gb 360 Touch","Elitebook Dragonfly 512/16 Gb","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-27 04:57:10");
INSERT INTO tbl_item VALUES("420","ABA418P","HP LAPTOP  CORE I5 11TH GEN 850 G8 256/8 Gb","850 G8 ","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","2","1","5","2024-03-27 05:19:51");
INSERT INTO tbl_item VALUES("421","ABA419P","HP Battery  840 G3 ","HP 840 G3 Battery","","40","","","","","1","2","0","","","","","","1600.00","1800.00","0","1","1","5","2024-03-28 12:27:55");
INSERT INTO tbl_item VALUES("422","ABA420P","840 G7 I5 256/8Gb Touch Screen","HP 840 G7 256/8Gb Touch","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","2","1","5","2024-03-29 04:14:32");
INSERT INTO tbl_item VALUES("423","ABA421P","HP LAPTOP  CORE I5 8TH GEN Hp 1040 G5 256/8gb 360","Hp 1040 G5 256/8gb 360","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-29 04:52:23");
INSERT INTO tbl_item VALUES("424","ABA422P","840 G3 CORE I7 6TH 256/8 Gb","840 G3 Non Touch","","1","3","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-30 05:42:44");
INSERT INTO tbl_item VALUES("425","ABA423P","840 G4 Core I5 256/8 GB","840 G4 256/8gb","","1","5","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-30 05:49:45");
INSERT INTO tbl_item VALUES("426","ABA424P","HP LAPTOP  CORE I5 10TH GEN 850 G7 256/8 Gb Touch","850 G7 256/8 Gb Touch","","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-30 06:57:14");
INSERT INTO tbl_item VALUES("427","ABA425P","HP LAPTOP  CORE I5 8TH GEN 850 G5 256/8gb Touch","850 G5 256/8gb Touch","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-30 06:58:31");
INSERT INTO tbl_item VALUES("428","ABA426P","HP LAPTOP  CORE I7 8TH GEN 850 G6 256/8gb Touch","850 G6 256/8gb Touch","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-30 06:59:44");
INSERT INTO tbl_item VALUES("429","ABA427P","840 G6 256/8 GB Touch Screen Core I5","840 G6 256/8gb Touch","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-30 07:04:07");
INSERT INTO tbl_item VALUES("430","ABA428P","LENOVO LAPTOP  CORE I5 8TH GEN T490  Touch 16/512","T490 Core I5 8th Generation 16/512","","1","5","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-03-31 11:30:08");
INSERT INTO tbl_item VALUES("431","ABA429P","HP LAPTOP  CORE I5 8TH GEN HP EliteBook 850 G6 Touch 256/8","HP EliteBook 850 G6 Touch 256/8","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-03-31 05:07:35");
INSERT INTO tbl_item VALUES("432","ABA430P","HP LAPTOP  CORE I5 8TH GEN 850 G6 I5 8th Non Touch 8/256","850 G6 I5 8th Non Touch 8/256","","1","5","3","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-04-01 12:33:39");
INSERT INTO tbl_item VALUES("433","ABA431P","ASUS LAPTOP  CORE I5 11TH GEN VIVO Book 14 Core I5 11th 512/8 GB","VIVO Book 14 Core I5 11th 512/8 GB","","1","5","6","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-04-01 05:52:52");
INSERT INTO tbl_item VALUES("434","ABA432P","HP LAPTOP  RYZON 5 5600U Pavilion 15 Ryzen 5-5625U 512/8 GB","Pavilion 15 Ryzen 5-5625U 512/8 GB","","1","7","22","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-04-01 05:55:38");
INSERT INTO tbl_item VALUES("435","ABA433P","HP LAPTOP  RYZON 5 5500U Pavilion 15 Ryzen 5-5625U 16/512","Pavilion 15 Ryzen 5-5625U 16/512","","1","7","26","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-04-02 05:51:45");
INSERT INTO tbl_item VALUES("436","ABA434P","HP LAPTOP  CORE I5 8TH GEN ZBook 14U Touch I5 8th 16/256 GB","ZBook 14U Touch I5 8th 16/256 GB","","1","5","3","1","","1","","0","","","","","VoeSyzbwkN1C24clMws73UwPK9SdlptgbDx1MTsJ_171230546","0.00","0.00","0","1","1","5","2024-04-05 02:24:25");
INSERT INTO tbl_item VALUES("437","ABA435P","Lenovo IP FLEX 3 Chromebook","Lenovo IP FLEX 3","","1","47","","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-17 07:13:17");
INSERT INTO tbl_item VALUES("438","ABA436P","HP 15-DY2xxx 256/8 GB","HP 15 -DY2xxx 256/8 GB","","1","5","34","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-17 07:14:50");
INSERT INTO tbl_item VALUES("439","ABA437P","LENOVO LAPTOP  CORE I5 7TH GEN Lenovo Thinkpad T470 256/8Gb","Lenovo Thinkpad T470 256/8Gb","","1","5","2","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-17 07:17:18");
INSERT INTO tbl_item VALUES("440","ABA438P","LENOVO LAPTOP  CORE I7 10TH GEN L 14 512/16 Gb","L 14 512/16 Gb","","1","3","5","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-19 02:52:59");
INSERT INTO tbl_item VALUES("441","ABA439P","LENOVO LAPTOP  CORE I7 10TH GEN  L-14 256/16 Gb","Lenovo L-14 256/16 Gb","","1","3","5","3","","1","12","0","","","","","","34500.00","40500.00","0","1","1","5","2024-04-19 03:25:13");
INSERT INTO tbl_item VALUES("442","ABA440P","LENOVO LAPTOP  CORE I7 8TH GEN T490 8/256 I7 8th Generation","T490 8/256 I7 8th Generation","","1","3","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-04-21 12:34:36");
INSERT INTO tbl_item VALUES("443","ABA441P","KINGSPACE SSD  512 GB  M.2 NVME 512gb","M.2 NVME 512gb","","4","37","","11","","1","2","0","","","","","","0.00","0.00","0","1","1","5","2024-04-21 01:10:55");
INSERT INTO tbl_item VALUES("444","ABA442P","LENOVO LAPTOP  CORE I7 8TH GEN T490 Core I7 8th Generation 16/512","T490 Core I7 8th Generation 16/512","","1","3","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-22 12:20:26");
INSERT INTO tbl_item VALUES("445","ABA443P","LENOVO LAPTOP  CORE I7 8TH GEN I7 8th Gn 256/8gb","I7 8th Gn 256/8gb","","1","3","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-22 12:23:42");
INSERT INTO tbl_item VALUES("446","ABA444P","LENOVO LAPTOP  CORE I7 8TH GEN Lenovo ThinkPad T490s 256/8","Lenovo ThinkPad T490s 256/8","","1","3","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-22 03:05:26");
INSERT INTO tbl_item VALUES("447","ABA445P","MICROSOFT LAPTOP  CORE I7 10TH GEN Microsoft Surface Laptop 3 16/","Microsoft Surface Laptop 3 16/256","","1","3","5","16","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-24 11:38:18");
INSERT INTO tbl_item VALUES("448","ABA446P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7490 256/8","Dell Latitude 7490 256/8","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-24 11:45:46");
INSERT INTO tbl_item VALUES("449","ABA447P","LENOVO LAPTOP  RYZON 7 Pro 4750U Lenovo Thinkpad T14 256/16","Lenovo Thinkpad T14 256/16","","1","8","35","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-24 11:56:42");
INSERT INTO tbl_item VALUES("450","ABA448P","MICROSOFT LAPTOP  CORE I5 11TH GEN Surface Laptop 4 16/256","Surface Laptop 4 16/256","","1","5","6","16","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-24 06:26:02");
INSERT INTO tbl_item VALUES("451","ABA449P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 830 G6 256/8","HP Elitebook 830 G6 256/8","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:00:30");
INSERT INTO tbl_item VALUES("452","ABA450P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 830 G6 256/16","HP Elitebook 830 G6 256/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:01:17");
INSERT INTO tbl_item VALUES("453","ABA451P","HP LAPTOP  CORE I5 8TH GEN HP Elitebook 830 G6 Touch 256/16","HP Elitebook 830 G6 Touch 256/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:04:32");
INSERT INTO tbl_item VALUES("454","ABA452P","HP LAPTOP  CORE I5 8TH GEN HP EliteBook 830 G6 Touch 512/16","HP EliteBook 830 G6 Touch 512/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:09:39");
INSERT INTO tbl_item VALUES("455","ABA453P","HP LAPTOP  CORE I7 8TH GEN HP Elitebook 830 G6  Touch  256/8","HP Elitebook 830 G6  Touch  256/8","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:12:12");
INSERT INTO tbl_item VALUES("456","ABA454P","HP LAPTOP  CORE I5 10TH GEN HP Elitebook 830 G7 X360 512/16","HP Elitebook 830 G7 X360 512/16","","1","5","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:13:59");
INSERT INTO tbl_item VALUES("457","ABA455P","HP LAPTOP  CORE I5 3RD GEN HP Elitebook 9470m 128/8","HP Elitebook 9470m 128/8","","1","5","9","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-25 05:30:15");
INSERT INTO tbl_item VALUES("458","ABA456P","ASUS Chromebook CX22N ","ASUS CX22N","","1","47","","4","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-27 05:27:34");
INSERT INTO tbl_item VALUES("459","ABA457P","840 G6 Core I5 512/16","HP Elitebook 840 G6 512/16","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-27 07:20:48");
INSERT INTO tbl_item VALUES("460","ABA458P","SSD  512 GB  SSD 512 M.2 Dubai","SSD 512 M.2 Dubai","","4","37","","","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-28 02:12:24");
INSERT INTO tbl_item VALUES("461","ABA459P","LENOVO LAPTOP  CORE I7 8TH GEN T490 Core I7 8th Gen 16/256","T490 Core I7 8th Gen 16/256","","1","3","3","3","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-04-28 02:44:33");
INSERT INTO tbl_item VALUES("462","ABA460P","APPLE Mobile    I Phone 11 ROM 128 GB","I Phone 11 ROM 128 GB","","33","","","6","","1","","0","","","","","","0.00","0.00","0","2","1","5","2024-04-29 01:58:53");
INSERT INTO tbl_item VALUES("463","ABA461P","HP LAPTOP  CORE I5 8TH GEN 830 G5  256/16 Gb","830 G5  256/16 Gb","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-04-29 07:27:30");
INSERT INTO tbl_item VALUES("464","ABA462P","Pentium 8TH GEN HP ProBook X360 11E 128/4 GB","HP ProBook X 360 128/4gb","","1","39","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-02 07:05:33");
INSERT INTO tbl_item VALUES("465","ABA463P","HP Stream PRO G3 4/64","HP Stream PRO G3 14 SSD 64 RAM 4 GB ","","1","41","","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-05-03 07:04:38");
INSERT INTO tbl_item VALUES("466","ABA464P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7400  256/8 Gb","Dell Latitude 7400  256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-04 06:14:27");
INSERT INTO tbl_item VALUES("467","ABA465P","DELL LAPTOP  CORE I5 10TH GEN Dell Precision 3550 256/16 Gb","Dell Precision 3550 256/16 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 06:07:24");
INSERT INTO tbl_item VALUES("468","ABA466P","DELL LAPTOP  CORE I7 9TH GEN Dell Precision 7740 512/32 Gb ","Dell Precision 7740 512/32 Gb ","","1","3","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 06:09:28");
INSERT INTO tbl_item VALUES("469","ABA467P","DELL LAPTOP  XEON 10TH GEN Dell Precision 7750 64/512","Dell Precision 7750 64/512","","1","48","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 07:48:52");
INSERT INTO tbl_item VALUES("470","ABA468P","DELL LAPTOP  XEON 10TH GEN Dell Precision 7750 32/512","Dell Precision 7750 32/512","","1","48","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 07:49:41");
INSERT INTO tbl_item VALUES("471","ABA469P","DELL LAPTOP  CORE I7 9TH GEN Dell Precision 5540 16/512","Dell Precision 5540 16/512","","1","3","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 07:50:51");
INSERT INTO tbl_item VALUES("472","ABA470P","DELL LAPTOP  CORE I5 8TH GEN Dell Precision 3540 16/","Dell Precision 3540 16/","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 07:53:51");
INSERT INTO tbl_item VALUES("473","ABA471P","DELL LAPTOP  Core i9 10TH GEN Dell Precision 5550 64/512","Dell Precision 5550 64/512","","1","45","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 07:55:16");
INSERT INTO tbl_item VALUES("474","ABA472P","DELL LAPTOP  CORE I7 10TH GEN Dell Precision 5550 16/256","Dell Precision 555016/256","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 07:59:47");
INSERT INTO tbl_item VALUES("475","ABA473P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7400  16/256 ","Dell Latitude 7400  16/256 ","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 08:04:03");
INSERT INTO tbl_item VALUES("476","ABA474P","DELL LAPTOP  CORE I7 8TH GEN Dell Precision 7400 8/512","Dell Precision 7400 8/512","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-06 08:04:55");
INSERT INTO tbl_item VALUES("477","ABA475P","APPLE Mobile  12 Pro 128 GB I Phone 12 Pro 128 GB","I Phone 12 Pro 128 GB","","33","49","17","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-05-08 12:23:07");
INSERT INTO tbl_item VALUES("478","ABA476P","DELL LAPTOP  CORE I7 8TH GEN Dell Precision 5530 512/32","Dell Precision 5530 512/32","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-08 02:06:44");
INSERT INTO tbl_item VALUES("479","ABA477P","DELL LAPTOP  CORE I5 10TH GEN Dell  Precision 5550 512/16","Dell  Precision 5550 512/16","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-08 02:09:28");
INSERT INTO tbl_item VALUES("480","ABA478P","DELL LAPTOP  CORE I7 10TH GEN Dell Precision 5551 512/32","Dell Precision 5551 512/32","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-08 02:11:40");
INSERT INTO tbl_item VALUES("481","ABA479P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7400  16/512","Dell Latitude 7400  16/512","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-08 02:19:09");
INSERT INTO tbl_item VALUES("482","ABA480P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 5300  256/8","Dell Latitude 5300  256/8","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-09 01:17:39");
INSERT INTO tbl_item VALUES("483","ABA481P","HP LAPTOP  CORE I3 8TH GEN 830 G6 256/8 Gb","830 G6 256/8 Gb","","1","2","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-09 06:58:31");
INSERT INTO tbl_item VALUES("484","ABA482P","DELL LAPTOP  CORE I5 6TH GEN Dell Latitude 7400  256/8 Gb","Dell Latitude 7400  256/8 Gb","","1","5","1","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-10 07:21:35");
INSERT INTO tbl_item VALUES("485","ABA483P","DELL LAPTOP  CORE I7 10TH GEN Dell Precision 5550 512/32 GB","Dell Precision 5550 1TB/32 GB","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-10 07:25:37");
INSERT INTO tbl_item VALUES("486","ABA484P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 5511  1TB/32GB","Dell Latitude 5511  1TB/32GB","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-10 07:28:40");
INSERT INTO tbl_item VALUES("487","ABA485P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7400  Touch 512/16 Gb","Dell Latitude 7400  Touch 512/16 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-11 04:30:18");
INSERT INTO tbl_item VALUES("488","ABA486P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7400  Touch 256/8 Gb","Dell Latitude 7400  Touch 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-12 04:38:46");
INSERT INTO tbl_item VALUES("489","ABA487P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5300 Touch  256/16gb","Dell Latitude 5300 Touch  256/16gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-12 04:50:46");
INSERT INTO tbl_item VALUES("490","ABA488P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 5400  256/16 Gb","Dell Latitude 5400  256/16 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-12 04:53:43");
INSERT INTO tbl_item VALUES("491","ABA489P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5400  256/16 Gb","Dell Latitude 5400  256/16 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-12 04:58:44");
INSERT INTO tbl_item VALUES("492","ABA490P","DELL LAPTOP  CORE I7 8TH GEN Dell Precision 5530  512/16 Gb","Dell Precision 5530  512/16 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-12 05:02:29");
INSERT INTO tbl_item VALUES("493","ABA491P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7400  Touch 256/8 Gb","Dell Latitude 7400  Touch 256/8 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-15 02:38:52");
INSERT INTO tbl_item VALUES("494","ABA492P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5400 Touch 256/8 Gb","Dell Latitude 5400 Touch 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-15 02:52:25");
INSERT INTO tbl_item VALUES("495","ABA493P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5300 Touch 256/8 Gb","Dell Latitude 5300 Touch 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-15 02:56:22");
INSERT INTO tbl_item VALUES("496","ABA494P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5300  X360 256/8 Gb","Dell Latitude 5300  X360 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-15 03:02:36");
INSERT INTO tbl_item VALUES("497","ABA495P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7400 X360 Touch16/512","Dell Latitude 7400 X360 Touch16/512","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-15 04:19:28");
INSERT INTO tbl_item VALUES("498","ABA496P","HP LAPTOP  CORE I7 8TH GEN HP 830 G6 256/8gb","HP 830 G6 256/8gb","","1","3","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-15 04:24:43");
INSERT INTO tbl_item VALUES("499","ABA497P","SK Hynix RAM  DDR4 16 GB Laptop Ram 2666 V","Laptop Ram 2666 V","","22","21","36","17","","1","12","0","","","","","","2300.00","3000.00","0","1","1","5","2024-05-17 03:44:44");
INSERT INTO tbl_item VALUES("500","ABA498P","840 G3 Core I5 256/8 GB","HP 840 G3 8/256 Gb","","1","5","1","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-17 05:35:51");
INSERT INTO tbl_item VALUES("501","ABA499P","DELL LAPTOP  CORE I7 9TH GEN Dell Precision 7540 256/32","Dell Precision 7540 256/32","","1","3","4","2","","1","12","0","","","","","","0.00","0.00","30","1","1","5","2024-05-19 05:48:11");
INSERT INTO tbl_item VALUES("502","ABA500P","DELL LAPTOP  CORE I7 6TH GEN Dell Precision 7520 512/32","Dell Precision 7520 512/32","","1","3","1","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-19 05:49:35");
INSERT INTO tbl_item VALUES("503","ABA501P","DELL LAPTOP  CORE I7 8TH GEN Dell Precision 7730 32/","Dell Precision 7730 32/","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-19 05:50:24");
INSERT INTO tbl_item VALUES("504","ABA502P","APPLE LAPTOP  CORE I7 8TH GEN MacBook Air A2337","MacBook Air A2337","","1","3","3","6","","1","4","0","","","","","","0.00","0.00","0","1","1","5","2024-05-20 04:22:46");
INSERT INTO tbl_item VALUES("505","ABA503P","DELL LAPTOP  CORE I7 6TH GEN Dell Latitude 7470 Touch 256/8Gb","Dell Latitude 7470 Touch 256/8Gb","","1","3","1","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-26 03:58:30");
INSERT INTO tbl_item VALUES("506","ABA504P","840 G6 Core I5 Touch Screen 256/16 GB","HP EliteBook 840 G6 Touch 256/16 Gb","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-29 01:09:53");
INSERT INTO tbl_item VALUES("507","ABA505P","DELL LAPTOP  CORE I7 6TH GEN Dell Precision 7710 256/16 Gb","Dell Precision 7710 256/16 Gb","","1","3","1","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-05-29 01:17:23");
INSERT INTO tbl_item VALUES("508","ABA506P","APPLE Mobile  256 GB   13 Pro Max ","13 Pro Max ","","33","29","","6","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-05-29 06:59:35");
INSERT INTO tbl_item VALUES("509","ABA507P","KINGSPACE SSD  M.2  SSD 256 Gb M.2 ","SSD 256 Gb M.2 ","","4","22","","11","","1","","0","","","","","","2300.00","2500.00","0","1","1","5","2024-06-01 03:51:23");
INSERT INTO tbl_item VALUES("510","ABA508P","KINGSPACE RAM  DDR4 8 GB Ram 8 Gb Ddr 4","Ram 8 Gb Ddr 4","","22","21","13","11","","1","2","0","","","","","","1900.00","2200.00","0","1","1","5","2024-06-01 04:29:35");
INSERT INTO tbl_item VALUES("511","ABA509P","KINGSPACE RAM  DDR4 8 GB Ram Laptop 8 GB DDR 4 32000 Mhz","Ram Laptop 8 GB DDR 4 32000 Mhz","","22","21","13","11","","1","2","0","","","","","","1900.00","2200.00","0","1","1","5","2024-06-01 04:38:40");
INSERT INTO tbl_item VALUES("512","ABA510P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5410 16/256","Dell Latitude 5410 16/256","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-07 01:52:58");
INSERT INTO tbl_item VALUES("513","ABA511P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 5410 8/256","Dell Latitude 5410 8/256","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-07 01:55:22");
INSERT INTO tbl_item VALUES("514","ABA512P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5500 256/8","Dell Latitude 5500 256/8","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-07 02:03:13");
INSERT INTO tbl_item VALUES("515","ABA513P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 5490 256/8","Dell Latitude 5490 256/8","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-07 02:07:13");
INSERT INTO tbl_item VALUES("516","ABA514P","FUJITSU LAPTOP  CORE I5 8TH GEN Fujitsu Life Book T939 I5 8th 256","Fujitsu Life Book T939 I5 8th 256/8 GB ","","1","5","3","7","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-06-09 07:04:53");
INSERT INTO tbl_item VALUES("517","ABA515P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 5410  512/16 Gb","Dell Latitude 5410  512/16 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 11:29:06");
INSERT INTO tbl_item VALUES("518","ABA516P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 5410  512/32 Gb","Dell Latitude 5410  512/32 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 11:30:52");
INSERT INTO tbl_item VALUES("519","ABA517P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5511  256/16 Gb","Dell Latitude 5511  256/16 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 11:38:19");
INSERT INTO tbl_item VALUES("520","ABA518P","DELL LAPTOP  CORE I7 9TH GEN Dell Latitude 5501 256/16 Gb","Dell Latitude 5501 256/16 Gb","","1","3","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 11:46:41");
INSERT INTO tbl_item VALUES("521","ABA519P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5510  256/16 Gb","Dell Latitude 5510  256/16 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 11:51:56");
INSERT INTO tbl_item VALUES("522","ABA520P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 5500  512/16 Gb","Dell Latitude 5500  512/16 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 12:08:20");
INSERT INTO tbl_item VALUES("523","ABA521P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 5500  256/8 Gb","Dell Latitude 5500  256/8 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 12:12:48");
INSERT INTO tbl_item VALUES("524","ABA522P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5500  256/16 Gb","Dell Latitude 5500  256/16 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 12:15:31");
INSERT INTO tbl_item VALUES("525","ABA523P","HP LAPTOP  CORE I3 13th Gen HP 250 G10 512/8 (Intact)","HP 250 G10 512/8 (Intact)","","1","2","31","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-10 05:21:29");
INSERT INTO tbl_item VALUES("526","ABA524P","HP LAPTOP  CORE I5 13th Gen HP 250 G10 512/8","HP 250 G10 512/8","","1","5","31","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-11 07:35:20");
INSERT INTO tbl_item VALUES("527","ABA525P","DELL LAPTOP  CORE I5 4th Gen Dell Latitude 6440  256/8 Gb","Dell Latitude 6440  256/8 Gb","","1","5","37","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 12:40:28");
INSERT INTO tbl_item VALUES("528","ABA526P","DELL LAPTOP  CORE I5 10TH GEN Dell Inspiron 5593 8/256 Gb","Dell Inspiron 5593 8/256 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 12:45:36");
INSERT INTO tbl_item VALUES("529","ABA527P","DELL LAPTOP  CORE I5 10TH GEN Dell Precession 7550 16/512 Gb","Dell Precession 7550 16/512 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:03:57");
INSERT INTO tbl_item VALUES("530","ABA528P","DELL LAPTOP  CORE I5 10TH GEN Dell Precision 7550  512/32 Gb","Dell Precision 7550  512/32 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:06:30");
INSERT INTO tbl_item VALUES("531","ABA529P","DELL LAPTOP  CORE I7 10TH GEN Dell Precision 7550 Touch 512/32 Gb","Dell Precision 7550 Touch 512/32 Gb ","","1","3","","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:08:47");
INSERT INTO tbl_item VALUES("532","ABA530P","DELL LAPTOP  CORE I7 10TH GEN Dell Precision 7550 Touch 512/64 Gb","Dell Precision 7550 Touch 512/64 Gb","","1","3","","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:10:06");
INSERT INTO tbl_item VALUES("533","ABA531P","     ","","","","","","","","","","0","","","","","","0.00","0.00","0","0","1","5","2024-06-13 01:10:15");
INSERT INTO tbl_item VALUES("534","ABA532P","DELL LAPTOP  CORE I7 11TH GEN Dell Latitude 7420  Touch 512/16 Gb","Dell Latitude 7420  Touch 512/16 Gb","","1","3","6","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:22:26");
INSERT INTO tbl_item VALUES("535","ABA533P","DELL LAPTOP  CORE I5 9TH GEN Dell Latitude 5401  256/16 Gb","Dell Latitude 5401  256/16 Gb","","1","5","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:28:50");
INSERT INTO tbl_item VALUES("536","ABA534P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7300  Touch 16/512 Gb","Dell Latitude 7300  Touch 16/512 Gb","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:46:42");
INSERT INTO tbl_item VALUES("537","ABA535P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 3390 256/8 Gb","Dell Latitude 3390 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:50:31");
INSERT INTO tbl_item VALUES("538","ABA536P","FUJITSU LAPTOP  CORE I5 8TH GEN Fujitsu Lifebook T939 Touch 256/8","Fujitsu Lifebook T939 Touch 256/8Gb ","","1","5","3","7","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 01:56:42");
INSERT INTO tbl_item VALUES("539","ABA537P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 5510  512/16 Gb","Dell Latitude 5510  512/16 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:32:56");
INSERT INTO tbl_item VALUES("540","ABA538P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 3310  Touch 256/8 Gb","Dell Latitude 3310  Touch 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:38:22");
INSERT INTO tbl_item VALUES("541","ABA539P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5310 Touch  256/16 Gb","Dell Latitude 5310 Touch  256/16 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:42:52");
INSERT INTO tbl_item VALUES("542","ABA540P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 5310 Touch 512/16 Gb","Dell Latitude 5310 Touch 512/16 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:44:30");
INSERT INTO tbl_item VALUES("543","ABA541P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 9410  Touch 16/512 Gb","Dell Latitude 9410  Touch 16/512 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:50:28");
INSERT INTO tbl_item VALUES("544","ABA542P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5411  256/16 Gb","Dell Latitude 5411  256/16 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:53:37");
INSERT INTO tbl_item VALUES("545","ABA543P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 7410 Touch 256/8 Gb","Dell Latitude 7410 Touch 256/8 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 05:57:41");
INSERT INTO tbl_item VALUES("546","ABA544P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 7410  Touch 512/8 Gb","Dell Latitude 7410  Touch 512/8 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 06:01:26");
INSERT INTO tbl_item VALUES("547","ABA545P","DELL LAPTOP  CORE I5 6TH GEN Dell Latitude 5480  256/8 Gb","Dell Latitude 5480  256/8 Gb","","1","5","1","2","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 06:05:54");
INSERT INTO tbl_item VALUES("548","ABA546P","DELL LAPTOP  CORE I5 9TH GEN Dell Latitude 5501  256/16 Gb","Dell Latitude 5501  256/16 Gb","","1","5","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 06:14:12");
INSERT INTO tbl_item VALUES("549","ABA547P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5290 Tab Touch 256/8 G","Dell Latitude 5290 Tab Touch 256/8 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-13 06:21:09");
INSERT INTO tbl_item VALUES("550","ABA548P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 7410  Touch 512/16","Dell Latitude 7410  Touch 512/16","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 12:52:42");
INSERT INTO tbl_item VALUES("551","ABA549P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 7410 1TB/32 Gb","Dell Latitude 7410 Touch 1TB/32 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 12:55:16");
INSERT INTO tbl_item VALUES("552","ABA550P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 3410  256/8 Gb","Dell Latitude 3410  256/8 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 01:34:22");
INSERT INTO tbl_item VALUES("553","ABA551P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 3400  256/16 Gb","Dell Latitude 3400  256/16 Gb","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 01:35:56");
INSERT INTO tbl_item VALUES("554","ABA552P","DELL LAPTOP  CORE I7 9TH GEN Dell Latitude 5401  256/16 Gb","Dell Latitude 5401  256/16 Gb","","1","3","4","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 01:37:56");
INSERT INTO tbl_item VALUES("555","ABA553P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 7310  Touch 256/8 Gb","Dell Latitude 7310  Touch 256/8 Gb","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 01:39:55");
INSERT INTO tbl_item VALUES("556","ABA554P","DELL LAPTOP  CORE I5 7TH GEN Dell Latitude 5590  128/8 Gb","Dell Latitude 5590  128/8 Gb","","1","5","2","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-23 01:44:55");
INSERT INTO tbl_item VALUES("557","ABA555P","HP LAPTOP  CORE I5 8TH GEN HP 830 G6 256/8gb","HP 830 G6 256/8gb","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-24 06:15:03");
INSERT INTO tbl_item VALUES("558","ABA556P","HP LAPTOP  CORE I5 11TH GEN HP ProBook 450 G8 512/16 Gb","HP ProBook 450 G8 512/16 Gb","","1","5","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-24 06:27:54");
INSERT INTO tbl_item VALUES("559","ABA557P","LENOVO LAPTOP  CORE I5 6TH GEN ThinkPad X1 Carbon 256/8 Gb","ThinkPad X1 Carbon 256/8 Gb","","1","5","1","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-24 06:37:49");
INSERT INTO tbl_item VALUES("560","ABA558P","HP LAPTOP  CORE I5 8TH GEN HP Z Book 14u G5 Touch 256/16 Gb","HP Z Book 14u G5 Touch 256/16 Gb","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-06-27 02:13:35");
INSERT INTO tbl_item VALUES("561","ABA559P","HP LAPTOP  CORE I7 8TH GEN 840 G5 Touch 256/8","840 G5 Touch 256/8","","1","3","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-07-07 06:28:03");
INSERT INTO tbl_item VALUES("562","ABA560P","HP LAPTOP  RYZEN 5 4650U HP 845 G7 AMD Ryzen 5 512/16 Gb","HP 845 G7 AMD Ryzen 5 512/16 ","","1","50","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-07-26 12:12:35");
INSERT INTO tbl_item VALUES("563","ABA561P","HP LAPTOP  CORE I5 11TH GEN HP 840 G8 512/16","HP 840 G8 512/16","","1","5","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-07-26 12:20:58");
INSERT INTO tbl_item VALUES("564","ABA562P","HP LAPTOP  CORE I5 8TH GEN HP 850 G6 512/16 Gb","HP 850 G6 512/16 Gb","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-07-26 12:26:13");
INSERT INTO tbl_item VALUES("565","ABA563P","HP LAPTOP  CORE I5 8TH GEN HP 850 G6 512/16 Gb Touch","HP 850 G6 512/16 Gb Touch","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-07-26 12:38:13");
INSERT INTO tbl_item VALUES("566","ABA564P"," Accessories  display  13.3 Display ","13.3 Display ","","41","44","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2024-07-27 02:20:05");
INSERT INTO tbl_item VALUES("567","ABA565P","HP LAPTOP  CORE I5 8TH GEN HP 850 G5  512/16 Gb  Touch","HP 850 G5  521/16 Gb  Touch","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-07-29 12:30:16");
INSERT INTO tbl_item VALUES("568","ABA566P","     Laptop Color ","Laptop Color ","","","","","","","1","","0","","","","","","0.00","0.00","0","0","1","5","2024-07-30 02:58:22");
INSERT INTO tbl_item VALUES("569","ABA567P","HP LAPTOP 7450 G5 AMD Ryzen 2500U  16/256 Gb","16/256 Gb","","1","52","","1","","1","12","0","","","7450 G5","","","0.00","0.00","30","1","1","5","2024-08-01 05:49:16");
INSERT INTO tbl_item VALUES("570","ABA568P","DELL LAPTOP  CORE I7 10TH GEN Dell Latitude 7310 Touch 360  512/1","Dell Latitude 7310 Touch 360  512/16 ","","1","3","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 10:57:12");
INSERT INTO tbl_item VALUES("572","ABA569P","DELL LAPTOP  CORE I5 11TH GEN Dell Latituide 5420 256/16","Dell Latituide 5420 256/16","","1","5","6","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 11:01:49");
INSERT INTO tbl_item VALUES("573","ABA570P","DELL LAPTOP  CORE I7 8TH GEN Dell Latitude 7300 Touch 8/512 ","Dell Latitude 7300 Touch 8/512 ","","1","3","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 11:07:45");
INSERT INTO tbl_item VALUES("574","ABA571P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 7410 Touch 8/512","Dell Latitude 7410 Touch 8/512","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 11:26:00");
INSERT INTO tbl_item VALUES("576","ABA573P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5310 Touch 512/16 Gb","Dell Latitude 5310 Touch 512/16 Gb","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 11:33:54");
INSERT INTO tbl_item VALUES("577","ABA574P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 5310 Touch 256/8","Dell Latitude 5310 Touch 256/8","","1","5","5","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 11:38:57");
INSERT INTO tbl_item VALUES("578","ABA575P","HP LAPTOP  CORE I5 5TH GEN HP Elitebook 840 G2 500/8","HP Elitebook 840 G2 500/8","","1","5","7","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:08:58");
INSERT INTO tbl_item VALUES("579","ABA576P","DELL LAPTOP  CORE I5 10TH GEN Dell Latitude 7210 512/16 Tab","Dell Latitude 7210 512/16","","1","5","","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:19:13");
INSERT INTO tbl_item VALUES("580","ABA577P","DELL LAPTOP  CORE I5 7TH GEN Dell Latitude 7212 Rugged 16/256","Dell Latitude 7212 Rugged 16/256","","1","5","2","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:26:37");
INSERT INTO tbl_item VALUES("581","ABA578P","LAPTOP  CORE I5 8TH GEN Dell Latitude 5420 Rugged 32/512","Dell Latitude 5420 Rugged 32/512","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:30:34");
INSERT INTO tbl_item VALUES("582","ABA579P","DELL LAPTOP  CORE I5 4TH GEN Dell Latitude 14 Rugged 256/8","Dell Latitude 14 Rugged 256/8","","1","5","8","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:33:36");
INSERT INTO tbl_item VALUES("583","ABA580P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 5424 Rugged 16/256","Dell Latitude 5424 Rugged 16/256","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:36:16");
INSERT INTO tbl_item VALUES("584","ABA581P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7424 Rugged 256/16","Dell Latitude 7424 Rugged 256/16","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:41:02");
INSERT INTO tbl_item VALUES("585","ABA582P","DELL LAPTOP  CORE I5 8TH GEN Dell Latitude 7212 Rugged 16/256","Dell Latitude 7212 Rugged 16/256","","1","5","3","2","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:44:14");
INSERT INTO tbl_item VALUES("586","ABA583P","MICROSOFT LAPTOP    Microsoft Surface Pro 7","Microsoft Surface Pro 7","","1","5","","16","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 12:55:13");
INSERT INTO tbl_item VALUES("588","ABA584P","MICROSOFT LAPTOP  CORE I7 8TH GEN Microsoft Surface Book 2 512/16","Microsoft Surface Book 2 512/16","","1","3","3","16","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-11 01:00:24");
INSERT INTO tbl_item VALUES("589","ABA585P","HP LAPTOP  CORE I7 5TH GEN 840 G2 I7 5th 256/8 Gb","840 G2 I7 5th 256/8 Gb","","1","3","7","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-18 05:29:34");
INSERT INTO tbl_item VALUES("590","ABA586P","ACER LAPTOP  Ryzen 5  AMD Ryzen 5 4600H 512/8 Gb","AMD Ryzen 5 4600H 512/8 Gb","","1","50","","5","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-22 02:11:09");
INSERT INTO tbl_item VALUES("591","ABA587P","ACER LAPTOP  CORE I5 9TH GEN Intel (R) 512 /8 Gb","Intel (R) 512 /8 Gb","","1","5","4","5","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-22 02:14:41");
INSERT INTO tbl_item VALUES("592","ABA588P","HP LAPTOP  CORE I7 11TH GEN 850 G8 512/16 Gb Touch","850 G8 512/16 Gb Touch","","1","3","6","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-23 12:30:42");
INSERT INTO tbl_item VALUES("593","ABA589P","HP LAPTOP  Ryzen 7  845 G8 Ryzen 7 5850u 256/8 Gb","845 G8 Ryzen 7 5850u 256/8 Gb","","1","53","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-25 07:00:06");
INSERT INTO tbl_item VALUES("594","ABA590P","HP LAPTOP  CORE I5 7TH GEN Zbook 14u Touch 256/8 Gb","Zbook 14u Touch 256/8 Gb","","1","5","2","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-08-25 07:41:23");
INSERT INTO tbl_item VALUES("595","ABA591P","HP LAPTOP  CORE I5 8TH GEN  Dragonfly256/8 Gb 360 Touch","HP Laptop Core I5 8th Gen Dragonfly256/8 Gb 360 Touch","","1","5","3","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-09-04 05:43:20");
INSERT INTO tbl_item VALUES("596","ABA592P","HP LAPTOP  845 G7 Ryzen 7 256/8 Gb","845 G7 Ryzen 7 256/8 Gb","","1","53","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-09-11 02:55:38");
INSERT INTO tbl_item VALUES("597","ABA593P","HP LAPTOP  CORE I7 10TH GEN Zbook 14u G7 Touch 512/16 Gb","Zbook 14u G7 Touch 512/16 Gb","","1","3","5","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-09-13 11:37:14");
INSERT INTO tbl_item VALUES("598","ABA594P","HP LAPTOP  Ryzen 3   745 G6 Ryzen 3 Pro 3300U 256/8 Gb","745 G6 Ryzen 3 Pro 3300U 256/8 Gb","","1","43","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-09-13 12:58:45");
INSERT INTO tbl_item VALUES("599","ABA595P","ASUS LAPTOP  CORE I5 10TH GEN Gaming Intel FX506LH 512/16 Gb","ASUS Gaming Intel FX506LH 512/16 Gb","","1","5","","4","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-09-21 02:24:42");
INSERT INTO tbl_item VALUES("600","ABA596P","HP LAPTOP  CORE I5 10TH GEN 840 G10 Core I5 10th 16/256","840 G10 Core I5 10th 16/256","","1","5","5","1","","1","","0","","","","","","0.00","0.00","0","1","1","5","2024-09-22 08:19:49");
INSERT INTO tbl_item VALUES("601","ABA597P","LENOVO LAPTOP  CORE I5 8TH GEN Lenovo T490s 256/16 Gb Touch","Lenovo T490s 256/16 Gb Touch","","1","5","3","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-09-29 06:59:12");
INSERT INTO tbl_item VALUES("602","ABA598P","HP LAPTOP  Ryzen 7  845 G7 Ryzen 7 4750 256/8 Gb","845 G7 Ryzen 7 4750 256/8 Gb","","1","53","","1","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-09-29 07:08:35");
INSERT INTO tbl_item VALUES("603","ABA599P","LENOVO LAPTOP  RYZON 5  Lenovo Yoga 6-13ALC6 Ryzen 5(5500u) 360 T","Lenovo Yoga 6-13ALC6 Ryzen 5(5500u) 360 Touch 256/8 Gb","","1","7","","3","","1","12","0","","","","","","0.00","0.00","0","1","1","5","2024-10-10 06:06:13");
INSERT INTO tbl_item VALUES("604","ABA600P","ASUS LAPTOP    ASUS ROG-ZEPHYRUS-G14 AMD Ryzen 9 5900HS 6gb Graph","ASUS ROG-ZEPHYRUS-G14 AMD Ryzen 9 5900HS 6gb Graphics 512/16 Gb","","1","","","4","","","12","0","","","","","","0.00","0.00","0","1","1","5","2024-10-10 06:13:40");



CREATE TABLE `tbl_journalde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `did` int(11) NOT NULL,
  `dtype` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `cid` int(11) NOT NULL,
  `ctype` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_journalde VALUES("29","0","29","93","CU","30000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("30","0","30","70","CU","39500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("31","0","31","72","CU","24000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("32","0","32","88","CU","335500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("33","0","33","71","CU","118000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("34","0","34","95","CU","94500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("35","0","35","97","CU","77500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("36","0","36","98","CU","74000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("37","0","37","86","CU","157000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("38","0","38","89","CU","53500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("39","0","39","99","CU","48000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("40","0","40","73","CU","32500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("41","0","41","87","CU","32000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("42","0","42","100","CU","25500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("43","0","43","101","CU","24000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("44","0","44","90","CU","30000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("45","0","45","70","CU","39500.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("46","0","46","2","SU","150000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("48","0","48","104","CU","16000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("49","0","49","47","LE","267000.00","2","SU","","","0","");
INSERT INTO tbl_journalde VALUES("50","0","50","102","CU","6000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("51","0","51","110","CU","29800.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("52","0","52","77","CU","17000.00","47","LE","","","0","");
INSERT INTO tbl_journalde VALUES("53","0","53","33","LE","5500.00","20","SU","","","0","adjust 840 G4");



CREATE TABLE `tbl_parent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_parent VALUES("1","LAPTOP","","","5","2021-11-17 12:58:48");
INSERT INTO tbl_parent VALUES("2","INTERNET SECURITY","","","5","2021-11-17 12:59:07");
INSERT INTO tbl_parent VALUES("3","HDD","","","5","2021-11-17 12:59:15");
INSERT INTO tbl_parent VALUES("4","SSD","","","5","2021-11-17 12:59:20");
INSERT INTO tbl_parent VALUES("5","MOUSE","","","5","2021-11-17 12:59:32");
INSERT INTO tbl_parent VALUES("6","HEADPHONE","","","5","2021-11-17 12:59:45");
INSERT INTO tbl_parent VALUES("7","HUB","","","5","2021-11-17 01:00:01");
INSERT INTO tbl_parent VALUES("8","ELITEBOOK","","","5","2021-11-18 10:57:44");
INSERT INTO tbl_parent VALUES("9","PROBOOK","","","5","2021-11-18 10:58:05");
INSERT INTO tbl_parent VALUES("10","PAVILION","","","5","2021-11-18 10:58:14");
INSERT INTO tbl_parent VALUES("11","LATITUDE","","","5","2021-11-18 10:58:40");
INSERT INTO tbl_parent VALUES("12","THINKPAD","","","5","2021-11-18 10:59:00");
INSERT INTO tbl_parent VALUES("13","SONICMASTER","","","5","2021-11-18 10:59:32");
INSERT INTO tbl_parent VALUES("14","VB-G","","","5","2021-12-03 02:28:44");
INSERT INTO tbl_parent VALUES("15","NOTEBOOK","","","5","2021-12-03 02:42:22");
INSERT INTO tbl_parent VALUES("16","PC","","","5","2021-12-05 02:06:29");
INSERT INTO tbl_parent VALUES("17","PAD","","","5","2021-12-05 02:09:18");
INSERT INTO tbl_parent VALUES("18","I PAD","","","5","2021-12-05 02:09:52");
INSERT INTO tbl_parent VALUES("19","INSPIRON","","","5","2021-12-05 03:59:41");
INSERT INTO tbl_parent VALUES("20","MICROSOFRT","","","5","2021-12-05 04:09:31");
INSERT INTO tbl_parent VALUES("21","SURFACE","","","5","2021-12-05 04:10:04");
INSERT INTO tbl_parent VALUES("22","RAM","","","5","2021-12-05 06:25:23");
INSERT INTO tbl_parent VALUES("23","GPS","","","5","2021-12-08 04:49:37");
INSERT INTO tbl_parent VALUES("24","KEYBOARD ","","","5","2021-12-09 11:37:22");
INSERT INTO tbl_parent VALUES("25","C-TYPE","","","5","2021-12-09 11:39:10");
INSERT INTO tbl_parent VALUES("26","SECOND","","","5","2021-12-09 11:42:14");
INSERT INTO tbl_parent VALUES("27","INTERNAL CD ROOM","","","5","2021-12-09 11:44:13");
INSERT INTO tbl_parent VALUES("28","SCREENGUARD ","","","5","2021-12-09 11:45:54");
INSERT INTO tbl_parent VALUES("29","CHARGER","","","5","2021-12-09 11:46:52");
INSERT INTO tbl_parent VALUES("30","ADAPTER","","","5","2021-12-09 11:47:27");
INSERT INTO tbl_parent VALUES("31","DATA CABLE","","","5","2021-12-09 11:48:12");
INSERT INTO tbl_parent VALUES("32","SCANNER","","","5","2021-12-29 11:15:40");
INSERT INTO tbl_parent VALUES("33","Mobile","","","5","2022-01-22 02:34:05");
INSERT INTO tbl_parent VALUES("34","Latitude 7390","","","5","2022-01-29 01:49:15");
INSERT INTO tbl_parent VALUES("35","Lenovo T440S Touch Screen","","","5","2022-01-30 01:55:14");
INSERT INTO tbl_parent VALUES("36","DELL Latitude E 7390","","Core i5 8th gen SSD 256 RAM 16 GB display 13.3 touch 360","5","2022-02-01 05:44:01");
INSERT INTO tbl_parent VALUES("37","HP Elite Book 840 G3 ","","Core i5 6th gen SSD 256 RAM 8GB ","5","2022-02-01 05:44:30");
INSERT INTO tbl_parent VALUES("38","HP 840 G4","","Core i5 7th gen SSD 256 RAM 8GB display touch","5","2022-02-01 05:45:04");
INSERT INTO tbl_parent VALUES("39","Laptop BAG","","","5","2022-06-13 03:56:15");
INSERT INTO tbl_parent VALUES("40","battery ","","","5","2022-10-30 05:49:03");
INSERT INTO tbl_parent VALUES("41","Accessories","","","5","2024-02-15 12:07:15");



CREATE TABLE `tbl_payvoucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_payvoucher VALUES("1","PAV120322101","","381000.00","2022-03-12","0","5","2022-03-12 05:49:56");
INSERT INTO tbl_payvoucher VALUES("3","PAV200322102","","100000.00","2022-03-20","0","5","2022-03-20 03:10:04");
INSERT INTO tbl_payvoucher VALUES("5","PAV250322101","","17000.00","2022-03-25","0","5","2022-03-25 12:04:03");
INSERT INTO tbl_payvoucher VALUES("7","PAV250322103","","4000.00","2022-03-25","0","5","2022-03-25 12:05:15");
INSERT INTO tbl_payvoucher VALUES("8","PAV250322104","","30000.00","2022-03-25","0","5","2022-03-25 05:09:55");
INSERT INTO tbl_payvoucher VALUES("9","PAV270322101","","66000.00","2022-03-27","0","5","2022-03-27 02:33:32");
INSERT INTO tbl_payvoucher VALUES("10","PAV060422101","","100000.00","2022-04-06","0","5","2022-04-06 03:32:28");
INSERT INTO tbl_payvoucher VALUES("11","PAV060422102","","50000.00","2022-04-06","0","5","2022-04-06 06:52:11");
INSERT INTO tbl_payvoucher VALUES("12","PAV070422101","","30000.00","2022-04-07","0","5","2022-04-07 07:09:20");
INSERT INTO tbl_payvoucher VALUES("13","PAV080422101","","95000.00","2022-04-08","0","5","2022-04-08 06:55:52");
INSERT INTO tbl_payvoucher VALUES("14","PAV090422101","","25000.00","2022-04-09","0","5","2022-04-09 12:27:48");
INSERT INTO tbl_payvoucher VALUES("15","PAV100422101","HP 840 G3 Return ","25000.00","2022-04-10","0","5","2022-04-10 03:22:48");
INSERT INTO tbl_payvoucher VALUES("16","PAV220422101","","10000.00","2022-04-22","0","5","2022-04-22 04:31:55");
INSERT INTO tbl_payvoucher VALUES("17","PAV230422101","","8000.00","2022-04-23","0","5","2022-04-23 04:42:11");
INSERT INTO tbl_payvoucher VALUES("18","PAV270422101","","5000.00","2022-04-27","0","5","2022-04-27 04:41:00");
INSERT INTO tbl_payvoucher VALUES("19","PAV280422101","","100000.00","2022-04-28","0","5","2022-04-28 03:18:42");
INSERT INTO tbl_payvoucher VALUES("20","PAV300422101","","75000.00","2022-04-30","0","5","2022-04-30 10:26:46");
INSERT INTO tbl_payvoucher VALUES("21","PAV300422102","","36000.00","2022-04-30","0","5","2022-04-30 10:27:36");
INSERT INTO tbl_payvoucher VALUES("22","PAV300422103","","18000.00","2022-04-30","0","5","2022-04-30 10:28:20");
INSERT INTO tbl_payvoucher VALUES("23","PAV120522101","","10000.00","2022-05-12","0","5","2022-05-12 02:53:33");
INSERT INTO tbl_payvoucher VALUES("24","PAV120522102","","20500.00","2022-05-12","0","5","2022-05-12 06:05:18");
INSERT INTO tbl_payvoucher VALUES("25","PAV180522101","","6000.00","2022-05-18","0","5","2022-05-18 08:00:22");
INSERT INTO tbl_payvoucher VALUES("26","PAV190522101","","180500.00","2022-05-19","0","5","2022-05-19 11:25:24");
INSERT INTO tbl_payvoucher VALUES("27","PAV190522102","","87500.00","2022-05-19","0","5","2022-05-19 11:26:36");
INSERT INTO tbl_payvoucher VALUES("28","PAV190522103","","87000.00","2022-05-19","0","5","2022-05-19 11:26:53");
INSERT INTO tbl_payvoucher VALUES("29","PAV190522104","","116000.00","2022-05-19","0","5","2022-05-19 11:27:35");
INSERT INTO tbl_payvoucher VALUES("30","PAV230522101","","56000.00","2022-05-23","0","5","2022-05-23 03:40:59");
INSERT INTO tbl_payvoucher VALUES("31","PAV260522101","","100000.00","2022-05-26","0","5","2022-05-26 12:57:09");
INSERT INTO tbl_payvoucher VALUES("32","PAV260522102","","44000.00","2022-05-26","0","5","2022-05-26 04:52:03");
INSERT INTO tbl_payvoucher VALUES("33","PAV270522101","","35000.00","2022-05-27","0","5","2022-05-27 07:03:48");
INSERT INTO tbl_payvoucher VALUES("34","PAV280522101","","37000.00","2022-05-28","0","5","2022-05-28 08:02:28");
INSERT INTO tbl_payvoucher VALUES("35","PAV020622101","","14200.00","2022-06-02","0","5","2022-06-02 03:04:43");
INSERT INTO tbl_payvoucher VALUES("36","PAV020622102","","38000.00","2022-06-02","0","5","2022-06-02 03:05:33");
INSERT INTO tbl_payvoucher VALUES("37","PAV030622101","","60000.00","2022-06-03","0","5","2022-06-03 01:49:00");
INSERT INTO tbl_payvoucher VALUES("38","PAV030622102","","63500.00","2022-06-03","0","5","2022-06-03 01:49:45");
INSERT INTO tbl_payvoucher VALUES("39","PAV030622103","","50000.00","2022-06-03","0","5","2022-06-03 01:50:49");
INSERT INTO tbl_payvoucher VALUES("40","PAV030622104","","34000.00","2022-06-03","0","5","2022-06-03 01:51:26");
INSERT INTO tbl_payvoucher VALUES("41","PAV030622105","","2000.00","2022-06-03","0","5","2022-06-03 01:51:42");
INSERT INTO tbl_payvoucher VALUES("42","PAV050622101","","97000.00","2022-06-05","0","5","2022-06-05 08:20:21");
INSERT INTO tbl_payvoucher VALUES("43","PAV050622102","","26500.00","2022-06-05","0","5","2022-06-05 08:20:54");
INSERT INTO tbl_payvoucher VALUES("44","PAV090622101","","18000.00","2022-06-09","0","5","2022-06-09 12:18:55");
INSERT INTO tbl_payvoucher VALUES("45","PAV090622102","","20000.00","2022-06-09","0","5","2022-06-09 07:57:29");
INSERT INTO tbl_payvoucher VALUES("46","PAV130622101","","100000.00","2022-06-13","0","5","2022-06-13 03:29:41");
INSERT INTO tbl_payvoucher VALUES("47","PAV150622101","","35000.00","2022-06-15","0","5","2022-06-15 07:25:43");
INSERT INTO tbl_payvoucher VALUES("48","PAV170622101","","28000.00","2022-06-17","0","5","2022-06-17 01:22:49");
INSERT INTO tbl_payvoucher VALUES("49","PAV170622102","","19000.00","2022-06-17","0","5","2022-06-17 01:25:08");
INSERT INTO tbl_payvoucher VALUES("50","PAV180622101","","50000.00","2022-06-18","0","5","2022-06-18 01:30:33");
INSERT INTO tbl_payvoucher VALUES("51","PAV180622102","","12000.00","2022-06-18","0","5","2022-06-18 07:35:36");
INSERT INTO tbl_payvoucher VALUES("52","PAV180622103","","8000.00","2022-06-18","0","5","2022-06-18 07:36:15");
INSERT INTO tbl_payvoucher VALUES("53","PAV180622104","","21500.00","2022-06-18","0","5","2022-06-18 07:37:46");
INSERT INTO tbl_payvoucher VALUES("54","PAV190622101","","20000.00","2022-06-19","0","5","2022-06-19 08:46:56");
INSERT INTO tbl_payvoucher VALUES("55","PAV200622101","","21500.00","2022-06-20","0","5","2022-06-20 07:58:39");
INSERT INTO tbl_payvoucher VALUES("56","PAV220622101","","25500.00","2022-06-22","0","5","2022-06-22 06:39:14");
INSERT INTO tbl_payvoucher VALUES("57","PAV220622102","","12000.00","2022-06-22","0","5","2022-06-22 08:04:19");
INSERT INTO tbl_payvoucher VALUES("58","PAV250622101","","10000.00","2022-06-25","0","5","2022-06-25 06:47:04");
INSERT INTO tbl_payvoucher VALUES("59","PAV270622101","","15000.00","2022-06-27","0","5","2022-06-27 02:42:19");
INSERT INTO tbl_payvoucher VALUES("60","PAV290622101","","54000.00","2022-06-29","0","5","2022-06-29 03:22:26");
INSERT INTO tbl_payvoucher VALUES("61","PAV300622101","","21000.00","2022-06-30","0","5","2022-06-30 08:20:45");
INSERT INTO tbl_payvoucher VALUES("62","PAV020722101","","70000.00","2022-07-02","0","5","2022-07-02 01:25:50");
INSERT INTO tbl_payvoucher VALUES("63","PAV020722102","","43000.00","2022-07-02","0","5","2022-07-02 01:26:06");
INSERT INTO tbl_payvoucher VALUES("64","PAV040722101","","12500.00","2022-07-04","0","5","2022-07-04 05:53:27");
INSERT INTO tbl_payvoucher VALUES("65","PAV050722101","","48000.00","2022-07-05","0","5","2022-07-05 12:28:57");
INSERT INTO tbl_payvoucher VALUES("66","PAV050722102","","3000.00","2022-07-05","0","5","2022-07-05 12:50:37");
INSERT INTO tbl_payvoucher VALUES("67","PAV080722101","","19000.00","2022-07-08","0","5","2022-07-08 01:03:25");
INSERT INTO tbl_payvoucher VALUES("68","PAV080722102","","43000.00","2022-07-08","0","5","2022-07-08 01:03:45");
INSERT INTO tbl_payvoucher VALUES("69","PAV120722101","","25000.00","2022-07-12","0","5","2022-07-12 03:19:06");
INSERT INTO tbl_payvoucher VALUES("70","PAV230722101","","28000.00","2022-07-23","0","5","2022-07-23 12:11:25");
INSERT INTO tbl_payvoucher VALUES("71","PAV240722101","","1000.00","2022-07-24","0","5","2022-07-24 05:21:18");
INSERT INTO tbl_payvoucher VALUES("72","PAV280722101","","19300.00","2022-07-28","0","5","2022-07-28 06:40:17");
INSERT INTO tbl_payvoucher VALUES("73","PAV280722102","","25500.00","2022-07-28","0","5","2022-07-28 06:40:57");
INSERT INTO tbl_payvoucher VALUES("74","PAV010822101","","23000.00","2022-08-01","0","5","2022-08-01 01:50:35");
INSERT INTO tbl_payvoucher VALUES("75","PAV090822101","","132000.00","2022-08-09","0","5","2022-08-09 11:10:18");
INSERT INTO tbl_payvoucher VALUES("76","PAV100822101","","200000.00","2022-08-10","0","5","2022-08-10 05:07:42");
INSERT INTO tbl_payvoucher VALUES("77","PAV140822101","","100000.00","2022-08-14","0","5","2022-08-14 03:47:11");
INSERT INTO tbl_payvoucher VALUES("78","PAV210822101","","400000.00","2022-08-21","0","5","2022-08-21 03:25:36");
INSERT INTO tbl_payvoucher VALUES("79","PAV220822101","","24500.00","2022-08-22","0","5","2022-08-22 01:51:01");
INSERT INTO tbl_payvoucher VALUES("80","PAV250822101","","44000.00","2022-08-25","0","5","2022-08-25 11:38:54");
INSERT INTO tbl_payvoucher VALUES("81","PAV290822101","","23500.00","2022-08-29","0","5","2022-08-29 06:57:37");
INSERT INTO tbl_payvoucher VALUES("82","PAV020922101","","145000.00","2022-09-02","0","5","2022-09-02 12:35:22");
INSERT INTO tbl_payvoucher VALUES("83","PAV020922102","","30000.00","2022-09-02","0","5","2022-09-02 12:37:16");
INSERT INTO tbl_payvoucher VALUES("84","PAV020922103","","70000.00","2022-09-02","0","5","2022-09-02 07:11:05");
INSERT INTO tbl_payvoucher VALUES("85","PAV030922101","","25000.00","2022-09-03","0","5","2022-09-03 02:10:52");
INSERT INTO tbl_payvoucher VALUES("86","PAV040922101","","200000.00","2022-09-04","0","5","2022-09-04 05:41:03");
INSERT INTO tbl_payvoucher VALUES("87","PAV070922101","","60000.00","2022-09-07","0","5","2022-09-07 11:40:02");
INSERT INTO tbl_payvoucher VALUES("88","PAV070922102","","50000.00","2022-09-07","0","5","2022-09-07 07:59:05");
INSERT INTO tbl_payvoucher VALUES("89","PAV080922101","","134500.00","2022-09-08","0","5","2022-09-08 12:21:29");
INSERT INTO tbl_payvoucher VALUES("90","PAV100922101","","143500.00","2022-09-10","0","5","2022-09-10 07:24:49");
INSERT INTO tbl_payvoucher VALUES("91","PAV110922101","","323500.00","2022-09-11","0","5","2022-09-11 02:51:40");
INSERT INTO tbl_payvoucher VALUES("92","PAV160922101","","3500.00","2022-09-16","0","5","2022-09-16 05:17:42");
INSERT INTO tbl_payvoucher VALUES("93","PAV300922101","","1221250.00","2022-09-30","0","5","2022-09-30 04:26:19");
INSERT INTO tbl_payvoucher VALUES("94","PAV041022101","","32500.00","2022-10-04","0","5","2022-10-04 01:52:44");
INSERT INTO tbl_payvoucher VALUES("95","PAV121022101","","45000.00","2022-10-12","0","5","2022-10-12 12:55:54");
INSERT INTO tbl_payvoucher VALUES("96","PAV121022102","","27600.00","2022-10-12","0","5","2022-10-12 12:58:08");
INSERT INTO tbl_payvoucher VALUES("97","PAV121022103","","29400.00","2022-10-12","0","5","2022-10-12 01:05:01");
INSERT INTO tbl_payvoucher VALUES("98","PAV191022101","","100000.00","2022-10-19","0","5","2022-10-19 07:00:48");
INSERT INTO tbl_payvoucher VALUES("99","PAV221022101","","67500.00","2022-10-22","0","5","2022-10-22 06:36:07");
INSERT INTO tbl_payvoucher VALUES("100","PAV281022101","","24000.00","2022-10-28","0","5","2022-10-28 07:50:37");
INSERT INTO tbl_payvoucher VALUES("101","PAV291022101","","549500.00","2022-10-29","0","5","2022-10-29 11:48:29");
INSERT INTO tbl_payvoucher VALUES("102","PAV301022101","","3907750.00","2022-10-30","0","5","2022-10-30 11:56:00");
INSERT INTO tbl_payvoucher VALUES("103","PAV111122101","","100000.00","2022-11-11","0","5","2022-11-11 01:20:42");
INSERT INTO tbl_payvoucher VALUES("104","PAV181122101","","116000.00","2022-11-18","0","5","2022-11-18 12:12:22");
INSERT INTO tbl_payvoucher VALUES("105","PAV281122101","","19000.00","2022-11-28","0","5","2022-11-28 11:42:40");
INSERT INTO tbl_payvoucher VALUES("106","PAV281122102","","494000.00","2022-11-28","0","5","2022-11-28 12:04:53");
INSERT INTO tbl_payvoucher VALUES("107","PAV031222101","","1500.00","2022-12-03","0","5","2022-12-03 05:43:51");
INSERT INTO tbl_payvoucher VALUES("108","PAV061222101","","25000.00","2022-12-06","0","5","2022-12-06 12:24:56");
INSERT INTO tbl_payvoucher VALUES("109","PAV061222102","","594500.00","2022-12-06","0","5","2022-12-06 12:25:21");
INSERT INTO tbl_payvoucher VALUES("110","PAV061222103","","116500.00","2022-12-06","0","5","2022-12-06 12:31:26");
INSERT INTO tbl_payvoucher VALUES("111","PAV071222101","","12000.00","2022-12-07","0","5","2022-12-07 02:08:33");
INSERT INTO tbl_payvoucher VALUES("112","PAV081222101","","100000.00","2022-12-08","0","5","2022-12-08 05:37:06");
INSERT INTO tbl_payvoucher VALUES("113","PAV111222101","","919000.00","2022-12-11","0","5","2022-12-11 11:18:34");
INSERT INTO tbl_payvoucher VALUES("114","PAV111222102","","28166.00","2022-12-11","0","5","2022-12-11 11:19:49");
INSERT INTO tbl_payvoucher VALUES("115","PAV111222103","","100000.00","2022-12-11","0","5","2022-12-11 05:31:36");
INSERT INTO tbl_payvoucher VALUES("116","PAV141222101","","90000.00","2022-12-14","0","5","2022-12-14 05:20:38");
INSERT INTO tbl_payvoucher VALUES("117","PAV191222101","","23000.00","2022-12-19","0","5","2022-12-19 11:54:06");
INSERT INTO tbl_payvoucher VALUES("119","PAV301222101","","54000.00","2022-12-30","0","5","2022-12-30 03:56:25");
INSERT INTO tbl_payvoucher VALUES("120","PAV060123101","","307500.00","2023-01-06","0","5","2023-01-06 02:23:57");
INSERT INTO tbl_payvoucher VALUES("121","PAV210123101","","7500.00","2023-01-21","0","5","2023-01-21 02:08:30");
INSERT INTO tbl_payvoucher VALUES("122","PAV260123101","","40000.00","2023-01-26","0","5","2023-01-26 07:31:37");
INSERT INTO tbl_payvoucher VALUES("123","PAV270123101","","50000.00","2023-01-27","0","5","2023-01-27 07:49:19");
INSERT INTO tbl_payvoucher VALUES("124","PAV270123102","","3000.00","2023-01-27","0","5","2023-01-27 07:49:41");
INSERT INTO tbl_payvoucher VALUES("125","PAV280123101","","42000.00","2023-01-28","0","5","2023-01-28 11:58:48");
INSERT INTO tbl_payvoucher VALUES("126","PAV290123101","","334000.00","2023-01-29","0","5","2023-01-29 08:12:50");
INSERT INTO tbl_payvoucher VALUES("127","PAV290123102","","4000.00","2023-01-29","0","5","2023-01-29 11:48:45");
INSERT INTO tbl_payvoucher VALUES("128","PAV290123103","","158500.00","2023-01-29","0","5","2023-01-29 11:51:41");
INSERT INTO tbl_payvoucher VALUES("129","PAV300123101","","38500.00","2023-01-30","0","5","2023-01-30 12:11:23");
INSERT INTO tbl_payvoucher VALUES("130","PAV300123102","","100000.00","2023-01-30","0","5","2023-01-30 07:36:56");
INSERT INTO tbl_payvoucher VALUES("131","PAV300123103","","86000.00","2023-01-30","0","5","2023-01-30 08:00:17");
INSERT INTO tbl_payvoucher VALUES("132","PAV010223101","","30000.00","2023-02-01","0","5","2023-02-01 10:32:11");
INSERT INTO tbl_payvoucher VALUES("133","PAV010223102","","60000.00","2023-02-01","0","5","2023-02-01 10:57:23");
INSERT INTO tbl_payvoucher VALUES("134","PAV020223101","","13200.00","2023-02-02","0","5","2023-02-02 11:51:23");
INSERT INTO tbl_payvoucher VALUES("135","PAV020223102","","154100.00","2023-02-02","0","5","2023-02-02 11:52:06");
INSERT INTO tbl_payvoucher VALUES("136","PAV030223101","","494000.00","2023-02-03","0","5","2023-02-03 06:04:45");
INSERT INTO tbl_payvoucher VALUES("137","PAV110223101","","32000.00","2023-02-11","0","5","2023-02-11 12:31:35");
INSERT INTO tbl_payvoucher VALUES("138","PAV160223101","","3976000.00","2023-02-16","0","5","2023-02-16 09:29:27");
INSERT INTO tbl_payvoucher VALUES("139","PAV190223101","","21000.00","2023-02-19","0","5","2023-02-19 12:38:56");
INSERT INTO tbl_payvoucher VALUES("140","PAV230223101","","100000.00","2023-02-23","0","5","2023-02-23 01:47:40");
INSERT INTO tbl_payvoucher VALUES("143","PAV140323101","","200000.00","2023-03-14","0","5","2023-03-14 01:04:52");
INSERT INTO tbl_payvoucher VALUES("144","PAV150323101","","90000.00","2023-03-15","0","5","2023-03-15 05:57:45");
INSERT INTO tbl_payvoucher VALUES("145","PAV160323101","","338300.00","2023-03-16","0","5","2023-03-16 10:55:16");
INSERT INTO tbl_payvoucher VALUES("146","PAV160323102","","22000.00","2023-03-16","0","5","2023-03-16 10:55:36");
INSERT INTO tbl_payvoucher VALUES("147","PAV170323101","","500.00","2023-03-17","0","5","2023-03-17 05:16:16");
INSERT INTO tbl_payvoucher VALUES("148","PAV190323101","","157000.00","2023-03-19","0","5","2023-03-19 12:25:55");
INSERT INTO tbl_payvoucher VALUES("149","PAV200323101","","9500.00","2023-03-20","0","5","2023-03-20 12:55:24");
INSERT INTO tbl_payvoucher VALUES("150","PAV200323102","","120000.00","2023-03-20","0","5","2023-03-20 01:03:17");
INSERT INTO tbl_payvoucher VALUES("151","PAV220323101","","2000000.00","2023-02-16","0","5","2023-03-22 11:14:08");
INSERT INTO tbl_payvoucher VALUES("152","PAV220323102","","7500000.00","2023-02-23","0","5","2023-03-22 11:51:26");
INSERT INTO tbl_payvoucher VALUES("153","PAV220323103","","140000.00","2023-03-22","0","5","2023-03-22 10:08:55");
INSERT INTO tbl_payvoucher VALUES("154","PAV230323101","","110000.00","2023-03-23","0","5","2023-03-23 05:32:59");
INSERT INTO tbl_payvoucher VALUES("155","PAV270323101","","20500.00","2023-03-27","0","5","2023-03-27 12:43:46");
INSERT INTO tbl_payvoucher VALUES("156","PAV270323102","","18500.00","2023-03-27","0","5","2023-03-27 12:47:10");
INSERT INTO tbl_payvoucher VALUES("157","PAV030423101","","19000.00","2023-04-03","0","5","2023-04-03 10:33:46");
INSERT INTO tbl_payvoucher VALUES("158","PAV040423101","","20000.00","2023-04-04","0","5","2023-04-04 10:49:49");
INSERT INTO tbl_payvoucher VALUES("159","PAV090423101","","19000.00","2023-04-09","0","5","2023-04-09 11:09:04");
INSERT INTO tbl_payvoucher VALUES("160","PAV130423101","","36000.00","2023-04-13","0","5","2023-04-13 11:36:03");
INSERT INTO tbl_payvoucher VALUES("161","PAV140423101","","28000.00","2023-04-14","0","5","2023-04-14 10:26:15");
INSERT INTO tbl_payvoucher VALUES("162","PAV190423101","","1370000.00","2023-04-19","0","5","2023-04-19 11:57:10");
INSERT INTO tbl_payvoucher VALUES("163","PAV190423102","","38000.00","2023-04-19","0","5","2023-04-19 01:01:25");
INSERT INTO tbl_payvoucher VALUES("164","PAV110523101","","490500.00","2023-05-11","0","5","2023-05-11 11:52:01");
INSERT INTO tbl_payvoucher VALUES("165","PAV140523101","","36000.00","2023-05-14","0","5","2023-05-14 11:23:49");
INSERT INTO tbl_payvoucher VALUES("166","PAV270523101","","39000.00","2023-05-27","0","5","2023-05-27 04:17:17");
INSERT INTO tbl_payvoucher VALUES("167","PAV070623101","","200000.00","2023-06-07","0","5","2023-06-07 04:13:06");
INSERT INTO tbl_payvoucher VALUES("168","PAV160623101","","19500.00","2023-06-16","0","5","2023-06-16 02:03:53");
INSERT INTO tbl_payvoucher VALUES("169","PAV210623101","","23000.00","2023-06-21","0","5","2023-06-21 10:55:00");
INSERT INTO tbl_payvoucher VALUES("170","PAV210623102","","6000.00","2023-06-21","0","5","2023-06-21 02:04:18");
INSERT INTO tbl_payvoucher VALUES("171","PAV070723101","","293000.00","2023-07-07","0","5","2023-07-07 04:11:20");
INSERT INTO tbl_payvoucher VALUES("172","PAV100723101","","930000.00","2023-07-10","0","5","2023-07-10 12:39:47");
INSERT INTO tbl_payvoucher VALUES("173","PAV170723101","","116000.00","2023-07-17","0","5","2023-07-17 11:05:49");
INSERT INTO tbl_payvoucher VALUES("174","PAV210723101","","28000.00","2023-07-21","0","5","2023-07-21 12:46:01");
INSERT INTO tbl_payvoucher VALUES("175","PAV210723102","","19500.00","2023-07-21","0","5","2023-07-21 12:49:38");
INSERT INTO tbl_payvoucher VALUES("176","PAV210723103","","500.00","2023-07-21","0","5","2023-07-21 12:52:06");
INSERT INTO tbl_payvoucher VALUES("177","PAV210723104","","19000.00","2023-07-21","0","5","2023-07-21 12:55:06");
INSERT INTO tbl_payvoucher VALUES("178","PAV270723101","","209000.00","2023-07-27","0","5","2023-07-27 06:31:06");
INSERT INTO tbl_payvoucher VALUES("179","PAV030823101","","250000.00","2023-08-03","0","5","2023-08-03 01:33:36");
INSERT INTO tbl_payvoucher VALUES("180","PAV040823101","","50000.00","2023-08-04","0","5","2023-08-04 11:43:54");
INSERT INTO tbl_payvoucher VALUES("181","PAV050823101","","25000.00","2023-08-05","0","5","2023-08-05 06:54:28");
INSERT INTO tbl_payvoucher VALUES("182","PAV060823101","","40000.00","2023-08-06","0","5","2023-08-06 02:15:40");
INSERT INTO tbl_payvoucher VALUES("183","PAV060823102","","50000.00","2023-08-06","0","5","2023-08-06 02:22:15");
INSERT INTO tbl_payvoucher VALUES("185","PAV120823101","","11000.00","2023-08-12","0","5","2023-08-12 03:02:12");
INSERT INTO tbl_payvoucher VALUES("186","PAV130823101","For Ledger Mistake Adjustment.","29000.00","2023-08-13","0","5","2023-08-13 11:33:21");
INSERT INTO tbl_payvoucher VALUES("187","PAV160823101","","20000.00","2023-08-16","0","5","2023-08-16 07:42:16");
INSERT INTO tbl_payvoucher VALUES("188","PAV180823101","","179000.00","2023-08-18","0","5","2023-08-18 02:12:59");
INSERT INTO tbl_payvoucher VALUES("189","PAV210823101","","175500.00","2023-08-21","0","5","2023-08-21 01:14:31");
INSERT INTO tbl_payvoucher VALUES("190","PAV230823101","","50000.00","2023-08-23","0","5","2023-08-23 12:51:40");
INSERT INTO tbl_payvoucher VALUES("191","PAV260823101","","40000.00","2023-08-26","0","5","2023-08-26 10:43:15");
INSERT INTO tbl_payvoucher VALUES("192","PAV280823101","","396000.00","2023-08-28","0","5","2023-08-28 05:48:03");
INSERT INTO tbl_payvoucher VALUES("193","PAV280823102","","1591000.00","2023-08-28","0","5","2023-08-28 05:51:19");
INSERT INTO tbl_payvoucher VALUES("194","PAV280823103","","19000.00","2023-08-28","0","5","2023-08-28 05:52:05");
INSERT INTO tbl_payvoucher VALUES("195","PAV280823104","","100000.00","2023-08-28","0","5","2023-08-28 07:25:24");
INSERT INTO tbl_payvoucher VALUES("196","PAV280823105","","20000.00","2023-08-28","0","5","2023-08-28 07:28:29");
INSERT INTO tbl_payvoucher VALUES("197","PAV280823106","","100000.00","2023-08-28","0","5","2023-08-28 07:39:46");
INSERT INTO tbl_payvoucher VALUES("198","PAV110923101","","300000.00","2023-09-11","0","5","2023-09-11 01:45:46");
INSERT INTO tbl_payvoucher VALUES("199","PAV160923101","","55000.00","2023-09-16","0","5","2023-09-16 01:04:56");
INSERT INTO tbl_payvoucher VALUES("200","PAV200923101","","150000.00","2023-09-20","0","5","2023-09-20 12:34:01");
INSERT INTO tbl_payvoucher VALUES("201","PAV200923102","","61000.00","2023-09-20","0","5","2023-09-20 04:08:27");
INSERT INTO tbl_payvoucher VALUES("202","PAV200923103","","150000.00","2023-09-20","0","5","2023-09-20 06:07:06");
INSERT INTO tbl_payvoucher VALUES("203","PAV200923104","","100000.00","2023-09-20","0","5","2023-09-20 06:21:58");
INSERT INTO tbl_payvoucher VALUES("205","PAV210923101","","12000000.00","2023-08-31","0","5","2023-09-21 02:09:19");
INSERT INTO tbl_payvoucher VALUES("206","PAV210923102","","9440000.00","2023-08-16","0","5","2023-09-21 02:10:19");
INSERT INTO tbl_payvoucher VALUES("207","PAV220923101","","25000.00","2023-09-22","0","5","2023-09-22 10:48:08");
INSERT INTO tbl_payvoucher VALUES("208","PAV220923102","","26000.00","2023-09-22","0","5","2023-09-22 10:49:37");
INSERT INTO tbl_payvoucher VALUES("209","PAV240923101","","100000.00","2023-09-24","0","5","2023-09-24 04:54:05");
INSERT INTO tbl_payvoucher VALUES("210","PAV240923102","","100000.00","2023-09-24","0","5","2023-09-24 07:46:52");
INSERT INTO tbl_payvoucher VALUES("211","PAV250923101","","20000.00","2023-09-25","0","5","2023-09-25 01:38:00");
INSERT INTO tbl_payvoucher VALUES("212","PAV280923101","","10000.00","2023-09-28","0","5","2023-09-28 07:36:13");
INSERT INTO tbl_payvoucher VALUES("213","PAV011023101","","12000.00","2023-10-01","0","5","2023-10-01 01:41:48");
INSERT INTO tbl_payvoucher VALUES("214","PAV031023101","","200000.00","2023-10-03","0","5","2023-10-03 12:11:30");
INSERT INTO tbl_payvoucher VALUES("215","PAV051023101","","100000.00","2023-10-05","0","5","2023-10-05 11:42:59");
INSERT INTO tbl_payvoucher VALUES("216","PAV061023101","","9500.00","2023-10-06","0","5","2023-10-06 07:34:16");
INSERT INTO tbl_payvoucher VALUES("217","PAV081023101","","44000.00","2023-10-08","0","5","2023-10-08 12:19:56");
INSERT INTO tbl_payvoucher VALUES("218","PAV091023101","","100000.00","2023-10-09","0","5","2023-10-09 07:18:54");
INSERT INTO tbl_payvoucher VALUES("219","PAV111023101","","50000.00","2023-10-11","0","5","2023-10-11 01:39:02");
INSERT INTO tbl_payvoucher VALUES("220","PAV111023102","","245000.00","2023-10-11","0","5","2023-10-11 01:43:36");
INSERT INTO tbl_payvoucher VALUES("221","PAV131023101","","50000.00","2023-10-13","0","5","2023-10-13 11:04:18");
INSERT INTO tbl_payvoucher VALUES("222","PAV181023101","","100000.00","2023-10-18","0","5","2023-10-18 01:12:05");
INSERT INTO tbl_payvoucher VALUES("223","PAV191023101","","200000.00","2023-10-19","0","5","2023-10-19 10:52:34");
INSERT INTO tbl_payvoucher VALUES("224","PAV191023102","","16000.00","2023-10-19","0","5","2023-10-19 10:52:56");
INSERT INTO tbl_payvoucher VALUES("225","PAV191023103","","69000.00","2023-10-19","0","5","2023-10-19 11:18:03");
INSERT INTO tbl_payvoucher VALUES("226","PAV191023104","","18000.00","2023-10-17","0","5","2023-10-19 06:00:57");
INSERT INTO tbl_payvoucher VALUES("227","PAV221023101","","80000.00","2023-10-22","0","5","2023-10-22 10:53:04");
INSERT INTO tbl_payvoucher VALUES("228","PAV221023102","","150000.00","2023-10-22","0","5","2023-10-22 10:59:16");
INSERT INTO tbl_payvoucher VALUES("229","PAV221023103","","250000.00","2023-10-22","0","5","2023-10-22 11:00:09");
INSERT INTO tbl_payvoucher VALUES("230","PAV011123101","","40000.00","2023-11-01","0","5","2023-11-01 06:32:36");
INSERT INTO tbl_payvoucher VALUES("231","PAV031123101","","600300.00","2023-11-03","0","5","2023-11-03 11:19:47");
INSERT INTO tbl_payvoucher VALUES("232","PAV031123102","","10500.00","2023-11-03","0","5","2023-11-03 01:05:37");
INSERT INTO tbl_payvoucher VALUES("233","PAV061123101","","150000.00","2023-11-06","0","5","2023-11-06 02:57:39");
INSERT INTO tbl_payvoucher VALUES("234","PAV121123101","","100000.00","2023-11-12","0","5","2023-11-12 06:39:07");
INSERT INTO tbl_payvoucher VALUES("235","PAV221123101","","100000.00","2023-11-22","0","5","2023-11-22 08:04:51");
INSERT INTO tbl_payvoucher VALUES("236","PAV281123101","","97500.00","2023-11-28","0","5","2023-11-28 07:19:14");
INSERT INTO tbl_payvoucher VALUES("237","PAV011223101","","20000.00","2023-12-01","0","5","2023-12-01 11:39:02");
INSERT INTO tbl_payvoucher VALUES("238","PAV011223102","","100000.00","2023-12-01","0","5","2023-12-01 12:25:19");
INSERT INTO tbl_payvoucher VALUES("239","PAV011223103","","50000.00","2023-12-01","0","5","2023-12-01 12:41:57");
INSERT INTO tbl_payvoucher VALUES("240","PAV011223104","","50000.00","2023-12-01","0","5","2023-12-01 12:42:23");
INSERT INTO tbl_payvoucher VALUES("241","PAV031223101","","50000.00","2023-12-03","0","5","2023-12-03 01:39:02");
INSERT INTO tbl_payvoucher VALUES("242","PAV151223101","","116366.00","2023-12-15","0","5","2023-12-15 03:02:37");
INSERT INTO tbl_payvoucher VALUES("243","PAV151223102","","136000.00","2023-12-15","0","5","2023-12-15 03:25:26");
INSERT INTO tbl_payvoucher VALUES("244","PAV201223101","","30000.00","2023-12-20","0","5","2023-12-20 05:34:01");
INSERT INTO tbl_payvoucher VALUES("245","PAV201223102","","15000.00","2023-12-20","0","5","2023-12-20 06:37:34");
INSERT INTO tbl_payvoucher VALUES("246","PAV201223103","","25000.00","2023-12-20","0","5","2023-12-20 07:02:46");
INSERT INTO tbl_payvoucher VALUES("247","PAV271223101","","50000.00","2023-12-27","0","5","2023-12-27 01:03:59");
INSERT INTO tbl_payvoucher VALUES("248","PAV281223101","","25000.00","2023-12-28","0","5","2023-12-28 07:14:05");
INSERT INTO tbl_payvoucher VALUES("249","PAV040124101","","50000.00","2024-01-04","0","5","2024-01-04 04:05:56");
INSERT INTO tbl_payvoucher VALUES("252","PAV050124101","","100000.00","2024-01-05","0","5","2024-01-05 05:30:40");
INSERT INTO tbl_payvoucher VALUES("253","PAV060124101","","40000.00","2024-01-06","0","5","2024-01-06 12:33:19");
INSERT INTO tbl_payvoucher VALUES("254","PAV060124102","","30000.00","2024-01-06","0","5","2024-01-06 01:00:58");
INSERT INTO tbl_payvoucher VALUES("255","PAV100124101","","20000.00","2024-01-10","0","5","2024-01-10 07:58:21");
INSERT INTO tbl_payvoucher VALUES("256","PAV100124102","","95000.00","2024-01-10","0","5","2024-01-10 09:26:28");
INSERT INTO tbl_payvoucher VALUES("257","PAV120124101","","2000.00","2024-01-12","0","5","2024-01-12 03:19:55");
INSERT INTO tbl_payvoucher VALUES("258","PAV120124102","","26000.00","2024-01-12","0","5","2024-01-12 04:14:12");
INSERT INTO tbl_payvoucher VALUES("259","PAV120124103","","50000.00","2024-01-12","0","5","2024-01-12 07:45:01");
INSERT INTO tbl_payvoucher VALUES("260","PAV120124104","","50000.00","2024-01-12","0","5","2024-01-12 08:06:59");
INSERT INTO tbl_payvoucher VALUES("261","PAV120124105","","20000.00","2024-01-12","0","5","2024-01-12 08:12:54");
INSERT INTO tbl_payvoucher VALUES("262","PAV130124101","","12500.00","2024-01-13","0","5","2024-01-13 12:05:49");
INSERT INTO tbl_payvoucher VALUES("264","PAV130124103","","152000.00","2024-01-13","0","5","2024-01-13 12:16:29");
INSERT INTO tbl_payvoucher VALUES("265","PAV130124104","","126500.00","2024-01-13","0","5","2024-01-13 12:18:17");
INSERT INTO tbl_payvoucher VALUES("266","PAV140124101","","50000.00","2024-01-14","0","5","2024-01-14 11:24:43");
INSERT INTO tbl_payvoucher VALUES("267","PAV150124101","For 1040 Price Adjustment ","2000.00","2024-01-15","0","5","2024-01-15 12:11:02");
INSERT INTO tbl_payvoucher VALUES("268","PAV150124102","","27000.00","2024-01-15","0","5","2024-01-15 12:43:12");
INSERT INTO tbl_payvoucher VALUES("269","PAV150124103","","200000.00","2024-01-15","0","5","2024-01-15 05:50:04");
INSERT INTO tbl_payvoucher VALUES("270","PAV170124101","","20000.00","2024-01-17","0","5","2024-01-17 01:23:18");
INSERT INTO tbl_payvoucher VALUES("271","PAV170124102","","70000.00","2024-01-17","0","5","2024-01-17 09:33:52");
INSERT INTO tbl_payvoucher VALUES("272","PAV180124101","","100000.00","2024-01-18","0","5","2024-01-18 04:16:25");
INSERT INTO tbl_payvoucher VALUES("273","PAV180124102","","20000.00","2024-01-18","0","5","2024-01-18 06:26:25");
INSERT INTO tbl_payvoucher VALUES("274","PAV240124101","","348000.00","2024-01-24","0","5","2024-01-24 03:59:29");
INSERT INTO tbl_payvoucher VALUES("275","PAV240124102","","10000.00","2024-01-24","0","5","2024-01-24 08:01:14");
INSERT INTO tbl_payvoucher VALUES("276","PAV240124103","","20000.00","2024-01-24","0","5","2024-01-24 08:12:06");
INSERT INTO tbl_payvoucher VALUES("277","PAV250124101","","1000.00","2024-01-25","0","5","2024-01-25 07:16:24");
INSERT INTO tbl_payvoucher VALUES("278","PAV270124101","","80000.00","2024-01-27","0","5","2024-01-27 03:41:30");
INSERT INTO tbl_payvoucher VALUES("279","PAV290124101","","30000.00","2024-01-29","0","5","2024-01-29 08:05:09");
INSERT INTO tbl_payvoucher VALUES("280","PAV290124102","","33600.00","2024-01-29","0","5","2024-01-29 09:37:43");
INSERT INTO tbl_payvoucher VALUES("281","PAV290124103","","20000.00","2024-01-29","0","5","2024-01-29 09:57:03");
INSERT INTO tbl_payvoucher VALUES("282","PAV300124101","","107000.00","2024-01-30","0","5","2024-01-30 07:42:51");
INSERT INTO tbl_payvoucher VALUES("283","PAV310124101","","20000.00","2024-01-31","0","5","2024-01-31 11:59:37");
INSERT INTO tbl_payvoucher VALUES("284","PAV010224101","","84000.00","2024-02-01","0","5","2024-02-01 12:01:40");
INSERT INTO tbl_payvoucher VALUES("285","PAV010224102","","50000.00","2024-02-01","0","5","2024-02-01 07:09:41");
INSERT INTO tbl_payvoucher VALUES("286","PAV050224101","","10000.00","2024-02-05","0","5","2024-02-05 07:52:29");
INSERT INTO tbl_payvoucher VALUES("287","PAV160224101","","30500.00","2024-02-16","0","5","2024-02-16 11:59:35");
INSERT INTO tbl_payvoucher VALUES("288","PAV180224101","","30000.00","2024-02-18","0","5","2024-02-18 01:42:26");
INSERT INTO tbl_payvoucher VALUES("289","PAV220224101","","5000.00","2024-02-22","0","5","2024-02-22 06:57:32");
INSERT INTO tbl_payvoucher VALUES("290","PAV290224101","","700.00","2024-02-29","0","5","2024-02-29 01:58:12");
INSERT INTO tbl_payvoucher VALUES("291","PAV020324101","","40000.00","2024-03-02","0","5","2024-03-02 07:30:59");
INSERT INTO tbl_payvoucher VALUES("292","PAV020324102","","40000.00","2024-03-02","0","5","2024-03-02 11:02:03");
INSERT INTO tbl_payvoucher VALUES("293","PAV020324103","","20000.00","2024-03-02","0","5","2024-03-02 11:04:25");
INSERT INTO tbl_payvoucher VALUES("294","PAV080324101","","50300.00","2024-03-08","0","5","2024-03-08 05:01:54");
INSERT INTO tbl_payvoucher VALUES("295","PAV100324101","","35200.00","2024-03-10","0","5","2024-03-10 01:06:12");
INSERT INTO tbl_payvoucher VALUES("297","PAV200324101","","46500.00","2024-03-20","0","5","2024-03-20 11:59:45");
INSERT INTO tbl_payvoucher VALUES("299","PAV210324101","","63000.00","2024-03-21","0","5","2024-03-21 12:13:47");
INSERT INTO tbl_payvoucher VALUES("300","PAV210324102","","147500.00","2024-03-21","0","5","2024-03-21 12:15:04");
INSERT INTO tbl_payvoucher VALUES("301","PAV220324101","","15000.00","2024-03-22","0","5","2024-03-22 05:21:14");
INSERT INTO tbl_payvoucher VALUES("302","PAV260324101","","20000.00","2024-03-26","0","5","2024-03-26 01:32:52");
INSERT INTO tbl_payvoucher VALUES("304","PAV060424101","","25000.00","2024-04-06","0","5","2024-04-06 11:15:59");
INSERT INTO tbl_payvoucher VALUES("305","PAV250424101","","77000.00","2024-04-25","0","5","2024-04-25 06:15:13");
INSERT INTO tbl_payvoucher VALUES("306","PAV050524101","","164000.00","2024-05-05","0","5","2024-05-05 01:56:06");
INSERT INTO tbl_payvoucher VALUES("307","PAV190524101","","1256500.00","2024-05-19","0","5","2024-05-19 06:23:41");
INSERT INTO tbl_payvoucher VALUES("308","PAV090624101","","30000.00","2024-06-09","0","5","2024-06-09 04:59:46");
INSERT INTO tbl_payvoucher VALUES("309","PAV090624102","","341500.00","2024-06-09","0","5","2024-06-09 05:34:42");
INSERT INTO tbl_payvoucher VALUES("310","PAV100624101","","25000.00","2024-06-10","0","5","2024-06-10 11:51:55");
INSERT INTO tbl_payvoucher VALUES("311","PAV100624102","","28000.00","2024-06-10","0","5","2024-06-10 11:54:50");
INSERT INTO tbl_payvoucher VALUES("313","PAV030724102","","19000.00","2024-07-03","0","5","2024-07-03 11:52:20");
INSERT INTO tbl_payvoucher VALUES("314","PAV270724101","","50000.00","2024-07-27","0","5","2024-07-27 02:50:40");
INSERT INTO tbl_payvoucher VALUES("315","PAV300724101","","111200.00","2024-07-30","0","5","2024-07-30 09:31:55");
INSERT INTO tbl_payvoucher VALUES("316","PAV300724102","","1000.00","2024-07-30","0","5","2024-07-30 09:33:55");
INSERT INTO tbl_payvoucher VALUES("317","PAV050824101","","62000.00","2024-08-05","0","5","2024-08-05 09:16:01");
INSERT INTO tbl_payvoucher VALUES("318","PAV180824101","City bank TRF","100000.00","2024-08-18","0","5","2024-08-18 06:36:45");
INSERT INTO tbl_payvoucher VALUES("319","PAV020924101","","17500.00","2024-09-02","0","5","2024-09-02 10:26:01");
INSERT INTO tbl_payvoucher VALUES("320","PAV050924101","","3000.00","2024-09-05","0","5","2024-09-05 06:27:55");
INSERT INTO tbl_payvoucher VALUES("321","PAV050924102","","3500.00","2024-09-05","0","5","2024-09-05 06:28:52");
INSERT INTO tbl_payvoucher VALUES("322","PAV050924103","","104000.00","2024-09-05","0","5","2024-09-05 06:30:39");
INSERT INTO tbl_payvoucher VALUES("323","PAV140924101","","10000.00","2024-09-14","0","5","2024-09-14 08:15:31");
INSERT INTO tbl_payvoucher VALUES("324","PAV220924101","","399000.00","2024-09-22","0","5","2024-09-22 08:21:53");
INSERT INTO tbl_payvoucher VALUES("325","PAV240924101","","82000.00","2024-09-24","0","5","2024-09-24 11:43:01");
INSERT INTO tbl_payvoucher VALUES("326","PAV290924101","","10000.00","2024-09-29","0","5","2024-09-29 12:49:00");
INSERT INTO tbl_payvoucher VALUES("327","PAV011024101","","27000.00","2024-10-01","0","5","2024-10-01 07:07:49");



CREATE TABLE `tbl_payvoucherde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `cty` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `did` int(11) NOT NULL,
  `dty` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=386 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_payvoucherde VALUES("18","0","1","2","LE","381000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("20","0","3","2","LE","100000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("22","0","5","2","LE","17000.00","75","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("24","0","7","2","LE","4000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("25","0","8","2","LE","30000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("26","0","9","2","LE","66000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("27","0","10","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("28","0","11","2","LE","50000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("29","0","12","2","LE","30000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("30","0","13","2","LE","95000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("31","0","14","2","LE","25000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("32","0","15","2","LE","25000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("33","0","16","2","LE","10000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("34","0","17","2","LE","8000.00","6","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("35","0","18","2","LE","5000.00","6","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("36","0","19","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("37","0","20","2","LE","75000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("38","0","21","2","LE","36000.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("39","0","22","2","LE","18000.00","6","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("40","0","23","2","LE","10000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("41","0","24","2","LE","20500.00","94","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("42","0","25","2","LE","6000.00","93","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("43","0","26","2","LE","180500.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("44","0","27","2","LE","87500.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("45","0","28","2","LE","87000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("46","0","29","2","LE","116000.00","14","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("47","0","30","2","LE","56000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("48","0","31","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("49","0","32","2","LE","44000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("50","0","33","2","LE","35000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("51","0","34","2","LE","37000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("52","0","35","2","LE","14200.00","142","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("53","0","36","2","LE","38000.00","108","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("54","0","37","2","LE","60000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("55","0","38","2","LE","63500.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("56","0","39","2","LE","50000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("57","0","40","2","LE","34000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("58","0","41","2","LE","2000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("59","0","42","2","LE","97000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("60","0","43","2","LE","26500.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("61","0","44","2","LE","18000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("62","0","45","2","LE","20000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("63","0","46","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("64","0","47","2","LE","35000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("65","0","48","2","LE","28000.00","111","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("66","0","49","2","LE","19000.00","85","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("67","0","50","2","LE","50000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("68","0","51","2","LE","12000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("69","0","52","2","LE","8000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("70","0","53","2","LE","21500.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("71","0","54","2","LE","20000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("72","0","55","2","LE","21500.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("73","0","56","2","LE","25500.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("74","0","57","2","LE","12000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("75","0","58","2","LE","10000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("76","0","59","2","LE","15000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("77","0","60","2","LE","54000.00","90","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("78","0","61","2","LE","21000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("79","0","62","2","LE","70000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("80","0","63","2","LE","43000.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("81","0","64","2","LE","12500.00","6","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("82","0","65","2","LE","48000.00","160","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("83","0","66","2","LE","3000.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("84","0","67","2","LE","19000.00","18","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("85","0","68","2","LE","43000.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("86","0","69","2","LE","25000.00","150","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("87","0","70","2","LE","28000.00","111","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("88","0","71","2","LE","1000.00","160","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("89","0","72","2","LE","19300.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("90","0","73","2","LE","25500.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("91","0","74","2","LE","23000.00","160","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("92","0","75","2","LE","132000.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("93","0","76","2","LE","200000.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("94","0","77","2","LE","100000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("95","0","78","2","LE","400000.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("96","0","79","2","LE","24500.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("97","0","80","2","LE","44000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("98","0","81","2","LE","23500.00","100","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("99","0","82","2","LE","145000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("100","0","83","2","LE","30000.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("101","0","84","2","LE","70000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("102","0","85","2","LE","25000.00","85","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("103","0","86","2","LE","200000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("104","0","87","2","LE","60000.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("105","0","88","2","LE","50000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("106","0","89","2","LE","134500.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("107","0","90","2","LE","143500.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("108","0","91","2","LE","323500.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("109","0","92","2","LE","3500.00","176","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("110","0","93","2","LE","1221250.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("111","0","94","2","LE","32500.00","179","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("112","0","95","2","LE","45000.00","100","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("113","0","96","2","LE","27600.00","110","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("114","0","97","2","LE","29400.00","156","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("115","0","98","2","LE","100000.00","25","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("116","0","99","2","LE","67500.00","191","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("117","0","100","2","LE","24000.00","108","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("118","0","101","2","LE","549500.00","166","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("119","0","102","2","LE","920750.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("120","0","102","2","LE","121000.00","19","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("121","0","102","2","LE","48000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("122","0","102","2","LE","235000.00","25","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("123","0","102","2","LE","24000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("124","0","102","2","LE","1323500.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("125","0","102","2","LE","1235500.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("126","0","103","2","LE","100000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("127","0","104","2","LE","116000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("128","0","105","2","LE","19000.00","6","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("129","0","106","2","LE","494000.00","166","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("130","0","107","2","LE","1500.00","153","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("131","0","108","2","LE","25000.00","28","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("132","0","109","2","LE","594500.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("133","0","110","2","LE","116500.00","214","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("134","0","111","2","LE","12000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("135","0","112","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("136","0","113","2","LE","473000.00","159","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("137","0","113","2","LE","446000.00","166","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("138","0","114","2","LE","28166.00","115","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("139","0","115","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("140","0","116","2","LE","90000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("141","0","117","2","LE","23000.00","184","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("144","0","119","2","LE","32000.00","85","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("145","0","119","2","LE","22000.00","229","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("146","0","120","2","LE","307500.00","166","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("147","0","121","2","LE","7500.00","200","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("148","0","122","2","LE","20000.00","32","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("149","0","122","2","LE","20000.00","32","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("150","0","123","2","LE","50000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("151","0","124","2","LE","3000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("152","0","125","2","LE","42000.00","166","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("153","0","126","2","LE","334000.00","28","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("154","0","127","2","LE","4000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("155","0","128","2","LE","137500.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("156","0","128","2","LE","21000.00","29","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("157","0","129","2","LE","38500.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("158","0","130","2","LE","50000.00","32","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("159","0","130","2","LE","50000.00","32","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("160","0","131","2","LE","86000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("161","0","132","2","LE","30000.00","32","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("162","0","133","2","LE","60000.00","32","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("163","0","134","2","LE","13200.00","212","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("164","0","135","2","LE","154100.00","165","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("165","0","136","2","LE","494000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("166","0","137","2","LE","32000.00","134","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("167","0","138","2","LE","3900000.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("168","0","138","2","LE","76000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("169","0","139","2","LE","21000.00","210","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("170","0","140","2","LE","100000.00","223","CU","","","0","CITY TRNS");
INSERT INTO tbl_payvoucherde VALUES("173","0","143","2","LE","200000.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("174","0","144","2","LE","90000.00","223","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("175","0","145","2","LE","338300.00","21","SU","","","0","adjust 100+140k");
INSERT INTO tbl_payvoucherde VALUES("176","0","146","2","LE","22000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("177","0","147","2","LE","500.00","237","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("178","0","148","2","LE","157000.00","166","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("179","0","149","2","LE","9500.00","199","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("180","0","150","2","LE","38000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("181","0","150","2","LE","82000.00","30","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("182","0","151","2","LE","2000000.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("183","0","152","2","LE","7500000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("184","0","153","2","LE","140000.00","250","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("185","0","154","2","LE","110000.00","250","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("186","0","155","2","LE","20500.00","195","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("187","0","156","2","LE","18500.00","210","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("188","0","157","2","LE","19000.00","250","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("189","0","158","2","LE","20000.00","259","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("190","0","159","2","LE","19000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("191","0","160","2","LE","36000.00","250","CU","","","0","city transfer");
INSERT INTO tbl_payvoucherde VALUES("192","0","161","2","LE","28000.00","28","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("193","0","162","2","LE","1370000.00","235","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("194","0","163","2","LE","38000.00","210","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("195","0","164","2","LE","285000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("196","0","164","2","LE","98500.00","20","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("197","0","164","2","LE","90000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("198","0","164","2","LE","17000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("199","0","165","2","LE","36000.00","171","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("200","0","166","2","LE","39000.00","161","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("201","0","167","2","LE","200000.00","47","SU","","","0","sonali 200k");
INSERT INTO tbl_payvoucherde VALUES("202","0","168","2","LE","19500.00","161","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("203","0","169","2","LE","23000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("204","0","170","2","LE","6000.00","168","CU","","","0","adjust ");
INSERT INTO tbl_payvoucherde VALUES("205","0","171","2","LE","293000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("206","0","172","2","LE","930000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("207","0","173","2","LE","116000.00","47","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("208","0","174","2","LE","28000.00","199","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("209","0","175","2","LE","19500.00","27","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("210","0","176","2","LE","500.00","28","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("211","0","177","2","LE","19000.00","284","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("212","0","178","2","LE","209000.00","42","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("213","0","179","2","LE","250000.00","225","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("214","0","180","2","LE","50000.00","280","CU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("215","0","181","2","LE","25000.00","280","CU","","","0","cash paid for console");
INSERT INTO tbl_payvoucherde VALUES("216","0","182","2","LE","40000.00","211","CU","","","0","for adjust");
INSERT INTO tbl_payvoucherde VALUES("217","0","183","2","LE","50000.00","225","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("219","0","185","2","LE","11000.00","225","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("220","0","186","2","LE","29000.00","292","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("221","0","187","2","LE","20000.00","215","CU","","","0","840 G3");
INSERT INTO tbl_payvoucherde VALUES("222","0","188","2","LE","65000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("223","0","188","2","LE","114000.00","42","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("224","0","189","2","LE","175500.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("225","0","190","2","LE","50000.00","288","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("226","0","191","2","LE","40000.00","101","CU","","","0","cash loan");
INSERT INTO tbl_payvoucherde VALUES("227","0","192","2","LE","396000.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("228","0","193","2","LE","1591000.00","53","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("229","0","194","2","LE","19000.00","27","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("230","0","195","2","LE","100000.00","56","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("231","0","196","2","LE","20000.00","54","SU","","","0","adj with 120k payment");
INSERT INTO tbl_payvoucherde VALUES("232","0","197","2","LE","100000.00","7","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("233","0","198","2","LE","300000.00","53","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("234","0","199","2","LE","55000.00","56","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("235","0","200","2","LE","150000.00","7","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("236","0","201","2","LE","61000.00","136","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("237","0","202","2","LE","150000.00","7","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("238","0","203","2","LE","100000.00","53","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("240","0","205","2","LE","12000000.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("241","0","206","2","LE","9440000.00","15","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("242","0","207","2","LE","25000.00","157","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("243","0","208","2","LE","26000.00","294","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("244","0","209","2","LE","100000.00","7","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("245","0","210","2","LE","100000.00","52","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("246","0","211","2","LE","20000.00","56","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("247","0","212","2","LE","10000.00","60","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("248","0","213","2","LE","12000.00","7","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("249","0","214","2","LE","100000.00","52","SU","","","0","CITY");
INSERT INTO tbl_payvoucherde VALUES("250","0","214","2","LE","100000.00","7","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("251","0","215","2","LE","100000.00","291","CU","","","0","adjustment");
INSERT INTO tbl_payvoucherde VALUES("252","0","216","2","LE","9500.00","53","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("253","0","217","2","LE","44000.00","195","CU","","","0","sakib cash");
INSERT INTO tbl_payvoucherde VALUES("254","0","218","2","LE","100000.00","288","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("255","0","219","2","LE","50000.00","7","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("256","0","220","2","LE","1500.00","56","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("257","0","220","2","LE","75000.00","14","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("258","0","220","2","LE","168500.00","60","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("259","0","221","2","LE","50000.00","52","SU","","","0","CITY");
INSERT INTO tbl_payvoucherde VALUES("260","0","222","2","LE","100000.00","244","CU","","","0","cash for mini pc 10 unit");
INSERT INTO tbl_payvoucherde VALUES("261","0","223","2","LE","200000.00","53","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("262","0","224","2","LE","16000.00","52","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("263","0","225","2","LE","69000.00","14","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("264","0","226","2","LE","18000.00","59","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("265","0","227","2","LE","80000.00","53","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("266","0","228","2","LE","150000.00","298","CU","","","0","City bank");
INSERT INTO tbl_payvoucherde VALUES("267","0","229","2","LE","250000.00","298","CU","","","0","G5 unit 10");
INSERT INTO tbl_payvoucherde VALUES("268","0","230","2","LE","40000.00","7","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("269","0","231","2","LE","200000.00","298","CU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("270","0","231","2","LE","17500.00","280","CU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("271","0","231","2","LE","19800.00","113","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("272","0","231","2","LE","248000.00","304","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("273","0","231","2","LE","115000.00","285","CU","","","0","City");
INSERT INTO tbl_payvoucherde VALUES("274","0","232","2","LE","10500.00","53","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("275","0","233","2","LE","150000.00","244","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("276","0","234","2","LE","100000.00","244","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("277","0","235","2","LE","100000.00","244","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("278","0","236","2","LE","71500.00","9","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("279","0","236","2","LE","26000.00","62","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("280","0","237","2","LE","20000.00","7","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("281","0","238","2","LE","100000.00","59","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("282","0","239","2","LE","50000.00","307","CU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("283","0","240","2","LE","50000.00","244","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("284","0","241","2","LE","50000.00","288","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("285","0","242","2","LE","2000.00","258","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("286","0","242","2","LE","1000.00","86","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("287","0","242","2","LE","4400.00","210","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("288","0","242","2","LE","18500.00","96","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("289","0","242","2","LE","5500.00","168","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("290","0","242","2","LE","4000.00","183","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("291","0","242","2","LE","25000.00","304","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("292","0","242","2","LE","27800.00","310","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("293","0","242","2","LE","28166.00","115","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("294","0","243","2","LE","136000.00","62","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("295","0","244","2","LE","30000.00","288","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("296","0","245","2","LE","15000.00","74","CU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("297","0","246","2","LE","25000.00","244","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("298","0","247","2","LE","50000.00","136","CU","","","0","EBL");
INSERT INTO tbl_payvoucherde VALUES("299","0","248","2","LE","25000.00","304","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("300","0","249","2","LE","50000.00","64","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("303","0","252","2","LE","100000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("304","0","253","2","LE","40000.00","64","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("305","0","254","2","LE","30000.00","64","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("306","0","255","2","LE","20000.00","66","SU","","","0","city ");
INSERT INTO tbl_payvoucherde VALUES("307","0","256","2","LE","95000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("308","0","257","2","LE","2000.00","64","SU","","","0","battery+color");
INSERT INTO tbl_payvoucherde VALUES("309","0","258","2","LE","26000.00","65","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("310","0","259","2","LE","50000.00","63","SU","","","0","BRAC Bank");
INSERT INTO tbl_payvoucherde VALUES("311","0","260","2","LE","50000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("312","0","261","2","LE","20000.00","66","SU","","","0","islami bank");
INSERT INTO tbl_payvoucherde VALUES("313","0","262","2","LE","12500.00","59","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("315","0","264","2","LE","152000.00","61","SU","","","0","prev due paid");
INSERT INTO tbl_payvoucherde VALUES("316","0","265","2","LE","81500.00","62","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("317","0","265","2","LE","45000.00","1","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("318","0","266","2","LE","50000.00","61","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("319","0","267","2","LE","2000.00","64","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("320","0","268","2","LE","27000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("321","0","269","2","LE","200000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("322","0","270","2","LE","20000.00","61","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("323","0","271","2","LE","70000.00","61","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("324","0","272","2","LE","100000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("325","0","273","2","LE","20000.00","66","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("326","0","274","2","LE","98000.00","61","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("327","0","274","2","LE","100000.00","63","SU","","","0","BRAC ");
INSERT INTO tbl_payvoucherde VALUES("328","0","274","2","LE","150000.00","64","SU","","","0","DBBL ");
INSERT INTO tbl_payvoucherde VALUES("329","0","275","2","LE","10000.00","66","SU","","","0","cash ");
INSERT INTO tbl_payvoucherde VALUES("330","0","276","2","LE","20000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("331","0","277","2","LE","1000.00","64","SU","","","0","misti ");
INSERT INTO tbl_payvoucherde VALUES("332","0","278","2","LE","80000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("333","0","279","2","LE","20000.00","66","SU","","","0","Probook 440");
INSERT INTO tbl_payvoucherde VALUES("334","0","279","2","LE","10000.00","66","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("335","0","280","2","LE","33600.00","288","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("336","0","281","2","LE","20000.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("337","0","282","2","LE","107000.00","1","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("338","0","283","2","LE","20000.00","93","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("339","0","284","2","LE","84000.00","253","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("340","0","285","2","LE","50000.00","63","SU","","","0","BRAC");
INSERT INTO tbl_payvoucherde VALUES("341","0","286","2","LE","10000.00","66","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("342","0","287","2","LE","30500.00","307","CU","","","0","Cash");
INSERT INTO tbl_payvoucherde VALUES("343","0","288","2","LE","30000.00","63","SU","","","0","City bank");
INSERT INTO tbl_payvoucherde VALUES("344","0","289","2","LE","5000.00","195","CU","","","0","loan cash ");
INSERT INTO tbl_payvoucherde VALUES("345","0","290","2","LE","700.00","64","SU","","","0","color");
INSERT INTO tbl_payvoucherde VALUES("346","0","291","2","LE","40000.00","64","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("347","0","292","2","LE","40000.00","69","SU","","","0","city");
INSERT INTO tbl_payvoucherde VALUES("348","0","293","2","LE","20000.00","304","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("349","0","294","2","LE","50300.00","64","SU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("350","0","295","2","LE","35200.00","63","SU","","","0","BRAC");
INSERT INTO tbl_payvoucherde VALUES("353","0","297","2","LE","46500.00","194","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("355","0","299","2","LE","63000.00","55","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("356","0","300","2","LE","147500.00","46","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("357","0","301","2","LE","15000.00","304","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("358","0","302","2","LE","20000.00","64","SU","","","0","loan DBBL");
INSERT INTO tbl_payvoucherde VALUES("360","0","304","2","LE","25000.00","1","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("361","0","305","2","LE","77000.00","93","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("362","0","306","2","LE","164000.00","50","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("363","0","307","2","LE","1256500.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("364","0","308","2","LE","30000.00","338","CU","","","0","adjust");
INSERT INTO tbl_payvoucherde VALUES("365","0","309","2","LE","341500.00","50","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("366","0","310","2","LE","25000.00","329","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("367","0","311","2","LE","28000.00","230","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("369","0","313","2","LE","19000.00","50","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("370","0","314","2","LE","50000.00","347","CU","","","0","adjust");
INSERT INTO tbl_payvoucherde VALUES("371","0","315","2","LE","4200.00","29","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("372","0","315","2","LE","107000.00","1","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("373","0","316","2","LE","1000.00","41","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("374","0","317","2","LE","62000.00","308","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("375","0","318","2","LE","100000.00","64","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("376","0","319","2","LE","17500.00","265","CU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("377","0","320","2","LE","3000.00","62","SU","","","0","adjust");
INSERT INTO tbl_payvoucherde VALUES("378","0","321","2","LE","3500.00","64","SU","","","0","adjust");
INSERT INTO tbl_payvoucherde VALUES("379","0","322","2","LE","5000.00","3","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("380","0","322","2","LE","99000.00","50","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("381","0","323","2","LE","10000.00","328","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("382","0","324","2","LE","399000.00","1","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("383","0","325","2","LE","82000.00","50","SU","","","0","cash");
INSERT INTO tbl_payvoucherde VALUES("384","0","326","2","LE","10000.00","328","CU","","","0","DBBL");
INSERT INTO tbl_payvoucherde VALUES("385","0","327","2","LE","27000.00","286","CU","","","0","adjust");



CREATE TABLE `tbl_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `refinv` varchar(15) DEFAULT NULL,
  `type` varchar(2) NOT NULL,
  `supid` int(11) NOT NULL,
  `itemdis` decimal(8,2) NOT NULL DEFAULT 0.00,
  `subtot` decimal(12,2) NOT NULL,
  `disp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `disamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `totdis` decimal(8,2) NOT NULL DEFAULT 0.00,
  `vatp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `vatamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `taxp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `taxamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `spmoney` decimal(8,2) NOT NULL DEFAULT 0.00,
  `otname` varchar(35) NOT NULL,
  `otamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `freight` decimal(8,2) NOT NULL DEFAULT 0.00,
  `less` decimal(8,2) NOT NULL DEFAULT 0.00,
  `adamo` decimal(12,2) DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `curid` int(11) NOT NULL,
  `ref` varchar(25) DEFAULT NULL,
  `note` varchar(150) DEFAULT NULL,
  `apdate` date NOT NULL,
  `nxtduedate` date DEFAULT NULL,
  `rawcash` decimal(12,2) NOT NULL DEFAULT 0.00,
  `changes` decimal(8,2) NOT NULL DEFAULT 0.00,
  `purp` int(11) DEFAULT NULL,
  `creditid` varchar(15) NOT NULL,
  `details` varchar(65) DEFAULT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1569 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_purchase VALUES("1","PUR080322101","","SU","1","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2022-03-08","2022-03-15","0.00","0.00","","LE_2","","0","5","2022-03-08 06:24:47");
INSERT INTO tbl_purchase VALUES("2","PUR120322101","","SU","1","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2022-03-12","2022-03-19","0.00","0.00","","LE_2","","0","5","2022-03-12 04:26:52");
INSERT INTO tbl_purchase VALUES("3","PUR120322102","","SU","1","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2022-03-12","2022-03-19","0.00","0.00","","LE_2","","0","5","2022-03-12 04:30:33");
INSERT INTO tbl_purchase VALUES("4","PUR120322103","","SU","1","0.00","74000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74000.00","0","","","2022-03-12","2022-03-19","0.00","0.00","","LE_2","","0","5","2022-03-12 04:37:39");
INSERT INTO tbl_purchase VALUES("5","PUR120322104","","SU","1","0.00","96000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96000.00","0","","","2022-03-12","2022-03-19","50000.00","0.00","","LE_2","","0","5","2022-03-12 05:43:39");
INSERT INTO tbl_purchase VALUES("6","PUR130322101","","SU","1","0.00","104000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104000.00","0","","","2022-03-13","2022-03-20","0.00","0.00","","LE_2","","0","5","2022-03-13 07:18:28");
INSERT INTO tbl_purchase VALUES("7","PUR200322101","","SU","2","0.00","99000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99000.00","0","","","2022-03-20","2022-03-27","0.00","0.00","","LE_2","","0","5","2022-03-20 02:54:07");
INSERT INTO tbl_purchase VALUES("8","PUR250322101","","SU","1","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-03-25","2022-04-01","0.00","0.00","","LE_2","","0","5","2022-03-25 01:04:17");
INSERT INTO tbl_purchase VALUES("9","PUR250322102","","SU","1","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-03-25","","30000.00","0.00","","LE_2","","0","5","2022-03-25 01:07:10");
INSERT INTO tbl_purchase VALUES("10","PUR250322103","","SU","1","0.00","273500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","273500.00","0","","","2022-03-25","","273500.00","0.00","","LE_2","","0","5","2022-03-25 01:20:24");
INSERT INTO tbl_purchase VALUES("11","PUR250322104","","SU","1","0.00","29500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29500.00","0","","","2022-03-25","","29500.00","0.00","","LE_2","","0","5","2022-03-25 01:22:49");
INSERT INTO tbl_purchase VALUES("12","PUR250322105","","SU","1","0.00","255000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","255000.00","0","","","2022-03-25","","255000.00","0.00","","LE_2","","0","5","2022-03-25 01:33:27");
INSERT INTO tbl_purchase VALUES("13","PUR250322106","","SU","1","0.00","549500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","549500.00","0","","","2022-03-25","","549500.00","0.00","","LE_2","","0","5","2022-03-25 01:51:52");
INSERT INTO tbl_purchase VALUES("14","PUR250322107","","SU","1","0.00","601500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","601500.00","0","","","2022-03-25","","601500.00","0.00","","LE_2","","0","5","2022-03-25 02:00:49");
INSERT INTO tbl_purchase VALUES("15","PUR250322108","","SU","1","0.00","12000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12000.00","0","","","2022-03-25","","12000.00","0.00","","LE_2","","0","5","2022-03-25 02:15:23");
INSERT INTO tbl_purchase VALUES("16","PUR250322109","","SU","1","0.00","566000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","566000.00","0","","","2022-03-25","","566000.00","0.00","","LE_2","","0","5","2022-03-25 02:30:39");
INSERT INTO tbl_purchase VALUES("17","PUR250322110","","SU","1","0.00","241000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","241000.00","0","","","2022-03-25","","241000.00","0.00","","LE_2","","0","5","2022-03-25 02:37:47");
INSERT INTO tbl_purchase VALUES("18","PUR250322111","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-03-25","","23000.00","0.00","","LE_2","","0","5","2022-03-25 02:39:24");
INSERT INTO tbl_purchase VALUES("19","PUR250322112","","SU","1","0.00","205000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","205000.00","0","","","2022-03-25","","205000.00","0.00","","LE_2","","0","5","2022-03-25 02:40:36");
INSERT INTO tbl_purchase VALUES("20","PUR250322113","","SU","1","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2022-03-25","","105000.00","0.00","","LE_2","","0","5","2022-03-25 02:44:46");
INSERT INTO tbl_purchase VALUES("21","PUR250322114","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-03-25","","25000.00","0.00","","LE_2","","0","5","2022-03-25 02:47:30");
INSERT INTO tbl_purchase VALUES("22","PUR250322115","","SU","1","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2022-03-25","","75000.00","0.00","","LE_2","","0","5","2022-03-25 02:49:43");
INSERT INTO tbl_purchase VALUES("23","PUR250322116","","SU","1","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-03-25","","31500.00","0.00","","LE_2","","0","5","2022-03-25 03:13:21");
INSERT INTO tbl_purchase VALUES("24","PUR250322117","","SU","2","0.00","74000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74000.00","0","","","2022-03-25","2022-04-01","0.00","0.00","","LE_2","","0","5","2022-03-25 03:21:28");
INSERT INTO tbl_purchase VALUES("25","PUR250322118","","SU","2","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-03-25","2022-04-01","0.00","0.00","","LE_2","","0","5","2022-03-25 03:24:48");
INSERT INTO tbl_purchase VALUES("26","PUR250322119","","SU","3","0.00","41000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41000.00","0","","","2022-03-25","","41000.00","0.00","","LE_2","","0","5","2022-03-25 05:33:08");
INSERT INTO tbl_purchase VALUES("27","PUR270322101","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-03-27","","25000.00","0.00","","LE_2","","0","5","2022-03-27 11:58:24");
INSERT INTO tbl_purchase VALUES("28","PUR270322102","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-03-27","","25000.00","0.00","","LE_2","","0","5","2022-03-27 12:03:16");
INSERT INTO tbl_purchase VALUES("29","PUR270322103","","SU","1","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2022-03-27","","45000.00","0.00","","LE_2","","0","5","2022-03-27 12:51:18");
INSERT INTO tbl_purchase VALUES("30","PUR270322104","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-03-27","","20000.00","0.00","","LE_2","","0","5","2022-03-27 03:02:08");
INSERT INTO tbl_purchase VALUES("31","PUR270322105","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-03-27","","25000.00","0.00","","LE_2","","0","5","2022-03-27 04:10:21");
INSERT INTO tbl_purchase VALUES("32","PUR270322106","","SU","4","0.00","73000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73000.00","0","","","2022-03-27","","73000.00","0.00","","LE_2","","0","5","2022-03-27 04:18:32");
INSERT INTO tbl_purchase VALUES("33","PUR270322107","","SU","1","0.00","49300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49300.00","0","","","2022-03-27","","49300.00","0.00","","LE_2","","0","5","2022-03-27 05:09:32");
INSERT INTO tbl_purchase VALUES("34","PUR270322108","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-03-27","","15000.00","0.00","","LE_2","","0","5","2022-03-27 06:47:59");
INSERT INTO tbl_purchase VALUES("35","PUR280322101","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-03-28","","15000.00","0.00","","LE_2","","0","5","2022-03-28 01:56:32");
INSERT INTO tbl_purchase VALUES("36","PUR280322102","","SU","1","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-03-28","","31500.00","0.00","","LE_2","","0","5","2022-03-28 08:04:02");
INSERT INTO tbl_purchase VALUES("37","PUR290322101","","SU","1","0.00","120000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120000.00","0","","","2022-03-29","","120000.00","0.00","","LE_2","","0","5","2022-03-29 11:57:03");
INSERT INTO tbl_purchase VALUES("38","PUR290322102","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-03-29","","20000.00","0.00","","LE_2","","0","5","2022-03-29 11:58:58");
INSERT INTO tbl_purchase VALUES("39","PUR300322101","","SU","1","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-03-30","","22000.00","0.00","","LE_2","","0","5","2022-03-30 12:00:27");
INSERT INTO tbl_purchase VALUES("40","PUR300322102","","SU","1","0.00","61250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61250.00","0","","","2022-03-30","","61250.00","0.00","","LE_2","","0","5","2022-03-30 12:04:54");
INSERT INTO tbl_purchase VALUES("41","PUR300322103","","SU","1","0.00","39000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39000.00","0","","","2022-03-30","","39000.00","0.00","","LE_2","","0","5","2022-03-30 12:07:33");
INSERT INTO tbl_purchase VALUES("42","PUR300322104","","SU","1","0.00","119000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","119000.00","0","","","2022-03-30","","119000.00","0.00","","LE_2","","0","5","2022-03-30 12:11:07");
INSERT INTO tbl_purchase VALUES("43","PUR300322105","","SU","1","0.00","356250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","356250.00","0","","","2022-03-30","","356250.00","0.00","","LE_2","","0","5","2022-03-30 12:18:34");
INSERT INTO tbl_purchase VALUES("44","PUR300322106","","SU","1","0.00","26250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26250.00","0","","","2022-03-30","","26250.00","0.00","","LE_2","","0","5","2022-03-30 12:19:48");
INSERT INTO tbl_purchase VALUES("45","PUR300322107","","SU","1","0.00","135000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135000.00","0","","","2022-03-30","","135000.00","0.00","","LE_2","","0","5","2022-03-30 12:22:49");
INSERT INTO tbl_purchase VALUES("46","PUR300322108","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-03-30","","15000.00","0.00","","LE_2","","0","5","2022-03-30 12:23:59");
INSERT INTO tbl_purchase VALUES("47","PUR300322109","","SU","1","0.00","52500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52500.00","0","","","2022-03-30","","52500.00","0.00","","LE_2","","0","5","2022-03-30 12:26:52");
INSERT INTO tbl_purchase VALUES("48","PUR300322110","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-03-30","","25000.00","0.00","","LE_2","","0","5","2022-03-30 12:31:42");
INSERT INTO tbl_purchase VALUES("49","PUR300322111","","SU","1","0.00","195000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","195000.00","0","","","2022-03-30","","195000.00","0.00","","LE_2","","0","5","2022-03-30 12:42:23");
INSERT INTO tbl_purchase VALUES("50","PUR300322112","","SU","1","0.00","255500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","255500.00","0","","","2022-03-30","","255500.00","0.00","","LE_2","","0","5","2022-03-30 12:46:59");
INSERT INTO tbl_purchase VALUES("51","PUR300322113","","SU","1","0.00","116250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116250.00","0","","","2022-03-30","","116250.00","0.00","","LE_2","","0","5","2022-03-30 12:49:05");
INSERT INTO tbl_purchase VALUES("52","PUR300322114","","SU","1","0.00","36500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36500.00","0","","","2022-03-30","","36500.00","0.00","","LE_2","","0","5","2022-03-30 12:50:32");
INSERT INTO tbl_purchase VALUES("53","PUR300322115","","SU","1","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2022-03-30","","19250.00","0.00","","LE_2","","0","5","2022-03-30 12:52:09");
INSERT INTO tbl_purchase VALUES("54","PUR300322116","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2022-03-30","","17500.00","0.00","","LE_2","","0","5","2022-03-30 12:56:44");
INSERT INTO tbl_purchase VALUES("55","PUR300322117","","SU","1","0.00","32500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32500.00","0","","","2022-03-30","","32500.00","0.00","","LE_2","","0","5","2022-03-30 12:59:25");
INSERT INTO tbl_purchase VALUES("56","PUR300322118","","SU","1","0.00","135000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135000.00","0","","","2022-03-30","","135000.00","0.00","","LE_2","","0","5","2022-03-30 01:01:34");
INSERT INTO tbl_purchase VALUES("57","PUR300322119","","SU","1","0.00","14500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14500.00","0","","","2022-03-30","","14500.00","0.00","","LE_2","","0","5","2022-03-30 04:25:17");
INSERT INTO tbl_purchase VALUES("58","PUR300322120","","SU","1","0.00","450000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450000.00","0","","","2022-03-30","","450000.00","0.00","","LE_2","","0","5","2022-03-30 04:46:04");
INSERT INTO tbl_purchase VALUES("59","PUR300322121","","SU","1","0.00","201000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","201000.00","0","","","2022-03-30","","201000.00","0.00","","LE_2","","0","5","2022-03-30 05:29:32");
INSERT INTO tbl_purchase VALUES("60","PUR300322122","","SU","1","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2022-03-30","","58000.00","0.00","","LE_2","","0","5","2022-03-30 06:17:22");
INSERT INTO tbl_purchase VALUES("61","PUR300322123","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2022-03-30","","17500.00","0.00","","LE_2","","0","5","2022-03-30 08:37:56");
INSERT INTO tbl_purchase VALUES("62","PUR310322101","","SU","1","0.00","315000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","315000.00","0","","","2022-03-31","","315000.00","0.00","","LE_2","","0","5","2022-03-31 11:41:17");
INSERT INTO tbl_purchase VALUES("63","PUR310322102","","SU","1","0.00","86000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86000.00","0","","","2022-03-31","","86000.00","0.00","","LE_2","","0","5","2022-03-31 11:52:06");
INSERT INTO tbl_purchase VALUES("64","PUR310322103","","SU","5","0.00","25500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25500.00","0","","","2022-03-31","","25500.00","0.00","","LE_2","","0","5","2022-03-31 05:01:00");
INSERT INTO tbl_purchase VALUES("65","PUR310322104","","SU","2","0.00","103000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103000.00","0","","","2022-03-31","2022-04-07","0.00","0.00","","LE_2","","0","5","2022-03-31 06:26:58");
INSERT INTO tbl_purchase VALUES("66","PUR010422101","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-04-01","","26000.00","0.00","","LE_2","","0","5","2022-04-01 11:43:17");
INSERT INTO tbl_purchase VALUES("67","PUR010422102","","SU","1","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2022-04-01","","29000.00","0.00","","LE_2","","0","5","2022-04-01 12:34:32");
INSERT INTO tbl_purchase VALUES("68","PUR010422103","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-04-01","","19000.00","0.00","","LE_2","","0","5","2022-04-01 01:28:47");
INSERT INTO tbl_purchase VALUES("69","PUR010422104","","SU","1","0.00","79000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","79000.00","0","","","2022-04-01","","79000.00","0.00","","LE_2","","0","5","2022-04-01 02:23:05");
INSERT INTO tbl_purchase VALUES("70","PUR020422101","","SU","1","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-04-02","","10000.00","0.00","","LE_2","","0","5","2022-04-02 01:26:55");
INSERT INTO tbl_purchase VALUES("71","PUR030422101","","SU","1","0.00","81000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81000.00","0","","","2022-04-03","","81000.00","0.00","","LE_2","","0","5","2022-04-03 04:26:51");
INSERT INTO tbl_purchase VALUES("72","PUR070422101","","SU","2","0.00","369000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","369000.00","0","","","2022-04-07","2022-04-14","0.00","0.00","","LE_2","","0","5","2022-04-07 01:37:41");
INSERT INTO tbl_purchase VALUES("73","PUR070422102","","SU","1","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2022-04-07","","17000.00","0.00","","LE_2","","0","5","2022-04-07 02:17:35");
INSERT INTO tbl_purchase VALUES("74","PUR070422103","","SU","2","0.00","136500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","136500.00","0","","","2022-04-07","2022-04-14","0.00","0.00","","LE_2","","0","5","2022-04-07 03:43:34");
INSERT INTO tbl_purchase VALUES("75","PUR090422101","","SU","1","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-04-09","","10000.00","0.00","","LE_2","","0","5","2022-04-09 03:21:46");
INSERT INTO tbl_purchase VALUES("76","PUR100422101","","SU","1","0.00","49000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49000.00","0","","","2022-04-10","","49000.00","0.00","","LE_2","","0","5","2022-04-10 01:23:56");
INSERT INTO tbl_purchase VALUES("77","PUR100422102","","SU","1","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-04-10","","10000.00","0.00","","LE_2","","0","5","2022-04-10 02:23:57");
INSERT INTO tbl_purchase VALUES("78","PUR100422103","","SU","1","0.00","29500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29500.00","0","","","2022-04-10","","29500.00","0.00","","LE_2","","0","5","2022-04-10 03:46:44");
INSERT INTO tbl_purchase VALUES("79","PUR110422101","","SU","1","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2022-04-11","","75000.00","0.00","","LE_2","","0","5","2022-04-11 06:14:29");
INSERT INTO tbl_purchase VALUES("80","PUR120422101","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-04-12","","20000.00","0.00","","LE_2","","0","5","2022-04-12 10:47:01");
INSERT INTO tbl_purchase VALUES("81","PUR120422102","","SU","1","0.00","1886500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1886500.00","0","","","2022-04-12","","1886500.00","0.00","","LE_2","","0","5","2022-04-12 02:25:43");
INSERT INTO tbl_purchase VALUES("82","PUR120422103","","SU","1","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2022-04-12","","24500.00","0.00","","LE_2","","0","5","2022-04-12 02:26:36");
INSERT INTO tbl_purchase VALUES("83","PUR120422104","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-04-12","","26000.00","0.00","","LE_2","","0","5","2022-04-12 04:37:01");
INSERT INTO tbl_purchase VALUES("84","PUR130422101","","SU","1","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-04-13","","22000.00","0.00","","LE_2","","0","5","2022-04-13 04:27:24");
INSERT INTO tbl_purchase VALUES("85","PUR130422102","","SU","1","0.00","25500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25500.00","0","","","2022-04-13","","25500.00","0.00","","LE_2","","0","5","2022-04-13 04:32:37");
INSERT INTO tbl_purchase VALUES("86","PUR160422101","","SU","1","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-04-16","","28000.00","0.00","","LE_2","","0","5","2022-04-16 03:36:16");
INSERT INTO tbl_purchase VALUES("87","PUR190422101","","SU","1","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-04-19","","31500.00","0.00","","LE_2","","0","5","2022-04-19 03:57:30");
INSERT INTO tbl_purchase VALUES("88","PUR210422101","","SU","1","0.00","25500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25500.00","0","","","2022-04-21","","25500.00","0.00","","LE_2","","0","5","2022-04-21 02:07:36");
INSERT INTO tbl_purchase VALUES("89","PUR210422102","","SU","6","0.00","32000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32000.00","0","","","2022-04-21","2022-04-28","25000.00","0.00","","LE_2","","0","5","2022-04-21 05:09:24");
INSERT INTO tbl_purchase VALUES("90","PUR220422101","","SU","1","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2022-04-22","","35000.00","0.00","","LE_2","","0","5","2022-04-22 02:58:16");
INSERT INTO tbl_purchase VALUES("91","PUR220422102","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-04-22","","20000.00","0.00","","LE_2","","0","5","2022-04-22 05:00:32");
INSERT INTO tbl_purchase VALUES("92","PUR220422103","","SU","6","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-04-22","2022-04-29","20000.00","0.00","","LE_2","","0","5","2022-04-22 05:04:41");
INSERT INTO tbl_purchase VALUES("93","PUR230422101","","SU","1","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2022-04-23","","24500.00","0.00","","LE_2","","0","5","2022-04-23 03:04:31");
INSERT INTO tbl_purchase VALUES("94","PUR230422102","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2022-04-23","","17500.00","0.00","","LE_2","","0","5","2022-04-23 04:04:54");
INSERT INTO tbl_purchase VALUES("95","PUR230422103","","SU","6","0.00","8500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8500.00","0","","","2022-04-23","","8500.00","0.00","","LE_2","","0","5","2022-04-23 05:07:35");
INSERT INTO tbl_purchase VALUES("96","PUR250422101","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-04-25","","15000.00","0.00","","LE_2","","0","5","2022-04-25 03:47:23");
INSERT INTO tbl_purchase VALUES("97","PUR260422101","","SU","8","0.00","74000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74000.00","0","","","2022-04-26","2022-05-03","0.00","0.00","","LE_2","","0","5","2022-04-26 03:54:15");
INSERT INTO tbl_purchase VALUES("98","PUR260422102","","SU","7","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2022-04-26","2022-05-03","0.00","0.00","","LE_2","","0","5","2022-04-26 03:55:04");
INSERT INTO tbl_purchase VALUES("99","PUR260422103","","SU","6","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2022-04-26","2022-05-03","10000.00","0.00","","LE_2","","0","5","2022-04-26 06:26:27");
INSERT INTO tbl_purchase VALUES("100","PUR290422101","","SU","1","0.00","14000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14000.00","0","","","2022-04-29","","14000.00","0.00","","LE_2","","0","5","2022-04-29 11:22:09");
INSERT INTO tbl_purchase VALUES("101","PUR290422102","","SU","9","0.00","255500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","255500.00","0","","","2022-04-29","2022-05-06","0.00","0.00","","LE_2","","0","5","2022-04-29 01:02:11");
INSERT INTO tbl_purchase VALUES("102","PUR080522101","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-05-08","","15000.00","0.00","","LE_2","","0","5","2022-05-08 03:01:39");
INSERT INTO tbl_purchase VALUES("103","PUR090522101","","SU","1","0.00","217000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","217000.00","0","","","2022-05-09","","217000.00","0.00","","LE_2","","0","5","2022-05-09 05:59:46");
INSERT INTO tbl_purchase VALUES("104","PUR090522102","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-05-09","","15000.00","0.00","","LE_2","","0","5","2022-05-09 08:22:00");
INSERT INTO tbl_purchase VALUES("105","PUR110522101","","SU","1","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2022-05-11","","90000.00","0.00","","LE_2","","0","5","2022-05-11 05:59:51");
INSERT INTO tbl_purchase VALUES("106","PUR120522101","","SU","10","0.00","312000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","312000.00","0","","","2022-05-12","","312000.00","0.00","","LE_2","","0","5","2022-05-12 11:31:31");
INSERT INTO tbl_purchase VALUES("107","PUR120522102","","SU","10","0.00","13000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13000.00","0","","","2022-05-12","","13000.00","0.00","","LE_2","","0","5","2022-05-12 11:37:03");
INSERT INTO tbl_purchase VALUES("108","PUR120522103","","SU","11","0.00","8000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8000.00","0","","","2022-05-12","2022-05-19","0.00","0.00","","LE_2","","0","5","2022-05-12 02:48:43");
INSERT INTO tbl_purchase VALUES("109","PUR120522104","","SU","2","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-05-12","2022-05-19","0.00","0.00","","LE_2","","0","5","2022-05-12 06:57:53");
INSERT INTO tbl_purchase VALUES("110","PUR120522105","","SU","6","0.00","2400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2400.00","0","","","2022-05-12","","2400.00","0.00","","LE_2","","0","5","2022-05-12 07:17:39");
INSERT INTO tbl_purchase VALUES("111","PUR120522106","","SU","11","0.00","14960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14960.00","0","","","2022-05-12","","14960.00","0.00","","LE_2","","0","5","2022-05-12 07:23:27");
INSERT INTO tbl_purchase VALUES("112","PUR140522101","","SU","12","0.00","87000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87000.00","0","","","2022-05-14","2022-05-21","0.00","0.00","","LE_2","","0","5","2022-05-14 02:34:58");
INSERT INTO tbl_purchase VALUES("113","PUR140522102","","SU","14","0.00","116000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116000.00","0","","","2022-05-14","2022-05-21","0.00","0.00","","LE_2","","0","5","2022-05-14 07:17:25");
INSERT INTO tbl_purchase VALUES("114","PUR150522101","","SU","10","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-05-15","","22000.00","0.00","","LE_2","","0","5","2022-05-15 05:23:23");
INSERT INTO tbl_purchase VALUES("115","PUR150522102","","SU","13","0.00","187500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","187500.00","0","","","2022-05-15","2022-05-22","100000.00","0.00","","LE_2","","0","5","2022-05-15 07:28:14");
INSERT INTO tbl_purchase VALUES("116","PUR190522101","","SU","9","0.00","85500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85500.00","0","","","2022-05-19","","90000.00","4500.00","","LE_2","","0","5","2022-05-19 11:35:59");
INSERT INTO tbl_purchase VALUES("117","PUR190522102","","SU","10","0.00","44000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","44000.00","0","","","2022-05-19","","44000.00","0.00","","LE_2","","0","5","2022-05-19 06:25:50");
INSERT INTO tbl_purchase VALUES("118","PUR190522103","","SU","13","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2022-05-19","2022-05-26","0.00","0.00","","LE_2","","0","5","2022-05-19 07:29:25");
INSERT INTO tbl_purchase VALUES("119","PUR210522101","","SU","15","0.00","140400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140400.00","0","","","2022-05-21","","140400.00","0.00","","LE_2","","0","5","2022-05-21 02:13:52");
INSERT INTO tbl_purchase VALUES("120","PUR210522102","","SU","5","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-05-21","","25000.00","0.00","","LE_2","","0","5","2022-05-21 02:23:36");
INSERT INTO tbl_purchase VALUES("121","PUR210522103","","SU","9","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-05-21","2022-05-28","4500.00","0.00","","LE_2","","0","5","2022-05-21 02:34:34");
INSERT INTO tbl_purchase VALUES("122","PUR210522104","","SU","10","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-05-21","","15000.00","0.00","","LE_2","","0","5","2022-05-21 07:36:37");
INSERT INTO tbl_purchase VALUES("123","PUR210522105","","SU","10","0.00","97000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","97000.00","0","","","2022-05-21","","97000.00","0.00","","LE_2","","0","5","2022-05-21 08:14:58");
INSERT INTO tbl_purchase VALUES("124","PUR220522101","","SU","15","0.00","140400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140400.00","0","","","2022-05-22","","140400.00","0.00","","LE_2","","0","5","2022-05-22 05:26:27");
INSERT INTO tbl_purchase VALUES("125","PUR220522102","","SU","15","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-05-22","","38600.00","0.00","","LE_2","","0","5","2022-05-22 05:28:51");
INSERT INTO tbl_purchase VALUES("126","PUR220522103","","SU","9","0.00","77000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77000.00","0","","","2022-05-22","2022-05-29","0.00","0.00","","LE_2","","0","5","2022-05-22 06:00:35");
INSERT INTO tbl_purchase VALUES("127","PUR230522101","","SU","13","0.00","46000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46000.00","0","","","2022-05-23","2022-05-30","6000.00","0.00","","LE_2","","0","5","2022-05-23 04:13:04");
INSERT INTO tbl_purchase VALUES("128","PUR230522102","","SU","9","0.00","167500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","167500.00","0","","","2022-05-23","2022-05-30","0.00","0.00","","LE_2","","0","5","2022-05-23 04:58:55");
INSERT INTO tbl_purchase VALUES("129","PUR230522103","","SU","9","0.00","38500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38500.00","0","","","2022-05-23","2022-05-30","0.00","0.00","","LE_2","","0","5","2022-05-23 05:27:57");
INSERT INTO tbl_purchase VALUES("130","PUR240522101","","SU","9","0.00","28500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28500.00","0","","","2022-05-24","2022-05-31","0.00","0.00","","LE_2","","0","5","2022-05-24 12:53:16");
INSERT INTO tbl_purchase VALUES("131","PUR240522102","","SU","15","0.00","181700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","181700.00","0","","","2022-05-24","","181700.00","0.00","","LE_2","","0","5","2022-05-24 01:15:51");
INSERT INTO tbl_purchase VALUES("132","PUR250522101","","SU","10","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-05-25","","25000.00","0.00","","LE_2","","0","5","2022-05-25 06:27:26");
INSERT INTO tbl_purchase VALUES("133","PUR260522101","","SU","10","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-05-26","","25000.00","0.00","","LE_2","","0","5","2022-05-26 03:51:13");
INSERT INTO tbl_purchase VALUES("134","PUR270522101","","SU","1","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2022-05-27","","50000.00","0.00","","LE_2","","0","5","2022-05-27 03:57:41");
INSERT INTO tbl_purchase VALUES("135","PUR270522102","","SU","15","0.00","106700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106700.00","0","","","2022-05-27","","106700.00","0.00","","LE_2","","0","5","2022-05-27 03:59:24");
INSERT INTO tbl_purchase VALUES("136","PUR270522103","","SU","16","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2022-05-27","","24000.00","0.00","","LE_2","","0","5","2022-05-27 04:35:37");
INSERT INTO tbl_purchase VALUES("137","PUR270522104","","SU","13","0.00","63000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63000.00","0","","","2022-05-27","2022-06-03","0.00","0.00","","LE_2","","0","5","2022-05-27 08:10:24");
INSERT INTO tbl_purchase VALUES("138","PUR280522101","","SU","16","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2022-05-28","2022-06-04","5000.00","0.00","","LE_2","","0","5","2022-05-28 07:07:43");
INSERT INTO tbl_purchase VALUES("139","PUR280522102","","SU","1","0.00","2000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2000.00","0","","","2022-05-28","2022-06-04","0.00","0.00","","LE_2","","0","5","2022-05-28 07:11:11");
INSERT INTO tbl_purchase VALUES("140","PUR290522101","","SU","15","0.00","197500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197500.00","0","","","2022-05-29","","197500.00","0.00","","LE_2","","0","5","2022-05-29 04:26:45");
INSERT INTO tbl_purchase VALUES("141","PUR300522101","","SU","16","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-05-30","","25000.00","0.00","","LE_2","","0","5","2022-05-30 08:23:20");
INSERT INTO tbl_purchase VALUES("142","PUR010622101","","SU","15","0.00","210600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","210600.00","0","","","2022-06-01","","310600.00","100000.00","","LE_2","","0","5","2022-06-01 05:25:15");
INSERT INTO tbl_purchase VALUES("143","PUR010622102","","SU","15","0.00","69000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69000.00","0","","","2022-06-01","","69000.00","0.00","","LE_2","","0","5","2022-06-01 05:27:46");
INSERT INTO tbl_purchase VALUES("144","PUR010622103","","SU","1","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2022-06-01","","38000.00","0.00","","LE_2","","0","5","2022-06-01 05:31:06");
INSERT INTO tbl_purchase VALUES("145","PUR020622101","","SU","12","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2022-06-02","2022-06-09","15000.00","0.00","","LE_2","","0","5","2022-06-02 06:44:44");
INSERT INTO tbl_purchase VALUES("146","PUR020622102","","SU","12","0.00","28500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28500.00","0","","","2022-06-02","2022-06-09","0.00","0.00","","LE_2","","0","5","2022-06-02 07:06:28");
INSERT INTO tbl_purchase VALUES("147","PUR020622103","","SU","15","0.00","63500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63500.00","0","","","2022-06-02","2022-06-09","0.00","0.00","","LE_2","","0","5","2022-06-02 07:08:57");
INSERT INTO tbl_purchase VALUES("148","PUR020622104","","SU","15","0.00","25500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25500.00","0","","","2022-06-02","","25500.00","0.00","","LE_2","","0","5","2022-06-02 07:10:57");
INSERT INTO tbl_purchase VALUES("149","PUR030622101","","SU","15","0.00","464400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","464400.00","0","","","2022-06-03","","464400.00","0.00","","LE_2","","0","5","2022-06-03 01:39:47");
INSERT INTO tbl_purchase VALUES("150","PUR030622102","","SU","1","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2022-06-03","","38000.00","0.00","","LE_2","","0","5","2022-06-03 06:58:13");
INSERT INTO tbl_purchase VALUES("151","PUR030622103","","SU","12","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-06-03","2022-06-10","0.00","0.00","","LE_2","","0","5","2022-06-03 08:22:46");
INSERT INTO tbl_purchase VALUES("152","PUR040622101","","SU","17","0.00","37500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37500.00","0","","","2022-06-04","","37500.00","0.00","","LE_2","","0","5","2022-06-04 12:15:42");
INSERT INTO tbl_purchase VALUES("153","PUR040622102","","SU","15","0.00","158000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","158000.00","0","","","2022-06-04","","158000.00","0.00","","LE_2","","0","5","2022-06-04 05:26:28");
INSERT INTO tbl_purchase VALUES("154","PUR040622103","","SU","15","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2022-06-04","","51000.00","0.00","","LE_2","","0","5","2022-06-04 05:28:08");
INSERT INTO tbl_purchase VALUES("155","PUR040622104","","SU","15","0.00","105300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105300.00","0","","","2022-06-04","","105300.00","0.00","","LE_2","","0","5","2022-06-04 05:31:24");
INSERT INTO tbl_purchase VALUES("156","PUR050622101","","SU","1","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-06-05","","31500.00","0.00","","LE_2","","0","5","2022-06-05 05:57:37");
INSERT INTO tbl_purchase VALUES("157","PUR060622101","","SU","16","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2022-06-06","2022-06-13","0.00","0.00","","LE_2","","0","5","2022-06-06 11:37:34");
INSERT INTO tbl_purchase VALUES("158","PUR080622101","","SU","15","0.00","140400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140400.00","0","","","2022-06-08","","140400.00","0.00","","LE_2","","0","5","2022-06-08 02:16:07");
INSERT INTO tbl_purchase VALUES("159","PUR090622101","","SU","15","0.00","39500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39500.00","0","","","2022-06-09","","39500.00","0.00","","LE_2","","0","5","2022-06-09 12:11:52");
INSERT INTO tbl_purchase VALUES("160","PUR090622102","","SU","15","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-06-09","","15000.00","0.00","","LE_2","","0","5","2022-06-09 12:27:07");
INSERT INTO tbl_purchase VALUES("161","PUR090622103","","SU","15","0.00","39500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39500.00","0","","","2022-06-09","","39500.00","0.00","","LE_2","","0","5","2022-06-09 02:54:17");
INSERT INTO tbl_purchase VALUES("162","PUR090622104","","SU","15","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-06-09","","15000.00","0.00","","LE_2","","0","5","2022-06-09 07:20:54");
INSERT INTO tbl_purchase VALUES("163","PUR090622105","","SU","15","0.00","35100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35100.00","0","","","2022-06-09","","35100.00","0.00","","LE_2","","0","5","2022-06-09 07:24:41");
INSERT INTO tbl_purchase VALUES("164","PUR090622106","","SU","17","0.00","87700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87700.00","0","","","2022-06-09","","87700.00","0.00","","LE_2","","0","5","2022-06-09 11:24:32");
INSERT INTO tbl_purchase VALUES("165","PUR100622101","","SU","15","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-06-10","","20000.00","0.00","","LE_2","","0","5","2022-06-10 07:38:44");
INSERT INTO tbl_purchase VALUES("166","PUR110622101","","SU","15","0.00","285600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285600.00","0","","","2022-06-11","","285600.00","0.00","","LE_2","","0","5","2022-06-11 08:03:28");
INSERT INTO tbl_purchase VALUES("167","PUR130622101","","SU","15","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-06-13","","31500.00","0.00","","LE_2","","0","5","2022-06-13 01:47:53");
INSERT INTO tbl_purchase VALUES("168","PUR130622102","","SU","15","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-06-13","","31500.00","0.00","","LE_2","","0","5","2022-06-13 01:56:05");
INSERT INTO tbl_purchase VALUES("169","PUR130622103","","SU","15","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-06-13","","31500.00","0.00","","LE_2","","0","5","2022-06-13 01:58:51");
INSERT INTO tbl_purchase VALUES("170","PUR130622104","","SU","16","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-06-13","","23000.00","0.00","","LE_2","","0","5","2022-06-13 02:38:21");
INSERT INTO tbl_purchase VALUES("171","PUR130622105","","SU","10","0.00","14000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14000.00","0","","","2022-06-13","","14000.00","0.00","","LE_2","","0","5","2022-06-13 03:58:00");
INSERT INTO tbl_purchase VALUES("172","PUR130622106","","SU","15","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-06-13","","10000.00","0.00","","LE_2","","0","5","2022-06-13 04:43:44");
INSERT INTO tbl_purchase VALUES("173","PUR150622101","","SU","15","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-06-15","","21500.00","0.00","","LE_2","","0","5","2022-06-15 12:36:05");
INSERT INTO tbl_purchase VALUES("174","PUR150622102","","SU","15","0.00","494500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","494500.00","0","","","2022-06-15","","494500.00","0.00","","LE_2","","0","5","2022-06-15 12:48:48");
INSERT INTO tbl_purchase VALUES("175","PUR150622103","","SU","15","0.00","35100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35100.00","0","","","2022-06-15","","35100.00","0.00","","LE_2","","0","5","2022-06-15 12:49:32");
INSERT INTO tbl_purchase VALUES("176","PUR150622104","","SU","15","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-06-15","","64500.00","0.00","","LE_2","","0","5","2022-06-15 03:13:45");
INSERT INTO tbl_purchase VALUES("177","PUR160622101","","SU","15","0.00","69500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69500.00","0","","","2022-06-16","","69500.00","0.00","","LE_2","","0","5","2022-06-16 06:47:25");
INSERT INTO tbl_purchase VALUES("178","PUR160622102","","SU","15","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-06-16","","10000.00","0.00","","LE_2","","0","5","2022-06-16 06:48:22");
INSERT INTO tbl_purchase VALUES("179","PUR160622103","","SU","15","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2022-06-16","","24500.00","0.00","","LE_2","","0","5","2022-06-16 06:49:41");
INSERT INTO tbl_purchase VALUES("180","PUR180622101","","SU","15","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2022-06-18","","24500.00","0.00","","LE_2","","0","5","2022-06-18 11:25:40");
INSERT INTO tbl_purchase VALUES("181","PUR180622102","","SU","15","0.00","129000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129000.00","0","","","2022-06-18","","129000.00","0.00","","LE_2","","0","5","2022-06-18 07:19:50");
INSERT INTO tbl_purchase VALUES("182","PUR180622103","","SU","15","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-06-18","","21500.00","0.00","","LE_2","","0","5","2022-06-18 07:25:20");
INSERT INTO tbl_purchase VALUES("183","PUR180622104","","SU","16","0.00","56500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56500.00","0","","","2022-06-18","2022-06-25","0.00","0.00","","LE_2","","0","5","2022-06-18 07:34:25");
INSERT INTO tbl_purchase VALUES("184","PUR190622101","","SU","15","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2022-06-19","","27000.00","0.00","","LE_2","","0","5","2022-06-19 07:39:03");
INSERT INTO tbl_purchase VALUES("185","PUR190622102","","SU","15","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-06-19","","10000.00","0.00","","LE_2","","0","5","2022-06-19 08:05:18");
INSERT INTO tbl_purchase VALUES("186","PUR200622101","","SU","15","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-06-20","","64500.00","0.00","","LE_2","","0","5","2022-06-20 04:47:54");
INSERT INTO tbl_purchase VALUES("187","PUR200622102","","SU","15","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-06-20","2022-06-27","0.00","0.00","","LE_2","","0","5","2022-06-20 05:10:39");
INSERT INTO tbl_purchase VALUES("188","PUR200622103","","SU","15","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-06-20","","21500.00","0.00","","LE_2","","0","5","2022-06-20 07:09:11");
INSERT INTO tbl_purchase VALUES("189","PUR200622104","","SU","15","0.00","7000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7000.00","0","","","2022-06-20","","7000.00","0.00","","LE_2","","0","5","2022-06-20 07:50:25");
INSERT INTO tbl_purchase VALUES("190","PUR220622101","","SU","15","0.00","246600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","246600.00","0","","","2022-06-22","","246600.00","0.00","","LE_2","","0","5","2022-06-22 04:17:19");
INSERT INTO tbl_purchase VALUES("191","PUR220622102","","SU","10","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2022-06-22","","40000.00","0.00","","LE_2","","0","5","2022-06-22 04:46:12");
INSERT INTO tbl_purchase VALUES("192","PUR220622103","","SU","16","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-06-22","2022-06-29","0.00","0.00","","LE_2","","0","5","2022-06-22 06:36:41");
INSERT INTO tbl_purchase VALUES("193","PUR220622104","","SU","10","0.00","41000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41000.00","0","","","2022-06-22","","41000.00","0.00","","LE_2","","0","5","2022-06-22 07:38:34");
INSERT INTO tbl_purchase VALUES("194","PUR230622101","","SU","15","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-06-23","","64500.00","0.00","","LE_2","","0","5","2022-06-23 07:43:04");
INSERT INTO tbl_purchase VALUES("195","PUR240622101","","SU","10","0.00","76860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76860.00","0","","","2022-06-24","","76860.00","0.00","","LE_2","","0","5","2022-06-24 11:22:08");
INSERT INTO tbl_purchase VALUES("196","PUR240622102","","SU","15","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-06-24","","21500.00","0.00","","LE_2","","0","5","2022-06-24 11:47:16");
INSERT INTO tbl_purchase VALUES("197","PUR240622103","","SU","16","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-06-24","2022-07-01","0.00","0.00","","LE_2","","0","5","2022-06-24 05:59:21");
INSERT INTO tbl_purchase VALUES("198","PUR240622104","","SU","15","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2022-06-24","","60000.00","0.00","","LE_2","","0","5","2022-06-24 06:25:54");
INSERT INTO tbl_purchase VALUES("199","PUR250622101","","SU","15","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-06-25","","64500.00","0.00","","LE_2","","0","5","2022-06-25 06:42:31");
INSERT INTO tbl_purchase VALUES("200","PUR270622101","","SU","15","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2022-06-27","","33000.00","0.00","","LE_2","","0","5","2022-06-27 02:41:55");
INSERT INTO tbl_purchase VALUES("201","PUR270622102","","SU","6","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-06-27","","20000.00","0.00","","LE_2","","0","5","2022-06-27 07:50:15");
INSERT INTO tbl_purchase VALUES("202","PUR270622103","","SU","16","0.00","41000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41000.00","0","","","2022-06-27","2022-07-04","20000.00","0.00","","LE_2","","0","5","2022-06-27 07:54:33");
INSERT INTO tbl_purchase VALUES("203","PUR290622101","","SU","10","0.00","129000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129000.00","0","","","2022-06-29","","129000.00","0.00","","LE_2","","0","5","2022-06-29 04:26:49");
INSERT INTO tbl_purchase VALUES("204","PUR290622102","","SU","3","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-06-29","","23000.00","0.00","","LE_2","","0","5","2022-06-29 05:36:26");
INSERT INTO tbl_purchase VALUES("205","PUR300622101","","SU","16","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-06-30","","16500.00","0.00","","LE_2","","0","5","2022-06-30 01:59:57");
INSERT INTO tbl_purchase VALUES("206","PUR300622102","","SU","10","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2022-06-30","","75000.00","0.00","","LE_2","","0","5","2022-06-30 04:25:17");
INSERT INTO tbl_purchase VALUES("207","PUR300622103","","SU","15","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-06-30","","43000.00","0.00","","LE_2","","0","5","2022-06-30 07:50:48");
INSERT INTO tbl_purchase VALUES("208","PUR020722101","","SU","15","0.00","23250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23250.00","0","","","2022-07-02","","23250.00","0.00","","LE_2","","0","5","2022-07-02 05:55:15");
INSERT INTO tbl_purchase VALUES("209","PUR020722102","","SU","15","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-07-02","","43000.00","0.00","","LE_2","","0","5","2022-07-02 06:28:57");
INSERT INTO tbl_purchase VALUES("210","PUR020722103","","SU","18","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-07-02","2022-07-09","0.00","0.00","","LE_2","","0","5","2022-07-02 07:11:35");
INSERT INTO tbl_purchase VALUES("211","PUR020722104","","SU","15","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2022-07-02","","47000.00","0.00","","LE_2","","0","5","2022-07-02 08:54:11");
INSERT INTO tbl_purchase VALUES("212","PUR030722101","","SU","15","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-07-03","","21500.00","0.00","","LE_2","","0","5","2022-07-03 01:17:50");
INSERT INTO tbl_purchase VALUES("213","PUR030722102","","SU","10","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-07-03","","21500.00","0.00","","LE_2","","0","5","2022-07-03 01:26:12");
INSERT INTO tbl_purchase VALUES("214","PUR030722103","","SU","10","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-07-03","","21500.00","0.00","","LE_2","","0","5","2022-07-03 05:14:06");
INSERT INTO tbl_purchase VALUES("215","PUR030722104","","SU","10","0.00","86000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86000.00","0","","","2022-07-03","","86000.00","0.00","","LE_2","","0","5","2022-07-03 05:52:38");
INSERT INTO tbl_purchase VALUES("216","PUR030722105","","SU","10","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-07-03","","21500.00","0.00","","LE_2","","0","5","2022-07-03 08:54:52");
INSERT INTO tbl_purchase VALUES("217","PUR030722106","","SU","6","0.00","12000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12000.00","0","","","2022-07-03","2022-07-10","0.00","0.00","","LE_2","","0","5","2022-07-03 09:00:11");
INSERT INTO tbl_purchase VALUES("218","PUR030722107","","SU","15","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-07-03","","22000.00","0.00","","LE_2","","0","5","2022-07-03 09:10:04");
INSERT INTO tbl_purchase VALUES("219","PUR040722101","","SU","10","0.00","107500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107500.00","0","","","2022-07-04","","107500.00","0.00","","LE_2","","0","5","2022-07-04 04:29:12");
INSERT INTO tbl_purchase VALUES("220","PUR050722101","","SU","15","0.00","107500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107500.00","0","","","2022-07-05","","107500.00","0.00","","LE_2","","0","5","2022-07-05 12:40:51");
INSERT INTO tbl_purchase VALUES("221","PUR050722102","","SU","16","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2022-07-05","2022-07-12","0.00","0.00","","LE_2","","0","5","2022-07-05 12:54:11");
INSERT INTO tbl_purchase VALUES("222","PUR060722101","","SU","15","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-07-06","","43000.00","0.00","","LE_2","","0","5","2022-07-06 04:36:49");
INSERT INTO tbl_purchase VALUES("223","PUR060722102","","SU","10","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-07-06","","64500.00","0.00","","LE_2","","0","5","2022-07-06 07:31:24");
INSERT INTO tbl_purchase VALUES("224","PUR060722103","","SU","10","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-07-06","","43000.00","0.00","","LE_2","","0","5","2022-07-06 07:44:10");
INSERT INTO tbl_purchase VALUES("225","PUR060722104","","SU","10","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-07-06","2022-07-13","0.00","0.00","","LE_2","","0","5","2022-07-06 08:15:48");
INSERT INTO tbl_purchase VALUES("226","PUR070722101","","SU","10","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-07-07","","38600.00","0.00","","LE_2","","0","5","2022-07-07 07:07:18");
INSERT INTO tbl_purchase VALUES("227","PUR080722101","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-08","","19300.00","0.00","","LE_2","","0","5","2022-07-08 01:31:37");
INSERT INTO tbl_purchase VALUES("228","PUR080722102","","SU","10","0.00","77200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77200.00","0","","","2022-07-08","","77200.00","0.00","","LE_2","","0","5","2022-07-08 03:49:29");
INSERT INTO tbl_purchase VALUES("229","PUR140722101","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-14","","19300.00","0.00","","LE_2","","0","5","2022-07-14 02:46:38");
INSERT INTO tbl_purchase VALUES("230","PUR150722101","","SU","15","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2022-07-15","","17000.00","0.00","","LE_2","","0","5","2022-07-15 01:58:13");
INSERT INTO tbl_purchase VALUES("231","PUR150722102","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-15","","19300.00","0.00","","LE_2","","0","5","2022-07-15 05:16:16");
INSERT INTO tbl_purchase VALUES("232","PUR160722101","","SU","10","0.00","57900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57900.00","0","","","2022-07-16","","57900.00","0.00","","LE_2","","0","5","2022-07-16 03:17:43");
INSERT INTO tbl_purchase VALUES("233","PUR160722102","","SU","10","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2022-07-16","","24500.00","0.00","","LE_2","","0","5","2022-07-16 03:18:41");
INSERT INTO tbl_purchase VALUES("234","PUR160722103","","SU","1","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2022-07-16","","40000.00","0.00","","LE_2","","0","5","2022-07-16 06:53:12");
INSERT INTO tbl_purchase VALUES("235","PUR180722101","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-18","2022-07-25","0.00","0.00","","LE_2","","0","5","2022-07-18 06:25:15");
INSERT INTO tbl_purchase VALUES("236","PUR200722101","","SU","15","0.00","212300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","212300.00","0","","","2022-07-20","","212300.00","0.00","","LE_2","","0","5","2022-07-20 06:44:36");
INSERT INTO tbl_purchase VALUES("237","PUR200722102","","SU","10","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-07-20","","21000.00","0.00","","LE_2","","0","5","2022-07-20 06:46:01");
INSERT INTO tbl_purchase VALUES("238","PUR200722103","","SU","10","0.00","152500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152500.00","0","","","2022-07-20","","152500.00","0.00","","LE_2","","0","5","2022-07-20 06:49:44");
INSERT INTO tbl_purchase VALUES("239","PUR200722104","","SU","10","0.00","19500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19500.00","0","","","2022-07-20","","19500.00","0.00","","LE_2","","0","5","2022-07-20 07:25:35");
INSERT INTO tbl_purchase VALUES("240","PUR210722101","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-21","","19300.00","0.00","","LE_2","","0","5","2022-07-21 12:53:58");
INSERT INTO tbl_purchase VALUES("241","PUR210722102","","SU","15","0.00","57900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57900.00","0","","","2022-07-21","","57900.00","0.00","","LE_2","","0","5","2022-07-21 02:08:26");
INSERT INTO tbl_purchase VALUES("242","PUR210722103","","SU","15","0.00","231600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","231600.00","0","","","2022-07-21","","231600.00","0.00","","LE_2","","0","5","2022-07-21 04:33:22");
INSERT INTO tbl_purchase VALUES("243","PUR210722104","","SU","15","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-21","","19300.00","0.00","","LE_2","","0","5","2022-07-21 04:52:09");
INSERT INTO tbl_purchase VALUES("244","PUR220722101","","SU","15","0.00","96500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96500.00","0","","","2022-07-22","","96500.00","0.00","","LE_2","","0","5","2022-07-22 05:49:26");
INSERT INTO tbl_purchase VALUES("245","PUR230722101","","SU","19","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2022-07-23","2022-07-30","0.00","0.00","","LE_2","","0","5","2022-07-23 05:19:06");
INSERT INTO tbl_purchase VALUES("246","PUR240722101","","SU","10","0.00","173700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","173700.00","0","","","2022-07-24","","173700.00","0.00","","LE_2","","0","5","2022-07-24 11:55:26");
INSERT INTO tbl_purchase VALUES("247","PUR240722102","","SU","19","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-07-24","2022-07-31","0.00","0.00","","LE_2","","0","5","2022-07-24 04:46:01");
INSERT INTO tbl_purchase VALUES("248","PUR240722103","","SU","19","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-07-24","2022-07-31","0.00","0.00","","LE_2","","0","5","2022-07-24 04:47:46");
INSERT INTO tbl_purchase VALUES("249","PUR240722104","","SU","19","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-07-24","2022-07-31","0.00","0.00","","LE_2","","0","5","2022-07-24 04:49:31");
INSERT INTO tbl_purchase VALUES("250","PUR240722105","","SU","19","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-07-24","2022-07-31","0.00","0.00","","LE_2","","0","5","2022-07-24 04:54:47");
INSERT INTO tbl_purchase VALUES("251","PUR240722106","","SU","19","0.00","15500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15500.00","0","","","2022-07-24","2022-07-31","0.00","0.00","","LE_2","","0","5","2022-07-24 05:15:50");
INSERT INTO tbl_purchase VALUES("252","PUR250722101","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-25","","19300.00","0.00","","LE_2","","0","5","2022-07-25 04:17:23");
INSERT INTO tbl_purchase VALUES("253","PUR270722101","","SU","10","0.00","97500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","97500.00","0","","","2022-07-27","","97500.00","0.00","","LE_2","","0","5","2022-07-27 11:31:56");
INSERT INTO tbl_purchase VALUES("254","PUR270722102","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-27","","19300.00","0.00","","LE_2","","0","5","2022-07-27 12:02:10");
INSERT INTO tbl_purchase VALUES("255","PUR270722103","","SU","10","0.00","77200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77200.00","0","","","2022-07-27","","77200.00","0.00","","LE_2","","0","5","2022-07-27 03:02:00");
INSERT INTO tbl_purchase VALUES("256","PUR270722104","","SU","10","0.00","46500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46500.00","0","","","2022-07-27","","46500.00","0.00","","LE_2","","0","5","2022-07-27 03:58:35");
INSERT INTO tbl_purchase VALUES("257","PUR270722105","","SU","10","0.00","96500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96500.00","0","","","2022-07-27","","96500.00","0.00","","LE_2","","0","5","2022-07-27 04:24:08");
INSERT INTO tbl_purchase VALUES("258","PUR280722101","","SU","10","0.00","57900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57900.00","0","","","2022-07-28","","57900.00","0.00","","LE_2","","0","5","2022-07-28 02:33:15");
INSERT INTO tbl_purchase VALUES("259","PUR280722102","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-28","","19300.00","0.00","","LE_2","","0","5","2022-07-28 06:16:54");
INSERT INTO tbl_purchase VALUES("260","PUR280722103","","SU","19","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-07-28","2022-08-04","0.00","0.00","","LE_2","","0","5","2022-07-28 07:13:43");
INSERT INTO tbl_purchase VALUES("261","PUR290722101","","SU","10","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-07-29","","38600.00","0.00","","LE_2","","0","5","2022-07-29 03:48:49");
INSERT INTO tbl_purchase VALUES("262","PUR290722102","","SU","10","0.00","57900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57900.00","0","","","2022-07-29","","57900.00","0.00","","LE_2","","0","5","2022-07-29 04:34:05");
INSERT INTO tbl_purchase VALUES("263","PUR290722103","","SU","10","0.00","77200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77200.00","0","","","2022-07-29","","77200.00","0.00","","LE_2","","0","5","2022-07-29 04:52:52");
INSERT INTO tbl_purchase VALUES("264","PUR300722101","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-30","","19300.00","0.00","","LE_2","","0","5","2022-07-30 01:48:49");
INSERT INTO tbl_purchase VALUES("265","PUR300722102","","SU","10","0.00","154400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","154400.00","0","","","2022-07-30","","154400.00","0.00","","LE_2","","0","5","2022-07-30 04:51:12");
INSERT INTO tbl_purchase VALUES("266","PUR300722103","","SU","10","0.00","77200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77200.00","0","","","2022-07-30","","77200.00","0.00","","LE_2","","0","5","2022-07-30 05:15:14");
INSERT INTO tbl_purchase VALUES("267","PUR300722104","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-07-30","","19300.00","0.00","","LE_2","","0","5","2022-07-30 06:48:19");
INSERT INTO tbl_purchase VALUES("268","PUR310722101","","SU","10","0.00","77200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77200.00","0","","","2022-07-31","","77200.00","0.00","","LE_2","","0","5","2022-07-31 03:58:42");
INSERT INTO tbl_purchase VALUES("269","PUR310722102","","SU","10","0.00","57900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57900.00","0","","","2022-07-31","","57900.00","0.00","","LE_2","","0","5","2022-07-31 04:24:45");
INSERT INTO tbl_purchase VALUES("270","PUR310722103","","SU","10","0.00","154400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","154400.00","0","","","2022-07-31","","154400.00","0.00","","LE_2","","0","5","2022-07-31 05:42:57");
INSERT INTO tbl_purchase VALUES("271","PUR010822101","","SU","10","0.00","96500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96500.00","0","","","2022-08-01","","96500.00","0.00","","LE_2","","0","5","2022-08-01 01:47:56");
INSERT INTO tbl_purchase VALUES("272","PUR010822102","","SU","10","0.00","19300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19300.00","0","","","2022-08-01","","19300.00","0.00","","LE_2","","0","5","2022-08-01 05:53:37");
INSERT INTO tbl_purchase VALUES("273","PUR030822101","","SU","10","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-08-03","","38600.00","0.00","","LE_2","","0","5","2022-08-03 02:57:03");
INSERT INTO tbl_purchase VALUES("274","PUR030822102","","SU","20","0.00","235000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","235000.00","0","","","2022-08-03","2022-08-10","0.00","0.00","","LE_2","","0","5","2022-08-03 05:00:21");
INSERT INTO tbl_purchase VALUES("275","PUR050822101","","SU","10","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2022-08-05","","27000.00","0.00","","LE_2","","0","5","2022-08-05 01:37:48");
INSERT INTO tbl_purchase VALUES("276","PUR050822102","","SU","10","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2022-08-05","","80000.00","0.00","","LE_2","","0","5","2022-08-05 01:46:14");
INSERT INTO tbl_purchase VALUES("277","PUR060822101","","SU","20","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2022-08-06","2022-08-13","0.00","0.00","","LE_2","","0","5","2022-08-06 11:46:38");
INSERT INTO tbl_purchase VALUES("278","PUR060822102","","SU","10","0.00","32000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32000.00","0","","","2022-08-06","","32000.00","0.00","","LE_2","","0","5","2022-08-06 07:12:06");
INSERT INTO tbl_purchase VALUES("279","PUR080822101","","SU","20","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2022-08-08","2022-08-15","0.00","0.00","","LE_2","","0","5","2022-08-08 06:11:52");
INSERT INTO tbl_purchase VALUES("280","PUR080822102","","SU","20","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-08-08","2022-08-15","0.00","0.00","","LE_2","","0","5","2022-08-08 07:07:56");
INSERT INTO tbl_purchase VALUES("281","PUR080822103","","SU","20","0.00","230000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","230000.00","0","","","2022-08-08","2022-08-15","0.00","0.00","","LE_2","","0","5","2022-08-08 07:15:15");
INSERT INTO tbl_purchase VALUES("282","PUR080822104","","SU","20","0.00","153000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","153000.00","0","","","2022-08-08","2022-08-15","0.00","0.00","","LE_2","","0","5","2022-08-08 07:22:57");
INSERT INTO tbl_purchase VALUES("283","PUR100822101","","SU","9","0.00","144000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","144000.00","0","","","2022-08-10","2022-08-17","0.00","0.00","","LE_2","","0","5","2022-08-10 07:27:02");
INSERT INTO tbl_purchase VALUES("284","PUR120822101","","SU","10","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-08-12","","19000.00","0.00","","LE_2","","0","5","2022-08-12 01:16:35");
INSERT INTO tbl_purchase VALUES("285","PUR120822102","","SU","9","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2022-08-12","2022-08-19","0.00","0.00","","LE_2","","0","5","2022-08-12 05:49:02");
INSERT INTO tbl_purchase VALUES("286","PUR120822103","","SU","15","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-08-12","","30000.00","0.00","","LE_2","","0","5","2022-08-12 05:55:13");
INSERT INTO tbl_purchase VALUES("287","PUR120822104","","SU","20","0.00","161000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","161000.00","0","","","2022-08-12","2022-08-19","0.00","0.00","","LE_2","","0","5","2022-08-12 07:21:07");
INSERT INTO tbl_purchase VALUES("288","PUR130822101","","SU","20","0.00","91000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91000.00","0","","","2022-08-13","2022-08-20","0.00","0.00","","LE_2","","0","5","2022-08-13 03:04:21");
INSERT INTO tbl_purchase VALUES("289","PUR130822102","","SU","15","0.00","121500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","121500.00","0","","","2022-08-13","","121500.00","0.00","","LE_2","","0","5","2022-08-13 03:53:39");
INSERT INTO tbl_purchase VALUES("290","PUR130822103","","SU","15","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2022-08-13","","100000.00","0.00","","LE_2","","0","5","2022-08-13 05:48:04");
INSERT INTO tbl_purchase VALUES("291","PUR140822101","","SU","21","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-08-14","","15000.00","0.00","","LE_2","","0","5","2022-08-14 01:06:59");
INSERT INTO tbl_purchase VALUES("292","PUR140822102","","SU","15","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-08-14","","23000.00","0.00","","LE_2","","0","5","2022-08-14 03:54:39");
INSERT INTO tbl_purchase VALUES("293","PUR170822101","","SU","10","0.00","138000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","138000.00","0","","","2022-08-17","","138000.00","0.00","","LE_2","","0","5","2022-08-17 12:40:28");
INSERT INTO tbl_purchase VALUES("294","PUR170822102","","SU","10","0.00","161000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","161000.00","0","","","2022-08-17","","161000.00","0.00","","LE_2","","0","5","2022-08-17 05:25:29");
INSERT INTO tbl_purchase VALUES("295","PUR180822101","","SU","15","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-08-18","","23000.00","0.00","","LE_2","","0","5","2022-08-18 01:46:57");
INSERT INTO tbl_purchase VALUES("296","PUR180822102","","SU","10","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2022-08-18","","115000.00","0.00","","LE_2","","0","5","2022-08-18 02:25:32");
INSERT INTO tbl_purchase VALUES("297","PUR180822103","","SU","22","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2022-08-18","","45000.00","0.00","","LE_2","","0","5","2022-08-18 06:34:44");
INSERT INTO tbl_purchase VALUES("298","PUR180822104","","SU","15","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-08-18","","23000.00","0.00","","LE_2","","0","5","2022-08-18 07:02:08");
INSERT INTO tbl_purchase VALUES("299","PUR180822105","","SU","10","0.00","46000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46000.00","0","","","2022-08-18","","46000.00","0.00","","LE_2","","0","5","2022-08-18 07:06:34");
INSERT INTO tbl_purchase VALUES("300","PUR180822106","","SU","15","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2022-08-18","","42000.00","0.00","","LE_2","","0","5","2022-08-18 07:16:02");
INSERT INTO tbl_purchase VALUES("302","PUR200822101","","SU","10","0.00","135100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135100.00","0","","","2022-08-20","","135100.00","0.00","","LE_2","","0","5","2022-08-20 02:59:47");
INSERT INTO tbl_purchase VALUES("303","PUR220822101","","SU","10","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2022-08-22","","115000.00","0.00","","LE_2","","0","5","2022-08-22 12:24:29");
INSERT INTO tbl_purchase VALUES("304","PUR220822102","","SU","10","0.00","14000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14000.00","0","","","2022-08-22","","14000.00","0.00","","LE_2","","0","5","2022-08-22 06:58:00");
INSERT INTO tbl_purchase VALUES("305","PUR220822103","","SU","10","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-08-22","","38600.00","0.00","","LE_2","","0","5","2022-08-22 07:04:47");
INSERT INTO tbl_purchase VALUES("306","PUR240822101","","SU","15","0.00","161000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","161000.00","0","","","2022-08-24","","161000.00","0.00","","LE_2","","0","5","2022-08-24 01:54:21");
INSERT INTO tbl_purchase VALUES("307","PUR240822102","","SU","15","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-08-24","","38600.00","0.00","","LE_2","","0","5","2022-08-24 02:51:51");
INSERT INTO tbl_purchase VALUES("308","PUR240822103","","SU","9","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2022-08-24","2022-08-31","0.00","0.00","","LE_2","","0","5","2022-08-24 03:30:58");
INSERT INTO tbl_purchase VALUES("309","PUR240822104","","SU","10","0.00","119000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","119000.00","0","","","2022-08-24","","119000.00","0.00","","LE_2","","0","5","2022-08-24 03:37:23");
INSERT INTO tbl_purchase VALUES("310","PUR240822105","","SU","15","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2022-08-24","","34000.00","0.00","","LE_2","","0","5","2022-08-24 03:50:11");
INSERT INTO tbl_purchase VALUES("311","PUR240822106","","SU","15","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-08-24","","20000.00","0.00","","LE_2","","0","5","2022-08-24 07:05:20");
INSERT INTO tbl_purchase VALUES("312","PUR250822101","","SU","15","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-08-25","","30000.00","0.00","","LE_2","","0","5","2022-08-25 11:28:20");
INSERT INTO tbl_purchase VALUES("313","PUR250822102","","SU","15","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-08-25","","38600.00","0.00","","LE_2","","0","5","2022-08-25 06:48:03");
INSERT INTO tbl_purchase VALUES("314","PUR250822103","","SU","10","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-08-25","","16500.00","0.00","","LE_2","","0","5","2022-08-25 07:43:00");
INSERT INTO tbl_purchase VALUES("315","PUR250822104","","SU","15","0.00","38600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38600.00","0","","","2022-08-25","","38600.00","0.00","","LE_2","","0","5","2022-08-25 07:46:30");
INSERT INTO tbl_purchase VALUES("316","PUR260822101","","SU","21","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-08-26","","30000.00","0.00","","LE_2","","0","5","2022-08-26 01:56:12");
INSERT INTO tbl_purchase VALUES("317","PUR260822102","","SU","20","0.00","70500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70500.00","0","","","2022-08-26","2022-09-02","0.00","0.00","","LE_2","","0","5","2022-08-26 02:10:13");
INSERT INTO tbl_purchase VALUES("318","PUR260822103","","SU","15","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-08-26","2022-09-02","0.00","0.00","","LE_2","","0","5","2022-08-26 03:05:08");
INSERT INTO tbl_purchase VALUES("319","PUR260822104","","SU","10","0.00","96500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96500.00","0","","","2022-08-26","","96500.00","0.00","","LE_2","","0","5","2022-08-26 05:21:48");
INSERT INTO tbl_purchase VALUES("320","PUR280822101","","SU","20","0.00","117500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","117500.00","0","","","2022-08-28","2022-09-04","0.00","0.00","","LE_2","","0","5","2022-08-28 10:51:47");
INSERT INTO tbl_purchase VALUES("321","PUR280822102","","SU","15","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-08-28","","23500.00","0.00","","LE_2","","0","5","2022-08-28 04:44:31");
INSERT INTO tbl_purchase VALUES("322","PUR290822101","","SU","15","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-08-29","","10000.00","0.00","","LE_2","","0","5","2022-08-29 06:53:38");
INSERT INTO tbl_purchase VALUES("323","PUR290822102","","SU","10","0.00","82300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","82300.00","0","","","2022-08-29","","82300.00","0.00","","LE_2","","0","5","2022-08-29 07:01:17");
INSERT INTO tbl_purchase VALUES("324","PUR310822101","","SU","15","0.00","70500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70500.00","0","","","2022-08-31","","70500.00","0.00","","LE_2","","0","5","2022-08-31 01:29:01");
INSERT INTO tbl_purchase VALUES("325","PUR310822102","","SU","15","0.00","73000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73000.00","0","","","2022-08-31","","73000.00","0.00","","LE_2","","0","5","2022-08-31 07:09:13");
INSERT INTO tbl_purchase VALUES("326","PUR010922101","","SU","9","0.00","230000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","230000.00","0","","","2022-09-01","2022-09-08","0.00","0.00","","LE_2","","0","5","2022-09-01 01:27:18");
INSERT INTO tbl_purchase VALUES("327","PUR010922102","","SU","7","0.00","91500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91500.00","0","","","2022-09-01","2022-09-08","50000.00","0.00","","LE_2","","0","5","2022-09-01 03:40:57");
INSERT INTO tbl_purchase VALUES("328","PUR010922103","","SU","9","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2022-09-01","2022-09-08","0.00","0.00","","LE_2","","0","5","2022-09-01 06:14:00");
INSERT INTO tbl_purchase VALUES("329","PUR010922104","","SU","10","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-09-01","","22000.00","0.00","","LE_2","","0","5","2022-09-01 06:27:38");
INSERT INTO tbl_purchase VALUES("330","PUR020922101","","SU","10","0.00","115500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115500.00","0","","","2022-09-02","","115500.00","0.00","","LE_2","","0","5","2022-09-02 11:25:52");
INSERT INTO tbl_purchase VALUES("331","PUR020922102","","SU","15","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-09-02","","16500.00","0.00","","LE_2","","0","5","2022-09-02 11:37:08");
INSERT INTO tbl_purchase VALUES("332","PUR020922103","","SU","15","0.00","87000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87000.00","0","","","2022-09-02","","87000.00","0.00","","LE_2","","0","5","2022-09-02 06:20:46");
INSERT INTO tbl_purchase VALUES("333","PUR030922101","","SU","9","0.00","92000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92000.00","0","","","2022-09-03","2022-09-10","0.00","0.00","","LE_2","","0","5","2022-09-03 02:01:29");
INSERT INTO tbl_purchase VALUES("334","PUR030922102","","SU","15","0.00","68100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68100.00","0","","","2022-09-03","","68100.00","0.00","","LE_2","","0","5","2022-09-03 03:29:47");
INSERT INTO tbl_purchase VALUES("335","PUR030922103","","SU","9","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-09-03","2022-09-10","0.00","0.00","","LE_2","","0","5","2022-09-03 03:51:54");
INSERT INTO tbl_purchase VALUES("336","PUR030922104","","SU","20","0.00","162000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","162000.00","0","","","2022-09-03","2022-09-10","0.00","0.00","","LE_2","","0","5","2022-09-03 05:12:49");
INSERT INTO tbl_purchase VALUES("337","PUR040922101","","SU","15","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-09-04","","23500.00","0.00","","LE_2","","0","5","2022-09-04 01:21:39");
INSERT INTO tbl_purchase VALUES("338","PUR040922102","","SU","15","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2022-09-04","","40000.00","0.00","","LE_2","","0","5","2022-09-04 01:47:48");
INSERT INTO tbl_purchase VALUES("339","PUR040922103","","SU","7","0.00","93000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","93000.00","0","","","2022-09-04","2022-09-11","0.00","0.00","","LE_2","","0","5","2022-09-04 07:09:30");
INSERT INTO tbl_purchase VALUES("340","PUR050922101","","SU","15","0.00","66000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","66000.00","0","","","2022-09-05","","66000.00","0.00","","LE_2","","0","5","2022-09-05 11:08:48");
INSERT INTO tbl_purchase VALUES("341","PUR050922102","","SU","10","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2022-09-05","","115000.00","0.00","","LE_2","","0","5","2022-09-05 11:16:27");
INSERT INTO tbl_purchase VALUES("342","PUR050922103","","SU","15","0.00","110500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110500.00","0","","","2022-09-05","","110500.00","0.00","","LE_2","","0","5","2022-09-05 06:29:20");
INSERT INTO tbl_purchase VALUES("343","PUR070922101","","SU","15","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-09-07","","23500.00","0.00","","LE_2","","0","5","2022-09-07 11:09:27");
INSERT INTO tbl_purchase VALUES("344","PUR070922102","","SU","10","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2022-09-07","","60000.00","0.00","","LE_2","","0","5","2022-09-07 11:47:53");
INSERT INTO tbl_purchase VALUES("345","PUR070922103","","SU","15","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","","2022-09-07","2022-09-14","0.00","0.00","","LE_2","","0","5","2022-09-07 11:52:57");
INSERT INTO tbl_purchase VALUES("346","PUR070922104","","SU","15","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2022-09-07","","17000.00","0.00","","LE_2","","0","5","2022-09-07 02:20:44");
INSERT INTO tbl_purchase VALUES("347","PUR070922105","","SU","20","0.00","148000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","148000.00","0","","","2022-09-07","","148000.00","0.00","","LE_2","","0","5","2022-09-07 04:42:40");
INSERT INTO tbl_purchase VALUES("348","PUR070922106","","SU","12","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-09-07","2022-09-14","0.00","0.00","","LE_2","","0","5","2022-09-07 04:45:14");
INSERT INTO tbl_purchase VALUES("349","PUR070922107","","SU","12","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2022-09-07","2022-09-14","0.00","0.00","","LE_2","","0","5","2022-09-07 05:16:43");
INSERT INTO tbl_purchase VALUES("350","PUR070922108","","SU","12","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2022-09-07","2022-09-14","0.00","0.00","","LE_2","","0","5","2022-09-07 05:44:04");
INSERT INTO tbl_purchase VALUES("351","PUR070922109","","SU","15","0.00","120500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120500.00","0","","","2022-09-07","","120500.00","0.00","","LE_2","","0","5","2022-09-07 06:26:33");
INSERT INTO tbl_purchase VALUES("352","PUR070922110","","SU","10","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-09-07","","10000.00","0.00","","LE_2","","0","5","2022-09-07 07:58:09");
INSERT INTO tbl_purchase VALUES("353","PUR080922101","","SU","15","0.00","577500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","577500.00","0","","","2022-09-08","","577500.00","0.00","","LE_2","","0","5","2022-09-08 05:04:38");
INSERT INTO tbl_purchase VALUES("354","PUR080922102","","SU","15","0.00","128000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128000.00","0","","","2022-09-08","","128000.00","0.00","","LE_2","","0","5","2022-09-08 05:12:03");
INSERT INTO tbl_purchase VALUES("355","PUR080922103","","SU","10","0.00","73500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73500.00","0","","","2022-09-08","","73500.00","0.00","","LE_2","","0","5","2022-09-08 06:05:40");
INSERT INTO tbl_purchase VALUES("356","PUR090922101","","SU","15","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-09-09","2022-09-16","0.00","0.00","","LE_2","","0","5","2022-09-09 12:04:45");
INSERT INTO tbl_purchase VALUES("357","PUR090922102","","SU","10","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-09-09","","16000.00","0.00","","LE_2","","0","5","2022-09-09 12:12:53");
INSERT INTO tbl_purchase VALUES("358","PUR090922103","","SU","15","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-09-09","","16000.00","0.00","","LE_2","","0","5","2022-09-09 12:16:25");
INSERT INTO tbl_purchase VALUES("359","PUR090922104","","SU","15","0.00","525250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","525250.00","0","","","2022-09-09","2022-09-16","0.00","0.00","","LE_2","","0","5","2022-09-09 12:58:12");
INSERT INTO tbl_purchase VALUES("360","PUR090922105","","SU","10","0.00","348500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","348500.00","0","","","2022-09-09","","348500.00","0.00","","LE_2","","0","5","2022-09-09 07:01:16");
INSERT INTO tbl_purchase VALUES("361","PUR090922106","","SU","9","0.00","92000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92000.00","0","","","2022-09-09","2022-09-16","0.00","0.00","","LE_2","","0","5","2022-09-09 07:07:26");
INSERT INTO tbl_purchase VALUES("362","PUR090922107","","SU","9","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-09-09","2022-09-16","0.00","0.00","","LE_2","","0","5","2022-09-09 07:47:38");
INSERT INTO tbl_purchase VALUES("363","PUR100922101","","SU","20","0.00","148000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","148000.00","0","","","2022-09-10","2022-09-17","0.00","0.00","","LE_2","","0","5","2022-09-10 01:52:37");
INSERT INTO tbl_purchase VALUES("364","PUR100922102","","SU","15","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-09-10","","20000.00","0.00","","LE_2","","0","5","2022-09-10 01:54:18");
INSERT INTO tbl_purchase VALUES("365","PUR100922103","","SU","9","0.00","345000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","345000.00","0","","","2022-09-10","2022-09-17","0.00","0.00","","LE_2","","0","5","2022-09-10 02:42:40");
INSERT INTO tbl_purchase VALUES("366","PUR100922104","","SU","15","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-09-10","","23500.00","0.00","","LE_2","","0","5","2022-09-10 03:47:27");
INSERT INTO tbl_purchase VALUES("367","PUR100922105","","SU","15","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-09-10","","25000.00","0.00","","LE_2","","0","5","2022-09-10 06:57:50");
INSERT INTO tbl_purchase VALUES("368","PUR110922101","","SU","15","0.00","64000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64000.00","0","","","2022-09-11","","64000.00","0.00","","LE_2","","0","5","2022-09-11 12:04:57");
INSERT INTO tbl_purchase VALUES("369","PUR110922102","","SU","9","0.00","167000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","167000.00","0","","","2022-09-11","2022-09-18","0.00","0.00","","LE_2","","0","5","2022-09-11 03:08:37");
INSERT INTO tbl_purchase VALUES("370","PUR110922103","","SU","9","0.00","230000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","230000.00","0","","","2022-09-11","2022-09-18","0.00","0.00","","LE_2","","0","5","2022-09-11 04:50:16");
INSERT INTO tbl_purchase VALUES("371","PUR120922101","","SU","9","0.00","141000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","141000.00","0","","","2022-09-12","2022-09-19","0.00","0.00","","LE_2","","0","5","2022-09-12 02:20:07");
INSERT INTO tbl_purchase VALUES("372","PUR120922102","","SU","10","0.00","89000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","89000.00","0","","","2022-09-12","","89000.00","0.00","","LE_2","","0","5","2022-09-12 05:33:40");
INSERT INTO tbl_purchase VALUES("373","PUR140922101","","SU","9","0.00","164500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164500.00","0","","","2022-09-14","2022-09-21","0.00","0.00","","LE_2","","0","5","2022-09-14 05:21:41");
INSERT INTO tbl_purchase VALUES("374","PUR140922102","","SU","9","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-09-14","2022-09-21","0.00","0.00","","LE_2","","0","5","2022-09-14 06:13:16");
INSERT INTO tbl_purchase VALUES("375","PUR150922101","","SU","10","0.00","2500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2500.00","0","","","2022-09-15","","2500.00","0.00","","LE_2","","0","5","2022-09-15 11:18:47");
INSERT INTO tbl_purchase VALUES("376","PUR150922102","","SU","15","0.00","214000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","214000.00","0","","","2022-09-15","","214000.00","0.00","","LE_2","","0","5","2022-09-15 05:28:42");
INSERT INTO tbl_purchase VALUES("377","PUR150922103","","SU","20","0.00","230000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","230000.00","0","","","2022-09-15","2022-09-22","0.00","0.00","","LE_2","","0","5","2022-09-15 07:19:38");
INSERT INTO tbl_purchase VALUES("378","PUR160922101","","SU","20","0.00","286500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","286500.00","0","","","2022-09-16","2022-09-23","0.00","0.00","","LE_2","","0","5","2022-09-16 10:52:47");
INSERT INTO tbl_purchase VALUES("379","PUR160922102","","SU","25","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2022-09-16","2022-09-23","0.00","0.00","","LE_2","","0","5","2022-09-16 02:21:37");
INSERT INTO tbl_purchase VALUES("380","PUR160922103","","SU","9","0.00","207000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","207000.00","0","","","2022-09-16","2022-09-23","0.00","0.00","","LE_2","","0","5","2022-09-16 05:26:01");
INSERT INTO tbl_purchase VALUES("381","PUR160922104","","SU","10","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-09-16","","23500.00","0.00","","LE_2","","0","5","2022-09-16 06:03:29");
INSERT INTO tbl_purchase VALUES("382","PUR160922105","","SU","10","0.00","166000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","166000.00","0","","","2022-09-16","","166000.00","0.00","","LE_2","","0","5","2022-09-16 06:30:03");
INSERT INTO tbl_purchase VALUES("383","PUR160922106","","SU","9","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2022-09-16","2022-09-23","0.00","0.00","","LE_2","","0","5","2022-09-16 07:08:46");
INSERT INTO tbl_purchase VALUES("384","PUR160922107","","SU","15","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-09-16","","19000.00","0.00","","LE_2","","0","5","2022-09-16 08:03:46");
INSERT INTO tbl_purchase VALUES("385","PUR180922101","","SU","15","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2022-09-18","","57000.00","0.00","","LE_2","","0","5","2022-09-18 03:57:35");
INSERT INTO tbl_purchase VALUES("386","PUR180922102","","SU","9","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2022-09-18","2022-09-25","0.00","0.00","","LE_2","","0","5","2022-09-18 03:59:07");
INSERT INTO tbl_purchase VALUES("387","PUR180922103","","SU","15","0.00","240000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","240000.00","0","","","2022-09-18","","240000.00","0.00","","LE_2","","0","5","2022-09-18 04:05:36");
INSERT INTO tbl_purchase VALUES("388","PUR180922104","","SU","15","0.00","87500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87500.00","0","","","2022-09-18","","87500.00","0.00","","LE_2","","0","5","2022-09-18 11:49:42");
INSERT INTO tbl_purchase VALUES("389","PUR200922101","","SU","10","0.00","216500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","216500.00","0","","","2022-09-20","","216500.00","0.00","","LE_2","","0","5","2022-09-20 12:05:04");
INSERT INTO tbl_purchase VALUES("390","PUR200922102","","SU","15","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-09-20","","26000.00","0.00","","LE_2","","0","5","2022-09-20 12:16:04");
INSERT INTO tbl_purchase VALUES("391","PUR220922101","","SU","15","0.00","154500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","154500.00","0","","","2022-09-22","","154500.00","0.00","","LE_2","","0","5","2022-09-22 03:24:17");
INSERT INTO tbl_purchase VALUES("392","PUR220922102","","SU","15","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2022-09-22","","90000.00","0.00","","LE_2","","0","5","2022-09-22 03:27:23");
INSERT INTO tbl_purchase VALUES("393","PUR220922103","","SU","15","0.00","214500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","214500.00","0","","","2022-09-22","2022-09-29","0.00","0.00","","LE_2","","0","5","2022-09-22 03:37:06");
INSERT INTO tbl_purchase VALUES("394","PUR220922104","","SU","15","0.00","262500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","262500.00","0","","","2022-09-22","","262500.00","0.00","","LE_2","","0","5","2022-09-22 03:45:01");
INSERT INTO tbl_purchase VALUES("395","PUR220922105","","SU","15","0.00","195000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","195000.00","0","","","2022-09-22","","195000.00","0.00","","LE_2","","0","5","2022-09-22 03:48:42");
INSERT INTO tbl_purchase VALUES("396","PUR220922106","","SU","10","0.00","235000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","235000.00","0","","","2022-09-22","","235000.00","0.00","","LE_2","","0","5","2022-09-22 04:06:47");
INSERT INTO tbl_purchase VALUES("397","PUR220922107","","SU","15","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-09-22","","25000.00","0.00","","LE_2","","0","5","2022-09-22 12:38:02");
INSERT INTO tbl_purchase VALUES("398","PUR230922101","","SU","15","0.00","34500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34500.00","0","","","2022-09-23","","34500.00","0.00","","LE_2","","0","5","2022-09-23 02:38:39");
INSERT INTO tbl_purchase VALUES("399","PUR230922102","","SU","15","0.00","150000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150000.00","0","","","2022-09-23","","150000.00","0.00","","LE_2","","0","5","2022-09-23 02:46:28");
INSERT INTO tbl_purchase VALUES("400","PUR240922101","","SU","26","0.00","49000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49000.00","0","","","2022-09-24","","49000.00","0.00","","LE_2","","0","5","2022-09-24 02:35:32");
INSERT INTO tbl_purchase VALUES("401","PUR240922102","","SU","15","0.00","87500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87500.00","0","","","2022-09-24","","87500.00","0.00","","LE_2","","0","5","2022-09-24 02:40:04");
INSERT INTO tbl_purchase VALUES("402","PUR250922101","","SU","15","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2022-09-25","","50000.00","0.00","","LE_2","","0","5","2022-09-25 03:29:26");
INSERT INTO tbl_purchase VALUES("403","PUR250922102","","SU","15","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2022-09-25","","47000.00","0.00","","LE_2","","0","5","2022-09-25 03:44:28");
INSERT INTO tbl_purchase VALUES("404","PUR250922103","","SU","15","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-09-25","","19000.00","0.00","","LE_2","","0","5","2022-09-25 12:43:49");
INSERT INTO tbl_purchase VALUES("405","PUR250922104","","SU","25","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2022-09-25","2022-10-02","0.00","0.00","","LE_2","","0","5","2022-09-25 12:46:38");
INSERT INTO tbl_purchase VALUES("406","PUR250922105","","SU","15","0.00","213000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","213000.00","0","","","2022-09-25","","213000.00","0.00","","LE_2","","0","5","2022-09-25 12:50:00");
INSERT INTO tbl_purchase VALUES("407","PUR260922101","","SU","15","0.00","102000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","102000.00","0","","","2022-09-26","","102000.00","0.00","","LE_2","","0","5","2022-09-26 02:16:57");
INSERT INTO tbl_purchase VALUES("408","PUR260922102","","SU","15","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-09-26","","25000.00","0.00","","LE_2","","0","5","2022-09-26 02:18:03");
INSERT INTO tbl_purchase VALUES("409","PUR260922103","","SU","10","0.00","81000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81000.00","0","","","2022-09-26","","81000.00","0.00","","LE_2","","0","5","2022-09-26 02:21:58");
INSERT INTO tbl_purchase VALUES("410","PUR260922104","","SU","15","0.00","112000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112000.00","0","","","2022-09-26","2022-10-03","0.00","0.00","","LE_2","","0","5","2022-09-26 02:25:49");
INSERT INTO tbl_purchase VALUES("411","PUR260922105","","SU","9","0.00","164500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164500.00","0","","","2022-09-26","2022-10-03","0.00","0.00","","LE_2","","0","5","2022-09-26 02:27:49");
INSERT INTO tbl_purchase VALUES("412","PUR270922101","","SU","15","0.00","241500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","241500.00","0","","","2022-09-27","2022-10-04","0.00","0.00","","LE_2","","0","5","2022-09-27 12:04:01");
INSERT INTO tbl_purchase VALUES("413","PUR270922102","","SU","15","0.00","23250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23250.00","0","","","2022-09-27","","23250.00","0.00","","LE_2","","0","5","2022-09-27 12:13:23");
INSERT INTO tbl_purchase VALUES("414","PUR280922101","","SU","15","0.00","74000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74000.00","0","","","2022-09-28","","74000.00","0.00","","LE_2","","0","5","2022-09-28 04:24:05");
INSERT INTO tbl_purchase VALUES("415","PUR280922102","","SU","10","0.00","176000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","176000.00","0","","","2022-09-28","","176000.00","0.00","","LE_2","","0","5","2022-09-28 04:27:05");
INSERT INTO tbl_purchase VALUES("416","PUR280922103","","SU","15","0.00","102000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","102000.00","0","","","2022-09-28","","102000.00","0.00","","LE_2","","0","5","2022-09-28 04:38:41");
INSERT INTO tbl_purchase VALUES("417","PUR290922101","","SU","15","0.00","149000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149000.00","0","","","2022-09-29","","149000.00","0.00","","LE_2","","0","5","2022-09-29 02:02:27");
INSERT INTO tbl_purchase VALUES("418","PUR290922102","","SU","10","0.00","307000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","307000.00","0","","","2022-09-29","","307000.00","0.00","","LE_2","","0","5","2022-09-29 02:07:45");
INSERT INTO tbl_purchase VALUES("419","PUR290922103","","SU","15","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-09-29","","16500.00","0.00","","LE_2","","0","5","2022-09-29 02:58:16");
INSERT INTO tbl_purchase VALUES("420","PUR290922104","","SU","15","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-09-29","2022-10-06","0.00","0.00","","LE_2","","0","5","2022-09-29 02:12:06");
INSERT INTO tbl_purchase VALUES("421","PUR300922101","","SU","15","0.00","420000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","420000.00","0","","","2022-09-30","","420000.00","0.00","","LE_2","","0","5","2022-09-30 04:16:43");
INSERT INTO tbl_purchase VALUES("422","PUR011022101","","SU","27","0.00","437500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","437500.00","0","","","2022-10-01","","437500.00","0.00","","LE_2","","0","5","2022-10-01 01:58:25");
INSERT INTO tbl_purchase VALUES("423","PUR011022102","","SU","27","0.00","375000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","375000.00","0","","","2022-10-01","","375000.00","0.00","","LE_2","","0","5","2022-10-01 02:05:45");
INSERT INTO tbl_purchase VALUES("424","PUR031022101","","SU","27","0.00","350000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350000.00","0","","","2022-10-03","2022-10-10","0.00","0.00","","LE_2","","0","5","2022-10-03 01:46:16");
INSERT INTO tbl_purchase VALUES("425","PUR031022102","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2022-10-03","2022-10-10","0.00","0.00","","LE_2","","0","5","2022-10-03 01:59:00");
INSERT INTO tbl_purchase VALUES("426","PUR031022103","","SU","27","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-10-03","2022-10-10","0.00","0.00","","LE_2","","0","5","2022-10-03 02:01:02");
INSERT INTO tbl_purchase VALUES("427","PUR031022104","","SU","27","0.00","45500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45500.00","0","","","2022-10-03","2022-10-10","0.00","0.00","","LE_2","","0","5","2022-10-03 02:17:02");
INSERT INTO tbl_purchase VALUES("428","PUR041022101","","SU","27","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2022-10-04","","175000.00","0.00","","LE_2","","0","5","2022-10-04 02:33:02");
INSERT INTO tbl_purchase VALUES("429","PUR041022102","","SU","27","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-10-04","","25000.00","0.00","","LE_2","","0","5","2022-10-04 02:42:31");
INSERT INTO tbl_purchase VALUES("430","PUR051022101","","SU","27","0.00","212500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","212500.00","0","","","2022-10-05","","212500.00","0.00","","LE_2","","0","5","2022-10-05 04:38:56");
INSERT INTO tbl_purchase VALUES("431","PUR051022102","","SU","27","0.00","425000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","425000.00","0","","","2022-10-05","","425000.00","0.00","","LE_2","","0","5","2022-10-05 05:02:52");
INSERT INTO tbl_purchase VALUES("432","PUR051022103","","SU","27","0.00","137500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","137500.00","0","","","2022-10-05","","137500.00","0.00","","LE_2","","0","5","2022-10-05 05:10:03");
INSERT INTO tbl_purchase VALUES("433","PUR051022104","","SU","27","0.00","225500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","225500.00","0","","","2022-10-05","","225500.00","0.00","","LE_2","","0","5","2022-10-05 05:30:02");
INSERT INTO tbl_purchase VALUES("434","PUR071022101","","SU","27","0.00","101000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","101000.00","0","","","2022-10-07","2022-10-14","0.00","0.00","","LE_2","","0","5","2022-10-07 01:19:05");
INSERT INTO tbl_purchase VALUES("435","PUR071022102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-10-07","","19000.00","0.00","","LE_2","","0","5","2022-10-07 01:46:58");
INSERT INTO tbl_purchase VALUES("436","PUR081022101","","SU","27","0.00","200000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200000.00","0","","","2022-10-08","","200000.00","0.00","","LE_2","","0","5","2022-10-08 02:05:38");
INSERT INTO tbl_purchase VALUES("437","PUR081022102","","SU","27","0.00","141000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","141000.00","0","","","2022-10-08","","141000.00","0.00","","LE_2","","0","5","2022-10-08 02:08:44");
INSERT INTO tbl_purchase VALUES("438","PUR081022103","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-10-08","2022-10-15","0.00","0.00","","LE_2","","0","5","2022-10-08 02:14:26");
INSERT INTO tbl_purchase VALUES("439","PUR081022104","","SU","27","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-10-08","","22000.00","0.00","","LE_2","","0","5","2022-10-08 02:24:09");
INSERT INTO tbl_purchase VALUES("440","PUR081022105","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2022-10-08","","12500.00","0.00","","LE_2","","0","5","2022-10-08 02:42:25");
INSERT INTO tbl_purchase VALUES("441","PUR091022101","","SU","27","0.00","250500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","250500.00","0","","","2022-10-09","","250500.00","0.00","","LE_2","","0","5","2022-10-09 02:12:36");
INSERT INTO tbl_purchase VALUES("442","PUR101022101","","SU","27","0.00","145500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","145500.00","0","","","2022-10-10","","145500.00","0.00","","LE_2","","0","5","2022-10-10 03:30:12");
INSERT INTO tbl_purchase VALUES("443","PUR101022102","","SU","27","0.00","252000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","252000.00","0","","","2022-10-10","","252000.00","0.00","","LE_2","","0","5","2022-10-10 03:33:31");
INSERT INTO tbl_purchase VALUES("444","PUR101022103","","SU","27","0.00","187500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","187500.00","0","","","2022-10-10","","187500.00","0.00","","LE_2","","0","5","2022-10-10 03:36:56");
INSERT INTO tbl_purchase VALUES("445","PUR111022101","","SU","27","0.00","314000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","314000.00","0","","","2022-10-11","","314000.00","0.00","","LE_2","","0","5","2022-10-11 02:37:52");
INSERT INTO tbl_purchase VALUES("446","PUR111022102","","SU","27","0.00","23500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23500.00","0","","","2022-10-11","","23500.00","0.00","","LE_2","","0","5","2022-10-11 02:49:04");
INSERT INTO tbl_purchase VALUES("447","PUR131022101","","SU","27","0.00","362000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","362000.00","0","","","2022-10-13","","362000.00","0.00","","LE_2","","0","5","2022-10-13 01:57:12");
INSERT INTO tbl_purchase VALUES("448","PUR131022102","","SU","27","0.00","179000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","179000.00","0","","","2022-10-13","","179000.00","0.00","","LE_2","","0","5","2022-10-13 02:00:29");
INSERT INTO tbl_purchase VALUES("449","PUR131022103","","SU","27","0.00","112000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112000.00","0","","","2022-10-13","","112000.00","0.00","","LE_2","","0","5","2022-10-13 02:05:39");
INSERT INTO tbl_purchase VALUES("450","PUR131022104","","SU","27","0.00","280000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","280000.00","0","","","2022-10-13","","280000.00","0.00","","LE_2","","0","5","2022-10-13 02:09:44");
INSERT INTO tbl_purchase VALUES("451","PUR131022105","","SU","27","0.00","30500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30500.00","0","","","2022-10-13","","30500.00","0.00","","LE_2","","0","5","2022-10-13 02:22:05");
INSERT INTO tbl_purchase VALUES("452","PUR131022106","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-10-13","","26000.00","0.00","","LE_2","","0","5","2022-10-13 02:43:25");
INSERT INTO tbl_purchase VALUES("453","PUR141022101","","SU","27","0.00","167000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","167000.00","0","","","2022-10-14","","167000.00","0.00","","LE_2","","0","5","2022-10-14 04:31:54");
INSERT INTO tbl_purchase VALUES("454","PUR141022102","","SU","27","0.00","230000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","230000.00","0","","","2022-10-14","","230000.00","0.00","","LE_2","","0","5","2022-10-14 04:38:33");
INSERT INTO tbl_purchase VALUES("455","PUR151022101","","SU","27","0.00","54000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54000.00","0","","","2022-10-15","","54000.00","0.00","","LE_2","","0","5","2022-10-15 01:22:17");
INSERT INTO tbl_purchase VALUES("456","PUR151022102","","SU","27","0.00","26500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26500.00","0","","","2022-10-15","2022-10-22","0.00","0.00","","LE_2","","0","5","2022-10-15 01:24:59");
INSERT INTO tbl_purchase VALUES("457","PUR151022103","","SU","27","0.00","69750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69750.00","0","","","2022-10-15","2022-10-22","0.00","0.00","","LE_2","","0","5","2022-10-15 01:40:47");
INSERT INTO tbl_purchase VALUES("458","PUR151022104","","SU","27","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2022-10-15","2022-10-22","0.00","0.00","","LE_2","","0","5","2022-10-15 01:42:31");
INSERT INTO tbl_purchase VALUES("459","PUR151022105","","SU","27","0.00","30500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30500.00","0","","","2022-10-15","2022-10-22","0.00","0.00","","LE_2","","0","5","2022-10-15 02:04:26");
INSERT INTO tbl_purchase VALUES("460","PUR151022106","","SU","27","0.00","82500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","82500.00","0","","","2022-10-15","","82500.00","0.00","","LE_2","","0","5","2022-10-15 02:08:14");
INSERT INTO tbl_purchase VALUES("461","PUR151022107","","SU","27","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2022-10-15","","38000.00","0.00","","LE_2","","0","5","2022-10-15 02:12:24");
INSERT INTO tbl_purchase VALUES("462","PUR151022108","","SU","27","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-10-15","","21000.00","0.00","","LE_2","","0","5","2022-10-15 05:02:04");
INSERT INTO tbl_purchase VALUES("463","PUR151022109","","SU","27","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2022-10-15","","105000.00","0.00","","LE_2","","0","5","2022-10-15 05:07:46");
INSERT INTO tbl_purchase VALUES("464","PUR151022110","","SU","27","0.00","49500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49500.00","0","","","2022-10-15","","49500.00","0.00","","LE_2","","0","5","2022-10-15 05:58:22");
INSERT INTO tbl_purchase VALUES("465","PUR151022111","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-10-15","","26000.00","0.00","","LE_2","","0","5","2022-10-15 06:00:05");
INSERT INTO tbl_purchase VALUES("466","PUR161022101","","SU","27","0.00","367500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","367500.00","0","","","2022-10-16","","367500.00","0.00","","LE_2","","0","5","2022-10-16 02:36:57");
INSERT INTO tbl_purchase VALUES("467","PUR161022102","","SU","27","0.00","204000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","204000.00","0","","","2022-10-16","","204000.00","0.00","","LE_2","","0","5","2022-10-16 03:13:41");
INSERT INTO tbl_purchase VALUES("468","PUR161022103","","SU","27","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2022-10-16","","126000.00","0.00","","LE_2","","0","5","2022-10-16 05:03:50");
INSERT INTO tbl_purchase VALUES("469","PUR161022104","","SU","27","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2022-10-16","","65000.00","0.00","","LE_2","","0","5","2022-10-16 05:37:01");
INSERT INTO tbl_purchase VALUES("470","PUR171022101","","SU","27","0.00","88000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88000.00","0","","","2022-10-17","","88000.00","0.00","","LE_2","","0","5","2022-10-17 11:00:42");
INSERT INTO tbl_purchase VALUES("471","PUR171022102","","SU","27","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-10-17","","22000.00","0.00","","LE_2","","0","5","2022-10-17 03:51:58");
INSERT INTO tbl_purchase VALUES("472","PUR191022101","","SU","27","0.00","293000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","293000.00","0","","","2022-10-19","","293000.00","0.00","","LE_2","","0","5","2022-10-19 04:57:51");
INSERT INTO tbl_purchase VALUES("473","PUR191022102","","SU","27","0.00","150000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150000.00","0","","","2022-10-19","","150000.00","0.00","","LE_2","","0","5","2022-10-19 05:32:59");
INSERT INTO tbl_purchase VALUES("474","PUR191022103","","SU","27","0.00","129000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129000.00","0","","","2022-10-19","","129000.00","0.00","","LE_2","","0","5","2022-10-19 05:46:20");
INSERT INTO tbl_purchase VALUES("475","PUR191022104","","SU","27","0.00","82500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","82500.00","0","","","2022-10-19","","82500.00","0.00","","LE_2","","0","5","2022-10-19 06:30:58");
INSERT INTO tbl_purchase VALUES("476","PUR191022105","","SU","27","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-10-19","","15000.00","0.00","","LE_2","","0","5","2022-10-19 06:33:16");
INSERT INTO tbl_purchase VALUES("477","PUR201022101","","SU","27","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-10-20","","30000.00","0.00","","LE_2","","0","5","2022-10-20 03:15:53");
INSERT INTO tbl_purchase VALUES("478","PUR211022101","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-10-21","","21500.00","0.00","","LE_2","","0","5","2022-10-21 12:08:43");
INSERT INTO tbl_purchase VALUES("479","PUR211022102","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-10-21","","21500.00","0.00","","LE_2","","0","5","2022-10-21 12:16:29");
INSERT INTO tbl_purchase VALUES("480","PUR211022103","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-10-21","","21500.00","0.00","","LE_2","","0","5","2022-10-21 12:21:24");
INSERT INTO tbl_purchase VALUES("481","PUR211022104","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2022-10-21","","12500.00","0.00","","LE_2","","0","5","2022-10-21 12:43:34");
INSERT INTO tbl_purchase VALUES("482","PUR211022105","","SU","27","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-10-21","","30000.00","0.00","","LE_2","","0","5","2022-10-21 12:55:08");
INSERT INTO tbl_purchase VALUES("483","PUR211022106","","SU","27","0.00","26500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26500.00","0","","","2022-10-21","","26500.00","0.00","","LE_2","","0","5","2022-10-21 01:13:02");
INSERT INTO tbl_purchase VALUES("484","PUR211022107","","SU","27","0.00","19500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19500.00","0","","","2022-10-21","","19500.00","0.00","","LE_2","","0","5","2022-10-21 01:15:56");
INSERT INTO tbl_purchase VALUES("485","PUR211022108","","SU","27","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2022-10-21","","45000.00","0.00","","LE_2","","0","5","2022-10-21 07:34:46");
INSERT INTO tbl_purchase VALUES("486","PUR221022101","","SU","27","0.00","93000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","93000.00","0","","","2022-10-22","","93000.00","0.00","","LE_2","","0","5","2022-10-22 06:08:44");
INSERT INTO tbl_purchase VALUES("487","PUR231022101","","SU","27","0.00","135000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135000.00","0","","","2022-10-23","","135000.00","0.00","","LE_2","","0","5","2022-10-23 03:49:14");
INSERT INTO tbl_purchase VALUES("488","PUR231022102","","SU","27","0.00","180000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180000.00","0","","","2022-10-23","","180000.00","0.00","","LE_2","","0","5","2022-10-23 05:36:46");
INSERT INTO tbl_purchase VALUES("489","PUR261022101","","SU","27","0.00","142000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","142000.00","0","","","2022-10-26","","142000.00","0.00","","LE_2","","0","5","2022-10-26 04:14:32");
INSERT INTO tbl_purchase VALUES("490","PUR261022102","","SU","27","0.00","446500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","446500.00","0","","","2022-10-26","","446500.00","0.00","","LE_2","","0","5","2022-10-26 07:31:24");
INSERT INTO tbl_purchase VALUES("491","PUR271022101","","SU","27","0.00","316000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","316000.00","0","","","2022-10-27","","316000.00","0.00","","LE_2","","0","5","2022-10-27 01:14:06");
INSERT INTO tbl_purchase VALUES("492","PUR271022102","","SU","27","0.00","186500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","186500.00","0","","","2022-10-27","2022-11-03","0.00","0.00","","LE_2","","0","5","2022-10-27 01:29:25");
INSERT INTO tbl_purchase VALUES("493","PUR271022103","","SU","27","0.00","13500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13500.00","0","","","2022-10-27","","13500.00","0.00","","LE_2","","0","5","2022-10-27 04:41:56");
INSERT INTO tbl_purchase VALUES("494","PUR271022104","","SU","27","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-10-27","","43000.00","0.00","","LE_2","","0","5","2022-10-27 05:24:03");
INSERT INTO tbl_purchase VALUES("495","PUR271022105","","SU","27","0.00","193500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","193500.00","0","","","2022-10-27","","193500.00","0.00","","LE_2","","0","5","2022-10-27 07:03:59");
INSERT INTO tbl_purchase VALUES("496","PUR281022101","","SU","27","0.00","162000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","162000.00","0","","","2022-10-28","","162000.00","0.00","","LE_2","","0","5","2022-10-28 05:29:59");
INSERT INTO tbl_purchase VALUES("497","PUR291022101","","SU","27","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-10-29","","22000.00","0.00","","LE_2","","0","5","2022-10-29 11:24:06");
INSERT INTO tbl_purchase VALUES("498","PUR291022102","","SU","27","0.00","73500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73500.00","0","","","2022-10-29","","73500.00","0.00","","LE_2","","0","5","2022-10-29 12:26:07");
INSERT INTO tbl_purchase VALUES("499","PUR291022103","","SU","27","0.00","208500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","208500.00","0","","","2022-10-29","","208500.00","0.00","","LE_2","","0","5","2022-10-29 04:13:44");
INSERT INTO tbl_purchase VALUES("500","PUR291022104","","SU","27","0.00","215000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","215000.00","0","","","2022-10-29","","215000.00","0.00","","LE_2","","0","5","2022-10-29 04:16:58");
INSERT INTO tbl_purchase VALUES("501","PUR291022105","","SU","27","0.00","72500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72500.00","0","","","2022-10-29","","72500.00","0.00","","LE_2","","0","5","2022-10-29 05:17:10");
INSERT INTO tbl_purchase VALUES("502","PUR301022101","","SU","27","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-10-30","","16500.00","0.00","","LE_2","","0","5","2022-10-30 10:48:36");
INSERT INTO tbl_purchase VALUES("503","PUR301022102","","SU","27","0.00","164000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164000.00","0","","","2022-10-30","","164000.00","0.00","","LE_2","","0","5","2022-10-30 02:55:47");
INSERT INTO tbl_purchase VALUES("504","PUR301022103","","SU","27","0.00","1200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1200.00","0","","","2022-10-30","","1200.00","0.00","","LE_2","","0","5","2022-10-30 05:49:51");
INSERT INTO tbl_purchase VALUES("505","PUR301022104","","SU","27","0.00","77500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77500.00","0","","","2022-10-30","","77500.00","0.00","","LE_2","","0","5","2022-10-30 06:04:42");
INSERT INTO tbl_purchase VALUES("506","PUR311022101","","SU","27","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2022-10-31","","33000.00","0.00","","LE_2","","0","5","2022-10-31 11:01:23");
INSERT INTO tbl_purchase VALUES("507","PUR311022102","","SU","27","0.00","272000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","272000.00","0","","","2022-10-31","","272000.00","0.00","","LE_2","","0","5","2022-10-31 06:24:28");
INSERT INTO tbl_purchase VALUES("508","PUR021122101","","SU","27","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-11-02","","10000.00","0.00","","LE_2","","0","5","2022-11-02 01:10:52");
INSERT INTO tbl_purchase VALUES("509","PUR021122102","","SU","27","0.00","210000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","210000.00","0","","","2022-11-02","","210000.00","0.00","","LE_2","","0","5","2022-11-02 04:11:48");
INSERT INTO tbl_purchase VALUES("510","PUR021122103","","SU","27","0.00","8000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8000.00","0","","","2022-11-02","","8000.00","0.00","","LE_2","","0","5","2022-11-02 04:14:53");
INSERT INTO tbl_purchase VALUES("511","PUR021122104","","SU","27","0.00","81000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81000.00","0","","","2022-11-02","","81000.00","0.00","","LE_2","","0","5","2022-11-02 05:58:19");
INSERT INTO tbl_purchase VALUES("512","PUR021122105","","SU","27","0.00","189000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","189000.00","0","","","2022-11-02","","189000.00","0.00","","LE_2","","0","5","2022-11-02 07:55:19");
INSERT INTO tbl_purchase VALUES("513","PUR031122101","","SU","27","0.00","248000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","248000.00","0","","","2022-11-03","","248000.00","0.00","","LE_2","","0","5","2022-11-03 12:04:12");
INSERT INTO tbl_purchase VALUES("514","PUR031122102","","SU","27","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-11-03","","25000.00","0.00","","LE_2","","0","5","2022-11-03 12:11:45");
INSERT INTO tbl_purchase VALUES("515","PUR031122103","","SU","10","0.00","153000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","153000.00","0","","","2022-11-03","","153000.00","0.00","","LE_2","","0","5","2022-11-03 12:28:39");
INSERT INTO tbl_purchase VALUES("516","PUR031122104","","SU","27","0.00","14000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14000.00","0","","","2022-11-03","","14000.00","0.00","","LE_2","","0","5","2022-11-03 12:30:20");
INSERT INTO tbl_purchase VALUES("517","PUR031122105","","SU","27","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2022-11-03","","80000.00","0.00","","LE_2","","0","5","2022-11-03 12:35:30");
INSERT INTO tbl_purchase VALUES("518","PUR031122106","","SU","27","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","","2022-11-03","","70000.00","0.00","","LE_2","","0","5","2022-11-03 04:14:47");
INSERT INTO tbl_purchase VALUES("519","PUR031122107","","SU","10","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2022-11-03","","34000.00","0.00","","LE_2","","0","5","2022-11-03 04:18:50");
INSERT INTO tbl_purchase VALUES("520","PUR031122108","","SU","10","0.00","136500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","136500.00","0","","","2022-11-03","","136500.00","0.00","","LE_2","","0","5","2022-11-03 06:04:35");
INSERT INTO tbl_purchase VALUES("521","PUR041122101","","SU","27","0.00","84000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84000.00","0","","","2022-11-04","","84000.00","0.00","","LE_2","","0","5","2022-11-04 11:07:51");
INSERT INTO tbl_purchase VALUES("522","PUR041122102","","SU","27","0.00","112800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112800.00","0","","","2022-11-04","","112800.00","0.00","","LE_2","","0","5","2022-11-04 02:10:02");
INSERT INTO tbl_purchase VALUES("523","PUR041122103","","SU","27","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2022-11-04","2022-11-11","0.00","0.00","","LE_2","","0","5","2022-11-04 02:13:31");
INSERT INTO tbl_purchase VALUES("524","PUR041122104","","SU","27","0.00","260000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","260000.00","0","","","2022-11-04","","260000.00","0.00","","LE_2","","0","5","2022-11-04 05:12:21");
INSERT INTO tbl_purchase VALUES("525","PUR051122101","","SU","27","0.00","572000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","572000.00","0","","","2022-11-05","","572000.00","0.00","","LE_2","","0","5","2022-11-05 11:57:23");
INSERT INTO tbl_purchase VALUES("526","PUR061122101","","SU","27","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-11-06","","21000.00","0.00","","LE_2","","0","5","2022-11-06 12:12:32");
INSERT INTO tbl_purchase VALUES("527","PUR061122102","","SU","27","0.00","162500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","162500.00","0","","","2022-11-06","","162500.00","0.00","","LE_2","","0","5","2022-11-06 10:23:02");
INSERT INTO tbl_purchase VALUES("528","PUR061122103","","SU","27","0.00","169500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","169500.00","0","","","2022-11-06","","169500.00","0.00","","LE_2","","0","5","2022-11-06 10:25:11");
INSERT INTO tbl_purchase VALUES("529","PUR061122104","","SU","27","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2022-11-06","","42000.00","0.00","","LE_2","","0","5","2022-11-06 10:34:31");
INSERT INTO tbl_purchase VALUES("530","PUR061122105","","SU","27","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2022-11-06","","40000.00","0.00","","LE_2","","0","5","2022-11-06 10:38:34");
INSERT INTO tbl_purchase VALUES("531","PUR091122101","","SU","27","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-11-09","","16500.00","0.00","","LE_2","","0","5","2022-11-09 12:44:11");
INSERT INTO tbl_purchase VALUES("532","PUR091122102","","SU","27","0.00","63000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63000.00","0","","","2022-11-09","","63000.00","0.00","","LE_2","","0","5","2022-11-09 12:51:37");
INSERT INTO tbl_purchase VALUES("533","PUR091122103","","SU","27","0.00","116000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116000.00","0","","","2022-11-09","","116000.00","0.00","","LE_2","","0","5","2022-11-09 12:57:52");
INSERT INTO tbl_purchase VALUES("534","PUR091122104","","SU","27","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-11-09","","21000.00","0.00","","LE_2","","0","5","2022-11-09 06:43:31");
INSERT INTO tbl_purchase VALUES("535","PUR091122105","","SU","27","0.00","246000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","246000.00","0","","","2022-11-09","","246000.00","0.00","","LE_2","","0","5","2022-11-09 07:51:14");
INSERT INTO tbl_purchase VALUES("536","PUR101122101","","SU","27","0.00","148500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","148500.00","0","","","2022-11-10","","148500.00","0.00","","LE_2","","0","5","2022-11-10 05:51:30");
INSERT INTO tbl_purchase VALUES("537","PUR111122101","","SU","27","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2022-11-11","","10000.00","0.00","","LE_2","","0","5","2022-11-11 11:48:49");
INSERT INTO tbl_purchase VALUES("538","PUR111122102","","SU","27","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-11-11","","20000.00","0.00","","LE_2","","0","5","2022-11-11 12:02:36");
INSERT INTO tbl_purchase VALUES("539","PUR111122103","","SU","27","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2022-11-11","","60000.00","0.00","","LE_2","","0","5","2022-11-11 12:45:35");
INSERT INTO tbl_purchase VALUES("540","PUR111122104","","SU","27","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2022-11-11","","22000.00","0.00","","LE_2","","0","5","2022-11-11 05:27:51");
INSERT INTO tbl_purchase VALUES("541","PUR111122105","","SU","27","0.00","116000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116000.00","0","","","2022-11-11","2022-11-18","0.00","0.00","","LE_2","","0","5","2022-11-11 07:42:45");
INSERT INTO tbl_purchase VALUES("542","PUR121122101","","SU","15","0.00","207000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","207000.00","0","","","2022-11-12","","207000.00","0.00","","LE_2","","0","5","2022-11-12 07:46:52");
INSERT INTO tbl_purchase VALUES("543","PUR131122101","","SU","27","0.00","151000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","151000.00","0","","","2022-11-13","","151000.00","0.00","","LE_2","","0","5","2022-11-13 12:13:11");
INSERT INTO tbl_purchase VALUES("544","PUR131122102","","SU","27","0.00","99000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99000.00","0","","","2022-11-13","","99000.00","0.00","","LE_2","","0","5","2022-11-13 06:18:16");
INSERT INTO tbl_purchase VALUES("545","PUR131122103","","SU","27","0.00","67500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67500.00","0","","","2022-11-13","","67500.00","0.00","","LE_2","","0","5","2022-11-13 06:38:41");
INSERT INTO tbl_purchase VALUES("546","PUR131122104","","SU","27","0.00","259500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","259500.00","0","","","2022-11-13","","259500.00","0.00","","LE_2","","0","5","2022-11-13 07:25:49");
INSERT INTO tbl_purchase VALUES("547","PUR141122101","","SU","27","0.00","265000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","265000.00","0","","","2022-11-14","","265000.00","0.00","","LE_2","","0","5","2022-11-14 11:47:18");
INSERT INTO tbl_purchase VALUES("548","PUR141122102","","SU","27","0.00","2200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2200.00","0","","","2022-11-14","","2200.00","0.00","","LE_2","","0","5","2022-11-14 12:04:56");
INSERT INTO tbl_purchase VALUES("549","PUR141122103","","SU","27","0.00","193000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","193000.00","0","","","2022-11-14","","193000.00","0.00","","LE_2","","0","5","2022-11-14 06:10:28");
INSERT INTO tbl_purchase VALUES("550","PUR141122104","","SU","27","0.00","96000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96000.00","0","","","2022-11-14","","96000.00","0.00","","LE_2","","0","5","2022-11-14 06:12:39");
INSERT INTO tbl_purchase VALUES("551","PUR141122105","","SU","27","0.00","94000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","94000.00","0","","","2022-11-14","","94000.00","0.00","","LE_2","","0","5","2022-11-14 06:18:04");
INSERT INTO tbl_purchase VALUES("552","PUR141122106","","SU","27","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2022-11-14","","175000.00","0.00","","LE_2","","0","5","2022-11-14 06:21:58");
INSERT INTO tbl_purchase VALUES("553","PUR141122107","","SU","27","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-11-14","","25000.00","0.00","","LE_2","","0","5","2022-11-14 06:38:35");
INSERT INTO tbl_purchase VALUES("554","PUR151122101","","SU","27","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2022-11-15","","105000.00","0.00","","LE_2","","0","5","2022-11-15 12:14:32");
INSERT INTO tbl_purchase VALUES("555","PUR161122101","","SU","27","0.00","187000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","187000.00","0","","","2022-11-16","","187000.00","0.00","","LE_2","","0","5","2022-11-16 02:08:38");
INSERT INTO tbl_purchase VALUES("556","PUR161122102","","SU","27","0.00","236500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","236500.00","0","","","2022-11-16","","236500.00","0.00","","LE_2","","0","5","2022-11-16 04:12:32");
INSERT INTO tbl_purchase VALUES("557","PUR161122103","","SU","27","0.00","120000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120000.00","0","","","2022-11-16","","120000.00","0.00","","LE_2","","0","5","2022-11-16 04:13:39");
INSERT INTO tbl_purchase VALUES("558","PUR161122104","","SU","27","0.00","167500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","167500.00","0","","","2022-11-16","","167500.00","0.00","","LE_2","","0","5","2022-11-16 04:43:50");
INSERT INTO tbl_purchase VALUES("559","PUR161122105","","SU","27","0.00","225000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","225000.00","0","","","2022-11-16","","225000.00","0.00","","LE_2","","0","5","2022-11-16 04:51:18");
INSERT INTO tbl_purchase VALUES("560","PUR161122106","","SU","27","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-11-16","","64500.00","0.00","","LE_2","","0","5","2022-11-16 06:42:12");
INSERT INTO tbl_purchase VALUES("561","PUR161122107","","SU","27","0.00","236500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","236500.00","0","","","2022-11-16","","236500.00","0.00","","LE_2","","0","5","2022-11-16 07:07:54");
INSERT INTO tbl_purchase VALUES("562","PUR161122108","","SU","27","0.00","49500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49500.00","0","","","2022-11-16","","49500.00","0.00","","LE_2","","0","5","2022-11-16 07:51:51");
INSERT INTO tbl_purchase VALUES("563","PUR171122101","","SU","27","0.00","165000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165000.00","0","","","2022-11-17","","165000.00","0.00","","LE_2","","0","5","2022-11-17 06:28:40");
INSERT INTO tbl_purchase VALUES("564","PUR171122102","","SU","27","0.00","206500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","206500.00","0","","","2022-11-17","","206500.00","0.00","","LE_2","","0","5","2022-11-17 06:33:46");
INSERT INTO tbl_purchase VALUES("565","PUR171122103","","SU","27","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2022-11-17","","60000.00","0.00","","LE_2","","0","5","2022-11-17 06:49:18");
INSERT INTO tbl_purchase VALUES("566","PUR181122101","","SU","27","0.00","27500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27500.00","0","","","2022-11-18","","27500.00","0.00","","LE_2","","0","5","2022-11-18 11:30:43");
INSERT INTO tbl_purchase VALUES("567","PUR181122102","","SU","27","0.00","149000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149000.00","0","","","2022-11-18","","149000.00","0.00","","LE_2","","0","5","2022-11-18 06:47:18");
INSERT INTO tbl_purchase VALUES("568","PUR201122101","","SU","27","0.00","30500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30500.00","0","","","2022-11-20","","30500.00","0.00","","LE_2","","0","5","2022-11-20 03:17:54");
INSERT INTO tbl_purchase VALUES("569","PUR201122102","","SU","27","0.00","159000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159000.00","0","","","2022-11-20","","159000.00","0.00","","LE_2","","0","5","2022-11-20 05:05:05");
INSERT INTO tbl_purchase VALUES("570","PUR211122101","","SU","27","0.00","215000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","215000.00","0","","","2022-11-21","","215000.00","0.00","","LE_2","","0","5","2022-11-21 11:04:30");
INSERT INTO tbl_purchase VALUES("571","PUR211122102","","SU","27","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2022-11-21","","29000.00","0.00","","LE_2","","0","5","2022-11-21 11:06:11");
INSERT INTO tbl_purchase VALUES("572","PUR211122103","","SU","27","0.00","161000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","161000.00","0","","","2022-11-21","","161000.00","0.00","","LE_2","","0","5","2022-11-21 11:26:54");
INSERT INTO tbl_purchase VALUES("573","PUR211122104","","SU","27","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2022-11-21","","27000.00","0.00","","LE_2","","0","5","2022-11-21 11:32:53");
INSERT INTO tbl_purchase VALUES("574","PUR211122105","","SU","27","0.00","174500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","174500.00","0","","","2022-11-21","","174500.00","0.00","","LE_2","","0","5","2022-11-21 12:00:16");
INSERT INTO tbl_purchase VALUES("575","PUR211122106","","SU","27","0.00","49500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49500.00","0","","","2022-11-21","","49500.00","0.00","","LE_2","","0","5","2022-11-21 12:08:41");
INSERT INTO tbl_purchase VALUES("576","PUR211122107","","SU","27","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2022-11-21","","47000.00","0.00","","LE_2","","0","5","2022-11-21 02:01:02");
INSERT INTO tbl_purchase VALUES("577","PUR211122108","","SU","27","0.00","134000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134000.00","0","","","2022-11-21","","134000.00","0.00","","LE_2","","0","5","2022-11-21 02:39:43");
INSERT INTO tbl_purchase VALUES("578","PUR211122109","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2022-11-21","","26000.00","0.00","","LE_2","","0","5","2022-11-21 02:57:57");
INSERT INTO tbl_purchase VALUES("579","PUR211122110","","SU","27","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2022-11-21","","45000.00","0.00","","LE_2","","0","5","2022-11-21 04:09:50");
INSERT INTO tbl_purchase VALUES("580","PUR211122111","","SU","27","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","","2022-11-21","","70000.00","0.00","","LE_2","","0","5","2022-11-21 06:11:41");
INSERT INTO tbl_purchase VALUES("581","PUR221122101","","SU","27","0.00","199000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","199000.00","0","","","2022-11-22","","199000.00","0.00","","LE_2","","0","5","2022-11-22 03:25:29");
INSERT INTO tbl_purchase VALUES("582","PUR231122101","","SU","27","0.00","215000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","215000.00","0","","","2022-11-23","","215000.00","0.00","","LE_2","","0","5","2022-11-23 10:54:38");
INSERT INTO tbl_purchase VALUES("583","PUR231122102","","SU","27","0.00","67000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67000.00","0","","","2022-11-23","","67000.00","0.00","","LE_2","","0","5","2022-11-23 02:53:42");
INSERT INTO tbl_purchase VALUES("584","PUR231122103","","SU","27","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-11-23","","21000.00","0.00","","LE_2","","0","5","2022-11-23 07:00:43");
INSERT INTO tbl_purchase VALUES("585","PUR231122104","","SU","27","0.00","164500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164500.00","0","","","2022-11-23","","164500.00","0.00","","LE_2","","0","5","2022-11-23 07:46:55");
INSERT INTO tbl_purchase VALUES("586","PUR241122101","","SU","27","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2022-11-24","","126000.00","0.00","","LE_2","","0","5","2022-11-24 06:28:18");
INSERT INTO tbl_purchase VALUES("587","PUR251122101","","SU","6","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-11-25","2022-12-02","0.00","0.00","","LE_2","","0","5","2022-11-25 06:16:22");
INSERT INTO tbl_purchase VALUES("588","PUR251122102","","SU","27","0.00","202000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","202000.00","0","","","2022-11-25","","202000.00","0.00","","LE_2","","0","5","2022-11-25 06:27:38");
INSERT INTO tbl_purchase VALUES("589","PUR251122103","","SU","27","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2022-11-25","","25000.00","0.00","","LE_2","","0","5","2022-11-25 07:36:44");
INSERT INTO tbl_purchase VALUES("590","PUR261122101","","SU","27","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2022-11-26","","27000.00","0.00","","LE_2","","0","5","2022-11-26 04:31:53");
INSERT INTO tbl_purchase VALUES("591","PUR261122102","","SU","27","0.00","105500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105500.00","0","","","2022-11-26","","105500.00","0.00","","LE_2","","0","5","2022-11-26 06:16:13");
INSERT INTO tbl_purchase VALUES("592","PUR261122103","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-11-26","","28000.00","0.00","","LE_2","","0","5","2022-11-26 07:42:20");
INSERT INTO tbl_purchase VALUES("593","PUR281122101","","SU","27","0.00","219000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","219000.00","0","","","2022-11-28","","219000.00","0.00","","LE_2","","0","5","2022-11-28 11:51:14");
INSERT INTO tbl_purchase VALUES("594","PUR281122102","","SU","27","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-11-28","","21000.00","0.00","","LE_2","","0","5","2022-11-28 07:14:16");
INSERT INTO tbl_purchase VALUES("595","PUR301122101","","SU","27","0.00","225000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","225000.00","0","","","2022-11-30","","225000.00","0.00","","LE_2","","0","5","2022-11-30 11:23:48");
INSERT INTO tbl_purchase VALUES("596","PUR301122102","","SU","27","0.00","299500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","299500.00","0","","","2022-11-30","2022-12-07","0.00","0.00","","LE_2","","0","5","2022-11-30 11:26:46");
INSERT INTO tbl_purchase VALUES("597","PUR301122103","","SU","27","0.00","33500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33500.00","0","","","2022-11-30","","33500.00","0.00","","LE_2","","0","5","2022-11-30 11:32:08");
INSERT INTO tbl_purchase VALUES("598","PUR301122104","","SU","27","0.00","76500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76500.00","0","","","2022-11-30","","76500.00","0.00","","LE_2","","0","5","2022-11-30 05:26:18");
INSERT INTO tbl_purchase VALUES("599","PUR301122105","","SU","27","0.00","84000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84000.00","0","","","2022-11-30","","84000.00","0.00","","LE_2","","0","5","2022-11-30 05:31:01");
INSERT INTO tbl_purchase VALUES("600","PUR301122106","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-11-30","","28000.00","0.00","","LE_2","","0","5","2022-11-30 06:12:46");
INSERT INTO tbl_purchase VALUES("601","PUR301122107","","SU","27","0.00","420000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","420000.00","0","","","2022-11-30","","420000.00","0.00","","LE_2","","0","5","2022-11-30 06:40:31");
INSERT INTO tbl_purchase VALUES("602","PUR301122108","","SU","27","0.00","473000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","473000.00","0","","","2022-11-30","","473000.00","0.00","","LE_2","","0","5","2022-11-30 06:46:24");
INSERT INTO tbl_purchase VALUES("603","PUR301122109","","SU","27","0.00","229500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","229500.00","0","","","2022-11-30","","229500.00","0.00","","LE_2","","0","5","2022-11-30 06:48:37");
INSERT INTO tbl_purchase VALUES("604","PUR011222101","","SU","27","0.00","86000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86000.00","0","","","2022-12-01","","86000.00","0.00","","LE_2","","0","5","2022-12-01 04:22:21");
INSERT INTO tbl_purchase VALUES("605","PUR011222102","","SU","27","0.00","132000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","132000.00","0","","","2022-12-01","","132000.00","0.00","","LE_2","","0","5","2022-12-01 07:50:43");
INSERT INTO tbl_purchase VALUES("606","PUR031222101","","SU","27","0.00","295000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","295000.00","0","","","2022-12-03","2022-12-10","0.00","0.00","","LE_2","","0","5","2022-12-03 11:05:20");
INSERT INTO tbl_purchase VALUES("607","PUR031222102","","SU","27","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-12-03","","15000.00","0.00","","LE_2","","0","5","2022-12-03 11:45:12");
INSERT INTO tbl_purchase VALUES("608","PUR031222103","","SU","27","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-12-03","","16500.00","0.00","","LE_2","","0","5","2022-12-03 12:09:09");
INSERT INTO tbl_purchase VALUES("609","PUR031222104","","SU","27","0.00","193500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","193500.00","0","","","2022-12-03","","193500.00","0.00","","LE_2","","0","5","2022-12-03 01:50:10");
INSERT INTO tbl_purchase VALUES("610","PUR031222105","","SU","28","0.00","59000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59000.00","0","","","2022-12-03","2022-12-10","0.00","0.00","","LE_2","","0","5","2022-12-03 05:02:19");
INSERT INTO tbl_purchase VALUES("611","PUR041222101","","SU","27","0.00","127500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","127500.00","0","","","2022-12-04","","127500.00","0.00","","LE_2","","0","5","2022-12-04 01:14:37");
INSERT INTO tbl_purchase VALUES("612","PUR041222102","","SU","27","0.00","107500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107500.00","0","","","2022-12-04","","107500.00","0.00","","LE_2","","0","5","2022-12-04 01:32:00");
INSERT INTO tbl_purchase VALUES("613","PUR041222103","","SU","27","0.00","134000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134000.00","0","","","2022-12-04","","134000.00","0.00","","LE_2","","0","5","2022-12-04 05:09:07");
INSERT INTO tbl_purchase VALUES("614","PUR041222104","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-12-04","","21500.00","0.00","","LE_2","","0","5","2022-12-04 05:53:13");
INSERT INTO tbl_purchase VALUES("615","PUR041222105","","SU","27","0.00","66000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","66000.00","0","","","2022-12-04","","66000.00","0.00","","LE_2","","0","5","2022-12-04 07:10:48");
INSERT INTO tbl_purchase VALUES("616","PUR041222106","","SU","27","0.00","258000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","258000.00","0","","","2022-12-04","","258000.00","0.00","","LE_2","","0","5","2022-12-04 07:40:10");
INSERT INTO tbl_purchase VALUES("617","PUR041222107","","SU","27","0.00","228000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228000.00","0","","","2022-12-04","","228000.00","0.00","","LE_2","","0","5","2022-12-04 07:42:17");
INSERT INTO tbl_purchase VALUES("618","PUR051222101","","SU","27","0.00","215000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","215000.00","0","","","2022-12-05","","215000.00","0.00","","LE_2","","0","5","2022-12-05 06:13:35");
INSERT INTO tbl_purchase VALUES("619","PUR051222102","","SU","27","0.00","205000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","205000.00","0","","","2022-12-05","","205000.00","0.00","","LE_2","","0","5","2022-12-05 06:14:54");
INSERT INTO tbl_purchase VALUES("620","PUR051222103","","SU","27","0.00","268000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","268000.00","0","","","2022-12-05","","268000.00","0.00","","LE_2","","0","5","2022-12-05 06:23:36");
INSERT INTO tbl_purchase VALUES("621","PUR051222104","","SU","27","0.00","129000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129000.00","0","","","2022-12-05","","129000.00","0.00","","LE_2","","0","5","2022-12-05 06:36:40");
INSERT INTO tbl_purchase VALUES("622","PUR051222105","","SU","27","0.00","61000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61000.00","0","","","2022-12-05","","61000.00","0.00","","LE_2","","0","5","2022-12-05 07:00:51");
INSERT INTO tbl_purchase VALUES("623","PUR071222101","","SU","2","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","5","2022-12-07 02:11:36");
INSERT INTO tbl_purchase VALUES("624","PUR071222102","","SU","2","0.00","180000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","5","2022-12-07 07:31:18");
INSERT INTO tbl_purchase VALUES("625","PUR071222103","","SU","27","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-12-07","","43000.00","0.00","","LE_2","","0","5","2022-12-07 07:55:24");
INSERT INTO tbl_purchase VALUES("626","PUR081222101","","SU","27","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2022-12-08","","65000.00","0.00","","LE_2","","0","5","2022-12-08 11:42:08");
INSERT INTO tbl_purchase VALUES("627","PUR081222102","","SU","27","0.00","116500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116500.00","0","","","2022-12-08","","116500.00","0.00","","LE_2","","0","5","2022-12-08 11:49:09");
INSERT INTO tbl_purchase VALUES("628","PUR081222103","","SU","27","0.00","150500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150500.00","0","","","2022-12-08","","150500.00","0.00","","LE_2","","0","5","2022-12-08 01:27:46");
INSERT INTO tbl_purchase VALUES("629","PUR081222104","","SU","2","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","5","2022-12-08 06:04:44");
INSERT INTO tbl_purchase VALUES("630","PUR081222105","","SU","27","0.00","82500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","82500.00","0","","","2022-12-08","","82500.00","0.00","","LE_2","","0","5","2022-12-08 06:39:27");
INSERT INTO tbl_purchase VALUES("631","PUR081222106","","SU","27","0.00","112500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112500.00","0","","","2022-12-08","","112500.00","0.00","","LE_2","","0","5","2022-12-08 06:41:31");
INSERT INTO tbl_purchase VALUES("632","PUR081222107","","SU","27","0.00","164000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164000.00","0","","","2022-12-08","","164000.00","0.00","","LE_2","","0","5","2022-12-08 06:43:44");
INSERT INTO tbl_purchase VALUES("633","PUR081222108","","SU","27","0.00","61000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61000.00","0","","","2022-12-08","","61000.00","0.00","","LE_2","","0","5","2022-12-08 06:45:24");
INSERT INTO tbl_purchase VALUES("634","PUR091222101","","SU","27","0.00","220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220.00","0","","","2022-12-09","","220.00","0.00","","LE_2","","0","5","2022-12-09 10:43:23");
INSERT INTO tbl_purchase VALUES("635","PUR091222102","","SU","27","0.00","4000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4000.00","0","","","2022-12-09","","4000.00","0.00","","LE_2","","0","5","2022-12-09 10:45:36");
INSERT INTO tbl_purchase VALUES("636","PUR091222103","","SU","29","0.00","23800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23800.00","0","","","2022-12-09","","23800.00","0.00","","LE_2","","0","5","2022-12-09 04:37:19");
INSERT INTO tbl_purchase VALUES("637","PUR091222104","","SU","29","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2022-12-09","","72000.00","0.00","","LE_2","","0","5","2022-12-09 05:16:30");
INSERT INTO tbl_purchase VALUES("638","PUR091222105","","SU","29","0.00","50600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50600.00","0","","","2022-12-09","","50600.00","0.00","","LE_2","","0","5","2022-12-09 05:23:04");
INSERT INTO tbl_purchase VALUES("639","PUR091222106","","SU","29","0.00","64800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64800.00","0","","","2022-12-09","","64800.00","0.00","","LE_2","","0","5","2022-12-09 05:48:00");
INSERT INTO tbl_purchase VALUES("640","PUR091222107","","SU","15","0.00","12000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12000.00","0","","","2022-12-09","","12000.00","0.00","","LE_2","","0","5","2022-12-09 05:59:37");
INSERT INTO tbl_purchase VALUES("641","PUR091222108","","SU","27","0.00","129000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129000.00","0","","","2022-12-09","","129000.00","0.00","","LE_2","","0","5","2022-12-09 06:04:56");
INSERT INTO tbl_purchase VALUES("642","PUR111222101","","SU","27","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2022-12-11","","43000.00","0.00","","LE_2","","0","5","2022-12-11 03:49:04");
INSERT INTO tbl_purchase VALUES("643","PUR111222102","","SU","27","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2022-12-11","","64500.00","0.00","","LE_2","","0","5","2022-12-11 04:37:00");
INSERT INTO tbl_purchase VALUES("644","PUR111222103","","SU","27","0.00","107500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107500.00","0","","","2022-12-11","","107500.00","0.00","","LE_2","","0","5","2022-12-11 04:47:10");
INSERT INTO tbl_purchase VALUES("645","PUR111222104","","SU","27","0.00","125000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125000.00","0","","","2022-12-11","","125000.00","0.00","","LE_2","","0","5","2022-12-11 05:08:05");
INSERT INTO tbl_purchase VALUES("646","PUR111222105","","SU","2","0.00","88500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88500.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","5","2022-12-11 06:07:23");
INSERT INTO tbl_purchase VALUES("647","PUR121222101","","SU","27","0.00","315000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","315000.00","0","","","2022-12-12","","315000.00","0.00","","LE_2","","0","5","2022-12-12 02:11:49");
INSERT INTO tbl_purchase VALUES("648","PUR121222102","","SU","27","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-12-12","","16500.00","0.00","","LE_2","","0","5","2022-12-12 02:16:15");
INSERT INTO tbl_purchase VALUES("649","PUR131222101","","SU","27","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2022-12-13","","34000.00","0.00","","LE_2","","0","5","2022-12-13 11:38:52");
INSERT INTO tbl_purchase VALUES("650","PUR141222101","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2022-12-14","","21500.00","0.00","","LE_2","","0","5","2022-12-14 01:41:28");
INSERT INTO tbl_purchase VALUES("651","PUR141222102","","SU","27","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2022-12-14","","16500.00","0.00","","LE_2","","0","5","2022-12-14 02:29:02");
INSERT INTO tbl_purchase VALUES("652","PUR141222103","","SU","27","0.00","322500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","322500.00","0","","","2022-12-14","","322500.00","0.00","","LE_2","","0","5","2022-12-14 06:55:51");
INSERT INTO tbl_purchase VALUES("653","PUR151222101","","SU","27","0.00","623500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","623500.00","0","","","2022-12-15","","623500.00","0.00","","LE_2","","0","5","2022-12-15 05:16:49");
INSERT INTO tbl_purchase VALUES("654","PUR151222102","","SU","27","0.00","134000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134000.00","0","","","2022-12-15","","134000.00","0.00","","LE_2","","0","5","2022-12-15 05:50:50");
INSERT INTO tbl_purchase VALUES("655","PUR151222103","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-12-15","","28000.00","0.00","","LE_2","","0","5","2022-12-15 05:53:24");
INSERT INTO tbl_purchase VALUES("656","PUR171222101","","SU","27","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","5","2022-12-17 06:10:27");
INSERT INTO tbl_purchase VALUES("657","PUR171222102","","SU","1","0.00","2300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2300.00","0","","","2022-12-17","","2300.00","0.00","","LE_2","","0","5","2022-12-17 02:14:26");
INSERT INTO tbl_purchase VALUES("658","PUR171222103","","SU","27","0.00","246000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","246000.00","0","","","2022-12-17","","246000.00","0.00","","LE_2","","0","5","2022-12-17 02:59:49");
INSERT INTO tbl_purchase VALUES("659","PUR181222101","","SU","27","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2022-12-18","","20000.00","0.00","","LE_2","","0","5","2022-12-18 02:48:06");
INSERT INTO tbl_purchase VALUES("660","PUR181222102","","SU","27","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2022-12-18","","15000.00","0.00","","LE_2","","0","5","2022-12-18 04:18:48");
INSERT INTO tbl_purchase VALUES("661","PUR191222101","","SU","27","0.00","666500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","666500.00","0","","","2022-12-19","","666500.00","0.00","","LE_2","","0","5","2022-12-19 02:17:56");
INSERT INTO tbl_purchase VALUES("662","PUR191222102","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2022-12-19","","28000.00","0.00","","LE_2","","0","5","2022-12-19 06:32:12");
INSERT INTO tbl_purchase VALUES("663","PUR191222103","","SU","27","0.00","168000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","168000.00","0","","","2022-12-19","","168000.00","0.00","","LE_2","","0","5","2022-12-19 07:15:58");
INSERT INTO tbl_purchase VALUES("664","PUR211222101","","SU","1","0.00","4000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4000.00","0","","","2022-12-21","2022-12-28","0.00","0.00","","LE_2","","0","5","2022-12-21 12:59:38");
INSERT INTO tbl_purchase VALUES("665","PUR231222101","","SU","27","0.00","752500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","752500.00","0","","","2022-12-23","","752500.00","0.00","","LE_2","","0","5","2022-12-23 03:36:55");
INSERT INTO tbl_purchase VALUES("666","PUR241222101","","SU","27","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2022-12-24","","23000.00","0.00","","LE_2","","0","5","2022-12-24 04:25:07");
INSERT INTO tbl_purchase VALUES("667","PUR251222101","","SU","27","0.00","15500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15500.00","0","","","2022-12-25","","15500.00","0.00","","LE_2","","0","5","2022-12-25 07:04:39");
INSERT INTO tbl_purchase VALUES("668","PUR261222101","","SU","29","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-12-26","2023-01-02","0.00","0.00","","LE_2","","0","5","2022-12-26 11:45:27");
INSERT INTO tbl_purchase VALUES("669","PUR261222102","","SU","27","0.00","186500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","186500.00","0","","","2022-12-26","","186500.00","0.00","","LE_2","","0","5","2022-12-26 03:47:39");
INSERT INTO tbl_purchase VALUES("670","PUR261222103","","SU","27","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2022-12-26","","1500.00","0.00","","LE_2","","0","5","2022-12-26 07:42:50");
INSERT INTO tbl_purchase VALUES("671","PUR291222101","","SU","27","0.00","473500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","473500.00","0","","","2022-12-29","","473500.00","0.00","","LE_2","","0","5","2022-12-29 11:59:18");
INSERT INTO tbl_purchase VALUES("672","PUR291222102","","SU","27","0.00","112000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112000.00","0","","","2022-12-29","","112000.00","0.00","","LE_2","","0","5","2022-12-29 07:04:47");
INSERT INTO tbl_purchase VALUES("673","PUR291222103","","SU","15","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2022-12-29","","175000.00","0.00","","LE_2","","0","5","2022-12-29 07:19:36");
INSERT INTO tbl_purchase VALUES("674","PUR291222104","","SU","27","0.00","55000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55000.00","0","","","2022-12-29","","55000.00","0.00","","LE_2","","0","5","2022-12-29 07:29:03");
INSERT INTO tbl_purchase VALUES("675","PUR301222101","","SU","27","0.00","631000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","631000.00","0","","","2022-12-30","","631000.00","0.00","","LE_2","","0","5","2022-12-30 04:04:46");
INSERT INTO tbl_purchase VALUES("676","PUR010123101","","SU","27","0.00","84000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84000.00","0","","","2023-01-01","","84000.00","0.00","","LE_2","","0","5","2023-01-01 06:42:38");
INSERT INTO tbl_purchase VALUES("677","PUR010123102","","SU","27","0.00","293500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","293500.00","0","","","2023-01-01","","293500.00","0.00","","LE_2","","0","5","2023-01-01 07:49:38");
INSERT INTO tbl_purchase VALUES("678","PUR060123101","","SU","27","0.00","473500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","473500.00","0","","","2023-01-06","","473500.00","0.00","","LE_2","","0","5","2023-01-06 04:49:54");
INSERT INTO tbl_purchase VALUES("679","PUR070123101","","SU","27","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-01-07","","56000.00","0.00","","LE_2","","0","5","2023-01-07 05:43:53");
INSERT INTO tbl_purchase VALUES("680","PUR080123101","","SU","27","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2023-01-08","","30000.00","0.00","","LE_2","","0","5","2023-01-08 05:57:42");
INSERT INTO tbl_purchase VALUES("681","PUR090123101","","SU","27","0.00","85500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85500.00","0","","","2023-01-09","2023-01-16","0.00","0.00","","LE_2","","0","5","2023-01-09 12:31:33");
INSERT INTO tbl_purchase VALUES("682","PUR110123101","","SU","27","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2023-01-11","","43000.00","0.00","","LE_2","","0","5","2023-01-11 05:37:27");
INSERT INTO tbl_purchase VALUES("683","PUR120123101","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2023-01-12","","21500.00","0.00","","LE_2","","0","5","2023-01-12 01:57:04");
INSERT INTO tbl_purchase VALUES("684","PUR120123102","","SU","27","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-01-12","","114000.00","0.00","","LE_2","","0","5","2023-01-12 03:35:15");
INSERT INTO tbl_purchase VALUES("685","PUR150123101","","SU","27","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2023-01-15","","58000.00","0.00","","LE_2","","0","5","2023-01-15 11:13:01");
INSERT INTO tbl_purchase VALUES("686","PUR150123102","","SU","27","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-01-15","","38000.00","0.00","","LE_2","","0","5","2023-01-15 11:16:12");
INSERT INTO tbl_purchase VALUES("687","PUR150123103","","SU","27","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2023-01-15","","36000.00","0.00","","LE_2","","0","5","2023-01-15 12:02:17");
INSERT INTO tbl_purchase VALUES("688","PUR150123104","","SU","27","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2023-01-15","","21500.00","0.00","","LE_2","","0","5","2023-01-15 06:20:23");
INSERT INTO tbl_purchase VALUES("689","PUR160123101","","SU","27","0.00","228500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228500.00","0","","","2023-01-16","","228500.00","0.00","","LE_2","","0","5","2023-01-16 06:56:02");
INSERT INTO tbl_purchase VALUES("690","PUR180123101","","SU","27","0.00","305500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","305500.00","0","","","2023-01-18","","305500.00","0.00","","LE_2","","0","5","2023-01-18 07:34:24");
INSERT INTO tbl_purchase VALUES("691","PUR190123101","","SU","27","0.00","279500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","279500.00","0","","","2023-01-19","","279500.00","0.00","","LE_2","","0","5","2023-01-19 07:06:09");
INSERT INTO tbl_purchase VALUES("692","PUR200123101","","SU","27","0.00","86000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86000.00","0","","","2023-01-20","","86000.00","0.00","","LE_2","","0","5","2023-01-20 05:42:30");
INSERT INTO tbl_purchase VALUES("693","PUR210123101","","SU","27","0.00","171000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171000.00","0","","","2023-01-21","","171000.00","0.00","","LE_2","","0","5","2023-01-21 06:21:02");
INSERT INTO tbl_purchase VALUES("694","PUR210123102","","SU","27","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-01-21","","38000.00","0.00","","LE_2","","0","5","2023-01-21 06:54:49");
INSERT INTO tbl_purchase VALUES("695","PUR220123101","","SU","27","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-01-22","","38000.00","0.00","","LE_2","","0","5","2023-01-22 02:22:01");
INSERT INTO tbl_purchase VALUES("696","PUR220123102","","SU","27","0.00","152000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152000.00","0","","","2023-01-22","","152000.00","0.00","","LE_2","","0","5","2023-01-22 06:55:29");
INSERT INTO tbl_purchase VALUES("697","PUR220123103","","SU","28","0.00","150000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150000.00","0","","","2023-01-22","2023-01-29","0.00","0.00","","LE_2","","0","5","2023-01-22 06:58:35");
INSERT INTO tbl_purchase VALUES("698","PUR220123104","","SU","28","0.00","178500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","178500.00","0","","","2023-01-22","2023-01-29","0.00","0.00","","LE_2","","0","5","2023-01-22 07:05:40");
INSERT INTO tbl_purchase VALUES("699","PUR230123101","","SU","27","0.00","247000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","247000.00","0","","","2023-01-23","","247000.00","0.00","","LE_2","","0","5","2023-01-23 07:45:18");
INSERT INTO tbl_purchase VALUES("700","PUR230123102","","SU","27","0.00","13500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13500.00","0","","","2023-01-23","","13500.00","0.00","","LE_2","","0","5","2023-01-23 07:46:58");
INSERT INTO tbl_purchase VALUES("701","PUR250123101","","SU","27","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2023-01-25","","10000.00","0.00","","LE_2","","0","5","2023-01-25 03:32:57");
INSERT INTO tbl_purchase VALUES("702","PUR250123102","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2023-01-25","","12500.00","0.00","","LE_2","","0","5","2023-01-25 04:14:15");
INSERT INTO tbl_purchase VALUES("703","PUR260123101","","SU","30","0.00","41000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41000.00","0","","","2023-01-26","2023-02-02","0.00","0.00","","LE_2","","0","5","2023-01-26 11:58:12");
INSERT INTO tbl_purchase VALUES("704","PUR260123102","","SU","31","0.00","139000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","139000.00","0","","","2023-01-26","2023-02-02","0.00","0.00","","LE_2","","0","5","2023-01-26 02:57:15");
INSERT INTO tbl_purchase VALUES("705","PUR260123103","","SU","32","0.00","110000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110000.00","0","","","2023-01-26","2023-02-02","0.00","0.00","","LE_2","","0","5","2023-01-26 07:29:11");
INSERT INTO tbl_purchase VALUES("706","PUR260123104","","SU","27","0.00","399000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","399000.00","0","","","2023-01-26","","399000.00","0.00","","LE_2","","0","5","2023-01-26 07:52:53");
INSERT INTO tbl_purchase VALUES("707","PUR270123101","","SU","27","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2023-01-27","","15000.00","0.00","","LE_2","","0","5","2023-01-27 12:25:06");
INSERT INTO tbl_purchase VALUES("708","PUR280123101","","SU","27","0.00","304000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","304000.00","0","","","2023-01-28","","304000.00","0.00","","LE_2","","0","5","2023-01-28 06:15:16");
INSERT INTO tbl_purchase VALUES("709","PUR280123102","","SU","27","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2023-01-28","","36000.00","0.00","","LE_2","","0","5","2023-01-28 06:16:15");
INSERT INTO tbl_purchase VALUES("710","PUR280123103","","SU","30","0.00","41000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41000.00","0","","","2023-01-28","2023-02-04","0.00","0.00","","LE_2","","0","5","2023-01-28 06:36:37");
INSERT INTO tbl_purchase VALUES("711","PUR280123104","","SU","27","0.00","285000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285000.00","0","","","2023-01-28","","285000.00","0.00","","LE_2","","0","5","2023-01-28 06:52:24");
INSERT INTO tbl_purchase VALUES("712","PUR290123101","","SU","27","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2023-01-29","2023-02-05","0.00","0.00","","LE_2","","0","5","2023-01-29 12:08:51");
INSERT INTO tbl_purchase VALUES("713","PUR290123102","","SU","27","0.00","361000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","361000.00","0","","","2023-01-29","","361000.00","0.00","","LE_2","","0","5","2023-01-29 03:17:53");
INSERT INTO tbl_purchase VALUES("714","PUR290123103","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-01-29","","28000.00","0.00","","LE_2","","0","5","2023-01-29 07:54:26");
INSERT INTO tbl_purchase VALUES("715","PUR300123101","","SU","27","0.00","190000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190000.00","0","","","2023-01-30","","190000.00","0.00","","LE_2","","0","5","2023-01-30 12:25:18");
INSERT INTO tbl_purchase VALUES("716","PUR300123102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-01-30","","19000.00","0.00","","LE_2","","0","5","2023-01-30 01:15:38");
INSERT INTO tbl_purchase VALUES("717","PUR300123103","","SU","27","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-01-30","","114000.00","0.00","","LE_2","","0","5","2023-01-30 07:12:16");
INSERT INTO tbl_purchase VALUES("718","PUR300123104","","SU","27","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-01-30","","38000.00","0.00","","LE_2","","0","5","2023-01-30 08:06:43");
INSERT INTO tbl_purchase VALUES("719","PUR010223101","","SU","20","0.00","298500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","298500.00","0","","","2023-02-01","2023-02-08","0.00","0.00","","LE_2","","0","5","2023-02-01 12:46:11");
INSERT INTO tbl_purchase VALUES("720","PUR010223102","","SU","2","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2023-02-01","2023-02-08","0.00","0.00","","LE_2","","0","5","2023-02-01 03:26:43");
INSERT INTO tbl_purchase VALUES("721","PUR010223103","","SU","27","0.00","835000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","835000.00","0","","","2023-02-01","","835000.00","0.00","","LE_2","","0","5","2023-02-01 04:29:29");
INSERT INTO tbl_purchase VALUES("722","PUR020223101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-02","","19000.00","0.00","","LE_2","","0","5","2023-02-02 03:03:36");
INSERT INTO tbl_purchase VALUES("723","PUR030223101","","SU","27","0.00","418000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","418000.00","0","","","2023-02-03","","418000.00","0.00","","LE_2","","0","5","2023-02-03 11:21:44");
INSERT INTO tbl_purchase VALUES("724","PUR030223102","","SU","27","0.00","494000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","494000.00","0","","","2023-02-03","2023-02-10","0.00","0.00","","LE_2","","0","5","2023-02-03 01:40:11");
INSERT INTO tbl_purchase VALUES("725","PUR030223103","","SU","27","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2023-02-03","","58000.00","0.00","","LE_2","","0","5","2023-02-03 06:04:02");
INSERT INTO tbl_purchase VALUES("726","PUR030223104","","SU","27","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2023-02-03","","72000.00","0.00","","LE_2","","0","5","2023-02-03 07:26:00");
INSERT INTO tbl_purchase VALUES("727","PUR040223101","","SU","27","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2023-02-04","","47000.00","0.00","","LE_2","","0","5","2023-02-04 04:51:22");
INSERT INTO tbl_purchase VALUES("728","PUR040223102","","SU","27","0.00","209000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","209000.00","0","","","2023-02-04","","209000.00","0.00","","LE_2","","0","5","2023-02-04 07:50:20");
INSERT INTO tbl_purchase VALUES("729","PUR050223101","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2023-02-05","","12500.00","0.00","","LE_2","","0","5","2023-02-05 01:19:28");
INSERT INTO tbl_purchase VALUES("730","PUR050223102","","SU","27","0.00","372000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","372000.00","0","","","2023-02-05","","372000.00","0.00","","LE_2","","0","5","2023-02-05 07:15:24");
INSERT INTO tbl_purchase VALUES("731","PUR060223101","","SU","27","0.00","289000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","289000.00","0","","","2023-02-06","","289000.00","0.00","","LE_2","","0","5","2023-02-06 12:07:58");
INSERT INTO tbl_purchase VALUES("732","PUR060223102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-06","","19000.00","0.00","","LE_2","","0","5","2023-02-06 12:58:21");
INSERT INTO tbl_purchase VALUES("733","PUR060223103","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-06","","19000.00","0.00","","LE_2","","0","5","2023-02-06 02:10:11");
INSERT INTO tbl_purchase VALUES("734","PUR060223104","","SU","27","0.00","228000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228000.00","0","","","2023-02-06","","228000.00","0.00","","LE_2","","0","5","2023-02-06 06:34:33");
INSERT INTO tbl_purchase VALUES("735","PUR080223101","","SU","27","0.00","176000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","176000.00","0","","","2023-02-08","","176000.00","0.00","","LE_2","","0","5","2023-02-08 11:51:30");
INSERT INTO tbl_purchase VALUES("736","PUR080223102","","SU","27","0.00","168000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","168000.00","0","","","2023-02-08","","168000.00","0.00","","LE_2","","0","5","2023-02-08 05:03:34");
INSERT INTO tbl_purchase VALUES("737","PUR090223101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-09","","19000.00","0.00","","LE_2","","0","5","2023-02-09 03:39:20");
INSERT INTO tbl_purchase VALUES("738","PUR090223102","","SU","27","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2023-02-09","","20000.00","0.00","","LE_2","","0","5","2023-02-09 03:54:49");
INSERT INTO tbl_purchase VALUES("739","PUR090223103","","SU","27","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-02-09","2023-02-16","0.00","0.00","","LE_2","","0","5","2023-02-09 06:09:48");
INSERT INTO tbl_purchase VALUES("740","PUR100223101","","SU","27","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2023-02-10","","48000.00","0.00","","LE_2","","0","5","2023-02-10 06:50:35");
INSERT INTO tbl_purchase VALUES("741","PUR110223101","","SU","15","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-02-11","","38000.00","0.00","","LE_2","","0","5","2023-02-11 11:55:13");
INSERT INTO tbl_purchase VALUES("742","PUR110223102","","SU","10","0.00","1800000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1800000.00","0","","","2022-02-15","","1800000.00","0.00","","LE_2","","0","5","2023-02-11 10:28:53");
INSERT INTO tbl_purchase VALUES("743","PUR110223103","","SU","29","0.00","1900000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1900000.00","0","","","2023-02-11","","1900000.00","0.00","","LE_2","","0","5","2023-02-11 10:31:52");
INSERT INTO tbl_purchase VALUES("744","PUR120223101","","SU","27","0.00","4750000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4750000.00","0","","","2022-02-23","","4750000.00","0.00","","LE_2","","0","5","2023-02-12 12:33:10");
INSERT INTO tbl_purchase VALUES("745","PUR120223102","","SU","36","0.00","500000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","500000.00","0","","","2022-03-30","","500000.00","0.00","","LE_2","","0","5","2023-02-12 10:56:46");
INSERT INTO tbl_purchase VALUES("747","PUR120223103","","SU","37","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2022-03-09","","100000.00","0.00","","LE_2","","0","5","2023-02-12 10:59:38");
INSERT INTO tbl_purchase VALUES("748","PUR120223104","","SU","37","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","","2022-02-23","","70000.00","0.00","","LE_2","","0","5","2023-02-12 11:00:29");
INSERT INTO tbl_purchase VALUES("749","PUR120223105","","SU","38","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2022-03-09","","100000.00","0.00","","LE_2","","0","5","2023-02-12 11:06:29");
INSERT INTO tbl_purchase VALUES("750","PUR120223106","","SU","10","0.00","1340000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1340000.00","0","","","2022-03-10","","1345000.00","5000.00","","LE_2","","0","5","2023-02-12 11:08:42");
INSERT INTO tbl_purchase VALUES("751","PUR120223107","","SU","15","0.00","2000000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2000000.00","0","","","2022-03-06","","2000000.00","0.00","","LE_2","","0","5","2023-02-12 11:15:34");
INSERT INTO tbl_purchase VALUES("752","PUR120223108","","SU","15","0.00","500000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","500000.00","0","","","2022-03-23","","500000.00","0.00","","LE_2","","0","5","2023-02-12 11:17:18");
INSERT INTO tbl_purchase VALUES("753","PUR120223109","","SU","27","0.00","500000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","500000.00","0","","","2022-04-15","","500000.00","0.00","","LE_2","","0","5","2023-02-12 11:18:35");
INSERT INTO tbl_purchase VALUES("754","PUR120223110","","SU","27","0.00","8140000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8140000.00","0","","","2022-03-24","","8140000.00","0.00","","LE_2","","0","5","2023-02-12 12:29:48");
INSERT INTO tbl_purchase VALUES("755","PUR120223111","","SU","10","0.00","3900000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3900000.00","0","","","2022-09-14","2023-02-19","0.00","0.00","","LE_2","","0","5","2023-02-12 01:42:37");
INSERT INTO tbl_purchase VALUES("756","PUR120223112","","SU","10","0.00","7400000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7400000.00","0","","","2022-04-05","","7400000.00","0.00","","LE_2","","0","5","2023-02-12 02:33:47");
INSERT INTO tbl_purchase VALUES("757","PUR120223113","","SU","27","0.00","73000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73000.00","0","","","2023-02-12","","73000.00","0.00","","LE_2","","0","5","2023-02-12 06:12:02");
INSERT INTO tbl_purchase VALUES("758","PUR120223114","","SU","27","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-02-12","","114000.00","0.00","","LE_2","","0","5","2023-02-12 07:21:41");
INSERT INTO tbl_purchase VALUES("759","PUR150223101","","SU","10","0.00","504000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","504000.00","0","","","2023-02-15","","504000.00","0.00","","LE_2","","0","5","2023-02-15 12:31:36");
INSERT INTO tbl_purchase VALUES("760","PUR150223102","","SU","15","0.00","266000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266000.00","0","","","2023-02-15","","266000.00","0.00","","LE_2","","0","5","2023-02-15 01:11:03");
INSERT INTO tbl_purchase VALUES("761","PUR160223101","","SU","27","0.00","703000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","703000.00","0","","","2023-02-16","","703000.00","0.00","","LE_2","","0","5","2023-02-16 11:48:46");
INSERT INTO tbl_purchase VALUES("762","PUR160223102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-16","","19000.00","0.00","","LE_2","","0","5","2023-02-16 05:22:28");
INSERT INTO tbl_purchase VALUES("763","PUR160223103","","SU","27","0.00","456000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","456000.00","0","","","2023-02-16","","456000.00","0.00","","LE_2","","0","5","2023-02-16 07:25:34");
INSERT INTO tbl_purchase VALUES("764","PUR170223101","","SU","27","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2023-02-17","","48000.00","0.00","","LE_2","","0","5","2023-02-17 05:10:17");
INSERT INTO tbl_purchase VALUES("765","PUR170223102","","SU","27","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-02-17","","76000.00","0.00","","LE_2","","0","5","2023-02-17 05:44:50");
INSERT INTO tbl_purchase VALUES("766","PUR180223101","","SU","27","0.00","20500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20500.00","0","","","2023-02-18","","20500.00","0.00","","LE_2","","0","5","2023-02-18 06:57:32");
INSERT INTO tbl_purchase VALUES("767","PUR180223102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-18","","19000.00","0.00","","LE_2","","0","5","2023-02-18 07:48:37");
INSERT INTO tbl_purchase VALUES("768","PUR200223101","","SU","27","0.00","380000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","380000.00","0","","","2023-02-20","","380000.00","0.00","","LE_2","","0","5","2023-02-20 06:00:08");
INSERT INTO tbl_purchase VALUES("769","PUR220223101","","SU","27","0.00","380000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","380000.00","0","","","2023-02-22","","380000.00","0.00","","LE_2","","0","5","2023-02-22 07:06:47");
INSERT INTO tbl_purchase VALUES("770","PUR220223102","","SU","27","0.00","171000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171000.00","0","","","2023-02-22","","171000.00","0.00","","LE_2","","0","5","2023-02-22 10:49:03");
INSERT INTO tbl_purchase VALUES("771","PUR230223101","","SU","27","0.00","380000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","380000.00","0","","","2023-02-23","","380000.00","0.00","","LE_2","","0","5","2023-02-23 03:34:43");
INSERT INTO tbl_purchase VALUES("772","PUR240223101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-24","","19000.00","0.00","","LE_2","","0","5","2023-02-24 02:39:39");
INSERT INTO tbl_purchase VALUES("773","PUR240223102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-24","","19000.00","0.00","","LE_2","","0","5","2023-02-24 05:54:15");
INSERT INTO tbl_purchase VALUES("774","PUR240223103","","SU","27","0.00","532000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","532000.00","0","","","2023-02-24","","532000.00","0.00","","LE_2","","0","5","2023-02-24 07:00:20");
INSERT INTO tbl_purchase VALUES("775","PUR250223101","","SU","27","0.00","104000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104000.00","0","","","2023-02-25","","104000.00","0.00","","LE_2","","0","5","2023-02-25 06:14:07");
INSERT INTO tbl_purchase VALUES("776","PUR260223101","","SU","27","0.00","323000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","323000.00","0","","","2023-02-26","","323000.00","0.00","","LE_2","","0","5","2023-02-26 05:35:54");
INSERT INTO tbl_purchase VALUES("777","PUR260223102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-02-26","","19000.00","0.00","","LE_2","","0","5","2023-02-26 07:21:52");
INSERT INTO tbl_purchase VALUES("778","PUR010323101","","SU","27","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-03-01","","38000.00","0.00","","LE_2","","0","5","2023-03-01 07:30:48");
INSERT INTO tbl_purchase VALUES("779","PUR030323101","","SU","27","0.00","286000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","286000.00","0","","","2023-03-03","","286000.00","0.00","","LE_2","","0","5","2023-03-03 03:58:27");
INSERT INTO tbl_purchase VALUES("780","PUR030323102","","SU","27","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-03-03","","114000.00","0.00","","LE_2","","0","5","2023-03-03 04:56:13");
INSERT INTO tbl_purchase VALUES("781","PUR040323101","","SU","27","0.00","513000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","513000.00","0","","","2023-03-04","","513000.00","0.00","","LE_2","","0","5","2023-03-04 12:02:14");
INSERT INTO tbl_purchase VALUES("782","PUR040323102","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2023-03-04","","12500.00","0.00","","LE_2","","0","5","2023-03-04 11:19:40");
INSERT INTO tbl_purchase VALUES("783","PUR040323103","","SU","27","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2023-03-04","","95000.00","0.00","","LE_2","","0","5","2023-03-04 07:50:15");
INSERT INTO tbl_purchase VALUES("784","PUR040323104","","SU","27","0.00","59000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59000.00","0","","","2023-03-04","","59000.00","0.00","","LE_2","","0","5","2023-03-04 08:00:09");
INSERT INTO tbl_purchase VALUES("785","PUR040323105","","SU","27","0.00","152000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152000.00","0","","","2023-03-04","","152000.00","0.00","","LE_2","","0","5","2023-03-04 08:20:50");
INSERT INTO tbl_purchase VALUES("786","PUR050323101","","SU","27","0.00","247000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","247000.00","0","","","2023-03-05","","247000.00","0.00","","LE_2","","0","5","2023-03-05 05:11:50");
INSERT INTO tbl_purchase VALUES("787","PUR050323102","","SU","27","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-03-05","","76000.00","0.00","","LE_2","","0","5","2023-03-05 07:43:16");
INSERT INTO tbl_purchase VALUES("788","PUR060323101","","SU","27","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2023-03-06","","130000.00","0.00","","LE_2","","0","5","2023-03-06 11:29:06");
INSERT INTO tbl_purchase VALUES("789","PUR060323102","","SU","27","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2023-03-06","","52000.00","0.00","","LE_2","","0","5","2023-03-06 05:44:40");
INSERT INTO tbl_purchase VALUES("790","PUR090323101","","SU","27","0.00","380000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","380000.00","0","","","2023-03-09","","380000.00","0.00","","LE_2","","0","5","2023-03-09 10:49:28");
INSERT INTO tbl_purchase VALUES("791","PUR090323102","","SU","27","0.00","285000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285000.00","0","","","2023-03-09","","285000.00","0.00","","LE_2","","0","5","2023-03-09 03:30:18");
INSERT INTO tbl_purchase VALUES("792","PUR090323103","","SU","27","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-03-09","","114000.00","0.00","","LE_2","","0","5","2023-03-09 06:32:32");
INSERT INTO tbl_purchase VALUES("793","PUR100323101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-03-10","2023-03-17","0.00","0.00","","LE_2","","0","5","2023-03-10 11:47:24");
INSERT INTO tbl_purchase VALUES("794","PUR100323102","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-03-10","","26000.00","0.00","","LE_2","","0","5","2023-03-10 12:37:15");
INSERT INTO tbl_purchase VALUES("795","PUR100323103","","SU","27","0.00","32000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32000.00","0","","","2023-03-10","","32000.00","0.00","","LE_2","","0","5","2023-03-10 04:54:12");
INSERT INTO tbl_purchase VALUES("796","PUR100323104","","SU","27","0.00","209000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","209000.00","0","","","2023-03-10","","209000.00","0.00","","LE_2","","0","5","2023-03-10 05:22:31");
INSERT INTO tbl_purchase VALUES("797","PUR110323101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-03-11","","19000.00","0.00","","LE_2","","0","5","2023-03-11 12:58:36");
INSERT INTO tbl_purchase VALUES("798","PUR110323102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-03-06","","19000.00","0.00","","LE_2","","0","5","2023-03-11 02:30:09");
INSERT INTO tbl_purchase VALUES("799","PUR110323103","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-03-11","","26000.00","0.00","","LE_2","","0","5","2023-03-11 02:39:27");
INSERT INTO tbl_purchase VALUES("800","PUR110323104","","SU","15","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-03-11","","114000.00","0.00","","LE_2","","0","5","2023-03-11 04:48:33");
INSERT INTO tbl_purchase VALUES("801","PUR110323105","","SU","27","0.00","804000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","804000.00","0","","","2023-03-11","","804000.00","0.00","","LE_2","","0","5","2023-03-11 08:05:39");
INSERT INTO tbl_purchase VALUES("802","PUR120323101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-03-12","2023-03-19","0.00","0.00","","LE_2","","0","5","2023-03-12 01:27:44");
INSERT INTO tbl_purchase VALUES("803","PUR130323101","","SU","27","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2023-03-13","","133000.00","0.00","","LE_2","","0","5","2023-03-13 04:18:27");
INSERT INTO tbl_purchase VALUES("804","PUR130323102","","SU","27","0.00","121000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","121000.00","0","","","2023-03-13","","121000.00","0.00","","LE_2","","0","5","2023-03-13 07:12:28");
INSERT INTO tbl_purchase VALUES("805","PUR150323101","","SU","27","0.00","874000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","874000.00","0","","","2023-03-15","","874000.00","0.00","","LE_2","","0","5","2023-03-15 06:40:40");
INSERT INTO tbl_purchase VALUES("806","PUR180323101","","SU","10","0.00","144000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","144000.00","0","","","2023-03-18","","144000.00","0.00","","LE_2","","0","5","2023-03-18 06:41:33");
INSERT INTO tbl_purchase VALUES("807","PUR180323102","","SU","27","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-03-18","","114000.00","0.00","","LE_2","","0","5","2023-03-18 06:43:35");
INSERT INTO tbl_purchase VALUES("808","PUR180323103","","SU","27","0.00","228000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228000.00","0","","","2023-03-18","","228000.00","0.00","","LE_2","","0","5","2023-03-18 07:47:22");
INSERT INTO tbl_purchase VALUES("809","PUR190323101","","SU","27","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2023-03-19","","133000.00","0.00","","LE_2","","0","5","2023-03-19 01:07:02");
INSERT INTO tbl_purchase VALUES("810","PUR190323102","","SU","27","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2023-03-19","","10000.00","0.00","","LE_2","","0","5","2023-03-19 02:45:08");
INSERT INTO tbl_purchase VALUES("811","PUR200323101","","SU","27","0.00","266000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266000.00","0","","","2023-03-20","","266000.00","0.00","","LE_2","","0","5","2023-03-20 06:14:29");
INSERT INTO tbl_purchase VALUES("812","PUR220323101","","SU","27","0.00","2100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2100000.00","0","","","2023-01-11","2023-03-29","0.00","0.00","","LE_2","","0","5","2023-03-22 10:59:04");
INSERT INTO tbl_purchase VALUES("813","PUR220323102","","SU","27","0.00","5400000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5400000.00","0","","","2023-02-02","2023-03-29","0.00","0.00","","LE_2","","0","5","2023-03-22 11:07:58");
INSERT INTO tbl_purchase VALUES("814","PUR220323103","","SU","1","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2023-01-21","2023-03-29","0.00","0.00","","LE_2","","0","5","2023-03-22 11:14:53");
INSERT INTO tbl_purchase VALUES("815","PUR220323104","","SU","10","0.00","2000000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2000000.00","0","","","2023-02-12","2023-03-29","0.00","0.00","","LE_2","","0","5","2023-03-22 11:13:10");
INSERT INTO tbl_purchase VALUES("816","PUR220323105","","SU","24","0.00","2875000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2875000.00","0","","","2023-02-26","","2875000.00","0.00","","LE_2","","0","5","2023-03-22 11:19:10");
INSERT INTO tbl_purchase VALUES("817","PUR220323106","","SU","27","0.00","570000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","570000.00","0","","","2023-03-22","","570000.00","0.00","","LE_2","","0","5","2023-03-22 06:03:44");
INSERT INTO tbl_purchase VALUES("818","PUR240323101","","SU","27","0.00","494000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","494000.00","0","","","2023-03-24","","494000.00","0.00","","LE_2","","0","5","2023-03-24 11:55:41");
INSERT INTO tbl_purchase VALUES("819","PUR240323102","","SU","27","0.00","183500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","183500.00","0","","","2023-03-24","","183500.00","0.00","","LE_2","","0","5","2023-03-24 12:04:31");
INSERT INTO tbl_purchase VALUES("820","PUR270323101","","SU","27","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2023-03-27","","78000.00","0.00","","LE_2","","0","5","2023-03-27 11:04:25");
INSERT INTO tbl_purchase VALUES("821","PUR300323101","","SU","27","0.00","128000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128000.00","0","","","2023-03-30","","128000.00","0.00","","LE_2","","0","5","2023-03-30 02:29:43");
INSERT INTO tbl_purchase VALUES("822","PUR010423101","","SU","27","0.00","673000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","673000.00","0","","","2023-04-01","","673000.00","0.00","","LE_2","","0","5","2023-04-01 07:20:08");
INSERT INTO tbl_purchase VALUES("823","PUR010423102","","SU","27","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2023-04-01","","30000.00","0.00","","LE_2","","0","5","2023-04-01 07:22:40");
INSERT INTO tbl_purchase VALUES("824","PUR020423101","","SU","27","0.00","247000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","247000.00","0","","","2023-04-02","","247000.00","0.00","","LE_2","","0","5","2023-04-02 11:25:03");
INSERT INTO tbl_purchase VALUES("825","PUR020423102","","SU","27","0.00","658000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","658000.00","0","","","2023-04-02","","658000.00","0.00","","LE_2","","0","5","2023-04-02 03:23:35");
INSERT INTO tbl_purchase VALUES("826","PUR030423101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-04-03","","19000.00","0.00","","LE_2","","0","5","2023-04-03 11:02:41");
INSERT INTO tbl_purchase VALUES("827","PUR030423102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-04-03","2023-04-10","0.00","0.00","","LE_2","","0","5","2023-04-03 12:09:56");
INSERT INTO tbl_purchase VALUES("828","PUR030423103","","SU","27","0.00","52750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52750.00","0","","","2023-04-03","","52750.00","0.00","","LE_2","","0","5","2023-04-03 12:40:01");
INSERT INTO tbl_purchase VALUES("829","PUR040423101","","SU","10","0.00","397000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","397000.00","0","","","2023-04-04","","397000.00","0.00","","LE_2","","0","5","2023-04-04 11:17:27");
INSERT INTO tbl_purchase VALUES("830","PUR050423101","","SU","27","0.00","208000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","208000.00","0","","","2023-04-05","","208000.00","0.00","","LE_2","","0","5","2023-04-05 07:43:51");
INSERT INTO tbl_purchase VALUES("831","PUR090423101","","SU","27","0.00","210000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","210000.00","0","","","2023-04-09","","210000.00","0.00","","LE_2","","0","5","2023-04-09 11:07:30");
INSERT INTO tbl_purchase VALUES("832","PUR130423101","","SU","42","0.00","259000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","259000.00","0","","","2023-04-13","","259000.00","0.00","","LE_2","","0","5","2023-04-13 09:59:22");
INSERT INTO tbl_purchase VALUES("833","PUR130423102","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-04-13","","19000.00","0.00","","LE_2","","0","5","2023-04-13 10:02:29");
INSERT INTO tbl_purchase VALUES("834","PUR140423101","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-04-14","","26000.00","0.00","","LE_2","","0","5","2023-04-14 10:11:14");
INSERT INTO tbl_purchase VALUES("835","PUR150423101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-04-15","","19000.00","0.00","","LE_2","","0","5","2023-04-15 10:56:31");
INSERT INTO tbl_purchase VALUES("836","PUR150423102","","SU","27","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2023-04-15","","30000.00","0.00","","LE_2","","0","5","2023-04-15 10:59:42");
INSERT INTO tbl_purchase VALUES("837","PUR150423103","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2023-04-15","","12500.00","0.00","","LE_2","","0","5","2023-04-15 03:32:58");
INSERT INTO tbl_purchase VALUES("838","PUR160423101","","SU","27","0.00","94500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","94500.00","0","","","2023-04-16","","94500.00","0.00","","LE_2","","0","5","2023-04-16 10:50:44");
INSERT INTO tbl_purchase VALUES("839","PUR180423101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-04-18","","19000.00","0.00","","LE_2","","0","5","2023-04-18 11:14:32");
INSERT INTO tbl_purchase VALUES("840","PUR300423101","","SU","42","0.00","445000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","445000.00","0","","","2023-04-30","","445000.00","0.00","","LE_2","","0","5","2023-04-30 07:07:16");
INSERT INTO tbl_purchase VALUES("841","PUR300423102","","SU","42","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-04-30","","38000.00","0.00","","LE_2","","0","5","2023-04-30 07:11:51");
INSERT INTO tbl_purchase VALUES("842","PUR040523101","","SU","27","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2023-05-04","","10000.00","0.00","","LE_2","","0","5","2023-05-04 08:07:05");
INSERT INTO tbl_purchase VALUES("843","PUR050523101","","SU","42","0.00","220000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220000.00","0","","","2023-05-05","","220000.00","0.00","","LE_2","","0","5","2023-05-05 04:10:53");
INSERT INTO tbl_purchase VALUES("844","PUR060523101","","SU","1","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2023-05-06","","65000.00","0.00","","LE_2","","0","5","2023-05-06 12:38:17");
INSERT INTO tbl_purchase VALUES("845","PUR060523102","","SU","43","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-05-06","","19000.00","0.00","","LE_2","","0","5","2023-05-06 07:42:32");
INSERT INTO tbl_purchase VALUES("846","PUR070523101","","SU","1","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2023-05-07","","18000.00","0.00","","LE_2","","0","5","2023-05-07 12:49:53");
INSERT INTO tbl_purchase VALUES("847","PUR070523102","","SU","1","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2023-05-07","","21500.00","0.00","","LE_2","","0","5","2023-05-07 01:27:23");
INSERT INTO tbl_purchase VALUES("848","PUR070523103","","SU","44","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-05-07","","57000.00","0.00","","LE_2","","0","5","2023-05-07 03:12:17");
INSERT INTO tbl_purchase VALUES("849","PUR070523104","","SU","1","0.00","14000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14000.00","0","","","2023-05-07","","14000.00","0.00","","LE_2","","0","5","2023-05-07 03:40:11");
INSERT INTO tbl_purchase VALUES("850","PUR070523105","","SU","1","0.00","39500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39500.00","0","","","2023-05-07","","39500.00","0.00","","LE_2","","0","5","2023-05-07 03:56:21");
INSERT INTO tbl_purchase VALUES("852","PUR080523101","","SU","43","0.00","285000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285000.00","0","","","2023-05-08","2023-05-15","0.00","0.00","","LE_2","","0","5","2023-05-08 03:51:55");
INSERT INTO tbl_purchase VALUES("853","PUR080523102","","SU","1","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-05-08","","28000.00","0.00","","LE_2","","0","5","2023-05-08 06:32:59");
INSERT INTO tbl_purchase VALUES("854","PUR080523103","","SU","42","0.00","91000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91000.00","0","","","2023-05-08","","91000.00","0.00","","LE_2","","0","5","2023-05-08 07:32:09");
INSERT INTO tbl_purchase VALUES("855","PUR100523101","","SU","46","0.00","102500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","102500.00","0","","","2023-05-10","2023-05-17","0.00","0.00","","LE_2","","0","5","2023-05-10 06:42:00");
INSERT INTO tbl_purchase VALUES("856","PUR100523102","","SU","43","0.00","190000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190000.00","0","","","2023-05-10","","190000.00","0.00","","LE_2","","0","5","2023-05-10 08:10:54");
INSERT INTO tbl_purchase VALUES("857","PUR110523101","","SU","1","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2023-05-11","","36000.00","0.00","","LE_2","","0","5","2023-05-11 12:30:23");
INSERT INTO tbl_purchase VALUES("858","PUR110523102","","SU","44","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-05-11","","57000.00","0.00","","LE_2","","0","5","2023-05-12 01:05:46");
INSERT INTO tbl_purchase VALUES("859","PUR110523103","","SU","41","0.00","2900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2900.00","0","","","2023-05-11","","2900.00","0.00","","LE_2","","0","5","2023-05-11 06:41:53");
INSERT INTO tbl_purchase VALUES("860","PUR110523104","","SU","42","0.00","125000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125000.00","0","","","2023-05-11","","125000.00","0.00","","LE_2","","0","5","2023-05-11 07:22:24");
INSERT INTO tbl_purchase VALUES("861","PUR120523101","","SU","44","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2023-05-12","","95000.00","0.00","","LE_2","","0","5","2023-05-12 03:21:11");
INSERT INTO tbl_purchase VALUES("862","PUR120523102","","SU","44","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-05-12","","19000.00","0.00","","LE_2","","0","5","2023-05-12 06:37:14");
INSERT INTO tbl_purchase VALUES("863","PUR150523101","","SU","43","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2023-05-15","","133000.00","0.00","","LE_2","","0","5","2023-05-15 02:02:40");
INSERT INTO tbl_purchase VALUES("864","PUR150523102","","SU","44","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-05-15","","76000.00","0.00","","LE_2","","0","5","2023-05-15 05:55:16");
INSERT INTO tbl_purchase VALUES("865","PUR150523103","","SU","42","0.00","257000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","257000.00","0","","","2023-05-15","","257000.00","0.00","","LE_2","","0","5","2023-05-15 06:11:32");
INSERT INTO tbl_purchase VALUES("866","PUR180523101","","SU","44","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-05-18","","76000.00","0.00","","LE_2","","0","5","2023-05-18 05:04:51");
INSERT INTO tbl_purchase VALUES("867","PUR180523102","","SU","42","0.00","152000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152000.00","0","","","2023-05-18","","152000.00","0.00","","LE_2","","0","5","2023-05-18 05:13:13");
INSERT INTO tbl_purchase VALUES("868","PUR190523101","","SU","1","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-05-19","","56000.00","0.00","","LE_2","","0","5","2023-05-19 11:14:58");
INSERT INTO tbl_purchase VALUES("869","PUR190523102","","SU","43","0.00","266000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266000.00","0","","","2023-05-19","","266000.00","0.00","","LE_2","","0","5","2023-05-19 02:31:17");
INSERT INTO tbl_purchase VALUES("870","PUR190523103","","SU","44","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-05-19","","57000.00","0.00","","LE_2","","0","5","2023-05-19 07:50:50");
INSERT INTO tbl_purchase VALUES("871","PUR210523101","","SU","44","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-05-21","","76000.00","0.00","","LE_2","","0","5","2023-05-21 06:26:04");
INSERT INTO tbl_purchase VALUES("872","PUR210523102","","SU","42","0.00","112000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112000.00","0","","","2023-05-21","","112000.00","0.00","","LE_2","","0","5","2023-05-21 06:31:51");
INSERT INTO tbl_purchase VALUES("873","PUR240523101","","SU","43","0.00","266000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266000.00","0","","","2023-05-24","","266000.00","0.00","","LE_2","","0","5","2023-05-24 07:52:23");
INSERT INTO tbl_purchase VALUES("874","PUR240523102","","SU","42","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2023-05-24","","130000.00","0.00","","LE_2","","0","5","2023-05-24 07:56:29");
INSERT INTO tbl_purchase VALUES("875","PUR250523101","","SU","44","0.00","343000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","343000.00","0","","","2023-05-25","","343000.00","0.00","","LE_2","","0","5","2023-05-25 04:58:02");
INSERT INTO tbl_purchase VALUES("876","PUR250523102","","SU","47","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-05-25","2023-06-01","0.00","0.00","","LE_2","","0","5","2023-05-25 05:35:11");
INSERT INTO tbl_purchase VALUES("877","PUR260523101","","SU","48","0.00","223500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","223500.00","0","","","2023-05-26","","223500.00","0.00","","LE_2","","0","5","2023-05-26 05:36:26");
INSERT INTO tbl_purchase VALUES("878","PUR270523101","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-05-27","","19000.00","0.00","","LE_2","","0","5","2023-05-27 02:07:58");
INSERT INTO tbl_purchase VALUES("879","PUR270523102","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-05-27","","19000.00","0.00","","LE_2","","0","5","2023-05-27 03:03:44");
INSERT INTO tbl_purchase VALUES("880","PUR270523103","","SU","48","0.00","374500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","374500.00","0","","","2023-05-27","","374500.00","0.00","","LE_2","","0","5","2023-05-27 03:43:08");
INSERT INTO tbl_purchase VALUES("881","PUR270523104","","SU","47","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-05-27","","28000.00","0.00","","LE_2","","0","5","2023-05-27 03:58:25");
INSERT INTO tbl_purchase VALUES("882","PUR270523105","","SU","44","0.00","46000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46000.00","0","","","2023-05-27","","46000.00","0.00","","LE_2","","0","5","2023-05-27 06:50:09");
INSERT INTO tbl_purchase VALUES("883","PUR270523106","","SU","47","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-05-27","","26000.00","0.00","","LE_2","","0","5","2023-05-27 06:50:52");
INSERT INTO tbl_purchase VALUES("884","PUR280523101","","SU","42","0.00","342000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","342000.00","0","","","2023-05-28","","342000.00","0.00","","LE_2","","0","5","2023-05-28 06:46:19");
INSERT INTO tbl_purchase VALUES("885","PUR280523102","","SU","48","0.00","122500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","122500.00","0","","","2023-05-28","","122500.00","0.00","","LE_2","","0","5","2023-05-28 07:06:35");
INSERT INTO tbl_purchase VALUES("886","PUR290523101","","SU","44","0.00","483000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","483000.00","0","","","2023-05-29","","483000.00","0.00","","LE_2","","0","5","2023-05-29 06:03:31");
INSERT INTO tbl_purchase VALUES("887","PUR290523102","","SU","43","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2023-05-29","","95000.00","0.00","","LE_2","","0","5","2023-05-29 06:22:41");
INSERT INTO tbl_purchase VALUES("888","PUR290523103","","SU","42","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-05-29","","76000.00","0.00","","LE_2","","0","5","2023-05-29 08:01:39");
INSERT INTO tbl_purchase VALUES("889","PUR310523101","","SU","44","0.00","483000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","483000.00","0","","","2023-05-31","","483000.00","0.00","","LE_2","","0","5","2023-05-31 04:15:23");
INSERT INTO tbl_purchase VALUES("890","PUR310523102","","SU","47","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-05-31","","26000.00","0.00","","LE_2","","0","5","2023-05-31 05:52:31");
INSERT INTO tbl_purchase VALUES("891","PUR310523103","","SU","48","0.00","77000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77000.00","0","","","2023-05-31","","77000.00","0.00","","LE_2","","0","5","2023-05-31 06:21:17");
INSERT INTO tbl_purchase VALUES("892","PUR010623101","","SU","48","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2023-06-01","","78000.00","0.00","","LE_2","","0","5","2023-06-01 05:34:02");
INSERT INTO tbl_purchase VALUES("893","PUR010623102","","SU","48","0.00","1214000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1214000.00","0","","","2023-06-01","","1214000.00","0.00","","LE_2","","0","5","2023-06-01 07:46:48");
INSERT INTO tbl_purchase VALUES("894","PUR010623103","","SU","43","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-06-01","","57000.00","0.00","","LE_2","","0","5","2023-06-01 07:50:29");
INSERT INTO tbl_purchase VALUES("895","PUR010623104","","SU","1","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2023-06-01","","42000.00","0.00","","LE_2","","0","5","2023-06-01 08:02:02");
INSERT INTO tbl_purchase VALUES("896","PUR030623101","","SU","1","0.00","69000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69000.00","0","","","2023-06-03","","69000.00","0.00","","LE_2","","0","5","2023-06-03 11:12:56");
INSERT INTO tbl_purchase VALUES("897","PUR030623102","","SU","49","0.00","202000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","202000.00","0","","","2023-06-03","","202000.00","0.00","","LE_2","","0","5","2023-06-03 04:20:25");
INSERT INTO tbl_purchase VALUES("898","PUR040623101","","SU","44","0.00","79000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","79000.00","0","","","2023-06-04","","79000.00","0.00","","LE_2","","0","5","2023-06-04 09:30:20");
INSERT INTO tbl_purchase VALUES("899","PUR040623102","","SU","49","0.00","919500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","919500.00","0","","","2023-06-04","","919500.00","0.00","","LE_2","","0","5","2023-06-04 09:52:14");
INSERT INTO tbl_purchase VALUES("900","PUR040623103","","SU","50","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2023-06-04","","130000.00","0.00","","LE_2","","0","5","2023-06-04 09:55:40");
INSERT INTO tbl_purchase VALUES("901","PUR040623104","","SU","43","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-06-04","","19000.00","0.00","","LE_2","","0","5","2023-06-04 10:11:14");
INSERT INTO tbl_purchase VALUES("902","PUR050623101","","SU","49","0.00","171000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171000.00","0","","","2023-06-05","","171000.00","0.00","","LE_2","","0","5","2023-06-05 05:09:57");
INSERT INTO tbl_purchase VALUES("903","PUR050623102","","SU","50","0.00","260000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","260000.00","0","","","2023-06-05","","260000.00","0.00","","LE_2","","0","5","2023-06-05 05:39:22");
INSERT INTO tbl_purchase VALUES("904","PUR070623101","","SU","47","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-06-07","2023-06-14","0.00","0.00","","LE_2","","0","5","2023-06-07 04:09:31");
INSERT INTO tbl_purchase VALUES("905","PUR070623102","","SU","49","0.00","266000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266000.00","0","","","2023-06-07","","266000.00","0.00","","LE_2","","0","5","2023-06-07 04:25:54");
INSERT INTO tbl_purchase VALUES("906","PUR070623103","","SU","47","0.00","416000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","416000.00","0","","","2023-06-07","","416000.00","0.00","","LE_2","","0","5","2023-06-07 07:42:10");
INSERT INTO tbl_purchase VALUES("907","PUR070623104","","SU","43","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-06-07","","19000.00","0.00","","LE_2","","0","5","2023-06-07 05:02:07");
INSERT INTO tbl_purchase VALUES("908","PUR070623105","","SU","50","0.00","224000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","224000.00","0","","","2023-06-07","","224000.00","0.00","","LE_2","","0","5","2023-06-07 05:18:19");
INSERT INTO tbl_purchase VALUES("909","PUR070623106","","SU","44","0.00","230000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","230000.00","0","","","2023-06-07","","230000.00","0.00","","LE_2","","0","5","2023-06-07 08:01:52");
INSERT INTO tbl_purchase VALUES("910","PUR080623101","","SU","43","0.00","190000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190000.00","0","","","2023-06-08","","190000.00","0.00","","LE_2","","0","5","2023-06-08 12:03:06");
INSERT INTO tbl_purchase VALUES("911","PUR080623102","","SU","47","0.00","448000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","448000.00","0","","","2023-06-08","","448000.00","0.00","","LE_2","","0","5","2023-06-08 04:09:28");
INSERT INTO tbl_purchase VALUES("912","PUR080623103","","SU","42","0.00","333000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","333000.00","0","","","2023-06-08","","333000.00","0.00","","LE_2","","0","5","2023-06-08 06:26:39");
INSERT INTO tbl_purchase VALUES("913","PUR080623104","","SU","49","0.00","302000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","302000.00","0","","","2023-06-08","","302000.00","0.00","","LE_2","","0","5","2023-06-08 06:43:42");
INSERT INTO tbl_purchase VALUES("914","PUR090623101","","SU","50","0.00","312000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","312000.00","0","","","2023-06-09","","312000.00","0.00","","LE_2","","0","5","2023-06-09 01:11:07");
INSERT INTO tbl_purchase VALUES("915","PUR100623101","","SU","49","0.00","171000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171000.00","0","","","2023-06-10","","171000.00","0.00","","LE_2","","0","5","2023-06-10 04:23:05");
INSERT INTO tbl_purchase VALUES("916","PUR110623101","","SU","50","0.00","405500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","405500.00","0","","","2023-06-11","","405500.00","0.00","","LE_2","","0","5","2023-06-11 04:54:01");
INSERT INTO tbl_purchase VALUES("917","PUR120623101","","SU","47","0.00","389000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","389000.00","0","","","2023-06-12","","389000.00","0.00","","LE_2","","0","5","2023-06-12 02:03:28");
INSERT INTO tbl_purchase VALUES("918","PUR120623102","","SU","42","0.00","665000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","665000.00","0","","","2023-06-12","","665000.00","0.00","","LE_2","","0","5","2023-06-12 03:08:52");
INSERT INTO tbl_purchase VALUES("919","PUR120623103","","SU","43","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-06-12","","57000.00","0.00","","LE_2","","0","5","2023-06-12 06:11:52");
INSERT INTO tbl_purchase VALUES("920","PUR120623104","","SU","50","0.00","278500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","278500.00","0","","","2023-06-12","","278500.00","0.00","","LE_2","","0","5","2023-06-12 06:32:13");
INSERT INTO tbl_purchase VALUES("921","PUR140623101","","SU","43","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-06-14","","19000.00","0.00","","LE_2","","0","5","2023-06-14 11:08:02");
INSERT INTO tbl_purchase VALUES("922","PUR150623101","","SU","42","0.00","759000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","759000.00","0","","","2023-06-15","","759000.00","0.00","","LE_2","","0","5","2023-06-15 02:02:18");
INSERT INTO tbl_purchase VALUES("923","PUR150623102","","SU","50","0.00","202000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","202000.00","0","","","2023-06-15","","202000.00","0.00","","LE_2","","0","5","2023-06-15 02:17:11");
INSERT INTO tbl_purchase VALUES("924","PUR150623103","","SU","44","0.00","160500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","160500.00","0","","","2023-06-15","","160500.00","0.00","","LE_2","","0","5","2023-06-15 02:34:33");
INSERT INTO tbl_purchase VALUES("925","PUR170623101","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-06-17","2023-06-24","0.00","0.00","","LE_2","","0","5","2023-06-17 11:45:29");
INSERT INTO tbl_purchase VALUES("926","PUR170623102","","SU","50","0.00","358000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","358000.00","0","","","2023-06-17","","358000.00","0.00","","LE_2","","0","5","2023-06-17 04:11:22");
INSERT INTO tbl_purchase VALUES("927","PUR180623101","","SU","42","0.00","390500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","390500.00","0","","","2023-06-18","","390500.00","0.00","","LE_2","","0","5","2023-06-18 04:52:53");
INSERT INTO tbl_purchase VALUES("928","PUR180623102","","SU","50","0.00","156000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","156000.00","0","","","2023-06-18","","156000.00","0.00","","LE_2","","0","5","2023-06-18 07:00:53");
INSERT INTO tbl_purchase VALUES("929","PUR190623101","","SU","47","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-06-19","","28000.00","0.00","","LE_2","","0","5","2023-06-19 12:54:10");
INSERT INTO tbl_purchase VALUES("930","PUR190623102","","SU","44","0.00","261000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","261000.00","0","","","2023-06-19","","261000.00","0.00","","LE_2","","0","5","2023-06-19 04:14:52");
INSERT INTO tbl_purchase VALUES("931","PUR210623101","","SU","44","0.00","170000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","170000.00","0","","","2023-06-21","","170000.00","0.00","","LE_2","","0","5","2023-06-21 01:13:51");
INSERT INTO tbl_purchase VALUES("932","PUR210623102","","SU","1","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-06-21","","57000.00","0.00","","LE_2","","0","5","2023-06-21 01:19:35");
INSERT INTO tbl_purchase VALUES("933","PUR220623101","","SU","50","0.00","71000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","71000.00","0","","","2023-06-22","2023-06-29","0.00","0.00","","LE_2","","0","5","2023-06-22 03:58:42");
INSERT INTO tbl_purchase VALUES("934","PUR220623102","","SU","50","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2023-06-22","2023-06-29","0.00","0.00","","LE_2","","0","5","2023-06-22 04:33:16");
INSERT INTO tbl_purchase VALUES("935","PUR230623101","","SU","50","0.00","71000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","71000.00","0","","","2023-06-23","2023-06-30","0.00","0.00","","LE_2","","0","5","2023-06-23 04:43:12");
INSERT INTO tbl_purchase VALUES("936","PUR230623102","","SU","50","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2023-06-23","2023-06-30","0.00","0.00","","LE_2","","0","5","2023-06-23 06:45:01");
INSERT INTO tbl_purchase VALUES("937","PUR240623101","","SU","44","0.00","197500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197500.00","0","","","2023-06-24","","197500.00","0.00","","LE_2","","0","5","2023-06-24 04:46:27");
INSERT INTO tbl_purchase VALUES("938","PUR240623102","","SU","42","0.00","147000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","147000.00","0","","","2023-06-24","","147000.00","0.00","","LE_2","","0","5","2023-06-24 06:58:13");
INSERT INTO tbl_purchase VALUES("939","PUR250623101","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-06-25","","19000.00","0.00","","LE_2","","0","5","2023-06-25 04:10:58");
INSERT INTO tbl_purchase VALUES("940","PUR260623101","","SU","50","0.00","364500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","364500.00","0","","","2023-06-26","","364500.00","0.00","","LE_2","","0","5","2023-06-26 12:35:58");
INSERT INTO tbl_purchase VALUES("941","PUR060723101","","SU","50","0.00","798000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","798000.00","0","","","2023-07-06","","798000.00","0.00","","LE_2","","0","5","2023-07-06 01:04:14");
INSERT INTO tbl_purchase VALUES("942","PUR060723102","","SU","50","0.00","572000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","572000.00","0","","","2023-07-06","","572000.00","0.00","","LE_2","","0","5","2023-07-06 01:21:44");
INSERT INTO tbl_purchase VALUES("943","PUR060723103","","SU","44","0.00","88500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88500.00","0","","","2023-07-06","","88500.00","0.00","","LE_2","","0","5","2023-07-06 04:51:46");
INSERT INTO tbl_purchase VALUES("944","PUR060723104","","SU","42","0.00","924000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","924000.00","0","","","2023-07-06","","924000.00","0.00","","LE_2","","0","5","2023-07-06 05:13:02");
INSERT INTO tbl_purchase VALUES("945","PUR060723105","","SU","50","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2023-07-06","","133000.00","0.00","","LE_2","","0","5","2023-07-06 05:16:22");
INSERT INTO tbl_purchase VALUES("946","PUR070723101","","SU","50","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-07-07","","19000.00","0.00","","LE_2","","0","5","2023-07-07 04:10:39");
INSERT INTO tbl_purchase VALUES("947","PUR080723101","","SU","51","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2023-07-08","","48000.00","0.00","","LE_2","","0","5","2023-07-08 07:05:37");
INSERT INTO tbl_purchase VALUES("948","PUR090723101","","SU","50","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-07-09","","38000.00","0.00","","LE_2","","0","5","2023-07-09 11:24:02");
INSERT INTO tbl_purchase VALUES("949","PUR090723102","","SU","1","0.00","43000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43000.00","0","","","2023-07-09","","43000.00","0.00","","LE_2","","0","5","2023-07-09 07:09:34");
INSERT INTO tbl_purchase VALUES("950","PUR100723101","","SU","42","0.00","673000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","673000.00","0","","","2023-07-10","","673000.00","0.00","","LE_2","","0","5","2023-07-10 10:45:53");
INSERT INTO tbl_purchase VALUES("951","PUR100723102","","SU","1","0.00","1100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1100000.00","0","","","2023-05-03","","1100000.00","0.00","","LE_2","","0","5","2023-07-10 12:18:31");
INSERT INTO tbl_purchase VALUES("952","PUR100723103","","SU","1","0.00","1200000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1200000.00","0","","","2023-05-27","","1200000.00","0.00","","LE_2","","0","5","2023-07-10 12:22:55");
INSERT INTO tbl_purchase VALUES("953","PUR100723104","","SU","1","0.00","930000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","930000.00","0","","","2023-06-12","2023-07-17","0.00","0.00","","LE_2","","0","5","2023-07-10 12:33:00");
INSERT INTO tbl_purchase VALUES("954","PUR100723105","","SU","1","0.00","855000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","855000.00","0","","","2023-06-18","","855000.00","0.00","","LE_2","","0","5","2023-07-10 12:39:04");
INSERT INTO tbl_purchase VALUES("955","PUR100723106","","SU","51","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2023-07-10","","36000.00","0.00","","LE_2","","0","5","2023-07-10 03:28:14");
INSERT INTO tbl_purchase VALUES("956","PUR100723107","","SU","51","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-07-10","","38000.00","0.00","","LE_2","","0","5","2023-07-10 07:54:41");
INSERT INTO tbl_purchase VALUES("957","PUR120723101","","SU","50","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-07-12","","76000.00","0.00","","LE_2","","0","5","2023-07-12 01:26:57");
INSERT INTO tbl_purchase VALUES("958","PUR130723101","","SU","27","0.00","19500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19500.00","0","","","2023-07-13","2023-07-20","0.00","0.00","","LE_2","","0","5","2023-07-13 12:25:34");
INSERT INTO tbl_purchase VALUES("959","PUR130723102","","SU","42","0.00","327500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","327500.00","0","","","2023-07-13","","327500.00","0.00","","LE_2","","0","5","2023-07-13 04:49:21");
INSERT INTO tbl_purchase VALUES("960","PUR130723103","","SU","42","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2023-07-13","","16500.00","0.00","","LE_2","","0","5","2023-07-13 05:21:27");
INSERT INTO tbl_purchase VALUES("961","PUR130723104","","SU","27","0.00","86000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86000.00","0","","","2023-07-13","","86000.00","0.00","","LE_2","","0","5","2023-07-13 06:56:50");
INSERT INTO tbl_purchase VALUES("962","PUR130723105","","SU","42","0.00","159500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159500.00","0","","","2023-07-13","","159500.00","0.00","","LE_2","","0","5","2023-07-13 07:11:25");
INSERT INTO tbl_purchase VALUES("963","PUR150723101","","SU","51","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2023-07-15","","18000.00","0.00","","LE_2","","0","5","2023-07-15 11:06:00");
INSERT INTO tbl_purchase VALUES("964","PUR160723101","","SU","47","0.00","409000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","409000.00","0","","","2023-07-16","","409000.00","0.00","","LE_2","","0","5","2023-07-16 05:18:44");
INSERT INTO tbl_purchase VALUES("965","PUR170723101","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2023-07-17","","20000.00","0.00","","LE_2","","0","5","2023-07-17 11:04:36");
INSERT INTO tbl_purchase VALUES("966","PUR200723101","","SU","49","0.00","896000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","896000.00","0","","","2023-07-20","","896000.00","0.00","","LE_2","","0","5","2023-07-20 05:44:30");
INSERT INTO tbl_purchase VALUES("967","PUR220723101","","SU","27","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-07-22","","23000.00","0.00","","LE_2","","0","5","2023-07-22 12:57:38");
INSERT INTO tbl_purchase VALUES("968","PUR270723101","","SU","42","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2023-07-27","","76000.00","0.00","","LE_2","","0","5","2023-07-27 05:30:21");
INSERT INTO tbl_purchase VALUES("969","PUR270723102","","SU","42","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-07-27","","38000.00","0.00","","LE_2","","0","5","2023-07-27 05:53:07");
INSERT INTO tbl_purchase VALUES("970","PUR270723103","","SU","42","0.00","209000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","209000.00","0","","","2023-07-27","2023-08-03","0.00","0.00","","LE_2","","0","5","2023-07-27 06:30:36");
INSERT INTO tbl_purchase VALUES("971","PUR280723101","","SU","51","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2023-07-28","","75000.00","0.00","","LE_2","","0","5","2023-07-28 01:09:02");
INSERT INTO tbl_purchase VALUES("972","PUR280723102","","SU","1","0.00","20500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20500.00","0","","","2023-07-28","","20500.00","0.00","","LE_2","","0","5","2023-07-28 06:31:09");
INSERT INTO tbl_purchase VALUES("973","PUR280723103","","SU","1","0.00","20500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20500.00","0","","","2023-07-28","","20500.00","0.00","","LE_2","","0","5","2023-07-28 06:37:38");
INSERT INTO tbl_purchase VALUES("974","PUR290723101","","SU","42","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-07-29","","57000.00","0.00","","LE_2","","0","5","2023-07-29 12:53:28");
INSERT INTO tbl_purchase VALUES("975","PUR290723102","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-07-29","","23000.00","0.00","","LE_2","","0","5","2023-07-29 01:02:30");
INSERT INTO tbl_purchase VALUES("976","PUR310723101","","SU","42","0.00","513000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","513000.00","0","","","2023-07-31","","513000.00","0.00","","LE_2","","0","5","2023-07-31 01:02:58");
INSERT INTO tbl_purchase VALUES("977","PUR310723102","","SU","42","0.00","188000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","188000.00","0","","","2023-07-31","","188000.00","0.00","","LE_2","","0","5","2023-07-31 07:30:20");
INSERT INTO tbl_purchase VALUES("978","PUR020823101","","SU","42","0.00","222000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","222000.00","0","","","2023-08-02","","222000.00","0.00","","LE_2","","0","5","2023-08-02 06:56:44");
INSERT INTO tbl_purchase VALUES("979","PUR040823101","","SU","42","0.00","226500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","226500.00","0","","","2023-08-04","","226500.00","0.00","","LE_2","","0","5","2023-08-04 12:22:42");
INSERT INTO tbl_purchase VALUES("980","PUR040823102","","SU","1","0.00","4675000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4675000.00","0","","","2023-08-04","","4675500.00","500.00","","LE_2","","0","5","2023-08-04 02:05:21");
INSERT INTO tbl_purchase VALUES("981","PUR050823101","","SU","42","0.00","85000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85000.00","0","","","2023-08-05","","85000.00","0.00","","LE_2","","0","5","2023-08-05 06:59:23");
INSERT INTO tbl_purchase VALUES("982","PUR060823101","","SU","27","0.00","58500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58500.00","0","","","2023-08-06","","58500.00","0.00","","LE_2","","0","5","2023-08-06 01:19:33");
INSERT INTO tbl_purchase VALUES("983","PUR060823102","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-08-06","","28000.00","0.00","","LE_2","","0","5","2023-08-06 07:34:34");
INSERT INTO tbl_purchase VALUES("984","PUR070823101","","SU","27","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-08-07","","56000.00","0.00","","LE_2","","0","5","2023-08-07 01:19:05");
INSERT INTO tbl_purchase VALUES("985","PUR070823102","","SU","27","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-08-07","","17000.00","0.00","","LE_2","","0","5","2023-08-07 02:50:58");
INSERT INTO tbl_purchase VALUES("986","PUR070823103","","SU","42","0.00","108000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108000.00","0","","","2023-08-07","","108000.00","0.00","","LE_2","","0","5","2023-08-07 08:05:54");
INSERT INTO tbl_purchase VALUES("987","PUR100823101","","SU","42","0.00","466000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","466000.00","0","","","2023-08-10","","466000.00","0.00","","LE_2","","0","5","2023-08-10 02:58:32");
INSERT INTO tbl_purchase VALUES("988","PUR110823101","","SU","27","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-08-11","","17000.00","0.00","","LE_2","","0","5","2023-08-11 04:50:23");
INSERT INTO tbl_purchase VALUES("989","PUR120823101","","SU","42","0.00","106500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106500.00","0","","","2023-08-12","","106500.00","0.00","","LE_2","","0","5","2023-08-12 05:42:23");
INSERT INTO tbl_purchase VALUES("990","PUR120823102","","SU","53","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2023-08-12","2023-08-19","0.00","0.00","","LE_2","","0","5","2023-08-12 07:12:42");
INSERT INTO tbl_purchase VALUES("991","PUR120823103","","SU","53","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2023-08-12","2023-08-19","0.00","0.00","","LE_2","","0","5","2023-08-12 07:16:36");
INSERT INTO tbl_purchase VALUES("992","PUR120823104","","SU","53","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2023-08-12","2023-08-19","0.00","0.00","","LE_2","","0","5","2023-08-12 07:30:23");
INSERT INTO tbl_purchase VALUES("993","PUR120823105","","SU","53","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2023-08-12","2023-08-19","0.00","0.00","","LE_2","","0","5","2023-08-12 08:17:29");
INSERT INTO tbl_purchase VALUES("994","PUR130823101","","SU","53","0.00","2088000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2088000.00","0","","","2023-08-13","2023-08-20","0.00","0.00","","LE_2","","0","5","2023-08-13 12:36:40");
INSERT INTO tbl_purchase VALUES("995","PUR130823102","","SU","42","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-08-13","2023-08-20","0.00","0.00","","LE_2","","0","5","2023-08-13 07:34:00");
INSERT INTO tbl_purchase VALUES("996","PUR140823101","","SU","1","0.00","205500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","205500.00","0","","","2023-08-14","","205500.00","0.00","","LE_2","","0","5","2023-08-14 02:55:37");
INSERT INTO tbl_purchase VALUES("997","PUR140823102","","SU","1","0.00","118000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","118000.00","0","","","2023-08-14","","118000.00","0.00","","LE_2","","0","5","2023-08-14 03:18:23");
INSERT INTO tbl_purchase VALUES("999","PUR140823103","","SU","42","0.00","289500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","289500.00","0","","","2023-08-14","","289500.00","0.00","","LE_2","","0","5","2023-08-14 07:06:30");
INSERT INTO tbl_purchase VALUES("1000","PUR140823104","","SU","13","0.00","106000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106000.00","0","","","2023-08-14","","106000.00","0.00","","LE_2","","0","5","2023-08-14 07:10:54");
INSERT INTO tbl_purchase VALUES("1001","PUR140823105","","SU","27","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2023-08-14","2023-08-21","0.00","0.00","","LE_2","","0","5","2023-08-14 07:19:39");
INSERT INTO tbl_purchase VALUES("1002","PUR160823101","","SU","27","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2023-08-16","","12500.00","0.00","","LE_2","","0","5","2023-08-16 03:05:42");
INSERT INTO tbl_purchase VALUES("1003","PUR160823102","","SU","54","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2023-08-16","2023-08-23","0.00","0.00","","LE_2","","0","5","2023-08-16 03:59:07");
INSERT INTO tbl_purchase VALUES("1004","PUR160823103","","SU","27","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2023-08-16","2023-08-23","0.00","0.00","","LE_2","","0","5","2023-08-16 06:34:54");
INSERT INTO tbl_purchase VALUES("1005","PUR160823104","","SU","1","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-08-16","","17000.00","0.00","","LE_2","","0","5","2023-08-16 06:58:31");
INSERT INTO tbl_purchase VALUES("1006","PUR160823105","","SU","42","0.00","149500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149500.00","0","","","2023-08-16","","149500.00","0.00","","LE_2","","0","5","2023-08-16 07:10:17");
INSERT INTO tbl_purchase VALUES("1007","PUR170823101","","SU","53","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2023-08-17","2023-08-24","0.00","0.00","","LE_2","","0","5","2023-08-17 11:10:57");
INSERT INTO tbl_purchase VALUES("1008","PUR190823101","","SU","27","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-08-19","","28000.00","0.00","","LE_2","","0","5","2023-08-19 11:34:20");
INSERT INTO tbl_purchase VALUES("1009","PUR190823102","","SU","7","0.00","175500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175500.00","0","","","2023-08-19","2023-08-26","0.00","0.00","","LE_2","","0","5","2023-08-19 03:12:45");
INSERT INTO tbl_purchase VALUES("1010","PUR190823103","","SU","42","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-08-19","","19000.00","0.00","","LE_2","","0","5","2023-08-19 05:19:12");
INSERT INTO tbl_purchase VALUES("1011","PUR210823101","","SU","7","0.00","220000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220000.00","0","","","2023-08-21","2023-08-28","0.00","0.00","","LE_2","","0","5","2023-08-21 01:13:06");
INSERT INTO tbl_purchase VALUES("1012","PUR210823102","","SU","7","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-08-21","2023-08-28","0.00","0.00","","LE_2","","0","5","2023-08-21 04:53:15");
INSERT INTO tbl_purchase VALUES("1013","PUR210823103","","SU","7","0.00","263500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","263500.00","0","","","2023-08-21","2023-08-28","0.00","0.00","","LE_2","","0","5","2023-08-21 07:05:10");
INSERT INTO tbl_purchase VALUES("1015","PUR250823101","","SU","27","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-08-25","2023-09-01","0.00","0.00","","LE_2","","0","5","2023-08-25 07:08:16");
INSERT INTO tbl_purchase VALUES("1016","PUR260823101","","SU","32","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2023-08-26","","16000.00","0.00","","LE_2","","0","5","2023-08-26 04:45:09");
INSERT INTO tbl_purchase VALUES("1017","PUR270823101","","SU","7","0.00","235000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","235000.00","0","","","2023-08-27","2023-09-03","0.00","0.00","","LE_2","","0","5","2023-08-27 02:35:30");
INSERT INTO tbl_purchase VALUES("1018","PUR270823102","","SU","27","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2023-08-27","","18000.00","0.00","","LE_2","","0","5","2023-08-27 05:25:45");
INSERT INTO tbl_purchase VALUES("1019","PUR280823101","","SU","53","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-08-28","","28000.00","0.00","","LE_2","","0","5","2023-08-28 11:15:20");
INSERT INTO tbl_purchase VALUES("1020","PUR280823102","","SU","7","0.00","82500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","82500.00","0","","","2023-08-28","2023-09-04","0.00","0.00","","LE_2","","0","5","2023-08-28 05:26:15");
INSERT INTO tbl_purchase VALUES("1021","PUR280823103","","SU","27","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-08-28","","26000.00","0.00","","LE_2","","0","5","2023-08-28 03:39:54");
INSERT INTO tbl_purchase VALUES("1022","PUR280823104","","SU","55","0.00","63000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63000.00","0","","","2023-08-28","2023-09-04","0.00","0.00","","LE_2","","0","5","2023-08-28 04:21:46");
INSERT INTO tbl_purchase VALUES("1023","PUR280823105","","SU","56","0.00","190000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190000.00","0","","","2023-08-28","2023-09-04","0.00","0.00","","LE_2","","0","5","2023-08-28 04:50:38");
INSERT INTO tbl_purchase VALUES("1024","PUR280823106","","SU","42","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2023-08-28","","45000.00","0.00","","LE_2","","0","5","2023-08-28 06:32:10");
INSERT INTO tbl_purchase VALUES("1025","PUR310823101","","SU","42","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2023-08-31","","42000.00","0.00","","LE_2","","0","5","2023-08-31 07:13:15");
INSERT INTO tbl_purchase VALUES("1026","PUR160923101","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2023-09-16","","25000.00","0.00","","LE_2","","0","5","2023-09-16 01:42:13");
INSERT INTO tbl_purchase VALUES("1027","PUR180923101","","SU","57","0.00","357500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","357500.00","0","","","2023-09-18","","357500.00","0.00","","LE_2","","0","5","2023-09-18 04:16:31");
INSERT INTO tbl_purchase VALUES("1028","PUR200923101","","SU","7","0.00","296000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","296000.00","0","","","2023-09-20","2023-09-27","0.00","0.00","","LE_2","","0","5","2023-09-20 01:20:00");
INSERT INTO tbl_purchase VALUES("1029","PUR200923102","","SU","54","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-09-20","","19000.00","0.00","","LE_2","","0","5","2023-09-20 04:00:26");
INSERT INTO tbl_purchase VALUES("1030","PUR200923103","","SU","7","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-09-20","2023-09-27","0.00","0.00","","LE_2","","0","5","2023-09-20 05:33:55");
INSERT INTO tbl_purchase VALUES("1031","PUR200923104","","SU","7","0.00","64000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64000.00","0","","","2023-09-20","2023-09-27","0.00","0.00","","LE_2","","0","5","2023-09-20 06:37:42");
INSERT INTO tbl_purchase VALUES("1032","PUR210923101","","SU","15","0.00","6900000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6900000.00","0","","","2023-08-15","2023-09-28","0.00","0.00","","LE_2","","0","5","2023-09-21 12:49:36");
INSERT INTO tbl_purchase VALUES("1033","PUR210923102","","SU","15","0.00","2320000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2320000.00","0","","","2023-09-01","2023-09-28","0.00","0.00","","LE_2","","0","5","2023-09-21 12:59:31");
INSERT INTO tbl_purchase VALUES("1034","PUR210923103","","SU","15","0.00","5320000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5320000.00","0","","","2023-09-04","2023-09-28","0.00","0.00","","LE_2","","0","5","2023-09-21 12:59:56");
INSERT INTO tbl_purchase VALUES("1035","PUR210923104","","SU","15","0.00","6900000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6900000.00","0","","","2023-08-22","2023-09-28","0.00","0.00","","LE_2","","0","5","2023-09-21 01:12:06");
INSERT INTO tbl_purchase VALUES("1036","PUR210923105","","SU","46","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-09-21","2023-09-28","0.00","0.00","","LE_2","","0","5","2023-09-21 04:00:00");
INSERT INTO tbl_purchase VALUES("1037","PUR220923101","","SU","60","0.00","26500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26500.00","0","","","2023-09-22","2023-09-29","0.00","0.00","","LE_2","","0","5","2023-09-22 02:46:58");
INSERT INTO tbl_purchase VALUES("1038","PUR220923102","","SU","60","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-09-22","2023-09-29","0.00","0.00","","LE_2","","0","5","2023-09-22 03:39:13");
INSERT INTO tbl_purchase VALUES("1039","PUR230923101","","SU","57","0.00","335700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","335700.00","0","","","2023-09-23","","335700.00","0.00","","LE_2","","0","5","2023-09-23 01:12:54");
INSERT INTO tbl_purchase VALUES("1040","PUR230923102","","SU","52","0.00","152000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152000.00","0","","","2023-09-23","2023-09-30","0.00","0.00","","LE_2","","0","5","2023-09-23 01:16:34");
INSERT INTO tbl_purchase VALUES("1041","PUR230923103","","SU","52","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-09-23","2023-09-30","0.00","0.00","","LE_2","","0","5","2023-09-23 04:08:46");
INSERT INTO tbl_purchase VALUES("1042","PUR240923101","","SU","44","0.00","108000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108000.00","0","","","2023-09-24","","108000.00","0.00","","LE_2","","0","5","2023-09-24 02:23:08");
INSERT INTO tbl_purchase VALUES("1043","PUR240923102","","SU","57","0.00","266600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266600.00","0","","","2023-09-24","","266600.00","0.00","","LE_2","","0","5","2023-09-24 04:52:58");
INSERT INTO tbl_purchase VALUES("1044","PUR240923103","","SU","42","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2023-09-24","","18000.00","0.00","","LE_2","","0","5","2023-09-24 06:35:41");
INSERT INTO tbl_purchase VALUES("1045","PUR240923104","","SU","42","0.00","162000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","162000.00","0","","","2023-09-24","","162000.00","0.00","","LE_2","","0","5","2023-09-24 07:15:21");
INSERT INTO tbl_purchase VALUES("1046","PUR250923101","","SU","42","0.00","10500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10500.00","0","","","2023-09-25","","10500.00","0.00","","LE_2","","0","5","2023-09-25 10:56:55");
INSERT INTO tbl_purchase VALUES("1047","PUR270923101","","SU","60","0.00","49000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49000.00","0","","","2023-09-27","2023-10-04","0.00","0.00","","LE_2","","0","5","2023-09-27 05:22:26");
INSERT INTO tbl_purchase VALUES("1048","PUR270923102","","SU","42","0.00","124000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","124000.00","0","","","2023-09-27","","124000.00","0.00","","LE_2","","0","5","2023-09-27 05:30:12");
INSERT INTO tbl_purchase VALUES("1049","PUR280923101","","SU","27","0.00","46000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46000.00","0","","","2023-09-28","","46000.00","0.00","","LE_2","","0","5","2023-09-28 12:02:56");
INSERT INTO tbl_purchase VALUES("1050","PUR280923102","","SU","14","0.00","136000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","136000.00","0","","","2023-09-28","2023-10-05","0.00","0.00","","LE_2","","0","5","2023-09-30 11:32:43");
INSERT INTO tbl_purchase VALUES("1051","PUR280923103","","SU","60","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-09-28","2023-10-05","0.00","0.00","","LE_2","","0","5","2023-09-28 06:06:23");
INSERT INTO tbl_purchase VALUES("1052","PUR300923101","","SU","44","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2023-09-30","","80000.00","0.00","","LE_2","","0","5","2023-09-30 05:44:32");
INSERT INTO tbl_purchase VALUES("1053","PUR011023101","","SU","44","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2023-10-01","","72000.00","0.00","","LE_2","","0","5","2023-10-01 04:09:02");
INSERT INTO tbl_purchase VALUES("1054","PUR021023101","","SU","42","0.00","195500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","195500.00","0","","","2023-10-02","","195500.00","0.00","","LE_2","","0","5","2023-10-02 11:42:41");
INSERT INTO tbl_purchase VALUES("1055","PUR021023102","","SU","60","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2023-10-02","2023-10-09","0.00","0.00","","LE_2","","0","5","2023-10-02 03:11:41");
INSERT INTO tbl_purchase VALUES("1056","PUR021023103","","SU","42","0.00","414000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","414000.00","0","","","2023-10-02","","414000.00","0.00","","LE_2","","0","5","2023-10-02 06:02:20");
INSERT INTO tbl_purchase VALUES("1057","PUR021023104","","SU","42","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-10-02","","17000.00","0.00","","LE_2","","0","5","2023-10-02 06:03:13");
INSERT INTO tbl_purchase VALUES("1058","PUR041023101","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","Charger +p.cable","2023-10-04","","18000.00","0.00","","LE_2","","0","5","2023-10-04 11:07:31");
INSERT INTO tbl_purchase VALUES("1059","PUR041023102","","SU","42","0.00","11000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11000.00","0","","","2023-10-04","","11000.00","0.00","","LE_2","","0","5","2023-10-04 05:51:02");
INSERT INTO tbl_purchase VALUES("1060","PUR041023103","","SU","14","0.00","242000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","242000.00","0","","","2023-10-04","","242000.00","0.00","","LE_2","","0","5","2023-10-04 07:44:16");
INSERT INTO tbl_purchase VALUES("1061","PUR051023101","","SU","14","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2023-10-05","","25000.00","0.00","","LE_2","","0","5","2023-10-05 05:22:29");
INSERT INTO tbl_purchase VALUES("1062","PUR061023101","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-10-06","","23000.00","0.00","","LE_2","","0","5","2023-10-06 12:53:07");
INSERT INTO tbl_purchase VALUES("1063","PUR061023102","","SU","14","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-10-06","","26000.00","0.00","","LE_2","","0","5","2023-10-06 02:15:00");
INSERT INTO tbl_purchase VALUES("1064","PUR061023103","","SU","1","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2023-10-06","","21000.00","0.00","","LE_2","","0","5","2023-10-06 02:32:03");
INSERT INTO tbl_purchase VALUES("1065","PUR061023104","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-10-06","","23000.00","0.00","","LE_2","","0","5","2023-10-06 02:36:58");
INSERT INTO tbl_purchase VALUES("1066","PUR061023105","","SU","14","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2023-10-06","","115000.00","0.00","","LE_2","","0","5","2023-10-06 02:42:59");
INSERT INTO tbl_purchase VALUES("1067","PUR081023101","","SU","1","0.00","14500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14500.00","0","","","2023-10-08","","14500.00","0.00","","LE_2","","0","5","2023-10-08 04:29:18");
INSERT INTO tbl_purchase VALUES("1068","PUR081023102","","SU","14","0.00","248000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","248000.00","0","","","2023-10-08","","248000.00","0.00","","LE_2","","0","5","2023-10-08 07:24:33");
INSERT INTO tbl_purchase VALUES("1069","PUR091023101","","SU","27","0.00","23000000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000000.00","0","","","2022-06-01","","23000000.00","0.00","","LE_2","","0","5","2023-10-09 01:48:56");
INSERT INTO tbl_purchase VALUES("1070","PUR091023102","","SU","27","0.00","11500000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11500000.00","0","","","2023-01-05","","11500000.00","0.00","","LE_2","","0","5","2023-10-09 01:53:45");
INSERT INTO tbl_purchase VALUES("1071","PUR091023103","","SU","15","0.00","15200000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15200000.00","0","","","2022-07-07","","15200000.00","0.00","","LE_2","","0","5","2023-10-09 01:51:20");
INSERT INTO tbl_purchase VALUES("1072","PUR091023104","","SU","1","0.00","18000000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000000.00","0","","","2022-12-04","","18000000.00","0.00","","LE_2","","0","5","2023-10-09 01:53:14");
INSERT INTO tbl_purchase VALUES("1073","PUR091023105","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-10-09","","19000.00","0.00","","LE_2","","0","5","2023-10-09 07:23:34");
INSERT INTO tbl_purchase VALUES("1074","PUR111023101","","SU","29","0.00","173800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","173800.00","0","","","2023-10-11","","173800.00","0.00","","LE_2","","0","5","2023-10-11 04:33:39");
INSERT INTO tbl_purchase VALUES("1075","PUR111023102","","SU","14","0.00","96000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96000.00","0","","","2023-10-11","","96000.00","0.00","","LE_2","","0","5","2023-10-11 04:44:37");
INSERT INTO tbl_purchase VALUES("1076","PUR111023103","","SU","57","0.00","166500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","166500.00","0","","","2023-10-11","","166500.00","0.00","","LE_2","","0","5","2023-10-11 07:36:59");
INSERT INTO tbl_purchase VALUES("1077","PUR111023104","","SU","61","0.00","152000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152000.00","0","","","2023-10-11","2023-10-18","0.00","0.00","","LE_2","","0","5","2023-10-11 07:45:52");
INSERT INTO tbl_purchase VALUES("1078","PUR131023101","","SU","14","0.00","290000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","290000.00","0","","","2023-10-13","","290000.00","0.00","","LE_2","","0","5","2023-10-13 12:47:00");
INSERT INTO tbl_purchase VALUES("1079","PUR131023102","","SU","1","0.00","2500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2500.00","0","","","2023-10-13","","2500.00","0.00","","LE_2","","0","5","2023-10-13 04:21:15");
INSERT INTO tbl_purchase VALUES("1080","PUR141023101","","SU","14","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2023-10-14","","133000.00","0.00","","LE_2","","0","5","2023-10-14 04:52:26");
INSERT INTO tbl_purchase VALUES("1081","PUR141023102","","SU","57","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2023-10-14","","90000.00","0.00","","LE_2","","0","5","2023-10-14 04:56:23");
INSERT INTO tbl_purchase VALUES("1082","PUR141023103","","SU","57","0.00","92500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92500.00","0","","","2023-10-14","","92500.00","0.00","","LE_2","","0","5","2023-10-14 07:04:04");
INSERT INTO tbl_purchase VALUES("1083","PUR141023104","","SU","14","0.00","69000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69000.00","0","","","2023-10-14","2023-10-21","0.00","0.00","","LE_2","","0","5","2023-10-14 07:16:56");
INSERT INTO tbl_purchase VALUES("1084","PUR181023101","","SU","14","0.00","182000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","182000.00","0","","","2023-10-18","","182000.00","0.00","","LE_2","","0","5","2023-10-18 02:03:25");
INSERT INTO tbl_purchase VALUES("1085","PUR181023102","","SU","42","0.00","239000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","239000.00","0","","","2023-10-18","","239000.00","0.00","","LE_2","","0","5","2023-10-18 04:31:14");
INSERT INTO tbl_purchase VALUES("1086","PUR181023103","","SU","14","0.00","125000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125000.00","0","","","2023-10-18","","125000.00","0.00","","LE_2","","0","5","2023-10-18 07:59:24");
INSERT INTO tbl_purchase VALUES("1087","PUR191023101","","SU","14","0.00","68000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68000.00","0","","","2023-10-19","","68000.00","0.00","","LE_2","","0","5","2023-10-19 05:48:47");
INSERT INTO tbl_purchase VALUES("1088","PUR201023101","","SU","1","0.00","4500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4500.00","0","","","2023-10-20","","4500.00","0.00","","LE_2","","0","5","2023-10-20 11:27:02");
INSERT INTO tbl_purchase VALUES("1089","PUR211023101","","SU","57","0.00","92500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92500.00","0","","","2023-10-21","","92500.00","0.00","","LE_2","","0","5","2023-10-21 12:51:40");
INSERT INTO tbl_purchase VALUES("1090","PUR211023102","","SU","14","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2023-10-21","","50000.00","0.00","","LE_2","","0","5","2023-10-21 02:40:16");
INSERT INTO tbl_purchase VALUES("1092","PUR211023103","","SU","1","0.00","46000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46000.00","0","","","2023-10-21","","46000.00","0.00","","LE_2","","0","5","2023-10-21 04:57:21");
INSERT INTO tbl_purchase VALUES("1093","PUR211023104","","SU","9","0.00","26500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26500.00","0","","","2023-10-21","2023-10-28","0.00","0.00","","LE_2","","0","5","2023-10-21 05:16:03");
INSERT INTO tbl_purchase VALUES("1094","PUR221023101","","SU","14","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2023-10-22","","115000.00","0.00","","LE_2","","0","5","2023-10-22 05:33:16");
INSERT INTO tbl_purchase VALUES("1095","PUR231023101","","SU","1","0.00","4400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4400.00","0","","","2023-10-23","","4400.00","0.00","","LE_2","","0","5","2023-10-23 12:03:37");
INSERT INTO tbl_purchase VALUES("1096","PUR231023102","","SU","1","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-10-23","","38000.00","0.00","","LE_2","","0","5","2023-10-23 07:20:53");
INSERT INTO tbl_purchase VALUES("1097","PUR251023101","","SU","29","0.00","10800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10800.00","0","","","2023-10-25","","10800.00","0.00","","LE_2","","0","5","2023-10-25 01:59:52");
INSERT INTO tbl_purchase VALUES("1098","PUR251023102","","SU","14","0.00","180000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180000.00","0","","","2023-10-25","","180000.00","0.00","","LE_2","","0","5","2023-10-25 04:19:52");
INSERT INTO tbl_purchase VALUES("1099","PUR261023101","","SU","14","0.00","259000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","259000.00","0","","","2023-10-26","","259000.00","0.00","","LE_2","","0","5","2023-10-27 11:27:04");
INSERT INTO tbl_purchase VALUES("1100","PUR271023101","","SU","1","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-10-27","","56000.00","0.00","","LE_2","","0","5","2023-10-27 03:43:16");
INSERT INTO tbl_purchase VALUES("1101","PUR271023102","","SU","1","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-10-27","","28000.00","0.00","","LE_2","","0","5","2023-10-27 08:01:21");
INSERT INTO tbl_purchase VALUES("1102","PUR301023101","","SU","42","0.00","198000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","198000.00","0","","","2023-10-30","","198000.00","0.00","","LE_2","","0","5","2023-10-30 06:21:45");
INSERT INTO tbl_purchase VALUES("1103","PUR011123101","","SU","14","0.00","73500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73500.00","0","","","2023-11-01","","73500.00","0.00","","LE_2","","0","5","2023-11-01 12:03:56");
INSERT INTO tbl_purchase VALUES("1104","PUR011123102","","SU","14","0.00","140000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140000.00","0","","","2023-11-01","","140000.00","0.00","","LE_2","","0","5","2023-11-01 02:59:39");
INSERT INTO tbl_purchase VALUES("1105","PUR011123103","","SU","7","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2023-11-01","2023-11-08","0.00","0.00","","LE_2","","0","5","2023-11-01 07:34:46");
INSERT INTO tbl_purchase VALUES("1106","PUR031123101","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-11-03","","26000.00","0.00","","LE_2","","0","5","2023-11-03 07:40:54");
INSERT INTO tbl_purchase VALUES("1107","PUR041123101","","SU","14","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2023-11-04","","175000.00","0.00","","LE_2","","0","5","2023-11-04 12:02:01");
INSERT INTO tbl_purchase VALUES("1108","PUR051123101","","SU","1","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-11-05","","17000.00","0.00","","LE_2","","0","5","2023-11-05 04:41:49");
INSERT INTO tbl_purchase VALUES("1109","PUR081123101","","SU","14","0.00","338000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","338000.00","0","","No Charger","2023-11-08","","338000.00","0.00","","LE_2","","0","5","2023-11-08 02:54:54");
INSERT INTO tbl_purchase VALUES("1110","PUR101123101","","SU","46","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-11-10","2023-11-17","0.00","0.00","","LE_2","","0","5","2023-11-10 05:35:42");
INSERT INTO tbl_purchase VALUES("1111","PUR111123101","","SU","14","0.00","380000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","380000.00","0","","No  Charger","2023-11-11","","380000.00","0.00","","LE_2","","0","5","2023-11-11 04:06:37");
INSERT INTO tbl_purchase VALUES("1112","PUR121123101","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2023-11-12","","25000.00","0.00","","LE_2","","0","5","2023-11-12 05:38:43");
INSERT INTO tbl_purchase VALUES("1113","PUR151123101","","SU","14","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-11-15","","114000.00","0.00","","LE_2","","0","5","2023-11-15 02:07:15");
INSERT INTO tbl_purchase VALUES("1114","PUR151123102","","SU","14","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2023-11-15","","34000.00","0.00","","LE_2","","0","5","2023-11-15 04:24:16");
INSERT INTO tbl_purchase VALUES("1115","PUR151123103","","SU","14","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-11-15","","17000.00","0.00","","LE_2","","0","5","2023-11-15 05:40:20");
INSERT INTO tbl_purchase VALUES("1116","PUR171123101","","SU","14","0.00","187000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","187000.00","0","","","2023-11-17","","187000.00","0.00","","LE_2","","0","5","2023-11-17 12:36:18");
INSERT INTO tbl_purchase VALUES("1117","PUR181123101","","SU","1","0.00","26500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26500.00","0","","","2023-11-18","","26500.00","0.00","","LE_2","","0","5","2023-11-18 03:26:42");
INSERT INTO tbl_purchase VALUES("1118","PUR191123101","","SU","14","0.00","156000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","156000.00","0","","","2023-11-19","","156000.00","0.00","","LE_2","","0","5","2023-11-19 12:14:38");
INSERT INTO tbl_purchase VALUES("1119","PUR191123102","","SU","42","0.00","74800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74800.00","0","","","2023-11-19","","74800.00","0.00","","LE_2","","0","5","2023-11-19 05:22:23");
INSERT INTO tbl_purchase VALUES("1120","PUR191123103","","SU","42","0.00","75200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75200.00","0","","","2023-11-19","","75200.00","0.00","","LE_2","","0","5","2023-11-19 05:38:54");
INSERT INTO tbl_purchase VALUES("1121","PUR201123101","","SU","14","0.00","182000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","182000.00","0","","","2023-11-20","","182000.00","0.00","","LE_2","","0","5","2023-11-20 03:37:16");
INSERT INTO tbl_purchase VALUES("1122","PUR201123102","","SU","42","0.00","188000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","188000.00","0","","","2023-11-20","","188000.00","0.00","","LE_2","","0","5","2023-11-20 07:32:31");
INSERT INTO tbl_purchase VALUES("1123","PUR221123101","","SU","42","0.00","263200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","263200.00","0","","","2023-11-22","","263200.00","0.00","","LE_2","","0","5","2023-11-22 06:20:33");
INSERT INTO tbl_purchase VALUES("1124","PUR221123102","","SU","42","0.00","18800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18800.00","0","","","2023-11-22","","18800.00","0.00","","LE_2","","0","5","2023-11-22 07:24:45");
INSERT INTO tbl_purchase VALUES("1125","PUR231123101","","SU","42","0.00","112800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112800.00","0","","","2023-11-23","","112800.00","0.00","","LE_2","","0","5","2023-11-23 11:48:44");
INSERT INTO tbl_purchase VALUES("1126","PUR231123102","","SU","44","0.00","104000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104000.00","0","","","2023-11-23","","104000.00","0.00","","LE_2","","0","5","2023-11-23 03:43:14");
INSERT INTO tbl_purchase VALUES("1127","PUR241123101","","SU","42","0.00","376000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","376000.00","0","","","2023-11-24","","376000.00","0.00","","LE_2","","0","5","2023-11-24 11:24:34");
INSERT INTO tbl_purchase VALUES("1128","PUR241123102","","SU","1","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2023-11-24","","58000.00","0.00","","LE_2","","0","5","2023-11-24 06:46:50");
INSERT INTO tbl_purchase VALUES("1129","PUR241123103","","SU","42","0.00","304000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","304000.00","0","","","2023-11-24","","304000.00","0.00","","LE_2","","0","5","2023-11-24 07:50:18");
INSERT INTO tbl_purchase VALUES("1130","PUR251123101","","SU","14","0.00","168000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","168000.00","0","","","2023-11-25","","168000.00","0.00","","LE_2","","0","5","2023-11-25 01:05:45");
INSERT INTO tbl_purchase VALUES("1131","PUR251123102","","SU","62","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2023-11-25","2023-12-02","0.00","0.00","","LE_2","","0","5","2023-11-25 02:08:04");
INSERT INTO tbl_purchase VALUES("1132","PUR261123101","","SU","14","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-11-26","","19000.00","0.00","","LE_2","","0","5","2023-11-26 12:05:03");
INSERT INTO tbl_purchase VALUES("1133","PUR271123101","","SU","42","0.00","470350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","470350.00","0","","","2023-11-27","","470350.00","0.00","","LE_2","","0","5","2023-11-27 06:49:18");
INSERT INTO tbl_purchase VALUES("1134","PUR291123101","","SU","14","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2023-11-29","","130000.00","0.00","","LE_2","","0","5","2023-11-29 02:16:37");
INSERT INTO tbl_purchase VALUES("1135","PUR021223101","","SU","14","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2023-12-02","","114000.00","0.00","","LE_2","","0","5","2023-12-02 01:53:18");
INSERT INTO tbl_purchase VALUES("1136","PUR031223101","","SU","1","0.00","44000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","44000.00","0","","","2023-12-03","","44000.00","0.00","","LE_2","","0","5","2023-12-03 06:49:24");
INSERT INTO tbl_purchase VALUES("1137","PUR061223101","","SU","14","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2023-12-06","","72000.00","0.00","","LE_2","","0","5","2023-12-06 03:39:07");
INSERT INTO tbl_purchase VALUES("1138","PUR101223101","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-12-10","","23000.00","0.00","","LE_2","","0","5","2023-12-10 02:59:31");
INSERT INTO tbl_purchase VALUES("1139","PUR101223102","","SU","62","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-12-10","2023-12-17","0.00","0.00","","LE_2","","0","5","2023-12-10 06:33:18");
INSERT INTO tbl_purchase VALUES("1140","PUR131223101","","SU","62","0.00","53000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","53000.00","0","","Charger 2 pcs","2023-12-13","2023-12-20","0.00","0.00","","LE_2","","0","5","2023-12-13 03:01:32");
INSERT INTO tbl_purchase VALUES("1141","PUR131223102","","SU","62","0.00","110000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110000.00","0","","","2023-12-13","2023-12-20","0.00","0.00","","LE_2","","0","5","2023-12-13 03:04:45");
INSERT INTO tbl_purchase VALUES("1142","PUR131223103","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-12-13","","19000.00","0.00","","LE_2","","0","5","2023-12-13 06:32:20");
INSERT INTO tbl_purchase VALUES("1143","PUR151223101","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-12-15","2023-12-22","0.00","0.00","","LE_2","","0","5","2023-12-15 06:05:13");
INSERT INTO tbl_purchase VALUES("1144","PUR171223101","","SU","63","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2023-12-17","2023-12-24","0.00","0.00","","LE_2","","0","5","2023-12-17 07:02:17");
INSERT INTO tbl_purchase VALUES("1145","PUR181223101","","SU","63","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-12-18","","56000.00","0.00","","LE_2","","0","5","2023-12-18 05:02:54");
INSERT INTO tbl_purchase VALUES("1146","PUR181223102","","SU","63","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2023-12-18","","27000.00","0.00","","LE_2","","0","5","2023-12-18 06:37:05");
INSERT INTO tbl_purchase VALUES("1147","PUR201223101","","SU","14","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-12-20","","57000.00","0.00","","LE_2","","0","5","2023-12-20 02:58:48");
INSERT INTO tbl_purchase VALUES("1148","PUR201223102","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","Star networking solution","2023-12-20","","19000.00","0.00","","LE_2","","0","5","2023-12-20 06:20:46");
INSERT INTO tbl_purchase VALUES("1149","PUR201223103","","SU","1","0.00","19500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19500.00","0","","Limon ","2023-12-20","","19500.00","0.00","","LE_2","","0","5","2023-12-20 06:22:42");
INSERT INTO tbl_purchase VALUES("1150","PUR211223101","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-12-21","2023-12-28","0.00","0.00","","LE_2","","0","5","2023-12-21 12:11:12");
INSERT INTO tbl_purchase VALUES("1151","PUR211223102","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-12-21","","19000.00","0.00","","LE_2","","0","5","2023-12-21 12:55:08");
INSERT INTO tbl_purchase VALUES("1152","PUR211223103","","SU","63","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-12-21","","38000.00","0.00","","LE_2","","0","5","2023-12-21 05:21:43");
INSERT INTO tbl_purchase VALUES("1153","PUR221223101","","SU","63","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2023-12-22","","38000.00","0.00","","LE_2","","0","5","2023-12-22 06:45:08");
INSERT INTO tbl_purchase VALUES("1154","PUR281223101","","SU","62","0.00","28500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28500.00","0","","","2023-12-28","2024-01-04","0.00","0.00","","LE_2","","0","5","2023-12-28 02:06:41");
INSERT INTO tbl_purchase VALUES("1155","PUR040124101","","SU","64","0.00","418300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","418300.00","0","","","2024-01-04","2024-01-11","0.00","0.00","","LE_2","","0","5","2024-01-04 12:32:56");
INSERT INTO tbl_purchase VALUES("1156","PUR040124102","","SU","65","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-01-04","2024-01-11","0.00","0.00","","LE_2","","0","5","2024-01-04 12:40:37");
INSERT INTO tbl_purchase VALUES("1157","PUR040124103","","SU","63","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-01-04","2024-01-11","0.00","0.00","","LE_2","","0","5","2024-01-04 12:46:26");
INSERT INTO tbl_purchase VALUES("1158","PUR040124104","","SU","63","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2024-01-04","2024-01-11","0.00","0.00","","LE_2","","0","5","2024-01-04 12:53:40");
INSERT INTO tbl_purchase VALUES("1159","PUR040124105","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-01-04","","19000.00","0.00","","LE_2","","0","5","2024-01-04 12:56:13");
INSERT INTO tbl_purchase VALUES("1160","PUR040124106","","SU","64","0.00","259000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","259000.00","0","","","2024-01-04","2024-01-11","0.00","0.00","","LE_2","","0","5","2024-01-04 04:05:15");
INSERT INTO tbl_purchase VALUES("1161","PUR040124107","","SU","1","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-01-04","","18000.00","0.00","","LE_2","","0","5","2024-01-04 04:07:43");
INSERT INTO tbl_purchase VALUES("1162","PUR050124101","","SU","64","0.00","22500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22500.00","0","","","2024-01-05","2024-01-12","0.00","0.00","","LE_2","","0","5","2024-01-05 05:03:32");
INSERT INTO tbl_purchase VALUES("1163","PUR060124101","","SU","64","0.00","18700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18700.00","0","","","2024-01-06","2024-01-13","0.00","0.00","","LE_2","","0","5","2024-01-06 12:32:51");
INSERT INTO tbl_purchase VALUES("1164","PUR060124102","","SU","66","0.00","64000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64000.00","0","","","2024-01-06","2024-01-13","10000.00","0.00","","LE_2","","0","5","2024-01-06 04:32:39");
INSERT INTO tbl_purchase VALUES("1165","PUR100124101","","SU","64","0.00","73500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73500.00","0","","","2024-01-10","2024-01-17","0.00","0.00","","LE_2","","0","5","2024-01-10 07:06:45");
INSERT INTO tbl_purchase VALUES("1166","PUR100124102","","SU","64","0.00","81000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81000.00","0","","","2024-01-10","2024-01-17","0.00","0.00","","LE_2","","0","5","2024-01-10 12:38:24");
INSERT INTO tbl_purchase VALUES("1167","PUR100124103","","SU","64","0.00","84000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84000.00","0","","","2024-01-10","2024-01-17","0.00","0.00","","LE_2","","0","5","2024-01-10 12:40:18");
INSERT INTO tbl_purchase VALUES("1168","PUR100124104","","SU","64","0.00","81000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81000.00","0","","","2024-01-10","2024-01-17","0.00","0.00","","LE_2","","0","5","2024-01-10 05:26:26");
INSERT INTO tbl_purchase VALUES("1169","PUR110124101","","SU","1","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2024-01-11","","80000.00","0.00","","LE_2","","0","5","2024-01-11 06:57:46");
INSERT INTO tbl_purchase VALUES("1170","PUR120124101","","SU","64","0.00","19800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19800.00","0","","for adjustment customer ledger","2024-01-12","2024-01-19","0.00","0.00","","LE_2","","0","5","2024-01-12 03:23:49");
INSERT INTO tbl_purchase VALUES("1171","PUR120124102","","SU","66","0.00","3000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3000.00","0","","7470 unit 4 add 500 and 840 G3 add 1k","2024-01-12","2024-01-19","0.00","0.00","","LE_2","","0","5","2024-01-12 04:32:05");
INSERT INTO tbl_purchase VALUES("1172","PUR120124103","","SU","61","0.00","288000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","288000.00","0","","","2024-01-12","2024-01-19","50000.00","0.00","","LE_2","","0","5","2024-01-12 06:38:57");
INSERT INTO tbl_purchase VALUES("1173","PUR120124104","","SU","63","0.00","12200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12200.00","0","","","2024-01-12","2024-01-19","0.00","0.00","","LE_2","","0","5","2024-01-12 07:37:47");
INSERT INTO tbl_purchase VALUES("1174","PUR130124101","","SU","63","0.00","27500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27500.00","0","","","2024-01-13","2024-01-20","0.00","0.00","","LE_2","","0","5","2024-01-13 02:05:02");
INSERT INTO tbl_purchase VALUES("1175","PUR130124102","","SU","63","0.00","166000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","166000.00","0","","","2024-01-13","2024-01-20","0.00","0.00","","LE_2","","0","5","2024-01-13 06:58:20");
INSERT INTO tbl_purchase VALUES("1176","PUR130124103","","SU","63","0.00","26500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26500.00","0","","","2024-01-13","2024-01-20","0.00","0.00","","LE_2","","0","5","2024-01-13 07:57:45");
INSERT INTO tbl_purchase VALUES("1177","PUR150124101","","SU","1","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-01-15","2024-01-22","0.00","0.00","","LE_2","","0","5","2024-01-15 12:42:50");
INSERT INTO tbl_purchase VALUES("1178","PUR210124101","","SU","1","0.00","55000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55000.00","0","","","2024-01-21","2024-01-28","0.00","0.00","","LE_2","","0","5","2024-01-21 11:43:51");
INSERT INTO tbl_purchase VALUES("1179","PUR240124101","","SU","42","0.00","135000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135000.00","0","","","2024-01-24","","135000.00","0.00","","LE_2","","0","5","2024-01-24 07:01:09");
INSERT INTO tbl_purchase VALUES("1180","PUR240124102","","SU","1","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2024-01-24","","23000.00","0.00","","LE_2","","0","5","2024-01-24 07:59:44");
INSERT INTO tbl_purchase VALUES("1181","PUR260124101","","SU","66","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2024-01-26","2024-02-02","0.00","0.00","","LE_2","","0","5","2024-01-26 07:01:13");
INSERT INTO tbl_purchase VALUES("1182","PUR270124101","","SU","1","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","Charger 2pcs","2024-01-27","2024-02-03","0.00","0.00","","LE_2","","0","5","2024-01-27 03:39:48");
INSERT INTO tbl_purchase VALUES("1183","PUR280124101","","SU","1","0.00","1144000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1144000.00","0","","Charger 26","2024-01-28","","1144000.00","0.00","","LE_2","","0","5","2024-01-28 06:43:58");
INSERT INTO tbl_purchase VALUES("1184","PUR290124101","","SU","1","0.00","806000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","806000.00","0","","","2024-01-29","","806000.00","0.00","","LE_2","","0","5","2024-01-29 07:27:53");
INSERT INTO tbl_purchase VALUES("1185","PUR300124101","","SU","1","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2024-01-30","","28000.00","0.00","","LE_2","","0","5","2024-01-30 07:37:13");
INSERT INTO tbl_purchase VALUES("1186","PUR310124101","","SU","50","0.00","260000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","260000.00","0","","Charger 7 pcs","2024-01-31","","260000.00","0.00","","LE_2","","0","5","2024-01-31 12:24:47");
INSERT INTO tbl_purchase VALUES("1187","PUR310124102","","SU","1","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2024-01-31","","78000.00","0.00","","LE_2","","0","5","2024-01-31 02:41:52");
INSERT INTO tbl_purchase VALUES("1188","PUR020224101","","SU","50","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","Charger 2","2024-02-02","","52000.00","0.00","","LE_2","","0","5","2024-02-02 05:05:51");
INSERT INTO tbl_purchase VALUES("1189","PUR030224101","","SU","68","0.00","67500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67500.00","0","","","2024-02-03","","67500.00","0.00","","LE_2","","0","5","2024-02-03 06:31:48");
INSERT INTO tbl_purchase VALUES("1190","PUR040224101","","SU","1","0.00","128100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128100.00","0","","SWAP","2024-02-04","","128100.00","0.00","","LE_2","","0","5","2024-02-04 11:28:21");
INSERT INTO tbl_purchase VALUES("1191","PUR050224101","","SU","50","0.00","117500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","117500.00","0","","","2024-02-05","","117500.00","0.00","","LE_2","","0","5","2024-02-05 03:26:13");
INSERT INTO tbl_purchase VALUES("1192","PUR050224102","","SU","68","0.00","157500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","157500.00","0","","","2024-02-05","","157500.00","0.00","","LE_2","","0","5","2024-02-05 04:41:46");
INSERT INTO tbl_purchase VALUES("1193","PUR070224101","","SU","50","0.00","522000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","522000.00","0","","","2024-02-07","","522000.00","0.00","","LE_2","","0","5","2024-02-07 12:31:13");
INSERT INTO tbl_purchase VALUES("1194","PUR070224102","","SU","50","0.00","106500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106500.00","0","","","2024-02-07","","106500.00","0.00","","LE_2","","0","5","2024-02-07 12:52:17");
INSERT INTO tbl_purchase VALUES("1195","PUR070224103","","SU","68","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2024-02-07","","114000.00","0.00","","LE_2","","0","5","2024-02-07 05:16:36");
INSERT INTO tbl_purchase VALUES("1196","PUR070224104","","SU","50","0.00","547500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","547500.00","0","","","2024-02-07","","547500.00","0.00","","LE_2","","0","5","2024-02-07 05:33:21");
INSERT INTO tbl_purchase VALUES("1197","PUR070224105","","SU","1","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2024-02-07","","29000.00","0.00","","LE_2","","0","5","2024-02-07 05:52:09");
INSERT INTO tbl_purchase VALUES("1198","PUR080224101","","SU","50","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2024-02-08","","76000.00","0.00","","LE_2","","0","5","2024-02-08 03:08:00");
INSERT INTO tbl_purchase VALUES("1199","PUR080224102","","SU","68","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-02-08","","95000.00","0.00","","LE_2","","0","5","2024-02-08 03:43:50");
INSERT INTO tbl_purchase VALUES("1200","PUR100224101","","SU","50","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2024-02-10","","29000.00","0.00","","LE_2","","0","5","2024-02-10 11:38:03");
INSERT INTO tbl_purchase VALUES("1201","PUR100224102","","SU","50","0.00","253500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","253500.00","0","","","2024-02-10","","253500.00","0.00","","LE_2","","0","5","2024-02-10 01:33:29");
INSERT INTO tbl_purchase VALUES("1202","PUR100224103","","SU","68","0.00","187000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","187000.00","0","","","2024-02-10","","187000.00","0.00","","LE_2","","0","5","2024-02-10 03:18:30");
INSERT INTO tbl_purchase VALUES("1203","PUR100224104","","SU","1","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2024-02-10","","24500.00","0.00","","LE_2","","0","5","2024-02-10 04:40:56");
INSERT INTO tbl_purchase VALUES("1204","PUR100224105","","SU","68","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2024-02-10","","16000.00","0.00","","LE_2","","0","5","2024-02-10 05:24:35");
INSERT INTO tbl_purchase VALUES("1205","PUR110224101","","SU","50","0.00","333000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","333000.00","0","","","2024-02-11","","333000.00","0.00","","LE_2","","0","5","2024-02-11 02:06:34");
INSERT INTO tbl_purchase VALUES("1206","PUR110224102","","SU","68","0.00","149000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149000.00","0","","","2024-02-11","","149000.00","0.00","","LE_2","","0","5","2024-02-11 03:19:52");
INSERT INTO tbl_purchase VALUES("1207","PUR110224103","","SU","50","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-02-11","","19000.00","0.00","","LE_2","","0","5","2024-02-11 03:29:33");
INSERT INTO tbl_purchase VALUES("1208","PUR120224101","","SU","50","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-02-12","","95000.00","0.00","","LE_2","","0","5","2024-02-12 01:50:54");
INSERT INTO tbl_purchase VALUES("1209","PUR120224102","","SU","68","0.00","146000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","146000.00","0","","","2024-02-12","","146000.00","0.00","","LE_2","","0","5","2024-02-12 03:15:42");
INSERT INTO tbl_purchase VALUES("1210","PUR140224101","","SU","50","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2024-02-14","","16000.00","0.00","","LE_2","","0","5","2024-02-14 12:08:31");
INSERT INTO tbl_purchase VALUES("1211","PUR140224102","","SU","68","0.00","165000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165000.00","0","","","2024-02-14","","165000.00","0.00","","LE_2","","0","5","2024-02-14 05:11:58");
INSERT INTO tbl_purchase VALUES("1212","PUR150224101","","SU","50","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2024-02-15","","114000.00","0.00","","LE_2","","0","5","2024-02-15 11:38:40");
INSERT INTO tbl_purchase VALUES("1213","PUR150224102","","SU","50","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2024-02-15","","17000.00","0.00","","LE_2","","0","5","2024-02-15 04:03:40");
INSERT INTO tbl_purchase VALUES("1214","PUR170224101","","SU","50","0.00","415000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","415000.00","0","","","2024-02-17","","415000.00","0.00","","LE_2","","0","5","2024-02-17 10:51:04");
INSERT INTO tbl_purchase VALUES("1215","PUR170224102","","SU","50","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2024-02-17","","50000.00","0.00","","LE_2","","0","5","2024-02-17 10:53:27");
INSERT INTO tbl_purchase VALUES("1216","PUR170224103","","SU","68","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-02-17","","95000.00","0.00","","LE_2","","0","5","2024-02-17 02:30:21");
INSERT INTO tbl_purchase VALUES("1217","PUR180224101","","SU","50","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2024-02-18","","51000.00","0.00","","LE_2","","0","5","2024-02-18 01:07:21");
INSERT INTO tbl_purchase VALUES("1218","PUR180224102","","SU","69","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-02-18","2024-02-25","0.00","0.00","","LE_2","","0","5","2024-02-18 06:51:11");
INSERT INTO tbl_purchase VALUES("1219","PUR190224101","","SU","50","0.00","211000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","211000.00","0","","","2024-02-19","","211000.00","0.00","","LE_2","","0","5","2024-02-19 12:32:33");
INSERT INTO tbl_purchase VALUES("1220","PUR230224101","","SU","50","0.00","234000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","234000.00","0","","","2024-02-23","","234000.00","0.00","","LE_2","","0","5","2024-02-23 03:12:26");
INSERT INTO tbl_purchase VALUES("1221","PUR230224102","","SU","50","0.00","396000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","396000.00","0","","","2024-02-23","","396000.00","0.00","","LE_2","","0","5","2024-02-23 03:20:46");
INSERT INTO tbl_purchase VALUES("1222","PUR240224101","","SU","50","0.00","270000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","270000.00","0","","","2024-02-24","","270000.00","0.00","","LE_2","","0","5","2024-02-24 12:37:31");
INSERT INTO tbl_purchase VALUES("1223","PUR250224101","","SU","50","0.00","74000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74000.00","0","","","2024-02-25","","74000.00","0.00","","LE_2","","0","5","2024-02-25 12:50:46");
INSERT INTO tbl_purchase VALUES("1224","PUR270224101","","SU","50","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2024-02-27","","126000.00","0.00","","LE_2","","0","5","2024-02-27 08:02:52");
INSERT INTO tbl_purchase VALUES("1225","PUR280224101","","SU","50","0.00","285000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285000.00","0","","","2024-02-28","","285000.00","0.00","","LE_2","","0","5","2024-02-28 02:26:38");
INSERT INTO tbl_purchase VALUES("1226","PUR290224101","","SU","64","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-02-29","2024-03-07","0.00","0.00","","LE_2","","0","5","2024-02-29 01:51:07");
INSERT INTO tbl_purchase VALUES("1227","PUR010324101","","SU","42","0.00","142500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","142500.00","0","","","2024-03-01","","142500.00","0.00","","LE_2","","0","5","2024-03-01 11:01:35");
INSERT INTO tbl_purchase VALUES("1228","PUR010324102","","SU","42","0.00","199500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","199500.00","0","","","2024-03-01","","199500.00","0.00","","LE_2","","0","5","2024-03-01 11:12:21");
INSERT INTO tbl_purchase VALUES("1229","PUR010324103","","SU","50","0.00","174000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","174000.00","0","","","2024-03-01","","174000.00","0.00","","LE_2","","0","5","2024-03-01 12:25:05");
INSERT INTO tbl_purchase VALUES("1230","PUR010324104","","SU","1","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2024-03-01","","1500.00","0.00","","LE_2","","0","5","2024-03-01 03:38:03");
INSERT INTO tbl_purchase VALUES("1231","PUR010324105","","SU","50","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2024-03-01","","22000.00","0.00","","LE_2","","0","5","2024-03-01 06:36:24");
INSERT INTO tbl_purchase VALUES("1232","PUR020324101","","SU","50","0.00","94000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","94000.00","0","","","2024-03-02","","94000.00","0.00","","LE_2","","0","5","2024-03-02 12:27:56");
INSERT INTO tbl_purchase VALUES("1233","PUR020324102","","SU","64","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2024-03-02","2024-03-09","0.00","0.00","","LE_2","","0","5","2024-03-02 01:01:53");
INSERT INTO tbl_purchase VALUES("1234","PUR030324101","","SU","50","0.00","184000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","184000.00","0","","","2024-03-03","","184000.00","0.00","","LE_2","","0","5","2024-03-03 01:26:09");
INSERT INTO tbl_purchase VALUES("1235","PUR030324102","","SU","42","0.00","116000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116000.00","0","","","2024-03-03","","116000.00","0.00","","LE_2","","0","5","2024-03-03 03:42:40");
INSERT INTO tbl_purchase VALUES("1236","PUR030324103","","SU","50","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2024-03-03","","47000.00","0.00","","LE_2","","0","5","2024-03-03 03:44:24");
INSERT INTO tbl_purchase VALUES("1237","PUR040324101","","SU","50","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2024-03-04","","29000.00","0.00","","LE_2","","0","5","2024-03-04 11:19:39");
INSERT INTO tbl_purchase VALUES("1238","PUR040324102","","SU","50","0.00","179500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","179500.00","0","","","2024-03-04","","179500.00","0.00","","LE_2","","0","5","2024-03-04 03:17:22");
INSERT INTO tbl_purchase VALUES("1239","PUR040324103","","SU","50","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2024-03-04","","47000.00","0.00","","LE_2","","0","5","2024-03-04 07:22:00");
INSERT INTO tbl_purchase VALUES("1240","PUR060324101","","SU","50","0.00","94500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","94500.00","0","","","2024-03-06","","94500.00","0.00","","LE_2","","0","5","2024-03-06 02:10:15");
INSERT INTO tbl_purchase VALUES("1241","PUR060324102","","SU","50","0.00","416500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","416500.00","0","","","2024-03-06","","416500.00","0.00","","LE_2","","0","5","2024-03-06 02:32:15");
INSERT INTO tbl_purchase VALUES("1242","PUR060324103","","SU","42","0.00","209000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","209000.00","0","","","2024-03-06","","209000.00","0.00","","LE_2","","0","5","2024-03-06 06:49:51");
INSERT INTO tbl_purchase VALUES("1243","PUR070324101","","SU","50","0.00","12500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12500.00","0","","","2024-03-07","","12500.00","0.00","","LE_2","","0","5","2024-03-07 02:00:33");
INSERT INTO tbl_purchase VALUES("1244","PUR080324101","","SU","1","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2024-03-08","","57000.00","0.00","","LE_2","","0","5","2024-03-08 11:10:04");
INSERT INTO tbl_purchase VALUES("1245","PUR080324102","","SU","50","0.00","99000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99000.00","0","","","2024-03-08","","99000.00","0.00","","LE_2","","0","5","2024-03-08 04:01:23");
INSERT INTO tbl_purchase VALUES("1246","PUR080324103","","SU","64","0.00","159000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159000.00","0","","","2024-03-08","","159000.00","0.00","","LE_2","","0","5","2024-03-08 08:00:34");
INSERT INTO tbl_purchase VALUES("1247","PUR080324104","","SU","68","0.00","819000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","819000.00","0","","","2024-03-08","","819000.00","0.00","","LE_2","","0","5","2024-03-08 05:22:27");
INSERT INTO tbl_purchase VALUES("1248","PUR090324101","","SU","42","0.00","359000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","359000.00","0","","","2024-03-09","","359000.00","0.00","","LE_2","","0","5","2024-03-09 05:56:17");
INSERT INTO tbl_purchase VALUES("1249","PUR100324101","","SU","47","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-03-10","","18000.00","0.00","","LE_2","","0","5","2024-03-10 08:14:00");
INSERT INTO tbl_purchase VALUES("1250","PUR110324101","","SU","50","0.00","93000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","93000.00","0","","","2024-03-11","","93000.00","0.00","","LE_2","","0","5","2024-03-11 01:10:23");
INSERT INTO tbl_purchase VALUES("1251","PUR110324102","","SU","47","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2024-03-11","","38000.00","0.00","","LE_2","","0","5","2024-03-11 06:29:54");
INSERT INTO tbl_purchase VALUES("1252","PUR130324101","","SU","50","0.00","164000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164000.00","0","","","2024-03-13","","164000.00","0.00","","LE_2","","0","5","2024-03-13 11:45:03");
INSERT INTO tbl_purchase VALUES("1253","PUR130324102","","SU","50","0.00","257000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","257000.00","0","","","2024-03-13","","257000.00","0.00","","LE_2","","0","5","2024-03-13 02:34:08");
INSERT INTO tbl_purchase VALUES("1254","PUR130324103","","SU","50","0.00","220000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220000.00","0","","","2024-03-13","","220000.00","0.00","","LE_2","","0","5","2024-03-13 02:43:39");
INSERT INTO tbl_purchase VALUES("1255","PUR130324104","","SU","47","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2024-03-13","","72000.00","0.00","","LE_2","","0","5","2024-03-13 04:44:22");
INSERT INTO tbl_purchase VALUES("1256","PUR150324101","","SU","42","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-03-15","","95000.00","0.00","","LE_2","","0","5","2024-03-15 10:53:29");
INSERT INTO tbl_purchase VALUES("1257","PUR150324102","","SU","50","0.00","257000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","257000.00","0","","","2024-03-15","","257000.00","0.00","","LE_2","","0","5","2024-03-15 11:04:12");
INSERT INTO tbl_purchase VALUES("1258","PUR150324103","","SU","50","0.00","104000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104000.00","0","","","2024-03-15","","104000.00","0.00","","LE_2","","0","5","2024-03-15 03:16:27");
INSERT INTO tbl_purchase VALUES("1259","PUR150324104","","SU","47","0.00","54000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54000.00","0","","","2024-03-15","","54000.00","0.00","","LE_2","","0","5","2024-03-15 03:36:55");
INSERT INTO tbl_purchase VALUES("1260","PUR150324105","","SU","50","0.00","403000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","403000.00","0","","","2024-03-15","","403000.00","0.00","","LE_2","","0","5","2024-03-15 04:43:56");
INSERT INTO tbl_purchase VALUES("1261","PUR160324101","","SU","1","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2024-03-16","","16000.00","0.00","","LE_2","","0","5","2024-03-16 01:19:22");
INSERT INTO tbl_purchase VALUES("1262","PUR160324102","","SU","47","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2024-03-16","","38000.00","0.00","","LE_2","","0","5","2024-03-16 04:53:21");
INSERT INTO tbl_purchase VALUES("1263","PUR160324103","","SU","68","0.00","265000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","265000.00","0","","","2024-03-16","","265000.00","0.00","","LE_2","","0","5","2024-03-16 05:21:29");
INSERT INTO tbl_purchase VALUES("1264","PUR170324101","","SU","50","0.00","203000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","203000.00","0","","","2024-03-17","","203000.00","0.00","","LE_2","","0","5","2024-03-17 11:53:45");
INSERT INTO tbl_purchase VALUES("1265","PUR170324102","","SU","50","0.00","616000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","616000.00","0","","","2024-03-17","","616000.00","0.00","","LE_2","","0","5","2024-03-17 03:05:32");
INSERT INTO tbl_purchase VALUES("1266","PUR170324103","","SU","50","0.00","55000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55000.00","0","","","2024-03-17","","55000.00","0.00","","LE_2","","0","5","2024-03-17 03:12:39");
INSERT INTO tbl_purchase VALUES("1267","PUR170324104","","SU","70","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2024-03-17","","130000.00","0.00","","LE_2","","0","5","2024-03-17 03:34:30");
INSERT INTO tbl_purchase VALUES("1268","PUR170324105","","SU","50","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2024-03-17","","65000.00","0.00","","LE_2","","0","5","2024-03-17 04:13:44");
INSERT INTO tbl_purchase VALUES("1269","PUR170324106","","SU","42","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-03-17","","95000.00","0.00","","LE_2","","0","5","2024-03-17 04:18:39");
INSERT INTO tbl_purchase VALUES("1270","PUR170324107","","SU","47","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-03-17","","36000.00","0.00","","LE_2","","0","5","2024-03-17 05:50:51");
INSERT INTO tbl_purchase VALUES("1271","PUR180324101","","SU","50","0.00","11000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11000.00","0","","","2024-03-18","","11000.00","0.00","","LE_2","","0","5","2024-03-18 12:03:05");
INSERT INTO tbl_purchase VALUES("1272","PUR180324102","","SU","50","0.00","217000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","217000.00","0","","","2024-03-18","","217000.00","0.00","","LE_2","","0","5","2024-03-18 02:17:11");
INSERT INTO tbl_purchase VALUES("1273","PUR180324103","","SU","68","0.00","170500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","170500.00","0","","","2024-03-18","","170500.00","0.00","","LE_2","","0","5","2024-03-18 02:24:41");
INSERT INTO tbl_purchase VALUES("1274","PUR180324104","","SU","70","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2024-03-18","","52000.00","0.00","","LE_2","","0","5","2024-03-18 04:18:53");
INSERT INTO tbl_purchase VALUES("1275","PUR180324105","","SU","50","0.00","116000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116000.00","0","","","2024-03-18","","116000.00","0.00","","LE_2","","0","5","2024-03-18 06:09:56");
INSERT INTO tbl_purchase VALUES("1276","PUR180324106","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-03-18","","26000.00","0.00","","LE_2","","0","5","2024-03-18 07:05:14");
INSERT INTO tbl_purchase VALUES("1277","PUR200324101","","SU","68","0.00","79500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","79500.00","0","","","2024-03-20","","79500.00","0.00","","LE_2","","0","5","2024-03-20 11:31:26");
INSERT INTO tbl_purchase VALUES("1278","PUR200324102","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-03-20","","26000.00","0.00","","LE_2","","0","5","2024-03-20 12:02:39");
INSERT INTO tbl_purchase VALUES("1279","PUR200324103","","SU","68","0.00","111500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","111500.00","0","","","2024-03-20","","111500.00","0.00","","LE_2","","0","5","2024-03-20 04:57:50");
INSERT INTO tbl_purchase VALUES("1280","PUR200324104","","SU","64","0.00","133800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133800.00","0","","","2024-03-20","","133800.00","0.00","","LE_2","","0","5","2024-03-20 05:02:19");
INSERT INTO tbl_purchase VALUES("1281","PUR200324105","","SU","50","0.00","94000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","94000.00","0","","","2024-03-20","","94000.00","0.00","","LE_2","","0","5","2024-03-20 05:04:32");
INSERT INTO tbl_purchase VALUES("1282","PUR200324106","","SU","47","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-03-20","","18000.00","0.00","","LE_2","","0","5","2024-03-20 07:06:25");
INSERT INTO tbl_purchase VALUES("1283","PUR210324101","","SU","50","0.00","71000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","71000.00","0","","","2024-03-21","","71000.00","0.00","","LE_2","","0","5","2024-03-21 11:59:24");
INSERT INTO tbl_purchase VALUES("1284","PUR210324102","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-03-21","","26000.00","0.00","","LE_2","","0","5","2024-03-21 01:57:33");
INSERT INTO tbl_purchase VALUES("1285","PUR210324103","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-03-21","","26000.00","0.00","","LE_2","","0","5","2024-03-21 01:58:50");
INSERT INTO tbl_purchase VALUES("1286","PUR210324104","","SU","70","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2024-03-21","","78000.00","0.00","","LE_2","","0","5","2024-03-21 04:12:30");
INSERT INTO tbl_purchase VALUES("1287","PUR210324105","","SU","1","0.00","11000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11000.00","0","","","2024-03-21","","11000.00","0.00","","LE_2","","0","5","2024-03-21 04:40:04");
INSERT INTO tbl_purchase VALUES("1288","PUR220324101","","SU","50","0.00","189000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","189000.00","0","","","2024-03-22","","189000.00","0.00","","LE_2","","0","5","2024-03-22 11:35:33");
INSERT INTO tbl_purchase VALUES("1289","PUR220324102","","SU","50","0.00","215000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","215000.00","0","","","2024-03-22","","215000.00","0.00","","LE_2","","0","5","2024-03-22 07:04:02");
INSERT INTO tbl_purchase VALUES("1290","PUR220324103","","SU","14","0.00","39000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39000.00","0","","","2024-03-22","","39000.00","0.00","","LE_2","","0","5","2024-03-22 07:13:12");
INSERT INTO tbl_purchase VALUES("1291","PUR230324101","","SU","50","0.00","49000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49000.00","0","","","2024-03-23","","49000.00","0.00","","LE_2","","0","5","2024-03-23 12:33:00");
INSERT INTO tbl_purchase VALUES("1292","PUR230324102","","SU","50","0.00","179500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","179500.00","0","","","2024-03-23","","179500.00","0.00","","LE_2","","0","5","2024-03-23 02:07:46");
INSERT INTO tbl_purchase VALUES("1293","PUR240324101","","SU","50","0.00","532000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","532000.00","0","","charger: hp blue-21
hp big-8
dell-4","2024-03-24","","532000.00","0.00","","LE_2","","0","5","2024-03-24 04:24:14");
INSERT INTO tbl_purchase VALUES("1294","PUR250324101","","SU","50","0.00","99000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99000.00","0","","","2024-03-25","","99000.00","0.00","","LE_2","","0","5","2024-03-25 03:01:25");
INSERT INTO tbl_purchase VALUES("1295","PUR250324102","","SU","42","0.00","290000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","290000.00","0","","","2024-03-25","","290000.00","0.00","","LE_2","","0","5","2024-03-25 03:03:45");
INSERT INTO tbl_purchase VALUES("1296","PUR270324101","","SU","70","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2024-03-27","","33000.00","0.00","","LE_2","","0","5","2024-04-15 09:40:56");
INSERT INTO tbl_purchase VALUES("1297","PUR270324102","","SU","50","0.00","201000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","201000.00","0","","","2024-03-27","","201000.00","0.00","","LE_2","","0","5","2024-03-27 05:38:30");
INSERT INTO tbl_purchase VALUES("1298","PUR270324103","","SU","50","0.00","222000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","222000.00","0","","","2024-03-27","","222000.00","0.00","","LE_2","","0","5","2024-03-27 05:42:55");
INSERT INTO tbl_purchase VALUES("1299","PUR270324104","","SU","42","0.00","272500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","272500.00","0","","","2024-03-27","","272500.00","0.00","","LE_2","","0","5","2024-03-27 07:09:38");
INSERT INTO tbl_purchase VALUES("1300","PUR280324101","","SU","50","0.00","74000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74000.00","0","","","2024-03-28","","74000.00","0.00","","LE_2","","0","5","2024-03-28 02:34:14");
INSERT INTO tbl_purchase VALUES("1301","PUR280324102","","SU","1","0.00","1600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1600.00","0","","Ever green","2024-03-28","","1600.00","0.00","","LE_2","","0","5","2024-03-28 02:44:16");
INSERT INTO tbl_purchase VALUES("1302","PUR280324103","","SU","50","0.00","605000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","605000.00","0","","","2024-03-28","","605000.00","0.00","","LE_2","","0","5","2024-03-28 03:13:07");
INSERT INTO tbl_purchase VALUES("1303","PUR280324104","","SU","50","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-03-28","","19000.00","0.00","","LE_2","","0","5","2024-03-28 04:39:59");
INSERT INTO tbl_purchase VALUES("1304","PUR280324105","","SU","68","0.00","153000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","153000.00","0","","","2024-03-28","","153000.00","0.00","","LE_2","","0","5","2024-03-28 06:01:44");
INSERT INTO tbl_purchase VALUES("1305","PUR280324106","","SU","50","0.00","414000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","414000.00","0","","","2024-03-28","","414000.00","0.00","","LE_2","","0","5","2024-03-28 08:07:22");
INSERT INTO tbl_purchase VALUES("1306","PUR290324101","","SU","50","0.00","296000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","296000.00","0","","","2024-03-29","","296000.00","0.00","","LE_2","","0","5","2024-03-29 03:40:13");
INSERT INTO tbl_purchase VALUES("1307","PUR290324102","","SU","50","0.00","494000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","494000.00","0","","","2024-03-29","","494000.00","0.00","","LE_2","","0","5","2024-03-29 04:06:47");
INSERT INTO tbl_purchase VALUES("1308","PUR290324103","","SU","50","0.00","334000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","334000.00","0","","","2024-03-29","","334000.00","0.00","","LE_2","","0","5","2024-03-29 04:22:52");
INSERT INTO tbl_purchase VALUES("1309","PUR290324104","","SU","50","0.00","105500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105500.00","0","","","2024-03-29","","105500.00","0.00","","LE_2","","0","5","2024-03-29 04:38:08");
INSERT INTO tbl_purchase VALUES("1310","PUR290324105","","SU","50","0.00","66000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","66000.00","0","","","2024-03-29","","66000.00","0.00","","LE_2","","0","5","2024-03-29 04:42:11");
INSERT INTO tbl_purchase VALUES("1311","PUR290324106","","SU","50","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2024-03-29","","175000.00","0.00","","LE_2","","0","5","2024-03-29 04:46:22");
INSERT INTO tbl_purchase VALUES("1312","PUR290324107","","SU","50","0.00","32500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32500.00","0","","","2024-03-29","","32500.00","0.00","","LE_2","","0","5","2024-03-29 04:48:39");
INSERT INTO tbl_purchase VALUES("1313","PUR290324108","","SU","50","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2024-03-29","","48000.00","0.00","","LE_2","","0","5","2024-03-29 04:57:54");
INSERT INTO tbl_purchase VALUES("1314","PUR290324109","","SU","50","0.00","148000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","148000.00","0","","","2024-03-29","","148000.00","0.00","","LE_2","","0","5","2024-03-29 05:04:54");
INSERT INTO tbl_purchase VALUES("1315","PUR290324110","","SU","70","0.00","120000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120000.00","0","","","2024-03-29","","120000.00","0.00","","LE_2","","0","5","2024-03-29 05:34:30");
INSERT INTO tbl_purchase VALUES("1316","PUR290324111","","SU","1","0.00","81500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81500.00","0","","","2024-03-29","","81500.00","0.00","","LE_2","","0","5","2024-03-29 05:53:45");
INSERT INTO tbl_purchase VALUES("1317","PUR290324112","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-03-29","","26000.00","0.00","","LE_2","","0","5","2024-03-29 06:56:48");
INSERT INTO tbl_purchase VALUES("1318","PUR300324101","","SU","50","0.00","171000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171000.00","0","","","2024-03-30","","171000.00","0.00","","LE_2","","0","5","2024-03-30 05:54:04");
INSERT INTO tbl_purchase VALUES("1319","PUR300324102","","SU","50","0.00","312500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","312500.00","0","","","2024-03-30","","312500.00","0.00","","LE_2","","0","5","2024-03-30 07:18:50");
INSERT INTO tbl_purchase VALUES("1320","PUR300324103","","SU","1","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-03-30","","40000.00","0.00","","LE_2","","0","5","2024-03-30 08:52:21");
INSERT INTO tbl_purchase VALUES("1321","PUR310324101","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2024-03-31","2024-04-07","0.00","0.00","","LE_2","","0","5","2024-03-31 11:34:44");
INSERT INTO tbl_purchase VALUES("1322","PUR310324102","","SU","50","0.00","1709500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1709500.00","0","","HP blue-20 hp big-3 hp type c-2","2024-03-31","","1709500.00","0.00","","LE_2","","0","5","2024-03-31 05:23:42");
INSERT INTO tbl_purchase VALUES("1323","PUR010424101","","SU","50","0.00","237000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","237000.00","0","","","2024-04-01","","237000.00","0.00","","LE_2","","0","5","2024-04-01 12:45:31");
INSERT INTO tbl_purchase VALUES("1324","PUR010424102","","SU","68","0.00","188000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","188000.00","0","","","2024-04-01","","188000.00","0.00","","LE_2","","0","5","2024-04-01 03:26:10");
INSERT INTO tbl_purchase VALUES("1325","PUR010424103","","SU","50","0.00","282000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","282000.00","0","","","2024-04-01","","282000.00","0.00","","LE_2","","0","5","2024-04-01 05:27:00");
INSERT INTO tbl_purchase VALUES("1326","PUR010424104","","SU","13","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-04-01","","95000.00","0.00","","LE_2","","0","5","2024-04-01 06:00:38");
INSERT INTO tbl_purchase VALUES("1327","PUR020424101","","SU","50","0.00","557500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","557500.00","0","","","2024-04-02","","557500.00","0.00","","LE_2","","0","5","2024-04-02 02:33:24");
INSERT INTO tbl_purchase VALUES("1328","PUR020424102","","SU","13","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2024-04-02","","48000.00","0.00","","LE_2","","0","5","2024-04-02 05:53:43");
INSERT INTO tbl_purchase VALUES("1329","PUR030424101","","SU","50","0.00","519000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","519000.00","0","","","2024-04-03","","519000.00","0.00","","LE_2","","0","5","2024-04-03 02:55:33");
INSERT INTO tbl_purchase VALUES("1330","PUR030424102","","SU","68","0.00","108000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108000.00","0","","","2024-04-03","","108000.00","0.00","","LE_2","","0","5","2024-04-03 05:31:17");
INSERT INTO tbl_purchase VALUES("1331","PUR040424101","","SU","51","0.00","773000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","773000.00","0","","","2024-04-04","","773000.00","0.00","","LE_2","","0","5","2024-04-04 07:38:40");
INSERT INTO tbl_purchase VALUES("1332","PUR050424101","","SU","50","0.00","192000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","192000.00","0","","","2024-04-05","","192000.00","0.00","","LE_2","","0","5","2024-04-05 12:34:36");
INSERT INTO tbl_purchase VALUES("1333","PUR050424102","","SU","50","0.00","58000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58000.00","0","","","2024-04-05","","58000.00","0.00","","LE_2","","0","5","2024-04-05 12:49:35");
INSERT INTO tbl_purchase VALUES("1334","PUR050424103","","SU","50","0.00","139000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","139000.00","0","","","2024-04-05","","139000.00","0.00","","LE_2","","0","5","2024-04-05 02:51:36");
INSERT INTO tbl_purchase VALUES("1335","PUR070424101","","SU","50","0.00","660000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","660000.00","0","","","2024-04-07","","660000.00","0.00","","LE_2","","0","5","2024-04-07 01:23:06");
INSERT INTO tbl_purchase VALUES("1336","PUR070424102","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-04-07","","26000.00","0.00","","LE_2","","0","5","2024-04-07 03:19:53");
INSERT INTO tbl_purchase VALUES("1337","PUR070424103","","SU","50","0.00","234000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","234000.00","0","","","2024-04-07","","234000.00","0.00","","LE_2","","0","5","2024-04-07 04:29:15");
INSERT INTO tbl_purchase VALUES("1338","PUR080424101","","SU","50","0.00","215000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","215000.00","0","","","2024-04-08","","215000.00","0.00","","LE_2","","0","5","2024-04-08 02:08:26");
INSERT INTO tbl_purchase VALUES("1339","PUR080424102","","SU","50","0.00","302000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","302000.00","0","","","2024-04-08","","302000.00","0.00","","LE_2","","0","5","2024-04-08 07:24:28");
INSERT INTO tbl_purchase VALUES("1340","PUR080424103","","SU","51","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2024-04-08","","130000.00","0.00","","LE_2","","0","5","2024-04-08 07:30:08");
INSERT INTO tbl_purchase VALUES("1341","PUR170424101","","SU","68","0.00","448000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","448000.00","0","","","2024-04-17","","448000.00","0.00","","LE_2","","0","5","2024-04-17 07:32:36");
INSERT INTO tbl_purchase VALUES("1342","PUR170424102","","SU","50","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2024-04-17","","16500.00","0.00","","LE_2","","0","5","2024-04-17 07:33:42");
INSERT INTO tbl_purchase VALUES("1343","PUR170424103","","SU","50","0.00","333000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","333000.00","0","","","2024-04-17","","333000.00","0.00","","LE_2","","0","5","2024-04-17 07:41:04");
INSERT INTO tbl_purchase VALUES("1344","PUR180424101","","SU","70","0.00","338000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","338000.00","0","","One pc not entry soft..","2024-04-18","","338000.00","0.00","","LE_2","","0","5","2024-04-18 06:57:05");
INSERT INTO tbl_purchase VALUES("1345","PUR190424101","","SU","50","0.00","637500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","637500.00","0","","","2024-04-19","","637500.00","0.00","","LE_2","","0","5","2024-04-19 03:58:01");
INSERT INTO tbl_purchase VALUES("1346","PUR190424102","","SU","50","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2024-04-19","","33000.00","0.00","","LE_2","","0","5","2024-04-19 04:38:13");
INSERT INTO tbl_purchase VALUES("1347","PUR200424101","","SU","70","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-04-20","","26000.00","0.00","","LE_2","","0","5","2024-04-20 11:53:02");
INSERT INTO tbl_purchase VALUES("1348","PUR200424102","","SU","1","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","zoom","2024-04-20","","29000.00","0.00","","LE_2","","0","5","2024-04-20 01:06:46");
INSERT INTO tbl_purchase VALUES("1349","PUR200424103","","SU","68","0.00","171000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171000.00","0","","","2024-04-20","","171000.00","0.00","","LE_2","","0","5","2024-04-20 02:31:11");
INSERT INTO tbl_purchase VALUES("1352","PUR210424102","","SU","68","0.00","152000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152000.00","0","","","2024-04-21","","152000.00","0.00","","LE_2","","0","5","2024-04-21 12:30:10");
INSERT INTO tbl_purchase VALUES("1353","PUR210424103","","SU","29","0.00","9500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9500.00","0","","","2024-04-21","","9500.00","0.00","","LE_2","","0","5","2024-04-21 01:20:13");
INSERT INTO tbl_purchase VALUES("1354","PUR210424104","","SU","50","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2024-04-21","","65000.00","0.00","","LE_2","","0","5","2024-04-21 02:58:13");
INSERT INTO tbl_purchase VALUES("1355","PUR220424101","","SU","50","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2024-04-22","","52000.00","0.00","","LE_2","","0","5","2024-04-22 05:58:56");
INSERT INTO tbl_purchase VALUES("1356","PUR220424102","","SU","42","0.00","114000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114000.00","0","","","2024-04-22","","114000.00","0.00","","LE_2","","0","5","2024-04-22 12:09:04");
INSERT INTO tbl_purchase VALUES("1357","PUR220424103","","SU","50","0.00","706500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","706500.00","0","","","2024-04-22","","706500.00","0.00","","LE_2","","0","5","2024-04-22 03:18:07");
INSERT INTO tbl_purchase VALUES("1358","PUR220424104","","SU","51","0.00","125000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125000.00","0","","","2024-04-22","","125000.00","0.00","","LE_2","","0","5","2024-04-22 02:57:03");
INSERT INTO tbl_purchase VALUES("1359","PUR220424105","","SU","68","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2024-04-22","","133000.00","0.00","","LE_2","","0","5","2024-04-22 03:00:47");
INSERT INTO tbl_purchase VALUES("1360","PUR220424106","","SU","50","0.00","104000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104000.00","0","","","2024-04-21","","104000.00","0.00","","LE_2","","0","5","2024-04-22 06:05:54");
INSERT INTO tbl_purchase VALUES("1361","PUR220424107","","SU","1","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-04-22","","40000.00","0.00","","LE_2","","0","5","2024-04-22 06:59:58");
INSERT INTO tbl_purchase VALUES("1362","PUR220424108","","SU","50","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2024-04-22","","33000.00","0.00","","LE_2","","0","5","2024-04-22 07:28:12");
INSERT INTO tbl_purchase VALUES("1363","PUR220424109","","SU","70","0.00","104000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104000.00","0","","","2024-04-22","","104000.00","0.00","","LE_2","","0","5","2024-04-22 07:43:51");
INSERT INTO tbl_purchase VALUES("1364","PUR240424101","","SU","50","0.00","287000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","287000.00","0","","","2024-04-24","","287000.00","0.00","","LE_2","","0","5","2024-04-24 11:59:20");
INSERT INTO tbl_purchase VALUES("1365","PUR240424102","","SU","50","0.00","737500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","737500.00","0","","hp-40
hp big-1
suface-3","2024-04-24","","737500.00","0.00","","LE_2","","0","5","2024-04-24 06:29:29");
INSERT INTO tbl_purchase VALUES("1366","PUR240424103","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-04-24","","26000.00","0.00","","LE_2","","0","5","2024-04-24 06:31:00");
INSERT INTO tbl_purchase VALUES("1367","PUR240424104","","SU","29","0.00","4200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4200.00","0","","","2024-04-24","2024-05-01","0.00","0.00","","LE_2","","0","5","2024-04-24 07:20:35");
INSERT INTO tbl_purchase VALUES("1368","PUR250424101","","SU","50","0.00","362000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","362000.00","0","","","2024-04-25","","362000.00","0.00","","LE_2","","0","5","2024-04-25 05:23:04");
INSERT INTO tbl_purchase VALUES("1369","PUR250424102","","SU","68","0.00","198500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","198500.00","0","","","2024-04-25","","198500.00","0.00","","LE_2","","0","5","2024-04-25 05:32:11");
INSERT INTO tbl_purchase VALUES("1370","PUR250424103","","SU","42","0.00","135000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135000.00","0","","","2024-04-25","","135000.00","0.00","","LE_2","","0","5","2024-04-25 07:23:28");
INSERT INTO tbl_purchase VALUES("1371","PUR270424101","","SU","51","0.00","359500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","359500.00","0","","","2024-04-27","","359500.00","0.00","","LE_2","","0","5","2024-04-27 05:52:36");
INSERT INTO tbl_purchase VALUES("1372","PUR270424102","","SU","50","0.00","120000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120000.00","0","","","2024-04-27","","120000.00","0.00","","LE_2","","0","5","2024-04-27 07:22:53");
INSERT INTO tbl_purchase VALUES("1373","PUR280424101","","SU","50","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-04-28","","40000.00","0.00","","LE_2","","0","5","2024-04-28 01:58:57");
INSERT INTO tbl_purchase VALUES("1374","PUR280424102","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-04-28","","26000.00","0.00","","LE_2","","0","5","2024-04-28 02:05:22");
INSERT INTO tbl_purchase VALUES("1375","PUR280424103","","SU","1","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2024-04-28","","60000.00","0.00","","LE_2","","0","5","2024-04-28 02:22:27");
INSERT INTO tbl_purchase VALUES("1376","PUR280424104","","SU","68","0.00","201000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","201000.00","0","","","2024-04-28","","201000.00","0.00","","LE_2","","0","5","2024-04-28 02:48:56");
INSERT INTO tbl_purchase VALUES("1377","PUR290424101","","SU","50","0.00","112000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112000.00","0","","","2024-04-29","","112000.00","0.00","","LE_2","","0","5","2024-04-29 05:13:21");
INSERT INTO tbl_purchase VALUES("1378","PUR290424102","","SU","1","0.00","61400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61400.00","0","","","2024-04-29","","61400.00","0.00","","LE_2","","0","5","2024-04-29 02:02:07");
INSERT INTO tbl_purchase VALUES("1379","PUR290424103","","SU","50","0.00","154000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","154000.00","0","","","2024-04-29","","154000.00","0.00","","LE_2","","0","5","2024-04-29 07:30:20");
INSERT INTO tbl_purchase VALUES("1380","PUR020524101","","SU","68","0.00","233000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","233000.00","0","","","2024-05-02","","233000.00","0.00","","LE_2","","0","5","2024-05-02 07:17:03");
INSERT INTO tbl_purchase VALUES("1381","PUR030524101","","SU","50","0.00","164000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164000.00","0","","","2024-05-03","2024-05-10","0.00","0.00","","LE_2","","0","5","2024-05-03 07:47:48");
INSERT INTO tbl_purchase VALUES("1382","PUR030524102","","SU","50","0.00","1179500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1179500.00","0","","","2024-05-03","","1179500.00","0.00","","LE_2","","0","5","2024-05-03 07:13:37");
INSERT INTO tbl_purchase VALUES("1383","PUR040524101","","SU","68","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2024-05-04","","57000.00","0.00","","LE_2","","0","5","2024-05-04 03:13:22");
INSERT INTO tbl_purchase VALUES("1385","PUR040524103","","SU","42","0.00","418000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","418000.00","0","","","2024-05-04","","418000.00","0.00","","LE_2","","0","5","2024-05-04 04:31:40");
INSERT INTO tbl_purchase VALUES("1386","PUR040524104","","SU","70","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2024-05-04","","25000.00","0.00","","LE_2","","0","5","2024-05-04 05:00:43");
INSERT INTO tbl_purchase VALUES("1387","PUR040524105","","SU","50","0.00","350000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350000.00","0","","","2024-05-04","","350000.00","0.00","","LE_2","","0","5","2024-05-04 06:16:36");
INSERT INTO tbl_purchase VALUES("1388","PUR050524101","","SU","68","0.00","277000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","277000.00","0","","","2024-05-05","","277000.00","0.00","","LE_2","","0","5","2024-05-05 02:10:26");
INSERT INTO tbl_purchase VALUES("1389","PUR050524102","","SU","50","0.00","9500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9500.00","0","","","2024-05-05","","9500.00","0.00","","LE_2","","0","5","2024-05-05 02:55:50");
INSERT INTO tbl_purchase VALUES("1391","PUR060524101","","SU","50","0.00","544000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","544000.00","0","","","2024-05-06","","544000.00","0.00","","LE_2","","0","5","2024-05-06 08:15:10");
INSERT INTO tbl_purchase VALUES("1392","PUR060524102","","SU","50","0.00","369500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","369500.00","0","","","2024-05-06","2024-05-13","0.00","0.00","","LE_2","","0","5","2024-05-06 08:10:58");
INSERT INTO tbl_purchase VALUES("1393","PUR080524101","","SU","1","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2024-05-08","","38000.00","0.00","","LE_2","","0","5","2024-05-08 12:28:38");
INSERT INTO tbl_purchase VALUES("1394","PUR080524102","","SU","50","0.00","285500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285500.00","0","","","2024-05-08","","285500.00","0.00","","LE_2","","0","5","2024-05-08 02:22:03");
INSERT INTO tbl_purchase VALUES("1395","PUR080524103","","SU","68","0.00","254000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","254000.00","0","","","2024-05-08","","254000.00","0.00","","LE_2","","0","5","2024-05-08 04:39:54");
INSERT INTO tbl_purchase VALUES("1396","PUR080524104","","SU","51","0.00","37500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37500.00","0","","","2024-05-08","","37500.00","0.00","","LE_2","","0","5","2024-05-08 04:10:16");
INSERT INTO tbl_purchase VALUES("1397","PUR080524105","","SU","50","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2024-05-08","","24000.00","0.00","","LE_2","","0","5","2024-05-08 04:41:33");
INSERT INTO tbl_purchase VALUES("1398","PUR090524101","","SU","50","0.00","552750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","552750.00","0","","","2024-05-09","","552750.00","0.00","","LE_2","","0","5","2024-05-09 01:20:29");
INSERT INTO tbl_purchase VALUES("1399","PUR090524102","","SU","42","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-05-09","","95000.00","0.00","","LE_2","","0","5","2024-05-10 12:16:49");
INSERT INTO tbl_purchase VALUES("1400","PUR100524101","","SU","50","0.00","274250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","274250.00","0","","","2024-05-10","","274250.00","0.00","","LE_2","","0","5","2024-05-10 03:27:19");
INSERT INTO tbl_purchase VALUES("1401","PUR100524102","","SU","50","0.00","418500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","418500.00","0","","","2024-05-10","","418500.00","0.00","","LE_2","","0","5","2024-05-10 07:40:23");
INSERT INTO tbl_purchase VALUES("1402","PUR110524101","","SU","50","0.00","132500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","132500.00","0","","","2024-05-11","","132500.00","0.00","","LE_2","","0","5","2024-05-11 04:38:02");
INSERT INTO tbl_purchase VALUES("1403","PUR120524101","","SU","50","0.00","527250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","527250.00","0","","","2024-05-12","","527250.00","0.00","","LE_2","","0","5","2024-05-12 05:06:41");
INSERT INTO tbl_purchase VALUES("1404","PUR130524101","","SU","68","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2024-05-13","","20000.00","0.00","","LE_2","","0","5","2024-05-13 01:51:32");
INSERT INTO tbl_purchase VALUES("1405","PUR130524102","","SU","1","0.00","3000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3000.00","0","","","2024-05-13","","3000.00","0.00","","LE_2","","0","5","2024-05-13 01:58:35");
INSERT INTO tbl_purchase VALUES("1406","PUR130524103","","SU","50","0.00","99300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99300.00","0","","","2024-05-13","","99300.00","0.00","","LE_2","","0","5","2024-05-13 02:40:33");
INSERT INTO tbl_purchase VALUES("1407","PUR130524104","","SU","68","0.00","636500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","636500.00","0","","charger-6pcs","2024-05-13","","636500.00","0.00","","LE_2","","0","5","2024-05-13 05:11:02");
INSERT INTO tbl_purchase VALUES("1408","PUR150524101","","SU","50","0.00","458500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","458500.00","0","","","2024-05-15","","458500.00","0.00","","LE_2","","0","5","2024-05-15 06:42:52");
INSERT INTO tbl_purchase VALUES("1409","PUR150524102","","SU","50","0.00","310000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","310000.00","0","","","2024-05-15","","310000.00","0.00","","LE_2","","0","5","2024-05-15 03:05:34");
INSERT INTO tbl_purchase VALUES("1410","PUR150524103","","SU","50","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2024-05-15","","75000.00","0.00","","LE_2","","0","5","2024-05-15 06:28:23");
INSERT INTO tbl_purchase VALUES("1411","PUR150524104","","SU","68","0.00","221000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","221000.00","0","","","2024-05-15","","221000.00","0.00","","LE_2","","0","5","2024-05-15 06:34:08");
INSERT INTO tbl_purchase VALUES("1412","PUR150524105","","SU","42","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-05-15","","95000.00","0.00","","LE_2","","0","5","2024-05-15 06:36:30");
INSERT INTO tbl_purchase VALUES("1413","PUR150524106","","SU","50","0.00","404000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","404000.00","0","","","2024-05-15","","404000.00","0.00","","LE_2","","0","5","2024-05-15 06:52:26");
INSERT INTO tbl_purchase VALUES("1414","PUR160524101","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-05-16","","26000.00","0.00","","LE_2","","0","5","2024-05-16 02:15:12");
INSERT INTO tbl_purchase VALUES("1415","PUR160524102","","SU","50","0.00","147000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","147000.00","0","","","2024-05-16","","147000.00","0.00","","LE_2","","0","5","2024-05-16 04:46:48");
INSERT INTO tbl_purchase VALUES("1416","PUR160524103","","SU","42","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-05-16","","95000.00","0.00","","LE_2","","0","5","2024-05-16 05:41:10");
INSERT INTO tbl_purchase VALUES("1417","PUR160524104","","SU","68","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2024-05-16","","24000.00","0.00","","LE_2","","0","5","2024-05-16 06:30:34");
INSERT INTO tbl_purchase VALUES("1418","PUR170524101","","SU","50","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-05-17","","36000.00","0.00","","LE_2","","0","5","2024-05-17 03:34:09");
INSERT INTO tbl_purchase VALUES("1419","PUR170524102","","SU","1","0.00","35500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35500.00","0","","","2024-05-17","","35500.00","0.00","","LE_2","","0","5","2024-05-17 03:55:36");
INSERT INTO tbl_purchase VALUES("1420","PUR170524103","","SU","50","0.00","520500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","520500.00","0","","","2024-05-17","2024-05-24","0.00","0.00","","LE_2","","0","5","2024-05-17 07:39:55");
INSERT INTO tbl_purchase VALUES("1421","PUR180524101","","SU","68","0.00","186000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","186000.00","0","","","2024-05-18","","186000.00","0.00","","LE_2","","0","5","2024-05-18 02:50:11");
INSERT INTO tbl_purchase VALUES("1422","PUR190524101","","SU","50","0.00","652250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","652250.00","0","","","2024-05-19","","652250.00","0.00","","LE_2","","0","5","2024-05-19 06:22:47");
INSERT INTO tbl_purchase VALUES("1423","PUR200524101","","SU","1","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","Charger with Full Box","2024-05-20","","70000.00","0.00","","LE_2","","0","5","2024-05-20 04:26:25");
INSERT INTO tbl_purchase VALUES("1424","PUR230524101","","SU","50","0.00","61500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61500.00","0","","","2024-05-23","","61500.00","0.00","","LE_2","","0","5","2024-05-23 04:16:40");
INSERT INTO tbl_purchase VALUES("1425","PUR240524101","","SU","1","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2024-05-24","","30000.00","0.00","","LE_2","","0","5","2024-05-24 03:27:37");
INSERT INTO tbl_purchase VALUES("1426","PUR250524101","","SU","68","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2024-05-25","","38000.00","0.00","","LE_2","","0","5","2024-05-25 05:32:25");
INSERT INTO tbl_purchase VALUES("1427","PUR250524102","","SU","68","0.00","568000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","568000.00","0","","","2024-05-25","","568000.00","0.00","","LE_2","","0","5","2024-05-25 06:34:32");
INSERT INTO tbl_purchase VALUES("1428","PUR260524101","","SU","50","0.00","496500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","496500.00","0","","","2024-05-26","","496500.00","0.00","","LE_2","","0","5","2024-05-26 04:04:23");
INSERT INTO tbl_purchase VALUES("1429","PUR270524101","","SU","50","0.00","117000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","117000.00","0","","","2024-05-27","","117000.00","0.00","","LE_2","","0","5","2024-05-27 06:42:46");
INSERT INTO tbl_purchase VALUES("1430","PUR270524102","","SU","68","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2024-05-27","","126000.00","0.00","","LE_2","","0","5","2024-05-27 06:45:24");
INSERT INTO tbl_purchase VALUES("1431","PUR290524101","","SU","50","0.00","588800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","588800.00","0","","","2024-05-29","","588800.00","0.00","","LE_2","","0","5","2024-05-29 08:08:43");
INSERT INTO tbl_purchase VALUES("1432","PUR290524102","","SU","42","0.00","167500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","167500.00","0","","","2024-05-29","","167500.00","0.00","","LE_2","","0","5","2024-05-29 03:56:07");
INSERT INTO tbl_purchase VALUES("1433","PUR290524103","","SU","68","0.00","217000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","217000.00","0","","","2024-05-29","","217000.00","0.00","","LE_2","","0","5","2024-05-29 04:03:00");
INSERT INTO tbl_purchase VALUES("1434","PUR290524104","","SU","1","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","","2024-05-29","","70000.00","0.00","","LE_2","","0","5","2024-05-29 07:00:56");
INSERT INTO tbl_purchase VALUES("1435","PUR290524105","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-05-29","","26000.00","0.00","","LE_2","","0","5","2024-05-29 07:43:12");
INSERT INTO tbl_purchase VALUES("1436","PUR300524101","","SU","50","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2024-05-30","","24000.00","0.00","","LE_2","","0","5","2024-05-30 03:21:55");
INSERT INTO tbl_purchase VALUES("1437","PUR300524102","","SU","50","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2024-05-30","","51000.00","0.00","","LE_2","","0","5","2024-05-30 07:03:39");
INSERT INTO tbl_purchase VALUES("1439","PUR310524101","","SU","50","0.00","229800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","229800.00","0","","","2024-05-31","","229800.00","0.00","","LE_2","","0","5","2024-05-31 04:53:32");
INSERT INTO tbl_purchase VALUES("1440","PUR310524102","","SU","68","0.00","198000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","198000.00","0","","","2024-05-31","","198000.00","0.00","","LE_2","","0","5","2024-05-31 04:33:13");
INSERT INTO tbl_purchase VALUES("1441","PUR010624101","","SU","29","0.00","84000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84000.00","0","","","2024-06-01","","84000.00","0.00","","LE_2","","0","5","2024-06-01 04:48:28");
INSERT INTO tbl_purchase VALUES("1442","PUR010624102","","SU","50","0.00","71000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","71000.00","0","","","2024-06-01","","71000.00","0.00","","LE_2","","0","5","2024-06-01 04:58:18");
INSERT INTO tbl_purchase VALUES("1443","PUR010624103","","SU","68","0.00","218500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","218500.00","0","","","2024-06-01","","218500.00","0.00","","LE_2","","0","5","2024-06-01 07:13:47");
INSERT INTO tbl_purchase VALUES("1444","PUR020624101","","SU","50","0.00","1201600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1201600.00","0","","","2024-06-02","","1201600.00","0.00","","LE_2","","0","5","2024-06-02 02:36:38");
INSERT INTO tbl_purchase VALUES("1445","PUR020624102","","SU","50","0.00","328300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","328300.00","0","","","2024-06-02","","328300.00","0.00","","LE_2","","0","5","2024-06-02 06:03:15");
INSERT INTO tbl_purchase VALUES("1446","PUR020624103","","SU","1","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2024-06-02","","29000.00","0.00","","LE_2","","0","5","2024-06-02 08:24:05");
INSERT INTO tbl_purchase VALUES("1447","PUR030624101","","SU","50","0.00","103500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103500.00","0","","","2024-06-03","2024-06-10","0.00","0.00","","LE_2","","0","5","2024-06-03 07:16:05");
INSERT INTO tbl_purchase VALUES("1448","PUR050624101","","SU","50","0.00","235000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","235000.00","0","","","2024-06-05","2024-06-12","0.00","0.00","","LE_2","","0","5","2024-06-05 03:03:52");
INSERT INTO tbl_purchase VALUES("1449","PUR070624101","","SU","50","0.00","945000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","945000.00","0","","","2024-06-07","","945000.00","0.00","","LE_2","","0","5","2024-06-07 02:22:03");
INSERT INTO tbl_purchase VALUES("1450","PUR100624101","","SU","50","0.00","678000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","678000.00","0","","","2024-06-10","","978000.00","300000.00","","LE_2","","0","5","2024-06-10 12:31:18");
INSERT INTO tbl_purchase VALUES("1451","PUR100624102","","SU","1","0.00","67000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67000.00","0","","","2024-06-10","","67000.00","0.00","","LE_2","","0","5","2024-06-10 05:25:57");
INSERT INTO tbl_purchase VALUES("1452","PUR100624103","","SU","1","0.00","1541000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1541000.00","0","","bag","2024-06-10","","1541000.00","0.00","","LE_2","","0","5","2024-06-10 06:03:27");
INSERT INTO tbl_purchase VALUES("1453","PUR110624101","","SU","50","0.00","452000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","452000.00","0","","","2024-06-11","","452000.00","0.00","","LE_2","","0","5","2024-06-11 02:59:08");
INSERT INTO tbl_purchase VALUES("1454","PUR110624102","","SU","1","0.00","2000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2000.00","0","","","2024-06-11","","2000.00","0.00","","LE_2","","0","5","2024-06-11 07:31:43");
INSERT INTO tbl_purchase VALUES("1455","PUR110624103","","SU","1","0.00","384000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","384000.00","0","","","2024-06-11","","384000.00","0.00","","LE_2","","0","5","2024-06-11 07:38:46");
INSERT INTO tbl_purchase VALUES("1456","PUR130624101","","SU","50","0.00","421000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","421000.00","0","","","2024-06-13","","421000.00","0.00","","LE_2","","0","5","2024-06-13 02:02:01");
INSERT INTO tbl_purchase VALUES("1457","PUR130624102","","SU","50","0.00","527000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","527000.00","0","","","2024-06-13","","527000.00","0.00","","LE_2","","0","5","2024-06-13 06:29:09");
INSERT INTO tbl_purchase VALUES("1458","PUR230624101","","SU","50","0.00","1115900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1115900.00","0","","","2024-06-23","","1115900.00","0.00","","LE_2","","0","5","2024-06-23 01:59:17");
INSERT INTO tbl_purchase VALUES("1459","PUR240624101","","SU","68","0.00","1243500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1243500.00","0","","","2024-06-24","","1243500.00","0.00","","LE_2","","0","5","2024-06-24 06:53:58");
INSERT INTO tbl_purchase VALUES("1460","PUR270624101","","SU","50","0.00","457100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","457100.00","0","","","2024-06-27","","457100.00","0.00","","LE_2","","0","5","2024-06-27 02:25:39");
INSERT INTO tbl_purchase VALUES("1461","PUR280624101","","SU","50","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-06-28","2024-07-05","0.00","0.00","","LE_2","","0","5","2024-06-28 11:59:47");
INSERT INTO tbl_purchase VALUES("1462","PUR280624102","","SU","50","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-06-28","","95000.00","0.00","","LE_2","","0","5","2024-06-28 12:03:32");
INSERT INTO tbl_purchase VALUES("1463","PUR280624103","","SU","50","0.00","589500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","589500.00","0","","","2024-06-28","","589500.00","0.00","","LE_2","","0","5","2024-06-28 12:28:53");
INSERT INTO tbl_purchase VALUES("1464","PUR300624101","","SU","50","0.00","285000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","285000.00","0","","","2024-06-30","","285000.00","0.00","","LE_2","","0","5","2024-06-30 07:41:11");
INSERT INTO tbl_purchase VALUES("1465","PUR030724101","","SU","50","0.00","786000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","786000.00","0","","","2024-07-03","","786000.00","0.00","","LE_2","","0","5","2024-07-03 01:42:58");
INSERT INTO tbl_purchase VALUES("1466","PUR050724101","","SU","50","0.00","389500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","389500.00","0","","","2024-07-05","","389500.00","0.00","","LE_2","","0","5","2024-07-05 11:50:32");
INSERT INTO tbl_purchase VALUES("1467","PUR050724102","","SU","68","0.00","467000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","467000.00","0","","","2024-07-05","","467000.00","0.00","","LE_2","","0","5","2024-07-05 08:00:12");
INSERT INTO tbl_purchase VALUES("1468","PUR050724103","","SU","50","0.00","443000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","443000.00","0","","","2024-07-05","","443000.00","0.00","","LE_2","","0","5","2024-07-05 08:11:19");
INSERT INTO tbl_purchase VALUES("1469","PUR060724101","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2024-07-06","","17500.00","0.00","","LE_2","","0","5","2024-07-06 12:46:12");
INSERT INTO tbl_purchase VALUES("1470","PUR060724102","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2024-07-06","","17500.00","0.00","","LE_2","","0","5","2024-07-06 02:06:11");
INSERT INTO tbl_purchase VALUES("1471","PUR060724103","","SU","68","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2024-07-06","","51000.00","0.00","","LE_2","","0","5","2024-07-06 05:02:30");
INSERT INTO tbl_purchase VALUES("1472","PUR060724104","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2024-07-06","","17500.00","0.00","","LE_2","","0","5","2024-07-06 06:07:45");
INSERT INTO tbl_purchase VALUES("1473","PUR070724101","","SU","50","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2024-07-07","","48000.00","0.00","","LE_2","","0","5","2024-07-07 12:35:24");
INSERT INTO tbl_purchase VALUES("1474","PUR070724102","","SU","50","0.00","548500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","548500.00","0","","","2024-07-07","","548500.00","0.00","","LE_2","","0","5","2024-07-07 06:33:59");
INSERT INTO tbl_purchase VALUES("1475","PUR100724101","","SU","50","0.00","145500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","145500.00","0","","","2024-07-10","","145500.00","0.00","","LE_2","","0","5","2024-07-10 11:44:59");
INSERT INTO tbl_purchase VALUES("1476","PUR110724101","","SU","50","0.00","67500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67500.00","0","","","2024-07-11","","67500.00","0.00","","LE_2","","0","5","2024-07-11 02:17:51");
INSERT INTO tbl_purchase VALUES("1477","PUR110724102","","SU","50","0.00","615500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","615500.00","0","","","2024-07-11","","615500.00","0.00","","LE_2","","0","5","2024-07-11 02:43:49");
INSERT INTO tbl_purchase VALUES("1478","PUR120724101","","SU","50","0.00","22500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22500.00","0","","","2024-07-12","","22500.00","0.00","","LE_2","","0","5","2024-07-12 04:33:18");
INSERT INTO tbl_purchase VALUES("1479","PUR120724102","","SU","50","0.00","96000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96000.00","0","","","2024-07-12","","96000.00","0.00","","LE_2","","0","5","2024-07-12 06:21:17");
INSERT INTO tbl_purchase VALUES("1480","PUR140724101","","SU","50","0.00","897000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","897000.00","0","","","2024-07-14","","897000.00","0.00","","LE_2","","0","5","2024-07-14 12:10:17");
INSERT INTO tbl_purchase VALUES("1481","PUR170724101","","SU","50","0.00","145000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","145000.00","0","","","2024-07-17","","145000.00","0.00","","LE_2","","0","5","2024-07-17 01:55:46");
INSERT INTO tbl_purchase VALUES("1482","PUR240724101","","SU","50","0.00","165500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165500.00","0","","","2024-07-24","","165500.00","0.00","","LE_2","","0","5","2024-07-24 01:04:45");
INSERT INTO tbl_purchase VALUES("1483","PUR250724101","","SU","1","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2024-07-25","2024-08-01","0.00","0.00","","LE_2","","0","5","2024-07-25 01:22:50");
INSERT INTO tbl_purchase VALUES("1484","PUR260724101","","SU","50","0.00","137000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","137000.00","0","","","2024-07-26","","137000.00","0.00","","LE_2","","0","5","2024-07-26 12:47:43");
INSERT INTO tbl_purchase VALUES("1485","PUR270724101","","SU","1","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2024-07-27","2024-08-03","0.00","0.00","","LE_2","","0","5","2024-07-27 02:24:22");
INSERT INTO tbl_purchase VALUES("1486","PUR290724101","","SU","1","0.00","88000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88000.00","0","","","2024-07-29","","88000.00","0.00","","LE_2","","0","5","2024-07-29 01:02:57");
INSERT INTO tbl_purchase VALUES("1487","PUR290724102","","SU","50","0.00","698500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","698500.00","0","","","2024-07-29","","698500.00","0.00","","LE_2","","0","5","2024-07-29 01:11:48");
INSERT INTO tbl_purchase VALUES("1488","PUR300724101","","SU","1","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-07-30","","40000.00","0.00","","LE_2","","0","5","2024-07-30 03:00:26");
INSERT INTO tbl_purchase VALUES("1489","PUR310724101","","SU","1","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2024-07-31","","80000.00","0.00","","LE_2","","0","5","2024-07-31 05:52:35");
INSERT INTO tbl_purchase VALUES("1490","PUR010824101","","SU","50","0.00","241500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","241500.00","0","","","2024-08-01","","241500.00","0.00","","LE_2","","0","5","2024-08-01 05:53:35");
INSERT INTO tbl_purchase VALUES("1491","PUR020824101","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","Ever green Anis vai","2024-08-02","","26000.00","0.00","","LE_2","","0","5","2024-08-02 07:48:59");
INSERT INTO tbl_purchase VALUES("1492","PUR030824101","","SU","1","0.00","29000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29000.00","0","","","2024-08-03","","29000.00","0.00","","LE_2","","0","5","2024-08-03 04:19:53");
INSERT INTO tbl_purchase VALUES("1493","PUR110824101","","SU","50","0.00","509500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","509500.00","0","","","2024-08-11","","509500.00","0.00","","LE_2","","0","5","2024-08-11 11:43:25");
INSERT INTO tbl_purchase VALUES("1494","PUR110824102","","SU","50","0.00","679000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","679000.00","0","","","2024-08-11","","679000.00","0.00","","LE_2","","0","5","2024-08-12 11:51:56");
INSERT INTO tbl_purchase VALUES("1495","PUR140824101","","SU","1","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2024-08-14","","25000.00","0.00","","LE_2","","0","5","2024-08-14 05:55:15");
INSERT INTO tbl_purchase VALUES("1496","PUR170824101","","SU","64","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2024-08-17","2024-08-24","0.00","0.00","","LE_2","","0","5","2024-08-17 02:32:04");
INSERT INTO tbl_purchase VALUES("1497","PUR170824102","","SU","1","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2024-08-17","","21000.00","0.00","","LE_2","","0","5","2024-08-17 07:09:41");
INSERT INTO tbl_purchase VALUES("1498","PUR180824101","","SU","50","0.00","231000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","231000.00","0","","","2024-08-18","","231000.00","0.00","","LE_2","","0","5","2024-08-18 06:04:49");
INSERT INTO tbl_purchase VALUES("1499","PUR190824101","","SU","50","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2024-08-19","2024-08-26","0.00","0.00","","LE_2","","0","5","2024-08-19 07:25:33");
INSERT INTO tbl_purchase VALUES("1500","PUR210824101","","SU","1","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-08-21","","40000.00","0.00","","LE_2","","0","5","2024-08-21 11:31:17");
INSERT INTO tbl_purchase VALUES("1501","PUR220824101","","SU","14","0.00","129000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129000.00","0","","","2024-08-22","","129000.00","0.00","","LE_2","","0","5","2024-08-22 02:20:25");
INSERT INTO tbl_purchase VALUES("1502","PUR220824102","","SU","1","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-08-22","","40000.00","0.00","","LE_2","","0","5","2024-08-22 05:34:58");
INSERT INTO tbl_purchase VALUES("1503","PUR230824101","","SU","14","0.00","97000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","97000.00","0","","","2024-08-23","","97000.00","0.00","","LE_2","","0","5","2024-08-23 12:36:10");
INSERT INTO tbl_purchase VALUES("1504","PUR250824101","","SU","50","0.00","77500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77500.00","0","","","2024-08-25","","77500.00","0.00","","LE_2","","0","5","2024-08-25 06:24:50");
INSERT INTO tbl_purchase VALUES("1505","PUR250824102","","SU","42","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2024-08-25","","126000.00","0.00","","LE_2","","0","5","2024-08-25 06:31:33");
INSERT INTO tbl_purchase VALUES("1506","PUR250824103","","SU","50","0.00","733500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","733500.00","0","","","2024-08-25","","733500.00","0.00","","LE_2","","0","5","2024-08-25 07:12:33");
INSERT INTO tbl_purchase VALUES("1507","PUR250824104","","SU","3","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2024-08-25","2024-09-01","20000.00","0.00","","LE_2","","0","5","2024-08-25 07:42:54");
INSERT INTO tbl_purchase VALUES("1508","PUR260824101","","SU","1","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2024-08-26","","17000.00","0.00","","LE_2","","0","5","2024-08-26 03:29:37");
INSERT INTO tbl_purchase VALUES("1509","PUR260824102","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2024-08-26","","20000.00","0.00","","LE_2","","0","5","2024-08-26 07:38:28");
INSERT INTO tbl_purchase VALUES("1510","PUR280824101","","SU","50","0.00","178000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","178000.00","0","","","2024-08-28","","178000.00","0.00","","LE_2","","0","5","2024-08-28 04:19:49");
INSERT INTO tbl_purchase VALUES("1511","PUR280824102","","SU","50","0.00","557000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","557000.00","0","","","2024-08-28","","557000.00","0.00","","LE_2","","0","5","2024-08-28 04:37:00");
INSERT INTO tbl_purchase VALUES("1512","PUR280824103","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","","2024-08-28","","20000.00","0.00","","LE_2","","0","5","2024-08-28 08:02:51");
INSERT INTO tbl_purchase VALUES("1513","PUR290824101","","SU","42","0.00","199000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","199000.00","0","","","2024-08-29","","199000.00","0.00","","LE_2","","0","5","2024-08-29 04:26:51");
INSERT INTO tbl_purchase VALUES("1514","PUR300824101","","SU","50","0.00","438500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","438500.00","0","","","2024-08-30","","438500.00","0.00","","LE_2","","0","5","2024-08-30 12:19:52");
INSERT INTO tbl_purchase VALUES("1515","PUR300824102","","SU","50","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2024-08-30","2024-09-06","0.00","0.00","","LE_2","","0","5","2024-08-30 07:17:14");
INSERT INTO tbl_purchase VALUES("1516","PUR300824103","","SU","1","0.00","20000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20000.00","0","","Adjust","2024-08-30","","20000.00","0.00","","LE_2","","0","5","2024-08-30 07:48:31");
INSERT INTO tbl_purchase VALUES("1517","PUR310824101","","SU","14","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2024-08-31","","57000.00","0.00","","LE_2","","0","5","2024-08-31 01:51:29");
INSERT INTO tbl_purchase VALUES("1518","PUR010924101","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-09-01","","26000.00","0.00","","LE_2","","0","5","2024-09-01 11:01:58");
INSERT INTO tbl_purchase VALUES("1519","PUR010924102","","SU","1","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2024-09-01","","15000.00","0.00","","LE_2","","0","5","2024-09-01 08:06:18");
INSERT INTO tbl_purchase VALUES("1520","PUR020924101","","SU","50","0.00","400000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","400000.00","0","","","2024-09-02","","400000.00","0.00","","LE_2","","0","5","2024-09-02 04:35:44");
INSERT INTO tbl_purchase VALUES("1521","PUR040924101","","SU","50","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2024-09-04","","34000.00","0.00","","LE_2","","0","5","2024-09-04 05:51:25");
INSERT INTO tbl_purchase VALUES("1522","PUR040924102","","SU","14","0.00","157000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","157000.00","0","","","2024-09-04","","157000.00","0.00","","LE_2","","0","5","2024-09-04 04:26:14");
INSERT INTO tbl_purchase VALUES("1523","PUR040924103","","SU","50","0.00","327000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","327000.00","0","","","2024-09-04","","327000.00","0.00","","LE_2","","0","5","2024-09-04 07:38:48");
INSERT INTO tbl_purchase VALUES("1524","PUR050924101","","SU","50","0.00","180000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180000.00","0","","","2024-09-05","","180000.00","0.00","","LE_2","","0","5","2024-09-05 11:42:22");
INSERT INTO tbl_purchase VALUES("1525","PUR060924101","","SU","14","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-09-06","","19000.00","0.00","","LE_2","","0","5","2024-09-06 01:12:40");
INSERT INTO tbl_purchase VALUES("1526","PUR060924102","","SU","1","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2024-09-06","","28000.00","0.00","","LE_2","","0","5","2024-09-06 02:19:00");
INSERT INTO tbl_purchase VALUES("1527","PUR070924101","","SU","50","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-09-07","","26000.00","0.00","","LE_2","","0","5","2024-09-07 11:14:53");
INSERT INTO tbl_purchase VALUES("1528","PUR070924102","","SU","50","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2024-09-07","","78000.00","0.00","","LE_2","","0","5","2024-09-07 03:17:02");
INSERT INTO tbl_purchase VALUES("1529","PUR080924101","","SU","50","0.00","255000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","255000.00","0","","","2024-09-08","","255000.00","0.00","","LE_2","","0","5","2024-09-08 05:25:05");
INSERT INTO tbl_purchase VALUES("1530","PUR080924102","","SU","1","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-09-08","","19000.00","0.00","","LE_2","","0","5","2024-09-08 05:43:07");
INSERT INTO tbl_purchase VALUES("1531","PUR090924101","","SU","50","0.00","216000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","216000.00","0","","","2024-09-09","","216000.00","0.00","","LE_2","","0","5","2024-09-09 05:59:00");
INSERT INTO tbl_purchase VALUES("1532","PUR110924101","","SU","50","0.00","156000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","156000.00","0","","","2024-09-11","","156000.00","0.00","","LE_2","","0","5","2024-09-11 02:45:01");
INSERT INTO tbl_purchase VALUES("1533","PUR110924102","","SU","50","0.00","862000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","862000.00","0","","","2024-09-11","","862000.00","0.00","","LE_2","","0","5","2024-09-11 04:15:28");
INSERT INTO tbl_purchase VALUES("1534","PUR120924101","","SU","14","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2024-09-12","","100000.00","0.00","","LE_2","","0","5","2024-09-12 01:24:03");
INSERT INTO tbl_purchase VALUES("1535","PUR130924101","","SU","50","0.00","583000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","583000.00","0","","","2024-09-13","","583000.00","0.00","","LE_2","","0","5","2024-09-13 11:50:56");
INSERT INTO tbl_purchase VALUES("1536","PUR130924102","","SU","1","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2024-09-13","","26000.00","0.00","","LE_2","","0","5","2024-09-13 01:00:59");
INSERT INTO tbl_purchase VALUES("1537","PUR140924101","","SU","1","0.00","332000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","332000.00","0","","","2024-09-14","2024-09-21","0.00","0.00","","LE_2","","0","5","2024-09-14 04:22:25");
INSERT INTO tbl_purchase VALUES("1538","PUR150924101","","SU","50","0.00","162500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","162500.00","0","","","2024-09-15","","162500.00","0.00","","LE_2","","0","5","2024-09-15 05:40:35");
INSERT INTO tbl_purchase VALUES("1539","PUR150924102","","SU","1","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2024-09-15","","28000.00","0.00","","LE_2","","0","5","2024-09-15 05:49:38");
INSERT INTO tbl_purchase VALUES("1540","PUR180924101","","SU","14","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2024-09-18","","78000.00","0.00","","LE_2","","0","5","2024-09-18 02:19:07");
INSERT INTO tbl_purchase VALUES("1541","PUR180924102","","SU","50","0.00","400000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","400000.00","0","","","2024-09-18","","400000.00","0.00","","LE_2","","0","5","2024-09-18 05:47:35");
INSERT INTO tbl_purchase VALUES("1542","PUR190924101","","SU","50","0.00","82000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","82000.00","0","","","2024-09-19","2024-09-26","0.00","0.00","","LE_2","","0","5","2024-09-19 11:40:42");
INSERT INTO tbl_purchase VALUES("1543","PUR200924101","","SU","50","0.00","31000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31000.00","0","","","2024-09-20","","31000.00","0.00","","LE_2","","0","5","2024-09-20 05:05:09");
INSERT INTO tbl_purchase VALUES("1544","PUR200924102","","SU","1","0.00","38000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38000.00","0","","","2024-09-20","","38000.00","0.00","","LE_2","","0","5","2024-09-20 05:06:39");
INSERT INTO tbl_purchase VALUES("1545","PUR200924103","","SU","50","0.00","163000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","163000.00","0","","","2024-09-20","","163000.00","0.00","","LE_2","","0","5","2024-09-20 05:21:28");
INSERT INTO tbl_purchase VALUES("1546","PUR210924101","","SU","1","0.00","47000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47000.00","0","","","2024-09-21","","47000.00","0.00","","LE_2","","0","5","2024-09-21 02:31:37");
INSERT INTO tbl_purchase VALUES("1547","PUR210924102","","SU","1","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-09-21","","18000.00","0.00","","LE_2","","0","5","2024-09-21 07:35:23");
INSERT INTO tbl_purchase VALUES("1548","PUR220924101","","SU","1","0.00","112000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112000.00","0","","","2024-09-22","2024-09-29","0.00","0.00","","LE_2","","0","5","2024-09-22 08:21:27");
INSERT INTO tbl_purchase VALUES("1549","PUR230924101","","SU","50","0.00","54000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54000.00","0","","","2024-09-23","","54000.00","0.00","","LE_2","","0","5","2024-09-23 05:24:41");
INSERT INTO tbl_purchase VALUES("1550","PUR250924101","","SU","50","0.00","103500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103500.00","0","","","2024-09-25","","103500.00","0.00","","LE_2","","0","5","2024-09-25 04:25:49");
INSERT INTO tbl_purchase VALUES("1551","PUR260924101","","SU","50","0.00","110000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110000.00","0","","","2024-09-26","","110000.00","0.00","","LE_2","","0","5","2024-09-26 11:30:05");
INSERT INTO tbl_purchase VALUES("1552","PUR260924102","","SU","50","0.00","1208000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1208000.00","0","","","2024-09-26","","1208000.00","0.00","","LE_2","","0","5","2024-09-26 05:26:28");
INSERT INTO tbl_purchase VALUES("1553","PUR280924101","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2024-09-28","","17500.00","0.00","","LE_2","","0","5","2024-09-28 07:04:34");
INSERT INTO tbl_purchase VALUES("1554","PUR280924102","","SU","1","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2024-09-28","","17500.00","0.00","","LE_2","","0","5","2024-09-28 07:10:01");
INSERT INTO tbl_purchase VALUES("1555","PUR290924101","","SU","50","0.00","27500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27500.00","0","","","2024-09-29","","27500.00","0.00","","LE_2","","0","5","2024-09-29 12:36:49");
INSERT INTO tbl_purchase VALUES("1556","PUR290924102","","SU","50","0.00","27500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27500.00","0","","","2024-09-29","","27500.00","0.00","","LE_2","","0","5","2024-09-29 06:51:28");
INSERT INTO tbl_purchase VALUES("1557","PUR290924103","","SU","50","0.00","349500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","349500.00","0","","","2024-09-29","","349500.00","0.00","","LE_2","","0","5","2024-09-29 07:21:49");
INSERT INTO tbl_purchase VALUES("1558","PUR021024101","","SU","50","0.00","52000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52000.00","0","","","2024-10-02","","52000.00","0.00","","LE_2","","0","5","2024-10-02 12:58:29");
INSERT INTO tbl_purchase VALUES("1559","PUR021024102","","SU","14","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2024-10-02","","57000.00","0.00","","LE_2","","0","5","2024-10-02 05:01:14");
INSERT INTO tbl_purchase VALUES("1560","PUR041024101","","SU","1","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-10-04","","18000.00","0.00","","LE_2","","0","5","2024-10-04 12:52:12");
INSERT INTO tbl_purchase VALUES("1561","PUR041024102","","SU","1","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2024-10-04","","16000.00","0.00","","LE_2","","0","5","2024-10-04 03:17:49");
INSERT INTO tbl_purchase VALUES("1562","PUR041024103","","SU","14","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-10-04","","36000.00","0.00","","LE_2","","0","5","2024-10-04 05:42:42");
INSERT INTO tbl_purchase VALUES("1563","PUR061024101","","SU","50","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-10-06","","36000.00","0.00","","LE_2","","0","5","2024-10-06 12:23:49");
INSERT INTO tbl_purchase VALUES("1564","PUR061024102","","SU","50","0.00","276500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","276500.00","0","","","2024-10-06","","276500.00","0.00","","LE_2","","0","5","2024-10-06 07:52:21");
INSERT INTO tbl_purchase VALUES("1565","PUR091024101","","SU","50","0.00","734500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","734500.00","0","","","2024-10-09","","734500.00","0.00","","LE_2","","0","5","2024-10-09 12:19:41");
INSERT INTO tbl_purchase VALUES("1566","PUR091024102","","SU","50","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2024-10-09","","126000.00","0.00","","LE_2","","0","5","2024-10-09 02:57:09");
INSERT INTO tbl_purchase VALUES("1567","PUR101024101","","SU","1","0.00","110000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110000.00","0","","","2024-10-10","","110000.00","0.00","","LE_2","","0","5","2024-10-10 06:24:11");
INSERT INTO tbl_purchase VALUES("1568","PUR111024101","","SU","50","0.00","408000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","408000.00","0","","","2024-10-11","","408000.00","0.00","","LE_2","","0","5","2024-10-11 04:33:52");



CREATE TABLE `tbl_recvoucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2534 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_recvoucher VALUES("3","0","REV200322102","","60000.00","2022-03-20","5","2022-03-20 03:09:14");
INSERT INTO tbl_recvoucher VALUES("5","0","REV250322102","","32500.00","2022-03-25","5","2022-03-25 03:10:07");
INSERT INTO tbl_recvoucher VALUES("6","0","REV250322103","","21500.00","2022-03-25","5","2022-03-25 03:40:07");
INSERT INTO tbl_recvoucher VALUES("7","0","REV250322104","","33000.00","2022-03-25","5","2022-03-25 03:40:41");
INSERT INTO tbl_recvoucher VALUES("8","0","REV250322105","","96000.00","2022-03-25","5","2022-03-25 04:16:38");
INSERT INTO tbl_recvoucher VALUES("9","0","REV250322106","","39500.00","2022-03-25","5","2022-03-25 04:36:31");
INSERT INTO tbl_recvoucher VALUES("10","0","REV270322101","","25000.00","2022-03-27","5","2022-03-27 12:23:44");
INSERT INTO tbl_recvoucher VALUES("11","0","REV270322102","","26000.00","2022-03-27","5","2022-03-27 01:04:30");
INSERT INTO tbl_recvoucher VALUES("12","0","REV270322103","","16000.00","2022-03-27","5","2022-03-27 02:50:30");
INSERT INTO tbl_recvoucher VALUES("13","0","REV270322104","","10000.00","2022-03-27","5","2022-03-27 07:35:22");
INSERT INTO tbl_recvoucher VALUES("14","0","REV280322101","","30000.00","2022-03-28","5","2022-03-28 03:38:42");
INSERT INTO tbl_recvoucher VALUES("15","0","REV280322102","","14000.00","2022-03-28","5","2022-03-28 07:15:03");
INSERT INTO tbl_recvoucher VALUES("16","0","REV280322103","","50000.00","2022-03-28","5","2022-03-28 07:24:32");
INSERT INTO tbl_recvoucher VALUES("17","0","REV280322104","","41000.00","2022-03-28","5","2022-03-28 08:00:35");
INSERT INTO tbl_recvoucher VALUES("18","0","REV280322105","","33000.00","2022-03-28","5","2022-03-28 08:07:17");
INSERT INTO tbl_recvoucher VALUES("19","0","REV290322101","","30000.00","2022-03-29","5","2022-03-29 01:31:52");
INSERT INTO tbl_recvoucher VALUES("20","0","REV290322102","","40000.00","2022-03-29","5","2022-03-29 11:03:25");
INSERT INTO tbl_recvoucher VALUES("21","0","REV300322101","","15000.00","2022-03-30","5","2022-03-30 04:26:53");
INSERT INTO tbl_recvoucher VALUES("22","0","REV300322102","","57500.00","2022-03-30","5","2022-03-30 06:18:00");
INSERT INTO tbl_recvoucher VALUES("23","0","REV300322103","","15000.00","2022-03-30","5","2022-03-30 11:52:14");
INSERT INTO tbl_recvoucher VALUES("24","0","REV310322101","","10000.00","2022-03-31","5","2022-03-31 05:04:21");
INSERT INTO tbl_recvoucher VALUES("25","0","REV310322102","","23000.00","2022-03-31","5","2022-03-31 05:53:13");
INSERT INTO tbl_recvoucher VALUES("26","0","REV310322103","","10000.00","2022-03-31","5","2022-03-31 08:29:55");
INSERT INTO tbl_recvoucher VALUES("27","0","REV010422101","","10000.00","2022-04-01","5","2022-04-01 01:04:15");
INSERT INTO tbl_recvoucher VALUES("28","0","REV010422102","","27500.00","2022-04-01","5","2022-04-01 11:44:55");
INSERT INTO tbl_recvoucher VALUES("29","0","REV010422103","","30000.00","2022-04-01","5","2022-04-01 12:35:30");
INSERT INTO tbl_recvoucher VALUES("30","0","REV010422104","","32500.00","2022-04-01","5","2022-04-01 02:19:51");
INSERT INTO tbl_recvoucher VALUES("31","0","REV010422105","","178000.00","2022-04-01","5","2022-04-01 02:40:42");
INSERT INTO tbl_recvoucher VALUES("32","0","REV020422101","","30000.00","2022-04-02","5","2022-04-02 11:24:26");
INSERT INTO tbl_recvoucher VALUES("33","0","REV030422101","","50000.00","2022-04-03","5","2022-04-03 04:09:27");
INSERT INTO tbl_recvoucher VALUES("34","0","REV030422102","","50000.00","2022-04-03","5","2022-04-03 04:47:54");
INSERT INTO tbl_recvoucher VALUES("35","0","REV030422103","","50000.00","2022-04-03","5","2022-04-03 09:38:51");
INSERT INTO tbl_recvoucher VALUES("36","0","REV030422104","","20000.00","2022-04-03","5","2022-04-03 09:41:09");
INSERT INTO tbl_recvoucher VALUES("37","0","REV040422101","","100000.00","2022-04-04","5","2022-04-04 11:02:12");
INSERT INTO tbl_recvoucher VALUES("38","0","REV040422102","","50000.00","2022-04-04","5","2022-04-04 01:16:48");
INSERT INTO tbl_recvoucher VALUES("39","0","REV050422101","","25500.00","2022-04-05","5","2022-04-05 10:24:23");
INSERT INTO tbl_recvoucher VALUES("40","0","REV050422102","","50000.00","2022-04-05","5","2022-04-05 11:03:50");
INSERT INTO tbl_recvoucher VALUES("41","0","REV060422101","","10000.00","2022-04-06","5","2022-04-06 11:33:16");
INSERT INTO tbl_recvoucher VALUES("42","0","REV060422102","","10000.00","2022-04-06","5","2022-04-06 01:29:22");
INSERT INTO tbl_recvoucher VALUES("43","0","REV060422103","","50000.00","2022-04-06","5","2022-04-06 07:09:09");
INSERT INTO tbl_recvoucher VALUES("44","0","REV070422101","","108000.00","2022-04-07","5","2022-04-07 12:05:18");
INSERT INTO tbl_recvoucher VALUES("45","0","REV070422102","","10000.00","2022-04-07","5","2022-04-07 07:13:20");
INSERT INTO tbl_recvoucher VALUES("46","0","REV090422101","","60000.00","2022-04-09","5","2022-04-09 12:27:25");
INSERT INTO tbl_recvoucher VALUES("47","0","REV090422102","","100000.00","2022-04-09","5","2022-04-09 09:32:40");
INSERT INTO tbl_recvoucher VALUES("48","0","REV090422103","","10000.00","2022-04-09","5","2022-04-09 10:45:24");
INSERT INTO tbl_recvoucher VALUES("49","0","REV100422101","","6000.00","2022-04-10","5","2022-04-10 03:24:04");
INSERT INTO tbl_recvoucher VALUES("50","0","REV110422101","","6000.00","2022-04-11","5","2022-04-11 11:03:38");
INSERT INTO tbl_recvoucher VALUES("51","0","REV110422102","","29000.00","2022-04-11","5","2022-04-11 02:10:54");
INSERT INTO tbl_recvoucher VALUES("52","0","REV110422103","","25500.00","2022-04-11","5","2022-04-11 03:36:57");
INSERT INTO tbl_recvoucher VALUES("53","0","REV110422104","","70000.00","2022-04-11","5","2022-04-11 05:47:45");
INSERT INTO tbl_recvoucher VALUES("54","0","REV110422105","","26000.00","2022-04-11","5","2022-04-11 06:58:52");
INSERT INTO tbl_recvoucher VALUES("55","0","REV120422101","","21000.00","2022-04-12","5","2022-04-12 10:56:48");
INSERT INTO tbl_recvoucher VALUES("56","0","REV120422102","","65000.00","2022-04-12","5","2022-04-12 01:11:41");
INSERT INTO tbl_recvoucher VALUES("57","0","REV120422103","T470 Return 1 Unit Tk. 28000","78000.00","2022-04-12","5","2022-04-12 04:31:31");
INSERT INTO tbl_recvoucher VALUES("58","0","REV120422104","","50000.00","2022-04-12","5","2022-04-12 06:52:42");
INSERT INTO tbl_recvoucher VALUES("59","0","REV130422101","","60000.00","2022-04-13","5","2022-04-13 01:11:49");
INSERT INTO tbl_recvoucher VALUES("60","0","REV130422102","","17000.00","2022-04-13","5","2022-04-13 01:43:47");
INSERT INTO tbl_recvoucher VALUES("61","0","REV130422103","","8000.00","2022-04-13","5","2022-04-13 03:35:52");
INSERT INTO tbl_recvoucher VALUES("62","0","REV130422104","Hp 820 G3 Non Touch New Serial Number ","24800.00","2022-04-13","5","2022-04-13 04:26:23");
INSERT INTO tbl_recvoucher VALUES("63","0","REV160422101","","50000.00","2022-04-16","5","2022-04-16 04:30:57");
INSERT INTO tbl_recvoucher VALUES("64","0","REV180422101","","50000.00","2022-04-18","5","2022-04-18 12:34:52");
INSERT INTO tbl_recvoucher VALUES("65","0","REV180422102","","30000.00","2022-04-18","5","2022-04-18 03:23:57");
INSERT INTO tbl_recvoucher VALUES("66","0","REV190422101","","71000.00","2022-04-19","5","2022-04-19 12:04:11");
INSERT INTO tbl_recvoucher VALUES("67","0","REV190422102","","31500.00","2022-04-19","5","2022-04-19 03:55:04");
INSERT INTO tbl_recvoucher VALUES("68","0","REV190422103","","24000.00","2022-04-19","5","2022-04-19 09:48:07");
INSERT INTO tbl_recvoucher VALUES("69","0","REV200422101","","52000.00","2022-04-20","5","2022-04-20 03:01:36");
INSERT INTO tbl_recvoucher VALUES("70","0","REV210422101","","50000.00","2022-04-21","5","2022-04-21 10:45:57");
INSERT INTO tbl_recvoucher VALUES("71","0","REV210422102","","50000.00","2022-04-21","5","2022-04-21 02:45:18");
INSERT INTO tbl_recvoucher VALUES("72","0","REV210422103","","30000.00","2022-04-21","5","2022-04-21 03:04:02");
INSERT INTO tbl_recvoucher VALUES("73","0","REV220422101","","20000.00","2022-04-22","5","2022-04-22 01:00:30");
INSERT INTO tbl_recvoucher VALUES("74","0","REV230422101","","50000.00","2022-04-23","5","2022-04-23 03:27:35");
INSERT INTO tbl_recvoucher VALUES("75","0","REV230422102","","20500.00","2022-04-23","5","2022-04-23 04:08:09");
INSERT INTO tbl_recvoucher VALUES("76","0","REV230422103","","5000.00","2022-04-23","5","2022-04-23 04:28:05");
INSERT INTO tbl_recvoucher VALUES("77","0","REV250422101","","100000.00","2022-04-25","5","2022-04-25 11:24:18");
INSERT INTO tbl_recvoucher VALUES("78","0","REV250422102","","50000.00","2022-04-25","5","2022-04-25 12:57:23");
INSERT INTO tbl_recvoucher VALUES("79","0","REV250422103","","26000.00","2022-04-25","5","2022-04-25 07:12:54");
INSERT INTO tbl_recvoucher VALUES("80","0","REV260422101","","50000.00","2022-04-26","5","2022-04-26 03:10:48");
INSERT INTO tbl_recvoucher VALUES("81","0","REV260422102","","70000.00","2022-04-26","5","2022-04-26 04:07:19");
INSERT INTO tbl_recvoucher VALUES("82","0","REV270422101","","150000.00","2022-04-27","5","2022-04-27 01:21:50");
INSERT INTO tbl_recvoucher VALUES("83","0","REV270422102","","48000.00","2022-04-27","5","2022-04-27 01:25:51");
INSERT INTO tbl_recvoucher VALUES("84","0","REV270422103","","115500.00","2022-04-27","5","2022-04-27 04:53:18");
INSERT INTO tbl_recvoucher VALUES("85","0","REV270422104","","15000.00","2022-04-27","5","2022-04-27 07:55:05");
INSERT INTO tbl_recvoucher VALUES("86","0","REV280422101","","30000.00","2022-04-28","5","2022-04-28 12:11:34");
INSERT INTO tbl_recvoucher VALUES("87","0","REV280422102","","26000.00","2022-04-28","5","2022-04-28 03:18:06");
INSERT INTO tbl_recvoucher VALUES("88","0","REV280422103","","100000.00","2022-04-28","5","2022-04-28 03:19:22");
INSERT INTO tbl_recvoucher VALUES("89","0","REV290422101","","33500.00","2022-04-29","5","2022-04-29 04:09:52");
INSERT INTO tbl_recvoucher VALUES("90","0","REV300422101","","7300.00","2022-04-30","5","2022-04-30 03:16:28");
INSERT INTO tbl_recvoucher VALUES("91","0","REV300422102","","10000.00","2022-04-30","5","2022-04-30 03:46:57");
INSERT INTO tbl_recvoucher VALUES("92","0","REV300422103","","17000.00","2022-04-30","5","2022-04-30 08:41:19");
INSERT INTO tbl_recvoucher VALUES("93","0","REV300422104","","25500.00","2022-04-30","5","2022-04-30 08:59:45");
INSERT INTO tbl_recvoucher VALUES("94","0","REV300422105","","34000.00","2022-04-30","5","2022-04-30 09:30:14");
INSERT INTO tbl_recvoucher VALUES("95","0","REV010522101","","50000.00","2022-05-01","5","2022-05-01 02:08:05");
INSERT INTO tbl_recvoucher VALUES("96","0","REV040522101","","269500.00","2022-05-04","5","2022-05-04 10:35:01");
INSERT INTO tbl_recvoucher VALUES("97","0","REV090522101","","40000.00","2022-05-09","5","2022-05-09 02:31:50");
INSERT INTO tbl_recvoucher VALUES("98","0","REV090522102","Return Acer I3 4th Gen Tk. 16000","16000.00","2022-05-09","5","2022-05-09 08:24:06");
INSERT INTO tbl_recvoucher VALUES("99","0","REV110522101","","10000.00","2022-05-11","5","2022-05-11 11:46:50");
INSERT INTO tbl_recvoucher VALUES("100","0","REV120522101","","15000.00","2022-05-12","5","2022-05-12 02:20:05");
INSERT INTO tbl_recvoucher VALUES("101","0","REV120522102","","15000.00","2022-05-12","5","2022-05-12 02:52:37");
INSERT INTO tbl_recvoucher VALUES("102","0","REV120522103","","20500.00","2022-05-12","5","2022-05-12 06:05:44");
INSERT INTO tbl_recvoucher VALUES("103","0","REV120522104","","50000.00","2022-05-12","5","2022-05-12 06:41:27");
INSERT INTO tbl_recvoucher VALUES("104","0","REV120522105","","280000.00","2022-05-12","5","2022-05-12 08:00:23");
INSERT INTO tbl_recvoucher VALUES("105","0","REV120522106","","40000.00","2022-05-12","5","2022-05-12 08:36:58");
INSERT INTO tbl_recvoucher VALUES("106","0","REV140522101","","170000.00","2022-05-14","5","2022-05-14 03:06:23");
INSERT INTO tbl_recvoucher VALUES("107","0","REV140522102","","20000.00","2022-05-14","5","2022-05-14 08:09:16");
INSERT INTO tbl_recvoucher VALUES("108","0","REV150522101","","25000.00","2022-05-15","5","2022-05-15 12:48:59");
INSERT INTO tbl_recvoucher VALUES("109","0","REV150522102","","60000.00","2022-05-15","5","2022-05-15 12:49:16");
INSERT INTO tbl_recvoucher VALUES("110","0","REV150522103","","71500.00","2022-05-15","5","2022-05-15 02:20:14");
INSERT INTO tbl_recvoucher VALUES("111","0","REV170522101","","50000.00","2022-05-17","5","2022-05-17 11:16:42");
INSERT INTO tbl_recvoucher VALUES("112","0","REV170522102","","60000.00","2022-05-17","5","2022-05-17 11:17:02");
INSERT INTO tbl_recvoucher VALUES("113","0","REV170522103","","31000.00","2022-05-17","5","2022-05-17 11:19:29");
INSERT INTO tbl_recvoucher VALUES("114","0","REV180522101","440 core i5 sales return 23500 ","23500.00","2022-05-18","5","2022-05-18 01:22:20");
INSERT INTO tbl_recvoucher VALUES("115","0","REV180522102","","100000.00","2022-05-18","5","2022-05-18 02:04:40");
INSERT INTO tbl_recvoucher VALUES("116","0","REV180522103","","900.00","2022-05-18","5","2022-05-18 07:56:41");
INSERT INTO tbl_recvoucher VALUES("117","0","REV190522101","","30000.00","2022-05-19","5","2022-05-19 02:54:32");
INSERT INTO tbl_recvoucher VALUES("118","0","REV190522102","","26000.00","2022-05-19","5","2022-05-19 05:52:26");
INSERT INTO tbl_recvoucher VALUES("119","0","REV200522101","","40000.00","2022-05-20","5","2022-05-20 11:11:24");
INSERT INTO tbl_recvoucher VALUES("120","0","REV200522102","640 Core I5 6th Gen 256 And 8 GB Sales Return 23500+ 23500","47000.00","2022-05-20","5","2022-05-20 11:13:44");
INSERT INTO tbl_recvoucher VALUES("121","0","REV200522103","","31000.00","2022-05-20","5","2022-05-20 11:37:35");
INSERT INTO tbl_recvoucher VALUES("122","0","REV200522104","","174500.00","2022-05-20","5","2022-05-20 11:38:58");
INSERT INTO tbl_recvoucher VALUES("123","0","REV200522105","","25500.00","2022-05-20","5","2022-05-20 11:40:13");
INSERT INTO tbl_recvoucher VALUES("124","0","REV200522106","","30000.00","2022-05-20","5","2022-05-20 08:27:07");
INSERT INTO tbl_recvoucher VALUES("125","0","REV210522101","","10000.00","2022-05-21","5","2022-05-21 02:28:32");
INSERT INTO tbl_recvoucher VALUES("126","0","REV210522102","","8500.00","2022-05-21","5","2022-05-21 02:28:53");
INSERT INTO tbl_recvoucher VALUES("127","0","REV210522103","","25500.00","2022-05-21","5","2022-05-21 03:12:16");
INSERT INTO tbl_recvoucher VALUES("128","0","REV210522104","","16500.00","2022-05-21","5","2022-05-21 07:22:34");
INSERT INTO tbl_recvoucher VALUES("129","0","REV210522105","","85000.00","2022-05-21","5","2022-05-21 08:10:57");
INSERT INTO tbl_recvoucher VALUES("130","0","REV230522101","","30000.00","2022-05-23","5","2022-05-23 04:15:45");
INSERT INTO tbl_recvoucher VALUES("131","0","REV230522102","","34500.00","2022-05-23","5","2022-05-23 05:19:01");
INSERT INTO tbl_recvoucher VALUES("132","0","REV240522101","","25500.00","2022-05-24","5","2022-05-24 12:44:52");
INSERT INTO tbl_recvoucher VALUES("133","0","REV240522102","","25000.00","2022-05-24","5","2022-05-24 12:49:20");
INSERT INTO tbl_recvoucher VALUES("134","0","REV250522101","","50000.00","2022-05-25","5","2022-05-25 11:11:52");
INSERT INTO tbl_recvoucher VALUES("135","0","REV250522102","","26000.00","2022-05-25","5","2022-05-25 11:58:16");
INSERT INTO tbl_recvoucher VALUES("136","0","REV250522103","","50000.00","2022-05-25","5","2022-05-25 06:24:05");
INSERT INTO tbl_recvoucher VALUES("137","0","REV250522104","","26500.00","2022-05-25","5","2022-05-25 06:24:42");
INSERT INTO tbl_recvoucher VALUES("138","0","REV250522105","","100000.00","2022-05-25","5","2022-05-25 06:25:05");
INSERT INTO tbl_recvoucher VALUES("139","0","REV250522106","","26000.00","2022-05-25","5","2022-05-25 06:26:07");
INSERT INTO tbl_recvoucher VALUES("140","0","REV250522107","","200000.00","2022-05-25","5","2022-05-25 06:26:30");
INSERT INTO tbl_recvoucher VALUES("141","0","REV250522108","","10000.00","2022-05-25","5","2022-05-25 08:29:00");
INSERT INTO tbl_recvoucher VALUES("142","0","REV260522101","","10000.00","2022-05-26","5","2022-05-26 12:57:40");
INSERT INTO tbl_recvoucher VALUES("143","0","REV260522102","","5000.00","2022-05-26","5","2022-05-26 12:57:55");
INSERT INTO tbl_recvoucher VALUES("144","0","REV260522103","","30000.00","2022-05-26","5","2022-05-26 05:08:26");
INSERT INTO tbl_recvoucher VALUES("145","0","REV260522104","","40000.00","2022-05-26","5","2022-05-26 06:58:05");
INSERT INTO tbl_recvoucher VALUES("147","0","REV270522102","","10000.00","2022-05-27","5","2022-05-27 10:51:11");
INSERT INTO tbl_recvoucher VALUES("148","0","REV270522103","","71000.00","2022-05-27","5","2022-05-27 10:52:58");
INSERT INTO tbl_recvoucher VALUES("149","0","REV280522101","","21000.00","2022-05-28","5","2022-05-28 12:44:52");
INSERT INTO tbl_recvoucher VALUES("150","0","REV280522102","","30000.00","2022-05-28","5","2022-05-28 08:01:34");
INSERT INTO tbl_recvoucher VALUES("151","0","REV290522101","","13500.00","2022-05-29","5","2022-05-29 04:29:37");
INSERT INTO tbl_recvoucher VALUES("152","0","REV300522101","","15000.00","2022-05-30","5","2022-05-30 06:55:56");
INSERT INTO tbl_recvoucher VALUES("153","0","REV300522102","","25000.00","2022-05-30","5","2022-05-30 08:18:33");
INSERT INTO tbl_recvoucher VALUES("154","0","REV010622101","","19000.00","2022-06-01","5","2022-06-01 05:31:37");
INSERT INTO tbl_recvoucher VALUES("155","0","REV010622102","","26000.00","2022-06-01","5","2022-06-01 05:40:09");
INSERT INTO tbl_recvoucher VALUES("156","0","REV010622103","","1000.00","2022-06-01","5","2022-06-01 07:14:07");
INSERT INTO tbl_recvoucher VALUES("157","0","REV020622101","","37000.00","2022-06-02","5","2022-06-02 03:12:03");
INSERT INTO tbl_recvoucher VALUES("158","0","REV020622102","","9000.00","2022-06-02","5","2022-06-02 06:42:03");
INSERT INTO tbl_recvoucher VALUES("159","0","REV020622103","","900.00","2022-06-02","5","2022-06-02 07:31:11");
INSERT INTO tbl_recvoucher VALUES("160","0","REV020622104","","10000.00","2022-06-02","5","2022-06-02 07:43:42");
INSERT INTO tbl_recvoucher VALUES("161","0","REV020622105","","50000.00","2022-06-02","5","2022-06-02 07:53:10");
INSERT INTO tbl_recvoucher VALUES("162","0","REV030622101","","74000.00","2022-06-03","5","2022-06-03 01:47:21");
INSERT INTO tbl_recvoucher VALUES("163","0","REV040622101","","15000.00","2022-06-04","5","2022-06-04 12:02:39");
INSERT INTO tbl_recvoucher VALUES("164","0","REV040622102","","4500.00","2022-06-04","5","2022-06-04 12:16:13");
INSERT INTO tbl_recvoucher VALUES("165","0","REV040622103","","21500.00","2022-06-04","5","2022-06-04 05:22:47");
INSERT INTO tbl_recvoucher VALUES("166","0","REV040622104","","50000.00","2022-06-04","5","2022-06-04 07:55:14");
INSERT INTO tbl_recvoucher VALUES("167","0","REV040622105","","104000.00","2022-06-04","5","2022-06-04 08:04:18");
INSERT INTO tbl_recvoucher VALUES("168","0","REV050622101","","10000.00","2022-06-05","5","2022-06-05 06:54:14");
INSERT INTO tbl_recvoucher VALUES("169","0","REV050622102","","50000.00","2022-06-05","5","2022-06-05 08:19:53");
INSERT INTO tbl_recvoucher VALUES("170","0","REV050622103","","2500.00","2022-06-05","5","2022-06-05 08:21:26");
INSERT INTO tbl_recvoucher VALUES("171","0","REV050622104","","50000.00","2022-06-05","5","2022-06-05 08:23:37");
INSERT INTO tbl_recvoucher VALUES("172","0","REV060622101","","16500.00","2022-06-06","5","2022-06-06 02:24:29");
INSERT INTO tbl_recvoucher VALUES("173","0","REV080622101","","202000.00","2022-06-08","5","2022-06-08 11:20:12");
INSERT INTO tbl_recvoucher VALUES("174","0","REV080622102","","22000.00","2022-06-08","5","2022-06-08 11:20:30");
INSERT INTO tbl_recvoucher VALUES("175","0","REV090622101","","10000.00","2022-06-09","5","2022-06-09 12:15:03");
INSERT INTO tbl_recvoucher VALUES("176","0","REV090622102","","140000.00","2022-06-09","5","2022-06-09 07:25:26");
INSERT INTO tbl_recvoucher VALUES("177","0","REV100622101","","133300.00","2022-06-10","5","2022-06-10 12:41:49");
INSERT INTO tbl_recvoucher VALUES("178","0","REV100622102","","52000.00","2022-06-10","5","2022-06-10 01:00:24");
INSERT INTO tbl_recvoucher VALUES("179","0","REV110622101","","30000.00","2022-06-11","5","2022-06-11 01:11:29");
INSERT INTO tbl_recvoucher VALUES("180","0","REV110622102","","5500.00","2022-06-11","5","2022-06-11 01:31:48");
INSERT INTO tbl_recvoucher VALUES("181","0","REV110622103","","26500.00","2022-06-11","5","2022-06-11 08:39:50");
INSERT INTO tbl_recvoucher VALUES("182","0","REV110622104","","20000.00","2022-06-11","5","2022-06-11 08:44:04");
INSERT INTO tbl_recvoucher VALUES("183","0","REV110622105","","17000.00","2022-06-11","5","2022-06-11 09:02:29");
INSERT INTO tbl_recvoucher VALUES("184","0","REV130622101","","150000.00","2022-06-13","5","2022-06-13 03:29:15");
INSERT INTO tbl_recvoucher VALUES("185","0","REV130622102","","40000.00","2022-06-13","5","2022-06-13 05:00:46");
INSERT INTO tbl_recvoucher VALUES("186","0","REV140622101","","4000.00","2022-06-14","5","2022-06-14 11:53:06");
INSERT INTO tbl_recvoucher VALUES("187","0","REV140622102","","59000.00","2022-06-14","5","2022-06-14 11:57:32");
INSERT INTO tbl_recvoucher VALUES("188","0","REV140622103","","61500.00","2022-06-14","5","2022-06-14 12:01:45");
INSERT INTO tbl_recvoucher VALUES("189","0","REV150622101","","24500.00","2022-06-15","5","2022-06-15 07:24:56");
INSERT INTO tbl_recvoucher VALUES("190","0","REV160622101","","50000.00","2022-06-16","5","2022-06-16 11:11:37");
INSERT INTO tbl_recvoucher VALUES("191","0","REV160622102","","10000.00","2022-06-16","5","2022-06-16 07:54:06");
INSERT INTO tbl_recvoucher VALUES("192","0","REV160622103","","10000.00","2022-06-16","5","2022-06-16 08:03:45");
INSERT INTO tbl_recvoucher VALUES("193","0","REV170622101","","10000.00","2022-06-17","5","2022-06-17 01:27:01");
INSERT INTO tbl_recvoucher VALUES("194","0","REV170622102","","25500.00","2022-06-17","5","2022-06-17 01:54:17");
INSERT INTO tbl_recvoucher VALUES("195","0","REV180622101","","50000.00","2022-06-18","5","2022-06-18 06:15:35");
INSERT INTO tbl_recvoucher VALUES("196","0","REV190622101","","11500.00","2022-06-19","5","2022-06-19 11:18:36");
INSERT INTO tbl_recvoucher VALUES("197","0","REV190622102","","20000.00","2022-06-19","5","2022-06-19 01:38:25");
INSERT INTO tbl_recvoucher VALUES("198","0","REV190622103","","100000.00","2022-06-19","5","2022-06-19 01:55:44");
INSERT INTO tbl_recvoucher VALUES("199","0","REV190622104","","60000.00","2022-06-19","5","2022-06-19 04:25:57");
INSERT INTO tbl_recvoucher VALUES("200","0","REV190622105","","10000.00","2022-06-19","5","2022-06-19 07:40:08");
INSERT INTO tbl_recvoucher VALUES("201","0","REV190622106","","94000.00","2022-06-19","5","2022-06-19 08:14:51");
INSERT INTO tbl_recvoucher VALUES("202","0","REV200622101","","350000.00","2022-06-20","5","2022-06-20 03:26:31");
INSERT INTO tbl_recvoucher VALUES("203","0","REV200622102","","25000.00","2022-06-20","5","2022-06-20 04:04:56");
INSERT INTO tbl_recvoucher VALUES("204","0","REV200622103","","15000.00","2022-06-20","5","2022-06-20 04:05:16");
INSERT INTO tbl_recvoucher VALUES("205","0","REV200622104","","76000.00","2022-06-20","5","2022-06-20 04:44:42");
INSERT INTO tbl_recvoucher VALUES("206","0","REV200622105","","50000.00","2022-06-20","5","2022-06-20 06:42:15");
INSERT INTO tbl_recvoucher VALUES("207","0","REV200622106","","87600.00","2022-06-20","5","2022-06-20 06:46:00");
INSERT INTO tbl_recvoucher VALUES("208","0","REV220622101","","5000.00","2022-06-22","5","2022-06-22 07:41:04");
INSERT INTO tbl_recvoucher VALUES("209","0","REV230622101","","31400.00","2022-06-23","5","2022-06-23 04:56:47");
INSERT INTO tbl_recvoucher VALUES("210","0","REV230622102","","90000.00","2022-06-23","5","2022-06-23 06:39:04");
INSERT INTO tbl_recvoucher VALUES("211","0","REV240622101","","20000.00","2022-06-24","5","2022-06-24 11:23:01");
INSERT INTO tbl_recvoucher VALUES("212","0","REV250622101","","10000.00","2022-06-25","5","2022-06-25 01:21:54");
INSERT INTO tbl_recvoucher VALUES("213","0","REV250622102","","24000.00","2022-06-25","5","2022-06-25 06:46:07");
INSERT INTO tbl_recvoucher VALUES("214","0","REV250622103","","25000.00","2022-06-25","5","2022-06-25 08:03:58");
INSERT INTO tbl_recvoucher VALUES("215","0","REV260622101","","60000.00","2022-06-26","5","2022-06-26 08:00:36");
INSERT INTO tbl_recvoucher VALUES("216","0","REV260622102","","26000.00","2022-06-26","5","2022-06-26 08:01:33");
INSERT INTO tbl_recvoucher VALUES("217","0","REV260622103","","50000.00","2022-06-26","5","2022-06-26 08:03:42");
INSERT INTO tbl_recvoucher VALUES("218","0","REV260622104","","24500.00","2022-06-26","5","2022-06-26 08:04:19");
INSERT INTO tbl_recvoucher VALUES("219","0","REV260622105","","40000.00","2022-06-26","5","2022-06-26 08:06:18");
INSERT INTO tbl_recvoucher VALUES("220","0","REV270622101","","26000.00","2022-06-27","5","2022-06-27 11:45:25");
INSERT INTO tbl_recvoucher VALUES("221","0","REV270622102","","55000.00","2022-06-27","5","2022-06-27 12:24:18");
INSERT INTO tbl_recvoucher VALUES("222","0","REV270622103","","60000.00","2022-06-27","5","2022-06-27 01:56:41");
INSERT INTO tbl_recvoucher VALUES("223","0","REV270622104","","25000.00","2022-06-27","5","2022-06-27 04:02:03");
INSERT INTO tbl_recvoucher VALUES("224","0","REV270622105","","24500.00","2022-06-27","5","2022-06-27 06:19:26");
INSERT INTO tbl_recvoucher VALUES("225","0","REV290622101","","26000.00","2022-06-29","5","2022-06-29 12:48:22");
INSERT INTO tbl_recvoucher VALUES("226","0","REV290622102","","50000.00","2022-06-29","5","2022-06-29 12:48:44");
INSERT INTO tbl_recvoucher VALUES("227","0","REV290622103","","25000.00","2022-06-29","5","2022-06-29 05:37:32");
INSERT INTO tbl_recvoucher VALUES("228","0","REV300622101","","50000.00","2022-06-30","5","2022-06-30 08:07:04");
INSERT INTO tbl_recvoucher VALUES("229","0","REV300622102","","21000.00","2022-06-30","5","2022-06-30 08:21:10");
INSERT INTO tbl_recvoucher VALUES("230","0","REV020722101","","25000.00","2022-07-02","5","2022-07-02 12:50:26");
INSERT INTO tbl_recvoucher VALUES("231","0","REV020722102","","20000.00","2022-07-02","5","2022-07-02 03:42:49");
INSERT INTO tbl_recvoucher VALUES("232","0","REV020722103","","25000.00","2022-07-02","5","2022-07-02 05:09:33");
INSERT INTO tbl_recvoucher VALUES("233","0","REV020722104","","25000.00","2022-07-02","5","2022-07-02 09:00:24");
INSERT INTO tbl_recvoucher VALUES("234","0","REV030722101","","50000.00","2022-07-03","5","2022-07-03 05:03:17");
INSERT INTO tbl_recvoucher VALUES("235","0","REV030722102","","1000.00","2022-07-03","5","2022-07-03 09:02:16");
INSERT INTO tbl_recvoucher VALUES("236","0","REV040722101","","7000.00","2022-07-04","5","2022-07-04 12:24:40");
INSERT INTO tbl_recvoucher VALUES("237","0","REV040722102","","69700.00","2022-07-04","5","2022-07-04 06:37:58");
INSERT INTO tbl_recvoucher VALUES("238","0","REV040722103","","15000.00","2022-07-04","5","2022-07-04 07:10:36");
INSERT INTO tbl_recvoucher VALUES("239","0","REV040722104","","13500.00","2022-07-04","5","2022-07-04 08:32:40");
INSERT INTO tbl_recvoucher VALUES("240","0","REV050722101","","25500.00","2022-07-05","5","2022-07-05 11:51:58");
INSERT INTO tbl_recvoucher VALUES("241","0","REV050722102","","9000.00","2022-07-05","5","2022-07-05 12:18:15");
INSERT INTO tbl_recvoucher VALUES("242","0","REV050722103","","86000.00","2022-07-05","5","2022-07-05 12:55:35");
INSERT INTO tbl_recvoucher VALUES("243","0","REV050722104","","10500.00","2022-07-05","5","2022-07-05 01:04:57");
INSERT INTO tbl_recvoucher VALUES("244","0","REV050722105","","16000.00","2022-07-05","5","2022-07-05 04:54:55");
INSERT INTO tbl_recvoucher VALUES("245","0","REV050722106","","40000.00","2022-07-05","5","2022-07-05 04:55:27");
INSERT INTO tbl_recvoucher VALUES("246","0","REV060722101","","25000.00","2022-07-06","5","2022-07-06 01:31:19");
INSERT INTO tbl_recvoucher VALUES("247","0","REV060722102","","19500.00","2022-07-06","5","2022-07-06 02:18:29");
INSERT INTO tbl_recvoucher VALUES("248","0","REV060722103","","40000.00","2022-07-06","5","2022-07-06 02:25:07");
INSERT INTO tbl_recvoucher VALUES("249","0","REV060722104","","15000.00","2022-07-06","5","2022-07-06 07:39:10");
INSERT INTO tbl_recvoucher VALUES("250","0","REV060722105","","25000.00","2022-07-06","5","2022-07-06 08:24:17");
INSERT INTO tbl_recvoucher VALUES("251","0","REV070722101","","50000.00","2022-07-07","5","2022-07-07 02:31:22");
INSERT INTO tbl_recvoucher VALUES("252","0","REV070722102","","15000.00","2022-07-07","5","2022-07-07 04:36:34");
INSERT INTO tbl_recvoucher VALUES("253","0","REV070722103","","70000.00","2022-07-07","5","2022-07-07 06:57:29");
INSERT INTO tbl_recvoucher VALUES("254","0","REV070722104","","5000.00","2022-07-07","5","2022-07-07 07:48:23");
INSERT INTO tbl_recvoucher VALUES("255","0","REV080722101","","20000.00","2022-07-08","5","2022-07-08 02:54:30");
INSERT INTO tbl_recvoucher VALUES("256","0","REV090722101","","5000.00","2022-07-09","5","2022-07-09 12:38:06");
INSERT INTO tbl_recvoucher VALUES("257","0","REV090722102","","25000.00","2022-07-09","5","2022-07-09 12:38:25");
INSERT INTO tbl_recvoucher VALUES("258","0","REV090722103","","40000.00","2022-07-09","5","2022-07-09 05:02:13");
INSERT INTO tbl_recvoucher VALUES("259","0","REV140722101","","25000.00","2022-07-14","5","2022-07-14 02:45:57");
INSERT INTO tbl_recvoucher VALUES("260","0","REV160722101","","9500.00","2022-07-16","5","2022-07-16 01:17:59");
INSERT INTO tbl_recvoucher VALUES("261","0","REV160722102","","50000.00","2022-07-16","5","2022-07-16 02:35:41");
INSERT INTO tbl_recvoucher VALUES("262","0","REV170722101","","31000.00","2022-07-17","5","2022-07-17 01:24:40");
INSERT INTO tbl_recvoucher VALUES("263","0","REV170722102","","100000.00","2022-07-17","5","2022-07-17 02:27:36");
INSERT INTO tbl_recvoucher VALUES("264","0","REV180722101","","30000.00","2022-07-18","5","2022-07-18 06:22:03");
INSERT INTO tbl_recvoucher VALUES("265","0","REV180722102","","22000.00","2022-07-18","5","2022-07-18 06:22:24");
INSERT INTO tbl_recvoucher VALUES("266","0","REV180722103","","50000.00","2022-07-18","5","2022-07-18 06:22:40");
INSERT INTO tbl_recvoucher VALUES("267","0","REV180722104","","2000.00","2022-07-18","5","2022-07-18 06:22:57");
INSERT INTO tbl_recvoucher VALUES("268","0","REV200722101","","60000.00","2022-07-20","5","2022-07-20 12:28:56");
INSERT INTO tbl_recvoucher VALUES("269","0","REV200722102","","11000.00","2022-07-20","5","2022-07-20 07:55:49");
INSERT INTO tbl_recvoucher VALUES("270","0","REV210722101","","47000.00","2022-07-21","5","2022-07-21 12:55:45");
INSERT INTO tbl_recvoucher VALUES("271","0","REV210722102","","710600.00","2022-07-21","5","2022-07-21 12:56:53");
INSERT INTO tbl_recvoucher VALUES("272","0","REV210722103","","25000.00","2022-07-21","5","2022-07-21 01:31:02");
INSERT INTO tbl_recvoucher VALUES("273","0","REV210722104","","24500.00","2022-07-21","5","2022-07-21 04:25:35");
INSERT INTO tbl_recvoucher VALUES("274","0","REV210722105","","50000.00","2022-07-21","5","2022-07-21 07:39:56");
INSERT INTO tbl_recvoucher VALUES("275","0","REV220722101","","80000.00","2022-07-22","5","2022-07-22 12:05:54");
INSERT INTO tbl_recvoucher VALUES("276","0","REV220722102","","16500.00","2022-07-22","5","2022-07-22 04:06:43");
INSERT INTO tbl_recvoucher VALUES("277","0","REV220722103","","45000.00","2022-07-22","5","2022-07-22 05:09:03");
INSERT INTO tbl_recvoucher VALUES("278","0","REV220722104","","21000.00","2022-07-22","5","2022-07-22 07:46:50");
INSERT INTO tbl_recvoucher VALUES("279","0","REV230722101","","46000.00","2022-07-23","5","2022-07-23 05:28:35");
INSERT INTO tbl_recvoucher VALUES("280","0","REV230722102","","20000.00","2022-07-23","5","2022-07-23 05:44:34");
INSERT INTO tbl_recvoucher VALUES("281","0","REV230722103","","27000.00","2022-07-23","5","2022-07-23 07:10:58");
INSERT INTO tbl_recvoucher VALUES("282","0","REV240722101","","20000.00","2022-07-24","5","2022-07-24 12:13:18");
INSERT INTO tbl_recvoucher VALUES("283","0","REV240722102","","24500.00","2022-07-24","5","2022-07-24 02:09:15");
INSERT INTO tbl_recvoucher VALUES("284","0","REV240722103","","35000.00","2022-07-24","5","2022-07-24 02:33:08");
INSERT INTO tbl_recvoucher VALUES("285","0","REV240722104","","52500.00","2022-07-24","5","2022-07-24 03:57:23");
INSERT INTO tbl_recvoucher VALUES("286","0","REV240722105","","14500.00","2022-07-24","5","2022-07-24 06:07:58");
INSERT INTO tbl_recvoucher VALUES("287","0","REV240722106","","25000.00","2022-07-24","5","2022-07-24 06:50:44");
INSERT INTO tbl_recvoucher VALUES("288","0","REV250722101","","120000.00","2022-07-25","5","2022-07-25 03:27:51");
INSERT INTO tbl_recvoucher VALUES("289","0","REV250722102","","50000.00","2022-07-25","5","2022-07-25 04:00:37");
INSERT INTO tbl_recvoucher VALUES("290","0","REV250722103","","8000.00","2022-07-25","5","2022-07-25 04:47:04");
INSERT INTO tbl_recvoucher VALUES("291","0","REV270722101","","9000.00","2022-07-27","5","2022-07-27 11:39:33");
INSERT INTO tbl_recvoucher VALUES("292","0","REV270722102","For 840 G3 Return","25000.00","2022-07-27","5","2022-07-27 11:43:37");
INSERT INTO tbl_recvoucher VALUES("293","0","REV270722103","","16000.00","2022-07-27","5","2022-07-27 11:46:31");
INSERT INTO tbl_recvoucher VALUES("294","0","REV270722104","","77000.00","2022-07-27","5","2022-07-27 11:49:57");
INSERT INTO tbl_recvoucher VALUES("295","0","REV270722105","","6000.00","2022-07-27","5","2022-07-27 05:41:22");
INSERT INTO tbl_recvoucher VALUES("296","0","REV270722106","","120000.00","2022-07-27","5","2022-07-27 06:52:03");
INSERT INTO tbl_recvoucher VALUES("297","0","REV270722107","","23500.00","2022-07-27","5","2022-07-27 06:52:29");
INSERT INTO tbl_recvoucher VALUES("298","0","REV270722108","","50000.00","2022-07-27","5","2022-07-27 09:16:38");
INSERT INTO tbl_recvoucher VALUES("299","0","REV270722109","","34000.00","2022-07-27","5","2022-07-27 09:22:29");
INSERT INTO tbl_recvoucher VALUES("300","0","REV280722101","","24000.00","2022-07-28","5","2022-07-28 11:01:09");
INSERT INTO tbl_recvoucher VALUES("301","0","REV280722102","","20000.00","2022-07-28","5","2022-07-28 02:13:51");
INSERT INTO tbl_recvoucher VALUES("302","0","REV280722103","","50000.00","2022-07-28","5","2022-07-28 02:24:34");
INSERT INTO tbl_recvoucher VALUES("303","0","REV280722104","","30000.00","2022-07-28","5","2022-07-28 10:40:41");
INSERT INTO tbl_recvoucher VALUES("304","0","REV290722101","","24500.00","2022-07-29","5","2022-07-29 07:29:13");
INSERT INTO tbl_recvoucher VALUES("305","0","REV300722101","","120500.00","2022-07-30","5","2022-07-30 12:34:24");
INSERT INTO tbl_recvoucher VALUES("306","0","REV310722101","","100000.00","2022-07-31","5","2022-07-31 05:48:23");
INSERT INTO tbl_recvoucher VALUES("307","0","REV310722102","","15000.00","2022-07-31","5","2022-07-31 06:44:37");
INSERT INTO tbl_recvoucher VALUES("308","0","REV010822101","","40000.00","2022-08-01","5","2022-08-01 12:18:28");
INSERT INTO tbl_recvoucher VALUES("309","0","REV010822102","","50000.00","2022-08-01","5","2022-08-01 03:47:03");
INSERT INTO tbl_recvoucher VALUES("310","0","REV010822103","","36000.00","2022-08-01","5","2022-08-01 03:50:20");
INSERT INTO tbl_recvoucher VALUES("311","0","REV010822104","","100000.00","2022-08-01","5","2022-08-01 05:54:09");
INSERT INTO tbl_recvoucher VALUES("312","0","REV010822105","","10000.00","2022-08-01","5","2022-08-01 07:24:38");
INSERT INTO tbl_recvoucher VALUES("313","0","REV030822101","","44000.00","2022-08-03","5","2022-08-03 01:26:00");
INSERT INTO tbl_recvoucher VALUES("314","0","REV030822102","","25000.00","2022-08-03","5","2022-08-03 01:26:15");
INSERT INTO tbl_recvoucher VALUES("315","0","REV030822103","","100000.00","2022-08-03","5","2022-08-03 04:17:09");
INSERT INTO tbl_recvoucher VALUES("316","0","REV030822104","","25000.00","2022-08-03","5","2022-08-03 07:22:42");
INSERT INTO tbl_recvoucher VALUES("317","0","REV040822101","","54000.00","2022-08-04","5","2022-08-04 12:55:41");
INSERT INTO tbl_recvoucher VALUES("318","0","REV040822102","","50000.00","2022-08-04","5","2022-08-04 01:32:57");
INSERT INTO tbl_recvoucher VALUES("319","0","REV040822103","","11000.00","2022-08-04","5","2022-08-04 02:37:13");
INSERT INTO tbl_recvoucher VALUES("320","0","REV040822104","","5000.00","2022-08-04","5","2022-08-04 07:33:51");
INSERT INTO tbl_recvoucher VALUES("321","0","REV050822101","","48000.00","2022-08-05","5","2022-08-05 01:41:53");
INSERT INTO tbl_recvoucher VALUES("322","0","REV050822102","","100000.00","2022-08-05","5","2022-08-05 06:57:56");
INSERT INTO tbl_recvoucher VALUES("323","0","REV050822103","","30000.00","2022-08-05","5","2022-08-05 06:58:10");
INSERT INTO tbl_recvoucher VALUES("324","0","REV060822101","","40000.00","2022-08-06","5","2022-08-06 12:51:31");
INSERT INTO tbl_recvoucher VALUES("325","0","REV060822102","","30000.00","2022-08-06","5","2022-08-06 07:05:45");
INSERT INTO tbl_recvoucher VALUES("326","0","REV060822103","","45000.00","2022-08-06","5","2022-08-06 07:36:05");
INSERT INTO tbl_recvoucher VALUES("327","0","REV080822101","","100000.00","2022-08-08","5","2022-08-08 01:12:30");
INSERT INTO tbl_recvoucher VALUES("328","0","REV080822102","","25000.00","2022-08-08","5","2022-08-08 02:05:41");
INSERT INTO tbl_recvoucher VALUES("329","0","REV090822101","","30000.00","2022-08-09","5","2022-08-09 11:13:03");
INSERT INTO tbl_recvoucher VALUES("330","0","REV100822101","","24000.00","2022-08-10","5","2022-08-10 12:25:21");
INSERT INTO tbl_recvoucher VALUES("331","0","REV100822102","","200000.00","2022-08-10","5","2022-08-10 12:42:22");
INSERT INTO tbl_recvoucher VALUES("332","0","REV100822103","","19000.00","2022-08-10","5","2022-08-10 01:08:59");
INSERT INTO tbl_recvoucher VALUES("333","0","REV100822104","","123000.00","2022-08-10","5","2022-08-10 07:30:00");
INSERT INTO tbl_recvoucher VALUES("334","0","REV110822101","","20000.00","2022-08-11","5","2022-08-11 01:43:22");
INSERT INTO tbl_recvoucher VALUES("335","0","REV140822101","","90000.00","2022-08-14","5","2022-08-14 11:12:09");
INSERT INTO tbl_recvoucher VALUES("336","0","REV140822102","","27000.00","2022-08-14","5","2022-08-14 01:33:56");
INSERT INTO tbl_recvoucher VALUES("337","0","REV140822103","","146000.00","2022-08-14","5","2022-08-14 01:57:45");
INSERT INTO tbl_recvoucher VALUES("338","0","REV150822101","","28500.00","2022-08-15","5","2022-08-15 09:37:13");
INSERT INTO tbl_recvoucher VALUES("339","0","REV150822102","","61000.00","2022-08-15","5","2022-08-15 09:38:14");
INSERT INTO tbl_recvoucher VALUES("340","0","REV170822101","","25000.00","2022-08-17","5","2022-08-17 11:04:22");
INSERT INTO tbl_recvoucher VALUES("341","0","REV170822102","","14000.00","2022-08-17","5","2022-08-17 04:52:54");
INSERT INTO tbl_recvoucher VALUES("342","0","REV170822103","","80000.00","2022-08-17","5","2022-08-17 05:50:57");
INSERT INTO tbl_recvoucher VALUES("343","0","REV170822104","","22000.00","2022-08-17","5","2022-08-17 06:54:56");
INSERT INTO tbl_recvoucher VALUES("344","0","REV170822105","","25500.00","2022-08-17","5","2022-08-17 07:03:17");
INSERT INTO tbl_recvoucher VALUES("345","0","REV210822101","","100000.00","2022-08-21","5","2022-08-21 01:09:01");
INSERT INTO tbl_recvoucher VALUES("346","0","REV210822102","","200000.00","2022-08-21","5","2022-08-21 03:25:08");
INSERT INTO tbl_recvoucher VALUES("347","0","REV210822103","G3 Adjust Price 24500 To 25000 Unit 22 Tk. 11000","11500.00","2022-08-21","5","2022-08-21 03:27:14");
INSERT INTO tbl_recvoucher VALUES("348","0","REV220822101","","25000.00","2022-08-22","5","2022-08-22 12:14:57");
INSERT INTO tbl_recvoucher VALUES("349","0","REV220822102","","25000.00","2022-08-22","5","2022-08-22 02:27:42");
INSERT INTO tbl_recvoucher VALUES("350","0","REV220822103","","35000.00","2022-08-22","5","2022-08-22 05:16:01");
INSERT INTO tbl_recvoucher VALUES("351","0","REV220822104","","21400.00","2022-08-22","5","2022-08-22 07:28:16");
INSERT INTO tbl_recvoucher VALUES("352","0","REV220822105","Gobindo Personal Sell 840 G3","20000.00","2022-08-22","5","2022-08-22 07:29:29");
INSERT INTO tbl_recvoucher VALUES("353","0","REV220822106","","150000.00","2022-08-22","5","2022-08-22 07:39:04");
INSERT INTO tbl_recvoucher VALUES("354","0","REV220822107","","35000.00","2022-08-22","5","2022-08-22 10:29:26");
INSERT INTO tbl_recvoucher VALUES("355","0","REV220822108","","30000.00","2022-08-22","5","2022-08-22 10:34:28");
INSERT INTO tbl_recvoucher VALUES("356","0","REV220822109","","61500.00","2022-08-22","5","2022-08-22 10:38:43");
INSERT INTO tbl_recvoucher VALUES("357","0","REV230822101","","25000.00","2022-08-23","5","2022-08-23 01:46:02");
INSERT INTO tbl_recvoucher VALUES("358","0","REV230822102","","25000.00","2022-08-23","5","2022-08-23 11:38:20");
INSERT INTO tbl_recvoucher VALUES("359","0","REV230822103","","10000.00","2022-08-23","5","2022-08-23 11:38:35");
INSERT INTO tbl_recvoucher VALUES("360","0","REV240822101","","38000.00","2022-08-24","5","2022-08-24 11:07:45");
INSERT INTO tbl_recvoucher VALUES("361","0","REV240822102","","27000.00","2022-08-24","5","2022-08-24 12:15:37");
INSERT INTO tbl_recvoucher VALUES("362","0","REV240822103","","100000.00","2022-08-24","5","2022-08-24 03:58:34");
INSERT INTO tbl_recvoucher VALUES("363","0","REV240822104","","90000.00","2022-08-24","5","2022-08-24 05:18:13");
INSERT INTO tbl_recvoucher VALUES("364","0","REV240822105","","20000.00","2022-08-24","5","2022-08-24 06:28:32");
INSERT INTO tbl_recvoucher VALUES("365","0","REV240822106","","61500.00","2022-08-24","5","2022-08-24 07:09:59");
INSERT INTO tbl_recvoucher VALUES("366","0","REV240822107","","70000.00","2022-08-24","5","2022-08-24 07:35:06");
INSERT INTO tbl_recvoucher VALUES("367","0","REV240822108","","30700.00","2022-08-24","5","2022-08-24 07:54:16");
INSERT INTO tbl_recvoucher VALUES("368","0","REV250822101","","49000.00","2022-08-25","5","2022-08-25 05:00:12");
INSERT INTO tbl_recvoucher VALUES("369","0","REV250822102","","25000.00","2022-08-25","5","2022-08-25 06:49:14");
INSERT INTO tbl_recvoucher VALUES("370","0","REV250822103","","25000.00","2022-08-25","5","2022-08-25 08:15:54");
INSERT INTO tbl_recvoucher VALUES("371","0","REV260822101","","75000.00","2022-08-26","5","2022-08-26 05:34:24");
INSERT INTO tbl_recvoucher VALUES("372","0","REV280822101","","41500.00","2022-08-28","5","2022-08-28 05:22:08");
INSERT INTO tbl_recvoucher VALUES("373","0","REV280822102","","5000.00","2022-08-28","5","2022-08-28 06:32:25");
INSERT INTO tbl_recvoucher VALUES("374","0","REV280822103","","5000.00","2022-08-28","5","2022-08-28 07:52:14");
INSERT INTO tbl_recvoucher VALUES("375","0","REV280822104","","24500.00","2022-08-28","5","2022-08-28 07:54:51");
INSERT INTO tbl_recvoucher VALUES("376","0","REV280822105","","12500.00","2022-08-28","5","2022-08-28 07:56:30");
INSERT INTO tbl_recvoucher VALUES("377","0","REV290822101","","30000.00","2022-08-29","5","2022-08-29 10:54:52");
INSERT INTO tbl_recvoucher VALUES("378","0","REV290822102","","50000.00","2022-08-29","5","2022-08-29 11:09:44");
INSERT INTO tbl_recvoucher VALUES("379","0","REV290822103","","20000.00","2022-08-29","5","2022-08-29 06:46:56");
INSERT INTO tbl_recvoucher VALUES("380","0","REV290822104","","200000.00","2022-08-29","5","2022-08-29 06:47:22");
INSERT INTO tbl_recvoucher VALUES("381","0","REV290822105","","45000.00","2022-08-29","5","2022-08-29 06:48:04");
INSERT INTO tbl_recvoucher VALUES("382","0","REV310822101","","12500.00","2022-08-31","5","2022-08-31 10:39:50");
INSERT INTO tbl_recvoucher VALUES("383","0","REV310822102","","25000.00","2022-08-31","5","2022-08-31 10:40:51");
INSERT INTO tbl_recvoucher VALUES("384","0","REV310822103","","63000.00","2022-08-31","5","2022-08-31 01:42:37");
INSERT INTO tbl_recvoucher VALUES("385","0","REV310822104","","30000.00","2022-08-31","5","2022-08-31 06:17:57");
INSERT INTO tbl_recvoucher VALUES("386","0","REV010922101","","20000.00","2022-09-01","5","2022-09-01 12:05:13");
INSERT INTO tbl_recvoucher VALUES("387","0","REV010922102","","50000.00","2022-09-01","5","2022-09-01 12:06:38");
INSERT INTO tbl_recvoucher VALUES("388","0","REV010922103","","35000.00","2022-09-01","5","2022-09-01 04:04:11");
INSERT INTO tbl_recvoucher VALUES("389","0","REV020922101","","80000.00","2022-09-02","5","2022-09-02 05:46:26");
INSERT INTO tbl_recvoucher VALUES("390","0","REV040922101","","300000.00","2022-09-04","5","2022-09-04 02:16:26");
INSERT INTO tbl_recvoucher VALUES("391","0","REV040922102","","24000.00","2022-09-04","5","2022-09-04 03:44:49");
INSERT INTO tbl_recvoucher VALUES("392","0","REV040922103","","150000.00","2022-09-04","5","2022-09-04 03:52:14");
INSERT INTO tbl_recvoucher VALUES("393","0","REV040922104","","48500.00","2022-09-04","5","2022-09-04 04:49:55");
INSERT INTO tbl_recvoucher VALUES("394","0","REV040922105","","24000.00","2022-09-04","5","2022-09-04 06:08:22");
INSERT INTO tbl_recvoucher VALUES("395","0","REV040922106","","300.00","2022-09-04","5","2022-09-04 07:48:12");
INSERT INTO tbl_recvoucher VALUES("396","0","REV050922101","","50000.00","2022-09-05","5","2022-09-05 01:47:31");
INSERT INTO tbl_recvoucher VALUES("397","0","REV050922102","","27000.00","2022-09-05","5","2022-09-05 02:09:30");
INSERT INTO tbl_recvoucher VALUES("398","0","REV050922103","","91500.00","2022-09-05","5","2022-09-05 06:35:33");
INSERT INTO tbl_recvoucher VALUES("399","0","REV050922104","","50000.00","2022-09-05","5","2022-09-05 06:35:49");
INSERT INTO tbl_recvoucher VALUES("400","0","REV070922101","","8000.00","2022-09-07","5","2022-09-07 11:20:05");
INSERT INTO tbl_recvoucher VALUES("401","0","REV070922102","","20000.00","2022-09-07","5","2022-09-07 12:18:51");
INSERT INTO tbl_recvoucher VALUES("402","0","REV070922103","","50000.00","2022-09-07","5","2022-09-07 05:15:07");
INSERT INTO tbl_recvoucher VALUES("403","0","REV070922104","","24500.00","2022-09-07","5","2022-09-07 07:34:08");
INSERT INTO tbl_recvoucher VALUES("404","0","REV080922101","","21000.00","2022-09-08","5","2022-09-08 11:53:19");
INSERT INTO tbl_recvoucher VALUES("405","0","REV080922102","","50000.00","2022-09-08","5","2022-09-08 04:47:24");
INSERT INTO tbl_recvoucher VALUES("406","0","REV080922103","","483000.00","2022-09-08","5","2022-09-08 08:00:21");
INSERT INTO tbl_recvoucher VALUES("407","0","REV090922101","","75000.00","2022-09-09","5","2022-09-09 11:12:50");
INSERT INTO tbl_recvoucher VALUES("408","0","REV090922102","","50000.00","2022-09-09","5","2022-09-09 01:25:49");
INSERT INTO tbl_recvoucher VALUES("409","0","REV090922103","","21000.00","2022-09-09","5","2022-09-09 03:27:02");
INSERT INTO tbl_recvoucher VALUES("410","0","REV090922104","","50000.00","2022-09-09","5","2022-09-09 06:52:02");
INSERT INTO tbl_recvoucher VALUES("411","0","REV100922101","","50000.00","2022-09-10","5","2022-09-10 10:58:20");
INSERT INTO tbl_recvoucher VALUES("412","0","REV100922102","","20000.00","2022-09-10","5","2022-09-10 12:37:45");
INSERT INTO tbl_recvoucher VALUES("413","0","REV100922103","","27000.00","2022-09-10","5","2022-09-10 02:18:33");
INSERT INTO tbl_recvoucher VALUES("414","0","REV100922104","","79000.00","2022-09-10","5","2022-09-10 07:22:39");
INSERT INTO tbl_recvoucher VALUES("415","0","REV110922101","","19000.00","2022-09-11","5","2022-09-11 11:55:09");
INSERT INTO tbl_recvoucher VALUES("416","0","REV110922102","","23900.00","2022-09-11","5","2022-09-11 11:55:23");
INSERT INTO tbl_recvoucher VALUES("417","0","REV110922103","","35000.00","2022-09-11","5","2022-09-11 01:39:00");
INSERT INTO tbl_recvoucher VALUES("418","0","REV110922104","","50000.00","2022-09-11","5","2022-09-11 02:08:58");
INSERT INTO tbl_recvoucher VALUES("419","0","REV110922105","","200000.00","2022-09-11","5","2022-09-11 02:09:15");
INSERT INTO tbl_recvoucher VALUES("420","0","REV110922106","","89200.00","2022-09-11","5","2022-09-11 05:38:10");
INSERT INTO tbl_recvoucher VALUES("421","0","REV110922107","","42000.00","2022-09-11","5","2022-09-11 06:57:12");
INSERT INTO tbl_recvoucher VALUES("422","0","REV110922108","","50000.00","2022-09-11","5","2022-09-11 07:59:42");
INSERT INTO tbl_recvoucher VALUES("423","0","REV120922101","","12500.00","2022-09-12","5","2022-09-12 12:25:30");
INSERT INTO tbl_recvoucher VALUES("424","0","REV120922102","","24500.00","2022-09-12","5","2022-09-12 05:54:55");
INSERT INTO tbl_recvoucher VALUES("425","0","REV120922103","","27000.00","2022-09-12","5","2022-09-12 06:06:06");
INSERT INTO tbl_recvoucher VALUES("426","0","REV120922104","","32000.00","2022-09-12","5","2022-09-12 06:42:01");
INSERT INTO tbl_recvoucher VALUES("427","0","REV120922105","","23800.00","2022-09-12","5","2022-09-12 06:44:24");
INSERT INTO tbl_recvoucher VALUES("428","0","REV120922106","","100000.00","2022-09-12","5","2022-09-12 08:09:01");
INSERT INTO tbl_recvoucher VALUES("429","0","REV130922101","","20000.00","2022-09-13","5","2022-09-13 02:54:17");
INSERT INTO tbl_recvoucher VALUES("430","0","REV130922102","","85000.00","2022-09-13","5","2022-09-13 07:32:39");
INSERT INTO tbl_recvoucher VALUES("431","0","REV140922101","","500000.00","2022-09-14","5","2022-09-14 03:41:52");
INSERT INTO tbl_recvoucher VALUES("432","0","REV140922102","","8000.00","2022-09-14","5","2022-09-14 06:32:37");
INSERT INTO tbl_recvoucher VALUES("433","0","REV150922101","","2000.00","2022-09-15","5","2022-09-15 11:55:14");
INSERT INTO tbl_recvoucher VALUES("434","0","REV150922102","","168000.00","2022-09-15","5","2022-09-15 12:43:45");
INSERT INTO tbl_recvoucher VALUES("435","0","REV150922103","","300000.00","2022-09-15","5","2022-09-15 04:59:03");
INSERT INTO tbl_recvoucher VALUES("436","0","REV150922104","","17500.00","2022-09-15","5","2022-09-15 05:14:16");
INSERT INTO tbl_recvoucher VALUES("437","0","REV150922105","","100000.00","2022-09-15","5","2022-09-15 05:38:36");
INSERT INTO tbl_recvoucher VALUES("438","0","REV150922106","","100000.00","2022-09-15","5","2022-09-15 08:19:54");
INSERT INTO tbl_recvoucher VALUES("439","0","REV160922101","","1000000.00","2022-09-16","5","2022-09-16 04:34:53");
INSERT INTO tbl_recvoucher VALUES("440","0","REV160922102","","138000.00","2022-09-16","5","2022-09-16 05:02:45");
INSERT INTO tbl_recvoucher VALUES("441","0","REV160922103","","32000.00","2022-09-16","5","2022-09-16 05:39:00");
INSERT INTO tbl_recvoucher VALUES("442","0","REV180922101","","50000.00","2022-09-18","5","2022-09-18 01:11:46");
INSERT INTO tbl_recvoucher VALUES("443","0","REV180922102","","50000.00","2022-09-18","5","2022-09-18 01:12:23");
INSERT INTO tbl_recvoucher VALUES("444","0","REV180922103","","373500.00","2022-09-18","5","2022-09-18 12:11:41");
INSERT INTO tbl_recvoucher VALUES("445","0","REV180922104","","200000.00","2022-09-18","5","2022-09-18 03:51:33");
INSERT INTO tbl_recvoucher VALUES("446","0","REV180922105","","200000.00","2022-09-18","5","2022-09-18 03:52:16");
INSERT INTO tbl_recvoucher VALUES("447","0","REV190922101","","178000.00","2022-09-19","5","2022-09-19 01:20:00");
INSERT INTO tbl_recvoucher VALUES("448","0","REV200922101","","200000.00","2022-09-20","5","2022-09-20 02:28:45");
INSERT INTO tbl_recvoucher VALUES("449","0","REV230922101","","225000.00","2022-09-23","5","2022-09-23 01:43:55");
INSERT INTO tbl_recvoucher VALUES("450","0","REV230922102","","2500.00","2022-09-23","5","2022-09-23 01:52:58");
INSERT INTO tbl_recvoucher VALUES("451","0","REV250922101","","50000.00","2022-09-25","5","2022-09-25 03:52:27");
INSERT INTO tbl_recvoucher VALUES("452","0","REV270922101","","400000.00","2022-09-27","5","2022-09-27 12:35:42");
INSERT INTO tbl_recvoucher VALUES("453","0","REV270922102","","500000.00","2022-09-27","5","2022-09-27 12:36:03");
INSERT INTO tbl_recvoucher VALUES("454","0","REV270922103","","500000.00","2022-09-27","5","2022-09-27 12:36:26");
INSERT INTO tbl_recvoucher VALUES("455","0","REV280922101","","30000.00","2022-09-28","5","2022-09-28 04:40:22");
INSERT INTO tbl_recvoucher VALUES("456","0","REV300922101","","50000.00","2022-09-30","5","2022-09-30 04:26:53");
INSERT INTO tbl_recvoucher VALUES("457","0","REV300922102","","300000.00","2022-09-30","5","2022-09-30 04:27:57");
INSERT INTO tbl_recvoucher VALUES("458","0","REV031022101","","410000.00","2022-10-03","5","2022-10-03 12:52:45");
INSERT INTO tbl_recvoucher VALUES("459","0","REV031022102","","100000.00","2022-10-03","5","2022-10-03 01:09:07");
INSERT INTO tbl_recvoucher VALUES("460","0","REV031022103","","25000.00","2022-10-03","5","2022-10-03 02:26:38");
INSERT INTO tbl_recvoucher VALUES("461","0","REV031022104","","5000.00","2022-10-03","5","2022-10-03 02:41:15");
INSERT INTO tbl_recvoucher VALUES("462","0","REV031022105","","24000.00","2022-10-03","5","2022-10-03 02:44:20");
INSERT INTO tbl_recvoucher VALUES("463","0","REV041022101","","270000.00","2022-10-04","5","2022-10-04 01:09:23");
INSERT INTO tbl_recvoucher VALUES("464","0","REV041022102","","247500.00","2022-10-04","5","2022-10-04 01:34:25");
INSERT INTO tbl_recvoucher VALUES("465","0","REV041022103","","49000.00","2022-10-04","5","2022-10-04 01:45:08");
INSERT INTO tbl_recvoucher VALUES("466","0","REV041022104","","20000.00","2022-10-04","5","2022-10-04 01:45:44");
INSERT INTO tbl_recvoucher VALUES("467","0","REV041022105","","5500.00","2022-10-04","5","2022-10-04 01:54:12");
INSERT INTO tbl_recvoucher VALUES("468","0","REV041022106","","47000.00","2022-10-04","5","2022-10-04 01:57:18");
INSERT INTO tbl_recvoucher VALUES("469","0","REV041022107","","19000.00","2022-10-04","5","2022-10-04 02:30:33");
INSERT INTO tbl_recvoucher VALUES("470","0","REV041022108","","50000.00","2022-10-04","5","2022-10-04 03:04:55");
INSERT INTO tbl_recvoucher VALUES("471","0","REV041022109","","250000.00","2022-10-04","5","2022-10-04 03:10:56");
INSERT INTO tbl_recvoucher VALUES("472","0","REV051022101","","24000.00","2022-10-05","5","2022-10-05 04:17:49");
INSERT INTO tbl_recvoucher VALUES("473","0","REV071022101","","112500.00","2022-10-07","5","2022-10-07 04:29:08");
INSERT INTO tbl_recvoucher VALUES("474","0","REV091022101","","50000.00","2022-10-09","5","2022-10-09 02:04:41");
INSERT INTO tbl_recvoucher VALUES("475","0","REV091022102","","24000.00","2022-10-09","5","2022-10-09 05:24:02");
INSERT INTO tbl_recvoucher VALUES("476","0","REV111022101","","61100.00","2022-10-11","5","2022-10-11 02:31:09");
INSERT INTO tbl_recvoucher VALUES("477","0","REV111022102","","238000.00","2022-10-11","5","2022-10-11 02:31:37");
INSERT INTO tbl_recvoucher VALUES("478","0","REV121022101","","46500.00","2022-10-12","5","2022-10-12 02:48:21");
INSERT INTO tbl_recvoucher VALUES("479","0","REV131022101","","25000.00","2022-10-13","5","2022-10-13 02:38:45");
INSERT INTO tbl_recvoucher VALUES("480","0","REV151022101","","40500.00","2022-10-15","5","2022-10-15 01:17:46");
INSERT INTO tbl_recvoucher VALUES("481","0","REV161022101","","200000.00","2022-10-16","5","2022-10-16 12:54:18");
INSERT INTO tbl_recvoucher VALUES("482","0","REV171022101","","99000.00","2022-10-17","5","2022-10-17 11:54:42");
INSERT INTO tbl_recvoucher VALUES("483","0","REV171022102","","25000.00","2022-10-17","5","2022-10-17 04:05:16");
INSERT INTO tbl_recvoucher VALUES("484","0","REV171022103","","300000.00","2022-10-17","5","2022-10-17 05:06:04");
INSERT INTO tbl_recvoucher VALUES("485","0","REV171022104","","148000.00","2022-10-17","5","2022-10-17 05:06:58");
INSERT INTO tbl_recvoucher VALUES("486","0","REV171022105","","12000.00","2022-10-17","5","2022-10-17 05:29:41");
INSERT INTO tbl_recvoucher VALUES("487","0","REV171022106","","20000.00","2022-10-17","5","2022-10-17 07:12:53");
INSERT INTO tbl_recvoucher VALUES("488","0","REV171022107","","232500.00","2022-10-17","5","2022-10-17 07:23:37");
INSERT INTO tbl_recvoucher VALUES("489","0","REV191022101","","70000.00","2022-10-19","5","2022-10-19 01:05:22");
INSERT INTO tbl_recvoucher VALUES("490","0","REV191022102","","24500.00","2022-10-19","5","2022-10-19 07:46:37");
INSERT INTO tbl_recvoucher VALUES("491","0","REV191022103","","25000.00","2022-10-19","5","2022-10-19 07:56:25");
INSERT INTO tbl_recvoucher VALUES("492","0","REV201022101","","30000.00","2022-10-20","5","2022-10-20 11:14:36");
INSERT INTO tbl_recvoucher VALUES("493","0","REV201022102","","20000.00","2022-10-20","5","2022-10-20 11:14:56");
INSERT INTO tbl_recvoucher VALUES("494","0","REV201022103","","10000.00","2022-10-20","5","2022-10-20 11:44:21");
INSERT INTO tbl_recvoucher VALUES("495","0","REV201022104","","110000.00","2022-10-20","5","2022-10-20 02:54:59");
INSERT INTO tbl_recvoucher VALUES("496","0","REV211022101","","38000.00","2022-10-21","5","2022-10-21 12:28:29");
INSERT INTO tbl_recvoucher VALUES("497","0","REV211022102","","26000.00","2022-10-21","5","2022-10-21 06:48:22");
INSERT INTO tbl_recvoucher VALUES("498","0","REV211022103","","24500.00","2022-10-21","5","2022-10-21 07:36:39");
INSERT INTO tbl_recvoucher VALUES("499","0","REV221022101","","1000.00","2022-10-22","5","2022-10-22 05:22:11");
INSERT INTO tbl_recvoucher VALUES("500","0","REV221022102","","40000.00","2022-10-22","5","2022-10-22 06:24:56");
INSERT INTO tbl_recvoucher VALUES("501","0","REV221022103","","27000.00","2022-10-22","5","2022-10-22 06:42:05");
INSERT INTO tbl_recvoucher VALUES("502","0","REV221022104","","10000.00","2022-10-22","5","2022-10-22 07:19:32");
INSERT INTO tbl_recvoucher VALUES("503","0","REV231022101","","100000.00","2022-10-23","5","2022-10-23 11:50:10");
INSERT INTO tbl_recvoucher VALUES("504","0","REV231022102","","24500.00","2022-10-23","5","2022-10-23 04:26:09");
INSERT INTO tbl_recvoucher VALUES("505","0","REV231022103","","49000.00","2022-10-23","5","2022-10-23 04:29:09");
INSERT INTO tbl_recvoucher VALUES("506","0","REV231022104","","1000000.00","2022-10-23","5","2022-10-23 04:29:29");
INSERT INTO tbl_recvoucher VALUES("507","0","REV231022105","","80000.00","2022-10-23","5","2022-10-23 05:58:57");
INSERT INTO tbl_recvoucher VALUES("508","0","REV231022106","","24000.00","2022-10-23","5","2022-10-23 06:52:29");
INSERT INTO tbl_recvoucher VALUES("509","0","REV261022101","","56000.00","2022-10-26","5","2022-10-26 11:32:54");
INSERT INTO tbl_recvoucher VALUES("510","0","REV261022102","","100000.00","2022-10-26","5","2022-10-26 12:52:26");
INSERT INTO tbl_recvoucher VALUES("511","0","REV261022103","","12500.00","2022-10-26","5","2022-10-26 05:27:29");
INSERT INTO tbl_recvoucher VALUES("512","0","REV261022104","","23000.00","2022-10-26","5","2022-10-26 07:37:27");
INSERT INTO tbl_recvoucher VALUES("513","0","REV271022101","","27000.00","2022-10-27","5","2022-10-27 11:09:48");
INSERT INTO tbl_recvoucher VALUES("514","0","REV281022101","","53500.00","2022-10-28","5","2022-10-28 03:05:32");
INSERT INTO tbl_recvoucher VALUES("515","0","REV281022102","","100000.00","2022-10-28","5","2022-10-28 07:09:22");
INSERT INTO tbl_recvoucher VALUES("516","0","REV291022101","","23500.00","2022-10-29","5","2022-10-29 11:01:22");
INSERT INTO tbl_recvoucher VALUES("517","0","REV291022102","","436100.00","2022-10-29","5","2022-10-29 11:30:07");
INSERT INTO tbl_recvoucher VALUES("518","0","REV291022103","","224000.00","2022-10-29","5","2022-10-29 11:50:05");
INSERT INTO tbl_recvoucher VALUES("519","0","REV291022104","","24000.00","2022-10-29","5","2022-10-29 12:01:38");
INSERT INTO tbl_recvoucher VALUES("520","0","REV291022105","","50000.00","2022-10-29","5","2022-10-29 04:29:46");
INSERT INTO tbl_recvoucher VALUES("521","0","REV291022106","","150000.00","2022-10-29","5","2022-10-29 05:07:40");
INSERT INTO tbl_recvoucher VALUES("522","0","REV301022101","","56000.00","2022-10-30","5","2022-10-30 11:50:11");
INSERT INTO tbl_recvoucher VALUES("523","0","REV301022102","","500.00","2022-10-30","5","2022-10-30 11:50:24");
INSERT INTO tbl_recvoucher VALUES("524","0","REV301022103","","89000.00","2022-10-30","5","2022-10-30 11:50:45");
INSERT INTO tbl_recvoucher VALUES("525","0","REV301022104","","21500.00","2022-10-30","5","2022-10-30 11:51:13");
INSERT INTO tbl_recvoucher VALUES("526","0","REV301022105","","4700.00","2022-10-30","5","2022-10-30 11:51:33");
INSERT INTO tbl_recvoucher VALUES("527","0","REV301022106","","35800.00","2022-10-30","5","2022-10-30 11:52:06");
INSERT INTO tbl_recvoucher VALUES("528","0","REV301022107","","19000.00","2022-10-30","5","2022-10-30 02:41:58");
INSERT INTO tbl_recvoucher VALUES("529","0","REV301022108","","150000.00","2022-10-30","5","2022-10-30 03:57:28");
INSERT INTO tbl_recvoucher VALUES("530","0","REV301022109","","250000.00","2022-10-30","5","2022-10-30 03:57:56");
INSERT INTO tbl_recvoucher VALUES("531","0","REV301022110","","44000.00","2022-10-30","5","2022-10-30 04:37:56");
INSERT INTO tbl_recvoucher VALUES("532","0","REV301022111","","25000.00","2022-10-30","5","2022-10-30 04:43:11");
INSERT INTO tbl_recvoucher VALUES("533","0","REV301022112","","100000.00","2022-10-30","5","2022-10-30 06:23:20");
INSERT INTO tbl_recvoucher VALUES("534","0","REV301022113","","35000.00","2022-10-30","5","2022-10-30 06:29:06");
INSERT INTO tbl_recvoucher VALUES("535","0","REV301022114","","42500.00","2022-10-30","5","2022-10-30 07:32:56");
INSERT INTO tbl_recvoucher VALUES("536","0","REV311022101","","6000.00","2022-10-31","5","2022-10-31 10:44:23");
INSERT INTO tbl_recvoucher VALUES("537","0","REV311022102","","210000.00","2022-10-31","5","2022-10-31 10:56:35");
INSERT INTO tbl_recvoucher VALUES("538","0","REV311022103","","13000.00","2022-10-31","5","2022-10-31 12:48:00");
INSERT INTO tbl_recvoucher VALUES("539","0","REV311022104","","20000.00","2022-10-31","5","2022-10-31 04:54:01");
INSERT INTO tbl_recvoucher VALUES("540","0","REV021122101","","35000.00","2022-11-02","5","2022-11-02 11:09:45");
INSERT INTO tbl_recvoucher VALUES("541","0","REV021122102","","29000.00","2022-11-02","5","2022-11-02 11:10:01");
INSERT INTO tbl_recvoucher VALUES("542","0","REV021122103","","75000.00","2022-11-02","5","2022-11-02 11:11:12");
INSERT INTO tbl_recvoucher VALUES("543","0","REV021122104","","33000.00","2022-11-02","5","2022-11-02 06:22:55");
INSERT INTO tbl_recvoucher VALUES("544","0","REV031122101","","295000.00","2022-11-03","5","2022-11-03 03:47:08");
INSERT INTO tbl_recvoucher VALUES("545","0","REV041122101","","76000.00","2022-11-04","5","2022-11-04 11:05:31");
INSERT INTO tbl_recvoucher VALUES("546","0","REV041122102","","36000.00","2022-11-04","5","2022-11-04 11:06:14");
INSERT INTO tbl_recvoucher VALUES("547","0","REV041122103","","66000.00","2022-11-04","5","2022-11-04 02:03:14");
INSERT INTO tbl_recvoucher VALUES("548","0","REV041122104","","45000.00","2022-11-04","5","2022-11-04 07:14:15");
INSERT INTO tbl_recvoucher VALUES("549","0","REV061122101","","620000.00","2022-11-06","5","2022-11-06 10:57:52");
INSERT INTO tbl_recvoucher VALUES("550","0","REV091122101","","20000.00","2022-11-09","5","2022-11-09 01:17:34");
INSERT INTO tbl_recvoucher VALUES("551","0","REV091122102","","40000.00","2022-11-09","5","2022-11-09 01:37:14");
INSERT INTO tbl_recvoucher VALUES("552","0","REV091122103","","233000.00","2022-11-09","5","2022-11-09 01:59:04");
INSERT INTO tbl_recvoucher VALUES("553","0","REV091122104","","44000.00","2022-11-09","5","2022-11-09 03:28:53");
INSERT INTO tbl_recvoucher VALUES("554","0","REV091122105","","24000.00","2022-11-09","5","2022-11-09 03:30:15");
INSERT INTO tbl_recvoucher VALUES("555","0","REV091122106","","100000.00","2022-11-09","5","2022-11-09 06:18:38");
INSERT INTO tbl_recvoucher VALUES("556","0","REV101122101","","100000.00","2022-11-10","5","2022-11-10 01:04:09");
INSERT INTO tbl_recvoucher VALUES("557","0","REV111122101","","250000.00","2022-11-11","5","2022-11-11 01:19:36");
INSERT INTO tbl_recvoucher VALUES("558","0","REV111122102","","10000.00","2022-11-11","5","2022-11-11 01:22:06");
INSERT INTO tbl_recvoucher VALUES("559","0","REV111122103","","49000.00","2022-11-11","5","2022-11-11 01:23:01");
INSERT INTO tbl_recvoucher VALUES("560","0","REV111122104","","32000.00","2022-11-11","5","2022-11-11 01:25:03");
INSERT INTO tbl_recvoucher VALUES("561","0","REV111122105","","164000.00","2022-11-11","5","2022-11-11 01:27:18");
INSERT INTO tbl_recvoucher VALUES("562","0","REV111122106","","3000.00","2022-11-11","5","2022-11-11 07:36:04");
INSERT INTO tbl_recvoucher VALUES("563","0","REV121122101","","45000.00","2022-11-12","5","2022-11-12 04:27:57");
INSERT INTO tbl_recvoucher VALUES("564","0","REV131122101","","30000.00","2022-11-13","5","2022-11-13 04:53:55");
INSERT INTO tbl_recvoucher VALUES("565","0","REV141122101","","46000.00","2022-11-14","5","2022-11-14 11:22:30");
INSERT INTO tbl_recvoucher VALUES("566","0","REV141122102","","183500.00","2022-11-14","5","2022-11-14 11:29:41");
INSERT INTO tbl_recvoucher VALUES("567","0","REV161122101","","34500.00","2022-11-16","5","2022-11-16 01:57:42");
INSERT INTO tbl_recvoucher VALUES("568","0","REV161122102","","200000.00","2022-11-16","5","2022-11-16 04:00:37");
INSERT INTO tbl_recvoucher VALUES("569","0","REV161122103","","30000.00","2022-11-16","5","2022-11-16 04:05:15");
INSERT INTO tbl_recvoucher VALUES("570","0","REV171122101","","90000.00","2022-11-17","5","2022-11-17 11:26:29");
INSERT INTO tbl_recvoucher VALUES("571","0","REV171122102","","50000.00","2022-11-17","5","2022-11-17 12:37:45");
INSERT INTO tbl_recvoucher VALUES("572","0","REV171122103","","22500.00","2022-11-17","5","2022-11-17 12:39:14");
INSERT INTO tbl_recvoucher VALUES("573","0","REV171122104","","45000.00","2022-11-17","5","2022-11-17 02:08:26");
INSERT INTO tbl_recvoucher VALUES("574","0","REV171122105","","30000.00","2022-11-17","5","2022-11-17 05:56:17");
INSERT INTO tbl_recvoucher VALUES("575","0","REV171122106","","30000.00","2022-11-17","5","2022-11-17 07:03:46");
INSERT INTO tbl_recvoucher VALUES("576","0","REV171122107","","32000.00","2022-11-17","5","2022-11-17 07:10:13");
INSERT INTO tbl_recvoucher VALUES("577","0","REV171122108","","17200.00","2022-11-17","5","2022-11-17 07:10:36");
INSERT INTO tbl_recvoucher VALUES("578","0","REV171122109","","23000.00","2022-11-17","5","2022-11-17 07:44:05");
INSERT INTO tbl_recvoucher VALUES("579","0","REV181122101","","19000.00","2022-11-18","5","2022-11-18 11:23:58");
INSERT INTO tbl_recvoucher VALUES("580","0","REV181122102","","105000.00","2022-11-18","5","2022-11-18 11:24:22");
INSERT INTO tbl_recvoucher VALUES("581","0","REV181122103","","159500.00","2022-11-18","5","2022-11-18 12:11:57");
INSERT INTO tbl_recvoucher VALUES("582","0","REV181122104","","200000.00","2022-11-18","5","2022-11-18 06:33:49");
INSERT INTO tbl_recvoucher VALUES("583","0","REV191122101","","10000.00","2022-11-19","5","2022-11-19 11:01:43");
INSERT INTO tbl_recvoucher VALUES("584","0","REV191122102","","195000.00","2022-11-19","5","2022-11-19 03:02:20");
INSERT INTO tbl_recvoucher VALUES("585","0","REV191122103","","50000.00","2022-11-19","5","2022-11-19 04:10:28");
INSERT INTO tbl_recvoucher VALUES("586","0","REV191122104","","18500.00","2022-11-19","5","2022-11-19 06:17:05");
INSERT INTO tbl_recvoucher VALUES("587","0","REV201122101","","100000.00","2022-11-20","5","2022-11-20 01:06:09");
INSERT INTO tbl_recvoucher VALUES("588","0","REV201122102","","137000.00","2022-11-20","5","2022-11-20 01:42:32");
INSERT INTO tbl_recvoucher VALUES("589","0","REV211122101","","90000.00","2022-11-21","5","2022-11-21 12:46:56");
INSERT INTO tbl_recvoucher VALUES("590","0","REV211122102","","50000.00","2022-11-21","5","2022-11-21 01:20:40");
INSERT INTO tbl_recvoucher VALUES("591","0","REV211122103","","50000.00","2022-11-21","5","2022-11-21 02:16:53");
INSERT INTO tbl_recvoucher VALUES("592","0","REV211122104","","60000.00","2022-11-21","5","2022-11-21 03:39:34");
INSERT INTO tbl_recvoucher VALUES("593","0","REV211122105","","4200.00","2022-11-21","5","2022-11-21 03:40:54");
INSERT INTO tbl_recvoucher VALUES("594","0","REV211122106","","16000.00","2022-11-21","5","2022-11-21 04:47:00");
INSERT INTO tbl_recvoucher VALUES("595","0","REV221122101","","50000.00","2022-11-22","5","2022-11-22 07:00:29");
INSERT INTO tbl_recvoucher VALUES("596","0","REV231122101","","33500.00","2022-11-23","5","2022-11-23 11:33:13");
INSERT INTO tbl_recvoucher VALUES("597","0","REV231122102","","60000.00","2022-11-23","5","2022-11-23 02:07:41");
INSERT INTO tbl_recvoucher VALUES("598","0","REV231122103","","25000.00","2022-11-23","5","2022-11-23 04:23:28");
INSERT INTO tbl_recvoucher VALUES("599","0","REV231122104","","22500.00","2022-11-23","5","2022-11-23 04:33:30");
INSERT INTO tbl_recvoucher VALUES("600","0","REV241122101","","100000.00","2022-11-24","5","2022-11-24 05:04:10");
INSERT INTO tbl_recvoucher VALUES("601","0","REV241122102","","50000.00","2022-11-24","5","2022-11-24 06:12:31");
INSERT INTO tbl_recvoucher VALUES("602","0","REV251122101","","30000.00","2022-11-25","5","2022-11-25 12:46:05");
INSERT INTO tbl_recvoucher VALUES("603","0","REV251122102","","10000.00","2022-11-25","5","2022-11-25 06:33:40");
INSERT INTO tbl_recvoucher VALUES("604","0","REV261122101","","69000.00","2022-11-26","5","2022-11-26 10:57:53");
INSERT INTO tbl_recvoucher VALUES("605","0","REV261122102","","70000.00","2022-11-26","5","2022-11-26 04:28:34");
INSERT INTO tbl_recvoucher VALUES("606","0","REV261122103","","30000.00","2022-11-26","5","2022-11-26 04:30:17");
INSERT INTO tbl_recvoucher VALUES("607","0","REV271122101","","119000.00","2022-11-27","5","2022-11-27 04:21:06");
INSERT INTO tbl_recvoucher VALUES("608","0","REV281122101","","15500.00","2022-11-28","5","2022-11-28 11:41:17");
INSERT INTO tbl_recvoucher VALUES("609","0","REV281122102","","488000.00","2022-11-28","5","2022-11-28 12:05:22");
INSERT INTO tbl_recvoucher VALUES("610","0","REV281122103","","45000.00","2022-11-28","5","2022-11-28 12:11:17");
INSERT INTO tbl_recvoucher VALUES("611","0","REV281122104","","70000.00","2022-11-28","5","2022-11-28 12:12:55");
INSERT INTO tbl_recvoucher VALUES("612","0","REV281122105","","23000.00","2022-11-28","5","2022-11-28 10:13:18");
INSERT INTO tbl_recvoucher VALUES("613","0","REV281122106","","250.00","2022-11-28","5","2022-11-28 10:13:49");
INSERT INTO tbl_recvoucher VALUES("614","0","REV291122101","","30000.00","2022-11-29","5","2022-11-29 11:45:02");
INSERT INTO tbl_recvoucher VALUES("615","0","REV301122101","","18000.00","2022-11-30","5","2022-11-30 12:43:58");
INSERT INTO tbl_recvoucher VALUES("616","0","REV301122102","","50000.00","2022-11-30","5","2022-11-30 12:48:16");
INSERT INTO tbl_recvoucher VALUES("617","0","REV301122103","","2000.00","2022-11-30","5","2022-11-30 06:08:24");
INSERT INTO tbl_recvoucher VALUES("618","0","REV301122104","","207500.00","2022-11-30","5","2022-11-30 07:20:14");
INSERT INTO tbl_recvoucher VALUES("619","0","REV301122105","","25000.00","2022-11-30","5","2022-11-30 07:52:21");
INSERT INTO tbl_recvoucher VALUES("620","0","REV301122106","","200000.00","2022-11-30","5","2022-11-30 07:58:01");
INSERT INTO tbl_recvoucher VALUES("621","0","REV011222101","","23500.00","2022-12-01","5","2022-12-01 06:09:20");
INSERT INTO tbl_recvoucher VALUES("622","0","REV011222102","","8000.00","2022-12-01","5","2022-12-01 06:51:08");
INSERT INTO tbl_recvoucher VALUES("623","0","REV031222101","","348000.00","2022-12-03","5","2022-12-03 11:08:54");
INSERT INTO tbl_recvoucher VALUES("624","0","REV031222102","","40000.00","2022-12-03","5","2022-12-03 12:02:39");
INSERT INTO tbl_recvoucher VALUES("625","0","REV031222103","","7500.00","2022-12-03","5","2022-12-03 05:30:11");
INSERT INTO tbl_recvoucher VALUES("626","0","REV041222101","","35000.00","2022-12-04","5","2022-12-04 01:33:10");
INSERT INTO tbl_recvoucher VALUES("627","0","REV041222102","","200000.00","2022-12-04","5","2022-12-04 03:28:57");
INSERT INTO tbl_recvoucher VALUES("628","0","REV051222101","","200000.00","2022-12-05","5","2022-12-05 02:25:35");
INSERT INTO tbl_recvoucher VALUES("629","0","REV051222102","","17000.00","2022-12-05","5","2022-12-05 06:46:17");
INSERT INTO tbl_recvoucher VALUES("630","0","REV051222103","","50000.00","2022-12-05","5","2022-12-05 07:01:18");
INSERT INTO tbl_recvoucher VALUES("631","0","REV051222104","","45000.00","2022-12-05","5","2022-12-05 07:43:03");
INSERT INTO tbl_recvoucher VALUES("632","0","REV061222101","","32000.00","2022-12-06","5","2022-12-06 12:18:35");
INSERT INTO tbl_recvoucher VALUES("633","0","REV061222102","","300000.00","2022-12-06","5","2022-12-06 12:29:03");
INSERT INTO tbl_recvoucher VALUES("634","0","REV061222103","","200000.00","2022-12-06","5","2022-12-06 01:55:43");
INSERT INTO tbl_recvoucher VALUES("635","0","REV071222101","","24000.00","2022-12-07","5","2022-12-07 02:10:09");
INSERT INTO tbl_recvoucher VALUES("636","0","REV071222102","","35000.00","2022-12-07","5","2022-12-07 02:17:23");
INSERT INTO tbl_recvoucher VALUES("637","0","REV081222101","","50000.00","2022-12-08","5","2022-12-08 10:55:46");
INSERT INTO tbl_recvoucher VALUES("638","0","REV081222102","","18000.00","2022-12-08","5","2022-12-08 07:59:51");
INSERT INTO tbl_recvoucher VALUES("639","0","REV081222103","","29000.00","2022-12-08","5","2022-12-08 09:55:34");
INSERT INTO tbl_recvoucher VALUES("640","0","REV091222101","","23000.00","2022-12-09","5","2022-12-09 04:03:47");
INSERT INTO tbl_recvoucher VALUES("641","0","REV111222101","","128500.00","2022-12-11","5","2022-12-11 11:17:42");
INSERT INTO tbl_recvoucher VALUES("642","0","REV111222102","","25000.00","2022-12-11","5","2022-12-11 04:15:13");
INSERT INTO tbl_recvoucher VALUES("643","0","REV111222103","","206000.00","2022-12-11","5","2022-12-11 06:11:25");
INSERT INTO tbl_recvoucher VALUES("644","0","REV111222104","","150000.00","2022-12-11","5","2022-12-11 07:16:46");
INSERT INTO tbl_recvoucher VALUES("645","0","REV121222101","","108000.00","2022-12-12","5","2022-12-12 01:41:32");
INSERT INTO tbl_recvoucher VALUES("646","0","REV121222102","","25000.00","2022-12-12","5","2022-12-12 02:32:26");
INSERT INTO tbl_recvoucher VALUES("647","0","REV121222103","","100000.00","2022-12-12","5","2022-12-12 07:54:18");
INSERT INTO tbl_recvoucher VALUES("648","0","REV131222101","","10000.00","2022-12-13","5","2022-12-13 11:31:32");
INSERT INTO tbl_recvoucher VALUES("649","0","REV131222102","","150000.00","2022-12-13","5","2022-12-13 12:04:12");
INSERT INTO tbl_recvoucher VALUES("650","0","REV141222101","","50000.00","2022-12-14","5","2022-12-14 11:49:15");
INSERT INTO tbl_recvoucher VALUES("652","0","REV141222103","","32000.00","2022-12-14","5","2022-12-14 06:35:58");
INSERT INTO tbl_recvoucher VALUES("653","0","REV141222104","","65000.00","2022-12-14","5","2022-12-14 08:04:48");
INSERT INTO tbl_recvoucher VALUES("654","0","REV141222105","","1334.00","2022-12-14","5","2022-12-14 10:37:38");
INSERT INTO tbl_recvoucher VALUES("655","0","REV141222106","","39000.00","2022-12-14","5","2022-12-14 10:39:07");
INSERT INTO tbl_recvoucher VALUES("656","0","REV151222101","","50000.00","2022-12-15","5","2022-12-15 05:09:44");
INSERT INTO tbl_recvoucher VALUES("657","0","REV151222102","","46000.00","2022-12-15","5","2022-12-15 05:37:21");
INSERT INTO tbl_recvoucher VALUES("658","0","REV151222103","","40000.00","2022-12-15","5","2022-12-15 06:12:47");
INSERT INTO tbl_recvoucher VALUES("659","0","REV151222104","","29500.00","2022-12-15","5","2022-12-15 07:05:07");
INSERT INTO tbl_recvoucher VALUES("660","0","REV151222105","","172000.00","2022-12-15","5","2022-12-15 07:50:17");
INSERT INTO tbl_recvoucher VALUES("661","0","REV171222101","","17000.00","2022-12-17","5","2022-12-17 01:04:07");
INSERT INTO tbl_recvoucher VALUES("662","0","REV171222102","","32000.00","2022-12-17","5","2022-12-17 05:43:39");
INSERT INTO tbl_recvoucher VALUES("663","0","REV171222103","","110000.00","2022-12-17","5","2022-12-17 09:26:32");
INSERT INTO tbl_recvoucher VALUES("664","0","REV181222101","","25000.00","2022-12-18","5","2022-12-18 12:04:13");
INSERT INTO tbl_recvoucher VALUES("665","0","REV181222102","","30000.00","2022-12-18","5","2022-12-18 01:51:55");
INSERT INTO tbl_recvoucher VALUES("666","0","REV181222103","","25000.00","2022-12-18","5","2022-12-18 01:55:41");
INSERT INTO tbl_recvoucher VALUES("667","0","REV181222104","","143600.00","2022-12-18","5","2022-12-18 02:02:14");
INSERT INTO tbl_recvoucher VALUES("668","0","REV181222105","","46000.00","2022-12-18","5","2022-12-18 06:45:13");
INSERT INTO tbl_recvoucher VALUES("669","0","REV191222101","","49500.00","2022-12-19","5","2022-12-19 11:55:57");
INSERT INTO tbl_recvoucher VALUES("670","0","REV191222102","","3000.00","2022-12-19","5","2022-12-19 01:40:05");
INSERT INTO tbl_recvoucher VALUES("671","0","REV191222103","","119000.00","2022-12-19","5","2022-12-19 04:47:30");
INSERT INTO tbl_recvoucher VALUES("672","0","REV191222104","","22500.00","2022-12-19","5","2022-12-19 04:53:29");
INSERT INTO tbl_recvoucher VALUES("673","0","REV191222105","","13000.00","2022-12-19","5","2022-12-19 06:34:34");
INSERT INTO tbl_recvoucher VALUES("674","0","REV191222106","","325000.00","2022-12-19","5","2022-12-19 09:31:07");
INSERT INTO tbl_recvoucher VALUES("675","0","REV191222107","","100000.00","2022-12-19","5","2022-12-19 09:52:32");
INSERT INTO tbl_recvoucher VALUES("676","0","REV191222108","","118000.00","2022-12-19","5","2022-12-19 10:21:00");
INSERT INTO tbl_recvoucher VALUES("677","0","REV211222101","","65000.00","2022-12-21","5","2022-12-21 12:41:11");
INSERT INTO tbl_recvoucher VALUES("678","0","REV211222102","","67000.00","2022-12-21","5","2022-12-21 01:41:20");
INSERT INTO tbl_recvoucher VALUES("679","0","REV211222103","","50000.00","2022-12-21","5","2022-12-21 04:47:44");
INSERT INTO tbl_recvoucher VALUES("680","0","REV211222104","","55000.00","2022-12-21","5","2022-12-21 04:48:19");
INSERT INTO tbl_recvoucher VALUES("681","0","REV211222105","","30000.00","2022-12-21","5","2022-12-21 05:09:19");
INSERT INTO tbl_recvoucher VALUES("682","0","REV211222106","","40000.00","2022-12-21","5","2022-12-21 10:38:48");
INSERT INTO tbl_recvoucher VALUES("683","0","REV211222107","","15000.00","2022-12-21","5","2022-12-21 10:39:30");
INSERT INTO tbl_recvoucher VALUES("684","0","REV221222101","","100000.00","2022-12-22","5","2022-12-22 01:07:36");
INSERT INTO tbl_recvoucher VALUES("685","0","REV221222102","","75000.00","2022-12-22","5","2022-12-22 05:58:07");
INSERT INTO tbl_recvoucher VALUES("686","0","REV221222103","","100000.00","2022-12-22","5","2022-12-22 06:06:50");
INSERT INTO tbl_recvoucher VALUES("687","0","REV221222104","","73000.00","2022-12-22","5","2022-12-22 06:13:30");
INSERT INTO tbl_recvoucher VALUES("688","0","REV221222105","","44000.00","2022-12-22","5","2022-12-22 07:22:28");
INSERT INTO tbl_recvoucher VALUES("689","0","REV221222106","","100000.00","2022-12-22","5","2022-12-22 07:56:06");
INSERT INTO tbl_recvoucher VALUES("690","0","REV221222107","","50000.00","2022-12-22","5","2022-12-22 07:58:20");
INSERT INTO tbl_recvoucher VALUES("691","0","REV221222108","","100000.00","2022-12-22","5","2022-12-22 09:32:04");
INSERT INTO tbl_recvoucher VALUES("692","0","REV231222101","","25000.00","2022-12-23","5","2022-12-23 03:41:14");
INSERT INTO tbl_recvoucher VALUES("693","0","REV231222102","","14000.00","2022-12-23","5","2022-12-23 03:44:17");
INSERT INTO tbl_recvoucher VALUES("694","0","REV251222101","","50000.00","2022-12-25","5","2022-12-25 12:26:58");
INSERT INTO tbl_recvoucher VALUES("695","0","REV251222102","","22500.00","2022-12-25","5","2022-12-25 01:04:21");
INSERT INTO tbl_recvoucher VALUES("696","0","REV251222103","","64500.00","2022-12-25","5","2022-12-25 01:05:19");
INSERT INTO tbl_recvoucher VALUES("697","0","REV251222104","","22000.00","2022-12-25","5","2022-12-25 01:06:09");
INSERT INTO tbl_recvoucher VALUES("698","0","REV251222105","","10000.00","2022-12-25","5","2022-12-25 01:37:20");
INSERT INTO tbl_recvoucher VALUES("699","0","REV251222106","","40000.00","2022-12-25","5","2022-12-25 04:48:07");
INSERT INTO tbl_recvoucher VALUES("700","0","REV261222101","","10000.00","2022-12-26","5","2022-12-26 12:11:03");
INSERT INTO tbl_recvoucher VALUES("701","0","REV261222102","","30000.00","2022-12-26","5","2022-12-26 12:16:07");
INSERT INTO tbl_recvoucher VALUES("702","0","REV261222103","","19000.00","2022-12-26","5","2022-12-26 04:15:07");
INSERT INTO tbl_recvoucher VALUES("703","0","REV261222104","","22000.00","2022-12-26","5","2022-12-26 06:35:59");
INSERT INTO tbl_recvoucher VALUES("704","0","REV261222105","","22000.00","2022-12-26","5","2022-12-26 07:32:35");
INSERT INTO tbl_recvoucher VALUES("705","0","REV281222101","","100000.00","2022-12-28","5","2022-12-28 11:18:16");
INSERT INTO tbl_recvoucher VALUES("706","0","REV281222102","","90000.00","2022-12-28","5","2022-12-28 11:18:55");
INSERT INTO tbl_recvoucher VALUES("707","0","REV281222103","","100000.00","2022-12-28","5","2022-12-28 02:39:04");
INSERT INTO tbl_recvoucher VALUES("708","0","REV281222104","","50000.00","2022-12-28","5","2022-12-28 07:06:38");
INSERT INTO tbl_recvoucher VALUES("709","0","REV291222101","","55000.00","2022-12-29","5","2022-12-29 11:02:45");
INSERT INTO tbl_recvoucher VALUES("710","0","REV291222102","2k Less 440 G3 1 K Less From Previous Due","3000.00","2022-12-29","5","2022-12-29 11:06:59");
INSERT INTO tbl_recvoucher VALUES("711","0","REV291222103","","18000.00","2022-12-29","5","2022-12-29 01:18:40");
INSERT INTO tbl_recvoucher VALUES("712","0","REV291222104","","100000.00","2022-12-29","5","2022-12-29 03:45:40");
INSERT INTO tbl_recvoucher VALUES("713","0","REV291222105","","50000.00","2022-12-29","5","2022-12-29 03:46:53");
INSERT INTO tbl_recvoucher VALUES("714","0","REV291222106","","44000.00","2022-12-29","5","2022-12-29 07:05:41");
INSERT INTO tbl_recvoucher VALUES("715","0","REV291222107","","22000.00","2022-12-29","5","2022-12-29 07:06:17");
INSERT INTO tbl_recvoucher VALUES("716","0","REV301222101","","50000.00","2022-12-30","5","2022-12-30 12:59:30");
INSERT INTO tbl_recvoucher VALUES("717","0","REV301222102","","255000.00","2022-12-30","5","2022-12-30 01:38:20");
INSERT INTO tbl_recvoucher VALUES("718","0","REV301222103","","49800.00","2022-12-30","5","2022-12-30 01:39:18");
INSERT INTO tbl_recvoucher VALUES("719","0","REV301222104","Adjustment ","24000.00","2022-12-30","5","2022-12-30 01:40:39");
INSERT INTO tbl_recvoucher VALUES("720","0","REV311222101","","30000.00","2022-12-31","5","2022-12-31 01:11:22");
INSERT INTO tbl_recvoucher VALUES("721","0","REV010123101","","20000.00","2023-01-01","5","2023-01-01 11:17:30");
INSERT INTO tbl_recvoucher VALUES("722","0","REV010123102","","25000.00","2023-01-01","5","2023-01-01 01:55:42");
INSERT INTO tbl_recvoucher VALUES("723","0","REV040123101","","100000.00","2023-01-04","5","2023-01-04 12:54:25");
INSERT INTO tbl_recvoucher VALUES("724","0","REV040123102","","24500.00","2023-01-04","5","2023-01-04 12:57:02");
INSERT INTO tbl_recvoucher VALUES("725","0","REV040123103","","307500.00","2023-01-04","5","2023-01-04 12:59:52");
INSERT INTO tbl_recvoucher VALUES("727","0","REV040123104","","44000.00","2023-01-04","5","2023-01-04 03:21:49");
INSERT INTO tbl_recvoucher VALUES("728","0","REV040123105","","50000.00","2023-01-04","5","2023-01-04 06:09:33");
INSERT INTO tbl_recvoucher VALUES("729","0","REV040123106","","25000.00","2023-01-04","5","2023-01-04 06:12:57");
INSERT INTO tbl_recvoucher VALUES("730","0","REV040123107","","20000.00","2023-01-04","5","2023-01-04 07:53:23");
INSERT INTO tbl_recvoucher VALUES("731","0","REV050123101","","8500.00","2023-01-05","5","2023-01-05 05:36:19");
INSERT INTO tbl_recvoucher VALUES("732","0","REV050123102","","13000.00","2023-01-05","5","2023-01-05 05:39:39");
INSERT INTO tbl_recvoucher VALUES("733","0","REV060123101","","133500.00","2023-01-06","5","2023-01-06 02:08:50");
INSERT INTO tbl_recvoucher VALUES("734","0","REV060123102","","17000.00","2023-01-06","5","2023-01-06 02:29:09");
INSERT INTO tbl_recvoucher VALUES("735","0","REV060123103","","24000.00","2023-01-06","5","2023-01-06 02:31:11");
INSERT INTO tbl_recvoucher VALUES("736","0","REV060123104","","307500.00","2023-01-06","5","2023-01-06 04:58:10");
INSERT INTO tbl_recvoucher VALUES("737","0","REV070123101","","2000.00","2023-01-07","5","2023-01-07 06:44:32");
INSERT INTO tbl_recvoucher VALUES("738","0","REV070123102","","20000.00","2023-01-07","5","2023-01-07 07:03:49");
INSERT INTO tbl_recvoucher VALUES("739","0","REV070123103","","6000.00","2023-01-07","5","2023-01-07 07:04:21");
INSERT INTO tbl_recvoucher VALUES("741","0","REV090123102","","361250.00","2023-01-09","5","2023-01-09 04:03:21");
INSERT INTO tbl_recvoucher VALUES("742","0","REV090123103","","50000.00","2023-01-09","5","2023-01-09 07:16:15");
INSERT INTO tbl_recvoucher VALUES("743","0","REV090123104","","10000.00","2023-01-09","5","2023-01-09 07:22:56");
INSERT INTO tbl_recvoucher VALUES("744","0","REV090123105","","23000.00","2023-01-09","5","2023-01-09 07:30:13");
INSERT INTO tbl_recvoucher VALUES("745","0","REV090123106","","50000.00","2023-01-09","5","2023-01-09 07:40:18");
INSERT INTO tbl_recvoucher VALUES("746","0","REV100123101","","222000.00","2023-01-10","5","2023-01-10 01:40:43");
INSERT INTO tbl_recvoucher VALUES("747","0","REV100123102","","65000.00","2023-01-10","5","2023-01-10 06:19:30");
INSERT INTO tbl_recvoucher VALUES("749","0","REV120123101","","30000.00","2023-01-12","5","2023-01-12 01:32:07");
INSERT INTO tbl_recvoucher VALUES("751","0","REV130123101","","10000.00","2023-01-13","5","2023-01-13 11:22:12");
INSERT INTO tbl_recvoucher VALUES("752","0","REV150123101","","24000.00","2023-01-15","5","2023-01-15 01:23:29");
INSERT INTO tbl_recvoucher VALUES("753","0","REV150123102","","30000.00","2023-01-15","5","2023-01-15 03:40:11");
INSERT INTO tbl_recvoucher VALUES("754","0","REV160123101","","35000.00","2023-01-16","5","2023-01-16 04:55:23");
INSERT INTO tbl_recvoucher VALUES("755","0","REV160123102","","20000.00","2023-01-16","5","2023-01-16 07:17:03");
INSERT INTO tbl_recvoucher VALUES("756","0","REV160123103","","8000.00","2023-01-16","5","2023-01-16 07:20:21");
INSERT INTO tbl_recvoucher VALUES("757","0","REV160123104","","24000.00","2023-01-16","5","2023-01-16 07:21:15");
INSERT INTO tbl_recvoucher VALUES("758","0","REV180123101","","50000.00","2023-01-18","5","2023-01-18 11:02:17");
INSERT INTO tbl_recvoucher VALUES("759","0","REV180123102","","30000.00","2023-01-18","5","2023-01-18 11:02:37");
INSERT INTO tbl_recvoucher VALUES("760","0","REV180123103","","150000.00","2023-01-18","5","2023-01-18 11:03:05");
INSERT INTO tbl_recvoucher VALUES("761","0","REV180123104","","20000.00","2023-01-18","5","2023-01-18 11:03:37");
INSERT INTO tbl_recvoucher VALUES("762","0","REV190123101","","35000.00","2023-01-19","5","2023-01-19 11:01:49");
INSERT INTO tbl_recvoucher VALUES("763","0","REV210123101","","150000.00","2023-01-21","5","2023-01-21 06:36:24");
INSERT INTO tbl_recvoucher VALUES("764","0","REV210123102","","40000.00","2023-01-21","5","2023-01-21 07:10:58");
INSERT INTO tbl_recvoucher VALUES("765","0","REV210123103","","20000.00","2023-01-21","5","2023-01-21 07:25:07");
INSERT INTO tbl_recvoucher VALUES("766","0","REV210123104","","42750.00","2023-01-21","5","2023-01-21 10:00:01");
INSERT INTO tbl_recvoucher VALUES("767","0","REV220123101","","29000.00","2023-01-22","5","2023-01-22 03:52:34");
INSERT INTO tbl_recvoucher VALUES("768","0","REV220123102","","200000.00","2023-01-22","5","2023-01-22 03:53:54");
INSERT INTO tbl_recvoucher VALUES("769","0","REV230123101","","21000.00","2023-01-23","5","2023-01-23 02:33:07");
INSERT INTO tbl_recvoucher VALUES("770","0","REV230123102","","121000.00","2023-01-23","5","2023-01-23 04:06:50");
INSERT INTO tbl_recvoucher VALUES("771","0","REV230123103","","15000.00","2023-01-23","5","2023-01-23 07:15:54");
INSERT INTO tbl_recvoucher VALUES("772","0","REV230123104","","21000.00","2023-01-23","5","2023-01-23 07:40:29");
INSERT INTO tbl_recvoucher VALUES("773","0","REV230123105","","100000.00","2023-01-23","5","2023-01-23 09:51:10");
INSERT INTO tbl_recvoucher VALUES("774","0","REV230123106","","20000.00","2023-01-23","5","2023-01-23 09:55:53");
INSERT INTO tbl_recvoucher VALUES("775","0","REV250123101","","15000.00","2023-01-25","5","2023-01-25 07:13:20");
INSERT INTO tbl_recvoucher VALUES("776","0","REV260123101","","20000.00","2023-01-26","5","2023-01-26 02:02:52");
INSERT INTO tbl_recvoucher VALUES("777","0","REV260123102","","102500.00","2023-01-26","5","2023-01-26 05:25:25");
INSERT INTO tbl_recvoucher VALUES("778","0","REV280123101","","18500.00","2023-01-28","5","2023-01-28 11:39:03");
INSERT INTO tbl_recvoucher VALUES("779","0","REV280123102","","40000.00","2023-01-28","5","2023-01-28 11:57:20");
INSERT INTO tbl_recvoucher VALUES("780","0","REV290123101","","60000.00","2023-01-29","5","2023-01-29 01:47:30");
INSERT INTO tbl_recvoucher VALUES("781","0","REV290123102","","20000.00","2023-01-29","5","2023-01-29 07:43:22");
INSERT INTO tbl_recvoucher VALUES("782","0","REV290123103","","30000.00","2023-01-29","5","2023-01-29 11:40:36");
INSERT INTO tbl_recvoucher VALUES("783","0","REV300123101","","31000.00","2023-01-30","5","2023-01-30 12:13:05");
INSERT INTO tbl_recvoucher VALUES("784","0","REV300123102","","10000.00","2023-01-30","5","2023-01-30 04:32:29");
INSERT INTO tbl_recvoucher VALUES("785","0","REV300123103","","22500.00","2023-01-30","5","2023-01-30 06:51:34");
INSERT INTO tbl_recvoucher VALUES("786","0","REV300123104","","123000.00","2023-01-30","5","2023-01-30 06:57:52");
INSERT INTO tbl_recvoucher VALUES("787","0","REV310123101","","100000.00","2023-01-31","5","2023-01-31 01:57:23");
INSERT INTO tbl_recvoucher VALUES("788","0","REV310123102","","78000.00","2023-01-31","5","2023-01-31 03:07:08");
INSERT INTO tbl_recvoucher VALUES("789","0","REV010223101","","92200.00","2023-02-01","5","2023-02-01 06:08:24");
INSERT INTO tbl_recvoucher VALUES("790","0","REV010223102","","40000.00","2023-02-01","5","2023-02-01 06:49:44");
INSERT INTO tbl_recvoucher VALUES("791","0","REV010223103","","59000.00","2023-02-01","5","2023-02-01 06:59:20");
INSERT INTO tbl_recvoucher VALUES("792","0","REV010223104","","40000.00","2023-02-01","5","2023-02-01 08:29:17");
INSERT INTO tbl_recvoucher VALUES("793","0","REV010223105","","120000.00","2023-02-01","5","2023-02-01 10:58:53");
INSERT INTO tbl_recvoucher VALUES("794","0","REV020223101","","29500.00","2023-02-02","5","2023-02-02 06:44:18");
INSERT INTO tbl_recvoucher VALUES("795","0","REV020223102","","124000.00","2023-02-02","5","2023-02-02 07:51:04");
INSERT INTO tbl_recvoucher VALUES("796","0","REV020223103","","70000.00","2023-02-02","5","2023-02-02 10:11:42");
INSERT INTO tbl_recvoucher VALUES("797","0","REV030223101","","300000.00","2023-02-03","5","2023-02-03 12:47:55");
INSERT INTO tbl_recvoucher VALUES("798","0","REV030223102","","60000.00","2023-02-03","5","2023-02-03 03:40:11");
INSERT INTO tbl_recvoucher VALUES("799","0","REV030223103","","42000.00","2023-02-03","5","2023-02-03 07:49:31");
INSERT INTO tbl_recvoucher VALUES("800","0","REV040223101","","59000.00","2023-02-04","5","2023-02-04 12:47:47");
INSERT INTO tbl_recvoucher VALUES("801","0","REV040223102","","21000.00","2023-02-04","5","2023-02-04 01:37:57");
INSERT INTO tbl_recvoucher VALUES("802","0","REV040223103","","123000.00","2023-02-04","5","2023-02-04 04:01:34");
INSERT INTO tbl_recvoucher VALUES("803","0","REV040223104","","20000.00","2023-02-04","5","2023-02-04 04:02:03");
INSERT INTO tbl_recvoucher VALUES("804","0","REV050223101","","103000.00","2023-02-05","5","2023-02-05 07:44:15");
INSERT INTO tbl_recvoucher VALUES("805","0","REV050223102","","40000.00","2023-02-05","5","2023-02-05 07:56:20");
INSERT INTO tbl_recvoucher VALUES("806","0","REV050223103","","21000.00","2023-02-05","5","2023-02-05 07:57:10");
INSERT INTO tbl_recvoucher VALUES("807","0","REV050223104","","119000.00","2023-02-05","5","2023-02-05 08:14:09");
INSERT INTO tbl_recvoucher VALUES("808","0","REV060223101","","150000.00","2023-02-06","5","2023-02-06 01:26:03");
INSERT INTO tbl_recvoucher VALUES("809","0","REV060223102","","20500.00","2023-02-06","5","2023-02-06 06:58:42");
INSERT INTO tbl_recvoucher VALUES("810","0","REV060223103","","40000.00","2023-02-06","5","2023-02-06 07:04:14");
INSERT INTO tbl_recvoucher VALUES("811","0","REV070223101","","100000.00","2023-02-07","5","2023-02-07 12:04:37");
INSERT INTO tbl_recvoucher VALUES("812","0","REV070223102","","100000.00","2023-02-07","5","2023-02-07 12:12:36");
INSERT INTO tbl_recvoucher VALUES("813","0","REV070223103","","150000.00","2023-02-07","5","2023-02-07 11:56:12");
INSERT INTO tbl_recvoucher VALUES("814","0","REV080223101","","100000.00","2023-02-08","5","2023-02-08 11:48:33");
INSERT INTO tbl_recvoucher VALUES("815","0","REV080223102","","109000.00","2023-02-08","5","2023-02-08 06:14:47");
INSERT INTO tbl_recvoucher VALUES("816","0","REV080223103","","190000.00","2023-02-08","5","2023-02-08 07:35:47");
INSERT INTO tbl_recvoucher VALUES("817","0","REV090223101","","21000.00","2023-02-09","5","2023-02-09 11:45:04");
INSERT INTO tbl_recvoucher VALUES("818","0","REV090223102","","49000.00","2023-02-09","5","2023-02-09 01:25:29");
INSERT INTO tbl_recvoucher VALUES("819","0","REV090223103","","80000.00","2023-02-09","5","2023-02-09 03:54:30");
INSERT INTO tbl_recvoucher VALUES("820","0","REV090223104","","94000.00","2023-02-09","5","2023-02-09 07:54:32");
INSERT INTO tbl_recvoucher VALUES("821","0","REV090223105","","23500.00","2023-02-09","5","2023-02-09 07:55:32");
INSERT INTO tbl_recvoucher VALUES("822","0","REV090223106","","260000.00","2023-02-09","5","2023-02-09 07:58:12");
INSERT INTO tbl_recvoucher VALUES("823","0","REV110223101","","60000.00","2023-02-11","5","2023-02-11 06:12:53");
INSERT INTO tbl_recvoucher VALUES("824","0","REV110223102","","100000.00","2023-02-11","5","2023-02-11 07:46:16");
INSERT INTO tbl_recvoucher VALUES("825","0","REV110223103","","31000.00","2023-02-11","5","2023-02-11 07:47:47");
INSERT INTO tbl_recvoucher VALUES("826","0","REV110223104","","200000.00","2023-02-11","5","2023-02-11 07:48:44");
INSERT INTO tbl_recvoucher VALUES("827","0","REV110223105","","20000.00","2023-02-11","5","2023-02-11 07:50:28");
INSERT INTO tbl_recvoucher VALUES("828","0","REV110223106","","20000.00","2023-02-11","5","2023-02-11 09:19:31");
INSERT INTO tbl_recvoucher VALUES("829","0","REV110223107","","21000.00","2023-02-11","5","2023-02-11 09:20:03");
INSERT INTO tbl_recvoucher VALUES("830","0","REV120223101","","55000.00","2023-02-12","5","2023-02-12 03:37:48");
INSERT INTO tbl_recvoucher VALUES("831","0","REV150223101","","250000.00","2023-02-15","5","2023-02-15 12:16:29");
INSERT INTO tbl_recvoucher VALUES("832","0","REV150223102","","29000.00","2023-02-15","5","2023-02-15 01:12:17");
INSERT INTO tbl_recvoucher VALUES("833","0","REV150223103","","21000.00","2023-02-15","5","2023-02-15 01:13:43");
INSERT INTO tbl_recvoucher VALUES("834","0","REV150223104","","8500.00","2023-02-15","5","2023-02-15 01:19:37");
INSERT INTO tbl_recvoucher VALUES("835","0","REV150223105","","20000.00","2023-02-15","5","2023-02-15 04:03:30");
INSERT INTO tbl_recvoucher VALUES("836","0","REV150223106","","98000.00","2023-02-15","5","2023-02-15 06:59:05");
INSERT INTO tbl_recvoucher VALUES("837","0","REV160223101","","132500.00","2023-02-16","5","2023-02-16 09:20:22");
INSERT INTO tbl_recvoucher VALUES("838","0","REV160223102","","20500.00","2023-02-16","5","2023-02-16 09:21:06");
INSERT INTO tbl_recvoucher VALUES("839","0","REV160223103","","350000.00","2023-02-16","5","2023-02-16 09:26:43");
INSERT INTO tbl_recvoucher VALUES("840","0","REV160223104","","100000.00","2023-02-16","5","2023-02-16 09:34:29");
INSERT INTO tbl_recvoucher VALUES("841","0","REV170223101","","22000.00","2023-02-17","5","2023-02-17 04:30:19");
INSERT INTO tbl_recvoucher VALUES("842","0","REV170223102","","16500.00","2023-02-17","5","2023-02-17 07:08:48");
INSERT INTO tbl_recvoucher VALUES("843","0","REV170223103","","25000.00","2023-02-17","5","2023-02-17 07:49:03");
INSERT INTO tbl_recvoucher VALUES("844","0","REV170223104","","20000.00","2023-02-17","5","2023-02-17 07:49:47");
INSERT INTO tbl_recvoucher VALUES("845","0","REV170223105","","20000.00","2023-02-17","5","2023-02-17 07:56:26");
INSERT INTO tbl_recvoucher VALUES("846","0","REV180223101","","76000.00","2023-02-18","5","2023-02-18 05:37:03");
INSERT INTO tbl_recvoucher VALUES("847","0","REV180223102","","5000.00","2023-02-18","5","2023-02-18 05:40:37");
INSERT INTO tbl_recvoucher VALUES("848","0","REV180223103","","63750.00","2023-02-18","5","2023-02-18 05:46:14");
INSERT INTO tbl_recvoucher VALUES("849","0","REV180223104","","35000.00","2023-02-18","5","2023-02-18 06:55:50");
INSERT INTO tbl_recvoucher VALUES("850","0","REV190223101","","290000.00","2023-02-19","5","2023-02-19 12:31:19");
INSERT INTO tbl_recvoucher VALUES("851","0","REV190223102","","20500.00","2023-02-19","5","2023-02-19 12:35:31");
INSERT INTO tbl_recvoucher VALUES("852","0","REV190223103","","140000.00","2023-02-19","5","2023-02-19 12:06:36");
INSERT INTO tbl_recvoucher VALUES("853","0","REV190223104","","39000.00","2023-02-19","5","2023-02-19 04:50:43");
INSERT INTO tbl_recvoucher VALUES("854","0","REV190223105","","20500.00","2023-02-19","5","2023-02-19 04:52:00");
INSERT INTO tbl_recvoucher VALUES("855","0","REV200223101","","40000.00","2023-02-20","5","2023-02-20 10:57:46");
INSERT INTO tbl_recvoucher VALUES("856","0","REV200223102","","21500.00","2023-02-20","5","2023-02-20 12:18:42");
INSERT INTO tbl_recvoucher VALUES("857","0","REV200223103","","15000.00","2023-02-20","5","2023-02-20 04:10:49");
INSERT INTO tbl_recvoucher VALUES("858","0","REV200223104","","300000.00","2023-02-20","5","2023-02-20 07:44:33");
INSERT INTO tbl_recvoucher VALUES("859","0","REV220223101","","10000.00","2023-02-22","5","2023-02-22 01:31:54");
INSERT INTO tbl_recvoucher VALUES("860","0","REV220223102","","100000.00","2023-02-22","5","2023-02-22 03:44:49");
INSERT INTO tbl_recvoucher VALUES("861","0","REV220223103","","20000.00","2023-02-22","5","2023-02-22 07:51:01");
INSERT INTO tbl_recvoucher VALUES("862","0","REV220223104","","100000.00","2023-02-22","5","2023-02-22 10:44:04");
INSERT INTO tbl_recvoucher VALUES("863","0","REV230223101","","20000.00","2023-02-23","5","2023-02-23 11:30:24");
INSERT INTO tbl_recvoucher VALUES("864","0","REV230223102","","39000.00","2023-02-23","5","2023-02-23 07:42:17");
INSERT INTO tbl_recvoucher VALUES("865","0","REV230223103","","28500.00","2023-02-23","5","2023-02-23 10:29:15");
INSERT INTO tbl_recvoucher VALUES("866","0","REV230223104","","21500.00","2023-02-23","5","2023-02-23 10:29:40");
INSERT INTO tbl_recvoucher VALUES("867","0","REV240223101","","70000.00","2023-02-24","5","2023-02-24 01:15:51");
INSERT INTO tbl_recvoucher VALUES("868","0","REV240223102","","16000.00","2023-02-24","5","2023-02-24 07:13:30");
INSERT INTO tbl_recvoucher VALUES("869","0","REV240223103","","52500.00","2023-02-24","5","2023-02-24 07:29:08");
INSERT INTO tbl_recvoucher VALUES("870","0","REV240223104","","21000.00","2023-02-24","5","2023-02-24 07:56:14");
INSERT INTO tbl_recvoucher VALUES("871","0","REV240223105","","41000.00","2023-02-24","5","2023-02-24 10:13:03");
INSERT INTO tbl_recvoucher VALUES("872","0","REV250223101","","20000.00","2023-02-25","5","2023-02-25 03:30:03");
INSERT INTO tbl_recvoucher VALUES("873","0","REV250223102","","150000.00","2023-02-25","5","2023-02-25 04:22:49");
INSERT INTO tbl_recvoucher VALUES("874","0","REV260223101","","61500.00","2023-02-26","5","2023-02-26 04:27:48");
INSERT INTO tbl_recvoucher VALUES("875","0","REV270223101","","100000.00","2023-02-22","5","2023-02-27 05:51:08");
INSERT INTO tbl_recvoucher VALUES("876","0","REV270223102","","401000.00","2023-02-27","5","2023-02-27 06:06:35");
INSERT INTO tbl_recvoucher VALUES("877","0","REV280223101","","180000.00","2023-02-28","5","2023-02-28 12:39:31");
INSERT INTO tbl_recvoucher VALUES("878","0","REV010323101","","100000.00","2023-03-01","5","2023-03-01 11:04:59");
INSERT INTO tbl_recvoucher VALUES("879","0","REV010323102","","40000.00","2023-03-01","5","2023-03-01 11:08:32");
INSERT INTO tbl_recvoucher VALUES("880","0","REV010323103","","20500.00","2023-03-01","5","2023-03-01 11:11:44");
INSERT INTO tbl_recvoucher VALUES("881","0","REV010323104","","40000.00","2023-03-01","5","2023-03-01 11:24:44");
INSERT INTO tbl_recvoucher VALUES("882","0","REV010323105","","21500.00","2023-03-01","5","2023-03-01 11:33:49");
INSERT INTO tbl_recvoucher VALUES("883","0","REV010323106","","100000.00","2023-03-01","5","2023-03-01 12:14:20");
INSERT INTO tbl_recvoucher VALUES("884","0","REV010323107","","41000.00","2023-03-01","5","2023-03-01 01:40:40");
INSERT INTO tbl_recvoucher VALUES("885","0","REV010323108","","50000.00","2023-03-01","5","2023-03-01 01:41:02");
INSERT INTO tbl_recvoucher VALUES("886","0","REV020323101","","75000.00","2023-03-02","5","2023-03-02 07:04:56");
INSERT INTO tbl_recvoucher VALUES("887","0","REV030323101","","48000.00","2023-03-03","5","2023-03-03 07:57:42");
INSERT INTO tbl_recvoucher VALUES("888","0","REV030323102","","92000.00","2023-03-03","5","2023-03-03 07:58:33");
INSERT INTO tbl_recvoucher VALUES("889","0","REV030323103","","1000.00","2023-03-03","5","2023-03-03 11:52:00");
INSERT INTO tbl_recvoucher VALUES("890","0","REV040323101","","14500.00","2023-03-04","5","2023-03-04 11:20:52");
INSERT INTO tbl_recvoucher VALUES("891","0","REV050323101","","21500.00","2023-03-05","5","2023-03-05 11:51:55");
INSERT INTO tbl_recvoucher VALUES("892","0","REV050323102","","67000.00","2023-03-05","5","2023-03-05 01:26:17");
INSERT INTO tbl_recvoucher VALUES("893","0","REV050323103","","225000.00","2023-03-05","5","2023-03-05 03:08:46");
INSERT INTO tbl_recvoucher VALUES("894","0","REV060323101","","28500.00","2023-03-06","5","2023-03-06 11:33:39");
INSERT INTO tbl_recvoucher VALUES("895","0","REV060323102","1000 Less For Keyboard ","20500.00","2023-03-06","5","2023-03-06 11:35:38");
INSERT INTO tbl_recvoucher VALUES("896","0","REV060323103","","400000.00","2023-03-06","5","2023-03-06 01:55:21");
INSERT INTO tbl_recvoucher VALUES("897","0","REV060323104","","25000.00","2023-03-06","5","2023-03-06 10:58:16");
INSERT INTO tbl_recvoucher VALUES("898","0","REV060323105","","200000.00","2023-03-06","5","2023-03-06 10:58:59");
INSERT INTO tbl_recvoucher VALUES("899","0","REV060323106","","300000.00","2023-03-06","5","2023-03-06 10:59:44");
INSERT INTO tbl_recvoucher VALUES("900","0","REV060323107","","200000.00","2023-03-06","5","2023-03-06 11:23:20");
INSERT INTO tbl_recvoucher VALUES("901","0","REV090323101","","10000.00","2023-03-09","5","2023-03-09 10:53:43");
INSERT INTO tbl_recvoucher VALUES("902","0","REV090323102","","28000.00","2023-03-09","5","2023-03-09 11:02:14");
INSERT INTO tbl_recvoucher VALUES("903","0","REV100323101","","5000.00","2023-03-10","5","2023-03-10 05:47:20");
INSERT INTO tbl_recvoucher VALUES("904","0","REV100323102","","200000.00","2023-03-10","5","2023-03-10 06:20:27");
INSERT INTO tbl_recvoucher VALUES("905","0","REV100323103","","21000.00","2023-03-10","5","2023-03-10 07:28:25");
INSERT INTO tbl_recvoucher VALUES("906","0","REV110323101","","200000.00","2023-03-11","5","2023-03-11 01:03:52");
INSERT INTO tbl_recvoucher VALUES("907","0","REV120323101","","200000.00","2023-03-12","5","2023-03-12 06:47:43");
INSERT INTO tbl_recvoucher VALUES("908","0","REV130323101","","200000.00","2023-03-13","5","2023-03-13 06:21:15");
INSERT INTO tbl_recvoucher VALUES("909","0","REV130323102","","100000.00","2023-03-13","5","2023-03-13 06:24:45");
INSERT INTO tbl_recvoucher VALUES("910","0","REV160323101","","200000.00","2023-03-16","5","2023-03-16 07:44:23");
INSERT INTO tbl_recvoucher VALUES("911","0","REV180323101","","20500.00","2023-03-18","5","2023-03-18 04:52:42");
INSERT INTO tbl_recvoucher VALUES("912","0","REV180323102","","10000.00","2023-03-18","5","2023-03-18 08:11:15");
INSERT INTO tbl_recvoucher VALUES("913","0","REV190323101","","15000.00","2023-03-19","5","2023-03-19 12:03:46");
INSERT INTO tbl_recvoucher VALUES("914","0","REV190323102","","240000.00","2023-03-19","5","2023-03-19 12:04:20");
INSERT INTO tbl_recvoucher VALUES("915","0","REV190323103","","676600.00","2023-03-19","5","2023-03-19 12:04:50");
INSERT INTO tbl_recvoucher VALUES("916","0","REV190323104","","92500.00","2023-03-19","5","2023-03-19 02:46:30");
INSERT INTO tbl_recvoucher VALUES("917","0","REV190323105","","200000.00","2023-03-19","5","2023-03-19 05:58:16");
INSERT INTO tbl_recvoucher VALUES("918","0","REV190323106","","40000.00","2023-03-19","5","2023-03-19 06:13:41");
INSERT INTO tbl_recvoucher VALUES("919","0","REV200323101","","20000.00","2023-03-20","5","2023-03-20 12:26:54");
INSERT INTO tbl_recvoucher VALUES("920","0","REV200323102","","20000.00","2023-03-20","5","2023-03-20 12:28:40");
INSERT INTO tbl_recvoucher VALUES("921","0","REV200323103","","25000.00","2023-03-20","5","2023-03-20 12:33:41");
INSERT INTO tbl_recvoucher VALUES("922","0","REV200323104","","146600.00","2023-03-20","5","2023-03-20 12:57:30");
INSERT INTO tbl_recvoucher VALUES("923","0","REV200323105","","73500.00","2023-03-20","5","2023-03-20 01:04:33");
INSERT INTO tbl_recvoucher VALUES("924","0","REV200323106","","20000.00","2023-03-20","5","2023-03-20 07:58:05");
INSERT INTO tbl_recvoucher VALUES("925","0","REV220323101","","150000.00","2023-03-22","5","2023-03-22 12:21:19");
INSERT INTO tbl_recvoucher VALUES("926","0","REV220323102","","28000.00","2023-03-22","5","2023-03-22 05:23:25");
INSERT INTO tbl_recvoucher VALUES("927","0","REV220323103","","20000.00","2023-03-22","5","2023-03-22 07:47:10");
INSERT INTO tbl_recvoucher VALUES("928","0","REV220323104","","19500.00","2023-03-22","5","2023-03-22 07:47:32");
INSERT INTO tbl_recvoucher VALUES("929","0","REV230323101","","19500.00","2023-03-23","5","2023-03-23 04:03:44");
INSERT INTO tbl_recvoucher VALUES("930","0","REV230323102","","116000.00","2023-03-23","5","2023-03-23 04:04:09");
INSERT INTO tbl_recvoucher VALUES("931","0","REV230323103","","69500.00","2023-03-23","5","2023-03-23 05:36:30");
INSERT INTO tbl_recvoucher VALUES("932","0","REV230323104","","200000.00","2023-03-23","5","2023-03-23 05:39:42");
INSERT INTO tbl_recvoucher VALUES("933","0","REV230323105","","20000.00","2023-03-23","5","2023-03-23 07:34:59");
INSERT INTO tbl_recvoucher VALUES("934","0","REV230323106","","73500.00","2023-03-23","5","2023-03-23 07:47:44");
INSERT INTO tbl_recvoucher VALUES("935","0","REV240323101","","7300.00","2023-03-24","5","2023-03-24 01:05:37");
INSERT INTO tbl_recvoucher VALUES("936","0","REV250323101","","49500.00","2023-03-25","5","2023-03-25 04:27:13");
INSERT INTO tbl_recvoucher VALUES("937","0","REV250323102","","22000.00","2023-03-25","5","2023-03-25 04:30:26");
INSERT INTO tbl_recvoucher VALUES("938","0","REV250323103","","20000.00","2023-03-25","5","2023-03-25 05:19:22");
INSERT INTO tbl_recvoucher VALUES("939","0","REV250323104","","500000.00","2023-03-25","5","2023-03-25 07:31:33");
INSERT INTO tbl_recvoucher VALUES("940","0","REV260323101","","40000.00","2023-03-26","5","2023-03-26 09:33:23");
INSERT INTO tbl_recvoucher VALUES("941","0","REV270323101","","20000.00","2023-03-27","5","2023-03-27 02:45:48");
INSERT INTO tbl_recvoucher VALUES("942","0","REV270323102","","20000.00","2023-03-27","5","2023-03-27 03:43:30");
INSERT INTO tbl_recvoucher VALUES("943","0","REV270323103","","300000.00","2023-03-27","5","2023-03-27 04:21:12");
INSERT INTO tbl_recvoucher VALUES("944","0","REV270323104","","50000.00","2023-03-27","5","2023-03-27 04:37:31");
INSERT INTO tbl_recvoucher VALUES("945","0","REV280323101","","25000.00","2023-03-28","5","2023-03-28 03:20:14");
INSERT INTO tbl_recvoucher VALUES("946","0","REV290323101","","56000.00","2023-03-29","5","2023-03-29 12:45:54");
INSERT INTO tbl_recvoucher VALUES("947","0","REV290323102","","150000.00","2023-03-29","5","2023-03-29 12:56:20");
INSERT INTO tbl_recvoucher VALUES("948","0","REV290323103","","20500.00","2023-03-29","5","2023-03-29 06:13:01");
INSERT INTO tbl_recvoucher VALUES("949","0","REV290323104","","20000.00","2023-03-29","5","2023-03-29 06:17:11");
INSERT INTO tbl_recvoucher VALUES("950","0","REV300323101","","100000.00","2023-03-30","5","2023-03-30 10:57:38");
INSERT INTO tbl_recvoucher VALUES("951","0","REV300323102","","37000.00","2023-03-30","5","2023-03-30 10:59:17");
INSERT INTO tbl_recvoucher VALUES("952","0","REV300323103","","20500.00","2023-03-30","5","2023-03-30 12:01:12");
INSERT INTO tbl_recvoucher VALUES("953","0","REV010423101","","20000.00","2023-04-01","5","2023-04-01 04:38:30");
INSERT INTO tbl_recvoucher VALUES("954","0","REV010423102","","15000.00","2023-04-01","5","2023-04-01 05:19:40");
INSERT INTO tbl_recvoucher VALUES("955","0","REV010423103","","130000.00","2023-01-29","5","2023-04-01 10:41:52");
INSERT INTO tbl_recvoucher VALUES("958","0","REV010423105","","100000.00","2023-02-06","5","2023-04-01 11:08:24");
INSERT INTO tbl_recvoucher VALUES("959","0","REV010423106","","90000.00","2023-02-02","5","2023-04-01 11:17:12");
INSERT INTO tbl_recvoucher VALUES("960","0","REV010423107","","100000.00","2023-01-31","5","2023-04-01 11:24:05");
INSERT INTO tbl_recvoucher VALUES("962","0","REV010423109","","150000.00","2023-03-05","5","2023-04-01 11:27:27");
INSERT INTO tbl_recvoucher VALUES("963","0","REV010423110","","100000.00","2023-03-12","5","2023-04-01 11:28:08");
INSERT INTO tbl_recvoucher VALUES("966","0","REV010423113","","200000.00","2023-02-25","5","2023-04-01 11:38:30");
INSERT INTO tbl_recvoucher VALUES("967","0","REV010423114","","500000.00","2023-03-20","5","2023-04-01 11:44:35");
INSERT INTO tbl_recvoucher VALUES("968","0","REV020423101","","50000.00","2023-04-02","5","2023-04-02 04:20:19");
INSERT INTO tbl_recvoucher VALUES("969","0","REV030423101","","139500.00","2023-04-03","5","2023-04-03 10:57:17");
INSERT INTO tbl_recvoucher VALUES("970","0","REV030423102","","20000.00","2023-04-03","5","2023-04-03 02:40:18");
INSERT INTO tbl_recvoucher VALUES("971","0","REV030423103","","50000.00","2023-04-03","5","2023-04-03 04:09:09");
INSERT INTO tbl_recvoucher VALUES("972","0","REV030423104","","100000.00","2023-04-03","5","2023-04-03 04:33:32");
INSERT INTO tbl_recvoucher VALUES("973","0","REV030423105","","100000.00","2023-04-02","5","2023-04-03 04:36:22");
INSERT INTO tbl_recvoucher VALUES("974","0","REV030423106","","200000.00","2023-04-03","5","2023-04-03 08:21:44");
INSERT INTO tbl_recvoucher VALUES("975","0","REV030423107","","95000.00","2023-04-03","5","2023-04-03 08:27:28");
INSERT INTO tbl_recvoucher VALUES("976","0","REV030423108","","96000.00","2023-04-03","5","2023-04-03 10:52:49");
INSERT INTO tbl_recvoucher VALUES("977","0","REV040423101","","73000.00","2023-04-04","5","2023-04-04 11:42:50");
INSERT INTO tbl_recvoucher VALUES("978","0","REV040423102","600 Less Payment 17200tk","17800.00","2023-04-04","5","2023-04-04 03:46:26");
INSERT INTO tbl_recvoucher VALUES("980","0","REV050423102","","5000.00","2023-04-05","5","2023-04-05 01:38:20");
INSERT INTO tbl_recvoucher VALUES("981","0","REV060423101","","100000.00","2023-04-02","5","2023-04-06 12:03:03");
INSERT INTO tbl_recvoucher VALUES("982","0","REV060423102","","100000.00","2023-04-06","5","2023-04-06 04:28:27");
INSERT INTO tbl_recvoucher VALUES("983","0","REV060423103","","50000.00","2023-04-06","5","2023-04-06 07:15:29");
INSERT INTO tbl_recvoucher VALUES("984","0","REV070423101","","50000.00","2023-04-07","5","2023-04-07 07:25:43");
INSERT INTO tbl_recvoucher VALUES("985","0","REV070423102","","40000.00","2023-04-07","5","2023-04-07 07:51:21");
INSERT INTO tbl_recvoucher VALUES("986","0","REV080423101","","40000.00","2023-04-08","5","2023-04-08 10:27:02");
INSERT INTO tbl_recvoucher VALUES("987","0","REV090423101","","147000.00","2023-04-09","5","2023-04-09 01:23:40");
INSERT INTO tbl_recvoucher VALUES("988","0","REV090423102","","100000.00","2023-04-09","5","2023-04-09 01:55:28");
INSERT INTO tbl_recvoucher VALUES("989","0","REV090423103","","20000.00","2023-04-09","5","2023-04-09 02:46:26");
INSERT INTO tbl_recvoucher VALUES("990","0","REV090423104","","28000.00","2023-04-09","5","2023-04-09 03:52:48");
INSERT INTO tbl_recvoucher VALUES("991","0","REV090423105","","8000.00","2023-04-09","5","2023-04-09 03:57:06");
INSERT INTO tbl_recvoucher VALUES("992","0","REV100423101","","50000.00","2023-04-10","5","2023-04-10 10:25:20");
INSERT INTO tbl_recvoucher VALUES("993","0","REV100423102","","50000.00","2023-04-09","5","2023-04-10 01:27:33");
INSERT INTO tbl_recvoucher VALUES("994","0","REV100423103","","100000.00","2023-04-10","5","2023-04-10 03:01:38");
INSERT INTO tbl_recvoucher VALUES("995","0","REV110423101","","75000.00","2023-04-11","5","2023-04-11 10:44:43");
INSERT INTO tbl_recvoucher VALUES("996","0","REV110423102","","22000.00","2023-04-11","5","2023-04-11 01:13:25");
INSERT INTO tbl_recvoucher VALUES("997","0","REV110423103","","26000.00","2023-04-11","5","2023-04-11 02:34:47");
INSERT INTO tbl_recvoucher VALUES("998","0","REV120423101","","24000.00","2023-04-12","5","2023-04-12 06:44:05");
INSERT INTO tbl_recvoucher VALUES("999","0","REV120423102","","9500.00","2023-04-12","5","2023-04-12 07:31:42");
INSERT INTO tbl_recvoucher VALUES("1000","0","REV140423101","","18800.00","2023-04-14","5","2023-04-14 10:17:20");
INSERT INTO tbl_recvoucher VALUES("1001","0","REV140423102","","63000.00","2023-04-14","5","2023-04-14 10:17:41");
INSERT INTO tbl_recvoucher VALUES("1003","0","REV140423103","","28000.00","2023-04-14","5","2023-04-14 10:19:26");
INSERT INTO tbl_recvoucher VALUES("1004","0","REV140423104","","21000.00","2023-04-14","5","2023-04-14 10:22:14");
INSERT INTO tbl_recvoucher VALUES("1005","0","REV160423101","","10000.00","2023-04-16","5","2023-04-16 11:13:24");
INSERT INTO tbl_recvoucher VALUES("1006","0","REV170423101","500 Less","20500.00","2023-04-17","5","2023-04-17 12:59:59");
INSERT INTO tbl_recvoucher VALUES("1007","0","REV170423102","","32000.00","2023-04-17","5","2023-04-17 01:02:05");
INSERT INTO tbl_recvoucher VALUES("1008","0","REV170423103","","27500.00","2023-04-17","5","2023-04-17 01:05:18");
INSERT INTO tbl_recvoucher VALUES("1009","0","REV170423104","","50000.00","2023-04-17","5","2023-04-17 03:07:26");
INSERT INTO tbl_recvoucher VALUES("1010","0","REV180423101","","20000.00","2023-04-18","5","2023-04-18 12:42:10");
INSERT INTO tbl_recvoucher VALUES("1011","0","REV180423102","","50000.00","2023-04-18","5","2023-04-18 01:00:08");
INSERT INTO tbl_recvoucher VALUES("1012","0","REV180423103","","30000.00","2023-04-18","5","2023-04-18 01:05:18");
INSERT INTO tbl_recvoucher VALUES("1013","0","REV180423104","","130000.00","2023-01-29","5","2023-04-18 03:02:22");
INSERT INTO tbl_recvoucher VALUES("1015","0","REV180423106","","90000.00","2023-02-02","5","2023-04-18 03:04:01");
INSERT INTO tbl_recvoucher VALUES("1016","0","REV180423107","","100000.00","2023-02-06","5","2023-04-18 03:05:02");
INSERT INTO tbl_recvoucher VALUES("1019","0","REV180423109","Cash","200000.00","2023-02-25","5","2023-04-18 03:08:42");
INSERT INTO tbl_recvoucher VALUES("1020","0","REV180423110","","150000.00","2023-03-05","5","2023-04-18 03:09:41");
INSERT INTO tbl_recvoucher VALUES("1021","0","REV180423111","City Dubai","100000.00","2023-03-12","5","2023-04-18 03:11:18");
INSERT INTO tbl_recvoucher VALUES("1022","0","REV180423112","Brac Cq 450+50","500000.00","2023-03-20","5","2023-04-18 03:14:01");
INSERT INTO tbl_recvoucher VALUES("1023","0","REV190423101","","100000.00","2023-02-04","5","2023-04-19 11:42:08");
INSERT INTO tbl_recvoucher VALUES("1024","0","REV190423102","Tv","12000.00","2023-02-20","5","2023-04-19 11:51:02");
INSERT INTO tbl_recvoucher VALUES("1025","0","REV190423103","","36000.00","2023-04-19","5","2023-04-19 12:43:17");
INSERT INTO tbl_recvoucher VALUES("1026","0","REV190423104","","4000.00","2023-04-19","5","2023-04-19 02:11:57");
INSERT INTO tbl_recvoucher VALUES("1027","0","REV300423101","","10000.00","2023-04-30","5","2023-04-30 11:06:38");
INSERT INTO tbl_recvoucher VALUES("1028","0","REV300423102","","19000.00","2023-04-30","5","2023-04-30 11:43:42");
INSERT INTO tbl_recvoucher VALUES("1029","0","REV300423103","","250000.00","2023-04-30","5","2023-04-30 12:36:05");
INSERT INTO tbl_recvoucher VALUES("1030","0","REV030523101","","7000.00","2023-05-03","5","2023-05-03 04:50:41");
INSERT INTO tbl_recvoucher VALUES("1031","0","REV030523102","","100000.00","2023-05-03","5","2023-05-03 06:16:23");
INSERT INTO tbl_recvoucher VALUES("1032","0","REV040523101","","21000.00","2023-05-04","5","2023-05-04 02:03:41");
INSERT INTO tbl_recvoucher VALUES("1033","0","REV040523102","","20000.00","2023-05-04","5","2023-05-04 08:11:17");
INSERT INTO tbl_recvoucher VALUES("1034","0","REV040523103","","3000.00","2023-05-04","5","2023-05-04 08:17:07");
INSERT INTO tbl_recvoucher VALUES("1035","0","REV050523101","","25000.00","2023-05-05","5","2023-05-05 04:12:20");
INSERT INTO tbl_recvoucher VALUES("1036","0","REV050523102","","20000.00","2023-05-05","5","2023-05-05 07:08:15");
INSERT INTO tbl_recvoucher VALUES("1037","0","REV060523101","","20000.00","2023-05-06","5","2023-05-06 02:50:23");
INSERT INTO tbl_recvoucher VALUES("1038","0","REV070523101","","30000.00","2023-05-07","5","2023-05-07 11:07:34");
INSERT INTO tbl_recvoucher VALUES("1039","0","REV080523101","","33000.00","2023-05-08","5","2023-05-08 06:35:25");
INSERT INTO tbl_recvoucher VALUES("1040","0","REV080523102","","28000.00","2023-05-08","5","2023-05-08 07:40:22");
INSERT INTO tbl_recvoucher VALUES("1041","0","REV100523101","","17000.00","2023-05-10","5","2023-05-10 11:01:28");
INSERT INTO tbl_recvoucher VALUES("1042","0","REV100523102","","13000.00","2023-05-10","5","2023-05-10 11:03:07");
INSERT INTO tbl_recvoucher VALUES("1043","0","REV100523103","","21000.00","2023-05-10","5","2023-05-10 11:53:28");
INSERT INTO tbl_recvoucher VALUES("1045","0","REV100523105","","68000.00","2023-05-10","5","2023-05-10 05:42:58");
INSERT INTO tbl_recvoucher VALUES("1046","0","REV100523106","","102500.00","2023-05-10","5","2023-05-10 07:08:39");
INSERT INTO tbl_recvoucher VALUES("1047","0","REV110523101","","51000.00","2023-05-11","5","2023-05-11 04:07:18");
INSERT INTO tbl_recvoucher VALUES("1048","0","REV110523102","","35000.00","2023-05-11","5","2023-05-11 06:25:57");
INSERT INTO tbl_recvoucher VALUES("1049","0","REV130523101","","150000.00","2023-05-13","5","2023-05-13 07:48:31");
INSERT INTO tbl_recvoucher VALUES("1050","0","REV140523101","","30000.00","2023-05-14","5","2023-05-14 03:30:11");
INSERT INTO tbl_recvoucher VALUES("1051","0","REV150523101","","20000.00","2023-05-15","5","2023-05-15 11:04:57");
INSERT INTO tbl_recvoucher VALUES("1052","0","REV150523102","","41000.00","2023-05-15","5","2023-05-15 07:47:05");
INSERT INTO tbl_recvoucher VALUES("1053","0","REV170523101","","85000.00","2023-05-17","5","2023-05-17 04:08:17");
INSERT INTO tbl_recvoucher VALUES("1055","0","REV190523101","","147000.00","2023-05-19","5","2023-05-19 11:32:49");
INSERT INTO tbl_recvoucher VALUES("1056","0","REV210523101","","212000.00","2023-05-21","5","2023-05-21 02:02:48");
INSERT INTO tbl_recvoucher VALUES("1057","0","REV220523101","","50000.00","2023-05-22","5","2023-05-22 04:26:31");
INSERT INTO tbl_recvoucher VALUES("1058","0","REV230523101","","120000.00","2023-05-23","5","2023-05-23 04:28:46");
INSERT INTO tbl_recvoucher VALUES("1059","0","REV240523101","","200000.00","2023-05-24","5","2023-05-24 05:15:47");
INSERT INTO tbl_recvoucher VALUES("1060","0","REV250523101","","22000.00","2023-05-25","5","2023-05-25 11:05:10");
INSERT INTO tbl_recvoucher VALUES("1061","0","REV250523102","","20000.00","2023-05-25","5","2023-05-25 11:06:01");
INSERT INTO tbl_recvoucher VALUES("1062","0","REV250523103","","69500.00","2023-05-25","5","2023-05-25 05:52:17");
INSERT INTO tbl_recvoucher VALUES("1063","0","REV260523101","","20000.00","2023-05-26","5","2023-05-26 03:23:23");
INSERT INTO tbl_recvoucher VALUES("1064","0","REV260523102","","39000.00","2023-05-26","5","2023-05-26 08:08:48");
INSERT INTO tbl_recvoucher VALUES("1065","0","REV280523101","","150000.00","2023-05-28","5","2023-05-28 03:59:28");
INSERT INTO tbl_recvoucher VALUES("1066","0","REV280523102","","27500.00","2023-05-28","5","2023-05-28 02:05:51");
INSERT INTO tbl_recvoucher VALUES("1067","0","REV280523103","","140000.00","2023-05-28","5","2023-05-28 04:44:58");
INSERT INTO tbl_recvoucher VALUES("1068","0","REV290523101","","50000.00","2023-05-29","5","2023-05-29 01:29:11");
INSERT INTO tbl_recvoucher VALUES("1069","0","REV290523102","","100000.00","2023-05-29","5","2023-05-29 01:31:16");
INSERT INTO tbl_recvoucher VALUES("1070","0","REV290523103","","92500.00","2023-05-29","5","2023-05-29 01:16:56");
INSERT INTO tbl_recvoucher VALUES("1071","0","REV290523104","","40000.00","2023-05-29","5","2023-05-29 01:17:33");
INSERT INTO tbl_recvoucher VALUES("1072","0","REV290523105","","6000.00","2023-05-29","5","2023-05-29 05:16:58");
INSERT INTO tbl_recvoucher VALUES("1073","0","REV290523106","","61500.00","2023-05-29","5","2023-05-29 08:08:20");
INSERT INTO tbl_recvoucher VALUES("1074","0","REV300523101","","30000.00","2023-05-30","5","2023-05-30 03:58:13");
INSERT INTO tbl_recvoucher VALUES("1075","0","REV310523101","","103000.00","2023-05-31","5","2023-05-31 04:08:30");
INSERT INTO tbl_recvoucher VALUES("1076","0","REV310523102","","200000.00","2023-05-31","5","2023-05-31 05:31:19");
INSERT INTO tbl_recvoucher VALUES("1077","0","REV310523103","","100000.00","2023-05-31","5","2023-05-31 07:26:16");
INSERT INTO tbl_recvoucher VALUES("1078","0","REV310523104","","21000.00","2023-05-31","5","2023-05-31 07:49:01");
INSERT INTO tbl_recvoucher VALUES("1079","0","REV020623101","","45000.00","2023-06-02","5","2023-06-02 11:41:06");
INSERT INTO tbl_recvoucher VALUES("1080","0","REV020623102","","42000.00","2023-06-02","5","2023-06-02 03:22:58");
INSERT INTO tbl_recvoucher VALUES("1081","0","REV020623103","","100000.00","2023-06-02","5","2023-06-02 03:36:27");
INSERT INTO tbl_recvoucher VALUES("1082","0","REV020623104","","50000.00","2023-06-02","5","2023-06-02 08:25:19");
INSERT INTO tbl_recvoucher VALUES("1083","0","REV030623101","","58500.00","2023-06-03","5","2023-06-03 03:13:57");
INSERT INTO tbl_recvoucher VALUES("1084","0","REV040623101","","50000.00","2023-06-04","5","2023-06-04 10:13:47");
INSERT INTO tbl_recvoucher VALUES("1085","0","REV040623102","","100000.00","2023-06-04","5","2023-06-04 10:14:28");
INSERT INTO tbl_recvoucher VALUES("1086","0","REV040623103","","100000.00","2023-06-04","5","2023-06-04 10:14:57");
INSERT INTO tbl_recvoucher VALUES("1087","0","REV040623104","","100000.00","2023-06-04","5","2023-06-04 10:15:22");
INSERT INTO tbl_recvoucher VALUES("1088","0","REV050623101","","16500.00","2023-06-05","5","2023-06-05 01:56:05");
INSERT INTO tbl_recvoucher VALUES("1089","0","REV050623102","","80000.00","2023-06-05","5","2023-06-05 03:53:28");
INSERT INTO tbl_recvoucher VALUES("1090","0","REV050623103","","100000.00","2023-06-05","5","2023-06-05 04:09:41");
INSERT INTO tbl_recvoucher VALUES("1091","0","REV050623104","","310000.00","2023-06-05","5","2023-06-05 08:00:24");
INSERT INTO tbl_recvoucher VALUES("1093","0","REV060623101","","35000.00","2023-06-06","5","2023-06-06 04:39:12");
INSERT INTO tbl_recvoucher VALUES("1094","0","REV060623102","","20000.00","2023-06-06","5","2023-06-06 04:43:01");
INSERT INTO tbl_recvoucher VALUES("1095","0","REV070623101","","80000.00","2023-06-07","5","2023-06-07 04:00:55");
INSERT INTO tbl_recvoucher VALUES("1096","0","REV070623102","","60000.00","2023-06-07","5","2023-06-07 03:05:48");
INSERT INTO tbl_recvoucher VALUES("1097","0","REV080623101","","18000.00","2023-06-08","5","2023-06-08 03:10:21");
INSERT INTO tbl_recvoucher VALUES("1098","0","REV080623102","","184200.00","2023-06-08","5","2023-06-08 03:16:35");
INSERT INTO tbl_recvoucher VALUES("1099","0","REV080623103","","100000.00","2023-06-08","5","2023-06-08 03:18:04");
INSERT INTO tbl_recvoucher VALUES("1100","0","REV080623104","","216000.00","2023-06-08","5","2023-06-08 03:24:42");
INSERT INTO tbl_recvoucher VALUES("1101","0","REV090623101","","99000.00","2023-06-09","5","2023-06-09 03:31:24");
INSERT INTO tbl_recvoucher VALUES("1102","0","REV100623101","","50000.00","2023-06-10","5","2023-06-10 11:36:58");
INSERT INTO tbl_recvoucher VALUES("1103","0","REV100623102","","7000.00","2023-06-10","5","2023-06-10 06:11:55");
INSERT INTO tbl_recvoucher VALUES("1104","0","REV100623103","","100000.00","2023-06-10","5","2023-06-10 06:25:10");
INSERT INTO tbl_recvoucher VALUES("1105","0","REV110623101","","136000.00","2023-06-11","5","2023-06-11 11:46:08");
INSERT INTO tbl_recvoucher VALUES("1106","0","REV110623102","","60000.00","2023-06-11","5","2023-06-11 12:47:23");
INSERT INTO tbl_recvoucher VALUES("1107","0","REV110623103","","100000.00","2023-06-11","5","2023-06-11 04:01:13");
INSERT INTO tbl_recvoucher VALUES("1108","0","REV110623104","","190000.00","2023-06-11","5","2023-06-11 04:01:43");
INSERT INTO tbl_recvoucher VALUES("1109","0","REV120623101","","100000.00","2023-06-12","5","2023-06-12 02:57:34");
INSERT INTO tbl_recvoucher VALUES("1110","0","REV120623102","","100000.00","2023-06-12","5","2023-06-12 04:17:03");
INSERT INTO tbl_recvoucher VALUES("1111","0","REV120623103","","91000.00","2023-06-12","5","2023-06-12 05:52:13");
INSERT INTO tbl_recvoucher VALUES("1112","0","REV120623104","","70000.00","2023-06-12","5","2023-06-12 08:10:37");
INSERT INTO tbl_recvoucher VALUES("1113","0","REV120623105","","18000.00","2023-06-12","5","2023-06-12 08:21:32");
INSERT INTO tbl_recvoucher VALUES("1114","0","REV120623106","","130000.00","2023-06-12","5","2023-06-12 09:03:48");
INSERT INTO tbl_recvoucher VALUES("1115","0","REV130623101","","150000.00","2023-06-13","5","2023-06-13 02:49:59");
INSERT INTO tbl_recvoucher VALUES("1116","0","REV130623102","","336500.00","2023-06-13","5","2023-06-13 04:33:48");
INSERT INTO tbl_recvoucher VALUES("1117","0","REV130623103","","214500.00","2023-06-13","5","2023-06-13 04:58:57");
INSERT INTO tbl_recvoucher VALUES("1118","0","REV130623104","","81000.00","2023-06-13","5","2023-06-13 05:08:31");
INSERT INTO tbl_recvoucher VALUES("1119","0","REV140623101","","30000.00","2023-06-14","5","2023-06-14 01:44:27");
INSERT INTO tbl_recvoucher VALUES("1120","0","REV140623102","","100000.00","2023-06-14","5","2023-06-14 02:31:28");
INSERT INTO tbl_recvoucher VALUES("1121","0","REV140623103","","19500.00","2023-06-14","5","2023-06-14 04:01:41");
INSERT INTO tbl_recvoucher VALUES("1122","0","REV140623104","","40000.00","2023-06-14","5","2023-06-14 07:21:43");
INSERT INTO tbl_recvoucher VALUES("1123","0","REV150623101","","78000.00","2023-06-15","5","2023-06-15 02:45:47");
INSERT INTO tbl_recvoucher VALUES("1124","0","REV150623102","","27500.00","2023-06-15","5","2023-06-15 03:03:38");
INSERT INTO tbl_recvoucher VALUES("1125","0","REV150623103","","28000.00","2023-06-15","5","2023-06-15 03:14:25");
INSERT INTO tbl_recvoucher VALUES("1126","0","REV150623104","","38000.00","2023-06-15","5","2023-06-15 04:35:46");
INSERT INTO tbl_recvoucher VALUES("1127","0","REV150623105","","75000.00","2023-06-15","5","2023-06-15 07:05:30");
INSERT INTO tbl_recvoucher VALUES("1128","0","REV160623101","","50000.00","2023-06-16","5","2023-06-16 05:49:04");
INSERT INTO tbl_recvoucher VALUES("1129","0","REV160623102","","100000.00","2023-06-16","5","2023-06-16 05:49:39");
INSERT INTO tbl_recvoucher VALUES("1130","0","REV160623103","","164700.00","2023-06-14","5","2023-06-16 02:18:56");
INSERT INTO tbl_recvoucher VALUES("1131","0","REV160623104","","55000.00","2023-06-16","5","2023-06-16 02:28:12");
INSERT INTO tbl_recvoucher VALUES("1132","0","REV160623105","","27000.00","2023-06-16","5","2023-06-16 06:01:04");
INSERT INTO tbl_recvoucher VALUES("1133","0","REV170623101","","20000.00","2023-06-17","5","2023-06-17 03:56:56");
INSERT INTO tbl_recvoucher VALUES("1134","0","REV170623102","","60500.00","2023-06-17","5","2023-06-17 03:28:27");
INSERT INTO tbl_recvoucher VALUES("1135","0","REV170623103","","20000.00","2023-06-17","5","2023-06-17 04:19:09");
INSERT INTO tbl_recvoucher VALUES("1136","0","REV170623104","","14500.00","2023-06-17","5","2023-06-17 04:27:17");
INSERT INTO tbl_recvoucher VALUES("1137","0","REV170623105","","42000.00","2023-06-17","5","2023-06-17 04:28:10");
INSERT INTO tbl_recvoucher VALUES("1138","0","REV180623101","","48000.00","2023-06-18","5","2023-06-18 11:28:49");
INSERT INTO tbl_recvoucher VALUES("1139","0","REV180623102","","100000.00","2023-06-17","5","2023-06-18 11:38:31");
INSERT INTO tbl_recvoucher VALUES("1140","0","REV180623103","","173700.00","2023-06-18","5","2023-06-18 11:39:10");
INSERT INTO tbl_recvoucher VALUES("1141","0","REV180623104","","192500.00","2023-06-18","5","2023-06-18 12:03:08");
INSERT INTO tbl_recvoucher VALUES("1142","0","REV180623105","","150000.00","2023-06-18","5","2023-06-18 02:18:13");
INSERT INTO tbl_recvoucher VALUES("1143","0","REV180623106","","32000.00","2023-06-18","5","2023-06-18 02:48:22");
INSERT INTO tbl_recvoucher VALUES("1144","0","REV180623107","","19500.00","2023-06-18","5","2023-06-18 03:32:27");
INSERT INTO tbl_recvoucher VALUES("1145","0","REV180623108","","100000.00","2023-06-18","5","2023-06-18 04:07:55");
INSERT INTO tbl_recvoucher VALUES("1146","0","REV180623109","","50000.00","2023-06-18","5","2023-06-18 04:11:53");
INSERT INTO tbl_recvoucher VALUES("1147","0","REV180623110","","100000.00","2023-06-18","5","2023-06-18 04:55:31");
INSERT INTO tbl_recvoucher VALUES("1148","0","REV180623111","","100000.00","2023-06-18","5","2023-06-18 06:07:37");
INSERT INTO tbl_recvoucher VALUES("1149","0","REV190623101","","140000.00","2023-06-19","5","2023-06-19 04:34:34");
INSERT INTO tbl_recvoucher VALUES("1150","0","REV190623102","","45000.00","2023-06-19","5","2023-06-19 05:47:28");
INSERT INTO tbl_recvoucher VALUES("1151","0","REV200623101","","140000.00","2023-06-20","5","2023-06-20 12:31:15");
INSERT INTO tbl_recvoucher VALUES("1152","0","REV210623101","","21000.00","2023-06-21","5","2023-06-21 12:52:50");
INSERT INTO tbl_recvoucher VALUES("1153","0","REV210623102","","50000.00","2023-06-21","5","2023-06-21 01:46:41");
INSERT INTO tbl_recvoucher VALUES("1154","0","REV210623103","","450.00","2023-06-21","5","2023-06-21 02:39:24");
INSERT INTO tbl_recvoucher VALUES("1155","0","REV210623104","","40000.00","2023-06-21","5","2023-06-21 04:53:56");
INSERT INTO tbl_recvoucher VALUES("1156","0","REV220623101","","60000.00","2023-06-22","5","2023-06-22 11:01:56");
INSERT INTO tbl_recvoucher VALUES("1157","0","REV220623102","","40000.00","2023-06-22","5","2023-06-22 04:28:22");
INSERT INTO tbl_recvoucher VALUES("1158","0","REV220623103","","102500.00","2023-06-22","5","2023-06-22 06:15:15");
INSERT INTO tbl_recvoucher VALUES("1159","0","REV230623101","","100000.00","2023-06-23","5","2023-06-23 01:02:31");
INSERT INTO tbl_recvoucher VALUES("1160","0","REV240623101","","20000.00","2023-06-24","5","2023-06-24 03:10:27");
INSERT INTO tbl_recvoucher VALUES("1161","0","REV240623102","","172000.00","2023-06-24","5","2023-06-24 06:22:58");
INSERT INTO tbl_recvoucher VALUES("1162","0","REV240623103","","30000.00","2023-06-24","5","2023-06-24 06:40:20");
INSERT INTO tbl_recvoucher VALUES("1163","0","REV240623104","","87000.00","2023-06-24","5","2023-06-24 06:48:20");
INSERT INTO tbl_recvoucher VALUES("1164","0","REV250623101","","70000.00","2023-06-25","5","2023-06-25 01:34:30");
INSERT INTO tbl_recvoucher VALUES("1165","0","REV250623102","","29000.00","2023-06-25","5","2023-06-25 02:21:40");
INSERT INTO tbl_recvoucher VALUES("1166","0","REV250623103","","20000.00","2023-06-25","5","2023-06-25 02:22:22");
INSERT INTO tbl_recvoucher VALUES("1167","0","REV250623104","","100000.00","2023-06-25","5","2023-06-25 05:24:33");
INSERT INTO tbl_recvoucher VALUES("1168","0","REV250623105","","56000.00","2023-06-25","5","2023-06-25 06:39:38");
INSERT INTO tbl_recvoucher VALUES("1169","0","REV250623106","","30000.00","2023-06-25","5","2023-06-25 06:44:24");
INSERT INTO tbl_recvoucher VALUES("1170","0","REV250623107","","20000.00","2023-06-25","5","2023-06-25 07:19:36");
INSERT INTO tbl_recvoucher VALUES("1171","0","REV260623101","","100000.00","2023-06-26","5","2023-06-26 02:09:44");
INSERT INTO tbl_recvoucher VALUES("1172","0","REV260623102","","20500.00","2023-06-26","5","2023-06-26 04:12:36");
INSERT INTO tbl_recvoucher VALUES("1173","0","REV260623103","","54000.00","2023-06-26","5","2023-06-26 05:27:39");
INSERT INTO tbl_recvoucher VALUES("1174","0","REV260623104","","20000.00","2023-06-26","5","2023-06-26 06:26:09");
INSERT INTO tbl_recvoucher VALUES("1175","0","REV260623105","","35000.00","2023-06-26","5","2023-06-26 06:48:01");
INSERT INTO tbl_recvoucher VALUES("1176","0","REV260623106","","45000.00","2023-06-26","5","2023-06-26 07:03:51");
INSERT INTO tbl_recvoucher VALUES("1177","0","REV260623107","","30000.00","2023-06-26","5","2023-06-26 07:22:03");
INSERT INTO tbl_recvoucher VALUES("1178","0","REV260623108","","50000.00","2023-06-26","5","2023-06-26 08:10:54");
INSERT INTO tbl_recvoucher VALUES("1179","0","REV260623109","","15000.00","2023-06-26","5","2023-06-26 08:19:39");
INSERT INTO tbl_recvoucher VALUES("1180","0","REV270623101","","30000.00","2023-06-27","5","2023-06-27 12:37:35");
INSERT INTO tbl_recvoucher VALUES("1181","0","REV300623101","","74000.00","2023-06-30","5","2023-06-30 03:01:41");
INSERT INTO tbl_recvoucher VALUES("1182","0","REV300623102","","9000.00","2023-06-30","5","2023-06-30 03:02:51");
INSERT INTO tbl_recvoucher VALUES("1183","0","REV060723101","","28500.00","2023-07-06","5","2023-07-06 07:59:44");
INSERT INTO tbl_recvoucher VALUES("1184","0","REV070723101","","95000.00","2023-07-07","5","2023-07-07 09:38:16");
INSERT INTO tbl_recvoucher VALUES("1185","0","REV090723101","","100000.00","2023-07-09","5","2023-07-09 03:03:18");
INSERT INTO tbl_recvoucher VALUES("1186","0","REV090723102","","74200.00","2023-07-09","5","2023-07-09 06:25:07");
INSERT INTO tbl_recvoucher VALUES("1187","0","REV090723103","","120000.00","2023-07-09","5","2023-07-09 06:33:40");
INSERT INTO tbl_recvoucher VALUES("1188","0","REV090723104","","19500.00","2023-07-09","5","2023-07-09 08:21:26");
INSERT INTO tbl_recvoucher VALUES("1189","0","REV100723101","","150000.00","2023-07-10","5","2023-07-10 01:18:18");
INSERT INTO tbl_recvoucher VALUES("1190","0","REV100723102","","120000.00","2023-07-10","5","2023-07-10 01:37:24");
INSERT INTO tbl_recvoucher VALUES("1191","0","REV100723103","","50000.00","2023-07-10","5","2023-07-10 01:56:31");
INSERT INTO tbl_recvoucher VALUES("1192","0","REV100723104","","600000.00","2023-07-10","5","2023-07-10 03:09:27");
INSERT INTO tbl_recvoucher VALUES("1193","0","REV100723105","","89000.00","2023-07-10","5","2023-07-10 03:22:03");
INSERT INTO tbl_recvoucher VALUES("1194","0","REV100723106","","34000.00","2023-07-10","5","2023-07-10 03:51:21");
INSERT INTO tbl_recvoucher VALUES("1195","0","REV100723107","","40000.00","2023-07-10","5","2023-07-10 07:56:04");
INSERT INTO tbl_recvoucher VALUES("1196","0","REV110723101","","400000.00","2023-07-11","5","2023-07-11 12:07:33");
INSERT INTO tbl_recvoucher VALUES("1197","0","REV120723101","","31000.00","2023-07-12","5","2023-07-12 12:17:06");
INSERT INTO tbl_recvoucher VALUES("1198","0","REV120723102","","200000.00","2023-07-12","5","2023-07-12 02:55:26");
INSERT INTO tbl_recvoucher VALUES("1199","0","REV120723103","","35000.00","2023-07-12","5","2023-07-12 07:43:55");
INSERT INTO tbl_recvoucher VALUES("1200","0","REV120723104","","19800.00","2023-07-12","5","2023-07-12 07:47:48");
INSERT INTO tbl_recvoucher VALUES("1201","0","REV140723101","","29500.00","2023-07-14","5","2023-07-14 10:58:57");
INSERT INTO tbl_recvoucher VALUES("1202","0","REV140723102","","23500.00","2023-07-14","5","2023-07-14 12:49:42");
INSERT INTO tbl_recvoucher VALUES("1203","0","REV140723103","","52000.00","2023-07-14","5","2023-07-14 07:01:38");
INSERT INTO tbl_recvoucher VALUES("1204","0","REV140723104","","100000.00","2023-07-14","5","2023-07-14 07:19:36");
INSERT INTO tbl_recvoucher VALUES("1205","0","REV140723105","","100000.00","2023-07-14","5","2023-07-14 07:40:07");
INSERT INTO tbl_recvoucher VALUES("1206","0","REV140723106","","50000.00","2023-07-14","5","2023-07-14 08:17:29");
INSERT INTO tbl_recvoucher VALUES("1207","0","REV150723101","","197000.00","2023-07-15","5","2023-07-15 01:23:25");
INSERT INTO tbl_recvoucher VALUES("1208","0","REV150723102","","30000.00","2023-07-15","5","2023-07-15 11:36:31");
INSERT INTO tbl_recvoucher VALUES("1209","0","REV160723101","","25000.00","2023-07-16","5","2023-07-16 05:56:04");
INSERT INTO tbl_recvoucher VALUES("1210","0","REV160723102","","50000.00","2023-07-16","5","2023-07-16 06:45:08");
INSERT INTO tbl_recvoucher VALUES("1211","0","REV160723103","","50000.00","2023-07-16","5","2023-07-16 06:45:29");
INSERT INTO tbl_recvoucher VALUES("1212","0","REV160723104","","17000.00","2023-07-16","5","2023-07-16 06:54:05");
INSERT INTO tbl_recvoucher VALUES("1213","0","REV170723101","","40000.00","2023-07-17","5","2023-07-17 12:15:24");
INSERT INTO tbl_recvoucher VALUES("1214","0","REV170723102","","100000.00","2023-07-17","5","2023-07-17 02:55:38");
INSERT INTO tbl_recvoucher VALUES("1215","0","REV170723103","","200000.00","2023-07-17","5","2023-07-17 03:55:07");
INSERT INTO tbl_recvoucher VALUES("1216","0","REV170723104","","100000.00","2023-07-17","5","2023-07-17 06:57:27");
INSERT INTO tbl_recvoucher VALUES("1217","0","REV180723101","","25000.00","2023-07-18","5","2023-07-18 02:21:37");
INSERT INTO tbl_recvoucher VALUES("1218","0","REV180723102","","300000.00","2023-07-17","5","2023-07-18 02:27:54");
INSERT INTO tbl_recvoucher VALUES("1219","0","REV180723103","","40000.00","2023-07-18","5","2023-07-18 02:57:50");
INSERT INTO tbl_recvoucher VALUES("1220","0","REV180723104","","20000.00","2023-07-18","5","2023-07-18 03:39:41");
INSERT INTO tbl_recvoucher VALUES("1221","0","REV180723105","","69500.00","2023-07-18","5","2023-07-18 03:40:43");
INSERT INTO tbl_recvoucher VALUES("1222","0","REV190723101","","35000.00","2023-07-19","5","2023-07-19 07:24:42");
INSERT INTO tbl_recvoucher VALUES("1223","0","REV200723101","","50000.00","2023-07-20","5","2023-07-20 04:57:21");
INSERT INTO tbl_recvoucher VALUES("1224","0","REV210723101","","84900.00","2023-07-21","5","2023-07-21 12:45:07");
INSERT INTO tbl_recvoucher VALUES("1225","0","REV210723102","","100000.00","2023-07-21","5","2023-07-21 12:46:40");
INSERT INTO tbl_recvoucher VALUES("1226","0","REV210723103","","1013000.00","2023-07-21","5","2023-07-21 12:51:05");
INSERT INTO tbl_recvoucher VALUES("1227","0","REV210723104","","73500.00","2023-07-21","5","2023-07-21 01:01:04");
INSERT INTO tbl_recvoucher VALUES("1228","0","REV210723105","","129000.00","2023-07-21","5","2023-07-21 06:12:07");
INSERT INTO tbl_recvoucher VALUES("1229","0","REV230723101","","100000.00","2023-07-23","5","2023-07-23 01:27:46");
INSERT INTO tbl_recvoucher VALUES("1230","0","REV230723102","","26000.00","2023-07-23","5","2023-07-23 01:35:43");
INSERT INTO tbl_recvoucher VALUES("1231","0","REV230723103","","50000.00","2023-07-23","5","2023-07-23 07:43:39");
INSERT INTO tbl_recvoucher VALUES("1232","0","REV230723104","","56000.00","2023-07-23","5","2023-07-23 08:03:41");
INSERT INTO tbl_recvoucher VALUES("1233","0","REV240723101","","100000.00","2023-07-24","5","2023-07-24 02:57:38");
INSERT INTO tbl_recvoucher VALUES("1234","0","REV240723102","","100000.00","2023-07-24","5","2023-07-24 07:09:23");
INSERT INTO tbl_recvoucher VALUES("1235","0","REV260723101","","31000.00","2023-07-26","5","2023-07-26 11:17:03");
INSERT INTO tbl_recvoucher VALUES("1236","0","REV260723102","","100000.00","2023-07-26","5","2023-07-26 03:25:48");
INSERT INTO tbl_recvoucher VALUES("1237","0","REV270723101","","27400.00","2023-07-27","5","2023-07-27 12:28:55");
INSERT INTO tbl_recvoucher VALUES("1238","0","REV270723102","","100000.00","2023-07-27","5","2023-07-27 01:27:05");
INSERT INTO tbl_recvoucher VALUES("1239","0","REV270723103","","100000.00","2023-07-27","5","2023-07-27 05:57:31");
INSERT INTO tbl_recvoucher VALUES("1240","0","REV270723104","","20000.00","2023-07-27","5","2023-07-27 07:29:27");
INSERT INTO tbl_recvoucher VALUES("1243","0","REV280723101","","13000.00","2023-07-28","5","2023-07-28 05:04:21");
INSERT INTO tbl_recvoucher VALUES("1244","0","REV280723102","","100000.00","2023-07-28","5","2023-07-28 06:50:46");
INSERT INTO tbl_recvoucher VALUES("1245","0","REV290723101","","40000.00","2023-07-29","5","2023-07-29 05:35:00");
INSERT INTO tbl_recvoucher VALUES("1246","0","REV300723101","","50000.00","2023-07-30","5","2023-07-30 02:21:40");
INSERT INTO tbl_recvoucher VALUES("1247","0","REV300723102","","34650.00","2023-07-30","5","2023-07-30 06:04:42");
INSERT INTO tbl_recvoucher VALUES("1248","0","REV310723101","","150000.00","2023-07-31","5","2023-07-31 01:56:29");
INSERT INTO tbl_recvoucher VALUES("1249","0","REV310723102","","30000.00","2023-07-31","5","2023-07-31 07:49:28");
INSERT INTO tbl_recvoucher VALUES("1250","0","REV020823101","","75000.00","2023-08-02","5","2023-08-02 01:35:53");
INSERT INTO tbl_recvoucher VALUES("1251","0","REV020823102","","11000.00","2023-08-02","5","2023-08-02 04:59:34");
INSERT INTO tbl_recvoucher VALUES("1252","0","REV020823103","","17000.00","2023-08-02","5","2023-08-02 05:38:05");
INSERT INTO tbl_recvoucher VALUES("1253","0","REV020823104","","1000.00","2023-08-02","5","2023-08-02 05:45:07");
INSERT INTO tbl_recvoucher VALUES("1254","0","REV020823105","","100000.00","2023-08-02","5","2023-08-02 07:40:56");
INSERT INTO tbl_recvoucher VALUES("1255","0","REV030823101","","1000.00","2023-08-03","5","2023-08-03 02:37:53");
INSERT INTO tbl_recvoucher VALUES("1256","0","REV030823102","","131000.00","2023-08-03","5","2023-08-03 03:37:50");
INSERT INTO tbl_recvoucher VALUES("1257","0","REV030823103","","50000.00","2023-08-03","5","2023-08-03 04:08:08");
INSERT INTO tbl_recvoucher VALUES("1258","0","REV030823104","","100000.00","2023-08-03","5","2023-08-03 04:08:36");
INSERT INTO tbl_recvoucher VALUES("1259","0","REV030823105","","10000.00","2023-08-03","5","2023-08-03 07:48:05");
INSERT INTO tbl_recvoucher VALUES("1260","0","REV040823101","","74000.00","2023-08-04","5","2023-08-04 11:37:13");
INSERT INTO tbl_recvoucher VALUES("1261","0","REV040823102","","45000.00","2023-08-04","5","2023-08-04 03:12:24");
INSERT INTO tbl_recvoucher VALUES("1262","0","REV040823103","","30000.00","2023-08-04","5","2023-08-04 06:30:51");
INSERT INTO tbl_recvoucher VALUES("1263","0","REV050823101","","13500.00","2023-08-05","5","2023-08-05 11:54:35");
INSERT INTO tbl_recvoucher VALUES("1264","0","REV050823102","","100000.00","2023-08-05","5","2023-08-05 04:10:21");
INSERT INTO tbl_recvoucher VALUES("1265","0","REV060823101","","12000.00","2023-08-06","5","2023-08-06 02:08:45");
INSERT INTO tbl_recvoucher VALUES("1266","0","REV060823102","","78000.00","2023-08-06","5","2023-08-06 04:52:48");
INSERT INTO tbl_recvoucher VALUES("1267","0","REV070823101","","30000.00","2023-08-07","5","2023-08-07 11:36:03");
INSERT INTO tbl_recvoucher VALUES("1268","0","REV070823102","","130000.00","2023-08-07","5","2023-08-07 11:40:52");
INSERT INTO tbl_recvoucher VALUES("1269","0","REV090823101","","28500.00","2023-08-09","5","2023-08-09 12:35:27");
INSERT INTO tbl_recvoucher VALUES("1270","0","REV090823102","","50500.00","2023-08-09","5","2023-08-09 01:50:06");
INSERT INTO tbl_recvoucher VALUES("1271","0","REV090823103","","50000.00","2023-08-09","5","2023-08-09 11:59:58");
INSERT INTO tbl_recvoucher VALUES("1272","0","REV100823101","","10000.00","2023-08-09","5","2023-08-10 12:00:37");
INSERT INTO tbl_recvoucher VALUES("1273","0","REV100823102","","30000.00","2023-08-10","5","2023-08-10 12:53:21");
INSERT INTO tbl_recvoucher VALUES("1274","0","REV100823103","","19500.00","2023-08-10","5","2023-08-10 12:58:59");
INSERT INTO tbl_recvoucher VALUES("1275","0","REV100823104","","50000.00","2023-08-10","5","2023-08-10 01:28:00");
INSERT INTO tbl_recvoucher VALUES("1276","0","REV100823105","","19500.00","2023-08-10","5","2023-08-10 07:08:04");
INSERT INTO tbl_recvoucher VALUES("1277","0","REV110823101","","29000.00","2023-08-11","5","2023-08-11 07:46:26");
INSERT INTO tbl_recvoucher VALUES("1278","0","REV120823101","","50000.00","2023-08-12","5","2023-08-12 12:10:30");
INSERT INTO tbl_recvoucher VALUES("1279","0","REV120823102","","26000.00","2023-08-12","5","2023-08-12 02:32:09");
INSERT INTO tbl_recvoucher VALUES("1280","0","REV120823103","","60000.00","2023-08-12","5","2023-08-12 07:34:09");
INSERT INTO tbl_recvoucher VALUES("1281","0","REV120823104","","24000.00","2023-08-12","5","2023-08-12 07:43:42");
INSERT INTO tbl_recvoucher VALUES("1283","0","REV130823101","","2000.00","2023-08-13","5","2023-08-13 01:02:52");
INSERT INTO tbl_recvoucher VALUES("1284","0","REV130823102","","586000.00","2023-08-13","5","2023-08-13 03:31:25");
INSERT INTO tbl_recvoucher VALUES("1285","0","REV130823103","","50000.00","2023-08-13","5","2023-08-13 03:36:53");
INSERT INTO tbl_recvoucher VALUES("1286","0","REV130823104","","40000.00","2023-08-13","5","2023-08-13 04:14:40");
INSERT INTO tbl_recvoucher VALUES("1287","0","REV130823105","","15000.00","2023-08-13","5","2023-08-13 07:48:37");
INSERT INTO tbl_recvoucher VALUES("1288","0","REV140823101","","8500.00","2023-08-14","5","2023-08-14 11:34:30");
INSERT INTO tbl_recvoucher VALUES("1289","0","REV140823102","","16000.00","2023-08-14","5","2023-08-14 01:08:51");
INSERT INTO tbl_recvoucher VALUES("1290","0","REV140823103","","100000.00","2023-08-14","5","2023-08-14 05:29:42");
INSERT INTO tbl_recvoucher VALUES("1291","0","REV150823101","","59000.00","2023-08-15","5","2023-08-15 07:25:09");
INSERT INTO tbl_recvoucher VALUES("1292","0","REV150823102","","400000.00","2023-08-15","5","2023-08-15 08:38:15");
INSERT INTO tbl_recvoucher VALUES("1293","0","REV160823101","","12000.00","2023-08-16","5","2023-08-16 12:30:16");
INSERT INTO tbl_recvoucher VALUES("1294","0","REV160823102","","150000.00","2023-08-16","5","2023-08-16 07:40:04");
INSERT INTO tbl_recvoucher VALUES("1295","0","REV170823101","","20500.00","2023-08-17","5","2023-08-17 11:12:21");
INSERT INTO tbl_recvoucher VALUES("1296","0","REV170823102","","50000.00","2023-08-17","5","2023-08-17 01:04:31");
INSERT INTO tbl_recvoucher VALUES("1297","0","REV170823103","","300000.00","2023-08-17","5","2023-08-17 01:48:21");
INSERT INTO tbl_recvoucher VALUES("1298","0","REV170823104","","25000.00","2023-08-17","5","2023-08-17 03:13:45");
INSERT INTO tbl_recvoucher VALUES("1299","0","REV170823105","","35500.00","2023-08-17","5","2023-08-17 03:17:53");
INSERT INTO tbl_recvoucher VALUES("1300","0","REV170823106","","170000.00","2023-08-17","5","2023-08-17 04:18:29");
INSERT INTO tbl_recvoucher VALUES("1301","0","REV170823107","","19000.00","2023-08-17","5","2023-08-17 05:27:27");
INSERT INTO tbl_recvoucher VALUES("1302","0","REV170823108","","203000.00","2023-08-17","5","2023-08-17 07:35:16");
INSERT INTO tbl_recvoucher VALUES("1303","0","REV180823101","","1611250.00","2023-08-18","5","2023-08-18 02:05:46");
INSERT INTO tbl_recvoucher VALUES("1304","0","REV180823102","","809600.00","2023-08-18","5","2023-08-18 02:08:38");
INSERT INTO tbl_recvoucher VALUES("1305","0","REV180823103","","1000.00","2023-08-18","5","2023-08-18 02:09:21");
INSERT INTO tbl_recvoucher VALUES("1306","0","REV190823101","","14000.00","2023-08-19","5","2023-08-19 11:38:17");
INSERT INTO tbl_recvoucher VALUES("1307","0","REV190823102","","50000.00","2023-08-19","5","2023-08-19 11:53:35");
INSERT INTO tbl_recvoucher VALUES("1308","0","REV200823101","","20000.00","2023-08-20","5","2023-08-20 12:49:35");
INSERT INTO tbl_recvoucher VALUES("1309","0","REV200823102","","52000.00","2023-08-20","5","2023-08-20 01:48:36");
INSERT INTO tbl_recvoucher VALUES("1310","0","REV200823103","","19000.00","2023-08-20","5","2023-08-20 02:54:58");
INSERT INTO tbl_recvoucher VALUES("1311","0","REV200823104","","92000.00","2023-08-20","5","2023-08-20 03:20:39");
INSERT INTO tbl_recvoucher VALUES("1312","0","REV210823101","","19500.00","2023-08-21","5","2023-08-21 07:20:14");
INSERT INTO tbl_recvoucher VALUES("1313","0","REV210823102","","60000.00","2023-08-21","5","2023-08-21 07:47:57");
INSERT INTO tbl_recvoucher VALUES("1314","0","REV220823101","","35000.00","2023-08-22","5","2023-08-22 09:00:31");
INSERT INTO tbl_recvoucher VALUES("1315","0","REV230823101","","33000.00","2023-08-23","5","2023-08-23 01:47:42");
INSERT INTO tbl_recvoucher VALUES("1316","0","REV230823102","","19500.00","2023-08-23","5","2023-08-23 07:47:12");
INSERT INTO tbl_recvoucher VALUES("1317","0","REV230823103","","40000.00","2023-08-23","5","2023-08-23 07:54:28");
INSERT INTO tbl_recvoucher VALUES("1318","0","REV230823104","","35000.00","2023-08-23","5","2023-08-23 07:56:27");
INSERT INTO tbl_recvoucher VALUES("1319","0","REV240823101","","12000.00","2023-08-24","5","2023-08-24 11:48:26");
INSERT INTO tbl_recvoucher VALUES("1320","0","REV240823102","","200000.00","2023-08-24","5","2023-08-24 06:01:22");
INSERT INTO tbl_recvoucher VALUES("1321","0","REV240823103","","20000.00","2023-08-24","5","2023-08-24 07:27:36");
INSERT INTO tbl_recvoucher VALUES("1322","0","REV240823104","","25000.00","2023-08-24","5","2023-08-24 07:53:57");
INSERT INTO tbl_recvoucher VALUES("1323","0","REV240823105","","30000.00","2023-08-24","5","2023-08-24 08:01:18");
INSERT INTO tbl_recvoucher VALUES("1324","0","REV260823101","","48500.00","2023-08-26","5","2023-08-26 12:11:30");
INSERT INTO tbl_recvoucher VALUES("1325","0","REV260823102","","54000.00","2023-08-26","5","2023-08-26 04:39:43");
INSERT INTO tbl_recvoucher VALUES("1326","0","REV260823103","","30000.00","2023-08-26","5","2023-08-26 07:29:14");
INSERT INTO tbl_recvoucher VALUES("1327","0","REV270823101","","100000.00","2023-08-27","5","2023-08-27 11:57:18");
INSERT INTO tbl_recvoucher VALUES("1328","0","REV270823102","","7000.00","2023-08-27","5","2023-08-27 06:20:05");
INSERT INTO tbl_recvoucher VALUES("1329","0","REV280823101","","28000.00","2023-08-28","5","2023-08-28 11:54:13");
INSERT INTO tbl_recvoucher VALUES("1330","0","REV280823102","","6500.00","2023-08-28","5","2023-08-28 05:53:31");
INSERT INTO tbl_recvoucher VALUES("1331","0","REV280823103","Adjust P.","2000.00","2023-08-28","5","2023-08-28 06:20:18");
INSERT INTO tbl_recvoucher VALUES("1332","0","REV280823104","","140000.00","2023-08-28","5","2023-08-28 06:55:43");
INSERT INTO tbl_recvoucher VALUES("1333","0","REV280823105","","3000.00","2023-08-28","5","2023-08-28 07:21:35");
INSERT INTO tbl_recvoucher VALUES("1334","0","REV300823101","","5000.00","2023-08-30","5","2023-08-30 12:26:38");
INSERT INTO tbl_recvoucher VALUES("1335","0","REV310823101","","2500.00","2023-08-31","5","2023-08-31 11:35:09");
INSERT INTO tbl_recvoucher VALUES("1336","0","REV010923101","","9000.00","2023-09-01","5","2023-09-01 03:53:32");
INSERT INTO tbl_recvoucher VALUES("1337","0","REV010923102","","30000.00","2023-09-01","5","2023-09-01 04:59:09");
INSERT INTO tbl_recvoucher VALUES("1338","0","REV020923101","","20000.00","2023-09-02","5","2023-09-02 10:52:20");
INSERT INTO tbl_recvoucher VALUES("1339","0","REV020923102","","50000.00","2023-09-02","5","2023-09-02 05:27:12");
INSERT INTO tbl_recvoucher VALUES("1340","0","REV030923101","","80000.00","2023-09-03","5","2023-09-03 04:03:55");
INSERT INTO tbl_recvoucher VALUES("1341","0","REV030923102","","8000.00","2023-09-03","5","2023-09-03 05:25:09");
INSERT INTO tbl_recvoucher VALUES("1342","0","REV040923101","","30000.00","2023-09-04","5","2023-09-04 11:48:30");
INSERT INTO tbl_recvoucher VALUES("1343","0","REV100923101","","30000.00","2023-09-10","5","2023-09-10 11:10:41");
INSERT INTO tbl_recvoucher VALUES("1344","0","REV110923101","","200000.00","2023-09-11","5","2023-09-11 01:46:55");
INSERT INTO tbl_recvoucher VALUES("1345","0","REV110923102","","20000.00","2023-09-11","5","2023-09-11 12:34:06");
INSERT INTO tbl_recvoucher VALUES("1346","0","REV110923103","","62000.00","2023-09-11","5","2023-09-11 12:38:21");
INSERT INTO tbl_recvoucher VALUES("1348","0","REV160923101","","28000.00","2023-09-16","5","2023-09-16 12:51:09");
INSERT INTO tbl_recvoucher VALUES("1349","0","REV160923102","","90000.00","2023-09-16","5","2023-09-16 01:51:33");
INSERT INTO tbl_recvoucher VALUES("1350","0","REV200923101","","145500.00","2023-09-20","5","2023-09-20 02:55:23");
INSERT INTO tbl_recvoucher VALUES("1351","0","REV210923101","","70000.00","2023-09-21","5","2023-09-21 10:55:12");
INSERT INTO tbl_recvoucher VALUES("1352","0","REV210923102","","33800.00","2023-09-21","5","2023-09-21 11:44:43");
INSERT INTO tbl_recvoucher VALUES("1353","0","REV220923101","","1100000.00","2023-09-22","5","2023-09-22 10:10:41");
INSERT INTO tbl_recvoucher VALUES("1354","0","REV220923102","","6500.00","2023-09-22","5","2023-09-22 10:50:23");
INSERT INTO tbl_recvoucher VALUES("1355","0","REV220923103","","104000.00","2023-09-22","5","2023-09-22 10:52:56");
INSERT INTO tbl_recvoucher VALUES("1356","0","REV220923104","","245000.00","2023-09-22","5","2023-09-22 10:53:33");
INSERT INTO tbl_recvoucher VALUES("1357","0","REV240923101","","34000.00","2023-09-24","5","2023-09-24 12:26:17");
INSERT INTO tbl_recvoucher VALUES("1358","0","REV240923102","","185000.00","2023-09-24","5","2023-09-24 03:45:49");
INSERT INTO tbl_recvoucher VALUES("1359","0","REV240923103","","102000.00","2023-09-24","5","2023-09-24 05:06:06");
INSERT INTO tbl_recvoucher VALUES("1360","0","REV240923104","","600000.00","2023-09-24","5","2023-09-24 06:45:53");
INSERT INTO tbl_recvoucher VALUES("1361","0","REV270923101","","246500.00","2023-09-27","5","2023-09-27 11:00:05");
INSERT INTO tbl_recvoucher VALUES("1362","0","REV280923101","","70000.00","2023-09-28","5","2023-09-28 10:27:16");
INSERT INTO tbl_recvoucher VALUES("1363","0","REV280923102","","15000.00","2023-09-28","5","2023-09-28 06:10:13");
INSERT INTO tbl_recvoucher VALUES("1364","0","REV300923101","","26000.00","2023-09-30","5","2023-09-30 11:42:44");
INSERT INTO tbl_recvoucher VALUES("1365","0","REV300923102","","50000.00","2023-09-30","5","2023-09-30 05:22:31");
INSERT INTO tbl_recvoucher VALUES("1366","0","REV300923103","","12000.00","2023-09-30","5","2023-09-30 07:09:58");
INSERT INTO tbl_recvoucher VALUES("1367","0","REV011023101","","35000.00","2023-10-01","5","2023-10-01 11:03:00");
INSERT INTO tbl_recvoucher VALUES("1368","0","REV011023102","","200000.00","2023-09-11","5","2023-10-01 11:23:34");
INSERT INTO tbl_recvoucher VALUES("1369","0","REV011023103","","100000.00","2023-10-01","5","2023-10-01 06:24:57");
INSERT INTO tbl_recvoucher VALUES("1370","0","REV011023104","","100000.00","2023-10-01","5","2023-10-01 07:14:54");
INSERT INTO tbl_recvoucher VALUES("1371","0","REV021023101","","300000.00","2023-10-02","5","2023-10-02 07:03:05");
INSERT INTO tbl_recvoucher VALUES("1372","0","REV031023101","","9500.00","2023-10-03","5","2023-10-03 12:01:21");
INSERT INTO tbl_recvoucher VALUES("1373","0","REV041023101","","25500.00","2023-10-04","5","2023-10-04 01:40:50");
INSERT INTO tbl_recvoucher VALUES("1374","0","REV041023102","","3100.00","2023-10-04","5","2023-10-04 01:41:18");
INSERT INTO tbl_recvoucher VALUES("1375","0","REV041023103","","100000.00","2023-10-03","5","2023-10-04 02:10:06");
INSERT INTO tbl_recvoucher VALUES("1376","0","REV041023104","","120000.00","2023-10-04","5","2023-10-04 06:54:10");
INSERT INTO tbl_recvoucher VALUES("1377","0","REV041023105","","19000.00","2023-10-04","5","2023-10-04 06:58:59");
INSERT INTO tbl_recvoucher VALUES("1378","0","REV041023106","","37000.00","2023-10-04","5","2023-10-04 07:13:27");
INSERT INTO tbl_recvoucher VALUES("1379","0","REV041023107","","18500.00","2023-10-04","5","2023-10-04 08:05:54");
INSERT INTO tbl_recvoucher VALUES("1380","0","REV041023108","","65000.00","2023-10-04","5","2023-10-04 10:08:06");
INSERT INTO tbl_recvoucher VALUES("1381","0","REV051023101","","19000.00","2023-10-05","5","2023-10-05 03:07:16");
INSERT INTO tbl_recvoucher VALUES("1382","0","REV051023102","","50000.00","2023-10-05","5","2023-10-05 04:26:47");
INSERT INTO tbl_recvoucher VALUES("1383","0","REV061023101","","26000.00","2023-10-06","5","2023-10-06 07:17:41");
INSERT INTO tbl_recvoucher VALUES("1384","0","REV081023101","","10000.00","2023-10-07","5","2023-10-08 11:50:01");
INSERT INTO tbl_recvoucher VALUES("1385","0","REV081023102","","35000.00","2023-10-08","5","2023-10-08 12:27:59");
INSERT INTO tbl_recvoucher VALUES("1386","0","REV091023101","","30000.00","2023-10-09","5","2023-10-09 01:16:49");
INSERT INTO tbl_recvoucher VALUES("1387","0","REV091023102","","40500.00","2023-10-09","5","2023-10-09 07:18:23");
INSERT INTO tbl_recvoucher VALUES("1388","0","REV111023101","","100000.00","2023-10-11","5","2023-10-11 01:49:17");
INSERT INTO tbl_recvoucher VALUES("1389","0","REV111023102","","5000000.00","2023-10-11","5","2023-10-11 01:49:54");
INSERT INTO tbl_recvoucher VALUES("1390","0","REV111023103","","50000.00","2023-10-11","5","2023-10-11 02:59:14");
INSERT INTO tbl_recvoucher VALUES("1391","0","REV111023104","","19000.00","2023-10-11","5","2023-10-11 06:44:32");
INSERT INTO tbl_recvoucher VALUES("1392","0","REV111023105","","40000.00","2023-10-11","5","2023-10-11 07:31:05");
INSERT INTO tbl_recvoucher VALUES("1393","0","REV111023106","","30000.00","2023-10-11","5","2023-10-11 08:08:06");
INSERT INTO tbl_recvoucher VALUES("1394","0","REV121023101","","74000.00","2023-10-12","5","2023-10-12 04:22:07");
INSERT INTO tbl_recvoucher VALUES("1395","0","REV121023102","","19000.00","2023-10-12","5","2023-10-12 04:56:36");
INSERT INTO tbl_recvoucher VALUES("1396","0","REV121023103","","50000.00","2023-10-12","5","2023-10-12 06:03:03");
INSERT INTO tbl_recvoucher VALUES("1397","0","REV131023101","","40000.00","2023-10-13","5","2023-10-13 11:03:37");
INSERT INTO tbl_recvoucher VALUES("1398","0","REV131023102","","10000.00","2023-10-13","5","2023-10-13 04:36:17");
INSERT INTO tbl_recvoucher VALUES("1399","0","REV141023101","","25000.00","2023-10-14","5","2023-10-14 11:05:22");
INSERT INTO tbl_recvoucher VALUES("1400","0","REV141023102","","20000.00","2023-10-14","5","2023-10-14 11:14:08");
INSERT INTO tbl_recvoucher VALUES("1401","0","REV141023103","","90000.00","2023-10-14","5","2023-10-14 06:32:47");
INSERT INTO tbl_recvoucher VALUES("1402","0","REV151023101","","94000.00","2023-10-15","5","2023-10-15 05:33:20");
INSERT INTO tbl_recvoucher VALUES("1403","0","REV161023101","","348000.00","2023-10-16","5","2023-10-16 11:47:35");
INSERT INTO tbl_recvoucher VALUES("1404","0","REV181023101","","50000.00","2023-10-18","5","2023-10-18 01:10:15");
INSERT INTO tbl_recvoucher VALUES("1405","0","REV181023102","","15100.00","2023-10-18","5","2023-10-18 01:10:46");
INSERT INTO tbl_recvoucher VALUES("1406","0","REV181023103","","36000.00","2023-10-18","5","2023-10-18 01:25:36");
INSERT INTO tbl_recvoucher VALUES("1407","0","REV181023104","","25000.00","2023-10-18","5","2023-10-18 02:46:19");
INSERT INTO tbl_recvoucher VALUES("1408","0","REV181023105","","10000.00","2023-10-18","5","2023-10-18 05:30:00");
INSERT INTO tbl_recvoucher VALUES("1409","0","REV181023106","","40000.00","2023-10-18","5","2023-10-18 06:19:01");
INSERT INTO tbl_recvoucher VALUES("1410","0","REV191023101","","50000.00","2023-10-19","5","2023-10-19 02:03:19");
INSERT INTO tbl_recvoucher VALUES("1411","0","REV191023102","","6500.00","2023-10-19","5","2023-10-19 06:01:32");
INSERT INTO tbl_recvoucher VALUES("1412","0","REV211023101","","162500.00","2023-10-21","5","2023-10-21 05:27:41");
INSERT INTO tbl_recvoucher VALUES("1413","0","REV211023102","","30000.00","2023-10-21","5","2023-10-21 05:51:18");
INSERT INTO tbl_recvoucher VALUES("1414","0","REV221023101","","250000.00","2023-10-22","5","2023-10-22 10:52:32");
INSERT INTO tbl_recvoucher VALUES("1415","0","REV231023101","","25500.00","2023-10-23","5","2023-10-23 07:08:53");
INSERT INTO tbl_recvoucher VALUES("1416","0","REV251023101","","50000.00","2023-10-25","5","2023-10-25 11:49:31");
INSERT INTO tbl_recvoucher VALUES("1417","0","REV251023102","","5000.00","2023-10-25","5","2023-10-25 11:50:28");
INSERT INTO tbl_recvoucher VALUES("1418","0","REV251023103","","70000.00","2023-10-25","5","2023-10-25 06:45:17");
INSERT INTO tbl_recvoucher VALUES("1419","0","REV271023101","","10000.00","2023-10-27","5","2023-10-27 12:15:32");
INSERT INTO tbl_recvoucher VALUES("1420","0","REV291023101","","20000.00","2023-10-20","5","2023-10-29 11:40:10");
INSERT INTO tbl_recvoucher VALUES("1421","0","REV291023102","","50000.00","2023-10-29","5","2023-10-29 05:04:58");
INSERT INTO tbl_recvoucher VALUES("1422","0","REV301023101","","10000.00","2023-10-30","5","2023-10-30 11:22:55");
INSERT INTO tbl_recvoucher VALUES("1423","0","REV301023102","","49000.00","2023-10-30","5","2023-10-30 07:48:32");
INSERT INTO tbl_recvoucher VALUES("1424","0","REV011123101","","23500.00","2023-11-01","5","2023-11-01 02:09:09");
INSERT INTO tbl_recvoucher VALUES("1425","0","REV011123102","","11400.00","2023-11-01","5","2023-11-01 02:54:55");
INSERT INTO tbl_recvoucher VALUES("1426","0","REV011123103","","58600.00","2023-11-01","5","2023-11-01 03:32:11");
INSERT INTO tbl_recvoucher VALUES("1427","0","REV011123104","","10000.00","2023-11-01","5","2023-11-01 04:11:24");
INSERT INTO tbl_recvoucher VALUES("1428","0","REV011123105","","19000.00","2023-11-01","5","2023-11-01 07:00:10");
INSERT INTO tbl_recvoucher VALUES("1429","0","REV011123106","","8000.00","2023-11-01","5","2023-11-01 07:08:19");
INSERT INTO tbl_recvoucher VALUES("1430","0","REV021123101","","40000.00","2023-11-02","5","2023-11-02 04:01:37");
INSERT INTO tbl_recvoucher VALUES("1431","0","REV031123101","","98000.00","2023-11-03","5","2023-11-03 11:21:56");
INSERT INTO tbl_recvoucher VALUES("1432","0","REV031123102","","23000.00","2023-11-03","5","2023-11-03 01:06:01");
INSERT INTO tbl_recvoucher VALUES("1433","0","REV041123101","","28000.00","2023-11-04","5","2023-11-04 12:04:48");
INSERT INTO tbl_recvoucher VALUES("1434","0","REV041123102","","6500.00","2023-11-04","5","2023-11-04 04:48:27");
INSERT INTO tbl_recvoucher VALUES("1435","0","REV041123103","","45500.00","2023-11-04","5","2023-11-04 07:13:16");
INSERT INTO tbl_recvoucher VALUES("1436","0","REV051123101","","25000.00","2023-11-05","5","2023-11-05 03:13:34");
INSERT INTO tbl_recvoucher VALUES("1437","0","REV051123102","","3500.00","2023-11-05","5","2023-11-05 03:25:26");
INSERT INTO tbl_recvoucher VALUES("1438","0","REV051123103","","21000.00","2023-11-05","5","2023-11-05 04:47:10");
INSERT INTO tbl_recvoucher VALUES("1439","0","REV061123101","","12500.00","2023-11-06","5","2023-11-06 05:05:29");
INSERT INTO tbl_recvoucher VALUES("1440","0","REV081123101","","250000.00","2023-11-08","5","2023-11-08 04:38:51");
INSERT INTO tbl_recvoucher VALUES("1443","0","REV091123101","","35000.00","2023-11-09","5","2023-11-09 04:55:22");
INSERT INTO tbl_recvoucher VALUES("1444","0","REV101123101","","40000.00","2023-11-10","5","2023-11-10 12:14:31");
INSERT INTO tbl_recvoucher VALUES("1445","0","REV101123102","","108000.00","2023-11-10","5","2023-11-10 07:36:24");
INSERT INTO tbl_recvoucher VALUES("1446","0","REV111123101","","35000.00","2023-11-11","5","2023-11-11 02:50:02");
INSERT INTO tbl_recvoucher VALUES("1447","0","REV121123101","","93500.00","2023-11-12","5","2023-11-12 12:36:45");
INSERT INTO tbl_recvoucher VALUES("1448","0","REV121123102","","140000.00","2023-11-12","5","2023-11-12 05:29:16");
INSERT INTO tbl_recvoucher VALUES("1449","0","REV131123101","","22000.00","2023-11-13","5","2023-11-13 02:48:12");
INSERT INTO tbl_recvoucher VALUES("1450","0","REV171123101","","151500.00","2023-11-17","5","2023-11-17 11:48:59");
INSERT INTO tbl_recvoucher VALUES("1451","0","REV191123101","","69200.00","2023-11-19","5","2023-11-19 01:13:53");
INSERT INTO tbl_recvoucher VALUES("1452","0","REV191123102","","29000.00","2023-11-19","5","2023-11-19 02:33:28");
INSERT INTO tbl_recvoucher VALUES("1453","0","REV191123103","","169000.00","2023-11-19","5","2023-11-19 06:31:03");
INSERT INTO tbl_recvoucher VALUES("1454","0","REV191123104","","10000.00","2023-11-19","5","2023-11-19 07:57:11");
INSERT INTO tbl_recvoucher VALUES("1455","0","REV201123101","","26500.00","2023-11-20","5","2023-11-20 01:18:41");
INSERT INTO tbl_recvoucher VALUES("1456","0","REV201123102","","28000.00","2023-11-20","5","2023-11-20 03:38:31");
INSERT INTO tbl_recvoucher VALUES("1457","0","REV201123103","","190000.00","2023-11-20","5","2023-11-20 07:48:58");
INSERT INTO tbl_recvoucher VALUES("1458","0","REV221123101","","58500.00","2023-11-22","5","2023-11-22 12:06:45");
INSERT INTO tbl_recvoucher VALUES("1459","0","REV221123102","","270000.00","2023-11-22","5","2023-11-22 02:17:16");
INSERT INTO tbl_recvoucher VALUES("1460","0","REV221123103","","30000.00","2023-11-22","5","2023-11-22 07:31:15");
INSERT INTO tbl_recvoucher VALUES("1461","0","REV221123104","","100000.00","2023-11-22","5","2023-11-22 07:51:30");
INSERT INTO tbl_recvoucher VALUES("1463","0","REV231123101","","335000.00","2023-11-23","5","2023-11-23 01:40:35");
INSERT INTO tbl_recvoucher VALUES("1464","0","REV231123102","","170000.00","2023-11-23","5","2023-11-23 04:34:36");
INSERT INTO tbl_recvoucher VALUES("1465","0","REV231123103","","50000.00","2023-11-23","5","2023-11-23 06:36:32");
INSERT INTO tbl_recvoucher VALUES("1466","0","REV241123101","","220000.00","2023-11-24","5","2023-11-24 01:00:29");
INSERT INTO tbl_recvoucher VALUES("1467","0","REV241123102","","20000.00","2023-11-24","5","2023-11-24 01:01:58");
INSERT INTO tbl_recvoucher VALUES("1468","0","REV241123103","","125000.00","2023-11-24","5","2023-11-24 03:06:45");
INSERT INTO tbl_recvoucher VALUES("1469","0","REV241123104","","54000.00","2023-11-24","5","2023-11-24 03:25:58");
INSERT INTO tbl_recvoucher VALUES("1470","0","REV251123101","","1450.00","2023-11-25","5","2023-11-25 04:19:24");
INSERT INTO tbl_recvoucher VALUES("1471","0","REV251123102","","36000.00","2023-11-25","5","2023-11-25 06:34:11");
INSERT INTO tbl_recvoucher VALUES("1472","0","REV261123101","","72000.00","2023-11-26","5","2023-11-26 06:34:18");
INSERT INTO tbl_recvoucher VALUES("1473","0","REV261123102","","28000.00","2023-11-26","5","2023-11-26 06:34:42");
INSERT INTO tbl_recvoucher VALUES("1474","0","REV271123101","","28000.00","2023-11-27","5","2023-11-27 11:21:48");
INSERT INTO tbl_recvoucher VALUES("1475","0","REV281123101","","25000.00","2023-11-28","5","2023-11-28 07:06:45");
INSERT INTO tbl_recvoucher VALUES("1476","0","REV291123101","","196000.00","2023-11-29","5","2023-11-29 03:51:56");
INSERT INTO tbl_recvoucher VALUES("1477","0","REV291123102","","100000.00","2023-11-29","5","2023-11-29 04:36:44");
INSERT INTO tbl_recvoucher VALUES("1478","0","REV301123101","","50000.00","2023-11-30","5","2023-11-30 05:10:21");
INSERT INTO tbl_recvoucher VALUES("1479","0","REV011223101","","179500.00","2023-12-01","5","2023-12-01 12:34:57");
INSERT INTO tbl_recvoucher VALUES("1480","0","REV021223101","","140000.00","2023-12-02","5","2023-12-02 02:29:59");
INSERT INTO tbl_recvoucher VALUES("1481","0","REV031223101","","20000.00","2023-12-03","5","2023-12-03 06:27:20");
INSERT INTO tbl_recvoucher VALUES("1482","0","REV031223102","","17200.00","2023-12-03","5","2023-12-03 02:46:22");
INSERT INTO tbl_recvoucher VALUES("1483","0","REV031223103","","1200.00","2023-12-03","5","2023-12-03 02:47:46");
INSERT INTO tbl_recvoucher VALUES("1484","0","REV031223104","","20000.00","2023-12-03","5","2023-12-03 07:19:26");
INSERT INTO tbl_recvoucher VALUES("1485","0","REV071223101","","84500.00","2023-12-07","5","2023-12-07 01:17:34");
INSERT INTO tbl_recvoucher VALUES("1486","0","REV091223101","","28500.00","2023-12-09","5","2023-12-09 01:17:43");
INSERT INTO tbl_recvoucher VALUES("1487","0","REV101223101","","14500.00","2023-12-10","5","2023-12-10 05:39:04");
INSERT INTO tbl_recvoucher VALUES("1488","0","REV131223101","","84000.00","2023-12-13","5","2023-12-13 05:49:26");
INSERT INTO tbl_recvoucher VALUES("1489","0","REV131223102","","17000.00","2023-12-13","5","2023-12-13 07:31:56");
INSERT INTO tbl_recvoucher VALUES("1490","0","REV131223103","","30000.00","2023-12-13","5","2023-12-13 07:50:14");
INSERT INTO tbl_recvoucher VALUES("1491","0","REV151223101","","20000.00","2023-12-15","5","2023-12-15 06:16:48");
INSERT INTO tbl_recvoucher VALUES("1492","0","REV181223101","","28000.00","2023-12-18","5","2023-12-18 06:43:59");
INSERT INTO tbl_recvoucher VALUES("1493","0","REV211223101","","85300.00","2023-12-21","5","2023-12-21 12:22:44");
INSERT INTO tbl_recvoucher VALUES("1494","0","REV251223101","","30000.00","2023-12-25","5","2023-12-25 04:56:46");
INSERT INTO tbl_recvoucher VALUES("1495","0","REV251223102","","20000.00","2023-12-25","5","2023-12-25 04:57:24");
INSERT INTO tbl_recvoucher VALUES("1496","0","REV281223101","","64000.00","2023-12-28","5","2023-12-28 01:54:05");
INSERT INTO tbl_recvoucher VALUES("1497","0","REV040124101","","33000.00","2024-01-04","5","2024-01-04 04:58:20");
INSERT INTO tbl_recvoucher VALUES("1498","0","REV040124102","","10000.00","2024-01-04","5","2024-01-04 05:59:23");
INSERT INTO tbl_recvoucher VALUES("1499","0","REV050124101","","34300.00","2024-01-05","5","2024-01-05 11:58:04");
INSERT INTO tbl_recvoucher VALUES("1500","0","REV050124102","","4000.00","2024-01-05","5","2024-01-05 12:20:27");
INSERT INTO tbl_recvoucher VALUES("1501","0","REV050124103","","27800.00","2024-01-05","5","2024-01-05 01:13:04");
INSERT INTO tbl_recvoucher VALUES("1502","0","REV050124104","","160000.00","2024-01-05","5","2024-01-05 05:20:43");
INSERT INTO tbl_recvoucher VALUES("1503","0","REV060124101","","28000.00","2024-01-06","5","2024-01-06 12:41:30");
INSERT INTO tbl_recvoucher VALUES("1504","0","REV060124102","","43000.00","2024-01-06","5","2024-01-06 01:03:38");
INSERT INTO tbl_recvoucher VALUES("1505","0","REV100124101","","80000.00","2024-01-10","5","2024-01-10 08:04:37");
INSERT INTO tbl_recvoucher VALUES("1506","0","REV110124101","","30000.00","2024-01-11","5","2024-01-11 07:20:15");
INSERT INTO tbl_recvoucher VALUES("1507","0","REV110124102","","10000.00","2024-01-11","5","2024-01-11 07:29:43");
INSERT INTO tbl_recvoucher VALUES("1508","0","REV120124101","","16800.00","2024-01-12","5","2024-01-12 03:22:34");
INSERT INTO tbl_recvoucher VALUES("1509","0","REV130124101","","56000.00","2024-01-13","5","2024-01-13 06:11:25");
INSERT INTO tbl_recvoucher VALUES("1510","0","REV140124101","","7900.00","2024-01-14","5","2024-01-14 03:12:57");
INSERT INTO tbl_recvoucher VALUES("1511","0","REV140124102","","80000.00","2024-01-14","5","2024-01-14 11:25:27");
INSERT INTO tbl_recvoucher VALUES("1512","0","REV210124101","","47700.00","2024-01-21","5","2024-01-21 05:43:48");
INSERT INTO tbl_recvoucher VALUES("1513","0","REV230124101","","28000.00","2024-01-23","5","2024-01-23 01:55:25");
INSERT INTO tbl_recvoucher VALUES("1514","0","REV240124101","","19700.00","2024-01-24","5","2024-01-24 05:26:01");
INSERT INTO tbl_recvoucher VALUES("1515","0","REV260124101","","13800.00","2024-01-26","5","2024-01-26 02:16:42");
INSERT INTO tbl_recvoucher VALUES("1516","0","REV260124102","","24000.00","2024-01-26","5","2024-01-26 03:08:16");
INSERT INTO tbl_recvoucher VALUES("1517","0","REV270124101","","100000.00","2024-01-27","5","2024-01-27 03:44:24");
INSERT INTO tbl_recvoucher VALUES("1518","0","REV270124102","","4500.00","2024-01-27","5","2024-01-27 04:29:54");
INSERT INTO tbl_recvoucher VALUES("1519","0","REV280124101","","250000.00","2024-01-28","5","2024-01-28 10:39:25");
INSERT INTO tbl_recvoucher VALUES("1520","0","REV280124102","","14000.00","2024-01-28","5","2024-01-28 07:55:36");
INSERT INTO tbl_recvoucher VALUES("1521","0","REV290124101","","200000.00","2024-01-29","5","2024-01-29 04:38:00");
INSERT INTO tbl_recvoucher VALUES("1522","0","REV290124102","","27000.00","2024-01-29","5","2024-01-29 08:02:10");
INSERT INTO tbl_recvoucher VALUES("1523","0","REV290124103","","142500.00","2024-01-29","5","2024-01-29 09:28:07");
INSERT INTO tbl_recvoucher VALUES("1524","0","REV290124104","","120000.00","2024-01-29","5","2024-01-29 09:28:30");
INSERT INTO tbl_recvoucher VALUES("1525","0","REV300124101","","50000.00","2024-01-30","5","2024-01-30 07:21:58");
INSERT INTO tbl_recvoucher VALUES("1526","0","REV300124102","","36000.00","2024-01-30","5","2024-01-30 07:25:16");
INSERT INTO tbl_recvoucher VALUES("1527","0","REV310124101","","10000.00","2024-01-31","5","2024-01-31 02:36:48");
INSERT INTO tbl_recvoucher VALUES("1528","0","REV310124102","","190000.00","2024-01-31","5","2024-01-31 04:16:07");
INSERT INTO tbl_recvoucher VALUES("1529","0","REV310124103","","56000.00","2024-01-31","5","2024-01-31 04:16:55");
INSERT INTO tbl_recvoucher VALUES("1530","0","REV310124104","","3000.00","2024-01-31","5","2024-01-31 04:33:57");
INSERT INTO tbl_recvoucher VALUES("1531","0","REV310124105","","100000.00","2024-01-31","5","2024-01-31 05:44:22");
INSERT INTO tbl_recvoucher VALUES("1532","0","REV310124106","","22500.00","2024-01-31","5","2024-01-31 07:00:42");
INSERT INTO tbl_recvoucher VALUES("1533","0","REV310124107","","15000.00","2024-01-31","5","2024-01-31 11:33:11");
INSERT INTO tbl_recvoucher VALUES("1534","0","REV010224101","","50000.00","2024-02-01","5","2024-02-01 11:58:09");
INSERT INTO tbl_recvoucher VALUES("1535","0","REV010224102","","35000.00","2024-02-01","5","2024-02-01 12:07:58");
INSERT INTO tbl_recvoucher VALUES("1536","0","REV010224103","","32400.00","2024-02-01","5","2024-02-01 12:16:54");
INSERT INTO tbl_recvoucher VALUES("1537","0","REV010224104","","60000.00","2024-02-01","5","2024-02-01 12:37:13");
INSERT INTO tbl_recvoucher VALUES("1538","0","REV010224105","","20000.00","2024-02-01","5","2024-02-01 06:38:16");
INSERT INTO tbl_recvoucher VALUES("1539","0","REV010224106","","22000.00","2024-02-01","5","2024-02-01 07:05:18");
INSERT INTO tbl_recvoucher VALUES("1540","0","REV010224107","","20500.00","2024-02-01","5","2024-02-01 07:07:56");
INSERT INTO tbl_recvoucher VALUES("1541","0","REV020224101","","40000.00","2024-02-02","5","2024-02-02 11:31:15");
INSERT INTO tbl_recvoucher VALUES("1542","0","REV020224102","","8000.00","2024-02-02","5","2024-02-02 11:33:01");
INSERT INTO tbl_recvoucher VALUES("1543","0","REV030224101","","8000.00","2024-02-03","5","2024-02-03 07:09:04");
INSERT INTO tbl_recvoucher VALUES("1544","0","REV040224101","","75000.00","2024-02-04","5","2024-02-04 05:12:06");
INSERT INTO tbl_recvoucher VALUES("1545","0","REV050224101","","104000.00","2024-02-05","5","2024-02-05 05:22:31");
INSERT INTO tbl_recvoucher VALUES("1546","0","REV050224102","","50000.00","2024-02-05","5","2024-02-05 05:59:40");
INSERT INTO tbl_recvoucher VALUES("1547","0","REV060224101","","20000.00","2024-02-06","5","2024-02-06 12:44:54");
INSERT INTO tbl_recvoucher VALUES("1548","0","REV070224101","","28260.00","2024-02-07","5","2024-02-07 12:17:14");
INSERT INTO tbl_recvoucher VALUES("1549","0","REV070224102","","130000.00","2024-02-07","5","2024-02-07 07:13:01");
INSERT INTO tbl_recvoucher VALUES("1550","0","REV070224103","","170000.00","2024-02-05","5","2024-02-07 07:33:54");
INSERT INTO tbl_recvoucher VALUES("1551","0","REV070224104","","300000.00","2024-02-07","5","2024-02-07 07:58:24");
INSERT INTO tbl_recvoucher VALUES("1552","0","REV080224101","","20000.00","2024-02-08","5","2024-02-08 05:55:15");
INSERT INTO tbl_recvoucher VALUES("1553","0","REV080224102","","100000.00","2024-02-08","5","2024-02-08 05:57:13");
INSERT INTO tbl_recvoucher VALUES("1554","0","REV090224101","","80000.00","2024-02-09","5","2024-02-09 12:03:34");
INSERT INTO tbl_recvoucher VALUES("1555","0","REV090224102","","40000.00","2024-02-09","5","2024-02-09 12:11:33");
INSERT INTO tbl_recvoucher VALUES("1556","0","REV090224103","","43000.00","2024-02-09","5","2024-02-09 12:48:47");
INSERT INTO tbl_recvoucher VALUES("1557","0","REV100224101","","12000.00","2024-02-10","5","2024-02-10 12:00:28");
INSERT INTO tbl_recvoucher VALUES("1558","0","REV100224102","","100000.00","2024-02-10","5","2024-02-10 12:28:15");
INSERT INTO tbl_recvoucher VALUES("1559","0","REV100224103","","40000.00","2024-02-10","5","2024-02-10 02:10:24");
INSERT INTO tbl_recvoucher VALUES("1560","0","REV100224104","","60000.00","2024-02-10","5","2024-02-10 04:49:04");
INSERT INTO tbl_recvoucher VALUES("1561","0","REV100224105","","25000.00","2024-02-10","5","2024-02-10 07:55:22");
INSERT INTO tbl_recvoucher VALUES("1562","0","REV110224101","","25000.00","2024-02-11","5","2024-02-11 12:29:30");
INSERT INTO tbl_recvoucher VALUES("1563","0","REV110224102","","150000.00","2024-02-11","5","2024-02-11 06:58:18");
INSERT INTO tbl_recvoucher VALUES("1564","0","REV110224103","","80500.00","2024-02-11","5","2024-02-11 07:17:30");
INSERT INTO tbl_recvoucher VALUES("1565","0","REV110224104","","30000.00","2024-02-11","5","2024-02-11 08:16:17");
INSERT INTO tbl_recvoucher VALUES("1566","0","REV120224101","","30000.00","2024-02-12","5","2024-02-12 02:34:32");
INSERT INTO tbl_recvoucher VALUES("1567","0","REV120224102","","32000.00","2024-02-12","5","2024-02-12 02:45:23");
INSERT INTO tbl_recvoucher VALUES("1568","0","REV120224103","","28000.00","2024-02-12","5","2024-02-12 02:46:06");
INSERT INTO tbl_recvoucher VALUES("1569","0","REV120224104","","50000.00","2024-02-12","5","2024-02-12 05:24:09");
INSERT INTO tbl_recvoucher VALUES("1570","0","REV120224105","","22000.00","2024-02-12","5","2024-02-12 06:31:12");
INSERT INTO tbl_recvoucher VALUES("1571","0","REV120224106","","12000.00","2024-02-12","5","2024-02-12 10:46:35");
INSERT INTO tbl_recvoucher VALUES("1572","0","REV130224101","","56500.00","2024-02-13","5","2024-02-13 08:41:54");
INSERT INTO tbl_recvoucher VALUES("1573","0","REV140224101","","18500.00","2024-02-14","5","2024-02-14 01:09:29");
INSERT INTO tbl_recvoucher VALUES("1574","0","REV140224102","","11000.00","2024-02-14","5","2024-02-14 01:18:45");
INSERT INTO tbl_recvoucher VALUES("1575","0","REV140224103","","28500.00","2024-02-14","5","2024-02-14 02:01:21");
INSERT INTO tbl_recvoucher VALUES("1576","0","REV140224104","","30000.00","2024-02-14","5","2024-02-14 02:07:45");
INSERT INTO tbl_recvoucher VALUES("1577","0","REV140224105","","29000.00","2024-02-14","5","2024-02-14 02:26:38");
INSERT INTO tbl_recvoucher VALUES("1578","0","REV140224106","","40000.00","2024-02-14","5","2024-02-14 07:39:11");
INSERT INTO tbl_recvoucher VALUES("1579","0","REV140224107","","37500.00","2024-02-14","5","2024-02-14 07:55:41");
INSERT INTO tbl_recvoucher VALUES("1580","0","REV150224101","","30000.00","2024-02-15","5","2024-02-15 10:56:02");
INSERT INTO tbl_recvoucher VALUES("1581","0","REV150224102","","19800.00","2024-02-15","5","2024-02-15 12:57:37");
INSERT INTO tbl_recvoucher VALUES("1582","0","REV150224103","","25000.00","2024-02-15","5","2024-02-15 04:18:58");
INSERT INTO tbl_recvoucher VALUES("1583","0","REV150224104","","50000.00","2024-02-15","5","2024-02-15 11:01:32");
INSERT INTO tbl_recvoucher VALUES("1584","0","REV150224105","","15000.00","2024-02-15","5","2024-02-15 11:03:22");
INSERT INTO tbl_recvoucher VALUES("1585","0","REV160224101","","76000.00","2024-02-16","5","2024-02-16 11:36:41");
INSERT INTO tbl_recvoucher VALUES("1586","0","REV160224102","","248100.00","2024-02-16","5","2024-02-16 11:58:08");
INSERT INTO tbl_recvoucher VALUES("1587","0","REV170224101","","20000.00","2024-02-17","5","2024-02-17 01:08:32");
INSERT INTO tbl_recvoucher VALUES("1588","0","REV170224102","","15000.00","2024-02-17","5","2024-02-17 08:06:25");
INSERT INTO tbl_recvoucher VALUES("1589","0","REV170224103","","12000.00","2024-02-17","5","2024-02-17 08:11:10");
INSERT INTO tbl_recvoucher VALUES("1590","0","REV180224101","","100000.00","2024-02-18","5","2024-02-18 01:32:45");
INSERT INTO tbl_recvoucher VALUES("1591","0","REV180224102","","60000.00","2024-02-18","5","2024-02-18 03:05:52");
INSERT INTO tbl_recvoucher VALUES("1592","0","REV180224103","","30000.00","2024-02-18","5","2024-02-18 03:30:34");
INSERT INTO tbl_recvoucher VALUES("1593","0","REV180224104","","55000.00","2024-02-18","5","2024-02-18 03:32:37");
INSERT INTO tbl_recvoucher VALUES("1594","0","REV180224105","","360.00","2024-02-18","5","2024-02-18 04:27:52");
INSERT INTO tbl_recvoucher VALUES("1595","0","REV180224106","","50000.00","2024-02-18","5","2024-02-18 05:03:40");
INSERT INTO tbl_recvoucher VALUES("1596","0","REV180224107","","50000.00","2024-02-18","5","2024-02-18 06:59:02");
INSERT INTO tbl_recvoucher VALUES("1597","0","REV180224108","","100000.00","2024-02-18","5","2024-02-18 11:42:09");
INSERT INTO tbl_recvoucher VALUES("1598","0","REV190224101","","15000.00","2024-02-19","5","2024-02-19 12:36:54");
INSERT INTO tbl_recvoucher VALUES("1599","0","REV190224102","","90000.00","2024-02-19","5","2024-02-19 04:02:40");
INSERT INTO tbl_recvoucher VALUES("1600","0","REV190224103","","29000.00","2024-02-19","5","2024-02-19 07:17:10");
INSERT INTO tbl_recvoucher VALUES("1601","0","REV200224101","","100000.00","2024-02-19","5","2024-02-20 10:40:10");
INSERT INTO tbl_recvoucher VALUES("1602","0","REV200224102","","19000.00","2024-02-20","5","2024-02-20 10:32:19");
INSERT INTO tbl_recvoucher VALUES("1603","0","REV220224101","","1500.00","2024-02-22","5","2024-02-22 05:39:37");
INSERT INTO tbl_recvoucher VALUES("1604","0","REV220224102","","50000.00","2024-02-22","5","2024-02-22 06:55:55");
INSERT INTO tbl_recvoucher VALUES("1605","0","REV220224103","","30000.00","2024-02-22","5","2024-02-22 07:02:53");
INSERT INTO tbl_recvoucher VALUES("1606","0","REV230224101","","251100.00","2024-02-23","5","2024-02-23 03:26:39");
INSERT INTO tbl_recvoucher VALUES("1607","0","REV240224101","","61500.00","2024-02-24","5","2024-02-24 01:07:36");
INSERT INTO tbl_recvoucher VALUES("1608","0","REV240224102","","290000.00","2024-02-24","5","2024-02-24 01:08:11");
INSERT INTO tbl_recvoucher VALUES("1609","0","REV250224101","","6000.00","2024-02-25","5","2024-02-25 06:04:30");
INSERT INTO tbl_recvoucher VALUES("1610","0","REV250224102","","8000.00","2024-02-25","5","2024-02-25 07:14:23");
INSERT INTO tbl_recvoucher VALUES("1611","0","REV250224103","","10000.00","2024-02-25","5","2024-02-25 07:18:36");
INSERT INTO tbl_recvoucher VALUES("1612","0","REV270224101","","49500.00","2024-02-27","5","2024-02-27 08:20:45");
INSERT INTO tbl_recvoucher VALUES("1613","0","REV270224102","","178600.00","2024-02-27","5","2024-02-27 08:23:36");
INSERT INTO tbl_recvoucher VALUES("1614","0","REV280224101","","5000.00","2024-02-28","5","2024-02-28 02:59:34");
INSERT INTO tbl_recvoucher VALUES("1615","0","REV010324101","","12500.00","2024-03-01","5","2024-03-01 12:04:14");
INSERT INTO tbl_recvoucher VALUES("1616","0","REV010324102","","120000.00","2024-03-01","5","2024-03-01 12:38:14");
INSERT INTO tbl_recvoucher VALUES("1617","0","REV010324103","","200000.00","2024-02-28","5","2024-03-01 03:28:03");
INSERT INTO tbl_recvoucher VALUES("1618","0","REV010324104","","20000.00","2024-03-01","5","2024-03-01 04:03:37");
INSERT INTO tbl_recvoucher VALUES("1619","0","REV010324105","","137000.00","2024-03-01","5","2024-03-01 04:04:29");
INSERT INTO tbl_recvoucher VALUES("1620","0","REV010324106","","20000.00","2024-03-01","5","2024-03-01 06:45:09");
INSERT INTO tbl_recvoucher VALUES("1621","0","REV010324107","","19000.00","2024-03-01","5","2024-03-01 07:11:44");
INSERT INTO tbl_recvoucher VALUES("1622","0","REV010324108","","516100.00","2024-03-01","5","2024-03-01 07:49:35");
INSERT INTO tbl_recvoucher VALUES("1623","0","REV020324101","","100000.00","2024-03-02","5","2024-03-02 02:18:48");
INSERT INTO tbl_recvoucher VALUES("1624","0","REV020324102","","26500.00","2024-03-02","5","2024-03-02 07:34:38");
INSERT INTO tbl_recvoucher VALUES("1625","0","REV020324103","","170000.00","2024-03-02","5","2024-03-02 08:02:17");
INSERT INTO tbl_recvoucher VALUES("1626","0","REV020324104","","12600.00","2024-03-02","5","2024-03-02 11:00:32");
INSERT INTO tbl_recvoucher VALUES("1627","0","REV030324101","","20000.00","2024-03-03","5","2024-03-03 12:34:36");
INSERT INTO tbl_recvoucher VALUES("1628","0","REV030324102","","150000.00","2024-03-03","5","2024-03-03 05:37:56");
INSERT INTO tbl_recvoucher VALUES("1629","0","REV040324101","30-k City\n88k-Brac","118000.00","2024-03-04","5","2024-03-04 01:57:47");
INSERT INTO tbl_recvoucher VALUES("1630","0","REV040324102","","20000.00","2024-03-04","5","2024-03-04 07:17:14");
INSERT INTO tbl_recvoucher VALUES("1631","0","REV070324101","","15000.00","2024-03-07","5","2024-03-07 08:52:18");
INSERT INTO tbl_recvoucher VALUES("1632","0","REV070324102","city joma","10000.00","2024-03-07","5","2024-03-07 04:08:35");
INSERT INTO tbl_recvoucher VALUES("1633","0","REV070324103","","7000.00","2024-03-07","5","2024-03-07 06:30:32");
INSERT INTO tbl_recvoucher VALUES("1634","0","REV080324101","","100000.00","2024-03-08","5","2024-03-08 11:00:05");
INSERT INTO tbl_recvoucher VALUES("1635","0","REV080324102","Adjusted 2000 tk","52000.00","2024-03-08","5","2024-03-08 05:26:53");
INSERT INTO tbl_recvoucher VALUES("1636","0","REV080324103","","34000.00","2024-03-08","5","2024-03-08 05:39:04");
INSERT INTO tbl_recvoucher VALUES("1637","0","REV090324101","","70000.00","2024-03-09","5","2024-03-09 10:41:28");
INSERT INTO tbl_recvoucher VALUES("1638","0","REV090324102","","5000.00","2024-03-09","5","2024-03-09 10:50:10");
INSERT INTO tbl_recvoucher VALUES("1639","0","REV100324101","","70000.00","2024-03-10","5","2024-03-10 11:06:10");
INSERT INTO tbl_recvoucher VALUES("1640","0","REV100324102","City Bank Transfer","47000.00","2024-03-10","5","2024-03-10 11:07:28");
INSERT INTO tbl_recvoucher VALUES("1641","0","REV100324103","","70000.00","2024-03-10","5","2024-03-10 11:54:01");
INSERT INTO tbl_recvoucher VALUES("1642","0","REV100324104","","30000.00","2024-03-10","5","2024-03-10 01:18:38");
INSERT INTO tbl_recvoucher VALUES("1643","0","REV100324105","","30000.00","2024-03-10","5","2024-03-10 07:27:42");
INSERT INTO tbl_recvoucher VALUES("1644","0","REV110324101","","180000.00","2024-03-11","5","2024-03-11 12:47:00");
INSERT INTO tbl_recvoucher VALUES("1645","0","REV110324102","","19000.00","2024-03-11","5","2024-03-11 05:24:59");
INSERT INTO tbl_recvoucher VALUES("1646","0","REV120324101","","12500.00","2024-03-12","5","2024-03-12 06:33:48");
INSERT INTO tbl_recvoucher VALUES("1647","0","REV130324101","Bank bang joma","150000.00","2024-03-13","5","2024-03-13 11:06:08");
INSERT INTO tbl_recvoucher VALUES("1648","0","REV130324102","","10000.00","2024-03-13","5","2024-03-13 11:20:02");
INSERT INTO tbl_recvoucher VALUES("1649","0","REV130324103","","1000.00","2024-03-13","5","2024-03-13 11:22:05");
INSERT INTO tbl_recvoucher VALUES("1650","0","REV130324104","","57000.00","2024-03-13","5","2024-03-13 01:55:47");
INSERT INTO tbl_recvoucher VALUES("1651","0","REV130324105","","10000.00","2024-03-13","5","2024-03-13 03:15:44");
INSERT INTO tbl_recvoucher VALUES("1652","0","REV130324106","","100000.00","2024-03-13","5","2024-03-13 04:11:20");
INSERT INTO tbl_recvoucher VALUES("1653","0","REV150324101","","20000.00","2024-03-15","5","2024-03-15 11:24:05");
INSERT INTO tbl_recvoucher VALUES("1654","0","REV150324102","","39600.00","2024-03-15","5","2024-03-15 11:25:26");
INSERT INTO tbl_recvoucher VALUES("1655","0","REV160324101","","39600.00","2024-03-16","5","2024-03-16 12:03:23");
INSERT INTO tbl_recvoucher VALUES("1656","0","REV170324101","","70000.00","2024-03-17","5","2024-03-17 12:53:11");
INSERT INTO tbl_recvoucher VALUES("1657","0","REV170324102","","44000.00","2024-03-17","5","2024-03-17 03:40:22");
INSERT INTO tbl_recvoucher VALUES("1658","0","REV170324103","","2000.00","2024-03-17","5","2024-03-17 03:42:39");
INSERT INTO tbl_recvoucher VALUES("1659","0","REV170324104","","20000.00","2024-03-17","5","2024-03-17 04:44:03");
INSERT INTO tbl_recvoucher VALUES("1660","0","REV180324101","","20000.00","2024-03-18","5","2024-03-18 10:43:24");
INSERT INTO tbl_recvoucher VALUES("1661","0","REV180324102","","50000.00","2024-03-18","5","2024-03-18 02:27:48");
INSERT INTO tbl_recvoucher VALUES("1662","0","REV180324103","","23000.00","2024-03-18","5","2024-03-18 02:28:33");
INSERT INTO tbl_recvoucher VALUES("1663","0","REV180324104","","46000.00","2024-03-18","5","2024-03-18 03:29:43");
INSERT INTO tbl_recvoucher VALUES("1664","0","REV180324105","","85000.00","2024-03-18","5","2024-03-18 04:45:47");
INSERT INTO tbl_recvoucher VALUES("1665","0","REV190324101","","85000.00","2024-03-19","5","2024-03-19 08:12:36");
INSERT INTO tbl_recvoucher VALUES("1666","0","REV200324101","","80000.00","2024-03-20","5","2024-03-20 03:04:04");
INSERT INTO tbl_recvoucher VALUES("1667","0","REV200324102","","89000.00","2024-03-20","5","2024-03-20 03:24:14");
INSERT INTO tbl_recvoucher VALUES("1668","0","REV200324103","","30000.00","2024-03-20","5","2024-03-20 05:26:45");
INSERT INTO tbl_recvoucher VALUES("1669","0","REV200324104","","100000.00","2024-03-20","5","2024-03-20 05:41:11");
INSERT INTO tbl_recvoucher VALUES("1670","0","REV200324105","","76000.00","2024-03-20","5","2024-03-20 07:51:48");
INSERT INTO tbl_recvoucher VALUES("1671","0","REV210324101","","50000.00","2024-03-21","5","2024-03-21 01:51:46");
INSERT INTO tbl_recvoucher VALUES("1672","0","REV210324102","","200000.00","2024-03-20","5","2024-03-21 03:37:21");
INSERT INTO tbl_recvoucher VALUES("1673","0","REV210324103","","31000.00","2024-03-21","5","2024-03-21 10:28:58");
INSERT INTO tbl_recvoucher VALUES("1674","0","REV220324101","","39000.00","2024-03-22","5","2024-03-22 02:36:47");
INSERT INTO tbl_recvoucher VALUES("1675","0","REV230324101","","10000.00","2024-03-23","5","2024-03-23 12:23:15");
INSERT INTO tbl_recvoucher VALUES("1676","0","REV230324102","","42000.00","2024-03-23","5","2024-03-23 12:24:58");
INSERT INTO tbl_recvoucher VALUES("1677","0","REV230324103","","17000.00","2024-03-23","5","2024-03-23 01:06:22");
INSERT INTO tbl_recvoucher VALUES("1678","0","REV230324104","","28000.00","2024-03-23","5","2024-03-23 01:06:56");
INSERT INTO tbl_recvoucher VALUES("1679","0","REV230324105","","21500.00","2024-03-23","5","2024-03-23 04:02:55");
INSERT INTO tbl_recvoucher VALUES("1680","0","REV230324106","","100000.00","2024-03-23","5","2024-03-23 04:54:10");
INSERT INTO tbl_recvoucher VALUES("1681","0","REV230324107","","100000.00","2024-03-23","5","2024-03-23 06:03:22");
INSERT INTO tbl_recvoucher VALUES("1682","0","REV230324108","","60000.00","2024-03-23","5","2024-03-23 07:20:42");
INSERT INTO tbl_recvoucher VALUES("1683","0","REV230324109","","80000.00","2024-03-23","5","2024-03-23 07:22:15");
INSERT INTO tbl_recvoucher VALUES("1684","0","REV240324101","","40000.00","2024-03-24","5","2024-03-24 03:33:24");
INSERT INTO tbl_recvoucher VALUES("1685","0","REV240324102","","70000.00","2024-03-24","5","2024-03-24 03:45:11");
INSERT INTO tbl_recvoucher VALUES("1686","0","REV240324103","","90000.00","2024-03-24","5","2024-03-24 06:10:19");
INSERT INTO tbl_recvoucher VALUES("1687","0","REV240324104","","300000.00","2024-03-24","5","2024-03-24 06:10:45");
INSERT INTO tbl_recvoucher VALUES("1688","0","REV250324101","","200000.00","2024-03-25","5","2024-03-25 11:32:20");
INSERT INTO tbl_recvoucher VALUES("1689","0","REV250324102","","1000.00","2024-03-25","5","2024-03-25 02:00:55");
INSERT INTO tbl_recvoucher VALUES("1690","0","REV250324103","","80000.00","2024-03-25","5","2024-03-25 02:36:46");
INSERT INTO tbl_recvoucher VALUES("1691","0","REV250324104","","200000.00","2024-03-25","5","2024-03-25 05:10:08");
INSERT INTO tbl_recvoucher VALUES("1692","0","REV250324105","","45000.00","2024-03-25","5","2024-03-25 07:21:44");
INSERT INTO tbl_recvoucher VALUES("1693","0","REV250324106","","20500.00","2024-03-25","5","2024-03-25 07:22:51");
INSERT INTO tbl_recvoucher VALUES("1694","0","REV250324107","","100000.00","2024-03-25","5","2024-03-25 11:02:27");
INSERT INTO tbl_recvoucher VALUES("1695","0","REV250324108","","20500.00","2024-03-25","5","2024-03-25 11:03:14");
INSERT INTO tbl_recvoucher VALUES("1696","0","REV260324101","","100000.00","2024-03-26","5","2024-03-26 01:16:07");
INSERT INTO tbl_recvoucher VALUES("1697","0","REV260324102","","100000.00","2024-03-26","5","2024-03-26 09:43:56");
INSERT INTO tbl_recvoucher VALUES("1698","0","REV260324103","","50000.00","2024-03-26","5","2024-03-26 05:11:09");
INSERT INTO tbl_recvoucher VALUES("1699","0","REV270324101","","70000.00","2024-03-27","5","2024-03-27 04:08:33");
INSERT INTO tbl_recvoucher VALUES("1700","0","REV270324102","","50000.00","2024-03-27","5","2024-03-27 05:53:41");
INSERT INTO tbl_recvoucher VALUES("1701","0","REV270324103","","45000.00","2024-03-27","5","2024-03-27 05:54:29");
INSERT INTO tbl_recvoucher VALUES("1702","0","REV280324101","","50000.00","2024-03-28","5","2024-03-28 01:40:36");
INSERT INTO tbl_recvoucher VALUES("1703","0","REV280324102","","25500.00","2024-03-28","5","2024-03-28 02:51:04");
INSERT INTO tbl_recvoucher VALUES("1704","0","REV280324103","","50000.00","2024-03-28","5","2024-03-28 03:22:09");
INSERT INTO tbl_recvoucher VALUES("1705","0","REV290324101","","10000.00","2024-03-29","5","2024-03-29 11:10:52");
INSERT INTO tbl_recvoucher VALUES("1706","0","REV290324102","","19700.00","2024-03-29","5","2024-03-29 05:42:08");
INSERT INTO tbl_recvoucher VALUES("1707","0","REV290324103","","70000.00","2024-03-29","5","2024-03-29 10:29:02");
INSERT INTO tbl_recvoucher VALUES("1708","0","REV300324101","","50000.00","2024-03-28","5","2024-03-30 04:08:27");
INSERT INTO tbl_recvoucher VALUES("1709","0","REV300324102","","50000.00","2024-03-30","5","2024-03-30 04:58:32");
INSERT INTO tbl_recvoucher VALUES("1710","0","REV300324103","","250000.00","2024-03-30","5","2024-03-30 07:20:06");
INSERT INTO tbl_recvoucher VALUES("1711","0","REV300324104","","100000.00","2024-03-30","5","2024-03-30 10:40:31");
INSERT INTO tbl_recvoucher VALUES("1712","0","REV300324105","","115000.00","2024-03-30","5","2024-03-30 11:17:05");
INSERT INTO tbl_recvoucher VALUES("1713","0","REV310324101","","140000.00","2024-03-31","5","2024-03-31 01:15:42");
INSERT INTO tbl_recvoucher VALUES("1714","0","REV310324102","","100000.00","2024-03-31","5","2024-03-31 02:01:45");
INSERT INTO tbl_recvoucher VALUES("1715","0","REV310324103","","70000.00","2024-03-31","5","2024-03-31 04:32:22");
INSERT INTO tbl_recvoucher VALUES("1716","0","REV310324104","","42500.00","2024-03-31","5","2024-03-31 07:15:20");
INSERT INTO tbl_recvoucher VALUES("1717","0","REV310324105","","50000.00","2024-03-31","5","2024-03-31 08:11:40");
INSERT INTO tbl_recvoucher VALUES("1718","0","REV010424101","","128000.00","2024-04-01","5","2024-04-01 02:19:17");
INSERT INTO tbl_recvoucher VALUES("1719","0","REV010424102","","35000.00","2024-04-01","5","2024-04-01 05:46:51");
INSERT INTO tbl_recvoucher VALUES("1720","0","REV010424103","","115000.00","2024-04-01","5","2024-04-01 05:47:16");
INSERT INTO tbl_recvoucher VALUES("1721","0","REV010424104","","30000.00","2024-04-01","5","2024-04-01 06:07:57");
INSERT INTO tbl_recvoucher VALUES("1722","0","REV020424101","","59000.00","2024-04-02","5","2024-04-02 12:41:33");
INSERT INTO tbl_recvoucher VALUES("1723","0","REV020424102","","40000.00","2024-04-02","5","2024-04-02 12:52:55");
INSERT INTO tbl_recvoucher VALUES("1724","0","REV020424103","","14000.00","2024-04-02","5","2024-04-02 03:42:34");
INSERT INTO tbl_recvoucher VALUES("1725","0","REV020424104","","30000.00","2024-04-02","5","2024-04-02 06:08:26");
INSERT INTO tbl_recvoucher VALUES("1726","0","REV020424105","","70000.00","2024-04-02","5","2024-04-02 07:29:47");
INSERT INTO tbl_recvoucher VALUES("1727","0","REV030424101","","28000.00","2024-04-03","5","2024-04-03 01:56:15");
INSERT INTO tbl_recvoucher VALUES("1728","0","REV030424102","","95000.00","2024-04-03","5","2024-04-03 03:27:26");
INSERT INTO tbl_recvoucher VALUES("1729","0","REV030424103","","48000.00","2024-04-03","5","2024-04-03 06:58:54");
INSERT INTO tbl_recvoucher VALUES("1730","0","REV030424104","","55000.00","2024-04-03","5","2024-04-03 10:33:30");
INSERT INTO tbl_recvoucher VALUES("1731","0","REV040424101","","13000.00","2024-04-04","5","2024-04-04 02:23:24");
INSERT INTO tbl_recvoucher VALUES("1732","0","REV040424102","","262000.00","2024-04-04","5","2024-04-04 04:40:39");
INSERT INTO tbl_recvoucher VALUES("1733","0","REV040424103","","35000.00","2024-04-04","5","2024-04-04 05:49:11");
INSERT INTO tbl_recvoucher VALUES("1734","0","REV040424104","","21000.00","2024-04-04","5","2024-04-04 07:14:34");
INSERT INTO tbl_recvoucher VALUES("1735","0","REV040424105","","100000.00","2024-04-04","5","2024-04-04 08:19:21");
INSERT INTO tbl_recvoucher VALUES("1736","0","REV050424101","","70000.00","2024-04-05","5","2024-04-05 12:27:34");
INSERT INTO tbl_recvoucher VALUES("1737","0","REV050424102","","6000.00","2024-04-05","5","2024-04-05 12:20:08");
INSERT INTO tbl_recvoucher VALUES("1738","0","REV050424103","","28000.00","2024-04-05","5","2024-04-05 12:40:17");
INSERT INTO tbl_recvoucher VALUES("1739","0","REV050424104","","30000.00","2024-04-05","5","2024-04-05 05:39:05");
INSERT INTO tbl_recvoucher VALUES("1740","0","REV060424101","","20000.00","2024-04-06","5","2024-04-06 10:30:04");
INSERT INTO tbl_recvoucher VALUES("1741","0","REV060424102","","100000.00","2024-04-06","5","2024-04-06 04:07:04");
INSERT INTO tbl_recvoucher VALUES("1742","0","REV060424103","","50000.00","2024-04-06","5","2024-04-06 11:05:38");
INSERT INTO tbl_recvoucher VALUES("1743","0","REV060424104","","30000.00","2024-04-06","5","2024-04-06 11:13:19");
INSERT INTO tbl_recvoucher VALUES("1744","0","REV060424105","","10000.00","2024-04-06","5","2024-04-06 11:14:51");
INSERT INTO tbl_recvoucher VALUES("1745","0","REV080424101","","139500.00","2024-04-08","5","2024-04-08 01:19:37");
INSERT INTO tbl_recvoucher VALUES("1746","0","REV080424102","","20000.00","2024-04-08","5","2024-04-08 02:00:50");
INSERT INTO tbl_recvoucher VALUES("1747","0","REV080424103","","60000.00","2024-04-08","5","2024-04-08 02:33:25");
INSERT INTO tbl_recvoucher VALUES("1748","0","REV080424104","","15000.00","2024-04-08","5","2024-04-08 02:39:48");
INSERT INTO tbl_recvoucher VALUES("1749","0","REV080424105","","100000.00","2024-04-08","5","2024-04-08 04:11:34");
INSERT INTO tbl_recvoucher VALUES("1750","0","REV080424106","","19500.00","2024-04-08","5","2024-04-08 05:27:22");
INSERT INTO tbl_recvoucher VALUES("1751","0","REV090424101","","35500.00","2024-04-09","5","2024-04-09 05:12:00");
INSERT INTO tbl_recvoucher VALUES("1752","0","REV090424102","","10000.00","2024-04-09","5","2024-04-09 05:39:52");
INSERT INTO tbl_recvoucher VALUES("1753","0","REV100424101","","13000.00","2024-04-10","5","2024-04-10 11:06:24");
INSERT INTO tbl_recvoucher VALUES("1754","0","REV100424102","","37000.00","2024-04-10","5","2024-04-10 11:21:14");
INSERT INTO tbl_recvoucher VALUES("1755","0","REV170424101","","100000.00","2024-04-17","5","2024-04-17 06:39:53");
INSERT INTO tbl_recvoucher VALUES("1756","0","REV180424101","","100000.00","2024-04-18","5","2024-04-18 01:38:39");
INSERT INTO tbl_recvoucher VALUES("1757","0","REV180424102","","40500.00","2024-04-18","5","2024-04-18 07:40:46");
INSERT INTO tbl_recvoucher VALUES("1758","0","REV180424103","","27500.00","2024-04-18","5","2024-04-18 08:06:44");
INSERT INTO tbl_recvoucher VALUES("1759","0","REV180424104","","18000.00","2024-04-18","5","2024-04-18 08:07:02");
INSERT INTO tbl_recvoucher VALUES("1760","0","REV180424105","","9400.00","2024-04-18","5","2024-04-18 08:18:55");
INSERT INTO tbl_recvoucher VALUES("1761","0","REV180424106","","3900.00","2024-04-18","5","2024-04-18 08:21:14");
INSERT INTO tbl_recvoucher VALUES("1762","0","REV180424107","","190000.00","2024-04-18","5","2024-04-18 11:07:29");
INSERT INTO tbl_recvoucher VALUES("1763","0","REV180424108","","42000.00","2024-04-18","5","2024-04-18 11:10:20");
INSERT INTO tbl_recvoucher VALUES("1764","0","REV180424109","","69500.00","2024-04-18","5","2024-04-18 11:20:54");
INSERT INTO tbl_recvoucher VALUES("1765","0","REV200424101","","207500.00","2024-04-20","5","2024-04-20 12:58:16");
INSERT INTO tbl_recvoucher VALUES("1766","0","REV200424102","","30000.00","2024-04-20","5","2024-04-20 01:15:37");
INSERT INTO tbl_recvoucher VALUES("1767","0","REV200424103","","100000.00","2024-04-20","5","2024-04-20 01:21:39");
INSERT INTO tbl_recvoucher VALUES("1768","0","REV200424104","","80000.00","2024-04-20","5","2024-04-20 01:26:08");
INSERT INTO tbl_recvoucher VALUES("1769","0","REV200424105","","40000.00","2024-04-20","5","2024-04-20 12:40:38");
INSERT INTO tbl_recvoucher VALUES("1770","0","REV210424101","DBBL","2500.00","2024-04-21","5","2024-04-21 01:27:32");
INSERT INTO tbl_recvoucher VALUES("1771","0","REV210424102","","41000.00","2024-04-21","5","2024-04-21 01:29:07");
INSERT INTO tbl_recvoucher VALUES("1772","0","REV210424103","","150000.00","2024-04-21","5","2024-04-21 03:04:57");
INSERT INTO tbl_recvoucher VALUES("1773","0","REV210424104","","70000.00","2024-04-21","5","2024-04-21 08:12:55");
INSERT INTO tbl_recvoucher VALUES("1774","0","REV220424101","","100000.00","2024-04-22","5","2024-04-22 02:11:23");
INSERT INTO tbl_recvoucher VALUES("1775","0","REV220424102","","50000.00","2024-04-22","5","2024-04-22 02:11:48");
INSERT INTO tbl_recvoucher VALUES("1776","0","REV220424103","","50000.00","2024-04-22","5","2024-04-22 02:12:11");
INSERT INTO tbl_recvoucher VALUES("1777","0","REV220424104","","100000.00","2024-04-22","5","2024-04-22 03:39:13");
INSERT INTO tbl_recvoucher VALUES("1778","0","REV220424105","","80000.00","2024-04-22","5","2024-04-22 06:16:07");
INSERT INTO tbl_recvoucher VALUES("1779","0","REV230424101","","80000.00","2024-04-23","5","2024-04-23 01:17:54");
INSERT INTO tbl_recvoucher VALUES("1780","0","REV230424102","","300000.00","2024-04-23","5","2024-04-23 05:24:33");
INSERT INTO tbl_recvoucher VALUES("1781","0","REV240424101","","30000.00","2024-04-24","5","2024-04-24 02:46:48");
INSERT INTO tbl_recvoucher VALUES("1782","0","REV240424102","","5000.00","2024-04-24","5","2024-04-24 01:19:10");
INSERT INTO tbl_recvoucher VALUES("1784","0","REV240424103","","17500.00","2024-04-24","5","2024-04-24 01:49:08");
INSERT INTO tbl_recvoucher VALUES("1785","0","REV240424104","","33000.00","2024-04-24","5","2024-04-24 01:51:10");
INSERT INTO tbl_recvoucher VALUES("1786","0","REV240424105","","100000.00","2024-04-24","5","2024-04-24 02:26:37");
INSERT INTO tbl_recvoucher VALUES("1787","0","REV240424106","","24500.00","2024-04-24","5","2024-04-24 02:54:48");
INSERT INTO tbl_recvoucher VALUES("1788","0","REV250424101","","100000.00","2024-04-25","5","2024-04-25 04:05:12");
INSERT INTO tbl_recvoucher VALUES("1789","0","REV250424102","","2000.00","2024-04-25","5","2024-04-25 01:09:53");
INSERT INTO tbl_recvoucher VALUES("1790","0","REV250424103","","100000.00","2024-04-25","5","2024-04-25 04:08:57");
INSERT INTO tbl_recvoucher VALUES("1791","0","REV250424104","","45000.00","2024-04-25","5","2024-04-25 04:09:19");
INSERT INTO tbl_recvoucher VALUES("1792","0","REV250424105","","27500.00","2024-04-25","5","2024-04-25 04:11:04");
INSERT INTO tbl_recvoucher VALUES("1793","0","REV250424106","","60000.00","2024-04-25","5","2024-04-25 07:19:32");
INSERT INTO tbl_recvoucher VALUES("1794","0","REV250424107","","42000.00","2024-04-25","5","2024-04-25 07:39:13");
INSERT INTO tbl_recvoucher VALUES("1795","0","REV250424108","","17000.00","2024-04-25","5","2024-04-25 07:47:26");
INSERT INTO tbl_recvoucher VALUES("1796","0","REV250424109","nagad e 13995tk","20000.00","2024-04-25","5","2024-04-25 07:54:24");
INSERT INTO tbl_recvoucher VALUES("1797","0","REV250424110","dbbl","27500.00","2024-04-25","5","2024-04-25 07:55:11");
INSERT INTO tbl_recvoucher VALUES("1798","0","REV250424111","","5500.00","2024-04-25","5","2024-04-25 07:58:02");
INSERT INTO tbl_recvoucher VALUES("1799","0","REV260424101","","100000.00","2024-04-26","5","2024-04-26 12:23:44");
INSERT INTO tbl_recvoucher VALUES("1800","0","REV260424102","","10000.00","2024-04-26","5","2024-04-26 12:44:30");
INSERT INTO tbl_recvoucher VALUES("1801","0","REV260424103","","19500.00","2024-04-26","5","2024-04-26 07:12:13");
INSERT INTO tbl_recvoucher VALUES("1802","0","REV260424104","","50000.00","2024-04-26","5","2024-04-26 08:11:52");
INSERT INTO tbl_recvoucher VALUES("1803","0","REV270424101","","50000.00","2024-04-27","5","2024-04-27 04:34:27");
INSERT INTO tbl_recvoucher VALUES("1804","0","REV270424102","","27500.00","2024-04-27","5","2024-04-27 04:34:49");
INSERT INTO tbl_recvoucher VALUES("1805","0","REV270424103","","75000.00","2024-04-27","5","2024-04-27 05:02:16");
INSERT INTO tbl_recvoucher VALUES("1806","0","REV270424104","","50000.00","2024-04-27","5","2024-04-27 05:02:40");
INSERT INTO tbl_recvoucher VALUES("1807","0","REV270424105","","70000.00","2024-04-27","5","2024-04-27 05:03:07");
INSERT INTO tbl_recvoucher VALUES("1808","0","REV270424106","","15000.00","2024-04-27","5","2024-04-27 08:00:51");
INSERT INTO tbl_recvoucher VALUES("1809","0","REV280424101","","30000.00","2024-04-28","5","2024-04-28 12:33:11");
INSERT INTO tbl_recvoucher VALUES("1810","0","REV280424102","","16000.00","2024-04-28","5","2024-04-28 01:22:04");
INSERT INTO tbl_recvoucher VALUES("1811","0","REV280424103","","369000.00","2024-04-28","5","2024-04-28 03:21:17");
INSERT INTO tbl_recvoucher VALUES("1812","0","REV280424104","","82500.00","2024-04-28","5","2024-04-28 04:41:06");
INSERT INTO tbl_recvoucher VALUES("1813","0","REV280424105","","180000.00","2024-04-28","5","2024-04-28 05:26:18");
INSERT INTO tbl_recvoucher VALUES("1814","0","REV280424106","","40000.00","2024-04-28","5","2024-04-28 05:40:37");
INSERT INTO tbl_recvoucher VALUES("1815","0","REV280424107","","40000.00","2024-04-28","5","2024-04-28 05:51:54");
INSERT INTO tbl_recvoucher VALUES("1816","0","REV280424108","","15000.00","2024-04-28","5","2024-04-28 06:33:44");
INSERT INTO tbl_recvoucher VALUES("1817","0","REV280424109","","37000.00","2024-04-28","5","2024-04-28 06:58:42");
INSERT INTO tbl_recvoucher VALUES("1818","0","REV280424110","","41000.00","2024-04-28","5","2024-04-28 07:24:40");
INSERT INTO tbl_recvoucher VALUES("1819","0","REV280424111","","30000.00","2024-04-28","5","2024-04-28 07:28:13");
INSERT INTO tbl_recvoucher VALUES("1820","0","REV280424112","","50000.00","2024-04-28","5","2024-04-28 08:02:15");
INSERT INTO tbl_recvoucher VALUES("1821","0","REV280424113","","1500.00","2024-04-28","5","2024-04-28 08:06:14");
INSERT INTO tbl_recvoucher VALUES("1822","0","REV290424101","","200000.00","2024-04-29","5","2024-04-29 02:47:08");
INSERT INTO tbl_recvoucher VALUES("1823","0","REV290424102","","26000.00","2024-04-29","5","2024-04-29 06:19:27");
INSERT INTO tbl_recvoucher VALUES("1824","0","REV290424103","","45000.00","2024-04-29","5","2024-04-29 06:33:01");
INSERT INTO tbl_recvoucher VALUES("1825","0","REV290424104","","20000.00","2024-04-29","5","2024-04-29 07:49:52");
INSERT INTO tbl_recvoucher VALUES("1826","0","REV290424105","","50000.00","2024-04-29","5","2024-04-29 09:42:00");
INSERT INTO tbl_recvoucher VALUES("1827","0","REV290424106","","30000.00","2024-04-29","5","2024-04-29 09:42:42");
INSERT INTO tbl_recvoucher VALUES("1828","0","REV290424107","","200000.00","2024-04-29","5","2024-04-29 11:37:13");
INSERT INTO tbl_recvoucher VALUES("1829","0","REV300424101","","300000.00","2024-04-30","5","2024-04-30 12:40:44");
INSERT INTO tbl_recvoucher VALUES("1830","0","REV300424102","","20000.00","2024-04-30","5","2024-04-30 01:41:33");
INSERT INTO tbl_recvoucher VALUES("1831","0","REV300424103","","114500.00","2024-04-30","5","2024-04-30 02:35:13");
INSERT INTO tbl_recvoucher VALUES("1832","0","REV300424104","","100000.00","2024-04-30","5","2024-04-30 03:59:46");
INSERT INTO tbl_recvoucher VALUES("1833","0","REV300424105","","100000.00","2024-04-30","5","2024-04-30 09:06:20");
INSERT INTO tbl_recvoucher VALUES("1834","0","REV300424106","","49000.00","2024-04-30","5","2024-04-30 09:06:56");
INSERT INTO tbl_recvoucher VALUES("1835","0","REV020524101","","40000.00","2024-05-02","5","2024-05-02 12:30:30");
INSERT INTO tbl_recvoucher VALUES("1836","0","REV020524102","","16000.00","2024-05-02","5","2024-05-02 12:57:41");
INSERT INTO tbl_recvoucher VALUES("1837","0","REV020524103","","60000.00","2024-05-02","5","2024-05-02 04:13:36");
INSERT INTO tbl_recvoucher VALUES("1838","0","REV020524104","","50000.00","2024-05-02","5","2024-05-02 04:41:35");
INSERT INTO tbl_recvoucher VALUES("1839","0","REV020524105","","250000.00","2024-05-02","5","2024-05-02 07:26:06");
INSERT INTO tbl_recvoucher VALUES("1840","0","REV020524106","","100000.00","2024-05-02","5","2024-05-02 07:55:41");
INSERT INTO tbl_recvoucher VALUES("1841","0","REV030524101","","225000.00","2024-05-03","5","2024-05-03 08:19:49");
INSERT INTO tbl_recvoucher VALUES("1842","0","REV030524102","","50000.00","2024-05-03","5","2024-05-03 10:14:25");
INSERT INTO tbl_recvoucher VALUES("1843","0","REV030524103","","350000.00","2024-05-03","5","2024-05-03 10:15:24");
INSERT INTO tbl_recvoucher VALUES("1844","0","REV040524101","","150000.00","2024-05-03","5","2024-05-04 11:51:26");
INSERT INTO tbl_recvoucher VALUES("1845","0","REV040524102","","200000.00","2024-05-04","5","2024-05-04 12:17:46");
INSERT INTO tbl_recvoucher VALUES("1846","0","REV040524103","","300000.00","2024-05-04","5","2024-05-04 01:17:47");
INSERT INTO tbl_recvoucher VALUES("1847","0","REV040524104","","194500.00","2024-05-04","5","2024-05-04 01:19:54");
INSERT INTO tbl_recvoucher VALUES("1848","0","REV040524105","","20000.00","2024-05-02","5","2024-05-04 01:39:12");
INSERT INTO tbl_recvoucher VALUES("1849","0","REV040524106","","29500.00","2024-05-04","5","2024-05-04 07:12:10");
INSERT INTO tbl_recvoucher VALUES("1850","0","REV040524107","","40000.00","2024-05-04","5","2024-05-04 07:12:38");
INSERT INTO tbl_recvoucher VALUES("1851","0","REV040524108","","150000.00","2024-05-04","5","2024-05-04 07:33:53");
INSERT INTO tbl_recvoucher VALUES("1852","0","REV040524109","","50000.00","2024-05-04","5","2024-05-04 11:27:21");
INSERT INTO tbl_recvoucher VALUES("1853","0","REV050524101","","20000.00","2024-05-05","5","2024-05-05 12:30:34");
INSERT INTO tbl_recvoucher VALUES("1854","0","REV060524101","","50000.00","2024-05-06","5","2024-05-06 01:15:42");
INSERT INTO tbl_recvoucher VALUES("1855","0","REV060524102","","30000.00","2024-05-02","5","2024-05-06 01:18:54");
INSERT INTO tbl_recvoucher VALUES("1856","0","REV060524103","","100000.00","2024-05-06","5","2024-05-06 01:34:32");
INSERT INTO tbl_recvoucher VALUES("1857","0","REV060524104","","23000.00","2024-05-05","5","2024-05-06 01:40:25");
INSERT INTO tbl_recvoucher VALUES("1858","0","REV060524105","","120000.00","2024-05-06","5","2024-05-06 04:43:35");
INSERT INTO tbl_recvoucher VALUES("1859","0","REV060524106","","39000.00","2024-05-06","5","2024-05-06 06:36:00");
INSERT INTO tbl_recvoucher VALUES("1860","0","REV060524107","","9500.00","2024-05-06","5","2024-05-06 07:13:11");
INSERT INTO tbl_recvoucher VALUES("1861","0","REV060524108","","11000.00","2024-05-06","5","2024-05-06 07:46:38");
INSERT INTO tbl_recvoucher VALUES("1862","0","REV060524109","","32000.00","2024-05-06","5","2024-05-06 08:29:54");
INSERT INTO tbl_recvoucher VALUES("1863","0","REV060524110","","5000.00","2024-05-06","5","2024-05-06 11:53:35");
INSERT INTO tbl_recvoucher VALUES("1864","0","REV070524101","","50000.00","2024-05-07","5","2024-05-07 11:25:08");
INSERT INTO tbl_recvoucher VALUES("1865","0","REV070524102","","16000.00","2024-05-07","5","2024-05-07 12:28:42");
INSERT INTO tbl_recvoucher VALUES("1866","0","REV070524103","","10000.00","2024-05-07","5","2024-05-07 06:32:44");
INSERT INTO tbl_recvoucher VALUES("1867","0","REV070524104","","200000.00","2024-05-07","5","2024-05-07 06:59:53");
INSERT INTO tbl_recvoucher VALUES("1868","0","REV080524101","","50000.00","2024-05-08","5","2024-05-08 12:16:25");
INSERT INTO tbl_recvoucher VALUES("1869","0","REV080524102","","10000.00","2024-05-08","5","2024-05-08 12:18:47");
INSERT INTO tbl_recvoucher VALUES("1870","0","REV080524103","","10000.00","2024-05-08","5","2024-05-08 12:20:13");
INSERT INTO tbl_recvoucher VALUES("1871","0","REV080524104","","3500.00","2024-05-08","5","2024-05-08 12:14:36");
INSERT INTO tbl_recvoucher VALUES("1872","0","REV080524105","","80000.00","2024-05-08","5","2024-05-08 12:52:55");
INSERT INTO tbl_recvoucher VALUES("1873","0","REV080524106","","369500.00","2024-05-08","5","2024-05-08 02:40:07");
INSERT INTO tbl_recvoucher VALUES("1874","0","REV080524107","","60000.00","2024-05-08","5","2024-05-08 04:26:57");
INSERT INTO tbl_recvoucher VALUES("1875","0","REV080524108","","28000.00","2024-05-08","5","2024-05-08 06:37:14");
INSERT INTO tbl_recvoucher VALUES("1876","0","REV080524109","","34000.00","2024-05-08","5","2024-05-08 07:04:26");
INSERT INTO tbl_recvoucher VALUES("1877","0","REV100524101","","100000.00","2024-05-10","5","2024-05-10 12:23:30");
INSERT INTO tbl_recvoucher VALUES("1878","0","REV100524102","","100000.00","2024-05-10","5","2024-05-10 12:23:59");
INSERT INTO tbl_recvoucher VALUES("1879","0","REV100524103","","58500.00","2024-05-10","5","2024-05-10 04:14:05");
INSERT INTO tbl_recvoucher VALUES("1880","0","REV100524104","","18000.00","2024-05-10","5","2024-05-10 06:09:07");
INSERT INTO tbl_recvoucher VALUES("1881","0","REV100524105","","19000.00","2024-05-10","5","2024-05-10 07:53:02");
INSERT INTO tbl_recvoucher VALUES("1882","0","REV100524106","3500TK ADJUST","49000.00","2024-05-10","5","2024-05-10 08:12:16");
INSERT INTO tbl_recvoucher VALUES("1883","0","REV100524107","CASH","12000.00","2024-05-10","5","2024-05-10 08:13:29");
INSERT INTO tbl_recvoucher VALUES("1884","0","REV100524108","CITY","13000.00","2024-05-10","5","2024-05-10 08:17:20");
INSERT INTO tbl_recvoucher VALUES("1885","0","REV100524109","","10000.00","2024-05-10","5","2024-05-10 08:19:12");
INSERT INTO tbl_recvoucher VALUES("1886","0","REV100524110","","20000.00","2024-05-10","5","2024-05-10 08:31:30");
INSERT INTO tbl_recvoucher VALUES("1887","0","REV120524101","","50000.00","2024-05-12","5","2024-05-12 03:56:45");
INSERT INTO tbl_recvoucher VALUES("1888","0","REV120524102","","50000.00","2024-05-12","5","2024-05-12 03:57:18");
INSERT INTO tbl_recvoucher VALUES("1889","0","REV120524103","","20000.00","2024-05-12","5","2024-05-12 11:45:56");
INSERT INTO tbl_recvoucher VALUES("1892","0","REV120524104","DBBL TRF","20000.00","2024-05-12","5","2024-05-12 04:20:04");
INSERT INTO tbl_recvoucher VALUES("1893","0","REV120524105","","20500.00","2024-05-12","5","2024-05-12 07:03:59");
INSERT INTO tbl_recvoucher VALUES("1894","0","REV120524106","SSD 512 Sata Kingspec For Monty","53000.00","2024-05-12","5","2024-05-12 07:35:09");
INSERT INTO tbl_recvoucher VALUES("1895","0","REV120524107","","266000.00","2024-05-12","5","2024-05-12 11:42:25");
INSERT INTO tbl_recvoucher VALUES("1896","0","REV130524101","city bank ","100000.00","2024-05-13","5","2024-05-13 02:26:57");
INSERT INTO tbl_recvoucher VALUES("1897","0","REV130524102","","50000.00","2024-05-13","5","2024-05-13 06:01:16");
INSERT INTO tbl_recvoucher VALUES("1898","0","REV140524101","","70000.00","2024-05-14","5","2024-05-14 03:30:00");
INSERT INTO tbl_recvoucher VALUES("1899","0","REV140524102","","27300.00","2024-05-14","5","2024-05-14 03:52:21");
INSERT INTO tbl_recvoucher VALUES("1900","0","REV150524101","","90000.00","2024-05-15","5","2024-05-15 01:43:17");
INSERT INTO tbl_recvoucher VALUES("1901","0","REV150524102","","50000.00","2024-05-15","5","2024-05-15 07:28:11");
INSERT INTO tbl_recvoucher VALUES("1902","0","REV150524103","","70000.00","2024-05-15","5","2024-05-15 07:36:08");
INSERT INTO tbl_recvoucher VALUES("1903","0","REV150524104","","21500.00","2024-05-15","5","2024-05-15 07:53:05");
INSERT INTO tbl_recvoucher VALUES("1904","0","REV160524101","","50000.00","2024-05-16","5","2024-05-16 02:58:18");
INSERT INTO tbl_recvoucher VALUES("1905","0","REV160524102","","8004400.00","2024-05-16","5","2024-05-16 03:02:20");
INSERT INTO tbl_recvoucher VALUES("1906","0","REV160524103","","50000.00","2024-05-16","5","2024-05-16 02:25:43");
INSERT INTO tbl_recvoucher VALUES("1907","0","REV160524104","","50000.00","2024-05-16","5","2024-05-16 04:52:37");
INSERT INTO tbl_recvoucher VALUES("1908","0","REV160524105","","50000.00","2024-05-16","5","2024-05-16 05:03:50");
INSERT INTO tbl_recvoucher VALUES("1909","0","REV160524106","","45000.00","2024-05-16","5","2024-05-16 05:59:16");
INSERT INTO tbl_recvoucher VALUES("1910","0","REV160524107","","100000.00","2024-05-16","5","2024-05-16 06:16:47");
INSERT INTO tbl_recvoucher VALUES("1911","0","REV160524108","","60000.00","2024-05-16","5","2024-05-16 07:48:52");
INSERT INTO tbl_recvoucher VALUES("1912","0","REV170524101","","60000.00","2024-05-17","5","2024-05-17 12:25:59");
INSERT INTO tbl_recvoucher VALUES("1913","0","REV170524102","City joma (TRF)","55000.00","2024-05-17","5","2024-05-17 04:18:41");
INSERT INTO tbl_recvoucher VALUES("1914","0","REV180524101","","5000.00","2024-05-18","5","2024-05-18 01:52:59");
INSERT INTO tbl_recvoucher VALUES("1915","0","REV180524102","","95000.00","2024-05-18","5","2024-05-18 03:08:36");
INSERT INTO tbl_recvoucher VALUES("1916","0","REV180524103","","70000.00","2024-05-18","5","2024-05-18 06:45:30");
INSERT INTO tbl_recvoucher VALUES("1917","0","REV180524104","","125000.00","2024-05-18","5","2024-05-18 06:45:58");
INSERT INTO tbl_recvoucher VALUES("1918","0","REV180524105","","55000.00","2024-05-18","5","2024-05-18 06:49:15");
INSERT INTO tbl_recvoucher VALUES("1919","0","REV180524106","","80000.00","2024-05-18","5","2024-05-18 10:49:15");
INSERT INTO tbl_recvoucher VALUES("1920","0","REV190524101","","40000.00","2024-05-19","5","2024-05-19 01:34:29");
INSERT INTO tbl_recvoucher VALUES("1921","0","REV190524102","","50000.00","2024-05-19","5","2024-05-19 02:10:42");
INSERT INTO tbl_recvoucher VALUES("1922","0","REV190524103","","35000.00","2024-05-19","5","2024-05-19 02:11:47");
INSERT INTO tbl_recvoucher VALUES("1923","0","REV190524104","","100000.00","2024-05-19","5","2024-05-19 07:21:18");
INSERT INTO tbl_recvoucher VALUES("1924","0","REV190524105","","100000.00","2024-05-19","5","2024-05-19 11:32:21");
INSERT INTO tbl_recvoucher VALUES("1925","0","REV190524106","","100000.00","2024-05-19","5","2024-05-19 11:33:00");
INSERT INTO tbl_recvoucher VALUES("1926","0","REV190524107","","35000.00","2024-05-19","5","2024-05-19 11:33:25");
INSERT INTO tbl_recvoucher VALUES("1927","0","REV200524101","","20000.00","2024-05-20","5","2024-05-20 05:04:01");
INSERT INTO tbl_recvoucher VALUES("1928","0","REV200524102","","80000.00","2024-05-20","5","2024-05-20 05:39:07");
INSERT INTO tbl_recvoucher VALUES("1929","0","REV200524103","","4000.00","2024-05-20","5","2024-05-20 06:23:25");
INSERT INTO tbl_recvoucher VALUES("1930","0","REV200524104","","90000.00","2024-05-20","5","2024-05-20 08:18:33");
INSERT INTO tbl_recvoucher VALUES("1931","0","REV200524105","","70000.00","2024-05-20","5","2024-05-20 11:06:28");
INSERT INTO tbl_recvoucher VALUES("1932","0","REV200524106","","30000.00","2024-05-20","5","2024-05-20 11:19:25");
INSERT INTO tbl_recvoucher VALUES("1933","0","REV220524101","","80000.00","2024-05-22","5","2024-05-22 12:55:33");
INSERT INTO tbl_recvoucher VALUES("1934","0","REV220524102","","40000.00","2024-05-22","5","2024-05-22 08:50:09");
INSERT INTO tbl_recvoucher VALUES("1935","0","REV220524103","","50000.00","2024-05-22","5","2024-05-22 11:21:51");
INSERT INTO tbl_recvoucher VALUES("1936","0","REV220524104","","200000.00","2024-05-22","5","2024-05-22 11:22:24");
INSERT INTO tbl_recvoucher VALUES("1937","0","REV220524105","","40000.00","2024-05-22","5","2024-05-22 11:22:56");
INSERT INTO tbl_recvoucher VALUES("1938","0","REV220524106","","50000.00","2024-05-22","5","2024-05-22 11:23:16");
INSERT INTO tbl_recvoucher VALUES("1939","0","REV230524101","","26500.00","2024-05-23","5","2024-05-23 11:13:51");
INSERT INTO tbl_recvoucher VALUES("1940","0","REV230524102","","40000.00","2024-05-23","5","2024-05-23 03:11:16");
INSERT INTO tbl_recvoucher VALUES("1941","0","REV230524103","","34000.00","2024-05-23","5","2024-05-23 05:26:42");
INSERT INTO tbl_recvoucher VALUES("1942","0","REV230524104","","1500.00","2024-05-23","5","2024-05-23 05:39:58");
INSERT INTO tbl_recvoucher VALUES("1943","0","REV230524105","","26000.00","2024-05-23","5","2024-05-23 06:06:03");
INSERT INTO tbl_recvoucher VALUES("1944","0","REV230524106","","30000.00","2024-05-23","5","2024-05-23 07:33:34");
INSERT INTO tbl_recvoucher VALUES("1945","0","REV240524101","","50000.00","2024-05-24","5","2024-05-24 12:26:44");
INSERT INTO tbl_recvoucher VALUES("1946","0","REV240524102","","40000.00","2024-05-24","5","2024-05-24 12:27:26");
INSERT INTO tbl_recvoucher VALUES("1947","0","REV240524103","","20000.00","2024-05-24","5","2024-05-24 12:28:07");
INSERT INTO tbl_recvoucher VALUES("1948","0","REV250524101","","20000.00","2024-05-25","5","2024-05-25 12:21:10");
INSERT INTO tbl_recvoucher VALUES("1949","0","REV250524102","","50000.00","2024-05-25","5","2024-05-25 01:16:45");
INSERT INTO tbl_recvoucher VALUES("1950","0","REV250524103","","60000.00","2024-05-25","5","2024-05-25 07:31:10");
INSERT INTO tbl_recvoucher VALUES("1951","0","REV250524104","","31000.00","2024-05-25","5","2024-05-25 07:53:23");
INSERT INTO tbl_recvoucher VALUES("1952","0","REV250524105","","10000.00","2024-05-25","5","2024-05-25 08:02:55");
INSERT INTO tbl_recvoucher VALUES("1953","0","REV260524101","","12500.00","2024-05-26","5","2024-05-26 11:46:14");
INSERT INTO tbl_recvoucher VALUES("1954","0","REV260524102","","32000.00","2024-05-26","5","2024-05-26 04:46:04");
INSERT INTO tbl_recvoucher VALUES("1956","0","REV260524104","","25500.00","2024-05-26","5","2024-05-26 08:06:42");
INSERT INTO tbl_recvoucher VALUES("1957","0","REV270524101","","158200.00","2024-05-27","5","2024-05-27 01:14:51");
INSERT INTO tbl_recvoucher VALUES("1958","0","REV270524102","","50000.00","2024-05-27","5","2024-05-27 07:01:35");
INSERT INTO tbl_recvoucher VALUES("1959","0","REV270524103","","50000.00","2024-05-27","5","2024-05-27 07:13:19");
INSERT INTO tbl_recvoucher VALUES("1960","0","REV270524104","","400000.00","2024-05-27","5","2024-05-27 07:24:57");
INSERT INTO tbl_recvoucher VALUES("1961","0","REV280524101","","250000.00","2024-05-28","5","2024-05-28 02:10:00");
INSERT INTO tbl_recvoucher VALUES("1962","0","REV280524102","","1500.00","2024-05-28","5","2024-05-28 02:25:10");
INSERT INTO tbl_recvoucher VALUES("1963","0","REV280524103","","120000.00","2024-05-28","5","2024-05-28 11:06:03");
INSERT INTO tbl_recvoucher VALUES("1964","0","REV280524104","","30000.00","2024-05-28","5","2024-05-28 11:06:27");
INSERT INTO tbl_recvoucher VALUES("1965","0","REV280524105","","27500.00","2024-05-28","5","2024-05-28 11:07:05");
INSERT INTO tbl_recvoucher VALUES("1966","0","REV280524106","","4000.00","2024-05-28","5","2024-05-28 11:07:39");
INSERT INTO tbl_recvoucher VALUES("1967","0","REV290524101","","24000.00","2024-05-29","5","2024-05-29 12:54:38");
INSERT INTO tbl_recvoucher VALUES("1968","0","REV290524102","","10000.00","2024-05-29","5","2024-05-29 07:58:24");
INSERT INTO tbl_recvoucher VALUES("1969","0","REV290524103","","50000.00","2024-05-29","5","2024-05-29 08:18:54");
INSERT INTO tbl_recvoucher VALUES("1970","0","REV300524101","","30000.00","2024-05-29","5","2024-05-30 12:00:36");
INSERT INTO tbl_recvoucher VALUES("1971","0","REV300524102","","15000.00","2024-05-30","5","2024-05-30 12:21:07");
INSERT INTO tbl_recvoucher VALUES("1972","0","REV300524103","","26500.00","2024-05-30","5","2024-05-30 12:27:01");
INSERT INTO tbl_recvoucher VALUES("1973","0","REV300524104","","6000.00","2024-05-30","5","2024-05-30 12:47:05");
INSERT INTO tbl_recvoucher VALUES("1974","0","REV300524105","","13500.00","2024-05-30","5","2024-05-30 04:17:40");
INSERT INTO tbl_recvoucher VALUES("1975","0","REV300524106","","46500.00","2024-05-30","5","2024-05-30 07:39:09");
INSERT INTO tbl_recvoucher VALUES("1976","0","REV310524101","","13000.00","2024-05-31","5","2024-05-31 11:39:35");
INSERT INTO tbl_recvoucher VALUES("1977","0","REV310524102","","43500.00","2024-05-31","5","2024-05-31 11:41:24");
INSERT INTO tbl_recvoucher VALUES("1978","0","REV310524103","","39000.00","2024-05-31","5","2024-05-31 11:51:49");
INSERT INTO tbl_recvoucher VALUES("1979","0","REV310524104","","70700.00","2024-05-31","5","2024-05-31 03:13:53");
INSERT INTO tbl_recvoucher VALUES("1980","0","REV310524105","","100000.00","2024-05-31","5","2024-05-31 03:41:13");
INSERT INTO tbl_recvoucher VALUES("1981","0","REV310524106","","30500.00","2024-05-31","5","2024-05-31 08:04:02");
INSERT INTO tbl_recvoucher VALUES("1982","0","REV310524107","","35000.00","2024-05-31","5","2024-05-31 08:04:21");
INSERT INTO tbl_recvoucher VALUES("1983","0","REV010624101","","150000.00","2024-06-01","5","2024-06-01 12:43:44");
INSERT INTO tbl_recvoucher VALUES("1984","0","REV010624102","","20000.00","2024-06-01","5","2024-06-01 12:44:22");
INSERT INTO tbl_recvoucher VALUES("1985","0","REV010624103","","23000.00","2024-06-01","5","2024-06-01 03:35:28");
INSERT INTO tbl_recvoucher VALUES("1986","0","REV010624104","","48000.00","2024-06-01","5","2024-06-01 05:04:27");
INSERT INTO tbl_recvoucher VALUES("1987","0","REV010624105","","12000.00","2024-06-01","5","2024-06-01 05:08:58");
INSERT INTO tbl_recvoucher VALUES("1988","0","REV010624106","","70000.00","2024-06-01","5","2024-06-01 06:27:55");
INSERT INTO tbl_recvoucher VALUES("1989","0","REV020624101","","130000.00","2024-06-02","5","2024-06-02 01:07:22");
INSERT INTO tbl_recvoucher VALUES("1990","0","REV020624102","","30000.00","2024-06-02","5","2024-06-02 01:07:46");
INSERT INTO tbl_recvoucher VALUES("1991","0","REV020624103","","5000.00","2024-06-02","5","2024-06-02 12:52:02");
INSERT INTO tbl_recvoucher VALUES("1992","0","REV020624104","","30000.00","2024-06-02","5","2024-06-02 01:03:57");
INSERT INTO tbl_recvoucher VALUES("1993","0","REV020624105","","196000.00","2024-06-01","5","2024-06-02 01:10:40");
INSERT INTO tbl_recvoucher VALUES("1994","0","REV020624106","","130000.00","2024-06-02","5","2024-06-02 08:29:42");
INSERT INTO tbl_recvoucher VALUES("1995","0","REV030624101","","300000.00","2024-06-03","5","2024-06-03 12:57:55");
INSERT INTO tbl_recvoucher VALUES("1996","0","REV030624102","","30000.00","2024-06-03","5","2024-06-03 12:58:19");
INSERT INTO tbl_recvoucher VALUES("1997","0","REV030624103","","25000.00","2024-06-03","5","2024-06-03 12:58:45");
INSERT INTO tbl_recvoucher VALUES("1998","0","REV030624104","","100000.00","2024-06-03","5","2024-06-03 11:25:32");
INSERT INTO tbl_recvoucher VALUES("1999","0","REV030624105","","32000.00","2024-06-03","5","2024-06-03 12:28:39");
INSERT INTO tbl_recvoucher VALUES("2000","0","REV030624106","","19500.00","2024-06-03","5","2024-06-03 01:10:35");
INSERT INTO tbl_recvoucher VALUES("2001","0","REV030624107","","19500.00","2024-06-03","5","2024-06-03 02:37:36");
INSERT INTO tbl_recvoucher VALUES("2002","0","REV030624108","","150000.00","2024-06-03","5","2024-06-03 05:20:31");
INSERT INTO tbl_recvoucher VALUES("2003","0","REV030624109","","100000.00","2024-06-03","5","2024-06-03 06:18:10");
INSERT INTO tbl_recvoucher VALUES("2004","0","REV040624101","","60000.00","2024-06-04","5","2024-06-04 11:23:06");
INSERT INTO tbl_recvoucher VALUES("2005","0","REV040624102","","50000.00","2024-06-04","5","2024-06-04 04:45:05");
INSERT INTO tbl_recvoucher VALUES("2006","0","REV050624101","","41500.00","2024-06-05","5","2024-06-05 04:04:03");
INSERT INTO tbl_recvoucher VALUES("2007","0","REV050624102","","6500.00","2024-06-05","5","2024-06-05 06:16:15");
INSERT INTO tbl_recvoucher VALUES("2008","0","REV050624103","","40000.00","2024-06-05","5","2024-06-05 06:20:37");
INSERT INTO tbl_recvoucher VALUES("2009","0","REV050624104","","50000.00","2024-06-05","5","2024-06-05 06:31:34");
INSERT INTO tbl_recvoucher VALUES("2010","0","REV050624105","","10000.00","2024-06-05","5","2024-06-05 08:00:34");
INSERT INTO tbl_recvoucher VALUES("2011","0","REV060624101","","62000.00","2024-06-06","5","2024-06-06 10:45:22");
INSERT INTO tbl_recvoucher VALUES("2012","0","REV060624102","","90000.00","2024-06-06","5","2024-06-06 10:47:35");
INSERT INTO tbl_recvoucher VALUES("2013","0","REV060624103","","10000.00","2024-06-06","5","2024-06-06 11:09:00");
INSERT INTO tbl_recvoucher VALUES("2014","0","REV060624104","","35000.00","2024-06-06","5","2024-06-06 11:17:31");
INSERT INTO tbl_recvoucher VALUES("2015","0","REV060624105","","350000.00","2024-06-06","5","2024-06-06 01:56:33");
INSERT INTO tbl_recvoucher VALUES("2016","0","REV060624106","","70000.00","2024-06-06","5","2024-06-06 06:27:45");
INSERT INTO tbl_recvoucher VALUES("2017","0","REV060624107","","50000.00","2024-06-06","5","2024-06-06 06:28:08");
INSERT INTO tbl_recvoucher VALUES("2018","0","REV060624108","","23000.00","2024-06-06","5","2024-06-06 07:11:36");
INSERT INTO tbl_recvoucher VALUES("2019","0","REV060624109","","11000.00","2024-06-06","5","2024-06-06 07:12:10");
INSERT INTO tbl_recvoucher VALUES("2020","0","REV060624110","","40000.00","2024-06-06","5","2024-06-06 07:29:17");
INSERT INTO tbl_recvoucher VALUES("2021","0","REV060624111","","40000.00","2024-06-06","5","2024-06-06 07:43:50");
INSERT INTO tbl_recvoucher VALUES("2022","0","REV060624112","","23000.00","2024-06-06","5","2024-06-06 07:49:40");
INSERT INTO tbl_recvoucher VALUES("2023","0","REV060624113","","35000.00","2024-06-06","5","2024-06-06 07:56:48");
INSERT INTO tbl_recvoucher VALUES("2024","0","REV060624114","","7500.00","2024-06-06","5","2024-06-06 07:58:34");
INSERT INTO tbl_recvoucher VALUES("2025","0","REV060624115","","48000.00","2024-06-06","5","2024-06-06 08:08:40");
INSERT INTO tbl_recvoucher VALUES("2026","0","REV060624116","","50000.00","2024-06-06","5","2024-06-06 08:22:32");
INSERT INTO tbl_recvoucher VALUES("2027","0","REV060624117","","45000.00","2024-06-06","5","2024-06-06 08:26:07");
INSERT INTO tbl_recvoucher VALUES("2028","0","REV070624101","","30000.00","2024-06-07","5","2024-06-07 01:17:33");
INSERT INTO tbl_recvoucher VALUES("2029","0","REV070624102","","50000.00","2024-06-07","5","2024-06-07 01:17:58");
INSERT INTO tbl_recvoucher VALUES("2030","0","REV070624103","","110000.00","2024-06-07","5","2024-06-07 01:18:23");
INSERT INTO tbl_recvoucher VALUES("2031","0","REV070624104","","35000.00","2024-06-07","5","2024-06-07 01:18:43");
INSERT INTO tbl_recvoucher VALUES("2032","0","REV070624105","ssd 256gb 6pcs ","13200.00","2024-06-07","5","2024-06-07 06:22:53");
INSERT INTO tbl_recvoucher VALUES("2033","0","REV070624106","","40000.00","2024-06-07","5","2024-06-07 10:58:49");
INSERT INTO tbl_recvoucher VALUES("2034","0","REV070624107","","10000.00","2024-06-07","5","2024-06-07 11:01:20");
INSERT INTO tbl_recvoucher VALUES("2035","0","REV090624101","","25000.00","2024-06-09","5","2024-06-09 10:59:19");
INSERT INTO tbl_recvoucher VALUES("2036","0","REV090624102","","27000.00","2024-06-09","5","2024-06-09 10:59:59");
INSERT INTO tbl_recvoucher VALUES("2037","0","REV090624103","","50000.00","2024-06-09","5","2024-06-09 11:00:28");
INSERT INTO tbl_recvoucher VALUES("2038","0","REV090624104","","50000.00","2024-06-09","5","2024-06-09 11:01:01");
INSERT INTO tbl_recvoucher VALUES("2039","0","REV090624105","","50000.00","2024-06-09","5","2024-06-09 11:01:25");
INSERT INTO tbl_recvoucher VALUES("2040","0","REV090624106","","30000.00","2024-06-09","5","2024-06-09 11:01:56");
INSERT INTO tbl_recvoucher VALUES("2041","0","REV090624107","","1500.00","2024-06-09","5","2024-06-09 11:04:32");
INSERT INTO tbl_recvoucher VALUES("2042","0","REV090624108","","118300.00","2024-06-09","5","2024-06-09 04:57:17");
INSERT INTO tbl_recvoucher VALUES("2043","0","REV090624109","","189000.00","2024-06-09","5","2024-06-09 04:58:20");
INSERT INTO tbl_recvoucher VALUES("2044","0","REV090624110","","11500.00","2024-06-09","5","2024-06-09 05:02:26");
INSERT INTO tbl_recvoucher VALUES("2045","0","REV090624111","","151500.00","2024-06-09","5","2024-06-09 05:03:12");
INSERT INTO tbl_recvoucher VALUES("2046","0","REV090624112","","1500.00","2024-06-09","5","2024-06-09 05:50:37");
INSERT INTO tbl_recvoucher VALUES("2047","0","REV090624113","","30000.00","2024-06-09","5","2024-06-09 05:55:00");
INSERT INTO tbl_recvoucher VALUES("2048","0","REV090624114","","10500.00","2024-06-09","5","2024-06-09 07:33:38");
INSERT INTO tbl_recvoucher VALUES("2049","0","REV090624115","","50000.00","2024-06-09","5","2024-06-09 08:20:25");
INSERT INTO tbl_recvoucher VALUES("2050","0","REV090624116","","30000.00","2024-06-09","5","2024-06-09 08:21:53");
INSERT INTO tbl_recvoucher VALUES("2051","0","REV100624101","","100000.00","2024-06-10","5","2024-06-10 01:02:16");
INSERT INTO tbl_recvoucher VALUES("2052","0","REV100624102","","10000.00","2024-06-10","5","2024-06-10 01:33:19");
INSERT INTO tbl_recvoucher VALUES("2053","0","REV100624103","","10000.00","2024-06-10","5","2024-06-10 06:15:45");
INSERT INTO tbl_recvoucher VALUES("2054","0","REV100624104","","39000.00","2024-06-10","5","2024-06-10 11:50:17");
INSERT INTO tbl_recvoucher VALUES("2055","0","REV100624105","","1250000.00","2024-06-10","5","2024-06-10 11:56:07");
INSERT INTO tbl_recvoucher VALUES("2056","0","REV110624101","","125900.00","2024-06-11","5","2024-06-11 11:41:56");
INSERT INTO tbl_recvoucher VALUES("2057","0","REV110624102","","8300.00","2024-06-11","5","2024-06-11 03:26:13");
INSERT INTO tbl_recvoucher VALUES("2058","0","REV110624103","","500000.00","2024-06-11","5","2024-06-11 04:38:26");
INSERT INTO tbl_recvoucher VALUES("2059","0","REV110624104","","1500.00","2024-06-11","5","2024-06-11 04:58:30");
INSERT INTO tbl_recvoucher VALUES("2060","0","REV120624101","","21000.00","2024-06-12","5","2024-06-12 11:15:44");
INSERT INTO tbl_recvoucher VALUES("2061","0","REV120624102","","400000.00","2024-06-12","5","2024-06-12 11:39:12");
INSERT INTO tbl_recvoucher VALUES("2062","0","REV120624103","","3000.00","2024-06-12","5","2024-06-12 02:15:52");
INSERT INTO tbl_recvoucher VALUES("2063","0","REV120624104","","99500.00","2024-06-12","5","2024-06-12 02:24:25");
INSERT INTO tbl_recvoucher VALUES("2064","0","REV120624105","","40000.00","2024-06-12","5","2024-06-12 04:23:24");
INSERT INTO tbl_recvoucher VALUES("2065","0","REV120624106","","30000.00","2024-06-10","5","2024-06-12 05:24:55");
INSERT INTO tbl_recvoucher VALUES("2066","0","REV120624107","","19000.00","2024-06-12","5","2024-06-12 05:51:00");
INSERT INTO tbl_recvoucher VALUES("2067","0","REV120624108","","21700.00","2024-06-12","5","2024-06-12 05:51:24");
INSERT INTO tbl_recvoucher VALUES("2068","0","REV120624109","","29500.00","2024-06-12","5","2024-06-12 07:19:37");
INSERT INTO tbl_recvoucher VALUES("2069","0","REV130624101","","55000.00","2024-06-13","5","2024-06-13 12:48:55");
INSERT INTO tbl_recvoucher VALUES("2070","0","REV130624102","","74500.00","2024-06-13","5","2024-06-13 12:55:01");
INSERT INTO tbl_recvoucher VALUES("2071","0","REV140624101","","30000.00","2024-06-13","5","2024-06-14 10:30:28");
INSERT INTO tbl_recvoucher VALUES("2072","0","REV140624102","","20000.00","2024-06-14","5","2024-06-14 10:31:03");
INSERT INTO tbl_recvoucher VALUES("2073","0","REV140624103","","78000.00","2024-06-14","5","2024-06-14 10:49:02");
INSERT INTO tbl_recvoucher VALUES("2074","0","REV140624104","","23000.00","2024-06-14","5","2024-06-14 12:53:48");
INSERT INTO tbl_recvoucher VALUES("2075","0","REV140624105","","1250.00","2024-06-14","5","2024-06-14 12:54:22");
INSERT INTO tbl_recvoucher VALUES("2076","0","REV140624106","","27000.00","2024-06-14","5","2024-06-14 02:22:33");
INSERT INTO tbl_recvoucher VALUES("2077","0","REV140624107","","35000.00","2024-06-14","5","2024-06-14 03:31:06");
INSERT INTO tbl_recvoucher VALUES("2078","0","REV140624108","","65000.00","2024-06-14","5","2024-06-14 04:47:47");
INSERT INTO tbl_recvoucher VALUES("2079","0","REV140624109","","63500.00","2024-06-14","5","2024-06-14 05:12:03");
INSERT INTO tbl_recvoucher VALUES("2080","0","REV140624110","","27000.00","2024-06-14","5","2024-06-14 07:13:47");
INSERT INTO tbl_recvoucher VALUES("2081","0","REV150624101","","9000.00","2024-06-15","5","2024-06-15 01:38:59");
INSERT INTO tbl_recvoucher VALUES("2082","0","REV180624101","","50000.00","2024-06-16","5","2024-06-18 07:10:46");
INSERT INTO tbl_recvoucher VALUES("2083","0","REV180624102","","70000.00","2024-06-18","5","2024-06-18 07:13:10");
INSERT INTO tbl_recvoucher VALUES("2084","0","REV180624103","","37000.00","2024-06-15","5","2024-06-18 08:29:32");
INSERT INTO tbl_recvoucher VALUES("2085","0","REV190624101","","25000.00","2024-06-13","5","2024-06-19 02:00:52");
INSERT INTO tbl_recvoucher VALUES("2086","0","REV190624102","","50000.00","2024-06-19","5","2024-06-19 02:06:10");
INSERT INTO tbl_recvoucher VALUES("2087","0","REV220624101","","10000.00","2024-06-20","5","2024-06-22 12:17:35");
INSERT INTO tbl_recvoucher VALUES("2088","0","REV230624101","","200000.00","2024-06-23","5","2024-06-23 08:03:52");
INSERT INTO tbl_recvoucher VALUES("2089","0","REV240624101","","92000.00","2024-06-24","5","2024-06-24 07:43:52");
INSERT INTO tbl_recvoucher VALUES("2090","0","REV240624102","","20000.00","2024-06-24","5","2024-06-24 07:46:23");
INSERT INTO tbl_recvoucher VALUES("2091","0","REV240624103","","30000.00","2024-06-24","5","2024-06-24 08:12:41");
INSERT INTO tbl_recvoucher VALUES("2092","0","REV250624101","","60000.00","2024-06-24","5","2024-06-25 12:53:21");
INSERT INTO tbl_recvoucher VALUES("2093","0","REV250624102","","60000.00","2024-06-25","5","2024-06-25 12:55:14");
INSERT INTO tbl_recvoucher VALUES("2094","0","REV250624103","","50000.00","2024-06-25","5","2024-06-25 01:23:09");
INSERT INTO tbl_recvoucher VALUES("2095","0","REV250624104","","90000.00","2024-06-25","5","2024-06-25 01:40:52");
INSERT INTO tbl_recvoucher VALUES("2096","0","REV260624101","","50000.00","2024-06-25","5","2024-06-26 11:01:47");
INSERT INTO tbl_recvoucher VALUES("2097","0","REV260624102","","10000.00","2024-06-25","5","2024-06-26 11:03:00");
INSERT INTO tbl_recvoucher VALUES("2098","0","REV260624103","","48000.00","2024-06-26","5","2024-06-26 11:03:24");
INSERT INTO tbl_recvoucher VALUES("2099","0","REV260624104","","50000.00","2024-06-26","5","2024-06-26 11:04:48");
INSERT INTO tbl_recvoucher VALUES("2100","0","REV260624105","","19500.00","2024-06-26","5","2024-06-26 11:24:09");
INSERT INTO tbl_recvoucher VALUES("2101","0","REV260624106","","52500.00","2024-06-26","5","2024-06-26 11:24:36");
INSERT INTO tbl_recvoucher VALUES("2102","0","REV260624107","","24600.00","2024-06-26","5","2024-06-26 11:25:23");
INSERT INTO tbl_recvoucher VALUES("2103","0","REV260624108","","40000.00","2024-06-26","5","2024-06-26 02:01:48");
INSERT INTO tbl_recvoucher VALUES("2104","0","REV260624109","","60000.00","2024-06-26","5","2024-06-26 05:17:27");
INSERT INTO tbl_recvoucher VALUES("2105","0","REV260624110","","3000.00","2024-06-26","5","2024-06-26 05:18:20");
INSERT INTO tbl_recvoucher VALUES("2106","0","REV260624111","","5000.00","2024-06-26","5","2024-06-26 05:19:20");
INSERT INTO tbl_recvoucher VALUES("2107","0","REV260624112","","30000.00","2024-06-26","5","2024-06-26 05:21:40");
INSERT INTO tbl_recvoucher VALUES("2108","0","REV260624113","","30000.00","2024-06-26","5","2024-06-26 08:10:37");
INSERT INTO tbl_recvoucher VALUES("2109","0","REV270624101","","100000.00","2024-06-27","5","2024-06-27 04:33:18");
INSERT INTO tbl_recvoucher VALUES("2110","0","REV270624102","","80000.00","2024-06-27","5","2024-06-27 05:30:24");
INSERT INTO tbl_recvoucher VALUES("2111","0","REV270624103","","20000.00","2024-06-27","5","2024-06-27 06:34:19");
INSERT INTO tbl_recvoucher VALUES("2112","0","REV270624104","","48500.00","2024-06-27","5","2024-06-27 06:37:16");
INSERT INTO tbl_recvoucher VALUES("2113","0","REV270624105","","50000.00","2024-06-27","5","2024-06-27 06:47:51");
INSERT INTO tbl_recvoucher VALUES("2114","0","REV270624106","","40000.00","2024-06-27","5","2024-06-27 08:12:56");
INSERT INTO tbl_recvoucher VALUES("2115","0","REV270624107","","25000.00","2024-06-27","5","2024-06-27 08:15:35");
INSERT INTO tbl_recvoucher VALUES("2116","0","REV280624101","","75000.00","2024-06-28","5","2024-06-28 05:46:51");
INSERT INTO tbl_recvoucher VALUES("2117","0","REV280624102","","50000.00","2024-06-28","5","2024-06-28 08:10:06");
INSERT INTO tbl_recvoucher VALUES("2118","0","REV290624101","","12000.00","2024-06-29","5","2024-06-29 02:58:01");
INSERT INTO tbl_recvoucher VALUES("2119","0","REV290624102","","19500.00","2024-06-29","5","2024-06-29 03:11:59");
INSERT INTO tbl_recvoucher VALUES("2120","0","REV290624103","","100000.00","2024-06-29","5","2024-06-29 05:29:05");
INSERT INTO tbl_recvoucher VALUES("2121","0","REV290624104","","10000.00","2024-06-28","5","2024-06-29 11:10:40");
INSERT INTO tbl_recvoucher VALUES("2122","0","REV290624105","","10000.00","2024-06-29","5","2024-06-29 11:11:06");
INSERT INTO tbl_recvoucher VALUES("2123","0","REV290624106","","100000.00","2024-06-29","5","2024-06-29 11:11:38");
INSERT INTO tbl_recvoucher VALUES("2124","0","REV290624107","","30000.00","2024-06-29","5","2024-06-29 11:17:26");
INSERT INTO tbl_recvoucher VALUES("2125","0","REV290624108","","100000.00","2024-06-29","5","2024-06-29 11:24:01");
INSERT INTO tbl_recvoucher VALUES("2126","0","REV300624101","","50000.00","2024-06-30","5","2024-06-30 11:50:12");
INSERT INTO tbl_recvoucher VALUES("2127","0","REV300624102","","40000.00","2024-06-28","5","2024-06-30 04:01:46");
INSERT INTO tbl_recvoucher VALUES("2129","0","REV300624104","","130000.00","2024-06-30","5","2024-06-30 04:17:58");
INSERT INTO tbl_recvoucher VALUES("2130","0","REV300624105","","188500.00","2024-06-30","5","2024-06-30 05:49:50");
INSERT INTO tbl_recvoucher VALUES("2131","0","REV300624106","","50000.00","2024-06-30","5","2024-06-30 07:03:51");
INSERT INTO tbl_recvoucher VALUES("2132","0","REV300624107","","40000.00","2024-06-30","5","2024-06-30 07:43:22");
INSERT INTO tbl_recvoucher VALUES("2133","0","REV300624108","","11000.00","2024-06-30","5","2024-06-30 07:48:25");
INSERT INTO tbl_recvoucher VALUES("2134","0","REV300624109","","50000.00","2024-06-30","5","2024-06-30 08:01:45");
INSERT INTO tbl_recvoucher VALUES("2135","0","REV010724101","","10000.00","2024-07-01","5","2024-07-01 11:00:09");
INSERT INTO tbl_recvoucher VALUES("2136","0","REV010724102","","30000.00","2024-07-01","5","2024-07-01 11:00:46");
INSERT INTO tbl_recvoucher VALUES("2137","0","REV010724103","","40000.00","2024-07-01","5","2024-07-01 11:01:10");
INSERT INTO tbl_recvoucher VALUES("2138","0","REV010724104","","100000.00","2024-07-01","5","2024-07-01 03:40:07");
INSERT INTO tbl_recvoucher VALUES("2139","0","REV010724105","","50000.00","2024-07-01","5","2024-07-01 07:52:37");
INSERT INTO tbl_recvoucher VALUES("2140","0","REV010724106","","27000.00","2024-07-01","5","2024-07-01 08:17:10");
INSERT INTO tbl_recvoucher VALUES("2141","0","REV020724101","","6000.00","2024-07-02","5","2024-07-02 12:15:11");
INSERT INTO tbl_recvoucher VALUES("2142","0","REV030724101","","20000.00","2024-07-02","5","2024-07-03 11:20:54");
INSERT INTO tbl_recvoucher VALUES("2143","0","REV030724102","","10000.00","2024-07-03","5","2024-07-03 11:21:27");
INSERT INTO tbl_recvoucher VALUES("2144","0","REV030724103","","10000.00","2024-07-03","5","2024-07-03 11:28:02");
INSERT INTO tbl_recvoucher VALUES("2145","0","REV030724104","","20000.00","2024-07-03","5","2024-07-03 11:52:48");
INSERT INTO tbl_recvoucher VALUES("2146","0","REV030724105","","4000.00","2024-07-03","5","2024-07-03 01:40:04");
INSERT INTO tbl_recvoucher VALUES("2147","0","REV030724106","","43000.00","2024-07-03","5","2024-07-03 02:47:50");
INSERT INTO tbl_recvoucher VALUES("2148","0","REV030724107","","40000.00","2024-07-03","5","2024-07-03 02:52:33");
INSERT INTO tbl_recvoucher VALUES("2149","0","REV030724108","","55000.00","2024-07-03","5","2024-07-03 06:46:22");
INSERT INTO tbl_recvoucher VALUES("2150","0","REV030724109","","100000.00","2024-07-03","5","2024-07-03 06:56:49");
INSERT INTO tbl_recvoucher VALUES("2151","0","REV030724110","","50000.00","2024-07-03","5","2024-07-03 08:00:56");
INSERT INTO tbl_recvoucher VALUES("2152","0","REV030724111","","45000.00","2024-07-03","5","2024-07-03 10:58:50");
INSERT INTO tbl_recvoucher VALUES("2153","0","REV030724112","","100000.00","2024-07-03","5","2024-07-03 10:59:14");
INSERT INTO tbl_recvoucher VALUES("2154","0","REV030724113","","18000.00","2024-07-03","5","2024-07-03 11:26:57");
INSERT INTO tbl_recvoucher VALUES("2156","0","REV030724115","","27000.00","2024-06-30","5","2024-07-03 11:49:41");
INSERT INTO tbl_recvoucher VALUES("2157","0","REV030724116","","13000.00","2024-07-03","5","2024-07-03 11:53:21");
INSERT INTO tbl_recvoucher VALUES("2158","0","REV040724101","","150000.00","2024-07-04","5","2024-07-04 06:12:55");
INSERT INTO tbl_recvoucher VALUES("2159","0","REV040724102","","100000.00","2024-07-04","5","2024-07-04 07:13:58");
INSERT INTO tbl_recvoucher VALUES("2160","0","REV040724103","","5050.00","2024-07-04","5","2024-07-04 07:47:29");
INSERT INTO tbl_recvoucher VALUES("2161","0","REV040724104","","5000.00","2024-07-04","5","2024-07-04 08:08:05");
INSERT INTO tbl_recvoucher VALUES("2162","0","REV040724105","","20600.00","2024-07-04","5","2024-07-04 08:08:45");
INSERT INTO tbl_recvoucher VALUES("2163","0","REV050724101","","35000.00","2024-07-05","5","2024-07-05 12:23:01");
INSERT INTO tbl_recvoucher VALUES("2164","0","REV050724102","","19500.00","2024-07-05","5","2024-07-05 02:47:35");
INSERT INTO tbl_recvoucher VALUES("2165","0","REV050724103","","30000.00","2024-07-05","5","2024-07-05 06:02:53");
INSERT INTO tbl_recvoucher VALUES("2166","0","REV050724104","","45000.00","2024-07-05","5","2024-07-05 08:30:25");
INSERT INTO tbl_recvoucher VALUES("2167","0","REV050724105","","100000.00","2024-07-05","5","2024-07-05 08:39:10");
INSERT INTO tbl_recvoucher VALUES("2168","0","REV050724106","","30000.00","2024-07-05","5","2024-07-05 08:53:10");
INSERT INTO tbl_recvoucher VALUES("2169","0","REV050724107","","50000.00","2024-07-05","5","2024-07-05 10:40:32");
INSERT INTO tbl_recvoucher VALUES("2170","0","REV060724101","","500.00","2024-07-06","5","2024-07-06 11:20:55");
INSERT INTO tbl_recvoucher VALUES("2171","0","REV060724102","","10000.00","2024-07-06","5","2024-07-06 05:18:56");
INSERT INTO tbl_recvoucher VALUES("2172","0","REV060724103","","8500.00","2024-07-06","5","2024-07-06 06:02:25");
INSERT INTO tbl_recvoucher VALUES("2173","0","REV060724104","","19000.00","2024-07-06","5","2024-07-06 06:04:52");
INSERT INTO tbl_recvoucher VALUES("2174","0","REV060724105","","19500.00","2024-07-06","5","2024-07-06 06:11:29");
INSERT INTO tbl_recvoucher VALUES("2175","0","REV060724106","","52000.00","2024-07-06","5","2024-07-06 06:14:50");
INSERT INTO tbl_recvoucher VALUES("2176","0","REV060724107","","50000.00","2024-07-06","5","2024-07-06 06:15:12");
INSERT INTO tbl_recvoucher VALUES("2177","0","REV060724108","","20000.00","2024-07-06","5","2024-07-06 06:45:42");
INSERT INTO tbl_recvoucher VALUES("2178","0","REV060724109","","76000.00","2024-07-06","5","2024-07-06 06:46:25");
INSERT INTO tbl_recvoucher VALUES("2179","0","REV060724110","","20000.00","2024-07-06","5","2024-07-06 07:00:18");
INSERT INTO tbl_recvoucher VALUES("2180","0","REV060724111","","19000.00","2024-07-06","5","2024-07-06 08:05:46");
INSERT INTO tbl_recvoucher VALUES("2181","0","REV060724112","","20000.00","2024-07-06","5","2024-07-06 08:06:15");
INSERT INTO tbl_recvoucher VALUES("2182","0","REV060724113","","3500.00","2024-07-06","5","2024-07-06 08:18:00");
INSERT INTO tbl_recvoucher VALUES("2183","0","REV060724114","","55000.00","2024-07-06","5","2024-07-06 08:29:48");
INSERT INTO tbl_recvoucher VALUES("2184","0","REV070724101","SSD 256 M.2 Apollo 20 Pcs + Ram 8 Gb DDR 4  22 Pcs","76000.00","2024-07-07","5","2024-07-07 12:51:51");
INSERT INTO tbl_recvoucher VALUES("2185","0","REV070724102","","45000.00","2024-07-07","5","2024-07-07 01:47:17");
INSERT INTO tbl_recvoucher VALUES("2186","0","REV070724103","","19500.00","2024-07-07","5","2024-07-07 04:22:07");
INSERT INTO tbl_recvoucher VALUES("2187","0","REV070724104","","25000.00","2024-07-07","5","2024-07-07 04:24:14");
INSERT INTO tbl_recvoucher VALUES("2188","0","REV070724105","","35000.00","2024-07-07","5","2024-07-07 04:24:42");
INSERT INTO tbl_recvoucher VALUES("2189","0","REV070724106","","18000.00","2024-07-07","5","2024-07-07 06:20:14");
INSERT INTO tbl_recvoucher VALUES("2190","0","REV070724107","","112000.00","2024-07-07","5","2024-07-07 08:37:29");
INSERT INTO tbl_recvoucher VALUES("2191","0","REV070724108","","50000.00","2024-07-07","5","2024-07-07 11:15:27");
INSERT INTO tbl_recvoucher VALUES("2192","0","REV080724101","","89750.00","2024-07-07","5","2024-07-08 12:00:16");
INSERT INTO tbl_recvoucher VALUES("2193","0","REV080724102","","100000.00","2024-07-08","5","2024-07-08 05:46:45");
INSERT INTO tbl_recvoucher VALUES("2194","0","REV080724103","","100000.00","2024-07-08","5","2024-07-08 05:47:12");
INSERT INTO tbl_recvoucher VALUES("2195","0","REV080724104","","100000.00","2024-07-08","5","2024-07-08 05:47:54");
INSERT INTO tbl_recvoucher VALUES("2196","0","REV080724105","","29500.00","2024-07-08","5","2024-07-08 05:49:02");
INSERT INTO tbl_recvoucher VALUES("2197","0","REV080724106","","140000.00","2024-07-08","5","2024-07-08 06:41:37");
INSERT INTO tbl_recvoucher VALUES("2198","0","REV080724107","","50000.00","2024-07-08","5","2024-07-08 06:43:28");
INSERT INTO tbl_recvoucher VALUES("2199","0","REV080724108","","100000.00","2024-07-08","5","2024-07-08 07:19:24");
INSERT INTO tbl_recvoucher VALUES("2200","0","REV080724109","","50000.00","2024-07-08","5","2024-07-08 07:58:32");
INSERT INTO tbl_recvoucher VALUES("2201","0","REV090724101","","20000.00","2024-07-09","5","2024-07-09 05:06:11");
INSERT INTO tbl_recvoucher VALUES("2203","0","REV100724102","","20000.00","2024-07-10","5","2024-07-10 11:28:06");
INSERT INTO tbl_recvoucher VALUES("2204","0","REV100724103","","30000.00","2024-07-10","5","2024-07-10 11:29:55");
INSERT INTO tbl_recvoucher VALUES("2205","0","REV100724104","","30000.00","2024-07-10","5","2024-07-10 01:08:43");
INSERT INTO tbl_recvoucher VALUES("2206","0","REV100724105","","52500.00","2024-07-10","5","2024-07-10 01:46:21");
INSERT INTO tbl_recvoucher VALUES("2207","0","REV100724106","","80000.00","2024-07-10","5","2024-07-10 02:19:42");
INSERT INTO tbl_recvoucher VALUES("2208","0","REV100724107","Bill Edit Kora Jay Nai 39000 Paisi","39000.00","2024-07-10","5","2024-07-10 04:30:48");
INSERT INTO tbl_recvoucher VALUES("2209","0","REV100724108","","35000.00","2024-07-10","5","2024-07-10 08:00:51");
INSERT INTO tbl_recvoucher VALUES("2210","0","REV100724109","","19500.00","2024-07-10","5","2024-07-10 08:06:26");
INSERT INTO tbl_recvoucher VALUES("2211","0","REV100724110","","9000.00","2024-07-10","5","2024-07-10 08:07:53");
INSERT INTO tbl_recvoucher VALUES("2212","0","REV110724101","","18000.00","2024-07-11","5","2024-07-11 02:11:39");
INSERT INTO tbl_recvoucher VALUES("2213","0","REV110724102","","49000.00","2024-07-11","5","2024-07-11 02:45:56");
INSERT INTO tbl_recvoucher VALUES("2214","0","REV110724103","","6000.00","2024-07-11","5","2024-07-11 05:15:19");
INSERT INTO tbl_recvoucher VALUES("2215","0","REV110724104","","49500.00","2024-07-11","5","2024-07-11 06:27:19");
INSERT INTO tbl_recvoucher VALUES("2216","0","REV110724105","","30000.00","2024-07-11","5","2024-07-11 07:32:21");
INSERT INTO tbl_recvoucher VALUES("2217","0","REV110724106","Bank TRF","40000.00","2024-07-11","5","2024-07-11 07:45:00");
INSERT INTO tbl_recvoucher VALUES("2218","0","REV110724107","","19500.00","2024-07-11","5","2024-07-11 07:46:22");
INSERT INTO tbl_recvoucher VALUES("2219","0","REV110724108","","30000.00","2024-07-11","5","2024-07-11 07:49:10");
INSERT INTO tbl_recvoucher VALUES("2220","0","REV110724109","","134500.00","2024-07-11","5","2024-07-11 07:59:59");
INSERT INTO tbl_recvoucher VALUES("2221","0","REV110724110","","50000.00","2024-07-11","5","2024-07-11 11:46:04");
INSERT INTO tbl_recvoucher VALUES("2222","0","REV120724101","","30000.00","2024-07-12","5","2024-07-12 05:50:01");
INSERT INTO tbl_recvoucher VALUES("2223","0","REV120724102","","60000.00","2024-07-12","5","2024-07-12 07:50:06");
INSERT INTO tbl_recvoucher VALUES("2224","0","REV130724101","","196000.00","2024-07-13","5","2024-07-13 12:30:25");
INSERT INTO tbl_recvoucher VALUES("2225","0","REV130724102","","20500.00","2024-07-13","5","2024-07-13 02:22:04");
INSERT INTO tbl_recvoucher VALUES("2226","0","REV130724103","","20000.00","2024-07-13","5","2024-07-13 03:01:52");
INSERT INTO tbl_recvoucher VALUES("2227","0","REV130724104","","19000.00","2024-07-13","5","2024-07-13 07:59:25");
INSERT INTO tbl_recvoucher VALUES("2228","0","REV130724105","","35000.00","2024-07-13","5","2024-07-13 08:03:07");
INSERT INTO tbl_recvoucher VALUES("2229","0","REV140724101","","25000.00","2024-07-14","5","2024-07-14 07:48:45");
INSERT INTO tbl_recvoucher VALUES("2230","0","REV150724101","","90000.00","2024-07-15","5","2024-07-15 06:01:20");
INSERT INTO tbl_recvoucher VALUES("2231","0","REV150724102","","50000.00","2024-07-15","5","2024-07-15 07:52:10");
INSERT INTO tbl_recvoucher VALUES("2232","0","REV160724101","","40000.00","2024-07-15","5","2024-07-16 03:28:15");
INSERT INTO tbl_recvoucher VALUES("2233","0","REV170724101","","40000.00","2024-07-17","5","2024-07-17 11:49:20");
INSERT INTO tbl_recvoucher VALUES("2234","0","REV170724102","","20000.00","2024-07-17","5","2024-07-17 01:48:08");
INSERT INTO tbl_recvoucher VALUES("2235","0","REV170724103","","206000.00","2024-07-17","5","2024-07-17 07:49:06");
INSERT INTO tbl_recvoucher VALUES("2236","0","REV170724104","","67500.00","2024-07-17","5","2024-07-17 08:04:34");
INSERT INTO tbl_recvoucher VALUES("2237","0","REV250724101","","50000.00","2024-07-25","5","2024-07-25 01:02:10");
INSERT INTO tbl_recvoucher VALUES("2238","0","REV270724101","","22000.00","2024-07-27","5","2024-07-27 11:25:42");
INSERT INTO tbl_recvoucher VALUES("2239","0","REV270724102","","250000.00","2024-07-18","5","2024-07-27 02:15:43");
INSERT INTO tbl_recvoucher VALUES("2240","0","REV280724101","","3000.00","2024-07-28","5","2024-07-28 05:32:52");
INSERT INTO tbl_recvoucher VALUES("2241","0","REV280724102","","43000.00","2024-07-28","5","2024-07-28 09:21:31");
INSERT INTO tbl_recvoucher VALUES("2242","0","REV290724101","","40000.00","2024-07-28","5","2024-07-29 12:25:32");
INSERT INTO tbl_recvoucher VALUES("2243","0","REV290724102","","30000.00","2024-07-29","5","2024-07-29 12:28:34");
INSERT INTO tbl_recvoucher VALUES("2244","0","REV290724103","","92500.00","2024-07-11","5","2024-07-29 02:04:27");
INSERT INTO tbl_recvoucher VALUES("2245","0","REV290724104","","70000.00","2024-07-29","5","2024-07-29 02:23:21");
INSERT INTO tbl_recvoucher VALUES("2246","0","REV290724105","","53000.00","2024-07-29","5","2024-07-29 02:44:10");
INSERT INTO tbl_recvoucher VALUES("2247","0","REV290724106","","34000.00","2024-07-29","5","2024-07-29 04:03:18");
INSERT INTO tbl_recvoucher VALUES("2248","0","REV290724107","","40000.00","2024-07-29","5","2024-07-29 11:30:16");
INSERT INTO tbl_recvoucher VALUES("2249","0","REV300724101","","30000.00","2024-07-30","5","2024-07-30 02:19:26");
INSERT INTO tbl_recvoucher VALUES("2250","0","REV300724102","","9000.00","2024-07-30","5","2024-07-30 03:42:32");
INSERT INTO tbl_recvoucher VALUES("2251","0","REV300724103","","4000.00","2024-07-30","5","2024-07-30 09:24:37");
INSERT INTO tbl_recvoucher VALUES("2252","0","REV310724101","","7200.00","2024-07-31","5","2024-07-31 05:42:48");
INSERT INTO tbl_recvoucher VALUES("2253","0","REV310724102","","60000.00","2024-07-31","5","2024-07-31 05:43:26");
INSERT INTO tbl_recvoucher VALUES("2254","0","REV310724103","","5000.00","2024-07-31","5","2024-07-31 10:54:44");
INSERT INTO tbl_recvoucher VALUES("2255","0","REV010824101","","10000.00","2024-07-16","5","2024-08-01 12:50:05");
INSERT INTO tbl_recvoucher VALUES("2256","0","REV010824102","","28500.00","2024-08-01","5","2024-08-01 12:54:54");
INSERT INTO tbl_recvoucher VALUES("2257","0","REV010824103","","51500.00","2024-08-01","5","2024-08-01 02:28:57");
INSERT INTO tbl_recvoucher VALUES("2258","0","REV010824104","","70000.00","2024-08-01","5","2024-08-01 02:50:49");
INSERT INTO tbl_recvoucher VALUES("2260","0","REV010824106","","25000.00","2024-08-01","5","2024-08-01 05:08:52");
INSERT INTO tbl_recvoucher VALUES("2261","0","REV010824107","","100000.00","2024-08-01","5","2024-08-01 05:47:39");
INSERT INTO tbl_recvoucher VALUES("2262","0","REV010824108","","2500.00","2024-08-01","5","2024-08-01 09:11:09");
INSERT INTO tbl_recvoucher VALUES("2263","0","REV020824101","","10000.00","2024-08-02","5","2024-08-02 03:57:05");
INSERT INTO tbl_recvoucher VALUES("2264","0","REV020824102","","25500.00","2024-08-02","5","2024-08-02 07:29:21");
INSERT INTO tbl_recvoucher VALUES("2265","0","REV020824103","","40000.00","2024-08-02","5","2024-08-02 09:17:30");
INSERT INTO tbl_recvoucher VALUES("2266","0","REV030824101","","358000.00","2024-08-03","5","2024-08-03 03:41:21");
INSERT INTO tbl_recvoucher VALUES("2267","0","REV030824102","","25000.00","2024-08-03","5","2024-08-03 04:31:34");
INSERT INTO tbl_recvoucher VALUES("2268","0","REV030824103","","96000.00","2024-08-03","5","2024-08-03 06:28:43");
INSERT INTO tbl_recvoucher VALUES("2269","0","REV050824101","","15000.00","2024-08-01","5","2024-08-05 11:20:31");
INSERT INTO tbl_recvoucher VALUES("2270","0","REV070824101","12 Pro AED 1200 And 11 AED 810 Carry 4k And Profit 1k","61400.00","2024-08-07","5","2024-08-07 11:37:32");
INSERT INTO tbl_recvoucher VALUES("2271","0","REV080824101","","80000.00","2024-08-08","5","2024-08-08 11:19:47");
INSERT INTO tbl_recvoucher VALUES("2272","0","REV100824101","","1000.00","2024-08-10","5","2024-08-10 03:27:57");
INSERT INTO tbl_recvoucher VALUES("2273","0","REV100824102","","2000.00","2024-08-10","5","2024-08-10 03:37:16");
INSERT INTO tbl_recvoucher VALUES("2274","0","REV120824101","","50000.00","2024-08-12","5","2024-08-12 07:05:41");
INSERT INTO tbl_recvoucher VALUES("2275","0","REV130824101","Laptop RAM DDR 4 Unit 2 8 GB Shaikat ","2900.00","2024-08-13","5","2024-08-13 12:36:04");
INSERT INTO tbl_recvoucher VALUES("2276","0","REV130824102","","20000.00","2024-08-13","5","2024-08-13 02:39:13");
INSERT INTO tbl_recvoucher VALUES("2277","0","REV130824103","","48000.00","2024-08-13","5","2024-08-13 04:02:34");
INSERT INTO tbl_recvoucher VALUES("2278","0","REV140824101","","115000.00","2024-08-14","5","2024-08-14 11:40:19");
INSERT INTO tbl_recvoucher VALUES("2279","0","REV140824102","","40000.00","2024-08-14","5","2024-08-14 12:37:22");
INSERT INTO tbl_recvoucher VALUES("2280","0","REV140824103","","20000.00","2024-08-14","5","2024-08-14 06:36:32");
INSERT INTO tbl_recvoucher VALUES("2281","0","REV140824104","","8000.00","2024-08-14","5","2024-08-14 07:09:51");
INSERT INTO tbl_recvoucher VALUES("2282","0","REV140824105","","12500.00","2024-08-14","5","2024-08-14 07:52:31");
INSERT INTO tbl_recvoucher VALUES("2283","0","REV150824101","","25100.00","2024-08-15","5","2024-08-15 07:28:38");
INSERT INTO tbl_recvoucher VALUES("2284","0","REV150824102","","23000.00","2024-08-15","5","2024-08-15 11:06:10");
INSERT INTO tbl_recvoucher VALUES("2285","0","REV150824103","","37000.00","2024-08-15","5","2024-08-15 11:10:17");
INSERT INTO tbl_recvoucher VALUES("2286","0","REV160824101","","50000.00","2024-08-16","5","2024-08-16 06:59:07");
INSERT INTO tbl_recvoucher VALUES("2287","0","REV170824101","","40000.00","2024-08-17","5","2024-08-17 10:37:29");
INSERT INTO tbl_recvoucher VALUES("2288","0","REV170824102","","18000.00","2024-08-17","5","2024-08-17 10:54:08");
INSERT INTO tbl_recvoucher VALUES("2289","0","REV170824103","Cash 74000 tk + Bikash  5500","79500.00","2024-08-17","5","2024-08-17 05:25:35");
INSERT INTO tbl_recvoucher VALUES("2290","0","REV180824101","","100000.00","2024-08-18","5","2024-08-18 01:11:23");
INSERT INTO tbl_recvoucher VALUES("2291","0","REV180824102","","60000.00","2024-08-18","5","2024-08-18 01:48:24");
INSERT INTO tbl_recvoucher VALUES("2292","0","REV180824103","","4000.00","2024-08-18","5","2024-08-18 05:19:48");
INSERT INTO tbl_recvoucher VALUES("2293","0","REV180824104","TRF BANK ","4000.00","2024-08-18","5","2024-08-18 05:48:41");
INSERT INTO tbl_recvoucher VALUES("2294","0","REV190824101","","100000.00","2024-08-19","5","2024-08-19 12:27:49");