

CREATE TABLE `tbl_acledger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `grid` int(11) NOT NULL,
  `sgrid` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(250) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=180 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_acledger VALUES("1","200001","2","1","Petty Cash","","Every Days Official Expenses Amount","1","2020-04-22 12:22:21");
INSERT INTO tbl_acledger VALUES("2","200002","2","1","Cash","","Income Form Sales Or Other Income","1","2020-04-22 12:23:22");
INSERT INTO tbl_acledger VALUES("3","100001","1","6","Service Tools &amp; Equipment","","","1","2020-04-22 12:30:58");
INSERT INTO tbl_acledger VALUES("4","100002","1","6","Furniture, Fixture &amp; Interiors","","","1","2020-04-22 12:33:37");
INSERT INTO tbl_acledger VALUES("5","300001","3","30","Capital","","","1","2020-04-22 12:41:21");
INSERT INTO tbl_acledger VALUES("6","300002","3","31","Cash Withdrawal","","","1","2020-04-22 12:41:42");
INSERT INTO tbl_acledger VALUES("7","300003","3","32","Retained Earnings","","","1","2020-04-22 12:42:12");
INSERT INTO tbl_acledger VALUES("8","300004","3","32","VAT Reimbursement Account","","","1","2020-04-22 12:43:15");
INSERT INTO tbl_acledger VALUES("9","500001","5","14","VAT On Commission Payable","","","1","2020-04-22 12:44:09");
INSERT INTO tbl_acledger VALUES("10","500002","5","14","VAT On Sales Payable","","","1","2020-04-22 12:44:48");
INSERT INTO tbl_acledger VALUES("11","700001","7","27","Interest On FDR","","","1","2020-04-22 12:46:31");
INSERT INTO tbl_acledger VALUES("12","700002","7","28","Freight Receipt","","","1","2020-04-22 12:47:09");
INSERT INTO tbl_acledger VALUES("13","900065","9","21","Bank Charges-ব্যাংক চার্জ","ব্যাংক চার্জ","","1","2020-04-22 12:48:48");
INSERT INTO tbl_acledger VALUES("14","600001","6","25","Cost Of Good Sold","","","1","2020-04-22 12:50:22");
INSERT INTO tbl_acledger VALUES("15","900032","9","21","Telephones &amp; Mobile Bill","টেলিফোন এবং মোবাইল বিল","","1","2020-04-22 12:48:04");
INSERT INTO tbl_acledger VALUES("16","900072","9","21","Electricity Bills বিদ্যুৎ বিল","বিদ্যুৎ বিল","","1","2020-04-22 12:48:32");
INSERT INTO tbl_acledger VALUES("17","900023","9","21","Food, Lunch &amp; Entertainments","খাবার, দুপুরের খাবার এবং অন্যান্য","","1","2020-04-22 12:48:49");
INSERT INTO tbl_acledger VALUES("18","500007","5","16","Supplier Previous Balance","","","1","2020-04-22 12:49:09");
INSERT INTO tbl_acledger VALUES("19","900039","9","21","Office Conveyances","যাতায়াত খরচ","","1","2020-04-22 12:49:41");
INSERT INTO tbl_acledger VALUES("20","900068","9","21","Office Stationeries-অফিস মনিহারি","কার্যালয়ের নিশ্চল খরচ","","1","2020-04-22 12:50:34");
INSERT INTO tbl_acledger VALUES("21","900020","9","21","Internet &amp; IT Expenses","ইন্টারনেট ও আইটির খরচ","","1","2020-04-22 12:50:56");
INSERT INTO tbl_acledger VALUES("22","900034","9","21","Sundry Expenses","বিবিধ খরচ","","1","2020-04-22 12:51:20");
INSERT INTO tbl_acledger VALUES("23","900061","9","21","Licences  Renewals Exp","লাইসেন্স নবায়ন খরচ","","1","2020-04-22 12:51:43");
INSERT INTO tbl_acledger VALUES("24","900064","9","21","Sales Commission","বিক্রয় কমিশন","","1","2020-04-22 12:52:17");
INSERT INTO tbl_acledger VALUES("25","900048","9","21","VAT On Purchase","ক্রয়ের উপর ভ্যাট","","1","2020-04-22 12:53:00");
INSERT INTO tbl_acledger VALUES("26","900049","9","21","Tax On Purchase","ক্রয়ের উপর ট্যাক্স","","1","2020-04-22 12:53:14");
INSERT INTO tbl_acledger VALUES("27","800013","8","20","Other Direct Expenses","অন্যান্য পরিচালন খরচ","","1","2020-04-22 12:53:29");
INSERT INTO tbl_acledger VALUES("28","900033","9","21","Tips &amp; Donations","টিপস এবং ডোনেশন","","1","2020-04-22 12:54:02");
INSERT INTO tbl_acledger VALUES("29","900028","9","21","Personal Expenses","ব্যাক্তিগত খরচ","All personal Expenses of Owner","1","2020-04-22 12:54:48");
INSERT INTO tbl_acledger VALUES("30","800022","8","20","Delivery Expenses","ডেলিভারি","Finished goods to clients and raw materials to factory. ","1","2020-04-22 01:08:31");
INSERT INTO tbl_acledger VALUES("31","900026","9","21","Office Rent","কার্যালয়ের ভাড়া","","1","2020-04-27 10:35:17");
INSERT INTO tbl_acledger VALUES("32","700003","7","26","Commission Income","","","1","2020-04-27 10:45:27");
INSERT INTO tbl_acledger VALUES("33","100003","1","12","Customer Opening Balance","","","1","2020-04-27 10:54:57");
INSERT INTO tbl_acledger VALUES("34","600002","6","23","Sales Revenue","","","1","2020-04-28 02:20:11");
INSERT INTO tbl_acledger VALUES("35","900031","9","21","Water Bill","পানির বিল","Welcome Test","1","2020-04-29 11:29:35");
INSERT INTO tbl_acledger VALUES("36","800010","8","20","Discount On Sales","বিক্রয়ের ডিসকাউন্ট","","1","2020-06-11 07:58:38");
INSERT INTO tbl_acledger VALUES("37","800009","8","20","Discount On Item","আইটেমে ডিসকাউন্ট","","1","2020-06-11 08:00:10");
INSERT INTO tbl_acledger VALUES("38","500003","5","14","AIT On Sales Payable","","","1","2020-06-11 08:03:40");
INSERT INTO tbl_acledger VALUES("39","700004","7","28","Service Charges Receipts","","","1","2020-06-11 08:06:32");
INSERT INTO tbl_acledger VALUES("40","800011","8","20","Less Given On Sales","বিক্রয়ের উপর কমিশন","","1","2020-06-11 08:09:58");
INSERT INTO tbl_acledger VALUES("41","500005","5","16","Discount Reserves On Purchase","","","1","2020-06-16 11:25:15");
INSERT INTO tbl_acledger VALUES("42","500004","5","16","Discount Item On Purchase","","","1","2020-06-16 11:25:59");
INSERT INTO tbl_acledger VALUES("43","700007","7","28","Less Paid On Purchase","","","1","2020-06-16 11:29:10");
INSERT INTO tbl_acledger VALUES("44","900067","9","21","Labour &amp; Transportation-লেবার ও ট্র","লেবার এবং ট্রান্সপোর্টেশন","","1","2020-06-16 11:41:50");
INSERT INTO tbl_acledger VALUES("45","800012","8","20","Less Receive On Purchase Return","ক্রয়কৃত পন্য ফেরতের উপর ছাড়","","1","2020-06-17 02:56:32");
INSERT INTO tbl_acledger VALUES("46","700008","7","28","Less Paid On Sales Return","","","1","2020-06-17 11:29:43");
INSERT INTO tbl_acledger VALUES("47","300005","3","30","Receive/Payable Adjustment Account","","Customer And Supplier Opening Balance","1","2020-07-07 12:43:41");
INSERT INTO tbl_acledger VALUES("48","500006","5","33","Salaries,Wages And Allowance","","Employee Salary","1","2020-07-23 11:01:51");
INSERT INTO tbl_acledger VALUES("49","800016","8","20","Product Adjustment","","Product witch are damage, stolen, miss use etc...","1","2020-08-25 01:35:32");
INSERT INTO tbl_acledger VALUES("50","800017","8","37","Cost Of Good Damage","","","1","2020-08-25 02:13:42");
INSERT INTO tbl_acledger VALUES("51","600003","6","38","Damage Revenue","","Product witch are damage, stolen, miss use etc...","1","2020-08-25 02:28:47");
INSERT INTO tbl_acledger VALUES("52","300006","3","31","Cash Withdrawn From Mobile Account","","Cash Withdrawn from Mobile Account","1","2020-10-10 03:49:47");
INSERT INTO tbl_acledger VALUES("53","900040","9","21","Vehicle Parts And Petrol Bill","","","1","2020-10-14 08:34:32");
INSERT INTO tbl_acledger VALUES("54","900036","9","21","Entertainment","","","1","2020-11-12 07:46:54");
INSERT INTO tbl_acledger VALUES("55","000001","0","","M/ Jamal &amp; Brother`","","ca","1","2020-12-01 02:10:54");
INSERT INTO tbl_acledger VALUES("56","300007","3","30","13 Cons","","","1","2020-12-17 04:01:12");
INSERT INTO tbl_acledger VALUES("57","300008","3","30","Md. Mohib Ullah (Ripon)","","Md. Mohib Ullah (Ripon), Owners Equity, Share Capital.","1","2020-12-22 11:29:36");
INSERT INTO tbl_acledger VALUES("58","300009","3","30","Karim Khan","","","1","2020-12-23 05:18:17");
INSERT INTO tbl_acledger VALUES("59","300010","3","30","Naimul Hasan","","","1","2020-12-23 05:18:55");
INSERT INTO tbl_acledger VALUES("60","300011","3","30","Akbar Ali","","ownership ","1","2020-12-23 05:19:20");
INSERT INTO tbl_acledger VALUES("61","300012","3","30","Asabul Royen","","If any","1","2021-01-04 04:37:03");
INSERT INTO tbl_acledger VALUES("62","300013","3","30","Ashraful","","owner","1","2021-01-06 01:00:46");
INSERT INTO tbl_acledger VALUES("63","300014","3","30","Abul Kalam","","owner","1","2021-01-06 01:01:38");
INSERT INTO tbl_acledger VALUES("64","900038","9","21","Qwert","qwert","","1","2021-03-16 12:47:14");
INSERT INTO tbl_acledger VALUES("65","800089","8","20","Factory Expense","ফ্যাক্টরির খরচ","","7","2021-11-02 05:47:09");
INSERT INTO tbl_acledger VALUES("66","800023","8","20","Personal Expense","Personal Expense","","7","2021-12-06 04:51:36");
INSERT INTO tbl_acledger VALUES("67","900042","9","21","Factory Rent (Ground Floor)","Factory Rent","","7","2021-12-14 02:30:39");
INSERT INTO tbl_acledger VALUES("68","900043","9","21","Factory Rent (4th Floor)","Factory Rent (4th Floor)","","7","2021-12-14 02:32:52");
INSERT INTO tbl_acledger VALUES("69","900051","9","21","Marketing (Conveyance)","মার্কেটিং খরচ","মার্কেটিং খরচ","7","2021-12-14 02:36:32");
INSERT INTO tbl_acledger VALUES("70","100004","1","6","Machineries","","","7","2021-12-14 02:45:45");
INSERT INTO tbl_acledger VALUES("71","900044","9","21","Depreciation","","","7","2021-12-14 02:51:32");
INSERT INTO tbl_acledger VALUES("72","100005","1","6","Accumulated Depreciation","","","7","2021-12-14 02:52:06");
INSERT INTO tbl_acledger VALUES("73","900045","9","21","Software Maintenance &amp; Renewal"," Software Maintenance & Renewal","","1","2022-01-02 04:12:56");
INSERT INTO tbl_acledger VALUES("74","800025","8","20","Factory Petty Cash","Factory Petty Cash","","1","2022-01-02 05:33:28");
INSERT INTO tbl_acledger VALUES("75","100006","1","6","Furniture","","","1","2022-01-03 05:18:12");
INSERT INTO tbl_acledger VALUES("76","100007","1","6","Land","","","1","2022-01-03 05:40:05");
INSERT INTO tbl_acledger VALUES("77","100008","1","6","Motor Bike","","","1","2022-01-03 05:40:20");
INSERT INTO tbl_acledger VALUES("78","200003","2","39","Kolom (Production)","","","1","2022-03-27 03:55:25");
INSERT INTO tbl_acledger VALUES("79","200004","2","39","Pathor (Production)","","","1","2022-03-27 03:58:17");
INSERT INTO tbl_acledger VALUES("80","200005","2","39","NT-18 Plantic Feet","","","1","2022-03-27 04:03:46");
INSERT INTO tbl_acledger VALUES("81","800026","8","20","Bkash Charge","","","1","2022-03-27 04:28:53");
INSERT INTO tbl_acledger VALUES("82","800027","8","20","Transportation","","","1","2022-03-27 04:56:41");
INSERT INTO tbl_acledger VALUES("83","900046","9","21","INCOME TAX","আয়কর","","1","2022-05-11 01:36:21");
INSERT INTO tbl_acledger VALUES("84","900047","9","21","VAT","ভ্যাট","","1","2022-05-11 01:36:59");
INSERT INTO tbl_acledger VALUES("85","800094","8","20","TRUCK FUEL-ট্রাকের তেল","ট্রাকের তেল","","1","2022-05-11 01:38:01");
INSERT INTO tbl_acledger VALUES("86","800075","8","20","LEABOUR COST (লেবার মজুরি)"," LEABOUR COST (লেবার মজুরি)","","1","2022-05-11 01:43:01");
INSERT INTO tbl_acledger VALUES("87","900074","9","21","SALARY/ বেতন","বেতন","বেতন","1","2022-05-11 01:45:06");
INSERT INTO tbl_acledger VALUES("88","900052","9","21","BANK LOAN","ব্যাংক লোন","","1","2022-05-11 02:27:14");
INSERT INTO tbl_acledger VALUES("89","900066","9","21","FOOD OFFICE-ফুড অফিস","ফুড অফিস","ফুড অফিস","1","2022-05-11 02:51:48");
INSERT INTO tbl_acledger VALUES("90","800030","8","20","নছিমন/ ভ্যান/ অটো ভাড়া","নছিমন/ ভ্যান/ অটো ভাড়া","","1","2022-05-12 09:31:45");
INSERT INTO tbl_acledger VALUES("91","800118","8","20","ওভারটাইম- Overtime","ওভারটাইম","","1","2022-05-12 09:32:16");
INSERT INTO tbl_acledger VALUES("92","800032","8","20","লেবার নাস্তা","লেবার নাস্তা","","1","2022-05-12 09:34:06");
INSERT INTO tbl_acledger VALUES("93","800033","8","20","ড্রাইভার/ হেলপার নাস্তা","ড্রাইভার/ হেলপার নাস্তা","","1","2022-05-12 09:34:56");
INSERT INTO tbl_acledger VALUES("94","800034","8","20","অফিস স্টাফ নাস্তা","অফিস স্টাফ নাস্তা","","1","2022-05-12 09:35:31");
INSERT INTO tbl_acledger VALUES("95","800110","8","20","ফোরম্যান নাস্তা FOUR NASTA ","ফোরম্যান নাস্তা","","1","2022-05-12 09:36:04");
INSERT INTO tbl_acledger VALUES("96","800036","8","20","লাইনম্যান নাস্তা","লাইনম্যান নাস্তা","","1","2022-05-12 09:36:31");
INSERT INTO tbl_acledger VALUES("97","800122","8","20","ময়লা ভাঙ্গা MOYLA BANGA EXP","ময়লা ভাঙ্গা","","1","2022-05-12 09:39:33");
INSERT INTO tbl_acledger VALUES("98","800112","8","20","ভূট্রা ভাঙ্গা খরচ-VUTTA BANGA EXP","ভূট্রা ভাঙ্গা","","1","2022-05-12 09:40:08");
INSERT INTO tbl_acledger VALUES("99","800111","8","20","প্যাকিং খরচ-PACKING EXP","প্যাকিং খরচ","","1","2022-05-12 09:40:52");
INSERT INTO tbl_acledger VALUES("100","800040","8","20","রাজ মিস্ত্রি খরচ","রাজ মিস্ত্রি খরচ","","1","2022-05-12 09:41:30");
INSERT INTO tbl_acledger VALUES("101","800041","8","20","নির্মানাধীন/ সামগ্রী","নির্মানাধীন/ সামগ্রী","","1","2022-05-12 09:44:00");
INSERT INTO tbl_acledger VALUES("102","800042","8","20","অগ্রীম বেতন","অগ্রীম বেতন","","1","2022-05-12 09:44:35");
INSERT INTO tbl_acledger VALUES("103","800121","8","20","Truck Other Exp. ট্রাক যাবতীয় খরচ","ট্রাক/ পিকাপ যাবতীয় খরচ","","1","2022-05-12 09:46:22");
INSERT INTO tbl_acledger VALUES("104","900055","9","21","অফিস খরচ","অফিস খরচ","","1","2022-05-12 09:46:41");
INSERT INTO tbl_acledger VALUES("105","800119","8","20","ডিলার/ ব্যালেন্স - Delar Balance","ডিলার/ ব্যালেন্স","","1","2022-05-12 09:47:28");
INSERT INTO tbl_acledger VALUES("106","800045","8","20","লেবার মজুরী","লেবার মজুরী","","1","2022-05-12 10:20:49");
INSERT INTO tbl_acledger VALUES("107","800046","8","20","লেবার নাস্তা/ রাতের","লেবার নাস্তা/ রাতের","","1","2022-05-12 10:37:59");
INSERT INTO tbl_acledger VALUES("108","800047","8","20","লেবার নাস্তা/ দিনের","লেবার নাস্তা/ দিনের","","1","2022-05-12 10:38:20");
INSERT INTO tbl_acledger VALUES("109","800048","8","20","রান্নার সামগ্রী","রান্নার সামগ্রী","","1","2022-05-12 10:41:45");
INSERT INTO tbl_acledger VALUES("110","800049","8","20","ক্লিনার বিল","ক্লিনার বিল","","1","2022-05-12 07:15:17");
INSERT INTO tbl_acledger VALUES("111","800117","8","20","রোড খরচ Road Exp","Road Exp","","1","2022-05-12 10:01:22");
INSERT INTO tbl_acledger VALUES("112","800051","8","20","মো: সোহরাব হোসেন /ফোরম্যান","মো: সোহরাব হোসেন /ফোরম্যান","","1","2022-05-14 08:32:53");
INSERT INTO tbl_acledger VALUES("113","800052","8","20","মো: রাজিব তালুকদার /লাইন ম্যান","মো: রাজিব তালুকদার /লাইন ম্যান","","1","2022-05-14 08:33:33");
INSERT INTO tbl_acledger VALUES("114","800053","8","20","মো: ইউনুছ তালুকদার /লাইন ম্যান","মো: ইউনুছ তালুকদার /লাইন ম্যান","","1","2022-05-14 08:34:01");
INSERT INTO tbl_acledger VALUES("115","800054","8","20","মো: জলিল মোল্লা /লাইন ম্যান","মো: জলিল মোল্লা /লাইন ম্যান","","1","2022-05-14 08:35:09");
INSERT INTO tbl_acledger VALUES("116","800055","8","20","মো: আলী হোসেন	/লেবার","	মো: আলী হোসেন	/লেবার","","1","2022-05-14 08:35:33");
INSERT INTO tbl_acledger VALUES("117","800056","8","20","মো: আলেক মিয়া	/লেবার","	মো: আলেক মিয়া	/লেবার","","1","2022-05-14 08:35:51");
INSERT INTO tbl_acledger VALUES("118","800057","8","20","মো: সুমন তালুকদার /লেবার","মো: সুমন তালুকদার /লেবার","","1","2022-05-14 08:36:16");
INSERT INTO tbl_acledger VALUES("119","800058","8","20","মো: নজরুল/	লেবার","মো: নজরুল/	লেবার","","1","2022-05-14 08:52:25");
INSERT INTO tbl_acledger VALUES("120","800106","8","20","M","মো: মোস্তাফিজ	/লাইন ম্যান","","1","2022-05-14 08:53:00");
INSERT INTO tbl_acledger VALUES("121","800108","8","20","M O","মো: মোস্তফা	সিনিঃ/লাইন ম্যান","","1","2022-05-14 08:55:15");
INSERT INTO tbl_acledger VALUES("122","800061","8","20","মো: রাবিত হাসান	/লেবার","মো: রাবিত হাসান	/লেবার","","1","2022-05-14 08:55:40");
INSERT INTO tbl_acledger VALUES("123","800062","8","20","মো: সোহেল মাল	/লেবার","	মো: সোহেল মাল	/লেবার","","1","2022-05-14 08:56:06");
INSERT INTO tbl_acledger VALUES("124","800063","8","20","মো: ওয়াহিদুল	/লেবার","মো: ওয়াহিদুল	/লেবার","","1","2022-05-14 08:56:28");
INSERT INTO tbl_acledger VALUES("125","800091","8","20","লেবার","লেবার","","1","2022-05-14 08:56:53");
INSERT INTO tbl_acledger VALUES("126","800065","8","20","মো: মনির /ড্রাইভার","মো: মনির /ড্রাইভার","","1","2022-05-14 08:57:15");
INSERT INTO tbl_acledger VALUES("127","800066","8","20","মো: বাবুল / ড্রাইভার","মো: বাবুল / ড্রাইভার","","1","2022-05-14 08:57:41");
INSERT INTO tbl_acledger VALUES("128","800076","8","20","মো: রাশেদ  /ড্রাইভার","মো: রাশেদ /ড্রাইভার","","1","2022-05-14 08:58:08");
INSERT INTO tbl_acledger VALUES("129","800068","8","20","মো: এমদাত হাওলাদার	/কেয়ারটেকার","মো: এমদাত হাওলাদার	/কেয়ারটেকার","","1","2022-05-14 09:05:43");
INSERT INTO tbl_acledger VALUES("130","800069","8","20","নুরুন্নাহার /বাবুর্চী","নুরুন্নাহার /বাবুর্চী","","1","2022-05-14 09:05:59");
INSERT INTO tbl_acledger VALUES("131","800107","8","20","R A","মো: রাসেল /হেলপার","","1","2022-05-14 09:06:30");
INSERT INTO tbl_acledger VALUES("132","800071","8","20","মো: ফয়সাল /ড্রাইভার ","মো: ফয়সাল /ড্রাইভার ","","1","2022-05-14 09:07:49");
INSERT INTO tbl_acledger VALUES("133","800072","8","20","কামাল / অফসি সহায়ক","কামাল / অফসি সহায়ক","","1","2022-05-14 09:08:16");
INSERT INTO tbl_acledger VALUES("134","800073","8","20","কাজল /হেলপার","কাজল /হেলপার","","1","2022-05-14 09:09:44");
INSERT INTO tbl_acledger VALUES("135","800074","8","20","বাবু /হেলপার","বাবু /হেলপার","","1","2022-05-14 09:10:01");
INSERT INTO tbl_acledger VALUES("136","900056","9","21","মো: বশির আহমেদ","মো: বশির আহমেদ","কম্পিউটার অপারেটর","1","2022-05-14 09:30:27");
INSERT INTO tbl_acledger VALUES("137","900057","9","21","অন্যান্য","অন্যান্য","","1","2022-05-16 11:27:06");
INSERT INTO tbl_acledger VALUES("138","800077","8","20","গোডাউন খরচ","গোডাউন খরচ","","1","2022-05-17 06:00:43");
INSERT INTO tbl_acledger VALUES("139","900069","9","21","RI","রিপন ম্যানেজার","","1","2022-05-19 02:49:54");
INSERT INTO tbl_acledger VALUES("140","800078","8","20","মো: ইউছুফ","মো: ইউছুফ","","1","2022-05-19 05:25:30");
INSERT INTO tbl_acledger VALUES("141","800079","8","20","মো: ইব্রাহিম লেবার","মো: ইব্রাহিম লেবার","","1","2022-05-19 05:41:07");
INSERT INTO tbl_acledger VALUES("142","800080","8","20","শান্ত/ হেলপার","শান্ত/ হেলপার","","1","2022-05-19 05:55:48");
INSERT INTO tbl_acledger VALUES("143","800081","8","20","নড়িয়া গোডাউন ভাড়া","নড়িয়া গোডাউন ভাড়া","","1","2022-05-30 09:37:06");
INSERT INTO tbl_acledger VALUES("144","800095","8","20","ANGARIA GODAWAON-আংগারিয়া গোডাউন","আংগারিয়া গোডাউন ভাড়া","","1","2022-05-30 09:37:42");
INSERT INTO tbl_acledger VALUES("145","900079","9","21","WRONG ENTRY L","WRONG ENTRY L","","1","2022-05-30 09:42:10");
INSERT INTO tbl_acledger VALUES("146","800083","8","20","গোডাউন  অফিস খরচ","গোডাউন  অফিস খরচ","","1","2022-05-30 01:23:13");
INSERT INTO tbl_acledger VALUES("147","800084","8","20","SALES RETURN (বিক্রয় ফেরত)","SALES RETURN (বিক্রয় ফেরত)","","1","2022-05-31 11:50:09");
INSERT INTO tbl_acledger VALUES("148","800085","8","20","PURCHES RETURN (ক্রয় ফেরত)","PURCHES RETURN (ক্রয় ফেরত)","","1","2022-05-31 11:51:20");
INSERT INTO tbl_acledger VALUES("149","800105","8","20","MACHIN ETC-মেশিনে যাবতীয় খরচ","মেশিনে যাবতীয় খরচ","","1","2022-06-01 06:11:44");
INSERT INTO tbl_acledger VALUES("150","800127","8","20","কারখানার মেশিনপত্র","কারখানার মেশিনপত্র","","1","2022-06-02 05:26:48");
INSERT INTO tbl_acledger VALUES("151","900060","9","21","বাস ক্রয় বাবদ","বাস ক্রয় বাবদ","","1","2022-06-02 05:34:10");
INSERT INTO tbl_acledger VALUES("152","800090","8","20","দান খরচ","দান খরচ","","1","2022-06-04 03:18:51");
INSERT INTO tbl_acledger VALUES("153","900062","9","21","বেতন"," বেতন","","1","2022-06-04 03:25:11");
INSERT INTO tbl_acledger VALUES("154","900063","9","21","কামাল - অফসি সহায়ক","কামাল - অফসি সহায়ক","","1","2022-06-04 03:27:02");
INSERT INTO tbl_acledger VALUES("155","800092","8","20","চাক্কা তৈরী","চাক্কা তৈরী","","1","2022-07-19 03:16:45");
INSERT INTO tbl_acledger VALUES("156","800114","8","20","বকশিস BOKSISH","baksish","","1","2022-07-30 05:42:35");
INSERT INTO tbl_acledger VALUES("157","800096","8","20","NASTA EXP-নাস্তা খরচ","NASTA EXP-নাস্তা খরচ","","1","2022-08-03 04:37:37");
INSERT INTO tbl_acledger VALUES("158","800097","8","20","অটো ভাড়া-AUTO RENT","অটো ভাড়া-AUTO RENT","","1","2022-08-03 04:38:08");
INSERT INTO tbl_acledger VALUES("159","800098","8","20","NOCIMON RENT-নছিমন ভাড়া","NOCIMON RENT-নছিমন ভাড়া","","1","2022-08-03 04:38:35");
INSERT INTO tbl_acledger VALUES("160","800099","8","20","ভ্যান ভাড়া-VAN RENT","ভ্যান ভাড়া-VAN RENT","","1","2022-08-03 04:39:21");
INSERT INTO tbl_acledger VALUES("161","800100","8","20","ONLINE EXP.-অন লাইন","ONLINE EXP.-অন লাইন","","1","2022-08-03 04:40:22");
INSERT INTO tbl_acledger VALUES("162","800101","8","20","মটর বাইকের তেল-MOTOR BIKE FUEL","মটর বাইকের তেল-MOTOR BIKE FUEL","","1","2022-08-03 04:41:41");
INSERT INTO tbl_acledger VALUES("163","800102","8","20","TRUCK MOBIL-ট্রাকের মবিল","TRUCK MOBIL-ট্রাকের মবিল","","1","2022-08-03 04:45:44");
INSERT INTO tbl_acledger VALUES("164","800103","8","20","TRUCK RENT-ট্রাক ভাড়া","TRUCK RENT-ট্রাক ভাড়া","","1","2022-08-17 02:03:58");
INSERT INTO tbl_acledger VALUES("165","800104","8","20","মটর বাইকের খরচ-MOTORBIKE EXP","মটর বাইকের খরচ-MOTORBIKE EXP","","1","2022-08-17 02:06:41");
INSERT INTO tbl_acledger VALUES("166","900070","9","21","RICE MIL","রাইচ মিল","গাগ্রিজোড়া","1","2022-09-12 06:05:21");
INSERT INTO tbl_acledger VALUES("167","800113","8","20","ব্রীজ স্কেল খরচ-BRIDGE SCALE EXP","ব্রীজ স্কেল খরচ","প্রেম তলা","1","2022-10-04 09:44:14");
INSERT INTO tbl_acledger VALUES("168","900071","9","21","APU","অপু","বিসিক শরীয়তপুর","1","2022-10-09 09:35:39");
INSERT INTO tbl_acledger VALUES("169","800115","8","20","সুদ হিসাব/INTEREST EXP","সুদ হিসাব/INTEREST EXP","সুদ হিসাব/INTEREST EXP","1","2022-11-28 12:00:09");
INSERT INTO tbl_acledger VALUES("170","800124","8","20","RANNA EXP রান্না খরচ","RANNA","RANNA EXP","1","2023-03-27 11:48:33");
INSERT INTO tbl_acledger VALUES("171","900073","9","21","দান খরচ Dan Exp","দান খরচ Dan Exp","","1","2023-04-03 09:20:51");
INSERT INTO tbl_acledger VALUES("172","800125","8","20","HARD WARE","HARD WARE ","","1","2023-04-19 03:42:19");
INSERT INTO tbl_acledger VALUES("173","800126","8","20","গোড়াউন খরচ ( Godwan Expens)","গোড়াউন খরচ","","1","2023-06-08 06:21:59");
INSERT INTO tbl_acledger VALUES("174","900075","9","21","OFFICE NASTA","","","1","2024-01-29 02:08:06");
INSERT INTO tbl_acledger VALUES("175","900076","9","21","DIsh Bill","","","1","2024-03-02 12:12:03");
INSERT INTO tbl_acledger VALUES("176","900077","9","21","Fetra ফেতরা","","","1","2024-04-05 07:39:48");
INSERT INTO tbl_acledger VALUES("177","800128","8","20","ELLECTRICITE EXP","","","1","2024-05-15 02:23:32");
INSERT INTO tbl_acledger VALUES("178","900078","9","21","Bonus","","BONUS","1","2024-06-16 04:47:57");
INSERT INTO tbl_acledger VALUES("179","800129","8","20","MEDICINE ","","","1","2024-07-08 08:04:35");



CREATE TABLE `tbl_acmobile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `mobile` varchar(18) NOT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_bacount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bid` int(11) NOT NULL,
  `branch` varchar(45) DEFAULT NULL,
  `bbranch` varchar(255) DEFAULT NULL,
  `acno` varchar(25) NOT NULL,
  `title` varchar(45) NOT NULL,
  `location` varchar(250) NOT NULL,
  `brcode` varchar(6) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_bacount VALUES("2","4","Shariatpur","","274190133580","Talukder Agro Firm","Shariatpur","1901","1","2022-05-05 11:29:53");
INSERT INTO tbl_bacount VALUES("3","5","Shariatpur","","1139004411225","Talukder Agro Firm","Shariatpur","9004","1","2022-05-05 11:52:17");
INSERT INTO tbl_bacount VALUES("4","6","Shariatpur","","16246","Talukder Food Industries","Shariatpur","16246","1","2022-05-05 11:53:40");
INSERT INTO tbl_bacount VALUES("5","7","SHARIATPUR TOWN","","2741902001275","M/S TALUKDER FOOD INDUSTRIES","PALANG,SHARIATPUR","175860","1","2022-06-06 10:13:03");
INSERT INTO tbl_bacount VALUES("6","8","SHARIATPUR","","235212200211469","M/S TALUKDER AGRO FARM","SADAR,SHARIATPUR","250860","1","2022-06-06 10:29:31");
INSERT INTO tbl_bacount VALUES("7","4","TOWN BRANCH","","2741901033580","TALUKDER AGRO FARM","SADAR,SHARIATPUR","175860","1","2022-06-07 07:55:46");
INSERT INTO tbl_bacount VALUES("8","9","DOMSHAR BAZAR","","7017419718250","JINURAIN TALUKDER LEAN","DOMSHAR,SADAR ,SHARIATPUR","017240","1","2022-07-14 02:15:20");
INSERT INTO tbl_bacount VALUES("9","10","শরীয়তপুর শাখা","","20502510100253005","তালুকদার ফুড ইন্ডাস্ট্রিজ-২","পালং শরীয়তপুর","80002","1","2022-08-31 09:12:26");
INSERT INTO tbl_bacount VALUES("10","18","SHARIATPUR","","1139006183777","BOYATI ENGENIARING WORKSHOP","SHARIATPUR SADAR","1139","1","2024-06-11 06:37:27");



CREATE TABLE `tbl_bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` varchar(6) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_bank VALUES("4","PBL","Pubali Bank Ltd","","1","2022-05-05 11:23:05");
INSERT INTO tbl_bank VALUES("5","NBL","National Bank LTD.","","1","2022-05-05 11:23:53");
INSERT INTO tbl_bank VALUES("6","EBL","Exim Bank LTD.","","1","2022-05-05 11:24:22");
INSERT INTO tbl_bank VALUES("7","PBL CC","PUBALI BANK LTD 1275","","1","2022-06-06 09:55:05");
INSERT INTO tbl_bank VALUES("8","UBL","UTTARA BANK LTD","","1","2022-06-06 10:33:28");
INSERT INTO tbl_bank VALUES("9","BBL","BRAC BANK LTD","","1","2022-07-14 02:12:25");
INSERT INTO tbl_bank VALUES("10","IBL","ISLAMI BANK LIMITED","","1","2022-08-31 09:09:25");
INSERT INTO tbl_bank VALUES("11","PBL 52","Pubali Bank LTD CURRENT","","1","2022-10-25 09:05:41");
INSERT INTO tbl_bank VALUES("12","T2 PBL","T-2 PUBALI BANK LTD","","1","2023-06-14 04:43:52");
INSERT INTO tbl_bank VALUES("13","1275 P","Pubali Bank PLC-1275","","1","2024-03-21 03:49:25");
INSERT INTO tbl_bank VALUES("14","NBL","NATIONAL BANK PLC","","1","2024-03-21 03:50:21");
INSERT INTO tbl_bank VALUES("15","IBL","ISLAMI BANK PLC","","1","2024-03-21 03:50:47");
INSERT INTO tbl_bank VALUES("16","P 1499","Pubali Bank PLC 1499","","1","2024-03-21 03:51:18");
INSERT INTO tbl_bank VALUES("17","P29400","Pubali Bank PLC-29400","","1","2024-03-21 03:58:33");
INSERT INTO tbl_bank VALUES("18","NBP","NATIONAL BANK SHAHIN","","1","2024-06-11 06:32:45");



CREATE TABLE `tbl_banktra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` double(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_banktra VALUES("1","TRN120522101","","3352391.00","2022-05-12","0","1","2022-05-12 05:13:35");
INSERT INTO tbl_banktra VALUES("2","TRN120522102","","600000.00","2022-05-12","0","1","2022-05-12 05:15:15");
INSERT INTO tbl_banktra VALUES("3","TRN300522101","","50000.00","2022-05-30","0","1","2022-05-30 01:10:45");
INSERT INTO tbl_banktra VALUES("4","TRN300522102","","100000.00","2022-05-30","0","1","2022-05-30 01:11:54");



CREATE TABLE `tbl_banktrade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `seid` int(11) NOT NULL,
  `brid` int(11) DEFAULT 0,
  `cid` int(11) NOT NULL,
  `cty` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `did` int(11) NOT NULL,
  `dty` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_banktrade VALUES("1","1","0","2","BA","3352391.00","2","LE","120522101","2022-05-12","0","");
INSERT INTO tbl_banktrade VALUES("2","2","0","2","BA","600000.00","2","LE","120522102","2022-05-12","0","");
INSERT INTO tbl_banktrade VALUES("3","3","0","3","BA","50000.00","2","LE","290522101","2022-05-29","0","");
INSERT INTO tbl_banktrade VALUES("4","4","0","2","LE","100000.00","2","BA","","","0","29-05-22");



CREATE TABLE `tbl_branch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `address` varchar(250) NOT NULL,
  `baddress` varchar(350) DEFAULT NULL,
  `phone` varchar(18) NOT NULL,
  `email` varchar(45) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(35) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_brand VALUES("1","শক্তি","","","1","2023-01-11 01:06:13");



CREATE TABLE `tbl_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_category VALUES("1","2","চিকন ভূষি","","","1","2022-05-05 09:36:51");
INSERT INTO tbl_category VALUES("2","4","কাটিং ভুট্টা","","","1","2022-05-05 09:37:09");
INSERT INTO tbl_category VALUES("3","5","গমের বস্তা","","","1","2022-05-05 09:37:35");
INSERT INTO tbl_category VALUES("4","5","গমের ময়লা/ ফিল্টার","","","1","2022-05-05 09:37:51");
INSERT INTO tbl_category VALUES("5","5","লাল গম","","","1","2022-05-05 09:38:06");
INSERT INTO tbl_category VALUES("6","2","মোটা ভূষি","","","1","2022-05-05 09:38:21");
INSERT INTO tbl_category VALUES("7","3","নরমাল ময়দা","","","1","2022-05-05 09:38:37");
INSERT INTO tbl_category VALUES("8","1","ও.এম.এস আটা","","","1","2022-05-05 09:39:00");
INSERT INTO tbl_category VALUES("9","5","সাদা গম","","","1","2022-05-05 09:39:17");
INSERT INTO tbl_category VALUES("10","1","শক্তি আটা","","","1","2022-05-05 09:39:33");
INSERT INTO tbl_category VALUES("11","3","স্পেশাল ময়দা","","","1","2022-05-05 09:39:51");
INSERT INTO tbl_category VALUES("12","4","ভুট্টার গুড়া","","","1","2022-05-05 09:40:06");



CREATE TABLE `tbl_cheqman` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientid` int(11) DEFAULT NULL,
  `type` varchar(2) DEFAULT NULL,
  `chkno` varchar(30) NOT NULL,
  `chkdt` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `acid` int(11) DEFAULT NULL,
  `refinv` varchar(30) DEFAULT NULL,
  `chbnkid` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `ref` varchar(255) DEFAULT NULL,
  `paymod` varchar(5) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `apdate` datetime NOT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_cheqman VALUES("1","6","CU","120522103","2022-05-12","100000.00","2","REV120522103","","","","REC","1","2022-05-12 00:00:00","0","1","2022-05-12 05:18:00");
INSERT INTO tbl_cheqman VALUES("2","41","CU","120522104","2022-05-12","636400.00","2","REV120522104","","","370 বস্তাভূষি ","REC","1","2022-05-12 00:00:00","0","1","2022-05-12 05:20:24");
INSERT INTO tbl_cheqman VALUES("3","4","SU","16-05-2022","2022-05-16","4000000.00","2","PAV160522102","","","","PAY","1","2022-05-16 00:00:00","0","1","2022-05-16 05:44:31");
INSERT INTO tbl_cheqman VALUES("4","4","SU","2022-05-17","2022-05-16","2885000.00","2","PAV160522102","","","","PAY","1","2022-05-16 00:00:00","0","1","2022-05-16 05:44:31");
INSERT INTO tbl_cheqman VALUES("5","10","SU","2022-05-16","2022-05-16","5115000.00","2","PAV160522103","","","18","PAY","1","2022-05-16 00:00:00","0","1","2022-05-16 06:35:36");
INSERT INTO tbl_cheqman VALUES("6","10","SU","2022-05-16","2022-05-16","1000.00","3","PAV160522104","","","19","PAY","1","2022-05-16 00:00:00","0","1","2022-05-16 06:36:17");
INSERT INTO tbl_cheqman VALUES("7","10","SU","2022-05-16","2022-05-16","2885000.00","2","REV160522104","","","","REC","1","2022-05-16 00:00:00","0","1","2022-05-16 06:49:23");
INSERT INTO tbl_cheqman VALUES("8","44","CU","19","2022-05-17","50000.00","3","REV170522101","","","","REC","1","2022-05-17 00:00:00","0","1","2022-05-17 06:04:47");
INSERT INTO tbl_cheqman VALUES("9","1","SU","2022-05-20","2022-05-18","2700000.00","2","PAV180522103","","","20","PAY","1","2022-05-18 00:00:00","0","1","2022-05-18 03:54:00");
INSERT INTO tbl_cheqman VALUES("10","10","SU","2022-05-20","2022-05-18","390000.00","2","PAV180522104","","","20","PAY","1","2022-05-18 00:00:00","0","1","2022-05-18 06:12:16");
INSERT INTO tbl_cheqman VALUES("11","10","SU","2022-05-22","2022-05-22","300000.00","2","PAV220522104","","","","PAY","1","2022-05-22 00:00:00","0","1","2022-05-22 04:21:30");
INSERT INTO tbl_cheqman VALUES("12","10","SU","2022-05-22","2022-05-22","550000.00","2","PAV220522105","","","","PAY","1","2022-05-22 00:00:00","0","1","2022-05-22 04:22:32");
INSERT INTO tbl_cheqman VALUES("13","56","CU","মোঃ সজিব মীর মালত","2022-05-22","1028000.00","2","PAV220522106","","","","PAY","1","2022-05-22 00:00:00","0","1","2022-05-22 04:29:05");
INSERT INTO tbl_cheqman VALUES("14","33","CU","2022-05-22","2022-05-22","100000.00","2","PAV220522107","","","","PAY","1","2022-05-22 00:00:00","0","1","2022-05-22 04:47:35");
INSERT INTO tbl_cheqman VALUES("16","6","CU","230522101","2022-05-23","57000.00","2","REV060622101","","","","REC","1","2022-06-06 00:00:00","0","1","2022-06-06 09:49:55");
INSERT INTO tbl_cheqman VALUES("17","10","SU","2022-06-26","2022-06-26","903500.00","3","PAV260622108","","","","PAY","1","2022-06-26 00:00:00","0","1","2022-06-26 05:35:58");
INSERT INTO tbl_cheqman VALUES("18","10","SU","2022-06-26","2022-06-26","150000.00","3","PAV260622108","","","","PAY","1","2022-06-26 00:00:00","0","1","2022-06-26 05:35:58");
INSERT INTO tbl_cheqman VALUES("22","10","CU","11225","2022-09-06","250000.00","3","SEL070922116","5","","","REC","3","2022-09-07 00:00:00","0","1","2022-09-07 07:07:24");



CREATE TABLE `tbl_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `cperson` varchar(45) DEFAULT NULL,
  `bcperson` varchar(255) DEFAULT NULL,
  `mname` varchar(45) DEFAULT NULL,
  `cnumber` varchar(18) NOT NULL,
  `cphone` varchar(14) DEFAULT NULL,
  `cemail` varchar(45) DEFAULT NULL,
  `nid` varchar(20) DEFAULT NULL,
  `creditlimit` double DEFAULT 0,
  `crepreiod` int(11) NOT NULL DEFAULT 0,
  `address` varchar(200) DEFAULT NULL,
  `baddress` varchar(350) DEFAULT NULL,
  `saddress` varchar(200) DEFAULT NULL,
  `did` int(11) DEFAULT NULL,
  `zid` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=124 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_customer VALUES("1","ABA/CU/001","আঃ কুদ্দুছ বেপারী ( KUDDUS BAPARY )","","","","","01720854612","","","","0","0","মুন্সিরহাট,ডোমসার,শরীয়তপুর","","","","","0","1","1","2022-05-05 11:13:50");
INSERT INTO tbl_customer VALUES("2","ABA/CU/002","আঃ রব সিকদার ( ROB SIKDER )","","","","","01405692620","","","","0","0","রাজগঞ্জ বাজার,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-05 11:15:06");
INSERT INTO tbl_customer VALUES("3","ABA/CU/003","আলমগীর চৌকিদার ( ALOMGIR CHOKIDER )","","","","","01757479986","","","","0","0","উত্তর বালুরচর,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-05 11:16:11");
INSERT INTO tbl_customer VALUES("4","ABA/CU/004","ছোবাহান চৌকিদার SOBAHAN CHOWKIDER","","","","","01914102209","","","","0","0","প্রেমতলা, শরীয়তপুর ","","প্রেমতলা, শরীয়তপুর   ","","","0","1","1","2022-05-05 11:17:40");
INSERT INTO tbl_customer VALUES("5","ABA/CU/005","সালাউদ্দিন মাঝি ( SALA UDDIN MAJI )","","হাসেম মাঝি","","","01718236793","","","","0","0","নড়িয়া গোডান রোড,নড়িয়া,শরিয়তপুর","","","","","0","1","1","2022-05-05 01:01:16");
INSERT INTO tbl_customer VALUES("6","ABA/CU/006","ARMAN ALI (আরমান আলী)","","","","","01737040810","","","","0","0","রাজারচর,মাদারীপুর","","","23","","0","1","1","2022-05-08 09:02:13");
INSERT INTO tbl_customer VALUES("7","ABA/CU/007","BHAI BHAI ENTERPRISE (ভাই ভাই এন্টারপ্রাইজ)","","","","","01758176027","","","","0","0","ডগ্রিবাজার,শরীয়তপুর","","","","","0","1","1","2022-05-08 09:02:56");
INSERT INTO tbl_customer VALUES("8","ABA/CU/008","DELOWER MADBOR -দেলোয়ার মাদবর","","","","","01713584370","","","","0","0","চিকন্দি বাজার,পালং,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:08:15");
INSERT INTO tbl_customer VALUES("9","ABA/CU/009","DELOWER BISSHAS (দেলোয়ার বিশ্বাস )","","","","","01724144684","","","","0","0","আংগারিয়া বাজার,সদর, শরীয়তপুর ।","","","","","0","0","1","2022-05-08 09:12:00");
INSERT INTO tbl_customer VALUES("10","ABA/CU/010","দেলোয়ার ফকির-DELOWER FAKIR","","","","","01890183034","","","","0","0","কাজিরহাট,জাজিরা, শরীয়তপুর","","","","","0","1","1","2022-05-08 09:12:39");
INSERT INTO tbl_customer VALUES("11","ABA/CU/011","DELOWER HOWLADER (দেলোয়ার হাওলাদার)","","মাঝি","","","01716019517","","","","0","0","ভোজেশ্বর নদীরপাড়,নড়িয়া,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:14:48");
INSERT INTO tbl_customer VALUES("12","ABA/CU/012","EAKUB ALI PAHAR (ইয়াকুব আলী পাহাড়)","","","","","01724369837","","","","0","0","বটতলা,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:15:26");
INSERT INTO tbl_customer VALUES("13","ABA/CU/013","EAKUB HOSEN (ইয়াকুব হোসেন)","","","","","01915960707","","","","0","0","আংগারিয়া বাজার,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:16:08");
INSERT INTO tbl_customer VALUES("14","ABA/CU/014","FARHAD SARDER (ফরহাদ সরদার)","","","","","01714576303","","","","0","0","আংগারিয়া বাজার,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:16:43");
INSERT INTO tbl_customer VALUES("15","ABA/CU/015","GOPAL SHAHA (গোপাল সাহা)","","","","","01712287320","","","","0","0","আংগারিয়া বাজার,শরীয়তপুর","","","","","0","1","1","2022-05-08 09:17:13");
INSERT INTO tbl_customer VALUES("17","ABA/CU/017","IMRAN BAPARY (ইমরান বেপারী )","","","","","01774030613","","","","0","0","নরকলিকাতা,নড়িয়া,শরীয়তপুর ।","","নরকলিকাতা,নড়িয়া,শরীয়তপুর ।","","","0","1","1","2022-05-08 09:21:53");
INSERT INTO tbl_customer VALUES("18","ABA/CU/018","Ronjit Dey রনজিৎ দে","","","","","01716662990","","","","0","0","বালারবাজার,রূদকর,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:24:35");
INSERT INTO tbl_customer VALUES("19","ABA/CU/019","JANE ALOM MUNSHI (জানে আলম মুন্সি)","","","","","01921582094","","","","0","0","পৌর মার্কেট,সদর শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:25:13");
INSERT INTO tbl_customer VALUES("20","ABA/CU/020","JASIM FAKIR (জসিম ফকির)","","","","","01918210995","","","","0","0","ভোজেশ্বর নদীর পাড় বাজার,নড়িয়া,শরয়িতপুর","","","","","0","1","1","2022-05-08 09:25:42");
INSERT INTO tbl_customer VALUES("21","ABA/CU/021","JUEL SARDER (জুয়েল সরদার)","","","","","01918411928","","","","0","0","ভোজেশ্বর,শরীয়তপুর","","","","","0","1","1","2022-05-08 09:26:41");
INSERT INTO tbl_customer VALUES("22","ABA/CU/022","Kalam Mollla (কালাম মোল্লা)","","","","","01768996509","","","","0","0","আংগারিয়া বাজার,পালং,শরীয়তপুর ","","আংগারিয়া বাজার,পালং,শরীয়তপুর ","","","0","1","1","2022-05-08 09:27:17");
INSERT INTO tbl_customer VALUES("23","ABA/CU/023","KASEM SRDER ( কাসেম সরদার)","","","","","01304310680","","","","0","0","আংগারিয়া বাজার, পালং,শরীয়তপুর ।","","আংগারিয়া বাজার, পালং,শরীয়তপুর ।","","","0","1","1","2022-05-08 09:28:10");
INSERT INTO tbl_customer VALUES("24","ABA/CU/024","Khalil Sarder (খলিল সরদার)","","","","","01933601367","","","","0","0","চৌরঙ্গীর মোড়,ক্লাব রোড,সদর,শরীয়তপুর ।","","চৌরঙ্গীর মোড়,ক্লাব রোড,সদর,শরীয়তপুর ।","","","0","1","1","2022-05-08 09:28:48");
INSERT INTO tbl_customer VALUES("25","ABA/CU/025","LEAN TALUKDER( লিয়েন তালুকদার)","","","","","01728882561","","","","0","0","পশ্চিম কাশাভোগ,আংগারিয়া,সদর,শরীয়তপুর ।","","পশ্চিম কাশাভোগ,আংগারিয়া,সদর,শরীয়তপুর ।","","","0","1","1","2022-05-08 09:29:40");
INSERT INTO tbl_customer VALUES("26","ABA/CU/026","MAHSIN MADBOR (মহসিন মাদবর)","","","","","01739525483","","","","0","0","ধানুকা বাজার,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:30:12");
INSERT INTO tbl_customer VALUES("27","ABA/CU/027","MAMUN MADBOR (মামুন মাদবর)","","","","","01904396436","","","","0","0","প্রেমতলা,পালং,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:31:46");
INSERT INTO tbl_customer VALUES("28","ABA/CU/028","MONIR HOSEN SIKDER মনির হোসেন সিকদার","","","","","01912227126","01912227126","","","0","0","মনোহর বাজার,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:32:20");
INSERT INTO tbl_customer VALUES("29","ABA/CU/029","MASUM DHALI (মাছুম ঢালী)","","","","","01713823902","","","","0","0","ডোমসার,শরীয়তপুর","","","","","0","1","1","2022-05-08 09:32:47");
INSERT INTO tbl_customer VALUES("30","ABA/CU/030","MILON MALOT ( মিলন মালত )","","","","","01743343290","","","","0","0","ভোজেশ্বর নদীর পাড় বাজার,নড়িয়া,শরিয়তপুর","","","","","0","1","1","2022-05-08 09:33:16");
INSERT INTO tbl_customer VALUES("32","ABA/CU/032","PAVEL SARDER (পাভেল সরদার)","","","","","01914501426","","","","0","0","মঠের বাজার,মাদারীপুর","","","","","0","1","1","2022-05-08 09:34:47");
INSERT INTO tbl_customer VALUES("33","ABA/CU/033","RAHMAN DAIRY FIRM (রহমান ডেইরি ফার্ম)","","","","","01966826310","","","","0","0","পূর্ব কোটাপাড়া,বালাখানা,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:35:14");
INSERT INTO tbl_customer VALUES("34","ABA/CU/034","Rasel Angle ( রাসেল এঙ্গেল )","","","","","01766747888","","","","0","0","শৌলপাড়া.জাজিরা,শরীয়তপুর ।","","শৌলপাড়া.জাজিরা,শরীয়তপুর ।","","","0","1","1","2022-05-08 09:35:40");
INSERT INTO tbl_customer VALUES("35","ABA/CU/035","Rason Store Sariatpur (রেসন ষ্টোর )","","","","","01715123426","","","","0","0","Sp Sariatpur","","","","","0","1","1","2022-05-08 09:36:18");
INSERT INTO tbl_customer VALUES("37","ABA/CU/037","SAPON MUNSI (স্বপন মুন্সি)","","","","","01712475003","","","","0","0","পালং উত্তর বাজার,সদর,শরীয়তপুর ।","","","","","0","1","1","2022-05-08 09:37:43");
INSERT INTO tbl_customer VALUES("38","ABA/CU/038","SUDEB MONDOL (সুদেব মন্ডল)  ","","","","","01712139689","","","","0","0","টরকী,গৌরনদী,বরিশাল","","","","","0","1","1","2022-05-08 09:38:17");
INSERT INTO tbl_customer VALUES("39","ABA/CU/039","শামসুর নাহার জান্নাত-Samshur Nahar Jannat ","","","","","01921236500","","","","0","0","আংগারিয়া বজার,সদর,শরীয়তপুর ।","","আংগারিয়া বজার,সদর,শরীয়তপুর ।","","","0","1","1","2022-05-08 09:39:17");
INSERT INTO tbl_customer VALUES("40","ABA/CU/040","YOUNUS AKON (ইউনুছ আকন)","","","","","01913258164","","","","0","0","প্রেমতলা,শরীয়তপুর","","","","","0","1","1","2022-05-08 09:39:55");
INSERT INTO tbl_customer VALUES("41","ABA/CU/041","মাঝি এন্টারপ্রাইজ (MAJI Enterprise)","","","","","01732999584","","","","0","0","ঘড়িসার বাজার, নড়িয়া,শরীয়তপুর।","","ঘড়িসার বাজার, নড়িয়া,শরীয়তপুর।

","","","0","1","1","2022-05-08 09:40:16");
INSERT INTO tbl_customer VALUES("42","ABA/CU/042","মেসার্স হারুন ইন্ডষ্ট্রিজ ( HARUN INDUSTRIES)","","","","","01711853979","","","","0","0","গোয়ালচামট,ফরিদপুর","","","","","0","1","1","2022-05-08 09:41:26");
INSERT INTO tbl_customer VALUES("44","ABA/CU/044","মন্তোষ কর্মকার ( MONTOS KORMOKER )","","","","","01765430314","","","","0","0","ঠাকুর বাজার শিবচর, মাদারীপুর","","","","","0","1","1","2022-05-12 04:39:11");
INSERT INTO tbl_customer VALUES("45","ABA/CU/045","জাজিরা ও.এম, এস ডিলার","","","","","01714922227","","","","0","0","জাজিরা ও.এম, এস ডিলার","","","","","0","1","1","2022-05-12 06:29:39");
INSERT INTO tbl_customer VALUES("46","ABA/CU/046","নড়িয়া ও, এম, এস ডিলার","","","","","01726878220","","","","0","0","নড়িয়া ও, এম, এস ডিলার","","","","","0","1","1","2022-05-12 06:36:33");
INSERT INTO tbl_customer VALUES("47","ABA/CU/047","ভেদরগঞ্জ ও, এম, এস ডিলার","","","","","01611232327","","","","0","0","ভেদরগঞ্জ ও, এম, এস ডিলার","","","","","0","1","1","2022-05-12 06:46:12");
INSERT INTO tbl_customer VALUES("48","ABA/CU/048","গোসাইরহাট ( GOSHAIRHAT )","","","","","01712310207","","","","0","0","গোসাইরহাট ও, এম, এস ডিলার","","","","","0","1","1","2022-05-12 06:47:14");
INSERT INTO tbl_customer VALUES("49","ABA/CU/049","ডামুড্যা ও, এম, এস ডিলার","","","","","01814980783","","","","0","0","ডামুড্যা ও, এম, এস ডিলার","","","","","0","1","1","2022-05-12 06:48:17");
INSERT INTO tbl_customer VALUES("51","ABA/CU/051","ঝিলন খান ( JILON KHAN )","","","","","01755888125","","","","0","0","কোটাপাড়া বাজার","","","","","0","1","1","2022-05-14 04:32:34");
INSERT INTO tbl_customer VALUES("52","ABA/CU/052","ফারুক খালাসি-FARUK KHALSI","","","","","01735721055","","","","0","0","কাজিরহাট","","","","","0","1","1","2022-05-14 04:37:51");
INSERT INTO tbl_customer VALUES("53","ABA/CU/053","পল্টু সাহা -POLTU SHAHA","","","","","01733798098","","","","0","0","টেকেরহাট, রাজৈর মাদারীপুর","","","","","0","1","1","2022-05-14 06:50:08");
INSERT INTO tbl_customer VALUES("54","ABA/CU/054","আঃ কুদ্দুস হাওলাদার ( Kuddus Hawlader)","","","","","01724369873","","","","0","0","ডগ্রিবাজার,রাজনগর,নড়িয়া,শরীয়তপুর ।","","ডগ্রিবাজার,রাজনগর,নড়িয়া,শরীয়তপুর ।","","","0","1","1","2022-05-16 05:46:41");
INSERT INTO tbl_customer VALUES("55","ABA/CU/055","আলমগীর মোল্লা ( ALOMGIR MOLLA )","","","","","আলমগীর মোল্লা","","","","0","0","আংগারিয়া বাজার","","","","","0","1","1","2022-05-17 02:11:38");
INSERT INTO tbl_customer VALUES("56","ABA/CU/056","মোঃ সজিব মীর মালত ( SAJIB MIR MALOT )","","","","","মোঃ সজিব মীর মালত","","","","0","0","মডেল টাউন, সদর,রোড,শরীয়তপুর।","","","","","0","1","1","2022-05-22 04:28:31");
INSERT INTO tbl_customer VALUES("58","ABA/CU/058","মুন এন্টারপ্রাইজ (MOON ENTERPRISE)","","","","","01714977871","","","","0","0","পালং বাজার,সদর,শরীয়তপুর ।","","পালং বাজার,সদর,শরীয়তপুর ।","","","0","1","1","2022-06-04 01:37:04");
INSERT INTO tbl_customer VALUES("60","ABA/CU/060","গাগ্রিজোড়া জমি ( GAGRIZORA LAND )","","","","","01716583953","","","","0","0","গাগ্রিজোড়া নড়িয়া, শরীয়তপুর","","","","","0","1","1","2022-06-07 06:35:34");
INSERT INTO tbl_customer VALUES("61","ABA/CU/061","PRAN KRISNO PAUL (প্রান কৃঞ্চ পাল)","","","","","01724747822","","","","0","0","ভোজেশ্বর দানা পট্টি,নড়িয়া,শরীয়তপুর ।","","ভোজেশ্বর দানা পট্টি,নড়িয়া,শরীয়তপুর ।","","","0","0","1","2022-06-08 03:31:11");
INSERT INTO tbl_customer VALUES("62","ABA/CU/062","ফিড মিল ( তালুকদার ফুড -২) Feed Mill","","লিয়েন তালুকদার","","","01951338055","","","","0","0","এ, ১৩-১৪, বিসিক শিল্পনগরী, শরীয়তপুর।","","","","","0","1","1","2022-06-11 03:53:51");
INSERT INTO tbl_customer VALUES("63","ABA/CU/063","জনতা ফুড প্রোডাক্ট ( Janata Food Product)","","","","","01684679920","01637089925","","","0","0","বাতাসা পট্রি পুরান বাজার, চাঁদপুর","","বাতাসা পট্রি পুরান বাজার, চাঁদপুর","","","0","1","1","2022-06-19 04:54:42");
INSERT INTO tbl_customer VALUES("64","ABA/CU/064","আড়িগাঁও পুকুর -Arigao Pukur,Kashem Talukder","","","","","01871577248","","","","0","0","আরিগাও,হ্যালিপেড,শরীয়তপুর ","","আরিগাও,হ্যালিপেড,শরীয়তপুর ","","","0","0","1","2022-06-24 11:45:37");
INSERT INTO tbl_customer VALUES("65","ABA/CU/065","ফাহাদ স্টোর, FAHAD STORE","","","","","01912855152","01912855152","","","0","0","পাইলট মোড় ,ভোজেশ্বর , শরীয়তপুর ","","পাইলট মোড় ,ভোজেশ্বর , শরীয়তপুর ","","","0","0","1","2022-06-24 11:47:14");
INSERT INTO tbl_customer VALUES("66","ABA/CU/066","NAHID MAMONY TRADERS-নাহিদ মামনী ট্রের্ডাস","","","","","0192750573","01927501573","","","0","0","পালং উত্তর বাজার,শরয়িতপুর ।","","পালং উত্তর বাজার,শরয়িতপুর ।","","","0","1","1","2022-06-27 06:25:03");
INSERT INTO tbl_customer VALUES("67","ABA/CU/067","চিকন্দী কাজ (লিয়েন)  CHIKONDI CONTRACT (LEAN)","","","","","01724043994","","","","0","0","চিকন্দী,আংগারিয়া ,সদর,শরীয়তপুর","","আংগারিয়া ,সদর,শরীয়তপুর","","","0","1","1","2022-07-16 09:24:40");
INSERT INTO tbl_customer VALUES("68","ABA/CU/068","মোঃ মুনসেফ সরদার Munsef Sarder","","","","","01712535753","","","","0","0","আংগারিয়া বাজার","","আংগারিয়া বাজার","","","0","1","1","2022-07-19 06:54:15");
INSERT INTO tbl_customer VALUES("69","ABA/CU/069","EVA POLTRI AND FISH FEED ইভা পোল্টি এন্ড ফিস ","","","","","01816604282","01734413495","","","0","0","টাকা বাড়ি,জল্লা,উজিরপুর,বরিশাল","","টাকা বাড়ি,জল্লা,উজিরপুর,বরিশাল","","","0","1","1","2022-07-28 08:37:47");
INSERT INTO tbl_customer VALUES("70","ABA/CU/070","SHIMUL STORE-শিমুল স্টোর","","","","","01712434981","","","","0","0","TORKI BONDHOR,BARISHAL","","","","","0","1","1","2022-08-06 09:50:05");
INSERT INTO tbl_customer VALUES("71","ABA/CU/071","GOBINDO SHAHA গোবিন্দ সাহা","","","","","01715648822","","","","0","0","টরকী বন্দর, গৌরনদী,বরিশাল। ","","","","","0","1","1","2022-08-23 12:02:50");
INSERT INTO tbl_customer VALUES("73","ABA/CU/073","বাহাদুর হাওলাদা Bahadur Hawlader","","","","","01713821049","","","","0","0","কাঠালবাড়ী ঘাট,শরীয়তপুর","","কাঠালবাড়ী ঘাট,শরীয়তপুর","","","0","1","1","2022-09-01 08:28:31");
INSERT INTO tbl_customer VALUES("74","ABA/CU/074","কামরুল হাসান(KAMRUL HASAN)","","","","","01919731606","","","","0","0","সিকারপুর, ফেরিঘাট, বরিশাল","","","","","0","1","1","2022-09-05 01:45:29");
INSERT INTO tbl_customer VALUES("75","ABA/CU/075","মোঃ রুবেল- MD.RUBEL","","","","","01711229938","","","","0","0","শিকারপুর ফেরীঘাট,বরিশাল","","শিকারপুর ফেরীঘাট,বরিশাল","","","0","1","1","2022-09-06 08:19:04");
INSERT INTO tbl_customer VALUES("76","ABA/CU/076","খোকন শাহ(Khokon Sha)","","","","","01722387083","","","","0","0","ভদ্রশন বাজার, মাদারীপুর","","","","","0","1","1","2022-09-11 06:05:41");
INSERT INTO tbl_customer VALUES("77","ABA/CU/077","বিশ্বনাথ দাস--Bishonath Das","","","","","01727788888","","","","0","0","আংগারিয়া বাজার,পালং,শরীয়তপুর","","","","","0","1","1","2022-09-12 03:32:05");
INSERT INTO tbl_customer VALUES("79","ABA/CU/079","মোকাম লিঃ -Mokam LTD -Shariatpur","","সাফায়াত ","","","01713357136","","","","0","0","শরীয়তপুর, জজ কোর্ট","","","","","0","0","1","2022-09-19 10:44:04");
INSERT INTO tbl_customer VALUES("80","ABA/CU/080","মোকাম লিঃ MOKAM LTD-MADARIPUR","","Sahin Madaripur","","","01325072354","","","","0","0","মাদারীপুর  সদর,মাদারীপুর ","","","","","1","0","1","2022-09-25 10:46:12");
INSERT INTO tbl_customer VALUES("81","ABA/CU/081","SALAM STORE-সালাম স্টোর","","","","","01934064547","","","","0","0","মাদবরেরচর,শিবচর,মাদারীপুর","","মাদবরেরচর,শিবচর,মাদারীপুর","23","","0","1","1","2022-09-30 06:08:56");
INSERT INTO tbl_customer VALUES("82","ABA/CU/082","মোঃ লিয়াকত খান","","","","","01726696923","","","","0","0","পশ্চিম কোটাপাড়া,পালং শরীয়তপুর","","পশ্চিম কোটাপাড়া,পালং শরীয়তপুর","","","0","1","1","2022-10-15 05:17:16");
INSERT INTO tbl_customer VALUES("83","ABA/CU/083","ভজন কুন্ডু BOJON KUNDHU-বাপ্পী কুন্ডু","","বাপ্পী কুন্ডু","","","01887557299","01711269586","","","0","0","টরকি বন্দর,গৌরনদী,বরিশাল ","","","","","0","1","1","2022-10-23 09:37:13");
INSERT INTO tbl_customer VALUES("84","ABA/CU/084","বিনয় মন্ডল -BINOY MONDOL","","","","","01714452577","","","","0","0","টরকি বন্দর, গৌরনদী,বরিশাল","","","","","0","1","1","2022-10-31 10:40:54");
INSERT INTO tbl_customer VALUES("85","ABA/CU/085","সজিব সরদার- Sajib Sarder ","","","","","01712127735","","","","0","0","টরকি বন্দর, গৌরনদী,বরিশাল","","","","","0","1","1","2022-10-31 10:44:21");
INSERT INTO tbl_customer VALUES("86","ABA/CU/086","SATATA FISH FEED সততা ফিস ফিড","","","","","01941105445","","","","0","0","অপদাহাট,কোটালীপাড়া,গোপালগঞ্জ। ","","","","","0","1","1","2022-11-02 05:47:06");
INSERT INTO tbl_customer VALUES("88","ABA/CU/088","মেসার্স আজিজ ষ্টোর M/S. AZIZ STORE","","","","","01757842975","","","","0","0","গোসাইরহাঁট,শরীয়তপুর। ","","গোসাইরহাঁট,শরীয়তপুর। ","","","0","1","1","2022-12-12 02:51:10");
INSERT INTO tbl_customer VALUES("89","ABA/CU/089","মেরিন জাহান ডলি-Marin Jahan Doly","","বিল্লাল","","","01916707184","01911292478","","","0","0","মনোহর বাজার,শরীয়তপুর","","","","","111","1","1","2022-12-18 08:38:43");
INSERT INTO tbl_customer VALUES("91","ABA/CU/090","নিউ মডেল টাউন দোকান New Model Twon Dokan","","","","","01779329142","","","","0","0","বাস স্ট্যান্ড সংলগ্ন,সদর,শরীয়তপুর। ","","","","","0","1","1","2023-01-03 10:50:18");
INSERT INTO tbl_customer VALUES("92","ABA/CU/091","সৈয়দ মুন্সি Soyod Munsi","","","","","01864446185","01775782148","","","0","0","আংগারিয়া,বাজার,শরীয়তপুর ","","","","","128","1","1","2023-01-03 12:14:35");
INSERT INTO tbl_customer VALUES("93","ABA/CU/092","আসলাম সিকদার (ASLAM SIKDER) বাংলা বাজার","","","","","01718132832","","","","0","0","বাংলা বাজার","","বাংলা বাজার","","","0","1","1","2023-01-04 11:17:27");
INSERT INTO tbl_customer VALUES("94","ABA/CU/093","সাগর বৈদ্য - SAGOR BOYDDO","","","","","01789655046","","","","0","0","পাচ্চর,মাদারীপুর ","","পাচ্চর,মাদারীপুর ","","","0","1","1","2023-01-28 01:21:49");
INSERT INTO tbl_customer VALUES("95","ABA/CU/094","আক্কাস আলী মেম্বার Akkas Ali Member","","","","","01714879028","01714879028","","","0","0","পশ্চিমকোটাপাড়া,পালং,শরীয়তপুর।","","","","","128","1","1","2023-02-02 09:56:05");
INSERT INTO tbl_customer VALUES("96","ABA/CU/095","শ্যামল কুন্ড- SAMOL KUNDHO ","","","","",": 01712880338","","","","0","0","শিবচর,মাদারীপুর","","","","","0","1","1","2023-02-05 10:43:33");
INSERT INTO tbl_customer VALUES("97","ABA/CU/096","পুন্য রায় Punnoy Ray","","","","","01739452696","","","","0","0","টরকিবন্দর ","","","","","128","1","1","2023-02-06 10:40:32");
INSERT INTO tbl_customer VALUES("98","ABA/CU/097","দানেশ মহলদার","","","","","01741191077","","","","0","0","চন্দ্রপুর,সদর,শরীয়তপুর","","","","","0","0","1","2023-02-27 02:34:21");
INSERT INTO tbl_customer VALUES("99","ABA/CU/098","মোস্তাফা মোল্লা(Mostafa Molla)","","","","","01740513784","","","","0","0","গোলার বাজার, সখিপুর, শরীয়তপুর","","গোলার বাজার, সখিপুর, শরীয়তপুর","","","0","1","1","2023-03-01 11:37:04");
INSERT INTO tbl_customer VALUES("100","ABA/CU/099","মৃত্যুঞ্জয়(Mirtonjoy)","","","","","01733978342","","","","0","0","টরকী বন্দর, বরিশাল","","টরকী বন্দর, বরিশাল","","","0","1","1","2023-03-08 03:41:15");
INSERT INTO tbl_customer VALUES("101","ABA/CU/100","OMS YOUNUS AKON ওএমএস ইউনুস আকন","","","","","01816065017","","","","0","0","PREMTALA,PALONG,SHARIATPUR","","","","","0","1","1","2023-03-27 11:55:12");
INSERT INTO tbl_customer VALUES("102","ABA/CU/101","সালাউদ্দিন ষ্টোর SALAUDDIN STORE","","","","","01721880982","","","","0","0","মিয়ার হাট, কালকিনি, মাদারীপুর","","","","","0","1","1","2023-04-04 04:46:24");
INSERT INTO tbl_customer VALUES("103","ABA/CU/102","জাহাঙ্গীর শেখ  Jahangir Sheikh","","","","","01912879435","01912879435","","","0","0","পালং উওর বাজার ,শরীয়তপুর ","","","","","0","1","1","2023-05-25 05:31:35");
INSERT INTO tbl_customer VALUES("104","ABA/CU/103","SAJIB SOYAL সজিব ছৈয়াল","","","","","01741671604","01741671604","","","0","0","ভোজেশ্বর, নড়িয়া,শরীয়তপুর। ","","BOJESHOR,NARIA,SHARIATPUR","","","0","1","1","2023-06-07 06:19:18");
INSERT INTO tbl_customer VALUES("105","ABA/CU/104","মাহাবুব এন্টার প্রাইজ MAHABUB ENTERPRISE ","","","","","01771988851","","","","0","0","ভোজেশ্বর,বাজার ,দক্ষিন মাথায় ,কলেজ রোড","","","","","0","1","1","2023-06-19 11:11:43");
INSERT INTO tbl_customer VALUES("106","ABA/CU/105","মিঠুন খান Mithun Khan","","","","","01931614713","01931614713","","","0","0","চন্দ্রপুর,মাদারীপুর ","","","","","0","0","1","2023-07-10 05:53:54");
INSERT INTO tbl_customer VALUES("107","ABA/CU/106","বনিক ট্রেডার্স -BANIK TRADERS","","প্রো: সুমন বনিক ","","","01880768673","01880768673","","","0","0","চাঁদহাট,নগরকান্দা,ফরিদপুর ","","ফরিদপুর ","","","0","1","1","2023-07-15 02:39:54");
INSERT INTO tbl_customer VALUES("108","ABA/CU/107","RONY MADBOR রনি মাদবর ","","","","","01766848151","01766848151","","","0","0","কাজিরহাট,জাজিরা,শরীয়তপুর ","","কাজিরহাট,জাজিরা,শরীয়তপুর ","","","0","1","1","2023-07-22 10:39:15");
INSERT INTO tbl_customer VALUES("109","ABA/CU/108","দেলোয়ার শেখ - Delower Sheikh ","","","","","01791088100","","","","0","0","ভোজেশ্বর বাস স্ট্যান্ড","","","","","0","1","1","2023-07-25 01:17:40");
INSERT INTO tbl_customer VALUES("112","ABA/CU/111","LEADER AGRO BUSINESS LTD,লিডার এগ্রো বিজনেস ","","BABUL AKTER SHAHIN","","","01602863183","01602863183","","","0","0","SHARIATPUR","","","","","0","1","1","2023-08-23 12:31:54");
INSERT INTO tbl_customer VALUES("113","ABA/CU/112","Aman আমান ","","","","","01712507001","01712507001","","","0","0","স্টেডিয়াম ,ধানুকা,শরীয়তপুর। ","","স্টেডিয়াম ,ধানুকা,শরীয়তপুর। ","","","0","1","1","2023-08-23 08:55:11");
INSERT INTO tbl_customer VALUES("114","ABA/CU/113","MD. AMIR ALI-আমির আলী","","","","","01967229962","01967229962","","","0","0","শেখপুর,শিবচর,মাদারীপুর","","শেখপুর,শিবচর,মাদারীপুর","","","0","1","1","2023-08-26 08:49:37");
INSERT INTO tbl_customer VALUES("115","ABA/CU/114","নজরুল ইসলাম খান, Nazurl Islam Khan ","","","","","01759011410","","","","0","0","দক্ষিনবালুচড়া , শরীয়তপুর ","","দক্ষিনবালুচড়া , শরীয়তপুর ","","","0","1","1","2023-09-06 01:15:54");
INSERT INTO tbl_customer VALUES("116","ABA/CU/115","লিয়াকত খান বাড়ির পু Leaquat Khan Barir Pukur","","সাওন ","","","01915119757","01915119757","","","0","0","খিলগাও ডোমসার ,শরীয়তপুর ","","খিলগাও ডোমসার ,শরীয়তপুর ","","","0","1","1","2023-09-11 12:01:13");
INSERT INTO tbl_customer VALUES("117","ABA/CU/116","RUBEL -JEWEL SARDER,রুবেল -জুয়েল সরদার ","","","","","01775755292","01775755292","","","0","0","BOJHESHOR BAZAR,NARIA,SHARIATPUR","","ভোজেশ্বর ,নদীরপাড় ","","","0","1","1","2023-09-12 06:06:06");
INSERT INTO tbl_customer VALUES("119","ABA/CU/118","গৌরাঙ্গ ভান্ডার  - Gaurang Bhbnder","","","","","01712754465","","","","0","0","উজিরপুর,Ujipur","","উজিরপুর,Ujipur","","","0","0","1","2023-11-14 01:17:53");
INSERT INTO tbl_customer VALUES("120","ABA/CU/119","সাগর মাদবর - Shagor Madbor ","","","","","01909303147","","","","0","0","গ্লোরী তৈলের পাম,বাঘীয়া শরীয়তপুর ","","গ্লোরী তৈলের পাম,বাঘীয়া শরীয়তপুর ","","","0","1","1","2024-03-28 11:44:51");
INSERT INTO tbl_customer VALUES("121","ABA/CU/120","এম ভি ট্রেডিং  M V TRADING","","","","","01711202503","01718136622","","","0","0","স্টেশন রোড,খুলনা। ","","","","","0","1","1","2024-06-27 08:51:41");
INSERT INTO tbl_customer VALUES("122","ABA/CU/121","PALASH KHAN পলাশ খান","","","","","01778369657","","","","0","0","আংগারিয়া, শরীয়তপুর সদর,শরীয়তপুর। ","","","","","0","1","1","2024-08-01 11:36:18");
INSERT INTO tbl_customer VALUES("123","ABA/CU/122","SALIM TALUKDER সেলিম তালুকদার","","","","","01726106741","","","","0","0","গোলারবাজার,নড়িয়া,শরীয়তপুর। ","","","","","0","1","1","2024-08-01 02:32:00");



CREATE TABLE `tbl_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `apdate` datetime NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=578 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_expenses VALUES("1","EXP210324101","","21580.00","2024-03-21 00:00:00","0","1","2024-03-21 04:07:56");
INSERT INTO tbl_expenses VALUES("2","EXP210324102","","153000.00","2024-03-21 00:00:00","0","1","2024-03-21 06:46:27");
INSERT INTO tbl_expenses VALUES("3","EXP210324103","","560.00","2024-03-21 00:00:00","0","1","2024-03-21 06:50:09");
INSERT INTO tbl_expenses VALUES("4","EXP220324101","","10170.00","2024-03-22 00:00:00","0","1","2024-03-22 02:27:29");
INSERT INTO tbl_expenses VALUES("5","EXP220324102","","29648.00","2024-03-22 00:00:00","0","1","2024-03-22 09:43:28");
INSERT INTO tbl_expenses VALUES("6","EXP230324101","","23060.00","2024-03-23 00:00:00","0","1","2024-03-23 09:35:30");
INSERT INTO tbl_expenses VALUES("7","EXP230324102","","5425.00","2024-03-23 00:00:00","0","1","2024-03-23 02:18:31");
INSERT INTO tbl_expenses VALUES("8","EXP230324103","","100.00","2024-03-23 00:00:00","0","1","2024-03-23 02:36:13");
INSERT INTO tbl_expenses VALUES("9","EXP230324104","","715.00","2024-03-23 00:00:00","0","1","2024-03-23 03:46:21");
INSERT INTO tbl_expenses VALUES("10","EXP230324105","","900.00","2024-03-23 00:00:00","0","1","2024-03-23 09:28:59");
INSERT INTO tbl_expenses VALUES("11","EXP230324106","","7900.00","2024-03-23 00:00:00","0","1","2024-03-23 09:32:25");
INSERT INTO tbl_expenses VALUES("12","EXP240324101","","8820.00","2024-03-24 00:00:00","0","1","2024-03-24 10:57:38");
INSERT INTO tbl_expenses VALUES("13","EXP240324102","","2750.00","2024-03-24 00:00:00","0","1","2024-03-24 02:07:02");
INSERT INTO tbl_expenses VALUES("14","EXP240324103","","5040.00","2024-03-24 00:00:00","0","1","2024-03-24 04:12:30");
INSERT INTO tbl_expenses VALUES("15","EXP240324104","","2220.00","2024-03-24 00:00:00","0","1","2024-03-24 07:44:47");
INSERT INTO tbl_expenses VALUES("16","EXP240324105","","14290.00","2024-03-24 00:00:00","0","1","2024-03-24 08:54:52");
INSERT INTO tbl_expenses VALUES("17","EXP250324101","","50910.00","2024-03-25 00:00:00","0","1","2024-03-25 10:41:46");
INSERT INTO tbl_expenses VALUES("18","EXP250324102","","1120.00","2024-03-25 00:00:00","0","1","2024-03-25 02:16:50");
INSERT INTO tbl_expenses VALUES("19","EXP250324103","","19240.00","2024-03-25 00:00:00","0","1","2024-03-25 08:01:39");
INSERT INTO tbl_expenses VALUES("20","EXP260324101","","12830.00","2024-03-26 00:00:00","0","1","2024-03-26 12:34:42");
INSERT INTO tbl_expenses VALUES("21","EXP260324102","","6820.00","2024-03-26 00:00:00","0","1","2024-03-26 09:15:32");
INSERT INTO tbl_expenses VALUES("22","EXP270324101","","5665.00","2024-03-27 00:00:00","0","1","2024-03-27 01:13:21");
INSERT INTO tbl_expenses VALUES("23","EXP270324102","","1990.00","2024-03-27 00:00:00","0","1","2024-03-27 04:50:42");
INSERT INTO tbl_expenses VALUES("24","EXP270324103","","5400.00","2024-03-27 00:00:00","0","1","2024-03-27 09:10:40");
INSERT INTO tbl_expenses VALUES("25","EXP280324101","","6070.00","2024-03-28 00:00:00","0","1","2024-03-28 10:43:37");
INSERT INTO tbl_expenses VALUES("26","EXP280324102","","3200.00","2024-03-28 00:00:00","0","1","2024-03-28 02:43:09");
INSERT INTO tbl_expenses VALUES("27","EXP280324103","","720.00","2024-03-28 00:00:00","0","1","2024-03-28 04:58:08");
INSERT INTO tbl_expenses VALUES("28","EXP280324104","","15400.00","2024-03-28 00:00:00","0","1","2024-03-28 08:34:09");
INSERT INTO tbl_expenses VALUES("29","EXP290324101","","2370.00","2024-03-29 00:00:00","0","1","2024-03-29 05:40:45");
INSERT INTO tbl_expenses VALUES("30","EXP290324102","","8660.00","2024-03-29 00:00:00","0","1","2024-03-29 08:06:12");
INSERT INTO tbl_expenses VALUES("31","EXP300324101","","8185.00","2024-03-30 00:00:00","0","1","2024-03-30 11:55:44");
INSERT INTO tbl_expenses VALUES("32","EXP300324102","","17385.00","2024-03-30 00:00:00","0","1","2024-03-30 04:11:35");
INSERT INTO tbl_expenses VALUES("33","EXP300324103","","340.00","2024-03-30 00:00:00","0","1","2024-03-30 07:31:42");
INSERT INTO tbl_expenses VALUES("34","EXP310324101","","3145.00","2024-03-31 00:00:00","0","1","2024-03-31 11:01:22");
INSERT INTO tbl_expenses VALUES("35","EXP310324102","","2440.00","2024-03-31 00:00:00","0","1","2024-03-31 12:38:57");
INSERT INTO tbl_expenses VALUES("36","EXP310324103","","11000.00","2024-03-31 00:00:00","0","1","2024-03-31 02:06:27");
INSERT INTO tbl_expenses VALUES("37","EXP310324104","","229530.00","2024-03-31 00:00:00","0","1","2024-03-31 03:36:23");
INSERT INTO tbl_expenses VALUES("38","EXP310324105","","60.00","2024-03-31 00:00:00","0","1","2024-03-31 04:50:47");
INSERT INTO tbl_expenses VALUES("39","EXP310324106","","13715.00","2024-03-31 00:00:00","0","1","2024-03-31 08:35:39");
INSERT INTO tbl_expenses VALUES("40","EXP010424101","","1730.00","2024-04-01 00:00:00","0","1","2024-04-01 12:53:06");
INSERT INTO tbl_expenses VALUES("41","EXP010424102","","200420.00","2024-04-01 00:00:00","0","1","2024-04-01 03:41:19");
INSERT INTO tbl_expenses VALUES("42","EXP010424103","","30860.00","2024-04-01 00:00:00","0","1","2024-04-01 09:49:34");
INSERT INTO tbl_expenses VALUES("43","EXP020424101","","1360.00","2024-04-02 00:00:00","0","1","2024-04-02 10:31:19");
INSERT INTO tbl_expenses VALUES("44","EXP020424102","","71650.00","2024-04-02 00:00:00","0","1","2024-04-02 09:26:16");
INSERT INTO tbl_expenses VALUES("45","EXP030424101","","1895.00","2024-04-03 00:00:00","0","1","2024-04-03 11:40:18");
INSERT INTO tbl_expenses VALUES("46","EXP030424102","","40850.00","2024-04-03 00:00:00","0","1","2024-04-03 01:41:49");
INSERT INTO tbl_expenses VALUES("47","EXP030424103","","30280.00","2024-04-03 00:00:00","0","1","2024-04-03 03:39:10");
INSERT INTO tbl_expenses VALUES("48","EXP030424104","","120.00","2024-04-03 00:00:00","0","1","2024-04-03 03:39:58");
INSERT INTO tbl_expenses VALUES("49","EXP030424105","","34100.00","2024-04-03 00:00:00","0","1","2024-04-03 03:45:11");
INSERT INTO tbl_expenses VALUES("50","EXP030424106","","8210.00","2024-04-03 00:00:00","0","1","2024-04-03 07:07:02");
INSERT INTO tbl_expenses VALUES("51","EXP030424107","","600.00","2024-04-03 00:00:00","0","1","2024-04-03 07:07:25");
INSERT INTO tbl_expenses VALUES("52","EXP040424101","","10265.00","2024-04-04 00:00:00","0","1","2024-04-04 12:03:54");
INSERT INTO tbl_expenses VALUES("53","EXP040424102","","14515.00","2024-04-04 00:00:00","0","1","2024-04-04 04:23:27");
INSERT INTO tbl_expenses VALUES("54","EXP040424103","","9670.00","2024-04-04 00:00:00","0","1","2024-04-04 04:25:39");
INSERT INTO tbl_expenses VALUES("55","EXP040424104","","163520.00","2024-04-04 00:00:00","0","1","2024-04-04 07:34:22");
INSERT INTO tbl_expenses VALUES("56","EXP040424105","","28270.00","2024-04-04 00:00:00","0","1","2024-04-04 08:33:11");
INSERT INTO tbl_expenses VALUES("57","EXP050424101","","11100.00","2024-04-05 00:00:00","0","1","2024-04-05 07:42:56");
INSERT INTO tbl_expenses VALUES("58","EXP050424102","","6650.00","2024-04-05 00:00:00","0","1","2024-04-05 08:28:18");
INSERT INTO tbl_expenses VALUES("59","EXP060424101","","14345.00","2024-04-06 00:00:00","0","1","2024-04-06 11:46:54");
INSERT INTO tbl_expenses VALUES("60","EXP060424102","","251300.00","2024-04-06 00:00:00","0","1","2024-04-06 02:09:01");
INSERT INTO tbl_expenses VALUES("61","EXP060424103","","10150.00","2024-04-06 00:00:00","0","1","2024-04-06 04:00:13");
INSERT INTO tbl_expenses VALUES("62","EXP060424104","","3975.00","2024-04-06 00:00:00","0","1","2024-04-06 08:13:02");
INSERT INTO tbl_expenses VALUES("63","EXP070424101","","25195.00","2024-04-07 00:00:00","0","1","2024-04-07 02:03:39");
INSERT INTO tbl_expenses VALUES("64","EXP070424102","","680.00","2024-04-07 00:00:00","0","1","2024-04-07 04:24:38");
INSERT INTO tbl_expenses VALUES("65","EXP070424103","","10340.00","2024-04-07 00:00:00","0","1","2024-04-07 07:37:35");
INSERT INTO tbl_expenses VALUES("66","EXP080424101","","9600.00","2024-04-08 00:00:00","0","1","2024-04-08 12:27:02");
INSERT INTO tbl_expenses VALUES("67","EXP080424102","","14185.00","2024-04-08 00:00:00","0","1","2024-04-08 04:50:27");
INSERT INTO tbl_expenses VALUES("68","EXP080424103","","13230.00","2024-04-08 00:00:00","0","1","2024-04-08 07:01:41");
INSERT INTO tbl_expenses VALUES("69","EXP090424101","","21565.00","2024-04-08 00:00:00","0","1","2024-04-09 10:42:53");
INSERT INTO tbl_expenses VALUES("70","EXP090424102","","26135.00","2024-04-09 00:00:00","0","1","2024-04-09 12:45:06");
INSERT INTO tbl_expenses VALUES("71","EXP090424103","","143500.00","2024-04-09 00:00:00","0","1","2024-04-09 05:52:26");
INSERT INTO tbl_expenses VALUES("72","EXP090424104","","26390.00","2024-04-09 00:00:00","0","1","2024-04-09 05:55:32");
INSERT INTO tbl_expenses VALUES("73","EXP090424105","","68490.00","2024-04-09 00:00:00","0","1","2024-04-09 09:33:46");
INSERT INTO tbl_expenses VALUES("74","EXP140424101","","13730.00","2024-04-10 00:00:00","0","1","2024-04-14 09:43:37");
INSERT INTO tbl_expenses VALUES("75","EXP140424102","","22660.00","2024-04-10 00:00:00","0","1","2024-04-14 11:00:58");
INSERT INTO tbl_expenses VALUES("76","EXP140424103","","2910.00","2024-04-10 00:00:00","0","1","2024-04-14 11:02:19");
INSERT INTO tbl_expenses VALUES("77","EXP140424104","","840.00","2024-04-14 00:00:00","0","1","2024-04-14 11:10:48");
INSERT INTO tbl_expenses VALUES("78","EXP140424105","","1865.00","2024-04-14 00:00:00","0","1","2024-04-14 08:12:29");
INSERT INTO tbl_expenses VALUES("79","EXP140424106","","1840.00","2024-04-14 00:00:00","0","1","2024-04-14 08:21:19");
INSERT INTO tbl_expenses VALUES("80","EXP150424101","","5620.00","2024-04-15 00:00:00","0","1","2024-04-15 03:51:30");
INSERT INTO tbl_expenses VALUES("81","EXP150424102","","11180.00","2024-04-15 00:00:00","0","1","2024-04-15 08:30:25");
INSERT INTO tbl_expenses VALUES("82","EXP150424103","","6770.00","2024-04-15 00:00:00","0","1","2024-04-15 09:50:26");
INSERT INTO tbl_expenses VALUES("83","EXP160424101","","2945.00","2024-04-16 00:00:00","0","1","2024-04-16 03:51:37");
INSERT INTO tbl_expenses VALUES("84","EXP160424102","","9370.00","2024-04-16 00:00:00","0","1","2024-04-16 09:51:45");
INSERT INTO tbl_expenses VALUES("85","EXP170424101","","46930.00","2024-04-17 00:00:00","0","1","2024-04-17 03:17:06");
INSERT INTO tbl_expenses VALUES("86","EXP170424102","","28230.00","2024-04-17 00:00:00","0","1","2024-04-17 09:18:39");
INSERT INTO tbl_expenses VALUES("87","EXP180424101","","2740.00","2024-04-18 00:00:00","0","1","2024-04-18 10:31:42");
INSERT INTO tbl_expenses VALUES("88","EXP180424102","","11730.00","2024-04-18 00:00:00","0","1","2024-04-18 02:16:30");
INSERT INTO tbl_expenses VALUES("89","EXP180424103","","1400.00","2024-04-18 00:00:00","0","1","2024-04-18 02:21:38");
INSERT INTO tbl_expenses VALUES("90","EXP180424104","","20110.00","2024-04-18 00:00:00","0","1","2024-04-18 06:18:45");
INSERT INTO tbl_expenses VALUES("91","EXP180424105","","23305.00","2024-04-18 00:00:00","0","1","2024-04-18 09:19:20");
INSERT INTO tbl_expenses VALUES("92","EXP190424101","","8410.00","2024-04-19 00:00:00","0","1","2024-04-19 12:03:24");
INSERT INTO tbl_expenses VALUES("93","EXP190424102","","720.00","2024-04-19 00:00:00","0","1","2024-04-19 09:01:14");
INSERT INTO tbl_expenses VALUES("94","EXP200424101","","10820.00","2024-04-20 00:00:00","0","1","2024-04-20 10:26:07");
INSERT INTO tbl_expenses VALUES("95","EXP200424102","","2250.00","2024-04-20 00:00:00","0","1","2024-04-20 12:08:11");
INSERT INTO tbl_expenses VALUES("96","EXP200424103","","17700.00","2024-04-20 00:00:00","0","1","2024-04-20 03:41:21");
INSERT INTO tbl_expenses VALUES("97","EXP200424104","","175390.00","2024-04-20 00:00:00","0","1","2024-04-20 07:20:03");
INSERT INTO tbl_expenses VALUES("98","EXP200424105","","23740.00","2024-04-20 00:00:00","0","1","2024-04-20 09:39:28");
INSERT INTO tbl_expenses VALUES("99","EXP210424101","","51530.00","2024-04-21 00:00:00","0","1","2024-04-21 09:50:32");
INSERT INTO tbl_expenses VALUES("100","EXP210424102","","250.00","2024-04-21 00:00:00","0","1","2024-04-21 09:54:48");
INSERT INTO tbl_expenses VALUES("101","EXP220424101","","21767.00","2024-04-22 00:00:00","0","1","2024-04-22 02:01:33");
INSERT INTO tbl_expenses VALUES("102","EXP220424102","","1350.00","2024-04-22 00:00:00","0","1","2024-04-22 05:44:31");
INSERT INTO tbl_expenses VALUES("103","EXP220424103","","18710.00","2024-04-22 00:00:00","0","1","2024-04-22 10:15:45");
INSERT INTO tbl_expenses VALUES("104","EXP230424101","","67950.00","2024-04-23 00:00:00","0","1","2024-04-23 11:18:02");
INSERT INTO tbl_expenses VALUES("105","EXP230424102","","20340.00","2024-04-23 00:00:00","0","1","2024-04-23 02:29:31");
INSERT INTO tbl_expenses VALUES("106","EXP230424103","","20460.00","2024-04-23 00:00:00","0","1","2024-04-23 07:43:48");
INSERT INTO tbl_expenses VALUES("107","EXP230424104","","9430.00","2024-04-23 00:00:00","0","1","2024-04-23 10:34:09");
INSERT INTO tbl_expenses VALUES("108","EXP240424101","","54442.00","2024-04-24 00:00:00","0","1","2024-04-24 09:53:52");
INSERT INTO tbl_expenses VALUES("109","EXP240424102","","22180.00","2024-04-24 00:00:00","0","1","2024-04-24 09:57:51");
INSERT INTO tbl_expenses VALUES("110","EXP250424101","","20885.00","2024-04-25 00:00:00","0","1","2024-04-25 03:45:15");
INSERT INTO tbl_expenses VALUES("111","EXP250424102","","22660.00","2024-04-25 00:00:00","0","1","2024-04-25 10:40:20");
INSERT INTO tbl_expenses VALUES("112","EXP260424101","","4090.00","2024-04-26 00:00:00","0","1","2024-04-26 12:27:20");
INSERT INTO tbl_expenses VALUES("113","EXP260424102","","3310.00","2024-04-26 00:00:00","0","1","2024-04-26 06:13:36");
INSERT INTO tbl_expenses VALUES("114","EXP260424103","","8340.00","2024-04-26 00:00:00","0","1","2024-04-26 07:37:33");
INSERT INTO tbl_expenses VALUES("115","EXP270424101","","950.00","2024-04-27 00:00:00","0","1","2024-04-27 11:57:46");
INSERT INTO tbl_expenses VALUES("116","EXP270424102","","450.00","2024-04-27 00:00:00","0","1","2024-04-27 03:34:42");
INSERT INTO tbl_expenses VALUES("117","EXP270424103","","13219.00","2024-04-27 00:00:00","0","1","2024-04-27 09:31:13");
INSERT INTO tbl_expenses VALUES("118","EXP280424101","","4010.00","2024-04-28 00:00:00","0","1","2024-04-28 11:32:39");
INSERT INTO tbl_expenses VALUES("119","EXP280424102","","320.00","2024-04-28 00:00:00","0","1","2024-04-28 09:57:03");
INSERT INTO tbl_expenses VALUES("120","EXP280424103","","19990.00","2024-04-28 00:00:00","0","1","2024-04-28 10:03:05");
INSERT INTO tbl_expenses VALUES("121","EXP290424101","","25665.00","2024-04-29 00:00:00","0","1","2024-04-29 02:38:40");
INSERT INTO tbl_expenses VALUES("122","EXP290424102","","3150.00","2024-04-29 00:00:00","0","1","2024-04-29 06:11:27");
INSERT INTO tbl_expenses VALUES("123","EXP290424103","","4750.00","2024-04-29 00:00:00","0","1","2024-04-29 07:15:07");
INSERT INTO tbl_expenses VALUES("124","EXP300424101","","9065.00","2024-04-29 00:00:00","0","1","2024-04-30 07:59:40");
INSERT INTO tbl_expenses VALUES("125","EXP300424102","","939577.00","2024-04-30 00:00:00","0","1","2024-04-30 08:36:37");
INSERT INTO tbl_expenses VALUES("126","EXP300424103","","3300.00","2024-04-30 00:00:00","0","1","2024-04-30 08:40:47");
INSERT INTO tbl_expenses VALUES("127","EXP300424104","","6000.00","2024-04-30 00:00:00","0","1","2024-04-30 08:41:06");
INSERT INTO tbl_expenses VALUES("128","EXP300424105","","1600.00","2024-04-30 00:00:00","0","1","2024-04-30 08:47:04");
INSERT INTO tbl_expenses VALUES("129","EXP010524101","","41290.00","2024-05-01 00:00:00","0","1","2024-05-01 03:14:44");
INSERT INTO tbl_expenses VALUES("130","EXP010524102","","200.00","2024-05-01 00:00:00","0","1","2024-05-01 06:23:36");
INSERT INTO tbl_expenses VALUES("131","EXP010524103","","13536.00","2024-05-01 00:00:00","0","1","2024-05-01 07:02:07");
INSERT INTO tbl_expenses VALUES("132","EXP010524104","","5480.00","2024-05-01 00:00:00","0","1","2024-05-01 07:51:20");
INSERT INTO tbl_expenses VALUES("133","EXP010524105","","360.00","2024-05-01 00:00:00","0","1","2024-05-01 08:07:09");
INSERT INTO tbl_expenses VALUES("134","EXP020524101","","21850.00","2024-05-02 00:00:00","0","1","2024-05-02 02:18:54");
INSERT INTO tbl_expenses VALUES("135","EXP020524102","","23730.00","2024-05-02 00:00:00","0","1","2024-05-02 06:04:25");
INSERT INTO tbl_expenses VALUES("136","EXP020524103","","11440.00","2024-05-02 00:00:00","0","1","2024-05-02 07:57:32");
INSERT INTO tbl_expenses VALUES("137","EXP020524104","","7630.00","2024-05-02 00:00:00","0","1","2024-05-02 08:53:03");
INSERT INTO tbl_expenses VALUES("138","EXP020524105","","500.00","2024-05-02 00:00:00","0","1","2024-05-02 09:08:05");
INSERT INTO tbl_expenses VALUES("139","EXP030524101","","21280.00","2024-05-03 00:00:00","0","1","2024-05-03 01:10:36");
INSERT INTO tbl_expenses VALUES("140","EXP030524102","","3170.00","2024-05-03 00:00:00","0","1","2024-05-03 09:53:58");
INSERT INTO tbl_expenses VALUES("141","EXP040524101","","4290.00","2024-05-04 00:00:00","0","1","2024-05-04 03:44:29");
INSERT INTO tbl_expenses VALUES("142","EXP040524102","","6310.00","2024-05-04 00:00:00","0","1","2024-05-04 09:18:47");
INSERT INTO tbl_expenses VALUES("143","EXP050524101","","11850.00","2024-05-05 00:00:00","0","1","2024-05-05 03:58:31");
INSERT INTO tbl_expenses VALUES("144","EXP050524102","","163695.00","2024-05-05 00:00:00","0","1","2024-05-05 09:17:59");
INSERT INTO tbl_expenses VALUES("145","EXP050524103","","13790.00","2024-05-05 00:00:00","0","1","2024-05-05 09:24:27");
INSERT INTO tbl_expenses VALUES("146","EXP060524101","","39335.00","2024-05-06 00:00:00","0","1","2024-05-06 02:34:56");
INSERT INTO tbl_expenses VALUES("147","EXP060524102","","8660.00","2024-05-06 00:00:00","0","1","2024-05-06 07:59:16");
INSERT INTO tbl_expenses VALUES("148","EXP070524101","","230.00","2024-05-06 00:00:00","0","1","2024-05-07 09:41:56");
INSERT INTO tbl_expenses VALUES("149","EXP070524102","","4730.00","2024-05-07 00:00:00","0","1","2024-05-07 05:48:19");
INSERT INTO tbl_expenses VALUES("150","EXP070524103","","350.00","2024-05-07 00:00:00","0","1","2024-05-07 05:54:01");
INSERT INTO tbl_expenses VALUES("151","EXP080524101","","16700.00","2024-05-07 00:00:00","0","1","2024-05-08 08:46:35");
INSERT INTO tbl_expenses VALUES("152","EXP080524102","","32750.00","2024-05-08 00:00:00","0","1","2024-05-08 05:56:54");
INSERT INTO tbl_expenses VALUES("153","EXP080524103","","3799.00","2024-05-08 00:00:00","0","1","2024-05-08 09:12:26");
INSERT INTO tbl_expenses VALUES("154","EXP090524101","","14010.00","2024-05-09 00:00:00","0","1","2024-05-09 01:51:25");
INSERT INTO tbl_expenses VALUES("155","EXP090524102","","23930.00","2024-05-09 00:00:00","0","1","2024-05-09 07:19:39");
INSERT INTO tbl_expenses VALUES("156","EXP090524103","","2030.00","2024-05-09 00:00:00","0","1","2024-05-09 07:38:12");
INSERT INTO tbl_expenses VALUES("157","EXP090524104","","12780.00","2024-05-09 00:00:00","0","1","2024-05-09 09:01:53");
INSERT INTO tbl_expenses VALUES("158","EXP100524101","","815.00","2024-05-10 00:00:00","0","1","2024-05-10 10:22:05");
INSERT INTO tbl_expenses VALUES("159","EXP100524102","","440.00","2024-05-10 00:00:00","0","1","2024-05-10 07:36:15");
INSERT INTO tbl_expenses VALUES("160","EXP110524101","","1790.00","2024-05-11 00:00:00","0","1","2024-05-11 03:44:28");
INSERT INTO tbl_expenses VALUES("161","EXP110524102","","210.00","2024-05-11 00:00:00","0","1","2024-05-11 07:26:44");
INSERT INTO tbl_expenses VALUES("162","EXP110524103","","400.00","2024-05-11 00:00:00","0","1","2024-05-11 08:20:09");
INSERT INTO tbl_expenses VALUES("163","EXP110524104","","480.00","2024-05-11 00:00:00","0","1","2024-05-11 08:20:52");
INSERT INTO tbl_expenses VALUES("164","EXP120524101","","2410.00","2024-05-12 00:00:00","0","1","2024-05-12 01:44:25");
INSERT INTO tbl_expenses VALUES("165","EXP120524102","","140.00","2024-05-12 00:00:00","0","1","2024-05-12 01:45:02");
INSERT INTO tbl_expenses VALUES("166","EXP120524103","","10495.00","2024-05-12 00:00:00","0","1","2024-05-12 09:28:48");
INSERT INTO tbl_expenses VALUES("167","EXP130524101","","9695.00","2024-05-13 00:00:00","0","1","2024-05-13 11:49:44");
INSERT INTO tbl_expenses VALUES("168","EXP130524102","","10090.00","2024-05-13 00:00:00","0","1","2024-05-13 05:23:25");
INSERT INTO tbl_expenses VALUES("169","EXP130524103","","10.00","2024-05-13 00:00:00","0","1","2024-05-13 05:25:31");
INSERT INTO tbl_expenses VALUES("170","EXP140524101","","21350.00","2024-05-13 00:00:00","0","1","2024-05-14 09:30:15");
INSERT INTO tbl_expenses VALUES("171","EXP140524102","","6805.00","2024-05-14 00:00:00","0","1","2024-05-14 10:36:00");
INSERT INTO tbl_expenses VALUES("172","EXP140524103","","2900.00","2024-05-14 00:00:00","0","1","2024-05-14 10:37:57");
INSERT INTO tbl_expenses VALUES("173","EXP140524104","","12910.00","2024-05-14 00:00:00","0","1","2024-05-14 04:46:57");
INSERT INTO tbl_expenses VALUES("174","EXP140524105","","10.00","2024-05-14 00:00:00","0","1","2024-05-14 04:47:18");
INSERT INTO tbl_expenses VALUES("175","EXP140524106","","1530.00","2024-05-14 00:00:00","0","1","2024-05-14 07:17:19");
INSERT INTO tbl_expenses VALUES("176","EXP150524101","","6540.00","2024-05-15 00:00:00","0","1","2024-05-15 02:24:34");
INSERT INTO tbl_expenses VALUES("177","EXP150524102","","2370.00","2024-05-15 00:00:00","0","1","2024-05-15 08:24:11");
INSERT INTO tbl_expenses VALUES("178","EXP150524103","","1815.00","2024-05-15 00:00:00","0","1","2024-05-15 08:27:40");
INSERT INTO tbl_expenses VALUES("179","EXP160524101","","4150.00","2024-05-15 00:00:00","0","1","2024-05-16 08:22:02");
INSERT INTO tbl_expenses VALUES("180","EXP160524102","","3730.00","2024-05-16 00:00:00","0","1","2024-05-16 12:03:41");
INSERT INTO tbl_expenses VALUES("181","EXP160524103","","100.00","2024-05-16 00:00:00","0","1","2024-05-16 12:04:02");
INSERT INTO tbl_expenses VALUES("182","EXP160524104","","9460.00","2024-05-16 00:00:00","0","1","2024-05-16 06:09:46");
INSERT INTO tbl_expenses VALUES("183","EXP160524105","","17111.00","2024-05-16 00:00:00","0","1","2024-05-16 09:19:18");
INSERT INTO tbl_expenses VALUES("184","EXP170524101","","1850.00","2024-05-17 00:00:00","0","1","2024-05-17 11:50:46");
INSERT INTO tbl_expenses VALUES("185","EXP170524102","","6720.00","2024-05-17 00:00:00","0","1","2024-05-17 06:39:59");
INSERT INTO tbl_expenses VALUES("186","EXP170524103","","15440.00","2024-05-17 00:00:00","0","1","2024-05-17 09:22:38");
INSERT INTO tbl_expenses VALUES("187","EXP170524104","","800.00","2024-05-17 00:00:00","0","1","2024-05-17 09:26:48");
INSERT INTO tbl_expenses VALUES("188","EXP180524101","","800.00","2024-05-17 00:00:00","0","1","2024-05-18 02:41:39");
INSERT INTO tbl_expenses VALUES("189","EXP180524102","","375.00","2024-05-17 00:00:00","0","1","2024-05-18 02:42:03");
INSERT INTO tbl_expenses VALUES("190","EXP180524103","","43660.00","2024-05-18 00:00:00","0","1","2024-05-18 02:44:51");
INSERT INTO tbl_expenses VALUES("191","EXP180524104","","10648.00","2024-05-18 00:00:00","0","1","2024-05-18 05:41:33");
INSERT INTO tbl_expenses VALUES("192","EXP180524105","","12435.00","2024-05-18 00:00:00","0","1","2024-05-18 08:45:15");
INSERT INTO tbl_expenses VALUES("193","EXP190524101","","1100.00","2024-05-19 00:00:00","0","1","2024-05-19 03:35:41");
INSERT INTO tbl_expenses VALUES("194","EXP190524102","","7425.00","2024-05-19 00:00:00","0","1","2024-05-19 03:49:44");
INSERT INTO tbl_expenses VALUES("195","EXP190524103","","20.00","2024-05-19 00:00:00","0","1","2024-05-19 03:58:28");
INSERT INTO tbl_expenses VALUES("196","EXP190524104","","18120.00","2024-05-19 00:00:00","0","1","2024-05-19 04:42:57");
INSERT INTO tbl_expenses VALUES("197","EXP190524105","","17440.00","2024-05-19 00:00:00","0","1","2024-05-19 11:14:12");
INSERT INTO tbl_expenses VALUES("198","EXP200524101","","15930.00","2024-05-20 00:00:00","0","1","2024-05-20 11:19:59");
INSERT INTO tbl_expenses VALUES("199","EXP200524102","","31200.00","2024-05-19 00:00:00","0","1","2024-05-20 11:55:05");
INSERT INTO tbl_expenses VALUES("200","EXP200524103","","21495.00","2024-05-20 00:00:00","0","1","2024-05-20 02:34:50");
INSERT INTO tbl_expenses VALUES("201","EXP200524104","","150.00","2024-05-20 00:00:00","0","1","2024-05-20 05:21:42");
INSERT INTO tbl_expenses VALUES("202","EXP200524105","","12000.00","2024-05-20 00:00:00","0","1","2024-05-20 06:29:05");
INSERT INTO tbl_expenses VALUES("203","EXP210524101","","167255.00","2024-05-21 00:00:00","0","1","2024-05-21 11:58:19");
INSERT INTO tbl_expenses VALUES("204","EXP210524102","","705.00","2024-05-21 00:00:00","0","1","2024-05-21 11:58:50");
INSERT INTO tbl_expenses VALUES("205","EXP210524103","","7750.00","2024-05-21 00:00:00","0","1","2024-05-21 12:13:28");
INSERT INTO tbl_expenses VALUES("206","EXP210524104","","6830.00","2024-05-21 00:00:00","0","1","2024-05-21 03:06:12");
INSERT INTO tbl_expenses VALUES("207","EXP210524105","","69895.00","2024-05-21 00:00:00","0","1","2024-05-21 09:16:15");
INSERT INTO tbl_expenses VALUES("208","EXP220524101","","9620.00","2024-05-22 00:00:00","0","1","2024-05-22 02:56:55");
INSERT INTO tbl_expenses VALUES("209","EXP220524102","","13770.00","2024-05-22 00:00:00","0","1","2024-05-22 08:09:31");
INSERT INTO tbl_expenses VALUES("210","EXP220524103","","9430.00","2024-05-22 00:00:00","0","1","2024-05-22 09:22:29");
INSERT INTO tbl_expenses VALUES("211","EXP230524101","","21500.00","2024-05-23 00:00:00","0","1","2024-05-23 09:44:20");
INSERT INTO tbl_expenses VALUES("212","EXP230524102","","16810.00","2024-05-23 00:00:00","0","1","2024-05-23 09:50:26");
INSERT INTO tbl_expenses VALUES("213","EXP240524101","","62830.00","2024-05-24 00:00:00","0","1","2024-05-24 07:39:34");
INSERT INTO tbl_expenses VALUES("214","EXP250524101","","20465.00","2024-05-25 00:00:00","0","1","2024-05-25 09:11:12");
INSERT INTO tbl_expenses VALUES("215","EXP250524102","","5745.00","2024-05-25 00:00:00","0","1","2024-05-25 11:15:28");
INSERT INTO tbl_expenses VALUES("216","EXP250524103","","1630.00","2024-05-25 00:00:00","0","1","2024-05-25 02:26:07");
INSERT INTO tbl_expenses VALUES("217","EXP260524101","","22760.00","2024-05-25 00:00:00","0","1","2024-05-26 01:53:19");
INSERT INTO tbl_expenses VALUES("218","EXP260524102","","4860.00","2024-05-26 00:00:00","0","1","2024-05-26 01:58:00");
INSERT INTO tbl_expenses VALUES("219","EXP260524103","","7655.00","2024-05-26 00:00:00","0","1","2024-05-26 06:36:15");
INSERT INTO tbl_expenses VALUES("220","EXP270524101","","22470.00","2024-05-26 00:00:00","0","1","2024-05-27 10:22:42");
INSERT INTO tbl_expenses VALUES("221","EXP280524101","","13145.00","2024-05-27 00:00:00","0","1","2024-05-28 01:58:49");
INSERT INTO tbl_expenses VALUES("222","EXP280524102","","5160.00","2024-05-28 00:00:00","0","1","2024-05-28 02:03:24");
INSERT INTO tbl_expenses VALUES("223","EXP280524103","","570.00","2024-05-28 00:00:00","0","1","2024-05-28 07:32:16");
INSERT INTO tbl_expenses VALUES("224","EXP290524101","","9165.00","2024-05-28 00:00:00","0","1","2024-05-29 09:25:22");
INSERT INTO tbl_expenses VALUES("225","EXP290524102","","44820.00","2024-05-29 00:00:00","0","1","2024-05-29 06:09:55");
INSERT INTO tbl_expenses VALUES("226","EXP300524101","","15425.00","2024-05-30 00:00:00","0","1","2024-05-30 08:56:51");
INSERT INTO tbl_expenses VALUES("227","EXP300524102","","320.00","2024-05-30 00:00:00","0","1","2024-05-30 09:04:34");
INSERT INTO tbl_expenses VALUES("228","EXP300524103","","26350.00","2024-05-30 00:00:00","0","1","2024-05-30 10:05:18");
INSERT INTO tbl_expenses VALUES("229","EXP310524101","","18385.00","2024-05-31 00:00:00","0","1","2024-05-31 05:15:03");
INSERT INTO tbl_expenses VALUES("230","EXP310524102","","7560.00","2024-05-31 00:00:00","0","1","2024-05-31 08:24:40");
INSERT INTO tbl_expenses VALUES("231","EXP010624101","","10078.00","2024-06-01 00:00:00","0","1","2024-06-01 06:33:32");
INSERT INTO tbl_expenses VALUES("232","EXP010624102","","160.00","2024-06-01 00:00:00","0","1","2024-06-01 06:34:44");
INSERT INTO tbl_expenses VALUES("233","EXP010624103","","13870.00","2024-06-01 00:00:00","0","1","2024-06-01 09:29:34");
INSERT INTO tbl_expenses VALUES("234","EXP020624101","","3640.00","2024-06-02 00:00:00","0","1","2024-06-02 09:30:14");
INSERT INTO tbl_expenses VALUES("235","EXP020624102","","49540.00","2024-06-02 00:00:00","0","1","2024-06-02 09:46:04");
INSERT INTO tbl_expenses VALUES("236","EXP030624101","","15205.00","2024-06-03 00:00:00","0","1","2024-06-03 08:47:02");
INSERT INTO tbl_expenses VALUES("237","EXP030624102","","600.00","2024-06-03 00:00:00","0","1","2024-06-03 09:02:54");
INSERT INTO tbl_expenses VALUES("238","EXP030624103","","57045.00","2024-06-03 00:00:00","0","1","2024-06-03 02:47:07");
INSERT INTO tbl_expenses VALUES("239","EXP030624104","","28080.00","2024-06-03 00:00:00","0","1","2024-06-03 10:45:12");
INSERT INTO tbl_expenses VALUES("240","EXP040624101","","16215.00","2024-06-04 00:00:00","0","1","2024-06-04 02:57:23");
INSERT INTO tbl_expenses VALUES("241","EXP040624102","","51635.00","2024-06-04 00:00:00","0","1","2024-06-04 10:07:39");
INSERT INTO tbl_expenses VALUES("242","EXP050624101","","3770.00","2024-06-05 00:00:00","0","1","2024-06-05 11:29:18");
INSERT INTO tbl_expenses VALUES("243","EXP050624102","","1940.00","2024-06-05 00:00:00","0","1","2024-06-05 01:23:28");
INSERT INTO tbl_expenses VALUES("244","EXP050624103","","4020.00","2024-06-05 00:00:00","0","1","2024-06-05 09:29:34");
INSERT INTO tbl_expenses VALUES("245","EXP050624104","","157660.00","2024-06-05 00:00:00","0","1","2024-06-05 09:35:09");
INSERT INTO tbl_expenses VALUES("246","EXP050624105","","59235.00","2024-06-05 00:00:00","0","1","2024-06-05 09:40:36");
INSERT INTO tbl_expenses VALUES("247","EXP060624101","","5980.00","2024-06-06 00:00:00","0","1","2024-06-06 04:04:08");
INSERT INTO tbl_expenses VALUES("248","EXP060624102","","40050.00","2024-06-06 00:00:00","0","1","2024-06-06 05:42:52");
INSERT INTO tbl_expenses VALUES("249","EXP070624101","","8310.00","2024-06-07 00:00:00","0","1","2024-06-07 10:37:46");
INSERT INTO tbl_expenses VALUES("250","EXP070624102","","69585.00","2024-06-07 00:00:00","0","1","2024-06-07 07:50:55");
INSERT INTO tbl_expenses VALUES("251","EXP080624101","","8900.00","2024-06-08 00:00:00","0","1","2024-06-08 08:18:46");
INSERT INTO tbl_expenses VALUES("252","EXP080624102","","9325.00","2024-06-08 00:00:00","0","1","2024-06-08 10:57:51");
INSERT INTO tbl_expenses VALUES("253","EXP080624103","","6670.00","2024-06-08 00:00:00","0","1","2024-06-08 02:23:46");
INSERT INTO tbl_expenses VALUES("254","EXP080624104","","2000.00","2024-06-08 00:00:00","0","1","2024-06-08 05:37:14");
INSERT INTO tbl_expenses VALUES("255","EXP080624105","","3000.00","2024-06-08 00:00:00","0","1","2024-06-08 05:41:40");
INSERT INTO tbl_expenses VALUES("256","EXP090624101","","12710.00","2024-06-08 00:00:00","0","1","2024-06-09 08:57:23");
INSERT INTO tbl_expenses VALUES("257","EXP090624102","","16670.00","2024-06-09 00:00:00","0","1","2024-06-09 03:01:23");
INSERT INTO tbl_expenses VALUES("258","EXP090624103","","10800.00","2024-06-09 00:00:00","0","1","2024-06-09 09:11:59");
INSERT INTO tbl_expenses VALUES("259","EXP100624101","","17745.00","2024-06-10 00:00:00","0","1","2024-06-10 03:15:37");
INSERT INTO tbl_expenses VALUES("260","EXP100624102","","33695.00","2024-06-10 00:00:00","0","1","2024-06-10 08:03:05");
INSERT INTO tbl_expenses VALUES("261","EXP100624103","","1970.00","2024-06-10 00:00:00","0","1","2024-06-10 10:32:46");
INSERT INTO tbl_expenses VALUES("262","EXP100624104","","850.00","2024-06-10 00:00:00","0","1","2024-06-10 10:34:26");
INSERT INTO tbl_expenses VALUES("263","EXP110624101","","20485.00","2024-06-11 00:00:00","0","1","2024-06-11 03:40:34");
INSERT INTO tbl_expenses VALUES("264","EXP110624102","","49580.00","2024-06-11 00:00:00","0","1","2024-06-11 06:31:35");
INSERT INTO tbl_expenses VALUES("265","EXP110624103","","35520.00","2024-06-11 00:00:00","0","1","2024-06-11 08:22:07");
INSERT INTO tbl_expenses VALUES("266","EXP110624104","","7430.00","2024-06-11 00:00:00","0","1","2024-06-11 08:53:25");
INSERT INTO tbl_expenses VALUES("267","EXP120624101","","28560.00","2024-06-12 00:00:00","0","1","2024-06-12 03:13:47");
INSERT INTO tbl_expenses VALUES("268","EXP120624102","","2820.00","2024-06-12 00:00:00","0","1","2024-06-12 06:36:34");
INSERT INTO tbl_expenses VALUES("269","EXP120624103","","12697.00","2024-06-12 00:00:00","0","1","2024-06-12 08:43:07");
INSERT INTO tbl_expenses VALUES("270","EXP120624104","","140.00","2024-06-12 00:00:00","0","1","2024-06-12 08:56:52");
INSERT INTO tbl_expenses VALUES("271","EXP130624101","","24740.00","2024-06-13 00:00:00","0","1","2024-06-13 03:49:44");
INSERT INTO tbl_expenses VALUES("272","EXP130624102","","11050.00","2024-06-13 00:00:00","0","1","2024-06-13 04:00:28");
INSERT INTO tbl_expenses VALUES("273","EXP130624103","","1080.00","2024-06-13 00:00:00","0","1","2024-06-13 04:01:31");
INSERT INTO tbl_expenses VALUES("274","EXP130624104","","13810.00","2024-06-13 00:00:00","0","1","2024-06-13 09:34:58");
INSERT INTO tbl_expenses VALUES("275","EXP140624101","","26930.00","2024-06-14 00:00:00","0","1","2024-06-14 06:50:33");
INSERT INTO tbl_expenses VALUES("276","EXP140624102","","8000.00","2024-06-14 00:00:00","0","1","2024-06-14 08:14:58");
INSERT INTO tbl_expenses VALUES("277","EXP150624101","","14920.00","2024-06-15 00:00:00","0","1","2024-06-15 02:23:34");
INSERT INTO tbl_expenses VALUES("278","EXP150624102","","29085.00","2024-06-15 00:00:00","0","1","2024-06-15 08:19:57");
INSERT INTO tbl_expenses VALUES("279","EXP150624103","","30.00","2024-06-15 00:00:00","0","1","2024-06-15 08:26:26");
INSERT INTO tbl_expenses VALUES("280","EXP160624101","","77410.00","2024-06-16 00:00:00","0","1","2024-06-16 10:52:54");
INSERT INTO tbl_expenses VALUES("281","EXP160624102","","70200.00","2024-06-16 00:00:00","0","1","2024-06-16 04:51:39");
INSERT INTO tbl_expenses VALUES("282","EXP160624103","","20700.00","2024-06-16 00:00:00","0","1","2024-06-16 05:04:57");
INSERT INTO tbl_expenses VALUES("283","EXP160624104","","7800.00","2024-06-16 00:00:00","0","1","2024-06-16 05:05:45");
INSERT INTO tbl_expenses VALUES("284","EXP160624105","","1950.00","2024-06-16 00:00:00","0","1","2024-06-16 05:34:51");
INSERT INTO tbl_expenses VALUES("285","EXP160624106","","3000.00","2024-06-16 00:00:00","0","1","2024-06-16 05:58:40");
INSERT INTO tbl_expenses VALUES("286","EXP210624101","","8848.00","2024-06-21 00:00:00","0","1","2024-06-21 09:37:29");
INSERT INTO tbl_expenses VALUES("287","EXP210624102","","74365.00","2024-06-21 00:00:00","0","1","2024-06-21 09:47:45");
INSERT INTO tbl_expenses VALUES("288","EXP220624101","","1520.00","2024-06-22 00:00:00","0","1","2024-06-22 12:12:56");
INSERT INTO tbl_expenses VALUES("289","EXP220624102","","170.00","2024-06-22 00:00:00","0","1","2024-06-22 12:14:51");
INSERT INTO tbl_expenses VALUES("290","EXP220624103","","100.00","2024-06-22 00:00:00","0","1","2024-06-22 07:44:01");
INSERT INTO tbl_expenses VALUES("291","EXP220624104","","55800.00","2024-06-22 00:00:00","0","1","2024-06-22 07:48:30");
INSERT INTO tbl_expenses VALUES("292","EXP220624105","","130.00","2024-06-22 00:00:00","0","1","2024-06-22 07:48:48");
INSERT INTO tbl_expenses VALUES("293","EXP220624106","","2890.00","2024-06-22 00:00:00","0","1","2024-06-22 08:12:22");
INSERT INTO tbl_expenses VALUES("294","EXP230624101","","31480.00","2024-06-23 00:00:00","0","1","2024-06-23 04:00:43");
INSERT INTO tbl_expenses VALUES("295","EXP230624102","","220.00","2024-06-23 00:00:00","0","1","2024-06-23 04:01:47");
INSERT INTO tbl_expenses VALUES("296","EXP230624103","","51940.00","2024-06-23 00:00:00","0","1","2024-06-23 09:13:00");
INSERT INTO tbl_expenses VALUES("297","EXP240624101","","65755.00","2024-06-24 00:00:00","0","1","2024-06-24 10:52:32");
INSERT INTO tbl_expenses VALUES("298","EXP240624102","","8178.00","2024-06-24 00:00:00","0","1","2024-06-24 03:38:00");
INSERT INTO tbl_expenses VALUES("299","EXP240624103","","20.00","2024-06-24 00:00:00","0","1","2024-06-24 03:43:40");
INSERT INTO tbl_expenses VALUES("300","EXP240624104","","11783.00","2024-06-24 00:00:00","0","1","2024-06-24 08:45:14");
INSERT INTO tbl_expenses VALUES("301","EXP250624101","","32620.00","2024-06-25 00:00:00","0","1","2024-06-25 11:24:22");
INSERT INTO tbl_expenses VALUES("302","EXP250624102","","137695.00","2024-06-25 00:00:00","0","1","2024-06-25 05:34:05");
INSERT INTO tbl_expenses VALUES("303","EXP250624103","","13990.00","2024-06-25 00:00:00","0","1","2024-06-25 08:47:18");
INSERT INTO tbl_expenses VALUES("304","EXP250624104","","1000.00","2024-06-25 00:00:00","0","1","2024-06-25 08:47:59");
INSERT INTO tbl_expenses VALUES("305","EXP260624101","","600.00","2024-06-26 00:00:00","0","1","2024-06-26 03:35:46");
INSERT INTO tbl_expenses VALUES("306","EXP260624102","","47023.00","2024-06-26 00:00:00","0","1","2024-06-26 06:02:17");
INSERT INTO tbl_expenses VALUES("307","EXP260624103","","7600.00","2024-06-26 00:00:00","0","1","2024-06-26 07:57:42");
INSERT INTO tbl_expenses VALUES("308","EXP270624101","","140685.00","2024-06-27 00:00:00","0","1","2024-06-27 04:23:52");
INSERT INTO tbl_expenses VALUES("309","EXP270624102","","15380.00","2024-06-27 00:00:00","0","1","2024-06-27 08:08:14");
INSERT INTO tbl_expenses VALUES("310","EXP270624103","","23085.00","2024-06-27 00:00:00","0","1","2024-06-27 08:57:17");
INSERT INTO tbl_expenses VALUES("311","EXP280624101","","38420.00","2024-06-28 00:00:00","0","1","2024-06-28 06:41:03");
INSERT INTO tbl_expenses VALUES("312","EXP280624102","","6140.00","2024-06-28 00:00:00","0","1","2024-06-28 08:07:38");
INSERT INTO tbl_expenses VALUES("313","EXP290624101","","18670.00","2024-06-29 00:00:00","0","1","2024-06-29 07:24:25");
INSERT INTO tbl_expenses VALUES("314","EXP290624102","","7619.00","2024-06-29 00:00:00","0","1","2024-06-29 07:27:05");
INSERT INTO tbl_expenses VALUES("315","EXP300624101","","22090.00","2024-06-30 00:00:00","0","1","2024-06-30 06:22:52");
INSERT INTO tbl_expenses VALUES("316","EXP010724101","","28080.00","2024-07-01 00:00:00","0","1","2024-07-01 06:46:21");
INSERT INTO tbl_expenses VALUES("317","EXP010724102","","7750.00","2024-07-01 00:00:00","0","1","2024-07-01 06:47:27");
INSERT INTO tbl_expenses VALUES("318","EXP010724103","","8145.00","2024-07-01 00:00:00","0","1","2024-07-01 07:56:49");
INSERT INTO tbl_expenses VALUES("319","EXP020724101","","1520.00","2024-07-02 00:00:00","0","1","2024-07-02 01:43:37");
INSERT INTO tbl_expenses VALUES("320","EXP020724102","","2880.00","2024-07-01 00:00:00","0","1","2024-07-02 01:46:17");
INSERT INTO tbl_expenses VALUES("321","EXP020724103","","29365.00","2024-07-02 00:00:00","0","1","2024-07-02 02:08:34");
INSERT INTO tbl_expenses VALUES("322","EXP020724104","","30.00","2024-07-02 00:00:00","0","1","2024-07-02 02:15:32");
INSERT INTO tbl_expenses VALUES("323","EXP020724105","","6825.00","2024-07-02 00:00:00","0","1","2024-07-02 07:48:47");
INSERT INTO tbl_expenses VALUES("324","EXP030724101","","1200.00","2024-07-03 00:00:00","0","1","2024-07-03 01:06:41");
INSERT INTO tbl_expenses VALUES("325","EXP030724102","","15975.00","2024-07-03 00:00:00","0","1","2024-07-03 01:12:57");
INSERT INTO tbl_expenses VALUES("326","EXP030724103","","4360.00","2024-07-03 00:00:00","0","1","2024-07-03 07:26:26");
INSERT INTO tbl_expenses VALUES("327","EXP030724104","","7530.00","2024-07-03 00:00:00","0","1","2024-07-03 07:50:42");
INSERT INTO tbl_expenses VALUES("328","EXP030724105","","1000.00","2024-07-03 00:00:00","0","1","2024-07-03 07:56:43");
INSERT INTO tbl_expenses VALUES("329","EXP040724101","","60.00","2024-07-04 00:00:00","0","1","2024-07-04 09:00:58");
INSERT INTO tbl_expenses VALUES("330","EXP040724102","","12310.00","2024-07-04 00:00:00","0","1","2024-07-04 02:35:58");
INSERT INTO tbl_expenses VALUES("331","EXP040724103","","112840.00","2024-07-04 00:00:00","0","1","2024-07-04 09:16:03");
INSERT INTO tbl_expenses VALUES("332","EXP040724104","","28890.00","2024-07-04 00:00:00","0","1","2024-07-04 09:19:36");
INSERT INTO tbl_expenses VALUES("333","EXP050724101","","22620.00","2024-07-05 00:00:00","0","1","2024-07-05 11:44:57");
INSERT INTO tbl_expenses VALUES("334","EXP050724102","","2110.00","2024-07-05 00:00:00","0","1","2024-07-05 08:27:12");
INSERT INTO tbl_expenses VALUES("335","EXP050724103","","7900.00","2024-07-05 00:00:00","0","1","2024-07-05 08:29:19");
INSERT INTO tbl_expenses VALUES("336","EXP050724104","","340.00","2024-07-05 00:00:00","0","1","2024-07-05 08:41:14");
INSERT INTO tbl_expenses VALUES("337","EXP060724101","","5610.00","2024-07-06 00:00:00","0","1","2024-07-06 06:13:12");
INSERT INTO tbl_expenses VALUES("338","EXP060724102","","12855.00","2024-07-06 00:00:00","0","1","2024-07-06 08:43:01");
INSERT INTO tbl_expenses VALUES("339","EXP060724103","","7000.00","2024-07-06 00:00:00","0","1","2024-07-06 09:15:42");
INSERT INTO tbl_expenses VALUES("340","EXP070724101","","33425.00","2024-07-07 00:00:00","0","1","2024-07-07 02:32:11");
INSERT INTO tbl_expenses VALUES("341","EXP070724102","","1510.00","2024-07-07 00:00:00","0","1","2024-07-07 02:36:38");
INSERT INTO tbl_expenses VALUES("342","EXP070724103","","1120.00","2024-07-07 00:00:00","0","1","2024-07-07 04:43:40");
INSERT INTO tbl_expenses VALUES("343","EXP070724104","","15290.00","2024-07-07 00:00:00","0","1","2024-07-07 08:28:30");
INSERT INTO tbl_expenses VALUES("344","EXP080724101","","12285.00","2024-07-08 00:00:00","0","1","2024-07-08 02:46:54");
INSERT INTO tbl_expenses VALUES("345","EXP080724102","","80260.00","2024-07-08 00:00:00","0","1","2024-07-08 05:27:35");
INSERT INTO tbl_expenses VALUES("346","EXP080724103","","9950.00","2024-07-08 00:00:00","0","1","2024-07-08 08:05:06");
INSERT INTO tbl_expenses VALUES("347","EXP090724101","","29980.00","2024-07-09 00:00:00","0","1","2024-07-09 09:41:54");
INSERT INTO tbl_expenses VALUES("348","EXP090724102","","23320.00","2024-07-09 00:00:00","0","1","2024-07-09 12:50:58");
INSERT INTO tbl_expenses VALUES("349","EXP090724103","","5400.00","2024-07-09 00:00:00","0","1","2024-07-09 05:22:03");
INSERT INTO tbl_expenses VALUES("350","EXP090724104","","38475.00","2024-07-09 00:00:00","0","1","2024-07-09 08:41:22");
INSERT INTO tbl_expenses VALUES("351","EXP100724101","","27740.00","2024-07-10 00:00:00","0","1","2024-07-10 06:15:08");
INSERT INTO tbl_expenses VALUES("352","EXP100724102","","10040.00","2024-07-10 00:00:00","0","1","2024-07-10 06:18:27");
INSERT INTO tbl_expenses VALUES("353","EXP100724103","","8880.00","2024-07-10 00:00:00","0","1","2024-07-10 07:57:29");
INSERT INTO tbl_expenses VALUES("354","EXP100724104","","4665.00","2024-07-10 00:00:00","0","1","2024-07-10 08:17:44");
INSERT INTO tbl_expenses VALUES("355","EXP110724101","","420.00","2024-07-11 00:00:00","0","1","2024-07-11 12:26:41");
INSERT INTO tbl_expenses VALUES("356","EXP110724102","","18420.00","2024-07-11 00:00:00","0","1","2024-07-11 06:07:46");
INSERT INTO tbl_expenses VALUES("357","EXP110724103","","7170.00","2024-07-11 00:00:00","0","1","2024-07-11 08:14:06");
INSERT INTO tbl_expenses VALUES("358","EXP130724101","","14595.00","2024-07-13 00:00:00","0","1","2024-07-13 09:00:59");
INSERT INTO tbl_expenses VALUES("359","EXP130724102","","56166.00","2024-07-13 00:00:00","0","1","2024-07-13 05:06:57");
INSERT INTO tbl_expenses VALUES("360","EXP130724103","","8640.00","2024-07-13 00:00:00","0","1","2024-07-13 08:09:15");
INSERT INTO tbl_expenses VALUES("361","EXP140724101","","799.00","2024-07-14 00:00:00","0","1","2024-07-14 02:19:08");
INSERT INTO tbl_expenses VALUES("362","EXP140724102","","70515.00","2024-07-14 00:00:00","0","1","2024-07-14 02:25:46");
INSERT INTO tbl_expenses VALUES("363","EXP140724103","","12480.00","2024-07-14 00:00:00","0","1","2024-07-14 04:32:56");
INSERT INTO tbl_expenses VALUES("364","EXP140724104","","18220.00","2024-07-14 00:00:00","0","1","2024-07-14 08:27:22");
INSERT INTO tbl_expenses VALUES("365","EXP150724101","","101330.00","2024-07-15 00:00:00","0","1","2024-07-15 04:56:47");
INSERT INTO tbl_expenses VALUES("366","EXP150724102","","9320.00","2024-07-15 00:00:00","0","1","2024-07-15 07:53:02");
INSERT INTO tbl_expenses VALUES("367","EXP160724101","","5465.00","2024-07-16 00:00:00","0","1","2024-07-16 02:50:19");
INSERT INTO tbl_expenses VALUES("368","EXP160724102","","60.00","2024-07-16 00:00:00","0","1","2024-07-16 02:53:25");
INSERT INTO tbl_expenses VALUES("369","EXP160724103","","9005.00","2024-07-16 00:00:00","0","1","2024-07-16 03:00:29");
INSERT INTO tbl_expenses VALUES("370","EXP160724104","","18410.00","2024-07-16 00:00:00","0","1","2024-07-16 08:20:27");
INSERT INTO tbl_expenses VALUES("371","EXP160724105","","14640.00","2024-07-16 00:00:00","0","1","2024-07-16 09:07:10");
INSERT INTO tbl_expenses VALUES("372","EXP160724106","","600.00","2024-07-16 00:00:00","0","1","2024-07-16 09:17:36");
INSERT INTO tbl_expenses VALUES("373","EXP170724101","","4270.00","2024-07-17 00:00:00","0","1","2024-07-17 12:47:45");
INSERT INTO tbl_expenses VALUES("374","EXP170724102","","2000.00","2024-07-17 00:00:00","0","1","2024-07-17 12:48:11");
INSERT INTO tbl_expenses VALUES("375","EXP170724103","","550.00","2024-07-17 00:00:00","0","1","2024-07-17 01:27:50");
INSERT INTO tbl_expenses VALUES("376","EXP170724104","","25940.00","2024-07-17 00:00:00","0","1","2024-07-17 06:08:26");
INSERT INTO tbl_expenses VALUES("377","EXP170724105","","21710.00","2024-07-17 00:00:00","0","1","2024-07-17 08:08:11");
INSERT INTO tbl_expenses VALUES("378","EXP180724101","","41070.00","2024-07-18 00:00:00","0","1","2024-07-18 03:38:41");
INSERT INTO tbl_expenses VALUES("379","EXP180724102","","40.00","2024-07-18 00:00:00","0","1","2024-07-18 03:53:31");
INSERT INTO tbl_expenses VALUES("380","EXP180724103","","25550.00","2024-07-18 00:00:00","0","1","2024-07-18 05:25:05");
INSERT INTO tbl_expenses VALUES("381","EXP250724101","","18420.00","2024-07-18 00:00:00","0","1","2024-07-25 08:16:22");
INSERT INTO tbl_expenses VALUES("382","EXP250724102","","4560.00","2024-07-18 00:00:00","0","1","2024-07-25 08:21:59");
INSERT INTO tbl_expenses VALUES("383","EXP250724103","","5.00","2024-07-18 00:00:00","0","1","2024-07-25 08:22:22");
INSERT INTO tbl_expenses VALUES("384","EXP250724104","","11624.00","2024-07-20 00:00:00","0","1","2024-07-25 09:43:30");
INSERT INTO tbl_expenses VALUES("385","EXP250724105","","11130.00","2024-07-25 00:00:00","0","1","2024-07-25 04:12:26");
INSERT INTO tbl_expenses VALUES("386","EXP260724101","","20616.00","2024-07-25 00:00:00","0","1","2024-07-26 11:02:41");
INSERT INTO tbl_expenses VALUES("387","EXP270724101","","41859.00","2024-07-26 00:00:00","0","1","2024-07-27 08:11:52");
INSERT INTO tbl_expenses VALUES("388","EXP270724102","","8555.00","2024-07-27 00:00:00","0","1","2024-07-27 09:19:35");
INSERT INTO tbl_expenses VALUES("389","EXP270724103","","46290.00","2024-07-27 00:00:00","0","1","2024-07-27 09:28:31");
INSERT INTO tbl_expenses VALUES("390","EXP270724104","","161445.00","2024-07-21 00:00:00","0","1","2024-07-27 10:20:11");
INSERT INTO tbl_expenses VALUES("391","EXP270724105","","11735.00","2024-07-22 00:00:00","0","1","2024-07-27 10:24:22");
INSERT INTO tbl_expenses VALUES("392","EXP270724106","","8870.00","2024-07-22 00:00:00","0","1","2024-07-27 10:46:52");
INSERT INTO tbl_expenses VALUES("393","EXP270724107","","39313.00","2024-07-23 00:00:00","0","1","2024-07-27 10:54:42");
INSERT INTO tbl_expenses VALUES("394","EXP270724108","","44605.00","2024-07-24 00:00:00","0","1","2024-07-27 11:48:07");
INSERT INTO tbl_expenses VALUES("395","EXP270724109","","30000.00","2024-07-24 00:00:00","0","1","2024-07-27 11:51:12");
INSERT INTO tbl_expenses VALUES("396","EXP270724110","","32780.00","2024-07-27 00:00:00","0","1","2024-07-27 06:40:34");
INSERT INTO tbl_expenses VALUES("397","EXP280724101","","10610.00","2024-07-27 00:00:00","0","1","2024-07-28 09:28:00");
INSERT INTO tbl_expenses VALUES("398","EXP280724102","","19615.00","2024-07-28 00:00:00","0","1","2024-07-28 05:55:49");
INSERT INTO tbl_expenses VALUES("399","EXP290724101","","39400.00","2024-07-29 00:00:00","0","1","2024-07-29 02:09:41");
INSERT INTO tbl_expenses VALUES("400","EXP290724102","","6540.00","2024-07-29 00:00:00","0","1","2024-07-29 06:30:08");
INSERT INTO tbl_expenses VALUES("401","EXP290724103","","20.00","2024-07-29 00:00:00","0","1","2024-07-29 06:30:35");
INSERT INTO tbl_expenses VALUES("402","EXP290724104","","9210.00","2024-07-29 00:00:00","0","1","2024-07-29 08:58:08");
INSERT INTO tbl_expenses VALUES("403","EXP300724101","","10110.00","2024-07-30 00:00:00","0","1","2024-07-30 06:07:26");
INSERT INTO tbl_expenses VALUES("404","EXP300724102","","200.00","2024-07-30 00:00:00","0","1","2024-07-30 06:19:40");
INSERT INTO tbl_expenses VALUES("405","EXP300724103","","140.00","2024-07-30 00:00:00","0","1","2024-07-30 06:20:28");
INSERT INTO tbl_expenses VALUES("406","EXP010824101","","111290.00","2024-07-31 00:00:00","0","1","2024-08-01 08:30:33");
INSERT INTO tbl_expenses VALUES("407","EXP020824101","","99415.00","2024-08-01 00:00:00","0","1","2024-08-02 05:57:18");
INSERT INTO tbl_expenses VALUES("408","EXP020824102","","21340.00","2024-08-02 00:00:00","0","1","2024-08-02 06:08:59");
INSERT INTO tbl_expenses VALUES("409","EXP020824103","","2000.00","2024-08-02 00:00:00","0","1","2024-08-02 06:16:03");
INSERT INTO tbl_expenses VALUES("410","EXP030824101","","36515.00","2024-08-03 00:00:00","0","1","2024-08-03 04:06:16");
INSERT INTO tbl_expenses VALUES("411","EXP040824101","","55530.00","2024-08-04 00:00:00","0","1","2024-08-04 06:14:11");
INSERT INTO tbl_expenses VALUES("412","EXP040824102","","9735.00","2024-08-04 00:00:00","0","1","2024-08-04 08:40:39");
INSERT INTO tbl_expenses VALUES("413","EXP050824101","","63170.00","2024-08-05 00:00:00","0","1","2024-08-05 07:19:21");
INSERT INTO tbl_expenses VALUES("414","EXP050824102","","61760.00","2024-08-05 00:00:00","0","1","2024-08-05 09:30:44");
INSERT INTO tbl_expenses VALUES("415","EXP060824101","","50310.00","2024-08-06 00:00:00","0","1","2024-08-06 04:20:15");
INSERT INTO tbl_expenses VALUES("416","EXP060824102","","2990.00","2024-08-06 00:00:00","0","1","2024-08-06 06:59:31");
INSERT INTO tbl_expenses VALUES("417","EXP060824103","","17220.00","2024-08-06 00:00:00","0","1","2024-08-06 08:40:29");
INSERT INTO tbl_expenses VALUES("418","EXP070824101","","3140.00","2024-08-07 00:00:00","0","1","2024-08-07 03:57:41");
INSERT INTO tbl_expenses VALUES("419","EXP070824102","","6920.00","2024-08-07 00:00:00","0","1","2024-08-07 07:58:16");
INSERT INTO tbl_expenses VALUES("420","EXP080824101","","52440.00","2024-08-08 00:00:00","0","1","2024-08-08 02:17:38");
INSERT INTO tbl_expenses VALUES("421","EXP090824101","","26400.00","2024-08-09 00:00:00","0","1","2024-08-09 09:28:14");
INSERT INTO tbl_expenses VALUES("422","EXP090824102","","52570.00","2024-08-09 00:00:00","0","1","2024-08-09 06:24:16");
INSERT INTO tbl_expenses VALUES("423","EXP090824103","","18870.00","2024-08-09 00:00:00","0","1","2024-08-09 08:19:53");
INSERT INTO tbl_expenses VALUES("424","EXP100824101","","47575.00","2024-08-10 00:00:00","0","1","2024-08-10 07:23:21");
INSERT INTO tbl_expenses VALUES("425","EXP110824101","","41885.00","2024-08-11 00:00:00","0","1","2024-08-11 06:20:20");
INSERT INTO tbl_expenses VALUES("426","EXP110824102","","18000.00","2024-08-11 00:00:00","0","1","2024-08-11 06:20:40");
INSERT INTO tbl_expenses VALUES("427","EXP110824103","","100.00","2024-08-11 00:00:00","0","1","2024-08-11 06:21:00");
INSERT INTO tbl_expenses VALUES("428","EXP110824104","","22740.00","2024-08-11 00:00:00","0","1","2024-08-11 06:57:04");
INSERT INTO tbl_expenses VALUES("429","EXP110824105","","21370.00","2024-08-11 00:00:00","0","1","2024-08-11 09:32:35");
INSERT INTO tbl_expenses VALUES("430","EXP120824101","","39449.00","2024-08-12 00:00:00","0","1","2024-08-12 06:08:52");
INSERT INTO tbl_expenses VALUES("431","EXP120824102","","570.00","2024-08-12 00:00:00","0","1","2024-08-12 06:10:05");
INSERT INTO tbl_expenses VALUES("432","EXP120824103","","37277.00","2024-08-12 00:00:00","0","1","2024-08-12 09:07:08");
INSERT INTO tbl_expenses VALUES("433","EXP130824101","","17480.00","2024-08-13 00:00:00","0","1","2024-08-13 12:59:33");
INSERT INTO tbl_expenses VALUES("434","EXP130824102","","24350.00","2024-08-13 00:00:00","0","1","2024-08-13 07:02:27");
INSERT INTO tbl_expenses VALUES("435","EXP140824101","","126960.00","2024-08-14 00:00:00","0","1","2024-08-14 02:59:43");
INSERT INTO tbl_expenses VALUES("436","EXP140824102","","12145.00","2024-08-14 00:00:00","0","1","2024-08-14 03:11:40");
INSERT INTO tbl_expenses VALUES("437","EXP150824101","","10085.00","2024-08-14 00:00:00","0","1","2024-08-15 10:25:22");
INSERT INTO tbl_expenses VALUES("438","EXP150824102","","25640.00","2024-08-15 00:00:00","0","1","2024-08-15 02:52:09");
INSERT INTO tbl_expenses VALUES("439","EXP150824103","","10000.00","2024-08-15 00:00:00","0","1","2024-08-15 02:54:03");
INSERT INTO tbl_expenses VALUES("440","EXP150824104","","40.00","2024-08-15 00:00:00","0","1","2024-08-15 02:59:51");
INSERT INTO tbl_expenses VALUES("441","EXP150824105","","60.00","2024-08-15 00:00:00","0","1","2024-08-15 03:03:41");
INSERT INTO tbl_expenses VALUES("442","EXP150824106","","39830.00","2024-08-15 00:00:00","0","1","2024-08-15 07:54:22");
INSERT INTO tbl_expenses VALUES("443","EXP160824101","","27250.00","2024-08-15 00:00:00","0","1","2024-08-16 09:12:45");
INSERT INTO tbl_expenses VALUES("444","EXP160824102","","4090.00","2024-08-16 00:00:00","0","1","2024-08-16 06:30:49");
INSERT INTO tbl_expenses VALUES("445","EXP160824103","","12070.00","2024-08-16 00:00:00","0","1","2024-08-16 07:47:37");
INSERT INTO tbl_expenses VALUES("446","EXP160824104","","270.00","2024-08-16 00:00:00","0","1","2024-08-16 08:10:06");
INSERT INTO tbl_expenses VALUES("447","EXP170824101","","1870.00","2024-08-17 00:00:00","0","1","2024-08-17 05:56:29");
INSERT INTO tbl_expenses VALUES("448","EXP170824102","","34400.00","2024-08-17 00:00:00","0","1","2024-08-17 08:54:35");
INSERT INTO tbl_expenses VALUES("449","EXP180824101","","20715.00","2024-08-18 00:00:00","0","1","2024-08-18 03:30:54");
INSERT INTO tbl_expenses VALUES("450","EXP190824101","","8090.00","2024-08-18 00:00:00","0","1","2024-08-19 09:53:51");
INSERT INTO tbl_expenses VALUES("451","EXP190824102","","65570.00","2024-08-19 00:00:00","0","1","2024-08-19 06:10:59");
INSERT INTO tbl_expenses VALUES("452","EXP190824103","","640.00","2024-08-19 00:00:00","0","1","2024-08-19 07:32:45");
INSERT INTO tbl_expenses VALUES("453","EXP190824104","","11815.00","2024-08-19 00:00:00","0","1","2024-08-19 08:23:04");
INSERT INTO tbl_expenses VALUES("454","EXP210824101","","162105.00","2024-08-20 00:00:00","0","1","2024-08-21 09:13:44");
INSERT INTO tbl_expenses VALUES("455","EXP210824102","","81075.00","2024-08-21 00:00:00","0","1","2024-08-21 05:01:39");
INSERT INTO tbl_expenses VALUES("456","EXP210824103","","11087.00","2024-08-21 00:00:00","0","1","2024-08-21 08:54:36");
INSERT INTO tbl_expenses VALUES("457","EXP220824101","","50650.00","2024-08-22 00:00:00","0","1","2024-08-22 06:59:19");
INSERT INTO tbl_expenses VALUES("458","EXP230824101","","42680.00","2024-08-22 00:00:00","0","1","2024-08-23 09:15:20");
INSERT INTO tbl_expenses VALUES("459","EXP230824102","","32590.00","2024-08-23 00:00:00","0","1","2024-08-23 07:51:44");
INSERT INTO tbl_expenses VALUES("460","EXP240824101","","28860.00","2024-08-24 00:00:00","0","1","2024-08-24 05:33:21");
INSERT INTO tbl_expenses VALUES("461","EXP240824102","","2689.00","2024-08-24 00:00:00","0","1","2024-08-24 09:01:39");
INSERT INTO tbl_expenses VALUES("462","EXP250824101","","122480.00","2024-08-25 00:00:00","0","1","2024-08-25 01:26:37");
INSERT INTO tbl_expenses VALUES("463","EXP250824102","","88668.00","2024-08-25 00:00:00","0","1","2024-08-25 05:54:54");
INSERT INTO tbl_expenses VALUES("464","EXP250824103","","14805.00","2024-08-25 00:00:00","0","1","2024-08-25 08:58:35");
INSERT INTO tbl_expenses VALUES("465","EXP260824101","","29018.00","2024-08-26 00:00:00","0","1","2024-08-26 06:01:01");
INSERT INTO tbl_expenses VALUES("466","EXP260824102","","3880.00","2024-08-26 00:00:00","0","1","2024-08-26 08:10:11");
INSERT INTO tbl_expenses VALUES("467","EXP270824101","","16200.00","2024-08-27 00:00:00","0","1","2024-08-27 02:16:21");
INSERT INTO tbl_expenses VALUES("468","EXP270824102","","18060.00","2024-08-27 00:00:00","0","1","2024-08-27 09:16:59");
INSERT INTO tbl_expenses VALUES("469","EXP280824101","","49430.00","2024-08-28 00:00:00","0","1","2024-08-28 03:52:32");
INSERT INTO tbl_expenses VALUES("470","EXP280824102","","120.00","2024-08-28 00:00:00","0","1","2024-08-28 05:40:21");
INSERT INTO tbl_expenses VALUES("471","EXP280824103","","910.00","2024-08-28 00:00:00","0","1","2024-08-28 07:29:21");
INSERT INTO tbl_expenses VALUES("472","EXP280824104","","1600.00","2024-08-28 00:00:00","0","1","2024-08-28 07:53:59");
INSERT INTO tbl_expenses VALUES("473","EXP290824101","","783568.00","2024-08-29 00:00:00","0","1","2024-08-29 02:13:58");
INSERT INTO tbl_expenses VALUES("474","EXP290824102","","30150.00","2024-08-29 00:00:00","0","1","2024-08-29 07:28:15");
INSERT INTO tbl_expenses VALUES("475","EXP290824103","","20.00","2024-08-29 00:00:00","0","1","2024-08-29 07:28:52");
INSERT INTO tbl_expenses VALUES("476","EXP300824101","","27780.00","2024-08-30 00:00:00","0","1","2024-08-30 07:25:28");
INSERT INTO tbl_expenses VALUES("477","EXP310824101","","7470.00","2024-08-30 00:00:00","0","1","2024-08-31 02:34:40");
INSERT INTO tbl_expenses VALUES("478","EXP310824102","","38320.00","2024-08-31 00:00:00","0","1","2024-08-31 02:43:40");
INSERT INTO tbl_expenses VALUES("479","EXP310824103","","2070.00","2024-08-31 00:00:00","0","1","2024-08-31 06:26:01");
INSERT INTO tbl_expenses VALUES("480","EXP310824104","","27420.00","2024-08-31 00:00:00","0","1","2024-08-31 09:32:36");
INSERT INTO tbl_expenses VALUES("481","EXP010924101","","64640.00","2024-09-01 00:00:00","0","1","2024-09-01 03:16:15");
INSERT INTO tbl_expenses VALUES("482","EXP010924102","","310.00","2024-09-01 00:00:00","0","1","2024-09-01 06:19:13");
INSERT INTO tbl_expenses VALUES("483","EXP020924101","","17795.00","2024-09-01 00:00:00","0","1","2024-09-02 08:44:44");
INSERT INTO tbl_expenses VALUES("484","EXP020924102","","7280.00","2024-09-02 00:00:00","0","1","2024-09-02 12:42:18");
INSERT INTO tbl_expenses VALUES("485","EXP020924103","","23790.00","2024-09-02 00:00:00","0","1","2024-09-02 07:33:42");
INSERT INTO tbl_expenses VALUES("486","EXP020924104","","3830.00","2024-09-02 00:00:00","0","1","2024-09-02 09:03:52");
INSERT INTO tbl_expenses VALUES("487","EXP030924101","","85800.00","2024-09-03 00:00:00","0","1","2024-09-03 04:08:27");
INSERT INTO tbl_expenses VALUES("488","EXP030924102","","14510.00","2024-09-03 00:00:00","0","1","2024-09-03 08:55:36");
INSERT INTO tbl_expenses VALUES("489","EXP040924101","","17730.00","2024-09-04 00:00:00","0","1","2024-09-04 03:52:50");
INSERT INTO tbl_expenses VALUES("490","EXP040924102","","67330.00","2024-09-04 00:00:00","0","1","2024-09-04 08:54:51");
INSERT INTO tbl_expenses VALUES("491","EXP050924101","","111225.00","2024-09-05 00:00:00","0","1","2024-09-05 04:03:27");
INSERT INTO tbl_expenses VALUES("492","EXP060924101","","134775.00","2024-09-06 00:00:00","0","1","2024-09-06 12:10:27");
INSERT INTO tbl_expenses VALUES("493","EXP060924102","","55620.00","2024-09-06 00:00:00","0","1","2024-09-06 12:16:09");
INSERT INTO tbl_expenses VALUES("494","EXP060924103","","112620.00","2024-09-06 00:00:00","0","1","2024-09-06 06:59:11");
INSERT INTO tbl_expenses VALUES("495","EXP070924101","","12280.00","2024-09-06 00:00:00","0","1","2024-09-07 09:41:46");
INSERT INTO tbl_expenses VALUES("496","EXP070924102","","2080.00","2024-09-07 00:00:00","0","1","2024-09-07 09:43:02");
INSERT INTO tbl_expenses VALUES("497","EXP070924103","","16160.00","2024-09-07 00:00:00","0","1","2024-09-07 02:51:25");
INSERT INTO tbl_expenses VALUES("498","EXP070924104","","8570.00","2024-09-07 00:00:00","0","1","2024-09-07 07:29:32");
INSERT INTO tbl_expenses VALUES("499","EXP080924101","","8300.00","2024-09-08 00:00:00","0","1","2024-09-08 08:51:54");
INSERT INTO tbl_expenses VALUES("500","EXP080924102","","10115.00","2024-09-08 00:00:00","0","1","2024-09-08 12:33:21");
INSERT INTO tbl_expenses VALUES("501","EXP080924103","","65045.00","2024-09-08 00:00:00","0","1","2024-09-08 04:11:19");
INSERT INTO tbl_expenses VALUES("502","EXP090924101","","19938.00","2024-09-08 00:00:00","0","1","2024-09-09 12:24:54");
INSERT INTO tbl_expenses VALUES("503","EXP090924102","","42810.00","2024-09-09 00:00:00","0","1","2024-09-09 02:20:43");
INSERT INTO tbl_expenses VALUES("504","EXP090924103","","1760.00","2024-09-09 00:00:00","0","1","2024-09-09 06:35:22");
INSERT INTO tbl_expenses VALUES("505","EXP090924104","","800.00","2024-09-09 00:00:00","0","1","2024-09-09 06:36:18");
INSERT INTO tbl_expenses VALUES("506","EXP090924105","","35720.00","2024-09-09 00:00:00","0","1","2024-09-09 09:12:51");
INSERT INTO tbl_expenses VALUES("507","EXP100924101","","15510.00","2024-09-10 00:00:00","0","1","2024-09-10 04:12:41");
INSERT INTO tbl_expenses VALUES("508","EXP100924102","","3700.00","2024-09-10 00:00:00","0","1","2024-09-10 07:41:33");
INSERT INTO tbl_expenses VALUES("509","EXP110924101","","71587.00","2024-09-11 00:00:00","0","1","2024-09-11 03:30:21");
INSERT INTO tbl_expenses VALUES("510","EXP110924102","","18570.00","2024-09-11 00:00:00","0","1","2024-09-11 07:17:50");
INSERT INTO tbl_expenses VALUES("511","EXP120924101","","15830.00","2024-09-11 00:00:00","0","1","2024-09-12 04:07:09");
INSERT INTO tbl_expenses VALUES("512","EXP120924102","","26190.00","2024-09-12 00:00:00","0","1","2024-09-12 04:31:39");
INSERT INTO tbl_expenses VALUES("513","EXP120924103","","61585.00","2024-09-12 00:00:00","0","1","2024-09-12 08:54:17");
INSERT INTO tbl_expenses VALUES("514","EXP130924101","","13770.00","2024-09-12 00:00:00","0","1","2024-09-13 07:38:23");
INSERT INTO tbl_expenses VALUES("515","EXP130924102","","31260.00","2024-09-13 00:00:00","0","1","2024-09-13 07:44:58");
INSERT INTO tbl_expenses VALUES("516","EXP130924103","","3270.00","2024-09-13 00:00:00","0","1","2024-09-13 08:20:56");
INSERT INTO tbl_expenses VALUES("517","EXP140924101","","25330.00","2024-09-12 00:00:00","0","1","2024-09-14 08:52:50");
INSERT INTO tbl_expenses VALUES("518","EXP140924102","","15940.00","2024-09-14 00:00:00","0","1","2024-09-14 07:49:48");
INSERT INTO tbl_expenses VALUES("519","EXP150924101","","29593.00","2024-09-15 00:00:00","0","1","2024-09-15 03:20:30");
INSERT INTO tbl_expenses VALUES("520","EXP150924102","","3260.00","2024-09-15 00:00:00","0","1","2024-09-15 07:41:05");
INSERT INTO tbl_expenses VALUES("521","EXP160924101","","14040.00","2024-09-16 00:00:00","0","1","2024-09-16 12:35:08");
INSERT INTO tbl_expenses VALUES("522","EXP160924102","","37220.00","2024-09-16 00:00:00","0","1","2024-09-16 02:17:55");
INSERT INTO tbl_expenses VALUES("523","EXP160924103","","38424.00","2024-09-16 00:00:00","0","1","2024-09-16 08:39:15");
INSERT INTO tbl_expenses VALUES("524","EXP170924101","","2225.00","2024-09-17 00:00:00","0","1","2024-09-17 01:17:09");
INSERT INTO tbl_expenses VALUES("525","EXP170924102","","500.00","2024-09-17 00:00:00","0","1","2024-09-17 03:24:59");
INSERT INTO tbl_expenses VALUES("526","EXP170924103","","15235.00","2024-09-17 00:00:00","0","1","2024-09-17 09:59:20");
INSERT INTO tbl_expenses VALUES("527","EXP180924101","","24830.00","2024-09-18 00:00:00","0","1","2024-09-18 03:21:22");
INSERT INTO tbl_expenses VALUES("528","EXP180924102","","10010.00","2024-09-18 00:00:00","0","1","2024-09-18 04:59:29");
INSERT INTO tbl_expenses VALUES("529","EXP180924103","","15870.00","2024-09-18 00:00:00","0","1","2024-09-18 07:43:24");
INSERT INTO tbl_expenses VALUES("530","EXP190924101","","20175.00","2024-09-19 00:00:00","0","1","2024-09-19 04:14:54");
INSERT INTO tbl_expenses VALUES("531","EXP190924102","","43565.00","2024-09-19 00:00:00","0","1","2024-09-19 07:53:35");
INSERT INTO tbl_expenses VALUES("532","EXP200924101","","29265.00","2024-09-19 00:00:00","0","1","2024-09-20 09:14:09");
INSERT INTO tbl_expenses VALUES("533","EXP200924102","","4400.00","2024-09-20 00:00:00","0","1","2024-09-20 09:16:02");
INSERT INTO tbl_expenses VALUES("534","EXP200924103","","71270.00","2024-09-20 00:00:00","0","1","2024-09-20 07:18:24");
INSERT INTO tbl_expenses VALUES("535","EXP210924101","","18970.00","2024-09-20 00:00:00","0","1","2024-09-21 04:07:26");
INSERT INTO tbl_expenses VALUES("536","EXP210924102","","2100.00","2024-09-21 00:00:00","0","1","2024-09-21 04:09:23");
INSERT INTO tbl_expenses VALUES("537","EXP220924101","","84095.00","2024-09-22 00:00:00","0","1","2024-09-22 12:23:28");
INSERT INTO tbl_expenses VALUES("538","EXP220924102","","101190.00","2024-09-22 00:00:00","0","1","2024-09-22 09:03:51");
INSERT INTO tbl_expenses VALUES("539","EXP230924101","","94965.00","2024-09-23 00:00:00","0","1","2024-09-23 02:02:00");
INSERT INTO tbl_expenses VALUES("540","EXP230924102","","26400.00","2024-09-23 00:00:00","0","1","2024-09-23 09:29:50");
INSERT INTO tbl_expenses VALUES("541","EXP240924101","","95510.00","2024-09-24 00:00:00","0","1","2024-09-24 02:47:27");
INSERT INTO tbl_expenses VALUES("542","EXP240924102","","21090.00","2024-09-24 00:00:00","0","1","2024-09-24 10:52:29");
INSERT INTO tbl_expenses VALUES("543","EXP250924101","","42024.00","2024-09-25 00:00:00","0","1","2024-09-25 02:47:37");
INSERT INTO tbl_expenses VALUES("544","EXP260924101","","13700.00","2024-09-25 00:00:00","0","1","2024-09-26 02:39:48");
INSERT INTO tbl_expenses VALUES("545","EXP260924102","","61275.00","2024-09-26 00:00:00","0","1","2024-09-26 02:44:44");
INSERT INTO tbl_expenses VALUES("546","EXP260924103","","60204.00","2024-09-26 00:00:00","0","1","2024-09-26 09:36:45");
INSERT INTO tbl_expenses VALUES("547","EXP270924101","","5970.00","2024-09-27 00:00:00","0","1","2024-09-27 02:33:11");
INSERT INTO tbl_expenses VALUES("548","EXP280924101","","19615.00","2024-09-27 00:00:00","0","1","2024-09-28 08:21:32");
INSERT INTO tbl_expenses VALUES("549","EXP280924102","","7140.00","2024-09-28 00:00:00","0","1","2024-09-28 03:33:34");
INSERT INTO tbl_expenses VALUES("550","EXP290924101","","22615.00","2024-09-28 00:00:00","0","1","2024-09-29 12:06:06");
INSERT INTO tbl_expenses VALUES("551","EXP290924102","","23875.00","2024-09-29 00:00:00","0","1","2024-09-29 12:13:00");
INSERT INTO tbl_expenses VALUES("552","EXP290924103","","47765.00","2024-09-29 00:00:00","0","1","2024-09-29 08:12:40");
INSERT INTO tbl_expenses VALUES("553","EXP300924101","","3450.00","2024-09-29 00:00:00","0","1","2024-09-30 11:36:48");
INSERT INTO tbl_expenses VALUES("554","EXP300924102","","9060.00","2024-09-30 00:00:00","0","1","2024-09-30 11:41:00");
INSERT INTO tbl_expenses VALUES("555","EXP011024101","","27330.00","2024-09-30 00:00:00","0","1","2024-10-01 03:30:15");
INSERT INTO tbl_expenses VALUES("556","EXP011024102","","49550.00","2024-10-01 00:00:00","0","1","2024-10-01 03:36:30");
INSERT INTO tbl_expenses VALUES("557","EXP011024103","","17030.00","2024-09-30 00:00:00","0","1","2024-10-01 03:41:45");
INSERT INTO tbl_expenses VALUES("558","EXP011024104","","22000.00","2024-10-01 00:00:00","0","1","2024-10-01 07:09:51");
INSERT INTO tbl_expenses VALUES("559","EXP021024101","","130495.00","2024-10-02 00:00:00","0","1","2024-10-02 05:00:37");
INSERT INTO tbl_expenses VALUES("560","EXP021024102","","12950.00","2024-10-01 00:00:00","0","1","2024-10-02 05:07:09");
INSERT INTO tbl_expenses VALUES("561","EXP031024101","","48580.00","2024-10-02 00:00:00","0","1","2024-10-03 10:47:26");
INSERT INTO tbl_expenses VALUES("562","EXP031024102","","9260.00","2024-10-03 00:00:00","0","1","2024-10-03 10:50:20");
INSERT INTO tbl_expenses VALUES("563","EXP031024103","","70000.00","2024-10-03 00:00:00","0","1","2024-10-03 10:54:50");
INSERT INTO tbl_expenses VALUES("564","EXP031024104","","24105.00","2024-10-03 00:00:00","0","1","2024-10-03 04:17:15");
INSERT INTO tbl_expenses VALUES("565","EXP031024105","","28490.00","2024-10-03 00:00:00","0","1","2024-10-03 07:53:54");
INSERT INTO tbl_expenses VALUES("566","EXP041024101","","32200.00","2024-10-04 00:00:00","0","1","2024-10-04 05:37:28");
INSERT INTO tbl_expenses VALUES("567","EXP051024101","","24200.00","2024-10-04 00:00:00","0","1","2024-10-05 01:40:13");
INSERT INTO tbl_expenses VALUES("568","EXP051024102","","16555.00","2024-10-05 00:00:00","0","1","2024-10-05 02:01:01");
INSERT INTO tbl_expenses VALUES("569","EXP051024103","","3360.00","2024-10-05 00:00:00","0","1","2024-10-05 02:02:11");
INSERT INTO tbl_expenses VALUES("570","EXP051024104","","110590.00","2024-10-05 00:00:00","0","1","2024-10-05 07:38:20");
INSERT INTO tbl_expenses VALUES("571","EXP051024105","","6630.00","2024-10-05 00:00:00","0","1","2024-10-05 07:44:56");
INSERT INTO tbl_expenses VALUES("572","EXP061024101","","44170.00","2024-10-06 00:00:00","0","1","2024-10-06 03:55:55");
INSERT INTO tbl_expenses VALUES("573","EXP061024102","","24545.00","2024-10-06 00:00:00","0","1","2024-10-06 04:05:56");
INSERT INTO tbl_expenses VALUES("574","EXP071024101","","27447.00","2024-10-06 00:00:00","0","1","2024-10-07 02:43:09");
INSERT INTO tbl_expenses VALUES("575","EXP071024102","","42840.00","2024-10-07 00:00:00","0","1","2024-10-07 02:48:37");
INSERT INTO tbl_expenses VALUES("576","EXP071024103","","60860.00","2024-10-07 00:00:00","0","1","2024-10-07 08:49:45");
INSERT INTO tbl_expenses VALUES("577","EXP081024101","","30770.00","2024-10-08 00:00:00","0","1","2024-10-08 02:48:44");



CREATE TABLE `tbl_expensesde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `expid` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4335 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_expensesde VALUES("1","0","1","86","7000.00","");
INSERT INTO tbl_expensesde VALUES("2","0","1","111","270.00","");
INSERT INTO tbl_expensesde VALUES("3","0","1","103","1310.00","");
INSERT INTO tbl_expensesde VALUES("4","0","1","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("5","0","1","164","7000.00","");
INSERT INTO tbl_expensesde VALUES("6","0","2","87","149340.00","");
INSERT INTO tbl_expensesde VALUES("7","0","2","111","3660.00","");
INSERT INTO tbl_expensesde VALUES("8","0","3","170","400.00","খাবার");
INSERT INTO tbl_expensesde VALUES("9","0","3","95","160.00","");
INSERT INTO tbl_expensesde VALUES("10","0","4","85","8500.00","সেলিম");
INSERT INTO tbl_expensesde VALUES("11","0","4","90","20.00","");
INSERT INTO tbl_expensesde VALUES("12","0","4","111","1350.00","");
INSERT INTO tbl_expensesde VALUES("13","0","4","170","260.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("14","0","4","170","40.00","ভিমবার ");
INSERT INTO tbl_expensesde VALUES("15","0","5","87","10000.00","সজিব ");
INSERT INTO tbl_expensesde VALUES("16","0","5","104","348.00","মোবাইল রির্চাজ রিপন ");
INSERT INTO tbl_expensesde VALUES("17","0","5","91","800.00","");
INSERT INTO tbl_expensesde VALUES("18","0","5","86","6080.00","");
INSERT INTO tbl_expensesde VALUES("19","0","5","111","1600.00","");
INSERT INTO tbl_expensesde VALUES("20","0","5","87","10500.00","রিপন ");
INSERT INTO tbl_expensesde VALUES("21","0","5","87","300.00","");
INSERT INTO tbl_expensesde VALUES("22","0","5","171","20.00","");
INSERT INTO tbl_expensesde VALUES("23","0","6","170","50.00","");
INSERT INTO tbl_expensesde VALUES("24","0","6","171","10.00","");
INSERT INTO tbl_expensesde VALUES("25","0","6","85","5000.00","monir");
INSERT INTO tbl_expensesde VALUES("26","0","6","85","18000.00","taurash");
INSERT INTO tbl_expensesde VALUES("27","0","7","158","40.00","");
INSERT INTO tbl_expensesde VALUES("28","0","7","160","100.00","");
INSERT INTO tbl_expensesde VALUES("29","0","7","103","50.00","sirij kagoj");
INSERT INTO tbl_expensesde VALUES("30","0","7","160","420.00","");
INSERT INTO tbl_expensesde VALUES("31","0","7","95","160.00","");
INSERT INTO tbl_expensesde VALUES("32","0","7","170","460.00","rosun,jira,ada");
INSERT INTO tbl_expensesde VALUES("33","0","7","170","2335.00","murgi,oil,salt");
INSERT INTO tbl_expensesde VALUES("34","0","7","170","230.00","torkari");
INSERT INTO tbl_expensesde VALUES("35","0","7","149","1300.00","nut,boltu");
INSERT INTO tbl_expensesde VALUES("36","0","7","149","140.00","bonga");
INSERT INTO tbl_expensesde VALUES("37","0","7","82","160.00","");
INSERT INTO tbl_expensesde VALUES("38","0","7","158","30.00","");
INSERT INTO tbl_expensesde VALUES("39","0","8","171","100.00","");
INSERT INTO tbl_expensesde VALUES("40","0","9","149","130.00","");
INSERT INTO tbl_expensesde VALUES("41","0","9","87","465.00","basir");
INSERT INTO tbl_expensesde VALUES("42","0","9","170","120.00","iftari");
INSERT INTO tbl_expensesde VALUES("43","0","10","149","900.00","GUNA,BORING");
INSERT INTO tbl_expensesde VALUES("44","0","11","103","7400.00","");
INSERT INTO tbl_expensesde VALUES("45","0","11","157","270.00","");
INSERT INTO tbl_expensesde VALUES("46","0","11","87","230.00","");
INSERT INTO tbl_expensesde VALUES("47","0","12","111","150.00","");
INSERT INTO tbl_expensesde VALUES("48","0","12","90","10.00","");
INSERT INTO tbl_expensesde VALUES("49","0","12","111","1630.00","");
INSERT INTO tbl_expensesde VALUES("50","0","12","170","200.00","");
INSERT INTO tbl_expensesde VALUES("51","0","12","90","20.00","");
INSERT INTO tbl_expensesde VALUES("52","0","12","111","1700.00","");
INSERT INTO tbl_expensesde VALUES("53","0","12","86","5110.00","");
INSERT INTO tbl_expensesde VALUES("54","0","13","167","2550.00","");
INSERT INTO tbl_expensesde VALUES("55","0","13","170","100.00","লেবু");
INSERT INTO tbl_expensesde VALUES("56","0","13","90","100.00","");
INSERT INTO tbl_expensesde VALUES("57","0","14","87","5000.00","সজিব ");
INSERT INTO tbl_expensesde VALUES("58","0","14","92","40.00","");
INSERT INTO tbl_expensesde VALUES("59","0","15","111","1900.00","");
INSERT INTO tbl_expensesde VALUES("60","0","15","104","120.00","কলম ");
INSERT INTO tbl_expensesde VALUES("61","0","15","90","200.00","");
INSERT INTO tbl_expensesde VALUES("62","0","16","92","200.00","");
INSERT INTO tbl_expensesde VALUES("63","0","16","104","120.00","মাঠা ");
INSERT INTO tbl_expensesde VALUES("64","0","16","92","230.00","");
INSERT INTO tbl_expensesde VALUES("65","0","16","86","4640.00","");
INSERT INTO tbl_expensesde VALUES("66","0","16","86","8120.00","");
INSERT INTO tbl_expensesde VALUES("67","0","16","95","80.00","");
INSERT INTO tbl_expensesde VALUES("68","0","16","150","900.00","অকটেল");
INSERT INTO tbl_expensesde VALUES("69","0","17","93","100.00","");
INSERT INTO tbl_expensesde VALUES("70","0","17","111","1860.00","");
INSERT INTO tbl_expensesde VALUES("71","0","17","111","1250.00","");
INSERT INTO tbl_expensesde VALUES("72","0","17","89","11000.00","স্ট্যাফ ");
INSERT INTO tbl_expensesde VALUES("73","0","17","89","8000.00","স্যার");
INSERT INTO tbl_expensesde VALUES("74","0","17","105","27000.00","");
INSERT INTO tbl_expensesde VALUES("75","0","17","87","500.00","সাগর");
INSERT INTO tbl_expensesde VALUES("76","0","17","89","1200.00","পিয়ন");
INSERT INTO tbl_expensesde VALUES("77","0","18","170","110.00","বেসন");
INSERT INTO tbl_expensesde VALUES("78","0","18","170","320.00","");
INSERT INTO tbl_expensesde VALUES("79","0","18","170","540.00","ছোলা,তেজপাতা");
INSERT INTO tbl_expensesde VALUES("80","0","18","170","150.00","Torkari");
INSERT INTO tbl_expensesde VALUES("81","0","19","90","400.00","");
INSERT INTO tbl_expensesde VALUES("82","0","19","137","1000.00","ফেতরা ");
INSERT INTO tbl_expensesde VALUES("83","0","19","85","1200.00","");
INSERT INTO tbl_expensesde VALUES("84","0","19","92","270.00","");
INSERT INTO tbl_expensesde VALUES("85","0","19","93","480.00","");
INSERT INTO tbl_expensesde VALUES("86","0","19","86","4860.00","");
INSERT INTO tbl_expensesde VALUES("87","0","19","111","830.00","");
INSERT INTO tbl_expensesde VALUES("88","0","19","90","20.00","");
INSERT INTO tbl_expensesde VALUES("89","0","19","104","80.00","মুডি ");
INSERT INTO tbl_expensesde VALUES("90","0","19","150","10000.00","ব্লুয়ার মটর মেরামত ");
INSERT INTO tbl_expensesde VALUES("91","0","19","92","100.00","");
INSERT INTO tbl_expensesde VALUES("92","0","20","111","450.00","");
INSERT INTO tbl_expensesde VALUES("93","0","20","170","2280.00","ইফতারির বাজার ");
INSERT INTO tbl_expensesde VALUES("94","0","20","85","7000.00","");
INSERT INTO tbl_expensesde VALUES("95","0","20","90","20.00","");
INSERT INTO tbl_expensesde VALUES("96","0","20","170","30.00","কলা");
INSERT INTO tbl_expensesde VALUES("97","0","20","150","30.00","ট্যাপ ");
INSERT INTO tbl_expensesde VALUES("98","0","20","150","3000.00","পুলি ২ টা ");
INSERT INTO tbl_expensesde VALUES("99","0","20","90","20.00","");
INSERT INTO tbl_expensesde VALUES("100","0","21","92","270.00","");
INSERT INTO tbl_expensesde VALUES("101","0","21","90","200.00","");
INSERT INTO tbl_expensesde VALUES("102","0","21","92","100.00","");
INSERT INTO tbl_expensesde VALUES("103","0","21","86","5200.00","");
INSERT INTO tbl_expensesde VALUES("104","0","21","111","350.00","");
INSERT INTO tbl_expensesde VALUES("105","0","21","95","160.00","");
INSERT INTO tbl_expensesde VALUES("106","0","21","90","540.00","");
INSERT INTO tbl_expensesde VALUES("107","0","22","90","20.00","");
INSERT INTO tbl_expensesde VALUES("108","0","22","111","1810.00","");
INSERT INTO tbl_expensesde VALUES("109","0","22","92","100.00","");
INSERT INTO tbl_expensesde VALUES("110","0","22","156","170.00","");
INSERT INTO tbl_expensesde VALUES("111","0","22","170","1895.00","তৈল , শুকনা মরিচ ");
INSERT INTO tbl_expensesde VALUES("112","0","22","170","340.00","কুমড়া , ঢেড়স ");
INSERT INTO tbl_expensesde VALUES("113","0","22","137","1000.00","হিজলা ");
INSERT INTO tbl_expensesde VALUES("114","0","22","150","330.00","রং");
INSERT INTO tbl_expensesde VALUES("115","0","23","94","90.00","হুইল পাউড়ার ");
INSERT INTO tbl_expensesde VALUES("116","0","23","170","1840.00","আপেল , মাল্টা ");
INSERT INTO tbl_expensesde VALUES("117","0","23","13","60.00","");
INSERT INTO tbl_expensesde VALUES("118","0","24","170","200.00","");
INSERT INTO tbl_expensesde VALUES("119","0","24","157","270.00","");
INSERT INTO tbl_expensesde VALUES("120","0","24","86","4930.00","");
INSERT INTO tbl_expensesde VALUES("121","0","25","170","820.00","মুরগি , ঢেড়স ");
INSERT INTO tbl_expensesde VALUES("122","0","25","92","100.00","");
INSERT INTO tbl_expensesde VALUES("123","0","25","86","5000.00","");
INSERT INTO tbl_expensesde VALUES("124","0","25","170","150.00","ইফতার ");
INSERT INTO tbl_expensesde VALUES("125","0","26","137","2780.00","লাকরি ভাঙ্হা ");
INSERT INTO tbl_expensesde VALUES("126","0","26","156","150.00","");
INSERT INTO tbl_expensesde VALUES("127","0","26","171","10.00","");
INSERT INTO tbl_expensesde VALUES("128","0","26","90","40.00","");
INSERT INTO tbl_expensesde VALUES("129","0","26","150","220.00","ট্যাপ");
INSERT INTO tbl_expensesde VALUES("130","0","27","91","80.00","");
INSERT INTO tbl_expensesde VALUES("131","0","27","96","240.00","");
INSERT INTO tbl_expensesde VALUES("132","0","27","95","160.00","");
INSERT INTO tbl_expensesde VALUES("133","0","27","170","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("134","0","27","92","40.00","");
INSERT INTO tbl_expensesde VALUES("135","0","28","111","900.00","709");
INSERT INTO tbl_expensesde VALUES("136","0","28","87","500.00","reyad");
INSERT INTO tbl_expensesde VALUES("137","0","28","157","230.00","");
INSERT INTO tbl_expensesde VALUES("138","0","28","158","270.00","");
INSERT INTO tbl_expensesde VALUES("139","0","28","111","2060.00","salim");
INSERT INTO tbl_expensesde VALUES("140","0","28","86","11440.00","");
INSERT INTO tbl_expensesde VALUES("141","0","29","158","270.00","");
INSERT INTO tbl_expensesde VALUES("142","0","29","171","10.00","");
INSERT INTO tbl_expensesde VALUES("143","0","29","170","2090.00","alu");
INSERT INTO tbl_expensesde VALUES("144","0","30","86","8660.00","");
INSERT INTO tbl_expensesde VALUES("145","0","31","171","40.00","");
INSERT INTO tbl_expensesde VALUES("146","0","31","170","2115.00","কাচাবাজার, ইফতারী বাজার ");
INSERT INTO tbl_expensesde VALUES("147","0","31","94","60.00","কলম");
INSERT INTO tbl_expensesde VALUES("148","0","31","170","300.00","খাবার ");
INSERT INTO tbl_expensesde VALUES("149","0","31","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("150","0","31","90","20.00","");
INSERT INTO tbl_expensesde VALUES("151","0","31","85","3650.00","");
INSERT INTO tbl_expensesde VALUES("152","0","32","90","450.00","");
INSERT INTO tbl_expensesde VALUES("153","0","32","85","1400.00","");
INSERT INTO tbl_expensesde VALUES("154","0","32","103","80.00","এয়ারকুলাম হাওয়া ");
INSERT INTO tbl_expensesde VALUES("155","0","32","111","180.00","");
INSERT INTO tbl_expensesde VALUES("156","0","32","105","15175.00","");
INSERT INTO tbl_expensesde VALUES("157","0","32","171","100.00","");
INSERT INTO tbl_expensesde VALUES("158","0","33","137","340.00","");
INSERT INTO tbl_expensesde VALUES("159","0","34","170","1415.00","কুমড়া .তৈল ,ডিম ");
INSERT INTO tbl_expensesde VALUES("160","0","34","167","1500.00","");
INSERT INTO tbl_expensesde VALUES("161","0","34","92","100.00","");
INSERT INTO tbl_expensesde VALUES("162","0","34","171","30.00","");
INSERT INTO tbl_expensesde VALUES("163","0","34","170","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("164","0","35","171","100.00","");
INSERT INTO tbl_expensesde VALUES("165","0","35","92","100.00","");
INSERT INTO tbl_expensesde VALUES("166","0","35","111","2140.00","");
INSERT INTO tbl_expensesde VALUES("167","0","35","150","80.00","");
INSERT INTO tbl_expensesde VALUES("168","0","35","90","20.00","");
INSERT INTO tbl_expensesde VALUES("169","0","36","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("170","0","36","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("171","0","37","156","150.00","");
INSERT INTO tbl_expensesde VALUES("172","0","37","16","229380.00","");
INSERT INTO tbl_expensesde VALUES("173","0","38","156","60.00","");
INSERT INTO tbl_expensesde VALUES("174","0","39","171","10.00","");
INSERT INTO tbl_expensesde VALUES("175","0","39","157","270.00","");
INSERT INTO tbl_expensesde VALUES("176","0","39","86","300.00","");
INSERT INTO tbl_expensesde VALUES("177","0","39","86","10915.00","");
INSERT INTO tbl_expensesde VALUES("178","0","39","95","160.00","");
INSERT INTO tbl_expensesde VALUES("179","0","39","170","40.00","MURI");
INSERT INTO tbl_expensesde VALUES("180","0","39","165","1800.00","SUJUKI");
INSERT INTO tbl_expensesde VALUES("181","0","39","170","200.00","");
INSERT INTO tbl_expensesde VALUES("182","0","39","158","20.00","");
INSERT INTO tbl_expensesde VALUES("183","0","40","90","200.00","");
INSERT INTO tbl_expensesde VALUES("184","0","40","171","30.00","");
INSERT INTO tbl_expensesde VALUES("185","0","40","90","20.00","");
INSERT INTO tbl_expensesde VALUES("186","0","40","170","850.00","হলুদ , মরিচ গুড়া , তরকারি");
INSERT INTO tbl_expensesde VALUES("187","0","40","104","630.00","ইফতারি আপেল ");
INSERT INTO tbl_expensesde VALUES("188","0","41","150","200000.00","পেটি বাবদ রুবেল সিরাজগঞ ");
INSERT INTO tbl_expensesde VALUES("189","0","41","171","120.00","");
INSERT INTO tbl_expensesde VALUES("190","0","41","170","300.00","খাবার");
INSERT INTO tbl_expensesde VALUES("191","0","42","171","10.00","");
INSERT INTO tbl_expensesde VALUES("192","0","42","137","1000.00","ফেতরা ");
INSERT INTO tbl_expensesde VALUES("193","0","42","104","20.00","মুডি");
INSERT INTO tbl_expensesde VALUES("194","0","42","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("195","0","42","111","630.00","");
INSERT INTO tbl_expensesde VALUES("196","0","42","103","4400.00","তাউরাস মবিল, ফিল্টার ডিজে");
INSERT INTO tbl_expensesde VALUES("197","0","42","92","270.00","");
INSERT INTO tbl_expensesde VALUES("198","0","42","87","500.00","");
INSERT INTO tbl_expensesde VALUES("199","0","42","106","5030.00","");
INSERT INTO tbl_expensesde VALUES("200","0","43","137","900.00","ফেতরা ");
INSERT INTO tbl_expensesde VALUES("201","0","43","90","200.00","");
INSERT INTO tbl_expensesde VALUES("202","0","43","171","10.00","");
INSERT INTO tbl_expensesde VALUES("203","0","43","104","100.00","মোবাইল খরচ রিপন ");
INSERT INTO tbl_expensesde VALUES("204","0","43","156","150.00","");
INSERT INTO tbl_expensesde VALUES("205","0","44","86","13080.00","");
INSERT INTO tbl_expensesde VALUES("206","0","44","86","7700.00","");
INSERT INTO tbl_expensesde VALUES("207","0","44","92","270.00","");
INSERT INTO tbl_expensesde VALUES("208","0","44","103","2310.00","মালামাল মুজরি ");
INSERT INTO tbl_expensesde VALUES("209","0","44","111","920.00","709");
INSERT INTO tbl_expensesde VALUES("210","0","44","103","41800.00","709 টায়ার ক্রয় ");
INSERT INTO tbl_expensesde VALUES("211","0","44","91","500.00","");
INSERT INTO tbl_expensesde VALUES("212","0","44","90","40.00","");
INSERT INTO tbl_expensesde VALUES("213","0","44","137","400.00","ফেতরা");
INSERT INTO tbl_expensesde VALUES("214","0","44","170","3800.00","ইফতারি বাজার ");
INSERT INTO tbl_expensesde VALUES("215","0","44","171","100.00","");
INSERT INTO tbl_expensesde VALUES("216","0","44","170","360.00","");
INSERT INTO tbl_expensesde VALUES("217","0","44","90","70.00","");
INSERT INTO tbl_expensesde VALUES("218","0","44","170","300.00","খাবার");
INSERT INTO tbl_expensesde VALUES("219","0","45","170","1235.00","মুরগি , গরম মশলা ");
INSERT INTO tbl_expensesde VALUES("220","0","45","103","260.00","চাক্কা তৈরী , পাউটার , ");
INSERT INTO tbl_expensesde VALUES("221","0","45","103","400.00","ট্রান্সপোট ");
INSERT INTO tbl_expensesde VALUES("222","0","46","90","50.00","");
INSERT INTO tbl_expensesde VALUES("223","0","46","138","31800.00","oclsd");
INSERT INTO tbl_expensesde VALUES("224","0","46","138","1000.00","");
INSERT INTO tbl_expensesde VALUES("225","0","46","138","3000.00","বকশিস");
INSERT INTO tbl_expensesde VALUES("226","0","46","137","5000.00","বিসিক স্টেড অফিসার কে ");
INSERT INTO tbl_expensesde VALUES("227","0","47","103","12200.00","SAHARA MOTORS");
INSERT INTO tbl_expensesde VALUES("228","0","47","103","600.00","MA BA BA MOTOTORS");
INSERT INTO tbl_expensesde VALUES("229","0","47","171","10.00","");
INSERT INTO tbl_expensesde VALUES("230","0","47","165","1420.00","CLASS PLATE");
INSERT INTO tbl_expensesde VALUES("231","0","47","165","600.00","MOBIL");
INSERT INTO tbl_expensesde VALUES("232","0","47","85","12450.00","SALIM");
INSERT INTO tbl_expensesde VALUES("233","0","47","149","3000.00","SEWING MACHINE");
INSERT INTO tbl_expensesde VALUES("234","0","48","158","120.00","");
INSERT INTO tbl_expensesde VALUES("235","0","49","21","34100.00","");
INSERT INTO tbl_expensesde VALUES("236","0","50","90","100.00","");
INSERT INTO tbl_expensesde VALUES("237","0","50","170","630.00","চিনি . টোকনারদানা ");
INSERT INTO tbl_expensesde VALUES("238","0","50","90","20.00","");
INSERT INTO tbl_expensesde VALUES("239","0","50","104","230.00","ডিস বিল ");
INSERT INTO tbl_expensesde VALUES("240","0","50","90","230.00","");
INSERT INTO tbl_expensesde VALUES("241","0","50","87","5000.00","রিপন ");
INSERT INTO tbl_expensesde VALUES("242","0","50","137","2000.00","সাংবাদিক কে ");
INSERT INTO tbl_expensesde VALUES("243","0","51","98","600.00","মালামাল ");
INSERT INTO tbl_expensesde VALUES("244","0","52","111","1100.00","");
INSERT INTO tbl_expensesde VALUES("245","0","52","87","700.00","");
INSERT INTO tbl_expensesde VALUES("246","0","52","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("247","0","52","87","1980.00","");
INSERT INTO tbl_expensesde VALUES("248","0","52","87","3000.00","");
INSERT INTO tbl_expensesde VALUES("249","0","52","170","1185.00","ড়েরস তৈল ");
INSERT INTO tbl_expensesde VALUES("250","0","52","137","300.00","ফেতরা");
INSERT INTO tbl_expensesde VALUES("251","0","53","137","10000.00","বিসিক অফিস বোনাস ");
INSERT INTO tbl_expensesde VALUES("252","0","53","150","1900.00","সেলফের মটর ");
INSERT INTO tbl_expensesde VALUES("253","0","53","150","200.00","হেডের সীল ");
INSERT INTO tbl_expensesde VALUES("254","0","53","150","540.00","");
INSERT INTO tbl_expensesde VALUES("255","0","53","13","315.00","");
INSERT INTO tbl_expensesde VALUES("256","0","53","171","40.00","");
INSERT INTO tbl_expensesde VALUES("257","0","53","162","1520.00","");
INSERT INTO tbl_expensesde VALUES("258","0","54","150","670.00","বিয়ারিং + ভাড়া ");
INSERT INTO tbl_expensesde VALUES("259","0","54","150","9000.00","বিয়ারিং ");
INSERT INTO tbl_expensesde VALUES("260","0","55","95","320.00","");
INSERT INTO tbl_expensesde VALUES("261","0","55","87","163200.00","");
INSERT INTO tbl_expensesde VALUES("262","0","56","149","100.00","cutting pathor");
INSERT INTO tbl_expensesde VALUES("263","0","56","87","12000.00","sohrab");
INSERT INTO tbl_expensesde VALUES("264","0","56","157","270.00","");
INSERT INTO tbl_expensesde VALUES("265","0","56","157","200.00","");
INSERT INTO tbl_expensesde VALUES("266","0","56","111","2110.00","9961");
INSERT INTO tbl_expensesde VALUES("267","0","56","86","13590.00","");
INSERT INTO tbl_expensesde VALUES("268","0","57","176","400.00","");
INSERT INTO tbl_expensesde VALUES("269","0","57","87","6500.00","MOSTAFIZ");
INSERT INTO tbl_expensesde VALUES("270","0","57","87","4000.00","");
INSERT INTO tbl_expensesde VALUES("271","0","57","176","200.00","");
INSERT INTO tbl_expensesde VALUES("272","0","58","111","1650.00","");
INSERT INTO tbl_expensesde VALUES("273","0","58","87","5000.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("274","0","59","176","1600.00","");
INSERT INTO tbl_expensesde VALUES("275","0","59","170","335.00","তরকারি , ");
INSERT INTO tbl_expensesde VALUES("276","0","59","148","200.00","");
INSERT INTO tbl_expensesde VALUES("277","0","59","156","150.00","");
INSERT INTO tbl_expensesde VALUES("278","0","59","138","12000.00","");
INSERT INTO tbl_expensesde VALUES("279","0","59","103","50.00","পানি");
INSERT INTO tbl_expensesde VALUES("280","0","59","171","10.00","");
INSERT INTO tbl_expensesde VALUES("281","0","60","176","250000.00","");
INSERT INTO tbl_expensesde VALUES("282","0","60","103","1000.00","");
INSERT INTO tbl_expensesde VALUES("283","0","60","150","300.00","তার ফিন , রং ");
INSERT INTO tbl_expensesde VALUES("284","0","61","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("285","0","61","137","150.00","কুরিয়ার র্চাজ ");
INSERT INTO tbl_expensesde VALUES("286","0","61","170","400.00","খাবার");
INSERT INTO tbl_expensesde VALUES("287","0","61","138","4600.00","");
INSERT INTO tbl_expensesde VALUES("288","0","62","158","50.00","");
INSERT INTO tbl_expensesde VALUES("289","0","62","27","85.00","");
INSERT INTO tbl_expensesde VALUES("290","0","62","157","300.00","");
INSERT INTO tbl_expensesde VALUES("291","0","62","87","2000.00","riyad");
INSERT INTO tbl_expensesde VALUES("292","0","62","160","50.00","");
INSERT INTO tbl_expensesde VALUES("293","0","62","19","100.00","");
INSERT INTO tbl_expensesde VALUES("294","0","62","20","450.00","");
INSERT INTO tbl_expensesde VALUES("295","0","62","170","420.00","");
INSERT INTO tbl_expensesde VALUES("296","0","62","158","20.00","");
INSERT INTO tbl_expensesde VALUES("297","0","62","156","450.00","");
INSERT INTO tbl_expensesde VALUES("298","0","62","170","50.00","");
INSERT INTO tbl_expensesde VALUES("299","0","63","92","230.00","");
INSERT INTO tbl_expensesde VALUES("300","0","63","162","1000.00","রিপন");
INSERT INTO tbl_expensesde VALUES("301","0","63","170","150.00","");
INSERT INTO tbl_expensesde VALUES("302","0","63","156","150.00","");
INSERT INTO tbl_expensesde VALUES("303","0","63","87","23500.00","");
INSERT INTO tbl_expensesde VALUES("304","0","63","170","140.00","খাবার");
INSERT INTO tbl_expensesde VALUES("305","0","63","90","10.00","");
INSERT INTO tbl_expensesde VALUES("306","0","63","137","15.00","বিকাশ ");
INSERT INTO tbl_expensesde VALUES("307","0","64","109","100.00","খেজুর ");
INSERT INTO tbl_expensesde VALUES("308","0","64","104","60.00","পিন ");
INSERT INTO tbl_expensesde VALUES("309","0","64","90","50.00","");
INSERT INTO tbl_expensesde VALUES("310","0","64","170","310.00","ডিম ");
INSERT INTO tbl_expensesde VALUES("311","0","64","170","160.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("312","0","65","170","40.00","শসা ");
INSERT INTO tbl_expensesde VALUES("313","0","65","138","4300.00","");
INSERT INTO tbl_expensesde VALUES("314","0","65","85","5760.00","");
INSERT INTO tbl_expensesde VALUES("315","0","65","92","240.00","");
INSERT INTO tbl_expensesde VALUES("316","0","66","167","2350.00","");
INSERT INTO tbl_expensesde VALUES("317","0","66","170","100.00","");
INSERT INTO tbl_expensesde VALUES("318","0","66","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("319","0","66","111","950.00","");
INSERT INTO tbl_expensesde VALUES("320","0","66","150","200.00","সুতা . ওয়ালিং রড় ");
INSERT INTO tbl_expensesde VALUES("321","0","67","170","720.00","ইফতারি বাজার ");
INSERT INTO tbl_expensesde VALUES("322","0","67","111","500.00","");
INSERT INTO tbl_expensesde VALUES("323","0","67","13","315.00","");
INSERT INTO tbl_expensesde VALUES("324","0","67","137","300.00","কোরিয়ার");
INSERT INTO tbl_expensesde VALUES("325","0","67","90","50.00","");
INSERT INTO tbl_expensesde VALUES("326","0","67","92","100.00","");
INSERT INTO tbl_expensesde VALUES("327","0","67","87","12000.00","");
INSERT INTO tbl_expensesde VALUES("328","0","67","170","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("329","0","68","87","10000.00","");
INSERT INTO tbl_expensesde VALUES("330","0","68","111","120.00","");
INSERT INTO tbl_expensesde VALUES("331","0","68","111","60.00","");
INSERT INTO tbl_expensesde VALUES("332","0","68","99","760.00","");
INSERT INTO tbl_expensesde VALUES("333","0","68","91","720.00","");
INSERT INTO tbl_expensesde VALUES("334","0","68","91","460.00","");
INSERT INTO tbl_expensesde VALUES("335","0","68","92","230.00","");
INSERT INTO tbl_expensesde VALUES("336","0","68","95","80.00","");
INSERT INTO tbl_expensesde VALUES("337","0","68","94","800.00","নেট বিল");
INSERT INTO tbl_expensesde VALUES("338","0","69","86","15265.00","");
INSERT INTO tbl_expensesde VALUES("339","0","69","138","4300.00","");
INSERT INTO tbl_expensesde VALUES("340","0","69","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("341","0","70","99","1200.00","");
INSERT INTO tbl_expensesde VALUES("342","0","70","156","150.00","");
INSERT INTO tbl_expensesde VALUES("343","0","70","170","1365.00","");
INSERT INTO tbl_expensesde VALUES("344","0","70","85","13400.00","");
INSERT INTO tbl_expensesde VALUES("345","0","70","90","10.00","");
INSERT INTO tbl_expensesde VALUES("346","0","70","103","2000.00","হাসান ");
INSERT INTO tbl_expensesde VALUES("347","0","70","171","2000.00","");
INSERT INTO tbl_expensesde VALUES("348","0","70","176","6000.00","");
INSERT INTO tbl_expensesde VALUES("349","0","70","90","10.00","");
INSERT INTO tbl_expensesde VALUES("350","0","71","87","105300.00","বোনাস ");
INSERT INTO tbl_expensesde VALUES("351","0","71","87","38200.00","বোনাস ");
INSERT INTO tbl_expensesde VALUES("352","0","72","87","1000.00","বকুল বোনাস ");
INSERT INTO tbl_expensesde VALUES("353","0","72","90","10.00","");
INSERT INTO tbl_expensesde VALUES("354","0","72","87","15000.00","লেবার বোনাস ");
INSERT INTO tbl_expensesde VALUES("355","0","72","87","10000.00","");
INSERT INTO tbl_expensesde VALUES("356","0","72","92","40.00","");
INSERT INTO tbl_expensesde VALUES("357","0","72","95","160.00","");
INSERT INTO tbl_expensesde VALUES("358","0","72","92","160.00","");
INSERT INTO tbl_expensesde VALUES("359","0","72","90","20.00","");
INSERT INTO tbl_expensesde VALUES("360","0","73","176","10000.00","");
INSERT INTO tbl_expensesde VALUES("361","0","73","87","41940.00","");
INSERT INTO tbl_expensesde VALUES("362","0","73","92","290.00","");
INSERT INTO tbl_expensesde VALUES("363","0","73","86","620.00","");
INSERT INTO tbl_expensesde VALUES("364","0","73","111","940.00","");
INSERT INTO tbl_expensesde VALUES("365","0","73","156","300.00","");
INSERT INTO tbl_expensesde VALUES("366","0","73","90","540.00","");
INSERT INTO tbl_expensesde VALUES("367","0","73","176","1000.00","");
INSERT INTO tbl_expensesde VALUES("368","0","73","170","100.00","");
INSERT INTO tbl_expensesde VALUES("369","0","73","86","11330.00","");
INSERT INTO tbl_expensesde VALUES("370","0","73","171","30.00","");
INSERT INTO tbl_expensesde VALUES("371","0","73","170","100.00","");
INSERT INTO tbl_expensesde VALUES("372","0","73","162","1200.00","");
INSERT INTO tbl_expensesde VALUES("373","0","73","92","100.00","");
INSERT INTO tbl_expensesde VALUES("374","0","74","85","3000.00","MONIR");
INSERT INTO tbl_expensesde VALUES("375","0","74","158","20.00","");
INSERT INTO tbl_expensesde VALUES("376","0","74","87","3000.00","KALACHAN");
INSERT INTO tbl_expensesde VALUES("377","0","74","157","200.00","");
INSERT INTO tbl_expensesde VALUES("378","0","74","111","2910.00","KALACHAN");
INSERT INTO tbl_expensesde VALUES("379","0","74","91","1200.00","");
INSERT INTO tbl_expensesde VALUES("380","0","74","103","1000.00","ANAMUL");
INSERT INTO tbl_expensesde VALUES("381","0","74","156","400.00","");
INSERT INTO tbl_expensesde VALUES("382","0","74","87","2000.00","SARAFAT");
INSERT INTO tbl_expensesde VALUES("383","0","75","170","300.00","খাবার");
INSERT INTO tbl_expensesde VALUES("384","0","75","87","10000.00","সজিব");
INSERT INTO tbl_expensesde VALUES("385","0","75","104","1180.00","");
INSERT INTO tbl_expensesde VALUES("386","0","75","129","400.00","তালা + সিম ");
INSERT INTO tbl_expensesde VALUES("387","0","75","170","130.00","ইফতারি ");
INSERT INTO tbl_expensesde VALUES("388","0","75","170","2500.00","খোরাকি ");
INSERT INTO tbl_expensesde VALUES("389","0","75","91","1000.00","");
INSERT INTO tbl_expensesde VALUES("390","0","75","150","1050.00","হাডওয়ার বিল, তালা ");
INSERT INTO tbl_expensesde VALUES("391","0","75","86","5700.00","");
INSERT INTO tbl_expensesde VALUES("392","0","75","91","400.00","");
INSERT INTO tbl_expensesde VALUES("393","0","76","111","2910.00","");
INSERT INTO tbl_expensesde VALUES("394","0","77","103","150.00","চাক্কা  মেরামত ");
INSERT INTO tbl_expensesde VALUES("395","0","77","170","210.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("396","0","77","170","240.00","ডাল, ");
INSERT INTO tbl_expensesde VALUES("397","0","77","104","240.00","নাস্তা ");
INSERT INTO tbl_expensesde VALUES("398","0","78","104","420.00","মোবাইল খরচ ");
INSERT INTO tbl_expensesde VALUES("399","0","78","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("400","0","78","90","40.00","");
INSERT INTO tbl_expensesde VALUES("401","0","78","92","270.00","");
INSERT INTO tbl_expensesde VALUES("402","0","78","170","30.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("403","0","78","94","75.00","");
INSERT INTO tbl_expensesde VALUES("404","0","78","94","30.00","চা পাতা");
INSERT INTO tbl_expensesde VALUES("405","0","79","170","300.00","");
INSERT INTO tbl_expensesde VALUES("406","0","79","86","560.00","");
INSERT INTO tbl_expensesde VALUES("407","0","79","150","980.00","বিয়ারিং বল্টু ");
INSERT INTO tbl_expensesde VALUES("408","0","80","170","110.00","শাক ");
INSERT INTO tbl_expensesde VALUES("409","0","80","156","170.00","");
INSERT INTO tbl_expensesde VALUES("410","0","80","90","330.00","");
INSERT INTO tbl_expensesde VALUES("411","0","80","171","10.00","");
INSERT INTO tbl_expensesde VALUES("412","0","80","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("413","0","81","85","4110.00","");
INSERT INTO tbl_expensesde VALUES("414","0","81","95","160.00","");
INSERT INTO tbl_expensesde VALUES("415","0","81","104","50.00","বিস্কুট");
INSERT INTO tbl_expensesde VALUES("416","0","81","90","300.00","");
INSERT INTO tbl_expensesde VALUES("417","0","81","86","6340.00","");
INSERT INTO tbl_expensesde VALUES("418","0","81","170","220.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("419","0","82","87","6500.00","MOSTAFIZ BONUS");
INSERT INTO tbl_expensesde VALUES("420","0","82","157","270.00","");
INSERT INTO tbl_expensesde VALUES("421","0","83","90","20.00","");
INSERT INTO tbl_expensesde VALUES("422","0","83","162","1200.00","");
INSERT INTO tbl_expensesde VALUES("423","0","83","90","30.00","");
INSERT INTO tbl_expensesde VALUES("424","0","83","86","665.00","");
INSERT INTO tbl_expensesde VALUES("425","0","83","170","80.00","");
INSERT INTO tbl_expensesde VALUES("426","0","83","103","100.00","এনামুল মিস্তী ");
INSERT INTO tbl_expensesde VALUES("427","0","83","170","850.00","ডাল , ডিম");
INSERT INTO tbl_expensesde VALUES("428","0","84","111","600.00","");
INSERT INTO tbl_expensesde VALUES("429","0","84","90","20.00","");
INSERT INTO tbl_expensesde VALUES("430","0","84","86","60.00","");
INSERT INTO tbl_expensesde VALUES("431","0","84","111","550.00","");
INSERT INTO tbl_expensesde VALUES("432","0","84","111","1150.00","");
INSERT INTO tbl_expensesde VALUES("433","0","84","86","6270.00","");
INSERT INTO tbl_expensesde VALUES("434","0","84","92","300.00","");
INSERT INTO tbl_expensesde VALUES("435","0","84","170","420.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("436","0","85","90","40.00","");
INSERT INTO tbl_expensesde VALUES("437","0","85","90","300.00","");
INSERT INTO tbl_expensesde VALUES("438","0","85","164","39500.00","");
INSERT INTO tbl_expensesde VALUES("439","0","85","156","150.00","");
INSERT INTO tbl_expensesde VALUES("440","0","85","138","5800.00","");
INSERT INTO tbl_expensesde VALUES("441","0","85","170","1140.00","");
INSERT INTO tbl_expensesde VALUES("442","0","86","85","5910.00","");
INSERT INTO tbl_expensesde VALUES("443","0","86","150","80.00","");
INSERT INTO tbl_expensesde VALUES("444","0","86","90","20.00","");
INSERT INTO tbl_expensesde VALUES("445","0","86","95","160.00","");
INSERT INTO tbl_expensesde VALUES("446","0","86","170","140.00","তরকারিা");
INSERT INTO tbl_expensesde VALUES("447","0","86","162","1460.00","");
INSERT INTO tbl_expensesde VALUES("448","0","86","85","6500.00","");
INSERT INTO tbl_expensesde VALUES("449","0","86","111","950.00","");
INSERT INTO tbl_expensesde VALUES("450","0","86","92","300.00","");
INSERT INTO tbl_expensesde VALUES("451","0","86","86","9210.00","");
INSERT INTO tbl_expensesde VALUES("452","0","86","86","3500.00","জাতায়াত খরচ");
INSERT INTO tbl_expensesde VALUES("453","0","87","90","20.00","");
INSERT INTO tbl_expensesde VALUES("454","0","87","85","2700.00","");
INSERT INTO tbl_expensesde VALUES("455","0","87","90","20.00","");
INSERT INTO tbl_expensesde VALUES("456","0","88","170","2510.00","ডাল ");
INSERT INTO tbl_expensesde VALUES("457","0","88","170","1220.00","তৈল, মুখ ডাল ");
INSERT INTO tbl_expensesde VALUES("458","0","88","164","8000.00","");
INSERT INTO tbl_expensesde VALUES("459","0","89","104","1400.00","থাইর লাইন লাগানো ");
INSERT INTO tbl_expensesde VALUES("460","0","90","111","1570.00","");
INSERT INTO tbl_expensesde VALUES("461","0","90","92","40.00","");
INSERT INTO tbl_expensesde VALUES("462","0","90","170","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("463","0","90","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("464","0","91","87","3400.00","রিয়াদ ");
INSERT INTO tbl_expensesde VALUES("465","0","91","87","8000.00","");
INSERT INTO tbl_expensesde VALUES("466","0","91","92","260.00","");
INSERT INTO tbl_expensesde VALUES("467","0","91","86","11020.00","");
INSERT INTO tbl_expensesde VALUES("468","0","91","104","75.00","চিনি");
INSERT INTO tbl_expensesde VALUES("469","0","91","104","80.00","কলম ");
INSERT INTO tbl_expensesde VALUES("470","0","91","90","20.00","");
INSERT INTO tbl_expensesde VALUES("471","0","91","111","450.00","");
INSERT INTO tbl_expensesde VALUES("472","0","92","170","7000.00","মুরগি অনন্য ");
INSERT INTO tbl_expensesde VALUES("473","0","92","170","1250.00","আলেক খোরাকি ");
INSERT INTO tbl_expensesde VALUES("474","0","92","90","40.00","");
INSERT INTO tbl_expensesde VALUES("475","0","92","95","80.00","");
INSERT INTO tbl_expensesde VALUES("476","0","92","90","40.00","");
INSERT INTO tbl_expensesde VALUES("477","0","93","165","100.00","");
INSERT INTO tbl_expensesde VALUES("478","0","93","27","20.00","");
INSERT INTO tbl_expensesde VALUES("479","0","93","158","600.00","");
INSERT INTO tbl_expensesde VALUES("480","0","94","104","80.00","ডিটারজেন ");
INSERT INTO tbl_expensesde VALUES("481","0","94","91","300.00","");
INSERT INTO tbl_expensesde VALUES("482","0","94","150","5120.00","বকুল ");
INSERT INTO tbl_expensesde VALUES("483","0","94","92","170.00","");
INSERT INTO tbl_expensesde VALUES("484","0","94","156","150.00","");
INSERT INTO tbl_expensesde VALUES("485","0","94","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("486","0","95","150","2000.00","সেলাই মেশিন মেরামত ");
INSERT INTO tbl_expensesde VALUES("487","0","95","170","250.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("488","0","96","162","710.00","");
INSERT INTO tbl_expensesde VALUES("489","0","96","165","2400.00","মবিল , ক্লাস প্লেট , ");
INSERT INTO tbl_expensesde VALUES("490","0","96","150","750.00","কাটিং পাথর ");
INSERT INTO tbl_expensesde VALUES("491","0","96","90","60.00","");
INSERT INTO tbl_expensesde VALUES("492","0","96","103","500.00","মালামাল ");
INSERT INTO tbl_expensesde VALUES("493","0","96","103","150.00","");
INSERT INTO tbl_expensesde VALUES("494","0","96","85","13130.00","");
INSERT INTO tbl_expensesde VALUES("495","0","97","87","175390.00","");
INSERT INTO tbl_expensesde VALUES("496","0","98","95","160.00","");
INSERT INTO tbl_expensesde VALUES("497","0","98","167","2550.00","");
INSERT INTO tbl_expensesde VALUES("498","0","98","111","1250.00","");
INSERT INTO tbl_expensesde VALUES("499","0","98","170","500.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("500","0","98","111","1250.00","");
INSERT INTO tbl_expensesde VALUES("501","0","98","86","8825.00","");
INSERT INTO tbl_expensesde VALUES("502","0","98","92","230.00","");
INSERT INTO tbl_expensesde VALUES("503","0","98","86","8825.00","");
INSERT INTO tbl_expensesde VALUES("504","0","98","104","130.00","হারপিক ");
INSERT INTO tbl_expensesde VALUES("505","0","98","90","20.00","");
INSERT INTO tbl_expensesde VALUES("506","0","99","104","2000.00","রাব্বি বিয়া ");
INSERT INTO tbl_expensesde VALUES("507","0","99","92","100.00","");
INSERT INTO tbl_expensesde VALUES("508","0","99","111","6005.00","");
INSERT INTO tbl_expensesde VALUES("509","0","99","91","800.00","");
INSERT INTO tbl_expensesde VALUES("510","0","99","90","20.00","");
INSERT INTO tbl_expensesde VALUES("511","0","99","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("512","0","99","170","1615.00","");
INSERT INTO tbl_expensesde VALUES("513","0","99","103","300.00","গ্রিজ ");
INSERT INTO tbl_expensesde VALUES("514","0","99","87","9070.00","সেলিম");
INSERT INTO tbl_expensesde VALUES("515","0","99","156","300.00","");
INSERT INTO tbl_expensesde VALUES("516","0","99","111","600.00","");
INSERT INTO tbl_expensesde VALUES("517","0","99","95","80.00","");
INSERT INTO tbl_expensesde VALUES("518","0","99","170","450.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("519","0","99","104","350.00","মোবাইল খরচ রিপন ");
INSERT INTO tbl_expensesde VALUES("520","0","99","87","2000.00","রিপন ");
INSERT INTO tbl_expensesde VALUES("521","0","99","111","4610.00","");
INSERT INTO tbl_expensesde VALUES("522","0","99","171","200.00","");
INSERT INTO tbl_expensesde VALUES("523","0","99","86","11380.00","");
INSERT INTO tbl_expensesde VALUES("524","0","99","92","230.00","");
INSERT INTO tbl_expensesde VALUES("525","0","99","87","2000.00","রিপন ");
INSERT INTO tbl_expensesde VALUES("526","0","99","170","6000.00","আলু ,পেয়াজ ");
INSERT INTO tbl_expensesde VALUES("527","0","99","90","100.00","");
INSERT INTO tbl_expensesde VALUES("528","0","99","90","220.00","");
INSERT INTO tbl_expensesde VALUES("529","0","99","86","150.00","");
INSERT INTO tbl_expensesde VALUES("530","0","99","111","1730.00","");
INSERT INTO tbl_expensesde VALUES("531","0","99","90","220.00","");
INSERT INTO tbl_expensesde VALUES("532","0","100","137","50.00","ভ্যানের টিউব ");
INSERT INTO tbl_expensesde VALUES("533","0","100","104","200.00","বাটি ");
INSERT INTO tbl_expensesde VALUES("534","0","101","170","50.00","লবন ভিমবার ");
INSERT INTO tbl_expensesde VALUES("535","0","101","90","20.00","");
INSERT INTO tbl_expensesde VALUES("536","0","101","164","18540.00","");
INSERT INTO tbl_expensesde VALUES("537","0","101","111","1860.00","");
INSERT INTO tbl_expensesde VALUES("538","0","101","171","10.00","");
INSERT INTO tbl_expensesde VALUES("539","0","101","90","40.00","");
INSERT INTO tbl_expensesde VALUES("540","0","101","170","1247.00","কাচামরিচ , অনন্য");
INSERT INTO tbl_expensesde VALUES("541","0","102","137","600.00","বাবুচি হালখাতা ");
INSERT INTO tbl_expensesde VALUES("542","0","102","111","750.00","");
INSERT INTO tbl_expensesde VALUES("543","0","103","86","15430.00","");
INSERT INTO tbl_expensesde VALUES("544","0","103","86","180.00","nasta");
INSERT INTO tbl_expensesde VALUES("545","0","103","99","900.00","");
INSERT INTO tbl_expensesde VALUES("546","0","103","99","1500.00","");
INSERT INTO tbl_expensesde VALUES("547","0","103","157","230.00","");
INSERT INTO tbl_expensesde VALUES("548","0","103","158","20.00","");
INSERT INTO tbl_expensesde VALUES("549","0","103","170","450.00","");
INSERT INTO tbl_expensesde VALUES("550","0","104","171","10.00","");
INSERT INTO tbl_expensesde VALUES("551","0","104","90","70.00","");
INSERT INTO tbl_expensesde VALUES("552","0","104","111","150.00","");
INSERT INTO tbl_expensesde VALUES("553","0","104","170","10160.00","চাল");
INSERT INTO tbl_expensesde VALUES("554","0","104","170","360.00","ডিম অনন্য");
INSERT INTO tbl_expensesde VALUES("555","0","104","89","57200.00","ডিলার , পিয়ন,টিসি, ট্রাজা");
INSERT INTO tbl_expensesde VALUES("556","0","105","170","8900.00","হালখাতা কাচা বাজার ");
INSERT INTO tbl_expensesde VALUES("557","0","105","85","11200.00","");
INSERT INTO tbl_expensesde VALUES("558","0","105","90","240.00","");
INSERT INTO tbl_expensesde VALUES("559","0","106","99","1210.00","");
INSERT INTO tbl_expensesde VALUES("560","0","106","92","230.00","");
INSERT INTO tbl_expensesde VALUES("561","0","106","170","14470.00","হালখাতা মুরগি ");
INSERT INTO tbl_expensesde VALUES("562","0","106","92","230.00","");
INSERT INTO tbl_expensesde VALUES("563","0","106","170","4320.00","7");
INSERT INTO tbl_expensesde VALUES("564","0","107","86","360.00","");
INSERT INTO tbl_expensesde VALUES("565","0","107","86","8260.00","");
INSERT INTO tbl_expensesde VALUES("566","0","107","158","810.00","");
INSERT INTO tbl_expensesde VALUES("567","0","108","92","230.00","");
INSERT INTO tbl_expensesde VALUES("568","0","108","150","3000.00","");
INSERT INTO tbl_expensesde VALUES("569","0","108","109","7200.00","হালখাতা ডেকোরেটর বিল ");
INSERT INTO tbl_expensesde VALUES("570","0","108","86","7302.00","");
INSERT INTO tbl_expensesde VALUES("571","0","108","111","1630.00","");
INSERT INTO tbl_expensesde VALUES("572","0","108","111","9470.00","");
INSERT INTO tbl_expensesde VALUES("573","0","108","109","6500.00","হালখাতা বাবুচি ");
INSERT INTO tbl_expensesde VALUES("574","0","108","164","18550.00","");
INSERT INTO tbl_expensesde VALUES("575","0","108","170","560.00","গামছা ");
INSERT INTO tbl_expensesde VALUES("576","0","109","170","300.00","হালখাতা ব্যানার ");
INSERT INTO tbl_expensesde VALUES("577","0","109","170","19200.00","টিসু , ভাড়া .রুই মাছ , ঘি");
INSERT INTO tbl_expensesde VALUES("578","0","109","170","2680.00","");
INSERT INTO tbl_expensesde VALUES("579","0","110","111","1000.00","");
INSERT INTO tbl_expensesde VALUES("580","0","110","111","2160.00","");
INSERT INTO tbl_expensesde VALUES("581","0","110","156","150.00","");
INSERT INTO tbl_expensesde VALUES("582","0","110","90","20.00","");
INSERT INTO tbl_expensesde VALUES("583","0","110","85","5250.00","");
INSERT INTO tbl_expensesde VALUES("584","0","110","138","1600.00","");
INSERT INTO tbl_expensesde VALUES("585","0","110","103","900.00","ফ্যান");
INSERT INTO tbl_expensesde VALUES("586","0","110","90","50.00","");
INSERT INTO tbl_expensesde VALUES("587","0","110","94","300.00","ঝাড়ু. সুতলা ");
INSERT INTO tbl_expensesde VALUES("588","0","110","85","8430.00","");
INSERT INTO tbl_expensesde VALUES("589","0","110","103","70.00","মবিল");
INSERT INTO tbl_expensesde VALUES("590","0","110","170","955.00","");
INSERT INTO tbl_expensesde VALUES("591","0","111","86","12000.00","");
INSERT INTO tbl_expensesde VALUES("592","0","111","111","900.00","");
INSERT INTO tbl_expensesde VALUES("593","0","111","90","300.00","");
INSERT INTO tbl_expensesde VALUES("594","0","111","92","200.00","");
INSERT INTO tbl_expensesde VALUES("595","0","111","104","530.00","ফেম কালি ");
INSERT INTO tbl_expensesde VALUES("596","0","111","170","360.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("597","0","111","95","320.00","");
INSERT INTO tbl_expensesde VALUES("598","0","111","111","1760.00","");
INSERT INTO tbl_expensesde VALUES("599","0","111","99","1510.00","");
INSERT INTO tbl_expensesde VALUES("600","0","111","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("601","0","111","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("602","0","111","92","280.00","");
INSERT INTO tbl_expensesde VALUES("603","0","111","150","500.00","ভাড়া বস্তা আনার ");
INSERT INTO tbl_expensesde VALUES("604","0","112","92","300.00","");
INSERT INTO tbl_expensesde VALUES("605","0","112","95","40.00","");
INSERT INTO tbl_expensesde VALUES("606","0","112","111","2130.00","");
INSERT INTO tbl_expensesde VALUES("607","0","112","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("608","0","112","90","30.00","");
INSERT INTO tbl_expensesde VALUES("609","0","112","90","50.00","");
INSERT INTO tbl_expensesde VALUES("610","0","112","90","540.00","");
INSERT INTO tbl_expensesde VALUES("611","0","113","85","2950.00","tata");
INSERT INTO tbl_expensesde VALUES("612","0","113","170","320.00","");
INSERT INTO tbl_expensesde VALUES("613","0","113","157","40.00","");
INSERT INTO tbl_expensesde VALUES("614","0","114","170","150.00","");
INSERT INTO tbl_expensesde VALUES("615","0","114","104","100.00","");
INSERT INTO tbl_expensesde VALUES("616","0","114","170","400.00","");
INSERT INTO tbl_expensesde VALUES("617","0","114","87","3000.00","sagor");
INSERT INTO tbl_expensesde VALUES("618","0","114","15","350.00","");
INSERT INTO tbl_expensesde VALUES("619","0","114","86","4340.00","");
INSERT INTO tbl_expensesde VALUES("620","0","115","92","930.00","");
INSERT INTO tbl_expensesde VALUES("621","0","115","90","20.00","");
INSERT INTO tbl_expensesde VALUES("622","0","116","156","170.00","");
INSERT INTO tbl_expensesde VALUES("623","0","116","103","140.00","নাট, ভাড়া ");
INSERT INTO tbl_expensesde VALUES("624","0","116","90","20.00","");
INSERT INTO tbl_expensesde VALUES("625","0","116","103","120.00","দুলাল");
INSERT INTO tbl_expensesde VALUES("626","0","117","103","200.00","দুলাল ");
INSERT INTO tbl_expensesde VALUES("627","0","117","150","500.00","স্কেল মেরামত ");
INSERT INTO tbl_expensesde VALUES("628","0","117","90","200.00","");
INSERT INTO tbl_expensesde VALUES("629","0","117","92","190.00","");
INSERT INTO tbl_expensesde VALUES("630","0","117","92","270.00","");
INSERT INTO tbl_expensesde VALUES("631","0","117","87","300.00","আনোয়ার ");
INSERT INTO tbl_expensesde VALUES("632","0","117","99","2170.00","");
INSERT INTO tbl_expensesde VALUES("633","0","117","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("634","0","117","170","320.00","ডিম ");
INSERT INTO tbl_expensesde VALUES("635","0","117","86","3824.00","");
INSERT INTO tbl_expensesde VALUES("636","0","117","86","175.00","");
INSERT INTO tbl_expensesde VALUES("637","0","117","90","70.00","");
INSERT INTO tbl_expensesde VALUES("638","0","118","170","330.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("639","0","118","85","2886.00","");
INSERT INTO tbl_expensesde VALUES("640","0","118","150","50.00","গাম ");
INSERT INTO tbl_expensesde VALUES("641","0","118","90","14.00","");
INSERT INTO tbl_expensesde VALUES("642","0","118","170","310.00","ডিম ");
INSERT INTO tbl_expensesde VALUES("643","0","118","170","120.00","করলা ");
INSERT INTO tbl_expensesde VALUES("644","0","118","170","40.00","শকনা মরিচ ");
INSERT INTO tbl_expensesde VALUES("645","0","118","170","120.00","লবন ");
INSERT INTO tbl_expensesde VALUES("646","0","118","104","140.00","স্যালাইন ");
INSERT INTO tbl_expensesde VALUES("647","0","119","90","20.00","");
INSERT INTO tbl_expensesde VALUES("648","0","119","87","300.00","বাবুচি মরিয়ম ");
INSERT INTO tbl_expensesde VALUES("649","0","120","162","200.00","");
INSERT INTO tbl_expensesde VALUES("650","0","120","90","270.00","");
INSERT INTO tbl_expensesde VALUES("651","0","120","90","400.00","");
INSERT INTO tbl_expensesde VALUES("652","0","120","86","7420.00","");
INSERT INTO tbl_expensesde VALUES("653","0","120","170","170.00","কাচা মরিচ তরকারি ");
INSERT INTO tbl_expensesde VALUES("654","0","120","92","260.00","");
INSERT INTO tbl_expensesde VALUES("655","0","120","92","240.00","");
INSERT INTO tbl_expensesde VALUES("656","0","120","103","150.00","দুলাল ");
INSERT INTO tbl_expensesde VALUES("657","0","120","103","450.00","লিয়ার");
INSERT INTO tbl_expensesde VALUES("658","0","120","164","5800.00","");
INSERT INTO tbl_expensesde VALUES("659","0","120","111","4630.00","");
INSERT INTO tbl_expensesde VALUES("660","0","121","170","995.00","");
INSERT INTO tbl_expensesde VALUES("661","0","121","137","5310.00","ছেড়া নোট ");
INSERT INTO tbl_expensesde VALUES("662","0","121","111","4520.00","");
INSERT INTO tbl_expensesde VALUES("663","0","121","167","2950.00","");
INSERT INTO tbl_expensesde VALUES("664","0","121","85","10330.00","");
INSERT INTO tbl_expensesde VALUES("665","0","121","90","150.00","");
INSERT INTO tbl_expensesde VALUES("666","0","121","129","1100.00","রিয়ারিং ২ টা , নেট ওয়ালিং");
INSERT INTO tbl_expensesde VALUES("667","0","121","90","20.00","");
INSERT INTO tbl_expensesde VALUES("668","0","121","156","170.00","");
INSERT INTO tbl_expensesde VALUES("669","0","121","86","120.00","");
INSERT INTO tbl_expensesde VALUES("670","0","122","19","2750.00","");
INSERT INTO tbl_expensesde VALUES("671","0","122","160","200.00","");
INSERT INTO tbl_expensesde VALUES("672","0","122","158","200.00","");
INSERT INTO tbl_expensesde VALUES("673","0","123","170","380.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("674","0","123","150","3140.00","");
INSERT INTO tbl_expensesde VALUES("675","0","123","161","230.00","");
INSERT INTO tbl_expensesde VALUES("676","0","123","104","1000.00","বাটি , ৪ ফেম ");
INSERT INTO tbl_expensesde VALUES("677","0","124","86","3500.00","");
INSERT INTO tbl_expensesde VALUES("678","0","124","99","2425.00","");
INSERT INTO tbl_expensesde VALUES("679","0","124","92","300.00","");
INSERT INTO tbl_expensesde VALUES("680","0","124","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("681","0","124","111","1830.00","");
INSERT INTO tbl_expensesde VALUES("682","0","124","90","10.00","");
INSERT INTO tbl_expensesde VALUES("683","0","125","160","100.00","");
INSERT INTO tbl_expensesde VALUES("684","0","125","16","897942.00","");
INSERT INTO tbl_expensesde VALUES("685","0","125","164","18550.00","");
INSERT INTO tbl_expensesde VALUES("686","0","125","103","3450.00","uball,bush");
INSERT INTO tbl_expensesde VALUES("687","0","125","162","1720.00","");
INSERT INTO tbl_expensesde VALUES("688","0","125","158","20.00","");
INSERT INTO tbl_expensesde VALUES("689","0","125","171","10.00","");
INSERT INTO tbl_expensesde VALUES("690","0","125","170","240.00","");
INSERT INTO tbl_expensesde VALUES("691","0","125","19","85.00","");
INSERT INTO tbl_expensesde VALUES("692","0","125","95","160.00","");
INSERT INTO tbl_expensesde VALUES("693","0","125","158","50.00","");
INSERT INTO tbl_expensesde VALUES("694","0","125","85","7000.00","");
INSERT INTO tbl_expensesde VALUES("695","0","125","20","1800.00","");
INSERT INTO tbl_expensesde VALUES("696","0","125","170","480.00","");
INSERT INTO tbl_expensesde VALUES("697","0","125","19","200.00","jaru");
INSERT INTO tbl_expensesde VALUES("698","0","125","157","300.00","");
INSERT INTO tbl_expensesde VALUES("699","0","125","86","7470.00","");
INSERT INTO tbl_expensesde VALUES("700","0","126","149","3200.00","plain sheet");
INSERT INTO tbl_expensesde VALUES("701","0","126","158","100.00","");
INSERT INTO tbl_expensesde VALUES("702","0","127","87","6000.00","sahin");
INSERT INTO tbl_expensesde VALUES("703","0","128","144","1600.00","");
INSERT INTO tbl_expensesde VALUES("704","0","129","90","40.00","");
INSERT INTO tbl_expensesde VALUES("705","0","129","92","50.00","");
INSERT INTO tbl_expensesde VALUES("706","0","129","90","40.00","");
INSERT INTO tbl_expensesde VALUES("707","0","129","165","1100.00","");
INSERT INTO tbl_expensesde VALUES("708","0","129","170","1350.00","মুরগি মশলা ");
INSERT INTO tbl_expensesde VALUES("709","0","129","170","120.00","কাচামরিচ ");
INSERT INTO tbl_expensesde VALUES("710","0","129","170","320.00","");
INSERT INTO tbl_expensesde VALUES("711","0","129","170","120.00","কাচামরিচ ");
INSERT INTO tbl_expensesde VALUES("712","0","129","90","100.00","");
INSERT INTO tbl_expensesde VALUES("713","0","129","165","600.00","মবিল শাহিন ");
INSERT INTO tbl_expensesde VALUES("714","0","129","150","18000.00","ইলেক্টনিক মালামাল");
INSERT INTO tbl_expensesde VALUES("715","0","129","167","2250.00","");
INSERT INTO tbl_expensesde VALUES("716","0","129","150","17200.00","");
INSERT INTO tbl_expensesde VALUES("717","0","130","87","200.00","salauddin");
INSERT INTO tbl_expensesde VALUES("718","0","131","137","13536.00","");
INSERT INTO tbl_expensesde VALUES("719","0","132","170","480.00","");
INSERT INTO tbl_expensesde VALUES("720","0","132","103","5000.00","hasan pati mistri");
INSERT INTO tbl_expensesde VALUES("721","0","133","87","360.00","");
INSERT INTO tbl_expensesde VALUES("722","0","134","104","190.00","ডিটারজেন ");
INSERT INTO tbl_expensesde VALUES("723","0","134","104","1500.00","তোসক বালিশ ");
INSERT INTO tbl_expensesde VALUES("724","0","134","90","20.00","");
INSERT INTO tbl_expensesde VALUES("725","0","134","170","1000.00","সোয়াবিন তৈল ");
INSERT INTO tbl_expensesde VALUES("726","0","134","170","310.00","ডিম ");
INSERT INTO tbl_expensesde VALUES("727","0","134","103","300.00","ট্রান্সপোট , ভাড়া ");
INSERT INTO tbl_expensesde VALUES("728","0","134","150","5000.00","পিনিয়াম ");
INSERT INTO tbl_expensesde VALUES("729","0","134","92","100.00","");
INSERT INTO tbl_expensesde VALUES("730","0","134","87","13000.00","");
INSERT INTO tbl_expensesde VALUES("731","0","134","95","160.00","");
INSERT INTO tbl_expensesde VALUES("732","0","134","104","140.00","স্যালাইন");
INSERT INTO tbl_expensesde VALUES("733","0","134","90","20.00","");
INSERT INTO tbl_expensesde VALUES("734","0","134","150","110.00","ডিজিল ");
INSERT INTO tbl_expensesde VALUES("735","0","135","111","450.00","");
INSERT INTO tbl_expensesde VALUES("736","0","135","87","16000.00","");
INSERT INTO tbl_expensesde VALUES("737","0","135","90","20.00","");
INSERT INTO tbl_expensesde VALUES("738","0","135","138","600.00","");
INSERT INTO tbl_expensesde VALUES("739","0","135","111","1960.00","");
INSERT INTO tbl_expensesde VALUES("740","0","135","150","230.00","ডিস বিল");
INSERT INTO tbl_expensesde VALUES("741","0","135","103","310.00","পাইপ , দুলাল মিস্তী ");
INSERT INTO tbl_expensesde VALUES("742","0","135","85","4000.00","");
INSERT INTO tbl_expensesde VALUES("743","0","135","92","160.00","");
INSERT INTO tbl_expensesde VALUES("744","0","136","87","6500.00","KAMAL");
INSERT INTO tbl_expensesde VALUES("745","0","136","87","4500.00","SAHADAT");
INSERT INTO tbl_expensesde VALUES("746","0","136","158","270.00","");
INSERT INTO tbl_expensesde VALUES("747","0","136","156","170.00","");
INSERT INTO tbl_expensesde VALUES("748","0","137","86","7370.00","");
INSERT INTO tbl_expensesde VALUES("749","0","137","92","260.00","");
INSERT INTO tbl_expensesde VALUES("750","0","138","87","500.00","জিন্নাত");
INSERT INTO tbl_expensesde VALUES("751","0","139","90","200.00","");
INSERT INTO tbl_expensesde VALUES("752","0","139","90","20.00","");
INSERT INTO tbl_expensesde VALUES("753","0","139","87","3000.00","");
INSERT INTO tbl_expensesde VALUES("754","0","139","90","30.00","");
INSERT INTO tbl_expensesde VALUES("755","0","139","111","3900.00","");
INSERT INTO tbl_expensesde VALUES("756","0","139","91","300.00","");
INSERT INTO tbl_expensesde VALUES("757","0","139","87","200.00","");
INSERT INTO tbl_expensesde VALUES("758","0","139","170","660.00","মুরগির পোলাও চাল ");
INSERT INTO tbl_expensesde VALUES("759","0","139","170","410.00","জিরা , দুধ মসল ডিম ");
INSERT INTO tbl_expensesde VALUES("760","0","139","170","60.00","");
INSERT INTO tbl_expensesde VALUES("761","0","139","85","12500.00","");
INSERT INTO tbl_expensesde VALUES("762","0","140","90","40.00","");
INSERT INTO tbl_expensesde VALUES("763","0","140","90","20.00","");
INSERT INTO tbl_expensesde VALUES("764","0","140","170","415.00","খোরাকি ");
INSERT INTO tbl_expensesde VALUES("765","0","140","90","20.00","");
INSERT INTO tbl_expensesde VALUES("766","0","140","86","2325.00","");
INSERT INTO tbl_expensesde VALUES("767","0","140","170","350.00","তরকারি ");
INSERT INTO tbl_expensesde VALUES("768","0","141","90","90.00","");
INSERT INTO tbl_expensesde VALUES("769","0","141","105","200.00","");
INSERT INTO tbl_expensesde VALUES("770","0","141","170","700.00","");
INSERT INTO tbl_expensesde VALUES("771","0","141","90","20.00","");
INSERT INTO tbl_expensesde VALUES("772","0","141","111","2300.00","কালাচান ");
INSERT INTO tbl_expensesde VALUES("773","0","141","91","800.00","");
INSERT INTO tbl_expensesde VALUES("774","0","141","104","180.00","কলা কেক ");
INSERT INTO tbl_expensesde VALUES("775","0","142","167","1100.00","");
INSERT INTO tbl_expensesde VALUES("776","0","142","156","170.00","");
INSERT INTO tbl_expensesde VALUES("777","0","142","149","140.00","");
INSERT INTO tbl_expensesde VALUES("778","0","142","85","3700.00","tauras");
INSERT INTO tbl_expensesde VALUES("779","0","142","87","450.00","salauddin");
INSERT INTO tbl_expensesde VALUES("780","0","142","87","100.00","monir");
INSERT INTO tbl_expensesde VALUES("781","0","142","157","50.00","");
INSERT INTO tbl_expensesde VALUES("782","0","142","91","240.00","");
INSERT INTO tbl_expensesde VALUES("783","0","142","87","100.00","rakib");
INSERT INTO tbl_expensesde VALUES("784","0","142","157","260.00","");
INSERT INTO tbl_expensesde VALUES("785","0","143","90","110.00","");
INSERT INTO tbl_expensesde VALUES("786","0","143","87","500.00","");
INSERT INTO tbl_expensesde VALUES("787","0","143","170","200.00","লাকরি ");
INSERT INTO tbl_expensesde VALUES("788","0","143","87","200.00","");
INSERT INTO tbl_expensesde VALUES("789","0","143","170","250.00","");
INSERT INTO tbl_expensesde VALUES("790","0","143","90","230.00","");
INSERT INTO tbl_expensesde VALUES("791","0","143","103","3900.00","মবিল ফিল্টার ");
INSERT INTO tbl_expensesde VALUES("792","0","143","156","200.00","");
INSERT INTO tbl_expensesde VALUES("793","0","143","92","180.00","");
INSERT INTO tbl_expensesde VALUES("794","0","143","150","6060.00","ওয়ালিং রড় ");
INSERT INTO tbl_expensesde VALUES("795","0","143","90","20.00","");
INSERT INTO tbl_expensesde VALUES("796","0","144","87","163695.00","");
INSERT INTO tbl_expensesde VALUES("797","0","145","87","200.00","");
INSERT INTO tbl_expensesde VALUES("798","0","145","86","5990.00","04-05-24");
INSERT INTO tbl_expensesde VALUES("799","0","145","86","7230.00","");
INSERT INTO tbl_expensesde VALUES("800","0","145","157","270.00","");
INSERT INTO tbl_expensesde VALUES("801","0","145","27","20.00","");
INSERT INTO tbl_expensesde VALUES("802","0","145","103","80.00","");
INSERT INTO tbl_expensesde VALUES("803","0","146","158","40.00","");
INSERT INTO tbl_expensesde VALUES("804","0","146","158","200.00","sajib");
INSERT INTO tbl_expensesde VALUES("805","0","146","19","225.00","saban,cokel");
INSERT INTO tbl_expensesde VALUES("806","0","146","157","70.00","");
INSERT INTO tbl_expensesde VALUES("807","0","146","144","10000.00","OCLSD");
INSERT INTO tbl_expensesde VALUES("808","0","146","173","15000.00","MILL,DELAR");
INSERT INTO tbl_expensesde VALUES("809","0","146","157","60.00","");
INSERT INTO tbl_expensesde VALUES("810","0","146","170","320.00","");
INSERT INTO tbl_expensesde VALUES("811","0","146","170","500.00","ALU");
INSERT INTO tbl_expensesde VALUES("812","0","146","170","940.00","SOABIN OIL");
INSERT INTO tbl_expensesde VALUES("813","0","146","170","90.00","");
INSERT INTO tbl_expensesde VALUES("814","0","146","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("815","0","146","170","6370.00","ALU,PIAZ");
INSERT INTO tbl_expensesde VALUES("816","0","146","160","120.00","");
INSERT INTO tbl_expensesde VALUES("817","0","146","170","400.00","");
INSERT INTO tbl_expensesde VALUES("818","0","147","103","1750.00","RING,NUT");
INSERT INTO tbl_expensesde VALUES("819","0","147","21","1500.00","");
INSERT INTO tbl_expensesde VALUES("820","0","147","158","20.00","");
INSERT INTO tbl_expensesde VALUES("821","0","147","170","200.00","");
INSERT INTO tbl_expensesde VALUES("822","0","147","158","50.00","WAHID");
INSERT INTO tbl_expensesde VALUES("823","0","147","86","4140.00","");
INSERT INTO tbl_expensesde VALUES("824","0","147","91","1000.00","ISMILE");
INSERT INTO tbl_expensesde VALUES("825","0","148","158","20.00","");
INSERT INTO tbl_expensesde VALUES("826","0","148","157","100.00","");
INSERT INTO tbl_expensesde VALUES("827","0","148","86","100.00","");
INSERT INTO tbl_expensesde VALUES("828","0","148","27","10.00","");
INSERT INTO tbl_expensesde VALUES("829","0","149","171","20.00","");
INSERT INTO tbl_expensesde VALUES("830","0","149","158","20.00","");
INSERT INTO tbl_expensesde VALUES("831","0","149","170","400.00","");
INSERT INTO tbl_expensesde VALUES("832","0","149","170","350.00","");
INSERT INTO tbl_expensesde VALUES("833","0","149","111","2100.00","");
INSERT INTO tbl_expensesde VALUES("834","0","149","19","1520.00","");
INSERT INTO tbl_expensesde VALUES("835","0","149","158","80.00","");
INSERT INTO tbl_expensesde VALUES("836","0","149","157","240.00","");
INSERT INTO tbl_expensesde VALUES("837","0","150","170","350.00","");
INSERT INTO tbl_expensesde VALUES("838","0","151","90","150.00","");
INSERT INTO tbl_expensesde VALUES("839","0","151","90","280.00","");
INSERT INTO tbl_expensesde VALUES("840","0","151","92","390.00","");
INSERT INTO tbl_expensesde VALUES("841","0","151","86","5750.00","");
INSERT INTO tbl_expensesde VALUES("842","0","151","138","5800.00","");
INSERT INTO tbl_expensesde VALUES("843","0","151","170","200.00","");
INSERT INTO tbl_expensesde VALUES("844","0","151","103","1800.00","পুশ রড় ");
INSERT INTO tbl_expensesde VALUES("845","0","151","103","1000.00","এনামুল মিস্তী ");
INSERT INTO tbl_expensesde VALUES("846","0","151","103","120.00","মিস্তী ");
INSERT INTO tbl_expensesde VALUES("847","0","151","87","1210.00","ইসমাইল ");
INSERT INTO tbl_expensesde VALUES("848","0","152","158","40.00","");
INSERT INTO tbl_expensesde VALUES("849","0","152","149","26000.00","");
INSERT INTO tbl_expensesde VALUES("850","0","152","158","200.00","");
INSERT INTO tbl_expensesde VALUES("851","0","152","144","4200.00","");
INSERT INTO tbl_expensesde VALUES("852","0","152","158","10.00","");
INSERT INTO tbl_expensesde VALUES("853","0","152","149","540.00","");
INSERT INTO tbl_expensesde VALUES("854","0","152","165","100.00","");
INSERT INTO tbl_expensesde VALUES("855","0","152","158","30.00","");
INSERT INTO tbl_expensesde VALUES("856","0","152","158","20.00","");
INSERT INTO tbl_expensesde VALUES("857","0","152","170","1200.00","MURGI,MASLA");
INSERT INTO tbl_expensesde VALUES("858","0","152","170","410.00","TORKARI");
INSERT INTO tbl_expensesde VALUES("859","0","153","170","200.00","");
INSERT INTO tbl_expensesde VALUES("860","0","153","157","20.00","");
INSERT INTO tbl_expensesde VALUES("861","0","153","157","270.00","");
INSERT INTO tbl_expensesde VALUES("862","0","153","158","20.00","");
INSERT INTO tbl_expensesde VALUES("863","0","153","86","3289.00","");
INSERT INTO tbl_expensesde VALUES("864","0","154","158","20.00","");
INSERT INTO tbl_expensesde VALUES("865","0","154","144","4200.00","");
INSERT INTO tbl_expensesde VALUES("866","0","154","85","5000.00","709");
INSERT INTO tbl_expensesde VALUES("867","0","154","149","290.00","");
INSERT INTO tbl_expensesde VALUES("868","0","154","170","890.00","soabin");
INSERT INTO tbl_expensesde VALUES("869","0","154","170","240.00","mugdal");
INSERT INTO tbl_expensesde VALUES("870","0","154","170","340.00","egg");
INSERT INTO tbl_expensesde VALUES("871","0","154","170","280.00","rosun");
INSERT INTO tbl_expensesde VALUES("872","0","154","170","160.00","holud,morich gura");
INSERT INTO tbl_expensesde VALUES("873","0","154","15","500.00","riyad");
INSERT INTO tbl_expensesde VALUES("874","0","154","158","1080.00","");
INSERT INTO tbl_expensesde VALUES("875","0","154","171","10.00","");
INSERT INTO tbl_expensesde VALUES("876","0","154","21","1000.00","ariyan");
INSERT INTO tbl_expensesde VALUES("877","0","155","87","1000.00","SOHRAB");
INSERT INTO tbl_expensesde VALUES("878","0","155","95","160.00","");
INSERT INTO tbl_expensesde VALUES("879","0","155","87","1310.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("880","0","155","87","9000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("881","0","155","87","500.00","JINNAT");
INSERT INTO tbl_expensesde VALUES("882","0","155","158","50.00","NASTA");
INSERT INTO tbl_expensesde VALUES("883","0","155","103","1700.00","PATI MISTRI");
INSERT INTO tbl_expensesde VALUES("884","0","155","87","2000.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("885","0","155","157","40.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("886","0","155","87","8000.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("887","0","155","156","170.00","709");
INSERT INTO tbl_expensesde VALUES("888","0","156","103","1800.00","SAMIM");
INSERT INTO tbl_expensesde VALUES("889","0","156","157","230.00","");
INSERT INTO tbl_expensesde VALUES("890","0","157","167","1050.00","");
INSERT INTO tbl_expensesde VALUES("891","0","157","158","20.00","");
INSERT INTO tbl_expensesde VALUES("892","0","157","86","5200.00","");
INSERT INTO tbl_expensesde VALUES("893","0","157","86","6000.00","anis sarder");
INSERT INTO tbl_expensesde VALUES("894","0","157","87","500.00","kamal");
INSERT INTO tbl_expensesde VALUES("895","0","157","171","10.00","");
INSERT INTO tbl_expensesde VALUES("896","0","158","156","200.00","");
INSERT INTO tbl_expensesde VALUES("897","0","158","170","450.00","");
INSERT INTO tbl_expensesde VALUES("898","0","158","170","80.00","");
INSERT INTO tbl_expensesde VALUES("899","0","158","170","50.00","");
INSERT INTO tbl_expensesde VALUES("900","0","158","170","20.00","");
INSERT INTO tbl_expensesde VALUES("901","0","158","149","15.00","TERKATA");
INSERT INTO tbl_expensesde VALUES("902","0","159","158","20.00","");
INSERT INTO tbl_expensesde VALUES("903","0","159","158","50.00","asik");
INSERT INTO tbl_expensesde VALUES("904","0","159","170","350.00","");
INSERT INTO tbl_expensesde VALUES("905","0","159","158","20.00","");
INSERT INTO tbl_expensesde VALUES("906","0","160","156","150.00","");
INSERT INTO tbl_expensesde VALUES("907","0","160","90","40.00","");
INSERT INTO tbl_expensesde VALUES("908","0","160","170","450.00","ডিম + শাক ");
INSERT INTO tbl_expensesde VALUES("909","0","160","156","150.00","");
INSERT INTO tbl_expensesde VALUES("910","0","160","111","200.00","");
INSERT INTO tbl_expensesde VALUES("911","0","160","21","800.00","");
INSERT INTO tbl_expensesde VALUES("912","0","161","157","40.00","YOUSUF");
INSERT INTO tbl_expensesde VALUES("913","0","161","171","20.00","");
INSERT INTO tbl_expensesde VALUES("914","0","161","170","100.00","");
INSERT INTO tbl_expensesde VALUES("915","0","161","158","50.00","");
INSERT INTO tbl_expensesde VALUES("916","0","162","170","350.00","");
INSERT INTO tbl_expensesde VALUES("917","0","162","157","50.00","");
INSERT INTO tbl_expensesde VALUES("918","0","163","86","300.00","");
INSERT INTO tbl_expensesde VALUES("919","0","163","158","20.00","");
INSERT INTO tbl_expensesde VALUES("920","0","163","86","160.00","");
INSERT INTO tbl_expensesde VALUES("921","0","164","171","30.00","");
INSERT INTO tbl_expensesde VALUES("922","0","164","170","200.00","");
INSERT INTO tbl_expensesde VALUES("923","0","164","170","640.00","");
INSERT INTO tbl_expensesde VALUES("924","0","164","170","400.00","");
INSERT INTO tbl_expensesde VALUES("925","0","164","170","250.00","");
INSERT INTO tbl_expensesde VALUES("926","0","164","170","200.00","");
INSERT INTO tbl_expensesde VALUES("927","0","164","111","650.00","taoras");
INSERT INTO tbl_expensesde VALUES("928","0","164","157","40.00","");
INSERT INTO tbl_expensesde VALUES("929","0","165","158","20.00","");
INSERT INTO tbl_expensesde VALUES("930","0","165","27","120.00","");
INSERT INTO tbl_expensesde VALUES("931","0","166","13","345.00","");
INSERT INTO tbl_expensesde VALUES("932","0","166","20","1200.00","");
INSERT INTO tbl_expensesde VALUES("933","0","166","27","400.00","");
INSERT INTO tbl_expensesde VALUES("934","0","166","158","50.00","");
INSERT INTO tbl_expensesde VALUES("935","0","166","158","20.00","");
INSERT INTO tbl_expensesde VALUES("936","0","166","162","1410.00","");
INSERT INTO tbl_expensesde VALUES("937","0","166","170","80.00","");
INSERT INTO tbl_expensesde VALUES("938","0","166","171","10.00","");
INSERT INTO tbl_expensesde VALUES("939","0","166","160","300.00","");
INSERT INTO tbl_expensesde VALUES("940","0","166","170","320.00","");
INSERT INTO tbl_expensesde VALUES("941","0","166","86","6360.00","");
INSERT INTO tbl_expensesde VALUES("942","0","167","111","450.00","");
INSERT INTO tbl_expensesde VALUES("943","0","167","170","200.00","");
INSERT INTO tbl_expensesde VALUES("944","0","167","157","300.00","");
INSERT INTO tbl_expensesde VALUES("945","0","167","15","410.00","");
INSERT INTO tbl_expensesde VALUES("946","0","167","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("947","0","167","170","100.00","");
INSERT INTO tbl_expensesde VALUES("948","0","167","158","40.00","");
INSERT INTO tbl_expensesde VALUES("949","0","167","171","10.00","");
INSERT INTO tbl_expensesde VALUES("950","0","167","170","910.00","SAABIN OIL");
INSERT INTO tbl_expensesde VALUES("951","0","167","170","380.00","EGG");
INSERT INTO tbl_expensesde VALUES("952","0","167","170","15.00","");
INSERT INTO tbl_expensesde VALUES("953","0","167","20","880.00","A4 PAPER");
INSERT INTO tbl_expensesde VALUES("954","0","168","85","9740.00","");
INSERT INTO tbl_expensesde VALUES("955","0","168","160","200.00","");
INSERT INTO tbl_expensesde VALUES("956","0","168","156","150.00","MONIR");
INSERT INTO tbl_expensesde VALUES("957","0","169","171","10.00","");
INSERT INTO tbl_expensesde VALUES("958","0","170","111","250.00","");
INSERT INTO tbl_expensesde VALUES("959","0","170","158","20.00","");
INSERT INTO tbl_expensesde VALUES("960","0","170","172","530.00","");
INSERT INTO tbl_expensesde VALUES("961","0","170","87","500.00","SAGOR");
INSERT INTO tbl_expensesde VALUES("962","0","170","86","9420.00","");
INSERT INTO tbl_expensesde VALUES("963","0","170","157","300.00","");
INSERT INTO tbl_expensesde VALUES("964","0","170","86","300.00","");
INSERT INTO tbl_expensesde VALUES("965","0","170","157","240.00","SUMON");
INSERT INTO tbl_expensesde VALUES("966","0","170","103","9740.00","OIL TAORAS");
INSERT INTO tbl_expensesde VALUES("967","0","170","27","50.00","");
INSERT INTO tbl_expensesde VALUES("968","0","171","111","750.00","");
INSERT INTO tbl_expensesde VALUES("969","0","171","165","100.00","");
INSERT INTO tbl_expensesde VALUES("970","0","171","92","200.00","");
INSERT INTO tbl_expensesde VALUES("971","0","171","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("972","0","171","86","300.00","");
INSERT INTO tbl_expensesde VALUES("973","0","171","90","80.00","");
INSERT INTO tbl_expensesde VALUES("974","0","171","109","225.00","মুগ ডাল");
INSERT INTO tbl_expensesde VALUES("975","0","171","109","150.00","কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("976","0","172","109","2900.00","আলু");
INSERT INTO tbl_expensesde VALUES("977","0","173","85","10000.00","টাটা");
INSERT INTO tbl_expensesde VALUES("978","0","173","90","200.00","সজিব");
INSERT INTO tbl_expensesde VALUES("979","0","173","92","200.00","");
INSERT INTO tbl_expensesde VALUES("980","0","173","111","2510.00","");
INSERT INTO tbl_expensesde VALUES("981","0","174","171","10.00","");
INSERT INTO tbl_expensesde VALUES("982","0","175","27","50.00","asik");
INSERT INTO tbl_expensesde VALUES("983","0","175","170","450.00","");
INSERT INTO tbl_expensesde VALUES("984","0","175","157","300.00","");
INSERT INTO tbl_expensesde VALUES("985","0","175","91","380.00","");
INSERT INTO tbl_expensesde VALUES("986","0","175","95","160.00","");
INSERT INTO tbl_expensesde VALUES("987","0","175","160","40.00","");
INSERT INTO tbl_expensesde VALUES("988","0","175","27","150.00","");
INSERT INTO tbl_expensesde VALUES("989","0","176","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("990","0","176","170","200.00","");
INSERT INTO tbl_expensesde VALUES("991","0","176","87","1500.00","RIPON");
INSERT INTO tbl_expensesde VALUES("992","0","176","170","300.00","TORKARI");
INSERT INTO tbl_expensesde VALUES("993","0","176","149","400.00","");
INSERT INTO tbl_expensesde VALUES("994","0","176","158","600.00","");
INSERT INTO tbl_expensesde VALUES("995","0","176","158","20.00","");
INSERT INTO tbl_expensesde VALUES("996","0","176","170","1900.00","");
INSERT INTO tbl_expensesde VALUES("997","0","176","165","450.00","TUBE LESS");
INSERT INTO tbl_expensesde VALUES("998","0","176","177","30.00","");
INSERT INTO tbl_expensesde VALUES("999","0","176","27","40.00","");
INSERT INTO tbl_expensesde VALUES("1000","0","176","158","30.00","");
INSERT INTO tbl_expensesde VALUES("1001","0","176","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1002","0","177","85","1950.00","monir");
INSERT INTO tbl_expensesde VALUES("1003","0","177","103","220.00","");
INSERT INTO tbl_expensesde VALUES("1004","0","177","87","200.00","rakib");
INSERT INTO tbl_expensesde VALUES("1005","0","178","158","200.00","");
INSERT INTO tbl_expensesde VALUES("1006","0","178","170","415.00","alek");
INSERT INTO tbl_expensesde VALUES("1007","0","178","87","200.00","salauddin");
INSERT INTO tbl_expensesde VALUES("1008","0","178","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1009","0","178","27","700.00","");
INSERT INTO tbl_expensesde VALUES("1010","0","179","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1011","0","179","86","4130.00","");
INSERT INTO tbl_expensesde VALUES("1012","0","180","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1013","0","180","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1014","0","180","103","300.00","griz");
INSERT INTO tbl_expensesde VALUES("1015","0","180","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1016","0","180","170","1380.00","");
INSERT INTO tbl_expensesde VALUES("1017","0","180","87","1500.00","asik");
INSERT INTO tbl_expensesde VALUES("1018","0","180","170","180.00","tarkari");
INSERT INTO tbl_expensesde VALUES("1019","0","180","158","170.00","oms 9*30");
INSERT INTO tbl_expensesde VALUES("1020","0","181","158","100.00","oms");
INSERT INTO tbl_expensesde VALUES("1021","0","182","20","200.00","CURI,BATAARY PANI");
INSERT INTO tbl_expensesde VALUES("1022","0","182","13","60.00","");
INSERT INTO tbl_expensesde VALUES("1023","0","182","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("1024","0","182","87","3000.00","RIYAD");
INSERT INTO tbl_expensesde VALUES("1025","0","182","157","200.00","");
INSERT INTO tbl_expensesde VALUES("1026","0","183","87","9000.00","sohrab");
INSERT INTO tbl_expensesde VALUES("1027","0","183","157","40.00","");
INSERT INTO tbl_expensesde VALUES("1028","0","183","111","100.00","709");
INSERT INTO tbl_expensesde VALUES("1029","0","183","15","799.00","");
INSERT INTO tbl_expensesde VALUES("1030","0","183","15","348.00","sajib");
INSERT INTO tbl_expensesde VALUES("1031","0","183","15","169.00","");
INSERT INTO tbl_expensesde VALUES("1032","0","183","157","260.00","");
INSERT INTO tbl_expensesde VALUES("1033","0","183","86","5775.00","");
INSERT INTO tbl_expensesde VALUES("1034","0","183","86","300.00","");
INSERT INTO tbl_expensesde VALUES("1035","0","183","27","50.00","");
INSERT INTO tbl_expensesde VALUES("1036","0","183","158","270.00","");
INSERT INTO tbl_expensesde VALUES("1037","0","184","125","360.00","হাজিরা 1 জন");
INSERT INTO tbl_expensesde VALUES("1038","0","184","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1039","0","184","87","500.00","রিয়াদ");
INSERT INTO tbl_expensesde VALUES("1040","0","184","158","100.00","আাসিক");
INSERT INTO tbl_expensesde VALUES("1041","0","184","157","250.00","রাইস মিল রং মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("1042","0","184","149","400.00","বাল্ব");
INSERT INTO tbl_expensesde VALUES("1043","0","184","158","200.00","সজিব");
INSERT INTO tbl_expensesde VALUES("1044","0","185","85","5660.00","");
INSERT INTO tbl_expensesde VALUES("1045","0","185","170","150.00","");
INSERT INTO tbl_expensesde VALUES("1046","0","185","86","300.00","salauddin,sohel");
INSERT INTO tbl_expensesde VALUES("1047","0","185","170","570.00","murgi,egg");
INSERT INTO tbl_expensesde VALUES("1048","0","185","20","40.00","");
INSERT INTO tbl_expensesde VALUES("1049","0","186","89","10400.00","Ajij sir k ");
INSERT INTO tbl_expensesde VALUES("1050","0","186","86","4840.00","");
INSERT INTO tbl_expensesde VALUES("1051","0","186","157","200.00","সজিব");
INSERT INTO tbl_expensesde VALUES("1052","0","187","167","800.00","");
INSERT INTO tbl_expensesde VALUES("1053","0","188","167","800.00","");
INSERT INTO tbl_expensesde VALUES("1054","0","189","170","375.00","1");
INSERT INTO tbl_expensesde VALUES("1055","0","190","170","100.00","");
INSERT INTO tbl_expensesde VALUES("1056","0","190","170","760.00","EGG");
INSERT INTO tbl_expensesde VALUES("1057","0","190","103","42600.00","2 TI CHAKKA");
INSERT INTO tbl_expensesde VALUES("1058","0","190","111","200.00","");
INSERT INTO tbl_expensesde VALUES("1059","0","191","104","98.00","মোবাইল রিচার্জ রিয়াদ ");
INSERT INTO tbl_expensesde VALUES("1060","0","191","85","1550.00","");
INSERT INTO tbl_expensesde VALUES("1061","0","191","104","8000.00","ক্যামেরা বাবদ");
INSERT INTO tbl_expensesde VALUES("1062","0","191","162","1000.00","");
INSERT INTO tbl_expensesde VALUES("1063","0","192","171","50.00","");
INSERT INTO tbl_expensesde VALUES("1064","0","192","157","110.00","");
INSERT INTO tbl_expensesde VALUES("1065","0","192","86","9445.00","");
INSERT INTO tbl_expensesde VALUES("1066","0","192","87","2000.00","sajib");
INSERT INTO tbl_expensesde VALUES("1067","0","192","170","400.00","");
INSERT INTO tbl_expensesde VALUES("1068","0","192","86","200.00","");
INSERT INTO tbl_expensesde VALUES("1069","0","192","157","230.00","");
INSERT INTO tbl_expensesde VALUES("1070","0","193","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("1071","0","193","158","50.00","");
INSERT INTO tbl_expensesde VALUES("1072","0","194","157","140.00","ভাড়া+নাস্তা");
INSERT INTO tbl_expensesde VALUES("1073","0","194","170","110.00","শাক");
INSERT INTO tbl_expensesde VALUES("1074","0","194","157","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1075","0","194","111","5375.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("1076","0","194","91","1000.00","");
INSERT INTO tbl_expensesde VALUES("1077","0","194","160","600.00","");
INSERT INTO tbl_expensesde VALUES("1078","0","195","111","20.00","");
INSERT INTO tbl_expensesde VALUES("1079","0","196","164","18100.00","");
INSERT INTO tbl_expensesde VALUES("1080","0","196","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1081","0","197","170","120.00","শাক");
INSERT INTO tbl_expensesde VALUES("1082","0","197","111","600.00","");
INSERT INTO tbl_expensesde VALUES("1083","0","197","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1084","0","197","91","1000.00","মনির");
INSERT INTO tbl_expensesde VALUES("1085","0","197","82","3200.00","");
INSERT INTO tbl_expensesde VALUES("1086","0","197","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1087","0","197","157","310.00","");
INSERT INTO tbl_expensesde VALUES("1088","0","197","90","400.00","চিকন্দি ভ্যান ভাড়া");
INSERT INTO tbl_expensesde VALUES("1089","0","197","103","1500.00","ট্রাকের রশি");
INSERT INTO tbl_expensesde VALUES("1090","0","197","86","10130.00","");
INSERT INTO tbl_expensesde VALUES("1091","0","198","156","170.00","709");
INSERT INTO tbl_expensesde VALUES("1092","0","198","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1093","0","198","85","8820.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("1094","0","198","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("1095","0","198","111","450.00","");
INSERT INTO tbl_expensesde VALUES("1096","0","198","109","470.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1097","0","199","89","30000.00","ডিসি ফুুুুুুুুুুড স্যারকে");
INSERT INTO tbl_expensesde VALUES("1098","0","199","89","1200.00","");
INSERT INTO tbl_expensesde VALUES("1099","0","200","109","985.00","সোয়াবিন তেল");
INSERT INTO tbl_expensesde VALUES("1100","0","200","109","200.00","জিরা");
INSERT INTO tbl_expensesde VALUES("1101","0","200","85","5010.00","মনির ");
INSERT INTO tbl_expensesde VALUES("1102","0","200","145","15000.00","নিজ");
INSERT INTO tbl_expensesde VALUES("1103","0","200","158","300.00","");
INSERT INTO tbl_expensesde VALUES("1104","0","201","90","50.00","");
INSERT INTO tbl_expensesde VALUES("1105","0","201","137","100.00","ব্যাটারির পানি");
INSERT INTO tbl_expensesde VALUES("1106","0","202","87","10200.00","কালাচান");
INSERT INTO tbl_expensesde VALUES("1107","0","202","116","1800.00","");
INSERT INTO tbl_expensesde VALUES("1108","0","203","87","167255.00","");
INSERT INTO tbl_expensesde VALUES("1109","0","204","91","705.00","");
INSERT INTO tbl_expensesde VALUES("1110","0","205","96","40.00","রাজিব");
INSERT INTO tbl_expensesde VALUES("1111","0","205","87","2000.00","রিয়াদ");
INSERT INTO tbl_expensesde VALUES("1112","0","205","92","230.00","");
INSERT INTO tbl_expensesde VALUES("1113","0","205","86","5300.00","");
INSERT INTO tbl_expensesde VALUES("1114","0","205","125","20.00","");
INSERT INTO tbl_expensesde VALUES("1115","0","205","92","100.00","");
INSERT INTO tbl_expensesde VALUES("1116","0","205","157","60.00","রাজমিস্ত্রি ");
INSERT INTO tbl_expensesde VALUES("1117","0","206","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1118","0","206","170","320.00","তরকারী");
INSERT INTO tbl_expensesde VALUES("1119","0","206","90","40.00","রাজমিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("1120","0","206","87","300.00","রায়হান");
INSERT INTO tbl_expensesde VALUES("1121","0","206","111","5430.00","");
INSERT INTO tbl_expensesde VALUES("1122","0","206","92","220.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1123","0","206","160","200.00","");
INSERT INTO tbl_expensesde VALUES("1124","0","206","92","300.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1125","0","207","171","30.00","");
INSERT INTO tbl_expensesde VALUES("1126","0","207","87","14000.00","sumon");
INSERT INTO tbl_expensesde VALUES("1127","0","207","91","320.00","");
INSERT INTO tbl_expensesde VALUES("1128","0","207","85","9960.00","tata");
INSERT INTO tbl_expensesde VALUES("1129","0","207","170","4600.00","");
INSERT INTO tbl_expensesde VALUES("1130","0","207","158","100.00","");
INSERT INTO tbl_expensesde VALUES("1131","0","207","103","1700.00","");
INSERT INTO tbl_expensesde VALUES("1132","0","207","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1133","0","207","157","230.00","");
INSERT INTO tbl_expensesde VALUES("1134","0","207","27","30000.00","rason store");
INSERT INTO tbl_expensesde VALUES("1135","0","207","86","4805.00","");
INSERT INTO tbl_expensesde VALUES("1136","0","207","170","380.00","");
INSERT INTO tbl_expensesde VALUES("1137","0","207","15","100.00","");
INSERT INTO tbl_expensesde VALUES("1138","0","207","87","2000.00","shahin");
INSERT INTO tbl_expensesde VALUES("1139","0","207","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1140","0","207","149","200.00","");
INSERT INTO tbl_expensesde VALUES("1141","0","207","167","600.00","");
INSERT INTO tbl_expensesde VALUES("1142","0","207","170","350.00","");
INSERT INTO tbl_expensesde VALUES("1143","0","207","86","300.00","");
INSERT INTO tbl_expensesde VALUES("1144","0","207","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1145","0","208","86","60.00","");
INSERT INTO tbl_expensesde VALUES("1146","0","208","87","500.00","");
INSERT INTO tbl_expensesde VALUES("1147","0","208","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1148","0","208","111","5500.00","");
INSERT INTO tbl_expensesde VALUES("1149","0","208","87","500.00","");
INSERT INTO tbl_expensesde VALUES("1150","0","208","109","1115.00","");
INSERT INTO tbl_expensesde VALUES("1151","0","208","20","90.00","ডিটারজেন্ট");
INSERT INTO tbl_expensesde VALUES("1152","0","208","20","55.00","সাবান");
INSERT INTO tbl_expensesde VALUES("1153","0","208","109","70.00","মসল্লা");
INSERT INTO tbl_expensesde VALUES("1154","0","208","20","100.00","টিস্যু");
INSERT INTO tbl_expensesde VALUES("1155","0","208","20","100.00","হারপিক");
INSERT INTO tbl_expensesde VALUES("1156","0","208","20","80.00","");
INSERT INTO tbl_expensesde VALUES("1157","0","208","162","1260.00","");
INSERT INTO tbl_expensesde VALUES("1158","0","208","158","30.00","");
INSERT INTO tbl_expensesde VALUES("1159","0","208","155","140.00","");
INSERT INTO tbl_expensesde VALUES("1160","0","209","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1161","0","209","158","60.00","rased");
INSERT INTO tbl_expensesde VALUES("1162","0","209","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1163","0","209","87","4500.00","RASED");
INSERT INTO tbl_expensesde VALUES("1164","0","209","103","500.00","DULAL,RABER KUSUM");
INSERT INTO tbl_expensesde VALUES("1165","0","209","111","1350.00","");
INSERT INTO tbl_expensesde VALUES("1166","0","209","85","2720.00","");
INSERT INTO tbl_expensesde VALUES("1167","0","209","103","3400.00","DYNAMA");
INSERT INTO tbl_expensesde VALUES("1168","0","209","111","950.00","ISMILE");
INSERT INTO tbl_expensesde VALUES("1169","0","210","103","350.00","কুসুম");
INSERT INTO tbl_expensesde VALUES("1170","0","210","103","150.00","দুলাল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("1171","0","210","86","8550.00","");
INSERT INTO tbl_expensesde VALUES("1172","0","210","86","140.00","");
INSERT INTO tbl_expensesde VALUES("1173","0","210","109","240.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1174","0","211","173","4400.00","");
INSERT INTO tbl_expensesde VALUES("1175","0","211","111","600.00","709");
INSERT INTO tbl_expensesde VALUES("1176","0","211","109","640.00","হলুদে গুড়া মরিচের গুড়া ");
INSERT INTO tbl_expensesde VALUES("1177","0","211","111","6680.00","মনির");
INSERT INTO tbl_expensesde VALUES("1178","0","211","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1179","0","211","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1180","0","211","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1181","0","211","20","90.00","ভিমবার");
INSERT INTO tbl_expensesde VALUES("1182","0","211","109","100.00","কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("1183","0","211","109","2990.00","আলু");
INSERT INTO tbl_expensesde VALUES("1184","0","211","109","1760.00","রসুন আদা জিরা");
INSERT INTO tbl_expensesde VALUES("1185","0","211","109","2480.00","মুসুরীর ডাল");
INSERT INTO tbl_expensesde VALUES("1186","0","211","90","60.00","");
INSERT INTO tbl_expensesde VALUES("1187","0","211","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1188","0","211","158","30.00","");
INSERT INTO tbl_expensesde VALUES("1189","0","211","171","1000.00","");
INSERT INTO tbl_expensesde VALUES("1190","0","211","90","20.00","");
INSERT INTO tbl_expensesde VALUES("1191","0","211","157","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1192","0","212","86","600.00","");
INSERT INTO tbl_expensesde VALUES("1193","0","212","92","270.00","");
INSERT INTO tbl_expensesde VALUES("1194","0","212","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1195","0","212","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1196","0","212","92","200.00","");
INSERT INTO tbl_expensesde VALUES("1197","0","212","106","1500.00","সারাফাত");
INSERT INTO tbl_expensesde VALUES("1198","0","212","158","120.00","");
INSERT INTO tbl_expensesde VALUES("1199","0","212","111","140.00","");
INSERT INTO tbl_expensesde VALUES("1200","0","212","149","600.00","");
INSERT INTO tbl_expensesde VALUES("1201","0","212","111","200.00","");
INSERT INTO tbl_expensesde VALUES("1202","0","212","86","13000.00","সজিব");
INSERT INTO tbl_expensesde VALUES("1203","0","213","158","60.00","RASED");
INSERT INTO tbl_expensesde VALUES("1204","0","213","86","4770.00","");
INSERT INTO tbl_expensesde VALUES("1205","0","213","103","420.00","");
INSERT INTO tbl_expensesde VALUES("1206","0","213","86","1460.00","");
INSERT INTO tbl_expensesde VALUES("1207","0","213","87","1000.00","SOHRAB");
INSERT INTO tbl_expensesde VALUES("1208","0","213","89","19000.00","");
INSERT INTO tbl_expensesde VALUES("1209","0","213","89","27000.00","DELEAR FEE");
INSERT INTO tbl_expensesde VALUES("1210","0","213","111","5400.00","ISMAIL");
INSERT INTO tbl_expensesde VALUES("1211","0","213","111","300.00","");
INSERT INTO tbl_expensesde VALUES("1212","0","213","170","1280.00","MURGI,MASLLA,MURGI");
INSERT INTO tbl_expensesde VALUES("1213","0","213","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1214","0","213","91","1800.00","");
INSERT INTO tbl_expensesde VALUES("1215","0","213","170","300.00","");
INSERT INTO tbl_expensesde VALUES("1216","0","214","86","4625.00","");
INSERT INTO tbl_expensesde VALUES("1217","0","214","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1218","0","214","109","200.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1219","0","214","85","15600.00","18-9961");
INSERT INTO tbl_expensesde VALUES("1220","0","215","109","330.00","কাচামরিচ বেগুন");
INSERT INTO tbl_expensesde VALUES("1221","0","215","109","335.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1222","0","215","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("1223","0","215","158","80.00","রাজমিস্ত্র্রি ভাড়া");
INSERT INTO tbl_expensesde VALUES("1224","0","216","90","40.00","");
INSERT INTO tbl_expensesde VALUES("1225","0","216","152","50.00","");
INSERT INTO tbl_expensesde VALUES("1226","0","216","90","40.00","");
INSERT INTO tbl_expensesde VALUES("1227","0","216","137","1400.00","বেয়ারিং");
INSERT INTO tbl_expensesde VALUES("1228","0","216","167","100.00","");
INSERT INTO tbl_expensesde VALUES("1229","0","217","103","300.00","2  NUT");
INSERT INTO tbl_expensesde VALUES("1230","0","217","103","150.00","DULAL MISTRI");
INSERT INTO tbl_expensesde VALUES("1231","0","217","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1232","0","217","85","10120.00","TAORASH");
INSERT INTO tbl_expensesde VALUES("1233","0","217","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1234","0","217","111","450.00","MONIR");
INSERT INTO tbl_expensesde VALUES("1235","0","217","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("1236","0","217","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1237","0","217","157","220.00","");
INSERT INTO tbl_expensesde VALUES("1238","0","217","91","340.00","");
INSERT INTO tbl_expensesde VALUES("1239","0","217","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1240","0","217","86","4620.00","");
INSERT INTO tbl_expensesde VALUES("1241","0","218","15","350.00","RIYAD");
INSERT INTO tbl_expensesde VALUES("1242","0","218","27","210.00","SUTLY");
INSERT INTO tbl_expensesde VALUES("1243","0","218","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1244","0","218","27","130.00","");
INSERT INTO tbl_expensesde VALUES("1245","0","218","111","4020.00","TAORASH");
INSERT INTO tbl_expensesde VALUES("1246","0","219","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1247","0","219","158","50.00","wahid");
INSERT INTO tbl_expensesde VALUES("1248","0","219","149","85.00","");
INSERT INTO tbl_expensesde VALUES("1249","0","219","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1250","0","219","144","4200.00","");
INSERT INTO tbl_expensesde VALUES("1251","0","219","111","2990.00","");
INSERT INTO tbl_expensesde VALUES("1252","0","219","103","110.00","");
INSERT INTO tbl_expensesde VALUES("1253","0","220","170","110.00","");
INSERT INTO tbl_expensesde VALUES("1254","0","220","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1255","0","220","149","400.00","");
INSERT INTO tbl_expensesde VALUES("1256","0","220","167","1700.00","");
INSERT INTO tbl_expensesde VALUES("1257","0","220","27","70.00","RASED");
INSERT INTO tbl_expensesde VALUES("1258","0","220","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1259","0","220","170","390.00","");
INSERT INTO tbl_expensesde VALUES("1260","0","220","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1261","0","220","99","2210.00","");
INSERT INTO tbl_expensesde VALUES("1262","0","220","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1263","0","220","164","17100.00","");
INSERT INTO tbl_expensesde VALUES("1264","0","221","19","550.00","");
INSERT INTO tbl_expensesde VALUES("1265","0","221","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1266","0","221","86","8075.00","");
INSERT INTO tbl_expensesde VALUES("1267","0","221","170","230.00","");
INSERT INTO tbl_expensesde VALUES("1268","0","221","170","30.00","");
INSERT INTO tbl_expensesde VALUES("1269","0","221","173","4200.00","");
INSERT INTO tbl_expensesde VALUES("1270","0","221","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1271","0","222","111","1200.00","709");
INSERT INTO tbl_expensesde VALUES("1272","0","222","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1273","0","222","170","875.00","SOABIN OIL");
INSERT INTO tbl_expensesde VALUES("1274","0","222","170","1045.00","MURGI");
INSERT INTO tbl_expensesde VALUES("1275","0","222","170","375.00","EGG");
INSERT INTO tbl_expensesde VALUES("1276","0","222","170","35.00","SUKNA MARICH");
INSERT INTO tbl_expensesde VALUES("1277","0","222","170","20.00","MASLA");
INSERT INTO tbl_expensesde VALUES("1278","0","222","15","100.00","");
INSERT INTO tbl_expensesde VALUES("1279","0","222","162","1140.00","");
INSERT INTO tbl_expensesde VALUES("1280","0","222","158","10.00","");
INSERT INTO tbl_expensesde VALUES("1281","0","222","44","100.00","");
INSERT INTO tbl_expensesde VALUES("1282","0","222","87","200.00","");
INSERT INTO tbl_expensesde VALUES("1283","0","222","158","40.00","DULAL");
INSERT INTO tbl_expensesde VALUES("1284","0","223","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1285","0","223","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1286","0","223","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1287","0","223","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("1288","0","224","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1289","0","224","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1290","0","224","170","525.00","");
INSERT INTO tbl_expensesde VALUES("1291","0","224","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1292","0","224","99","1920.00","");
INSERT INTO tbl_expensesde VALUES("1293","0","224","157","340.00","");
INSERT INTO tbl_expensesde VALUES("1294","0","224","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1295","0","224","86","5950.00","");
INSERT INTO tbl_expensesde VALUES("1296","0","225","103","300.00","কাজ বাবদ");
INSERT INTO tbl_expensesde VALUES("1297","0","225","157","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1298","0","225","85","7800.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("1299","0","225","170","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1300","0","225","170","60.00","তরকারী");
INSERT INTO tbl_expensesde VALUES("1301","0","225","150","50.00","সলুয়েশন");
INSERT INTO tbl_expensesde VALUES("1302","0","225","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1303","0","225","13","230.00","");
INSERT INTO tbl_expensesde VALUES("1304","0","225","137","100.00","ব্যাটারির পানি");
INSERT INTO tbl_expensesde VALUES("1305","0","225","150","25000.00","রোলার পিনিয়াম বাবদ সালাম");
INSERT INTO tbl_expensesde VALUES("1306","0","225","146","1760.00","");
INSERT INTO tbl_expensesde VALUES("1307","0","225","138","800.00","সরদার খরচ");
INSERT INTO tbl_expensesde VALUES("1308","0","225","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1309","0","225","173","50.00","ওয়াহিদ ভাড়া");
INSERT INTO tbl_expensesde VALUES("1310","0","225","105","750.00","");
INSERT INTO tbl_expensesde VALUES("1311","0","225","158","810.00","");
INSERT INTO tbl_expensesde VALUES("1312","0","225","145","1000.00","বাসার নছিমন ভাড়া");
INSERT INTO tbl_expensesde VALUES("1313","0","225","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1314","0","225","85","5400.00","ইসমাইল");
INSERT INTO tbl_expensesde VALUES("1315","0","225","160","50.00","");
INSERT INTO tbl_expensesde VALUES("1316","0","226","111","1700.00","");
INSERT INTO tbl_expensesde VALUES("1317","0","226","104","65.00","টোস্ট");
INSERT INTO tbl_expensesde VALUES("1318","0","226","86","5180.00","");
INSERT INTO tbl_expensesde VALUES("1319","0","226","99","2100.00","");
INSERT INTO tbl_expensesde VALUES("1320","0","226","92","260.00","");
INSERT INTO tbl_expensesde VALUES("1321","0","226","145","5600.00","বাসার ক্যামেরা");
INSERT INTO tbl_expensesde VALUES("1322","0","226","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1323","0","226","87","500.00","সালাউদ্দীন");
INSERT INTO tbl_expensesde VALUES("1324","0","227","170","320.00","");
INSERT INTO tbl_expensesde VALUES("1325","0","228","99","1250.00","2 kg 500");
INSERT INTO tbl_expensesde VALUES("1326","0","228","86","220.00","nasta");
INSERT INTO tbl_expensesde VALUES("1327","0","228","86","9900.00","");
INSERT INTO tbl_expensesde VALUES("1328","0","228","111","500.00","");
INSERT INTO tbl_expensesde VALUES("1329","0","228","157","120.00","");
INSERT INTO tbl_expensesde VALUES("1330","0","228","87","2320.00","sohrab");
INSERT INTO tbl_expensesde VALUES("1331","0","228","87","1410.00","mostafiz");
INSERT INTO tbl_expensesde VALUES("1332","0","228","86","220.00","");
INSERT INTO tbl_expensesde VALUES("1333","0","228","87","2570.00","sahin");
INSERT INTO tbl_expensesde VALUES("1334","0","228","158","60.00","");
INSERT INTO tbl_expensesde VALUES("1335","0","228","111","1660.00","ismile");
INSERT INTO tbl_expensesde VALUES("1336","0","228","111","700.00","");
INSERT INTO tbl_expensesde VALUES("1337","0","228","161","230.00","");
INSERT INTO tbl_expensesde VALUES("1338","0","228","157","90.00","");
INSERT INTO tbl_expensesde VALUES("1339","0","228","157","90.00","");
INSERT INTO tbl_expensesde VALUES("1340","0","228","103","5010.00","");
INSERT INTO tbl_expensesde VALUES("1341","0","229","158","50.00","");
INSERT INTO tbl_expensesde VALUES("1342","0","229","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1343","0","229","170","415.00","");
INSERT INTO tbl_expensesde VALUES("1344","0","229","157","100.00","");
INSERT INTO tbl_expensesde VALUES("1345","0","229","170","800.00","mugdal");
INSERT INTO tbl_expensesde VALUES("1346","0","229","111","5560.00","");
INSERT INTO tbl_expensesde VALUES("1347","0","229","111","1800.00","ismile");
INSERT INTO tbl_expensesde VALUES("1348","0","229","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1349","0","229","85","9200.00","taorash");
INSERT INTO tbl_expensesde VALUES("1350","0","229","91","100.00","");
INSERT INTO tbl_expensesde VALUES("1351","0","230","170","500.00","murgi");
INSERT INTO tbl_expensesde VALUES("1352","0","230","170","50.00","masla");
INSERT INTO tbl_expensesde VALUES("1353","0","230","158","540.00","");
INSERT INTO tbl_expensesde VALUES("1354","0","230","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1355","0","230","86","5630.00","");
INSERT INTO tbl_expensesde VALUES("1356","0","230","91","800.00","");
INSERT INTO tbl_expensesde VALUES("1357","0","231","15","100.00","");
INSERT INTO tbl_expensesde VALUES("1358","0","231","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1359","0","231","162","190.00","jel");
INSERT INTO tbl_expensesde VALUES("1360","0","231","44","200.00","");
INSERT INTO tbl_expensesde VALUES("1361","0","231","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("1362","0","231","170","385.00","egg");
INSERT INTO tbl_expensesde VALUES("1363","0","231","170","883.00","soabin oil");
INSERT INTO tbl_expensesde VALUES("1364","0","231","170","300.00","torkari");
INSERT INTO tbl_expensesde VALUES("1365","0","231","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1366","0","231","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1367","0","231","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1368","0","231","158","200.00","sajib");
INSERT INTO tbl_expensesde VALUES("1369","0","231","167","1600.00","");
INSERT INTO tbl_expensesde VALUES("1370","0","232","95","140.00","");
INSERT INTO tbl_expensesde VALUES("1371","0","232","157","20.00","");
INSERT INTO tbl_expensesde VALUES("1372","0","233","103","4700.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("1373","0","233","111","450.00","");
INSERT INTO tbl_expensesde VALUES("1374","0","233","104","950.00","মোবাইল খরচ");
INSERT INTO tbl_expensesde VALUES("1375","0","233","86","6020.00","");
INSERT INTO tbl_expensesde VALUES("1376","0","233","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1377","0","233","111","930.00","");
INSERT INTO tbl_expensesde VALUES("1378","0","233","153","500.00","সোহরাব");
INSERT INTO tbl_expensesde VALUES("1379","0","233","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1380","0","233","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1381","0","234","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("1382","0","234","92","150.00","");
INSERT INTO tbl_expensesde VALUES("1383","0","234","170","490.00","ডিম,তরকারি");
INSERT INTO tbl_expensesde VALUES("1384","0","234","171","2000.00","হিজরা");
INSERT INTO tbl_expensesde VALUES("1385","0","235","111","4220.00","");
INSERT INTO tbl_expensesde VALUES("1386","0","235","111","2310.00","");
INSERT INTO tbl_expensesde VALUES("1387","0","235","103","30000.00","বকুল কে প্রাদান");
INSERT INTO tbl_expensesde VALUES("1388","0","235","150","600.00","ওযারিং মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("1389","0","235","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1390","0","235","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1391","0","235","103","2420.00","সেন্টার বেয়ারিং");
INSERT INTO tbl_expensesde VALUES("1392","0","235","85","9800.00","");
INSERT INTO tbl_expensesde VALUES("1393","0","236","92","240.00","সুমন");
INSERT INTO tbl_expensesde VALUES("1394","0","236","91","900.00","");
INSERT INTO tbl_expensesde VALUES("1395","0","236","158","40.00","রাজমিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("1396","0","236","92","85.00","+ভাড়া");
INSERT INTO tbl_expensesde VALUES("1397","0","236","87","500.00","");
INSERT INTO tbl_expensesde VALUES("1398","0","236","99","1800.00","");
INSERT INTO tbl_expensesde VALUES("1399","0","236","92","270.00","");
INSERT INTO tbl_expensesde VALUES("1400","0","236","86","11370.00","");
INSERT INTO tbl_expensesde VALUES("1401","0","237","110","600.00","");
INSERT INTO tbl_expensesde VALUES("1402","0","238","170","330.00","");
INSERT INTO tbl_expensesde VALUES("1403","0","238","170","13100.00","rice");
INSERT INTO tbl_expensesde VALUES("1404","0","238","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1405","0","238","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1406","0","238","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1407","0","238","170","490.00","");
INSERT INTO tbl_expensesde VALUES("1408","0","238","170","225.00","");
INSERT INTO tbl_expensesde VALUES("1409","0","238","170","340.00","");
INSERT INTO tbl_expensesde VALUES("1410","0","238","170","9420.00","");
INSERT INTO tbl_expensesde VALUES("1411","0","238","160","100.00","");
INSERT INTO tbl_expensesde VALUES("1412","0","238","149","140.00","");
INSERT INTO tbl_expensesde VALUES("1413","0","238","85","11700.00","");
INSERT INTO tbl_expensesde VALUES("1414","0","238","44","30.00","");
INSERT INTO tbl_expensesde VALUES("1415","0","238","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1416","0","238","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1417","0","238","27","120.00","");
INSERT INTO tbl_expensesde VALUES("1418","0","238","111","1720.00","");
INSERT INTO tbl_expensesde VALUES("1419","0","238","164","19000.00","pati,roller,pipe");
INSERT INTO tbl_expensesde VALUES("1420","0","239","158","120.00","");
INSERT INTO tbl_expensesde VALUES("1421","0","239","158","200.00","সজিব");
INSERT INTO tbl_expensesde VALUES("1422","0","239","109","13850.00","চাল,ডাল,লবন");
INSERT INTO tbl_expensesde VALUES("1423","0","239","158","40.00","ভাড়া+নাস্তা");
INSERT INTO tbl_expensesde VALUES("1424","0","239","95","110.00","");
INSERT INTO tbl_expensesde VALUES("1425","0","239","20","540.00","ব্যাটারির পানি");
INSERT INTO tbl_expensesde VALUES("1426","0","239","86","11400.00","");
INSERT INTO tbl_expensesde VALUES("1427","0","239","92","270.00","");
INSERT INTO tbl_expensesde VALUES("1428","0","239","91","150.00","");
INSERT INTO tbl_expensesde VALUES("1429","0","239","92","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1430","0","239","111","1300.00","");
INSERT INTO tbl_expensesde VALUES("1431","0","240","87","1400.00","ইসমাইল");
INSERT INTO tbl_expensesde VALUES("1432","0","240","158","120.00","");
INSERT INTO tbl_expensesde VALUES("1433","0","240","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("1434","0","240","111","480.00","");
INSERT INTO tbl_expensesde VALUES("1435","0","240","111","5205.00","");
INSERT INTO tbl_expensesde VALUES("1436","0","240","125","150.00","ইন্জেকশন");
INSERT INTO tbl_expensesde VALUES("1437","0","240","109","1330.00","মুরগি");
INSERT INTO tbl_expensesde VALUES("1438","0","240","109","880.00","তেল");
INSERT INTO tbl_expensesde VALUES("1439","0","240","109","450.00","ডিম+মসলা");
INSERT INTO tbl_expensesde VALUES("1440","0","240","109","200.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1441","0","241","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1442","0","241","85","5000.00","monir");
INSERT INTO tbl_expensesde VALUES("1443","0","241","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1444","0","241","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1445","0","241","170","120.00","");
INSERT INTO tbl_expensesde VALUES("1446","0","241","27","2665.00","");
INSERT INTO tbl_expensesde VALUES("1447","0","241","165","2665.00","");
INSERT INTO tbl_expensesde VALUES("1448","0","241","165","380.00","");
INSERT INTO tbl_expensesde VALUES("1449","0","241","165","120.00","");
INSERT INTO tbl_expensesde VALUES("1450","0","241","165","40.00","");
INSERT INTO tbl_expensesde VALUES("1451","0","241","20","35.00","");
INSERT INTO tbl_expensesde VALUES("1452","0","241","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("1453","0","241","111","750.00","");
INSERT INTO tbl_expensesde VALUES("1454","0","241","162","1350.00","");
INSERT INTO tbl_expensesde VALUES("1455","0","241","144","4200.00","");
INSERT INTO tbl_expensesde VALUES("1456","0","241","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1457","0","241","158","50.00","");
INSERT INTO tbl_expensesde VALUES("1458","0","241","171","50.00","");
INSERT INTO tbl_expensesde VALUES("1459","0","241","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1460","0","241","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1461","0","241","157","70.00","");
INSERT INTO tbl_expensesde VALUES("1462","0","241","91","200.00","");
INSERT INTO tbl_expensesde VALUES("1463","0","241","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1464","0","241","149","150.00","");
INSERT INTO tbl_expensesde VALUES("1465","0","241","87","13000.00","sohrab");
INSERT INTO tbl_expensesde VALUES("1466","0","241","99","1800.00","600");
INSERT INTO tbl_expensesde VALUES("1467","0","241","91","630.00","");
INSERT INTO tbl_expensesde VALUES("1468","0","241","86","15620.00","");
INSERT INTO tbl_expensesde VALUES("1469","0","242","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1470","0","242","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1471","0","242","111","1950.00","TAORAS");
INSERT INTO tbl_expensesde VALUES("1472","0","242","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1473","0","242","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1474","0","242","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1475","0","242","111","400.00","");
INSERT INTO tbl_expensesde VALUES("1476","0","242","170","650.00","HALUD,MARICH");
INSERT INTO tbl_expensesde VALUES("1477","0","242","170","260.00","TORKARI");
INSERT INTO tbl_expensesde VALUES("1478","0","242","170","380.00","");
INSERT INTO tbl_expensesde VALUES("1479","0","243","137","1900.00","সালাউদ্দীনের ডক্টর+উষধ");
INSERT INTO tbl_expensesde VALUES("1480","0","243","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1481","0","244","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1482","0","244","93","200.00","সাগর খবার বাবদ");
INSERT INTO tbl_expensesde VALUES("1483","0","244","20","3800.00","লিয়েন মিষ্টি ");
INSERT INTO tbl_expensesde VALUES("1484","0","245","87","157660.00","");
INSERT INTO tbl_expensesde VALUES("1485","0","246","111","650.00","");
INSERT INTO tbl_expensesde VALUES("1486","0","246","27","40.00","");
INSERT INTO tbl_expensesde VALUES("1487","0","246","99","2400.00","");
INSERT INTO tbl_expensesde VALUES("1488","0","246","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1489","0","246","86","11775.00","");
INSERT INTO tbl_expensesde VALUES("1490","0","246","85","7600.00","");
INSERT INTO tbl_expensesde VALUES("1491","0","246","103","14350.00","");
INSERT INTO tbl_expensesde VALUES("1492","0","246","87","22000.00","");
INSERT INTO tbl_expensesde VALUES("1493","0","246","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1494","0","247","158","100.00","");
INSERT INTO tbl_expensesde VALUES("1495","0","247","87","800.00","মোস্তাফিজ");
INSERT INTO tbl_expensesde VALUES("1496","0","247","87","2700.00","রায়হান");
INSERT INTO tbl_expensesde VALUES("1497","0","247","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1498","0","247","20","350.00","মোবাইল খরচ");
INSERT INTO tbl_expensesde VALUES("1499","0","247","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1500","0","247","109","280.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1501","0","247","20","1000.00","নেট বিল");
INSERT INTO tbl_expensesde VALUES("1502","0","247","149","100.00","ওয়ালিং রড");
INSERT INTO tbl_expensesde VALUES("1503","0","247","93","200.00","খাবার ");
INSERT INTO tbl_expensesde VALUES("1504","0","247","149","50.00","সলুয়েশন");
INSERT INTO tbl_expensesde VALUES("1505","0","248","164","19270.00","KALU");
INSERT INTO tbl_expensesde VALUES("1506","0","248","164","20350.00","");
INSERT INTO tbl_expensesde VALUES("1507","0","248","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1508","0","248","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1509","0","248","158","60.00","");
INSERT INTO tbl_expensesde VALUES("1510","0","248","157","40.00","");
INSERT INTO tbl_expensesde VALUES("1511","0","248","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1512","0","249","103","2150.00","পাতি খোলা সেন্টার বল্টু");
INSERT INTO tbl_expensesde VALUES("1513","0","249","92","270.00","");
INSERT INTO tbl_expensesde VALUES("1514","0","249","92","40.00","রাশেদ");
INSERT INTO tbl_expensesde VALUES("1515","0","249","86","5000.00","");
INSERT INTO tbl_expensesde VALUES("1516","0","249","111","850.00","709");
INSERT INTO tbl_expensesde VALUES("1517","0","250","20","200.00","টুটপেস্ট+ক্লিনার");
INSERT INTO tbl_expensesde VALUES("1518","0","250","158","200.00","");
INSERT INTO tbl_expensesde VALUES("1519","0","250","109","885.00","মুরগি+ডিন");
INSERT INTO tbl_expensesde VALUES("1520","0","250","111","4900.00","");
INSERT INTO tbl_expensesde VALUES("1521","0","250","145","35000.00","");
INSERT INTO tbl_expensesde VALUES("1522","0","250","158","100.00","");
INSERT INTO tbl_expensesde VALUES("1523","0","250","137","30.00","চিপস");
INSERT INTO tbl_expensesde VALUES("1524","0","250","145","20000.00","");
INSERT INTO tbl_expensesde VALUES("1525","0","250","92","85.00","রাশেদ ,কয়েল+ভাড়া");
INSERT INTO tbl_expensesde VALUES("1526","0","250","137","60.00","");
INSERT INTO tbl_expensesde VALUES("1527","0","250","86","5720.00","06/06/24");
INSERT INTO tbl_expensesde VALUES("1528","0","250","86","2405.00","");
INSERT INTO tbl_expensesde VALUES("1529","0","251","86","80.00","");
INSERT INTO tbl_expensesde VALUES("1530","0","251","170","500.00","");
INSERT INTO tbl_expensesde VALUES("1531","0","251","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1532","0","251","85","8300.00","TAURASH OIL");
INSERT INTO tbl_expensesde VALUES("1533","0","252","137","8060.00","নাওগার যাওয়ার ভাড়া+খাবার");
INSERT INTO tbl_expensesde VALUES("1534","0","252","158","10.00","");
INSERT INTO tbl_expensesde VALUES("1535","0","252","109","875.00","তেল");
INSERT INTO tbl_expensesde VALUES("1536","0","252","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1537","0","253","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("1538","0","253","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1539","0","253","111","650.00","709");
INSERT INTO tbl_expensesde VALUES("1540","0","254","167","2000.00","10 GARI");
INSERT INTO tbl_expensesde VALUES("1541","0","255","87","3000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("1542","0","256","170","430.00","");
INSERT INTO tbl_expensesde VALUES("1543","0","256","157","240.00","");
INSERT INTO tbl_expensesde VALUES("1544","0","256","170","200.00","kacamorich");
INSERT INTO tbl_expensesde VALUES("1545","0","256","111","300.00","709");
INSERT INTO tbl_expensesde VALUES("1546","0","256","157","300.00","lebour");
INSERT INTO tbl_expensesde VALUES("1547","0","256","91","460.00","");
INSERT INTO tbl_expensesde VALUES("1548","0","256","99","1590.00","");
INSERT INTO tbl_expensesde VALUES("1549","0","256","86","9190.00","");
INSERT INTO tbl_expensesde VALUES("1550","0","257","158","40.00","নাস্তা");
INSERT INTO tbl_expensesde VALUES("1551","0","257","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1552","0","257","137","400.00","সালাউদ্দীন উষধ");
INSERT INTO tbl_expensesde VALUES("1553","0","257","109","2320.00","মাছ");
INSERT INTO tbl_expensesde VALUES("1554","0","257","156","170.00","709");
INSERT INTO tbl_expensesde VALUES("1555","0","257","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1556","0","257","87","4000.00","");
INSERT INTO tbl_expensesde VALUES("1557","0","257","162","1100.00","");
INSERT INTO tbl_expensesde VALUES("1558","0","257","160","200.00","");
INSERT INTO tbl_expensesde VALUES("1559","0","257","109","380.00","তেল");
INSERT INTO tbl_expensesde VALUES("1560","0","257","150","1100.00","সীট নেট জালাই");
INSERT INTO tbl_expensesde VALUES("1561","0","257","85","5010.00","");
INSERT INTO tbl_expensesde VALUES("1562","0","257","150","1870.00","নাট+সুতা+ভাড়া");
INSERT INTO tbl_expensesde VALUES("1563","0","257","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1564","0","257","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1565","0","258","95","240.00","");
INSERT INTO tbl_expensesde VALUES("1566","0","258","92","40.00","");
INSERT INTO tbl_expensesde VALUES("1567","0","258","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("1568","0","258","111","350.00","");
INSERT INTO tbl_expensesde VALUES("1569","0","258","111","650.00","");
INSERT INTO tbl_expensesde VALUES("1570","0","258","106","600.00","হাজিরা");
INSERT INTO tbl_expensesde VALUES("1571","0","258","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1572","0","258","86","6840.00","");
INSERT INTO tbl_expensesde VALUES("1573","0","258","158","60.00","");
INSERT INTO tbl_expensesde VALUES("1574","0","259","91","60.00","");
INSERT INTO tbl_expensesde VALUES("1575","0","259","150","2600.00","হার্ডওয়ার বিল");
INSERT INTO tbl_expensesde VALUES("1576","0","259","91","900.00","");
INSERT INTO tbl_expensesde VALUES("1577","0","259","111","5760.00","");
INSERT INTO tbl_expensesde VALUES("1578","0","259","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1579","0","259","158","10.00","");
INSERT INTO tbl_expensesde VALUES("1580","0","259","20","160.00","চা চিনি");
INSERT INTO tbl_expensesde VALUES("1581","0","259","109","410.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1582","0","259","20","125.00","পেষ্ট");
INSERT INTO tbl_expensesde VALUES("1583","0","259","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1584","0","259","111","1030.00","");
INSERT INTO tbl_expensesde VALUES("1585","0","259","111","500.00","");
INSERT INTO tbl_expensesde VALUES("1586","0","259","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("1587","0","259","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1588","0","260","158","50.00","");
INSERT INTO tbl_expensesde VALUES("1589","0","260","85","9095.00","TATA");
INSERT INTO tbl_expensesde VALUES("1590","0","260","27","60.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("1591","0","260","27","410.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("1592","0","260","103","200.00","CHAKKA HAOA");
INSERT INTO tbl_expensesde VALUES("1593","0","260","87","22500.00","");
INSERT INTO tbl_expensesde VALUES("1594","0","260","21","500.00","");
INSERT INTO tbl_expensesde VALUES("1595","0","260","99","600.00","");
INSERT INTO tbl_expensesde VALUES("1596","0","260","157","260.00","");
INSERT INTO tbl_expensesde VALUES("1597","0","260","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1598","0","261","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1599","0","261","111","1750.00","");
INSERT INTO tbl_expensesde VALUES("1600","0","261","20","200.00","মার্কার কলম");
INSERT INTO tbl_expensesde VALUES("1601","0","262","111","850.00","");
INSERT INTO tbl_expensesde VALUES("1602","0","263","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1603","0","263","92","50.00","");
INSERT INTO tbl_expensesde VALUES("1604","0","263","87","500.00","");
INSERT INTO tbl_expensesde VALUES("1605","0","263","111","4360.00","");
INSERT INTO tbl_expensesde VALUES("1606","0","263","109","878.00","");
INSERT INTO tbl_expensesde VALUES("1607","0","263","109","1282.00","মুরগি");
INSERT INTO tbl_expensesde VALUES("1608","0","263","109","655.00","আলু ডিম");
INSERT INTO tbl_expensesde VALUES("1609","0","263","170","20.00","মসলা");
INSERT INTO tbl_expensesde VALUES("1610","0","263","152","10.00","");
INSERT INTO tbl_expensesde VALUES("1611","0","263","109","3320.00","আলু");
INSERT INTO tbl_expensesde VALUES("1612","0","263","103","300.00","গ্রিজ");
INSERT INTO tbl_expensesde VALUES("1613","0","263","109","350.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1614","0","263","137","700.00","গাফফার");
INSERT INTO tbl_expensesde VALUES("1615","0","263","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1616","0","263","103","8000.00","টাটা গাড়ির মাল");
INSERT INTO tbl_expensesde VALUES("1617","0","264","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1618","0","264","149","20000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("1619","0","264","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1620","0","264","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1621","0","264","162","1250.00","");
INSERT INTO tbl_expensesde VALUES("1622","0","264","144","28000.00","MINAR BODDOY");
INSERT INTO tbl_expensesde VALUES("1623","0","265","85","11600.00","taorush");
INSERT INTO tbl_expensesde VALUES("1624","0","265","85","8160.00","tata");
INSERT INTO tbl_expensesde VALUES("1625","0","265","86","14760.00","");
INSERT INTO tbl_expensesde VALUES("1626","0","265","111","1000.00","709");
INSERT INTO tbl_expensesde VALUES("1627","0","266","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1628","0","266","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1629","0","266","86","6380.00","10-0624");
INSERT INTO tbl_expensesde VALUES("1630","0","266","103","700.00","tata");
INSERT INTO tbl_expensesde VALUES("1631","0","267","158","200.00","");
INSERT INTO tbl_expensesde VALUES("1632","0","267","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1633","0","267","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1634","0","267","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1635","0","267","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("1636","0","267","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1637","0","267","111","400.00","");
INSERT INTO tbl_expensesde VALUES("1638","0","267","164","20500.00","");
INSERT INTO tbl_expensesde VALUES("1639","0","267","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1640","0","267","85","2000.00","");
INSERT INTO tbl_expensesde VALUES("1641","0","268","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1642","0","268","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1643","0","268","171","30.00","");
INSERT INTO tbl_expensesde VALUES("1644","0","268","160","70.00","");
INSERT INTO tbl_expensesde VALUES("1645","0","268","158","60.00","");
INSERT INTO tbl_expensesde VALUES("1646","0","268","27","2470.00","");
INSERT INTO tbl_expensesde VALUES("1647","0","269","111","600.00","monir");
INSERT INTO tbl_expensesde VALUES("1648","0","269","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1649","0","269","170","100.00","");
INSERT INTO tbl_expensesde VALUES("1650","0","269","170","580.00","");
INSERT INTO tbl_expensesde VALUES("1651","0","269","87","1500.00","salauddin bonus");
INSERT INTO tbl_expensesde VALUES("1652","0","269","27","170.00","");
INSERT INTO tbl_expensesde VALUES("1653","0","269","86","8357.00","");
INSERT INTO tbl_expensesde VALUES("1654","0","269","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1655","0","269","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("1656","0","270","156","140.00","");
INSERT INTO tbl_expensesde VALUES("1657","0","271","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1658","0","271","170","430.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1659","0","271","152","50.00","");
INSERT INTO tbl_expensesde VALUES("1660","0","271","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1661","0","271","111","4920.00","");
INSERT INTO tbl_expensesde VALUES("1662","0","271","137","140.00","ঝাড়ু");
INSERT INTO tbl_expensesde VALUES("1663","0","271","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("1664","0","271","152","20.00","");
INSERT INTO tbl_expensesde VALUES("1665","0","271","109","120.00","কুমড়া");
INSERT INTO tbl_expensesde VALUES("1666","0","272","153","3000.00","বোনাস");
INSERT INTO tbl_expensesde VALUES("1667","0","272","171","50.00","");
INSERT INTO tbl_expensesde VALUES("1668","0","272","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1669","0","272","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1670","0","272","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("1671","0","272","103","900.00","পলিথিন");
INSERT INTO tbl_expensesde VALUES("1672","0","272","85","6010.00","");
INSERT INTO tbl_expensesde VALUES("1673","0","273","87","1080.00","বোনাস");
INSERT INTO tbl_expensesde VALUES("1674","0","274","111","600.00","");
INSERT INTO tbl_expensesde VALUES("1675","0","274","27","400.00","");
INSERT INTO tbl_expensesde VALUES("1676","0","274","157","40.00","");
INSERT INTO tbl_expensesde VALUES("1677","0","274","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1678","0","274","157","80.00","");
INSERT INTO tbl_expensesde VALUES("1679","0","274","170","100.00","");
INSERT INTO tbl_expensesde VALUES("1680","0","274","103","200.00","");
INSERT INTO tbl_expensesde VALUES("1681","0","274","86","9930.00","");
INSERT INTO tbl_expensesde VALUES("1682","0","274","171","1500.00","MOSQUE");
INSERT INTO tbl_expensesde VALUES("1683","0","274","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1684","0","274","170","760.00","EGG");
INSERT INTO tbl_expensesde VALUES("1685","0","274","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1686","0","275","170","910.00","soabin oil+salt");
INSERT INTO tbl_expensesde VALUES("1687","0","275","156","200.00","");
INSERT INTO tbl_expensesde VALUES("1688","0","275","156","200.00","");
INSERT INTO tbl_expensesde VALUES("1689","0","275","27","500.00","");
INSERT INTO tbl_expensesde VALUES("1690","0","275","164","18600.00","");
INSERT INTO tbl_expensesde VALUES("1691","0","275","171","1000.00","");
INSERT INTO tbl_expensesde VALUES("1692","0","275","111","5220.00","ismile");
INSERT INTO tbl_expensesde VALUES("1693","0","275","92","120.00","");
INSERT INTO tbl_expensesde VALUES("1694","0","275","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1695","0","275","158","60.00","");
INSERT INTO tbl_expensesde VALUES("1696","0","275","157","100.00","");
INSERT INTO tbl_expensesde VALUES("1697","0","276","86","8000.00","");
INSERT INTO tbl_expensesde VALUES("1698","0","277","91","800.00","");
INSERT INTO tbl_expensesde VALUES("1699","0","277","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1700","0","277","156","150.00","MONIR");
INSERT INTO tbl_expensesde VALUES("1701","0","277","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1702","0","277","171","140.00","");
INSERT INTO tbl_expensesde VALUES("1703","0","277","171","100.00","");
INSERT INTO tbl_expensesde VALUES("1704","0","277","111","600.00","ISMILE");
INSERT INTO tbl_expensesde VALUES("1705","0","277","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1706","0","277","167","2200.00","");
INSERT INTO tbl_expensesde VALUES("1707","0","277","149","10000.00","BAKUL");
INSERT INTO tbl_expensesde VALUES("1708","0","277","170","500.00","");
INSERT INTO tbl_expensesde VALUES("1709","0","277","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1710","0","277","91","200.00","MONIR");
INSERT INTO tbl_expensesde VALUES("1711","0","277","156","100.00","MONIR TRUCK");
INSERT INTO tbl_expensesde VALUES("1712","0","277","158","30.00","HELPER");
INSERT INTO tbl_expensesde VALUES("1713","0","278","158","100.00","");
INSERT INTO tbl_expensesde VALUES("1714","0","278","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1715","0","278","95","160.00","");
INSERT INTO tbl_expensesde VALUES("1716","0","278","87","11665.00","alek");
INSERT INTO tbl_expensesde VALUES("1717","0","278","103","700.00","rediotor");
INSERT INTO tbl_expensesde VALUES("1718","0","278","103","600.00","1612");
INSERT INTO tbl_expensesde VALUES("1719","0","278","103","5000.00","anamul");
INSERT INTO tbl_expensesde VALUES("1720","0","278","111","40.00","");
INSERT INTO tbl_expensesde VALUES("1721","0","278","87","2000.00","bonus");
INSERT INTO tbl_expensesde VALUES("1722","0","278","86","8300.00","");
INSERT INTO tbl_expensesde VALUES("1723","0","278","92","500.00","");
INSERT INTO tbl_expensesde VALUES("1724","0","279","27","30.00","");
INSERT INTO tbl_expensesde VALUES("1725","0","280","158","30.00","");
INSERT INTO tbl_expensesde VALUES("1726","0","280","170","280.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1727","0","280","111","900.00","709");
INSERT INTO tbl_expensesde VALUES("1728","0","280","93","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("1729","0","280","158","90.00","");
INSERT INTO tbl_expensesde VALUES("1730","0","280","158","10.00","");
INSERT INTO tbl_expensesde VALUES("1731","0","280","85","6010.00","");
INSERT INTO tbl_expensesde VALUES("1732","0","280","87","31000.00","বোনাস");
INSERT INTO tbl_expensesde VALUES("1733","0","280","170","890.00","মাছ");
INSERT INTO tbl_expensesde VALUES("1734","0","280","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("1735","0","280","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("1736","0","281","111","1000.00","");
INSERT INTO tbl_expensesde VALUES("1737","0","281","178","69200.00","");
INSERT INTO tbl_expensesde VALUES("1738","0","282","87","20700.00","");
INSERT INTO tbl_expensesde VALUES("1739","0","283","87","1800.00","");
INSERT INTO tbl_expensesde VALUES("1740","0","283","87","6000.00","");
INSERT INTO tbl_expensesde VALUES("1741","0","284","157","20.00","");
INSERT INTO tbl_expensesde VALUES("1742","0","284","27","930.00","");
INSERT INTO tbl_expensesde VALUES("1743","0","284","111","500.00","");
INSERT INTO tbl_expensesde VALUES("1744","0","284","27","500.00","");
INSERT INTO tbl_expensesde VALUES("1745","0","285","87","3000.00","kamal");
INSERT INTO tbl_expensesde VALUES("1746","0","286","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("1747","0","286","90","900.00","বাসার");
INSERT INTO tbl_expensesde VALUES("1748","0","286","159","900.00","বালুচরা");
INSERT INTO tbl_expensesde VALUES("1749","0","286","159","900.00","আড়িগাও");
INSERT INTO tbl_expensesde VALUES("1750","0","286","159","900.00","রহমান ডেইরি");
INSERT INTO tbl_expensesde VALUES("1751","0","286","145","650.00","বাসার অক্রিজেন");
INSERT INTO tbl_expensesde VALUES("1752","0","286","162","400.00","");
INSERT INTO tbl_expensesde VALUES("1753","0","286","137","530.00","বরফ");
INSERT INTO tbl_expensesde VALUES("1754","0","286","15","109.00","");
INSERT INTO tbl_expensesde VALUES("1755","0","286","15","319.00","");
INSERT INTO tbl_expensesde VALUES("1756","0","286","109","2200.00","মুরগি,ডিম ,জিরা,রসুন");
INSERT INTO tbl_expensesde VALUES("1757","0","286","152","20.00","");
INSERT INTO tbl_expensesde VALUES("1758","0","286","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1759","0","287","87","37715.00","");
INSERT INTO tbl_expensesde VALUES("1760","0","287","92","40.00","");
INSERT INTO tbl_expensesde VALUES("1761","0","287","85","12800.00","তাওরাস");
INSERT INTO tbl_expensesde VALUES("1762","0","287","85","14000.00","1612");
INSERT INTO tbl_expensesde VALUES("1763","0","287","87","7000.00","");
INSERT INTO tbl_expensesde VALUES("1764","0","287","92","150.00","");
INSERT INTO tbl_expensesde VALUES("1765","0","287","106","2620.00","");
INSERT INTO tbl_expensesde VALUES("1766","0","287","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1767","0","288","109","420.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1768","0","288","109","1100.00","ডিম,মরিচেরগুরা,হলুদেরগুরা");
INSERT INTO tbl_expensesde VALUES("1769","0","289","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1770","0","290","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1771","0","290","92","80.00","");
INSERT INTO tbl_expensesde VALUES("1772","0","291","87","55800.00","");
INSERT INTO tbl_expensesde VALUES("1773","0","292","92","130.00","");
INSERT INTO tbl_expensesde VALUES("1774","0","293","86","2790.00","");
INSERT INTO tbl_expensesde VALUES("1775","0","293","87","100.00","");
INSERT INTO tbl_expensesde VALUES("1776","0","294","137","3500.00","শাহিন বেতন");
INSERT INTO tbl_expensesde VALUES("1777","0","294","109","440.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("1778","0","294","156","50.00","");
INSERT INTO tbl_expensesde VALUES("1779","0","294","109","720.00","");
INSERT INTO tbl_expensesde VALUES("1780","0","294","90","60.00","");
INSERT INTO tbl_expensesde VALUES("1781","0","294","85","7610.00","");
INSERT INTO tbl_expensesde VALUES("1782","0","294","103","4820.00","");
INSERT INTO tbl_expensesde VALUES("1783","0","294","103","4120.00","");
INSERT INTO tbl_expensesde VALUES("1784","0","294","137","1000.00","ইসমাঈল");
INSERT INTO tbl_expensesde VALUES("1785","0","294","90","10.00","");
INSERT INTO tbl_expensesde VALUES("1786","0","294","137","8000.00","জিন্নাত বেতন");
INSERT INTO tbl_expensesde VALUES("1787","0","294","103","1150.00","ক্যাবল");
INSERT INTO tbl_expensesde VALUES("1788","0","295","92","220.00","");
INSERT INTO tbl_expensesde VALUES("1789","0","296","87","42050.00","");
INSERT INTO tbl_expensesde VALUES("1790","0","296","27","20.00","");
INSERT INTO tbl_expensesde VALUES("1791","0","296","166","100.00","RASED");
INSERT INTO tbl_expensesde VALUES("1792","0","296","166","50.00","RASED");
INSERT INTO tbl_expensesde VALUES("1793","0","296","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1794","0","296","158","30.00","");
INSERT INTO tbl_expensesde VALUES("1795","0","296","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1796","0","296","95","240.00","");
INSERT INTO tbl_expensesde VALUES("1797","0","296","86","7600.00","");
INSERT INTO tbl_expensesde VALUES("1798","0","296","87","1500.00","REDWANE");
INSERT INTO tbl_expensesde VALUES("1799","0","297","87","660.00","RABBI ABSENT");
INSERT INTO tbl_expensesde VALUES("1800","0","297","170","250.00","TARKARI");
INSERT INTO tbl_expensesde VALUES("1801","0","297","85","8600.00","TATA");
INSERT INTO tbl_expensesde VALUES("1802","0","297","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1803","0","297","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("1804","0","297","87","3000.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("1805","0","297","87","1520.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("1806","0","297","170","765.00","SALT,DAL,EGG");
INSERT INTO tbl_expensesde VALUES("1807","0","297","23","10000.00","");
INSERT INTO tbl_expensesde VALUES("1808","0","297","164","17800.00","");
INSERT INTO tbl_expensesde VALUES("1809","0","297","85","5000.00","MONIR");
INSERT INTO tbl_expensesde VALUES("1810","0","297","156","150.00","");
INSERT INTO tbl_expensesde VALUES("1811","0","298","15","348.00","");
INSERT INTO tbl_expensesde VALUES("1812","0","298","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1813","0","298","137","70.00","গাফফার");
INSERT INTO tbl_expensesde VALUES("1814","0","298","94","50.00","বিস্কুট");
INSERT INTO tbl_expensesde VALUES("1815","0","298","109","7140.00","আলু+রসুন+আদা+ডাল");
INSERT INTO tbl_expensesde VALUES("1816","0","298","158","70.00","");
INSERT INTO tbl_expensesde VALUES("1817","0","298","137","100.00","স্যাভলন");
INSERT INTO tbl_expensesde VALUES("1818","0","298","137","220.00","স্প্রে");
INSERT INTO tbl_expensesde VALUES("1819","0","298","137","120.00","বেলচা");
INSERT INTO tbl_expensesde VALUES("1820","0","298","137","20.00","হুক");
INSERT INTO tbl_expensesde VALUES("1821","0","298","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1822","0","299","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1823","0","300","15","218.00","riyad");
INSERT INTO tbl_expensesde VALUES("1824","0","300","87","2500.00","ripon");
INSERT INTO tbl_expensesde VALUES("1825","0","300","86","8100.00","");
INSERT INTO tbl_expensesde VALUES("1826","0","300","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1827","0","300","87","600.00","shahin");
INSERT INTO tbl_expensesde VALUES("1828","0","300","27","45.00","koyel");
INSERT INTO tbl_expensesde VALUES("1829","0","300","157","300.00","");
INSERT INTO tbl_expensesde VALUES("1830","0","301","111","1620.00","709");
INSERT INTO tbl_expensesde VALUES("1831","0","301","85","1080.00","709");
INSERT INTO tbl_expensesde VALUES("1832","0","301","111","4470.00","TAORUS");
INSERT INTO tbl_expensesde VALUES("1833","0","301","87","2000.00","SAGOR");
INSERT INTO tbl_expensesde VALUES("1834","0","301","111","4680.00","TATA");
INSERT INTO tbl_expensesde VALUES("1835","0","301","170","1150.00","OIL,JIRA,MASLA");
INSERT INTO tbl_expensesde VALUES("1836","0","301","164","17500.00","");
INSERT INTO tbl_expensesde VALUES("1837","0","301","170","100.00","");
INSERT INTO tbl_expensesde VALUES("1838","0","301","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1839","0","302","85","7300.00","");
INSERT INTO tbl_expensesde VALUES("1840","0","302","170","410.00","");
INSERT INTO tbl_expensesde VALUES("1841","0","302","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1842","0","302","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1843","0","302","85","8650.00","");
INSERT INTO tbl_expensesde VALUES("1844","0","302","149","120000.00","Rubel SIRAJGANJ");
INSERT INTO tbl_expensesde VALUES("1845","0","302","162","1100.00","");
INSERT INTO tbl_expensesde VALUES("1846","0","302","13","115.00","");
INSERT INTO tbl_expensesde VALUES("1847","0","302","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1848","0","302","157","40.00","");
INSERT INTO tbl_expensesde VALUES("1849","0","302","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1850","0","303","111","400.00","MONIR");
INSERT INTO tbl_expensesde VALUES("1851","0","303","170","550.00","TORKARI,KACAMARICH");
INSERT INTO tbl_expensesde VALUES("1852","0","303","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1853","0","303","86","3500.00","BONUS");
INSERT INTO tbl_expensesde VALUES("1854","0","303","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1855","0","303","86","9250.00","");
INSERT INTO tbl_expensesde VALUES("1856","0","303","157","220.00","");
INSERT INTO tbl_expensesde VALUES("1857","0","304","145","1000.00","KALAI KAJNA");
INSERT INTO tbl_expensesde VALUES("1858","0","305","87","600.00","2 দিনের হাজিরা");
INSERT INTO tbl_expensesde VALUES("1859","0","306","87","843.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("1860","0","306","111","1090.00","MNIR");
INSERT INTO tbl_expensesde VALUES("1861","0","306","85","5810.00","709");
INSERT INTO tbl_expensesde VALUES("1862","0","306","111","450.00","");
INSERT INTO tbl_expensesde VALUES("1863","0","306","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1864","0","306","167","2650.00","");
INSERT INTO tbl_expensesde VALUES("1865","0","306","164","18300.00","");
INSERT INTO tbl_expensesde VALUES("1866","0","306","170","400.00","EGG");
INSERT INTO tbl_expensesde VALUES("1867","0","306","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1868","0","306","164","16700.00","");
INSERT INTO tbl_expensesde VALUES("1869","0","306","170","100.00","JINNAT");
INSERT INTO tbl_expensesde VALUES("1870","0","306","103","500.00","DULAL MISTRI");
INSERT INTO tbl_expensesde VALUES("1871","0","306","103","140.00","MISTRI NASTA,VARA");
INSERT INTO tbl_expensesde VALUES("1872","0","307","86","7340.00","");
INSERT INTO tbl_expensesde VALUES("1873","0","307","92","260.00","");
INSERT INTO tbl_expensesde VALUES("1874","0","308","111","850.00","709");
INSERT INTO tbl_expensesde VALUES("1875","0","308","156","200.00","");
INSERT INTO tbl_expensesde VALUES("1876","0","308","171","200.00","");
INSERT INTO tbl_expensesde VALUES("1877","0","308","162","1250.00","");
INSERT INTO tbl_expensesde VALUES("1878","0","308","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("1879","0","308","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("1880","0","308","170","425.00","EGG,SALT");
INSERT INTO tbl_expensesde VALUES("1881","0","308","158","170.00","GOM");
INSERT INTO tbl_expensesde VALUES("1882","0","308","171","20.00","");
INSERT INTO tbl_expensesde VALUES("1883","0","308","103","88600.00","TYRE TAORUS");
INSERT INTO tbl_expensesde VALUES("1884","0","308","103","100.00","CAKKA MERAMAT");
INSERT INTO tbl_expensesde VALUES("1885","0","308","111","4360.00","TAORUS");
INSERT INTO tbl_expensesde VALUES("1886","0","308","144","400.00","");
INSERT INTO tbl_expensesde VALUES("1887","0","308","111","2100.00","ISMILE");
INSERT INTO tbl_expensesde VALUES("1888","0","308","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("1889","0","308","158","20.00","RASED");
INSERT INTO tbl_expensesde VALUES("1890","0","308","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1891","0","308","85","5010.00","");
INSERT INTO tbl_expensesde VALUES("1892","0","308","170","90.00","");
INSERT INTO tbl_expensesde VALUES("1893","0","308","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1894","0","309","87","1000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("1895","0","309","170","13500.00","CHAL");
INSERT INTO tbl_expensesde VALUES("1896","0","309","170","490.00","SALT");
INSERT INTO tbl_expensesde VALUES("1897","0","309","95","320.00","");
INSERT INTO tbl_expensesde VALUES("1898","0","309","157","50.00","");
INSERT INTO tbl_expensesde VALUES("1899","0","309","157","20.00","");
INSERT INTO tbl_expensesde VALUES("1900","0","310","87","8000.00","rajib");
INSERT INTO tbl_expensesde VALUES("1901","0","310","157","260.00","");
INSERT INTO tbl_expensesde VALUES("1902","0","310","86","14825.00","");
INSERT INTO tbl_expensesde VALUES("1903","0","311","103","50.00","BARA,KOEL");
INSERT INTO tbl_expensesde VALUES("1904","0","311","164","17400.00","");
INSERT INTO tbl_expensesde VALUES("1905","0","311","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("1906","0","311","158","40.00","RASED");
INSERT INTO tbl_expensesde VALUES("1907","0","311","103","130.00","VARA");
INSERT INTO tbl_expensesde VALUES("1908","0","311","27","650.00","");
INSERT INTO tbl_expensesde VALUES("1909","0","311","103","200.00","KAROSIN,OTHERS");
INSERT INTO tbl_expensesde VALUES("1910","0","311","103","50.00","BARA,BATTERY");
INSERT INTO tbl_expensesde VALUES("1911","0","311","158","70.00","RASED");
INSERT INTO tbl_expensesde VALUES("1912","0","311","103","700.00","GRIS,SILL");
INSERT INTO tbl_expensesde VALUES("1913","0","311","103","200.00","DULAL");
INSERT INTO tbl_expensesde VALUES("1914","0","311","170","530.00","EGG,TARKARI");
INSERT INTO tbl_expensesde VALUES("1915","0","312","87","1000.00","RIYAD");
INSERT INTO tbl_expensesde VALUES("1916","0","312","86","5060.00","");
INSERT INTO tbl_expensesde VALUES("1917","0","312","86","80.00","");
INSERT INTO tbl_expensesde VALUES("1918","0","313","85","4160.00","taorus");
INSERT INTO tbl_expensesde VALUES("1919","0","313","85","3440.00","tata");
INSERT INTO tbl_expensesde VALUES("1920","0","313","167","1400.00","");
INSERT INTO tbl_expensesde VALUES("1921","0","313","170","350.00","");
INSERT INTO tbl_expensesde VALUES("1922","0","313","170","3090.00","murgi dal");
INSERT INTO tbl_expensesde VALUES("1923","0","313","157","100.00","");
INSERT INTO tbl_expensesde VALUES("1924","0","313","156","320.00","");
INSERT INTO tbl_expensesde VALUES("1925","0","313","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1926","0","313","171","10.00","");
INSERT INTO tbl_expensesde VALUES("1927","0","313","157","100.00","");
INSERT INTO tbl_expensesde VALUES("1928","0","313","85","5660.00","709");
INSERT INTO tbl_expensesde VALUES("1929","0","314","87","2400.00","nirob");
INSERT INTO tbl_expensesde VALUES("1930","0","314","103","2010.00","ANAMUL");
INSERT INTO tbl_expensesde VALUES("1931","0","314","15","999.00","");
INSERT INTO tbl_expensesde VALUES("1932","0","314","103","1210.00","TATA");
INSERT INTO tbl_expensesde VALUES("1933","0","314","111","500.00","709");
INSERT INTO tbl_expensesde VALUES("1934","0","314","103","500.00","");
INSERT INTO tbl_expensesde VALUES("1935","0","315","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1936","0","315","91","60.00","");
INSERT INTO tbl_expensesde VALUES("1937","0","315","170","170.00","");
INSERT INTO tbl_expensesde VALUES("1938","0","315","170","120.00","");
INSERT INTO tbl_expensesde VALUES("1939","0","315","170","400.00","");
INSERT INTO tbl_expensesde VALUES("1940","0","315","170","200.00","");
INSERT INTO tbl_expensesde VALUES("1941","0","315","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1942","0","315","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1943","0","315","91","860.00","");
INSERT INTO tbl_expensesde VALUES("1944","0","315","111","5180.00","ISMILE");
INSERT INTO tbl_expensesde VALUES("1945","0","315","111","4360.00","SAGOR");
INSERT INTO tbl_expensesde VALUES("1946","0","315","91","860.00","");
INSERT INTO tbl_expensesde VALUES("1947","0","315","85","8700.00","TAORUSH");
INSERT INTO tbl_expensesde VALUES("1948","0","315","170","320.00","");
INSERT INTO tbl_expensesde VALUES("1949","0","315","157","280.00","");
INSERT INTO tbl_expensesde VALUES("1950","0","315","95","240.00","");
INSERT INTO tbl_expensesde VALUES("1951","0","315","158","10.00","");
INSERT INTO tbl_expensesde VALUES("1952","0","316","86","800.00","");
INSERT INTO tbl_expensesde VALUES("1953","0","316","158","300.00","");
INSERT INTO tbl_expensesde VALUES("1954","0","316","170","520.00","");
INSERT INTO tbl_expensesde VALUES("1955","0","316","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1956","0","316","158","300.00","");
INSERT INTO tbl_expensesde VALUES("1957","0","316","158","50.00","");
INSERT INTO tbl_expensesde VALUES("1958","0","316","164","18600.00","");
INSERT INTO tbl_expensesde VALUES("1959","0","316","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1960","0","316","170","120.00","");
INSERT INTO tbl_expensesde VALUES("1961","0","316","111","1950.00","");
INSERT INTO tbl_expensesde VALUES("1962","0","316","103","5100.00","1612");
INSERT INTO tbl_expensesde VALUES("1963","0","316","95","80.00","");
INSERT INTO tbl_expensesde VALUES("1964","0","316","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("1965","0","317","86","7750.00","");
INSERT INTO tbl_expensesde VALUES("1966","0","318","158","40.00","");
INSERT INTO tbl_expensesde VALUES("1967","0","318","27","45.00","");
INSERT INTO tbl_expensesde VALUES("1968","0","318","86","7790.00","");
INSERT INTO tbl_expensesde VALUES("1969","0","318","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1970","0","319","111","1050.00","709");
INSERT INTO tbl_expensesde VALUES("1971","0","319","19","60.00","");
INSERT INTO tbl_expensesde VALUES("1972","0","319","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1973","0","319","91","140.00","");
INSERT INTO tbl_expensesde VALUES("1974","0","320","170","580.00","TORKARI");
INSERT INTO tbl_expensesde VALUES("1975","0","320","87","2000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("1976","0","320","103","300.00","");
INSERT INTO tbl_expensesde VALUES("1977","0","321","109","1090.00","মুরগি");
INSERT INTO tbl_expensesde VALUES("1978","0","321","109","290.00","ভিমবার + জিরা");
INSERT INTO tbl_expensesde VALUES("1979","0","321","109","875.00","তেল");
INSERT INTO tbl_expensesde VALUES("1980","0","321","137","330.00","মছুনি");
INSERT INTO tbl_expensesde VALUES("1981","0","321","137","50.00","সাবান");
INSERT INTO tbl_expensesde VALUES("1982","0","321","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1983","0","321","92","180.00","");
INSERT INTO tbl_expensesde VALUES("1984","0","321","90","150.00","");
INSERT INTO tbl_expensesde VALUES("1985","0","321","85","9810.00","টাটা");
INSERT INTO tbl_expensesde VALUES("1986","0","321","129","50.00","জ্বালাই");
INSERT INTO tbl_expensesde VALUES("1987","0","321","87","7000.00","");
INSERT INTO tbl_expensesde VALUES("1988","0","321","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("1989","0","321","92","120.00","");
INSERT INTO tbl_expensesde VALUES("1990","0","321","137","150.00","বস্তা ক্রয়");
INSERT INTO tbl_expensesde VALUES("1991","0","321","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("1992","0","321","156","170.00","");
INSERT INTO tbl_expensesde VALUES("1993","0","321","103","7200.00","জগ ও অনন্য ");
INSERT INTO tbl_expensesde VALUES("1994","0","321","103","450.00","সাহারা মটরস");
INSERT INTO tbl_expensesde VALUES("1995","0","322","152","10.00","");
INSERT INTO tbl_expensesde VALUES("1996","0","322","158","20.00","");
INSERT INTO tbl_expensesde VALUES("1997","0","323","157","270.00","");
INSERT INTO tbl_expensesde VALUES("1998","0","323","158","10.00","");
INSERT INTO tbl_expensesde VALUES("1999","0","323","21","1505.00","");
INSERT INTO tbl_expensesde VALUES("2000","0","323","86","4390.00","");
INSERT INTO tbl_expensesde VALUES("2001","0","323","111","650.00","");
INSERT INTO tbl_expensesde VALUES("2002","0","324","137","1000.00","বাল্ব+ক্যাপাছিটার");
INSERT INTO tbl_expensesde VALUES("2003","0","324","137","200.00","হোল্ডার");
INSERT INTO tbl_expensesde VALUES("2004","0","325","111","5735.00","");
INSERT INTO tbl_expensesde VALUES("2005","0","325","87","100.00","");
INSERT INTO tbl_expensesde VALUES("2006","0","325","109","730.00","তরকারি+সাবান");
INSERT INTO tbl_expensesde VALUES("2007","0","325","92","40.00","+ভাড়া");
INSERT INTO tbl_expensesde VALUES("2008","0","325","85","3300.00","");
INSERT INTO tbl_expensesde VALUES("2009","0","325","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2010","0","325","85","5450.00","709");
INSERT INTO tbl_expensesde VALUES("2011","0","325","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2012","0","325","109","220.00","মুগ ডাল");
INSERT INTO tbl_expensesde VALUES("2013","0","326","19","40.00","");
INSERT INTO tbl_expensesde VALUES("2014","0","326","20","440.00","");
INSERT INTO tbl_expensesde VALUES("2015","0","326","20","950.00","TALI KTATA");
INSERT INTO tbl_expensesde VALUES("2016","0","326","103","200.00","DULAL");
INSERT INTO tbl_expensesde VALUES("2017","0","326","87","400.00","");
INSERT INTO tbl_expensesde VALUES("2018","0","326","156","100.00","");
INSERT INTO tbl_expensesde VALUES("2019","0","326","111","400.00","709");
INSERT INTO tbl_expensesde VALUES("2020","0","326","156","100.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2021","0","326","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2022","0","326","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2023","0","326","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2024","0","326","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2025","0","326","91","140.00","");
INSERT INTO tbl_expensesde VALUES("2026","0","326","27","300.00","");
INSERT INTO tbl_expensesde VALUES("2027","0","326","23","750.00","RIYAD");
INSERT INTO tbl_expensesde VALUES("2028","0","326","27","30.00","");
INSERT INTO tbl_expensesde VALUES("2029","0","327","170","500.00","TORKARI");
INSERT INTO tbl_expensesde VALUES("2030","0","327","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2031","0","327","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("2032","0","327","86","5980.00","");
INSERT INTO tbl_expensesde VALUES("2033","0","328","87","1000.00","RIYAD");
INSERT INTO tbl_expensesde VALUES("2034","0","329","157","60.00","");
INSERT INTO tbl_expensesde VALUES("2035","0","330","149","5110.00","SWING MACHINE");
INSERT INTO tbl_expensesde VALUES("2036","0","330","158","60.00","");
INSERT INTO tbl_expensesde VALUES("2037","0","330","103","70.00","");
INSERT INTO tbl_expensesde VALUES("2038","0","330","170","380.00","");
INSERT INTO tbl_expensesde VALUES("2039","0","330","170","20.00","");
INSERT INTO tbl_expensesde VALUES("2040","0","330","103","500.00","FAHAD");
INSERT INTO tbl_expensesde VALUES("2041","0","330","105","800.00","");
INSERT INTO tbl_expensesde VALUES("2042","0","330","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2043","0","330","171","20.00","");
INSERT INTO tbl_expensesde VALUES("2044","0","330","156","170.00","");
INSERT INTO tbl_expensesde VALUES("2045","0","330","27","40.00","");
INSERT INTO tbl_expensesde VALUES("2046","0","330","85","5000.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2047","0","330","44","100.00","");
INSERT INTO tbl_expensesde VALUES("2048","0","330","171","20.00","");
INSERT INTO tbl_expensesde VALUES("2049","0","331","87","112840.00","");
INSERT INTO tbl_expensesde VALUES("2050","0","332","103","600.00","SILL");
INSERT INTO tbl_expensesde VALUES("2051","0","332","103","1210.00","NOJEL");
INSERT INTO tbl_expensesde VALUES("2052","0","332","86","6550.00","");
INSERT INTO tbl_expensesde VALUES("2053","0","332","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2054","0","332","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2055","0","332","144","5600.00","");
INSERT INTO tbl_expensesde VALUES("2056","0","332","87","14000.00","BASIR");
INSERT INTO tbl_expensesde VALUES("2057","0","332","27","40.00","");
INSERT INTO tbl_expensesde VALUES("2058","0","332","158","30.00","");
INSERT INTO tbl_expensesde VALUES("2059","0","332","167","450.00","");
INSERT INTO tbl_expensesde VALUES("2060","0","332","167","100.00","");
INSERT INTO tbl_expensesde VALUES("2061","0","333","87","16500.00","");
INSERT INTO tbl_expensesde VALUES("2062","0","333","87","4500.00","SHOHEL");
INSERT INTO tbl_expensesde VALUES("2063","0","333","158","300.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("2064","0","333","158","20.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("2065","0","333","170","1300.00","OIL,MURGI,MASLA");
INSERT INTO tbl_expensesde VALUES("2066","0","334","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2067","0","334","86","1080.00","");
INSERT INTO tbl_expensesde VALUES("2068","0","334","86","120.00","");
INSERT INTO tbl_expensesde VALUES("2069","0","334","87","870.00","MOSAFIZ");
INSERT INTO tbl_expensesde VALUES("2070","0","335","87","7900.00","ISMALE");
INSERT INTO tbl_expensesde VALUES("2071","0","336","109","340.00","");
INSERT INTO tbl_expensesde VALUES("2072","0","337","86","280.00","");
INSERT INTO tbl_expensesde VALUES("2073","0","337","149","120.00","");
INSERT INTO tbl_expensesde VALUES("2074","0","337","82","120.00","");
INSERT INTO tbl_expensesde VALUES("2075","0","337","171","30.00","");
INSERT INTO tbl_expensesde VALUES("2076","0","337","170","1230.00","");
INSERT INTO tbl_expensesde VALUES("2077","0","337","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2078","0","337","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2079","0","337","20","10.00","");
INSERT INTO tbl_expensesde VALUES("2080","0","337","87","3500.00","amdad");
INSERT INTO tbl_expensesde VALUES("2081","0","337","158","90.00","");
INSERT INTO tbl_expensesde VALUES("2082","0","337","158","40.00","salauddin");
INSERT INTO tbl_expensesde VALUES("2083","0","338","87","7500.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2084","0","338","159","900.00","NOCIMON VARA");
INSERT INTO tbl_expensesde VALUES("2085","0","338","158","40.00","NASTA+VARA");
INSERT INTO tbl_expensesde VALUES("2086","0","338","27","45.00","");
INSERT INTO tbl_expensesde VALUES("2087","0","338","157","300.00","");
INSERT INTO tbl_expensesde VALUES("2088","0","338","97","80.00","");
INSERT INTO tbl_expensesde VALUES("2089","0","338","91","110.00","");
INSERT INTO tbl_expensesde VALUES("2090","0","338","87","400.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("2091","0","338","171","200.00","");
INSERT INTO tbl_expensesde VALUES("2092","0","338","86","3160.00","");
INSERT INTO tbl_expensesde VALUES("2093","0","338","86","120.00","");
INSERT INTO tbl_expensesde VALUES("2094","0","339","87","7000.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("2095","0","340","85","9520.00","টাটা");
INSERT INTO tbl_expensesde VALUES("2096","0","340","93","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2097","0","340","93","100.00","নাস্তা");
INSERT INTO tbl_expensesde VALUES("2098","0","340","111","8275.00","");
INSERT INTO tbl_expensesde VALUES("2099","0","340","91","860.00","");
INSERT INTO tbl_expensesde VALUES("2100","0","340","87","8500.00","");
INSERT INTO tbl_expensesde VALUES("2101","0","340","137","500.00","সাগর গোসাইরহাট");
INSERT INTO tbl_expensesde VALUES("2102","0","340","87","4500.00","");
INSERT INTO tbl_expensesde VALUES("2103","0","340","109","370.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2104","0","340","109","150.00","কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("2105","0","340","103","250.00","লুকিং গ্লাস");
INSERT INTO tbl_expensesde VALUES("2106","0","340","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2107","0","341","152","10.00","");
INSERT INTO tbl_expensesde VALUES("2108","0","341","87","200.00","");
INSERT INTO tbl_expensesde VALUES("2109","0","341","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("2110","0","341","160","300.00","");
INSERT INTO tbl_expensesde VALUES("2111","0","342","162","1000.00","");
INSERT INTO tbl_expensesde VALUES("2112","0","342","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2113","0","342","27","100.00","");
INSERT INTO tbl_expensesde VALUES("2114","0","343","87","1000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("2115","0","343","144","6300.00","");
INSERT INTO tbl_expensesde VALUES("2116","0","343","158","10.00","");
INSERT INTO tbl_expensesde VALUES("2117","0","343","27","150.00","SUTLI");
INSERT INTO tbl_expensesde VALUES("2118","0","343","157","200.00","");
INSERT INTO tbl_expensesde VALUES("2119","0","343","95","240.00","");
INSERT INTO tbl_expensesde VALUES("2120","0","343","87","1000.00","KAMAL");
INSERT INTO tbl_expensesde VALUES("2121","0","343","111","1050.00","709");
INSERT INTO tbl_expensesde VALUES("2122","0","343","149","5000.00","");
INSERT INTO tbl_expensesde VALUES("2123","0","343","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2124","0","343","157","300.00","");
INSERT INTO tbl_expensesde VALUES("2125","0","344","109","440.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2126","0","344","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("2127","0","344","15","50.00","");
INSERT INTO tbl_expensesde VALUES("2128","0","344","109","370.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2129","0","344","109","380.00","রসুন+কাচা মরিচ+শুকনা মরিচ");
INSERT INTO tbl_expensesde VALUES("2130","0","344","111","4535.00","");
INSERT INTO tbl_expensesde VALUES("2131","0","344","93","50.00","");
INSERT INTO tbl_expensesde VALUES("2132","0","344","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2133","0","344","93","40.00","");
INSERT INTO tbl_expensesde VALUES("2134","0","344","158","100.00","");
INSERT INTO tbl_expensesde VALUES("2135","0","344","137","1000.00","ওয়াইফাই বিল");
INSERT INTO tbl_expensesde VALUES("2136","0","344","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2137","0","344","90","890.00","পাইপ ");
INSERT INTO tbl_expensesde VALUES("2138","0","344","90","20.00","");
INSERT INTO tbl_expensesde VALUES("2139","0","344","145","3000.00","");
INSERT INTO tbl_expensesde VALUES("2140","0","344","137","300.00","ট্রেড লাইসেন্স");
INSERT INTO tbl_expensesde VALUES("2141","0","344","137","40.00","ফটোকপি");
INSERT INTO tbl_expensesde VALUES("2142","0","345","149","80000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("2143","0","345","156","100.00","");
INSERT INTO tbl_expensesde VALUES("2144","0","345","156","160.00","");
INSERT INTO tbl_expensesde VALUES("2145","0","346","95","80.00","");
INSERT INTO tbl_expensesde VALUES("2146","0","346","170","630.00","");
INSERT INTO tbl_expensesde VALUES("2147","0","346","82","140.00","");
INSERT INTO tbl_expensesde VALUES("2148","0","346","103","2720.00","GODI MERAMAT");
INSERT INTO tbl_expensesde VALUES("2149","0","346","87","600.00","");
INSERT INTO tbl_expensesde VALUES("2150","0","346","86","5310.00","");
INSERT INTO tbl_expensesde VALUES("2151","0","346","179","470.00","LEABOUR");
INSERT INTO tbl_expensesde VALUES("2152","0","347","170","9940.00","ALU PIAZ,VARA");
INSERT INTO tbl_expensesde VALUES("2153","0","347","27","120.00","CAP");
INSERT INTO tbl_expensesde VALUES("2154","0","347","85","8750.00","");
INSERT INTO tbl_expensesde VALUES("2155","0","347","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2156","0","347","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("2157","0","347","85","5000.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2158","0","347","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2159","0","348","170","2220.00","OIL,EGG,MURGI,MASLLA");
INSERT INTO tbl_expensesde VALUES("2160","0","348","164","17500.00","");
INSERT INTO tbl_expensesde VALUES("2161","0","348","87","1000.00","SHOHRAB");
INSERT INTO tbl_expensesde VALUES("2162","0","348","87","2000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("2163","0","348","158","600.00","OMS HANIF");
INSERT INTO tbl_expensesde VALUES("2164","0","349","149","3700.00","SWEING MACHIN MERAMAT");
INSERT INTO tbl_expensesde VALUES("2165","0","349","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("2166","0","349","87","900.00","3 DIN /BASHIR");
INSERT INTO tbl_expensesde VALUES("2167","0","349","156","170.00","709");
INSERT INTO tbl_expensesde VALUES("2168","0","349","161","430.00","");
INSERT INTO tbl_expensesde VALUES("2169","0","350","111","1050.00","709");
INSERT INTO tbl_expensesde VALUES("2170","0","350","171","50.00","");
INSERT INTO tbl_expensesde VALUES("2171","0","350","87","28000.00","");
INSERT INTO tbl_expensesde VALUES("2172","0","350","86","6530.00","");
INSERT INTO tbl_expensesde VALUES("2173","0","350","158","10.00","");
INSERT INTO tbl_expensesde VALUES("2174","0","350","82","2000.00","hira");
INSERT INTO tbl_expensesde VALUES("2175","0","350","157","300.00","");
INSERT INTO tbl_expensesde VALUES("2176","0","350","87","300.00","");
INSERT INTO tbl_expensesde VALUES("2177","0","350","156","20.00","");
INSERT INTO tbl_expensesde VALUES("2178","0","350","19","65.00","");
INSERT INTO tbl_expensesde VALUES("2179","0","350","27","150.00","");
INSERT INTO tbl_expensesde VALUES("2180","0","351","109","420.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2181","0","351","156","160.00","");
INSERT INTO tbl_expensesde VALUES("2182","0","351","111","4450.00","");
INSERT INTO tbl_expensesde VALUES("2183","0","351","103","370.00","টাটা গাড়ির কাজ মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("2184","0","351","109","370.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2185","0","351","109","300.00","কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("2186","0","351","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2187","0","351","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("2188","0","351","103","180.00","মবিল ফিল্টার +হাওয়া");
INSERT INTO tbl_expensesde VALUES("2189","0","351","137","400.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2190","0","351","109","110.00","শাক");
INSERT INTO tbl_expensesde VALUES("2191","0","351","138","1900.00","");
INSERT INTO tbl_expensesde VALUES("2192","0","351","156","100.00","");
INSERT INTO tbl_expensesde VALUES("2193","0","352","107","40.00","");
INSERT INTO tbl_expensesde VALUES("2194","0","352","145","10000.00","");
INSERT INTO tbl_expensesde VALUES("2195","0","353","27","100.00","");
INSERT INTO tbl_expensesde VALUES("2196","0","353","23","400.00","vara");
INSERT INTO tbl_expensesde VALUES("2197","0","353","103","400.00","dulal mistri,malal babod");
INSERT INTO tbl_expensesde VALUES("2198","0","353","103","400.00","dulal mistri,malal babod");
INSERT INTO tbl_expensesde VALUES("2199","0","353","170","350.00","");
INSERT INTO tbl_expensesde VALUES("2200","0","353","86","7230.00","");
INSERT INTO tbl_expensesde VALUES("2201","0","354","27","45.00","");
INSERT INTO tbl_expensesde VALUES("2202","0","354","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2203","0","354","157","260.00","");
INSERT INTO tbl_expensesde VALUES("2204","0","354","87","300.00","");
INSERT INTO tbl_expensesde VALUES("2205","0","354","87","4000.00","sagor");
INSERT INTO tbl_expensesde VALUES("2206","0","354","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2207","0","355","152","50.00","");
INSERT INTO tbl_expensesde VALUES("2208","0","355","109","370.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2209","0","356","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2210","0","356","87","9000.00","");
INSERT INTO tbl_expensesde VALUES("2211","0","356","87","9000.00","SAHADAT");
INSERT INTO tbl_expensesde VALUES("2212","0","356","157","240.00","");
INSERT INTO tbl_expensesde VALUES("2213","0","356","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2214","0","357","87","500.00","RIYAD");
INSERT INTO tbl_expensesde VALUES("2215","0","357","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2216","0","357","111","600.00","");
INSERT INTO tbl_expensesde VALUES("2217","0","357","111","450.00","");
INSERT INTO tbl_expensesde VALUES("2218","0","357","157","260.00","");
INSERT INTO tbl_expensesde VALUES("2219","0","357","86","300.00","");
INSERT INTO tbl_expensesde VALUES("2220","0","357","27","40.00","");
INSERT INTO tbl_expensesde VALUES("2221","0","357","86","4980.00","");
INSERT INTO tbl_expensesde VALUES("2222","0","358","87","5000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("2223","0","358","170","400.00","");
INSERT INTO tbl_expensesde VALUES("2224","0","358","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2225","0","358","158","10.00","");
INSERT INTO tbl_expensesde VALUES("2226","0","358","85","4000.00","709");
INSERT INTO tbl_expensesde VALUES("2227","0","358","170","450.00","TORKARY");
INSERT INTO tbl_expensesde VALUES("2228","0","358","86","3165.00","");
INSERT INTO tbl_expensesde VALUES("2229","0","358","103","200.00","MISTRI");
INSERT INTO tbl_expensesde VALUES("2230","0","358","103","330.00","");
INSERT INTO tbl_expensesde VALUES("2231","0","358","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2232","0","358","87","200.00","SALAUDDIN");
INSERT INTO tbl_expensesde VALUES("2233","0","358","82","130.00","");
INSERT INTO tbl_expensesde VALUES("2234","0","358","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2235","0","358","91","530.00","");
INSERT INTO tbl_expensesde VALUES("2236","0","358","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2237","0","358","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2238","0","359","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2239","0","359","105","13120.00","");
INSERT INTO tbl_expensesde VALUES("2240","0","359","27","50.00","");
INSERT INTO tbl_expensesde VALUES("2241","0","359","158","30.00","");
INSERT INTO tbl_expensesde VALUES("2242","0","359","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2243","0","359","85","18100.00","");
INSERT INTO tbl_expensesde VALUES("2244","0","359","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("2245","0","359","144","4200.00","");
INSERT INTO tbl_expensesde VALUES("2246","0","359","171","10.00","");
INSERT INTO tbl_expensesde VALUES("2247","0","359","170","120.00","");
INSERT INTO tbl_expensesde VALUES("2248","0","359","170","876.00","");
INSERT INTO tbl_expensesde VALUES("2249","0","359","170","360.00","egg");
INSERT INTO tbl_expensesde VALUES("2250","0","359","170","200.00","");
INSERT INTO tbl_expensesde VALUES("2251","0","359","157","80.00","");
INSERT INTO tbl_expensesde VALUES("2252","0","360","86","8260.00","");
INSERT INTO tbl_expensesde VALUES("2253","0","360","158","100.00","");
INSERT INTO tbl_expensesde VALUES("2254","0","360","160","200.00","");
INSERT INTO tbl_expensesde VALUES("2255","0","360","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2256","0","360","82","30.00","");
INSERT INTO tbl_expensesde VALUES("2257","0","361","15","379.00","");
INSERT INTO tbl_expensesde VALUES("2258","0","361","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2259","0","361","150","400.00","কাটিং পাথর+ওয়ালিং রড");
INSERT INTO tbl_expensesde VALUES("2260","0","362","109","720.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2261","0","362","109","180.00","রসুন");
INSERT INTO tbl_expensesde VALUES("2262","0","362","85","5010.00","");
INSERT INTO tbl_expensesde VALUES("2263","0","362","87","4565.00","");
INSERT INTO tbl_expensesde VALUES("2264","0","362","145","2500.00","বাসার মটরের কাজ বাবদ");
INSERT INTO tbl_expensesde VALUES("2265","0","362","150","2500.00","মিলের প্যানেল বোর্ডর কাজ");
INSERT INTO tbl_expensesde VALUES("2266","0","362","152","40.00","");
INSERT INTO tbl_expensesde VALUES("2267","0","362","164","18100.00","");
INSERT INTO tbl_expensesde VALUES("2268","0","362","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("2269","0","362","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2270","0","363","111","950.00","");
INSERT INTO tbl_expensesde VALUES("2271","0","363","87","100.00","KAIUM");
INSERT INTO tbl_expensesde VALUES("2272","0","363","103","5500.00","TARBU MARAMAT");
INSERT INTO tbl_expensesde VALUES("2273","0","363","103","600.00","STICK");
INSERT INTO tbl_expensesde VALUES("2274","0","363","103","800.00","");
INSERT INTO tbl_expensesde VALUES("2275","0","363","15","80.00","");
INSERT INTO tbl_expensesde VALUES("2276","0","363","144","4200.00","");
INSERT INTO tbl_expensesde VALUES("2277","0","363","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2278","0","363","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("2279","0","364","167","3250.00","");
INSERT INTO tbl_expensesde VALUES("2280","0","364","156","170.00","");
INSERT INTO tbl_expensesde VALUES("2281","0","364","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2282","0","364","95","240.00","");
INSERT INTO tbl_expensesde VALUES("2283","0","364","111","1050.00","709");
INSERT INTO tbl_expensesde VALUES("2284","0","364","111","400.00","monir");
INSERT INTO tbl_expensesde VALUES("2285","0","364","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2286","0","364","149","600.00","");
INSERT INTO tbl_expensesde VALUES("2287","0","364","27","300.00","");
INSERT INTO tbl_expensesde VALUES("2288","0","364","170","620.00","");
INSERT INTO tbl_expensesde VALUES("2289","0","364","86","11230.00","");
INSERT INTO tbl_expensesde VALUES("2290","0","364","158","10.00","");
INSERT INTO tbl_expensesde VALUES("2291","0","364","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2292","0","365","86","120.00","");
INSERT INTO tbl_expensesde VALUES("2293","0","365","87","550.00","NIAZ");
INSERT INTO tbl_expensesde VALUES("2294","0","365","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2295","0","365","170","225.00","");
INSERT INTO tbl_expensesde VALUES("2296","0","365","27","70.00","");
INSERT INTO tbl_expensesde VALUES("2297","0","365","149","280.00","");
INSERT INTO tbl_expensesde VALUES("2298","0","365","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2299","0","365","87","200.00","RASED");
INSERT INTO tbl_expensesde VALUES("2300","0","365","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2301","0","365","158","845.00","OMS");
INSERT INTO tbl_expensesde VALUES("2302","0","365","162","1200.00","");
INSERT INTO tbl_expensesde VALUES("2303","0","365","170","60.00","");
INSERT INTO tbl_expensesde VALUES("2304","0","365","87","81460.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("2305","0","365","85","6010.00","709");
INSERT INTO tbl_expensesde VALUES("2306","0","365","27","10.00","");
INSERT INTO tbl_expensesde VALUES("2307","0","365","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2308","0","365","170","100.00","");
INSERT INTO tbl_expensesde VALUES("2309","0","365","144","10100.00","");
INSERT INTO tbl_expensesde VALUES("2310","0","366","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2311","0","366","87","530.00","");
INSERT INTO tbl_expensesde VALUES("2312","0","366","170","100.00","");
INSERT INTO tbl_expensesde VALUES("2313","0","366","171","300.00","");
INSERT INTO tbl_expensesde VALUES("2314","0","366","86","8070.00","");
INSERT INTO tbl_expensesde VALUES("2315","0","366","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2316","0","367","109","500.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2317","0","367","93","100.00","");
INSERT INTO tbl_expensesde VALUES("2318","0","367","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2319","0","367","111","1000.00","");
INSERT INTO tbl_expensesde VALUES("2320","0","367","109","1235.00","ডিম +তেল");
INSERT INTO tbl_expensesde VALUES("2321","0","367","137","90.00","বাটি");
INSERT INTO tbl_expensesde VALUES("2322","0","367","109","1030.00","মুরগি");
INSERT INTO tbl_expensesde VALUES("2323","0","367","150","1470.00","গ্রিজ+নাট বল্টু");
INSERT INTO tbl_expensesde VALUES("2324","0","367","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2325","0","368","109","60.00","মসলা");
INSERT INTO tbl_expensesde VALUES("2326","0","369","160","20.00","");
INSERT INTO tbl_expensesde VALUES("2327","0","369","150","7600.00","প্লেন সিট");
INSERT INTO tbl_expensesde VALUES("2328","0","369","150","610.00","গুনা+জি আই");
INSERT INTO tbl_expensesde VALUES("2329","0","369","137","120.00","নাইট কয়েল");
INSERT INTO tbl_expensesde VALUES("2330","0","369","152","10.00","");
INSERT INTO tbl_expensesde VALUES("2331","0","369","137","265.00","ডিটারজেন্ট");
INSERT INTO tbl_expensesde VALUES("2332","0","369","109","40.00","লবন");
INSERT INTO tbl_expensesde VALUES("2333","0","369","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2334","0","369","87","300.00","");
INSERT INTO tbl_expensesde VALUES("2335","0","369","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2336","0","370","86","9730.00","");
INSERT INTO tbl_expensesde VALUES("2337","0","370","157","270.00","NASTA");
INSERT INTO tbl_expensesde VALUES("2338","0","370","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2339","0","370","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2340","0","370","87","2000.00","SALAUDDIN");
INSERT INTO tbl_expensesde VALUES("2341","0","370","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2342","0","370","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2343","0","370","144","6000.00","");
INSERT INTO tbl_expensesde VALUES("2344","0","371","170","120.00","");
INSERT INTO tbl_expensesde VALUES("2345","0","371","89","12000.00","");
INSERT INTO tbl_expensesde VALUES("2346","0","371","165","690.00","");
INSERT INTO tbl_expensesde VALUES("2347","0","371","165","1830.00","");
INSERT INTO tbl_expensesde VALUES("2348","0","372","170","600.00","");
INSERT INTO tbl_expensesde VALUES("2349","0","373","170","200.00","");
INSERT INTO tbl_expensesde VALUES("2350","0","373","158","60.00","");
INSERT INTO tbl_expensesde VALUES("2351","0","373","111","1750.00","");
INSERT INTO tbl_expensesde VALUES("2352","0","373","158","810.00","oms");
INSERT INTO tbl_expensesde VALUES("2353","0","373","162","500.00","");
INSERT INTO tbl_expensesde VALUES("2354","0","373","165","900.00","bettery");
INSERT INTO tbl_expensesde VALUES("2355","0","373","158","30.00","");
INSERT INTO tbl_expensesde VALUES("2356","0","373","171","20.00","");
INSERT INTO tbl_expensesde VALUES("2357","0","374","23","2000.00","");
INSERT INTO tbl_expensesde VALUES("2358","0","375","162","500.00","");
INSERT INTO tbl_expensesde VALUES("2359","0","375","27","50.00","");
INSERT INTO tbl_expensesde VALUES("2360","0","376","164","19300.00","");
INSERT INTO tbl_expensesde VALUES("2361","0","376","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2362","0","376","160","300.00","");
INSERT INTO tbl_expensesde VALUES("2363","0","376","170","1700.00","fish");
INSERT INTO tbl_expensesde VALUES("2364","0","376","171","40.00","");
INSERT INTO tbl_expensesde VALUES("2365","0","376","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2366","0","376","173","4560.00","");
INSERT INTO tbl_expensesde VALUES("2367","0","377","149","1000.00","net oarlin");
INSERT INTO tbl_expensesde VALUES("2368","0","377","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2369","0","377","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2370","0","377","103","1520.00","");
INSERT INTO tbl_expensesde VALUES("2371","0","377","103","2200.00","");
INSERT INTO tbl_expensesde VALUES("2372","0","377","103","1500.00","");
INSERT INTO tbl_expensesde VALUES("2373","0","377","157","90.00","");
INSERT INTO tbl_expensesde VALUES("2374","0","377","87","3000.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("2375","0","377","170","560.00","");
INSERT INTO tbl_expensesde VALUES("2376","0","377","170","560.00","");
INSERT INTO tbl_expensesde VALUES("2377","0","377","111","550.00","");
INSERT INTO tbl_expensesde VALUES("2378","0","377","86","10340.00","");
INSERT INTO tbl_expensesde VALUES("2379","0","377","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2380","0","378","111","50.00","");
INSERT INTO tbl_expensesde VALUES("2381","0","378","109","420.00","কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("2382","0","378","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2383","0","378","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("2384","0","378","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2385","0","378","109","360.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2386","0","378","111","40.00","");
INSERT INTO tbl_expensesde VALUES("2387","0","378","103","120.00","চাক্কা হাওয়া");
INSERT INTO tbl_expensesde VALUES("2388","0","378","85","6010.00","709");
INSERT INTO tbl_expensesde VALUES("2389","0","378","85","10000.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("2390","0","378","85","5010.00","মনির");
INSERT INTO tbl_expensesde VALUES("2391","0","378","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2392","0","379","158","10.00","");
INSERT INTO tbl_expensesde VALUES("2393","0","379","137","30.00","পানি");
INSERT INTO tbl_expensesde VALUES("2394","0","380","170","360.00","");
INSERT INTO tbl_expensesde VALUES("2395","0","380","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2396","0","380","160","20.00","");
INSERT INTO tbl_expensesde VALUES("2397","0","380","87","11000.00","SALAUDDIN");
INSERT INTO tbl_expensesde VALUES("2398","0","380","87","500.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2399","0","380","87","11000.00","SOHRAB");
INSERT INTO tbl_expensesde VALUES("2400","0","380","157","160.00","");
INSERT INTO tbl_expensesde VALUES("2401","0","380","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2402","0","380","27","2200.00","");
INSERT INTO tbl_expensesde VALUES("2403","0","380","27","250.00","");
INSERT INTO tbl_expensesde VALUES("2404","0","381","111","20.00","");
INSERT INTO tbl_expensesde VALUES("2405","0","381","103","100.00","DULAL");
INSERT INTO tbl_expensesde VALUES("2406","0","381","89","9000.00","");
INSERT INTO tbl_expensesde VALUES("2407","0","381","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2408","0","381","157","230.00","");
INSERT INTO tbl_expensesde VALUES("2409","0","381","157","230.00","");
INSERT INTO tbl_expensesde VALUES("2410","0","381","86","7770.00","");
INSERT INTO tbl_expensesde VALUES("2411","0","381","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("2412","0","382","173","4560.00","");
INSERT INTO tbl_expensesde VALUES("2413","0","383","15","5.00","");
INSERT INTO tbl_expensesde VALUES("2414","0","384","15","379.00","");
INSERT INTO tbl_expensesde VALUES("2415","0","384","170","545.00","");
INSERT INTO tbl_expensesde VALUES("2416","0","384","159","650.00","");
INSERT INTO tbl_expensesde VALUES("2417","0","384","170","6860.00","");
INSERT INTO tbl_expensesde VALUES("2418","0","384","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2419","0","384","158","70.00","");
INSERT INTO tbl_expensesde VALUES("2420","0","384","170","300.00","");
INSERT INTO tbl_expensesde VALUES("2421","0","384","87","500.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2422","0","384","170","450.00","");
INSERT INTO tbl_expensesde VALUES("2423","0","384","86","1790.00","");
INSERT INTO tbl_expensesde VALUES("2424","0","385","171","10.00","");
INSERT INTO tbl_expensesde VALUES("2425","0","385","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2426","0","385","170","470.00","");
INSERT INTO tbl_expensesde VALUES("2427","0","385","19","50.00","");
INSERT INTO tbl_expensesde VALUES("2428","0","385","160","140.00","POLI");
INSERT INTO tbl_expensesde VALUES("2429","0","385","170","5200.00","VAN VARA,KAT VANGA");
INSERT INTO tbl_expensesde VALUES("2430","0","385","170","5200.00","VAN VARA,KAT VANGA");
INSERT INTO tbl_expensesde VALUES("2431","0","385","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2432","0","386","87","5000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("2433","0","386","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2434","0","386","157","250.00","");
INSERT INTO tbl_expensesde VALUES("2435","0","386","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2436","0","386","95","80.00","");
INSERT INTO tbl_expensesde VALUES("2437","0","386","165","800.00","");
INSERT INTO tbl_expensesde VALUES("2438","0","386","27","560.00","");
INSERT INTO tbl_expensesde VALUES("2439","0","386","170","60.00","");
INSERT INTO tbl_expensesde VALUES("2440","0","386","27","90.00","");
INSERT INTO tbl_expensesde VALUES("2441","0","386","111","6200.00","");
INSERT INTO tbl_expensesde VALUES("2442","0","386","157","140.00","");
INSERT INTO tbl_expensesde VALUES("2443","0","386","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2444","0","386","157","260.00","");
INSERT INTO tbl_expensesde VALUES("2445","0","386","86","300.00","");
INSERT INTO tbl_expensesde VALUES("2446","0","386","86","6606.00","");
INSERT INTO tbl_expensesde VALUES("2447","0","387","87","3000.00","SHOHRAB");
INSERT INTO tbl_expensesde VALUES("2448","0","387","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2449","0","387","86","60.00","");
INSERT INTO tbl_expensesde VALUES("2450","0","387","19","135.00","");
INSERT INTO tbl_expensesde VALUES("2451","0","387","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2452","0","387","15","379.00","");
INSERT INTO tbl_expensesde VALUES("2453","0","387","164","18300.00","");
INSERT INTO tbl_expensesde VALUES("2454","0","387","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2455","0","387","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2456","0","387","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2457","0","387","111","1250.00","");
INSERT INTO tbl_expensesde VALUES("2458","0","387","170","420.00","MURGI,MASLA");
INSERT INTO tbl_expensesde VALUES("2459","0","387","86","7350.00","");
INSERT INTO tbl_expensesde VALUES("2460","0","387","15","5.00","");
INSERT INTO tbl_expensesde VALUES("2461","0","387","111","10840.00","");
INSERT INTO tbl_expensesde VALUES("2462","0","388","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2463","0","388","158","120.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2464","0","388","137","45.00","কয়েল");
INSERT INTO tbl_expensesde VALUES("2465","0","388","146","1450.00","");
INSERT INTO tbl_expensesde VALUES("2466","0","388","173","800.00","সর্দারকে প্রদান");
INSERT INTO tbl_expensesde VALUES("2467","0","388","109","2020.00","হলুদের গুরা+ডিম+ডাল+তেল");
INSERT INTO tbl_expensesde VALUES("2468","0","388","158","270.00","");
INSERT INTO tbl_expensesde VALUES("2469","0","388","159","3200.00","");
INSERT INTO tbl_expensesde VALUES("2470","0","388","137","590.00","সুতলি+কলম");
INSERT INTO tbl_expensesde VALUES("2471","0","388","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2472","0","389","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2473","0","389","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2474","0","389","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("2475","0","389","87","6915.00","");
INSERT INTO tbl_expensesde VALUES("2476","0","389","87","200.00","");
INSERT INTO tbl_expensesde VALUES("2477","0","389","104","200.00","ক্যাশ মেমো");
INSERT INTO tbl_expensesde VALUES("2478","0","389","138","5100.00","");
INSERT INTO tbl_expensesde VALUES("2479","0","389","109","500.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2480","0","389","107","260.00","");
INSERT INTO tbl_expensesde VALUES("2481","0","389","106","3660.00","");
INSERT INTO tbl_expensesde VALUES("2482","0","389","87","6000.00","");
INSERT INTO tbl_expensesde VALUES("2483","0","389","87","600.00","");
INSERT INTO tbl_expensesde VALUES("2484","0","389","90","120.00","");
INSERT INTO tbl_expensesde VALUES("2485","0","389","85","4350.00","টাটা");
INSERT INTO tbl_expensesde VALUES("2486","0","389","111","650.00","");
INSERT INTO tbl_expensesde VALUES("2487","0","389","109","780.00","ডিম");
INSERT INTO tbl_expensesde VALUES("2488","0","389","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2489","0","389","87","6765.00","");
INSERT INTO tbl_expensesde VALUES("2490","0","389","85","7800.00","");
INSERT INTO tbl_expensesde VALUES("2491","0","389","109","120.00","শাক");
INSERT INTO tbl_expensesde VALUES("2492","0","389","137","60.00","কেক");
INSERT INTO tbl_expensesde VALUES("2493","0","390","87","144560.00","");
INSERT INTO tbl_expensesde VALUES("2494","0","390","158","40.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2495","0","390","158","150.00","");
INSERT INTO tbl_expensesde VALUES("2496","0","390","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("2497","0","390","137","150.00","ক্যাশ মেমো");
INSERT INTO tbl_expensesde VALUES("2498","0","390","160","150.00","");
INSERT INTO tbl_expensesde VALUES("2499","0","390","92","300.00","");
INSERT INTO tbl_expensesde VALUES("2500","0","390","86","6475.00","");
INSERT INTO tbl_expensesde VALUES("2501","0","390","86","5000.00","");
INSERT INTO tbl_expensesde VALUES("2502","0","390","87","1800.00","");
INSERT INTO tbl_expensesde VALUES("2503","0","390","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2504","0","390","87","1800.00","");
INSERT INTO tbl_expensesde VALUES("2505","0","391","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2506","0","391","111","1300.00","");
INSERT INTO tbl_expensesde VALUES("2507","0","391","109","395.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2508","0","391","87","10000.00","");
INSERT INTO tbl_expensesde VALUES("2509","0","392","137","40.00","মুড়ি");
INSERT INTO tbl_expensesde VALUES("2510","0","392","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2511","0","392","158","40.00","+ নাস্তা");
INSERT INTO tbl_expensesde VALUES("2512","0","392","111","800.00","");
INSERT INTO tbl_expensesde VALUES("2513","0","392","92","300.00","");
INSERT INTO tbl_expensesde VALUES("2514","0","392","111","1950.00","");
INSERT INTO tbl_expensesde VALUES("2515","0","392","106","5230.00","");
INSERT INTO tbl_expensesde VALUES("2516","0","392","157","470.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2517","0","393","157","250.00","+ খাবার");
INSERT INTO tbl_expensesde VALUES("2518","0","393","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2519","0","393","109","1773.00","তেল+ মুরগি");
INSERT INTO tbl_expensesde VALUES("2520","0","393","109","220.00","জিরা +মুরগির মসলা");
INSERT INTO tbl_expensesde VALUES("2521","0","393","137","30.00","ব্যাটারি");
INSERT INTO tbl_expensesde VALUES("2522","0","393","167","2850.00","");
INSERT INTO tbl_expensesde VALUES("2523","0","393","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2524","0","393","87","5000.00","");
INSERT INTO tbl_expensesde VALUES("2525","0","393","87","16000.00","");
INSERT INTO tbl_expensesde VALUES("2526","0","393","158","110.00","");
INSERT INTO tbl_expensesde VALUES("2527","0","393","92","300.00","");
INSERT INTO tbl_expensesde VALUES("2528","0","393","87","300.00","হাজিরা ১ জন");
INSERT INTO tbl_expensesde VALUES("2529","0","393","86","10640.00","");
INSERT INTO tbl_expensesde VALUES("2530","0","393","87","200.00","");
INSERT INTO tbl_expensesde VALUES("2531","0","393","137","1580.00","মিষ্টি+ ফল");
INSERT INTO tbl_expensesde VALUES("2532","0","394","138","100.00","");
INSERT INTO tbl_expensesde VALUES("2533","0","394","85","6500.00","তাউরাশ");
INSERT INTO tbl_expensesde VALUES("2534","0","394","111","900.00","");
INSERT INTO tbl_expensesde VALUES("2535","0","394","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("2536","0","394","109","675.00","তরকারি +ডিম");
INSERT INTO tbl_expensesde VALUES("2537","0","394","137","70.00","টিস্যু");
INSERT INTO tbl_expensesde VALUES("2538","0","394","137","90.00","চা পাতা");
INSERT INTO tbl_expensesde VALUES("2539","0","394","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2540","0","394","93","250.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2541","0","394","156","160.00","");
INSERT INTO tbl_expensesde VALUES("2542","0","394","156","200.00","");
INSERT INTO tbl_expensesde VALUES("2543","0","394","87","1350.00","চাউল ১ বস্তা শাহীন");
INSERT INTO tbl_expensesde VALUES("2544","0","394","109","14750.00","চাউল+ডাল");
INSERT INTO tbl_expensesde VALUES("2545","0","394","162","200.00","");
INSERT INTO tbl_expensesde VALUES("2546","0","394","137","260.00","বাল্ব");
INSERT INTO tbl_expensesde VALUES("2547","0","394","85","4160.00","");
INSERT INTO tbl_expensesde VALUES("2548","0","394","92","240.00","");
INSERT INTO tbl_expensesde VALUES("2549","0","394","95","240.00","");
INSERT INTO tbl_expensesde VALUES("2550","0","394","111","750.00","");
INSERT INTO tbl_expensesde VALUES("2551","0","394","111","800.00","");
INSERT INTO tbl_expensesde VALUES("2552","0","394","109","720.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2553","0","394","86","5030.00","");
INSERT INTO tbl_expensesde VALUES("2554","0","394","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2555","0","394","92","300.00","");
INSERT INTO tbl_expensesde VALUES("2556","0","394","87","600.00","২ টা হাজিরা");
INSERT INTO tbl_expensesde VALUES("2557","0","394","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2558","0","394","158","200.00","সজিব");
INSERT INTO tbl_expensesde VALUES("2559","0","395","150","30000.00","রুবেল");
INSERT INTO tbl_expensesde VALUES("2560","0","396","91","900.00","");
INSERT INTO tbl_expensesde VALUES("2561","0","396","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2562","0","396","149","190.00","");
INSERT INTO tbl_expensesde VALUES("2563","0","396","156","170.00","");
INSERT INTO tbl_expensesde VALUES("2564","0","396","162","1000.00","");
INSERT INTO tbl_expensesde VALUES("2565","0","396","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("2566","0","396","170","1250.00","");
INSERT INTO tbl_expensesde VALUES("2567","0","396","103","1050.00","");
INSERT INTO tbl_expensesde VALUES("2568","0","396","170","250.00","");
INSERT INTO tbl_expensesde VALUES("2569","0","396","171","40.00","");
INSERT INTO tbl_expensesde VALUES("2570","0","396","19","430.00","");
INSERT INTO tbl_expensesde VALUES("2571","0","396","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2572","0","396","103","200.00","");
INSERT INTO tbl_expensesde VALUES("2573","0","396","149","700.00","");
INSERT INTO tbl_expensesde VALUES("2574","0","396","85","9700.00","TAWRASH");
INSERT INTO tbl_expensesde VALUES("2575","0","396","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2576","0","396","85","11300.00","TATA");
INSERT INTO tbl_expensesde VALUES("2577","0","396","91","500.00","");
INSERT INTO tbl_expensesde VALUES("2578","0","396","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2579","0","397","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2580","0","397","86","9340.00","");
INSERT INTO tbl_expensesde VALUES("2581","0","397","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2582","0","397","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2583","0","397","27","20.00","");
INSERT INTO tbl_expensesde VALUES("2584","0","397","111","900.00","");
INSERT INTO tbl_expensesde VALUES("2585","0","397","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2586","0","398","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2587","0","398","170","515.00","");
INSERT INTO tbl_expensesde VALUES("2588","0","398","164","18100.00","");
INSERT INTO tbl_expensesde VALUES("2589","0","398","170","700.00","HOMBAIL");
INSERT INTO tbl_expensesde VALUES("2590","0","398","27","20.00","");
INSERT INTO tbl_expensesde VALUES("2591","0","398","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("2592","0","398","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2593","0","398","165","40.00","");
INSERT INTO tbl_expensesde VALUES("2594","0","399","91","80.00","");
INSERT INTO tbl_expensesde VALUES("2595","0","399","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2596","0","399","93","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2597","0","399","156","50.00","");
INSERT INTO tbl_expensesde VALUES("2598","0","399","85","5010.00","");
INSERT INTO tbl_expensesde VALUES("2599","0","399","109","1700.00","ডিম+মুরগি+কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("2600","0","399","111","5000.00","");
INSERT INTO tbl_expensesde VALUES("2601","0","399","137","1800.00","পলিথিন");
INSERT INTO tbl_expensesde VALUES("2602","0","399","152","20.00","");
INSERT INTO tbl_expensesde VALUES("2603","0","399","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2604","0","399","156","100.00","");
INSERT INTO tbl_expensesde VALUES("2605","0","399","150","22500.00","সীট এঙ্গেল পাতি");
INSERT INTO tbl_expensesde VALUES("2606","0","399","150","2150.00","কাটিং পাথর,নাট বল্টু,চশমা");
INSERT INTO tbl_expensesde VALUES("2607","0","399","90","220.00","");
INSERT INTO tbl_expensesde VALUES("2608","0","399","137","340.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2609","0","399","145","200.00","মডেল টাউন বেচকাটার বকশিস");
INSERT INTO tbl_expensesde VALUES("2610","0","400","90","410.00","");
INSERT INTO tbl_expensesde VALUES("2611","0","400","85","6010.00","");
INSERT INTO tbl_expensesde VALUES("2612","0","400","103","120.00","দুলাল");
INSERT INTO tbl_expensesde VALUES("2613","0","401","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2614","0","402","27","1250.00","");
INSERT INTO tbl_expensesde VALUES("2615","0","402","86","5970.00","");
INSERT INTO tbl_expensesde VALUES("2616","0","402","87","500.00","salauddin");
INSERT INTO tbl_expensesde VALUES("2617","0","402","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2618","0","402","111","600.00","");
INSERT INTO tbl_expensesde VALUES("2619","0","402","165","550.00","");
INSERT INTO tbl_expensesde VALUES("2620","0","402","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2621","0","402","179","50.00","mahim");
INSERT INTO tbl_expensesde VALUES("2622","0","403","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("2623","0","403","92","100.00","");
INSERT INTO tbl_expensesde VALUES("2624","0","403","109","2080.00","মাছ+ব্যাগ");
INSERT INTO tbl_expensesde VALUES("2625","0","403","109","1740.00","তেল+তরকারি+ডিম");
INSERT INTO tbl_expensesde VALUES("2626","0","403","137","2800.00","সেলাই মেশিনের কাজ");
INSERT INTO tbl_expensesde VALUES("2627","0","403","92","100.00","");
INSERT INTO tbl_expensesde VALUES("2628","0","403","150","410.00","আঠা+ড্রিল বিট");
INSERT INTO tbl_expensesde VALUES("2629","0","403","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2630","0","403","137","200.00","ফাহাদ মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("2631","0","403","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2632","0","403","158","120.00","নাস্তা +কয়েল");
INSERT INTO tbl_expensesde VALUES("2633","0","403","156","140.00","");
INSERT INTO tbl_expensesde VALUES("2634","0","403","85","1000.00","");
INSERT INTO tbl_expensesde VALUES("2635","0","403","103","250.00","মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("2636","0","404","145","200.00","মডেলটাউনএঙ্গেলমিস্ত্রিভাড়");
INSERT INTO tbl_expensesde VALUES("2637","0","405","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2638","0","405","92","100.00","");
INSERT INTO tbl_expensesde VALUES("2639","0","406","170","340.00","");
INSERT INTO tbl_expensesde VALUES("2640","0","406","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2641","0","406","85","10400.00","tata");
INSERT INTO tbl_expensesde VALUES("2642","0","406","89","60000.00","dc food");
INSERT INTO tbl_expensesde VALUES("2643","0","406","171","1000.00","");
INSERT INTO tbl_expensesde VALUES("2644","0","406","170","680.00","");
INSERT INTO tbl_expensesde VALUES("2645","0","406","170","680.00","");
INSERT INTO tbl_expensesde VALUES("2646","0","406","170","820.00","");
INSERT INTO tbl_expensesde VALUES("2647","0","406","158","80.00","");
INSERT INTO tbl_expensesde VALUES("2648","0","406","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2649","0","406","19","520.00","");
INSERT INTO tbl_expensesde VALUES("2650","0","406","87","615.00","BIDDUT BILL");
INSERT INTO tbl_expensesde VALUES("2651","0","406","167","2350.00","");
INSERT INTO tbl_expensesde VALUES("2652","0","406","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2653","0","406","170","720.00","JIRA");
INSERT INTO tbl_expensesde VALUES("2654","0","406","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2655","0","406","158","30.00","");
INSERT INTO tbl_expensesde VALUES("2656","0","406","170","450.00","");
INSERT INTO tbl_expensesde VALUES("2657","0","406","162","1100.00","");
INSERT INTO tbl_expensesde VALUES("2658","0","406","165","340.00","");
INSERT INTO tbl_expensesde VALUES("2659","0","406","111","650.00","");
INSERT INTO tbl_expensesde VALUES("2660","0","406","111","1050.00","709");
INSERT INTO tbl_expensesde VALUES("2661","0","406","157","100.00","");
INSERT INTO tbl_expensesde VALUES("2662","0","406","27","120.00","");
INSERT INTO tbl_expensesde VALUES("2663","0","406","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2664","0","406","86","5525.00","");
INSERT INTO tbl_expensesde VALUES("2665","0","406","157","120.00","");
INSERT INTO tbl_expensesde VALUES("2666","0","406","87","5000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("2667","0","406","149","500.00","ELECTRICIAN A.ROB");
INSERT INTO tbl_expensesde VALUES("2668","0","407","158","240.00","");
INSERT INTO tbl_expensesde VALUES("2669","0","407","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2670","0","407","89","11000.00","");
INSERT INTO tbl_expensesde VALUES("2671","0","407","89","36200.00","");
INSERT INTO tbl_expensesde VALUES("2672","0","407","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2673","0","407","170","1130.00","");
INSERT INTO tbl_expensesde VALUES("2674","0","407","170","100.00","");
INSERT INTO tbl_expensesde VALUES("2675","0","407","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2676","0","407","111","4700.00","tata");
INSERT INTO tbl_expensesde VALUES("2677","0","407","156","100.00","");
INSERT INTO tbl_expensesde VALUES("2678","0","407","149","320.00","");
INSERT INTO tbl_expensesde VALUES("2679","0","407","87","13000.00","kamal");
INSERT INTO tbl_expensesde VALUES("2680","0","407","87","4500.00","sahadat");
INSERT INTO tbl_expensesde VALUES("2681","0","407","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2682","0","407","85","10000.00","tawras");
INSERT INTO tbl_expensesde VALUES("2683","0","407","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2684","0","407","27","100.00","sagor");
INSERT INTO tbl_expensesde VALUES("2685","0","407","91","420.00","");
INSERT INTO tbl_expensesde VALUES("2686","0","407","157","120.00","");
INSERT INTO tbl_expensesde VALUES("2687","0","407","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2688","0","407","87","300.00","RASED");
INSERT INTO tbl_expensesde VALUES("2689","0","407","170","380.00","");
INSERT INTO tbl_expensesde VALUES("2690","0","407","149","10000.00","STATER");
INSERT INTO tbl_expensesde VALUES("2691","0","407","103","2900.00","HASAN");
INSERT INTO tbl_expensesde VALUES("2692","0","407","86","3715.00","");
INSERT INTO tbl_expensesde VALUES("2693","0","408","87","2000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("2694","0","408","170","400.00","");
INSERT INTO tbl_expensesde VALUES("2695","0","408","87","200.00","SALAUDDIN");
INSERT INTO tbl_expensesde VALUES("2696","0","408","164","18100.00","");
INSERT INTO tbl_expensesde VALUES("2697","0","408","95","240.00","");
INSERT INTO tbl_expensesde VALUES("2698","0","408","20","400.00","CHAIR MERAMAT");
INSERT INTO tbl_expensesde VALUES("2699","0","409","87","2000.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("2700","0","410","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("2701","0","410","165","300.00","চাক্কা+স্যানেটরী");
INSERT INTO tbl_expensesde VALUES("2702","0","410","91","300.00","");
INSERT INTO tbl_expensesde VALUES("2703","0","410","109","400.00","মুরগি+মসলা");
INSERT INTO tbl_expensesde VALUES("2704","0","410","158","80.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2705","0","410","145","18150.00","মডেল টাউন রাজমিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("2706","0","410","86","2090.00","");
INSERT INTO tbl_expensesde VALUES("2707","0","410","109","725.00","আলু+তরকারি");
INSERT INTO tbl_expensesde VALUES("2708","0","410","86","20.00","");
INSERT INTO tbl_expensesde VALUES("2709","0","410","109","9680.00","আলু+পিয়াজ");
INSERT INTO tbl_expensesde VALUES("2710","0","410","158","1080.00","ও,এম,এস");
INSERT INTO tbl_expensesde VALUES("2711","0","410","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2712","0","410","137","420.00","আইকা");
INSERT INTO tbl_expensesde VALUES("2713","0","410","109","1250.00","তেল+ ডিম");
INSERT INTO tbl_expensesde VALUES("2714","0","411","158","70.00","");
INSERT INTO tbl_expensesde VALUES("2715","0","411","87","500.00","SAGOR");
INSERT INTO tbl_expensesde VALUES("2716","0","411","111","460.00","");
INSERT INTO tbl_expensesde VALUES("2717","0","411","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2718","0","411","164","18600.00","");
INSERT INTO tbl_expensesde VALUES("2719","0","411","170","160.00","");
INSERT INTO tbl_expensesde VALUES("2720","0","411","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("2721","0","411","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("2722","0","411","170","200.00","");
INSERT INTO tbl_expensesde VALUES("2723","0","411","158","200.00","");
INSERT INTO tbl_expensesde VALUES("2724","0","411","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2725","0","411","103","200.00","");
INSERT INTO tbl_expensesde VALUES("2726","0","411","103","120.00","");
INSERT INTO tbl_expensesde VALUES("2727","0","411","85","4510.00","");
INSERT INTO tbl_expensesde VALUES("2728","0","411","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2729","0","411","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2730","0","411","85","4850.00","TOWRAS");
INSERT INTO tbl_expensesde VALUES("2731","0","411","170","930.00","");
INSERT INTO tbl_expensesde VALUES("2732","0","411","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2733","0","411","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2734","0","411","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2735","0","412","157","100.00","");
INSERT INTO tbl_expensesde VALUES("2736","0","412","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2737","0","412","86","8525.00","");
INSERT INTO tbl_expensesde VALUES("2738","0","412","103","350.00","");
INSERT INTO tbl_expensesde VALUES("2739","0","412","86","300.00","");
INSERT INTO tbl_expensesde VALUES("2740","0","412","157","300.00","");
INSERT INTO tbl_expensesde VALUES("2741","0","413","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2742","0","413","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2743","0","413","170","290.00","");
INSERT INTO tbl_expensesde VALUES("2744","0","413","111","450.00","");
INSERT INTO tbl_expensesde VALUES("2745","0","413","111","400.00","");
INSERT INTO tbl_expensesde VALUES("2746","0","413","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2747","0","413","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2748","0","413","87","61820.00","SALARY");
INSERT INTO tbl_expensesde VALUES("2749","0","414","87","6300.00","SHOHEL");
INSERT INTO tbl_expensesde VALUES("2750","0","414","87","49600.00","");
INSERT INTO tbl_expensesde VALUES("2751","0","414","86","5860.00","");
INSERT INTO tbl_expensesde VALUES("2752","0","415","87","28500.00","");
INSERT INTO tbl_expensesde VALUES("2753","0","415","150","1500.00","মেশিনের কাজ বাবদ রুবেল");
INSERT INTO tbl_expensesde VALUES("2754","0","415","152","20.00","");
INSERT INTO tbl_expensesde VALUES("2755","0","415","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2756","0","415","92","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("2757","0","415","162","1110.00","");
INSERT INTO tbl_expensesde VALUES("2758","0","415","109","1130.00","মুরগি");
INSERT INTO tbl_expensesde VALUES("2759","0","415","109","350.00","মরিচ+তরকারি");
INSERT INTO tbl_expensesde VALUES("2760","0","415","150","1170.00","ফ্লাটবার");
INSERT INTO tbl_expensesde VALUES("2761","0","415","103","120.00","দুলাল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("2762","0","415","111","350.00","");
INSERT INTO tbl_expensesde VALUES("2763","0","415","145","7900.00","মডেল টাউন এঙ্গেল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("2764","0","415","87","8000.00","");
INSERT INTO tbl_expensesde VALUES("2765","0","415","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2766","0","416","20","250.00","");
INSERT INTO tbl_expensesde VALUES("2767","0","416","73","1500.00","");
INSERT INTO tbl_expensesde VALUES("2768","0","416","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2769","0","416","158","60.00","");
INSERT INTO tbl_expensesde VALUES("2770","0","416","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2771","0","416","170","300.00","");
INSERT INTO tbl_expensesde VALUES("2772","0","416","157","90.00","");
INSERT INTO tbl_expensesde VALUES("2773","0","416","149","50.00","nut");
INSERT INTO tbl_expensesde VALUES("2774","0","416","157","100.00","");
INSERT INTO tbl_expensesde VALUES("2775","0","416","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2776","0","416","103","420.00","");
INSERT INTO tbl_expensesde VALUES("2777","0","417","87","300.00","MAHID");
INSERT INTO tbl_expensesde VALUES("2778","0","417","86","6470.00","");
INSERT INTO tbl_expensesde VALUES("2779","0","417","87","900.00","SALAUDDIN");
INSERT INTO tbl_expensesde VALUES("2780","0","417","160","100.00","");
INSERT INTO tbl_expensesde VALUES("2781","0","417","157","250.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("2782","0","417","87","9200.00","");
INSERT INTO tbl_expensesde VALUES("2783","0","418","158","110.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2784","0","418","137","45.00","সেভলন");
INSERT INTO tbl_expensesde VALUES("2785","0","418","152","10.00","");
INSERT INTO tbl_expensesde VALUES("2786","0","418","109","1275.00","তেল+তরকারি");
INSERT INTO tbl_expensesde VALUES("2787","0","418","109","600.00","রসুন+ডিম");
INSERT INTO tbl_expensesde VALUES("2788","0","418","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2789","0","418","158","60.00","");
INSERT INTO tbl_expensesde VALUES("2790","0","418","145","1000.00","মালেকফুপাকাজনাজিমুদ্দীনকে");
INSERT INTO tbl_expensesde VALUES("2791","0","419","85","3500.00","");
INSERT INTO tbl_expensesde VALUES("2792","0","419","157","100.00","");
INSERT INTO tbl_expensesde VALUES("2793","0","419","158","60.00","");
INSERT INTO tbl_expensesde VALUES("2794","0","419","19","600.00","CHAIR MERAMAT");
INSERT INTO tbl_expensesde VALUES("2795","0","419","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2796","0","419","157","260.00","");
INSERT INTO tbl_expensesde VALUES("2797","0","419","86","2360.00","");
INSERT INTO tbl_expensesde VALUES("2798","0","420","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2799","0","420","92","50.00","");
INSERT INTO tbl_expensesde VALUES("2800","0","420","87","7635.00","");
INSERT INTO tbl_expensesde VALUES("2801","0","420","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2802","0","420","145","20000.00","কাউন্সিলর ইমু আক্তার কে ");
INSERT INTO tbl_expensesde VALUES("2803","0","420","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2804","0","420","111","800.00","");
INSERT INTO tbl_expensesde VALUES("2805","0","420","85","5010.00","");
INSERT INTO tbl_expensesde VALUES("2806","0","420","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2807","0","420","109","690.00","");
INSERT INTO tbl_expensesde VALUES("2808","0","420","145","2000.00","বাসার ভ্যান এর কন্ট্রোল ");
INSERT INTO tbl_expensesde VALUES("2809","0","420","109","725.00","ডিম+হলুদের গুড়া");
INSERT INTO tbl_expensesde VALUES("2810","0","420","150","15000.00","মটরের কাজে বকুল কে");
INSERT INTO tbl_expensesde VALUES("2811","0","420","137","60.00","সীল");
INSERT INTO tbl_expensesde VALUES("2812","0","420","137","120.00","ট্রেড লাইসন্সে তৈরি");
INSERT INTO tbl_expensesde VALUES("2813","0","420","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2814","0","420","152","100.00","");
INSERT INTO tbl_expensesde VALUES("2815","0","421","103","4500.00","WATER PUMP");
INSERT INTO tbl_expensesde VALUES("2816","0","421","15","80.00","");
INSERT INTO tbl_expensesde VALUES("2817","0","421","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2818","0","421","170","200.00","");
INSERT INTO tbl_expensesde VALUES("2819","0","421","111","450.00","");
INSERT INTO tbl_expensesde VALUES("2820","0","421","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2821","0","421","87","11000.00","SOHRAB");
INSERT INTO tbl_expensesde VALUES("2822","0","421","157","200.00","");
INSERT INTO tbl_expensesde VALUES("2823","0","421","157","300.00","");
INSERT INTO tbl_expensesde VALUES("2824","0","421","87","3600.00","L SHAHIN");
INSERT INTO tbl_expensesde VALUES("2825","0","421","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2826","0","421","86","5850.00","");
INSERT INTO tbl_expensesde VALUES("2827","0","422","87","4300.00","");
INSERT INTO tbl_expensesde VALUES("2828","0","422","158","160.00","");
INSERT INTO tbl_expensesde VALUES("2829","0","422","170","1470.00","");
INSERT INTO tbl_expensesde VALUES("2830","0","422","164","36800.00","");
INSERT INTO tbl_expensesde VALUES("2831","0","422","103","1950.00","");
INSERT INTO tbl_expensesde VALUES("2832","0","422","103","2200.00","");
INSERT INTO tbl_expensesde VALUES("2833","0","422","27","90.00","");
INSERT INTO tbl_expensesde VALUES("2834","0","422","111","5600.00","");
INSERT INTO tbl_expensesde VALUES("2835","0","423","86","6230.00","");
INSERT INTO tbl_expensesde VALUES("2836","0","423","85","12460.00","");
INSERT INTO tbl_expensesde VALUES("2837","0","423","86","180.00","");
INSERT INTO tbl_expensesde VALUES("2838","0","424","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2839","0","424","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2840","0","424","20","27500.00","MOYDER CARD");
INSERT INTO tbl_expensesde VALUES("2841","0","424","170","905.00","");
INSERT INTO tbl_expensesde VALUES("2842","0","424","103","350.00","");
INSERT INTO tbl_expensesde VALUES("2843","0","424","21","500.00","");
INSERT INTO tbl_expensesde VALUES("2844","0","424","171","10.00","");
INSERT INTO tbl_expensesde VALUES("2845","0","424","19","230.00","TEA");
INSERT INTO tbl_expensesde VALUES("2846","0","424","171","10.00","");
INSERT INTO tbl_expensesde VALUES("2847","0","424","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2848","0","424","85","11360.00","TAWRAS");
INSERT INTO tbl_expensesde VALUES("2849","0","424","103","1800.00","");
INSERT INTO tbl_expensesde VALUES("2850","0","424","27","120.00","");
INSERT INTO tbl_expensesde VALUES("2851","0","424","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2852","0","424","157","100.00","");
INSERT INTO tbl_expensesde VALUES("2853","0","424","103","3700.00","1612");
INSERT INTO tbl_expensesde VALUES("2854","0","424","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2855","0","424","156","200.00","");
INSERT INTO tbl_expensesde VALUES("2856","0","424","158","270.00","OMS");
INSERT INTO tbl_expensesde VALUES("2857","0","425","157","70.00","");
INSERT INTO tbl_expensesde VALUES("2858","0","425","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2859","0","425","111","2000.00","BISKUT");
INSERT INTO tbl_expensesde VALUES("2860","0","425","111","4090.00","TATA");
INSERT INTO tbl_expensesde VALUES("2861","0","425","111","1000.00","709");
INSERT INTO tbl_expensesde VALUES("2862","0","425","111","400.00","MONIR");
INSERT INTO tbl_expensesde VALUES("2863","0","425","170","375.00","");
INSERT INTO tbl_expensesde VALUES("2864","0","425","149","150.00","CUTTING PATHOR");
INSERT INTO tbl_expensesde VALUES("2865","0","425","170","120.00","");
INSERT INTO tbl_expensesde VALUES("2866","0","425","164","17100.00","");
INSERT INTO tbl_expensesde VALUES("2867","0","425","149","1860.00","CUTTING PATHOR,GASAR PATH");
INSERT INTO tbl_expensesde VALUES("2868","0","425","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2869","0","425","171","40.00","");
INSERT INTO tbl_expensesde VALUES("2870","0","425","111","900.00","709");
INSERT INTO tbl_expensesde VALUES("2871","0","425","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("2872","0","425","158","120.00","");
INSERT INTO tbl_expensesde VALUES("2873","0","425","21","1000.00","");
INSERT INTO tbl_expensesde VALUES("2874","0","425","170","620.00","");
INSERT INTO tbl_expensesde VALUES("2875","0","425","87","7000.00","");
INSERT INTO tbl_expensesde VALUES("2876","0","426","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2877","0","427","27","100.00","");
INSERT INTO tbl_expensesde VALUES("2878","0","428","103","8000.00","SAHARA");
INSERT INTO tbl_expensesde VALUES("2879","0","428","103","14400.00","MA BABA");
INSERT INTO tbl_expensesde VALUES("2880","0","428","103","200.00","DULAL");
INSERT INTO tbl_expensesde VALUES("2881","0","428","157","100.00","");
INSERT INTO tbl_expensesde VALUES("2882","0","428","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2883","0","429","170","340.00","");
INSERT INTO tbl_expensesde VALUES("2884","0","429","86","270.00","");
INSERT INTO tbl_expensesde VALUES("2885","0","429","149","420.00","");
INSERT INTO tbl_expensesde VALUES("2886","0","429","156","100.00","");
INSERT INTO tbl_expensesde VALUES("2887","0","429","170","100.00","");
INSERT INTO tbl_expensesde VALUES("2888","0","429","157","180.00","");
INSERT INTO tbl_expensesde VALUES("2889","0","429","85","8630.00","");
INSERT INTO tbl_expensesde VALUES("2890","0","429","111","500.00","");
INSERT INTO tbl_expensesde VALUES("2891","0","429","157","240.00","");
INSERT INTO tbl_expensesde VALUES("2892","0","429","91","800.00","");
INSERT INTO tbl_expensesde VALUES("2893","0","429","86","9190.00","");
INSERT INTO tbl_expensesde VALUES("2894","0","429","86","600.00","");
INSERT INTO tbl_expensesde VALUES("2895","0","430","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2896","0","430","170","100.00","");
INSERT INTO tbl_expensesde VALUES("2897","0","430","167","2600.00","");
INSERT INTO tbl_expensesde VALUES("2898","0","430","87","3000.00","FOUR MAN");
INSERT INTO tbl_expensesde VALUES("2899","0","430","165","400.00","");
INSERT INTO tbl_expensesde VALUES("2900","0","430","161","60.00","");
INSERT INTO tbl_expensesde VALUES("2901","0","430","164","18300.00","");
INSERT INTO tbl_expensesde VALUES("2902","0","430","15","379.00","");
INSERT INTO tbl_expensesde VALUES("2903","0","430","111","4700.00","");
INSERT INTO tbl_expensesde VALUES("2904","0","430","149","5000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("2905","0","430","19","70.00","TILES CLEANER");
INSERT INTO tbl_expensesde VALUES("2906","0","430","170","450.00","");
INSERT INTO tbl_expensesde VALUES("2907","0","430","158","90.00","");
INSERT INTO tbl_expensesde VALUES("2908","0","430","170","990.00","MURGI");
INSERT INTO tbl_expensesde VALUES("2909","0","430","170","3260.00","ALU");
INSERT INTO tbl_expensesde VALUES("2910","0","431","103","550.00","JAM NUT,DULAL");
INSERT INTO tbl_expensesde VALUES("2911","0","431","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2912","0","432","95","160.00","");
INSERT INTO tbl_expensesde VALUES("2913","0","432","158","40.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2914","0","432","92","120.00","");
INSERT INTO tbl_expensesde VALUES("2915","0","432","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("2916","0","432","15","77.00","");
INSERT INTO tbl_expensesde VALUES("2917","0","432","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2918","0","432","92","270.00","");
INSERT INTO tbl_expensesde VALUES("2919","0","432","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2920","0","432","109","450.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2921","0","432","111","4350.00","");
INSERT INTO tbl_expensesde VALUES("2922","0","432","158","220.00","");
INSERT INTO tbl_expensesde VALUES("2923","0","432","86","11540.00","");
INSERT INTO tbl_expensesde VALUES("2924","0","433","85","10010.00","");
INSERT INTO tbl_expensesde VALUES("2925","0","433","87","1500.00","");
INSERT INTO tbl_expensesde VALUES("2926","0","433","158","110.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2927","0","433","109","250.00","মুগডাল+লবন");
INSERT INTO tbl_expensesde VALUES("2928","0","433","109","150.00","কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("2929","0","433","137","290.00","আইকা+সিরিজ কাগজ");
INSERT INTO tbl_expensesde VALUES("2930","0","433","158","120.00","ভাড়া+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2931","0","433","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("2932","0","433","86","50.00","ডেলিভারি");
INSERT INTO tbl_expensesde VALUES("2933","0","434","171","10.00","");
INSERT INTO tbl_expensesde VALUES("2934","0","434","19","150.00","");
INSERT INTO tbl_expensesde VALUES("2935","0","434","19","90.00","COBI PRINT");
INSERT INTO tbl_expensesde VALUES("2936","0","434","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2937","0","434","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2938","0","434","44","330.00","");
INSERT INTO tbl_expensesde VALUES("2939","0","434","149","180.00","");
INSERT INTO tbl_expensesde VALUES("2940","0","434","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2941","0","434","149","690.00","SEIP");
INSERT INTO tbl_expensesde VALUES("2942","0","434","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2943","0","434","170","4150.00","");
INSERT INTO tbl_expensesde VALUES("2944","0","434","157","50.00","");
INSERT INTO tbl_expensesde VALUES("2945","0","434","95","80.00","");
INSERT INTO tbl_expensesde VALUES("2946","0","434","158","540.00","OMS");
INSERT INTO tbl_expensesde VALUES("2947","0","435","92","100.00","");
INSERT INTO tbl_expensesde VALUES("2948","0","435","137","800.00","শর্ট");
INSERT INTO tbl_expensesde VALUES("2949","0","435","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("2950","0","435","145","100000.00","");
INSERT INTO tbl_expensesde VALUES("2951","0","435","86","8060.00","");
INSERT INTO tbl_expensesde VALUES("2952","0","436","158","50.00","");
INSERT INTO tbl_expensesde VALUES("2953","0","436","85","8370.00","");
INSERT INTO tbl_expensesde VALUES("2954","0","436","145","650.00","বাসায় অক্রিজেন");
INSERT INTO tbl_expensesde VALUES("2955","0","436","158","90.00","+ নাস্তা");
INSERT INTO tbl_expensesde VALUES("2956","0","436","137","300.00","ময়লা নেওয়া বাবদ");
INSERT INTO tbl_expensesde VALUES("2957","0","436","106","50.00","");
INSERT INTO tbl_expensesde VALUES("2958","0","436","109","895.00","তেল ডিম আদা রসুন");
INSERT INTO tbl_expensesde VALUES("2959","0","436","156","150.00","");
INSERT INTO tbl_expensesde VALUES("2960","0","436","137","900.00","রাব্বি ঔষধ");
INSERT INTO tbl_expensesde VALUES("2961","0","436","137","550.00","জিন্নাত ঔষধ");
INSERT INTO tbl_expensesde VALUES("2962","0","436","152","20.00","");
INSERT INTO tbl_expensesde VALUES("2963","0","436","137","100.00","কেক+পানি");
INSERT INTO tbl_expensesde VALUES("2964","0","436","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2965","0","437","111","5000.00","");
INSERT INTO tbl_expensesde VALUES("2966","0","437","157","270.00","");
INSERT INTO tbl_expensesde VALUES("2967","0","437","86","4345.00","");
INSERT INTO tbl_expensesde VALUES("2968","0","437","170","390.00","");
INSERT INTO tbl_expensesde VALUES("2969","0","437","27","80.00","2 DIN");
INSERT INTO tbl_expensesde VALUES("2970","0","438","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2971","0","438","109","390.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("2972","0","438","111","5000.00","");
INSERT INTO tbl_expensesde VALUES("2973","0","438","158","90.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("2974","0","438","137","30.00","টুপিন");
INSERT INTO tbl_expensesde VALUES("2975","0","438","145","10000.00","দেলোয়ার মাদবর");
INSERT INTO tbl_expensesde VALUES("2976","0","438","158","200.00","");
INSERT INTO tbl_expensesde VALUES("2977","0","438","87","500.00","");
INSERT INTO tbl_expensesde VALUES("2978","0","438","109","950.00","তরকারি+ডিম");
INSERT INTO tbl_expensesde VALUES("2979","0","438","150","110.00","নাট +স্কু");
INSERT INTO tbl_expensesde VALUES("2980","0","438","156","350.00","");
INSERT INTO tbl_expensesde VALUES("2981","0","438","103","8000.00","কেবিনের কাজ বাবদ আবদুল");
INSERT INTO tbl_expensesde VALUES("2982","0","439","145","10000.00","সাহায্য প্রাদান চিকন্দি");
INSERT INTO tbl_expensesde VALUES("2983","0","440","158","40.00","");
INSERT INTO tbl_expensesde VALUES("2984","0","441","158","30.00","+ভিমবার");
INSERT INTO tbl_expensesde VALUES("2985","0","441","137","30.00","ভ্যানে হাওয়া");
INSERT INTO tbl_expensesde VALUES("2986","0","442","157","40.00","");
INSERT INTO tbl_expensesde VALUES("2987","0","442","87","24500.00","RAJIB,SUMON,SOHRAB");
INSERT INTO tbl_expensesde VALUES("2988","0","442","157","240.00","");
INSERT INTO tbl_expensesde VALUES("2989","0","442","157","160.00","");
INSERT INTO tbl_expensesde VALUES("2990","0","442","157","200.00","MISTRI");
INSERT INTO tbl_expensesde VALUES("2991","0","442","87","5000.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("2992","0","442","87","500.00","SALAUDDIN");
INSERT INTO tbl_expensesde VALUES("2993","0","442","19","40.00","");
INSERT INTO tbl_expensesde VALUES("2994","0","442","111","5130.00","");
INSERT INTO tbl_expensesde VALUES("2995","0","442","149","4000.00","RUBEL SIRAJGANJ");
INSERT INTO tbl_expensesde VALUES("2996","0","442","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2997","0","443","158","20.00","");
INSERT INTO tbl_expensesde VALUES("2998","0","443","157","230.00","");
INSERT INTO tbl_expensesde VALUES("2999","0","443","164","17800.00","");
INSERT INTO tbl_expensesde VALUES("3000","0","443","86","9200.00","");
INSERT INTO tbl_expensesde VALUES("3001","0","444","111","1100.00","709");
INSERT INTO tbl_expensesde VALUES("3002","0","444","157","90.00","");
INSERT INTO tbl_expensesde VALUES("3003","0","444","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3004","0","444","87","100.00","mahid");
INSERT INTO tbl_expensesde VALUES("3005","0","444","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3006","0","444","91","2760.00","");
INSERT INTO tbl_expensesde VALUES("3007","0","445","165","1050.00","OIL,WASH");
INSERT INTO tbl_expensesde VALUES("3008","0","445","170","720.00","");
INSERT INTO tbl_expensesde VALUES("3009","0","445","86","5280.00","");
INSERT INTO tbl_expensesde VALUES("3010","0","445","87","5000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("3011","0","445","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3012","0","446","158","270.00","");
INSERT INTO tbl_expensesde VALUES("3013","0","447","158","120.00","");
INSERT INTO tbl_expensesde VALUES("3014","0","447","87","200.00","");
INSERT INTO tbl_expensesde VALUES("3015","0","447","92","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3016","0","447","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3017","0","447","85","1010.00","");
INSERT INTO tbl_expensesde VALUES("3018","0","447","109","420.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3019","0","448","19","60.00","");
INSERT INTO tbl_expensesde VALUES("3020","0","448","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3021","0","448","85","8750.00","tata");
INSERT INTO tbl_expensesde VALUES("3022","0","448","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3023","0","448","170","200.00","");
INSERT INTO tbl_expensesde VALUES("3024","0","448","86","6970.00","");
INSERT INTO tbl_expensesde VALUES("3025","0","448","111","400.00","");
INSERT INTO tbl_expensesde VALUES("3026","0","449","92","180.00","");
INSERT INTO tbl_expensesde VALUES("3027","0","449","85","6000.00","");
INSERT INTO tbl_expensesde VALUES("3028","0","449","109","1120.00","মুরগি");
INSERT INTO tbl_expensesde VALUES("3029","0","449","158","90.00","");
INSERT INTO tbl_expensesde VALUES("3030","0","449","92","50.00","");
INSERT INTO tbl_expensesde VALUES("3031","0","449","109","2015.00","তেল+ডিম+মরিচ+হলুদের গুড়া");
INSERT INTO tbl_expensesde VALUES("3032","0","449","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3033","0","449","111","7500.00","");
INSERT INTO tbl_expensesde VALUES("3034","0","449","158","70.00","");
INSERT INTO tbl_expensesde VALUES("3035","0","449","150","1600.00","কাটিং পাথর ওয়ারিং রড ");
INSERT INTO tbl_expensesde VALUES("3036","0","449","150","1600.00","প্লেন সিট ");
INSERT INTO tbl_expensesde VALUES("3037","0","449","111","470.00","");
INSERT INTO tbl_expensesde VALUES("3038","0","450","158","200.00","");
INSERT INTO tbl_expensesde VALUES("3039","0","450","15","110.00","KAKI");
INSERT INTO tbl_expensesde VALUES("3040","0","450","86","7160.00","");
INSERT INTO tbl_expensesde VALUES("3041","0","450","157","600.00","2 DIN");
INSERT INTO tbl_expensesde VALUES("3042","0","450","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3043","0","451","158","120.00","");
INSERT INTO tbl_expensesde VALUES("3044","0","451","170","885.00","");
INSERT INTO tbl_expensesde VALUES("3045","0","451","149","440.00","");
INSERT INTO tbl_expensesde VALUES("3046","0","451","162","200.00","");
INSERT INTO tbl_expensesde VALUES("3047","0","451","111","4360.00","");
INSERT INTO tbl_expensesde VALUES("3048","0","451","171","40.00","");
INSERT INTO tbl_expensesde VALUES("3049","0","451","164","17350.00","");
INSERT INTO tbl_expensesde VALUES("3050","0","451","85","9500.00","TAOWRAS");
INSERT INTO tbl_expensesde VALUES("3051","0","451","156","160.00","");
INSERT INTO tbl_expensesde VALUES("3052","0","451","149","31200.00","STEEL");
INSERT INTO tbl_expensesde VALUES("3053","0","451","158","100.00","");
INSERT INTO tbl_expensesde VALUES("3054","0","451","149","200.00","");
INSERT INTO tbl_expensesde VALUES("3055","0","451","170","200.00","");
INSERT INTO tbl_expensesde VALUES("3056","0","451","27","165.00","");
INSERT INTO tbl_expensesde VALUES("3057","0","451","149","650.00","LOOKING GLASS");
INSERT INTO tbl_expensesde VALUES("3058","0","452","157","240.00","");
INSERT INTO tbl_expensesde VALUES("3059","0","452","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3060","0","452","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3061","0","453","86","11715.00","");
INSERT INTO tbl_expensesde VALUES("3062","0","453","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3063","0","454","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3064","0","454","87","91865.00","");
INSERT INTO tbl_expensesde VALUES("3065","0","454","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("3066","0","454","149","550.00","CHAIN");
INSERT INTO tbl_expensesde VALUES("3067","0","454","149","50.00","");
INSERT INTO tbl_expensesde VALUES("3068","0","454","149","30.00","");
INSERT INTO tbl_expensesde VALUES("3069","0","454","158","10.00","");
INSERT INTO tbl_expensesde VALUES("3070","0","454","82","1500.00","HIRA");
INSERT INTO tbl_expensesde VALUES("3071","0","454","149","400.00","PLAIN SHEET");
INSERT INTO tbl_expensesde VALUES("3072","0","454","103","120.00","DULAL");
INSERT INTO tbl_expensesde VALUES("3073","0","454","111","4750.00","TATA");
INSERT INTO tbl_expensesde VALUES("3074","0","454","170","485.00","");
INSERT INTO tbl_expensesde VALUES("3075","0","454","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3076","0","454","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3077","0","454","170","1700.00","FISH");
INSERT INTO tbl_expensesde VALUES("3078","0","454","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3079","0","454","170","750.00","EGG");
INSERT INTO tbl_expensesde VALUES("3080","0","454","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3081","0","454","103","360.00","TYRE");
INSERT INTO tbl_expensesde VALUES("3082","0","454","111","600.00","");
INSERT INTO tbl_expensesde VALUES("3083","0","454","156","150.00","");
INSERT INTO tbl_expensesde VALUES("3084","0","454","149","50.00","");
INSERT INTO tbl_expensesde VALUES("3085","0","454","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3086","0","454","111","350.00","");
INSERT INTO tbl_expensesde VALUES("3087","0","454","157","40.00","RASED");
INSERT INTO tbl_expensesde VALUES("3088","0","454","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3089","0","454","19","65.00","");
INSERT INTO tbl_expensesde VALUES("3090","0","454","27","70.00","");
INSERT INTO tbl_expensesde VALUES("3091","0","454","170","390.00","");
INSERT INTO tbl_expensesde VALUES("3092","0","454","86","12990.00","");
INSERT INTO tbl_expensesde VALUES("3093","0","454","87","7250.00","");
INSERT INTO tbl_expensesde VALUES("3094","0","454","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3095","0","454","85","10700.00","TATA");
INSERT INTO tbl_expensesde VALUES("3096","0","454","167","2600.00","");
INSERT INTO tbl_expensesde VALUES("3097","0","455","85","5000.00","monir");
INSERT INTO tbl_expensesde VALUES("3098","0","455","170","225.00","");
INSERT INTO tbl_expensesde VALUES("3099","0","455","170","20.00","");
INSERT INTO tbl_expensesde VALUES("3100","0","455","170","150.00","");
INSERT INTO tbl_expensesde VALUES("3101","0","455","82","180.00","");
INSERT INTO tbl_expensesde VALUES("3102","0","455","170","700.00","");
INSERT INTO tbl_expensesde VALUES("3103","0","455","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3104","0","455","87","4000.00","SOHRAB");
INSERT INTO tbl_expensesde VALUES("3105","0","455","87","16500.00","RIPOMN");
INSERT INTO tbl_expensesde VALUES("3106","0","455","103","7000.00","CABIN");
INSERT INTO tbl_expensesde VALUES("3107","0","455","164","17200.00","");
INSERT INTO tbl_expensesde VALUES("3108","0","455","19","140.00","");
INSERT INTO tbl_expensesde VALUES("3109","0","455","111","4070.00","");
INSERT INTO tbl_expensesde VALUES("3110","0","455","87","8000.00","");
INSERT INTO tbl_expensesde VALUES("3111","0","455","87","17330.00","");
INSERT INTO tbl_expensesde VALUES("3112","0","455","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3113","0","455","87","500.00","MINTU DRIVER");
INSERT INTO tbl_expensesde VALUES("3114","0","455","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3115","0","456","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3116","0","456","170","9190.00","ALU PIAJ");
INSERT INTO tbl_expensesde VALUES("3117","0","456","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3118","0","456","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3119","0","456","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3120","0","456","15","397.00","");
INSERT INTO tbl_expensesde VALUES("3121","0","456","111","900.00","709");
INSERT INTO tbl_expensesde VALUES("3122","0","457","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3123","0","457","87","5000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("3124","0","457","87","5000.00","RABBI");
INSERT INTO tbl_expensesde VALUES("3125","0","457","156","150.00","");
INSERT INTO tbl_expensesde VALUES("3126","0","457","161","60.00","");
INSERT INTO tbl_expensesde VALUES("3127","0","457","170","100.00","");
INSERT INTO tbl_expensesde VALUES("3128","0","457","87","1200.00","");
INSERT INTO tbl_expensesde VALUES("3129","0","457","111","350.00","");
INSERT INTO tbl_expensesde VALUES("3130","0","457","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3131","0","457","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("3132","0","457","158","270.00","");
INSERT INTO tbl_expensesde VALUES("3133","0","457","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3134","0","457","170","860.00","");
INSERT INTO tbl_expensesde VALUES("3135","0","457","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3136","0","457","157","180.00","");
INSERT INTO tbl_expensesde VALUES("3137","0","457","162","500.00","");
INSERT INTO tbl_expensesde VALUES("3138","0","458","170","200.00","");
INSERT INTO tbl_expensesde VALUES("3139","0","458","86","24500.00","");
INSERT INTO tbl_expensesde VALUES("3140","0","458","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3141","0","458","158","250.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("3142","0","458","157","70.00","");
INSERT INTO tbl_expensesde VALUES("3143","0","458","111","930.00","");
INSERT INTO tbl_expensesde VALUES("3144","0","458","87","5000.00","MOSTAFIZ");
INSERT INTO tbl_expensesde VALUES("3145","0","458","103","5310.00","TAOWRAS GATE LOCK");
INSERT INTO tbl_expensesde VALUES("3146","0","458","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3147","0","458","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3148","0","458","95","80.00","");
INSERT INTO tbl_expensesde VALUES("3149","0","458","103","2800.00","CHANDI,MONIR TRUCK");
INSERT INTO tbl_expensesde VALUES("3150","0","458","149","3100.00","SAIB,PULI,GAS");
INSERT INTO tbl_expensesde VALUES("3151","0","459","87","14500.00","RAJIB+MOSTAFIZ");
INSERT INTO tbl_expensesde VALUES("3152","0","459","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3153","0","459","171","10.00","");
INSERT INTO tbl_expensesde VALUES("3154","0","459","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3155","0","459","111","5670.00","TATA");
INSERT INTO tbl_expensesde VALUES("3156","0","459","149","1200.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("3157","0","459","157","70.00","");
INSERT INTO tbl_expensesde VALUES("3158","0","459","91","480.00","RABBI");
INSERT INTO tbl_expensesde VALUES("3159","0","459","170","540.00","");
INSERT INTO tbl_expensesde VALUES("3160","0","459","171","10000.00","CIRA");
INSERT INTO tbl_expensesde VALUES("3161","0","460","171","10.00","");
INSERT INTO tbl_expensesde VALUES("3162","0","460","158","70.00","");
INSERT INTO tbl_expensesde VALUES("3163","0","460","149","330.00","");
INSERT INTO tbl_expensesde VALUES("3164","0","460","156","160.00","");
INSERT INTO tbl_expensesde VALUES("3165","0","460","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3166","0","460","171","10.00","");
INSERT INTO tbl_expensesde VALUES("3167","0","460","27","120.00","");
INSERT INTO tbl_expensesde VALUES("3168","0","460","20","200.00","");
INSERT INTO tbl_expensesde VALUES("3169","0","460","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3170","0","460","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3171","0","460","20","250.00","CHAIR MERAMAT");
INSERT INTO tbl_expensesde VALUES("3172","0","460","149","15000.00","MOTOR PURCHASE");
INSERT INTO tbl_expensesde VALUES("3173","0","460","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3174","0","460","171","50.00","");
INSERT INTO tbl_expensesde VALUES("3175","0","460","85","2600.00","TAOWRAS");
INSERT INTO tbl_expensesde VALUES("3176","0","460","162","1620.00","");
INSERT INTO tbl_expensesde VALUES("3177","0","460","165","6640.00","");
INSERT INTO tbl_expensesde VALUES("3178","0","460","27","450.00","CORTON TAPE");
INSERT INTO tbl_expensesde VALUES("3179","0","460","27","250.00","");
INSERT INTO tbl_expensesde VALUES("3180","0","460","27","1000.00","PRIVATE CAR");
INSERT INTO tbl_expensesde VALUES("3181","0","460","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3182","0","461","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3183","0","461","27","45.00","");
INSERT INTO tbl_expensesde VALUES("3184","0","461","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3185","0","461","149","480.00","");
INSERT INTO tbl_expensesde VALUES("3186","0","461","158","70.00","");
INSERT INTO tbl_expensesde VALUES("3187","0","461","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3188","0","461","170","345.00","");
INSERT INTO tbl_expensesde VALUES("3189","0","461","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3190","0","461","15","879.00","");
INSERT INTO tbl_expensesde VALUES("3191","0","461","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3192","0","461","171","200.00","");
INSERT INTO tbl_expensesde VALUES("3193","0","462","158","50.00","");
INSERT INTO tbl_expensesde VALUES("3194","0","462","86","5315.00","");
INSERT INTO tbl_expensesde VALUES("3195","0","462","87","8500.00","");
INSERT INTO tbl_expensesde VALUES("3196","0","462","145","28000.00","বিকাশ");
INSERT INTO tbl_expensesde VALUES("3197","0","462","145","25000.00","বিকাশ");
INSERT INTO tbl_expensesde VALUES("3198","0","462","158","180.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3199","0","462","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("3200","0","462","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3201","0","462","109","1465.00","তেল+ডিম+আদা");
INSERT INTO tbl_expensesde VALUES("3202","0","462","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("3203","0","462","109","16620.00","চাল+ডাল");
INSERT INTO tbl_expensesde VALUES("3204","0","462","87","12000.00","");
INSERT INTO tbl_expensesde VALUES("3205","0","462","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3206","0","462","150","380.00","বল্টু");
INSERT INTO tbl_expensesde VALUES("3207","0","462","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3208","0","463","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3209","0","463","103","76000.00","tyre");
INSERT INTO tbl_expensesde VALUES("3210","0","463","15","379.00","");
INSERT INTO tbl_expensesde VALUES("3211","0","463","15","39.00","");
INSERT INTO tbl_expensesde VALUES("3212","0","463","87","1200.00","bridge scale");
INSERT INTO tbl_expensesde VALUES("3213","0","463","162","1010.00","");
INSERT INTO tbl_expensesde VALUES("3214","0","463","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3215","0","463","85","9980.00","");
INSERT INTO tbl_expensesde VALUES("3216","0","464","158","100.00","");
INSERT INTO tbl_expensesde VALUES("3217","0","464","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3218","0","464","111","1530.00","");
INSERT INTO tbl_expensesde VALUES("3219","0","464","103","2800.00","ROSI,POLI");
INSERT INTO tbl_expensesde VALUES("3220","0","464","111","750.00","");
INSERT INTO tbl_expensesde VALUES("3221","0","464","170","430.00","");
INSERT INTO tbl_expensesde VALUES("3222","0","464","86","7415.00","");
INSERT INTO tbl_expensesde VALUES("3223","0","464","103","1510.00","ANAMUL");
INSERT INTO tbl_expensesde VALUES("3224","0","465","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3225","0","465","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3226","0","465","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3227","0","465","149","300.00","TERKATA");
INSERT INTO tbl_expensesde VALUES("3228","0","465","170","150.00","");
INSERT INTO tbl_expensesde VALUES("3229","0","465","170","960.00","");
INSERT INTO tbl_expensesde VALUES("3230","0","465","158","50.00","");
INSERT INTO tbl_expensesde VALUES("3231","0","465","149","6170.00","");
INSERT INTO tbl_expensesde VALUES("3232","0","465","91","150.00","");
INSERT INTO tbl_expensesde VALUES("3233","0","465","149","120.00","");
INSERT INTO tbl_expensesde VALUES("3234","0","465","103","220.00","");
INSERT INTO tbl_expensesde VALUES("3235","0","465","103","200.00","DULAL");
INSERT INTO tbl_expensesde VALUES("3236","0","465","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3237","0","465","87","1000.00","SHOHRAB");
INSERT INTO tbl_expensesde VALUES("3238","0","465","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3239","0","465","156","170.00","");
INSERT INTO tbl_expensesde VALUES("3240","0","465","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3241","0","465","149","420.00","SS PIPE");
INSERT INTO tbl_expensesde VALUES("3242","0","465","44","255.00","");
INSERT INTO tbl_expensesde VALUES("3243","0","465","160","60.00","");
INSERT INTO tbl_expensesde VALUES("3244","0","465","111","6800.00","TAOWRAS");
INSERT INTO tbl_expensesde VALUES("3245","0","465","160","300.00","");
INSERT INTO tbl_expensesde VALUES("3246","0","465","85","9943.00","");
INSERT INTO tbl_expensesde VALUES("3247","0","465","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3248","0","465","111","650.00","");
INSERT INTO tbl_expensesde VALUES("3249","0","465","103","110.00","POUDER");
INSERT INTO tbl_expensesde VALUES("3250","0","465","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3251","0","465","111","750.00","");
INSERT INTO tbl_expensesde VALUES("3252","0","466","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3253","0","466","19","60.00","");
INSERT INTO tbl_expensesde VALUES("3254","0","466","157","240.00","");
INSERT INTO tbl_expensesde VALUES("3255","0","466","149","1500.00","rubel");
INSERT INTO tbl_expensesde VALUES("3256","0","466","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3257","0","466","111","750.00","");
INSERT INTO tbl_expensesde VALUES("3258","0","466","87","500.00","");
INSERT INTO tbl_expensesde VALUES("3259","0","466","158","70.00","");
INSERT INTO tbl_expensesde VALUES("3260","0","466","170","500.00","");
INSERT INTO tbl_expensesde VALUES("3261","0","467","86","9335.00","");
INSERT INTO tbl_expensesde VALUES("3262","0","467","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3263","0","467","157","70.00","");
INSERT INTO tbl_expensesde VALUES("3264","0","467","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3265","0","467","170","200.00","");
INSERT INTO tbl_expensesde VALUES("3266","0","467","111","50.00","");
INSERT INTO tbl_expensesde VALUES("3267","0","467","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3268","0","467","170","1025.00","");
INSERT INTO tbl_expensesde VALUES("3269","0","467","170","50.00","");
INSERT INTO tbl_expensesde VALUES("3270","0","467","170","20.00","");
INSERT INTO tbl_expensesde VALUES("3271","0","467","170","700.00","PATH KHERY");
INSERT INTO tbl_expensesde VALUES("3272","0","467","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3273","0","467","149","610.00","");
INSERT INTO tbl_expensesde VALUES("3274","0","467","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3275","0","467","85","3750.00","");
INSERT INTO tbl_expensesde VALUES("3276","0","467","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3277","0","467","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3278","0","468","158","140.00","");
INSERT INTO tbl_expensesde VALUES("3279","0","468","157","230.00","");
INSERT INTO tbl_expensesde VALUES("3280","0","468","95","80.00","");
INSERT INTO tbl_expensesde VALUES("3281","0","468","170","40.00","");
INSERT INTO tbl_expensesde VALUES("3282","0","468","165","7650.00","");
INSERT INTO tbl_expensesde VALUES("3283","0","468","86","5220.00","");
INSERT INTO tbl_expensesde VALUES("3284","0","468","170","640.00","");
INSERT INTO tbl_expensesde VALUES("3285","0","468","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3286","0","468","103","4010.00","RECSIN,ATHA");
INSERT INTO tbl_expensesde VALUES("3287","0","468","15","30.00","");
INSERT INTO tbl_expensesde VALUES("3288","0","469","158","110.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3289","0","469","109","650.00","হলুদের গুরা");
INSERT INTO tbl_expensesde VALUES("3290","0","469","137","250.00","খাবার+পৌর কর");
INSERT INTO tbl_expensesde VALUES("3291","0","469","109","840.00","ডিম+রসুন+আদা");
INSERT INTO tbl_expensesde VALUES("3292","0","469","145","500.00","বাসায় কাকি");
INSERT INTO tbl_expensesde VALUES("3293","0","469","137","1775.00","মিষ্টি+দধি+ফল");
INSERT INTO tbl_expensesde VALUES("3294","0","469","103","1050.00","ফিল্টার মেরামত");
INSERT INTO tbl_expensesde VALUES("3295","0","469","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3296","0","469","111","3910.00","");
INSERT INTO tbl_expensesde VALUES("3297","0","469","85","9010.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3298","0","469","16","20087.00","বাসায়");
INSERT INTO tbl_expensesde VALUES("3299","0","469","16","768.00","শাহীন");
INSERT INTO tbl_expensesde VALUES("3300","0","469","92","50.00","");
INSERT INTO tbl_expensesde VALUES("3301","0","469","145","10000.00","");
INSERT INTO tbl_expensesde VALUES("3302","0","469","103","150.00","দুলাল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("3303","0","469","137","260.00","কেরোসিন");
INSERT INTO tbl_expensesde VALUES("3304","0","470","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3305","0","470","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3306","0","471","149","340.00","AIKA ATHTA");
INSERT INTO tbl_expensesde VALUES("3307","0","471","149","210.00","");
INSERT INTO tbl_expensesde VALUES("3308","0","471","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3309","0","471","95","80.00","");
INSERT INTO tbl_expensesde VALUES("3310","0","471","160","100.00","");
INSERT INTO tbl_expensesde VALUES("3311","0","471","170","160.00","");
INSERT INTO tbl_expensesde VALUES("3312","0","472","156","100.00","");
INSERT INTO tbl_expensesde VALUES("3313","0","472","157","120.00","");
INSERT INTO tbl_expensesde VALUES("3314","0","472","149","580.00","");
INSERT INTO tbl_expensesde VALUES("3315","0","472","160","300.00","");
INSERT INTO tbl_expensesde VALUES("3316","0","472","158","230.00","");
INSERT INTO tbl_expensesde VALUES("3317","0","472","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3318","0","473","157","70.00","");
INSERT INTO tbl_expensesde VALUES("3319","0","473","111","750.00","709");
INSERT INTO tbl_expensesde VALUES("3320","0","473","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3321","0","473","164","17100.00","");
INSERT INTO tbl_expensesde VALUES("3322","0","473","170","1825.00","");
INSERT INTO tbl_expensesde VALUES("3323","0","473","19","150.00","SABAN");
INSERT INTO tbl_expensesde VALUES("3324","0","473","160","80.00","");
INSERT INTO tbl_expensesde VALUES("3325","0","473","16","763573.00","");
INSERT INTO tbl_expensesde VALUES("3326","0","474","111","900.00","709");
INSERT INTO tbl_expensesde VALUES("3327","0","474","156","170.00","");
INSERT INTO tbl_expensesde VALUES("3328","0","474","164","17350.00","");
INSERT INTO tbl_expensesde VALUES("3329","0","474","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3330","0","474","149","11500.00","");
INSERT INTO tbl_expensesde VALUES("3331","0","474","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3332","0","474","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3333","0","475","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3334","0","476","27","200.00","");
INSERT INTO tbl_expensesde VALUES("3335","0","476","170","100.00","");
INSERT INTO tbl_expensesde VALUES("3336","0","476","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3337","0","476","170","1190.00","");
INSERT INTO tbl_expensesde VALUES("3338","0","476","111","4340.00","TATA");
INSERT INTO tbl_expensesde VALUES("3339","0","476","91","800.00","DRIVER+HELPER");
INSERT INTO tbl_expensesde VALUES("3340","0","476","179","2000.00","");
INSERT INTO tbl_expensesde VALUES("3341","0","476","103","8510.00","");
INSERT INTO tbl_expensesde VALUES("3342","0","476","85","8700.00","TAOURAS");
INSERT INTO tbl_expensesde VALUES("3343","0","476","91","1850.00","");
INSERT INTO tbl_expensesde VALUES("3344","0","476","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3345","0","476","27","40.00","");
INSERT INTO tbl_expensesde VALUES("3346","0","477","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3347","0","477","86","5940.00","");
INSERT INTO tbl_expensesde VALUES("3348","0","477","103","850.00","মালামাল +দুলাল");
INSERT INTO tbl_expensesde VALUES("3349","0","477","109","580.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3350","0","477","86","80.00","");
INSERT INTO tbl_expensesde VALUES("3351","0","478","158","90.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3352","0","478","92","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3353","0","478","152","30.00","");
INSERT INTO tbl_expensesde VALUES("3354","0","478","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("3355","0","478","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("3356","0","478","158","300.00","সজিব");
INSERT INTO tbl_expensesde VALUES("3357","0","478","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3358","0","478","167","1750.00","");
INSERT INTO tbl_expensesde VALUES("3359","0","478","158","50.00","");
INSERT INTO tbl_expensesde VALUES("3360","0","478","150","180.00","ডিল ভিট");
INSERT INTO tbl_expensesde VALUES("3361","0","478","137","1060.00","প্রিন্টার মেশিন মেরামত");
INSERT INTO tbl_expensesde VALUES("3362","0","478","137","600.00","হেড বাল্ব");
INSERT INTO tbl_expensesde VALUES("3363","0","478","150","250.00","নাট");
INSERT INTO tbl_expensesde VALUES("3364","0","478","109","370.00","ডিম");
INSERT INTO tbl_expensesde VALUES("3365","0","478","90","360.00","");
INSERT INTO tbl_expensesde VALUES("3366","0","478","109","3850.00","জিরা,রসুন,কাচা মরিচ,আলু");
INSERT INTO tbl_expensesde VALUES("3367","0","478","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3368","0","478","152","290.00","");
INSERT INTO tbl_expensesde VALUES("3369","0","479","111","890.00","");
INSERT INTO tbl_expensesde VALUES("3370","0","479","111","760.00","");
INSERT INTO tbl_expensesde VALUES("3371","0","479","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3372","0","479","27","40.00","");
INSERT INTO tbl_expensesde VALUES("3373","0","479","170","100.00","");
INSERT INTO tbl_expensesde VALUES("3374","0","479","158","100.00","");
INSERT INTO tbl_expensesde VALUES("3375","0","479","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3376","0","480","87","1000.00","MONIR");
INSERT INTO tbl_expensesde VALUES("3377","0","480","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3378","0","480","103","300.00","CHAKKA");
INSERT INTO tbl_expensesde VALUES("3379","0","480","103","250.00","JALAY");
INSERT INTO tbl_expensesde VALUES("3380","0","480","179","100.00","");
INSERT INTO tbl_expensesde VALUES("3381","0","480","103","1500.00","BEARING");
INSERT INTO tbl_expensesde VALUES("3382","0","480","103","500.00","");
INSERT INTO tbl_expensesde VALUES("3383","0","480","158","150.00","");
INSERT INTO tbl_expensesde VALUES("3384","0","480","103","500.00","TANKI");
INSERT INTO tbl_expensesde VALUES("3385","0","480","19","110.00","");
INSERT INTO tbl_expensesde VALUES("3386","0","480","103","200.00","DUALAL");
INSERT INTO tbl_expensesde VALUES("3387","0","480","149","2100.00","");
INSERT INTO tbl_expensesde VALUES("3388","0","480","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3389","0","480","86","9690.00","");
INSERT INTO tbl_expensesde VALUES("3390","0","480","85","10630.00","TATA");
INSERT INTO tbl_expensesde VALUES("3391","0","480","170","350.00","");
INSERT INTO tbl_expensesde VALUES("3392","0","481","158","70.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3393","0","481","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3394","0","481","109","1500.00","ডিম,তেল,মুগ ডাল");
INSERT INTO tbl_expensesde VALUES("3395","0","481","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3396","0","481","137","3600.00","সেলাই মেশিন মেরামত");
INSERT INTO tbl_expensesde VALUES("3397","0","481","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3398","0","481","111","4400.00","");
INSERT INTO tbl_expensesde VALUES("3399","0","481","137","20.00","সুপার গ্লু");
INSERT INTO tbl_expensesde VALUES("3400","0","481","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3401","0","481","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("3402","0","481","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("3403","0","482","19","110.00","");
INSERT INTO tbl_expensesde VALUES("3404","0","482","157","200.00","");
INSERT INTO tbl_expensesde VALUES("3405","0","483","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3406","0","483","157","560.00","");
INSERT INTO tbl_expensesde VALUES("3407","0","483","156","30.00","");
INSERT INTO tbl_expensesde VALUES("3408","0","483","86","13890.00","");
INSERT INTO tbl_expensesde VALUES("3409","0","483","87","1000.00","shahin");
INSERT INTO tbl_expensesde VALUES("3410","0","483","111","850.00","");
INSERT INTO tbl_expensesde VALUES("3411","0","483","156","400.00","");
INSERT INTO tbl_expensesde VALUES("3412","0","483","170","400.00","");
INSERT INTO tbl_expensesde VALUES("3413","0","483","158","80.00","");
INSERT INTO tbl_expensesde VALUES("3414","0","483","86","25.00","");
INSERT INTO tbl_expensesde VALUES("3415","0","483","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3416","0","483","87","500.00","MINTU");
INSERT INTO tbl_expensesde VALUES("3417","0","484","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("3418","0","484","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3419","0","484","158","70.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3420","0","484","111","4320.00","টাটা");
INSERT INTO tbl_expensesde VALUES("3421","0","484","158","140.00","");
INSERT INTO tbl_expensesde VALUES("3422","0","484","109","1500.00","মুরগি+ডিম+ মসলা");
INSERT INTO tbl_expensesde VALUES("3423","0","484","158","50.00","");
INSERT INTO tbl_expensesde VALUES("3424","0","485","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3425","0","485","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3426","0","485","157","80.00","");
INSERT INTO tbl_expensesde VALUES("3427","0","485","157","240.00","SUMON");
INSERT INTO tbl_expensesde VALUES("3428","0","485","149","15600.00","");
INSERT INTO tbl_expensesde VALUES("3429","0","485","20","170.00","");
INSERT INTO tbl_expensesde VALUES("3430","0","485","103","500.00","LED BILL");
INSERT INTO tbl_expensesde VALUES("3431","0","485","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3432","0","485","103","7000.00","BONUTKOBJA,LOCK");
INSERT INTO tbl_expensesde VALUES("3433","0","486","103","2800.00","HASAN");
INSERT INTO tbl_expensesde VALUES("3434","0","486","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3435","0","486","111","360.00","");
INSERT INTO tbl_expensesde VALUES("3436","0","486","170","370.00","");
INSERT INTO tbl_expensesde VALUES("3437","0","487","158","60.00","");
INSERT INTO tbl_expensesde VALUES("3438","0","487","85","10010.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3439","0","487","85","8450.00","টাটা");
INSERT INTO tbl_expensesde VALUES("3440","0","487","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("3441","0","487","158","100.00","");
INSERT INTO tbl_expensesde VALUES("3442","0","487","164","19800.00","");
INSERT INTO tbl_expensesde VALUES("3443","0","487","156","160.00","");
INSERT INTO tbl_expensesde VALUES("3444","0","487","109","1205.00","ডিম,মুগ ডাল,আদা");
INSERT INTO tbl_expensesde VALUES("3445","0","487","90","225.00","");
INSERT INTO tbl_expensesde VALUES("3446","0","487","158","100.00","");
INSERT INTO tbl_expensesde VALUES("3447","0","487","90","80.00","");
INSERT INTO tbl_expensesde VALUES("3448","0","487","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3449","0","487","164","19800.00","");
INSERT INTO tbl_expensesde VALUES("3450","0","487","162","200.00","");
INSERT INTO tbl_expensesde VALUES("3451","0","487","90","600.00","");
INSERT INTO tbl_expensesde VALUES("3452","0","487","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("3453","0","487","150","60.00","ফিউজ");
INSERT INTO tbl_expensesde VALUES("3454","0","487","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3455","0","488","13","230.00","");
INSERT INTO tbl_expensesde VALUES("3456","0","488","111","350.00","");
INSERT INTO tbl_expensesde VALUES("3457","0","488","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3458","0","488","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3459","0","488","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3460","0","488","157","200.00","MISTRI");
INSERT INTO tbl_expensesde VALUES("3461","0","488","167","1800.00","");
INSERT INTO tbl_expensesde VALUES("3462","0","488","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3463","0","488","170","210.00","");
INSERT INTO tbl_expensesde VALUES("3464","0","488","15","50.00","");
INSERT INTO tbl_expensesde VALUES("3465","0","488","86","11240.00","");
INSERT INTO tbl_expensesde VALUES("3466","0","488","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3467","0","489","158","100.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3468","0","489","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3469","0","489","99","990.00","");
INSERT INTO tbl_expensesde VALUES("3470","0","489","111","350.00","");
INSERT INTO tbl_expensesde VALUES("3471","0","489","111","4060.00","");
INSERT INTO tbl_expensesde VALUES("3472","0","489","85","4210.00","");
INSERT INTO tbl_expensesde VALUES("3473","0","489","111","4100.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3474","0","489","87","500.00","");
INSERT INTO tbl_expensesde VALUES("3475","0","489","109","2390.00","ডিম+মুরগি+তেল");
INSERT INTO tbl_expensesde VALUES("3476","0","489","150","690.00","সেইব+বল্টু");
INSERT INTO tbl_expensesde VALUES("3477","0","489","90","320.00","");
INSERT INTO tbl_expensesde VALUES("3478","0","490","149","50000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("3479","0","490","85","9410.00","");
INSERT INTO tbl_expensesde VALUES("3480","0","490","111","850.00","");
INSERT INTO tbl_expensesde VALUES("3481","0","490","87","5000.00","");
INSERT INTO tbl_expensesde VALUES("3482","0","490","103","150.00","TYRE MERAMAT");
INSERT INTO tbl_expensesde VALUES("3483","0","490","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3484","0","490","91","1200.00","");
INSERT INTO tbl_expensesde VALUES("3485","0","490","157","40.00","RASED");
INSERT INTO tbl_expensesde VALUES("3486","0","490","158","60.00","");
INSERT INTO tbl_expensesde VALUES("3487","0","490","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3488","0","490","103","300.00","");
INSERT INTO tbl_expensesde VALUES("3489","0","491","156","100.00","");
INSERT INTO tbl_expensesde VALUES("3490","0","491","109","550.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3491","0","491","158","70.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3492","0","491","92","100.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3493","0","491","109","1915.00","মাছ");
INSERT INTO tbl_expensesde VALUES("3494","0","491","85","11100.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3495","0","491","162","1200.00","");
INSERT INTO tbl_expensesde VALUES("3496","0","491","109","650.00","হলুদের গুড়া +মরিচের গুড়া");
INSERT INTO tbl_expensesde VALUES("3497","0","491","109","380.00","ডিম");
INSERT INTO tbl_expensesde VALUES("3498","0","491","158","180.00","");
INSERT INTO tbl_expensesde VALUES("3499","0","491","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3500","0","491","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3501","0","491","164","18700.00","");
INSERT INTO tbl_expensesde VALUES("3502","0","491","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3503","0","491","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3504","0","491","103","3450.00","তাউরাস গেট বাবদ");
INSERT INTO tbl_expensesde VALUES("3505","0","491","164","17200.00","");
INSERT INTO tbl_expensesde VALUES("3506","0","491","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3507","0","491","103","1500.00","গ্রীজ");
INSERT INTO tbl_expensesde VALUES("3508","0","491","152","100.00","+ কম্পিউটর");
INSERT INTO tbl_expensesde VALUES("3509","0","492","158","100.00","");
INSERT INTO tbl_expensesde VALUES("3510","0","492","82","150.00","");
INSERT INTO tbl_expensesde VALUES("3511","0","492","158","90.00","");
INSERT INTO tbl_expensesde VALUES("3512","0","492","95","240.00","");
INSERT INTO tbl_expensesde VALUES("3513","0","492","111","1200.00","");
INSERT INTO tbl_expensesde VALUES("3514","0","492","87","132995.00","");
INSERT INTO tbl_expensesde VALUES("3515","0","493","149","4000.00","RUBEL MISTRI");
INSERT INTO tbl_expensesde VALUES("3516","0","493","157","200.00","");
INSERT INTO tbl_expensesde VALUES("3517","0","493","87","10750.00","");
INSERT INTO tbl_expensesde VALUES("3518","0","493","156","100.00","");
INSERT INTO tbl_expensesde VALUES("3519","0","493","91","2440.00","");
INSERT INTO tbl_expensesde VALUES("3520","0","493","157","260.00","");
INSERT INTO tbl_expensesde VALUES("3521","0","493","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3522","0","493","87","5000.00","");
INSERT INTO tbl_expensesde VALUES("3523","0","493","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("3524","0","493","87","8000.00","");
INSERT INTO tbl_expensesde VALUES("3525","0","493","19","500.00","");
INSERT INTO tbl_expensesde VALUES("3526","0","493","86","16470.00","");
INSERT INTO tbl_expensesde VALUES("3527","0","493","111","850.00","");
INSERT INTO tbl_expensesde VALUES("3528","0","493","85","6010.00","709");
INSERT INTO tbl_expensesde VALUES("3529","0","494","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3530","0","494","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3531","0","494","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3532","0","494","170","760.00","");
INSERT INTO tbl_expensesde VALUES("3533","0","494","162","200.00","");
INSERT INTO tbl_expensesde VALUES("3534","0","494","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("3535","0","494","87","4500.00","");
INSERT INTO tbl_expensesde VALUES("3536","0","494","91","100.00","");
INSERT INTO tbl_expensesde VALUES("3537","0","494","87","3000.00","");
INSERT INTO tbl_expensesde VALUES("3538","0","494","164","17730.00","");
INSERT INTO tbl_expensesde VALUES("3539","0","494","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3540","0","494","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3541","0","494","87","4500.00","");
INSERT INTO tbl_expensesde VALUES("3542","0","494","91","3760.00","");
INSERT INTO tbl_expensesde VALUES("3543","0","494","111","4800.00","");
INSERT INTO tbl_expensesde VALUES("3544","0","494","87","8500.00","");
INSERT INTO tbl_expensesde VALUES("3545","0","494","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3546","0","494","103","100.00","");
INSERT INTO tbl_expensesde VALUES("3547","0","494","87","7500.00","");
INSERT INTO tbl_expensesde VALUES("3548","0","494","91","300.00","");
INSERT INTO tbl_expensesde VALUES("3549","0","494","170","380.00","");
INSERT INTO tbl_expensesde VALUES("3550","0","494","170","380.00","");
INSERT INTO tbl_expensesde VALUES("3551","0","494","73","1500.00","");
INSERT INTO tbl_expensesde VALUES("3552","0","495","86","10280.00","");
INSERT INTO tbl_expensesde VALUES("3553","0","495","87","2000.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("3554","0","496","87","2000.00","SAHIN");
INSERT INTO tbl_expensesde VALUES("3555","0","496","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3556","0","496","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3557","0","496","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3558","0","497","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("3559","0","497","92","170.00","+ভাড়া");
INSERT INTO tbl_expensesde VALUES("3560","0","497","87","5000.00","");
INSERT INTO tbl_expensesde VALUES("3561","0","497","109","1990.00","আদা+রসুন+জিরা+মুগডাল");
INSERT INTO tbl_expensesde VALUES("3562","0","497","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3563","0","497","103","920.00","পাওয়ার হাইড্রোলিক+নজেল");
INSERT INTO tbl_expensesde VALUES("3564","0","497","152","30.00","");
INSERT INTO tbl_expensesde VALUES("3565","0","497","158","70.00","");
INSERT INTO tbl_expensesde VALUES("3566","0","497","85","4960.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3567","0","497","21","1000.00","");
INSERT INTO tbl_expensesde VALUES("3568","0","498","171","40.00","");
INSERT INTO tbl_expensesde VALUES("3569","0","498","87","3500.00","AMDAD");
INSERT INTO tbl_expensesde VALUES("3570","0","498","111","350.00","");
INSERT INTO tbl_expensesde VALUES("3571","0","498","149","400.00","OIL");
INSERT INTO tbl_expensesde VALUES("3572","0","498","149","670.00","TER");
INSERT INTO tbl_expensesde VALUES("3573","0","498","87","200.00","KAMAL MEDECINE");
INSERT INTO tbl_expensesde VALUES("3574","0","498","103","3000.00","RING,16 PC");
INSERT INTO tbl_expensesde VALUES("3575","0","498","170","390.00","");
INSERT INTO tbl_expensesde VALUES("3576","0","498","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3577","0","499","15","50.00","");
INSERT INTO tbl_expensesde VALUES("3578","0","499","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3579","0","499","91","1350.00","");
INSERT INTO tbl_expensesde VALUES("3580","0","499","86","6430.00","");
INSERT INTO tbl_expensesde VALUES("3581","0","499","27","200.00","HASAN");
INSERT INTO tbl_expensesde VALUES("3582","0","500","158","200.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("3583","0","500","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3584","0","500","149","1200.00","GAS OARLING");
INSERT INTO tbl_expensesde VALUES("3585","0","500","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3586","0","500","170","200.00","");
INSERT INTO tbl_expensesde VALUES("3587","0","500","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3588","0","500","19","135.00","");
INSERT INTO tbl_expensesde VALUES("3589","0","500","111","1300.00","");
INSERT INTO tbl_expensesde VALUES("3590","0","500","87","7000.00","SOHRAB");
INSERT INTO tbl_expensesde VALUES("3591","0","501","109","1145.00","কাচা মরিচ+তেল+মসল্লা");
INSERT INTO tbl_expensesde VALUES("3592","0","501","85","3700.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3593","0","501","85","10500.00","ইসমাইল");
INSERT INTO tbl_expensesde VALUES("3594","0","501","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("3595","0","501","87","5000.00","");
INSERT INTO tbl_expensesde VALUES("3596","0","501","87","7000.00","");
INSERT INTO tbl_expensesde VALUES("3597","0","501","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("3598","0","501","137","200.00","জি আই নেট ভাড়া");
INSERT INTO tbl_expensesde VALUES("3599","0","502","157","240.00","");
INSERT INTO tbl_expensesde VALUES("3600","0","502","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3601","0","502","158","15.00","");
INSERT INTO tbl_expensesde VALUES("3602","0","502","15","28.00","");
INSERT INTO tbl_expensesde VALUES("3603","0","502","15","30.00","");
INSERT INTO tbl_expensesde VALUES("3604","0","502","149","1930.00","B BELT");
INSERT INTO tbl_expensesde VALUES("3605","0","502","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3606","0","502","91","1350.00","");
INSERT INTO tbl_expensesde VALUES("3607","0","502","91","460.00","");
INSERT INTO tbl_expensesde VALUES("3608","0","502","86","13195.00","");
INSERT INTO tbl_expensesde VALUES("3609","0","502","15","400.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("3610","0","502","23","2000.00","KAMAL ");
INSERT INTO tbl_expensesde VALUES("3611","0","503","158","270.00","OMS");
INSERT INTO tbl_expensesde VALUES("3612","0","503","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3613","0","503","156","150.00","");
INSERT INTO tbl_expensesde VALUES("3614","0","503","170","380.00","");
INSERT INTO tbl_expensesde VALUES("3615","0","503","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("3616","0","503","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3617","0","503","149","5000.00","BAKUL,MOTOR,OTHER MAL");
INSERT INTO tbl_expensesde VALUES("3618","0","503","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3619","0","503","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3620","0","503","111","550.00","MONIR");
INSERT INTO tbl_expensesde VALUES("3621","0","504","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3622","0","504","91","660.00","");
INSERT INTO tbl_expensesde VALUES("3623","0","504","111","550.00","");
INSERT INTO tbl_expensesde VALUES("3624","0","504","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3625","0","504","95","240.00","");
INSERT INTO tbl_expensesde VALUES("3626","0","504","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3627","0","505","103","800.00","709 OAWARING MISTRI");
INSERT INTO tbl_expensesde VALUES("3628","0","506","167","3400.00","");
INSERT INTO tbl_expensesde VALUES("3629","0","506","86","18000.00","sarder salary");
INSERT INTO tbl_expensesde VALUES("3630","0","506","86","8700.00","");
INSERT INTO tbl_expensesde VALUES("3631","0","506","170","450.00","");
INSERT INTO tbl_expensesde VALUES("3632","0","506","170","3200.00","alu");
INSERT INTO tbl_expensesde VALUES("3633","0","506","19","450.00","");
INSERT INTO tbl_expensesde VALUES("3634","0","506","170","1460.00","rice");
INSERT INTO tbl_expensesde VALUES("3635","0","506","158","60.00","");
INSERT INTO tbl_expensesde VALUES("3636","0","507","158","200.00","");
INSERT INTO tbl_expensesde VALUES("3637","0","507","92","180.00","");
INSERT INTO tbl_expensesde VALUES("3638","0","507","103","950.00","ক্যাবল+পাইপ মনির");
INSERT INTO tbl_expensesde VALUES("3639","0","507","103","200.00","দুলাল");
INSERT INTO tbl_expensesde VALUES("3640","0","507","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3641","0","507","92","170.00","+খাবার সাগর");
INSERT INTO tbl_expensesde VALUES("3642","0","507","109","1500.00","মুরগি+ডিম+মসল্লা");
INSERT INTO tbl_expensesde VALUES("3643","0","507","137","1500.00","লাইসেন্স বাবদ");
INSERT INTO tbl_expensesde VALUES("3644","0","507","85","5000.00","709");
INSERT INTO tbl_expensesde VALUES("3645","0","507","87","200.00","");
INSERT INTO tbl_expensesde VALUES("3646","0","507","90","20.00","");
INSERT INTO tbl_expensesde VALUES("3647","0","507","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("3648","0","507","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3649","0","507","111","540.00","");
INSERT INTO tbl_expensesde VALUES("3650","0","507","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3651","0","508","170","320.00","");
INSERT INTO tbl_expensesde VALUES("3652","0","508","91","900.00","");
INSERT INTO tbl_expensesde VALUES("3653","0","508","157","230.00","");
INSERT INTO tbl_expensesde VALUES("3654","0","508","103","2210.00","RABER KUSUM");
INSERT INTO tbl_expensesde VALUES("3655","0","508","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3656","0","508","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3657","0","509","156","160.00","");
INSERT INTO tbl_expensesde VALUES("3658","0","509","91","1000.00","");
INSERT INTO tbl_expensesde VALUES("3659","0","509","157","170.00","");
INSERT INTO tbl_expensesde VALUES("3660","0","509","111","6070.00","taoras");
INSERT INTO tbl_expensesde VALUES("3661","0","509","111","4740.00","tata");
INSERT INTO tbl_expensesde VALUES("3662","0","509","87","800.00","mintu");
INSERT INTO tbl_expensesde VALUES("3663","0","509","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3664","0","509","149","19600.00","");
INSERT INTO tbl_expensesde VALUES("3665","0","509","162","800.00","");
INSERT INTO tbl_expensesde VALUES("3666","0","509","149","4500.00","B BELT");
INSERT INTO tbl_expensesde VALUES("3667","0","509","23","4557.00","KAMAL");
INSERT INTO tbl_expensesde VALUES("3668","0","509","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3669","0","509","111","250.00","");
INSERT INTO tbl_expensesde VALUES("3670","0","509","103","6900.00","MA BABA");
INSERT INTO tbl_expensesde VALUES("3671","0","509","103","4000.00","SAHARA");
INSERT INTO tbl_expensesde VALUES("3672","0","510","103","9750.00","");
INSERT INTO tbl_expensesde VALUES("3673","0","510","170","150.00","");
INSERT INTO tbl_expensesde VALUES("3674","0","510","87","1500.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("3675","0","510","170","760.00","EGG-2");
INSERT INTO tbl_expensesde VALUES("3676","0","510","170","100.00","");
INSERT INTO tbl_expensesde VALUES("3677","0","510","91","900.00","");
INSERT INTO tbl_expensesde VALUES("3678","0","510","157","140.00","");
INSERT INTO tbl_expensesde VALUES("3679","0","510","87","4500.00","FARHAD");
INSERT INTO tbl_expensesde VALUES("3680","0","510","157","310.00","");
INSERT INTO tbl_expensesde VALUES("3681","0","510","91","460.00","");
INSERT INTO tbl_expensesde VALUES("3682","0","511","137","20.00","আঠা");
INSERT INTO tbl_expensesde VALUES("3683","0","511","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3684","0","511","86","15790.00","");
INSERT INTO tbl_expensesde VALUES("3685","0","512","111","1000.00","");
INSERT INTO tbl_expensesde VALUES("3686","0","512","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3687","0","512","87","500.00","");
INSERT INTO tbl_expensesde VALUES("3688","0","512","158","170.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3689","0","512","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3690","0","512","109","1180.00","তেল+ডিম");
INSERT INTO tbl_expensesde VALUES("3691","0","512","152","200.00","");
INSERT INTO tbl_expensesde VALUES("3692","0","512","111","830.00","");
INSERT INTO tbl_expensesde VALUES("3693","0","512","111","870.00","");
INSERT INTO tbl_expensesde VALUES("3694","0","512","87","500.00","");
INSERT INTO tbl_expensesde VALUES("3695","0","512","87","1500.00","");
INSERT INTO tbl_expensesde VALUES("3696","0","512","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("3697","0","512","137","260.00","পাতিল ক্রয়");
INSERT INTO tbl_expensesde VALUES("3698","0","512","150","120.00","সকেট প্লাগ");
INSERT INTO tbl_expensesde VALUES("3699","0","512","109","470.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3700","0","512","92","50.00","");
INSERT INTO tbl_expensesde VALUES("3701","0","513","103","3400.00","");
INSERT INTO tbl_expensesde VALUES("3702","0","513","27","25.00","");
INSERT INTO tbl_expensesde VALUES("3703","0","513","157","240.00","");
INSERT INTO tbl_expensesde VALUES("3704","0","513","87","15000.00","");
INSERT INTO tbl_expensesde VALUES("3705","0","513","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3706","0","513","86","8850.00","");
INSERT INTO tbl_expensesde VALUES("3707","0","513","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("3708","0","513","87","500.00","HELPER JAHANGIR");
INSERT INTO tbl_expensesde VALUES("3709","0","513","103","6000.00","");
INSERT INTO tbl_expensesde VALUES("3710","0","513","87","500.00","RABBI");
INSERT INTO tbl_expensesde VALUES("3711","0","513","157","230.00","");
INSERT INTO tbl_expensesde VALUES("3712","0","513","91","350.00","");
INSERT INTO tbl_expensesde VALUES("3713","0","513","149","25000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("3714","0","513","103","200.00","GRIZ");
INSERT INTO tbl_expensesde VALUES("3715","0","513","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3716","0","513","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3717","0","513","19","60.00","");
INSERT INTO tbl_expensesde VALUES("3718","0","514","87","1500.00","");
INSERT INTO tbl_expensesde VALUES("3719","0","514","86","8850.00","");
INSERT INTO tbl_expensesde VALUES("3720","0","514","85","3400.00","টাটা");
INSERT INTO tbl_expensesde VALUES("3721","0","514","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3722","0","515","158","80.00","");
INSERT INTO tbl_expensesde VALUES("3723","0","515","158","100.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3724","0","515","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3725","0","515","87","200.00","");
INSERT INTO tbl_expensesde VALUES("3726","0","515","109","820.00","মুরগি+মসলা");
INSERT INTO tbl_expensesde VALUES("3727","0","515","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3728","0","515","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3729","0","515","92","100.00","");
INSERT INTO tbl_expensesde VALUES("3730","0","515","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("3731","0","515","137","430.00","A4 কাগজ");
INSERT INTO tbl_expensesde VALUES("3732","0","515","91","300.00","");
INSERT INTO tbl_expensesde VALUES("3733","0","515","92","120.00","+ভাড়া");
INSERT INTO tbl_expensesde VALUES("3734","0","515","137","50.00","কয়েল");
INSERT INTO tbl_expensesde VALUES("3735","0","515","138","5100.00","");
INSERT INTO tbl_expensesde VALUES("3736","0","515","109","430.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3737","0","515","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3738","0","515","86","5470.00","");
INSERT INTO tbl_expensesde VALUES("3739","0","516","167","1200.00","");
INSERT INTO tbl_expensesde VALUES("3740","0","516","87","2000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("3741","0","516","15","70.00","");
INSERT INTO tbl_expensesde VALUES("3742","0","517","149","25000.00","rubel malamal");
INSERT INTO tbl_expensesde VALUES("3743","0","517","103","200.00","griz");
INSERT INTO tbl_expensesde VALUES("3744","0","517","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3745","0","517","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3746","0","517","20","60.00","");
INSERT INTO tbl_expensesde VALUES("3747","0","518","111","7380.00","tata");
INSERT INTO tbl_expensesde VALUES("3748","0","518","91","800.00","");
INSERT INTO tbl_expensesde VALUES("3749","0","518","170","395.00","");
INSERT INTO tbl_expensesde VALUES("3750","0","518","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3751","0","518","149","205.00","");
INSERT INTO tbl_expensesde VALUES("3752","0","518","157","50.00","");
INSERT INTO tbl_expensesde VALUES("3753","0","518","103","1950.00","");
INSERT INTO tbl_expensesde VALUES("3754","0","518","103","3400.00","");
INSERT INTO tbl_expensesde VALUES("3755","0","518","86","1440.00","");
INSERT INTO tbl_expensesde VALUES("3756","0","518","157","300.00","");
INSERT INTO tbl_expensesde VALUES("3757","0","519","109","150.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3758","0","519","92","60.00","+ভাড়া");
INSERT INTO tbl_expensesde VALUES("3759","0","519","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3760","0","519","111","3600.00","তাওরাস");
INSERT INTO tbl_expensesde VALUES("3761","0","519","109","1343.00","তেল+ডিম");
INSERT INTO tbl_expensesde VALUES("3762","0","519","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3763","0","519","103","600.00","পলিথিন 709");
INSERT INTO tbl_expensesde VALUES("3764","0","519","164","17100.00","");
INSERT INTO tbl_expensesde VALUES("3765","0","519","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3766","0","519","137","1600.00","রেইন কোর্ট");
INSERT INTO tbl_expensesde VALUES("3767","0","519","158","60.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3768","0","519","85","5010.00","মনির");
INSERT INTO tbl_expensesde VALUES("3769","0","520","158","200.00","najimuddin");
INSERT INTO tbl_expensesde VALUES("3770","0","520","158","200.00","najimuddin");
INSERT INTO tbl_expensesde VALUES("3771","0","520","86","240.00","");
INSERT INTO tbl_expensesde VALUES("3772","0","520","91","920.00","");
INSERT INTO tbl_expensesde VALUES("3773","0","520","170","600.00","");
INSERT INTO tbl_expensesde VALUES("3774","0","520","87","500.00","MINTU");
INSERT INTO tbl_expensesde VALUES("3775","0","520","170","100.00","");
INSERT INTO tbl_expensesde VALUES("3776","0","520","87","500.00","JAHANGIR");
INSERT INTO tbl_expensesde VALUES("3777","0","521","95","240.00","");
INSERT INTO tbl_expensesde VALUES("3778","0","521","87","1500.00","");
INSERT INTO tbl_expensesde VALUES("3779","0","521","85","8830.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3780","0","521","85","3300.00","টাটা");
INSERT INTO tbl_expensesde VALUES("3781","0","521","158","170.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3782","0","522","89","25000.00","DC FOOD");
INSERT INTO tbl_expensesde VALUES("3783","0","522","170","790.00","");
INSERT INTO tbl_expensesde VALUES("3784","0","522","87","1000.00","SAJIB");
INSERT INTO tbl_expensesde VALUES("3785","0","522","85","1400.00","");
INSERT INTO tbl_expensesde VALUES("3786","0","522","158","200.00","");
INSERT INTO tbl_expensesde VALUES("3787","0","522","149","1710.00","B BELT");
INSERT INTO tbl_expensesde VALUES("3788","0","522","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3789","0","522","95","80.00","");
INSERT INTO tbl_expensesde VALUES("3790","0","522","171","30.00","");
INSERT INTO tbl_expensesde VALUES("3791","0","522","85","6010.00","");
INSERT INTO tbl_expensesde VALUES("3792","0","522","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3793","0","522","157","40.00","MOSTAFIZ");
INSERT INTO tbl_expensesde VALUES("3794","0","522","103","920.00","LEBER");
INSERT INTO tbl_expensesde VALUES("3795","0","523","171","20.00","");
INSERT INTO tbl_expensesde VALUES("3796","0","523","111","460.00","");
INSERT INTO tbl_expensesde VALUES("3797","0","523","103","300.00","TERMINAL");
INSERT INTO tbl_expensesde VALUES("3798","0","523","111","500.00","");
INSERT INTO tbl_expensesde VALUES("3799","0","523","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("3800","0","523","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3801","0","523","170","270.00","");
INSERT INTO tbl_expensesde VALUES("3802","0","523","91","450.00","");
INSERT INTO tbl_expensesde VALUES("3803","0","523","15","999.00","");
INSERT INTO tbl_expensesde VALUES("3804","0","523","157","360.00","");
INSERT INTO tbl_expensesde VALUES("3805","0","523","87","2000.00","JINNAT");
INSERT INTO tbl_expensesde VALUES("3806","0","523","111","850.00","");
INSERT INTO tbl_expensesde VALUES("3807","0","523","86","13775.00","");
INSERT INTO tbl_expensesde VALUES("3808","0","524","87","100.00","");
INSERT INTO tbl_expensesde VALUES("3809","0","524","158","200.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3810","0","524","156","200.00","");
INSERT INTO tbl_expensesde VALUES("3811","0","524","156","150.00","");
INSERT INTO tbl_expensesde VALUES("3812","0","524","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3813","0","524","109","1085.00","মুরগি+মসলা");
INSERT INTO tbl_expensesde VALUES("3814","0","524","162","200.00","");
INSERT INTO tbl_expensesde VALUES("3815","0","524","158","270.00","ও এম এস");
INSERT INTO tbl_expensesde VALUES("3816","0","525","137","200.00","মাহিন্দ্র ভাড়া");
INSERT INTO tbl_expensesde VALUES("3817","0","525","152","20.00","");
INSERT INTO tbl_expensesde VALUES("3818","0","525","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3819","0","525","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3820","0","525","92","50.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3821","0","525","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3822","0","526","152","40.00","");
INSERT INTO tbl_expensesde VALUES("3823","0","526","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3824","0","526","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3825","0","526","158","40.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3826","0","526","137","40.00","কয়েল");
INSERT INTO tbl_expensesde VALUES("3827","0","526","92","260.00","");
INSERT INTO tbl_expensesde VALUES("3828","0","526","167","400.00","");
INSERT INTO tbl_expensesde VALUES("3829","0","526","137","110.00","প্রিন্ট পানি");
INSERT INTO tbl_expensesde VALUES("3830","0","526","156","100.00","");
INSERT INTO tbl_expensesde VALUES("3831","0","526","87","5000.00","");
INSERT INTO tbl_expensesde VALUES("3832","0","526","86","8640.00","");
INSERT INTO tbl_expensesde VALUES("3833","0","526","137","545.00","পলি");
INSERT INTO tbl_expensesde VALUES("3834","0","527","85","3200.00","");
INSERT INTO tbl_expensesde VALUES("3835","0","527","109","600.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("3836","0","527","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3837","0","527","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("3838","0","527","109","650.00","হলুদ মরিচের গুড়া");
INSERT INTO tbl_expensesde VALUES("3839","0","527","156","150.00","");
INSERT INTO tbl_expensesde VALUES("3840","0","527","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3841","0","527","109","1200.00","ডিম,আদা রসুন");
INSERT INTO tbl_expensesde VALUES("3842","0","527","137","70.00","টিস্যু");
INSERT INTO tbl_expensesde VALUES("3843","0","527","158","170.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3844","0","527","90","70.00","");
INSERT INTO tbl_expensesde VALUES("3845","0","527","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3846","0","527","103","150.00","দুলাল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("3847","0","528","103","10000.00","");
INSERT INTO tbl_expensesde VALUES("3848","0","528","171","10.00","");
INSERT INTO tbl_expensesde VALUES("3849","0","529","157","40.00","");
INSERT INTO tbl_expensesde VALUES("3850","0","529","87","6915.00","USUF");
INSERT INTO tbl_expensesde VALUES("3851","0","529","170","130.00","");
INSERT INTO tbl_expensesde VALUES("3852","0","529","157","220.00","");
INSERT INTO tbl_expensesde VALUES("3853","0","529","170","430.00","");
INSERT INTO tbl_expensesde VALUES("3854","0","529","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("3855","0","529","149","470.00","BELT  70");
INSERT INTO tbl_expensesde VALUES("3856","0","529","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3857","0","529","111","500.00","709");
INSERT INTO tbl_expensesde VALUES("3858","0","529","86","6095.00","");
INSERT INTO tbl_expensesde VALUES("3859","0","530","137","30.00","প্রিন্ট");
INSERT INTO tbl_expensesde VALUES("3860","0","530","137","70.00","ট্রান্সপোর্ট");
INSERT INTO tbl_expensesde VALUES("3861","0","530","158","80.00","");
INSERT INTO tbl_expensesde VALUES("3862","0","530","111","500.00","");
INSERT INTO tbl_expensesde VALUES("3863","0","530","109","465.00","মুগ ডাল কাচা মরিচ");
INSERT INTO tbl_expensesde VALUES("3864","0","530","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("3865","0","530","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3866","0","530","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3867","0","531","87","7000.00","BASHIR");
INSERT INTO tbl_expensesde VALUES("3868","0","531","158","60.00","");
INSERT INTO tbl_expensesde VALUES("3869","0","531","13","60.00","");
INSERT INTO tbl_expensesde VALUES("3870","0","531","87","1000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("3871","0","531","15","10.00","");
INSERT INTO tbl_expensesde VALUES("3872","0","531","171","25.00","");
INSERT INTO tbl_expensesde VALUES("3873","0","531","157","40.00","NASTA");
INSERT INTO tbl_expensesde VALUES("3874","0","531","149","80.00","DRIL BIT");
INSERT INTO tbl_expensesde VALUES("3875","0","531","158","40.00","");
INSERT INTO tbl_expensesde VALUES("3876","0","531","95","240.00","");
INSERT INTO tbl_expensesde VALUES("3877","0","531","157","100.00","");
INSERT INTO tbl_expensesde VALUES("3878","0","531","87","34910.00","");
INSERT INTO tbl_expensesde VALUES("3879","0","532","87","20165.00","");
INSERT INTO tbl_expensesde VALUES("3880","0","532","156","300.00","");
INSERT INTO tbl_expensesde VALUES("3881","0","532","111","650.00","");
INSERT INTO tbl_expensesde VALUES("3882","0","532","86","8150.00","");
INSERT INTO tbl_expensesde VALUES("3883","0","533","87","4400.00","");
INSERT INTO tbl_expensesde VALUES("3884","0","534","91","500.00","");
INSERT INTO tbl_expensesde VALUES("3885","0","534","87","66270.00","");
INSERT INTO tbl_expensesde VALUES("3886","0","534","87","4500.00","");
INSERT INTO tbl_expensesde VALUES("3887","0","535","86","11000.00","");
INSERT INTO tbl_expensesde VALUES("3888","0","535","111","5950.00","");
INSERT INTO tbl_expensesde VALUES("3889","0","535","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3890","0","535","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("3891","0","536","103","2100.00","দুলাল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("3892","0","537","85","10400.00","তাউরাস");
INSERT INTO tbl_expensesde VALUES("3893","0","537","85","9300.00","টাটা");
INSERT INTO tbl_expensesde VALUES("3894","0","537","158","50.00","");
INSERT INTO tbl_expensesde VALUES("3895","0","537","158","170.00","+ নাস্তা");
INSERT INTO tbl_expensesde VALUES("3896","0","537","152","70.00","");
INSERT INTO tbl_expensesde VALUES("3897","0","537","109","500.00","জিরা মরিচ ডাল");
INSERT INTO tbl_expensesde VALUES("3898","0","537","164","17800.00","");
INSERT INTO tbl_expensesde VALUES("3899","0","537","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("3900","0","537","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3901","0","537","87","3500.00","");
INSERT INTO tbl_expensesde VALUES("3902","0","537","87","3250.00","");
INSERT INTO tbl_expensesde VALUES("3903","0","537","91","30.00","");
INSERT INTO tbl_expensesde VALUES("3904","0","537","111","1050.00","");
INSERT INTO tbl_expensesde VALUES("3905","0","537","109","8940.00","আলু+পেয়াজ");
INSERT INTO tbl_expensesde VALUES("3906","0","537","92","90.00","");
INSERT INTO tbl_expensesde VALUES("3907","0","537","158","200.00","");
INSERT INTO tbl_expensesde VALUES("3908","0","537","86","9815.00","");
INSERT INTO tbl_expensesde VALUES("3909","0","538","149","48500.00","BELT,OIL,NET,TOP PIN");
INSERT INTO tbl_expensesde VALUES("3910","0","538","87","6500.00","");
INSERT INTO tbl_expensesde VALUES("3911","0","538","111","4380.00","TATA");
INSERT INTO tbl_expensesde VALUES("3912","0","538","111","4180.00","TAUORAS");
INSERT INTO tbl_expensesde VALUES("3913","0","538","91","1600.00","");
INSERT INTO tbl_expensesde VALUES("3914","0","538","103","6000.00","");
INSERT INTO tbl_expensesde VALUES("3915","0","538","170","3880.00","");
INSERT INTO tbl_expensesde VALUES("3916","0","538","111","1590.00","");
INSERT INTO tbl_expensesde VALUES("3917","0","538","158","60.00","");
INSERT INTO tbl_expensesde VALUES("3918","0","538","20","15.00","");
INSERT INTO tbl_expensesde VALUES("3919","0","538","171","100.00","");
INSERT INTO tbl_expensesde VALUES("3920","0","538","171","10.00","");
INSERT INTO tbl_expensesde VALUES("3921","0","538","157","270.00","");
INSERT INTO tbl_expensesde VALUES("3922","0","538","157","200.00","");
INSERT INTO tbl_expensesde VALUES("3923","0","538","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3924","0","538","111","760.00","709");
INSERT INTO tbl_expensesde VALUES("3925","0","538","103","100.00","KARASIN");
INSERT INTO tbl_expensesde VALUES("3926","0","538","27","160.00","");
INSERT INTO tbl_expensesde VALUES("3927","0","538","170","340.00","");
INSERT INTO tbl_expensesde VALUES("3928","0","538","20","10000.00","CC CAMERA");
INSERT INTO tbl_expensesde VALUES("3929","0","538","103","200.00","JALAI");
INSERT INTO tbl_expensesde VALUES("3930","0","538","103","400.00","DULAL");
INSERT INTO tbl_expensesde VALUES("3931","0","538","91","1770.00","");
INSERT INTO tbl_expensesde VALUES("3932","0","538","86","9035.00","");
INSERT INTO tbl_expensesde VALUES("3933","0","538","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3934","0","538","111","960.00","DHAKA FOUR MAN");
INSERT INTO tbl_expensesde VALUES("3935","0","539","85","2000.00","monir");
INSERT INTO tbl_expensesde VALUES("3936","0","539","85","8920.00","tata");
INSERT INTO tbl_expensesde VALUES("3937","0","539","85","8000.00","");
INSERT INTO tbl_expensesde VALUES("3938","0","539","158","30.00","");
INSERT INTO tbl_expensesde VALUES("3939","0","539","27","170.00","sagor");
INSERT INTO tbl_expensesde VALUES("3940","0","539","164","74400.00","4 TRUCK");
INSERT INTO tbl_expensesde VALUES("3941","0","539","149","120.00","");
INSERT INTO tbl_expensesde VALUES("3942","0","539","27","110.00","");
INSERT INTO tbl_expensesde VALUES("3943","0","539","170","300.00","");
INSERT INTO tbl_expensesde VALUES("3944","0","539","170","780.00","");
INSERT INTO tbl_expensesde VALUES("3945","0","539","170","25.00","");
INSERT INTO tbl_expensesde VALUES("3946","0","539","171","30.00","");
INSERT INTO tbl_expensesde VALUES("3947","0","539","157","80.00","");
INSERT INTO tbl_expensesde VALUES("3948","0","540","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3949","0","540","165","200.00","");
INSERT INTO tbl_expensesde VALUES("3950","0","540","158","80.00","+ নাস্তা");
INSERT INTO tbl_expensesde VALUES("3951","0","540","111","400.00","");
INSERT INTO tbl_expensesde VALUES("3952","0","540","150","10000.00","মালামালবাবদবকুল কে প্রদান");
INSERT INTO tbl_expensesde VALUES("3953","0","540","111","400.00","");
INSERT INTO tbl_expensesde VALUES("3954","0","540","92","100.00","");
INSERT INTO tbl_expensesde VALUES("3955","0","540","92","240.00","");
INSERT INTO tbl_expensesde VALUES("3956","0","540","137","20.00","টোল");
INSERT INTO tbl_expensesde VALUES("3957","0","540","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3958","0","540","137","450.00","মশারী");
INSERT INTO tbl_expensesde VALUES("3959","0","540","137","160.00","কাটার,বোল্ট");
INSERT INTO tbl_expensesde VALUES("3960","0","540","137","250.00","মাক্র");
INSERT INTO tbl_expensesde VALUES("3961","0","540","15","140.00","");
INSERT INTO tbl_expensesde VALUES("3962","0","540","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3963","0","540","91","460.00","");
INSERT INTO tbl_expensesde VALUES("3964","0","540","91","1350.00","");
INSERT INTO tbl_expensesde VALUES("3965","0","540","92","270.00","");
INSERT INTO tbl_expensesde VALUES("3966","0","540","87","300.00","");
INSERT INTO tbl_expensesde VALUES("3967","0","540","86","11320.00","");
INSERT INTO tbl_expensesde VALUES("3968","0","540","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3969","0","541","109","4130.00","মাছ");
INSERT INTO tbl_expensesde VALUES("3970","0","541","150","19410.00","সিপ্টারের ফ্রেম ও তার");
INSERT INTO tbl_expensesde VALUES("3971","0","541","164","19200.00","");
INSERT INTO tbl_expensesde VALUES("3972","0","541","164","18600.00","");
INSERT INTO tbl_expensesde VALUES("3973","0","541","137","19000.00","মিলের ক্যামেরা");
INSERT INTO tbl_expensesde VALUES("3974","0","541","109","2220.00","রসুন,আদা,জিরা,ডিম");
INSERT INTO tbl_expensesde VALUES("3975","0","541","87","1100.00","");
INSERT INTO tbl_expensesde VALUES("3976","0","541","162","1000.00","");
INSERT INTO tbl_expensesde VALUES("3977","0","541","111","4000.00","");
INSERT INTO tbl_expensesde VALUES("3978","0","541","111","4000.00","");
INSERT INTO tbl_expensesde VALUES("3979","0","541","150","1220.00","সিপ্টারের পকেট");
INSERT INTO tbl_expensesde VALUES("3980","0","541","92","570.00","খাবার +ভাড়া");
INSERT INTO tbl_expensesde VALUES("3981","0","541","150","830.00","বিবেল্ট গুনা         ");
INSERT INTO tbl_expensesde VALUES("3982","0","541","158","20.00","");
INSERT INTO tbl_expensesde VALUES("3983","0","541","152","10.00","");
INSERT INTO tbl_expensesde VALUES("3984","0","541","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("3985","0","542","95","160.00","");
INSERT INTO tbl_expensesde VALUES("3986","0","542","158","150.00","");
INSERT INTO tbl_expensesde VALUES("3987","0","542","158","40.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("3988","0","542","137","50.00","কয়েল");
INSERT INTO tbl_expensesde VALUES("3989","0","542","111","760.00","");
INSERT INTO tbl_expensesde VALUES("3990","0","542","111","200.00","");
INSERT INTO tbl_expensesde VALUES("3991","0","542","92","100.00","");
INSERT INTO tbl_expensesde VALUES("3992","0","542","91","1350.00","");
INSERT INTO tbl_expensesde VALUES("3993","0","542","92","270.00","");
INSERT INTO tbl_expensesde VALUES("3994","0","542","91","460.00","");
INSERT INTO tbl_expensesde VALUES("3995","0","542","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("3996","0","542","103","1010.00","ফিঙ্গার প্রিন্ট");
INSERT INTO tbl_expensesde VALUES("3997","0","542","137","100.00","মসজিদের বেতন");
INSERT INTO tbl_expensesde VALUES("3998","0","542","103","1700.00","কাজ বাবদ হাসান");
INSERT INTO tbl_expensesde VALUES("3999","0","542","86","12010.00","");
INSERT INTO tbl_expensesde VALUES("4000","0","542","137","40.00","রয়েল ক্লিপ");
INSERT INTO tbl_expensesde VALUES("4001","0","542","109","690.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4002","0","543","158","40.00","");
INSERT INTO tbl_expensesde VALUES("4003","0","543","85","9410.00","");
INSERT INTO tbl_expensesde VALUES("4004","0","543","156","150.00","");
INSERT INTO tbl_expensesde VALUES("4005","0","543","85","6000.00","709");
INSERT INTO tbl_expensesde VALUES("4006","0","543","15","399.00","");
INSERT INTO tbl_expensesde VALUES("4007","0","543","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("4008","0","543","109","975.00","তেল+লবন");
INSERT INTO tbl_expensesde VALUES("4009","0","543","92","50.00","");
INSERT INTO tbl_expensesde VALUES("4010","0","543","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4011","0","543","103","1100.00","টাটা গাড়ির কাজ");
INSERT INTO tbl_expensesde VALUES("4012","0","543","164","18700.00","");
INSERT INTO tbl_expensesde VALUES("4013","0","544","92","400.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4014","0","544","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4015","0","544","86","10390.00","");
INSERT INTO tbl_expensesde VALUES("4016","0","544","92","230.00","");
INSERT INTO tbl_expensesde VALUES("4017","0","544","91","460.00","");
INSERT INTO tbl_expensesde VALUES("4018","0","544","86","2200.00","");
INSERT INTO tbl_expensesde VALUES("4019","0","545","103","200.00","লেমনিটিং");
INSERT INTO tbl_expensesde VALUES("4020","0","545","109","430.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4021","0","545","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4022","0","545","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("4023","0","545","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("4024","0","545","109","1165.00","ডিম,ডাল,লবন");
INSERT INTO tbl_expensesde VALUES("4025","0","545","111","4160.00","তাওরাস");
INSERT INTO tbl_expensesde VALUES("4026","0","545","156","200.00","");
INSERT INTO tbl_expensesde VALUES("4027","0","545","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4028","0","545","164","18500.00","");
INSERT INTO tbl_expensesde VALUES("4029","0","546","161","115.00","");
INSERT INTO tbl_expensesde VALUES("4030","0","546","157","40.00","");
INSERT INTO tbl_expensesde VALUES("4031","0","546","150","38000.00","রোলার পিনিয়াম");
INSERT INTO tbl_expensesde VALUES("4032","0","546","95","160.00","");
INSERT INTO tbl_expensesde VALUES("4033","0","546","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4034","0","546","92","200.00","");
INSERT INTO tbl_expensesde VALUES("4035","0","546","158","30.00","");
INSERT INTO tbl_expensesde VALUES("4036","0","546","109","340.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4037","0","546","157","230.00","");
INSERT INTO tbl_expensesde VALUES("4038","0","546","91","1050.00","");
INSERT INTO tbl_expensesde VALUES("4039","0","546","103","5210.00","কাজ বাবদ");
INSERT INTO tbl_expensesde VALUES("4040","0","546","15","379.00","");
INSERT INTO tbl_expensesde VALUES("4041","0","546","158","80.00","");
INSERT INTO tbl_expensesde VALUES("4042","0","546","137","1330.00","তোষক");
INSERT INTO tbl_expensesde VALUES("4043","0","546","86","12770.00","");
INSERT INTO tbl_expensesde VALUES("4044","0","546","137","70.00","বিস্কুুট");
INSERT INTO tbl_expensesde VALUES("4045","0","547","92","300.00","+ভাড়া");
INSERT INTO tbl_expensesde VALUES("4046","0","547","158","200.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4047","0","547","152","20.00","");
INSERT INTO tbl_expensesde VALUES("4048","0","547","109","750.00","মুরগি ,মসলা");
INSERT INTO tbl_expensesde VALUES("4049","0","547","111","3500.00","টাটা");
INSERT INTO tbl_expensesde VALUES("4050","0","547","103","1200.00","টাটা লাইট");
INSERT INTO tbl_expensesde VALUES("4051","0","548","85","7410.00","TATA");
INSERT INTO tbl_expensesde VALUES("4052","0","548","157","85.00","");
INSERT INTO tbl_expensesde VALUES("4053","0","548","91","2960.00","");
INSERT INTO tbl_expensesde VALUES("4054","0","548","87","3000.00","SHAHIN");
INSERT INTO tbl_expensesde VALUES("4055","0","548","103","1010.00","MERAMAT");
INSERT INTO tbl_expensesde VALUES("4056","0","548","157","20.00","");
INSERT INTO tbl_expensesde VALUES("4057","0","548","158","40.00","");
INSERT INTO tbl_expensesde VALUES("4058","0","548","86","4500.00","");
INSERT INTO tbl_expensesde VALUES("4059","0","548","170","590.00","");
INSERT INTO tbl_expensesde VALUES("4060","0","549","158","200.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4061","0","549","152","30.00","");
INSERT INTO tbl_expensesde VALUES("4062","0","549","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4063","0","549","109","650.00","হলুদের গুড়া মরিচের গুড়া");
INSERT INTO tbl_expensesde VALUES("4064","0","549","103","3300.00","গেট বাবদ খরচ");
INSERT INTO tbl_expensesde VALUES("4065","0","549","158","100.00","+রেড অক্যাইড");
INSERT INTO tbl_expensesde VALUES("4066","0","549","109","630.00","ডিম মরিচ");
INSERT INTO tbl_expensesde VALUES("4067","0","549","152","80.00","");
INSERT INTO tbl_expensesde VALUES("4068","0","549","158","70.00","");
INSERT INTO tbl_expensesde VALUES("4069","0","549","158","50.00","");
INSERT INTO tbl_expensesde VALUES("4070","0","549","138","2000.00","");
INSERT INTO tbl_expensesde VALUES("4071","0","549","152","10.00","");
INSERT INTO tbl_expensesde VALUES("4072","0","550","158","40.00","");
INSERT INTO tbl_expensesde VALUES("4073","0","550","95","160.00","");
INSERT INTO tbl_expensesde VALUES("4074","0","550","87","3900.00","");
INSERT INTO tbl_expensesde VALUES("4075","0","550","111","500.00","");
INSERT INTO tbl_expensesde VALUES("4076","0","550","137","200.00","স্কেল মেরামত");
INSERT INTO tbl_expensesde VALUES("4077","0","550","150","2600.00","কাটিং হাউজিং ছিলিপ");
INSERT INTO tbl_expensesde VALUES("4078","0","550","103","600.00","টায়ার রড পুশ রড");
INSERT INTO tbl_expensesde VALUES("4079","0","550","103","200.00","ক্লাচ খোলা কাটিং");
INSERT INTO tbl_expensesde VALUES("4080","0","550","91","1380.00","");
INSERT INTO tbl_expensesde VALUES("4081","0","550","92","300.00","");
INSERT INTO tbl_expensesde VALUES("4082","0","550","137","65.00","টোষ্ট");
INSERT INTO tbl_expensesde VALUES("4083","0","550","164","1800.00","");
INSERT INTO tbl_expensesde VALUES("4084","0","550","86","10870.00","");
INSERT INTO tbl_expensesde VALUES("4085","0","551","109","370.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4086","0","551","87","1500.00","");
INSERT INTO tbl_expensesde VALUES("4087","0","551","90","200.00","+খাবার");
INSERT INTO tbl_expensesde VALUES("4088","0","551","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("4089","0","551","137","210.00","টিস্যু+ভিম লিকুয়েড");
INSERT INTO tbl_expensesde VALUES("4090","0","551","164","1800.00","");
INSERT INTO tbl_expensesde VALUES("4091","0","551","109","1295.00","ডিম +তেল");
INSERT INTO tbl_expensesde VALUES("4092","0","551","158","100.00","");
INSERT INTO tbl_expensesde VALUES("4093","0","552","164","20000.00","");
INSERT INTO tbl_expensesde VALUES("4094","0","552","167","1750.00","");
INSERT INTO tbl_expensesde VALUES("4095","0","552","157","80.00","");
INSERT INTO tbl_expensesde VALUES("4096","0","552","85","5010.00","MONIR");
INSERT INTO tbl_expensesde VALUES("4097","0","552","111","360.00","");
INSERT INTO tbl_expensesde VALUES("4098","0","552","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("4099","0","552","149","10010.00","MOTOR TER");
INSERT INTO tbl_expensesde VALUES("4100","0","552","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4101","0","552","171","10.00","");
INSERT INTO tbl_expensesde VALUES("4102","0","552","158","50.00","");
INSERT INTO tbl_expensesde VALUES("4103","0","552","157","200.00","");
INSERT INTO tbl_expensesde VALUES("4104","0","552","91","240.00","");
INSERT INTO tbl_expensesde VALUES("4105","0","552","157","80.00","");
INSERT INTO tbl_expensesde VALUES("4106","0","552","158","40.00","");
INSERT INTO tbl_expensesde VALUES("4107","0","552","158","150.00","");
INSERT INTO tbl_expensesde VALUES("4108","0","552","170","350.00","");
INSERT INTO tbl_expensesde VALUES("4109","0","552","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4110","0","552","86","6385.00","");
INSERT INTO tbl_expensesde VALUES("4111","0","552","103","1010.00","ANAMUL");
INSERT INTO tbl_expensesde VALUES("4112","0","553","103","1450.00","মোনিরের গাড়ির হর্ন বাবদ");
INSERT INTO tbl_expensesde VALUES("4113","0","553","13","100.00","");
INSERT INTO tbl_expensesde VALUES("4114","0","553","138","1900.00","");
INSERT INTO tbl_expensesde VALUES("4115","0","554","165","1800.00","কারবোরেটর");
INSERT INTO tbl_expensesde VALUES("4116","0","554","158","200.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4117","0","554","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4118","0","554","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("4119","0","554","137","220.00","ব্যাটারির পানি");
INSERT INTO tbl_expensesde VALUES("4120","0","554","156","200.00","");
INSERT INTO tbl_expensesde VALUES("4121","0","554","109","530.00","ডিম+ কুমড়া");
INSERT INTO tbl_expensesde VALUES("4122","0","554","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("4123","0","554","137","90.00","ডিটারজেন্ট");
INSERT INTO tbl_expensesde VALUES("4124","0","555","164","24500.00","আরমান");
INSERT INTO tbl_expensesde VALUES("4125","0","555","138","1900.00","");
INSERT INTO tbl_expensesde VALUES("4126","0","555","156","350.00","");
INSERT INTO tbl_expensesde VALUES("4127","0","555","109","580.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4128","0","556","150","810.00","ওয়ারিং রড");
INSERT INTO tbl_expensesde VALUES("4129","0","556","150","60.00","নাট বল্টু");
INSERT INTO tbl_expensesde VALUES("4130","0","556","137","110.00","লেদ বিল");
INSERT INTO tbl_expensesde VALUES("4131","0","556","158","30.00","");
INSERT INTO tbl_expensesde VALUES("4132","0","556","95","160.00","");
INSERT INTO tbl_expensesde VALUES("4133","0","556","152","30.00","");
INSERT INTO tbl_expensesde VALUES("4134","0","556","164","20600.00","");
INSERT INTO tbl_expensesde VALUES("4135","0","556","109","1910.00","মুরগি আলু ডিম শুকনা মরিচ");
INSERT INTO tbl_expensesde VALUES("4136","0","556","150","6000.00","মটর মেরামত বাবদ");
INSERT INTO tbl_expensesde VALUES("4137","0","556","164","18200.00","");
INSERT INTO tbl_expensesde VALUES("4138","0","556","150","1470.00","পুলির চাবি বাবদ");
INSERT INTO tbl_expensesde VALUES("4139","0","556","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4140","0","556","156","150.00","");
INSERT INTO tbl_expensesde VALUES("4141","0","557","91","920.00","");
INSERT INTO tbl_expensesde VALUES("4142","0","557","92","460.00","");
INSERT INTO tbl_expensesde VALUES("4143","0","557","137","150.00","ব্যাটারি চার্জ");
INSERT INTO tbl_expensesde VALUES("4144","0","557","86","8500.00","");
INSERT INTO tbl_expensesde VALUES("4145","0","557","86","7000.00","");
INSERT INTO tbl_expensesde VALUES("4146","0","558","164","19200.00","");
INSERT INTO tbl_expensesde VALUES("4147","0","558","157","100.00","");
INSERT INTO tbl_expensesde VALUES("4148","0","558","91","1370.00","");
INSERT INTO tbl_expensesde VALUES("4149","0","558","157","300.00","");
INSERT INTO tbl_expensesde VALUES("4150","0","558","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4151","0","558","111","850.00","");
INSERT INTO tbl_expensesde VALUES("4152","0","558","171","20.00","");
INSERT INTO tbl_expensesde VALUES("4153","0","558","156","120.00","");
INSERT INTO tbl_expensesde VALUES("4154","0","558","171","20.00","");
INSERT INTO tbl_expensesde VALUES("4155","0","559","109","950.00","তরকারি ,মরিচ ");
INSERT INTO tbl_expensesde VALUES("4156","0","559","102","500.00","");
INSERT INTO tbl_expensesde VALUES("4157","0","559","158","300.00","সজিব");
INSERT INTO tbl_expensesde VALUES("4158","0","559","109","3000.00","আলু");
INSERT INTO tbl_expensesde VALUES("4159","0","559","150","800.00","গ্যাংবোর্ড");
INSERT INTO tbl_expensesde VALUES("4160","0","559","137","80.00","মার্কার কলম");
INSERT INTO tbl_expensesde VALUES("4161","0","559","158","50.00","");
INSERT INTO tbl_expensesde VALUES("4162","0","559","109","820.00","ডিম");
INSERT INTO tbl_expensesde VALUES("4163","0","559","111","7200.00","টাটা");
INSERT INTO tbl_expensesde VALUES("4164","0","559","164","19000.00","");
INSERT INTO tbl_expensesde VALUES("4165","0","559","111","5325.00","তাওরাস");
INSERT INTO tbl_expensesde VALUES("4166","0","559","150","220.00","রশি");
INSERT INTO tbl_expensesde VALUES("4167","0","559","158","350.00","+ খাবার");
INSERT INTO tbl_expensesde VALUES("4168","0","559","91","500.00","");
INSERT INTO tbl_expensesde VALUES("4169","0","559","87","400.00","");
INSERT INTO tbl_expensesde VALUES("4170","0","559","164","21700.00","");
INSERT INTO tbl_expensesde VALUES("4171","0","559","165","500.00","মেরামত");
INSERT INTO tbl_expensesde VALUES("4172","0","559","164","19200.00","");
INSERT INTO tbl_expensesde VALUES("4173","0","559","164","21300.00","");
INSERT INTO tbl_expensesde VALUES("4174","0","559","158","850.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4175","0","559","164","22300.00","");
INSERT INTO tbl_expensesde VALUES("4176","0","559","85","5000.00","মনির");
INSERT INTO tbl_expensesde VALUES("4177","0","559","103","150.00","দুলাল মিস্ত্রি");
INSERT INTO tbl_expensesde VALUES("4178","0","560","87","1000.00","");
INSERT INTO tbl_expensesde VALUES("4179","0","560","86","11950.00","");
INSERT INTO tbl_expensesde VALUES("4180","0","561","163","30840.00","");
INSERT INTO tbl_expensesde VALUES("4181","0","561","111","500.00","");
INSERT INTO tbl_expensesde VALUES("4182","0","561","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4183","0","561","86","15470.00","");
INSERT INTO tbl_expensesde VALUES("4184","0","561","92","300.00","");
INSERT INTO tbl_expensesde VALUES("4185","0","561","91","1050.00","");
INSERT INTO tbl_expensesde VALUES("4186","0","561","91","20.00","");
INSERT INTO tbl_expensesde VALUES("4187","0","561","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4188","0","562","91","780.00","");
INSERT INTO tbl_expensesde VALUES("4189","0","562","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4190","0","562","109","500.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4191","0","562","87","500.00","");
INSERT INTO tbl_expensesde VALUES("4192","0","562","93","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4193","0","562","111","750.00","");
INSERT INTO tbl_expensesde VALUES("4194","0","562","85","6010.00","");
INSERT INTO tbl_expensesde VALUES("4195","0","562","162","500.00","");
INSERT INTO tbl_expensesde VALUES("4196","0","563","169","70000.00","আনোয়ার চেয়ারম্যান");
INSERT INTO tbl_expensesde VALUES("4197","0","564","109","1815.00","তেল,ডিম,আদা,রসুন");
INSERT INTO tbl_expensesde VALUES("4198","0","564","137","270.00","ঝাড়ু");
INSERT INTO tbl_expensesde VALUES("4199","0","564","138","1700.00","");
INSERT INTO tbl_expensesde VALUES("4200","0","564","92","20.00","");
INSERT INTO tbl_expensesde VALUES("4201","0","564","158","50.00","");
INSERT INTO tbl_expensesde VALUES("4202","0","564","164","19300.00","");
INSERT INTO tbl_expensesde VALUES("4203","0","564","90","450.00","");
INSERT INTO tbl_expensesde VALUES("4204","0","564","15","500.00","");
INSERT INTO tbl_expensesde VALUES("4205","0","565","149","20000.00","RUBEL-2 JON");
INSERT INTO tbl_expensesde VALUES("4206","0","565","144","3800.00","");
INSERT INTO tbl_expensesde VALUES("4207","0","565","82","2000.00","");
INSERT INTO tbl_expensesde VALUES("4208","0","565","91","1370.00","");
INSERT INTO tbl_expensesde VALUES("4209","0","565","157","300.00","");
INSERT INTO tbl_expensesde VALUES("4210","0","565","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4211","0","565","87","1000.00","MAHABUB");
INSERT INTO tbl_expensesde VALUES("4212","0","566","95","160.00","");
INSERT INTO tbl_expensesde VALUES("4213","0","566","156","90.00","");
INSERT INTO tbl_expensesde VALUES("4214","0","566","82","100.00","");
INSERT INTO tbl_expensesde VALUES("4215","0","566","157","70.00","");
INSERT INTO tbl_expensesde VALUES("4216","0","566","85","11100.00","tata");
INSERT INTO tbl_expensesde VALUES("4217","0","566","162","700.00","");
INSERT INTO tbl_expensesde VALUES("4218","0","566","170","880.00","");
INSERT INTO tbl_expensesde VALUES("4219","0","566","164","18900.00","");
INSERT INTO tbl_expensesde VALUES("4220","0","566","103","200.00","dulal");
INSERT INTO tbl_expensesde VALUES("4221","0","567","87","15000.00","sajib");
INSERT INTO tbl_expensesde VALUES("4222","0","567","157","80.00","");
INSERT INTO tbl_expensesde VALUES("4223","0","567","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4224","0","567","86","7045.00","");
INSERT INTO tbl_expensesde VALUES("4225","0","567","73","1505.00","");
INSERT INTO tbl_expensesde VALUES("4226","0","567","170","550.00","");
INSERT INTO tbl_expensesde VALUES("4227","0","568","170","710.00","");
INSERT INTO tbl_expensesde VALUES("4228","0","568","87","2000.00","");
INSERT INTO tbl_expensesde VALUES("4229","0","568","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4230","0","568","170","225.00","");
INSERT INTO tbl_expensesde VALUES("4231","0","568","111","1610.00","");
INSERT INTO tbl_expensesde VALUES("4232","0","568","87","2890.00","MINTU");
INSERT INTO tbl_expensesde VALUES("4233","0","568","87","3000.00","JAHANGIR");
INSERT INTO tbl_expensesde VALUES("4234","0","568","91","800.00","");
INSERT INTO tbl_expensesde VALUES("4235","0","568","111","2300.00","");
INSERT INTO tbl_expensesde VALUES("4236","0","568","144","3000.00","");
INSERT INTO tbl_expensesde VALUES("4237","0","569","158","100.00","");
INSERT INTO tbl_expensesde VALUES("4238","0","569","149","3260.00","BAKUL MOTOR");
INSERT INTO tbl_expensesde VALUES("4239","0","570","87","97060.00","");
INSERT INTO tbl_expensesde VALUES("4240","0","570","87","6530.00","");
INSERT INTO tbl_expensesde VALUES("4241","0","570","87","7000.00","");
INSERT INTO tbl_expensesde VALUES("4242","0","571","167","3850.00","");
INSERT INTO tbl_expensesde VALUES("4243","0","571","111","800.00","");
INSERT INTO tbl_expensesde VALUES("4244","0","571","157","40.00","");
INSERT INTO tbl_expensesde VALUES("4245","0","571","95","160.00","");
INSERT INTO tbl_expensesde VALUES("4246","0","571","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4247","0","571","91","1490.00","");
INSERT INTO tbl_expensesde VALUES("4248","0","571","157","270.00","");
INSERT INTO tbl_expensesde VALUES("4249","0","572","87","2020.00","");
INSERT INTO tbl_expensesde VALUES("4250","0","572","158","40.00","");
INSERT INTO tbl_expensesde VALUES("4251","0","572","111","650.00","");
INSERT INTO tbl_expensesde VALUES("4252","0","572","158","140.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4253","0","572","137","1500.00","লেবারদের চুলা");
INSERT INTO tbl_expensesde VALUES("4254","0","572","152","10.00","");
INSERT INTO tbl_expensesde VALUES("4255","0","572","87","19100.00","");
INSERT INTO tbl_expensesde VALUES("4256","0","572","109","960.00","ডিম+তরকারি+মরিচ জিরা");
INSERT INTO tbl_expensesde VALUES("4257","0","572","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4258","0","572","164","18400.00","");
INSERT INTO tbl_expensesde VALUES("4259","0","572","150","1310.00","বি বেল্ট");
INSERT INTO tbl_expensesde VALUES("4260","0","572","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4261","0","573","87","1500.00","");
INSERT INTO tbl_expensesde VALUES("4262","0","573","138","4800.00","");
INSERT INTO tbl_expensesde VALUES("4263","0","573","146","600.00","");
INSERT INTO tbl_expensesde VALUES("4264","0","573","158","50.00","");
INSERT INTO tbl_expensesde VALUES("4265","0","573","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4266","0","573","87","8500.00","");
INSERT INTO tbl_expensesde VALUES("4267","0","573","111","200.00","");
INSERT INTO tbl_expensesde VALUES("4268","0","573","137","350.00","ভ্যান জালাই");
INSERT INTO tbl_expensesde VALUES("4269","0","573","158","220.00","");
INSERT INTO tbl_expensesde VALUES("4270","0","573","92","200.00","খাবার");
INSERT INTO tbl_expensesde VALUES("4271","0","573","156","170.00","");
INSERT INTO tbl_expensesde VALUES("4272","0","573","87","1610.00","");
INSERT INTO tbl_expensesde VALUES("4273","0","573","87","3000.00","");
INSERT INTO tbl_expensesde VALUES("4274","0","573","111","2325.00","");
INSERT INTO tbl_expensesde VALUES("4275","0","573","91","800.00","");
INSERT INTO tbl_expensesde VALUES("4276","0","573","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4277","0","574","137","3220.00","ভ্যানের কনটোলার");
INSERT INTO tbl_expensesde VALUES("4278","0","574","15","38.00","");
INSERT INTO tbl_expensesde VALUES("4279","0","574","137","19.00","বিকাশ খরচ");
INSERT INTO tbl_expensesde VALUES("4280","0","574","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4281","0","574","137","2420.00","তোশক মশারী");
INSERT INTO tbl_expensesde VALUES("4282","0","574","87","4500.00","");
INSERT INTO tbl_expensesde VALUES("4283","0","574","157","480.00","");
INSERT INTO tbl_expensesde VALUES("4284","0","574","158","60.00","");
INSERT INTO tbl_expensesde VALUES("4285","0","574","92","320.00","");
INSERT INTO tbl_expensesde VALUES("4286","0","574","91","460.00","");
INSERT INTO tbl_expensesde VALUES("4287","0","574","162","1150.00","");
INSERT INTO tbl_expensesde VALUES("4288","0","574","158","120.00","+খাবার");
INSERT INTO tbl_expensesde VALUES("4289","0","574","109","410.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4290","0","574","92","120.00","+খাবার");
INSERT INTO tbl_expensesde VALUES("4291","0","574","86","14110.00","");
INSERT INTO tbl_expensesde VALUES("4292","0","575","92","160.00","");
INSERT INTO tbl_expensesde VALUES("4293","0","575","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4294","0","575","164","18000.00","");
INSERT INTO tbl_expensesde VALUES("4295","0","575","109","1570.00","ডিম,তেল,তরকারি");
INSERT INTO tbl_expensesde VALUES("4296","0","575","85","5010.00","মনির");
INSERT INTO tbl_expensesde VALUES("4297","0","575","111","330.00","");
INSERT INTO tbl_expensesde VALUES("4298","0","575","150","800.00","কাটিং পাথর");
INSERT INTO tbl_expensesde VALUES("4299","0","575","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4300","0","575","158","60.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4301","0","575","109","1850.00","মাছ");
INSERT INTO tbl_expensesde VALUES("4302","0","575","87","10000.00","");
INSERT INTO tbl_expensesde VALUES("4303","0","575","87","4300.00","");
INSERT INTO tbl_expensesde VALUES("4304","0","575","152","20.00","");
INSERT INTO tbl_expensesde VALUES("4305","0","575","162","200.00","");
INSERT INTO tbl_expensesde VALUES("4306","0","575","165","500.00","");
INSERT INTO tbl_expensesde VALUES("4307","0","576","170","880.00","");
INSERT INTO tbl_expensesde VALUES("4308","0","576","103","1100.00","");
INSERT INTO tbl_expensesde VALUES("4309","0","576","87","8000.00","RAJIB");
INSERT INTO tbl_expensesde VALUES("4310","0","576","91","940.00","");
INSERT INTO tbl_expensesde VALUES("4311","0","576","91","690.00","");
INSERT INTO tbl_expensesde VALUES("4312","0","576","149","23000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("4313","0","576","20","560.00","");
INSERT INTO tbl_expensesde VALUES("4314","0","576","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4315","0","576","157","100.00","");
INSERT INTO tbl_expensesde VALUES("4316","0","576","167","750.00","");
INSERT INTO tbl_expensesde VALUES("4317","0","576","86","7170.00","");
INSERT INTO tbl_expensesde VALUES("4318","0","576","103","15000.00","CABIN-18-9961");
INSERT INTO tbl_expensesde VALUES("4319","0","576","173","2000.00","");
INSERT INTO tbl_expensesde VALUES("4320","0","576","111","650.00","");
INSERT INTO tbl_expensesde VALUES("4321","0","577","109","350.00","তরকারি");
INSERT INTO tbl_expensesde VALUES("4322","0","577","158","190.00","+নাস্তা");
INSERT INTO tbl_expensesde VALUES("4323","0","577","85","5000.00","");
INSERT INTO tbl_expensesde VALUES("4324","0","577","111","350.00","");
INSERT INTO tbl_expensesde VALUES("4325","0","577","15","100.00","");
INSERT INTO tbl_expensesde VALUES("4326","0","577","152","10.00","");
INSERT INTO tbl_expensesde VALUES("4327","0","577","138","4000.00","");
INSERT INTO tbl_expensesde VALUES("4328","0","577","109","1910.00","মুরগি,মসলা,ডিম");
INSERT INTO tbl_expensesde VALUES("4329","0","577","158","100.00","");
INSERT INTO tbl_expensesde VALUES("4330","0","577","164","17700.00","");
INSERT INTO tbl_expensesde VALUES("4331","0","577","152","40.00","");
INSERT INTO tbl_expensesde VALUES("4332","0","577","158","20.00","");
INSERT INTO tbl_expensesde VALUES("4333","0","577","111","900.00","");
INSERT INTO tbl_expensesde VALUES("4334","0","577","138","100.00","ভাড়া");



CREATE TABLE `tbl_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `name` varchar(65) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `prid` int(11) DEFAULT NULL,
  `catid` int(11) DEFAULT NULL,
  `scatid` int(11) DEFAULT NULL,
  `brid` int(11) DEFAULT NULL,
  `manid` int(11) DEFAULT NULL,
  `unid` int(11) DEFAULT NULL,
  `couid` int(11) DEFAULT NULL,
  `minstock` double NOT NULL DEFAULT 0,
  `cqty` int(11) DEFAULT NULL,
  `barcode` varchar(25) DEFAULT NULL,
  `certificate` varchar(150) DEFAULT NULL,
  `modelno` varchar(25) DEFAULT NULL,
  `brandno` varchar(25) DEFAULT NULL,
  `image` varchar(50) DEFAULT NULL,
  `cost` decimal(12,2) NOT NULL DEFAULT 0.00,
  `price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `wday` double NOT NULL DEFAULT 0,
  `pmod` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `raw` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_item VALUES("2","ABA002P","গম ","","","","","","","","2","","0","50","","","","","download_1653294491.jpg","0.00","0.00","0","0","1","1","1","2022-05-05 09:49:07");
INSERT INTO tbl_item VALUES("5","ABA005P","শক্তি মোটা ভূষি ৩৫ কেজি","","","2","6","","","","26","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-05-05 11:04:31");
INSERT INTO tbl_item VALUES("7","ABA007P","ও.এম.এস আটা ৫০ কেজি","","","","8","","","","26","1","0","0","","","","","O M S ATTA_1657966660.jpg","0.00","0.00","0","0","1","0","1","2022-05-05 11:06:29");
INSERT INTO tbl_item VALUES("10","ABA010P","শক্তি চিকন ভূষি ৫০ কেজি","","","2","1","","","","26","","0","0","","","","","chikon busi_1657860440.jpg","0.00","0.00","0","0","1","0","1","2022-05-05 01:05:01");
INSERT INTO tbl_item VALUES("11","ABA011P","শক্তি নরমাল ময়দা ৫০ কেজি","","","","","","","","26","","0","0","","","","","4dfb_1656419776.jpg","0.00","0.00","0","0","1","0","1","2022-05-05 01:05:29");
INSERT INTO tbl_item VALUES("12","ABA012P","শক্তি ফিস ফিড 25 কেজি","","","","","","","","26","","0","0","","","","","Corn_1653288079.jpg","0.00","0.00","0","0","1","0","1","2022-05-05 01:05:55");
INSERT INTO tbl_item VALUES("13","ABA013P","শক্তি আটা ৫০ কেজি","","","","","","","","26","","0","0","","","","","শক্তি আটা২_1657856970.jpg","0.00","0.00","0","0","1","0","1","2022-05-05 01:06:23");
INSERT INTO tbl_item VALUES("14","ABA014P","শক্তি মোটা ভূষি ৩৭ কেজি","","","","","","","","26","","0","0","","","","","download (1)_1656419951.jpg","0.00","0.00","0","0","1","0","1","2022-05-05 01:10:13");
INSERT INTO tbl_item VALUES("26","ABA025P","শক্তি মোটা ভূষি ৩৪ কেজি","","","","","","","","26","","0","0","","","","","download (1)_1656419923.jpg","0.00","0.00","0","0","1","0","1","2022-05-08 11:47:14");
INSERT INTO tbl_item VALUES("28","ABA027P","সাদা গম ৫০ কেজি","","","5","3","","","","26","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-05-08 11:49:41");
INSERT INTO tbl_item VALUES("30","ABA029P","শক্তি চিকন ভূষি ৫৫ কেজি","","","2","1","","","","26","1","0","0","","","","","chikon busi_1657860458.jpg","0.00","0.00","0","0","0","0","1","2022-05-11 11:15:11");
INSERT INTO tbl_item VALUES("36","ABA035P","প্যাকেট ২ কেজি আটা","","","1","","","","","2","1","0","0","","","","","শক্তি লোগো 1_1657857106.jpeg","0.00","0.00","0","0","1","0","1","2022-05-12 06:17:00");
INSERT INTO tbl_item VALUES("38","ABA037P","গমের ময়লা/ ফিল্টার /খুদ ","","","","","","","","2","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-05-14 06:24:56");
INSERT INTO tbl_item VALUES("40","ABA039P","ভুট্টার গুড়া  35 কেজি","","","","","","","","26","","0","35","","","","","","0.00","0.00","0","0","1","0","1","2022-05-26 11:31:03");
INSERT INTO tbl_item VALUES("41","ABA040P","খুচরা আটা","","","1","10","","","","2","1","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-05-29 11:37:30");
INSERT INTO tbl_item VALUES("46","ABA045P","খুচরা এম.এস আটা","","","1","8","","","","26","1","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-06-07 12:58:14");
INSERT INTO tbl_item VALUES("54","ABA053P","ইন্ডিয়ান হনুমান মোটা ভূষি ৩৭ KG ","","","","","","","","2","","0","37","","","","","","0.00","0.00","0","0","1","0","1","2022-06-16 06:15:22");
INSERT INTO tbl_item VALUES("63","ABA062P","প্যাকেট আটা ৫ কেজি ","","","","","","","","2","","0","0","","","","","শক্তি লোগো 1_1657857133.jpeg","0.00","0.00","0","0","1","0","1","2022-06-19 09:50:52");
INSERT INTO tbl_item VALUES("64","ABA063P","শক্তি গরুর ফিড ২৫ কেজি","","","","","","","","26","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-06-19 02:22:00");
INSERT INTO tbl_item VALUES("67","ABA066P","শক্তি মোটা ভূষি ৩৩ কেজি","","","","","","","","26","","0","0","","","","","download (1)_1656419829.jpg","0.00","0.00","0","0","1","0","1","2022-06-22 06:49:42");
INSERT INTO tbl_item VALUES("68","ABA067P","শক্তি মোটা ভূষি ৩২  কেজি ","","","","","","","","26","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-07-20 10:30:24");
INSERT INTO tbl_item VALUES("69","ABA068P","    ফিল্টার ","","","","","","","","","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-07-28 08:13:49");
INSERT INTO tbl_item VALUES("70","ABA069P","খৈল  ","","","","","","","","2","","0","0","","","","","","0.00","0.00","0","0","0","0","1","2022-07-30 09:32:35");
INSERT INTO tbl_item VALUES("71","ABA070P","    খুচরা গম ","","","","","","","","2","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-09-14 08:58:49");
INSERT INTO tbl_item VALUES("72","ABA071P","লাল গম ৫০ কেজি ","","","","","","","","26","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-11-19 08:54:43");
INSERT INTO tbl_item VALUES("77","ABA075P","খুচরা ভূষি","","","","","","","","2","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2022-11-22 11:26:08");
INSERT INTO tbl_item VALUES("78","ABA076P","প্যাকেট আটা ১ কেজি","","","","10","","","","2","","0","0","","","","","","0.00","0.00","0","0","0","0","1","2022-12-07 10:03:54");
INSERT INTO tbl_item VALUES("79","ABA077P","ইন্ডিয়ান  চিকন ভূষি ৫০ KG ","","","","","","","","26","","0","0","","","","","","0.00","0.00","0","0","1","0","1","2023-03-08 03:03:07");
INSERT INTO tbl_item VALUES("80","ABA078P","শক্তি ফিস ফিড ২৫ কেজি  ","","","","","","1","","26","1","0","0","","","","","","0.00","0.00","0","0","1","0","1","2023-07-26 12:16:19");



CREATE TABLE `tbl_journalde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `did` int(11) NOT NULL,
  `dtype` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `cid` int(11) NOT NULL,
  `ctype` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_parent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_parent VALUES("1","আটা ","","","1","2022-05-05 09:35:14");
INSERT INTO tbl_parent VALUES("2","ভূষি","","","1","2022-05-05 09:35:29");
INSERT INTO tbl_parent VALUES("3","ময়দা","","","1","2022-05-05 09:35:42");
INSERT INTO tbl_parent VALUES("4","ভুট্টা","","","1","2022-05-05 09:35:54");
INSERT INTO tbl_parent VALUES("5","গম","","","1","2022-05-05 09:36:11");



CREATE TABLE `tbl_payvoucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=785 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_payvoucher VALUES("1","PAV210324101","","45712245.00","2024-03-21","0","1","2024-03-21 03:05:27");
INSERT INTO tbl_payvoucher VALUES("2","PAV210324102","","18353103.00","2024-03-21","0","1","2024-03-21 03:16:25");
INSERT INTO tbl_payvoucher VALUES("4","PAV210324104","","21830.00","2024-03-21","0","1","2024-03-21 06:51:53");
INSERT INTO tbl_payvoucher VALUES("5","PAV210324105","","800000.00","2024-03-21","0","1","2024-03-21 07:26:25");
INSERT INTO tbl_payvoucher VALUES("6","PAV210324106","","590970.00","2024-03-21","0","1","2024-03-21 08:11:53");
INSERT INTO tbl_payvoucher VALUES("7","PAV220324101","","200000.00","2024-03-21","0","1","2024-03-22 12:05:43");
INSERT INTO tbl_payvoucher VALUES("8","PAV220324102","","3409040.00","2024-03-21","0","1","2024-03-22 12:09:28");
INSERT INTO tbl_payvoucher VALUES("12","PAV220324103","","26320.00","2024-03-22","0","1","2024-03-22 02:24:19");
INSERT INTO tbl_payvoucher VALUES("13","PAV220324104","","828862.00","2024-03-22","0","1","2024-03-22 04:44:38");
INSERT INTO tbl_payvoucher VALUES("14","PAV220324105","","44970.00","2024-03-21","0","1","2024-03-22 09:22:00");
INSERT INTO tbl_payvoucher VALUES("15","PAV220324106","","85865.00","2024-03-22","0","1","2024-03-22 09:38:09");
INSERT INTO tbl_payvoucher VALUES("16","PAV230324101","","320.00","2024-03-23","0","1","2024-03-23 09:37:11");
INSERT INTO tbl_payvoucher VALUES("17","PAV230324102","","1470.00","2024-03-23","0","1","2024-03-23 02:11:24");
INSERT INTO tbl_payvoucher VALUES("18","PAV230324103","","5350.00","2024-03-23","0","1","2024-03-23 02:14:30");
INSERT INTO tbl_payvoucher VALUES("19","PAV230324104","","50000.00","2024-03-23","0","1","2024-03-23 02:36:00");
INSERT INTO tbl_payvoucher VALUES("20","PAV230324105","","20000.00","2024-03-23","0","1","2024-03-23 04:58:44");
INSERT INTO tbl_payvoucher VALUES("23","PAV230324108","","4600070.00","2024-03-23","0","1","2024-03-23 08:27:41");
INSERT INTO tbl_payvoucher VALUES("24","PAV230324109","","500000.00","2024-03-21","0","1","2024-03-23 09:22:19");
INSERT INTO tbl_payvoucher VALUES("25","PAV230324110","","15500.00","2024-03-23","0","1","2024-03-23 09:28:27");
INSERT INTO tbl_payvoucher VALUES("26","PAV240324101","","123200.00","2024-03-24","0","1","2024-03-24 02:04:30");
INSERT INTO tbl_payvoucher VALUES("27","PAV240324102","","892640.00","2024-03-24","0","1","2024-03-24 04:08:16");
INSERT INTO tbl_payvoucher VALUES("28","PAV240324103","","43000.00","2024-03-24","0","1","2024-03-24 04:13:56");
INSERT INTO tbl_payvoucher VALUES("29","PAV240324104","","1637000.00","2024-03-24","0","1","2024-03-24 04:18:40");
INSERT INTO tbl_payvoucher VALUES("30","PAV240324105","","106000.00","2024-03-24","0","1","2024-03-24 04:20:27");
INSERT INTO tbl_payvoucher VALUES("31","PAV240324106","","50000.00","2024-03-21","0","1","2024-03-24 04:54:20");
INSERT INTO tbl_payvoucher VALUES("32","PAV240324107","","524290.00","2024-03-24","0","1","2024-03-24 07:43:42");
INSERT INTO tbl_payvoucher VALUES("33","PAV250324101","","46000.00","2024-03-25","0","1","2024-03-25 08:44:09");
INSERT INTO tbl_payvoucher VALUES("34","PAV250324102","","18520.00","2024-03-25","0","1","2024-03-25 02:22:21");
INSERT INTO tbl_payvoucher VALUES("35","PAV250324103","","852360.00","2024-03-25","0","1","2024-03-25 08:15:42");
INSERT INTO tbl_payvoucher VALUES("36","PAV260324101","","30000.00","2024-03-25","0","1","2024-03-26 09:19:44");
INSERT INTO tbl_payvoucher VALUES("37","PAV260324102","","80.00","2024-03-26","0","1","2024-03-26 12:31:24");
INSERT INTO tbl_payvoucher VALUES("38","PAV260324103","","121250.00","2024-03-26","0","1","2024-03-26 04:36:59");
INSERT INTO tbl_payvoucher VALUES("39","PAV260324104","","12500.00","2024-03-26","0","1","2024-03-26 04:40:46");
INSERT INTO tbl_payvoucher VALUES("40","PAV260324105","","32910.00","2024-03-26","0","1","2024-03-26 09:13:18");
INSERT INTO tbl_payvoucher VALUES("41","PAV270324101","","13680.00","2024-03-27","0","1","2024-03-27 01:14:58");
INSERT INTO tbl_payvoucher VALUES("42","PAV270324102","","1376845.00","2024-03-27","0","1","2024-03-27 04:49:00");
INSERT INTO tbl_payvoucher VALUES("43","PAV270324103","","4500.00","2024-03-27","0","1","2024-03-27 09:08:58");
INSERT INTO tbl_payvoucher VALUES("44","PAV280324101","","3410.00","2024-03-28","0","1","2024-03-28 10:40:54");
INSERT INTO tbl_payvoucher VALUES("45","PAV280324102","","14656.00","2024-03-28","0","1","2024-03-28 12:03:07");
INSERT INTO tbl_payvoucher VALUES("46","PAV280324103","","462650.00","2024-03-28","0","1","2024-03-28 02:41:32");
INSERT INTO tbl_payvoucher VALUES("47","PAV280324104","","7850.00","2024-03-28","0","1","2024-03-28 04:56:53");
INSERT INTO tbl_payvoucher VALUES("48","PAV280324105","","47020.00","2024-03-28","0","1","2024-03-28 07:06:49");
INSERT INTO tbl_payvoucher VALUES("49","PAV280324106","","523900.00","2024-03-28","0","1","2024-03-28 08:36:17");
INSERT INTO tbl_payvoucher VALUES("50","PAV280324107","","800000.00","2024-03-28","0","1","2024-03-28 08:45:26");
INSERT INTO tbl_payvoucher VALUES("51","PAV290324101","","239185.00","2024-03-29","0","1","2024-03-29 12:52:12");
INSERT INTO tbl_payvoucher VALUES("52","PAV290324102","","20530.00","2024-03-29","0","1","2024-03-29 05:39:34");
INSERT INTO tbl_payvoucher VALUES("53","PAV300324101","","140.00","2024-03-30","0","1","2024-03-30 11:56:07");
INSERT INTO tbl_payvoucher VALUES("54","PAV300324102","","22150.00","2024-03-30","0","1","2024-03-30 04:09:39");
INSERT INTO tbl_payvoucher VALUES("55","PAV300324103","","1081240.00","2024-03-30","0","1","2024-03-30 07:26:31");
INSERT INTO tbl_payvoucher VALUES("56","PAV300324104","","2600.00","2024-03-30","0","1","2024-03-30 08:56:49");
INSERT INTO tbl_payvoucher VALUES("57","PAV310324101","","40.00","2024-03-31","0","1","2024-03-31 11:02:31");
INSERT INTO tbl_payvoucher VALUES("59","PAV310324102","","500000.00","2024-03-31","0","1","2024-03-31 12:36:08");
INSERT INTO tbl_payvoucher VALUES("60","PAV310324103","","173520.00","2024-03-31","0","1","2024-03-31 02:06:03");
INSERT INTO tbl_payvoucher VALUES("61","PAV310324104","","60020.00","2024-03-31","0","1","2024-03-31 02:37:17");
INSERT INTO tbl_payvoucher VALUES("62","PAV310324105","","1134429.00","2024-03-31","0","1","2024-03-31 03:35:40");
INSERT INTO tbl_payvoucher VALUES("63","PAV310324106","","1040021.00","2024-03-31","0","1","2024-03-31 04:50:10");
INSERT INTO tbl_payvoucher VALUES("64","PAV310324107","","500000.00","2024-03-31","0","1","2024-03-31 08:16:37");
INSERT INTO tbl_payvoucher VALUES("65","PAV310324108","","15000.00","2024-03-31","0","1","2024-03-31 08:33:00");
INSERT INTO tbl_payvoucher VALUES("66","PAV310324109","","25000.00","2024-03-31","0","1","2024-03-31 08:38:41");
INSERT INTO tbl_payvoucher VALUES("67","PAV010424101","","596370.00","2024-04-01","0","1","2024-04-01 03:39:07");
INSERT INTO tbl_payvoucher VALUES("68","PAV010424102","","531100.00","2024-04-01","0","1","2024-04-01 09:44:18");
INSERT INTO tbl_payvoucher VALUES("69","PAV020424101","","31050.00","2024-04-02","0","1","2024-04-02 10:29:34");
INSERT INTO tbl_payvoucher VALUES("70","PAV020424102","","300000.00","2024-04-02","0","1","2024-04-02 03:34:16");
INSERT INTO tbl_payvoucher VALUES("71","PAV020424103","","41670.00","2024-04-02","0","1","2024-04-02 09:20:17");
INSERT INTO tbl_payvoucher VALUES("72","PAV020424104","","50000.00","2024-04-02","0","1","2024-04-02 09:27:02");
INSERT INTO tbl_payvoucher VALUES("73","PAV030424101","","43850.00","2024-04-03","0","1","2024-04-03 11:37:44");
INSERT INTO tbl_payvoucher VALUES("74","PAV030424102","","10300.00","2024-04-03","0","1","2024-04-03 01:35:49");
INSERT INTO tbl_payvoucher VALUES("75","PAV030424103","","1180000.00","2024-04-03","0","1","2024-04-03 03:16:31");
INSERT INTO tbl_payvoucher VALUES("76","PAV030424104","","1000000.00","2024-04-03","0","1","2024-04-03 03:30:53");
INSERT INTO tbl_payvoucher VALUES("77","PAV030424105","","976011.00","2024-04-03","0","1","2024-04-03 03:44:29");
INSERT INTO tbl_payvoucher VALUES("78","PAV030424106","","39694.00","2024-04-03","0","1","2024-04-03 07:04:21");
INSERT INTO tbl_payvoucher VALUES("79","PAV030424107","","34600.00","2024-04-03","0","1","2024-04-03 09:59:24");
INSERT INTO tbl_payvoucher VALUES("80","PAV040424101","","8700.00","2024-04-04","0","1","2024-04-04 12:04:34");
INSERT INTO tbl_payvoucher VALUES("81","PAV040424102","","5260000.00","2024-04-04","0","1","2024-04-04 02:26:28");
INSERT INTO tbl_payvoucher VALUES("82","PAV040424103","","300.00","2024-04-04","0","1","2024-04-04 04:20:30");
INSERT INTO tbl_payvoucher VALUES("83","PAV040424104","","185000.00","2024-04-04","0","1","2024-04-04 04:23:56");
INSERT INTO tbl_payvoucher VALUES("84","PAV040424105","","2184610.00","2024-04-04","0","1","2024-04-04 07:28:31");
INSERT INTO tbl_payvoucher VALUES("85","PAV040424106","","16000.00","2024-04-04","0","1","2024-04-04 08:29:37");
INSERT INTO tbl_payvoucher VALUES("86","PAV050424101","","52000.00","2024-04-04","0","1","2024-04-05 07:54:46");
INSERT INTO tbl_payvoucher VALUES("87","PAV050424102","","240.00","2024-04-05","0","1","2024-04-05 02:57:13");
INSERT INTO tbl_payvoucher VALUES("88","PAV050424103","","2220.00","2024-04-05","0","1","2024-04-05 02:58:22");
INSERT INTO tbl_payvoucher VALUES("89","PAV050424104","","182500.00","2024-04-05","0","1","2024-04-05 04:24:53");
INSERT INTO tbl_payvoucher VALUES("90","PAV050424105","","148495.00","2024-04-05","0","1","2024-04-05 08:27:13");
INSERT INTO tbl_payvoucher VALUES("92","PAV060424102","","150080.00","2024-04-06","0","1","2024-04-06 10:43:07");
INSERT INTO tbl_payvoucher VALUES("93","PAV060424103","","1000.00","2024-04-06","0","1","2024-04-06 11:40:02");
INSERT INTO tbl_payvoucher VALUES("95","PAV060424105","","10405.00","2024-04-06","0","1","2024-04-06 03:58:08");
INSERT INTO tbl_payvoucher VALUES("96","PAV060424106","","2720.00","2024-04-06","0","1","2024-04-06 08:08:28");
INSERT INTO tbl_payvoucher VALUES("97","PAV070424101","","43700.00","2024-04-07","0","1","2024-04-07 02:01:08");
INSERT INTO tbl_payvoucher VALUES("98","PAV070424102","","95000.00","2024-04-07","0","1","2024-04-07 04:25:41");
INSERT INTO tbl_payvoucher VALUES("99","PAV070424103","","2100.00","2024-04-01","0","1","2024-04-07 04:52:49");
INSERT INTO tbl_payvoucher VALUES("100","PAV070424104","","13950.00","2024-04-07","0","1","2024-04-07 07:36:26");
INSERT INTO tbl_payvoucher VALUES("101","PAV080424101","","50000.00","2024-04-08","0","1","2024-04-08 12:23:28");
INSERT INTO tbl_payvoucher VALUES("102","PAV080424102","","984452.00","2024-04-08","0","1","2024-04-08 03:58:18");
INSERT INTO tbl_payvoucher VALUES("103","PAV080424103","","50000.00","2024-04-08","0","1","2024-04-08 04:48:05");
INSERT INTO tbl_payvoucher VALUES("104","PAV080424104","","106365.00","2024-04-08","0","1","2024-04-08 06:58:51");
INSERT INTO tbl_payvoucher VALUES("105","PAV080424105","","2500.00","2024-04-08","0","1","2024-04-08 07:50:15");
INSERT INTO tbl_payvoucher VALUES("106","PAV090424101","","450000.00","2024-04-06","0","1","2024-04-09 08:22:04");
INSERT INTO tbl_payvoucher VALUES("107","PAV090424102","","1415569.00","2024-04-08","0","1","2024-04-09 10:39:09");
INSERT INTO tbl_payvoucher VALUES("108","PAV090424103","","510160.00","2024-04-09","0","1","2024-04-09 10:52:52");
INSERT INTO tbl_payvoucher VALUES("109","PAV090424104","","3773.00","2024-04-08","0","1","2024-04-09 12:40:38");
INSERT INTO tbl_payvoucher VALUES("110","PAV090424105","","58500.00","2024-04-09","0","1","2024-04-09 12:42:18");
INSERT INTO tbl_payvoucher VALUES("111","PAV090424106","","613050.00","2024-04-09","0","1","2024-04-09 05:48:17");
INSERT INTO tbl_payvoucher VALUES("112","PAV090424107","","500000.00","2024-04-09","0","1","2024-04-09 07:59:01");
INSERT INTO tbl_payvoucher VALUES("115","PAV090424108","","734360.00","2024-04-09","0","1","2024-04-09 09:28:43");
INSERT INTO tbl_payvoucher VALUES("116","PAV140424101","","10200.00","2024-04-10","0","1","2024-04-14 10:56:30");
INSERT INTO tbl_payvoucher VALUES("117","PAV140424102","","1000.00","2024-04-10","0","1","2024-04-14 11:03:28");
INSERT INTO tbl_payvoucher VALUES("118","PAV140424103","","500.00","2024-04-14","0","1","2024-04-14 11:08:59");
INSERT INTO tbl_payvoucher VALUES("119","PAV140424104","","35000.00","2023-12-06","0","1","2024-04-14 12:17:58");
INSERT INTO tbl_payvoucher VALUES("120","PAV140424105","","500.00","2024-04-14","0","1","2024-04-14 08:07:57");
INSERT INTO tbl_payvoucher VALUES("122","PAV140424106","","7550.00","2024-04-14","0","1","2024-04-14 08:17:25");
INSERT INTO tbl_payvoucher VALUES("123","PAV150424101","","6000.00","2024-04-10","0","1","2024-04-15 09:16:11");
INSERT INTO tbl_payvoucher VALUES("124","PAV150424102","","1000000.00","2024-04-15","0","1","2024-04-15 03:47:43");
INSERT INTO tbl_payvoucher VALUES("125","PAV150424103","","1044000.00","2024-04-15","0","1","2024-04-15 03:53:10");
INSERT INTO tbl_payvoucher VALUES("126","PAV150424104","","62910.00","2024-04-15","0","1","2024-04-15 09:49:11");
INSERT INTO tbl_payvoucher VALUES("127","PAV160424101","","2940000.00","2024-04-16","0","1","2024-04-16 03:48:32");
INSERT INTO tbl_payvoucher VALUES("128","PAV160424102","","950000.00","2024-04-16","0","1","2024-04-16 04:01:26");
INSERT INTO tbl_payvoucher VALUES("129","PAV160424103","","172000.00","2024-04-16","0","1","2024-04-16 05:23:31");
INSERT INTO tbl_payvoucher VALUES("130","PAV160424104","","162000.00","2024-04-16","0","1","2024-04-16 09:47:57");
INSERT INTO tbl_payvoucher VALUES("131","PAV170424101","","32200.00","2024-04-17","0","1","2024-04-17 09:15:04");
INSERT INTO tbl_payvoucher VALUES("132","PAV180424101","","100000.00","2024-04-16","0","1","2024-04-18 09:23:50");
INSERT INTO tbl_payvoucher VALUES("133","PAV180424102","","100000.00","2024-04-18","0","1","2024-04-18 09:25:45");
INSERT INTO tbl_payvoucher VALUES("134","PAV180424103","","639600.00","2024-04-16","0","1","2024-04-18 10:30:51");
INSERT INTO tbl_payvoucher VALUES("135","PAV180424104","","71800.00","2024-04-18","0","1","2024-04-18 02:20:30");
INSERT INTO tbl_payvoucher VALUES("136","PAV180424105","","814000.00","2024-04-18","0","1","2024-04-18 06:16:50");
INSERT INTO tbl_payvoucher VALUES("137","PAV180424106","","268000.00","2024-04-18","0","1","2024-04-18 09:13:58");
INSERT INTO tbl_payvoucher VALUES("138","PAV190424101","","5000.00","2024-04-19","0","1","2024-04-19 12:04:03");
INSERT INTO tbl_payvoucher VALUES("139","PAV190424102","","101840.00","2024-04-19","0","1","2024-04-19 09:03:23");
INSERT INTO tbl_payvoucher VALUES("140","PAV190424103","","200.00","2024-04-18","0","1","2024-04-19 09:13:54");
INSERT INTO tbl_payvoucher VALUES("141","PAV200424101","","30000.00","2024-04-20","0","1","2024-04-20 08:24:12");
INSERT INTO tbl_payvoucher VALUES("142","PAV200424102","","3000.00","2024-04-19","0","1","2024-04-20 09:11:43");
INSERT INTO tbl_payvoucher VALUES("143","PAV200424103","","200.00","2024-04-20","0","1","2024-04-20 10:15:11");
INSERT INTO tbl_payvoucher VALUES("144","PAV200424104","","5000.00","2024-04-20","0","1","2024-04-20 10:26:36");
INSERT INTO tbl_payvoucher VALUES("145","PAV200424105","","21000.00","2024-04-20","0","1","2024-04-20 12:07:12");
INSERT INTO tbl_payvoucher VALUES("146","PAV200424106","","1000.00","2024-04-20","0","1","2024-04-20 09:40:34");
INSERT INTO tbl_payvoucher VALUES("147","PAV210424101","","100.00","2024-04-20","0","1","2024-04-21 09:32:53");
INSERT INTO tbl_payvoucher VALUES("149","PAV210424102","","20000.00","2024-04-21","0","1","2024-04-21 03:10:58");
INSERT INTO tbl_payvoucher VALUES("150","PAV210424103","","2120900.00","2024-04-21","0","1","2024-04-21 03:15:46");
INSERT INTO tbl_payvoucher VALUES("151","PAV210424104","","3220.00","2024-04-21","0","1","2024-04-21 09:53:41");
INSERT INTO tbl_payvoucher VALUES("152","PAV210424105","","1000000.00","2024-04-21","0","1","2024-04-21 09:55:21");
INSERT INTO tbl_payvoucher VALUES("153","PAV220424101","","50000.00","2024-04-22","0","1","2024-04-22 02:02:09");
INSERT INTO tbl_payvoucher VALUES("154","PAV220424102","","3750.00","2024-04-22","0","1","2024-04-22 05:45:37");
INSERT INTO tbl_payvoucher VALUES("155","PAV220424103","","1830320.00","2024-04-22","0","1","2024-04-22 10:12:55");
INSERT INTO tbl_payvoucher VALUES("156","PAV230424101","","5540.00","2024-04-23","0","1","2024-04-23 11:13:09");
INSERT INTO tbl_payvoucher VALUES("157","PAV230424102","","61000.00","2024-04-23","0","1","2024-04-23 02:28:25");
INSERT INTO tbl_payvoucher VALUES("159","PAV230424104","","22000.00","2024-04-23","0","1","2024-04-23 07:44:27");
INSERT INTO tbl_payvoucher VALUES("160","PAV230424105","","739500.00","2024-04-23","0","1","2024-04-23 10:32:36");
INSERT INTO tbl_payvoucher VALUES("161","PAV240424101","","10023600.00","2024-04-24","0","1","2024-04-24 09:37:23");
INSERT INTO tbl_payvoucher VALUES("162","PAV250424101","","22500.00","2024-04-24","0","1","2024-04-25 11:01:28");
INSERT INTO tbl_payvoucher VALUES("163","PAV250424102","","106000.00","2024-04-23","0","1","2024-04-25 11:03:20");
INSERT INTO tbl_payvoucher VALUES("164","PAV250424103","","393950.00","2024-04-24","0","1","2024-04-25 11:33:10");
INSERT INTO tbl_payvoucher VALUES("165","PAV250424104","","22000.00","2024-04-23","0","1","2024-04-25 03:40:51");
INSERT INTO tbl_payvoucher VALUES("166","PAV250424105","","2000000.00","2024-04-25","0","1","2024-04-25 10:16:03");
INSERT INTO tbl_payvoucher VALUES("167","PAV250424106","","1658910.00","2024-04-25","0","1","2024-04-25 10:24:40");
INSERT INTO tbl_payvoucher VALUES("168","PAV250424107","","280.00","2024-04-25","0","1","2024-04-25 10:34:55");
INSERT INTO tbl_payvoucher VALUES("169","PAV250424108","","700000.00","2024-04-25","0","1","2024-04-25 10:41:40");
INSERT INTO tbl_payvoucher VALUES("170","PAV260424101","","20750.00","2024-04-26","0","1","2024-04-26 12:25:39");
INSERT INTO tbl_payvoucher VALUES("171","PAV260424102","","44000.00","2024-04-26","0","1","2024-04-26 06:12:15");
INSERT INTO tbl_payvoucher VALUES("172","PAV270424101","","1000.00","2024-04-23","0","1","2024-04-27 10:57:41");
INSERT INTO tbl_payvoucher VALUES("173","PAV270424102","","106640.00","2024-04-27","0","1","2024-04-27 11:56:08");
INSERT INTO tbl_payvoucher VALUES("174","PAV270424103","","600.00","2024-04-27","0","1","2024-04-27 11:58:17");
INSERT INTO tbl_payvoucher VALUES("175","PAV270424104","","42930.00","2024-04-27","0","1","2024-04-27 03:30:36");
INSERT INTO tbl_payvoucher VALUES("176","PAV270424105","","45570.00","2024-04-27","0","1","2024-04-27 08:29:45");
INSERT INTO tbl_payvoucher VALUES("177","PAV270424106","","7200.00","2024-04-27","0","1","2024-04-27 09:27:20");
INSERT INTO tbl_payvoucher VALUES("178","PAV280424101","","1608090.00","2024-04-28","0","1","2024-04-28 05:00:20");
INSERT INTO tbl_payvoucher VALUES("179","PAV280424102","","47960.00","2024-04-28","0","1","2024-04-28 09:53:05");
INSERT INTO tbl_payvoucher VALUES("180","PAV290424101","","582040.00","2024-04-29","0","1","2024-04-29 02:34:59");
INSERT INTO tbl_payvoucher VALUES("181","PAV290424102","","1355900.00","2024-04-29","0","1","2024-04-29 04:58:44");
INSERT INTO tbl_payvoucher VALUES("182","PAV290424103","","70127.00","2024-04-29","0","1","2024-04-29 06:24:30");
INSERT INTO tbl_payvoucher VALUES("183","PAV300424101","","5000200.00","2024-04-29","0","1","2024-04-30 08:02:38");
INSERT INTO tbl_payvoucher VALUES("184","PAV300424102","","601350.00","2024-04-30","0","1","2024-04-30 08:04:01");
INSERT INTO tbl_payvoucher VALUES("185","PAV300424103","","300000.00","2024-04-29","0","1","2024-04-30 08:06:06");
INSERT INTO tbl_payvoucher VALUES("186","PAV300424104","","18390.00","2024-04-30","0","1","2024-04-30 08:39:48");
INSERT INTO tbl_payvoucher VALUES("187","PAV010524101","","75435.00","2024-05-01","0","1","2024-05-01 02:01:08");
INSERT INTO tbl_payvoucher VALUES("188","PAV010524102","","10100.00","2024-05-01","0","1","2024-05-01 02:55:59");
INSERT INTO tbl_payvoucher VALUES("189","PAV010524103","","49000.00","2024-05-01","0","1","2024-05-01 03:04:59");
INSERT INTO tbl_payvoucher VALUES("190","PAV010524104","","49600.00","2024-05-01","0","1","2024-05-01 06:21:13");
INSERT INTO tbl_payvoucher VALUES("191","PAV020524101","","420000.00","2024-05-02","0","1","2024-05-02 05:31:10");
INSERT INTO tbl_payvoucher VALUES("192","PAV020524102","","91580.00","2024-05-02","0","1","2024-05-02 06:07:25");
INSERT INTO tbl_payvoucher VALUES("193","PAV020524103","","158730.00","2024-05-02","0","1","2024-05-02 07:56:15");
INSERT INTO tbl_payvoucher VALUES("194","PAV020524104","","1000.00","2024-05-02","0","1","2024-05-02 08:55:49");
INSERT INTO tbl_payvoucher VALUES("195","PAV020524105","","412000.00","2024-05-02","0","1","2024-05-02 09:07:29");
INSERT INTO tbl_payvoucher VALUES("196","PAV030524101","","26000.00","2024-05-03","0","1","2024-05-03 01:11:15");
INSERT INTO tbl_payvoucher VALUES("197","PAV030524102","","58340.00","2024-05-03","0","1","2024-05-03 09:52:11");
INSERT INTO tbl_payvoucher VALUES("198","PAV040524101","","4090.00","2024-05-04","0","1","2024-05-04 03:38:40");
INSERT INTO tbl_payvoucher VALUES("199","PAV040524102","","10000.00","2024-02-14","0","1","2024-05-04 03:39:31");
INSERT INTO tbl_payvoucher VALUES("200","PAV040524103","","2523500.00","2024-04-23","0","1","2024-05-04 04:56:32");
INSERT INTO tbl_payvoucher VALUES("201","PAV040524104","","5600.00","2024-05-04","0","1","2024-05-04 09:19:57");
INSERT INTO tbl_payvoucher VALUES("202","PAV050524101","","1547070.00","2024-05-05","0","1","2024-05-05 03:54:06");
INSERT INTO tbl_payvoucher VALUES("203","PAV050524102","","1802000.00","2024-05-05","0","1","2024-05-05 09:16:07");
INSERT INTO tbl_payvoucher VALUES("204","PAV050524103","","49485.00","2024-05-05","0","1","2024-05-05 09:21:03");
INSERT INTO tbl_payvoucher VALUES("205","PAV060524101","","1177370.00","2024-05-06","0","1","2024-05-06 02:38:20");
INSERT INTO tbl_payvoucher VALUES("206","PAV060524102","","14850.00","2024-05-06","0","1","2024-05-06 02:39:18");
INSERT INTO tbl_payvoucher VALUES("207","PAV060524103","","600000.00","2024-05-06","0","1","2024-05-06 02:43:26");
INSERT INTO tbl_payvoucher VALUES("208","PAV060524104","","40.00","2024-05-06","0","1","2024-05-06 08:00:12");
INSERT INTO tbl_payvoucher VALUES("209","PAV070524101","","32420.00","2024-05-07","0","1","2024-05-07 05:53:26");
INSERT INTO tbl_payvoucher VALUES("210","PAV070524102","","2830.00","2024-05-07","0","1","2024-05-07 06:12:25");
INSERT INTO tbl_payvoucher VALUES("211","PAV080524101","","31520.00","2024-05-07","0","1","2024-05-08 08:27:58");
INSERT INTO tbl_payvoucher VALUES("212","PAV080524102","","1745440.00","2024-05-08","0","1","2024-05-08 03:55:16");
INSERT INTO tbl_payvoucher VALUES("213","PAV080524103","","21500.00","2024-05-08","0","1","2024-05-08 09:13:54");
INSERT INTO tbl_payvoucher VALUES("214","PAV090524101","","500000.00","2024-05-05","0","1","2024-05-09 12:39:09");
INSERT INTO tbl_payvoucher VALUES("215","PAV090524102","","500000.00","2024-05-05","0","1","2024-05-09 02:39:04");
INSERT INTO tbl_payvoucher VALUES("216","PAV090524103","","81500.00","2024-05-09","0","1","2024-05-09 03:05:28");
INSERT INTO tbl_payvoucher VALUES("217","PAV090524104","","486130.00","2024-05-09","0","1","2024-05-09 07:15:00");
INSERT INTO tbl_payvoucher VALUES("218","PAV090524105","","500000.00","2024-05-09","0","1","2024-05-09 08:06:25");
INSERT INTO tbl_payvoucher VALUES("219","PAV090524106","","1013000.00","2024-05-09","0","1","2024-05-09 09:11:26");
INSERT INTO tbl_payvoucher VALUES("220","PAV090524107","","200000.00","2024-05-09","0","1","2024-05-09 09:11:56");
INSERT INTO tbl_payvoucher VALUES("221","PAV100524101","","35960.00","2024-05-10","0","1","2024-05-10 10:27:37");
INSERT INTO tbl_payvoucher VALUES("222","PAV100524102","","825260.00","2024-05-08","0","1","2024-05-10 11:19:36");
INSERT INTO tbl_payvoucher VALUES("223","PAV100524103","","4700000.00","2024-05-10","0","1","2024-05-10 11:32:44");
INSERT INTO tbl_payvoucher VALUES("224","PAV100524104","","525591.00","2024-05-08","0","1","2024-05-10 11:46:04");
INSERT INTO tbl_payvoucher VALUES("225","PAV100524105","","120.00","2024-05-10","0","1","2024-05-10 07:38:51");
INSERT INTO tbl_payvoucher VALUES("226","PAV110524101","","700.00","2024-05-11","0","1","2024-05-11 03:42:24");
INSERT INTO tbl_payvoucher VALUES("227","PAV110524102","","15000.00","2024-05-11","0","1","2024-05-11 07:24:25");
INSERT INTO tbl_payvoucher VALUES("228","PAV120524101","","800000.00","2024-05-12","0","1","2024-05-12 01:28:12");
INSERT INTO tbl_payvoucher VALUES("229","PAV120524102","","3350.00","2024-05-12","0","1","2024-05-12 01:41:48");
INSERT INTO tbl_payvoucher VALUES("230","PAV120524103","","3168100.00","2024-05-12","0","1","2024-05-12 05:09:36");
INSERT INTO tbl_payvoucher VALUES("231","PAV120524104","","1500000.00","2024-05-12","0","1","2024-05-12 09:29:12");
INSERT INTO tbl_payvoucher VALUES("232","PAV120524105","","215000.00","2024-05-12","0","1","2024-05-12 09:31:30");
INSERT INTO tbl_payvoucher VALUES("233","PAV130524101","","600000.00","2024-05-13","0","1","2024-05-13 11:50:23");
INSERT INTO tbl_payvoucher VALUES("234","PAV130524102","","300000.00","2024-05-13","0","1","2024-05-13 05:37:48");
INSERT INTO tbl_payvoucher VALUES("235","PAV140524101","","5250.00","2024-05-13","0","1","2024-05-14 09:16:39");
INSERT INTO tbl_payvoucher VALUES("236","PAV140524102","","509582.00","2024-05-13","0","1","2024-05-14 09:19:43");
INSERT INTO tbl_payvoucher VALUES("237","PAV140524103","","213830.00","2024-05-13","0","1","2024-05-14 09:25:39");
INSERT INTO tbl_payvoucher VALUES("238","PAV140524104","","2750.00","2024-05-14","0","1","2024-05-14 10:37:36");
INSERT INTO tbl_payvoucher VALUES("239","PAV140524105","","3013169.00","2024-05-14","0","1","2024-05-14 12:30:12");
INSERT INTO tbl_payvoucher VALUES("240","PAV140524106","","300000.00","2024-05-14","0","1","2024-05-14 03:51:38");
INSERT INTO tbl_payvoucher VALUES("241","PAV140524107","","23499.00","2024-05-14","0","1","2024-05-14 03:52:00");
INSERT INTO tbl_payvoucher VALUES("242","PAV140524108","","3200.00","2024-05-14","0","1","2024-05-14 07:19:33");
INSERT INTO tbl_payvoucher VALUES("243","PAV150524101","","10000000.00","2024-05-15","0","1","2024-05-15 02:04:19");
INSERT INTO tbl_payvoucher VALUES("244","PAV150524102","","2008245.00","2024-05-15","0","1","2024-05-15 06:06:06");
INSERT INTO tbl_payvoucher VALUES("245","PAV150524103","","149600.00","2024-05-15","0","1","2024-05-15 08:25:43");
INSERT INTO tbl_payvoucher VALUES("246","PAV160524101","","375000.00","2024-05-15","0","1","2024-05-16 08:23:13");
INSERT INTO tbl_payvoucher VALUES("247","PAV160524102","","300.00","2024-05-14","0","1","2024-05-16 08:26:06");
INSERT INTO tbl_payvoucher VALUES("248","PAV160524103","","105.00","2024-05-14","0","1","2024-05-16 08:26:54");
INSERT INTO tbl_payvoucher VALUES("249","PAV160524104","","10000.00","2024-05-15","0","1","2024-05-16 09:01:01");
INSERT INTO tbl_payvoucher VALUES("251","PAV160524106","","444100.00","2024-05-16","0","1","2024-05-16 12:15:17");
INSERT INTO tbl_payvoucher VALUES("252","PAV160524107","","3908000.00","2024-05-16","0","1","2024-05-16 06:07:20");
INSERT INTO tbl_payvoucher VALUES("253","PAV160524108","","41580.00","2024-05-16","0","1","2024-05-16 06:24:44");
INSERT INTO tbl_payvoucher VALUES("254","PAV160524109","","65040.00","2024-05-16","0","1","2024-05-16 09:15:12");
INSERT INTO tbl_payvoucher VALUES("255","PAV160524110","","25000.00","2024-05-16","0","1","2024-05-16 09:28:14");
INSERT INTO tbl_payvoucher VALUES("257","PAV170524102","","28900.00","2024-05-17","0","1","2024-05-17 11:57:41");
INSERT INTO tbl_payvoucher VALUES("258","PAV170524103","","2000.00","2024-05-17","0","1","2024-05-17 06:42:47");
INSERT INTO tbl_payvoucher VALUES("259","PAV170524104","","1090075.00","2024-05-17","0","1","2024-05-17 09:18:53");
INSERT INTO tbl_payvoucher VALUES("260","PAV180524101","","16920.00","2024-05-18","0","1","2024-05-18 02:46:22");
INSERT INTO tbl_payvoucher VALUES("261","PAV180524102","","800.00","2024-05-18","0","1","2024-05-18 08:43:07");
INSERT INTO tbl_payvoucher VALUES("264","PAV190524102","","1140000.00","2024-05-19","0","1","2024-05-19 02:27:27");
INSERT INTO tbl_payvoucher VALUES("265","PAV190524103","","368424.00","2024-05-01","0","1","2024-05-19 02:29:57");
INSERT INTO tbl_payvoucher VALUES("266","PAV190524104","","220.00","2024-05-19","0","1","2024-05-19 03:58:07");
INSERT INTO tbl_payvoucher VALUES("267","PAV190524105","","3061850.00","2024-05-19","0","1","2024-05-19 04:42:13");
INSERT INTO tbl_payvoucher VALUES("269","PAV190524106","","24900.00","2024-05-19","0","1","2024-05-19 08:01:36");
INSERT INTO tbl_payvoucher VALUES("270","PAV190524107","","839550.00","2024-05-19","0","1","2024-05-19 11:18:10");
INSERT INTO tbl_payvoucher VALUES("271","PAV200524101","","500000.00","2024-05-20","0","1","2024-05-20 12:13:05");
INSERT INTO tbl_payvoucher VALUES("272","PAV200524102","","701300.00","2024-05-20","0","1","2024-05-20 02:41:50");
INSERT INTO tbl_payvoucher VALUES("273","PAV200524103","","7600.00","2024-05-20","0","1","2024-05-20 02:48:45");
INSERT INTO tbl_payvoucher VALUES("274","PAV200524104","","29370.00","2024-05-20","0","1","2024-05-20 02:59:08");
INSERT INTO tbl_payvoucher VALUES("275","PAV200524105","","140630.00","2024-05-20","0","1","2024-05-20 03:25:42");
INSERT INTO tbl_payvoucher VALUES("276","PAV200524106","","500000.00","2024-05-20","0","1","2024-05-20 05:22:50");
INSERT INTO tbl_payvoucher VALUES("277","PAV200524107","","18350.00","2024-05-20","0","1","2024-05-20 06:35:02");
INSERT INTO tbl_payvoucher VALUES("278","PAV210524101","","980.00","2024-05-21","0","1","2024-05-21 12:15:25");
INSERT INTO tbl_payvoucher VALUES("279","PAV210524102","","4000.00","2024-05-20","0","1","2024-05-21 12:22:12");
INSERT INTO tbl_payvoucher VALUES("280","PAV210524103","","6420.00","2024-05-16","0","1","2024-05-21 01:18:52");
INSERT INTO tbl_payvoucher VALUES("281","PAV210524104","","48100.00","2024-05-21","0","1","2024-05-21 09:07:05");
INSERT INTO tbl_payvoucher VALUES("282","PAV210524105","","300000.00","2024-05-19","0","1","2024-05-21 09:16:52");
INSERT INTO tbl_payvoucher VALUES("283","PAV210524106","","450.00","2024-05-21","0","1","2024-05-21 09:18:10");
INSERT INTO tbl_payvoucher VALUES("284","PAV220524101","","90460.00","2024-05-22","0","1","2024-05-22 08:05:04");
INSERT INTO tbl_payvoucher VALUES("285","PAV230524101","","1096460.00","2024-05-23","0","1","2024-05-23 06:12:43");
INSERT INTO tbl_payvoucher VALUES("286","PAV230524102","","321230.00","2024-05-23","0","1","2024-05-23 09:57:31");
INSERT INTO tbl_payvoucher VALUES("287","PAV240524101","","30400.00","2024-05-11","0","1","2024-05-24 10:38:11");
INSERT INTO tbl_payvoucher VALUES("288","PAV240524102","","41150.00","2024-05-24","0","1","2024-05-24 07:47:21");
INSERT INTO tbl_payvoucher VALUES("289","PAV250524101","","1692640.00","2024-05-25","0","1","2024-05-25 02:19:55");
INSERT INTO tbl_payvoucher VALUES("290","PAV250524102","","9160.00","2024-05-25","0","1","2024-05-25 02:22:00");
INSERT INTO tbl_payvoucher VALUES("291","PAV250524103","","500000.00","2024-05-25","0","1","2024-05-25 02:23:02");
INSERT INTO tbl_payvoucher VALUES("292","PAV260524101","","100000.00","2024-05-26","0","1","2024-05-26 10:25:50");
INSERT INTO tbl_payvoucher VALUES("293","PAV260524102","","2150.00","2024-05-26","0","1","2024-05-26 10:26:56");
INSERT INTO tbl_payvoucher VALUES("294","PAV260524103","","120.00","2024-05-26","0","1","2024-05-26 10:31:59");
INSERT INTO tbl_payvoucher VALUES("295","PAV260524104","","200800.00","2024-05-26","0","1","2024-05-26 02:00:51");
INSERT INTO tbl_payvoucher VALUES("296","PAV270524101","","1246500.00","2024-05-26","0","1","2024-05-27 10:15:46");
INSERT INTO tbl_payvoucher VALUES("297","PAV270524102","","17860.00","2024-05-27","0","1","2024-05-27 10:17:29");
INSERT INTO tbl_payvoucher VALUES("298","PAV270524103","","74750.00","2024-05-26","0","1","2024-05-27 01:05:20");
INSERT INTO tbl_payvoucher VALUES("299","PAV280524101","","4699499.00","2024-05-28","0","1","2024-05-28 07:30:16");
INSERT INTO tbl_payvoucher VALUES("300","PAV290524101","","914400.00","2024-05-29","0","1","2024-05-29 06:18:45");
INSERT INTO tbl_payvoucher VALUES("301","PAV290524102","","1100000.00","2024-05-29","0","1","2024-05-29 06:37:03");
INSERT INTO tbl_payvoucher VALUES("302","PAV290524103","","100000.00","2024-05-29","0","1","2024-05-29 09:29:11");
INSERT INTO tbl_payvoucher VALUES("303","PAV300524101","","1233200.00","2024-05-30","0","1","2024-05-30 09:03:37");
INSERT INTO tbl_payvoucher VALUES("304","PAV300524102","","500000.00","2024-05-30","0","1","2024-05-30 09:31:39");
INSERT INTO tbl_payvoucher VALUES("305","PAV300524103","","1637910.00","2024-05-30","0","1","2024-05-30 09:54:29");
INSERT INTO tbl_payvoucher VALUES("306","PAV310524101","","45220.00","2024-05-31","0","1","2024-05-31 05:10:54");
INSERT INTO tbl_payvoucher VALUES("307","PAV310524102","","34300.00","2024-05-31","0","1","2024-05-31 08:22:50");
INSERT INTO tbl_payvoucher VALUES("308","PAV310524103","","10000.00","2024-05-31","0","1","2024-05-31 08:25:19");
INSERT INTO tbl_payvoucher VALUES("309","PAV310524104","","16800.00","2024-05-31","0","1","2024-05-31 08:51:18");
INSERT INTO tbl_payvoucher VALUES("310","PAV010624101","","30500.00","2024-06-01","0","1","2024-06-01 06:27:48");
INSERT INTO tbl_payvoucher VALUES("311","PAV010624102","","2320.00","2024-06-01","0","1","2024-06-01 09:33:23");
INSERT INTO tbl_payvoucher VALUES("312","PAV020624101","","286867.50","2024-05-30","0","1","2024-06-02 06:12:11");
INSERT INTO tbl_payvoucher VALUES("313","PAV020624102","Pu","1995500.00","2024-06-02","0","1","2024-06-02 09:39:56");
INSERT INTO tbl_payvoucher VALUES("314","PAV020624103","","22000.00","2024-06-02","0","1","2024-06-02 09:47:20");
INSERT INTO tbl_payvoucher VALUES("316","PAV030624102","","200.00","2024-06-03","0","1","2024-06-03 09:04:32");
INSERT INTO tbl_payvoucher VALUES("317","PAV030624103","","7242500.00","2024-06-03","0","1","2024-06-03 02:32:54");
INSERT INTO tbl_payvoucher VALUES("318","PAV030624104","","77110.00","2024-06-03","0","1","2024-06-03 10:39:12");
INSERT INTO tbl_payvoucher VALUES("319","PAV040624101","","140700.00","2024-06-04","0","1","2024-06-04 08:55:11");
INSERT INTO tbl_payvoucher VALUES("321","PAV040624103","","525.00","2024-05-30","0","1","2024-06-04 10:09:25");
INSERT INTO tbl_payvoucher VALUES("322","PAV040624104","","2020.00","2024-06-04","0","1","2024-06-04 02:49:49");
INSERT INTO tbl_payvoucher VALUES("323","PAV040624105","","372150.00","2024-06-04","0","1","2024-06-04 03:04:08");
INSERT INTO tbl_payvoucher VALUES("324","PAV040624106","","149805.00","2024-06-04","0","1","2024-06-04 09:52:07");
INSERT INTO tbl_payvoucher VALUES("325","PAV040624107","","5000.00","2024-06-04","0","1","2024-06-04 10:08:15");
INSERT INTO tbl_payvoucher VALUES("326","PAV050624101","","1136870.00","2024-06-05","0","1","2024-06-05 09:03:37");
INSERT INTO tbl_payvoucher VALUES("327","PAV050624102","","10560.00","2024-06-05","0","1","2024-06-05 09:43:10");
INSERT INTO tbl_payvoucher VALUES("328","PAV060624101","","11050.00","2024-06-06","0","1","2024-06-06 01:57:37");
INSERT INTO tbl_payvoucher VALUES("329","PAV060624102","","1700.00","2024-06-06","0","1","2024-06-06 03:56:11");
INSERT INTO tbl_payvoucher VALUES("330","PAV060624103","","1090160.00","2024-06-06","0","1","2024-06-06 05:50:12");
INSERT INTO tbl_payvoucher VALUES("331","PAV060624104","","363200.00","2024-06-06","0","1","2024-06-06 06:51:24");
INSERT INTO tbl_payvoucher VALUES("332","PAV060624105","","70000.00","2024-06-06","0","1","2024-06-06 08:20:47");
INSERT INTO tbl_payvoucher VALUES("333","PAV070624101","","650065.00","2024-06-07","0","1","2024-06-07 10:34:36");
INSERT INTO tbl_payvoucher VALUES("334","PAV070624102","","7900.00","2024-06-06","0","1","2024-06-07 08:11:55");
INSERT INTO tbl_payvoucher VALUES("335","PAV080624101","","17720.00","2024-06-08","0","1","2024-06-08 11:06:03");
INSERT INTO tbl_payvoucher VALUES("336","PAV080624102","","55000.00","2024-06-07","0","1","2024-06-08 11:13:53");
INSERT INTO tbl_payvoucher VALUES("337","PAV080624103","","20600.00","2024-06-08","0","1","2024-06-08 02:22:42");
INSERT INTO tbl_payvoucher VALUES("338","PAV080624104","","2510.00","2024-06-08","0","1","2024-06-08 02:24:33");
INSERT INTO tbl_payvoucher VALUES("339","PAV080624105","","24050.00","2024-06-08","0","1","2024-06-08 05:41:04");
INSERT INTO tbl_payvoucher VALUES("340","PAV090624101","","10420.00","2024-06-08","0","1","2024-06-09 08:54:32");
INSERT INTO tbl_payvoucher VALUES("342","PAV090624103","","236700.00","2024-06-09","0","1","2024-06-09 06:34:38");
INSERT INTO tbl_payvoucher VALUES("343","PAV090624104","","1000000.00","2024-06-09","0","1","2024-06-09 07:45:18");
INSERT INTO tbl_payvoucher VALUES("344","PAV090624105","","8345.00","2024-06-09","0","1","2024-06-09 09:14:41");
INSERT INTO tbl_payvoucher VALUES("345","PAV100624101","","20559595.00","2024-06-10","0","1","2024-06-10 07:57:40");
INSERT INTO tbl_payvoucher VALUES("346","PAV100624102","","340.00","2024-06-10","0","1","2024-06-10 08:04:22");
INSERT INTO tbl_payvoucher VALUES("347","PAV100624103","","9000.00","2024-06-10","0","1","2024-06-10 10:31:24");
INSERT INTO tbl_payvoucher VALUES("348","PAV110624101","","9000.00","2024-06-10","0","1","2024-06-11 08:09:42");
INSERT INTO tbl_payvoucher VALUES("349","PAV110624102","","234500.00","2024-06-11","0","1","2024-06-11 03:42:50");
INSERT INTO tbl_payvoucher VALUES("350","PAV110624103","","10593899.00","2024-06-11","0","1","2024-06-11 06:25:11");
INSERT INTO tbl_payvoucher VALUES("351","PAV110624104","","400000.00","2024-06-10","0","1","2024-06-11 08:15:06");
INSERT INTO tbl_payvoucher VALUES("352","PAV110624105","","10785.00","2024-06-11","0","1","2024-06-11 08:51:58");
INSERT INTO tbl_payvoucher VALUES("353","PAV110624106","","300.00","2024-06-11","0","1","2024-06-11 08:54:02");
INSERT INTO tbl_payvoucher VALUES("354","PAV110624107","","300000.00","2024-06-11","0","1","2024-06-11 09:16:03");
INSERT INTO tbl_payvoucher VALUES("355","PAV120624101","","20800.00","2024-06-12","0","1","2024-06-12 03:18:30");
INSERT INTO tbl_payvoucher VALUES("356","PAV120624102","","6000.00","2024-06-12","0","1","2024-06-12 08:56:22");
INSERT INTO tbl_payvoucher VALUES("357","PAV130624101","","12580.00","2024-06-13","0","1","2024-06-13 03:55:32");
INSERT INTO tbl_payvoucher VALUES("358","PAV130624102","","150.00","2024-06-13","0","1","2024-06-13 03:56:41");
INSERT INTO tbl_payvoucher VALUES("359","PAV130624103","","6091510.00","2024-06-13","0","1","2024-06-13 09:28:09");
INSERT INTO tbl_payvoucher VALUES("360","PAV130624104","","500.00","2024-06-13","0","1","2024-06-13 09:30:17");
INSERT INTO tbl_payvoucher VALUES("361","PAV140624101","","150.00","2024-06-14","0","1","2024-06-14 06:52:38");
INSERT INTO tbl_payvoucher VALUES("362","PAV140624102","","5000.00","2024-06-14","0","1","2024-06-14 08:14:38");
INSERT INTO tbl_payvoucher VALUES("363","PAV140624103","","51000.00","2024-06-14","0","1","2024-06-14 08:36:04");
INSERT INTO tbl_payvoucher VALUES("364","PAV150624101","","24450.00","2024-06-15","0","1","2024-06-15 08:25:54");
INSERT INTO tbl_payvoucher VALUES("365","PAV160624101","","33080.00","2024-06-16","0","1","2024-06-16 10:56:28");
INSERT INTO tbl_payvoucher VALUES("366","PAV160624102","","72520.00","2024-06-16","0","1","2024-06-16 03:44:03");
INSERT INTO tbl_payvoucher VALUES("367","PAV160624103","","350000.00","2024-06-16","0","1","2024-06-16 05:07:00");
INSERT INTO tbl_payvoucher VALUES("368","PAV160624104","","80000.00","2024-06-16","0","1","2024-06-16 05:55:20");
INSERT INTO tbl_payvoucher VALUES("369","PAV160624105","","300000.00","2024-06-16","0","1","2024-06-16 05:58:19");
INSERT INTO tbl_payvoucher VALUES("370","PAV170624101","","670100.00","2024-06-16","0","1","2024-06-17 07:58:46");
INSERT INTO tbl_payvoucher VALUES("371","PAV210624101","","3495000.00","2024-06-21","0","1","2024-06-21 11:40:52");
INSERT INTO tbl_payvoucher VALUES("372","PAV210624102","","40000.00","2024-06-21","0","1","2024-06-21 11:41:35");
INSERT INTO tbl_payvoucher VALUES("373","PAV210624103","","1000000.00","2024-06-21","0","1","2024-06-21 12:17:46");
INSERT INTO tbl_payvoucher VALUES("374","PAV210624104","","1176551.00","2024-06-21","0","1","2024-06-21 09:39:49");
INSERT INTO tbl_payvoucher VALUES("375","PAV220624101","","1000.00","2024-06-22","0","1","2024-06-22 12:14:21");
INSERT INTO tbl_payvoucher VALUES("376","PAV220624102","","50000.00","2024-06-22","0","1","2024-06-22 07:45:35");
INSERT INTO tbl_payvoucher VALUES("377","PAV230624101","","3670000.00","2024-06-23","0","1","2024-06-23 03:55:04");
INSERT INTO tbl_payvoucher VALUES("378","PAV230624102","","317500.00","2024-06-23","0","1","2024-06-23 09:01:35");
INSERT INTO tbl_payvoucher VALUES("379","PAV230624103","","291400.00","2024-06-23","0","1","2024-06-23 09:02:01");
INSERT INTO tbl_payvoucher VALUES("380","PAV230624104","","20005.00","2024-06-23","0","1","2024-06-23 09:08:10");
INSERT INTO tbl_payvoucher VALUES("381","PAV240624101","","8900.00","2024-06-24","0","1","2024-06-24 10:47:21");
INSERT INTO tbl_payvoucher VALUES("382","PAV240624102","","316375.00","2024-06-24","0","1","2024-06-24 12:22:07");
INSERT INTO tbl_payvoucher VALUES("383","PAV240624103","","6700.00","2024-06-24","0","1","2024-06-24 03:42:48");
INSERT INTO tbl_payvoucher VALUES("384","PAV240624104","","40525.00","2024-06-24","0","1","2024-06-24 08:40:51");
INSERT INTO tbl_payvoucher VALUES("385","PAV250624101","","1000.00","2024-06-25","0","1","2024-06-25 11:17:03");
INSERT INTO tbl_payvoucher VALUES("386","PAV250624102","","1600.00","2024-06-25","0","1","2024-06-25 11:17:53");
INSERT INTO tbl_payvoucher VALUES("387","PAV250624103","","1000.00","2024-06-25","0","1","2024-06-25 11:25:20");
INSERT INTO tbl_payvoucher VALUES("388","PAV250624104","","2000000.00","2024-06-25","0","1","2024-06-25 05:29:25");
INSERT INTO tbl_payvoucher VALUES("389","PAV250624105","","4505.00","2024-06-25","0","1","2024-06-25 08:43:43");
INSERT INTO tbl_payvoucher VALUES("390","PAV250624106","","280000.00","2024-06-25","0","1","2024-06-25 08:49:14");
INSERT INTO tbl_payvoucher VALUES("391","PAV260624101","","60000.00","2024-06-14","0","1","2024-06-26 10:28:20");
INSERT INTO tbl_payvoucher VALUES("392","PAV260624102","","3900.00","2024-06-14","0","1","2024-06-26 10:48:36");
INSERT INTO tbl_payvoucher VALUES("393","PAV260624103","","6000.00","2024-06-26","0","1","2024-06-26 03:34:37");
INSERT INTO tbl_payvoucher VALUES("394","PAV260624104","","2608767.00","2024-06-26","0","1","2024-06-26 05:57:15");
INSERT INTO tbl_payvoucher VALUES("395","PAV260624105","","5100.00","2024-06-26","0","1","2024-06-26 07:57:02");
INSERT INTO tbl_payvoucher VALUES("396","PAV270624101","","1000000.00","2024-06-27","0","1","2024-06-27 11:19:06");
INSERT INTO tbl_payvoucher VALUES("397","PAV270624102","","1008350.00","2024-06-27","0","1","2024-06-27 04:13:12");
INSERT INTO tbl_payvoucher VALUES("398","PAV270624103","","4000.00","2024-06-27","0","1","2024-06-27 04:13:56");
INSERT INTO tbl_payvoucher VALUES("399","PAV270624104","","400000.00","2024-06-27","0","1","2024-06-27 04:33:06");
INSERT INTO tbl_payvoucher VALUES("400","PAV270624105","","920018.00","2024-06-27","0","1","2024-06-27 08:06:05");
INSERT INTO tbl_payvoucher VALUES("401","PAV270624106","","5000.00","2024-06-27","0","1","2024-06-27 08:11:49");
INSERT INTO tbl_payvoucher VALUES("403","PAV270624108","","3900.00","2024-06-27","0","1","2024-06-27 08:56:13");
INSERT INTO tbl_payvoucher VALUES("404","PAV280624101","","11300.00","2024-06-28","0","1","2024-06-28 06:36:37");
INSERT INTO tbl_payvoucher VALUES("405","PAV280624102","","3000.00","2024-06-28","0","1","2024-06-28 08:06:36");
INSERT INTO tbl_payvoucher VALUES("406","PAV290624101","","11910.00","2024-06-29","0","1","2024-06-29 07:20:40");
INSERT INTO tbl_payvoucher VALUES("407","PAV290624102","","600.00","2024-06-29","0","1","2024-06-29 07:27:37");
INSERT INTO tbl_payvoucher VALUES("408","PAV300624101","","381380.00","2024-06-30","0","1","2024-06-30 06:11:52");
INSERT INTO tbl_payvoucher VALUES("409","PAV010724101","","500000.00","2024-07-01","0","1","2024-07-01 09:16:52");
INSERT INTO tbl_payvoucher VALUES("410","PAV010724102","","16500.00","2024-07-01","0","1","2024-07-01 06:39:44");
INSERT INTO tbl_payvoucher VALUES("411","PAV020724101","","1400000.00","2024-06-30","0","1","2024-07-02 01:40:20");
INSERT INTO tbl_payvoucher VALUES("412","PAV020724102","","100000.00","2024-07-02","0","1","2024-07-02 01:40:43");
INSERT INTO tbl_payvoucher VALUES("413","PAV020724103","","1000.00","2024-07-01","0","1","2024-07-02 01:44:26");
INSERT INTO tbl_payvoucher VALUES("414","PAV020724104","","52000.00","2024-07-02","0","1","2024-07-02 02:14:22");
INSERT INTO tbl_payvoucher VALUES("415","PAV030724101","","12410.00","2024-07-03","0","1","2024-07-03 01:21:33");
INSERT INTO tbl_payvoucher VALUES("416","PAV030724102","","186000.00","2024-07-03","0","1","2024-07-03 01:22:35");
INSERT INTO tbl_payvoucher VALUES("417","PAV040724101","","6500.00","2024-07-03","0","1","2024-07-04 09:00:23");
INSERT INTO tbl_payvoucher VALUES("418","PAV040724102","","2107500.00","2024-07-04","0","1","2024-07-04 02:27:27");
INSERT INTO tbl_payvoucher VALUES("419","PAV040724103","","100000.00","2024-07-04","0","1","2024-07-04 09:20:18");
INSERT INTO tbl_payvoucher VALUES("420","PAV050724101","","421300.00","2024-07-04","0","1","2024-07-05 09:57:47");
INSERT INTO tbl_payvoucher VALUES("421","PAV050724102","","500000.00","2024-07-04","0","1","2024-07-05 11:35:19");
INSERT INTO tbl_payvoucher VALUES("423","PAV050724103","","100000.00","2024-07-03","0","1","2024-07-05 11:42:29");
INSERT INTO tbl_payvoucher VALUES("424","PAV050724104","","27600.00","2024-07-05","0","1","2024-07-05 08:25:23");
INSERT INTO tbl_payvoucher VALUES("425","PAV050724105","","3400.00","2024-07-05","0","1","2024-07-05 08:28:49");
INSERT INTO tbl_payvoucher VALUES("426","PAV060724101","","1600.00","2024-07-04","0","1","2024-07-06 11:23:14");
INSERT INTO tbl_payvoucher VALUES("427","PAV060724102","","27400.00","2024-05-28","0","1","2024-07-06 12:13:43");
INSERT INTO tbl_payvoucher VALUES("428","PAV060724103","","67587.00","2024-07-04","0","1","2024-07-06 12:45:46");
INSERT INTO tbl_payvoucher VALUES("429","PAV060724104","","300000.00","2024-06-27","0","1","2024-07-06 01:47:02");
INSERT INTO tbl_payvoucher VALUES("430","PAV060724105","","5810.00","2024-07-06","0","1","2024-07-06 06:32:34");
INSERT INTO tbl_payvoucher VALUES("431","PAV060724106","","19625.00","2024-07-06","0","1","2024-07-06 08:47:01");
INSERT INTO tbl_payvoucher VALUES("434","PAV060724108","","6000.00","2024-07-06","0","1","2024-07-06 09:13:50");
INSERT INTO tbl_payvoucher VALUES("435","PAV070724101","","4000.00","2024-07-07","0","1","2024-07-07 02:34:24");
INSERT INTO tbl_payvoucher VALUES("436","PAV070724102","","2000000.00","2024-07-07","0","1","2024-07-07 02:38:37");
INSERT INTO tbl_payvoucher VALUES("437","PAV070724103","","1950.00","2024-07-07","0","1","2024-07-07 02:39:34");
INSERT INTO tbl_payvoucher VALUES("438","PAV070724104","","50000.00","2024-07-07","0","1","2024-07-07 02:40:31");
INSERT INTO tbl_payvoucher VALUES("439","PAV070724105","","2321000.00","2024-07-07","0","1","2024-07-07 04:37:01");
INSERT INTO tbl_payvoucher VALUES("440","PAV070724106","","37140.00","2024-07-07","0","1","2024-07-07 08:30:57");
INSERT INTO tbl_payvoucher VALUES("441","PAV080724101","","5000.00","2024-07-06","0","1","2024-07-08 08:56:39");
INSERT INTO tbl_payvoucher VALUES("442","PAV080724102","","5000.00","2024-07-06","0","1","2024-07-08 02:44:29");
INSERT INTO tbl_payvoucher VALUES("443","PAV080724103","","500000.00","2024-07-08","0","1","2024-07-08 02:48:42");
INSERT INTO tbl_payvoucher VALUES("444","PAV080724104","","1140000.00","2024-07-08","0","1","2024-07-08 05:26:31");
INSERT INTO tbl_payvoucher VALUES("445","PAV080724105","","5000.00","2024-07-08","0","1","2024-07-08 08:07:26");
INSERT INTO tbl_payvoucher VALUES("446","PAV080724106","","100000.00","2024-07-08","0","1","2024-07-08 08:08:05");
INSERT INTO tbl_payvoucher VALUES("447","PAV080724107","","400000.00","2024-07-08","0","1","2024-07-08 08:20:32");
INSERT INTO tbl_payvoucher VALUES("448","PAV090724101","","135015.00","2024-07-09","0","1","2024-07-09 12:47:00");
INSERT INTO tbl_payvoucher VALUES("449","PAV090724102","","75000.00","2024-07-09","0","1","2024-07-09 02:27:20");
INSERT INTO tbl_payvoucher VALUES("450","PAV090724103","","12350.00","2024-07-09","0","1","2024-07-09 02:30:06");
INSERT INTO tbl_payvoucher VALUES("451","PAV090724104","","56000.00","2024-07-09","0","1","2024-07-09 05:22:36");
INSERT INTO tbl_payvoucher VALUES("452","PAV090724105","","65000.00","2024-05-30","0","1","2024-07-09 05:23:12");
INSERT INTO tbl_payvoucher VALUES("453","PAV090724106","","150.00","2024-07-09","0","1","2024-07-09 08:42:26");
INSERT INTO tbl_payvoucher VALUES("454","PAV100724101","","29120.00","2024-07-10","0","1","2024-07-10 09:05:58");
INSERT INTO tbl_payvoucher VALUES("455","PAV100724102","","50000.00","2024-04-24","0","1","2024-07-10 11:15:19");
INSERT INTO tbl_payvoucher VALUES("456","PAV100724103","","100000.00","2024-07-10","0","1","2024-07-10 05:47:56");
INSERT INTO tbl_payvoucher VALUES("457","PAV100724104","","1814990.00","2024-07-10","0","1","2024-07-10 05:58:34");
INSERT INTO tbl_payvoucher VALUES("458","PAV110724101","","950000.00","2024-07-11","0","1","2024-07-11 12:25:51");
INSERT INTO tbl_payvoucher VALUES("459","PAV110724102","","1292610.00","2024-07-11","0","1","2024-07-11 06:05:47");
INSERT INTO tbl_payvoucher VALUES("460","PAV110724103","","130000.00","2024-07-11","0","1","2024-07-11 06:12:19");
INSERT INTO tbl_payvoucher VALUES("461","PAV130724101","","58690.00","2024-07-12","0","1","2024-07-13 08:55:01");
INSERT INTO tbl_payvoucher VALUES("462","PAV130724102","","4500.00","2024-07-13","0","1","2024-07-13 10:16:24");
INSERT INTO tbl_payvoucher VALUES("463","PAV130724103","","239000.00","2024-07-11","0","1","2024-07-13 05:02:08");
INSERT INTO tbl_payvoucher VALUES("464","PAV130724104","","6500.00","2024-07-13","0","1","2024-07-13 05:13:37");
INSERT INTO tbl_payvoucher VALUES("465","PAV140724101","","400.00","2024-07-14","0","1","2024-07-14 02:26:54");
INSERT INTO tbl_payvoucher VALUES("466","PAV140724102","","2647050.00","2024-07-14","0","1","2024-07-14 04:29:59");
INSERT INTO tbl_payvoucher VALUES("467","PAV140724103","","1316650.00","2024-07-14","0","1","2024-07-14 05:59:18");
INSERT INTO tbl_payvoucher VALUES("468","PAV140724104","","500000.00","2024-07-14","0","1","2024-07-14 07:18:20");
INSERT INTO tbl_payvoucher VALUES("469","PAV140724105","","485460.00","2024-07-14","0","1","2024-07-14 08:29:03");
INSERT INTO tbl_payvoucher VALUES("470","PAV150724101","","22089.00","2024-07-15","0","1","2024-07-15 01:39:24");
INSERT INTO tbl_payvoucher VALUES("471","PAV150724102","","1399000.00","2024-07-15","0","1","2024-07-15 04:58:46");
INSERT INTO tbl_payvoucher VALUES("473","PAV160724101","","9000.00","2024-07-16","0","1","2024-07-16 02:52:50");
INSERT INTO tbl_payvoucher VALUES("474","PAV160724102","","6300.00","2024-07-16","0","1","2024-07-16 03:02:21");
INSERT INTO tbl_payvoucher VALUES("475","PAV160724103","","500000.00","2024-07-16","0","1","2024-07-16 08:57:29");
INSERT INTO tbl_payvoucher VALUES("476","PAV160724104","","686500.00","2024-07-16","0","1","2024-07-16 09:05:44");
INSERT INTO tbl_payvoucher VALUES("477","PAV160724105","","5000.00","2024-07-16","0","1","2024-07-16 09:07:45");
INSERT INTO tbl_payvoucher VALUES("478","PAV170724101","","30500.00","2024-07-17","0","1","2024-07-17 12:59:38");
INSERT INTO tbl_payvoucher VALUES("479","PAV170724102","","7430.00","2024-07-17","0","1","2024-07-17 01:26:57");
INSERT INTO tbl_payvoucher VALUES("480","PAV170724103","","85000.00","2024-07-17","0","1","2024-07-17 06:09:39");
INSERT INTO tbl_payvoucher VALUES("481","PAV170724104","","4600.00","2024-07-17","0","1","2024-07-17 08:09:07");
INSERT INTO tbl_payvoucher VALUES("482","PAV180724101","","2068300.00","2024-07-18","0","1","2024-07-18 03:51:37");
INSERT INTO tbl_payvoucher VALUES("484","PAV180724102","","2660000.00","2024-07-15","0","1","2024-07-18 04:37:53");
INSERT INTO tbl_payvoucher VALUES("485","PAV180724103","","966000.00","2024-04-04","0","1","2024-07-18 04:49:09");
INSERT INTO tbl_payvoucher VALUES("486","PAV180724104","","2967200.00","2024-07-18","0","1","2024-07-18 05:21:41");
INSERT INTO tbl_payvoucher VALUES("487","PAV180724105","","17200.00","2024-07-18","0","1","2024-07-18 05:25:48");
INSERT INTO tbl_payvoucher VALUES("488","PAV250724101","","10150.00","2024-07-18","0","1","2024-07-25 08:11:10");
INSERT INTO tbl_payvoucher VALUES("489","PAV250724102","","20000.00","2024-07-19","0","1","2024-07-25 09:48:38");
INSERT INTO tbl_payvoucher VALUES("490","PAV250724103","","2438000.00","2024-07-25","0","1","2024-07-25 04:09:48");
INSERT INTO tbl_payvoucher VALUES("491","PAV250724104","","300000.00","2024-07-23","0","1","2024-07-25 06:35:28");
INSERT INTO tbl_payvoucher VALUES("492","PAV250724105","","175000.00","2024-07-25","0","1","2024-07-25 08:10:08");
INSERT INTO tbl_payvoucher VALUES("493","PAV260724101","","21520.00","2024-07-25","0","1","2024-07-26 10:50:47");
INSERT INTO tbl_payvoucher VALUES("494","PAV260724102","","2000000.00","2024-07-24","0","1","2024-07-26 12:25:54");
INSERT INTO tbl_payvoucher VALUES("495","PAV270724101","","117840.00","2024-07-26","0","1","2024-07-27 08:17:57");
INSERT INTO tbl_payvoucher VALUES("496","PAV270724102","","48490.00","2024-07-20","0","1","2024-07-27 08:41:34");
INSERT INTO tbl_payvoucher VALUES("497","PAV270724103","","509550.00","2024-07-21","0","1","2024-07-27 08:48:56");
INSERT INTO tbl_payvoucher VALUES("498","PAV270724104","","5280.00","2024-07-22","0","1","2024-07-27 08:50:10");
INSERT INTO tbl_payvoucher VALUES("499","PAV270724105","","218550.00","2024-07-23","0","1","2024-07-27 08:53:35");
INSERT INTO tbl_payvoucher VALUES("500","PAV270724106","","36200.00","2024-07-18","0","1","2024-07-27 08:54:25");
INSERT INTO tbl_payvoucher VALUES("501","PAV270724107","","1702400.00","2024-07-24","0","1","2024-07-27 09:04:47");
INSERT INTO tbl_payvoucher VALUES("502","PAV270724108","","1000.00","2024-07-24","0","1","2024-07-27 11:50:12");
INSERT INTO tbl_payvoucher VALUES("503","PAV270724109","","110.00","2024-07-27","0","1","2024-07-27 06:43:50");
INSERT INTO tbl_payvoucher VALUES("504","PAV280724101","","40060.00","2024-07-27","0","1","2024-07-28 09:21:21");
INSERT INTO tbl_payvoucher VALUES("505","PAV280724102","","4024390.00","2024-07-28","0","1","2024-07-28 05:52:41");
INSERT INTO tbl_payvoucher VALUES("506","PAV280724103","","300000.00","2024-07-28","0","1","2024-07-28 07:37:39");
INSERT INTO tbl_payvoucher VALUES("507","PAV280724104","","425210.00","2024-07-28","0","1","2024-07-28 09:16:10");
INSERT INTO tbl_payvoucher VALUES("508","PAV290724101","","25300.00","2024-07-28","0","1","2024-07-29 12:24:46");
INSERT INTO tbl_payvoucher VALUES("509","PAV290724102","","800.00","2024-07-29","0","1","2024-07-29 02:10:25");
INSERT INTO tbl_payvoucher VALUES("510","PAV290724103","","3550.00","2024-07-29","0","1","2024-07-29 06:32:05");
INSERT INTO tbl_payvoucher VALUES("511","PAV290724104","","611400.00","2024-07-29","0","1","2024-07-29 08:53:09");
INSERT INTO tbl_payvoucher VALUES("512","PAV300724101","","554390.00","2024-07-30","0","1","2024-07-30 06:16:27");
INSERT INTO tbl_payvoucher VALUES("513","PAV310724101","","2196790.00","2024-07-31","0","1","2024-07-31 08:05:37");
INSERT INTO tbl_payvoucher VALUES("515","PAV020824101","","4359126.50","2024-08-01","0","1","2024-08-02 12:45:13");
INSERT INTO tbl_payvoucher VALUES("516","PAV020824102","","150.00","2024-08-02","0","1","2024-08-02 05:58:46");
INSERT INTO tbl_payvoucher VALUES("517","PAV020824103","","92300.00","2024-08-02","0","1","2024-08-02 06:05:48");
INSERT INTO tbl_payvoucher VALUES("518","PAV030824101","","48050.00","2024-08-03","0","1","2024-08-03 12:29:09");
INSERT INTO tbl_payvoucher VALUES("519","PAV040824101","","25000.00","2023-12-10","0","1","2024-08-04 02:01:15");
INSERT INTO tbl_payvoucher VALUES("520","PAV040824102","","2485470.00","2024-08-04","0","1","2024-08-04 06:04:35");
INSERT INTO tbl_payvoucher VALUES("521","PAV040824103","","270000.00","2024-08-04","0","1","2024-08-04 06:05:04");
INSERT INTO tbl_payvoucher VALUES("522","PAV040824104","","307130.00","2024-08-04","0","1","2024-08-04 08:25:13");
INSERT INTO tbl_payvoucher VALUES("523","PAV040824105","","5200.00","2024-08-04","0","1","2024-08-04 08:44:48");
INSERT INTO tbl_payvoucher VALUES("524","PAV050824101","","92400.00","2024-08-05","0","1","2024-08-05 09:27:01");
INSERT INTO tbl_payvoucher VALUES("525","PAV060824101","","50448.00","2024-08-06","0","1","2024-08-06 09:01:40");
INSERT INTO tbl_payvoucher VALUES("526","PAV060824102","","4900.00","2024-08-05","0","1","2024-08-06 11:46:00");
INSERT INTO tbl_payvoucher VALUES("527","PAV060824103","","730000.00","2024-08-06","0","1","2024-08-06 06:55:05");
INSERT INTO tbl_payvoucher VALUES("528","PAV060824104","","150.00","2024-08-06","0","1","2024-08-06 07:00:55");
INSERT INTO tbl_payvoucher VALUES("529","PAV060824105","","17160.00","2024-08-06","0","1","2024-08-06 08:42:18");
INSERT INTO tbl_payvoucher VALUES("530","PAV070824101","","754145.00","2024-08-07","0","1","2024-08-07 07:55:37");
INSERT INTO tbl_payvoucher VALUES("531","PAV080824101","","512560.00","2024-08-08","0","1","2024-08-08 02:06:11");
INSERT INTO tbl_payvoucher VALUES("532","PAV080824102","","2750000.00","2024-08-08","0","1","2024-08-08 05:39:47");
INSERT INTO tbl_payvoucher VALUES("533","PAV080824103","","3010900.00","2024-08-08","0","1","2024-08-08 07:01:06");
INSERT INTO tbl_payvoucher VALUES("534","PAV080824104","","600000.00","2024-08-08","0","1","2024-08-08 07:32:51");
INSERT INTO tbl_payvoucher VALUES("535","PAV080824105","","2000.00","2024-08-08","0","1","2024-08-08 07:34:02");
INSERT INTO tbl_payvoucher VALUES("536","PAV090824101","","934700.00","2024-08-08","0","1","2024-08-09 06:12:18");
INSERT INTO tbl_payvoucher VALUES("537","PAV090824102","","40770.00","2024-08-09","0","1","2024-08-09 06:15:37");
INSERT INTO tbl_payvoucher VALUES("538","PAV090824103","","46000.00","2024-08-09","0","1","2024-08-09 06:36:46");
INSERT INTO tbl_payvoucher VALUES("539","PAV090824104","","14100.00","2024-08-09","0","1","2024-08-09 08:18:50");
INSERT INTO tbl_payvoucher VALUES("540","PAV100824101","","7000.00","2024-08-10","0","1","2024-08-10 07:30:11");
INSERT INTO tbl_payvoucher VALUES("541","PAV100824102","","226049.00","2024-08-10","0","1","2024-08-10 08:00:47");
INSERT INTO tbl_payvoucher VALUES("542","PAV110824101","","12150.00","2024-08-04","0","1","2024-08-11 12:05:33");
INSERT INTO tbl_payvoucher VALUES("543","PAV110824102","","23280.00","2024-07-18","0","1","2024-08-11 01:12:51");
INSERT INTO tbl_payvoucher VALUES("544","PAV110824103","","15100.00","2024-07-19","0","1","2024-08-11 01:13:40");
INSERT INTO tbl_payvoucher VALUES("545","PAV110824104","","3510.00","2024-08-03","0","1","2024-08-11 01:24:15");
INSERT INTO tbl_payvoucher VALUES("546","PAV110824105","","4147850.00","2024-08-11","0","1","2024-08-11 06:07:46");
INSERT INTO tbl_payvoucher VALUES("547","PAV110824106","","216000.00","2024-08-11","0","1","2024-08-11 09:27:56");
INSERT INTO tbl_payvoucher VALUES("548","PAV110824107","","670.00","2024-08-11","0","1","2024-08-11 09:33:32");
INSERT INTO tbl_payvoucher VALUES("549","PAV120824101","","3644150.00","2024-08-12","0","1","2024-08-12 05:55:54");
INSERT INTO tbl_payvoucher VALUES("550","PAV120824102","","6460.00","2024-08-12","0","1","2024-08-12 09:10:34");
INSERT INTO tbl_payvoucher VALUES("551","PAV130824101","","600.00","2024-08-13","0","1","2024-08-13 01:00:40");
INSERT INTO tbl_payvoucher VALUES("552","PAV130824102","","1077950.00","2024-08-13","0","1","2024-08-13 06:24:18");
INSERT INTO tbl_payvoucher VALUES("553","PAV130824103","","30000.00","2024-08-13","0","1","2024-08-13 06:32:30");
INSERT INTO tbl_payvoucher VALUES("554","PAV130824104","","1134655.00","2024-08-13","0","1","2024-08-13 06:43:13");
INSERT INTO tbl_payvoucher VALUES("555","PAV130824105","","6500.00","2024-08-13","0","1","2024-08-13 06:53:10");
INSERT INTO tbl_payvoucher VALUES("556","PAV140824101","","49100.00","2024-08-11","0","1","2024-08-14 09:42:59");
INSERT INTO tbl_payvoucher VALUES("557","PAV140824102","","15040.00","2024-08-14","0","1","2024-08-14 03:00:34");
INSERT INTO tbl_payvoucher VALUES("558","PAV140824103","","6250.00","2024-08-14","0","1","2024-08-14 03:02:04");
INSERT INTO tbl_payvoucher VALUES("559","PAV140824104","","1300.00","2024-08-14","0","1","2024-08-14 03:03:09");
INSERT INTO tbl_payvoucher VALUES("560","PAV150824101","","1146960.00","2024-08-14","0","1","2024-08-15 10:21:59");
INSERT INTO tbl_payvoucher VALUES("561","PAV150824102","","14800.00","2024-08-15","0","1","2024-08-15 12:12:32");
INSERT INTO tbl_payvoucher VALUES("562","PAV150824103","","44450.00","2024-08-15","0","1","2024-08-15 12:20:02");
INSERT INTO tbl_payvoucher VALUES("563","PAV150824104","","504860.00","2024-08-15","0","1","2024-08-15 02:58:57");
INSERT INTO tbl_payvoucher VALUES("564","PAV150824105","","5950.00","2024-08-15","0","1","2024-08-15 03:02:55");
INSERT INTO tbl_payvoucher VALUES("565","PAV150824106","","2308750.00","2024-08-15","0","1","2024-08-15 07:48:21");
INSERT INTO tbl_payvoucher VALUES("566","PAV150824107","","400000.00","2024-08-15","0","1","2024-08-15 07:49:54");
INSERT INTO tbl_payvoucher VALUES("567","PAV160824101","","5000.00","2024-08-15","0","1","2024-08-16 09:10:57");
INSERT INTO tbl_payvoucher VALUES("568","PAV160824102","","111250.00","2024-08-16","0","1","2024-08-16 06:27:17");
INSERT INTO tbl_payvoucher VALUES("569","PAV160824103","","500.00","2024-08-16","0","1","2024-08-16 06:31:37");
INSERT INTO tbl_payvoucher VALUES("570","PAV160824104","","32150.00","2024-08-16","0","1","2024-08-16 07:42:36");
INSERT INTO tbl_payvoucher VALUES("571","PAV160824105","","17600.00","2024-08-16","0","1","2024-08-16 08:09:18");
INSERT INTO tbl_payvoucher VALUES("572","PAV170824101","","14200.00","2024-08-08","0","1","2024-08-17 09:28:56");
INSERT INTO tbl_payvoucher VALUES("573","PAV170824102","","1690.00","2024-08-16","0","1","2024-08-17 09:35:35");
INSERT INTO tbl_payvoucher VALUES("574","PAV170824103","","3000.00","2024-08-17","0","1","2024-08-17 05:50:49");
INSERT INTO tbl_payvoucher VALUES("575","PAV170824104","","500.00","2024-08-17","0","1","2024-08-17 08:55:25");
INSERT INTO tbl_payvoucher VALUES("576","PAV170824105","","63300.00","2024-08-17","0","1","2024-08-17 08:56:47");
INSERT INTO tbl_payvoucher VALUES("577","PAV180824101","","47100.00","2024-08-18","0","1","2024-08-18 03:25:03");
INSERT INTO tbl_payvoucher VALUES("578","PAV180824102","","1160000.00","2024-08-18","0","1","2024-08-18 03:41:13");
INSERT INTO tbl_payvoucher VALUES("579","PAV180824103","","5518500.00","2024-08-18","0","1","2024-08-18 05:52:20");
INSERT INTO tbl_payvoucher VALUES("580","PAV190824101","","8495.00","2024-08-19","0","1","2024-08-19 09:48:09");
INSERT INTO tbl_payvoucher VALUES("581","PAV190824102","","50000.00","2024-08-18","0","1","2024-08-19 09:51:12");
INSERT INTO tbl_payvoucher VALUES("583","PAV190824104","","1391900.00","2024-08-19","0","1","2024-08-19 05:53:57");
INSERT INTO tbl_payvoucher VALUES("584","PAV190824105","","1103900.00","2024-08-19","0","1","2024-08-19 07:30:54");
INSERT INTO tbl_payvoucher VALUES("586","PAV200824102","","1300.00","2024-08-20","0","1","2024-08-20 07:03:52");
INSERT INTO tbl_payvoucher VALUES("587","PAV210824101","","12350.00","2024-08-20","0","1","2024-08-21 08:52:42");
INSERT INTO tbl_payvoucher VALUES("588","PAV210824102","","987155.00","2024-08-21","0","1","2024-08-21 05:08:26");
INSERT INTO tbl_payvoucher VALUES("589","PAV210824103","","150000.00","2024-08-21","0","1","2024-08-21 08:47:21");
INSERT INTO tbl_payvoucher VALUES("590","PAV210824104","","503510.00","2024-08-21","0","1","2024-08-21 08:50:39");
INSERT INTO tbl_payvoucher VALUES("591","PAV220824101","","773260.00","2024-08-20","0","1","2024-08-22 11:35:13");
INSERT INTO tbl_payvoucher VALUES("592","PAV220824102","","855320.00","2024-08-22","0","1","2024-08-22 01:30:45");
INSERT INTO tbl_payvoucher VALUES("593","PAV220824103","","3057758.00","2024-08-22","0","1","2024-08-22 06:45:39");
INSERT INTO tbl_payvoucher VALUES("594","PAV230824101","","30250.00","2024-08-22","0","1","2024-08-23 08:50:00");
INSERT INTO tbl_payvoucher VALUES("595","PAV230824102","","500.00","2024-08-07","0","1","2024-08-23 11:25:40");
INSERT INTO tbl_payvoucher VALUES("596","PAV230824103","","850320.00","2024-08-22","0","1","2024-08-23 11:42:15");
INSERT INTO tbl_payvoucher VALUES("597","PAV230824104","","94850.00","2024-08-23","0","1","2024-08-23 07:40:24");
INSERT INTO tbl_payvoucher VALUES("598","PAV240824101","","30700.00","2024-08-24","0","1","2024-08-24 05:41:45");
INSERT INTO tbl_payvoucher VALUES("599","PAV250824101","","3975950.00","2024-08-25","0","1","2024-08-25 05:51:19");
INSERT INTO tbl_payvoucher VALUES("600","PAV250824102","","5400000.00","2024-08-25","0","1","2024-08-25 06:35:33");
INSERT INTO tbl_payvoucher VALUES("601","PAV250824103","","200000.00","2024-08-25","0","1","2024-08-25 08:43:33");
INSERT INTO tbl_payvoucher VALUES("602","PAV250824104","","2143000.00","2024-08-25","0","1","2024-08-25 08:52:22");
INSERT INTO tbl_payvoucher VALUES("603","PAV260824101","","80000.00","2024-08-26","0","1","2024-08-26 05:42:00");
INSERT INTO tbl_payvoucher VALUES("604","PAV260824102","","115075.00","2024-08-26","0","1","2024-08-26 05:48:30");
INSERT INTO tbl_payvoucher VALUES("605","PAV260824103","","60000.00","2024-08-26","0","1","2024-08-26 08:11:16");
INSERT INTO tbl_payvoucher VALUES("606","PAV270824101","","3000000.00","2024-08-27","0","1","2024-08-27 06:01:15");
INSERT INTO tbl_payvoucher VALUES("607","PAV270824102","","3020000.00","2024-08-27","0","1","2024-08-27 06:03:24");
INSERT INTO tbl_payvoucher VALUES("608","PAV270824103","","155110.00","2024-08-27","0","1","2024-08-27 09:13:00");
INSERT INTO tbl_payvoucher VALUES("609","PAV280824101","","1760390.00","2024-08-28","0","1","2024-08-28 03:40:21");
INSERT INTO tbl_payvoucher VALUES("610","PAV280824102","","1800.00","2024-08-28","0","1","2024-08-28 03:53:22");
INSERT INTO tbl_payvoucher VALUES("611","PAV280824103","","1228000.00","2024-08-28","0","1","2024-08-28 05:39:30");
INSERT INTO tbl_payvoucher VALUES("612","PAV280824104","","118000.00","2024-08-28","0","1","2024-08-28 07:26:30");
INSERT INTO tbl_payvoucher VALUES("613","PAV280824105","","330000.00","2024-08-28","0","1","2024-08-28 07:54:25");
INSERT INTO tbl_payvoucher VALUES("614","PAV290824101","","3967405.00","2024-08-29","0","1","2024-08-29 02:26:24");
INSERT INTO tbl_payvoucher VALUES("615","PAV290824102","","2433300.00","2024-08-29","0","1","2024-08-29 04:17:46");
INSERT INTO tbl_payvoucher VALUES("616","PAV290824103","","355000.00","2024-08-29","0","1","2024-08-29 04:18:30");
INSERT INTO tbl_payvoucher VALUES("617","PAV290824104","","20100.00","2024-08-29","0","1","2024-08-29 07:10:02");
INSERT INTO tbl_payvoucher VALUES("618","PAV290824105","","5000.00","2024-08-29","0","1","2024-08-29 07:29:24");
INSERT INTO tbl_payvoucher VALUES("619","PAV300824101","","68900.00","2024-08-29","0","1","2024-08-30 11:55:48");
INSERT INTO tbl_payvoucher VALUES("620","PAV300824102","","755000.00","2024-08-29","0","1","2024-08-30 11:56:35");
INSERT INTO tbl_payvoucher VALUES("621","PAV300824103","","18150.00","2024-08-03","0","1","2024-08-30 12:01:25");
INSERT INTO tbl_payvoucher VALUES("622","PAV300824104","","7900.00","2024-08-06","0","1","2024-08-30 12:02:06");
INSERT INTO tbl_payvoucher VALUES("623","PAV300824105","","1000.00","2024-08-07","0","1","2024-08-30 12:03:13");
INSERT INTO tbl_payvoucher VALUES("624","PAV300824106","","22000.00","2024-08-08","0","1","2024-08-30 12:04:38");
INSERT INTO tbl_payvoucher VALUES("625","PAV300824107","","650.00","2024-08-14","0","1","2024-08-30 12:09:23");
INSERT INTO tbl_payvoucher VALUES("626","PAV300824108","","10000.00","2024-08-15","0","1","2024-08-30 12:10:07");
INSERT INTO tbl_payvoucher VALUES("627","PAV300824109","","53000.00","2024-08-25","0","1","2024-08-30 12:11:28");
INSERT INTO tbl_payvoucher VALUES("628","PAV300824110","","10000.00","2024-08-28","0","1","2024-08-30 12:11:56");
INSERT INTO tbl_payvoucher VALUES("629","PAV300824111","","500.00","2024-08-28","0","1","2024-08-30 12:12:28");
INSERT INTO tbl_payvoucher VALUES("630","PAV300824112","","9000.00","2024-08-24","0","1","2024-08-30 12:18:59");
INSERT INTO tbl_payvoucher VALUES("631","PAV300824113","","1479820.00","2024-08-30","0","1","2024-08-30 07:21:50");
INSERT INTO tbl_payvoucher VALUES("632","PAV300824114","","470.00","2024-08-30","0","1","2024-08-30 07:26:23");
INSERT INTO tbl_payvoucher VALUES("633","PAV310824101","","2500.00","2024-08-31","0","1","2024-08-31 10:55:26");
INSERT INTO tbl_payvoucher VALUES("634","PAV310824102","","20000.00","2024-08-31","0","1","2024-08-31 10:59:28");
INSERT INTO tbl_payvoucher VALUES("635","PAV310824103","","1300.00","2024-08-31","0","1","2024-08-31 11:00:55");
INSERT INTO tbl_payvoucher VALUES("636","PAV310824104","","58970.00","2024-08-31","0","1","2024-08-31 02:50:14");
INSERT INTO tbl_payvoucher VALUES("637","PAV310824105","","2750.00","2024-08-31","0","1","2024-08-31 06:03:32");
INSERT INTO tbl_payvoucher VALUES("638","PAV310824106","","50000.00","2024-08-31","0","1","2024-08-31 09:24:23");
INSERT INTO tbl_payvoucher VALUES("639","PAV010924101","","98990.00","2024-09-01","0","1","2024-09-01 03:21:11");
INSERT INTO tbl_payvoucher VALUES("640","PAV010924102","","1000.00","2024-09-01","0","1","2024-09-01 03:22:37");
INSERT INTO tbl_payvoucher VALUES("641","PAV010924103","","1000000.00","2024-09-01","0","1","2024-09-01 06:11:32");
INSERT INTO tbl_payvoucher VALUES("642","PAV010924104","","2500000.00","2024-09-01","0","1","2024-09-01 06:12:03");
INSERT INTO tbl_payvoucher VALUES("643","PAV010924105","","3674010.00","2024-09-01","0","1","2024-09-01 06:16:47");
INSERT INTO tbl_payvoucher VALUES("644","PAV020924101","","43660.00","2024-09-01","0","1","2024-09-02 08:23:43");
INSERT INTO tbl_payvoucher VALUES("645","PAV020924102","","141400.00","2024-09-02","0","1","2024-09-02 12:47:11");
INSERT INTO tbl_payvoucher VALUES("646","PAV020924103","","9230.00","2024-09-02","0","1","2024-09-02 02:15:34");
INSERT INTO tbl_payvoucher VALUES("647","PAV020924104","","314400.00","2024-09-02","0","1","2024-09-02 07:19:31");
INSERT INTO tbl_payvoucher VALUES("648","PAV020924105","","1270000.00","2024-09-02","0","1","2024-09-02 09:02:33");
INSERT INTO tbl_payvoucher VALUES("649","PAV030924101","","261500.00","2024-09-03","0","1","2024-09-03 03:09:53");
INSERT INTO tbl_payvoucher VALUES("650","PAV030924102","","1416850.00","2024-09-03","0","1","2024-09-03 08:51:22");
INSERT INTO tbl_payvoucher VALUES("652","PAV040924101","","150000.00","2024-09-02","0","1","2024-09-04 09:17:58");
INSERT INTO tbl_payvoucher VALUES("653","PAV040924102","","159750.00","2024-09-04","0","1","2024-09-04 01:24:23");
INSERT INTO tbl_payvoucher VALUES("654","PAV040924103","","132000.00","2024-09-02","0","1","2024-09-04 01:24:48");
INSERT INTO tbl_payvoucher VALUES("655","PAV040924104","","20000.00","2024-08-27","0","1","2024-09-04 05:16:11");
INSERT INTO tbl_payvoucher VALUES("656","PAV040924105","","1000000.00","2024-09-04","0","1","2024-09-04 06:54:38");
INSERT INTO tbl_payvoucher VALUES("657","PAV040924106","","644800.00","2024-09-04","0","1","2024-09-04 06:57:49");
INSERT INTO tbl_payvoucher VALUES("658","PAV050924101","","959570.00","2024-09-05","0","1","2024-09-05 04:10:41");
INSERT INTO tbl_payvoucher VALUES("659","PAV050924102","","6600000.00","2024-09-05","0","1","2024-09-05 05:54:12");
INSERT INTO tbl_payvoucher VALUES("660","PAV060924101","","14440.00","2024-09-05","0","1","2024-09-06 11:19:52");
INSERT INTO tbl_payvoucher VALUES("661","PAV060924102","","3564550.00","2024-09-05","0","1","2024-09-06 12:07:14");
INSERT INTO tbl_payvoucher VALUES("662","PAV060924103","","1968250.00","2024-09-06","0","1","2024-09-06 06:49:51");
INSERT INTO tbl_payvoucher VALUES("663","PAV060924104","","299.00","2024-09-06","0","1","2024-09-06 06:59:49");
INSERT INTO tbl_payvoucher VALUES("664","PAV070924101","","9470.00","2024-09-06","0","1","2024-09-07 09:40:48");
INSERT INTO tbl_payvoucher VALUES("665","PAV070924102","","7000.00","2024-09-07","0","1","2024-09-07 09:44:10");
INSERT INTO tbl_payvoucher VALUES("666","PAV070924103","","9000.00","2024-09-07","0","1","2024-09-07 02:52:29");
INSERT INTO tbl_payvoucher VALUES("667","PAV070924104","","7800.00","2024-09-05","0","1","2024-09-07 06:48:07");
INSERT INTO tbl_payvoucher VALUES("668","PAV070924105","","3400.00","2024-09-05","0","1","2024-09-07 07:13:58");
INSERT INTO tbl_payvoucher VALUES("669","PAV070924106","","2000.00","2024-09-07","0","1","2024-09-07 07:23:54");
INSERT INTO tbl_payvoucher VALUES("670","PAV070924107","","15900.00","2024-09-07","0","1","2024-09-07 07:25:58");
INSERT INTO tbl_payvoucher VALUES("671","PAV080924101","","19820.00","2024-09-07","0","1","2024-09-08 08:49:51");
INSERT INTO tbl_payvoucher VALUES("673","PAV080924103","","499000.00","2024-09-07","0","1","2024-09-08 12:13:01");
INSERT INTO tbl_payvoucher VALUES("674","PAV080924104","","563110.00","2024-09-08","0","1","2024-09-08 04:28:02");
INSERT INTO tbl_payvoucher VALUES("675","PAV080924105","","3400000.00","2024-09-08","0","1","2024-09-08 06:56:35");
INSERT INTO tbl_payvoucher VALUES("676","PAV080924106","","1597350.00","2024-09-08","0","1","2024-09-08 08:01:03");
INSERT INTO tbl_payvoucher VALUES("677","PAV090924101","","4500.00","2024-09-05","0","1","2024-09-09 01:39:01");
INSERT INTO tbl_payvoucher VALUES("678","PAV090924102","","500000.00","2024-09-09","0","1","2024-09-09 02:05:20");
INSERT INTO tbl_payvoucher VALUES("680","PAV090924104","","61300.00","2024-09-09","0","1","2024-09-09 02:12:37");
INSERT INTO tbl_payvoucher VALUES("681","PAV090924105","","2252000.00","2024-09-09","0","1","2024-09-09 06:33:35");
INSERT INTO tbl_payvoucher VALUES("682","PAV090924106","","25230.00","2024-09-09","0","1","2024-09-09 06:59:54");
INSERT INTO tbl_payvoucher VALUES("683","PAV090924107","","580000.00","2024-09-09","0","1","2024-09-09 09:14:20");
INSERT INTO tbl_payvoucher VALUES("684","PAV090924108","","260000.00","2024-09-09","0","1","2024-09-09 09:20:02");
INSERT INTO tbl_payvoucher VALUES("685","PAV100924101","","1000.00","2024-09-09","0","1","2024-09-10 08:59:27");
INSERT INTO tbl_payvoucher VALUES("686","PAV100924102","","3000.00","2024-09-10","0","1","2024-09-10 04:17:09");
INSERT INTO tbl_payvoucher VALUES("687","PAV100924103","","690000.00","2024-09-10","0","1","2024-09-10 04:41:41");
INSERT INTO tbl_payvoucher VALUES("688","PAV100924104","","505000.00","2024-09-10","0","1","2024-09-10 07:36:10");
INSERT INTO tbl_payvoucher VALUES("689","PAV110924101","","22400.00","2024-09-11","0","1","2024-09-11 03:24:07");
INSERT INTO tbl_payvoucher VALUES("690","PAV110924102","","1000000.00","2024-09-11","0","1","2024-09-11 04:36:35");
INSERT INTO tbl_payvoucher VALUES("691","PAV110924103","","87500.00","2024-09-11","0","1","2024-09-11 04:36:58");
INSERT INTO tbl_payvoucher VALUES("692","PAV110924104","","10410.00","2024-09-11","0","1","2024-09-11 06:59:53");
INSERT INTO tbl_payvoucher VALUES("693","PAV120924101","","30000.00","2024-09-12","0","1","2024-09-12 03:26:51");
INSERT INTO tbl_payvoucher VALUES("694","PAV120924102","","1100.00","2024-09-11","0","1","2024-09-12 04:08:27");
INSERT INTO tbl_payvoucher VALUES("695","PAV120924103","","500000.00","2024-09-12","0","1","2024-09-12 04:12:56");
INSERT INTO tbl_payvoucher VALUES("697","PAV120924104","","2506000.00","2024-09-12","0","1","2024-09-12 07:41:30");
INSERT INTO tbl_payvoucher VALUES("698","PAV120924105","","1848510.00","2024-09-12","0","1","2024-09-12 08:46:28");
INSERT INTO tbl_payvoucher VALUES("699","PAV120924106","","12100.00","2024-09-12","0","1","2024-09-12 09:08:25");
INSERT INTO tbl_payvoucher VALUES("700","PAV130924101","","125500.00","2024-09-13","0","1","2024-09-13 07:19:19");
INSERT INTO tbl_payvoucher VALUES("701","PAV150924101","","515600.00","2024-09-15","0","1","2024-09-15 03:22:50");
INSERT INTO tbl_payvoucher VALUES("702","PAV150924102","","2043500.00","2024-09-15","0","1","2024-09-15 06:01:08");
INSERT INTO tbl_payvoucher VALUES("703","PAV150924103","","1000.00","2024-09-15","0","1","2024-09-15 07:37:41");
INSERT INTO tbl_payvoucher VALUES("704","PAV160924101","","2500.00","2024-09-16","0","1","2024-09-16 02:04:11");
INSERT INTO tbl_payvoucher VALUES("705","PAV160924102","","3300.00","2024-09-16","0","1","2024-09-16 02:18:43");
INSERT INTO tbl_payvoucher VALUES("706","PAV160924103","","190000.00","2024-09-09","0","1","2024-09-16 07:48:20");
INSERT INTO tbl_payvoucher VALUES("707","PAV160924104","","9900.00","2024-09-16","0","1","2024-09-16 08:32:57");
INSERT INTO tbl_payvoucher VALUES("708","PAV160924105","","12500.00","2024-09-16","0","1","2024-09-16 08:40:57");
INSERT INTO tbl_payvoucher VALUES("709","PAV170924101","","6000.00","2024-09-17","0","1","2024-09-17 03:16:21");
INSERT INTO tbl_payvoucher VALUES("710","PAV170924102","","571610.00","2024-09-17","0","1","2024-09-17 03:22:03");
INSERT INTO tbl_payvoucher VALUES("711","PAV170924103","","2187285.00","2024-09-17","0","1","2024-09-17 07:47:34");
INSERT INTO tbl_payvoucher VALUES("712","PAV170924104","","1094900.00","2024-09-17","0","1","2024-09-17 10:00:54");
INSERT INTO tbl_payvoucher VALUES("713","PAV180924101","","1300500.00","2024-09-18","0","1","2024-09-18 01:05:22");
INSERT INTO tbl_payvoucher VALUES("714","PAV180924102","","28500.00","2024-09-18","0","1","2024-09-18 03:27:59");
INSERT INTO tbl_payvoucher VALUES("715","PAV180924103","","1000000.00","2024-09-18","0","1","2024-09-18 04:55:11");
INSERT INTO tbl_payvoucher VALUES("716","PAV180924104","","519020.00","2024-09-18","0","1","2024-09-18 07:37:06");
INSERT INTO tbl_payvoucher VALUES("717","PAV190924101","","758000.00","2024-09-19","0","1","2024-09-19 04:17:49");
INSERT INTO tbl_payvoucher VALUES("718","PAV190924102","","2000000.00","2024-09-19","0","1","2024-09-19 06:09:28");
INSERT INTO tbl_payvoucher VALUES("719","PAV190924103","","1158315.00","2024-09-19","0","1","2024-09-19 07:47:33");
INSERT INTO tbl_payvoucher VALUES("720","PAV190924104","","5500.00","2024-09-19","0","1","2024-09-19 07:54:24");
INSERT INTO tbl_payvoucher VALUES("721","PAV190924105","","100000.00","2024-09-19","0","1","2024-09-19 09:27:11");
INSERT INTO tbl_payvoucher VALUES("722","PAV200924101","","5000.00","2024-09-19","0","1","2024-09-20 09:16:54");
INSERT INTO tbl_payvoucher VALUES("723","PAV200924102","","81100.00","2024-09-20","0","1","2024-09-20 07:07:09");
INSERT INTO tbl_payvoucher VALUES("724","PAV220924101","","45760.00","2024-09-22","0","1","2024-09-22 12:30:26");
INSERT INTO tbl_payvoucher VALUES("725","PAV220924102","","1119520.00","2024-09-22","0","1","2024-09-22 02:57:16");
INSERT INTO tbl_payvoucher VALUES("726","PAV220924103","","4900000.00","2024-09-22","0","1","2024-09-22 08:14:22");
INSERT INTO tbl_payvoucher VALUES("727","PAV220924104","","1550200.00","2024-09-22","0","1","2024-09-22 08:43:58");
INSERT INTO tbl_payvoucher VALUES("728","PAV220924105","","200000.00","2024-09-22","0","1","2024-09-22 09:26:49");
INSERT INTO tbl_payvoucher VALUES("729","PAV230924101","","521900.00","2024-09-23","0","1","2024-09-23 10:11:27");
INSERT INTO tbl_payvoucher VALUES("730","PAV230924102","","108100.00","2024-09-23","0","1","2024-09-23 02:05:20");
INSERT INTO tbl_payvoucher VALUES("731","PAV230924103","","275380.00","2024-09-23","0","1","2024-09-23 09:31:59");
INSERT INTO tbl_payvoucher VALUES("732","PAV240924101","","510170.00","2024-09-24","0","1","2024-09-24 02:52:33");
INSERT INTO tbl_payvoucher VALUES("733","PAV240924102","","1470.00","2024-09-24","0","1","2024-09-24 02:53:16");
INSERT INTO tbl_payvoucher VALUES("734","PAV240924103","","3835000.00","2024-09-24","0","1","2024-09-24 04:58:16");
INSERT INTO tbl_payvoucher VALUES("735","PAV250924101","","810.00","2024-09-25","0","1","2024-09-25 02:49:25");
INSERT INTO tbl_payvoucher VALUES("736","PAV250924102","","477950.00","2024-09-25","0","1","2024-09-25 07:00:39");
INSERT INTO tbl_payvoucher VALUES("738","PAV260924102","","1450470.00","2024-09-26","0","1","2024-09-26 02:46:45");
INSERT INTO tbl_payvoucher VALUES("739","PAV260924103","","3464000.00","2024-09-26","0","1","2024-09-26 05:02:02");
INSERT INTO tbl_payvoucher VALUES("740","PAV260924104","","192519.00","2024-09-26","0","1","2024-09-26 09:26:29");
INSERT INTO tbl_payvoucher VALUES("741","PAV270924101","","25300.00","2024-09-27","0","1","2024-09-27 02:41:03");
INSERT INTO tbl_payvoucher VALUES("742","PAV280924101","","46650.00","2024-09-27","0","1","2024-09-28 08:12:36");
INSERT INTO tbl_payvoucher VALUES("743","PAV280924102","","45500.00","2024-09-28","0","1","2024-09-28 03:35:54");
INSERT INTO tbl_payvoucher VALUES("744","PAV290924101","","3410.00","2024-09-29","0","1","2024-09-29 12:08:58");
INSERT INTO tbl_payvoucher VALUES("745","PAV290924102","","5752500.00","2024-09-29","0","1","2024-09-29 05:44:44");
INSERT INTO tbl_payvoucher VALUES("746","PAV290924103","","780000.00","2024-09-29","0","1","2024-09-29 07:25:26");
INSERT INTO tbl_payvoucher VALUES("747","PAV300924101","","316490.00","2024-09-30","0","1","2024-09-30 11:46:47");
INSERT INTO tbl_payvoucher VALUES("748","PAV300924102","","2362276.00","2024-09-30","0","1","2024-09-30 08:25:47");
INSERT INTO tbl_payvoucher VALUES("749","PAV011024101","","49000.00","2024-10-01","0","1","2024-10-01 08:53:25");
INSERT INTO tbl_payvoucher VALUES("750","PAV011024102","","6850.00","2024-09-30","0","1","2024-10-01 01:48:58");
INSERT INTO tbl_payvoucher VALUES("751","PAV011024103","","114400.00","2024-10-01","0","1","2024-10-01 03:38:32");
INSERT INTO tbl_payvoucher VALUES("752","PAV011024104","","2310000.00","2024-10-01","0","1","2024-10-01 05:11:38");
INSERT INTO tbl_payvoucher VALUES("754","PAV021024102","","4000.00","2024-10-01","0","1","2024-10-02 08:35:37");
INSERT INTO tbl_payvoucher VALUES("755","PAV021024103","","4370.00","2024-10-02","0","1","2024-10-02 05:06:26");
INSERT INTO tbl_payvoucher VALUES("756","PAV021024104","","50000.00","2024-10-02","0","1","2024-10-02 05:08:30");
INSERT INTO tbl_payvoucher VALUES("757","PAV021024105","","1539950.00","2024-10-02","0","1","2024-10-02 05:31:39");
INSERT INTO tbl_payvoucher VALUES("758","PAV021024106","","27530.00","2024-10-02","0","1","2024-10-02 06:25:03");
INSERT INTO tbl_payvoucher VALUES("759","PAV021024107","","100000.00","2024-10-02","0","1","2024-10-02 06:38:22");
INSERT INTO tbl_payvoucher VALUES("760","PAV031024101","","650.00","2024-10-03","0","1","2024-10-03 10:53:22");
INSERT INTO tbl_payvoucher VALUES("762","PAV031024103","","509500.00","2024-10-03","0","1","2024-10-03 04:19:25");
INSERT INTO tbl_payvoucher VALUES("763","PAV031024104","","4503650.00","2024-10-03","0","1","2024-10-03 07:14:44");
INSERT INTO tbl_payvoucher VALUES("764","PAV041024101","","42100.00","2024-10-04","0","1","2024-10-04 12:33:33");
INSERT INTO tbl_payvoucher VALUES("765","PAV041024102","","11680.00","2024-10-04","0","1","2024-10-04 12:34:24");
INSERT INTO tbl_payvoucher VALUES("766","PAV041024103","","25000.00","2024-10-04","0","1","2024-10-04 05:38:14");
INSERT INTO tbl_payvoucher VALUES("767","PAV051024101","","10600.00","2024-10-05","0","1","2024-10-05 10:06:36");
INSERT INTO tbl_payvoucher VALUES("768","PAV051024102","","25850.00","2024-10-04","0","1","2024-10-05 01:41:15");
INSERT INTO tbl_payvoucher VALUES("769","PAV051024103","","1640.00","2024-10-05","0","1","2024-10-05 01:43:45");
INSERT INTO tbl_payvoucher VALUES("770","PAV051024104","","9400.00","2024-10-05","0","1","2024-10-05 07:34:19");
INSERT INTO tbl_payvoucher VALUES("771","PAV051024105","","20100.00","2024-10-05","0","1","2024-10-05 09:01:40");
INSERT INTO tbl_payvoucher VALUES("772","PAV061024101","","257870.00","2024-10-06","0","1","2024-10-06 04:08:30");
INSERT INTO tbl_payvoucher VALUES("773","PAV061024102","","2946480.00","2024-10-06","0","1","2024-10-06 05:48:39");
INSERT INTO tbl_payvoucher VALUES("774","PAV061024103","","24400.00","2024-10-06","0","1","2024-10-06 08:13:42");
INSERT INTO tbl_payvoucher VALUES("775","PAV061024104","","676900.00","2024-10-06","0","1","2024-10-06 09:36:42");
INSERT INTO tbl_payvoucher VALUES("776","PAV061024105","","2200.00","2024-10-06","0","1","2024-10-06 09:37:07");
INSERT INTO tbl_payvoucher VALUES("777","PAV071024101","","738.00","2024-10-07","0","1","2024-10-07 10:04:23");
INSERT INTO tbl_payvoucher VALUES("778","PAV071024102","","236000.00","2024-10-07","0","1","2024-10-07 02:51:59");
INSERT INTO tbl_payvoucher VALUES("779","PAV071024103","","100000.00","2024-10-06","0","1","2024-10-07 08:38:10");
INSERT INTO tbl_payvoucher VALUES("780","PAV071024104","","40000.00","2024-10-07","0","1","2024-10-07 08:41:30");
INSERT INTO tbl_payvoucher VALUES("781","PAV071024105","","645000.00","2024-10-07","0","1","2024-10-07 08:51:20");
INSERT INTO tbl_payvoucher VALUES("782","PAV081024101","","846.00","2023-05-01","0","1","2024-10-08 12:39:30");
INSERT INTO tbl_payvoucher VALUES("783","PAV081024102","","675.00","2023-01-01","0","1","2024-10-08 12:42:12");
INSERT INTO tbl_payvoucher VALUES("784","PAV081024103","","53530.00","2024-10-08","0","1","2024-10-08 02:54:04");



CREATE TABLE `tbl_payvoucherde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `cty` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `did` int(11) NOT NULL,
  `dty` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2413 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_payvoucherde VALUES("1","0","1","2","LE","5360595.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2","0","1","2","LE","2574081.00","5","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("3","0","1","2","LE","1201800.00","7","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("4","0","1","2","LE","3249040.00","8","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("5","0","1","2","LE","77320.00","11","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("6","0","1","2","LE","8600.00","12","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("7","0","1","2","LE","26340.00","13","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("8","0","1","2","LE","181145.00","15","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("9","0","1","2","LE","75230.00","17","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("10","0","1","2","LE","1455130.00","21","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("11","0","1","2","LE","62460.00","24","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("12","0","1","2","LE","2090640.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("13","0","1","2","LE","37250.00","28","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("14","0","1","2","LE","427480.00","29","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("15","0","1","2","LE","36700.00","30","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("16","0","1","2","LE","235645.00","32","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("17","0","1","2","LE","611950.00","33","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("18","0","1","2","LE","46400.00","37","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("19","0","1","2","LE","305200.00","38","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("20","0","1","2","LE","19350.00","39","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("21","0","1","2","LE","835665.00","40","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("22","0","1","2","LE","1780500.00","41","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("23","0","1","2","LE","690000.00","44","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("24","0","1","2","LE","680.00","51","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("25","0","1","2","LE","20800.00","52","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("26","0","1","2","LE","6645229.00","56","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("27","0","1","2","LE","1974920.00","60","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("28","0","1","2","LE","2072940.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("29","0","1","2","LE","313740.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("30","0","1","2","LE","3126945.00","64","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("31","0","1","2","LE","2382230.00","67","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("32","0","1","2","LE","10000.00","68","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("33","0","1","2","LE","2734.00","82","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("34","0","1","2","LE","57200.00","88","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("35","0","1","2","LE","1077200.00","89","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("36","0","1","2","LE","4600070.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("37","0","1","2","LE","12900.00","101","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("38","0","1","2","LE","462760.00","109","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("39","0","1","2","LE","660200.00","95","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("40","0","1","2","LE","73976.00","112","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("41","0","1","2","LE","388600.00","115","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("42","0","1","2","LE","217800.00","116","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("43","0","1","2","LE","222800.00","117","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("44","0","2","2","LE","1288908.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("45","0","2","2","LE","58687.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("46","0","2","2","LE","2696.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("47","0","2","2","LE","539179.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("48","0","2","2","LE","13955.00","53","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("49","0","2","2","LE","16449678.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("52","0","4","2","LE","20950.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("53","0","4","2","LE","440.00","35","SU","","","0","রাজমিস্তী ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("54","0","4","2","LE","440.00","35","SU","","","0","রাজমিস্তী ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("55","0","5","2","LE","800000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("56","0","6","2","LE","90970.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("57","0","6","2","LE","500000.00","68","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("58","0","7","2","LE","200000.00","2","SU","","","0","KALAM MOLLA");
INSERT INTO tbl_payvoucherde VALUES("59","0","8","2","LE","3409040.00","10","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("63","0","12","2","LE","10000.00","35","SU","","","0","ভিট বালি আজগর খান ");
INSERT INTO tbl_payvoucherde VALUES("64","0","12","2","LE","320.00","62","CU","","","0","পালার চাক্কা ");
INSERT INTO tbl_payvoucherde VALUES("65","0","12","2","LE","1000.00","67","CU","","","0","খাবার ");
INSERT INTO tbl_payvoucherde VALUES("66","0","12","2","LE","10000.00","67","CU","","","0","পাইপ মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("67","0","12","2","LE","5000.00","35","SU","","","0","টিপু বাজার ");
INSERT INTO tbl_payvoucherde VALUES("68","0","13","2","LE","828862.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("69","0","14","2","LE","300.00","62","CU","","","0","শেইব");
INSERT INTO tbl_payvoucherde VALUES("70","0","14","2","LE","1600.00","35","SU","","","0","নাট");
INSERT INTO tbl_payvoucherde VALUES("71","0","14","2","LE","29850.00","35","SU","","","0","রং মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("72","0","14","2","LE","250.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("73","0","14","2","LE","500.00","25","CU","","","0","বাজার বাসর মিস্তী খাবার");
INSERT INTO tbl_payvoucherde VALUES("74","0","14","2","LE","1170.00","25","CU","","","0","বাজার বাসার বানিশ মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("75","0","14","2","LE","5200.00","25","CU","","","0","বাসার রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("76","0","14","2","LE","4550.00","25","CU","","","0","বাসার রাজমিস্তী");
INSERT INTO tbl_payvoucherde VALUES("77","0","14","2","LE","550.00","25","CU","","","0","পেট্রোল, ভাড়া ,স্যানটারী ");
INSERT INTO tbl_payvoucherde VALUES("78","0","14","2","LE","1000.00","25","CU","","","0","হাসান বেতন ");
INSERT INTO tbl_payvoucherde VALUES("79","0","15","2","LE","10000.00","35","SU","","","0","টিপু");
INSERT INTO tbl_payvoucherde VALUES("80","0","15","2","LE","1000.00","35","SU","","","0","সাগর ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("81","0","15","2","LE","19600.00","35","SU","","","0","শেড মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("82","0","15","2","LE","28800.00","35","SU","","","0","গাছ ডিল");
INSERT INTO tbl_payvoucherde VALUES("83","0","15","2","LE","500.00","25","CU","","","0","শাহীন বাইক তৈল ");
INSERT INTO tbl_payvoucherde VALUES("84","0","15","2","LE","890.00","35","SU","","","0","রেত, পুলিশ ,টোল ");
INSERT INTO tbl_payvoucherde VALUES("85","0","15","2","LE","5000.00","35","SU","","","0","চালের টিন ক্রয় অগ্রিম ");
INSERT INTO tbl_payvoucherde VALUES("86","0","15","2","LE","370.00","25","CU","","","0","মোবাইল রির্চাজ শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("87","0","15","2","LE","2005.00","25","CU","","","0","ফুপির বাসার কল কমপেসার ");
INSERT INTO tbl_payvoucherde VALUES("88","0","15","2","LE","2700.00","35","SU","","","0","পাইলিং ");
INSERT INTO tbl_payvoucherde VALUES("89","0","15","2","LE","15000.00","35","SU","","","0","ভিট বালু ");
INSERT INTO tbl_payvoucherde VALUES("90","0","16","2","LE","320.00","35","SU","","","0","rajmistri vara");
INSERT INTO tbl_payvoucherde VALUES("91","0","17","2","LE","1470.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("92","0","18","2","LE","300.00","35","SU","","","0","transport");
INSERT INTO tbl_payvoucherde VALUES("93","0","18","2","LE","50.00","35","SU","","","0","sirij kagoj");
INSERT INTO tbl_payvoucherde VALUES("94","0","18","2","LE","5000.00","19","SU","","","0","13-2454 rong safiq");
INSERT INTO tbl_payvoucherde VALUES("95","0","19","2","LE","50000.00","35","SU","","","0","এঙ্গেল ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("96","0","20","2","LE","500.00","25","CU","","","0","GATE BARIR");
INSERT INTO tbl_payvoucherde VALUES("97","0","20","2","LE","4200.00","62","CU","","","0","ANGLE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("98","0","20","2","LE","15000.00","35","SU","","","0","ANGLE");
INSERT INTO tbl_payvoucherde VALUES("99","0","20","2","LE","300.00","35","SU","","","0","BARNISH MISTRI");
INSERT INTO tbl_payvoucherde VALUES("102","0","23","2","LE","4600070.00","96","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("103","0","24","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("104","0","25","2","LE","5000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("105","0","25","2","LE","2100.00","62","CU","","","0","PLATE,SIEP CUTTING");
INSERT INTO tbl_payvoucherde VALUES("106","0","25","2","LE","1000.00","19","SU","","","0","13-2454");
INSERT INTO tbl_payvoucherde VALUES("107","0","25","2","LE","7400.00","67","CU","","","0","CLAM+MITER");
INSERT INTO tbl_payvoucherde VALUES("108","0","26","2","LE","43200.00","64","CU","","","0","ডিজেল বাবদ  ");
INSERT INTO tbl_payvoucherde VALUES("109","0","26","2","LE","80000.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("110","0","27","2","LE","11440.00","35","SU","","","0","এঙ্গেল ");
INSERT INTO tbl_payvoucherde VALUES("111","0","27","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("112","0","27","2","LE","200000.00","6","CU","","","0","প্রাদান ");
INSERT INTO tbl_payvoucherde VALUES("113","0","27","2","LE","181200.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("114","0","28","2","LE","43000.00","7","SU","","","0","পে - অর্ডার ");
INSERT INTO tbl_payvoucherde VALUES("115","0","29","2","LE","1637000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("116","0","30","2","LE","106000.00","4","LO","","","0","কিস্তি");
INSERT INTO tbl_payvoucherde VALUES("117","0","31","2","LE","50000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("118","0","32","2","LE","1000.00","25","CU","","","0","বাসার কাকি ");
INSERT INTO tbl_payvoucherde VALUES("119","0","32","2","LE","4000.00","25","CU","","","0","ফানিচার বানিশ তুলি ");
INSERT INTO tbl_payvoucherde VALUES("120","0","32","2","LE","1000.00","25","CU","","","0","বাসার মিষ্টি ");
INSERT INTO tbl_payvoucherde VALUES("121","0","32","2","LE","570.00","25","CU","","","0","মনোহর বাজার সিমেন্ট ,নাজি");
INSERT INTO tbl_payvoucherde VALUES("122","0","32","2","LE","2000.00","25","CU","","","0","শাহীন বেতন বাবদ");
INSERT INTO tbl_payvoucherde VALUES("123","0","32","2","LE","515000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("124","0","32","2","LE","720.00","35","SU","","","0","গসার পাথর ");
INSERT INTO tbl_payvoucherde VALUES("125","0","33","2","LE","7000.00","67","CU","","","0","পাইপ মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("126","0","33","2","LE","5500.00","67","CU","","","0","সিমেন্ট , অনন্য ");
INSERT INTO tbl_payvoucherde VALUES("127","0","33","2","LE","500.00","35","SU","","","0","টাঙ্গাইল বাজার ");
INSERT INTO tbl_payvoucherde VALUES("128","0","33","2","LE","33000.00","35","SU","","","0","বাশ ক্রয় , ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("129","0","34","2","LE","3320.00","62","CU","","","0","Plain sheet");
INSERT INTO tbl_payvoucherde VALUES("130","0","34","2","LE","3620.00","62","CU","","","0","Rong");
INSERT INTO tbl_payvoucherde VALUES("131","0","34","2","LE","1860.00","35","SU","","","0","Owarling rod");
INSERT INTO tbl_payvoucherde VALUES("132","0","34","2","LE","9320.00","35","SU","","","0","Rong");
INSERT INTO tbl_payvoucherde VALUES("133","0","34","2","LE","400.00","67","CU","","","0","Van, transport ");
INSERT INTO tbl_payvoucherde VALUES("134","0","35","2","LE","2280.00","35","SU","","","0","রং");
INSERT INTO tbl_payvoucherde VALUES("135","0","35","2","LE","480.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("136","0","35","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("137","0","35","2","LE","3000.00","25","CU","","","0","বাসার ফ্যান গরু ঘর মনে হয়");
INSERT INTO tbl_payvoucherde VALUES("138","0","35","2","LE","3000.00","25","CU","","","0","বাডির মটর মেরামত ");
INSERT INTO tbl_payvoucherde VALUES("139","0","35","2","LE","243600.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("140","0","35","2","LE","100000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("141","0","36","2","LE","30000.00","67","CU","","","0","মাহাবুব ");
INSERT INTO tbl_payvoucherde VALUES("142","0","37","2","LE","80.00","35","SU","","","0","ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("143","0","38","2","LE","7600.00","35","SU","","","0","সিলেকশন বালি  ");
INSERT INTO tbl_payvoucherde VALUES("144","0","38","2","LE","100000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("145","0","38","2","LE","13300.00","35","SU","","","0","রং মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("146","0","38","2","LE","350.00","25","CU","","","0","বাসার কুরিয়ার খরচ ");
INSERT INTO tbl_payvoucherde VALUES("147","0","39","2","LE","12500.00","35","SU","","","0","ট্রাক ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("148","0","40","2","LE","1000.00","25","CU","","","0","সিলেট ");
INSERT INTO tbl_payvoucherde VALUES("149","0","40","2","LE","1500.00","35","SU","","","0","গ্যাস ");
INSERT INTO tbl_payvoucherde VALUES("150","0","40","2","LE","30000.00","35","SU","","","0","ভিট বালি ");
INSERT INTO tbl_payvoucherde VALUES("151","0","40","2","LE","330.00","35","SU","","","0","ডিজেল ");
INSERT INTO tbl_payvoucherde VALUES("152","0","40","2","LE","80.00","35","SU","","","0","রাজমিস্তী ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("153","0","41","2","LE","3680.00","35","SU","","","0","ওয়ালিং রড় ");
INSERT INTO tbl_payvoucherde VALUES("154","0","41","2","LE","10000.00","35","SU","","","0","ভিট বালি ");
INSERT INTO tbl_payvoucherde VALUES("155","0","42","2","LE","149100.00","35","SU","","","0","এঙ্গেল ");
INSERT INTO tbl_payvoucherde VALUES("156","0","42","2","LE","146000.00","35","SU","","","0","এঙ্গেল ");
INSERT INTO tbl_payvoucherde VALUES("157","0","42","2","LE","50000.00","35","SU","","","0","টিন");
INSERT INTO tbl_payvoucherde VALUES("158","0","42","2","LE","3345.00","35","SU","","","0","রিক্রাভাড়া , স্কেল ইফতার ");
INSERT INTO tbl_payvoucherde VALUES("159","0","42","2","LE","400.00","35","SU","","","0","ব্যাংক চার্জ ");
INSERT INTO tbl_payvoucherde VALUES("160","0","42","2","LE","76000.00","35","SU","","","0","টিন");
INSERT INTO tbl_payvoucherde VALUES("161","0","42","2","LE","300000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("162","0","42","2","LE","24000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("163","0","42","2","LE","98000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("164","0","42","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("165","0","42","2","LE","30000.00","35","SU","","","0","ভিট বালি ");
INSERT INTO tbl_payvoucherde VALUES("166","0","43","2","LE","4500.00","35","SU","","","0","bodla");
INSERT INTO tbl_payvoucherde VALUES("167","0","44","2","LE","2045.00","35","SU","","","0","টাঙ্গাইল মাহাবুব বাজার ");
INSERT INTO tbl_payvoucherde VALUES("168","0","44","2","LE","1365.00","35","SU","","","0","বিদুৎ");
INSERT INTO tbl_payvoucherde VALUES("169","0","45","2","LE","3346.00","35","SU","","","0","বিদুৎ বিল ");
INSERT INTO tbl_payvoucherde VALUES("170","0","45","2","LE","3240.00","35","SU","","","0","রেড় অক্রাইড");
INSERT INTO tbl_payvoucherde VALUES("171","0","45","2","LE","2620.00","62","CU","","","0","রং");
INSERT INTO tbl_payvoucherde VALUES("172","0","45","2","LE","1550.00","35","SU","","","0","কাটিং পাথর নেগেটিব ");
INSERT INTO tbl_payvoucherde VALUES("173","0","45","2","LE","1650.00","35","SU","","","0","তার , টুপিন , প্লাস ");
INSERT INTO tbl_payvoucherde VALUES("174","0","45","2","LE","2250.00","67","CU","","","0","ফ্যান , তার ");
INSERT INTO tbl_payvoucherde VALUES("175","0","46","2","LE","30000.00","35","SU","","","0","ভিট বালি");
INSERT INTO tbl_payvoucherde VALUES("176","0","46","2","LE","285000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("177","0","46","2","LE","86000.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("178","0","46","2","LE","61500.00","35","SU","","","0","বালি , সিমেন্ট ");
INSERT INTO tbl_payvoucherde VALUES("179","0","46","2","LE","150.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("180","0","47","2","LE","500.00","67","CU","","","0","এজি অফিস ");
INSERT INTO tbl_payvoucherde VALUES("181","0","47","2","LE","7350.00","35","SU","","","0","রুবেল বেতন ");
INSERT INTO tbl_payvoucherde VALUES("182","0","48","2","LE","31800.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("183","0","48","2","LE","10400.00","25","CU","","","0","ফুপির বাসার রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("184","0","48","2","LE","4500.00","35","SU","","","0","প্লেন সীট ");
INSERT INTO tbl_payvoucherde VALUES("185","0","48","2","LE","320.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("186","0","49","2","LE","13000.00","67","CU","","","0","pipe helal");
INSERT INTO tbl_payvoucherde VALUES("187","0","49","2","LE","1000.00","67","CU","","","0","asik khaber");
INSERT INTO tbl_payvoucherde VALUES("188","0","49","2","LE","9000.00","67","CU","","","0","asik salary");
INSERT INTO tbl_payvoucherde VALUES("189","0","49","2","LE","900.00","35","SU","","","0","kodal,terkata");
INSERT INTO tbl_payvoucherde VALUES("190","0","49","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("191","0","50","2","LE","800000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("192","0","51","2","LE","500.00","35","SU","","","0","electrician rob");
INSERT INTO tbl_payvoucherde VALUES("193","0","51","2","LE","202000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("194","0","51","2","LE","10100.00","67","CU","","","0","koel pipe 1200ft");
INSERT INTO tbl_payvoucherde VALUES("195","0","51","2","LE","2585.00","35","SU","","","0","bazar");
INSERT INTO tbl_payvoucherde VALUES("196","0","51","2","LE","10000.00","35","SU","","","0","tipu");
INSERT INTO tbl_payvoucherde VALUES("197","0","51","2","LE","1000.00","25","CU","","","0","hasan");
INSERT INTO tbl_payvoucherde VALUES("198","0","51","2","LE","6130.00","35","SU","","","0","RAJMISTRI KHABER");
INSERT INTO tbl_payvoucherde VALUES("199","0","51","2","LE","3470.00","35","SU","","","0","SHED MISTRI KHABER");
INSERT INTO tbl_payvoucherde VALUES("200","0","51","2","LE","3400.00","35","SU","","","0","TIPU KHABER");
INSERT INTO tbl_payvoucherde VALUES("201","0","52","2","LE","17530.00","35","SU","","","0","shed mistri");
INSERT INTO tbl_payvoucherde VALUES("202","0","52","2","LE","3000.00","35","SU","","","0","gas 2 ti");
INSERT INTO tbl_payvoucherde VALUES("203","0","53","2","LE","140.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("204","0","54","2","LE","3200.00","67","CU","","","0","পাকশবালি ");
INSERT INTO tbl_payvoucherde VALUES("205","0","54","2","LE","17550.00","25","CU","","","0","ফুফির জমির গাছ কাটা বাবদ ");
INSERT INTO tbl_payvoucherde VALUES("206","0","54","2","LE","1400.00","19","SU","","","0","132454 রিলি, মুজরী ");
INSERT INTO tbl_payvoucherde VALUES("207","0","55","2","LE","200.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("208","0","55","2","LE","223000.00","25","CU","","","0","বাডির গরু ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("209","0","55","2","LE","849400.00","35","SU","","","0","টিন ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("210","0","55","2","LE","280.00","35","SU","","","0","রাজমিস্তী ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("211","0","55","2","LE","5220.00","35","SU","","","0","রেড , অক্রাই , থিনার ");
INSERT INTO tbl_payvoucherde VALUES("212","0","55","2","LE","3140.00","35","SU","","","0","অক্রিজেন ২ টি ,ওয়ালিং রড়");
INSERT INTO tbl_payvoucherde VALUES("213","0","56","2","LE","2600.00","25","CU","","","0","COW SALT");
INSERT INTO tbl_payvoucherde VALUES("214","0","57","2","LE","40.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("216","0","59","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("217","0","60","2","LE","8000.00","25","CU","","","0","শাহিদ নিজ ");
INSERT INTO tbl_payvoucherde VALUES("218","0","60","2","LE","520.00","67","CU","","","0","বিদুৎ সংযোগ আবেদন ফ্রি ");
INSERT INTO tbl_payvoucherde VALUES("219","0","60","2","LE","10000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("220","0","60","2","LE","5000.00","35","SU","","","0","বালু ভরাট বাবদ আলআমিন ");
INSERT INTO tbl_payvoucherde VALUES("221","0","60","2","LE","150000.00","64","CU","","","0","শাহীন মাদবর কে ভেকু ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("222","0","61","2","LE","60020.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("223","0","62","2","LE","100000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("224","0","62","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("225","0","62","2","LE","500000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("226","0","62","2","LE","34429.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("227","0","63","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("228","0","63","2","LE","560021.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("229","0","63","2","LE","150000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("230","0","63","2","LE","30000.00","35","SU","","","0","এমভি মাহির বালু বাবদ ");
INSERT INTO tbl_payvoucherde VALUES("231","0","64","2","LE","500000.00","41","CU","","","0","WRONG ENTRY");
INSERT INTO tbl_payvoucherde VALUES("232","0","65","2","LE","9500.00","67","CU","","","0","HELAL PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("233","0","65","2","LE","5500.00","67","CU","","","0","CIMENT");
INSERT INTO tbl_payvoucherde VALUES("234","0","66","2","LE","25000.00","64","CU","","","0","MAHEDI");
INSERT INTO tbl_payvoucherde VALUES("235","0","67","2","LE","400.00","67","CU","","","0","ভ্যান ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("236","0","67","2","LE","4600.00","67","CU","","","0","কয়েল, পাইপ ");
INSERT INTO tbl_payvoucherde VALUES("237","0","67","2","LE","550.00","25","CU","","","0","কাঠ ভাঙ্গা বাবদ ");
INSERT INTO tbl_payvoucherde VALUES("238","0","67","2","LE","3540.00","67","CU","","","0","পাবলিক হেলথ পান্জাবী ");
INSERT INTO tbl_payvoucherde VALUES("239","0","67","2","LE","1000.00","67","CU","","","0","বকশিক ");
INSERT INTO tbl_payvoucherde VALUES("240","0","67","2","LE","350.00","35","SU","","","0","ভ্যান ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("241","0","67","2","LE","2030.00","35","SU","","","0","পলি ");
INSERT INTO tbl_payvoucherde VALUES("242","0","67","2","LE","35000.00","35","SU","","","0","রড় ");
INSERT INTO tbl_payvoucherde VALUES("243","0","67","2","LE","2100.00","62","CU","","","0","পাইপ ");
INSERT INTO tbl_payvoucherde VALUES("244","0","67","2","LE","300.00","62","CU","","","0","ঢোপ কাপড় ");
INSERT INTO tbl_payvoucherde VALUES("245","0","67","2","LE","100000.00","25","CU","","","0","শওকত ");
INSERT INTO tbl_payvoucherde VALUES("246","0","67","2","LE","200000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("247","0","67","2","LE","240000.00","19","SU","","","0","ব্যাক ব্যাংকের কিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("248","0","67","2","LE","6500.00","62","CU","","","0","বয়লারের মালামাল , বকশিস ");
INSERT INTO tbl_payvoucherde VALUES("249","0","68","2","LE","25000.00","35","SU","","","0","ভিট বালু আল-আমিন ");
INSERT INTO tbl_payvoucherde VALUES("250","0","68","2","LE","500000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("251","0","68","2","LE","5000.00","25","CU","","","0","বাডির সি সি ক্যামেরা ");
INSERT INTO tbl_payvoucherde VALUES("252","0","68","2","LE","1100.00","35","SU","","","0","টাঙ্গাইল ");
INSERT INTO tbl_payvoucherde VALUES("253","0","69","2","LE","30000.00","35","SU","","","0","বালি আল- আমিন কে ");
INSERT INTO tbl_payvoucherde VALUES("254","0","69","2","LE","900.00","35","SU","","","0","রাজমিস্তী নাস্তা , বদলা ");
INSERT INTO tbl_payvoucherde VALUES("255","0","69","2","LE","150.00","35","SU","","","0","নাস্তা ");
INSERT INTO tbl_payvoucherde VALUES("256","0","70","2","LE","300000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("257","0","71","2","LE","3400.00","25","CU","","","0","বাসার গাছ ভাঙ্গা ");
INSERT INTO tbl_payvoucherde VALUES("258","0","71","2","LE","800.00","35","SU","","","0","তারকাটা ");
INSERT INTO tbl_payvoucherde VALUES("259","0","71","2","LE","220.00","35","SU","","","0","তার  ");
INSERT INTO tbl_payvoucherde VALUES("260","0","71","2","LE","500.00","35","SU","","","0","বাল্ব ");
INSERT INTO tbl_payvoucherde VALUES("261","0","71","2","LE","1500.00","35","SU","","","0","লেবার ");
INSERT INTO tbl_payvoucherde VALUES("262","0","71","2","LE","10000.00","25","CU","","","0","বিকাশ ");
INSERT INTO tbl_payvoucherde VALUES("263","0","71","2","LE","25000.00","64","CU","","","0","মাটি কাটার বাবদ মেহেদী ");
INSERT INTO tbl_payvoucherde VALUES("264","0","71","2","LE","250.00","64","CU","","","0","ভ্যান ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("265","0","72","2","LE","50000.00","25","CU","","","0","শওকত চাচা ");
INSERT INTO tbl_payvoucherde VALUES("266","0","73","2","LE","1350.00","25","CU","","","0","শাহিন নিজ গোপাল সাহা থেকে");
INSERT INTO tbl_payvoucherde VALUES("267","0","73","2","LE","40000.00","35","SU","","","0","বালি বাবদ আল- আমিনকে ");
INSERT INTO tbl_payvoucherde VALUES("268","0","73","2","LE","2500.00","62","CU","","","0","বিস্কুট ");
INSERT INTO tbl_payvoucherde VALUES("269","0","74","2","LE","300.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("270","0","74","2","LE","10000.00","35","SU","","","0","বদলা");
INSERT INTO tbl_payvoucherde VALUES("271","0","75","2","LE","680000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("272","0","75","2","LE","200000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("273","0","75","2","LE","300000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("274","0","76","2","LE","1000000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("275","0","77","2","LE","950000.00","8","SU","","","0","50000*19");
INSERT INTO tbl_payvoucherde VALUES("276","0","77","2","LE","200.00","25","CU","","","0","AGRO FIRM ");
INSERT INTO tbl_payvoucherde VALUES("277","0","77","2","LE","11911.00","25","CU","","","0","CURENT BILL");
INSERT INTO tbl_payvoucherde VALUES("278","0","77","2","LE","13900.00","25","CU","","","0","BAZAR MEET");
INSERT INTO tbl_payvoucherde VALUES("279","0","78","2","LE","494.00","25","CU","","","0","বিদুৎ বিল শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("280","0","78","2","LE","20000.00","35","SU","","","0","বালি বাবদ আল- আমিন কে ");
INSERT INTO tbl_payvoucherde VALUES("281","0","78","2","LE","4200.00","35","SU","","","0","পলি , ও রশি ");
INSERT INTO tbl_payvoucherde VALUES("282","0","78","2","LE","15000.00","25","CU","","","0","নিজ ");
INSERT INTO tbl_payvoucherde VALUES("283","0","79","2","LE","1000.00","35","SU","","","0","পলি বাবদ");
INSERT INTO tbl_payvoucherde VALUES("284","0","79","2","LE","5000.00","35","SU","","","0","বালি বাবদ আল- আমিন কে ");
INSERT INTO tbl_payvoucherde VALUES("285","0","79","2","LE","6000.00","35","SU","","","0","লেবার খরচ ");
INSERT INTO tbl_payvoucherde VALUES("286","0","79","2","LE","1000.00","35","SU","","","0","ভোট বকশিস ");
INSERT INTO tbl_payvoucherde VALUES("287","0","79","2","LE","20000.00","25","CU","","","0","বিকাশ ");
INSERT INTO tbl_payvoucherde VALUES("288","0","79","2","LE","1600.00","35","SU","","","0","বদলা ");
INSERT INTO tbl_payvoucherde VALUES("289","0","80","2","LE","8700.00","35","SU","","","0","নাইট গাইট বেতন ");
INSERT INTO tbl_payvoucherde VALUES("290","0","81","2","LE","560000.00","25","CU","","","0","লরিন কে ");
INSERT INTO tbl_payvoucherde VALUES("291","0","81","2","LE","500000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("292","0","81","2","LE","1000000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("293","0","81","2","LE","500000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("294","0","81","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("295","0","81","2","LE","700000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("296","0","82","2","LE","300.00","25","CU","","","0","ফুপির বাসার কাঠ ভাঙ্গা ");
INSERT INTO tbl_payvoucherde VALUES("297","0","83","2","LE","185000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("298","0","84","2","LE","100000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("299","0","84","2","LE","7200.00","35","SU","","","0","ইট আনার ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("300","0","84","2","LE","2000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("301","0","84","2","LE","320.00","35","SU","","","0","ভাড়া রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("302","0","84","2","LE","18200.00","25","CU","","","0","ফুফির বাসার রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("303","0","84","2","LE","50400.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("304","0","84","2","LE","3390.00","35","SU","","","0","রশি ");
INSERT INTO tbl_payvoucherde VALUES("305","0","84","2","LE","5100.00","35","SU","","","0","ওয়ালিং");
INSERT INTO tbl_payvoucherde VALUES("306","0","85","2","LE","14000.00","67","CU","","","0","helal");
INSERT INTO tbl_payvoucherde VALUES("307","0","85","2","LE","1000.00","67","CU","","","0","khaber");
INSERT INTO tbl_payvoucherde VALUES("308","0","85","2","LE","1000.00","67","CU","","","0","asik salary");
INSERT INTO tbl_payvoucherde VALUES("309","0","86","2","LE","50000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("310","0","86","2","LE","2000.00","35","SU","","","0","মাটি কাটার বদলা ");
INSERT INTO tbl_payvoucherde VALUES("311","0","87","2","LE","240.00","35","SU","","","0","রাজমিস্তী ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("312","0","88","2","LE","1800.00","137","LE","","","0","ফেতরা");
INSERT INTO tbl_payvoucherde VALUES("313","0","88","2","LE","200.00","137","LE","","","0","ফেতরা");
INSERT INTO tbl_payvoucherde VALUES("314","0","88","2","LE","220.00","170","LE","","","0","তরকারি ");
INSERT INTO tbl_payvoucherde VALUES("315","0","89","2","LE","100000.00","25","CU","","","0","চাচা ");
INSERT INTO tbl_payvoucherde VALUES("316","0","89","2","LE","82500.00","35","SU","","","0","বালু ভরাট বাবদ আল-আমিন কে");
INSERT INTO tbl_payvoucherde VALUES("317","0","90","2","LE","2005.00","35","SU","","","0","MAHABUB");
INSERT INTO tbl_payvoucherde VALUES("318","0","90","2","LE","40.00","35","SU","","","0","SCRU");
INSERT INTO tbl_payvoucherde VALUES("319","0","90","2","LE","50.00","35","SU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("320","0","90","2","LE","400.00","35","SU","","","0","NASTA");
INSERT INTO tbl_payvoucherde VALUES("321","0","90","2","LE","18500.00","35","SU","","","0","NAJIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("322","0","90","2","LE","17400.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("323","0","90","2","LE","72000.00","25","CU","","","0","TIN,MACH BAZAR,ANIS");
INSERT INTO tbl_payvoucherde VALUES("324","0","90","2","LE","20000.00","25","CU","","","0","BKASH PAVEL");
INSERT INTO tbl_payvoucherde VALUES("325","0","90","2","LE","18100.00","35","SU","","","0","BALU,CIMENT");
INSERT INTO tbl_payvoucherde VALUES("328","0","92","2","LE","150000.00","67","CU","","","0","helal");
INSERT INTO tbl_payvoucherde VALUES("329","0","92","2","LE","80.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("330","0","93","2","LE","1000.00","25","CU","","","0","MALEQ FUFA  BAUNDARI");
INSERT INTO tbl_payvoucherde VALUES("334","0","95","2","LE","655.00","67","CU","","","0","so");
INSERT INTO tbl_payvoucherde VALUES("335","0","95","2","LE","9750.00","25","CU","","","0","চাল ক্রয় গোড়াউন ");
INSERT INTO tbl_payvoucherde VALUES("336","0","96","2","LE","500.00","35","SU","","","0","ভ্যান ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("337","0","96","2","LE","340.00","35","SU","","","0","ট্রাসপোট ");
INSERT INTO tbl_payvoucherde VALUES("338","0","96","2","LE","330.00","25","CU","","","0","পলি");
INSERT INTO tbl_payvoucherde VALUES("339","0","96","2","LE","150.00","62","CU","","","0","ওর্য়ালিং রড");
INSERT INTO tbl_payvoucherde VALUES("340","0","96","2","LE","1000.00","25","CU","","","0","হাসান");
INSERT INTO tbl_payvoucherde VALUES("341","0","96","2","LE","400.00","25","CU","","","0","কাকি");
INSERT INTO tbl_payvoucherde VALUES("342","0","97","2","LE","21800.00","25","CU","","","0","ফেতরা ");
INSERT INTO tbl_payvoucherde VALUES("343","0","97","2","LE","21700.00","64","CU","","","0","ডিজেল বাবদ ");
INSERT INTO tbl_payvoucherde VALUES("344","0","97","2","LE","200.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("345","0","98","2","LE","95000.00","35","SU","","","0","ইট ক্রয় বাবদ লিয়াকত ");
INSERT INTO tbl_payvoucherde VALUES("346","0","99","2","LE","2100.00","1","SU","","","0","BUSI 16230");
INSERT INTO tbl_payvoucherde VALUES("347","0","100","2","LE","13000.00","25","CU","","","0","ফেতরা ");
INSERT INTO tbl_payvoucherde VALUES("348","0","100","2","LE","900.00","35","SU","","","0","জি আই তার ");
INSERT INTO tbl_payvoucherde VALUES("349","0","100","2","LE","50.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("350","0","101","2","LE","50000.00","64","CU","","","0","ভেকু ভাড়া সাহীন মাদবর ");
INSERT INTO tbl_payvoucherde VALUES("351","0","102","2","LE","6010.00","35","SU","","","0","বাজার শেড় মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("352","0","102","2","LE","2500.00","35","SU","","","0","বিস্কুট ");
INSERT INTO tbl_payvoucherde VALUES("353","0","102","2","LE","44390.00","35","SU","","","0","শেড মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("354","0","102","2","LE","9482.00","35","SU","","","0","বাজার রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("355","0","102","2","LE","95000.00","35","SU","","","0","ইট");
INSERT INTO tbl_payvoucherde VALUES("356","0","102","2","LE","23600.00","25","CU","","","0","ফুপির বাড়ি মনোহর ইট ও ভাড়");
INSERT INTO tbl_payvoucherde VALUES("357","0","102","2","LE","3000.00","35","SU","","","0","পান্জাবী বাদশা শেখ ");
INSERT INTO tbl_payvoucherde VALUES("358","0","102","2","LE","350.00","62","CU","","","0","ভিক্রসল ");
INSERT INTO tbl_payvoucherde VALUES("359","0","102","2","LE","120.00","35","SU","","","0","রং কারর ফোম ");
INSERT INTO tbl_payvoucherde VALUES("360","0","102","2","LE","100000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("361","0","102","2","LE","700000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("362","0","103","2","LE","50000.00","25","CU","","","0","দিপা ইলেকট্রিনিক ");
INSERT INTO tbl_payvoucherde VALUES("363","0","104","2","LE","100000.00","35","SU","","","0","টিপু  ভাইকে ");
INSERT INTO tbl_payvoucherde VALUES("364","0","104","2","LE","50.00","25","CU","","","0","ফুফির বাসার কাচি");
INSERT INTO tbl_payvoucherde VALUES("365","0","104","2","LE","3515.00","25","CU","","","0","ফুফির বাসার মালামাল নাস্ত");
INSERT INTO tbl_payvoucherde VALUES("366","0","104","2","LE","2800.00","25","CU","","","0","ফুফির বাসার বদলা . ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("367","0","105","2","LE","2500.00","62","CU","","","0","বিস্কুট ");
INSERT INTO tbl_payvoucherde VALUES("368","0","106","2","LE","50000.00","26","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("369","0","106","2","LE","100000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("370","0","106","2","LE","300000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("371","0","107","2","LE","419.00","35","SU","","","0","টিপু বাজার ");
INSERT INTO tbl_payvoucherde VALUES("372","0","107","2","LE","10000.00","62","CU","","","0","সালাউদ্দীন ধার ");
INSERT INTO tbl_payvoucherde VALUES("373","0","107","2","LE","5000.00","35","SU","","","0","শেড মিস্তী অগ্রিম ");
INSERT INTO tbl_payvoucherde VALUES("374","0","107","2","LE","900000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("375","0","107","2","LE","150.00","35","SU","","","0","বকশিস ");
INSERT INTO tbl_payvoucherde VALUES("376","0","107","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("377","0","108","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("378","0","108","2","LE","240.00","35","SU","","","0","নাস্তা ");
INSERT INTO tbl_payvoucherde VALUES("379","0","108","2","LE","9600.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("380","0","108","2","LE","320.00","35","SU","","","0","রাজমিস্তী ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("381","0","109","2","LE","3773.00","35","SU","","","0","রাইছ মিল টিপু বাজার ");
INSERT INTO tbl_payvoucherde VALUES("382","0","110","2","LE","27300.00","25","CU","","","0","ফুফির বাসার রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("383","0","110","2","LE","31200.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("384","0","111","2","LE","339000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("385","0","111","2","LE","60000.00","1","LO","","","0","ম্যানেজার ধার ");
INSERT INTO tbl_payvoucherde VALUES("386","0","111","2","LE","2500.00","25","CU","","","0","বাসার তুলি আপার ফানিচার ");
INSERT INTO tbl_payvoucherde VALUES("387","0","111","2","LE","1100.00","25","CU","","","0","বাজার বাসার মিটার ");
INSERT INTO tbl_payvoucherde VALUES("388","0","111","2","LE","19500.00","25","CU","","","0","হাসান বেতন বোনাস ");
INSERT INTO tbl_payvoucherde VALUES("389","0","111","2","LE","7750.00","25","CU","","","0","মালেক ফুপার বাউন্ডারি সিম");
INSERT INTO tbl_payvoucherde VALUES("390","0","111","2","LE","12000.00","62","CU","","","0","থাই ");
INSERT INTO tbl_payvoucherde VALUES("391","0","111","2","LE","20000.00","25","CU","","","0","মালেক ফুপার জমির ");
INSERT INTO tbl_payvoucherde VALUES("392","0","111","2","LE","200.00","25","CU","","","0","মালেক ফুপার জমির দড়ি ");
INSERT INTO tbl_payvoucherde VALUES("393","0","111","2","LE","800.00","25","CU","","","0","শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("394","0","111","2","LE","12900.00","35","SU","","","0","রড় রামু ঘোষ ");
INSERT INTO tbl_payvoucherde VALUES("395","0","111","2","LE","6000.00","67","CU","","","0","আসিক বোনাস ");
INSERT INTO tbl_payvoucherde VALUES("396","0","111","2","LE","15000.00","35","SU","","","0","বালির দালাল ");
INSERT INTO tbl_payvoucherde VALUES("397","0","111","2","LE","2000.00","67","CU","","","0","আসিক বেতন ");
INSERT INTO tbl_payvoucherde VALUES("398","0","111","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("399","0","111","2","LE","800.00","35","SU","","","0","নাস্তা খাবার ");
INSERT INTO tbl_payvoucherde VALUES("400","0","111","2","LE","10000.00","35","SU","","","0","মাহবুব ");
INSERT INTO tbl_payvoucherde VALUES("401","0","111","2","LE","1500.00","35","SU","","","0","রুবেল ভাড় া");
INSERT INTO tbl_payvoucherde VALUES("402","0","111","2","LE","1000.00","35","SU","","","0","বাজার ");
INSERT INTO tbl_payvoucherde VALUES("403","0","111","2","LE","1000.00","35","SU","","","0","মাহাবুব বোনাস ");
INSERT INTO tbl_payvoucherde VALUES("404","0","112","2","LE","500000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("407","0","115","2","LE","3005.00","67","CU","","","0","পাবলিক হেলথ মাহাবুব ");
INSERT INTO tbl_payvoucherde VALUES("408","0","115","2","LE","34000.00","35","SU","","","0","সুরকি , বালি ");
INSERT INTO tbl_payvoucherde VALUES("409","0","115","2","LE","1200.00","35","SU","","","0","লেবার");
INSERT INTO tbl_payvoucherde VALUES("410","0","115","2","LE","8500.00","35","SU","","","0","বাবুচি বেতন ");
INSERT INTO tbl_payvoucherde VALUES("411","0","115","2","LE","1210.00","35","SU","","","0","মাহাবুব ");
INSERT INTO tbl_payvoucherde VALUES("412","0","115","2","LE","37445.00","35","SU","","","0","বাজার ও খাবার অনন্য ");
INSERT INTO tbl_payvoucherde VALUES("413","0","115","2","LE","149000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("414","0","115","2","LE","500000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("415","0","116","2","LE","10000.00","35","SU","","","0","ক্যামেরা রাউটার মজরী ");
INSERT INTO tbl_payvoucherde VALUES("416","0","116","2","LE","200.00","35","SU","","","0","পাটখড়ি ");
INSERT INTO tbl_payvoucherde VALUES("417","0","117","2","LE","1000.00","25","CU","","","0","বাসার কাকির ফোন নেটওয়ারআই");
INSERT INTO tbl_payvoucherde VALUES("418","0","118","2","LE","500.00","35","SU","","","0","খাবার");
INSERT INTO tbl_payvoucherde VALUES("419","0","119","2","LE","35000.00","64","CU","","","0","সোলার ইনভাটর, বকুল");
INSERT INTO tbl_payvoucherde VALUES("420","0","120","2","LE","500.00","35","SU","","","0","পাহারা হাসান ");
INSERT INTO tbl_payvoucherde VALUES("423","0","122","2","LE","5550.00","25","CU","","","0","বাসার গরুর গোস্ত ");
INSERT INTO tbl_payvoucherde VALUES("424","0","122","2","LE","2000.00","25","CU","","","0","শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("425","0","123","2","LE","6000.00","35","SU","","","0","নাইম , রাসেদ বেতন ");
INSERT INTO tbl_payvoucherde VALUES("426","0","124","2","LE","500000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("427","0","124","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("428","0","125","2","LE","1044000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("429","0","126","2","LE","50000.00","19","SU","","","0","LINE KHAROCH 2 BUS");
INSERT INTO tbl_payvoucherde VALUES("430","0","126","2","LE","10000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("431","0","126","2","LE","2910.00","25","CU","","","0","MURGI,FISH,KHEJUR");
INSERT INTO tbl_payvoucherde VALUES("432","0","127","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("433","0","127","2","LE","400000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("434","0","127","2","LE","500000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("435","0","127","2","LE","40000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("436","0","128","2","LE","950000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("437","0","129","2","LE","172000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("438","0","130","2","LE","3000.00","35","SU","","","0","সেড মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("439","0","130","2","LE","159000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("440","0","131","2","LE","31200.00","25","CU","","","0","শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("441","0","131","2","LE","1000.00","35","SU","","","0","টাঙ্গাইল বাজার ");
INSERT INTO tbl_payvoucherde VALUES("442","0","132","2","LE","100000.00","64","CU","","","0","feed purchese");
INSERT INTO tbl_payvoucherde VALUES("443","0","133","2","LE","100000.00","64","CU","","","0","net purchase");
INSERT INTO tbl_payvoucherde VALUES("444","0","134","2","LE","100000.00","64","CU","","","0","ফিড ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("445","0","134","2","LE","200000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("446","0","134","2","LE","339600.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("447","0","135","2","LE","1000.00","11","SU","","","0","ট্রাক ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("448","0","135","2","LE","70800.00","19","SU","","","0","২ি৪৫৪ ২ টা চাক্কা ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("449","0","136","2","LE","14000.00","35","SU","","","0","বদলা ");
INSERT INTO tbl_payvoucherde VALUES("450","0","136","2","LE","400000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("451","0","136","2","LE","200000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("452","0","136","2","LE","200000.00","64","CU","","","0","ফিড ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("453","0","137","2","LE","268000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("454","0","138","2","LE","5000.00","35","SU","","","0","শেড মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("455","0","139","2","LE","160.00","35","SU","","","0","RAJMISTRI VARA");
INSERT INTO tbl_payvoucherde VALUES("456","0","139","2","LE","100.00","35","SU","","","0","KHABER");
INSERT INTO tbl_payvoucherde VALUES("457","0","139","2","LE","100000.00","25","CU","","","0","SAWKOT KAKA");
INSERT INTO tbl_payvoucherde VALUES("458","0","139","2","LE","1500.00","25","CU","","","0","HASAN");
INSERT INTO tbl_payvoucherde VALUES("459","0","139","2","LE","80.00","25","CU","","","0","NAT");
INSERT INTO tbl_payvoucherde VALUES("460","0","140","2","LE","200.00","5","CU","","","0","WRONG ENTRY");
INSERT INTO tbl_payvoucherde VALUES("461","0","141","2","LE","30000.00","25","CU","","","0","বাসার গরুর ওষুধ ");
INSERT INTO tbl_payvoucherde VALUES("462","0","142","2","LE","2000.00","35","SU","","","0","মাহাবুব বেতন , ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("463","0","142","2","LE","1000.00","35","SU","","","0","টাঙ্গাইল বাজার ");
INSERT INTO tbl_payvoucherde VALUES("464","0","143","2","LE","120.00","62","CU","","","0","গস কাগজ ");
INSERT INTO tbl_payvoucherde VALUES("465","0","143","2","LE","80.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("466","0","144","2","LE","5000.00","35","SU","","","0","টিপু ");
INSERT INTO tbl_payvoucherde VALUES("467","0","145","2","LE","1000.00","67","CU","","","0","আসিক বেতন ");
INSERT INTO tbl_payvoucherde VALUES("468","0","145","2","LE","20000.00","25","CU","","","0","বিকাশ ");
INSERT INTO tbl_payvoucherde VALUES("469","0","146","2","LE","1000.00","35","SU","","","0","ভাড়া নাইম টাঙ্গাইল");
INSERT INTO tbl_payvoucherde VALUES("470","0","147","2","LE","100.00","35","SU","","","0","নছিমন ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("472","0","149","2","LE","20000.00","24","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("473","0","150","2","LE","800.00","35","SU","","","0","লেবার নাস্তা ");
INSERT INTO tbl_payvoucherde VALUES("474","0","150","2","LE","100.00","62","CU","","","0","নাস্তা রং মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("475","0","150","2","LE","220000.00","68","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("476","0","150","2","LE","700000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("477","0","150","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("478","0","150","2","LE","500000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("479","0","150","2","LE","200000.00","64","CU","","","0","ফিড় ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("480","0","151","2","LE","50.00","62","CU","","","0","পুটিং ");
INSERT INTO tbl_payvoucherde VALUES("481","0","151","2","LE","450.00","35","SU","","","0","হোগলা ");
INSERT INTO tbl_payvoucherde VALUES("482","0","151","2","LE","1100.00","62","CU","","","0","রং");
INSERT INTO tbl_payvoucherde VALUES("483","0","151","2","LE","1620.00","35","SU","","","0","টু ইন তার বাল্ব সুইজ ");
INSERT INTO tbl_payvoucherde VALUES("484","0","152","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("485","0","153","2","LE","50000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("486","0","154","2","LE","3750.00","19","SU","","","0","2471 ফিল্টার ");
INSERT INTO tbl_payvoucherde VALUES("487","0","155","2","LE","11500.00","35","SU","","","0","shed mistri");
INSERT INTO tbl_payvoucherde VALUES("488","0","155","2","LE","7000.00","35","SU","","","0","shed house");
INSERT INTO tbl_payvoucherde VALUES("489","0","155","2","LE","1500.00","25","CU","","","0","maleq fufa");
INSERT INTO tbl_payvoucherde VALUES("490","0","155","2","LE","35000.00","35","SU","","","0","bambo");
INSERT INTO tbl_payvoucherde VALUES("491","0","155","2","LE","1750000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("492","0","155","2","LE","20000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("493","0","155","2","LE","3000.00","35","SU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("494","0","155","2","LE","2320.00","35","SU","","","0","rosi");
INSERT INTO tbl_payvoucherde VALUES("495","0","156","2","LE","40.00","35","SU","","","0","ভাড়া রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("496","0","156","2","LE","5000.00","35","SU","","","0","টিপু কে ");
INSERT INTO tbl_payvoucherde VALUES("497","0","156","2","LE","100.00","62","CU","","","0","রং মিস্তী নাস্তা ");
INSERT INTO tbl_payvoucherde VALUES("498","0","156","2","LE","400.00","62","CU","","","0","রং");
INSERT INTO tbl_payvoucherde VALUES("499","0","157","2","LE","60000.00","35","SU","","","0","মালামাল গেট ");
INSERT INTO tbl_payvoucherde VALUES("500","0","157","2","LE","1000.00","35","SU","","","0","নাট বল্টু ");
INSERT INTO tbl_payvoucherde VALUES("506","0","159","2","LE","22000.00","35","SU","","","0","ট্রাক ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("507","0","160","2","LE","1500.00","25","CU","","","0","হাসান");
INSERT INTO tbl_payvoucherde VALUES("508","0","160","2","LE","10000.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("509","0","160","2","LE","1200.00","82","CU","","","0","নছিমন");
INSERT INTO tbl_payvoucherde VALUES("510","0","160","2","LE","200.00","25","CU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("511","0","160","2","LE","1000.00","25","CU","","","0","বার্বুচি");
INSERT INTO tbl_payvoucherde VALUES("512","0","160","2","LE","600.00","25","CU","","","0","মিটার");
INSERT INTO tbl_payvoucherde VALUES("513","0","160","2","LE","725000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("514","0","161","2","LE","2800.00","62","CU","","","0","রং");
INSERT INTO tbl_payvoucherde VALUES("515","0","161","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("516","0","161","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("517","0","161","2","LE","1780000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("518","0","161","2","LE","19000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("519","0","161","2","LE","700000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("520","0","161","2","LE","2602800.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("521","0","161","2","LE","3214000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("522","0","161","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("523","0","161","2","LE","1200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("524","0","161","2","LE","5000.00","35","SU","","","0","ট্রাক ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("525","0","162","2","LE","22500.00","35","SU","","","0","ট্রাক ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("526","0","163","2","LE","106000.00","4","LO","","","0","কিস্তী");
INSERT INTO tbl_payvoucherde VALUES("527","0","164","2","LE","393950.00","117","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("528","0","165","2","LE","2000.00","35","SU","","","0","মাহাবুব , সাগর ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("529","0","165","2","LE","2000.00","35","SU","","","0","সাগার মাহাবুব 23.04.24");
INSERT INTO tbl_payvoucherde VALUES("530","0","165","2","LE","18000.00","35","SU","","","0","ট্রাক ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("531","0","166","2","LE","1000000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("532","0","166","2","LE","1000000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("533","0","167","2","LE","23000.00","35","SU","","","0","ট্রাক ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("534","0","167","2","LE","10000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("535","0","167","2","LE","26000.00","35","SU","","","0","রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("536","0","167","2","LE","14950.00","25","CU","","","0","বাসার রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("537","0","167","2","LE","2000.00","35","SU","","","0","আনলোড ");
INSERT INTO tbl_payvoucherde VALUES("538","0","167","2","LE","200.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("539","0","167","2","LE","1582760.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("540","0","168","2","LE","280.00","35","SU","","","0","রাজমিস্তী ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("541","0","169","2","LE","700000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("542","0","170","2","LE","7600.00","67","CU","","","0","বাকশি বালি ");
INSERT INTO tbl_payvoucherde VALUES("543","0","170","2","LE","11000.00","35","SU","","","0","টিপু ");
INSERT INTO tbl_payvoucherde VALUES("544","0","170","2","LE","1000.00","64","CU","","","0","আরমান");
INSERT INTO tbl_payvoucherde VALUES("545","0","170","2","LE","150.00","25","CU","","","0","বাসার মিটারের মালামাল ");
INSERT INTO tbl_payvoucherde VALUES("546","0","170","2","LE","1000.00","25","CU","","","0","বাসার মিটার মুজুরি ");
INSERT INTO tbl_payvoucherde VALUES("547","0","171","2","LE","22000.00","35","SU","","","0","truck vara");
INSERT INTO tbl_payvoucherde VALUES("548","0","171","2","LE","22000.00","35","SU","","","0","truck vara");
INSERT INTO tbl_payvoucherde VALUES("549","0","172","2","LE","1000.00","67","CU","","","0","asik salary");
INSERT INTO tbl_payvoucherde VALUES("550","0","173","2","LE","20000.00","25","CU","","","0","বাডির গরুর  ওষুধ ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("551","0","173","2","LE","84200.00","25","CU","","","0","ফুফির জমির ইট ক্রয় মামুন ");
INSERT INTO tbl_payvoucherde VALUES("552","0","173","2","LE","2000.00","35","SU","","","0","আনলোড় ");
INSERT INTO tbl_payvoucherde VALUES("553","0","173","2","LE","440.00","35","SU","","","0","নাস্তা আনলোড় ");
INSERT INTO tbl_payvoucherde VALUES("554","0","174","2","LE","600.00","35","SU","","","0","রাশেদ ");
INSERT INTO tbl_payvoucherde VALUES("555","0","175","2","LE","26500.00","35","SU","","","0","ট্রাক ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("556","0","175","2","LE","20.00","35","SU","","","0","ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("557","0","175","2","LE","100.00","35","SU","","","0","ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("558","0","175","2","LE","150.00","35","SU","","","0","পিন তারকাটা ");
INSERT INTO tbl_payvoucherde VALUES("559","0","175","2","LE","6060.00","35","SU","","","0","ওয়ালিং রড় ");
INSERT INTO tbl_payvoucherde VALUES("560","0","175","2","LE","900.00","35","SU","","","0","চেয়ার  ২ টি ");
INSERT INTO tbl_payvoucherde VALUES("561","0","175","2","LE","2200.00","62","CU","","","0","ফ্যান সর্কেট ");
INSERT INTO tbl_payvoucherde VALUES("562","0","175","2","LE","7000.00","62","CU","","","0","ফ্যান ");
INSERT INTO tbl_payvoucherde VALUES("563","0","176","2","LE","200.00","25","CU","","","0","বাসার গুনা ");
INSERT INTO tbl_payvoucherde VALUES("564","0","176","2","LE","5000.00","25","CU","","","0","আদিল বেতন ");
INSERT INTO tbl_payvoucherde VALUES("565","0","176","2","LE","5500.00","25","CU","","","0","বাসার এগ্রোফাম এর পৌ ফ্রি");
INSERT INTO tbl_payvoucherde VALUES("566","0","176","2","LE","770.00","25","CU","","","0","বাসার পেলাস স্কু ড্রাইভার");
INSERT INTO tbl_payvoucherde VALUES("567","0","176","2","LE","770.00","25","CU","","","0","বাসার পেলাস স্কু ড্রাইভার");
INSERT INTO tbl_payvoucherde VALUES("568","0","176","2","LE","8940.00","25","CU","","","0","বাসার পৌর কর ");
INSERT INTO tbl_payvoucherde VALUES("569","0","176","2","LE","22260.00","25","CU","","","0","বাসার গরু ঘরের ১২ ফ্যান ");
INSERT INTO tbl_payvoucherde VALUES("570","0","176","2","LE","1840.00","62","CU","","","0","ফ্যান ");
INSERT INTO tbl_payvoucherde VALUES("571","0","176","2","LE","160.00","25","CU","","","0","মালেক ফুপার পৌর কর ");
INSERT INTO tbl_payvoucherde VALUES("572","0","176","2","LE","130.00","25","CU","","","0","ফট কপি ");
INSERT INTO tbl_payvoucherde VALUES("573","0","177","2","LE","5000.00","64","CU","","","0","ওহিদুল বেতন ");
INSERT INTO tbl_payvoucherde VALUES("574","0","177","2","LE","1000.00","62","CU","","","0","হাসান ");
INSERT INTO tbl_payvoucherde VALUES("575","0","177","2","LE","1000.00","67","CU","","","0","আসিক বেতন ");
INSERT INTO tbl_payvoucherde VALUES("576","0","177","2","LE","200.00","35","SU","","","0","রাজমিস্তী নাস্তা ");
INSERT INTO tbl_payvoucherde VALUES("577","0","178","2","LE","1800.00","62","CU","","","0","আজিজুল বেতন ");
INSERT INTO tbl_payvoucherde VALUES("578","0","178","2","LE","1430.00","35","SU","","","0","গ্যাসের বেতল ");
INSERT INTO tbl_payvoucherde VALUES("579","0","178","2","LE","700.00","35","SU","","","0","পাট খরি ");
INSERT INTO tbl_payvoucherde VALUES("580","0","178","2","LE","150.00","35","SU","","","0","বস্তা ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("581","0","178","2","LE","560.00","35","SU","","","0","রাজমিস্তী নাস্তা ");
INSERT INTO tbl_payvoucherde VALUES("582","0","178","2","LE","32000.00","35","SU","","","0","লরি ভাড়া বয়লার ");
INSERT INTO tbl_payvoucherde VALUES("583","0","178","2","LE","1000.00","35","SU","","","0","বয়লার মিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("584","0","178","2","LE","370000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("585","0","178","2","LE","1200000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("586","0","178","2","LE","450.00","35","SU","","","0","খাবার ");
INSERT INTO tbl_payvoucherde VALUES("587","0","179","2","LE","3000.00","25","CU","","","0","কাকি ");
INSERT INTO tbl_payvoucherde VALUES("588","0","179","2","LE","500.00","25","CU","","","0","বাজার বাসার মিটার বিল ");
INSERT INTO tbl_payvoucherde VALUES("589","0","179","2","LE","1000.00","25","CU","","","0","বাসার মাছ বিক্রয় নছিমন ভা");
INSERT INTO tbl_payvoucherde VALUES("590","0","179","2","LE","400.00","35","SU","","","0","রশি ");
INSERT INTO tbl_payvoucherde VALUES("591","0","179","2","LE","2100.00","35","SU","","","0","কাটিং পাথর ");
INSERT INTO tbl_payvoucherde VALUES("592","0","179","2","LE","60.00","35","SU","","","0","ভাড়া রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("593","0","179","2","LE","20000.00","25","CU","","","0","বিকাশ ");
INSERT INTO tbl_payvoucherde VALUES("594","0","179","2","LE","900.00","35","SU","","","0","মাল আনলোড ");
INSERT INTO tbl_payvoucherde VALUES("595","0","179","2","LE","20000.00","35","SU","","","0","সিমেন্ট বালি ");
INSERT INTO tbl_payvoucherde VALUES("596","0","180","2","LE","40.00","35","SU","","","0","ভাড়া রাজমিস্তী ");
INSERT INTO tbl_payvoucherde VALUES("597","0","180","2","LE","580000.00","35","SU","","","0","শাজানহান কে ");
INSERT INTO tbl_payvoucherde VALUES("598","0","180","2","LE","2000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("599","0","181","2","LE","150000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("600","0","181","2","LE","500000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("601","0","181","2","LE","500000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("602","0","181","2","LE","200000.00","6","CU","","","0","গম ");
INSERT INTO tbl_payvoucherde VALUES("603","0","181","2","LE","3900.00","62","CU","","","0","কয়েল পাইপ ");
INSERT INTO tbl_payvoucherde VALUES("604","0","181","2","LE","2000.00","25","CU","","","0","ফুপির বাসার মনোহর নাজিমুদ");
INSERT INTO tbl_payvoucherde VALUES("605","0","182","2","LE","39456.00","62","CU","","","0","biddut bill");
INSERT INTO tbl_payvoucherde VALUES("606","0","182","2","LE","17990.00","35","SU","","","0","biduut bill");
INSERT INTO tbl_payvoucherde VALUES("607","0","182","2","LE","3897.00","25","CU","","","0","basar bill");
INSERT INTO tbl_payvoucherde VALUES("608","0","182","2","LE","8784.00","25","CU","","","0","agro firm biddut bill");
INSERT INTO tbl_payvoucherde VALUES("609","0","183","2","LE","200.00","62","CU","","","0","হাসান কাজ বাবদ ");
INSERT INTO tbl_payvoucherde VALUES("610","0","183","2","LE","3000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("611","0","183","2","LE","2000000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("612","0","184","2","LE","14250.00","35","SU","","","0","it banga");
INSERT INTO tbl_payvoucherde VALUES("613","0","184","2","LE","167100.00","35","SU","","","0","rod purchase");
INSERT INTO tbl_payvoucherde VALUES("614","0","184","2","LE","20000.00","25","CU","","","0","bkash");
INSERT INTO tbl_payvoucherde VALUES("615","0","184","2","LE","400000.00","6","CU","","","0","gom");
INSERT INTO tbl_payvoucherde VALUES("616","0","185","2","LE","300000.00","31","SU","","","0","agrni bank dhan bari");
INSERT INTO tbl_payvoucherde VALUES("617","0","186","2","LE","6390.00","35","SU","","","0","khaber,boksisk,toll");
INSERT INTO tbl_payvoucherde VALUES("618","0","186","2","LE","5000.00","35","SU","","","0","caretaker");
INSERT INTO tbl_payvoucherde VALUES("619","0","186","2","LE","1000.00","35","SU","","","0","rajib");
INSERT INTO tbl_payvoucherde VALUES("620","0","186","2","LE","6000.00","35","SU","","","0","load-unload");
INSERT INTO tbl_payvoucherde VALUES("621","0","187","2","LE","5435.00","19","SU","","","0","2454 বাসের নড়িয়া ঘাটতি ");
INSERT INTO tbl_payvoucherde VALUES("622","0","187","2","LE","10000.00","35","SU","","","0","সাজাহান ");
INSERT INTO tbl_payvoucherde VALUES("623","0","187","2","LE","10000.00","25","CU","","","0","নিজ ");
INSERT INTO tbl_payvoucherde VALUES("624","0","187","2","LE","50000.00","67","CU","","","0","চিকন্দী ইলেক্টনিক ");
INSERT INTO tbl_payvoucherde VALUES("625","0","188","2","LE","1950.00","35","SU","","","0","ফ্যান");
INSERT INTO tbl_payvoucherde VALUES("626","0","188","2","LE","250.00","35","SU","","","0","ক্যাটাসিটার ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("627","0","188","2","LE","3900.00","62","CU","","","0","ফ্যান ");
INSERT INTO tbl_payvoucherde VALUES("628","0","188","2","LE","4000.00","25","CU","","","0","শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("629","0","189","2","LE","49000.00","25","CU","","","0","বাসার ইলেক্টনিক মালামাল ");
INSERT INTO tbl_payvoucherde VALUES("630","0","190","2","LE","49600.00","35","SU","","","0","bali,cement");
INSERT INTO tbl_payvoucherde VALUES("631","0","191","2","LE","2700.00","62","CU","","","0","VAT");
INSERT INTO tbl_payvoucherde VALUES("632","0","191","2","LE","26300.00","62","CU","","","0","KAJNA,PANIR BILL");
INSERT INTO tbl_payvoucherde VALUES("633","0","191","2","LE","300000.00","12","SU","","","0","NBL");
INSERT INTO tbl_payvoucherde VALUES("634","0","191","2","LE","91000.00","64","CU","","","0","QALITY");
INSERT INTO tbl_payvoucherde VALUES("635","0","192","2","LE","91000.00","64","CU","","","0","ফিড় ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("636","0","192","2","LE","580.00","25","CU","","","0","এগ্নেফার্মের ফর্মের জমা ব");
INSERT INTO tbl_payvoucherde VALUES("637","0","193","2","LE","12350.00","25","CU","","","0","MONOR,RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("638","0","193","2","LE","37800.00","35","SU","","","0","RAJMISTRI-63");
INSERT INTO tbl_payvoucherde VALUES("639","0","193","2","LE","280.00","35","SU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("640","0","193","2","LE","77500.00","62","CU","","","0","JUEL");
INSERT INTO tbl_payvoucherde VALUES("641","0","193","2","LE","750.00","62","CU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("642","0","193","2","LE","29450.00","62","CU","","","0","KHAOIL");
INSERT INTO tbl_payvoucherde VALUES("643","0","193","2","LE","600.00","62","CU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("644","0","194","2","LE","1000.00","67","CU","","","0","আসিক খাবার বাবদ ");
INSERT INTO tbl_payvoucherde VALUES("645","0","195","2","LE","12000.00","26","SU","","","0","ফ্রেব্রু-মার্চ আলআমিন ");
INSERT INTO tbl_payvoucherde VALUES("646","0","195","2","LE","400000.00","26","SU","","","0","এপ্রিল- মে আল-আমিন ");
INSERT INTO tbl_payvoucherde VALUES("647","0","196","2","LE","26000.00","35","SU","","","0","টিপু");
INSERT INTO tbl_payvoucherde VALUES("648","0","197","2","LE","340.00","35","SU","","","0","মিষ্টি  ");
INSERT INTO tbl_payvoucherde VALUES("649","0","197","2","LE","58000.00","35","SU","","","0","লোড আনলোড ");
INSERT INTO tbl_payvoucherde VALUES("650","0","198","2","LE","3050.00","62","CU","","","0","ল্যাবের মালামাল ");
INSERT INTO tbl_payvoucherde VALUES("651","0","198","2","LE","850.00","62","CU","","","0","স্ট্যানাটারী মালামাল ");
INSERT INTO tbl_payvoucherde VALUES("652","0","198","2","LE","190.00","62","CU","","","0","হার্ডওয়ার ");
INSERT INTO tbl_payvoucherde VALUES("653","0","199","2","LE","10000.00","25","CU","","","0","নিজ");
INSERT INTO tbl_payvoucherde VALUES("654","0","200","2","LE","500000.00","12","SU","","","0","nbl");
INSERT INTO tbl_payvoucherde VALUES("655","0","200","2","LE","500000.00","11","SU","","","0","pbl");
INSERT INTO tbl_payvoucherde VALUES("656","0","200","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("657","0","200","2","LE","500000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("658","0","200","2","LE","23500.00","39","SU","","","0","truck vara");
INSERT INTO tbl_payvoucherde VALUES("659","0","201","2","LE","5000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("660","0","201","2","LE","600.00","25","CU","","","0","oxezen");
INSERT INTO tbl_payvoucherde VALUES("661","0","202","2","LE","7070.00","62","CU","","","0","ল্যাবের মালামাল ");
INSERT INTO tbl_payvoucherde VALUES("662","0","202","2","LE","1000000.00","35","SU","","","0","ডায়ার ক্রয় ");
INSERT INTO tbl_payvoucherde VALUES("663","0","202","2","LE","540000.00","35","SU","","","0","ডায়ারের হিটার ");
INSERT INTO tbl_payvoucherde VALUES("664","0","203","2","LE","500000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("665","0","203","2","LE","1302000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("666","0","204","2","LE","38285.00","67","CU","","","0","current, khuti");
INSERT INTO tbl_payvoucherde VALUES("667","0","204","2","LE","1200.00","35","SU","","","0","tosok");
INSERT INTO tbl_payvoucherde VALUES("668","0","204","2","LE","10000.00","25","CU","","","0","jele basar pukur");
INSERT INTO tbl_payvoucherde VALUES("669","0","205","2","LE","1000.00","25","CU","","","0","NAJIM UDDIN FUFIR BASA ");
INSERT INTO tbl_payvoucherde VALUES("670","0","205","2","LE","34000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("671","0","205","2","LE","2370.00","35","SU","","","0","HOGLA,POLI,TERKATA");
INSERT INTO tbl_payvoucherde VALUES("672","0","205","2","LE","1140000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("673","0","206","2","LE","14800.00","35","SU","","","0","KAT");
INSERT INTO tbl_payvoucherde VALUES("674","0","206","2","LE","50.00","35","SU","","","0","NASTA");
INSERT INTO tbl_payvoucherde VALUES("675","0","207","2","LE","600000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("676","0","208","2","LE","40.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("677","0","209","2","LE","800.00","35","SU","","","0","van bara");
INSERT INTO tbl_payvoucherde VALUES("678","0","209","2","LE","1500.00","62","CU","","","0","biskut");
INSERT INTO tbl_payvoucherde VALUES("679","0","209","2","LE","30000.00","35","SU","","","0","oasim hari chabi");
INSERT INTO tbl_payvoucherde VALUES("680","0","209","2","LE","80.00","35","SU","","","0","asik");
INSERT INTO tbl_payvoucherde VALUES("681","0","209","2","LE","40.00","35","SU","","","0","mahabub");
INSERT INTO tbl_payvoucherde VALUES("682","0","210","2","LE","1830.00","25","CU","","","0","koi,ilsha  mach");
INSERT INTO tbl_payvoucherde VALUES("683","0","210","2","LE","1000.00","25","CU","","","0","fufir basa najimuddin");
INSERT INTO tbl_payvoucherde VALUES("684","0","211","2","LE","5000.00","25","CU","","","0","শাহীন ");
INSERT INTO tbl_payvoucherde VALUES("685","0","211","2","LE","6520.00","35","SU","","","0","রসি");
INSERT INTO tbl_payvoucherde VALUES("686","0","211","2","LE","20000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("687","0","212","2","LE","631440.00","2","LO","","","0","ARMAN");
INSERT INTO tbl_payvoucherde VALUES("688","0","212","2","LE","1100000.00","2","LO","","","0","BARKOT");
INSERT INTO tbl_payvoucherde VALUES("689","0","212","2","LE","14000.00","62","CU","","","0","CIRKIT BREKER");
INSERT INTO tbl_payvoucherde VALUES("690","0","213","2","LE","20000.00","62","CU","","","0","SCINCETIST");
INSERT INTO tbl_payvoucherde VALUES("691","0","213","2","LE","1500.00","35","SU","","","0","ELECTRICIAN");
INSERT INTO tbl_payvoucherde VALUES("692","0","214","2","LE","500000.00","2","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("693","0","215","2","LE","500000.00","11","SU","","","0","pbl");
INSERT INTO tbl_payvoucherde VALUES("694","0","216","2","LE","1000.00","25","CU","","","0","b belt");
INSERT INTO tbl_payvoucherde VALUES("695","0","216","2","LE","10000.00","25","CU","","","0","fish jele,hasan");
INSERT INTO tbl_payvoucherde VALUES("696","0","216","2","LE","200.00","25","CU","","","0","6 pin");
INSERT INTO tbl_payvoucherde VALUES("697","0","216","2","LE","5600.00","25","CU","","","0","nocimon 7*800");
INSERT INTO tbl_payvoucherde VALUES("698","0","216","2","LE","3000.00","25","CU","","","0","gas kata");
INSERT INTO tbl_payvoucherde VALUES("699","0","216","2","LE","14000.00","25","CU","","","0","hasan");
INSERT INTO tbl_payvoucherde VALUES("700","0","216","2","LE","16000.00","25","CU","","","0","hardware");
INSERT INTO tbl_payvoucherde VALUES("701","0","216","2","LE","26700.00","25","CU","","","0","sultan fufar side");
INSERT INTO tbl_payvoucherde VALUES("702","0","216","2","LE","5000.00","25","CU","","","0","sultan fufar najimuddin");
INSERT INTO tbl_payvoucherde VALUES("703","0","217","2","LE","400000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("704","0","217","2","LE","60000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("705","0","217","2","LE","80.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("706","0","217","2","LE","15000.00","35","SU","","","0","25*600");
INSERT INTO tbl_payvoucherde VALUES("707","0","217","2","LE","11050.00","25","CU","","","0","MONORA FUFIR BASA");
INSERT INTO tbl_payvoucherde VALUES("708","0","218","2","LE","500000.00","46","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("709","0","219","2","LE","1013000.00","1","LO","","","0","barkat");
INSERT INTO tbl_payvoucherde VALUES("710","0","220","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("711","0","221","2","LE","28000.00","35","SU","","","0","TIPU");
INSERT INTO tbl_payvoucherde VALUES("712","0","221","2","LE","7500.00","25","CU","","","0","KUTA");
INSERT INTO tbl_payvoucherde VALUES("713","0","221","2","LE","260.00","25","CU","","","0","CHAIN MERAMAT");
INSERT INTO tbl_payvoucherde VALUES("714","0","221","2","LE","200.00","25","CU","","","0","HASAN");
INSERT INTO tbl_payvoucherde VALUES("715","0","222","2","LE","825260.00","35","SU","","","0","SAJIB BHAI ROD CEMENT");
INSERT INTO tbl_payvoucherde VALUES("716","0","223","2","LE","3000000.00","25","CU","","","0","SAJIB DOKAN ");
INSERT INTO tbl_payvoucherde VALUES("717","0","223","2","LE","1700000.00","25","CU","","","0","SAJIB DOKAN");
INSERT INTO tbl_payvoucherde VALUES("718","0","224","2","LE","525591.00","25","CU","","","0","CEMENT,ROD");
INSERT INTO tbl_payvoucherde VALUES("719","0","225","2","LE","120.00","35","SU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("720","0","226","2","LE","700.00","35","SU","","","0","কাটিং পাথর ");
INSERT INTO tbl_payvoucherde VALUES("721","0","227","2","LE","15000.00","35","SU","","","0","Gate RASEL");
INSERT INTO tbl_payvoucherde VALUES("722","0","228","2","LE","800000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("723","0","229","2","LE","3150.00","35","SU","","","0","poli,oxizen,terkata");
INSERT INTO tbl_payvoucherde VALUES("724","0","229","2","LE","200.00","35","SU","","","0","van vara");
INSERT INTO tbl_payvoucherde VALUES("725","0","230","2","LE","1911100.00","62","CU","","","0","PBL");
INSERT INTO tbl_payvoucherde VALUES("726","0","230","2","LE","1257000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("727","0","231","2","LE","1500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("728","0","232","2","LE","215000.00","25","CU","","","0","cow purchase");
INSERT INTO tbl_payvoucherde VALUES("729","0","233","2","LE","600000.00","62","CU","","","0","CM PRO");
INSERT INTO tbl_payvoucherde VALUES("730","0","234","2","LE","300000.00","6","CU","","","0","GOM PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("731","0","235","2","LE","4000.00","25","CU","","","0","adil");
INSERT INTO tbl_payvoucherde VALUES("732","0","235","2","LE","650.00","25","CU","","","0","oxezen");
INSERT INTO tbl_payvoucherde VALUES("733","0","235","2","LE","500.00","25","CU","","","0","pump jalai");
INSERT INTO tbl_payvoucherde VALUES("734","0","235","2","LE","100.00","25","CU","","","0","jele");
INSERT INTO tbl_payvoucherde VALUES("735","0","236","2","LE","240000.00","19","SU","","","0","brac kisti");
INSERT INTO tbl_payvoucherde VALUES("736","0","236","2","LE","230000.00","67","CU","","","0","pump purchase");
INSERT INTO tbl_payvoucherde VALUES("737","0","236","2","LE","39582.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("738","0","237","2","LE","780.00","35","SU","","","0","TARKATA");
INSERT INTO tbl_payvoucherde VALUES("739","0","237","2","LE","200000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("740","0","237","2","LE","13050.00","35","SU","","","0","KAT KATA");
INSERT INTO tbl_payvoucherde VALUES("741","0","238","2","LE","2750.00","35","SU","","","0","কাটিং পাথর, করাত,হাতুর");
INSERT INTO tbl_payvoucherde VALUES("742","0","239","2","LE","3013169.00","67","CU","","","0","CONTRACT PURCHASE,JAMA");
INSERT INTO tbl_payvoucherde VALUES("743","0","240","2","LE","300000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("744","0","241","2","LE","23499.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("745","0","242","2","LE","2000.00","25","CU","","","0","sultan fufa water bill");
INSERT INTO tbl_payvoucherde VALUES("746","0","242","2","LE","1200.00","25","CU","","","0","malek fufa ,najimuddin");
INSERT INTO tbl_payvoucherde VALUES("747","0","243","2","LE","5000000.00","31","SU","","","0","1275");
INSERT INTO tbl_payvoucherde VALUES("748","0","243","2","LE","5000000.00","31","SU","","","0","1499");
INSERT INTO tbl_payvoucherde VALUES("749","0","244","2","LE","1012500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("750","0","244","2","LE","702500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("751","0","244","2","LE","196477.00","67","CU","","","0","PIPE");
INSERT INTO tbl_payvoucherde VALUES("752","0","244","2","LE","96768.00","35","SU","","","0","GI");
INSERT INTO tbl_payvoucherde VALUES("753","0","245","2","LE","76500.00","62","CU","","","0","qality feed");
INSERT INTO tbl_payvoucherde VALUES("754","0","245","2","LE","23100.00","35","SU","","","0","kat saw mill");
INSERT INTO tbl_payvoucherde VALUES("755","0","245","2","LE","50000.00","25","CU","","","0","pavel bkash");
INSERT INTO tbl_payvoucherde VALUES("756","0","246","2","LE","375000.00","1","LO","","","0","arman");
INSERT INTO tbl_payvoucherde VALUES("757","0","247","2","LE","300.00","35","SU","","","0","van bara rasel");
INSERT INTO tbl_payvoucherde VALUES("758","0","248","2","LE","20.00","158","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("759","0","248","2","LE","85.00","157","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("760","0","249","2","LE","10000.00","25","CU","","","0","wrong entry");
INSERT INTO tbl_payvoucherde VALUES("763","0","251","2","LE","433000.00","46","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("764","0","251","2","LE","10000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("765","0","251","2","LE","1000.00","25","CU","","","0","বাজার বাসার মিটার বাবদ");
INSERT INTO tbl_payvoucherde VALUES("766","0","251","2","LE","100.00","25","CU","","","0","বাজার বাসার মটরের কাজ বাব");
INSERT INTO tbl_payvoucherde VALUES("767","0","252","2","LE","500000.00","1","LO","","","0","JEWEL");
INSERT INTO tbl_payvoucherde VALUES("768","0","252","2","LE","2135000.00","35","SU","","","0","MACHINE PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("769","0","252","2","LE","84000.00","35","SU","","","0","BALV");
INSERT INTO tbl_payvoucherde VALUES("770","0","252","2","LE","70000.00","25","CU","","","0","MAMUN");
INSERT INTO tbl_payvoucherde VALUES("771","0","252","2","LE","1119000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("772","0","253","2","LE","32580.00","35","SU","","","0","ROD");
INSERT INTO tbl_payvoucherde VALUES("773","0","253","2","LE","7600.00","35","SU","","","0","BALI");
INSERT INTO tbl_payvoucherde VALUES("774","0","253","2","LE","400.00","67","CU","","","0","VAN VARA");
INSERT INTO tbl_payvoucherde VALUES("775","0","253","2","LE","1000.00","67","CU","","","0","RASEL AANGLE");
INSERT INTO tbl_payvoucherde VALUES("776","0","254","2","LE","33600.00","35","SU","","","0","56 rajmistri");
INSERT INTO tbl_payvoucherde VALUES("777","0","254","2","LE","13000.00","25","CU","","","0","rajmistr 20");
INSERT INTO tbl_payvoucherde VALUES("778","0","254","2","LE","240.00","35","SU","","","0","vara");
INSERT INTO tbl_payvoucherde VALUES("779","0","254","2","LE","18200.00","67","CU","","","0","pipe,rolling");
INSERT INTO tbl_payvoucherde VALUES("780","0","255","2","LE","25000.00","32","CU","","","0","wrong entry");
INSERT INTO tbl_payvoucherde VALUES("782","0","257","2","LE","28000.00","35","SU","","","0","টিপুকে প্রদান");
INSERT INTO tbl_payvoucherde VALUES("783","0","257","2","LE","900.00","25","CU","","","0","বাসার পাইপ বাবদ");
INSERT INTO tbl_payvoucherde VALUES("784","0","258","2","LE","1000.00","67","CU","","","0","khaber asik");
INSERT INTO tbl_payvoucherde VALUES("785","0","258","2","LE","1000.00","67","CU","","","0","asik salary");
INSERT INTO tbl_payvoucherde VALUES("786","0","259","2","LE","400000.00","2","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("787","0","259","2","LE","656775.00","1","LO","","","0","police super");
INSERT INTO tbl_payvoucherde VALUES("788","0","259","2","LE","5000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("789","0","259","2","LE","28300.00","35","SU","","","0","বালু , সিমেন্ট");
INSERT INTO tbl_payvoucherde VALUES("790","0","260","2","LE","16920.00","35","SU","","","0","ROAD EXP MALAMAL");
INSERT INTO tbl_payvoucherde VALUES("791","0","261","2","LE","800.00","35","SU","","","0","terkata");
INSERT INTO tbl_payvoucherde VALUES("800","0","264","2","LE","1140000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("801","0","265","2","LE","368424.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("802","0","266","2","LE","220.00","35","SU","","","0","রাইসমিলেররংমিস্ত্রিনাস্তা");
INSERT INTO tbl_payvoucherde VALUES("803","0","267","2","LE","3061850.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("805","0","269","2","LE","24900.00","5","CU","","","0","JILON KHAN RETURN");
INSERT INTO tbl_payvoucherde VALUES("806","0","270","2","LE","600.00","35","SU","","","0","রাজমিস্ত্রি.নাস্তা+ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("807","0","270","2","LE","838950.00","62","CU","","","0","খৈল ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("808","0","271","2","LE","500000.00","2","LO","","","0","জুয়েল সরদার");
INSERT INTO tbl_payvoucherde VALUES("809","0","272","2","LE","300.00","35","SU","","","0","রং মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("810","0","272","2","LE","1000.00","5","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("811","0","272","2","LE","500000.00","25","SU","","","0","1275");
INSERT INTO tbl_payvoucherde VALUES("812","0","272","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("813","0","273","2","LE","6650.00","62","CU","","","0","ইলেকট্রনিক কাজ বাবদ");
INSERT INTO tbl_payvoucherde VALUES("814","0","273","2","LE","950.00","25","CU","","","0","বাসার মটরের বিয়ারিং ");
INSERT INTO tbl_payvoucherde VALUES("815","0","274","2","LE","29370.00","35","SU","","","0","জিআই,এলবো,ফ্লাস");
INSERT INTO tbl_payvoucherde VALUES("816","0","275","2","LE","140630.00","67","CU","","","0","পামহতেট্যাংকিরফিটিংয়েরমাল");
INSERT INTO tbl_payvoucherde VALUES("817","0","276","2","LE","394000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("818","0","276","2","LE","106000.00","4","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("819","0","277","2","LE","18350.00","35","SU","","","0","ফোম,চকমাটি,ওয়ারিং রড");
INSERT INTO tbl_payvoucherde VALUES("820","0","278","2","LE","980.00","35","SU","","","0","তার পিন সিরিজ কাগজ");
INSERT INTO tbl_payvoucherde VALUES("821","0","279","2","LE","4000.00","19","SU","","","0","2471,,তেল ঘটতি");
INSERT INTO tbl_payvoucherde VALUES("822","0","280","2","LE","3190.00","35","SU","","","0","foam,siriz paper,brush");
INSERT INTO tbl_payvoucherde VALUES("823","0","280","2","LE","3230.00","35","SU","","","0","terkata,superglue");
INSERT INTO tbl_payvoucherde VALUES("824","0","281","2","LE","1100.00","25","CU","","","0","basar miter recherge");
INSERT INTO tbl_payvoucherde VALUES("825","0","281","2","LE","1000.00","25","CU","","","0","basar baburci");
INSERT INTO tbl_payvoucherde VALUES("826","0","281","2","LE","45000.00","25","CU","","","0","jele");
INSERT INTO tbl_payvoucherde VALUES("827","0","281","2","LE","1000.00","25","CU","","","0","nocimon vara");
INSERT INTO tbl_payvoucherde VALUES("828","0","282","2","LE","300000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("829","0","283","2","LE","450.00","35","SU","","","0","rong mistri,koyel");
INSERT INTO tbl_payvoucherde VALUES("830","0","284","2","LE","350.00","35","SU","","","0","rong mistri nasta");
INSERT INTO tbl_payvoucherde VALUES("831","0","284","2","LE","200.00","62","CU","","","0","van vara");
INSERT INTO tbl_payvoucherde VALUES("832","0","284","2","LE","61500.00","35","SU","","","0","square ber");
INSERT INTO tbl_payvoucherde VALUES("833","0","284","2","LE","28410.00","62","CU","","","0","truck bara");
INSERT INTO tbl_payvoucherde VALUES("834","0","285","2","LE","12200.00","35","SU","","","0","KAT PURCSHE+BANK");
INSERT INTO tbl_payvoucherde VALUES("835","0","285","2","LE","1260.00","35","SU","","","0","TERPIN,CARBON");
INSERT INTO tbl_payvoucherde VALUES("836","0","285","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("837","0","285","2","LE","495000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("838","0","285","2","LE","388000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("839","0","286","2","LE","13800.00","35","SU","","","0","রাজমিস্ত্র");
INSERT INTO tbl_payvoucherde VALUES("840","0","286","2","LE","300000.00","1","LO","","","0","জুয়েল সরদার");
INSERT INTO tbl_payvoucherde VALUES("841","0","286","2","LE","7000.00","62","CU","","","0","এসি মেরামাত");
INSERT INTO tbl_payvoucherde VALUES("842","0","286","2","LE","430.00","35","SU","","","0","রাজমিস্ত্ররংমিস্ত্রনাস্তা");
INSERT INTO tbl_payvoucherde VALUES("843","0","287","2","LE","30400.00","115","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("844","0","288","2","LE","26000.00","35","SU","","","0","TIPU-52");
INSERT INTO tbl_payvoucherde VALUES("845","0","288","2","LE","150.00","35","SU","","","0","MUJA");
INSERT INTO tbl_payvoucherde VALUES("846","0","288","2","LE","11000.00","35","SU","","","0","TRUCK VARA");
INSERT INTO tbl_payvoucherde VALUES("847","0","288","2","LE","4000.00","35","SU","","","0","MAL UNLOAD");
INSERT INTO tbl_payvoucherde VALUES("848","0","289","2","LE","21700.00","35","SU","","","0","রং মি:");
INSERT INTO tbl_payvoucherde VALUES("849","0","289","2","LE","1114900.00","35","SU","","","0","এস এস ডায়ার");
INSERT INTO tbl_payvoucherde VALUES("850","0","289","2","LE","504000.00","35","SU","","","0","আদিয়ান থেকে মাল ক্রয়");
INSERT INTO tbl_payvoucherde VALUES("851","0","289","2","LE","1830.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("852","0","289","2","LE","1210.00","35","SU","","","0","খাবার");
INSERT INTO tbl_payvoucherde VALUES("853","0","289","2","LE","5000.00","35","SU","","","0","ট্রাক ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("854","0","289","2","LE","43000.00","35","SU","","","0","এস এস পাইপ");
INSERT INTO tbl_payvoucherde VALUES("855","0","289","2","LE","1000.00","35","SU","","","0","বকশিশ");
INSERT INTO tbl_payvoucherde VALUES("856","0","290","2","LE","1000.00","67","CU","","","0","খাবার আশিক");
INSERT INTO tbl_payvoucherde VALUES("857","0","290","2","LE","4000.00","67","CU","","","0","রাসেল বাস রড বাকা");
INSERT INTO tbl_payvoucherde VALUES("858","0","290","2","LE","4160.00","35","SU","","","0","কাটিং পাথর");
INSERT INTO tbl_payvoucherde VALUES("859","0","291","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("860","0","291","2","LE","200000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("861","0","292","2","LE","100000.00","1","LO","","","0","SUDEV");
INSERT INTO tbl_payvoucherde VALUES("862","0","293","2","LE","1500.00","35","SU","","","0","GAS");
INSERT INTO tbl_payvoucherde VALUES("863","0","293","2","LE","650.00","35","SU","","","0","OCEXEN");
INSERT INTO tbl_payvoucherde VALUES("864","0","294","2","LE","120.00","35","SU","","","0","RAJMISTRI BARA");
INSERT INTO tbl_payvoucherde VALUES("865","0","295","2","LE","200000.00","25","SU","","","0","GOM PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("866","0","295","2","LE","200.00","35","SU","","","0","VAN BARA");
INSERT INTO tbl_payvoucherde VALUES("867","0","295","2","LE","450.00","35","SU","","","0","SPRING");
INSERT INTO tbl_payvoucherde VALUES("868","0","295","2","LE","150.00","35","SU","","","0","MERKER PEN");
INSERT INTO tbl_payvoucherde VALUES("869","0","296","2","LE","465000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("870","0","296","2","LE","350000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("871","0","296","2","LE","20000.00","25","CU","","","0","DOLIL");
INSERT INTO tbl_payvoucherde VALUES("872","0","296","2","LE","200.00","35","SU","","","0","RONG MISTIRI");
INSERT INTO tbl_payvoucherde VALUES("873","0","296","2","LE","300000.00","2","LO","","","0","MAJI");
INSERT INTO tbl_payvoucherde VALUES("874","0","296","2","LE","120.00","25","CU","","","0","PATI PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("875","0","296","2","LE","300.00","67","CU","","","0","HEMER DILL");
INSERT INTO tbl_payvoucherde VALUES("876","0","296","2","LE","70000.00","35","SU","","","0","TIPU");
INSERT INTO tbl_payvoucherde VALUES("877","0","296","2","LE","20000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("878","0","296","2","LE","20000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("879","0","296","2","LE","880.00","35","SU","","","0","MALAMAL PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("880","0","297","2","LE","16860.00","35","SU","","","0","RONG,ROLLER,FOAM,BRUSH");
INSERT INTO tbl_payvoucherde VALUES("881","0","297","2","LE","800.00","35","SU","","","0","BALB");
INSERT INTO tbl_payvoucherde VALUES("882","0","297","2","LE","200.00","35","SU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("883","0","298","2","LE","74750.00","67","CU","","","0","SUMMERSIBALE TEST");
INSERT INTO tbl_payvoucherde VALUES("884","0","299","2","LE","2265000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("885","0","299","2","LE","110000.00","35","SU","","","0","ROD PURCHASE,RAM KRISNO");
INSERT INTO tbl_payvoucherde VALUES("886","0","299","2","LE","1500000.00","1","LO","","","0","BARKAT");
INSERT INTO tbl_payvoucherde VALUES("887","0","299","2","LE","7826.00","35","SU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("888","0","299","2","LE","9755.00","25","CU","","","0","AGRO FIRM");
INSERT INTO tbl_payvoucherde VALUES("889","0","299","2","LE","4418.00","25","CU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("890","0","299","2","LE","340000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("891","0","299","2","LE","350000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("892","0","299","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("893","0","299","2","LE","2000.00","25","CU","","","0","GAS,BAZAR,FUFA");
INSERT INTO tbl_payvoucherde VALUES("894","0","299","2","LE","5000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("895","0","299","2","LE","5500.00","35","SU","","","0","TI 3" 10 PC");
INSERT INTO tbl_payvoucherde VALUES("896","0","300","2","LE","4250.00","35","SU","","","0","গুনা,আটা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("897","0","300","2","LE","150.00","35","SU","","","0","ট্রাসপোট");
INSERT INTO tbl_payvoucherde VALUES("898","0","300","2","LE","10000.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("899","0","300","2","LE","293000.00","6","CU","","","0","গম ক্রয় বাবদ প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("900","0","300","2","LE","500000.00","6","CU","","","0","গম ক্রয় বাবদ প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("901","0","300","2","LE","107000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("902","0","301","2","LE","1100000.00","25","CU","","","0","SAJIB DOKAN");
INSERT INTO tbl_payvoucherde VALUES("903","0","302","2","LE","100000.00","6","CU","","","0","BASIR WRONG");
INSERT INTO tbl_payvoucherde VALUES("904","0","303","2","LE","3200.00","62","CU","","","0","ক্যামেরা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("905","0","303","2","LE","20000.00","67","CU","","","0","বিলএর 1% xnকে");
INSERT INTO tbl_payvoucherde VALUES("906","0","303","2","LE","10000.00","67","CU","","","0","বিলএর 5% ক্যাশিয়ারকে");
INSERT INTO tbl_payvoucherde VALUES("907","0","303","2","LE","1000000.00","1","LO","","","0","লিয়েন");
INSERT INTO tbl_payvoucherde VALUES("908","0","303","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("909","0","304","2","LE","500000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("910","0","305","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("911","0","305","2","LE","2850.00","35","SU","","","0","chakki-6,clam");
INSERT INTO tbl_payvoucherde VALUES("912","0","305","2","LE","1050.00","35","SU","","","0","pan");
INSERT INTO tbl_payvoucherde VALUES("913","0","305","2","LE","290.00","35","SU","","","0","nat");
INSERT INTO tbl_payvoucherde VALUES("914","0","305","2","LE","200.00","35","SU","","","0","bara");
INSERT INTO tbl_payvoucherde VALUES("915","0","305","2","LE","41860.00","62","CU","","","0","biddut bill");
INSERT INTO tbl_payvoucherde VALUES("916","0","305","2","LE","600000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("917","0","305","2","LE","501100.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("918","0","305","2","LE","350.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("919","0","305","2","LE","160.00","35","SU","","","0","rajmistri bara");
INSERT INTO tbl_payvoucherde VALUES("920","0","305","2","LE","2600.00","25","CU","","","0","monora fufa");
INSERT INTO tbl_payvoucherde VALUES("921","0","305","2","LE","11600.00","35","SU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("922","0","305","2","LE","7150.00","35","SU","","","0","planshet");
INSERT INTO tbl_payvoucherde VALUES("923","0","305","2","LE","400.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("924","0","305","2","LE","60000.00","25","CU","","","0","madrasha");
INSERT INTO tbl_payvoucherde VALUES("925","0","305","2","LE","7000.00","67","CU","","","0","20*350");
INSERT INTO tbl_payvoucherde VALUES("926","0","305","2","LE","1000.00","67","CU","","","0","gecket");
INSERT INTO tbl_payvoucherde VALUES("927","0","305","2","LE","300.00","67","CU","","","0","bkash");
INSERT INTO tbl_payvoucherde VALUES("928","0","306","2","LE","31500.00","35","SU","","","0","tipu");
INSERT INTO tbl_payvoucherde VALUES("929","0","306","2","LE","12600.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("930","0","306","2","LE","1000.00","25","CU","","","0","hasan");
INSERT INTO tbl_payvoucherde VALUES("931","0","306","2","LE","120.00","35","SU","","","0","quriar");
INSERT INTO tbl_payvoucherde VALUES("932","0","307","2","LE","5300.00","35","SU","","","0","toylet");
INSERT INTO tbl_payvoucherde VALUES("933","0","307","2","LE","9000.00","25","CU","","","0","malek fufa,ridoy");
INSERT INTO tbl_payvoucherde VALUES("934","0","307","2","LE","20000.00","67","CU","","","0","so sir 1%");
INSERT INTO tbl_payvoucherde VALUES("935","0","308","2","LE","10000.00","25","CU","","","0","kuta");
INSERT INTO tbl_payvoucherde VALUES("936","0","309","2","LE","8300.00","35","SU","","","0","rasel angle");
INSERT INTO tbl_payvoucherde VALUES("937","0","309","2","LE","5050.00","35","SU","","","0","oarling rod");
INSERT INTO tbl_payvoucherde VALUES("938","0","309","2","LE","3250.00","35","SU","","","0","cutting pathor");
INSERT INTO tbl_payvoucherde VALUES("939","0","309","2","LE","200.00","35","SU","","","0","pen");
INSERT INTO tbl_payvoucherde VALUES("940","0","310","2","LE","1000.00","62","CU","","","0","salary");
INSERT INTO tbl_payvoucherde VALUES("941","0","310","2","LE","9900.00","67","CU","","","0","biddut khuti");
INSERT INTO tbl_payvoucherde VALUES("942","0","310","2","LE","300.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("943","0","310","2","LE","3000.00","67","CU","","","0","rasel angle");
INSERT INTO tbl_payvoucherde VALUES("944","0","310","2","LE","1500.00","35","SU","","","0","gate kaj rasel");
INSERT INTO tbl_payvoucherde VALUES("945","0","310","2","LE","8650.00","35","SU","","","0","red oxside");
INSERT INTO tbl_payvoucherde VALUES("946","0","310","2","LE","700.00","35","SU","","","0","oxejen");
INSERT INTO tbl_payvoucherde VALUES("947","0","310","2","LE","5200.00","35","SU","","","0","markin kapor,thiner,rong");
INSERT INTO tbl_payvoucherde VALUES("948","0","310","2","LE","250.00","35","SU","","","0","vara");
INSERT INTO tbl_payvoucherde VALUES("949","0","311","2","LE","320.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("950","0","311","2","LE","1000.00","67","CU","","","0","আসিক বেতন");
INSERT INTO tbl_payvoucherde VALUES("951","0","311","2","LE","1000.00","67","CU","","","0","খাবার বাবদ");
INSERT INTO tbl_payvoucherde VALUES("952","0","312","2","LE","286867.50","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("953","0","313","2","LE","200.00","35","SU","","","0","রাজমিস্ত্রি ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("954","0","313","2","LE","50000.00","19","SU","","","0","24-54,জরিমানা");
INSERT INTO tbl_payvoucherde VALUES("955","0","313","2","LE","300000.00","2","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("956","0","313","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("957","0","313","2","LE","1142500.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("958","0","313","2","LE","1900.00","35","SU","","","0","ফোম,ব্রাশ");
INSERT INTO tbl_payvoucherde VALUES("959","0","313","2","LE","500.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("960","0","313","2","LE","400.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("961","0","314","2","LE","22000.00","62","CU","","","0","লবন ক্রয়");
INSERT INTO tbl_payvoucherde VALUES("963","0","316","2","LE","200.00","35","SU","","","0","ভ্যান ভাড়া ");
INSERT INTO tbl_payvoucherde VALUES("964","0","317","2","LE","500.00","35","SU","","","0","pipe");
INSERT INTO tbl_payvoucherde VALUES("965","0","317","2","LE","442000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("966","0","317","2","LE","5000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("967","0","317","2","LE","300000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("968","0","317","2","LE","500000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("969","0","317","2","LE","500000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("970","0","317","2","LE","500000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("971","0","318","2","LE","77110.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("972","0","319","2","LE","140700.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("974","0","321","2","LE","525.00","89","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("975","0","322","2","LE","2000.00","67","CU","","","0","ঠিকাদারি কাজ বাবদ");
INSERT INTO tbl_payvoucherde VALUES("976","0","322","2","LE","20.00","35","SU","","","0","রাজমিস্ত্রি ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("977","0","323","2","LE","930.00","35","SU","","","0","চক+গ্রান্ডিং এর নাট");
INSERT INTO tbl_payvoucherde VALUES("978","0","323","2","LE","1220.00","35","SU","","","0","গ্রিজ গান ফ্লাঞ্চ");
INSERT INTO tbl_payvoucherde VALUES("979","0","323","2","LE","30000.00","26","SU","","","0","মাহাবুব কে প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("980","0","323","2","LE","240000.00","19","SU","","","0","ব্রাকের কিস্তি");
INSERT INTO tbl_payvoucherde VALUES("981","0","323","2","LE","100000.00","35","SU","","","0","রড ক্রয়");
INSERT INTO tbl_payvoucherde VALUES("982","0","324","2","LE","40000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("983","0","324","2","LE","2000.00","67","CU","","","0","rasel angle");
INSERT INTO tbl_payvoucherde VALUES("984","0","324","2","LE","90650.00","25","CU","","","0","cow feed,kura,salt");
INSERT INTO tbl_payvoucherde VALUES("985","0","324","2","LE","5005.00","25","CU","","","0","bkash");
INSERT INTO tbl_payvoucherde VALUES("986","0","324","2","LE","5000.00","35","SU","","","0","gate babod rasel");
INSERT INTO tbl_payvoucherde VALUES("987","0","324","2","LE","1350.00","67","CU","","","0","hamer drill");
INSERT INTO tbl_payvoucherde VALUES("988","0","324","2","LE","5800.00","35","SU","","","0","kat banga");
INSERT INTO tbl_payvoucherde VALUES("989","0","325","2","LE","5000.00","25","CU","","","0","ADIL");
INSERT INTO tbl_payvoucherde VALUES("990","0","326","2","LE","32300.00","25","CU","","","0","মালেকফুপারসাইডেররডসিমেন্ট");
INSERT INTO tbl_payvoucherde VALUES("991","0","326","2","LE","18800.00","35","SU","","","0","পাইপ ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("992","0","326","2","LE","5520.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("993","0","326","2","LE","30000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("994","0","326","2","LE","250.00","35","SU","","","0","রং মিস্ত্রি নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("995","0","326","2","LE","200000.00","1","LO","","","0","রহমান");
INSERT INTO tbl_payvoucherde VALUES("996","0","326","2","LE","100000.00","1","LO","","","0","রহমান");
INSERT INTO tbl_payvoucherde VALUES("997","0","326","2","LE","400000.00","1","LO","","","0","আরমান");
INSERT INTO tbl_payvoucherde VALUES("998","0","326","2","LE","350000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("999","0","327","2","LE","3800.00","25","CU","","","0","misti");
INSERT INTO tbl_payvoucherde VALUES("1000","0","327","2","LE","1000.00","25","CU","","","0","hasan");
INSERT INTO tbl_payvoucherde VALUES("1001","0","327","2","LE","4450.00","25","CU","","","0","misti");
INSERT INTO tbl_payvoucherde VALUES("1002","0","327","2","LE","1060.00","25","CU","","","0","da,katail");
INSERT INTO tbl_payvoucherde VALUES("1003","0","327","2","LE","250.00","67","CU","","","0","nasta");
INSERT INTO tbl_payvoucherde VALUES("1004","0","328","2","LE","11050.00","35","SU","","","0","রং ব্র্রাশ");
INSERT INTO tbl_payvoucherde VALUES("1005","0","329","2","LE","1700.00","35","SU","","","0","তার পিন,জুট");
INSERT INTO tbl_payvoucherde VALUES("1006","0","330","2","LE","480.00","25","CU","","","0","MISTI");
INSERT INTO tbl_payvoucherde VALUES("1007","0","330","2","LE","500000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1008","0","330","2","LE","88500.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1009","0","330","2","LE","35400.00","67","CU","","","0","PIPE");
INSERT INTO tbl_payvoucherde VALUES("1010","0","330","2","LE","465000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1011","0","330","2","LE","300.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1012","0","330","2","LE","480.00","25","CU","","","0","MISTI");
INSERT INTO tbl_payvoucherde VALUES("1013","0","331","2","LE","363200.00","64","CU","","","0","MATI KATA");
INSERT INTO tbl_payvoucherde VALUES("1014","0","332","2","LE","70000.00","64","CU","","","0","নুর ইসলাম মাছ");
INSERT INTO tbl_payvoucherde VALUES("1015","0","333","2","LE","1000.00","67","CU","","","0","আসিক খাবার");
INSERT INTO tbl_payvoucherde VALUES("1016","0","333","2","LE","500.00","67","CU","","","0","জি আই তার,রশি");
INSERT INTO tbl_payvoucherde VALUES("1017","0","333","2","LE","500.00","67","CU","","","0","খেলা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1018","0","333","2","LE","200.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1019","0","333","2","LE","10000.00","35","SU","","","0","মনির রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1020","0","333","2","LE","400.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1021","0","333","2","LE","9900.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1022","0","333","2","LE","150.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1023","0","333","2","LE","100000.00","1","LO","","","0","juel");
INSERT INTO tbl_payvoucherde VALUES("1024","0","333","2","LE","500000.00","1","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("1025","0","333","2","LE","415.00","35","SU","","","0","কুরিয়ার বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1026","0","333","2","LE","27000.00","35","SU","","","0","টিপুকে প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("1027","0","334","2","LE","7900.00","40","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1028","0","335","2","LE","120.00","35","SU","","","0","রাজমিস্ত্রি ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1029","0","335","2","LE","7800.00","25","CU","","","0","মনোহরমালেকফুফাররাজমিস্ত্র");
INSERT INTO tbl_payvoucherde VALUES("1030","0","335","2","LE","9800.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1031","0","336","2","LE","35000.00","25","CU","","","0","won");
INSERT INTO tbl_payvoucherde VALUES("1032","0","336","2","LE","20000.00","25","CU","","","0","arman");
INSERT INTO tbl_payvoucherde VALUES("1033","0","337","2","LE","20000.00","25","CU","","","0","NIJ GOPAL");
INSERT INTO tbl_payvoucherde VALUES("1034","0","337","2","LE","600.00","35","SU","","","0","GRAND DRILL");
INSERT INTO tbl_payvoucherde VALUES("1035","0","338","2","LE","2510.00","25","CU","","","0","SCALE MERAMAT");
INSERT INTO tbl_payvoucherde VALUES("1036","0","339","2","LE","23800.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1037","0","339","2","LE","250.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1038","0","340","2","LE","10000.00","67","CU","","","0","rasel angle");
INSERT INTO tbl_payvoucherde VALUES("1039","0","340","2","LE","420.00","62","CU","","","0","dai meramat");
INSERT INTO tbl_payvoucherde VALUES("1041","0","342","2","LE","40000.00","25","CU","","","0","lawrin");
INSERT INTO tbl_payvoucherde VALUES("1042","0","342","2","LE","74000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1043","0","342","2","LE","25000.00","67","CU","","","0","bakul");
INSERT INTO tbl_payvoucherde VALUES("1044","0","342","2","LE","96800.00","35","SU","","","0","rod");
INSERT INTO tbl_payvoucherde VALUES("1045","0","342","2","LE","900.00","35","SU","","","0","oxizen");
INSERT INTO tbl_payvoucherde VALUES("1046","0","343","2","LE","1000000.00","1","LO","","","0","জুয়েল");
INSERT INTO tbl_payvoucherde VALUES("1047","0","344","2","LE","300.00","35","SU","","","0","রং মিস্ত্রি নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("1048","0","344","2","LE","45.00","62","CU","","","0","কয়েল");
INSERT INTO tbl_payvoucherde VALUES("1049","0","344","2","LE","3000.00","35","SU","","","0","রং মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1050","0","344","2","LE","5000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1051","0","345","2","LE","12315960.00","25","CU","","","0","SAJIB BHAI DOKAN PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1052","0","345","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1053","0","345","2","LE","4422615.00","25","CU","","","0","SAJIB DOKAN PURCHASE 1499");
INSERT INTO tbl_payvoucherde VALUES("1054","0","345","2","LE","5000.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("1055","0","345","2","LE","520.00","25","CU","","","0","BOROF");
INSERT INTO tbl_payvoucherde VALUES("1056","0","345","2","LE","250.00","25","CU","","","0","TULI APA QURIAR");
INSERT INTO tbl_payvoucherde VALUES("1057","0","345","2","LE","50.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1058","0","345","2","LE","100.00","25","CU","","","0","GRASS CUTTING MACHINE JAL");
INSERT INTO tbl_payvoucherde VALUES("1059","0","345","2","LE","750000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1060","0","345","2","LE","50000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1061","0","345","2","LE","100.00","67","CU","","","0","JALAI KAJ");
INSERT INTO tbl_payvoucherde VALUES("1062","0","345","2","LE","14000.00","25","CU","","","0","HASAN SALARY");
INSERT INTO tbl_payvoucherde VALUES("1063","0","345","2","LE","1000000.00","2","LO","","","0","MAJI");
INSERT INTO tbl_payvoucherde VALUES("1064","0","345","2","LE","1000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("1065","0","346","2","LE","300.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1066","0","346","2","LE","40.00","35","SU","","","0","VARA+NASTA");
INSERT INTO tbl_payvoucherde VALUES("1067","0","347","2","LE","2600.00","35","SU","","","0","কাটিং পাথর ");
INSERT INTO tbl_payvoucherde VALUES("1068","0","347","2","LE","960.00","35","SU","","","0","তার পিন");
INSERT INTO tbl_payvoucherde VALUES("1069","0","347","2","LE","300.00","35","SU","","","0","স্টীল তারকাটা");
INSERT INTO tbl_payvoucherde VALUES("1070","0","347","2","LE","70.00","35","SU","","","0","রেত");
INSERT INTO tbl_payvoucherde VALUES("1071","0","347","2","LE","150.00","67","CU","","","0","ভ্যান ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1072","0","347","2","LE","4480.00","35","SU","","","0","রং");
INSERT INTO tbl_payvoucherde VALUES("1073","0","347","2","LE","440.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1074","0","348","2","LE","9000.00","8","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1075","0","349","2","LE","214500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1076","0","349","2","LE","20000.00","25","CU","","","0","বিকাশ");
INSERT INTO tbl_payvoucherde VALUES("1077","0","350","2","LE","1500000.00","31","SU","","","0","1275");
INSERT INTO tbl_payvoucherde VALUES("1078","0","350","2","LE","3000000.00","31","SU","","","0","1499");
INSERT INTO tbl_payvoucherde VALUES("1079","0","350","2","LE","203400.00","7","SU","","","0","ATTA PURCHSE");
INSERT INTO tbl_payvoucherde VALUES("1080","0","350","2","LE","100000.00","35","SU","","","0","IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1081","0","350","2","LE","1500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1082","0","350","2","LE","3000000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1083","0","350","2","LE","1000000.00","1","LO","","","0","1275");
INSERT INTO tbl_payvoucherde VALUES("1084","0","350","2","LE","290000.00","1","LO","","","0","ARMAN");
INSERT INTO tbl_payvoucherde VALUES("1085","0","350","2","LE","499.00","35","SU","","","0","CC CAMERA NET BILL");
INSERT INTO tbl_payvoucherde VALUES("1086","0","351","2","LE","400000.00","12","SU","","","0","nbl");
INSERT INTO tbl_payvoucherde VALUES("1087","0","352","2","LE","500.00","62","CU","","","0","shohel");
INSERT INTO tbl_payvoucherde VALUES("1088","0","352","2","LE","5000.00","25","CU","","","0","churi");
INSERT INTO tbl_payvoucherde VALUES("1089","0","352","2","LE","2000.00","25","CU","","","0","khaber najim uddin");
INSERT INTO tbl_payvoucherde VALUES("1090","0","352","2","LE","85.00","35","SU","","","0","rased");
INSERT INTO tbl_payvoucherde VALUES("1091","0","352","2","LE","3000.00","25","CU","","","0","nocimon bara");
INSERT INTO tbl_payvoucherde VALUES("1092","0","352","2","LE","200.00","25","CU","","","0","hasan");
INSERT INTO tbl_payvoucherde VALUES("1093","0","353","2","LE","300.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("1094","0","354","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1095","0","355","2","LE","200.00","35","SU","","","0","পেপার");
INSERT INTO tbl_payvoucherde VALUES("1096","0","355","2","LE","20600.00","25","CU","","","0","ছাগল ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1097","0","356","2","LE","4000.00","67","CU","","","0","helal");
INSERT INTO tbl_payvoucherde VALUES("1098","0","356","2","LE","1000.00","67","CU","","","0","asik khaber");
INSERT INTO tbl_payvoucherde VALUES("1099","0","356","2","LE","1000.00","67","CU","","","0","rosi,merker pen");
INSERT INTO tbl_payvoucherde VALUES("1100","0","357","2","LE","1080.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("1101","0","357","2","LE","8000.00","67","CU","","","0","রাসেল");
INSERT INTO tbl_payvoucherde VALUES("1102","0","357","2","LE","3000.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1103","0","357","2","LE","500.00","35","SU","","","0","ট্রাসপোট");
INSERT INTO tbl_payvoucherde VALUES("1104","0","358","2","LE","150.00","35","SU","","","0","ভ্যান ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1105","0","359","2","LE","60000.00","35","SU","","","0","CHIKNI");
INSERT INTO tbl_payvoucherde VALUES("1106","0","359","2","LE","200000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1107","0","359","2","LE","655000.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1108","0","359","2","LE","30400.00","35","SU","","","0","BALI");
INSERT INTO tbl_payvoucherde VALUES("1109","0","359","2","LE","10000.00","62","CU","","","0","ROLLER");
INSERT INTO tbl_payvoucherde VALUES("1110","0","359","2","LE","90000.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1111","0","359","2","LE","500.00","25","CU","","","0","KALAI MEDICAL");
INSERT INTO tbl_payvoucherde VALUES("1112","0","359","2","LE","33000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1113","0","359","2","LE","2700.00","35","SU","","","0","KHABER");
INSERT INTO tbl_payvoucherde VALUES("1114","0","359","2","LE","1000.00","35","SU","","","0","BOKSHIS");
INSERT INTO tbl_payvoucherde VALUES("1115","0","359","2","LE","8450.00","25","CU","","","0","MALEK FUFAR JIOMI");
INSERT INTO tbl_payvoucherde VALUES("1116","0","359","2","LE","3000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1117","0","359","2","LE","2000000.00","41","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1118","0","359","2","LE","460.00","35","SU","","","0","VARA+NASTA");
INSERT INTO tbl_payvoucherde VALUES("1119","0","360","2","LE","500.00","62","CU","","","0","FULL TREE");
INSERT INTO tbl_payvoucherde VALUES("1120","0","361","2","LE","150.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("1121","0","362","2","LE","5000.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("1122","0","363","2","LE","50000.00","67","CU","","","0","HELAL MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1123","0","363","2","LE","1000.00","25","CU","","","0","NAJIM UDDIN");
INSERT INTO tbl_payvoucherde VALUES("1124","0","364","2","LE","4600.00","62","CU","","","0","led kaj");
INSERT INTO tbl_payvoucherde VALUES("1125","0","364","2","LE","300.00","67","CU","","","0","led bill");
INSERT INTO tbl_payvoucherde VALUES("1126","0","364","2","LE","10000.00","67","CU","","","0","asik");
INSERT INTO tbl_payvoucherde VALUES("1127","0","364","2","LE","8450.00","35","SU","","","0","kali rajmistr");
INSERT INTO tbl_payvoucherde VALUES("1128","0","364","2","LE","900.00","35","SU","","","0","rajmistri nasta");
INSERT INTO tbl_payvoucherde VALUES("1129","0","364","2","LE","100.00","35","SU","","","0","rased");
INSERT INTO tbl_payvoucherde VALUES("1130","0","364","2","LE","100.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("1131","0","365","2","LE","27600.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1132","0","365","2","LE","5200.00","25","CU","","","0","মালেক ফুপার রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1133","0","365","2","LE","280.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1134","0","366","2","LE","72520.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1135","0","367","2","LE","50000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1136","0","367","2","LE","300000.00","48","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1137","0","368","2","LE","76800.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1138","0","368","2","LE","200.00","67","CU","","","0","flanch");
INSERT INTO tbl_payvoucherde VALUES("1139","0","368","2","LE","600.00","25","CU","","","0","miter exp");
INSERT INTO tbl_payvoucherde VALUES("1140","0","368","2","LE","1000.00","25","CU","","","0","bazar bua salary");
INSERT INTO tbl_payvoucherde VALUES("1141","0","368","2","LE","1400.00","25","CU","","","0","van motor");
INSERT INTO tbl_payvoucherde VALUES("1142","0","369","2","LE","300000.00","46","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1143","0","370","2","LE","4000.00","67","CU","","","0","RASEL ANGLE");
INSERT INTO tbl_payvoucherde VALUES("1144","0","370","2","LE","26600.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1145","0","370","2","LE","28500.00","35","SU","","","0","BALI CEMENT");
INSERT INTO tbl_payvoucherde VALUES("1146","0","370","2","LE","1000.00","25","CU","","","0","MADRASHA SALARY");
INSERT INTO tbl_payvoucherde VALUES("1147","0","370","2","LE","600000.00","25","CU","","","0","SAJIB BHAI DOKAN");
INSERT INTO tbl_payvoucherde VALUES("1148","0","370","2","LE","10000.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("1149","0","371","2","LE","3200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1150","0","371","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1151","0","371","2","LE","95000.00","48","SU","","","0","গম ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1152","0","372","2","LE","40000.00","46","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1153","0","373","2","LE","1000000.00","31","SU","","","0","পূবালী ব্যাংকে");
INSERT INTO tbl_payvoucherde VALUES("1154","0","374","2","LE","376551.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1155","0","374","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1156","0","374","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1157","0","374","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1158","0","375","2","LE","1000.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1159","0","376","2","LE","50000.00","150","LE","","","0","ব্লুয়ার সাইক্লোন ডাইওয়াস");
INSERT INTO tbl_payvoucherde VALUES("1160","0","377","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1161","0","377","2","LE","170000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1162","0","377","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1163","0","377","2","LE","1000000.00","1","LO","","","0","juyel");
INSERT INTO tbl_payvoucherde VALUES("1164","0","378","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1165","0","378","2","LE","17500.00","35","SU","","","0","CIKNI");
INSERT INTO tbl_payvoucherde VALUES("1166","0","379","2","LE","291400.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1167","0","380","2","LE","20005.00","67","CU","","","0","HELAL PIPE");
INSERT INTO tbl_payvoucherde VALUES("1168","0","381","2","LE","6300.00","25","CU","","","0","SALT BASA");
INSERT INTO tbl_payvoucherde VALUES("1169","0","381","2","LE","1300.00","25","CU","","","0","MOKSED BASA");
INSERT INTO tbl_payvoucherde VALUES("1170","0","381","2","LE","1300.00","25","CU","","","0","BAREL");
INSERT INTO tbl_payvoucherde VALUES("1171","0","382","2","LE","316375.00","48","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1172","0","383","2","LE","2900.00","25","CU","","","0","কোটাপুকুরেগ্যাসট্যাবলেট");
INSERT INTO tbl_payvoucherde VALUES("1173","0","383","2","LE","3800.00","35","SU","","","0","চিপনির প্লেট ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1174","0","384","2","LE","40525.00","46","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1175","0","385","2","LE","1000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("1176","0","386","2","LE","1600.00","35","SU","","","0","KHABER");
INSERT INTO tbl_payvoucherde VALUES("1177","0","387","2","LE","1000.00","67","CU","","","0","ASIK KHABER");
INSERT INTO tbl_payvoucherde VALUES("1178","0","388","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1179","0","389","2","LE","2500.00","67","CU","","","0","warling rod,saluasion");
INSERT INTO tbl_payvoucherde VALUES("1180","0","389","2","LE","2005.00","67","CU","","","0","mahabub");
INSERT INTO tbl_payvoucherde VALUES("1181","0","390","2","LE","280000.00","1","LO","","","0","BARKAT");
INSERT INTO tbl_payvoucherde VALUES("1182","0","391","2","LE","60000.00","25","CU","","","0","ARMAN");
INSERT INTO tbl_payvoucherde VALUES("1183","0","392","2","LE","3900.00","25","CU","","","0","MALEK FUFAR JOMI RAJMISTR");
INSERT INTO tbl_payvoucherde VALUES("1184","0","393","2","LE","2000.00","25","CU","","","0","মালেক ফুপার জমি ");
INSERT INTO tbl_payvoucherde VALUES("1185","0","393","2","LE","2000.00","67","CU","","","0","পাইপ মিস্ত্রি খাবার");
INSERT INTO tbl_payvoucherde VALUES("1186","0","393","2","LE","2000.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1187","0","394","2","LE","240000.00","1","LO","","","0","Barkat kaka");
INSERT INTO tbl_payvoucherde VALUES("1188","0","394","2","LE","226500.00","1","LO","","","0","Arman SAGOR");
INSERT INTO tbl_payvoucherde VALUES("1189","0","394","2","LE","1000000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1190","0","394","2","LE","786800.00","62","CU","","","0","SUTKI");
INSERT INTO tbl_payvoucherde VALUES("1191","0","394","2","LE","324000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1192","0","394","2","LE","22795.00","25","CU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("1193","0","394","2","LE","8672.00","35","SU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("1194","0","395","2","LE","5100.00","64","CU","","","0","মাছ ধরা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1195","0","396","2","LE","1000000.00","117","CU","","","0","WRONG ENTRY");
INSERT INTO tbl_payvoucherde VALUES("1196","0","397","2","LE","1750.00","67","CU","","","0","CLAM");
INSERT INTO tbl_payvoucherde VALUES("1197","0","397","2","LE","6600.00","62","CU","","","0","CHITTAGONG");
INSERT INTO tbl_payvoucherde VALUES("1198","0","397","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1199","0","398","2","LE","4000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1200","0","399","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1201","0","400","2","LE","171000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1202","0","400","2","LE","250.00","67","CU","","","0","CLAM");
INSERT INTO tbl_payvoucherde VALUES("1203","0","400","2","LE","590000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1204","0","400","2","LE","108058.00","62","CU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("1205","0","400","2","LE","33000.00","62","CU","","","0","TRUCK VARA");
INSERT INTO tbl_payvoucherde VALUES("1206","0","400","2","LE","17710.00","19","SU","","","0","MOBIL,FILTER CHANGE");
INSERT INTO tbl_payvoucherde VALUES("1207","0","401","2","LE","4000.00","67","CU","","","0","HELAL MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1208","0","401","2","LE","1000.00","67","CU","","","0","ASIK BONUS");
INSERT INTO tbl_payvoucherde VALUES("1210","0","403","2","LE","3900.00","25","CU","","","0","rajmistri malek fufa");
INSERT INTO tbl_payvoucherde VALUES("1211","0","404","2","LE","11300.00","25","CU","","","0","MANGO TREE PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1212","0","405","2","LE","3000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1213","0","406","2","LE","5000.00","25","CU","","","0","osman salary");
INSERT INTO tbl_payvoucherde VALUES("1214","0","406","2","LE","5410.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1215","0","406","2","LE","1500.00","25","CU","","","0","private car gas +oil");
INSERT INTO tbl_payvoucherde VALUES("1216","0","407","2","LE","600.00","35","SU","","","0","CHULA");
INSERT INTO tbl_payvoucherde VALUES("1217","0","408","2","LE","2000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1218","0","408","2","LE","3000.00","62","CU","","","0","BISKUT");
INSERT INTO tbl_payvoucherde VALUES("1219","0","408","2","LE","19440.00","64","CU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("1220","0","408","2","LE","1000.00","62","CU","","","0","BISKUT");
INSERT INTO tbl_payvoucherde VALUES("1221","0","408","2","LE","4000.00","35","SU","","","0","GUNA");
INSERT INTO tbl_payvoucherde VALUES("1222","0","408","2","LE","1940.00","35","SU","","","0","TERKATA");
INSERT INTO tbl_payvoucherde VALUES("1223","0","408","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1224","0","408","2","LE","50000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1225","0","409","2","LE","400000.00","1","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("1226","0","409","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1227","0","410","2","LE","10000.00","35","SU","","","0","RAJMISTRI-10");
INSERT INTO tbl_payvoucherde VALUES("1228","0","410","2","LE","3500.00","62","CU","","","0","BISKUT");
INSERT INTO tbl_payvoucherde VALUES("1229","0","410","2","LE","3000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1230","0","411","2","LE","800000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1231","0","411","2","LE","600000.00","1","LO","","","0","JUEL");
INSERT INTO tbl_payvoucherde VALUES("1232","0","412","2","LE","100000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1233","0","413","2","LE","1000.00","115","CU","","","0","NOCIMON VARA");
INSERT INTO tbl_payvoucherde VALUES("1234","0","414","2","LE","40500.00","19","SU","","","0","24-54,মবিল ফিল্টারওঅনন্য");
INSERT INTO tbl_payvoucherde VALUES("1235","0","414","2","LE","10000.00","19","SU","","","0","24-54, হারেজ মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1236","0","414","2","LE","1000.00","25","CU","","","0","বাসার কাকি");
INSERT INTO tbl_payvoucherde VALUES("1237","0","414","2","LE","500.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1238","0","415","2","LE","1150.00","35","SU","","","0","ট্রেড লাইসেন্স");
INSERT INTO tbl_payvoucherde VALUES("1239","0","415","2","LE","200.00","62","CU","","","0","ফিড ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1240","0","415","2","LE","3500.00","25","CU","","","0","মালেক ফুপার জায়গায় বাশ");
INSERT INTO tbl_payvoucherde VALUES("1241","0","415","2","LE","520.00","25","CU","","","0","মালেক ফুপার বাশের ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1242","0","415","2","LE","90.00","67","CU","","","0","আসিক ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1243","0","415","2","LE","1920.00","67","CU","","","0","তালা+ভাড়া+খাবার+বালতি");
INSERT INTO tbl_payvoucherde VALUES("1244","0","415","2","LE","5030.00","67","CU","","","0","আসিক বোনাস+ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1245","0","416","2","LE","186000.00","7","SU","","","0","আটা ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1246","0","417","2","LE","6500.00","25","CU","","","0","cow medicines");
INSERT INTO tbl_payvoucherde VALUES("1247","0","418","2","LE","1900000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1248","0","418","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1249","0","418","2","LE","1000.00","25","CU","","","0","kaki");
INSERT INTO tbl_payvoucherde VALUES("1250","0","418","2","LE","5000.00","25","CU","","","0","ADIL SALARY");
INSERT INTO tbl_payvoucherde VALUES("1251","0","418","2","LE","1500.00","62","CU","","","0","BISKUT");
INSERT INTO tbl_payvoucherde VALUES("1252","0","419","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1253","0","420","2","LE","10000.00","25","CU","","","0","nij");
INSERT INTO tbl_payvoucherde VALUES("1254","0","420","2","LE","7800.00","25","CU","","","0","malek fufa-RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1255","0","420","2","LE","3500.00","25","CU","","","0","MALEK FUFA-NAJIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1256","0","420","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1257","0","421","2","LE","500000.00","1","LO","","","0","BARKAT");
INSERT INTO tbl_payvoucherde VALUES("1259","0","423","2","LE","100000.00","1","LO","","","0","RAHMAN DAIRY");
INSERT INTO tbl_payvoucherde VALUES("1260","0","424","2","LE","20000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1261","0","424","2","LE","650.00","35","SU","","","0","OXIZEN");
INSERT INTO tbl_payvoucherde VALUES("1262","0","424","2","LE","4000.00","25","CU","","","0","STATIONARY");
INSERT INTO tbl_payvoucherde VALUES("1263","0","424","2","LE","2950.00","35","SU","","","0","KODAL,SABOL,CUTTING PATHO");
INSERT INTO tbl_payvoucherde VALUES("1264","0","425","2","LE","1000.00","25","CU","","","0","HASAN");
INSERT INTO tbl_payvoucherde VALUES("1265","0","425","2","LE","200.00","25","CU","","","0","VAN ROSI");
INSERT INTO tbl_payvoucherde VALUES("1266","0","425","2","LE","2200.00","25","CU","","","0","FISH PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1267","0","426","2","LE","1600.00","13","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1268","0","427","2","LE","27400.00","25","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1269","0","428","2","LE","67587.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1270","0","429","2","LE","300000.00","115","CU","","","0","ALI AHMED");
INSERT INTO tbl_payvoucherde VALUES("1271","0","430","2","LE","1870.00","25","CU","","","0","tol,khaber");
INSERT INTO tbl_payvoucherde VALUES("1272","0","430","2","LE","1900.00","25","CU","","","0","adepter");
INSERT INTO tbl_payvoucherde VALUES("1273","0","430","2","LE","1020.00","35","SU","","","0","oarling rod");
INSERT INTO tbl_payvoucherde VALUES("1274","0","430","2","LE","1020.00","67","CU","","","0","oarling rod");
INSERT INTO tbl_payvoucherde VALUES("1275","0","431","2","LE","13625.00","25","CU","","","0","NAZRUL");
INSERT INTO tbl_payvoucherde VALUES("1276","0","431","2","LE","6000.00","17","EM","","","0","NOCIMON VARA,");
INSERT INTO tbl_payvoucherde VALUES("1280","0","434","2","LE","6000.00","115","CU","","","0","NOCIMON VARA,OXIZEN,JAILL");
INSERT INTO tbl_payvoucherde VALUES("1281","0","435","2","LE","4000.00","137","LE","","","0","ফায়ার লাইসেন্স নবায়ন ফি");
INSERT INTO tbl_payvoucherde VALUES("1282","0","436","2","LE","1500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1283","0","436","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1284","0","437","2","LE","1950.00","35","SU","","","0","সেইভ");
INSERT INTO tbl_payvoucherde VALUES("1285","0","438","2","LE","50000.00","46","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1286","0","439","2","LE","320000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1287","0","439","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1288","0","439","2","LE","1000000.00","25","CU","","","0","MOJAMMEL/BARKAT");
INSERT INTO tbl_payvoucherde VALUES("1289","0","439","2","LE","1000.00","60","CU","","","0","KALAI,TOFSILDER OFFICE");
INSERT INTO tbl_payvoucherde VALUES("1290","0","440","2","LE","220.00","62","CU","","","0","DIJEL");
INSERT INTO tbl_payvoucherde VALUES("1291","0","440","2","LE","1230.00","62","CU","","","0","OIL SEAL");
INSERT INTO tbl_payvoucherde VALUES("1292","0","440","2","LE","34150.00","35","SU","","","0","CEMENT+BALU");
INSERT INTO tbl_payvoucherde VALUES("1293","0","440","2","LE","1540.00","62","CU","","","0","CEMENT");
INSERT INTO tbl_payvoucherde VALUES("1294","0","441","2","LE","5000.00","35","SU","","","0","tipu mistri");
INSERT INTO tbl_payvoucherde VALUES("1295","0","442","2","LE","5000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1296","0","443","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1297","0","443","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1298","0","444","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1299","0","444","2","LE","140000.00","19","SU","","","0","brac kisti");
INSERT INTO tbl_payvoucherde VALUES("1300","0","445","2","LE","5000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1301","0","446","2","LE","100000.00","46","SU","","","0","DELOWER");
INSERT INTO tbl_payvoucherde VALUES("1302","0","447","2","LE","400000.00","1","LO","","","0","ARMAN");
INSERT INTO tbl_payvoucherde VALUES("1303","0","448","2","LE","30000.00","67","CU","","","0","SOYOD RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1304","0","448","2","LE","150.00","25","CU","","","0","GAS NIPLE");
INSERT INTO tbl_payvoucherde VALUES("1305","0","448","2","LE","100.00","25","CU","","","0","JAILLA");
INSERT INTO tbl_payvoucherde VALUES("1306","0","448","2","LE","14000.00","25","CU","","","0","HASAN SALARY");
INSERT INTO tbl_payvoucherde VALUES("1307","0","448","2","LE","17005.00","35","SU","","","0","ANKER BOLTU");
INSERT INTO tbl_payvoucherde VALUES("1308","0","448","2","LE","45150.00","25","CU","","","0","GOAT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1309","0","448","2","LE","4205.00","35","SU","","","0","ALBO,BAN 3"");
INSERT INTO tbl_payvoucherde VALUES("1310","0","448","2","LE","1500.00","25","CU","","","0","TREE CUTTING");
INSERT INTO tbl_payvoucherde VALUES("1311","0","448","2","LE","8500.00","25","CU","","","0","SANATERY MALAMAL");
INSERT INTO tbl_payvoucherde VALUES("1312","0","448","2","LE","12000.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("1313","0","448","2","LE","1155.00","25","CU","","","0","MALEK FUFU -CHURI");
INSERT INTO tbl_payvoucherde VALUES("1314","0","448","2","LE","1200.00","62","CU","","","0","MAGNET");
INSERT INTO tbl_payvoucherde VALUES("1315","0","448","2","LE","50.00","62","CU","","","0","KAGOJ");
INSERT INTO tbl_payvoucherde VALUES("1316","0","449","2","LE","75000.00","6","CU","","","0","LEAN");
INSERT INTO tbl_payvoucherde VALUES("1317","0","450","2","LE","5600.00","25","CU","","","0","TRADE LICENSE");
INSERT INTO tbl_payvoucherde VALUES("1318","0","450","2","LE","6750.00","62","CU","","","0","TRADE LICENSE");
INSERT INTO tbl_payvoucherde VALUES("1319","0","451","2","LE","56000.00","11","SU","","","0","NBL");
INSERT INTO tbl_payvoucherde VALUES("1320","0","452","2","LE","65000.00","11","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1321","0","453","2","LE","150.00","35","SU","","","0","ankor boltu vara");
INSERT INTO tbl_payvoucherde VALUES("1322","0","454","2","LE","29120.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1323","0","455","2","LE","50000.00","29","CU","","","0","WRONG ENTRY");
INSERT INTO tbl_payvoucherde VALUES("1324","0","456","2","LE","100000.00","46","SU","","","0","delower fakir");
INSERT INTO tbl_payvoucherde VALUES("1325","0","457","2","LE","1000.00","62","CU","","","0","biskut");
INSERT INTO tbl_payvoucherde VALUES("1326","0","457","2","LE","100.00","35","SU","","","0","van vara");
INSERT INTO tbl_payvoucherde VALUES("1327","0","457","2","LE","4000.00","35","SU","","","0","terkata");
INSERT INTO tbl_payvoucherde VALUES("1328","0","457","2","LE","4960.00","35","SU","","","0","oarling rod");
INSERT INTO tbl_payvoucherde VALUES("1329","0","457","2","LE","700000.00","2","SU","","","0","20 ton gom 35 tk rate");
INSERT INTO tbl_payvoucherde VALUES("1330","0","457","2","LE","150000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1331","0","457","2","LE","4000.00","35","SU","","","0","vara nogan");
INSERT INTO tbl_payvoucherde VALUES("1332","0","457","2","LE","772000.00","35","SU","","","0","malamal purchase,eli mite");
INSERT INTO tbl_payvoucherde VALUES("1333","0","457","2","LE","14000.00","35","SU","","","0","touras oil");
INSERT INTO tbl_payvoucherde VALUES("1334","0","457","2","LE","8430.00","35","SU","","","0","road kharoch");
INSERT INTO tbl_payvoucherde VALUES("1335","0","457","2","LE","24000.00","35","SU","","","0","truck vara");
INSERT INTO tbl_payvoucherde VALUES("1336","0","457","2","LE","2500.00","60","CU","","","0","salam/kalai");
INSERT INTO tbl_payvoucherde VALUES("1337","0","457","2","LE","30000.00","60","CU","","","0","jomi kalai");
INSERT INTO tbl_payvoucherde VALUES("1338","0","457","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1339","0","458","2","LE","50000.00","35","SU","","","0","রড ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1340","0","458","2","LE","500000.00","1","LO","","","0","MAJI");
INSERT INTO tbl_payvoucherde VALUES("1341","0","458","2","LE","400000.00","1","LO","","","0","JUEL");
INSERT INTO tbl_payvoucherde VALUES("1342","0","459","2","LE","3000.00","116","CU","","","0","CHUN");
INSERT INTO tbl_payvoucherde VALUES("1343","0","459","2","LE","4500.00","25","CU","","","0","CHUN");
INSERT INTO tbl_payvoucherde VALUES("1344","0","459","2","LE","24330.00","35","SU","","","0","ANGLE");
INSERT INTO tbl_payvoucherde VALUES("1345","0","459","2","LE","580.00","35","SU","","","0","NAT");
INSERT INTO tbl_payvoucherde VALUES("1346","0","459","2","LE","200.00","35","SU","","","0","VAN VARA");
INSERT INTO tbl_payvoucherde VALUES("1347","0","459","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1348","0","459","2","LE","260000.00","67","CU","","","0","SUMMERSIBOL PUMP");
INSERT INTO tbl_payvoucherde VALUES("1349","0","460","2","LE","130000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1350","0","461","2","LE","36800.00","35","SU","","","0","RICE MILL");
INSERT INTO tbl_payvoucherde VALUES("1351","0","461","2","LE","18000.00","35","SU","","","0","TIPU");
INSERT INTO tbl_payvoucherde VALUES("1352","0","461","2","LE","1190.00","62","CU","","","0","BEARING");
INSERT INTO tbl_payvoucherde VALUES("1353","0","461","2","LE","2700.00","35","SU","","","0","CUTTING PATHOR");
INSERT INTO tbl_payvoucherde VALUES("1354","0","462","2","LE","3000.00","67","CU","","","0","rasel");
INSERT INTO tbl_payvoucherde VALUES("1355","0","462","2","LE","1500.00","67","CU","","","0","asik khaber");
INSERT INTO tbl_payvoucherde VALUES("1356","0","463","2","LE","239000.00","46","SU","","","0","delower fakir");
INSERT INTO tbl_payvoucherde VALUES("1357","0","464","2","LE","1000.00","25","CU","","","0","malek fufa najim");
INSERT INTO tbl_payvoucherde VALUES("1358","0","464","2","LE","5500.00","25","CU","","","0","malek fufa,najim uddin");
INSERT INTO tbl_payvoucherde VALUES("1359","0","465","2","LE","400.00","62","CU","","","0","ডায়ারের কাজ");
INSERT INTO tbl_payvoucherde VALUES("1360","0","466","2","LE","203000.00","1","LO","","","0","pay order");
INSERT INTO tbl_payvoucherde VALUES("1361","0","466","2","LE","750.00","35","SU","","","0","pathkhori");
INSERT INTO tbl_payvoucherde VALUES("1362","0","466","2","LE","900000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1363","0","466","2","LE","1343300.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1364","0","466","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1365","0","467","2","LE","1316650.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1366","0","468","2","LE","500000.00","5","CU","","","0","ভুল সংশোধন");
INSERT INTO tbl_payvoucherde VALUES("1367","0","469","2","LE","26260.00","35","SU","","","0","cement");
INSERT INTO tbl_payvoucherde VALUES("1368","0","469","2","LE","159200.00","2","LO","","","0","salam");
INSERT INTO tbl_payvoucherde VALUES("1369","0","469","2","LE","300000.00","2","LO","","","0","sajib");
INSERT INTO tbl_payvoucherde VALUES("1370","0","470","2","LE","5960.00","25","CU","","","0","BAZAR");
INSERT INTO tbl_payvoucherde VALUES("1371","0","470","2","LE","6300.00","25","CU","","","0","COW SALT");
INSERT INTO tbl_payvoucherde VALUES("1372","0","470","2","LE","7800.00","25","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1373","0","470","2","LE","200.00","25","CU","","","0","SANITARY");
INSERT INTO tbl_payvoucherde VALUES("1374","0","470","2","LE","1530.00","67","CU","","","0","QURIER EXP");
INSERT INTO tbl_payvoucherde VALUES("1375","0","470","2","LE","299.00","35","SU","","","0","CC CAMERA");
INSERT INTO tbl_payvoucherde VALUES("1376","0","471","2","LE","800000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1377","0","471","2","LE","99000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1378","0","471","2","LE","500000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1380","0","473","2","LE","1000.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1381","0","473","2","LE","4000.00","35","SU","","","0","ফায়ার লাইসেন্স");
INSERT INTO tbl_payvoucherde VALUES("1382","0","473","2","LE","4000.00","62","CU","","","0","ফায়ার লাইসেন্স");
INSERT INTO tbl_payvoucherde VALUES("1383","0","474","2","LE","300.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("1384","0","474","2","LE","6000.00","67","CU","","","0","রাসেল ");
INSERT INTO tbl_payvoucherde VALUES("1385","0","475","2","LE","500000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1386","0","476","2","LE","249500.00","64","CU","","","0","QUALITY FEED");
INSERT INTO tbl_payvoucherde VALUES("1387","0","476","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1388","0","476","2","LE","217500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1389","0","476","2","LE","119500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1390","0","477","2","LE","5000.00","19","SU","","","0","BETTRY");
INSERT INTO tbl_payvoucherde VALUES("1391","0","478","2","LE","23000.00","25","CU","","","0","bkash");
INSERT INTO tbl_payvoucherde VALUES("1392","0","478","2","LE","2500.00","67","CU","","","0","motor vara");
INSERT INTO tbl_payvoucherde VALUES("1393","0","478","2","LE","5000.00","19","SU","","","0","bettary");
INSERT INTO tbl_payvoucherde VALUES("1394","0","479","2","LE","1600.00","25","CU","","","0","miter recharge");
INSERT INTO tbl_payvoucherde VALUES("1395","0","479","2","LE","1000.00","25","CU","","","0","bua salary");
INSERT INTO tbl_payvoucherde VALUES("1396","0","479","2","LE","1000.00","25","CU","","","0","shahida ");
INSERT INTO tbl_payvoucherde VALUES("1397","0","479","2","LE","1250.00","25","CU","","","0","van charger");
INSERT INTO tbl_payvoucherde VALUES("1398","0","479","2","LE","650.00","115","CU","","","0","oxyzen");
INSERT INTO tbl_payvoucherde VALUES("1399","0","479","2","LE","1930.00","115","CU","","","0","machine,khaber,khaber");
INSERT INTO tbl_payvoucherde VALUES("1400","0","480","2","LE","55000.00","115","CU","","","0","fish purchase");
INSERT INTO tbl_payvoucherde VALUES("1401","0","480","2","LE","30000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1402","0","481","2","LE","4480.00","35","SU","","","0","BIN");
INSERT INTO tbl_payvoucherde VALUES("1403","0","481","2","LE","120.00","35","SU","","","0","KOBJA");
INSERT INTO tbl_payvoucherde VALUES("1404","0","482","2","LE","400000.00","1","LO","","","0","juel");
INSERT INTO tbl_payvoucherde VALUES("1405","0","482","2","LE","500000.00","1","LO","","","0","sojib");
INSERT INTO tbl_payvoucherde VALUES("1406","0","482","2","LE","300000.00","1","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("1407","0","482","2","LE","5000.00","10","SU","","","0","লাইসেন্স বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1408","0","482","2","LE","5000.00","62","CU","","","0","লাইসেন্স বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1409","0","482","2","LE","700.00","35","SU","","","0","ভ্যান ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1410","0","482","2","LE","300000.00","2","SU","","","0","গম ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1411","0","482","2","LE","500000.00","62","CU","","","0","পলিশ ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1412","0","482","2","LE","50000.00","25","CU","","","0","আরমান কে");
INSERT INTO tbl_payvoucherde VALUES("1413","0","482","2","LE","5000.00","35","SU","","","0","মাচাইল");
INSERT INTO tbl_payvoucherde VALUES("1414","0","482","2","LE","800.00","35","SU","","","0","অক্রিজেন");
INSERT INTO tbl_payvoucherde VALUES("1415","0","482","2","LE","1800.00","35","SU","","","0","তারকাটা");
INSERT INTO tbl_payvoucherde VALUES("1417","0","484","2","LE","2660000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1418","0","485","2","LE","966000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1419","0","486","2","LE","1500000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1420","0","486","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1421","0","486","2","LE","30000.00","67","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1422","0","486","2","LE","420000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1423","0","486","2","LE","17200.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1424","0","487","2","LE","17200.00","62","CU","","","0","PATI,STICK");
INSERT INTO tbl_payvoucherde VALUES("1425","0","488","2","LE","7750.00","35","SU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("1426","0","488","2","LE","2400.00","35","SU","","","0","RAJMISTRI ARIF");
INSERT INTO tbl_payvoucherde VALUES("1427","0","489","2","LE","20000.00","35","SU","","","0","ROD PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1428","0","490","2","LE","3000.00","25","CU","","","0","MALEK FUFANAJIM UDDIN");
INSERT INTO tbl_payvoucherde VALUES("1429","0","490","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1430","0","490","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1431","0","490","2","LE","435000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1432","0","490","2","LE","500000.00","1","LO","","","0","JUEL");
INSERT INTO tbl_payvoucherde VALUES("1433","0","491","2","LE","300000.00","6","CU","","","0","GOM PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1434","0","492","2","LE","175000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1435","0","493","2","LE","8000.00","35","SU","","","0","RONG,RED OXIED");
INSERT INTO tbl_payvoucherde VALUES("1436","0","493","2","LE","600.00","35","SU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1437","0","493","2","LE","180.00","35","SU","","","0","GRANDING ");
INSERT INTO tbl_payvoucherde VALUES("1438","0","493","2","LE","100.00","35","SU","","","0","CAPACITER");
INSERT INTO tbl_payvoucherde VALUES("1439","0","493","2","LE","400.00","35","SU","","","0","VAN VARA");
INSERT INTO tbl_payvoucherde VALUES("1440","0","493","2","LE","3600.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1441","0","493","2","LE","8500.00","35","SU","","","0","RAJMISTRI KOL");
INSERT INTO tbl_payvoucherde VALUES("1442","0","493","2","LE","140.00","35","SU","","","0","NASTA RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1443","0","494","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1444","0","495","2","LE","1000.00","67","CU","","","0","ASIK");
INSERT INTO tbl_payvoucherde VALUES("1445","0","495","2","LE","21000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1446","0","495","2","LE","20000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1447","0","495","2","LE","17600.00","25","CU","","","0","MALEK FUFA IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1448","0","495","2","LE","18500.00","35","SU","","","0","IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1449","0","495","2","LE","300.00","25","CU","","","0","SAJIB DOKAN PIPE");
INSERT INTO tbl_payvoucherde VALUES("1450","0","495","2","LE","150.00","25","CU","","","0","SAJIB-NASTA");
INSERT INTO tbl_payvoucherde VALUES("1451","0","495","2","LE","290.00","35","SU","","","0","ARIF KHABER");
INSERT INTO tbl_payvoucherde VALUES("1452","0","495","2","LE","34000.00","35","SU","","","0","RAJMISTRI CHAPAI");
INSERT INTO tbl_payvoucherde VALUES("1453","0","495","2","LE","5000.00","35","SU","","","0","RAJMISTRI BKASH");
INSERT INTO tbl_payvoucherde VALUES("1454","0","496","2","LE","22400.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1455","0","496","2","LE","290.00","35","SU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("1456","0","496","2","LE","7800.00","25","CU","","","0","MALEK FUFA RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1457","0","496","2","LE","10000.00","67","CU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1458","0","496","2","LE","1000.00","62","CU","","","0","BISKUT");
INSERT INTO tbl_payvoucherde VALUES("1459","0","496","2","LE","7000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1460","0","497","2","LE","200000.00","2","SU","","","0","GOM");
INSERT INTO tbl_payvoucherde VALUES("1461","0","497","2","LE","200000.00","25","CU","","","0","SAJIB DOKAN ROAD PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1462","0","497","2","LE","2550.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1463","0","497","2","LE","81900.00","35","SU","","","0","IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1464","0","497","2","LE","18100.00","25","CU","","","0","MALEK FUFA IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1465","0","497","2","LE","7000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1466","0","498","2","LE","280.00","35","SU","","","0","NET");
INSERT INTO tbl_payvoucherde VALUES("1467","0","498","2","LE","5000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1468","0","499","2","LE","100000.00","35","SU","","","0","ROD PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1469","0","499","2","LE","100000.00","2","SU","","","0","GOM");
INSERT INTO tbl_payvoucherde VALUES("1470","0","499","2","LE","16500.00","35","SU","","","0","MATI KATA");
INSERT INTO tbl_payvoucherde VALUES("1471","0","499","2","LE","2050.00","35","SU","","","0","ARIFUL");
INSERT INTO tbl_payvoucherde VALUES("1472","0","500","2","LE","36200.00","35","SU","","","0","CEMENT,BALI");
INSERT INTO tbl_payvoucherde VALUES("1473","0","501","2","LE","38040.00","25","CU","","","0","FISH DORA BABOD");
INSERT INTO tbl_payvoucherde VALUES("1474","0","501","2","LE","3750.00","35","SU","","","0","ROD,CUTTING PATHOR");
INSERT INTO tbl_payvoucherde VALUES("1475","0","501","2","LE","300.00","25","CU","","","0","OXEZEN KEY");
INSERT INTO tbl_payvoucherde VALUES("1476","0","501","2","LE","1950.00","25","CU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1477","0","501","2","LE","1560.00","25","CU","","","0","BOROF 3 TI");
INSERT INTO tbl_payvoucherde VALUES("1478","0","501","2","LE","100.00","25","CU","","","0","BOKSISH JAILLA");
INSERT INTO tbl_payvoucherde VALUES("1479","0","501","2","LE","200.00","25","CU","","","0","NASTA FISH DORA");
INSERT INTO tbl_payvoucherde VALUES("1480","0","501","2","LE","30000.00","25","CU","","","0","ARMAN");
INSERT INTO tbl_payvoucherde VALUES("1481","0","501","2","LE","500.00","25","CU","","","0","MALEK FUFA NAJIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1482","0","501","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1483","0","501","2","LE","11000.00","35","SU","","","0","MATI PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1484","0","501","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1485","0","501","2","LE","250000.00","2","LO","","","0","BINOY-18-07-24");
INSERT INTO tbl_payvoucherde VALUES("1486","0","501","2","LE","165000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1487","0","502","2","LE","1000.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1488","0","503","2","LE","110.00","35","SU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("1489","0","504","2","LE","1400.00","35","SU","","","0","LP GAS");
INSERT INTO tbl_payvoucherde VALUES("1490","0","504","2","LE","6650.00","35","SU","","","0","BLET,TERKATA,TERPIN,KARI");
INSERT INTO tbl_payvoucherde VALUES("1491","0","504","2","LE","800.00","35","SU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1492","0","504","2","LE","900.00","35","SU","","","0","HOGLA");
INSERT INTO tbl_payvoucherde VALUES("1493","0","504","2","LE","400.00","35","SU","","","0","VAN VARA");
INSERT INTO tbl_payvoucherde VALUES("1494","0","504","2","LE","950.00","25","CU","","","0","2 TI CHAIR");
INSERT INTO tbl_payvoucherde VALUES("1495","0","504","2","LE","100.00","35","SU","","","0","RONG MISTRI NASTTA");
INSERT INTO tbl_payvoucherde VALUES("1496","0","504","2","LE","6060.00","35","SU","","","0","OARLING ROD");
INSERT INTO tbl_payvoucherde VALUES("1497","0","504","2","LE","5000.00","25","CU","","","0","DOKAN COLL BASANO");
INSERT INTO tbl_payvoucherde VALUES("1498","0","504","2","LE","10000.00","35","SU","","","0","BILLAL BOILER SHOPFITTIN,");
INSERT INTO tbl_payvoucherde VALUES("1499","0","504","2","LE","7800.00","25","CU","","","0","RAJMISTRI MALEK FUFA");
INSERT INTO tbl_payvoucherde VALUES("1500","0","505","2","LE","20000.00","25","CU","","","0","van toiri advance");
INSERT INTO tbl_payvoucherde VALUES("1501","0","505","2","LE","50000.00","25","CU","","","0","RAJMISTRI KAJ BABOD");
INSERT INTO tbl_payvoucherde VALUES("1502","0","505","2","LE","390.00","35","SU","","","0","JARU,FOAM");
INSERT INTO tbl_payvoucherde VALUES("1503","0","505","2","LE","1000.00","35","SU","","","0","HOMBAILE");
INSERT INTO tbl_payvoucherde VALUES("1504","0","505","2","LE","13000.00","25","CU","","","0","PANGASH MAC");
INSERT INTO tbl_payvoucherde VALUES("1505","0","505","2","LE","1359500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1506","0","505","2","LE","30500.00","25","CU","","","0","DOKAN,ROD,ANGLE");
INSERT INTO tbl_payvoucherde VALUES("1507","0","505","2","LE","1950000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1508","0","505","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1509","0","505","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1510","0","506","2","LE","300000.00","7","CU","","","0","ভুল এনটি");
INSERT INTO tbl_payvoucherde VALUES("1511","0","507","2","LE","31300.00","35","SU","","","0","cement,bali");
INSERT INTO tbl_payvoucherde VALUES("1512","0","507","2","LE","100.00","35","SU","","","0","rong mistri");
INSERT INTO tbl_payvoucherde VALUES("1513","0","507","2","LE","37800.00","35","SU","","","0","chain pipe");
INSERT INTO tbl_payvoucherde VALUES("1514","0","507","2","LE","29000.00","35","SU","","","0","chain coppa bearing,hit ");
INSERT INTO tbl_payvoucherde VALUES("1515","0","507","2","LE","300000.00","35","SU","","","0","plain sheet,flanch");
INSERT INTO tbl_payvoucherde VALUES("1516","0","507","2","LE","610.00","35","SU","","","0","khaber");
INSERT INTO tbl_payvoucherde VALUES("1517","0","507","2","LE","800.00","35","SU","","","0","tipu");
INSERT INTO tbl_payvoucherde VALUES("1518","0","507","2","LE","300.00","67","CU","","","0","VARA");
INSERT INTO tbl_payvoucherde VALUES("1519","0","507","2","LE","25300.00","67","CU","","","0","ROD,KAT,NAJIMUDDIN ");
INSERT INTO tbl_payvoucherde VALUES("1520","0","508","2","LE","25300.00","25","CU","","","0","MALEK FUFA,ROD,KAT,SALARY");
INSERT INTO tbl_payvoucherde VALUES("1521","0","509","2","LE","800.00","35","SU","","","0","কাটিং পাথর");
INSERT INTO tbl_payvoucherde VALUES("1522","0","510","2","LE","200.00","35","SU","","","0","রং মিস্ত্রি নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("1523","0","510","2","LE","3350.00","35","SU","","","0","নাট");
INSERT INTO tbl_payvoucherde VALUES("1524","0","511","2","LE","600000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1525","0","511","2","LE","1400.00","35","SU","","","0","hira transport");
INSERT INTO tbl_payvoucherde VALUES("1526","0","511","2","LE","10000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1527","0","512","2","LE","520.00","35","SU","","","0","কেরোসিন");
INSERT INTO tbl_payvoucherde VALUES("1528","0","512","2","LE","32000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1529","0","512","2","LE","520000.00","35","SU","","","0","মালামাল ক্রয় বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1530","0","512","2","LE","900.00","35","SU","","","0","চেইন কাপ্পার কুরিয়ার");
INSERT INTO tbl_payvoucherde VALUES("1531","0","512","2","LE","150.00","35","SU","","","0","ভাড়া বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1532","0","512","2","LE","200.00","35","SU","","","0","রং মিস্ত্রি নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("1533","0","512","2","LE","620.00","62","CU","","","0","মেগনেট");
INSERT INTO tbl_payvoucherde VALUES("1534","0","513","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1535","0","513","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1536","0","513","2","LE","1200.00","35","SU","","","0","LAP,TOSOK");
INSERT INTO tbl_payvoucherde VALUES("1537","0","513","2","LE","10000.00","35","SU","","","0","CHOWDURY ENTERPRISE");
INSERT INTO tbl_payvoucherde VALUES("1538","0","513","2","LE","1000.00","35","SU","","","0","ANGLE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1539","0","513","2","LE","2000.00","25","CU","","","0","DOKAN");
INSERT INTO tbl_payvoucherde VALUES("1540","0","513","2","LE","830.00","25","CU","","","0","TALA CIKOL");
INSERT INTO tbl_payvoucherde VALUES("1541","0","513","2","LE","2680.00","35","SU","","","0","TIPU MISTRI MEDECINE");
INSERT INTO tbl_payvoucherde VALUES("1542","0","513","2","LE","106000.00","4","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1543","0","513","2","LE","2650.00","35","SU","","","0","NAT,CHAINE BIT");
INSERT INTO tbl_payvoucherde VALUES("1544","0","513","2","LE","30000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1545","0","513","2","LE","800.00","35","SU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1546","0","513","2","LE","1685.00","35","SU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("1547","0","513","2","LE","17945.00","25","CU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("1548","0","513","2","LE","20000.00","25","CU","","","0","VAN MERAMAT");
INSERT INTO tbl_payvoucherde VALUES("1550","0","515","2","LE","1000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("1551","0","515","2","LE","30000.00","35","SU","","","0","JULHAS");
INSERT INTO tbl_payvoucherde VALUES("1552","0","515","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1553","0","515","2","LE","714206.50","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1554","0","515","2","LE","80000.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1555","0","515","2","LE","11000.00","64","CU","","","0","OHIDUL");
INSERT INTO tbl_payvoucherde VALUES("1556","0","515","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1557","0","515","2","LE","10780.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1558","0","515","2","LE","300000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1559","0","515","2","LE","609000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1560","0","515","2","LE","1500000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1561","0","515","2","LE","3000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1562","0","515","2","LE","140.00","35","SU","","","0","VARA RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1563","0","516","2","LE","150.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1564","0","517","2","LE","1000.00","25","CU","","","0","ASIK KABER");
INSERT INTO tbl_payvoucherde VALUES("1565","0","517","2","LE","16500.00","35","SU","","","0","BOILER MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1566","0","517","2","LE","21000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1567","0","517","2","LE","43200.00","35","SU","","","0","RAJSHAHI RAJMISTRI ");
INSERT INTO tbl_payvoucherde VALUES("1568","0","517","2","LE","3600.00","35","SU","","","0","RAJMISTRI ARIF");
INSERT INTO tbl_payvoucherde VALUES("1569","0","517","2","LE","7000.00","35","SU","","","0","RAJMISTRI KOLCHORI");
INSERT INTO tbl_payvoucherde VALUES("1570","0","518","2","LE","1400.00","35","SU","","","0","gas");
INSERT INTO tbl_payvoucherde VALUES("1571","0","518","2","LE","14700.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1572","0","518","2","LE","7400.00","115","CU","","","0","OIL,MOBIL LEABOUR");
INSERT INTO tbl_payvoucherde VALUES("1573","0","518","2","LE","7800.00","35","SU","","","0","FAN");
INSERT INTO tbl_payvoucherde VALUES("1574","0","518","2","LE","1200.00","35","SU","","","0","BALP");
INSERT INTO tbl_payvoucherde VALUES("1575","0","518","2","LE","700.00","35","SU","","","0","ADPTER");
INSERT INTO tbl_payvoucherde VALUES("1576","0","518","2","LE","7800.00","25","CU","","","0","MALEK FUFA RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1577","0","518","2","LE","4000.00","25","CU","","","0","ADIL SALARY");
INSERT INTO tbl_payvoucherde VALUES("1578","0","518","2","LE","3050.00","25","CU","","","0","PRIVATE CAR GAS");
INSERT INTO tbl_payvoucherde VALUES("1579","0","519","2","LE","25000.00","122","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1580","0","520","2","LE","1600.00","35","SU","","","0","GASAR PATHOR");
INSERT INTO tbl_payvoucherde VALUES("1581","0","520","2","LE","520.00","35","SU","","","0","JUT,SIRIJ PAPER");
INSERT INTO tbl_payvoucherde VALUES("1582","0","520","2","LE","600000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1583","0","520","2","LE","1100000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1584","0","520","2","LE","782000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1585","0","520","2","LE","1350.00","25","CU","","","0","VAN TOYRI");
INSERT INTO tbl_payvoucherde VALUES("1586","0","521","2","LE","270000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1587","0","522","2","LE","7000.00","25","CU","","","0","BASA KAKI");
INSERT INTO tbl_payvoucherde VALUES("1588","0","522","2","LE","50.00","67","CU","","","0","MITER SIT");
INSERT INTO tbl_payvoucherde VALUES("1589","0","522","2","LE","80.00","25","CU","","","0","SIT");
INSERT INTO tbl_payvoucherde VALUES("1590","0","522","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1591","0","523","2","LE","900.00","25","CU","","","0","GASS CUTER MACHINE");
INSERT INTO tbl_payvoucherde VALUES("1592","0","523","2","LE","4300.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1593","0","524","2","LE","23800.00","35","SU","","","0","RONG,BRASH,ROLLER");
INSERT INTO tbl_payvoucherde VALUES("1594","0","524","2","LE","50000.00","35","SU","","","0","TIPU ");
INSERT INTO tbl_payvoucherde VALUES("1595","0","524","2","LE","18600.00","25","CU","","","0","MALEK FUFA JOYGA");
INSERT INTO tbl_payvoucherde VALUES("1596","0","525","2","LE","50448.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1597","0","526","2","LE","4900.00","91","CU","","","0","IT BANGHA");
INSERT INTO tbl_payvoucherde VALUES("1598","0","527","2","LE","530000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1599","0","527","2","LE","200000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1600","0","528","2","LE","150.00","35","SU","","","0","RONG NASTA");
INSERT INTO tbl_payvoucherde VALUES("1601","0","529","2","LE","13710.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1602","0","529","2","LE","3450.00","35","SU","","","0","BEARING,NUT");
INSERT INTO tbl_payvoucherde VALUES("1603","0","530","2","LE","350000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1604","0","530","2","LE","3500.00","111","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1605","0","530","2","LE","100.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1606","0","530","2","LE","545.00","91","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1607","0","530","2","LE","400000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1608","0","531","2","LE","8900.00","35","SU","","","0","বিয়ারিং ওয়ারিং রড");
INSERT INTO tbl_payvoucherde VALUES("1609","0","531","2","LE","3460.00","35","SU","","","0","কাটিং পাথর ফোম");
INSERT INTO tbl_payvoucherde VALUES("1610","0","531","2","LE","200.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1611","0","531","2","LE","500000.00","1","LO","","","0","আরমান");
INSERT INTO tbl_payvoucherde VALUES("1612","0","532","2","LE","2750000.00","31","SU","","","0","পূবালী ব্যাংকে");
INSERT INTO tbl_payvoucherde VALUES("1613","0","533","2","LE","2750000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1614","0","533","2","LE","200000.00","91","CU","","","0","SAJIB BHAI");
INSERT INTO tbl_payvoucherde VALUES("1615","0","533","2","LE","7200.00","25","CU","","","0","IBRAHIM MALEK FUFA");
INSERT INTO tbl_payvoucherde VALUES("1616","0","533","2","LE","13500.00","25","CU","","","0","HRIDOY");
INSERT INTO tbl_payvoucherde VALUES("1617","0","533","2","LE","10000.00","25","CU","","","0","RUBEL ");
INSERT INTO tbl_payvoucherde VALUES("1618","0","533","2","LE","1700.00","91","CU","","","0","PIPE");
INSERT INTO tbl_payvoucherde VALUES("1619","0","533","2","LE","14200.00","25","CU","","","0","SUMERSIBLE CLAM,BALB");
INSERT INTO tbl_payvoucherde VALUES("1620","0","533","2","LE","14300.00","35","SU","","","0","OFFICE RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1621","0","534","2","LE","50000.00","35","SU","","","0","cement");
INSERT INTO tbl_payvoucherde VALUES("1622","0","534","2","LE","350000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1623","0","534","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1624","0","535","2","LE","2000.00","25","CU","","","0","malek fufa khaber");
INSERT INTO tbl_payvoucherde VALUES("1625","0","536","2","LE","4600.00","91","CU","","","0","BALI,CEMENT");
INSERT INTO tbl_payvoucherde VALUES("1626","0","536","2","LE","2800.00","91","CU","","","0","BALI");
INSERT INTO tbl_payvoucherde VALUES("1627","0","536","2","LE","79800.00","35","SU","","","0","BALI,CEMENT");
INSERT INTO tbl_payvoucherde VALUES("1628","0","536","2","LE","700000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1629","0","536","2","LE","147500.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1630","0","537","2","LE","17600.00","35","SU","","","0","BOILER MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1631","0","537","2","LE","23000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1632","0","537","2","LE","170.00","91","CU","","","0","VARA,ASIK");
INSERT INTO tbl_payvoucherde VALUES("1633","0","538","2","LE","46000.00","35","SU","","","0","RAJMISTRI CHAPAI");
INSERT INTO tbl_payvoucherde VALUES("1634","0","539","2","LE","2900.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1635","0","539","2","LE","10000.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1636","0","539","2","LE","1200.00","91","CU","","","0","HELPER");
INSERT INTO tbl_payvoucherde VALUES("1637","0","540","2","LE","7000.00","6","CU","","","0","FISH PURCHESE");
INSERT INTO tbl_payvoucherde VALUES("1638","0","541","2","LE","6000.00","35","SU","","","0","SAMIM LED");
INSERT INTO tbl_payvoucherde VALUES("1639","0","541","2","LE","1200.00","25","CU","","","0","PIPE PES KATA");
INSERT INTO tbl_payvoucherde VALUES("1640","0","541","2","LE","1500.00","67","CU","","","0","GASS CUTTING MERAMAT");
INSERT INTO tbl_payvoucherde VALUES("1641","0","541","2","LE","299.00","35","SU","","","0","INTERNET");
INSERT INTO tbl_payvoucherde VALUES("1642","0","541","2","LE","12550.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1643","0","541","2","LE","400.00","25","CU","","","0","CHALNI");
INSERT INTO tbl_payvoucherde VALUES("1644","0","541","2","LE","150.00","35","SU","","","0","RONG MISTRI NASTA");
INSERT INTO tbl_payvoucherde VALUES("1645","0","541","2","LE","10000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1646","0","541","2","LE","1000.00","25","CU","","","0","KHICURI");
INSERT INTO tbl_payvoucherde VALUES("1647","0","541","2","LE","3900.00","25","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1648","0","541","2","LE","80250.00","91","CU","","","0","IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1649","0","541","2","LE","107000.00","35","SU","","","0","IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1650","0","541","2","LE","800.00","25","CU","","","0","MURGI");
INSERT INTO tbl_payvoucherde VALUES("1651","0","541","2","LE","1000.00","25","CU","","","0","KAKI");
INSERT INTO tbl_payvoucherde VALUES("1652","0","542","2","LE","12150.00","25","CU","","","0","VAN TOYRI");
INSERT INTO tbl_payvoucherde VALUES("1653","0","543","2","LE","23280.00","115","CU","","","0","PONA FISH KHABER");
INSERT INTO tbl_payvoucherde VALUES("1654","0","544","2","LE","15100.00","115","CU","","","0","QUALITY FEED");
INSERT INTO tbl_payvoucherde VALUES("1655","0","545","2","LE","3510.00","115","CU","","","0","MACHINER OIL + KAJ");
INSERT INTO tbl_payvoucherde VALUES("1656","0","546","2","LE","1600000.00","31","SU","","","0","PUBALI");
INSERT INTO tbl_payvoucherde VALUES("1657","0","546","2","LE","1400000.00","31","SU","","","0","NBL");
INSERT INTO tbl_payvoucherde VALUES("1658","0","546","2","LE","1100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1659","0","546","2","LE","10000.00","25","CU","","","0","PAVEL");
INSERT INTO tbl_payvoucherde VALUES("1660","0","546","2","LE","25000.00","25","CU","","","0","PABEL");
INSERT INTO tbl_payvoucherde VALUES("1661","0","546","2","LE","500.00","25","CU","","","0","RAOUTER MALEK FUFA");
INSERT INTO tbl_payvoucherde VALUES("1662","0","546","2","LE","200.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1663","0","546","2","LE","180.00","35","SU","","","0","MARKER PEN");
INSERT INTO tbl_payvoucherde VALUES("1664","0","546","2","LE","11970.00","35","SU","","","0","ROD,KODAL,ROSI");
INSERT INTO tbl_payvoucherde VALUES("1665","0","547","2","LE","216000.00","1","LO","","","0","arman");
INSERT INTO tbl_payvoucherde VALUES("1666","0","548","2","LE","670.00","35","SU","","","0","print");
INSERT INTO tbl_payvoucherde VALUES("1667","0","549","2","LE","600000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1668","0","549","2","LE","290000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1669","0","549","2","LE","2700000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1670","0","549","2","LE","54000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1671","0","549","2","LE","150.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1672","0","550","2","LE","1000.00","25","CU","","","0","খাবার মালেক ফুপার জায়গা");
INSERT INTO tbl_payvoucherde VALUES("1673","0","550","2","LE","5030.00","35","SU","","","0","গুনা +তার কাটা");
INSERT INTO tbl_payvoucherde VALUES("1674","0","550","2","LE","430.00","35","SU","","","0","ভাড়া+নাস্তা +চক");
INSERT INTO tbl_payvoucherde VALUES("1675","0","551","2","LE","600.00","62","CU","","","0","ফিউজ লাগানো বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1676","0","552","2","LE","40000.00","35","SU","","","0","it purchase");
INSERT INTO tbl_payvoucherde VALUES("1677","0","552","2","LE","37000.00","116","CU","","","0","liz,fish");
INSERT INTO tbl_payvoucherde VALUES("1678","0","552","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1679","0","552","2","LE","800.00","35","SU","","","0","oxizen");
INSERT INTO tbl_payvoucherde VALUES("1680","0","552","2","LE","150.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1681","0","553","2","LE","30000.00","25","CU","","","0","NIZ");
INSERT INTO tbl_payvoucherde VALUES("1682","0","554","2","LE","9680.00","19","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1683","0","554","2","LE","9675.00","3","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1684","0","554","2","LE","50000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1685","0","554","2","LE","19350.00","13","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1686","0","554","2","LE","19350.00","39","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1687","0","554","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1688","0","554","2","LE","17700.00","25","CU","","","0","SADDAM,KHAIUM,SOYOD");
INSERT INTO tbl_payvoucherde VALUES("1689","0","554","2","LE","8900.00","19","SU","","","0","13-2471");
INSERT INTO tbl_payvoucherde VALUES("1690","0","555","2","LE","5000.00","115","CU","","","0","JALLAI FISH BABOD");
INSERT INTO tbl_payvoucherde VALUES("1691","0","555","2","LE","1500.00","91","CU","","","0","MITER RECHERGE");
INSERT INTO tbl_payvoucherde VALUES("1692","0","556","2","LE","49100.00","25","CU","","","0","niz");
INSERT INTO tbl_payvoucherde VALUES("1693","0","557","2","LE","7500.00","35","SU","","","0","নাট");
INSERT INTO tbl_payvoucherde VALUES("1694","0","557","2","LE","40.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1695","0","557","2","LE","7500.00","35","SU","","","0","নাট");
INSERT INTO tbl_payvoucherde VALUES("1696","0","558","2","LE","6250.00","35","SU","","","0","কাটিং পাথর ওয়রিং রড");
INSERT INTO tbl_payvoucherde VALUES("1697","0","559","2","LE","1300.00","64","CU","","","0","অক্রিজেন");
INSERT INTO tbl_payvoucherde VALUES("1698","0","560","2","LE","200.00","35","SU","","","0","BAMBOO");
INSERT INTO tbl_payvoucherde VALUES("1699","0","560","2","LE","900000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1700","0","560","2","LE","200.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1701","0","560","2","LE","5800.00","67","CU","","","0","COEL PIPE");
INSERT INTO tbl_payvoucherde VALUES("1702","0","560","2","LE","2870.00","25","CU","","","0","EYAM");
INSERT INTO tbl_payvoucherde VALUES("1703","0","560","2","LE","170.00","91","CU","","","0","FITTING");
INSERT INTO tbl_payvoucherde VALUES("1704","0","560","2","LE","420.00","35","SU","","","0","CLAM,MARKIN TAPE");
INSERT INTO tbl_payvoucherde VALUES("1705","0","560","2","LE","150.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1706","0","560","2","LE","237150.00","1","LO","","","0","RUBEL");
INSERT INTO tbl_payvoucherde VALUES("1707","0","561","2","LE","14800.00","26","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1708","0","562","2","LE","44450.00","89","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1709","0","563","2","LE","1060.00","35","SU","","","0","তারকাটা +নাট");
INSERT INTO tbl_payvoucherde VALUES("1710","0","563","2","LE","3800.00","62","CU","","","0","গ্রিজ");
INSERT INTO tbl_payvoucherde VALUES("1711","0","563","2","LE","500000.00","1","LO","","","0","juel");
INSERT INTO tbl_payvoucherde VALUES("1712","0","564","2","LE","5800.00","35","SU","","","0","পুলির ঘাট কাটা");
INSERT INTO tbl_payvoucherde VALUES("1713","0","564","2","LE","150.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("1714","0","565","2","LE","1800.00","67","CU","","","0","KHABER,OTHER KAJ");
INSERT INTO tbl_payvoucherde VALUES("1715","0","565","2","LE","7000.00","67","CU","","","0","PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1716","0","565","2","LE","15950.00","35","SU","","","0","RAJMISTRI OFFICE");
INSERT INTO tbl_payvoucherde VALUES("1717","0","565","2","LE","384000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1718","0","565","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1719","0","565","2","LE","900000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1720","0","566","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1721","0","567","2","LE","5000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1722","0","568","2","LE","24500.00","35","SU","","","0","tipu mistri");
INSERT INTO tbl_payvoucherde VALUES("1723","0","568","2","LE","17500.00","91","CU","","","0","balu");
INSERT INTO tbl_payvoucherde VALUES("1724","0","568","2","LE","19250.00","35","SU","","","0","boyler mistri");
INSERT INTO tbl_payvoucherde VALUES("1725","0","568","2","LE","50000.00","35","SU","","","0","rajmistri chapai");
INSERT INTO tbl_payvoucherde VALUES("1726","0","569","2","LE","500.00","35","SU","","","0","NAYEEM");
INSERT INTO tbl_payvoucherde VALUES("1727","0","570","2","LE","1950.00","35","SU","","","0","40SI+VARA");
INSERT INTO tbl_payvoucherde VALUES("1728","0","570","2","LE","3600.00","35","SU","","","0","ARIF");
INSERT INTO tbl_payvoucherde VALUES("1729","0","570","2","LE","23100.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1730","0","570","2","LE","3500.00","62","CU","","","0","WATER CONTROLLER");
INSERT INTO tbl_payvoucherde VALUES("1731","0","571","2","LE","16100.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1732","0","571","2","LE","1500.00","64","CU","","","0","OXIZEN");
INSERT INTO tbl_payvoucherde VALUES("1733","0","572","2","LE","14200.00","67","CU","","","0","sumersible pump clcm,suij");
INSERT INTO tbl_payvoucherde VALUES("1734","0","573","2","LE","1690.00","67","CU","","","0","khucra malalmal");
INSERT INTO tbl_payvoucherde VALUES("1735","0","574","2","LE","1690.00","67","CU","","","0","আসিক");
INSERT INTO tbl_payvoucherde VALUES("1736","0","574","2","LE","160.00","67","CU","","","0","আসিক খাবার");
INSERT INTO tbl_payvoucherde VALUES("1737","0","574","2","LE","150.00","35","SU","","","0","রং মিস্ত্রি নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("1738","0","574","2","LE","1000.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1739","0","575","2","LE","500.00","35","SU","","","0","nasta");
INSERT INTO tbl_payvoucherde VALUES("1740","0","576","2","LE","10000.00","35","SU","","","0","rod");
INSERT INTO tbl_payvoucherde VALUES("1741","0","576","2","LE","2800.00","91","CU","","","0","bali");
INSERT INTO tbl_payvoucherde VALUES("1742","0","576","2","LE","50500.00","35","SU","","","0","cement,bali");
INSERT INTO tbl_payvoucherde VALUES("1743","0","577","2","LE","700.00","64","CU","","","0","মাছ ধরা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1744","0","577","2","LE","400.00","64","CU","","","0","নাস্তা হাসান");
INSERT INTO tbl_payvoucherde VALUES("1745","0","577","2","LE","11000.00","89","LE","","","0","স্টাফ খরচ");
INSERT INTO tbl_payvoucherde VALUES("1746","0","577","2","LE","8000.00","89","LE","","","0","T C F");
INSERT INTO tbl_payvoucherde VALUES("1747","0","577","2","LE","27000.00","89","LE","","","0","ডিলার ব্যালেন্স");
INSERT INTO tbl_payvoucherde VALUES("1748","0","578","2","LE","1000000.00","1","LO","","","0","জুয়েল");
INSERT INTO tbl_payvoucherde VALUES("1749","0","578","2","LE","160000.00","3","LO","","","0","মন্তোষ");
INSERT INTO tbl_payvoucherde VALUES("1750","0","579","2","LE","4000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1751","0","579","2","LE","210000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1752","0","579","2","LE","3350000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1753","0","579","2","LE","527000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1754","0","579","2","LE","1320000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1755","0","579","2","LE","50000.00","91","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1756","0","579","2","LE","50000.00","35","SU","","","0","CEMENT");
INSERT INTO tbl_payvoucherde VALUES("1757","0","579","2","LE","4000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1758","0","579","2","LE","2050.00","25","CU","","","0","KHABER NAZIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1759","0","579","2","LE","1450.00","25","CU","","","0","MALEK FUFA GAS");
INSERT INTO tbl_payvoucherde VALUES("1760","0","580","2","LE","8495.00","35","SU","","","0","PULI");
INSERT INTO tbl_payvoucherde VALUES("1761","0","581","2","LE","50000.00","35","SU","","","0","ROD PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1777","0","583","2","LE","36000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1778","0","583","2","LE","355500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1779","0","583","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1780","0","583","2","LE","400.00","67","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1781","0","584","2","LE","150000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1782","0","584","2","LE","450000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1783","0","584","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1784","0","584","2","LE","202500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1785","0","584","2","LE","400.00","25","CU","","","0","MALEK FUFA NAJIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1786","0","584","2","LE","1000.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1795","0","586","2","LE","1300.00","64","CU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1796","0","587","2","LE","1830.00","35","SU","","","0","nayeem");
INSERT INTO tbl_payvoucherde VALUES("1797","0","587","2","LE","4500.00","35","SU","","","0","RASED");
INSERT INTO tbl_payvoucherde VALUES("1798","0","587","2","LE","500.00","67","CU","","","0","ASIK");
INSERT INTO tbl_payvoucherde VALUES("1799","0","587","2","LE","5520.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1800","0","588","2","LE","650655.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1801","0","588","2","LE","335000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1802","0","588","2","LE","1500.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1803","0","589","2","LE","150000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1804","0","590","2","LE","500000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1805","0","590","2","LE","3310.00","62","CU","","","0","BOYLER NOBAYON");
INSERT INTO tbl_payvoucherde VALUES("1806","0","590","2","LE","200.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1807","0","591","2","LE","200000.00","25","CU","","","0","ANOWER SUBOCHUNI");
INSERT INTO tbl_payvoucherde VALUES("1808","0","591","2","LE","9000.00","67","CU","","","0","TER,CABLE,PIPE-BAKUL");
INSERT INTO tbl_payvoucherde VALUES("1809","0","591","2","LE","52000.00","91","CU","","","0","CEMENT-100 BAG");
INSERT INTO tbl_payvoucherde VALUES("1810","0","591","2","LE","200.00","67","CU","","","0","HERA TRASNPORT");
INSERT INTO tbl_payvoucherde VALUES("1811","0","591","2","LE","4080.00","25","CU","","","0","KAKI. BASA");
INSERT INTO tbl_payvoucherde VALUES("1812","0","591","2","LE","500000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1813","0","591","2","LE","3775.00","35","SU","","","0","OWARLING ROD");
INSERT INTO tbl_payvoucherde VALUES("1814","0","591","2","LE","4205.00","62","CU","","","0","BEARING,MAGNATE");
INSERT INTO tbl_payvoucherde VALUES("1815","0","592","2","LE","5000.00","67","CU","","","0","ASIK");
INSERT INTO tbl_payvoucherde VALUES("1816","0","592","2","LE","850000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1817","0","592","2","LE","320.00","25","CU","","","0","MALEK FUFA-NASTA");
INSERT INTO tbl_payvoucherde VALUES("1818","0","593","2","LE","850000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1819","0","593","2","LE","5000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("1820","0","593","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1821","0","593","2","LE","100000.00","35","SU","","","0","NIPA STEEL");
INSERT INTO tbl_payvoucherde VALUES("1822","0","593","2","LE","100000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1823","0","593","2","LE","630758.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1824","0","593","2","LE","300000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1825","0","593","2","LE","300000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1826","0","593","2","LE","56800.00","35","SU","","","0","ROD");
INSERT INTO tbl_payvoucherde VALUES("1827","0","593","2","LE","200000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1828","0","593","2","LE","15200.00","35","SU","","","0","RONG ");
INSERT INTO tbl_payvoucherde VALUES("1829","0","594","2","LE","7500.00","35","SU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("1830","0","594","2","LE","2550.00","115","CU","","","0","chun");
INSERT INTO tbl_payvoucherde VALUES("1831","0","594","2","LE","10200.00","25","CU","","","0","CHUN");
INSERT INTO tbl_payvoucherde VALUES("1832","0","594","2","LE","10000.00","35","SU","","","0","MOTOR BURNISH");
INSERT INTO tbl_payvoucherde VALUES("1833","0","595","2","LE","500.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("1834","0","596","2","LE","850000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1835","0","596","2","LE","320.00","25","CU","","","0","MALEK FUFA NASTA");
INSERT INTO tbl_payvoucherde VALUES("1836","0","597","2","LE","28000.00","35","SU","","","0","TIPU");
INSERT INTO tbl_payvoucherde VALUES("1837","0","597","2","LE","19250.00","35","SU","","","0","BILLAL MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1838","0","597","2","LE","38800.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1839","0","597","2","LE","8800.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1840","0","598","2","LE","300.00","35","SU","","","0","VAN VARA");
INSERT INTO tbl_payvoucherde VALUES("1841","0","598","2","LE","5300.00","35","SU","","","0","OAELING ROD");
INSERT INTO tbl_payvoucherde VALUES("1842","0","598","2","LE","400.00","35","SU","","","0","AJ R TRANSPORT");
INSERT INTO tbl_payvoucherde VALUES("1843","0","598","2","LE","300.00","35","SU","","","0","STEEL TERKATA");
INSERT INTO tbl_payvoucherde VALUES("1844","0","598","2","LE","2600.00","35","SU","","","0","CUTTING DISH");
INSERT INTO tbl_payvoucherde VALUES("1845","0","598","2","LE","400.00","35","SU","","","0","CUTTING PATHOR");
INSERT INTO tbl_payvoucherde VALUES("1846","0","598","2","LE","2400.00","25","CU","","","0","MALEK FUFA,NAJIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1847","0","598","2","LE","9000.00","25","CU","","","0","ENGINERING BILL");
INSERT INTO tbl_payvoucherde VALUES("1848","0","598","2","LE","10000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1849","0","599","2","LE","150000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1850","0","599","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1851","0","599","2","LE","75950.00","35","SU","","","0","rod,curi");
INSERT INTO tbl_payvoucherde VALUES("1852","0","599","2","LE","250000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1853","0","599","2","LE","1500000.00","35","SU","","","0","nipa steel");
INSERT INTO tbl_payvoucherde VALUES("1854","0","599","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1855","0","600","2","LE","5000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1856","0","600","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1857","0","601","2","LE","200000.00","6","CU","","","0","ভুল সংশোধন সজিব");
INSERT INTO tbl_payvoucherde VALUES("1858","0","602","2","LE","8000.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1859","0","602","2","LE","200000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1860","0","602","2","LE","1935000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1861","0","603","2","LE","80000.00","6","CU","","","0","FISH");
INSERT INTO tbl_payvoucherde VALUES("1862","0","604","2","LE","24000.00","35","SU","","","0","MALAMAL,KHABER,VARA");
INSERT INTO tbl_payvoucherde VALUES("1863","0","604","2","LE","70000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1864","0","604","2","LE","9760.00","35","SU","","","0","MONIR TRUCK EXP");
INSERT INTO tbl_payvoucherde VALUES("1865","0","604","2","LE","1010.00","67","CU","","","0","SO BILL");
INSERT INTO tbl_payvoucherde VALUES("1866","0","604","2","LE","820.00","67","CU","","","0","KHABAR");
INSERT INTO tbl_payvoucherde VALUES("1867","0","604","2","LE","9485.00","64","CU","","","0","CURRENT BILL");
INSERT INTO tbl_payvoucherde VALUES("1868","0","605","2","LE","60000.00","35","SU","","","0","malamal purchase");
INSERT INTO tbl_payvoucherde VALUES("1869","0","606","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1870","0","606","2","LE","2000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1871","0","607","2","LE","22000.00","67","CU","","","0","VOLTAGE REGULATOR");
INSERT INTO tbl_payvoucherde VALUES("1872","0","607","2","LE","760000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1873","0","607","2","LE","238000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1874","0","607","2","LE","2000000.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1875","0","608","2","LE","1600.00","25","CU","","","0","CURRENT BILL");
INSERT INTO tbl_payvoucherde VALUES("1876","0","608","2","LE","1000.00","25","CU","","","0","TANKI CLEAN,JARU");
INSERT INTO tbl_payvoucherde VALUES("1877","0","608","2","LE","1000.00","25","CU","","","0","MALEK FUFA NAZIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1878","0","608","2","LE","150000.00","25","CU","","","0","MONIR MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1879","0","608","2","LE","1510.00","35","SU","","","0","NUT");
INSERT INTO tbl_payvoucherde VALUES("1880","0","609","2","LE","1560000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1881","0","609","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1882","0","609","2","LE","390.00","67","CU","","","0","ইন্জিনিয়ার খাবার");
INSERT INTO tbl_payvoucherde VALUES("1883","0","610","2","LE","1800.00","35","SU","","","0","অনাপত্তি পত্র্র");
INSERT INTO tbl_payvoucherde VALUES("1884","0","611","2","LE","935000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1885","0","611","2","LE","500.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1886","0","611","2","LE","292500.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1887","0","612","2","LE","11000.00","35","SU","","","0","MATI KATA");
INSERT INTO tbl_payvoucherde VALUES("1888","0","612","2","LE","200.00","35","SU","","","0","SALARY NAYEEM");
INSERT INTO tbl_payvoucherde VALUES("1889","0","612","2","LE","1000.00","35","SU","","","0","TERKATA,BRUSH,JUTE");
INSERT INTO tbl_payvoucherde VALUES("1890","0","612","2","LE","105800.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1891","0","613","2","LE","330000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1892","0","614","2","LE","20100.00","62","CU","","","0","KHOIL");
INSERT INTO tbl_payvoucherde VALUES("1893","0","614","2","LE","800.00","35","SU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1894","0","614","2","LE","2000000.00","25","CU","","","0","MALEK  FUFA ");
INSERT INTO tbl_payvoucherde VALUES("1895","0","614","2","LE","1000000.00","35","SU","","","0","BLACK SUTER");
INSERT INTO tbl_payvoucherde VALUES("1896","0","614","2","LE","228000.00","91","CU","","","0","SAJIB DOKAN");
INSERT INTO tbl_payvoucherde VALUES("1897","0","614","2","LE","20321.00","35","SU","","","0","CURRENT BILL");
INSERT INTO tbl_payvoucherde VALUES("1898","0","614","2","LE","37894.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1899","0","614","2","LE","500000.00","1","LO","","","0","JUEL");
INSERT INTO tbl_payvoucherde VALUES("1900","0","614","2","LE","139390.00","67","CU","","","0","MOTOR");
INSERT INTO tbl_payvoucherde VALUES("1901","0","614","2","LE","800.00","35","SU","","","0","OXEZEN");
INSERT INTO tbl_payvoucherde VALUES("1902","0","614","2","LE","20100.00","62","CU","","","0","KHOIL");
INSERT INTO tbl_payvoucherde VALUES("1903","0","615","2","LE","433300.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1904","0","615","2","LE","2000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1905","0","616","2","LE","355000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1906","0","617","2","LE","20100.00","6","CU","","","0","WRONG ENTRY");
INSERT INTO tbl_payvoucherde VALUES("1907","0","618","2","LE","5000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1908","0","619","2","LE","5000.00","35","SU","","","0","RAJMISTRI KOLCURI");
INSERT INTO tbl_payvoucherde VALUES("1909","0","619","2","LE","3400.00","35","SU","","","0","RAJMISTRI ARIF");
INSERT INTO tbl_payvoucherde VALUES("1910","0","619","2","LE","15400.00","35","SU","","","0","RAJMISTRI OFFICE");
INSERT INTO tbl_payvoucherde VALUES("1911","0","619","2","LE","500.00","25","CU","","","0","BASAR ELECTRONIC BAKUL");
INSERT INTO tbl_payvoucherde VALUES("1912","0","619","2","LE","3000.00","62","CU","","","0","MOTOR BEARING+OTHER EXP");
INSERT INTO tbl_payvoucherde VALUES("1913","0","619","2","LE","41600.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1914","0","620","2","LE","400000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1915","0","620","2","LE","355000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1916","0","621","2","LE","18150.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("1917","0","622","2","LE","7900.00","91","CU","","","0","ANGLE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1918","0","623","2","LE","1000.00","25","CU","","","0","NAJIMUDDIN");
INSERT INTO tbl_payvoucherde VALUES("1919","0","624","2","LE","2000.00","25","CU","","","0","VAN ER CONTROLER");
INSERT INTO tbl_payvoucherde VALUES("1920","0","624","2","LE","20000.00","25","CU","","","0","CONSILOR EMU");
INSERT INTO tbl_payvoucherde VALUES("1921","0","625","2","LE","650.00","25","CU","","","0","OXIZEN");
INSERT INTO tbl_payvoucherde VALUES("1922","0","626","2","LE","10000.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("1923","0","627","2","LE","25000.00","25","CU","","","0","BKASH");
INSERT INTO tbl_payvoucherde VALUES("1924","0","627","2","LE","10000.00","25","CU","","","0","BKASH");
INSERT INTO tbl_payvoucherde VALUES("1925","0","627","2","LE","18000.00","25","CU","","","0","BKASH");
INSERT INTO tbl_payvoucherde VALUES("1926","0","628","2","LE","10000.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("1927","0","629","2","LE","500.00","25","CU","","","0","KAKI");
INSERT INTO tbl_payvoucherde VALUES("1928","0","630","2","LE","9000.00","67","CU","","","0","ENGINERING BILL");
INSERT INTO tbl_payvoucherde VALUES("1929","0","631","2","LE","21450.00","91","CU","","","0","RAJMISTRI-39 JON");
INSERT INTO tbl_payvoucherde VALUES("1930","0","631","2","LE","1120.00","62","CU","","","0","OVERTIME");
INSERT INTO tbl_payvoucherde VALUES("1931","0","631","2","LE","37800.00","35","SU","","","0","RAJMISTRI CHAPAI");
INSERT INTO tbl_payvoucherde VALUES("1932","0","631","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1933","0","631","2","LE","20000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1934","0","631","2","LE","10000.00","67","CU","","","0","SO");
INSERT INTO tbl_payvoucherde VALUES("1935","0","631","2","LE","300000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1936","0","631","2","LE","37200.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1937","0","631","2","LE","28000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1938","0","631","2","LE","19250.00","35","SU","","","0","BOILER MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1939","0","631","2","LE","5000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("1940","0","632","2","LE","70.00","91","CU","","","0","VARA+NASTA");
INSERT INTO tbl_payvoucherde VALUES("1941","0","632","2","LE","400.00","91","CU","","","0","LIGHT");
INSERT INTO tbl_payvoucherde VALUES("1942","0","633","2","LE","2500.00","25","CU","","","0","malek fufa -najimuddin kh");
INSERT INTO tbl_payvoucherde VALUES("1943","0","634","2","LE","20000.00","25","CU","","","0","NAJIMUDDIN SALARY");
INSERT INTO tbl_payvoucherde VALUES("1944","0","635","2","LE","1300.00","25","CU","","","0","MALEK-2 JON MOJURI");
INSERT INTO tbl_payvoucherde VALUES("1945","0","636","2","LE","20000.00","25","CU","","","0","গোপাল");
INSERT INTO tbl_payvoucherde VALUES("1946","0","636","2","LE","24000.00","91","CU","","","0","সুরকি লিয়াকত");
INSERT INTO tbl_payvoucherde VALUES("1947","0","636","2","LE","9170.00","35","SU","","","0","পলি,কাটিংপাথর,তারকাটা,");
INSERT INTO tbl_payvoucherde VALUES("1948","0","636","2","LE","1820.00","35","SU","","","0","ওয়ালিং রড");
INSERT INTO tbl_payvoucherde VALUES("1949","0","636","2","LE","3980.00","35","SU","","","0","কাঠ ভাঙ্গা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("1950","0","637","2","LE","1500.00","67","CU","","","0","transport motor pump");
INSERT INTO tbl_payvoucherde VALUES("1951","0","637","2","LE","250.00","91","CU","","","0","khaber,soket,vara");
INSERT INTO tbl_payvoucherde VALUES("1952","0","637","2","LE","1000.00","67","CU","","","0","khaber asik");
INSERT INTO tbl_payvoucherde VALUES("1953","0","638","2","LE","50000.00","35","SU","","","0","LT,HT,PFI,ELD");
INSERT INTO tbl_payvoucherde VALUES("1954","0","639","2","LE","360.00","91","CU","","","0","বাল্ব");
INSERT INTO tbl_payvoucherde VALUES("1955","0","639","2","LE","130.00","35","SU","","","0","তার কাটা");
INSERT INTO tbl_payvoucherde VALUES("1956","0","639","2","LE","98500.00","91","CU","","","0","রড");
INSERT INTO tbl_payvoucherde VALUES("1957","0","640","2","LE","1000.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("1958","0","641","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1959","0","642","2","LE","2500000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1960","0","643","2","LE","7010.00","62","CU","","","0","name plate");
INSERT INTO tbl_payvoucherde VALUES("1961","0","643","2","LE","3667000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1962","0","644","2","LE","150.00","91","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1963","0","644","2","LE","1000.00","35","SU","","","0","rajmistri arman");
INSERT INTO tbl_payvoucherde VALUES("1964","0","644","2","LE","400.00","35","SU","","","0","oarling rod");
INSERT INTO tbl_payvoucherde VALUES("1965","0","644","2","LE","15005.00","67","CU","","","0","helal/liton");
INSERT INTO tbl_payvoucherde VALUES("1966","0","644","2","LE","1205.00","64","CU","","","0","nocimonmon vara");
INSERT INTO tbl_payvoucherde VALUES("1967","0","644","2","LE","900.00","67","CU","","","0","bill office exp");
INSERT INTO tbl_payvoucherde VALUES("1968","0","644","2","LE","25000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1969","0","645","2","LE","900.00","62","CU","","","0","লেবার বেতন");
INSERT INTO tbl_payvoucherde VALUES("1970","0","645","2","LE","100000.00","1","LO","","","0","সুধীর");
INSERT INTO tbl_payvoucherde VALUES("1971","0","645","2","LE","8000.00","62","CU","","","0","মটর বাধাই মুজুরি");
INSERT INTO tbl_payvoucherde VALUES("1972","0","645","2","LE","16000.00","150","LE","","","0","সার্কিট ব্রেকার");
INSERT INTO tbl_payvoucherde VALUES("1973","0","645","2","LE","16000.00","35","SU","","","0","বার্নিশ মটরের");
INSERT INTO tbl_payvoucherde VALUES("1974","0","645","2","LE","500.00","103","LE","","","0","কেবিন মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("1975","0","646","2","LE","700.00","35","SU","","","0","MOBIL");
INSERT INTO tbl_payvoucherde VALUES("1976","0","646","2","LE","4280.00","35","SU","","","0","GRIS");
INSERT INTO tbl_payvoucherde VALUES("1977","0","646","2","LE","4250.00","35","SU","","","0","KLAM,THINAR,BRUSH,JUT,FOA");
INSERT INTO tbl_payvoucherde VALUES("1978","0","647","2","LE","8400.00","25","CU","","","0","ROD PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("1979","0","647","2","LE","500.00","91","CU","","","0","RAJMISTRI BOKISH");
INSERT INTO tbl_payvoucherde VALUES("1980","0","647","2","LE","300500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1981","0","647","2","LE","5000.00","91","CU","","","0","RAJMISTRI DALAI");
INSERT INTO tbl_payvoucherde VALUES("1982","0","648","2","LE","20000.00","35","SU","","","0","BOILER MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1983","0","648","2","LE","250000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1984","0","648","2","LE","1000000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1985","0","649","2","LE","30000.00","67","CU","","","0","BILL 3O LAC *1%");
INSERT INTO tbl_payvoucherde VALUES("1986","0","649","2","LE","5000.00","67","CU","","","0","BILL PURBER");
INSERT INTO tbl_payvoucherde VALUES("1987","0","649","2","LE","5000.00","25","CU","","","0","ADIL SALARY");
INSERT INTO tbl_payvoucherde VALUES("1988","0","649","2","LE","5000.00","25","CU","","","0","KAKI ");
INSERT INTO tbl_payvoucherde VALUES("1989","0","649","2","LE","1000.00","25","CU","","","0","SS PIPE,CLICK");
INSERT INTO tbl_payvoucherde VALUES("1990","0","649","2","LE","215500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1991","0","650","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1992","0","650","2","LE","160000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1993","0","650","2","LE","40000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1994","0","650","2","LE","40000.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("1995","0","650","2","LE","44450.00","35","SU","","","0","ROD");
INSERT INTO tbl_payvoucherde VALUES("1996","0","650","2","LE","125900.00","35","SU","","","0","ROD,SABBIR");
INSERT INTO tbl_payvoucherde VALUES("1997","0","650","2","LE","5000.00","35","SU","","","0","ABUL MISTRI");
INSERT INTO tbl_payvoucherde VALUES("1998","0","650","2","LE","1500.00","25","CU","","","0","PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2000","0","652","2","LE","150000.00","1","LO","","","0","ARMAN-BINOY");
INSERT INTO tbl_payvoucherde VALUES("2001","0","653","2","LE","159750.00","35","SU","","","0","IT PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("2002","0","654","2","LE","132000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2003","0","655","2","LE","20000.00","44","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2004","0","656","2","LE","1000000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2005","0","657","2","LE","642000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2006","0","657","2","LE","2800.00","64","CU","","","0","JELE FISH DORA");
INSERT INTO tbl_payvoucherde VALUES("2007","0","658","2","LE","400000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2008","0","658","2","LE","30300.00","91","CU","","","0","সিমেন্ট");
INSERT INTO tbl_payvoucherde VALUES("2009","0","658","2","LE","500.00","25","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2010","0","658","2","LE","800.00","19","SU","","","0","2454 সারভিসিং");
INSERT INTO tbl_payvoucherde VALUES("2011","0","658","2","LE","7470.00","19","SU","","","0","2454 ব্রেকসু মুজুরি");
INSERT INTO tbl_payvoucherde VALUES("2012","0","658","2","LE","1500.00","35","SU","","","0","ইট ভাঙ্গানো");
INSERT INTO tbl_payvoucherde VALUES("2013","0","658","2","LE","10000.00","25","CU","","","0","মালেক ফুপার জায়গা রুবেল");
INSERT INTO tbl_payvoucherde VALUES("2014","0","658","2","LE","9000.00","25","CU","","","0","মালেক ফুপার জায়গা");
INSERT INTO tbl_payvoucherde VALUES("2015","0","658","2","LE","500000.00","1","LO","","","0","শ্যামল কুন্ড");
INSERT INTO tbl_payvoucherde VALUES("2016","0","659","2","LE","2000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2017","0","659","2","LE","1200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2018","0","659","2","LE","3400000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2019","0","660","2","LE","140.00","91","CU","","","0","KHABER.VARA");
INSERT INTO tbl_payvoucherde VALUES("2020","0","660","2","LE","14300.00","35","SU","","","0","OFFICE RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2021","0","661","2","LE","10210.00","67","CU","","","0","FISH JORIMANA");
INSERT INTO tbl_payvoucherde VALUES("2022","0","661","2","LE","16700.00","25","CU","","","0","JAJIM");
INSERT INTO tbl_payvoucherde VALUES("2023","0","661","2","LE","6060.00","35","SU","","","0","OWARLIN ROD");
INSERT INTO tbl_payvoucherde VALUES("2024","0","661","2","LE","1480.00","35","SU","","","0","TERPIN,GOJ KAPOR.SUP GLUE");
INSERT INTO tbl_payvoucherde VALUES("2025","0","661","2","LE","2000.00","67","CU","","","0","PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2026","0","661","2","LE","500.00","67","CU","","","0","ANGLE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2027","0","661","2","LE","2264000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2028","0","661","2","LE","150000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2029","0","661","2","LE","1100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2030","0","661","2","LE","6200.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2031","0","661","2","LE","4800.00","35","SU","","","0","NAYEEM");
INSERT INTO tbl_payvoucherde VALUES("2032","0","661","2","LE","100.00","35","SU","","","0","IT BOKSHIS");
INSERT INTO tbl_payvoucherde VALUES("2033","0","661","2","LE","2000.00","67","CU","","","0","PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2034","0","661","2","LE","500.00","67","CU","","","0","ASIK KHABER");
INSERT INTO tbl_payvoucherde VALUES("2035","0","662","2","LE","900000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2036","0","662","2","LE","922500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2037","0","662","2","LE","24500.00","35","SU","","","0","TIPU");
INSERT INTO tbl_payvoucherde VALUES("2038","0","662","2","LE","19250.00","35","SU","","","0","BILLAL");
INSERT INTO tbl_payvoucherde VALUES("2039","0","662","2","LE","1050.00","25","CU","","","0","ADAPTER");
INSERT INTO tbl_payvoucherde VALUES("2040","0","662","2","LE","14900.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2041","0","662","2","LE","15000.00","67","CU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2042","0","662","2","LE","28050.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2043","0","662","2","LE","43000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2044","0","663","2","LE","299.00","35","SU","","","0","MOBILE RECHERGE");
INSERT INTO tbl_payvoucherde VALUES("2045","0","664","2","LE","5600.00","35","SU","","","0","BABURSIR SALARY");
INSERT INTO tbl_payvoucherde VALUES("2046","0","664","2","LE","1100.00","35","SU","","","0","MEDECINE");
INSERT INTO tbl_payvoucherde VALUES("2047","0","664","2","LE","770.00","67","CU","","","0","KHABER,ONNANO");
INSERT INTO tbl_payvoucherde VALUES("2048","0","664","2","LE","2000.00","67","CU","","","0","HELAL PIPE");
INSERT INTO tbl_payvoucherde VALUES("2049","0","665","2","LE","2000.00","25","CU","","","0","NAJIM UDDIN KHABER");
INSERT INTO tbl_payvoucherde VALUES("2050","0","665","2","LE","5000.00","35","SU","","","0","RASED SALARY");
INSERT INTO tbl_payvoucherde VALUES("2051","0","666","2","LE","9000.00","12","CU","","","0","কে প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("2052","0","667","2","LE","7800.00","26","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2053","0","668","2","LE","3400.00","19","SU","","","0","HASAN MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2054","0","669","2","LE","1000.00","67","CU","","","0","RASEL ANGLE");
INSERT INTO tbl_payvoucherde VALUES("2055","0","669","2","LE","1000.00","67","CU","","","0","PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2056","0","670","2","LE","15400.00","35","SU","","","0","BALI");
INSERT INTO tbl_payvoucherde VALUES("2057","0","670","2","LE","500.00","35","SU","","","0","RAJMISTRI 500");
INSERT INTO tbl_payvoucherde VALUES("2058","0","671","2","LE","6010.00","67","CU","","","0","pump side net");
INSERT INTO tbl_payvoucherde VALUES("2059","0","671","2","LE","5010.00","67","CU","","","0","pipe,nut");
INSERT INTO tbl_payvoucherde VALUES("2060","0","671","2","LE","4800.00","67","CU","","","0","angle fittings");
INSERT INTO tbl_payvoucherde VALUES("2061","0","671","2","LE","4000.00","35","SU","","","0","rajmistri saidul");
INSERT INTO tbl_payvoucherde VALUES("2063","0","673","2","LE","499000.00","86","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2064","0","674","2","LE","40500.00","35","SU","","","0","অফহোয়াড রেড,মার্কিন কাপড়,");
INSERT INTO tbl_payvoucherde VALUES("2065","0","674","2","LE","5860.00","35","SU","","","0","ওয়ালিং রড L,B,L");
INSERT INTO tbl_payvoucherde VALUES("2066","0","674","2","LE","500000.00","1","LO","","","0","জুয়েল");
INSERT INTO tbl_payvoucherde VALUES("2067","0","674","2","LE","1220.00","35","SU","","","0","রয়েল বল্ট থিনার");
INSERT INTO tbl_payvoucherde VALUES("2068","0","674","2","LE","210.00","35","SU","","","0","ট্যাপ");
INSERT INTO tbl_payvoucherde VALUES("2069","0","674","2","LE","1300.00","35","SU","","","0","সেইব চাবি গাড");
INSERT INTO tbl_payvoucherde VALUES("2070","0","674","2","LE","20.00","35","SU","","","0","ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("2071","0","674","2","LE","14000.00","35","SU","","","0","ঢালাই");
INSERT INTO tbl_payvoucherde VALUES("2072","0","675","2","LE","2000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2073","0","675","2","LE","700000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2074","0","675","2","LE","200000.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2075","0","675","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2076","0","676","2","LE","540.00","67","CU","","","0","MALALMAL");
INSERT INTO tbl_payvoucherde VALUES("2077","0","676","2","LE","1000.00","35","SU","","","0","ABUL RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2078","0","676","2","LE","5810.00","67","CU","","","0","DRESER");
INSERT INTO tbl_payvoucherde VALUES("2079","0","676","2","LE","920000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2080","0","676","2","LE","670000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2081","0","677","2","LE","4500.00","25","CU","","","0","NIJ");
INSERT INTO tbl_payvoucherde VALUES("2082","0","678","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2084","0","680","2","LE","1300.00","35","SU","","","0","SIRIJ KAGOJ");
INSERT INTO tbl_payvoucherde VALUES("2085","0","680","2","LE","50000.00","35","SU","","","0","CEMET");
INSERT INTO tbl_payvoucherde VALUES("2086","0","680","2","LE","10000.00","64","CU","","","0","LIGHT,FAN,HOLDER");
INSERT INTO tbl_payvoucherde VALUES("2087","0","681","2","LE","350000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2088","0","681","2","LE","1900000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2089","0","681","2","LE","2000.00","67","CU","","","0","ROD");
INSERT INTO tbl_payvoucherde VALUES("2090","0","682","2","LE","1000.00","25","CU","","","0","CURRENT BILL");
INSERT INTO tbl_payvoucherde VALUES("2091","0","682","2","LE","16000.00","25","CU","","","0","HASAN SALARY");
INSERT INTO tbl_payvoucherde VALUES("2092","0","682","2","LE","1730.00","67","CU","","","0","HAJBOL,COBJA");
INSERT INTO tbl_payvoucherde VALUES("2093","0","682","2","LE","5000.00","67","CU","","","0","ANGLE ");
INSERT INTO tbl_payvoucherde VALUES("2094","0","682","2","LE","1500.00","67","CU","","","0","RASEL ANGLE");
INSERT INTO tbl_payvoucherde VALUES("2095","0","683","2","LE","580000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2096","0","684","2","LE","260000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2097","0","685","2","LE","1000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("2098","0","686","2","LE","1000.00","67","CU","","","0","আসিক বেতন");
INSERT INTO tbl_payvoucherde VALUES("2099","0","686","2","LE","1000.00","62","CU","","","0","কেরাসিন");
INSERT INTO tbl_payvoucherde VALUES("2100","0","686","2","LE","1000.00","35","SU","","","0","রাজমিস্ত্র");
INSERT INTO tbl_payvoucherde VALUES("2101","0","687","2","LE","690000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2102","0","688","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2103","0","688","2","LE","5000.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2104","0","689","2","LE","2400.00","35","SU","","","0","it purchase");
INSERT INTO tbl_payvoucherde VALUES("2105","0","689","2","LE","500.00","25","CU","","","0","a/c service");
INSERT INTO tbl_payvoucherde VALUES("2106","0","689","2","LE","4300.00","25","CU","","","0","sanetary");
INSERT INTO tbl_payvoucherde VALUES("2107","0","689","2","LE","1400.00","67","CU","","","0","pipe");
INSERT INTO tbl_payvoucherde VALUES("2108","0","689","2","LE","13800.00","19","SU","","","0","bettery 13-2454");
INSERT INTO tbl_payvoucherde VALUES("2109","0","690","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2110","0","691","2","LE","87500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2111","0","692","2","LE","6900.00","67","CU","","","0","rasel mistri");
INSERT INTO tbl_payvoucherde VALUES("2112","0","692","2","LE","500.00","67","CU","","","0","rasel mistri");
INSERT INTO tbl_payvoucherde VALUES("2113","0","692","2","LE","1000.00","67","CU","","","0","pipe helal");
INSERT INTO tbl_payvoucherde VALUES("2114","0","692","2","LE","2010.00","67","CU","","","0","mahabub");
INSERT INTO tbl_payvoucherde VALUES("2115","0","693","2","LE","10000.00","67","CU","","","0",".5 cashier");
INSERT INTO tbl_payvoucherde VALUES("2116","0","693","2","LE","20000.00","67","CU","","","0","1% xen");
INSERT INTO tbl_payvoucherde VALUES("2117","0","694","2","LE","800.00","35","SU","","","0","অক্রিজেন");
INSERT INTO tbl_payvoucherde VALUES("2118","0","694","2","LE","300.00","35","SU","","","0","ঢালাই নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("2119","0","695","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2121","0","697","2","LE","2500000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2122","0","697","2","LE","600.00","67","CU","","","0","KHABER");
INSERT INTO tbl_payvoucherde VALUES("2123","0","697","2","LE","1000.00","67","CU","","","0","PIPE MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2124","0","697","2","LE","2400.00","35","SU","","","0","IT VARA");
INSERT INTO tbl_payvoucherde VALUES("2125","0","697","2","LE","500.00","35","SU","","","0","LED BILL");
INSERT INTO tbl_payvoucherde VALUES("2126","0","697","2","LE","1500.00","35","SU","","","0","KHABER");
INSERT INTO tbl_payvoucherde VALUES("2127","0","698","2","LE","4000.00","25","CU","","","0","NAJIM UDDIN KHABER");
INSERT INTO tbl_payvoucherde VALUES("2128","0","698","2","LE","2510.00","67","CU","","","0","SOLAR PANEL");
INSERT INTO tbl_payvoucherde VALUES("2129","0","698","2","LE","1230000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2130","0","698","2","LE","12000.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2131","0","698","2","LE","100000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2132","0","698","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2133","0","699","2","LE","12100.00","35","SU","","","0","RAJMISTRI OFFICE");
INSERT INTO tbl_payvoucherde VALUES("2134","0","700","2","LE","28600.00","91","CU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("2135","0","700","2","LE","49600.00","35","SU","","","0","rajmistri chapai");
INSERT INTO tbl_payvoucherde VALUES("2136","0","700","2","LE","17300.00","35","SU","","","0","rajmistri office");
INSERT INTO tbl_payvoucherde VALUES("2137","0","700","2","LE","2000.00","35","SU","","","0","thinar,steel koni");
INSERT INTO tbl_payvoucherde VALUES("2138","0","700","2","LE","28000.00","35","SU","","","0","tipu mistri");
INSERT INTO tbl_payvoucherde VALUES("2139","0","701","2","LE","5400.00","35","SU","","","0","রাজমিস্ত্র");
INSERT INTO tbl_payvoucherde VALUES("2140","0","701","2","LE","1000.00","67","CU","","","0","আসিক বেতন");
INSERT INTO tbl_payvoucherde VALUES("2141","0","701","2","LE","200000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2142","0","701","2","LE","309200.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2143","0","702","2","LE","800000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2144","0","702","2","LE","723500.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2145","0","702","2","LE","420000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2146","0","702","2","LE","100000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2147","0","703","2","LE","1000.00","25","CU","","","0","malek fufa dish ter");
INSERT INTO tbl_payvoucherde VALUES("2148","0","704","2","LE","1000.00","67","CU","","","0","PIPE HELAL");
INSERT INTO tbl_payvoucherde VALUES("2149","0","704","2","LE","500.00","67","CU","","","0","KHABER MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2150","0","704","2","LE","1000.00","67","CU","","","0","ASIK KHABER");
INSERT INTO tbl_payvoucherde VALUES("2151","0","705","2","LE","3300.00","67","CU","","","0","SOLAR,MOTOR TER");
INSERT INTO tbl_payvoucherde VALUES("2152","0","706","2","LE","190000.00","19","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2153","0","707","2","LE","9900.00","67","CU","","","0","SOLAR BETTERY");
INSERT INTO tbl_payvoucherde VALUES("2154","0","708","2","LE","12000.00","19","SU","","","0","BETTERY");
INSERT INTO tbl_payvoucherde VALUES("2155","0","708","2","LE","500.00","19","SU","","","0","TALA");
INSERT INTO tbl_payvoucherde VALUES("2156","0","709","2","LE","6000.00","35","SU","","","0","রাজমিস্ত্র");
INSERT INTO tbl_payvoucherde VALUES("2157","0","710","2","LE","11000.00","89","LE","","","0","স্টাফ খরচ");
INSERT INTO tbl_payvoucherde VALUES("2158","0","710","2","LE","600.00","89","LE","","","0","পিয়ন খরচ");
INSERT INTO tbl_payvoucherde VALUES("2159","0","710","2","LE","8000.00","89","LE","","","0","টি সি ‍এফ স্যার");
INSERT INTO tbl_payvoucherde VALUES("2160","0","710","2","LE","10.00","137","LE","","","0","বিকাশ চার্জ");
INSERT INTO tbl_payvoucherde VALUES("2161","0","710","2","LE","2000.00","138","LE","","","0","খাবার");
INSERT INTO tbl_payvoucherde VALUES("2162","0","710","2","LE","550000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2163","0","711","2","LE","2000000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2164","0","711","2","LE","100000.00","35","SU","","","0","cement");
INSERT INTO tbl_payvoucherde VALUES("2165","0","711","2","LE","74900.00","35","SU","","","0","rod");
INSERT INTO tbl_payvoucherde VALUES("2166","0","711","2","LE","9540.00","35","SU","","","0","THINER,NUT,PATHOR");
INSERT INTO tbl_payvoucherde VALUES("2167","0","711","2","LE","2745.00","35","SU","","","0","CUTTING PATHOR,DISH");
INSERT INTO tbl_payvoucherde VALUES("2168","0","711","2","LE","100.00","35","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2169","0","712","2","LE","100000.00","35","SU","","","0","সিমেন্ট");
INSERT INTO tbl_payvoucherde VALUES("2170","0","712","2","LE","74900.00","35","SU","","","0","রড");
INSERT INTO tbl_payvoucherde VALUES("2171","0","712","2","LE","920000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2172","0","713","2","LE","700000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2173","0","713","2","LE","600000.00","3","LO","","","0","DELOWERFAKIR");
INSERT INTO tbl_payvoucherde VALUES("2174","0","713","2","LE","500.00","62","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2175","0","714","2","LE","27000.00","89","LE","","","0","মাসিক ফি");
INSERT INTO tbl_payvoucherde VALUES("2176","0","714","2","LE","1000.00","62","CU","","","0","সাইন বোর্ড ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("2177","0","714","2","LE","500.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("2178","0","715","2","LE","1000000.00","4","SU","","","0","ISLAMI BANK");
INSERT INTO tbl_payvoucherde VALUES("2179","0","716","2","LE","14010.00","62","CU","","","0","SINBORD");
INSERT INTO tbl_payvoucherde VALUES("2180","0","716","2","LE","5010.00","25","CU","","","0","RONY BHAI");
INSERT INTO tbl_payvoucherde VALUES("2181","0","716","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2182","0","717","2","LE","14400.00","35","SU","","","0","বালি");
INSERT INTO tbl_payvoucherde VALUES("2183","0","717","2","LE","25000.00","35","SU","","","0","সিমেন্ট");
INSERT INTO tbl_payvoucherde VALUES("2184","0","717","2","LE","500000.00","1","LO","","","0","maji");
INSERT INTO tbl_payvoucherde VALUES("2185","0","717","2","LE","215000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2186","0","717","2","LE","3600.00","35","SU","","","0","ইটের ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("2187","0","718","2","LE","1000000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2188","0","718","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2189","0","719","2","LE","10000.00","35","SU","","","0","SANATERING");
INSERT INTO tbl_payvoucherde VALUES("2190","0","719","2","LE","75500.00","91","CU","","","0","ROD,BALU");
INSERT INTO tbl_payvoucherde VALUES("2191","0","719","2","LE","28280.00","19","SU","","","0","TAX TOKEN,FITNESS");
INSERT INTO tbl_payvoucherde VALUES("2192","0","719","2","LE","4505.00","19","SU","","","0","13-2454 DALAL");
INSERT INTO tbl_payvoucherde VALUES("2193","0","719","2","LE","35.00","19","SU","","","0","PHOTO COPY");
INSERT INTO tbl_payvoucherde VALUES("2194","0","719","2","LE","28280.00","19","SU","","","0","FITNESS,TAX TOKEN13- 2471");
INSERT INTO tbl_payvoucherde VALUES("2195","0","719","2","LE","4505.00","19","SU","","","0","DALAL");
INSERT INTO tbl_payvoucherde VALUES("2196","0","719","2","LE","2010.00","19","SU","","","0","NUMBER PLATE");
INSERT INTO tbl_payvoucherde VALUES("2197","0","719","2","LE","90.00","19","SU","","","0","PHOTO COPY");
INSERT INTO tbl_payvoucherde VALUES("2198","0","719","2","LE","810.00","19","SU","","","0","FINGER PRINT");
INSERT INTO tbl_payvoucherde VALUES("2199","0","719","2","LE","4200.00","91","CU","","","0","BIT BALU");
INSERT INTO tbl_payvoucherde VALUES("2200","0","719","2","LE","100.00","67","CU","","","0","MAHABUB VARA");
INSERT INTO tbl_payvoucherde VALUES("2201","0","719","2","LE","1000000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2202","0","720","2","LE","5500.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2203","0","721","2","LE","100000.00","6","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2204","0","722","2","LE","5000.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2205","0","723","2","LE","31600.00","35","SU","","","0","RAJMISTRI CHAPAI");
INSERT INTO tbl_payvoucherde VALUES("2206","0","723","2","LE","16500.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2207","0","723","2","LE","1400.00","91","CU","","","0","BIT BALU");
INSERT INTO tbl_payvoucherde VALUES("2208","0","723","2","LE","5000.00","67","CU","","","0","RONG MISTRI SOYOD");
INSERT INTO tbl_payvoucherde VALUES("2209","0","723","2","LE","2100.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2210","0","723","2","LE","24500.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2211","0","724","2","LE","2500.00","25","CU","","","0","মনোরা সাইডের খাবার");
INSERT INTO tbl_payvoucherde VALUES("2212","0","724","2","LE","7700.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2213","0","724","2","LE","7600.00","35","SU","","","0","রং মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2214","0","724","2","LE","500.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("2215","0","724","2","LE","4000.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2216","0","724","2","LE","10900.00","89","LE","","","0","আজিজ");
INSERT INTO tbl_payvoucherde VALUES("2217","0","724","2","LE","1260.00","64","CU","","","0","বিদুৎ বিল");
INSERT INTO tbl_payvoucherde VALUES("2218","0","724","2","LE","11300.00","35","SU","","","0","রং,তারকাটা,লেদ বিল রয়েল ");
INSERT INTO tbl_payvoucherde VALUES("2219","0","725","2","LE","10000.00","67","CU","","","0","ASIK SALARY");
INSERT INTO tbl_payvoucherde VALUES("2220","0","725","2","LE","600000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2221","0","725","2","LE","2520.00","19","SU","","","0","NUMBER PLATE");
INSERT INTO tbl_payvoucherde VALUES("2222","0","725","2","LE","6000.00","19","SU","","","0","FITNESS,ROUT PERMIT DALAL");
INSERT INTO tbl_payvoucherde VALUES("2223","0","725","2","LE","1000.00","25","CU","","","0","BAZAR BASA BUA SALARY");
INSERT INTO tbl_payvoucherde VALUES("2224","0","725","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2225","0","726","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2226","0","726","2","LE","1600000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2227","0","726","2","LE","2300000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2228","0","727","2","LE","1550000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2229","0","727","2","LE","200.00","62","CU","","","0","TAP,VARA");
INSERT INTO tbl_payvoucherde VALUES("2230","0","728","2","LE","200000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2231","0","729","2","LE","81900.00","35","SU","","","0","it purchase");
INSERT INTO tbl_payvoucherde VALUES("2232","0","729","2","LE","430000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2233","0","729","2","LE","2180.00","67","CU","","","0","cement");
INSERT INTO tbl_payvoucherde VALUES("2234","0","729","2","LE","1000.00","67","CU","","","0","khaber");
INSERT INTO tbl_payvoucherde VALUES("2235","0","729","2","LE","5000.00","67","CU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("2236","0","729","2","LE","200.00","67","CU","","","0","jug,mug");
INSERT INTO tbl_payvoucherde VALUES("2237","0","729","2","LE","70.00","67","CU","","","0","vara");
INSERT INTO tbl_payvoucherde VALUES("2238","0","729","2","LE","1000.00","67","CU","","","0","pipe mistri");
INSERT INTO tbl_payvoucherde VALUES("2239","0","729","2","LE","550.00","67","CU","","","0","cement");
INSERT INTO tbl_payvoucherde VALUES("2240","0","730","2","LE","100000.00","35","SU","","","0","ROD PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("2241","0","730","2","LE","5300.00","35","SU","","","0","TERKATA,CUTTING PATHOR,TE");
INSERT INTO tbl_payvoucherde VALUES("2242","0","730","2","LE","2800.00","91","CU","","","0","BIT BALU");
INSERT INTO tbl_payvoucherde VALUES("2243","0","731","2","LE","274000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2244","0","731","2","LE","1380.00","150","LE","","","0","বি বোল্ট, এঙ্গেল");
INSERT INTO tbl_payvoucherde VALUES("2245","0","732","2","LE","1000.00","35","SU","","","0","পাট খোরি");
INSERT INTO tbl_payvoucherde VALUES("2246","0","732","2","LE","1000.00","25","CU","","","0","বাসার মাদ্রাসার বেতন");
INSERT INTO tbl_payvoucherde VALUES("2247","0","732","2","LE","6145.00","25","CU","","","0","গ্যাস");
INSERT INTO tbl_payvoucherde VALUES("2248","0","732","2","LE","1000.00","25","CU","","","0","অকটেন");
INSERT INTO tbl_payvoucherde VALUES("2249","0","732","2","LE","1025.00","25","CU","","","0","টোল");
INSERT INTO tbl_payvoucherde VALUES("2250","0","732","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2251","0","733","2","LE","1470.00","62","CU","","","0","কেমিক্যাল");
INSERT INTO tbl_payvoucherde VALUES("2252","0","734","2","LE","500000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2253","0","734","2","LE","2800000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2254","0","734","2","LE","535000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2255","0","735","2","LE","810.00","25","CU","","","0","বাসায় ওয়াই ফাই বিল");
INSERT INTO tbl_payvoucherde VALUES("2256","0","736","2","LE","50000.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2257","0","736","2","LE","6000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2258","0","736","2","LE","6950.00","35","SU","","","0","ROYEL BOLT,STEEL TERKATA");
INSERT INTO tbl_payvoucherde VALUES("2259","0","736","2","LE","50000.00","35","SU","","","0","ROD,CHURI");
INSERT INTO tbl_payvoucherde VALUES("2260","0","736","2","LE","5000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2261","0","736","2","LE","100000.00","25","CU","","","0","DUCH BANGLA BANK");
INSERT INTO tbl_payvoucherde VALUES("2262","0","736","2","LE","10000.00","35","SU","","","0","CYCLONE");
INSERT INTO tbl_payvoucherde VALUES("2263","0","736","2","LE","250000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2270","0","738","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2271","0","738","2","LE","700000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2272","0","738","2","LE","250000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2273","0","738","2","LE","470.00","35","SU","","","0","গ্রান্ডিং মেশিনের ব্লেট");
INSERT INTO tbl_payvoucherde VALUES("2274","0","739","2","LE","1450000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2275","0","739","2","LE","200000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2276","0","739","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2277","0","739","2","LE","814000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2278","0","740","2","LE","164200.00","25","CU","","","0","ডাচ বাংলা ব্যাংকে প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("2279","0","740","2","LE","12100.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2280","0","740","2","LE","10000.00","35","SU","","","0","রং মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2281","0","740","2","LE","1019.00","67","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2282","0","740","2","LE","5200.00","28","CU","","","0","কে প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("2283","0","741","2","LE","24500.00","35","SU","","","0","অপুু মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2284","0","741","2","LE","800.00","35","SU","","","0","অক্রিজেন");
INSERT INTO tbl_payvoucherde VALUES("2285","0","742","2","LE","29600.00","35","SU","","","0","CHAPAI Rajmistri");
INSERT INTO tbl_payvoucherde VALUES("2286","0","742","2","LE","17050.00","91","CU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2287","0","743","2","LE","34500.00","12","CU","","","0","ব্যালেন্স প্রাদান");
INSERT INTO tbl_payvoucherde VALUES("2288","0","743","2","LE","10000.00","35","SU","","","0","শেড মিস্ত্রিকে");
INSERT INTO tbl_payvoucherde VALUES("2289","0","743","2","LE","1000.00","35","SU","","","0","কাঠ মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2290","0","744","2","LE","510.00","35","SU","","","0","কাটিং,নজেল");
INSERT INTO tbl_payvoucherde VALUES("2291","0","744","2","LE","2500.00","35","SU","","","0","রাজ মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2292","0","744","2","LE","400.00","62","CU","","","0","মটরের বোরিং সাইজ");
INSERT INTO tbl_payvoucherde VALUES("2293","0","745","2","LE","780000.00","39","SU","","","0","VUSI PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("2294","0","745","2","LE","200000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2295","0","745","2","LE","800000.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2296","0","745","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2297","0","745","2","LE","1460000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2298","0","745","2","LE","77000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2299","0","745","2","LE","30000.00","35","SU","","","0","CYCLONE");
INSERT INTO tbl_payvoucherde VALUES("2300","0","745","2","LE","5500.00","35","SU","","","0","CYCLONE VARA");
INSERT INTO tbl_payvoucherde VALUES("2301","0","745","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2302","0","745","2","LE","100000.00","35","SU","","","0","ANGLE");
INSERT INTO tbl_payvoucherde VALUES("2303","0","745","2","LE","800000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2304","0","746","2","LE","780000.00","6","CU","","","0","VUSI PURCHASE");
INSERT INTO tbl_payvoucherde VALUES("2305","0","747","2","LE","20010.00","67","CU","","","0","হেলাল মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2306","0","747","2","LE","180000.00","35","SU","","","0","কাটিং বেল্ট");
INSERT INTO tbl_payvoucherde VALUES("2307","0","747","2","LE","42400.00","35","SU","","","0","পাইপ");
INSERT INTO tbl_payvoucherde VALUES("2308","0","747","2","LE","6350.00","35","SU","","","0","কাটিং প্লেট");
INSERT INTO tbl_payvoucherde VALUES("2309","0","747","2","LE","60800.00","35","SU","","","0","প্লেন কয়েল সিট");
INSERT INTO tbl_payvoucherde VALUES("2310","0","747","2","LE","3200.00","62","CU","","","0","ওয়াটার কন্ট্রলার");
INSERT INTO tbl_payvoucherde VALUES("2311","0","747","2","LE","300.00","35","SU","","","0","নাস্তা");
INSERT INTO tbl_payvoucherde VALUES("2312","0","747","2","LE","3430.00","35","SU","","","0","রোড খরচ +খাবার");
INSERT INTO tbl_payvoucherde VALUES("2313","0","748","2","LE","9731.00","35","SU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("2314","0","748","2","LE","16545.00","25","CU","","","0","BIDDUT BILL");
INSERT INTO tbl_payvoucherde VALUES("2315","0","748","2","LE","100000.00","35","SU","","","0","ANGLER");
INSERT INTO tbl_payvoucherde VALUES("2316","0","748","2","LE","5000.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2317","0","748","2","LE","23000.00","35","SU","","","0","MALAMAL AL ABBASH");
INSERT INTO tbl_payvoucherde VALUES("2318","0","748","2","LE","2000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2319","0","748","2","LE","200000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2320","0","748","2","LE","3800.00","35","SU","","","0","TRANSPORT");
INSERT INTO tbl_payvoucherde VALUES("2321","0","748","2","LE","1450.00","25","CU","","","0","BKASH");
INSERT INTO tbl_payvoucherde VALUES("2322","0","748","2","LE","2750.00","35","SU","","","0","SIRIZ KAGOJ,POLI,BELT");
INSERT INTO tbl_payvoucherde VALUES("2323","0","749","2","LE","49000.00","6","CU","","","0","truck vara");
INSERT INTO tbl_payvoucherde VALUES("2324","0","750","2","LE","200.00","35","SU","","","0","ARIF RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2325","0","750","2","LE","150.00","35","SU","","","0","PAPER");
INSERT INTO tbl_payvoucherde VALUES("2326","0","750","2","LE","5500.00","35","SU","","","0","OFFICE ELECTRICITY");
INSERT INTO tbl_payvoucherde VALUES("2327","0","750","2","LE","1000.00","25","CU","","","0","KAKI");
INSERT INTO tbl_payvoucherde VALUES("2328","0","751","2","LE","2000.00","35","SU","","","0","টিন সেট মিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2329","0","751","2","LE","112400.00","35","SU","","","0","রড বাবদ");
INSERT INTO tbl_payvoucherde VALUES("2330","0","752","2","LE","1000000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2331","0","752","2","LE","1310000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2334","0","754","2","LE","4000.00","25","CU","","","0","kaki");
INSERT INTO tbl_payvoucherde VALUES("2335","0","755","2","LE","2000.00","35","SU","","","0","বিদুৎ");
INSERT INTO tbl_payvoucherde VALUES("2336","0","755","2","LE","170.00","91","CU","","","0","খাবার");
INSERT INTO tbl_payvoucherde VALUES("2337","0","755","2","LE","500.00","91","CU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2338","0","755","2","LE","1700.00","35","SU","","","0","জুট,তারফিন ,ফোম");
INSERT INTO tbl_payvoucherde VALUES("2339","0","756","2","LE","50000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2340","0","757","2","LE","11945.00","25","CU","","","0","TIKET");
INSERT INTO tbl_payvoucherde VALUES("2341","0","757","2","LE","3005.00","67","CU","","","0","SHOHEL MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2342","0","757","2","LE","650000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2343","0","757","2","LE","500000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2344","0","757","2","LE","375000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2345","0","758","2","LE","530.00","67","CU","","","0","CEMENT");
INSERT INTO tbl_payvoucherde VALUES("2346","0","758","2","LE","2000.00","67","CU","","","0","PLAY,KHICHURI");
INSERT INTO tbl_payvoucherde VALUES("2347","0","758","2","LE","25000.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2348","0","759","2","LE","100000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2349","0","760","2","LE","500.00","35","SU","","","0","বাবুর্চি");
INSERT INTO tbl_payvoucherde VALUES("2350","0","760","2","LE","150.00","91","CU","","","0","খাবার");
INSERT INTO tbl_payvoucherde VALUES("2352","0","762","2","LE","5000.00","35","SU","","","0","রাজমিস্ত্রি");
INSERT INTO tbl_payvoucherde VALUES("2353","0","762","2","LE","500000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2354","0","762","2","LE","4500.00","87","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2355","0","763","2","LE","180000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2356","0","763","2","LE","700000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2357","0","763","2","LE","900000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2358","0","763","2","LE","3000.00","35","SU","","","0","SURKI");
INSERT INTO tbl_payvoucherde VALUES("2359","0","763","2","LE","950000.00","8","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2360","0","763","2","LE","12650.00","35","SU","","","0","OFFICE RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2361","0","763","2","LE","36800.00","35","SU","","","0","PLAIN SEET");
INSERT INTO tbl_payvoucherde VALUES("2362","0","763","2","LE","2600.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2363","0","763","2","LE","2600.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2364","0","763","2","LE","8000.00","35","SU","","","0","RONG MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2365","0","763","2","LE","1708000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2366","0","764","2","LE","17600.00","35","SU","","","0","SHED MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2367","0","764","2","LE","24500.00","35","SU","","","0","TIPU MISTRI");
INSERT INTO tbl_payvoucherde VALUES("2368","0","765","2","LE","11680.00","35","SU","","","0","OARLING ROD,CUTTING PATHO");
INSERT INTO tbl_payvoucherde VALUES("2369","0","766","2","LE","25000.00","35","SU","","","0","chapai rajmistri");
INSERT INTO tbl_payvoucherde VALUES("2370","0","767","2","LE","10600.00","26","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2371","0","768","2","LE","25850.00","91","CU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("2372","0","769","2","LE","640.00","35","SU","","","0","fan maramat,tye clip");
INSERT INTO tbl_payvoucherde VALUES("2373","0","769","2","LE","1000.00","25","CU","","","0","motor coyel");
INSERT INTO tbl_payvoucherde VALUES("2374","0","770","2","LE","1500.00","35","SU","","","0","RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2375","0","770","2","LE","3100.00","35","SU","","","0","RONG");
INSERT INTO tbl_payvoucherde VALUES("2376","0","770","2","LE","3300.00","35","SU","","","0","ARIF RAJMISTRI");
INSERT INTO tbl_payvoucherde VALUES("2377","0","770","2","LE","1500.00","35","SU","","","0","ABUL");
INSERT INTO tbl_payvoucherde VALUES("2378","0","771","2","LE","15000.00","35","SU","","","0","SURKI");
INSERT INTO tbl_payvoucherde VALUES("2379","0","771","2","LE","5100.00","35","SU","","","0","BABURCIR SALARI");
INSERT INTO tbl_payvoucherde VALUES("2380","0","772","2","LE","1000.00","67","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2381","0","772","2","LE","150000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2382","0","772","2","LE","100000.00","91","CU","","","0","রড");
INSERT INTO tbl_payvoucherde VALUES("2383","0","772","2","LE","170.00","35","SU","","","0","রড ভাড়া");
INSERT INTO tbl_payvoucherde VALUES("2384","0","772","2","LE","6700.00","91","CU","","","0","ইট ভাঙ্গা বাবদ");
INSERT INTO tbl_payvoucherde VALUES("2385","0","773","2","LE","250000.00","4","SU","","","0","DELOWER FAKIR");
INSERT INTO tbl_payvoucherde VALUES("2386","0","773","2","LE","450000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2387","0","773","2","LE","800000.00","50","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2388","0","773","2","LE","546000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2389","0","773","2","LE","900000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2390","0","773","2","LE","480.00","35","SU","","","0","POLI");
INSERT INTO tbl_payvoucherde VALUES("2391","0","774","2","LE","7000.00","35","SU","","","0","surki");
INSERT INTO tbl_payvoucherde VALUES("2392","0","774","2","LE","2000.00","35","SU","","","0","sader pipe ");
INSERT INTO tbl_payvoucherde VALUES("2393","0","774","2","LE","1500.00","25","CU","","","0","sanatery");
INSERT INTO tbl_payvoucherde VALUES("2394","0","774","2","LE","2700.00","25","CU","","","0","van charger");
INSERT INTO tbl_payvoucherde VALUES("2395","0","774","2","LE","5000.00","25","CU","","","0","adil");
INSERT INTO tbl_payvoucherde VALUES("2396","0","774","2","LE","6200.00","35","SU","","","0","rajmistri chapai");
INSERT INTO tbl_payvoucherde VALUES("2397","0","775","2","LE","676900.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2398","0","776","2","LE","2200.00","35","SU","","","0","rajmistri");
INSERT INTO tbl_payvoucherde VALUES("2399","0","777","2","LE","738.00","31","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2400","0","778","2","LE","3000.00","35","SU","","","0","গ্যাসের বোতল");
INSERT INTO tbl_payvoucherde VALUES("2401","0","778","2","LE","76500.00","35","SU","","","0","ইট ক্রয়");
INSERT INTO tbl_payvoucherde VALUES("2402","0","778","2","LE","106500.00","91","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2403","0","778","2","LE","50000.00","91","CU","","","0","রড ক্রয়");
INSERT INTO tbl_payvoucherde VALUES("2404","0","779","2","LE","100000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2405","0","780","2","LE","40000.00","35","SU","","","0","SELECTION BALI MAMUN");
INSERT INTO tbl_payvoucherde VALUES("2406","0","781","2","LE","645000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2407","0","782","2","LE","846.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2408","0","783","2","LE","675.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("2409","0","784","2","LE","500.00","62","CU","","","0","বিস্কুট");
INSERT INTO tbl_payvoucherde VALUES("2410","0","784","2","LE","50000.00","35","SU","","","0","সিমেন্ট");
INSERT INTO tbl_payvoucherde VALUES("2411","0","784","2","LE","1130.00","35","SU","","","0","অক্রিজেন,ডিজেল");
INSERT INTO tbl_payvoucherde VALUES("2412","0","784","2","LE","1900.00","35","SU","","","0","নেট,কোনি ,ভাড়া");



CREATE TABLE `tbl_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `refinv` varchar(15) DEFAULT NULL,
  `type` varchar(2) NOT NULL,
  `supid` int(11) NOT NULL,
  `itemdis` decimal(8,2) NOT NULL DEFAULT 0.00,
  `subtot` decimal(12,2) NOT NULL,
  `disp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `disamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `totdis` decimal(8,2) NOT NULL DEFAULT 0.00,
  `vatp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `vatamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `taxp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `taxamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `spmoney` decimal(8,2) NOT NULL DEFAULT 0.00,
  `otname` varchar(35) NOT NULL,
  `otamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `freight` decimal(8,2) NOT NULL DEFAULT 0.00,
  `less` decimal(8,2) NOT NULL DEFAULT 0.00,
  `adamo` decimal(12,2) DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `curid` int(11) NOT NULL,
  `ref` varchar(25) DEFAULT NULL,
  `note` varchar(150) DEFAULT NULL,
  `apdate` date NOT NULL,
  `nxtduedate` date DEFAULT NULL,
  `rawcash` decimal(12,2) NOT NULL DEFAULT 0.00,
  `changes` decimal(8,2) NOT NULL DEFAULT 0.00,
  `purp` int(11) DEFAULT NULL,
  `creditid` varchar(15) NOT NULL,
  `details` varchar(65) DEFAULT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `praw` varchar(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1869 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_purchase VALUES("2","PUR210324101","","SU","10","0.00","8707542.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8707542.00","0","","","2024-03-21","","8707542.00","0.00","","LE_2","","0","1","2024-03-21 02:45:30","0");
INSERT INTO tbl_purchase VALUES("3","PUR210324102","","SU","10","0.00","6136308.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6136308.00","0","","","2024-03-21","","6136308.00","0.00","","LE_2","","0","1","2024-03-21 03:19:28","1");
INSERT INTO tbl_purchase VALUES("4","PUR210324103","","SU","10","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-03-21","","19000.00","0.00","","LE_2","","0","1","2024-03-21 03:20:17","0");
INSERT INTO tbl_purchase VALUES("5","PUR210324104","","SU","10","0.00","3600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3600.00","0","","","2024-03-21","","3600.00","0.00","","LE_2","","0","1","2024-03-21 03:52:55","0");
INSERT INTO tbl_purchase VALUES("6","PUR210324105","","SU","10","0.00","1600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1600.00","0","","","2024-03-21","","1600.00","0.00","","LE_2","","0","1","2024-03-21 04:31:07","0");
INSERT INTO tbl_purchase VALUES("7","PUR210324106","","SU","12","0.00","715225.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","715225.00","0","","","2024-03-21","2024-03-28","0.00","0.00","","LE_2","","0","1","2024-03-21 07:16:47","1");
INSERT INTO tbl_purchase VALUES("8","PUR210324107","","SU","39","0.00","330925.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","330925.00","0","","","2024-03-21","","330925.00","0.00","","LE_2","","0","1","2024-03-21 07:18:11","1");
INSERT INTO tbl_purchase VALUES("9","PUR210324108","","SU","10","0.00","256000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","256000.00","0","","","2024-03-21","","256000.00","0.00","","LE_2","","0","1","2024-03-21 07:37:39","0");
INSERT INTO tbl_purchase VALUES("10","PUR210324109","","SU","10","0.00","80500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80500.00","0","","","2024-03-21","","80500.00","0.00","","LE_2","","0","1","2024-03-21 07:53:47","0");
INSERT INTO tbl_purchase VALUES("11","PUR210324110","","SU","10","0.00","196800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","196800.00","0","","","2024-03-21","","196800.00","0.00","","LE_2","","0","1","2024-03-21 07:54:36","0");
INSERT INTO tbl_purchase VALUES("12","PUR210324111","","SU","14","0.00","52500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52500.00","0","","","2024-03-21","2024-03-21","52500.00","0.00","","LE_2","","0","1","2024-03-21 08:01:19","0");
INSERT INTO tbl_purchase VALUES("13","PUR210324112","","SU","14","0.00","68250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68250.00","0","","","2024-03-21","2024-03-21","68250.00","0.00","","LE_2","","0","1","2024-03-21 08:01:19","0");
INSERT INTO tbl_purchase VALUES("14","PUR210324113","","SU","10","0.00","120000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120000.00","0","","","2024-03-21","","120000.00","0.00","","LE_2","","0","1","2024-03-21 08:07:59","0");
INSERT INTO tbl_purchase VALUES("15","PUR220324101","","SU","14","0.00","211750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","211750.00","0","","","2024-03-22","2024-03-22","211750.00","0.00","","LE_2","","0","1","2024-03-22 08:35:15","0");
INSERT INTO tbl_purchase VALUES("16","PUR220324102","","SU","14","0.00","12250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12250.00","0","","","2024-03-22","2024-03-22","12250.00","0.00","","LE_2","","0","1","2024-03-22 08:35:15","0");
INSERT INTO tbl_purchase VALUES("17","PUR220324103","","SU","14","0.00","242200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","242200.00","0","","","2024-03-22","2024-03-22","242200.00","0.00","","LE_2","","0","1","2024-03-22 08:35:15","0");
INSERT INTO tbl_purchase VALUES("18","PUR220324104","","SU","10","0.00","1800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1800.00","0","","","2024-03-22","","1800.00","0.00","","LE_2","","0","1","2024-03-22 10:54:47","0");
INSERT INTO tbl_purchase VALUES("19","PUR220324105","","SU","39","0.00","704835.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","704835.00","0","","","2024-03-22","2024-03-29","0.00","0.00","","LE_2","","0","1","2024-03-22 01:25:04","1");
INSERT INTO tbl_purchase VALUES("20","PUR220324106","","SU","39","0.00","124027.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","124027.50","0","","","2024-03-22","2024-03-29","0.00","0.00","","LE_2","","0","1","2024-03-22 01:26:05","1");
INSERT INTO tbl_purchase VALUES("21","PUR220324107","","SU","10","0.00","197000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197000.00","0","","","2024-03-22","","197000.00","0.00","","LE_2","","0","1","2024-03-22 07:08:38","0");
INSERT INTO tbl_purchase VALUES("22","PUR220324108","","SU","39","0.00","63000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63000.00","0","","","2024-03-22","","63000.00","0.00","","LE_2","","0","1","2024-03-22 07:26:17","1");
INSERT INTO tbl_purchase VALUES("23","PUR230324101","","SU","14","0.00","180000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180000.00","0","","","2024-03-23","2024-03-23","180000.00","0.00","","LE_2","","0","1","2024-03-23 10:32:10","0");
INSERT INTO tbl_purchase VALUES("24","PUR230324102","","SU","24","0.00","81770.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81770.00","0","","","2024-03-23","2024-03-30","0.00","0.00","","LE_2","","0","1","2024-03-23 11:09:15","1");
INSERT INTO tbl_purchase VALUES("25","PUR230324103","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-03-23","2024-03-23","18000.00","0.00","","LE_2","","0","1","2024-03-23 04:11:51","0");
INSERT INTO tbl_purchase VALUES("26","PUR230324104","","SU","14","0.00","259000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","259000.00","0","","","2024-03-23","2024-03-23","259000.00","0.00","","LE_2","","0","1","2024-03-23 07:10:14","0");
INSERT INTO tbl_purchase VALUES("27","PUR230324105","","SU","14","0.00","214200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","214200.00","0","","","2024-03-23","2024-03-23","214200.00","0.00","","LE_2","","0","1","2024-03-23 07:10:14","0");
INSERT INTO tbl_purchase VALUES("28","PUR230324106","","SU","43","0.00","289800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","289800.00","0","","","2024-03-23","","289800.00","0.00","","LE_2","","0","1","2024-03-23 08:05:45","1");
INSERT INTO tbl_purchase VALUES("29","PUR230324107","","SU","39","0.00","318090.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","318090.00","0","","","2024-03-23","","318090.00","0.00","","LE_2","","0","1","2024-03-23 08:06:12","1");
INSERT INTO tbl_purchase VALUES("30","PUR230324108","","SU","12","0.00","701012.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","701012.00","0","","","2024-03-23","2024-03-30","0.00","0.00","","LE_2","","0","1","2024-03-23 08:07:21","1");
INSERT INTO tbl_purchase VALUES("31","PUR230324109","","SU","43","0.00","589950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","589950.00","0","","","2024-03-23","","589950.00","0.00","","LE_2","","0","1","2024-03-23 09:06:20","1");
INSERT INTO tbl_purchase VALUES("32","PUR230324110","","SU","12","0.00","705160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","705160.00","0","","","2024-03-23","2024-03-30","0.00","0.00","","LE_2","","0","1","2024-03-23 09:18:32","1");
INSERT INTO tbl_purchase VALUES("33","PUR240324101","","SU","14","0.00","325500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","325500.00","0","","","2024-03-24","2024-03-24","325500.00","0.00","","LE_2","","0","1","2024-03-24 08:36:57","0");
INSERT INTO tbl_purchase VALUES("34","PUR240324102","","SU","14","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-03-24","2024-03-24","19250.00","0.00","","LE_2","","0","1","2024-03-24 08:36:57","0");
INSERT INTO tbl_purchase VALUES("35","PUR240324103","","SU","14","0.00","296800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","296800.00","0","","","2024-03-24","2024-03-24","296800.00","0.00","","LE_2","","0","1","2024-03-24 08:36:57","0");
INSERT INTO tbl_purchase VALUES("36","PUR240324104","","SU","24","0.00","181220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","181220.00","0","","","2024-03-24","2024-03-31","0.00","0.00","","LE_2","","0","1","2024-03-24 02:11:02","1");
INSERT INTO tbl_purchase VALUES("37","PUR240324105","","SU","39","0.00","212330.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","212330.00","0","","MITHUN","2024-03-24","","212330.00","0.00","","LE_2","","0","1","2024-03-24 04:56:47","1");
INSERT INTO tbl_purchase VALUES("38","PUR240324106","","SU","39","0.00","680000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","680000.00","0","","MALIGRAM","2024-03-24","","680000.00","0.00","","LE_2","","0","1","2024-03-24 04:57:28","1");
INSERT INTO tbl_purchase VALUES("39","PUR240324107","","SU","10","0.00","139200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","139200.00","0","","","2024-03-24","","139200.00","0.00","","LE_2","","0","1","2024-03-24 07:12:57","0");
INSERT INTO tbl_purchase VALUES("40","PUR240324108","","SU","39","0.00","693600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","693600.00","0","","","2024-03-24","","693600.00","0.00","","LE_2","","0","1","2024-03-24 08:08:05","1");
INSERT INTO tbl_purchase VALUES("41","PUR250324101","","SU","14","0.00","304500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","304500.00","0","","","2024-03-25","2024-03-25","304500.00","0.00","","LE_2","","0","1","2024-03-25 08:59:33","0");
INSERT INTO tbl_purchase VALUES("42","PUR250324102","","SU","14","0.00","15750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15750.00","0","","","2024-03-25","2024-03-25","15750.00","0.00","","LE_2","","0","1","2024-03-25 08:59:33","0");
INSERT INTO tbl_purchase VALUES("43","PUR250324103","","SU","14","0.00","126540.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126540.00","0","","","2024-03-25","2024-03-25","126540.00","0.00","","LE_2","","0","1","2024-03-25 08:59:33","0");
INSERT INTO tbl_purchase VALUES("44","PUR250324104","","SU","14","0.00","155520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","155520.00","0","","","2024-03-25","2024-03-25","155520.00","0.00","","LE_2","","0","1","2024-03-25 08:59:33","0");
INSERT INTO tbl_purchase VALUES("45","PUR250324105","","SU","11","0.00","712300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","712300.00","0","","","2024-03-25","2024-04-01","0.00","0.00","","LE_2","","0","1","2024-03-25 09:58:57","1");
INSERT INTO tbl_purchase VALUES("46","PUR250324106","","SU","10","0.00","0.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","0.20","0","","","2024-03-25","","0.20","0.00","","LE_2","","0","1","2024-03-25 10:08:04","0");
INSERT INTO tbl_purchase VALUES("47","PUR260324101","","SU","14","0.00","330750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","330750.00","0","","","2024-03-26","2024-03-26","330750.00","0.00","","LE_2","","0","1","2024-03-26 07:55:07","0");
INSERT INTO tbl_purchase VALUES("48","PUR260324102","","SU","14","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2024-03-26","2024-03-26","21000.00","0.00","","LE_2","","0","1","2024-03-26 07:55:07","0");
INSERT INTO tbl_purchase VALUES("49","PUR260324103","","SU","14","0.00","244400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","244400.00","0","","","2024-03-26","2024-03-26","244400.00","0.00","","LE_2","","0","1","2024-03-26 07:55:07","0");
INSERT INTO tbl_purchase VALUES("50","PUR260324104","","SU","10","0.00","0.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","0.30","0","","","2024-03-26","","0.30","0.00","","LE_2","","0","1","2024-03-26 11:11:07","0");
INSERT INTO tbl_purchase VALUES("51","PUR260324105","","SU","10","0.00","0.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","0.10","0","","","2024-03-26","","0.10","0.00","","LE_2","","0","1","2024-03-26 11:14:13","0");
INSERT INTO tbl_purchase VALUES("52","PUR260324106","","SU","24","0.00","121110.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","121110.00","0","","","2024-03-26","2024-04-02","35110.00","0.00","","LE_2","","0","1","2024-03-26 11:24:21","1");
INSERT INTO tbl_purchase VALUES("53","PUR260324107","","SU","10","0.00","257600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","257600.00","0","","","2024-03-26","","257600.00","0.00","","LE_2","","0","1","2024-03-26 12:14:58","0");
INSERT INTO tbl_purchase VALUES("54","PUR270324101","","SU","14","0.00","360500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","360500.00","0","","","2024-03-27","2024-03-27","360500.00","0.00","","LE_2","","0","1","2024-03-27 08:24:42","0");
INSERT INTO tbl_purchase VALUES("55","PUR270324102","","SU","14","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-03-27","2024-03-27","19250.00","0.00","","LE_2","","0","1","2024-03-27 08:24:42","0");
INSERT INTO tbl_purchase VALUES("56","PUR270324103","","SU","14","0.00","159840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159840.00","0","","","2024-03-27","2024-03-27","159840.00","0.00","","LE_2","","0","1","2024-03-27 08:24:42","0");
INSERT INTO tbl_purchase VALUES("57","PUR270324104","","SU","14","0.00","57600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57600.00","0","","","2024-03-27","2024-03-27","57600.00","0.00","","LE_2","","0","1","2024-03-27 08:24:42","0");
INSERT INTO tbl_purchase VALUES("58","PUR270324105","","SU","12","0.00","704550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","704550.00","0","","","2024-03-27","2024-04-03","0.00","0.00","","LE_2","","0","1","2024-03-27 12:52:26","1");
INSERT INTO tbl_purchase VALUES("59","PUR270324106","","SU","10","0.00","9320.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9320.00","0","","","2024-03-27","","9320.00","0.00","","LE_2","","0","1","2024-03-27 04:13:57","0");
INSERT INTO tbl_purchase VALUES("60","PUR280324101","","SU","10","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2024-03-28","","105000.00","0.00","","LE_2","","0","1","2024-03-28 08:10:01","0");
INSERT INTO tbl_purchase VALUES("61","PUR280324102","","SU","14","0.00","369250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","369250.00","0","","","2024-03-28","2024-03-28","369250.00","0.00","","LE_2","","0","1","2024-03-28 08:31:15","0");
INSERT INTO tbl_purchase VALUES("62","PUR280324103","","SU","14","0.00","29750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29750.00","0","","","2024-03-28","2024-03-28","29750.00","0.00","","LE_2","","0","1","2024-03-28 08:31:15","0");
INSERT INTO tbl_purchase VALUES("63","PUR280324104","","SU","14","0.00","10656.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10656.00","0","","","2024-03-28","2024-03-28","10656.00","0.00","","LE_2","","0","1","2024-03-28 08:31:15","0");
INSERT INTO tbl_purchase VALUES("64","PUR280324105","","SU","14","0.00","165240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165240.00","0","","","2024-03-28","2024-03-28","165240.00","0.00","","LE_2","","0","1","2024-03-28 08:31:15","0");
INSERT INTO tbl_purchase VALUES("65","PUR280324106","","SU","14","0.00","95616.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95616.00","0","","","2024-03-28","2024-03-28","95616.00","0.00","","LE_2","","0","1","2024-03-28 08:31:15","0");
INSERT INTO tbl_purchase VALUES("66","PUR280324107","","SU","12","0.00","674050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","674050.00","0","","","2024-03-28","2024-04-04","0.00","0.00","","LE_2","","0","1","2024-03-28 08:54:34","1");
INSERT INTO tbl_purchase VALUES("67","PUR280324108","","SU","39","0.00","139750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","139750.00","0","","","2024-03-28","","139750.00","0.00","","LE_2","","0","1","2024-03-28 10:45:40","1");
INSERT INTO tbl_purchase VALUES("68","PUR280324109","","SU","10","0.00","5700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5700.00","0","","","2024-03-28","","5700.00","0.00","","LE_2","","0","1","2024-03-28 01:16:46","0");
INSERT INTO tbl_purchase VALUES("69","PUR280324110","","SU","51","0.00","7920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7920.00","0","","","2024-03-28","","7920.00","0.00","","LE_2","","0","1","2024-03-28 04:31:37","1");
INSERT INTO tbl_purchase VALUES("70","PUR280324111","","SU","10","0.00","1900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1900.00","0","","","2024-03-28","","1900.00","0.00","","LE_2","","0","1","2024-03-28 07:20:57","0");
INSERT INTO tbl_purchase VALUES("71","PUR280324112","","SU","10","0.00","12.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12.30","0","","","2024-03-28","","12.30","0.00","","LE_2","","0","1","2024-03-28 07:25:08","0");
INSERT INTO tbl_purchase VALUES("72","PUR290324101","","SU","14","0.00","220720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220720.00","0","","","2024-03-29","2024-03-29","220720.00","0.00","","LE_2","","0","1","2024-03-29 10:58:02","0");
INSERT INTO tbl_purchase VALUES("73","PUR290324102","","SU","14","0.00","343375.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","343375.00","0","","","2024-03-29","2024-03-29","343375.00","0.00","","LE_2","","0","1","2024-03-29 10:58:02","0");
INSERT INTO tbl_purchase VALUES("74","PUR290324103","","SU","14","0.00","21775.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21775.00","0","","","2024-03-29","2024-03-29","21775.00","0.00","","LE_2","","0","1","2024-03-29 10:58:02","0");
INSERT INTO tbl_purchase VALUES("75","PUR290324104","","SU","10","0.00","16200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16200.00","0","","","2024-03-29","","16200.00","0.00","","LE_2","","0","1","2024-03-29 12:59:36","0");
INSERT INTO tbl_purchase VALUES("76","PUR300324101","","SU","10","0.00","194400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","194400.00","0","","","2024-03-30","","194400.00","0.00","","LE_2","","0","1","2024-03-30 09:03:56","0");
INSERT INTO tbl_purchase VALUES("77","PUR300324102","","SU","24","0.00","62725.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","62725.00","0","","","2024-03-30","2024-04-06","2725.00","0.00","","LE_2","","0","1","2024-03-30 11:17:16","1");
INSERT INTO tbl_purchase VALUES("78","PUR300324103","","SU","14","0.00","159250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159250.00","0","","","2024-03-30","2024-03-30","159250.00","0.00","","LE_2","","0","1","2024-03-30 07:03:06","0");
INSERT INTO tbl_purchase VALUES("79","PUR300324104","","SU","14","0.00","12250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12250.00","0","","","2024-03-30","2024-03-30","12250.00","0.00","","LE_2","","0","1","2024-03-30 07:03:06","0");
INSERT INTO tbl_purchase VALUES("80","PUR300324105","","SU","14","0.00","98400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","98400.00","0","","","2024-03-30","2024-03-30","98400.00","0.00","","LE_2","","0","1","2024-03-30 07:03:06","0");
INSERT INTO tbl_purchase VALUES("81","PUR300324106","","SU","10","0.00","39670.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39670.00","0","","","2024-03-30","","39670.00","0.00","","LE_2","","0","1","2024-03-30 08:10:21","0");
INSERT INTO tbl_purchase VALUES("82","PUR300324107","","SU","10","0.00","1.60","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1.60","0","","","2024-03-30","","1.60","0.00","","LE_2","","0","1","2024-03-30 08:22:27","0");
INSERT INTO tbl_purchase VALUES("83","PUR310324101","","SU","14","0.00","350000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350000.00","0","","","2024-03-31","2024-03-31","350000.00","0.00","","LE_2","","0","1","2024-03-31 10:00:14","0");
INSERT INTO tbl_purchase VALUES("84","PUR310324102","","SU","14","0.00","22750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22750.00","0","","","2024-03-31","2024-03-31","22750.00","0.00","","LE_2","","0","1","2024-03-31 10:00:14","0");
INSERT INTO tbl_purchase VALUES("85","PUR310324103","","SU","14","0.00","299700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","299700.00","0","","","2024-03-31","2024-03-31","299700.00","0.00","","LE_2","","0","1","2024-03-31 10:00:14","0");
INSERT INTO tbl_purchase VALUES("86","PUR310324104","","SU","10","0.00","45600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45600.00","0","","","2024-03-31","","45600.00","0.00","","LE_2","","0","1","2024-03-31 10:41:24","0");
INSERT INTO tbl_purchase VALUES("87","PUR310324105","","SU","10","0.00","15.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15.00","0","","","2024-03-31","","15.00","0.00","","LE_2","","0","1","2024-03-31 12:03:36","0");
INSERT INTO tbl_purchase VALUES("88","PUR310324106","","SU","10","0.00","17800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17800.00","0","","","2024-03-31","","17800.00","0.00","","LE_2","","0","1","2024-03-31 12:15:55","0");
INSERT INTO tbl_purchase VALUES("89","PUR310324107","","SU","12","0.00","693875.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","693875.00","0","","","2024-03-31","2024-04-07","0.00","0.00","","LE_2","","0","1","2024-03-31 04:02:52","1");
INSERT INTO tbl_purchase VALUES("90","PUR310324108","","SU","10","0.00","1.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1.40","0","","","2024-03-31","","1.40","0.00","","LE_2","","0","1","2024-03-31 07:27:03","0");
INSERT INTO tbl_purchase VALUES("91","PUR310324109","","SU","10","0.00","13680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13680.00","0","","","2024-03-31","","13680.00","0.00","","LE_2","","0","1","2024-03-31 07:27:56","0");
INSERT INTO tbl_purchase VALUES("92","PUR010424101","","SU","14","0.00","350000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350000.00","0","","","2024-04-01","2024-04-01","350000.00","0.00","","LE_2","","0","1","2024-04-01 08:19:57","0");
INSERT INTO tbl_purchase VALUES("93","PUR010424102","","SU","14","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-04-01","2024-04-01","19250.00","0.00","","LE_2","","0","1","2024-04-01 08:19:57","0");
INSERT INTO tbl_purchase VALUES("94","PUR010424103","","SU","14","0.00","275724.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","275724.00","0","","","2024-04-01","2024-04-01","275724.00","0.00","","LE_2","","0","1","2024-04-01 08:19:57","0");
INSERT INTO tbl_purchase VALUES("95","PUR010424104","","SU","14","0.00","388500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","388500.00","0","","","2024-04-01","2024-04-01","388500.00","0.00","","LE_2","","0","1","2024-04-01 04:56:08","0");
INSERT INTO tbl_purchase VALUES("96","PUR010424105","","SU","14","0.00","22750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22750.00","0","","","2024-04-01","2024-04-01","22750.00","0.00","","LE_2","","0","1","2024-04-01 04:56:08","0");
INSERT INTO tbl_purchase VALUES("97","PUR010424106","","SU","14","0.00","303696.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","303696.00","0","","","2024-04-01","2024-04-01","303696.00","0.00","","LE_2","","0","1","2024-04-01 04:56:08","0");
INSERT INTO tbl_purchase VALUES("98","PUR010424107","","SU","10","0.00","116850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116850.00","0","","","2024-04-01","","116850.00","0.00","","LE_2","","0","1","2024-04-01 05:05:00","0");
INSERT INTO tbl_purchase VALUES("99","PUR010424108","","SU","1","0.00","683760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","683760.00","0","","","2024-04-01","2024-04-08","0.00","0.00","","LE_2","","0","1","2024-04-01 08:27:39","0");
INSERT INTO tbl_purchase VALUES("100","PUR010424109","","SU","10","0.00","83640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","83640.00","0","","","2024-04-01","","83640.00","0.00","","LE_2","","0","1","2024-04-01 09:30:55","0");
INSERT INTO tbl_purchase VALUES("101","PUR010424110","","SU","10","0.00","4560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4560.00","0","","","2024-04-01","","4560.00","0.00","","LE_2","","0","1","2024-04-01 09:31:15","0");
INSERT INTO tbl_purchase VALUES("102","PUR010424111","","SU","10","0.00","49450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49450.00","0","","","2024-04-01","","49450.00","0.00","","LE_2","","0","1","2024-04-01 09:52:59","0");
INSERT INTO tbl_purchase VALUES("103","PUR020424101","","SU","14","0.00","320250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","320250.00","0","","","2024-04-02","2024-04-02","320250.00","0.00","","LE_2","","0","1","2024-04-02 08:25:46","0");
INSERT INTO tbl_purchase VALUES("104","PUR020424102","","SU","14","0.00","22750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22750.00","0","","","2024-04-02","2024-04-02","22750.00","0.00","","LE_2","","0","1","2024-04-02 08:25:46","0");
INSERT INTO tbl_purchase VALUES("105","PUR020424103","","SU","14","0.00","314352.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","314352.00","0","","","2024-04-02","2024-04-02","314352.00","0.00","","LE_2","","0","1","2024-04-02 08:25:46","0");
INSERT INTO tbl_purchase VALUES("106","PUR020424104","","SU","10","0.00","88560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88560.00","0","","","2024-04-02","","88560.00","0.00","","LE_2","","0","1","2024-04-02 08:30:31","0");
INSERT INTO tbl_purchase VALUES("107","PUR020424105","","SU","39","0.00","21125.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21125.00","0","","","2024-04-02","","21125.00","0.00","","LE_2","","0","1","2024-04-02 10:20:16","1");
INSERT INTO tbl_purchase VALUES("108","PUR020424106","","SU","39","0.00","32500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32500.00","0","","","2024-04-02","","32500.00","0.00","","LE_2","","0","1","2024-04-02 10:20:42","1");
INSERT INTO tbl_purchase VALUES("109","PUR020424107","","SU","10","0.00","1.60","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1.60","0","","","2024-04-02","","1.60","0.00","","LE_2","","0","1","2024-04-02 02:50:36","0");
INSERT INTO tbl_purchase VALUES("110","PUR020424108","","SU","39","0.00","32257.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32257.50","0","","","2024-04-02","","32257.50","0.00","","LE_2","","0","1","2024-04-02 03:22:17","1");
INSERT INTO tbl_purchase VALUES("111","PUR020424109","","SU","10","0.00","105600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105600.00","0","","","2024-04-02","","105600.00","0.00","","LE_2","","0","1","2024-04-02 04:02:04","0");
INSERT INTO tbl_purchase VALUES("112","PUR020424110","","SU","10","0.00","17600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17600.00","0","","","2024-04-02","","17600.00","0.00","","LE_2","","0","1","2024-04-02 04:21:51","0");
INSERT INTO tbl_purchase VALUES("113","PUR020424111","","SU","10","0.00","1.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1.30","0","","","2024-04-02","","1.30","0.00","","LE_2","","0","1","2024-04-02 08:00:14","0");
INSERT INTO tbl_purchase VALUES("114","PUR020424112","","SU","10","0.00","6840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6840.00","0","","","2024-04-02","","6840.00","0.00","","LE_2","","0","1","2024-04-02 08:01:40","0");
INSERT INTO tbl_purchase VALUES("115","PUR020424113","","SU","43","0.00","277200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","277200.00","0","","","2024-04-02","","277200.00","0.00","","LE_2","","0","1","2024-04-02 08:03:12","1");
INSERT INTO tbl_purchase VALUES("116","PUR020424114","","SU","14","0.00","350000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350000.00","0","","","2024-04-02","2024-04-02","350000.00","0.00","","LE_2","","0","1","2024-04-02 08:47:13","0");
INSERT INTO tbl_purchase VALUES("117","PUR020424115","","SU","14","0.00","29750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29750.00","0","","","2024-04-02","2024-04-02","29750.00","0.00","","LE_2","","0","1","2024-04-02 08:47:13","0");
INSERT INTO tbl_purchase VALUES("118","PUR020424116","","SU","14","0.00","102564.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","102564.00","0","","","2024-04-02","2024-04-02","102564.00","0.00","","LE_2","","0","1","2024-04-02 08:47:13","0");
INSERT INTO tbl_purchase VALUES("119","PUR020424117","","SU","14","0.00","236160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","236160.00","0","","","2024-04-02","2024-04-02","236160.00","0.00","","LE_2","","0","1","2024-04-02 08:47:13","0");
INSERT INTO tbl_purchase VALUES("120","PUR030424101","","SU","14","0.00","338400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","338400.00","0","","","2024-04-03","2024-04-03","338400.00","0.00","","LE_2","","0","1","2024-04-03 08:19:55","0");
INSERT INTO tbl_purchase VALUES("121","PUR030424102","","SU","14","0.00","23400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23400.00","0","","","2024-04-03","2024-04-03","23400.00","0.00","","LE_2","","0","1","2024-04-03 08:19:55","0");
INSERT INTO tbl_purchase VALUES("122","PUR030424103","","SU","14","0.00","319680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","319680.00","0","","","2024-04-03","2024-04-03","319680.00","0.00","","LE_2","","0","1","2024-04-03 08:19:55","0");
INSERT INTO tbl_purchase VALUES("123","PUR030424104","","SU","7","0.00","714600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","714600.00","0","","","2024-04-03","2024-04-10","0.00","0.00","","LE_2","","0","1","2024-04-03 02:56:38","1");
INSERT INTO tbl_purchase VALUES("124","PUR030424105","","SU","14","0.00","129500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","129500.00","0","","","2024-04-03","2024-04-03","129500.00","0.00","","LE_2","","0","1","2024-04-03 03:13:05","0");
INSERT INTO tbl_purchase VALUES("125","PUR030424106","","SU","39","0.00","32500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32500.00","0","","","2024-04-03","","32500.00","0.00","","LE_2","","0","1","2024-04-03 04:13:41","1");
INSERT INTO tbl_purchase VALUES("126","PUR030424107","","SU","10","0.00","9120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9120.00","0","","","2024-04-03","","9120.00","0.00","","LE_2","","0","1","2024-04-03 07:30:26","0");
INSERT INTO tbl_purchase VALUES("127","PUR030424108","","SU","10","0.00","7.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7.20","0","","","2024-04-03","","7.20","0.00","","LE_2","","0","1","2024-04-03 07:32:14","0");
INSERT INTO tbl_purchase VALUES("128","PUR030424109","","SU","39","0.00","671520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","671520.00","0","","","2024-04-03","","671520.00","0.00","","LE_2","","0","1","2024-04-03 08:07:45","1");
INSERT INTO tbl_purchase VALUES("129","PUR030424110","","SU","10","0.00","31080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31080.00","0","","","2024-04-03","","31080.00","0.00","","LE_2","","0","1","2024-04-03 08:23:21","0");
INSERT INTO tbl_purchase VALUES("130","PUR040424101","","SU","14","0.00","358200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","358200.00","0","","","2024-04-04","2024-04-04","358200.00","0.00","","LE_2","","0","1","2024-04-04 08:16:44","0");
INSERT INTO tbl_purchase VALUES("131","PUR040424102","","SU","14","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2024-04-04","2024-04-04","30600.00","0.00","","LE_2","","0","1","2024-04-04 08:16:44","0");
INSERT INTO tbl_purchase VALUES("132","PUR040424103","","SU","14","0.00","321012.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","321012.00","0","","","2024-04-04","2024-04-04","321012.00","0.00","","LE_2","","0","1","2024-04-04 08:16:44","0");
INSERT INTO tbl_purchase VALUES("133","PUR040424104","","SU","10","0.00","15.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15.00","0","","","2024-04-04","","15.00","0.00","","LE_2","","0","1","2024-04-04 09:07:55","0");
INSERT INTO tbl_purchase VALUES("134","PUR040424105","","SU","14","0.00","266400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266400.00","0","","","2024-04-04","2024-04-04","266400.00","0.00","","LE_2","","0","1","2024-04-04 07:12:49","0");
INSERT INTO tbl_purchase VALUES("135","PUR040424106","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-04-04","2024-04-04","18000.00","0.00","","LE_2","","0","1","2024-04-04 07:12:49","0");
INSERT INTO tbl_purchase VALUES("136","PUR040424107","","SU","14","0.00","233100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","233100.00","0","","","2024-04-04","2024-04-04","233100.00","0.00","","LE_2","","0","1","2024-04-04 07:12:49","0");
INSERT INTO tbl_purchase VALUES("137","PUR050424101","","SU","14","0.00","343800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","343800.00","0","","","2024-04-05","2024-04-05","343800.00","0.00","","LE_2","","0","1","2024-04-05 08:00:31","0");
INSERT INTO tbl_purchase VALUES("138","PUR050424102","","SU","14","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-04-05","2024-04-05","28800.00","0.00","","LE_2","","0","1","2024-04-05 08:00:31","0");
INSERT INTO tbl_purchase VALUES("139","PUR050424103","","SU","14","0.00","289044.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","289044.00","0","","","2024-04-05","2024-04-05","289044.00","0.00","","LE_2","","0","1","2024-04-05 08:00:31","0");
INSERT INTO tbl_purchase VALUES("140","PUR050424104","","SU","39","0.00","672030.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","672030.00","0","","","2024-04-05","","672030.00","0.00","","LE_2","","0","1","2024-04-05 10:31:53","1");
INSERT INTO tbl_purchase VALUES("141","PUR050424105","","SU","43","0.00","568575.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","568575.00","0","","","2024-04-05","","568575.00","0.00","","LE_2","","0","1","2024-04-05 07:53:16","1");
INSERT INTO tbl_purchase VALUES("142","PUR050424106","","SU","10","0.00","166000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","166000.00","0","","","2024-04-05","","166000.00","0.00","","LE_2","","0","1","2024-04-05 07:59:13","0");
INSERT INTO tbl_purchase VALUES("143","PUR060424101","","SU","10","0.00","6854.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6854.00","0","","","2024-04-06","","6854.00","0.00","","LE_2","","0","1","2024-04-06 12:08:40","0");
INSERT INTO tbl_purchase VALUES("144","PUR060424102","","SU","10","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2024-04-06","","90000.00","0.00","","LE_2","","0","1","2024-04-06 02:06:19","0");
INSERT INTO tbl_purchase VALUES("145","PUR060424103","","SU","10","0.00","40.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40.00","0","","","2024-04-06","","40.00","0.00","","LE_2","","0","1","2024-04-06 02:11:36","0");
INSERT INTO tbl_purchase VALUES("146","PUR060424104","","SU","7","0.00","477000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","477000.00","0","","","2024-04-06","2024-04-13","0.00","0.00","","LE_2","","0","1","2024-04-06 04:50:09","1");
INSERT INTO tbl_purchase VALUES("147","PUR060424105","","SU","2","0.00","210000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","210000.00","0","","","2024-04-06","2024-04-13","0.00","0.00","","LE_2","","0","1","2024-04-06 04:47:52","1");
INSERT INTO tbl_purchase VALUES("148","PUR060424106","","SU","8","0.00","393072.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","393072.00","0","","","2024-04-06","2024-04-13","0.00","0.00","","LE_2","","0","1","2024-04-06 04:50:43","1");
INSERT INTO tbl_purchase VALUES("149","PUR060424107","","SU","24","0.00","26400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26400.00","0","","","2024-04-06","","26400.00","0.00","","LE_2","","0","1","2024-04-06 06:15:35","1");
INSERT INTO tbl_purchase VALUES("151","PUR060424108","","SU","10","0.00","22800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22800.00","0","","","2024-04-06","","22800.00","0.00","","LE_2","","0","1","2024-04-06 07:19:00","0");
INSERT INTO tbl_purchase VALUES("152","PUR060424109","","SU","43","0.00","578880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","578880.00","0","","","2024-04-06","","578880.00","0.00","","LE_2","","0","1","2024-04-08 09:37:33","1");
INSERT INTO tbl_purchase VALUES("153","PUR070424101","","SU","14","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2024-04-07","2024-04-07","175000.00","0.00","","LE_2","","0","1","2024-04-07 08:44:46","0");
INSERT INTO tbl_purchase VALUES("154","PUR070424102","","SU","14","0.00","23120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23120.00","0","","","2024-04-07","2024-04-07","23120.00","0.00","","LE_2","","0","1","2024-04-07 09:17:58","0");
INSERT INTO tbl_purchase VALUES("155","PUR070424103","","SU","14","0.00","268200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","268200.00","0","","","2024-04-07","2024-04-07","268200.00","0.00","","LE_2","","0","1","2024-04-07 11:00:19","0");
INSERT INTO tbl_purchase VALUES("156","PUR070424104","","SU","14","0.00","23400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23400.00","0","","","2024-04-07","2024-04-07","23400.00","0.00","","LE_2","","0","1","2024-04-07 11:00:19","0");
INSERT INTO tbl_purchase VALUES("157","PUR070424105","","SU","14","0.00","79380.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","79380.00","0","","","2024-04-07","2024-04-07","79380.00","0.00","","LE_2","","0","1","2024-04-07 11:00:19","0");
INSERT INTO tbl_purchase VALUES("158","PUR070424106","","SU","10","0.00","6.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6.00","0","","","2024-04-07","","6.00","0.00","","LE_2","","0","1","2024-04-07 11:01:31","0");
INSERT INTO tbl_purchase VALUES("159","PUR070424107","","SU","43","0.00","403920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","403920.00","0","","","2024-04-07","","403920.00","0.00","","LE_2","","0","1","2024-04-07 03:57:09","1");
INSERT INTO tbl_purchase VALUES("160","PUR070424108","","SU","8","0.00","373806.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","373806.00","0","","","2024-04-07","2024-04-14","0.00","0.00","","LE_2","","0","1","2024-04-07 04:24:14","1");
INSERT INTO tbl_purchase VALUES("161","PUR070424109","","SU","10","0.00","6840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6840.00","0","","","2024-04-07","","6840.00","0.00","","LE_2","","0","1","2024-04-07 07:10:42","0");
INSERT INTO tbl_purchase VALUES("162","PUR070424110","","SU","12","0.00","762622.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","762622.00","0","","","2024-04-07","2024-04-14","0.00","0.00","","LE_2","","0","1","2024-04-07 07:18:56","1");
INSERT INTO tbl_purchase VALUES("163","PUR070424111","","SU","10","0.00","18.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18.10","0","","","2024-04-07","","18.10","0.00","","LE_2","","0","1","2024-04-07 07:55:24","0");
INSERT INTO tbl_purchase VALUES("164","PUR080424101","","SU","14","0.00","310356.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","310356.00","0","","","2024-04-08","2024-04-08","310356.00","0.00","","LE_2","","0","1","2024-04-08 07:55:06","0");
INSERT INTO tbl_purchase VALUES("165","PUR080424102","","SU","14","0.00","357000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","357000.00","0","","","2024-04-08","2024-04-08","357000.00","0.00","","LE_2","","0","1","2024-04-08 08:14:49","0");
INSERT INTO tbl_purchase VALUES("166","PUR080424103","","SU","14","0.00","26250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26250.00","0","","","2024-04-08","2024-04-08","26250.00","0.00","","LE_2","","0","1","2024-04-08 08:14:49","0");
INSERT INTO tbl_purchase VALUES("167","PUR080424104","","SU","8","0.00","369151.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","369151.00","0","","","2024-04-08","2024-04-15","0.00","0.00","","LE_2","","0","1","2024-04-08 03:52:42","1");
INSERT INTO tbl_purchase VALUES("168","PUR080424105","","SU","10","0.00","147600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","147600.00","0","","","2024-04-08","","147600.00","0.00","","LE_2","","0","1","2024-04-08 04:06:26","0");
INSERT INTO tbl_purchase VALUES("169","PUR080424106","","SU","24","0.00","28798.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28798.00","0","","","2024-04-08","","28798.00","0.00","","LE_2","","0","1","2024-04-08 04:40:37","1");
INSERT INTO tbl_purchase VALUES("170","PUR080424107","","SU","14","0.00","159840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159840.00","0","","","2024-04-08","2024-04-08","159840.00","0.00","","LE_2","","0","1","2024-04-08 04:58:48","0");
INSERT INTO tbl_purchase VALUES("171","PUR080424108","","SU","14","0.00","133200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133200.00","0","","","2024-04-08","2024-04-08","133200.00","0.00","","LE_2","","0","1","2024-04-08 05:52:18","0");
INSERT INTO tbl_purchase VALUES("172","PUR080424109","","SU","10","0.00","5.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5.00","0","","","2024-04-08","","5.00","0.00","","LE_2","","0","1","2024-04-08 09:00:31","0");
INSERT INTO tbl_purchase VALUES("173","PUR080424110","","SU","10","0.00","91200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91200.00","0","","","2024-04-08","","91200.00","0.00","","LE_2","","0","1","2024-04-08 09:09:04","0");
INSERT INTO tbl_purchase VALUES("174","PUR080424111","","SU","14","0.00","428750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","428750.00","0","","","2024-04-08","2024-04-08","428750.00","0.00","","LE_2","","0","1","2024-04-08 09:19:37","0");
INSERT INTO tbl_purchase VALUES("175","PUR080424112","","SU","14","0.00","26250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26250.00","0","","","2024-04-08","2024-04-08","26250.00","0.00","","LE_2","","0","1","2024-04-08 09:19:37","0");
INSERT INTO tbl_purchase VALUES("176","PUR080424113","","SU","14","0.00","73260.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73260.00","0","","","2024-04-08","2024-04-08","73260.00","0.00","","LE_2","","0","1","2024-04-08 09:19:37","0");
INSERT INTO tbl_purchase VALUES("177","PUR080424114","","SU","14","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2024-04-08","2024-04-08","24000.00","0.00","","LE_2","","0","1","2024-04-08 09:19:37","0");
INSERT INTO tbl_purchase VALUES("178","PUR090424101","","SU","14","0.00","318600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","318600.00","0","","","2024-04-09","2024-04-09","318600.00","0.00","","LE_2","","0","1","2024-04-09 08:39:23","0");
INSERT INTO tbl_purchase VALUES("179","PUR090424102","","SU","14","0.00","60120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60120.00","0","","","2024-04-09","2024-04-09","60120.00","0.00","","LE_2","","0","1","2024-04-09 08:39:23","0");
INSERT INTO tbl_purchase VALUES("180","PUR090424103","","SU","14","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2024-04-09","2024-04-09","30600.00","0.00","","LE_2","","0","1","2024-04-09 08:39:23","0");
INSERT INTO tbl_purchase VALUES("181","PUR090424104","","SU","14","0.00","306360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","306360.00","0","","","2024-04-09","2024-04-09","306360.00","0.00","","LE_2","","0","1","2024-04-09 08:39:23","0");
INSERT INTO tbl_purchase VALUES("182","PUR090424105","","SU","14","0.00","318600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","318600.00","0","","","2024-04-09","2024-04-09","318600.00","0.00","","LE_2","","0","1","2024-04-09 08:39:28","0");
INSERT INTO tbl_purchase VALUES("183","PUR090424106","","SU","14","0.00","60120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60120.00","0","","","2024-04-09","2024-04-09","60120.00","0.00","","LE_2","","0","1","2024-04-09 08:39:28","0");
INSERT INTO tbl_purchase VALUES("184","PUR090424107","","SU","14","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2024-04-09","2024-04-09","30600.00","0.00","","LE_2","","0","1","2024-04-09 08:39:28","0");
INSERT INTO tbl_purchase VALUES("185","PUR090424108","","SU","14","0.00","306360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","306360.00","0","","","2024-04-09","2024-04-09","306360.00","0.00","","LE_2","","0","1","2024-04-09 08:39:28","0");
INSERT INTO tbl_purchase VALUES("186","PUR090424109","","SU","10","0.00","123000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","123000.00","0","","","2024-04-09","","123000.00","0.00","","LE_2","","0","1","2024-04-09 10:46:49","0");
INSERT INTO tbl_purchase VALUES("187","PUR090424110","","SU","10","0.00","27060.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27060.00","0","","","2024-04-09","","27060.00","0.00","","LE_2","","0","1","2024-04-09 11:25:52","0");
INSERT INTO tbl_purchase VALUES("188","PUR090424111","","SU","14","0.00","183000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","183000.00","0","","","2024-04-09","2024-04-09","183000.00","0.00","","LE_2","","0","1","2024-04-09 12:31:49","0");
INSERT INTO tbl_purchase VALUES("189","PUR090424112","","SU","10","0.00","18240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18240.00","0","","","2024-04-09","","18240.00","0.00","","LE_2","","0","1","2024-04-09 02:11:39","0");
INSERT INTO tbl_purchase VALUES("190","PUR090424113","","SU","14","0.00","383400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","383400.00","0","","","2024-04-09","2024-04-09","383400.00","0.00","","LE_2","","0","1","2024-04-09 07:23:10","0");
INSERT INTO tbl_purchase VALUES("191","PUR090424114","","SU","14","0.00","5400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5400.00","0","","","2024-04-09","2024-04-09","5400.00","0.00","","LE_2","","0","1","2024-04-09 07:23:10","0");
INSERT INTO tbl_purchase VALUES("192","PUR090424115","","SU","14","0.00","115884.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115884.00","0","","","2024-04-09","2024-04-09","115884.00","0.00","","LE_2","","0","1","2024-04-09 07:23:10","0");
INSERT INTO tbl_purchase VALUES("193","PUR100424101","","SU","14","0.00","279000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","279000.00","0","","","2024-04-10","2024-04-10","279000.00","0.00","","LE_2","","0","1","2024-04-10 07:26:32","0");
INSERT INTO tbl_purchase VALUES("194","PUR100424102","","SU","14","0.00","19800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19800.00","0","","","2024-04-10","2024-04-10","19800.00","0.00","","LE_2","","0","1","2024-04-10 07:26:32","0");
INSERT INTO tbl_purchase VALUES("195","PUR100424103","","SU","14","0.00","267732.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","267732.00","0","","","2024-04-10","2024-04-10","267732.00","0.00","","LE_2","","0","1","2024-04-10 07:26:32","0");
INSERT INTO tbl_purchase VALUES("196","PUR140424101","","SU","10","0.00","15960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15960.00","0","","","2024-04-14","","15960.00","0.00","","LE_2","","0","1","2024-04-14 08:27:02","0");
INSERT INTO tbl_purchase VALUES("197","PUR140424102","","SU","11","0.00","652800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","652800.00","0","","","2024-04-09","2024-04-21","0.00","0.00","","LE_2","","0","1","2024-04-14 09:10:14","1");
INSERT INTO tbl_purchase VALUES("198","PUR140424103","","SU","10","0.00","10.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10.00","0","","","2024-04-14","","10.00","0.00","","LE_2","","0","1","2024-04-14 06:23:56","0");
INSERT INTO tbl_purchase VALUES("199","PUR140424104","","SU","10","0.00","2.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2.00","0","","","2024-04-14","","2.00","0.00","","LE_2","","0","1","2024-04-14 06:36:05","0");
INSERT INTO tbl_purchase VALUES("200","PUR150424101","","SU","14","0.00","392400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","392400.00","0","","","2024-04-15","2024-04-15","392400.00","0.00","","LE_2","","0","1","2024-04-15 07:52:12","0");
INSERT INTO tbl_purchase VALUES("201","PUR150424102","","SU","14","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2024-04-15","2024-04-15","32400.00","0.00","","LE_2","","0","1","2024-04-15 07:52:12","0");
INSERT INTO tbl_purchase VALUES("202","PUR150424103","","SU","14","0.00","319200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","319200.00","0","","","2024-04-15","2024-04-15","319200.00","0.00","","LE_2","","0","1","2024-04-15 07:52:12","0");
INSERT INTO tbl_purchase VALUES("203","PUR150424104","","SU","14","0.00","227800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","227800.00","0","","","2024-04-15","2024-04-15","227800.00","0.00","","LE_2","","0","1","2024-04-15 02:26:52","0");
INSERT INTO tbl_purchase VALUES("204","PUR150424105","","SU","14","0.00","39690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39690.00","0","","","2024-04-15","2024-04-15","39690.00","0.00","","LE_2","","0","1","2024-04-15 04:41:24","0");
INSERT INTO tbl_purchase VALUES("205","PUR150424106","","SU","10","0.00","4.60","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4.60","0","","","2024-04-15","","4.60","0.00","","LE_2","","0","1","2024-04-15 07:41:29","0");
INSERT INTO tbl_purchase VALUES("206","PUR150424107","","SU","10","0.00","11400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11400.00","0","","","2024-04-15","","11400.00","0.00","","LE_2","","0","1","2024-04-15 07:46:06","0");
INSERT INTO tbl_purchase VALUES("207","PUR150424108","","SU","14","0.00","405150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","405150.00","0","","","2024-04-15","2024-04-15","405150.00","0.00","","LE_2","","0","1","2024-04-15 07:52:50","0");
INSERT INTO tbl_purchase VALUES("208","PUR150424109","","SU","14","0.00","33300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33300.00","0","","","2024-04-15","2024-04-15","33300.00","0.00","","LE_2","","0","1","2024-04-15 07:52:50","0");
INSERT INTO tbl_purchase VALUES("209","PUR150424110","","SU","14","0.00","23976.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23976.00","0","","","2024-04-15","2024-04-15","23976.00","0.00","","LE_2","","0","1","2024-04-15 07:52:50","0");
INSERT INTO tbl_purchase VALUES("210","PUR160424101","","SU","14","0.00","412200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","412200.00","0","","","2024-04-16","2024-04-16","412200.00","0.00","","LE_2","","0","1","2024-04-16 07:54:51","0");
INSERT INTO tbl_purchase VALUES("211","PUR160424102","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-04-16","2024-04-16","27000.00","0.00","","LE_2","","0","1","2024-04-16 07:54:51","0");
INSERT INTO tbl_purchase VALUES("212","PUR160424103","","SU","14","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2024-04-16","2024-04-16","115000.00","0.00","","LE_2","","0","1","2024-04-16 07:54:51","0");
INSERT INTO tbl_purchase VALUES("213","PUR160424104","","SU","14","0.00","77256.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77256.00","0","","","2024-04-16","2024-04-16","77256.00","0.00","","LE_2","","0","1","2024-04-16 07:54:51","0");
INSERT INTO tbl_purchase VALUES("214","PUR160424105","","SU","14","0.00","122000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","122000.00","0","","","2024-04-16","2024-04-16","122000.00","0.00","","LE_2","","0","1","2024-04-16 07:54:51","0");
INSERT INTO tbl_purchase VALUES("215","PUR160424106","","SU","10","0.00","5.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5.00","0","","","2024-04-16","","5.00","0.00","","LE_2","","0","1","2024-04-16 07:56:08","0");
INSERT INTO tbl_purchase VALUES("216","PUR160424107","","SU","24","0.00","27166.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27166.00","0","","","2024-04-16","","27166.00","0.00","","LE_2","","0","1","2024-04-16 09:01:31","1");
INSERT INTO tbl_purchase VALUES("217","PUR160424108","","SU","10","0.00","49200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49200.00","0","","","2024-04-16","","49200.00","0.00","","LE_2","","0","1","2024-04-16 09:47:13","0");
INSERT INTO tbl_purchase VALUES("218","PUR160424109","","SU","10","0.00","0.60","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","0.60","0","","","2024-04-16","","0.60","0.00","","LE_2","","0","1","2024-04-16 08:21:06","0");
INSERT INTO tbl_purchase VALUES("219","PUR160424110","","SU","14","0.00","347400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","347400.00","0","","","2024-04-16","2024-04-16","347400.00","0.00","","LE_2","","0","1","2024-04-16 08:23:32","0");
INSERT INTO tbl_purchase VALUES("220","PUR160424111","","SU","14","0.00","19800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19800.00","0","","","2024-04-16","2024-04-16","19800.00","0.00","","LE_2","","0","1","2024-04-16 08:23:32","0");
INSERT INTO tbl_purchase VALUES("221","PUR160424112","","SU","14","0.00","99900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99900.00","0","","","2024-04-16","2024-04-16","99900.00","0.00","","LE_2","","0","1","2024-04-16 08:23:32","0");
INSERT INTO tbl_purchase VALUES("222","PUR160424113","","SU","14","0.00","19392.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19392.00","0","","","2024-04-16","2024-04-16","19392.00","0.00","","LE_2","","0","1","2024-04-16 08:23:32","0");
INSERT INTO tbl_purchase VALUES("223","PUR160424114","","SU","14","0.00","158400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","158400.00","0","","","2024-04-16","2024-04-16","158400.00","0.00","","LE_2","","0","1","2024-04-16 08:41:00","0");
INSERT INTO tbl_purchase VALUES("224","PUR160424115","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-04-16","2024-04-16","18000.00","0.00","","LE_2","","0","1","2024-04-16 08:41:00","0");
INSERT INTO tbl_purchase VALUES("225","PUR170424101","","SU","14","0.00","208800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","208800.00","0","","","2024-04-17","2024-04-17","208800.00","0.00","","LE_2","","0","1","2024-04-17 08:04:58","0");
INSERT INTO tbl_purchase VALUES("226","PUR170424102","","SU","14","0.00","16200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16200.00","0","","","2024-04-17","2024-04-17","16200.00","0.00","","LE_2","","0","1","2024-04-17 08:04:58","0");
INSERT INTO tbl_purchase VALUES("227","PUR170424103","","SU","14","0.00","177156.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","177156.00","0","","","2024-04-17","2024-04-17","177156.00","0.00","","LE_2","","0","1","2024-04-17 08:04:58","0");
INSERT INTO tbl_purchase VALUES("228","PUR170424104","","SU","14","0.00","8610.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8610.00","0","","","2024-04-17","2024-04-17","8610.00","0.00","","LE_2","","0","1","2024-04-17 08:04:58","0");
INSERT INTO tbl_purchase VALUES("229","PUR170424105","","SU","10","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-04-17","","36000.00","0.00","","LE_2","","0","1","2024-04-17 08:40:28","0");
INSERT INTO tbl_purchase VALUES("230","PUR170424106","","SU","10","0.00","114077.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114077.00","0","","","2024-04-17","","114077.00","0.00","","LE_2","","0","1","2024-04-17 02:51:27","0");
INSERT INTO tbl_purchase VALUES("231","PUR170424107","","SU","10","0.00","70110.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70110.00","0","","","2024-04-17","","70110.00","0.00","","LE_2","","0","1","2024-04-17 02:52:18","0");
INSERT INTO tbl_purchase VALUES("232","PUR170424108","","SU","10","0.00","98400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","98400.00","0","","","2024-04-17","","98400.00","0.00","","LE_2","","0","1","2024-04-17 02:53:34","0");
INSERT INTO tbl_purchase VALUES("233","PUR170424109","","SU","8","0.00","373939.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","373939.00","0","","","2024-04-17","2024-04-24","0.00","0.00","","LE_2","","0","1","2024-04-17 08:48:45","1");
INSERT INTO tbl_purchase VALUES("234","PUR170424110","","SU","8","0.00","150594.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150594.00","0","","","2024-04-17","2024-04-24","0.00","0.00","","LE_2","","0","1","2024-04-17 08:49:13","1");
INSERT INTO tbl_purchase VALUES("235","PUR170424111","","SU","10","0.00","63850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63850.00","0","","","2024-04-17","","63850.00","0.00","","LE_2","","0","1","2024-04-17 08:53:18","0");
INSERT INTO tbl_purchase VALUES("236","PUR180424101","","SU","14","0.00","387000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","387000.00","0","","","2024-04-18","2024-04-18","387000.00","0.00","","LE_2","","0","1","2024-04-18 07:57:15","0");
INSERT INTO tbl_purchase VALUES("237","PUR180424102","","SU","14","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2024-04-18","2024-04-18","25200.00","0.00","","LE_2","","0","1","2024-04-18 07:57:15","0");
INSERT INTO tbl_purchase VALUES("238","PUR180424103","","SU","14","0.00","236817.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","236817.00","0","","","2024-04-18","2024-04-18","236817.00","0.00","","LE_2","","0","1","2024-04-18 07:57:15","0");
INSERT INTO tbl_purchase VALUES("239","PUR180424104","","SU","14","0.00","140220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140220.00","0","","","2024-04-18","2024-04-18","140220.00","0.00","","LE_2","","0","1","2024-04-18 07:57:15","0");
INSERT INTO tbl_purchase VALUES("240","PUR180424105","","SU","10","0.00","61040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61040.00","0","","","2024-04-18","","61040.00","0.00","","LE_2","","0","1","2024-04-18 08:22:50","0");
INSERT INTO tbl_purchase VALUES("241","PUR180424106","","SU","31","0.00","667981.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","667981.70","0","","","2024-04-18","2024-04-25","0.00","0.00","","LE_2","","0","1","2024-04-18 08:52:05","1");
INSERT INTO tbl_purchase VALUES("242","PUR180424107","","SU","31","0.00","67704.25","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67704.25","0","","","2024-04-18","2024-04-25","0.00","0.00","","LE_2","","0","1","2024-04-18 08:52:39","1");
INSERT INTO tbl_purchase VALUES("243","PUR180424108","","SU","31","0.00","664695.24","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","664695.24","0","","","2024-04-18","2024-04-25","0.00","0.00","","LE_2","","0","1","2024-04-18 08:53:10","1");
INSERT INTO tbl_purchase VALUES("244","PUR180424109","","SU","11","0.00","690000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","690000.00","0","","","2024-04-18","2024-04-25","0.00","0.00","","LE_2","","0","1","2024-04-18 02:02:40","1");
INSERT INTO tbl_purchase VALUES("245","PUR180424110","","SU","10","0.00","182400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","182400.00","0","","","2024-04-18","","182400.00","0.00","","LE_2","","0","1","2024-04-18 03:00:22","0");
INSERT INTO tbl_purchase VALUES("246","PUR180424111","","SU","10","0.00","54000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54000.00","0","","","2024-04-18","","54000.00","0.00","","LE_2","","0","1","2024-04-18 03:35:54","0");
INSERT INTO tbl_purchase VALUES("247","PUR180424112","","SU","39","0.00","30705.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30705.00","0","","","2024-04-18","","30705.00","0.00","","LE_2","","0","1","2024-04-18 05:37:50","1");
INSERT INTO tbl_purchase VALUES("248","PUR180424113","","SU","10","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2024-04-18","","21500.00","0.00","","LE_2","","0","1","2024-04-18 07:33:27","0");
INSERT INTO tbl_purchase VALUES("249","PUR180424114","","SU","14","0.00","347400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","347400.00","0","","","2024-04-18","2024-04-18","347400.00","0.00","","LE_2","","0","1","2024-04-18 08:08:43","0");
INSERT INTO tbl_purchase VALUES("250","PUR180424115","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-04-18","2024-04-18","27000.00","0.00","","LE_2","","0","1","2024-04-18 08:08:43","0");
INSERT INTO tbl_purchase VALUES("251","PUR180424116","","SU","14","0.00","282384.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","282384.00","0","","","2024-04-18","2024-04-18","282384.00","0.00","","LE_2","","0","1","2024-04-18 08:08:43","0");
INSERT INTO tbl_purchase VALUES("252","PUR180424117","","SU","14","0.00","11070.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11070.00","0","","","2024-04-18","2024-04-18","11070.00","0.00","","LE_2","","0","1","2024-04-18 08:08:43","0");
INSERT INTO tbl_purchase VALUES("253","PUR180424118","","SU","10","0.00","91200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91200.00","0","","","2024-04-18","","91200.00","0.00","","LE_2","","0","1","2024-04-18 08:09:46","0");
INSERT INTO tbl_purchase VALUES("254","PUR190424101","","SU","14","0.00","381600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","381600.00","0","","","2024-04-19","2024-04-19","381600.00","0.00","","LE_2","","0","1","2024-04-19 11:42:29","0");
INSERT INTO tbl_purchase VALUES("255","PUR190424102","","SU","14","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2024-04-19","2024-04-19","32400.00","0.00","","LE_2","","0","1","2024-04-19 11:42:29","0");
INSERT INTO tbl_purchase VALUES("256","PUR190424103","","SU","14","0.00","159460.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159460.00","0","","","2024-04-19","2024-04-19","159460.00","0.00","","LE_2","","0","1","2024-04-19 11:42:29","0");
INSERT INTO tbl_purchase VALUES("257","PUR190424104","","SU","14","0.00","65190.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65190.00","0","","","2024-04-19","2024-04-19","65190.00","0.00","","LE_2","","0","1","2024-04-19 11:42:29","0");
INSERT INTO tbl_purchase VALUES("258","PUR190424105","","SU","14","0.00","123000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","123000.00","0","","","2024-04-19","2024-04-19","123000.00","0.00","","LE_2","","0","1","2024-04-19 11:42:29","0");
INSERT INTO tbl_purchase VALUES("259","PUR190424106","","SU","12","0.00","713425.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","713425.50","0","","","2024-04-19","2024-04-26","0.00","0.00","","LE_2","","0","1","2024-04-20 08:34:40","1");
INSERT INTO tbl_purchase VALUES("260","PUR190424107","","SU","43","0.00","714286.25","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","714286.25","0","","","2024-04-19","","714286.25","0.00","","LE_2","","0","1","2024-04-19 09:52:42","1");
INSERT INTO tbl_purchase VALUES("261","PUR190424108","","SU","10","0.00","88920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88920.00","0","","","2024-04-19","","88920.00","0.00","","LE_2","","0","1","2024-04-19 10:06:05","0");
INSERT INTO tbl_purchase VALUES("262","PUR190424109","","SU","10","0.00","304985.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","304985.00","0","","","2024-04-19","","304985.00","0.00","","LE_2","","0","1","2024-04-19 10:11:55","0");
INSERT INTO tbl_purchase VALUES("263","PUR200424101","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-04-20","2024-04-20","18000.00","0.00","","LE_2","","0","1","2024-04-20 08:58:42","0");
INSERT INTO tbl_purchase VALUES("264","PUR200424102","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-04-20","2024-04-20","18000.00","0.00","","LE_2","","0","1","2024-04-20 03:28:51","0");
INSERT INTO tbl_purchase VALUES("265","PUR200424103","","SU","10","0.00","11825.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11825.00","0","","","2024-04-20","","11825.00","0.00","","LE_2","","0","1","2024-04-20 04:40:44","0");
INSERT INTO tbl_purchase VALUES("266","PUR200424104","","SU","10","0.00","0.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","0.70","0","","","2024-04-20","","0.70","0.00","","LE_2","","0","1","2024-04-20 06:27:15","0");
INSERT INTO tbl_purchase VALUES("267","PUR200424105","","SU","43","0.00","414046.25","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","414046.25","0","","","2024-04-20","","414046.25","0.00","","LE_2","","0","1","2024-04-20 06:32:33","1");
INSERT INTO tbl_purchase VALUES("268","PUR200424106","","SU","14","0.00","8064.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8064.00","0","","","2024-04-20","2024-04-20","8064.00","0.00","","LE_2","","0","1","2024-04-20 07:14:00","0");
INSERT INTO tbl_purchase VALUES("269","PUR200424107","","SU","10","0.00","10750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10750.00","0","","","2024-04-20","","10750.00","0.00","","LE_2","","0","1","2024-04-20 08:10:59","0");
INSERT INTO tbl_purchase VALUES("270","PUR200424108","","SU","10","0.00","63840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63840.00","0","","","2024-04-20","","63840.00","0.00","","LE_2","","0","1","2024-04-20 08:16:39","0");
INSERT INTO tbl_purchase VALUES("271","PUR200424109","","SU","14","0.00","378000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","378000.00","0","","","2024-04-20","2024-04-20","378000.00","0.00","","LE_2","","0","1","2024-04-20 08:31:20","0");
INSERT INTO tbl_purchase VALUES("272","PUR200424110","","SU","14","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2024-04-20","2024-04-20","32400.00","0.00","","LE_2","","0","1","2024-04-20 08:31:20","0");
INSERT INTO tbl_purchase VALUES("273","PUR200424111","","SU","14","0.00","294000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","294000.00","0","","","2024-04-20","2024-04-20","294000.00","0.00","","LE_2","","0","1","2024-04-20 08:31:20","0");
INSERT INTO tbl_purchase VALUES("274","PUR210424101","","SU","14","0.00","334800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","334800.00","0","","","2024-04-21","2024-04-21","334800.00","0.00","","LE_2","","0","1","2024-04-21 07:50:05","0");
INSERT INTO tbl_purchase VALUES("275","PUR210424102","","SU","14","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-04-21","2024-04-21","28800.00","0.00","","LE_2","","0","1","2024-04-21 07:50:05","0");
INSERT INTO tbl_purchase VALUES("276","PUR210424103","","SU","14","0.00","355887.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","355887.00","0","","","2024-04-21","2024-04-21","355887.00","0.00","","LE_2","","0","1","2024-04-21 07:50:05","0");
INSERT INTO tbl_purchase VALUES("277","PUR210424104","","SU","14","0.00","37000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37000.00","0","","","2024-04-21","2024-04-21","37000.00","0.00","","LE_2","","0","1","2024-04-21 08:29:08","0");
INSERT INTO tbl_purchase VALUES("278","PUR210424105","","SU","31","0.00","727117.60","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","727117.60","0","","","2024-04-21","2024-04-28","0.00","0.00","","LE_2","","0","1","2024-04-21 08:57:30","1");
INSERT INTO tbl_purchase VALUES("279","PUR210424106","","SU","39","0.00","150075.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150075.00","0","","","2024-04-20","","150075.00","0.00","","LE_2","","0","1","2024-04-21 10:29:50","1");
INSERT INTO tbl_purchase VALUES("280","PUR210424107","","SU","10","0.00","228000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228000.00","0","","","2024-04-21","","228000.00","0.00","","LE_2","","0","1","2024-04-21 01:00:01","0");
INSERT INTO tbl_purchase VALUES("281","PUR210424108","","SU","10","0.00","22800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22800.00","0","","","2024-04-21","","22800.00","0.00","","LE_2","","0","1","2024-04-21 01:38:00","0");
INSERT INTO tbl_purchase VALUES("282","PUR210424109","","SU","24","0.00","57800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57800.00","0","","","2024-04-21","2024-04-28","37800.00","0.00","","LE_2","","0","1","2024-04-21 02:44:25","1");
INSERT INTO tbl_purchase VALUES("283","PUR210424110","","SU","14","0.00","99900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99900.00","0","","","2024-04-21","2024-04-21","99900.00","0.00","","LE_2","","0","1","2024-04-21 06:31:54","0");
INSERT INTO tbl_purchase VALUES("284","PUR210424111","","SU","10","0.00","84360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84360.00","0","","","2024-04-21","","84360.00","0.00","","LE_2","","0","1","2024-04-21 07:23:35","0");
INSERT INTO tbl_purchase VALUES("285","PUR210424112","","SU","14","0.00","372600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","372600.00","0","","","2024-04-21","2024-04-21","372600.00","0.00","","LE_2","","0","1","2024-04-21 07:58:30","0");
INSERT INTO tbl_purchase VALUES("286","PUR210424113","","SU","14","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2024-04-21","2024-04-21","30600.00","0.00","","LE_2","","0","1","2024-04-21 07:58:30","0");
INSERT INTO tbl_purchase VALUES("287","PUR210424114","","SU","14","0.00","268840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","268840.00","0","","","2024-04-21","2024-04-21","268840.00","0.00","","LE_2","","0","1","2024-04-21 07:58:30","0");
INSERT INTO tbl_purchase VALUES("288","PUR210424115","","SU","10","0.00","2.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2.30","0","","","2024-04-21","","2.30","0.00","","LE_2","","0","1","2024-04-21 07:58:55","0");
INSERT INTO tbl_purchase VALUES("289","PUR210424116","","SU","39","0.00","34000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34000.00","0","","","2024-04-08","","34000.00","0.00","","LE_2","","0","1","2024-04-21 08:06:43","1");
INSERT INTO tbl_purchase VALUES("290","PUR210424117","","SU","10","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2024-04-21","","45000.00","0.00","","LE_2","","0","1","2024-04-21 09:04:08","0");
INSERT INTO tbl_purchase VALUES("291","PUR220424101","","SU","14","0.00","365400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","365400.00","0","","","2024-04-22","2024-04-22","365400.00","0.00","","LE_2","","0","1","2024-04-22 08:01:13","0");
INSERT INTO tbl_purchase VALUES("292","PUR220424102","","SU","14","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2024-04-22","2024-04-22","21600.00","0.00","","LE_2","","0","1","2024-04-22 08:01:13","0");
INSERT INTO tbl_purchase VALUES("293","PUR220424103","","SU","14","0.00","368200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","368200.00","0","","","2024-04-22","2024-04-22","368200.00","0.00","","LE_2","","0","1","2024-04-22 08:01:13","0");
INSERT INTO tbl_purchase VALUES("294","PUR220424104","","SU","10","0.00","52500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52500.00","0","","","2024-04-22","","52500.00","0.00","","LE_2","","0","1","2024-04-22 08:42:26","0");
INSERT INTO tbl_purchase VALUES("295","PUR220424105","","SU","31","0.00","706881.78","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","706881.78","0","","","2024-04-22","2024-04-29","0.00","0.00","","LE_2","","0","1","2024-04-22 09:30:27","1");
INSERT INTO tbl_purchase VALUES("296","PUR220424106","","SU","10","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2024-04-22","","45000.00","0.00","","LE_2","","0","1","2024-04-22 11:31:08","0");
INSERT INTO tbl_purchase VALUES("297","PUR220424107","","SU","12","0.00","779824.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","779824.00","0","","","2024-04-22","2024-04-29","0.00","0.00","","LE_2","","0","1","2024-04-22 12:11:13","1");
INSERT INTO tbl_purchase VALUES("298","PUR220424108","","SU","14","0.00","91000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91000.00","0","","","2024-04-22","2024-04-22","91000.00","0.00","","LE_2","","0","1","2024-04-22 02:59:46","0");
INSERT INTO tbl_purchase VALUES("299","PUR220424109","","SU","10","0.00","11825.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11825.00","0","","","2024-04-22","","11825.00","0.00","","LE_2","","0","1","2024-04-22 06:14:28","0");
INSERT INTO tbl_purchase VALUES("300","PUR220424110","","SU","14","0.00","26400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26400.00","0","","","2024-04-22","2024-04-22","26400.00","0.00","","LE_2","","0","1","2024-04-22 06:21:00","0");
INSERT INTO tbl_purchase VALUES("301","PUR220424111","","SU","14","0.00","54000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54000.00","0","","","2024-04-22","2024-04-22","54000.00","0.00","","LE_2","","0","1","2024-04-22 10:03:58","0");
INSERT INTO tbl_purchase VALUES("302","PUR220424112","","SU","14","0.00","144000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","144000.00","0","","","2024-04-22","2024-04-22","144000.00","0.00","","LE_2","","0","1","2024-04-22 10:03:58","0");
INSERT INTO tbl_purchase VALUES("303","PUR220424113","","SU","14","0.00","12600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12600.00","0","","","2024-04-22","2024-04-22","12600.00","0.00","","LE_2","","0","1","2024-04-22 10:03:58","0");
INSERT INTO tbl_purchase VALUES("304","PUR220424114","","SU","14","0.00","105840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105840.00","0","","","2024-04-22","2024-04-22","105840.00","0.00","","LE_2","","0","1","2024-04-22 10:03:58","0");
INSERT INTO tbl_purchase VALUES("305","PUR220424115","","SU","11","0.00","690000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","690000.00","0","","","2024-04-22","2024-04-29","0.00","0.00","","LE_2","","0","1","2024-04-22 10:05:23","1");
INSERT INTO tbl_purchase VALUES("306","PUR220424116","","SU","14","0.00","43200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43200.00","0","","","2024-04-22","2024-04-22","43200.00","0.00","","LE_2","","0","1","2024-04-22 10:11:59","0");
INSERT INTO tbl_purchase VALUES("307","PUR220424117","","SU","10","0.00","72960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72960.00","0","","","2024-04-22","","72960.00","0.00","","LE_2","","0","1","2024-04-22 10:20:53","0");
INSERT INTO tbl_purchase VALUES("308","PUR230424101","","SU","14","0.00","401400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","401400.00","0","","","2024-04-23","2024-04-23","401400.00","0.00","","LE_2","","0","1","2024-04-23 08:09:49","0");
INSERT INTO tbl_purchase VALUES("309","PUR230424102","","SU","14","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2024-04-23","2024-04-23","25200.00","0.00","","LE_2","","0","1","2024-04-23 08:09:49","0");
INSERT INTO tbl_purchase VALUES("310","PUR230424103","","SU","14","0.00","200480.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200480.00","0","","","2024-04-23","2024-04-23","200480.00","0.00","","LE_2","","0","1","2024-04-23 08:09:49","0");
INSERT INTO tbl_purchase VALUES("311","PUR230424104","","SU","14","0.00","148830.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","148830.00","0","","","2024-04-23","2024-04-23","148830.00","0.00","","LE_2","","0","1","2024-04-23 08:09:49","0");
INSERT INTO tbl_purchase VALUES("312","PUR230424105","","SU","10","0.00","2.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2.00","0","","","2024-04-23","","2.00","0.00","","LE_2","","0","1","2024-04-23 10:26:01","0");
INSERT INTO tbl_purchase VALUES("313","PUR230424106","","SU","10","0.00","142800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","142800.00","0","","","2024-04-23","","142800.00","0.00","","LE_2","","0","1","2024-04-23 05:26:05","0");
INSERT INTO tbl_purchase VALUES("314","PUR230424107","","SU","39","0.00","434290.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","434290.00","0","","","2024-04-23","","434290.00","0.00","","LE_2","","0","1","2024-04-23 06:42:42","1");
INSERT INTO tbl_purchase VALUES("315","PUR230424108","","SU","39","0.00","698700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","698700.00","0","","","2024-04-23","","698700.00","0.00","","LE_2","","0","1","2024-04-23 07:31:59","1");
INSERT INTO tbl_purchase VALUES("316","PUR230424109","","SU","39","0.00","693600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","693600.00","0","","","2024-04-23","","693600.00","0.00","","LE_2","","0","1","2024-04-23 08:58:00","1");
INSERT INTO tbl_purchase VALUES("317","PUR230424110","","SU","10","0.00","2664.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2664.00","0","","","2024-04-23","","2664.00","0.00","","LE_2","","0","1","2024-04-23 09:49:34","0");
INSERT INTO tbl_purchase VALUES("318","PUR230424111","","SU","10","0.00","63840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63840.00","0","","","2024-04-23","","63840.00","0.00","","LE_2","","0","1","2024-04-23 09:50:47","0");
INSERT INTO tbl_purchase VALUES("319","PUR230424112","","SU","39","0.00","47093.75","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47093.75","0","","","2024-04-23","","47093.75","0.00","","LE_2","","0","1","2024-04-23 10:11:39","1");
INSERT INTO tbl_purchase VALUES("320","PUR240424101","","SU","14","0.00","385200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","385200.00","0","","","2024-04-24","2024-04-24","385200.00","0.00","","LE_2","","0","1","2024-04-24 07:16:05","0");
INSERT INTO tbl_purchase VALUES("321","PUR240424102","","SU","14","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-04-24","2024-04-24","28800.00","0.00","","LE_2","","0","1","2024-04-24 07:16:05","0");
INSERT INTO tbl_purchase VALUES("322","PUR240424103","","SU","14","0.00","199800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","199800.00","0","","","2024-04-24","2024-04-24","199800.00","0.00","","LE_2","","0","1","2024-04-24 07:16:05","0");
INSERT INTO tbl_purchase VALUES("323","PUR240424104","","SU","14","0.00","61000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61000.00","0","","","2024-04-24","2024-04-24","61000.00","0.00","","LE_2","","0","1","2024-04-24 07:16:05","0");
INSERT INTO tbl_purchase VALUES("324","PUR240424105","","SU","14","0.00","69160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69160.00","0","","","2024-04-24","2024-04-24","69160.00","0.00","","LE_2","","0","1","2024-04-24 07:16:05","0");
INSERT INTO tbl_purchase VALUES("325","PUR240424106","","SU","24","0.00","53992.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","53992.00","0","","","2024-04-24","","53992.00","0.00","","LE_2","","0","1","2024-04-24 11:51:24","1");
INSERT INTO tbl_purchase VALUES("326","PUR240424107","","SU","31","0.00","708253.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","708253.70","0","","","2024-04-24","2024-05-01","0.00","0.00","","LE_2","","0","1","2024-04-24 12:25:22","1");
INSERT INTO tbl_purchase VALUES("327","PUR240424108","","SU","39","0.00","375893.75","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","375893.75","0","","","2024-04-24","","375893.75","0.00","","LE_2","","0","1","2024-04-24 08:17:52","1");
INSERT INTO tbl_purchase VALUES("328","PUR240424109","","SU","10","0.00","144000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","144000.00","0","","","2024-04-24","","144000.00","0.00","","LE_2","","0","1","2024-04-24 10:54:56","0");
INSERT INTO tbl_purchase VALUES("329","PUR250424101","","SU","14","0.00","210600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","210600.00","0","","","2024-04-25","2024-04-25","210600.00","0.00","","LE_2","","0","1","2024-04-25 09:17:53","0");
INSERT INTO tbl_purchase VALUES("330","PUR250424102","","SU","14","0.00","16200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16200.00","0","","","2024-04-25","2024-04-25","16200.00","0.00","","LE_2","","0","1","2024-04-25 09:17:53","0");
INSERT INTO tbl_purchase VALUES("331","PUR250424103","","SU","14","0.00","147852.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","147852.00","0","","","2024-04-25","2024-04-25","147852.00","0.00","","LE_2","","0","1","2024-04-25 09:17:53","0");
INSERT INTO tbl_purchase VALUES("332","PUR250424104","","SU","14","0.00","363600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","363600.00","0","","","2024-04-25","2024-04-25","363600.00","0.00","","LE_2","","0","1","2024-04-25 09:18:05","0");
INSERT INTO tbl_purchase VALUES("333","PUR250424105","","SU","14","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2024-04-25","2024-04-25","30600.00","0.00","","LE_2","","0","1","2024-04-25 09:18:05","0");
INSERT INTO tbl_purchase VALUES("334","PUR250424106","","SU","14","0.00","123000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","123000.00","0","","","2024-04-25","2024-04-25","123000.00","0.00","","LE_2","","0","1","2024-04-25 09:18:05","0");
INSERT INTO tbl_purchase VALUES("335","PUR250424107","","SU","14","0.00","205128.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","205128.00","0","","","2024-04-25","2024-04-25","205128.00","0.00","","LE_2","","0","1","2024-04-25 09:18:05","0");
INSERT INTO tbl_purchase VALUES("336","PUR250424108","","SU","10","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2024-04-25","","45000.00","0.00","","LE_2","","0","1","2024-04-25 11:30:49","0");
INSERT INTO tbl_purchase VALUES("337","PUR250424109","","SU","12","0.00","705160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","705160.00","0","","","2024-04-24","2024-05-02","0.00","0.00","","LE_2","","0","1","2024-04-25 02:28:38","1");
INSERT INTO tbl_purchase VALUES("338","PUR250424110","","SU","11","0.00","680000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","680000.00","0","","","2024-04-25","2024-05-02","0.00","0.00","","LE_2","","0","1","2024-04-25 02:37:08","1");
INSERT INTO tbl_purchase VALUES("339","PUR250424111","","SU","8","0.00","149359.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149359.00","0","","","2024-04-25","2024-05-02","0.00","0.00","","LE_2","","0","1","2024-04-25 03:46:01","1");
INSERT INTO tbl_purchase VALUES("340","PUR250424112","","SU","10","0.00","232560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","232560.00","0","","","2024-04-25","","232560.00","0.00","","LE_2","","0","1","2024-04-25 08:47:32","0");
INSERT INTO tbl_purchase VALUES("341","PUR250424113","","SU","12","0.00","769454.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","769454.00","0","","","2024-04-25","2024-05-02","0.00","0.00","","LE_2","","0","1","2024-04-25 09:40:29","1");
INSERT INTO tbl_purchase VALUES("342","PUR250424114","","SU","14","0.00","252000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","252000.00","0","","","2024-04-25","2024-04-25","252000.00","0.00","","LE_2","","0","1","2024-04-25 09:54:54","0");
INSERT INTO tbl_purchase VALUES("343","PUR250424115","","SU","14","0.00","226440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","226440.00","0","","","2024-04-25","2024-04-25","226440.00","0.00","","LE_2","","0","1","2024-04-25 09:54:54","0");
INSERT INTO tbl_purchase VALUES("344","PUR250424116","","SU","14","0.00","86100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86100.00","0","","","2024-04-25","2024-04-25","86100.00","0.00","","LE_2","","0","1","2024-04-25 09:54:54","0");
INSERT INTO tbl_purchase VALUES("345","PUR250424117","","SU","14","0.00","108720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108720.00","0","","","2024-04-25","2024-04-25","108720.00","0.00","","LE_2","","0","1","2024-04-25 09:54:54","0");
INSERT INTO tbl_purchase VALUES("346","PUR250424118","","SU","14","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2024-04-25","2024-04-25","32400.00","0.00","","LE_2","","0","1","2024-04-25 09:54:54","0");
INSERT INTO tbl_purchase VALUES("347","PUR260424101","","SU","14","0.00","356400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","356400.00","0","","","2024-04-26","2024-04-26","356400.00","0.00","","LE_2","","0","1","2024-04-26 07:59:42","0");
INSERT INTO tbl_purchase VALUES("348","PUR260424102","","SU","14","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-04-26","2024-04-26","28800.00","0.00","","LE_2","","0","1","2024-04-26 07:59:42","0");
INSERT INTO tbl_purchase VALUES("349","PUR260424103","","SU","14","0.00","197616.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197616.00","0","","","2024-04-26","2024-04-26","197616.00","0.00","","LE_2","","0","1","2024-04-26 07:59:42","0");
INSERT INTO tbl_purchase VALUES("350","PUR260424104","","SU","14","0.00","4920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4920.00","0","","","2024-04-26","2024-04-26","4920.00","0.00","","LE_2","","0","1","2024-04-26 07:59:42","0");
INSERT INTO tbl_purchase VALUES("351","PUR260424105","","SU","14","0.00","147630.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","147630.00","0","","","2024-04-26","2024-04-26","147630.00","0.00","","LE_2","","0","1","2024-04-26 07:59:42","0");
INSERT INTO tbl_purchase VALUES("352","PUR260424106","","SU","24","0.00","10914.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10914.00","0","","","2024-04-26","","10914.00","0.00","","LE_2","","0","1","2024-04-26 12:20:14","1");
INSERT INTO tbl_purchase VALUES("353","PUR260424107","","SU","11","0.00","670000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","670000.00","0","","","2024-04-26","2024-05-03","0.00","0.00","","LE_2","","0","1","2024-04-26 07:33:58","1");
INSERT INTO tbl_purchase VALUES("354","PUR270424101","","SU","24","0.00","84252.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84252.50","0","","","2024-04-27","","84252.50","0.00","","LE_2","","0","1","2024-04-27 10:51:17","1");
INSERT INTO tbl_purchase VALUES("355","PUR270424102","","SU","10","0.00","15990.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15990.00","0","","","2024-04-27","","15990.00","0.00","","LE_2","","0","1","2024-04-27 08:45:04","0");
INSERT INTO tbl_purchase VALUES("356","PUR270424103","","SU","10","0.00","3690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3690.00","0","","","2024-04-27","","3690.00","0.00","","LE_2","","0","1","2024-04-27 08:46:15","0");
INSERT INTO tbl_purchase VALUES("357","PUR270424104","","SU","10","0.00","77520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77520.00","0","","","2024-04-27","","77520.00","0.00","","LE_2","","0","1","2024-04-27 08:53:22","0");
INSERT INTO tbl_purchase VALUES("358","PUR270424105","","SU","10","0.00","6.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6.00","0","","","2024-04-27","","6.00","0.00","","LE_2","","0","1","2024-04-27 09:06:48","0");
INSERT INTO tbl_purchase VALUES("359","PUR270424106","","SU","14","0.00","284400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","284400.00","0","","","2024-04-27","2024-04-27","284400.00","0.00","","LE_2","","0","1","2024-04-27 09:16:18","0");
INSERT INTO tbl_purchase VALUES("360","PUR270424107","","SU","14","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2024-04-27","2024-04-27","40000.00","0.00","","LE_2","","0","1","2024-04-27 09:16:18","0");
INSERT INTO tbl_purchase VALUES("361","PUR270424108","","SU","14","0.00","55080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55080.00","0","","","2024-04-27","2024-04-27","55080.00","0.00","","LE_2","","0","1","2024-04-27 09:16:18","0");
INSERT INTO tbl_purchase VALUES("362","PUR270424109","","SU","14","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2024-04-27","2024-04-27","32400.00","0.00","","LE_2","","0","1","2024-04-27 09:16:18","0");
INSERT INTO tbl_purchase VALUES("363","PUR270424110","","SU","14","0.00","131610.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","131610.00","0","","","2024-04-27","2024-04-27","131610.00","0.00","","LE_2","","0","1","2024-04-27 09:16:18","0");
INSERT INTO tbl_purchase VALUES("364","PUR270424111","","SU","14","0.00","237600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","237600.00","0","","","2024-04-27","2024-04-27","237600.00","0.00","","LE_2","","0","1","2024-04-27 09:16:18","0");
INSERT INTO tbl_purchase VALUES("365","PUR280424101","","SU","14","0.00","383400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","383400.00","0","","","2024-04-28","2024-04-28","383400.00","0.00","","LE_2","","0","1","2024-04-28 08:17:41","0");
INSERT INTO tbl_purchase VALUES("366","PUR280424102","","SU","14","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-04-28","2024-04-28","36000.00","0.00","","LE_2","","0","1","2024-04-28 08:17:41","0");
INSERT INTO tbl_purchase VALUES("367","PUR280424103","","SU","14","0.00","165200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165200.00","0","","","2024-04-28","2024-04-28","165200.00","0.00","","LE_2","","0","1","2024-04-28 08:17:41","0");
INSERT INTO tbl_purchase VALUES("368","PUR280424104","","SU","14","0.00","68640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68640.00","0","","","2024-04-28","2024-04-28","68640.00","0.00","","LE_2","","0","1","2024-04-28 08:17:41","0");
INSERT INTO tbl_purchase VALUES("369","PUR280424105","","SU","14","0.00","125460.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125460.00","0","","","2024-04-28","2024-04-28","125460.00","0.00","","LE_2","","0","1","2024-04-28 08:17:41","0");
INSERT INTO tbl_purchase VALUES("370","PUR280424106","","SU","31","0.00","676356.56","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","676356.56","0","","","2024-04-28","2024-05-05","0.00","0.00","","LE_2","","0","1","2024-04-28 08:25:24","1");
INSERT INTO tbl_purchase VALUES("371","PUR280424107","","SU","10","0.00","88920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88920.00","0","","","2024-04-28","","88920.00","0.00","","LE_2","","0","1","2024-04-28 08:03:03","0");
INSERT INTO tbl_purchase VALUES("372","PUR280424108","","SU","39","0.00","40200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40200.00","0","","","2024-04-28","","40200.00","0.00","","LE_2","","0","1","2024-04-28 08:50:10","1");
INSERT INTO tbl_purchase VALUES("373","PUR290424101","","SU","14","0.00","396000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","396000.00","0","","","2024-04-29","2024-04-29","396000.00","0.00","","LE_2","","0","1","2024-04-29 07:57:30","0");
INSERT INTO tbl_purchase VALUES("374","PUR290424102","","SU","14","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2024-04-29","2024-04-29","30600.00","0.00","","LE_2","","0","1","2024-04-29 07:57:30","0");
INSERT INTO tbl_purchase VALUES("375","PUR290424103","","SU","14","0.00","345840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","345840.00","0","","","2024-04-29","2024-04-29","345840.00","0.00","","LE_2","","0","1","2024-04-29 07:57:30","0");
INSERT INTO tbl_purchase VALUES("376","PUR290424104","","SU","31","0.00","698993.24","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","698993.24","0","","","2024-04-29","2024-05-06","0.00","0.00","","LE_2","","0","1","2024-04-29 09:52:16","1");
INSERT INTO tbl_purchase VALUES("377","PUR290424105","","SU","10","0.00","45600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45600.00","0","","","2024-04-29","","45600.00","0.00","","LE_2","","0","1","2024-04-29 07:28:59","0");
INSERT INTO tbl_purchase VALUES("378","PUR290424106","","SU","10","0.00","809.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","809.00","0","","","2024-04-29","","809.00","0.00","","LE_2","","0","1","2024-04-29 08:33:20","0");
INSERT INTO tbl_purchase VALUES("379","PUR300424101","","SU","14","0.00","338400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","338400.00","0","","","2024-04-30","2024-04-30","338400.00","0.00","","LE_2","","0","1","2024-04-30 07:53:17","0");
INSERT INTO tbl_purchase VALUES("380","PUR300424102","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-04-30","2024-04-30","18000.00","0.00","","LE_2","","0","1","2024-04-30 07:53:17","0");
INSERT INTO tbl_purchase VALUES("381","PUR300424103","","SU","14","0.00","294360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","294360.00","0","","","2024-04-30","2024-04-30","294360.00","0.00","","LE_2","","0","1","2024-04-30 07:53:17","0");
INSERT INTO tbl_purchase VALUES("382","PUR300424104","","SU","31","0.00","708596.68","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","708596.68","0","","","2024-04-30","2024-05-07","0.00","0.00","","LE_2","","0","1","2024-04-30 08:51:57","1");
INSERT INTO tbl_purchase VALUES("383","PUR300424105","","SU","10","0.00","269100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","269100.00","0","","","2024-04-30","","269100.00","0.00","","LE_2","","0","1","2024-04-30 09:59:16","0");
INSERT INTO tbl_purchase VALUES("384","PUR300424106","","SU","8","0.00","149834.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149834.00","0","","","2024-04-30","2024-05-07","0.00","0.00","","LE_2","","0","1","2024-04-30 08:27:33","1");
INSERT INTO tbl_purchase VALUES("385","PUR010524101","","SU","14","0.00","367200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","367200.00","0","","","2024-05-01","2024-05-01","367200.00","0.00","","LE_2","","0","1","2024-05-01 08:26:53","0");
INSERT INTO tbl_purchase VALUES("386","PUR010524102","","SU","14","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2024-05-01","2024-05-01","25200.00","0.00","","LE_2","","0","1","2024-05-01 08:26:53","0");
INSERT INTO tbl_purchase VALUES("387","PUR010524103","","SU","14","0.00","311688.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","311688.00","0","","","2024-05-01","2024-05-01","311688.00","0.00","","LE_2","","0","1","2024-05-01 08:26:53","0");
INSERT INTO tbl_purchase VALUES("388","PUR010524104","","SU","10","0.00","68400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68400.00","0","","","2024-05-01","","68400.00","0.00","","LE_2","","0","1","2024-05-01 06:59:53","0");
INSERT INTO tbl_purchase VALUES("389","PUR010524105","","SU","10","0.00","243900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","243900.00","0","","","2024-05-01","","243900.00","0.00","","LE_2","","0","1","2024-05-01 07:55:42","0");
INSERT INTO tbl_purchase VALUES("390","PUR020524101","","SU","14","0.00","390600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","390600.00","0","","","2024-05-02","2024-05-02","390600.00","0.00","","LE_2","","0","1","2024-05-02 08:32:57","0");
INSERT INTO tbl_purchase VALUES("391","PUR020524102","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-05-02","2024-05-02","27000.00","0.00","","LE_2","","0","1","2024-05-02 08:32:57","0");
INSERT INTO tbl_purchase VALUES("392","PUR020524103","","SU","14","0.00","339150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","339150.00","0","","","2024-05-02","2024-05-02","339150.00","0.00","","LE_2","","0","1","2024-05-02 08:32:57","0");
INSERT INTO tbl_purchase VALUES("393","PUR020524104","","SU","11","0.00","660000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","660000.00","0","","","2024-05-02","2024-05-09","0.00","0.00","","LE_2","","0","1","2024-05-02 11:50:24","1");
INSERT INTO tbl_purchase VALUES("394","PUR020524105","","SU","46","0.00","264650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","264650.00","0","","","2024-05-02","2024-05-09","0.00","0.00","","LE_2","","0","1","2024-05-02 06:04:02","1");
INSERT INTO tbl_purchase VALUES("395","PUR020524106","","SU","46","0.00","668492.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","668492.50","0","","","2024-05-02","2024-05-09","0.00","0.00","","LE_2","","0","1","2024-05-02 06:04:53","1");
INSERT INTO tbl_purchase VALUES("396","PUR020524107","","SU","39","0.00","684740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","684740.00","0","","","2024-04-30","","684740.00","0.00","","LE_2","","0","1","2024-05-02 07:35:12","1");
INSERT INTO tbl_purchase VALUES("397","PUR020524108","","SU","10","0.00","18240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18240.00","0","","","2024-05-02","","18240.00","0.00","","LE_2","","0","1","2024-05-02 08:33:02","0");
INSERT INTO tbl_purchase VALUES("398","PUR030524101","","SU","14","0.00","378000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","378000.00","0","","","2024-05-03","2024-05-03","378000.00","0.00","","LE_2","","0","1","2024-05-03 08:43:51","0");
INSERT INTO tbl_purchase VALUES("399","PUR030524102","","SU","14","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-05-03","2024-05-03","28800.00","0.00","","LE_2","","0","1","2024-05-03 08:43:51","0");
INSERT INTO tbl_purchase VALUES("400","PUR030524103","","SU","14","0.00","181152.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","181152.00","0","","","2024-05-03","2024-05-03","181152.00","0.00","","LE_2","","0","1","2024-05-03 08:43:51","0");
INSERT INTO tbl_purchase VALUES("401","PUR030524104","","SU","14","0.00","123000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","123000.00","0","","","2024-05-03","2024-05-03","123000.00","0.00","","LE_2","","0","1","2024-05-03 08:43:51","0");
INSERT INTO tbl_purchase VALUES("402","PUR030524105","","SU","31","0.00","663151.83","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","663151.83","0","","","2024-05-03","2024-05-10","0.00","0.00","","LE_2","","0","1","2024-05-03 09:36:42","1");
INSERT INTO tbl_purchase VALUES("403","PUR040524101","","SU","10","0.00","1230.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1230.00","0","","","2024-05-04","","1230.00","0.00","","LE_2","","0","1","2024-05-04 01:06:11","0");
INSERT INTO tbl_purchase VALUES("404","PUR040524102","","SU","10","0.00","98400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","98400.00","0","","","2024-05-04","","98400.00","0.00","","LE_2","","0","1","2024-05-04 03:15:29","0");
INSERT INTO tbl_purchase VALUES("405","PUR050524101","","SU","14","0.00","370800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","370800.00","0","","","2024-05-05","2024-05-05","370800.00","0.00","","LE_2","","0","1","2024-05-05 08:41:35","0");
INSERT INTO tbl_purchase VALUES("406","PUR050524102","","SU","14","0.00","23400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23400.00","0","","","2024-05-05","2024-05-05","23400.00","0.00","","LE_2","","0","1","2024-05-05 08:41:35","0");
INSERT INTO tbl_purchase VALUES("407","PUR050524103","","SU","14","0.00","257070.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","257070.00","0","","","2024-05-05","2024-05-05","257070.00","0.00","","LE_2","","0","1","2024-05-05 08:41:35","0");
INSERT INTO tbl_purchase VALUES("408","PUR050524104","","SU","39","0.00","674190.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","674190.00","0","","","2024-05-05","","674190.00","0.00","","LE_2","","0","1","2024-05-05 11:13:10","1");
INSERT INTO tbl_purchase VALUES("409","PUR050524105","","SU","10","0.00","158400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","158400.00","0","","","2024-05-05","","158400.00","0.00","","LE_2","","0","1","2024-05-05 06:59:58","0");
INSERT INTO tbl_purchase VALUES("410","PUR060524101","","SU","39","0.00","100650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100650.00","0","","","2024-05-06","","100650.00","0.00","","LE_2","","0","1","2024-05-06 08:40:00","1");
INSERT INTO tbl_purchase VALUES("411","PUR060524102","","SU","39","0.00","165000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165000.00","0","","","2024-05-06","","165000.00","0.00","","LE_2","","0","1","2024-05-06 08:40:51","1");
INSERT INTO tbl_purchase VALUES("412","PUR060524103","","SU","7","0.00","610810.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","610810.00","0","","","2024-05-05","2024-05-13","0.00","0.00","","LE_2","","0","1","2024-05-06 08:43:56","1");
INSERT INTO tbl_purchase VALUES("413","PUR060524104","","SU","14","0.00","381225.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","381225.00","0","","","2024-05-06","2024-05-06","381225.00","0.00","","LE_2","","0","1","2024-05-06 09:32:23","0");
INSERT INTO tbl_purchase VALUES("414","PUR060524105","","SU","14","0.00","274896.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","274896.00","0","","","2024-05-06","2024-05-06","274896.00","0.00","","LE_2","","0","1","2024-05-06 09:32:23","0");
INSERT INTO tbl_purchase VALUES("415","PUR060524106","","SU","14","0.00","25875.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25875.00","0","","","2024-05-06","2024-05-06","25875.00","0.00","","LE_2","","0","1","2024-05-06 09:32:23","0");
INSERT INTO tbl_purchase VALUES("416","PUR070524101","","SU","10","0.00","2.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2.00","0","","","2024-05-07","","2.00","0.00","","LE_2","","0","1","2024-05-07 11:01:50","0");
INSERT INTO tbl_purchase VALUES("417","PUR070524102","","SU","14","0.00","120600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120600.00","0","","","2024-05-07","2024-05-07","120600.00","0.00","","LE_2","","0","1","2024-05-07 07:36:48","0");
INSERT INTO tbl_purchase VALUES("418","PUR070524103","","SU","14","0.00","10800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10800.00","0","","","2024-05-07","2024-05-07","10800.00","0.00","","LE_2","","0","1","2024-05-07 07:36:48","0");
INSERT INTO tbl_purchase VALUES("419","PUR070524104","","SU","14","0.00","84480.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84480.00","0","","","2024-05-07","2024-05-07","84480.00","0.00","","LE_2","","0","1","2024-05-07 07:36:48","0");
INSERT INTO tbl_purchase VALUES("420","PUR070524105","","SU","14","0.00","12300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12300.00","0","","","2024-05-07","2024-05-07","12300.00","0.00","","LE_2","","0","1","2024-05-07 07:36:48","0");
INSERT INTO tbl_purchase VALUES("421","PUR070524106","","SU","14","0.00","47520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47520.00","0","","","2024-05-07","2024-05-07","47520.00","0.00","","LE_2","","0","1","2024-05-07 07:36:48","0");
INSERT INTO tbl_purchase VALUES("422","PUR070524107","","SU","7","0.00","492975.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","492975.00","0","","","2024-05-07","2024-05-14","0.00","0.00","","LE_2","","0","1","2024-05-07 07:55:19","1");
INSERT INTO tbl_purchase VALUES("423","PUR070524108","","SU","8","0.00","115349.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115349.00","0","","","2024-05-07","2024-05-14","0.00","0.00","","LE_2","","0","1","2024-05-07 07:55:47","1");
INSERT INTO tbl_purchase VALUES("424","PUR070524109","","SU","8","0.00","662013.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","662013.00","0","","","2024-05-07","2024-05-14","0.00","0.00","","LE_2","","0","1","2024-05-07 07:56:56","1");
INSERT INTO tbl_purchase VALUES("425","PUR080524101","","SU","14","0.00","262800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","262800.00","0","","","2024-05-08","2024-05-08","262800.00","0.00","","LE_2","","0","1","2024-05-08 08:23:09","0");
INSERT INTO tbl_purchase VALUES("426","PUR080524102","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-05-08","2024-05-08","18000.00","0.00","","LE_2","","0","1","2024-05-08 08:23:09","0");
INSERT INTO tbl_purchase VALUES("427","PUR080524103","","SU","14","0.00","224900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","224900.00","0","","","2024-05-08","2024-05-08","224900.00","0.00","","LE_2","","0","1","2024-05-08 08:23:09","0");
INSERT INTO tbl_purchase VALUES("428","PUR080524104","","SU","10","0.00","42250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42250.00","0","","","2024-05-08","","42250.00","0.00","","LE_2","","0","1","2024-05-08 09:35:26","1");
INSERT INTO tbl_purchase VALUES("429","PUR080524105","","SU","8","0.00","381159.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","381159.00","0","","","2024-05-08","2024-05-15","0.00","0.00","","LE_2","","0","1","2024-05-08 09:05:52","1");
INSERT INTO tbl_purchase VALUES("430","PUR090524101","","SU","14","0.00","361800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","361800.00","0","","","2024-05-09","2024-05-09","361800.00","0.00","","LE_2","","0","1","2024-05-09 08:03:17","0");
INSERT INTO tbl_purchase VALUES("431","PUR090524102","","SU","14","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2024-05-09","2024-05-09","25200.00","0.00","","LE_2","","0","1","2024-05-09 08:03:17","0");
INSERT INTO tbl_purchase VALUES("432","PUR090524103","","SU","14","0.00","303600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","303600.00","0","","","2024-05-09","2024-05-09","303600.00","0.00","","LE_2","","0","1","2024-05-09 08:03:17","0");
INSERT INTO tbl_purchase VALUES("433","PUR090524104","","SU","10","0.00","240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","240.00","0","","","2024-05-09","","240.00","0.00","","LE_2","","0","1","2024-05-09 11:39:21","0");
INSERT INTO tbl_purchase VALUES("434","PUR090524105","","SU","8","0.00","337820.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","337820.00","0","","","2024-05-09","2024-05-16","0.00","0.00","","LE_2","","0","1","2024-05-09 04:17:49","1");
INSERT INTO tbl_purchase VALUES("435","PUR090524106","","SU","10","0.00","105400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105400.00","0","","","2024-05-09","","105400.00","0.00","","LE_2","","0","1","2024-05-09 08:47:36","0");
INSERT INTO tbl_purchase VALUES("436","PUR100524101","","SU","14","0.00","370800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","370800.00","0","","","2024-05-10","2024-05-10","370800.00","0.00","","LE_2","","0","1","2024-05-10 09:30:06","0");
INSERT INTO tbl_purchase VALUES("437","PUR100524102","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-05-10","2024-05-10","27000.00","0.00","","LE_2","","0","1","2024-05-10 09:30:06","0");
INSERT INTO tbl_purchase VALUES("438","PUR100524103","","SU","14","0.00","269280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","269280.00","0","","","2024-05-10","2024-05-10","269280.00","0.00","","LE_2","","0","1","2024-05-10 09:30:06","0");
INSERT INTO tbl_purchase VALUES("439","PUR110524101","","SU","14","0.00","221000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","221000.00","0","","","2024-05-11","2024-05-11","221000.00","0.00","","LE_2","","0","1","2024-05-11 08:23:11","0");
INSERT INTO tbl_purchase VALUES("440","PUR110524102","","SU","10","0.00","152640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","152640.00","0","","","2024-05-11","","152640.00","0.00","","LE_2","","0","1","2024-05-11 05:33:59","0");
INSERT INTO tbl_purchase VALUES("441","PUR110524103","","SU","10","0.00","158400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","158400.00","0","","","2024-05-11","","158400.00","0.00","","LE_2","","0","1","2024-05-11 05:36:44","0");
INSERT INTO tbl_purchase VALUES("442","PUR120524101","","SU","14","0.00","388800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","388800.00","0","","","2024-05-12","2024-05-12","388800.00","0.00","","LE_2","","0","1","2024-05-12 08:28:34","0");
INSERT INTO tbl_purchase VALUES("443","PUR120524102","","SU","14","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2024-05-12","2024-05-12","25200.00","0.00","","LE_2","","0","1","2024-05-12 08:28:34","0");
INSERT INTO tbl_purchase VALUES("444","PUR120524103","","SU","14","0.00","277200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","277200.00","0","","","2024-05-12","2024-05-12","277200.00","0.00","","LE_2","","0","1","2024-05-12 08:28:34","0");
INSERT INTO tbl_purchase VALUES("445","PUR120524104","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-05-12","2024-05-12","18000.00","0.00","","LE_2","","0","1","2024-05-12 07:14:05","0");
INSERT INTO tbl_purchase VALUES("446","PUR120524105","","SU","14","0.00","263340.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","263340.00","0","","","2024-05-12","2024-05-12","263340.00","0.00","","LE_2","","0","1","2024-05-12 07:14:05","0");
INSERT INTO tbl_purchase VALUES("447","PUR120524106","","SU","14","0.00","329400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","329400.00","0","","","2024-05-12","2024-05-12","329400.00","0.00","","LE_2","","0","1","2024-05-12 07:14:05","0");
INSERT INTO tbl_purchase VALUES("448","PUR120524107","","SU","39","0.00","138105.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","138105.00","0","","","2024-05-12","","138105.00","0.00","","LE_2","","0","1","2024-05-12 08:58:32","1");
INSERT INTO tbl_purchase VALUES("449","PUR130524101","","SU","10","0.00","6300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6300.00","0","","","2024-05-13","","6300.00","0.00","","LE_2","","0","1","2024-05-13 08:03:50","0");
INSERT INTO tbl_purchase VALUES("450","PUR130524102","","SU","14","0.00","460800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","460800.00","0","","","2024-05-13","2024-05-13","460800.00","0.00","","LE_2","","0","1","2024-05-13 08:51:45","0");
INSERT INTO tbl_purchase VALUES("451","PUR130524103","","SU","14","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2024-05-13","2024-05-13","32400.00","0.00","","LE_2","","0","1","2024-05-13 08:51:45","0");
INSERT INTO tbl_purchase VALUES("452","PUR130524104","","SU","14","0.00","10640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10640.00","0","","","2024-05-13","2024-05-13","10640.00","0.00","","LE_2","","0","1","2024-05-13 08:51:45","0");
INSERT INTO tbl_purchase VALUES("453","PUR130524105","","SU","14","0.00","345450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","345450.00","0","","","2024-05-13","2024-05-13","345450.00","0.00","","LE_2","","0","1","2024-05-13 08:51:45","0");
INSERT INTO tbl_purchase VALUES("454","PUR130524106","","SU","51","0.00","16031.25","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16031.25","0","","","2024-05-13","","16031.25","0.00","","LE_2","","0","1","2024-05-13 10:35:41","1");
INSERT INTO tbl_purchase VALUES("455","PUR130524107","","SU","14","0.00","370800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","370800.00","0","","","2024-05-13","2024-05-13","370800.00","0.00","","LE_2","","0","1","2024-05-13 09:18:49","0");
INSERT INTO tbl_purchase VALUES("456","PUR130524108","","SU","14","0.00","266000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266000.00","0","","","2024-05-13","2024-05-13","266000.00","0.00","","LE_2","","0","1","2024-05-13 09:18:49","0");
INSERT INTO tbl_purchase VALUES("457","PUR130524109","","SU","14","0.00","16200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16200.00","0","","","2024-05-13","2024-05-13","16200.00","0.00","","LE_2","","0","1","2024-05-13 09:18:49","0");
INSERT INTO tbl_purchase VALUES("458","PUR130524110","","SU","10","0.00","29640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29640.00","0","","","2024-05-13","","29640.00","0.00","","LE_2","","0","1","2024-05-13 09:24:37","0");
INSERT INTO tbl_purchase VALUES("459","PUR140524101","","SU","14","0.00","37625.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37625.00","0","","","2024-05-14","2024-05-14","37625.00","0.00","","LE_2","","0","1","2024-05-14 08:25:15","0");
INSERT INTO tbl_purchase VALUES("460","PUR140524102","","SU","14","0.00","313200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","313200.00","0","","","2024-05-14","2024-05-14","313200.00","0.00","","LE_2","","0","1","2024-05-14 08:25:15","0");
INSERT INTO tbl_purchase VALUES("461","PUR140524103","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-05-14","2024-05-14","27000.00","0.00","","LE_2","","0","1","2024-05-14 08:25:15","0");
INSERT INTO tbl_purchase VALUES("462","PUR140524104","","SU","14","0.00","135960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135960.00","0","","","2024-05-14","2024-05-14","135960.00","0.00","","LE_2","","0","1","2024-05-14 08:25:15","0");
INSERT INTO tbl_purchase VALUES("463","PUR140524105","","SU","14","0.00","197400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197400.00","0","","","2024-05-14","2024-05-14","197400.00","0.00","","LE_2","","0","1","2024-05-14 08:25:15","0");
INSERT INTO tbl_purchase VALUES("464","PUR140524106","","SU","39","0.00","681492.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","681492.00","0","","","2024-05-14","","681492.00","0.00","","LE_2","","0","1","2024-05-14 03:49:17","1");
INSERT INTO tbl_purchase VALUES("465","PUR140524107","","SU","10","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-05-14","","18000.00","0.00","","LE_2","","0","1","2024-05-14 06:08:56","0");
INSERT INTO tbl_purchase VALUES("466","PUR140524108","","SU","10","0.00","40500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40500.00","0","","","2024-05-14","","40500.00","0.00","","LE_2","","0","1","2024-05-14 06:39:17","0");
INSERT INTO tbl_purchase VALUES("467","PUR140524109","","SU","14","0.00","324000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","324000.00","0","","","2024-05-14","2024-05-14","324000.00","0.00","","LE_2","","0","1","2024-05-14 06:54:26","0");
INSERT INTO tbl_purchase VALUES("468","PUR140524110","","SU","14","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2024-05-14","2024-05-14","21600.00","0.00","","LE_2","","0","1","2024-05-14 06:54:26","0");
INSERT INTO tbl_purchase VALUES("469","PUR140524111","","SU","14","0.00","297920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","297920.00","0","","","2024-05-14","2024-05-14","297920.00","0.00","","LE_2","","0","1","2024-05-14 06:54:26","0");
INSERT INTO tbl_purchase VALUES("470","PUR150524101","","SU","14","0.00","266400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266400.00","0","","","2024-05-15","2024-05-15","266400.00","0.00","","LE_2","","0","1","2024-05-15 07:46:34","0");
INSERT INTO tbl_purchase VALUES("471","PUR150524102","","SU","14","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-05-15","2024-05-15","28800.00","0.00","","LE_2","","0","1","2024-05-15 07:46:34","0");
INSERT INTO tbl_purchase VALUES("472","PUR150524103","","SU","14","0.00","200640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200640.00","0","","","2024-05-15","2024-05-15","200640.00","0.00","","LE_2","","0","1","2024-05-15 07:46:34","0");
INSERT INTO tbl_purchase VALUES("473","PUR150524104","","SU","14","0.00","66420.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","66420.00","0","","","2024-05-15","2024-05-15","66420.00","0.00","","LE_2","","0","1","2024-05-15 07:46:34","0");
INSERT INTO tbl_purchase VALUES("474","PUR150524105","","SU","10","0.00","5.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5.10","0","","","2024-05-15","","5.10","0.00","","LE_2","","0","1","2024-05-15 07:51:19","0");
INSERT INTO tbl_purchase VALUES("475","PUR150524106","","SU","10","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2024-05-15","","6000.00","0.00","","LE_2","","0","1","2024-05-15 09:02:49","0");
INSERT INTO tbl_purchase VALUES("476","PUR150524107","","SU","14","0.00","225000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","225000.00","0","","","2024-05-15","2024-05-15","225000.00","0.00","","LE_2","","0","1","2024-05-15 05:53:25","0");
INSERT INTO tbl_purchase VALUES("477","PUR150524108","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-05-15","2024-05-15","18000.00","0.00","","LE_2","","0","1","2024-05-15 05:53:25","0");
INSERT INTO tbl_purchase VALUES("478","PUR150524109","","SU","14","0.00","158270.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","158270.00","0","","","2024-05-15","2024-05-15","158270.00","0.00","","LE_2","","0","1","2024-05-15 05:53:25","0");
INSERT INTO tbl_purchase VALUES("479","PUR160524101","","SU","10","0.00","8.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8.40","0","","","2024-05-16","","8.40","0.00","","LE_2","","0","1","2024-05-16 07:47:26","0");
INSERT INTO tbl_purchase VALUES("480","PUR160524102","","SU","14","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-05-16","2024-05-16","36000.00","0.00","","LE_2","","0","1","2024-05-16 07:53:59","0");
INSERT INTO tbl_purchase VALUES("481","PUR160524103","","SU","14","0.00","318600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","318600.00","0","","","2024-05-16","2024-05-16","318600.00","0.00","","LE_2","","0","1","2024-05-16 07:53:59","0");
INSERT INTO tbl_purchase VALUES("482","PUR160524104","","SU","14","0.00","357720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","357720.00","0","","","2024-05-16","2024-05-16","357720.00","0.00","","LE_2","","0","1","2024-05-16 07:53:59","0");
INSERT INTO tbl_purchase VALUES("483","PUR160524105","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-05-16","2024-05-16","27000.00","0.00","","LE_2","","0","1","2024-05-16 07:53:59","0");
INSERT INTO tbl_purchase VALUES("484","PUR160524106","","SU","14","0.00","297000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","297000.00","0","","","2024-05-16","2024-05-16","297000.00","0.00","","LE_2","","0","1","2024-05-16 06:01:08","0");
INSERT INTO tbl_purchase VALUES("485","PUR160524107","","SU","14","0.00","243390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","243390.00","0","","","2024-05-16","2024-05-16","243390.00","0.00","","LE_2","","0","1","2024-05-16 06:01:08","0");
INSERT INTO tbl_purchase VALUES("486","PUR160524108","","SU","14","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2024-05-16","2024-05-16","90000.00","0.00","","LE_2","","0","1","2024-05-16 06:01:08","0");
INSERT INTO tbl_purchase VALUES("487","PUR170524101","","SU","14","0.00","348500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","348500.00","0","","","2024-05-17","2024-05-17","348500.00","0.00","","LE_2","","0","1","2024-05-17 08:48:16","0");
INSERT INTO tbl_purchase VALUES("488","PUR170524102","","SU","14","0.00","19800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19800.00","0","","","2024-05-17","2024-05-17","19800.00","0.00","","LE_2","","0","1","2024-05-17 08:48:16","0");
INSERT INTO tbl_purchase VALUES("489","PUR170524103","","SU","14","0.00","301350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","301350.00","0","","","2024-05-17","2024-05-17","301350.00","0.00","","LE_2","","0","1","2024-05-17 08:48:16","0");
INSERT INTO tbl_purchase VALUES("490","PUR170524104","","SU","10","0.00","432000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","432000.00","0","","","2024-05-17","","432000.00","0.00","","LE_2","","0","1","2024-05-17 08:34:19","0");
INSERT INTO tbl_purchase VALUES("491","PUR180524101","","SU","10","0.00","412300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","412300.00","0","","","2024-05-18","","412300.00","0.00","","LE_2","","0","1","2024-05-18 01:52:12","0");
INSERT INTO tbl_purchase VALUES("492","PUR180524102","","SU","14","0.00","268200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","268200.00","0","","","2024-05-18","2024-05-18","268200.00","0.00","","LE_2","","0","1","2024-05-18 08:05:02","0");
INSERT INTO tbl_purchase VALUES("493","PUR180524103","","SU","14","0.00","164700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","164700.00","0","","","2024-05-18","2024-05-18","164700.00","0.00","","LE_2","","0","1","2024-05-18 08:05:02","0");
INSERT INTO tbl_purchase VALUES("494","PUR180524104","","SU","14","0.00","9000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9000.00","0","","","2024-05-18","2024-05-18","9000.00","0.00","","LE_2","","0","1","2024-05-18 08:05:02","0");
INSERT INTO tbl_purchase VALUES("495","PUR190524101","","SU","14","0.00","405000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","405000.00","0","","","2024-05-19","2024-05-19","405000.00","0.00","","LE_2","","0","1","2024-05-19 08:19:04","0");
INSERT INTO tbl_purchase VALUES("496","PUR190524102","","SU","14","0.00","236740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","236740.00","0","","","2024-05-19","2024-05-19","236740.00","0.00","","LE_2","","0","1","2024-05-19 08:19:04","0");
INSERT INTO tbl_purchase VALUES("497","PUR190524103","","SU","14","0.00","19800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19800.00","0","","","2024-05-19","2024-05-19","19800.00","0.00","","LE_2","","0","1","2024-05-19 08:19:04","0");
INSERT INTO tbl_purchase VALUES("498","PUR190524104","","SU","31","0.00","691447.68","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","691447.68","0","","","2024-05-19","2024-05-26","0.00","0.00","","LE_2","","0","1","2024-05-19 12:55:40","1");
INSERT INTO tbl_purchase VALUES("499","PUR190524105","","SU","31","0.00","546433.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","546433.30","0","","","2024-05-19","2024-05-26","0.00","0.00","","LE_2","","0","1","2024-05-21 11:32:56","1");
INSERT INTO tbl_purchase VALUES("500","PUR190524106","","SU","31","0.00","143117.33","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","143117.33","0","","","2024-05-19","2024-05-26","0.00","0.00","","LE_2","","0","1","2024-05-21 11:34:09","1");
INSERT INTO tbl_purchase VALUES("501","PUR190524107","","SU","10","0.00","91800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91800.00","0","","","2024-05-19","","91800.00","0.00","","LE_2","","0","1","2024-05-19 08:51:14","0");
INSERT INTO tbl_purchase VALUES("502","PUR190524108","","SU","14","0.00","10800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10800.00","0","","","2024-05-19","2024-05-19","10800.00","0.00","","LE_2","","0","1","2024-05-19 08:58:26","0");
INSERT INTO tbl_purchase VALUES("503","PUR190524109","","SU","14","0.00","188600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","188600.00","0","","","2024-05-19","2024-05-19","188600.00","0.00","","LE_2","","0","1","2024-05-19 08:58:26","0");
INSERT INTO tbl_purchase VALUES("504","PUR190524110","","SU","14","0.00","453600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","453600.00","0","","","2024-05-19","2024-05-19","453600.00","0.00","","LE_2","","0","1","2024-05-19 08:58:26","0");
INSERT INTO tbl_purchase VALUES("505","PUR200524101","","SU","14","0.00","385000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","385000.00","0","","","2024-05-20","2024-05-20","385000.00","0.00","","LE_2","","0","1","2024-05-20 08:56:02","0");
INSERT INTO tbl_purchase VALUES("506","PUR200524102","","SU","14","0.00","304500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","304500.00","0","","","2024-05-20","2024-05-20","304500.00","0.00","","LE_2","","0","1","2024-05-20 08:56:02","0");
INSERT INTO tbl_purchase VALUES("507","PUR200524103","","SU","14","0.00","17500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17500.00","0","","","2024-05-20","2024-05-20","17500.00","0.00","","LE_2","","0","1","2024-05-20 08:56:02","0");
INSERT INTO tbl_purchase VALUES("508","PUR200524104","","SU","14","0.00","2100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2100.00","0","","","2024-05-20","2024-05-20","2100.00","0.00","","LE_2","","0","1","2024-05-20 08:56:02","0");
INSERT INTO tbl_purchase VALUES("509","PUR200524105","","SU","14","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2024-05-20","2024-05-20","21600.00","0.00","","LE_2","","0","1","2024-05-20 08:56:02","0");
INSERT INTO tbl_purchase VALUES("512","PUR200524106","","SU","14","0.00","87500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87500.00","0","","","2024-05-20","2024-05-20","87500.00","0.00","","LE_2","","0","1","2024-05-20 09:15:12","0");
INSERT INTO tbl_purchase VALUES("513","PUR200524107","","SU","46","0.00","30280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30280.00","0","","","2024-05-20","","30280.00","0.00","","LE_2","","0","1","2024-05-20 10:55:07","1");
INSERT INTO tbl_purchase VALUES("514","PUR200524108","","SU","14","0.00","415800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","415800.00","0","","","2024-05-20","2024-05-20","415800.00","0.00","","LE_2","","0","1","2024-05-20 09:01:48","0");
INSERT INTO tbl_purchase VALUES("515","PUR200524109","","SU","14","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2024-05-20","2024-05-20","18000.00","0.00","","LE_2","","0","1","2024-05-20 09:01:48","0");
INSERT INTO tbl_purchase VALUES("516","PUR200524110","","SU","14","0.00","307230.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","307230.00","0","","","2024-05-20","2024-05-20","307230.00","0.00","","LE_2","","0","1","2024-05-20 09:01:48","0");
INSERT INTO tbl_purchase VALUES("521","PUR210524105","","SU","14","0.00","402500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","402500.00","0","","","2024-05-21","2024-05-21","402500.00","0.00","","LE_2","","0","1","2024-05-21 08:47:02","0");
INSERT INTO tbl_purchase VALUES("522","PUR210524106","","SU","14","0.00","311850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","311850.00","0","","","2024-05-21","2024-05-21","311850.00","0.00","","LE_2","","0","1","2024-05-21 08:47:02","0");
INSERT INTO tbl_purchase VALUES("523","PUR210524107","","SU","14","0.00","25850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25850.00","0","","","2024-05-21","2024-05-21","25850.00","0.00","","LE_2","","0","1","2024-05-21 08:47:02","0");
INSERT INTO tbl_purchase VALUES("524","PUR210524108","","SU","14","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","0.00","0","","","2024-05-21","2024-05-21","0.00","0.00","","LE_2","","0","1","2024-05-21 08:47:02","0");
INSERT INTO tbl_purchase VALUES("525","PUR210524109","","SU","31","0.00","668150.97","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","668150.97","0","","","2024-05-21","2024-05-28","0.00","0.00","","LE_2","","0","1","2024-05-21 11:35:10","1");
INSERT INTO tbl_purchase VALUES("526","PUR210524110","","SU","14","0.00","175000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175000.00","0","","","2024-05-21","2024-05-21","175000.00","0.00","","LE_2","","0","1","2024-05-21 06:58:46","0");
INSERT INTO tbl_purchase VALUES("527","PUR210524111","","SU","14","0.00","90720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90720.00","0","","","2024-05-21","2024-05-21","90720.00","0.00","","LE_2","","0","1","2024-05-21 06:58:46","0");
INSERT INTO tbl_purchase VALUES("528","PUR210524112","","SU","14","0.00","8750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8750.00","0","","","2024-05-21","2024-05-21","8750.00","0.00","","LE_2","","0","1","2024-05-21 06:58:46","0");
INSERT INTO tbl_purchase VALUES("529","PUR210524113","","SU","10","0.00","252000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","252000.00","0","","","2024-05-21","","252000.00","0.00","","LE_2","","0","1","2024-05-21 07:00:29","0");
INSERT INTO tbl_purchase VALUES("530","PUR220524101","","SU","14","0.00","29750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29750.00","0","","","2024-05-22","2024-05-22","29750.00","0.00","","LE_2","","0","1","2024-05-22 08:36:00","0");
INSERT INTO tbl_purchase VALUES("531","PUR220524102","","SU","14","0.00","420000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","420000.00","0","","","2024-05-22","2024-05-22","420000.00","0.00","","LE_2","","0","1","2024-05-22 08:36:00","0");
INSERT INTO tbl_purchase VALUES("532","PUR220524103","","SU","14","0.00","226200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","226200.00","0","","","2024-05-22","2024-05-22","226200.00","0.00","","LE_2","","0","1","2024-05-22 08:36:00","0");
INSERT INTO tbl_purchase VALUES("533","PUR220524104","","SU","14","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2024-05-22","2024-05-22","36000.00","0.00","","LE_2","","0","1","2024-05-22 04:02:54","0");
INSERT INTO tbl_purchase VALUES("534","PUR220524105","","SU","10","0.00","87500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87500.00","0","","","2024-05-22","","87500.00","0.00","","LE_2","","0","1","2024-05-22 06:42:52","0");
INSERT INTO tbl_purchase VALUES("535","PUR220524106","","SU","14","0.00","329400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","329400.00","0","","","2024-05-22","2024-05-22","329400.00","0.00","","LE_2","","0","1","2024-05-22 07:13:43","0");
INSERT INTO tbl_purchase VALUES("536","PUR220524107","","SU","14","0.00","192500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","192500.00","0","","","2024-05-22","2024-05-22","192500.00","0.00","","LE_2","","0","1","2024-05-22 07:13:43","0");
INSERT INTO tbl_purchase VALUES("537","PUR220524108","","SU","14","0.00","14400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14400.00","0","","","2024-05-22","2024-05-22","14400.00","0.00","","LE_2","","0","1","2024-05-22 07:13:43","0");
INSERT INTO tbl_purchase VALUES("538","PUR220524109","","SU","14","0.00","31200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31200.00","0","","","2024-05-22","2024-05-22","31200.00","0.00","","LE_2","","0","1","2024-05-22 07:13:43","0");
INSERT INTO tbl_purchase VALUES("539","PUR220524110","","SU","31","0.00","660048.08","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","660048.08","0","","","2024-05-22","2024-05-29","0.00","0.00","","LE_2","","0","1","2024-05-22 07:50:34","1");
INSERT INTO tbl_purchase VALUES("540","PUR230524101","","SU","14","0.00","313200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","313200.00","0","","","2024-05-23","2024-05-23","313200.00","0.00","","LE_2","","0","1","2024-05-23 08:41:17","0");
INSERT INTO tbl_purchase VALUES("541","PUR230524102","","SU","14","0.00","10750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10750.00","0","","","2024-05-23","2024-05-23","10750.00","0.00","","LE_2","","0","1","2024-05-23 08:41:17","0");
INSERT INTO tbl_purchase VALUES("542","PUR230524103","","SU","14","0.00","247500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","247500.00","0","","","2024-05-23","2024-05-23","247500.00","0.00","","LE_2","","0","1","2024-05-23 08:41:17","0");
INSERT INTO tbl_purchase VALUES("543","PUR230524104","","SU","14","0.00","4530.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4530.00","0","","","2024-05-23","2024-05-23","4530.00","0.00","","LE_2","","0","1","2024-05-23 08:41:17","0");
INSERT INTO tbl_purchase VALUES("544","PUR230524105","","SU","14","0.00","20700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20700.00","0","","","2024-05-23","2024-05-23","20700.00","0.00","","LE_2","","0","1","2024-05-23 08:41:17","0");
INSERT INTO tbl_purchase VALUES("545","PUR230524106","","SU","10","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2024-05-23","","56000.00","0.00","","LE_2","","0","1","2024-05-23 06:51:44","0");
INSERT INTO tbl_purchase VALUES("546","PUR230524107","","SU","14","0.00","15750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15750.00","0","","","2024-05-23","2024-05-23","15750.00","0.00","","LE_2","","0","1","2024-05-23 07:04:42","0");
INSERT INTO tbl_purchase VALUES("547","PUR230524108","","SU","14","0.00","178100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","178100.00","0","","","2024-05-23","2024-05-23","178100.00","0.00","","LE_2","","0","1","2024-05-23 07:04:42","0");
INSERT INTO tbl_purchase VALUES("548","PUR230524109","","SU","14","0.00","404250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","404250.00","0","","","2024-05-23","2024-05-23","404250.00","0.00","","LE_2","","0","1","2024-05-23 07:04:42","0");
INSERT INTO tbl_purchase VALUES("549","PUR230524110","","SU","51","0.00","24204.60","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24204.60","0","","","2024-05-23","","24204.60","0.00","","LE_2","","0","1","2024-05-23 08:05:11","1");
INSERT INTO tbl_purchase VALUES("550","PUR230524111","","SU","8","0.00","377948.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","377948.00","0","","","2024-05-23","2024-05-30","0.00","0.00","","LE_2","","0","1","2024-05-23 09:23:01","1");
INSERT INTO tbl_purchase VALUES("551","PUR240524101","","SU","14","0.00","361800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","361800.00","0","","","2024-05-24","2024-05-24","361800.00","0.00","","LE_2","","0","1","2024-05-24 09:25:22","0");
INSERT INTO tbl_purchase VALUES("552","PUR240524102","","SU","14","0.00","241500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","241500.00","0","","","2024-05-24","2024-05-24","241500.00","0.00","","LE_2","","0","1","2024-05-24 09:25:22","0");
INSERT INTO tbl_purchase VALUES("553","PUR240524103","","SU","14","0.00","15750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15750.00","0","","","2024-05-24","2024-05-24","15750.00","0.00","","LE_2","","0","1","2024-05-24 09:25:22","0");
INSERT INTO tbl_purchase VALUES("554","PUR240524104","","SU","14","0.00","16100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16100.00","0","","","2024-05-24","2024-05-24","16100.00","0.00","","LE_2","","0","1","2024-05-24 09:25:22","0");
INSERT INTO tbl_purchase VALUES("555","PUR240524105","","SU","31","0.00","657009.49","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","657009.49","0","","","2024-05-24","2024-05-31","0.00","0.00","","LE_2","","0","1","2024-05-24 12:47:14","1");
INSERT INTO tbl_purchase VALUES("556","PUR240524106","","SU","24","0.00","102000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","102000.00","0","","","2024-05-24","","102000.00","0.00","","LE_2","","0","1","2024-05-24 07:04:40","1");
INSERT INTO tbl_purchase VALUES("557","PUR250524101","","SU","10","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2024-05-25","","31500.00","0.00","","LE_2","","0","1","2024-05-25 08:18:45","0");
INSERT INTO tbl_purchase VALUES("558","PUR250524102","","SU","10","0.00","45500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45500.00","0","","","2024-05-25","","45500.00","0.00","","LE_2","","0","1","2024-05-25 08:21:52","0");
INSERT INTO tbl_purchase VALUES("559","PUR250524103","","SU","14","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2024-05-25","2024-05-25","24500.00","0.00","","LE_2","","0","1","2024-05-25 08:39:05","0");
INSERT INTO tbl_purchase VALUES("560","PUR250524104","","SU","14","0.00","379750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","379750.00","0","","","2024-05-25","2024-05-25","379750.00","0.00","","LE_2","","0","1","2024-05-25 08:39:05","0");
INSERT INTO tbl_purchase VALUES("561","PUR250524105","","SU","14","0.00","191100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","191100.00","0","","","2024-05-25","2024-05-25","191100.00","0.00","","LE_2","","0","1","2024-05-25 08:39:05","0");
INSERT INTO tbl_purchase VALUES("562","PUR250524106","","SU","11","0.00","466095.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","466095.00","0","","","2024-05-25","2024-06-01","0.00","0.00","","LE_2","","0","1","2024-05-25 08:54:37","1");
INSERT INTO tbl_purchase VALUES("563","PUR260524101","","SU","14","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2024-05-26","2024-05-26","24500.00","0.00","","LE_2","","0","1","2024-05-26 09:31:17","0");
INSERT INTO tbl_purchase VALUES("564","PUR260524102","","SU","14","0.00","357000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","357000.00","0","","","2024-05-26","2024-05-26","357000.00","0.00","","LE_2","","0","1","2024-05-26 09:31:17","0");
INSERT INTO tbl_purchase VALUES("565","PUR260524103","","SU","14","0.00","35475.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35475.00","0","","","2024-05-26","2024-05-26","35475.00","0.00","","LE_2","","0","1","2024-05-26 09:31:17","0");
INSERT INTO tbl_purchase VALUES("566","PUR260524104","","SU","14","0.00","59500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59500.00","0","","","2024-05-26","2024-05-26","59500.00","0.00","","LE_2","","0","1","2024-05-26 09:31:17","0");
INSERT INTO tbl_purchase VALUES("567","PUR260524105","","SU","14","0.00","171130.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171130.00","0","","","2024-05-26","2024-05-26","171130.00","0.00","","LE_2","","0","1","2024-05-26 09:31:17","0");
INSERT INTO tbl_purchase VALUES("568","PUR260524106","","SU","31","0.00","665112.39","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","665112.39","0","","","2024-05-26","2024-06-02","0.00","0.00","","LE_2","","0","1","2024-05-26 01:19:27","1");
INSERT INTO tbl_purchase VALUES("569","PUR260524107","","SU","31","0.00","629999.85","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","629999.85","0","","","2024-05-26","2024-06-02","0.00","0.00","","LE_2","","0","1","2024-05-26 06:27:21","1");
INSERT INTO tbl_purchase VALUES("570","PUR260524108","","SU","8","0.00","378613.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","378613.00","0","","","2024-05-26","2024-06-02","0.00","0.00","","LE_2","","0","1","2024-05-26 06:28:13","1");
INSERT INTO tbl_purchase VALUES("571","PUR260524109","","SU","14","0.00","7000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7000.00","0","","","2024-05-26","2024-05-26","7000.00","0.00","","LE_2","","0","1","2024-05-26 08:36:53","0");
INSERT INTO tbl_purchase VALUES("572","PUR260524110","","SU","14","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2024-05-26","2024-05-26","24500.00","0.00","","LE_2","","0","1","2024-05-26 08:36:53","0");
INSERT INTO tbl_purchase VALUES("573","PUR260524111","","SU","14","0.00","172800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","172800.00","0","","","2024-05-26","2024-05-26","172800.00","0.00","","LE_2","","0","1","2024-05-26 08:36:53","0");
INSERT INTO tbl_purchase VALUES("574","PUR260524112","","SU","14","0.00","107900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107900.00","0","","","2024-05-26","2024-05-26","107900.00","0.00","","LE_2","","0","1","2024-05-26 08:36:53","0");
INSERT INTO tbl_purchase VALUES("578","PUR270524101","","SU","14","0.00","329000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","329000.00","0","","","2024-05-27","2024-05-27","329000.00","0.00","","LE_2","","0","1","2024-05-27 08:45:07","0");
INSERT INTO tbl_purchase VALUES("579","PUR270524102","","SU","14","0.00","15750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15750.00","0","","","2024-05-27","2024-05-27","15750.00","0.00","","LE_2","","0","1","2024-05-27 08:45:07","0");
INSERT INTO tbl_purchase VALUES("580","PUR270524103","","SU","14","0.00","180700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180700.00","0","","","2024-05-27","2024-05-27","180700.00","0.00","","LE_2","","0","1","2024-05-27 08:45:07","0");
INSERT INTO tbl_purchase VALUES("581","PUR280524101","","SU","8","0.00","378233.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","378233.00","0","","","2024-05-28","2024-06-04","0.00","0.00","","LE_2","","0","1","2024-05-28 01:26:27","1");
INSERT INTO tbl_purchase VALUES("582","PUR280524102","","SU","14","0.00","173250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","173250.00","0","","","2024-05-28","2024-05-28","173250.00","0.00","","LE_2","","0","1","2024-05-28 08:35:39","0");
INSERT INTO tbl_purchase VALUES("583","PUR280524103","","SU","14","0.00","96000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96000.00","0","","","2024-05-28","2024-05-28","96000.00","0.00","","LE_2","","0","1","2024-05-28 08:35:39","0");
INSERT INTO tbl_purchase VALUES("584","PUR280524104","","SU","14","0.00","12250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12250.00","0","","","2024-05-28","2024-05-28","12250.00","0.00","","LE_2","","0","1","2024-05-28 08:35:39","0");
INSERT INTO tbl_purchase VALUES("585","PUR280524105","","SU","14","0.00","231400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","231400.00","0","","","2024-05-28","2024-05-28","231400.00","0.00","","LE_2","","0","1","2024-05-28 08:35:39","0");
INSERT INTO tbl_purchase VALUES("586","PUR280524106","","SU","14","0.00","61250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61250.00","0","","","2024-05-28","2024-05-28","61250.00","0.00","","LE_2","","0","1","2024-05-28 08:49:06","0");
INSERT INTO tbl_purchase VALUES("587","PUR290524101","","SU","14","0.00","350000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350000.00","0","","","2024-05-29","2024-05-29","350000.00","0.00","","LE_2","","0","1","2024-05-29 08:32:52","0");
INSERT INTO tbl_purchase VALUES("588","PUR290524102","","SU","14","0.00","30100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30100.00","0","","","2024-05-29","2024-05-29","30100.00","0.00","","LE_2","","0","1","2024-05-29 08:32:52","0");
INSERT INTO tbl_purchase VALUES("589","PUR290524103","","SU","14","0.00","15750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15750.00","0","","","2024-05-29","2024-05-29","15750.00","0.00","","LE_2","","0","1","2024-05-29 08:32:52","0");
INSERT INTO tbl_purchase VALUES("590","PUR290524104","","SU","14","0.00","223600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","223600.00","0","","","2024-05-29","2024-05-29","223600.00","0.00","","LE_2","","0","1","2024-05-29 08:32:52","0");
INSERT INTO tbl_purchase VALUES("597","PUR290524105","","SU","25","0.00","677110.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","677110.00","0","","","2024-05-29","2024-06-05","0.00","0.00","","LE_2","","0","1","2024-05-29 08:44:10","1");
INSERT INTO tbl_purchase VALUES("598","PUR290524106","","SU","14","0.00","8750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8750.00","0","","","2024-05-29","2024-05-29","8750.00","0.00","","LE_2","","0","1","2024-05-29 08:47:44","0");
INSERT INTO tbl_purchase VALUES("599","PUR290524107","","SU","14","0.00","183750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","183750.00","0","","","2024-05-29","2024-05-29","183750.00","0.00","","LE_2","","0","1","2024-05-29 08:47:44","0");
INSERT INTO tbl_purchase VALUES("600","PUR290524108","","SU","14","0.00","65250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65250.00","0","","","2024-05-29","2024-05-29","65250.00","0.00","","LE_2","","0","1","2024-05-29 08:47:44","0");
INSERT INTO tbl_purchase VALUES("601","PUR290524109","","SU","14","0.00","136500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","136500.00","0","","","2024-05-29","2024-05-29","136500.00","0.00","","LE_2","","0","1","2024-05-29 08:47:44","0");
INSERT INTO tbl_purchase VALUES("602","PUR290524110","","SU","14","0.00","13200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13200.00","0","","","2024-05-29","2024-05-29","13200.00","0.00","","LE_2","","0","1","2024-05-29 08:47:44","0");
INSERT INTO tbl_purchase VALUES("603","PUR300524101","","SU","14","0.00","401200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","401200.00","0","","","2024-05-30","2024-05-30","401200.00","0.00","","LE_2","","0","1","2024-05-30 08:43:00","0");
INSERT INTO tbl_purchase VALUES("604","PUR300524102","","SU","14","0.00","214630.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","214630.00","0","","","2024-05-30","2024-05-30","214630.00","0.00","","LE_2","","0","1","2024-05-30 08:43:00","0");
INSERT INTO tbl_purchase VALUES("605","PUR300524103","","SU","14","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2024-05-30","2024-05-30","17000.00","0.00","","LE_2","","0","1","2024-05-30 08:43:00","0");
INSERT INTO tbl_purchase VALUES("606","PUR300524104","","SU","43","0.00","286867.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","286867.50","0","","","2024-05-30","2024-06-06","0.00","0.00","","LE_2","","0","1","2024-05-30 06:28:44","1");
INSERT INTO tbl_purchase VALUES("607","PUR300524105","","SU","39","0.00","695278.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","695278.00","0","","","2024-05-30","","695278.00","0.00","","LE_2","","0","1","2024-05-30 09:25:52","1");
INSERT INTO tbl_purchase VALUES("608","PUR300524106","","SU","14","0.00","260750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","260750.00","0","","","2024-05-30","2024-05-30","260750.00","0.00","","LE_2","","0","1","2024-05-30 09:40:11","0");
INSERT INTO tbl_purchase VALUES("609","PUR300524107","","SU","14","0.00","7000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7000.00","0","","","2024-05-30","2024-05-30","7000.00","0.00","","LE_2","","0","1","2024-05-30 09:40:11","0");
INSERT INTO tbl_purchase VALUES("610","PUR300524108","","SU","14","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2024-05-30","2024-05-30","35000.00","0.00","","LE_2","","0","1","2024-05-30 09:40:11","0");
INSERT INTO tbl_purchase VALUES("611","PUR300524109","","SU","14","0.00","145600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","145600.00","0","","","2024-05-30","2024-05-30","145600.00","0.00","","LE_2","","0","1","2024-05-30 09:40:11","0");
INSERT INTO tbl_purchase VALUES("612","PUR300524110","","SU","14","0.00","111600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","111600.00","0","","","2024-05-30","2024-05-30","111600.00","0.00","","LE_2","","0","1","2024-05-30 09:40:11","0");
INSERT INTO tbl_purchase VALUES("617","PUR310524101","","SU","14","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2024-05-31","2024-05-31","21000.00","0.00","","LE_2","","0","1","2024-05-31 09:27:07","0");
INSERT INTO tbl_purchase VALUES("618","PUR310524102","","SU","14","0.00","381500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","381500.00","0","","","2024-05-31","2024-05-31","381500.00","0.00","","LE_2","","0","1","2024-05-31 09:27:07","0");
INSERT INTO tbl_purchase VALUES("619","PUR310524103","","SU","14","0.00","172900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","172900.00","0","","","2024-05-31","2024-05-31","172900.00","0.00","","LE_2","","0","1","2024-05-31 09:27:07","0");
INSERT INTO tbl_purchase VALUES("620","PUR310524104","","SU","14","0.00","64800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64800.00","0","","","2024-05-31","2024-05-31","64800.00","0.00","","LE_2","","0","1","2024-05-31 09:27:07","0");
INSERT INTO tbl_purchase VALUES("621","PUR310524105","","SU","31","0.00","723520.73","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","723520.73","0","","","2024-05-31","2024-06-07","0.00","0.00","","LE_2","","0","1","2024-05-31 10:41:25","1");
INSERT INTO tbl_purchase VALUES("622","PUR310524106","","SU","43","0.00","286177.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","286177.50","0","","","2024-05-31","","286177.50","0.00","","LE_2","","0","1","2024-05-31 06:04:28","1");
INSERT INTO tbl_purchase VALUES("623","PUR310524107","","SU","39","0.00","450450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450450.00","0","","","2024-05-31","","450450.00","0.00","","LE_2","","0","1","2024-05-31 08:25:24","1");
INSERT INTO tbl_purchase VALUES("624","PUR010624101","","SU","10","0.00","13440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13440.00","0","","","2024-06-01","2024-06-08","0.00","0.00","","LE_2","","0","1","2024-06-01 09:19:26","0");
INSERT INTO tbl_purchase VALUES("625","PUR010624102","","SU","14","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-06-01","2024-06-01","19250.00","0.00","","LE_2","","0","1","2024-06-01 09:00:00","0");
INSERT INTO tbl_purchase VALUES("626","PUR010624103","","SU","14","0.00","341250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","341250.00","0","","","2024-06-01","2024-06-01","341250.00","0.00","","LE_2","","0","1","2024-06-01 09:00:00","0");
INSERT INTO tbl_purchase VALUES("627","PUR010624104","","SU","14","0.00","263900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","263900.00","0","","","2024-06-01","2024-06-01","263900.00","0.00","","LE_2","","0","1","2024-06-01 09:00:00","0");
INSERT INTO tbl_purchase VALUES("628","PUR020624101","","SU","14","0.00","389760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","389760.00","0","","","2024-06-02","2024-06-02","389760.00","0.00","","LE_2","","0","1","2024-06-02 08:18:58","0");
INSERT INTO tbl_purchase VALUES("629","PUR020624102","","SU","14","0.00","243360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","243360.00","0","","","2024-06-02","2024-06-02","243360.00","0.00","","LE_2","","0","1","2024-06-02 08:18:58","0");
INSERT INTO tbl_purchase VALUES("630","PUR020624103","","SU","14","0.00","2550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2550.00","0","","","2024-06-02","2024-06-02","2550.00","0.00","","LE_2","","0","1","2024-06-02 08:18:58","0");
INSERT INTO tbl_purchase VALUES("631","PUR020624104","","SU","14","0.00","22620.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22620.00","0","","","2024-06-02","2024-06-02","22620.00","0.00","","LE_2","","0","1","2024-06-02 08:18:58","0");
INSERT INTO tbl_purchase VALUES("632","PUR020624105","","SU","31","0.00","674565.76","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","674565.76","0","","","2024-06-02","2024-06-09","0.00","0.00","","LE_2","","0","1","2024-06-02 10:00:23","1");
INSERT INTO tbl_purchase VALUES("633","PUR020624106","","SU","11","0.00","243950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","243950.00","0","","","2024-06-02","2024-06-09","0.00","0.00","","LE_2","","0","1","2024-06-02 12:35:45","1");
INSERT INTO tbl_purchase VALUES("634","PUR020624107","","SU","11","0.00","697200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","697200.00","0","","","2024-06-02","2024-06-09","0.00","0.00","","LE_2","","0","1","2024-06-02 12:36:44","1");
INSERT INTO tbl_purchase VALUES("635","PUR020624108","","SU","14","0.00","49560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49560.00","0","","","2024-06-02","2024-06-02","49560.00","0.00","","LE_2","","0","1","2024-06-02 01:11:14","0");
INSERT INTO tbl_purchase VALUES("636","PUR020624109","","SU","43","0.00","288075.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","288075.00","0","","","2024-06-02","","288075.00","0.00","","LE_2","","0","1","2024-06-02 06:10:24","1");
INSERT INTO tbl_purchase VALUES("637","PUR020624110","","SU","14","0.00","24500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24500.00","0","","","2024-06-02","2024-06-02","24500.00","0.00","","LE_2","","0","1","2024-06-02 08:28:32","0");
INSERT INTO tbl_purchase VALUES("638","PUR020624111","","SU","14","0.00","308000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","308000.00","0","","","2024-06-02","2024-06-02","308000.00","0.00","","LE_2","","0","1","2024-06-02 08:28:32","0");
INSERT INTO tbl_purchase VALUES("639","PUR020624112","","SU","14","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2024-06-02","2024-06-02","60000.00","0.00","","LE_2","","0","1","2024-06-02 08:28:32","0");
INSERT INTO tbl_purchase VALUES("640","PUR020624113","","SU","14","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2024-06-02","2024-06-02","65000.00","0.00","","LE_2","","0","1","2024-06-02 08:28:32","0");
INSERT INTO tbl_purchase VALUES("641","PUR020624114","","SU","14","0.00","61875.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61875.00","0","","","2024-06-02","2024-06-02","61875.00","0.00","","LE_2","","0","1","2024-06-02 08:28:32","0");
INSERT INTO tbl_purchase VALUES("642","PUR020624115","","SU","14","0.00","108000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108000.00","0","","","2024-06-02","2024-06-02","108000.00","0.00","","LE_2","","0","1","2024-06-02 08:28:32","0");
INSERT INTO tbl_purchase VALUES("643","PUR030624101","","SU","14","0.00","408280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","408280.00","0","","","2024-06-03","2024-06-03","408280.00","0.00","","LE_2","","0","1","2024-06-03 08:22:26","0");
INSERT INTO tbl_purchase VALUES("644","PUR030624102","","SU","14","0.00","240640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","240640.00","0","","","2024-06-03","2024-06-03","240640.00","0.00","","LE_2","","0","1","2024-06-03 08:22:26","0");
INSERT INTO tbl_purchase VALUES("645","PUR030624103","","SU","14","0.00","24220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24220.00","0","","","2024-06-03","2024-06-03","24220.00","0.00","","LE_2","","0","1","2024-06-03 08:22:26","0");
INSERT INTO tbl_purchase VALUES("646","PUR030624104","","SU","14","0.00","11700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11700.00","0","","","2024-06-03","2024-06-03","11700.00","0.00","","LE_2","","0","1","2024-06-03 01:19:20","0");
INSERT INTO tbl_purchase VALUES("647","PUR030624105","","SU","39","0.00","667932.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","667932.50","0","","","2024-06-03","","667932.50","0.00","","LE_2","","0","1","2024-06-03 02:17:53","1");
INSERT INTO tbl_purchase VALUES("648","PUR030624106","","SU","14","0.00","175500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175500.00","0","","","2024-06-03","2024-06-03","175500.00","0.00","","LE_2","","0","1","2024-06-03 03:20:59","0");
INSERT INTO tbl_purchase VALUES("649","PUR030624107","","SU","14","0.00","178200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","178200.00","0","","","2024-06-03","2024-06-03","178200.00","0.00","","LE_2","","0","1","2024-06-03 08:45:14","0");
INSERT INTO tbl_purchase VALUES("650","PUR030624108","","SU","14","0.00","5400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5400.00","0","","","2024-06-03","2024-06-03","5400.00","0.00","","LE_2","","0","1","2024-06-03 08:45:14","0");
INSERT INTO tbl_purchase VALUES("651","PUR030624109","","SU","14","0.00","12250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12250.00","0","","","2024-06-03","2024-06-03","12250.00","0.00","","LE_2","","0","1","2024-06-03 08:45:14","0");
INSERT INTO tbl_purchase VALUES("652","PUR030624110","","SU","14","0.00","108000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108000.00","0","","","2024-06-03","2024-06-03","108000.00","0.00","","LE_2","","0","1","2024-06-03 08:45:14","0");
INSERT INTO tbl_purchase VALUES("653","PUR040624101","","SU","14","0.00","411740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","411740.00","0","","","2024-06-04","2024-06-04","411740.00","0.00","","LE_2","","0","1","2024-06-04 08:23:12","0");
INSERT INTO tbl_purchase VALUES("654","PUR040624102","","SU","14","0.00","226950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","226950.00","0","","","2024-06-04","2024-06-04","226950.00","0.00","","LE_2","","0","1","2024-06-04 08:23:12","0");
INSERT INTO tbl_purchase VALUES("655","PUR040624103","","SU","14","0.00","24220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24220.00","0","","","2024-06-04","2024-06-04","24220.00","0.00","","LE_2","","0","1","2024-06-04 08:23:12","0");
INSERT INTO tbl_purchase VALUES("656","PUR040624104","","SU","14","0.00","36500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36500.00","0","","","2024-06-04","2024-06-04","36500.00","0.00","","LE_2","","0","1","2024-06-04 02:21:35","0");
INSERT INTO tbl_purchase VALUES("657","PUR040624105","","SU","31","0.00","643842.29","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","643842.29","0","","","2024-06-04","2024-06-11","0.00","0.00","","LE_2","","0","1","2024-06-04 05:39:57","1");
INSERT INTO tbl_purchase VALUES("658","PUR040624106","","SU","39","0.00","713034.38","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","713034.38","0","","","2024-06-04","","713034.38","0.00","","LE_2","","0","1","2024-06-04 06:08:26","1");
INSERT INTO tbl_purchase VALUES("659","PUR040624107","","SU","14","0.00","24050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24050.00","0","","","2024-06-04","2024-06-04","24050.00","0.00","","LE_2","","0","1","2024-06-04 06:59:04","0");
INSERT INTO tbl_purchase VALUES("660","PUR040624108","","SU","14","0.00","336700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","336700.00","0","","","2024-06-04","2024-06-04","336700.00","0.00","","LE_2","","0","1","2024-06-04 06:59:04","0");
INSERT INTO tbl_purchase VALUES("661","PUR040624109","","SU","14","0.00","202500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","202500.00","0","","","2024-06-04","2024-06-04","202500.00","0.00","","LE_2","","0","1","2024-06-04 06:59:04","0");
INSERT INTO tbl_purchase VALUES("662","PUR040624110","","SU","14","0.00","4680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4680.00","0","","","2024-06-04","2024-06-04","4680.00","0.00","","LE_2","","0","1","2024-06-04 06:59:04","0");
INSERT INTO tbl_purchase VALUES("663","PUR040624111","","SU","7","0.00","706825.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","706825.00","0","","","2024-06-04","2024-06-11","0.00","0.00","","LE_2","","0","1","2024-06-04 08:12:32","1");
INSERT INTO tbl_purchase VALUES("664","PUR040624112","","SU","14","0.00","77850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","77850.00","0","","","2024-06-04","2024-06-04","77850.00","0.00","","LE_2","","0","1","2024-06-04 09:29:45","0");
INSERT INTO tbl_purchase VALUES("665","PUR050624101","","SU","14","0.00","359840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","359840.00","0","","","2024-06-05","2024-06-05","359840.00","0.00","","LE_2","","0","1","2024-06-05 08:34:48","0");
INSERT INTO tbl_purchase VALUES("666","PUR050624102","","SU","14","0.00","227630.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","227630.00","0","","","2024-06-05","2024-06-05","227630.00","0.00","","LE_2","","0","1","2024-06-05 08:34:48","0");
INSERT INTO tbl_purchase VALUES("667","PUR050624103","","SU","14","0.00","7680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7680.00","0","","","2024-06-05","2024-06-05","7680.00","0.00","","LE_2","","0","1","2024-06-05 08:34:48","0");
INSERT INTO tbl_purchase VALUES("668","PUR050624104","","SU","14","0.00","17300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17300.00","0","","","2024-06-05","2024-06-05","17300.00","0.00","","LE_2","","0","1","2024-06-05 08:34:48","0");
INSERT INTO tbl_purchase VALUES("669","PUR050624105","","SU","10","0.00","11000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11000.00","0","","","2024-06-05","","11000.00","0.00","","LE_2","","0","1","2024-06-05 04:07:21","0");
INSERT INTO tbl_purchase VALUES("670","PUR050624106","","SU","11","0.00","303150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","303150.00","0","","","2024-06-05","2024-06-12","0.00","0.00","","LE_2","","0","1","2024-06-05 08:30:27","1");
INSERT INTO tbl_purchase VALUES("671","PUR050624107","","SU","12","0.00","388500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","388500.00","0","","","2024-06-05","2024-06-12","0.00","0.00","","LE_2","","0","1","2024-06-05 08:31:09","1");
INSERT INTO tbl_purchase VALUES("672","PUR050624108","","SU","7","0.00","418425.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","418425.00","0","","","2024-06-05","2024-06-12","0.00","0.00","","LE_2","","0","1","2024-06-05 08:34:49","1");
INSERT INTO tbl_purchase VALUES("673","PUR050624109","","SU","2","0.00","266186.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266186.00","0","","","2024-06-05","2024-06-12","0.00","0.00","","LE_2","","0","1","2024-06-05 08:35:37","1");
INSERT INTO tbl_purchase VALUES("674","PUR050624110","","SU","14","0.00","22200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22200.00","0","","","2024-06-05","2024-06-05","22200.00","0.00","","LE_2","","0","1","2024-06-05 09:01:16","0");
INSERT INTO tbl_purchase VALUES("675","PUR050624111","","SU","14","0.00","336700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","336700.00","0","","","2024-06-05","2024-06-05","336700.00","0.00","","LE_2","","0","1","2024-06-05 09:01:16","0");
INSERT INTO tbl_purchase VALUES("676","PUR050624112","","SU","14","0.00","140000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140000.00","0","","","2024-06-05","2024-06-05","140000.00","0.00","","LE_2","","0","1","2024-06-05 09:01:16","0");
INSERT INTO tbl_purchase VALUES("677","PUR050624113","","SU","14","0.00","221940.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","221940.00","0","","","2024-06-05","2024-06-05","221940.00","0.00","","LE_2","","0","1","2024-06-05 09:01:16","0");
INSERT INTO tbl_purchase VALUES("678","PUR060624101","","SU","31","0.00","726896.94","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","726896.94","0","","","2024-06-06","2024-06-13","0.00","0.00","","LE_2","","0","1","2024-06-06 08:35:31","1");
INSERT INTO tbl_purchase VALUES("679","PUR060624102","","SU","31","0.00","687057.72","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","687057.72","0","","","2024-06-06","2024-06-13","0.00","0.00","","LE_2","","0","1","2024-06-06 08:36:52","1");
INSERT INTO tbl_purchase VALUES("680","PUR060624103","","SU","14","0.00","389250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","389250.00","0","","","2024-06-06","2024-06-06","389250.00","0.00","","LE_2","","0","1","2024-06-06 08:56:20","0");
INSERT INTO tbl_purchase VALUES("681","PUR060624104","","SU","14","0.00","267750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","267750.00","0","","","2024-06-06","2024-06-06","267750.00","0.00","","LE_2","","0","1","2024-06-06 08:56:20","0");
INSERT INTO tbl_purchase VALUES("682","PUR060624105","","SU","14","0.00","22490.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22490.00","0","","","2024-06-06","2024-06-06","22490.00","0.00","","LE_2","","0","1","2024-06-06 08:56:20","0");
INSERT INTO tbl_purchase VALUES("684","PUR060624107","","SU","14","0.00","44400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","44400.00","0","","","2024-06-06","2024-06-06","44400.00","0.00","","LE_2","","0","1","2024-06-06 02:11:07","0");
INSERT INTO tbl_purchase VALUES("685","PUR060624108","","SU","10","0.00","48440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48440.00","0","","ফেরত মাল","2024-06-06","2024-06-13","0.00","0.00","","LE_2","","0","1","2024-06-06 06:27:45","0");
INSERT INTO tbl_purchase VALUES("686","PUR060624109","","SU","14","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2024-06-06","2024-06-06","25200.00","0.00","","LE_2","","0","1","2024-06-06 06:41:04","0");
INSERT INTO tbl_purchase VALUES("687","PUR060624110","","SU","14","0.00","397800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","397800.00","0","","","2024-06-06","2024-06-06","397800.00","0.00","","LE_2","","0","1","2024-06-06 06:41:04","0");
INSERT INTO tbl_purchase VALUES("688","PUR060624111","","SU","14","0.00","139860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","139860.00","0","","","2024-06-06","2024-06-06","139860.00","0.00","","LE_2","","0","1","2024-06-06 06:41:04","0");
INSERT INTO tbl_purchase VALUES("689","PUR060624112","","SU","14","0.00","42624.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42624.00","0","","","2024-06-06","2024-06-06","42624.00","0.00","","LE_2","","0","1","2024-06-06 06:41:04","0");
INSERT INTO tbl_purchase VALUES("690","PUR060624113","","SU","39","0.00","88750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88750.00","0","","","2024-06-06","","88750.00","0.00","","LE_2","","0","1","2024-06-06 07:35:33","1");
INSERT INTO tbl_purchase VALUES("691","PUR070624101","","SU","14","0.00","423000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","423000.00","0","","","2024-06-07","2024-06-07","423000.00","0.00","","LE_2","","0","1","2024-06-07 09:02:16","0");
INSERT INTO tbl_purchase VALUES("692","PUR070624102","","SU","14","0.00","181152.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","181152.00","0","","","2024-06-07","2024-06-07","181152.00","0.00","","LE_2","","0","1","2024-06-07 09:02:16","0");
INSERT INTO tbl_purchase VALUES("693","PUR070624103","","SU","14","0.00","26640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26640.00","0","","","2024-06-07","2024-06-07","26640.00","0.00","","LE_2","","0","1","2024-06-07 09:02:16","0");
INSERT INTO tbl_purchase VALUES("694","PUR070624104","","SU","14","0.00","35712.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35712.00","0","","","2024-06-07","2024-06-07","35712.00","0.00","","LE_2","","0","1","2024-06-07 09:02:16","0");
INSERT INTO tbl_purchase VALUES("695","PUR070624105","","SU","14","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2024-06-07","2024-06-07","27000.00","0.00","","LE_2","","0","1","2024-06-07 09:02:16","0");
INSERT INTO tbl_purchase VALUES("696","PUR070624106","","SU","31","0.00","608692.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","608692.80","0","","","2024-06-07","2024-06-14","0.00","0.00","","LE_2","","0","1","2024-06-07 09:54:12","1");
INSERT INTO tbl_purchase VALUES("697","PUR070624107","","SU","31","0.00","604003.07","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","604003.07","0","","","2024-06-07","2024-06-14","0.00","0.00","","LE_2","","0","1","2024-06-07 05:11:23","1");
INSERT INTO tbl_purchase VALUES("698","PUR080624101","","SU","14","0.00","133000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133000.00","0","","","2024-06-08","2024-06-08","133000.00","0.00","","LE_2","","0","1","2024-06-08 02:12:48","0");
INSERT INTO tbl_purchase VALUES("699","PUR080624102","","SU","14","0.00","56320.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56320.00","0","","","2024-06-08","2024-06-08","56320.00","0.00","","LE_2","","0","1","2024-06-08 03:34:37","0");
INSERT INTO tbl_purchase VALUES("700","PUR080624103","","SU","14","0.00","355250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","355250.00","0","","","2024-06-08","2024-06-08","355250.00","0.00","","LE_2","","0","1","2024-06-08 08:36:16","0");
INSERT INTO tbl_purchase VALUES("701","PUR080624104","","SU","14","0.00","148200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","148200.00","0","","","2024-06-08","2024-06-08","148200.00","0.00","","LE_2","","0","1","2024-06-08 08:36:16","0");
INSERT INTO tbl_purchase VALUES("702","PUR080624105","","SU","14","0.00","10710.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10710.00","0","","","2024-06-08","2024-06-08","10710.00","0.00","","LE_2","","0","1","2024-06-08 08:36:16","0");
INSERT INTO tbl_purchase VALUES("703","PUR080624106","","SU","14","0.00","95040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95040.00","0","","","2024-06-08","2024-06-08","95040.00","0.00","","LE_2","","0","1","2024-06-08 08:36:16","0");
INSERT INTO tbl_purchase VALUES("704","PUR080624107","","SU","14","0.00","8960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8960.00","0","","","2024-06-08","2024-06-08","8960.00","0.00","","LE_2","","0","1","2024-06-08 08:36:16","0");
INSERT INTO tbl_purchase VALUES("705","PUR080624108","","SU","14","0.00","22750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22750.00","0","","","2024-06-08","2024-06-08","22750.00","0.00","","LE_2","","0","1","2024-06-08 08:36:16","0");
INSERT INTO tbl_purchase VALUES("706","PUR090624101","","SU","14","0.00","399630.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","399630.00","0","","","2024-06-09","2024-06-09","399630.00","0.00","","LE_2","","0","1","2024-06-09 08:22:46","0");
INSERT INTO tbl_purchase VALUES("707","PUR090624102","","SU","14","0.00","280500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","280500.00","0","","","2024-06-09","2024-06-09","280500.00","0.00","","LE_2","","0","1","2024-06-09 08:22:46","0");
INSERT INTO tbl_purchase VALUES("708","PUR090624103","","SU","14","0.00","17300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17300.00","0","","","2024-06-09","2024-06-09","17300.00","0.00","","LE_2","","0","1","2024-06-09 08:22:46","0");
INSERT INTO tbl_purchase VALUES("709","PUR090624104","","SU","14","0.00","195000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","195000.00","0","","","2024-06-09","2024-06-09","195000.00","0.00","","LE_2","","0","1","2024-06-09 12:16:24","0");
INSERT INTO tbl_purchase VALUES("710","PUR090624105","","SU","14","0.00","76325.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76325.00","0","","","2024-06-09","2024-06-09","76325.00","0.00","","LE_2","","0","1","2024-06-09 04:57:25","0");
INSERT INTO tbl_purchase VALUES("711","PUR090624106","","SU","14","0.00","46080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46080.00","0","","","2024-06-09","2024-06-09","46080.00","0.00","","LE_2","","0","1","2024-06-09 06:36:44","0");
INSERT INTO tbl_purchase VALUES("712","PUR090624107","","SU","14","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-06-09","2024-06-09","19250.00","0.00","","LE_2","","0","1","2024-06-09 08:36:12","0");
INSERT INTO tbl_purchase VALUES("713","PUR090624108","","SU","14","0.00","441000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","441000.00","0","","","2024-06-09","2024-06-09","441000.00","0.00","","LE_2","","0","1","2024-06-09 08:36:12","0");
INSERT INTO tbl_purchase VALUES("714","PUR090624109","","SU","14","0.00","4760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4760.00","0","","","2024-06-09","2024-06-09","4760.00","0.00","","LE_2","","0","1","2024-06-09 08:36:12","0");
INSERT INTO tbl_purchase VALUES("715","PUR090624110","","SU","10","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-06-09","","19250.00","0.00","","LE_2","","0","1","2024-06-09 08:37:28","0");
INSERT INTO tbl_purchase VALUES("716","PUR100624101","","SU","14","0.00","397900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","397900.00","0","","","2024-06-10","2024-06-10","397900.00","0.00","","LE_2","","0","1","2024-06-10 08:20:07","0");
INSERT INTO tbl_purchase VALUES("717","PUR100624102","","SU","14","0.00","263680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","263680.00","0","","","2024-06-10","2024-06-10","263680.00","0.00","","LE_2","","0","1","2024-06-10 08:20:07","0");
INSERT INTO tbl_purchase VALUES("718","PUR100624103","","SU","14","0.00","17300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17300.00","0","","","2024-06-10","2024-06-10","17300.00","0.00","","LE_2","","0","1","2024-06-10 08:20:07","0");
INSERT INTO tbl_purchase VALUES("719","PUR100624104","","SU","31","0.00","699887.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","699887.30","0","","","2024-06-10","2024-06-17","0.00","0.00","","LE_2","","0","1","2024-06-10 10:46:49","1");
INSERT INTO tbl_purchase VALUES("720","PUR100624105","","SU","14","0.00","103040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103040.00","0","","","2024-06-10","2024-06-10","103040.00","0.00","","LE_2","","0","1","2024-06-10 02:26:15","0");
INSERT INTO tbl_purchase VALUES("721","PUR100624106","","SU","14","0.00","78000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78000.00","0","","","2024-06-10","2024-06-10","78000.00","0.00","","LE_2","","0","1","2024-06-10 03:00:15","0");
INSERT INTO tbl_purchase VALUES("722","PUR100624107","","SU","14","0.00","81900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81900.00","0","","","2024-06-10","2024-06-10","81900.00","0.00","","LE_2","","0","1","2024-06-10 06:16:55","0");
INSERT INTO tbl_purchase VALUES("723","PUR100624108","","SU","14","0.00","330750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","330750.00","0","","","2024-06-10","2024-06-10","330750.00","0.00","","LE_2","","0","1","2024-06-10 06:16:55","0");
INSERT INTO tbl_purchase VALUES("724","PUR100624109","","SU","14","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2024-06-10","2024-06-10","35000.00","0.00","","LE_2","","0","1","2024-06-10 06:16:55","0");
INSERT INTO tbl_purchase VALUES("725","PUR100624110","","SU","14","0.00","22750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22750.00","0","","","2024-06-10","2024-06-10","22750.00","0.00","","LE_2","","0","1","2024-06-10 06:16:55","0");
INSERT INTO tbl_purchase VALUES("726","PUR110624101","","SU","31","0.00","637427.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","637427.50","0","","","2024-06-11","2024-06-18","0.00","0.00","","LE_2","","0","1","2024-06-11 07:52:46","1");
INSERT INTO tbl_purchase VALUES("727","PUR110624102","","SU","14","0.00","418660.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","418660.00","0","","","2024-06-11","2024-06-11","418660.00","0.00","","LE_2","","0","1","2024-06-11 08:53:16","0");
INSERT INTO tbl_purchase VALUES("728","PUR110624103","","SU","14","0.00","266240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","266240.00","0","","","2024-06-11","2024-06-11","266240.00","0.00","","LE_2","","0","1","2024-06-11 08:53:16","0");
INSERT INTO tbl_purchase VALUES("729","PUR110624104","","SU","14","0.00","22490.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22490.00","0","","","2024-06-11","2024-06-11","22490.00","0.00","","LE_2","","0","1","2024-06-11 08:53:16","0");
INSERT INTO tbl_purchase VALUES("730","PUR110624105","","SU","14","0.00","19250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19250.00","0","","","2024-06-11","2024-06-11","19250.00","0.00","","LE_2","","0","1","2024-06-11 06:59:32","0");
INSERT INTO tbl_purchase VALUES("731","PUR110624106","","SU","14","0.00","383250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","383250.00","0","","","2024-06-11","2024-06-11","383250.00","0.00","","LE_2","","0","1","2024-06-11 06:59:32","0");
INSERT INTO tbl_purchase VALUES("732","PUR110624107","","SU","14","0.00","63700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63700.00","0","","","2024-06-11","2024-06-11","63700.00","0.00","","LE_2","","0","1","2024-06-11 06:59:32","0");
INSERT INTO tbl_purchase VALUES("733","PUR110624108","","SU","14","0.00","2380.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2380.00","0","","","2024-06-11","2024-06-11","2380.00","0.00","","LE_2","","0","1","2024-06-11 06:59:32","0");
INSERT INTO tbl_purchase VALUES("734","PUR110624109","","SU","14","0.00","178080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","178080.00","0","","","2024-06-11","2024-06-11","178080.00","0.00","","LE_2","","0","1","2024-06-11 06:59:32","0");
INSERT INTO tbl_purchase VALUES("735","PUR110624110","","SU","12","0.00","1055876.25","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1055876.25","0","","","2024-06-11","2024-06-18","0.00","0.00","","LE_2","","0","1","2024-06-11 08:11:00","1");
INSERT INTO tbl_purchase VALUES("736","PUR110624111","","SU","14","0.00","34050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34050.00","0","","","2024-06-11","2024-06-11","34050.00","0.00","","LE_2","","0","1","2024-06-11 08:32:53","0");
INSERT INTO tbl_purchase VALUES("737","PUR120624101","","SU","14","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2024-06-12","2024-06-12","60000.00","0.00","","LE_2","","0","1","2024-06-12 08:36:52","0");
INSERT INTO tbl_purchase VALUES("738","PUR120624102","","SU","14","0.00","401360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","401360.00","0","","","2024-06-12","2024-06-12","401360.00","0.00","","LE_2","","0","1","2024-06-12 08:41:37","0");
INSERT INTO tbl_purchase VALUES("739","PUR120624103","","SU","14","0.00","22490.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22490.00","0","","","2024-06-12","2024-06-12","22490.00","0.00","","LE_2","","0","1","2024-06-12 08:41:37","0");
INSERT INTO tbl_purchase VALUES("740","PUR120624104","","SU","14","0.00","128000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128000.00","0","","","2024-06-12","2024-06-12","128000.00","0.00","","LE_2","","0","1","2024-06-12 08:41:37","0");
INSERT INTO tbl_purchase VALUES("741","PUR120624105","","SU","14","0.00","118675.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","118675.00","0","","","2024-06-12","2024-06-12","118675.00","0.00","","LE_2","","0","1","2024-06-12 08:41:37","0");
INSERT INTO tbl_purchase VALUES("742","PUR120624106","","SU","31","0.00","699203.36","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","699203.36","0","","","2024-06-12","2024-06-19","0.00","0.00","","LE_2","","0","1","2024-06-12 07:45:16","1");
INSERT INTO tbl_purchase VALUES("743","PUR120624107","","SU","39","0.00","108275.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108275.00","0","","","2024-06-12","","108275.00","0.00","","LE_2","","0","1","2024-06-12 03:06:26","1");
INSERT INTO tbl_purchase VALUES("744","PUR120624108","","SU","14","0.00","128000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128000.00","0","","","2024-06-12","2024-06-12","128000.00","0.00","","LE_2","","0","1","2024-06-12 04:16:05","0");
INSERT INTO tbl_purchase VALUES("745","PUR120624109","","SU","31","0.00","40286.17","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40286.17","0","","","2024-06-12","2024-06-19","0.00","0.00","","LE_2","","0","1","2024-06-12 07:47:02","1");
INSERT INTO tbl_purchase VALUES("746","PUR120624110","","SU","14","0.00","43890.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43890.00","0","","","2024-06-12","2024-06-12","43890.00","0.00","","LE_2","","0","1","2024-06-12 08:08:49","0");
INSERT INTO tbl_purchase VALUES("747","PUR120624111","","SU","14","0.00","406000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","406000.00","0","","","2024-06-12","2024-06-12","406000.00","0.00","","LE_2","","0","1","2024-06-12 08:08:49","0");
INSERT INTO tbl_purchase VALUES("748","PUR120624112","","SU","14","0.00","15750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15750.00","0","","","2024-06-12","2024-06-12","15750.00","0.00","","LE_2","","0","1","2024-06-12 08:08:49","0");
INSERT INTO tbl_purchase VALUES("749","PUR120624113","","SU","10","0.00","10640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10640.00","0","","","2024-06-12","2024-06-19","0.00","0.00","","LE_2","","0","1","2024-06-12 08:14:27","0");
INSERT INTO tbl_purchase VALUES("750","PUR120624114","","SU","39","0.00","136852.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","136852.50","0","","","2024-06-12","","136852.50","0.00","","LE_2","","0","1","2024-06-12 08:50:55","1");
INSERT INTO tbl_purchase VALUES("751","PUR130624101","","SU","14","0.00","449800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","449800.00","0","","","2024-06-13","2024-06-13","449800.00","0.00","","LE_2","","0","1","2024-06-13 08:35:56","0");
INSERT INTO tbl_purchase VALUES("752","PUR130624102","","SU","14","0.00","20760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20760.00","0","","","2024-06-13","2024-06-13","20760.00","0.00","","LE_2","","0","1","2024-06-13 08:35:56","0");
INSERT INTO tbl_purchase VALUES("753","PUR130624103","","SU","14","0.00","224315.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","224315.00","0","","","2024-06-13","2024-06-13","224315.00","0.00","","LE_2","","0","1","2024-06-13 08:35:56","0");
INSERT INTO tbl_purchase VALUES("754","PUR130624104","","SU","14","0.00","3840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3840.00","0","","","2024-06-13","2024-06-13","3840.00","0.00","","LE_2","","0","1","2024-06-13 08:35:56","0");
INSERT INTO tbl_purchase VALUES("755","PUR130624105","","SU","31","0.00","688295.72","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","688295.72","0","","","2024-06-13","2024-06-20","0.00","0.00","","LE_2","","0","1","2024-06-13 10:01:15","1");
INSERT INTO tbl_purchase VALUES("756","PUR130624106","","SU","31","0.00","683697.65","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","683697.65","0","","","2024-06-13","2024-06-20","0.00","0.00","","LE_2","","0","1","2024-06-13 10:54:27","1");
INSERT INTO tbl_purchase VALUES("757","PUR130624107","","SU","14","0.00","31500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31500.00","0","","","2024-06-13","2024-06-13","31500.00","0.00","","LE_2","","0","1","2024-06-13 03:11:43","0");
INSERT INTO tbl_purchase VALUES("758","PUR130624108","","SU","14","0.00","22750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22750.00","0","","","2024-06-13","2024-06-13","22750.00","0.00","","LE_2","","0","1","2024-06-13 09:45:59","0");
INSERT INTO tbl_purchase VALUES("759","PUR130624109","","SU","14","0.00","428750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","428750.00","0","","","2024-06-13","2024-06-13","428750.00","0.00","","LE_2","","0","1","2024-06-13 09:45:59","0");
INSERT INTO tbl_purchase VALUES("760","PUR130624110","","SU","14","0.00","41440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41440.00","0","","","2024-06-13","2024-06-13","41440.00","0.00","","LE_2","","0","1","2024-06-13 09:45:59","0");
INSERT INTO tbl_purchase VALUES("761","PUR130624111","","SU","14","0.00","180700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180700.00","0","","","2024-06-13","2024-06-13","180700.00","0.00","","LE_2","","0","1","2024-06-13 09:45:59","0");
INSERT INTO tbl_purchase VALUES("762","PUR140624101","","SU","31","0.00","728970.96","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","728970.96","0","","","2024-06-14","2024-06-21","0.00","0.00","","LE_2","","0","1","2024-06-14 08:46:45","1");
INSERT INTO tbl_purchase VALUES("763","PUR140624102","","SU","31","0.00","712347.17","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","712347.17","0","","","2024-06-14","2024-06-21","0.00","0.00","","LE_2","","0","1","2024-06-14 08:48:31","1");
INSERT INTO tbl_purchase VALUES("764","PUR140624103","","SU","14","0.00","33250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33250.00","0","","","2024-06-14","2024-06-14","33250.00","0.00","","LE_2","","0","1","2024-06-14 06:36:08","0");
INSER