
<?php $__env->startSection("title"); ?> Dashboard <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
.avatar_img{
    width: 25px;
    height: 25px;
    border-radius: 50%;   
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
    <div class="col-md-6">
        <div class="row">
            <div class="col-md-6">
                <div class="info-box">
                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-users"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Users</span>
                        <span class="info-box-number"><?php echo e($total_users); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-info elevation-1"><i class="fas fa-boxes-stacked"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Products</span>
                        <span class="info-box-number"><?php echo e($total_products); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box">
                    <span class="info-box-icon bg-danger elevation-1"><i class="fas fa-clipboard-list"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Active Orders</span>
                        <span class="info-box-number"><?php echo e($incomplete_orders); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-primary elevation-1"><i class="fas fa-b"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Brands</span>
                        <span class="info-box-number"><?php echo e($total_brands); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box">
                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-sitemap"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Categories</span>
                        <span class="info-box-number"><?php echo e($total_category); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-table-list"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Sub-Categories</span>
                        <span class="info-box-number"><?php echo e($total_sub_category); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-info elevation-1"><i class="fas fa-ticket"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Coupons</span>
                        <span class="info-box-number"><?php echo e($total_coupons); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-success elevation-1"><i class="fas fa-bolt"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Flash Sale Items</span>
                        <span class="info-box-number"><?php echo e($total_flash_sale); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-secondary elevation-1"><i class="fas fa-tags"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Best Deals Items</span>
                        <span class="info-box-number"><?php echo e($total_best_deals); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="info-box mb-3">
                    <span class="info-box-icon bg-warning elevation-1"><i class="fas fa-thumbs-up"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Recommended</span>
                        <span class="info-box-number"><?php echo e($total_recommends); ?></span>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <div class="col-md-6">
        <div class="card card-body">
            <span class="text-muted text-center">Orders by Payment Method</span>
            <div>
                <canvas id="paymentMethodChart" width="400"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card card-body">
            <span class="text-muted text-center">Monthly Orders</span>
            <canvas id="monthlyOrderChart" height="400"></canvas>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card card-body">
            <span class="text-muted text-center">Monthly Revenue</span>
            <canvas id="monthlyRevenueChart" height="400"></canvas>
        </div>
    </div>
</div>

<div class="row">
<div class="col-12">
    <small class="text-muted"><i class="fa-solid fa-landmark"></i> Recent Payments</small>
    <table class="table table-striped bg-white text-center">
        <thead>
            <tr>
                <th>User</th>
                <th><i class="fa-solid fa-bangladeshi-taka-sign"></i> Amount</th>
                <th>Order ID</th>
                <th>Transaction ID</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $recent_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td>
                        <a href="<?php echo e(route('admin_users_view', ['uid' => $payment->user->id])); ?>" class="text-dark"><img src="<?php echo e(Storage::url($payment->user->avatar)); ?>" class="img-fluid avatar_img">
                        <?php echo e($payment->user->full_name); ?></a>
                    </td>
                    <td><?php echo e($payment->amount); ?></td>
                    <td><?php echo e($payment->order_id); ?></td>
                    <td><?php echo e($payment->tran_id); ?></td>
                    <td>
                        <?php if($payment->status == 'Pending'): ?>
                            <span class="badge badge-warning">Pending</span>
                        <?php elseif($payment->status == 'Failed'): ?>
                            <span class="badge badge-danger">Failed</span>
                        <?php elseif($payment->status == 'Cancel'): ?>
                            <span class="badge badge-secondary">Cancelled</span>
                        <?php elseif($payment->status == 'Complete' || $payment->status == 'Processing'): ?>
                            <span class="badge badge-success"><?php echo e(ucfirst($payment->status)); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5">no payments!</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const paymentsByDay = <?php echo json_encode($paymentsByDay, 15, 512) ?>;
    const ordersByDay = <?php echo json_encode($ordersByDay, 15, 512) ?>;
    const labels = Array.from({ length: paymentsByDay.length }, (_, index) => (index + 1).toString());

    new Chart(document.getElementById('monthlyOrderChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Orders',
                data: ordersByDay,
                borderColor: '#f79f1f',
                backgroundColor: '#f79f1f',
                fill: true
            }]
        },
        options: {
            responsive: true,
            scales: {
                x: {
                    beginAtZero: true
                },
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    new Chart(document.getElementById('monthlyRevenueChart').getContext('2d'), {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'Revenue',
                data: paymentsByDay,
                borderColor: '#28a745d1',
                backgroundColor: '#28a745d1',
                fill: true
            }]
        },
        options: {
            responsive: true,
            scales: {
                x: {
                    beginAtZero: true
                },
                y: {
                    beginAtZero: true
                }
            }
        }
    });
    new Chart(document.getElementById('paymentMethodChart').getContext('2d'), {
        type: 'doughnut',
        data: {
            labels: ['Digital Payments', 'Cash on Delivery'],
            datasets: [{
                data: [<?php echo e($payWithSslCount); ?>, <?php echo e($cashOnDeliveryCount); ?>],
                backgroundColor: ['#36A2EB', '#FF6384']
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top'
                }
            }
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yasiritc/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>