
<?php $__env->startSection("title"); ?> ComputerShop - <?php echo e($product->title); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
div.product_info_wrapper{
    box-shadow: 0px 0px 5px 1px rgba(0,0,0,.075)!important;
}
ul#featured_list{
    margin: unset;
    padding: revert;
    list-style: unset;
    color: #686868;
}
table{
    line-height: 30px;
}
div.progress_container{
    line-height: 1;
}
div.progress{
    width: 200px;
    height: 5px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<?php 
$images = json_decode($product->images, true);
$tags = json_decode($product->tags, true);

if (is_string($product->featured)) {
    $featured = json_decode($product->featured, true);
} elseif (is_array($product->featured)) {
    $featured = $product->featured;
} else {
    $featured = [];
}
if (is_string($product->specification)) {
    $specification = json_decode($product->specification, true);
} elseif (is_array($product->specification)) {
    $specification = $product->specification;
} else {
    $specification = [];
}
?>
<?php if(auth()->guard()->check()): ?>
<?php
$wishlistIds = auth()->user()->wishlist->pluck('product_id')->toArray();
$inWishlist = in_array($product->id, $wishlistIds);
?>
<?php endif; ?>
<!-- breadcrumbs -->
<div class="container">
	<div class="breadcrumbs">
		<a href="<?php echo e(route('home')); ?>"><i class="las la-home"></i></a>
		<a href="<?php echo e(route('search_query', ['search' => $product->category->name])); ?>"><?php echo e($product->category->name); ?></a>
        <?php if($product->sub_category_id): ?>
        <a href="<?php echo e(route('search_query', ['search' => $product->subCategory->name])); ?>"><?php echo e($product->subCategory->name); ?></a>
        <?php endif; ?>
		<a href="" class="active"><?php echo e($product->title); ?></a>
	</div>
</div>
<!-- product view -->
<div class="product_view_wrap section_padding_b">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="product_view_slider">
                    <div class="single_viewslider">
                        <img src="<?php echo e(Storage::url($images[0])); ?>" id="main_image">
                    </div>
                </div>
                <div class="product_viewslid_nav">
                    <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single_viewslid_nav">
                        <img src="<?php echo e(Storage::url($img)); ?>" class="cursor_pointer thumbnail">
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>                
            </div>
            <div class="col-lg-6">
                <div class="product_info_wrapper card card-body border-0">
                    <div class="product_base_info">
                        <h1><?php echo e($product->title); ?></h1>
                        <div class="product_other_info">
                            <div class="d-flex align-items-center">
                                <span>Availability:</span> 
                                <div class="text-center progress_container">
                                    <small class="<?php echo e($product->quantity > 10 ? 'text-success' : 'text-danger'); ?>"><?php echo e($product->quantity > 0 ? 'In Stock' : 'Out of Stock'); ?></small>
                                    <div class="progress ms-2" role="progressbar">
                                        <div class="progress-bar <?php echo e($product->quantity > 10 ? 'bg-success' : 'bg-danger'); ?>" style="width: <?php echo e(min(100, ($product->quantity / 25) * 100)); ?>%"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="price mt-3 mb-3 d-flex align-items-center">
                            <?php if($product->regular_price): ?>
                            <span class="prev_price ms-0">&#x9F3;<?php echo e($product->regular_price); ?></span>
                            <span class="org_price ms-2">&#x9F3;<?php echo e($product->sale_price); ?></span>
                            <div class="disc_tag ms-3">-<?php echo e(number_format((($product->regular_price - $product->sale_price) / $product->regular_price) * 100, 0)); ?>%</div>
                            <?php else: ?>
                            <span class="org_price ms-2">&#x9F3;<?php echo e($product->sale_price); ?></span>
                            <?php endif; ?>
                        </div>
                        <?php if(!empty($featured)): ?>
                        <div class="shop_filter border-bottom-0 pb-0">
                            <small>
                                <ul id="featured_list">
                                    <?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($item); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </small>
                        </div>
                        <?php endif; ?>
                        <div class="cart_qnty ms-md-auto">
                            <p>Quantity</p>
                            <div class="d-flex align-items-center">
                                <div class="cart_qnty_btn" id="quantity_btn_minus">
                                    <i class="las la-minus"></i>
                                </div>
                                <div class="cart_count" id="quantity_display">1</div>
                                <input type="hidden" id="quantity_field" value="1" min="1" max="<?php echo e($product->quantity); ?>" value="<?php echo e($product->quantity === 0 ? 0 : 1); ?>">
                                <div class="cart_qnty_btn" id="quantity_btn_plus">
                                    <i class="las la-plus"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="product_buttons">
                        <?php if($product->quantity > 0): ?>
                        <button type="button" class="default_btn small rounded me-sm-3 me-2 px-4 add_to_cart_btn" 
                            data-id="<?php echo e($product->id); ?>" 
                            data-title="<?php echo e($product->title); ?>" 
                            data-slug="<?php echo e($product->slug); ?>" 
                            data-image="<?php echo e(Storage::url($images[0])); ?>" 
                            data-price="<?php echo e($product->sale_price); ?>" 
                            data-quantity="1"><i class="icon-cart me-2"></i> Add to Cart</button>
                        <?php else: ?>
                            <button class="btn btn-danger" disabled>Out of Stock</button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('product_wishlist_updater', ['id' => $product->id])); ?>" class="default_btn small rounded second border-none">
                        <?php if(auth()->guard()->check()): ?>
                            <i class="las <?php echo e($inWishlist ? 'la-minus-circle' : 'la-heart'); ?> me-2"></i> Wishlist</a>
                        <?php else: ?>
                            <i class="las la-heart"></i>
                        <?php endif; ?>
                    </div>
                    <div class="share_icons footer_icon d-flex justify-content-center">
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(Request::url())); ?>" target="_blank"><i class="lab la-facebook-f"></i></a>
                        <a href="https://twitter.com/intent/tweet?url=<?php echo e(urlencode(Request::url())); ?>" target="_blank"><i class="lab la-twitter"></i></a>
                        <a href="https://www.linkedin.com/shareArticle?url=<?php echo e(urlencode(Request::url())); ?>" target="_blank"><i class="lab la-linkedin"></i></a>
                        <a href="https://pinterest.com/pin/create/button/?url=<?php echo e(urlencode(Request::url())); ?>" target="_blank"><i class="lab la-pinterest"></i></a>
                        <a href="https://wa.me/send?text=<?php echo e(urlencode(Request::url())); ?>" target="_blank"><i class="lab la-whatsapp"></i></a>
                        <a href="mailto:?body=<?php echo e(urlencode(Request::url())); ?>" target="_blank"><i class="las la-envelope"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="product_view_tabs mt-4">
            <div class="pv_tab_buttons" class="spec_text">
                <div class="pbt_single_btn active" data-target=".description">Description</div>
                <div class="pbt_single_btn" data-target=".specifications">Specifications</div>
            </div>
            <div class="pb_tab_content description active">
                <div class="row">
                    <div class="col-lg-8">
                        <?php echo $product->description; ?>

                    </div>
                </div>
            </div>
            <div class="pb_tab_content specifications">
                <?php if(!empty($specification)): ?>
                <div class="row">
                    <div class="col-md-6 mx-auto">
                        <table class="table">
                            <tbody>
                                <?php $__currentLoopData = $specification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-muted"><?php echo e($spec['key']); ?></td>
                                    <td class="d-flex justify-content-end text-muted"><?php echo e($spec['value']); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php if($related_products->isNotEmpty()): ?>
<!-- new arrive -->
<section class="new_arrive section_padding_b">
    <div class="container">
        <div class="d-flex align-items-start justify-content-between">
            <h2 class="section_title_2">Related products</h2>
        </div>
        <div class="product_slider_2">
        <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php 
            $pd_images = json_decode($pd->images, true);
        ?>
        <?php if(auth()->guard()->check()): ?>
        <?php
        $wishlistIds = auth()->check() ? auth()->user()->wishlist->pluck('product_id')->toArray() : [];
        $inWishlist = in_array($pd->id, $wishlistIds);
        ?>
        <?php endif; ?>
            <div class="single_toparrival">
               <div class="single_new_arrive">
                  <div class="sna_img">
                      <a href="<?php echo e(route('product_view', ['slug' => $pd->slug])); ?>">
                          <img loading="lazy" class="prd_img" src="<?php echo e(Storage::url($pd_images[0])); ?>" />
                      </a>
                      <?php if($pd->quantity === 0): ?>
                      <span class="tag">Stock Out</span>
                      <?php endif; ?>
                      <div class="prodcut_hovcont">
                          <a href="<?php echo e(route('product_wishlist_updater', ['id' => $pd->id])); ?>" class="icon" tabindex="0">
                              <?php if(auth()->guard()->check()): ?>
                              <i class="las <?php echo e($inWishlist ? 'la-minus-circle la-lg' : 'la-heart'); ?>"></i>
                              <?php else: ?>
                              <i class="las la-heart"></i>
                              <?php endif; ?>
                          </a>
                      </div>
                  </div>
                  <div class="sna_content">
                      <a href="<?php echo e(route('product_view', ['slug' => $pd->slug])); ?>">
                          <h6><?php echo e(Str::limit($pd->title, 55)); ?></h6>
                       </a>
                      <div class="ratprice mt-3">
                          <div class="price d-flex align-items-center">
                            <?php if($pd->regular_price): ?>
                            <span class="prev_price ms-0">&#x9F3;<?php echo e($pd->regular_price); ?></span>
                            <?php endif; ?>
                            <span class="org_price ms-2">&#x9F3;<?php echo e($pd->sale_price); ?></span>
                            <?php if($pd->regular_price): ?>
                            <div class="disc_tag ms-3">-<?php echo e(number_format((($pd->regular_price - $pd->sale_price) / $pd->regular_price) * 100, 0)); ?>%</div>
                            <?php endif; ?>
                          </div>
                      </div>
                      <div class="product_adcart">
                        <?php if($pd->quantity > 0): ?>
                        <button type="button" class="default_btn add_to_cart_slider" 
                           data-id="<?php echo e($pd->id); ?>" 
                           data-title="<?php echo e($pd->title); ?>" 
                           data-slug="<?php echo e($pd->slug); ?>" 
                           data-image="<?php echo e(Storage::url($pd_images[0])); ?>" 
                           data-price="<?php echo e($pd->sale_price); ?>" 
                           data-quantity="1"><i class="icon-cart me-2"></i> Add to Cart</button>
                        <?php else: ?>
                           <button class="btn btn-danger" disabled>Out of Stock</button>
                        <?php endif; ?>
                      </div>
                  </div>
              </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
        </div>
    </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$(document).ready(function() {
    let cart = JSON.parse(localStorage.getItem('cart')) || [];
    let productId = $('.add_to_cart_btn').data('id');
    let productIndex = cart.findIndex(item => item.id === productId);

    if (productIndex !== -1 && cart !== null) {
        let quantity = cart[productIndex].quantity;
        $('#quantity_display').text(quantity);
        $('#quantity_field').val(quantity);
    }else{
        $('#quantity_display').text(1);
        $('#quantity_field').val(1);
    }

    $('#quantity_btn_minus').click(function() {
        let currentValue = parseInt($('#quantity_field').val());
        let maxValue = parseInt($('#quantity_field').attr('max'));
        if (currentValue > 1) {
            $('#quantity_field').val(currentValue - 1);
            $('#quantity_display').text(currentValue - 1);
            $('.add_to_cart_btn').removeAttr('data-quantity');
            $('.add_to_cart_btn').attr('data-quantity', currentValue - 1);
            if (productIndex !== -1 && cart !== null) {
                cart[productIndex].quantity = currentValue - 1;
                localStorage.setItem('cart', JSON.stringify(cart));
                updateCartView();
            }
        }
    });
    $('#quantity_btn_plus').click(function() {
        let currentValue = parseInt($('#quantity_field').val());
        let maxValue = parseInt($('#quantity_field').attr('max'));
        if (currentValue < maxValue) {
            $('#quantity_field').val(currentValue + 1);
            $('#quantity_display').text(currentValue + 1);
            $('.add_to_cart_btn').removeAttr('data-quantity');
            $('.add_to_cart_btn').attr('data-quantity', currentValue + 1);
            if (productIndex !== -1 && cart !== null) {
                cart[productIndex].quantity = currentValue + 1;
                localStorage.setItem('cart', JSON.stringify(cart));
                updateCartView();
            }
        }
    });

    function updateCartBadge() {
      let cart = JSON.parse(localStorage.getItem('cart')) || []; 
      let totalItems = cart.length;
      if (totalItems > 0) {
         $('.cart_counter').text(totalItems);
      } else {
         $('.cart_counter').text(0);
      }
   }
   function truncateTitle(title) {
        if (title.length > 30) {
            return title.substring(0, 30) + '...';
        }
        return title;
    }
    function updateCartView() {
        let cart = JSON.parse(localStorage.getItem('cart')) || [];
        let cartItemsContainer = $('.cartsdrop_wrap');
        cartItemsContainer.empty();
        let subtotal = 0;
        cart.forEach(function(item) {
            let cartItemHtml = `
                <div class="single_cartdrop mb-3">
                    <span class="remove_cart" data-id="${item.id}"><i class="las la-times"></i></span>
                    <div class="cartdrop_img">
                        <img loading="lazy" src="${item.image}" />
                    </div>
                    <div class="cartdrop_cont">
                        <h5 class="text_lg mb-0 default_link"><a href="/product/${item.slug}">${truncateTitle(item.title)}</a></h5>
                        <p class="mb-0 text_xs text_p">x${item.quantity} <span class="ms-2">$${item.price}</span></p>
                    </div>
                </div>
            `;
            cartItemsContainer.append(cartItemHtml);
            subtotal += item.price * item.quantity;
        });
        $('.cart_subtotal').html('&#x9F3;'+subtotal);

        $('.remove_cart').click(function() {
            let productId = $(this).data('id');
            removeFromCart(productId);
        });
    }

    function removeFromCart(productId) {
        let cart = JSON.parse(localStorage.getItem('cart')) || [];
        let updatedCart = cart.filter(item => item.id !== productId);
        localStorage.setItem('cart', JSON.stringify(updatedCart));
        updateCartBadge();
        updateCartView();
    }
   function updateButtons() {
      let cart = JSON.parse(localStorage.getItem('cart')) || [];
      $('.add_to_cart_slider').each(function() {
         let productId = $(this).data('id');
         let inCart = cart.some(item => item.id === productId);
         if (inCart) {
         $(this).removeClass('default_btn');
         $(this).addClass('btn btn-success');
         $(this).html('<i class="las la-check"></i> Added to Cart');
         $(this).attr('disabled', true);
      }
      });
   }

   updateButtons();
   updateCartBadge();
   updateCartView();

    $('.add_to_cart_slider').on('click', function() {
      let product = {
         id: $(this).data('id'),
         title: $(this).data('title'),
         slug: $(this).data('slug'),
         image: $(this).data('image'),
         price: $(this).data('price'),
         quantity: $(this).data('quantity')
      };
      let cart = JSON.parse(localStorage.getItem('cart')) || [];
      let existingProductIndex = cart.findIndex(item => item.id === product.id);
      if (existingProductIndex !== -1) {
         cart[existingProductIndex].quantity += 1;
      } else {
         cart.push(product);
      }
      localStorage.setItem('cart', JSON.stringify(cart));
      updateButtons();
      updateCartBadge();
      updateCartView();
   });

    $('.thumbnail').click(function() {
        $('#main_image').attr('src', $(this).attr('src'));
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/computec/public_html/resources/views/general/product_view.blade.php ENDPATH**/ ?>