
<?php $__env->startSection("title"); ?> CarShop Admin - Vehicles List <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.dealer_img{
    width: 30px;
    height: 30px;
    border-radius: 50%;
}
img.vehicle_list_img{
    width: 80px;
    height: 45px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark border-bottom">Vehicles/List</h5>
</div>
<div class="col-12 mb-3">
<form method="GET">
<?php echo csrf_field(); ?>
    <div class="input-group">
        <input type="text" class="form-control py-4" name="search" id="search_field" placeholder="Search users by vehicles brand, model, category, price, mileage, fuel type, condition, exterior/interior color, model year, or status..." required>
        <div class="input-group-prepend">
            <button type="submit" class="input-group-text bg-light"><i class="fas fa-search"></i></button>
        </div>
    </div>
    <a href="<?php echo e(route('admin_vehicles_list')); ?>" class="text-muted d-none" id="reset_btn"><small>reset</small></a>
</form>
</div>
<div class="col-12">
<div class="card card-body p-0">
<table class="table table-bordered text-center">
<thead class="bg-dark">
    <tr>
        <th>#</th>
        <th>Image</th>
        <th>Name</th>
        <th>Dealer</th>
        <th>Price</th>
        <th>Category</th>
        <th>Condition</th>
        <th>Status</th>
        <th>Campaign</th>
        <th>Publish Date</th>
        <th>Action</th>
    </tr>
</thead>
<tbody>
<?php $__empty_1 = true; $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td>
            <?php if($vehicle->images): ?>
                <?php $images = json_decode($vehicle->images, true); ?>
                <img src="<?php echo e(Storage::url($images[0])); ?>" class="img-fluid rounded vehicle_list_img">
            <?php endif; ?>
        </td>
        <td>
            <div class="d-flex flex-column">
                <small><img src="<?php echo e(Storage::url($vehicle->brand->logo)); ?>" class="img-fluid" width="20"> <?php echo e($vehicle->brand->name); ?></small>
                <small><?php echo e($vehicle->model); ?></small>
            </div>
        </td>
        <td>
            <a href="<?php echo e(route('admin_users_view', ['uid' => $vehicle->dealer->id])); ?>" class="text-dark">
                <img src="<?php echo e(Storage::url($vehicle->dealer->avatar)); ?>" class="dealer_img">
                <?php echo e($vehicle->dealer->full_name); ?>

            </a>
        </td>
        <td><?php echo e($vehicle->price); ?> BDT</td>
        <td><?php echo e($vehicle->category->title); ?></td>
        <td><?php echo e(ucfirst($vehicle->condition)); ?></td>
        <td>
            <form action="<?php echo e(route('admin_vehicles_status_updater')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e($vehicle->id); ?>">
                <select name="status" class="custom-select">
                    <option value="active" <?php echo e($vehicle->status === 'active' ? 'selected' : ''); ?>>Active</option>
                    <option value="closed" <?php echo e($vehicle->status === 'closed' ? 'selected' : ''); ?>>Closed</option>
                    <option value="sold" <?php echo e($vehicle->status === 'sold' ? 'selected' : ''); ?>>Sold</option>
                </select>
            </form>
        </td>
        <td>
            <div class="d-flex flex-column">
                <?php $campaign = json_decode($vehicle->campaign, true) ?>
                <?php if($campaign): ?>
                    <?php $__currentLoopData = $campaign; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <small><?php echo e($key); ?></small>
                        <?php if(is_array($value)): ?>
                            <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $duration => $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <small><i class="fa-regular fa-clock"></i> <?php echo e($duration); ?> - <?php echo e($cost); ?> BDT</small>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <span>not found!</span>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <span>not found!</span>
                <?php endif; ?>
            </div>
        </td>
        <td><?php echo e(\Carbon\Carbon::parse($vehicle->publish_date)->format('M d, Y')); ?></td>
        <td>
            <a href="<?php echo e(route('admin_vehicles_view', ['id' => $vehicle->id])); ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i></a>
            <button type="button" class="btn btn-danger btn-sm delete_vehicle_btn" data-toggle="modal" data-target="#delete_vehicle_modal" data-id="<?php echo e($vehicle->id); ?>"><i class="fas fa-trash-alt"></i></button>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
        <td colspan="10" class="text-center text-muted">no vehicles found!</td>
    </tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
<div class="col-12 d-flex justify-content-between align-items-baseline py-4">
<small class="text-dark">Showing <?php echo e($vehicles->firstItem()); ?> to <?php echo e($vehicles->lastItem()); ?> of <?php echo e($vehicles->total()); ?> results</small>
<?php echo e($vehicles->links("partial.pagination")); ?>

</div>
</div>
<div class="modal fade" id="delete_vehicle_modal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-danger"><i class="fas fa-exclamation-triangle"></i> Delete This Vehicle</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body bg-light">
        Are you sure? do you really want to delete this vehicle?
      </div>
      <div class="modal-footer d-flex justify-content-between p-0">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <form action="<?php echo e(route('admin_vehicles_delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="vehicle_id" id="vehicle_id">
            <button type="submit" class="btn btn-danger">Confirm</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$(document).ready(function() {
    $('select[name="status"]').change(function() {
        $(this).closest('form').submit();
    });
    $(".delete_vehicle_btn").click(function(){
        $("#vehicle_id").val($(this).data("id"));
    });
});
function getSearchTermFromUrl() {
  let urlParams = new URLSearchParams(window.location.search);
  return urlParams.get('search') || '';
}
window.onload = function() {
  document.getElementById('search_field').value = getSearchTermFromUrl();
  if(getSearchTermFromUrl()){
    document.getElementById('reset_btn').classList.remove('d-none');
  }
};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/admin/vehicles_list.blade.php ENDPATH**/ ?>