
<?php $__env->startSection("stylesheet"); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection("title"); ?> Parts/Accessories Edit Product <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.product_images_preview{
    width: 125px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12 mb-2">
<h5 class="text-dark border-bottom"><a href="<?php echo e(route('admin_pna_inventory')); ?>" class="text-muted">Parts/Accessories Inventory</a>/Edit Product: <?php echo e($product->id); ?></h5>
</div>
<div class="col-12">
<div class="card card-body">
<form action="<?php echo e(route('admin_pna_inventory_edit_handler')); ?>" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<div class="row">
    <div class="col-md-6 mb-3">
        <label for="title" class="text-dark mb-0">Product Title</label>
        <input type="text" name="title" class="form-control mb-3" id="title" min="10" max="150" value="<?php echo e($product->title); ?>" required>
        <label for="description" class="text-dark mb-0">Product Description</label>
        <textarea name="description" class="form-control mb-3" id="description"><?php echo e($product->description); ?></textarea>
        <label for="tags" class="text-dark mb-0">Tags <span class="text-muted">(separate by comma)</span></label>
        <input type="text" name="tags" class="form-control" id="tags" placeholder="eg: tag1, tag2, tag3..." value="<?php echo e(implode(', ', json_decode($product->tags))); ?>" required>
    </div>
    <div class="col-md-6 mb-3">
    <div class="row">
    <div class="col-md-6 mb-3">
        <label for="type" class="text-dark mb-0">Select Type</label>
        <select name="type" class="custom-select" id="type" required>
            <option selected disabled>-- select --</option>
            <option value="Parts" <?php echo e($product->type === 'Parts' ? 'selected' : ''); ?>>Parts</option>
            <option value="Accessories" <?php echo e($product->type === 'Accessories' ? 'selected' : ''); ?>>Accessories</option>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="quantity" class="text-dark mb-0">Quantity</label>
        <input type="number" name="quantity" class="form-control mb-3" id="quantity" min="1" value="<?php echo e($product->quantity); ?>" required>
    </div>
    <div class="col-md-6 mb-3">
        <label for="brand" class="text-dark mb-0">Select Brand</label>
        <select name="brand_id" class="custom-select" id="brand" required>
            <option selected disabled>-- select --</option>
            <?php $__currentLoopData = $pna_brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($brand->id); ?>" <?php echo e(($brand->name === $product->brand->name) ? "selected" : ""); ?>><?php echo e($brand->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="category" class="text-dark mb-0">Select Category</label>
        <select name="category_id" class="custom-select" id="category" required>
            <option selected disabled>-- select --</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>" <?php echo e(($category->name === $product->category->name) ? "selected" : ""); ?>><?php echo e($category->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="regular_price" class="text-dark mb-0">Regular Price</label>
        <div class="input-group">
            <div class="input-group-prepend">
              <span class="input-group-text">BDT</span>
            </div>
            <input type="number" name="regular_price" class="form-control" id="regular_price" value="<?php echo e($product->regular_price); ?>">
        </div>
    </div>
    <div class="col-md-6 mb-2">
        <label for="sale_price" class="text-dark mb-0">Sale Price</label>
        <div class="input-group">
            <div class="input-group-prepend">
              <span class="input-group-text">BDT</span>
            </div>
            <input type="number" name="sale_price" class="form-control" id="sale_price" value="<?php echo e($product->sale_price); ?>" required>
        </div>
    </div>
    <div class="col-md-4 mb-2">
        <input type="checkbox" name="has_warranty" id="has_warranty" <?php echo e($product->has_warranty ? 'checked' : ''); ?>>
        <label for="has_warranty" class="text-dark mb-0">Provide Warranty</label>
    </div>
    </div>
    <div class="col-12">
        <hr class="mt-0 mb-2">
    </div>
    <div class="col-12">
        <label for="meta_title" class="text-dark mb-0">Meta Title</label>
        <input type="text" name="meta_title" class="form-control mb-3" id="meta_title" min="10" max="150" value="<?php echo e($product->meta_title); ?>" required>
        <label for="meta_description" class="text-dark mb-0">Meta Description</label>
        <textarea name="meta_description" class="form-control" id="meta_description" rows="3"><?php echo e($product->meta_description); ?></textarea>
    </div>
    </div>
    <div class="col-12">
        <hr class="my-2">
    </div>
    <div class="col-12 mb-3">
    <div class="row">
        <div class="col-md-6 d-flex flex-column justify-content-center align-items-center mb-md-0 mb-3">
            <label for="images">Select product images</label>
            <input type="file" id="images" accept=".png, .jpg, .jpeg" multiple>
        </div>
        <div class="col-md-6">
            <input type="hidden" name="images" class="images-data" value="<?php echo e($product->images); ?>">
            <ul class="list-group list-group-numbered image-previews">
                <?php
                    $images = json_decode($product->images, true);
                ?>
                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <span><?php echo e($loop->iteration); ?>.</span>
                    <img src="<?php echo e(Storage::url($image)); ?>" class="product_images_preview rounded">
                    <i class="fas fa-trash-alt fa-lg text-danger cursor_pointer remove-image"></i>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
    </div>
    <input type="hidden" name="id" value="<?php echo e($product->id); ?>">
    <div class="col-12 text-center">
        <button type="submit" class="btn btn-primary">Publish Now</button>
    </div>
</div>
</form>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script>
$(document).ready(function() {
    $('#description').summernote({
        tabsize: 2,
        height: 250
    });

    let imageDataArray = <?php echo json_encode(json_decode($product->images, true), 512) ?>;
    $('#images').change(async function() {
        let existingImagesCount = $('.image-previews li').length;
        for (let index = 0; index < this.files.length; index++) {
            const file = this.files[index];
            const reader = new FileReader();
            await new Promise((resolve, reject) => {
                reader.onload = function(event) {
                    $('.image-previews').append('<li class="list-group-item d-flex justify-content-between align-items-center">' +
                        '<span>'+ (existingImagesCount + index + 1) +'.</span>' +
                        '<img src="' + event.target.result + '" class="product_images_preview rounded">' +
                        '<i class="fas fa-trash-alt fa-lg text-danger cursor_pointer remove-image"></i>' +
                        '</li>');
                    imageDataArray.push(event.target.result);
                    $('.images-data').val(JSON.stringify(imageDataArray));
                    resolve();
                };
                reader.onerror = function(error) {
                    reject(error);
                };
                reader.readAsDataURL(file);
            });
        }
    });
    $(document).on('click', '.remove-image', function() {
        let imageIndex = $(this).parent().index();
        imageDataArray.splice(imageIndex, 1);
        $('.images-data').val(JSON.stringify(imageDataArray));
        $(this).parent().remove();
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/admin/pna_inventory_edit.blade.php ENDPATH**/ ?>