
<?php $__env->startSection("title"); ?> My Orders History <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.product_list_img{
    width: 25px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!-- breadcrumbs -->
<div class="container">
	<div class="breadcrumbs">
		<a href="<?php echo e(route('home')); ?>"><i class="las la-home"></i></a>
		<a href="<?php echo e(route('user_account')); ?>">My Account</a>
		<a href="<?php echo e(route('user_account_orders')); ?>" class="active">My Orders History</a>
	</div>
</div>
<!-- account -->
<div class="my_account_wrap section_padding_b">
	<div class="container">
		<div class="row">
			<!--  account sidebar  -->
			<?php echo $__env->make('partial.account_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			<!-- account content -->
			<div class="col-lg-9">
				<table class="table table-bordered table-hover table-responsive text-center">
					<thead>
						<tr>
							<th class="text-muted">Order ID</th>
							<th class="text-muted">Products</th>
							<th class="text-muted">Quantity</th>
							<th class="text-muted">Amount</th>
							<th class="text-muted">Shipping & Delivery</th>
							<th class="text-muted">Progress</th>
							<th class="text-muted">Date</th>
						</tr>
					</thead>
					<tbody>
						<?php
							$orderQuantities = [];
							foreach ($orders as $order) {
								if (!isset($orderQuantities[$order->order_id])) {
									$orderQuantities[$order->order_id] = 0;
								}
								$orderQuantities[$order->order_id] += $order->quantity;
							}
						?>
						<?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
						<?php if($index == 0 || $order->order_id != $orders[$index - 1]->order_id): ?>
							<tr>
								<td><?php echo e($order->order_id); ?></td>
								<td class="text-left">
									<div class="d-flex flex-column align-items-start">
										<?php $__currentLoopData = $orders->where('order_id', $order->order_id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
											<?php $images = json_decode($item->product->images, true); ?>
											<a href="<?php echo e(route('product_view', ['slug' => $item->product->slug])); ?>" class="text-dark">
												<img src="<?php echo e(Storage::url($images[0])); ?>" class="img-fluid rounded product_list_img mr-1">
												<small><?php echo e(Str::limit($item->product->title, 25)); ?></small>
											</a>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</div>
								</td>
								<td><?php echo e($orderQuantities[$order->order_id]); ?></td>
								<td>&#x9F3;<?php echo e($order->amount); ?></td>
								<td>
									<button class="btn btn-light btn-sm border" data-bs-toggle="modal" data-bs-target="#shipping_and_delivert_view" data-snd="<?php echo e($order->shipping_address); ?>" data-dm="<?php echo e($order->delivery_method); ?>">view</button>
								</td>
								<td><?php echo e(ucfirst($order->deliver_status)); ?></td>
								<td>
									<div class="d-flex flex-column">
										<small><?php echo e(\Carbon\Carbon::parse($order->issued_at)->format('h:i A')); ?></small>
										<small><?php echo e(\Carbon\Carbon::parse($order->issued_at)->format('M d, Y')); ?></small>
									</div>
								</td>
							</tr>
						<?php endif; ?>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<tr>
							<td colspan="7" class="text-center text-muted">No orders made yet!</td>
						</tr>
					<?php endif; ?>
					</tbody>
				</table>
			</div>
        </div>
    </div>
</div>

<div class="modal fade" id="shipping_and_delivert_view" tabindex="-1" >
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5">Shipping & Delivery Address</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body shipping_and_delivert_modal_body">
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$('#shipping_and_delivert_view').on('show.bs.modal', function (event) {
    let button = $(event.relatedTarget);
    let snd = button.data('snd');
    let dm = button.data('dm');
    let delivery_method = dm === 'pay_with_ssl' ? 'Digital Payment' : 'Cash on Delivery';
    let modal = $(this);
    modal.find('.shipping_and_delivert_modal_body').html(`
        <div><span class="fw-bold text-muted">Payment Option: </span>${delivery_method}</div>
        <table class="table mt-2 mb-0">
            <tbody>
                <tr>
                    <td class="text-dark">Full Name</td>
                    <td>:</td>
                    <td>${snd.first_name} ${snd.last_name}</td>
                </tr>
                <tr>
                    <td class="text-dark">Email</td>
                    <td>:</td>
                    <td>${snd.email}</td>
                </tr>
                <tr>
                    <td class="text-dark">Phone</td>
                    <td>:</td>
                    <td>${snd.phone}</td>
                </tr>
                <tr>
                    <td class="text-dark">Address</td>
                    <td>:</td>
                    <td>${snd.address}</td>
                </tr>
                <tr>
                    <td class="text-dark">City</td>
                    <td>:</td>
                    <td>${snd.city}</td>
                </tr>
                <tr>
                    <td class="text-dark">Country</td>
                    <td>:</td>
                    <td>${snd.country}</td>
                </tr>
                <tr>
                    <td class="text-dark">Zip Code</td>
                    <td>:</td>
                    <td>${snd.zip_code}</td>
                </tr>
            </tbody>
         </table>
    `);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\computershop\resources\views/user/account_orders.blade.php ENDPATH**/ ?>