
<?php $__env->startSection("title"); ?> Track My Order <?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!-- breadcrumbs -->
<div class="container">
	<div class="breadcrumbs">
		<a href="<?php echo e(route('home')); ?>"><i class="las la-home"></i></a>
		<a href="<?php echo e(route('track_order')); ?>">Track My Order</a>
	</div>
</div>
<!-- track order -->
<div class="track_orders section_padding_b">
    <div class="container">
        <div class="padding_default shadow_sm">
            <h2 class="title_2 mb-4">Order Tracking</h2>
            <form action="<?php echo e(route('track_order')); ?>" method="GET">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-lg-5">
                        <div class="single_billing_inp">
                            <label for="order_id">Order ID <span>*</span></label>
                            <input type="text" name="order_id" id="order_id" placeholder="#xxxxxxxxxxxxx" value="<?php echo e(isset($order) ? $order->order_id : ''); ?>" required>
                        </div>
                    </div>
                    <div class="col-12 mt-1">
                        <button type="submit" class="default_btn xs_btn rounded px-4">track order</button>
                    </div>
                </div>
            </form>

            <?php if(isset($order)): ?>
            <div class="mt-4 pt-2 track_status">
                <h4 class="title_3 text-uppercase"><?php echo e(ucfirst($order->deliver_status)); ?></h4>
                <div class="track_path">
                    <?php
                        $statuses = ['placed', 'preparing', 'shipping', 'delivered'];
                        $currentStatusIndex = array_search($order->deliver_status, $statuses);
                    ?>
        
                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="single_track <?php echo e($index > $currentStatusIndex ? 'pending' : ''); ?>">
                            <h5 class="text_lg mb-0"><?php echo e($index + 1); ?>. <?php echo e(ucfirst($status)); ?></h5>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/computec/public_html/resources/views/general/track_order.blade.php ENDPATH**/ ?>