
<?php $__env->startSection("title"); ?> Products List <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.product_list_img{
    width: 80px;
    height: 45px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark border-bottom">Products List</h5>
</div>
<div class="col-12 mb-3">
<form method="GET">
    <div class="input-group">
        <input type="text" class="form-control py-4" name="search" id="search_field" placeholder="Search by product title, sku/code, condition, regular or sale price tags, featured or specification..." required>
        <div class="input-group-prepend">
            <button type="submit" class="input-group-text bg-light"><i class="fas fa-search"></i></button>
        </div>
    </div>
    <a href="<?php echo e(route('admin_products_list')); ?>" class="text-muted d-none" id="reset_btn"><small>reset</small></a>
</form>
</div>
<div class="col-12">
<div class="card card-body p-0">
<div class="table-responsive">
<table class="table table-bordered text-center">
<thead class="bg-dark">
    <tr>
        <th>#</th>
        <th>Product</th>
        <th>SKU/Code</th>
        <th>Price <i class="fa-solid fa-bangladeshi-taka-sign"></i></th>
        <th>Quantity</th>
        <th>Brand</th>
        <th>Category</th>
        <th>Condition</th>
        <th>Publish Date</th>
        <th>Action</th>
    </tr>
</thead>
<tbody>
<?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td>
          <a href="<?php echo e(route('admin_products_view', ['id' => $product->id])); ?>" class="d-flex align-items-center text-dark">
            <?php if($product->images): ?>
                <?php $images = json_decode($product->images, true); ?>
                <img src="<?php echo e(Storage::url($images[0])); ?>" class="img-fluid rounded product_list_img mr-1">
            <?php endif; ?>
            <span><?php echo e(Str::limit($product->title, 50)); ?></span>
          </a>
        </td>
        <td><?php echo e($product->sku); ?></td>
        <td>
          <div class="d-flex flex-column">
            <?php if($product->regular_price): ?><span title="regular price"><s><?php echo e($product->regular_price); ?> tk</s></span><?php endif; ?>
            <span title="sale price"><?php echo e($product->sale_price); ?> tk</span>
          </div>
        </td>
        <td><?php echo e($product->quantity); ?></td>
        <td><?php echo e(optional($product->brand)->name); ?></td>
        <?php if($product->sub_category_id): ?>
        <td>
          <div class="d-flex flex-column">
            <small><?php echo e($product->category->name); ?></small>
            <small><i class="fa-solid fa-arrow-turn-down fa-sm text-muted"></i></small>
            <small><?php echo e($product->subcategory->name); ?></small>
          </div>
        </td>
        <?php else: ?>
        <td><?php echo e($product->category->name); ?></td>
        <?php endif; ?>
        <td><?php echo e($product->condition); ?></td>
        <td><?php echo e(\Carbon\Carbon::parse($product->publish_date)->format('M d, Y')); ?></td>
        <td>
            <a href="<?php echo e(route('admin_products_view', ['id' => $product->id])); ?>" class="btn btn-info btn-sm"><i class="fas fa-edit"></i></a>
            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete_product_modal" data-id="<?php echo e($product->id); ?>" data-img="<?php echo e(Storage::url($images[0])); ?>" data-title="<?php echo e($product->title); ?>" data-quantity="<?php echo e($product->quantity); ?>"><i class="fas fa-trash-alt"></i></button>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
      <td colspan="10" class="text-center text-muted">no products found!</td>
    </tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
</div>
<div class="col-12 d-flex justify-content-between align-items-baseline py-4">
<small class="text-dark">Showing <?php echo e($products->firstItem()); ?> to <?php echo e($products->lastItem()); ?> of <?php echo e($products->total()); ?> results</small>
<?php echo e($products->links("partial.pagination")); ?>

</div>
</div>

<div class="modal fade" id="delete_product_modal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-danger"><i class="fas fa-exclamation-triangle"></i> Delete This Product</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body bg-light d-flex flex-column justify-content-center align-items-center">
        <h6 class="text-danger">Are you sure? do you really want to delete this product?</h6>
        <img class="img-fluid rounded product_list_img del_preview_img mb-2">
        <span class="text-dark del_preview_title mb-1"></span>
        <span class="badge border del_preview_quantity"></span>
      </div>
      <div class="modal-footer d-flex justify-content-between p-0">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <form action="<?php echo e(route('admin_products_delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="product_id" id="product_id">
            <button type="submit" class="btn btn-danger">Yes, Confirm</button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$('#delete_product_modal').on('show.bs.modal', function (event) {
  let button = $(event.relatedTarget);
  let id = button.data('id');
  let img = button.data('img');
  let title = button.data('title');
  let quantity = button.data('quantity');
  let modal = $(this);
  modal.find('#product_id').val(id);
  modal.find('.del_preview_img').attr('src', img);
  modal.find('.del_preview_title').text(title);
  modal.find('.del_preview_quantity').text('Quantity: ' + quantity);
});

function getSearchTermFromUrl() {
  let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get('search') || '';
}
window.onload = function() {
  document.getElementById('search_field').value = getSearchTermFromUrl();
  if(getSearchTermFromUrl()){
    document.getElementById('reset_btn').classList.remove('d-none');
  }
};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/computec/public_html/resources/views/admin/products_list.blade.php ENDPATH**/ ?>