
<?php $__env->startSection("title"); ?> Best Deals <?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!-- breadcrumbs -->
<div class="container">
	<div class="breadcrumbs">
		<a href="<?php echo e(route('home')); ?>"><i class="las la-home"></i></a>
		<a href="<?php echo e(route('best_deals')); ?>" class="active">Best Deals</a>
	</div>
</div>
<!-- brands list -->
<div class="section_padding_b">
<div class="container">
<h2 class="section_title_2 text-center mb-0">Best Deals</h2>
<hr class="w-25 mx-auto mt-2 mb-5">
<div class="row">
    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <?php 
        $images = json_decode($pd->product->images, true);
        $wishlistIds = auth()->user()->wishlist->pluck('product_id')->toArray();
        $inWishlist = in_array($pd->product->id, $wishlistIds);
    ?>
        <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
            <div class="single_new_arrive">
                <div class="sna_img">
                    <a href="<?php echo e(route('product_view', ['slug' => $pd->product->slug])); ?>">
                        <img loading="lazy" class="prd_img" src="<?php echo e(Storage::url($images[0])); ?>" />
                    </a>
                    <?php if($pd->product->quantity === 0): ?>
                    <span class="tag">Stock Out</span>
                    <?php endif; ?>
                    <div class="prodcut_hovcont">
                        <a href="<?php echo e(route('product_wishlist_updater', ['id' => $pd->product->id])); ?>" class="icon" tabindex="0">
                            <i class="las <?php echo e($inWishlist ? 'la-minus-circle la-lg' : 'la-heart'); ?>"></i>
                        </a>
                    </div>
                </div>
                <div class="sna_content">
                    <a href="<?php echo e(route('product_view', ['slug' => $pd->product->slug])); ?>">
                        <h6><?php echo e(Str::limit($pd->product->title, 70)); ?></h6>
                    </a>
                    <div class="ratprice mt-3">
                        <div class="price d-flex align-items-center">
                            <?php if($pd->product->regular_price): ?>
                            <span class="prev_price ms-0">&#x9F3;<?php echo e($pd->product->regular_price); ?></span>
                            <?php endif; ?>
                            <span class="org_price ms-2">&#x9F3;<?php echo e($pd->product->sale_price); ?></span>
                            <?php if($pd->product->regular_price): ?>
                            <div class="disc_tag ms-3">-<?php echo e(number_format((($pd->product->regular_price - $pd->product->sale_price) / $pd->product->regular_price) * 100, 0)); ?>%</div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="product_adcart">
                        <?php if($pd->product->quantity > 0): ?>
                        <button type="button" class="default_btn add_to_cart_btn" 
                           data-id="<?php echo e($pd->product->id); ?>" 
                           data-title="<?php echo e($pd->product->title); ?>" 
                           data-slug="<?php echo e($pd->product->slug); ?>" 
                           data-image="<?php echo e(Storage::url($images[0])); ?>" 
                           data-price="<?php echo e($pd->product->sale_price); ?>" 
                           data-quantity="1"><i class="icon-cart me-2"></i> Add to Cart</button>
                        <?php else: ?>
                           <button class="btn btn-danger" disabled>Out of Stock</button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div class="col-12 text-center">
        <span class="text-muted">no products found!</span>
    </div>
<?php endif; ?>
<div class="col-12 d-flex justify-content-between align-items-baseline py-4">
    <small class="text-dark">Showing <?php echo e($products->firstItem()); ?> to <?php echo e($products->lastItem()); ?> of <?php echo e($products->total()); ?> results</small>
    <?php echo e($products->links("partial.pagination")); ?>

</div>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yasiritc/public_html/resources/views/general/best_deals.blade.php ENDPATH**/ ?>