
<?php $__env->startSection("title"); ?> CarShop - My Vehicles Store <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
.hr_bg{
    background-color: #c3c3c3;
    border: none;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="container mtb_6030">
<div class="row mb-4">
<div class="col-12 mb-3">
    <h5 class="text-danger text-center mb-0">List of My Vehicles</h5>
    <hr class="hr_bg">
</div>
<div class="col-12 table-responsive">
<table class="table table-bordered table-hover table-responsive text-center">
<thead class="bg-dark text-light">
    <tr>
        <th>#</th>
        <th>Image</th>
        <th>Name</th>
        <th>Price</th>
        <th>Category</th>
        <th>Condition</th>
        <th>Campaign</th>
        <th>Publish Date</th>
        <th>Status</th>
    </tr>
</thead>
<tbody>
<?php $__empty_1 = true; $__currentLoopData = $vehicles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vehicle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td>
            <?php if($vehicle->images): ?>
                <?php $images = json_decode($vehicle->images, true); ?>
                <a href="<?php echo e(route('vehicle_details', ['car' => $vehicle->slug])); ?>"><img src="<?php echo e(Storage::url($images[0])); ?>" class="img-fluid rounded" width="80"></a>
            <?php endif; ?>
        </td>
        <td>
            <a href="<?php echo e(route('vehicle_details', ['car' => $vehicle->slug])); ?>" class="d-flex flex-column text-dark">
                <small><img src="<?php echo e(Storage::url($vehicle->brand->logo)); ?>" class="img-fluid" width="20"> <?php echo e($vehicle->brand->name); ?></small>
                <small><?php echo e($vehicle->model); ?></small>
            </a>
        </td>
        <td><a href="<?php echo e(route('vehicle_details', ['car' => $vehicle->slug])); ?>" class="text-dark"><?php echo e($vehicle->price); ?> BDT</a></td>
        <td><a href="<?php echo e(route('vehicle_details', ['car' => $vehicle->slug])); ?>" class="text-dark"><?php echo e($vehicle->category->title); ?></a></td>
        <td><a href="<?php echo e(route('vehicle_details', ['car' => $vehicle->slug])); ?>" class="text-dark"><?php echo e(ucfirst($vehicle->condition)); ?></a></td>
        <td>
            <div class="d-flex flex-column">
                <?php $campaign = json_decode($vehicle->campaign, true) ?>
                <?php if($campaign): ?>
                    <?php $__currentLoopData = $campaign; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <small><?php echo e($key); ?></small>
                        <?php if(is_array($value)): ?>
                            <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $duration => $cost): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <small><i class="fa-regular fa-clock"></i> <?php echo e($duration); ?> - <?php echo e($cost); ?> BDT</small>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <span>not found!</span>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <span>not found!</span>
                <?php endif; ?>
            </div>
        </td>
        <td><a href="<?php echo e(route('vehicle_details', ['car' => $vehicle->slug])); ?>" class="text-dark"><?php echo e(\Carbon\Carbon::parse($vehicle->publish_date)->format('M d, Y')); ?></a></td>
        <td>
            <?php if($vehicle->status === 'active'): ?>
            <form action="<?php echo e(route('admin_vehicles_status_updater')); ?>" method="POST" id="status_updater_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id" value="<?php echo e($vehicle->id); ?>">
                <select name="status" class="form-select">
                    <option value="active" <?php echo e($vehicle->status === 'active' ? 'selected' : ''); ?>>Active for Sale</option>
                    <option value="sold" <?php echo e($vehicle->status === 'sold' ? 'selected' : ''); ?>>Mark as Sold</option>
                    <option value="closed" <?php echo e($vehicle->status === 'closed' ? 'selected' : ''); ?>>Close</option>
                </select>
            </form>
            <?php elseif($vehicle->status === 'sold'): ?>
            <span class="text-success">Sold</span>
            <?php elseif($vehicle->status === 'closed'): ?>
            <span class="text-muted">Closed</span>
            <?php endif; ?>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
        <td colspan="10" class="text-center text-muted">no vehicles found!</td>
    </tr>
<?php endif; ?>
</tbody>
</table>
</div>
<div class="col-12 d-flex justify-content-between align-items-baseline py-4">
<small class="text-dark">Showing <?php echo e($vehicles->firstItem()); ?> to <?php echo e($vehicles->lastItem()); ?> of <?php echo e($vehicles->total()); ?> results</small>
<?php echo e($vehicles->links("partial.pagination")); ?>

</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$(document).ready(function() {
    $('select[name="status"]').change(function() {
        $('#status_updater_form').submit();
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/user/my_vehicles.blade.php ENDPATH**/ ?>