
<?php $__env->startSection("title"); ?> My Wishlist <?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!-- breadcrumbs -->
<div class="container">
	<div class="breadcrumbs">
		<a href="<?php echo e(route('home')); ?>"><i class="las la-home"></i></a>
		<a href="<?php echo e(route('user_account')); ?>">My Account</a>
		<a href="<?php echo e(route('user_account_wishlist')); ?>" class="active">My Wishlist</a>
	</div>
</div>
<!-- account -->
<div class="my_account_wrap section_padding_b">
	<div class="container">
		<div class="row">
			<!--  account sidebar  -->
			<?php echo $__env->make('partial.account_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
			<!-- account content -->
			<div class="col-lg-9">
				<div class="shop_cart_wrap wishlist">
					<?php $__empty_1 = true; $__currentLoopData = $wishlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
					<?php
						$images = json_decode($wl->product->images, true);
					?>
						<div class="single_shop_cart d-flex align-items-center flex-wrap mt-0">
							<div class="cart_img mb-4 mb-md-0">
								<a href="<?php echo e(route('product_view', ['slug' => $wl->product->slug])); ?>"><img loading="lazy" src="<?php echo e(Storage::url($images[0])); ?>"></a>
							</div>
							<div class="cart_cont">
								<a href="<?php echo e(route('product_view', ['slug' => $wl->product->slug])); ?>"><h5><?php echo e($wl->product->title); ?></h5></a>
								<p class="instock mb-0">Availability: 
									<?php if($wl->product->quantity > 0): ?>
										<span class="text-success">In Stock</span>
									<?php else: ?>
										<span class="text-danger">Out of Stock</span>
									<?php endif; ?>
								</p>
							</div>
							<div class="cart_price ms-md-auto ms-0">
								<p>&#x9F3;<?php echo e($wl->product->sale_price); ?></p>
							</div>
							<div class="cart_remove ms-auto align-self-end align-self-md-center">
								<a href="<?php echo e(route('product_wishlist_remover', ['id' => $wl->id])); ?>"><i class="icon-trash text-danger"></i></a>
							</div>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<h5 class="text-muted text-center">Your wishlist is empty!</h5>
					<?php endif; ?>
				</div>
				<div class="d-flex justify-content-between align-items-baseline py-4">
					<small class="text-dark">Showing <?php echo e($wishlist->firstItem()); ?> to <?php echo e($wishlist->lastItem()); ?> of <?php echo e($wishlist->total()); ?> results</small>
					<?php echo e($wishlist->links("partial.pagination")); ?>

				</div>
			</div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\computershop\resources\views/user/account_wishlist.blade.php ENDPATH**/ ?>