
<?php $__env->startSection("title"); ?> CarShop - Search Results <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.search_cars_img{
  height: 200px;
  width: 100%;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!--================================= inner-intro -->
 <section class="inner-intro bg-1 bg-overlay-black-70">
  <div class="container">
     <div class="row text-center intro-title">
           <div class="col-md-6 text-md-start d-inline-block">
            <h3 class="text-white">Results Found: <?php echo e($results->count()); ?></h3>
           </div>
           <div class="col-md-6 text-md-end float-end">
            <ul class="page-breadcrumb">
                <li><a href="<?php echo e(route('home')); ?>"><i class="fa fa-home"></i> Home</a><i class="fa fa-angle-double-right"></i></li>
                <li><span>Search Result</span></li>
            </ul>
           </div>
     </div>
  </div>
</section>
<!--================================= inner-intro -->
<!--================================= product-listing -->
<section class="product-listing page-section-pb pt-5">
<div class="container">
<div class="row">
<div class="col-12 mb-4">
<form method="GET">
<?php echo csrf_field(); ?>
  <div class="input-group">
    <input type="text" name="search" class="form-control" id="search_field" placeholder="Search by car name, brand, model or keyword" value="<?php echo e(request()->input('search')); ?>" required>
    <button type="submit" class="input-group-text bg-danger text-light border-0"><i class="fas fa-search"></i></button>
  </div>
</form>
</div>
<div class="col-12">
  <?php if($results->count() > 0): ?>
        <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="car-grid mt-3">
           <div class="row">
            <div class="col-lg-4 col-md-12">
              <div class="car-item gray-bg text-center">
                <div class="car-image position-relative">
                  <?php 
                    $images = json_decode($car->images, true);
                    $campaigns = json_decode($car->campaign, true);
                  ?>
                  <a href="<?php echo e(route('vehicle_details', ['car' => $car->slug])); ?>">
                      <img class="img-fluid rounded" src="<?php echo e(Storage::url($images[0])); ?>">
                      <?php if($car->status === "active"): ?>
                        <span class="badge bg-success position-absolute top-0 end-0 m-3">In Stock</span>
                      <?php elseif($car->status === "sold"): ?>
                        <span class="badge bg-secondary position-absolute top-0 end-0 m-3">Sold</span>
                      <?php endif; ?>
                      <?php if(isset($campaigns['Urgent'])): ?>
                        <span class="badge bg-danger position-absolute top-0 start-0 urgent_label mt-3">Urgent</span>
                      <?php endif; ?>
                  </a>
                </div>
              </div>
             </div>
              <div class="col-lg-8 col-md-12">
                <div class="car-details">
                <div class="car-title">
                 <a href="<?php echo e(route('vehicle_details', ['car' => $car->slug])); ?>"><?php echo e($car->model); ?></a>
                 <p><?php echo e(Str::limit($car->description, 125)); ?></p>
                  </div>
                  <div class="price">
                       <span class="new-price"><?php echo e($car->price); ?> BDT</span>
                       <a class="button red float-end" href="<?php echo e(route('vehicle_details', ['car' => $car->slug])); ?>">Details</a>
                     </div>
                   <div class="car-list">
                     <ul class="list-inline">
                       <li><i class="fa-solid fa-gauge-high"></i> <?php echo e($car->mileage); ?></li>
                       <li><i class="fa-solid fa-gas-pump"></i> <?php echo e($car->fuel_type); ?></li>
                       <li><i class="fa-solid fa-car-burst"></i> <?php echo e(ucfirst($car->condition)); ?></li>
                     </ul>
                   </div>
                  </div>
                </div>
              </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <div class="card card-body text-center mt-3">
          <h4 class="text-danger">No vehicles found!</h4>
        </div>
        <?php endif; ?>
</div>
<?php if($results->count() > 0): ?>
<div class="col-12 d-flex justify-content-center align-items-baseline py-4">
<?php echo e($results->links("partial.pagination")); ?>

</div>
<?php endif; ?>
</div>
</div>
</section>
<!--================================= product-listing -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/general/vehicle_search_query.blade.php ENDPATH**/ ?>