
<?php $__env->startSection("title"); ?> CarShop Admin - Blogs List <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.thumbnail_img{
    height: 40px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark border-bottom">Blogs/List</h5>
</div>
<div class="col-12 mb-3">
<form method="GET">
<?php echo csrf_field(); ?>
    <div class="input-group">
        <input type="text" class="form-control py-4" name="search" id="search_field" placeholder="Search users by title or tags..." required>
        <div class="input-group-prepend">
            <button type="submit" class="input-group-text bg-light"><i class="fas fa-search"></i></button>
        </div>
    </div>
    <a href="<?php echo e(route('admin_blogs_list')); ?>" class="text-muted d-none" id="reset_btn"><small>reset</small></a>
</form>
</div>
<div class="col-12">
<div class="card card-body p-0">
<table class="table table-bordered table-striped text-center">
<thead class="bg-dark">
    <tr>
        <th>#</th>
        <th>Thumbnail</th>
        <th>Ttile</th>
        <th>Publish Date</th>
        <th>Action</th>
    </tr>
</thead>
<tbody>
<?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td><?php echo e($loop->iteration); ?></td>
        <td><img src="<?php echo e(Storage::url($blog->thumbnail)); ?>" class="img-fluid rounded thumbnail_img"></td>
        <td><?php echo e(Str::limit($blog->title, 50)); ?></td>
        <td><?php echo e(\Carbon\Carbon::parse($blog->publish_date)->format('M d, Y')); ?></td>
        <td>
            <a class="btn btn-secondary btn-sm" href="<?php echo e(route('blogs_details', ['article' => $blog->slug])); ?>" target="_blank"><i class="fas fa-eye"></i></a>
            <a class="btn btn-info btn-sm" href="<?php echo e(route('admin_blogs_edit', ['id' => $blog->id])); ?>" class="mx-2"><i class="fas fa-edit"></i></a>
            <button type="button" class="btn btn-danger btn-sm delete_blog_btn" data-toggle="modal" data-target="#delete_blog_modal" data-id="<?php echo e($blog->id); ?>"><i class="fas fa-trash"></i></button>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <tr>
        <td colspan="5">no post found!</td>
    </tr>
<?php endif; ?>
</tbody>
</table>
</div>

<div class="modal fade" id="delete_blog_modal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-danger"><i class="fas fa-exclamation-triangle"></i> Delete This Post</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body bg-light">
        Are you sure? do you really want to delete this post?
      </div>
      <div class="modal-footer d-flex justify-content-between p-0">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <form action="<?php echo e(route('admin_blogs_delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" id="blog_id">
            <button type="submit" class="btn btn-danger">Confirm</button>
        </form>
      </div>
    </div>
  </div>
</div>
</div>
<div class="col-12 d-flex justify-content-between align-items-baseline py-4">
<small class="text-dark">Showing <?php echo e($blogs->firstItem()); ?> to <?php echo e($blogs->lastItem()); ?> of <?php echo e($blogs->total()); ?> results</small>
<?php echo e($blogs->links("partial.pagination")); ?>

</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$(document).ready(function(){
    $(".delete_blog_btn").click(function(){
      $("#blog_id").val($(this).data("id"));
    });
});
function getSearchTermFromUrl() {
  let urlParams = new URLSearchParams(window.location.search);
  return urlParams.get('search') || '';
}
window.onload = function() {
  document.getElementById('search_field').value = getSearchTermFromUrl();
  if(getSearchTermFromUrl()){
    document.getElementById('reset_btn').classList.remove('d-none');
  }
};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/admin/blogs_list.blade.php ENDPATH**/ ?>