
<?php $__env->startSection("stylesheet"); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection("title"); ?> Product - <?php echo e($product->title); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.product_images_preview{
    width: 125px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<?php
$images = json_decode($product->images, true);
?>
<div class="row">
<div class="col-12 mb-2">
<h5 class="text-dark border-bottom"><a href="<?php echo e(route('admin_products_list')); ?>" class="text-muted">Products List</a>/Product - <?php echo e($product->title); ?></h5>
</div>
<div class="col-12">
<div class="card card-body">
<form action="<?php echo e(route('admin_products_view_handler')); ?>" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<div class="row">
    <div class="col-md-6 mb-3">
        <label for="title" class="text-dark mb-0">Title</label>
        <input type="text" name="title" class="form-control mb-3" id="title" min="10" max="150" value="<?php echo e($product->title); ?>" required>
        <div class="mb-3">
            <label class="text-dark mb-0">Featured</label>
            <div class="input-group mb-2">
                <input type="text" class="form-control" id="add_featured_field">
                <input type="hidden" name="featured" id="add_featured_store_field" value="<?php echo e(isset($product->featured) ? json_encode($product->featured) : '[]'); ?>">
                <div class="input-group-prepend">
                    <button type="button" class="input-group-text" id="add_featured_btn"><i class="fas fa-plus"></i></button>
                </div>
            </div>
            <ul class="list-group" id="add_featured_ul">
                <?php if(isset($product->featured)): ?>
                    <?php
                        $featured = is_string($product->featured) 
                                    ? json_decode($product->featured, true) 
                                    : $product->featured;
                        $featured = is_array($featured) ? $featured : [];
                    ?>
                    <?php $__currentLoopData = $featured; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ftr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span><?php echo e($ftr); ?></span>
                            <i class="fas fa-circle-minus text-danger cursor_pointer remove_featured"></i>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </ul>
        </div>
        <label for="description" class="text-dark mb-0">Description</label>
        <textarea name="description" class="form-control mb-3" id="description"><?php echo e($product->description); ?></textarea>
        <div class="mb-3">
            <label class="text-dark mb-0">Specification</label>
            <div class="input-group mb-2">
                <input type="text" class="form-control" id="add_specification_field_key" placeholder="key">
                <input type="text" class="form-control" id="add_specification_field_value" placeholder="value">
                <input type="hidden" name="specification" id="add_specification_store_field" value="<?php echo e(isset($product->specification) ? json_encode($product->specification) : '[]'); ?>">
                <div class="input-group-prepend">
                    <button type="button" class="input-group-text" id="add_specification_btn"><i class="fas fa-plus"></i></button>
                </div>
            </div>
            <div>
                <span class="badge badge-light border cursor_pointer">Processor</span>
                <span class="badge badge-light border cursor_pointer">Graphics Card</span>
                <span class="badge badge-light border cursor_pointer">Ram</span>
                <span class="badge badge-light border cursor_pointer">Storage</span>
                <span class="badge badge-light border cursor_pointer">Display</span>
                <span class="badge badge-light border cursor_pointer">Keyboard</span>
                <span class="badge badge-light border cursor_pointer">Battery</span>
                <span class="badge badge-light border cursor_pointer">Operating System</span>
                <span class="badge badge-light border cursor_pointer">Security</span>
                <span class="badge badge-light border cursor_pointer">Weight</span>
            </div>
            <table class="table table-sm text-center mt-2" id="add_specification_table">
                <tbody>
                    <?php if(isset($product->specification)): ?>
                    <?php
                        $specification = is_string($product->specification) 
                                        ? json_decode($product->specification, true) 
                                        : $product->specification;
                        $specification = is_array($specification) ? $specification : [];
                    ?>
                    <?php $__currentLoopData = $specification; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $spec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($spec['key']); ?></td>
                            <td><?php echo e($spec['value']); ?></td>
                            <td><i class="fas fa-circle-minus text-danger cursor_pointer remove_specification"></i></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
        <label for="tags" class="text-dark mb-0">Tags <small class="text-muted">(separate by comma)</small></label>
        <input type="text" name="tags" class="form-control" id="tags" placeholder="eg: tag1, tag2, tag3..." value="<?php echo e(implode(', ', json_decode($product->tags))); ?>" required>
    </div>
    <div class="col-md-6 mb-3">
    <div class="row">
    <div class="col-md-6 mb-3">
        <label for="condition" class="text-dark mb-0">Select Condition</label>
        <select name="condition" class="custom-select" id="condition" required>
            <option selected disabled>-- select --</option>
            <option value="New" <?php echo e($product->condition === 'New' ? 'selected' : ''); ?>>New</option>
            <option value="Used" <?php echo e($product->condition === 'Used' ? 'selected' : ''); ?>>Used</option>
            <option value="Refurbished" <?php echo e($product->condition === 'Refurbished' ? 'selected' : ''); ?>>Refurbished</option>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="quantity" class="text-dark mb-0">Quantity</label>
        <input type="number" name="quantity" class="form-control mb-3" id="quantity" value="<?php echo e($product->quantity); ?>" required>
    </div>
    <div class="col-md-6 mb-3">
        <label for="sku" class="text-dark mb-0">SKU/Code <small class="text-danger">*</small></label>
        <input type="text" name="sku" class="form-control mb-3" id="sku" value="<?php echo e($product->sku); ?>" required>
    </div>
    <div class="col-md-6 mb-3">
        <label for="brand" class="text-dark mb-0">Select Brand</label>
        <select name="brand_id" class="custom-select" id="brand" required>
            <option selected disabled>-- select --</option>
            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($brand->id); ?>" <?php echo e(($product->brand && $brand->name === $product->brand->name) ? "selected" : ""); ?>>
                <?php echo e($brand->name); ?>

            </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="category" class="text-dark mb-0">Select Category</label>
        <select name="category_id" class="custom-select" id="category" required>
            <option selected disabled>-- Select Category --</option>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>" <?php echo e(($category->name === $product->category->name) ? "selected" : ""); ?>><?php echo e($category->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="sub_category" class="text-dark mb-0">Select Sub-Category</label>
        <select name="sub_category_id" class="custom-select" id="sub_category" required>
            <option selected disabled>-- Select Sub-Category --</option>
            <?php $__currentLoopData = $sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($sub_category->id); ?>" data-category-id="<?php echo e($sub_category->category_id); ?>" <?php echo e(($sub_category->id === $product->sub_category_id) ? 'selected' : ''); ?>><?php echo e($sub_category->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
    <div class="col-md-6 mb-3">
        <label for="regular_price" class="text-dark mb-0">Regular Price <small class="text-muted">(Optional)</small></label>
        <div class="input-group">
            <div class="input-group-prepend">
              <span class="input-group-text">BDT</span>
            </div>
            <input type="number" name="regular_price" class="form-control" id="regular_price" value="<?php echo e($product->regular_price); ?>">
        </div>
    </div>
    <div class="col-md-6 mb-2">
        <label for="sale_price" class="text-dark mb-0">Sale Price</label>
        <div class="input-group">
            <div class="input-group-prepend">
              <span class="input-group-text">BDT</span>
            </div>
            <input type="number" name="sale_price" class="form-control" id="sale_price" value="<?php echo e($product->sale_price); ?>" required>
        </div>
    </div>
    </div>
    <div class="col-12">
        <hr class="mt-0 mb-2">
    </div>
    <div class="col-12">
        <label for="meta_title" class="text-dark mb-0">Meta Title</label>
        <input type="text" name="meta_title" class="form-control mb-3" id="meta_title" value="<?php echo e($product->meta_title); ?>">
        <label for="meta_description" class="text-dark mb-0">Meta Description</label>
        <textarea name="meta_description" class="form-control" id="meta_description" rows="4"><?php echo e($product->meta_description); ?></textarea>
    </div>
    </div>
    <div class="col-12">
        <hr class="my-2">
    </div>
    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
    <div class="col-12 mb-3">
    <div class="row">
        <div class="col-md-6 d-flex flex-column justify-content-center align-items-center mb-md-0 mb-3">
            <label for="images">Select product images</label>
            <input type="file" id="images" accept=".png, .jpg, .jpeg" multiple>
        </div>
        <div class="col-md-6">
            <input type="hidden" name="images" class="images-data" value="<?php echo e($product->images); ?>">
            <ul class="list-group list-group-numbered image-previews">
                <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <span><?php echo e($loop->iteration); ?>.</span>
                    <img src="<?php echo e(Storage::url($image)); ?>" class="product_images_preview rounded">
                    <i class="fas fa-trash-alt fa-lg text-danger cursor_pointer remove-image"></i>
                </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
    </div>
    <div class="col-12 text-center">
        <button type="submit" class="btn btn-outline-primary">Save Changes</button>
    </div>
</div>
</form>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script>
$(document).ready(function() {
    $('#description').summernote({
        tabsize: 2,
        height: 250
    });

    let featuredArray = <?php echo json_encode(empty($product->featured) ? [] : (is_string($product->featured) ? json_decode($product->featured, true) : $product->featured), 512) ?>;
    $('#add_featured_btn').click(function() {
        let value = $('#add_featured_field').val().trim();
        if (value) {
            featuredArray.push(value);
            let listItem = `<li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${value}</span>
                                <i class="fas fa-circle-minus text-danger cursor_pointer remove_featured"></i>
                            </li>`;
            $('#add_featured_ul').append(listItem);
            $('#add_featured_store_field').val(JSON.stringify(featuredArray));
            $('#add_featured_field').val('').focus();
        }
    });
    $(document).on('click', '.remove_featured', function() {
        let listItem = $(this).closest('li');
        let value = listItem.find('span').text();
        featuredArray = featuredArray.filter(function(item) {
            return item !== value;
        });
        listItem.remove();
        $('#add_featured_store_field').val(JSON.stringify(featuredArray));
    });

    $('.badge.cursor_pointer').click(function() {
        let badgeText = $(this).text().trim();
        $('#add_specification_field_key').val(badgeText);
    })
    let specificationArray = <?php echo json_encode(empty($product->specification) ? [] : (is_string($product->specification) ? json_decode($product->specification, true) : $product->specification), 512) ?>;
    $('#add_specification_btn').click(function() {
        let key = $('#add_specification_field_key').val().trim();
        let value = $('#add_specification_field_value').val().trim();
        if (key && value) {
            specificationArray.push({key: key, value: value});
            let tableRow = `<tr>
                                <td>${key}</td>
                                <td>${value}</td>
                                <td><i class="fas fa-circle-minus text-danger cursor_pointer remove_specification"></i></td>
                            </tr>`;
            $('#add_specification_table tbody').append(tableRow);
            $('#add_specification_store_field').val(JSON.stringify(specificationArray));
            $('#add_specification_field_key').val('').focus();
            $('#add_specification_field_value').val('');
        }
    });
    $(document).on('click', '.remove_specification', function() {
        let tableRow = $(this).closest('tr');
        let key = tableRow.find('td:first').text();
        specificationArray = specificationArray.filter(item => item.key !== key);
        tableRow.remove();
        $('#add_specification_store_field').val(JSON.stringify(specificationArray));
    });

    let imageDataArray = <?php echo json_encode(json_decode($product->images, true), 512) ?>;
    $('#images').change(async function() {
        let existingImagesCount = $('.image-previews li').length;
        for (let index = 0; index < this.files.length; index++) {
            const file = this.files[index];
            const reader = new FileReader();
            await new Promise((resolve, reject) => {
                reader.onload = function(event) {
                    $('.image-previews').append('<li class="list-group-item d-flex justify-content-between align-items-center">' +
                        '<span>'+ (existingImagesCount + index + 1) +'.</span>' +
                        '<img src="' + event.target.result + '" class="product_images_preview rounded">' +
                        '<i class="fas fa-trash-alt fa-lg text-danger cursor_pointer remove-image"></i>' +
                        '</li>');
                    imageDataArray.push(event.target.result);
                    $('.images-data').val(JSON.stringify(imageDataArray));
                    resolve();
                };
                reader.onerror = function(error) {
                    reject(error);
                };
                reader.readAsDataURL(file);
            });
        }
    });
    $(document).on('click', '.remove-image', function() {
        let imageIndex = $(this).parent().index();
        imageDataArray.splice(imageIndex, 1);
        $('.images-data').val(JSON.stringify(imageDataArray));
        $(this).parent().remove();
    });
    
    let categories = <?php echo json_encode($categories->pluck('name', 'id')->toArray()); ?>;
    let subCategories = <?php echo $sub_categories->groupBy('category_id')->map->pluck('name', 'id')->toJson(); ?>;
    function populateSubCategories(categoryId, selectedSubCategoryId = null) {
        let subCategoryOptions = '<option selected disabled>-- Select Sub-Category --</option>';
        if (subCategories.hasOwnProperty(categoryId)) {
            $.each(subCategories[categoryId], function(subCategoryId, subCategoryName) {
                let selected = (selectedSubCategoryId && selectedSubCategoryId == subCategoryId) ? 'selected' : '';
                subCategoryOptions += `<option value="${subCategoryId}" ${selected}>${subCategoryName}</option>`;
            });
        }
        $('#sub_category').html(subCategoryOptions);
    }
    let initialCategoryId = $('#category').val();
    let selectedSubCategoryId = <?php echo json_encode($product->sub_category_id); ?>;
    if (initialCategoryId) {
        populateSubCategories(initialCategoryId, selectedSubCategoryId);
    }
    $('#category').change(function() {
        let categoryId = $(this).val();
        populateSubCategories(categoryId);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yasiritc/public_html/resources/views/admin/products_view.blade.php ENDPATH**/ ?>