
<?php $__env->startSection("title"); ?> Verify Your Email <?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<!-- breadcrumbs -->
<div class="container">
  <div class="breadcrumbs">
    <a href="<?php echo e(route('home')); ?>"><i class="las la-home"></i></a>
    <a href="<?php echo e(route('verification.notice')); ?>" class="active">Verify Your Email</a>
  </div>
</div>
<!-- verify email -->
<div class="section_padding mb-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-5 col-lg-7">
                <div class="padding_default shadow_sm">
                    <h2 class="title_2">Thanks for signing up 🎉</h2>
                    <p class="text_md mb-4">Before getting started, could you verify your email address by clicking on the link we just emailed to you?
                        <br><br>
                        If you didn't receive the email, we will gladly send you another.</p>
                    <form action="<?php echo e(route('verification.send')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-12 text-center mb-3">
                                <?php if(session('status') == 'verification-link-sent'): ?>
                                <div class="alert alert-info fade show" role="alert">A new verification link has been sent to the email address you provided during registration.</div>
                                <?php endif; ?>
                                <?php if($errors->any() || session('error')): ?>
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <?php if(session('error')): ?>
                                        <?php echo e(session('error')); ?>

                                    <?php else: ?>
                                    <ul class="my-0 mx-2">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                                <div class="col-12 text-center">
                                    <button type="submit" class="default_btn xs_btn rounded px-4 d-block w-100">Resend Verification Email</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("general_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\computershop\resources\views/auth/verify_email.blade.php ENDPATH**/ ?>