
<?php $__env->startSection("title"); ?> Coupons Code <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark border-bottom">Coupons List</h5>
</div>
<div class="col-12 d-flex justify-content-end mb-3">
<button type="button" class="btn btn-dark" data-toggle="modal" data-target="#add_coupon_modal"><i class="fas fa-plus"></i> Add New Coupon</button>
</div>
<div class="col-12 mb-3">
<form method="GET">
    <div class="input-group">
        <input type="text" class="form-control py-4" name="search" id="search_field" placeholder="Search by coupon codes..." required>
        <div class="input-group-prepend">
            <button type="submit" class="input-group-text bg-light"><i class="fas fa-search"></i></button>
        </div>
    </div>
    <a href="<?php echo e(route('admin_coupons')); ?>" class="text-muted d-none" id="reset_btn"><small>reset</small></a>
</form>
</div>
<div class="col-12">
<table class="table table-bordered text-center bg-white">
<thead class="bg-dark">
    <tr>
        <th>#</th>
        <th>Code</th>
        <th>Value</th>
        <th>Type</th>
        <th>Valid From</th>
        <th>Valid Until</th>
        <th>Used</th>
        <th>Usage Limit</th>
        <th>Created at</th>
        <th><i class="fas fa-circle-minus"></i></th>
    </tr>
</thead>
<tbody>
<?php $__empty_1 = true; $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr>
    <td><?php echo e($loop->iteration); ?></td>
    <td class="text-dark font-weight-bold"><?php echo e($coupon->code); ?></td>
    <td><?php echo e($coupon->type == 'fixed' ? '৳'.$coupon->value : $coupon->value.'%'); ?></td>
    <td><?php echo e(ucfirst($coupon->type)); ?></td>
    <td>
        <div class="d-flex flex-column">
            <small><?php echo e(\Carbon\Carbon::parse($coupon->valid_from)->format('h:i A')); ?></small>
            <small><?php echo e(\Carbon\Carbon::parse($coupon->valid_from)->format('d M, Y')); ?></small>
        </div>
    </td>
    <td>
        <div class="d-flex flex-column">
            <small><?php echo e(\Carbon\Carbon::parse($coupon->valid_until)->format('h:i A')); ?></small>
            <small><?php echo e(\Carbon\Carbon::parse($coupon->valid_until)->format('d M, Y')); ?></small>
        </div>
    </td>
    <td><?php echo e($coupon->usage_count); ?></td>
    <td><?php echo e($coupon->usage_limit); ?></td>
    <td>
        <div class="d-flex flex-column">
            <small><?php echo e(\Carbon\Carbon::parse($coupon->created_at)->format('h:i A')); ?></small>
            <small><?php echo e(\Carbon\Carbon::parse($coupon->created_at)->format('d M, Y')); ?></small>
        </div>
    </td>
    <td>
        <form action="<?php echo e(route('admin_coupons_remove')); ?>" method="POST" class="d-inline">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" value="<?php echo e($coupon->id); ?>">
            <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
        </form>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
  <td colspan="10" class="text-muted">no coupons found!</td>
</tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
<!-- add coupon modal -->
<div class="modal fade" id="add_coupon_modal" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark"><i class="fas fa-ticket"></i> Add New Coupon</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="<?php echo e(route('admin_coupons_add')); ?>" method="POST">
      <div class="modal-body bg-light">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-md-7 mx-auto mb-3">
                <label for="code" class="mb-1">Give a Unique Code for New Coupon</label>
                <input type="text" name="code" class="form-control" id="code" placeholder="eg: ABC123" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="value" class="mb-1">Value/Discount</label>
                <input type="tel" name="value" class="form-control" id="value" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="type" class="mb-1">Select Coupon Type</label>
                <select name="type" id="type" class="custom-select" required>
                    <option value="fixed">Fixed</option>
                    <option value="percentage">Percentage</option>
                </select>
            </div>
            <div class="col-md-6 mb-3">
                <label for="valid_from" class="mb-1">Valid From</label>
                <input type="datetime-local" name="valid_from" class="form-control" id="valid_from" required>
            </div>
            <div class="col-md-6 mb-3">
                <label for="valid_until" class="mb-1">Valid Until</label>
                <input type="datetime-local" name="valid_until" class="form-control" id="valid_until" required>
            </div>
            <div class="col-md-6">
                <label for="usage_limit" class="mb-1">Usage Limit</label>
                <input type="number" name="usage_limit" class="form-control" id="usage_limit" placeholder="how many times this coupon can be usable?" required>
            </div>
        </div>
      </div>
      <div class="modal-footer d-flex justify-content-between p-0">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-success">Submit</button>
      </div>
      </form>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
function getSearchTermFromUrl() {
    let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get('search') || '';
}
window.onload = function() {
    document.getElementById('search_field').value = getSearchTermFromUrl();
    if(getSearchTermFromUrl()){
        document.getElementById('reset_btn').classList.remove('d-none');
    }
};
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/computec/public_html/resources/views/admin/coupons.blade.php ENDPATH**/ ?>