
<?php $__env->startSection("stylesheet"); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection("title"); ?> CarShop Admin - Post New Blog <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.preview_img{
    width: 400px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12 mb-2">
<h5 class="text-dark border-bottom">Blogs/Publish New Post</h5>
</div>
<div class="col-12">
<div class="card card-body">
<form action="<?php echo e(route('admin_blogs_add_handler')); ?>" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<div class="row">
<div class="col-12 mb-3">
<div class="d-flex flex-column align-items-center">
<img src="<?php echo e(asset('images/placeholder_img.png')); ?>" class="img-fluid rounded preview_img mb-3">
<input type="file" name="thumbnail" id="thumbnail" required>
</div>
</div>
<div class="col-12 mb-3">
    <label for="title" class="text-dark mb-0">Write a caption for your post</label>
    <input type="text" name="title" class="form-control" id="title" required>
</div>
<div class="col-12 mb-3">
    <label for="content" class="text-dark mb-0">Content</label>
    <textarea name="content" class="form-control" id="content" required></textarea>
</div>
<div class="col-12 mb-3">
    <label for="tags" class="text-dark mb-0">Add some tags <span class="text-muted">(separate by comma)</span></label>
    <input type="text" name="tags" class="form-control" id="tags" placeholder="eg: tag1, tag2, tag3..." required>
</div>
<div class="col-12 text-center">
    <button type="submit" class="btn btn-success">Publish Now</button>
</div>
</div>
</form>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
<script>
$(document).ready(function() {
    const thumbnail = $('#thumbnail');
    const preview_img = $('.preview_img');

    thumbnail.on('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                preview_img.attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });

    $('#content').summernote({
        tabsize: 2,
        height: 200
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/admin/blogs_add.blade.php ENDPATH**/ ?>