
<?php $__env->startSection("title"); ?> CarShop Admin - Parts/Accessories Reviews <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.avatar_img{
    width: 40px;
    height: 40px;
    border-radius: 50%;   
}
img.product_list_img{
    width: 80px;
    height: 45px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark border-bottom">Parts/Accessories Reviews</h5>
</div>
<div class="col-12">
<div class="card card-body p-0">
<table class="table table-bordered text-center">
    <thead class="bg-dark">
        <tr>
            <th>#</th>
            <th>User</th>
            <th>Product</th>
            <th>Review</th>
            <th>Date</th>
            <th>Trash</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td>
                <a href="<?php echo e(route('admin_users_view', ['uid' => $review->user->id])); ?>" class="text-dark"><img src="<?php echo e(Storage::url($review->user->avatar)); ?>" class="img-fluid avatar_img">
                <?php echo e($review->user->full_name); ?></a>
            </td>
            <td>
                <a href="<?php echo e(route('admin_pna_inventory_edit', ['id' => $review->pna->id])); ?>" class="d-flex align-items-center text-dark">
                    <?php if($review->pna->images): ?>
                        <?php $images = json_decode($review->pna->images, true); ?>
                        <img src="<?php echo e(Storage::url($images[0])); ?>" class="img-fluid rounded product_list_img mr-1">
                    <?php endif; ?>
                    <span><?php echo e(Str::limit($review->pna->title, 50)); ?></span>
                </div>
            </td>
            <td>
                <div>
                    <?php for($i = 0; $i < 5; $i++): ?>
                        <?php if($i < $review->rating): ?>
                            <i class="fas fa-star fa-sm text-warning"></i>
                        <?php else: ?>
                            <i class="fas fa-star fa-sm"></i>
                        <?php endif; ?>
                    <?php endfor; ?>
                </div>
                <small class="text-dark"><?php echo e($review->feedback); ?></small>
            </td>
            <td><?php echo e(\Carbon\Carbon::parse($review->issued_at)->format('M d, Y h:i A')); ?></td>
            <td>
                <form action="<?php echo e(route('admin_pna_reviews_remover')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e($review->id); ?>">
                    <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
                </form>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/admin/pna_reviews.blade.php ENDPATH**/ ?>