
<?php $__env->startSection("title"); ?> General Settings <?php $__env->stopSection(); ?>
<?php $__env->startSection("style"); ?>
<style>
img.favicon_preview{
    width: 25px;
}
img.logo_img_preview{
    width: 250px;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark">Settings</h5>
</div>
<div class="col-12">
<div class="card card-body">
<form action="<?php echo e(route('admin_settings_general_updater')); ?>" method="POST" enctype="multipart/form-data">
<?php echo csrf_field(); ?>
<div class="row">
<div class="col-12 border-bottom text-center mb-3">
<small class="text-muted">Favicon & Logo</small>
</div>
<div class="col-12 mb-4">
<div class="row">
    <div class="col-md-4 d-flex flex-column align-items-center">
        <span>Favicon Icon</span>
        <img src="<?php echo e($settings->favicon ? Storage::url($settings->favicon) : asset('images/favicon.ico')); ?>" class="img-fluid rounded favicon_preview mt-2 mb-3">
        <input type="file" name="favicon" class="favicon mb-md-0 mb-3">
    </div>
    <div class="col-md-4 d-flex flex-column align-items-center">
        <span>Site logo</span>
        <img src="<?php echo e($settings->logo_site ? Storage::url($settings->logo_site) : asset('images/placeholder_img.png')); ?>" class="img-fluid rounded logo_img_preview img_preview_site my-2">
        <input type="file" name="logo_site" class="logo_site mb-md-0 mb-3">
    </div>
    <div class="col-md-4 d-flex flex-column align-items-center">
        <span>Admin logo</span>
        <img src="<?php echo e($settings->logo_admin ? Storage::url($settings->logo_admin) : asset('images/placeholder_img.png')); ?>" class="img-fluid rounded logo_img_preview img_preview_admin my-2">
        <input type="file" name="logo_admin" class="logo_admin">
    </div>
</div>
</div>

<div class="col-12 border-bottom text-center mb-3">
<small class="text-muted">Title</small>
</div>
<div class="col-md-10 mx-auto mb-4">
<div class="row">
<div class="col-md-6 mb-md-0 mb-3">
    <label for="title_site" class="text-dark mb-0">Site Title</label>
    <input type="text" name="title_site" class="form-control" id="title_site" value="<?php echo e($settings->title_site); ?>" required>
</div>
<div class="col-md-6">
    <label for="title_admin" class="text-dark mb-0">Admin Title</label>
    <input type="text" name="title_admin" class="form-control" id="title_admin" value="<?php echo e($settings->title_admin); ?>" required>
</div>
</div>
</div>

<div class="col-12 border-bottom text-center mb-3">
<small class="text-muted">Footer</small>
</div>
<div class="col-12 mx-auto mb-4">
<div class="row">
<div class="col-md-7 mb-3">
    <label for="footer_copyright" class="text-dark mb-0">Footer Copyright</label>
    <input type="text" name="footer_copyright" class="form-control mb-3" id="footer_copyright" value="<?php echo e($settings->footer_copyright); ?>" required>
    <label for="footer_description" class="text-dark mb-0">Footer Description</label>
    <textarea name="footer_description" class="form-control" id="footer_description" rows="4"><?php echo e($settings->footer_description); ?></textarea>
</div>
<div class="col-12">
<div class="row">
    <div class="col-md-4">
        <label for="contact_address" class="text-dark mb-0">Contact Address</label>
        <input type="text" name="contact_address" class="form-control mb-3" id="contact_address" value="<?php echo e($settings->contact_address); ?>" required>
    </div>
    <div class="col-md-4">
        <label for="contact_phone" class="text-dark mb-0">Contact Phone</label>
        <input type="tel" name="contact_phone" class="form-control mb-3" id="contact_phone" value="<?php echo e($settings->contact_phone); ?>" required>
    </div>
    <div class="col-md-4">
        <label for="contact_email" class="text-dark mb-0">Contact Email</label>
        <input type="email" name="contact_email" class="form-control" id="contact_email" value="<?php echo e($settings->contact_email); ?>" required>
    </div>
</div>
</div>
</div>
</div>

<div class="col-12 border-bottom text-center mb-3">
<small class="text-muted">SEO</small>
</div>
<div class="col-12 mb-4">
<div class="row">
    <div class="col-md-5">
        <label for="ga_id" class="text-dark mb-0">Google Analytics ID</label>
        <input type="text" name="ga_id" class="form-control mb-3" id="ga_id" value="<?php echo e($settings->ga_id); ?>" placeholder="UA-01234560-0">
    </div>
    <div class="col-md-7">
        <label for="meta_author" class="text-dark mb-0">Meta Author</label>
        <input type="text" name="meta_author" class="form-control mb-3" id="meta_author" value="<?php echo e($settings->meta_author); ?>">
    </div>
    <div class="col-md-6 mb-md-0 mb-3">
        <label for="meta_description" class="text-dark mb-0">Meta Description</label>
        <textarea name="meta_description" class="form-control" id="meta_description" rows="3"><?php echo e($settings->meta_description); ?></textarea>
    </div>
    <div class="col-md-6">
        <label for="meta_keywords" class="text-dark mb-0">Meta Keywords</label>
        <textarea name="meta_keywords" class="form-control" id="meta_keywords" rows="3"><?php echo e($settings->meta_keywords); ?></textarea>
    </div>
</div>
</div>

<div class="col-12 border-bottom text-center mb-3">
<small class="text-muted">Social Links</small>
</div>
<div class="col-12 mb-4">
<div class="row">
<div class="col-md-4 mb-md-0 mb-3">
    <label for="platform" class="text-dark mb-0">Select Platform</label>
    <select class="custom-select mb-3" id="platform">
        <option selected disabled>-- select --</option>
        <option value="facebook">Facebook</option>
        <option value="facebook-messenger">Facebook Messenger</option>
        <option value="twitter">Twitter</option>
        <option value="square-x-twitter">X (New Twitter)</option>
        <option value="instagram">Instagram</option>
        <option value="tiktok">TikTok</option>
        <option value="linkedin">LinkedIn</option>
        <option value="github">GitHub</option>
        <option value="discord">Discord</option>
        <option value="youtube">YouTube</option>
        <option value="medium">Medium</option>
        <option value="vimeo">Vimeo</option>
        <option value="whatsapp">WhatsApp</option>
        <option value="telegram">Telegram</option>
        <option value="pinterest">Pinterest</option>
        <option value="skype">Skype</option>
        <option value="viber">Viber</option>
        <option value="tumblr">Tumblr</option>
        <option value="snapchat">Snapchat</option>
        <option value="reddit">Reddit</option>
    </select>

    <label for="url" class="text-dark mb-0">Paste URL</label>
    <div class="input-group">
        <input type="url" class="form-control" id="url">
        <div class="input-group-prepend">
            <button type="button" class="input-group-text add_link"><i class="fas fa-plus"></i></button>
        </div>
    </div>
</div>
<div class="col-md-6 mb-md-0 mb-3 offset-2">
    <ul class="list-group" id="link_list">
        <li class="list-group-item text-muted text-center">you have no links added yet!</li>
    </ul>
</div>
</div>
</div>
<input type="hidden" name="social_ids" id="social_ids_field" value="<?php echo e($settings->social_ids); ?>" required>
<div class="col-12 text-center">
<button type="submit" class="btn btn-success">Save Changes</button>
</div>

</div>
</form>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
$(document).ready(function() {
    $('.favicon').on('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('.favicon_preview').attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });

    $('.logo_site').on('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('.img_preview_site').attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });

    $('.logo_admin').on('change', function() {
        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('.img_preview_admin').attr('src', e.target.result);
            }
            reader.readAsDataURL(file);
        }
    });

    let links = <?php echo $settings->social_ids; ?>;
    function displayInitialLinks() {
        $('#link_list').empty();
        if (links && links.length > 0) {
            links.forEach(link => {
                let listItem = `<li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                    <a href="${url}" target="_blank"><i class="${link.platform}"></i> ${link.url}</a>
                                    <button type="button" class="btn btn-sm btn-danger remove_link" data-url="${link.url}"><i class="fas fa-minus fa-sm"></i></button>
                                </li>`;
                $('#link_list').append(listItem);
            });
        } else {
            $('#link_list').html('<li class="list-group-item text-muted text-center">You have no links added yet!</li>');
        }
    }
    displayInitialLinks();
    $('.add_link').click(function() {
        let platform = $('#platform').val();
        let url = $('#url').val();
        if (!links) {
            links = [];
        }
        if (platform && url) {
            links.push({ platform: platform, url: url });
            $('#social_ids_field').val(JSON.stringify(links));
            let listItem = `<li class="list-group-item d-flex justify-content-between align-items-center text-dark">
                                <a href="${url}" target="_blank"><i class="${platform}"></i> ${url}</a>
                                <button type="button" class="btn btn-sm btn-danger remove_link" data-url="${url}"><i class="fas fa-minus fa-sm"></i></button>
                            </li>`;
            $('#link_list').append(listItem);
            $('#platform').val($('#platform option:first').val());
            $('#url').val('');
        }
    });
    $('#link_list').on('click', '.remove_link', function() {
        let urlToRemove = $(this).data('url');
        links = links.filter(link => link.url !== urlToRemove);
        $('#social_ids_field').val(JSON.stringify(links));
        $(this).closest('li').remove();
        if ($('#link_list').children().length === 0) {
            $('#link_list').html('<li class="list-group-item text-muted text-center">You have no links added yet!</li>');
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yasiritc/public_html/resources/views/admin/settings_general.blade.php ENDPATH**/ ?>