<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($settings->ga_id); ?>"></script>
<script>
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());
gtag('config', <?php echo e($settings->ga_id); ?>);
</script>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
<meta name="author" content="<?php echo e($settings->meta_author); ?>" />
<?php if(isset($product->meta_title)): ?>
<?php echo $__env->yieldContent("product_meta_title"); ?>
<?php endif; ?>
<?php if(isset($product->meta_description)): ?>
<?php echo $__env->yieldContent("product_meta_description"); ?>
<?php else: ?>
<meta name="description" content="<?php echo e($settings->meta_description); ?>" />
<?php endif; ?>
<meta name="keywords" content="<?php echo e($settings->meta_keywords); ?>" />
<link rel="shortcut icon" href="<?php echo e(Storage::url($settings->favicon)); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/bootstrap.min.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/flaticon.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/mega-menu/mega_menu.css')); ?>" />
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/slick/slick.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/slick/slick-theme.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/owl-carousel/owl.carousel.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('revolution/css/settings.css')); ?>">
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/style.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/jquery-ui.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/responsive.css')); ?>" />
<title><?php echo e($settings->title_site); ?> - <?php echo $__env->yieldContent("title"); ?></title>
<style>
.owl-nav button span{
  font-size: 50px;
  margin: 0 -8px;
}
html::-webkit-scrollbar{
  width: 10px;
  height: 10px;
}
html::-webkit-scrollbar-track-piece{
  background-color: #1C1C1C;
}
html::-webkit-scrollbar-thumb:vertical{
  height: 30px;
  background-color: #DB2D2E;
  border-radius: 10px;
}
ul.pagination li.page-item{
  list-style: none;
}
ul.pagination li.page-item .page-link{
  height: 40px;
  display: flex;
  align-items: center;
  margin: 0;
}
.urgent_label{
  rotate: -45deg;
}
.navbar_user_avatar{
  width: 25px;
  height: 25px;
  border-radius: 50%;
}
img.feature_cars_slider_img{
  height: 155px;
}
.bg-1{
  background-image: url("<?php echo e(asset('images/section_bg.png')); ?>");
}
.mtb_6030{
  margin-top: 60px;
  margin-bottom: 30px;
}
.cart_icon{
  position: relative;
  display: inline-block;
}
.cart_badge{
  position: absolute;
  top: 22px;
  right: 5px;
  transform: translate(50%, -50%);
  border-radius: 50%;
  font-size: 8px;
}
img.payment_method_logo{
  width: 50px;
  border-radius: .25rem;
}
</style>
<?php echo $__env->yieldContent("style"); ?>
</head>
<body>
<!--================================= loading -->
 <div id="loading">
    <div id="loading-center">
        <img src="<?php echo e(asset('images/loader.gif')); ?>">
    </div>
</div>
<!--================================= loading -->

<!--================================= header -->
<header id="header" class="fancy">
<div class="topbar">
	<div class="container">
		<div class="row">
			<div class="col-lg-6 col-md-12">
				<div class="topbar-left text-lg-start text-center">
          <ul class="list-inline">
            <li><i class="fas fa-envelope"></i> <?php echo e($settings->contact_email); ?></li>
            <li><i class="fas fa-phone"></i> <?php echo e($settings->contact_phone); ?></li>
            <?php if(!empty($settings->social_ids)): ?>
            <?php
              $socialLinks = json_decode($settings->social_ids, true);
            ?>
              <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><a href="<?php echo e($link['url']); ?>" target="_blank"><i class="<?php echo e($link['platform']); ?>"></i></a></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
          </ul>
				</div>
			</div>
			<div class="col-lg-6 col-md-12">
				<div class="topbar-right text-lg-end text-center">
					<ul class="list-inline">
            <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#finance_calculator"><i class="fa-solid fa-calculator"></i></a></li>
            <li>Want to Sell? <?php if(Auth::check()): ?> <a href="<?php echo e(route('vehicle_publish_new')); ?>">Post Your Car</a> <?php else: ?> <a href="<?php echo e(route('vehicle_publish_new')); ?>">Join as Dealer</a><?php endif; ?></li>
          </ul>
				</div>
			</div>
		</div>
	</div>
</div>

<!--================================= mega menu -->
<div class="menu">
  <div class="container">
    <div class="row">
     <div class="col-md-12">
     <!-- menu start -->
       <nav id="menu" class="mega-menu">
        <!-- menu list items container -->
        <section class="menu-list-items">
            <!-- menu logo -->
            <ul class="menu-logo">
                <li>
                    <a href="<?php echo e(route('home')); ?>"><img id="logo_dark_img" src="<?php echo e(Storage::url($settings->logo_site)); ?>" alt="logo"></a>
                </li>
            </ul>
            <!-- menu links -->
            <ul class="menu-links">
              <li>
                <a href="javascript:void(0)">Vehicles <i class="fa fa-angle-down fa-indicator"></i></a>
                <ul class="drop-down-multilevel">
                  <?php $__currentLoopData = $vehicle_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li><a href="<?php echo e(route('search_query', ['search' => $category->title])); ?>"><?php echo e($category->title); ?></a></li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
              </li>
              <li>
                <a href="javascript:void(0)">Brands <i class="fa fa-angle-down fa-indicator"></i></a>
                <ul class="drop-down-multilevel">
                  <?php $__empty_1 = true; $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                      <?php
                          $searchTerm = str_replace('%2B', '+', $brand->name);
                      ?>
                      <li><a href="<?php echo e(route('search_query', ['search' => $searchTerm])); ?>"><?php echo e($brand->name); ?></a></li>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                      <li>No brands found</li>
                  <?php endif; ?>
              </ul>              
              </li>
              <li class="<?php echo e(isset($active_page) && $active_page == 'pna' ? 'active' : ''); ?>"><a href="<?php echo e(route('pna_landing_page')); ?>">Parts & Accessories</a></li>
              <li><a href="<?php echo e(route('blogs')); ?>">News</a></li>
              <?php if(Auth::check()): ?>
                <li><a href="<?php echo e(route('vehicle_publish_new')); ?>">Sell Now</a></li>
                <li>
                  <div class="d-flex align-items-center cursor_pointer"><img src="<?php echo e(Storage::url( auth()->user()->avatar )); ?>" class="img-fluid navbar_user_avatar"> <span class="mx-1">My Account</span> <i class="fa fa-angle-down fa-indicator"></i></div>
                  <ul class="drop-down-multilevel">
                    <?php if(auth()->user()->is_admin): ?>
                    <li><a href="<?php echo e(route('admin_dashboard')); ?>">Admin Panel</a></li>
                    <?php endif; ?>
                    <li><a href="<?php echo e(route('user_profile')); ?>">Profile</a></li>
                    <li><a href="<?php echo e(route('user_my_vehicles')); ?>">My Vehicles</a></li>
                    <li><a href="<?php echo e(route('user_my_orders')); ?>">Order History</a></li>
                    <li><a href="<?php echo e(route('logout')); ?>">Logout</a></li>
                  </ul>
                </li>
              <?php else: ?>
                <li><a href="<?php echo e(route('signin')); ?>"><i class="fas fa-user"></i> My Account</a></li>
              <?php endif; ?>
              <li>
                  <a href="<?php echo e(route('pna_cart')); ?>" class="cart_icon ps-2 pe-1"><i class="fa-solid fa-cart-shopping fa-lg"></i>
                    <span class="badge bg-danger cart_badge"></span>
                  </a>
              </li>
              <li>
              <div class="search-top"><a class="search-btn not_click d-none d-lg-block" href="javascript:void(0);">Search Button</a>
                <div class="search-box not-click px-2">
                  <form action="<?php echo e(route('search_query')); ?>" method="GET">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                      <input type="text" name="search" class="form-control search_bar_input" placeholder="Search by car name, brand, model or keyword" required>
                      <button type="submit" class="input-group-text border-0">Search</button>
                    </div>
                  </form>
                </div>
              </div>
              </li>
           </section>
         </nav>
       </div>
     </div>
    </div>
   </div>
  <!-- menu end -->
</header>
<?php if(session("success")): ?>
<div class="toast-container position-fixed bottom-0 end-0 p-3">
  <div class="toast <?php if(session('success')): ?> bg-success <?php elseif(session('info')): ?> bg-info <?php else: ?> bg-danger <?php endif; ?> text-white" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-body d-flex justify-content-between">
      <span><?php echo e(session("success")); ?></span>
    </div>
  </div>
</div>
<?php endif; ?>
<?php if(session("info")): ?>
<div class="toast-container position-fixed bottom-0 end-0 p-3">
  <div class="toast <?php if(session('success')): ?> bg-success <?php elseif(session('info')): ?> bg-info <?php else: ?> bg-danger <?php endif; ?> text-white" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-body d-flex justify-content-between">
      <span><?php echo e(session("info")); ?></span>
    </div>
  </div>
</div>
<?php endif; ?>
<?php if(session("error")): ?>
<div class="toast-container position-fixed bottom-0 end-0 p-3">
  <div class="toast <?php if(session('success')): ?> bg-success <?php elseif(session('info')): ?> bg-info <?php else: ?> bg-danger <?php endif; ?> text-white" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-body d-flex justify-content-between">
      <span><?php echo e(session("error")); ?></span>
    </div>
  </div>
</div>
<?php endif; ?>
<?php if($errors->any()): ?>
<div class="toast-container position-fixed bottom-0 end-0 p-3">
  <div class="toast bg-danger text-white" role="alert" aria-live="assertive" aria-atomic="true">
    <div class="toast-body d-flex justify-content-between">
      <ul class="mb-0">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </ul>
    </div>
  </div>
</div>
<?php endif; ?>
<!--================================= header -->
<!--================================= page content -->
<?php echo $__env->yieldContent("content"); ?>
<!--================================= page content -->
<!--================================= footer -->
<footer class="footer-2 page-section-pt">
  <div class="container">
    <div class="row">
      <div class="col-lg-3 col-md-6">
        <div class="about-content">
          <img class="img-fluid" id="logo-footer" src="<?php echo e(Storage::url($settings->logo_site)); ?>">
          <p class="text-gray"><?php echo e($settings->footer_description); ?></p>
        </div>
        <div class="social">
        <ul>
          <?php if(!empty($settings->social_ids)): ?>
            <?php
              $socialLinks = json_decode($settings->social_ids, true);
            ?>
            <?php $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <li><a href="<?php echo e($link['url']); ?>" target="_blank"><i class="<?php echo e($link['platform']); ?>"></i></a></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php endif; ?>
        </ul>
       </div>
      </div>
      <div class="col-lg-3 col-md-6">
        <div class="usefull-link">
        <h6 class="text-white"><?php echo e($settings->footer_link_1); ?></h6>
          <ul>
            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php if($page->position == 'left'): ?>
                <li><a href="<?php echo e(route('page_details', ['slug' => $page->slug])); ?>"><i class="fas fa-angle-right"></i> <?php echo e($page->name); ?></a></li>
              <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-lg-3 col-md-6">
       <div class="usefull-link">
        <h6 class="text-white"><?php echo e($settings->footer_link_2); ?></h6>
          <ul>
            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php if($page->position == 'right'): ?>
                <li><a href="<?php echo e(route('page_details', ['slug' => $page->slug])); ?>"><i class="fas fa-angle-right"></i> <?php echo e($page->name); ?></a></li>
              <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </ul>
        </div>
      </div>
      <div class="col-lg-3 col-md-6">
      <div class="keep-touch">
        <h6 class="text-white"><?php echo e($settings->footer_link_3); ?></h6>
         <div class="address">
          <ul>
            <li><i class="fas fa-map-marker"></i><span><?php echo e($settings->contact_address); ?></span></li>
            <li><i class="fas fa-phone"></i><span><?php echo e($settings->contact_phone); ?></span></li>
            <li><i class="fas fa-envelope"></i><span><?php echo e($settings->contact_email); ?></span></li>
          </ul>
        </div>
       </div>
      </div>
    </div>
    </div>
    <div class="copyright">
     <div class="container">
      <div class="row">
      <div class="col-lg-6 col-md-12">
       <div class="text-lg-start text-center">
         <p><?php echo $settings->footer_copyright; ?></p>
       </div>
      </div>
      <div class="col-lg-6 col-md-12">
        <ul class="list-inline text-lg-end text-center">
          <li>Pay with</li>
          <li><img src="<?php echo e(asset('images/payments/bkash.jpg')); ?>" class="payment_method_logo"></li>
          <li><img src="<?php echo e(asset('images/payments/nagad.jpg')); ?>" class="payment_method_logo"></li>
          <li><img src="<?php echo e(asset('images/payments/rocket.jpg')); ?>" class="payment_method_logo"></li>
          <li><img src="<?php echo e(asset('images/payments/upay.png')); ?>" class="payment_method_logo"></li>
          <li><img src="<?php echo e(asset('images/payments/mastercard.jpg')); ?>" class="payment_method_logo"></li>
          <li><img src="<?php echo e(asset('images/payments/visa.jpg')); ?>" class="payment_method_logo"></li>
          <li><img src="<?php echo e(asset('images/payments/american_express.jpg')); ?>" class="payment_method_logo"></li>
        </ul>
       </div>
      </div>
     </div>
    </div>
</footer>
<!--================================= footer -->
<!--================================= back to top -->
<div class="car-top">
  <span><img src="<?php echo e(asset('images/car.png')); ?>"></span>
</div>
<!--================================= back to top -->
<!-- finance calculator modal -->
<div class="modal fade" id="finance_calculator" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5">Finance Calculator</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="financing-calculator-01" class="gray-form">
          <div class="mb-3">
              <label class="form-label">Vehicle Price (BDT)*</label>
              <input type="number" class="form-control" placeholder="Price" id="loan-amount-01" name="loan-amount">
          </div>
          <div class="mb-3">
              <label class="form-label">Down Payment *</label>
              <input type="number" class="form-control" placeholder="Payment" id="down-payment-01" name="down-payment">
          </div>
          <div class="mb-3">
              <label class="form-label">Interest Rate (%)</label>
              <input type="number" class="form-control" placeholder="Rate" id="interest-rate-01" name="interest-rate">
          </div>
          <div class="mb-3">
              <label class="form-label">Period (Month)*</label>
              <input type="number" class="form-control" placeholder="Month" id="period-01" name="period">
          </div>
          <div class="mb-3">
              <label class="form-label">Payment</label>
              <div class="cal_text payment-box">
                  <div id="txtPayment-01">0 BDT<sup>&#47;mo</sup></div>
              </div>
          </div>
          <div>
            <a class="button red calculate_finance_01" href="javascript:void(0)" data-form-id="financing-calculator-01">Estimate Payment</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>


<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src="<?php echo e(env('TAWK_CHAT_URI')); ?>";
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
<script type="text/javascript" src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/popper.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/mega-menu/mega_menu.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/jquery.appear.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/owl-carousel/owl.carousel.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/slick/slick.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/magnific-popup/jquery.magnific-popup.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('revolution/js/jquery.themepunch.tools.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('revolution/js/jquery.themepunch.revolution.min.js')); ?>"></script>
<?php echo $__env->yieldContent("script"); ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
  let toastElement = document.querySelector(".toast");
  if (toastElement) {
    let toast = new bootstrap.Toast(toastElement);
    toast.show();
  }

  function updateCartBadge() {
    let cart = JSON.parse(localStorage.getItem('cart')) || []; 
    let totalItems = cart.length;
    if (totalItems > 0) {
      $('.cart_badge').text(totalItems).show();
    } else {
      $('.cart_badge').hide();
    }
  }
  updateCartBadge();

  function isNumberValid(x) {
      let filter = /(^\d+\.?$)|(^\d*\.\d+$)/;
      if (filter.test(x)) {
          return true;
      }
      return false;
  }

  $(document).on('click', '.calculate_finance_01', function(){
      let form_id = $(this).attr('data-form-id');
      let current_form = $('#'+form_id);
      let loan_amount_el = current_form.find('#loan-amount-01');
      let loan_amount = loan_amount_el.val();
      let interest_rate_el = current_form.find('#interest-rate-01');
      let interest_rate = interest_rate_el.val();
      let period_el = current_form.find('#period-01');
      let period = period_el.val();
      let down_payment_el = current_form.find('#down-payment-01');
      let down_payment = down_payment_el.val();
      let currency_symbol = 'BDT';

      let t = down_payment;
      let I = interest_rate;
      let N = period;
      let P = loan_amount;

      let vTempP = String(P).replace(currency_symbol, '').replace(',', '');
      if (!isNumberValid(vTempP)) {
          alert("Please enter a valid number for the Loan Amount (P).");
          loan_amount_el.focus();
          return false;
      }

      let vTempT = String(t).replace(currency_symbol, '').replace(',', '');
      if (!isNumberValid(vTempT)) {
          alert("Please enter a valid number for the Down Payment (P).");
          down_payment_el.focus();
          return false;
      }

      if (!isNumberValid(I)) {
          alert("Enter an Interest Rate (r).");
          interest_rate_el.focus();
          return false;
      }
      if (!isNumberValid(N)) {
          alert("Please enter the Total Number of Payments (N).");
          period_el.focus();
          return false;
      }

      P = vTempP;
      t = vTempT;
      let X = (P - t);
      let Y = ((I / 100) / 12);
      let z = (Math.pow((1 + ((I / 100) / 12)), -N));
      let a = (X * Y);
      let b = (1 - z);
      let Tot = (a / b);
      let ans2 = Tot.toFixed();

      $('#txtPayment-01').html(ans2 + " " + currency_symbol + '<sup>&#47;mo</sup>');
  });
});
</script>
<script type="text/javascript" src="<?php echo e(asset('js/custom.js')); ?>"></script>
</body>
</html><?php /**PATH C:\Users\user\Workspace\carshop\resources\views/general_base.blade.php ENDPATH**/ ?>