
<?php $__env->startSection("title"); ?> Categories <?php $__env->stopSection(); ?>
<?php $__env->startSection("content"); ?>
<div class="row">
<div class="col-12">
<h5 class="text-dark border-bottom">Categories</h5>
</div>
<div class="col-12 d-flex justify-content-end mb-3">
<button type="button" class="btn btn-dark" data-toggle="modal" data-target="#add_category_modal"><i class="fas fa-plus"></i> Add New Category</button>
</div>
<div class="col-12 mb-3">
<form method="GET">
    <div class="input-group">
        <input type="text" class="form-control py-4" name="search" id="search_field" placeholder="Search by category names..." required>
        <div class="input-group-prepend">
            <button type="submit" class="input-group-text bg-light"><i class="fas fa-search"></i></button>
        </div>
    </div>
    <a href="<?php echo e(route('admin_category_list')); ?>" class="text-muted d-none" id="reset_btn"><small>reset</small></a>
</form>
</div>
<div class="col-12">
<table class="table table-bordered text-center bg-white">
<thead class="bg-dark">
    <tr>
        <th>#</th>
        <th>Category Name</th>
        <th>Total Sub-Category</th>
        <th>Total Products</th>
        <th>Action</th>
    </tr>
</thead>
<tbody>
<?php $__empty_1 = true; $__currentLoopData = $categories_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr>
    <td><?php echo e($loop->iteration); ?></td>
    <td><?php echo e($category->name); ?></td>
    <td><?php echo e($category->subCategories->count()); ?></td>
    <td>
      <?php
        $totalProducts = 0;
        foreach ($category->subCategories as $subCategory) {
          $totalProducts += $subCategory->products->count();
        }
        echo $totalProducts;
      ?>
    </td>
    <td>
        <button type="button" class="btn btn-warning btn-sm edit_category_modal_btn" data-toggle="modal" data-target="#edit_category_modal" data-id="<?php echo e($category->id); ?>" data-name="<?php echo e($category->name); ?>"><i class="fas fa-edit"></i> Edit</button>
        <form action="<?php echo e(route('admin_category_delete')); ?>" method="POST" class="d-inline">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="id" value="<?php echo e($category->id); ?>">
            <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i> Delete</button>
        </form>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
  <td colspan="5" class="text-muted">no categories found!</td>
</tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>

<!-- add category modal -->
<div class="modal fade" id="add_category_modal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark"><i class="fas fa-border-all"></i> Add Category</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="<?php echo e(route('admin_category_add')); ?>" method="POST">
      <div class="modal-body bg-light">
        <?php echo csrf_field(); ?>
        <label for="name" class="mb-1">Give a name for new category</label>
        <input type="text" name="name" class="form-control" id="name" required>
      </div>
      <div class="modal-footer d-flex justify-content-between p-0">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-success">Submit</button>
      </div>
      </form>
    </div>
  </div>
</div>
<!-- edit category modal -->
<div class="modal fade" id="edit_category_modal" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark"><i class="fas fa-border-all"></i> Edit Category</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="<?php echo e(route('admin_category_edit')); ?>" method="POST">
      <div class="modal-body bg-light">
        <?php echo csrf_field(); ?>
        <label for="edit_category_name" class="mb-1">Update category name</label>
        <input type="text" name="name" class="form-control" id="edit_category_name" required>
        <input type="hidden" name="id" id="edit_category_id">
      </div>
      <div class="modal-footer d-flex justify-content-between p-0">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-success">Save Changes</button>
      </div>
      </form>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("script"); ?>
<script>
function getSearchTermFromUrl() {
  let urlParams = new URLSearchParams(window.location.search);
    return urlParams.get('search') || '';
}
window.onload = function() {
  document.getElementById('search_field').value = getSearchTermFromUrl();
  if(getSearchTermFromUrl()){
    document.getElementById('reset_btn').classList.remove('d-none');
  }
};
$(".edit_category_modal_btn").click(function(){
  let categoryId = $(this).data("id");
  let categoryName = $(this).data("name");
  $("#edit_category_name").val(categoryName);
  $("#edit_category_id").val(categoryId);
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("admin_base", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\computershop\resources\views/admin/category.blade.php ENDPATH**/ ?>