<?php $__env->startSection('title'); ?>
    Add Blog
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/')); ?>assets/backend/plugins/summernote/summernote-bs4.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
<section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Add New Blog</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Blogs</a></li>
            <li class="breadcrumb-item active">Add Blog</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
        <form action="<?php echo e(route('blog.update', $blog->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <div class="row items-center">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="name">Select Category</label>
                                <small>
                                    <?php if($errors->has('category_id')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('category_id')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <select class="form-control select2" id="category_id" name="category_id" style="width: 100%;">
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e($blog->category_id == $category->id ? 'selected' : ' '); ?>><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="name">Select User</label>
                                <small>
                                    <?php if($errors->has('user_id')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('user_id')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <select class="form-control select2" id="user_id" name="user_id" style="width: 100%;">
                                    <option value="">Select User</option>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($user->id); ?>" <?php echo e($blog->user_id == $user->id ? 'selected' : ' '); ?>><?php echo e($user->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="title">Title</label>
                                <small>
                                    <?php if($errors->has('title')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('title')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" id="title" name="title" value="<?php echo e($blog->title); ?>">
                            </div>

                            <div class="form-group">
                                <label for="subtitle">Sub Title</label>
                                <small>
                                    <?php if($errors->has('subtitle')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('subtitle')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" id="subtitle" name="subtitle" value="<?php echo e($blog->subtitle); ?>">
                            </div>
                            <div class="form-group">
                                <label for="content">Content</label>
                                <small>
                                    <?php if($errors->has('content')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('content')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="form-control summernote" name="content" id="content" placeholder="Enter content"><?php echo e($blog->content); ?></textarea>
                            </div>
                            <div class="form-group">
                                <label for="date">Date</label>
                                <small>
                                    <?php if($errors->has('date')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('date')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="date" class="form-control" id="date" name="date" value="<?php echo e($blog->date); ?>">
                            </div>
                            <div class="form-group">
                                <label for="time">Expire Date</label>
                                <small>
                                    <?php if($errors->has('expire_date')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('expire_date')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="date" class="form-control" id="expire_date" name="expire_date" value="<?php echo e($blog->expire_date); ?>">
                            </div>

                            <div class="form-group">
                                <label for="status">Available</label>
                                <small>
                                    <?php if($errors->has('abilable')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('abilable')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <select class="form-control" id="abilable" name="abilable">
                                    <option value="Online">Online</option>
                                    <option value="All Outlet">All Outlet</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="exampleInputFile">Image</label>
                                <small>
                                    <?php if($errors->has('image')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('image')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" name="image" class="custom-file-input" id="exampleInputFile">
                                        <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                                    </div>
                                </div>
                                <?php if($blog->image): ?>
                                <div>
                                    <img src="<?php echo e(asset($blog->image)); ?>" alt="" style="width: 100px; height: 100px;">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 pb-5 pt-3 text-center">
                    <input type="submit" value="Save" class="form-contol btn btn-success float-right">
                </div>
            </div>
        </form>
    </div>
  </section>
</div>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/summernote/summernote-bs4.min.js"></script>
<script>
    $(function () {
      $('.summernote').summernote()
    })
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\startech\resources\views/admin/blog/edit.blade.php ENDPATH**/ ?>