<?php $__env->startSection('title'); ?>
<?php echo e($subcategory->name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
<style>
    .btn-product-icon{
        color: #fff;
        background: #6d8fed !important;
    }

    .btn-product-icon{
        color: #fff;
        background: #6d8fed !important;
    }
    .bg-widget {
        background: #fff;
    }
    .filter-price{
        padding: 0 21px 0px 9px;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>

<nav aria-label="breadcrumb" class="breadcrumb-nav mt-3 mb-0">
    <div class="container">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
            <li class="breadcrumb-item" aria-current="page"><a href="<?php echo e(route('product.category', $subcategory->category->id)); ?>"> <?php echo e($subcategory->category->name); ?></a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e($subcategory->name); ?></li>
        </ol>
    </div><!-- End .container -->
</nav><!-- End .breadcrumb-nav -->

    <div class="page-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-9">
                    <div class="toolbox">
                        <div class="toolbox-left">
                            <div class="toolbox-info">
                                Showing <span><?php echo e($products->firstItem()); ?> - <?php echo e($products->lastItem()); ?></span> of <?php echo e($products->total()); ?> Products
                            </div><!-- End .toolbox-info -->
                        </div><!-- End .toolbox-left -->

                        <div class="toolbox-right">
                            <div class="toolbox-sort">
                                <label for="sortby">Sort by:</label>
                                <div class="select-custom">
                                    <select name="sortby" id="sortby" class="form-control">
                                        <option value="popularity" selected="selected">Most Popular</option>
                                        <option value="rating">Most Rated</option>
                                        <option value="date">Date</option>
                                    </select>
                                </div>
                            </div><!-- End .toolbox-sort -->
                            <div class="toolbox-layout">
                                <a href="#" class="btn-layout layoutcategory" id="categoryList" data-id="<?php echo e($subcategory->id); ?>">
                                    <svg width="16" height="10">
                                        <rect x="0" y="0" width="4" height="4" />
                                        <rect x="6" y="0" width="10" height="4" />
                                        <rect x="0" y="6" width="4" height="4" />
                                        <rect x="6" y="6" width="10" height="4" />
                                    </svg>
                                </a>

                                <a href="#" class="btn-layout layoutcategory" id="categorytwocol" data-id="<?php echo e($subcategory->id); ?>">
                                    <svg width="10" height="10">
                                        <rect x="0" y="0" width="4" height="4" />
                                        <rect x="6" y="0" width="4" height="4" />
                                        <rect x="0" y="6" width="4" height="4" />
                                        <rect x="6" y="6" width="4" height="4" />
                                    </svg>
                                </a>

                                <a href="#" class="btn-layout layoutcategory" id="categorythreecol" data-id="<?php echo e($subcategory->id); ?>">
                                    <svg width="16" height="10">
                                        <rect x="0" y="0" width="4" height="4" />
                                        <rect x="6" y="0" width="4" height="4" />
                                        <rect x="12" y="0" width="4" height="4" />
                                        <rect x="0" y="6" width="4" height="4" />
                                        <rect x="6" y="6" width="4" height="4" />
                                        <rect x="12" y="6" width="4" height="4" />
                                    </svg>
                                </a>

                                <a href="#" class="btn-layout layoutcategory active" id="categoryfourcol" data-id="<?php echo e($subcategory->id); ?>">
                                    <svg width="22" height="10">
                                        <rect x="0" y="0" width="4" height="4" />
                                        <rect x="6" y="0" width="4" height="4" />
                                        <rect x="12" y="0" width="4" height="4" />
                                        <rect x="18" y="0" width="4" height="4" />
                                        <rect x="0" y="6" width="4" height="4" />
                                        <rect x="6" y="6" width="4" height="4" />
                                        <rect x="12" y="6" width="4" height="4" />
                                        <rect x="18" y="6" width="4" height="4" />
                                    </svg>
                                </a>
                            </div><!-- End .toolbox-layout -->
                        </div><!-- End .toolbox-right -->
                    </div><!-- End .toolbox -->

                    <div class="products mb-3">
                        <div class="row justify-content-center" id="productsContainer">
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-6 col-md-3 col-lg-3">
                                <div class="product product-7">
                                    <figure class="product-media">
                                        <a href="product.html">
                                            <img src="<?php echo e(asset($product->image)); ?>" alt="Product image" class="product-image">
                                        </a>

                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon" onclick="addToCart(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>); return false;">
                                                <i class="fa-solid fa-cart-shopping"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToWishlist(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>); return false;"><i class="fa-solid fa-heart"></i></a>
                                            <a href="#" class="btn-product-icon" onclick="addToCompare(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>); return false;"><i class="fa-solid fa-code-compare"></i></a>
                                            <a href="<?php echo e(route('product.detail', $product->id)); ?>" class="btn-product-icon"><i class="fa-solid fa-eye"></i></a>
                                        </div>
                                    </figure>

                                    <div class="product-body text-left">
                                        <h3 class="product-title mb-2"><a href="product.html"><?php echo e($product->name); ?></a></h3>
                                        <div class="product-price text-left">
                                            <span>৳<?php echo e($product->sale_price); ?></span> <span class="text-decoration-line-through ml-3">৳<?php echo e($product->regular_price); ?></span>
                                        </div>
                                    </div>
                                </div><!-- End .product -->
                            </div><!-- End .col-sm-6 col-lg-4 -->
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div><!-- End .row -->

                    </div><!-- End .products -->

                    <nav aria-label="Page navigation">
                        <ul class="pagination justify-content-center">

                            <li class="page-item <?php echo e($products->onFirstPage() ? 'disabled' : ''); ?>">
                                <a class="page-link page-link-prev" href="<?php echo e($products->previousPageUrl()); ?>" aria-label="Previous" tabindex="-1" aria-disabled="<?php echo e($products->onFirstPage() ? 'true' : 'false'); ?>">
                                    <span aria-hidden="true"><i class="icon-long-arrow-left"></i></span>Prev
                                </a>
                            </li>


                            <?php $__currentLoopData = $products->getUrlRange(1, $products->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="page-item <?php echo e($products->currentPage() == $page ? 'active' : ''); ?>" aria-current="page">
                                    <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <li class="page-item <?php echo e($products->hasMorePages() ? '' : 'disabled'); ?>">
                                <a class="page-link page-link-next" href="<?php echo e($products->nextPageUrl()); ?>" aria-label="Next">
                                    Next <span aria-hidden="true"><i class="icon-long-arrow-right"></i></span>
                                </a>
                            </li>


                            <li class="page-item-total">of <?php echo e($products->lastPage()); ?></li>
                        </ul>
                    </nav>

                </div><!-- End .col-lg-9 -->



                <aside class="col-lg-3 col-xl-5col order-lg-first">
                    <div class="sidebar sidebar-shop">
                        <div class="widget widget-collapsible bg-widget pt-3">
                            <h3 class="widget-title">
                                <a data-toggle="collapse" href="#widget-5" role="button" aria-expanded="true" aria-controls="widget-5">
                                    Price Range
                                </a>
                            </h3><!-- End .widget-title -->

                            <div class="collapse show" id="widget-5">
                                <div class="widget-body">
                                    <div class="filter-price">
                                        <div id="price-slider"></div>
                                    </div>
                                </div>
                            </div><!-- End .collapse -->
                        </div>

                        <div class="widget widget-collapsible bg-widget pt-3">
                            <h3 class="widget-title">
                                <a data-toggle="collapse" href="#widget-6" role="button" aria-expanded="true" aria-controls="widget-6">
                                    Brand
                                </a>
                            </h3>

                            <div class="collapse show" id="widget-6">
                                <div class="widget-body">
                                    <div class="filter-items filter-items-count">
                                        <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="filter-item">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input brand-checkbox" id="brand-<?php echo e($brand->id); ?>" data-brand-id="<?php echo e($brand->id); ?>">
                                                <label class="custom-control-label" for="brand-<?php echo e($brand->id); ?>"><?php echo e($brand->name); ?></label>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div><!-- End .filter-items -->
                                </div><!-- End .widget-body -->
                            </div><!-- End .collapse -->
                        </div>

                        <?php $__currentLoopData = $productatributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productatribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $atributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($condition = $productatribute == $atribute->id): ?>
                        <div class="widget widget-collapsible bg-widget pt-3">
                            <h3 class="widget-title">
                                <a data-toggle="collapse" href="#widget-<?php echo e($atribute->id); ?>" role="button" aria-expanded="true" aria-controls="widget-<?php echo e($atribute->id); ?>">
                                    <?php echo e($atribute->name); ?>

                                </a>
                            </h3><!-- End .widget-title -->

                            <div class="collapse show" id="widget-<?php echo e($atribute->id); ?>">
                                <div class="widget-body">
                                    <div class="filter-items">
                                        <?php $__currentLoopData = $atribute->atributevalues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atributevalue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="filter-item">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input atribute-checkbox" id="size-<?php echo e($atributevalue->id); ?>" data-atributevalue-id="<?php echo e($atributevalue->id); ?>">
                                                <label class="custom-control-label" for="size-<?php echo e($atributevalue->id); ?>"><?php echo e($atributevalue->value); ?></label>
                                            </div><!-- End .custom-checkbox -->
                                        </div><!-- End .filter-item -->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div><!-- End .widget-body -->
                            </div><!-- End .collapse -->
                        </div>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </aside>
            </div><!-- End .row -->

        </div><!-- End .container -->


    </div><!-- End .page-content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    function addToCart(productId, productName, productPrice) {
            let formData = new FormData();
            formData.append('_token', '<?php echo e(csrf_token()); ?>');
            formData.append('product_id', productId);
            formData.append('quantity', 1);
            $.ajax({
                url: "<?php echo e(route('cart.store')); ?>",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    console.log(response);
                    toastr.success('<span style="font-size:15px">Product added to cart successfully!</span>');
                    location.reload();
                },
                error: function(error) {
                    console.log(error);
                    location.reload();
                }
            });
        }

        function addToWishlist(productId, productName, productPrice) {
            let formData = new FormData();
            formData.append('_token', '<?php echo e(csrf_token()); ?>');
            formData.append('product_id', productId);
            formData.append('quantity', 1);
            $.ajax({
                url: "<?php echo e(route('wishlist.store')); ?>",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    console.log(response);
                    toastr.success('<span style="font-size:15px">Product added to wishlist successfully!</span>');
                    location.reload();
                },
                error: function(error) {
                    console.log(error);
                    location.reload();
                }
            });
        }

        function addToCompare(productId, productName, productPrice) {
            let formData = new FormData();
            formData.append('_token', '<?php echo e(csrf_token()); ?>');
            formData.append('product_id', productId);
            formData.append('quantity', 1);
            $.ajax({
                url: "<?php echo e(route('compare.store')); ?>",
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    console.log(response);
                    toastr.success('<span style="font-size:15px">Product added to compare successfully!</span>');
                    location.reload();
                },
                error: function(error) {
                    console.log(error);
                    location.reload();
                }
            });
        }
</script>
<script>
    $(document).ready(function() {
        var priceSlider = document.getElementById('price-slider');

        if (typeof noUiSlider === 'object') {
            if (priceSlider == null) return;

            noUiSlider.create(priceSlider, {
                start: [<?php echo e($products->min('sale_price')); ?>, <?php echo e($products->max('sale_price')); ?>],
                connect: true,
                step: 50,
                margin: 200,
                range: {
                    'min': <?php echo e($products->min('sale_price')); ?>,
                    'max': <?php echo e($products->max('sale_price')); ?>

                },
                tooltips: true,
                format: wNumb({
                    decimals: 0,
                    prefix: 'TK'
                })
            });

            priceSlider.noUiSlider.on('update', function(values, handle) {
                $('#filter-price-range').text(values.join(' - '));
            });
        }
    });
</script>
<script>
    $(document).ready(function() {
        var assetBaseUrl = "<?php echo e(asset('')); ?>";
        var $productsContainer = $('#productsContainer');
        var priceSlider = document.getElementById('price-slider');

        priceSlider.noUiSlider.on('change', filterProducts);
        $('.brand-checkbox').on('change', filterProducts);
        $('.atribute-checkbox').on('change', filterProducts);

        function filterProducts() {
            var minPrice = priceSlider.noUiSlider.get()[0];
            var maxPrice = priceSlider.noUiSlider.get()[1];
            var subcategoryId = $('.layoutcategory.active').data('id');
            var brands = [];
            var productatributes = [];
            $('.brand-checkbox:checked').each(function() {
                brands.push($(this).data('brand-id'));
            });

            $('.atribute-checkbox:checked').each(function() {
                productatributes.push($(this).data('atributevalue-id'));
            });


            var layout;
            if ($('#categoryList').hasClass('active')) {
                layout = 'list';
            } else if ($('#categorytwocol').hasClass('active')) {
                layout = 'twocol';
            } else if ($('#categorythreecol').hasClass('active')) {
                layout = 'threecol';
            } else if ($('#categoryfourcol').hasClass('active')) {
                layout = 'fourcol';
            }

            $.ajax({
                url: "<?php echo e(route('product.sub.filter')); ?>",
                type: 'POST',
                data: {
                    min_price: minPrice,
                    max_price: maxPrice,
                    subcategory_id: subcategoryId,
                    brands: brands,
                    productatributes: productatributes,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    displayProducts(response, layout);
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        }

        $('#categoryList, #categorytwocol, #categorythreecol, #categoryfourcol').click(function() {
            var subcategoryId = $(this).data('id');
            $('#categoryList, #categorytwocol, #categorythreecol, #categoryfourcol').removeClass('active');

            $(this).addClass('active');

            filterProducts();
        });

        function displayProducts(products, layout) {
            $productsContainer.empty();
            switch(layout) {
                case 'list':
                    $.each(products, function(index, product) {
                        let productUrl = "<?php echo e(route('product.detail', ':id')); ?>".replace(':id', product.id);
                        var productHTML = `
                            <div class="col-6 col-md-3 col-lg-3">
                                <div class="product product-7">
                                    <figure class="product-media">
                                        <a href="${productUrl}">
                                            <img src="${assetBaseUrl}${product.image}" alt="Product image" class="product-image">
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon" onclick="addToCart(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-cart-shopping"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToWishlist(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-heart"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToCompare(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-code-compare"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon"><i class="fa-solid fa-eye"></i></a>
                                        </div>
                                    </figure>
                                    <div class="product-body text-left">
                                        <h3 class="product-title mb-2"><a href="${productUrl}">${product.name}</a></h3>
                                        <div class="product-price text-left">
                                            <span>$${product.sale_price}</span>
                                            <span class="text-decoration-line-through ml-3">$${product.regular_price}</span>
                                        </div>
                                    </div>
                                </div><!-- End .product -->
                            </div><!-- End .col-6 col-md-3 col-lg-3 -->
                        `;
                        $productsContainer.append(productHTML);
                    });
                    break;
                case 'twocol':
                    $.each(products, function(index, product) {
                        let productUrl = "<?php echo e(route('product.detail', ':id')); ?>".replace(':id', product.id);
                        var productHTML = `
                            <div class="col-6">
                                <div class="product product-7">
                                    <figure class="product-media">
                                        <a href="${productUrl}">
                                            <img src="${assetBaseUrl}${product.image}" alt="Product image" class="product-image">
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon" onclick="addToCart(${product.id}, '${product.name}', ${product.sale_price}); return false;">
                                                <i class="fa-solid fa-cart-shopping"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToWishlist(${product.id}, '${product.name}', ${product.sale_price}); return false;">
                                                <i class="fa-solid fa-heart"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToCompare(${product.id}, '${product.name}', ${product.sale_price}); return false;">
                                                <i class="fa-solid fa-code-compare"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon"><i class="fa-solid fa-eye"></i></a>
                                        </div>
                                    </figure>
                                    <div class="product-body text-left">
                                        <h3 class="product-title mb-2"><a href="${productUrl}">${product.name}</a></h3>
                                        <div class="product-price text-left">
                                            <span>$${product.sale_price}</span>
                                            <span class="text-decoration-line-through ml-3">$${product.regular_price}</span>
                                        </div>
                                    </div>
                                </div><!-- End .product -->
                            </div><!-- End .col-6 col-md-3 col-lg-3 -->
                        `;
                        $productsContainer.append(productHTML);
                    });
                    break;
                case 'threecol':
                    $.each(products, function(index, product) {
                        let productUrl = "<?php echo e(route('product.detail', ':id')); ?>".replace(':id', product.id);
                        var productHTML = `
                            <div class="col-4">
                                <div class="product product-7">
                                    <figure class="product-media">
                                        <a href="${productUrl}">
                                            <img src="${assetBaseUrl}${product.image}" alt="Product image" class="product-image">
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon" onclick="addToCart(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-cart-shopping"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToWishlist(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-heart"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToCompare(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-code-compare"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon"><i class="fa-solid fa-eye"></i></a>
                                        </div>
                                    </figure>
                                    <div class="product-body text-left">
                                        <h3 class="product-title mb-2"><a href="${productUrl}">${product.name}</a></h3>
                                        <div class="product-price text-left">
                                            <span>$${product.sale_price}</span>
                                            <span class="text-decoration-line-through ml-3">$${product.regular_price}</span>
                                        </div>
                                    </div>
                                </div><!-- End .product -->
                            </div><!-- End .col-6 col-md-3 col-lg-3 -->
                        `;
                        $productsContainer.append(productHTML);
                    });
                    break;
                case 'fourcol':
                    $.each(products, function(index, product) {
                        let productUrl = "<?php echo e(route('product.detail', ':id')); ?>".replace(':id', product.id);
                        var productHTML = `
                            <div class="col-3">
                                <div class="product product-7">
                                    <figure class="product-media">
                                        <a href="${productUrl}">
                                            <img src="${assetBaseUrl}${product.image}" alt="Product image" class="product-image">
                                        </a>
                                        <div class="product-action-vertical">
                                            <a href="#" class="btn-product-icon" onclick="addToCart(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-cart-shopping"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToWishlist(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-heart"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon" onclick="addToCompare(${product.id}, '${product.name}', ${product.price}); return false;">
                                                <i class="fa-solid fa-code-compare"></i>
                                            </a>
                                            <a href="#" class="btn-product-icon"><i class="fa-solid fa-eye"></i></a>
                                        </div>
                                    </figure>
                                    <div class="product-body text-left">
                                        <h3 class="product-title mb-2"><a href="${productUrl}">${product.name}</a></h3>
                                        <div class="product-price text-left">
                                            <span>$${product.sale_price}</span>
                                            <span class="text-decoration-line-through ml-3">$${product.regular_price}</span>
                                        </div>
                                    </div>
                                </div><!-- End .product -->
                            </div><!-- End .col-6 col-md-3 col-lg-3 -->
                        `;
                        $productsContainer.append(productHTML);
                    });
                    break;
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('front.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\software_q7bd\resources\views/front-old/product/sub-category.blade.php ENDPATH**/ ?>
