<?php $__env->startSection('title'); ?>
    Add New Sub Sub Category
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/')); ?>assets/backend/plugins/summernote/summernote-bs4.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
<section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Add New Sub Sub Category</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(route('sub-sub-category.index')); ?>">Sub Sub Categories</a></li>
            <li class="breadcrumb-item active">Add Sub Sub Category</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
        <form action="<?php echo e(route('sub-sub-category.store')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row items-center">
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="name">Sub Sub Category Name</label>
                                <small>
                                    <?php if($errors->has('name')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" id="name" name="name" placeholder="Enter Category Name">
                            </div>

                            <div class="form-group">
                                <label for="name">Select Category</label>
                                <small>
                                    <?php if($errors->has('category_id')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('category_id')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <select class="form-control select2" id="category_id" name="category_id" style="width: 100%;">
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="name">Select Sub Category</label>
                                <small>
                                    <?php if($errors->has('subcategory_id')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('subcategory_id')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <select class="form-control select2" id="subcategory_id" name="subcategory_id" style="width: 100%;">
                                    <option value="">Select Sub Category</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="topbar-heading">Topbar Heading</label>
                                <small>
                                    <?php if($errors->has('topbar_heading')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('topbar_heading')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="topbar_heading" id="topbar-heading" placeholder="Enter Topbar Heading">
                            </div>
                            <div class="form-group">
                                <label for="topbar-heading">Topbar Description</label>
                                <small>
                                    <?php if($errors->has('topbar_description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('topbar_description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" name="topbar_description">
                                    Enter Topbar Description
                                </textarea>
                            </div>
                            <div class="form-group">
                                <label for="topbar-heading">Bottom Description</label>
                                <small>
                                    <?php if($errors->has('bottom_description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('bottom_description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" id="summernote" name="bottom_description">
                                    Enter Bottom Description
                                </textarea>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputFile">Image</label>
                                <small>
                                    <?php if($errors->has('image')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('image')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <div class="input-group">
                                    <div class="custom-file">
                                        <input type="file" name="image" class="custom-file-input" id="exampleInputFile">
                                        <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="parent_id">Meta Title</label>
                                <small>
                                    <?php if($errors->has('meta_title')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_title')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="meta_title" id="meta_title" placeholder="Enter Meta Title">
                            </div>
                            <div class="form-group">
                                <label for="parent_id">Meta URL</label>
                                <small>
                                    <?php if($errors->has('meta_url')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_url')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="meta_url" id="meta_url" placeholder="Enter Meta Url">
                            </div>
                            <div class="form-group">
                                <label for="parent_id">Meta Keywords</label>
                                <small>
                                    <?php if($errors->has('meta_keyword')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_keyword')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="meta_keyword" id="meta_keyword" placeholder="Enter Meta Keywords">
                            </div>
                            <div class="form-group">
                                <label for="parent_id">Meta Description</label>
                                <small>
                                    <?php if($errors->has('meta_description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" id="summernote" name="meta_description">
                                    Enter Meta Description
                                </textarea>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-12 pb-5 pt-3 text-center">
                    <input type="submit" value="Save" class="form-contol btn btn-success float-right">
                </div>
            </div>
        </form>
    </div>
  </section>
</div>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/summernote/summernote-bs4.min.js"></script>
<script>
    $(function () {
      $('.summernote').summernote()
    })
  </script>
  <script>
       $(document).ready(function () {

        $('#category_id').on('change', function () {
            var category_id = $(this).val();
            $.ajax({
                url: "<?php echo e(route('get-subcategory')); ?>",
                type: "POST",
                data: {
                    category_id: category_id,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    var options = '<option value="">Select Sub Category</option>';
                    response.forEach(element => {
                        options += '<option value="' + element.id + '">' + element.name + '</option>';
                    });
                    $('#subcategory_id').html(options);
                }
            });
        });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\smce\resources\views/admin/sub-sub-category/create.blade.php ENDPATH**/ ?>