<?php $__env->startSection('title'); ?>
    Cart
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<style>
    .page-content {
  background:none;
}
.card{
    border-radius: 10px !important;
}
thead{
    background-color: rgb(98, 135, 236);
}
.table th, .table thead th{
    font-size: 17px;
    padding: 16px;
    color: white;
    font-weight: 600;
}
.remove-button{
    background: transparent;
  border: none;
  color: red;
}
.card-footer{
    border-top: none;
    background: transparent;
    font-size: 20px;
    font-weight: 600;
    text-align: end;
}
.checkout-button{
    min-width: 100px;
    padding: 10px;
    background: #6488e8;
    border-radius: 5px;
    color: white;
}
.checkout-button:hover{
    background: #3a5ab9;
    color: #ffff
}
.product-title {
    font-size: 20px;
}
.table .total-col{
    color: #000;
}
.table.table-cart .quantity-col{
    width: 230px;

}
</style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('body'); ?>

<nav aria-label="breadcrumb" class="breadcrumb-nav mb-0">
    <div class="container-fluid mx-5">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Shopping Cart</li>
        </ol>
    </div><!-- End .container -->
</nav><!-- End .breadcrumb-nav -->

<div class="page-content">
    <div class="cart">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card p-md-5 m-md-5 p-0 m-0" style="border-top:none">
                        <div class="card-header">
                            <h4 class="card-title mb-4" style="font-size: 28px">
                                Shopping Cart
                            </h4>
                        </div>
                        <form action="<?php echo e(route('order.store')); ?>" method="post" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="card-body p-0">
                                <table class="table table-cart table-mobile">
                                    <thead>
                                        <tr>
                                            <th>Product</th>
                                            <th>Price</th>
                                            <th>Quantity</th>
                                            <th>Total</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>

                                    <tbody>
                                        <?php
                                            $total = 0;
                                        ?>
                                        <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productId => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $total += $product['price'] * $product['quantity'];
                                        ?>
                                        <tr data-id="<?php echo e($productId); ?>">
                                            <td class="product-col">
                                                <div class="product">
                                                    <figure class="product-media d-none d-md-block">
                                                        <a href="#">
                                                            <img src="<?php echo e(asset($product['photo'])); ?>" alt="Product image">
                                                        </a>
                                                    </figure>
                                                    <h3 class="product-title">
                                                        <a href="#"><?php echo e($product['name']); ?></a>
                                                        <input type="hidden" name="product_name[]" value="<?php echo e($product['name']); ?>">
                                                    </h3>
                                                </div>
                                                <div class="price-col d-block d-lg-none">
                                                    ৳<?php echo e($product['price']); ?>

                                                    <input type="hidden" name="price[]" value="<?php echo e($product['price']); ?>">
                                                </div>
                                                <button class="remove-button d-lg-none" onclick="removeFromCart('<?php echo e($productId); ?>')">Remove</button>
                                            </td>
                                            <td class="price-col">
                                                ৳<?php echo e($product['price']); ?>

                                                <input type="hidden" name="price[]" value="<?php echo e($product['price']); ?>">
                                            </td>
                                            <td class="quantity-col">
                                                <div class="cart-product-quantity">
                                                    <input type="number" class="form-control" name="quantity[]" value="<?php echo e($product['quantity']); ?>" min="1" max="10" step="1" data-decimals="0" required>
                                                    <input type="hidden" id="productId" name="product_id[]" value="<?php echo e($productId); ?>">
                                                </div>
                                            </td>
                                            <td class="total-col">
                                                ৳<?php echo e($product['price'] * $product['quantity']); ?>

                                                <input type="hidden" name="total_price[]" value="<?php echo e($product['price'] * $product['quantity']); ?>">
                                            </td>
                                            <td class="remove-col">
                                                <button class="remove-button" onclick="removeFromCart('<?php echo e($productId); ?>')">Remove</button>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer">
                                <div class="subtotal">
                                    Subtotal: <span>৳<?php echo e($total); ?> <input type="hidden" name="subtotal" value="<?php echo e($total); ?>"></span>
                                    <button type="submit" class="btn checkout-button">Checkout</button>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div><!-- End .row -->
        </div><!-- End .container -->
    </div><!-- End .cart -->
</div><!-- End .page-content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script>
    $(document).ready(function() {
        $('.cart-product-quantity input').on('change', function() {
            var productId = $(this).closest('tr').data('id');
            var quantity = $(this).val();
            updateToCart(productId, quantity);
            console.log(productId, quantity);
        });
        let updateCartUrl = "<?php echo e(route('cart.update', ':productId')); ?>";

        function updateToCart(productId, quantity) {
            let url = updateCartUrl.replace(':productId', productId);
            $.ajax({
                url: url,
                type: "PUT",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    product_id: productId,
                    quantity: quantity
                },
                success: function(response) {
                    console.log(response);
                    toastr.success('<span style="font-size:16px">Product updated to cart successfully!</span>');
                    location.reload();
                }
            });
        }

    });
    function removeFromCart(productId) {
        $.ajax({
            url: "<?php echo e(route('cart.remove')); ?>",
            type: "POST",
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                product_id: productId
            },
            success: function(response) {
                toastr.success('<span style="font-size:16px">Product removed from cart successfully!</span>');
                location.reload();
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\yasir_it\resources\views/front-old/cart/index.blade.php ENDPATH**/ ?>
