<?php //b984a9f16344f89ab2c6d078362a3920
/** @noinspection all */

namespace App\Models {

    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\BelongsToMany;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasManyThrough;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use Laravel\Sanctum\PersonalAccessToken;
    use LaravelIdea\Helper\App\Models\_IH_Atributevalue_C;
    use LaravelIdea\Helper\App\Models\_IH_Atributevalue_QB;
    use LaravelIdea\Helper\App\Models\_IH_Atribute_C;
    use LaravelIdea\Helper\App\Models\_IH_Atribute_QB;
    use LaravelIdea\Helper\App\Models\_IH_Blog_C;
    use LaravelIdea\Helper\App\Models\_IH_Blog_QB;
    use LaravelIdea\Helper\App\Models\_IH_Brand_C;
    use LaravelIdea\Helper\App\Models\_IH_Brand_QB;
    use LaravelIdea\Helper\App\Models\_IH_Category_C;
    use LaravelIdea\Helper\App\Models\_IH_Category_QB;
    use LaravelIdea\Helper\App\Models\_IH_Checkoutdetails_C;
    use LaravelIdea\Helper\App\Models\_IH_Checkoutdetails_QB;
    use LaravelIdea\Helper\App\Models\_IH_Checkout_C;
    use LaravelIdea\Helper\App\Models\_IH_Checkout_QB;
    use LaravelIdea\Helper\App\Models\_IH_Orderdetails_C;
    use LaravelIdea\Helper\App\Models\_IH_Orderdetails_QB;
    use LaravelIdea\Helper\App\Models\_IH_Order_C;
    use LaravelIdea\Helper\App\Models\_IH_Order_QB;
    use LaravelIdea\Helper\App\Models\_IH_Productatribute_C;
    use LaravelIdea\Helper\App\Models\_IH_Productatribute_QB;
    use LaravelIdea\Helper\App\Models\_IH_Product_C;
    use LaravelIdea\Helper\App\Models\_IH_Product_QB;
    use LaravelIdea\Helper\App\Models\_IH_Setting_C;
    use LaravelIdea\Helper\App\Models\_IH_Setting_QB;
    use LaravelIdea\Helper\App\Models\_IH_Slider_C;
    use LaravelIdea\Helper\App\Models\_IH_Slider_QB;
    use LaravelIdea\Helper\App\Models\_IH_Specification_C;
    use LaravelIdea\Helper\App\Models\_IH_Specification_QB;
    use LaravelIdea\Helper\App\Models\_IH_Subcategory_C;
    use LaravelIdea\Helper\App\Models\_IH_Subcategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_Subsubcategory_C;
    use LaravelIdea\Helper\App\Models\_IH_Subsubcategory_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_C;
    use LaravelIdea\Helper\Laravel\Sanctum\_IH_PersonalAccessToken_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Atributevalue_C|Atributevalue[] $atributevalues
     * @property-read int $atributevalues_count
     * @method HasMany|_IH_Atributevalue_QB atributevalues()
     * @property _IH_Productatribute_C|Productatribute[] $productatributes
     * @property-read int $productatributes_count
     * @method HasMany|_IH_Productatribute_QB productatributes()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method BelongsToMany|_IH_Product_QB products()
     * @method static _IH_Atribute_QB onWriteConnection()
     * @method _IH_Atribute_QB newQuery()
     * @method static _IH_Atribute_QB on(null|string $connection = null)
     * @method static _IH_Atribute_QB query()
     * @method static _IH_Atribute_QB with(array|string $relations)
     * @method _IH_Atribute_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Atribute_C|Atribute[] all()
     * @foreignLinks id,\App\Models\Atributevalue,atribute_id|id,\App\Models\Productatribute,atribute_id
     * @mixin _IH_Atribute_QB
     */
    class Atribute extends Model {}

    /**
     * @property int $id
     * @property int $atribute_id
     * @property string $value
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Atributevalue_QB onWriteConnection()
     * @method _IH_Atributevalue_QB newQuery()
     * @method static _IH_Atributevalue_QB on(null|string $connection = null)
     * @method static _IH_Atributevalue_QB query()
     * @method static _IH_Atributevalue_QB with(array|string $relations)
     * @method _IH_Atributevalue_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Atributevalue_C|Atributevalue[] all()
     * @ownLinks atribute_id,\App\Models\Atribute,id
     * @foreignLinks id,\App\Models\Productatribute,atributevalue_id
     * @mixin _IH_Atributevalue_QB
     */
    class Atributevalue extends Model {}

    /**
     * @property int $id
     * @property int|null $category_id
     * @property int|null $user_id
     * @property string $title
     * @property string $subtitle
     * @property string|null $content
     * @property string|null $slug
     * @property string|null $date
     * @property string|null $expire_date
     * @property string|null $abilable
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category|null $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_Blog_QB onWriteConnection()
     * @method _IH_Blog_QB newQuery()
     * @method static _IH_Blog_QB on(null|string $connection = null)
     * @method static _IH_Blog_QB query()
     * @method static _IH_Blog_QB with(array|string $relations)
     * @method _IH_Blog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Blog_C|Blog[] all()
     * @ownLinks category_id,\App\Models\Category,id|user_id,\App\Models\User,id
     * @mixin _IH_Blog_QB
     */
    class Blog extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @method static _IH_Brand_QB onWriteConnection()
     * @method _IH_Brand_QB newQuery()
     * @method static _IH_Brand_QB on(null|string $connection = null)
     * @method static _IH_Brand_QB query()
     * @method static _IH_Brand_QB with(array|string $relations)
     * @method _IH_Brand_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Brand_C|Brand[] all()
     * @foreignLinks id,\App\Models\Product,brand_id
     * @mixin _IH_Brand_QB
     */
    class Brand extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $description
     * @property string|null $topbar_heading
     * @property string|null $topbar_description
     * @property string|null $bottom_description
     * @property string|null $meta_title
     * @property string|null $meta_url
     * @property string|null $meta_description
     * @property string|null $meta_keyword
     * @property string|null $total_product
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @property _IH_Subcategory_C|Subcategory[] $subcategories
     * @property-read int $subcategories_count
     * @method HasMany|_IH_Subcategory_QB subcategories()
     * @property _IH_Subsubcategory_C|Subsubcategory[] $subsubcategories
     * @property-read int $subsubcategories_count
     * @method HasManyThrough|_IH_Subsubcategory_QB subsubcategories()
     * @method static _IH_Category_QB onWriteConnection()
     * @method _IH_Category_QB newQuery()
     * @method static _IH_Category_QB on(null|string $connection = null)
     * @method static _IH_Category_QB query()
     * @method static _IH_Category_QB with(array|string $relations)
     * @method _IH_Category_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Category_C|Category[] all()
     * @foreignLinks id,\App\Models\Subcategory,category_id|id,\App\Models\Subsubcategory,category_id|id,\App\Models\Product,category_id|id,\App\Models\Blog,category_id
     * @mixin _IH_Category_QB
     */
    class Category extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property string $ip_address
     * @property float $subtotal
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Checkout_QB onWriteConnection()
     * @method _IH_Checkout_QB newQuery()
     * @method static _IH_Checkout_QB on(null|string $connection = null)
     * @method static _IH_Checkout_QB query()
     * @method static _IH_Checkout_QB with(array|string $relations)
     * @method _IH_Checkout_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Checkout_C|Checkout[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @foreignLinks id,\App\Models\Checkoutdetails,checkout_id|id,\App\Models\Order,checkout_id
     * @mixin _IH_Checkout_QB
     */
    class Checkout extends Model {}

    /**
     * @property int $id
     * @property int $checkout_id
     * @property int $product_id
     * @property int $user_id
     * @property string $ip_address
     * @property string $product_name
     * @property int $quantity
     * @property float $price
     * @property float $total_price
     * @property int $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_Checkoutdetails_QB onWriteConnection()
     * @method _IH_Checkoutdetails_QB newQuery()
     * @method static _IH_Checkoutdetails_QB on(null|string $connection = null)
     * @method static _IH_Checkoutdetails_QB query()
     * @method static _IH_Checkoutdetails_QB with(array|string $relations)
     * @method _IH_Checkoutdetails_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Checkoutdetails_C|Checkoutdetails[] all()
     * @ownLinks checkout_id,\App\Models\Checkout,id|product_id,\App\Models\Product,id|user_id,\App\Models\User,id
     * @mixin _IH_Checkoutdetails_QB
     */
    class Checkoutdetails extends Model {}

    /**
     * @property int $id
     * @property int $checkout_id
     * @property string $name
     * @property string|null $email
     * @property string|null $phone
     * @property int|null $amount
     * @property string|null $address
     * @property string|null $status
     * @property string|null $transaction_id
     * @property string|null $currency
     * @property string|null $cus_country
     * @property string|null $cus_postcode
     * @property string|null $cus_city
     * @property string|null $cus_addr2
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Order_QB onWriteConnection()
     * @method _IH_Order_QB newQuery()
     * @method static _IH_Order_QB on(null|string $connection = null)
     * @method static _IH_Order_QB query()
     * @method static _IH_Order_QB with(array|string $relations)
     * @method _IH_Order_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Order_C|Order[] all()
     * @ownLinks checkout_id,\App\Models\Checkout,id
     * @mixin _IH_Order_QB
     */
    class Order extends Model {}

    /**
     * @method static _IH_Orderdetails_QB onWriteConnection()
     * @method _IH_Orderdetails_QB newQuery()
     * @method static _IH_Orderdetails_QB on(null|string $connection = null)
     * @method static _IH_Orderdetails_QB query()
     * @method static _IH_Orderdetails_QB with(array|string $relations)
     * @method _IH_Orderdetails_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Orderdetails_C|Orderdetails[] all()
     * @mixin _IH_Orderdetails_QB
     */
    class Orderdetails extends Model {}

    /**
     * @property int $id
     * @property int $category_id
     * @property int|null $subcategory_id
     * @property int|null $subsubcategory_id
     * @property int|null $brand_id
     * @property string $name
     * @property string|null $image
     * @property string|null $description
     * @property int|null $regular_price
     * @property int|null $sale_price
     * @property string|null $product_status
     * @property string|null $product_code
     * @property string|null $key_features
     * @property string|null $slug
     * @property string|null $meta_title
     * @property string|null $meta_url
     * @property string|null $meta_description
     * @property string|null $meta_keyword
     * @property string|null $topbar_heading
     * @property string|null $topbar_description
     * @property string|null $bottom_description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $image_2
     * @property string|null $image_3
     * @property string|null $image_4
     * @property Brand|null $brand
     * @method BelongsTo|_IH_Brand_QB brand()
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Productatribute_C|Productatribute[] $productatributes
     * @property-read int $productatributes_count
     * @method HasMany|_IH_Productatribute_QB productatributes()
     * @property _IH_Specification_C|Specification[] $specifications
     * @property-read int $specifications_count
     * @method HasMany|_IH_Specification_QB specifications()
     * @property Subcategory|null $subcategory
     * @method BelongsTo|_IH_Subcategory_QB subcategory()
     * @property Subsubcategory|null $subsubcategory
     * @method BelongsTo|_IH_Subsubcategory_QB subsubcategory()
     * @method static _IH_Product_QB onWriteConnection()
     * @method _IH_Product_QB newQuery()
     * @method static _IH_Product_QB on(null|string $connection = null)
     * @method static _IH_Product_QB query()
     * @method static _IH_Product_QB with(array|string $relations)
     * @method _IH_Product_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Product_C|Product[] all()
     * @ownLinks category_id,\App\Models\Category,id|subcategory_id,\App\Models\Subcategory,id|subsubcategory_id,\App\Models\Subsubcategory,id|brand_id,\App\Models\Brand,id
     * @foreignLinks id,\App\Models\Productatribute,product_id|id,\App\Models\Specification,product_id|id,\App\Models\Checkoutdetails,product_id
     * @mixin _IH_Product_QB
     */
    class Product extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property int $atribute_id
     * @property int $atributevalue_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Atribute $atribute
     * @method BelongsTo|_IH_Atribute_QB atribute()
     * @property Atributevalue $atributevalue
     * @method BelongsTo|_IH_Atributevalue_QB atributevalue()
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method static _IH_Productatribute_QB onWriteConnection()
     * @method _IH_Productatribute_QB newQuery()
     * @method static _IH_Productatribute_QB on(null|string $connection = null)
     * @method static _IH_Productatribute_QB query()
     * @method static _IH_Productatribute_QB with(array|string $relations)
     * @method _IH_Productatribute_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Productatribute_C|Productatribute[] all()
     * @ownLinks product_id,\App\Models\Product,id|atribute_id,\App\Models\Atribute,id|atributevalue_id,\App\Models\Atributevalue,id
     * @mixin _IH_Productatribute_QB
     */
    class Productatribute extends Model {}

    /**
     * @property int $id
     * @property string|null $logo
     * @property string|null $logo_name
     * @property string|null $fb_url
     * @property string|null $twitter_url
     * @property string|null $insta_url
     * @property string|null $pinta_url
     * @property string|null $linkdien_url
     * @property string|null $youtube_url
     * @property string|null $whatsapp_url
     * @property int|null $mobile_number1
     * @property int|null $mobile_number2
     * @property int|null $mobile_number3
     * @property int|null $mobile_number4
     * @property string|null $email
     * @property string|null $address1
     * @property string|null $address2
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Setting_QB onWriteConnection()
     * @method _IH_Setting_QB newQuery()
     * @method static _IH_Setting_QB on(null|string $connection = null)
     * @method static _IH_Setting_QB query()
     * @method static _IH_Setting_QB with(array|string $relations)
     * @method _IH_Setting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Setting_C|Setting[] all()
     * @mixin _IH_Setting_QB
     */
    class Setting extends Model {}

    /**
     * @property int $id
     * @property string $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Slider_QB onWriteConnection()
     * @method _IH_Slider_QB newQuery()
     * @method static _IH_Slider_QB on(null|string $connection = null)
     * @method static _IH_Slider_QB query()
     * @method static _IH_Slider_QB with(array|string $relations)
     * @method _IH_Slider_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Slider_C|Slider[] all()
     * @mixin _IH_Slider_QB
     */
    class Slider extends Model {}

    /**
     * @property int $id
     * @property int $product_id
     * @property string $specification
     * @property string $specification_description
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Specification_QB onWriteConnection()
     * @method _IH_Specification_QB newQuery()
     * @method static _IH_Specification_QB on(null|string $connection = null)
     * @method static _IH_Specification_QB query()
     * @method static _IH_Specification_QB with(array|string $relations)
     * @method _IH_Specification_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Specification_C|Specification[] all()
     * @ownLinks product_id,\App\Models\Product,id
     * @mixin _IH_Specification_QB
     */
    class Specification extends Model {}

    /**
     * @property int $id
     * @property int $category_id
     * @property string $name
     * @property string|null $topbar_heading
     * @property string|null $topbar_description
     * @property string|null $bottom_description
     * @property string|null $meta_title
     * @property string|null $meta_url
     * @property string|null $meta_description
     * @property string|null $meta_keyword
     * @property string|null $total_product
     * @property string $fetured_subcategory
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @property _IH_Subsubcategory_C|Subsubcategory[] $subsubcategories
     * @property-read int $subsubcategories_count
     * @method HasMany|_IH_Subsubcategory_QB subsubcategories()
     * @method static _IH_Subcategory_QB onWriteConnection()
     * @method _IH_Subcategory_QB newQuery()
     * @method static _IH_Subcategory_QB on(null|string $connection = null)
     * @method static _IH_Subcategory_QB query()
     * @method static _IH_Subcategory_QB with(array|string $relations)
     * @method _IH_Subcategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Subcategory_C|Subcategory[] all()
     * @ownLinks category_id,\App\Models\Category,id
     * @foreignLinks id,\App\Models\Subsubcategory,subcategory_id|id,\App\Models\Product,subcategory_id
     * @mixin _IH_Subcategory_QB
     */
    class Subcategory extends Model {}

    /**
     * @property int $id
     * @property int $category_id
     * @property int $subcategory_id
     * @property string $name
     * @property string|null $topbar_heading
     * @property string|null $topbar_description
     * @property string|null $bottom_description
     * @property string|null $meta_title
     * @property string|null $meta_url
     * @property string|null $meta_description
     * @property string|null $meta_keyword
     * @property string|null $total_product
     * @property string|null $image
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Category $category
     * @method BelongsTo|_IH_Category_QB category()
     * @property _IH_Product_C|Product[] $products
     * @property-read int $products_count
     * @method HasMany|_IH_Product_QB products()
     * @property Subcategory $subcategory
     * @method BelongsTo|_IH_Subcategory_QB subcategory()
     * @method static _IH_Subsubcategory_QB onWriteConnection()
     * @method _IH_Subsubcategory_QB newQuery()
     * @method static _IH_Subsubcategory_QB on(null|string $connection = null)
     * @method static _IH_Subsubcategory_QB query()
     * @method static _IH_Subsubcategory_QB with(array|string $relations)
     * @method _IH_Subsubcategory_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Subsubcategory_C|Subsubcategory[] all()
     * @ownLinks category_id,\App\Models\Category,id|subcategory_id,\App\Models\Subcategory,id
     * @foreignLinks id,\App\Models\Product,subsubcategory_id
     * @mixin _IH_Subsubcategory_QB
     */
    class Subsubcategory extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property _IH_PersonalAccessToken_C|PersonalAccessToken[] $tokens
     * @property-read int $tokens_count
     * @method MorphToMany|_IH_PersonalAccessToken_QB tokens()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all()
     * @foreignLinks id,\App\Models\Checkout,user_id|id,\App\Models\Checkoutdetails,user_id|id,\App\Models\Blog,user_id
     * @mixin _IH_User_QB
     * @method static UserFactory factory(array|callable|int|null $count = null, array|callable $state = [])
     */
    class User extends Model {}
}
