<?php $__env->startSection('title'); ?>
    Order Details
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<!-- DataTables -->
<link rel="stylesheet" href="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<link rel="stylesheet" href="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
<link rel="stylesheet" href="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
<section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Order Details</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Order</a></li>
            <li class="breadcrumb-item active">Order Details</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-12">
          <div class="card">

            <div class="card-body">
              <table id="example1" class="table table-bordered table-striped">
                <thead>
                <tr>
                    <th>Product Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Total Price</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $checkoutdetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkoutdetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($checkoutdetail->product_name); ?></td>
                        <td><?php echo e($checkoutdetail->quantity); ?></td>
                        <td><?php echo e($checkoutdetail->price); ?></td>
                        <td><?php echo e($checkoutdetail->total_price); ?></td>
                        <td>
                            <?php if($checkoutdetail->status == 0): ?>
                                <span class="badge badge-warning">Pending</span>
                            <?php elseif($checkoutdetail->status == 1): ?>
                                <span class="badge badge-success">Success</span>
                            <?php elseif($checkoutdetail->status == 2): ?>
                                <span class="badge badge-info">Progress</span>
                            <?php else: ?>
                                <span class="badge badge-danger">Cancel</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($checkoutdetail->created_at->format('d M Y')); ?></td>
                        <td>
                            <button type="button" class="btn btn-default" data-toggle="modal" data-target="#modal-<?php echo e($checkoutdetail->id); ?>">
                                Change Status
                            </button>
                        </td>
                    </tr>
                    <div class="modal fade" id="modal-<?php echo e($checkoutdetail->id); ?>">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">Checkout Detail</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <form action="<?php echo e(route('update.status')); ?>" method="post" id="checkout-detail-form-<?php echo e($checkoutdetail->id); ?>">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="checkout_detail_id" id="checkout_detail_id" value="<?php echo e($checkoutdetail->id); ?>">
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <label for="status">Status</label>
                                            <select name="status" id="status" class="form-control">
                                                <option value="0" <?php if($checkoutdetail->status == 0): ?> selected <?php endif; ?>>Pending</option>
                                                <option value="1" <?php if($checkoutdetail->status == 1): ?> selected <?php endif; ?>>Success</option>
                                                <option value="2" <?php if($checkoutdetail->status == 2): ?> selected <?php endif; ?>>Progress</option>
                                                <option value="3" <?php if($checkoutdetail->status == 3): ?> selected <?php endif; ?>>Cancel</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="modal-footer justify-content-between">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-primary save-changes-btn">Save changes</button>
                                    </div>
                                </form>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

              </table>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->
    </div>
  </section>
</div>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/jszip/jszip.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/pdfmake/pdfmake.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/pdfmake/vfs_fonts.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-buttons/js/buttons.print.min.js"></script>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
<script>
    $(function () {
      $("#example1").DataTable({
        "responsive": true, "lengthChange": false, "autoWidth": false,
        "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
      }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
      $('#example2').DataTable({
        "paging": true,
        "lengthChange": false,
        "searching": false,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "responsive": true,
      });
    });

</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\startech\resources\views/admin/order/show.blade.php ENDPATH**/ ?>