<?php $__env->startSection('title'); ?>
Profile
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Profile</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">User Profile</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-md-6 mx-auto">

                <!-- Profile Image -->
                <div class="card card-primary card-outline">
                    <div class="card-body box-profile">
                        <div class="text-center">
                            <img class="profile-user-img img-fluid img-circle"
                            src="<?php echo e(asset('/')); ?>assets/backend/dist/img/user4-128x128.jpg"
                            alt="User profile picture">
                        </div>

                        <form id="send-verification" method="post" action="<?php echo e(route('verification.send')); ?>">
                            <?php echo csrf_field(); ?>
                        </form>
                        <form method="post" action="<?php echo e(route('profile.update')); ?>" class="row g-3">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('patch'); ?>
                            <div class="col-12">
                                <label class="form-label">Name</label>
                                <small class="text-danger">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </small>
                                <input id="name" name="name" type="text" value="<?php echo e($user->name); ?>" class="form-control">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Email address</label>
                                <small class="text-danger">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </small>
                                <input id="email" name="email" type="email" class="form-control" value="<?php echo e($user->email); ?>">
                            </div>
                            <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                                <p>Your email address is unverified.</p>
                                <button form="send-verification" class="btn btn-primary">Click here to re-send the verification email.</button>
                                <?php if(session('status') === 'verification-link-sent'): ?>
                                    <p class="mt-2 font-medium text-sm text-green-600 dark:text-green-400">
                                        <?php echo e(__('A new verification link has been sent to your email address.')); ?>

                                    </p>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div class="text-start py-3 px-2">
                                <button type="submit" class="btn btn-primary px-4">Save</button>
                            </div>
                        </form>

                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h6 class="mb-0">Update Password</h6>
                    </div>
                    <div class="card-body box-profile">
                        <form method="post" action="<?php echo e(route('password.update')); ?>" class="row g-3">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('put'); ?>
                            <div class="col-12">
                                <label class="form-label">Current Password</label>
                                <small class="text-danger">
                                    <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </small>
                                <input id="update_password_current_password" name="current_password" type="password" class="form-control">
                            </div>
                            <div class="col-12">
                                <label class="form-label">New Password</label>
                                <small class="text-danger">
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </small>
                                <input id="update_password_password" name="password" type="password" class="form-control">
                            </div>
                            <div class="col-12">
                                <label class="form-label">Password Confirmation</label>
                                <small class="text-danger">
                                    <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <?php echo e($message); ?>

                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </small>
                                <input id="update_password_password_confirmation" name="password_confirmation" type="password" class="form-control">
                            </div>
                            <div class="text-start py-3 px-2">
                                <button type="submit" class="btn btn-primary px-4">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h6 class="mb-0">Delete Account</h6>
                    </div>
                    <div class="card-body box-profile">
                        <form method="post" action="<?php echo e(route('profile.destroy')); ?>" class="row g-3">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('delete'); ?>

                            <div class="col-12">
                                <h2>Are you sure you want to delete your account?</h2>
                                <p>Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.</p>
                            </div>
                            <div class="text-start px-2 py-3">
                                <button type="submit" class="btn btn-danger px-4">Delete Account</button>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
          </div>
          <!-- /.row -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
</div><!--end row-->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH G:\web development\sarowar\shirtandart\resources\views/profile/edit.blade.php ENDPATH**/ ?>