

CREATE TABLE `tbl_acledger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `grid` int(11) NOT NULL,
  `sgrid` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(250) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_acledger VALUES("1","200001","2","1","Petty Cash","","Every Days Official Expenses Amount","1","2020-04-22 12:22:21");
INSERT INTO tbl_acledger VALUES("2","200002","2","1","Cash","","Income Form Sales Or Other Income","1","2020-04-22 12:23:22");
INSERT INTO tbl_acledger VALUES("3","100001","1","6","Service Tools &amp; Equipment","","","1","2020-04-22 12:30:58");
INSERT INTO tbl_acledger VALUES("4","100002","1","6","Furniture, Fixture &amp; Interiors","","","1","2020-04-22 12:33:37");
INSERT INTO tbl_acledger VALUES("5","300001","3","30","Capital","","","1","2020-04-22 12:41:21");
INSERT INTO tbl_acledger VALUES("6","300002","3","31","Cash Withdrawal","","","1","2020-04-22 12:41:42");
INSERT INTO tbl_acledger VALUES("7","300003","3","32","Retained Earnings","","","1","2020-04-22 12:42:12");
INSERT INTO tbl_acledger VALUES("8","300004","3","32","VAT Reimbursement Account","","","1","2020-04-22 12:43:15");
INSERT INTO tbl_acledger VALUES("9","500001","5","14","VAT On Commission Payable","","","1","2020-04-22 12:44:09");
INSERT INTO tbl_acledger VALUES("10","500002","5","14","VAT On Sales Payable","","","1","2020-04-22 12:44:48");
INSERT INTO tbl_acledger VALUES("11","700001","7","27","Interest On FDR","","","1","2020-04-22 12:46:31");
INSERT INTO tbl_acledger VALUES("12","700002","7","28","Freight Receipt","","","1","2020-04-22 12:47:09");
INSERT INTO tbl_acledger VALUES("13","900039","9","21","Bank Payments","ব্যাংক পেমেন্ট","","1","2020-04-22 12:48:48");
INSERT INTO tbl_acledger VALUES("14","600001","6","25","Cost Of Good Sold","","","1","2020-04-22 12:50:22");
INSERT INTO tbl_acledger VALUES("15","900032","9","21","Telephones &amp; Mobile Bill","টেলিফোন এবং মোবাইল বিল","","1","2020-04-22 12:48:04");
INSERT INTO tbl_acledger VALUES("16","900022","9","21","Electricity Bills","বিদ্যুৎ বিল","","1","2020-04-22 12:48:32");
INSERT INTO tbl_acledger VALUES("17","900023","9","21","Food, Lunch &amp; Entertainments","খাবার, দুপুরের খাবার এবং অন্যান্য","","1","2020-04-22 12:48:49");
INSERT INTO tbl_acledger VALUES("18","500007","5","16","Supplier Previous Balance","","","1","2020-04-22 12:49:09");
INSERT INTO tbl_acledger VALUES("19","900019","9","21","Conveyances","যাতায়াত খরচ","","1","2020-04-22 12:49:41");
INSERT INTO tbl_acledger VALUES("20","900027","9","21","Office Stationeries","কার্যালয়ের নিশ্চল খরচ","","1","2020-04-22 12:50:34");
INSERT INTO tbl_acledger VALUES("21","900020","9","21","Internet &amp; IT Expenses","ইন্টারনেট ও আইটির খরচ","","1","2020-04-22 12:50:56");
INSERT INTO tbl_acledger VALUES("22","900034","9","21","Sundry Expenses","বিবিধ খরচ","","1","2020-04-22 12:51:20");
INSERT INTO tbl_acledger VALUES("23","900025","9","21","Licences &amp; Renewals","লাইছেঞ্ছ নবায়ন খরচ","","1","2020-04-22 12:51:43");
INSERT INTO tbl_acledger VALUES("24","900029","9","21","Sales Commission","বিক্রয় কমিশন","","1","2020-04-22 12:52:17");
INSERT INTO tbl_acledger VALUES("25","800015","8","20","VAT On Purchase","ক্রয়ের উপর ভ্যাট","","1","2020-04-22 12:53:00");
INSERT INTO tbl_acledger VALUES("26","800014","8","20","Tax On Purchase","ক্রয়ের উপর ট্যাক্স","","1","2020-04-22 12:53:14");
INSERT INTO tbl_acledger VALUES("27","800013","8","20","Other Direct Expenses","অন্যান্য পরিচালন খরচ","","1","2020-04-22 12:53:29");
INSERT INTO tbl_acledger VALUES("28","900033","9","21","Tips &amp; Donations","টিপস এবং ডোনেশন","","1","2020-04-22 12:54:02");
INSERT INTO tbl_acledger VALUES("29","900028","9","21","Personal Expenses","ব্যাক্তিগত খরচ","All personal Expenses of Owner","1","2020-04-22 12:54:48");
INSERT INTO tbl_acledger VALUES("30","900024","9","21","Home Delivery","হোম ডেলিভারি","","1","2020-04-22 01:08:31");
INSERT INTO tbl_acledger VALUES("31","900026","9","21","Office Rent","কার্যালয়ের ভাড়া","","1","2020-04-27 10:35:17");
INSERT INTO tbl_acledger VALUES("32","700003","7","26","Commission Income","","","1","2020-04-27 10:45:27");
INSERT INTO tbl_acledger VALUES("33","100003","1","12","Customer Opening Balance","","","1","2020-04-27 10:54:57");
INSERT INTO tbl_acledger VALUES("34","600002","6","23","Sales Revenue","","","1","2020-04-28 02:20:11");
INSERT INTO tbl_acledger VALUES("36","800010","8","20","Discount On Sales","বিক্রয়ের ডিসকাউন্ট","","1","2020-06-11 07:58:38");
INSERT INTO tbl_acledger VALUES("37","800009","8","20","Discount On Item","আইটেমে ডিসকাউন্ট","","1","2020-06-11 08:00:10");
INSERT INTO tbl_acledger VALUES("38","500003","5","14","AIT On Sales Payable","","","1","2020-06-11 08:03:40");
INSERT INTO tbl_acledger VALUES("39","700004","7","28","Service Charges Receipts","","","1","2020-06-11 08:06:32");
INSERT INTO tbl_acledger VALUES("40","800011","8","20","Less Given On Sales","বিক্রয়ের উপর কমিশন","","1","2020-06-11 08:09:58");
INSERT INTO tbl_acledger VALUES("41","500005","5","16","Discount Reserves On Purchase","","","1","2020-06-16 11:25:15");
INSERT INTO tbl_acledger VALUES("42","500004","5","16","Discount Item On Purchase","","","1","2020-06-16 11:25:59");
INSERT INTO tbl_acledger VALUES("43","700007","7","28","Less Paid On Purchase","","","1","2020-06-16 11:29:10");
INSERT INTO tbl_acledger VALUES("44","900018","9","21","Labour &amp; Transportation","লেবার এবং ট্রান্সপোর্টেশন","","1","2020-06-16 11:41:50");
INSERT INTO tbl_acledger VALUES("45","800012","8","20","Less Receive On Purchase Return","ক্রয়কৃত পন্য ফেরতের উপর ছাড়","","1","2020-06-17 02:56:32");
INSERT INTO tbl_acledger VALUES("46","700008","7","28","Less Paid On Sales Return","","","1","2020-06-17 11:29:43");
INSERT INTO tbl_acledger VALUES("47","300005","3","30","Receive/Payable Adjustment Account","","Customer And Supplier Opening Balance","1","2020-07-07 12:43:41");
INSERT INTO tbl_acledger VALUES("48","900042","9","21","Salaries,Wages And Allowance","","Employee Salary","1","2020-07-23 11:01:51");
INSERT INTO tbl_acledger VALUES("49","800016","8","20","Product Adjustment","","Product witch are damage, stolen, miss use etc...","1","2020-08-25 01:35:32");
INSERT INTO tbl_acledger VALUES("50","800017","8","37","Cost Of Good Damage","","","1","2020-08-25 02:13:42");
INSERT INTO tbl_acledger VALUES("51","600003","6","38","Damage Revenue","","Product witch are damage, stolen, miss use etc...","1","2020-08-25 02:28:47");
INSERT INTO tbl_acledger VALUES("52","300006","3","31","Cash Withdrawn From Mobile Account","","Cash Withdrawn from Mobile Account","1","2020-10-10 03:49:47");
INSERT INTO tbl_acledger VALUES("53","900037","9","21","Motor Bike Bill","","","1","2020-10-14 08:34:32");
INSERT INTO tbl_acledger VALUES("54","900036","9","21","Entertainment","","","1","2020-11-12 07:46:54");
INSERT INTO tbl_acledger VALUES("55","000001","0","","M/ Jamal &amp; Brother`","","ca","1","2020-12-01 02:10:54");
INSERT INTO tbl_acledger VALUES("56","300007","3","30","13 Cons","","","1","2020-12-17 04:01:12");
INSERT INTO tbl_acledger VALUES("57","300008","3","30","Md. Mohib Ullah (Ripon)","","Md. Mohib Ullah (Ripon), Owners Equity, Share Capital.","1","2020-12-22 11:29:36");
INSERT INTO tbl_acledger VALUES("58","300009","3","30","Karim Khan","","","1","2020-12-23 05:18:17");
INSERT INTO tbl_acledger VALUES("59","300010","3","30","Naimul Hasan","","","1","2020-12-23 05:18:55");
INSERT INTO tbl_acledger VALUES("60","300011","3","30","Akbar Ali","","ownership ","1","2020-12-23 05:19:20");
INSERT INTO tbl_acledger VALUES("61","300012","3","30","Asabul Royen","","If any","1","2021-01-04 04:37:03");
INSERT INTO tbl_acledger VALUES("62","300013","3","30","Ashraful","","owner","1","2021-01-06 01:00:46");
INSERT INTO tbl_acledger VALUES("63","300014","3","30","Abul Kalam","","owner","1","2021-01-06 01:01:38");
INSERT INTO tbl_acledger VALUES("64","900038","9","21","Qwert","qwert","","1","2021-03-16 12:47:14");
INSERT INTO tbl_acledger VALUES("66","800018","8","20","HUJURER","হুজুরের","","1","2022-12-18 07:55:52");
INSERT INTO tbl_acledger VALUES("67","800019","8","20","MD. KASEM","মো: কাশেম","","1","2022-12-18 08:02:19");
INSERT INTO tbl_acledger VALUES("68","800020","8","20","BIZLI CABLE ","বিজল্লী কেবল","","1","2022-12-18 08:03:26");
INSERT INTO tbl_acledger VALUES("69","800021","8","20","OSAKA ","ওসাকা","","1","2022-12-18 08:04:41");
INSERT INTO tbl_acledger VALUES("70","800022","8","20","CARNIVAL NETWORK","ক্যারনিবাল নেটওর্য়াক","","1","2022-12-18 08:05:42");
INSERT INTO tbl_acledger VALUES("71","500008","5","39","Supplier Opening Balance","","","1","2022-12-20 11:31:29");
INSERT INTO tbl_acledger VALUES("72","800023","8","20","NAYEM VAI ( AKASH )","নাইম ভাই (আকাশ)","","1","2022-12-20 07:43:04");
INSERT INTO tbl_acledger VALUES("73","900040","9","21","MEHEDI HASAN (MASUM)","মেহেদী হাসান (মাসুম)","","1","2022-12-21 12:29:54");
INSERT INTO tbl_acledger VALUES("77","800027","8","20","CHARITY","","","1","2022-12-23 01:03:47");
INSERT INTO tbl_acledger VALUES("78","800028","8","20","MONIR SIR","","","1","2022-12-24 12:29:55");
INSERT INTO tbl_acledger VALUES("79","900041","9","21","DULAL VAI ","","","1","2022-12-27 12:35:08");
INSERT INTO tbl_acledger VALUES("80","800029","8","20","BANK INTEREST"," ব্যাংক সুদ","","1","2023-01-07 09:39:09");
INSERT INTO tbl_acledger VALUES("81","800030","8","20","TOHA PACKAGING AND DIMER AHOTH","তোহা প্যাকেজিং এবং ডিমের আড়ৎ","","1","2023-01-08 08:43:34");
INSERT INTO tbl_acledger VALUES("82","800031","8","20","M/S KORNOPULI PAPER HOUSE","মেসার্স কর্ণফুলী পেপার হাউস","","1","2023-01-09 06:32:46");
INSERT INTO tbl_acledger VALUES("83","800032","8","20","SHOP RENT","","","1","2023-01-10 10:00:07");
INSERT INTO tbl_acledger VALUES("84","800033","8","20","DPS","","","1","2023-01-12 09:11:21");
INSERT INTO tbl_acledger VALUES("85","800034","8","20","MEHEDI HASAN (RAFI)","","","1","2023-02-01 12:47:13");
INSERT INTO tbl_acledger VALUES("86","800035","8","20","IBRAHIM KHALIL","","","1","2023-02-01 12:47:45");



CREATE TABLE `tbl_acmobile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `mobile` varchar(18) NOT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_acmobile VALUES("1","BKASH","","01881099122","0","1","2022-12-18 06:01:37");
INSERT INTO tbl_acmobile VALUES("2","BKASH","","01833017388","0","1","2022-12-18 08:33:08");
INSERT INTO tbl_acmobile VALUES("3","NAGAD","","0188 109 9122","0","1","2022-12-31 03:28:53");



CREATE TABLE `tbl_bacount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bid` int(11) NOT NULL,
  `branch` varchar(45) DEFAULT NULL,
  `bbranch` varchar(255) DEFAULT NULL,
  `acno` varchar(25) NOT NULL,
  `title` varchar(45) NOT NULL,
  `location` varchar(250) NOT NULL,
  `brcode` varchar(6) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_bacount VALUES("1","6","HAZIGONJ","","0901204603538001","SATELLITE VISION","HAZIGONJ","0901","1","2022-12-20 11:23:12");
INSERT INTO tbl_bacount VALUES("2","1","HAZIGONJ","","7017513988752","SATELLITE VISION","HAZIGONJ","242","1","2023-01-02 08:23:08");



CREATE TABLE `tbl_bank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` varchar(6) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_bank VALUES("1","DBBL","Dutch-Bangla Bank Ltd.","","1","2020-09-21 04:39:03");
INSERT INTO tbl_bank VALUES("2","IBL","Islami Bank Ltd.","","1","2020-09-21 04:39:40");
INSERT INTO tbl_bank VALUES("3","BA","BANK ASIA ","","1","2020-11-12 04:27:07");
INSERT INTO tbl_bank VALUES("4","NCC","NCC Bank","","1","2020-12-17 04:06:03");
INSERT INTO tbl_bank VALUES("5","HSBC","HSBC","","1","2021-01-04 04:19:17");
INSERT INTO tbl_bank VALUES("6","BRC","Brack","","1","2021-01-06 01:02:18");



CREATE TABLE `tbl_banktra` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` double(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_banktra VALUES("3","TRN120123101","","10500.00","2023-01-12","0","1","2023-01-12 04:20:46");
INSERT INTO tbl_banktra VALUES("4","TRN160123101","","28000.00","2023-01-16","0","1","2023-01-16 05:48:51");
INSERT INTO tbl_banktra VALUES("10","TRN160123103","","43275.00","2023-01-03","0","1","2023-01-16 07:12:10");
INSERT INTO tbl_banktra VALUES("17","TRN180123101","","720899.90","2023-01-01","0","1","2023-01-18 01:18:53");
INSERT INTO tbl_banktra VALUES("18","TRN220123101","","92500.00","2023-01-22","0","1","2023-01-22 05:49:10");
INSERT INTO tbl_banktra VALUES("19","TRN230123101","","9500.00","2023-01-23","0","1","2023-01-23 04:31:46");
INSERT INTO tbl_banktra VALUES("20","TRN240123101","","24000.00","2023-01-24","0","1","2023-01-24 05:37:53");
INSERT INTO tbl_banktra VALUES("21","TRN250123101","","33500.00","2023-01-25","0","1","2023-01-25 05:28:50");
INSERT INTO tbl_banktra VALUES("22","TRN260123101","","51500.00","2023-01-26","0","1","2023-01-26 06:23:46");
INSERT INTO tbl_banktra VALUES("24","TRN290123101","","117500.00","2023-01-29","0","1","2023-01-29 06:24:54");
INSERT INTO tbl_banktra VALUES("26","TRN310123101","","46000.00","2023-01-31","0","1","2023-01-31 05:26:03");
INSERT INTO tbl_banktra VALUES("27","TRN010223101","","15500.00","2023-02-01","0","1","2023-02-01 01:37:34");
INSERT INTO tbl_banktra VALUES("28","TRN010223102","","55500.00","2023-02-01","0","1","2023-02-01 05:29:14");
INSERT INTO tbl_banktra VALUES("29","TRN020223101","","60000.00","2023-01-30","0","1","2023-02-02 12:24:49");
INSERT INTO tbl_banktra VALUES("30","TRN020223102","","689.00","2023-02-02","0","1","2023-02-02 12:39:27");
INSERT INTO tbl_banktra VALUES("31","TRN020223103","","689.00","2023-02-02","0","1","2023-02-02 12:39:43");
INSERT INTO tbl_banktra VALUES("32","TRN020223104","","330.00","2023-02-02","0","1","2023-02-02 12:39:56");
INSERT INTO tbl_banktra VALUES("33","TRN020223105","","330.00","2023-02-02","0","1","2023-02-02 12:40:09");
INSERT INTO tbl_banktra VALUES("34","TRN020223106","","28500.00","2023-02-02","0","1","2023-02-02 05:06:21");
INSERT INTO tbl_banktra VALUES("36","TRN030223101","","1400.00","2023-02-03","0","1","2023-02-03 07:35:31");
INSERT INTO tbl_banktra VALUES("37","TRN050223101","","117300.00","2023-02-05","0","1","2023-02-05 04:59:04");
INSERT INTO tbl_banktra VALUES("38","TRN060223101","","2000.00","2023-02-06","0","1","2023-02-06 06:35:22");
INSERT INTO tbl_banktra VALUES("40","TRN060223103","","21000.00","2023-02-06","0","1","2023-02-06 07:06:33");
INSERT INTO tbl_banktra VALUES("41","TRN060223104","","750.00","2023-02-06","0","1","2023-02-06 08:19:20");
INSERT INTO tbl_banktra VALUES("42","TRN070223101","","38000.00","2023-02-07","0","1","2023-02-07 05:27:24");
INSERT INTO tbl_banktra VALUES("43","TRN080223101","","49000.00","2023-02-08","0","1","2023-02-08 05:17:03");
INSERT INTO tbl_banktra VALUES("44","TRN090223101","","24000.00","2023-02-09","0","1","2023-02-09 05:22:16");
INSERT INTO tbl_banktra VALUES("45","TRN110223101","","500.00","2023-02-11","0","1","2023-02-11 10:21:50");
INSERT INTO tbl_banktra VALUES("46","TRN120223101","","72500.00","2023-02-12","0","1","2023-02-12 04:50:38");
INSERT INTO tbl_banktra VALUES("47","TRN120223102","","1812.00","2023-02-12","0","1","2023-02-12 10:39:24");
INSERT INTO tbl_banktra VALUES("48","TRN130223101","","29000.00","2023-02-13","0","1","2023-02-13 11:01:03");
INSERT INTO tbl_banktra VALUES("49","TRN160223101","","5000.00","2023-02-16","0","1","2023-02-16 12:06:00");
INSERT INTO tbl_banktra VALUES("50","TRN160223102","","5000.00","2023-02-16","0","1","2023-02-16 12:25:37");
INSERT INTO tbl_banktra VALUES("51","TRN160223103","","29000.00","2023-02-13","0","1","2023-02-16 12:41:49");
INSERT INTO tbl_banktra VALUES("52","TRN190223101","MEHEDI","77500.00","2023-02-19","0","1","2023-02-19 09:35:43");
INSERT INTO tbl_banktra VALUES("53","TRN200223101","","113500.00","2023-02-20","0","1","2023-02-20 10:50:12");
INSERT INTO tbl_banktra VALUES("54","TRN180323101","","42000.00","2023-03-18","0","1","2023-03-18 09:59:32");



CREATE TABLE `tbl_banktrade` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `seid` int(11) NOT NULL,
  `brid` int(11) DEFAULT 0,
  `cid` int(11) NOT NULL,
  `cty` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `did` int(11) NOT NULL,
  `dty` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_banktrade VALUES("3","3","0","2","BA","10500.00","2","LE","ONLINE","2023-01-12","0","");
INSERT INTO tbl_banktrade VALUES("4","4","0","2","LE","28000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("10","10","0","2","BA","43275.00","2","LE","ONLINE","2023-01-16","0","");
INSERT INTO tbl_banktrade VALUES("17","17","0","2","LE","720899.90","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("18","18","0","2","LE","92500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("19","19","0","2","LE","9500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("20","20","0","2","LE","24000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("21","21","0","2","LE","33500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("22","22","0","2","LE","51500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("24","24","0","2","LE","117500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("26","26","0","2","LE","46000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("27","27","0","2","BA","15500.00","2","LE","ONLINE","2023-02-01","0","");
INSERT INTO tbl_banktrade VALUES("28","28","0","2","LE","55500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("29","29","0","2","LE","60000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("30","30","0","3","MO","689.00","2","LE","","","0","");
INSERT INTO tbl_banktrade VALUES("31","31","0","2","LE","689.00","1","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("32","32","0","2","MO","330.00","2","LE","","","0","");
INSERT INTO tbl_banktrade VALUES("33","33","0","2","LE","330.00","1","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("34","34","0","2","LE","28500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("36","36","0","2","LE","1400.00","1","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("37","37","0","2","LE","117300.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("38","38","0","2","LE","2000.00","1","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("40","40","0","2","LE","21000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("41","41","0","2","LE","750.00","1","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("42","42","0","2","LE","38000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("43","43","0","2","LE","49000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("44","44","0","2","LE","24000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("45","45","0","1","MO","500.00","2","LE","","","0","");
INSERT INTO tbl_banktrade VALUES("46","46","0","2","LE","72500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("47","47","0","2","LE","1812.00","1","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("48","48","0","1","BA","29000.00","2","LE","ONLINE","2023-02-13","0","ONLINE");
INSERT INTO tbl_banktrade VALUES("49","49","0","1","MO","5000.00","2","LE","","","0","");
INSERT INTO tbl_banktrade VALUES("50","50","0","2","LE","5000.00","3","MO","","","0","");
INSERT INTO tbl_banktrade VALUES("51","51","0","2","LE","29000.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("52","52","0","1","BA","77500.00","2","LE","ONLINE","2023-02-19","0","ONLINE");
INSERT INTO tbl_banktrade VALUES("53","53","0","2","LE","113500.00","1","BA","","","0","");
INSERT INTO tbl_banktrade VALUES("54","54","0","2","LE","42000.00","1","BA","","","0","");



CREATE TABLE `tbl_branch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `address` varchar(250) NOT NULL,
  `baddress` varchar(350) DEFAULT NULL,
  `phone` varchar(18) NOT NULL,
  `email` varchar(45) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(35) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_brand VALUES("11","CIRCLE","","","1","2024-05-01 11:39:25");



CREATE TABLE `tbl_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_category VALUES("11","0","ROUTER","","ALL TYPE OF ROUTER ITEMS HERE!","1","2022-11-27 04:28:47");
INSERT INTO tbl_category VALUES("12","0","ONU","","ALL ONU ITEMS HERE!","1","2022-11-27 07:43:58");
INSERT INTO tbl_category VALUES("13","0","NETWORK SWITCH","","ALL NETWORK SWITCH ITEMS HERE!","1","2022-11-27 08:30:55");
INSERT INTO tbl_category VALUES("14","0","CAT","","ALL INTERNET CAT CABLE HERE!","1","2022-11-27 08:53:35");
INSERT INTO tbl_category VALUES("15","0","NODE","","ALL NODE ITEMS HERE!","1","2022-11-27 08:55:19");
INSERT INTO tbl_category VALUES("16","0","FIBER CABLE ","","ALL FIBER CABLE ITMES HERE!","1","2022-11-28 11:29:59");
INSERT INTO tbl_category VALUES("17","0","PLC","","ALL TYPE OF PLC ITEMS HERE!","1","2022-11-28 03:04:51");
INSERT INTO tbl_category VALUES("18","0","RG - 6","","ALL TYPE OF RG - 6 CABLE ITEMS HERE!","1","2022-11-28 03:33:05");
INSERT INTO tbl_category VALUES("19","0","OUT OF STOCK","","ALL OUT OF STOCK ITEMS1","1","2022-11-28 06:58:34");
INSERT INTO tbl_category VALUES("20","0","CAMERA","","ALL TYPE OF CAMERA ITEMS HERE!","1","2022-11-29 07:15:47");
INSERT INTO tbl_category VALUES("21","0","LIGHT","","ALL TYPE OF LIGHT ITMES HERE!","1","2022-11-30 01:29:08");
INSERT INTO tbl_category VALUES("25","0","MULTIPLUG","","ALL TYPE OF MULTIPLUG ITEMS HERE!","1","2022-12-02 06:15:29");
INSERT INTO tbl_category VALUES("26","0","PADLOCK","","ALL TYPE OF PADLOCK ITEMS HERE!","1","2022-12-13 11:36:50");
INSERT INTO tbl_category VALUES("27","0","REMOTE","","","1","2022-12-24 05:43:28");
INSERT INTO tbl_category VALUES("28","0","ELECTRIC BOARD","","","1","2022-12-29 01:18:46");
INSERT INTO tbl_category VALUES("29","0","FAN","","","1","2024-05-01 11:41:53");
INSERT INTO tbl_category VALUES("30","0","fiver 6f","","","1","2024-05-14 04:16:32");



CREATE TABLE `tbl_cgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(35) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_cheqman` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clientid` int(11) DEFAULT NULL,
  `type` varchar(2) DEFAULT NULL,
  `chkno` varchar(30) NOT NULL,
  `chkdt` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `acid` int(11) DEFAULT NULL,
  `refinv` varchar(30) DEFAULT NULL,
  `chbnkid` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `ref` varchar(255) DEFAULT NULL,
  `paymod` varchar(5) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `apdate` datetime NOT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) DEFAULT NULL,
  `code` varchar(15) NOT NULL,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `cperson` varchar(45) DEFAULT NULL,
  `bcperson` varchar(255) DEFAULT NULL,
  `mname` varchar(45) DEFAULT NULL,
  `cnumber` varchar(18) NOT NULL,
  `cphone` varchar(14) DEFAULT NULL,
  `cemail` varchar(45) DEFAULT NULL,
  `nid` varchar(20) DEFAULT NULL,
  `creditlimit` double DEFAULT 0,
  `crepreiod` int(11) NOT NULL DEFAULT 0,
  `address` varchar(200) DEFAULT NULL,
  `baddress` varchar(350) DEFAULT NULL,
  `saddress` varchar(200) DEFAULT NULL,
  `did` int(11) DEFAULT NULL,
  `zid` int(11) DEFAULT NULL,
  `rank` int(11) DEFAULT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=397 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_customer VALUES("1","","ABA/CU/001","SUPREME SATELLITE (RAYHAN VAI - 8P)","","","","","01831552536","","","","0","0","HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-11-25 12:02:06");
INSERT INTO tbl_customer VALUES("3","","ABA/CU/002","NUR NETWORK ( RAMPUR ) ","","","","","01811656188","","","","0","0","MOISHAID, RAMPUR","","","","","0","1","1","2022-11-25 01:27:53");
INSERT INTO tbl_customer VALUES("4","","ABA/CU/003","MD. ALAMIN VAI (28P)","","","","","01990696969","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-11-25 03:26:13");
INSERT INTO tbl_customer VALUES("5","","ABA/CU/004","HUMAYUN VAI (41P)","","","","","01833355680","","","","0","0","DATRA","","","","","0","1","1","2022-11-25 03:40:17");
INSERT INTO tbl_customer VALUES("6","","ABA/CU/005","MAMUN VAI (46P)","","","","","01818635665","","","","0","0","OLIPUR","","","","","0","1","1","2022-11-25 03:42:05");
INSERT INTO tbl_customer VALUES("7","","ABA/CU/006","MITU VAI (47P)","","","","","01817953144","","","","0","0","EAST KAZIR GAON","","","","","0","1","1","2022-11-25 03:43:31");
INSERT INTO tbl_customer VALUES("8","","ABA/CU/007","SUMON NET (48P)","","","","","01726693535","","","","0","0","ZIANAGAR","","","","","0","1","1","2022-11-25 03:45:38");
INSERT INTO tbl_customer VALUES("9","","ABA/CU/008","JAMAL VAI NET (50P)","","","","","01835613780","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-11-25 03:46:45");
INSERT INTO tbl_customer VALUES("10","","ABA/CU/009","MD PARVES VAI (66P)","","","","","01881150119","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-11-25 03:48:50");
INSERT INTO tbl_customer VALUES("11","","ABA/CU/010","MD. IBRAHIM VAI (71P)","","","","","01617748474","","","","0","0","MUNSHIR HAT","","","","","0","1","1","2022-11-25 03:56:17");
INSERT INTO tbl_customer VALUES("12","","ABA/CU/011","NETWORK CARNIVAL (75P)","","","","","01925246518","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-11-25 04:02:07");
INSERT INTO tbl_customer VALUES("13","","ABA/CU/012","MD. RAZIB VAI (80P)","","","","","01875781210","","","","0","0","WARUK BAZAR","","","","","0","1","1","2022-11-25 04:04:06");
INSERT INTO tbl_customer VALUES("14","","ABA/CU/013","SHAHRASTI NET - MD. USUP (83P)","","","","","01853978419","","","","0","0","SHAHRASTI","","","","","0","1","1","2022-11-25 04:08:25");
INSERT INTO tbl_customer VALUES("15","","ABA/CU/014","THELISHAEER / ALI VAI (86P)","","","","","01824889484","","","","0","0","THELISHAEER","","","","","0","1","1","2022-11-25 04:13:56");
INSERT INTO tbl_customer VALUES("16","","ABA/CU/015","MD. MONJU MONSHI (89P)","","","","","01990010329","","","","0","0","RANDHUNIMURA","","","","","0","1","1","2022-11-25 04:17:18");
INSERT INTO tbl_customer VALUES("17","","ABA/CU/016","MD. SHOHEL / MD. ALAMIN (94P)","","","","","01636714927","","","","0","0","SENGATULI","","","","","0","1","1","2022-11-25 04:23:38");
INSERT INTO tbl_customer VALUES("18","","ABA/CU/017","MD. MASUM VAI (96P)","","","","","01812302373","","","","0","0","PALAKHAL","","","","","0","1","1","2022-11-25 04:36:44");
INSERT INTO tbl_customer VALUES("19","","ABA/CU/018","MD. NUR VAI (103P)","","","","","01813128336","","","","0","0","CHOWMUHANI","","","","","0","1","1","2022-11-25 04:41:54");
INSERT INTO tbl_customer VALUES("20","","ABA/CU/019","MD. SHOJIB VAI (105)","","","","","01812209844","","","","0","0","MODEL COLLEGE","","","","","0","1","1","2022-11-25 04:44:15");
INSERT INTO tbl_customer VALUES("21","","ABA/CU/020","MD. RASEL / RAJU  (106P)","","","","","01305909307","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-11-25 04:48:08");
INSERT INTO tbl_customer VALUES("22","","ABA/CU/021","DAFFODIL NETWORK (107P)","","","","","01720110180","","","","0","0","BABU VAI","","","","","0","1","1","2022-11-25 04:50:21");
INSERT INTO tbl_customer VALUES("23","","ABA/CU/022","MD. HELAL VAI (120P)","","","","","01858691017","","","","0","0","BILLWAYE","","","","","0","1","1","2022-11-25 05:04:19");
INSERT INTO tbl_customer VALUES("24","","ABA/CU/023","RSM INTERNET (145P)","","","","","01676779567","","","","0","0","RAMGANJ","","","","","0","1","1","2022-11-25 05:09:40");
INSERT INTO tbl_customer VALUES("25","","ABA/CU/024","NAHARA CABLE","","","","","01740830281","","","","0","0","KACHUA","","","","","0","1","1","2022-11-26 11:16:48");
INSERT INTO tbl_customer VALUES("26","","ABA/CU/025","MD. MONJU VAI DISH/FIT (92P)","","","","","01917245279","","","","0","0","ZIANAGAR","","","","","0","1","1","2022-11-26 08:29:51");
INSERT INTO tbl_customer VALUES("27","","ABA/CU/026","MD. MOHSIN VAI (100P)","","","","","01715534455","","","","0","0","BALAKHAL","","","","","0","1","1","2022-11-26 08:31:41");
INSERT INTO tbl_customer VALUES("28","","ABA/CU/027","HM ENTERPRISE (109P)","","","","","01710977322","","","","0","0","HAJIGONJ MODEL COLLEGE","","","","","0","1","1","2022-11-26 08:34:53");
INSERT INTO tbl_customer VALUES("29","","ABA/CU/028","FOYSAL BOLI (110P)","","","","","01624779372","","","","0","0","BOLI BHARI","","","","","0","1","1","2022-11-26 08:36:15");
INSERT INTO tbl_customer VALUES("30","","ABA/CU/029","SALIM VAI (112P)","","","","","01811517511","","","","0","0","BORKUL","","","","","0","1","1","2022-11-26 08:37:48");
INSERT INTO tbl_customer VALUES("31","","ABA/CU/030","MAKSUD (122P)","","","","","01303231782","","","","0","0","RHAMPUR","","","","","0","1","1","2022-11-26 08:40:06");
INSERT INTO tbl_customer VALUES("32","","ABA/CU/031","MD. BABU MOJUMDER (139P)","","","","","01788337747","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-11-26 08:41:36");
INSERT INTO tbl_customer VALUES("33","","ABA/CU/032","DAILY SHORT SALES","","","","","01881099122","","md.masum6122@gmail.com","","0","0","SHUR-SHOPON SUPER MARKET (CHORASTA), BISHO ROAD, HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-03 07:21:26");
INSERT INTO tbl_customer VALUES("34","","ABA/CU/033","AR INTERNET ","","","","","01822 528340","","","","0","0","SHOPON VAI, HAJIGONJ","","","","","0","1","1","2022-12-08 01:18:32");
INSERT INTO tbl_customer VALUES("35","","ABA/CU/034","BOLAKHAL CABLE NET","","","","","01638205347","","","","0","0","BOLAKHAL BAZAR, HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-12 11:39:26");
INSERT INTO tbl_customer VALUES("36","","ABA/CU/035","KAMRUL ISLAM ( DIGITAL NETWORK )","","","","","01726158951","","","","0","0","DOMURIA","","","","","0","1","1","2022-12-12 12:41:20");
INSERT INTO tbl_customer VALUES("37","","ABA/CU/036","BINODHON CABLE ( FHORIDUL JAMAN)","","","","","01747459658","","","","0","0","NAHARA, SHAHRASTI, CHANDPUR","","","","","0","1","1","2022-12-16 06:14:56");
INSERT INTO tbl_customer VALUES("38","","ABA/CU/037","BK CABLE/NET ( MD. BABUL KHAN )","","","","","01684395878","","","","0","0","NARAYANPUR, MOTHLOB","","","","","0","1","1","2022-12-16 07:42:54");
INSERT INTO tbl_customer VALUES("39","","ABA/CU/038","TAREK ONLINE","","","","","01869688746","","","","0","0","KAKORTHOLA, HAJIGONJ","","","","","0","1","1","2022-12-16 08:09:56");
INSERT INTO tbl_customer VALUES("40","","ABA/CU/039","COMPUTER MARKET (MAKSUD VAI)","","","","","01740566032","","","","0","0","HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-17 01:02:52");
INSERT INTO tbl_customer VALUES("41","","ABA/CU/040","KB INTERNET","","","","","01916197061","","","","0","0","KACHUA","","","","","0","1","1","2022-12-17 01:16:36");
INSERT INTO tbl_customer VALUES("42","","ABA/CU/041","PORHO BROTHERS","","","","","01817562326","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-12-17 06:37:57");
INSERT INTO tbl_customer VALUES("43","","ABA/CU/042","HASAN ONLINE ","","","","","01614257697","","","","0","0","AMIN ROAD, HAJIGONJ","","","","","0","1","1","2022-12-17 09:54:02");
INSERT INTO tbl_customer VALUES("44","","ABA/CU/043","MD. JUNAYED ","","","","","01984307050","","","","0","0","KACHUA","","","","","0","1","1","2022-12-18 11:31:34");
INSERT INTO tbl_customer VALUES("45","","ABA/CU/044","MD. AZIZ ","","","","","01641424608","","","","0","0","HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-18 07:29:59");
INSERT INTO tbl_customer VALUES("46","","ABA/CU/045","S.H COMPUTER (CU)","","","","","01765066141","","","","0","0","HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-18 08:27:39");
INSERT INTO tbl_customer VALUES("47","","ABA/CU/046","HAFIZ BELAL","","","","","01822814342","","","","0","0","HAJIGONJ","","","","","0","1","1","2022-12-18 09:41:36");
INSERT INTO tbl_customer VALUES("48","","ABA/CU/047","SATELLITE VISION - TWO","","","","","01679758109","","","","0","0","RAJANIGANDHA MARKET 2ND FLOOR, HAZIGANJ, CHANDPUR","","","","","0","1","1","2022-12-19 12:54:12");
INSERT INTO tbl_customer VALUES("49","","ABA/CU/048","BORKUL DISH/NET","","","","","01609994468","","","","0","0","BORKUL, HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-19 01:50:04");
INSERT INTO tbl_customer VALUES("50","","ABA/CU/049","B NET (KHOKON VAI )","","","","","01717166703","","","","0","0","GOLLAK BAZAR, FORIDGONZ, CHANDPUR","","","","","0","1","1","2022-12-19 04:27:16");
INSERT INTO tbl_customer VALUES("51","","ABA/CU/050","MIM SATELLITE ( SAWON VAI )","","","","","01632219132","","","","0","0","BAILLATHOLI BAZAR, KACHUA","","","","","0","1","1","2022-12-19 06:35:50");
INSERT INTO tbl_customer VALUES("52","","ABA/CU/051","DULAL VAI ","","","","","01867319990","","","","0","0","HOSSENPUR, KACHUA","","","","","0","1","1","2022-12-19 06:41:22");
INSERT INTO tbl_customer VALUES("53","","ABA/CU/052","BABU DHADHA ","","","","","01820103443","","","","0","0","BATORA, HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-19 08:47:58");
INSERT INTO tbl_customer VALUES("54","","ABA/CU/053","MD. RASEL KAZI","","","","","01757821568","","","","0","0","MOHAMAYA, CHANDPUR","","","","","0","1","1","2022-12-20 01:04:24");
INSERT INTO tbl_customer VALUES("55","","ABA/CU/054","FOYSAL VAI","","","","","01647601514","","","","0","0","HOSSENPUR, KACHUA","","","","","0","1","1","2022-12-20 01:33:25");
INSERT INTO tbl_customer VALUES("56","","ABA/CU/055","MD. MANIK","","","","","01709276881","","","","0","0","MATHOIN, HAZIGONJ","","","","","0","1","1","2022-12-20 03:21:28");
INSERT INTO tbl_customer VALUES("57","","ABA/CU/056","MD. KASEM ","","","","","01846427449","","","","0","0","HAZIGONJ, CHANDPUR","","","","","0","1","1","2022-12-20 05:00:44");
INSERT INTO tbl_customer VALUES("58","","ABA/CU/057","NASIR VAI","","","","","01644200070","","","","0","0","KACHUA","","","","","0","1","1","2022-12-20 05:09:45");
INSERT INTO tbl_customer VALUES("59","","ABA/CU/058","NAYEM HOSSAIN ( AKASH )","","","","","01875516801","","","","0","0","HAJIGONJ, CHANDPUR","","","","","0","1","1","2022-12-20 07:33:45");
INSERT INTO tbl_customer VALUES("60","","ABA/CU/059","JOGOTHPUR CABLE NETWORK","","","","","01733627698","","","","0","0","JOGOTHPUR, KACHUA, CHANDPUR","","","","","0","1","1","2022-12-20 08:35:28");
INSERT INTO tbl_customer VALUES("61","","ABA/CU/060","MEHEDI HASAN (MASUM)","","","","","0188 1099122","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-21 12:22:34");
INSERT INTO tbl_customer VALUES("62","","ABA/CU/061","FOYEZ AHAMED","","","","","01851534694","","","","0","0","RAZARGAOW, HAZIGONZ","","","","","0","1","1","2022-12-21 01:44:00");
INSERT INTO tbl_customer VALUES("63","","ABA/CU/062","MONIR SIR","","","","","01881099119","","","","0","0","HAZIGONJ","","","","","0","1","1","2022-12-21 06:04:57");
INSERT INTO tbl_customer VALUES("64","","ABA/CU/063","SOPNO CABLE/NET (FOYEZ VAI)","","","","","01830814285","","","","0","0","MONTOLA, FORIDGONJ, CHANDPUR ","","","","","0","1","1","2022-12-21 07:14:24");
INSERT INTO tbl_customer VALUES("65","","ABA/CU/064","MOHSIN MEMBAR","","","","","01814096685","","","","0","0","DHEVPUR, CHANDPUR SADAR","","","","","0","1","1","2022-12-21 08:25:09");
INSERT INTO tbl_customer VALUES("66","","ABA/CU/065","HAJIGONJ BROADBAND BD","","","","","01766838339","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-21 08:34:57");
INSERT INTO tbl_customer VALUES("67","","ABA/CU/066","SHOHEL VAI","","","","","01628670101","","","","0","0","RAMPUR, HAZIGONZ","","","","","0","1","1","2022-12-21 08:59:34");
INSERT INTO tbl_customer VALUES("68","","ABA/CU/067","ARIF HOSSAIN","","","","","01647047291","","","","0","0","BADDHA, HAZIGONZ","","","","","0","1","1","2022-12-22 11:15:07");
INSERT INTO tbl_customer VALUES("69","","ABA/CU/068","MINTU ","","","","","01719376192","","","","0","0","NATEHARA, HAZIGONZ","","","","","0","1","1","2022-12-22 12:32:44");
INSERT INTO tbl_customer VALUES("70","","ABA/CU/069","AYAN TEED LINK","","","","","01615222044","","","","0","0","MOHAMAYA BAZAR, CHANDPUR","","","","","0","1","1","2022-12-22 03:27:33");
INSERT INTO tbl_customer VALUES("71","","ABA/CU/070","NUR NETWORK ( HAZIGONZ )","","","","","01913774839","","","","0","0","HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-22 06:56:38");
INSERT INTO tbl_customer VALUES("72","","ABA/CU/071","TITU VAI","","","","","01812264336","","","","0","0","SIRAMPUR, KACHUA","","","","","0","1","1","2022-12-22 07:14:59");
INSERT INTO tbl_customer VALUES("73","","ABA/CU/072","IKRAM HOSSAIN","","","","","01812396085","","","","0","0","GOLLAK BAZAR, HAZIGANJ","","","","","0","1","1","2022-12-22 07:33:56");
INSERT INTO tbl_customer VALUES("74","","ABA/CU/073","UNIVERSEL CABLE NETWORK","","","","","01816706753","","","","0","0","MOHAMMEDHPUR, HAZIGONZ","","","","","0","1","1","2022-12-23 03:10:10");
INSERT INTO tbl_customer VALUES("75","","ABA/CU/074","JOSHIM UDDIN","","","","","01852619596","","","","0","0","ALIGONZ, CHANDPUR","","","","","0","1","1","2022-12-23 06:32:04");
INSERT INTO tbl_customer VALUES("76","","ABA/CU/075","BIDHAN DHADHA","","","","","01670662849","","","","0","0","KACHUA","","","","","0","1","1","2022-12-23 06:37:32");
INSERT INTO tbl_customer VALUES("77","","ABA/CU/076","TANVIR AHAMED (SHOPON STUFF)","","","","","01857846913","","","","0","0","HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-23 06:51:02");
INSERT INTO tbl_customer VALUES("78","","ABA/CU/077","RUBEL BUIYA","","","","","01683318693","","","","0","0","HATILA, HAZIGONZ","","","","","0","1","1","2022-12-23 08:29:21");
INSERT INTO tbl_customer VALUES("79","","ABA/CU/078","MD. SHOHAG","","","","","01811526862","","","","0","0","KOIARFUL, HAZIGONZ,","","","","","0","1","1","2022-12-23 08:41:47");
INSERT INTO tbl_customer VALUES("80","","ABA/CU/079","OVI SATELLITE ","","","","","01816406844","","","","0","0","MARKI, HAZIGONZ","","","","","0","1","1","2022-12-23 09:27:47");
INSERT INTO tbl_customer VALUES("81","","ABA/CU/080","MD. ANISUL RAHAMAN","","","","","01829910412","","","","0","0","NOYAPARA, POST OFFICE SOHIDPUR BAZAR, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-24 11:51:52");
INSERT INTO tbl_customer VALUES("82","","ABA/CU/081","MD. ALLOMGER","","","","","01815848167","","","","0","0","SAHARASTE","","","9","","123","1","1","2022-12-24 03:45:39");
INSERT INTO tbl_customer VALUES("83","","ABA/CU/082","MD. HASAN VAI","","","","","01636268547","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-24 04:40:01");
INSERT INTO tbl_customer VALUES("84","","ABA/CU/083","MD. MAMUN VAI","","","","","01714888995","01816496093","","","0","0","RAZAPUR, KHILPARA, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-24 06:26:07");
INSERT INTO tbl_customer VALUES("85","","ABA/CU/084","MD. RASHED (AMMUJHAN)","","","","","01713627544","","","","0","0","AMMUJHAN, KACHUA","","","","","0","1","1","2022-12-25 11:25:23");
INSERT INTO tbl_customer VALUES("86","","ABA/CU/085","SAOWN SHEK","","","","","01728850297","","","","0","0","FOKIRBAZA, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-25 12:03:52");
INSERT INTO tbl_customer VALUES("87","","ABA/CU/086","MD IMAN VAI","","","","","01814444133","","","","0","0","7 NO UNION NATEHARA, HAZIGONZ","","","","","0","1","1","2022-12-25 03:19:58");
INSERT INTO tbl_customer VALUES("88","","ABA/CU/087","MD. DELOWAR","","","","","01798073333","","","","0","0","DARCHOR GRAM, KACHUA","","","","","0","1","1","2022-12-25 04:42:18");
INSERT INTO tbl_customer VALUES("89","","ABA/CU/088","MD. MAHABUB","","","","","01310044599","","","","0","0","CHOMOHONY","","","","","0","1","1","2022-12-25 07:44:38");
INSERT INTO tbl_customer VALUES("90","","ABA/CU/089","NOBORUPA","","","","","01825034746","01932022153","","","0","0","KACHUA","","","","","0","1","1","2022-12-25 09:11:08");
INSERT INTO tbl_customer VALUES("91","","ABA/CU/090","ZELANE VAI","","","","","01710165678","","","","0","0","DOMARIA, KACHUA, CHANDPUR","","","","","0","1","1","2022-12-25 09:50:58");
INSERT INTO tbl_customer VALUES("92","","ABA/CU/091","MD. ROMAN","","","","","01643819663","","","","0","0","5 NO WOARD, HAZIGONZ","","","","","0","1","1","2022-12-25 10:14:25");
INSERT INTO tbl_customer VALUES("93","","ABA/CU/092","MD. SHORIF VAI","","","","","01746424061","","","","0","0","PALGIRI","","","","","0","1","1","2022-12-26 12:29:27");
INSERT INTO tbl_customer VALUES("94","","ABA/CU/093","TRUST NET (HASAN VAI)","","","","","01674426839","","","","0","0","AMIN ROAD, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-26 12:31:43");
INSERT INTO tbl_customer VALUES("95","","ABA/CU/094","MONIGAOW ONLINE","","","","","01609489505","","","","0","0","NARAYANPUR, MOTHLOB","","","","","0","1","1","2022-12-26 04:58:11");
INSERT INTO tbl_customer VALUES("96","","ABA/CU/095","HASAN TELECOM (KAIUM)","","","","","01857236002","","","","0","0","ARULI BORKUL, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-26 07:04:38");
INSERT INTO tbl_customer VALUES("97","","ABA/CU/096","SHADIN WIFI","","","","","01639266912","","","","0","0","MOHAMAYA, EAST BAZAR, CHANDPUR","","","","","0","1","1","2022-12-26 10:06:47");
INSERT INTO tbl_customer VALUES("98","","ABA/CU/097","BKASH SELSS","","","","","01833017388","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-26 10:38:45");
INSERT INTO tbl_customer VALUES("99","","ABA/CU/098","ANS NETWORK","","","","","01628609964","","","","0","0","HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-27 11:33:01");
INSERT INTO tbl_customer VALUES("100","","ABA/CU/099","BORHAN UDDIN","","","","","01728386233","","","","0","0","CHOMHONY, KACHUA","","","","","0","1","1","2022-12-27 01:03:50");
INSERT INTO tbl_customer VALUES("101","","ABA/CU/100","UZZAL DADA","","","","","01738264695","","","","0","0","KASIMPUR, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-27 06:30:53");
INSERT INTO tbl_customer VALUES("102","","ABA/CU/101","PARVEZ HOSSAIN","","","","","01647383149","","","","0","0","WARUK BAZAR","","","","","0","1","1","2022-12-27 07:01:05");
INSERT INTO tbl_customer VALUES("103","","ABA/CU/102","AHSAN ULLAH","","","","","01817964766","","","","0","0","BORKUL, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-27 07:16:48");
INSERT INTO tbl_customer VALUES("104","","ABA/CU/103","ZAKIR HOSSAIN","","","","","01718739610","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-27 08:26:04");
INSERT INTO tbl_customer VALUES("105","","ABA/CU/104","RUBEL","","","","","01779440127","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-27 08:37:45");
INSERT INTO tbl_customer VALUES("106","","ABA/CU/105","UZZAL ","","","","","01403269448","","","","0","0","TORAGHOR, HAZIGONZ","","","","","0","1","1","2022-12-27 08:53:13");
INSERT INTO tbl_customer VALUES("107","","ABA/CU/106","ROXY VAI","","","","","01874142499","","","","0","0","SHENDRA, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-27 09:04:05");
INSERT INTO tbl_customer VALUES("108","","ABA/CU/107","MD. ZAKIR ","","","","","01712787574","","","","0","0","DHOYALIA","","","","","0","1","1","2022-12-28 10:36:32");
INSERT INTO tbl_customer VALUES("109","","ABA/CU/108","RIPON","","","","","01625450077","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-28 10:58:29");
INSERT INTO tbl_customer VALUES("110","","ABA/CU/109","MOJUMDAR CABLES","","","","","01629617895","","","","0","0","GHOLBAHAR, KACHUA","","","","","0","1","1","2022-12-28 12:30:41");
INSERT INTO tbl_customer VALUES("111","","ABA/CU/110","S.M INTERNET (NAZIR VAI)","","","","","01818201162","","","","0","0","MOTHLOB, CHANDPUR","","","","","0","1","1","2022-12-28 02:06:33");
INSERT INTO tbl_customer VALUES("112","","ABA/CU/111","ABU BAKR","","","","","01652549364","","","","0","0","DHEBPUR, CHANDPUR","","","","","0","1","1","2022-12-28 04:06:06");
INSERT INTO tbl_customer VALUES("113","","ABA/CU/112","SHAHALAM PATOWARY","","","","","01730907014","","","","0","0","CHENGATOLI","","","","","0","1","1","2022-12-28 05:47:23");
INSERT INTO tbl_customer VALUES("114","","ABA/CU/113","SUNDARBAN COURIER","","","","","01826026963","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-29 11:41:52");
INSERT INTO tbl_customer VALUES("115","","ABA/CU/114","MOJAMMEL VAI","","","","","01726373638","","","","0","0","KACHUA","","","","","0","1","1","2022-12-29 03:58:14");
INSERT INTO tbl_customer VALUES("116","","ABA/CU/115","RIDOY ELECTRIC","","","","","01617958826","","","","0","0","RAMGONZ","","","","","0","1","1","2022-12-29 05:20:20");
INSERT INTO tbl_customer VALUES("117","","ABA/CU/116","COMPUTER GARDEN (CUS)","","","","","01832277476","","","","0","0","RAJONIGONDHA MARKET, 2ND FLOOR, SHOP #33, #34, #32, HAZIGONZ, CHANDPUR","","","","","0","1","1","2022-12-29 06:22:22");
INSERT INTO tbl_customer VALUES("118","","ABA/CU/117","MD. MAINUDDIN","","","","","01831479171","","","","0","0","KACHUA","","","","","0","1","1","2022-12-29 06:30:36");
INSERT INTO tbl_customer VALUES("119","","ABA/CU/118","SAOWN","","","","","01632219184","01311302768","","","0","0","BALIATOLI, KACHUA","","","","","0","1","1","2022-12-29 06:53:50");
INSERT INTO tbl_customer VALUES("120","","ABA/CU/119","Md Ripon","","","","","01729572700","","","","0","0","belbare","","","9","","","1","1","2022-12-30 02:19:18");
INSERT INTO tbl_customer VALUES("121","","ABA/CU/120","JONY","","","","","01828548857","","","","0","0","HAZIGONZ","","","","","0","1","1","2022-12-30 06:20:00");
INSERT INTO tbl_customer VALUES("122","","ABA/CU/121","MD. SHAMIM ( SHENDRA )","","","","","01823616984","","","","0","0","SHENDRA, HAZIGONZ","","","","","0","1","1","2022-12-31 03:52:51");
INSERT INTO tbl_customer VALUES("123","","ABA/CU/122","MD. SALAUDDIN","","","","","01632046674","","","","0","0","KACHUA","","","","","0","1","1","2022-12-31 05:26:25");
INSERT INTO tbl_customer VALUES("124","","ABA/CU/123","MD.DULAL","","","","","01731806929","","","","0","0","MALIGAO","","","","","0","1","1","2023-01-01 01:16:34");
INSERT INTO tbl_customer VALUES("125","","ABA/CU/124","MD.BABUL","","","","","01719944052","","","","0","0","KADLA","","","","","0","1","1","2023-01-01 01:45:10");
INSERT INTO tbl_customer VALUES("126","","ABA/CU/125","MD JOHIR VHI","","","","","01825800688","","","","0","0","PANCHOY","","","","","","1","1","2023-01-01 03:20:51");
INSERT INTO tbl_customer VALUES("127","","ABA/CU/126","KALAM VAI","","","","","01865181120","","","","0","0","NARAYANPUR, MOTHLOB","","","9","","1","1","1","2023-01-01 07:10:17");
INSERT INTO tbl_customer VALUES("128","","ABA/CU/127","MD.SHAMIM","","","","","01852200022","","","","0","0","MAHER STATION","","","","","","1","1","2023-01-01 07:15:01");
INSERT INTO tbl_customer VALUES("129","","ABA/CU/128","SHADIN WIFI","","","","","01727284546","","","","0","0","SUCHIPARA/SAHARASTE","","","","","","1","1","2023-01-01 07:38:56");
INSERT INTO tbl_customer VALUES("130","","ABA/CU/129","MD. RAHUL PATWARRY","","","","","01819008230","","","","0","0","SOUTH SREEPUR, BAKILA","","","","","0","1","1","2023-01-02 07:18:29");
INSERT INTO tbl_customer VALUES("131","","ABA/CU/130","MD. RASHED (SONAPUR)","","","","","01767313233","","","","0","0","SONAPUR, RAMGONJ","","","","","0","1","1","2023-01-02 08:37:43");
INSERT INTO tbl_customer VALUES("132","","ABA/CU/131","NASIR VAI","","","","","01833045515","","","","0","0","RHADUNIMURA, HAZIGONZ","","","","","0","1","1","2023-01-02 10:19:51");
INSERT INTO tbl_customer VALUES("133","","ABA/CU/132","S.M SATELLITE","","","","","01818269411","","","","0","0","BELCHO BAZAR, HAZIGONZ, CHANDPUR","","","","","0","1","1","2023-01-03 12:20:45");
INSERT INTO tbl_customer VALUES("134","","ABA/CU/133","MD. SHOHEL ","","","","","01739686873","01746347592","","","0","0","RAMGONJ, HAZIGONZ","","","","","0","1","1","2023-01-03 01:01:40");
INSERT INTO tbl_customer VALUES("135","","ABA/CU/134","VAI VAI DES CABOL WIFI","","","","","01630425714","","","","0","0","HOTUNE","","","9","","","1","1","2023-01-03 03:35:16");
INSERT INTO tbl_customer VALUES("136","","ABA/CU/135","MD YOUSUF","","","","","01874274544","","","","0","0","KAMRANGA","","","9","","","1","1","2023-01-03 04:13:46");
INSERT INTO tbl_customer VALUES("137","","ABA/CU/136","IT CYBER NET","","","","","01614920621","","","","0","0","HAZIGONZ","","","9","","1","1","1","2023-01-03 05:09:19");
INSERT INTO tbl_customer VALUES("138","","ABA/CU/137","ARIYAN (FIBER NET)","","","","","01841704180","","","","0","0","ROHIMANAGA, KACHUA","","","","","0","1","1","2023-01-03 05:41:57");
INSERT INTO tbl_customer VALUES("139","","ABA/CU/138","ALI HOSSAIN","","","","","01814344980","","","","0","0","ROHIMANAGAR","","","","","0","1","1","2023-01-03 06:23:43");
INSERT INTO tbl_customer VALUES("140","","ABA/CU/139","MD.BURHAN UDDIN BADDA","","","","","01782862380","","","","0","0","BADDA","","","","","","1","1","2023-01-03 06:51:00");
INSERT INTO tbl_customer VALUES("141","","ABA/CU/140","MD.HABIB PEROJPUR","","","","","01795103555","","","","0","0","PEROJPUR BAJAR","","","9","","","1","1","2023-01-04 12:20:35");
INSERT INTO tbl_customer VALUES("142","","ABA/CU/141","MD. RAJU VHI HAJIGONJ","","","","","01825190090","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-01-04 01:15:33");
INSERT INTO tbl_customer VALUES("143","","ABA/CU/142","ABUL KASEM","","","","","01812528183","","","","0","0","MONPURA, KACHUA","","","","","0","1","1","2023-01-04 04:44:08");
INSERT INTO tbl_customer VALUES("144","","ABA/CU/143","CUSTOMERS PREVIEWS DUE","","","","","0188 1099 122","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-04 08:23:19");
INSERT INTO tbl_customer VALUES("145","","ABA/CU/144","NABARUPA KACHYA","","","","","01678203010","","","","0","0","KACHYA BAZAR","","","9","","","1","1","2023-01-05 10:34:45");
INSERT INTO tbl_customer VALUES("146","","ABA/CU/145","PATANISH ONLINE","","","","","01830018205","","","","0","0","PATANISH","","","","","0","1","1","2023-01-05 12:34:54");
INSERT INTO tbl_customer VALUES("147","","ABA/CU/146","MD. RASEL","","","","","01815409074","","","","0","0","RAZARGAOW","","","","","0","1","1","2023-01-05 01:44:37");
INSERT INTO tbl_customer VALUES("148","","ABA/CU/147","MD MASUD","","","","","01704465393","","","","0","0","LOKKHEPUR","","","9","","","1","1","2023-01-05 04:51:58");
INSERT INTO tbl_customer VALUES("149","","ABA/CU/148","FHOKIR FASHION","","","","","01812734488","","","","0","0","WARUK BAZAR","","","","","0","1","1","2023-01-05 05:17:29");
INSERT INTO tbl_customer VALUES("150","","ABA/CU/149","SHISHIR VAI","","","","","01856784444","","","","0","0","KALIAPARA, SHARASTHI","","","","","0","1","1","2023-01-06 11:44:01");
INSERT INTO tbl_customer VALUES("151","","ABA/CU/150","SKY NET ","","","","","01827798921","","","","0","0","JOGOTHPUR","","","","","0","1","1","2023-01-06 03:17:15");
INSERT INTO tbl_customer VALUES("152","","ABA/CU/151","SOBUZ MOZUMDAR","","","","","01846219195","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-06 03:20:30");
INSERT INTO tbl_customer VALUES("153","","ABA/CU/152","SHAHED MOZUMDAR","","","","","01880906274","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-06 03:23:06");
INSERT INTO tbl_customer VALUES("154","","ABA/CU/153","RAKIB KASHARI","","","","","01886032153","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-06 03:26:09");
INSERT INTO tbl_customer VALUES("155","","ABA/CU/154","SAMAD SHARDHAR","","","","","01838125430","","","","0","0","SHARDHAR BARI","","","","","0","1","1","2023-01-06 03:38:04");
INSERT INTO tbl_customer VALUES("156","","ABA/CU/155","NURUZZAMAN","","","","","01815050399","","","","0","0","NARAYANPUR","","","","","0","1","1","2023-01-06 03:50:52");
INSERT INTO tbl_customer VALUES("157","","ABA/CU/156","ZUEL VAI","","","","","01815927564","","","","0","0","ALIGONZ","","","","","0","1","1","2023-01-06 03:53:36");
INSERT INTO tbl_customer VALUES("158","","ABA/CU/157","RAISRY CABLE","","","","","01799839137","","","","0","0","JOGOTHPUR","","","","","0","1","1","2023-01-06 03:56:04");
INSERT INTO tbl_customer VALUES("159","","ABA/CU/158","JAMAL (ALIGONZ)","","","","","01728590150","","","","0","0","ALIGONZ","","","","","0","1","1","2023-01-06 09:23:58");
INSERT INTO tbl_customer VALUES("160","","ABA/CU/159","HABIB (KACHUA)","","","","","01615277111","","","","0","0","KACHUA","","","","","0","1","1","2023-01-06 09:24:56");
INSERT INTO tbl_customer VALUES("161","","ABA/CU/160","AJAD VAI","","","","","01835546688","","","","0","0","RAMPUR","","","","","0","1","1","2023-01-07 04:57:22");
INSERT INTO tbl_customer VALUES("162","","ABA/CU/161","SHOHEL VAI (CHANDPUR)","","","","","01681668870","","","","0","0","NOLHOA, CHANDPUR","","","","","0","1","1","2023-01-07 10:20:34");
INSERT INTO tbl_customer VALUES("163","","ABA/CU/162","MOSHARAF (ROHIMANAGAR)","","","","","01639440065","","","","0","0","ROHIMANAGAR","","","","","0","1","1","2023-01-07 10:30:57");
INSERT INTO tbl_customer VALUES("164","","ABA/CU/163","FOYAZ (2)","","","","","0183 0814 285","","","","0","0","SALIAPARA","","","","","0","1","1","2023-01-07 10:34:43");
INSERT INTO tbl_customer VALUES("165","","ABA/CU/164","MUDARGUNZ CABLE NET","","","","","01719721592","","","","0","0","MUDARGUNZ BAZAR","","","","","0","1","1","2023-01-08 12:42:42");
INSERT INTO tbl_customer VALUES("166","","ABA/CU/165","MD. SHARIF KACHUA","","","","","01733267921","","","","0","0","KACHUA","","","","","","1","1","2023-01-08 02:51:34");
INSERT INTO tbl_customer VALUES("167","","ABA/CU/166","SUMON VAI","","","","","01812525723","","","","0","0","BELCHO","","","","","0","1","1","2023-01-08 05:20:08");
INSERT INTO tbl_customer VALUES("168","","ABA/CU/167","RABBI VAI (KASARI)","","","","","01812209312","","","","0","0","KASARI BHARI","","","","","0","1","1","2023-01-08 08:19:37");
INSERT INTO tbl_customer VALUES("169","","ABA/CU/168","SHORIF TALUKDHAR","","","","","01811735679","","","","0","0","MOTHLOB DOKKIN","","","","","0","1","1","2023-01-09 01:19:32");
INSERT INTO tbl_customer VALUES("170","","ABA/CU/169","ESMILE VAI (JORPUL BAJAR)","","","","","01787001908","","","","0","0","JORPUL BAJAR, KACHUA","","","","","1","1","1","2023-01-09 02:16:16");
INSERT INTO tbl_customer VALUES("171","","ABA/CU/170","MD. JAHANGIR","","","","","01819436425","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-10 03:58:28");
INSERT INTO tbl_customer VALUES("173","","ABA/CU/171","FARHAD VAI (GUPTHI)","","","","","01848179834","","","","0","0","GUPTHI","","","","","0","1","1","2023-01-10 06:19:30");
INSERT INTO tbl_customer VALUES("174","","ABA/CU/172","RIDOY VAI","","","","","01614259938","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-10 08:29:33");
INSERT INTO tbl_customer VALUES("175","","ABA/CU/173","NB TECH","","","","","01913050974","","","","0","0","KACHUA","","","","","0","1","1","2023-01-11 05:08:47");
INSERT INTO tbl_customer VALUES("176","","ABA/CU/174","SHOHEL VAI (MANAGER)","","","","","01746347592","","milonhu92@gmail.com","","0","0","RAMGONZ","","","","","0","1","1","2023-01-11 06:56:50");
INSERT INTO tbl_customer VALUES("177","","ABA/CU/175","MD Ismail Hossain SHORSHAK","","","","","01851453455","","","","0","0","SHORSHAK , SHAHRASTI, ","","","9","","","1","1","2023-01-12 12:35:09");
INSERT INTO tbl_customer VALUES("178","","ABA/CU/176","MD.FARUK PATWARY","","","","","01740979824","","","","0","0","WARUK BAJAR","","","","","","1","1","2023-01-13 11:04:22");
INSERT INTO tbl_customer VALUES("179","","ABA/CU/177","ABS (SHORIF MOLLA)","","","","","01766266372","","","","0","0","TAKROAD, HAZIGONZ","","","","","0","1","1","2023-01-13 11:33:14");
INSERT INTO tbl_customer VALUES("180","","ABA/CU/178","HARUN (MALIGAOW)","","","","","01705147012","","","","0","0","MALIGAOW","","","","","0","1","1","2023-01-13 06:22:05");
INSERT INTO tbl_customer VALUES("181","","ABA/CU/179","AMZAD (FRIENDS COMMUNICATION NETWORK)","","","","","01727409785","","","","0","0","PALISHARA","","","","","0","1","1","2023-01-13 07:37:15");
INSERT INTO tbl_customer VALUES("182","","ABA/CU/180","MOTAHEAR","","","","","01822845992","","","","0","0","WARUK","","","","","0","1","1","2023-01-14 12:22:28");
INSERT INTO tbl_customer VALUES("183","","ABA/CU/181","MD. IMRAN (SHARASTHI)","","","","","01521105794","","","","0","0","SHARASTHI","","","","","0","1","1","2023-01-14 12:58:40");
INSERT INTO tbl_customer VALUES("185","","ABA/CU/182","RUBEL (ELECTRICIAN)","","","","","01682942144","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-15 12:59:51");
INSERT INTO tbl_customer VALUES("186","","ABA/CU/183","ALI AKBAR ENTERPRISE","","","","","01732839556","","","","0","0","MADINA SUPER MARKET, HAZIGONZ CHANDPUR","","","","","0","1","1","2023-01-16 05:36:44");
INSERT INTO tbl_customer VALUES("187","","ABA/CU/184","BACCHU (MUNSHIRHAT)","","","","","01819487598","","","","0","0","MUNSHIRHAT, FARIDGONZ, CHANDPUR","","","","","0","1","1","2023-01-17 03:12:14");
INSERT INTO tbl_customer VALUES("188","","ABA/CU/185","MASUM (NOLOA CHANDPUR)","","","","","01822193969","","","","0","0","NOLOA CHANDPUR","","","","","0","1","1","2023-01-18 08:01:39");
INSERT INTO tbl_customer VALUES("189","","ABA/CU/186","BONDHU CABLE","","","","","01813607405","","","","0","0","MOHAMAYA","","","","","0","1","1","2023-01-19 04:18:56");
INSERT INTO tbl_customer VALUES("190","","ABA/CU/187","JOGONATH MEDICAL HOLE","","","","","01761731413","","","","0","0","FIRE SERVICE ROAD, HAZIGONZ, CHANDPUR","","","","","0","1","1","2023-01-19 06:00:13");
INSERT INTO tbl_customer VALUES("191","","ABA/CU/188","MD. ROFIQ BADARPUR","","","","","01850554542","","","","0","0","BADARPUR CHANDPUR HAJIGANJ","","","","","","1","1","2023-01-20 10:23:08");
INSERT INTO tbl_customer VALUES("192","","ABA/CU/189","JOHIR VAI (KACHUA)","","","","","01819115491","","","","0","0","KACHUA","","","","","0","1","1","2023-01-20 10:48:56");
INSERT INTO tbl_customer VALUES("193","","ABA/CU/190","MD. MOSTAK","","","","","01727918832","","","","0","0","RELL CITHUSHI, LAKSHUM","","","","","0","1","1","2023-01-21 12:16:00");
INSERT INTO tbl_customer VALUES("194","","ABA/CU/191","MD. RAZU","","","","","01815658359","","","","0","0","BAKILA","","","","","1","1","1","2023-01-22 04:04:33");
INSERT INTO tbl_customer VALUES("195","","ABA/CU/192","AKASH RESEARCH","","","","","0188 109 91 22","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-01-22 06:29:15");
INSERT INTO tbl_customer VALUES("196","","ABA/CU/193","SONALI ENTERPISE","","","","","01832141241","","","","0","0","5 NO WORD, HAZIGONZ","","","","","0","1","1","2023-01-22 09:24:51");
INSERT INTO tbl_customer VALUES("197","","ABA/CU/194","MD. FORID MOLLADOHAR","","","","","01829416797","","","","0","0","MOLLADOHAR","","","","","","1","1","2023-01-23 03:31:25");
INSERT INTO tbl_customer VALUES("198","","ABA/CU/195","WORLD VISION CABLE NETWORK","","","","","01711962472","","","","0","0","MOMIN ROAD, ALIGONZ","","","","","0","1","1","2023-01-23 06:01:37");
INSERT INTO tbl_customer VALUES("199","","ABA/CU/196","ABUL KAHER","","","","","01835610314","","","","0","0","SHRIPUR, MITALI BAZAR","","","","","0","1","1","2023-01-24 01:00:52");
INSERT INTO tbl_customer VALUES("201","","ABA/CU/197","STAR TECH (JAHANGIR)","","","","","01306592020","","","","0","0","SATATION ROAD, HAZIGONZ","","","","","0","1","1","2023-01-25 11:39:31");
INSERT INTO tbl_customer VALUES("202","","ABA/CU/198","MD.JAMAL SHAHRASTI","","","","","01854607855","","","","0","0","SHAHRASTI","","","9","","","1","1","2023-01-26 11:29:57");
INSERT INTO tbl_customer VALUES("203","","ABA/CU/199","MASUD (BAGMARA)","","","","","01825076172","","","","0","0","BAGMARA, COMILLA","","","","","0","1","1","2023-01-26 02:50:36");
INSERT INTO tbl_customer VALUES("204","","ABA/CU/200","SHUKTARA CENETARI","","","","","01813931719","","","","0","0","ROFIQ SUPER MARKET, KACHUA ROAD, HAJIGONZ CHANDPUR","","","","","0","1","1","2023-01-26 09:24:46");
INSERT INTO tbl_customer VALUES("206","","ABA/CU/201","MD MAMUN","","","","","01711207502","","","","0","0","BABURHAT","","","9","","","1","1","2023-01-29 04:44:20");
INSERT INTO tbl_customer VALUES("207","","ABA/CU/202","MD.MANNAN DOYABANGGA","","","","","01743827035","","","","0","0","DOYABANGGA","","","9","","","1","1","2023-01-29 06:11:07");
INSERT INTO tbl_customer VALUES("208","","ABA/CU/203","H.M RUBEL NIJ ","","","","","01855410308","","","","0","0","HAJIGONJ ","","","9","","","1","1","2023-01-30 11:17:35");
INSERT INTO tbl_customer VALUES("209","","ABA/CU/204","SHOHEL RANA (NOYAGA)","","","","","01845993012","","","","0","0","NOYAGA, RAMGONJ","","","","","0","1","1","2023-01-30 12:28:53");
INSERT INTO tbl_customer VALUES("210","","ABA/CU/205","RUBEL MIZI (BELCHO BAZAR)","","","","","01758832527","","","","0","0","BELCHO BAZAR","","","","","0","1","1","2023-01-31 12:16:21");
INSERT INTO tbl_customer VALUES("211","","ABA/CU/206","MD.MONIR VHI ","","","","","01613309132","","","","0","0","KOSUYA BAJAR","","","9","","","1","1","2023-02-01 03:46:09");
INSERT INTO tbl_customer VALUES("212","","ABA/CU/207","MD. RAJIB VHI","","","","","01816160132","","","","0","0","ROHIMANOGOR","","","9","","","1","1","2023-02-01 05:07:17");
INSERT INTO tbl_customer VALUES("213","","ABA/CU/208","RUBEL(UZANI)","","","","","01632314584","","","","0","0","HOSSENPUR","","","","","0","1","1","2023-02-01 06:21:40");
INSERT INTO tbl_customer VALUES("214","","ABA/CU/209","HI TECK HAJIGONJ","","","","","01717559020","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-02-02 03:33:27");
INSERT INTO tbl_customer VALUES("215","","ABA/CU/210","MD.SHORIF VHI HAJOGONJ","","","","","01645104774","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-02-03 10:36:27");
INSERT INTO tbl_customer VALUES("216","","ABA/CU/211","ABUL KASEM MOZUMDHAR","","","","","01817514476","","","","0","0","NASIRCHORD, HAJIGONJ, CHANDPUR","","","","","0","1","1","2023-02-03 03:10:16");
INSERT INTO tbl_customer VALUES("217","","ABA/CU/212","KALATHO VAI","","","","","01316709836","","","","0","0","HAZIGONZ, MURAGAWO","","","","","0","1","1","2023-02-03 08:08:28");
INSERT INTO tbl_customer VALUES("218","","ABA/CU/213","SAGOR=SAHJJAD BABU MOJUMDAR","","","","","01744101610","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-02-05 03:35:09");
INSERT INTO tbl_customer VALUES("219","","ABA/CU/214","FAMILY LOAN","","","","","01 881 0991 22","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-02-05 04:56:41");
INSERT INTO tbl_customer VALUES("220","","ABA/CU/215","MD, RASEL VHI LOTTRA","","","","","01733030851","","","","0","0","LOTTRA","","","9","","","1","1","2023-02-06 05:01:16");
INSERT INTO tbl_customer VALUES("221","","ABA/CU/216","MD RUMAN","","","","","01820021379","","","","0","0","MONTOLA","","","","","","1","1","2023-02-06 05:25:56");
INSERT INTO tbl_customer VALUES("222","","ABA/CU/217","JAHED (PONISHAIR)","","","","","01625127530","","","","0","0","PONISHAIR, KAMTHA BAZAR, FARIDGONZ, CHANDPUR","","","","","0","1","1","2023-02-07 12:07:15");
INSERT INTO tbl_customer VALUES("223","","ABA/CU/218","AKBAR HOSSAIN (TELISHAIR)","","","","","01625107452","","","","0","0","TELISHAIR, FARIDGONZ","","","","","0","1","1","2023-02-07 01:20:00");
INSERT INTO tbl_customer VALUES("224","","ABA/CU/219","NAZIM (LABOUR)","","","","","018810  991  22","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-02-07 08:42:45");
INSERT INTO tbl_customer VALUES("225","","ABA/CU/220","M/S KORNOPULI PAPER HOUSE","","","","","01301628828","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-02-07 09:19:03");
INSERT INTO tbl_customer VALUES("226","","ABA/CU/221","4099$ OFFER SELL AKASH","","","","","018 755 16 801","","","","0","0","HAJIGONJ","","","","","0","1","1","2023-02-08 05:00:22");
INSERT INTO tbl_customer VALUES("227","","ABA/CU/222","JOHIR VAI (GAZI)","","","","","01716223941","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-02-08 08:01:25");
INSERT INTO tbl_customer VALUES("228","","ABA/CU/223","Khela Bazzar Cabol Tv","","","","","01914519802","","saifulnasrin999@gmail.com","","0","0","khela bazar.shaharasti","","","9","","","1","1","2023-02-10 05:42:27");
INSERT INTO tbl_customer VALUES("229","","ABA/CU/224","FARUK HOSSAIN ","","","","","01882578370","","","","0","0","MOKIMABHAD, KORIMBAGAN","","","","","0","1","1","2023-02-10 10:49:46");
INSERT INTO tbl_customer VALUES("230","","ABA/CU/225","JOSHIM CABLE NETWORK","","","","","01868046637","","","","0","0","NARAYANPUR, KALIGAPUR","","","","","0","1","1","2023-02-11 11:44:39");
INSERT INTO tbl_customer VALUES("231","","ABA/CU/226","PONGKOS DHA","","","","","01716056274","","","","0","0","HAZIGONZ","","","","","0","1","1","2023-02-11 12:12:26");
INSERT INTO tbl_customer VALUES("232","","ABA/CU/227","MD. HRIDOY BAKILA BAZAR","","","","","01863139329","","","","0","0","BAKILA BAZAR","","","9","","","1","1","2023-02-13 12:13:36");
INSERT INTO tbl_customer VALUES("233","","ABA/CU/228","MD.IQBAL VHI SHAHARUSTI","","","","","01614399100","","","","0","0","SHAHARUSTI","","","9","","","1","1","2023-02-15 11:39:33");
INSERT INTO tbl_customer VALUES("234","","ABA/CU/229","MAMA CABLE ","","","","","01733900369","","","","0","0","CHOWMUHANI","","","9","","","1","1","2023-02-15 01:37:41");
INSERT INTO tbl_customer VALUES("235","","ABA/CU/230","MD.SUMON VHI OLIPUR","","","","","01858501116","","","","0","0","OLIPUR","","","9","","","1","1","2023-02-15 06:54:05");
INSERT INTO tbl_customer VALUES("236","","ABA/CU/231","MD.SAGOR VHI RANDHUNIMURA","","","","","01867317903","","","","0","0","RANDHUNIMURA","","","9","","","1","1","2023-02-17 12:00:49");
INSERT INTO tbl_customer VALUES("237","","ABA/CU/232","MD.AHSAN HABIB NOADDA","","","","","01730795415","","","","0","0","NOADDA","","","9","","","1","1","2023-02-17 10:01:09");
INSERT INTO tbl_customer VALUES("238","","ABA/CU/233","MD.MAMUN SAKPURA","","","","","01813067388","","","","0","0","SAKPURA/RAMGONJ/","","","15","","","1","1","2023-02-19 08:16:49");
INSERT INTO tbl_customer VALUES("239","","ABA/CU/234","MD FORHAD TORAGOR","","","","","01837370000","","","","0","0","TORAGOR","","","9","","","1","1","2023-02-20 06:47:05");
INSERT INTO tbl_customer VALUES("240","","ABA/CU/235","KOMOL DADA","","","","","01827103898","","","","0","0","BOLAKAL","","","9","","","1","1","2023-02-20 09:38:14");
INSERT INTO tbl_customer VALUES("241","","ABA/CU/236","MD.RUBEL VHI KHILMEHAR","","","","","01838807122","","","","0","0","KHILMEHAR","","","9","","","1","1","2023-02-22 01:15:11");
INSERT INTO tbl_customer VALUES("242","","ABA/CU/237","MD.JUBAYED ","","","","","01757475961","","","","0","0","GOLLAG","","","9","","","1","1","2023-02-23 11:27:16");
INSERT INTO tbl_customer VALUES("243","","ABA/CU/238","POLLE CABOL MAJEGASA","","","","","01827125460","","","","0","0","MAJEGASA/SASAR","","","9","","","1","1","2023-02-23 04:28:36");
INSERT INTO tbl_customer VALUES("244","","ABA/CU/239","POLASH BONDU HAJIGONJ","","","","","01613241238","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-02-28 04:22:20");
INSERT INTO tbl_customer VALUES("245","","ABA/CU/240","S.POUER CABOL","","","","","01861963330","","","","0","0","BABURHAT,CADPUR","","","9","","","1","1","2023-02-28 07:48:38");
INSERT INTO tbl_customer VALUES("246","","ABA/CU/241","LIPI APU","","","","","01855446633","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-03-04 11:16:08");
INSERT INTO tbl_customer VALUES("247","","ABA/CU/242","DINMOHAMMAD VHI QC TAWAR","","","","","01624794910","","","","0","0","QC TAWAR ","","","9","","","1","1","2023-03-08 02:23:47");
INSERT INTO tbl_customer VALUES("248","","ABA/CU/243","MEHEDI HASAN RAFI ","","","","","01878228944","","","","0","0","HAJIGONJ","","","9","","0","1","1","2023-03-09 01:14:20");
INSERT INTO tbl_customer VALUES("249","","ABA/CU/244","MD.SAMIM VHI 81","","","","","01711350881","","","","0","0","RAMGONJ ","","","","","","1","1","2023-03-10 02:03:42");
INSERT INTO tbl_customer VALUES("250","","ABA/CU/245","MD.RASELVHI 64","","","","","01883707664","","","","0","0","SHACAR","","","","","","1","1","2023-03-12 10:32:43");
INSERT INTO tbl_customer VALUES("251","","ABA/CU/246","Samsu Vai","","","","","01683212365","","","","0","0","hajigonj","","","9","","","1","1","2023-03-14 04:46:45");
INSERT INTO tbl_customer VALUES("252","","ABA/CU/247","MD ABDUL KHAYER ","","","","","01715918869","","","","0","0","RAJAPURA LAXSAM","","","","","","1","1","2023-03-15 03:06:38");
INSERT INTO tbl_customer VALUES("253","","ABA/CU/248","MD MAMUN KHAN 506","","","","","01811906506","","","","0","0","NARAYANPUR","","","","","","1","1","2023-03-17 04:53:32");
INSERT INTO tbl_customer VALUES("254","","ABA/CU/249","Abu Omor Dokan","","","","","01815587267","","","","0","0","hajigonj","","","9","","","1","1","2023-03-19 04:48:36");
INSERT INTO tbl_customer VALUES("255","","ABA/CU/250","DIGITAL PINT","","","","","01894431070","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-03-21 05:29:20");
INSERT INTO tbl_customer VALUES("256","","ABA/CU/251","ADI RABBY BOLY ","","","","","01796335136","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-03-22 03:43:50");
INSERT INTO tbl_customer VALUES("257","","ABA/CU/252","MD.NOJRUL ISLAM VHI","","","","","01726973849","","","","0","0","SHAHRASTI","","","9","","","1","1","2023-03-22 04:05:22");
INSERT INTO tbl_customer VALUES("258","","ABA/CU/253","ABUL KASAM NOADDA","","","","","01824512887","","","","0","0","NOADDA","","","9","","","1","1","2023-03-23 04:07:40");
INSERT INTO tbl_customer VALUES("259","","ABA/CU/254","Md Saiful Islam Sumon ","","","","","01818012119","","","","0","0","MOTLOV UTTOR ","","","9","","","1","1","2023-03-26 01:09:52");
INSERT INTO tbl_customer VALUES("260","","ABA/CU/255","MD IBRAHIM UJANI","","","","","01811008628","","","","0","0","UJANI","","","","","","1","1","2023-03-29 04:12:04");
INSERT INTO tbl_customer VALUES("261","","ABA/CU/256","MD TABARAK","","","","","01874126662","","","","0","0","KHACHUA ADDA ","","","9","","","1","1","2023-03-30 01:08:59");
INSERT INTO tbl_customer VALUES("262","","ABA/CU/257","TAREK BONDU","","","","","01683006582","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-03-30 05:08:42");
INSERT INTO tbl_customer VALUES("263","","ABA/CU/258","KONICA CABOL TV","","","","","01715887737","","","","0","0","ROGONATPUR","","","","","","1","1","2023-03-30 08:11:14");
INSERT INTO tbl_customer VALUES("264","","ABA/CU/259","MD MOSTAFA JAMAL","","","","","01727600303","","","","0","0","HAJIGONJ","","","","","","1","1","2023-03-31 02:29:49");
INSERT INTO tbl_customer VALUES("265","","ABA/CU/260","SKY NET BORIAISH ","","","","","01878389020","","","","0","0","RAMGONJ","","","15","","155","1","1","2023-04-01 05:44:35");
INSERT INTO tbl_customer VALUES("266","","ABA/CU/261","MD HASAN VHI 43","","","","","01813257343","","","","0","0","BAKILA BAJAR ","","","9","","","1","1","2023-04-01 08:31:57");
INSERT INTO tbl_customer VALUES("267","","ABA/CU/262","NAZIM MOJUMDAR","","","","","01629432124","","","","0","0","BELCHOW KONDRA ","","","9","","","1","1","2023-04-02 11:53:09");
INSERT INTO tbl_customer VALUES("268","","ABA/CU/263","MD KALAM VHI ","","","","","01670497820","","","","0","0","DOYABANGGA","","","9","","","1","1","2023-04-03 11:23:05");
INSERT INTO tbl_customer VALUES("269","","ABA/CU/264","Ster Gaet","","","","","01711354398","","","","0","0","hajigonj","","","9","","","1","1","2023-04-04 05:21:43");
INSERT INTO tbl_customer VALUES("270","","ABA/CU/265","Farad Netwerk","","","","","01938420417","","","","0","0","daudkande","","","11","","","1","1","2023-04-08 05:51:58");
INSERT INTO tbl_customer VALUES("271","","ABA/CU/266","MD RUBEL ( KOCUA)","","","","","01820050623","","","","0","0","KOUCA","","","9","","","1","1","2023-04-13 12:21:13");
INSERT INTO tbl_customer VALUES("272","","ABA/CU/267","MD JONE","","","","","01614256504","","","","0","0","KOCUA","","","","","","1","1","2023-04-13 08:58:50");
INSERT INTO tbl_customer VALUES("273","","ABA/CU/268","MD FORKAN HOJUR","","","","","01813213084","","","","0","0","SHAHRASTI","","","","","","1","1","2023-04-16 05:03:10");
INSERT INTO tbl_customer VALUES("274","","ABA/CU/269","MD SOHIDULLA","","","","","01741635659","","","","0","0","FORIDGONJ","","","","","","1","1","2023-04-17 11:00:31");
INSERT INTO tbl_customer VALUES("275","","ABA/CU/270","H.M MASUD VHI ","","","","","01887766992","","","","0","0","JOYPURA","","","9","","","1","1","2023-04-19 01:12:48");
INSERT INTO tbl_customer VALUES("276","","ABA/CU/271","MD KAWSAR VHI","","","","","01877937454","","","","0","0","PARIDGONJ SOLLA","","","9","","","1","1","2023-04-19 10:18:22");
INSERT INTO tbl_customer VALUES("277","","ABA/CU/272","Alamin VHI ","","","","","01734031023","","","","0","0","KOSUYA","","","","","","1","1","2023-04-26 04:48:03");
INSERT INTO tbl_customer VALUES("278","","ABA/CU/273","Md Khalil Kaka","","","","","01819541628","","","","0","0","alig rampur","","","","","","1","1","2023-04-27 09:12:39");
INSERT INTO tbl_customer VALUES("279","","ABA/CU/274","MEHEDI CABLE NETWORK ","","","","","01812496224","","","","0","0","RAJARGAY RAMRA ","","","","","","1","1","2023-05-01 04:47:40");
INSERT INTO tbl_customer VALUES("280","","ABA/CU/275","Ali Vhi SHARIATPUR","","","","","01830009494","","","","0","0","Shariatpur","","","9","","","1","1","2023-05-04 12:01:51");
INSERT INTO tbl_customer VALUES("281","","ABA/CU/276","AMIR VHI ","","","","","01818096753","","","","0","0","KHAJUGAY","","","9","","","1","1","2023-05-04 11:14:29");
INSERT INTO tbl_customer VALUES("282","","ABA/CU/277","RAJJAK BATTERY ","","","","","01711445453","01711445453","","","0","0","HAJIGONJ","","","","","0","1","1","2023-05-11 08:01:47");
INSERT INTO tbl_customer VALUES("283","","ABA/CU/278","MD SHAHJALAL","","","","","01838314051","","","","0","0","LAKSHMIPUR","","","","","","1","1","2023-05-11 09:43:37");
INSERT INTO tbl_customer VALUES("284","","ABA/CU/279","MD SHAHJALAL (CHANDINA)","","","","","01727565797","","","","0","0","NOBABAPUR,COMILA","","","","","","1","1","2023-05-13 06:47:24");
INSERT INTO tbl_customer VALUES("285","","ABA/CU/280","JOYPURA CABEL","","","","","01734032752","","","","0","0","RAMGONJ","","","","","","1","1","2023-05-13 10:36:00");
INSERT INTO tbl_customer VALUES("286","","ABA/CU/281","MD ISMAIL MIZI ","","","","","01933200903","","","","0","0","HORIDASHPARA MATLAB","","","9","","","1","1","2023-05-19 12:03:14");
INSERT INTO tbl_customer VALUES("287","","ABA/CU/282","Boisake Caboll","","","","","01716668416","","","","0","0","raiur/","","","15","","","1","1","2023-05-21 08:36:20");
INSERT INTO tbl_customer VALUES("288","","ABA/CU/283","MD MUKTAR ","","","","","01612449198","","","","0","0","KACHUA SACHAR","","","","","","1","1","2023-05-22 01:31:50");
INSERT INTO tbl_customer VALUES("289","","ABA/CU/284","Md Atik Subidpur","","","","","01643873415","","","","0","0","subidpur","","","9","","","1","1","2023-05-24 07:23:48");
INSERT INTO tbl_customer VALUES("290","","ABA/CU/285","AKANIY ONLINE","","","","","01871238176","","","","0","0","AKANIY .KACUA","","","9","","","1","1","2023-05-25 10:31:31");
INSERT INTO tbl_customer VALUES("291","","ABA/CU/286","MD MAMUN ","","","","","01612116484","","","","0","0","BADDA  ","","","9","","","1","1","2023-05-26 05:29:01");
INSERT INTO tbl_customer VALUES("292","","ABA/CU/287","MD ARSHAD(NOBORUPA)","","","","","01821934931","","","","0","0","KOUCHA","","","9","","","1","1","2023-05-27 12:56:08");
INSERT INTO tbl_customer VALUES("293","","ABA/CU/288","MUKTA ENTERPRISE","","","","","01818856909","","","","0","0","Chanpur,palakhal","","","","","","1","1","2023-05-31 03:06:09");
INSERT INTO tbl_customer VALUES("294","","ABA/CU/289","Kamrul","","","","","01757105582","","","","0","0","MATLOV","","","9","","","1","1","2023-05-31 05:57:23");
INSERT INTO tbl_customer VALUES("295","","ABA/CU/290","ABDULLAH .A.P","","","","","01836119327","","","","0","0","HAJIGONJ","","","","","","1","1","2023-06-04 02:03:23");
INSERT INTO tbl_customer VALUES("296","","ABA/CU/291","YUNUS VHI ","","","","","01811692262","","","","0","0","BAKILA ","","","","","","1","1","2023-06-05 06:27:28");
INSERT INTO tbl_customer VALUES("297","","ABA/CU/292","Grin Vu Wollad Cabol [masud Rana]","","masud rana","","","01922801653","","","","0","0","moisamora","","","10","17","","1","1","2023-06-15 06:17:04");
INSERT INTO tbl_customer VALUES("298","","ABA/CU/293","MD SUMON ","","","","","01726457299","","","","0","0","SANTIR BAJAR ","","","","","","1","1","2023-06-26 03:15:36");
INSERT INTO tbl_customer VALUES("299","","ABA/CU/294","Santo Cabol Netwerk","","","","","01712231943","","","","0","0","penpara/ramgonj","","","15","","","1","1","2023-07-13 09:49:10");
INSERT INTO tbl_customer VALUES("300","","ABA/CU/295","Md. Dalowar (Nalgolkot)","","","","","01819427328","","","","0","0","Nalgolkot","","","11","","","1","1","2023-07-17 12:51:43");
INSERT INTO tbl_customer VALUES("301","","ABA/CU/296","Md. Mamun ","","Sky Nate","","","01580438840","","","","0","0","Koiyarpoul  Bazar","","","9","","","1","1","2023-07-24 09:53:34");
INSERT INTO tbl_customer VALUES("302","","ABA/CU/297","Farhan","","Farhan Cabal network","","","01314106405","","","","0","0","kachua","","","9","","","1","1","2023-08-03 01:09:45");
INSERT INTO tbl_customer VALUES("303","","ABA/CU/298","IKRA ONLINE CHANDPUR","","","","","01835050202","","","","0","0","CHANDPUR BAJAR","","","","","","1","1","2023-08-04 05:04:48");
INSERT INTO tbl_customer VALUES("304","","ABA/CU/299","Bakila Online","","","","","01821205648","","","","0","0","BAKILA BAZAR","","","","","","1","1","2023-08-06 01:58:33");
INSERT INTO tbl_customer VALUES("305","","ABA/CU/300","LABTOP BAZAR HAJIGONJ","","","","","01987982698","","","","0","0","HAJIGONJ","","","","","","1","1","2023-08-18 07:35:43");
INSERT INTO tbl_customer VALUES("306","","ABA/CU/301","MODINA A P","","","","","01903745708","","","","0","0","MUDAFFARGONJ","","","","","","1","1","2023-08-18 08:36:38");
INSERT INTO tbl_customer VALUES("307","","ABA/CU/302","Md Rasel Fatepur","","","","","01647058953","","","","0","0","fatepur/","","","9","","","1","1","2023-08-20 04:04:44");
INSERT INTO tbl_customer VALUES("308","","ABA/CU/303","SHIMUL VHI ","","","","","01818184990","","","","0","0","KOSUYA ","","","","","","1","1","2023-08-21 03:17:00");
INSERT INTO tbl_customer VALUES("309","","ABA/CU/304","FORHAD VHI ","","","","","01876433030","","","","0","0","MATUN ","","","","","","1","1","2023-08-25 04:09:16");
INSERT INTO tbl_customer VALUES("310","","ABA/CU/305","RAJIB SONDRO SEL","","","","","01920564350","","","","0","0","ROREMANOGOR","","","9","","","1","1","2023-08-25 08:59:59");
INSERT INTO tbl_customer VALUES("311","","ABA/CU/306","Sohel Vai Rabbi Kasary ","","","","","01643005162","","","","0","0","hajigonj","","","","","","1","1","2023-08-31 06:18:26");
INSERT INTO tbl_customer VALUES("312","","ABA/CU/307","DHAKA ECT","","","","","01838272870","","","","0","0","HAJIGONJ","","","","","","1","1","2023-09-01 05:02:16");
INSERT INTO tbl_customer VALUES("313","","ABA/CU/308","RIGAN ","","","","","01818703759","","","","0","0","CHANDPUR","","","","","","1","1","2023-09-04 07:08:36");
INSERT INTO tbl_customer VALUES("314","","ABA/CU/309","Kamrul Waruk Bazar","","","","","01713602104","","","","0","0","WARUK BAZAR","","","","","","1","1","2023-09-07 08:55:47");
INSERT INTO tbl_customer VALUES("315","","ABA/CU/310","Md Hasan ","","","","","01700661061","","","","0","0","suchipara","","","","","","1","1","2023-09-12 11:26:34");
INSERT INTO tbl_customer VALUES("316","","ABA/CU/311","MD IMRAN","","","","","01811693232","","","","0","0","HATILA","","","","","","1","1","2023-09-12 01:16:17");
INSERT INTO tbl_customer VALUES("317","","ABA/CU/312","YOUSUP PATWARY","","","","","01884008276","","","","0","0","HAJIGONJ","","","","","","1","1","2023-09-12 03:31:11");
INSERT INTO tbl_customer VALUES("318","","ABA/CU/313","Hannan Vhi ","","","","","01741217337","","","","0","0","Kachua Akiara","","","","","","1","1","2023-09-13 12:00:44");
INSERT INTO tbl_customer VALUES("319","","ABA/CU/314","Md Rezo Kanchpur","","","","","01710981353","","","","0","0","kanchur/chodraybazar","","","","","","1","1","2023-09-14 06:44:13");
INSERT INTO tbl_customer VALUES("320","","ABA/CU/315","Md Kiron Hossan","","","","","01874144488","","","","0","0","shahrasti ragoy","","","","","","1","1","2023-09-19 06:30:47");
INSERT INTO tbl_customer VALUES("321","","ABA/CU/316","Mithun Vhi ","","","","","01823583942","","","","0","0","hajigonj","","","","","0","1","1","2023-09-22 11:51:33");
INSERT INTO tbl_customer VALUES("322","","ABA/CU/317","Md Shakib","","","","","01754677385","","","","0","0","juila","","","","","","1","1","2023-09-24 05:31:00");
INSERT INTO tbl_customer VALUES("323","","ABA/CU/318","Md Momin","","","","","01821666282","","","","0","0","Asharkota","","","","","","1","1","2023-09-27 04:35:32");
INSERT INTO tbl_customer VALUES("324","","ABA/CU/319","Khokon Vhi ","","","","","01818563990","","","","0","0","Shahrasti","","","","","","1","1","2023-10-09 07:25:15");
INSERT INTO tbl_customer VALUES("325","","ABA/CU/320","Satellite Vision2","","","","","01855906122","","","","0","0","trakrod","","","9","","","1","1","2023-10-23 08:59:00");
INSERT INTO tbl_customer VALUES("326","","ABA/CU/321","MD MOHIN","","","","","01856731790","","","","0","0","Sripur,Debpur","","","","","","1","1","2023-10-24 09:39:50");
INSERT INTO tbl_customer VALUES("327","","ABA/CU/322","MD Habib","","","","","01633027099","","","","0","0","MUDAFFORGONJ","","","","","","1","1","2023-10-30 12:33:36");
INSERT INTO tbl_customer VALUES("328","","ABA/CU/323","MD AHASAN HABIB(BOLSID)","","","","","01818500987","","","","0","0","BOLSID,SHARASTI","","","9","","","1","1","2023-11-02 04:10:01");
INSERT INTO tbl_customer VALUES("329","","ABA/CU/324","Salim Ramgonj","","","","","01815594542","","","","0","0","ramgonj","","","15","","","1","1","2023-11-03 04:52:52");
INSERT INTO tbl_customer VALUES("330","","ABA/CU/325","MD SOMRAT KOBIR ","","","","","01879217985","","","","0","0","PALGIRI","","","9","","","1","1","2023-11-05 06:23:05");
INSERT INTO tbl_customer VALUES("331","","ABA/CU/326","HIMON VHI HAJIGONJ","","","","","01745840766","","","","0","0","HAJIGONJ","","","","","","1","1","2023-11-07 12:44:10");
INSERT INTO tbl_customer VALUES("332","","ABA/CU/327","ABU BOKKOR ","","","","","01640522401","","","","0","0","DEBPUR","","","9","","","1","1","2023-11-09 06:47:27");
INSERT INTO tbl_customer VALUES("333","","ABA/CU/328","HASAN MAHMUD","","","","","01715395157","","","","0","0","BORKUL","","","","","","1","1","2023-11-09 09:59:53");
INSERT INTO tbl_customer VALUES("334","","ABA/CU/329","MD.MOHIN VHI/DULALM VHI MALIGAW","","","","","01623037346","","","","0","0","KASHIMPUR","","","9","","","1","1","2023-11-12 12:46:02");
INSERT INTO tbl_customer VALUES("335","","ABA/CU/330","MD ABDUR RAHMAN","","","","","01614396675","","","","0","0","KOSUYA BAZAR","","","9","","","1","1","2023-11-21 12:35:49");
INSERT INTO tbl_customer VALUES("336","","ABA/CU/331","ABDUR SAMAD VHI ","","","","","01741727253","","","","0","0","Mudargonj","","","","","","1","1","2023-11-21 09:08:32");
INSERT INTO tbl_customer VALUES("337","","ABA/CU/332","RUBEL VHI ORANGE","","","","","01799693040","","","","0","0","BAKILA ","","","","","","1","1","2023-11-24 08:08:57");
INSERT INTO tbl_customer VALUES("338","","ABA/CU/333","Md Sohag  Manapur","","","","","01840521901","","","","0","0","manapur","","","9","","","1","1","2023-11-26 07:35:28");
INSERT INTO tbl_customer VALUES("339","","ABA/CU/334","Md Sumon Rel Ctose","","","","","01737195893","","","","0","0","rei ctose","","","","","","1","1","2023-11-27 02:40:37");
INSERT INTO tbl_customer VALUES("340","","ABA/CU/335","Shaown Boli ","","","","","01750337770","","","","0","0","HAJIGONJ","","","","","0","1","1","2023-11-27 04:32:08");
INSERT INTO tbl_customer VALUES("341","","ABA/CU/336","Suboj Mama","","","","","01711-430913","","","","0","0","Waruk","","","9","","","1","1","2023-11-29 10:28:01");
INSERT INTO tbl_customer VALUES("342","","ABA/CU/337","Computer Zone Hajigonj","","","","","01686921385","","","","0","0","hajigonj","","","","","","1","1","2023-12-09 06:16:23");
INSERT INTO tbl_customer VALUES("343","","ABA/CU/338","MD MITHU VHI ","","","","","01818046790","","","","0","0","KACHUA","","","9","","","1","1","2023-12-11 09:14:08");
INSERT INTO tbl_customer VALUES("344","","ABA/CU/339","MD IMAM SORDER","","","","","01639070179","","","","0","0","HAJIGONJ","","","9","","","1","1","2023-12-16 02:56:21");
INSERT INTO tbl_customer VALUES("345","","ABA/CU/340","MD UZZAL ISLAM","","","","","01300473797","","","","0","0","KACHUA POTEFPUR","","","","","","1","1","2023-12-20 11:53:24");
INSERT INTO tbl_customer VALUES("346","","ABA/CU/341","NIRAPAD ELECTRONICS","","","","","01733267855","","","","0","0","SHAHRASTI","","","","","","1","1","2023-12-21 05:41:17");
INSERT INTO tbl_customer VALUES("347","","ABA/CU/342","Sachar Jahanger","","01812059290","","","0181259290","","","","0","0","sachar","","","","","","1","1","2023-12-25 03:55:21");
INSERT INTO tbl_customer VALUES("348","","ABA/CU/343","MD HASAN ","","","","","01721440519","","","","0","0","Did you mean:
KAJIRGAW","","","9","","","1","1","2023-12-29 03:43:20");
INSERT INTO tbl_customer VALUES("349","","ABA/CU/344","MD RAKIB (RAMGONJ)","","","","","01824410057","","","","0","0","RAMGONJ","","","15","","","1","1","2024-01-01 09:56:31");
INSERT INTO tbl_customer VALUES("350","","ABA/CU/345","Mannan Dickchile","","01813514757","","","01813514757","","","","0","0","Hazigon, Chandpur.","","","9","","","1","1","2024-01-05 08:39:34");
INSERT INTO tbl_customer VALUES("351","","ABA/CU/346","Ms Online Service","","","","","01929197791","","","","0","0","turk rod munshi tower","","","9","","","1","1","2024-01-11 03:34:02");
INSERT INTO tbl_customer VALUES("352","","ABA/CU/347","Md Forahd Uddin","","","","","01609199680","","","","0","0","ujani","","","","","","1","1","2024-02-08 03:21:38");
INSERT INTO tbl_customer VALUES("353","","ABA/CU/348","Shahrasti Cable Network","","","","","01823597241","","","","0","0","Shahrasti ","","","9","","","1","1","2024-02-09 06:35:05");
INSERT INTO tbl_customer VALUES("354","","ABA/CU/349","MD RIFATUL ALLOM OLOCK","","","","","01811223010","","","","0","0","MUDAPPORGONJ","","","","","0","1","1","2024-02-16 07:16:08");
INSERT INTO tbl_customer VALUES("355","","ABA/CU/350","Md Liton Dis","","","","","01798249289","","","","0","0","kacua","","","","","","1","1","2024-02-20 02:22:51");
INSERT INTO tbl_customer VALUES("356","","ABA/CU/351","ROBI VHI","","","","","01772195399","","","","0","0","RAMGONJ BAZAR","","","","","","1","1","2024-02-21 04:55:52");
INSERT INTO tbl_customer VALUES("357","","ABA/CU/352","RASEL VHI B-NET ","","","","","01886068646","","","","0","0","Haziganj
BAZAR","","","","","","1","1","2024-02-26 06:01:07");
INSERT INTO tbl_customer VALUES("358","","ABA/CU/353","DHADHA","","","","","01717054426","","","","0","0","RAMGONJ","","","","","","1","1","2024-02-27 07:30:32");
INSERT INTO tbl_customer VALUES("359","","ABA/CU/354","ASHIQ TALUKDAR ","","","","","018631924292","","","","0","0","NOYAR BAZAR","","","11","","","1","1","2024-03-13 07:04:01");
INSERT INTO tbl_customer VALUES("360","","ABA/CU/355","Shkibol Hassan","","","","","01407133668","","","","0","0","wirles","","","9","","","1","1","2024-03-23 03:08:27");
INSERT INTO tbl_customer VALUES("361","","ABA/CU/356","MD KIRON KHAN","","","","","01617166681","","","","0","0","Narayanpur Bazar, Motlob,","","","9","","","1","1","2024-03-25 08:39:03");
INSERT INTO tbl_customer VALUES("362","","ABA/CU/357","MD SHOFIQ ","","","","","01811009286","","","","0","0","MOTLOV","","","9","","0","1","1","2024-04-04 09:30:18");
INSERT INTO tbl_customer VALUES("363","","ABA/CU/358","Shohag Vhi ","","","","","01722353572","","","","0","0","hajigonj","","","","","","1","1","2024-04-19 01:21:12");
INSERT INTO tbl_customer VALUES("364","","ABA/CU/359","RAKIB VHI ","","","","","01301625291","","","","0","0","SHAHIBAZAR","","","","","","1","1","2024-04-21 05:49:20");
INSERT INTO tbl_customer VALUES("365","","ABA/CU/360","Md Saiful Islam","","01895243495","","","01895243495","","","","0","0","dopoll","","","9","","","1","1","2024-04-26 05:22:50");
INSERT INTO tbl_customer VALUES("366","","ABA/CU/361","JISHAN AHMED ","","","","","01847182789","","","","0","0","Changatali Bazar
","","","","","","1","1","2024-05-02 02:27:44");
INSERT INTO tbl_customer VALUES("367","","ABA/CU/362","SHOHAG DALI","","SHOHAG DALI","","","01834308476","","","","0","0","MUKUM DESHAR","","","","","","1","1","2024-05-03 05:43:21");
INSERT INTO tbl_customer VALUES("368","","ABA/CU/363","Mahabub","","","","","01878231833","","","","0","0","BELSOW BAZAR","","","","","","1","1","2024-05-06 03:59:30");
INSERT INTO tbl_customer VALUES("369","","ABA/CU/364","DHAKA NETWORK ","","","","","01672936395","","","","0","0","27/B,2ND FLOOR,EASTERN MOLLIKA LANE ELEPHANT ROAD DHAKA-1205","","","18","12","","1","1","2024-05-14 06:04:19");
INSERT INTO tbl_customer VALUES("370","","ABA/CU/365","Titu Prodan","","","","","01681413784","","","","0","0","uttor shibpur","","","","","","1","1","2024-05-19 11:36:26");
INSERT INTO tbl_customer VALUES("371","","ABA/CU/366","MD KOBIR PRPDHAN ","","","","","01767901180","","","","0","0","UTTOR SHIBPUR","","","","","","1","1","2024-05-19 11:43:29");
INSERT INTO tbl_customer VALUES("372","","ABA/CU/367","RAKIB VHI ","","","","","01686805766","","","","0","0","hajigonj","","","","","","1","1","2024-05-23 05:43:54");
INSERT INTO tbl_customer VALUES("373","","ABA/CU/368","LEPTOP BAZAR","","","","","01646679816","","","","0","0","HAJIGONJ","","","","","","1","1","2024-06-12 12:32:34");
INSERT INTO tbl_customer VALUES("374","","ABA/CU/369","Ashik Anterprisj","","","","","01632753310","","","","0","0","adda.borora","","","11","","","1","1","2024-06-22 08:59:11");
INSERT INTO tbl_customer VALUES("375","","ABA/CU/370","Md Helal Naraonpur","","","","","01631266151","","","","0","0","naraonpur","","","9","","","1","1","2024-06-22 09:36:16");
INSERT INTO tbl_customer VALUES("376","","ABA/CU/371","ARIF DOPOLLAH","","","","","01919120123","","","","0","0","DOPOLLAH","","","9","","","1","1","2024-07-01 01:32:24");
INSERT INTO tbl_customer VALUES("377","","ABA/CU/372","Hatela Cabol Nat","","","","","01612829738","","","","0","0","hatela","","","","","","1","1","2024-07-06 09:27:53");
INSERT INTO tbl_customer VALUES("378","","ABA/CU/373","Foyezullah","","","","","01813926599","","","","0","0","comilla","","","11","","","1","1","2024-08-06 08:01:24");
INSERT INTO tbl_customer VALUES("379","","ABA/CU/374","MD.ISMAIL","","","","","01831024629","","","","0","0","NOYOGAW","","","9","","","1","1","2024-08-08 12:25:50");
INSERT INTO tbl_customer VALUES("380","","ABA/CU/375","Shadin Bangla","","","","","01684615940","","","","0","0","shahrasti","","","9","","","1","1","2024-08-10 07:15:16");
INSERT INTO tbl_customer VALUES("381","","ABA/CU/376","Zafor Iqbal","","","","","01856678117","","","","0","0","boksho ","","","9","","","1","1","2024-08-12 12:51:48");
INSERT INTO tbl_customer VALUES("382","","ABA/CU/377","MD YOUSUF","","","","","01864435206","","","","0","0","NARAYONPUR","","","","","","1","1","2024-08-12 02:02:05");
INSERT INTO tbl_customer VALUES("383","","ABA/CU/378","Hasan Vai Shasar","","","","","01827273440","","","","0","0","shasar","","","9","","","1","1","2024-08-13 04:12:30");
INSERT INTO tbl_customer VALUES("384","","ABA/CU/379","Sofiqul Islam Rana","","","","","01881800768","","","","0","0","lotra bazar shahrasti","","","","","","1","1","2024-08-14 02:16:14");
INSERT INTO tbl_customer VALUES("385","","ABA/CU/380","RASEL                                        ","","","","","01686497326","","","","0","0","GOLLAG","","","","","","1","1","2024-08-20 06:36:50");
INSERT INTO tbl_customer VALUES("386","","ABA/CU/381","NASIR MOLLA","","","","","01613229538","","","","0","0","CHANDPUR","","","","","","1","1","2024-08-25 07:49:43");
INSERT INTO tbl_customer VALUES("387","","ABA/CU/382","Ss Internet","","","","","01887902307","","","","0","0","randhune mura","","","","","","1","1","2024-08-31 02:24:04");
INSERT INTO tbl_customer VALUES("388","","ABA/CU/383","MD.MOJIBUR RAHMAN","","","","","01855668881","","","","0","0","KOCUYA","","","9","","","1","1","2024-09-01 10:31:49");
INSERT INTO tbl_customer VALUES("389","","ABA/CU/384","MD KASHEM CHASAR","","","","","01832851664","","","","0","0","CHASAR","","","9","","","1","1","2024-09-02 11:23:24");
INSERT INTO tbl_customer VALUES("390","","ABA/CU/385","Friends Cabol","","","","","01821500136","","","","0","0","barura.eakbarlya","","","11","","","1","1","2024-09-03 09:59:50");
INSERT INTO tbl_customer VALUES("391","","ABA/CU/386","MD ZAHANGIR CHASAR","","","","","01935718392","","","","0","0","CHASAR","","","9","","","1","1","2024-09-04 09:04:32");
INSERT INTO tbl_customer VALUES("392","","ABA/CU/387","Sumon Dada","","","","","0175829695","","","","0","0","ramgong","","","","","","1","1","2024-09-06 07:42:20");
INSERT INTO tbl_customer VALUES("393","","ABA/CU/388","FABIR NET","","","","","01607970058","","","","0","0","MOTALAB","","","","","","1","1","2024-09-07 06:59:14");
INSERT INTO tbl_customer VALUES("394","","ABA/CU/389","MD FORID HOSSEN","","","","","01850033333","","","","0","0","RAMGONG","","","9","","","1","1","2024-09-10 08:55:02");
INSERT INTO tbl_customer VALUES("395","","ABA/CU/390","IBRAHIM MUNSIRHAT","","","","","01613848474","","","","0","0","MUNSIRHAT","","","","","","1","1","2024-09-13 03:15:43");
INSERT INTO tbl_customer VALUES("396","","ABA/CU/391","BASIR MOLLICK","","","","","01879106505","","","","0","0","KHAZURIA","","","9","","","1","1","2024-09-13 05:36:23");



CREATE TABLE `tbl_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(10,2) NOT NULL,
  `apdate` datetime NOT NULL,
  `status` int(11) DEFAULT 1,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=265 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_expenses VALUES("2","EXP181222101","","1070.00","2022-12-18 00:00:00","1","0","1","2022-12-18 07:48:18");
INSERT INTO tbl_expenses VALUES("4","EXP181222103","","100.00","2022-12-18 00:00:00","1","0","1","2022-12-18 07:56:17");
INSERT INTO tbl_expenses VALUES("5","EXP181222104","","1650.00","2022-12-18 00:00:00","1","0","1","2022-12-18 08:06:14");
INSERT INTO tbl_expenses VALUES("6","EXP181222105","","5350.00","2022-12-18 00:00:00","1","0","1","2022-12-18 08:06:51");
INSERT INTO tbl_expenses VALUES("7","EXP181222106","","6000.00","2022-12-18 00:00:00","1","0","1","2022-12-18 08:11:30");
INSERT INTO tbl_expenses VALUES("8","EXP181222107","","11150.00","2022-12-18 00:00:00","1","0","1","2022-12-18 08:13:09");
INSERT INTO tbl_expenses VALUES("11","EXP191222102","","100.00","2022-12-19 00:00:00","1","0","1","2022-12-19 08:18:46");
INSERT INTO tbl_expenses VALUES("12","EXP201222101","","240.00","2022-12-20 00:00:00","1","0","1","2022-12-20 06:22:18");
INSERT INTO tbl_expenses VALUES("14","EXP201222102","","200.00","2022-12-20 00:00:00","1","0","1","2022-12-20 07:45:17");
INSERT INTO tbl_expenses VALUES("15","EXP211222101","","1120.00","2022-12-20 00:00:00","1","0","1","2022-12-21 12:30:26");
INSERT INTO tbl_expenses VALUES("18","EXP221222101","","500.00","2022-12-22 00:00:00","1","0","1","2022-12-22 12:01:31");
INSERT INTO tbl_expenses VALUES("19","EXP221222102","","80.00","2022-12-22 00:00:00","1","0","1","2022-12-22 01:13:55");
INSERT INTO tbl_expenses VALUES("21","EXP221222103","","8500.00","2022-12-22 00:00:00","1","0","1","2022-12-22 09:10:40");
INSERT INTO tbl_expenses VALUES("27","EXP231222103","","800.00","2022-12-23 00:00:00","1","0","1","2022-12-23 03:10:47");
INSERT INTO tbl_expenses VALUES("28","EXP231222104","","400.00","2022-12-23 00:00:00","1","0","1","2022-12-23 05:01:01");
INSERT INTO tbl_expenses VALUES("29","EXP231222105","","500.00","2022-12-23 00:00:00","1","0","1","2022-12-23 05:42:46");
INSERT INTO tbl_expenses VALUES("31","EXP231222107","","500.00","2022-12-23 00:00:00","1","0","1","2022-12-23 09:34:56");
INSERT INTO tbl_expenses VALUES("33","EXP231222108","","100.00","2022-12-23 00:00:00","1","0","1","2022-12-23 09:52:03");
INSERT INTO tbl_expenses VALUES("34","EXP241222101","","600.00","2022-12-24 00:00:00","1","0","1","2022-12-24 12:30:43");
INSERT INTO tbl_expenses VALUES("35","EXP241222102","","300.00","2022-12-24 00:00:00","1","0","1","2022-12-24 02:40:07");
INSERT INTO tbl_expenses VALUES("36","EXP241222103","","200.00","2022-12-24 00:00:00","1","0","1","2022-12-24 05:08:09");
INSERT INTO tbl_expenses VALUES("37","EXP241222104","","370.00","2022-12-24 00:00:00","1","0","1","2022-12-24 06:46:43");
INSERT INTO tbl_expenses VALUES("38","EXP241222105","","200.00","2022-12-24 00:00:00","1","0","1","2022-12-24 07:20:34");
INSERT INTO tbl_expenses VALUES("43","EXP251222104","","300.00","2022-12-25 00:00:00","1","0","1","2022-12-25 08:46:31");
INSERT INTO tbl_expenses VALUES("45","EXP261222101","","580.00","2022-12-26 00:00:00","1","0","1","2022-12-26 06:01:32");
INSERT INTO tbl_expenses VALUES("53","EXP261222103","","20.00","2022-12-26 00:00:00","1","0","1","2022-12-26 07:24:11");
INSERT INTO tbl_expenses VALUES("54","EXP261222104","","200.00","2022-12-26 00:00:00","1","0","1","2022-12-26 07:38:49");
INSERT INTO tbl_expenses VALUES("56","EXP261222106","","500.00","2022-12-25 00:00:00","1","0","1","2022-12-26 10:14:32");
INSERT INTO tbl_expenses VALUES("61","EXP271222102","","50.00","2022-12-27 00:00:00","1","0","1","2022-12-27 06:09:00");
INSERT INTO tbl_expenses VALUES("63","EXP271222104","","300.00","2022-12-26 00:00:00","1","0","1","2022-12-27 07:03:01");
INSERT INTO tbl_expenses VALUES("65","EXP271222106","","5000.00","2022-12-27 00:00:00","1","0","1","2022-12-27 10:56:44");
INSERT INTO tbl_expenses VALUES("66","EXP271222107","","35.00","2022-12-27 00:00:00","1","0","1","2022-12-27 11:09:27");
INSERT INTO tbl_expenses VALUES("67","EXP281222101","","300.00","2022-12-27 00:00:00","1","0","1","2022-12-28 10:37:26");
INSERT INTO tbl_expenses VALUES("68","EXP281222102","","10.00","2022-12-28 00:00:00","1","0","1","2022-12-28 05:31:18");
INSERT INTO tbl_expenses VALUES("69","EXP281222103","","100.00","2022-12-28 00:00:00","1","0","1","2022-12-28 07:06:43");
INSERT INTO tbl_expenses VALUES("72","EXP281222106","","20.00","2022-12-28 00:00:00","1","0","1","2022-12-28 10:19:51");
INSERT INTO tbl_expenses VALUES("75","EXP291222101","","400.00","2022-12-29 00:00:00","1","0","1","2022-12-29 01:25:38");
INSERT INTO tbl_expenses VALUES("76","EXP291222102","","20.00","2022-12-29 00:00:00","1","0","1","2022-12-29 10:19:33");
INSERT INTO tbl_expenses VALUES("77","EXP291222103","","120.00","2022-12-29 00:00:00","1","0","1","2022-12-29 10:29:41");
INSERT INTO tbl_expenses VALUES("78","EXP291222104","","100.00","2022-12-29 00:00:00","1","0","1","2022-12-29 10:35:06");
INSERT INTO tbl_expenses VALUES("79","EXP291222105","","100.00","2022-12-29 00:00:00","1","0","1","2022-12-29 10:35:30");
INSERT INTO tbl_expenses VALUES("81","EXP301222102","","90.00","2022-12-30 00:00:00","1","0","1","2022-12-30 05:55:36");
INSERT INTO tbl_expenses VALUES("82","EXP301222103","","25.00","2022-12-30 00:00:00","1","0","1","2022-12-30 05:57:52");
INSERT INTO tbl_expenses VALUES("86","EXP301222105","","100.00","2022-12-30 00:00:00","1","0","1","2022-12-30 10:42:28");
INSERT INTO tbl_expenses VALUES("87","EXP301222106","","35.00","2022-12-30 00:00:00","1","0","1","2022-12-30 10:50:28");
INSERT INTO tbl_expenses VALUES("88","EXP311222101","","250.00","2022-12-31 00:00:00","1","0","1","2022-12-31 11:52:44");
INSERT INTO tbl_expenses VALUES("89","EXP020123101","","520.00","2023-01-01 00:00:00","1","0","1","2023-01-02 01:11:14");
INSERT INTO tbl_expenses VALUES("90","EXP020123102","","220.00","2023-01-02 00:00:00","1","0","1","2023-01-02 01:13:17");
INSERT INTO tbl_expenses VALUES("91","EXP020123103","","500.00","2023-01-02 00:00:00","1","0","1","2023-01-02 06:39:48");
INSERT INTO tbl_expenses VALUES("93","EXP030123101","","1600.00","2023-01-03 00:00:00","1","0","1","2023-01-03 11:54:43");
INSERT INTO tbl_expenses VALUES("94","EXP040123101","","200.00","2023-01-04 00:00:00","1","0","1","2023-01-04 10:33:23");
INSERT INTO tbl_expenses VALUES("95","EXP050123101","","100.00","2023-01-04 00:00:00","1","0","1","2023-01-05 11:36:13");
INSERT INTO tbl_expenses VALUES("96","EXP050123102","","690.00","2023-01-05 00:00:00","1","0","1","2023-01-05 04:53:32");
INSERT INTO tbl_expenses VALUES("97","EXP050123103","","640.00","2023-01-05 00:00:00","1","0","1","2023-01-05 10:49:14");
INSERT INTO tbl_expenses VALUES("98","EXP050123104","","500.00","2023-01-05 00:00:00","1","0","1","2023-01-05 11:20:22");
INSERT INTO tbl_expenses VALUES("99","EXP050123105","","50.00","2023-01-05 00:00:00","1","0","1","2023-01-05 11:32:46");
INSERT INTO tbl_expenses VALUES("100","EXP060123101","","60.00","2023-01-06 00:00:00","1","0","1","2023-01-06 01:21:06");
INSERT INTO tbl_expenses VALUES("101","EXP060123102","","200.00","2023-01-06 00:00:00","1","0","1","2023-01-06 08:22:07");
INSERT INTO tbl_expenses VALUES("102","EXP060123103","","500.00","2023-01-06 00:00:00","1","0","1","2023-01-06 10:10:57");
INSERT INTO tbl_expenses VALUES("105","EXP070123101","","30.00","2023-01-06 00:00:00","1","0","1","2023-01-07 11:23:26");
INSERT INTO tbl_expenses VALUES("106","EXP070123102","","200.00","2023-01-07 00:00:00","1","0","1","2023-01-07 12:03:50");
INSERT INTO tbl_expenses VALUES("107","EXP070123103","","500.00","2023-01-07 00:00:00","1","0","1","2023-01-07 06:08:56");
INSERT INTO tbl_expenses VALUES("108","EXP070123104","","300.00","2023-01-07 00:00:00","1","0","1","2023-01-07 08:24:04");
INSERT INTO tbl_expenses VALUES("109","EXP070123105","KALATHO VAI","8800.00","2023-01-07 00:00:00","1","0","1","2023-01-07 09:42:31");
INSERT INTO tbl_expenses VALUES("110","EXP080123101","","320.00","2023-01-08 00:00:00","1","0","1","2023-01-08 05:46:30");
INSERT INTO tbl_expenses VALUES("111","EXP080123102","","20.00","2023-01-08 00:00:00","1","0","1","2023-01-08 05:46:53");
INSERT INTO tbl_expenses VALUES("112","EXP080123103","","200.00","2023-01-08 00:00:00","1","0","1","2023-01-08 07:35:53");
INSERT INTO tbl_expenses VALUES("113","EXP080123104","","200.00","2023-01-08 00:00:00","1","0","1","2023-01-08 08:06:59");
INSERT INTO tbl_expenses VALUES("114","EXP080123105","","360.00","2023-01-08 00:00:00","1","0","1","2023-01-08 08:44:14");
INSERT INTO tbl_expenses VALUES("115","EXP090123101","","200.00","2023-01-09 00:00:00","1","0","1","2023-01-09 11:35:06");
INSERT INTO tbl_expenses VALUES("117","EXP090123103","","55.00","2023-01-09 00:00:00","1","0","1","2023-01-09 09:00:01");
INSERT INTO tbl_expenses VALUES("120","EXP100123101","","200.00","2023-01-10 00:00:00","1","0","1","2023-01-10 01:48:10");
INSERT INTO tbl_expenses VALUES("121","EXP100123102","","110.00","2023-01-10 00:00:00","1","0","1","2023-01-10 07:44:24");
INSERT INTO tbl_expenses VALUES("122","EXP100123103","","200.00","2023-01-10 00:00:00","1","0","1","2023-01-10 09:23:01");
INSERT INTO tbl_expenses VALUES("123","EXP100123104","","6800.00","2023-01-10 00:00:00","1","0","1","2023-01-10 10:00:33");
INSERT INTO tbl_expenses VALUES("124","EXP110123101","","140.00","2023-01-11 00:00:00","1","0","1","2023-01-11 07:17:13");
INSERT INTO tbl_expenses VALUES("125","EXP110123102","","1000.00","2023-01-11 00:00:00","1","0","1","2023-01-11 10:19:23");
INSERT INTO tbl_expenses VALUES("126","EXP110123103","","20.00","2023-01-11 00:00:00","1","0","1","2023-01-11 10:39:53");
INSERT INTO tbl_expenses VALUES("127","EXP120123101","","20.00","2023-01-12 00:00:00","1","0","1","2023-01-12 04:36:50");
INSERT INTO tbl_expenses VALUES("128","EXP120123102","","1000.00","2023-01-12 00:00:00","1","0","1","2023-01-12 05:00:13");
INSERT INTO tbl_expenses VALUES("129","EXP120123103","","200.00","2023-01-12 00:00:00","1","0","1","2023-01-12 08:10:27");
INSERT INTO tbl_expenses VALUES("130","EXP120123104","","20.00","2023-01-12 00:00:00","1","0","1","2023-01-12 08:11:09");
INSERT INTO tbl_expenses VALUES("131","EXP120123105","","2000.00","2023-01-12 00:00:00","1","0","1","2023-01-12 09:11:55");
INSERT INTO tbl_expenses VALUES("133","EXP120123107","","500.00","2023-01-12 00:00:00","1","0","1","2023-01-12 09:51:33");
INSERT INTO tbl_expenses VALUES("134","EXP120123108","","50.00","2023-01-12 00:00:00","1","0","1","2023-01-12 09:52:43");
INSERT INTO tbl_expenses VALUES("135","EXP120123109","","50.00","2023-01-12 00:00:00","1","0","1","2023-01-12 11:19:36");
INSERT INTO tbl_expenses VALUES("136","EXP130123101","","100.00","2023-01-13 00:00:00","1","0","1","2023-01-13 11:52:26");
INSERT INTO tbl_expenses VALUES("138","EXP130123103","","500.00","2023-01-13 00:00:00","1","0","1","2023-01-13 07:48:35");
INSERT INTO tbl_expenses VALUES("140","EXP130123105","","200.00","2023-01-13 00:00:00","1","0","1","2023-01-13 09:49:09");
INSERT INTO tbl_expenses VALUES("141","EXP130123106","","120.00","2023-01-13 00:00:00","1","0","1","2023-01-13 09:57:13");
INSERT INTO tbl_expenses VALUES("142","EXP140123101","","150.00","2023-01-14 00:00:00","1","0","1","2023-01-14 02:50:29");
INSERT INTO tbl_expenses VALUES("143","EXP140123102","","100.00","2023-01-14 00:00:00","1","0","1","2023-01-14 10:37:14");
INSERT INTO tbl_expenses VALUES("144","EXP140123103","","40.00","2023-01-14 00:00:00","1","0","1","2023-01-14 10:43:33");
INSERT INTO tbl_expenses VALUES("145","EXP150123101","","300.00","2023-01-15 00:00:00","1","0","1","2023-01-15 04:42:59");
INSERT INTO tbl_expenses VALUES("146","EXP150123102","","500.00","2023-01-15 00:00:00","1","0","1","2023-01-15 07:57:11");
INSERT INTO tbl_expenses VALUES("147","EXP150123103","","200.00","2023-01-15 00:00:00","1","0","1","2023-01-15 08:02:43");
INSERT INTO tbl_expenses VALUES("148","EXP150123104","","10.00","2023-01-15 00:00:00","1","0","1","2023-01-15 10:21:43");
INSERT INTO tbl_expenses VALUES("150","EXP160123101","","30.00","2023-01-16 00:00:00","1","0","1","2023-01-16 09:41:59");
INSERT INTO tbl_expenses VALUES("151","EXP170123101","","200.00","2023-01-17 00:00:00","1","0","1","2023-01-17 07:40:24");
INSERT INTO tbl_expenses VALUES("152","EXP170123102","","1600.00","2023-01-17 00:00:00","1","0","1","2023-01-17 08:41:52");
INSERT INTO tbl_expenses VALUES("153","EXP170123103","","270.00","2023-01-17 00:00:00","1","0","1","2023-01-17 08:42:24");
INSERT INTO tbl_expenses VALUES("154","EXP170123104","","20.00","2023-01-17 00:00:00","1","0","1","2023-01-17 10:01:09");
INSERT INTO tbl_expenses VALUES("155","EXP170123105","","200.00","2023-01-17 00:00:00","1","0","1","2023-01-17 10:42:17");
INSERT INTO tbl_expenses VALUES("158","EXP180123101","","830.00","2023-01-18 00:00:00","1","0","1","2023-01-18 06:04:22");
INSERT INTO tbl_expenses VALUES("159","EXP180123102","","300.00","2023-01-18 00:00:00","1","0","1","2023-01-18 09:19:14");
INSERT INTO tbl_expenses VALUES("160","EXP180123103","","20.00","2023-01-18 00:00:00","1","0","1","2023-01-18 10:27:07");
INSERT INTO tbl_expenses VALUES("161","EXP180123104","","10.00","2023-01-18 00:00:00","1","0","1","2023-01-18 10:27:54");
INSERT INTO tbl_expenses VALUES("162","EXP180123105","","3000.00","2023-01-18 00:00:00","1","0","1","2023-01-18 10:28:33");
INSERT INTO tbl_expenses VALUES("163","EXP190123101","","500.00","2023-01-19 00:00:00","1","0","1","2023-01-19 07:06:59");
INSERT INTO tbl_expenses VALUES("164","EXP190123102","","320.00","2023-01-19 00:00:00","1","0","1","2023-01-19 08:10:23");
INSERT INTO tbl_expenses VALUES("165","EXP190123103","","20.00","2023-01-19 00:00:00","1","0","1","2023-01-19 09:28:29");
INSERT INTO tbl_expenses VALUES("167","EXP200123101","","470.00","2023-01-20 00:00:00","1","0","1","2023-01-20 06:41:18");
INSERT INTO tbl_expenses VALUES("168","EXP200123102","","80.00","2023-01-20 00:00:00","1","0","1","2023-01-20 06:58:40");
INSERT INTO tbl_expenses VALUES("169","EXP200123103","","100.00","2023-01-20 00:00:00","1","0","1","2023-01-20 07:35:58");
INSERT INTO tbl_expenses VALUES("170","EXP200123104","","500.00","2023-01-20 00:00:00","1","0","1","2023-01-20 08:00:56");
INSERT INTO tbl_expenses VALUES("172","EXP200123106","","80.00","2023-01-20 00:00:00","1","0","1","2023-01-20 08:03:01");
INSERT INTO tbl_expenses VALUES("173","EXP210123101","","300.00","2023-01-21 00:00:00","1","0","1","2023-01-21 02:28:20");
INSERT INTO tbl_expenses VALUES("174","EXP210123102","","200.00","2023-01-21 00:00:00","1","0","1","2023-01-21 09:04:58");
INSERT INTO tbl_expenses VALUES("175","EXP210123103","","300.00","2023-01-21 00:00:00","1","0","1","2023-01-21 11:04:49");
INSERT INTO tbl_expenses VALUES("176","EXP220123101","","10.00","2023-01-22 00:00:00","1","0","1","2023-01-22 06:40:29");
INSERT INTO tbl_expenses VALUES("177","EXP220123102","","1000.00","2023-01-22 00:00:00","1","0","1","2023-01-22 10:13:21");
INSERT INTO tbl_expenses VALUES("178","EXP230123101","","300.00","2023-01-23 00:00:00","1","0","1","2023-01-23 04:22:27");
INSERT INTO tbl_expenses VALUES("179","EXP230123102","","1000.00","2023-01-23 00:00:00","1","0","1","2023-01-23 07:11:19");
INSERT INTO tbl_expenses VALUES("180","EXP230123103","","90.00","2023-01-23 00:00:00","1","0","1","2023-01-23 07:21:00");
INSERT INTO tbl_expenses VALUES("181","EXP240123101","","500.00","2023-01-24 00:00:00","1","0","1","2023-01-24 07:32:41");
INSERT INTO tbl_expenses VALUES("182","EXP250123101","","320.00","2023-01-25 00:00:00","1","0","1","2023-01-25 06:31:04");
INSERT INTO tbl_expenses VALUES("183","EXP250123102","","500.00","2023-01-25 00:00:00","1","0","1","2023-01-25 07:33:12");
INSERT INTO tbl_expenses VALUES("184","EXP250123103","","130.00","2023-01-25 00:00:00","1","0","1","2023-01-25 08:10:19");
INSERT INTO tbl_expenses VALUES("185","EXP250123104","","1100.00","2023-01-25 00:00:00","1","0","1","2023-01-25 08:53:25");
INSERT INTO tbl_expenses VALUES("186","EXP250123105","","18.00","2023-01-25 00:00:00","1","0","1","2023-01-25 09:09:58");
INSERT INTO tbl_expenses VALUES("187","EXP260123101","","50.00","2023-01-26 00:00:00","1","0","1","2023-01-26 06:55:45");
INSERT INTO tbl_expenses VALUES("188","EXP260123102","","370.00","2023-01-26 00:00:00","1","0","1","2023-01-26 06:56:46");
INSERT INTO tbl_expenses VALUES("189","EXP260123103","","500.00","2023-01-26 00:00:00","1","0","1","2023-01-26 08:22:45");
INSERT INTO tbl_expenses VALUES("190","EXP260123104","BUSINESS TAX DUE","2000.00","2023-01-19 00:00:00","1","0","1","2023-01-26 10:01:36");
INSERT INTO tbl_expenses VALUES("191","EXP270123101","","300.00","2023-01-27 00:00:00","1","0","1","2023-01-27 04:47:43");
INSERT INTO tbl_expenses VALUES("193","EXP270123103","","300.00","2023-01-27 00:00:00","1","0","1","2023-01-27 08:34:11");
INSERT INTO tbl_expenses VALUES("197","EXP270123104","","61.00","2023-01-27 00:00:00","1","0","1","2023-01-27 10:36:55");
INSERT INTO tbl_expenses VALUES("198","EXP280123101","","1000.00","2023-01-28 00:00:00","1","0","1","2023-01-28 07:36:31");
INSERT INTO tbl_expenses VALUES("199","EXP290123101","","1452.00","2023-01-29 00:00:00","1","0","1","2023-01-29 12:03:08");
INSERT INTO tbl_expenses VALUES("201","EXP290123102","","230.00","2023-01-29 00:00:00","1","0","1","2023-01-29 06:25:56");
INSERT INTO tbl_expenses VALUES("202","EXP290123103","","1000.00","2023-01-29 00:00:00","1","0","1","2023-01-29 09:53:56");
INSERT INTO tbl_expenses VALUES("204","EXP300123101","","460.00","2023-01-30 00:00:00","1","0","1","2023-01-30 08:11:31");
INSERT INTO tbl_expenses VALUES("206","EXP310123101","","430.00","2023-01-31 00:00:00","1","0","1","2023-01-31 12:09:39");
INSERT INTO tbl_expenses VALUES("207","EXP010223101","","30.00","2023-02-01 00:00:00","1","0","1","2023-02-01 05:33:46");
INSERT INTO tbl_expenses VALUES("208","EXP010223102","","50.00","2023-02-01 00:00:00","1","0","1","2023-02-01 09:37:57");
INSERT INTO tbl_expenses VALUES("209","EXP010223103","","200.00","2023-02-01 00:00:00","1","0","1","2023-02-01 11:27:06");
INSERT INTO tbl_expenses VALUES("210","EXP020223101","","20.00","2023-02-02 00:00:00","1","0","1","2023-02-02 12:18:14");
INSERT INTO tbl_expenses VALUES("212","EXP020223102","","1000.00","2023-02-02 00:00:00","1","0","1","2023-02-02 09:15:53");
INSERT INTO tbl_expenses VALUES("213","EXP020223103","","50.00","2023-02-02 00:00:00","1","0","1","2023-02-02 09:21:19");
INSERT INTO tbl_expenses VALUES("214","EXP020223104","","50.00","2023-02-02 00:00:00","1","0","1","2023-02-02 09:23:06");
INSERT INTO tbl_expenses VALUES("215","EXP020223105","","30.00","2023-02-02 00:00:00","1","0","1","2023-02-02 10:37:52");
INSERT INTO tbl_expenses VALUES("216","EXP020223106","","40.00","2023-02-02 00:00:00","1","0","1","2023-02-02 10:44:01");
INSERT INTO tbl_expenses VALUES("217","EXP030223101","","10.00","2023-02-03 00:00:00","1","0","1","2023-02-03 06:09:39");
INSERT INTO tbl_expenses VALUES("218","EXP030223102","","125.00","2023-02-03 00:00:00","1","0","1","2023-02-03 06:10:06");
INSERT INTO tbl_expenses VALUES("219","EXP030223103","","50.00","2023-02-03 00:00:00","1","0","1","2023-02-03 08:17:35");
INSERT INTO tbl_expenses VALUES("220","EXP030223104","","50.00","2023-02-03 00:00:00","1","0","1","2023-02-03 10:30:38");
INSERT INTO tbl_expenses VALUES("222","EXP040223102","","15.00","2023-02-04 00:00:00","1","0","1","2023-02-04 07:53:57");
INSERT INTO tbl_expenses VALUES("223","EXP040223103","","50.00","2023-02-04 00:00:00","1","0","1","2023-02-04 10:37:29");
INSERT INTO tbl_expenses VALUES("224","EXP050223101","","50.00","2023-02-05 00:00:00","1","0","1","2023-02-05 01:52:46");
INSERT INTO tbl_expenses VALUES("225","EXP050223102","","500.00","2023-02-05 00:00:00","1","0","1","2023-02-05 05:45:09");
INSERT INTO tbl_expenses VALUES("227","EXP050223104","","50.00","2023-02-05 00:00:00","1","0","1","2023-02-05 09:04:27");
INSERT INTO tbl_expenses VALUES("228","EXP050223105","","20.00","2023-02-05 00:00:00","1","0","1","2023-02-05 10:13:12");
INSERT INTO tbl_expenses VALUES("229","EXP060223101","","300.00","2023-02-06 00:00:00","1","0","1","2023-02-06 07:02:21");
INSERT INTO tbl_expenses VALUES("230","EXP060223102","","50.00","2023-02-06 00:00:00","1","0","1","2023-02-06 07:03:48");
INSERT INTO tbl_expenses VALUES("231","EXP060223103","","50.00","2023-02-06 00:00:00","1","0","1","2023-02-06 08:51:13");
INSERT INTO tbl_expenses VALUES("232","EXP060223104","","1000.00","2023-02-06 00:00:00","1","0","1","2023-02-06 11:23:02");
INSERT INTO tbl_expenses VALUES("233","EXP070223101","","5000.00","2023-02-07 00:00:00","1","0","1","2023-02-07 08:43:18");
INSERT INTO tbl_expenses VALUES("234","EXP070223102","","50.00","2023-02-07 00:00:00","1","0","1","2023-02-07 08:50:36");
INSERT INTO tbl_expenses VALUES("235","EXP070223103","","50.00","2023-02-07 00:00:00","1","0","1","2023-02-07 09:33:00");
INSERT INTO tbl_expenses VALUES("238","EXP070223104","","20.00","2023-02-07 00:00:00","1","0","1","2023-02-07 09:41:09");
INSERT INTO tbl_expenses VALUES("239","EXP080223101","","520.00","2023-02-08 00:00:00","1","0","1","2023-02-08 01:38:52");
INSERT INTO tbl_expenses VALUES("240","EXP080223102","","300.00","2023-02-08 00:00:00","1","0","1","2023-02-08 05:05:14");
INSERT INTO tbl_expenses VALUES("241","EXP080223103","","50.00","2023-02-08 00:00:00","1","0","1","2023-02-08 09:41:43");
INSERT INTO tbl_expenses VALUES("242","EXP080223104","","50.00","2023-02-08 00:00:00","1","0","1","2023-02-08 09:42:29");
INSERT INTO tbl_expenses VALUES("243","EXP090223101","","200.00","2023-02-09 00:00:00","1","0","1","2023-02-09 12:07:25");
INSERT INTO tbl_expenses VALUES("244","EXP090223102","","50.00","2023-02-09 00:00:00","1","0","1","2023-02-09 06:29:35");
INSERT INTO tbl_expenses VALUES("245","EXP090223103","","50.00","2023-02-09 00:00:00","1","0","1","2023-02-09 09:59:41");
INSERT INTO tbl_expenses VALUES("246","EXP100223101","","260.00","2023-02-10 00:00:00","1","0","1","2023-02-10 07:38:27");
INSERT INTO tbl_expenses VALUES("247","EXP100223102","","3800.00","2023-02-10 00:00:00","1","0","1","2023-02-10 07:47:42");
INSERT INTO tbl_expenses VALUES("248","EXP100223103","","50.00","2023-02-10 00:00:00","1","0","1","2023-02-10 08:38:26");
INSERT INTO tbl_expenses VALUES("249","EXP100223104","","50.00","2023-02-10 00:00:00","1","0","1","2023-02-10 09:35:59");
INSERT INTO tbl_expenses VALUES("252","EXP100223106","","100.00","2023-02-10 00:00:00","1","0","1","2023-02-10 10:02:46");
INSERT INTO tbl_expenses VALUES("253","EXP100223107","","145.00","2023-02-10 00:00:00","1","0","1","2023-02-10 10:05:23");
INSERT INTO tbl_expenses VALUES("254","EXP110223101","","50.00","2023-02-11 00:00:00","1","0","1","2023-02-11 02:00:30");
INSERT INTO tbl_expenses VALUES("255","EXP110223102","","50.00","2023-02-11 00:00:00","1","0","1","2023-02-11 10:24:27");
INSERT INTO tbl_expenses VALUES("258","EXP120223103","","50.00","2023-02-12 00:00:00","1","0","1","2023-02-12 08:04:32");
INSERT INTO tbl_expenses VALUES("259","EXP120223104","","3.00","2023-02-12 00:00:00","1","0","1","2023-02-12 10:44:03");
INSERT INTO tbl_expenses VALUES("260","EXP120223105","","50.00","2023-02-12 00:00:00","1","0","1","2023-02-12 10:46:28");
INSERT INTO tbl_expenses VALUES("261","EXP140223101","","300.00","2023-02-13 00:00:00","1","0","1","2023-02-14 04:47:44");
INSERT INTO tbl_expenses VALUES("262","EXP200223101","","50.00","2023-02-20 00:00:00","1","0","1","2023-02-20 10:58:56");
INSERT INTO tbl_expenses VALUES("263","EXP200223102","","50.00","2023-02-20 00:00:00","1","0","1","2023-02-20 11:00:03");
INSERT INTO tbl_expenses VALUES("264","EXP230323101","","500.00","2023-03-23 00:00:00","1","0","1","2023-03-23 07:45:07");



CREATE TABLE `tbl_expensesde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `expid` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=266 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_expensesde VALUES("3","0","2","44","1070.00","");
INSERT INTO tbl_expensesde VALUES("5","0","4","66","100.00","");
INSERT INTO tbl_expensesde VALUES("6","0","5","67","1650.00","");
INSERT INTO tbl_expensesde VALUES("7","0","6","69","5350.00","");
INSERT INTO tbl_expensesde VALUES("8","0","7","68","6000.00","");
INSERT INTO tbl_expensesde VALUES("9","0","8","16","11150.00","");
INSERT INTO tbl_expensesde VALUES("12","0","11","44","100.00","");
INSERT INTO tbl_expensesde VALUES("13","0","12","44","240.00","");
INSERT INTO tbl_expensesde VALUES("15","0","14","72","200.00","FITTING CHARGE");
INSERT INTO tbl_expensesde VALUES("16","0","15","73","1120.00","");
INSERT INTO tbl_expensesde VALUES("19","0","18","73","500.00","");
INSERT INTO tbl_expensesde VALUES("20","0","19","44","80.00","");
INSERT INTO tbl_expensesde VALUES("22","0","21","73","8500.00","");
INSERT INTO tbl_expensesde VALUES("28","0","27","73","800.00","");
INSERT INTO tbl_expensesde VALUES("29","0","28","44","400.00","");
INSERT INTO tbl_expensesde VALUES("30","0","29","73","500.00","SOPON VHI PARTY");
INSERT INTO tbl_expensesde VALUES("32","0","31","73","500.00","");
INSERT INTO tbl_expensesde VALUES("34","0","33","77","100.00","");
INSERT INTO tbl_expensesde VALUES("35","0","34","78","600.00","");
INSERT INTO tbl_expensesde VALUES("36","0","35","72","300.00","");
INSERT INTO tbl_expensesde VALUES("37","0","36","73","200.00","");
INSERT INTO tbl_expensesde VALUES("38","0","37","44","370.00","");
INSERT INTO tbl_expensesde VALUES("39","0","38","73","200.00","OWN PERSONAL");
INSERT INTO tbl_expensesde VALUES("44","0","43","73","300.00","");
INSERT INTO tbl_expensesde VALUES("46","0","45","44","580.00","");
INSERT INTO tbl_expensesde VALUES("54","0","53","77","20.00","");
INSERT INTO tbl_expensesde VALUES("55","0","54","78","200.00","");
INSERT INTO tbl_expensesde VALUES("57","0","56","73","500.00","");
INSERT INTO tbl_expensesde VALUES("62","0","61","73","50.00","LITON");
INSERT INTO tbl_expensesde VALUES("64","0","63","72","300.00","");
INSERT INTO tbl_expensesde VALUES("66","0","65","73","5000.00","RUBEL");
INSERT INTO tbl_expensesde VALUES("67","0","66","77","35.00","");
INSERT INTO tbl_expensesde VALUES("68","0","67","73","300.00","");
INSERT INTO tbl_expensesde VALUES("69","0","68","77","10.00","");
INSERT INTO tbl_expensesde VALUES("70","0","69","78","100.00","");
INSERT INTO tbl_expensesde VALUES("73","0","72","77","20.00","");
INSERT INTO tbl_expensesde VALUES("76","0","75","73","400.00","");
INSERT INTO tbl_expensesde VALUES("77","0","76","77","20.00","");
INSERT INTO tbl_expensesde VALUES("78","0","77","17","120.00","");
INSERT INTO tbl_expensesde VALUES("79","0","78","73","100.00","");
INSERT INTO tbl_expensesde VALUES("80","0","79","17","100.00","");
INSERT INTO tbl_expensesde VALUES("82","0","81","77","90.00","");
INSERT INTO tbl_expensesde VALUES("83","0","82","77","25.00","");
INSERT INTO tbl_expensesde VALUES("87","0","86","17","100.00","");
INSERT INTO tbl_expensesde VALUES("88","0","87","77","35.00","");
INSERT INTO tbl_expensesde VALUES("89","0","88","73","250.00","");
INSERT INTO tbl_expensesde VALUES("90","0","89","44","520.00","");
INSERT INTO tbl_expensesde VALUES("91","0","90","44","220.00","");
INSERT INTO tbl_expensesde VALUES("92","0","91","73","500.00","");
INSERT INTO tbl_expensesde VALUES("94","0","93","16","1600.00","");
INSERT INTO tbl_expensesde VALUES("95","0","94","73","200.00","");
INSERT INTO tbl_expensesde VALUES("96","0","95","73","100.00","");
INSERT INTO tbl_expensesde VALUES("97","0","96","44","690.00","");
INSERT INTO tbl_expensesde VALUES("98","0","97","44","640.00","");
INSERT INTO tbl_expensesde VALUES("99","0","98","73","500.00","");
INSERT INTO tbl_expensesde VALUES("100","0","99","44","50.00","");
INSERT INTO tbl_expensesde VALUES("101","0","100","77","60.00","");
INSERT INTO tbl_expensesde VALUES("102","0","101","78","200.00","");
INSERT INTO tbl_expensesde VALUES("103","0","102","73","500.00","");
INSERT INTO tbl_expensesde VALUES("106","0","105","77","30.00","");
INSERT INTO tbl_expensesde VALUES("107","0","106","73","200.00","");
INSERT INTO tbl_expensesde VALUES("108","0","107","73","500.00","");
INSERT INTO tbl_expensesde VALUES("109","0","108","72","300.00","");
INSERT INTO tbl_expensesde VALUES("110","0","109","80","8800.00","");
INSERT INTO tbl_expensesde VALUES("111","0","110","44","320.00","");
INSERT INTO tbl_expensesde VALUES("112","0","111","77","20.00","");
INSERT INTO tbl_expensesde VALUES("113","0","112","73","200.00","");
INSERT INTO tbl_expensesde VALUES("114","0","113","78","200.00","");
INSERT INTO tbl_expensesde VALUES("115","0","114","81","360.00","");
INSERT INTO tbl_expensesde VALUES("116","0","115","73","200.00","");
INSERT INTO tbl_expensesde VALUES("118","0","117","77","55.00","");
INSERT INTO tbl_expensesde VALUES("121","0","120","44","200.00","");
INSERT INTO tbl_expensesde VALUES("122","0","121","44","110.00","");
INSERT INTO tbl_expensesde VALUES("123","0","122","78","200.00","");
INSERT INTO tbl_expensesde VALUES("124","0","123","83","6800.00","");
INSERT INTO tbl_expensesde VALUES("125","0","124","44","140.00","");
INSERT INTO tbl_expensesde VALUES("126","0","125","73","1000.00","");
INSERT INTO tbl_expensesde VALUES("127","0","126","44","20.00","TUHIN VAI");
INSERT INTO tbl_expensesde VALUES("128","0","127","44","20.00","TUHIN VAI");
INSERT INTO tbl_expensesde VALUES("129","0","128","73","1000.00","");
INSERT INTO tbl_expensesde VALUES("130","0","129","78","200.00","");
INSERT INTO tbl_expensesde VALUES("131","0","130","44","20.00","");
INSERT INTO tbl_expensesde VALUES("132","0","131","84","2000.00","TUHIN VAI");
INSERT INTO tbl_expensesde VALUES("134","0","133","73","500.00","");
INSERT INTO tbl_expensesde VALUES("135","0","134","44","50.00","");
INSERT INTO tbl_expensesde VALUES("136","0","135","44","50.00","");
INSERT INTO tbl_expensesde VALUES("137","0","136","73","100.00","");
INSERT INTO tbl_expensesde VALUES("139","0","138","73","500.00","");
INSERT INTO tbl_expensesde VALUES("141","0","140","73","200.00","");
INSERT INTO tbl_expensesde VALUES("142","0","141","77","120.00","");
INSERT INTO tbl_expensesde VALUES("143","0","142","44","150.00","");
INSERT INTO tbl_expensesde VALUES("144","0","143","73","100.00","");
INSERT INTO tbl_expensesde VALUES("145","0","144","77","40.00","");
INSERT INTO tbl_expensesde VALUES("146","0","145","72","300.00","");
INSERT INTO tbl_expensesde VALUES("147","0","146","73","500.00","");
INSERT INTO tbl_expensesde VALUES("148","0","147","78","200.00","");
INSERT INTO tbl_expensesde VALUES("149","0","148","77","10.00","");
INSERT INTO tbl_expensesde VALUES("151","0","150","77","30.00","");
INSERT INTO tbl_expensesde VALUES("152","0","151","78","200.00","");
INSERT INTO tbl_expensesde VALUES("153","0","152","73","1600.00","");
INSERT INTO tbl_expensesde VALUES("154","0","153","44","270.00","");
INSERT INTO tbl_expensesde VALUES("155","0","154","77","20.00","");
INSERT INTO tbl_expensesde VALUES("156","0","155","73","200.00","");
INSERT INTO tbl_expensesde VALUES("159","0","158","44","830.00","");
INSERT INTO tbl_expensesde VALUES("160","0","159","78","300.00","");
INSERT INTO tbl_expensesde VALUES("161","0","160","17","20.00","MINHAZ ");
INSERT INTO tbl_expensesde VALUES("162","0","161","77","10.00","");
INSERT INTO tbl_expensesde VALUES("163","0","162","26","3000.00","");
INSERT INTO tbl_expensesde VALUES("164","0","163","73","500.00","");
INSERT INTO tbl_expensesde VALUES("165","0","164","44","320.00","");
INSERT INTO tbl_expensesde VALUES("166","0","165","44","20.00","");
INSERT INTO tbl_expensesde VALUES("168","0","167","44","470.00","");
INSERT INTO tbl_expensesde VALUES("169","0","168","77","80.00","");
INSERT INTO tbl_expensesde VALUES("170","0","169","66","100.00","");
INSERT INTO tbl_expensesde VALUES("171","0","170","73","500.00","");
INSERT INTO tbl_expensesde VALUES("173","0","172","44","80.00","");
INSERT INTO tbl_expensesde VALUES("174","0","173","72","300.00","");
INSERT INTO tbl_expensesde VALUES("175","0","174","78","200.00","");
INSERT INTO tbl_expensesde VALUES("176","0","175","73","300.00","");
INSERT INTO tbl_expensesde VALUES("177","0","176","77","10.00","");
INSERT INTO tbl_expensesde VALUES("178","0","177","73","1000.00","");
INSERT INTO tbl_expensesde VALUES("179","0","178","72","300.00","");
INSERT INTO tbl_expensesde VALUES("180","0","179","73","1000.00","");
INSERT INTO tbl_expensesde VALUES("181","0","180","77","90.00","");
INSERT INTO tbl_expensesde VALUES("182","0","181","73","500.00","");
INSERT INTO tbl_expensesde VALUES("183","0","182","44","320.00","");
INSERT INTO tbl_expensesde VALUES("184","0","183","73","500.00","");
INSERT INTO tbl_expensesde VALUES("185","0","184","44","130.00","");
INSERT INTO tbl_expensesde VALUES("186","0","185","73","1100.00","");
INSERT INTO tbl_expensesde VALUES("187","0","186","77","18.00","");
INSERT INTO tbl_expensesde VALUES("188","0","187","77","50.00","");
INSERT INTO tbl_expensesde VALUES("189","0","188","44","370.00","");
INSERT INTO tbl_expensesde VALUES("190","0","189","73","500.00","");
INSERT INTO tbl_expensesde VALUES("191","0","190","26","2000.00","");
INSERT INTO tbl_expensesde VALUES("192","0","191","72","300.00","");
INSERT INTO tbl_expensesde VALUES("194","0","193","72","300.00","");
INSERT INTO tbl_expensesde VALUES("198","0","197","73","61.00","");
INSERT INTO tbl_expensesde VALUES("199","0","198","73","1000.00","");
INSERT INTO tbl_expensesde VALUES("200","0","199","16","1452.00","");
INSERT INTO tbl_expensesde VALUES("202","0","201","44","230.00","");
INSERT INTO tbl_expensesde VALUES("203","0","202","73","1000.00","");
INSERT INTO tbl_expensesde VALUES("205","0","204","44","460.00","");
INSERT INTO tbl_expensesde VALUES("207","0","206","44","430.00","");
INSERT INTO tbl_expensesde VALUES("208","0","207","20","30.00","");
INSERT INTO tbl_expensesde VALUES("209","0","208","85","50.00","");
INSERT INTO tbl_expensesde VALUES("210","0","209","73","200.00","");
INSERT INTO tbl_expensesde VALUES("211","0","210","44","20.00","");
INSERT INTO tbl_expensesde VALUES("213","0","212","81","1000.00","");
INSERT INTO tbl_expensesde VALUES("214","0","213","86","50.00","");
INSERT INTO tbl_expensesde VALUES("215","0","214","85","50.00","");
INSERT INTO tbl_expensesde VALUES("216","0","215","73","30.00","");
INSERT INTO tbl_expensesde VALUES("217","0","216","73","40.00","");
INSERT INTO tbl_expensesde VALUES("218","0","217","44","10.00","");
INSERT INTO tbl_expensesde VALUES("219","0","218","77","125.00","");
INSERT INTO tbl_expensesde VALUES("220","0","219","85","50.00","");
INSERT INTO tbl_expensesde VALUES("221","0","220","86","50.00","");
INSERT INTO tbl_expensesde VALUES("223","0","222","77","15.00","");
INSERT INTO tbl_expensesde VALUES("224","0","223","86","50.00","");
INSERT INTO tbl_expensesde VALUES("225","0","224","86","50.00","");
INSERT INTO tbl_expensesde VALUES("226","0","225","73","500.00","");
INSERT INTO tbl_expensesde VALUES("228","0","227","85","50.00","");
INSERT INTO tbl_expensesde VALUES("229","0","228","77","20.00","");
INSERT INTO tbl_expensesde VALUES("230","0","229","44","300.00","");
INSERT INTO tbl_expensesde VALUES("231","0","230","85","50.00","");
INSERT INTO tbl_expensesde VALUES("232","0","231","86","50.00","");
INSERT INTO tbl_expensesde VALUES("233","0","232","17","1000.00","");
INSERT INTO tbl_expensesde VALUES("234","0","233","83","5000.00","");
INSERT INTO tbl_expensesde VALUES("235","0","234","85","50.00","");
INSERT INTO tbl_expensesde VALUES("236","0","235","86","50.00","");
INSERT INTO tbl_expensesde VALUES("239","0","238","77","20.00","");
INSERT INTO tbl_expensesde VALUES("240","0","239","44","520.00","");
INSERT INTO tbl_expensesde VALUES("241","0","240","72","300.00","");
INSERT INTO tbl_expensesde VALUES("242","0","241","85","50.00","");
INSERT INTO tbl_expensesde VALUES("243","0","242","86","50.00","");
INSERT INTO tbl_expensesde VALUES("244","0","243","73","200.00","");
INSERT INTO tbl_expensesde VALUES("245","0","244","85","50.00","");
INSERT INTO tbl_expensesde VALUES("246","0","245","86","50.00","");
INSERT INTO tbl_expensesde VALUES("247","0","246","44","260.00","");
INSERT INTO tbl_expensesde VALUES("248","0","247","83","3800.00","");
INSERT INTO tbl_expensesde VALUES("249","0","248","85","50.00","");
INSERT INTO tbl_expensesde VALUES("250","0","249","86","50.00","");
INSERT INTO tbl_expensesde VALUES("253","0","252","73","100.00","");
INSERT INTO tbl_expensesde VALUES("254","0","253","77","145.00","");
INSERT INTO tbl_expensesde VALUES("255","0","254","17","50.00","");
INSERT INTO tbl_expensesde VALUES("256","0","255","86","50.00","");
INSERT INTO tbl_expensesde VALUES("259","0","258","85","50.00","");
INSERT INTO tbl_expensesde VALUES("260","0","259","77","3.00","");
INSERT INTO tbl_expensesde VALUES("261","0","260","85","50.00","");
INSERT INTO tbl_expensesde VALUES("262","0","261","72","300.00","cash");
INSERT INTO tbl_expensesde VALUES("263","0","262","85","50.00","");
INSERT INTO tbl_expensesde VALUES("264","0","263","86","50.00","");
INSERT INTO tbl_expensesde VALUES("265","0","264","78","500.00","CASH");



CREATE TABLE `tbl_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(15) NOT NULL,
  `name` varchar(65) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `prid` int(11) DEFAULT NULL,
  `catid` int(11) DEFAULT NULL,
  `scatid` int(11) DEFAULT NULL,
  `brid` int(11) DEFAULT NULL,
  `manid` int(11) DEFAULT NULL,
  `unid` int(11) DEFAULT NULL,
  `couid` int(11) DEFAULT NULL,
  `minstock` double NOT NULL DEFAULT 0,
  `cqty` int(11) DEFAULT NULL,
  `barcode` varchar(25) DEFAULT NULL,
  `certificate` varchar(150) DEFAULT NULL,
  `modelno` varchar(25) DEFAULT NULL,
  `brandno` varchar(25) DEFAULT NULL,
  `image` varchar(50) DEFAULT NULL,
  `cost` decimal(12,2) NOT NULL DEFAULT 0.00,
  `price` decimal(12,2) NOT NULL DEFAULT 0.00,
  `wday` double NOT NULL DEFAULT 0,
  `pmod` int(11) NOT NULL,
  `status` int(1) NOT NULL DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=972 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_item VALUES("10","ABA001P","ROUTER NETIS WF2409E ","NETIS - 2409","","","11","","","","1","","5","","","","","","7f6645ad93864fb1bbb04b5daed4eb58_1669545311.jpg","1287.00","0.00","365","2","1","1","2022-11-27 04:34:11");
INSERT INTO tbl_item VALUES("11","ABA002P","ROUTER  NETIS WF2419E","NETIS WF2419E","","","11","","","","1","","5","","","","","","47df4f8fc35b11d475d7250da51f84e5_1669545537.jpg","0.00","0.00","365","2","1","1","2022-11-27 04:38:57");
INSERT INTO tbl_item VALUES("13","ABA003P","ROUTER NETIS W4","NETIS W4","","","11","","","","1","","0","","","","","","Screenshot_1_1669546187.png","0.00","0.00","365","2","1","1","2022-11-27 04:43:08");
INSERT INTO tbl_item VALUES("15","ABA005P","ROUTER  TP-LINK WR820N","TP-LINK WR820N","","","11","","","","1","","5","","","","","","820_1669553671.jpg","0.00","0.00","365","1","1","1","2022-11-27 05:59:08");
INSERT INTO tbl_item VALUES("16","ABA006P","ROUTER  TP-LINK WR840N","TP-LINK WR840N","","","11","","","","1","","0","","","","","","th_1669550588.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:02:17");
INSERT INTO tbl_item VALUES("17","ABA007P","ROUTER  TP-LINK WR841N","TP-LINK WR841N","","","11","","","","1","","5","","","","","","hh_1669550699.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:04:59");
INSERT INTO tbl_item VALUES("18","ABA008P","ROUTER  TP-LINK WR845N","TP-LINK WR845N","","","11","","","","1","","5","","","","","","kk_1669550793.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:06:33");
INSERT INTO tbl_item VALUES("19","ABA009P","ROUTER  TP-LINK C20","TP-LINK C20","","","11","","","","1","","5","","","","","","GG_1669550915.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:08:35");
INSERT INTO tbl_item VALUES("20","ABA010P","ROUTER  TP-LINK C60","TP-LINK C60","","","11","","","","1","","5","","","","","","KLK_1669551118.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:11:58");
INSERT INTO tbl_item VALUES("21","ABA011P","ROUTER  TP-LINK C6","TP-LINK C6","","","11","","","","1","","5","","","","","","GGH_1669551401.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:16:41");
INSERT INTO tbl_item VALUES("22","ABA012P","ROUTER  TP-LINK C24","TP-LINK C24","","","11","","","","1","","0","","","","","","24_1669551498.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:18:18");
INSERT INTO tbl_item VALUES("23","ABA013P","ROUTER  TENDA N301","TENDA N301","","","11","","","","1","","5","","","","","","301N_1669551937.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:25:37");
INSERT INTO tbl_item VALUES("24","ABA014P","ROUTER  TENDA F3","TENDA F3","","","11","","","","1","","0","","","","","","F3_1669551989.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:26:29");
INSERT INTO tbl_item VALUES("25","ABA015P","ROUTER  TENDA F6","TENDA F6","","","11","","","","1","","0","","","","","","F6_1669552069.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:27:49");
INSERT INTO tbl_item VALUES("26","ABA016P","ROUTER  TENDA F9","TENDA F9","","","11","","","","1","","0","","","","","","F9_1669552124.jpg","0.00","0.00","365","0","1","1","2022-11-27 06:28:44");
INSERT INTO tbl_item VALUES("27","ABA017P","ROUTER  TENDA AC5","TENDA AC5","","","11","","","2","1","1","5","","","","","","AC5_1669553937.jpg","0.00","0.00","365","2","1","1","2022-11-27 06:58:57");
INSERT INTO tbl_item VALUES("28","ABA018P","ROUTER  TENDA AC10","TENDA AC10","","","11","","","","1","","5","","","","","","AC10_1669554089.jpg","0.00","0.00","365","0","1","1","2022-11-27 07:01:29");
INSERT INTO tbl_item VALUES("29","ABA019P","ROUTER  TENDA AC7","TENDA AC7","","","11","","","","1","","5","","","","","","AC7_1669554348.jpg","0.00","0.00","365","1","1","1","2022-11-27 07:05:48");
INSERT INTO tbl_item VALUES("30","ABA020P","ROUTER  MT-LINK WR950N","MT-LINK WR950N","","","11","","","","1","","0","","","","","","950_1669554560.jpg","0.00","0.00","365","2","1","1","2022-11-27 07:09:20");
INSERT INTO tbl_item VALUES("31","ABA021P","ROUTER  MT-LINK WR850N","MT-LINK WR850N","","","11","","","","1","","5","","","","","","850_1669554916.png","0.00","0.00","365","1","1","1","2022-11-27 07:15:16");
INSERT INTO tbl_item VALUES("32","ABA022P","ROUTER  WALTON TORONGO","WALTON TORONGO","","","11","","","","1","","5","","","","","","TORONGO_1669555420.jpg","0.00","0.00","365","0","1","1","2022-11-27 07:23:40");
INSERT INTO tbl_item VALUES("33","ABA023P","ROUTER  MERCUSYS MW305R","MERCUSYS MW305R","","","11","","","","1","","5","","","","","","305_1669555756.jpg","0.00","0.00","365","0","1","1","2022-11-27 07:29:16");
INSERT INTO tbl_item VALUES("34","ABA024P","ROUTER  TP-LINK DECO M5","TP-LINK DECO M5","","","11","","","","1","","0","","","","","","M5_1669555818.jpg","0.00","0.00","365","1","1","1","2022-11-27 07:30:18");
INSERT INTO tbl_item VALUES("35","ABA025P","ROUTER  XIAOMI MI 4C ","XIAOMI MI 4C ","","","11","","","","1","","0","","","","","","4C_1669556025.jpg","0.00","0.00","365","1","1","1","2022-11-27 07:33:45");
INSERT INTO tbl_item VALUES("36","ABA026P","ONU  ZIBBIX - XPON","ZIBBIX - XPON","","","12","","","","1","","20","","","","","","Screenshot_4_1669564316.png","900.00","0.00","0","2","1","1","2022-11-27 07:46:20");
INSERT INTO tbl_item VALUES("37","ABA027P","ONU  BT PON - EPON","BT PON - EPON","","","12","","","","1","","5","","","","","","fitted_1669563849.jpg","0.00","0.00","365","2","1","1","2022-11-27 07:48:40");
INSERT INTO tbl_item VALUES("38","ABA028P","ONU  ONECONNECT ","ONECONNECT ","","","12","","","","1","","0","","","","","","ONECONNECT_1669557159.jpg","0.00","0.00","365","0","1","1","2022-11-27 07:52:39");
INSERT INTO tbl_item VALUES("39","ABA029P","DBC ONU XPON 10by100","DBC 2-PORT","","","12","","","","1","","10","","","","","","Screenshot_3_1669564134.png","0.00","0.00","0","0","1","1","2022-11-27 07:58:13");
INSERT INTO tbl_item VALUES("40","ABA030P","ONU  HUAWEI GPON","HUAWEI GPON","","","12","","","","1","","10","","","","","","Screenshot_2_1669558757.png","0.00","0.00","365","2","1","1","2022-11-27 08:01:43");
INSERT INTO tbl_item VALUES("41","ABA031P","ONU HUAWEI 4 PORT","HUAWEI GPON 4 PORT","","","12","","","","1","","0","","","","","","4PORT_1669558057.jpg","0.00","0.00","365","2","1","1","2022-11-27 08:07:37");
INSERT INTO tbl_item VALUES("42","ABA032P","ONU HUAWEI 1-PORT","HUAWEI GPON 1-PORT","","","12","","","","1","","10","","","","","","Screenshot_2_1669558690.png","0.00","0.00","365","0","1","1","2022-11-27 08:10:25");
INSERT INTO tbl_item VALUES("43","ABA033P","ONU HANDY 2-PORT","HUAWEI GPON 2-PORT","","","12","","","","1","","10","","","","","","images_1669558464.jfif","0.00","0.00","365","0","1","1","2022-11-27 08:14:24");
INSERT INTO tbl_item VALUES("44","ABA034P","ONU  GL-COM","GL-COM","","","12","","","","1","","10","","","","","","GL_1669559390.jpg","0.00","0.00","365","0","1","1","2022-11-27 08:29:50");
INSERT INTO tbl_item VALUES("45","ABA035P","NETWORK SWITCH  TP-LINK 5 PORT ","TP-LINK 5 PORT ","","","13","","","","1","","10","","","","","","5_1669559669.jpg","0.00","0.00","365","0","1","1","2022-11-27 08:34:28");
INSERT INTO tbl_item VALUES("46","ABA036P","NETWORK SWITCH  TP-LINK 8 PORT","TP-LINK 8 PORT","","","13","","","","1","","10","","","","","","8_1669559734.jpg","0.00","0.00","365","2","1","1","2022-11-27 08:35:34");
INSERT INTO tbl_item VALUES("47","ABA037P","NETWORK SWITCH  TENDA 5 PORT","TENDA 5 PORT","","","13","","","","1","","10","","","","","","55_1669560168.jpg","0.00","0.00","365","1","1","1","2022-11-27 08:42:48");
INSERT INTO tbl_item VALUES("48","ABA038P","NETWORK SWITCH  TENDA 8 PORT","TENDA 8 PORT","","","13","","","","1","","10","","","","","","88_1669563230.jpg","0.00","0.00","365","2","1","1","2022-11-27 08:43:36");
INSERT INTO tbl_item VALUES("49","ABA039P","   NETWORK SWITCH  NETIS 5 PORT","NETIS 5 PORT","","","13","","","","1","","10","","","","","","555_1669560341.jpg","0.00","0.00","365","1","1","1","2022-11-27 08:45:41");
INSERT INTO tbl_item VALUES("50","ABA040P","   NETWORK SWITCH  NETIS 8 PORT","NETIS 8 PORT","","","13","","","","1","","10","","","","","","888_1669560403.jpg","0.00","0.00","365","0","1","1","2022-11-27 08:46:43");
INSERT INTO tbl_item VALUES("51","ABA041P","   NETWORK SWITCH  TP-LINK GIGABIT 5 PORT","TP-LINK GIGABIT 5 PORT","","","13","","","","1","","10","","","","","","GIG_1669560653.jpg","0.00","0.00","365","1","1","1","2022-11-27 08:50:53");
INSERT INTO tbl_item VALUES("52","ABA042P","NETWORK SWITCH  TP-LINK GIGABIT 8 PORT","TP-LINK GIGABIT 8 PORT","","","13","","","","1","","0","","","","","","GIG 8_1669560743.jpg","0.00","0.00","365","1","1","1","2022-11-27 08:52:23");
INSERT INTO tbl_item VALUES("53","ABA043P","   CAT  D-LINK CAT-5","D-LINK CAT-5","","","14","","","","4","","5","","","","","","D-Link_Cat-5_1669562500.jpg","0.00","0.00","0","0","1","1","2022-11-27 09:21:40");
INSERT INTO tbl_item VALUES("54","ABA044P","   CAT  D-LINK CAT-6","D-LINK CAT-6","","","14","","","","4","","5","","","","","","D-Link_Cat-5_1669562578.jpg","0.00","0.00","0","0","1","1","2022-11-27 09:22:58");
INSERT INTO tbl_item VALUES("56","ABA045P","   CAT  ADP CAT-5","ADP CAT-5","","","14","","","","4","","5","","","","","","66_1669562877.jpg","0.00","0.00","0","0","1","1","2022-11-27 09:27:57");
INSERT INTO tbl_item VALUES("57","ABA046P","   CAT  ADP CAT-6","ADP CAT-6","","","14","","","","4","","5","","","","","","66_1669563461.jpg","0.00","0.00","0","0","1","1","2022-11-27 09:37:41");
INSERT INTO tbl_item VALUES("58","ABA047P","CAT  RED DRAGON CAT-6 TAMA ","RED DRAGON CAT-5","","","14","","","","4","","5","","","","","","android-chrome-512x512_1704026798.png","0.00","0.00","0","0","1","1","2022-11-27 09:40:46");
INSERT INTO tbl_item VALUES("59","ABA048P","RED DRAGON INDOOR FULL CAT-6","RED DRAGON CAT-6","","","14","","","","4","","0","","","","","","images (6)_1701353440.jpg","0.00","0.00","0","0","1","1","2022-11-27 09:41:28");
INSERT INTO tbl_item VALUES("60","ABA049P","   CAT  CIRCLE CAT-6","CIRCLE CAT-6","","","14","","","","4","","5","","","","","","Screenshot_5_1669611794.png","0.00","0.00","0","0","1","1","2022-11-28 11:03:14");
INSERT INTO tbl_item VALUES("61","ABA050P","   CAT  CIRCLE CAT-5","CIRCLE CAT-5","","","14","","","","4","","5","","","","","","Screenshot_5_1669611888.png","0.00","0.00","0","0","1","1","2022-11-28 11:04:48");
INSERT INTO tbl_item VALUES("62","ABA051P","   CAT  RED DRAGON FULL CAT-5","RED DRAGON FULL CAT-5","","","14","","","","4","","0","","","","","","5555_1669612048.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:07:28");
INSERT INTO tbl_item VALUES("63","ABA052P","CAT  RED DRAGON OUTDOOR FULL CAT-6","RED DRAGON FULL CAT-6","","","14","","","","4","","0","","","","","","6666_1669612100.png","0.00","0.00","0","0","1","1","2022-11-28 11:08:20");
INSERT INTO tbl_item VALUES("65","ABA054P","   CAT  RED DRAGON OUTDOOR FULL CAT-6","RED DRAGON OUTDOOR FULL CAT-6","","","14","","","","4","","5","","","","","","6666_1669612314.png","0.00","0.00","0","0","1","1","2022-11-28 11:11:54");
INSERT INTO tbl_item VALUES("66","ABA055P","   CAT  D-LINK OUTDOOR FULL CAT-5","D-LINK OUTDOOR FULL CAT-5","","","14","","","","4","","5","","","","","","D-Link_Cat-5_1669612525.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:15:25");
INSERT INTO tbl_item VALUES("67","ABA056P","   CAT  D-LINK OUTDOOR FULL CAT-6","D-LINK OUTDOOR FULL CAT-6","","","14","","","","4","","5","","","","","","D-Link_Cat-5_1669612618.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:16:58");
INSERT INTO tbl_item VALUES("68","ABA057P","   CAT  AD-LINK OUTDOOR CAT-6","AD-LINK OUTDOOR CAT-6","","","14","","","","4","","0","","","","","","ADD_1669612786.jfif","0.00","0.00","0","0","1","1","2022-11-28 11:19:46");
INSERT INTO tbl_item VALUES("69","ABA058P","   CAT  AD-LINK OUTDOOR CAT-5","AD-LINK OUTDOOR CAT-5","","","14","","","","4","","5","","","","","","ADDD_1669612916.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:21:55");
INSERT INTO tbl_item VALUES("70","ABA059P","   CAT  ADP OUTDOOR CAT-6","ADP OUTDOOR CAT-6","","","14","","","","4","","0","","","","","","OUT_1669613232.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:27:12");
INSERT INTO tbl_item VALUES("71","ABA060P","CAT  ADP OUTDOOR CAT-5","ADP OUTDOOR CAT-5","","","14","","","","14","","5","","","","","","Screenshot_176_1671947434.png","0.00","0.00","0","0","1","1","2022-11-28 11:28:21");
INSERT INTO tbl_item VALUES("72","ABA061P","FIBER CABLE  BIZLI - 2F","BIZLI CABLE - 2F","","","16","","","","4","","5","","","","","","BIZLI_1669613613.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:33:33");
INSERT INTO tbl_item VALUES("73","ABA062P","   FIBER CABLE   BIZLI - 4F","BIZLI - 4F","","","16","","","","4","","0","","","","","","4F_1669613812.png","0.00","0.00","0","0","1","1","2022-11-28 11:36:52");
INSERT INTO tbl_item VALUES("74","ABA063P","FIBER CABLE BIZLI - 6F","BIZLI - 6F","","","16","","","","4","","5","","","","","","Screenshot_6_1669614015.png","0.00","0.00","0","0","1","1","2022-11-28 11:40:15");
INSERT INTO tbl_item VALUES("75","ABA064P","   FIBER CABLE   BIZLI - 12F","BIZLI - 12F","","","16","","","","4","","5","","","","","","12F_1669614133.jpg","0.00","0.00","0","0","1","1","2022-11-28 11:42:13");
INSERT INTO tbl_item VALUES("76","ABA065P","   FIBER CABLE   BRB - 2F","BRB - 2F","","","16","","","","4","","5","","","","","","OUTT_1669617411.jpg","0.00","0.00","0","0","1","1","2022-11-28 12:36:51");
INSERT INTO tbl_item VALUES("77","ABA066P","   FIBER CABLE   BRB - 4F","BRB - 4F","","","16","","","","4","","5","","","","","","4F_1669617473.png","0.00","0.00","0","0","1","1","2022-11-28 12:37:53");
INSERT INTO tbl_item VALUES("78","ABA067P","   FIBER CABLE   BRB - 6F","BRB - 6F","","","16","","","","4","","0","","","","","","OUTT_1669617587.jpg","0.00","0.00","0","0","1","1","2022-11-28 12:39:47");
INSERT INTO tbl_item VALUES("79","ABA068P","   FIBER CABLE   BRB - 12F","BRB - 12F","","","16","","","","4","","5","","","","","","12F_1669617707.jpg","0.00","0.00","0","0","1","1","2022-11-28 12:41:47");
INSERT INTO tbl_item VALUES("80","ABA069P","   FIBER CABLE   LEADER - 2F","LEADER - 2F","","","16","","","","4","","5","","","","","","4F_1669618372.png","0.00","0.00","0","0","1","1","2022-11-28 12:52:52");
INSERT INTO tbl_item VALUES("81","ABA070P","   FIBER CABLE   LEADER - 4F","LEADER - 4F","","","16","","","","4","","5","","","","","","BIZLI_1669618423.jpg","0.00","0.00","0","0","1","1","2022-11-28 12:53:43");
INSERT INTO tbl_item VALUES("82","ABA071P","   FIBER CABLE   LEADER - 6F","LEADER - 6F","","","16","","","","4","","5","","","","","","4F_1669618463.png","0.00","0.00","0","0","1","1","2022-11-28 12:54:23");
INSERT INTO tbl_item VALUES("83","ABA072P","   FIBER CABLE   LEADER - 12F","LEADER - 12F","","","16","","","","4","","5","","","","","","12F_1669618494.jpg","0.00","0.00","0","0","1","1","2022-11-28 12:54:54");
INSERT INTO tbl_item VALUES("84","ABA073P","   FIBER CABLE   FIBER SOLUTION - 2F","FIBER SOLUTION - 2F","","","16","","","","4","","5","","","","","","12F_1669618692.jpg","0.00","0.00","0","0","1","1","2022-11-28 12:58:12");
INSERT INTO tbl_item VALUES("87","ABA074P","   FIBER CABLE   FIVER SOLUTION - 4F","FIVER SOLUTION - 4F","","","16","","","","4","","5","","","","","","FB_1669619013.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:03:33");
INSERT INTO tbl_item VALUES("88","ABA075P","   FIBER CABLE   USHA MARTIN - 2F","USHA MARTIN - 2F","","","16","","","","4","","5","","","","","","US_1669619259.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:07:39");
INSERT INTO tbl_item VALUES("89","ABA076P","   FIBER CABLE   USHA MARTIN - 4F","USHA MARTIN - 4F","","","16","","","","4","","5","","","","","","USA_1669619294.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:08:14");
INSERT INTO tbl_item VALUES("90","ABA077P","   FIBER CABLE   POLY - 2F","POLY - 2F","","","16","","","","4","","5","","","","","","FB_1669619383.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:09:42");
INSERT INTO tbl_item VALUES("91","ABA078P","   FIBER CABLE   POLY - 4F","POLY - 4F","","","16","","","","4","","5","","","","","","USA_1669619429.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:10:29");
INSERT INTO tbl_item VALUES("92","ABA079P","   FIBER CABLE   USING - 4F","USING - 4F","","","16","","","","4","","5","","","","","","US_1669619614.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:13:34");
INSERT INTO tbl_item VALUES("93","ABA080P","FIBER CABLE USING - 6F","USING - 6F","","","16","","","","4","","5","","","","","","US_1669641832.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:17:23");
INSERT INTO tbl_item VALUES("94","ABA081P","   FIBER CABLE   USING - 12F","USING - 12F","","","16","","","","4","","5","","","","","","USA_1669619961.jpg","0.00","0.00","0","0","1","1","2022-11-28 01:19:21");
INSERT INTO tbl_item VALUES("95","ABA082P","NODE  HYBRID -12bBm","HYBRID -12bBm","","","15","","","","24","","10","","","","","","Screenshot_7_1669620863.png","0.00","0.00","0","0","1","1","2022-11-28 01:34:23");
INSERT INTO tbl_item VALUES("96","ABA083P","NODE  HYBRID -16bBm","HYBRID -16bBm","","","15","","","","24","","5","","","","","","Screenshot_8_1669620940.png","0.00","0.00","0","0","1","1","2022-11-28 01:35:40");
INSERT INTO tbl_item VALUES("97","ABA084P","NODE  ALTIS -12dBm","ALTIS -12dBm","","","15","","","","24","","5","","","","","","Screenshot_9_1669621176.png","0.00","0.00","0","0","1","1","2022-11-28 01:39:36");
INSERT INTO tbl_item VALUES("98","ABA085P","NODE  ALTIS -16dBm","ALTIS -16dBm","","","15","","","","24","","5","","","","","","Screenshot_9_1669621291.png","0.00","0.00","0","0","1","1","2022-11-28 01:41:31");
INSERT INTO tbl_item VALUES("101","ABA088P","PLC SPLITTER - 1*2","PLC SPLITTER - 1x2","","","17","","","","1","","10","","","","","","PLC_1669626877.png","0.00","0.00","0","0","1","1","2022-11-28 03:09:09");
INSERT INTO tbl_item VALUES("102","ABA089P","PLC  SPLITTER - 1*4","SPLITTER - 1x4","","","17","","","","1","","10","","","","","","PLC_1669626946.png","0.00","0.00","0","0","1","1","2022-11-28 03:15:46");
INSERT INTO tbl_item VALUES("103","ABA090P","PLC  SPLITTER - 1*8","SPLITTER - 1x8","","","17","","","","1","","10","","","","","","PLC_1669626987.png","0.00","0.00","0","0","1","1","2022-11-28 03:16:27");
INSERT INTO tbl_item VALUES("104","ABA091P","PLC  SPLITTER - 1*16","SPLITTER - 1x16","","","17","","","","1","","10","","","","","","PLC_1669627017.png","0.00","0.00","0","0","1","1","2022-11-28 03:16:57");
INSERT INTO tbl_item VALUES("105","ABA092P","   PLC  SPLITTER - 10/90","SPLITTER - 10/90","","","17","","","","1","","10","","","","","","PLC_1669627106.png","0.00","0.00","0","0","1","1","2022-11-28 03:18:26");
INSERT INTO tbl_item VALUES("106","ABA093P","   PLC  SPLITTER - 5/95","SPLITTER - 5/95","","","17","","","","1","","0","","","","","","PLC_1669627138.png","0.00","0.00","0","0","1","1","2022-11-28 03:18:58");
INSERT INTO tbl_item VALUES("107","ABA094P","   PLC  SPLITTER - 15/85","SPLITTER - 15/85","","","17","","","","1","","0","","","","","","PLC_1669627165.png","0.00","0.00","0","0","1","1","2022-11-28 03:19:25");
INSERT INTO tbl_item VALUES("108","ABA095P","   PLC  SPLITTER - 20/80","SPLITTER - 20/80","","","17","","","","1","","10","","","","","","PLC_1669627198.png","0.00","0.00","0","0","1","1","2022-11-28 03:19:58");
INSERT INTO tbl_item VALUES("109","ABA096P","   PLC  SPLITTER - 25/75","SPLITTER - 25/75","","","17","","","","1","","10","","","","","","PLC_1669627239.png","0.00","0.00","0","0","1","1","2022-11-28 03:20:39");
INSERT INTO tbl_item VALUES("110","ABA097P","   PLC  SPLITTER - 30/70","SPLITTER - 30/70","","","17","","","","1","","10","","","","","","PLC_1669627283.png","0.00","0.00","0","0","1","1","2022-11-28 03:21:23");
INSERT INTO tbl_item VALUES("111","ABA098P","   PLC  SPLITTER - 35/65","SPLITTER - 35/65","","","17","","","","1","","10","","","","","","PLC_1669627317.png","0.00","0.00","0","0","1","1","2022-11-28 03:21:57");
INSERT INTO tbl_item VALUES("112","ABA099P","   PLC  SPLITTER - 40/60","SPLITTER - 40/60","","","17","","","","1","","10","","","","","","PLC_1669627349.png","0.00","0.00","0","0","1","1","2022-11-28 03:22:29");
INSERT INTO tbl_item VALUES("113","ABA100P","   PLC  SPLITTER - 45/55","SPLITTER - 45/55","","","17","","","","1","","10","","","","","","PLC_1669627383.png","0.00","0.00","0","0","1","1","2022-11-28 03:23:03");
INSERT INTO tbl_item VALUES("114","ABA101P","   PLC  SPLITTER - 50/50","SPLITTER - 50/50","","","17","","","","1","","10","","","","","","PLC_1669627415.png","0.00","0.00","0","0","1","1","2022-11-28 03:23:35");
INSERT INTO tbl_item VALUES("115","ABA102P","RG - 6  SATELLITE VISION MIX FULL - 100M","SATELLITE VISION MIX FULL - 100M","","","18","","","","24","","5","","","","","","RG_1669628052.jpg","0.00","0.00","0","0","1","1","2022-11-28 03:34:12");
INSERT INTO tbl_item VALUES("116","ABA103P","RG - 6  SATELLITE VISION MIX - 300M","SATELLITE VISION MIX - 300M","","","18","","","","24","","5","","","","","","RGG_1669628135.jpg","0.00","0.00","0","0","1","1","2022-11-28 03:35:35");
INSERT INTO tbl_item VALUES("117","ABA104P","RG - 6  SATELLITE VISION MIX FULL - 300M","SATELLITE VISION MIX FULL - 300M","","","18","","","","24","","0","","","","","","RG_1669628194.jpg","0.00","0.00","0","0","1","1","2022-11-28 03:36:34");
INSERT INTO tbl_item VALUES("120","ABA107P","RG - 6  RED DRAGON MIX FULL - 100M","RED DRAGON MIX FULL - 100M","","","18","","","","24","","5","","","","","","RD_1669629290.png","0.00","0.00","0","0","1","1","2022-11-28 03:54:50");
INSERT INTO tbl_item VALUES("121","ABA108P","RG - 6  RED DRAGON MIX FULL - 300M","RED DRAGON MIX FULL - 300M","","","18","","","","24","","5","","","","","","RD_1669629336.png","0.00","0.00","0","0","1","1","2022-11-28 03:55:36");
INSERT INTO tbl_item VALUES("122","ABA109P","RG - 6  RED DRAGON TAMA 9.0 WAY - 100M","RED DRAGON TAMA - 100M","","","18","","","","24","","5","","","","","","TA_1669629436.jpg","0.00","0.00","0","0","1","1","2022-11-28 03:57:16");
INSERT INTO tbl_item VALUES("123","ABA110P","RG - 6  RED DRAGON TAMA FULL - 100M","RED DRAGON TAMA FULL - 100M","","","18","","","","24","","5","","","","","","TA_1669629527.jpg","0.00","0.00","0","0","1","1","2022-11-28 03:58:47");
INSERT INTO tbl_item VALUES("124","ABA111P","RG - 6  RED DRAGON TAMA - 300M","RED DRAGON TAMA - 300M","","","18","","","","24","","5","","","","","","FB_1669629578.jpg","0.00","0.00","0","0","1","1","2022-11-28 03:59:38");
INSERT INTO tbl_item VALUES("125","ABA112P","RG - 6  RED DRAGON TAMA FULL - 300M","RED DRAGON TAMA FULL - 300M","","","18","","","","24","","5","","","","","","RGG_1669629628.jpg","0.00","0.00","0","0","1","1","2022-11-28 04:00:28");
INSERT INTO tbl_item VALUES("127","ABA114P","   NODE  MINI - 2 WAY","MINI - 2 WAY","","","15","","","","1","","10","","","","","","22_1669632469.png","0.00","0.00","0","0","1","1","2022-11-28 04:47:49");
INSERT INTO tbl_item VALUES("128","ABA115P","   NODE  MINI - 1 WAY","MINI - 1 WAY","","","15","","","","1","","10","","","","","","11_1669632761.png","0.00","0.00","0","0","1","1","2022-11-28 04:52:41");
INSERT INTO tbl_item VALUES("129","ABA116P","   NODE  MINI - 3 WAY","MINI - 3 WAY","","","15","","","","1","","10","","","","","","33_1669632796.png","0.00","0.00","0","0","1","1","2022-11-28 04:53:16");
INSERT INTO tbl_item VALUES("130","ABA117P","   NODE  MINI - 4 WAY","MINI - 4 WAY","","","15","","","","1","","10","","","","","","44_1669632885.png","0.00","0.00","0","0","1","1","2022-11-28 04:54:45");
INSERT INTO tbl_item VALUES("131","ABA118P","PLC  SPLITTER MATHA WALA - 1*2","SPLITTER MATHA WALA - 1X2","","","17","","","","1","","20","","","","","","Screenshot_12_1669633070.png","0.00","0.00","0","0","1","1","2022-11-28 04:57:50");
INSERT INTO tbl_item VALUES("132","ABA119P","PLC  SPLITTER MATHA WALA - 1*4","SPLITTER MATHA WALA - 1X4","","","17","","","","1","","20","","","","","","Screenshot_12_1669633111.png","0.00","0.00","0","0","1","1","2022-11-28 04:58:31");
INSERT INTO tbl_item VALUES("133","ABA120P","PLC  SPLITTER MATHA WALA - 1*8","SPLITTER MATHA WALA - 1X8","","","17","","","","1","","10","","","","","","Screenshot_12_1669633143.png","0.00","0.00","0","0","1","1","2022-11-28 04:59:03");
INSERT INTO tbl_item VALUES("134","ABA121P","PLC  DISH SPLITTER - 5/95","DISH SPLITTER - 5/95","","","17","","","","1","","20","","","","","","Screenshot_14_1669636341.png","0.00","0.00","0","0","1","1","2022-11-28 05:00:30");
INSERT INTO tbl_item VALUES("135","ABA122P","PLC  DISH SPLITTER - 10/90","DISH SPLITTER - 10/90","","","17","","","","1","","0","","","","","","Screenshot_14_1669636191.png","0.00","0.00","0","0","1","1","2022-11-28 05:01:18");
INSERT INTO tbl_item VALUES("136","ABA123P","PLC  DISH SPLITTER - 15/85","DISH SPLITTER - 15/85","","","17","","","","1","","10","","","","","","Screenshot_14_1669636240.png","0.00","0.00","0","0","1","1","2022-11-28 05:01:55");
INSERT INTO tbl_item VALUES("137","ABA124P","PLC  DISH SPLITTER - 20/80","DISH SPLITTER - 20/80","","","17","","","","1","","10","","","","","","Screenshot_14_1669636271.png","0.00","0.00","0","0","1","1","2022-11-28 05:02:26");
INSERT INTO tbl_item VALUES("138","ABA125P","PLC  DISH SPLITTER - 25/75","DISH SPLITTER - 25/75","","","17","","","","1","","10","","","","","","Screenshot_14_1669636288.png","0.00","0.00","0","0","1","1","2022-11-28 05:03:10");
INSERT INTO tbl_item VALUES("139","ABA126P","PLC  DISH SPLITTER - 30/70","DISH SPLITTER - 30/70","","","17","","","","1","","10","","","","","","Screenshot_14_1669636307.png","0.00","0.00","0","0","1","1","2022-11-28 05:03:55");
INSERT INTO tbl_item VALUES("140","ABA127P","PLC  DISH SPLITTER - 35/65","DISH SPLITTER - 35/65","","","17","","","","1","","10","","","","","","Screenshot_14_1669636321.png","0.00","0.00","0","0","1","1","2022-11-28 05:04:43");
INSERT INTO tbl_item VALUES("141","ABA128P","PLC  DISH SPLITTER - 40/60","DISH SPLITTER - 40/60","","","17","","","","1","","10","","","","","","Screenshot_14_1669636355.png","0.00","0.00","0","0","1","1","2022-11-28 05:05:11");
INSERT INTO tbl_item VALUES("142","ABA129P","PLC  DISH SPLITTER - 45/55","DISH SPLITTER - 45/55","","","17","","","","1","","10","","","","","","Screenshot_14_1669636369.png","0.00","0.00","0","0","1","1","2022-11-28 05:06:05");
INSERT INTO tbl_item VALUES("143","ABA130P","PLC  DISH SPLITTER - 50/50","DISH SPLITTER - 50/50","","","17","","","","1","","10","","","","","","Screenshot_14_1669636385.png","0.00","0.00","0","0","1","1","2022-11-28 05:06:33");
INSERT INTO tbl_item VALUES("145","ABA132P","RG - 6  RED DRAGON MIX 8-WAY","RED DRAGON MIX 8-WAY","","","18","","","","24","","10","","","","","","77_1669634416.png","0.00","0.00","0","0","1","1","2022-11-28 05:20:16");
INSERT INTO tbl_item VALUES("146","ABA133P","RG - 6  RED DRAGON MIX 9-WAY","RED DRAGON MIX 9-WAY","","","18","","","","24","","0","","","","","","77_1669634508.png","0.00","0.00","0","0","1","1","2022-11-28 05:21:48");
INSERT INTO tbl_item VALUES("147","ABA134P","RG - 6  RED DRAGON MIX - 1.8WAY","RED DRAGON MIX - 1.8WAY","","","18","","","","24","","0","","","","","","77_1669634676.png","0.00","0.00","0","0","1","1","2022-11-28 05:24:36");
INSERT INTO tbl_item VALUES("148","ABA135P","RG - 6  RED DRAGON MIX - 2.0WAY ","RED DRAGON MIX - 2.0WAY ","","","18","","","","24","","10","","","","","","77_1669634791.png","0.00","0.00","0","0","1","1","2022-11-28 05:26:30");
INSERT INTO tbl_item VALUES("149","ABA136P","RG - 6  RED DRAGON MIX - 2.2 WAY","RED DRAGON MIX - 2.2 WAY","","","18","","","","24","","10","","","","","","77_1669634955.png","0.00","0.00","0","0","1","1","2022-11-28 05:29:15");
INSERT INTO tbl_item VALUES("150","ABA137P","RG - 6  RED DRAGON MIX - 2.7 WAY","RED DRAGON MIX - 2.7 WAY","","","18","","","","24","","10","","","","","","77_1669635001.png","0.00","0.00","0","0","1","1","2022-11-28 05:30:01");
INSERT INTO tbl_item VALUES("151","ABA138P","RG - 6  AR-LINK MIX - 100M","AR-LINK MIX - 100M","","","18","","","","24","","10","","","","","","AR_1669639494.png","0.00","0.00","0","0","1","1","2022-11-28 05:34:38");
INSERT INTO tbl_item VALUES("152","ABA139P","RG - 6  AR-LINK MIX 2.2 WAY - 300M","AR-LINK MIX - 300M","","","18","","","","24","","5","","","","","","AR_1669639549.png","0.00","0.00","0","0","1","1","2022-11-28 05:35:05");
INSERT INTO tbl_item VALUES("154","ABA141P","RG - 6  AR-LINK TAMA - 100M","AR-LINK TAMA - 100M","","","18","","","","24","","10","","","","","","AR_1669639712.png","0.00","0.00","0","0","1","1","2022-11-28 05:36:47");
INSERT INTO tbl_item VALUES("156","ABA143P","RG - 6  AR-LINK TAMA - 300M","AR-LINK TAMA - 300M","","","18","","","","24","","5","","","","","","AR_1669639694.png","0.00","0.00","0","0","1","1","2022-11-28 05:38:11");
INSERT INTO tbl_item VALUES("157","ABA144P","RG - 6  AR-LINK TAMA FULL - 300M","AR-LINK TAMA FULL - 300M","","","18","","","","24","","10","","","","","","AR_1669639671.png","0.00","0.00","0","0","1","1","2022-11-28 05:39:10");
INSERT INTO tbl_item VALUES("158","ABA145P","     NET PATCHCORD ","NET PATCHCORD ","","","","","","","1","","10","","","","","","nn_1669635910.png","0.00","0.00","0","0","1","1","2022-11-28 05:45:10");
INSERT INTO tbl_item VALUES("159","ABA146P","     NET PATCHCORD HIGH","NET PATCHCORD HIGH","","","","","","","1","","20","","","","","","n_1669635934.jpg","0.00","0.00","0","0","1","1","2022-11-28 05:45:33");
INSERT INTO tbl_item VALUES("160","ABA147P","DISH PATCHCORD HIGH","DISH PATCHCORD","","","","","","","1","","10","","","","","","Screenshot_13_1669636013.png","0.00","0.00","0","0","1","1","2022-11-28 05:46:53");
INSERT INTO tbl_item VALUES("161","ABA148P","PLC  SPLITTER - 4/96","SPLITTER - 4/96","","","17","","","","1","","10","","","","","","Screenshot_228_1672844702.png","0.00","0.00","0","0","1","1","2022-11-28 05:56:42");
INSERT INTO tbl_item VALUES("162","ABA149P","PLC  SPLITTER - 3/97","SPLITTER - 3/97","","","17","","","","1","","10","","","","","","Screenshot_228_1672844626.png","0.00","0.00","0","0","1","1","2022-11-28 05:57:19");
INSERT INTO tbl_item VALUES("163","ABA150P","PLC  SPLITTER - 2/98","SPLITTER - 2/98","","","17","","","","1","","10","","","","","","Screenshot_228_1672846496.png","0.00","0.00","0","0","1","1","2022-11-28 05:57:53");
INSERT INTO tbl_item VALUES("164","ABA151P","PLC  SPLITTER - 1/99","SPLITTER - 1/99","","","17","","","","1","","10","","","","","","Screenshot_228_1672845163.png","0.00","0.00","0","0","1","1","2022-11-28 05:58:30");
INSERT INTO tbl_item VALUES("165","ABA152P","CABLE TESTER ( DISH + NET )","CABLE TESTER ( DISH + NET )","","","","","","","1","","5","","","","","","DD_1669639885.png","0.00","0.00","0","0","1","1","2022-11-28 06:07:00");
INSERT INTO tbl_item VALUES("166","ABA153P","     CABLE TESTER ( AH - LINK )","CABLE TESTER ( AH - LINK )","","","","","","","1","","5","","","","","","AH_1669637270.jpg","0.00","0.00","0","0","1","1","2022-11-28 06:07:50");
INSERT INTO tbl_item VALUES("167","ABA154P","CABLE TESTER ( BATTERY )","CABLE TESTER ( BATTERY )","","","","","","","1","","0","","","","","","BB_1669639818.png","0.00","0.00","0","0","1","1","2022-11-28 06:10:01");
INSERT INTO tbl_item VALUES("168","ABA155P","D-LINK CRIMPER TOOLS","CRIMPER TOOLS ( D-LINK )","","","","","","","1","","5","","","","","","DDD_1669639968.png","0.00","0.00","0","0","1","1","2022-11-28 06:15:39");
INSERT INTO tbl_item VALUES("170","ABA157P","ADAPTER CC - 5V","ADAPTER - 5V","","","","","","","1","","20","","","","","","55555_1669640092.png","0.00","0.00","0","0","1","1","2022-11-28 06:54:52");
INSERT INTO tbl_item VALUES("171","ABA158P","OUT OF STOCK  ADAPTER - 9V","ADAPTER - 9V","","","19","","","","1","","10","","","","","","SS_1669641749.jpg","0.00","0.00","0","0","1","1","2022-11-28 06:58:55");
INSERT INTO tbl_item VALUES("172","ABA159P","OUT OF STOCK  ADAPTER - 12V","ADAPTER - 12V","","","19","","","","1","","0","","","","","","SS_1669641632.jpg","0.00","0.00","0","0","1","1","2022-11-28 06:59:20");
INSERT INTO tbl_item VALUES("173","ABA160P","     ADAPTER CC - 12V","ADAPTER CC - 12V","","","","","","","1","","10","","","","","","CC_1669640428.png","0.00","0.00","0","0","1","1","2022-11-28 07:00:28");
INSERT INTO tbl_item VALUES("174","ABA161P","     ADAPTER HIGH - 9V","ADAPTER HIGH - 9V","","","","","","","1","","10","","","","","","HHH_1669640536.png","0.00","0.00","0","0","1","1","2022-11-28 07:02:16");
INSERT INTO tbl_item VALUES("175","ABA162P","     ADAPTER CC HIGH - 12V","ADAPTER CC HIGH - 12V","","","","","","","1","","10","","","","","","122_1669640621.png","0.00","0.00","0","0","1","1","2022-11-28 07:03:41");
INSERT INTO tbl_item VALUES("176","ABA163P","OUT OF STOCK  ADAPTER HIGH - 5V","ADAPTER HIGH - 5V","","","19","","","","1","","0","","","","","","SS_1669641697.jpg","0.00","0.00","0","0","1","1","2022-11-28 07:04:09");
INSERT INTO tbl_item VALUES("177","ABA164P","OUT OF STOCK  CRIMPER TOOLS ( AH-LINK )","CRIMPER TOOLS ( AH-LINK )","","","19","","","","1","","0","","","","","","SS_1669641929.jpg","0.00","0.00","0","0","1","1","2022-11-28 07:06:49");
INSERT INTO tbl_item VALUES("178","ABA165P","     TJ BOX - 2 PORT","TJ BOX - 2 PORT","","","","","","","1","","50","","","","","","222_1669641252.png","0.00","0.00","0","0","1","1","2022-11-28 07:14:12");
INSERT INTO tbl_item VALUES("179","ABA166P","     TJ BOX - 4 PORT","TJ BOX - 4 PORT","","","","","","","1","","50","","","","","","444_1669641297.jpg","0.00","0.00","0","0","1","1","2022-11-28 07:14:57");
INSERT INTO tbl_item VALUES("180","ABA167P","     TJ BOX - 8 PORT","TJ BOX - 8 PORT","","","","","","","1","","50","","","","","","8888_1669641330.jpg","0.00","0.00","0","0","1","1","2022-11-28 07:15:30");
INSERT INTO tbl_item VALUES("181","ABA168P","     MC D-LINK ( A PART )","MC D-LINK ( A PART )","","","","","","","1","","10","","","","","","MC_1669644946.jpg","0.00","0.00","0","0","1","1","2022-11-28 08:15:46");
INSERT INTO tbl_item VALUES("182","ABA169P","     MC D-LINK ( B PART )","MC D-LINK ( B PART )","","","","","","","1","","10","","","","","","MC_1669644983.jpg","0.00","0.00","0","0","1","1","2022-11-28 08:16:23");
INSERT INTO tbl_item VALUES("183","ABA170P","     DISH JACK STEEL","DISH JACK STEEL","","","","","","","1","","50","","","","","","DDDD_1669704852.jpg","0.00","0.00","0","0","1","1","2022-11-29 12:54:12");
INSERT INTO tbl_item VALUES("185","ABA171P","     DISH JACK PLASTIC MX","DISH JACK PLASTIC MX","","","","","","","1","","0","","","","","","MXX_1669719690.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:01:30");
INSERT INTO tbl_item VALUES("186","ABA172P","DISH JACK PLASTIC PPX","DISH JACK PLASTIC PPX","","","","","","","1","","0","","","","","","SSS_1669719723.jpeg","0.00","0.00","0","0","1","1","2022-11-29 05:02:03");
INSERT INTO tbl_item VALUES("187","ABA173P","     DISH CONNECTOR","DISH CONNECTOR","","","","","","","1","","50","","","","","","CONN_1669719844.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:04:04");
INSERT INTO tbl_item VALUES("188","ABA174P","NET CONNECTOR / LAN CLIP ( E-NET )","NET CONNECTOR / LAN CLIP","","","","","","","1","","0","","","","","","Screenshot_15_1669720106.png","0.00","0.00","0","0","1","1","2022-11-29 05:08:26");
INSERT INTO tbl_item VALUES("189","ABA175P","NET CONNECTOR / LAN CLIP ( BLUE )","NET CONNECTOR / LAN CLIP ( NIL )","","","","","","","1","","0","","","","","","NIL_1669720437.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:13:57");
INSERT INTO tbl_item VALUES("190","ABA176P","     NET CONNECTOR / LAN CLIP D-LINK CAT-6 ","NET CONNECTOR / LAN CLIP D-LINK CAT-6 ","","","","","","","1","","50","","","","","","D-_1669720848.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:20:48");
INSERT INTO tbl_item VALUES("191","ABA177P","     NET CONNECTOR / LAN CLIP AMP","NET CONNECTOR / LAN CLIP AMP","","","","","","","1","","50","","","","","","AM_1669720886.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:21:26");
INSERT INTO tbl_item VALUES("192","ABA178P","     ANDROID TV BOX - 1K","ANDROID TV BOX - 1K","","","","","","","1","","10","","","","","","1K_1669722029.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:40:29");
INSERT INTO tbl_item VALUES("193","ABA179P","ANDROID TV BOX - TX10 8K","ANDROID TV BOX - 4K","","","","","","","1","","10","","","","","","4KK_1669731427.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:41:20");
INSERT INTO tbl_item VALUES("194","ABA180P","ANDROID TV BOX -  TX9 PRO 8K","ANDROID TV BOX - 8K","","","","","","","1","","10","","","","","","8K_1669722124.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:42:04");
INSERT INTO tbl_item VALUES("195","ABA181P","     TV CARD GADMEI","TV CARD GADMEI","","","","","","","1","","5","","","","","","GD_1669722280.jpg","0.00","0.00","0","0","1","1","2022-11-29 05:44:40");
INSERT INTO tbl_item VALUES("196","ABA182P","REPEATER XIAOMI MI ","REPEATER XIAOMI MI ","","","","","","","1","","10","","","","","","MI_1669722421.jpg","0.00","0.00","183","1","1","1","2022-11-29 05:47:01");
INSERT INTO tbl_item VALUES("197","ABA183P","     STEEL BOX ( 4.6 )","STEEL BOX ( 4.6 )","","","","","","","1","","20","","","","","","BOX_1669722724.png","0.00","0.00","0","0","1","1","2022-11-29 05:52:04");
INSERT INTO tbl_item VALUES("198","ABA184P","     STEEL BOX ( 8.10 )","STEEL BOX ( 8.10 )","","","","","","","1","","10","","","","","","BOX_1669722756.png","0.00","0.00","0","0","1","1","2022-11-29 05:52:36");
INSERT INTO tbl_item VALUES("199","ABA185P","     USING MC - A PART","USING MC - A PART","","","","","","","1","","10","","","","","","MC_1669723230.jpg","0.00","0.00","0","0","1","1","2022-11-29 06:00:30");
INSERT INTO tbl_item VALUES("200","ABA186P","     USING MC - B PART","USING MC - B PART","","","","","","","1","","20","","","","","","MC_1669723259.jpg","0.00","0.00","0","0","1","1","2022-11-29 06:00:59");
INSERT INTO tbl_item VALUES("201","ABA187P","DV METER","DV METER","","","","","","","1","","10","","","","","","DV_1670196121.jpg","0.00","0.00","0","0","1","1","2022-11-29 06:02:04");
INSERT INTO tbl_item VALUES("209","ABA195P","     DISH SPLITTER FWDM","DISH SPLITTER FWDM","","","","","","","1","","20","","","","","","fwdm_1669724946.jpg","0.00","0.00","0","0","1","1","2022-11-29 06:29:06");
INSERT INTO tbl_item VALUES("210","ABA196P","     TV STAND - LARGE","TV STAND - LARGE","","","","","","","1","","10","","","","","","SSSS_1669726153.jpg","0.00","0.00","0","0","1","1","2022-11-29 06:49:13");
INSERT INTO tbl_item VALUES("211","ABA197P","     TV STAND - SMALL ","TV STAND - SMALL ","","","","","","","1","","10","","","","","","SD_1669726494.jpg","0.00","0.00","0","0","1","1","2022-11-29 06:54:54");
INSERT INTO tbl_item VALUES("212","ABA198P","AKASH DTH BOX","AKASH DTH BOX","","","","","","","1","","0","","","","","","AK_1669726655.png","0.00","0.00","0","0","1","1","2022-11-29 06:57:35");
INSERT INTO tbl_item VALUES("213","ABA199P","     AKASH DTH STAN","AKASH DTH STAN","","","","","","","1","","5","","","","","","AS_1669726743.png","0.00","0.00","0","0","1","1","2022-11-29 06:59:03");
INSERT INTO tbl_item VALUES("214","ABA200P","AKASH DTH LMB / LNB - 1 PORT","AKASH DTH LMB/LNB","","","","","","","1","","10","","","","","","LN_1669726859.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:00:59");
INSERT INTO tbl_item VALUES("215","ABA201P","     LMB / LNB - 2 PORT","LMB / LNB - 2 PORT","","","","","","","1","","10","","","","","","2N_1669727052.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:04:12");
INSERT INTO tbl_item VALUES("216","ABA202P","     LMB / LNB - 4 PORT","LMB / LNB - 4 PORT","","","","","","","1","","5","","","","","","4N_1669727094.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:04:53");
INSERT INTO tbl_item VALUES("217","ABA203P","     HELLO BOX 6","HELLO BOX 6","","","","","","","1","","5","","","","","","HL_1669727455.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:10:55");
INSERT INTO tbl_item VALUES("218","ABA204P","     CAT-6 JOINTER  - 1 WAY","CAT-6 JOINTER  - 1 WAY","","","","","","","1","","50","","","","","","CT_1669727574.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:12:54");
INSERT INTO tbl_item VALUES("219","ABA205P","     CAT-6 JOINTER  - 2 WAY","CAT-6 JOINTER  - 2 WAY","","","","","","","1","","50","","","","","","1W_1669727626.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:13:46");
INSERT INTO tbl_item VALUES("220","ABA206P","Ezviz Smart Home Camera H6c 1080p Resolution","EZVIZ - C6N","","","20","","","","1","","0","","","","","","EZ_1669727871.jpg","2750.00","0.00","365","0","1","1","2022-11-29 07:17:51");
INSERT INTO tbl_item VALUES("221","ABA207P","   CAMERA  DAHUA IR BULLET CAMERA - B1A21P","DAHUA IR BULLET CAMERA - B1A21P","","","20","","","","1","","10","","","","","","DAA_1669728242.png","0.00","0.00","0","0","1","1","2022-11-29 07:24:01");
INSERT INTO tbl_item VALUES("222","ABA208P","   CAMERA  SRIHOME IP CAMERA - SH036","SRIHOME IP CAMERA - SH036","","","20","","","","1","","5","","","","","","SH_1669728560.png","0.00","0.00","0","0","1","1","2022-11-29 07:29:20");
INSERT INTO tbl_item VALUES("223","ABA209P","   CAMERA  DAHUA IR BULLET CAMERA - HFW1200DP","DAHUA IR BULLET CAMERA - HFW1200DP","","","20","","","","1","","5","","","","","","120_1669728806.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:33:26");
INSERT INTO tbl_item VALUES("224","ABA210P","   CAMERA  HIKVISION TURBO COLOR CAMERA - DS-2CE16DOT-IRP/ECO","HIKVISION TURBO COLOR CAMERA - DS-2CE16DOT-IRP/ECO","","","20","","","","1","","10","","","","","","16_1669728987.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:36:27");
INSERT INTO tbl_item VALUES("225","ABA211P","   CAMERA  HIKVISION TURBO COLOR CAMERA - DS-2CE56DOT-IRP/ECO","HIKVISION TURBO COLOR CAMERA - DS-2CE56DOT-IRP/ECO","","","20","","","","1","","5","","","","","","2C_1669729178.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:39:38");
INSERT INTO tbl_item VALUES("226","ABA212P","   CAMERA  DAHUA IR EYEBALL CAMERA - HDW1200TLP-A","DAHUA IR EYEBALL CAMERA - HDW1200TLP-A","","","20","","","","1","","5","","","","","","12_1669729420.png","0.00","0.00","0","0","1","1","2022-11-29 07:43:39");
INSERT INTO tbl_item VALUES("227","ABA213P","     HIKVISION 8CH DVR 7100 SERIES - DS-7108HGH1-K1","HIKVISION 8CH DVR 7100 SERIES - DS-7108HGH1-K1","","","","","","","1","","5","","","","","","8CH_1669729669.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:47:49");
INSERT INTO tbl_item VALUES("228","ABA214P","DAHUA 8CH DVR/XVR - DH-XVR1B08-l ","DAHUA DVR - DH-XVR1B08-l ","","","","","","","1","","5","","","","","","4CH_1669730007.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:53:27");
INSERT INTO tbl_item VALUES("229","ABA215P","     DAHUA DVR/XVR 16CH XVR1B16-l","DAHUA DVR/XVR 16CH XVR1B16-l","","","","","","","1","","5","","","","","","16CH_1669730359.jpg","0.00","0.00","0","0","1","1","2022-11-29 07:59:19");
INSERT INTO tbl_item VALUES("230","ABA216P","     MC NET-LINK ( A PART )","MC NET-LINK ( A PART )","","","","","","","1","","5","","","","","","DDHH_1669734491.jpg","0.00","0.00","0","0","1","1","2022-11-29 09:08:11");
INSERT INTO tbl_item VALUES("232","ABA218P","     LMB/LNB - TURBO","LMB/LNB - TURBO","","","","","","","1","","10","","","","","","Screenshot_16_1669734905.png","0.00","0.00","0","0","1","1","2022-11-29 09:15:05");
INSERT INTO tbl_item VALUES("233","ABA219P","     LMB/LNB PANORAMA ","LMB/LNB PANORAMA ","","","","","","","1","","0","","","","","","Screenshot_17_1669735068.png","0.00","0.00","0","0","1","1","2022-11-29 09:17:48");
INSERT INTO tbl_item VALUES("234","ABA220P","     TRANSFORMER DISH","TRANSFORMER DISH","","","","","","","1","","200","","","","","","Low_1669735177.jpg","0.00","0.00","0","0","1","1","2022-11-29 09:19:37");
INSERT INTO tbl_item VALUES("235","ABA221P","     NET CONNECTOR / LAN CLIP - AH-LINK","NET CONNECTOR / LAN CLIP - AH-LINK","","","","","","","1","","50","","","","","","Screenshot_18_1669786946.png","0.00","0.00","0","0","1","1","2022-11-30 11:42:26");
INSERT INTO tbl_item VALUES("236","ABA222P","     STEEL BOX DISH","STEEL BOX DISH","","","","","","","1","","10","","","","","","BOX_1669787086.png","0.00","0.00","0","0","1","1","2022-11-30 11:44:46");
INSERT INTO tbl_item VALUES("237","ABA223P","     DAHUA 4CH DVR/XVR - XVR1B04-l ","DAHUA 4CH DVR/XVR - XVR1B04-l ","","","","","","","1","","5","","","","","","4CH_1669789061.jpg","0.00","0.00","0","0","1","1","2022-11-30 12:17:41");
INSERT INTO tbl_item VALUES("238","ABA224P","WIFI IP SMART CAMERA - IPC-V380-Q3S","WIFI IP SMART CAMERA - IPC-V380-Q38","","","","","","","1","","10","","","","","","Screenshot_19_1669789274.png","0.00","0.00","0","0","1","1","2022-11-30 12:21:14");
INSERT INTO tbl_item VALUES("239","ABA225P","     OUTDOOR IP CAMERA - SH031E","OUTDOOR IP CAMERA - SH031E","","","","","","","1","","10","","","","","","SSSSS_1669789669.jpg","0.00","0.00","0","0","1","1","2022-11-30 12:27:49");
INSERT INTO tbl_item VALUES("240","ABA226P","     19&quot; LED MONITOR RELISYS - RE-19","19&quot; LED MONITOR RELISYS - RE-19","","","","","","","1","","5","","","","","","sssf_1669793242.jpg","0.00","0.00","0","0","1","1","2022-11-30 01:27:22");
INSERT INTO tbl_item VALUES("241","ABA227P","   LIGHT  SUPER STAR LED - 40 WATT","SUPER STAR LED - 40 WATT","","","21","","","","1","","10","","","","","","40_1669793522.jpg","0.00","0.00","0","0","1","1","2022-11-30 01:32:01");
INSERT INTO tbl_item VALUES("242","ABA228P","LIGHT  SUPER STAR LED - 15 WATT","SUPER STAR LED - 15 WATT","","","21","","","","1","","10","","","","","","15_1669793549.jpg","0.00","0.00","730","0","1","1","2022-11-30 01:32:29");
INSERT INTO tbl_item VALUES("243","ABA229P","LIGHT  SUPER STAR LED - 5 WATT","SUPER STAR LED - 5 WATT","","","21","","","","1","","10","","","","","","5W_1669793601.jpg","0.00","0.00","730","0","1","1","2022-11-30 01:33:21");
INSERT INTO tbl_item VALUES("245","ABA231P","LIGHT  SUPER STAR LED - 7 WATT","SUPER STAR LED - 7 WATT","","","21","","","","1","","10","","","","","","7_1669793893.png","0.00","0.00","730","0","1","1","2022-11-30 01:38:13");
INSERT INTO tbl_item VALUES("246","ABA232P","LIGHT  SUPER STAR LED - 12 WATT","SUPER STAR LED - 12 WATT","","","21","","","","1","","10","","","","","","12W_1669793942.jpg","0.00","0.00","730","0","1","1","2022-11-30 01:39:02");
INSERT INTO tbl_item VALUES("247","ABA233P","LIGHT  SUPER STAR LED - 3 WATT","SUPER STAR LED - 3 WATT","","","21","","","","1","","10","","","","","","3W_1669794639.jpg","0.00","0.00","730","0","1","1","2022-11-30 01:50:39");
INSERT INTO tbl_item VALUES("248","ABA234P","   LIGHT  SUPER STAR LED - 30 WATT","SUPER STAR LED - 30 WATT","","","21","","","","1","","10","","","","","","30_1669794726.jpg","0.00","0.00","0","0","1","1","2022-11-30 01:52:06");
INSERT INTO tbl_item VALUES("249","ABA235P","LIGHT  SUPER STAR LED - 18 WATT","SUPER STAR LED - 18 WATT","","","21","","","","1","","10","","","","","","18_1669794978.jpg","0.00","0.00","730","0","1","1","2022-11-30 01:56:18");
INSERT INTO tbl_item VALUES("250","ABA236P","LIGHT  SUPER STAR LED - 9 WATT","SUPER STAR LED - 9 WATT","","","21","","","","1","","10","","","","","","9_1669795165.jpg","0.00","0.00","730","0","1","1","2022-11-30 01:59:25");
INSERT INTO tbl_item VALUES("251","ABA237P","   LIGHT  SUPER STAR LED - 20 WATT","SUPER STAR LED - 20 WATT","","","21","","","","1","","10","","","","","","20_1669803009.png","0.00","0.00","0","0","1","1","2022-11-30 04:10:09");
INSERT INTO tbl_item VALUES("252","ABA238P","   LIGHT  SUPER STAR LED AC/DC - 10 WATT","SUPER STAR LED AC/DC - 10 WATT","","","21","","","","1","","10","","","","","","10_1669803193.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:13:13");
INSERT INTO tbl_item VALUES("253","ABA239P","   LIGHT  SUPER STAR LED AC/DC - 15 WATT","SUPER STAR LED AC/DC - 15 WATT","","","21","","","","1","","10","","","","","","15D_1669803402.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:16:42");
INSERT INTO tbl_item VALUES("254","ABA240P","   LIGHT  SUPER STAR LED AC/DC - 5 WATT","SUPER STAR LED AC/DC - 5 WATT","","","21","","","","1","","10","","","","","","5D_1669803471.png","0.00","0.00","0","0","1","1","2022-11-30 04:17:51");
INSERT INTO tbl_item VALUES("255","ABA241P","   LIGHT  OSAKA LED - 50WATT","OSAKA LED - 50WATT","","","21","","","","1","","10","","","","","","50D_1669804228.png","0.00","0.00","0","0","1","1","2022-11-30 04:30:28");
INSERT INTO tbl_item VALUES("256","ABA242P","   LIGHT  OSAKA LED - 40WATT","OSAKA LED - 40WATT","","","21","","","","1","","10","","","","","","40D_1669804307.png","0.00","0.00","0","0","1","1","2022-11-30 04:31:47");
INSERT INTO tbl_item VALUES("257","ABA243P","   LIGHT  OSAKA LED - 30WATT","OSAKA LED - 30WATT","","","21","","","","1","","10","","","","","","30-Watt-LED-Bulb-Osaka_1669804351.jpeg","0.00","0.00","0","0","1","1","2022-11-30 04:32:31");
INSERT INTO tbl_item VALUES("258","ABA244P","   LIGHT  OSAKA LED - 18WATT","OSAKA LED - 18WATT","","","21","","","","1","","10","","","","","","18D_1669804480.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:34:40");
INSERT INTO tbl_item VALUES("259","ABA245P","   LIGHT  OSAKA LED - 5WATT","OSAKA LED - 5WATT","","","21","","","","1","","10","","","","","","5DD_1669804548.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:35:48");
INSERT INTO tbl_item VALUES("260","ABA246P","   LIGHT  OSAKA LED - 10WATT","OSAKA LED - 10WATT","","","21","","","","1","","10","","","","","","10D_1669804604.png","0.00","0.00","0","0","1","1","2022-11-30 04:36:44");
INSERT INTO tbl_item VALUES("261","ABA247P","LIGHT  OSAKA LED - 20WATT","OSAKA LED - 20WATT","","","21","","","","1","","10","","","","","","20DD_1669804785.jpg","0.00","0.00","730","0","1","1","2022-11-30 04:39:45");
INSERT INTO tbl_item VALUES("262","ABA248P","   LIGHT  OSAKA LED - 15WATT","OSAKA LED - 15WATT","","","21","","","","1","","10","","","","","","15S_1669804890.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:41:30");
INSERT INTO tbl_item VALUES("263","ABA249P","   LIGHT  JET LED - 15WATT","JET LED - 15WATT","","","21","","","","1","","10","","","","","","15J_1669804965.png","0.00","0.00","0","0","1","1","2022-11-30 04:42:45");
INSERT INTO tbl_item VALUES("264","ABA250P","   LIGHT  JET LED - 12WATT","JET LED - 12WATT","","","21","","","","1","","10","","","","","","JET_1669805076.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:44:36");
INSERT INTO tbl_item VALUES("265","ABA251P","   LIGHT  JET LED - 9 WATT","JET LED - 9 WATT","","","21","","","","1","","10","","","","","","download (1)_1669805163.jfif","0.00","0.00","0","0","1","1","2022-11-30 04:46:03");
INSERT INTO tbl_item VALUES("266","ABA252P","   LIGHT  COSCO LED - 9WATT","COSCO LED - 9WATT","","","21","","","","1","","10","","","","","","15K_1669805285.png","0.00","0.00","0","0","1","1","2022-11-30 04:48:05");
INSERT INTO tbl_item VALUES("267","ABA253P","   LIGHT  COSCO LED - 12WATT","COSCO LED - 12WATT","","","21","","","","1","","10","","","","","","12Fw_1669805541.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:52:21");
INSERT INTO tbl_item VALUES("268","ABA254P","LIGHT  OSAKA LED AC/DC - 12WATT","OSAKA LED AC/DC - 15WATT","","","21","","","","1","","10","","","","","","AC12_1669805729.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:55:29");
INSERT INTO tbl_item VALUES("269","ABA255P","   LIGHT  OSAKA LED AC/DC - 10WATT","OSAKA LED AC/DC - 10WATT","","","21","","","","1","","10","","","","","","10AC_1669805788.png","0.00","0.00","0","0","1","1","2022-11-30 04:56:28");
INSERT INTO tbl_item VALUES("270","ABA256P","   LIGHT  OSAKA LED AC/DC - 5WATT","OSAKA LED AC/DC - 5WATT","","","21","","","","1","","10","","","","","","5AC_1669805863.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:57:43");
INSERT INTO tbl_item VALUES("271","ABA257P","   LIGHT  OSAKA LED AC/DC - 8WATT","OSAKA LED AC/DC - 8WATT","","","21","","","","1","","10","","","","","","8AC_1669805926.jpg","0.00","0.00","0","0","1","1","2022-11-30 04:58:46");
INSERT INTO tbl_item VALUES("272","ABA258P","   LIGHT  WALTON LED AC/DC - 18WATT","WALTON LED AC/DC - 18WATT","","","21","","","","1","","10","","","","","","18DD_1669806002.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:00:02");
INSERT INTO tbl_item VALUES("273","ABA259P","   LIGHT  WALTON LED AC/DC - 12WATT","WALTON LED AC/DC - 12WATT","","","21","","","","1","","10","","","","","","12DD_1669806041.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:00:41");
INSERT INTO tbl_item VALUES("274","ABA260P","   LIGHT  WALTON LED AC/DC - 10WATT","WALTON LED AC/DC - 10WATT","","","21","","","","1","","10","","","","","","10DD_1669806138.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:02:18");
INSERT INTO tbl_item VALUES("275","ABA261P","LIGHT  WALTON LED COLOR - 7WATT","WALTON LED COLOR - 7WATT","","","21","","","","1","","10","","","","","","7DD_1669806234.png","0.00","0.00","545","0","1","1","2022-11-30 05:03:53");
INSERT INTO tbl_item VALUES("276","ABA262P","   LIGHT  MEP LED - 12 WATT","MEP LED - 12 WATT","","","21","","","","1","","10","","","","","","12WT_1669806301.png","0.00","0.00","0","0","1","1","2022-11-30 05:05:01");
INSERT INTO tbl_item VALUES("277","ABA263P","LIGHT  KITTY LUMEX LED - 15WATT","KITTY LUMEX LED - 15WATT","","","21","","","","1","","10","","","","","","15KK_1669806674.jpg","0.00","0.00","730","0","1","1","2022-11-30 05:11:14");
INSERT INTO tbl_item VALUES("278","ABA264P","   LIGHT  LED NORMAL - SMALL","LED NORMAL - SMALL","","","21","","","","1","","10","","","","","","7W_1669807018.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:16:58");
INSERT INTO tbl_item VALUES("279","ABA265P","   LIGHT  LED NORMAL - LARGE","LED NORMAL - LARGE","","","21","","","","1","","10","","","","","","18K_1669807113.png","0.00","0.00","0","0","1","1","2022-11-30 05:18:33");
INSERT INTO tbl_item VALUES("280","ABA266P","   LIGHT  SATELLITE VISION LED AC/DC ","SATELLITE VISION LED AC/DC ","","","21","","","","1","","10","","","","","","18K_1669807483.png","0.00","0.00","0","0","1","1","2022-11-30 05:24:43");
INSERT INTO tbl_item VALUES("281","ABA267P","LIGHT SATELLITE VISION LED ","SATELLITE VISION LED - 20WATT","","","21","","","","1","","0","","","","","","8AC_1669807616.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:26:56");
INSERT INTO tbl_item VALUES("282","ABA268P","   LIGHT  OSAKA TUBE LED - 10WATT","OSAKA TUBE LED - 10WATT","","","21","","","","1","","20","","","","","","10SS_1669807775.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:29:35");
INSERT INTO tbl_item VALUES("283","ABA269P","   LIGHT  OSAKA TUBE LED - 40WATT","OSAKA TUBE LED - 40WATT","","","21","","","","1","","20","","","","","","Screenshot_20_1669807872.png","0.00","0.00","0","0","1","1","2022-11-30 05:31:12");
INSERT INTO tbl_item VALUES("284","ABA270P","   LIGHT  OSAKA TUBE LED - 20WATT","OSAKA TUBE LED - 20WATT","","","21","","","","1","","20","","","","","","200_1669807930.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:32:10");
INSERT INTO tbl_item VALUES("285","ABA271P","   LIGHT  WALTON TUBE LED - 34WATT","WALTON TUBE LED - 34WATT","","","21","","","","1","","10","","","","","","34_1669808009.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:33:29");
INSERT INTO tbl_item VALUES("286","ABA272P","   LIGHT  WALTON TUBE LED - 18 WATT","WALTON TUBE LED - 18 WATT","","","21","","","","1","","20","","","","","","34_1669808051.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:34:11");
INSERT INTO tbl_item VALUES("287","ABA273P","   LIGHT  SUPER STAR TUBE LED - 40 WATT","SUPER STAR TUBE LED - 40 WATT","","","21","","","","1","","10","","","","","","40L_1669808109.png","0.00","0.00","0","0","1","1","2022-11-30 05:35:09");
INSERT INTO tbl_item VALUES("288","ABA274P","   LIGHT  SUPER STAR TUBE LED - 20WATT","SUPER STAR TUBE LED - 20WATT","","","21","","","","1","","10","","","","","","20KK_1669808404.png","0.00","0.00","0","0","1","1","2022-11-30 05:40:04");
INSERT INTO tbl_item VALUES("291","ABA277P","   LIGHT  NORMAL - 200WATT","NORMAL - 200WATT","","","21","","","","1","","10","","","","","","NORMALL_1669809264.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:54:24");
INSERT INTO tbl_item VALUES("292","ABA278P","   LIGHT  NORMAL - 100WATT","NORMAL - 100WATT","","","21","","","","1","","10","","","","","","NORMALL_1669809294.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:54:54");
INSERT INTO tbl_item VALUES("293","ABA279P","LIGHT SUPER STAR NORMAL - 60WATT","NORMAL - 60WATT","","","21","","","","1","","0","","","","","","NORMALL_1669809325.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:55:25");
INSERT INTO tbl_item VALUES("294","ABA280P","   LIGHT  NORMAL - 40WATT","NORMAL - 40WATT","","","21","","","","1","","10","","","","","","NORMALL_1669809351.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:55:51");
INSERT INTO tbl_item VALUES("295","ABA281P","   LIGHT  NORMAL - 25WATT","NORMAL - 25WATT","","","21","","","","1","","10","","","","","","NORMALL_1669809378.jpg","0.00","0.00","0","0","1","1","2022-11-30 05:56:17");
INSERT INTO tbl_item VALUES("296","ABA282P","LIGHT DIM AVERAGE","DIM NORMAL","","","21","","","","1","","10","","","","","","53_1669810026.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:07:06");
INSERT INTO tbl_item VALUES("297","ABA283P","   LIGHT  ERICSON LED","ERICSON LED","","","21","","","","1","","10","","","","","","ER_1669810286.jfif","0.00","0.00","0","0","1","1","2022-11-30 06:11:26");
INSERT INTO tbl_item VALUES("298","ABA284P","   LIGHT  TRANSTEC ENERGY - 20WATT","TRANSTEC ENERGY - 20WATT","","","21","","","","1","","10","","","","","","EE_1669810477.png","0.00","0.00","0","0","1","1","2022-11-30 06:14:37");
INSERT INTO tbl_item VALUES("299","ABA285P","   LIGHT  TRANSTEC ENERGY 24 WATT","TRANSTEC ENERGY 24 WATT","","","21","","","","1","","10","","","","","","EE_1669810533.png","0.00","0.00","0","0","1","1","2022-11-30 06:15:33");
INSERT INTO tbl_item VALUES("300","ABA286P","   LIGHT  SUPER STAR ENERGY - 26 WATT","SUPER STAR ENERGY - 26 WATT","","","21","","","","1","","10","","","","","","AA_1669810641.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:17:21");
INSERT INTO tbl_item VALUES("301","ABA287P","   LIGHT  OSAKA PANEL LED - 12WATT","OSAKA PANEL LED - 12WATT","","","21","","","","1","","10","","","","","","PP_1669810700.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:18:20");
INSERT INTO tbl_item VALUES("302","ABA288P","LIGHT  WALTON PANEL COLOR - 18WATT","WALTON PANEL COLOR - 12WATT","","","21","","","","1","","10","","","","","","download (2)_1669810774.jfif","0.00","0.00","0","0","1","1","2022-11-30 06:19:34");
INSERT INTO tbl_item VALUES("303","ABA289P","PVC TAPE OSAKA HIGH","PVC TAPE OSAKA HIGH","","","","","","","1","","100","","","","","","TAP_1669811116.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:25:16");
INSERT INTO tbl_item VALUES("304","ABA290P","     PVC TAPE OSAKA NORMAL","PVC TAPE OSAKA NORMAL","","","","","","","1","","100","","","","","","NO_1669811249.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:27:29");
INSERT INTO tbl_item VALUES("305","ABA291P","CIRCUIT BREAKER MEP - 32A","CIRCUIT BREAKER MEP 32A","","","","","","","1","","10","","","","","","DO_1669815050.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:29:56");
INSERT INTO tbl_item VALUES("306","ABA292P","CIRCUIT BREAKER MEP - 20A","CIRCUIT BREAKER MEP - 20A","","","","","","","1","","10","","","","","","DO_1669814875.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:30:43");
INSERT INTO tbl_item VALUES("307","ABA293P","CIRCUIT BREAKER MEP - 16A","CIRCUIT BREAKER MEP - 16A","","","","","","","1","","10","","","","","","DO_1669814614.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:42:51");
INSERT INTO tbl_item VALUES("308","ABA294P","CIRCUIT BREAKER MEP - 10A","CIRCUIT BREAKER MEP - 10A","","","","","","","1","","10","","","","","","CCC_1669814099.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:43:33");
INSERT INTO tbl_item VALUES("309","ABA295P","CIRCUIT BREAKER MEP - 6A","CIRCUIT BREAKER MEP - 6A","","","","","","","1","","10","","","","","","DO_1669814996.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:44:11");
INSERT INTO tbl_item VALUES("310","ABA296P","     PVC TAPE SUPER STAR","PVC TAPE SUPER STAR","","","","","","","1","","10","","","","","","SST_1669812320.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:45:20");
INSERT INTO tbl_item VALUES("311","ABA297P","     PVC TAPE WALTON","PVC TAPE WALTON","","","","","","","1","","10","","","","","","WA_1669812390.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:46:30");
INSERT INTO tbl_item VALUES("312","ABA298P","     CIRCUIT BREAKER MEP DUBLE - 32A","CIRCUIT BREAKER MEP DUBLE - 32A","","","","","","","1","","10","","","","","","DO_1669812580.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:49:40");
INSERT INTO tbl_item VALUES("313","ABA299P","CIRCUIT BREAKER ESPN - 16A","CIRCUIT BREAKER ESPN - 16A","","","","","","","1","","10","","","","","","DO_1669820528.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:55:42");
INSERT INTO tbl_item VALUES("314","ABA300P","     CIRCUIT BREAKER CLICK - 16A","CIRCUIT BREAKER CLICK - 16A","","","","","","","1","","10","","","","","","CCC_1669813022.jpg","0.00","0.00","0","0","1","1","2022-11-30 06:57:02");
INSERT INTO tbl_item VALUES("315","ABA301P","     CIRCUIT BREAKER CLICK - 20A","CIRCUIT BREAKER CLICK - 20A","","","","","","","1","","10","","","","","","CCC_1669813235.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:00:35");
INSERT INTO tbl_item VALUES("316","ABA302P","     CIRCUIT BREAKER CLICK - 10A","CIRCUIT BREAKER CLICK - 10A","","","","","","","1","","10","","","","","","CCC_1669813350.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:02:30");
INSERT INTO tbl_item VALUES("317","ABA303P","     CIRCUIT BREAKER CLICK - 32A","CIRCUIT BREAKER CLICK - 32A","","","","","","","1","","20","","","","","","CCC_1669813417.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:03:37");
INSERT INTO tbl_item VALUES("318","ABA304P","     CIRCUIT BREAKER CLICK - 6A","CIRCUIT BREAKER CLICK - 6A","","","","","","","1","","10","","","","","","CCC_1669813518.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:05:18");
INSERT INTO tbl_item VALUES("319","ABA305P","Dahua DH-HAC-HDW1209TLQP--LED/HAC-HDW1209CLQP--LED 2M Color HDCVI","DAHUA FULL COLOR EYEBALL CAMERA - HDW1209TLQP-A-LED","","","20","","","","1","","5","","","","","","SDA_1669815475.png","0.00","0.00","0","0","1","1","2022-11-30 07:37:55");
INSERT INTO tbl_item VALUES("320","ABA306P","   CAMERA  HD CAMERA INFRARED WATERPROOF - IPC-V380-K6","HD CAMERA INFRARED WATERPROOF - IPC-V380-K6","","","20","","","","1","","5","","","","","","HD_1669815576.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:39:36");
INSERT INTO tbl_item VALUES("321","ABA307P","   CAMERA  PC/WEB CAMERA MINI PACKING","PC/WEB CAMERA MINI PACKING","","","20","","","","1","","5","","","","","","MINI_1669815652.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:40:52");
INSERT INTO tbl_item VALUES("322","ABA308P","   CAMERA  DAHUA FULL COLOR BULLET CAMERA - HFW1209CP-LED","DAHUA FULL COLOR BULLET CAMERA - HFW1209CP-LED","","","20","","","","1","","5","","","","","","COL_1669816008.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:46:47");
INSERT INTO tbl_item VALUES("323","ABA309P","   CAMERA  DAHUA IR BULLET CAMERA - HFW1200TLP","DAHUA IR BULLET CAMERA - HFW1200TLP","","","20","","","","1","","5","","","","","","TLP_1669816121.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:48:41");
INSERT INTO tbl_item VALUES("324","ABA310P","   CAMERA  DAHUA IR EYEBALL CAMERA - HDW1200EMP","DAHUA IR EYEBALL CAMERA - HDW1200EMP","","","20","","","","1","","5","","","","","","EMP_1669816221.jpg","0.00","0.00","0","0","1","1","2022-11-30 07:50:21");
INSERT INTO tbl_item VALUES("325","ABA311P","   LIGHT  GRAMEEN ENERGY - 9WATT","GRAMEEN ENERGY - 9WATT","","","21","","","","1","","20","","","","","","Screenshot_21_1669873133.png","0.00","0.00","0","0","1","1","2022-12-01 11:38:53");
INSERT INTO tbl_item VALUES("326","ABA312P","   LIGHT  GRAMEEN ENERGY - 20WATT","GRAMEEN ENERGY - 20WATT","","","21","","","","1","","10","","","","","","Screenshot_22_1669873184.png","0.00","0.00","0","0","1","1","2022-12-01 11:39:44");
INSERT INTO tbl_item VALUES("327","ABA313P","   LIGHT  RED DRAGON LED ","RED DRAGON LED ","","","21","","","","1","","10","","","","","","Screenshot_23_1669873284.png","0.00","0.00","0","0","1","1","2022-12-01 11:41:24");
INSERT INTO tbl_item VALUES("328","ABA314P","ELECTRIC SWITCH - KITTY","KITTY SWITCH","","","","","","","1","","20","","","","","","Screenshot_24_1669880878.png","0.00","0.00","0","0","1","1","2022-12-01 01:47:58");
INSERT INTO tbl_item VALUES("329","ABA315P","ELECTRIC SOCKET - KITTY","Kitty SOCKET ","","","","","","","1","","10","","","","","","2P_1669881048.jpg","0.00","0.00","0","0","1","1","2022-12-01 01:50:48");
INSERT INTO tbl_item VALUES("330","ABA316P","ELECTRIC INDICATOR - KITTY ","KITTY ANTICATOR","","","","","","","1","","10","","","","","","Screenshot_25_1669887264.png","0.00","0.00","0","0","1","1","2022-12-01 03:34:23");
INSERT INTO tbl_item VALUES("331","ABA317P","ELECTRIC FUSES - KITTY ","KITTY FUSES","","","","","","","1","","10","","","","","","fuses_1669887811.jpg","0.00","0.00","0","0","1","1","2022-12-01 03:43:31");
INSERT INTO tbl_item VALUES("332","ABA318P","ELECTRIC SWITCH - SUPER STAR ","SUPER STAR SWITCH","","","","","","","1","","10","","","","","","SU_1669893351.jpg","0.00","0.00","0","0","1","1","2022-12-01 03:47:50");
INSERT INTO tbl_item VALUES("333","ABA319P","ELECTRIC SOCKET - SUPER STAR","SUPER STAR SOCKET","","","","","","","1","","10","","","","","","Premium-2-Pin-Socket-1_1669888126.png","0.00","0.00","0","0","1","1","2022-12-01 03:48:46");
INSERT INTO tbl_item VALUES("334","ABA320P","ELECTRIC INDICATOR - SUPER STAR","SUPER STAR INDICATOR","","","","","","","1","","10","","","","","","Premium-Indicator-2_1669888201.png","0.00","0.00","0","0","1","1","2022-12-01 03:50:00");
INSERT INTO tbl_item VALUES("335","ABA321P","ELECTRIC SWITCH - MEP","MEP SWITCH","","","","","","","1","","10","","","","","","MEP_1669888268.jpg","0.00","0.00","0","0","1","1","2022-12-01 03:51:08");
INSERT INTO tbl_item VALUES("336","ABA322P","ELECTRIC SOCKET - MEP","MEP SOCKET","","","","","","","1","","10","","","","","","SC_1669888407.jpg","0.00","0.00","0","0","1","1","2022-12-01 03:53:27");
INSERT INTO tbl_item VALUES("337","ABA323P","ELECTRIC INDICATOR - MEP ","MEP INDICATOR","","","","","","","1","","10","","","","","","Premium-Indicator-2_1669888445.png","0.00","0.00","0","0","1","1","2022-12-01 03:54:05");
INSERT INTO tbl_item VALUES("339","ABA325P","     MSM SOCKET","MSM SOCKET","","","","","","","1","","10","","","","","","Premium-2-Pin-Socket-1_1669888624.png","0.00","0.00","0","0","1","1","2022-12-01 03:57:04");
INSERT INTO tbl_item VALUES("340","ABA326P","     MSM INDICATOR","MSM INDICATOR","","","","","","","1","","10","","","","","","Premium-Indicator-2_1669888682.png","0.00","0.00","0","0","1","1","2022-12-01 03:58:02");
INSERT INTO tbl_item VALUES("341","ABA327P","ADAR SWITCH ","ADAR SWITCH","","","","","","","1","","10","","","","","","ADA_1669890629.png","0.00","0.00","0","0","1","1","2022-12-01 04:30:29");
INSERT INTO tbl_item VALUES("342","ABA328P","     ADAR SOCKET","ADAR SOCKET","","","","","","","1","","10","","","","","","ADA_1669890652.png","0.00","0.00","0","0","1","1","2022-12-01 04:30:52");
INSERT INTO tbl_item VALUES("343","ABA329P","     ADAR INDICATOR","ADAR INDICATOR","","","","","","","1","","10","","","","","","ADA_1669890693.png","0.00","0.00","0","0","1","1","2022-12-01 04:31:33");
INSERT INTO tbl_item VALUES("344","ABA330P","     TOP ONE SWITCH","TOP ONE SWITCH","","","","","","","1","","10","","","","","","TOP_1669890763.png","0.00","0.00","0","0","1","1","2022-12-01 04:32:43");
INSERT INTO tbl_item VALUES("346","ABA332P","     R.S FIHAD STAR SOCKET","R.S FIHAD STAR SOCKET","","","","","","","1","","10","","","","","","RS_1669890879.png","0.00","0.00","0","0","1","1","2022-12-01 04:34:39");
INSERT INTO tbl_item VALUES("347","ABA333P","     LAVINA SWITCH","LAVINA SWITCH","","","","","","","1","","10","","","","","","LAV_1669890944.png","0.00","0.00","0","0","1","1","2022-12-01 04:35:44");
INSERT INTO tbl_item VALUES("348","ABA334P","LAVINA SOCKET","LAVINA SOCKET","","","","","","","1","","10","","","","","","LAV_1669893120.png","0.00","0.00","0","0","1","1","2022-12-01 04:36:39");
INSERT INTO tbl_item VALUES("349","ABA335P","     LAVINA INDICATOR","LAVINA INDICATOR","","","","","","","1","","10","","","","","","LAV_1669891033.png","0.00","0.00","0","0","1","1","2022-12-01 04:37:13");
INSERT INTO tbl_item VALUES("350","ABA336P","TWO PIN PLUG - HTI","TWO PIN PLUG - HTI","","","","","","","1","","10","","","","","","Screenshot_232_1673244811.png","0.00","0.00","0","0","1","1","2022-12-01 04:41:17");
INSERT INTO tbl_item VALUES("351","ABA337P","BATTEN HOLDER - WALTON","BATTEN HOLDER - WALTON","","","","","","","1","","10","","","","","","DDA_1669891350.png","0.00","0.00","0","0","1","1","2022-12-01 04:42:30");
INSERT INTO tbl_item VALUES("352","ABA338P","BATTEN HOLDER WALTON - PIN","BATTEN HOLDER WALTON - PIN","","","","","","","1","","10","","","","","","DDA_1669891479.png","0.00","0.00","0","0","1","1","2022-12-01 04:44:39");
INSERT INTO tbl_item VALUES("353","ABA339P","BATTEN HOLDER WALTON - PESS","BATTEN HOLDER WALTON - PESS","","","","","","","1","","10","","","","","","DDA_1669891577.png","0.00","0.00","0","0","1","1","2022-12-01 04:46:17");
INSERT INTO tbl_item VALUES("354","ABA340P","BATTEN HOLDER - MSM","BATTEN HOLDER - MSM","","","","","","","1","","10","","","","","","MSM_1669891718.png","0.00","0.00","0","0","1","1","2022-12-01 04:48:38");
INSERT INTO tbl_item VALUES("355","ABA341P","BATTEN HOLDER - MUM","BATTEN HOLDER - MUM","","","","","","","1","","10","","","","","","MUM_1669891780.png","0.00","0.00","0","0","1","1","2022-12-01 04:49:40");
INSERT INTO tbl_item VALUES("357","ABA343P","PENDANT HOLDER MEP - PESS","PENDANT HOLDER MEP - PESS","","","","","","","1","","10","","","","","","Screenshot_26_1669892275.png","0.00","0.00","0","0","1","1","2022-12-01 04:57:55");
INSERT INTO tbl_item VALUES("358","ABA344P","     PENDANT HOLDER T-10","PENDANT HOLDER T-10","","","","","","","1","","10","","","","","","Screenshot_27_1669892399.png","0.00","0.00","0","0","1","1","2022-12-01 04:59:59");
INSERT INTO tbl_item VALUES("359","ABA345P","PENDANT HOLDER - ROCK STAR","PENDANT HOLDER - ROCK STAR","","","","","","","1","","10","","","","","","RSC_1669892495.png","0.00","0.00","0","0","1","1","2022-12-01 05:01:35");
INSERT INTO tbl_item VALUES("360","ABA346P","PENDANT HOLDER - MSM","PENDANT HOLDER MSM","","","","","","","1","","10","","","","","","MSD_1669892562.png","0.00","0.00","0","0","1","1","2022-12-01 05:02:42");
INSERT INTO tbl_item VALUES("361","ABA347P","     KASEM STAR - TWO PIN PLUG","KASEM STAR - TWO PIN PLUG","","","","","","","1","","10","","","","","","Screenshot_28_1669892781.png","0.00","0.00","0","0","1","1","2022-12-01 05:06:21");
INSERT INTO tbl_item VALUES("362","ABA348P","     POKKA - TWO PIN PLUG","POKKA - TWO PIN PLUG","","","","","","","1","","10","","","","","","Screenshot_29_1669892855.png","0.00","0.00","0","0","1","1","2022-12-01 05:07:35");
INSERT INTO tbl_item VALUES("363","ABA349P","PENDENT HOLDER HAWA","PENDENT HOLDER HAWA","","","","","","","1","","0","","","","","","HAW_1669986225.png","0.00","0.00","0","0","1","1","2022-12-01 05:20:53");
INSERT INTO tbl_item VALUES("365","ABA351P","PENDANT HOLDER - B-GAZI","PENDANT HOLDER B-GAZI","","","","","","","1","","0","","","","","","Screenshot_128_1670997784.png","0.00","0.00","0","0","1","1","2022-12-01 05:34:32");
INSERT INTO tbl_item VALUES("366","ABA352P","ELECTRIC SWITCH - MSM","ELECTRIC SWITCH MSM","","","","","","","1","","10","","","","","","Screenshot_32_1669901316.png","0.00","0.00","0","0","1","1","2022-12-01 07:28:36");
INSERT INTO tbl_item VALUES("367","ABA353P","     GDL - ELECTRIC SWITCH","GDL - ELECTRIC SWITCH","","","","","","","1","","10","","","","","","Screenshot_33_1669959232.png","0.00","0.00","0","0","1","1","2022-12-02 11:33:52");
INSERT INTO tbl_item VALUES("369","ABA355P","     GDL - ELECTRIC INDICATOR","GDL - ELECTRIC INDICATOR","","","","","","","1","","20","","","","","","Screenshot_33_1669959313.png","0.00","0.00","0","0","1","1","2022-12-02 11:35:13");
INSERT INTO tbl_item VALUES("370","ABA356P","GDL - ELECTRIC KITKAT FUSES","GDL - ELECTRIC FUSES","","","","","","","1","","10","","","","","","Screenshot_33_1669959365.png","0.00","0.00","0","0","1","1","2022-12-02 11:36:05");
INSERT INTO tbl_item VALUES("371","ABA357P","     BATTEN HOLDER - ONE FIGHTER","BATTEN HOLDER - ONE FIGHTER","","","","","","","1","","10","","","","","","Screenshot_34_1669959504.png","0.00","0.00","0","0","1","1","2022-12-02 11:38:24");
INSERT INTO tbl_item VALUES("372","ABA358P","     BATTEN HOLDER - PROTHOM ALO","BATTEN HOLDER - PROTHOM ALO","","","","","","","1","","10","","","","","","Screenshot_35_1669959575.png","0.00","0.00","0","0","1","1","2022-12-02 11:39:35");
INSERT INTO tbl_item VALUES("373","ABA359P","     BATTEN HOLDER - KITTY HIGH","BATTEN HOLDER - KITTY HIGH","","","","","","","1","","10","","","","","","Screenshot_36_1669959658.png","0.00","0.00","0","0","1","1","2022-12-02 11:40:57");
INSERT INTO tbl_item VALUES("374","ABA360P","     BATTEN HOLDER - KITTY","BATTEN HOLDER - KITTY","","","","","","","1","","10","","","","","","Screenshot_37_1669959715.png","0.00","0.00","0","0","1","1","2022-12-02 11:41:55");
INSERT INTO tbl_item VALUES("375","ABA361P","     BATTEN HOLDER - AUTO POWER","BATTEN HOLDER - AUTO POWER","","","","","","","1","","10","","","","","","Screenshot_38_1669959781.png","0.00","0.00","0","0","1","1","2022-12-02 11:43:01");
INSERT INTO tbl_item VALUES("376","ABA362P","     BATTEN HOLDER ANIK - PESS + PIN","BATTEN HOLDER ANIK - PESS + PIN","","","","","","","1","","10","","","","","","Screenshot_39_1669959860.png","0.00","0.00","0","0","1","1","2022-12-02 11:44:20");
INSERT INTO tbl_item VALUES("377","ABA363P","     SIX PIN SOCKET - R.E","SIX PIN SOCKET - R.E","","","","","","","1","","10","","","","","","Screenshot_40_1669960020.png","0.00","0.00","0","0","1","1","2022-12-02 11:47:00");
INSERT INTO tbl_item VALUES("378","ABA364P","     EIGHT PIN SOCKET LIVON","EIGHT PIN SOCKET LIVON","","","","","","","1","","10","","","","","","Screenshot_41_1669960216.png","0.00","0.00","0","0","1","1","2022-12-02 11:50:16");
INSERT INTO tbl_item VALUES("379","ABA365P","     THREE PIN SOCKET - EMK","THREE PIN SOCKET - EMK","","","","","","","1","","10","","","","","","Screenshot_42_1669960304.png","0.00","0.00","0","0","1","1","2022-12-02 11:51:44");
INSERT INTO tbl_item VALUES("380","ABA366P","     THREE PIN SOCKET - MEB","THREE PIN SOCKET - MEB","","","","","","","1","","10","","","","","","Screenshot_43_1669960386.png","0.00","0.00","0","0","1","1","2022-12-02 11:53:06");
INSERT INTO tbl_item VALUES("381","ABA367P","3 PIN SOCKET - NOKIA","MOBILE MULTI SOCKET - NOKIA","","","","","","","1","","10","","","","","","Screenshot_44_1669960465.png","0.00","0.00","0","0","1","1","2022-12-02 11:54:25");
INSERT INTO tbl_item VALUES("382","ABA368P","     THREE PIN MULTI SOCKET - HTI","THREE PIN MULTI SOCKET - HTI","","","","","","","1","","10","","","","","","Screenshot_45_1669960619.png","0.00","0.00","0","0","1","1","2022-12-02 11:56:59");
INSERT INTO tbl_item VALUES("383","ABA369P","BASE ADAPTER  PESS + PIN - 5 STAR","PESS + PIN - 5 STAR","","","","","","","1","","10","","","","","","Screenshot_46_1669962395.png","0.00","0.00","0","0","1","1","2022-12-02 12:26:35");
INSERT INTO tbl_item VALUES("385","ABA371P","     IPS THREE PIN PLUG - MEP - P-20","IPS THREE PIN PLUG - MEP - P-20","","","","","","","1","","10","","","","","","Screenshot_48_1669964150.png","0.00","0.00","0","0","1","1","2022-12-02 12:55:50");
INSERT INTO tbl_item VALUES("386","ABA372P","     IPS THREE PIN PLUG - MEP - P-187","IPS THREE PIN PLUG - MEP - P-187","","","","","","","1","","10","","","","","","Screenshot_49_1669964190.png","0.00","0.00","0","0","1","1","2022-12-02 12:56:30");
INSERT INTO tbl_item VALUES("387","ABA373P","     IPS THREE PIN PLUG - HITEK","IPS THREE PIN PLUG - HITEK","","","","","","","1","","10","","","","","","Screenshot_50_1669964263.png","0.00","0.00","0","0","1","1","2022-12-02 12:57:43");
INSERT INTO tbl_item VALUES("388","ABA374P","     CIRCUIT BREAKER - MEP - L1","CIRCUIT BREAKER - MEP - L1","","","","","","","1","","10","","","","","","Screenshot_51_1669964452.png","0.00","0.00","0","0","1","1","2022-12-02 01:00:52");
INSERT INTO tbl_item VALUES("389","ABA375P","     CIRCUIT BREAKER - MEP - L2","CIRCUIT BREAKER - MEP - L2","","","","","","","1","","10","","","","","","Screenshot_52_1669964631.png","0.00","0.00","0","0","1","1","2022-12-02 01:03:51");
INSERT INTO tbl_item VALUES("390","ABA376P","     CIRCUIT BREAKER - ESPN - L1","CIRCUIT BREAKER - ESPN - L1","","","","","","","1","","10","","","","","","Screenshot_53_1669964754.png","0.00","0.00","0","0","1","1","2022-12-02 01:05:54");
INSERT INTO tbl_item VALUES("391","ABA377P","     CIRCUIT BREAKER - ESPN - L2","CIRCUIT BREAKER - ESPN - L2","","","","","","","1","","10","","","","","","Screenshot_53_1669964797.png","0.00","0.00","0","0","1","1","2022-12-02 01:06:37");
INSERT INTO tbl_item VALUES("392","ABA378P","     TIE CABLE 300MM","TIE CABLE 300MM","","","","","","","1","","10","","","","","","300_1669964969.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:09:29");
INSERT INTO tbl_item VALUES("393","ABA379P","TIE CABLE 150MM","TIE CABLE 150MM","","","","","","","13","","10","","","","","","150_1669964995.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:09:55");
INSERT INTO tbl_item VALUES("394","ABA380P","     TIE CABLE 200MM","TIE CABLE 200MM","","","","","","","1","","10","","","","","","200S_1669965125.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:12:05");
INSERT INTO tbl_item VALUES("395","ABA381P","     TIE CABLE 250MM","TIE CABLE 250MM","","","","","","","1","","10","","","","","","250_1669965155.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:12:35");
INSERT INTO tbl_item VALUES("396","ABA382P","     TIE CABLE 100MM","TIE CABLE 100MM","","","","","","","1","","10","","","","","","100A_1669965212.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:13:32");
INSERT INTO tbl_item VALUES("397","ABA383P","CABLE CLIP - 20MM","CABLE CLIP - 20MM","","","","","","","14","","0","","","","","","20M_1669965296.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:14:56");
INSERT INTO tbl_item VALUES("398","ABA384P","CABLE CLIP - 16MM","CABLE CLIP - 16MM","","","","","","","1","","10","","","","","","Screenshot_125_1670942791.png","0.00","0.00","0","0","1","1","2022-12-02 01:15:49");
INSERT INTO tbl_item VALUES("399","ABA385P","CABLE CLIP - 14MM","CABLE CLIP - 14MM","","","","","","","1","","0","","","","","","14M_1669965405.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:16:45");
INSERT INTO tbl_item VALUES("400","ABA386P","CABLE CLIP - 10MM","CABLE CLIP - 10MM","","","","","","","14","","10","","","","","","10M_1669965445.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:17:25");
INSERT INTO tbl_item VALUES("401","ABA387P","CABLE CLIP - 8MM","CABLE CLIP - 8MM","","","","","","","14","","0","","","","","","8mm_1669965493.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:18:13");
INSERT INTO tbl_item VALUES("402","ABA388P","CABLE CLIP - 7MM","CABLE CLIP - 7MM","","","","","","","14","","0","","","","","","7M_1669965540.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:19:00");
INSERT INTO tbl_item VALUES("403","ABA389P","CABLE CLIP - 6MM","CABLE CLIP - 6MM","","","","","","","14","","0","","","","","","6MM_1669965589.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:19:49");
INSERT INTO tbl_item VALUES("404","ABA390P","CABLE CLIP - 5MM","CABLE CLIP - 5MM","","","","","","","14","","0","","","","","","5MM_1669965611.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:20:11");
INSERT INTO tbl_item VALUES("405","ABA391P","CABLE CLIP - 4MM","CABLE CLIP - 4MM","","","","","","","14","","0","","","","","","4MM_1669965640.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:20:40");
INSERT INTO tbl_item VALUES("406","ABA392P","     PACKING TAPE - 50 WAY","PACKING TAPE - 50 WAY","","","","","","","1","","10","","","","","","50WAY_1669965688.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:21:28");
INSERT INTO tbl_item VALUES("407","ABA393P","     PACKING TAPE - 100 WAY","PACKING TAPE - 100 WAY","","","","","","","1","","10","","","","","","100WAY_1669965733.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:22:13");
INSERT INTO tbl_item VALUES("408","ABA394P","     PACKING TAPE - 150 WAY","PACKING TAPE - 150 WAY","","","","","","","1","","10","","","","","","150W_1669965776.png","0.00","0.00","0","0","1","1","2022-12-02 01:22:56");
INSERT INTO tbl_item VALUES("409","ABA395P","     PACKING TAPE - 200 WAY","PACKING TAPE - 200 WAY","","","","","","","1","","10","","","","","","200W_1669965813.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:23:33");
INSERT INTO tbl_item VALUES("410","ABA396P","MK BOX - 1 GANG","MK BOX 1 GANG","","","","","","","1","","10","","","","","","Screenshot_54_1669965909.png","0.00","0.00","0","0","1","1","2022-12-02 01:25:09");
INSERT INTO tbl_item VALUES("411","ABA397P","     MK BOX - 2 GANG","MK BOX - 2 GANG","","","","","","","1","","10","","","","","","2MK_1669965988.png","0.00","0.00","0","0","1","1","2022-12-02 01:26:28");
INSERT INTO tbl_item VALUES("412","ABA398P","     MK BOX - 3 GANG","MK BOX - 3 GANG","","","","","","","1","","10","","","","","","3G_1669966039.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:27:19");
INSERT INTO tbl_item VALUES("413","ABA399P","     MK BOX - 4 GANG","MK BOX - 4 GANG","","","","","","","1","","10","","","","","","4G_1669966084.jpg","0.00","0.00","0","0","1","1","2022-12-02 01:28:04");
INSERT INTO tbl_item VALUES("414","ABA400P","     TWO PIN SOCKET - MITU","TWO PIN SOCKET - MITU","","","","","","","1","","10","","","","","","Screenshot_55_1669973277.png","0.00","0.00","0","0","1","1","2022-12-02 03:27:57");
INSERT INTO tbl_item VALUES("415","ABA401P","     PUSH BUTTON SWITCH","PUSH BUTTON SWITCH","","","","","","","1","","10","","","","","","Screenshot_56_1669973465.png","0.00","0.00","0","0","1","1","2022-12-02 03:31:05");
INSERT INTO tbl_item VALUES("416","ABA402P","     BREAKER SWITCH","BREAKER SWITCH","","","","","","","1","","10","","","","","","Screenshot_57_1669973540.png","0.00","0.00","0","0","1","1","2022-12-02 03:32:20");
INSERT INTO tbl_item VALUES("417","ABA403P","     TWO PIN PLUG - MOTI","TWO PIN PLUG - MOTI","","","","","","","1","","10","","","","","","Screenshot_58_1669973608.png","0.00","0.00","0","0","1","1","2022-12-02 03:33:28");
INSERT INTO tbl_item VALUES("418","ABA404P","     IRON TWO PIN PLUG","IRON TWO PIN PLUG","","","","","","","1","","10","","","","","","Screenshot_59_1669973692.png","0.00","0.00","0","0","1","1","2022-12-02 03:34:52");
INSERT INTO tbl_item VALUES("419","ABA405P","     BIZLI CABLE - 1.0","BIZLI CABLE - 1.0","","","","","","","1","","10","","","","","","1.0_1669974089.jpeg","0.00","0.00","0","0","1","1","2022-12-02 03:41:29");
INSERT INTO tbl_item VALUES("420","ABA406P","     BIZLI CABLE - 1.3","BIZLI CABLE - 1.3","","","","","","","1","","10","","","","","","1._1669974170.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:42:49");
INSERT INTO tbl_item VALUES("421","ABA407P","     BIZLI CABLE - 1.5","BIZLI CABLE - 1.5","","","","","","","1","","10","","","","","","1._1669974198.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:43:18");
INSERT INTO tbl_item VALUES("422","ABA408P","     BIZLI CABLE - 2.0","BIZLI CABLE - 2.0","","","","","","","1","","10","","","","","","1.0_1669974222.jpeg","0.00","0.00","0","0","1","1","2022-12-02 03:43:42");
INSERT INTO tbl_item VALUES("423","ABA409P","     BIZLI CABLE - 2.5","BIZLI CABLE - 2.5","","","","","","","1","","10","","","","","","1._1669974263.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:44:23");
INSERT INTO tbl_item VALUES("424","ABA410P","     BIZLI CABLE - 4.5","BIZLI CABLE - 4.5","","","","","","","1","","10","","","","","","1._1669974289.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:44:49");
INSERT INTO tbl_item VALUES("425","ABA411P","     BRB CABLE - 1.0","BRB CABLE - 1.0","","","","","","","1","","10","","","","","","BBR_1669974390.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:46:30");
INSERT INTO tbl_item VALUES("426","ABA412P","BRB CABLE C.P - 1.3","BRB CABLE - 1.3","","","","","","","4","","0","","","","","","BBR_1669974415.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:46:55");
INSERT INTO tbl_item VALUES("427","ABA413P","     BRB CABLE - 1.5","BRB CABLE - 1.5","","","","","","","1","","10","","","","","","BBR_1669974435.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:47:15");
INSERT INTO tbl_item VALUES("428","ABA414P","BRB CABLE - 2.0","BRB CABLE - 2.0","","","","","","","4","","10","","","","","","BBR_1669974455.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:47:35");
INSERT INTO tbl_item VALUES("429","ABA415P","     BRB CABLE - 2.5","BRB CABLE - 2.5","","","","","","","1","","10","","","","","","BBR_1669974478.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:47:58");
INSERT INTO tbl_item VALUES("430","ABA416P","     BRB CABLE - 4.5","BRB CABLE - 4.5","","","","","","","1","","10","","","","","","BBR_1669974506.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:48:26");
INSERT INTO tbl_item VALUES("431","ABA417P","CAPACITOR THAILAND - 2.5","CAPACITOR THAILAND - 2.5","","","","","","","1","","10","","","","","","CV_1669990588.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:49:25");
INSERT INTO tbl_item VALUES("432","ABA418P","     CAPACITOR THAILAND - 3.5","CAPACITOR THAILAND - 3.5","","","","","","","1","","10","","","","","","CV_1669974603.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:50:03");
INSERT INTO tbl_item VALUES("433","ABA419P","     CAPACITOR - 3.5","CAPACITOR - 3.5","","","","","","","1","","10","","","","","","CZ_1669974668.jpeg","0.00","0.00","0","0","1","1","2022-12-02 03:51:08");
INSERT INTO tbl_item VALUES("434","ABA420P","     CAPACITOR - 2.5","CAPACITOR - 2.5","","","","","","","1","","10","","","","","","CX_1669974734.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:52:14");
INSERT INTO tbl_item VALUES("435","ABA421P","     TUBE STARTER","TUBE STARTER","","","","","","","1","","250","","","","","","TT_1669974783.jpg","0.00","0.00","0","0","1","1","2022-12-02 03:53:03");
INSERT INTO tbl_item VALUES("436","ABA422P","     ZOOM PIANO SWITCH","ZOOM PIANO SWITCH","","","","","","","1","","10","","","","","","ZZZ_1669975095.png","0.00","0.00","0","0","1","1","2022-12-02 03:58:15");
INSERT INTO tbl_item VALUES("437","ABA423P","     BOARD - 1 WAY","BOARD - 1 WAY","","","","","","","1","","10","","","","","","1_WAY_1669975312.jpg","0.00","0.00","0","0","1","1","2022-12-02 04:01:52");
INSERT INTO tbl_item VALUES("438","ABA424P","     BOARD - 3 WAY","BOARD - 3 WAY","","","","","","","1","","10","","","","","","Screenshot_61_1669975435.png","0.00","0.00","0","0","1","1","2022-12-02 04:03:55");
INSERT INTO tbl_item VALUES("439","ABA425P","     BOARD - 2 WAY","BOARD - 2 WAY","","","","","","","1","","10","","","","","","Screenshot_60_1669975512.png","0.00","0.00","0","0","1","1","2022-12-02 04:05:12");
INSERT INTO tbl_item VALUES("440","ABA426P","     BOARD - 4 WAY","BOARD - 4 WAY","","","","","","","1","","10","","","","","","Screenshot_62_1669975555.png","0.00","0.00","0","0","1","1","2022-12-02 04:05:55");
INSERT INTO tbl_item VALUES("441","ABA427P","     BOARD - 6 WAY","BOARD - 6 WAY","","","","","","","1","","10","","","","","","images_1669975607.jpg","0.00","0.00","0","0","1","1","2022-12-02 04:06:47");
INSERT INTO tbl_item VALUES("442","ABA428P","     BOARD - 8 WAY","BOARD - 8 WAY","","","","","","","1","","10","","","","","","images (1)_1669975680.jpg","0.00","0.00","0","0","1","1","2022-12-02 04:08:00");
INSERT INTO tbl_item VALUES("443","ABA429P","BOARD 6.8","BOARD 6X8","","","","","","","1","","10","","","","","","DDS_1669975852.jpg","0.00","0.00","0","0","1","1","2022-12-02 04:10:52");
INSERT INTO tbl_item VALUES("444","ABA430P","     BOARD 8.10","BOARD 8.10","","","","","","","1","","10","","","","","","8x10_1669975979.jpg","0.00","0.00","0","0","1","1","2022-12-02 04:12:58");
INSERT INTO tbl_item VALUES("445","ABA431P","     REGULATOR MADINA POWER","REGULATOR MADINA POWER","","","","","","","1","","10","","","","","","Screenshot_63_1669982979.png","0.00","0.00","0","0","1","1","2022-12-02 06:09:39");
INSERT INTO tbl_item VALUES("446","ABA432P","     REGULATOR - SEKSON","REGULATOR - SEKSON","","","","","","","1","","10","","","","","","Screenshot_64_1669983052.png","0.00","0.00","0","0","1","1","2022-12-02 06:10:52");
INSERT INTO tbl_item VALUES("447","ABA433P","     REGULATOR + SWITCH SEKSON","REGULATOR + SWITCH SEKSON","","","","","","","1","","10","","","","","","Screenshot_65_1669983146.png","0.00","0.00","0","0","1","1","2022-12-02 06:12:26");
INSERT INTO tbl_item VALUES("448","ABA434P","     TV ANTENNA","TV ANTENNA","","","","","","","1","","10","","","","","","Screenshot_66_1669983213.png","0.00","0.00","0","0","1","1","2022-12-02 06:13:33");
INSERT INTO tbl_item VALUES("449","ABA435P","     GENERATOR SWITCH","GENERATOR SWITCH","","","","","","","1","","10","","","","","","Screenshot_67_1669983277.png","0.00","0.00","0","0","1","1","2022-12-02 06:14:37");
INSERT INTO tbl_item VALUES("450","ABA436P","MULTIPLUG MAXLINE 5M - USB212","MAXLINE - USB212","","","25","","","","1","","10","","","","","","USB_1669983442.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:17:22");
INSERT INTO tbl_item VALUES("451","ABA437P","MULTIPLUG  SAFE TOUCH - 0034 5m","SAFE TOUCH - 0033","","","25","","","","1","","0","","","","","","ST_1669983508.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:18:28");
INSERT INTO tbl_item VALUES("452","ABA438P","   MULTIPLUG  SAFE TOUCH - 0034","SAFE TOUCH - 0034","","","25","","","","1","","10","","","","","","download_1669983548.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:19:08");
INSERT INTO tbl_item VALUES("453","ABA439P","   MULTIPLUG  SAFE TOUCH - 0455","SAFE TOUCH - 0455","","","25","","","","1","","10","","","","","","STT_1669983859.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:24:19");
INSERT INTO tbl_item VALUES("454","ABA440P","   MULTIPLUG  SAFE TOUCH ST - 825","SAFE TOUCH ST - 825","","","25","","","","1","","10","","","","","","STT_1669984022.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:27:02");
INSERT INTO tbl_item VALUES("455","ABA441P","   MULTIPLUG  OMAX MINI - 401","OMAX MINI - 401","","","25","","","","1","","10","","","","","","OO_1669984129.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:28:49");
INSERT INTO tbl_item VALUES("457","ABA443P","   MULTIPLUG  REAL TOUCH MH-815","REAL TOUCH MH-815","","","25","","","","1","","10","","","","","","images (2)_1669984299.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:31:39");
INSERT INTO tbl_item VALUES("458","ABA444P","   MULTIPLUG  SAFE TOUCH - 815","SAFE TOUCH - 815","","","25","","","","1","","10","","","","","","Screenshot_68_1669984396.png","0.00","0.00","0","0","1","1","2022-12-02 06:33:16");
INSERT INTO tbl_item VALUES("459","ABA445P","MULTIPLUG  SAFE TOUCH - 0032","SAFE TOUCH - 0032","","","25","","","","1","","10","","","","","","32_1669984476.png","0.00","0.00","0","0","1","1","2022-12-02 06:34:36");
INSERT INTO tbl_item VALUES("460","ABA446P","MULTIPLUG ABC LINE - 005","MULTIPLUG ABC LINE - 005","","","25","","","","1","","10","","","","","","AB_1669984636.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:37:16");
INSERT INTO tbl_item VALUES("461","ABA447P","MULTIPLUG TARAFUL RIGID - 218","MULTIPLUG TARAFUL RIGID - 218","","","25","","","","1","","10","","","","","","TAR_1669984709.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:38:29");
INSERT INTO tbl_item VALUES("462","ABA448P","MULTIPLUG INDIGO - 911","INDIGO - 218","","","25","","","","1","","10","","","","","","IND_1669984988.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:39:29");
INSERT INTO tbl_item VALUES("463","ABA449P","   MULTIPLUG  MAXLINE - 073","MAXLINE - 073","","","25","","","","1","","10","","","","","","TAR_1669984865.jpg","0.00","0.00","0","0","1","1","2022-12-02 06:41:05");
INSERT INTO tbl_item VALUES("465","ABA451P","     CUTTER BLADE - SMALL","CUTTER BLADE - SMALL","","","","","","","1","","10","","","","","","download (1)_1670050643.jpg","0.00","0.00","0","0","1","1","2022-12-03 12:57:23");
INSERT INTO tbl_item VALUES("466","ABA452P","     CUTTER BLADE - LARGE","CUTTER BLADE - LARGE","","","","","","","1","","10","","","","","","download (2)_1670050712.jpg","0.00","0.00","0","0","1","1","2022-12-03 12:58:32");
INSERT INTO tbl_item VALUES("467","ABA453P","     KNIFE CUTTER - LARGE","KNIFE CUTTER - LARGE","","","","","","","1","","10","","","","","","download (3)_1670050772.jpg","0.00","0.00","0","0","1","1","2022-12-03 12:59:32");
INSERT INTO tbl_item VALUES("468","ABA454P","     KNIFE CUTTER - SMALL","KNIFE CUTTER - SMALL","","","","","","","1","","10","","","","","","download (4)_1670050822.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:00:22");
INSERT INTO tbl_item VALUES("469","ABA455P","     GANG SERIES SWITCH - 1 WAY","GANG SERIES SWITCH - 1 WAY","","","","","","","1","","10","","","","","","images (3)_1670051031.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:03:51");
INSERT INTO tbl_item VALUES("470","ABA456P","     GANG SERIES SWITCH - 2 WAY","GANG SERIES SWITCH - 2 WAY","","","","","","","1","","10","","","","","","Screenshot_70_1670051091.png","0.00","0.00","0","0","1","1","2022-12-03 01:04:51");
INSERT INTO tbl_item VALUES("471","ABA457P","     GANG SERIES SWITCH - 3 WAY","GANG SERIES SWITCH - 3 WAY","","","","","","","1","","10","","","","","","Screenshot_71_1670051142.png","0.00","0.00","0","0","1","1","2022-12-03 01:05:42");
INSERT INTO tbl_item VALUES("472","ABA458P","     GANG SERIES SWITCH - 4 WAY","GANG SERIES SWITCH - 4 WAY","","","","","","","1","","10","","","","","","Screenshot_71_1670051302.png","0.00","0.00","0","0","1","1","2022-12-03 01:08:21");
INSERT INTO tbl_item VALUES("473","ABA459P","AV CORD 1.5M","AV CORD","","","","","","","1","","10","","","","","","AV_1670051398.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:09:58");
INSERT INTO tbl_item VALUES("474","ABA460P","     NET CABLE - 1M","NET CABLE - 1M","","","","","","","1","","10","","","","","","1M_1670051453.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:10:53");
INSERT INTO tbl_item VALUES("475","ABA461P","     NET CABLE - 2M","NET CABLE - 2M","","","","","","","1","","10","","","","","","2M_1670051495.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:11:35");
INSERT INTO tbl_item VALUES("476","ABA462P","     NET CABLE - 3M","NET CABLE - 3M","","","","","","","1","","10","","","","","","3M_1670051841.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:17:21");
INSERT INTO tbl_item VALUES("477","ABA463P","     NET CABLE - 5M","NET CABLE - 5M","","","","","","","1","","10","","","","","","Screenshot_72_1670051922.png","0.00","0.00","0","0","1","1","2022-12-03 01:18:42");
INSERT INTO tbl_item VALUES("478","ABA464P","HDMI CABLE - 15M","HDMI - 10M","","","","","","","1","","10","","","","","","10MF_1670052914.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:35:14");
INSERT INTO tbl_item VALUES("479","ABA465P","HDMI CABLE - 1M","HDMI - 1M","","","","","","","1","","10","","","","","","1MM_1670052962.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:36:02");
INSERT INTO tbl_item VALUES("480","ABA466P","HDMI CABLE - 1.5M","HDMI - 1.5M","","","","","","","1","","10","","","","","","1.5M_1670053020.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:37:00");
INSERT INTO tbl_item VALUES("481","ABA467P","HDMI CABLE - 2M","HDMI - 2M","","","","","","","1","","10","","","","","","2MM_1670053072.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:37:52");
INSERT INTO tbl_item VALUES("482","ABA468P","HDMI CABLE - 3M","HDMI - 3M","","","","","","","1","","10","","","","","","3MM_1670053114.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:38:34");
INSERT INTO tbl_item VALUES("483","ABA469P","     HDMI CABLE - 5M","HDMI CABLE - 5M","","","","","","","1","","10","","","","","","5M_1670053171.jpg","0.00","0.00","0","0","1","1","2022-12-03 01:39:31");
INSERT INTO tbl_item VALUES("484","ABA470P","ROUTER  TENDA 03","TENDA 03","","","11","","","","1","","0","","","","","","03_1670180986.jpg","0.00","0.00","365","0","1","1","2022-12-05 01:09:46");
INSERT INTO tbl_item VALUES("485","ABA471P","NETWORK SWITCH  NETIS GIGABIT 8 PORT","NETIS GIGABIT 8 PORT","","","13","","","","1","","10","","","","","","888_1670187489.jpg","0.00","0.00","0","1","1","1","2022-12-05 02:58:09");
INSERT INTO tbl_item VALUES("486","ABA472P","VGA CABLE - 15 METER","VGA CABLE - 15 METER","","","","","","","1","","5","","","","","","giant_1670196171.jpg","0.00","0.00","0","0","1","1","2022-12-05 05:22:51");
INSERT INTO tbl_item VALUES("487","ABA473P","     VIDEO BALUN 2MP ","VIDEO BALUN 2MP ","","","","","","","1","","10","","","","","","VB_1670197767.jpg","0.00","0.00","0","0","1","1","2022-12-05 05:49:27");
INSERT INTO tbl_item VALUES("488","ABA474P","     VIDEO BALUN 8MP ","VIDEO BALUN 8MP ","","","","","","","1","","10","","","","","","8MP_1670197816.png","0.00","0.00","0","0","1","1","2022-12-05 05:50:16");
INSERT INTO tbl_item VALUES("489","ABA475P","     DISH CONNECTOR HIGH","DISH CONNECTOR HIGH","","","","","","","1","","10","","","","","","HHJ_1670203018.jpg","0.00","0.00","0","0","1","1","2022-12-05 07:16:58");
INSERT INTO tbl_item VALUES("490","ABA476P","   CAMERA  WIFI SMART IP CAMERA - V380-Q5SY-30","WIFI SMART IP CAMERA - V380-Q5SY-30","","","20","","","","1","","10","","","","","","Nirapotta-10_1670203944.jpg","0.00","0.00","0","0","1","1","2022-12-05 07:32:24");
INSERT INTO tbl_item VALUES("491","ABA477P","CAT  D-LINK OUTDOOR BOX FULL CAT-6","D-LINK OUTDOOR BOX FULL CAT-6","","","14","","","","24","","0","","","","","","44f_1670250634.jpg","0.00","0.00","0","0","1","1","2022-12-05 08:30:34");
INSERT INTO tbl_item VALUES("492","ABA478P","     LAN CONNECTOR WASHER","LAN CONNECTOR WASHER","","","","","","","1","","0","","","","","","was_1670309372.png","0.00","0.00","0","0","1","1","2022-12-06 12:49:32");
INSERT INTO tbl_item VALUES("493","ABA479P","     VGA CABLE - 10 METER","VGA CABLE - 10 METER","","","","","","","1","","0","","","","","","10MMM_1670357830.jpg","0.00","0.00","0","0","1","1","2022-12-07 02:17:09");
INSERT INTO tbl_item VALUES("494","ABA480P","     VGA CABLE - 5 METER","VGA CABLE - 5 METER","","","","","","","1","","0","","","","","","5MMM_1670357908.jpg","0.00","0.00","0","0","1","1","2022-12-07 02:18:28");
INSERT INTO tbl_item VALUES("495","ABA481P","     VGA CABLE - 3 METER","VGA CABLE - 3 METER","","","","","","","1","","0","","","","","","3MMM_1670357929.jpg","0.00","0.00","0","0","1","1","2022-12-07 02:18:49");
INSERT INTO tbl_item VALUES("496","ABA482P","     VGA CABLE - 1.5 METER","VGA CABLE - 1.5 METER","","","","","","","1","","0","","","","","","1.5MM_1670357952.jpg","0.00","0.00","0","0","1","1","2022-12-07 02:19:12");
INSERT INTO tbl_item VALUES("497","ABA483P","NODE  4 OUTPUT HYBRID -12bBm","4 OUTPUT HYBRID -12bBm","","","15","","","","24","","0","","","","","","Screenshot_73_1670360288.png","0.00","0.00","0","0","1","1","2022-12-07 02:58:07");
INSERT INTO tbl_item VALUES("502","ABA484P","     NET VERIBAL PLUG ","NET VERIBAL PLUG ","","","","","","","1","","0","","","","","","Screenshot_75_1670370900.png","0.00","0.00","0","0","1","1","2022-12-07 05:55:00");
INSERT INTO tbl_item VALUES("503","ABA485P","     FIBER INSULATOR","FIBER INSULATOR","","","","","","","1","","0","","","","","","2-_1670371215.jpg","0.00","0.00","0","0","1","1","2022-12-07 06:00:15");
INSERT INTO tbl_item VALUES("504","ABA486P","     NET ADAPTER ","NET ADAPTER ","","","","","","","1","","0","","","","","","Screenshot_77_1670371917.png","0.00","0.00","0","0","1","1","2022-12-07 06:11:57");
INSERT INTO tbl_item VALUES("505","ABA487P","   RG - 6  RED DRAGON MIX - 1.7WAY","RED DRAGON MIX - 1.7WAY","","","18","","","","24","","0","","","","","","77_1670385316.png","0.00","0.00","0","0","1","1","2022-12-07 09:55:16");
INSERT INTO tbl_item VALUES("506","ABA488P","   RG - 6  RED DRAGON TAMA - 1.8 WAY   ","RED DRAGON TAMA - 1.8 WAY   ","","","18","","","","24","","0","","","","","","FB_1670385691.jpg","0.00","0.00","0","0","1","1","2022-12-07 10:01:31");
INSERT INTO tbl_item VALUES("507","ABA489P","UPS WGP","UPS WGP","","","","","","","1","","0","","","","","","DDSS_1670386257.png","0.00","0.00","0","2","1","1","2022-12-07 10:10:57");
INSERT INTO tbl_item VALUES("508","ABA490P","   LIGHT  COSCO LED - 15WATT","COSCO LED - 15WATT","","","21","","","","1","","0","","","","","","Screenshot_78_1670426407.png","0.00","0.00","365","0","1","1","2022-12-07 09:20:07");
INSERT INTO tbl_item VALUES("509","ABA491P","     RG-6 CUTTER","RG-6 CUTTER","","","","","","","1","","0","","","","","","Screenshot_79_1670476966.png","0.00","0.00","0","0","1","1","2022-12-08 11:22:46");
INSERT INTO tbl_item VALUES("510","ABA492P","   RG - 6  SATELLITE VISION MIX - 100M","SATELLITE VISION MIX - 100M","","","18","","","","24","","0","","","","","","TA_1670480082.jpg","0.00","0.00","0","0","1","1","2022-12-08 12:14:41");
INSERT INTO tbl_item VALUES("511","ABA493P","   RG - 6  AR-LINK MIX - 1.5 WAY","AR-LINK MIX - 1.5 WAY","","","18","","","","1","","0","","","","","","AR_1670480681.png","0.00","0.00","0","0","1","1","2022-12-08 12:24:41");
INSERT INTO tbl_item VALUES("512","ABA494P","     FLUID LEVEL CONTROLLER","FLUID LEVEL CONTROLLER","","","","","","","1","","0","","","","","","SSD_1670515275.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:01:15");
INSERT INTO tbl_item VALUES("513","ABA495P","     CAM STARTER","CAM STARTER","","","","","","","1","","0","","","","","","Screenshot_80_1670515559.png","0.00","0.00","0","0","1","1","2022-12-08 10:05:59");
INSERT INTO tbl_item VALUES("514","ABA496P","     SWITCH CLICK","SWITCH CLICK","","","","","","","1","","0","","","","","","CLICK-Premium-4-Gang-1way-switch_1670515734.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:08:54");
INSERT INTO tbl_item VALUES("515","ABA497P","     INDICATOR CLICK","INDICATOR CLICK","","","","","","","1","","0","","","","","","Click-Supreme-Piano-Indicator_1670515791.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:09:51");
INSERT INTO tbl_item VALUES("516","ABA498P","     CAPACITOR ICAR","CAPACITOR ICAR","","","","","","","1","","0","","","","","","Screenshot_81_1670516102.png","0.00","0.00","0","0","1","1","2022-12-08 10:15:02");
INSERT INTO tbl_item VALUES("517","ABA499P","CIRCUIT BREAKER CLICK DOUBLE  - 40A","CIRCUIT BREAKER CLICK - 40A","","","","","","","1","","0","","","","","","40MM_1670516511.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:19:11");
INSERT INTO tbl_item VALUES("518","ABA500P","     KITKAT FUSE LAVINA","KITKAT FUSE LAVINA","","","","","","","1","","0","","","","","","Screenshot_82_1670517251.png","0.00","0.00","0","0","1","1","2022-12-08 10:34:11");
INSERT INTO tbl_item VALUES("519","ABA501P","     KITKAT ALL ","KITKAT ALL ","","","","","","","1","","0","","","","","","Screenshot_82_1670517986.png","0.00","0.00","0","0","1","1","2022-12-08 10:46:26");
INSERT INTO tbl_item VALUES("520","ABA502P","     BELLPUSH","BELLPUSH","","","","","","","1","","0","","","","","","download (5)_1670518042.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:47:22");
INSERT INTO tbl_item VALUES("521","ABA503P","     THREE PIN SOCKET - MEP","THREE PIN SOCKET - MEP","","","","","","","1","","0","","","","","","SSC_1670518387.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:53:07");
INSERT INTO tbl_item VALUES("522","ABA504P","     THREE PIN SOCKET - PIXEL","THREE PIN SOCKET - PIXEL","","","","","","","1","","0","","","","","","SSC_1670518521.jpg","0.00","0.00","0","0","1","1","2022-12-08 10:55:21");
INSERT INTO tbl_item VALUES("523","ABA505P","     ELECTRIC INDICATOR - WALTON","ELECTRIC INDICATOR - WALTON","","","","","","","1","","0","","","","","","Screenshot_83_1670767400.png","0.00","0.00","0","0","1","1","2022-12-11 08:03:20");
INSERT INTO tbl_item VALUES("524","ABA506P","     ELECTRIC SWITCH WALTON","ELECTRIC SWITCH WALTON","","","","","","","1","","0","","","","","","Screenshot_84_1670767775.png","0.00","0.00","0","0","1","1","2022-12-11 08:09:35");
INSERT INTO tbl_item VALUES("525","ABA507P","     ELECTRIC SOCKET - WALTON","ELECTRIC SOCKET - WALTON","","","","","","","1","","0","","","","","","Screenshot_85_1670767917.png","0.00","0.00","0","0","1","1","2022-12-11 08:11:57");
INSERT INTO tbl_item VALUES("526","ABA508P","     BED SWITCH","BED SWITCH","","","","","","","1","","0","","","","","","Screenshot_86_1670768046.png","0.00","0.00","0","0","1","1","2022-12-11 08:14:06");
INSERT INTO tbl_item VALUES("528","ABA510P","     CELLING ROSE - ONE FIGHTER","CELLING ROSE - ONE FIGHTER","","","","","","","1","","0","","","","","","Screenshot_34_1670773534.png","0.00","0.00","0","0","1","1","2022-12-11 09:45:34");
INSERT INTO tbl_item VALUES("529","ABA511P","CELLING ROSE B-GAZI","CELLING ROSE B-GAZI","","","","","","","1","","0","","","","","","Screenshot_128_1670997849.png","0.00","0.00","0","0","1","1","2022-12-11 09:47:09");
INSERT INTO tbl_item VALUES("530","ABA512P","     CELLING ROSE - HIGH KITTY","CELLING ROSE - HIGH KITTY","","","","","","","1","","0","","","","","","Screenshot_37_1670773770.png","0.00","0.00","0","0","1","1","2022-12-11 09:49:30");
INSERT INTO tbl_item VALUES("531","ABA513P","     CELLING ROSE - SP","CELLING ROSE - SP","","","","","","","1","","0","","","","","","Screenshot_88_1670773859.png","0.00","0.00","0","0","1","1","2022-12-11 09:50:59");
INSERT INTO tbl_item VALUES("532","ABA514P","     CELLING ROSE - KITTY","CELLING ROSE - KITTY","","","","","","","1","","0","","","","","","Screenshot_37_1670773905.png","0.00","0.00","0","0","1","1","2022-12-11 09:51:45");
INSERT INTO tbl_item VALUES("533","ABA515P","     THREE PIN MULTIPLUG","THREE PIN MULTIPLUG","","","","","","","1","","0","","","","","","Screenshot_89_1670774407.png","0.00","0.00","0","0","1","1","2022-12-11 10:00:07");
INSERT INTO tbl_item VALUES("534","ABA516P","     THREE PIN MULTI SOCKET MEP - P210","THREE PIN MULTI SOCKET MEP - P210","","","","","","","1","","0","","","","","","Screenshot_90_1670774633.png","0.00","0.00","0","0","1","1","2022-12-11 10:03:53");
INSERT INTO tbl_item VALUES("535","ABA517P","     ALL REGULATOR ","ALL REGULATOR ","","","","","","","1","","0","","","","","","Screenshot_91_1670774758.png","0.00","0.00","0","0","1","1","2022-12-11 10:05:58");
INSERT INTO tbl_item VALUES("536","ABA518P","     THREE PIN MULTI SOCKET MEP - P13","THREE PIN MULTI SOCKET MEP - P13","","","","","","","1","","0","","","","","","Screenshot_92_1670774920.png","0.00","0.00","0","0","1","1","2022-12-11 10:08:40");
INSERT INTO tbl_item VALUES("537","ABA519P","     PIANO CALLING BELL","PIANO CALLING BELL","","","","","","","1","","0","","","","","","Screenshot_93_1670775124.png","0.00","0.00","0","0","1","1","2022-12-11 10:12:04");
INSERT INTO tbl_item VALUES("538","ABA520P","DP SWITCH RMK - 50A-250V","DP SWITCH MEP - P401","","","","","","","1","","0","","","","","","Screenshot_94_1670775281.png","0.00","0.00","0","0","1","1","2022-12-11 10:14:41");
INSERT INTO tbl_item VALUES("539","ABA521P","KITKAT FUSE TIGER - 100A","KITKAT FUSE TIGER - 63A","","","","","","","1","","0","","","","","","Screenshot_95_1670821892.png","0.00","0.00","0","0","1","1","2022-12-12 11:11:32");
INSERT INTO tbl_item VALUES("540","ABA522P","     KITKAT FUSE TIGER - 63A","KITKAT FUSE TIGER - 63A","","","","","","","1","","0","","","","","","Screenshot_96_1670821979.png","0.00","0.00","0","0","1","1","2022-12-12 11:12:59");
INSERT INTO tbl_item VALUES("541","ABA523P","     KITKAT FUSE CONA","KITKAT FUSE CONA","","","","","","","1","","0","","","","","","Screenshot_97_1670822151.png","0.00","0.00","0","0","1","1","2022-12-12 11:15:51");
INSERT INTO tbl_item VALUES("542","ABA524P","     PENDENT HOLDER - JANANI","PENDENT HOLDER - JANANI","","","","","","","1","","0","","","","","","Screenshot_98_1670822298.png","0.00","0.00","0","0","1","1","2022-12-12 11:18:18");
INSERT INTO tbl_item VALUES("543","ABA525P","PENCIL BATTERY SMALL","PENCIL BATTERY SMALL","","","","","","","8","","0","","","","","","Screenshot_99_1670824258.png","0.00","0.00","0","0","1","1","2022-12-12 11:50:58");
INSERT INTO tbl_item VALUES("544","ABA526P","     PENDENT HOLDER MULTI SOCKET ALL","PENDENT HOLDER MULTI SOCKET ALL","","","","","","","1","","0","","","","","","Screenshot_100_1670827632.png","0.00","0.00","0","0","1","1","2022-12-12 12:47:12");
INSERT INTO tbl_item VALUES("545","ABA527P","     THREE PIN MULTI SOCKET ALL","THREE PIN MULTI SOCKET ALL","","","","","","","1","","0","","","","","","Screenshot_101_1670827984.png","0.00","0.00","0","0","1","1","2022-12-12 12:53:04");
INSERT INTO tbl_item VALUES("546","ABA528P","   LIGHT  TRANSTEC - 200WATT","TRANSTEC - 200WATT","","","21","","","","1","","0","","","","","","Screenshot_102_1670828759.png","0.00","0.00","0","0","1","1","2022-12-12 01:05:59");
INSERT INTO tbl_item VALUES("547","ABA529P","   LIGHT  TRANSTEC - 60/40/25 WATT","TRANSTEC - 60/40/25 WATT","","","21","","","","1","","0","","","","","","Screenshot_103_1670828988.png","0.00","0.00","0","0","1","1","2022-12-12 01:09:48");
INSERT INTO tbl_item VALUES("548","ABA530P","   LIGHT  TRANSTEC - 100WATT","TRANSTEC - 100WATT","","","21","","","","1","","0","","","","","","Screenshot_104_1670829219.png","0.00","0.00","0","0","1","1","2022-12-12 01:13:39");
INSERT INTO tbl_item VALUES("549","ABA531P","   LIGHT  GRAMEEN LED NORMAL- 20WATT","GRAMEEN LED NORMAL- 20WATT","","","21","","","","1","","0","","","","","","Screenshot_105_1670829512.png","0.00","0.00","0","0","1","1","2022-12-12 01:18:32");
INSERT INTO tbl_item VALUES("550","ABA532P","   MULTIPLUG  OMAX TOP - 403","OMAX TOP - 403","","","25","","","","1","","0","","","","","","Screenshot_106_1670847486.png","0.00","0.00","0","0","1","1","2022-12-12 06:18:06");
INSERT INTO tbl_item VALUES("551","ABA533P","   MULTIPLUG  MAXLINE 2M - USB212	","MAXLINE 2M - USB212	","","","25","","","","1","","0","","","","","","USB_1670854022.jpg","0.00","0.00","0","0","1","1","2022-12-12 08:07:02");
INSERT INTO tbl_item VALUES("552","ABA534P","   MULTIPLUG  MAXLINE - 074","MAXLINE - 074","","","25","","","","1","","0","","","","","","TAR_1670854343.jpg","0.00","0.00","0","0","1","1","2022-12-12 08:12:23");
INSERT INTO tbl_item VALUES("553","ABA535P","   LIGHT  JR POWER LED ","JR POWER LED ","","","21","","","","1","","0","","","","","","Screenshot_107_1670855432.png","0.00","0.00","0","0","1","1","2022-12-12 08:30:32");
INSERT INTO tbl_item VALUES("554","ABA536P","   PADLOCK  SHAMS SOLDIER - 60MM","SHAMS SOLDIER - 60MM","","","26","","","","1","","0","","","","","","Screenshot_108_1670909874.png","0.00","0.00","0","0","1","1","2022-12-13 11:37:54");
INSERT INTO tbl_item VALUES("555","ABA537P","   PADLOCK  SHAMS BULL - 68MM","SHAMS BULL - 68MM","","","26","","","","1","","0","","","","","","Screenshot_109_1670909957.png","0.00","0.00","0","0","1","1","2022-12-13 11:39:17");
INSERT INTO tbl_item VALUES("556","ABA538P","   PADLOCK  SHAMS ROYAL - 90MM","SHAMS ROYAL - 90MM","","","26","","","","1","","0","","","","","","Screenshot_110_1670910045.png","0.00","0.00","0","0","1","1","2022-12-13 11:40:45");
INSERT INTO tbl_item VALUES("557","ABA539P","   PADLOCK  SHAMS PRIME - 67MM","SHAMS PRIME - 67MM","","","26","","","","1","","0","","","","","","Screenshot_111_1670910118.png","0.00","0.00","0","0","1","1","2022-12-13 11:41:58");
INSERT INTO tbl_item VALUES("558","ABA540P","   PADLOCK  SHIVA TETCO - 65MM","SHIVA TETCO - 65MM","","","26","","","","1","","0","","","","","","Screenshot_112_1670910207.png","0.00","0.00","0","0","1","1","2022-12-13 11:43:27");
INSERT INTO tbl_item VALUES("559","ABA541P","   PADLOCK  SHAMS PREMIUM - 50MM","SHAMS PREMIUM - 50MM","","","26","","","","1","","0","","","","","","Screenshot_113_1670910417.png","0.00","0.00","0","0","1","1","2022-12-13 11:46:57");
INSERT INTO tbl_item VALUES("560","ABA542P","   PADLOCK  SHAMS PREMIUM - 70MM","SHAMS PREMIUM - 70MM","","","26","","","","1","","0","","","","","","Screenshot_114_1670910525.png","0.00","0.00","0","0","1","1","2022-12-13 11:48:45");
INSERT INTO tbl_item VALUES("561","ABA543P","PADLOCK TOP - 32MM","TOP PADLOCK - 32MM","","","26","","","","1","","0","","","","","","Screenshot_115_1670910644.png","0.00","0.00","0","0","1","1","2022-12-13 11:50:44");
INSERT INTO tbl_item VALUES("562","ABA544P","PADLOCK TOP - 38MM","TOP PADLOCK - 38MM","","","26","","","","1","","0","","","","","","Screenshot_115_1670910728.png","0.00","0.00","0","0","1","1","2022-12-13 11:52:08");
INSERT INTO tbl_item VALUES("563","ABA545P","PADLOCK TOP - 50MM","TOP PADLOCK - 50MM","","","26","","","","1","","0","","","","","","Screenshot_115_1670910764.png","0.00","0.00","0","0","1","1","2022-12-13 11:52:44");
INSERT INTO tbl_item VALUES("564","ABA546P","   PADLOCK  SHAMS STRONG - 65MM","SHAMS STRONG - 65MM","","","26","","","","1","","0","","","","","","Screenshot_116_1670910862.png","0.00","0.00","0","0","1","1","2022-12-13 11:54:22");
INSERT INTO tbl_item VALUES("565","ABA547P","   PADLOCK  SUSAM TOP SECURITY - 63MM","SUSAM TOP SECURITY - 63MM","","","26","","","","1","","0","","","","","","Screenshot_117_1670911113.png","0.00","0.00","0","0","1","1","2022-12-13 11:58:33");
INSERT INTO tbl_item VALUES("566","ABA548P","   PADLOCK  TRI-CIVCYLE - 63MM","TRI-CIVCYLE - 63MM","","","26","","","","1","","0","","","","","","Screenshot_118_1670911215.png","0.00","0.00","0","0","1","1","2022-12-13 12:00:15");
INSERT INTO tbl_item VALUES("567","ABA549P","   PADLOCK  SRI-CIVCYLE - 38MM","SRI-CIVCYLE - 38MM","","","26","","","","1","","0","","","","","","Screenshot_119_1670911293.png","0.00","0.00","0","0","1","1","2022-12-13 12:01:33");
INSERT INTO tbl_item VALUES("568","ABA550P","   PADLOCK  SRI-CIVCYLE - 32MM","SRI-CIVCYLE - 32MM","","","26","","","","1","","0","","","","","","Screenshot_119_1670911382.png","0.00","0.00","0","0","1","1","2022-12-13 12:03:02");
INSERT INTO tbl_item VALUES("569","ABA551P","   PADLOCK  TRI-CIVCYLE - 50MM","TRI-CIVCYLE - 50MM","","","26","","","","1","","0","","","","","","Screenshot_118_1670911446.png","0.00","0.00","0","0","1","1","2022-12-13 12:04:06");
INSERT INTO tbl_item VALUES("570","ABA552P","   PADLOCK  BRASS - 25MM","BRASS - 25MM","","","26","","","","1","","0","","","","","","Screenshot_120_1670911552.png","0.00","0.00","0","0","1","1","2022-12-13 12:05:52");
INSERT INTO tbl_item VALUES("571","ABA553P","PADLOCK SHAMS DOUBLE LOCKING -  50MM","SHAMS DOUBLE LOCKING -  50MM","","","26","","","","1","","0","","","","","","Screenshot_122_1670911939.png","0.00","0.00","0","0","1","1","2022-12-13 12:06:44");
INSERT INTO tbl_item VALUES("572","ABA554P","   PADLOCK  SHAMS DOUBLE LOCKING - 70MM","SHAMS DOUBLE LOCKING - 70MM","","","26","","","","1","","0","","","","","","Screenshot_121_1670911868.png","0.00","0.00","0","0","1","1","2022-12-13 12:11:08");
INSERT INTO tbl_item VALUES("573","ABA555P","   MULTIPLUG  SINO POWER STRIP","SINO POWER STRIP","","","25","","","","1","","0","","","","","","Screenshot_124_1670915375.png","0.00","0.00","0","0","1","1","2022-12-13 01:09:35");
INSERT INTO tbl_item VALUES("574","ABA556P","     ROYAL PLUG","ROYAL PLUG","","","","","","","13","","0","","","","","","Screenshot_126_1670944904.png","0.00","0.00","0","0","1","1","2022-12-13 09:21:44");
INSERT INTO tbl_item VALUES("575","ABA557P","     GRAIN IC ","GRAIN IC ","","","","","","","1","","0","","","","","","Screenshot_127_1670945855.png","0.00","0.00","0","0","1","1","2022-12-13 09:37:34");
INSERT INTO tbl_item VALUES("576","ABA558P","     LEDGER IC","LEDGER IC","","","","","","","1","","0","","","","","","Screenshot_76_1670945999.png","0.00","0.00","0","0","1","1","2022-12-13 09:39:59");
INSERT INTO tbl_item VALUES("577","ABA559P","     REGULATOR GDL","REGULATOR GDL","","","","","","","1","","0","","","","","","Screenshot_91_1670946590.png","0.00","0.00","0","0","1","1","2022-12-13 09:49:50");
INSERT INTO tbl_item VALUES("578","ABA560P","DISH COUPLER - 1 WAY","DISH CAPLAR - 1WAY","","","","","","","1","","0","","","","","","1wa_1671081994.jpg","0.00","0.00","0","0","1","1","2022-12-15 11:26:34");
INSERT INTO tbl_item VALUES("579","ABA561P","DISH COUPLER - 2 WAY","DISH CAPLAR - 2WAY","","","","","","","1","","0","","","","","","Screenshot_129_1671082062.png","0.00","0.00","0","0","1","1","2022-12-15 11:27:42");
INSERT INTO tbl_item VALUES("580","ABA562P","DISH COUPLER - 3 WAY","DISH CAPLAR - 3 WAY","","","","","","","1","","0","","","","","","Screenshot_130_1671082135.png","0.00","0.00","0","0","1","1","2022-12-15 11:28:55");
INSERT INTO tbl_item VALUES("581","ABA563P","     DISH COUPLER - 4 WAY","DISH COUPLER - 4 WAY","","","","","","","1","","0","","","","","","Screenshot_131_1671082344.png","0.00","0.00","0","0","1","1","2022-12-15 11:32:24");
INSERT INTO tbl_item VALUES("582","ABA564P","     DISH SPLITTER - 2 WAY","DISH SPLITTER - 2 WAY","","","","","","","1","","0","","","","","","Screenshot_132_1671082730.png","0.00","0.00","0","0","1","1","2022-12-15 11:38:50");
INSERT INTO tbl_item VALUES("583","ABA565P","     HDMI CABLE - 10M","HDMI CABLE - 10M","","","","","","","1","","0","","","","","","Screenshot_133_1671083604.png","0.00","0.00","0","0","1","1","2022-12-15 11:53:24");
INSERT INTO tbl_item VALUES("584","ABA566P","TBS 1310nm SFP 20KM","TBS 1310nm SFP 20KM","","","","","","","1","","0","","","","","","Screenshot_134_1671085036.png","0.00","0.00","0","0","1","1","2022-12-15 12:10:04");
INSERT INTO tbl_item VALUES("586","ABA567P","     TBS 1550nm SFP 20KM","TBS 1550nm SFP 20KM","","","","","","","1","","0","","","","","","Screenshot_135_1671085118.png","0.00","0.00","0","0","1","1","2022-12-15 12:18:38");
INSERT INTO tbl_item VALUES("587","ABA568P","     E.NET 1550nm SFP 40KM","E.NET 1550nm SFP 40KM","","","","","","","1","","0","","","","","","Screenshot_136_1671085858.png","0.00","0.00","0","0","1","1","2022-12-15 12:30:58");
INSERT INTO tbl_item VALUES("588","ABA569P","     E.NET 1310nm SFP 40KM","E.NET 1310nm SFP 40KM","","","","","","","1","","0","","","","","","Screenshot_137_1671085946.png","0.00","0.00","0","0","1","1","2022-12-15 12:32:26");
INSERT INTO tbl_item VALUES("589","ABA570P","DBC 10G SFP 1270nm 20KM","TBS 10G SFP 1270nm 20KM","","","","","","","1","","0","","","","","","Screenshot_138_1671086056.png","1350.00","2250.00","365","0","1","1","2022-12-15 12:34:16");
INSERT INTO tbl_item VALUES("590","ABA571P","DBC 10G SFP 1330nm 20KM","TBS 10G SFP 1330nm 20KM","","","","","","","1","","0","","","","","","Screenshot_139_1671086200.png","1350.00","1350.00","365","0","1","1","2022-12-15 12:36:40");
INSERT INTO tbl_item VALUES("592","ABA573P","     NEXTWAVE 1310nm SFP 20KM","NEXTWAVE 1310nm SFP 20KM","","","","","","","1","","0","","","","","","Screenshot_141_1671086620.png","0.00","0.00","0","0","1","1","2022-12-15 12:43:40");
INSERT INTO tbl_item VALUES("593","ABA574P","     NEXTWAVE 1550nm SFP 20KM","NEXTWAVE 1550nm SFP 20KM","","","","","","","1","","0","","","","","","Screenshot_142_1671086680.png","0.00","0.00","0","0","1","1","2022-12-15 12:44:40");
INSERT INTO tbl_item VALUES("595","ABA576P","PON MODULE 8dBm 20KM","E.NET EPON 8dBm 20KM","","","","","","","1","","0","","","","","","Screenshot_144_1671087710.png","0.00","0.00","0","0","1","1","2022-12-15 01:01:50");
INSERT INTO tbl_item VALUES("596","ABA577P","PON MODULE 9dBm 20KM","TBS EPON 8dBm 20KM","","","","","","","1","","0","","","","","","Screenshot_145_1671087784.png","0.00","0.00","0","0","1","1","2022-12-15 01:03:04");
INSERT INTO tbl_item VALUES("597","ABA578P","     TBS 1310nm SFP 40KM","TBS 1310nm SFP 40KM","","","","","","","1","","0","","","","","","Screenshot_146_1671088346.png","0.00","0.00","0","0","1","1","2022-12-15 01:12:26");
INSERT INTO tbl_item VALUES("598","ABA579P","     TBS 1550nm SFP 40KM","TBS 1550nm SFP 40KM","","","","","","","1","","0","","","","","","Screenshot_147_1671088400.png","0.00","0.00","0","0","1","1","2022-12-15 01:13:20");
INSERT INTO tbl_item VALUES("599","ABA580P","     E.NET 1310nm SFP 20KM","E.NET 1310nm SFP 20KM","","","","","","","1","","0","","","","","","Screenshot_148_1671088502.png","0.00","0.00","0","0","1","1","2022-12-15 01:15:02");
INSERT INTO tbl_item VALUES("600","ABA581P","     E.NET 1550nm SFP 20KM","E.NET 1550nm SFP 20KM","","","","","","","1","","0","","","","","","Screenshot_149_1671088579.png","0.00","0.00","0","0","1","1","2022-12-15 01:16:19");
INSERT INTO tbl_item VALUES("601","ABA582P","     GI - TAR","GI - TAR","","","","","","","2","","0","","","","","","GI TAR_1671088922.jpg","0.00","0.00","0","0","1","1","2022-12-15 01:22:02");
INSERT INTO tbl_item VALUES("602","ABA583P","     DISH ADAPTER","DISH ADAPTER","","","","","","","1","","0","","","","","","Screenshot_150_1671173578.png","0.00","0.00","0","0","1","1","2022-12-16 12:52:58");
INSERT INTO tbl_item VALUES("603","ABA584P","     XPART NOSE PLUS","XPART NOSE PLUS","","","","","","","1","","0","","","","","","Screenshot_151_1671173704.png","0.00","0.00","0","0","1","1","2022-12-16 12:55:04");
INSERT INTO tbl_item VALUES("604","ABA585P","     ROYAL 8'' PLUS","ROYAL 8'' PLUS","","","","","","","1","","0","","","","","","Screenshot_152_1671173787.png","0.00","0.00","0","0","1","1","2022-12-16 12:56:27");
INSERT INTO tbl_item VALUES("605","ABA586P","     SHAMS 6'' PLUS","SHAMS 6'' PLUS","","","","","","","1","","0","","","","","","Screenshot_153_1671173971.png","0.00","0.00","0","0","1","1","2022-12-16 12:59:31");
INSERT INTO tbl_item VALUES("606","ABA587P","     CUTTING 6'' PLUS","CUTTING 6'' PLUS","","","","","","","1","","0","","","","","","Screenshot_154_1671174055.png","0.00","0.00","0","0","1","1","2022-12-16 01:00:55");
INSERT INTO tbl_item VALUES("607","ABA588P","     XPART 8'' WRENCH ","XPART 8'' WRENCH ","","","","","","","1","","0","","","","","","Screenshot_155_1671174255.png","0.00","0.00","0","0","1","1","2022-12-16 01:04:15");
INSERT INTO tbl_item VALUES("608","ABA589P","     SMALL MINUS","SMALL MINUS","","","","","","","1","","0","","","","","","SSDA_1671174383.jpg","0.00","0.00","0","0","1","1","2022-12-16 01:06:23");
INSERT INTO tbl_item VALUES("609","ABA590P","     LARGE MINUS","LARGE MINUS","","","","","","","1","","0","","","","","","Screenshot_156_1671174515.png","0.00","0.00","0","0","1","1","2022-12-16 01:08:35");
INSERT INTO tbl_item VALUES("610","ABA591P","     STAR PLUS MINUS","STAR PLUS MINUS","","","","","","","1","","0","","","","","","Screenshot_157_1671174819.png","0.00","0.00","0","0","1","1","2022-12-16 01:13:39");
INSERT INTO tbl_item VALUES("611","ABA592P","     23/76 TAMA CABLE","23/76 TAMA CABLE","","","","","","","1","","0","","","","","","Screenshot_158_1671174879.png","0.00","0.00","0","0","1","1","2022-12-16 01:14:39");
INSERT INTO tbl_item VALUES("612","ABA593P","     DBC CONNECTOR/CLIP","DBC CONNECTOR/CLIP","","","","","","","1","","0","","","","","","Screenshot_159_1671175035.png","0.00","0.00","0","0","1","1","2022-12-16 01:17:15");
INSERT INTO tbl_item VALUES("613","ABA594P","     OUBAO TOOL","OUBAO TOOL","","","","","","","1","","0","","","","","","GH_1671182654.jpg","0.00","0.00","0","0","1","1","2022-12-16 03:24:14");
INSERT INTO tbl_item VALUES("614","ABA595P","     BRB CABLE *C.P - 1.3","BRB CABLE *C.P - 1.3","","","","","","","4","","0","","","","","","BBR_1671186042.jpg","0.00","0.00","0","0","1","1","2022-12-16 04:20:42");
INSERT INTO tbl_item VALUES("615","ABA596P","     BRB CABLE - 1.3","BRB CABLE - 1.3","","","","","","","1","","0","","","","","","BBR_1671186238.jpg","0.00","0.00","0","0","1","1","2022-12-16 04:23:58");
INSERT INTO tbl_item VALUES("616","ABA597P","     ALIF SUN CABLE 40/76 ","ALIF SUN CABLE 40/76 ","","","","","","","4","","0","","","","","","4076_1671186390.jpg","0.00","0.00","0","0","1","1","2022-12-16 04:26:30");
INSERT INTO tbl_item VALUES("617","ABA598P","     WHITE NAVA CABLE 40/76","WHITE NAVA CABLE 40/76","","","","","","","4","","0","","","","","","400_1671186526.jpg","0.00","0.00","0","0","1","1","2022-12-16 04:28:46");
INSERT INTO tbl_item VALUES("618","ABA599P","     BRB CABLE - 3.0","BRB CABLE - 3.0","","","","","","","4","","0","","","","","","BBR_1671186691.jpg","0.00","0.00","0","0","1","1","2022-12-16 04:31:31");
INSERT INTO tbl_item VALUES("619","ABA600P","     P.H.B TAMA CABLE 23/76","P.H.B TAMA CABLE 23/76","","","","","","","4","","0","","","","","","images (4)_1671188725.jpg","0.00","0.00","0","0","1","1","2022-12-16 05:05:25");
INSERT INTO tbl_item VALUES("620","ABA601P","     MEP CABLE - 2.0","MEP CABLE - 2.0","","","","","","","4","","0","","","","","","Screenshot_160_1671189001.png","0.00","0.00","0","0","1","1","2022-12-16 05:10:01");
INSERT INTO tbl_item VALUES("621","ABA602P","REGULAR ELECTRIC TESTER","REGULAR ELECTRIC TESTER","","","","","","","1","","0","","","","","","3454_1671189884.jpg","0.00","0.00","0","0","1","1","2022-12-16 05:24:44");
INSERT INTO tbl_item VALUES("622","ABA603P","     HIGH QUALITY TESTER","HIGH QUALITY TESTER","","","","","","","1","","0","","","","","","WVT-Z01_1671190149.png","0.00","0.00","0","0","1","1","2022-12-16 05:29:09");
INSERT INTO tbl_item VALUES("623","ABA604P","     TEFLON TAPE","TEFLON TAPE","","","","","","","1","","0","","","","","","Screenshot_161_1671190316.png","0.00","0.00","0","0","1","1","2022-12-16 05:31:56");
INSERT INTO tbl_item VALUES("624","ABA605P","     GLASS DOOR LOCK","GLASS DOOR LOCK","","","","","","","1","","0","","","","","","123_1671190450.jpg","0.00","0.00","0","0","1","1","2022-12-16 05:34:10");
INSERT INTO tbl_item VALUES("625","ABA606P","     CEILING FAN PLASTIC RUBBER","CEILING FAN PLASTIC RUBBER","","","","","","","1","","0","","","","","","10H_1671190658.jpg","0.00","0.00","0","0","1","1","2022-12-16 05:37:38");
INSERT INTO tbl_item VALUES("626","ABA607P","     POWER LINEMAN BELT","POWER LINEMAN BELT","","","","","","","1","","0","","","","","","Screenshot_162_1671191071.png","0.00","0.00","0","0","1","1","2022-12-16 05:44:31");
INSERT INTO tbl_item VALUES("627","ABA608P","ONU HUAWEI XPON","ONU HUAWEI XPON","","","","","","","1","","0","","","","","","Huaw_1671195471.jpg","650.00","0.00","365","0","1","1","2022-12-16 06:57:51");
INSERT INTO tbl_item VALUES("628","ABA609P","     MOTOR CAPACITOR","MOTOR CAPACITOR","","","","","","","1","","0","","","","","","Screenshot_164_1671265649.png","0.00","0.00","0","0","1","1","2022-12-17 02:27:29");
INSERT INTO tbl_item VALUES("629","ABA610P","     BBS CABLE WHITE - 1.2","BBS CABLE WHITE - 1.2","","","","","","","4","","0","","","","","","Screenshot_165_1671272430.png","0.00","0.00","0","0","1","1","2022-12-17 04:20:30");
INSERT INTO tbl_item VALUES("630","ABA611P","   FIBER CABLE   USHA MARTIN - 12F","USHA MARTIN - 12F","","","16","","","","4","","0","","","","","","12F_1671274491.jpg","0.00","0.00","0","0","1","1","2022-12-17 04:54:51");
INSERT INTO tbl_item VALUES("631","ABA612P","     MEGHNA CABLE - 0.25 ","MEGHNA CABLE - 0.25 ","","","","","","","4","","0","","","","","","Screenshot_166_1671286410.png","0.00","0.00","0","0","1","1","2022-12-17 08:13:30");
INSERT INTO tbl_item VALUES("632","ABA613P","   LIGHT  SUPER STAR  - 200 WATT","SUPER STAR  - 200 WATT","","","21","","","","1","","0","","","","","","Screenshot_167_1671288614.png","0.00","0.00","0","0","1","1","2022-12-17 08:50:14");
INSERT INTO tbl_item VALUES("634","ABA615P","     DISH COUPLER - 5 WAY","DISH COUPLER - 5 WAY","","","","","","","1","","0","","","","","","1wa_1671364543.jpg","0.00","0.00","0","0","1","1","2022-12-18 05:55:43");
INSERT INTO tbl_item VALUES("635","ABA616P","DISH COUPLER - 6 WAY","DISH COUPLER - 6 WAY","","","","","","","1","","0","","","","","","1wa_1671364580.jpg","0.00","0.00","0","0","1","1","2022-12-18 05:56:00");
INSERT INTO tbl_item VALUES("636","ABA617P","CIRCLE CAT-6 BOX","CIRCLE CAT-6 BOX","","","14","","","","4","","0","","","","","","Screenshot_5_1671460872.png","0.00","0.00","0","0","1","1","2022-12-19 08:41:12");
INSERT INTO tbl_item VALUES("637","ABA618P","   FIBER CABLE   ABS - 4F","ABS - 4F","","","16","","","","4","","0","","","","","","FB_1671539177.jpg","0.00","0.00","0","0","1","1","2022-12-20 06:26:17");
INSERT INTO tbl_item VALUES("638","ABA619P","OTHERS PRODUCTS","OTHERS ","","","","","","","1","","0","","","","","","Screenshot_168_1671552245.png","0.00","0.00","0","0","1","1","2022-12-20 10:00:02");
INSERT INTO tbl_item VALUES("639","ABA620P","FIBER SLEEVERS HIGH","FIBER SLEEVERS","","","","","","","1","","0","","","","","","Screenshot_169_1671608298.png","0.00","0.00","0","0","1","1","2022-12-21 01:37:29");
INSERT INTO tbl_item VALUES("640","ABA621P","   RG - 6  RETAIL CABLE - 100M","RETAIL CABLE - 100M","","","18","","","","4","","0","","","","","","FB_1671615835.jpg","0.00","0.00","0","0","1","1","2022-12-21 03:43:55");
INSERT INTO tbl_item VALUES("641","ABA622P","   RG - 6  SATELLITE VISION D-2 - 300M","SATELLITE VISION D-2 - 300M","","","18","","","","24","","0","","","","","","OUT_1671636317.jpg","0.00","0.00","0","0","1","1","2022-12-21 09:25:17");
INSERT INTO tbl_item VALUES("644","ABA624P","   LIGHT  SUPER STAR - 100WATT","SUPER STAR - 100WATT","","","21","","","","1","","0","","","","","","Screenshot_170_1671694175.png","0.00","0.00","0","0","1","1","2022-12-22 01:29:35");
INSERT INTO tbl_item VALUES("645","ABA625P","     FIBER SLEEVERS","FIBER SLEEVERS","","","","","","","1","","0","","","","","","Screenshot_171_1671702906.png","0.00","0.00","0","0","1","1","2022-12-22 03:55:06");
INSERT INTO tbl_item VALUES("646","ABA626P","   REMOTE  HUAYA RM-L1340","HUAYA RM-L1340","","","27","","","","1","","0","","","","","","ccc_1671882301.jpg","0.00","0.00","0","0","1","1","2022-12-24 05:45:01");
INSERT INTO tbl_item VALUES("647","ABA627P","   REMOTE  AST - 1CE3","AST - 1CE3","","","27","","","","1","","0","","","","","","CV_1671882383.jpg","0.00","0.00","0","0","1","1","2022-12-24 05:46:23");
INSERT INTO tbl_item VALUES("648","ABA628P","   REMOTE  TX 3 MINI","TX 3 MINI","","","27","","","","1","","0","","","","","","TXCC_1671882518.jpg","0.00","0.00","0","0","1","1","2022-12-24 05:48:38");
INSERT INTO tbl_item VALUES("649","ABA629P","   REMOTE  X96 MINI ","X96 MINI ","","","27","","","","1","","0","","","","","","SSS_1671882843.jpg","0.00","0.00","0","0","1","1","2022-12-24 05:54:03");
INSERT INTO tbl_item VALUES("650","ABA630P","   REMOTE  2207 SMART","2207 SMART","","","27","","","","1","","0","","","","","","SDS_1671882972.jpg","0.00","0.00","0","0","1","1","2022-12-24 05:56:12");
INSERT INTO tbl_item VALUES("651","ABA631P","   REMOTE  WORLD TECH 2200 EPRPWO","WORLD TECH 2200 EPRPWO","","","27","","","","1","","0","","","","","","Screenshot_172_1671883184.png","0.00","0.00","0","0","1","1","2022-12-24 05:59:44");
INSERT INTO tbl_item VALUES("652","ABA632P","   REMOTE  MYONE ","MYONE ","","","27","","","","1","","0","","","","","","1_1671883287.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:01:27");
INSERT INTO tbl_item VALUES("653","ABA633P","   REMOTE  AKASH ","AKASH ","","","27","","","","1","","0","","","","","","Screenshot_173_1671883468.png","0.00","0.00","0","0","1","1","2022-12-24 06:04:28");
INSERT INTO tbl_item VALUES("654","ABA634P","   REMOTE  SINGER ","SINGER ","","","27","","","","1","","0","","","","","","DDD_1671883601.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:06:41");
INSERT INTO tbl_item VALUES("655","ABA635P","   REMOTE  SKY VIEW","SKY VIEW","","","27","","","","1","","0","","","","","","SDSA_1671884430.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:20:30");
INSERT INTO tbl_item VALUES("656","ABA636P","   REMOTE  MEDIA LED","MEDIA LED","","","27","","","","1","","0","","","","","","SDF_1671884507.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:21:46");
INSERT INTO tbl_item VALUES("657","ABA637P","   REMOTE  LCD ","LCD ","","","27","","","","1","","0","","","","","","SG_1671884566.jpeg","0.00","0.00","0","0","1","1","2022-12-24 06:22:46");
INSERT INTO tbl_item VALUES("658","ABA638P","   REMOTE  TOSHIBA ","TOSHIBA ","","","27","","","","1","","0","","","","","","TOSIBA_1671884883.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:28:03");
INSERT INTO tbl_item VALUES("659","ABA639P","   REMOTE  WALTON/MERCEL","WALTON/MERCEL","","","27","","","","1","","0","","","","","","WALTON_1671884996.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:29:56");
INSERT INTO tbl_item VALUES("660","ABA640P","   REMOTE  WALTON ECO","WALTON ECO","","","27","","","","1","","0","","","","","","WALTON_1671885058.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:30:58");
INSERT INTO tbl_item VALUES("661","ABA641P","   REMOTE  WALTON","WALTON","","","27","","","","1","","0","","","","","","WALTONX_1671885181.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:33:01");
INSERT INTO tbl_item VALUES("662","ABA642P","   REMOTE  JAMUNA GCBL TV 21A-C12","JAMUNA GCBL TV 21A-C12","","","27","","","","1","","0","","","","","","JAM_1671885266.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:34:26");
INSERT INTO tbl_item VALUES("663","ABA643P","   REMOTE  RANGS KTC TOSHIN","RANGS KTC TOSHIN","","","27","","","","1","","0","","","","","","RAN_1671885421.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:37:01");
INSERT INTO tbl_item VALUES("664","ABA644P","   REMOTE  GOLDEN PLUS 26A6","GOLDEN PLUS 26A6","","","27","","","","1","","0","","","","","","SF_1671885537.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:38:57");
INSERT INTO tbl_item VALUES("665","ABA645P","   REMOTE  SONY","SONY","","","27","","","","1","","0","","","","","","Screenshot_175_1671885651.png","0.00","0.00","0","0","1","1","2022-12-24 06:40:51");
INSERT INTO tbl_item VALUES("666","ABA646P","   REMOTE  SAMSUNG BN59-01175C","SAMSUNG BN59-01175C","","","27","","","","1","","0","","","","","","DFG_1671885921.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:45:21");
INSERT INTO tbl_item VALUES("667","ABA647P","   REMOTE  RM-L1162","RM-L1162","","","27","","","","1","","0","","","","","","RM-L1162_1671886139.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:48:59");
INSERT INTO tbl_item VALUES("668","ABA648P","   REMOTE  LG AKB73715606","LG AKB73715606","","","27","","","","1","","0","","","","","","LG_1671886241.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:50:40");
INSERT INTO tbl_item VALUES("669","ABA649P","   REMOTE  666","666","","","27","","","","1","","0","","","","","","666_1671886427.jpg","0.00","0.00","0","0","1","1","2022-12-24 06:53:47");
INSERT INTO tbl_item VALUES("670","ABA650P","   REMOTE  KK-Y237B","KK-Y237B","","","27","","","","1","","0","","","","","","Screenshot_177_1672051429.png","0.00","0.00","0","0","1","1","2022-12-26 04:43:49");
INSERT INTO tbl_item VALUES("671","ABA651P","   REMOTE  DZT1","DZT1","","","27","","","","1","","0","","","","","","Screenshot_178_1672051530.png","0.00","0.00","0","0","1","1","2022-12-26 04:45:29");
INSERT INTO tbl_item VALUES("672","ABA652P","   REMOTE  RM009A","RM009A","","","27","","","","1","","0","","","","","","Screenshot_179_1672051773.png","0.00","0.00","0","0","1","1","2022-12-26 04:49:32");
INSERT INTO tbl_item VALUES("673","ABA653P","   REMOTE  STAR HYDFSR 0070TC","STAR HYDFSR 0070TC","","","27","","","","1","","0","","","","","","GH_1672134916.jpg","0.00","0.00","0","0","1","1","2022-12-27 03:55:16");
INSERT INTO tbl_item VALUES("674","ABA654P","   REMOTE  STAR RANGS HYDESR 0041","STAR RANGS HYDESR 0041","","","27","","","","1","","0","","","","","","GHH_1672135086.jpg","0.00","0.00","0","0","1","1","2022-12-27 03:58:06");
INSERT INTO tbl_item VALUES("675","ABA655P","   REMOTE  SUN DIRECT","SUN DIRECT","","","27","","","","1","","0","","","","","","Screenshot_181_1672135187.png","0.00","0.00","0","0","1","1","2022-12-27 03:59:47");
INSERT INTO tbl_item VALUES("676","ABA656P","   REMOTE  D2H","D2H","","","27","","","","1","","0","","","","","","Screenshot_182_1672135251.png","0.00","0.00","0","0","1","1","2022-12-27 04:00:51");
INSERT INTO tbl_item VALUES("677","ABA657P","   REMOTE  NOVA","NOVA","","","27","","","","1","","0","","","","","","SDA_1672136337.jpg","0.00","0.00","0","0","1","1","2022-12-27 04:18:57");
INSERT INTO tbl_item VALUES("678","ABA658P","   REMOTE  DR GENERAL","DR GENERAL","","","27","","","","1","","0","","","","","","DR_1672136499.jpg","0.00","0.00","0","0","1","1","2022-12-27 04:21:39");
INSERT INTO tbl_item VALUES("679","ABA659P","   REMOTE  54B4","54B4","","","27","","","","1","","0","","","","","","54B4_1672139175.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:06:15");
INSERT INTO tbl_item VALUES("680","ABA660P","   REMOTE  6BD2 ","6BD2 ","","","27","","","","1","","0","","","","","","6BD2_1672139345.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:09:05");
INSERT INTO tbl_item VALUES("681","ABA661P","   REMOTE  6710V00124D","6710V00124D","","","27","","","","1","","0","","","","","","6710_1672139440.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:10:40");
INSERT INTO tbl_item VALUES("682","ABA662P","   REMOTE  EUR501310","EUR501310","","","27","","","","1","","0","","","","","","Screenshot_183_1672139559.png","0.00","0.00","0","0","1","1","2022-12-27 05:12:39");
INSERT INTO tbl_item VALUES("683","ABA663P","REMOTE  KEXID - C6/C12/C23","KEXID - C6","","","27","","","","1","","0","","","","","","KEXID_1672140140.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:22:20");
INSERT INTO tbl_item VALUES("684","ABA664P","   REMOTE  TRANSTEC","TRANSTEC","","","27","","","","1","","0","","","","","","TRANS_1672140289.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:24:49");
INSERT INTO tbl_item VALUES("685","ABA665P","   REMOTE  R-49C07","R-49C07","","","27","","","","1","","0","","","","","","Screenshot_184_1672140423.png","0.00","0.00","0","0","1","1","2022-12-27 05:27:03");
INSERT INTO tbl_item VALUES("686","ABA666P","   REMOTE  RM-ED054","RM-ED054","","","27","","","","1","","0","","","","","","EDO_1672140512.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:28:32");
INSERT INTO tbl_item VALUES("687","ABA667P","   REMOTE  CTC REMOTE","CTC REMOTE","","","27","","","","1","","0","","","","","","CTC_1672140649.jpg","0.00","0.00","0","0","1","1","2022-12-27 05:30:49");
INSERT INTO tbl_item VALUES("688","ABA668P","   REMOTE  RM008-V","RM008-V","","","27","","","","1","","0","","","","","","Screenshot_185_1672141489.png","0.00","0.00","0","0","1","1","2022-12-27 05:44:49");
INSERT INTO tbl_item VALUES("689","ABA669P","   REMOTE  RM - L1162","RM - L1162","","","27","","","","1","","0","","","","","","L1162_1672142504.jpg","0.00","0.00","0","0","1","1","2022-12-27 06:01:44");
INSERT INTO tbl_item VALUES("690","ABA670P","   REMOTE  LG RM-L930","LG RM-L930","","","27","","","","1","","0","","","","","","HTI_1672142730.jpg","0.00","0.00","0","0","1","1","2022-12-27 06:05:30");
INSERT INTO tbl_item VALUES("692","ABA672P","   REMOTE  AKAI","AKAI","","","27","","","","1","","0","","","","","","Screenshot_187_1672148039.png","0.00","0.00","0","0","1","1","2022-12-27 07:33:59");
INSERT INTO tbl_item VALUES("693","ABA673P","REMOTE  M03","MO3","","","27","","","","1","","0","","","","","","M03_1672148528.jpg","0.00","0.00","0","0","1","1","2022-12-27 07:42:07");
INSERT INTO tbl_item VALUES("694","ABA674P","   REMOTE  DE - 71","DE - 71","","","27","","","","1","","0","","","","","","DE_1672203773.jpg","0.00","0.00","0","0","1","1","2022-12-28 11:02:53");
INSERT INTO tbl_item VALUES("695","ABA675P","   REMOTE  RC - 71","RC - 71","","","27","","","","1","","0","","","","","","RC_1672204032.jpg","0.00","0.00","0","0","1","1","2022-12-28 11:07:12");
INSERT INTO tbl_item VALUES("696","ABA676P","   REMOTE  M21SMTOO","M21SMTOO","","","27","","","","1","","0","","","","","","M21S_1672205571.jpg","0.00","0.00","0","0","1","1","2022-12-28 11:32:51");
INSERT INTO tbl_item VALUES("697","ABA677P","   REMOTE  RM-952","RM-952","","","27","","","","1","","0","","","","","","Screenshot_188_1672206161.png","0.00","0.00","0","0","1","1","2022-12-28 11:42:41");
INSERT INTO tbl_item VALUES("698","ABA678P","   REMOTE  RM-883","RM-883","","","27","","","","1","","0","","","","","","88_1672206220.jpg","0.00","0.00","0","0","1","1","2022-12-28 11:43:40");
INSERT INTO tbl_item VALUES("699","ABA679P","   REMOTE  RM-870","RM-870","","","27","","","","1","","0","","","","","","Screenshot_189_1672207690.png","0.00","0.00","0","0","1","1","2022-12-28 12:08:10");
INSERT INTO tbl_item VALUES("700","ABA680P","   REMOTE  8891-6KU3","8891-6KU3","","","27","","","","1","","0","","","","","","Screenshot_190_1672208871.png","0.00","0.00","0","0","1","1","2022-12-28 12:27:51");
INSERT INTO tbl_item VALUES("701","ABA681P","   REMOTE  KR-100","KR-100","","","27","","","","1","","0","","","","","","Screenshot_191_1672209553.png","0.00","0.00","0","0","1","1","2022-12-28 12:39:13");
INSERT INTO tbl_item VALUES("702","ABA682P","   REMOTE  25IN1","25IN1","","","27","","","","1","","0","","","","","","25_1672209820.jpg","0.00","0.00","0","0","1","1","2022-12-28 12:43:40");
INSERT INTO tbl_item VALUES("703","ABA683P","   REMOTE  NIPPON","NIPPON","","","27","","","","1","","0","","","","","","NIP_1672210010.jpg","0.00","0.00","0","0","1","1","2022-12-28 12:46:50");
INSERT INTO tbl_item VALUES("704","ABA684P","   REMOTE  DIGITAL FAST","DIGITAL FAST","","","27","","","","1","","0","","","","","","","0.00","0.00","0","0","1","1","2022-12-28 01:21:47");
INSERT INTO tbl_item VALUES("705","ABA685P","   REMOTE  KK-Y27IB","KK-Y27IB","","","27","","","","1","","0","","","","","","Screenshot_193_1672212563.png","0.00","0.00","0","0","1","1","2022-12-28 01:29:23");
INSERT INTO tbl_item VALUES("706","ABA686P","METER TAPE","Measure Tape","","","","","","","1","","0","","","","","","TAP_1672214362.jpg","0.00","0.00","0","0","1","1","2022-12-28 01:59:22");
INSERT INTO tbl_item VALUES("707","ABA687P","   REMOTE  RS17-OM8371-A","RS17-OM8371-A","","","27","","","","1","","0","","","","","","Screenshot_194_1672228636.png","0.00","0.00","0","0","1","1","2022-12-28 05:57:16");
INSERT INTO tbl_item VALUES("708","ABA688P","REMOTE  AG","AG-2126","","","27","","","","1","","0","","","","","","Screenshot_195_1672228825.png","0.00","0.00","0","0","1","1","2022-12-28 06:00:25");
INSERT INTO tbl_item VALUES("709","ABA689P","   REMOTE  RM-177CH","RM-177CH","","","27","","","","1","","0","","","","","","download_1672229039.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:03:59");
INSERT INTO tbl_item VALUES("710","ABA690P","   REMOTE  RM-L1370","RM-L1370","","","27","","","","1","","0","","","","","","70_1672229126.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:05:26");
INSERT INTO tbl_item VALUES("711","ABA691P","   REMOTE  RM-88","RM-88","","","27","","","","1","","0","","","","","","Screenshot_196_1672229303.png","0.00","0.00","0","0","1","1","2022-12-28 06:08:23");
INSERT INTO tbl_item VALUES("712","ABA692P","   REMOTE  YKQ-51-1 ","YKQ-51-1 ","","","27","","","","1","","0","","","","","","Screenshot_197_1672229401.png","0.00","0.00","0","0","1","1","2022-12-28 06:10:00");
INSERT INTO tbl_item VALUES("713","ABA693P","   REMOTE  EN-30507R","EN-30507R","","","27","","","","1","","0","","","","","","GHS_1672230431.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:27:11");
INSERT INTO tbl_item VALUES("714","ABA694P","   REMOTE  RM-606W","RM-606W","","","27","","","","1","","0","","","","","","JJ_1672230541.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:29:01");
INSERT INTO tbl_item VALUES("715","ABA695P","   REMOTE  RM-191A-1","RM-191A-1","","","27","","","","1","","0","","","","","","14_1672230688.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:31:28");
INSERT INTO tbl_item VALUES("716","ABA696P","   REMOTE  RM-569CB+","RM-569CB+","","","27","","","","1","","0","","","","","","6B_1672230750.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:32:30");
INSERT INTO tbl_item VALUES("717","ABA697P","   REMOTE  MR LED-63","MR LED-63","","","27","","","","1","","0","","","","","","63_1672230850.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:34:10");
INSERT INTO tbl_item VALUES("718","ABA698P","   REMOTE  SA-08F7","SA-08F7","","","27","","","","1","","0","","","","","","Screenshot_198_1672230946.png","0.00","0.00","0","0","1","1","2022-12-28 06:35:46");
INSERT INTO tbl_item VALUES("719","ABA699P","   REMOTE  RC-700","RC-700","","","27","","","","1","","0","","","","","","DFD_1672231005.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:36:45");
INSERT INTO tbl_item VALUES("720","ABA700P","   REMOTE  RS17-MT-92","RS17-MT-92","","","27","","","","1","","0","","","","","","92_1672231306.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:41:46");
INSERT INTO tbl_item VALUES("721","ABA701P","   REMOTE  RC-400","RC-400","","","27","","","","1","","0","","","","","","Screenshot_199_1672231451.png","0.00","0.00","0","0","1","1","2022-12-28 06:44:11");
INSERT INTO tbl_item VALUES("722","ABA702P","   REMOTE  DE-9580","DE-9580","","","27","","","","1","","0","","","","","","download (1)_1672231907.jpg","0.00","0.00","0","0","1","1","2022-12-28 06:51:47");
INSERT INTO tbl_item VALUES("723","ABA703P","   REMOTE  TOPE","TOPE","","","27","","","","1","","0","","","","","","Screenshot_200_1672232325.png","0.00","0.00","0","0","1","1","2022-12-28 06:58:45");
INSERT INTO tbl_item VALUES("724","ABA704P","   REMOTE  6IN1+ ","6IN1+ ","","","27","","","","1","","0","","","","","","Screenshot_201_1672232424.png","0.00","0.00","0","0","1","1","2022-12-28 07:00:24");
INSERT INTO tbl_item VALUES("725","ABA705P","   REMOTE  DE-100","DE-100","","","27","","","","1","","0","","","","","","Screenshot_202_1672232536.png","0.00","0.00","0","0","1","1","2022-12-28 07:02:16");
INSERT INTO tbl_item VALUES("726","ABA706P","   REMOTE  A8873-6V90","A8873-6V90","","","27","","","","1","","0","","","","","","Screenshot_203_1672233780.png","0.00","0.00","0","0","1","1","2022-12-28 07:23:00");
INSERT INTO tbl_item VALUES("727","ABA707P","   REMOTE  00345A","00345A","","","27","","","","1","","0","","","","","","Screenshot_204_1672233844.png","0.00","0.00","0","0","1","1","2022-12-28 07:24:04");
INSERT INTO tbl_item VALUES("728","ABA708P","   REMOTE  KK-1205","KK-1205","","","27","","","","1","","0","","","","","","FG_1672234169.jpg","0.00","0.00","0","0","1","1","2022-12-28 07:29:29");
INSERT INTO tbl_item VALUES("729","ABA709P","   REMOTE  TCL-F","TCL-F","","","27","","","","1","","0","","","","","","TCL_1672234240.jpg","0.00","0.00","0","0","1","1","2022-12-28 07:30:40");
INSERT INTO tbl_item VALUES("730","ABA710P","   REMOTE  RC-200","RC-200","","","27","","","","1","","0","","","","","","RC-200_1672234294.jpg","0.00","0.00","0","0","1","1","2022-12-28 07:31:34");
INSERT INTO tbl_item VALUES("731","ABA711P","   REMOTE  00F7-01","00F7-01","","","27","","","","1","","0","","","","","","HJ_1672234354.jpg","0.00","0.00","0","0","1","1","2022-12-28 07:32:34");
INSERT INTO tbl_item VALUES("732","ABA712P","   REMOTE  AT2-02","AT2-02","","","27","","","","1","","0","","","","","","JK_1672234435.jpg","0.00","0.00","0","0","1","1","2022-12-28 07:33:55");
INSERT INTO tbl_item VALUES("733","ABA713P","   REMOTE  SY-T1N","SY-T1N","","","27","","","","1","","0","","","","","","GHJ_1672234612.jpg","0.00","0.00","0","0","1","1","2022-12-28 07:36:52");
INSERT INTO tbl_item VALUES("734","ABA714P","   REMOTE  LX-131","LX-131","","","27","","","","1","","0","","","","","","Screenshot_205_1672293930.png","0.00","0.00","0","0","1","1","2022-12-29 12:05:30");
INSERT INTO tbl_item VALUES("735","ABA715P","   REMOTE  RC-100","RC-100","","","27","","","","1","","0","","","","","","SD_1672294049.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:07:29");
INSERT INTO tbl_item VALUES("736","ABA716P","   REMOTE  H-01C","H-01C","","","27","","","","1","","0","","","","","","Screenshot_206_1672294288.png","0.00","0.00","0","0","1","1","2022-12-29 12:11:28");
INSERT INTO tbl_item VALUES("737","ABA717P","   REMOTE  TC-01","TC-01","","","27","","","","1","","0","","","","","","AD_1672294579.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:16:19");
INSERT INTO tbl_item VALUES("738","ABA718P","   REMOTE  CH-LED 33","CH-LED 33","","","27","","","","1","","0","","","","","","ET_1672294879.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:21:19");
INSERT INTO tbl_item VALUES("739","ABA719P","   REMOTE  LED-1177","LED-1177","","","27","","","","1","","0","","","","","","ET_1672294969.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:22:49");
INSERT INTO tbl_item VALUES("740","ABA720P","   REMOTE  RC-500","RC-500","","","27","","","","1","","0","","","","","","WS_1672295114.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:25:14");
INSERT INTO tbl_item VALUES("741","ABA721P","   REMOTE  RC-71 SMART","RC-71 SMART","","","27","","","","1","","0","","","","","","HU_1672295198.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:26:38");
INSERT INTO tbl_item VALUES("742","ABA722P","   REMOTE  STAR LED Q101","STAR LED Q101","","","27","","","","1","","0","","","","","","QQ_1672295414.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:30:14");
INSERT INTO tbl_item VALUES("743","ABA723P","   REMOTE  DE-0707","DE-0707","","","27","","","","1","","0","","","","","","WT_1672295569.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:32:49");
INSERT INTO tbl_item VALUES("744","ABA724P","   REMOTE  RC-0707","RC-0707","","","27","","","","1","","0","","","","","","QW_1672295703.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:35:03");
INSERT INTO tbl_item VALUES("745","ABA725P","   REMOTE  STAR RC-606","STAR RC-606","","","27","","","","1","","0","","","","","","Screenshot_208_1672295841.png","0.00","0.00","0","0","1","1","2022-12-29 12:37:21");
INSERT INTO tbl_item VALUES("746","ABA726P","   REMOTE  STAR RANGS","STAR RANGS","","","27","","","","1","","0","","","","","","AF_1672295939.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:38:58");
INSERT INTO tbl_item VALUES("747","ABA727P","   REMOTE  RM-L1306","RM-L1306","","","27","","","","1","","0","","","","","","L1_1672296031.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:40:31");
INSERT INTO tbl_item VALUES("748","ABA728P","REMOTE KK-901A","LINXUAN KK-901A","","","27","","","","1","","0","","","","","","DJ_1672296128.jpg","0.00","0.00","0","0","1","1","2022-12-29 12:42:08");
INSERT INTO tbl_item VALUES("749","ABA729P","   REMOTE  5Z51-S2","5Z51-S2","","","27","","","","1","","0","","","","","","Screenshot_209_1672296712.png","0.00","0.00","0","0","1","1","2022-12-29 12:51:52");
INSERT INTO tbl_item VALUES("750","ABA730P","   REMOTE  STAR-RS09-M301","STAR-RS09-M301","","","27","","","","1","","0","","","","","","Screenshot_210_1672297071.png","0.00","0.00","0","0","1","1","2022-12-29 12:57:51");
INSERT INTO tbl_item VALUES("751","ABA731P","   REMOTE  STAR KK-271B","STAR KK-271B","","","27","","","","1","","0","","","","","","Screenshot_211_1672297335.png","0.00","0.00","0","0","1","1","2022-12-29 01:02:15");
INSERT INTO tbl_item VALUES("752","ABA732P","   REMOTE  SONY RM-882","SONY RM-882","","","27","","","","1","","0","","","","","","51x5bKt39dL_1672297400.jpg","0.00","0.00","0","0","1","1","2022-12-29 01:03:20");
INSERT INTO tbl_item VALUES("753","ABA733P","   ELECTRIC BOARD  4 HOLE","4 HOLE","","","28","","","","1","","0","","","","","","Screenshot_212_1672298465.png","0.00","0.00","0","0","1","1","2022-12-29 01:21:05");
INSERT INTO tbl_item VALUES("754","ABA734P","   ELECTRIC BOARD  8/10 HOLE","8/10 HOLE","","","28","","","","1","","0","","","","","","Screenshot_213_1672298528.png","0.00","0.00","0","0","1","1","2022-12-29 01:22:08");
INSERT INTO tbl_item VALUES("755","ABA735P","   ELECTRIC BOARD  6/8 HOLE","6/8 HOLE","","","28","","","","1","","0","","","","","","Screenshot_214_1672298597.png","0.00","0.00","0","0","1","1","2022-12-29 01:23:17");
INSERT INTO tbl_item VALUES("756","ABA736P","   ELECTRIC BOARD  8 HOLE","8 HOLE","","","28","","","","1","","0","","","","","","Screenshot_215_1672298865.png","0.00","0.00","0","0","1","1","2022-12-29 01:27:45");
INSERT INTO tbl_item VALUES("757","ABA737P","   ELECTRIC BOARD  3 HOLE","3 HOLE","","","28","","","","1","","0","","","","","","Screenshot_216_1672298940.png","0.00","0.00","0","0","1","1","2022-12-29 01:29:00");
INSERT INTO tbl_item VALUES("758","ABA738P","   ELECTRIC BOARD  2 HOLE","2 HOLE","","","28","","","","1","","0","","","","","","Screenshot_217_1672298988.png","0.00","0.00","0","0","1","1","2022-12-29 01:29:48");
INSERT INTO tbl_item VALUES("759","ABA739P","   ELECTRIC BOARD  5 HOLE","5 HOLE","","","28","","","","1","","0","","","","","","Screenshot_218_1672299040.png","0.00","0.00","0","0","1","1","2022-12-29 01:30:40");
INSERT INTO tbl_item VALUES("760","ABA740P","   ELECTRIC BOARD  1 HOLE","1 HOLE","","","28","","","","1","","0","","","","","","Screenshot_219_1672299086.png","0.00","0.00","0","0","1","1","2022-12-29 01:31:26");
INSERT INTO tbl_item VALUES("761","ABA741P","     4 GANG MK BOX","4 GANG MK BOX","","","","","","","1","","0","","","","","","SSL_1672299193.jpg","0.00","0.00","0","0","1","1","2022-12-29 01:33:13");
INSERT INTO tbl_item VALUES("762","ABA742P","     COMBINED MK BOX","COMBINED MK BOX","","","","","","","1","","0","","","","","","WI_1672299394.jpg","0.00","0.00","0","0","1","1","2022-12-29 01:36:34");
INSERT INTO tbl_item VALUES("763","ABA743P","     1 GANG MK BOX","1 GANG MK BOX","","","","","","","1","","0","","","","","","Gang-Switch-Council-Box-6_1672299480.jpg","0.00","0.00","0","0","1","1","2022-12-29 01:38:00");
INSERT INTO tbl_item VALUES("764","ABA744P","   ELECTRIC BOARD  6 HOLE","6 HOLE","","","28","","","","1","","0","","","","","","Screenshot_220_1672299543.png","0.00","0.00","0","0","1","1","2022-12-29 01:39:03");
INSERT INTO tbl_item VALUES("765","ABA745P","     2 GANG MK BOX","2 GANG MK BOX","","","","","","","1","","0","","","","","","EI_1672299597.jpg","0.00","0.00","0","0","1","1","2022-12-29 01:39:57");
INSERT INTO tbl_item VALUES("766","ABA746P","   ELECTRIC BOARD  3/3 HOLDER ","3/3 HOLDER ","","","28","","","","1","","0","","","","","","Screenshot_221_1672299953.png","0.00","0.00","0","0","1","1","2022-12-29 01:45:53");
INSERT INTO tbl_item VALUES("767","ABA747P","   ELECTRIC BOARD  METER","METER","","","28","","","","1","","0","","","","","","Screenshot_222_1672300055.png","0.00","0.00","0","0","1","1","2022-12-29 01:47:35");
INSERT INTO tbl_item VALUES("768","ABA748P","   ELECTRIC BOARD  3 GANG MK BOX","3 GANG MK BOX","","","28","","","","1","","0","","","","","","SFF_1672300130.jpg","0.00","0.00","0","0","1","1","2022-12-29 01:48:50");
INSERT INTO tbl_item VALUES("769","ABA749P","   LIGHT  LED SINGLE TUBE","LED SINGLE TUBE","","","21","","","","1","","0","","","","","","Screenshot_225_1672413297.png","0.00","0.00","0","0","1","1","2022-12-30 09:14:57");
INSERT INTO tbl_item VALUES("770","ABA750P","     MC D-LINK ( FULL PEAR )","MC D-LINK ( FULL PEAR )","","","","","","","14","","0","","","","","","Screenshot_226_1672660959.png","0.00","0.00","0","0","1","1","2023-01-02 06:02:39");
INSERT INTO tbl_item VALUES("771","ABA751P","   CAT  BD-PON CAT-5","BD-PON CAT-5","","","14","","","","1","","0","","","","","","Screenshot_227_1672729467.png","0.00","0.00","0","0","1","1","2023-01-03 01:04:27");
INSERT INTO tbl_item VALUES("772","ABA752P","ONU  HUAWEI XPON","HUAWEI XPON","","","12","","","","1","","0","","","","","","Huaw_1672840915.jpg","650.00","0.00","0","0","1","1","2023-01-04 08:01:55");
INSERT INTO tbl_item VALUES("773","ABA753P","   PLC  SPLITTER - 1*16","SPLITTER - 1*16","","","17","","","","1","","0","","","","","","PLC_1672847330.png","0.00","0.00","0","0","1","1","2023-01-04 09:48:50");
INSERT INTO tbl_item VALUES("774","ABA754P","   FIBER CABLE   USHA MARTIN - 6F","USHA MARTIN - 6F","","","16","","","","4","","0","","","","","","12F_1673009466.jpg","0.00","0.00","0","0","1","1","2023-01-06 06:51:06");
INSERT INTO tbl_item VALUES("775","ABA755P","   RG - 6  SMART CHILL TAMA 1.8","SMART CHILL TAMA 1.8","","","18","","","","24","","0","","","","","","4F_1673177373.png","0.00","0.00","0","0","1","1","2023-01-08 05:29:33");
INSERT INTO tbl_item VALUES("776","ABA756P","   RG - 6  RED DRAGON TAMA 2.0 WAY","RED DRAGON TAMA 2.0 WAY","","","18","","","","1","","0","","","","","","4F_1673178026.png","0.00","0.00","0","0","1","1","2023-01-08 05:40:26");
INSERT INTO tbl_item VALUES("777","ABA757P","   RG - 6  RED DRAGON TAMA 2.8 WAY","RED DRAGON TAMA 2.8 WAY","","","18","","","","1","","0","","","","","","12F_1673178519.jpg","0.00","0.00","0","0","1","1","2023-01-08 05:48:39");
INSERT INTO tbl_item VALUES("778","ABA758P","   LIGHT  LED REGULAR","LED REGULAR","","","21","","","","1","","0","","","","","","Screenshot_230_1673184795.png","0.00","0.00","0","0","1","1","2023-01-08 07:33:15");
INSERT INTO tbl_item VALUES("779","ABA759P","   LIGHT  SOLAR LED LIGHT","SOLAR LED LIGHT","","","21","","","","1","","0","","","","","","Screenshot_231_1673243657.png","0.00","0.00","0","0","1","1","2023-01-09 11:54:17");
INSERT INTO tbl_item VALUES("780","ABA760P","   CAT  SZADP LAN CAT-5","SZADP LAN CAT-5","","","14","","","","24","","0","","","","","","OUT_1673345095.jpg","0.00","0.00","0","0","1","1","2023-01-10 04:04:55");
INSERT INTO tbl_item VALUES("781","ABA761P","CAT  SZADP LAN RETAIL CAT-5","CAT SZADP LAN RETAIL CAT-5","","","14","","","","4","","0","","","","","","OUT_1673451197.jpg","0.00","0.00","0","0","1","1","2023-01-11 09:33:17");
INSERT INTO tbl_item VALUES("782","ABA762P","   LIGHT  60 WATT LED OSAKA","60 WATT LED OSAKA","","","21","","","","1","","0","","","","","","Screenshot_233_1673532119.png","0.00","0.00","0","0","1","1","2023-01-12 08:01:59");
INSERT INTO tbl_item VALUES("783","ABA763P","MICROTIK CCR","MICROTIK ","","","","","","","1","","0","","","","","","maxresdefault_1673683666.jpg","0.00","0.00","0","1","1","1","2023-01-14 02:07:46");
INSERT INTO tbl_item VALUES("784","ABA764P","     CC CAMERA ADAPTER BOX","CC CAMERA ADAPTER BOX","","","","","","","1","","0","","","","","","Screenshot_234_1673684756.png","0.00","0.00","0","0","1","1","2023-01-14 02:25:56");
INSERT INTO tbl_item VALUES("785","ABA765P","   ROUTER  TENDA AC23","TENDA AC23","","","11","","","","1","","0","","","","","","Screenshot_235_1674045897.png","0.00","0.00","0","1","1","1","2023-01-18 06:44:57");
INSERT INTO tbl_item VALUES("786","ABA766P","   FIBER CABLE   OFS CABLE - 4F","OFS CABLE - 4F","","","16","","","","4","","0","","","","","","BIZLI_1674108862.jpg","0.00","0.00","0","0","1","1","2023-01-19 12:14:22");
INSERT INTO tbl_item VALUES("787","ABA767P","ROUTER ONU ADAPTER - 12V","ROUTER ONU ADAPTER - 9V","","","","","","","1","","0","","","","","","Screenshot_236_1674216794.png","0.00","0.00","0","0","1","1","2023-01-20 06:13:14");
INSERT INTO tbl_item VALUES("788","ABA768P","RED DRAGON OUTDOOR CAT-6 SHOT","RED DRAGON INDOOR CAT-6","","","14","","","","4","","0","","","","","","6666_1674400182.png","0.00","0.00","0","0","1","1","2023-01-22 09:09:42");
INSERT INTO tbl_item VALUES("789","ABA769P","RG - 6  SATELLITE VISION MIX AKASH - 100M","SATELLITE VISION MIX AKASH - 100M","","","18","","","","4","","0","","","","","","TA_1674457153.jpg","0.00","0.00","0","0","1","1","2023-01-23 12:59:13");
INSERT INTO tbl_item VALUES("790","ABA770P","     MC NET-LINK ( B PART )","MC NET-LINK ( B PART )","","","","","","","1","","0","","","","","","DDHH_1674654452.jpg","0.00","0.00","0","0","1","1","2023-01-25 07:47:32");
INSERT INTO tbl_item VALUES("791","ABA771P","     TRENDNET CRIMPING TOOLS","TRENDNET CRIMPING TOOLS","","","","","","","1","","0","","","","","","Screenshot_237_1674740600.png","0.00","0.00","0","0","1","1","2023-01-26 07:43:20");
INSERT INTO tbl_item VALUES("792","ABA772P","     CABLE TESTER ( D - LINK )","CABLE TESTER ( D - LINK )","","","","","","","1","","0","","","","","","Screenshot_238_1674741240.png","0.00","0.00","0","0","1","1","2023-01-26 07:54:00");
INSERT INTO tbl_item VALUES("793","ABA773P","ONU  HUAWEI EPON ","HUAWEI EPON ","","","12","","","","1","","0","","","","","","Screenshot_239_1675147543.png","0.00","0.00","365","2","1","1","2023-01-31 12:45:43");
INSERT INTO tbl_item VALUES("794","ABA774P","1TB HDD (WD)","1TB HDD (WD)","","","","","","","1","","0","","","","","","Screenshot_240_1675169726.png","0.00","0.00","0","0","1","1","2023-01-31 06:55:26");
INSERT INTO tbl_item VALUES("795","ABA775P","     NET CONNECTOR / LAN CLIP (SMALL)","NET CONNECTOR / LAN CLIP (SMALL)","","","","","","","1","","0","","","","","","Screenshot_241_1675775986.png","0.00","0.00","0","0","1","1","2023-02-07 07:19:46");
INSERT INTO tbl_item VALUES("796","ABA776P","     HIKVISION 16CH DVR - US","HIKVISION 16CH DVR - US","","","","","","","1","","0","","","","","","SS_1675948966.jpg","0.00","0.00","0","0","1","1","2023-02-09 07:22:46");
INSERT INTO tbl_item VALUES("797","ABA777P","     HOLDER CERAMIC","HOLDER CERAMIC","","","","","","","1","","0","","","","","","HMM_1676112107.jpg","0.00","0.00","0","0","1","1","2023-02-11 04:41:47");
INSERT INTO tbl_item VALUES("798","ABA778P","  1111   SHARP AMPLIFIER-900MHZ","SHARP AMPLIFIER-900MHZ","","","","","","","","1","0","","","","1111","","","1150.00","1350.00","0","0","1","1","2023-02-16 08:19:50");
INSERT INTO tbl_item VALUES("799","ABA779P","     MSM 3.5+2.5 CAPACITAR","MSM 3.5+2.5 CAPACITAR","","","","","","","","1","0","","","","","","","57.00","150.00","0","0","1","1","2023-02-17 04:47:43");
INSERT INTO tbl_item VALUES("800","ABA780P","     CHINA AC/COT ","CHINA AC/COT ","","","","","","","","","0","","","","","","","20.00","30.00","0","0","1","1","2023-02-17 04:54:13");
INSERT INTO tbl_item VALUES("801","ABA781P","     JORA MITIEN","JORA MITIEN","","","","","","","","","0","","","","","","","0.00","0.00","730","0","1","1","2023-02-17 11:13:10");
INSERT INTO tbl_item VALUES("802","ABA782P","TP-LINK940 ","TP-LINK940 ","","","11","","","","20","","0","","","","","","","0.00","0.00","365","2","1","1","2023-02-18 06:34:14");
INSERT INTO tbl_item VALUES("803","ABA783P","C24 ROUTER  TP-LINK C64","TP-LINK C64","","","11","","","","1","","0","","","","C64","TP-LINK","archer-c64-02-500x500-1_1689768314.jpg","2850.00","3200.00","365","2","1","1","2023-02-18 07:17:55");
INSERT INTO tbl_item VALUES("804","ABA784P","C54   TP-LINK C54","TP-LINK C54","","","","","","2","1","1","0","","","","C54","TP-LINK","","0.00","0.00","365","2","1","1","2023-02-18 07:19:41");
INSERT INTO tbl_item VALUES("805","ABA785P","NETWORK SWITCH TP-LINK BASIC 8POT","NETWORK SWITCH TP-LINK BASIC 8POT","","","13","","","","20","","0","","","","","","","0.00","0.00","365","2","1","1","2023-02-19 12:30:37");
INSERT INTO tbl_item VALUES("806","ABA786P","     1.3MEGNA CABLE","1.3MEGNA CABLE","","","","","","","4","1","0","","","","","","","0.00","0.00","0","0","1","1","2023-02-19 09:57:43");
INSERT INTO tbl_item VALUES("807","ABA787P","2F PARAMOUNT FIBLER","2FIVER PARAMOUNT","","","16","","","","4","","0","","","","","","","0.00","0.00","0","0","1","1","2023-02-21 09:34:00");
INSERT INTO tbl_item VALUES("808","ABA788P","     LED OSAKA 65","LED OSAKA 65","","","","","","","1","","0","","","","","","","0.00","0.00","0","0","1","1","2023-02-25 09:21:39");
INSERT INTO tbl_item VALUES("809","ABA789P","     DAHUA HD CAMERA 1509TLQP DOME","DAHUA HD CAMERA 1509TLQP DOME","","","","","","","","","0","","","","","","","0.00","0.00","0","0","1","1","2023-03-04 11:07:27");
INSERT INTO tbl_item VALUES("810","ABA790P","     DAHUA XVR DH-XVR1B08H 1.5MP","DAHUA XVR DH-XVR1B08H 1.5MP","","","","","","","","","0","","","","","","","0.00","0.00","0","0","1","1","2023-03-04 11:09:05");
INSERT INTO tbl_item VALUES("811","ABA791P","     DH-HAC-1509MHP-A-LED","DH-HAC-1509MHP-A-LED","","","","","","","","","0","","","","","","","0.00","0.00","0","0","1","1","2023-03-04 11:10:13");
INSERT INTO tbl_item VALUES("812","ABA792P","2TB HHD WD","HDD 2TV HARDDIX","","","","","","","1","","0","","","","","","giant_217446_1693742515.jpg","0.00","0.00","0","2","1","1","2023-03-04 11:25:14");
INSERT INTO tbl_item VALUES("813","ABA793P","     DISH-LESER SHARP","DISH-LESER SHARP","","","","","","","","","0","","","","","","","1350.00","1700.00","0","0","1","1","2023-03-13 05:29:53");
INSERT INTO tbl_item VALUES("814","ABA794P","     FIBER OPTIC PATCH CORD - CIKON + MOTA ","FIBER OPTIC PATCH CORD - CIKON + MOTA ","","","","","","","1","","0","","","","","","","100.00","150.00","0","0","1","1","2023-03-16 05:27:10");
INSERT INTO tbl_item VALUES("815","ABA795P","     3.0 Megna RM 7.2-9 ","3.0 Megna RM 7.2-9 ","","","","","","","4","","0","","","","","","","52.75","70.00","0","0","1","1","2023-03-17 06:35:17");
INSERT INTO tbl_item VALUES("816","ABA796P","CAT 6 TAMA DAHUA","CAT 6 TAMA DAHUA","","","","","","2","4","1","0","","","","","","","610.00","35.00","0","0","1","1","2023-03-18 08:58:03");
INSERT INTO tbl_item VALUES("817","ABA797P","     SFP MEDIA MC CASING","SFP MEDIA MC CASING","","","","","","","1","","0","","","","","","","950.00","1100.00","0","0","1","1","2023-03-21 06:55:28");
INSERT INTO tbl_item VALUES("818","ABA798P","NETIS SWITCH 8 POT ","NETIS SWITCH 8 POT ","","","","","","","1","","0","","","","","","","700.00","800.00","365","2","1","1","2023-03-22 09:01:08");
INSERT INTO tbl_item VALUES("819","ABA799P","     NETIS SWITCH 5 POT ","NETIS SWITCH 5 POT ","","","","","","","1","","0","","","","","","","550.00","650.00","365","2","1","1","2023-03-22 09:02:10");
INSERT INTO tbl_item VALUES("820","ABA800P","     MONITOR LED 17 INCH","MONITOR LED 17 INCH","","","","","","","1","","0","","","","","","","3200.00","4500.00","0","0","1","1","2023-03-22 09:58:49");
INSERT INTO tbl_item VALUES("821","ABA801P","     TENDA SECURITY IP CAMERA CP3","TENDA SECURITY IP CAMERA CP3","","","","","","","1","","0","","","","","","","2310.00","2600.00","0","2","1","1","2023-03-23 05:50:40");
INSERT INTO tbl_item VALUES("822","ABA802P","     AVEIS EPON AV-OLT-E04-L3","AVEIS EPON AV-OLT-E04-L3","","","","","","","1","","0","","","","","","","0.00","0.00","0","2","1","1","2023-04-02 04:33:29");
INSERT INTO tbl_item VALUES("823","ABA803P","ONE CONNECT ONU GPON","ONE CONNECT ONU GPON","","","","","","","1","","0","","","","","","ONECONNECT_1680439754.jpg","900.00","1000.00","365","0","1","1","2023-04-02 06:49:14");
INSERT INTO tbl_item VALUES("824","ABA804P","     TP- LINK ARCHER AX23","TP- LINK ARCHER AX23","","","","","","","1","","0","","","","","","","0.00","0.00","365","2","1","1","2023-04-03 01:48:33");
INSERT INTO tbl_item VALUES("825","ABA805P","DBC EPON 9DB PON 20KM","DBC EPON 9DB PON 20KM","","","","","","","1","","0","","","","","","DBC-EPON-8dBi-PON-Module-500x500_1680694190.jpg","1900.00","3000.00","365","0","1","1","2023-04-05 05:29:50");
INSERT INTO tbl_item VALUES("826","ABA806P","     Splicer Machine Shinhu X-910 ","Splicer Machine Shinhu X-910 ","","","","","","","1","","0","","","","","","Shinho-X-910_1680793701.jpg","110000.00","115000.00","730","0","1","1","2023-04-06 09:08:21");
INSERT INTO tbl_item VALUES("827","ABA807P","     2f Bizli Cabol","2f Bizli Cabol","","","","","","","4","1","0","","","","","","","0.00","0.00","0","0","1","1","2023-04-11 09:29:03");
INSERT INTO tbl_item VALUES("828","ABA808P","     T.T 14/76 Megna","T.T 14/76 Megna","","","","","","","4","","0","","","","","","","0.00","0.00","0","0","1","1","2023-04-14 10:17:13");
INSERT INTO tbl_item VALUES("829","ABA809P","MAX GOLD FAN","MAX GOLD FAN","","","","","","","1","","0","","","","","","","0.00","0.00","0","0","1","1","2023-04-15 09:44:03");
INSERT INTO tbl_item VALUES("830","ABA810P","     1.5 RM BLACK MEGHNA CABLE ","1.5 RM BLACK MEGHNA CABLE ","","","","","","","4","","0","","","","","","1.0_1682772355.jpeg","26.14","28.45","0","0","1","1","2023-04-29 06:45:55");
INSERT INTO tbl_item VALUES("831","ABA811P","     Electric Hose Pipe 3/4","Electric Hose Pipe 3/4","","","","","","","4","","0","","","","","","1 (1)_1682773196.jpg","3.50","4.50","0","0","1","1","2023-04-29 06:59:56");
INSERT INTO tbl_item VALUES("832","ABA812P","     Electric Hose Pipe 5/5","Electric Hose Pipe 5/5","","","","","","","4","","0","","","","","","1 (1)_1682773291.jpg","3.50","5.50","0","0","1","1","2023-04-29 07:01:30");
INSERT INTO tbl_item VALUES("834","ABA814P","     SUN SOLAR SWITCH ","SUN SOLAR SWITCH ","","","","","","","1","","0","","","","","","download (3)_1683551129.jpg","25.00","50.00","0","0","1","1","2023-05-08 07:05:29");
INSERT INTO tbl_item VALUES("835","ABA815P","     ANIK ROUND BATTEN HOLDAR ","ANIK ROUND BATTEN HOLDAR ","","","","","","","1","","0","","","","","","download (2)_1683552031.jpg","23.00","40.00","0","0","1","1","2023-05-08 07:20:31");
INSERT INTO tbl_item VALUES("836","ABA816P","     ANIK MULTI-FUNCTIONAL 10 PIN SOCKET ","ANIK MULTI-FUNCTIONAL 10 PIN SOCKET ","","","","","","","1","","0","","","","","","download (4)_1683552172.jpg","0.00","0.00","0","0","1","1","2023-05-08 07:22:52");
INSERT INTO tbl_item VALUES("837","ABA817P","ANIK HI SPEED DC FAN 10 ,","ANIK HI SPEED DC FAN 10 ,","","","","","","","1","","0","","","","","","344574509_6214088465349932_7118826582723745123_n_1","550.00","650.00","0","0","1","1","2023-05-08 07:26:32");
INSERT INTO tbl_item VALUES("838","ABA818P","     12V DC LED TUBE ANIK ","12V DC LED TUBE ANIK ","","","","","","","1","","0","","","","","","images_1683553224.jpg","120.00","200.00","0","0","1","1","2023-05-08 07:40:24");
INSERT INTO tbl_item VALUES("839","ABA819P","     ","","","","","","","","","","0","","","","","","images_1683553269.jpg","0.00","0.00","0","0","1","1","2023-05-08 07:41:09");
INSERT INTO tbl_item VALUES("840","ABA820P","     NETIS DUAL BAND N2-AC 1200","NETIS DUAL BAND N2-AC 1200","","","","","","","1","","0","","","","","","n2-ac1200-1-500x500_1684243823.jpg","2754.00","3200.00","0","2","1","1","2023-05-16 07:30:23");
INSERT INTO tbl_item VALUES("841","ABA821P","     Havit HV-MS753 Optical Mouse","Havit HV-MS753 Optical Mouse","","","","","","","1","","0","","","","","","ms753-1-500x500_1685547452.jpg","200.00","350.00","0","0","1","1","2023-05-31 09:37:32");
INSERT INTO tbl_item VALUES("842","ABA822P","     Mixie X2 Mouse","Mixie X2 Mouse","","","","","","","1","","0","","","","","","download (5)_1685547696.jpg","100.00","250.00","0","0","1","1","2023-05-31 09:41:36");
INSERT INTO tbl_item VALUES("843","ABA823P","     D7 Speaker","D7 Speaker","","","","","","","1","","0","","","","","","download (6)_1685547926.jpg","350.00","400.00","0","0","1","1","2023-05-31 09:45:26");
INSERT INTO tbl_item VALUES("844","ABA824P","     TEAMGROUP USB FLASH DRIVE 64GB C186","TEAMGROUP USB FLASH DRIVE 64GB C186","","","","","","","1","","0","","","","","","c186-1-500x500_1685548188.jpg","500.00","750.00","0","0","1","1","2023-05-31 09:49:48");
INSERT INTO tbl_item VALUES("845","ABA825P","HDD 500GB ","HDD 500GB ","","","","","","","1","","0","","","","","","giant_217446_1685548512.jpg","1000.00","1300.00","0","0","1","1","2023-05-31 09:55:12");
INSERT INTO tbl_item VALUES("846","ABA826P","     TJ BOX 10 POT ","TJ BOX 10 POT ","","","","","","","1","","0","","","","","","8way-TJ-Box-1_1685709153.jpg","130.00","180.00","0","0","1","1","2023-06-02 06:32:33");
INSERT INTO tbl_item VALUES("847","ABA827P","     TOLSEN 180MM 7,, PLIERS","TOLSEN 180MM 7,, PLIERS","","","","","","","1","","0","","","","","","10015_1685885286.jpg","270.00","350.00","0","0","1","1","2023-06-04 07:28:06");
INSERT INTO tbl_item VALUES("848","ABA828P","     TOLSEN 160MM 6,, PLIERS","TOLSEN 160MM 6,, PLIERS","","","","","","","1","","0","","","","","","10015_1685885503.jpg","230.00","280.00","0","0","1","1","2023-06-04 07:31:43");
INSERT INTO tbl_item VALUES("849","ABA829P","     CIRCLE RECHARGEBLE FAN 12,, AC/DC","CIRCLE RECHARGEBLE FAN 12,, AC/DC","","","","","","","1","","0","","","","","","download (7)_1686131665.jpg","3800.00","4000.00","0","0","1","1","2023-06-07 03:54:25");
INSERT INTO tbl_item VALUES("850","ABA830P","     AV-CFS03 Fiber Stripper","AV-CFS03 Fiber Stripper","","","","","","","1","","0","","","","","","1679332265833_1686582539.jpg","850.00","1250.00","0","0","1","1","2023-06-12 09:08:59");
INSERT INTO tbl_item VALUES("851","ABA831P","ZKT ECO BS-852T22C IP BULLET CAMERA ","ZKT ECO BS-852T22C IP BULLET CAMERA ","","","","","","","1","","0","","","","","","BS-852T22C-S6 -S_(500x500)_1687251981.png","2200.00","2500.00","365","0","1","1","2023-06-20 03:04:38");
INSERT INTO tbl_item VALUES("852","ABA832P","     ZKT ECO Z8508N E R DVR","ZKT ECO Z8508N E R DVR","","","","","","","1","","0","","","","","","images (2)_1687252581.jpg","4500.00","5000.00","365","0","1","1","2023-06-20 03:16:21");
INSERT INTO tbl_item VALUES("853","ABA833P","     ONECONNECT ONU XPON ","ONECONNECT ONU XPON ","","","","","","","1","","0","","","","","","ONECONNECT_1687612604.jpg","800.00","900.00","365","0","1","1","2023-06-24 07:16:44");
INSERT INTO tbl_item VALUES("854","ABA834P","     FIBER CLEAVER AV-FC01","FIBER CLEAVER AV-FC01","","","","","","","1","","0","","","","","","images (3)_1688987604.jpg","6500.00","8500.00","0","0","1","1","2023-07-10 05:13:24");
INSERT INTO tbl_item VALUES("855","ABA835P","     Optical Cleaver Blade High Precision Fiber Cutting Knife ..B","Optical Cleaver Blade High Precision Fiber Cutting Knife ..BLADE","","","","","","","1","","0","","","","","","images (4)_1688987788.jpg","3000.00","3500.00","0","0","1","1","2023-07-10 05:16:28");
INSERT INTO tbl_item VALUES("856","ABA836P","     12V DC 1.5A Power CHARGAR STAR ","12V DC 1.5A Power CHARGAR STAR ","","","","","","","1","","0","","","","","","61k1E3yMRlL._AC_SL1000__1689158739.jpg","70.00","100.00","0","0","1","1","2023-07-12 04:45:39");
INSERT INTO tbl_item VALUES("857","ABA837P","     Maxline Multi Plug 358 3M","Maxline Multi Plug 358 3M","","","","","","","1","","0","","","","","","15.-Ml_358-1_1689686725.jpg","400.00","550.00","0","0","1","1","2023-07-18 07:25:25");
INSERT INTO tbl_item VALUES("858","ABA838P","     Maxline Multi Plug 348 3M","Maxline Multi Plug 348 3M","","","","","","","1","","0","","","","","","3.-Ml_348_1689686801.jpg","370.00","450.00","0","0","1","1","2023-07-18 07:26:41");
INSERT INTO tbl_item VALUES("859","ABA839P","     Maxline Multi Plug 704 USB 4MM","Maxline Multi Plug 704 USB 4MM","","","","","","","1","","0","","","","","","S42d9a5d9a39b483890d91527a6a1f153f_1689687254.jpg","440.00","600.00","0","0","1","1","2023-07-18 07:34:14");
INSERT INTO tbl_item VALUES("860","ABA840P","     Maxline Multi Plug 008 3M","Maxline Multi Plug 008 3M","","","","","","","1","","0","","","","","","19.-Ml_2010_1689687438.jpg","80.00","150.00","0","0","1","1","2023-07-18 07:37:18");
INSERT INTO tbl_item VALUES("861","ABA841P","     Maxline Multi Plug 70 2MM","Maxline Multi Plug 70 2MM","","","","","","","1","","0","","","","","","7e4287d444967480850dca6b565c25ef_1689687665.jpg","45.00","80.00","0","0","1","1","2023-07-18 07:41:04");
INSERT INTO tbl_item VALUES("862","ABA842P","     Maxline Multi Plug 402 3MM","Maxline Multi Plug 402 3MM","","","","","","","1","","0","","","","","","computer-accessories-0-294302_1689687776.jpg","22.00","50.00","0","0","1","1","2023-07-18 07:42:56");
INSERT INTO tbl_item VALUES("863","ABA843P","     Cona On-Off Dp Switch ","Cona On-Off Dp Switch ","","","","","","","1","","0","","","","","","4c2badd1e0f489107e963e5867d51ce7_1689689040.jpg","110.00","250.00","0","0","1","1","2023-07-18 08:04:00");
INSERT INTO tbl_item VALUES("864","ABA844P","     Cona Dp Socket Switch","Cona Dp Socket Switch","","","","","","","1","","0","","","","","","zRZTlxtAL2qfs-xxlarge_1689689253.jpg","145.00","250.00","0","0","1","1","2023-07-18 08:07:33");
INSERT INTO tbl_item VALUES("865","ABA845P","     Ceiling Mounted Hook Fan Hook With Royal Bolts","Ceiling Mounted Hook Fan Hook With Royal Bolts","","","","","","","1","","0","","","","","","77df637ab5cef96f68b7098e924f1761_1689690070.png","0.00","0.00","0","0","1","1","2023-07-18 08:21:10");
INSERT INTO tbl_item VALUES("866","ABA846P","     Changeover Switch Lotus ","Changeover Switch Lotus ","","","","","","","1","","0","","","","","","download (8)_1689690541.jpg","420.00","600.00","0","0","1","1","2023-07-18 08:29:01");
INSERT INTO tbl_item VALUES("867","ABA847P","     Water Level Switch -H","Water Level Switch -H","","","","","","","1","","0","","","","","","db7ecb378b09dba814243444bbfde5d0_1689690697.jpg","380.00","550.00","0","0","1","1","2023-07-18 08:31:37");
INSERT INTO tbl_item VALUES("868","ABA848P","     Water Level Switch -N","Water Level Switch -N","","","","","","","1","","0","","","","","","db7ecb378b09dba814243444bbfde5d0_1689690742.jpg","260.00","400.00","0","0","1","1","2023-07-18 08:32:22");
INSERT INTO tbl_item VALUES("869","ABA849P","     24 F Using Fiber","24 F Using Fiber","","","","","","","4","","0","","","","","","OUTT_1690723021.jpg","25.00","30.00","0","0","1","1","2023-07-30 07:17:01");
INSERT INTO tbl_item VALUES("870","ABA850P","     Tenda 8 Port Gigabit Switch","Tenda 8 Port Gigabit Switch","","","","","","","1","","0","","","","","","81hwBZ1DJTL._AC_SL1500__1690724779.jpg","1300.00","1550.00","0","2","1","1","2023-07-30 07:46:19");
INSERT INTO tbl_item VALUES("871","ABA851P","     DVR 4 Chanal","DVR 4 Chanal","","","","","","","1","","0","","","","","","20220523170437_110_150493_1690736562.jpg","3000.00","3500.00","0","0","1","1","2023-07-30 11:02:42");
INSERT INTO tbl_item VALUES("872","ABA852P","     Strip Messenger Cable 12 Core","Strip Messenger Cable 12 Core","","","","","","","4","","0","","","","","","images (5)_1690812890.jpg","45.00","50.00","0","0","1","1","2023-07-31 08:14:49");
INSERT INTO tbl_item VALUES("873","ABA853P","SATELITTE VISION EPON ONU ","SATELITTE VISION EPON ONU ","","","","","","","1","","0","","","","","","367640809_2050358325307230_2624642237412045722_n_1","670.00","750.00","365","0","1","1","2023-08-17 05:51:29");
INSERT INTO tbl_item VALUES("874","ABA854P","     DB MITAR ","DB MITAR ","","","","","","","1","","0","","","","","","Digital-DB-Meter_1692610854.jpg","5800.00","6500.00","0","0","1","1","2023-08-21 03:40:54");
INSERT INTO tbl_item VALUES("875","ABA855P","     TENDA SWITCH  TEG1016M ","TENDA SWITCH  TEG1016M ","","","","","","","1","","0","","","","","","p1_1692706606.png","2800.00","3200.00","0","2","1","1","2023-08-22 06:16:46");
INSERT INTO tbl_item VALUES("876","ABA856P","     BBS CABLES 2X1.2 RM/ ","BBS CABLES 2X1.2 RM/ ","","","","","","","4","","0","","","","","","bbs_77_1692706837.jpg","0.00","0.00","0","0","1","1","2023-08-22 06:20:37");
INSERT INTO tbl_item VALUES("877","ABA857P","DBC ONU XPON 1GE ORGINAL","DBC ONU XPON 1GE ORGINAL","","","","","","","1","","0","","","","","","3756_1693920187.jpg","0.00","0.00","0","2","1","1","2023-09-05 07:23:07");
INSERT INTO tbl_item VALUES("878","ABA858P","DBC ONU EPON 1GE ORGINAL","DBC ONU EPON 1GE ORGINAL","","","","","","","1","","0","","","","","","3756_1693922710.jpg","0.00","0.00","0","2","1","1","2023-09-05 08:05:10");
INSERT INTO tbl_item VALUES("879","ABA859P","     B-link Network Cable Cat-6","B-link Network Cable Cat-6","","","","","","","4","","0","","","","","","giant_169785_1694596830.jpg","0.00","0.00","0","0","1","1","2023-09-13 03:20:30");
INSERT INTO tbl_item VALUES("880","ABA860P","     PLAAS Set-Top Box (PLAAS ","PLAAS Set-Top Box (PLAAS ","","","","","","","1","","0","","","","","","024eae70fc723737e51d6cd8cfc724d7_1695728831.jpg","0.00","0.00","0","0","1","1","2023-09-26 05:47:11");
INSERT INTO tbl_item VALUES("881","ABA861P","TBS EPON 1 Port - Tech BD Solutions","XPON 1 Port - Tech BD Solutions","","","","","","","1","","0","","","","","","download (10)_1697453001.jpg","800.00","900.00","0","2","1","1","2023-10-16 04:43:21");
INSERT INTO tbl_item VALUES("882","ABA862P","     834T IC ","834T IC ","","","","","","","1","","0","","","","","","","210.00","350.00","0","0","1","1","2023-10-17 07:23:49");
INSERT INTO tbl_item VALUES("883","ABA863P","     887 IC","887 IC","","","","","","","1","","0","","","","","","","350.00","450.00","0","0","1","1","2023-10-17 07:26:13");
INSERT INTO tbl_item VALUES("884","ABA864P","     814 IC","814 IC","","","","","","","1","","0","","","","","","","350.00","450.00","0","0","1","1","2023-10-17 07:27:08");
INSERT INTO tbl_item VALUES("885","ABA865P","     A3 ARC Fiber Optic Fusion Splicer Machine     ","A3 ARC Fiber Optic Fusion Splicer Machine     ","","","","","","","1","","0","","","","","","giant_153887_1697614448.jpg","0.73","80000.00","730","0","1","1","2023-10-18 01:34:08");
INSERT INTO tbl_item VALUES("886","ABA866P","     WELTI V-SOL 4 PORT","WELTI V-SOL 4 PORT","","","","","","","","","0","","","","","","","0.00","0.00","0","0","1","1","2023-10-20 07:59:27");
INSERT INTO tbl_item VALUES("887","ABA867P","     HDMI CABEL","HDMI CABEL","","","","","","","","","0","","","","","","","0.00","0.00","0","0","1","1","2023-11-10 01:24:34");
INSERT INTO tbl_item VALUES("888","ABA868P","NETIS N3D","NETIS N3D","","","","","","","1","","0","","","","","","20231111_223027_1699720289.jpg","2129.00","2500.00","365","1","1","1","2023-11-11 10:31:28");
INSERT INTO tbl_item VALUES("889","ABA869P","     CUTTER BLADE CHOTO ","CUTTER BLADE CHOTO ","","","","","","","1","","0","","","","","","SDI 1361C CUTTER BLADE-600x800_1700050324.jpg","3.00","5.00","0","0","1","1","2023-11-15 06:12:04");
INSERT INTO tbl_item VALUES("890","ABA870P","     CUTTER BLADE BIG ","CUTTER BLADE BIG ","","","","","","","1","","0","","","","","","SDI 1361C CUTTER BLADE-600x800_1700050442.jpg","5.00","10.00","0","0","1","1","2023-11-15 06:14:02");
INSERT INTO tbl_item VALUES("891","ABA871P","     Xpart Combination Pliers 8,, Inches","Xpart Combination Pliers 8,, Inches","","","","","","","1","","0","","","","","","download (11)_1701007455.jpg","255.00","320.00","0","0","1","1","2023-11-26 08:04:15");
INSERT INTO tbl_item VALUES("892","ABA872P","     Xpart Combination Pliers 6 Inches","Xpart Combination Pliers 6 Inches","","","","","","","1","","0","","","","","","download (11)_1701007546.jpg","204.00","280.00","0","0","1","1","2023-11-26 08:05:46");
INSERT INTO tbl_item VALUES("893","ABA873P","     Xpart Cutting Plier 6,,","Xpart Cutting Plier 6,,","","","","","","","1","","0","","","","","","download (11)_1701007999.jpg","204.00","280.00","0","0","1","1","2023-11-26 08:13:19");
INSERT INTO tbl_item VALUES("894","ABA874P","     XPART SCREW DRIVER STAR 8,,","XPART SCREW DRIVER STAR 8,,","","","","","","","1","","0","","","","","","0347773_screw-driver-star-rb-6x250mm-10_400_170100","102.00","130.00","0","0","1","1","2023-11-26 08:19:30");
INSERT INTO tbl_item VALUES("895","ABA875P","     XPART SCREW DRIVER STAR 6,,","XPART SCREW DRIVER STAR 6,,","","","","","","","1","","0","","","","","","0347773_screw-driver-star-rb-6x250mm-10_400_170100","93.00","120.00","0","0","1","1","2023-11-26 08:21:17");
INSERT INTO tbl_item VALUES("896","ABA876P","     XPART SCREW DRIVER STAR 4,,","XPART SCREW DRIVER STAR 4,,","","","","","","","1","","0","","","","","","0347773_screw-driver-star-rb-6x250mm-10_400_170100","83.00","100.00","0","0","1","1","2023-11-26 08:22:42");
INSERT INTO tbl_item VALUES("897","ABA877P","Philips Monitors 19,,","Philips Monitors","","","","","","","1","","0","","","","","","philips_24_lcd_softblue_monito_1653458917_cd97dfe3","0.00","0.00","0","0","1","1","2023-12-31 05:50:17");
INSERT INTO tbl_item VALUES("898","ABA878P","     Circle Ceiling Fan 56&quot; ANGEL","Circle Ceiling Fan 56&quot; ANGEL","","","","","","","1","","0","","","","","","fan-9-scaled_1704027856.jpg","0.00","0.00","0","0","1","1","2023-12-31 07:04:16");
INSERT INTO tbl_item VALUES("899","ABA879P","     24 Hour Rechargeable Wi-Fi IP Camera W2-16","24 Hour Rechargeable Wi-Fi IP Camera W2-16","","","","","","","1","","0","","","","","","giant_142488_1704201064.jpg","0.00","0.00","0","0","1","1","2024-01-02 07:11:04");
INSERT INTO tbl_item VALUES("900","ABA880P","     Click Supreme Piano 2 Pin Socket","Click Supreme Piano 2 Pin Socket","","","","","","","","","0","","","","","","2P_1704706298.jpg","0.00","0.00","0","0","1","1","2024-01-08 03:31:38");
INSERT INTO tbl_item VALUES("901","ABA881P","     Click Piano Duplex-One Way Switch","Click Piano Duplex-One Way Switch","","","","","","","1","","0","","","","","","premium-two-way-switch-super-star_1704706486.jpg","0.00","0.00","0","0","1","1","2024-01-08 03:34:45");
INSERT INTO tbl_item VALUES("902","ABA882P","     ANIK Piano Switch","ANIK Piano Switch","","","","","","","1","","0","","","","","","2P_1704873731.jpg","15.00","30.00","0","0","1","1","2024-01-10 02:02:11");
INSERT INTO tbl_item VALUES("903","ABA883P","     Anik Piano Socket ","Anik Piano Socket ","","","","","","","1","","0","","","","","","2P_1704873811.jpg","15.00","30.00","0","0","1","1","2024-01-10 02:03:31");
INSERT INTO tbl_item VALUES("904","ABA884P","     Anik 3 Pin Plug With Fused","Anik 3 Pin Plug With Fused","","","","","","","1","","0","","","","","","plug_1704874090.jpg","55.00","70.00","0","0","1","1","2024-01-10 02:08:10");
INSERT INTO tbl_item VALUES("905","ABA885P","     Anik Solar Charge Controller ","Anik Solar Charge Controller ","","","","","","","1","","0","","","","","","unnamed_1704874367.jpg","450.00","550.00","0","0","1","1","2024-01-10 02:12:47");
INSERT INTO tbl_item VALUES("906","ABA886P","     SFP Sot","SFP Sot","","","","","","2","1","1","0","","","","","","","1010.00","1500.00","365","0","1","1","2024-01-11 05:07:58");
INSERT INTO tbl_item VALUES("907","ABA887P","     Tg Box Raver","Tg Box Raver","","","","","","","1","","0","","","","","","8way-TJ-Box-3_1705216301.jpg","0.00","0.00","0","0","1","1","2024-01-14 01:11:41");
INSERT INTO tbl_item VALUES("908","ABA888P","     LC LC Fiber Patch Cables 3MM","LC LC Fiber Patch Cables 3MM","","","","","","","1","","0","","","","","","71VyxpWJqsL._SL1500__1705390529.jpg","0.00","0.00","0","0","1","1","2024-01-16 01:35:29");
INSERT INTO tbl_item VALUES("909","ABA889P","     LC LC Fiber Patch Cables 5MM","LC LC Fiber Patch Cables 5MM","","","","","","","1","","0","","","","","","71VyxpWJqsL._SL1500__1705390555.jpg","0.00","0.00","0","0","1","1","2024-01-16 01:35:55");
INSERT INTO tbl_item VALUES("910","ABA890P","     Partex Cables 1.3 Mm","Partex Cables 1.3 Mm","","","","","","","4","","0","","","","","","a59efb55104333.5976f5f441e79_1705847452.jpg","22.00","0.00","0","0","1","1","2024-01-21 08:30:52");
INSERT INTO tbl_item VALUES("911","ABA891P","     Zibbix Zx-8080 L3 4*10g Uplink 8 Port Epon Olt","Zibbix Zx-8080 L3 4*10g Uplink 8 Port Epon Olt","","","","","","","1","","0","","","","","","download (12)_1705927207.jpg","65000.00","75000.00","0","0","1","1","2024-01-22 06:40:07");
INSERT INTO tbl_item VALUES("912","ABA892P","     EZVIZ CS-H6c 1080P Smart Home Camera","EZVIZ CS-H6c 1080P Smart Home Camera","","","","","","","1","","0","","","","","","ezviz-cs-h6c_1706082761.jpg","0.00","3200.00","0","0","1","1","2024-01-24 01:52:41");
INSERT INTO tbl_item VALUES("913","ABA893P","DAHUA IMOU RANGER-2-G (2.0MP) WI-FI DOME IP CAMERA","DAHUA IMOU RANGER-2-G (2.0MP) WI-FI DOME IP CAMERA","","","","","","","1","","0","","","","","","giant_229112_1706082926.jpg","2450.00","2900.00","365","2","1","1","2024-01-24 01:55:26");
INSERT INTO tbl_item VALUES("914","ABA894P","     V380 Pro VR Cam E27 Moving Holder System IP CCTV Cameras Wi-","V380 Pro VR Cam E27 Moving Holder System IP CCTV Cameras Wi-Fi Smart Camera Wireless IP Camera Wireless IR Night Vision Wifi Camera WiFi IP Camera CCTV PTZ Camera Home Security Wi-Fi ","","","","","","","1","","0","","","","","","a913cd2db7d638e16f66ed0298103d0d_1706083091.jpg","1250.00","1600.00","365","0","1","1","2024-01-24 01:58:11");
INSERT INTO tbl_item VALUES("915","ABA895P","     Tenda AC8 AC1200 Router","Tenda AC8 AC1200 Router","","","","","","","1","","0","","","","","","download (13)_1706776630.jpg","0.00","0.00","365","2","1","1","2024-02-01 02:37:10");
INSERT INTO tbl_item VALUES("916","ABA896P","     Partex Cables 1.5 Rm 7w","Partex Cables 1.5 Rm 7w","","","","","","","4","","0","","","","","","a59efb55104333.5976f5f441e79_1707203519.jpg","0.00","0.00","0","0","1","1","2024-02-06 01:11:59");
INSERT INTO tbl_item VALUES("917","ABA897P","     Partex Cables 2.5 Rm 7w ","Partex Cables 2.5 Rm 7w ","","","","","","","4","","0","","","","","","a59efb55104333.5976f5f441e79_1707203990.jpg","0.00","0.00","0","0","1","1","2024-02-06 01:19:50");
INSERT INTO tbl_item VALUES("918","ABA898P","     Partex Cables 23/76 White Calar","Partex Cables 23/76 White Calar","","","","","","","","","0","","","","","","a59efb55104333.5976f5f441e79_1707204438.jpg","0.00","0.00","0","0","1","1","2024-02-06 01:27:18");
INSERT INTO tbl_item VALUES("919","ABA899P","     Partex Cables 2.0 Rm 3w ","Partex Cables 2.0 Rm 3w ","","","","","","","4","","0","","","","","","a59efb55104333.5976f5f441e79_1707204666.jpg","0.00","0.00","0","0","1","1","2024-02-06 01:31:06");
INSERT INTO tbl_item VALUES("920","ABA900P","     Alcohol Pad ","Alcohol Pad ","","","","","","","1","","0","","100","","","","0f82ec8be67b42e3f4748ea3ab6ebc89_1707235085.jpg","0.00","0.00","66","0","1","1","2024-02-06 09:58:05");
INSERT INTO tbl_item VALUES("921","ABA901P","     Zyxel NBG-418N V2 300 Mbps Wireless Router","Zyxel NBG-418N V2 300 Mbps Wireless Router","","","","","","","1","","0","","","","","","nbg-418n-500x500_1707394876.jpg","0.00","0.00","365","2","1","1","2024-02-08 06:21:16");
INSERT INTO tbl_item VALUES("922","ABA902P","     OLT EPON 8 PON RJ451000M UPlink SFP 10G EPON OLT 10 Gigabit ","OLT EPON 8 PON RJ451000M UPlink SFP 10G EPON OLT 10 Gigabit 8 PON Port OLT GEPON Support L3","","","","","","","1","","0","","","","","","","0.00","0.00","0","0","1","1","2024-02-15 08:42:35");
INSERT INTO tbl_item VALUES("923","ABA903P","     RL8004EL 4 Port EPON OLT","RL8004EL 4 Port EPON OLT","","","","","","","1","","0","","","","","","img_2021-05-29_07-18-52_1708009614.jpg","30000.00","35000.00","0","0","1","1","2024-02-15 09:06:54");
INSERT INTO tbl_item VALUES("924","ABA904P","     Cisco Small Business 300 Series Managed Switches Cisco SF300","Cisco Small Business 300 Series Managed Switches Cisco SF300-24P","","","","","","","1","","0","","","","","","download (14)_1708090007.jpg","0.00","0.00","0","0","1","1","2024-02-16 07:26:47");
INSERT INTO tbl_item VALUES("925","ABA905P","     Cudy WR1200 AC1200 Dual Band WiFi Router","Cudy WR1200 AC1200 Dual Band WiFi Router","","","","","","","1","","0","","","","","","download (15)_1708241465.jpg","2150.00","2500.00","365","2","1","1","2024-02-18 01:31:05");
INSERT INTO tbl_item VALUES("926","ABA906P","     FUSION SPLICER FA-40S","FUSION SPLICER FA-40S","","","","","","","1","","0","","","","","","Splicer-600x600 (1)_1708251910.jpeg","75000.00","77000.00","0","0","1","1","2024-02-18 04:25:09");
INSERT INTO tbl_item VALUES("927","ABA907P","     CAMERA DAHUA FULL COLOR BULLET CAMERA - HFW1209CLP-A-LED","CAMERA DAHUA FULL COLOR BULLET CAMERA - HFW1209CLP-A-LED","","","","","","","1","","0","","","","","","COL_1708256620.jpg","0.00","0.00","0","0","1","1","2024-02-18 05:43:40");
INSERT INTO tbl_item VALUES("928","ABA908P","Dahua DH-HAC-HDW1209TLQP-A-LED/HAC-HDW1209CLQP-LED 2M Colo","Dahua DH-HAC-HDW1209TLQP-A-LED/HAC-HDW1209CLQP-A-LED 2M Color HDCVI Dome Camera Dahua DH-HAC-HDW1209TLQP-A-LED/HAC-HDW1209CLQP-A-LED 2M Color HDCVI Dome Camera","","","","","","","1","","0","","","","","","dahua-dh-hac-hdw1209tlqp-a-led-2m-color-hdcvi-dome","0.00","0.00","0","0","1","1","2024-02-18 05:47:19");
INSERT INTO tbl_item VALUES("929","ABA909P","     Hikvision 4 Channel DS-7104HGHI-F1 Turbo HD DVR ","Hikvision 4 Channel DS-7104HGHI-F1 Turbo HD DVR ","","","","","","","1","","0","","","","","","download (16)_1708258241.jpg","0.00","0.00","0","0","1","1","2024-02-18 06:10:41");
INSERT INTO tbl_item VALUES("930","ABA910P","     Dahua HAC-HFW1239TLMP-A-LED Bullet Camera","Dahua HAC-HFW1239TLMP-A-LED Bullet Camera","","","","","","","1","","0","","","","","","download (17)_1708259346.jpg","0.00","0.00","0","0","1","1","2024-02-18 06:29:06");
INSERT INTO tbl_item VALUES("931","ABA911P","     FIBER CABLE USING -8F","FIBER CABLE USING -8F","","","","","","","4","","0","","","","","","4F_1708318384.png","20.00","25.00","0","0","1","1","2024-02-19 10:53:04");
INSERT INTO tbl_item VALUES("932","ABA912P","     BDCOM P3600-04-2AC 4-Port 10G EPON OLT","BDCOM P3600-04-2AC 4-Port 10G EPON OLT","","","","","","","1","","0","","","","","","giant_244086_1708428083.jpg","51500.00","51500.00","0","0","1","1","2024-02-20 05:21:23");
INSERT INTO tbl_item VALUES("933","ABA913P","     MX CRIMPER TOOLS","MX CRIMPER TOOLS","","","","","","","1","","0","","","","","","41aPLI10MEL._AC_UF1000,1000_QL80__1708501745.jpg","350.00","500.00","0","0","1","1","2024-02-21 01:49:05");
INSERT INTO tbl_item VALUES("934","ABA914P","     15V 5A Power Supply, Universal AC 100-240V To DC","15V 5A Power Supply, Universal AC 100-240V To DC","","","","","","","1","","0","","","","","","images (7)_1708502018.jpg","1500.00","1800.00","0","0","1","1","2024-02-21 01:53:38");
INSERT INTO tbl_item VALUES("935","ABA915P","     Mini HDMI To AV Converter","Mini HDMI To AV Converter","","","","","","","1","","0","","","","","","download (18)_1709217469.jpg","420.00","500.00","0","0","1","1","2024-02-29 08:37:49");
INSERT INTO tbl_item VALUES("936","ABA916P","     MULTIPLUG SAFE TOUCH - 0032 5M","MULTIPLUG SAFE TOUCH - 0032 5M","","","","","","","1","","0","","","","","","32_1669984476_1710487162.png","0.00","0.00","0","0","1","1","2024-03-15 01:19:22");
INSERT INTO tbl_item VALUES("937","ABA917P","DBC-GP-C+++ GPON SFP 9DB PON Module","DBC-GP-C+++ GPON SFP PON Module","","","","","","","1","","0","","","","","","DBC-EPON-8dBi-PON-Module-500x500 (1)_1710920946.jp","0.00","0.00","0","0","1","1","2024-03-20 01:21:59");
INSERT INTO tbl_item VALUES("938","ABA918P","     TL-SG116 | 16-Port Gigabit Desktop Switch - TP-Link","TL-SG116 | 16-Port Gigabit Desktop Switch - TP-Link","","","","","","","1","","0","","","","","","TL_SG116(UN)1.0_03_normal_1526630238919t_171197750","3000.00","4200.00","365","2","1","1","2024-04-01 07:18:21");
INSERT INTO tbl_item VALUES("939","ABA919P","     Tenda S16 - 16-Port Desktop Switch","Tenda S16 - 16-Port Desktop Switch","","","","","","","1","","0","","","","","","313xxH3SkZS._SL500_._AC_SL500__1711977736.jpg","1500.00","1950.00","0","2","1","1","2024-04-01 07:22:16");
INSERT INTO tbl_item VALUES("940","ABA920P","CCTV CAMERA STAND 10 INCH","CCTV CAMERA STAND 10 INCH","","","","","","","1","","0","","","","","","download (19)_1711978114.jpg","0.00","0.00","0","0","1","1","2024-04-01 07:28:34");
INSERT INTO tbl_item VALUES("941","ABA921P","     Marsriva KP1 EC 8000mAh Mini DC UPS For Router","Marsriva KP1 EC 8000mAh Mini DC UPS For Router","","","","","","","1","","0","","","","","","fitted_1711979811.jpg","0.00","0.00","0","2","1","1","2024-04-01 07:56:51");
INSERT INTO tbl_item VALUES("942","ABA922P","     MARSRIVA KP2 10000mAh Smart Mini DC UPS For Router","MARSRIVA KP2 10000mAh Smart Mini DC UPS For Router","","","","","","","1","","0","","","","","","","0.00","0.00","0","2","1","1","2024-04-01 08:01:02");
INSERT INTO tbl_item VALUES("943","ABA923P","     BD-PON PON MODULE 9DB","BD-PON PON MODULE 9DB","","","","","","","1","","0","","","","","","IMG_20200928_185826-removebg-preview_1712587187.pn","0.00","0.00","0","0","1","1","2024-04-08 08:39:47");
INSERT INTO tbl_item VALUES("944","ABA924P","     CIRCUIT BREAKER MEP DUBLE - 63A","CIRCUIT BREAKER MEP DUBLE - 63A","","","","","","","1","","0","","","","","","images (8)_1713451504.jpg","0.00","0.00","0","0","1","1","2024-04-18 08:45:04");
INSERT INTO tbl_item VALUES("945","ABA925P","     LED Light, 12V DC Light, 5Watt 12V Solar Bulb (DC Bulb)","LED Light, 12V DC Light, 5Watt 12V Solar Bulb (DC Bulb)","","","","","","","1","","0","","","","","","74eda10c77881064773af97a636f78be_1714122744.png","0.00","0.00","0","0","1","1","2024-04-26 03:12:24");
INSERT INTO tbl_item VALUES("946","ABA926P","     Circle 56&quot; ANGEL Fan","Circle 56&quot; ANGEL Fan","","","","","","","1","","0","","","","","","0000992_circle-56-angel-fan_510_1714541088.png","2880.00","3600.00","3650","0","1","1","2024-05-01 11:24:48");
INSERT INTO tbl_item VALUES("947","ABA927P","     Circle Celling Fan 56 &quot; - (Ivory Gold)","Circle Celling Fan 56 &quot; - (Ivory Gold)","","","","","","","1","","0","","","","","","7f42932c744a7559c591e71e46063f67_1714541786.jpg","2940.00","3600.00","3650","0","1","1","2024-05-01 11:36:26");
INSERT INTO tbl_item VALUES("948","ABA928P","CIRCLE     Circle 56&quot; AVENGERS Fan","Circle 56&quot; AVENGERS Fan","","","","","11","","1","","0","","","","","","images (9)_1714541974.jpg","2940.00","3600.00","3650","0","1","1","2024-05-01 11:39:33");
INSERT INTO tbl_item VALUES("949","ABA929P","CIRCLE   FAN  Circle 56&quot; PLATINUM Fan","Circle 56&quot; PLATINUM Fan","","","29","","11","","1","1","0","","","","","","download (20)_1714542123.jpg","2940.00","3600.00","3650","0","1","1","2024-05-01 11:42:03");
INSERT INTO tbl_item VALUES("950","ABA930P","CIRCLE   FAN  Circle Ceiling Fan Model - Magic Gold","Circle Ceiling Fan Model - Magic Gold","","","29","","11","","1","","0","","","","","","30b4cc70df76d162f0e72d34ca4edb1b_1714542259.jpg","2150.00","2500.00","1825","0","1","1","2024-05-01 11:44:19");
INSERT INTO tbl_item VALUES("951","ABA931P","  ec220-g5 ROUTER  Tp-link Ec220-g5","Tp-link Ec220-g5","","","11","","","2","","","0","","","","ec220-g5","excel","","2720.00","3500.00","365","2","1","1","2024-05-10 04:52:14");
INSERT INTO tbl_item VALUES("952","ABA932P","   fiver 6f  Fiver Solution 6f","Fiver Solution 6f","","","30","","","","4","","0","","","","","fiver solution","","14.50","16.00","0","0","1","1","2024-05-14 04:18:39");
INSERT INTO tbl_item VALUES("953","ABA933P","DBC 2 PORT EPON ONU ","DBC 2 PORT EPON ONU ","","","","","","","1","","0","","","","","","S1f56e3148cc54692b82b2cd16f6b6f886_1715950164.jpg","0.00","0.00","365","0","1","1","2024-05-17 06:49:24");
INSERT INTO tbl_item VALUES("954","ABA934P","     Router De 300Mbps, IMOU HR300 ","Router De 300Mbps, IMOU HR300 ","","","","","","","1","","0","","","","","","IMOU-HR300B_1717683172.webp","0.00","0.00","730","2","1","1","2024-06-06 08:12:52");
INSERT INTO tbl_item VALUES("955","ABA935P","     Router Wifi Imou HR12F (4 Anten)","Router Wifi Imou HR12F (4 Anten)","","","","","","","1","","0","","","","","","images (10)_1717683296.jpg","0.00","0.00","730","2","1","1","2024-06-06 08:14:56");
INSERT INTO tbl_item VALUES("956","ABA936P","     FIIBER SOLUTION 12F ","FIIBER SOLUTION 12F ","","","","","","","4","","0","","","","","","USA_1717937684.jpg","20.50","25.00","0","0","1","1","2024-06-09 06:54:44");
INSERT INTO tbl_item VALUES("957","ABA937P","OSAKA 18.5 Watt ACDC Backup LED Bulb Emergency","OSAKA 10 Watt ACDC Backup LED Bulb Emergency","","","","","","","1","","0","","","","","","download (21)_1718173297.jpg","755.00","800.00","0","0","1","1","2024-06-12 12:21:37");
INSERT INTO tbl_item VALUES("958","ABA938P","ONU  Tbs 1ge Xpon","Tbs 1ge Xpon","","","12","","","","1","2","0","","","","","","","800.00","900.00","365","2","1","1","2024-07-06 10:15:15");
INSERT INTO tbl_item VALUES("959","ABA939P","     AERECH AE-EPON 9DB+++20KM","AERECH AE-EPON 9DB+++20KM","","","","","","","1","","0","","","","","","1716452539990 (1)_1720444890.jfif","1800.00","2500.00","365","2","1","1","2024-07-08 07:21:30");
INSERT INTO tbl_item VALUES("960","ABA940P","     AERECH-AE-SFP-TX1310-20KM","AERECH-AE-SFP-TX1310-20KM","","","","","","","1","","0","","","","","","1716452539990_1720445277.jfif","525.00","700.00","0","2","1","1","2024-07-08 07:27:57");
INSERT INTO tbl_item VALUES("961","ABA941P","     AERECH-AE-SFP-TX1550 20KM","AERECH-AE-SFP-TX1550 20KM","","","","","","","1","","0","","","","","","1716452539990_1720445356.jfif","525.00","700.00","365","2","1","1","2024-07-08 07:29:16");
INSERT INTO tbl_item VALUES("962","ABA942P","     DAK CABOL 1 METER","DAK CABOL 1 METER","","","","","","2","1","2","0","","","","","","","0.00","800.00","0","0","1","1","2024-08-08 11:16:31");
INSERT INTO tbl_item VALUES("963","ABA943P","     DAC CABLE 1 METER","DAC CABLE 1 METER","","","","","","2","","1","0","","","","","","","0.00","1250.00","0","0","1","1","2024-08-08 11:21:11");
INSERT INTO tbl_item VALUES("964","ABA944P","     ROUTER TENDA F3 B","ROUTER TENDA F3 B","","","","","","","1","","0","","","","","","","1200.00","1250.00","365","0","1","1","2024-08-15 06:13:39");
INSERT INTO tbl_item VALUES("965","ABA945P","     DBC 10G SFP 1270nm 40KM","DBC 10G SFP 1270nm 40KM","","","","","","2","1","2","0","","","","","","","1900.00","2500.00","365","0","1","1","2024-08-15 07:42:28");
INSERT INTO tbl_item VALUES("966","ABA946P","     DBC 10G SFP 1330nm 40KM","DBC 10G SFP 1330nm 40KM","","","","","","2","1","2","0","","","","","","","1900.00","2500.00","365","0","1","1","2024-08-15 07:44:31");
INSERT INTO tbl_item VALUES("967","ABA947P","     WGP UPS POWER BANK                                          ","WGP UPS POWER BANK                                                                                                                                                                                                                       ","","","","","","","1","","0","","","","","","","1370.00","1700.00","0","0","1","1","2024-08-20 01:09:34");
INSERT INTO tbl_item VALUES("968","ABA948P","     DAC CABLE 2 METER","DAC CABLE 2 METER","","","","","","","4","","0","","","","","","","1100.00","1400.00","0","0","1","1","2024-08-29 02:54:58");
INSERT INTO tbl_item VALUES("969","ABA949P","     DAC CABLE 3 METER 10G","DAC CABLE 3 METER 10G","","","","","","","4","","0","","","","","","","1300.00","1550.00","0","0","1","1","2024-08-29 02:55:47");
INSERT INTO tbl_item VALUES("970","ABA950P","     Operator Networking Solution 1G Onu","Operator Networking Solution 1G Onu","","","","","","","1","","0","","","","","","","700.00","800.00","365","2","1","1","2024-09-10 12:45:21");
INSERT INTO tbl_item VALUES("971","ABA951P","     Partex Cables 1.4.0rm 7w ","Partex Cables 1.4.0rm 7w ","","","","","","","1","","0","","","","","","c1dd8655104333.5976f5f42eb56_1726141017.jpg","73.69","100.00","0","0","1","1","2024-09-12 05:36:57");



CREATE TABLE `tbl_journalde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `did` int(11) NOT NULL,
  `dtype` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `cid` int(11) NOT NULL,
  `ctype` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=447 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_journalde VALUES("18","0","5","3","CU","12770.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("19","0","6","1","CU","24997.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("20","0","7","4","CU","8456.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("21","0","8","5","CU","2349.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("22","0","9","6","CU","4404.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("23","0","10","7","CU","14385.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("24","0","11","8","CU","4960.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("25","0","12","9","CU","28958.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("26","0","13","10","CU","20522.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("27","0","14","11","CU","14260.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("28","0","15","12","CU","23018.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("29","0","16","13","CU","17300.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("30","0","17","14","CU","7030.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("31","0","18","16","CU","11500.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("32","0","19","17","CU","3858.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("33","0","20","18","CU","2540.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("34","0","21","27","CU","10635.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("35","0","22","19","CU","8258.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("36","0","23","20","CU","2250.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("37","0","24","21","CU","23074.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("38","0","25","22","CU","18662.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("40","0","27","29","CU","9081.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("41","0","28","30","CU","13930.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("42","0","29","23","CU","7461.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("43","0","30","31","CU","2405.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("44","0","31","32","CU","31894.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("45","0","32","45","CU","17240.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("47","0","34","46","CU","3310.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("51","0","38","34","CU","54646.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("56","0","43","71","LE","74052.00","37","SU","","","0","");
INSERT INTO tbl_journalde VALUES("57","0","44","48","CU","94364.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("58","0","45","1","CU","75.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("59","0","46","1","CU","30.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("60","0","47","5","LE","138047.62","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("61","0","48","1","LE","27030.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("63","0","50","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("64","0","51","1","LE","80.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("68","0","55","72","CU","17177.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("71","0","58","1","LE","8550.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("72","0","59","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("76","0","63","5","LE","40377.20","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("78","0","65","1","LE","800.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("79","0","66","1","LE","400.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("80","0","67","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("90","0","77","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("92","0","79","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("93","0","80","1","LE","600.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("94","0","81","28","CU","10951.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("95","0","82","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("96","0","83","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("97","0","84","1","LE","370.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("98","0","85","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("99","0","86","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("100","0","87","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("117","0","104","18","CU","4000.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("118","0","105","31","CU","9845.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("119","0","106","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("128","0","115","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("138","0","125","2","LE","21222.00","5","LE","","","0","");
INSERT INTO tbl_journalde VALUES("139","0","126","1","LE","580.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("145","0","132","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("150","0","137","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("159","0","146","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("163","0","150","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("164","0","151","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("165","0","152","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("166","0","153","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("167","0","154","1","LE","5000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("168","0","155","1","LE","35.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("169","0","156","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("170","0","157","1","LE","10.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("171","0","158","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("172","0","159","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("173","0","160","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("174","0","161","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("176","0","163","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("177","0","164","1","LE","400.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("178","0","165","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("179","0","166","1","LE","120.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("180","0","167","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("181","0","168","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("183","0","170","1","LE","90.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("184","0","171","1","LE","25.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("192","0","179","71","LE","12578.00","43","SU","","","0","");
INSERT INTO tbl_journalde VALUES("202","0","189","1","LE","175.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("205","0","192","1","LE","1600.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("206","0","193","134","CU","25240.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("207","0","194","144","CU","20000.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("208","0","195","1","LE","490.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("209","0","196","1","LE","640.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("210","0","197","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("211","0","198","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("212","0","199","1","LE","60.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("213","0","200","133","CU","4400.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("214","0","201","117","CU","8500.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("215","0","202","151","CU","17850.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("216","0","203","152","CU","6143.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("217","0","204","153","CU","5350.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("218","0","205","92","CU","3500.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("219","0","206","154","CU","1450.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("220","0","207","108","CU","2200.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("221","0","208","7","CU","473.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("222","0","209","120","CU","2200.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("223","0","210","21","CU","300.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("224","0","211","81","CU","6600.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("225","0","212","155","CU","1750.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("226","0","213","11","CU","10445.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("227","0","214","78","CU","2285.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("228","0","215","8","CU","1520.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("229","0","216","86","CU","500.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("230","0","217","131","CU","2570.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("231","0","218","67","CU","4395.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("232","0","219","25","CU","3022.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("233","0","220","141","CU","3800.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("234","0","221","156","CU","3000.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("235","0","222","101","CU","6300.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("236","0","223","157","CU","4700.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("237","0","224","84","CU","2200.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("238","0","225","158","CU","1800.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("239","0","226","113","CU","13437.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("240","0","227","71","LE","96600.00","7","SU","","","0","");
INSERT INTO tbl_journalde VALUES("241","0","228","71","LE","428775.00","4","SU","","","0","");
INSERT INTO tbl_journalde VALUES("242","0","229","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("243","0","230","144","CU","69940.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("244","0","231","159","CU","3260.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("245","0","232","160","CU","35197.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("246","0","233","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("250","0","237","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("251","0","238","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("252","0","239","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("253","0","240","1","LE","8800.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("254","0","241","162","CU","12450.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("255","0","242","163","CU","4600.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("256","0","243","164","CU","7237.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("258","0","245","71","LE","1450.00","45","SU","","","0","");
INSERT INTO tbl_journalde VALUES("259","0","245","91","CU","17092.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("260","0","246","76","CU","9400.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("261","0","247","3","CU","10625.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("262","0","248","3","CU","7240.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("263","0","249","1","LE","320.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("264","0","250","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("265","0","251","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("266","0","252","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("268","0","254","168","CU","16810.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("269","0","255","150","CU","35783.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("270","0","256","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("271","0","257","1","LE","55.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("272","0","258","1","LE","1200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("274","0","260","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("275","0","261","1","LE","110.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("276","0","262","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("277","0","263","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("278","0","264","1","LE","6800.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("279","0","265","1","LE","15.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("280","0","266","52","CU","15548.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("281","0","267","52","CU","3500.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("282","0","268","1","LE","140.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("283","0","269","176","CU","26000.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("284","0","270","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("285","0","271","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("286","0","272","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("287","0","273","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("288","0","274","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("289","0","275","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("290","0","276","1","LE","2000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("292","0","278","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("293","0","279","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("294","0","280","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("296","0","282","71","LE","36735.00","1","SU","","","0","");
INSERT INTO tbl_journalde VALUES("297","0","283","55","CU","69940.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("300","0","286","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("304","0","290","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("307","0","293","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("308","0","294","1","LE","100.00","2","LE","","","0","KASEM");
INSERT INTO tbl_journalde VALUES("310","0","296","1","LE","150.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("311","0","297","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("314","0","300","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("315","0","301","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("316","0","302","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("317","0","303","1","LE","10.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("319","0","305","1","LE","30.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("320","0","306","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("321","0","307","1","LE","1600.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("324","0","310","1","LE","535.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("325","0","311","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("326","0","312","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("327","0","313","1","LE","10.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("328","0","314","1","LE","3000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("329","0","315","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("330","0","316","1","LE","320.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("331","0","317","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("332","0","318","1","LE","10.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("333","0","319","63","CU","800.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("334","0","320","1","LE","470.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("335","0","321","1","LE","80.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("336","0","322","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("337","0","323","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("339","0","325","1","LE","80.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("340","0","326","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("341","0","327","63","CU","200.00","33","LE","","","0","");
INSERT INTO tbl_journalde VALUES("342","0","328","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("343","0","329","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("344","0","330","1","LE","10.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("345","0","331","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("346","0","332","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("347","0","333","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("348","0","334","1","LE","90.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("349","0","335","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("350","0","336","71","LE","5014.80","138","CU","","","0","");
INSERT INTO tbl_journalde VALUES("355","0","341","71","LE","10930.00","50","SU","","","0","");
INSERT INTO tbl_journalde VALUES("356","0","342","1","LE","320.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("357","0","343","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("358","0","344","1","LE","130.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("359","0","345","1","LE","1100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("360","0","346","1","LE","18.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("363","0","349","71","LE","1456.00","40","SU","","","0","");
INSERT INTO tbl_journalde VALUES("364","0","350","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("365","0","351","1","LE","370.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("366","0","352","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("367","0","353","1","LE","2000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("368","0","354","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("370","0","356","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("373","0","359","1","LE","61.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("374","0","360","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("375","0","361","1","LE","1452.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("377","0","363","1","LE","230.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("378","0","364","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("383","0","369","71","LE","120000.00","12","SU","","","0","");
INSERT INTO tbl_journalde VALUES("384","0","370","1","LE","460.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("386","0","372","1","LE","430.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("387","0","373","1","LE","30.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("388","0","374","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("389","0","375","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("390","0","376","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("393","0","379","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("394","0","380","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("395","0","381","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("396","0","382","1","LE","30.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("397","0","383","1","LE","30.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("398","0","384","1","LE","10.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("399","0","385","1","LE","125.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("400","0","386","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("401","0","387","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("402","0","388","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("403","0","389","1","LE","15.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("405","0","391","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("406","0","392","1","LE","500.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("408","0","394","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("409","0","395","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("410","0","396","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("411","0","397","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("412","0","398","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("413","0","399","1","LE","1000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("415","0","401","1","LE","5000.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("417","0","403","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("419","0","405","33","LE","350.00","224","CU","","","0","");
INSERT INTO tbl_journalde VALUES("420","0","406","71","LE","559.00","46","SU","","","0","");
INSERT INTO tbl_journalde VALUES("422","0","408","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("423","0","409","1","LE","20.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("424","0","410","1","LE","520.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("425","0","411","1","LE","300.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("426","0","412","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("427","0","413","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("428","0","414","1","LE","200.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("429","0","415","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("430","0","416","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("431","0","417","1","LE","260.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("432","0","418","1","LE","3800.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("433","0","419","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("434","0","420","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("438","0","424","1","LE","100.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("439","0","425","1","LE","145.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("440","0","426","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("441","0","427","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("444","0","430","1","LE","50.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("445","0","431","1","LE","3.00","2","LE","","","0","");
INSERT INTO tbl_journalde VALUES("446","0","432","1","LE","50.00","2","LE","","","0","");



CREATE TABLE `tbl_parent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `bname` varchar(255) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;




CREATE TABLE `tbl_payvoucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `brid` int(11) DEFAULT 0,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=427 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_payvoucher VALUES("2","PAV201222101","","10000.00","2022-12-20","0","1","2022-12-20 08:58:03");
INSERT INTO tbl_payvoucher VALUES("8","PAV221222102","","10000.00","2022-12-22","0","1","2022-12-22 10:25:18");
INSERT INTO tbl_payvoucher VALUES("9","PAV231222101","","50.00","2022-12-23","0","1","2022-12-23 08:48:14");
INSERT INTO tbl_payvoucher VALUES("13","PAV241222101","","110000.00","2022-12-22","0","1","2022-12-24 04:54:50");
INSERT INTO tbl_payvoucher VALUES("14","PAV241222102","","5000.00","2022-12-24","0","1","2022-12-24 07:12:27");
INSERT INTO tbl_payvoucher VALUES("17","PAV261222102","","5000.00","2022-12-26","0","1","2022-12-26 07:41:48");
INSERT INTO tbl_payvoucher VALUES("19","PAV261222104","","50.00","2022-12-26","0","1","2022-12-26 08:41:20");
INSERT INTO tbl_payvoucher VALUES("24","PAV271222101","","5650.00","2022-12-27","0","1","2022-12-27 04:12:02");
INSERT INTO tbl_payvoucher VALUES("25","PAV271222102","","90000.00","2022-12-27","0","1","2022-12-27 04:14:07");
INSERT INTO tbl_payvoucher VALUES("26","PAV271222103","","5000.00","2022-12-27","0","1","2022-12-27 08:13:36");
INSERT INTO tbl_payvoucher VALUES("27","PAV281222101","","39000.00","2022-12-28","0","1","2022-12-28 04:17:08");
INSERT INTO tbl_payvoucher VALUES("29","PAV291222101","","52000.00","2022-12-29","0","1","2022-12-29 04:25:26");
INSERT INTO tbl_payvoucher VALUES("31","PAV291222102","","8500.00","2022-12-29","0","1","2022-12-29 07:31:14");
INSERT INTO tbl_payvoucher VALUES("37","PAV301222101","","15000.00","2022-12-22","0","1","2022-12-30 04:20:52");
INSERT INTO tbl_payvoucher VALUES("38","PAV301222102","","5700.00","2022-12-24","0","1","2022-12-30 04:21:19");
INSERT INTO tbl_payvoucher VALUES("41","PAV301222105","","50.00","2022-12-23","0","1","2022-12-30 08:23:12");
INSERT INTO tbl_payvoucher VALUES("44","PAV301222108","","50.00","2022-12-27","0","1","2022-12-30 08:25:08");
INSERT INTO tbl_payvoucher VALUES("46","PAV301222110","","50.00","2022-12-29","0","1","2022-12-30 08:27:12");
INSERT INTO tbl_payvoucher VALUES("49","PAV301222112","","1050.00","2022-12-24","0","1","2022-12-30 08:48:19");
INSERT INTO tbl_payvoucher VALUES("54","PAV301222113","","2000.00","2022-12-30","0","1","2022-12-30 09:57:03");
INSERT INTO tbl_payvoucher VALUES("55","PAV301222114","","50.00","2022-12-30","0","1","2022-12-30 09:58:28");
INSERT INTO tbl_payvoucher VALUES("57","PAV301222116","","50.00","2022-12-30","0","1","2022-12-30 10:08:38");
INSERT INTO tbl_payvoucher VALUES("58","PAV301222117","","11100.00","2022-12-30","0","1","2022-12-30 10:17:21");
INSERT INTO tbl_payvoucher VALUES("62","PAV311222104","","50.00","2022-12-25","0","1","2022-12-31 11:49:20");
INSERT INTO tbl_payvoucher VALUES("63","PAV311222105","","50.00","2022-12-22","0","1","2022-12-31 11:49:52");
INSERT INTO tbl_payvoucher VALUES("64","PAV311222106","","3050.00","2022-12-27","0","1","2022-12-31 11:51:19");
INSERT INTO tbl_payvoucher VALUES("65","PAV311222107","","50.00","2022-12-28","0","1","2022-12-31 11:51:53");
INSERT INTO tbl_payvoucher VALUES("66","PAV311222108","","50.00","2022-12-29","0","1","2022-12-31 11:52:20");
INSERT INTO tbl_payvoucher VALUES("69","PAV311222109","","1050.00","2022-12-28","0","1","2022-12-31 11:55:08");
INSERT INTO tbl_payvoucher VALUES("74","PAV311222113","","37500.00","2022-12-31","0","1","2022-12-31 11:50:56");
INSERT INTO tbl_payvoucher VALUES("75","PAV311222114","","4200.00","2022-12-31","0","1","2022-12-31 11:52:11");
INSERT INTO tbl_payvoucher VALUES("78","PAV020123101","","2772.00","2023-01-01","0","1","2023-01-02 01:04:00");
INSERT INTO tbl_payvoucher VALUES("79","PAV020123102","","50.00","2023-01-01","0","1","2023-01-02 01:05:34");
INSERT INTO tbl_payvoucher VALUES("80","PAV020123103","","50.00","2022-12-31","0","1","2023-01-02 01:47:28");
INSERT INTO tbl_payvoucher VALUES("81","PAV020123104","","50.00","2023-01-02","0","1","2023-01-02 10:33:40");
INSERT INTO tbl_payvoucher VALUES("83","PAV020123106","","11000.00","2023-01-02","0","1","2023-01-02 10:38:53");
INSERT INTO tbl_payvoucher VALUES("84","PAV020123107","","50.00","2023-01-02","0","1","2023-01-02 10:43:15");
INSERT INTO tbl_payvoucher VALUES("85","PAV020123108","","54500.00","2023-01-02","0","1","2023-01-02 10:44:27");
INSERT INTO tbl_payvoucher VALUES("87","PAV030123102","","3000.00","2022-12-08","0","1","2023-01-03 01:31:52");
INSERT INTO tbl_payvoucher VALUES("89","PAV030123104","","136100.00","2023-01-03","0","1","2023-01-03 08:11:03");
INSERT INTO tbl_payvoucher VALUES("91","PAV030123106","","500.00","2022-12-26","0","1","2023-01-03 09:32:47");
INSERT INTO tbl_payvoucher VALUES("92","PAV030123107","","19500.00","2023-01-03","0","1","2023-01-03 09:33:26");
INSERT INTO tbl_payvoucher VALUES("94","PAV040123101","","50.00","2023-01-04","0","1","2023-01-04 08:49:11");
INSERT INTO tbl_payvoucher VALUES("95","PAV040123102","","50.00","2023-01-03","0","1","2023-01-04 08:50:15");
INSERT INTO tbl_payvoucher VALUES("96","PAV040123103","","50.00","2023-01-04","0","1","2023-01-04 10:18:24");
INSERT INTO tbl_payvoucher VALUES("102","PAV050123106","","56300.00","2023-01-05","0","1","2023-01-05 10:50:46");
INSERT INTO tbl_payvoucher VALUES("103","PAV050123107","","50.00","2023-01-05","0","1","2023-01-05 10:53:27");
INSERT INTO tbl_payvoucher VALUES("104","PAV050123108","","12000.00","2023-01-05","0","1","2023-01-05 10:55:49");
INSERT INTO tbl_payvoucher VALUES("107","PAV060123101","","1000.00","2023-01-06","0","1","2023-01-06 04:45:16");
INSERT INTO tbl_payvoucher VALUES("110","PAV060123102","","50.00","2023-01-06","0","1","2023-01-06 08:20:22");
INSERT INTO tbl_payvoucher VALUES("111","PAV060123103","","50.00","2023-01-06","0","1","2023-01-06 08:21:18");
INSERT INTO tbl_payvoucher VALUES("112","PAV080123101","","63500.00","2023-01-08","0","1","2023-01-08 08:10:52");
INSERT INTO tbl_payvoucher VALUES("113","PAV080123102","","100.00","2023-01-08","0","1","2023-01-08 09:46:40");
INSERT INTO tbl_payvoucher VALUES("115","PAV090123101","","50.00","2023-01-09","0","1","2023-01-09 07:24:04");
INSERT INTO tbl_payvoucher VALUES("117","PAV090123102","","28500.00","2023-01-09","0","1","2023-01-09 08:58:21");
INSERT INTO tbl_payvoucher VALUES("120","PAV090123104","MASUM VAI ","1000.00","2023-01-09","0","1","2023-01-09 10:26:46");
INSERT INTO tbl_payvoucher VALUES("121","PAV090123105","JUST FOR CASH CONFIRMATION","850.00","2022-12-08","0","1","2023-01-09 10:29:58");
INSERT INTO tbl_payvoucher VALUES("123","PAV100123101","","50.00","2023-01-09","0","1","2023-01-10 11:24:47");
INSERT INTO tbl_payvoucher VALUES("125","PAV100123103","","2600.00","2023-01-10","0","1","2023-01-10 07:00:27");
INSERT INTO tbl_payvoucher VALUES("126","PAV100123104","","50.00","2023-01-10","0","1","2023-01-10 07:45:20");
INSERT INTO tbl_payvoucher VALUES("127","PAV100123105","","6000.00","2023-01-10","0","1","2023-01-10 09:19:18");
INSERT INTO tbl_payvoucher VALUES("128","PAV100123106","","50.00","2023-01-10","0","1","2023-01-10 10:21:28");
INSERT INTO tbl_payvoucher VALUES("129","PAV100123107","","5000.00","2023-01-10","0","1","2023-01-10 10:38:56");
INSERT INTO tbl_payvoucher VALUES("131","PAV110123102","","50.00","2023-01-11","0","1","2023-01-11 09:46:50");
INSERT INTO tbl_payvoucher VALUES("133","PAV120123101","","50000.00","2023-01-12","0","1","2023-01-12 09:03:17");
INSERT INTO tbl_payvoucher VALUES("134","PAV120123102","","72500.00","2023-01-12","0","1","2023-01-12 09:50:20");
INSERT INTO tbl_payvoucher VALUES("135","PAV120123103","","50.00","2023-01-12","0","1","2023-01-12 10:35:00");
INSERT INTO tbl_payvoucher VALUES("136","PAV130123101","","2000.00","2023-01-13","0","1","2023-01-13 06:00:40");
INSERT INTO tbl_payvoucher VALUES("137","PAV130123102","","50.00","2023-01-13","0","1","2023-01-13 07:43:23");
INSERT INTO tbl_payvoucher VALUES("138","PAV130123103","","50.00","2023-01-13","0","1","2023-01-13 08:57:01");
INSERT INTO tbl_payvoucher VALUES("139","PAV140123101","","2000.00","2022-12-14","0","1","2023-01-14 07:08:20");
INSERT INTO tbl_payvoucher VALUES("141","PAV140123103","","50.00","2023-01-14","0","1","2023-01-14 10:39:25");
INSERT INTO tbl_payvoucher VALUES("142","PAV150123101","","224000.00","2023-01-15","0","1","2023-01-15 05:09:51");
INSERT INTO tbl_payvoucher VALUES("143","PAV150123102","","50.00","2023-01-15","0","1","2023-01-15 10:22:23");
INSERT INTO tbl_payvoucher VALUES("144","PAV150123103","","50.00","2023-01-15","0","1","2023-01-15 10:22:48");
INSERT INTO tbl_payvoucher VALUES("145","PAV160123101","","20000.00","2023-01-16","0","1","2023-01-16 12:18:37");
INSERT INTO tbl_payvoucher VALUES("148","PAV160123102","","2050.00","2023-01-05","0","1","2023-01-16 12:42:23");
INSERT INTO tbl_payvoucher VALUES("150","PAV160123103","","150.00","2022-12-15","0","1","2023-01-16 01:13:45");
INSERT INTO tbl_payvoucher VALUES("154","PAV160123105","","1050.00","2023-01-11","0","1","2023-01-16 01:17:07");
INSERT INTO tbl_payvoucher VALUES("155","PAV160123106","","3000.00","2023-01-16","0","1","2023-01-16 01:18:01");
INSERT INTO tbl_payvoucher VALUES("156","PAV160123107","FULL SALARY PAYMENTS","2020.00","2023-01-05","0","1","2023-01-16 04:37:56");
INSERT INTO tbl_payvoucher VALUES("157","PAV160123108","JUST FOR ACCOUNTS CONFIRMATIONS","1500.00","2022-12-06","0","1","2023-01-16 04:50:04");
INSERT INTO tbl_payvoucher VALUES("158","PAV160123109","","50.00","2023-01-16","0","1","2023-01-16 07:05:20");
INSERT INTO tbl_payvoucher VALUES("159","PAV160123110","","50.00","2023-01-16","0","1","2023-01-16 10:06:22");
INSERT INTO tbl_payvoucher VALUES("160","PAV170123101","","29000.00","2023-01-17","0","1","2023-01-17 11:51:55");
INSERT INTO tbl_payvoucher VALUES("163","PAV180123101","","50.00","2023-01-17","0","1","2023-01-18 12:57:42");
INSERT INTO tbl_payvoucher VALUES("165","PAV180123102","","50.00","2023-01-17","0","1","2023-01-18 12:59:08");
INSERT INTO tbl_payvoucher VALUES("171","PAV180123104","","70000.00","2023-01-17","0","1","2023-01-18 05:11:22");
INSERT INTO tbl_payvoucher VALUES("172","PAV180123105","","330000.00","2023-01-17","0","1","2023-01-18 05:13:32");
INSERT INTO tbl_payvoucher VALUES("173","PAV180123106","","50.00","2023-01-18","0","1","2023-01-18 10:32:54");
INSERT INTO tbl_payvoucher VALUES("174","PAV180123107","","50.00","2023-01-18","0","1","2023-01-18 10:33:10");
INSERT INTO tbl_payvoucher VALUES("175","PAV190123101","","50.00","2023-01-19","0","1","2023-01-19 09:30:15");
INSERT INTO tbl_payvoucher VALUES("176","PAV190123102","","9500.00","2023-01-19","0","1","2023-01-19 09:47:02");
INSERT INTO tbl_payvoucher VALUES("178","PAV190123103","","8000.00","2023-01-19","0","1","2023-01-19 10:08:42");
INSERT INTO tbl_payvoucher VALUES("180","PAV190123104","","15500.00","2023-01-19","0","1","2023-01-19 10:10:34");
INSERT INTO tbl_payvoucher VALUES("185","PAV190123109","","850.00","2023-01-01","0","1","2023-01-19 10:18:04");
INSERT INTO tbl_payvoucher VALUES("186","PAV190123110","","3549.00","2023-01-01","0","1","2023-01-19 10:22:49");
INSERT INTO tbl_payvoucher VALUES("188","PAV190123112","","13890.00","2023-01-01","0","1","2023-01-19 10:27:07");
INSERT INTO tbl_payvoucher VALUES("189","PAV190123113","","50.00","2023-01-19","0","1","2023-01-19 10:36:37");
INSERT INTO tbl_payvoucher VALUES("191","PAV190123115","","10800.00","2023-01-19","0","1","2023-01-19 10:50:45");
INSERT INTO tbl_payvoucher VALUES("200","PAV200123104","","50.00","2023-01-20","0","1","2023-01-20 12:45:03");
INSERT INTO tbl_payvoucher VALUES("204","PAV200123107","","8300.00","2023-01-19","0","1","2023-01-20 06:23:21");
INSERT INTO tbl_payvoucher VALUES("208","PAV200123110","","10350.00","2023-01-20","0","1","2023-01-20 08:04:54");
INSERT INTO tbl_payvoucher VALUES("210","PAV200123112","","50.00","2023-01-20","0","1","2023-01-20 10:38:44");
INSERT INTO tbl_payvoucher VALUES("217","PAV210123103","","50.00","2023-01-21","0","1","2023-01-21 11:05:33");
INSERT INTO tbl_payvoucher VALUES("218","PAV220123101","","60000.00","2023-01-22","0","1","2023-01-22 12:00:07");
INSERT INTO tbl_payvoucher VALUES("219","PAV220123102","","7025.00","2023-01-01","0","1","2023-01-22 12:06:47");
INSERT INTO tbl_payvoucher VALUES("224","PAV220123104","","38907.81","2023-01-01","0","1","2023-01-22 01:19:25");
INSERT INTO tbl_payvoucher VALUES("225","PAV220123105","","19000.00","2023-01-01","0","1","2023-01-22 01:30:46");
INSERT INTO tbl_payvoucher VALUES("226","PAV220123106","","691960.00","2023-01-01","0","1","2023-01-22 01:32:38");
INSERT INTO tbl_payvoucher VALUES("227","PAV220123107","","114431.21","2023-01-01","0","1","2023-01-22 01:35:12");
INSERT INTO tbl_payvoucher VALUES("228","PAV220123108","","1443.00","2023-01-01","0","1","2023-01-22 01:38:35");
INSERT INTO tbl_payvoucher VALUES("229","PAV220123109","","50.00","2023-01-22","0","1","2023-01-22 07:38:25");
INSERT INTO tbl_payvoucher VALUES("230","PAV220123110","","12500.00","2023-01-22","0","1","2023-01-22 10:09:46");
INSERT INTO tbl_payvoucher VALUES("231","PAV220123111","","5200.00","2023-01-01","0","1","2023-01-22 10:12:35");
INSERT INTO tbl_payvoucher VALUES("232","PAV220123112","","50.00","2023-01-22","0","1","2023-01-22 10:17:36");
INSERT INTO tbl_payvoucher VALUES("234","PAV230123102","","144300.00","2023-01-01","0","1","2023-01-23 06:26:18");
INSERT INTO tbl_payvoucher VALUES("236","PAV230123104","","50.00","2023-01-23","0","1","2023-01-23 06:45:04");
INSERT INTO tbl_payvoucher VALUES("237","PAV230123105","","1000.00","2023-01-23","0","1","2023-01-23 08:36:20");
INSERT INTO tbl_payvoucher VALUES("238","PAV230123106","","90000.00","2023-01-22","0","1","2023-01-23 10:25:22");
INSERT INTO tbl_payvoucher VALUES("239","PAV230123107","","12000.00","2023-01-23","0","1","2023-01-23 10:26:24");
INSERT INTO tbl_payvoucher VALUES("241","PAV240123101","","50.00","2023-01-23","0","1","2023-01-24 05:40:00");
INSERT INTO tbl_payvoucher VALUES("242","PAV240123102","","50.00","2023-01-24","0","1","2023-01-24 05:40:29");
INSERT INTO tbl_payvoucher VALUES("243","PAV240123103","","300.00","2023-01-24","0","1","2023-01-24 07:31:12");
INSERT INTO tbl_payvoucher VALUES("244","PAV240123104","","50.00","2023-01-24","0","1","2023-01-24 07:39:35");
INSERT INTO tbl_payvoucher VALUES("245","PAV240123105","AMINUR PAYMENTS","9000.00","2023-01-24","0","1","2023-01-24 08:36:16");
INSERT INTO tbl_payvoucher VALUES("246","PAV250123101","","10000.00","2023-01-25","0","1","2023-01-25 05:30:14");
INSERT INTO tbl_payvoucher VALUES("247","PAV250123102","","36150.00","2023-01-25","0","1","2023-01-25 05:52:10");
INSERT INTO tbl_payvoucher VALUES("249","PAV250123103","","100.00","2023-01-25","0","1","2023-01-25 08:42:06");
INSERT INTO tbl_payvoucher VALUES("250","PAV250123104","","50.00","2023-01-25","0","1","2023-01-25 09:10:13");
INSERT INTO tbl_payvoucher VALUES("251","PAV250123105","","50.00","2023-01-25","0","1","2023-01-25 09:29:23");
INSERT INTO tbl_payvoucher VALUES("257","PAV250123108","","3900.00","2023-01-25","0","1","2023-01-25 10:44:39");
INSERT INTO tbl_payvoucher VALUES("260","PAV260123101","","2027272.00","2023-01-01","0","1","2023-01-26 12:51:32");
INSERT INTO tbl_payvoucher VALUES("261","PAV260123102","","10000.00","2023-01-01","0","1","2023-01-26 12:52:08");
INSERT INTO tbl_payvoucher VALUES("262","PAV260123103","","10000.00","2023-01-01","0","1","2023-01-26 12:52:50");
INSERT INTO tbl_payvoucher VALUES("263","PAV260123104","","1456.00","2023-01-01","0","1","2023-01-26 01:01:43");
INSERT INTO tbl_payvoucher VALUES("264","PAV260123105","","1500.00","2023-01-25","0","1","2023-01-26 01:01:59");
INSERT INTO tbl_payvoucher VALUES("265","PAV260123106","","50.00","2023-01-26","0","1","2023-01-26 06:48:36");
INSERT INTO tbl_payvoucher VALUES("266","PAV260123107","","100.00","2023-01-26","0","1","2023-01-26 07:49:22");
INSERT INTO tbl_payvoucher VALUES("267","PAV260123108","","2400.00","2023-01-01","0","1","2023-01-26 08:16:09");
INSERT INTO tbl_payvoucher VALUES("269","PAV260123109","","50.00","2023-01-26","0","1","2023-01-26 09:48:18");
INSERT INTO tbl_payvoucher VALUES("270","PAV270123101","","4770.00","2023-01-27","0","1","2023-01-27 05:12:34");
INSERT INTO tbl_payvoucher VALUES("271","PAV270123102","","18000.00","2023-01-27","0","1","2023-01-27 08:11:59");
INSERT INTO tbl_payvoucher VALUES("272","PAV270123103","","50.00","2023-01-27","0","1","2023-01-27 08:16:46");
INSERT INTO tbl_payvoucher VALUES("273","PAV270123104","","50.00","2023-01-27","0","1","2023-01-27 10:18:48");
INSERT INTO tbl_payvoucher VALUES("274","PAV280123101","","500.00","2023-01-28","0","1","2023-01-28 06:27:40");
INSERT INTO tbl_payvoucher VALUES("275","PAV280123102","","50.00","2023-01-28","0","1","2023-01-28 09:48:34");
INSERT INTO tbl_payvoucher VALUES("276","PAV290123101","","50.00","2023-01-29","0","1","2023-01-29 06:20:14");
INSERT INTO tbl_payvoucher VALUES("277","PAV290123102","","5000.00","2023-01-29","0","1","2023-01-29 09:14:32");
INSERT INTO tbl_payvoucher VALUES("278","PAV290123103","","50.00","2023-01-29","0","1","2023-01-29 09:17:56");
INSERT INTO tbl_payvoucher VALUES("280","PAV300123102","","19000.00","2023-01-29","0","1","2023-01-30 02:44:07");
INSERT INTO tbl_payvoucher VALUES("282","PAV300123103","","120000.00","2023-01-29","0","1","2023-01-30 03:00:35");
INSERT INTO tbl_payvoucher VALUES("283","PAV300123104","","100000.00","2023-01-30","0","1","2023-01-30 03:13:32");
INSERT INTO tbl_payvoucher VALUES("284","PAV300123105","","50.00","2023-01-30","0","1","2023-01-30 08:59:18");
INSERT INTO tbl_payvoucher VALUES("286","PAV300123107","","500.00","2023-01-30","0","1","2023-01-30 09:48:53");
INSERT INTO tbl_payvoucher VALUES("287","PAV300123108","","550.00","2023-01-30","0","1","2023-01-30 10:01:26");
INSERT INTO tbl_payvoucher VALUES("288","PAV310123101","","20000.00","2023-01-30","0","1","2023-01-31 12:29:54");
INSERT INTO tbl_payvoucher VALUES("289","PAV310123102","","50.00","2023-01-31","0","1","2023-01-31 06:56:35");
INSERT INTO tbl_payvoucher VALUES("290","PAV310123103","","50.00","2023-01-31","0","1","2023-01-31 10:38:09");
INSERT INTO tbl_payvoucher VALUES("291","PAV010223101","","50.00","2023-02-01","0","1","2023-02-01 11:52:46");
INSERT INTO tbl_payvoucher VALUES("292","PAV010223102","","5373.00","2023-02-01","0","1","2023-02-01 10:39:27");
INSERT INTO tbl_payvoucher VALUES("294","PAV020223101","","86.00","2023-01-30","0","1","2023-02-02 12:30:43");
INSERT INTO tbl_payvoucher VALUES("295","PAV020223102","","7500.00","2023-01-30","0","1","2023-02-02 12:32:59");
INSERT INTO tbl_payvoucher VALUES("296","PAV020223103","","12891.00","2023-02-02","0","1","2023-02-02 07:01:23");
INSERT INTO tbl_payvoucher VALUES("297","PAV020223104","","709.00","2023-02-02","0","1","2023-02-02 07:01:53");
INSERT INTO tbl_payvoucher VALUES("298","PAV020223105","","10500.00","2023-02-02","0","1","2023-02-02 07:17:03");
INSERT INTO tbl_payvoucher VALUES("299","PAV020223106","","5000.00","2023-02-02","0","1","2023-02-02 10:53:23");
INSERT INTO tbl_payvoucher VALUES("300","PAV030223101","","10.00","2023-01-29","0","1","2023-02-03 12:54:44");
INSERT INTO tbl_payvoucher VALUES("301","PAV030223102","","12.00","2023-02-02","0","1","2023-02-03 01:18:48");
INSERT INTO tbl_payvoucher VALUES("302","PAV030223103","","130000.00","2023-02-03","0","1","2023-02-03 07:41:16");
INSERT INTO tbl_payvoucher VALUES("303","PAV030223104","","200.00","2023-02-03","0","1","2023-02-03 07:49:55");
INSERT INTO tbl_payvoucher VALUES("304","PAV030223105","","8800.00","2023-02-03","0","1","2023-02-03 08:08:59");
INSERT INTO tbl_payvoucher VALUES("305","PAV030223106","","280.00","2023-01-21","0","1","2023-02-03 09:28:05");
INSERT INTO tbl_payvoucher VALUES("308","PAV040223102","","1000.00","2022-12-30","0","1","2023-02-04 06:53:58");
INSERT INTO tbl_payvoucher VALUES("309","PAV040223103","","200.00","2023-02-04","0","1","2023-02-04 07:29:25");
INSERT INTO tbl_payvoucher VALUES("310","PAV050223101","","50000.00","2023-02-05","0","1","2023-02-05 05:00:08");
INSERT INTO tbl_payvoucher VALUES("311","PAV050223102","","51000.00","2023-02-05","0","1","2023-02-05 05:00:59");
INSERT INTO tbl_payvoucher VALUES("312","PAV050223103","","7000.00","2023-02-05","0","1","2023-02-05 05:01:53");
INSERT INTO tbl_payvoucher VALUES("316","PAV050223104","","573040.00","2023-01-01","0","1","2023-02-05 05:42:16");
INSERT INTO tbl_payvoucher VALUES("317","PAV050223105","","626960.00","2023-01-01","0","1","2023-02-05 05:43:45");
INSERT INTO tbl_payvoucher VALUES("318","PAV050223106","","50.00","2023-02-04","0","1","2023-02-05 09:07:46");
INSERT INTO tbl_payvoucher VALUES("319","PAV060223101","","12600.00","2023-02-06","0","1","2023-02-06 06:02:10");
INSERT INTO tbl_payvoucher VALUES("320","PAV060223102","","6900.00","2023-02-06","0","1","2023-02-06 06:32:59");
INSERT INTO tbl_payvoucher VALUES("322","PAV060223103","","5470.00","2023-02-06","0","1","2023-02-06 08:13:20");
INSERT INTO tbl_payvoucher VALUES("323","PAV060223104","","3000.00","2023-02-06","0","1","2023-02-06 08:13:54");
INSERT INTO tbl_payvoucher VALUES("324","PAV070223101","","3000.00","2023-02-07","0","1","2023-02-07 07:33:12");
INSERT INTO tbl_payvoucher VALUES("325","PAV070223102","","500.00","2023-02-07","0","1","2023-02-07 09:12:37");
INSERT INTO tbl_payvoucher VALUES("326","PAV070223103","","600.00","2023-02-07","0","1","2023-02-07 09:44:11");
INSERT INTO tbl_payvoucher VALUES("327","PAV070223104","","54822.00","2023-02-06","0","1","2023-02-07 10:08:57");
INSERT INTO tbl_payvoucher VALUES("328","PAV080223101","","50.00","2023-02-08","0","1","2023-02-08 06:48:27");
INSERT INTO tbl_payvoucher VALUES("329","PAV080223102","","100000.00","2023-02-08","0","1","2023-02-08 10:57:54");
INSERT INTO tbl_payvoucher VALUES("330","PAV090223101","","1000.00","2023-02-09","0","1","2023-02-09 02:42:32");
INSERT INTO tbl_payvoucher VALUES("331","PAV090223102","","8600.00","2023-02-09","0","1","2023-02-09 11:02:40");
INSERT INTO tbl_payvoucher VALUES("332","PAV090223103","","5000.00","2023-02-09","0","1","2023-02-09 11:13:22");
INSERT INTO tbl_payvoucher VALUES("333","PAV100223101","VGA-CABLE 3M RETERN SEL030223105","230.00","2023-02-10","0","1","2023-02-10 11:41:53");
INSERT INTO tbl_payvoucher VALUES("335","PAV100223102","","2275.00","2023-02-06","0","1","2023-02-10 04:52:33");
INSERT INTO tbl_payvoucher VALUES("336","PAV100223103","","40000.00","2023-02-10","0","1","2023-02-10 09:31:46");
INSERT INTO tbl_payvoucher VALUES("337","PAV110223101","","700.00","2023-02-11","0","1","2023-02-11 07:34:56");
INSERT INTO tbl_payvoucher VALUES("338","PAV120223101","","15000.00","2023-02-12","0","1","2023-02-12 10:31:28");
INSERT INTO tbl_payvoucher VALUES("339","PAV120223102","","3500.00","2023-02-12","0","1","2023-02-12 10:38:47");
INSERT INTO tbl_payvoucher VALUES("340","PAV120223103","","8700.00","2023-02-12","0","1","2023-02-12 10:39:49");
INSERT INTO tbl_payvoucher VALUES("341","PAV120223104","","3300.00","2023-02-12","0","1","2023-02-12 10:40:05");
INSERT INTO tbl_payvoucher VALUES("342","PAV140223101","","7000.00","2023-02-13","0","1","2023-02-14 04:44:30");
INSERT INTO tbl_payvoucher VALUES("343","PAV170223101","","7000.00","2023-02-17","0","1","2023-02-17 11:05:46");
INSERT INTO tbl_payvoucher VALUES("344","PAV190223101","MEHEDI","10000.00","2023-02-19","0","1","2023-02-19 09:40:36");
INSERT INTO tbl_payvoucher VALUES("345","PAV200223101","","400.00","2023-02-20","0","1","2023-02-20 03:52:15");
INSERT INTO tbl_payvoucher VALUES("346","PAV200223102","","400.00","2023-02-20","0","1","2023-02-20 07:09:48");
INSERT INTO tbl_payvoucher VALUES("347","PAV200223103","","589.00","2023-02-20","0","1","2023-02-20 09:55:20");
INSERT INTO tbl_payvoucher VALUES("348","PAV260223101","","1500.00","2023-02-26","0","1","2023-02-26 11:54:54");
INSERT INTO tbl_payvoucher VALUES("349","PAV100323101","","640.00","2023-03-10","0","1","2023-03-10 09:15:28");
INSERT INTO tbl_payvoucher VALUES("350","PAV100323102","","16628.00","2023-03-10","0","1","2023-03-10 09:18:44");
INSERT INTO tbl_payvoucher VALUES("351","PAV120323101","","300.00","2023-03-12","0","1","2023-03-12 11:56:23");
INSERT INTO tbl_payvoucher VALUES("352","PAV180323101","","20594.50","2023-03-18","0","1","2023-03-18 09:11:49");
INSERT INTO tbl_payvoucher VALUES("353","PAV290323101","","10150.00","2023-03-29","0","1","2023-03-29 02:15:29");
INSERT INTO tbl_payvoucher VALUES("354","PAV300323101","","167210.00","2023-03-30","0","1","2023-03-30 05:59:33");
INSERT INTO tbl_payvoucher VALUES("355","PAV090423101","","6275.00","2023-04-09","0","1","2023-04-09 04:51:09");
INSERT INTO tbl_payvoucher VALUES("356","PAV090423102","","37050.00","2023-04-09","0","1","2023-04-09 05:22:22");
INSERT INTO tbl_payvoucher VALUES("357","PAV110423101","","590.00","2023-04-11","0","1","2023-04-11 09:42:15");
INSERT INTO tbl_payvoucher VALUES("358","PAV300423101","","8000.00","2023-04-14","0","1","2023-04-30 02:32:23");
INSERT INTO tbl_payvoucher VALUES("359","PAV030523101","","3440.96","2023-05-03","0","1","2023-05-03 06:46:04");
INSERT INTO tbl_payvoucher VALUES("360","PAV030523102","","242623.00","2023-05-03","0","1","2023-05-03 06:47:00");
INSERT INTO tbl_payvoucher VALUES("361","PAV080523101","","139519.00","2023-05-08","0","1","2023-05-08 08:07:40");
INSERT INTO tbl_payvoucher VALUES("362","PAV080523102","","290.00","2023-05-08","0","1","2023-05-08 08:59:52");
INSERT INTO tbl_payvoucher VALUES("363","PAV080523103","","24300.00","2023-05-08","0","1","2023-05-08 09:03:10");
INSERT INTO tbl_payvoucher VALUES("364","PAV190523101","","102500.00","2023-05-19","0","1","2023-05-19 06:50:16");
INSERT INTO tbl_payvoucher VALUES("365","PAV190523102","","25420.00","2023-05-19","0","1","2023-05-19 06:52:18");
INSERT INTO tbl_payvoucher VALUES("366","PAV190523103","","2000.00","2023-05-19","0","1","2023-05-19 07:30:01");
INSERT INTO tbl_payvoucher VALUES("367","PAV190523104","","2614.00","2023-05-05","0","1","2023-05-19 07:33:03");
INSERT INTO tbl_payvoucher VALUES("368","PAV260523101","","2000.00","2023-05-26","0","1","2023-05-26 08:46:30");
INSERT INTO tbl_payvoucher VALUES("369","PAV310523101","","10000.00","2023-05-31","0","1","2023-05-31 10:03:54");
INSERT INTO tbl_payvoucher VALUES("370","PAV020623101","","79450.00","2023-06-02","0","1","2023-06-02 06:37:18");
INSERT INTO tbl_payvoucher VALUES("371","PAV020623102","","68000.00","2023-05-08","0","1","2023-06-02 08:58:59");
INSERT INTO tbl_payvoucher VALUES("372","PAV020623103","","30000.00","2023-06-01","0","1","2023-06-02 08:59:29");
INSERT INTO tbl_payvoucher VALUES("373","PAV140623101","","21450.00","2023-06-14","0","1","2023-06-14 03:01:09");
INSERT INTO tbl_payvoucher VALUES("374","PAV050723101","","140000.00","2023-06-05","0","1","2023-07-05 10:57:11");
INSERT INTO tbl_payvoucher VALUES("375","PAV050723102","","41405.00","2023-07-05","0","1","2023-07-05 05:47:03");
INSERT INTO tbl_payvoucher VALUES("376","PAV080723101","","2600.00","2023-07-08","0","1","2023-07-08 08:54:07");
INSERT INTO tbl_payvoucher VALUES("377","PAV200723101","","2000.00","2023-06-02","0","1","2023-07-20 04:35:07");
INSERT INTO tbl_payvoucher VALUES("378","PAV200723102","","1000.00","2023-06-16","0","1","2023-07-20 04:35:42");
INSERT INTO tbl_payvoucher VALUES("379","PAV200723103","","2000.00","2023-07-07","0","1","2023-07-20 04:36:15");
INSERT INTO tbl_payvoucher VALUES("380","PAV200723104","","2000.00","2023-07-14","0","1","2023-07-20 04:37:15");
INSERT INTO tbl_payvoucher VALUES("381","PAV210723101","","521800.00","2023-07-21","0","1","2023-07-21 08:21:51");
INSERT INTO tbl_payvoucher VALUES("382","PAV210723102","","3000.00","2023-07-21","0","1","2023-07-21 09:49:04");
INSERT INTO tbl_payvoucher VALUES("383","PAV230723101","","226000.00","2023-07-23","0","1","2023-07-23 05:44:49");
INSERT INTO tbl_payvoucher VALUES("384","PAV240723101","","2200.00","2023-07-24","0","1","2023-07-24 09:29:56");
INSERT INTO tbl_payvoucher VALUES("385","PAV140823101","","10000.00","2023-08-11","0","1","2023-08-14 10:53:48");
INSERT INTO tbl_payvoucher VALUES("386","PAV140823102","","4000.00","2023-08-03","0","1","2023-08-14 10:54:28");
INSERT INTO tbl_payvoucher VALUES("387","PAV050923101","","16996.85","2023-09-05","0","1","2023-09-05 11:22:29");
INSERT INTO tbl_payvoucher VALUES("388","PAV081023101","","5000.00","2023-08-12","0","1","2023-10-08 04:40:30");
INSERT INTO tbl_payvoucher VALUES("389","PAV081023102","","10000.00","2023-08-19","0","1","2023-10-08 04:41:38");
INSERT INTO tbl_payvoucher VALUES("390","PAV081023103","","6000.00","2023-08-20","0","1","2023-10-08 04:42:44");
INSERT INTO tbl_payvoucher VALUES("391","PAV081023104","","10000.00","2023-10-08","0","1","2023-10-08 04:43:26");
INSERT INTO tbl_payvoucher VALUES("392","PAV081023105","","8500.00","2023-08-29","0","1","2023-10-08 04:44:21");
INSERT INTO tbl_payvoucher VALUES("393","PAV081023106","","5000.00","2023-08-31","0","1","2023-10-08 04:44:57");
INSERT INTO tbl_payvoucher VALUES("394","PAV081023107","","9900.00","2023-09-01","0","1","2023-10-08 04:46:48");
INSERT INTO tbl_payvoucher VALUES("395","PAV071123101","","533600.00","2023-11-07","0","1","2023-11-07 09:29:41");
INSERT INTO tbl_payvoucher VALUES("396","PAV071123102","","2000.00","2023-11-07","0","1","2023-11-07 09:32:07");
INSERT INTO tbl_payvoucher VALUES("397","PAV071123103","","60000.00","2023-11-07","0","1","2023-11-07 09:39:16");
INSERT INTO tbl_payvoucher VALUES("398","PAV071123104","","171360.00","2023-11-07","0","1","2023-11-07 09:42:36");
INSERT INTO tbl_payvoucher VALUES("399","PAV071123105","","315094.00","2023-11-07","0","1","2023-11-07 09:46:26");
INSERT INTO tbl_payvoucher VALUES("400","PAV071123106","","7608.00","2023-11-07","0","1","2023-11-07 09:50:33");
INSERT INTO tbl_payvoucher VALUES("401","PAV071123107","","450000.00","2023-11-07","0","1","2023-11-07 09:55:43");
INSERT INTO tbl_payvoucher VALUES("402","PAV071123108","","225322.00","2023-11-07","0","1","2023-11-07 09:57:28");
INSERT INTO tbl_payvoucher VALUES("403","PAV071123109","","950.00","2023-11-07","0","1","2023-11-07 09:59:36");
INSERT INTO tbl_payvoucher VALUES("404","PAV071123110","","73920.00","2023-11-07","0","1","2023-11-07 10:02:27");
INSERT INTO tbl_payvoucher VALUES("405","PAV081123101","","41928.50","2023-11-08","0","1","2023-11-08 11:43:32");
INSERT INTO tbl_payvoucher VALUES("406","PAV081123102","","21943.24","2023-11-08","0","1","2023-11-08 11:44:36");
INSERT INTO tbl_payvoucher VALUES("407","PAV081123103","","44000.00","2023-11-08","0","1","2023-11-08 02:03:41");
INSERT INTO tbl_payvoucher VALUES("408","PAV081123104","","29510.00","2023-11-08","0","1","2023-11-08 02:04:41");
INSERT INTO tbl_payvoucher VALUES("409","PAV081123105","","11502.40","2023-11-08","0","1","2023-11-08 03:30:02");
INSERT INTO tbl_payvoucher VALUES("410","PAV201123101","","11600.00","2023-11-20","0","1","2023-11-20 05:13:38");
INSERT INTO tbl_payvoucher VALUES("411","PAV221123101","","287222.74","2023-11-22","0","1","2023-11-22 06:21:05");
INSERT INTO tbl_payvoucher VALUES("412","PAV261123101","","10000.00","2023-10-07","0","1","2023-11-26 06:02:08");
INSERT INTO tbl_payvoucher VALUES("413","PAV261123102","","5000.00","2023-11-26","0","1","2023-11-26 06:03:15");
INSERT INTO tbl_payvoucher VALUES("414","PAV261123103","","20000.00","2023-10-23","0","1","2023-11-26 06:06:30");
INSERT INTO tbl_payvoucher VALUES("415","PAV261123104","","15600.00","2023-10-27","0","1","2023-11-26 06:07:39");
INSERT INTO tbl_payvoucher VALUES("416","PAV301123101","","100724.25","2023-11-30","0","1","2023-11-30 08:15:00");
INSERT INTO tbl_payvoucher VALUES("417","PAV220124101","","54705.00","2024-01-22","0","1","2024-01-22 05:31:34");
INSERT INTO tbl_payvoucher VALUES("418","PAV290124101","","22950.50","2024-01-29","0","1","2024-01-29 07:34:14");
INSERT INTO tbl_payvoucher VALUES("419","PAV300124101","","190763.24","2024-01-30","0","1","2024-01-30 10:24:35");
INSERT INTO tbl_payvoucher VALUES("420","PAV310124101","","1225620.77","2024-01-31","0","1","2024-01-31 12:06:25");
INSERT INTO tbl_payvoucher VALUES("421","PAV310124102","","274634.48","2024-01-31","0","1","2024-01-31 12:09:13");
INSERT INTO tbl_payvoucher VALUES("422","PAV230224101","","6355.00","2024-02-23","0","1","2024-02-23 09:19:27");
INSERT INTO tbl_payvoucher VALUES("423","PAV290224101","","72575.00","2024-02-29","0","1","2024-02-29 04:04:12");
INSERT INTO tbl_payvoucher VALUES("424","PAV190324101","","32100.00","2024-03-19","0","1","2024-03-19 03:02:00");
INSERT INTO tbl_payvoucher VALUES("425","PAV090624101","","139152.00","2024-06-09","0","1","2024-06-09 01:04:02");
INSERT INTO tbl_payvoucher VALUES("426","PAV120724101","","16800.00","2024-07-12","0","1","2024-07-12 07:02:13");



CREATE TABLE `tbl_payvoucherde` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `seid` int(11) NOT NULL,
  `cid` int(11) NOT NULL,
  `cty` varchar(2) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `did` int(11) NOT NULL,
  `dty` varchar(2) NOT NULL,
  `cheno` varchar(20) DEFAULT NULL,
  `chedt` date DEFAULT NULL,
  `chest` int(11) DEFAULT NULL,
  `ref` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=433 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_payvoucherde VALUES("2","0","2","2","LE","10000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("8","0","8","2","LE","10000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("9","0","9","2","LE","50.00","1","EM","","","0","FOR DAILY COST");
INSERT INTO tbl_payvoucherde VALUES("13","0","13","1","BA","110000.00","13","SU","ONLINE","2022-12-22","0","");
INSERT INTO tbl_payvoucherde VALUES("14","0","14","2","LE","5000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("17","0","17","2","LE","5000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("19","0","19","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("24","0","24","1","BA","5650.00","13","SU","ONLINE","2022-12-27","0","");
INSERT INTO tbl_payvoucherde VALUES("25","0","25","1","BA","90000.00","8","SU","ONLINE","2022-12-27","0","");
INSERT INTO tbl_payvoucherde VALUES("26","0","26","2","LE","5000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("27","0","27","2","LE","39000.00","5","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("29","0","29","1","BA","52000.00","5","LE","ONLINE","2022-12-29","0","");
INSERT INTO tbl_payvoucherde VALUES("31","0","31","2","LE","8500.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("37","0","37","1","MO","15000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("38","0","38","1","MO","5700.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("41","0","41","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("44","0","44","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("46","0","46","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("49","0","49","2","LE","1050.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("54","0","54","2","LE","2000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("55","0","55","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("57","0","57","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("58","0","58","1","MO","11100.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("62","0","62","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("63","0","63","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("64","0","64","2","LE","3050.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("65","0","65","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("66","0","66","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("69","0","69","2","LE","1050.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("74","0","74","2","LE","37500.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("75","0","75","1","MO","4200.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("78","0","78","2","LE","2772.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("79","0","79","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("80","0","80","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("81","0","81","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("83","0","83","1","MO","11000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("84","0","84","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("85","0","85","1","BA","54500.00","5","LE","ONLINE","2023-01-02","0","");
INSERT INTO tbl_payvoucherde VALUES("87","0","87","2","LE","3000.00","3","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("89","0","89","1","BA","136100.00","13","SU","ONLINE","2023-01-03","0","");
INSERT INTO tbl_payvoucherde VALUES("91","0","91","2","LE","500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("92","0","92","2","LE","19500.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("94","0","94","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("95","0","95","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("96","0","96","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("102","0","102","1","BA","56300.00","5","LE","ONLINE","2023-01-05","0","");
INSERT INTO tbl_payvoucherde VALUES("103","0","103","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("104","0","104","2","LE","12000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("107","0","107","2","LE","1000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("110","0","110","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("111","0","111","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("112","0","112","1","BA","63500.00","5","LE","ONLINE","2023-01-08","0","");
INSERT INTO tbl_payvoucherde VALUES("113","0","113","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("114","0","113","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("116","0","115","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("118","0","117","2","LE","28500.00","5","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("121","0","120","2","LE","1000.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("122","0","121","2","LE","850.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("124","0","123","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("126","0","125","1","MO","2600.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("127","0","126","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("128","0","127","2","LE","6000.00","5","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("129","0","128","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("130","0","129","2","LE","5000.00","3","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("132","0","131","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("134","0","133","2","LE","50000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("135","0","134","2","LE","72500.00","5","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("136","0","135","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("137","0","136","2","LE","2000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("138","0","137","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("139","0","138","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("140","0","139","2","LE","2000.00","3","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("142","0","141","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("143","0","142","1","BA","224000.00","5","LE","ONLINE","2023-01-15","0","");
INSERT INTO tbl_payvoucherde VALUES("144","0","143","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("145","0","144","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("146","0","145","2","LE","20000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("149","0","148","2","LE","2050.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("151","0","150","2","LE","150.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("155","0","154","2","LE","1050.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("156","0","155","2","LE","3000.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("157","0","156","2","LE","2020.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("158","0","157","2","LE","1500.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("159","0","158","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("160","0","159","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("161","0","160","1","MO","29000.00","49","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("165","0","163","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("167","0","165","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("173","0","171","2","LE","70000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("174","0","172","2","LE","330000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("175","0","173","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("176","0","174","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("177","0","175","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("178","0","176","2","LE","9500.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("180","0","178","2","LE","8000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("182","0","180","1","MO","15500.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("187","0","185","2","MO","850.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("188","0","186","2","BA","3549.00","39","SU","ONLINE","2023-01-01","0","");
INSERT INTO tbl_payvoucherde VALUES("190","0","188","2","MO","13890.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("191","0","189","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("193","0","191","2","LE","10800.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("202","0","200","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("206","0","204","2","LE","8300.00","9","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("210","0","208","2","LE","10350.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("212","0","210","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("219","0","217","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("220","0","218","2","LE","60000.00","3","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("221","0","219","1","MO","7025.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("226","0","224","2","LE","38907.81","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("227","0","225","3","MO","19000.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("228","0","226","1","BA","691960.00","39","SU","ONLINE","2023-01-01","0","");
INSERT INTO tbl_payvoucherde VALUES("229","0","227","2","LE","114431.21","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("230","0","228","2","LE","1443.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("231","0","229","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("232","0","230","2","MO","11020.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("233","0","230","1","MO","1480.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("234","0","231","1","MO","5200.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("235","0","232","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("237","0","234","2","LE","144300.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("239","0","236","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("240","0","237","2","LE","1000.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("241","0","238","1","BA","90000.00","19","SU","ONLINE","2023-01-22","0","");
INSERT INTO tbl_payvoucherde VALUES("242","0","239","1","BA","12000.00","11","SU","ONLINE","2023-01-23","0","");
INSERT INTO tbl_payvoucherde VALUES("244","0","241","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("245","0","242","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("246","0","243","2","LE","300.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("247","0","244","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("248","0","245","1","MO","4000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("249","0","245","3","MO","5000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("250","0","246","1","BA","10000.00","9","SU","ONLINE","2023-01-25","0","");
INSERT INTO tbl_payvoucherde VALUES("251","0","247","1","BA","36150.00","11","SU","ONLINE","2023-01-25","0","");
INSERT INTO tbl_payvoucherde VALUES("253","0","249","2","LE","100.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("254","0","250","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("255","0","251","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("261","0","257","1","MO","3900.00","51","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("265","0","260","2","LE","2027272.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("266","0","261","2","LE","10000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("267","0","262","1","MO","10000.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("268","0","263","2","LE","1456.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("269","0","264","1","MO","1500.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("270","0","265","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("271","0","266","2","LE","100.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("272","0","267","2","LE","2400.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("274","0","269","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("275","0","270","1","MO","4770.00","52","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("276","0","271","2","LE","18000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("277","0","272","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("278","0","273","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("279","0","274","2","LE","500.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("280","0","275","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("281","0","276","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("282","0","277","2","LE","5000.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("283","0","278","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("285","0","280","2","MO","1000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("286","0","280","1","MO","18000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("288","0","282","1","BA","120000.00","12","SU","ONLINE","2023-01-29","0","");
INSERT INTO tbl_payvoucherde VALUES("289","0","283","1","BA","100000.00","4","SU","ONLINE","2023-01-30","0","");
INSERT INTO tbl_payvoucherde VALUES("290","0","284","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("292","0","286","2","LE","500.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("293","0","287","2","LE","550.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("294","0","288","1","BA","20000.00","12","SU","ONLINE","2023-01-30","0","");
INSERT INTO tbl_payvoucherde VALUES("295","0","289","2","LE","50.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("296","0","290","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("297","0","291","2","LE","50.00","2","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("298","0","292","1","MO","5373.00","54","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("300","0","294","2","LE","86.00","77","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("301","0","295","2","LE","7500.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("302","0","296","1","MO","12891.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("303","0","297","2","LE","709.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("304","0","298","2","LE","10500.00","12","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("305","0","299","2","LE","5000.00","3","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("306","0","300","2","LE","10.00","77","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("307","0","301","2","LE","12.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("308","0","302","1","BA","130000.00","19","SU","ONLINE","2023-02-03","0","");
INSERT INTO tbl_payvoucherde VALUES("309","0","303","2","LE","200.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("310","0","304","2","LE","8800.00","217","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("311","0","305","1","MO","280.00","99","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("314","0","308","2","LE","1000.00","4","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("315","0","309","2","LE","200.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("316","0","310","1","BA","50000.00","19","SU","ONLINE","2023-02-05","0","");
INSERT INTO tbl_payvoucherde VALUES("317","0","311","1","BA","51000.00","2","SU","ONLINE","2023-02-05","0","");
INSERT INTO tbl_payvoucherde VALUES("318","0","312","3","MO","7000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("322","0","316","2","LE","573040.00","2","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("323","0","317","2","LE","626960.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("324","0","318","2","LE","50.00","59","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("325","0","319","1","MO","12600.00","54","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("326","0","320","1","MO","6900.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("328","0","322","1","MO","5470.00","51","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("329","0","323","2","LE","3000.00","1","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("330","0","324","1","MO","3000.00","1","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("331","0","325","2","LE","500.00","224","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("332","0","326","2","LE","600.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("333","0","327","1","BA","54822.00","2","LO","ONLINE","2023-02-06","0","");
INSERT INTO tbl_payvoucherde VALUES("334","0","328","2","LE","50.00","77","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("335","0","329","1","BA","100000.00","4","SU","ONLINE","2023-02-08","0","");
INSERT INTO tbl_payvoucherde VALUES("336","0","330","2","LE","1000.00","4","LO","","","0","");
INSERT INTO tbl_payvoucherde VALUES("337","0","331","1","MO","8600.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("338","0","332","2","LE","5000.00","3","EM","","","0","");
INSERT INTO tbl_payvoucherde VALUES("339","0","333","2","LE","230.00","216","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("341","0","335","2","LE","2275.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("342","0","336","2","LE","40000.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("343","0","337","2","LE","700.00","63","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("344","0","338","1","MO","15000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("345","0","339","2","LE","3500.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("346","0","340","1","MO","8700.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("347","0","341","2","MO","3300.00","16","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("348","0","342","2","LE","7000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("349","0","343","2","LE","7000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("350","0","344","2","LE","10000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("351","0","345","2","LE","400.00","44","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("352","0","346","2","LE","400.00","189","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("353","0","347","2","LE","589.00","100","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("354","0","348","1","MO","1500.00","33","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("355","0","349","2","LE","640.00","44","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("356","0","350","2","LE","16628.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("357","0","351","2","LE","300.00","44","LE","","","0","");
INSERT INTO tbl_payvoucherde VALUES("358","0","352","1","MO","20594.50","51","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("359","0","353","2","LE","10150.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("360","0","354","1","MO","167210.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("361","0","355","2","LE","6275.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("362","0","356","2","BA","37050.00","10","SU","ONLINE","2023-04-09","0","");
INSERT INTO tbl_payvoucherde VALUES("363","0","357","2","LE","590.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("364","0","358","2","LE","8000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("365","0","359","1","MO","3440.96","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("366","0","360","1","MO","242623.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("367","0","361","2","LE","139519.00","5","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("368","0","362","2","LE","290.00","60","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("369","0","363","1","MO","24300.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("370","0","364","2","LE","102500.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("371","0","365","1","BA","25420.00","13","SU","ONLINE","2023-05-15","0","ONLINE");
INSERT INTO tbl_payvoucherde VALUES("372","0","366","2","LE","2000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("373","0","367","2","LE","2614.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("374","0","368","2","LE","2000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("375","0","369","1","MO","10000.00","62","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("376","0","370","2","LE","79450.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("377","0","371","2","LE","68000.00","5","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("378","0","372","2","LE","30000.00","5","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("379","0","373","1","MO","21450.00","49","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("380","0","374","1","MO","140000.00","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("381","0","375","2","LE","41405.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("382","0","376","1","MO","2600.00","192","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("383","0","377","2","LE","2000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("384","0","378","2","LE","1000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("385","0","379","2","LE","2000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("386","0","380","2","LE","2000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("387","0","381","2","LE","521800.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("388","0","382","2","LE","3000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("389","0","383","2","LE","226000.00","10","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("390","0","384","1","MO","2200.00","98","CU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("391","0","385","2","LE","10000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("392","0","386","2","LE","4000.00","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("393","0","387","1","MO","16996.85","49","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("394","0","388","2","LE","5000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("395","0","389","2","LE","10000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("396","0","390","2","LE","6000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("397","0","391","2","LE","10000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("398","0","392","2","LE","8500.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("399","0","393","2","LE","5000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("400","0","394","2","LE","9900.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("401","0","395","2","LE","533600.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("402","0","396","2","LE","2000.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("403","0","397","2","LE","60000.00","48","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("404","0","398","2","LE","171360.00","14","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("405","0","399","2","LE","315094.00","19","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("406","0","400","2","LE","7608.00","38","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("407","0","401","2","LE","450000.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("408","0","402","2","LE","225322.00","5","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("409","0","403","2","LE","950.00","62","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("410","0","404","1","MO","73920.00","13","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("411","0","405","1","MO","41928.50","51","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("412","0","406","1","MO","21943.24","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("413","0","407","1","MO","44000.00","1","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("414","0","408","1","MO","29510.00","7","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("415","0","409","1","MO","11502.40","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("416","0","410","2","LE","11600.00","19","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("417","0","411","1","MO","287222.74","43","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("418","0","412","2","LE","10000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("419","0","413","2","LE","5000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("420","0","414","2","LE","20000.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("421","0","415","2","LE","15600.00","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("422","0","416","1","MO","100724.25","49","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("423","0","417","1","MO","54705.00","2","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("424","0","418","1","MO","22950.50","40","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("425","0","419","1","MO","190763.24","37","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("426","0","420","1","MO","1225620.77","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("427","0","421","2","MO","274634.48","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("428","0","422","1","MO","6355.00","55","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("429","0","423","3","MO","72575.00","4","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("430","0","424","1","MO","32100.00","71","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("431","0","425","2","MO","139152.00","39","SU","","","0","");
INSERT INTO tbl_payvoucherde VALUES("432","0","426","1","MO","16800.00","43","SU","","","0","");



CREATE TABLE `tbl_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invno` varchar(15) NOT NULL,
  `refinv` varchar(15) DEFAULT NULL,
  `type` varchar(2) NOT NULL,
  `supid` int(11) NOT NULL,
  `itemdis` decimal(8,2) NOT NULL DEFAULT 0.00,
  `subtot` decimal(12,2) NOT NULL,
  `disp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `disamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `totdis` decimal(8,2) NOT NULL DEFAULT 0.00,
  `vatp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `vatamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `taxp` decimal(8,2) NOT NULL DEFAULT 0.00,
  `taxamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `spmoney` decimal(8,2) NOT NULL DEFAULT 0.00,
  `otname` varchar(35) NOT NULL,
  `otamo` decimal(8,2) NOT NULL DEFAULT 0.00,
  `freight` decimal(8,2) NOT NULL DEFAULT 0.00,
  `less` decimal(8,2) NOT NULL DEFAULT 0.00,
  `adamo` decimal(12,2) DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `curid` int(11) NOT NULL,
  `ref` varchar(25) DEFAULT NULL,
  `note` varchar(150) DEFAULT NULL,
  `apdate` date NOT NULL,
  `nxtduedate` date DEFAULT NULL,
  `rawcash` decimal(12,2) NOT NULL DEFAULT 0.00,
  `changes` decimal(8,2) NOT NULL DEFAULT 0.00,
  `purp` int(11) DEFAULT NULL,
  `creditid` varchar(15) NOT NULL,
  `details` varchar(65) DEFAULT NULL,
  `brid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1411 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_purchase VALUES("6","PUR051222101","","SU","39","0.00","3840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3840.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:24:21");
INSERT INTO tbl_purchase VALUES("8","PUR051222103","","SU","39","0.00","51300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51300.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:25:26");
INSERT INTO tbl_purchase VALUES("9","PUR051222104","","SU","39","0.00","30380.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30380.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:26:11");
INSERT INTO tbl_purchase VALUES("10","PUR051222105","","SU","39","0.00","66700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","66700.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:26:46");
INSERT INTO tbl_purchase VALUES("11","PUR051222106","","SU","39","0.00","298530.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","298530.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:28:12");
INSERT INTO tbl_purchase VALUES("13","PUR051222108","","SU","39","0.00","262440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","262440.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:29:43");
INSERT INTO tbl_purchase VALUES("14","PUR051222109","","SU","39","0.00","89700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","89700.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 10:15:13");
INSERT INTO tbl_purchase VALUES("15","PUR051222110","","SU","39","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:30:52");
INSERT INTO tbl_purchase VALUES("16","PUR051222111","","SU","39","0.00","56240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56240.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 09:49:14");
INSERT INTO tbl_purchase VALUES("17","PUR051222112","","SU","39","0.00","188190.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","188190.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:33:24");
INSERT INTO tbl_purchase VALUES("18","PUR051222113","","SU","39","0.00","228200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228200.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:34:40");
INSERT INTO tbl_purchase VALUES("19","PUR051222114","","SU","39","0.00","10800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10800.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:37:02");
INSERT INTO tbl_purchase VALUES("20","PUR051222115","","SU","39","0.00","26190.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26190.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:20:05");
INSERT INTO tbl_purchase VALUES("22","PUR051222117","","SU","39","0.00","22440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22440.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:44:41");
INSERT INTO tbl_purchase VALUES("23","PUR051222118","","SU","39","0.00","16120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16120.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:04:26");
INSERT INTO tbl_purchase VALUES("24","PUR051222119","","SU","39","0.00","16510.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16510.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:08:13");
INSERT INTO tbl_purchase VALUES("25","PUR051222120","","SU","39","0.00","14690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14690.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:22:34");
INSERT INTO tbl_purchase VALUES("26","PUR051222121","","SU","39","0.00","18590.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18590.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 04:56:29");
INSERT INTO tbl_purchase VALUES("27","PUR051222122","","SU","39","0.00","15990.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15990.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:11:43");
INSERT INTO tbl_purchase VALUES("28","PUR051222123","","SU","39","0.00","15470.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15470.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-07 05:01:21");
INSERT INTO tbl_purchase VALUES("29","PUR051222124","","SU","39","0.00","7500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7500.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:44:25");
INSERT INTO tbl_purchase VALUES("30","PUR051222125","","SU","39","0.00","9660.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9660.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:45:12");
INSERT INTO tbl_purchase VALUES("31","PUR051222126","","SU","39","0.00","7800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7800.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:45:53");
INSERT INTO tbl_purchase VALUES("32","PUR051222127","","SU","39","0.00","8200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8200.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:46:18");
INSERT INTO tbl_purchase VALUES("33","PUR051222128","","SU","39","0.00","12825.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12825.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:46:57");
INSERT INTO tbl_purchase VALUES("34","PUR051222129","","SU","39","0.00","3350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3350.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:47:40");
INSERT INTO tbl_purchase VALUES("35","PUR051222130","","SU","39","0.00","12000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12000.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:51:07");
INSERT INTO tbl_purchase VALUES("36","PUR051222131","","SU","39","0.00","4410.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4410.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:51:53");
INSERT INTO tbl_purchase VALUES("37","PUR051222132","","SU","39","0.00","4410.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4410.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:52:19");
INSERT INTO tbl_purchase VALUES("38","PUR051222133","","SU","39","0.00","860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","860.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 02:53:22");
INSERT INTO tbl_purchase VALUES("39","PUR051222134","","SU","39","0.00","984200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","984200.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-16 06:06:10");
INSERT INTO tbl_purchase VALUES("41","PUR051222136","","SU","39","0.00","36800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36800.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:35:33");
INSERT INTO tbl_purchase VALUES("42","PUR051222137","","SU","39","0.00","17940.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17940.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 03:02:34");
INSERT INTO tbl_purchase VALUES("43","PUR051222138","","SU","39","0.00","3125.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3125.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 03:03:17");
INSERT INTO tbl_purchase VALUES("44","PUR051222139","","SU","39","0.00","2750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2750.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 03:04:04");
INSERT INTO tbl_purchase VALUES("46","PUR051222141","","SU","39","0.00","2280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2280.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-06 07:42:09");
INSERT INTO tbl_purchase VALUES("47","PUR051222142","","SU","9","0.00","13270.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13270.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2023-01-20 06:24:27");
INSERT INTO tbl_purchase VALUES("48","PUR051222143","","SU","39","0.00","3150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3150.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:07:37");
INSERT INTO tbl_purchase VALUES("49","PUR051222144","","SU","39","0.00","3900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3900.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:08:23");
INSERT INTO tbl_purchase VALUES("50","PUR051222145","","SU","39","0.00","2680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2680.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:10:01");
INSERT INTO tbl_purchase VALUES("51","PUR051222146","","SU","39","0.00","13500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13500.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:18:28");
INSERT INTO tbl_purchase VALUES("52","PUR051222147","","SU","39","0.00","8100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8100.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:21:03");
INSERT INTO tbl_purchase VALUES("53","PUR051222148","","SU","39","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2023-01-02 12:25:32");
INSERT INTO tbl_purchase VALUES("54","PUR051222149","","SU","39","0.00","5600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5600.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 05:26:56");
INSERT INTO tbl_purchase VALUES("84","PUR051222158","","SU","16","0.00","144300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","144300.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 08:32:28");
INSERT INTO tbl_purchase VALUES("87","PUR051222159","","SU","14","0.00","171360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","171360.00","0","","","2022-12-05","2022-12-12","0.00","0.00","","LE_2","","0","1","2022-12-05 10:05:17");
INSERT INTO tbl_purchase VALUES("90","PUR061222101","","SU","39","0.00","17861.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17861.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-07 02:34:44");
INSERT INTO tbl_purchase VALUES("91","PUR061222102","","SU","39","0.00","16065.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16065.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-07 01:26:42");
INSERT INTO tbl_purchase VALUES("93","PUR061222104","","SU","39","0.00","14880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14880.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 01:03:08");
INSERT INTO tbl_purchase VALUES("94","PUR061222105","","SU","39","0.00","11200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11200.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 01:04:54");
INSERT INTO tbl_purchase VALUES("95","PUR061222106","","SU","39","0.00","6800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6800.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 11:42:16");
INSERT INTO tbl_purchase VALUES("96","PUR061222107","","SU","39","0.00","104400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104400.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-07 03:00:29");
INSERT INTO tbl_purchase VALUES("97","PUR061222108","","SU","39","0.00","15730.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15730.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-12 11:46:40");
INSERT INTO tbl_purchase VALUES("98","PUR061222109","","SU","39","0.00","2500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2500.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:31:34");
INSERT INTO tbl_purchase VALUES("99","PUR061222110","","SU","39","0.00","1050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1050.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:32:59");
INSERT INTO tbl_purchase VALUES("100","PUR061222111","","SU","39","0.00","134.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:52:00");
INSERT INTO tbl_purchase VALUES("101","PUR061222112","","SU","39","0.00","448.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","448.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:53:27");
INSERT INTO tbl_purchase VALUES("102","PUR061222113","","SU","39","0.00","755.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","755.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:54:15");
INSERT INTO tbl_purchase VALUES("103","PUR061222114","","SU","39","0.00","51750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51750.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:56:50");
INSERT INTO tbl_purchase VALUES("104","PUR061222115","","SU","39","0.00","7745.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7745.50","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 12:58:40");
INSERT INTO tbl_purchase VALUES("105","PUR061222116","","SU","39","0.00","20888.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20888.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 01:01:05");
INSERT INTO tbl_purchase VALUES("107","PUR061222117","","SU","39","0.00","7500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7500.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 01:11:59");
INSERT INTO tbl_purchase VALUES("111","PUR061222119","","SU","39","0.00","1900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1900.00","0","","","2022-12-06","2022-12-13","0.00","0.00","","LE_2","","0","1","2022-12-06 11:08:48");
INSERT INTO tbl_purchase VALUES("112","PUR071222101","","SU","39","0.00","2100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2100.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 01:39:41");
INSERT INTO tbl_purchase VALUES("113","PUR071222102","","SU","39","0.00","3100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3100.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 01:43:17");
INSERT INTO tbl_purchase VALUES("114","PUR071222103","","SU","39","0.00","6250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6250.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:00:12");
INSERT INTO tbl_purchase VALUES("115","PUR071222104","","SU","39","0.00","6500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6500.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:01:09");
INSERT INTO tbl_purchase VALUES("116","PUR071222105","","SU","39","0.00","4100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4100.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:03:22");
INSERT INTO tbl_purchase VALUES("117","PUR071222106","","SU","39","0.00","4800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4800.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:04:16");
INSERT INTO tbl_purchase VALUES("118","PUR071222107","","SU","39","0.00","7920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7920.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:05:45");
INSERT INTO tbl_purchase VALUES("119","PUR071222108","","SU","39","0.00","8550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8550.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:07:03");
INSERT INTO tbl_purchase VALUES("120","PUR071222109","","SU","39","0.00","6900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6900.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:07:57");
INSERT INTO tbl_purchase VALUES("121","PUR071222110","","SU","39","0.00","8000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:09:02");
INSERT INTO tbl_purchase VALUES("122","PUR071222111","","SU","39","0.00","700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","700.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:09:41");
INSERT INTO tbl_purchase VALUES("123","PUR071222112","","SU","39","0.00","6300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6300.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:10:53");
INSERT INTO tbl_purchase VALUES("124","PUR071222113","","SU","39","0.00","4200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4200.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:12:24");
INSERT INTO tbl_purchase VALUES("125","PUR071222114","","SU","39","0.00","12750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12750.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:13:06");
INSERT INTO tbl_purchase VALUES("126","PUR071222115","","SU","39","0.00","4000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:14:32");
INSERT INTO tbl_purchase VALUES("127","PUR071222116","","SU","39","0.00","1160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1160.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:20:33");
INSERT INTO tbl_purchase VALUES("128","PUR071222117","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:21:04");
INSERT INTO tbl_purchase VALUES("129","PUR071222118","","SU","39","0.00","1150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1150.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:21:31");
INSERT INTO tbl_purchase VALUES("130","PUR071222119","","SU","39","0.00","1400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1400.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:22:01");
INSERT INTO tbl_purchase VALUES("131","PUR071222120","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:23:01");
INSERT INTO tbl_purchase VALUES("132","PUR071222121","","SU","39","0.00","10650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10650.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:28:00");
INSERT INTO tbl_purchase VALUES("133","PUR071222122","","SU","39","0.00","4822.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4822.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:29:14");
INSERT INTO tbl_purchase VALUES("134","PUR071222123","","SU","39","0.00","45120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45120.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:30:33");
INSERT INTO tbl_purchase VALUES("135","PUR071222124","","SU","39","0.00","23170.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23170.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-19 07:07:24");
INSERT INTO tbl_purchase VALUES("136","PUR071222125","","SU","39","0.00","9000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:35:47");
INSERT INTO tbl_purchase VALUES("137","PUR071222126","","SU","39","0.00","4050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4050.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:36:29");
INSERT INTO tbl_purchase VALUES("138","PUR071222127","","SU","39","0.00","4300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4300.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 02:47:35");
INSERT INTO tbl_purchase VALUES("139","PUR071222128","","SU","39","0.00","2300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2300.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-10 05:07:32");
INSERT INTO tbl_purchase VALUES("140","PUR071222129","","SU","39","0.00","12400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12400.00","0","","","2022-12-01","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-06 07:59:42");
INSERT INTO tbl_purchase VALUES("142","PUR071222131","","SU","39","0.00","2080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2080.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 04:26:34");
INSERT INTO tbl_purchase VALUES("143","PUR071222132","","SU","39","0.00","1690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1690.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 04:28:26");
INSERT INTO tbl_purchase VALUES("144","PUR071222133","","SU","39","0.00","1560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1560.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 04:29:43");
INSERT INTO tbl_purchase VALUES("145","PUR071222134","","SU","39","0.00","780.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","780.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 04:31:39");
INSERT INTO tbl_purchase VALUES("147","PUR071222135","","SU","39","0.00","52390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52390.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 04:46:44");
INSERT INTO tbl_purchase VALUES("148","PUR071222136","","SU","39","0.00","19370.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19370.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:27:12");
INSERT INTO tbl_purchase VALUES("149","PUR071222137","","SU","39","0.00","16900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16900.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:30:07");
INSERT INTO tbl_purchase VALUES("150","PUR071222138","","SU","39","0.00","13520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13520.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:36:06");
INSERT INTO tbl_purchase VALUES("151","PUR071222139","","SU","39","0.00","18590.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18590.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:38:44");
INSERT INTO tbl_purchase VALUES("152","PUR071222140","","SU","39","0.00","5600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5600.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:41:07");
INSERT INTO tbl_purchase VALUES("153","PUR071222141","","SU","39","0.00","250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","250.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:43:06");
INSERT INTO tbl_purchase VALUES("154","PUR071222142","","SU","39","0.00","450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:46:39");
INSERT INTO tbl_purchase VALUES("155","PUR071222143","","SU","39","0.00","1140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1140.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:55:52");
INSERT INTO tbl_purchase VALUES("156","PUR071222144","","SU","39","0.00","750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","750.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 05:57:03");
INSERT INTO tbl_purchase VALUES("157","PUR071222145","","SU","39","0.00","2175.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2175.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:00:54");
INSERT INTO tbl_purchase VALUES("158","PUR071222146","","SU","39","0.00","90.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:01:30");
INSERT INTO tbl_purchase VALUES("159","PUR071222147","","SU","39","0.00","4248.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4248.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:13:09");
INSERT INTO tbl_purchase VALUES("160","PUR071222148","","SU","39","0.00","1520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1520.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:14:06");
INSERT INTO tbl_purchase VALUES("161","PUR071222149","","SU","39","0.00","1550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1550.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:14:38");
INSERT INTO tbl_purchase VALUES("162","PUR071222150","","SU","39","0.00","450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:15:18");
INSERT INTO tbl_purchase VALUES("163","PUR071222151","","SU","39","0.00","4500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4500.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:16:44");
INSERT INTO tbl_purchase VALUES("164","PUR071222152","","SU","39","0.00","1050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1050.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:17:25");
INSERT INTO tbl_purchase VALUES("165","PUR071222153","","SU","39","0.00","3500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3500.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 06:17:53");
INSERT INTO tbl_purchase VALUES("166","PUR071222154","","SU","39","0.00","596.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","596.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:43:30");
INSERT INTO tbl_purchase VALUES("167","PUR071222155","","SU","39","0.00","2112.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2112.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:35:48");
INSERT INTO tbl_purchase VALUES("168","PUR071222156","","SU","39","0.00","2850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2850.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:37:54");
INSERT INTO tbl_purchase VALUES("169","PUR071222157","","SU","39","0.00","3010.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3010.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:37:08");
INSERT INTO tbl_purchase VALUES("170","PUR071222158","","SU","39","0.00","2856.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2856.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:34:10");
INSERT INTO tbl_purchase VALUES("171","PUR071222159","","SU","39","0.00","6750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6750.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:41:20");
INSERT INTO tbl_purchase VALUES("172","PUR071222160","","SU","39","0.00","6375.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6375.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:42:52");
INSERT INTO tbl_purchase VALUES("173","PUR071222161","","SU","39","0.00","5000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 09:50:57");
INSERT INTO tbl_purchase VALUES("174","PUR071222162","","SU","39","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-08 12:10:09");
INSERT INTO tbl_purchase VALUES("175","PUR071222163","","SU","39","0.00","15200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15200.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 09:53:18");
INSERT INTO tbl_purchase VALUES("176","PUR071222164","","SU","39","0.00","1580.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1580.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 09:55:55");
INSERT INTO tbl_purchase VALUES("177","PUR071222165","","SU","39","0.00","3700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3700.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-08 12:06:33");
INSERT INTO tbl_purchase VALUES("179","PUR071222166","","SU","39","0.00","38400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38400.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:16:42");
INSERT INTO tbl_purchase VALUES("180","PUR071222167","","SU","39","0.00","2100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2100.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:02:38");
INSERT INTO tbl_purchase VALUES("181","PUR071222168","","SU","39","0.00","64600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64600.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-17 12:30:39");
INSERT INTO tbl_purchase VALUES("182","PUR071222169","","SU","39","0.00","185250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","185250.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-21 03:48:18");
INSERT INTO tbl_purchase VALUES("184","PUR071222171","","SU","39","0.00","6124.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6124.20","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:06:23");
INSERT INTO tbl_purchase VALUES("185","PUR071222172","","SU","39","0.00","3698.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3698.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:08:21");
INSERT INTO tbl_purchase VALUES("186","PUR071222173","","SU","39","0.00","1450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1450.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:09:01");
INSERT INTO tbl_purchase VALUES("187","PUR071222174","","SU","39","0.00","4800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4800.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:09:26");
INSERT INTO tbl_purchase VALUES("188","PUR071222175","","SU","39","0.00","700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","700.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:09:58");
INSERT INTO tbl_purchase VALUES("189","PUR071222176","","SU","39","0.00","18000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:11:44");
INSERT INTO tbl_purchase VALUES("190","PUR071222177","","SU","39","0.00","4800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4800.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 12:26:51");
INSERT INTO tbl_purchase VALUES("191","PUR071222178","","SU","39","0.00","1450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1450.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 11:44:04");
INSERT INTO tbl_purchase VALUES("192","PUR071222179","","SU","39","0.00","1000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 09:10:14");
INSERT INTO tbl_purchase VALUES("193","PUR071222180","","SU","39","0.00","570.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","570.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2023-01-02 12:14:38");
INSERT INTO tbl_purchase VALUES("194","PUR071222181","","SU","39","0.00","70000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:12:01");
INSERT INTO tbl_purchase VALUES("195","PUR071222182","","SU","39","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:12:34");
INSERT INTO tbl_purchase VALUES("196","PUR071222183","","SU","39","0.00","35856.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35856.00","0","","","2022-12-07","2022-12-14","0.00","0.00","","LE_2","","0","1","2022-12-07 10:13:07");
INSERT INTO tbl_purchase VALUES("197","PUR081222101","","SU","39","0.00","85.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 11:24:06");
INSERT INTO tbl_purchase VALUES("198","PUR081222102","","SU","39","0.00","5985.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5985.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-17 12:33:51");
INSERT INTO tbl_purchase VALUES("199","PUR081222103","","SU","39","0.00","1150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1150.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 12:26:52");
INSERT INTO tbl_purchase VALUES("200","PUR081222104","","SU","39","0.00","2619.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2619.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 09:56:33");
INSERT INTO tbl_purchase VALUES("201","PUR081222105","","SU","39","0.00","660.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","660.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 09:57:24");
INSERT INTO tbl_purchase VALUES("202","PUR081222106","","SU","39","0.00","350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:05:13");
INSERT INTO tbl_purchase VALUES("203","PUR081222107","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:06:54");
INSERT INTO tbl_purchase VALUES("204","PUR081222108","","SU","39","0.00","2100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2100.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:07:34");
INSERT INTO tbl_purchase VALUES("205","PUR081222109","","SU","39","0.00","360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","360.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:07:57");
INSERT INTO tbl_purchase VALUES("206","PUR081222110","","SU","39","0.00","360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","360.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:13:02");
INSERT INTO tbl_purchase VALUES("207","PUR081222111","","SU","39","0.00","440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","440.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:13:39");
INSERT INTO tbl_purchase VALUES("208","PUR081222112","","SU","39","0.00","720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","720.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:15:33");
INSERT INTO tbl_purchase VALUES("209","PUR081222113","","SU","39","0.00","530.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","530.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:22:39");
INSERT INTO tbl_purchase VALUES("210","PUR081222114","","SU","39","0.00","2596.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2596.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:23:32");
INSERT INTO tbl_purchase VALUES("211","PUR081222115","","SU","39","0.00","472.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","472.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:24:19");
INSERT INTO tbl_purchase VALUES("212","PUR081222116","","SU","39","0.00","1060.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1060.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:24:53");
INSERT INTO tbl_purchase VALUES("213","PUR081222117","","SU","39","0.00","480.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","480.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:25:38");
INSERT INTO tbl_purchase VALUES("214","PUR081222118","","SU","39","0.00","1920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1920.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:25:59");
INSERT INTO tbl_purchase VALUES("215","PUR081222119","","SU","39","0.00","400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","400.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:31:07");
INSERT INTO tbl_purchase VALUES("216","PUR081222120","","SU","39","0.00","80.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:32:04");
INSERT INTO tbl_purchase VALUES("217","PUR081222121","","SU","39","0.00","120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:41:55");
INSERT INTO tbl_purchase VALUES("218","PUR081222122","","SU","39","0.00","100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:44:37");
INSERT INTO tbl_purchase VALUES("219","PUR081222123","","SU","39","0.00","3380.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3380.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-26 07:55:50");
INSERT INTO tbl_purchase VALUES("220","PUR081222124","","SU","39","0.00","525.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","525.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:48:05");
INSERT INTO tbl_purchase VALUES("221","PUR081222125","","SU","39","0.00","720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","720.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:49:39");
INSERT INTO tbl_purchase VALUES("222","PUR081222126","","SU","39","0.00","450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:54:06");
INSERT INTO tbl_purchase VALUES("223","PUR081222127","","SU","39","0.00","1995.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1995.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:56:24");
INSERT INTO tbl_purchase VALUES("224","PUR081222128","","SU","39","0.00","1920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1920.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:57:01");
INSERT INTO tbl_purchase VALUES("225","PUR081222129","","SU","39","0.00","880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","880.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 10:57:34");
INSERT INTO tbl_purchase VALUES("226","PUR081222130","","SU","39","0.00","4440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4440.00","0","","","2022-12-08","2022-12-15","0.00","0.00","","LE_2","","0","1","2022-12-08 11:02:28");
INSERT INTO tbl_purchase VALUES("227","PUR111222101","","SU","39","0.00","1800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1800.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:48:21");
INSERT INTO tbl_purchase VALUES("228","PUR111222102","","SU","39","0.00","1920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1920.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:51:46");
INSERT INTO tbl_purchase VALUES("229","PUR111222103","","SU","39","0.00","840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","840.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:52:40");
INSERT INTO tbl_purchase VALUES("230","PUR111222104","","SU","39","0.00","816.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","816.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:53:54");
INSERT INTO tbl_purchase VALUES("231","PUR111222105","","SU","39","0.00","228.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","228.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:54:31");
INSERT INTO tbl_purchase VALUES("232","PUR111222106","","SU","39","0.00","444.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","444.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:55:08");
INSERT INTO tbl_purchase VALUES("233","PUR111222107","","SU","39","0.00","595.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","595.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:57:56");
INSERT INTO tbl_purchase VALUES("234","PUR111222108","","SU","39","0.00","740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","740.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 07:59:29");
INSERT INTO tbl_purchase VALUES("235","PUR111222109","","SU","39","0.00","350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","350.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:07:24");
INSERT INTO tbl_purchase VALUES("236","PUR111222110","","SU","39","0.00","140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:10:09");
INSERT INTO tbl_purchase VALUES("237","PUR111222111","","SU","39","0.00","20.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:16:22");
INSERT INTO tbl_purchase VALUES("238","PUR111222112","","SU","39","0.00","640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","640.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:17:35");
INSERT INTO tbl_purchase VALUES("239","PUR111222113","","SU","39","0.00","1652.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1652.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:19:10");
INSERT INTO tbl_purchase VALUES("240","PUR111222114","","SU","39","0.00","1416.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1416.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:19:45");
INSERT INTO tbl_purchase VALUES("241","PUR111222115","","SU","39","0.00","3068.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3068.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 08:20:27");
INSERT INTO tbl_purchase VALUES("242","PUR111222116","","SU","39","0.00","1155.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1155.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:00:06");
INSERT INTO tbl_purchase VALUES("243","PUR111222117","","SU","39","0.00","750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","750.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:00:58");
INSERT INTO tbl_purchase VALUES("244","PUR111222118","","SU","39","0.00","360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","360.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:01:28");
INSERT INTO tbl_purchase VALUES("245","PUR111222119","","SU","39","0.00","550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","550.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:03:27");
INSERT INTO tbl_purchase VALUES("246","PUR111222120","","SU","39","0.00","1100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1100.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:06:47");
INSERT INTO tbl_purchase VALUES("247","PUR111222121","","SU","39","0.00","180.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:07:44");
INSERT INTO tbl_purchase VALUES("248","PUR111222122","","SU","39","0.00","840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","840.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:09:39");
INSERT INTO tbl_purchase VALUES("249","PUR111222123","","SU","39","0.00","550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","550.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:10:25");
INSERT INTO tbl_purchase VALUES("250","PUR111222124","","SU","39","0.00","460.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","460.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:11:40");
INSERT INTO tbl_purchase VALUES("251","PUR111222125","","SU","39","0.00","1325.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1325.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:14:07");
INSERT INTO tbl_purchase VALUES("253","PUR111222127","","SU","39","0.00","1350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1350.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:15:15");
INSERT INTO tbl_purchase VALUES("254","PUR111222128","","SU","39","0.00","450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:16:12");
INSERT INTO tbl_purchase VALUES("255","PUR111222129","","SU","39","0.00","245.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","245.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:47:48");
INSERT INTO tbl_purchase VALUES("257","PUR111222131","","SU","39","0.00","960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","960.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:50:12");
INSERT INTO tbl_purchase VALUES("258","PUR111222132","","SU","39","0.00","1539.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1539.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 09:53:35");
INSERT INTO tbl_purchase VALUES("259","PUR111222133","","SU","39","0.00","450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","450.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 10:00:40");
INSERT INTO tbl_purchase VALUES("260","PUR111222134","","SU","39","0.00","160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","160.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 10:04:27");
INSERT INTO tbl_purchase VALUES("261","PUR111222135","","SU","39","0.00","1120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1120.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-17 09:00:32");
INSERT INTO tbl_purchase VALUES("262","PUR111222136","","SU","39","0.00","690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","690.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 10:10:39");
INSERT INTO tbl_purchase VALUES("263","PUR111222137","","SU","39","0.00","1000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1000.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 10:12:26");
INSERT INTO tbl_purchase VALUES("264","PUR111222138","","SU","39","0.00","816.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","816.00","0","","","2022-12-11","2022-12-18","0.00","0.00","","LE_2","","0","1","2022-12-11 10:16:38");
INSERT INTO tbl_purchase VALUES("265","PUR121222101","","SU","39","0.00","390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","390.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:13:33");
INSERT INTO tbl_purchase VALUES("266","PUR121222102","","SU","39","0.00","840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","840.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:14:10");
INSERT INTO tbl_purchase VALUES("267","PUR121222103","","SU","39","0.00","700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","700.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:16:17");
INSERT INTO tbl_purchase VALUES("268","PUR121222104","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:18:49");
INSERT INTO tbl_purchase VALUES("269","PUR121222105","","SU","39","0.00","4945.43","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4945.43","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:28:39");
INSERT INTO tbl_purchase VALUES("270","PUR121222106","","SU","39","0.00","90.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:27:03");
INSERT INTO tbl_purchase VALUES("271","PUR121222107","","SU","39","0.00","8550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8550.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:47:54");
INSERT INTO tbl_purchase VALUES("272","PUR121222108","","SU","39","0.00","925.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","925.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 11:55:18");
INSERT INTO tbl_purchase VALUES("273","PUR121222109","","SU","39","0.00","1785.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1785.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 12:22:23");
INSERT INTO tbl_purchase VALUES("274","PUR121222110","","SU","39","0.00","455.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","455.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 12:28:23");
INSERT INTO tbl_purchase VALUES("275","PUR121222111","","SU","39","0.00","2160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2160.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 12:29:33");
INSERT INTO tbl_purchase VALUES("276","PUR121222112","","SU","39","0.00","3420.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3420.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 12:48:33");
INSERT INTO tbl_purchase VALUES("277","PUR121222113","","SU","39","0.00","432.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","432.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 12:53:36");
INSERT INTO tbl_purchase VALUES("278","PUR121222114","","SU","39","0.00","3360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3360.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 01:06:48");
INSERT INTO tbl_purchase VALUES("279","PUR121222115","","SU","39","0.00","3100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3100.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 01:21:08");
INSERT INTO tbl_purchase VALUES("280","PUR121222116","","SU","39","0.00","3230.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3230.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 06:14:11");
INSERT INTO tbl_purchase VALUES("281","PUR121222117","","SU","39","0.00","360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","360.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 06:15:00");
INSERT INTO tbl_purchase VALUES("282","PUR121222118","","SU","39","0.00","8880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8880.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 06:28:52");
INSERT INTO tbl_purchase VALUES("283","PUR121222119","","SU","39","0.00","3105.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3105.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 06:44:18");
INSERT INTO tbl_purchase VALUES("284","PUR121222120","","SU","39","0.00","1860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1860.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 07:22:03");
INSERT INTO tbl_purchase VALUES("285","PUR121222121","","SU","39","0.00","2420.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2420.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 07:55:16");
INSERT INTO tbl_purchase VALUES("286","PUR121222122","","SU","39","0.00","1980.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1980.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 07:56:17");
INSERT INTO tbl_purchase VALUES("287","PUR121222123","","SU","39","0.00","840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","840.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 07:56:44");
INSERT INTO tbl_purchase VALUES("288","PUR121222124","","SU","39","0.00","800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","800.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 07:58:08");
INSERT INTO tbl_purchase VALUES("289","PUR121222125","","SU","39","0.00","3800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3800.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 07:59:31");
INSERT INTO tbl_purchase VALUES("290","PUR121222126","","SU","39","0.00","220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:00:34");
INSERT INTO tbl_purchase VALUES("291","PUR121222127","","SU","39","0.00","84.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:01:41");
INSERT INTO tbl_purchase VALUES("292","PUR121222128","","SU","39","0.00","220.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","220.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:02:49");
INSERT INTO tbl_purchase VALUES("293","PUR121222129","","SU","39","0.00","200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:03:42");
INSERT INTO tbl_purchase VALUES("294","PUR121222130","","SU","39","0.00","175.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","175.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:08:40");
INSERT INTO tbl_purchase VALUES("295","PUR121222131","","SU","39","0.00","217.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","217.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:09:08");
INSERT INTO tbl_purchase VALUES("296","PUR121222132","","SU","39","0.00","260.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","260.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:09:56");
INSERT INTO tbl_purchase VALUES("297","PUR121222133","","SU","39","0.00","140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:13:33");
INSERT INTO tbl_purchase VALUES("298","PUR121222134","","SU","39","0.00","8575.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8575.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-13 09:56:35");
INSERT INTO tbl_purchase VALUES("299","PUR121222135","","SU","39","0.00","1540.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1540.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:23:08");
INSERT INTO tbl_purchase VALUES("300","PUR121222136","","SU","39","0.00","1890.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1890.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:26:02");
INSERT INTO tbl_purchase VALUES("301","PUR121222137","","SU","39","0.00","3120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3120.00","0","","","2022-12-12","2022-12-19","0.00","0.00","","LE_2","","0","1","2022-12-12 08:33:37");
INSERT INTO tbl_purchase VALUES("302","PUR131222101","","SU","39","0.00","2790.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2790.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:23:01");
INSERT INTO tbl_purchase VALUES("303","PUR131222102","","SU","39","0.00","1300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1300.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:24:00");
INSERT INTO tbl_purchase VALUES("304","PUR131222103","","SU","39","0.00","1800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1800.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:24:48");
INSERT INTO tbl_purchase VALUES("305","PUR131222104","","SU","39","0.00","1300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1300.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:25:36");
INSERT INTO tbl_purchase VALUES("306","PUR131222105","","SU","39","0.00","1050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1050.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:26:33");
INSERT INTO tbl_purchase VALUES("307","PUR131222106","","SU","39","0.00","1760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1760.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:27:45");
INSERT INTO tbl_purchase VALUES("308","PUR131222107","","SU","39","0.00","4050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4050.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 01:02:56");
INSERT INTO tbl_purchase VALUES("309","PUR131222108","","SU","39","0.00","1602.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1602.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 10:03:13");
INSERT INTO tbl_purchase VALUES("310","PUR131222109","","SU","39","0.00","260.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","260.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:41:25");
INSERT INTO tbl_purchase VALUES("311","PUR131222110","","SU","39","0.00","196.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","196.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:42:56");
INSERT INTO tbl_purchase VALUES("312","PUR131222111","","SU","39","0.00","600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","600.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 01:02:03");
INSERT INTO tbl_purchase VALUES("313","PUR131222112","","SU","39","0.00","1560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1560.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 12:46:32");
INSERT INTO tbl_purchase VALUES("314","PUR131222113","","SU","39","0.00","480.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","480.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 08:59:42");
INSERT INTO tbl_purchase VALUES("315","PUR131222114","","SU","39","0.00","240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","240.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:02:05");
INSERT INTO tbl_purchase VALUES("316","PUR131222115","","SU","39","0.00","96.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","96.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:03:09");
INSERT INTO tbl_purchase VALUES("317","PUR131222116","","SU","39","0.00","810.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","810.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:04:30");
INSERT INTO tbl_purchase VALUES("318","PUR131222117","","SU","39","0.00","1080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1080.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:06:42");
INSERT INTO tbl_purchase VALUES("321","PUR131222120","","SU","39","0.00","595.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","595.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:12:11");
INSERT INTO tbl_purchase VALUES("322","PUR131222121","","SU","39","0.00","140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:14:35");
INSERT INTO tbl_purchase VALUES("323","PUR131222122","","SU","39","0.00","2025.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2025.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:28:10");
INSERT INTO tbl_purchase VALUES("324","PUR131222123","","SU","39","0.00","13520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13520.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:41:11");
INSERT INTO tbl_purchase VALUES("325","PUR131222124","","SU","39","0.00","5400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5400.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:43:40");
INSERT INTO tbl_purchase VALUES("326","PUR131222125","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:46:25");
INSERT INTO tbl_purchase VALUES("327","PUR131222126","","SU","39","0.00","960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","960.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:50:42");
INSERT INTO tbl_purchase VALUES("328","PUR131222127","","SU","39","0.00","5382.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5382.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 09:53:34");
INSERT INTO tbl_purchase VALUES("329","PUR131222128","","SU","39","0.00","1740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1740.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 10:04:33");
INSERT INTO tbl_purchase VALUES("330","PUR131222129","","SU","39","0.00","515.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","515.00","0","","","2022-12-13","2022-12-20","0.00","0.00","","LE_2","","0","1","2022-12-13 10:05:08");
INSERT INTO tbl_purchase VALUES("331","PUR141222101","","SU","39","0.00","150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150.00","0","","","2022-12-14","2022-12-21","0.00","0.00","","LE_2","","0","1","2022-12-14 12:07:44");
INSERT INTO tbl_purchase VALUES("332","PUR141222102","","SU","39","0.00","385.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","385.00","0","","","2022-12-14","2022-12-21","0.00","0.00","","LE_2","","0","1","2022-12-14 12:08:38");
INSERT INTO tbl_purchase VALUES("333","PUR141222103","","SU","39","0.00","5100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5100.00","0","","","2022-12-14","2022-12-21","0.00","0.00","","LE_2","","0","1","2022-12-14 12:21:53");
INSERT INTO tbl_purchase VALUES("334","PUR141222104","","SU","39","0.00","3492.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3492.00","0","","","2022-12-14","2022-12-21","0.00","0.00","","LE_2","","0","1","2022-12-14 12:38:47");
INSERT INTO tbl_purchase VALUES("335","PUR151222101","","SU","39","0.00","765.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","765.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:35:01");
INSERT INTO tbl_purchase VALUES("336","PUR151222102","","SU","39","0.00","170.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","170.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:35:28");
INSERT INTO tbl_purchase VALUES("337","PUR151222103","","SU","39","0.00","765.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","765.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:36:22");
INSERT INTO tbl_purchase VALUES("338","PUR151222104","","SU","39","0.00","510.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","510.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:36:48");
INSERT INTO tbl_purchase VALUES("339","PUR151222105","","SU","39","0.00","2520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2520.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:40:07");
INSERT INTO tbl_purchase VALUES("340","PUR151222106","","SU","39","0.00","1650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1650.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:41:24");
INSERT INTO tbl_purchase VALUES("341","PUR151222107","","SU","39","0.00","240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","240.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2023-01-12 10:13:25");
INSERT INTO tbl_purchase VALUES("342","PUR151222108","","SU","39","0.00","1755.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1755.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:44:44");
INSERT INTO tbl_purchase VALUES("343","PUR151222109","","SU","39","0.00","580.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","580.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:45:09");
INSERT INTO tbl_purchase VALUES("344","PUR151222110","","SU","39","0.00","595.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","595.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:46:03");
INSERT INTO tbl_purchase VALUES("345","PUR151222111","","SU","39","0.00","250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","250.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:47:40");
INSERT INTO tbl_purchase VALUES("346","PUR151222112","","SU","39","0.00","5160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5160.00","0","","","2022-12-15","2022-12-22","0.00","0.00","","LE_2","","0","1","2022-12-15 11:49:37");
INSERT INTO tbl_purchase VALUES("347","PUR161222101","","SU","39","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:24:13");
INSERT INTO tbl_purchase VALUES("348","PUR161222102","","SU","39","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:24:57");
INSERT INTO tbl_purchase VALUES("349","PUR161222103","","SU","39","0.00","4050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4050.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:26:14");
INSERT INTO tbl_purchase VALUES("350","PUR161222104","","SU","39","0.00","3375.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3375.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:26:43");
INSERT INTO tbl_purchase VALUES("351","PUR161222105","","SU","39","0.00","6750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6750.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:27:19");
INSERT INTO tbl_purchase VALUES("352","PUR161222106","","SU","39","0.00","6750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6750.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:27:40");
INSERT INTO tbl_purchase VALUES("353","PUR161222107","","SU","39","0.00","9000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:28:49");
INSERT INTO tbl_purchase VALUES("354","PUR161222108","","SU","39","0.00","9000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:29:23");
INSERT INTO tbl_purchase VALUES("355","PUR161222109","","SU","39","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:29:54");
INSERT INTO tbl_purchase VALUES("356","PUR161222110","","SU","39","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:30:17");
INSERT INTO tbl_purchase VALUES("357","PUR161222111","","SU","39","0.00","4400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4400.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:37:05");
INSERT INTO tbl_purchase VALUES("358","PUR161222112","","SU","39","0.00","63700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63700.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:37:56");
INSERT INTO tbl_purchase VALUES("359","PUR161222113","","SU","39","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-29 06:40:23");
INSERT INTO tbl_purchase VALUES("360","PUR161222114","","SU","39","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-29 06:41:08");
INSERT INTO tbl_purchase VALUES("361","PUR161222115","","SU","39","0.00","8000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:53:33");
INSERT INTO tbl_purchase VALUES("362","PUR161222116","","SU","39","0.00","1980.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1980.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:57:31");
INSERT INTO tbl_purchase VALUES("363","PUR161222117","","SU","39","0.00","1140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1140.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:58:27");
INSERT INTO tbl_purchase VALUES("364","PUR161222118","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 12:59:59");
INSERT INTO tbl_purchase VALUES("365","PUR161222119","","SU","39","0.00","720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","720.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:01:09");
INSERT INTO tbl_purchase VALUES("366","PUR161222120","","SU","39","0.00","200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 01:04:52");
INSERT INTO tbl_purchase VALUES("367","PUR161222121","","SU","39","0.00","200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 01:09:32");
INSERT INTO tbl_purchase VALUES("368","PUR161222122","","SU","39","0.00","960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","960.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 01:10:01");
INSERT INTO tbl_purchase VALUES("369","PUR161222123","","SU","39","0.00","150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 01:15:07");
INSERT INTO tbl_purchase VALUES("370","PUR161222124","","SU","39","0.00","1120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1120.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 01:15:44");
INSERT INTO tbl_purchase VALUES("371","PUR161222125","","SU","39","0.00","1440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1440.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 03:21:53");
INSERT INTO tbl_purchase VALUES("372","PUR161222126","","SU","39","0.00","300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","300.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 03:24:52");
INSERT INTO tbl_purchase VALUES("373","PUR161222127","","SU","39","0.00","950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","950.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 04:59:46");
INSERT INTO tbl_purchase VALUES("374","PUR161222128","","SU","39","0.00","6300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6300.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 04:58:41");
INSERT INTO tbl_purchase VALUES("375","PUR161222129","","SU","39","0.00","6600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6600.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 04:57:35");
INSERT INTO tbl_purchase VALUES("376","PUR161222130","","SU","39","0.00","1710.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1710.80","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 04:54:57");
INSERT INTO tbl_purchase VALUES("377","PUR161222131","","SU","39","0.00","1250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1250.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 04:50:33");
INSERT INTO tbl_purchase VALUES("378","PUR161222132","","SU","39","0.00","4800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4800.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 04:41:06");
INSERT INTO tbl_purchase VALUES("379","PUR161222133","","SU","39","0.00","930.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","930.10","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-18 09:44:10");
INSERT INTO tbl_purchase VALUES("380","PUR161222134","","SU","39","0.00","3300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3300.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:11:03");
INSERT INTO tbl_purchase VALUES("381","PUR161222135","","SU","39","0.00","1020.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1020.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:26:54");
INSERT INTO tbl_purchase VALUES("382","PUR161222136","","SU","39","0.00","544.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","544.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:29:59");
INSERT INTO tbl_purchase VALUES("383","PUR161222137","","SU","39","0.00","180.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:32:27");
INSERT INTO tbl_purchase VALUES("384","PUR161222138","","SU","39","0.00","280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","280.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:34:43");
INSERT INTO tbl_purchase VALUES("385","PUR161222139","","SU","39","0.00","480.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","480.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-17 09:02:53");
INSERT INTO tbl_purchase VALUES("386","PUR161222140","","SU","39","0.00","4650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4650.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 05:45:23");
INSERT INTO tbl_purchase VALUES("387","PUR161222141","","SU","39","0.00","5000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 06:28:23");
INSERT INTO tbl_purchase VALUES("388","PUR161222142","","SU","39","0.00","150000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150000.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 07:00:55");
INSERT INTO tbl_purchase VALUES("389","PUR161222143","","SU","39","0.00","13200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13200.00","0","","","2022-12-16","2022-12-23","0.00","0.00","","LE_2","","0","1","2022-12-16 07:40:27");
INSERT INTO tbl_purchase VALUES("390","PUR171222101","","SU","39","0.00","1340.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1340.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 01:23:05");
INSERT INTO tbl_purchase VALUES("391","PUR171222102","","SU","39","0.00","2142.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2142.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 01:26:54");
INSERT INTO tbl_purchase VALUES("392","PUR171222103","","SU","39","0.00","117.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","117.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 01:27:25");
INSERT INTO tbl_purchase VALUES("393","PUR171222104","","SU","39","0.00","3133.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3133.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 01:29:17");
INSERT INTO tbl_purchase VALUES("394","PUR171222105","","SU","39","0.00","338.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","338.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 01:32:55");
INSERT INTO tbl_purchase VALUES("395","PUR171222106","","SU","39","0.00","600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","600.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 02:28:10");
INSERT INTO tbl_purchase VALUES("396","PUR171222107","","SU","39","0.00","1160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1160.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:14:03");
INSERT INTO tbl_purchase VALUES("397","PUR171222108","","SU","39","0.00","900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","900.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:15:11");
INSERT INTO tbl_purchase VALUES("398","PUR171222109","","SU","39","0.00","200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","200.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:16:02");
INSERT INTO tbl_purchase VALUES("399","PUR171222110","","SU","39","0.00","523.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","523.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:26:37");
INSERT INTO tbl_purchase VALUES("400","PUR171222111","","SU","39","0.00","774.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","774.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 08:53:52");
INSERT INTO tbl_purchase VALUES("401","PUR171222112","","SU","39","0.00","2889.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2889.00","0","","","2022-12-11","2022-12-24","0.00","0.00","","LE_2","","0","1","2023-01-22 08:54:32");
INSERT INTO tbl_purchase VALUES("402","PUR171222113","","SU","39","0.00","435.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","435.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:31:16");
INSERT INTO tbl_purchase VALUES("403","PUR171222114","","SU","39","0.00","165.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:33:24");
INSERT INTO tbl_purchase VALUES("404","PUR171222115","","SU","39","0.00","197.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:34:15");
INSERT INTO tbl_purchase VALUES("406","PUR171222117","","SU","39","0.00","443.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","443.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:40:05");
INSERT INTO tbl_purchase VALUES("407","PUR171222118","","SU","39","0.00","383.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","383.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:41:01");
INSERT INTO tbl_purchase VALUES("408","PUR171222119","","SU","39","0.00","829.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","829.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:42:15");
INSERT INTO tbl_purchase VALUES("409","PUR171222120","","SU","39","0.00","523.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","523.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 04:43:26");
INSERT INTO tbl_purchase VALUES("411","PUR171222121","","SU","39","0.00","212897.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","212897.20","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 06:10:07");
INSERT INTO tbl_purchase VALUES("412","PUR171222122","","SU","39","0.00","150225.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150225.80","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-19 09:46:34");
INSERT INTO tbl_purchase VALUES("413","PUR171222123","","SU","39","0.00","107295.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107295.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2023-01-05 07:25:10");
INSERT INTO tbl_purchase VALUES("414","PUR171222124","","SU","39","0.00","19440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19440.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 06:30:36");
INSERT INTO tbl_purchase VALUES("415","PUR171222125","","SU","39","0.00","9180.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9180.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 06:31:16");
INSERT INTO tbl_purchase VALUES("416","PUR171222126","","SU","39","0.00","1550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1550.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 08:16:16");
INSERT INTO tbl_purchase VALUES("417","PUR171222127","","SU","39","0.00","975.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","975.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 08:30:44");
INSERT INTO tbl_purchase VALUES("418","PUR171222128","","SU","39","0.00","6400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6400.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 08:23:23");
INSERT INTO tbl_purchase VALUES("419","PUR171222129","","SU","39","0.00","30.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 08:51:12");
INSERT INTO tbl_purchase VALUES("420","PUR171222130","","SU","39","0.00","1840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1840.00","0","","","2022-12-17","2022-12-24","0.00","0.00","","LE_2","","0","1","2022-12-17 09:18:38");
INSERT INTO tbl_purchase VALUES("422","PUR181222101","","SU","39","0.00","45646.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45646.00","0","","","2022-12-18","2022-12-25","0.00","0.00","","LE_2","","0","1","2022-12-19 12:23:55");
INSERT INTO tbl_purchase VALUES("423","PUR181222102","","SU","39","0.00","22644.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22644.00","0","","","2022-12-18","2022-12-25","0.00","0.00","","LE_2","","0","1","2022-12-19 12:20:49");
INSERT INTO tbl_purchase VALUES("424","PUR181222103","","SU","39","0.00","16016.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16016.00","0","","","2022-12-18","2022-12-25","0.00","0.00","","LE_2","","0","1","2022-12-19 12:22:25");
INSERT INTO tbl_purchase VALUES("425","PUR181222104","","SU","39","0.00","850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","850.00","0","","","2022-12-18","2022-12-25","0.00","0.00","","LE_2","","0","1","2022-12-18 05:57:28");
INSERT INTO tbl_purchase VALUES("426","PUR181222105","","SU","39","0.00","850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","850.00","0","","","2022-12-18","2022-12-25","0.00","0.00","","LE_2","","0","1","2022-12-18 05:57:47");
INSERT INTO tbl_purchase VALUES("429","PUR191222101","","SU","39","0.00","160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","160.00","0","","","2022-12-19","2022-12-26","0.00","0.00","","LE_2","","0","1","2022-12-19 08:20:51");
INSERT INTO tbl_purchase VALUES("430","PUR191222102","","SU","39","0.00","10797.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10797.00","0","","","2022-12-19","2022-12-26","0.00","0.00","","LE_2","","0","1","2022-12-19 08:42:16");
INSERT INTO tbl_purchase VALUES("431","PUR201222101","","SU","39","0.00","61183.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","61183.00","0","","","2022-12-20","2022-12-27","0.00","0.00","","LE_2","","0","1","2022-12-20 12:49:05");
INSERT INTO tbl_purchase VALUES("432","PUR201222102","","SU","39","0.00","9612.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9612.00","0","","","2022-12-20","2022-12-27","0.00","0.00","","LE_2","","0","1","2022-12-20 06:27:45");
INSERT INTO tbl_purchase VALUES("433","PUR201222103","","SU","39","0.00","18361.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18361.00","0","","","2022-12-20","2022-12-27","0.00","0.00","","LE_2","","0","1","2022-12-20 08:03:42");
INSERT INTO tbl_purchase VALUES("434","PUR201222104","","SU","39","0.00","2000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2000.00","0","","","2022-12-20","2022-12-27","0.00","0.00","","LE_2","","0","1","2022-12-20 10:05:22");
INSERT INTO tbl_purchase VALUES("435","PUR211222101","","SU","39","0.00","17880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17880.00","0","","","2022-12-21","2022-12-28","0.00","0.00","","LE_2","","0","1","2022-12-22 04:00:01");
INSERT INTO tbl_purchase VALUES("436","PUR211222102","","SU","39","0.00","2850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2850.00","0","","","2022-12-21","2022-12-28","0.00","0.00","","LE_2","","0","1","2022-12-21 03:46:15");
INSERT INTO tbl_purchase VALUES("441","PUR221222102","","SU","39","0.00","600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","600.00","0","","","2022-12-22","2022-12-29","0.00","0.00","","LE_2","","0","1","2022-12-22 01:30:28");
INSERT INTO tbl_purchase VALUES("442","PUR221222103","","SU","39","0.00","27486.46","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27486.46","0","","","2022-12-22","2022-12-29","0.00","0.00","","LE_2","","0","1","2022-12-22 03:38:04");
INSERT INTO tbl_purchase VALUES("443","PUR221222104","","SU","39","0.00","18500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18500.00","0","","","2022-12-22","2022-12-29","0.00","0.00","","LE_2","","0","1","2022-12-22 03:40:59");
INSERT INTO tbl_purchase VALUES("444","PUR221222105","","SU","39","0.00","690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","690.00","0","","","2022-12-22","2022-12-29","0.00","0.00","","LE_2","","0","1","2022-12-22 03:58:52");
INSERT INTO tbl_purchase VALUES("446","PUR221222106","","SU","37","0.00","9720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9720.00","0","","","2022-12-22","2022-12-29","0.00","0.00","","LE_2","","0","1","2022-12-22 10:24:22");
INSERT INTO tbl_purchase VALUES("447","PUR231222101","","SU","40","0.00","15309.50","0.06","9.19","9.19","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15300.31","0","","","2022-12-23","2022-12-30","0.00","0.00","","LE_2","","0","1","2022-12-23 10:03:30");
INSERT INTO tbl_purchase VALUES("449","PUR241222101","","SU","13","0.00","115650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115650.00","0","","","2022-12-24","2022-12-31","0.00","0.00","","LE_2","","0","1","2022-12-24 04:54:02");
INSERT INTO tbl_purchase VALUES("451","PUR241222102","","SU","39","0.00","13797.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13797.00","0","","","2022-12-24","2022-12-31","0.00","0.00","","LE_2","","0","1","2022-12-24 07:24:46");
INSERT INTO tbl_purchase VALUES("452","PUR251222101","","SU","39","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2022-12-25","2023-01-01","0.00","0.00","","LE_2","","0","1","2022-12-25 11:52:37");
INSERT INTO tbl_purchase VALUES("453","PUR251222102","","SU","39","0.00","35990.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35990.00","0","","","2022-12-25","2023-01-01","0.00","0.00","","LE_2","","0","1","2022-12-25 05:23:21");
INSERT INTO tbl_purchase VALUES("454","PUR261222101","","SU","40","0.00","9162.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9162.00","0","","","2022-12-26","2023-01-02","0.00","0.00","","LE_2","","0","1","2022-12-26 10:04:48");
INSERT INTO tbl_purchase VALUES("455","PUR261222102","","SU","40","0.00","12595.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12595.00","0","","","2022-12-26","2023-01-02","0.00","0.00","","LE_2","","0","1","2022-12-26 10:04:24");
INSERT INTO tbl_purchase VALUES("456","PUR271222101","","SU","39","0.00","3216.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3216.00","0","","","2022-12-27","2023-01-03","0.00","0.00","","LE_2","","0","1","2022-12-27 06:48:22");
INSERT INTO tbl_purchase VALUES("458","PUR281222101","","SU","39","0.00","160.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","160.00","0","","","2022-12-28","2023-01-04","0.00","0.00","","LE_2","","0","1","2022-12-28 02:02:44");
INSERT INTO tbl_purchase VALUES("459","PUR281222102","","SU","39","0.00","13877.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13877.50","0","","","2022-12-28","2023-01-04","0.00","0.00","","LE_2","","0","1","2022-12-28 02:09:19");
INSERT INTO tbl_purchase VALUES("461","PUR301222101","","SU","42","0.00","2109.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","9.00","0.00","2100.00","0","","","2022-12-30","","2100.00","0.00","","LE_2","","0","1","2022-12-30 06:30:28");
INSERT INTO tbl_purchase VALUES("462","PUR301222102","","SU","40","0.00","15076.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","76.50","0.00","15000.00","0","","","2022-12-30","2023-01-06","0.00","0.00","","LE_2","","0","1","2022-12-30 10:16:48");
INSERT INTO tbl_purchase VALUES("463","PUR010123101","","SU","39","0.00","50400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50400.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 01:21:10");
INSERT INTO tbl_purchase VALUES("464","PUR010123102","","SU","39","0.00","98280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","98280.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 01:42:56");
INSERT INTO tbl_purchase VALUES("465","PUR010123103","","SU","39","0.00","163080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","163080.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 02:36:02");
INSERT INTO tbl_purchase VALUES("466","PUR010123104","","SU","39","0.00","28080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28080.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 02:49:34");
INSERT INTO tbl_purchase VALUES("467","PUR010123105","","SU","39","0.00","41440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41440.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:38:40");
INSERT INTO tbl_purchase VALUES("468","PUR010123106","","SU","39","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 03:28:01");
INSERT INTO tbl_purchase VALUES("469","PUR010123107","","SU","39","0.00","48830.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48830.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:39:24");
INSERT INTO tbl_purchase VALUES("470","PUR010123108","","SU","39","0.00","134520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134520.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:40:07");
INSERT INTO tbl_purchase VALUES("471","PUR010123109","","SU","39","0.00","16660.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16660.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:40:35");
INSERT INTO tbl_purchase VALUES("472","PUR010123110","","SU","39","0.00","51300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51300.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:40:54");
INSERT INTO tbl_purchase VALUES("473","PUR010123111","","SU","39","0.00","5100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5100.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:41:11");
INSERT INTO tbl_purchase VALUES("474","PUR010123112","","SU","39","0.00","2560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2560.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:41:26");
INSERT INTO tbl_purchase VALUES("475","PUR010123113","","SU","39","0.00","2760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2760.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:41:41");
INSERT INTO tbl_purchase VALUES("476","PUR010123114","","SU","39","0.00","1425.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1425.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:41:59");
INSERT INTO tbl_purchase VALUES("477","PUR010123115","","SU","39","0.00","6500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6500.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:42:21");
INSERT INTO tbl_purchase VALUES("478","PUR010123116","","SU","39","0.00","11880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11880.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:42:40");
INSERT INTO tbl_purchase VALUES("479","PUR010123117","","SU","39","0.00","110200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110200.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:43:07");
INSERT INTO tbl_purchase VALUES("480","PUR010123118","","SU","39","0.00","263190.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","263190.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:43:35");
INSERT INTO tbl_purchase VALUES("481","PUR010123119","","SU","39","0.00","108000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108000.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:44:00");
INSERT INTO tbl_purchase VALUES("482","PUR010123120","","SU","39","0.00","121800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","121800.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:44:39");
INSERT INTO tbl_purchase VALUES("483","PUR010123121","","SU","39","0.00","42750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42750.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:44:53");
INSERT INTO tbl_purchase VALUES("484","PUR010123122","","SU","39","0.00","7800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7800.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 09:45:21");
INSERT INTO tbl_purchase VALUES("485","PUR010123123","","SU","39","0.00","35200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35200.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 10:09:31");
INSERT INTO tbl_purchase VALUES("486","PUR010123124","","SU","39","0.00","1400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1400.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-01 10:10:23");
INSERT INTO tbl_purchase VALUES("487","PUR020123101","","SU","39","0.00","676.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","676.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 12:02:50");
INSERT INTO tbl_purchase VALUES("488","PUR020123102","","SU","39","0.00","591.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","591.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 12:05:16");
INSERT INTO tbl_purchase VALUES("489","PUR020123103","","SU","39","0.00","1474.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1474.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 12:11:14");
INSERT INTO tbl_purchase VALUES("491","PUR020123104","","SU","39","0.00","760.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","760.00","0","","","2023-01-01","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 08:26:23");
INSERT INTO tbl_purchase VALUES("492","PUR020123105","","SU","39","0.00","6732.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6732.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 05:29:27");
INSERT INTO tbl_purchase VALUES("493","PUR020123106","","SU","39","0.00","1560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1560.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 05:53:29");
INSERT INTO tbl_purchase VALUES("494","PUR020123107","","SU","39","0.00","315.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","315.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 05:54:06");
INSERT INTO tbl_purchase VALUES("495","PUR020123108","","SU","39","0.00","7600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7600.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 06:03:48");
INSERT INTO tbl_purchase VALUES("496","PUR020123109","","SU","8","0.00","94500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","4500.00","0.00","90000.00","0","","","2023-01-02","2023-01-09","0.00","0.00","","LE_2","","0","1","2023-01-02 07:34:38");
INSERT INTO tbl_purchase VALUES("497","PUR030123101","","SU","39","0.00","8700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8700.00","0","","","2023-01-01","2023-01-10","0.00","0.00","","LE_2","","0","1","2023-01-03 11:22:58");
INSERT INTO tbl_purchase VALUES("498","PUR030123102","","SU","39","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-03 11:25:02");
INSERT INTO tbl_purchase VALUES("499","PUR030123103","","SU","39","0.00","3800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3800.00","0","","","2023-01-01","2023-01-10","0.00","0.00","","LE_2","","0","1","2023-01-03 01:05:10");
INSERT INTO tbl_purchase VALUES("500","PUR040123101","","SU","39","0.00","3272.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","12.50","0.00","3260.00","0","","","2023-01-04","","3260.00","0.00","","LE_2","","0","1","2023-01-04 05:01:32");
INSERT INTO tbl_purchase VALUES("501","PUR040123102","","SU","39","0.00","2250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2250.00","0","","","2023-01-01","2023-01-11","0.00","0.00","","LE_2","","0","1","2023-01-04 08:02:43");
INSERT INTO tbl_purchase VALUES("502","PUR040123103","","SU","39","0.00","2080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2080.00","0","","","2023-01-04","2023-01-01","0.00","0.00","","LE_2","","0","1","2023-01-04 09:28:21");
INSERT INTO tbl_purchase VALUES("503","PUR040123104","","SU","39","0.00","2340.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2340.00","0","","","2023-01-01","2023-01-11","0.00","0.00","","LE_2","","0","1","2023-01-04 09:32:30");
INSERT INTO tbl_purchase VALUES("504","PUR040123105","","SU","39","0.00","2080.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2080.00","0","","","2023-01-01","2023-01-11","0.00","0.00","","LE_2","","0","1","2023-01-04 09:34:17");
INSERT INTO tbl_purchase VALUES("505","PUR040123106","","SU","40","0.00","14250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14250.00","0","","","2023-01-03","2023-01-11","0.00","0.00","","LE_2","","0","1","2023-01-04 09:52:14");
INSERT INTO tbl_purchase VALUES("506","PUR040123107","","SU","40","0.00","8076.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8076.50","0","","","2023-01-01","2023-01-11","0.00","0.00","","LE_2","","0","1","2023-01-04 10:06:40");
INSERT INTO tbl_purchase VALUES("507","PUR040123108","","SU","39","0.00","5434.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5434.00","0","","","2023-01-01","2023-01-11","0.00","0.00","","LE_2","","0","1","2023-01-04 10:11:43");
INSERT INTO tbl_purchase VALUES("508","PUR050123101","","SU","42","0.00","8610.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8610.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 11:34:19");
INSERT INTO tbl_purchase VALUES("509","PUR050123102","","SU","39","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2023-01-01","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 06:15:55");
INSERT INTO tbl_purchase VALUES("513","PUR050123105","","SU","13","0.00","38550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38550.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 07:56:02");
INSERT INTO tbl_purchase VALUES("514","PUR050123106","","SU","13","0.00","59000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59000.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 07:57:22");
INSERT INTO tbl_purchase VALUES("515","PUR050123107","","SU","13","0.00","38550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38550.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 07:58:34");
INSERT INTO tbl_purchase VALUES("517","PUR050123109","","SU","39","0.00","1892.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1892.00","0","","","2023-01-01","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 08:00:33");
INSERT INTO tbl_purchase VALUES("518","PUR050123110","","SU","39","0.00","46342.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46342.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-05 08:23:58");
INSERT INTO tbl_purchase VALUES("519","PUR050123111","","SU","39","0.00","525.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","525.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 08:09:43");
INSERT INTO tbl_purchase VALUES("520","PUR050123112","","SU","39","0.00","1560.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1560.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 08:10:30");
INSERT INTO tbl_purchase VALUES("521","PUR050123113","","SU","39","0.00","1900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1900.00","0","","","2023-01-05","2023-01-12","0.00","0.00","","LE_2","","0","1","2023-01-05 08:10:54");
INSERT INTO tbl_purchase VALUES("522","PUR060123101","","SU","39","0.00","9880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9880.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 01:23:25");
INSERT INTO tbl_purchase VALUES("523","PUR060123102","","SU","39","0.00","7301.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7301.50","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 04:54:56");
INSERT INTO tbl_purchase VALUES("526","PUR060123103","","SU","44","0.00","25200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25200.00","0","","","2023-01-05","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 06:12:59");
INSERT INTO tbl_purchase VALUES("527","PUR060123104","","SU","44","0.00","21100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21100.00","0","","","2023-01-05","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 06:17:04");
INSERT INTO tbl_purchase VALUES("528","PUR060123105","","SU","39","0.00","10203.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10203.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 06:44:02");
INSERT INTO tbl_purchase VALUES("529","PUR060123106","","SU","39","0.00","11508.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11508.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 06:48:33");
INSERT INTO tbl_purchase VALUES("530","PUR060123107","","SU","39","0.00","103840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103840.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:17:31");
INSERT INTO tbl_purchase VALUES("531","PUR060123108","","SU","39","0.00","15808.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15808.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:22:37");
INSERT INTO tbl_purchase VALUES("532","PUR060123109","","SU","39","0.00","165825.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","165825.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:26:49");
INSERT INTO tbl_purchase VALUES("533","PUR060123110","","SU","39","0.00","19440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19440.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:35:45");
INSERT INTO tbl_purchase VALUES("534","PUR060123111","","SU","40","0.00","6735.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6735.50","0","","","2023-01-05","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:38:03");
INSERT INTO tbl_purchase VALUES("535","PUR060123112","","SU","40","0.00","4480.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4480.50","0","","","2023-01-05","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:38:28");
INSERT INTO tbl_purchase VALUES("536","PUR060123113","","SU","39","0.00","14000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14000.00","0","","","2023-01-01","2023-01-13","0.00","0.00","","LE_2","","0","1","2023-01-06 07:47:13");
INSERT INTO tbl_purchase VALUES("537","PUR070123101","","SU","39","0.00","10350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10350.00","0","","","2023-01-01","2023-01-14","0.00","0.00","","LE_2","","0","1","2023-01-07 12:16:35");
INSERT INTO tbl_purchase VALUES("538","PUR070123102","","SU","39","0.00","8800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8800.00","0","","","2023-01-01","2023-01-14","0.00","0.00","","LE_2","","0","1","2023-01-07 09:48:02");
INSERT INTO tbl_purchase VALUES("539","PUR070123103","","SU","39","0.00","19950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19950.00","0","","","2023-01-01","2023-01-14","0.00","0.00","","LE_2","","0","1","2023-01-07 09:50:15");
INSERT INTO tbl_purchase VALUES("540","PUR080123101","","SU","39","0.00","9500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9500.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 01:51:57");
INSERT INTO tbl_purchase VALUES("541","PUR080123102","","SU","39","0.00","5000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5000.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 01:57:09");
INSERT INTO tbl_purchase VALUES("542","PUR080123103","","SU","40","0.00","10795.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10795.00","0","","","2023-01-08","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:14:12");
INSERT INTO tbl_purchase VALUES("543","PUR080123104","","SU","39","0.00","3450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3450.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:31:19");
INSERT INTO tbl_purchase VALUES("544","PUR080123105","","SU","39","0.00","4200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4200.00","0","","","2023-01-01","2023-01-08","0.00","0.00","","LE_2","","0","1","2023-01-22 08:22:21");
INSERT INTO tbl_purchase VALUES("545","PUR080123106","","SU","39","0.00","21600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21600.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:34:13");
INSERT INTO tbl_purchase VALUES("546","PUR080123107","","SU","39","0.00","9600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9600.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:35:06");
INSERT INTO tbl_purchase VALUES("547","PUR080123108","","SU","39","0.00","3700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3700.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:38:03");
INSERT INTO tbl_purchase VALUES("548","PUR080123109","","SU","39","0.00","2450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2450.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:41:46");
INSERT INTO tbl_purchase VALUES("549","PUR080123110","","SU","39","0.00","3800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3800.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:49:49");
INSERT INTO tbl_purchase VALUES("550","PUR080123111","","SU","39","0.00","1850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1850.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 05:51:10");
INSERT INTO tbl_purchase VALUES("551","PUR080123112","","SU","39","0.00","1200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1200.00","0","","","2023-01-01","2023-01-15","0.00","0.00","","LE_2","","0","1","2023-01-08 07:34:19");
INSERT INTO tbl_purchase VALUES("552","PUR090123101","","SU","39","0.00","1000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1000.00","0","","","2023-01-01","2023-01-16","0.00","0.00","","LE_2","","0","1","2023-01-09 11:26:55");
INSERT INTO tbl_purchase VALUES("553","PUR090123102","","SU","39","0.00","595.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","595.00","0","","","2023-01-01","2023-01-16","0.00","0.00","","LE_2","","0","1","2023-01-09 12:10:43");
INSERT INTO tbl_purchase VALUES("554","PUR090123103","","SU","39","0.00","880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","880.00","0","","","2023-01-01","2023-01-16","0.00","0.00","","LE_2","","0","1","2023-01-09 12:14:56");
INSERT INTO tbl_purchase VALUES("556","PUR090123104","","SU","40","0.00","8816.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8816.00","0","","","2023-01-09","2023-01-16","0.00","0.00","","LE_2","","0","1","2023-01-09 10:24:47");
INSERT INTO tbl_purchase VALUES("557","PUR090123105","","SU","40","0.00","4949.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4949.50","0","","","2023-01-09","2023-01-16","0.00","0.00","","LE_2","","0","1","2023-01-09 10:25:09");
INSERT INTO tbl_purchase VALUES("558","PUR100123101","","SU","39","0.00","5700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5700.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 01:38:46");
INSERT INTO tbl_purchase VALUES("559","PUR100123102","","SU","39","0.00","86950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86950.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-11 01:32:28");
INSERT INTO tbl_purchase VALUES("560","PUR100123103","","SU","39","0.00","1470.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1470.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 03:49:43");
INSERT INTO tbl_purchase VALUES("561","PUR100123104","","SU","39","0.00","980.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","980.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 03:50:08");
INSERT INTO tbl_purchase VALUES("562","PUR100123105","","SU","39","0.00","2340.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2340.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 03:52:20");
INSERT INTO tbl_purchase VALUES("563","PUR100123106","","SU","39","0.00","7600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7600.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 04:06:15");
INSERT INTO tbl_purchase VALUES("564","PUR100123107","","SU","2","0.00","5500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5500.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 04:21:03");
INSERT INTO tbl_purchase VALUES("565","PUR100123108","","SU","2","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2023-01-10","2023-01-17","0.00","0.00","","LE_2","","0","1","2023-01-10 04:42:25");
INSERT INTO tbl_purchase VALUES("566","PUR110123101","","SU","46","0.00","948.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","948.00","0","","","2023-01-11","2023-01-18","0.00","0.00","","LE_2","","0","1","2023-01-11 01:36:30");
INSERT INTO tbl_purchase VALUES("567","PUR110123102","","SU","39","0.00","1730.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1730.00","0","","","2023-01-11","2023-01-18","0.00","0.00","","LE_2","","0","1","2023-01-11 09:27:18");
INSERT INTO tbl_purchase VALUES("568","PUR110123103","","SU","39","0.00","3800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3800.00","0","","","2023-01-11","2023-01-18","0.00","0.00","","LE_2","","0","1","2023-01-11 09:31:34");
INSERT INTO tbl_purchase VALUES("569","PUR110123104","","SU","39","0.00","2402.85","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2402.85","0","","","2023-01-11","2023-01-18","0.00","0.00","","LE_2","","0","1","2023-01-11 09:39:50");
INSERT INTO tbl_purchase VALUES("570","PUR120123101","","SU","40","0.00","12350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12350.00","0","","","2023-01-12","2023-01-19","0.00","0.00","","LE_2","","0","1","2023-01-12 07:20:00");
INSERT INTO tbl_purchase VALUES("571","PUR120123102","","SU","43","0.00","127000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","18186.00","0.00","108814.00","0","","","2023-01-12","2023-01-19","0.00","0.00","","LE_2","","0","1","2023-01-12 09:07:03");
INSERT INTO tbl_purchase VALUES("572","PUR120123103","","SU","39","0.00","6242.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6242.20","0","","","2023-01-12","2023-01-19","0.00","0.00","","LE_2","","0","1","2023-01-12 08:41:30");
INSERT INTO tbl_purchase VALUES("573","PUR140123101","","SU","39","0.00","6081.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6081.50","0","","","2023-01-14","2023-01-21","0.00","0.00","","LE_2","","0","1","2023-01-14 02:29:07");
INSERT INTO tbl_purchase VALUES("574","PUR140123102","","SU","47","0.00","1020.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","170.00","0.00","850.00","0","","","2023-01-14","2023-01-21","0.00","0.00","","LE_2","","0","1","2023-01-14 02:30:23");
INSERT INTO tbl_purchase VALUES("575","PUR140123103","","SU","48","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2023-01-14","2023-01-21","0.00","0.00","","LE_2","","0","1","2023-01-14 02:38:02");
INSERT INTO tbl_purchase VALUES("576","PUR150123101","","SU","37","0.00","9720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9720.00","0","","","2023-01-15","2023-01-22","0.00","0.00","","LE_2","","0","1","2023-01-15 05:40:43");
INSERT INTO tbl_purchase VALUES("577","PUR170123101","","SU","49","0.00","29014.65","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","14.65","0.00","29000.00","0","","","2023-01-17","2023-01-24","0.00","0.00","","LE_2","","0","1","2023-01-17 11:50:02");
INSERT INTO tbl_purchase VALUES("578","PUR180123101","","SU","2","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-01-18","2023-01-25","13500.00","0.00","","LE_2","","0","1","2023-01-19 12:12:35");
INSERT INTO tbl_purchase VALUES("579","PUR180123102","","SU","2","0.00","23000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23000.00","0","","","2023-01-18","","23000.00","0.00","","LE_2","","0","1","2023-01-19 12:12:00");
INSERT INTO tbl_purchase VALUES("581","PUR180123103","","SU","2","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2023-01-18","","25000.00","0.00","","LE_2","","0","1","2023-01-19 12:11:27");
INSERT INTO tbl_purchase VALUES("582","PUR180123104","","SU","2","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2023-01-17","","33000.00","0.00","","LE_2","","0","1","2023-01-19 12:10:53");
INSERT INTO tbl_purchase VALUES("583","PUR180123105","","SU","50","0.00","6910.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6910.00","0","","","2023-01-17","2023-01-24","5200.00","0.00","","LE_2","","0","1","2023-01-22 02:00:44");
INSERT INTO tbl_purchase VALUES("584","PUR190123101","","SU","39","0.00","3350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3350.00","0","","","2023-01-01","2023-01-26","0.00","0.00","","LE_2","","0","1","2023-01-19 11:49:47");
INSERT INTO tbl_purchase VALUES("585","PUR190123102","","SU","40","0.00","15599.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15599.00","0","","","2023-01-18","","15599.00","0.00","","LE_2","","0","1","2023-01-19 07:57:31");
INSERT INTO tbl_purchase VALUES("586","PUR190123103","","SU","40","0.00","10108.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10108.00","0","","","2023-01-18","","10108.00","0.00","","LE_2","","0","1","2023-01-19 07:50:31");
INSERT INTO tbl_purchase VALUES("587","PUR200123101","","SU","9","0.00","10750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10750.00","0","","","2023-01-20","2023-01-27","0.00","0.00","","LE_2","","0","1","2023-01-20 06:16:12");
INSERT INTO tbl_purchase VALUES("588","PUR200123102","","SU","6","0.00","40350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40350.00","0","","","2023-01-19","","40350.00","0.00","","LE_2","","0","1","2023-01-20 07:55:28");
INSERT INTO tbl_purchase VALUES("589","PUR200123103","","SU","40","0.00","4189.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4189.50","0","","","2023-01-20","2023-01-27","0.00","0.00","","LE_2","","0","1","2023-01-20 07:27:34");
INSERT INTO tbl_purchase VALUES("590","PUR200123104","","SU","40","0.00","8540.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8540.50","0","","","2023-01-20","2023-01-27","0.00","0.00","","LE_2","","0","1","2023-01-20 07:33:30");
INSERT INTO tbl_purchase VALUES("593","PUR210123101","","SU","39","0.00","700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","700.00","0","","","2023-01-01","2023-01-28","0.00","0.00","","LE_2","","0","1","2023-01-21 12:29:25");
INSERT INTO tbl_purchase VALUES("594","PUR210123102","","SU","40","0.00","11010.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11010.50","0","","","2023-01-20","2023-01-27","0.00","0.00","","LE_2","","0","1","2023-01-21 06:46:05");
INSERT INTO tbl_purchase VALUES("595","PUR220123101","","SU","16","0.00","37911.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","411.50","0.00","37500.00","0","","","2023-01-22","2023-01-29","25000.00","0.00","","LE_2","","0","1","2023-01-22 10:07:39");
INSERT INTO tbl_purchase VALUES("596","PUR230123101","","SU","39","0.00","2900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2900.00","0","","","2023-01-01","2023-01-30","0.00","0.00","","LE_2","","0","1","2023-01-23 12:47:21");
INSERT INTO tbl_purchase VALUES("597","PUR230123102","","SU","39","0.00","1995.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1995.00","0","","","2023-01-01","2023-01-30","0.00","0.00","","LE_2","","0","1","2023-01-23 01:01:57");
INSERT INTO tbl_purchase VALUES("598","PUR240123101","","SU","39","0.00","4900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4900.00","0","","","2023-01-01","2023-01-31","0.00","0.00","","LE_2","","0","1","2023-01-24 12:14:12");
INSERT INTO tbl_purchase VALUES("600","PUR240123103","","SU","51","0.00","3906.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","6.00","0.00","3900.00","0","","","2023-01-24","2023-01-31","0.00","0.00","","LE_2","","0","1","2023-01-25 11:55:06");
INSERT INTO tbl_purchase VALUES("601","PUR250123101","","SU","50","0.00","12280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12280.00","0","","","2023-01-25","2023-02-01","0.00","0.00","","LE_2","","0","1","2023-01-25 07:54:00");
INSERT INTO tbl_purchase VALUES("602","PUR250123102","","SU","40","0.00","9144.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9144.00","0","","","2023-01-25","2023-02-01","0.00","0.00","","LE_2","","0","1","2023-01-25 08:04:56");
INSERT INTO tbl_purchase VALUES("603","PUR250123103","","SU","19","0.00","90000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90000.00","0","","","2023-01-25","2023-02-01","0.00","0.00","","LE_2","","0","1","2023-01-25 08:01:35");
INSERT INTO tbl_purchase VALUES("604","PUR260123101","","SU","39","0.00","576.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","576.00","0","","","2023-01-01","2023-02-02","0.00","0.00","","LE_2","","0","1","2023-01-26 06:06:27");
INSERT INTO tbl_purchase VALUES("605","PUR260123102","","SU","39","0.00","564.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","564.00","0","","","2023-01-01","2023-02-02","0.00","0.00","","LE_2","","0","1","2023-01-26 06:07:38");
INSERT INTO tbl_purchase VALUES("606","PUR260123103","","SU","11","0.00","45750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45750.00","0","","","2023-01-26","2023-02-02","0.00","0.00","","LE_2","","0","1","2023-01-26 07:59:29");
INSERT INTO tbl_purchase VALUES("607","PUR290123101","","SU","53","0.00","8514.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","14.00","0.00","8500.00","0","","","2023-01-29","","8500.00","0.00","","LE_2","","0","1","2023-01-29 02:12:45");
INSERT INTO tbl_purchase VALUES("608","PUR290123102","","SU","54","0.00","5373.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5373.00","0","","","2023-01-29","2023-02-05","0.00","0.00","","LE_2","","0","1","2023-01-29 05:29:44");
INSERT INTO tbl_purchase VALUES("609","PUR290123103","","SU","52","0.00","4769.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4769.00","0","","","2023-01-29","2023-02-05","0.00","0.00","","LE_2","","0","1","2023-01-29 07:31:19");
INSERT INTO tbl_purchase VALUES("610","PUR300123101","","SU","39","0.00","10000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10000.00","0","","","2023-01-01","2023-02-06","0.00","0.00","","LE_2","","0","1","2023-01-30 08:07:25");
INSERT INTO tbl_purchase VALUES("611","PUR300123102","","SU","40","0.00","18412.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","245.50","0.00","18167.00","0","","","2023-01-30","2023-02-06","0.00","0.00","","LE_2","","0","1","2023-02-02 09:34:59");
INSERT INTO tbl_purchase VALUES("613","PUR310123101","","SU","12","0.00","37200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37200.00","0","","","2023-01-31","2023-02-07","0.00","0.00","","LE_2","","0","1","2023-01-31 05:19:55");
INSERT INTO tbl_purchase VALUES("614","PUR020223101","","SU","40","0.00","14833.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14833.00","0","","","2023-02-02","2023-02-09","0.00","0.00","","LE_2","","0","1","2023-02-02 06:46:55");
INSERT INTO tbl_purchase VALUES("615","PUR030223101","","SU","39","0.00","1472.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1472.50","0","","","2023-01-01","2023-02-08","0.00","0.00","","LE_2","","0","1","2023-02-03 07:59:54");
INSERT INTO tbl_purchase VALUES("616","PUR050223101","","SU","39","0.00","19.44","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19.44","0","","","2023-01-01","2023-02-12","0.00","0.00","","LE_2","","0","1","2023-02-05 09:13:38");
INSERT INTO tbl_purchase VALUES("617","PUR060223101","","SU","54","0.00","12600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12600.00","0","","","2023-02-06","2023-02-13","0.00","0.00","","LE_2","","0","1","2023-02-06 05:47:04");
INSERT INTO tbl_purchase VALUES("618","PUR060223102","","SU","40","0.00","13400.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13400.50","0","","","2023-02-06","2023-02-13","0.00","0.00","","LE_2","","0","1","2023-02-06 06:30:40");
INSERT INTO tbl_purchase VALUES("619","PUR060223103","","SU","51","0.00","5472.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","2.00","0.00","5470.00","0","","","2023-02-06","2023-02-13","0.00","0.00","","LE_2","","0","1","2023-02-06 08:06:31");
INSERT INTO tbl_purchase VALUES("620","PUR070223101","","SU","39","0.00","17.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17.00","0","","","2023-01-01","2023-02-14","0.00","0.00","","LE_2","","0","1","2023-02-07 02:07:34");
INSERT INTO tbl_purchase VALUES("621","PUR070223102","","SU","19","0.00","180000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180000.00","0","","","2023-02-07","2023-02-14","0.00","0.00","","LE_2","","0","1","2023-02-07 03:42:16");
INSERT INTO tbl_purchase VALUES("622","PUR070223103","","SU","39","0.00","1493.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1493.00","0","","","2023-01-01","2023-02-14","0.00","0.00","","LE_2","","0","1","2023-02-07 07:22:21");
INSERT INTO tbl_purchase VALUES("623","PUR080223101","","SU","2","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2023-02-08","2023-02-15","0.00","0.00","","LE_2","","0","1","2023-02-08 01:24:58");
INSERT INTO tbl_purchase VALUES("624","PUR080223102","","SU","39","0.00","12552.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12552.00","0","","","2023-01-01","2023-02-15","0.00","0.00","","LE_2","","0","1","2023-02-08 05:13:42");
INSERT INTO tbl_purchase VALUES("625","PUR090223101","","SU","56","0.00","3500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3500.00","0","","","2023-02-09","","3500.00","0.00","","LE_2","","0","1","2023-02-09 07:32:22");
INSERT INTO tbl_purchase VALUES("626","PUR100223101","","SU","40","0.00","8661.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","61.50","0.00","8600.00","0","","","2023-02-10","2023-02-17","0.00","0.00","","LE_2","","0","1","2023-02-10 07:43:08");
INSERT INTO tbl_purchase VALUES("627","PUR100223102","","SU","39","0.00","1285.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1285.00","0","","","2023-01-01","2023-02-17","0.00","0.00","","LE_2","","0","1","2023-02-10 08:17:23");
INSERT INTO tbl_purchase VALUES("628","PUR110223101","","SU","39","0.00","7500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7500.00","0","","","2023-01-01","2023-02-18","0.00","0.00","","LE_2","","0","1","2023-02-11 04:21:45");
INSERT INTO tbl_purchase VALUES("629","PUR110223102","","SU","39","0.00","600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","600.00","0","","","2023-01-01","2023-02-18","0.00","0.00","","LE_2","","0","1","2023-02-11 04:42:43");
INSERT INTO tbl_purchase VALUES("630","PUR110223103","","SU","50","0.00","3500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3500.00","0","","","2023-02-11","2023-02-18","0.00","0.00","","LE_2","","0","1","2023-02-11 05:54:16");
INSERT INTO tbl_purchase VALUES("631","PUR120223101","","SU","39","0.00","600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","600.00","0","","","2023-01-01","2023-02-19","0.00","0.00","","LE_2","","0","1","2023-02-12 02:20:45");
INSERT INTO tbl_purchase VALUES("632","PUR120223102","","SU","16","0.00","15518.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","18.40","0.00","15500.00","0","","","2023-02-12","2023-02-19","0.00","0.00","","LE_2","","0","1","2023-02-12 10:38:25");
INSERT INTO tbl_purchase VALUES("633","PUR140223101","","SU","54","0.00","9500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9500.00","0","","","2023-02-14","2023-02-21","0.00","0.00","","LE_2","","0","1","2023-02-14 05:08:50");
INSERT INTO tbl_purchase VALUES("635","PUR150223102","","SU","4","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2023-02-15","2023-02-22","0.00","0.00","","LE_2","","0","1","2023-02-15 06:17:13");
INSERT INTO tbl_purchase VALUES("636","PUR150223103","","SU","4","0.00","30600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30600.00","0","","","2023-02-15","2023-02-22","0.00","0.00","","LE_2","","0","1","2023-02-15 06:40:13");
INSERT INTO tbl_purchase VALUES("637","PUR150223104","","SU","4","0.00","118800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","118800.00","0","","","2023-02-15","","118800.00","0.00","","LE_2","","0","1","2023-02-15 07:29:27");
INSERT INTO tbl_purchase VALUES("638","PUR150223105","","SU","40","0.00","14535.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14535.00","0","","","2023-02-15","2023-02-22","0.00","0.00","","LE_2","","0","1","2023-02-15 07:46:09");
INSERT INTO tbl_purchase VALUES("639","PUR150223106","","SU","4","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2023-02-15","2023-02-22","0.00","0.00","","LE_2","","0","1","2023-02-15 09:16:47");
INSERT INTO tbl_purchase VALUES("640","PUR160223101","","SU","26","0.00","38231.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38231.00","0","","","2023-02-16","","38231.00","0.00","","LE_2","","0","1","2023-02-16 07:16:36");
INSERT INTO tbl_purchase VALUES("641","PUR160223102","","SU","18","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2023-02-16","","33000.00","0.00","","LE_2","","0","1","2023-02-16 08:01:33");
INSERT INTO tbl_purchase VALUES("642","PUR160223103","","SU","5","0.00","31450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31450.00","0","","","2023-02-16","","31450.00","0.00","","BA_1","CHK_ONLINE_2023-02-15","0","1","2023-02-17 05:01:28");
INSERT INTO tbl_purchase VALUES("643","PUR170223101","","SU","10","0.00","107000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107000.00","0","","ONLINE","2023-02-17","","107000.00","0.00","1","BA_1","CHK_ONLINE_2023-02-15","0","1","2023-02-17 05:11:17");
INSERT INTO tbl_purchase VALUES("644","PUR170223102","","SU","10","0.00","36000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36000.00","0","","","2023-02-17","","36000.00","0.00","","BA_1","CHK_NULL_NULL","0","1","2023-02-17 02:24:21");
INSERT INTO tbl_purchase VALUES("645","PUR170223103","","SU","26","0.00","4280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4280.00","0","","ONLINE","2023-02-17","","4280.00","0.00","","BA_1","CHK_ONLINE_2023-02-17","0","1","2023-02-17 04:57:12");
INSERT INTO tbl_purchase VALUES("646","PUR170223104","","SU","4","0.00","103000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103000.00","0","","","2023-02-17","2023-02-24","0.00","0.00","","LE_2","","0","1","2023-02-17 11:14:28");
INSERT INTO tbl_purchase VALUES("647","PUR190223101","","SU","7","0.00","104270.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104270.00","0","","","2023-02-19","","104270.00","0.00","","LE_2","","0","1","2023-02-19 12:44:35");
INSERT INTO tbl_purchase VALUES("648","PUR190223102","","SU","7","0.00","19400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19400.00","0","","","2023-02-19","2023-02-26","16730.00","0.00","","LE_2","","0","1","2023-02-19 01:02:04");
INSERT INTO tbl_purchase VALUES("649","PUR190223103","","SU","43","0.00","12629.28","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12629.28","0","","","2023-02-19","2023-02-26","0.00","0.00","","LE_2","","0","1","2023-02-19 10:06:16");
INSERT INTO tbl_purchase VALUES("650","PUR200223101","","SU","40","0.00","16482.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16482.50","0","","","2023-02-20","2023-02-27","0.00","0.00","","LE_2","","0","1","2023-02-20 11:36:58");
INSERT INTO tbl_purchase VALUES("651","PUR210223101","","SU","5","0.00","55000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55000.00","0","","","2023-02-21","","55000.00","0.00","","LE_2","","0","1","2023-02-21 05:43:24");
INSERT INTO tbl_purchase VALUES("652","PUR210223102","","SU","56","0.00","965.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","965.50","0","","","2023-02-21","","965.50","0.00","","LE_2","","0","1","2023-02-21 06:40:53");
INSERT INTO tbl_purchase VALUES("653","PUR210223103","","SU","19","0.00","79950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","79950.00","0","","","2023-02-21","","79950.00","0.00","","LE_2","","0","1","2023-02-21 09:43:24");
INSERT INTO tbl_purchase VALUES("654","PUR220223101","","SU","40","0.00","14574.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14574.50","0","","","2023-02-22","2023-03-01","0.00","0.00","","LE_2","","0","1","2023-02-22 07:07:45");
INSERT INTO tbl_purchase VALUES("655","PUR230223101","","SU","51","0.00","1665.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1665.00","0","","","2023-02-23","","1665.00","0.00","","LE_2","","0","1","2023-02-23 03:39:44");
INSERT INTO tbl_purchase VALUES("656","PUR230223102","","SU","1","0.00","37000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37000.00","0","","","2023-02-23","","37000.00","0.00","","LE_2","","0","1","2023-02-23 04:34:59");
INSERT INTO tbl_purchase VALUES("657","PUR250223101","","SU","43","0.00","2130.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2130.00","0","","","2023-02-25","2023-03-04","0.00","0.00","","LE_2","","0","1","2023-02-25 09:23:46");
INSERT INTO tbl_purchase VALUES("658","PUR250223102","","SU","19","0.00","90720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90720.00","0","","PARAMOUNT","2023-02-25","","90720.00","0.00","","LE_2","","0","1","2023-02-25 10:13:02");
INSERT INTO tbl_purchase VALUES("659","PUR260223101","","SU","38","0.00","36600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36600.00","0","","","2023-02-26","","36600.00","0.00","","LE_2","","0","1","2023-02-26 04:52:55");
INSERT INTO tbl_purchase VALUES("660","PUR260223102","","SU","51","0.00","5432.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5432.00","0","","","2023-02-26","2023-03-05","0.00","0.00","","LE_2","","0","1","2023-02-26 05:01:38");
INSERT INTO tbl_purchase VALUES("661","PUR260223103","","SU","2","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2023-02-26","2023-03-05","0.00","0.00","","LE_2","","0","1","2023-02-26 07:38:29");
INSERT INTO tbl_purchase VALUES("662","PUR270223101","","SU","43","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2023-02-27","","1500.00","0.00","","LE_2","","0","1","2023-02-27 10:13:35");
INSERT INTO tbl_purchase VALUES("663","PUR270223102","","SU","40","0.00","10540.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10540.00","0","","","2023-02-27","","10540.00","0.00","","LE_2","","0","1","2023-02-27 10:15:07");
INSERT INTO tbl_purchase VALUES("664","PUR280223101","","SU","40","0.00","12389.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12389.00","0","","","2023-02-28","2023-03-07","0.00","0.00","","LE_2","","0","1","2023-02-28 05:12:05");
INSERT INTO tbl_purchase VALUES("665","PUR280223102","","SU","51","0.00","1404.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","4.00","0.00","1400.00","0","","","2023-02-28","","1400.00","0.00","","LE_2","","0","1","2023-02-28 05:22:15");
INSERT INTO tbl_purchase VALUES("667","PUR010323102","","SU","39","0.00","1200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1200.00","0","","","2023-03-01","","1200.00","0.00","","LE_2","","0","1","2023-03-01 08:46:58");
INSERT INTO tbl_purchase VALUES("668","PUR040323101","","SU","9","0.00","24100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24100.00","0","","","2023-03-04","","24100.00","0.00","","LE_2","","0","1","2023-03-04 11:14:35");
INSERT INTO tbl_purchase VALUES("669","PUR040323102","","SU","9","0.00","4500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4500.00","0","","","2023-03-04","","4500.00","0.00","","LE_2","","0","1","2023-03-04 11:26:16");
INSERT INTO tbl_purchase VALUES("670","PUR040323103","","SU","40","0.00","3312.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3312.00","0","","","2023-03-04","","3312.00","0.00","","LE_2","","0","1","2023-03-04 11:36:47");
INSERT INTO tbl_purchase VALUES("671","PUR050323101","","SU","12","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2023-03-05","","60000.00","0.00","","LE_2","","0","1","2023-03-05 01:58:20");
INSERT INTO tbl_purchase VALUES("672","PUR060323101","","SU","12","0.00","115000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115000.00","0","","","2023-03-06","","115000.00","0.00","","LE_2","","0","1","2023-03-06 05:13:59");
INSERT INTO tbl_purchase VALUES("673","PUR060323102","","SU","13","0.00","74490.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","74490.00","0","","","2023-03-06","","74490.00","0.00","","LE_2","","0","1","2023-03-06 08:29:25");
INSERT INTO tbl_purchase VALUES("674","PUR060323103","","SU","10","0.00","34400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34400.00","0","","","2023-03-06","","34400.00","0.00","","LE_2","","0","1","2023-03-07 04:38:04");
INSERT INTO tbl_purchase VALUES("675","PUR070323101","","SU","2","0.00","92000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92000.00","0","","","2023-03-07","","92000.00","0.00","","LE_2","","0","1","2023-03-07 06:04:11");
INSERT INTO tbl_purchase VALUES("676","PUR070323102","","SU","39","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2023-03-07","","1500.00","0.00","","LE_2","","0","1","2023-03-07 07:37:15");
INSERT INTO tbl_purchase VALUES("677","PUR090323101","","SU","40","0.00","21087.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21087.50","0","","","2023-03-09","2023-03-16","0.00","0.00","","LE_2","","0","1","2023-03-09 08:49:02");
INSERT INTO tbl_purchase VALUES("678","PUR100323101","","SU","13","0.00","143520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","143520.00","0","","","2023-03-10","","143520.00","0.00","","LE_2","","0","1","2023-03-10 09:08:42");
INSERT INTO tbl_purchase VALUES("679","PUR130323101","","SU","40","0.00","14383.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14383.00","0","","","2023-03-13","2023-03-20","0.00","0.00","","LE_2","","0","1","2023-03-13 05:10:55");
INSERT INTO tbl_purchase VALUES("680","PUR130323102","","SU","40","0.00","3125.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3125.50","0","","","2023-03-13","2023-03-20","0.00","0.00","","LE_2","","0","1","2023-03-13 05:10:35");
INSERT INTO tbl_purchase VALUES("681","PUR130323103","","SU","5","0.00","18400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18400.00","0","","","2023-03-13","","18400.00","0.00","","LE_2","","0","1","2023-03-13 05:33:18");
INSERT INTO tbl_purchase VALUES("682","PUR130323104","","SU","3","0.00","26580.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26580.00","0","","","2023-03-13","","26580.00","0.00","","LE_2","","0","1","2023-03-13 07:32:56");
INSERT INTO tbl_purchase VALUES("683","PUR140323101","","SU","19","0.00","120000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120000.00","0","","","2023-03-14","","120000.00","0.00","","LE_2","","0","1","2023-03-14 09:46:50");
INSERT INTO tbl_purchase VALUES("684","PUR160323101","","SU","10","0.00","56800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56800.00","0","","","2023-03-16","","56800.00","0.00","","LE_2","","0","1","2023-03-16 05:29:58");
INSERT INTO tbl_purchase VALUES("685","PUR160323102","","SU","10","0.00","5000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5000.00","0","","","2023-03-16","","5000.00","0.00","","LE_2","","0","1","2023-03-16 05:28:44");
INSERT INTO tbl_purchase VALUES("686","PUR160323103","","SU","40","0.00","14449.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14449.00","0","","","2023-03-16","2023-03-23","0.00","0.00","","LE_2","","0","1","2023-03-16 09:34:41");
INSERT INTO tbl_purchase VALUES("687","PUR170323101","","SU","43","0.00","5275.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5275.00","0","","","2023-03-17","2023-03-24","0.00","0.00","","LE_2","","0","1","2023-03-17 06:37:00");
INSERT INTO tbl_purchase VALUES("688","PUR180323101","","SU","49","0.00","19520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19520.00","0","","","2023-03-18","","19520.00","0.00","","LE_2","","0","1","2023-03-18 07:20:29");
INSERT INTO tbl_purchase VALUES("689","PUR180323102","","SU","38","0.00","32400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32400.00","0","","","2023-03-18","","32400.00","0.00","","LE_2","","0","1","2023-03-18 08:50:56");
INSERT INTO tbl_purchase VALUES("690","PUR180323103","","SU","51","0.00","15165.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15165.00","0","","","2023-03-18","2023-03-25","0.00","0.00","","LE_2","","0","1","2023-03-18 09:09:06");
INSERT INTO tbl_purchase VALUES("691","PUR180323104","","SU","6","0.00","43500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43500.00","0","","","2023-03-18","","43500.00","0.00","","LE_2","","0","1","2023-03-18 09:33:15");
INSERT INTO tbl_purchase VALUES("692","PUR200323101","","SU","40","0.00","7828.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7828.00","0","","","2023-03-20","","7828.00","0.00","","LE_2","","0","1","2023-03-20 06:56:56");
INSERT INTO tbl_purchase VALUES("694","PUR220323101","","SU","6","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-03-22","","26000.00","0.00","","LE_2","","0","1","2023-03-22 04:14:37");
INSERT INTO tbl_purchase VALUES("695","PUR220323102","","SU","39","0.00","4970.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4970.00","0","","","2023-03-22","","4970.00","0.00","","LE_2","","0","1","2023-03-22 07:06:50");
INSERT INTO tbl_purchase VALUES("696","PUR220323103","","SU","13","0.00","12140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12140.00","0","","","2023-03-22","","12140.00","0.00","","LE_2","","0","1","2023-03-22 09:17:58");
INSERT INTO tbl_purchase VALUES("697","PUR220323104","","SU","13","0.00","64440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64440.00","0","","","2023-03-22","","64440.00","0.00","","LE_2","","0","1","2023-03-22 09:49:06");
INSERT INTO tbl_purchase VALUES("698","PUR220323105","","SU","2","0.00","21500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21500.00","0","","","2023-03-22","","21500.00","0.00","","LE_2","","0","1","2023-03-22 10:01:24");
INSERT INTO tbl_purchase VALUES("699","PUR230323101","","SU","8","0.00","3800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3800.00","0","","","2023-03-23","","3800.00","0.00","","LE_2","","0","1","2023-03-23 05:46:19");
INSERT INTO tbl_purchase VALUES("700","PUR230323102","","SU","13","0.00","4620.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4620.00","0","","","2023-03-23","","4620.00","0.00","","LE_2","","0","1","2023-03-23 05:57:33");
INSERT INTO tbl_purchase VALUES("701","PUR230323103","","SU","13","0.00","34800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34800.00","0","","","2023-03-23","2023-03-30","9380.00","0.00","","LE_2","","0","1","2023-03-23 06:06:01");
INSERT INTO tbl_purchase VALUES("702","PUR230323104","","SU","39","0.00","750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","750.00","0","","","2023-03-23","","750.00","0.00","","LE_2","","0","1","2023-03-23 07:37:56");
INSERT INTO tbl_purchase VALUES("703","PUR250323101","","SU","39","0.00","13630.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13630.00","0","","","2023-03-24","","13630.00","0.00","","LE_2","","0","1","2023-03-25 03:58:45");
INSERT INTO tbl_purchase VALUES("704","PUR270323101","","SU","40","0.00","10678.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10678.00","0","","","2023-03-27","2023-04-03","0.00","0.00","","LE_2","","0","1","2023-03-27 12:33:07");
INSERT INTO tbl_purchase VALUES("705","PUR280323101","","SU","40","0.00","3876.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3876.00","0","","","2023-03-27","2023-04-04","0.00","0.00","","LE_2","","0","1","2023-03-28 11:17:20");
INSERT INTO tbl_purchase VALUES("706","PUR280323102","","SU","40","0.00","15791.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15791.50","0","","","2023-03-27","2023-04-04","0.00","0.00","","LE_2","","0","1","2023-03-28 11:19:01");
INSERT INTO tbl_purchase VALUES("707","PUR280323103","","SU","59","0.00","84000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84000.00","0","","","2023-03-28","","84000.00","0.00","","LE_2","","0","1","2023-03-28 09:55:27");
INSERT INTO tbl_purchase VALUES("708","PUR280323104","","SU","6","0.00","37100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37100.00","0","","","2023-03-28","2023-04-04","37000.00","0.00","","LE_2","","0","1","2023-03-28 10:08:56");
INSERT INTO tbl_purchase VALUES("709","PUR290323101","","SU","7","0.00","38250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38250.00","0","","","2023-03-29","","38250.00","0.00","","LE_2","","0","1","2023-03-29 02:13:46");
INSERT INTO tbl_purchase VALUES("710","PUR290323102","","SU","5","0.00","39600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39600.00","0","","","2023-03-29","2023-04-05","0.00","0.00","","LE_2","","0","1","2023-03-29 08:14:49");
INSERT INTO tbl_purchase VALUES("711","PUR290323103","","SU","40","0.00","11968.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11968.50","0","","","2023-03-28","2023-04-05","0.00","0.00","","LE_2","","0","1","2023-03-29 08:17:58");
INSERT INTO tbl_purchase VALUES("712","PUR300323101","","SU","43","0.00","1566.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1566.00","0","","","2023-03-30","2023-04-06","0.00","0.00","","LE_2","","0","1","2023-03-30 05:05:00");
INSERT INTO tbl_purchase VALUES("713","PUR300323102","","SU","40","0.00","13870.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13870.00","0","","","2023-03-30","2023-04-06","0.00","0.00","","LE_2","","0","1","2023-03-30 05:58:08");
INSERT INTO tbl_purchase VALUES("714","PUR010423101","","SU","39","0.00","6849.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6849.00","0","","","2023-04-01","","6849.00","0.00","","LE_2","","0","1","2023-04-01 08:37:49");
INSERT INTO tbl_purchase VALUES("715","PUR020423101","","SU","4","0.00","6400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6400.00","0","","","2023-04-02","2023-04-09","0.00","0.00","","LE_2","","0","1","2023-04-02 04:05:14");
INSERT INTO tbl_purchase VALUES("716","PUR020423102","","SU","4","0.00","185600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","185600.00","0","","","2023-04-02","2023-04-09","68000.00","0.00","","LE_2","","0","1","2023-04-02 04:36:24");
INSERT INTO tbl_purchase VALUES("717","PUR020423103","","SU","40","0.00","14473.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14473.50","0","","","2023-04-02","2023-04-09","0.00","0.00","","LE_2","","0","1","2023-04-02 06:34:41");
INSERT INTO tbl_purchase VALUES("718","PUR020423104","","SU","39","0.00","2700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2700.00","0","","","2023-04-02","","2700.00","0.00","","LE_2","","0","1","2023-04-02 06:35:46");
INSERT INTO tbl_purchase VALUES("719","PUR020423105","","SU","10","0.00","53100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","53100.00","0","","","2023-04-02","2023-04-09","0.00","0.00","","LE_2","","0","1","2023-04-02 07:04:17");
INSERT INTO tbl_purchase VALUES("720","PUR020423106","","SU","39","0.00","26040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26040.00","0","","","2023-04-02","","26040.00","0.00","","LE_2","","0","1","2023-04-02 08:01:40");
INSERT INTO tbl_purchase VALUES("721","PUR030423101","","SU","37","0.00","29425.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29425.00","0","","","2023-04-02","2023-04-10","0.00","0.00","","LE_2","","0","1","2023-04-03 11:28:19");
INSERT INTO tbl_purchase VALUES("722","PUR030423102","","SU","12","0.00","6400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6400.00","0","","","2023-04-03","2023-04-10","0.00","0.00","","LE_2","","0","1","2023-04-03 01:51:20");
INSERT INTO tbl_purchase VALUES("723","PUR030423103","","SU","12","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2023-04-03","","30000.00","0.00","","LE_2","","0","1","2023-04-03 03:11:30");
INSERT INTO tbl_purchase VALUES("724","PUR030423104","","SU","12","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2023-04-03","","30000.00","0.00","","LE_2","","0","1","2023-04-03 03:10:51");
INSERT INTO tbl_purchase VALUES("725","PUR030423105","","SU","6","0.00","59500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59500.00","0","","","2023-04-03","","59500.00","0.00","","LE_2","","0","1","2023-04-03 04:06:13");
INSERT INTO tbl_purchase VALUES("726","PUR050423101","","SU","51","0.00","9130.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9130.00","0","","","2023-04-05","2023-04-12","0.00","0.00","","LE_2","","0","1","2023-04-05 07:41:21");
INSERT INTO tbl_purchase VALUES("727","PUR050423102","","SU","59","0.00","91800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91800.00","0","","","2023-04-05","","91800.00","0.00","","LE_2","","0","1","2023-04-05 05:36:34");
INSERT INTO tbl_purchase VALUES("728","PUR060423101","","SU","7","0.00","10150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10150.00","0","","","2023-04-06","2023-04-13","0.00","0.00","","LE_2","","0","1","2023-04-06 04:29:57");
INSERT INTO tbl_purchase VALUES("729","PUR060423102","","SU","4","0.00","110000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110000.00","0","","","2023-04-06","2023-04-13","0.00","0.00","","LE_2","","0","1","2023-04-06 09:11:22");
INSERT INTO tbl_purchase VALUES("730","PUR080423101","","SU","51","0.00","8780.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8780.00","0","","","2023-04-08","","8780.00","0.00","","LE_2","","0","1","2023-04-08 05:57:25");
INSERT INTO tbl_purchase VALUES("731","PUR090423101","","SU","39","0.00","1928.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1928.50","0","","","2023-04-09","2023-04-16","0.00","0.00","","LE_2","","0","1","2023-04-09 04:46:13");
INSERT INTO tbl_purchase VALUES("732","PUR090423102","","SU","43","0.00","26330.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26330.00","0","","","2023-04-09","2023-04-16","0.00","0.00","","LE_2","","0","1","2023-04-09 04:55:51");
INSERT INTO tbl_purchase VALUES("733","PUR090423103","","SU","10","0.00","135000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","135000.00","0","","","2023-04-09","2023-04-16","0.00","0.00","","LE_2","","0","1","2023-04-09 05:19:44");
INSERT INTO tbl_purchase VALUES("734","PUR100423101","","SU","51","0.00","2441.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2441.50","0","","","2023-04-10","2023-04-17","0.00","0.00","","LE_2","","0","1","2023-04-10 02:19:17");
INSERT INTO tbl_purchase VALUES("735","PUR100423102","","SU","2","0.00","72000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72000.00","0","","","2023-04-10","","72000.00","0.00","","LE_2","","0","1","2023-04-10 04:59:51");
INSERT INTO tbl_purchase VALUES("736","PUR100423103","","SU","58","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2023-04-10","","50000.00","0.00","","LE_2","","0","1","2023-04-10 10:08:49");
INSERT INTO tbl_purchase VALUES("737","PUR100423104","","SU","5","0.00","108730.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108730.00","0","","","2023-04-10","","120000.00","11270.00","","LE_2","","0","1","2023-04-10 10:08:18");
INSERT INTO tbl_purchase VALUES("738","PUR100423105","","SU","56","0.00","4746.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4746.00","0","","","2023-04-10","","4746.00","0.00","","LE_2","","0","1","2023-04-10 10:54:38");
INSERT INTO tbl_purchase VALUES("739","PUR110423101","","SU","40","0.00","18942.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18942.00","0","","","2023-04-11","","18942.00","0.00","","LE_2","","0","1","2023-04-11 04:36:20");
INSERT INTO tbl_purchase VALUES("740","PUR110423102","","SU","37","0.00","21724.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21724.80","0","","","2023-04-11","","21724.80","0.00","","LE_2","","0","1","2023-04-11 09:39:32");
INSERT INTO tbl_purchase VALUES("741","PUR130423101","","SU","38","0.00","107970.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107970.00","0","","","2023-04-13","","107970.00","0.00","","LE_2","","0","1","2023-04-13 01:11:13");
INSERT INTO tbl_purchase VALUES("742","PUR130423102","","SU","5","0.00","1150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1150.00","0","","","2023-04-13","","1150.00","0.00","","LE_2","","0","1","2023-04-13 04:31:01");
INSERT INTO tbl_purchase VALUES("743","PUR130423103","","SU","40","0.00","12172.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12172.00","0","","","2023-04-13","","12172.00","0.00","","LE_2","","0","1","2023-04-13 11:43:30");
INSERT INTO tbl_purchase VALUES("744","PUR140423101","","SU","43","0.00","1853.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1853.00","0","","","2023-04-14","","1853.00","0.00","","LE_2","","0","1","2023-04-14 10:20:37");
INSERT INTO tbl_purchase VALUES("745","PUR150423101","","SU","38","0.00","2150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2150.00","0","","","2023-04-15","","2150.00","0.00","","LE_2","","0","1","2023-04-15 09:51:56");
INSERT INTO tbl_purchase VALUES("746","PUR170423101","","SU","40","0.00","14693.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14693.50","0","","","2023-04-17","2023-04-24","0.00","0.00","","LE_2","","0","1","2023-04-17 08:33:16");
INSERT INTO tbl_purchase VALUES("747","PUR180423101","","SU","19","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2023-04-18","","45000.00","0.00","","LE_2","","0","1","2023-04-18 10:43:41");
INSERT INTO tbl_purchase VALUES("748","PUR190423101","","SU","39","0.00","130.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130.00","0","","","2023-04-19","","130.00","0.00","","LE_2","","0","1","2023-04-19 09:40:44");
INSERT INTO tbl_purchase VALUES("749","PUR190423102","","SU","49","0.00","12598.15","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12598.15","0","","","2023-04-19","2023-04-26","12598.15","0.00","","LE_2","","0","1","2023-04-19 10:23:54");
INSERT INTO tbl_purchase VALUES("750","PUR210423101","","SU","40","0.00","16460.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16460.00","0","","","2023-04-21","2023-04-28","0.00","0.00","","LE_2","","0","1","2023-04-21 02:11:51");
INSERT INTO tbl_purchase VALUES("751","PUR260423101","","SU","55","0.00","5100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5100.00","0","","","2023-04-26","2023-05-03","0.00","0.00","","LE_2","","0","1","2023-04-26 04:18:12");
INSERT INTO tbl_purchase VALUES("752","PUR280423101","","SU","39","0.00","600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","600.00","0","","","2023-04-28","","600.00","0.00","","LE_2","","0","1","2023-04-28 04:56:19");
INSERT INTO tbl_purchase VALUES("753","PUR290423101","","SU","43","0.00","2614.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2614.00","0","","","2023-04-29","2023-05-06","0.00","0.00","","LE_2","","0","1","2023-04-29 06:46:44");
INSERT INTO tbl_purchase VALUES("754","PUR290423102","","SU","39","0.00","1100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1100.00","0","","","2023-04-29","","1100.00","0.00","","LE_2","","0","1","2023-04-29 07:03:08");
INSERT INTO tbl_purchase VALUES("755","PUR300423101","","SU","37","0.00","10862.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10862.00","0","","","2023-04-14","2023-05-07","0.00","0.00","","LE_2","","0","1","2023-04-30 02:27:43");
INSERT INTO tbl_purchase VALUES("756","PUR020523101","","SU","40","0.00","11080.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11080.50","0","","","2023-05-02","2023-05-09","0.00","0.00","","LE_2","","0","1","2023-05-02 01:00:54");
INSERT INTO tbl_purchase VALUES("757","PUR030523101","","SU","39","0.00","8977.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8977.50","0","","","2023-05-03","2023-05-10","0.00","0.00","","LE_2","","0","1","2023-05-03 02:26:32");
INSERT INTO tbl_purchase VALUES("758","PUR030523102","","SU","30","0.00","3170.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.40","0.00","3170.00","0","","","2023-05-03","","3170.00","0.00","","LE_2","","0","1","2023-05-03 06:44:40");
INSERT INTO tbl_purchase VALUES("759","PUR030523103","","SU","39","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2023-05-03","","1500.00","0.00","","LE_2","","0","1","2023-05-03 06:42:41");
INSERT INTO tbl_purchase VALUES("760","PUR040523101","","SU","4","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-05-04","2023-05-11","0.00","0.00","","LE_2","","0","1","2023-05-04 05:55:54");
INSERT INTO tbl_purchase VALUES("761","PUR040523102","","SU","4","0.00","299000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","299000.00","0","","","2023-05-04","2023-05-11","0.00","0.00","","LE_2","","0","1","2023-05-04 07:06:18");
INSERT INTO tbl_purchase VALUES("762","PUR040523103","","SU","60","0.00","10290.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10290.00","0","","","2023-05-04","2023-05-11","10000.00","0.00","","LE_2","","0","1","2023-05-04 07:17:02");
INSERT INTO tbl_purchase VALUES("763","PUR040523104","","SU","40","0.00","12129.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12129.00","0","","","2023-05-04","2023-05-11","0.00","0.00","","LE_2","","0","1","2023-05-04 08:15:52");
INSERT INTO tbl_purchase VALUES("764","PUR050523101","","SU","59","0.00","172800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","172800.00","0","","","2023-05-05","","172800.00","0.00","","LE_2","","0","1","2023-05-05 12:48:05");
INSERT INTO tbl_purchase VALUES("765","PUR060523101","","SU","5","0.00","117079.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","117079.90","0","","","2023-05-06","2023-05-13","0.00","0.00","","LE_2","","0","1","2023-05-06 01:49:07");
INSERT INTO tbl_purchase VALUES("766","PUR060523102","","SU","40","0.00","22980.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22980.00","0","","","2023-05-06","","22980.00","0.00","","LE_2","","0","1","2023-05-06 07:10:25");
INSERT INTO tbl_purchase VALUES("767","PUR070523101","","SU","10","0.00","6600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6600.00","0","","","2023-05-07","2023-05-14","0.00","0.00","","LE_2","","0","1","2023-05-07 04:24:57");
INSERT INTO tbl_purchase VALUES("768","PUR080523101","","SU","10","0.00","47850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47850.00","0","","","2023-05-08","2023-05-15","0.00","0.00","","LE_2","","0","1","2023-05-08 12:41:18");
INSERT INTO tbl_purchase VALUES("769","PUR080523102","","SU","40","0.00","26805.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26805.00","0","","","2023-05-08","2023-05-15","0.00","0.00","","LE_2","","0","1","2023-05-08 06:50:38");
INSERT INTO tbl_purchase VALUES("770","PUR080523103","","SU","60","0.00","6500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","40.00","0.00","6460.00","0","","","2023-05-08","","6460.00","0.00","","LE_2","","0","1","2023-05-08 07:18:43");
INSERT INTO tbl_purchase VALUES("771","PUR080523104","","SU","61","0.00","10020.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","20.00","0.00","10000.00","0","","","2023-05-08","","10000.00","0.00","","LE_2","","0","1","2023-05-08 08:00:49");
INSERT INTO tbl_purchase VALUES("772","PUR080523105","","SU","5","0.00","52500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","52500.00","0","","","2023-05-08","2023-05-15","0.00","0.00","","LE_2","","0","1","2023-05-08 08:04:28");
INSERT INTO tbl_purchase VALUES("773","PUR080523106","","SU","39","0.00","3330.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3330.00","0","","","2023-05-08","","3330.00","0.00","","LE_2","","0","1","2023-05-08 11:23:36");
INSERT INTO tbl_purchase VALUES("774","PUR100523101","","SU","51","0.00","8740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8740.00","0","","","2023-05-10","2023-05-17","0.00","0.00","","LE_2","","0","1","2023-05-10 11:49:45");
INSERT INTO tbl_purchase VALUES("775","PUR100523102","","SU","40","0.00","6327.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6327.00","0","","","2023-05-10","","6327.00","0.00","","LE_2","","0","1","2023-05-10 08:16:03");
INSERT INTO tbl_purchase VALUES("776","PUR100523103","","SU","40","0.00","13753.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13753.00","0","","","2023-05-10","","13753.00","0.00","","LE_2","","0","1","2023-05-10 08:19:45");
INSERT INTO tbl_purchase VALUES("778","PUR130523101","","SU","40","0.00","12940.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12940.00","0","","","2023-05-13","","12940.00","0.00","","LE_2","","0","1","2023-05-13 10:36:34");
INSERT INTO tbl_purchase VALUES("779","PUR160523101","","SU","13","0.00","55658.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55658.00","0","","","2023-05-16","","55658.00","0.00","","LE_2","","0","1","2023-05-16 05:36:37");
INSERT INTO tbl_purchase VALUES("780","PUR160523102","","SU","40","0.00","18905.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18905.00","0","","","2023-05-16","2023-05-23","0.00","0.00","","LE_2","","0","1","2023-05-16 06:29:37");
INSERT INTO tbl_purchase VALUES("781","PUR160523103","","SU","13","0.00","204390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","204390.00","0","","","2023-05-16","","204390.00","0.00","","LE_2","","0","1","2023-05-16 09:17:02");
INSERT INTO tbl_purchase VALUES("782","PUR160523104","","SU","39","0.00","5947.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5947.50","0","","","2023-05-16","","5947.50","0.00","","LE_2","","0","1","2023-05-16 11:51:30");
INSERT INTO tbl_purchase VALUES("783","PUR170523101","","SU","10","0.00","21700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21700.00","0","","","2023-05-17","2023-05-24","0.00","0.00","","LE_2","","0","1","2023-05-17 06:01:05");
INSERT INTO tbl_purchase VALUES("784","PUR170523102","","SU","6","0.00","27100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27100.00","0","","","2023-05-17","","27100.00","0.00","","LE_2","","0","1","2023-05-17 06:24:08");
INSERT INTO tbl_purchase VALUES("785","PUR170523103","","SU","19","0.00","98000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","98000.00","0","","","2023-05-17","","98000.00","0.00","","LE_2","","0","1","2023-05-17 07:09:19");
INSERT INTO tbl_purchase VALUES("786","PUR190523101","","SU","2","0.00","32000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32000.00","0","","","2023-05-19","","32000.00","0.00","","LE_2","","0","1","2023-05-19 06:48:49");
INSERT INTO tbl_purchase VALUES("787","PUR200523101","","SU","40","0.00","12910.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12910.50","0","","","2023-05-20","","12910.50","0.00","","LE_2","","0","1","2023-05-20 07:00:28");
INSERT INTO tbl_purchase VALUES("788","PUR220523101","","SU","2","0.00","25010.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","10.00","0.00","25000.00","0","","","2023-05-22","","25000.00","0.00","","LE_2","","0","1","2023-05-22 02:06:03");
INSERT INTO tbl_purchase VALUES("789","PUR230523101","","SU","39","0.00","1000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1000.00","0","","","2023-05-23","","1000.00","0.00","","LE_2","","0","1","2023-05-23 05:33:16");
INSERT INTO tbl_purchase VALUES("790","PUR250523101","","SU","39","0.00","41400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41400.00","0","","","2023-05-25","","41400.00","0.00","","LE_2","","0","1","2023-05-25 04:27:57");
INSERT INTO tbl_purchase VALUES("791","PUR260523101","","SU","6","0.00","28120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28120.00","0","","","2023-05-26","","28120.00","0.00","","LE_2","","0","1","2023-05-26 09:16:06");
INSERT INTO tbl_purchase VALUES("792","PUR260523102","","SU","45","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2023-05-26","","45000.00","0.00","","LE_2","","0","1","2023-05-26 09:18:11");
INSERT INTO tbl_purchase VALUES("793","PUR280523101","","SU","39","0.00","13000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13000.00","0","","","2023-05-28","","13000.00","0.00","","LE_2","","0","1","2023-05-28 06:17:49");
INSERT INTO tbl_purchase VALUES("794","PUR280523102","","SU","2","0.00","42480.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42480.00","0","","","2023-05-28","","42480.00","0.00","","LE_2","","0","1","2023-05-28 07:01:51");
INSERT INTO tbl_purchase VALUES("795","PUR290523101","","SU","33","0.00","39500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39500.00","0","","","2023-05-29","","39500.00","0.00","","LE_2","","0","1","2023-05-29 09:30:05");
INSERT INTO tbl_purchase VALUES("796","PUR300523101","","SU","51","0.00","4890.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4890.00","0","","","2023-05-30","2023-06-06","0.00","0.00","","LE_2","","0","1","2023-05-30 02:14:53");
INSERT INTO tbl_purchase VALUES("797","PUR310523101","","SU","62","0.00","10950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10950.00","0","","","2023-05-31","2023-06-07","0.00","0.00","","LE_2","","0","1","2023-05-31 10:03:10");
INSERT INTO tbl_purchase VALUES("798","PUR020623101","","SU","2","0.00","71400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","71400.00","0","","","2023-06-02","","71400.00","0.00","","LE_2","","0","1","2023-06-02 06:27:19");
INSERT INTO tbl_purchase VALUES("799","PUR020623102","","SU","10","0.00","26000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26000.00","0","","","2023-06-02","2023-06-09","0.00","0.00","","LE_2","","0","1","2023-06-02 06:34:52");
INSERT INTO tbl_purchase VALUES("800","PUR020623103","","SU","40","0.00","11979.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11979.50","0","","","2023-06-02","2023-06-09","0.00","0.00","","LE_2","","0","1","2023-06-02 06:55:58");
INSERT INTO tbl_purchase VALUES("801","PUR020623104","","SU","5","0.00","51654.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51654.50","0","","","2023-06-02","2023-06-09","0.00","0.00","","LE_2","","0","1","2023-06-02 08:58:07");
INSERT INTO tbl_purchase VALUES("802","PUR040623101","","SU","51","0.00","5676.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5676.00","0","","","2023-06-04","","5676.00","0.00","","LE_2","","0","1","2023-06-04 04:58:43");
INSERT INTO tbl_purchase VALUES("803","PUR040623102","","SU","39","0.00","2540.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2540.00","0","","","2023-06-04","","2540.00","0.00","","LE_2","","0","1","2023-06-04 07:34:23");
INSERT INTO tbl_purchase VALUES("804","PUR060623101","","SU","13","0.00","154440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","154440.00","0","","","2023-06-06","","154440.00","0.00","","LE_2","","0","1","2023-06-06 06:17:41");
INSERT INTO tbl_purchase VALUES("805","PUR070623101","","SU","38","0.00","7600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7600.00","0","","","2023-06-07","2023-06-14","0.00","0.00","","LE_2","","0","1","2023-06-07 03:55:34");
INSERT INTO tbl_purchase VALUES("806","PUR100623101","","SU","39","0.00","5940.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5940.00","0","","","2023-06-10","","5940.00","0.00","","LE_2","","0","1","2023-06-10 08:58:11");
INSERT INTO tbl_purchase VALUES("807","PUR110623101","","SU","19","0.00","191858.44","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","191858.44","0","","","2023-06-11","","191858.44","0.00","","LE_2","","0","1","2023-06-11 07:38:05");
INSERT INTO tbl_purchase VALUES("808","PUR110623102","","SU","39","0.00","6650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","50.00","0.00","6600.00","0","","","2023-06-09","","6600.00","0.00","","LE_2","","0","1","2023-06-11 04:42:21");
INSERT INTO tbl_purchase VALUES("809","PUR110623103","","SU","13","0.00","92040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92040.00","0","","","2023-06-11","","92040.00","0.00","","LE_2","","0","1","2023-06-11 05:42:59");
INSERT INTO tbl_purchase VALUES("810","PUR120623101","","SU","39","0.00","936.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","936.00","0","","","2023-06-12","","936.00","0.00","","LE_2","","0","1","2023-06-12 04:46:04");
INSERT INTO tbl_purchase VALUES("811","PUR120623102","","SU","39","0.00","14500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14500.00","0","","","2023-06-09","","14500.00","0.00","","LE_2","","0","1","2023-06-12 05:30:55");
INSERT INTO tbl_purchase VALUES("812","PUR120623103","","SU","51","0.00","1500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1500.00","0","","","2023-06-12","","1500.00","0.00","","LE_2","","0","1","2023-06-12 08:25:54");
INSERT INTO tbl_purchase VALUES("813","PUR120623104","","SU","39","0.00","9350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9350.00","0","","","2023-06-12","","9350.00","0.00","","LE_2","","0","1","2023-06-12 09:09:35");
INSERT INTO tbl_purchase VALUES("814","PUR140623101","","SU","39","0.00","7842.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7842.00","0","","","2023-06-13","","7842.00","0.00","","LE_2","","0","1","2023-06-14 02:46:40");
INSERT INTO tbl_purchase VALUES("815","PUR140623102","","SU","49","0.00","31750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31750.00","0","","","2023-06-13","2023-06-21","10300.00","0.00","","LE_2","","0","1","2023-06-14 02:59:54");
INSERT INTO tbl_purchase VALUES("816","PUR140623103","","SU","33","0.00","46177.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","27.00","0.00","46150.00","0","","","2023-06-14","","46150.00","0.00","","LE_2","","0","1","2023-06-14 03:06:33");
INSERT INTO tbl_purchase VALUES("817","PUR140623104","","SU","40","0.00","12120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12120.00","0","","","2023-06-14","","12120.00","0.00","","LE_2","","0","1","2023-06-14 07:25:29");
INSERT INTO tbl_purchase VALUES("818","PUR140623105","","SU","39","0.00","3960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3960.00","0","","","2023-06-14","","3960.00","0.00","","LE_2","","0","1","2023-06-14 08:37:00");
INSERT INTO tbl_purchase VALUES("819","PUR150623101","","SU","39","0.00","665.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","665.00","0","","","2023-06-07","","665.00","0.00","","LE_2","","0","1","2023-06-15 02:48:08");
INSERT INTO tbl_purchase VALUES("820","PUR150623102","","SU","51","0.00","4000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4000.00","0","","","2023-06-15","2023-06-22","0.00","0.00","","LE_2","","0","1","2023-06-15 03:03:33");
INSERT INTO tbl_purchase VALUES("821","PUR180623101","","SU","40","0.00","16017.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16017.00","0","","","2023-06-18","2023-06-25","0.00","0.00","","LE_2","","0","1","2023-06-18 04:12:28");
INSERT INTO tbl_purchase VALUES("822","PUR190623101","","SU","39","0.00","21000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21000.00","0","","","2023-06-19","2023-06-26","11600.00","0.00","","LE_2","","0","1","2023-06-19 08:14:01");
INSERT INTO tbl_purchase VALUES("823","PUR190623102","","SU","5","0.00","83724.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","83724.10","0","","","2023-06-19","","83724.10","0.00","","LE_2","","0","1","2023-06-19 08:17:09");
INSERT INTO tbl_purchase VALUES("824","PUR230623101","","SU","40","0.00","7550.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7550.50","0","","","2023-06-22","2023-06-30","0.00","0.00","","LE_2","","0","1","2023-06-23 03:58:43");
INSERT INTO tbl_purchase VALUES("825","PUR230623102","","SU","2","0.00","42800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42800.00","0","","","2023-06-23","","42800.00","0.00","","LE_2","","0","1","2023-06-23 05:35:09");
INSERT INTO tbl_purchase VALUES("826","PUR230623103","","SU","13","0.00","112470.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112470.00","0","","","2023-06-23","","112470.00","0.00","","LE_2","","0","1","2023-06-23 08:29:03");
INSERT INTO tbl_purchase VALUES("827","PUR230623104","","SU","2","0.00","42800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42800.00","0","","","2023-06-23","","42800.00","0.00","","LE_2","","0","1","2023-06-23 08:47:26");
INSERT INTO tbl_purchase VALUES("828","PUR230623105","","SU","2","0.00","128400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128400.00","0","","","2023-06-23","","128400.00","0.00","","LE_2","","0","1","2023-06-23 09:18:52");
INSERT INTO tbl_purchase VALUES("829","PUR230623106","","SU","4","0.00","126000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","126000.00","0","","","2023-06-23","","126000.00","0.00","","LE_2","","0","1","2023-06-23 09:47:42");
INSERT INTO tbl_purchase VALUES("830","PUR240623101","","SU","10","0.00","312500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","312500.00","0","","","2023-06-24","2023-07-01","0.00","0.00","","LE_2","","0","1","2023-06-24 07:22:13");
INSERT INTO tbl_purchase VALUES("831","PUR260623101","","SU","39","0.00","2140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2140.00","0","","","2023-06-26","2023-07-03","0.00","0.00","","LE_2","","0","1","2023-06-26 03:13:37");
INSERT INTO tbl_purchase VALUES("832","PUR270623101","","SU","40","0.00","16515.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16515.00","0","","","2023-06-26","2023-07-04","0.00","0.00","","LE_2","","0","1","2023-06-27 04:52:13");
INSERT INTO tbl_purchase VALUES("833","PUR020723101","","SU","40","0.00","5742.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5742.00","0","","","2023-07-02","","5742.00","0.00","","LE_2","","0","1","2023-07-02 09:11:18");
INSERT INTO tbl_purchase VALUES("834","PUR040723101","","SU","7","0.00","18400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18400.00","0","","","2023-07-04","","18400.00","0.00","","LE_2","","0","1","2023-07-04 08:03:20");
INSERT INTO tbl_purchase VALUES("835","PUR050723101","","SU","40","0.00","19636.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19636.50","0","","","2023-07-05","2023-07-12","0.00","0.00","","LE_2","","0","1","2023-07-05 10:56:07");
INSERT INTO tbl_purchase VALUES("836","PUR100723101","","SU","38","0.00","107970.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","107970.00","0","","","2023-07-10","","107970.00","0.00","","LE_2","","0","1","2023-07-10 04:59:02");
INSERT INTO tbl_purchase VALUES("837","PUR100723102","","SU","6","0.00","43210.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43210.00","0","","","2023-07-10","","43210.00","0.00","","LE_2","","0","1","2023-07-10 05:02:41");
INSERT INTO tbl_purchase VALUES("838","PUR100723103","","SU","4","0.00","56000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56000.00","0","","","2023-07-10","2023-07-17","0.00","0.00","","LE_2","","0","1","2023-07-10 05:20:42");
INSERT INTO tbl_purchase VALUES("839","PUR100723104","","SU","1","0.00","29550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29550.00","0","","","2023-07-10","2023-07-17","0.00","0.00","","LE_2","","0","1","2023-07-10 05:25:09");
INSERT INTO tbl_purchase VALUES("840","PUR120723101","","SU","6","0.00","39200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39200.00","0","","","2023-07-12","","39200.00","0.00","","LE_2","","0","1","2023-07-12 04:50:56");
INSERT INTO tbl_purchase VALUES("841","PUR130723101","","SU","40","0.00","18852.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18852.00","0","","","2023-07-12","","18852.00","0.00","","LE_2","","0","1","2023-07-13 11:16:18");
INSERT INTO tbl_purchase VALUES("842","PUR140723101","","SU","39","0.00","102314.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","14.00","0.00","102300.00","0","","","2023-07-13","","102300.00","0.00","","LE_2","","0","1","2023-07-14 07:15:19");
INSERT INTO tbl_purchase VALUES("843","PUR140723102","","SU","39","0.00","18810.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18810.00","0","","","2023-07-14","","18810.00","0.00","","LE_2","","0","1","2023-07-14 09:02:38");
INSERT INTO tbl_purchase VALUES("844","PUR180723101","","SU","40","0.00","27172.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27172.00","0","","","2023-07-18","","27172.00","0.00","","LE_2","","0","1","2023-07-18 07:07:16");
INSERT INTO tbl_purchase VALUES("845","PUR180723102","","SU","26","0.00","31900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31900.00","0","","","2023-07-18","","31900.00","0.00","","LE_2","","0","1","2023-07-18 08:41:06");
INSERT INTO tbl_purchase VALUES("846","PUR180723103","","SU","26","0.00","197000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","197000.00","0","","","2023-07-18","2023-07-25","31900.00","0.00","","LE_2","","0","1","2023-07-18 08:46:15");
INSERT INTO tbl_purchase VALUES("847","PUR180723104","","SU","39","0.00","10332.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10332.00","0","","","2023-07-18","","10332.00","0.00","","LE_2","","0","1","2023-07-18 08:47:02");
INSERT INTO tbl_purchase VALUES("848","PUR190723101","","SU","62","0.00","68310.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68310.00","0","","","2023-07-19","","68310.00","0.00","","LE_2","","0","1","2023-07-19 06:13:44");
INSERT INTO tbl_purchase VALUES("849","PUR190723102","","SU","39","0.00","68534.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68534.90","0","","","2023-07-19","2023-07-26","68534.90","0.00","","LE_2","","0","1","2023-07-19 06:41:49");
INSERT INTO tbl_purchase VALUES("850","PUR190723103","","SU","19","0.00","192000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","192000.00","0","","","2023-07-19","","192000.00","0.00","","LE_2","","0","1","2023-07-19 07:40:44");
INSERT INTO tbl_purchase VALUES("851","PUR200723101","","SU","43","0.00","12000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12000.00","0","","","2023-07-19","2023-07-27","0.00","0.00","","LE_2","","0","1","2023-07-20 04:41:21");
INSERT INTO tbl_purchase VALUES("852","PUR200723102","","SU","39","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2023-07-20","","27000.00","0.00","","LE_2","","0","1","2023-07-20 08:52:57");
INSERT INTO tbl_purchase VALUES("853","PUR210723101","","SU","2","0.00","106700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106700.00","0","","","2023-07-21","","106700.00","0.00","","LE_2","","0","1","2023-07-21 05:58:58");
INSERT INTO tbl_purchase VALUES("854","PUR220723101","","SU","40","0.00","5000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5000.00","0","","","2023-07-22","","5000.00","0.00","","LE_2","","0","1","2023-07-22 08:50:38");
INSERT INTO tbl_purchase VALUES("855","PUR230723101","","SU","10","0.00","40640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40640.00","0","","","2023-07-23","2023-07-30","0.00","0.00","","LE_2","","0","1","2023-07-23 05:41:04");
INSERT INTO tbl_purchase VALUES("856","PUR230723102","","SU","39","0.00","3240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3240.00","0","","","2023-07-23","","3240.00","0.00","","LE_2","","0","1","2023-07-23 05:42:07");
INSERT INTO tbl_purchase VALUES("857","PUR230723103","","SU","4","0.00","62400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","62400.00","0","","","2023-07-23","","62400.00","0.00","","LE_2","","0","1","2023-07-23 07:49:12");
INSERT INTO tbl_purchase VALUES("858","PUR240723101","","SU","39","0.00","7248.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7248.00","0","","","2023-07-24","","7248.00","0.00","","LE_2","","0","1","2023-07-24 01:41:42");
INSERT INTO tbl_purchase VALUES("859","PUR240723102","","SU","13","0.00","73920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73920.00","0","","","2023-07-24","2023-07-31","0.00","0.00","","LE_2","","0","1","2023-07-24 05:38:06");
INSERT INTO tbl_purchase VALUES("860","PUR290723101","","SU","7","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2023-07-29","","35000.00","0.00","","LE_2","","0","1","2023-07-29 08:34:33");
INSERT INTO tbl_purchase VALUES("861","PUR300723101","","SU","40","0.00","13585.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13585.00","0","","","2023-07-30","","13585.00","0.00","","LE_2","","0","1","2023-07-30 07:20:14");
INSERT INTO tbl_purchase VALUES("862","PUR300723102","","SU","39","0.00","15200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15200.00","0","","","2023-07-30","","15200.00","0.00","","LE_2","","0","1","2023-07-30 07:51:23");
INSERT INTO tbl_purchase VALUES("863","PUR300723103","","SU","40","0.00","1840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1840.00","0","","","2023-07-30","","1840.00","0.00","","LE_2","","0","1","2023-07-30 08:48:10");
INSERT INTO tbl_purchase VALUES("864","PUR300723104","","SU","39","0.00","3000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3000.00","0","","","2023-07-30","","3000.00","0.00","","LE_2","","0","1","2023-07-30 11:08:19");
INSERT INTO tbl_purchase VALUES("865","PUR310723101","","SU","39","0.00","22410.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22410.00","0","","","2023-07-31","","22410.00","0.00","","LE_2","","0","1","2023-07-31 08:16:22");
INSERT INTO tbl_purchase VALUES("866","PUR010823101","","SU","40","0.00","25216.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25216.50","0","","","2023-08-01","2023-08-08","25216.00","0.00","","LE_2","","0","1","2023-08-01 05:47:48");
INSERT INTO tbl_purchase VALUES("867","PUR010823102","","SU","39","0.00","204060.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","204060.00","0","","","2023-08-01","","204060.00","0.00","","LE_2","","0","1","2023-08-01 07:15:52");
INSERT INTO tbl_purchase VALUES("868","PUR020823101","","SU","39","0.00","1824.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1824.00","0","","","2023-08-02","","1824.00","0.00","","LE_2","","0","1","2023-08-02 10:20:13");
INSERT INTO tbl_purchase VALUES("869","PUR030823101","","SU","39","0.00","10737.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10737.00","0","","","2023-08-03","","10737.00","0.00","","LE_2","","0","1","2023-08-03 01:12:46");
INSERT INTO tbl_purchase VALUES("870","PUR030823102","","SU","55","0.00","6900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6900.00","0","","","2023-08-03","2023-08-10","0.00","0.00","","LE_2","","0","1","2023-08-03 03:59:50");
INSERT INTO tbl_purchase VALUES("871","PUR030823103","","SU","43","0.00","358.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","358.00","0","","","2023-08-03","2023-08-10","0.00","0.00","","LE_2","","0","1","2023-08-03 04:07:25");
INSERT INTO tbl_purchase VALUES("872","PUR040823101","","SU","39","0.00","15400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15400.00","0","","","2023-08-04","","15400.00","0.00","","LE_2","","0","1","2023-08-04 04:03:22");
INSERT INTO tbl_purchase VALUES("873","PUR040823102","","SU","2","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2023-08-04","2023-08-11","0.00","0.00","","LE_2","","0","1","2023-08-04 05:58:44");
INSERT INTO tbl_purchase VALUES("874","PUR040823103","","SU","19","0.00","125000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125000.00","0","","","2023-08-04","","125000.00","0.00","","LE_2","","0","1","2023-08-04 06:27:17");
INSERT INTO tbl_purchase VALUES("875","PUR040823104","","SU","6","0.00","9600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9600.00","0","","","2023-08-04","","9600.00","0.00","","LE_2","","0","1","2023-08-04 06:25:19");
INSERT INTO tbl_purchase VALUES("876","PUR040823105","","SU","6","0.00","1250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1250.00","0","","","2023-08-04","","1250.00","0.00","","LE_2","","0","1","2023-08-04 10:23:31");
INSERT INTO tbl_purchase VALUES("877","PUR050823101","","SU","39","0.00","13776.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13776.00","0","","","2023-08-05","","13776.00","0.00","","LE_2","","0","1","2023-08-05 09:18:05");
INSERT INTO tbl_purchase VALUES("878","PUR060823101","","SU","37","0.00","54430.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54430.00","0","","","2023-08-06","2023-08-13","0.00","0.00","","LE_2","","0","1","2023-08-06 06:48:10");
INSERT INTO tbl_purchase VALUES("879","PUR070823101","","SU","40","0.00","12390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12390.00","0","","","2023-08-07","","12390.00","0.00","","LE_2","","0","1","2023-08-07 06:57:45");
INSERT INTO tbl_purchase VALUES("880","PUR070823102","","SU","61","0.00","2050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2050.00","0","","","2023-08-07","","2050.00","0.00","","LE_2","","0","1","2023-08-07 05:22:23");
INSERT INTO tbl_purchase VALUES("882","PUR070823103","","SU","39","0.00","6250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6250.00","0","","","2023-08-07","","6250.00","0.00","","LE_2","","0","1","2023-08-07 06:49:49");
INSERT INTO tbl_purchase VALUES("883","PUR070823104","","SU","6","0.00","111000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","111000.00","0","","","2023-08-07","","111000.00","0.00","","LE_2","","0","1","2023-08-07 06:56:46");
INSERT INTO tbl_purchase VALUES("884","PUR090823101","","SU","39","0.00","1710.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1710.00","0","","","2023-08-09","","1710.00","0.00","","LE_2","","0","1","2023-08-09 06:23:44");
INSERT INTO tbl_purchase VALUES("885","PUR090823102","","SU","33","0.00","62000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","62000.00","0","","","2023-08-09","2023-08-16","0.00","0.00","","LE_2","","0","1","2023-08-09 08:58:19");
INSERT INTO tbl_purchase VALUES("886","PUR110823101","","SU","39","0.00","13100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13100.00","0","","","2023-08-11","","13100.00","0.00","","LE_2","","0","1","2023-08-11 05:06:12");
INSERT INTO tbl_purchase VALUES("887","PUR120823101","","SU","40","0.00","2185.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2185.00","0","","","2023-08-12","","2185.00","0.00","","LE_2","","0","1","2023-08-12 02:06:53");
INSERT INTO tbl_purchase VALUES("888","PUR130823101","","SU","39","0.00","5300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5300.00","0","","","2023-08-13","","5300.00","0.00","","LE_2","","0","1","2023-08-13 09:54:13");
INSERT INTO tbl_purchase VALUES("889","PUR140823101","","SU","39","0.00","936.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","936.00","0","","","2023-08-14","","936.00","0.00","","LE_2","","0","1","2023-08-14 06:53:02");
INSERT INTO tbl_purchase VALUES("890","PUR150823101","","SU","40","0.00","8390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8390.00","0","","","2023-08-15","","8390.00","0.00","","LE_2","","0","1","2023-08-15 08:18:32");
INSERT INTO tbl_purchase VALUES("891","PUR170823101","","SU","10","0.00","134000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134000.00","0","","","2023-08-17","2023-08-24","0.00","0.00","","LE_2","","0","1","2023-08-17 06:13:00");
INSERT INTO tbl_purchase VALUES("892","PUR180823101","","SU","5","0.00","90930.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","90930.00","0","","","2023-08-18","2023-08-25","60007.00","0.00","","LE_2","","0","1","2023-08-18 10:25:02");
INSERT INTO tbl_purchase VALUES("893","PUR190823101","","SU","40","0.00","14013.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14013.50","0","","","2023-08-19","","14013.50","0.00","","LE_2","","0","1","2023-08-19 05:56:38");
INSERT INTO tbl_purchase VALUES("894","PUR190823102","","SU","2","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2023-08-19","2023-08-26","0.00","0.00","","LE_2","","0","1","2023-08-19 08:51:16");
INSERT INTO tbl_purchase VALUES("895","PUR200823101","","SU","59","0.00","20250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20250.00","0","","","2023-08-18","","20250.00","0.00","","LE_2","","0","1","2023-08-20 12:43:11");
INSERT INTO tbl_purchase VALUES("896","PUR200823102","","SU","19","0.00","96445.45","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.45","0.00","96445.00","0","","","2023-08-20","","96445.00","0.00","","LE_2","","0","1","2023-08-20 07:11:44");
INSERT INTO tbl_purchase VALUES("897","PUR210823101","","SU","5","0.00","5800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5800.00","0","","","2023-08-21","2023-08-28","0.00","0.00","","LE_2","","0","1","2023-08-21 03:43:14");
INSERT INTO tbl_purchase VALUES("898","PUR220823101","","SU","51","0.00","7345.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7345.00","0","","","2023-08-22","2023-08-29","0.00","0.00","","LE_2","","0","1","2023-08-22 10:27:55");
INSERT INTO tbl_purchase VALUES("899","PUR220823102","","SU","39","0.00","14700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14700.00","0","","","2023-08-22","","14700.00","0.00","","LE_2","","0","1","2023-08-22 06:30:09");
INSERT INTO tbl_purchase VALUES("900","PUR220823103","","SU","5","0.00","51000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51000.00","0","","","2023-08-22","2023-08-29","0.00","0.00","","LE_2","","0","1","2023-08-22 08:10:15");
INSERT INTO tbl_purchase VALUES("901","PUR230823101","","SU","39","0.00","8200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8200.00","0","","","2023-08-23","","8200.00","0.00","","LE_2","","0","1","2023-08-23 04:42:35");
INSERT INTO tbl_purchase VALUES("902","PUR230823102","","SU","2","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2023-08-23","","100000.00","0.00","","LE_2","","0","1","2023-08-23 07:19:42");
INSERT INTO tbl_purchase VALUES("903","PUR250823101","","SU","12","0.00","99050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99050.00","0","","","2023-08-25","","99050.00","0.00","","LE_2","","0","1","2023-08-25 05:13:46");
INSERT INTO tbl_purchase VALUES("904","PUR290823101","","SU","46","0.00","709.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","709.00","0","","","2023-08-29","","709.00","0.00","","LE_2","","0","1","2023-08-29 06:12:00");
INSERT INTO tbl_purchase VALUES("905","PUR300823101","","SU","2","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2023-08-30","","100000.00","0.00","","LE_2","","0","1","2023-08-30 07:21:19");
INSERT INTO tbl_purchase VALUES("906","PUR300823102","","SU","39","0.00","2200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2200.00","0","","","2023-08-30","","2200.00","0.00","","LE_2","","0","1","2023-08-30 11:01:29");
INSERT INTO tbl_purchase VALUES("907","PUR310823101","","SU","19","0.00","320350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","5350.00","0.00","315000.00","0","","","2023-08-31","2023-09-07","0.00","0.00","","LE_2","","0","1","2023-08-31 12:30:25");
INSERT INTO tbl_purchase VALUES("908","PUR310823102","","SU","39","0.00","7600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7600.00","0","","","2023-08-31","","7600.00","0.00","","LE_2","","0","1","2023-08-31 06:00:37");
INSERT INTO tbl_purchase VALUES("909","PUR310823103","","SU","7","0.00","64270.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","70.00","0.00","64200.00","0","","","2023-08-31","","64200.00","0.00","","LE_2","","0","1","2023-08-31 07:20:49");
INSERT INTO tbl_purchase VALUES("910","PUR030923101","","SU","62","0.00","30300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","2300.00","0.00","28000.00","0","","","2023-09-03","","28000.00","0.00","","LE_2","","0","1","2023-09-03 06:24:57");
INSERT INTO tbl_purchase VALUES("911","PUR050923101","","SU","34","0.00","7500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7500.00","0","","","2023-09-05","","7500.00","0.00","","LE_2","","0","1","2023-09-05 07:28:52");
INSERT INTO tbl_purchase VALUES("912","PUR050923102","","SU","34","0.00","3000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3000.00","0","","","2023-09-05","","3000.00","0.00","","LE_2","","0","1","2023-09-05 07:45:38");
INSERT INTO tbl_purchase VALUES("913","PUR050923103","","SU","34","0.00","58850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58850.00","0","","","2023-09-05","","58850.00","0.00","","LE_2","","0","1","2023-09-05 08:26:39");
INSERT INTO tbl_purchase VALUES("914","PUR050923104","","SU","39","0.00","700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","700.00","0","","","2023-09-04","","700.00","0.00","","LE_2","","0","1","2023-09-05 08:29:22");
INSERT INTO tbl_purchase VALUES("915","PUR050923105","","SU","49","0.00","55190.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","3690.00","0.00","51500.00","0","","","2023-09-05","2023-09-12","34500.00","0.00","","LE_2","","0","1","2023-09-05 11:20:46");
INSERT INTO tbl_purchase VALUES("916","PUR070923101","","SU","40","0.00","6400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6400.00","0","","","2023-09-07","","6400.00","0.00","","LE_2","","0","1","2023-09-07 09:51:57");
INSERT INTO tbl_purchase VALUES("917","PUR080923101","","SU","2","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2023-09-08","","105000.00","0.00","","LE_2","","0","1","2023-09-08 05:20:35");
INSERT INTO tbl_purchase VALUES("918","PUR110923101","","SU","5","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2023-09-11","2023-09-18","0.00","0.00","","LE_2","","0","1","2023-09-11 11:25:07");
INSERT INTO tbl_purchase VALUES("919","PUR110923102","","SU","39","0.00","22100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22100.00","0","","","2023-09-11","","22100.00","0.00","","LE_2","","0","1","2023-09-11 08:38:54");
INSERT INTO tbl_purchase VALUES("920","PUR120923101","","SU","12","0.00","153600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","153600.00","0","","","2023-09-12","","153600.00","0.00","","LE_2","","0","1","2023-09-12 03:26:13");
INSERT INTO tbl_purchase VALUES("921","PUR130923101","","SU","63","0.00","33820.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33820.00","0","","","2023-09-13","","33820.00","0.00","","LE_2","","0","1","2023-09-13 03:25:50");
INSERT INTO tbl_purchase VALUES("922","PUR150923101","","SU","34","0.00","59500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59500.00","0","","","2023-09-15","","59500.00","0.00","","LE_2","","0","1","2023-09-15 01:02:08");
INSERT INTO tbl_purchase VALUES("923","PUR180923101","","SU","51","0.00","9747.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9747.00","0","","","2023-09-18","","9747.00","0.00","","LE_2","","0","1","2023-09-18 01:55:24");
INSERT INTO tbl_purchase VALUES("924","PUR180923102","","SU","43","0.00","170000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","170000.00","0","","","2023-09-15","2023-09-25","0.00","0.00","","LE_2","","0","1","2023-09-18 02:00:29");
INSERT INTO tbl_purchase VALUES("925","PUR180923103","","SU","39","0.00","85000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85000.00","0","","","2023-09-18","","85000.00","0.00","","LE_2","","0","1","2023-09-18 08:27:04");
INSERT INTO tbl_purchase VALUES("926","PUR200923101","","SU","49","0.00","55390.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55390.00","0","","","2023-09-20","","55390.00","0.00","","LE_2","","0","1","2023-09-20 11:56:37");
INSERT INTO tbl_purchase VALUES("927","PUR220923101","","SU","2","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2023-09-22","","105000.00","0.00","","LE_2","","0","1","2023-09-22 11:35:39");
INSERT INTO tbl_purchase VALUES("928","PUR220923102","","SU","33","0.00","46000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46000.00","0","","","2023-09-22","","46000.00","0.00","","LE_2","","0","1","2023-09-22 07:37:29");
INSERT INTO tbl_purchase VALUES("929","PUR230923101","","SU","39","0.00","4248.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4248.00","0","","","2023-09-23","","4248.00","0.00","","LE_2","","0","1","2023-09-23 10:09:01");
INSERT INTO tbl_purchase VALUES("930","PUR260923101","","SU","38","0.00","73000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73000.00","0","","","2023-09-25","","73000.00","0.00","","LE_2","","0","1","2023-09-26 12:09:14");
INSERT INTO tbl_purchase VALUES("931","PUR260923102","","SU","39","0.00","23800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23800.00","0","","","2023-09-26","","23800.00","0.00","","LE_2","","0","1","2023-09-26 05:49:06");
INSERT INTO tbl_purchase VALUES("932","PUR260923103","","SU","51","0.00","5382.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5382.00","0","","","2023-09-26","2023-10-03","0.00","0.00","","LE_2","","0","1","2023-09-26 06:16:11");
INSERT INTO tbl_purchase VALUES("933","PUR280923101","","SU","4","0.00","17000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17000.00","0","","","2023-09-28","2023-10-05","0.00","0.00","","LE_2","","0","1","2023-09-28 06:22:16");
INSERT INTO tbl_purchase VALUES("934","PUR280923102","","SU","39","0.00","7400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7400.00","0","","","2023-09-28","","7400.00","0.00","","LE_2","","0","1","2023-09-28 09:11:30");
INSERT INTO tbl_purchase VALUES("935","PUR290923101","","SU","4","0.00","36400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36400.00","0","","","2023-09-29","2023-10-06","0.00","0.00","","LE_2","","0","1","2023-09-29 03:42:44");
INSERT INTO tbl_purchase VALUES("936","PUR300923101","","SU","37","0.00","29072.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29072.50","0","","","2023-09-30","","29072.50","0.00","","LE_2","","0","1","2023-09-30 01:06:13");
INSERT INTO tbl_purchase VALUES("937","PUR021023101","","SU","34","0.00","56250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56250.00","0","","","2023-10-02","","56250.00","0.00","","LE_2","","0","1","2023-10-02 05:13:36");
INSERT INTO tbl_purchase VALUES("938","PUR041023101","","SU","19","0.00","122500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","122500.00","0","","","2023-10-04","","122500.00","0.00","","LE_2","","0","1","2023-10-04 11:43:04");
INSERT INTO tbl_purchase VALUES("939","PUR051023101","","SU","2","0.00","206600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","206600.00","0","","","2023-10-05","2023-10-12","1600.00","0.00","","LE_2","","0","1","2023-10-05 07:56:09");
INSERT INTO tbl_purchase VALUES("940","PUR081023101","","SU","5","0.00","111670.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","111670.00","0","","","2023-10-08","","111670.00","0.00","","LE_2","","0","1","2023-10-08 04:31:54");
INSERT INTO tbl_purchase VALUES("941","PUR081023102","","SU","37","0.00","21491.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21491.00","0","","","2023-10-08","2023-10-15","0.00","0.00","","LE_2","","0","1","2023-10-08 04:37:29");
INSERT INTO tbl_purchase VALUES("942","PUR081023103","","SU","39","0.00","4600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4600.00","0","","","2023-10-08","","4600.00","0.00","","LE_2","","0","1","2023-10-08 06:34:32");
INSERT INTO tbl_purchase VALUES("943","PUR091023101","","SU","5","0.00","111980.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","111980.00","0","","","2023-10-09","2023-10-16","0.00","0.00","","LE_2","","0","1","2023-10-09 05:37:09");
INSERT INTO tbl_purchase VALUES("944","PUR111023101","","SU","34","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2023-10-11","","65000.00","0.00","","LE_2","","0","1","2023-10-11 06:50:32");
INSERT INTO tbl_purchase VALUES("945","PUR131023101","","SU","9","0.00","31400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31400.00","0","","","2023-10-13","2023-10-20","0.00","0.00","","LE_2","","0","1","2023-10-13 12:56:16");
INSERT INTO tbl_purchase VALUES("946","PUR131023102","","SU","12","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2023-10-13","2023-10-20","0.00","0.00","","LE_2","","0","1","2023-10-13 01:53:49");
INSERT INTO tbl_purchase VALUES("947","PUR131023103","","SU","12","0.00","189000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","189000.00","0","","","2023-10-13","","189000.00","0.00","","LE_2","","0","1","2023-10-13 06:46:03");
INSERT INTO tbl_purchase VALUES("949","PUR161023101","","SU","34","0.00","24200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24200.00","0","","","2023-10-16","","24200.00","0.00","","LE_2","","0","1","2023-10-16 01:29:57");
INSERT INTO tbl_purchase VALUES("950","PUR161023102","","SU","34","0.00","18750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18750.00","0","","","2023-10-16","","18750.00","0.00","","LE_2","","0","1","2023-10-16 04:38:24");
INSERT INTO tbl_purchase VALUES("951","PUR161023103","","SU","4","0.00","48000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48000.00","0","","","2023-10-16","","48000.00","0.00","","LE_2","","0","1","2023-10-16 04:50:57");
INSERT INTO tbl_purchase VALUES("952","PUR171023101","","SU","5","0.00","54000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54000.00","0","","","2023-10-17","","54000.00","0.00","","LE_2","","0","1","2023-10-17 06:29:05");
INSERT INTO tbl_purchase VALUES("953","PUR171023102","","SU","59","0.00","98470.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","98470.00","0","","","2023-10-17","","98470.00","0.00","","LE_2","","0","1","2023-10-17 09:08:02");
INSERT INTO tbl_purchase VALUES("954","PUR181023101","","SU","59","0.00","13566.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13566.00","0","","","2023-10-17","","13566.00","0.00","","LE_2","","0","1","2023-10-18 10:35:30");
INSERT INTO tbl_purchase VALUES("955","PUR181023102","","SU","4","0.00","73000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73000.00","0","","","2023-10-18","2023-10-25","0.00","0.00","","LE_2","","0","1","2023-10-18 01:41:33");
INSERT INTO tbl_purchase VALUES("956","PUR181023103","","SU","2","0.00","63000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63000.00","0","","","2023-10-18","","63000.00","0.00","","LE_2","","0","1","2023-10-18 06:48:06");
INSERT INTO tbl_purchase VALUES("957","PUR181023104","","SU","59","0.00","6400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6400.00","0","","","2023-10-18","","6400.00","0.00","","LE_2","","0","1","2023-10-18 08:03:40");
INSERT INTO tbl_purchase VALUES("958","PUR191023101","","SU","12","0.00","10200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10200.00","0","","","2023-10-19","","10200.00","0.00","","LE_2","","0","1","2023-10-19 02:37:04");
INSERT INTO tbl_purchase VALUES("959","PUR191023102","","SU","6","0.00","16800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16800.00","0","","","2023-10-19","","16800.00","0.00","","LE_2","","0","1","2023-10-19 07:52:58");
INSERT INTO tbl_purchase VALUES("960","PUR201023101","","SU","43","0.00","67000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67000.00","0","","","2023-10-20","2023-10-27","0.00","0.00","","LE_2","","0","1","2023-10-20 04:48:57");
INSERT INTO tbl_purchase VALUES("961","PUR201023102","","SU","48","0.00","45950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45950.00","0","","","2023-10-20","","45950.00","0.00","","LE_2","","0","1","2023-10-20 08:03:55");
INSERT INTO tbl_purchase VALUES("962","PUR201023103","","SU","39","0.00","2014.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2014.00","0","","","2023-10-20","","2014.00","0.00","","LE_2","","0","1","2023-10-20 08:05:30");
INSERT INTO tbl_purchase VALUES("963","PUR221023101","","SU","2","0.00","36990.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36990.00","0","","","2023-10-22","","36990.00","0.00","","LE_2","","0","1","2023-10-22 05:44:13");
INSERT INTO tbl_purchase VALUES("964","PUR271023101","","SU","39","0.00","15500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15500.00","0","","","2023-10-27","","15500.00","0.00","","LE_2","","0","1","2023-10-27 06:42:45");
INSERT INTO tbl_purchase VALUES("965","PUR271023102","","SU","2","0.00","123600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","123600.00","0","","","2023-10-27","2023-11-03","0.00","0.00","","LE_2","","0","1","2023-10-27 10:55:21");
INSERT INTO tbl_purchase VALUES("966","PUR301023101","","SU","5","0.00","87004.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87004.50","0","","","2023-10-30","2023-11-06","0.00","0.00","","LE_2","","0","1","2023-10-30 04:13:42");
INSERT INTO tbl_purchase VALUES("967","PUR301023102","","SU","37","0.00","29120.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29120.00","0","","","2023-10-28","2023-11-06","0.00","0.00","","LE_2","","0","1","2023-11-08 10:10:46");
INSERT INTO tbl_purchase VALUES("968","PUR011123101","","SU","19","0.00","194250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","194250.00","0","","","2023-11-01","","195000.00","750.00","","LE_2","","0","1","2023-11-01 01:34:40");
INSERT INTO tbl_purchase VALUES("969","PUR021123101","","SU","39","0.00","45994.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45994.70","0","","","2023-11-02","2023-11-09","45994.00","0.00","","LE_2","","0","1","2023-11-02 03:57:37");
INSERT INTO tbl_purchase VALUES("970","PUR021123102","","SU","34","0.00","55600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55600.00","0","","","2023-11-02","","55600.00","0.00","","LE_2","","0","1","2023-11-02 06:27:56");
INSERT INTO tbl_purchase VALUES("971","PUR021123103","","SU","59","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2023-11-02","","22200.00","200.00","","LE_2","","0","1","2023-11-02 07:17:05");
INSERT INTO tbl_purchase VALUES("972","PUR041123101","","SU","39","0.00","11100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11100.00","0","","","2023-11-04","","11100.00","0.00","","LE_2","","0","1","2023-11-04 09:36:34");
INSERT INTO tbl_purchase VALUES("973","PUR061123101","","SU","40","0.00","11724.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11724.50","0","","","2023-11-06","","11724.50","0.00","","LE_2","","0","1","2023-11-06 05:26:18");
INSERT INTO tbl_purchase VALUES("974","PUR061123102","","SU","2","0.00","40000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40000.00","0","","","2023-11-06","","40000.00","0.00","","LE_2","","0","1","2023-11-06 07:11:10");
INSERT INTO tbl_purchase VALUES("975","PUR071123101","","SU","5","0.00","134700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134700.00","0","","","2023-11-07","","134700.00","0.00","","LE_2","","0","1","2023-11-07 12:12:33");
INSERT INTO tbl_purchase VALUES("976","PUR071123102","","SU","48","0.00","109500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","109500.00","0","","","2023-11-07","","109500.00","0.00","","LE_2","","0","1","2023-11-07 03:03:45");
INSERT INTO tbl_purchase VALUES("977","PUR071123103","","SU","19","0.00","190000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190000.00","0","","","2023-11-07","","190000.00","0.00","","LE_2","","0","1","2023-11-07 03:28:09");
INSERT INTO tbl_purchase VALUES("978","PUR071123104","","SU","34","0.00","89000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","89000.00","0","","","2023-11-07","","89000.00","0.00","","LE_2","","0","1","2023-11-07 03:50:54");
INSERT INTO tbl_purchase VALUES("979","PUR081123101","","SU","39","0.00","14200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14200.00","0","","","2023-11-08","","14200.00","0.00","","LE_2","","0","1","2023-11-08 10:50:15");
INSERT INTO tbl_purchase VALUES("980","PUR081123102","","SU","59","0.00","24440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24440.00","0","","","2023-11-08","","24440.00","0.00","","LE_2","","0","1","2023-11-08 11:37:47");
INSERT INTO tbl_purchase VALUES("981","PUR081123103","","SU","33","0.00","40740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40740.00","0","","","2023-11-08","","40740.00","0.00","","LE_2","","0","1","2023-11-08 11:39:50");
INSERT INTO tbl_purchase VALUES("982","PUR081123104","","SU","51","0.00","6042.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6042.00","0","","","2023-11-08","","6042.00","0.00","","LE_2","","0","1","2023-11-08 11:41:46");
INSERT INTO tbl_purchase VALUES("983","PUR081123105","","SU","40","0.00","11502.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11502.40","0","","","2023-11-08","2023-11-15","0.00","0.00","","LE_2","","0","1","2023-11-08 03:28:55");
INSERT INTO tbl_purchase VALUES("984","PUR091123101","","SU","39","0.00","5500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5500.00","0","","","2023-11-09","","5500.00","0.00","","LE_2","","0","1","2023-11-09 12:47:04");
INSERT INTO tbl_purchase VALUES("985","PUR091123102","","SU","40","0.00","8240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8240.00","0","","","2023-11-09","","8240.00","0.00","","LE_2","","0","1","2023-11-09 08:02:42");
INSERT INTO tbl_purchase VALUES("986","PUR091123103","","SU","34","0.00","47880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47880.00","0","","","2023-11-09","","47880.00","0.00","","LE_2","","0","1","2023-11-09 09:58:47");
INSERT INTO tbl_purchase VALUES("987","PUR101123101","","SU","55","0.00","8450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8450.00","0","","","2023-11-10","2023-11-17","0.00","0.00","","LE_2","","0","1","2023-11-10 01:21:18");
INSERT INTO tbl_purchase VALUES("990","PUR111123101","","SU","13","0.00","65854.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65854.00","0","","","2023-11-11","","65854.00","0.00","","LE_2","","0","1","2023-11-11 10:40:52");
INSERT INTO tbl_purchase VALUES("991","PUR111123102","","SU","13","0.00","21290.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21290.00","0","","","2023-11-11","","21290.00","0.00","","LE_2","","0","1","2023-11-11 10:43:46");
INSERT INTO tbl_purchase VALUES("992","PUR121123101","","SU","40","0.00","11449.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11449.50","0","","","2023-11-12","","11449.50","0.00","","LE_2","","0","1","2023-11-12 04:04:30");
INSERT INTO tbl_purchase VALUES("993","PUR131123101","","SU","63","0.00","54950.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","54950.50","0","","","2023-11-13","","54950.50","0.00","","LE_2","","0","1","2023-11-13 12:52:05");
INSERT INTO tbl_purchase VALUES("994","PUR131123102","","SU","2","0.00","133200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","133200.00","0","","","2023-11-13","","133200.00","0.00","","LE_2","","0","1","2023-11-13 06:29:19");
INSERT INTO tbl_purchase VALUES("995","PUR131123103","","SU","33","0.00","27000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27000.00","0","","","2023-11-13","2023-11-20","0.00","0.00","","LE_2","","0","1","2023-11-13 06:55:16");
INSERT INTO tbl_purchase VALUES("996","PUR141123101","","SU","19","0.00","150000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","150000.00","0","","","2023-11-14","2023-11-21","138400.00","0.00","","LE_2","","0","1","2023-11-14 06:24:51");
INSERT INTO tbl_purchase VALUES("997","PUR141123102","","SU","40","0.00","5082.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5082.50","0","","","2023-11-14","","5082.50","0.00","","LE_2","","0","1","2023-11-14 06:26:43");
INSERT INTO tbl_purchase VALUES("998","PUR151123101","","SU","63","0.00","13737.62","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13737.62","0","","","2023-11-15","","13737.62","0.00","","LE_2","","0","1","2023-11-15 12:05:00");
INSERT INTO tbl_purchase VALUES("999","PUR151123102","","SU","46","0.00","400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","400.00","0","","","2023-11-15","","400.00","0.00","","LE_2","","0","1","2023-11-15 06:15:26");
INSERT INTO tbl_purchase VALUES("1000","PUR161123101","","SU","13","0.00","116550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116550.00","0","","","2023-11-16","","116550.00","0.00","","LE_2","","0","1","2023-11-16 05:19:17");
INSERT INTO tbl_purchase VALUES("1001","PUR161123102","","SU","12","0.00","37600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37600.00","0","","","2023-11-16","","37600.00","0.00","","LE_2","","0","1","2023-11-16 05:42:35");
INSERT INTO tbl_purchase VALUES("1002","PUR191123101","","SU","26","0.00","32465.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32465.00","0","","","2023-11-19","","32465.00","0.00","","LE_2","","0","1","2023-11-19 03:44:32");
INSERT INTO tbl_purchase VALUES("1003","PUR191123102","","SU","40","0.00","9656.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9656.20","0","","","2023-11-19","","9656.20","0.00","","LE_2","","0","1","2023-11-19 04:46:11");
INSERT INTO tbl_purchase VALUES("1004","PUR191123103","","SU","19","0.00","64500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64500.00","0","","","2023-11-19","","64500.00","0.00","","LE_2","","0","1","2023-11-19 05:18:19");
INSERT INTO tbl_purchase VALUES("1005","PUR221123101","","SU","34","0.00","65500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65500.00","0","","","2023-11-22","","65500.00","0.00","","LE_2","","0","1","2023-11-22 06:16:42");
INSERT INTO tbl_purchase VALUES("1006","PUR221123102","","SU","43","0.00","14800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14800.00","0","","","2023-11-22","2023-11-29","0.00","0.00","","LE_2","","0","1","2023-11-22 06:19:30");
INSERT INTO tbl_purchase VALUES("1007","PUR231123101","","SU","59","0.00","57000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","57000.00","0","","","2023-11-23","","57000.00","0.00","","LE_2","","0","1","2023-11-23 11:24:59");
INSERT INTO tbl_purchase VALUES("1008","PUR231123102","","SU","39","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2023-11-23","","42000.00","0.00","","LE_2","","0","1","2023-11-23 07:22:25");
INSERT INTO tbl_purchase VALUES("1009","PUR241123101","","SU","63","0.00","36500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","36500.00","0","","","2023-11-24","","36500.00","0.00","","LE_2","","0","1","2023-11-24 11:15:06");
INSERT INTO tbl_purchase VALUES("1010","PUR241123102","","SU","33","0.00","34200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34200.00","0","","","2023-11-24","","34200.00","0.00","","LE_2","","0","1","2023-11-24 11:25:25");
INSERT INTO tbl_purchase VALUES("1011","PUR241123103","","SU","4","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2023-11-24","","80000.00","0.00","","LE_2","","0","1","2023-11-24 04:36:30");
INSERT INTO tbl_purchase VALUES("1012","PUR241123104","","SU","40","0.00","9577.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9577.90","0","","","2023-11-23","","9577.90","0.00","","LE_2","","0","1","2023-11-24 05:37:58");
INSERT INTO tbl_purchase VALUES("1013","PUR261123101","","SU","40","0.00","29638.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29638.80","0","","","2023-11-26","2023-12-03","29638.80","0.00","","LE_2","","0","1","2023-11-26 05:26:00");
INSERT INTO tbl_purchase VALUES("1014","PUR261123102","","SU","37","0.00","16393.61","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16393.61","0","","","2023-11-26","2023-12-03","0.00","0.00","","LE_2","","0","1","2023-11-26 06:00:39");
INSERT INTO tbl_purchase VALUES("1015","PUR261123103","","SU","64","0.00","9681.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9681.30","0","","","2023-11-26","","9681.30","0.00","","LE_2","","0","1","2023-11-26 08:51:30");
INSERT INTO tbl_purchase VALUES("1016","PUR271123101","","SU","7","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2023-11-27","","35000.00","0.00","","LE_2","","0","1","2023-11-27 10:38:43");
INSERT INTO tbl_purchase VALUES("1017","PUR281123101","","SU","40","0.00","9399.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9399.30","0","","","2023-11-28","2023-12-05","9399.30","0.00","","LE_2","","0","1","2023-11-28 05:45:25");
INSERT INTO tbl_purchase VALUES("1018","PUR281123102","","SU","51","0.00","8140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8140.00","0","","","2023-11-28","","8140.00","0.00","","LE_2","","0","1","2023-11-28 05:52:16");
INSERT INTO tbl_purchase VALUES("1019","PUR281123103","","SU","59","0.00","81300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81300.00","0","","","2023-11-28","","81300.00","0.00","","LE_2","","0","1","2023-11-28 07:55:04");
INSERT INTO tbl_purchase VALUES("1020","PUR291123101","","SU","2","0.00","103000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","103000.00","0","","","2023-11-29","","103000.00","0.00","","LE_2","","0","1","2023-11-29 07:04:46");
INSERT INTO tbl_purchase VALUES("1021","PUR301123101","","SU","33","0.00","22997.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22997.00","0","","","2023-11-30","","22997.00","0.00","","LE_2","","0","1","2023-11-30 10:58:24");
INSERT INTO tbl_purchase VALUES("1022","PUR301123102","","SU","49","0.00","112700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112700.00","0","","","2023-11-30","2023-12-07","12000.00","0.00","","LE_2","","0","1","2023-11-30 08:13:36");
INSERT INTO tbl_purchase VALUES("1023","PUR301123103","","SU","40","0.00","8971.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8971.80","0","","","2023-11-30","2023-12-07","8971.80","0.00","","LE_2","","0","1","2023-11-30 09:02:08");
INSERT INTO tbl_purchase VALUES("1024","PUR021223101","","SU","42","0.00","19391.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19391.40","0","","","2023-12-02","","19391.40","0.00","","LE_2","","0","1","2023-12-02 06:02:32");
INSERT INTO tbl_purchase VALUES("1025","PUR031223101","","SU","49","0.00","20900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20900.00","0","","","2023-12-03","","20900.00","0.00","","LE_2","","0","1","2023-12-03 07:41:59");
INSERT INTO tbl_purchase VALUES("1026","PUR041223101","","SU","51","0.00","13227.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13227.50","0","","","2023-12-04","2023-12-11","13227.00","0.00","","LE_2","","0","1","2023-12-04 05:54:57");
INSERT INTO tbl_purchase VALUES("1027","PUR051223101","","SU","59","0.00","97900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","97900.00","0","","","2023-12-05","","97900.00","0.00","","LE_2","","0","1","2023-12-05 11:16:01");
INSERT INTO tbl_purchase VALUES("1028","PUR061223101","","SU","19","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2023-12-06","","95000.00","0.00","","LE_2","","0","1","2023-12-06 12:44:48");
INSERT INTO tbl_purchase VALUES("1029","PUR061223102","","SU","51","0.00","3771.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3771.50","0","","","2023-12-06","2023-12-13","3771.00","0.00","","LE_2","","0","1","2023-12-06 10:03:59");
INSERT INTO tbl_purchase VALUES("1032","PUR081223102","","SU","59","0.00","53400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","53400.00","0","","","2023-12-08","","53400.00","0.00","","LE_2","","0","1","2023-12-08 07:02:45");
INSERT INTO tbl_purchase VALUES("1033","PUR081223103","","SU","34","0.00","70500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","70500.00","0","","","2023-12-08","","70500.00","0.00","","LE_2","","0","1","2023-12-08 07:15:56");
INSERT INTO tbl_purchase VALUES("1034","PUR091223101","","SU","55","0.00","3300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3300.00","0","","","2023-12-09","2023-12-16","0.00","0.00","","LE_2","","0","1","2023-12-09 02:54:25");
INSERT INTO tbl_purchase VALUES("1035","PUR101223101","","SU","40","0.00","19114.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19114.00","0","","","2023-12-10","","19114.00","0.00","","LE_2","","0","1","2023-12-10 07:53:59");
INSERT INTO tbl_purchase VALUES("1036","PUR111223101","","SU","33","0.00","94250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","94250.00","0","","","2023-12-11","","94250.00","0.00","","LE_2","","0","1","2023-12-11 06:22:19");
INSERT INTO tbl_purchase VALUES("1037","PUR111223102","","SU","34","0.00","78600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78600.00","0","","","2023-12-11","","78600.00","0.00","","LE_2","","0","1","2023-12-11 06:36:39");
INSERT INTO tbl_purchase VALUES("1038","PUR121223101","","SU","37","0.00","10197.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10197.00","0","","","2023-12-04","2023-12-19","0.00","0.00","","LE_2","","0","1","2023-12-12 01:24:57");
INSERT INTO tbl_purchase VALUES("1039","PUR121223102","","SU","5","0.00","46549.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46549.80","0","","","2023-11-14","","46549.80","0.00","","LE_2","","0","1","2023-12-12 01:34:21");
INSERT INTO tbl_purchase VALUES("1040","PUR121223103","","SU","2","0.00","101000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","101000.00","0","","","2023-12-12","","101000.00","0.00","","LE_2","","0","1","2023-12-12 06:05:51");
INSERT INTO tbl_purchase VALUES("1041","PUR121223104","","SU","19","0.00","87500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87500.00","0","","","2023-12-12","","87500.00","0.00","","LE_2","","0","1","2023-12-12 08:47:39");
INSERT INTO tbl_purchase VALUES("1042","PUR121223105","","SU","43","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2023-12-12","","15000.00","0.00","","LE_2","","0","1","2023-12-12 08:49:44");
INSERT INTO tbl_purchase VALUES("1043","PUR131223101","","SU","13","0.00","67765.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67765.00","0","","","2023-12-13","","67765.00","0.00","","LE_2","","0","1","2023-12-13 12:03:37");
INSERT INTO tbl_purchase VALUES("1044","PUR131223102","","SU","63","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2023-12-13","","33000.00","0.00","","LE_2","","0","1","2023-12-13 12:30:22");
INSERT INTO tbl_purchase VALUES("1045","PUR141223101","","SU","61","0.00","5040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5040.00","0","","","2023-12-14","","5040.00","0.00","","LE_2","","0","1","2023-12-14 01:05:02");
INSERT INTO tbl_purchase VALUES("1046","PUR151223101","","SU","33","0.00","49397.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49397.00","0","","","2023-12-15","","49397.00","0.00","","LE_2","","0","1","2023-12-15 06:16:28");
INSERT INTO tbl_purchase VALUES("1047","PUR161223101","","SU","42","0.00","17873.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17873.30","0","","","2023-12-16","2023-12-23","17873.00","0.00","","LE_2","","0","1","2023-12-16 03:49:32");
INSERT INTO tbl_purchase VALUES("1048","PUR161223102","","SU","19","0.00","156750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","156750.00","0","","","2023-12-16","","156750.00","0.00","","LE_2","","0","1","2023-12-16 11:09:01");
INSERT INTO tbl_purchase VALUES("1049","PUR211223101","","SU","2","0.00","31860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31860.00","0","","","2023-12-21","","31860.00","0.00","","LE_2","","0","1","2023-12-21 12:21:58");
INSERT INTO tbl_purchase VALUES("1050","PUR211223102","","SU","2","0.00","31860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31860.00","0","","","2023-12-21","","31860.00","0.00","","LE_2","","0","1","2023-12-21 04:16:15");
INSERT INTO tbl_purchase VALUES("1051","PUR231223101","","SU","59","0.00","33600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33600.00","0","","","2023-12-23","","33600.00","0.00","","LE_2","","0","1","2023-12-23 03:41:44");
INSERT INTO tbl_purchase VALUES("1052","PUR251223101","","SU","59","0.00","4350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4350.00","0","","","2023-12-23","","4350.00","0.00","","LE_2","","0","1","2023-12-25 01:18:13");
INSERT INTO tbl_purchase VALUES("1053","PUR251223102","","SU","40","0.00","1612.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1612.00","0","","","2023-12-25","","1612.00","0.00","","LE_2","","0","1","2023-12-25 04:07:36");
INSERT INTO tbl_purchase VALUES("1054","PUR251223103","","SU","38","0.00","59783.05","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59783.05","0","","","2023-12-25","2024-01-01","59783.00","0.00","","LE_2","","0","1","2023-12-25 07:23:04");
INSERT INTO tbl_purchase VALUES("1055","PUR251223104","","SU","55","0.00","3900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3900.00","0","","","2023-12-25","","3900.00","0.00","","LE_2","","0","1","2023-12-25 08:24:40");
INSERT INTO tbl_purchase VALUES("1056","PUR261223101","","SU","13","0.00","109830.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","109830.00","0","","","2023-12-26","","109830.00","0.00","","LE_2","","0","1","2023-12-26 05:06:39");
INSERT INTO tbl_purchase VALUES("1057","PUR261223102","","SU","40","0.00","6630.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6630.00","0","","","2023-12-26","","6630.00","0.00","","LE_2","","0","1","2023-12-26 05:11:06");
INSERT INTO tbl_purchase VALUES("1058","PUR261223103","","SU","53","0.00","4050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4050.00","0","","","2023-12-26","","4050.00","0.00","","LE_2","","0","1","2023-12-26 06:58:24");
INSERT INTO tbl_purchase VALUES("1059","PUR291223101","","SU","39","0.00","2400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2400.00","0","","","2023-12-29","","2400.00","0.00","","LE_2","","0","1","2023-12-29 03:30:07");
INSERT INTO tbl_purchase VALUES("1060","PUR311223101","","SU","39","0.00","190706.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190706.00","0","","","2023-12-31","","190706.00","0.00","","LE_2","","0","1","2023-12-31 06:51:46");
INSERT INTO tbl_purchase VALUES("1061","PUR010124101","","SU","39","0.00","6600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6600.00","0","","","2024-01-01","","6600.00","0.00","","LE_2","","0","1","2024-01-01 11:08:20");
INSERT INTO tbl_purchase VALUES("1062","PUR010124102","","SU","2","0.00","101000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","101000.00","0","","","2024-01-01","","101000.00","0.00","","LE_2","","0","1","2024-01-01 09:36:59");
INSERT INTO tbl_purchase VALUES("1063","PUR020124101","","SU","39","0.00","1700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1700.00","0","","","2024-01-02","","1700.00","0.00","","LE_2","","0","1","2024-01-02 03:26:46");
INSERT INTO tbl_purchase VALUES("1064","PUR020124102","","SU","63","0.00","76820.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76820.00","0","","","2024-01-02","","76820.00","0.00","","LE_2","","0","1","2024-01-02 04:48:39");
INSERT INTO tbl_purchase VALUES("1065","PUR020124103","","SU","12","0.00","21400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21400.00","0","","","2024-01-02","","21400.00","0.00","","LE_2","","0","1","2024-01-02 07:15:11");
INSERT INTO tbl_purchase VALUES("1066","PUR020124104","","SU","39","0.00","270.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","270.00","0","","","2024-01-02","","270.00","0.00","","LE_2","","0","1","2024-01-02 09:09:27");
INSERT INTO tbl_purchase VALUES("1067","PUR020124105","","SU","39","0.00","1860.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1860.00","0","","","2024-01-02","","1860.00","0.00","","LE_2","","0","1","2024-01-02 09:40:19");
INSERT INTO tbl_purchase VALUES("1068","PUR030124101","","SU","39","0.00","43352.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43352.30","0","","","2024-01-03","","43352.30","0.00","","LE_2","","0","1","2024-01-03 02:35:38");
INSERT INTO tbl_purchase VALUES("1069","PUR040124101","","SU","2","0.00","66600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","66600.00","0","","","2024-01-04","","66600.00","0.00","","LE_2","","0","1","2024-01-04 12:30:45");
INSERT INTO tbl_purchase VALUES("1070","PUR040124102","","SU","5","0.00","106000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106000.00","0","","","2024-01-04","","106000.00","0.00","","LE_2","","0","1","2024-01-04 05:01:47");
INSERT INTO tbl_purchase VALUES("1071","PUR040124103","","SU","34","0.00","65500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65500.00","0","","","2024-01-04","","65500.00","0.00","","LE_2","","0","1","2024-01-04 05:16:12");
INSERT INTO tbl_purchase VALUES("1072","PUR060124101","","SU","19","0.00","87500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","87500.00","0","","","2024-01-06","","88500.00","1000.00","","LE_2","","0","1","2024-01-06 05:59:05");
INSERT INTO tbl_purchase VALUES("1073","PUR060124102","","SU","34","0.00","39300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","","0.00","0.00","0.00","0.00","39300.00","0","","","2024-01-06","","39300.00","0.00","","LE_2","","0","1","2024-01-06 06:33:00");
INSERT INTO tbl_purchase VALUES("1074","PUR080124101","","SU","65","0.00","4846.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4846.00","0","","","2024-01-08","","4846.00","0.00","","LE_2","","0","1","2024-01-08 03:41:46");
INSERT INTO tbl_purchase VALUES("1075","PUR080124102","","SU","40","0.00","4736.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4736.00","0","","","2024-01-08","","4736.00","0.00","","LE_2","","0","1","2024-01-08 03:53:40");
INSERT INTO tbl_purchase VALUES("1076","PUR090124101","","SU","39","0.00","12330.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12330.00","0","","","2024-01-09","","12330.00","0.00","","LE_2","","0","1","2024-01-09 02:39:08");
INSERT INTO tbl_purchase VALUES("1077","PUR100124101","","SU","46","0.00","865.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","865.00","0","","","2024-01-10","","865.00","0.00","","LE_2","","0","1","2024-01-10 12:57:16");
INSERT INTO tbl_purchase VALUES("1078","PUR100124102","","SU","61","0.00","3720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3720.00","0","","","2024-01-10","","3720.00","0.00","","LE_2","","0","1","2024-01-10 02:16:15");
INSERT INTO tbl_purchase VALUES("1079","PUR100124103","","SU","2","0.00","64650.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64650.00","0","","","2024-01-10","","64650.00","0.00","","LE_2","","0","1","2024-01-10 07:22:24");
INSERT INTO tbl_purchase VALUES("1080","PUR100124104","","SU","19","0.00","104750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104750.00","0","","","2024-01-10","","104750.00","0.00","","LE_2","","0","1","2024-01-10 09:46:10");
INSERT INTO tbl_purchase VALUES("1081","PUR110124101","","SU","34","0.00","5100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5100.00","0","","","2024-01-11","2024-01-18","0.00","0.00","","LE_2","","0","1","2024-01-11 05:09:49");
INSERT INTO tbl_purchase VALUES("1082","PUR110124102","","SU","5","0.00","111090.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","111090.00","0","","","2024-01-11","2024-01-18","78700.00","0.00","","LE_2","","0","1","2024-01-11 05:14:12");
INSERT INTO tbl_purchase VALUES("1083","PUR120124101","","SU","13","0.00","38255.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38255.00","0","","","2024-01-12","","38255.00","0.00","","LE_2","","0","1","2024-01-12 04:20:57");
INSERT INTO tbl_purchase VALUES("1084","PUR130124101","","SU","53","0.00","3680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3680.00","0","","","2024-01-13","","3680.00","0.00","","LE_2","","0","1","2024-01-13 07:10:08");
INSERT INTO tbl_purchase VALUES("1085","PUR140124101","","SU","59","0.00","37200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37200.00","0","","","2024-01-14","","37200.00","0.00","","LE_2","","0","1","2024-01-14 12:52:19");
INSERT INTO tbl_purchase VALUES("1086","PUR140124102","","SU","49","0.00","136734.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","136734.30","0","","","2024-01-14","","136736.00","1.70","","LE_2","","0","1","2024-01-14 01:05:10");
INSERT INTO tbl_purchase VALUES("1087","PUR140124103","","SU","10","0.00","19820.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19820.00","0","","","2024-01-14","","19820.00","0.00","","LE_2","","0","1","2024-01-14 01:15:16");
INSERT INTO tbl_purchase VALUES("1088","PUR150124101","","SU","66","0.00","3700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3700.00","0","","","2024-01-15","","3700.00","0.00","","LE_2","","0","1","2024-01-15 04:10:32");
INSERT INTO tbl_purchase VALUES("1089","PUR160124101","","SU","34","0.00","105975.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105975.00","0","","","2024-01-16","","105975.00","0.00","","LE_2","","0","1","2024-01-16 02:06:46");
INSERT INTO tbl_purchase VALUES("1090","PUR160124102","","SU","2","0.00","225000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","225000.00","0","","","2024-01-16","","225000.00","0.00","","LE_2","","0","1","2024-01-16 02:54:12");
INSERT INTO tbl_purchase VALUES("1091","PUR170124101","","SU","2","0.00","11705.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11705.00","0","","","2024-01-17","2024-01-24","0.00","0.00","","LE_2","","0","1","2024-01-17 07:57:46");
INSERT INTO tbl_purchase VALUES("1092","PUR180124101","","SU","34","0.00","113250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","113250.00","0","","","2024-01-18","","113250.00","0.00","","LE_2","","0","1","2024-01-18 07:03:15");
INSERT INTO tbl_purchase VALUES("1093","PUR190124101","","SU","13","0.00","117000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","117000.00","0","","","2024-01-19","","117000.00","0.00","","LE_2","","0","1","2024-01-19 04:36:49");
INSERT INTO tbl_purchase VALUES("1094","PUR190124102","","SU","59","0.00","55500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55500.00","0","","","2024-01-19","","55500.00","0.00","","LE_2","","0","1","2024-01-19 07:15:11");
INSERT INTO tbl_purchase VALUES("1095","PUR210124101","","SU","67","0.00","9810.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9810.00","0","","","2024-01-21","2024-01-28","0.00","0.00","","LE_2","","0","1","2024-01-21 08:36:46");
INSERT INTO tbl_purchase VALUES("1096","PUR220124101","","SU","2","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2024-01-22","2024-01-29","0.00","0.00","","LE_2","","0","1","2024-01-22 05:29:25");
INSERT INTO tbl_purchase VALUES("1097","PUR220124102","","SU","8","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2024-01-22","","65000.00","0.00","","LE_2","","0","1","2024-01-22 06:44:21");
INSERT INTO tbl_purchase VALUES("1098","PUR230124101","","SU","59","0.00","50400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50400.00","0","","","2024-01-23","","50400.00","0.00","","LE_2","","0","1","2024-01-23 06:22:59");
INSERT INTO tbl_purchase VALUES("1099","PUR240124101","","SU","55","0.00","7400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7400.00","0","","","2024-01-24","2024-01-31","0.00","0.00","","LE_2","","0","1","2024-01-24 02:05:43");
INSERT INTO tbl_purchase VALUES("1100","PUR240124102","","SU","51","0.00","8000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8000.00","0","","","2024-01-24","","8000.00","0.00","","LE_2","","0","1","2024-01-24 08:09:57");
INSERT INTO tbl_purchase VALUES("1101","PUR250124101","","SU","59","0.00","31850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31850.00","0","","","2024-01-25","","31850.00","0.00","","LE_2","","0","1","2024-01-25 05:16:31");
INSERT INTO tbl_purchase VALUES("1102","PUR250124102","","SU","19","0.00","38807.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38807.50","0","","","2024-01-25","","38807.50","0.00","","LE_2","","0","1","2024-01-25 08:26:15");
INSERT INTO tbl_purchase VALUES("1103","PUR290124101","","SU","40","0.00","22956.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22956.50","0","","","2024-01-29","2024-02-05","0.00","0.00","","LE_2","","0","1","2024-01-29 07:32:48");
INSERT INTO tbl_purchase VALUES("1104","PUR300124101","","SU","37","0.00","68740.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68740.00","0","","","2024-01-30","2024-02-06","0.00","0.00","","LE_2","","0","1","2024-01-30 01:26:55");
INSERT INTO tbl_purchase VALUES("1105","PUR300124102","","SU","19","0.00","9500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9500.00","0","","","2024-01-30","","9500.00","0.00","","LE_2","","0","1","2024-01-30 08:46:50");
INSERT INTO tbl_purchase VALUES("1107","PUR310124102","","SU","59","0.00","92280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","92280.00","0","","","2024-01-31","","92280.00","0.00","","LE_2","","0","1","2024-01-31 06:52:47");
INSERT INTO tbl_purchase VALUES("1108","PUR310124103","","SU","2","0.00","20600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20600.00","0","","","2024-01-31","","20600.00","0.00","","LE_2","","0","1","2024-01-31 06:23:50");
INSERT INTO tbl_purchase VALUES("1109","PUR310124104","","SU","2","0.00","41200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41200.00","0","","","2024-01-31","","41200.00","0.00","","LE_2","","0","1","2024-01-31 06:49:34");
INSERT INTO tbl_purchase VALUES("1110","PUR310124105","","SU","40","0.00","5586.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5586.00","0","","","2024-01-31","","5586.00","0.00","","LE_2","","0","1","2024-01-31 07:32:11");
INSERT INTO tbl_purchase VALUES("1111","PUR310124106","","SU","19","0.00","120450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","120450.00","0","","","2024-01-31","","120450.00","0.00","","LE_2","","0","1","2024-01-31 10:23:16");
INSERT INTO tbl_purchase VALUES("1112","PUR010224101","","SU","59","0.00","44600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","44600.00","0","","","2024-02-01","","44600.00","0.00","","LE_2","","0","1","2024-02-01 01:43:59");
INSERT INTO tbl_purchase VALUES("1113","PUR010224102","","SU","59","0.00","149000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","149000.00","0","","","2024-02-01","","149000.00","0.00","","LE_2","","0","1","2024-02-01 02:13:09");
INSERT INTO tbl_purchase VALUES("1114","PUR010224103","","SU","59","0.00","26100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26100.00","0","","","2024-02-01","","26100.00","0.00","","LE_2","","0","1","2024-02-01 02:55:36");
INSERT INTO tbl_purchase VALUES("1115","PUR010224104","","SU","39","0.00","43800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43800.00","0","","","2024-02-01","","43800.00","0.00","","LE_2","","0","1","2024-02-01 02:43:12");
INSERT INTO tbl_purchase VALUES("1116","PUR020224101","","SU","2","0.00","247200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","247200.00","0","","","2024-02-02","","247200.00","0.00","","LE_2","","0","1","2024-02-02 07:53:42");
INSERT INTO tbl_purchase VALUES("1117","PUR030224101","","SU","40","0.00","33187.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33187.30","0","","","2024-02-03","","33187.30","0.00","","LE_2","","0","1","2024-02-03 03:57:11");
INSERT INTO tbl_purchase VALUES("1118","PUR030224102","","SU","39","0.00","22997.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22997.00","0","","","2024-02-03","","22997.00","0.00","","LE_2","","0","1","2024-02-03 05:57:40");
INSERT INTO tbl_purchase VALUES("1119","PUR040224101","","SU","55","0.00","6850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6850.00","0","","","2024-02-04","2024-02-11","0.00","0.00","","LE_2","","0","1","2024-02-04 02:04:15");
INSERT INTO tbl_purchase VALUES("1120","PUR040224102","","SU","4","0.00","40500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40500.00","0","","","2024-02-04","","40500.00","0.00","","LE_2","","0","1","2024-02-04 02:24:18");
INSERT INTO tbl_purchase VALUES("1121","PUR040224103","","SU","37","0.00","14715.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14715.00","0","","","2024-02-04","","14715.00","0.00","","LE_2","","0","1","2024-02-04 04:40:21");
INSERT INTO tbl_purchase VALUES("1122","PUR060224101","","SU","67","0.00","22633.42","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22633.42","0","","","2024-02-06","2024-02-13","0.00","0.00","","LE_2","","0","1","2024-02-06 01:46:41");
INSERT INTO tbl_purchase VALUES("1123","PUR060224102","","SU","13","0.00","59612.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","59612.00","0","","","2024-02-06","","59612.00","0.00","","LE_2","","0","1","2024-06-11 08:05:19");
INSERT INTO tbl_purchase VALUES("1124","PUR060224103","","SU","19","0.00","583812.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","583812.50","0","","","2024-02-06","","583812.50","0.00","","LE_2","","0","1","2024-02-06 09:45:45");
INSERT INTO tbl_purchase VALUES("1125","PUR060224104","","SU","68","0.00","6600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6600.00","0","","","2024-02-06","","6600.00","0.00","","LE_2","","0","1","2024-02-06 10:03:31");
INSERT INTO tbl_purchase VALUES("1126","PUR080224101","","SU","40","0.00","10915.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10915.50","0","","","2024-02-08","","10915.50","0.00","","LE_2","","0","1","2024-02-08 05:44:14");
INSERT INTO tbl_purchase VALUES("1127","PUR080224102","","SU","51","0.00","7930.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7930.00","0","","","2024-02-07","","7930.00","0.00","","LE_2","","0","1","2024-02-08 06:14:13");
INSERT INTO tbl_purchase VALUES("1128","PUR080224103","","SU","13","0.00","130946.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130946.00","0","","","2024-02-08","","130946.00","0.00","","LE_2","","0","1","2024-02-08 07:27:39");
INSERT INTO tbl_purchase VALUES("1129","PUR090224101","","SU","34","0.00","140500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140500.00","0","","","2024-02-09","","140500.00","0.00","","LE_2","","0","1","2024-02-09 04:54:55");
INSERT INTO tbl_purchase VALUES("1130","PUR090224102","","SU","19","0.00","190000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","190000.00","0","","","2024-02-09","","190000.00","0.00","","LE_2","","0","1","2024-02-10 09:08:40");
INSERT INTO tbl_purchase VALUES("1131","PUR090224103","","SU","5","0.00","62000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","62000.00","0","","","2024-02-09","","62000.00","0.00","","LE_2","","0","1","2024-02-09 05:54:50");
INSERT INTO tbl_purchase VALUES("1132","PUR090224104","","SU","39","0.00","15100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15100.00","0","","","2024-02-09","","15100.00","0.00","","LE_2","","0","1","2024-02-09 05:56:45");
INSERT INTO tbl_purchase VALUES("1133","PUR100224101","","SU","67","0.00","3125.03","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3125.03","0","","","2024-02-10","2024-02-17","0.00","0.00","","LE_2","","0","1","2024-02-10 04:09:05");
INSERT INTO tbl_purchase VALUES("1134","PUR120224101","","SU","39","0.00","180.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","180.00","0","","","2024-02-11","","180.00","0.00","","LE_2","","0","1","2024-02-12 01:49:54");
INSERT INTO tbl_purchase VALUES("1135","PUR130224101","","SU","40","0.00","5500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5500.00","0","","","2024-02-13","","5500.00","0.00","","LE_2","","0","1","2024-02-13 01:56:07");
INSERT INTO tbl_purchase VALUES("1136","PUR140224101","","SU","16","0.00","55420.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55420.00","0","","","2024-02-14","","55420.00","0.00","","LE_2","","0","1","2024-02-14 02:09:44");
INSERT INTO tbl_purchase VALUES("1137","PUR140224102","","SU","39","0.00","3030.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3030.00","0","","","2024-02-14","","3030.00","0.00","","LE_2","","0","1","2024-02-14 07:36:13");
INSERT INTO tbl_purchase VALUES("1138","PUR150224101","","SU","34","0.00","131000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","131000.00","0","","","2024-02-15","","131000.00","0.00","","LE_2","","0","1","2024-02-15 11:37:20");
INSERT INTO tbl_purchase VALUES("1139","PUR150224102","","SU","19","0.00","265750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","265750.00","0","","","2024-02-15","","265750.00","0.00","","LE_2","","0","1","2024-02-15 01:29:22");
INSERT INTO tbl_purchase VALUES("1140","PUR150224103","","SU","33","0.00","16750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16750.00","0","","","2024-02-15","","16750.00","0.00","","LE_2","","0","1","2024-02-15 04:44:04");
INSERT INTO tbl_purchase VALUES("1141","PUR150224104","","SU","40","0.00","1000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1000.00","0","","","2024-02-15","","1000.00","0.00","","LE_2","","0","1","2024-02-15 07:33:59");
INSERT INTO tbl_purchase VALUES("1142","PUR150224105","","SU","39","0.00","51475.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51475.00","0","","","2024-02-15","","51475.00","0.00","","LE_2","","0","1","2024-02-15 08:46:16");
INSERT INTO tbl_purchase VALUES("1143","PUR150224106","","SU","39","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2024-01-30","","30000.00","0.00","","LE_2","","0","1","2024-02-15 09:09:29");
INSERT INTO tbl_purchase VALUES("1144","PUR180224101","","SU","12","0.00","4300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4300.00","0","","","2024-02-18","","4300.00","0.00","","LE_2","","0","1","2024-02-18 01:34:20");
INSERT INTO tbl_purchase VALUES("1145","PUR180224102","","SU","34","0.00","75000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","75000.00","0","","","2024-02-18","","75000.00","0.00","","LE_2","","0","1","2024-02-18 04:26:32");
INSERT INTO tbl_purchase VALUES("1146","PUR180224103","","SU","69","0.00","134750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134750.00","0","","","2024-02-18","","134750.00","0.00","","LE_2","","0","1","2024-02-18 06:58:31");
INSERT INTO tbl_purchase VALUES("1147","PUR190224101","","SU","40","0.00","9123.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9123.00","0","","","2024-02-19","","9123.00","0.00","","LE_2","","0","1","2024-02-19 11:06:04");
INSERT INTO tbl_purchase VALUES("1148","PUR200224101","","SU","2","0.00","28510.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28510.00","0","","","2024-02-20","","28510.00","0.00","","LE_2","","0","1","2024-02-20 01:30:05");
INSERT INTO tbl_purchase VALUES("1149","PUR200224102","","SU","70","0.00","51500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51500.00","0","","","2024-02-20","","51500.00","0.00","","LE_2","","0","1","2024-02-20 05:29:32");
INSERT INTO tbl_purchase VALUES("1150","PUR200224103","","SU","40","0.00","22710.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22710.70","0","","","2024-02-20","","22710.70","0.00","","LE_2","","0","1","2024-02-20 07:51:06");
INSERT INTO tbl_purchase VALUES("1151","PUR210224101","","SU","39","0.00","10700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10700.00","0","","","2024-02-21","","10700.00","0.00","","LE_2","","0","1","2024-02-21 12:50:01");
INSERT INTO tbl_purchase VALUES("1152","PUR210224102","","SU","59","0.00","85100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85100.00","0","","","2024-02-21","","85100.00","0.00","","LE_2","","0","1","2024-02-21 01:57:10");
INSERT INTO tbl_purchase VALUES("1153","PUR220224101","","SU","40","0.00","10792.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10792.00","0","","","2024-02-22","","10792.00","0.00","","LE_2","","0","1","2024-02-22 04:25:13");
INSERT INTO tbl_purchase VALUES("1154","PUR230224101","","SU","2","0.00","106000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106000.00","0","","","2024-02-23","","106000.00","0.00","","LE_2","","0","1","2024-02-23 05:02:45");
INSERT INTO tbl_purchase VALUES("1155","PUR280224101","","SU","46","0.00","690.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","690.00","0","","","2024-02-28","","690.00","0.00","","LE_2","","0","1","2024-02-28 10:20:02");
INSERT INTO tbl_purchase VALUES("1156","PUR290224101","","SU","59","0.00","116000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","116000.00","0","","","2024-02-29","","116000.00","0.00","","LE_2","","0","1","2024-02-29 04:47:30");
INSERT INTO tbl_purchase VALUES("1157","PUR290224102","","SU","2","0.00","63600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63600.00","0","","","2024-02-29","","63600.00","0.00","","LE_2","","0","1","2024-02-29 04:22:57");
INSERT INTO tbl_purchase VALUES("1158","PUR290224103","","SU","10","0.00","23074.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23074.00","0","","","2024-02-29","","23074.00","0.00","","LE_2","","0","1","2024-02-29 04:26:21");
INSERT INTO tbl_purchase VALUES("1159","PUR290224104","","SU","71","0.00","67100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","67100.00","0","","","2024-02-29","2024-03-07","0.00","0.00","","LE_2","","0","1","2024-02-29 08:20:08");
INSERT INTO tbl_purchase VALUES("1160","PUR290224105","","SU","59","0.00","840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","840.00","0","","","2024-02-29","","840.00","0.00","","LE_2","","0","1","2024-02-29 08:39:30");
INSERT INTO tbl_purchase VALUES("1161","PUR020324101","","SU","42","0.00","11430.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11430.30","0","","","2024-03-02","","11430.30","0.00","","LE_2","","0","1","2024-03-02 10:33:32");
INSERT INTO tbl_purchase VALUES("1162","PUR040324101","","SU","37","0.00","29785.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29785.00","0","","","2024-03-04","","29785.00","0.00","","LE_2","","0","1","2024-03-04 01:53:08");
INSERT INTO tbl_purchase VALUES("1163","PUR040324102","","SU","13","0.00","465600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","465600.00","0","","","2024-03-04","","465600.00","0.00","","LE_2","","0","1","2024-03-04 06:42:11");
INSERT INTO tbl_purchase VALUES("1164","PUR050324101","","SU","40","0.00","22941.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22941.70","0","","","2024-03-05","","22941.70","0.00","","LE_2","","0","1","2024-03-05 10:02:25");
INSERT INTO tbl_purchase VALUES("1165","PUR060324101","","SU","39","0.00","7700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7700.00","0","","","2024-03-06","","7700.00","0.00","","LE_2","","0","1","2024-03-06 06:28:34");
INSERT INTO tbl_purchase VALUES("1166","PUR080324101","","SU","40","0.00","10991.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10991.50","0","","","2024-03-08","","10991.50","0.00","","LE_2","","0","1","2024-03-08 10:42:19");
INSERT INTO tbl_purchase VALUES("1167","PUR100324101","","SU","34","0.00","206500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","206500.00","0","","","2024-03-10","","206500.00","0.00","","LE_2","","0","1","2024-03-10 03:28:32");
INSERT INTO tbl_purchase VALUES("1168","PUR100324102","","SU","39","0.00","7335.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7335.00","0","","","2024-03-10","","7335.00","0.00","","LE_2","","0","1","2024-03-10 07:40:00");
INSERT INTO tbl_purchase VALUES("1169","PUR120324101","","SU","39","0.00","5600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5600.00","0","","","2024-03-12","","5600.00","0.00","","LE_2","","0","1","2024-03-12 02:33:46");
INSERT INTO tbl_purchase VALUES("1170","PUR120324102","","SU","34","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2024-03-12","","16000.00","0.00","","LE_2","","0","1","2024-03-12 02:47:33");
INSERT INTO tbl_purchase VALUES("1171","PUR130324101","","SU","34","0.00","10100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10100.00","0","","","2024-03-13","","10100.00","0.00","","LE_2","","0","1","2024-03-13 03:22:26");
INSERT INTO tbl_purchase VALUES("1172","PUR130324102","","SU","33","0.00","45994.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45994.00","0","","","2024-03-13","","45994.00","0.00","","LE_2","","0","1","2024-03-13 03:26:38");
INSERT INTO tbl_purchase VALUES("1173","PUR140324101","","SU","39","0.00","1962.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1962.00","0","","","2024-03-14","","1962.00","0.00","","LE_2","","0","1","2024-03-14 07:23:22");
INSERT INTO tbl_purchase VALUES("1176","PUR150324101","","SU","26","0.00","37720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37720.00","0","","","2024-03-15","","37720.00","0.00","","LE_2","","0","1","2024-03-15 01:28:11");
INSERT INTO tbl_purchase VALUES("1177","PUR180324101","","SU","40","0.00","9615.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9615.90","0","","","2024-03-18","2024-03-25","9615.90","0.00","","LE_2","","0","1","2024-03-18 08:42:47");
INSERT INTO tbl_purchase VALUES("1178","PUR200324101","","SU","6","0.00","64750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","64750.00","0","","","2024-03-20","","64750.00","0.00","","LE_2","","0","1","2024-03-20 05:29:51");
INSERT INTO tbl_purchase VALUES("1179","PUR200324102","","SU","40","0.00","21547.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21547.90","0","","","2024-03-20","","21547.90","0.00","","LE_2","","0","1","2024-03-20 05:18:14");
INSERT INTO tbl_purchase VALUES("1180","PUR200324103","","SU","39","0.00","42000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","42000.00","0","","","2024-03-20","","42000.00","0.00","","LE_2","","0","1","2024-03-20 07:11:28");
INSERT INTO tbl_purchase VALUES("1181","PUR210324101","","SU","10","0.00","30200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30200.00","0","","","2024-03-21","","30200.00","0.00","","LE_2","","0","1","2024-03-21 01:21:39");
INSERT INTO tbl_purchase VALUES("1182","PUR220324101","","SU","71","0.00","65450.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65450.00","0","","","2024-03-22","2024-03-29","20450.00","0.00","","LE_2","","0","1","2024-03-22 04:24:07");
INSERT INTO tbl_purchase VALUES("1183","PUR240324101","","SU","10","0.00","25000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25000.00","0","","","2024-03-24","","25000.00","0.00","","LE_2","","0","1","2024-03-24 08:38:14");
INSERT INTO tbl_purchase VALUES("1184","PUR240324102","","SU","40","0.00","10592.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10592.50","0","","","2024-03-24","","10592.50","0.00","","LE_2","","0","1","2024-03-24 08:40:04");
INSERT INTO tbl_purchase VALUES("1185","PUR250324101","","SU","59","0.00","23200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23200.00","0","","","2024-03-25","","23200.00","0.00","","LE_2","","0","1","2024-03-25 03:40:14");
INSERT INTO tbl_purchase VALUES("1186","PUR250324102","","SU","59","0.00","8100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8100.00","0","","","2024-03-25","","8100.00","0.00","","LE_2","","0","1","2024-03-25 05:16:56");
INSERT INTO tbl_purchase VALUES("1187","PUR250324103","","SU","34","0.00","16470.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16470.00","0","","","2024-03-25","2024-04-01","0.00","0.00","","LE_2","","0","1","2024-03-25 05:36:04");
INSERT INTO tbl_purchase VALUES("1188","PUR260324101","","SU","59","0.00","23200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23200.00","0","","","2024-03-26","","23200.00","0.00","","LE_2","","0","1","2024-03-26 02:55:50");
INSERT INTO tbl_purchase VALUES("1189","PUR260324102","","SU","34","0.00","63000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63000.00","0","","","2024-03-26","","63000.00","0.00","","LE_2","","0","1","2024-03-26 03:29:00");
INSERT INTO tbl_purchase VALUES("1190","PUR260324103","","SU","5","0.00","39000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39000.00","0","","","2024-03-26","2024-04-02","0.00","0.00","","LE_2","","0","1","2024-03-26 08:24:27");
INSERT INTO tbl_purchase VALUES("1191","PUR270324101","","SU","7","0.00","33500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33500.00","0","","","2024-03-27","","33500.00","0.00","","LE_2","","0","1","2024-03-27 07:56:12");
INSERT INTO tbl_purchase VALUES("1192","PUR290324101","","SU","45","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2024-03-29","","15000.00","0.00","","LE_2","","0","1","2024-03-29 05:06:46");
INSERT INTO tbl_purchase VALUES("1193","PUR010424101","","SU","40","0.00","9000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9000.00","0","","","2024-04-01","","9000.00","0.00","","LE_2","","0","1","2024-04-01 01:37:01");
INSERT INTO tbl_purchase VALUES("1194","PUR010424102","","SU","49","0.00","16500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16500.00","0","","","2024-04-01","","16500.00","0.00","","LE_2","","0","1","2024-04-01 01:41:25");
INSERT INTO tbl_purchase VALUES("1195","PUR010424103","","SU","39","0.00","17573.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17573.00","0","","","2024-04-01","","17573.00","0.00","","LE_2","","0","1","2024-04-01 07:34:32");
INSERT INTO tbl_purchase VALUES("1196","PUR010424104","","SU","13","0.00","58800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","58800.00","0","","","2024-04-01","","58800.00","0.00","","LE_2","","0","1","2024-04-01 08:10:51");
INSERT INTO tbl_purchase VALUES("1197","PUR020424101","","SU","2","0.00","69600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69600.00","0","","","2024-04-02","","69600.00","0.00","","LE_2","","0","1","2024-04-02 03:45:57");
INSERT INTO tbl_purchase VALUES("1198","PUR020424102","","SU","40","0.00","16002.30","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16002.30","0","","","2024-04-02","","16002.30","0.00","","LE_2","","0","1","2024-04-02 08:46:19");
INSERT INTO tbl_purchase VALUES("1199","PUR020424103","","SU","53","0.00","3040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3040.00","0","","","2024-04-02","","3040.00","0.00","","LE_2","","0","1","2024-04-02 09:07:31");
INSERT INTO tbl_purchase VALUES("1200","PUR030424101","","SU","6","0.00","17400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17400.00","0","","","2024-04-03","","17400.00","0.00","","LE_2","","0","1","2024-04-03 12:49:06");
INSERT INTO tbl_purchase VALUES("1201","PUR040424101","","SU","6","0.00","46500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","46500.00","0","","","2024-04-04","","46500.00","0.00","","LE_2","","0","1","2024-04-04 05:30:12");
INSERT INTO tbl_purchase VALUES("1202","PUR060424101","","SU","40","0.00","6403.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6403.00","0","","","2024-04-06","","6403.00","0.00","","LE_2","","0","1","2024-04-06 03:43:43");
INSERT INTO tbl_purchase VALUES("1203","PUR070424101","","SU","34","0.00","130000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","130000.00","0","","","2024-04-07","2024-04-14","0.00","0.00","","LE_2","","0","1","2024-04-07 01:13:50");
INSERT INTO tbl_purchase VALUES("1204","PUR070424102","","SU","40","0.00","19571.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19571.90","0","","","2024-04-07","","19571.90","0.00","","LE_2","","0","1","2024-04-07 01:37:05");
INSERT INTO tbl_purchase VALUES("1205","PUR080424101","","SU","2","0.00","34800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","34800.00","0","","","2024-04-08","","34800.00","0.00","","LE_2","","0","1","2024-04-08 05:51:54");
INSERT INTO tbl_purchase VALUES("1206","PUR080424102","","SU","39","0.00","2500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2500.00","0","","","2024-04-08","","2500.00","0.00","","LE_2","","0","1","2024-04-08 08:42:25");
INSERT INTO tbl_purchase VALUES("1207","PUR090424101","","SU","39","0.00","6649.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6649.00","0","","","2024-04-09","","6649.00","0.00","","LE_2","","0","1","2024-04-09 07:55:19");
INSERT INTO tbl_purchase VALUES("1208","PUR120424101","","SU","40","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2024-04-12","","6000.00","0.00","","LE_2","","0","1","2024-04-12 10:13:37");
INSERT INTO tbl_purchase VALUES("1209","PUR150424101","","SU","61","0.00","1900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1900.00","0","","","2024-04-15","","1900.00","0.00","","LE_2","","0","1","2024-04-15 06:18:16");
INSERT INTO tbl_purchase VALUES("1210","PUR160424101","","SU","38","0.00","245000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","245000.00","0","","","2024-04-16","","245000.00","0.00","","LE_2","","0","1","2024-04-16 03:57:40");
INSERT INTO tbl_purchase VALUES("1211","PUR180424101","","SU","39","0.00","8268.00","5.00","413.40","413.40","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7854.60","0","","","2024-04-18","","7854.60","0.00","","LE_2","","0","1","2024-04-18 09:11:25");
INSERT INTO tbl_purchase VALUES("1212","PUR190424101","","SU","69","0.00","12660.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12660.00","0","","","2024-04-19","","12660.00","0.00","","LE_2","","0","1","2024-04-19 06:38:51");
INSERT INTO tbl_purchase VALUES("1213","PUR190424102","","SU","13","0.00","119700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","119700.00","0","","","2024-04-19","","119700.00","0.00","","LE_2","","0","1","2024-04-19 07:10:58");
INSERT INTO tbl_purchase VALUES("1214","PUR190424103","","SU","39","0.00","3489.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3489.00","0","","","2024-04-19","","3489.00","0.00","","LE_2","","0","1","2024-04-19 07:47:28");
INSERT INTO tbl_purchase VALUES("1215","PUR200424101","","SU","53","0.00","6517.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6517.00","0","","","2024-04-20","","6517.00","0.00","","LE_2","","0","1","2024-04-20 05:00:48");
INSERT INTO tbl_purchase VALUES("1216","PUR230424101","","SU","51","0.00","7500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7500.00","0","","","2024-04-22","","7500.00","0.00","","LE_2","","0","1","2024-04-23 05:44:15");
INSERT INTO tbl_purchase VALUES("1217","PUR230424102","","SU","39","0.00","1962.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1962.00","0","","","2024-04-23","","1962.00","0.00","","LE_2","","0","1","2024-04-23 05:47:06");
INSERT INTO tbl_purchase VALUES("1218","PUR260424101","","SU","40","0.00","5890.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5890.00","0","","","2024-04-26","","5890.00","0.00","","LE_2","","0","1","2024-04-26 12:25:10");
INSERT INTO tbl_purchase VALUES("1219","PUR260424102","","SU","61","0.00","3060.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3060.00","0","","","2024-04-26","","3060.00","0.00","","LE_2","","0","1","2024-04-26 03:17:05");
INSERT INTO tbl_purchase VALUES("1220","PUR280424101","","SU","40","0.00","8540.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8540.50","0","","","2024-04-28","","8540.50","0.00","","LE_2","","0","1","2024-04-28 09:56:32");
INSERT INTO tbl_purchase VALUES("1221","PUR290424101","","SU","2","0.00","106000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106000.00","0","","","2024-04-29","","106000.00","0.00","","LE_2","","0","1","2024-04-29 02:21:53");
INSERT INTO tbl_purchase VALUES("1222","PUR290424102","","SU","59","0.00","48300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48300.00","0","","","2024-04-29","","48300.00","0.00","","LE_2","","0","1","2024-04-29 10:10:13");
INSERT INTO tbl_purchase VALUES("1223","PUR010524101","","SU","38","0.00","113910.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","113910.00","0","","","2024-05-01","","113910.00","0.00","","LE_2","","0","1","2024-05-01 11:48:49");
INSERT INTO tbl_purchase VALUES("1224","PUR010524102","","SU","39","0.00","24000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24000.00","0","","","2024-05-01","","24000.00","0.00","","LE_2","","0","1","2024-05-01 07:11:57");
INSERT INTO tbl_purchase VALUES("1225","PUR010524103","","SU","39","0.00","5913.25","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5913.25","0","","","2024-05-01","2024-05-08","5913.00","0.00","","LE_2","","0","1","2024-05-01 09:18:26");
INSERT INTO tbl_purchase VALUES("1226","PUR020524101","","SU","16","0.00","97590.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","97590.00","0","","","2024-05-02","","97590.00","0.00","","LE_2","","0","1","2024-05-02 05:29:47");
INSERT INTO tbl_purchase VALUES("1227","PUR020524102","","SU","69","0.00","20950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20950.00","0","","","2024-05-02","","20950.00","0.00","","LE_2","","0","1","2024-05-02 07:57:38");
INSERT INTO tbl_purchase VALUES("1228","PUR050524101","","SU","59","0.00","5800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5800.00","0","","","2024-05-05","","5800.00","0.00","","LE_2","","0","1","2024-05-05 12:54:04");
INSERT INTO tbl_purchase VALUES("1229","PUR050524102","","SU","59","0.00","40600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","40600.00","0","","","2024-05-05","","40600.00","0.00","","LE_2","","0","1","2024-05-05 01:44:21");
INSERT INTO tbl_purchase VALUES("1230","PUR050524103","","SU","40","0.00","13699.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13699.00","0","","","2024-05-05","","13699.00","0.00","","LE_2","","0","1","2024-05-05 09:41:33");
INSERT INTO tbl_purchase VALUES("1231","PUR050524104","","SU","39","0.00","2880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2880.00","0","","","2024-05-05","","2880.00","0.00","","LE_2","","0","1","2024-05-05 09:46:32");
INSERT INTO tbl_purchase VALUES("1232","PUR090524101","","SU","2","0.00","125000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","125000.00","0","","","2024-05-09","","125000.00","0.00","","LE_2","","0","1","2024-05-09 07:22:47");
INSERT INTO tbl_purchase VALUES("1233","PUR090524102","","SU","63","0.00","39100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","1173.00","0.00","37927.00","0","","","2024-05-09","","37927.00","0.00","","LE_2","","0","1","2024-05-09 08:14:57");
INSERT INTO tbl_purchase VALUES("1234","PUR090524103","","SU","6","0.00","19500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19500.00","0","","","2024-05-09","","19500.00","0.00","","LE_2","","0","1","2024-05-09 08:25:15");
INSERT INTO tbl_purchase VALUES("1235","PUR090524104","","SU","39","0.00","1056.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1056.00","0","","","2024-05-09","","1056.00","0.00","","LE_2","","0","1","2024-05-09 08:38:56");
INSERT INTO tbl_purchase VALUES("1236","PUR100524101","","SU","12","0.00","43300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43300.00","0","","","2024-05-10","","43300.00","0.00","","LE_2","","0","1","2024-05-10 04:46:22");
INSERT INTO tbl_purchase VALUES("1237","PUR100524102","","SU","12","0.00","13600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13600.00","0","","","2024-05-10","","13600.00","0.00","","LE_2","","0","1","2024-05-10 05:03:22");
INSERT INTO tbl_purchase VALUES("1238","PUR100524103","","SU","59","0.00","51500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","51500.00","0","","","2024-05-10","","51500.00","0.00","","LE_2","","0","1","2024-05-10 08:01:58");
INSERT INTO tbl_purchase VALUES("1239","PUR100524104","","SU","2","0.00","50720.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50720.00","0","","","2024-05-10","","50720.00","0.00","","LE_2","","0","1","2024-05-10 08:29:45");
INSERT INTO tbl_purchase VALUES("1240","PUR120524101","","SU","5","0.00","16800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16800.00","0","","","2023-03-29","","16800.00","0.00","","LE_2","","0","1","2024-05-12 05:48:25");
INSERT INTO tbl_purchase VALUES("1241","PUR120524102","","SU","40","0.00","10921.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10921.20","0","","","2024-05-12","","10921.20","0.00","","LE_2","","0","1","2024-05-12 10:30:14");
INSERT INTO tbl_purchase VALUES("1242","PUR140524101","","SU","19","0.00","91000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91000.00","0","","","2024-05-14","","91000.00","0.00","","LE_2","","0","1","2024-05-14 04:12:49");
INSERT INTO tbl_purchase VALUES("1243","PUR140524102","","SU","19","0.00","43500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","43500.00","0","","","2024-05-14","","43500.00","0.00","","LE_2","","0","1","2024-05-14 04:20:46");
INSERT INTO tbl_purchase VALUES("1244","PUR140524103","","SU","72","0.00","63700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","63700.00","0","","","2024-05-14","","63700.00","0.00","","LE_2","","0","1","2024-05-14 06:34:56");
INSERT INTO tbl_purchase VALUES("1245","PUR140524104","","SU","40","0.00","1700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1700.00","0","","","2024-05-14","","1700.00","0.00","","LE_2","","0","1","2024-05-14 07:50:30");
INSERT INTO tbl_purchase VALUES("1246","PUR150524101","","SU","40","0.00","8341.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","8341.00","0","","","2024-05-15","","8341.00","0.00","","LE_2","","0","1","2024-05-15 08:41:47");
INSERT INTO tbl_purchase VALUES("1247","PUR170524101","","SU","40","0.00","3742.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3742.80","0","","","2024-05-17","","3742.80","0.00","","LE_2","","0","1","2024-05-17 11:54:36");
INSERT INTO tbl_purchase VALUES("1248","PUR170524102","","SU","39","0.00","14800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14800.00","0","","","2024-05-17","","14800.00","0.00","","LE_2","","0","1","2024-05-17 05:48:47");
INSERT INTO tbl_purchase VALUES("1249","PUR170524103","","SU","59","0.00","37500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37500.00","0","","","2024-05-17","","37500.00","0.00","","LE_2","","0","1","2024-05-17 07:33:58");
INSERT INTO tbl_purchase VALUES("1250","PUR180524101","","SU","19","0.00","91045.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91045.50","0","","","2024-05-18","","91045.50","0.00","","LE_2","","0","1","2024-05-18 11:12:38");
INSERT INTO tbl_purchase VALUES("1251","PUR190524101","","SU","5","0.00","88365.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88365.00","0","","","2024-05-19","","88365.00","0.00","","LE_2","","0","1","2024-05-19 12:24:31");
INSERT INTO tbl_purchase VALUES("1252","PUR190524102","","SU","40","0.00","2880.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2880.00","0","","","2024-05-19","","2880.00","0.00","","LE_2","","0","1","2024-05-19 10:23:21");
INSERT INTO tbl_purchase VALUES("1253","PUR220524101","","SU","2","0.00","104670.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","104670.00","0","","","2024-05-22","","104670.00","0.00","","LE_2","","0","1","2024-05-22 06:46:51");
INSERT INTO tbl_purchase VALUES("1254","PUR220524102","","SU","40","0.00","30963.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30963.50","0","","","2024-05-22","","30963.50","0.00","","LE_2","","0","1","2024-05-22 07:54:51");
INSERT INTO tbl_purchase VALUES("1255","PUR240524101","","SU","39","0.00","2139.06","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2139.06","0","","","2024-05-24","","2139.56","0.50","","LE_2","","0","1","2024-05-24 02:53:04");
INSERT INTO tbl_purchase VALUES("1256","PUR240524102","","SU","40","0.00","2700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2700.00","0","","","2024-05-24","","2700.00","0.00","","LE_2","","0","1","2024-05-24 07:27:01");
INSERT INTO tbl_purchase VALUES("1257","PUR260524101","","SU","40","0.00","21542.20","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","21542.20","0","","","2024-05-26","","21542.20","0.00","","LE_2","","0","1","2024-05-26 12:55:41");
INSERT INTO tbl_purchase VALUES("1258","PUR280524101","","SU","2","0.00","105000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","105000.00","0","","","2024-05-28","","105000.00","0.00","","LE_2","","0","1","2024-05-28 01:00:48");
INSERT INTO tbl_purchase VALUES("1259","PUR300524101","","SU","12","0.00","71400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","71400.00","0","","","2024-05-30","","71400.00","0.00","","LE_2","","0","1","2024-05-30 07:50:45");
INSERT INTO tbl_purchase VALUES("1260","PUR020624101","","SU","40","0.00","11821.80","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11821.80","0","","","2024-06-02","","11821.80","0.00","","LE_2","","0","1","2024-06-02 07:54:52");
INSERT INTO tbl_purchase VALUES("1261","PUR030624101","","SU","6","0.00","14950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","14950.00","0","","","2024-06-03","","14950.00","0.00","","LE_2","","0","1","2024-06-03 11:26:30");
INSERT INTO tbl_purchase VALUES("1262","PUR030624102","","SU","6","0.00","56170.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56170.00","0","","","2024-06-03","","56170.00","0.00","","LE_2","","0","1","2024-06-03 11:56:01");
INSERT INTO tbl_purchase VALUES("1263","PUR040624101","","SU","26","0.00","5400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5400.00","0","","","2024-06-04","","5400.00","0.00","","LE_2","","0","1","2024-06-04 03:55:03");
INSERT INTO tbl_purchase VALUES("1264","PUR040624102","","SU","34","0.00","65500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65500.00","0","","","2024-06-04","","65500.00","0.00","","LE_2","","0","1","2024-06-04 06:56:27");
INSERT INTO tbl_purchase VALUES("1265","PUR040624103","","SU","40","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2024-06-04","","6000.00","0.00","","LE_2","","0","1","2024-06-04 07:05:19");
INSERT INTO tbl_purchase VALUES("1266","PUR060624101","","SU","13","0.00","55700.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55700.00","0","","","2024-06-06","","55700.00","0.00","","LE_2","","0","1","2024-06-06 08:36:55");
INSERT INTO tbl_purchase VALUES("1267","PUR070624101","","SU","40","0.00","7488.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7488.00","0","","","2024-06-07","","7488.00","0.00","","LE_2","","0","1","2024-06-07 04:55:47");
INSERT INTO tbl_purchase VALUES("1268","PUR090624101","","SU","40","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2024-06-09","","6000.00","0.00","","LE_2","","0","1","2024-06-09 12:55:38");
INSERT INTO tbl_purchase VALUES("1269","PUR090624102","","SU","39","0.00","159500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","159500.00","0","","","2024-06-09","2024-06-16","0.00","0.00","","LE_2","","0","1","2024-06-09 12:59:52");
INSERT INTO tbl_purchase VALUES("1270","PUR090624103","","SU","19","0.00","102645.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","102645.00","0","","","2024-06-09","","102645.00","0.00","","LE_2","","0","1","2024-06-09 06:57:55");
INSERT INTO tbl_purchase VALUES("1271","PUR090624104","","SU","40","0.00","24603.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","24603.10","0","","","2024-06-09","","24603.10","0.00","","LE_2","","0","1","2024-06-09 08:25:37");
INSERT INTO tbl_purchase VALUES("1273","PUR110624102","","SU","2","0.00","201200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","201200.00","0","","","2024-06-11","","201200.00","0.00","","LE_2","","0","1","2024-06-11 06:31:28");
INSERT INTO tbl_purchase VALUES("1274","PUR110624103","","SU","6","0.00","16000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16000.00","0","","","2024-06-11","","16000.00","0.00","","LE_2","","0","1","2024-06-11 08:35:48");
INSERT INTO tbl_purchase VALUES("1275","PUR120624101","","SU","43","0.00","4530.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4530.00","0","","","2024-06-12","","4530.00","0.00","","LE_2","","0","1","2024-06-12 12:26:51");
INSERT INTO tbl_purchase VALUES("1276","PUR130624101","","SU","6","0.00","29300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29300.00","0","","","2024-06-13","","29300.00","0.00","","LE_2","","0","1","2024-06-13 09:04:11");
INSERT INTO tbl_purchase VALUES("1277","PUR140624101","","SU","40","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2024-06-14","","6000.00","0.00","","LE_2","","0","1","2024-06-14 08:18:57");
INSERT INTO tbl_purchase VALUES("1278","PUR150624101","","SU","7","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2024-06-15","","35000.00","0.00","","LE_2","","0","1","2024-06-15 06:18:00");
INSERT INTO tbl_purchase VALUES("1279","PUR150624102","","SU","40","0.00","25887.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25887.50","0","","","2024-06-15","","25887.50","0.00","","LE_2","","0","1","2024-06-15 10:02:44");
INSERT INTO tbl_purchase VALUES("1280","PUR160624101","","SU","2","0.00","69600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69600.00","0","","","2024-06-16","","69600.00","0.00","","LE_2","","0","1","2024-06-16 04:12:13");
INSERT INTO tbl_purchase VALUES("1281","PUR160624102","","SU","40","0.00","12085.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12085.90","0","","","2024-06-16","","12085.90","0.00","","LE_2","","0","1","2024-06-16 06:27:59");
INSERT INTO tbl_purchase VALUES("1282","PUR250624101","","SU","5","0.00","30000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","30000.00","0","","","2024-06-25","","30000.00","0.00","","LE_2","","0","1","2024-06-25 07:29:36");
INSERT INTO tbl_purchase VALUES("1283","PUR260624101","","SU","51","0.00","7010.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7010.00","0","","","2024-06-26","","7010.00","0.00","","LE_2","","0","1","2024-06-26 11:09:02");
INSERT INTO tbl_purchase VALUES("1284","PUR270624101","","SU","39","0.00","1900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1900.00","0","","","2024-06-27","","1900.00","0.00","","LE_2","","0","1","2024-06-27 03:45:35");
INSERT INTO tbl_purchase VALUES("1285","PUR280624101","","SU","12","0.00","114300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","114300.00","0","","","2024-06-28","","114300.00","0.00","","LE_2","","0","1","2024-06-28 11:47:40");
INSERT INTO tbl_purchase VALUES("1286","PUR280624102","","SU","19","0.00","91000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","91000.00","0","","","2024-06-28","","91000.00","0.00","","LE_2","","0","1","2024-06-28 11:44:10");
INSERT INTO tbl_purchase VALUES("1287","PUR280624103","","SU","34","0.00","72500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","72500.00","0","","","2024-06-28","","72500.00","0.00","","LE_2","","0","1","2024-06-28 11:40:21");
INSERT INTO tbl_purchase VALUES("1288","PUR280624104","","SU","39","0.00","4278.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4278.00","0","","","2024-06-28","","4278.00","0.00","","LE_2","","0","1","2024-06-28 08:19:37");
INSERT INTO tbl_purchase VALUES("1289","PUR010724101","","SU","40","0.00","18545.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18545.90","0","","","2024-07-01","","18545.90","0.00","","LE_2","","0","1","2024-07-01 07:05:20");
INSERT INTO tbl_purchase VALUES("1290","PUR030724101","","SU","40","0.00","7000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7000.00","0","","","2024-07-03","","7000.00","0.00","","LE_2","","0","1","2024-07-03 08:55:47");
INSERT INTO tbl_purchase VALUES("1291","PUR060724101","","SU","71","0.00","60000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","60000.00","0","","","2024-07-06","","60000.00","0.00","","LE_2","","0","1","2024-07-06 04:53:35");
INSERT INTO tbl_purchase VALUES("1292","PUR060724102","","SU","71","0.00","7200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7200.00","0","","","2024-07-06","","7200.00","0.00","","LE_2","","0","1","2024-07-06 10:18:50");
INSERT INTO tbl_purchase VALUES("1293","PUR070724101","","SU","71","0.00","76800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76800.00","0","","","2024-07-07","","76800.00","0.00","","LE_2","","0","1","2024-07-07 03:05:59");
INSERT INTO tbl_purchase VALUES("1294","PUR070724102","","SU","34","0.00","62500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","62500.00","0","","","2024-07-07","","62500.00","0.00","","LE_2","","0","1","2024-07-07 05:01:24");
INSERT INTO tbl_purchase VALUES("1295","PUR070724103","","SU","34","0.00","62500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","62500.00","0","","","2024-07-07","","62500.00","0.00","","LE_2","","0","1","2024-07-07 05:25:47");
INSERT INTO tbl_purchase VALUES("1296","PUR070724104","","SU","40","0.00","6422.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6422.00","0","","","2024-07-07","","6422.00","0.00","","LE_2","","0","1","2024-07-07 09:16:53");
INSERT INTO tbl_purchase VALUES("1297","PUR080724101","","SU","59","0.00","39900.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","39900.00","0","","","2024-07-08","","39900.00","0.00","","LE_2","","0","1","2024-07-08 07:13:37");
INSERT INTO tbl_purchase VALUES("1298","PUR080724102","","SU","34","0.00","56500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","56500.00","0","","","2024-07-08","","56500.00","0.00","","LE_2","","0","1","2024-07-08 07:43:23");
INSERT INTO tbl_purchase VALUES("1299","PUR090724101","","SU","40","0.00","18943.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","18943.00","0","","","2024-07-09","","18943.00","0.00","","LE_2","","0","1","2024-07-09 08:16:22");
INSERT INTO tbl_purchase VALUES("1300","PUR100724101","","SU","13","0.00","69850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69850.00","0","","","2024-07-10","","69850.00","0.00","","LE_2","","0","1","2024-07-10 07:47:08");
INSERT INTO tbl_purchase VALUES("1301","PUR110724101","","SU","2","0.00","106000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","106000.00","0","","","2024-07-11","","106000.00","0.00","","LE_2","","0","1","2024-07-12 10:44:57");
INSERT INTO tbl_purchase VALUES("1302","PUR120724101","","SU","43","0.00","16800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16800.00","0","","","2024-07-12","2024-07-19","0.00","0.00","","LE_2","","0","1","2024-07-12 06:56:48");
INSERT INTO tbl_purchase VALUES("1303","PUR120724102","","SU","6","0.00","13600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13600.00","0","","","2024-07-12","","13600.00","0.00","","LE_2","","0","1","2024-07-12 06:53:47");
INSERT INTO tbl_purchase VALUES("1304","PUR140724101","","SU","40","0.00","7484.10","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7484.10","0","","","2024-07-14","","7484.10","0.00","","LE_2","","0","1","2024-07-14 09:23:16");
INSERT INTO tbl_purchase VALUES("1305","PUR150724101","","SU","2","0.00","112500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","112500.00","0","","","2024-07-15","","112500.00","0.00","","LE_2","","0","1","2024-07-15 01:22:02");
INSERT INTO tbl_purchase VALUES("1306","PUR150724102","","SU","19","0.00","47500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47500.00","0","","","2024-07-15","","47500.00","0.00","","LE_2","","0","1","2024-07-15 05:55:14");
INSERT INTO tbl_purchase VALUES("1307","PUR160724101","","SU","16","0.00","50000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","50000.00","0","","","2024-07-16","","50000.00","0.00","","LE_2","","0","1","2024-07-16 07:53:11");
INSERT INTO tbl_purchase VALUES("1308","PUR170724101","","SU","19","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-07-17","","95000.00","0.00","","LE_2","","0","1","2024-07-17 05:33:09");
INSERT INTO tbl_purchase VALUES("1309","PUR170724102","","SU","40","0.00","12408.90","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12408.90","0","","","2024-07-17","","12408.90","0.00","","LE_2","","0","1","2024-07-17 06:54:00");
INSERT INTO tbl_purchase VALUES("1310","PUR250724101","","SU","7","0.00","35000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35000.00","0","","","2024-07-25","","35000.00","0.00","","LE_2","","0","1","2024-07-25 02:25:59");
INSERT INTO tbl_purchase VALUES("1311","PUR260724101","","SU","40","0.00","11409.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11409.50","0","","","2024-07-26","","11409.50","0.00","","LE_2","","0","1","2024-07-26 05:36:39");
INSERT INTO tbl_purchase VALUES("1312","PUR280724101","","SU","34","0.00","5240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5240.00","0","","","2024-07-28","","5240.00","0.00","","LE_2","","0","1","2024-07-28 11:39:23");
INSERT INTO tbl_purchase VALUES("1313","PUR280724102","","SU","63","0.00","86000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","86000.00","0","","","2024-07-28","","86000.00","0.00","","LE_2","","0","1","2024-07-28 12:34:14");
INSERT INTO tbl_purchase VALUES("1316","PUR280724105","","SU","34","0.00","31440.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","31440.00","0","","","2024-07-28","","31440.00","0.00","","LE_2","","0","1","2024-07-28 05:00:57");
INSERT INTO tbl_purchase VALUES("1317","PUR290724101","","SU","2","0.00","140240.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","140240.00","0","","","2024-07-29","","140240.00","0.00","","LE_2","","0","1","2024-07-29 12:26:53");
INSERT INTO tbl_purchase VALUES("1318","PUR290724102","","SU","19","0.00","142500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","142500.00","0","","","2024-07-29","","142500.00","0.00","","LE_2","","0","1","2024-07-29 12:36:10");
INSERT INTO tbl_purchase VALUES("1319","PUR290724103","","SU","5","0.00","47250.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","47250.00","0","","","2024-07-29","","47250.00","0.00","","LE_2","","0","1","2024-07-29 10:26:18");
INSERT INTO tbl_purchase VALUES("1320","PUR020824101","","SU","6","0.00","12200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","12200.00","0","","","2024-08-02","","12200.00","0.00","","LE_2","","0","1","2024-08-02 05:35:36");
INSERT INTO tbl_purchase VALUES("1321","PUR040824101","","SU","39","0.00","68400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68400.00","0","","","2024-08-04","","68400.00","0.00","","LE_2","","0","1","2024-08-04 12:30:11");
INSERT INTO tbl_purchase VALUES("1322","PUR040824102","","SU","39","0.00","73800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","73800.00","0","","","2024-08-04","","73800.00","0.00","","LE_2","","0","1","2024-08-04 01:32:58");
INSERT INTO tbl_purchase VALUES("1323","PUR080824101","","SU","2","0.00","128200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","128200.00","0","","","2024-08-08","","128200.00","0.00","","LE_2","","0","1","2024-08-08 04:25:30");
INSERT INTO tbl_purchase VALUES("1324","PUR080824102","","SU","53","0.00","4812.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4812.00","0","","","2024-08-08","","4812.00","0.00","","LE_2","","0","1","2024-08-08 08:46:10");
INSERT INTO tbl_purchase VALUES("1325","PUR080824103","","SU","34","0.00","45000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45000.00","0","","","2024-08-08","","45000.00","0.00","","LE_2","","0","1","2024-08-08 11:13:23");
INSERT INTO tbl_purchase VALUES("1326","PUR080824104","","SU","34","0.00","4050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4050.00","0","","","2024-08-08","","4050.00","0.00","","LE_2","","0","1","2024-08-08 11:23:50");
INSERT INTO tbl_purchase VALUES("1327","PUR090824101","","SU","40","0.00","17546.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17546.50","0","","","2024-08-09","","17546.50","0.00","","LE_2","","0","1","2024-08-09 11:25:26");
INSERT INTO tbl_purchase VALUES("1328","PUR090824102","","SU","34","0.00","65500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65500.00","0","","","2024-08-09","","65500.00","0.00","","LE_2","","0","1","2024-08-09 01:18:05");
INSERT INTO tbl_purchase VALUES("1329","PUR090824103","","SU","71","0.00","55500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55500.00","0","","","2024-08-09","","55500.00","0.00","","LE_2","","0","1","2024-08-09 02:08:15");
INSERT INTO tbl_purchase VALUES("1330","PUR090824104","","SU","2","0.00","88960.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","88960.00","0","","","2024-08-09","","88960.00","0.00","","LE_2","","0","1","2024-08-09 02:35:20");
INSERT INTO tbl_purchase VALUES("1331","PUR090824105","","SU","39","0.00","7750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","7750.00","0","","","2024-08-09","","7750.00","0.00","","LE_2","","0","1","2024-08-09 04:41:58");
INSERT INTO tbl_purchase VALUES("1332","PUR100824101","","SU","19","0.00","76000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","76000.00","0","","","2024-08-10","","76000.00","0.00","","LE_2","","0","1","2024-08-10 04:03:06");
INSERT INTO tbl_purchase VALUES("1333","PUR100824102","","SU","71","0.00","80000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80000.00","0","","","2024-08-10","","80000.00","0.00","","LE_2","","0","1","2024-08-10 07:18:07");
INSERT INTO tbl_purchase VALUES("1334","PUR100824103","","SU","34","0.00","123500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","123500.00","0","","","2024-08-10","","123500.00","0.00","","LE_2","","0","1","2024-08-10 07:25:13");
INSERT INTO tbl_purchase VALUES("1335","PUR100824104","","SU","53","0.00","16878.40","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16878.40","0","","","2024-08-10","","16878.40","0.00","","LE_2","","0","1","2024-08-10 11:41:35");
INSERT INTO tbl_purchase VALUES("1337","PUR100824106","","SU","13","0.00","38100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38100.00","0","","","2024-08-10","","38100.00","0.00","","LE_2","","0","1","2024-08-10 11:48:10");
INSERT INTO tbl_purchase VALUES("1338","PUR110824101","","SU","19","0.00","19000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","19000.00","0","","","2024-08-11","","19000.00","0.00","","LE_2","","0","1","2024-08-11 12:11:08");
INSERT INTO tbl_purchase VALUES("1339","PUR110824102","","SU","19","0.00","95000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","95000.00","0","","","2024-08-11","","95000.00","0.00","","LE_2","","0","1","2024-08-11 06:48:25");
INSERT INTO tbl_purchase VALUES("1340","PUR110824103","","SU","40","0.00","23470.70","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","23470.70","0","","","2024-08-11","","23470.70","0.00","","LE_2","","0","1","2024-08-11 09:21:50");
INSERT INTO tbl_purchase VALUES("1341","PUR120824101","","SU","2","0.00","55600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","55600.00","0","","","2024-08-12","","55600.00","0.00","","LE_2","","0","1","2024-08-12 12:58:17");
INSERT INTO tbl_purchase VALUES("1342","PUR120824102","","SU","5","0.00","28000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28000.00","0","","","2024-08-12","","28000.00","0.00","","LE_2","","0","1","2024-08-12 02:08:02");
INSERT INTO tbl_purchase VALUES("1343","PUR120824103","","SU","13","0.00","17850.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","17850.00","0","","","2024-08-12","","17850.00","0.00","","LE_2","","0","1","2024-08-12 04:57:40");
INSERT INTO tbl_purchase VALUES("1344","PUR120824104","","SU","19","0.00","115875.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","115875.00","0","","","2024-08-12","","115875.00","0.00","","LE_2","","0","1","2024-08-12 06:34:46");
INSERT INTO tbl_purchase VALUES("1345","PUR120824105","","SU","13","0.00","38100.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","38100.00","0","","","2024-08-12","","38100.00","0.00","","LE_2","","0","1","2024-08-12 07:56:29");
INSERT INTO tbl_purchase VALUES("1346","PUR120824106","","SU","5","0.00","16140.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","16140.00","0","","","2024-08-12","","16140.00","0.00","","LE_2","","0","1","2024-08-12 10:25:38");
INSERT INTO tbl_purchase VALUES("1347","PUR120824107","","SU","5","0.00","100000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","100000.00","0","","","2024-08-12","","100000.00","0.00","","LE_2","","0","1","2024-08-12 11:36:57");
INSERT INTO tbl_purchase VALUES("1348","PUR130824101","","SU","34","0.00","32750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32750.00","0","","","2024-08-13","","32750.00","0.00","","LE_2","","0","1","2024-08-13 02:03:32");
INSERT INTO tbl_purchase VALUES("1349","PUR130824102","","SU","2","0.00","84040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","84040.00","0","","","2024-08-13","","84040.00","0.00","","LE_2","","0","1","2024-08-13 02:12:37");
INSERT INTO tbl_purchase VALUES("1350","PUR130824103","","SU","2","0.00","20600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","20600.00","0","","","2024-08-13","","20600.00","0.00","","LE_2","","0","1","2024-08-13 09:30:38");
INSERT INTO tbl_purchase VALUES("1351","PUR130824104","","SU","39","0.00","15000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","15000.00","0","","","2024-08-13","","15000.00","0.00","","LE_2","","0","1","2024-08-13 09:52:00");
INSERT INTO tbl_purchase VALUES("1352","PUR130824105","","SU","63","0.00","29050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","29050.00","0","","","2024-08-13","","29050.00","0.00","","LE_2","","0","1","2024-08-13 11:33:34");
INSERT INTO tbl_purchase VALUES("1353","PUR130824106","","SU","13","0.00","6350.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6350.00","0","","","2024-08-13","","6350.00","0.00","","LE_2","","0","1","2024-08-13 11:40:16");
INSERT INTO tbl_purchase VALUES("1354","PUR130824107","","SU","34","0.00","3930.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3930.00","0","","","2024-08-13","","3930.00","0.00","","LE_2","","0","1","2024-08-13 11:42:39");
INSERT INTO tbl_purchase VALUES("1355","PUR140824101","","SU","2","0.00","4520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4520.00","0","","","2024-08-14","","4520.00","0.00","","LE_2","","0","1","2024-08-14 12:11:25");
INSERT INTO tbl_purchase VALUES("1356","PUR140824102","","SU","13","0.00","25840.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","25840.00","0","","","2024-08-14","","25840.00","0.00","","LE_2","","0","1","2024-08-14 11:55:23");
INSERT INTO tbl_purchase VALUES("1357","PUR140824103","","SU","40","0.00","11542.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11542.50","0","","","2024-08-14","","11542.50","0.00","","LE_2","","0","1","2024-08-14 01:33:55");
INSERT INTO tbl_purchase VALUES("1358","PUR140824104","","SU","34","0.00","93855.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","93855.00","0","","","2024-08-14","","93855.00","0.00","","LE_2","","0","1","2024-08-14 07:55:20");
INSERT INTO tbl_purchase VALUES("1359","PUR140824105","","SU","2","0.00","172520.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","172520.00","0","","","2024-08-14","","172520.00","0.00","","LE_2","","0","1","2024-08-17 11:17:20");
INSERT INTO tbl_purchase VALUES("1360","PUR140824106","","SU","39","0.00","4764.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4764.00","0","","","2024-08-14","","4764.00","0.00","","LE_2","","0","1","2024-08-14 10:54:42");
INSERT INTO tbl_purchase VALUES("1361","PUR150824101","","SU","2","0.00","79625.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","79625.00","0","","","2024-08-15","","79625.00","0.00","","LE_2","","0","1","2024-08-17 11:08:26");
INSERT INTO tbl_purchase VALUES("1362","PUR150824102","","SU","2","0.00","99225.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","99225.00","0","","","2024-08-15","","99225.00","0.00","","LE_2","","0","1","2024-08-20 11:38:35");
INSERT INTO tbl_purchase VALUES("1363","PUR150824103","","SU","2","0.00","45400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","45400.00","0","","","2024-08-15","","45400.00","0.00","","LE_2","","0","1","2024-08-17 11:13:35");
INSERT INTO tbl_purchase VALUES("1364","PUR150824104","","SU","2","0.00","69228.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","69228.00","0","","","2024-08-15","","69228.00","0.00","","LE_2","","0","1","2024-08-15 03:02:24");
INSERT INTO tbl_purchase VALUES("1365","PUR150824105","","SU","13","0.00","1270.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","1270.00","0","","","2024-08-15","","1270.00","0.00","","LE_2","","0","1","2024-08-15 05:59:51");
INSERT INTO tbl_purchase VALUES("1366","PUR150824106","","SU","2","0.00","28800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","28800.00","0","","","2024-08-15","","28800.00","0.00","","LE_2","","0","1","2024-08-15 06:21:13");
INSERT INTO tbl_purchase VALUES("1367","PUR150824107","","SU","59","0.00","121030.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","121030.00","0","","","2024-08-15","","121030.00","0.00","","LE_2","","0","1","2024-08-15 07:12:59");
INSERT INTO tbl_purchase VALUES("1368","PUR150824108","","SU","59","0.00","81600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81600.00","0","","","2024-08-15","","81600.00","0.00","","LE_2","","0","1","2024-08-15 07:51:37");
INSERT INTO tbl_purchase VALUES("1369","PUR150824109","","SU","13","0.00","80070.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","80070.00","0","","","2024-08-15","","80070.00","0.00","","LE_2","","0","1","2024-08-15 10:01:30");
INSERT INTO tbl_purchase VALUES("1370","PUR150824110","","SU","63","0.00","35150.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35150.00","0","","","2024-08-15","","35150.00","0.00","","LE_2","","0","1","2024-08-15 10:47:26");
INSERT INTO tbl_purchase VALUES("1371","PUR160824101","","SU","13","0.00","78210.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","78210.00","0","","","2024-08-16","","78210.00","0.00","","LE_2","","0","1","2024-08-16 01:41:15");
INSERT INTO tbl_purchase VALUES("1372","PUR160824102","","SU","71","0.00","26400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","26400.00","0","","","2024-08-16","","26400.00","0.00","","LE_2","","0","1","2024-08-16 02:52:11");
INSERT INTO tbl_purchase VALUES("1373","PUR160824103","","SU","2","0.00","6000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6000.00","0","","","2024-08-16","","6000.00","0.00","","LE_2","","0","1","2024-08-16 04:30:34");
INSERT INTO tbl_purchase VALUES("1374","PUR160824104","","SU","71","0.00","9360.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","9360.00","0","","","2024-08-16","","9360.00","0.00","","LE_2","","0","1","2024-08-16 05:37:20");
INSERT INTO tbl_purchase VALUES("1375","PUR160824105","","SU","34","0.00","32750.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","32750.00","0","","","2024-08-16","","32750.00","0.00","","LE_2","","0","1","2024-08-16 07:21:53");
INSERT INTO tbl_purchase VALUES("1376","PUR160824106","","SU","51","0.00","6920.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6920.00","0","","","2024-08-16","","6920.00","0.00","","LE_2","","0","1","2024-08-16 09:27:12");
INSERT INTO tbl_purchase VALUES("1377","PUR170824101","","SU","61","0.00","2680.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","2680.00","0","","","2024-08-17","","2680.00","0.00","","LE_2","","0","1","2024-08-17 10:46:13");
INSERT INTO tbl_purchase VALUES("1378","PUR170824102","","SU","19","0.00","127300.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","127300.00","0","","","2024-08-17","","127300.00","0.00","","LE_2","","0","1","2024-08-17 10:53:20");
INSERT INTO tbl_purchase VALUES("1379","PUR180824101","","SU","51","0.00","4000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4000.00","0","","","2024-08-18","","4000.00","0.00","","LE_2","","0","1","2024-08-18 07:41:30");
INSERT INTO tbl_purchase VALUES("1380","PUR180824102","","SU","34","0.00","188640.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","188640.00","0","","","2024-08-18","","188640.00","0.00","","LE_2","","0","1","2024-08-18 08:57:43");
INSERT INTO tbl_purchase VALUES("1381","PUR190824101","","SU","51","0.00","3000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","3000.00","0","","","2024-08-19","","3000.00","0.00","","LE_2","","0","1","2024-08-19 02:49:03");
INSERT INTO tbl_purchase VALUES("1382","PUR200824101","","SU","8","0.00","65000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","65000.00","0","","","2024-08-20","","65000.00","0.00","","LE_2","","0","1","2024-08-20 12:43:31");
INSERT INTO tbl_purchase VALUES("1383","PUR200824102","","SU","73","0.00","134550.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","134550.00","0","","","2024-08-20","","134550.00","0.00","","LE_2","","0","1","2024-08-20 01:15:09");
INSERT INTO tbl_purchase VALUES("1384","PUR200824103","","SU","40","0.00","13138.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","13138.50","0","","","2024-08-20","","13138.50","0.00","","LE_2","","0","1","2024-08-20 03:06:07");
INSERT INTO tbl_purchase VALUES("1385","PUR210824101","","SU","39","0.00","4854.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","4854.00","0","","","2024-08-21","","4854.00","0.00","","LE_2","","0","1","2024-08-21 06:40:15");
INSERT INTO tbl_purchase VALUES("1386","PUR250824101","","SU","71","0.00","85200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","85200.00","0","","","2024-08-25","","85200.00","0.00","","LE_2","","0","1","2024-08-25 12:53:33");
INSERT INTO tbl_purchase VALUES("1387","PUR250824102","","SU","5","0.00","27400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27400.00","0","","","2024-08-25","","27400.00","0.00","","LE_2","","0","1","2024-08-25 12:59:18");
INSERT INTO tbl_purchase VALUES("1388","PUR290824101","","SU","10","0.00","37869.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","37869.00","0","","","2024-08-29","","37869.00","0.00","","LE_2","","0","1","2024-08-29 10:57:03");
INSERT INTO tbl_purchase VALUES("1389","PUR290824102","","SU","2","0.00","33000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","33000.00","0","","","2024-08-29","","33000.00","0.00","","LE_2","","0","1","2024-08-29 12:44:46");
INSERT INTO tbl_purchase VALUES("1390","PUR290824103","","SU","74","0.00","11500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","11500.00","0","","","2024-08-29","","11500.00","0.00","","LE_2","","0","1","2024-08-29 02:38:11");
INSERT INTO tbl_purchase VALUES("1391","PUR290824104","","SU","71","0.00","81000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","81000.00","0","","","2024-08-29","","81000.00","0.00","","LE_2","","0","1","2024-08-29 02:53:01");
INSERT INTO tbl_purchase VALUES("1392","PUR290824105","","SU","34","0.00","44500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","44500.00","0","","","2024-08-29","","44500.00","0.00","","LE_2","","0","1","2024-08-29 03:26:51");
INSERT INTO tbl_purchase VALUES("1393","PUR290824106","","SU","6","0.00","22000.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","22000.00","0","","","2024-08-29","","22000.00","0.00","","LE_2","","0","1","2024-08-29 08:48:17");
INSERT INTO tbl_purchase VALUES("1394","PUR300824101","","SU","6","0.00","49320.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","49320.00","0","","","2024-08-30","","49320.00","0.00","","LE_2","","0","1","2024-08-31 10:37:06");
INSERT INTO tbl_purchase VALUES("1395","PUR310824101","","SU","40","0.00","10040.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","10040.00","0","","","2024-08-31","","10040.00","0.00","","LE_2","","0","1","2024-08-31 06:44:51");
INSERT INTO tbl_purchase VALUES("1396","PUR010924101","","SU","19","0.00","311087.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","311087.00","0","","","2024-09-01","","311087.00","0.00","","LE_2","","0","1","2024-09-01 01:24:03");
INSERT INTO tbl_purchase VALUES("1397","PUR020924101","","SU","69","0.00","68800.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68800.00","0","","","2024-09-02","","68800.00","0.00","","LE_2","","0","1","2024-09-02 04:55:03");
INSERT INTO tbl_purchase VALUES("1398","PUR020924102","","SU","59","0.00","35200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","35200.00","0","","","2024-09-02","","35200.00","0.00","","LE_2","","0","1","2024-09-02 05:25:15");
INSERT INTO tbl_purchase VALUES("1399","PUR020924103","","SU","59","0.00","41200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","41200.00","0","","","2024-09-02","","41200.00","0.00","","LE_2","","0","1","2024-09-02 05:43:52");
INSERT INTO tbl_purchase VALUES("1400","PUR050924101","","SU","19","0.00","108600.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","108600.00","0","","","2024-09-05","","108600.00","0.00","","LE_2","","0","1","2024-09-05 10:59:51");
INSERT INTO tbl_purchase VALUES("1401","PUR060924101","","SU","6","0.00","27280.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27280.00","0","","","2024-09-06","","27280.00","0.00","","LE_2","","0","1","2024-09-06 05:43:02");
INSERT INTO tbl_purchase VALUES("1402","PUR080924101","","SU","16","0.00","110110.50","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","110110.50","0","","","2024-09-08","","110110.50","0.00","","LE_2","","0","1","2024-09-08 03:29:07");
INSERT INTO tbl_purchase VALUES("1403","PUR080924102","","SU","59","0.00","27400.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","27400.00","0","","","2024-09-08","","27400.00","0.00","","LE_2","","0","1","2024-09-08 07:06:04");
INSERT INTO tbl_purchase VALUES("1404","PUR090924101","","SU","13","0.00","246200.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","246200.00","0","","","2024-09-09","","246200.00","0.00","","LE_2","","0","1","2024-09-09 07:03:59");
INSERT INTO tbl_purchase VALUES("1405","PUR100924101","","SU","59","0.00","68500.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","68500.00","0","","","2024-09-10","","68500.00","0.00","","LE_2","","0","1","2024-09-10 01:25:40");
INSERT INTO tbl_purchase VALUES("1406","PUR100924102","","SU","9","0.00","48050.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","48050.00","0","","","2024-09-10","","48050.00","0.00","","LE_2","","0","1","2024-09-10 10:47:01");
INSERT INTO tbl_purchase VALUES("1407","PUR110924101","","SU","74","0.00","44950.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","44950.00","0","","","2024-09-11","","44950.00","0.00","","LE_2","","0","1","2024-09-11 06:04:21");
INSERT INTO tbl_purchase VALUES("1408","PUR120924101","","SU","39","0.00","118490.01","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","118490.01","0","","","2024-09-12","2024-09-19","118490.01","0.00","","LE_2","","0","1","2024-09-12 05:50:40");
INSERT INTO tbl_purchase VALUES("1409","PUR120924102","","SU","39","0.00","5559.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","5559.00","0","","","2024-09-12","","5559.00","0.00","","LE_2","","0","1","2024-09-12 08:43:01");
INSERT INTO tbl_purchase VALUES("1410","PUR130924101","","SU","39","0.00","6649.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","0.00","Others","0.00","0.00","0.00","0.00","6649.00","0","","","2024-09-13","","6649.00","0.00","","LE_2","","0","1","2024-09-13 03:38:04");



CREATE TABLE `tbl_recvoucher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brid` int(11) DEFAULT 0,
  `invno` varchar(15) NOT NULL,
  `note` varchar(150) DEFAULT NULL,
  `amount` decimal(12,2) NOT NULL,
  `apdate` date NOT NULL,
  `uid` int(11) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2397 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO tbl_recvoucher VALUES("3","0","REV181222101","","5000.00","2022-12-18","1","2022-12-18 07:32:05");
INSERT INTO tbl_recvoucher VALUES("9","0","REV201222103","","15300.00","2022-12-20","1","2022-12-20 06:45:47");
INSERT INTO tbl_recvoucher VALUES("13","0","REV201222104","","2000.00","2022-12-20","1","2022-12-20 08:43:39");
INSERT INTO tbl_recvoucher VALUES("14","0","REV211222101","","23500.00","2022-12-19","1","2022-12-21 12:32:43");
INSERT INTO tbl_recvoucher VALUES("19","0","REV211222104","","10000.00","2022-12-21","1","2022-12-21 06:28:40");
INSERT INTO tbl_recvoucher VALUES("20","0","REV211222105","","33500.00","2022-12-21","1","2022-12-21 08:13:50");
INSERT INTO tbl_recvoucher VALUES("21","0","REV211222106","","22000.00","2022-12-21","1","2022-12-21 09:21:24");
INSERT INTO tbl_recvoucher VALUES("24","0","REV221222102","","2000.00","2022-12-22","1","2022-12-22 08:22:47");
INSERT INTO tbl_recvoucher VALUES("26","0","REV221222103","","38500.00","2022-12-22","1","2022-12-22 10:02:35");
INSERT INTO tbl_recvoucher VALUES("31","0","REV231222103","","300.00","2022-12-23","1","2022-12-23 06:52:05");
INSERT INTO tbl_recvoucher VALUES("32","0","REV241222101","","3500.00","2022-12-24","1","2022-12-24 12:58:49");
INSERT INTO tbl_recvoucher VALUES("37","0","REV251222105","","3000.00","2022-12-25","1","2022-12-25 08:21:32");
INSERT INTO tbl_recvoucher VALUES("40","0","REV261222101","","4000.00","2022-12-25","1","2022-12-26 12:13:31");
INSERT INTO tbl_recvoucher VALUES("41","0","REV261222102","","345000.00","2022-12-26","1","2022-12-26 12:20:27");
INSERT INTO tbl_recvoucher VALUES("46","0","REV261222107","","2000.00","2022-12-26","1","2022-12-26 08:20:11");
INSERT INTO tbl_recvoucher VALUES("49","0","REV271222102","","255000.00","2022-12-26","1","2022-12-27 11:30:44");
INSERT INTO tbl_recvoucher VALUES("50","0","REV271222103","","14500.00","2022-12-27","1","2022-12-27 03:46:10");
INSERT INTO tbl_recvoucher VALUES("55","0","REV281222103","","1500.00","2022-12-28","1","2022-12-28 06:26:20");
INSERT INTO tbl_recvoucher VALUES("57","0","REV291222101","","2600.00","2022-12-29","1","2022-12-29 05:09:02");
INSERT INTO tbl_recvoucher VALUES("58","0","REV291222102","","3150.00","2022-12-29","1","2022-12-29 07:16:33");
INSERT INTO tbl_recvoucher VALUES("59","0","REV291222103","","2300.00","2022-12-29","1","2022-12-29 08:20:32");
INSERT INTO tbl_recvoucher VALUES("63","0","REV301222102","","4640.00","2022-12-30","1","2022-12-30 07:11:35");
INSERT INTO tbl_recvoucher VALUES("64","0","REV311222101","","12000.00","2022-12-31","1","2022-12-31 03:34:34");
INSERT INTO tbl_recvoucher VALUES("65","0","REV311222102","","5070.00","2022-12-31","1","2022-12-31 03:40:18");
INSERT INTO tbl_recvoucher VALUES("66","0","REV311222103","","1250.00","2022-12-31","1","2022-12-31 05:29:07");
INSERT INTO tbl_recvoucher VALUES("67","0","REV311222104","","2100.00","2022-12-31","1","2022-12-31 07:01:04");
INSERT INTO tbl_recvoucher VALUES("68","0","REV311222105","","3900.00","2022-12-31","1","2022-12-31 09:33:06");
INSERT INTO tbl_recvoucher VALUES("69","0","REV020123101","","1120.00","2023-01-01","1","2023-01-02 11:13:29");
INSERT INTO tbl_recvoucher VALUES("70","0","REV020123102","","7000.00","2023-01-01","1","2023-01-02 05:24:37");
INSERT INTO tbl_recvoucher VALUES("71","0","REV020123103","","1500.00","2023-01-02","1","2023-01-02 05:43:03");
INSERT INTO tbl_recvoucher VALUES("72","0","REV020123104","","850.00","2023-01-02","1","2023-01-02 06:00:27");
INSERT INTO tbl_recvoucher VALUES("73","0","REV020123105","","1600.00","2023-01-02","1","2023-01-02 07:13:12");
INSERT INTO tbl_recvoucher VALUES("75","0","REV020123106","","3000.00","2022-12-25","1","2023-01-02 07:39:39");
INSERT INTO tbl_recvoucher VALUES("76","0","REV020123107","","3790.00","2022-12-28","1","2023-01-02 07:40:13");
INSERT INTO tbl_recvoucher VALUES("77","0","REV020123108","","16875.00","2023-01-02","1","2023-01-02 09:21:59");
INSERT INTO tbl_recvoucher VALUES("79","0","REV020123109","","26000.00","2023-01-02","1","2023-01-02 09:49:30");
INSERT INTO tbl_recvoucher VALUES("80","0","REV030123101","","1950.00","2023-01-03","1","2023-01-03 01:12:17");
INSERT INTO tbl_recvoucher VALUES("81","0","REV030123102","","2000.00","2023-01-03","1","2023-01-03 04:31:59");
INSERT INTO tbl_recvoucher VALUES("82","0","REV030123103","SEL030123117","1870.00","2023-01-03","1","2023-01-03 06:56:29");
INSERT INTO tbl_recvoucher VALUES("83","0","REV030123104","","2750.00","2023-01-03","1","2023-01-03 08:01:03");
INSERT INTO tbl_recvoucher VALUES("84","0","REV030123105","","740.00","2023-01-03","1","2023-01-03 08:03:55");
INSERT INTO tbl_recvoucher VALUES("85","0","REV030123106","","2500.00","2023-01-03","1","2023-01-03 08:23:41");
INSERT INTO tbl_recvoucher VALUES("89","0","REV040123102","","1000.00","2023-01-04","1","2023-01-04 04:48:13");
INSERT INTO tbl_recvoucher VALUES("90","0","REV040123103","","1370.00","2023-01-04","1","2023-01-04 08:15:54");
INSERT INTO tbl_recvoucher VALUES("91","0","REV040123104","DATE: 30/07/22 - SHALIM VAI  DAILY SALLS BOOKS DUE (OLT)","20000.00","2023-01-04","1","2023-01-04 08:28:12");
INSERT INTO tbl_recvoucher VALUES("92","0","REV040123105","","3000.00","2023-01-04","1","2023-01-04 08:31:41");
INSERT INTO tbl_recvoucher VALUES("93","0","REV040123106","","2000.00","2023-01-04","1","2023-01-04 08:32:14");
INSERT INTO tbl_recvoucher VALUES("94","0","REV040123107","","500.00","2023-01-04","1","2023-01-04 10:30:21");
INSERT INTO tbl_recvoucher VALUES("95","0","REV050123101","","2515.00","2023-01-05","1","2023-01-05 11:07:37");
INSERT INTO tbl_recvoucher VALUES("96","0","REV050123102","","2000.00","2023-01-05","1","2023-01-05 01:05:51");
INSERT INTO tbl_recvoucher VALUES("97","0","REV050123103","","3700.00","2023-01-05","1","2023-01-05 06:40:56");
INSERT INTO tbl_recvoucher VALUES("98","0","REV060123101","","23074.00","2022-11-01","1","2023-01-06 03:34:29");
INSERT INTO tbl_recvoucher VALUES("101","0","REV070123101","\&amp;quot;FARID VAI\&amp;quot; DUE RECEIVED BY DATE OF 25-08-2022","4000.00","2023-01-07","1","2023-01-07 08:17:00");
INSERT INTO tbl_recvoucher VALUES("104","0","REV080123102","BILL - SEL080123110","260.00","2023-01-08","1","2023-01-08 01:31:54");
INSERT INTO tbl_recvoucher VALUES("105","0","REV080123103","BILLS FROM : SEL080123111","1000.00","2023-01-08","1","2023-01-08 06:16:03");
INSERT INTO tbl_recvoucher VALUES("106","0","REV080123104","","5000.00","2023-01-06","1","2023-01-08 06:28:15");
INSERT INTO tbl_recvoucher VALUES("107","0","REV080123105","BILLS FROM : SEL080123122","18500.00","2023-01-08","1","2023-01-08 07:58:02");
INSERT INTO tbl_recvoucher VALUES("110","0","REV080123106","BILLS FROM - SEL080123109/SEL050123120","5000.00","2023-01-08","1","2023-01-08 08:54:09");
INSERT INTO tbl_recvoucher VALUES("111","0","REV090123101","BILLS FROM : SEL090123103","200.00","2023-01-09","1","2023-01-09 12:48:32");
INSERT INTO tbl_recvoucher VALUES("112","0","REV090123102","","200.00","2023-01-09","1","2023-01-09 02:25:39");
INSERT INTO tbl_recvoucher VALUES("114","0","REV090123103","BILLS FROM : SEL090123101/SEL090123120","10900.00","2023-01-09","1","2023-01-09 07:49:19");
INSERT INTO tbl_recvoucher VALUES("115","0","REV090123104","","2000.00","2023-01-09","1","2023-01-09 07:51:22");
INSERT INTO tbl_recvoucher VALUES("116","0","REV090123105","","300.00","2023-01-09","1","2023-01-09 10:32:42");
INSERT INTO tbl_recvoucher VALUES("117","0","REV100123101","BILLS FROM : SEL090123127","50.00","2023-01-10","1","2023-01-10 01:50:57");
INSERT INTO tbl_recvoucher VALUES("118","0","REV100123102","","3000.00","2023-01-10","1","2023-01-10 02:49:12");
INSERT INTO tbl_recvoucher VALUES("119","0","REV100123103","BILLS FROM : SEL100123109","2500.00","2023-01-10","1","2023-01-10 03:45:10");
INSERT INTO tbl_recvoucher VALUES("120","0","REV100123104","BILLS FROM : SEL100123110","1900.00","2023-01-10","1","2023-01-10 03:59:34");
INSERT INTO tbl_recvoucher VALUES("122","0","REV100123105","BILLS FROM : SEL090123125","900.00","2023-01-10","1","2023-01-10 04:55:30");
INSERT INTO tbl_recvoucher VALUES("123","0","REV100123106","","1200.00","2023-01-10","1","2023-01-10 08:08:09");
INSERT INTO tbl_recvoucher VALUES("124","0","REV100123107","BILL FROM : SEL080123120","50.00","2023-01-10","1","2023-01-10 08:35:08");
INSERT INTO tbl_recvoucher VALUES("125","0","REV100123108","","3000.00","2023-01-10","1","2023-01-10 08:35:37");
INSERT INTO tbl_recvoucher VALUES("126","0","REV100123109","","1250.00","2023-01-10","1","2023-01-10 10:25:47");
INSERT INTO tbl_recvoucher VALUES("127","0","REV100123110","","4680.00","2023-01-10","1","2023-01-10 10:48:06");
INSERT INTO tbl_recvoucher VALUES("128","0","REV100123111","","10000.00","2023-01-10","1","2023-01-10 10:49:00");
INSERT INTO tbl_recvoucher VALUES("130","0","REV110123102","BILLS FROM : SEL110123102","1515.00","2023-01-11","1","2023-01-11 11:11:49");
INSERT INTO tbl_recvoucher VALUES("131","0","REV110123103","BILLS FROM : SEL110123101","500.00","2023-01-11","1","2023-01-11 11:13:12");
INSERT INTO tbl_recvoucher VALUES("132","0","REV110123104","BILLS FROM : SEL110123105","160.00","2023-01-11","1","2023-01-11 01:54:22");
INSERT INTO tbl_recvoucher VALUES("134","0","REV110123106","","31690.00","2023-01-11","1","2023-01-11 06:31:14");
INSERT INTO tbl_recvoucher VALUES("135","0","REV110123107","BILL FROM : SEL090123124","1150.00","2023-01-11","1","2023-01-11 06:34:25");
INSERT INTO tbl_recvoucher VALUES("136","0","REV110123108","BILLS FROM : SEL030123104","660.00","2023-01-11","1","2023-01-11 06:44:51");
INSERT INTO tbl_recvoucher VALUES("137","0","REV110123109","","2000.00","2023-01-11","1","2023-01-11 08:47:41");
INSERT INTO tbl_recvoucher VALUES("138","0","REV120123101","","1500.00","2023-01-12","1","2023-01-12 06:10:59");
INSERT INTO tbl_recvoucher VALUES("139","0","REV120123102","BILLS FROM : SEL120123114","1300.00","2023-01-12","1","2023-01-12 07:48:14");
INSERT INTO tbl_recvoucher VALUES("140","0","REV120123103","BILLS FROM : SEL120123124","10450.00","2023-01-12","1","2023-01-12 08:34:16");
INSERT INTO tbl_recvoucher VALUES("141","0","REV120123104","AKASH DTH PAYMENTS RESEARCH","90.00","2023-01-12","1","2023-01-12 10:20:19");
INSERT INTO tbl_recvoucher VALUES("142","0","REV130123101","BILLS FROM : SEL130123104","5900.00","2023-01-13","1","2023-01-13 12:07:38");
INSERT INTO tbl_recvoucher VALUES("144","0","REV140123101","","5030.00","2023-01-14","1","2023-01-14 11:55:25");
INSERT INTO tbl_recvoucher VALUES("145","0","REV140123102","","850.00","2023-01-14","1","2023-01-14 02:31:40");
INSERT INTO tbl_recvoucher VALUES("146","0","REV140123103","BILLS FROM : SEL140123116","2470.00","2023-01-14","1","2023-01-14 05:53:26");
INSERT INTO tbl_recvoucher VALUES("147","0","REV140123104","","11100.00","2023-01-14","1","2023-01-14 08:36:01");
INSERT INTO tbl_recvoucher VALUES("148","0","REV140123105","BILLS FROM : SEL301222108","6280.00","2023-01-14","1","2023-01-14 09:36:50");
INSERT INTO tbl_recvoucher VALUES("149","0","REV150123101","","100.00","2023-01-15","1","2023-01-15 10:15:08");
INSERT INTO tbl_recvoucher VALUES("150","0","REV150123102","BILL FROM :SEL150123124","2270.00","2023-01-15","1","2023-01-15 10:30:19");
INSERT INTO tbl_recvoucher VALUES("151","0","REV160123101","","1000.00","2023-01-16","1","2023-01-16 03:29:09");
INSERT INTO tbl_recvoucher VALUES("153","0","REV160123102","BILLS FROM : SEL251222113","1000.00","2022-12-25","1","2023-01-16 04:28:20");
INSERT INTO tbl_recvoucher VALUES("154","0","REV160123103","BILLS FROM : SEL261222105","2245.00","2022-12-26","1","2023-01-16 05:00:39");
INSERT INTO tbl_recvoucher VALUES("155","0","REV160123104","","3900.00","2023-01-16","1","2023-01-16 07:57:50");
INSERT INTO tbl_recvoucher VALUES("157","0","REV160123106","BILLS FROM : SEL160123110/SEL110123101","1750.00","2023-01-16","1","2023-01-16 09:24:38");
INSERT INTO tbl_recvoucher VALUES("158","0","REV170123101","BILLS FROM : SEL170123101","1000.00","2023-01-17","1","2023-01-17 11:37:56");
INSERT INTO tbl_recvoucher VALUES("159","0","REV170123102","BILLS FROM : SEL170123108","640.00","2023-01-17","1","2023-01-17 01:10:12");
INSERT INTO tbl_recvoucher VALUES("160","0","REV170123103","","1320.00","2023-01-17","1","2023-01-17 03:31:11");
INSERT INTO tbl_recvoucher VALUES("161","0","REV170123104","BILLS FROM : SEL170123123","2500.00","2023-01-17","1","2023-01-17 09:36:01");
INSERT INTO tbl_recvoucher VALUES("162","0","REV180123101","","1260.00","2023-01-18","1","2023-01-18 10:45:45");
INSERT INTO tbl_recvoucher VALUES("164","0","REV180123102","","400.00","2023-01-18","1","2023-01-18 01:53:54");
INSERT INTO tbl_recvoucher VALUES("165","0","REV180123103","","4500.00","2023-01-18","1","2023-01-18 04:09:11");
INSERT INTO tbl_recvoucher VALUES("168","0","REV180123105","","2900.00","2023-01-18","1","2023-01-18 05:03:10");
INSERT INTO tbl_recvoucher VALUES("171","0","REV180123108","","70000.00","2023-01-17","1","2023-01-18 05:16:04");
INSERT INTO tbl_recvoucher VALUES("172","0","REV180123109","","330000.00","2023-01-17","1","2023-01-18 05:18:14");
INSERT INTO tbl_recvoucher VALUES("173","0","REV180123110","","3000.00","2023-01-18","1","2023-01-18 08:42:44");
INSERT INTO tbl_recvoucher VALUES("174","0","REV180123111","","150.00","2023-01-18","1","2023-01-18 08:56:01");
INSERT INTO tbl_recvoucher VALUES("175","0","REV190123101","BILLS FROM : SEL190123102","1140.00","2023-01-19","1","2023-01-19 11:23:53");
INSERT INTO tbl_recvoucher VALUES("177","0","REV190123103","BILLS FROM : SEL271222101","1000.00","2022-12-27","1","2023-01-19 11:27:28");
INSERT INTO tbl_recvoucher VALUES("179","0","REV190123104","BILLS FROM : SEL281222111","970.00","2022-12-28","1","2023-01-19 11:29:52");
INSERT INTO tbl_recvoucher VALUES("180","0","REV190123105","","8000.00","2023-01-19","1","2023-01-19 02:51:03");
INSERT INTO tbl_recvoucher VALUES("181","0","REV190123106","BILLS FROM : SEL190123116","1500.00","2023-01-19","1","2023-01-19 05:30:41");
INSERT INTO tbl_recvoucher VALUES("182","0","REV190123107","BILLS FROM : SEL261222122","1200.00","2022-12-26","1","2023-01-19 06:15:50");
INSERT INTO tbl_recvoucher VALUES("183","0","REV190123108","BILLS FROM : SEL110123117","850.00","2023-01-19","1","2023-01-19 07:20:15");
INSERT INTO tbl_recvoucher VALUES("185","0","REV190123110","","20000.00","2023-01-19","1","2023-01-19 08:36:23");
INSERT INTO tbl_recvoucher VALUES("186","0","REV190123111","","9000.00","2023-01-19","1","2023-01-19 09:07:01");
INSERT INTO tbl_recvoucher VALUES("187","0","REV190123112","BILLS FROM : SEL190123122","850.00","2023-01-19","1","2023-01-19 09:49:32");
INSERT INTO tbl_recvoucher VALUES("188","0","REV200123101","","300.00","2023-01-20","1","2023-01-20 12:27:07");
INSERT INTO tbl_recvoucher VALUES("189","0","REV200123102","","2000.00","2023-01-20","1","2023-01-20 01:00:56");
INSERT INTO tbl_recvoucher VALUES("190","0","REV200123103","","310.00","2023-01-20","1","2023-01-20 06:01:06");
INSERT INTO tbl_recvoucher VALUES("191","0","REV200123104","","10000.00","2023-01-20","1","2023-01-20 07:14:53");
INSERT INTO tbl_recvoucher VALUES("192","0","REV200123105","","3000.00","2023-01-20","1","2023-01-20 09:23:40");
INSERT INTO tbl_recvoucher VALUES("193","0","REV200123106","","1000.00","2023-01-20","1","2023-01-20 10:31:27");
INSERT INTO tbl_recvoucher VALUES("194","0","REV210123101","","1500.00","2023-01-21","1","2023-01-21 01:42:12");
INSERT INTO tbl_recvoucher VALUES("195","0","REV210123102","","2400.00","2023-01-21","1","2023-01-21 05:56:45");
INSERT INTO tbl_recvoucher VALUES("197","0","REV220123101","","1050.00","2023-01-22","1","2023-01-22 12:27:21");
INSERT INTO tbl_recvoucher VALUES("199","0","REV220123102","","200.00","2023-01-22","1","2023-01-22 01:21:14");
INSERT INTO tbl_recvoucher VALUES("201","0","REV220123103","BILLS FROM : SEL220123113","1500.00","2023-01-22","1","2023-01-22 06:01:04");
INSERT INTO tbl_recvoucher VALUES("202","0","REV220123104","30/70 SPLITER SELL EXCHANGE","170.00","2023-01-22","1","2023-01-22 09:04:03");
INSERT INTO tbl_recvoucher VALUES("203","0","REV230123101","","300.00","2023-01-23","1","2023-01-23 03:32:58");
INSERT INTO tbl_recvoucher VALUES("204","0","REV230123102","","2000.00","2023-01-23","1","2023-01-23 08:20:49");
INSERT INTO tbl_recvoucher VALUES("206","0","REV230123103","BILLS FROM : SEL230123116","3980.00","2023-01-23","1","2023-01-23 08:45:28");
INSERT INTO tbl_recvoucher VALUES("207","0","REV240123101","","800.00","2023-01-24","1","2023-01-24 01:49:52");
INSERT INTO tbl_recvoucher VALUES("208","0","REV240123102","","750.00","2023-01-24","1","2023-01-24 07:51:23");
INSERT INTO tbl_recvoucher VALUES("209","0","REV240123103","","2000.00","2023-01-24","1","2023-01-24 08:28:58");
INSERT INTO tbl_recvoucher VALUES("210","0","REV240123104","","5000.00","2023-01-24","1","2023-01-24 08:29:45");
INSERT INTO tbl_recvoucher VALUES("211","0","REV250123101","BILLS FROM : SEL250123125","1000.00","2023-01-25","1","2023-01-25 08:13:31");
INSERT INTO tbl_recvoucher VALUES("212","0","REV250123102","","4700.00","2023-01-25","1","2023-01-25 08:30:48");
INSERT INTO tbl_recvoucher VALUES("213","0","REV250123103","","2550.00","2023-01-25","1","2023-01-25 08:39:40");
INSERT INTO tbl_recvoucher VALUES("214","0","REV250123104","","2000.00","2023-01-25","1","2023-01-25 08:52:59");
INSERT INTO tbl_recvoucher VALUES("216","0","REV250123105","BILLS FROM : SEL250123130","2300.00","2023-01-25","1","2023-01-25 09:18:25");
INSERT INTO tbl_recvoucher VALUES("218","0","REV260123102","","2400.00","2023-01-01","1","2023-01-26 08:15:01");
INSERT INTO tbl_recvoucher VALUES("219","0","REV260123103","","2800.00","2023-01-26","1","2023-01-26 08:48:38");
INSERT INTO tbl_recvoucher VALUES("220","0","REV260123104","BILLS FROM : SEL260123125","689.00","2023-01-26","1","2023-01-26 09:08:58");
INSERT INTO tbl_recvoucher VALUES("221","0","REV270123101","BILLS FROM.SEL270123102","2100.00","2023-01-27","1","2023-01-27 11:15:06");
INSERT INTO tbl_recvoucher VALUES("222","0","REV270123102","","17000.00","2023-01-27","1","2023-01-27 05:53:13");
INSERT INTO tbl_recvoucher VALUES("223","0","REV270123103","DUE","500.00","2023-01-27","1","2023-01-27 07:24:49");
INSERT INTO tbl_recvoucher VALUES("224","0","REV270123104","","2000.00","2023-01-27","1","2023-01-27 09:04:56");
INSERT INTO tbl_recvoucher VALUES("225","0","REV270123105","","3000.00","2023-01-27","1","2023-01-27 09:05:24");
INSERT INTO tbl_recvoucher VALUES("226","0","REV280123101","","1300.00","2023-01-28","1","2023-01-28 01:21:23");
INSERT INTO tbl_recvoucher VALUES("227","0","REV280123102","","650.00","2023-01-28","1","2023-01-28 04:08:52");
INSERT INTO tbl_recvoucher VALUES("228","0","REV280123103","BILLS FROM : SEL010123133","1000.00","2023-01-28","1","2023-01-28 05:44:44");
INSERT INTO tbl_recvoucher VALUES("229","0","REV280123104","","1880.00","2023-01-28","1","2023-01-28 07:20:30");
INSERT INTO tbl_recvoucher VALUES("230","0","REV280123105","","3000.00","2023-01-28","1","2023-01-28 07:54:28");
INSERT INTO tbl_recvoucher VALUES("231","0","REV290123101","BILLS FROM.SEL290123101","3000.00","2023-01-29","1","2023-01-29 10:32:26");
INSERT INTO tbl_recvoucher VALUES("232","0","REV290123102","BILLS FROM.SEL290123117","4920.00","2023-01-29","1","2023-01-29 03:53:15");
INSERT INTO tbl_recvoucher VALUES("233","0","REV290123103","BILLS FROM.SEL290123119","2300.00","2023-01-29","1","2023-01-29 04:50:09");
INSERT INTO tbl_recvoucher VALUES("234","0","REV290123104","BILLS FROM : SEL290123109","4140.00","2023-01-29","1","2023-01-29 05:36:17");
INSERT INTO tbl_recvoucher VALUES("235","0","REV300123101","","2000.00","2023-01-30","1","2023-01-30 09:12:25");
INSERT INTO tbl_recvoucher VALUES("236","0","REV310123101","BILLS FROM : SEL310123110","2800.00","2023-01-31","1","2023-01-31 01:04:07");
INSERT INTO tbl_recvoucher VALUES("237","0","REV310123102","BILLS FROM.SEL310123117","150.00","2023-01-31","1","2023-01-31 04:26:54");
INSERT INTO tbl_recvoucher VALUES("238","0","REV310123103","","15400.00","2023-01-31","1","2023-01-31 09:01:13");
INSERT INTO tbl_recvoucher VALUES("239","0","REV010223101","BILLS FROM.SEL010223112","3150.00","2023-02-01","1","2023-02-01 03:59:15");
INSERT INTO tbl_recvoucher VALUES("240","0","REV010223102","","1545.00","2023-02-01","1","2023-02-01 06:24:43");
INSERT INTO tbl_recvoucher VALUES("241","0","REV010223103","","4190.00","2023-02-01","1","2023-02-01 08:03:54");
INSERT INTO tbl_recvoucher VALUES("242","0","REV010223104","","3500.00","2023-02-01","1","2023-02-01 08:07:48");
INSERT INTO tbl_recvoucher VALUES("243","0","REV010223105","","5350.00","2023-02-01","1","2023-02-01 10:50:07");
INSERT INTO tbl_recvoucher VALUES("244","0","REV020223101","","2000.00","2023-02-02","1","2023-02-02 08:33:07");
INSERT INTO tbl_recvoucher VALUES("245","0","REV020223102","","1000.00","2023-02-02","1","2023-02-02 08:33:37");
INSERT INTO tbl_recvoucher VALUES("246","0","REV030223101","","14750.00","2023-02-03","1","2023-02-03 04:39:26");
INSERT INTO tbl_recvoucher VALUES("247","0","REV030223102","","1000.00","2023-02-03","1","2023-02-03 04:43:30");
INSERT INTO tbl_recvoucher VALUES("248","0","REV030223103","","500.00","2023-02-03","1","2023-02-03 06:32:01");
INSERT INTO tbl_recvoucher VALUES("249","0","REV030223104","","1150.00","2023-02-03","1","2023-02-03 08:03:37");
INSERT INTO tbl_recvoucher VALUES("251","0","REV040223101","","6000.00","2023-02-04","1","2023-02-04 11:43:00");
INSERT INTO tbl_recvoucher VALUES("252","0","REV040223102","","2110.00","2023-02-04","1","2023-02-04 01:34:03");
INSERT INTO tbl_recvoucher VALUES("253","0","REV040223103","","2000.00","2023-02-04","1","2023-02-04 01:35:28");
INSERT INTO tbl_recvoucher VALUES("254","0","REV040223104","","1360.00","2023-02-04","1","2023-02-04 02:09:17");
INSERT INTO tbl_recvoucher VALUES("255","0","REV050223101","BILLS FROM : SEL050223104","3000.00","2023-02-05","1","2023-02-05 01:31:50");
INSERT INTO tbl_recvoucher VALUES("256","0","REV050223102","BILLS FROM.SEL050223107","840.00","2023-02-05","1","2023-02-05 03:03:48");
INSERT INTO tbl_recvoucher VALUES("257","0","REV050223103","","11000.00","2023-02-05","1","2023-02-05 04:58:28");
INSERT INTO tbl_recvoucher VALUES("262","0","REV050223104","","1200000.00","2023-01-01","1","2023-02-05 05:41:24");
INSERT INTO tbl_recvoucher VALUES("263","0","REV050223105","","1.00","2023-02-02","1","2023-02-05 05:51:23");
INSERT INTO tbl_recvoucher VALUES("264","0","REV050223106","","10.00","2023-02-05","1","2023-02-05 06:05:51");
INSERT INTO tbl_recvoucher VALUES("265","0","REV050223107","","1500.00","2023-02-05","1","2023-02-05 09:01:36");
INSERT INTO tbl_recvoucher VALUES("266","0","REV050223108","","350.00","2023-02-05","1","2023-02-05 09:03:01");
INSERT INTO tbl_recvoucher VALUES("267","0","REV050223109","","50.00","2023-02-05","1","2023-02-05 09:11:17");
INSERT INTO tbl_recvoucher VALUES("268","0","REV050223110","","600.00","2023-02-05","1","2023-02-05 09:15:41");
INSERT INTO tbl_recvoucher VALUES("269","0","REV050223111","","4000.00","2023-02-05","1","2023-02-05 09:52:10");
INSERT INTO tbl_recvoucher VALUES("270","0","REV050223112","","15500.00","2023-02-05","1","2023-02-05 10:06:17");
INSERT INTO tbl_recvoucher VALUES("271","0","REV060223101","BILLS FROM.SEL060223102","3860.00","2023-02-06","1","2023-02-06 11:06:01");
INSERT INTO tbl_recvoucher VALUES("272","0","REV060223102","","4360.00","2023-02-06","1","2023-02-06 12:57:20");
INSERT INTO tbl_recvoucher VALUES("273","0","REV060223103","BILLS FROM.SEL060223115","1900.00","2023-02-06","1","2023-02-06 05:05:41");
INSERT INTO tbl_recvoucher VALUES("274","0","REV060223104","","2200.00","2023-02-06","1","2023-02-06 05:35:56");
INSERT INTO tbl_recvoucher VALUES("276","0","REV060223105","","50.00","2023-02-06","1","2023-02-06 07:29:14");
INSERT INTO tbl_recvoucher VALUES("277","0","REV060223106","","4228.00","2023-02-06","1","2023-02-06 07:32:19");
INSERT INTO tbl_recvoucher VALUES("278","0","REV060223107","","6000.00","2023-02-06","1","2023-02-06 07:39:06");
INSERT INTO tbl_recvoucher VALUES("279","0","REV060223108","","1800.00","2023-02-06","1","2023-02-06 10:43:39");
INSERT INTO tbl_recvoucher VALUES("280","0","REV070223101","BILLS FROM.SEL070223101","6160.00","2023-02-07","1","2023-02-07 11:12:29");
INSERT INTO tbl_recvoucher VALUES("281","0","REV070223102","","2100.00","2023-02-07","1","2023-02-07 07:26:18");
INSERT INTO tbl_recvoucher VALUES("282","0","REV070223103","","2200.00","2023-02-07","1","2023-02-07 07:49:53");
INSERT INTO tbl_recvoucher VALUES("284","0","REV070223104","","1500.00","2023-02-07","1","2023-02-07 08:40:09");
INSERT INTO tbl_recvoucher VALUES("285","0","REV080223101","","3300.00","2023-02-08","1","2023-02-08 05:27:48");
INSERT INTO tbl_recvoucher VALUES("286","0","REV080223102","","300.00","2023-02-08","1","2023-02-08 08:47:21");
INSERT INTO tbl_recvoucher VALUES("288","0","REV080223104","","2000.00","2023-02-08","1","2023-02-08 09:29:04");
INSERT INTO tbl_recvoucher VALUES("289","0","REV080223105","","5600.00","2023-02-08","1","2023-02-08 09:34:46");
INSERT INTO tbl_recvoucher VALUES("290","0","REV090223101","","6600.00","2023-02-09","1","2023-02-09 11:06:57");
INSERT INTO tbl_recvoucher VALUES("291","0","REV100223101","","5000.00","2023-02-10","1","2023-02-10 04:41:32");
INSERT INTO tbl_recvoucher VALUES("292","0","REV100223102","","450.00","2023-02-10","1","2023-02-10 05:07:27");
INSERT INTO tbl_recvoucher VALUES("293","0","REV100223103","","300.00","2023-02-10","1","2023-02-10 09:59:37");
INSERT INTO tbl_recvoucher VALUES("294","0","REV110223101","","300.00","2023-02-11","1","2023-02-11 09:02:04");
INSERT INTO tbl_recvoucher VALUES("295","0","REV110223102","","4000.00","2023-02-11","1","2023-02-11 10:03:26");
INSERT INTO tbl_recvoucher VALUES("296","0","REV120223101","","2650.00","2023-02-12","1","2023-02-12 11:55:37");
INSERT INTO tbl_recvoucher VALUES("297","0","REV120223102","","400.00","2023-02-12","1","2023-02-12 08:00:24");
INSERT INTO tbl_recvoucher VALUES("298","0","REV130223101","BILLS  FROM.SEL130223102","2130.00","2023-02-13","1","2023-02-13 11:30:51");
INSERT INTO tbl_recvoucher VALUES("299","0","REV130223102","Bills From.SEL130223110","4615.00","2023-02-13","1","2023-02-13 01:49:29");
INSERT INTO tbl_recvoucher VALUES("300","0","REV130223103","bills from.SEL130223112","1170.00","2023-02-13","1","2023-02-13 04:19:21");
INSERT INTO tbl_recvoucher VALUES("301","0","REV130223104","","2000.00","2023-02-13","1","2023-02-13 08:08:00");
INSERT INTO tbl_recvoucher VALUES("302","0","REV130223105","","4000.00","2023-02-13","1","2023-02-13 08:50:01");
INSERT INTO tbl_recvoucher VALUES("303","0","REV130223106","","22500.00","2023-02-13","1","2023-02-13 08:50:42");
INSERT INTO tbl_recvoucher VALUES("304","0","REV130223107","BILLS FROM.SEL060223112/SEL260123120/SEL200123106/SEL110123114","9500.00","2023-02-13","1","2023-02-13 08:55:20");
INSERT INTO tbl_recvoucher VALUES("305","0","REV140223101","","5000.00","2023-02-14","1","2023-02-14 04:00:18");
INSERT INTO tbl_recvoucher VALUES("306","0","REV140223102","Bills From.SEL140223110","2500.00","2023-02-14","1","2023-02-14 05:25:30");
INSERT INTO tbl_recvoucher VALUES("307","0","REV150223101","BILLS FROM.SEL150223109","3450.00","2023-02-15","1","2023-02-15 02:16:02");
INSERT INTO tbl_recvoucher VALUES("308","0","REV150223102","Bills From.SEL150223115","1000.00","2023-02-15","1","2023-02-15 05:15:33");
INSERT INTO tbl_recvoucher VALUES("309","0","REV150223103","","119.00","2023-02-15","1","2023-02-15 05:44:15");
INSERT INTO tbl_recvoucher VALUES("310","0","REV160223101","BILLS FROM.SEL160223101","5050.00","2023-02-16","1","2023-02-16 11:05:23");
INSERT INTO tbl_recvoucher VALUES("311","0","REV160223102","","3000.00","2023-02-16","1","2023-02-16 04:12:55");
INSERT INTO tbl_recvoucher VALUES("312","0","REV160223103","BILLS FROM.SEL140223106","500.00","2023-02-16","1","2023-02-16 06:52:36");
INSERT INTO tbl_recvoucher VALUES("313","0","REV160223104","BILLS FROM.SEL160223116","4200.00","2023-02-16","1","2023-02-16 07:37:23");
INSERT INTO tbl_recvoucher VALUES("314","0","REV160223105","","15740.00","2023-02-16","1","2023-02-16 08:27:52");
INSERT INTO tbl_recvoucher VALUES("315","0","REV160223106","abg7nojpapp","860.00","2023-02-16","1","2023-02-16 09:11:37");
INSERT INTO tbl_recvoucher VALUES("316","0","REV170223101","","8000.00","2023-02-17","1","2023-02-17 04:38:06");
INSERT INTO tbl_recvoucher VALUES("317","0","REV170223102","BILLS FROM.SEL140223117","10000.00","2023-02-17","1","2023-02-17 08:40:18");
INSERT INTO tbl_recvoucher VALUES("318","0","REV170223103","BILLS FROM.SEL170223117","2100.00","2023-02-17","1","2023-02-17 08:44:01");
INSERT INTO tbl_recvoucher VALUES("319","0","REV170223104","","2000.00","2023-02-17","1","2023-02-17 11:30:05");
INSERT INTO tbl_recvoucher VALUES("320","0","REV180223101","Bills From.SEL180223107","550.00","2023-02-18","1","2023-02-18 03:48:07");
INSERT INTO tbl_recvoucher VALUES("321","0","REV180223102","","7000.00","2023-02-18","1","2023-02-18 04:01:32");
INSERT INTO tbl_recvoucher VALUES("322","0","REV180223103","online","5350.00","2023-02-18","1","2023-02-18 09:13:42");
INSERT INTO tbl_recvoucher VALUES("323","0","REV190223101","","6500.00","2023-02-19","1","2023-02-19 05:03:38");
INSERT INTO tbl_recvoucher VALUES("324","0","REV190223102","","600.00","2023-02-19","1","2023-02-19 05:29:10");
INSERT INTO tbl_recvoucher VALUES("325","0","REV190223103","","180.00","2023-02-19","1","2023-02-19 06:30:46");
INSERT INTO tbl_recvoucher VALUES("326","0","REV190223104","BILLS FROM.SEL190223110","12000.00","2023-02-19","1","2023-02-19 07:08:57");
INSERT INTO tbl_recvoucher VALUES("327","0","REV200223101","","1250.00","2023-02-20","1","2023-02-20 03:58:00");
INSERT INTO tbl_recvoucher VALUES("328","0","REV200223102","","1178.00","2023-02-20","1","2023-02-20 10:00:17");
INSERT INTO tbl_recvoucher VALUES("329","0","REV200223103","","2010.00","2023-02-20","1","2023-02-20 10:45:58");
INSERT INTO tbl_recvoucher VALUES("330","0","REV200223104","","800.00","2023-02-20","1","2023-02-20 11:13:39");
INSERT INTO tbl_recvoucher VALUES("331","0","REV210223101","","1100.00","2023-02-21","1","2023-02-21 12:21:06");
INSERT INTO tbl_recvoucher VALUES("332","0","REV210223102","Bills From.SEL210223102","550.00","2023-02-21","1","2023-02-21 12:59:36");
INSERT INTO tbl_recvoucher VALUES("333","0","REV210223103","","380.00","2023-02-21","1","2023-02-21 06:41:46");
INSERT INTO tbl_recvoucher VALUES("334","0","REV210223104","","30000.00","2023-02-21","1","2023-02-21 09:48:41");
INSERT INTO tbl_recvoucher VALUES("335","0","REV220223101","BILLS FROM.SEL220223105","2400.00","2023-02-22","1","2023-02-22 01:17:09");
INSERT INTO tbl_recvoucher VALUES("336","0","REV220223102","","1250.00","2023-02-22","1","2023-02-22 03:12:00");
INSERT INTO tbl_recvoucher VALUES("337","0","REV220223103","","2200.00","2023-02-22","1","2023-02-22 04:07:02");
INSERT INTO tbl_recvoucher VALUES("338","0","REV220223104","","15598.00","2023-02-22","1","2023-02-22 08:46:25");
INSERT INTO tbl_recvoucher VALUES("339","0","REV220223105","","1960.00","2023-02-22","1","2023-02-22 08:49:37");
INSERT INTO tbl_recvoucher VALUES("340","0","REV230223101","bills from.SEL230223102","1350.00","2023-02-23","1","2023-02-23 10:33:42");
INSERT INTO tbl_recvoucher VALUES("341","0","REV230223102","","452.00","2023-02-23","1","2023-02-23 04:58:35");
INSERT INTO tbl_recvoucher VALUES("342","0","REV230223103","","3000.00","2023-02-23","1","2023-02-23 07:27:21");
INSERT INTO tbl_recvoucher VALUES("343","0","REV230223104","","2000.00","2023-02-23","1","2023-02-23 08:30:58");
INSERT INTO tbl_recvoucher VALUES("344","0","REV240223101","","1020.00","2023-02-24","1","2023-02-24 02:12:11");
INSERT INTO tbl_recvoucher VALUES("345","0","REV250223101","BILLS FROM.SEL250223102","3480.00","2023-02-25","1","2023-02-25 11:08:48");
INSERT INTO tbl_recvoucher VALUES("346","0","REV250223102","BILLS FROM.SEL250223103","5000.00","2023-02-25","1","2023-02-25 12:08:13");
INSERT INTO tbl_recvoucher VALUES("347","0","REV250223103","","4000.00","2023-02-25","1","2023-02-25 07:37:22");
INSERT INTO tbl_recvoucher VALUES("348","0","REV250223104","","340.00","2023-02-25","1","2023-02-25 09:19:21");
INSERT INTO tbl_recvoucher VALUES("349","0","REV250223105","","2770.00","2023-02-25","1","2023-02-25 09:47:23");
INSERT INTO tbl_recvoucher VALUES("350","0","REV250223106","","8000.00","2023-02-25","1","2023-02-25 10:19:08");
INSERT INTO tbl_recvoucher VALUES("351","0","REV260223101","","250.00","2023-02-26","1","2023-02-26 05:50:44");
INSERT INTO tbl_recvoucher VALUES("352","0","REV260223102","BILLS FROM.SEL260223123","3700.00","2023-02-26","1","2023-02-26 06:55:05");
INSERT INTO tbl_recvoucher VALUES("353","0","REV260223103","","2000.00","2023-02-26","1","2023-02-26 08:37:21");
INSERT INTO tbl_recvoucher VALUES("354","0","REV260223104","","2100.00","2023-02-26","1","2023-02-26 08:40:48");
INSERT INTO tbl_recvoucher VALUES("355","0","REV270223101","BILLS FROM.SEL270223105","945.00","2023-02-27","1","2023-02-27 04:08:52");
INSERT INTO tbl_recvoucher VALUES("356","0","REV270223102","","1662.00","2023-02-27","1","2023-02-27 10:18:59");
INSERT INTO tbl_recvoucher VALUES("357","0","REV280223101","BILLS FROM.SEL280223101","3980.00","2023-02-28","1","2023-02-28 10:44:36");
INSERT INTO tbl_recvoucher VALUES("358","0","REV280223102","","980.00","2023-02-28","1","2023-02-28 11:39:24");
INSERT INTO tbl_recvoucher VALUES("359","0","REV280223103","","280.00","2023-02-28","1","2023-02-28 12:51:45");
INSERT INTO tbl_recvoucher VALUES("360","0","REV280223104","","4000.00","2023-02-28","1","2023-02-28 09:09:01");
INSERT INTO tbl_recvoucher VALUES("361","0","REV010323101","","1500.00","2023-03-01","1","2023-03-01 11:52:41");
INSERT INTO tbl_recvoucher VALUES("362","0","REV010323102","","1500.00","2023-03-01","1","2023-03-01 01:34:23");
INSERT INTO tbl_recvoucher VALUES("363","0","REV010323103","","4130.00","2023-03-01","1","2023-03-01 01:56:45");
INSERT INTO tbl_recvoucher VALUES("364","0","REV010323104","","3621.60","2023-03-01","1","2023-03-01 04:19:17");
INSERT INTO tbl_recvoucher VALUES("365","0","REV010323105","","2000.00","2023-03-01","1","2023-03-01 08:43:44");
INSERT INTO tbl_recvoucher VALUES("366","0","REV020323101","","910.00","2023-03-02","1","2023-03-02 12:06:51");
INSERT INTO tbl_recvoucher VALUES("367","0","REV020323102","","2000.00","2023-03-02","1","2023-03-02 12:18:48");
INSERT INTO tbl_recvoucher VALUES("368","0","REV020323103","","3060.00","2023-03-02","1","2023-03-02 06:32:55");
INSERT INTO tbl_recvoucher VALUES("369","0","REV020323104","","4550.00","2023-03-02","1","2023-03-02 06:46:33");
INSERT INTO tbl_recvoucher VALUES("370","0","REV020323105","","2000.00","2023-03-02","1","2023-03-02 07:26:20");
INSERT INTO tbl_recvoucher VALUES("371","0","REV020323106","","4200.00","2023-03-02","1","2023-03-02 08:16:52");
INSERT INTO tbl_recvoucher VALUES("372","0","REV040323101","","4500.00","2023-03-04","1","2023-03-04 09:33:43");
INSERT INTO tbl_recvoucher VALUES("373","0","REV040323102","","3014.00","2023-03-04","1","2023-03-04 09:40:28");
INSERT INTO tbl_recvoucher VALUES("374","0","REV040323103","","1000.00","2023-03-04","1","2023-03-04 09:44:06");
INSERT INTO tbl_recvoucher VALUES("375","0","REV040323104","","6000.00","2023-03-04","1","2023-03-04 10:56:21");
INSERT INTO tbl_recvoucher VALUES("376","0","REV040323105","","3900.00","2023-03-04","1","2023-03-04 11:00:58");
INSERT INTO tbl_recvoucher VALUES("377","0","REV050323101","","2100.00","2023-03-05","1","2023-03-05 07:29:29");
INSERT INTO tbl_recvoucher VALUES("378","0","REV050323102","","6400.00","2023-03-05","1","2023-03-05 07:30:42");
INSERT INTO tbl_recvoucher VALUES("379","0","REV050323103","","4360.00","2023-03-05","1","2023-03-05 08:55:59");
INSERT INTO tbl_recvoucher VALUES("380","0","REV060323101","BILLS FROM.SEL060323101","500.00","2023-03-06","1","2023-03-06 10:50:00");
INSERT INTO tbl_recvoucher VALUES("381","0","REV060323102","BILLS FROM.SEL060323105","3600.00","2023-03-06","1","2023-03-06 11:50:06");
INSERT INTO tbl_recvoucher VALUES("382","0","REV060323103","","700.00","2023-03-06","1","2023-03-06 05:33:17");
INSERT INTO tbl_recvoucher VALUES("383","0","REV060323104","","1580.00","2023-03-06","1","2023-03-06 07:02:20");
INSERT INTO tbl_recvoucher VALUES("384","0","REV060323105","","2415.00","2023-03-06","1","2023-03-06 08:18:44");
INSERT INTO tbl_recvoucher VALUES("385","0","REV070323101","","1090.00","2023-03-07","1","2023-03-07 07:41:00");
INSERT INTO tbl_recvoucher VALUES("386","0","REV070323102","","2540.00","2023-03-07","1","2023-03-07 08:56:32");
INSERT INTO tbl_recvoucher VALUES("387","0","REV080323101","","3260.00","2023-03-08","1","2023-03-08 11:59:28");
INSERT INTO tbl_recvoucher VALUES("388","0","REV080323102","","5000.00","2023-03-08","1","2023-03-08 09:18:06");
INSERT INTO tbl_recvoucher VALUES("389","0","REV080323103","","200.00","2023-03-08","1","2023-03-08 09:27:56");
INSERT INTO tbl_recvoucher VALUES("390","0","REV080323104","","1800.00","2023-03-08","1","2023-03-08 09:50:11");
INSERT INTO tbl_recvoucher VALUES("391","0","REV090323101","","1804.00","2023-03-09","1","2023-03-09 01:23:17");
INSERT INTO tbl_recvoucher VALUES("392","0","REV090323102","","3600.00","2023-03-09","1","2023-03-09 04:02:31");
INSERT INTO tbl_recvoucher VALUES("393","0","REV090323103","","1300.00","2023-03-09","1","2023-03-09 07:57:33");
INSERT INTO tbl_recvoucher VALUES("394","0","REV090323104","","1000.00","2023-03-09","1","2023-03-09 08:34:48");
INSERT INTO tbl_recvoucher VALUES("395","0","REV100323101","BILLS FROM.SEL100323106","4400.00","2023-03-10","1","2023-03-10 01:41:07");
INSERT INTO tbl_recvoucher VALUES("396","0","REV100323102","","5000.00","2023-03-10","1","2023-03-10 05:17:11");
INSERT INTO tbl_recvoucher VALUES("397","0","REV100323103","","1000.00","2023-03-10","1","2023-03-10 10:14:48");
INSERT INTO tbl_recvoucher VALUES("398","0","REV100323104","","2000.00","2023-03-10","1","2023-03-10 10:19:10");
INSERT INTO tbl_recvoucher VALUES("399","0","REV110323101","","600.00","2023-03-11","1","2023-03-11 05:05:10");
INSERT INTO tbl_recvoucher VALUES("400","0","REV120323101","","3250.00","2023-03-12","1","2023-03-12 10:34:44");
INSERT INTO tbl_recvoucher VALUES("401","0","REV120323102","","500.00","2023-03-12","1","2023-03-12 11:54:28");
INSERT INTO tbl_recvoucher VALUES("402","0","REV120323103","","1900.00","2023-03-12","1","2023-03-12 01:19:12");
INSERT INTO tbl_recvoucher VALUES("403","0","REV120323104","","150.00","2023-03-12","1","2023-03-12 07:39:01");
INSERT INTO tbl_recvoucher VALUES("404","0","REV120323105","","2000.00","2023-03-12","1","2023-03-12 09:20:30");
INSERT INTO tbl_recvoucher VALUES("405","0","REV130323101","","6500.00","2023-03-13","1","2023-03-13 06:48:19");
INSERT INTO tbl_recvoucher VALUES("406","0","REV130323102","","9000.00","2023-03-13","1","2023-03-13 09:10:14");
INSERT INTO tbl_recvoucher VALUES("407","0","REV130323103","","5000.00","2023-03-13","1","2023-03-13 09:15:55");
INSERT INTO tbl_recvoucher VALUES("408","0","REV140323101","","180.00","2023-03-14","1","2023-03-14 12:54:37");
INSERT INTO tbl_recvoucher VALUES("409","0","REV140323102","","1500.00","2023-03-14","1","2023-03-14 01:32:47");
INSERT INTO tbl_recvoucher VALUES("410","0","REV140323103","","2485.00","2023-03-14","1","2023-03-14 08:29:19");
INSERT INTO tbl_recvoucher VALUES("411","0","REV140323104","","2200.00","2023-03-14","1","2023-03-14 08:32:22");
INSERT INTO tbl_recvoucher VALUES("412","0","REV150323101","","2100.00","2023-03-15","1","2023-03-15 01:31:12");
INSERT INTO tbl_recvoucher VALUES("413","0","REV150323102","","500.00","2023-03-15","1","2023-03-15 06:06:12");
INSERT INTO tbl_recvoucher VALUES("414","0","REV150323103","","2675.00","2023-03-15","1","2023-03-15 06:13:50");
INSERT INTO tbl_recvoucher VALUES("415","0","REV150323104","","2150.00","2023-03-15","1","2023-03-15 08:24:09");
INSERT INTO tbl_recvoucher VALUES("416","0","REV160323101","","480.00","2023-03-16","1","2023-03-16 01:43:55");
INSERT INTO tbl_recvoucher VALUES("417","0","REV160323102","","1680.00","2023-03-15","1","2023-03-16 02:18:02");
INSERT INTO tbl_recvoucher VALUES("418","0","REV160323103","","2540.00","2023-03-16","1","2023-03-16 06:13:07");
INSERT INTO tbl_recvoucher VALUES("419","0","REV160323104","","10000.00","2023-03-16","1","2023-03-16 06:58:36");
INSERT INTO tbl_recvoucher VALUES("420","0","REV160323105","","2000.00","2023-03-16","1","2023-03-16 09:50:04");
INSERT INTO tbl_recvoucher VALUES("421","0","REV170323101","","1000.00","2023-03-17","1","2023-03-17 05:00:28");
INSERT INTO tbl_recvoucher VALUES("422","0","REV170323102","","500.00","2023-03-17","1","2023-03-17 07:13:31");
INSERT INTO tbl_recvoucher VALUES("423","0","REV170323103","","1000.00","2023-03-17","1","2023-03-17 08:50:36");
INSERT INTO tbl_recvoucher VALUES("424","0","REV180323101","","480.00","2023-03-18","1","2023-03-18 06:42:50");
INSERT INTO tbl_recvoucher VALUES("425","0","REV180323102","","900.00","2023-03-18","1","2023-03-18 06:55:43");
INSERT INTO tbl_recvoucher VALUES("426","0","REV190323101","","1400.00","2023-03-19","1","2023-03-19 05:52:11");
INSERT INTO tbl_recvoucher VALUES("427","0","REV190323102","","600.00","2023-03-19","1","2023-03-19 08:12:10");
INSERT INTO tbl_recvoucher VALUES("428","0","REV190323103","","100.00","2023-03-19","1","2023-03-19 08:31:30");
INSERT INTO tbl_recvoucher VALUES("429","0","REV200323101","","510.00","2023-03-20","1","2023-03-20 12:42:14");
INSERT INTO tbl_recvoucher VALUES("430","0","REV200323102","","3930.00","2023-03-20","1","2023-03-20 01:13:30");
INSERT INTO tbl_recvoucher VALUES("431","0","REV200323103","","1730.00","2023-03-19","1","2023-03-20 01:27:48");
INSERT INTO tbl_recvoucher VALUES("432","0","REV200323104","","3000.00","2023-03-20","1","2023-03-20 04:56:59");
INSERT INTO tbl_recvoucher VALUES("433","0","REV200323105","","8000.00","2023-03-20","1","2023-03-20 09:17:46");
INSERT INTO tbl_recvoucher VALUES("434","0","REV200323106","","40000.00","2023-03-20","1","2023-03-20 09:18:19");
INSERT INTO tbl_recvoucher VALUES("435","0","REV200323107","","1850.00","2023-03-20","1","2023-03-20 09:20:55");
INSERT INTO tbl_recvoucher VALUES("436","0","REV200323108","","7000.00","2023-03-20","1","2023-03-20 09:55:56");
INSERT INTO tbl_recvoucher VALUES("437","0","REV200323109","","3140.00","2023-03-20","1","2023-03-20 11:17:57");
INSERT INTO tbl_recvoucher VALUES("438","0","REV210323101","","1220.00","2023-03-21","1","2023-03-21 11:11:50");
INSERT INTO tbl_recvoucher VALUES("439","0","REV210323102","","2070.00","2023-03-21","1","2023-03-21 12:21:38");
INSERT INTO tbl_recvoucher VALUES("440","0","REV210323103","","470.00","2023-03-21","1","2023-03-21 07:19:41");
INSERT INTO tbl_recvoucher VALUES("441","0","REV220323101","","1250.00","2023-03-22","1","2023-03-22 12:30:06");
INSERT INTO tbl_recvoucher VALUES("442","0","REV220323102","","1250.00","2023-03-22","1","2023-03-22 12:40:19");
INSERT INTO tbl_recvoucher VALUES("443","0","REV220323103","","700.00","2023-03-22","1","2023-03-22 04:36:28");
INSERT INTO tbl_recvoucher VALUES("444","0","REV220323104","","5460.00","2023-03-22","1","2023-03-22 06:00:20");
INSERT INTO tbl_recvoucher VALUES("445","0","REV220323105","","690.00","2023-03-22","1","2023-03-22 06:02:40");
INSERT INTO tbl_recvoucher VALUES("446","0","REV220323106","","4812.50","2023-03-22","1","2023-03-22 06:06:14");
INSERT INTO tbl_recvoucher VALUES("447","0","REV220323107","","3000.00","2023-03-22","1","2023-03-22 11:55:21");
INSERT INTO tbl_recvoucher VALUES("448","0","REV220323108","","1500.00","2023-03-22","1","2023-03-22 11:55:53");
INSERT INTO tbl_recvoucher VALUES("449","0","REV230323101","","1200.00","2023-03-23","1","2023-03-23 04:18:46");
INSERT INTO tbl_recvoucher VALUES("450","0","REV230323102","","1400.00","2023-03-23","1","2023-03-23 08:01:39");
INSERT INTO tbl_recvoucher VALUES("451","0","REV250323101","","1750.00","2023-03-25","1","2023-03-25 03:51:12");
INSERT INTO tbl_recvoucher VALUES("452","0","REV250323102","","2380.00","2023-03-25","1","2023-03-25 04:19:46");
INSERT INTO tbl_recvoucher VALUES("453","0","REV250323103","","1150.00","2023-03-25","1","2023-03-25 04:37:25");
INSERT INTO tbl_recvoucher VALUES("454","0","REV260323101","","4970.00","2023-03-26","1","2023-03-26 02:08:20");
INSERT INTO tbl_recvoucher VALUES("455","0","REV260323102","","930.00","2023-03-26","1","2023-03-26 03:47:37");
INSERT INTO tbl_recvoucher VALUES("456","0","REV260323103","","470.00","2023-03-26","1","2023-03-26 05:43:20");
INSERT INTO tbl_recvoucher VALUES("457","0","REV270323101","","7161.00","2023-03-27","1","2023-03-27 01:07:07");
INSERT INTO tbl_recvoucher VALUES("458","0","REV270323102","","840.00","2023-03-27","1","2023-03-27 01:23:04");
INSERT INTO tbl_recvoucher VALUES("459","0","REV270323103","","1100.00","2023-03-27","1","2023-03-27 04:57:57");
INSERT INTO tbl_recvoucher VALUES("460","0","REV270323104","","750.00","2023-03-27","1","2023-03-27 04:59:27");
INSERT INTO tbl_recvoucher VALUES("461","0","REV270323105","","5599.90","2023-03-27","1","2023-03-27 05:00:24");
INSERT INTO tbl_recvoucher VALUES("462","0","REV270323106","","1100.00","2023-03-27","1","2023-03-27 05:12:02");
INSERT INTO tbl_recvoucher VALUES("463","0","REV270323107","","500.00","2023-03-27","1","2023-03-27 10:02:26");
INSERT INTO tbl_recvoucher VALUES("464","0","REV280323101","","300.00","2023-03-28","1","2023-03-28 10:47:40");
INSERT INTO tbl_recvoucher VALUES("465","0","REV280323102","","4460.00","2023-03-28","1","2023-03-28 12:02:14");
INSERT INTO tbl_recvoucher VALUES("466","0","REV280323103","","950.00","2023-03-28","1","2023-03-28 05:34:00");
INSERT INTO tbl_recvoucher VALUES("467","0","REV290323101","","5000.00","2023-03-29","1","2023-03-29 10:33:03");
INSERT INTO tbl_recvoucher VALUES("468","0","REV290323102","","950.00","2023-03-29","1","2023-03-29 02:11:20");
INSERT INTO tbl_recvoucher VALUES("469","0","REV290323103","","3000.00","2023-03-29","1","2023-03-29 07:45:51");
INSERT INTO tbl_recvoucher VALUES("470","0","REV290323104","","14000.00","2023-03-29","1","2023-03-29 09:32:32");
INSERT INTO tbl_recvoucher VALUES("471","0","REV300323101","","4500.00","2023-03-30","1","2023-03-30 01:14:36");
INSERT INTO tbl_recvoucher VALUES("472","0","REV300323102","","10000.00","2023-03-30","1","2023-03-30 08:25:08");
INSERT INTO tbl_recvoucher VALUES("473","0","REV300323103","","7579.69","2023-03-30","1","2023-03-30 08:36:13");
INSERT INTO tbl_recvoucher VALUES("474","0","REV310323101","","540.00","2023-03-31","1","2023-03-31 12:25:02");
INSERT INTO tbl_recvoucher VALUES("475","0","REV310323102","","2690.00","2023-03-31","1","2023-03-31 07:47:01");
INSERT INTO tbl_recvoucher VALUES("476","0","REV310323103","","2250.00","2023-03-31","1","2023-03-31 09:04:11");
INSERT INTO tbl_recvoucher VALUES("477","0","REV310323104","","2400.00","2023-03-31","1","2023-03-31 10:37:57");
INSERT INTO tbl_recvoucher VALUES("478","0","REV010423101","","1200.00","2023-04-01","1","2023-04-01 05:29:12");
INSERT INTO tbl_recvoucher VALUES("479","0","REV010423102","","9420.00","2023-04-01","1","2023-04-01 05:33:56");
INSERT INTO tbl_recvoucher VALUES("480","0","REV010423103","","2100.00","2023-04-01","1","2023-04-01 08:57:28");
INSERT INTO tbl_recvoucher VALUES("481","0","REV010423104","","800.00","2023-04-01","1","2023-04-01 08:57:49");
INSERT INTO tbl_recvoucher VALUES("482","0","REV010423105","","3300.00","2023-04-01","1","2023-04-01 09:09:05");
INSERT INTO tbl_recvoucher VALUES("483","0","REV010423106","","2461.00","2023-04-01","1","2023-04-01 09:20:17");
INSERT INTO tbl_recvoucher VALUES("484","0","REV020423101","","3200.00","2023-04-02","1","2023-04-02 11:11:11");
INSERT INTO tbl_recvoucher VALUES("485","0","REV020423102","","300.00","2023-04-02","1","2023-04-02 12:36:22");
INSERT INTO tbl_recvoucher VALUES("486","0","REV020423103","","2780.00","2023-04-02","1","2023-04-02 04:46:39");
INSERT INTO tbl_recvoucher VALUES("487","0","REV020423104","","2860.00","2023-04-02","1","2023-04-02 05:48:25");
INSERT INTO tbl_recvoucher VALUES("488","0","REV020423105","","2500.00","2023-04-02","1","2023-04-02 08:44:35");
INSERT INTO tbl_recvoucher VALUES("489","0","REV020423106","","650.00","2023-04-02","1","2023-04-02 09:09:59");
INSERT INTO tbl_recvoucher VALUES("490","0","REV030423101","","700.00","2023-04-03","1","2023-04-03 11:16:07");
INSERT INTO tbl_recvoucher VALUES("491","0","REV030423102","","3740.00","2023-04-03","1","2023-04-03 12:01:14");
INSERT INTO tbl_recvoucher VALUES("492","0","REV030423103","","12800.00","2023-04-03","1","2023-04-03 02:57:12");
INSERT INTO tbl_recvoucher VALUES("493","0","REV030423104","","4500.00","2023-04-03","1","2023-04-03 04:48:46");
INSERT INTO tbl_recvoucher VALUES("494","0","REV030423105","","2900.00","2023-04-03","1","2023-04-03 04:49:22");
INSERT INTO tbl_recvoucher VALUES("495","0","REV030423106","","50.00","2023-04-03","1","2023-04-03 07:51:26");
INSERT INTO tbl_recvoucher VALUES("496","0","REV040423101","","180.00","2023-04-04","1","2023-04-04 02:46:55");
INSERT INTO tbl_recvoucher VALUES("497","0","REV040423102","","1874.00","2023-04-04","1","2023-04-04 04:14:18");
INSERT INTO tbl_recvoucher VALUES("498","0","REV050423101","","6000.00","2023-01-18","1","2023-04-05 03:13:36");
INSERT INTO tbl_recvoucher VALUES("499","0","REV050423102","","120.00","2023-04-05","1","2023-04-05 08:06:31");
INSERT INTO tbl_recvoucher VALUES("500","0","REV050423103","","8500.00","2023-04-05","1","2023-04-05 08:23:13");
INSERT INTO tbl_recvoucher VALUES("501","0","REV050423104","","12456.00","2023-04-05","1","2023-04-05 10:29:39");
INSERT INTO tbl_recvoucher VALUES("502","0","REV060423101","","1000.00","2023-04-06","1","2023-04-06 05:08:01");
INSERT INTO tbl_recvoucher VALUES("503","0","REV060423102","","2355.00","2023-04-06","1","2023-04-06 09:31:23");
INSERT INTO tbl_recvoucher VALUES("504","0","REV070423101","","2900.00","2023-04-07","1","2023-04-07 03:13:31");
INSERT INTO tbl_recvoucher VALUES("505","0","REV070423102","","150.00","2023-04-07","1","2023-04-07 10:06:19");
INSERT INTO tbl_recvoucher VALUES("506","0","REV070423103","","850.00","2023-04-07","1","2023-04-07 11:17:15");
INSERT INTO tbl_recvoucher VALUES("507","0","REV080423101","","4500.00","2023-04-08","1","2023-04-08 01:45:44");
INSERT INTO tbl_recvoucher VALUES("508","0","REV080423102","","2500.00","2023-04-08","1","2023-04-08 05:45:50");
INSERT INTO tbl_recvoucher VALUES("509","0","REV080423103","","1000.00","2023-04-08","1","2023-04-08 08:13:03");
INSERT INTO tbl_recvoucher VALUES("510","0","REV080423104","","1550.00","2023-04-08","1","2023-04-08 09:45:57");
INSERT INTO tbl_recvoucher VALUES("511","0","REV090423101","","7340.00","2023-04-09","1","2023-04-09 02:15:59");
INSERT INTO tbl_recvoucher VALUES("512","0","REV090423102","","10000.00","2023-04-09","1","2023-04-09 02:16:21");
INSERT INTO tbl_recvoucher VALUES("513","0","REV090423103","","250.00","2023-04-09","1","2023-04-09 03:29:12");
INSERT INTO tbl_recvoucher VALUES("514","0","REV090423104","","129.00","2023-04-09","1","2023-04-09 03:35:49");
INSERT INTO tbl_recvoucher VALUES("515","0","REV100423101","","570.00","2023-04-10","1","2023-04-10 11:01:29");
INSERT INTO tbl_recvoucher VALUES("516","0","REV100423102","","3100.00","2023-04-10","1","2023-04-10 04:14:11");
INSERT INTO tbl_recvoucher VALUES("517","0","REV100423103","","900.00","2023-04-10","1","2023-04-10 04:14:38");
INSERT INTO tbl_recvoucher VALUES("518","0","REV130423101","","20000.00","2023-04-13","1","2023-04-13 05:04:14");
INSERT INTO tbl_recvoucher VALUES("519","0","REV130423102","","5320.00","2023-04-13","1","2023-04-13 11:12:45");
INSERT INTO tbl_recvoucher VALUES("520","0","REV140423101","","1400.00","2023-04-14","1","2023-04-14 03:51:50");
INSERT INTO tbl_recvoucher VALUES("521","0","REV140423102","","2000.00","2023-04-14","1","2023-04-14 08:13:32");
INSERT INTO tbl_recvoucher VALUES("522","0","REV150423101","","1250.00","2023-04-15","1","2023-04-15 10:13:27");
INSERT INTO tbl_recvoucher VALUES("523","0","REV180423101","","5000.00","2023-04-16","1","2023-04-18 03:18:44");
INSERT INTO tbl_recvoucher VALUES("524","0","REV180423102","","3000.00","2023-04-18","1","2023-04-18 03:19:06");
INSERT INTO tbl_recvoucher VALUES("525","0","REV190423101","","500.00","2023-04-19","1","2023-04-19 04:23:55");
INSERT INTO tbl_recvoucher VALUES("526","0","REV190423102","","1999.90","2023-04-19","1","2023-04-19 04:29:33");
INSERT INTO tbl_recvoucher VALUES("527","0","REV190423103","","2000.00","2023-04-19","1","2023-04-19 07:43:29");
INSERT INTO tbl_recvoucher VALUES("528","0","REV190423104","","7100.00","2023-04-19","1","2023-04-19 09:08:51");
INSERT INTO tbl_recvoucher VALUES("529","0","REV190423105","","2000.00","2023-04-19","1","2023-04-19 09:09:27");
INSERT INTO tbl_recvoucher VALUES("530","0","REV190423106","","1000.00","2023-04-13","1","2023-04-19 09:33:28");
INSERT INTO tbl_recvoucher VALUES("531","0","REV190423107","","10000.00","2023-04-19","1","2023-04-19 11:00:27");
INSERT INTO tbl_recvoucher VALUES("532","0","REV190423108","","10000.00","2023-04-19","1","2023-04-19 11:02:38");
INSERT INTO tbl_recvoucher VALUES("533","0","REV200423101","","730.00","2023-04-20","1","2023-04-20 08:56:03");
INSERT INTO tbl_recvoucher VALUES("534","0","REV200423102","","7750.00","2023-04-20","1","2023-04-20 08:59:53");
INSERT INTO tbl_recvoucher VALUES("535","0","REV200423103","","1600.00","2023-04-20","1","2023-04-20 09:02:13");
INSERT INTO tbl_recvoucher VALUES("536","0","REV200423104","","6490.00","2023-04-20","1","2023-04-20 11:00:07");
INSERT INTO tbl_recvoucher VALUES("537","0","REV210423101","","2640.00","2023-04-21","1","2023-04-21 08:25:27");
INSERT INTO tbl_recvoucher VALUES("538","0","REV220423101","","558.00","2023-04-21","1","2023-04-22 12:00:05");
INSERT INTO tbl_recvoucher VALUES("539","0","REV230423101","","2180.00","2023-04-23","1","2023-04-23 08:18:40");
INSERT INTO tbl_recvoucher VALUES("540","0","REV240423101","","600.00","2023-04-24","1","2023-04-24 06:52:51");
INSERT INTO tbl_recvoucher VALUES("541","0","REV250423101","","1500.00","2023-04-25","1","2023-04-25 04:32:32");
INSERT INTO tbl_recvoucher VALUES("542","0","REV250423102","","900.00","2023-04-25","1","2023-04-25 06:44:37");
INSERT INTO tbl_recvoucher VALUES("543","0","REV250423103","","1250.00","2023-04-25","1","2023-04-25 08:04:24");
INSERT INTO tbl_recvoucher VALUES("544","0","REV250423104","","500.00","2023-04-25","1","2023-04-25 09:09:19");
INSERT INTO tbl_recvoucher VALUES("545","0","REV250423105","","15860.00","2023-04-25","1","2023-04-25 10:48:51");
INSERT INTO tbl_recvoucher VALUES("546","0","REV260423101","","50.00","2023-04-26","1","2023-04-26 02:22:10");
INSERT INTO tbl_recvoucher VALUES("547","0","REV260423102","","950.00","2023-04-26","1","2023-04-26 10:38:42");
INSERT INTO tbl_recvoucher VALUES("548","0","REV260423103","","1300.00","2023-04-26","1","2023-04-26 10:41:12");
INSERT INTO tbl_recvoucher VALUES("549","0","REV270423101","","1200.00","2023-04-27","1","2023-04-27 12:36:43");
INSERT INTO tbl_recvoucher VALUES("550","0","REV270423102","","1050.00","2023-04-27","1","2023-04-27 02:01:46");
INSERT INTO tbl_recvoucher VALUES("551","0","REV270423103","","3800.00","2023-04-27","1","2023-04-27 05:21:56");
INSERT INTO tbl_recvoucher VALUES("552","0","REV270423104","","13220.00","2023-04-27","1","2023-04-27 07:47:04");
INSERT INTO tbl_recvoucher VALUES("553","0","REV280423101","","239.00","2023-04-28","1","2023-04-28 11:56:15");
INSERT INTO tbl_recvoucher VALUES("554","0","REV280423102","","3100.00","2023-04-28","1","2023-04-28 12:15:00");
INSERT INTO tbl_recvoucher VALUES("555","0","REV290423101","","5000.00","2023-04-29","1","2023-04-29 11:02:18");
INSERT INTO tbl_recvoucher VALUES("556","0","REV300423101","","10000.00","2023-04-30","1","2023-04-30 01:17:02");
INSERT INTO tbl_recvoucher VALUES("557","0","REV300423102","","2800.00","2023-04-30","1","2023-04-30 02:29:46");
INSERT INTO tbl_recvoucher VALUES("558","0","REV010523101","","3550.00","2023-05-01","1","2023-05-01 03:54:10");
INSERT INTO tbl_recvoucher VALUES("559","0","REV010523102","","950.00","2023-05-01","1","2023-05-01 05:54:08");
INSERT INTO tbl_recvoucher VALUES("560","0","REV010523103","","2450.00","2023-05-01","1","2023-05-01 08:45:22");
INSERT INTO tbl_recvoucher VALUES("561","0","REV010523104","","6200.00","2023-05-01","1","2023-05-01 08:47:49");
INSERT INTO tbl_recvoucher VALUES("562","0","REV020523101","","3180.00","2023-05-02","1","2023-05-02 06:54:15");
INSERT INTO tbl_recvoucher VALUES("563","0","REV020523102","","2740.00","2023-05-02","1","2023-05-02 07:47:13");
INSERT INTO tbl_recvoucher VALUES("564","0","REV020523103","","1220.00","2023-05-02","1","2023-05-02 11:08:04");
INSERT INTO tbl_recvoucher VALUES("565","0","REV030523101","","585.00","2023-05-03","1","2023-05-03 01:52:53");
INSERT INTO tbl_recvoucher VALUES("566","0","REV030523102","","200.00","2023-05-03","1","2023-05-03 01:54:56");
INSERT INTO tbl_recvoucher VALUES("567","0","REV030523103","","100.00","2023-05-03","1","2023-05-03 08:02:37");
INSERT INTO tbl_recvoucher VALUES("568","0","REV030523104","","5740.00","2023-05-03","1","2023-05-03 11:56:16");
INSERT INTO tbl_recvoucher VALUES("569","0","REV040523101","","3150.00","2023-05-04","1","2023-05-04 01:16:39");
INSERT INTO tbl_recvoucher VALUES("570","0","REV040523102","","800.00","2023-05-04","1","2023-05-04 05:35:24");
INSERT INTO tbl_recvoucher VALUES("571","0","REV040523103","","3900.00","2023-05-04","1","2023-05-04 05:39:51");
INSERT INTO tbl_recvoucher VALUES("572","0","REV040523104","","500.00","2023-05-04","1","2023-05-04 09:54:27");
INSERT INTO tbl_recvoucher VALUES("573","0","REV040523105","","7000.00","2023-05-04","1","2023-05-04 11:20:31");
INSERT INTO tbl_recvoucher VALUES("574","0","REV050523101","","650.00","2023-05-02","1","2023-05-05 02:11:30");
INSERT INTO tbl_recvoucher VALUES("575","0","REV050523102","","1350.00","2023-05-05","1","2023-05-05 09:40:45");
INSERT INTO tbl_recvoucher VALUES("576","0","REV060523101","","4000.00","2023-05-06","1","2023-05-06 03:10:35");
INSERT INTO tbl_recvoucher VALUES("577","0","REV060523102","","20000.00","2023-05-06","1","2023-05-06 08:05:45");
INSERT INTO tbl_recvoucher VALUES("578","0","REV060523103","","10000.00","2023-05-06","1","2023-05-06 08:30:34");
INSERT INTO tbl_recvoucher VALUES("579","0","REV060523104","","400.00","2023-05-06","1","2023-05-06 10:30:17");
INSERT INTO tbl_recvoucher VALUES("580","0","REV060523105","","300.00","2023-05-06","1","2023-05-06 10:38:03");
INSERT INTO tbl_recvoucher VALUES("581","0","REV060523106","","708.00","2023-04-20","1","2023-05-06 10:38:58");
INSERT INTO tbl_recvoucher VALUES("582","0","REV070523101","","2000.00","2023-05-07","1","2023-05-07 05:39:39");
INSERT INTO tbl_recvoucher VALUES("583","0","REV070523102","","3030.00","2023-05-07","1","2023-05-07 06:13:00");
INSERT INTO tbl_recvoucher VALUES("584","0","REV070523103","","1700.00","2023-05-07","1","2023-05-07 06:19:57");
INSERT INTO tbl_recvoucher VALUES("585","0","REV070523104","","1644.00","2023-05-07","1","2023-05-07 07:48:43");
INSERT INTO tbl_recvoucher VALUES("586","0","REV070523105","","400.00","2023-05-07","1","2023-05-07 07:53:12");
INSERT INTO tbl_recvoucher VALUES("587","0","REV070523106","","1500.00","2023-05-07","1","2023-05-07 11:11:49");
INSERT INTO tbl_recvoucher VALUES("588","0","REV080523101","","2800.00","2023-05-08","1","2023-05-08 12:42:49");
INSERT INTO tbl_recvoucher VALUES("589","0","REV080523102","","3154.00","2023-05-08","1","2023-05-08 03:20:36");
INSERT INTO tbl_recvoucher VALUES("590","0","REV080523103","","15000.00","2023-05-08","1","2023-05-08 06:04:09");
INSERT INTO tbl_recvoucher VALUES("591","0","REV080523104","","800.00","2023-05-08","1","2023-05-08 09:48:59");
INSERT INTO tbl_recvoucher VALUES("592","0","REV090523101","","1950.00","2023-05-04","1","2023-05-09 01:29:37");
INSERT INTO tbl_recvoucher VALUES("593","0","REV090523102","","1650.00","2023-05-08","1","2023-05-09 01:30:27");
INSERT INTO tbl_recvoucher VALUES("594","0","REV090523103","","2840.00","2023-05-09","1","2023-05-09 01:42:24");
INSERT INTO tbl_recvoucher VALUES("595","0","REV090523104","","10000.00","2023-05-09","1","2023-05-09 03:37:49");
INSERT INTO tbl_recvoucher VALUES("596","0","REV090523105","","1400.00","2023-05-09","1","2023-05-09 07:10:23");
INSERT INTO tbl_recvoucher VALUES("597","0","REV100523101","","1100.00","2023-05-10","1","2023-05-10 02:17:23");
INSERT INTO tbl_recvoucher VALUES("598","0","REV100523102","","1500.00","2023-05-10","1","2023-05-10 09:15:46");
INSERT INTO tbl_recvoucher VALUES("599","0","REV100523103","","725.00","2023-05-10","1","2023-05-10 10:32:18");
INSERT INTO tbl_recvoucher VALUES("600","0","REV100523104","","3500.00","2023-05-10","1","2023-05-10 11:58:54");
INSERT INTO tbl_recvoucher VALUES("601","0","REV110523101","","20000.00","2023-05-11","1","2023-05-11 06:31:57");
INSERT INTO tbl_recvoucher VALUES("602","0","REV110523102","","20.00","2023-05-11","1","2023-05-11 08:04:28");
INSERT INTO tbl_recvoucher VALUES("603","0","REV120523101","","1559.00","2023-05-12","1","2023-05-12 08:42:44");
INSERT INTO tbl_recvoucher VALUES("604","0","REV120523102","","3250.00","2023-05-12","1","2023-05-12 11:33:48");
INSERT INTO tbl_recvoucher VALUES("605","0","REV130523101","","400.00","2023-05-13","1","2023-05-13 07:46:05");
INSERT INTO tbl_recvoucher VALUES("606","0","REV130523102","","12600.00","2023-05-13","1","2023-05-13 10:42:14");
INSERT INTO tbl_recvoucher VALUES("607","0","REV130523103","","3600.00","2023-05-13","1","2023-05-13 11:09:24");
INSERT INTO tbl_recvoucher VALUES("608","0","REV130523104","","4400.00","2023-05-13","1","2023-05-13 11:15:39");
INSERT INTO tbl_recvoucher VALUES("609","0","REV130523105","","3330.00","2023-05-13","1","2023-05-13 11:18:11");
INSERT INTO tbl_recvoucher VALUES("610","0","REV150523101","","1650.00","2023-05-14","1","2023-05-15 12:00:44");
INSERT INTO tbl_recvoucher VALUES("611","0","REV150523102","","2550.00","2023-05-15","1","2023-05-15 12:01:32");
INSERT INTO tbl_recvoucher VALUES("612","0","REV160523101","","6400.00","2023-05-16","1","2023-05-16 02:19:26");
INSERT INTO tbl_recvoucher VALUES("613","0","REV160523102","","5000.00","2023-05-15","1","2023-05-16 07:04:55");
INSERT INTO tbl_recvoucher VALUES("614","0","REV160523103","","3000.00","2023-05-16","1","2023-05-16 10:48:10");
INSERT INTO tbl_recvoucher VALUES("615","0","REV170523101","","5000.00","2023-05-17","1","2023-05-17 05:32:31");
INSERT INTO tbl_recvoucher VALUES("616","0","REV170523102","","500.00","2023-05-17","1","2023-05-17 08:33:22");
INSERT INTO tbl_recvoucher VALUES("617","0","REV170523103","","1850.00","2023-05-14","1","2023-05-17 08:44:40");
INSERT INTO tbl_recvoucher VALUES("618","0","REV170523104","","1700.00","2023-05-17","1","2023-05-17 10:35:26");
INSERT INTO tbl_recvoucher VALUES("619","0","REV180523101","","5000.00","2023-05-18","1","2023-05-18 10:03:26");
INSERT INTO tbl_recvoucher VALUES("620","0","REV180523102","","4000.00","2023-05-18","1","2023-05-18 10:04:50");
INSERT INTO tbl_recvoucher VALUES("621","0","REV190523101","","600.00","2023-05-19","1","2023-05-19 11:41:16");
INSERT INTO tbl_recvoucher VALUES("622","0","REV190523102","","2900.00","2023-05-19","1","2023-05-19 01:18:42");
INSERT INTO tbl_recvoucher VALUES("623","0","REV190523103","","1400.00","2023-05-19","1","2023-05-19 02:33:15");
INSERT INTO tbl_recvoucher VALUES("624","0","REV190523104","","500.00","2023-05-19","1","2023-05-19 02:44:31");
INSERT INTO tbl_recvoucher VALUES("625","0","REV190523105","","5000.00","2023-05-19","1","2023-05-19 09:07:09");
INSERT INTO tbl_recvoucher VALUES("626","0","REV190523106","","11780.00","2023-05-19","1","2023-05-19 11:45:35");
INSERT INTO tbl_recvoucher VALUES("627","0","REV200523101","","5000.00","2023-05-20","1","2023-05-20 05:41:01");
INSERT INTO tbl_recvoucher VALUES("628","0","REV200523102","","13999.00","2023-05-20","1","2023-05-20 07:45:31");
INSERT INTO tbl_recvoucher VALUES("629","0","REV200523103","","10000.00","2023-05-20","1","2023-05-20 07:49:40");
INSERT INTO tbl_recvoucher VALUES("630","0","REV210523101","","850.00","2023-05-21","1","2023-05-21 05:09:17");
INSERT INTO tbl_recvoucher VALUES("631","0","REV210523102","","750.00","2023-05-21","1","2023-05-21 05:11:41");
INSERT INTO tbl_recvoucher VALUES("632","0","REV210523103","","8000.00","2023-05-21","1","2023-05-21 09:26:40");
INSERT INTO tbl_recvoucher VALUES("633","0","REV220523101","","7755.00","2023-05-20","1","2023-05-22 01:56:58");
INSERT INTO tbl_recvoucher VALUES("634","0","REV220523102","","2000.00","2023-05-22","1","2023-05-22 08:42:58");
INSERT INTO tbl_recvoucher VALUES("635","0","REV240523101","Tuhin","7000.00","2023-05-24","1","2023-05-24 03:02:14");
INSERT INTO tbl_recvoucher VALUES("636","0","REV240523102","","3100.00","2023-05-24","1","2023-05-24 10:15:28");
INSERT INTO tbl_recvoucher VALUES("637","0","REV240523103","","900.00","2023-05-24","1","2023-05-24 10:25:06");
INSERT INTO tbl_recvoucher VALUES("638","0","REV250523101","","2000.00","2023-05-25","1","2023-05-25 08:11:20");
INSERT INTO tbl_recvoucher VALUES("639","0","REV250523102","","1000.00","2023-05-25","1","2023-05-25 09:02:32");
INSERT INTO tbl_recvoucher VALUES("640","0","REV260523101","","4000.00","2023-05-26","1","2023-05-26 05:49:09");
INSERT INTO tbl_recvoucher VALUES("641","0","REV260523102","","1524.00","2023-05-26","1","2023-05-26 08:11:03");
INSERT INTO tbl_recvoucher VALUES("642","0","REV260523103","","930.00","2023-05-26","1","2023-05-26 09:36:39");
INSERT INTO tbl_recvoucher VALUES("643","0","REV260523104","","650.00","2023-05-26","1","2023-05-26 10:55:00");
INSERT INTO tbl_recvoucher VALUES("644","0","REV270523101","","13603.00","2023-05-27","1","2023-05-27 09:00:38");
INSERT INTO tbl_recvoucher VALUES("645","0","REV270523102","","950.00","2023-05-27","1","2023-05-27 09:10:37");
INSERT INTO tbl_recvoucher VALUES("646","0","REV270523103","","2560.00","2023-05-15","1","2023-05-27 09:19:03");
INSERT INTO tbl_recvoucher VALUES("647","0","REV270523104","","2620.00","2023-05-21","1","2023-05-27 09:19:53");
INSERT INTO tbl_recvoucher VALUES("648","0","REV280523101","","750.00","2023-05-28","1","2023-05-28 11:30:30");
INSERT INTO tbl_recvoucher VALUES("649","0","REV280523102","","10000.00","2023-05-28","1","2023-05-28 07:12:35");
INSERT INTO tbl_recvoucher VALUES("650","0","REV280523103","","5000.00","2023-05-28","1","2023-05-28 08:50:47");
INSERT INTO tbl_recvoucher VALUES("651","0","REV280523104","","2340.00","2023-05-28","1","2023-05-28 09:00:12");
INSERT INTO tbl_recvoucher VALUES("652","0","REV280523105","","1640.00","2023-05-28","1","2023-05-28 09:00:53");
INSERT INTO tbl_recvoucher VALUES("653","0","REV280523106","","1400.00","2023-05-28","1","2023-05-28 09:34:09");
INSERT INTO tbl_recvoucher VALUES("654","0","REV290523101","","2799.00","2023-05-28","1","2023-05-29 03:11:57");
INSERT INTO tbl_recvoucher VALUES("655","0","REV290523102","","3500.00","2023-05-29","1","2023-05-29 08:52:18");
INSERT INTO tbl_recvoucher VALUES("656","0","REV290523103","","3000.00","2023-05-29","1","2023-05-29 08:53:28");
INSERT INTO tbl_recvoucher VALUES("657","0","REV300523101","","2900.00","2023-05-29","1","2023-05-30 11:47:29");
INSERT INTO tbl_recvoucher VALUES("658","0","REV300523102","","250.00","2023-05-30","1","2023-05-30 03:01:18");
INSERT INTO tbl_recvoucher VALUES("659","0","REV300523103","","1500.00","2023-05-30","1","2023-05-30 03:42:27");
INSERT INTO tbl_recvoucher VALUES("660","0","REV300523104","","90.00","2023-05-30","1","2023-05-30 07:06:26");
INSERT INTO tbl_recvoucher VALUES("661","0","REV300523105","","700.00","2023-05-28","1","2023-05-30 08:30:49");
INSERT INTO tbl_recvoucher VALUES("662","0","REV300523106","","6300.00","2023-05-30","1","2023-05-30 10:15:13");
INSERT INTO tbl_recvoucher VALUES("663","0","REV010623101","","2310.00","2023-06-01","1","2023-06-01 11:17:07");
INSERT INTO tbl_recvoucher VALUES("664","0","REV010623102","","535.00","2023-06-01","1","2023-06-01 07:19:28");
INSERT INTO tbl_recvoucher VALUES("665","0","REV020623101","","4700.00","2023-06-02","1","2023-06-02 12:32:21");
INSERT INTO tbl_recvoucher VALUES("666","0","REV020623102","","4000.00","2023-06-02","1","2023-06-02 12:33:13");
INSERT INTO tbl_recvoucher VALUES("667","0","REV020623103","","2000.00","2023-06-02","1","2023-06-02 12:46:11");
INSERT INTO tbl_recvoucher VALUES("668","0","REV020623104","","3400.00","2023-05-31","1","2023-06-02 07:50:32");
INSERT INTO tbl_recvoucher VALUES("669","0","REV020623105","","2800.00","2023-06-02","1","2023-06-02 09:14:17");
INSERT INTO tbl_recvoucher VALUES("670","0","REV030623101","","5000.00","2023-06-03","1","2023-06-03 08:44:07");
INSERT INTO tbl_recvoucher VALUES("671","0","REV030623102","","5440.00","2023-06-03","1","2023-06-03 08:47:05");
INSERT INTO tbl_recvoucher VALUES("672","0","REV030623103","","950.00","2023-06-03","1","2023-06-03 08:48:38");
INSERT INTO tbl_recvoucher VALUES("673","0","REV030623104","","400.00","2023-06-03","1","2023-06-03 10:47:34");
INSERT INTO tbl_recvoucher VALUES("674","0","REV040623101","","1140.00","2023-06-04","1","2023-06-04 12:21:57");
INSERT INTO tbl_recvoucher VALUES("675","0","REV040623102","","5000.00","2023-06-04","1","2023-06-04 01:59:51");
INSERT INTO tbl_recvoucher VALUES("676","0","REV040623103","","1000.00","2023-06-04","1","2023-06-04 04:35:42");
INSERT INTO tbl_recvoucher VALUES("677","0","REV040623104","","1850.00","2023-06-04","1","2023-06-04 05:15:10");
INSERT INTO tbl_recvoucher VALUES("678","0","REV040623105","","10000.00","2023-06-04","1","2023-06-04 06:32:13");
INSERT INTO tbl_recvoucher VALUES("679","0","REV040623106","","5000.00","2023-06-04","1","2023-06-04 08:53:49");
INSERT INTO tbl_recvoucher VALUES("680","0","REV040623107","","5400.00","2023-06-04","1","2023-06-04 09:34:58");
INSERT INTO tbl_recvoucher VALUES("681","0","REV050623101","","9000.00","2023-06-05","1","2023-06-05 01:32:48");
INSERT INTO tbl_recvoucher VALUES("682","0","REV050623102","","5350.00","2023-06-05","1","2023-06-05 08:37:52");
INSERT INTO tbl_recvoucher VALUES("683","0","REV060623101","","3380.00","2023-06-06","1","2023-06-06 12:58:01");
INSERT INTO tbl_recvoucher VALUES("684","0","REV060623102","","2800.00","2023-06-06","1","2023-06-06 01:04:18");
INSERT INTO tbl_recvoucher VALUES("685","0","REV060623103","","1500.00","2023-06-06","1","2023-06-06 02:21:33");
INSERT INTO tbl_recvoucher VALUES("686","0","REV060623104","","2600.00","2023-06-06","1","2023-06-06 05:47:54");
INSERT INTO tbl_recvoucher VALUES("687","0","REV060623105","","4500.00","2023-06-06","1","2023-06-06 09:35:00");
INSERT INTO tbl_recvoucher VALUES("688","0","REV060623106","","500.00","2023-05-22","1","2023-06-06 09:45:59");
INSERT INTO tbl_recvoucher VALUES("689","0","REV060623107","","1030.00","2023-06-06","1","2023-06-06 10:12:52");
INSERT INTO tbl_recvoucher VALUES("690","0","REV060623108","","1250.00","2023-06-06","1","2023-06-06 11:10:40");
INSERT INTO tbl_recvoucher VALUES("691","0","REV070623101","","560.00","2023-06-07","1","2023-06-07 01:24:35");
INSERT INTO tbl_recvoucher VALUES("692","0","REV070623102","","1500.00","2023-06-07","1","2023-06-07 03:06:15");
INSERT INTO tbl_recvoucher VALUES("693","0","REV070623103","","2200.00","2023-06-07","1","2023-06-07 03:16:26");
INSERT INTO tbl_recvoucher VALUES("694","0","REV070623104","","16000.00","2023-06-07","1","2023-06-07 07:32:32");
INSERT INTO tbl_recvoucher VALUES("695","0","REV080623101","","1570.00","2023-06-08","1","2023-06-08 02:10:09");
INSERT INTO tbl_recvoucher VALUES("696","0","REV080623102","","2200.00","2023-06-08","1","2023-06-08 07:15:27");
INSERT INTO tbl_recvoucher VALUES("697","0","REV080623103","","5500.00","2023-06-08","1","2023-06-08 08:45:47");
INSERT INTO tbl_recvoucher VALUES("698","0","REV080623104","","3000.00","2023-06-08","1","2023-06-08 09:47:36");
INSERT INTO tbl_recvoucher VALUES("699","0","REV080623105","","630.00","2023-06-08","1","2023-06-08 09:48:56");
INSERT INTO tbl_recvoucher VALUES("700","0","REV080623106","","3400.00","2023-06-08","1","2023-06-08 10:43:44");
INSERT INTO tbl_recvoucher VALUES("701","0","REV080623107","","8150.00","2023-06-08","1","2023-06-08 11:12:48");
INSERT INTO tbl_recvoucher VALUES("702","0","REV090623101","","1100.00","2023-06-09","1","2023-06-09 04:09:09");
INSERT INTO tbl_recvoucher VALUES("703","0","REV090623102","","500.00","2023-06-09","1","2023-06-09 06:13:49");
INSERT INTO tbl_recvoucher VALUES("704","0","REV090623103","","5000.00","2023-06-09","1","2023-06-09 06:39:27");
INSERT INTO tbl_recvoucher VALUES("705","0","REV110623101","","11681.00","2023-06-11","1","2023-06-11 05:17:46");
INSERT INTO tbl_recvoucher VALUES("706","0","REV110623102","","200.00","2023-06-11","1","2023-06-11 09:03:17");
INSERT INTO tbl_recvoucher VALUES("707","0","REV110623103","","3700.00","2023-06-11","1","2023-06-11 10:15:19");
INSERT INTO tbl_recvoucher VALUES("708","0","REV120623101","","5100.00","2023-06-12","1","2023-06-12 11:33:14");
INSERT INTO tbl_recvoucher VALUES("709","0","REV120623102","","1000.00","2023-06-12","1","2023-06-12 07:58:22");
INSERT INTO tbl_recvoucher VALUES("710","0","REV120623103","","4105.00","2023-06-12","1","2023-06-12 08:20:08");
INSERT INTO tbl_recvoucher VALUES("711","0","REV120623104","","1500.00","2023-06-12","1","2023-06-12 08:29:11");
INSERT INTO tbl_recvoucher VALUES("712","0","REV120623105","","8070.00","2023-06-12","1","2023-06-12 08:52:03");
INSERT INTO tbl_recvoucher VALUES("713","0","REV120623106","","1650.00","2023-06-12","1","2023-06-12 11:33:12");
INSERT INTO tbl_recvoucher VALUES("714","0","REV120623107","","1500.00","2023-06-12","1","2023-06-12 11:35:13");
INSERT INTO tbl_recvoucher VALUES("715","0","REV120623108","","2500.00","2023-06-12","1","2023-06-12 11:44:29");
INSERT INTO tbl_recvoucher VALUES("716","0","REV120623109","","180.00","2023-06-12","1","2023-06-12 11:50:51");
INSERT INTO tbl_recvoucher VALUES("717","0","REV130623101","","10000.00","2023-06-13","1","2023-06-13 11:09:52");
INSERT INTO tbl_recvoucher VALUES("718","0","REV130623102","","750.00","2023-06-13","1","2023-06-13 07:15:13");
INSERT INTO tbl_recvoucher VALUES("719","0","REV130623103","","1650.00","2023-06-13","1","2023-06-13 07:17:51");
INSERT INTO tbl_recvoucher VALUES("720","0","REV130623104","","150.00","2023-06-13","1","2023-06-13 08:07:52");
INSERT INTO tbl_recvoucher VALUES("721","0","REV140623101","","3000.00","2023-06-14","1","2023-06-14 04:14:07");
INSERT INTO tbl_recvoucher VALUES("723","0","REV140623103","","950.00","2023-06-14","1","2023-06-14 07:29:23");
INSERT INTO tbl_recvoucher VALUES("724","0","REV140623104","","3400.00","2023-06-14","1","2023-06-14 08:01:42");
INSERT INTO tbl_recvoucher VALUES("725","0","REV140623105","","1250.00","2023-06-14","1","2023-06-14 08:28:57");
INSERT INTO tbl_recvoucher VALUES("726","0","REV150623101","","3600.00","2023-06-14","1","2023-06-15 04:32:08");
INSERT INTO tbl_recvoucher VALUES("727","0","REV150623102","","2000.00","2023-06-15","1","2023-06-15 09:09:56");
INSERT INTO tbl_recvoucher VALUES("728","0","REV160623101","","1335.00","2023-06-16","1","2023-06-16 03:57:59");
INSERT INTO tbl_recvoucher VALUES("729","0","REV160623102","","9550.00","2023-06-16","1","2023-06-16 08:30:06");
INSERT INTO tbl_recvoucher VALUES("730","0","REV160623103","","9000.00","2023-06-16","1","2023-06-16 08:42:01");
INSERT INTO tbl_recvoucher VALUES("731","0","REV160623104","","1000.00","2023-06-16","1","2023-06-16 08:51:05");
INSERT INTO tbl_recvoucher VALUES("732","0","REV170623101","","3200.00","2023-06-17","1","2023-06-17 10:17:42");
INSERT INTO tbl_recvoucher VALUES("733","0","REV170623102","","15000.00","2023-06-17","1","2023-06-17 10:41:30");
INSERT INTO tbl_recvoucher VALUES("734","0","REV180623101","","700.00","2023-06-18","1","2023-06-18 01:57:42");
INSERT INTO tbl_recvoucher VALUES("735","0","REV180623102","","2785.00","2023-06-18","1","2023-06-18 02:31:31");
INSERT INTO tbl_recvoucher VALUES("736","0","REV180623103","","1000.00","2023-06-18","1","2023-06-18 03:26:02");
INSERT INTO tbl_recvoucher VALUES("737","0","REV180623104","","1300.00","2023-06-18","1","2023-06-18 04:57:25");
INSERT INTO tbl_recvoucher VALUES("738","0","REV180623105","","500.00","2023-06-18","1","2023-06-18 09:22:03");
INSERT INTO tbl_recvoucher VALUES("739","0","REV190623101","","7000.00","2023-06-19","1","2023-06-19 07:40:09");
INSERT INTO tbl_recvoucher VALUES("740","0","REV190623102","","11600.00","2023-06-19","1","2023-06-19 08:12:44");
INSERT INTO tbl_recvoucher VALUES("741","0","REV190623103","","2000.00","2023-06-19","1","2023-06-19 08:49:30");
INSERT INTO tbl_recvoucher VALUES("742","0","REV200623101","","1070.00","2023-06-20","1","2023-06-20 10:47:14");
INSERT INTO tbl_recvoucher VALUES("743","0","REV200623102","","6450.00","2023-06-20","1","2023-06-20 04:04:55");
INSERT INTO tbl_recvoucher VALUES("744","0","REV200623103","","20000.00","2023-06-20","1","2023-06-20 04:22:30");
INSERT INTO tbl_recvoucher VALUES("745","0","REV200623104","","5000.00","2023-06-18","1","2023-06-20 04:30:06");
INSERT INTO tbl_recvoucher VALUES("746","0","REV200623105","","4080.00","2023-06-20","1","2023-06-20 04:58:03");
INSERT INTO tbl_recvoucher VALUES("747","0","REV200623106","","2150.00","2023-06-20","1","2023-06-20 06:39:06");
INSERT INTO tbl_recvoucher VALUES("748","0","REV220623101","","15590.00","2023-02-21","1","2023-06-22 10:41:10");
INSERT INTO tbl_recvoucher VALUES("749","0","REV220623102","","660.00","2023-06-22","1","2023-06-22 12:36:44");
INSERT INTO tbl_recvoucher VALUES("750","0","REV220623103","","2000.00","2023-06-22","1","2023-06-22 03:58:46");
INSERT INTO tbl_recvoucher VALUES("751","0","REV220623104","","1000.00","2023-06-22","1","2023-06-22 07:15:30");
INSERT INTO tbl_recvoucher VALUES("752","0","REV220623105","","1250.00","2023-06-22","1","2023-06-22 08:29:49");
INSERT INTO tbl_recvoucher VALUES("753","0","REV230623101","","3200.00","2023-06-22","1","2023-06-23 01:34:48");
INSERT INTO tbl_recvoucher VALUES("754","0","REV230623102","","730.00","2023-06-22","1","2023-06-23 01:38:17");
INSERT INTO tbl_recvoucher VALUES("755","0","REV240623101","","4031.00","2023-06-24","1","2023-06-24 06:57:23");
INSERT INTO tbl_recvoucher VALUES("756","0","REV240623102","","100.00","2023-06-24","1","2023-06-24 08:25:03");
INSERT INTO tbl_recvoucher VALUES("757","0","REV240623103","","15330.00","2023-06-24","1","2023-06-24 08:32:53");
INSERT INTO tbl_recvoucher VALUES("758","0","REV240623104","","1700.00","2023-06-24","1","2023-06-24 09:06:12");
INSERT INTO tbl_recvoucher VALUES("759","0","REV240623105","","1280.00","2023-06-24","1","2023-06-24 11:00:55");
INSERT INTO tbl_recvoucher VALUES("760","0","REV250623101","","1950.00","2023-06-25","1","2023-06-25 11:01:45");
INSERT INTO tbl_recvoucher VALUES("761","0","REV250623102","","4500.00","2023-06-25","1","2023-06-25 12:03:29");
INSERT INTO tbl_recvoucher VALUES("762","0","REV250623103","","5000.00","2023-06-25","1","2023-06-25 01:19:57");
INSERT INTO tbl_recvoucher VALUES("763","0","REV250623104","","4389.60","2023-06-25","1","2023-06-25 08:23:26");
INSERT INTO tbl_recvoucher VALUES("764","0","REV260623101","","1100.00","2023-06-26","1","2023-06-26 06:48:37");
INSERT INTO tbl_recvoucher VALUES("765","0","REV260623102","","12000.00","2023-06-26","1","2023-06-26 06:49:23");
INSERT INTO tbl_recvoucher VALUES("766","0","REV260623103","","3000.00","2023-06-26","1","2023-06-26 07:44:13");
INSERT INTO tbl_recvoucher VALUES("767","0","REV260623104","","1210.00","2023-06-26","1","2023-06-26 09:17:54");
INSERT INTO tbl_recvoucher VALUES("768","0","REV260623105","","623.70","2023-06-26","1","2023-06-26 11:29:20");
INSERT INTO tbl_recvoucher VALUES("769","0","REV280623101","","6000.00","2023-06-28","1","2023-06-28 04:02:35");
INSERT INTO tbl_recvoucher VALUES("770","0","REV280623102","","650.00","2023-06-28","1","2023-06-28 04:52:22");
INSERT INTO tbl_recvoucher VALUES("771","0","REV280623103","","750.00","2023-06-28","1","2023-06-28 06:03:50");
INSERT INTO tbl_recvoucher VALUES("772","0","REV280623104","","2200.00","2023-06-26","1","2023-06-28 07:14:16");
INSERT INTO tbl_recvoucher VALUES("773","0","REV300623101","","2500.00","2023-06-30","1","2023-06-30 04:45:48");
INSERT INTO tbl_recvoucher VALUES("774","0","REV010723101","","4000.00","2023-07-01","1","2023-07-01 10:34:35");
INSERT INTO tbl_recvoucher VALUES("775","0","REV020723101","","2000.00","2023-07-02","1","2023-07-02 06:17:34");
INSERT INTO tbl_recvoucher VALUES("776","0","REV020723102","","260.00","2023-07-02","1","2023-07-02 06:23:11");
INSERT INTO tbl_recvoucher VALUES("777","0","REV020723103","","3080.00","2023-07-02","1","2023-07-02 08:48:40");
INSERT INTO tbl_recvoucher VALUES("778","0","REV020723104","","3860.00","2023-07-02","1","2023-07-02 08:59:39");
INSERT INTO tbl_recvoucher VALUES("779","0","REV030723101","","3730.00","2023-07-03","1","2023-07-03 01:42:54");
INSERT INTO tbl_recvoucher VALUES("780","0","REV030723102","","1000.00","2023-07-03","1","2023-07-03 01:56:38");
INSERT INTO tbl_recvoucher VALUES("781","0","REV030723103","","800.00","2023-07-03","1","2023-07-03 04:19:10");
INSERT INTO tbl_recvoucher VALUES("782","0","REV030723104","","8000.00","2023-07-03","1","2023-07-03 05:51:12");
INSERT INTO tbl_recvoucher VALUES("783","0","REV030723105","","8000.00","2023-07-03","1","2023-07-03 06:32:56");
INSERT INTO tbl_recvoucher VALUES("784","0","REV030723106","","1450.00","2023-07-03","1","2023-07-03 09:00:42");
INSERT INTO tbl_recvoucher VALUES("785","0","REV030723107","","1050.00","2023-07-03","1","2023-07-03 09:01:16");
INSERT INTO tbl_recvoucher VALUES("786","0","REV040723101","","3060.00","2023-07-04","1","2023-07-04 04:06:37");
INSERT INTO tbl_recvoucher VALUES("787","0","REV050723101","","3500.00","2023-07-05","1","2023-07-05 11:57:03");
INSERT INTO tbl_recvoucher VALUES("788","0","REV050723102","","500.00","2023-07-05","1","2023-07-05 04:07:26");
INSERT INTO tbl_recvoucher VALUES("789","0","REV050723103","","769.00","2023-07-05","1","2023-07-05 04:22:31");
INSERT INTO tbl_recvoucher VALUES("790","0","REV050723104","","700.00","2023-07-05","1","2023-07-05 05:03:50");
INSERT INTO tbl_recvoucher VALUES("791","0","REV060723101","","5920.00","2023-07-05","1","2023-07-06 02:44:14");
INSERT INTO tbl_recvoucher VALUES("792","0","REV060723102","","170.00","2023-07-06","1","2023-07-06 06:37:03");
INSERT INTO tbl_recvoucher VALUES("793","0","REV060723103","","2000.00","2023-07-06","1","2023-07-06 07:54:11");
INSERT INTO tbl_recvoucher VALUES("794","0","REV060723104","","9900.00","2023-07-06","1","2023-07-06 08:40:27");
INSERT INTO tbl_recvoucher VALUES("795","0","REV060723105","","4000.00","2023-07-06","1","2023-07-06 08:58:17");
INSERT INTO tbl_recvoucher VALUES("796","0","REV060723106","","167.00","2023-07-06","1","2023-07-06 10:18:30");
INSERT INTO tbl_recvoucher VALUES("797","0","REV070723101","","4080.00","2023-07-07","1","2023-07-07 11:10:45");
INSERT INTO tbl_recvoucher VALUES("798","0","REV070723102","","750.00","2023-07-07","1","2023-07-07 09:12:13");
INSERT INTO tbl_recvoucher VALUES("799","0","REV080723101","","5500.00","2023-07-08","1","2023-07-08 04:21:32");
INSERT INTO tbl_recvoucher VALUES("800","0","REV080723102","","890.00","2023-07-08","1","2023-07-08 07:14:57");
INSERT INTO tbl_recvoucher VALUES("801","0","REV080723103","","2170.00","2023-07-08","1","2023-07-08 07:18:15");
INSERT INTO tbl_recvoucher VALUES("802","0","REV080723104","","1400.00","2023-07-08","1","2023-07-08 08:52:06");
INSERT INTO tbl_recvoucher VALUES("803","0","REV090723101","","2000.00","2023-07-09","1","2023-07-09 05:09:01");
INSERT INTO tbl_recvoucher VALUES("804","0","REV090723102","","5000.00","2023-07-09","1","2023-07-09 06:03:02");
INSERT INTO tbl_recvoucher VALUES("805","0","REV090723103","","6320.00","2023-07-09","1","2023-07-09 09:00:02");
INSERT INTO tbl_recvoucher VALUES("806","0","REV090723104","","25000.04","2023-07-09","1","2023-07-09 09:42:38");
INSERT INTO tbl_recvoucher VALUES("807","0","REV090723105","","2600.00","2023-07-09","1","2023-07-09 09:47:58");
INSERT INTO tbl_recvoucher VALUES("808","0","REV090723106","","2500.00","2023-07-09","1","2023-07-09 10:55:42");
INSERT INTO tbl_recvoucher VALUES("809","0","REV090723107","","200.00","2023-07-09","1","2023-07-09 11:25:37");
INSERT INTO tbl_recvoucher VALUES("810","0","REV100723101","","6800.00","2023-07-09","1","2023-07-10 01:10:33");
INSERT INTO tbl_recvoucher VALUES("811","0","REV100723102","","20000.00","2023-07-10","1","2023-07-10 04:18:44");
INSERT INTO tbl_recvoucher VALUES("812","0","REV100723103","","2840.00","2023-07-08","1","2023-07-10 06:31:25");
INSERT INTO tbl_recvoucher VALUES("813","0","REV100723104","","4080.00","2023-07-10","1","2023-07-10 07:18:33");
INSERT INTO tbl_recvoucher VALUES("814","0","REV110723101","","4800.00","2023-07-10","1","2023-07-11 10:48:15");
INSERT INTO tbl_recvoucher VALUES("815","0","REV110723102","","10000.00","2023-07-09","1","2023-07-11 01:21:11");
INSERT INTO tbl_recvoucher VALUES("816","0","REV110723103","","8620.00","2023-07-11","1","2023-07-11 06:19:08");
INSERT INTO tbl_recvoucher VALUES("817","0","REV120723101","","500.00","2023-06-22","1","2023-07-12 10:38:58");
INSERT INTO tbl_recvoucher VALUES("818","0","REV120723102","","700.00","2023-04-03","1","2023-07-12 12:10:38");
INSERT INTO tbl_recvoucher VALUES("819","0","REV120723103","","642.00","2023-07-12","1","2023-07-12 12:11:32");
INSERT INTO tbl_recvoucher VALUES("820","0","REV120723104","","400.00","2023-07-12","1","2023-07-12 04:03:19");
INSERT INTO tbl_recvoucher VALUES("821","0","REV130723101","","2050.00","2023-07-12","1","2023-07-13 10:38:12");
INSERT INTO tbl_recvoucher VALUES("822","0","REV130723102","","1030.00","2023-07-13","1","2023-07-13 04:41:04");
INSERT INTO tbl_recvoucher VALUES("823","0","REV130723103","","5000.00","2023-07-13","1","2023-07-13 05:54:35");
INSERT INTO tbl_recvoucher VALUES("824","0","REV130723104","","1900.00","2023-07-13","1","2023-07-13 06:34:52");
INSERT INTO tbl_recvoucher VALUES("825","0","REV130723105","","500.00","2023-07-13","1","2023-07-13 09:41:33");
INSERT INTO tbl_recvoucher VALUES("826","0","REV140723101","","1000.00","2023-07-14","1","2023-07-14 11:34:27");
INSERT INTO tbl_recvoucher VALUES("827","0","REV140723102","","5000.00","2023-07-14","1","2023-07-14 04:28:39");
INSERT INTO tbl_recvoucher VALUES("828","0","REV140723103","","6100.00","2023-07-07","1","2023-07-14 04:56:28");
INSERT INTO tbl_recvoucher VALUES("829","0","REV140723104","","950.00","2023-07-14","1","2023-07-14 06:04:07");
INSERT INTO tbl_recvoucher VALUES("830","0","REV150723101","","2800.00","2023-07-15","1","2023-07-15 01:06:39");
INSERT INTO tbl_recvoucher VALUES("831","0","REV150723102","","3000.00","2023-07-15","1","2023-07-15 02:58:31");
INSERT INTO tbl_recvoucher VALUES("832","0","REV150723103","","1500.00","2023-07-15","1","2023-07-15 09:14:56");
INSERT INTO tbl_recvoucher VALUES("833","0","REV160723101","","5500.00","2023-07-16","1","2023-07-16 07:20:14");
INSERT INTO tbl_recvoucher VALUES("834","0","REV160723102","","3350.00","2023-07-16","1","2023-07-16 07:54:50");
INSERT INTO tbl_recvoucher VALUES("835","0","REV160723103","","6270.00","2023-07-16","1","2023-07-16 08:39:45");
INSERT INTO tbl_recvoucher VALUES("836","0","REV160723104","","2000.00","2023-07-16","1","2023-07-16 09:03:53");
INSERT INTO tbl_recvoucher VALUES("837","0","REV160723105","","4000.00","2023-06-20","1","2023-07-16 09:06:55");
INSERT INTO tbl_recvoucher VALUES("838","0","REV160723106","","1250.00","2023-06-14","1","2023-07-16 09:09:05");
INSERT INTO tbl_recvoucher VALUES("839","0","REV160723107","","400.00","2023-07-16","1","2023-07-16 09:11:33");
INSERT INTO tbl_recvoucher VALUES("840","0","REV160723108","","100.00","2023-07-16","1","2023-07-16 09:12:38");
INSERT INTO tbl_recvoucher VALUES("841","0","REV160723109","","1100.00","2023-07-16","1","2023-07-16 10:25:29");
INSERT INTO tbl_recvoucher VALUES("842","0","REV170723101","","2830.00","2023-07-17","1","2023-07-17 11:04:24");
INSERT INTO tbl_recvoucher VALUES("843","0","REV170723102","","2000.00","2023-07-17","1","2023-07-17 11:41:16");
INSERT INTO tbl_recvoucher VALUES("844","0","REV170723103","","4900.00","2023-07-17","1","2023-07-17 02:17:10");
INSERT INTO tbl_recvoucher VALUES("845","0","REV170723104","","5765.00","2023-07-17","1","2023-07-17 03:01:36");
INSERT INTO tbl_recvoucher VALUES("846","0","REV170723105","","6220.00","2023-07-17","1","2023-07-17 03:24:12");
INSERT INTO tbl_recvoucher VALUES("847","0","REV170723106","","1500.00","2023-07-17","1","2023-07-17 09:36:50");
INSERT INTO tbl_recvoucher VALUES("848","0","REV170723107","","11000.00","2023-07-17","1","2023-07-17 10:47:48");
INSERT INTO tbl_recvoucher VALUES("849","0","REV170723108","","10000.00","2023-07-17","1","2023-07-17 10:49:29");
INSERT INTO tbl_recvoucher VALUES("850","0","REV180723101","","3200.00","2023-07-18","1","2023-07-18 08:09:17");
INSERT INTO tbl_recvoucher VALUES("851","0","REV180723102","","3600.00","2023-07-18","1","2023-07-18 08:54:10");
INSERT INTO tbl_recvoucher VALUES("852","0","REV180723103","","9930.00","2023-07-18","1","2023-07-18 09:33:40");
INSERT INTO tbl_recvoucher VALUES("853","0","REV180723104","","2800.00","2023-07-18","1","2023-07-18 09:55:17");
INSERT INTO tbl_recvoucher VALUES("854","0","REV190723101","","250.00","2023-07-19","1","2023-07-19 05:09:47");
INSERT INTO tbl_recvoucher VALUES("855","0","REV190723102","","1500.00","2023-07-19","1","2023-07-19 07:54:28");
INSERT INTO tbl_recvoucher VALUES("856","0","REV190723103","","40000.00","2023-07-19","1","2023-07-19 08:47:03");
INSERT INTO tbl_recvoucher VALUES("857","0","REV200723101","","1980.00","2023-07-20","1","2023-07-20 12:29:49");
INSERT INTO tbl_recvoucher VALUES("858","0","REV200723102","","1000.00","2023-07-20","1","2023-07-20 01:04:42");
INSERT INTO tbl_recvoucher VALUES("859","0","REV200723103","","4000.00","2023-07-20","1","2023-07-20 06:01:06");
INSERT INTO tbl_recvoucher VALUES("860","0","REV200723104","","1100.00","2023-07-20","1","2023-07-20 07:12:12");
INSERT INTO tbl_recvoucher VALUES("861","0","REV200723105","","2100.00","2023-07-20","1","2023-07-20 09:35:35");
INSERT INTO tbl_recvoucher VALUES("862","0","REV200723106","","9000.00","2023-07-20","1","2023-07-20 09:55:53");
INSERT INTO tbl_recvoucher VALUES("863","0","REV210723101","","200.00","2023-07-21","1","2023-07-21 10:44:58");
INSERT INTO tbl_recvoucher VALUES("864","0","REV210723102","","3800.00","2023-07-21","1","2023-07-21 08:15:44");
INSERT INTO tbl_recvoucher VALUES("865","0","REV210723103","","2720.00","2023-07-21","1","2023-07-21 08:56:26");
INSERT INTO tbl_recvoucher VALUES("866","0","REV210723104","","6000.00","2023-07-21","1","2023-07-21 10:05:45");
INSERT INTO tbl_recvoucher VALUES("867","0","REV220723101","","26000.00","2023-07-22","1","2023-07-22 02:09:31");
INSERT INTO tbl_recvoucher VALUES("868","0","REV220723102","","910.00","2023-07-22","1","2023-07-22 06:47:28");
INSERT INTO tbl_recvoucher VALUES("869","0","REV220723103","","2600.00","2023-07-22","1","2023-07-22 07:58:57");
INSERT INTO tbl_recvoucher VALUES("870","0","REV220723104","","3140.00","2023-07-22","1","2023-07-22 08:26:03");
INSERT INTO tbl_recvoucher VALUES("871","0","REV220723105","","4000.00","2023-07-22","1","2023-07-22 09:12:04");
INSERT INTO tbl_recvoucher VALUES("872","0","REV220723106","","6800.00","2023-07-22","1","2023-07-22 09:13:00");
INSERT INTO tbl_recvoucher VALUES("873","0","REV230723101","","5150.00","2023-07-23","1","2023-07-23 08:10:50");
INSERT INTO tbl_recvoucher VALUES("874","0","REV240723101","","3556.00","2023-07-24","1","2023-07-24 11:39:25");
INSERT INTO tbl_recvoucher VALUES("875","0","REV240723102","","1430.00","2023-07-24","1","2023-07-24 04:05:08");
INSERT INTO tbl_recvoucher VALUES("876","0","REV240723103","","15000.00","2023-07-24","1","2023-07-24 08:34:06");
INSERT INTO tbl_recvoucher VALUES("877","0","REV250723101","","2200.00","2023-07-24","1","2023-07-25 06:58:00");
INSERT INTO tbl_recvoucher VALUES("878","0","REV250723102","","2200.00","2023-07-23","1","2023-07-25 07:15:38");
INSERT INTO tbl_recvoucher VALUES("879","0","REV250723103","","3800.00","2023-07-25","1","2023-07-25 08:47:38");
INSERT INTO tbl_recvoucher VALUES("880","0","REV260723101","","2830.00","2023-07-26","1","2023-07-26 06:49:53");
INSERT INTO tbl_recvoucher VALUES("881","0","REV260723102","","2010.00","2023-07-26","1","2023-07-26 07:54:22");
INSERT INTO tbl_recvoucher VALUES("882","0","REV260723103","","3500.00","2023-07-26","1","2023-07-26 11:00:01");
INSERT INTO tbl_recvoucher VALUES("883","0","REV260723104","","6000.00","2023-07-26","1","2023-07-26 11:19:28");
INSERT INTO tbl_recvoucher VALUES("884","0","REV270723101","","6000.00","2023-07-27","1","2023-07-27 09:26:11");
INSERT INTO tbl_recvoucher VALUES("885","0","REV270723102","","1300.00","2023-07-26","1","2023-07-27 09:39:25");
INSERT INTO tbl_recvoucher VALUES("886","0","REV270723103","","3800.00","2023-07-27","1","2023-07-27 10:23:26");
INSERT INTO tbl_recvoucher VALUES("887","0","REV270723104","","150.00","2023-07-27","1","2023-07-27 10:33:40");
INSERT INTO tbl_recvoucher VALUES("888","0","REV280723101","","300.00","2023-07-28","1","2023-07-28 04:10:05");
INSERT INTO tbl_recvoucher VALUES("889","0","REV280723102","","2500.00","2023-07-28","1","2023-07-28 07:22:19");
INSERT INTO tbl_recvoucher VALUES("890","0","REV280723103","","1350.00","2023-07-28","1","2023-07-28 09:03:04");
INSERT INTO tbl_recvoucher VALUES("891","0","REV290723101","","23300.00","2023-07-29","1","2023-07-29 12:03:52");
INSERT INTO tbl_recvoucher VALUES("892","0","REV290723102","","5800.00","2023-07-27","1","2023-07-29 01:17:24");
INSERT INTO tbl_recvoucher VALUES("893","0","REV300723101","","6000.00","2023-07-30","1","2023-07-30 12:30:08");
INSERT INTO tbl_recvoucher VALUES("894","0","REV300723102","","1610.00","2023-07-30","1","2023-07-30 12:43:21");
INSERT INTO tbl_recvoucher VALUES("895","0","REV300723103","","800.00","2023-07-30","1","2023-07-30 01:32:47");
INSERT INTO tbl_recvoucher VALUES("896","0","REV300723104","","1870.00","2023-07-30","1","2023-07-30 01:37:45");
INSERT INTO tbl_recvoucher VALUES("897","0","REV300723105","","5000.00","2023-07-30","1","2023-07-30 08:17:22");
INSERT INTO tbl_recvoucher VALUES("898","0","REV300723106","","10000.00","2023-07-30","1","2023-07-30 09:05:22");
INSERT INTO tbl_recvoucher VALUES("899","0","REV300723107","","1000.00","2023-07-30","1","2023-07-30 09:10:05");
INSERT INTO tbl_recvoucher VALUES("900","0","REV300723108","","2300.00","2023-07-30","1","2023-07-30 10:21:12");
INSERT INTO tbl_recvoucher VALUES("901","0","REV300723109","","7000.00","2023-07-30","1","2023-07-30 10:30:43");
INSERT INTO tbl_recvoucher VALUES("902","0","REV310723101","","450.00","2023-07-31","1","2023-07-31 10:38:27");
INSERT INTO tbl_recvoucher VALUES("903","0","REV310723102","","200.00","2023-07-30","1","2023-07-31 10:51:39");
INSERT INTO tbl_recvoucher VALUES("904","0","REV310723103","","2095.00","2023-07-31","1","2023-07-31 02:07:54");
INSERT INTO tbl_recvoucher VALUES("905","0","REV310723104","","1100.00","2023-07-31","1","2023-07-31 09:51:56");
INSERT INTO tbl_recvoucher VALUES("906","0","REV010823101","","2180.00","2023-08-01","1","2023-08-01 05:49:01");
INSERT INTO tbl_recvoucher VALUES("907","0","REV010823102","","1660.00","2023-08-01","1","2023-08-01 06:02:37");
INSERT INTO tbl_recvoucher VALUES("908","0","REV010823103","","1000.00","2023-08-01","1","2023-08-01 06:04:22");
INSERT INTO tbl_recvoucher VALUES("909","0","REV010823104","","5000.00","2023-08-01","1","2023-08-01 07:35:17");
INSERT INTO tbl_recvoucher VALUES("910","0","REV010823105","","2000.00","2023-08-01","1","2023-08-01 08:49:51");
INSERT INTO tbl_recvoucher VALUES("911","0","REV010823106","","5940.00","2023-08-01","1","2023-08-01 11:25:41");
INSERT INTO tbl_recvoucher VALUES("912","0","REV020823101","","910.00","2023-08-01","1","2023-08-02 09:55:04");
INSERT INTO tbl_recvoucher VALUES("913","0","REV020823102","","3540.00","2023-08-02","1","2023-08-02 06:51:42");
INSERT INTO tbl_recvoucher VALUES("914","0","REV030823101","","2800.00","2023-08-03","1","2023-08-03 02:41:31");
INSERT INTO tbl_recvoucher VALUES("915","0","REV030823102","","4000.00","2023-08-03","1","2023-08-03 09:09:44");
INSERT INTO tbl_recvoucher VALUES("916","0","REV030823103","","10000.00","2023-08-03","1","2023-08-03 10:44:09");
INSERT INTO tbl_recvoucher VALUES("917","0","REV040823101","","10000.00","2023-08-04","1","2023-08-04 02:28:05");
INSERT INTO tbl_recvoucher VALUES("918","0","REV040823102","","1000.00","2023-08-04","1","2023-08-04 07:36:16");
INSERT INTO tbl_recvoucher VALUES("919","0","REV040823103","","1870.00","2023-08-04","1","2023-08-04 09:53:56");
INSERT INTO tbl_recvoucher VALUES("920","0","REV050823101","","81.00","2023-08-05","1","2023-08-05 12:45:10");
INSERT INTO tbl_recvoucher VALUES("921","0","REV050823102","","1450.00","2023-08-05","1","2023-08-05 02:12:56");
INSERT INTO tbl_recvoucher VALUES("922","0","REV050823103","","3340.00","2023-08-02","1","2023-08-05 08:36:50");
INSERT INTO tbl_recvoucher VALUES("923","0","REV070823101","","2600.00","2023-08-07","1","2023-08-07 11:20:12");
INSERT INTO tbl_recvoucher VALUES("924","0","REV070823102","","2070.00","2023-08-07","1","2023-08-07 11:20:54");
INSERT INTO tbl_recvoucher VALUES("925","0","REV070823103","","1650.00","2023-08-07","1","2023-08-07 11:37:45");
INSERT INTO tbl_recvoucher VALUES("926","0","REV070823104","","1100.00","2023-08-07","1","2023-08-07 07:49:09");
INSERT INTO tbl_recvoucher VALUES("927","0","REV070823105","","1500.00","2023-08-07","1","2023-08-07 08:45:17");
INSERT INTO tbl_recvoucher VALUES("928","0","REV070823106","","8000.00","2023-08-07","1","2023-08-07 09:49:52");
INSERT INTO tbl_recvoucher VALUES("929","0","REV070823107","","1800.00","2023-08-07","1","2023-08-07 10:07:29");
INSERT INTO tbl_recvoucher VALUES("930","0","REV080823101","","3250.00","2023-08-08","1","2023-08-08 02:09:50");
INSERT INTO tbl_recvoucher VALUES("931","0","REV080823102","","1500.00","2023-08-08","1","2023-08-08 05:14:08");
INSERT INTO tbl_recvoucher VALUES("932","0","REV080823103","","3000.00","2023-08-08","1","2023-08-08 05:20:55");
INSERT INTO tbl_recvoucher VALUES("933","0","REV090823101","","3000.00","2023-08-09","1","2023-08-09 05:46:36");
INSERT INTO tbl_recvoucher VALUES("934","0","REV090823102","","1500.00","2023-08-09","1","2023-08-09 07:18:31");
INSERT INTO tbl_recvoucher VALUES("935","0","REV090823103","","2200.00","2023-08-09","1","2023-08-09 09:36:15");
INSERT INTO tbl_recvoucher VALUES("936","0","REV090823104","","2000.00","2023-08-01","1","2023-08-09 10:52:04");
INSERT INTO tbl_recvoucher VALUES("937","0","REV110823101","","4000.00","2023-08-11","1","2023-08-11 02:51:06");
INSERT INTO tbl_recvoucher VALUES("938","0","REV110823102","","2050.00","2023-08-11","1","2023-08-11 03:55:22");
INSERT INTO tbl_recvoucher VALUES("939","0","REV110823103","","3780.00","2023-08-09","1","2023-08-11 04:05:23");
INSERT INTO tbl_recvoucher VALUES("940","0","REV110823104","","2160.00","2023-08-11","1","2023-08-11 06:04:03");
INSERT INTO tbl_recvoucher VALUES("941","0","REV110823105","","1500.00","2023-07-29","1","2023-08-11 06:07:53");
INSERT INTO tbl_recvoucher VALUES("942","0","REV110823106","","3000.00","2023-08-11","1","2023-08-11 06:23:53");
INSERT INTO tbl_recvoucher VALUES("943","0","REV110823107","","3980.00","2023-08-11","1","2023-08-11 07:12:40");
INSERT INTO tbl_recvoucher VALUES("944","0","REV110823108","","180.00","2023-08-11","1","2023-08-11 08:54:14");
INSERT INTO tbl_recvoucher VALUES("945","0","REV120823101","","3000.00","2023-08-12","1","2023-08-12 01:35:24");
INSERT INTO tbl_recvoucher VALUES("946","0","REV120823102","","600.00","2023-08-12","1","2023-08-12 05:11:26");
INSERT INTO tbl_recvoucher VALUES("947","0","REV120823103","","8000.00","2023-08-12","1","2023-08-12 10:01:56");
INSERT INTO tbl_recvoucher VALUES("948","0","REV120823104","","1550.00","2023-08-12","1","2023-08-12 10:45:07");
INSERT INTO tbl_recvoucher VALUES("949","0","REV130823101","","1300.00","2023-08-13","1","2023-08-13 12:54:35");
INSERT INTO tbl_recvoucher VALUES("950","0","REV130823102","","6000.00","2023-08-13","1","2023-08-13 06:09:30");
INSERT INTO tbl_recvoucher VALUES("951","0","REV130823103","","845.00","2023-08-13","1","2023-08-13 06:43:52");
INSERT INTO tbl_recvoucher VALUES("952","0","REV140823101","","2660.00","2023-08-14","1","2023-08-14 02:43:03");
INSERT INTO tbl_recvoucher VALUES("953","0","REV140823102","","5000.00","2023-07-21","1","2023-08-14 04:14:04");
INSERT INTO tbl_recvoucher VALUES("954","0","REV140823103","","2690.00","2023-08-14","1","2023-08-14 04:14:34");
INSERT INTO tbl_recvoucher VALUES("955","0","REV140823104","","5000.00","2023-08-14","1","2023-08-14 07:48:47");
INSERT INTO tbl_recvoucher VALUES("956","0","REV140823105","","1500.00","2023-08-07","1","2023-08-14 07:58:41");
INSERT INTO tbl_recvoucher VALUES("957","0","REV150823101","","800.00","2023-08-15","1","2023-08-15 12:25:33");
INSERT INTO tbl_recvoucher VALUES("958","0","REV150823102","","1400.00","2023-08-15","1","2023-08-15 10:31:07");
INSERT INTO tbl_recvoucher VALUES("959","0","REV150823103","","113791.25","2023-01-10","1","2023-08-15 03:57:09");
INSERT INTO tbl_recvoucher VALUES("960","0","REV150823104","","8420.00","2023-08-15","1","2023-08-15 04:00:55");
INSERT INTO tbl_recvoucher VALUES("961","0","REV150823105","","190.00","2023-08-15","1","2023-08-15 05:40:37");
INSERT INTO tbl_recvoucher VALUES("962","0","REV150823106","","11005.60","2023-08-15","1","2023-08-15 08:02:34");
INSERT INTO tbl_recvoucher VALUES("963","0","REV150823107","","10630.00","2023-08-15","1","2023-08-15 09:07:49");
INSERT INTO tbl_recvoucher VALUES("964","0","REV160823101","","3800.00","2023-07-18","1","2023-08-16 12:49:11");
INSERT INTO tbl_recvoucher VALUES("965","0","REV160823102","","3000.00","2023-08-16","1","2023-08-16 08:17:29");
INSERT INTO tbl_recvoucher VALUES("966","0","REV170823101","","170.00","2023-08-17","1","2023-08-17 11:13:02");
INSERT INTO tbl_recvoucher VALUES("967","0","REV170823102","","2000.00","2023-08-17","1","2023-08-17 03:12:08");
INSERT INTO tbl_recvoucher VALUES("969","0","REV170823104","","2000.00","2023-08-17","1","2023-08-17 08:09:42");
INSERT INTO tbl_recvoucher VALUES("970","0","REV180823101","","900.40","2023-08-18","1","2023-08-18 10:57:38");
INSERT INTO tbl_recvoucher VALUES("971","0","REV180823102","","2100.00","2023-08-18","1","2023-08-18 05:29:30");
INSERT INTO tbl_recvoucher VALUES("972","0","REV180823103","","960.00","2023-08-18","1","2023-08-18 07:49:09");
INSERT INTO tbl_recvoucher VALUES("973","0","REV180823104","","6850.00","2023-08-18","1","2023-08-18 08:18:20");
INSERT INTO tbl_recvoucher VALUES("974","0","REV190823101","","1350.00","2023-08-19","1","2023-08-19 06:34:05");
INSERT INTO tbl_recvoucher VALUES("975","0","REV200823101","","400.00","2023-08-20","1","2023-08-20 03:24:34");
INSERT INTO tbl_recvoucher VALUES("976","0","REV200823102","","1940.00","2023-08-20","1","2023-08-20 06:17:21");
INSERT INTO tbl_recvoucher VALUES("977","0","REV200823103","","2150.00","2023-08-20","1","2023-08-20 06:26:29");
INSERT INTO tbl_recvoucher VALUES("978","0","REV200823104","","3000.00","2023-08-20","1","2023-08-20 08:25:55");
INSERT INTO tbl_recvoucher VALUES("979","0","REV210823101","","791.25","2023-08-21","1","2023-08-21 10:56:01");
INSERT INTO tbl_recvoucher VALUES("980","0","REV210823102","","1000.00","2023-08-21","1","2023-08-21 11:52:19");
INSERT INTO tbl_recvoucher VALUES("981","0","REV210823103","","5000.00","2023-08-21","1","2023-08-21 03:27:48");
INSERT INTO tbl_recvoucher VALUES("982","0","REV210823104","","1180.00","2023-08-21","1","2023-08-21 04:30:48");
INSERT INTO tbl_recvoucher VALUES("983","0","REV210823105","","2700.00","2023-08-21","1","2023-08-21 06:27:58");
INSERT INTO tbl_recvoucher VALUES("984","0","REV210823106","","5895.00","2023-08-21","1","2023-08-21 09:03:04");
INSERT INTO tbl_recvoucher VALUES("985","0","REV210823107","","335.00","2023-08-21","1","2023-08-21 09:28:58");
INSERT INTO tbl_recvoucher VALUES("986","0","REV230823101","","9430.00","2023-08-23","1","2023-08-23 06:21:29");
INSERT INTO tbl_recvoucher VALUES("987","0","REV230823102","","6950.00","2023-08-23","1","2023-08-23 06:31:41");
INSERT INTO tbl_recvoucher VALUES("988","0","REV230823103","","6000.00","2023-08-23","1","2023-08-23 08:48:59");
INSERT INTO tbl_recvoucher VALUES("989","0","REV240823101","","5000.00","2023-08-24","1","2023-08-24 12:10:31");
INSERT INTO tbl_recvoucher VALUES("990","0","REV240823102","","15000.00","2023-08-24","1","2023-08-24 04:14:35");
INSERT INTO tbl_recvoucher VALUES("991","0","REV240823103","","1740.00","2023-08-24","1","2023-08-24 06:26:18");
INSERT INTO tbl_recvoucher VALUES("992","0","REV240823104","","2300.00","2023-08-24","1","2023-08-24 08:17:33");
INSERT INTO tbl_recvoucher VALUES("993","0","REV250823101","","1450.00","2023-08-25","1","2023-08-25 03:37:17");
INSERT INTO tbl_recvoucher VALUES("994","0","REV250823102","","1350.00","2023-08-24","1","2023-08-25 06:16:35");
INSERT INTO tbl_recvoucher VALUES("995","0","REV250823103","","3900.00","2023-08-25","1","2023-08-25 08:06:15");
INSERT INTO tbl_recvoucher VALUES("996","0","REV250823104","","900.00","2023-08-25","1","2023-08-25 09:19:19");
INSERT INTO tbl_recvoucher VALUES("997","0","REV250823105","","2700.00","2023-08-25","1","2023-08-25 09:21:10");
INSERT INTO tbl_recvoucher VALUES("998","0","REV250823106","","2000.00","2023-08-25","1","2023-08-25 09:28:15");
INSERT INTO tbl_recvoucher VALUES("999","0","REV260823101","","6480.00","2023-08-26","1","2023-08-26 11:47:18");
INSERT INTO tbl_recvoucher VALUES("1000","0","REV260823102","","4000.00","2023-08-26","1","2023-08-26 04:22:57");
INSERT INTO tbl_recvoucher VALUES("1001","0","REV260823103","","6700.00","2023-08-26","1","2023-08-26 04:42:54");
INSERT INTO tbl_recvoucher VALUES("1002","0","REV260823104","","4400.00","2023-08-26","1","2023-08-26 06:57:38");
INSERT INTO tbl_recvoucher VALUES("1003","0","REV260823105","","685.00","2023-08-26","1","2023-08-26 06:58:45");
INSERT INTO tbl_recvoucher VALUES("1004","0","REV260823106","","5000.00","2023-08-26","1","2023-08-26 08:50:21");
INSERT INTO tbl_recvoucher VALUES("1005","0","REV270823101","","605.00","2023-08-27","1","2023-08-27 10:36:03");
INSERT INTO tbl_recvoucher VALUES("1006","0","REV270823102","","2900.00","2023-08-27","1","2023-08-27 03:31:26");
INSERT INTO tbl_recvoucher VALUES("1007","0","REV270823103","","2000.00","2023-08-27","1","2023-08-27 07:13:06");
INSERT INTO tbl_recvoucher VALUES("1008","0","REV270823104","","7500.00","2023-08-27","1","2023-08-27 08:50:56");
INSERT INTO tbl_recvoucher VALUES("1009","0","REV280823101","","2020.00","2023-08-28","1","2023-08-28 08:33:01");
INSERT INTO tbl_recvoucher VALUES("1010","0","REV280823102","","1000.00","2023-08-28","1","2023-08-28 08:44:26");
INSERT INTO tbl_recvoucher VALUES("1011","0","REV290823101","","3545.00","2023-08-29","1","2023-08-29 12:22:13");
INSERT INTO tbl_recvoucher VALUES("1012","0","REV290823102","","1817.50","2023-08-29","1","2023-08-29 03:38:03");
INSERT INTO tbl_recvoucher VALUES("1013","0","REV290823103","","1520.00","2023-08-29","1","2023-08-29 07:06:31");
INSERT INTO tbl_recvoucher VALUES("1014","0","REV290823104","","4825.00","2023-08-29","1","2023-08-29 09:00:54");
INSERT INTO tbl_recvoucher VALUES("1015","0","REV290823105","","2400.00","2023-08-29","1","2023-08-29 09:04:26");
INSERT INTO tbl_recvoucher VALUES("1016","0","REV300823101","","5550.00","2023-08-30","1","2023-08-30 12:55:45");
INSERT INTO tbl_recvoucher VALUES("1017","0","REV300823102","","490.00","2023-08-30","1","2023-08-30 08:03:32");
INSERT INTO tbl_recvoucher VALUES("1018","0","REV300823103","","3000.00","2023-08-30","1","2023-08-30 09:08:11");
INSERT INTO tbl_recvoucher VALUES("1019","0","REV310823101","","4000.00","2023-08-31","1","2023-08-31 03:17:36");
INSERT INTO tbl_recvoucher VALUES("1020","0","REV310823102","","750.00","2023-08-31","1","2023-08-31 04:25:43");
INSERT INTO tbl_recvoucher VALUES("1021","0","REV310823103","","700.00","2023-08-31","1","2023-08-31 05:40:27");
INSERT INTO tbl_recvoucher VALUES("1022","0","REV310823104","","3560.00","2023-08-31","1","2023-08-31 06:50:47");
INSERT INTO tbl_recvoucher VALUES("1024","0","REV310823106","","5910.00","2023-08-31","1","2023-08-31 07:27:11");
INSERT INTO tbl_recvoucher VALUES("1025","0","REV310823107","","710.00","2023-08-29","1","2023-08-31 07:28:36");
INSERT INTO tbl_recvoucher VALUES("1026","0","REV310823108","","2375.00","2023-08-31","1","2023-08-31 08:11:38");
INSERT INTO tbl_recvoucher VALUES("1027","0","REV310823109","","3690.00","2023-08-31","1","2023-08-31 09:46:39");
INSERT INTO tbl_recvoucher VALUES("1028","0","REV310823110","","3000.00","2023-08-31","1","2023-08-31 11:28:52");
INSERT INTO tbl_recvoucher VALUES("1029","0","REV010923101","","1455.00","2023-09-01","1","2023-09-01 05:44:10");
INSERT INTO tbl_recvoucher VALUES("1030","0","REV010923102","","400.00","2023-09-01","1","2023-09-01 07:40:33");
INSERT INTO tbl_recvoucher VALUES("1031","0","REV010923103","","2520.00","2023-09-01","1","2023-09-01 07:59:33");
INSERT INTO tbl_recvoucher VALUES("1032","0","REV010923104","","22500.00","2023-09-01","1","2023-09-01 09:29:56");
INSERT INTO tbl_recvoucher VALUES("1033","0","REV010923105","","2100.00","2023-09-01","1","2023-09-01 10:36:33");
INSERT INTO tbl_recvoucher VALUES("1036","0","REV020923103","","1960.00","2023-09-02","1","2023-09-02 01:26:54");
INSERT INTO tbl_recvoucher VALUES("1037","0","REV020923104","","5910.00","2023-09-02","1","2023-09-02 01:31:12");
INSERT INTO tbl_recvoucher VALUES("1038","0","REV020923105","","4200.00","2023-09-02","1","2023-09-02 04:05:32");
INSERT INTO tbl_recvoucher VALUES("1039","0","REV020923106","","5290.00","2023-09-02","1","2023-09-02 04:40:49");
INSERT INTO tbl_recvoucher VALUES("1040","0","REV020923107","","8000.00","2023-09-02","1","2023-09-02 07:16:22");
INSERT INTO tbl_recvoucher VALUES("1041","0","REV020923108","","5500.00","2023-09-02","1","2023-09-02 09:24:29");
INSERT INTO tbl_recvoucher VALUES("1042","0","REV030923101","","5050.00","2023-08-17","1","2023-09-03 12:13:30");
INSERT INTO tbl_recvoucher VALUES("1044","0","REV030923102","","700.00","2023-09-03","1","2023-09-03 08:58:19");
INSERT INTO tbl_recvoucher VALUES("1045","0","REV040923101","","1978.60","2023-09-04","1","2023-09-04 10:36:52");
INSERT INTO tbl_recvoucher VALUES("1046","0","REV040923102","","1000.00","2023-09-04","1","2023-09-04 03:03:32");
INSERT INTO tbl_recvoucher VALUES("1047","0","REV040923103","","5000.00","2023-09-04","1","2023-09-04 08:59:22");
INSERT INTO tbl_recvoucher VALUES("1048","0","REV050923101","","7000.00","2023-09-05","1","2023-09-05 12:43:01");
INSERT INTO tbl_recvoucher VALUES("1049","0","REV050923102","","9000.00","2023-09-05","1","2023-09-05 12:58:43");
INSERT INTO tbl_recvoucher VALUES("1050","0","REV050923103","","1000.00","2023-09-05","1","2023-09-05 08:40:36");
INSERT INTO tbl_recvoucher VALUES("1051","0","REV050923104","","2800.00","2023-09-05","1","2023-09-05 10:48:16");
INSERT INTO tbl_recvoucher VALUES("1052","0","REV060923101","","320.00","2023-09-06","1","2023-09-06 08:35:47");
INSERT INTO tbl_recvoucher VALUES("1053","0","REV070923101","","8541.00","2023-09-07","1","2023-09-07 02:26:29");
INSERT INTO tbl_recvoucher VALUES("1054","0","REV070923102","","675.00","2023-09-07","1","2023-09-07 02:28:31");
INSERT INTO tbl_recvoucher VALUES("1055","0","REV070923103","","90.00","2023-09-06","1","2023-09-07 02:34:21");
INSERT INTO tbl_recvoucher VALUES("1056","0","REV070923104","","9050.00","2023-09-07","1","2023-09-07 02:46:51");
INSERT INTO tbl_recvoucher VALUES("1057","0","REV070923105","","2500.00","2023-09-07","1","2023-09-07 05:29:19");
INSERT INTO tbl_recvoucher VALUES("1058","0","REV070923106","","3199.20","2023-09-07","1","2023-09-07 09:57:23");
INSERT INTO tbl_recvoucher VALUES("1059","0","REV070923107","","2500.00","2023-09-07","1","2023-09-07 10:12:45");
INSERT INTO tbl_recvoucher VALUES("1060","0","REV070923108","","1395.00","2023-09-07","1","2023-09-07 10:53:39");
INSERT INTO tbl_recvoucher VALUES("1061","0","REV080923101","","8000.00","2023-09-08","1","2023-09-08 10:53:39");
INSERT INTO tbl_recvoucher VALUES("1062","0","REV080923102","","2200.00","2023-09-08","1","2023-09-08 04:22:40");
INSERT INTO tbl_recvoucher VALUES("1063","0","REV090923101","","3070.00","2023-09-09","1","2023-09-09 01:08:58");
INSERT INTO tbl_recvoucher VALUES("1064","0","REV090923102","","3750.00","2023-09-09","1","2023-09-09 02:01:45");
INSERT INTO tbl_recvoucher VALUES("1065","0","REV090923103","","990.00","2023-09-09","1","2023-09-09 08:10:37");
INSERT INTO tbl_recvoucher VALUES("1066","0","REV100923101","","500.00","2023-09-10","1","2023-09-10 01:44:01");
INSERT INTO tbl_recvoucher VALUES("1067","0","REV100923102","","3500.00","2023-09-10","1","2023-09-10 05:01:59");
INSERT INTO tbl_recvoucher VALUES("1068","0","REV100923103","","1100.00","2023-09-10","1","2023-09-10 05:02:29");
INSERT INTO tbl_recvoucher VALUES("1069","0","REV100923104","","10000.00","2023-09-10","1","2023-09-10 08:57:09");
INSERT INTO tbl_recvoucher VALUES("1070","0","REV110923101","","1950.00","2023-09-11","1","2023-09-11 01:11:46");
INSERT INTO tbl_recvoucher VALUES("1071","0","REV110923102","","15000.00","2023-09-11","1","2023-09-11 08:33:13");
INSERT INTO tbl_recvoucher VALUES("1073","0","REV120923101","","500.00","2023-09-10","1","2023-09-12 10:58:17");
INSERT INTO tbl_recvoucher VALUES("1074","0","REV120923102","","3900.00","2023-09-11","1","2023-09-12 11:13:36");
INSERT INTO tbl_recvoucher VALUES("1075","0","REV120923103","","720.00","2023-09-12","1","2023-09-12 12:15:47");
INSERT INTO tbl_recvoucher VALUES("1076","0","REV120923104","","2000.00","2023-09-12","1","2023-09-12 07:23:57");
INSERT INTO tbl_recvoucher VALUES("1077","0","REV120923105","","1350.00","2023-08-13","1","2023-09-12 09:39:14");
INSERT INTO tbl_recvoucher VALUES("1078","0","REV120923106","","360.00","2023-06-15","1","2023-09-12 09:40:44");
INSERT INTO tbl_recvoucher VALUES("1079","0","REV120923107","","980.00","2023-06-14","1","2023-09-12 09:41:19");
INSERT INTO tbl_recvoucher VALUES("1080","0","REV120923108","","2150.00","2023-09-12","1","2023-09-12 09:47:20");
INSERT INTO tbl_recvoucher VALUES("1081","0","REV120923109","","9150.00","2023-09-12","1","2023-09-12 10:25:53");
INSERT INTO tbl_recvoucher VALUES("1082","0","REV120923110","","8090.00","2023-09-12","1","2023-09-12 11:09:35");
INSERT INTO tbl_recvoucher VALUES("1083","0","REV130923101","","6200.00","2023-09-13","1","2023-09-13 01:31:09");
INSERT INTO tbl_recvoucher VALUES("1084","0","REV130923102","","1000.00","2023-09-13","1","2023-09-13 02:25:25");
INSERT INTO tbl_recvoucher VALUES("1085","0","REV130923103","","2200.00","2023-09-13","1","2023-09-13 07:46:35");
INSERT INTO tbl_recvoucher VALUES("1086","0","REV130923104","","260.00","2023-09-13","1","2023-09-13 11:17:37");
INSERT INTO tbl_recvoucher VALUES("1087","0","REV140923101","","570.00","2023-08-02","1","2023-09-14 10:53:27");
INSERT INTO tbl_recvoucher VALUES("1088","0","REV140923102","","1020.00","2023-09-14","1","2023-09-14 01:59:08");
INSERT INTO tbl_recvoucher VALUES("1089","0","REV140923103","","3110.00","2023-09-14","1","2023-09-14 06:23:50");
INSERT INTO tbl_recvoucher VALUES("1090","0","REV140923104","","9801.25","2023-09-14","1","2023-09-14 07:00:19");
INSERT INTO tbl_recvoucher VALUES("1091","0","REV140923105","","4000.00","2023-09-14","1","2023-09-14 07:15:28");
INSERT INTO tbl_recvoucher VALUES("1092","0","REV140923106","","10000.00","2023-09-14","1","2023-09-14 09:14:37");
INSERT INTO tbl_recvoucher VALUES("1093","0","REV150923101","","100.00","2023-09-15","1","2023-09-15 03:27:07");
INSERT INTO tbl_recvoucher VALUES("1094","0","REV150923102","","700.00","2023-09-15","1","2023-09-15 05:56:43");
INSERT INTO tbl_recvoucher VALUES("1095","0","REV160923101","","8000.00","2023-09-16","1","2023-09-16 07:02:40");
INSERT INTO tbl_recvoucher VALUES("1096","0","REV160923102","","8000.00","2023-09-16","1","2023-09-16 08:16:02");
INSERT INTO tbl_recvoucher VALUES("1097","0","REV170923101","","900.00","2023-03-29","1","2023-09-17 11:58:22");
INSERT INTO tbl_recvoucher VALUES("1098","0","REV170923102","","300.00","2023-09-17","1","2023-09-17 08:51:19");
INSERT INTO tbl_recvoucher VALUES("1099","0","REV180923101","","1230.00","2023-09-18","1","2023-09-18 12:10:09");
INSERT INTO tbl_recvoucher VALUES("1100","0","REV180923102","","500.00","2023-09-18","1","2023-09-18 12:22:34");
INSERT INTO tbl_recvoucher VALUES("1101","0","REV180923103","","5980.00","2023-09-18","1","2023-09-18 01:27:58");
INSERT INTO tbl_recvoucher VALUES("1102","0","REV180923104","","3000.00","2023-09-18","1","2023-09-18 05:41:24");
INSERT INTO tbl_recvoucher VALUES("1103","0","REV180923105","","5000.00","2023-09-18","1","2023-09-18 09:03:11");
INSERT INTO tbl_recvoucher VALUES("1104","0","REV180923106","","3590.00","2023-09-18","1","2023-09-18 09:04:08");
INSERT INTO tbl_recvoucher VALUES("1105","0","REV180923107","","3240.00","2023-09-18","1","2023-09-18 10:34:06");
INSERT INTO tbl_recvoucher VALUES("1106","0","REV190923101","","1000.00","2023-09-19","1","2023-09-19 11:20:20");
INSERT INTO tbl_recvoucher VALUES("1107","0","REV190923102","","5000.00","2023-09-19","1","2023-09-19 03:36:31");
INSERT INTO tbl_recvoucher VALUES("1108","0","REV190923103","","11800.00","2023-09-19","1","2023-09-19 09:43:53");
INSERT INTO tbl_recvoucher VALUES("1109","0","REV200923101","","4200.00","2023-09-20","1","2023-09-20 12:17:34");
INSERT INTO tbl_recvoucher VALUES("1110","0","REV200923102","","2020.00","2023-09-20","1","2023-09-20 05:16:04");
INSERT INTO tbl_recvoucher VALUES("1111","0","REV210923101","","1550.00","2023-09-19","1","2023-09-21 01:08:52");
INSERT INTO tbl_recvoucher VALUES("1112","0","REV220923101","","3440.00","2023-09-22","1","2023-09-22 11:58:47");
INSERT INTO tbl_recvoucher VALUES("1113","0","REV220923102","","3500.00","2023-09-22","1","2023-09-22 06:37:06");
INSERT INTO tbl_recvoucher VALUES("1114","0","REV220923103","","4010.00","2023-09-22","1","2023-09-22 08:03:45");
INSERT INTO tbl_recvoucher VALUES("1115","0","REV220923104","","6770.00","2023-09-22","1","2023-09-22 08:38:55");
INSERT INTO tbl_recvoucher VALUES("1116","0","REV220923105","","5900.00","2023-09-22","1","2023-09-22 11:11:28");
INSERT INTO tbl_recvoucher VALUES("1117","0","REV230923101","","810.00","2023-09-23","1","2023-09-23 06:36:02");
INSERT INTO tbl_recvoucher VALUES("1118","0","REV230923102","","22540.00","2023-09-23","1","2023-09-23 10:59:54");
INSERT INTO tbl_recvoucher VALUES("1119","0","REV240923101","","3390.00","2023-09-24","1","2023-09-24 09:05:22");
INSERT INTO tbl_recvoucher VALUES("1120","0","REV240923102","","4100.00","2023-09-22","1","2023-09-24 10:05:12");
INSERT INTO tbl_recvoucher VALUES("1121","0","REV240923103","","4190.00","2023-09-24","1","2023-09-24 10:06:02");
INSERT INTO tbl_recvoucher VALUES("1122","0","REV240923104","","3050.00","2023-09-24","1","2023-09-24 10:42:10");
INSERT INTO tbl_recvoucher VALUES("1123","0","REV250923101","","2840.00","2023-09-25","1","2023-09-25 07:17:31");
INSERT INTO tbl_recvoucher VALUES("1124","0","REV250923102","","170.00","2023-09-25","1","2023-09-25 08:51:22");
INSERT INTO tbl_recvoucher VALUES("1125","0","REV260923101","","273.00","2023-09-26","1","2023-09-26 03:52:21");
INSERT INTO tbl_recvoucher VALUES("1126","0","REV260923102","","6500.00","2023-09-26","1","2023-09-26 04:37:49");
INSERT INTO tbl_recvoucher VALUES("1127","0","REV260923103","","2600.00","2023-09-26","1","2023-09-26 06:26:12");
INSERT INTO tbl_recvoucher VALUES("1128","0","REV260923104","","1250.00","2023-09-26","1","2023-09-26 10:28:46");
INSERT INTO tbl_recvoucher VALUES("1129","0","REV270923101","","400.00","2023-09-27","1","2023-09-27 03:56:13");
INSERT INTO tbl_recvoucher VALUES("1130","0","REV270923102","","2000.00","2023-09-27","1","2023-09-27 03:57:15");
INSERT INTO tbl_recvoucher VALUES("1132","0","REV270923103","","1000.00","2023-09-27","1","2023-09-27 05:56:32");
INSERT INTO tbl_recvoucher VALUES("1133","0","REV270923104","","1320.00","2023-09-27","1","2023-09-27 07:35:50");
INSERT INTO tbl_recvoucher VALUES("1134","0","REV270923105","","4000.00","2023-09-27","1","2023-09-27 10:14:54");
INSERT INTO tbl_recvoucher VALUES("1135","0","REV280923101","","8000.00","2023-09-28","1","2023-09-28 07:19:19");
INSERT INTO tbl_recvoucher VALUES("1136","0","REV280923102","","4615.00","2023-09-28","1","2023-09-28 07:20:22");
INSERT INTO tbl_recvoucher VALUES("1137","0","REV280923103","","10000.00","2023-09-28","1","2023-09-28 07:56:26");
INSERT INTO tbl_recvoucher VALUES("1138","0","REV280923104","","3225.00","2023-09-28","1","2023-09-28 09:26:03");
INSERT INTO tbl_recvoucher VALUES("1139","0","REV280923105","","1872.54","2023-09-28","1","2023-09-28 09:35:00");
INSERT INTO tbl_recvoucher VALUES("1140","0","REV290923101","","50.00","2023-09-29","1","2023-09-29 03:15:31");
INSERT INTO tbl_recvoucher VALUES("1141","0","REV290923102","","5000.00","2023-09-29","1","2023-09-29 08:48:14");
INSERT INTO tbl_recvoucher VALUES("1142","0","REV290923103","","2000.00","2023-09-29","1","2023-09-29 10:13:47");
INSERT INTO tbl_recvoucher VALUES("1143","0","REV290923104","","6051.25","2023-09-29","1","2023-09-29 10:14:31");
INSERT INTO tbl_recvoucher VALUES("1144","0","REV290923105","","8110.00","2023-09-29","1","2023-09-29 10:15:57");
INSERT INTO tbl_recvoucher VALUES("1145","0","REV300923101","","5660.00","2023-09-30","1","2023-09-30 07:37:32");
INSERT INTO tbl_recvoucher VALUES("1146","0","REV300923102","","1500.00","2023-09-30","1","2023-09-30 08:22:49");
INSERT INTO tbl_recvoucher VALUES("1147","0","REV011023101","","1290.00","2023-10-01","1","2023-10-01 12:46:39");
INSERT INTO tbl_recvoucher VALUES("1148","0","REV011023102","","21003.00","2023-10-01","1","2023-10-01 04:50:37");
INSERT INTO tbl_recvoucher VALUES("1149","0","REV011023103","","1650.00","2023-10-01","1","2023-10-01 06:29:23");
INSERT INTO tbl_recvoucher VALUES("1150","0","REV011023104","","1850.00","2023-10-01","1","2023-10-01 07:45:45");
INSERT INTO tbl_recvoucher VALUES("1151","0","REV011023105","","5000.00","2023-10-01","1","2023-10-01 08:03:39");
INSERT INTO tbl_recvoucher VALUES("1152","0","REV011023106","","1790.00","2023-10-01","1","2023-10-01 09:07:59");
INSERT INTO tbl_recvoucher VALUES("1153","0","REV011023107","","2500.00","2023-08-28","1","2023-10-01 11:12:11");
INSERT INTO tbl_recvoucher VALUES("1154","0","REV021023101","","1000.00","2023-10-02","1","2023-10-02 11:22:03");
INSERT INTO tbl_recvoucher VALUES("1155","0","REV021023102","","100.00","2023-10-02","1","2023-10-02 11:30:24");
INSERT INTO tbl_recvoucher VALUES("1156","0","REV021023103","","6600.00","2023-10-02","1","2023-10-02 12:15:14");
INSERT INTO tbl_recvoucher VALUES("1157","0","REV021023104","","8000.00","2023-10-02","1","2023-10-02 06:39:34");
INSERT INTO tbl_recvoucher VALUES("1158","0","REV021023105","","1400.00","2023-10-02","1","2023-10-02 07:36:26");
INSERT INTO tbl_recvoucher VALUES("1159","0","REV031023101","","520.00","2023-10-03","1","2023-10-03 07:11:22");
INSERT INTO tbl_recvoucher VALUES("1160","0","REV031023102","","4200.00","2023-10-03","1","2023-10-03 10:15:48");
INSERT INTO tbl_recvoucher VALUES("1161","0","REV031023103","","31770.00","2023-10-03","1","2023-10-03 10:18:23");
INSERT INTO tbl_recvoucher VALUES("1162","0","REV041023101","","8320.00","2023-10-04","1","2023-10-04 12:03:52");
INSERT INTO tbl_recvoucher VALUES("1163","0","REV041023102","","2680.00","2023-10-04","1","2023-10-04 05:24:29");
INSERT INTO tbl_recvoucher VALUES("1164","0","REV041023103","","3000.00","2023-10-04","1","2023-10-04 06:33:17");
INSERT INTO tbl_recvoucher VALUES("1165","0","REV041023104","","10200.00","2023-10-04","1","2023-10-04 09:12:11");
INSERT INTO tbl_recvoucher VALUES("1166","0","REV051023101","","2850.00","2023-10-05","1","2023-10-05 05:17:43");
INSERT INTO tbl_recvoucher VALUES("1167","0","REV051023102","","307.00","2023-10-05","1","2023-10-05 05:35:00");
INSERT INTO tbl_recvoucher VALUES("1168","0","REV061023101","","2980.00","2023-10-06","1","2023-10-06 04:11:15");
INSERT INTO tbl_recvoucher VALUES("1169","0","REV061023102","","590.00","2023-10-06","1","2023-10-06 05:51:14");
INSERT INTO tbl_recvoucher VALUES("1170","0","REV061023103","","5000.00","2023-10-06","1","2023-10-06 08:47:59");
INSERT INTO tbl_recvoucher VALUES("1171","0","REV071023101","","1100.00","2023-10-07","1","2023-10-07 08:37:17");
INSERT INTO tbl_recvoucher VALUES("1172","0","REV081023101","","200.00","2023-10-08","1","2023-10-08 03:15:25");
INSERT INTO tbl_recvoucher VALUES("1173","0","REV081023102","","1550.00","2023-10-08","1","2023-10-08 08:11:26");
INSERT INTO tbl_recvoucher VALUES("1174","0","REV081023103","","3350.00","2023-10-08","1","2023-10-08 09:36:55");
INSERT INTO tbl_recvoucher VALUES("1175","0","REV091023101","","4000.00","2023-10-09","1","2023-10-09 03:51:59");
INSERT INTO tbl_recvoucher VALUES("1176","0","REV091023102","","700.00","2023-10-09","1","2023-10-09 04:54:33");
INSERT INTO tbl_recvoucher VALUES("1177","0","REV091023103","","270.00","2023-10-09","1","2023-10-09 07:45:12");
INSERT INTO tbl_recvoucher VALUES("1178","0","REV091023104","","2650.00","2023-10-09","1","2023-10-09 08:10:40");
INSERT INTO tbl_recvoucher VALUES("1179","0","REV091023105","","10000.00","2023-10-09","1","2023-10-09 08:12:09");
INSERT INTO tbl_recvoucher VALUES("1180","0","REV091023106","","1500.00","2023-10-09","1","2023-10-09 09:36:14");
INSERT INTO tbl_recvoucher VALUES("1181","0","REV091023107","","3265.00","2023-10-09","1","2023-10-09 09:38:15");
INSERT INTO tbl_recvoucher VALUES("1182","0","REV101023101","","600.00","2023-10-10","1","2023-10-10 03:57:07");
INSERT INTO tbl_recvoucher VALUES("1183","0","REV101023102","","2240.00","2023-10-10","1","2023-10-10 08:34:10");
INSERT INTO tbl_recvoucher VALUES("1184","0","REV111023101","","240.00","2023-10-11","1","2023-10-11 11:49:07");
INSERT INTO tbl_recvoucher VALUES("1185","0","REV111023102","","3180.00","2023-10-11","1","2023-10-11 04:43:46");
INSERT INTO tbl_recvoucher VALUES("1186","0","REV111023103","","1600.00","2023-10-11","1","2023-10-11 05:45:45");
INSERT INTO tbl_recvoucher VALUES("1187","0","REV111023104","","6180.00","2023-10-11","1","2023-10-11 07:11:54");
INSERT INTO tbl_recvoucher VALUES("1188","0","REV111023105","","1185.00","2023-10-11","1","2023-10-11 07:46:28");
INSERT INTO tbl_recvoucher VALUES("1189","0","REV111023106","","4500.00","2023-10-10","1","2023-10-11 08:55:24");
INSERT INTO tbl_recvoucher VALUES("1190","0","REV121023101","","5000.00","2023-10-12","1","2023-10-12 11:00:40");
INSERT INTO tbl_recvoucher VALUES("1191","0","REV121023102","","390.00","2023-10-12","1","2023-10-12 11:46:19");
INSERT INTO tbl_recvoucher VALUES("1192","0","REV121023103","","4075.00","2023-10-12","1","2023-10-12 12:04:09");
INSERT INTO tbl_recvoucher VALUES("1193","0","REV121023104","","15000.00","2023-10-12","1","2023-10-12 12:15:36");
INSERT INTO tbl_recvoucher VALUES("1194","0","REV131023101","","4200.00","2023-10-13","1","2023-10-13 08:39:42");
INSERT INTO tbl_recvoucher VALUES("1195","0","REV131023102","","3000.00","2023-10-13","1","2023-10-13 09:48:35");
INSERT INTO tbl_recvoucher VALUES("1196","0","REV141023101","","1000.00","2023-10-14","1","2023-10-14 06:55:05");
INSERT INTO tbl_recvoucher VALUES("1197","0","REV141023102","","4030.00","2023-10-14","1","2023-10-14 06:56:06");
INSERT INTO tbl_recvoucher VALUES("1198","0","REV141023103","","1100.00","2023-10-14","1","2023-10-14 07:14:07");
INSERT INTO tbl_recvoucher VALUES("1199","0","REV151023101","","1900.00","2023-10-14","1","2023-10-15 07:43:40");
INSERT INTO tbl_recvoucher VALUES("1200","0","REV151023102","","2000.00","2023-10-15","1","2023-10-15 08:10:44");
INSERT INTO tbl_recvoucher VALUES("1201","0","REV151023103","","792.00","2023-10-15","1","2023-10-15 11:04:22");
INSERT INTO tbl_recvoucher VALUES("1202","0","REV151023104","","3220.00","2023-10-15","1","2023-10-15 11:38:14");
INSERT INTO tbl_recvoucher VALUES("1203","0","REV161023101","","1550.00","2023-10-16","1","2023-10-16 08:34:31");
INSERT INTO tbl_recvoucher VALUES("1204","0","REV161023102","","5000.00","2023-10-11","1","2023-10-16 08:35:36");
INSERT INTO tbl_recvoucher VALUES("1205","0","REV161023103","","4250.00","2023-10-16","1","2023-10-16 09:28:02");
INSERT INTO tbl_recvoucher VALUES("1206","0","REV161023104","","600.00","2023-10-16","1","2023-10-16 09:45:57");
INSERT INTO tbl_recvoucher VALUES("1207","0","REV171023101","","955.00","2023-10-16","1","2023-10-17 02:46:59");
INSERT INTO tbl_recvoucher VALUES("1208","0","REV171023102","","4900.00","2023-10-17","1","2023-10-17 10:00:15");
INSERT INTO tbl_recvoucher VALUES("1209","0","REV181023101","","6100.00","2023-10-18","1","2023-10-18 12:42:00");
INSERT INTO tbl_recvoucher VALUES("1210","0","REV181023102","","30000.00","2023-10-17","1","2023-10-18 01:43:14");
INSERT INTO tbl_recvoucher VALUES("1211","0","REV181023103","","10800.00","2023-10-18","1","2023-10-18 07:09:42");
INSERT INTO tbl_recvoucher VALUES("1212","0","REV181023104","","4480.00","2023-10-18","1","2023-10-18 07:55:42");
INSERT INTO tbl_recvoucher VALUES("1213","0","REV191023101","","1800.00","2023-10-19","1","2023-10-19 11:04:53");
INSERT INTO tbl_recvoucher VALUES("1214","0","REV191023102","","850.00","2023-10-18","1","2023-10-19 01:08:07");
INSERT INTO tbl_recvoucher VALUES("1215","0","REV191023103","","1070.00","2023-10-19","1","2023-10-19 01:34:43");
INSERT INTO tbl_recvoucher VALUES("1216","0","REV191023104","","1800.00","2023-10-19","1","2023-10-19 05:17:16");
INSERT INTO tbl_recvoucher VALUES("1217","0","REV191023105","","16950.00","2023-10-01","1","2023-10-19 05:44:51");
INSERT INTO tbl_recvoucher VALUES("1218","0","REV191023106","","1800.00","2023-10-19","1","2023-10-19 08:50:05");
INSERT INTO tbl_recvoucher VALUES("1219","0","REV201023101","","800.00","2023-10-18","1","2023-10-20 10:58:05");
INSERT INTO tbl_recvoucher VALUES("1220","0","REV201023102","","595.00","2023-10-19","1","2023-10-20 10:58:45");
INSERT INTO tbl_recvoucher VALUES("1221","0","REV201023103","","2434.00","2023-10-20","1","2023-10-20 08:35:40");
INSERT INTO tbl_recvoucher VALUES("1222","0","REV201023104","","3400.00","2023-10-20","1","2023-10-20 08:36:28");
INSERT INTO tbl_recvoucher VALUES("1223","0","REV211023101","","2900.00","2023-10-21","1","2023-10-21 07:00:30");
INSERT INTO tbl_recvoucher VALUES("1224","0","REV221023101","","2100.00","2023-10-22","1","2023-10-22 10:39:10");
INSERT INTO tbl_recvoucher VALUES("1225","0","REV221023102","","3000.00","2023-10-22","1","2023-10-22 12:29:50");
INSERT INTO tbl_recvoucher VALUES("1226","0","REV221023103","","1420.00","2023-10-22","1","2023-10-22 05:00:15");
INSERT INTO tbl_recvoucher VALUES("1227","0","REV221023104","","200.00","2023-10-22","1","2023-10-22 10:09:00");
INSERT INTO tbl_recvoucher VALUES("1228","0","REV221023105","","850.00","2023-10-22","1","2023-10-22 10:54:14");
INSERT INTO tbl_recvoucher VALUES("1229","0","REV231023101","","2000.00","2023-10-23","1","2023-10-23 07:14:02");
INSERT INTO tbl_recvoucher VALUES("1230","0","REV241023101","","3900.00","2023-10-24","1","2023-10-24 12:32:02");
INSERT INTO tbl_recvoucher VALUES("1231","0","REV241023102","","5250.00","2023-10-24","1","2023-10-24 04:12:31");
INSERT INTO tbl_recvoucher VALUES("1232","0","REV241023103","","2400.00","2023-10-24","1","2023-10-24 09:42:07");
INSERT INTO tbl_recvoucher VALUES("1233","0","REV241023104","","4000.00","2023-10-24","1","2023-10-24 10:13:01");
INSERT INTO tbl_recvoucher VALUES("1235","0","REV251023101","","3000.00","2023-10-25","1","2023-10-25 10:57:25");
INSERT INTO tbl_recvoucher VALUES("1236","0","REV251023102","","2000.00","2023-10-24","1","2023-10-25 06:47:15");
INSERT INTO tbl_recvoucher VALUES("1237","0","REV251023103","","1000.00","2023-10-25","1","2023-10-25 09:13:13");
INSERT INTO tbl_recvoucher VALUES("1238","0","REV251023104","","3300.00","2023-10-25","1","2023-10-25 09:27:21");
INSERT INTO tbl_recvoucher VALUES("1239","0","REV271023101","","2620.00","2023-10-27","1","2023-10-27 10:41:53");
INSERT INTO tbl_recvoucher VALUES("1240","0","REV271023102","","500.00","2023-10-26","1","2023-10-27 11:49:32");
INSERT INTO tbl_recvoucher VALUES("1241","0","REV271023103","","3000.00","2023-10-12","1","2023-10-27 03:20:44");
INSERT INTO tbl_recvoucher VALUES("1242","0","REV271023104","","400.00","2023-10-27","1","2023-10-27 08:39:49");
INSERT INTO tbl_recvoucher VALUES("1243","0","REV271023105","","5250.00","2023-10-27","1","2023-10-27 09:05:19");
INSERT INTO tbl_recvoucher VALUES("1244","0","REV281023101","","3000.00","2023-10-28","1","2023-10-28 05:45:12");
INSERT INTO tbl_recvoucher VALUES("1245","0","REV291023101","","10600.00","2023-10-29","1","2023-10-29 03:32:04");
INSERT INTO tbl_recvoucher VALUES("1246","0","REV291023102","","2000.00","2023-10-29","1","2023-10-29 04:30:50");
INSERT INTO tbl_recvoucher VALUES("1247","0","REV291023103","","3155.00","2023-10-29","1","2023-10-29 05:39:28");
INSERT INTO tbl_recvoucher VALUES("1248","0","REV291023104","","5250.00","2023-10-29","1","2023-10-29 06:30:23");
INSERT INTO tbl_recvoucher VALUES("1249","0","REV291023105","","400.00","2023-10-29","1","2023-10-29 08:18:01");
INSERT INTO tbl_recvoucher VALUES("1250","0","REV301023101","","1215.00","2023-10-30","1","2023-10-30 04:17:22");
INSERT INTO tbl_recvoucher VALUES("1251","0","REV301023102","","1365.00","2023-10-30","1","2023-10-30 05:43:58");
INSERT INTO tbl_recvoucher VALUES("1252","0","REV301023103","","1850.00","2023-10-30","1","2023-10-30 06:11:58");
INSERT INTO tbl_recvoucher VALUES("1253","0","REV301023104","","2480.00","2023-10-30","1","2023-10-30 06:33:05");
INSERT INTO tbl_recvoucher VALUES("1254","0","REV301023105","","4200.00","2023-10-30","1","2023-10-30 07:01:09");
INSERT INTO tbl_recvoucher VALUES("1255","0","REV301023106","","900.00","2023-10-30","1","2023-10-30 08:01:26");
INSERT INTO tbl_recvoucher VALUES("1256","0","REV301023107","","8000.00","2023-10-30","1","2023-10-30 09:45:29");
INSERT INTO tbl_recvoucher VALUES("1257","0","REV301023108","","5760.00","2023-10-30","1","2023-10-30 09:57:45");
INSERT INTO tbl_recvoucher VALUES("1258","0","REV311023101","","1365.00","2023-10-30","1","2023-10-31 10:40:15");
INSERT INTO tbl_recvoucher VALUES("1259","0","REV311023102","","5250.00","2023-10-31","1","2023-10-31 12:08:00");
INSERT INTO tbl_recvoucher VALUES("1260","0","REV311023103","","798.70","2023-10-31","1","2023-10-31 06:19:57");
INSERT INTO tbl_recvoucher VALUES("1261","0","REV311023104","","2760.00","2023-10-31","1","2023-10-31 08:35:17");
INSERT INTO tbl_recvoucher VALUES("1262","0","REV011123101","","6950.00","2023-11-01","1","2023-11-01 01:20:07");
INSERT INTO tbl_recvoucher VALUES("1263","0","REV011123102","","675.00","2023-11-01","1","2023-11-01 01:20:59");
INSERT INTO tbl_recvoucher VALUES("1264","0","REV011123103","","6000.00","2023-11-01","1","2023-11-01 02:17:23");
INSERT INTO tbl_recvoucher VALUES("1265","0","REV011123104","","1850.00","2023-11-01","1","2023-11-01 06:24:02");
INSERT INTO tbl_recvoucher VALUES("1266","0","REV011123105","","3450.00","2023-11-01","1","2023-11-01 07:50:08");
INSERT INTO tbl_recvoucher VALUES("1267","0","REV011123106","","2160.00","2023-11-01","1","2023-11-01 08:12:14");
INSERT INTO tbl_recvoucher VALUES("1268","0","REV011123107","","382.77","2023-11-01","1","2023-11-01 09:32:16");
INSERT INTO tbl_recvoucher VALUES("1269","0","REV021123101","","1650.00","2023-11-02","1","2023-11-02 02:39:15");
INSERT INTO tbl_recvoucher VALUES("1270","0","REV021123102","","700.00","2023-11-02","1","2023-11-02 02:40:05");
INSERT INTO tbl_recvoucher VALUES("1271","0","REV021123103","","4730.00","2023-11-02","1","2023-11-02 02:41:30");
INSERT INTO tbl_recvoucher VALUES("1272","0","REV021123104","","10000.00","2023-11-02","1","2023-11-02 02:42:38");
INSERT INTO tbl_recvoucher VALUES("1273","0","REV021123105","","8500.00","2023-11-02","1","2023-11-02 05:37:24");
INSERT INTO tbl_recvoucher VALUES("1274","0","REV021123106","","800.00","2023-11-02","1","2023-11-02 05:38:12");
INSERT INTO tbl_recvoucher VALUES("1275","0","REV021123107","","2500.00","2023-11-02","1","2023-11-02 08:45:52");
INSERT INTO tbl_recvoucher VALUES("1276","0","REV021123108","","2500.00","2023-11-02","1","2023-11-02 10:07:45");
INSERT INTO tbl_recvoucher VALUES("1277","0","REV021123109","","2076.00","2023-10-24","1","2023-11-02 10:40:57");
INSERT INTO tbl_recvoucher VALUES("1278","0","REV021123110","","11700.00","2023-11-02","1","2023-11-02 10:46:10");
INSERT INTO tbl_recvoucher VALUES("1279","0","REV031123101","","4125.00","2023-11-03","1","2023-11-03 11:50:02");
INSERT INTO tbl_recvoucher VALUES("1280","0","REV031123102","","400.00","2023-11-03","1","2023-11-03 12:27:36");
INSERT INTO tbl_recvoucher VALUES("1281","0","REV031123103","","3000.00","2023-11-03","1","2023-11-03 12:33:32");
INSERT INTO tbl_recvoucher VALUES("1282","0","REV031123104","","4110.00","2023-11-03","1","2023-11-03 02:46:53");
INSERT INTO tbl_recvoucher VALUES("1283","0","REV031123105","","4200.00","2023-11-03","1","2023-11-03 04:55:27");
INSERT INTO tbl_recvoucher VALUES("1284","0","REV031123106","","1480.00","2023-11-03","1","2023-11-03 05:14:11");
INSERT INTO tbl_recvoucher VALUES("1285","0","REV031123107","","10500.00","2023-11-03","1","2023-11-03 07:59:07");
INSERT INTO tbl_recvoucher VALUES("1286","0","REV031123108","","5430.00","2023-11-03","1","2023-11-03 08:55:13");
INSERT INTO tbl_recvoucher VALUES("1287","0","REV031123109","","3500.00","2023-11-03","1","2023-11-03 09:01:08");
INSERT INTO tbl_recvoucher VALUES("1288","0","REV041123101","","5150.00","2023-11-04","1","2023-11-04 01:55:58");
INSERT INTO tbl_recvoucher VALUES("1289","0","REV041123102","","8000.00","2023-11-04","1","2023-11-04 03:53:22");
INSERT INTO tbl_recvoucher VALUES("1290","0","REV041123103","","700.00","2023-11-04","1","2023-11-04 03:54:15");
INSERT INTO tbl_recvoucher VALUES("1291","0","REV041123104","","12670.00","2023-11-04","1","2023-11-04 03:55:05");
INSERT INTO tbl_recvoucher VALUES("1292","0","REV041123105","","10000.00","2023-11-04","1","2023-11-04 04:47:24");
INSERT INTO tbl_recvoucher VALUES("1293","0","REV041123106","","5900.00","2023-11-04","1","2023-11-04 05:47:35");
INSERT INTO tbl_recvoucher VALUES("1294","0","REV041123107","","1000.00","2023-11-04","1","2023-11-04 07:15:40");
INSERT INTO tbl_recvoucher VALUES("1295","0","REV041123108","","3000.00","2023-11-04","1","2023-11-04 07:17:13");
INSERT INTO tbl_recvoucher VALUES("1296","0","REV041123109","","500.00","2023-11-04","1","2023-11-04 08:18:12");
INSERT INTO tbl_recvoucher VALUES("1298","0","REV051123102","","7300.00","2023-11-05","1","2023-11-05 08:27:55");
INSERT INTO tbl_recvoucher VALUES("1299","0","REV051123103","","500.00","2023-11-05","1","2023-11-05 09:00:48");
INSERT INTO tbl_recvoucher VALUES("1300","0","REV061123101","","200.00","2023-11-05","1","2023-11-06 10:48:12");
INSERT INTO tbl_recvoucher VALUES("1301","0","REV061123102","","910.00","2023-11-06","1","2023-11-06 12:15:09");
INSERT INTO tbl_recvoucher VALUES("1302","0","REV061123103","","500.00","2023-11-06","1","2023-11-06 03:03:14");
INSERT INTO tbl_recvoucher VALUES("1303","0","REV061123104","","1300.00","2023-11-06","1","2023-11-06 06:48:24");
INSERT INTO tbl_recvoucher VALUES("1304","0","REV061123105","","1400.00","2023-11-06","1","2023-11-06 08:55:06");
INSERT INTO tbl_recvoucher VALUES("1305","0","REV061123106","","1800.00","2023-11-06","1","2023-11-06 10:39:49");
INSERT INTO tbl_recvoucher VALUES("1306","0","REV071123101","","3401.16","2023-11-07","1","2023-11-07 01:24:08");
INSERT INTO tbl_recvoucher VALUES("1307","0","REV071123102","","2500.00","2023-11-07","1","2023-11-07 05:44:49");
INSERT INTO tbl_recvoucher VALUES("1308","0","REV071123103","","10000.00","2023-11-07","1","2023-11-07 06:10:35");
INSERT INTO tbl_recvoucher VALUES("1309","0","REV071123104","","350.00","2023-11-07","1","2023-11-07 06:38:10");
INSERT INTO tbl_recvoucher VALUES("1310","0","REV071123105","","7126.58","2023-11-07","1","2023-11-07 06:59:16");
INSERT INTO tbl_recvoucher VALUES("1311","0","REV071123106","","2520.00","2023-11-07","1","2023-11-07 09:23:19");
INSERT INTO tbl_recvoucher VALUES("1312","0","REV071123107","","5400.04","2023-11-07","1","2023-11-07 09:24:23");
INSERT INTO tbl_recvoucher VALUES("1313","0","REV081123101","","650.00","2023-11-08","1","2023-11-08 02:01:43");
INSERT INTO tbl_recvoucher VALUES("1314","0","REV081123102","","8000.00","2023-11-08","1","2023-11-08 02:11:14");
INSERT INTO tbl_recvoucher VALUES("1315","0","REV081123103","","27695.40","2023-11-08","1","2023-11-08 03:31:05");
INSERT INTO tbl_recvoucher VALUES("1316","0","REV081123104","","6000.00","2023-11-08","1","2023-11-08 09:40:46");
INSERT INTO tbl_recvoucher VALUES("1317","0","REV081123105","","4000.00","2023-11-08","1","2023-11-08 10:01:48");
INSERT INTO tbl_recvoucher VALUES("1318","0","REV091123101","","3000.00","2023-11-05","1","2023-11-09 10:44:43");
INSERT INTO tbl_recvoucher VALUES("1319","0","REV091123102","","1900.00","2023-11-09","1","2023-11-09 01:11:04");
INSERT INTO tbl_recvoucher VALUES("1320","0","REV091123103","","2100.00","2023-11-09","1","2023-11-09 03:21:30");
INSERT INTO tbl_recvoucher VALUES("1321","0","REV091123104","","150.00","2023-11-09","1","2023-11-09 04:46:18");
INSERT INTO tbl_recvoucher VALUES("1322","0","REV091123105","","4087.00","2023-11-09","1","2023-11-09 08:10:25");
INSERT INTO tbl_recvoucher VALUES("1323","0","REV091123106","","2400.00","2023-11-09","1","2023-11-09 08:54:06");
INSERT INTO tbl_recvoucher VALUES("1324","0","REV091123107","","5000.00","2023-11-09","1","2023-11-09 09:47:27");
INSERT INTO tbl_recvoucher VALUES("1325","0","REV101123101","","10902.85","2023-11-10","1","2023-11-10 04:52:45");
INSERT INTO tbl_recvoucher VALUES("1326","0","REV101123102","","1530.00","2023-11-10","1","2023-11-10 05:02:02");
INSERT INTO tbl_recvoucher VALUES("1327","0","REV101123103","","3000.00","2023-11-10","1","2023-11-10 09:05:38");
INSERT INTO tbl_recvoucher VALUES("1328","0","REV101123104","","1500.00","2023-11-10","1","2023-11-10 09:31:51");
INSERT INTO tbl_recvoucher VALUES("1329","0","REV111123101","","18800.00","2023-11-11","1","2023-11-11 03:14:01");
INSERT INTO tbl_recvoucher VALUES("1330","0","REV111123102","","3150.00","2023-11-11","1","2023-11-11 03:18:05");
INSERT INTO tbl_recvoucher VALUES("1331","0","REV111123103","","910.00","2023-11-11","1","2023-11-11 06:03:57");
INSERT INTO tbl_recvoucher VALUES("1332","0","REV111123104","","5400.00","2023-11-11","1","2023-11-11 07:02:00");
INSERT INTO tbl_recvoucher VALUES("1333","0","REV111123105","","750.00","2023-11-11","1","2023-11-11 07:06:20");
INSERT INTO tbl_recvoucher VALUES("1334","0","REV111123106","","4622.90","2023-11-11","1","2023-11-11 08:41:05");
INSERT INTO tbl_recvoucher VALUES("1335","0","REV111123107","","3800.00","2023-11-11","1","2023-11-11 09:07:23");
INSERT INTO tbl_recvoucher VALUES("1336","0","REV111123108","","3000.00","2023-11-11","1","2023-11-11 09:57:04");
INSERT INTO tbl_recvoucher VALUES("1337","0","REV121123101","","12500.00","2023-11-12","1","2023-11-12 01:08:09");
INSERT INTO tbl_recvoucher VALUES("1338","0","REV121123102","","700.00","2023-11-12","1","2023-11-12 03:22:36");
INSERT INTO tbl_recvoucher VALUES("1339","0","REV121123103","","2400.00","2023-11-12","1","2023-11-12 06:10:24");
INSERT INTO tbl_recvoucher VALUES("1340","0","REV121123104","","4000.00","2023-11-12","1","2023-11-12 07:25:55");
INSERT INTO tbl_recvoucher VALUES("1341","0","REV121123105","","1000.00","2023-11-11","1","2023-11-12 07:52:59");
INSERT INTO tbl_recvoucher VALUES("1342","0","REV121123106","","2900.00","2023-11-12","1","2023-11-12 08:51:29");
INSERT INTO tbl_recvoucher VALUES("1343","0","REV121123107","","22645.00","2023-11-12","1","2023-11-12 09:46:55");
INSERT INTO tbl_recvoucher VALUES("1344","0","REV131123101","","2930.00","2023-11-13","1","2023-11-13 02:51:36");
INSERT INTO tbl_recvoucher VALUES("1345","0","REV131123102","","3698.95","2023-11-13","1","2023-11-13 04:23:13");
INSERT INTO tbl_recvoucher VALUES("1346","0","REV131123103","","6760.45","2023-11-13","1","2023-11-13 05:41:44");
INSERT INTO tbl_recvoucher VALUES("1347","0","REV131123104","","1400.00","2023-11-13","1","2023-11-13 05:42:30");
INSERT INTO tbl_recvoucher VALUES("1348","0","REV131123105","","5000.00","2023-11-13","1","2023-11-13 05:53:28");
INSERT INTO tbl_recvoucher VALUES("1349","0","REV131123106","","1930.00","2023-11-13","1","2023-11-13 07:00:31");
INSERT INTO tbl_recvoucher VALUES("1350","0","REV131123107","","612.00","2023-11-13","1","2023-11-13 08:50:15");
INSERT INTO tbl_recvoucher VALUES("1351","0","REV131123108","","6000.00","2023-11-13","1","2023-11-13 09:50:52");
INSERT INTO tbl_recvoucher VALUES("1352","0","REV141123101","","10000.00","2023-11-14","1","2023-11-14 03:04:47");
INSERT INTO tbl_recvoucher VALUES("1353","0","REV141123102","","1080.00","2023-11-14","1","2023-11-14 07:16:13");
INSERT INTO tbl_recvoucher VALUES("1354","0","REV141123103","","365.00","2023-11-14","1","2023-11-14 07:35:17");
INSERT INTO tbl_recvoucher VALUES("1355","0","REV141123104","","2079.20","2023-11-14","1","2023-11-14 07:58:53");
INSERT INTO tbl_recvoucher VALUES("1356","0","REV141123105","","64219.00","2023-11-14","1","2023-11-14 09:53:05");
INSERT INTO tbl_recvoucher VALUES("1357","0","REV141123106","","41120.00","2023-11-14","1","2023-11-14 09:56:21");
INSERT INTO tbl_recvoucher VALUES("1358","0","REV151123101","","367.00","2023-11-15","1","2023-11-15 01:13:01");
INSERT INTO tbl_recvoucher VALUES("1359","0","REV151123102","","500.00","2023-11-15","1","2023-11-15 02:45:33");
INSERT INTO tbl_recvoucher VALUES("1360","0","REV151123103","","4090.00","2023-11-15","1","2023-11-15 07:30:55");
INSERT INTO tbl_recvoucher VALUES("1361","0","REV151123104","","6500.00","2023-11-15","1","2023-11-15 09:26:25");
INSERT INTO tbl_recvoucher VALUES("1362","0","REV151123105","","5000.00","2023-11-15","1","2023-11-15 09:34:52");
INSERT INTO tbl_recvoucher VALUES("1363","0","REV161123101","","34500.00","2023-11-16","1","2023-11-16 12:00:54");
INSERT INTO tbl_recvoucher VALUES("1364","0","REV161123102","","1350.00","2023-11-16","1","2023-11-16 12:41:37");
INSERT INTO tbl_recvoucher VALUES("1365","0","REV161123103","","2323.00","2023-11-15","1","2023-11-16 12:45:27");
INSERT INTO tbl_recvoucher VALUES("1366","0","REV161123104","","3000.00","2023-11-16","1","2023-11-16 02:27:22");
INSERT INTO tbl_recvoucher VALUES("1367","0","REV161123105","","500.00","2023-11-16","1","2023-11-16 05:08:01");
INSERT INTO tbl_recvoucher VALUES("1368","0","REV161123106","","8000.00","2023-11-16","1","2023-11-16 08:03:01");
INSERT INTO tbl_recvoucher VALUES("1369","0","REV181123101","","5000.00","2023-11-18","1","2023-11-18 09:38:41");
INSERT INTO tbl_recvoucher VALUES("1370","0","REV181123102","","4900.00","2023-11-18","1","2023-11-18 09:39:26");
INSERT INTO tbl_recvoucher VALUES("1371","0","REV191123101","","700.00","2023-11-19","1","2023-11-19 12:48:52");
INSERT INTO tbl_recvoucher VALUES("1372","0","REV191123102","","1700.00","2023-11-19","1","2023-11-19 01:04:47");
INSERT INTO tbl_recvoucher VALUES("1373","0","REV191123103","","3500.00","2023-11-19","1","2023-11-19 06:30:31");
INSERT INTO tbl_recvoucher VALUES("1374","0","REV191123104","","3940.00","2023-11-19","1","2023-11-19 06:53:23");
INSERT INTO tbl_recvoucher VALUES("1375","0","REV191123105","","6080.00","2023-11-19","1","2023-11-19 08:50:21");
INSERT INTO tbl_recvoucher VALUES("1376","0","REV191123106","","5500.00","2023-11-19","1","2023-11-19 10:09:06");
INSERT INTO tbl_recvoucher VALUES("1377","0","REV201123101","","280.00","2023-11-20","1","2023-11-20 11:41:54");
INSERT INTO tbl_recvoucher VALUES("1378","0","REV201123102","","60.00","2023-11-20","1","2023-11-20 12:30:40");
INSERT INTO tbl_recvoucher VALUES("1379","0","REV201123103","","400.00","2023-10-27","1","2023-11-20 01:02:52");
INSERT INTO tbl_recvoucher VALUES("1380","0","REV201123104","","500.00","2023-11-20","1","2023-11-20 02:08:54");
INSERT INTO tbl_recvoucher VALUES("1381","0","REV201123105","","4800.00","2023-11-20","1","2023-11-20 04:33:18");
INSERT INTO tbl_recvoucher VALUES("1382","0","REV201123106","","3700.00","2023-11-20","1","2023-11-20 06:17:21");
INSERT INTO tbl_recvoucher VALUES("1383","0","REV201123107","","5000.00","2023-11-20","1","2023-11-20 09:59:45");
INSERT INTO tbl_recvoucher VALUES("1384","0","REV201123108","","3380.00","2023-11-20","1","2023-11-20 10:10:10");
INSERT INTO tbl_recvoucher VALUES("1385","0","REV201123109","","1100.00","2023-11-20","1","2023-11-20 10:24:53");
INSERT INTO tbl_recvoucher VALUES("1386","0","REV211123101","","200.00","2023-11-21","1","2023-11-21 04:35:03");
INSERT INTO tbl_recvoucher VALUES("1387","0","REV211123102","","1410.00","2023-11-21","1","2023-11-21 04:56:43");
INSERT INTO tbl_recvoucher VALUES("1388","0","REV211123103","","5000.00","2023-11-21","1","2023-11-21 07:40:29");
INSERT INTO tbl_recvoucher VALUES("1389","0","REV211123104","","8300.00","2023-11-21","1","2023-11-21 07:59:54");
INSERT INTO tbl_recvoucher VALUES("1390","0","REV211123105","","5700.00","2023-11-21","1","2023-11-21 08:51:42");
INSERT INTO tbl_recvoucher VALUES("1391","0","REV211123106","","400.00","2023-11-21","1","2023-11-21 09:48:48");
INSERT INTO tbl_recvoucher VALUES("1392","0","REV211123107","","11500.00","2023-11-21","1","2023-11-21 10:19:19");
INSERT INTO tbl_recvoucher VALUES("1393","0","REV221123101","","100.00","2023-11-22","1","2023-11-22 02:56:12");
INSERT INTO tbl_recvoucher VALUES("1394","0","REV221123102","","1140.00","2023-11-22","1","2023-11-22 04:58:04");
INSERT INTO tbl_recvoucher VALUES("1395","0","REV221123103","","2545.00","2023-11-22","1","2023-11-22 05:04:04");
INSERT INTO tbl_recvoucher VALUES("1396","0","REV221123104","","1000.00","2023-11-22","1","2023-11-22 08:50:38");
INSERT INTO tbl_recvoucher VALUES("1397","0","REV231123101","","10000.00","2023-11-23","1","2023-11-23 12:44:12");
INSERT INTO tbl_recvoucher VALUES("1398","0","REV231123102","","2550.55","2023-11-23","1","2023-11-23 04:39:46");
INSERT INTO tbl_recvoucher VALUES("1399","0","REV231123103","","1000.00","2023-11-23","1","2023-11-23 08:35:31");
INSERT INTO tbl_recvoucher VALUES("1400","0","REV231123104","","4200.00","2023-11-23","1","2023-11-23 09:10:35");
INSERT INTO tbl_recvoucher VALUES("1401","0","REV241123101","","5250.00","2023-11-24","1","2023-11-24 02:55:25");
INSERT INTO tbl_recvoucher VALUES("1402","0","REV241123102","","1250.00","2023-11-24","1","2023-11-24 07:11:35");
INSERT INTO tbl_recvoucher VALUES("1403","0","REV241123103","","2300.00","2023-11-24","1","2023-11-24 07:12:54");
INSERT INTO tbl_recvoucher VALUES("1404","0","REV251123101","","2600.00","2023-11-25","1","2023-11-25 01:29:39");
INSERT INTO tbl_recvoucher VALUES("1405","0","REV251123102","","5320.00","2023-11-25","1","2023-11-25 01:46:48");
INSERT INTO tbl_recvoucher VALUES("1406","0","REV251123103","","3000.00","2023-11-25","1","2023-11-25 08:00:35");
INSERT INTO tbl_recvoucher VALUES("1407","0","REV251123104","","3000.00","2023-11-25","1","2023-11-25 08:27:42");
INSERT INTO tbl_recvoucher VALUES("1408","0","REV261123101","","7360.00","2023-11-26","1","2023-11-26 02:58:26");
INSERT INTO tbl_recvoucher VALUES("1409","0","REV261123102","","5000.00","2023-11-26","1","2023-11-26 09:02:17");
INSERT INTO tbl_recvoucher VALUES("1410","0","REV271123101","","2300.00","2023-11-27","1","2023-11-27 02:08:00");
INSERT INTO tbl_recvoucher VALUES("1411","0","REV271123102","","280.00","2023-11-27","1","2023-11-27 02:24:17");
INSERT INTO tbl_recvoucher VALUES("1412","0","REV271123103","","5500.00","2023-11-27","1","2023-11-27 03:21:54");
INSERT INTO tbl_recvoucher VALUES("1413","0","REV271123104","","1000.00","2023-11-26","1","2023-11-27 08:07:04");
INSERT INTO tbl_recvoucher VALUES("1414","0","REV271123105","","3000.00","2023-11-27","1","2023-11-27 10:20:23");
INSERT INTO tbl_recvoucher VALUES("1415","0","REV281123101","","2900.00","2023-11-28","1","2023-11-28 04:09:04");
INSERT INTO tbl_recvoucher VALUES("1416","0","REV281123102","","4000.00","2023-11-28","1","2023-11-28 09:46:34");
INSERT INTO tbl_recvoucher VALUES("1417","0","REV291123101","","4700.00","2023-11-29","1","2023-11-29 02:01:37");
INSERT INTO tbl_recvoucher VALUES("1418","0","REV291123102","","5850.00","2023-11-29","1","2023-11-29 02:13:17");
INSERT INTO tbl_recvoucher VALUES("1419","0","REV291123103","","1310.00","2023-11-04","1","2023-11-29 02:22:07");
INSERT INTO tbl_recvoucher VALUES("1420","0","REV291123104","","3700.00","2023-11-10","1","2023-11-29 02:23:37");
INSERT INTO tbl_recvoucher VALUES("1421","0","REV291123105","","750.00","2023-11-29","1","2023-11-29 05:32:32");
INSERT INTO tbl_recvoucher VALUES("1422","0","REV291123106","","1920.00","2023-11-29","1","2023-11-29 10:38:16");
INSERT INTO tbl_recvoucher VALUES("1423","0","REV291123107","","3000.00","2023-11-29","1","2023-11-29 10:46:00");
INSERT INTO tbl_recvoucher VALUES("1424","0","REV301123101","","2350.00","2023-11-30","1","2023-11-30 10:45:25");
INSERT INTO tbl_recvoucher VALUES("1425","0","REV301123102","","1000.00","2023-11-30","1","2023-11-30 03:40:12");
INSERT INTO tbl_recvoucher VALUES("1426","0","REV301123103","","6480.00","2023-11-30","1","2023-11-30 10:31:50");
INSERT INTO tbl_recvoucher VALUES("1427","0","REV011223101","","6000.00","2023-12-01","1","2023-12-01 02:22:01");
INSERT INTO tbl_recvoucher VALUES("1428","0","REV011223102","","1342.80","2023-12-01","1","2023-12-01 07:30:46");
INSERT INTO tbl_recvoucher VALUES("1429","0","REV011223103","","5000.00","2023-12-01","1","2023-12-01 08:25:11");
INSERT INTO tbl_recvoucher VALUES("1430","0","REV011223104","","8500.00","2023-12-01","1","2023-12-01 09:58:20");
INSERT INTO tbl_recvoucher VALUES("1431","0","REV021223101","","6900.00","2023-12-02","1","2023-12-02 02:23:16");
INSERT INTO tbl_recvoucher VALUES("1432","0","REV021223102","","3600.00","2023-12-02","1","2023-12-02 02:24:52");
INSERT INTO tbl_recvoucher VALUES("1433","0","REV021223103","","3400.00","2023-12-02","1","2023-12-02 02:25:51");
INSERT INTO tbl_recvoucher VALUES("1434","0","REV021223104","","1000.00","2023-12-02","1","2023-12-02 02:27:09");
INSERT INTO tbl_recvoucher VALUES("1435","0","REV021223105","","1350.00","2023-12-02","1","2023-12-02 04:54:53");
INSERT INTO tbl_recvoucher VALUES("1436","0","REV021223106","","1400.00","2023-12-02","1","2023-12-02 08:51:55");
INSERT INTO tbl_recvoucher VALUES("1437","0","REV021223107","","3500.00","2023-12-02","1","2023-12-02 10:26:09");
INSERT INTO tbl_recvoucher VALUES("1438","0","REV031223101","","4500.00","2023-12-03","1","2023-12-03 01:33:01");
INSERT INTO tbl_recvoucher VALUES("1439","0","REV031223102","","900.00","2023-12-03","1","2023-12-03 08:46:49");
INSERT INTO tbl_recvoucher VALUES("1440","0","REV031223103","","6350.00","2023-12-03","1","2023-12-03 09:57:59");
INSERT INTO tbl_recvoucher VALUES("1441","0","REV041223101","","10000.00","2023-12-03","1","2023-12-04 12:35:47");
INSERT INTO tbl_recvoucher VALUES("1442","0","REV041223102","","7000.00","2023-11-05","1","2023-12-04 02:21:48");
INSERT INTO tbl_recvoucher VALUES("1443","0","REV041223103","","7000.00","2023-11-08","1","2023-12-04 02:41:56");
INSERT INTO tbl_recvoucher VALUES("1444","0","REV041223104","","5000.00","2023-11-11","1","2023-12-04 02:42:58");
INSERT INTO tbl_recvoucher VALUES("1445","0","REV041223105","","5000.00","2023-11-27","1","2023-12-04 02:44:31");
INSERT INTO tbl_recvoucher VALUES("1446","0","REV041223106","","2000.00","2023-12-04","1","2023-12-04 07:17:53");
INSERT INTO tbl_recvoucher VALUES("1447","0","REV041223107","","2240.00","2023-12-04","1","2023-12-04 07:29:33");
INSERT INTO tbl_recvoucher VALUES("1448","0","REV051223101","","1480.00","2023-12-05","1","2023-12-05 11:50:56");
INSERT INTO tbl_recvoucher VALUES("1449","0","REV051223102","","755.00","2023-12-05","1","2023-12-05 12:56:14");
INSERT INTO tbl_recvoucher VALUES("1450","0","REV051223103","","100.00","2023-12-05","1","2023-12-05 01:13:32");
INSERT INTO tbl_recvoucher VALUES("1451","0","REV051223104","","2678.00","2023-12-05","1","2023-12-05 04:49:38");
INSERT INTO tbl_recvoucher VALUES("1452","0","REV051223105","","3100.00","2023-12-05","1","2023-12-05 05:04:00");
INSERT INTO tbl_recvoucher VALUES("1453","0","REV051223106","","4910.00","2023-12-05","1","2023-12-05 06:58:04");
INSERT INTO tbl_recvoucher VALUES("1454","0","REV051223107","","2500.00","2023-12-05","1","2023-12-05 07:04:19");
INSERT INTO tbl_recvoucher VALUES("1455","0","REV051223108","","2000.00","2023-12-05","1","2023-12-05 09:04:13");
INSERT INTO tbl_recvoucher VALUES("1456","0","REV051223109","","800.00","2023-12-05","1","2023-12-05 09:05:22");
INSERT INTO tbl_recvoucher VALUES("1457","0","REV051223110","","400.00","2023-12-05","1","2023-12-05 10:54:15");
INSERT INTO tbl_recvoucher VALUES("1458","0","REV061223101","","4350.00","2023-12-06","1","2023-12-06 03:09:58");
INSERT INTO tbl_recvoucher VALUES("1459","0","REV061223102","","50.00","2023-11-26","1","2023-12-06 04:35:15");
INSERT INTO tbl_recvoucher VALUES("1460","0","REV061223103","","1400.00","2023-12-06","1","2023-12-06 07:41:43");
INSERT INTO tbl_recvoucher VALUES("1461","0","REV061223104","","4000.00","2023-12-06","1","2023-12-06 09:23:53");
INSERT INTO tbl_recvoucher VALUES("1462","0","REV061223105","","3000.00","2023-12-06","1","2023-12-06 09:49:36");
INSERT INTO tbl_recvoucher VALUES("1463","0","REV071223101","","640.00","2023-12-07","1","2023-12-07 12:35:03");
INSERT INTO tbl_recvoucher VALUES("1464","0","REV071223102","","3500.00","2023-12-07","1","2023-12-07 03:26:19");
INSERT INTO tbl_recvoucher VALUES("1465","0","REV071223103","","500.00","2023-12-07","1","2023-12-07 07:06:36");
INSERT INTO tbl_recvoucher VALUES("1466","0","REV081223101","","90.00","2023-12-08","1","2023-12-08 02:39:42");
INSERT INTO tbl_recvoucher VALUES("1467","0","REV081223102","","1000.00","2023-12-08","1","2023-12-08 08:16:29");
INSERT INTO tbl_recvoucher VALUES("1468","0","REV081223103","","5000.00","2023-12-08","1","2023-12-08 09:51:19");
INSERT INTO tbl_recvoucher VALUES("1469","0","REV091223101","","7370.00","2023-12-09","1","2023-12-09 02:44:24");
INSERT INTO tbl_recvoucher VALUES("1470","0","REV091223102","","17000.00","2023-12-09","1","2023-12-09 03:59:02");
INSERT INTO tbl_recvoucher VALUES("1471","0","REV091223103","","660.00","2023-12-09","1","2023-12-09 03:59:55");
INSERT INTO tbl_recvoucher VALUES("1472","0","REV091223104","","2160.00","2023-12-09","1","2023-12-09 05:44:37");
INSERT INTO tbl_recvoucher VALUES("1473","0","REV091223105","","12990.00","2023-12-09","1","2023-12-09 07:14:50");
INSERT INTO tbl_recvoucher VALUES("1474","0","REV091223106","","100.00","2023-12-09","1","2023-12-09 09:23:59");
INSERT INTO tbl_recvoucher VALUES("1475","0","REV091223107","","2340.00","2023-12-09","1","2023-12-09 11:02:55");
INSERT INTO tbl_recvoucher VALUES("1477","0","REV101223101","","10500.00","2023-12-10","1","2023-12-10 01:40:43");
INSERT INTO tbl_recvoucher VALUES("1478","0","REV101223102","","8258.00","2023-12-10","1","2023-12-10 05:14:35");
INSERT INTO tbl_recvoucher VALUES("1479","0","REV101223103","","1200.00","2023-12-10","1","2023-12-10 05:59:09");
INSERT INTO tbl_recvoucher VALUES("1480","0","REV101223104","","1260.00","2023-12-10","1","2023-12-10 06:01:55");
INSERT INTO tbl_recvoucher VALUES("1481","0","REV101223105","","3000.00","2023-12-10","1","2023-12-10 10:14:39");
INSERT INTO tbl_recvoucher VALUES("1482","0","REV111223101","","12350.00","2023-12-11","1","2023-12-11 01:55:04");
INSERT INTO tbl_recvoucher VALUES("1483","0","REV111223102","","16350.00","2023-12-11","1","2023-12-11 03:52:44");
INSERT INTO tbl_recvoucher VALUES("1484","0","REV111223103","","4100.00","2023-12-11","1","2023-12-11 09:29:18");
INSERT INTO tbl_recvoucher VALUES("1485","0","REV111223104","","4000.00","2023-12-11","1","2023-12-11 09:43:00");
INSERT INTO tbl_recvoucher VALUES("1486","0","REV121223101","","1300.00","2023-12-12","1","2023-12-12 05:06:57");
INSERT INTO tbl_recvoucher VALUES("1487","0","REV121223102","","1050.00","2023-12-12","1","2023-12-12 09:03:22");
INSERT INTO tbl_recvoucher VALUES("1488","0","REV121223103","","2500.00","2023-12-12","1","2023-12-12 09:55:02");
INSERT INTO tbl_recvoucher VALUES("1489","0","REV131223101","","3500.00","2023-12-13","1","2023-12-13 04:47:12");
INSERT INTO tbl_recvoucher VALUES("1490","0","REV131223102","","800.00","2023-12-13","1","2023-12-13 04:50:23");
INSERT INTO tbl_recvoucher VALUES("1491","0","REV131223103","","3000.00","2023-12-13","1","2023-12-13 06:09:44");
INSERT INTO tbl_recvoucher VALUES("1492","0","REV131223104","","5730.00","2023-12-13","1","2023-12-13 07:05:24");
INSERT INTO tbl_recvoucher VALUES("1493","0","REV131223105","","900.00","2023-12-13","1","2023-12-13 09:01:13");
INSERT INTO tbl_recvoucher VALUES("1494","0","REV131223106","","6500.00","2023-12-13","1","2023-12-13 09:48:03");
INSERT INTO tbl_recvoucher VALUES("1495","0","REV131223107","","8000.00","2023-12-13","1","2023-12-13 09:48:59");
INSERT INTO tbl_recvoucher VALUES("1496","0","REV141223101","","2000.00","2023-12-14","1","2023-12-14 02:59:41");
INSERT INTO tbl_recvoucher VALUES("1497","0","REV141223102","","1320.00","2023-12-14","1","2023-12-14 03:21:50");
INSERT INTO tbl_recvoucher VALUES("1498","0","REV141223103","","3270.00","2023-12-14","1","2023-12-14 03:30:21");
INSERT INTO tbl_recvoucher VALUES("1499","0","REV141223104","","3180.00","2023-12-14","1","2023-12-14 04:06:55");
INSERT INTO tbl_recvoucher VALUES("1500","0","REV141223105","","2300.00","2023-12-14","1","2023-12-14 04:55:28");
INSERT INTO tbl_recvoucher VALUES("1501","0","REV141223106","","900.00","2023-12-14","1","2023-12-14 08:06:16");
INSERT INTO tbl_recvoucher VALUES("1503","0","REV151223102","","1200.00","2023-12-15","1","2023-12-15 05:00:40");
INSERT INTO tbl_recvoucher VALUES("1504","0","REV151223103","","2000.00","2023-12-15","1","2023-12-15 05:01:40");
INSERT INTO tbl_recvoucher VALUES("1505","0","REV151223104","","15000.00","2023-12-15","1","2023-12-15 05:14:56");
INSERT INTO tbl_recvoucher VALUES("1506","0","REV151223105","","1000.00","2023-12-15","1","2023-12-15 06:08:35");
INSERT INTO tbl_recvoucher VALUES("1507","0","REV151223106","","50.00","2023-12-15","1","2023-12-15 07:10:18");
INSERT INTO tbl_recvoucher VALUES("1508","0","REV151223107","","10000.00","2023-12-15","1","2023-12-15 07:48:51");
INSERT INTO tbl_recvoucher VALUES("1509","0","REV161223101","","100.00","2023-12-16","1","2023-12-16 04:40:48");
INSERT INTO tbl_recvoucher VALUES("1510","0","REV161223102","","3000.00","2023-12-16","1","2023-12-16 07:35:10");
INSERT INTO tbl_recvoucher VALUES("1511","0","REV161223103","","1950.00","2023-12-16","1","2023-12-16 08:33:03");
INSERT INTO tbl_recvoucher VALUES("1512","0","REV171223101","","2200.00","2023-12-17","1","2023-12-17 04:10:31");
INSERT INTO tbl_recvoucher VALUES("1513","0","REV171223102","","20000.00","2023-12-17","1","2023-12-17 04:24:41");
INSERT INTO tbl_recvoucher VALUES("1514","0","REV171223103","","4050.00","2023-12-17","1","2023-12-17 04:47:45");
INSERT INTO tbl_recvoucher VALUES("1515","0","REV171223104","","1800.00","2023-12-17","1","2023-12-17 05:50:25");
INSERT INTO tbl_recvoucher VALUES("1516","0","REV171223105","","2000.00","2023-12-17","1","2023-12-17 07:58:53");
INSERT INTO tbl_recvoucher VALUES("1517","0","REV181223101","","37000.00","2023-12-18","1","2023-12-18 01:17:40");
INSERT INTO tbl_recvoucher VALUES("1518","0","REV181223102","","4680.00","2023-12-18","1","2023-12-18 08:29:05");
INSERT INTO tbl_recvoucher VALUES("1519","0","REV181223103","","8000.00","2023-12-18","1","2023-12-18 09:13:59");
INSERT INTO tbl_recvoucher VALUES("1520","0","REV191223101","","350.00","2023-12-19","1","2023-12-19 11:18:47");
INSERT INTO tbl_recvoucher VALUES("1521","0","REV191223102","","3220.00","2023-12-14","1","2023-12-19 12:28:56");
INSERT INTO tbl_recvoucher VALUES("1522","0","REV191223103","","330.00","2023-12-19","1","2023-12-19 01:33:40");
INSERT INTO tbl_recvoucher VALUES("1523","0","REV191223104","","5100.00","2023-12-19","1","2023-12-19 02:35:09");
INSERT INTO tbl_recvoucher VALUES("1524","0","REV191223105","","2200.00","2023-12-19","1","2023-12-19 06:10:51");
INSERT INTO tbl_recvoucher VALUES("1525","0","REV191223106","","1900.00","2023-12-19","1","2023-12-19 06:11:52");
INSERT INTO tbl_recvoucher VALUES("1526","0","REV191223107","","2200.00","2023-12-19","1","2023-12-19 08:25:12");
INSERT INTO tbl_recvoucher VALUES("1527","0","REV201223101","","8100.00","2023-12-20","1","2023-12-20 05:04:48");
INSERT INTO tbl_recvoucher VALUES("1528","0","REV201223102","","5000.00","2023-12-20","1","2023-12-20 06:31:47");
INSERT INTO tbl_recvoucher VALUES("1529","0","REV201223103","","2625.36","2023-12-20","1","2023-12-20 07:20:33");
INSERT INTO tbl_recvoucher VALUES("1530","0","REV201223104","","2160.00","2023-12-20","1","2023-12-20 07:33:40");
INSERT INTO tbl_recvoucher VALUES("1531","0","REV201223105","","1250.00","2023-12-20","1","2023-12-20 08:17:44");
INSERT INTO tbl_recvoucher VALUES("1532","0","REV211223101","","2060.00","2023-12-21","1","2023-12-21 01:47:08");
INSERT INTO tbl_recvoucher VALUES("1533","0","REV211223102","","1900.00","2023-12-21","1","2023-12-21 02:31:13");
INSERT INTO tbl_recvoucher VALUES("1534","0","REV221223101","","10000.00","2023-12-22","1","2023-12-22 11:59:56");
INSERT INTO tbl_recvoucher VALUES("1535","0","REV221223102","","2560.00","2023-12-22","1","2023-12-22 02:41:58");
INSERT INTO tbl_recvoucher VALUES("1536","0","REV221223103","","5000.00","2023-12-22","1","2023-12-22 04:19:40");
INSERT INTO tbl_recvoucher VALUES("1537","0","REV221223104","","1250.00","2023-12-20","1","2023-12-22 09:10:12");
INSERT INTO tbl_recvoucher VALUES("1538","0","REV231223101","","1200.00","2023-12-23","1","2023-12-23 01:41:18");
INSERT INTO tbl_recvoucher VALUES("1539","0","REV231223102","","100.00","2023-12-23","1","2023-12-23 03:05:33");
INSERT INTO tbl_recvoucher VALUES("1540","0","REV231223103","","5240.00","2023-12-23","1","2023-12-23 07:52:33");
INSERT INTO tbl_recvoucher VALUES("1541","0","REV231223104","","3565.00","2023-12-23","1","2023-12-23 08:02:43");
INSERT INTO tbl_recvoucher VALUES("1542","0","REV231223105","","3700.00","2023-12-23","1","2023-12-23 09:55:48");
INSERT INTO tbl_recvoucher VALUES("1543","0","REV231223106","","5000.00","2023-12-23","1","2023-12-23 10:30:53");
INSERT INTO tbl_recvoucher VALUES("1544","0","REV241223101","","1930.00","2023-12-24","1","2023-12-24 11:30:21");
INSERT INTO tbl_recvoucher VALUES("1545","0","REV241223102","","9125.50","2023-12-24","1","2023-12-24 08:37:20");
INSERT INTO tbl_recvoucher VALUES("1546","0","REV241223103","","3000.00","2023-12-24","1","2023-12-24 09:28:14");
INSERT INTO tbl_recvoucher VALUES("1547","0","REV241223104","","4500.00","2023-12-24","1","2023-12-24 09:32:28");
INSERT INTO tbl_recvoucher VALUES("1548","0","REV251223101","","18880.00","2023-12-25","1","2023-12-25 04:50:46");
INSERT INTO tbl_recvoucher VALUES("1549","0","REV251223102","","4685.00","2023-12-25","1","2023-12-25 10:21:23");
INSERT INTO tbl_recvoucher VALUES("1550","0","REV261223101","","3010.00","2023-12-26","1","2023-12-26 01:53:04");
INSERT INTO tbl_recvoucher VALUES("1551","0","REV261223102","","3560.00","2023-12-26","1","2023-12-26 06:17:51");
INSERT INTO tbl_recvoucher VALUES("1552","0","REV261223103","","1400.00","2023-12-26","1","2023-12-26 06:55:51");
INSERT INTO tbl_recvoucher VALUES("1553","0","REV271223101","","21000.00","2023-12-27","1","2023-12-27 01:28:49");
INSERT INTO tbl_recvoucher VALUES("1554","0","REV271223102","","7490.00","2023-12-27","1","2023-12-27 07:02:20");
INSERT INTO tbl_recvoucher VALUES("1555","0","REV271223103","","1500.00","2023-12-27","1","2023-12-27 08:26:01");
INSERT INTO tbl_recvoucher VALUES("1556","0","REV291223101","","4500.00","2023-12-29","1","2023-12-29 04:51:30");
INSERT INTO tbl_recvoucher VALUES("1557","0","REV291223102","","4000.00","2023-12-29","1","2023-12-29 10:49:37");
INSERT INTO tbl_recvoucher VALUES("1558","0","REV301223101","","250.00","2023-12-30","1","2023-12-30 12:30:59");
INSERT INTO tbl_recvoucher VALUES("1559","0","REV301223102","","4000.00","2023-12-30","1","2023-12-30 01:28:55");
INSERT INTO tbl_recvoucher VALUES("1560","0","REV301223103","","7000.00","2023-12-30","1","2023-12-30 01:58:34");
INSERT INTO tbl_recvoucher VALUES("1561","0","REV301223104","","7000.00","2023-12-30","1","2023-12-30 06:29:15");
INSERT INTO tbl_recvoucher VALUES("1562","0","REV301223105","","4000.00","2023-12-30","1","2023-12-30 06:46:33");
INSERT INTO tbl_recvoucher VALUES("1563","0","REV301223106","","800.00","2023-12-30","1","2023-12-30 07:19:50");
INSERT INTO tbl_recvoucher VALUES("1564","0","REV311223101","","1000.00","2023-12-31","1","2023-12-31 11:50:10");
INSERT INTO tbl_recvoucher VALUES("1565","0","REV311223102","","7000.00","2023-12-27","1","2023-12-31 11:52:41");
INSERT INTO tbl_recvoucher VALUES("1566","0","REV311223103","","5575.00","2023-12-31","1","2023-12-31 03:20:49");
INSERT INTO tbl_recvoucher VALUES("1567","0","REV311223104","","6000.00","2023-12-31","1","2023-12-31 04:13:35");
INSERT INTO tbl_recvoucher VALUES("1568","0","REV311223105","","2700.00","2023-12-31","1","2023-12-31 07:40:22");
INSERT INTO tbl_recvoucher VALUES("1569","0","REV311223106","","100.00","2023-12-31","1","2023-12-31 08:25:36");
INSERT INTO tbl_recvoucher VALUES("1570","0","REV311223107","","13000.00","2023-12-31","1","2023-12-31 08:40:28");
INSERT INTO tbl_recvoucher VALUES("1571","0","REV010124101","","500.50","2024-01-01","1","2024-01-01 11:48:48");
INSERT INTO tbl_recvoucher VALUES("1572","0","REV010124102","","2500.00","2024-01-01","1","2024-01-01 02:19:25");
INSERT INTO tbl_recvoucher VALUES("1573","0","REV010124103","","4000.00","2024-01-01","1","2024-01-01 07:28:34");
INSERT INTO tbl_recvoucher VALUES("1574","0","REV010124104","","7400.00","2024-01-01","1","2024-01-01 10:32:13");
INSERT INTO tbl_recvoucher VALUES("1575","0","REV020124101","","3000.00","2024-01-02","1","2024-01-02 08:36:44");
INSERT INTO tbl_recvoucher VALUES("1576","0","REV020124102","","2635.00","2024-01-02","1","2024-01-02 10:29:48");
INSERT INTO tbl_recvoucher VALUES("1577","0","REV030124101","","4000.00","2024-01-03","1","2024-01-03 12:19:54");
INSERT INTO tbl_recvoucher VALUES("1578","0","REV030124102","","850.00","2024-01-03","1","2024-01-03 07:22:28");
INSERT INTO tbl_recvoucher VALUES("1579","0","REV030124103","","1550.00","2024-01-03","1","2024-01-03 07:25:11");
INSERT INTO tbl_recvoucher VALUES("1580","0","REV030124104","","2500.00","2024-01-03","1","2024-01-03 09:15:55");
INSERT INTO tbl_recvoucher VALUES("1581","0","REV040124101","","3000.44","2024-01-04","1","2024-01-04 01:04:18");
INSERT INTO tbl_recvoucher VALUES("1582","0","REV040124102","","700.00","2024-01-04","1","2024-01-04 01:19:42");
INSERT INTO tbl_recvoucher VALUES("1583","0","REV040124103","","10000.00","2024-01-04","1","2024-01-04 05:24:39");
INSERT INTO tbl_recvoucher VALUES("1584","0","REV040124104","","14880.00","2024-01-04","1","2024-01-04 05:32:02");
INSERT INTO tbl_recvoucher VALUES("1585","0","REV040124105","","5120.00","2024-01-04","1","2024-01-04 06:19:48");
INSERT INTO tbl_recvoucher VALUES("1586","0","REV040124106","","4000.00","2024-01-04","1","2024-01-04 09:25:15");
INSERT INTO tbl_recvoucher VALUES("1587","0","REV040124107","","1450.00","2024-01-04","1","2024-01-04 10:40:48");
INSERT INTO tbl_recvoucher VALUES("1589","0","REV050124102","","993.00","2024-01-05","1","2024-01-05 11:33:39");
INSERT INTO tbl_recvoucher VALUES("1590","0","REV050124103","","7200.00","2024-01-05","1","2024-01-05 03:23:23");
INSERT INTO tbl_recvoucher VALUES("1591","0","REV050124104","","4200.00","2024-01-05","1","2024-01-05 06:47:00");
INSERT INTO tbl_recvoucher VALUES("1592","0","REV050124105","","1000.00","2024-01-05","1","2024-01-05 07:51:09");
INSERT INTO tbl_recvoucher VALUES("1593","0","REV050124106","","400.00","2024-01-05","1","2024-01-05 08:59:04");
INSERT INTO tbl_recvoucher VALUES("1594","0","REV050124107","","9300.00","2024-01-05","1","2024-01-05 10:36:03");
INSERT INTO tbl_recvoucher VALUES("1595","0","REV060124101","","1250.00","2024-01-06","1","2024-01-06 12:35:30");
INSERT INTO tbl_recvoucher VALUES("1596","0","REV060124102","","1200.00","2024-01-06","1","2024-01-06 02:18:10");
INSERT INTO tbl_recvoucher VALUES("1597","0","REV060124103","","1000.00","2024-01-06","1","2024-01-06 02:39:20");
INSERT INTO tbl_recvoucher VALUES("1598","0","REV060124104","","3000.00","2024-01-06","1","2024-01-06 03:32:57");
INSERT INTO tbl_recvoucher VALUES("1599","0","REV060124105","","2660.00","2024-01-06","1","2024-01-06 08:51:55");
INSERT INTO tbl_recvoucher VALUES("1600","0","REV070124101","","1000.00","2024-01-07","1","2024-01-07 01:10:05");
INSERT INTO tbl_recvoucher VALUES("1601","0","REV080124101","","5000.00","2024-01-08","1","2024-01-08 02:19:53");
INSERT INTO tbl_recvoucher VALUES("1603","0","REV080124102","","1450.00","2024-01-08","1","2024-01-08 07:06:54");
INSERT INTO tbl_recvoucher VALUES("1604","0","REV080124103","","4000.00","2024-01-08","1","2024-01-08 09:26:46");
INSERT INTO tbl_recvoucher VALUES("1605","0","REV080124104","","1000.00","2023-12-21","1","2024-01-08 09:27:53");
INSERT INTO tbl_recvoucher VALUES("1606","0","REV080124105","","1400.00","2024-01-08","1","2024-01-08 09:35:07");
INSERT INTO tbl_recvoucher VALUES("1607","0","REV090124101","","1695.00","2024-01-09","1","2024-01-09 01:16:48");
INSERT INTO tbl_recvoucher VALUES("1608","0","REV090124102","","4100.00","2024-01-09","1","2024-01-09 03:17:50");
INSERT INTO tbl_recvoucher VALUES("1609","0","REV090124103","","190.00","2024-01-09","1","2024-01-09 09:47:06");
INSERT INTO tbl_recvoucher VALUES("1610","0","REV090124104","","6000.00","2024-01-09","1","2024-01-09 09:51:10");
INSERT INTO tbl_recvoucher VALUES("1611","0","REV090124105","","4320.00","2024-01-09","1","2024-01-09 10:10:09");
INSERT INTO tbl_recvoucher VALUES("1612","0","REV090124106","","3000.00","2024-01-09","1","2024-01-09 10:15:09");
INSERT INTO tbl_recvoucher VALUES("1613","0","REV100124101","","688.52","2024-01-10","1","2024-01-10 12:19:59");
INSERT INTO tbl_recvoucher VALUES("1614","0","REV100124102","","15000.00","2024-01-10","1","2024-01-10 12:41:18");
INSERT INTO tbl_recvoucher VALUES("1615","0","REV100124103","","640.00","2024-01-03","1","2024-01-10 01:38:23");
INSERT INTO tbl_recvoucher VALUES("1616","0","REV100124104","","1500.00","2024-01-10","1","2024-01-10 03:26:00");
INSERT INTO tbl_recvoucher VALUES("1617","0","REV100124105","","25000.00","2024-01-10","1","2024-01-10 03:35:17");
INSERT INTO tbl_recvoucher VALUES("1618","0","REV100124106","","5000.00","2024-01-10","1","2024-01-10 09:20:18");
INSERT INTO tbl_recvoucher VALUES("1619","0","REV110124101","","3750.00","2024-01-11","1","2024-01-11 12:27:48");
INSERT INTO tbl_recvoucher VALUES("1620","0","REV110124102","","1080.00","2024-01-11","1","2024-01-11 01:11:05");
INSERT INTO tbl_recvoucher VALUES("1621","0","REV110124103","","1500.00","2024-01-11","1","2024-01-11 07:27:05");
INSERT INTO tbl_recvoucher VALUES("1622","0","REV110124104","","25000.00","2024-01-11","1","2024-01-11 09:15:38");
INSERT INTO tbl_recvoucher VALUES("1623","0","REV110124105","","8000.00","2024-01-11","1","2024-01-11 09:25:23");
INSERT INTO tbl_recvoucher VALUES("1624","0","REV120124101","","1630.00","2024-01-12","1","2024-01-12 09:32:04");
INSERT INTO tbl_recvoucher VALUES("1625","0","REV130124101","","2300.00","2024-01-13","1","2024-01-13 02:37:01");
INSERT INTO tbl_recvoucher VALUES("1626","0","REV130124102","","20000.00","2024-01-13","1","2024-01-13 03:59:08");
INSERT INTO tbl_recvoucher VALUES("1627","0","REV130124103","","1400.00","2024-01-13","1","2024-01-13 04:41:35");
INSERT INTO tbl_recvoucher VALUES("1628","0","REV140124101","","1260.00","2024-01-14","1","2024-01-14 12:19:18");
INSERT INTO tbl_recvoucher VALUES("1629","0","REV140124102","","3020.00","2024-01-14","1","2024-01-14 04:50:52");
INSERT INTO tbl_recvoucher VALUES("1630","0","REV140124103","","4700.00","2024-01-14","1","2024-01-14 06:31:34");
INSERT INTO tbl_recvoucher VALUES("1631","0","REV140124104","","145.00","2024-01-14","1","2024-01-14 06:46:51");
INSERT INTO tbl_recvoucher VALUES("1632","0","REV140124105","","3500.00","2024-01-14","1","2024-01-14 07:23:10");
INSERT INTO tbl_recvoucher VALUES("1633","0","REV140124106","","1000.00","2024-01-14","1","2024-01-14 09:27:19");
INSERT INTO tbl_recvoucher VALUES("1634","0","REV150124101","","7800.00","2024-01-15","1","2024-01-15 07:56:09");
INSERT INTO tbl_recvoucher VALUES("1635","0","REV150124102","","5240.00","2023-12-23","1","2024-01-15 08:01:19");
INSERT INTO tbl_recvoucher VALUES("1636","0","REV150124103","","7500.00","2024-01-15","1","2024-01-15 09:19:56");
INSERT INTO tbl_recvoucher VALUES("1637","0","REV150124104","","4103.00","2024-01-15","1","2024-01-15 09:23:00");
INSERT INTO tbl_recvoucher VALUES("1638","0","REV150124105","","5000.00","2024-01-15","1","2024-01-15 09:43:44");
INSERT INTO tbl_recvoucher VALUES("1639","0","REV150124106","","10000.00","2024-01-15","1","2024-01-15 09:52:31");
INSERT INTO tbl_recvoucher VALUES("1640","0","REV150124107","","280.00","2024-01-15","1","2024-01-15 10:38:25");
INSERT INTO tbl_recvoucher VALUES("1641","0","REV160124101","","5000.00","2024-01-16","1","2024-01-16 01:53:51");
INSERT INTO tbl_recvoucher VALUES("1642","0","REV160124102","","17510.00","2024-01-16","1","2024-01-16 03:48:46");
INSERT INTO tbl_recvoucher VALUES("1643","0","REV160124103","","7000.00","2024-01-15","1","2024-01-16 04:14:06");
INSERT INTO tbl_recvoucher VALUES("1644","0","REV160124104","","1325.00","2023-11-21","1","2024-01-16 05:46:22");
INSERT INTO tbl_recvoucher VALUES("1645","0","REV160124105","","700.00","2024-01-16","1","2024-01-16 07:04:54");
INSERT INTO tbl_recvoucher VALUES("1646","0","REV160124106","","560.00","2024-01-16","1","2024-01-16 08:45:29");
INSERT INTO tbl_recvoucher VALUES("1647","0","REV160124107","","5000.00","2024-01-16","1","2024-01-16 08:46:34");
INSERT INTO tbl_recvoucher VALUES("1648","0","REV160124108","","7500.00","2024-01-16","1","2024-01-16 09:42:44");
INSERT INTO tbl_recvoucher VALUES("1649","0","REV160124109","","2650.00","2024-01-16","1","2024-01-16 10:14:05");
INSERT INTO tbl_recvoucher VALUES("1650","0","REV170124101","","1050.00","2024-01-17","1","2024-01-17 11:07:00");
INSERT INTO tbl_recvoucher VALUES("1651","0","REV170124102","","1290.00","2024-01-17","1","2024-01-17 04:25:12");
INSERT INTO tbl_recvoucher VALUES("1652","0","REV170124103","","5000.00","2024-01-06","1","2024-01-17 07:30:48");
INSERT INTO tbl_recvoucher VALUES("1653","0","REV180124101","","2000.00","2024-01-18","1","2024-01-18 01:02:31");
INSERT INTO tbl_recvoucher VALUES("1654","0","REV180124102","","6500.00","2024-01-18","1","2024-01-18 09:28:52");
INSERT INTO tbl_recvoucher VALUES("1655","0","REV180124103","","3000.00","2024-01-18","1","2024-01-18 09:30:50");
INSERT INTO tbl_recvoucher VALUES("1656","0","REV190124101","","910.00","2024-01-19","1","2024-01-19 03:56:34");
INSERT INTO tbl_recvoucher VALUES("1657","0","REV200124101","","4260.00","2024-01-20","1","2024-01-20 12:50:25");
INSERT INTO tbl_recvoucher VALUES("1658","0","REV200124102","","1572.00","2024-01-20","1","2024-01-20 01:48:04");
INSERT INTO tbl_recvoucher VALUES("1659","0","REV200124103","","500.00","2024-01-20","1","2024-01-20 01:49:39");
INSERT INTO tbl_recvoucher VALUES("1660","0","REV200124104","","2050.00","2024-01-20","1","2024-01-20 02:35:48");
INSERT INTO tbl_recvoucher VALUES("1661","0","REV200124105","","630.00","2024-01-20","1","2024-01-20 02:37:16");
INSERT INTO tbl_recvoucher VALUES("1662","0","REV200124106","","4440.00","2024-01-20","1","2024-01-20 02:56:29");
INSERT INTO tbl_recvoucher VALUES("1663","0","REV200124107","","4700.00","2024-01-20","1","2024-01-20 07:35:57");
INSERT INTO tbl_recvoucher VALUES("1664","0","REV200124108","","3000.00","2024-01-20","1","2024-01-20 07:55:06");
INSERT INTO tbl_recvoucher VALUES("1665","0","REV200124109","","20000.00","2024-01-20","1","2024-01-20 08:10:06");
INSERT INTO tbl_recvoucher VALUES("1666","0","REV210124101","","2200.00","2024-01-21","1","2024-01-21 02:49:32");
INSERT INTO tbl_recvoucher VALUES("1667","0","REV210124102","","2900.00","2024-01-21","1","2024-01-21 03:09:08");
INSERT INTO tbl_recvoucher VALUES("1668","0","REV210124103","","11150.00","2024-01-21","1","2024-01-21 08:01:16");
INSERT INTO tbl_recvoucher VALUES("1669","0","REV210124104","","5500.00","2024-01-21","1","2024-01-21 09:01:15");
INSERT INTO tbl_recvoucher VALUES("1670","0","REV220124101","","1420.00","2024-01-22","1","2024-01-22 12:54:40");
INSERT INTO tbl_recvoucher VALUES("1671","0","REV220124102","","10450.00","2024-01-22","1","2024-01-22 05:36:25");
INSERT INTO tbl_recvoucher VALUES("1672","0","REV220124103","","2000.00","2024-01-22","1","2024-01-22 09:06:41");
INSERT INTO tbl_recvoucher VALUES("1673","0","REV230124101","","5850.00","2024-01-23","1","2024-01-23 03:58:41");
INSERT INTO tbl_recvoucher VALUES("1674","0","REV230124102","","1650.00","2024-01-23","1","2024-01-23 05:46:42");
INSERT INTO tbl_recvoucher VALUES("1675","0","REV230124103","","2350.00","2024-01-23","1","2024-01-23 09:23:35");
INSERT INTO tbl_recvoucher VALUES("1676","0","REV240124101","","1400.00","2024-01-24","1","2024-01-24 11:59:01");
INSERT INTO tbl_recvoucher VALUES("1677","0","REV240124102","","1505.00","2024-01-24","1","2024-01-24 07:22:08");
INSERT INTO tbl_recvoucher VALUES("1678","0","REV250124101","","1800.00","2024-01-25","1","2024-01-25 06:46:48");
INSERT INTO tbl_recvoucher VALUES("1679","0","REV250124102","","11000.00","2024-01-25","1","2024-01-25 07:34:25");
INSERT INTO tbl_recvoucher VALUES("1680","0","REV250124103","","1000.00","2024-01-25","1","2024-01-25 08:04:40");
INSERT INTO tbl_recvoucher VALUES("1681","0","REV250124104","","4000.00","2024-01-25","1","2024-01-25 09:41:44");
INSERT INTO tbl_recvoucher VALUES("1682","0","REV260124101","","1300.00","2024-01-26","1","2024-01-26 05:24:55");
INSERT INTO tbl_recvoucher VALUES("1683","0","REV260124102","","5000.00","2024-01-26","1","2024-01-26 09:21:07");
INSERT INTO tbl_recvoucher VALUES("1684","0","REV270124101","","1000.00","2024-01-27","1","2024-01-27 07:13:23");
INSERT INTO tbl_recvoucher VALUES("1685","0","REV280124101","","10000.00","2024-01-28","1","2024-01-28 02:19:53");
INSERT INTO tbl_recvoucher VALUES("1686","0","REV280124102","","3660.00","2024-01-28","1","2024-01-28 10:05:23");
INSERT INTO tbl_recvoucher VALUES("1687","0","REV280124103","","7000.00","2024-01-28","1","2024-01-28 10:29:23");
INSERT INTO tbl_recvoucher VALUES("1688","0","REV290124101","","2160.00","2024-01-29","1","2024-01-29 11:39:36");
INSERT INTO tbl_recvoucher VALUES("1689","0","REV290124102","","7770.00","2024-01-29","1","2024-01-29 07:00:15");
INSERT INTO tbl_recvoucher VALUES("1690","0","REV290124103","","3000.00","2024-01-29","1","2024-01-29 08:43:09");
INSERT INTO tbl_recvoucher VALUES("1691","0","REV290124104","","2000.00","2024-01-29","1","2024-01-29 09:29:52");
INSERT INTO tbl_recvoucher VALUES("1692","0","REV290124105","","6000.00","2024-01-29","1","2024-01-29 09:32:00");
INSERT INTO tbl_recvoucher VALUES("1693","0","REV290124106","","7700.00","2024-01-29","1","2024-01-29 09:54:48");
INSERT INTO tbl_recvoucher VALUES("1694","0","REV300124101","","95381.62","2024-01-30","1","2024-01-30 01:28:28");
INSERT INTO tbl_recvoucher VALUES("1695","0","REV300124102","","10000.00","2024-01-30","1","2024-01-30 06:59:19");
INSERT INTO tbl_recvoucher VALUES("1696","0","REV300124103","","1170.00","2024-01-30","1","2024-01-30 08:42:30");
INSERT INTO tbl_recvoucher VALUES("1697","0","REV300124104","","1180.00","2024-01-30","1","2024-01-30 10:58:07");
INSERT INTO tbl_recvoucher VALUES("1698","0","REV310124101","","21500.00","2024-01-31","1","2024-01-31 03:13:49");
INSERT INTO tbl_recvoucher VALUES("1699","0","REV310124102","","7000.00","2024-01-31","1","2024-01-31 07:38:53");
INSERT INTO tbl_recvoucher VALUES("1700","0","REV310124103","","3000.00","2024-01-31","1","2024-01-31 07:59:47");
INSERT INTO tbl_recvoucher VALUES("1701","0","REV010224101","","5500.00","2024-02-01","1","2024-02-01 11:50:08");
INSERT INTO tbl_recvoucher VALUES("1702","0","REV010224102","","200.35","2024-02-01","1","2024-02-01 09:47:48");
INSERT INTO tbl_recvoucher VALUES("1703","0","REV010224103","","16000.00","2024-02-01","1","2024-02-01 10:24:00");
INSERT INTO tbl_recvoucher VALUES("1704","0","REV020224101","","9500.00","2024-02-02","1","2024-02-02 08:17:14");
INSERT INTO tbl_recvoucher VALUES("1705","0","REV020224102","","6500.00","2024-02-02","1","2024-02-02 08:34:38");
INSERT INTO tbl_recvoucher VALUES("1706","0","REV020224103","","3160.00","2024-02-02","1","2024-02-02 09:02:43");
INSERT INTO tbl_recvoucher VALUES("1707","0","REV020224104","","2800.00","2024-02-02","1","2024-02-02 09:42:06");
INSERT INTO tbl_recvoucher VALUES("1708","0","REV020224105","","2200.00","2024-02-02","1","2024-02-02 09:43:39");
INSERT INTO tbl_recvoucher VALUES("1709","0","REV020224106","","5000.00","2024-02-02","1","2024-02-02 09:44:52");
INSERT INTO tbl_recvoucher VALUES("1710","0","REV030224101","","1500.00","2024-02-03","1","2024-02-03 03:45:07");
INSERT INTO tbl_recvoucher VALUES("1711","0","REV030224102","","1080.00","2024-02-03","1","2024-02-03 08:01:17");
INSERT INTO tbl_recvoucher VALUES("1712","0","REV030224103","","6000.00","2024-02-03","1","2024-02-03 08:11:10");
INSERT INTO tbl_recvoucher VALUES("1713","0","REV040224101","","10000.00","2024-02-04","1","2024-02-04 01:37:20");
INSERT INTO tbl_recvoucher VALUES("1714","0","REV040224102","","15000.00","2024-02-04","1","2024-02-04 04:21:22");
INSERT INTO tbl_recvoucher VALUES("1715","0","REV040224103","","500.00","2024-02-04","1","2024-02-04 04:28:57");
INSERT INTO tbl_recvoucher VALUES("1716","0","REV040224104","","6550.00","2024-02-04","1","2024-02-04 10:50:32");
INSERT INTO tbl_recvoucher VALUES("1717","0","REV050224101","","3287.00","2024-02-05","1","2024-02-05 12:38:18");
INSERT INTO tbl_recvoucher VALUES("1718","0","REV050224102","","7000.00","2024-02-05","1","2024-02-05 10:14:40");
INSERT INTO tbl_recvoucher VALUES("1719","0","REV050224103","","2000.00","2024-02-05","1","2024-02-05 10:39:38");
INSERT INTO tbl_recvoucher VALUES("1720","0","REV060224101","","4433.00","2024-02-06","1","2024-02-06 03:25:12");
INSERT INTO tbl_recvoucher VALUES("1721","0","REV060224102","","10400.00","2024-02-06","1","2024-02-06 05:34:44");
INSERT INTO tbl_recvoucher VALUES("1722","0","REV060224103","","15000.00","2024-02-06","1","2024-02-06 07:12:43");
INSERT INTO tbl_recvoucher VALUES("1723","0","REV060224104","","1000.00","2024-02-06","1","2024-02-06 08:09:48");
INSERT INTO tbl_recvoucher VALUES("1724","0","REV060224105","","300.00","2024-02-06","1","2024-02-06 08:31:09");
INSERT INTO tbl_recvoucher VALUES("1725","0","REV060224106","","10000.00","2024-02-06","1","2024-02-06 08:34:11");
INSERT INTO tbl_recvoucher VALUES("1726","0","REV060224107","","18000.00","2024-02-06","1","2024-02-06 08:41:00");
INSERT INTO tbl_recvoucher VALUES("1727","0","REV070224101","","13950.00","2024-02-07","1","2024-02-07 01:44:29");
INSERT INTO tbl_recvoucher VALUES("1728","0","REV070224102","","9780.00","2024-02-07","1","2024-02-07 02:17:54");
INSERT INTO tbl_recvoucher VALUES("1729","0","REV070224103","","4000.00","2024-02-07","1","2024-02-07 06:33:06");
INSERT INTO tbl_recvoucher VALUES("1730","0","REV070224104","","10400.00","2024-02-07","1","2024-02-07 07:08:44");
INSERT INTO tbl_recvoucher VALUES("1731","0","REV070224105","","20000.00","2024-02-07","1","2024-02-07 08:40:25");
INSERT INTO tbl_recvoucher VALUES("1732","0","REV070224106","","710.00","2024-02-07","1","2024-02-07 09:17:25");
INSERT INTO tbl_recvoucher VALUES("1733","0","REV070224107","","8000.00","2024-02-07","1","2024-02-07 09:31:36");
INSERT INTO tbl_recvoucher VALUES("1734","0","REV070224108","","10000.00","2024-02-07","1","2024-02-07 09:33:10");
INSERT INTO tbl_recvoucher VALUES("1735","0","REV080224101","","10500.00","2024-02-08","1","2024-02-08 10:45:12");
INSERT INTO tbl_recvoucher VALUES("1736","0","REV090224101","","10000.00","2024-02-09","1","2024-02-09 09:19:59");
INSERT INTO tbl_recvoucher VALUES("1737","0","REV090224102","","18500.00","2024-02-09","1","2024-02-09 09:35:51");
INSERT INTO tbl_recvoucher VALUES("1738","0","REV100224101","","1360.00","2024-02-10","1","2024-02-10 05:53:35");
INSERT INTO tbl_recvoucher VALUES("1739","0","REV110224101","","4500.00","2024-02-11","1","2024-02-11 07:03:25");
INSERT INTO tbl_recvoucher VALUES("1740","0","REV110224102","","36500.00","2024-02-11","1","2024-02-11 09:49:06");
INSERT INTO tbl_recvoucher VALUES("1741","0","REV120224101","","25000.00","2024-02-12","1","2024-02-12 01:15:41");
INSERT INTO tbl_recvoucher VALUES("1742","0","REV120224102","","7000.00","2024-02-12","1","2024-02-12 06:50:49");
INSERT INTO tbl_recvoucher VALUES("1743","0","REV120224103","","5500.00","2024-02-12","1","2024-02-12 09:46:29");
INSERT INTO tbl_recvoucher VALUES("1744","0","REV130224101","","10600.00","2024-02-13","1","2024-02-13 12:39:47");
INSERT INTO tbl_recvoucher VALUES("1745","0","REV130224102","","3000.00","2024-02-13","1","2024-02-13 04:11:44");
INSERT INTO tbl_recvoucher VALUES("1746","0","REV130224103","","1240.00","2024-02-13","1","2024-02-13 09:48:24");
INSERT INTO tbl_recvoucher VALUES("1747","0","REV130224104","","51000.00","2024-02-13","1","2024-02-13 10:13:57");
INSERT INTO tbl_recvoucher VALUES("1748","0","REV140224101","","6000.00","2024-02-14","1","2024-02-14 02:41:44");
INSERT INTO tbl_recvoucher VALUES("1749","0","REV140224102","","200.00","2024-02-14","1","2024-02-14 02:47:28");
INSERT INTO tbl_recvoucher VALUES("1750","0","REV140224103","","27500.00","2024-02-14","1","2024-02-14 10:53:17");
INSERT INTO tbl_recvoucher VALUES("1751","0","REV150224101","","12900.00","2024-02-15","1","2024-02-15 11:54:42");
INSERT INTO tbl_recvoucher VALUES("1752","0","REV150224102","","17500.00","2024-02-15","1","2024-02-15 02:18:13");
INSERT INTO tbl_recvoucher VALUES("1753","0","REV150224103","","2000.00","2024-02-15","1","2024-02-15 03:12:32");
INSERT INTO tbl_recvoucher VALUES("1754","0","REV150224104","","4720.00","2024-02-15","1","2024-02-15 03:15:21");
INSERT INTO tbl_recvoucher VALUES("1755","0","REV150224105","","4000.00","2024-02-15","1","2024-02-15 07:28:18");
INSERT INTO tbl_recvoucher VALUES("1756","0","REV150224106","","40000.00","2024-01-20","1","2024-02-15 08:58:47");
INSERT INTO tbl_recvoucher VALUES("1757","0","REV150224107","","30000.00","2024-01-30","1","2024-02-15 09:13:05");
INSERT INTO tbl_recvoucher VALUES("1758","0","REV150224108","","8000.00","2024-02-15","1","2024-02-15 09:15:17");
INSERT INTO tbl_recvoucher VALUES("1759","0","REV150224109","","29500.00","2024-02-15","1","2024-02-15 09:25:08");
INSERT INTO tbl_recvoucher VALUES("1760","0","REV160224101","","4460.00","2024-02-16","1","2024-02-16 12:03:22");
INSERT INTO tbl_recvoucher VALUES("1761","0","REV160224102","","1300.00","2024-02-16","1","2024-02-16 05:02:26");
INSERT INTO tbl_recvoucher VALUES("1762","0","REV160224103","","8000.00","2024-02-16","1","2024-02-16 07:09:18");
INSERT INTO tbl_recvoucher VALUES("1763","0","REV160224104","","69000.00","2024-02-16","1","2024-02-16 07:21:45");
INSERT INTO tbl_recvoucher VALUES("1764","0","REV170224101","","2080.00","2024-02-17","1","2024-02-17 06:04:13");
INSERT INTO tbl_recvoucher VALUES("1765","0","REV170224102","","1570.00","2024-02-17","1","2024-02-17 06:40:56");
INSERT INTO tbl_recvoucher VALUES("1766","0","REV180224101","","3200.00","2024-02-18","1","2024-02-18 01:01:46");
INSERT INTO tbl_recvoucher VALUES("1767","0","REV180224102","","1750.00","2024-02-18","1","2024-02-18 04:56:28");
INSERT INTO tbl_recvoucher VALUES("1768","0","REV180224103","","21500.00","2024-02-18","1","2024-02-18 09:40:23");
INSERT INTO tbl_recvoucher VALUES("1769","0","REV180224104","","1800.00","2024-02-18","1","2024-02-18 11:21:31");
INSERT INTO tbl_recvoucher VALUES("1770","0","REV190224101","","3900.00","2024-02-19","1","2024-02-19 11:35:42");
INSERT INTO tbl_recvoucher VALUES("1771","0","REV190224102","","1000.00","2024-02-19","1","2024-02-19 03:07:19");
INSERT INTO tbl_recvoucher VALUES("1772","0","REV190224103","","40000.00","2024-02-19","1","2024-02-19 04:16:52");
INSERT INTO tbl_recvoucher VALUES("1773","0","REV190224104","","100.00","2024-02-18","1","2024-02-19 06:16:37");
INSERT INTO tbl_recvoucher VALUES("1774","0","REV190224105","","2000.00","2024-02-19","1","2024-02-19 08:59:11");
INSERT INTO tbl_recvoucher VALUES("1775","0","REV200224101","","70000.00","2024-02-20","1","2024-02-20 02:46:48");
INSERT INTO tbl_recvoucher VALUES("1776","0","REV200224102","","51500.00","2024-02-19","1","2024-02-20 05:33:06");
INSERT INTO tbl_recvoucher VALUES("1777","0","REV200224103","","7181.50","2024-02-20","1","2024-02-20 08:21:44");
INSERT INTO tbl_recvoucher VALUES("1778","0","REV210224101","","5000.00","2024-02-21","1","2024-02-21 10:44:36");
INSERT INTO tbl_recvoucher VALUES("1779","0","REV210224102","","340.00","2024-02-21","1","2024-02-21 11:42:53");
INSERT INTO tbl_recvoucher VALUES("1780","0","REV210224103","","4400.00","2024-02-21","1","2024-02-21 12:22:32");
INSERT INTO tbl_recvoucher VALUES("1781","0","REV210224104","","1177.00","2024-02-21","1","2024-02-21 05:09:57");
INSERT INTO tbl_recvoucher VALUES("1782","0","REV210224105","","9100.00","2024-02-21","1","2024-02-21 05:11:54");
INSERT INTO tbl_recvoucher VALUES("1783","0","REV210224106","","5000.00","2024-02-21","1","2024-02-21 08:12:58");
INSERT INTO tbl_recvoucher VALUES("1784","0","REV210224107","","1500.00","2024-02-21","1","2024-02-21 08:29:10");
INSERT INTO tbl_recvoucher VALUES("1785","0","REV210224108","","8500.00","2024-02-21","1","2024-02-21 08:36:23");
INSERT INTO tbl_recvoucher VALUES("1786","0","REV220224101","","850.00","2024-02-22","1","2024-02-22 01:45:50");
INSERT INTO tbl_recvoucher VALUES("1787","0","REV220224102","","3000.00","2024-02-22","1","2024-02-22 03:48:26");
INSERT INTO tbl_recvoucher VALUES("1788","0","REV220224103","","2100.00","2024-02-22","1","2024-02-22 08:12:35");
INSERT INTO tbl_recvoucher VALUES("1789","0","REV220224104","","45000.00","2024-02-22","1","2024-02-22 08:39:54");
INSERT INTO tbl_recvoucher VALUES("1790","0","REV220224105","","500.00","2024-02-22","1","2024-02-22 10:32:46");
INSERT INTO tbl_recvoucher VALUES("1791","0","REV220224106","","3200.00","2024-02-22","1","2024-02-22 10:36:07");
INSERT INTO tbl_recvoucher VALUES("1792","0","REV230224101","","400.00","2024-02-23","1","2024-02-23 07:00:03");
INSERT INTO tbl_recvoucher VALUES("1793","0","REV230224102","","6724.00","2024-02-23","1","2024-02-23 09:21:27");
INSERT INTO tbl_recvoucher VALUES("1794","0","REV230224103","","7500.00","2024-02-23","1","2024-02-23 09:56:13");
INSERT INTO tbl_recvoucher VALUES("1795","0","REV230224104","","1569.00","2024-02-23","1","2024-02-23 11:18:23");
INSERT INTO tbl_recvoucher VALUES("1796","0","REV240224101","","3550.00","2024-02-24","1","2024-02-24 01:58:38");
INSERT INTO tbl_recvoucher VALUES("1797","0","REV240224102","","28000.00","2024-02-24","1","2024-02-24 04:56:38");
INSERT INTO tbl_recvoucher VALUES("1798","0","REV240224103","","5000.00","2024-02-24","1","2024-02-24 05:22:30");
INSERT INTO tbl_recvoucher VALUES("1799","0","REV250224101","","260.00","2024-02-25","1","2024-02-25 01:09:18");
INSERT INTO tbl_recvoucher VALUES("1800","0","REV250224102","","1350.00","2024-02-25","1","2024-02-25 05:39:59");
INSERT INTO tbl_recvoucher VALUES("1801","0","REV260224101","","43600.00","2024-02-26","1","2024-02-26 07:56:09");
INSERT INTO tbl_recvoucher VALUES("1802","0","REV260224102","","7400.00","2024-02-26","1","2024-02-26 10:09:49");
INSERT INTO tbl_recvoucher VALUES("1803","0","REV260224103","","1000.00","2024-02-26","1","2024-02-26 10:18:54");
INSERT INTO tbl_recvoucher VALUES("1804","0","REV270224101","","4200.00","2024-02-27","1","2024-02-27 11:47:57");
INSERT INTO tbl_recvoucher VALUES("1805","0","REV270224102","","10200.00","2024-02-27","1","2024-02-27 02:39:27");
INSERT INTO tbl_recvoucher VALUES("1806","0","REV270224103","","1500.00","2023-03-22","1","2024-02-27 02:40:35");
INSERT INTO tbl_recvoucher VALUES("1807","0","REV270224104","","38500.00","2024-02-27","1","2024-02-27 05:09:59");
INSERT INTO tbl_recvoucher VALUES("1808","0","REV270224105","","400.00","2024-02-27","1","2024-02-27 07:04:03");
INSERT INTO tbl_recvoucher VALUES("1809","0","REV270224106","","10400.00","2024-02-27","1","2024-02-27 07:45:17");
INSERT INTO tbl_recvoucher VALUES("1810","0","REV270224107","","250.00","2024-02-27","1","2024-02-27 08:02:40");
INSERT INTO tbl_recvoucher VALUES("1811","0","REV270224108","","3000.00","2024-02-27","1","2024-02-27 08:36:05");
INSERT INTO tbl_recvoucher VALUES("1812","0","REV270224109","","5000.00","2024-02-27","1","2024-02-27 09:49:15");
INSERT INTO tbl_recvoucher VALUES("1813","0","REV280224101","","4320.00","2024-02-28","1","2024-02-28 02:28:21");
INSERT INTO tbl_recvoucher VALUES("1814","0","REV280224102","","8000.00","2024-02-28","1","2024-02-28 08:32:23");
INSERT INTO tbl_recvoucher VALUES("1815","0","REV290224101","","14400.00","2024-02-29","1","2024-02-29 05:29:19");
INSERT INTO tbl_recvoucher VALUES("1816","0","REV290224102","","22000.00","2024-02-29","1","2024-02-29 09:41:49");
INSERT INTO tbl_recvoucher VALUES("1817","0","REV010324101","","1600.00","2024-03-01","1","2024-03-01 09:12:01");
INSERT INTO tbl_recvoucher VALUES("1818","0","REV010324102","","5000.00","2024-03-01","1","2024-03-01 10:51:25");
INSERT INTO tbl_recvoucher VALUES("1819","0","REV010324103","","7786.00","2024-03-01","1","2024-03-01 10:54:59");
INSERT INTO tbl_recvoucher VALUES("1820","0","REV020324101","","3150.00","2024-03-02","1","2024-03-02 12:21:40");
INSERT INTO tbl_recvoucher VALUES("1821","0","REV020324102","","300.00","2024-03-02","1","2024-03-02 01:54:08");
INSERT INTO tbl_recvoucher VALUES("1822","0","REV020324103","","2020.00","2024-03-02","1","2024-03-02 02:57:54");
INSERT INTO tbl_recvoucher VALUES("1823","0","REV020324104","","4800.00","2024-03-02","1","2024-03-02 07:55:56");
INSERT INTO tbl_recvoucher VALUES("1824","0","REV020324105","","3000.00","2024-03-02","1","2024-03-02 08:33:10");
INSERT INTO tbl_recvoucher VALUES("1825","0","REV020324106","","1200.00","2024-03-02","1","2024-03-02 08:54:38");
INSERT INTO tbl_recvoucher VALUES("1826","0","REV030324101","","3470.00","2024-03-03","1","2024-03-03 10:58:00");
INSERT INTO tbl_recvoucher VALUES("1827","0","REV030324102","","530.00","2024-03-03","1","2024-03-03 11:03:15");
INSERT INTO tbl_recvoucher VALUES("1828","0","REV030324103","","13500.00","2024-03-03","1","2024-03-03 04:26:00");
INSERT INTO tbl_recvoucher VALUES("1829","0","REV030324104","","1300.00","2024-03-03","1","2024-03-03 05:15:37");
INSERT INTO tbl_recvoucher VALUES("1830","0","REV030324105","","250.00","2024-03-03","1","2024-03-03 08:30:00");
INSERT INTO tbl_recvoucher VALUES("1831","0","REV040324101","","1350.00","2024-03-04","1","2024-03-04 01:32:16");
INSERT INTO tbl_recvoucher VALUES("1832","0","REV040324102","","1000.00","2024-03-04","1","2024-03-04 04:58:21");
INSERT INTO tbl_recvoucher VALUES("1833","0","REV040324103","","700.00","2024-03-04","1","2024-03-04 10:34:43");
INSERT INTO tbl_recvoucher VALUES("1834","0","REV050324101","","1056.00","2024-03-05","1","2024-03-05 03:58:42");
INSERT INTO tbl_recvoucher VALUES("1835","0","REV050324102","","1000.00","2024-03-05","1","2024-03-05 08:07:29");
INSERT INTO tbl_recvoucher VALUES("1836","0","REV060324101","","360.00","2024-03-06","1","2024-03-06 03:50:04");
INSERT INTO tbl_recvoucher VALUES("1837","0","REV060324102","","3240.00","2024-03-06","1","2024-03-06 07:47:48");
INSERT INTO tbl_recvoucher VALUES("1838","0","REV060324103","","1810.00","2024-03-06","1","2024-03-06 07:50:07");
INSERT INTO tbl_recvoucher VALUES("1839","0","REV060324104","","3000.00","2024-03-06","1","2024-03-06 09:26:43");
INSERT INTO tbl_recvoucher VALUES("1840","0","REV060324105","","3850.00","2024-03-06","1","2024-03-06 10:06:20");
INSERT INTO tbl_recvoucher VALUES("1841","0","REV070324101","","1350.00","2024-03-07","1","2024-03-07 04:01:15");
INSERT INTO tbl_recvoucher VALUES("1842","0","REV070324102","","2665.00","2024-03-07","1","2024-03-07 07:22:07");
INSERT INTO tbl_recvoucher VALUES("1843","0","REV070324103","","5000.00","2024-03-07","1","2024-03-07 09:39:03");
INSERT INTO tbl_recvoucher VALUES("1844","0","REV070324104","","24000.00","2024-03-07","1","2024-03-07 09:40:46");
INSERT INTO tbl_recvoucher VALUES("1845","0","REV080324101","","4500.00","2024-03-08","1","2024-03-08 12:04:41");
INSERT INTO tbl_recvoucher VALUES("1846","0","REV080324102","","5000.00","2024-03-08","1","2024-03-08 09:16:43");
INSERT INTO tbl_recvoucher VALUES("1847","0","REV090324101","","10116.00","2024-03-09","1","2024-03-09 04:02:41");
INSERT INTO tbl_recvoucher VALUES("1848","0","REV090324102","","4400.00","2024-03-09","1","2024-03-09 09:12:58");
INSERT INTO tbl_recvoucher VALUES("1849","0","REV100324101","","280.00","2024-03-10","1","2024-03-10 11:22:54");
INSERT INTO tbl_recvoucher VALUES("1850","0","REV100324102","","3200.00","2024-03-10","1","2024-03-10 09:01:48");
INSERT INTO tbl_recvoucher VALUES("1851","0","REV110324101","","5000.00","2024-03-11","1","2024-03-11 12:06:39");
INSERT INTO tbl_recvoucher VALUES("1852","0","REV110324102","","510.00","2024-03-11","1","2024-03-11 03:04:01");
INSERT INTO tbl_recvoucher VALUES("1853","0","REV120324101","","6800.00","2024-03-12","1","2024-03-12 08:53:13");
INSERT INTO tbl_recvoucher VALUES("1854","0","REV120324102","","2900.00","2024-03-12","1","2024-03-12 10:21:30");
INSERT INTO tbl_recvoucher VALUES("1855","0","REV130324101","","15000.00","2024-03-13","1","2024-03-13 02:33:42");
INSERT INTO tbl_recvoucher VALUES("1856","0","REV130324102","","10000.00","2024-03-13","1","2024-03-13 07:41:32");
INSERT INTO tbl_recvoucher VALUES("1857","0","REV150324101","","3010.00","2024-03-15","1","2024-03-15 10:47:18");
INSERT INTO tbl_recvoucher VALUES("1858","0","REV150324102","","1500.00","2024-03-15","1","2024-03-15 11:55:36");
INSERT INTO tbl_recvoucher VALUES("1859","0","REV150324103","","30000.00","2024-03-15","1","2024-03-15 05:15:04");
INSERT INTO tbl_recvoucher VALUES("1860","0","REV160324101","","10750.00","2024-03-16","1","2024-03-16 05:49:41");
INSERT INTO tbl_recvoucher VALUES("1861","0","REV180324101","","740.00","2024-03-18","1","2024-03-18 07:25:53");
INSERT INTO tbl_recvoucher VALUES("1862","0","REV190324101","","5000.00","2024-03-19","1","2024-03-19 12:04:33");
INSERT INTO tbl_recvoucher VALUES("1863","0","REV190324102","","1300.00","2024-03-19","1","2024-03-19 12:32:36");
INSERT INTO tbl_recvoucher VALUES("1864","0","REV200324101","","3500.00","2024-03-20","1","2024-03-20 03:50:44");
INSERT INTO tbl_recvoucher VALUES("1865","0","REV200324102","","3000.00","2024-03-20","1","2024-03-20 09:05:49");
INSERT INTO tbl_recvoucher VALUES("1866","0","REV200324103","","630.00","2024-03-20","1","2024-03-20 09:08:05");
INSERT INTO tbl_recvoucher VALUES("1867","0","REV200324104","","2200.00","2024-03-20","1","2024-03-20 09:26:13");
INSERT INTO tbl_recvoucher VALUES("1868","0","REV200324105","","4050.00","2024-03-20","1","2024-03-20 09:39:22");
INSERT INTO tbl_recvoucher VALUES("1869","0","REV200324106","","1000.00","2024-03-20","1","2024-03-20 10:51:18");
INSERT INTO tbl_recvoucher VALUES("1870","0","REV210324101","","2500.00","2024-03-21","1","2024-03-21 12:57:40");
INSERT INTO tbl_recvoucher VALUES("1871","0","REV210324102","","1000.00","2024-03-21","1","2024-03-21 03:01:30");
INSERT INTO tbl_recvoucher VALUES("1873","0","REV210324104","","2100.00","2024-03-21","1","2024-03-21 09:59:56");
INSERT INTO tbl_recvoucher VALUES("1874","0","REV220324101","","559.98","2024-03-22","1","2024-03-22 03:29:42");
INSERT INTO tbl_recvoucher VALUES("1875","0","REV220324102","","3000.00","2024-03-22","1","2024-03-22 04:35:27");
INSERT INTO tbl_recvoucher VALUES("1876","0","REV220324103","","1260.00","2024-03-22","1","2024-03-22 10:50:33");
INSERT INTO tbl_recvoucher VALUES("1877","0","REV230324101","","1800.00","2024-03-23","1","2024-03-23 02:58:25");
INSERT INTO tbl_recvoucher VALUES("1878","0","REV230324102","","4280.00","2024-03-23","1","2024-03-23 08:16:04");
INSERT INTO tbl_recvoucher VALUES("1879","0","REV230324103","","600.00","2024-03-23","1","2024-03-23 08:23:53");
INSERT INTO tbl_recvoucher VALUES("1880","0","REV240324101","","60.00","2024-03-24","1","2024-03-24 11:12:39");
INSERT INTO tbl_recvoucher VALUES("1881","0","REV240324102","","3000.00","2024-03-24","1","2024-03-24 12:01:30");
INSERT INTO tbl_recvoucher VALUES("1882","0","REV240324103","","1000.00","2024-03-24","1","2024-03-24 12:23:04");
INSERT INTO tbl_recvoucher VALUES("1883","0","REV250324101","","6400.00","2024-03-25","1","2024-03-25 11:16:58");
INSERT INTO tbl_recvoucher VALUES("1884","0","REV250324102","","860.00","2024-03-25","1","2024-03-25 01:36:30");
INSERT INTO tbl_recvoucher VALUES("1885","0","REV250324103","","5000.00","2024-03-25","1","2024-03-25 07:52:49");
INSERT INTO tbl_recvoucher VALUES("1886","0","REV250324104","","3000.00","2024-03-25","1","2024-03-25 08:43:50");
INSERT INTO tbl_recvoucher VALUES("1887","0","REV250324105","","2606.00","2024-03-25","1","2024-03-25 09:58:07");
INSERT INTO tbl_recvoucher VALUES("1888","0","REV260324101","","2550.00","2024-03-26","1","2024-03-26 08:07:28");
INSERT INTO tbl_recvoucher VALUES("1889","0","REV260324102","","7500.00","2024-03-26","1","2024-03-26 10:19:38");
INSERT INTO tbl_recvoucher VALUES("1890","0","REV270324101","","3240.00","2024-03-27","1","2024-03-27 02:42:49");
INSERT INTO tbl_recvoucher VALUES("1891","0","REV270324102","","4000.00","2024-03-22","1","2024-03-27 07:57:49");
INSERT INTO tbl_recvoucher VALUES("1892","0","REV280324101","","950.00","2024-03-28","1","2024-03-28 04:42:54");
INSERT INTO tbl_recvoucher VALUES("1893","0","REV290324101","","9200.00","2024-03-29","1","2024-03-29 04:47:29");
INSERT INTO tbl_recvoucher VALUES("1894","0","REV290324102","","12002.75","2024-03-29","1","2024-03-29 05:38:45");
INSERT INTO tbl_recvoucher VALUES("1895","0","REV290324103","","1700.00","2024-03-29","1","2024-03-29 08:25:07");
INSERT INTO tbl_recvoucher VALUES("1896","0","REV290324104","","2000.00","2024-03-29","1","2024-03-29 09:43:09");
INSERT INTO tbl_recvoucher VALUES("1897","0","REV300324101","","360.00","2024-03-30","1","2024-03-30 03:00:24");
INSERT INTO tbl_recvoucher VALUES("1898","0","REV300324102","","2450.00","2024-03-30","1","2024-03-30 04:31:20");
INSERT INTO tbl_recvoucher VALUES("1899","0","REV310324101","","12500.00","2024-03-31","1","2024-03-31 07:22:35");
INSERT INTO tbl_recvoucher VALUES("1900","0","REV310324102","","500.00","2024-03-31","1","2024-03-31 08:54:33");
INSERT INTO tbl_recvoucher VALUES("1901","0","REV310324103","","7500.00","2024-03-31","1","2024-03-31 08:56:43");
INSERT INTO tbl_recvoucher VALUES("1902","0","REV310324104","","1100.00","2024-03-31","1","2024-03-31 11:35:55");
INSERT INTO tbl_recvoucher VALUES("1903","0","REV010424101","","4800.00","2024-04-01","1","2024-04-01 11:23:09");
INSERT INTO tbl_recvoucher VALUES("1904","0","REV010424102","","9570.00","2024-04-01","1","2024-04-01 11:39:03");
INSERT INTO tbl_recvoucher VALUES("1905","0","REV010424103","","1500.00","2024-04-01","1","2024-04-01 05:55:01");
INSERT INTO tbl_recvoucher VALUES("1906","0","REV010424104","","15000.00","2024-04-01","1","2024-04-01 09:27:07");
INSERT INTO tbl_recvoucher VALUES("1907","0","REV020424101","","30.00","2024-04-02","1","2024-04-02 03:31:40");
INSERT INTO tbl_recvoucher VALUES("1908","0","REV020424102","","15000.00","2024-04-02","1","2024-04-02 09:33:27");
INSERT INTO tbl_recvoucher VALUES("1909","0","REV030424101","","1650.00","2024-04-03","1","2024-04-03 05:31:51");
INSERT INTO tbl_recvoucher VALUES("1910","0","REV030424102","","2500.00","2024-04-03","1","2024-04-03 05:39:00");
INSERT INTO tbl_recvoucher VALUES("1911","0","REV040424101","","5200.00","2024-04-04","1","2024-04-04 05:58:16");
INSERT INTO tbl_recvoucher VALUES("1912","0","REV040424102","","300.00","2024-03-23","1","2024-04-04 06:06:19");
INSERT INTO tbl_recvoucher VALUES("1913","0","REV050424101","","1800.00","2024-04-05","1","2024-04-05 03:26:05");
INSERT INTO tbl_recvoucher VALUES("1914","0","REV050424102","","500.00","2024-