<?php
include ('../inc/dbcon.php');
include ('../inc/functions.php');

// --- Helper function for query ---
function getRow($query, $con) {
    $result = $con->query($query);
    return $result ? $result->fetch_assoc() : ['total' => 0, 'cash' => 0];
}

// --- Today’s date ---
$today = date('Y-m-d');

// --- SALES CALCULATIONS ---
$totalSales     = getRow("SELECT SUM(total) AS total, SUM(rawcash) AS cash FROM tbl_sales", $con);
$todaySales     = getRow("SELECT SUM(total) AS total, SUM(rawcash) AS cash FROM tbl_sales WHERE DATE(apdate) = '$today'", $con);

// --- PURCHASE CALCULATIONS ---
$totalPurchase  = getRow("SELECT SUM(total) AS total, SUM(rawcash) AS cash FROM tbl_purchase", $con);
$todayPurchase  = getRow("SELECT SUM(total) AS total, SUM(rawcash) AS cash FROM tbl_purchase WHERE DATE(apdate) = '$today'", $con);

// --- Calculate dues ---
$totalSalesDue      = $totalSales['total'] - $totalSales['cash'];
$todaySalesDue      = $todaySales['total'] - $todaySales['cash'];
$totalPurchaseDue   = $totalPurchase['total'] - $totalPurchase['cash'];
$todayPurchaseDue   = $todayPurchase['total'] - $todayPurchase['cash'];

// --- Output JSON ---
echo json_encode([
    "today_sales_purchase" => [
        "keys" => [
            ["color" => "#a7af88", "value" => "Today Purchase"],
            ["color" => "#0d8a3d", "value" => "Today Sales"]
        ],
        "data" => [
            [
                "value" => $todayPurchase['total'],
                "color" => "#a7af88",
                "label" => "Purchase",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ],
            [
                "value" => $todaySales['total'],
                "color" => "#0d8a3d",
                "label" => "Sales",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ],
        ],
    ],
    "sales_purchase" => [
        "keys" => [
            ["color" => "#e0cd85", "value" => "Total Purchase"],
            ["color" => "#d1770c", "value" => "Total Sales"],
        ],
        "data" => [
            [
                "value" => $totalPurchase['total'],
                "color" => "#e0cd85",
                "label" => "Purchase",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ],
            [
                "value" => $totalSales['total'],
                "color" => "#d1770c",
                "label" => "Sales",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ]
        ],
    ],
    "sales_cash_due" => [
        "keys" => [
            ["color" => "#e0cd85", "value" => "Total Cash Sales"],
            ["color" => "#d1770c", "value" => "Total Due Sales"],
        ],
        "data" => [
            [
                "value" => $totalSales['cash'],
                "color" => "#e0cd85",
                "label" => "Cash",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ],
            [
                "value" => $totalSalesDue,
                "color" => "#d1770c",
                "label" => "Due",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ]
        ],
    ],
    "purchase_cash_due" => [
        "keys" => [
            ["color" => "#41e3fa", "value" => "Total Cash Purchase"],
            ["color" => "#d1770c", "value" => "Total Due Purchase"],
        ],
        "data" => [
            [
                "value" => $totalPurchase['cash'],
                "color" => "#41e3fa",
                "label" => "Cash Purchase",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ],
            [
                "value" => $totalPurchaseDue,
                "color" => "#d1770c",
                "label" => "Due Purchase",
                "labelColor" => "white",
                "labelFontSize" => "5",
            ]
        ],
    ],
], JSON_PRETTY_PRINT);
?>
