<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">

        
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1"><?php echo e($data['title']); ?></h1>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(___('common.home')); ?></a></li>
                        <li class="breadcrumb-item"><?php echo e($data['title']); ?></li>
                    </ol>
                </div>
            </div>
        </div>
        


        <div class="col-12">
            <form action="<?php echo e(route('issue-book.search')); ?>" method="post" id="marksheed" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card ot-card mb-24 position-relative z_1">
                    <div class="card-header d-flex align-items-center gap-4 flex-wrap">
                        <h3 class="mb-0"><?php echo e(___('common.Filtering')); ?></h3>
                        
                        <div class="card_header_right d-flex align-items-center gap-3 flex-fill justify-content-end flex-wrap">
                        
                            <div class="single_large_selectBox">
                                <input class="form-control ot-input"
                                    name="keyword" list="datalistOptions" id="exampleDataList"
                                    placeholder="<?php echo e(___('student_info.Enter keyword')); ?>"
                                    value="<?php echo e(@$data['request']->keyword); ?>">
                            </div>

                            <button class="btn btn-lg ot-btn-primary" type="submit">
                                <?php echo e(___('common.Search')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>


        <!--  table content start -->
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="mb-0"><?php echo e($data['title']); ?></h4>
                    <?php if(hasPermission('issue_book_create')): ?>
                        <a href="<?php echo e(route('issue-book.create')); ?>" class="btn btn-lg ot-btn-primary">
                            <span><i class="fa-solid fa-plus"></i> </span>
                            <span class=""><?php echo e(___('common.add')); ?></span>
                        </a>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered class-table">
                            <thead class="thead">
                                <tr>
                                    <th class="serial"><?php echo e(___('common.sr_no')); ?></th>
                                    <th class="purchase"><?php echo e(___('library.Book')); ?></th>
                                    <th class="purchase"><?php echo e(___('library.Member')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.Phone')); ?></th>
                                    <th class="purchase"><?php echo e(___('library.Issue Date')); ?></th>
                                    <th class="purchase"><?php echo e(___('library.Return Date')); ?></th>
                                    <th class="purchase"><?php echo e(___('common.status')); ?></th>
                                    <?php if(hasPermission('issue_book_update') || hasPermission('issue_book_delete')): ?>
                                        <th class="action"><?php echo e(___('common.action')); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody class="tbody">
                                <?php $__empty_1 = true; $__currentLoopData = $data['issue_book']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr id="row_<?php echo e($row->id); ?>">
                                    <td class="serial"><?php echo e(++$key); ?></td>
                                    <td><?php echo e(@$row->book->name); ?></td>
                                    <td><?php echo e(@$row->user->name); ?></td>
                                    <td><?php echo e(@$row->phone); ?></td>
                                    <td><?php echo e(dateFormat(@$row->issue_date)); ?></td>
                                    <td><?php echo e(dateFormat(@$row->return_date)); ?></td>
                                    <td>
                                        <?php if($row->status == App\Enums\Status::ACTIVE): ?>
                                            <span class="badge-basic-success-text"><?php echo e(___('library.return')); ?></span>
                                        <?php else: ?>
                                            <span class="badge-basic-danger-text"><?php echo e(___('library.issued')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <?php if((hasPermission('issue_book_update') || hasPermission('issue_book_delete')) || @$row->status == App\Enums\IssueBook::ISSUED): ?>
                                        <td class="action">
                                            <div class="dropdown dropdown-action">
                                                <button type="button" class="btn-dropdown" data-bs-toggle="dropdown"
                                                    aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-end ">
                                                    <?php if(@$row->status == App\Enums\IssueBook::ISSUED): ?>
                                                        <li>
                                                            <a class="dropdown-item" href="#" onclick="showConfirmation('<?php echo e(route('issue-book.return', $row->id)); ?>')">
                                                                <span class="icon mr-8"> <i class="fa-solid fa fa-mail-reply"></i></span>
                                                                <?php echo e(___('library.return')); ?>

                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('issue_book_update')): ?>
                                                        <li>
                                                            <a class="dropdown-item"
                                                                href="<?php echo e(route('issue-book.edit', $row->id)); ?>"><span
                                                                    class="icon mr-8"><i
                                                                        class="fa-solid fa-pen-to-square"></i></span>
                                                                <?php echo e(___('common.edit')); ?></a>
                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(hasPermission('issue_book_delete')): ?>
                                                        <li>
                                                            <a class="dropdown-item" href="javascript:void(0);"
                                                                onclick="delete_row('issue-book/delete', <?php echo e($row->id); ?>)">
                                                                <span class="icon mr-8"><i
                                                                        class="fa-solid fa-trash-can"></i></span>
                                                                <span><?php echo e(___('common.delete')); ?></span>
                                                            </a>
                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center gray-color">
                                        <img src="<?php echo e(asset('images/no_data.svg')); ?>" alt="" class="mb-primary" width="100">
                                        <p class="mb-0 text-center"><?php echo e(___('common.No data available')); ?></p>
                                        <p class="mb-0 text-center text-secondary font-size-90">
                                            <?php echo e(___('common.Please add new entity regarding this table')); ?></p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <!--  table end -->
                    <!--  pagination start -->

                        <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                            <nav aria-label="Page navigation example">
                                <ul class="pagination justify-content-between">
                                    <?php echo $data['issue_book']->appends(\Request::capture()->except('page'))->links(); ?>

                                </ul>
                            </nav>
                        </div>

                    <!--  pagination end -->
                </div>
            </div>
        </div>
        <!--  table content end -->

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php echo $__env->make('backend.partials.delete-ajax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/axesba/public_html/demoschool/resources/views/backend/library/issue-book/index.blade.php ENDPATH**/ ?>