<?php $__env->startSection('title'); ?>
    <?php echo e(@$data['title']); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-content">
        <!-- profile content start -->
        <div class="profile-content">
            <div class="d-flex flex-column flex-lg-row gap-4 gap-lg-0">

                <div class="profile-menu">
                    <!-- profile menu head start -->
                    <div class="profile-menu-head">
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <img class="img-fluid rounded-circle" src="<?php echo e(@globalAsset(@$data->upload->path)); ?>"
                                    alt="<?php echo e(@$data->name); ?>">
                            </div>
                            <div class="flex-grow-1">
                                <div class="body">
                                    <h2 class="title"><?php echo e(@$data->first_name); ?> <?php echo e(@$data->last_name); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->role->name); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- profile menu head end -->

                    <!-- profile menu body start -->
                    <div class="profile-menu-body">
                        <nav>
                            <ul class="nav flex-column">
                                <li class="nav-item">
                                    <a class="nav-link active" aria-current="page"
                                        href="#"><?php echo e(___('common.Profile')); ?></a>
                                </li>
                            </ul>
                        </nav>
                    </div>
                    <!-- profile menu body end -->
                </div>

                <!-- profile menu end -->

                <div class="profile-body">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h2 class="title"><?php echo e(___('common.Staff Details')); ?></h2>
                        <a href="<?php echo e(route('users.edit',@$data->id)); ?>" class="btn btn-lg ot-btn-primary mb-5">
                            <span class="icon"><i class="fa-solid fa-pen-to-square"></i></span>
                            <span class=""><?php echo e(___('common.edit')); ?></span>
                        </a>
                    </div>

                    <!-- profile body form start -->
                    <div class="profile-body-form">
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.staff_id')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->staff_id); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('common.roles')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->role->name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.select_designation')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->designation->name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.departments')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->department->name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.first_name')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->first_name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.last_name')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->last_name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.father_name')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->father_name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.mother_name')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->mother_name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('common.email')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->email); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.genders')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->gender->name); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.date_of_birth')); ?></h2>
                                    <p class="paragraph"><?php echo e(dateFormat(@$data->dob)); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.joining_date')); ?></h2>
                                    <p class="paragraph"><?php echo e(dateFormat(@$data->joining_date)); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.phone')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->phone); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.emergency_contact')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->emergency_contact); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.marital_status')); ?></h2>
                                    <p class="paragraph">
                                        <?php if(@$data->marital_status == App\Enums\MaritalStatus::MARRIED): ?>
                                            <?php echo e(___('staff.married')); ?>

                                        <?php else: ?>
                                            <?php echo e(___('staff.unmarried')); ?>

                                        <?php endif; ?>  
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('common.status')); ?></h2>
                                    <p class="paragraph">
                                        <?php if(@$data->status == App\Enums\Status::ACTIVE): ?>
                                            <?php echo e(___('common.active')); ?>

                                        <?php else: ?>
                                            <?php echo e(___('common.inactive')); ?>

                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.current_address')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->current_address); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.permanent_address')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->permanent_address); ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="form-item">
                            <div class="d-flex justify-content-between align-content-center">
                                <div class="align-self-center">
                                    <h2 class="title"><?php echo e(___('staff.basic_salary')); ?></h2>
                                    <p class="paragraph"><?php echo e(@$data->basic_salary); ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <h3><?php echo e(___('staff.Documents')); ?></h3>
                        <?php if(@$data->upload_documents): ?>
                            <?php $__currentLoopData = @$data->upload_documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-item">
                                    <div class="d-flex justify-content-between align-content-center">
                                        <div class="align-self-center">
                                            <h2 class="title"><?php echo e($item['title']); ?></h2>
                                            <p class="paragraph"><a href="<?php echo e(@globalAsset($item['file']->upload->path)); ?>" download>Download</a></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </div>
                </div>
                <!-- profile body form end -->
            </div>
            <!-- profile body end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/axesba/public_html/protiva/resources/views/backend/users/show.blade.php ENDPATH**/ ?>