<?php

use App\Http\Controllers\Staff\DepartmentController;
use App\Http\Controllers\Staff\DesignationController;
use Illuminate\Support\Facades\Route;

Route::group(['middleware' => ['XssSanitizer']], function () {

    Route::group(['middleware' => 'lang'], function () {

        // auth routes
        Route::group(['middleware' => ['auth.routes', 'AdminPanel']], function () {
            
            Route::controller(DepartmentController::class)->prefix('department')->group(function () {
                Route::get('/',                 'index')->name('department.index')->middleware('PermissionCheck:department_read');
                Route::get('/create',           'create')->name('department.create')->middleware('PermissionCheck:department_create');
                Route::post('/store',           'store')->name('department.store')->middleware('PermissionCheck:department_create', 'DemoCheck');
                Route::get('/edit/{id}',        'edit')->name('department.edit')->middleware('PermissionCheck:department_update');
                Route::put('/update/{id}',      'update')->name('department.update')->middleware('PermissionCheck:department_update', 'DemoCheck');
                Route::delete('/delete/{id}',   'delete')->name('department.delete')->middleware('PermissionCheck:department_delete', 'DemoCheck');
            });
            
            Route::controller(DesignationController::class)->prefix('designation')->group(function () {
                Route::get('/',                 'index')->name('designation.index')->middleware('PermissionCheck:designation_read');
                Route::get('/create',           'create')->name('designation.create')->middleware('PermissionCheck:designation_create');
                Route::post('/store',           'store')->name('designation.store')->middleware('PermissionCheck:designation_create', 'DemoCheck');
                Route::get('/edit/{id}',        'edit')->name('designation.edit')->middleware('PermissionCheck:designation_update');
                Route::put('/update/{id}',      'update')->name('designation.update')->middleware('PermissionCheck:designation_update', 'DemoCheck');
                Route::delete('/delete/{id}',   'delete')->name('designation.delete')->middleware('PermissionCheck:designation_delete', 'DemoCheck');
            });
        });
    });
});