@extends('backend.master')

@section('title')
    {{ @$data['title'] }}
@endsection

@section('content')
    <div class="page-content">

        {{-- bradecrumb Area S t a r t --}}
        <div class="page-header">
            <div class="row">
                <div class="col-sm-6">
                    <h4 class="bradecrumb-title mb-1">{{ $data['title'] }}</h1>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ ___('common.home') }}</a></li>
                        <li class="breadcrumb-item">{{ $data['title'] }}</li>
                    </ol>
                </div>
            </div>
        </div>
        {{-- bradecrumb Area E n d --}}

        <div class="card ot-card">
            <div class="card-header">
                <h4>{{ ___('settings.sms_settings') }}</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('settings.sms-setting') }}" enctype="multipart/form-data" method="post"
                    id="visitForm">
                    @csrf
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="row">
                                <div class="row mb-3">
                                    {{-- sms status start --}}
                                    <div class="col-12 col-md-6 col-xl-6 col-lg-6 mb-3">
                                        <label for="inputname" class="form-label">{{ ___('settings.sms_status') }} <span
                                                class="fillable">*</span></label>
                                       <select name="sms_status" id="sms_status"
                                            class="@error('sms_status') is-invalid @enderror niceSelect bordered_style wide">
                                            <option value="">Select</option>
                                            <option value="1" {{ setting('sms_status') == 1 ? 'selected' : '' }}>Active</option>
                                            <option value="0" {{ setting('sms_status') == 0 ? 'selected' : '' }}>Inactive</option>
                                        </select>
                                    </div>
                                    {{-- sms status start --}}

                                    {{-- sms language start --}}
                                   <div class="col-12 col-md-6 col-xl-6 col-lg-6 mb-3">
                                        <label for="inputname" class="form-label">{{ ___('settings.sms_language') }} <span
                                                class="fillable">*</span></label>
                                       <select name="sms_language" id="sms_language"
                                            class="@error('sms_language') is-invalid @enderror niceSelect bordered_style wide">
                                            <option value="">Select</option>
                                            <option value="1" {{ setting('sms_language') == 1 ? 'selected' : '' }}>EN</option>
                                            <option value="0" {{ setting('sms_language') == 0 ? 'selected' : '' }}>BN</option>
                                        </select>
                                    </div>
                                    {{-- sms language start --}}

                                    {{-- sms api key start --}}
                                    <div class="col-12 col-md-6 col-xl-6 col-lg-6 mb-3">
                                        <label for="inputname" class="form-label">{{ ___('settings.sms_api_key') }} <span
                                                class="fillable">*</span></label>
                                        <input type="text" name="sms_api_key"
                                            class="form-control ot-input @error('sms_api_key') is-invalid @enderror"
                                            value="{{ Setting('sms_api_key') }}" placeholder="{{ ___('settings.sms_api_key') }}">
                                        @error('sms_api_key')
                                            <div id="validationServer04Feedback" class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    {{-- sms api key start --}}

                                    {{-- sms sender id start --}}
                                    <div class="col-12 col-md-6 col-xl-6 col-lg-6 mb-3">
                                        <label for="inputname" class="form-label">{{ ___('settings.sms_sender_id') }} <span
                                                class="fillable">*</span></label>
                                        <input type="text" name="sms_sender_id"
                                            class="form-control ot-input @error('sms_sender_id') is-invalid @enderror"
                                            value="{{ Setting('sms_sender_id') }}" placeholder="{{ ___('settings.sms_sender_id') }}">
                                        @error('sms_sender_id')
                                            <div id="validationServer04Feedback" class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    {{-- sms sender id start --}}
                                    {{-- sms type start --}}
                                   <div class="col-12 col-md-6 col-xl-6 col-lg-6 mb-3">
                                        <label for="inputname" class="form-label">{{ ___('settings.sms_type') }} <span
                                                class="fillable">*</span></label>
                                       <select name="sms_type" id="sms_type"
                                            class="@error('sms_type') is-invalid @enderror niceSelect bordered_style wide">
                                            <option value="">Select</option>
                                            <option value="text" {{ setting('sms_type') == 'text' ? 'selected' : '' }}>Text</option>
                                            <option value="unicode" {{ setting('sms_type') == 'unicode' ? 'selected' : '' }}>Unicode</option>
                                        </select>
                                    </div>
                                    {{-- sms type start --}}

                                    <!-- SMS url start -->
                                    <div class="col-12 col-md-6 col-xl-6 col-lg-6 mb-3">
                                        <label for="exampleInputPassword1"
                                            class="form-label ">{{ ___('settings.sms_url') }} <span
                                                class="fillable"></span></label> <input type="text"
                                            name="sms_url" value="{{ Setting('sms_url') }}"
                                            class="form-control ot-input @error('sms_url') is-invalid @enderror"
                                            id="exampleInputmail_password1"
                                            placeholder="{{ ___('settings.sms_url') }}" >
                                        @error('mail_password')
                                            <div id="validationServer04Feedback" class="invalid-feedback">
                                                {{ $message }}
                                            </div>
                                        @enderror
                                    </div>
                                    <!-- SMS url end -->
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 mt-3">
                            <div class="text-end">
                                @if (hasPermission('storage_settings_update'))
                                    <button class="btn btn-lg ot-btn-primary">
                                        <span>
                                            <i class="fa-solid fa-save"></i>
                                        </span>{{ ___('common.update') }}
                                    </button>
                                @endif
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
