
<?php $__env->startSection('title', __('Check Warranty')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Warranty
        <small>Manage all Warranty List</small>
    </h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">

	<div class="box">
        <div class="box-header">
        	<h3 class="box-title">Warranty List</h3>

        <form class="example" action="/search" method="post">
        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
       <input type="text" placeholder="Search.." name="search">
      <button type="submit"><i class="fa fa-search"></i></button>
        </form>
            <?php if(auth()->user()->can('warranty_check.create')): ?>
        	<div class="box-tools">
                <button type="button" class="btn btn-block btn-primary btn-modal" 
                	data-href="<?php echo e(action('WarrantyCheckController@create')); ?>" 
                	data-container=".warranty_check_modal">
                	<i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson( 'messages.add' )); ?></button>
            </div>
        
         
        </div>
        <div class="box-body">
        <?php if(auth()->user()->can('warranty_check.view')): ?>
            <div class="table-responsive">
            <?php endif; ?>
            <?php if(session()->has('success')): ?>
           <p class="alert alert-success" style="width:400px; height:25px; padding:0px;">
           <?php echo e(session()->get('success')); ?>

           </p>
             <?php endif; ?>
        	<table class="table table-bordered table-striped" id="warranty_check_table">
        		<thead>
        			<tr>
        				<th>Invoice ID</th>
        				<th>Warranty Issued Date</th>
                        <th>Duration(Year/s)</th>
                        <th>Expired Date</th>
                        <th>Actions</th>
        			</tr>
        		</thead>
                <tbody>
                    
                    	<?php $__currentLoopData = $warrants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $warrant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <tr>
                           <td><?php echo e($warrant->invoice_id); ?></td>
                           <td><?php echo e($warrant->warranty_issued_date); ?></td>
                           
                           <td><?php echo e($warrant->duration); ?></td> 
                           <td><?php echo e($warrant->expired_date); ?></td>
                          
                          <td>
                          <a href="<?php echo e(URL::to('edit_warranty/'.$warrant->id)); ?>"><button class="btn btn-outline-warning">Edit</button></a>
                            
                            <a onclick="return confirm('Delete this record?')"
                            href="<?php echo e(URL::to('delete_warranty/'.$warrant->id)); ?>"><button class="btn btn-outline-danger">Delete</button></a>
                            
                          </td>
                      </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        	</table>
            </div>
            <?php echo $warrants ->render(); ?>

           <?php endif; ?>
        </div>
    </div>

    <div class="modal fade warranty_check_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>