
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `band_payment_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `band_payment_history` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `band_id` int(10) NOT NULL,
  `paid_amount` double NOT NULL,
  `date` date NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `update_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_payment_history` WRITE;
/*!40000 ALTER TABLE `band_payment_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_payment_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `cash_register_id` int(11) NOT NULL,
  `u_id` int(10) unsigned NOT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_transactions` WRITE;
/*!40000 ALTER TABLE `bank_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_id` int(10) unsigned NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_users` WRITE;
/*!40000 ALTER TABLE `bank_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banking_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banking_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banking_categories` WRITE;
/*!40000 ALTER TABLE `banking_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `banking_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') COLLATE utf8mb4_unicode_ci NOT NULL,
  `booking_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_amount` double NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,9,'jio',NULL,0,36,NULL,'2020-11-24 17:09:16','2020-11-24 17:09:16'),(2,9,'Tahoor',NULL,0,36,NULL,'2020-11-24 18:09:39','2020-11-24 18:09:39'),(3,9,'Rangamati Naksha Furniture',NULL,0,36,NULL,'2021-05-21 19:09:56','2021-05-21 19:09:56'),(4,9,'Bord',NULL,0,36,NULL,'2021-08-18 14:14:16','2021-08-18 14:14:16'),(5,9,'Farmer\'s G','FG',0,36,NULL,'2021-08-19 04:54:41','2021-08-19 04:54:41'),(6,9,'Akash DTH','Badic STB',0,36,NULL,'2021-08-20 18:04:13','2021-08-20 18:04:13');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_1` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number_2` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label_2` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'includes',
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sku_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pos_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `woocommerce_api_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'before',
  `enabled_modules` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_format` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '24',
  `ref_no_prefixes` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme_color` char(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `email_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sms_settings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Master Pos',134,'2018-01-01',NULL,'Tin',NULL,NULL,NULL,0.00,1,'America/Phoenix',1,'fifo',0.00,'includes','/lL1n0sMQC94BPXAZ2FGH4x7kUKUqO9bnvxZNjpVD.jpeg','AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,1,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,1,NULL,0,0,0,1,NULL,1,0,'before','[\"modifiers\",\"transfer_balance\",\"receive_balance\",\"warranty_report\",\"vendor_report\"]','m/d/Y','12','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}','green',NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin-restaurant\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-01-04 07:15:19','2019-04-17 17:42:43'),(2,'Awesome Pharmacy',2,'2018-04-10','3412569900','VAT',NULL,NULL,NULL,25.00,4,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AP',1,'add_manufacturing','stop_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,4,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-04-10 12:12:40','2018-04-10 14:21:38'),(3,'Ultimate Electronics',2,'2018-04-10','12548555003','GST',NULL,NULL,NULL,25.00,5,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AE',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,0,5,0,0,0,1,'cmsn_agnt',1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-04-10 14:46:15','2018-12-23 16:10:52'),(4,'Awesome Services',134,NULL,'3412569900','GST',NULL,NULL,NULL,0.00,6,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,0,1,0,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin-restaurant\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-04-10 16:20:42','2018-12-22 12:59:33'),(5,'Awesome Restaurant',2,'2018-07-12','4578220005','IGST','4593220009','SGST',NULL,25.00,7,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AR',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before','[\"tables\",\"modifiers\",\"service_staff\",\"kitchen\",\"internal_banking\",\"transfer_balance\",\"receive_balance\",\"internal_kitchen\"]','m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-07-13 20:42:11','2019-02-16 23:28:27'),(7,'Test',134,NULL,NULL,NULL,NULL,NULL,NULL,25.00,22,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2019-02-11 11:34:35','2019-02-11 11:34:35'),(8,'sis2019',134,'2019-04-08',NULL,NULL,NULL,NULL,NULL,25.00,35,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2019-04-08 11:20:34','2019-04-08 11:20:34'),(9,'Dotz Demo',134,'2019-04-22',NULL,NULL,NULL,NULL,NULL,0.00,36,'Asia/Dhaka',1,'fifo',NULL,'includes','/B1VG3M3goW7sEI0EGA2kYizy1CxsHp4rqiloXb8B.jpeg',NULL,1,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,60,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"is_pos_subtotal_editable\":\"1\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0}',NULL,1,1,1,1,1,1,19,1,1,1,1,NULL,1,0,'before','[\"tables\",\"service_staff\",\"kitchen\",\"account\",\"internal_banking\",\"transfer_balance\",\"receive_balance\",\"internal_kitchen\",\"hr_management\",\"warranty\"]','m/d/Y','12','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}','black-light',NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2019-04-22 20:06:41','2021-05-29 10:35:48'),(10,'Dotz Restaurant',134,'2021-05-25',NULL,NULL,NULL,NULL,NULL,25.00,46,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before','[\"tables\",\"service_staff\",\"kitchen\",\"account\",\"hr_management\"]','m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2021-05-25 06:10:48','2021-05-25 07:16:07');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landmark` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `city` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zip_code` char(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `website` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,NULL,'SIS Shop','Dhaka','Bangladesh','Dhaka','Phoenix','1207',1,1,1,'browser',NULL,'01719131305',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2018-01-04 07:15:20','2018-12-16 19:26:05'),(9,9,'BL0001','Demoshop','Dhaka','Bangladesh','Dhaka','Dhaka','1216',6,6,1,'browser',NULL,'TEL: 01949242464','01701646117',NULL,'http://tahoorstudio.com/',NULL,NULL,NULL,NULL,NULL,'2019-04-22 20:06:41','2021-08-25 05:42:00'),(11,9,'BL0002','TF Dhanmondi',NULL,'Bangladesh','Dhaka','Dhaka','1207',6,6,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-24 16:55:37','2020-11-24 16:55:37'),(12,9,'BL0003','TF Banani',NULL,'Bangladesh','Dhaka','Dhaka','Dhaka',6,6,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-24 16:56:46','2020-11-24 16:56:46'),(13,9,'BL0004','TF Chottogram',NULL,'bangladesh','Chottogram','Chottogram','1111',6,6,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-24 16:57:52','2020-11-24 16:57:52'),(14,9,'BL0005','TF Sylhet',NULL,'Bangladesh','Sylhet','Sylhet','3100',6,6,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2020-11-24 18:03:05','2020-11-24 18:03:05'),(15,10,'BL0001','Dotz Restaurant','ter','Bangladesh','Dhaka','Dhaka','1207',7,7,1,'browser',NULL,'01717022024','','','',NULL,NULL,NULL,NULL,NULL,'2021-05-25 06:10:49','2021-05-25 06:10:49');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT 0.00,
  `pay_method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` enum('debit','credit') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,100.00,'cash','credit','initial',NULL,'2020-11-24 17:16:52','2020-11-24 17:16:52'),(2,2,5000.00,'cash','credit','initial',NULL,'2020-11-24 19:25:57','2020-11-24 19:25:57'),(3,2,200.00,'cash','credit','sell',14,'2021-04-07 13:35:38','2021-04-07 13:35:38'),(4,2,0.00,'cash','credit','sell',14,'2021-04-07 13:35:38','2021-04-07 13:35:38'),(5,2,210.00,'cash','credit','sell',15,'2021-05-21 04:19:14','2021-05-21 04:19:14'),(6,2,0.00,'cash','credit','sell',15,'2021-05-21 04:19:14','2021-05-21 04:19:14'),(7,2,10.00,'cash','credit','sell',21,'2021-05-22 14:45:16','2021-05-22 14:45:16'),(8,2,0.00,'cash','credit','sell',21,'2021-05-22 14:45:16','2021-05-22 14:45:16'),(9,2,30000.00,'cash','credit','sell',22,'2021-05-24 10:29:14','2021-05-24 10:29:14'),(10,2,0.00,'cash','credit','sell',22,'2021-05-24 10:29:14','2021-05-24 10:29:14'),(11,3,0.00,'cash','credit','initial',NULL,'2021-05-25 07:13:53','2021-05-25 07:13:53'),(12,2,30000.00,'cash','credit','sell',23,'2021-05-25 07:15:24','2021-05-25 07:15:24'),(13,2,0.00,'cash','credit','sell',23,'2021-05-25 07:15:24','2021-05-25 07:15:24'),(14,3,125.00,'cash','credit','sell',25,'2021-05-25 07:17:31','2021-05-25 07:17:31'),(15,3,0.00,'cash','credit','sell',25,'2021-05-25 07:17:31','2021-05-25 07:17:31'),(16,4,0.00,'cash','credit','initial',NULL,'2021-08-25 05:44:56','2021-08-25 05:44:56');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(20,2) NOT NULL DEFAULT 0.00,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `closing_note` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,9,41,'open',NULL,0.00,0,0,NULL,'2020-11-24 17:16:52','2020-11-24 17:16:52'),(2,9,36,'open',NULL,0.00,0,0,NULL,'2020-11-24 19:25:57','2020-11-24 19:25:57'),(3,10,46,'open',NULL,0.00,0,0,NULL,'2021-05-25 07:13:53','2021-05-25 07:13:53'),(4,9,48,'open',NULL,0.00,0,0,NULL,'2021-08-25 05:44:56','2021-08-25 05:44:56');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_cat_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'HIjab',9,'hijab01',0,36,NULL,NULL,'2021-05-21 04:13:39','2021-05-21 04:13:39');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `commision_agent_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commision_agent_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `variations_id` int(11) NOT NULL,
  `agent_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_quantity` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `commision_agent_stock` WRITE;
/*!40000 ALTER TABLE `commision_agent_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `commision_agent_stock` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('supplier','customer','both') COLLATE utf8mb4_unicode_ci NOT NULL,
  `supplier_business_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_type` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` double NOT NULL DEFAULT 0,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landmark` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `landline` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alternate_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `credit_limit` decimal(20,2) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `selling_price_groups_id` int(11) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer','',0,NULL,'CO0005',NULL,'Phoenix','Arizona','USA','Linking Street','(378) 400-1234',NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-04 01:45:20','2019-02-13 18:08:25'),(43,9,'customer',NULL,'Walk-In Customer','',0,NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,36,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-22 20:06:41','2019-04-22 20:06:41'),(194,9,'supplier','test','test','general',0,NULL,'CO0151',NULL,NULL,NULL,NULL,NULL,'5432',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24 17:11:43','2020-11-24 17:11:43'),(195,9,'supplier','abc','Sharif','general',0,NULL,'CO0152',NULL,NULL,NULL,NULL,NULL,'017446',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2020-11-24 19:25:11','2020-11-24 19:25:11'),(196,9,'supplier','gdfgf','Nayem','general',0,NULL,'CO0153',NULL,NULL,NULL,NULL,NULL,'635544',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21 18:50:13','2021-05-21 18:50:13'),(197,9,'supplier','gfgbbfgh','Nayem','general',0,NULL,'ggcbbgg',NULL,NULL,NULL,NULL,NULL,'46455',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21 18:58:15','2021-05-21 18:58:15'),(198,9,'supplier','Tiger Park Limited','Nayem','general',0,NULL,'CO0155','01810056681',NULL,NULL,NULL,NULL,'01818173',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-21 19:24:43','2021-05-21 19:24:43'),(199,9,'customer',NULL,'Himel Ahmed','general',0,NULL,'101',NULL,NULL,NULL,NULL,NULL,'01810056681',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-22 02:18:57','2021-05-22 02:18:57'),(200,10,'customer',NULL,'Walk-In Customer','',0,NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,46,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(201,9,'supplier','Akash DTH','Beximco','general',0,NULL,'Akash','00','Dhaka','Dhaka','Bangladesh','Dhaka','01404013040','00','01404013046',NULL,'days',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20 18:07:45','2021-08-20 18:07:45'),(202,9,'customer',NULL,'zia','general',0,NULL,'CO0158',NULL,NULL,NULL,NULL,NULL,'01914508912',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24 11:59:28','2021-08-24 11:59:28');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thousand_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `decimal_separator` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MX','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` varchar(10) NOT NULL,
  `product_id` int(10) NOT NULL,
  `discount_type` varchar(20) NOT NULL,
  `discount_amount` int(10) NOT NULL,
  `unit_price` double NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount` WRITE;
/*!40000 ALTER TABLE `discount` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dish_raw_item_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dish_raw_item_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dish_id` int(11) NOT NULL,
  `raw_item_id` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dish_raw_item_relation` WRITE;
/*!40000 ALTER TABLE `dish_raw_item_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `dish_raw_item_relation` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hrm_attendence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrm_attendence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `e_id` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hrm_attendence` WRITE;
/*!40000 ALTER TABLE `hrm_attendence` DISABLE KEYS */;
INSERT INTO `hrm_attendence` VALUES (1,9,1,'present','2021-05-19',NULL,'2021-05-19 02:05:27','2021-05-19 02:05:27'),(2,9,1,'present','2021-05-22',NULL,'2021-05-22 14:56:21','2021-05-22 14:56:21'),(3,9,2,'present','2021-05-22',NULL,'2021-05-22 14:56:21','2021-05-22 14:56:21'),(4,9,2,'absent','2021-08-21',NULL,'2021-08-21 06:29:03','2021-08-21 06:29:03'),(5,9,1,'present','2021-08-23',NULL,'2021-08-23 06:01:04','2021-08-23 06:01:04'),(6,9,2,'present','2021-08-23',NULL,'2021-08-23 06:01:04','2021-08-23 06:01:04');
/*!40000 ALTER TABLE `hrm_attendence` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hrm_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrm_employees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `father_name` varchar(255) NOT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `p_address` varchar(255) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `department` varchar(255) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `doj` date NOT NULL,
  `exit_date` date DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `salary` double NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hrm_employees` WRITE;
/*!40000 ALTER TABLE `hrm_employees` DISABLE KEYS */;
INSERT INTO `hrm_employees` VALUES (1,9,'Mehrabul Islam Nayem','1621389113_My picture.jpg','Mohammad Tazul Islam','1996-12-25','male','01810056681','2 floor Pappo Bhaban, Bara Nagar, Mograpara, Sonargaon, Narayanganj','Brahmmanbaria',101,'Account','Account Manager','2021-05-19',NULL,'0',12000,NULL,'2021-05-19 01:51:53','2021-05-19 01:51:53'),(2,9,'Himel Ahmed','','Mohammad Tazul Islam','2021-05-19','male','01810056681','2 floor Pappo Bhaban, Bara Nagar, Mograpara, Sonargaon, Narayanganj','Brahmmanbaria',102,'Account','Account Manager','2021-05-27',NULL,'0',15000,NULL,'2021-05-22 02:29:59','2021-08-23 05:49:48');
/*!40000 ALTER TABLE `hrm_employees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hrm_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrm_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `amount` double NOT NULL,
  `e_id` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hrm_transactions` WRITE;
/*!40000 ALTER TABLE `hrm_transactions` DISABLE KEYS */;
INSERT INTO `hrm_transactions` VALUES (1,9,'salary',1200,1,NULL,'2021-05-19 01:54:42','2021-05-19 01:54:42'),(2,9,'salary',15000,2,NULL,'2021-05-22 02:30:39','2021-05-22 02:30:39'),(3,10,'salary',2030,2,NULL,'2021-05-25 07:13:04','2021-05-25 07:13:04'),(4,9,'salary',1000,1,NULL,'2021-08-20 18:01:53','2021-08-20 18:01:53');
/*!40000 ALTER TABLE `hrm_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `header_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_no_prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_heading_line5` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_heading_paid` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quotation_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_due_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paid_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `client_tax_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `date_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_qty_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_unit_price_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_subtotal_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cat_code_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `highlight_color` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `footer_text` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `module_info` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(256) COLLATE utf8mb4_unicode_ci DEFAULT 'classic',
  `cn_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cn_amount_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_tax_headings` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,1,'classic',NULL,NULL,NULL,NULL,'2018-04-04 03:35:32','2018-04-04 03:35:32'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,2,'classic',NULL,NULL,NULL,NULL,'2018-04-10 12:12:40','2018-04-10 12:12:40'),(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,3,'classic',NULL,NULL,NULL,NULL,'2018-04-10 14:46:16','2018-04-10 14:46:16'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,4,'classic',NULL,NULL,NULL,NULL,'2018-04-10 16:20:43','2018-04-10 16:20:43'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,5,'classic',NULL,NULL,NULL,NULL,'2018-07-13 20:42:11','2018-07-13 20:42:11'),(6,'Tahoor Fashion',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000',NULL,NULL,0,9,'classic','Credit Note','Ref. No.','Credit Amount',NULL,'2019-05-12 20:22:52','2020-11-24 16:54:07'),(7,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,10,'classic',NULL,NULL,NULL,NULL,'2021-05-25 06:10:49','2021-05-25 06:10:49');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheme_type` enum('blank','year') COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','AS',1,13,4,1,'2018-01-04 07:15:20','2018-12-26 04:48:17'),(2,2,'Default','blank','AP',1,1327,4,1,'2018-04-10 12:12:40','2019-05-12 20:23:11'),(3,3,'Default','blank','AE',1,5,4,1,'2018-04-10 14:46:16','2018-04-10 15:54:16'),(4,4,'Default','blank','',1,8,4,1,'2018-04-10 16:20:43','2018-04-10 17:08:49'),(5,5,'Default','blank','',1,4,4,1,'2018-07-13 15:12:11','2018-07-13 06:16:36'),(6,9,'Tahoor Fashion','blank','Tahoor Fashion',0,48807,4,0,'2019-05-12 20:23:14','2021-05-25 07:15:24'),(7,10,'Default','blank','',1,1,4,1,'2021-05-25 06:10:49','2021-05-25 07:17:31'),(8,9,'tewt','year',NULL,1000,0,4,0,'2021-08-21 04:14:42','2021-08-21 04:14:42');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_dish_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_dish_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `dish_category_name` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_dish_category` WRITE;
/*!40000 ALTER TABLE `kitchen_dish_category` DISABLE KEYS */;
INSERT INTO `kitchen_dish_category` VALUES (1,9,'Chinese',NULL,'2021-05-25 06:35:28','2021-05-25 06:35:28');
/*!40000 ALTER TABLE `kitchen_dish_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_dish_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_dish_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `dis_name` varchar(255) NOT NULL,
  `dish_category_id` int(11) NOT NULL,
  `dish_type` varchar(255) NOT NULL,
  `dish_price` int(11) NOT NULL,
  `dish_availability` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_dish_list` WRITE;
/*!40000 ALTER TABLE `kitchen_dish_list` DISABLE KEYS */;
INSERT INTO `kitchen_dish_list` VALUES (1,9,'chinese',1,'Lunch',100,'1',NULL,'2021-05-25 06:36:00','2021-05-25 06:36:00');
/*!40000 ALTER TABLE `kitchen_dish_list` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_raw_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_raw_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `raw_item_name` varchar(255) NOT NULL,
  `quantity` double NOT NULL,
  `raw_item_unit` int(10) NOT NULL,
  `raw_item_used_unit` int(10) NOT NULL,
  `raw_item_unit_price` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_raw_items` WRITE;
/*!40000 ALTER TABLE `kitchen_raw_items` DISABLE KEYS */;
INSERT INTO `kitchen_raw_items` VALUES (1,9,'oil',5,22,23,100,NULL,'2021-05-25 06:34:41','2021-05-25 06:34:41');
/*!40000 ALTER TABLE `kitchen_raw_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_used_raw_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_used_raw_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `dish_id` int(11) NOT NULL,
  `raw_item_id` int(11) NOT NULL,
  `used_quantity` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_used_raw_items` WRITE;
/*!40000 ALTER TABLE `kitchen_used_raw_items` DISABLE KEYS */;
INSERT INTO `kitchen_used_raw_items` VALUES (1,9,1,1,1,NULL,'2021-05-25 06:36:23','2021-05-25 06:36:23');
/*!40000 ALTER TABLE `kitchen_used_raw_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User'),(1,3,'App\\User'),(1,9,'App\\User'),(1,10,'App\\User'),(1,23,'App\\User'),(1,26,'App\\User'),(1,27,'App\\User'),(1,28,'App\\User'),(1,29,'App\\User'),(2,2,'App\\User'),(3,4,'App\\User'),(5,5,'App\\User'),(7,6,'App\\User'),(9,7,'App\\User'),(11,8,'App\\User'),(13,20,'App\\User'),(13,32,'App\\User'),(14,31,'App\\User'),(14,33,'App\\User'),(14,34,'App\\User'),(18,22,'App\\User'),(22,35,'App\\User'),(24,36,'App\\User'),(24,39,'App\\User'),(25,37,'App\\User'),(26,38,'App\\User'),(26,40,'App\\User'),(27,41,'App\\User'),(29,42,'App\\User'),(29,44,'App\\User'),(30,43,'App\\User'),(31,45,'App\\User'),(32,47,'App\\User'),(33,48,'App\\User'),(34,46,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_body` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sms_body` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,10,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(2,10,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(3,10,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(4,10,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(5,10,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(6,10,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(7,10,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49'),(8,10,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2021-05-25 06:10:49','2021-05-25 06:10:49');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') COLLATE utf8mb4_unicode_ci NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(20,4) NOT NULL,
  `custom_permissions` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_link_text` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'Starter - Free','Give it a test drive...',1,2,1000,0,0,0,0,800,'months',1,10,0.0000,'',1,0,1,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:10:49'),(2,'Regular','For Small Shops',2,4,1000,0,0,0,0,800,'months',1,10,199.9900,'',1,1,1,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:12:30'),(3,'Unlimited','For Large Business',0,0,0,0,0,0,0,0,'months',1,10,599.9900,'',1,1,1,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:13:50'),(4,'Business','For Small & Growing Shops...',10,10,15000,0,0,0,0,1000,'months',1,10,259.9900,'',1,5,0,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:16:14');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2018-12-10 02:00:04',NULL),(2,'direct_sell.access','web','2018-12-10 02:00:04',NULL),(3,'product.opening_stock','web','2018-12-10 02:00:05','2018-12-10 02:00:05'),(4,'crud_all_bookings','web','2018-12-10 02:00:05','2018-12-10 02:00:05'),(5,'crud_own_bookings','web','2018-12-10 02:00:05','2018-12-10 02:00:05'),(6,'access_default_selling_price','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(7,'purchase.payments','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(8,'sell.payments','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(9,'edit_product_price_from_sale_screen','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(10,'edit_product_discount_from_sale_screen','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(11,'roles.view','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(12,'roles.create','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(13,'roles.update','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(14,'roles.delete','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(15,'woocommerce.syc_categories','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(16,'woocommerce.sync_products','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(17,'woocommerce.sync_orders','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(18,'woocommerce.map_tax_rates','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(19,'woocommerce.access_woocommerce_api_settings','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(20,'user.view','web','2018-12-10 02:00:06',NULL),(21,'user.create','web','2018-12-10 02:00:06',NULL),(22,'user.update','web','2018-12-10 02:00:06',NULL),(23,'user.delete','web','2018-12-10 02:00:06',NULL),(24,'supplier.view','web','2018-12-10 02:00:06',NULL),(25,'supplier.create','web','2018-12-10 02:00:06',NULL),(26,'supplier.update','web','2018-12-10 02:00:06',NULL),(27,'supplier.delete','web','2018-12-10 02:00:06',NULL),(28,'customer.view','web','2018-12-10 02:00:06',NULL),(29,'customer.create','web','2018-12-10 02:00:06',NULL),(30,'customer.update','web','2018-12-10 02:00:06',NULL),(31,'customer.delete','web','2018-12-10 02:00:06',NULL),(32,'product.view','web','2018-12-10 02:00:06',NULL),(33,'product.create','web','2018-12-10 02:00:06',NULL),(34,'product.update','web','2018-12-10 02:00:06',NULL),(35,'product.delete','web','2018-12-10 02:00:06',NULL),(36,'purchase.view','web','2018-12-10 02:00:06',NULL),(37,'purchase.create','web','2018-12-10 02:00:06',NULL),(38,'purchase.update','web','2018-12-10 02:00:06',NULL),(39,'purchase.delete','web','2018-12-10 02:00:06',NULL),(40,'sell.view','web','2018-12-10 02:00:06',NULL),(41,'sell.create','web','2018-12-10 02:00:06',NULL),(42,'sell.update','web','2018-12-10 02:00:06',NULL),(43,'sell.delete','web','2018-12-10 02:00:06',NULL),(44,'purchase_n_sell_report.view','web','2018-12-10 02:00:06',NULL),(45,'contacts_report.view','web','2018-12-10 02:00:06',NULL),(46,'stock_report.view','web','2018-12-10 02:00:06',NULL),(47,'tax_report.view','web','2018-12-10 02:00:06',NULL),(48,'trending_product_report.view','web','2018-12-10 02:00:06',NULL),(49,'register_report.view','web','2018-12-10 02:00:06',NULL),(50,'sales_representative.view','web','2018-12-10 02:00:06',NULL),(51,'expense_report.view','web','2018-12-10 02:00:06',NULL),(52,'business_settings.access','web','2018-12-10 02:00:06',NULL),(53,'barcode_settings.access','web','2018-12-10 02:00:06',NULL),(54,'invoice_settings.access','web','2018-12-10 02:00:06',NULL),(55,'brand.view','web','2018-12-10 02:00:06',NULL),(56,'brand.create','web','2018-12-10 02:00:06',NULL),(57,'brand.update','web','2018-12-10 02:00:06',NULL),(58,'brand.delete','web','2018-12-10 02:00:06',NULL),(59,'tax_rate.view','web','2018-12-10 02:00:06',NULL),(60,'tax_rate.create','web','2018-12-10 02:00:06',NULL),(61,'tax_rate.update','web','2018-12-10 02:00:06',NULL),(62,'tax_rate.delete','web','2018-12-10 02:00:06',NULL),(63,'unit.view','web','2018-12-10 02:00:06',NULL),(64,'unit.create','web','2018-12-10 02:00:06',NULL),(65,'unit.update','web','2018-12-10 02:00:06',NULL),(66,'unit.delete','web','2018-12-10 02:00:06',NULL),(67,'category.view','web','2018-12-10 02:00:06',NULL),(68,'category.create','web','2018-12-10 02:00:06',NULL),(69,'category.update','web','2018-12-10 02:00:06',NULL),(70,'category.delete','web','2018-12-10 02:00:06',NULL),(71,'expense.access','web','2018-12-10 02:00:06',NULL),(72,'access_all_locations','web','2018-12-10 02:00:06',NULL),(73,'dashboard.data','web','2018-12-10 02:00:06',NULL),(74,'location.1','web','2018-12-10 02:00:06',NULL),(75,'location.2','web','2018-12-10 02:00:06',NULL),(76,'location.3','web','2018-12-10 02:00:06',NULL),(77,'location.4','web','2018-12-10 02:00:07',NULL),(78,'location.5','web','2018-12-10 02:00:07',NULL),(79,'location.6','web','2018-12-17 08:17:40','2018-12-17 08:17:40'),(81,'report-supplier.view','web',NULL,NULL),(82,'tbbank.view','web',NULL,NULL),(83,'tbbank.create','web',NULL,NULL),(84,'tbbank.update','web',NULL,NULL),(85,'tbbank.delete','web',NULL,NULL),(86,'tbpersonal.view','web',NULL,NULL),(87,'tbpersonal.create','web',NULL,NULL),(88,'tbpersonal.update','web',NULL,NULL),(89,'tbpersonal.delete','web',NULL,NULL),(90,'rbbank.view','web',NULL,NULL),(91,'rbbank.create','web',NULL,NULL),(92,'rbbank.update','web',NULL,NULL),(93,'rbbank.delete','web',NULL,NULL),(94,'rbpersonal.view','web',NULL,NULL),(95,'rbpersonal.create','web',NULL,NULL),(96,'rbpersonal.update','web',NULL,NULL),(97,'rbpersonal.delete','web',NULL,NULL),(98,'ibuser.view','web',NULL,NULL),(99,'ibuser.create','web',NULL,NULL),(100,'ibuser.update','web',NULL,NULL),(101,'ibuser.delete','web',NULL,NULL),(102,'ibtransaction.view','web',NULL,NULL),(103,'ibtransaction.create','web',NULL,NULL),(104,'ibtransaction.update','web',NULL,NULL),(105,'ibtransaction.delete','web',NULL,NULL),(106,'ibcategory.view','web',NULL,NULL),(107,'ibcategory.create','web',NULL,NULL),(108,'ibcategory.update','web',NULL,NULL),(109,'ibcategory.delete','web',NULL,NULL),(110,'ikritem.view','web',NULL,NULL),(111,'ikritem.create','web',NULL,NULL),(112,'ikritem.update','web',NULL,NULL),(113,'ikritem.delete','web',NULL,NULL),(114,'ikdcategory.view','web',NULL,NULL),(115,'ikdcategory.create','web',NULL,NULL),(116,'ikdcategory.update','web',NULL,NULL),(117,'ikdcategory.delete','web',NULL,NULL),(118,'ikdlist.view','web',NULL,NULL),(119,'ikdlist.create','web',NULL,NULL),(120,'ikdlist.update','web',NULL,NULL),(121,'ikdlist.delete','web',NULL,NULL),(122,'location.7','web','2019-02-11 11:34:36','2019-02-11 11:34:36'),(123,'hrm_employyes.view','web',NULL,NULL),(124,'hrm_employyes.create','web',NULL,NULL),(125,'hrm_employyes.update','web',NULL,NULL),(126,'hrm_employyes.delete','web',NULL,NULL),(127,'hrm_transaction.view','web',NULL,NULL),(128,'hrm_transaction.create','web',NULL,NULL),(129,'hrm_transaction.update','web',NULL,NULL),(130,'hrm_transaction.delete','web',NULL,NULL),(131,'hrm_attendence.view','web',NULL,NULL),(132,'hrm_attendence.create','web',NULL,NULL),(133,'hrm_attendence.update','web',NULL,NULL),(134,'hrm_attendence.delete','web',NULL,NULL),(135,'warranty_supplier.view','web',NULL,NULL),(136,'warranty_supplier.create','web',NULL,NULL),(137,'warranty_supplier.update','web',NULL,NULL),(138,'warranty_supplier.delete','web',NULL,NULL),(139,'warranty_customer.view','web',NULL,NULL),(140,'warranty_customer.create','web',NULL,NULL),(141,'warranty_customer.update','web',NULL,NULL),(142,'warranty_customer.delete','web',NULL,NULL),(143,'location.8','web','2019-04-08 11:20:36','2019-04-08 11:20:36'),(144,'warranty_check.view','web',NULL,NULL),(145,'warranty_check.create','web',NULL,NULL),(146,'location.9','web','2019-04-22 20:06:41','2019-04-22 20:06:41'),(152,'supplier_report.view','web',NULL,NULL),(153,'selling_price_group.3','web','2020-01-01 19:12:34','2020-01-01 19:12:34'),(154,'location.10','web','2020-01-01 19:17:22','2020-01-01 19:17:22'),(155,'selling_price_group.1','web','2020-03-07 19:12:34','2020-03-07 19:12:34'),(156,'requisition.view','web',NULL,NULL),(157,'requisition.create','web',NULL,NULL),(158,'location.11','web','2020-11-24 16:55:37','2020-11-24 16:55:37'),(159,'location.12','web','2020-11-24 16:56:46','2020-11-24 16:56:46'),(160,'location.13','web','2020-11-24 16:57:52','2020-11-24 16:57:52'),(161,'location.14','web','2020-11-24 18:03:05','2020-11-24 18:03:05'),(162,'location.15','web','2021-05-25 06:10:49','2021-05-25 06:10:49');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `physical_stock_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `physical_stock_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `physical_qty` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `current_stock` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `physical_stock_histories` WRITE;
/*!40000 ALTER TABLE `physical_stock_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `physical_stock_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(256) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection_type` enum('network','windows','linux') COLLATE utf8mb4_unicode_ci NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_images` WRITE;
/*!40000 ALTER TABLE `product_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `row` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES (1,9,9,5061,NULL,NULL,NULL,'2020-11-24 17:10:01','2020-11-24 17:10:01'),(2,9,11,5061,NULL,NULL,NULL,'2020-11-24 17:10:01','2020-11-24 17:10:01'),(3,9,12,5061,NULL,NULL,NULL,'2020-11-24 17:10:01','2020-11-24 17:10:01'),(4,9,13,5061,NULL,NULL,NULL,'2020-11-24 17:10:01','2020-11-24 17:10:01'),(5,9,9,5062,NULL,NULL,NULL,'2020-11-24 18:13:37','2020-11-24 18:13:37'),(6,9,11,5062,NULL,NULL,NULL,'2020-11-24 18:13:37','2020-11-24 18:13:37'),(7,9,12,5062,NULL,NULL,NULL,'2020-11-24 18:13:37','2020-11-24 18:13:37'),(8,9,13,5062,NULL,NULL,NULL,'2020-11-24 18:13:37','2020-11-24 18:13:37'),(9,9,14,5062,NULL,NULL,NULL,'2020-11-24 18:13:37','2020-11-24 18:13:37'),(10,9,9,5063,NULL,NULL,NULL,'2021-05-21 04:17:14','2021-05-21 04:17:14'),(11,9,11,5063,NULL,NULL,NULL,'2021-05-21 04:17:14','2021-05-21 04:17:14'),(12,9,12,5063,NULL,NULL,NULL,'2021-05-21 04:17:14','2021-05-21 04:17:14'),(13,9,13,5063,NULL,NULL,NULL,'2021-05-21 04:17:14','2021-05-21 04:17:14'),(14,9,14,5063,NULL,NULL,NULL,'2021-05-21 04:17:14','2021-05-21 04:17:14'),(15,9,9,5064,NULL,NULL,NULL,'2021-05-21 04:17:49','2021-05-21 04:17:49'),(16,9,11,5064,NULL,NULL,NULL,'2021-05-21 04:17:49','2021-05-21 04:17:49'),(17,9,12,5064,NULL,NULL,NULL,'2021-05-21 04:17:49','2021-05-21 04:17:49'),(18,9,13,5064,NULL,NULL,NULL,'2021-05-21 04:17:49','2021-05-21 04:17:49'),(19,9,14,5064,NULL,NULL,NULL,'2021-05-21 04:17:49','2021-05-21 04:17:49'),(20,9,9,5065,NULL,NULL,NULL,'2021-05-21 19:21:25','2021-05-21 19:21:25'),(21,9,11,5065,NULL,NULL,NULL,'2021-05-21 19:21:25','2021-05-21 19:21:25'),(22,9,12,5065,NULL,NULL,NULL,'2021-05-21 19:21:25','2021-05-21 19:21:25'),(23,9,13,5065,NULL,NULL,NULL,'2021-05-21 19:21:25','2021-05-21 19:21:25'),(24,9,14,5065,NULL,NULL,NULL,'2021-05-21 19:21:25','2021-05-21 19:21:25');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',5061,1,'2020-11-24 17:10:01','2020-11-24 17:10:01'),(2,NULL,'DUMMY',5062,1,'2020-11-24 18:13:37','2020-11-24 18:13:37'),(3,NULL,'DUMMY',5063,1,'2021-05-21 04:17:14','2021-05-21 04:17:14'),(4,NULL,'DUMMY',5064,1,'2021-05-21 04:17:49','2021-05-21 04:17:49'),(5,NULL,'DUMMY',5065,1,'2021-05-21 19:21:25','2021-05-21 19:21:25'),(6,NULL,'DUMMY',5066,1,'2021-05-25 07:17:04','2021-05-25 07:17:04'),(7,NULL,'DUMMY',5067,1,'2021-08-21 01:17:04','2021-08-21 01:17:04');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') COLLATE utf8mb4_unicode_ci NOT NULL,
  `reseller_price` double NOT NULL,
  `mrp_price` double NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` int(11) NOT NULL,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') COLLATE utf8mb4_unicode_ci DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field1` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field2` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field3` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_custom_field4` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_product_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `initial_stock` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=5068 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (11,'Don Simon Pure Squeezed Orange (Con Pulp) Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',395,450,1,1,'8410261608105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:10:18','2019-04-25 22:10:18',NULL),(12,'Don Simon Pure Squeezed Orange (Sin Pulp) Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',395,450,1,1,'8410261608402','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:11:42','2019-04-25 22:11:42',NULL),(15,'Vitalia Chia Seed-250gm',9,'single',19,1,2,NULL,NULL,'exclusive',953,1070,1,1,'5310099008449','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:17:24','2019-05-12 23:50:38',NULL),(16,'Don Simon 100% Pressed Tropical Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',395,450,1,1,'8410261611105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:23:53','2019-04-25 22:23:53',NULL),(17,'Don Simon Orange (Naranja) Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',341,390,1,1,'8410261160108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:37:43','2019-04-25 22:37:43',NULL),(18,'Don Simon Apple (Manzana) Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',341,390,1,1,'8410261380100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:40:01','2019-04-25 22:40:01',NULL),(19,'Don Simon Mango Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',341,390,1,1,'8410261657103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:41:40','2019-04-25 22:41:40',NULL),(20,'Don Simon Tomato Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',350,390,1,1,'8410261390109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:43:02','2019-05-08 21:20:42',NULL),(22,'Don Simon Tropical Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',341,390,1,1,'8410261607801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:44:48','2019-04-25 22:44:48',NULL),(23,'Don Simon Orange (Naranja) Juice Pet 1.5ltr',9,'single',19,9,24,NULL,NULL,'exclusive',507.5,575,1,1,'8410261651019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:50:06','2019-04-25 22:50:06',NULL),(24,'Don Simon Pome & Grape (Granada) Juice Drink 1.5ltr',9,'single',19,9,24,NULL,NULL,'exclusive',507.5,575,1,1,'8410261650340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:52:53','2019-04-25 22:52:53',NULL),(25,'Don Simon Tropical Juice Drink 1.5ltr',9,'single',19,9,24,NULL,NULL,'exclusive',507.5,575,1,1,'8410261650067','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:55:11','2019-04-25 22:55:11',NULL),(26,'Don Simon Pineapple Juice 1.5ltr',9,'single',19,9,24,NULL,NULL,'exclusive',507.5,575,1,1,'8410261652016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 22:58:42','2019-04-25 22:58:42',NULL),(27,'Don Simon Orange (Naranja) Juice 20cl',9,'single',19,9,24,NULL,NULL,'exclusive',75.5,95,1,1,'8410261601618','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:39:57','2019-04-25 23:39:57',NULL),(28,'Don Simon Peach (Melocoton) Juice 20cl',9,'single',19,9,24,NULL,NULL,'exclusive',75.5,95,1,1,'8410261603612','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:41:18','2019-04-25 23:41:18',NULL),(29,'Don Simon Apple (Manzana) Juice 20cl',9,'single',19,9,24,NULL,NULL,'exclusive',75.5,95,1,1,'8410261604619','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:42:48','2019-04-25 23:42:48',NULL),(30,'Don Simon Red Fruit (Bosque) Juice 200ml',9,'single',19,9,24,NULL,NULL,'exclusive',75.5,95,1,1,'8410261609317','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:44:17','2019-04-25 23:44:17',NULL),(31,'Don Simon Multifruit Juice 200ml',9,'single',19,9,24,NULL,NULL,'exclusive',75.5,95,1,1,'8410261607412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:45:41','2019-04-25 23:45:41',NULL),(32,'Don Simon La Merienda Juce 200ml',9,'single',19,9,24,NULL,NULL,'exclusive',75.5,95,1,1,'8410261600314','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:46:49','2019-04-25 23:46:49',NULL),(33,'Don Simon Multifruit Juice 125mlml',9,'single',19,9,24,NULL,NULL,'exclusive',48.5,65,1,1,'8410261607214','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:49:37','2019-04-25 23:49:37',NULL),(34,'Don Simon Disfruta Orange Juice Drink 330ml',9,'single',19,9,24,NULL,NULL,'exclusive',98,120,1,1,'8410261650364','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:51:21','2019-04-25 23:51:21',NULL),(35,'Don Simon Tropical Juice Drink 330ml',9,'single',19,9,24,NULL,NULL,'exclusive',98,120,1,1,'8410261627052','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:52:45','2019-04-25 23:52:45',NULL),(36,'Don Simon Squeezed Orange Lite Juice Drink 330 ml',9,'single',19,9,24,NULL,NULL,'exclusive',98,120,1,1,'8410261621517','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:54:26','2019-05-26 22:17:37',NULL),(37,'Don Simon Squeezed Lemon Lite Juice Drink 330 ml',9,'single',19,9,24,NULL,NULL,'exclusive',98,120,1,1,'8410261626512','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:55:54','2019-05-26 22:17:09',NULL),(38,'Del Monte Cranberry Juice Drinks-32 Oz',9,'single',19,8,24,NULL,NULL,'exclusive',741.5,835,1,1,'8888111090064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:57:54','2019-04-25 23:57:54',NULL),(39,'Del Monte Acai Blueberry Fruit Drink 32 Oz',9,'single',19,8,24,NULL,NULL,'exclusive',804.5,905,1,1,'8887333190125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-25 23:59:36','2019-04-25 23:59:36',NULL),(40,'Lotte Xylitol Coating Gum (Orginal)-16gn',9,'single',19,20,22,NULL,NULL,'exclusive',80,100,1,1,'8801062318490','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 00:01:31','2019-04-26 00:01:31',NULL),(41,'Lotte Xylitol Coating Gum (Ice Mint)-16gm',9,'single',19,20,22,NULL,NULL,'exclusive',80,100,1,1,'8801062318537','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 00:03:02','2019-04-26 00:03:02',NULL),(42,'Lotte Xylitol Coating Gum (Pink Mint)-16gm',9,'single',19,20,22,NULL,NULL,'exclusive',80,100,1,1,'8801062318513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 00:04:47','2019-04-26 00:04:47',NULL),(43,'Lotte Xylitol Alpha Project Bottle Gum (Orginal)-86gm',9,'single',19,20,22,NULL,NULL,'exclusive',296,340,1,1,'8801062319190','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 00:07:34','2019-04-26 00:07:34',NULL),(45,'Don Simon Chocolate UHT Milkshake 200ml',9,'single',19,9,26,NULL,NULL,'exclusive',75.5,95,1,1,'8410261636030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:19:31','2019-04-26 15:19:31',NULL),(46,'Don Simon Strawberry Flavor UHT Milkshake 200ml',9,'single',19,9,26,NULL,NULL,'exclusive',75.5,95,1,1,'8410261636047','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:21:35','2019-04-26 15:21:35',NULL),(47,'Don Simon Vanilla UHT Milkshake 200ml',9,'single',19,9,26,NULL,NULL,'exclusive',75.5,95,1,1,'8410261636054','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:22:59','2019-04-26 15:22:59',NULL),(48,'Del Monte Sweet Corn Cream Style-418gm',9,'single',19,8,11,NULL,NULL,'exclusive',111.5,135,1,1,'24000163015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:25:04','2019-04-26 15:25:04',NULL),(49,'Del Monte Cream Style White Corn-418gm',9,'single',19,8,11,NULL,NULL,'exclusive',129.5,155,1,1,'24000163039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:28:53','2019-04-26 15:28:53',NULL),(50,'Del Monte Whole Kernel Corn-432gm',9,'single',19,8,11,NULL,NULL,'exclusive',111.5,135,1,1,'24000163022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:30:28','2020-07-23 00:23:21',NULL),(51,'Del Monte Whole Kernel Sweet White Corn-432gm',9,'single',19,8,11,NULL,NULL,'exclusive',152,180,1,1,'24000163046','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:32:17','2019-04-26 15:32:17',NULL),(52,'Del Monte Sweet Peas-425gm',9,'single',19,8,11,NULL,NULL,'exclusive',140.3,167,1,1,'24000163084','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:34:03','2019-04-26 15:34:03',NULL),(53,'Del Monte Very Young Small Sweet Peas-432gmDel Monte Very Young Small Sweet Peas-432gm',9,'single',19,8,11,NULL,NULL,'exclusive',147.5,175,1,1,'24000163091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:35:31','2019-04-26 15:35:31',NULL),(54,'Del Monte Mixed Vegetables-411gm',9,'single',19,8,11,NULL,NULL,'exclusive',147.5,175,1,1,'24000027645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:36:47','2019-04-26 15:36:47',NULL),(55,'Del Monte Chunky Mixed Fruit in Heavy Syrup-432gm',9,'single',19,8,43,NULL,NULL,'exclusive',224,260,1,1,'24000167099','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:40:54','2019-04-26 15:40:54',NULL),(56,'Del Monte Chunky Mixed Fruit in 100% Fruit Juice-425gm',9,'single',19,8,43,NULL,NULL,'exclusive',260,300,1,1,'24000167129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:42:20','2019-04-26 15:42:20',NULL),(57,'Del Monte Fruit Cocktail in Havey Syup-850gm',9,'single',19,8,43,NULL,NULL,'exclusive',273.5,315,1,1,'24000010920','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:44:00','2019-04-26 15:44:00',NULL),(58,'Del Mont Fiesta Fruit Cocktail 850gm',9,'single',19,8,43,NULL,NULL,'exclusive',190,240,1,1,'4800024037480','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:45:52','2019-05-09 23:41:20',NULL),(59,'Del Monte Apricot Halves in Havy Syrup-432gm',9,'single',19,8,43,NULL,NULL,'exclusive',179,210,1,1,'24000167006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:50:23','2019-04-26 15:50:23',NULL),(60,'Del Monte Pear Halves in Heavy Syrup-432gm',9,'single',19,8,43,NULL,NULL,'exclusive',219.5,255,1,1,'24000167013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:52:23','2019-04-26 15:52:23',NULL),(61,'Del Monte Yellow Peach Halves in Heavy Syrup-825gm',9,'single',19,8,43,NULL,NULL,'exclusive',314,360,1,1,'24000010418','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:53:53','2019-07-23 16:53:24',NULL),(65,'Del Monte Chunky Mixed Fruit 100 Calorie-234gm',9,'single',19,8,43,NULL,NULL,'exclusive',140.3,167,1,1,'24000015390','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 15:59:47','2019-04-26 15:59:47',NULL),(66,'Del Monte Dark Sweet Cherries in Heavy Syrup-425gm',9,'single',19,8,43,NULL,NULL,'exclusive',266.3,307,1,1,'24000167020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:01:41','2019-04-26 16:01:41',NULL),(68,'Del Monte Tomato  Paste 170gm',9,'single',19,8,31,NULL,NULL,'exclusive',111.5,135,1,1,'2400000035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:07:21','2019-04-26 16:07:21',NULL),(69,'Del Monte Tomato  Paste 170gm',9,'single',19,8,31,NULL,NULL,'exclusive',111.5,135,1,1,'2400000035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:07:22','2019-04-26 16:07:22',NULL),(70,'Delmont Tomato Ketchup 340gm',9,'single',19,8,45,NULL,NULL,'exclusive',125,150,1,1,'8887333020019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:11:25','2019-04-26 16:11:25',NULL),(80,'S&W Garbanzo Beans-439gm',9,'single',19,27,11,NULL,NULL,'exclusive',210,245,1,1,'011194391645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:50:21','2019-04-26 16:50:21',NULL),(81,'S&W Cut Green Beans-411gm',9,'single',19,27,11,NULL,NULL,'exclusive',116,140,1,1,'011194350482','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:51:30','2019-04-26 16:51:30',NULL),(82,'S&W Butter Beans-425gm',9,'single',19,27,11,NULL,NULL,'exclusive',260,300,1,1,'011194310707','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:52:55','2019-04-26 16:52:55',NULL),(83,'S&W Cream Style Corn-418gm',9,'single',19,27,11,NULL,NULL,'exclusive',134,160,1,1,'011194296452','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:54:33','2019-04-26 16:54:33',NULL),(84,'S&W Chili Beans-439gm',9,'single',19,27,11,NULL,NULL,'exclusive',260,300,1,1,'011194384890','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:55:45','2019-04-26 16:55:45',NULL),(86,'S&W Pinto Beans 425gm',9,'single',19,27,11,NULL,NULL,'exclusive',215,250,1,1,'011194386986','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:57:01','2019-04-26 16:57:01',NULL),(87,'S&W Cranberry Sauce 397gm',9,'single',19,27,32,NULL,NULL,'exclusive',453,515,1,1,'011194517632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 16:58:38','2019-04-26 16:58:38',NULL),(88,'S&W Pineapple Slice-567gm',9,'single',19,27,43,NULL,NULL,'exclusive',210.5,245,1,1,'8888111012318','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:01:46','2019-04-26 17:01:46',NULL),(89,'S&W Apple Cider Vinegar-473ml',9,'single',19,27,39,NULL,NULL,'exclusive',219.5,255,1,1,'011194588427','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:05:22','2019-04-26 17:05:22',NULL),(91,'S&W Apple Cider Vinegar-946ml',9,'single',19,27,39,NULL,NULL,'exclusive',422,480,1,1,'011194588830','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:10:02','2019-04-26 17:10:02',NULL),(92,'S&W Distelled White Vinegar-946ml',9,'single',19,27,39,NULL,NULL,'exclusive',314,360,1,1,'011194590062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:11:29','2020-07-23 00:25:31',NULL),(93,'S&W Distelled White Vinegar-473ml',9,'single',19,27,39,NULL,NULL,'exclusive',179,210,1,1,'011194589660','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:12:49','2020-07-23 00:26:31',NULL),(94,'S&W Chunk Lite Tuna in Water-170 gm',9,'single',19,27,8,NULL,NULL,'exclusive',228.5,265,1,1,'011194508494','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:24:41','2019-05-26 22:23:39',NULL),(96,'S&W Whole Kernel Corn-432gm',9,'single',19,27,11,NULL,NULL,'exclusive',138.5,165,1,1,'011194301224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:27:09','2019-04-26 17:27:09',NULL),(97,'S&W Tomato  Paste 170gm',9,'single',19,27,31,NULL,NULL,'exclusive',125,150,1,1,'011194377472','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:29:19','2019-04-26 17:29:19',NULL),(98,'S&W Blueberries in Heavy Syrup-425gm',9,'single',19,27,43,NULL,NULL,'exclusive',678.5,765,1,1,'011194228637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:31:07','2019-04-26 17:31:07',NULL),(99,'S&W Whole Peeled Tomatoes-411gm',9,'single',19,27,11,NULL,NULL,'exclusive',129.5,155,1,1,'011194362447','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:33:19','2019-04-26 17:33:19',NULL),(100,'S&W Peach Halves Extra Firm in Syrup-420gm',9,'single',19,27,43,NULL,NULL,'exclusive',129.5,155,1,1,'011194175825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:35:30','2019-04-26 17:35:30',NULL),(101,'Vitalia Crunchy Muesli with Apple and Hazelnut 320gm',9,'single',19,1,1,NULL,NULL,'exclusive',237.5,275,1,1,'5310099008548','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:52:23','2019-04-26 17:52:23',NULL),(102,'Vitalia Crunchy Muesli with Orange and Chocolate 320gm',9,'single',19,1,1,NULL,NULL,'exclusive',237.5,275,1,1,'5310099008562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:55:10','2019-04-26 17:55:10',NULL),(103,'Vitalia Crunchy Muesli with Tropical Fruits 600gm',9,'single',19,1,1,NULL,NULL,'exclusive',575,650,1,1,'5310099003192','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 17:57:20','2019-04-26 17:57:20',NULL),(104,'Vitalia Crunchy Muesli with Blackberry and Raspberry 600gm',9,'single',19,1,1,NULL,NULL,'exclusive',575,650,1,1,'5310099000559','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 18:00:53','2019-04-26 18:00:53',NULL),(105,'Vitalia Crunchy Muesli with Apple and Hazelnut 600gm',9,'single',19,1,1,NULL,NULL,'exclusive',575,650,1,1,'5310099000566','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 18:01:46','2019-04-26 18:01:46',NULL),(106,'Vitalia Crunchy Muesli with Banana and Chocolate 600gm',9,'single',19,1,1,NULL,NULL,'exclusive',575,650,1,1,'5310099000573','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 18:03:45','2019-04-26 18:03:45',NULL),(107,'Vitalia Chocolate Muesli 300gm',9,'single',19,1,1,NULL,NULL,'exclusive',431,490,1,1,'5310099003437','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 18:07:43','2019-04-26 18:07:43',NULL),(108,'Vitalia Crunchy Muesli with Chocolate and Orange 375gm',9,'single',19,1,1,NULL,NULL,'exclusive',377,430,1,1,'5310099009781','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 18:12:06','2019-04-26 18:12:06',NULL),(109,'Vitalia Crunchy Muesli with Chocolate and Chia 350gm',9,'single',19,1,1,NULL,NULL,'exclusive',395,440,1,1,'5310099008296','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 18:13:53','2019-06-20 20:35:43',NULL),(110,'Vitalia Fit & Active Muesli 650gm',9,'single',19,1,1,NULL,NULL,'exclusive',530,600,1,1,'5310099000276','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:31:48','2019-04-26 20:31:48',NULL),(111,'Vitalia Tropical Muesli with 35% Fruit 750gm',9,'single',19,1,1,NULL,NULL,'exclusive',494,560,1,1,'5310099000283','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:33:27','2019-04-26 20:33:27',NULL),(112,'Vitalia Muesli Diabet Bar 30gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,50,1,1,'5310099000887','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:37:35','2019-04-26 20:37:35',NULL),(113,'Vitalia Muesli Cranberry Bar 30gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,50,1,1,'5310099002980','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:39:02','2019-04-26 20:39:02',NULL),(114,'Vitalia Muesli Tropical Bar 30gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,50,1,1,'5310099000870','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:40:05','2019-04-26 20:40:05',NULL),(115,'Vitalia Gluten Free Bar Raspberry W Dark Chococlate 35gm',9,'single',19,1,3,NULL,NULL,'exclusive',111.5,135,1,1,'5310099016314','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:41:26','2019-04-26 20:41:26',NULL),(116,'Vitalia Gluten Free Bar Almond W Dark Chococlate 35gm',9,'single',19,1,3,NULL,NULL,'exclusive',111.5,135,1,1,'5310099016352','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:43:24','2019-04-26 20:43:24',NULL),(117,'Vitalia Granola Bars Walnut & Hazelnut 35gm',9,'single',19,1,3,NULL,NULL,'exclusive',55,60,1,1,'5310099005486','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:46:21','2019-06-21 00:39:03',NULL),(118,'Vitalia Granola Bars Apple & Cinnamon 35gm',9,'single',19,1,3,NULL,NULL,'exclusive',44,60,1,1,'5310099005479','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:47:47','2019-04-26 20:47:47',NULL),(119,'Vitalia Granola Bars Honey & Almonds 35gm',9,'single',19,1,3,NULL,NULL,'exclusive',44,60,1,1,'5310099006018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:48:47','2019-04-26 20:48:47',NULL),(120,'Vitalia Antioxident Bar,Orange & Dark Choco- 30gm',9,'single',19,1,3,NULL,NULL,'exclusive',44,60,1,1,'5310099005653','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:49:56','2019-04-26 20:49:56',NULL),(121,'Vitalia Dark Choco W Hazelnut- 35gm',9,'single',19,1,3,NULL,NULL,'exclusive',44,60,1,1,'5310099005677','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:51:02','2019-04-26 20:51:02',NULL),(122,'Vitalia Slim & Beauty Bar Apricot W Yogut- 30gm',9,'single',19,1,3,NULL,NULL,'exclusive',44,60,1,1,'5310099005660','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:53:15','2019-04-26 20:53:15',NULL),(123,'Vitalia Granola Bars Apple & Cinnamon 210gm',9,'single',19,1,3,NULL,NULL,'exclusive',280,310,1,1,'5310099005981','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:54:35','2019-06-21 00:46:35',NULL),(124,'Vitalia Granola Bars Walnut & Hazelnut 210gm',9,'single',19,1,3,NULL,NULL,'exclusive',280,310,1,1,'5310099005516','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:55:52','2019-06-21 00:40:51',NULL),(125,'Vitalia Sport Bar yoghut coating 60gm',9,'single',19,1,3,NULL,NULL,'exclusive',210,245,1,1,'5310099014068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 20:58:21','2019-04-26 20:58:21',NULL),(126,'Vitalia Sport Bar Milk Chocolate coating 60gm',9,'single',19,1,3,NULL,NULL,'exclusive',210.5,245,1,1,'5310099014051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:00:16','2019-04-26 21:00:16',NULL),(127,'Vitalia Sport Bar Dark Chocolate Coating 60gm',9,'single',19,1,3,NULL,NULL,'exclusive',210.5,245,1,1,'5310099014037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:01:44','2019-04-26 21:01:44',NULL),(128,'Vitalia Fruit Muesli 1kg',9,'single',19,1,1,NULL,NULL,'exclusive',741.5,835,1,1,'5310099003406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:04:09','2019-04-26 21:04:09',NULL),(129,'Vitalia Breakfast Muesli 1kg',9,'single',19,1,1,NULL,NULL,'exclusive',651.5,735,1,1,'5310099003390','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:07:08','2019-04-26 21:07:08',NULL),(130,'Vitalia Chocolate Muesli 1kg',9,'single',19,1,1,NULL,NULL,'exclusive',737,830,1,1,'5310099005899','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:08:24','2019-04-26 21:08:24',NULL),(131,'Vitalia Crunchy Muesli with Blackberry and Raspberry 320gm',9,'single',19,1,3,NULL,NULL,'exclusive',280,325,1,1,'5310099008555','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:09:42','2019-07-25 19:41:38',NULL),(132,'Vitalia Choco Muesli#daily 250gm',9,'single',19,1,1,NULL,NULL,'exclusive',260,300,1,1,'5310099017731','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:15:02','2019-04-26 21:15:02',NULL),(133,'Vitalia Forest Fruits Muesli#daily 250gm',9,'single',19,1,1,NULL,NULL,'exclusive',260,300,1,1,'5310099017519','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:16:30','2019-04-26 21:16:30',NULL),(134,'Vitalia Raw Nuts Muesli#daily 250gm',9,'single',19,1,1,NULL,NULL,'exclusive',260,300,1,1,'5310099017649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:18:03','2019-04-26 21:18:03',NULL),(135,'Vitalia Classic Muesli#Raw raisins 250gm',9,'single',19,1,1,NULL,NULL,'exclusive',260,300,1,1,'5310099017694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:19:00','2019-04-26 21:19:00',NULL),(136,'Vitalia Exotic Muesli#Raw Coconut 250gm',9,'single',19,1,1,NULL,NULL,'exclusive',260,300,1,1,'5310099017632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:20:09','2019-04-26 21:20:09',NULL),(138,'Vitalia 4 Grain Flakes 250gm',9,'single',19,1,21,NULL,NULL,'exclusive',183.5,215,1,1,'5310099018264','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:28:43','2019-04-26 21:28:43',NULL),(139,'Vitalia Wheat flakes 250 gm',9,'single',19,1,21,NULL,NULL,'exclusive',156.5,185,1,1,'5310099015348','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:30:49','2019-04-26 21:30:49',NULL),(140,'Vitalia Raw Seeds Muesli Basic 300gm',9,'single',19,1,1,NULL,NULL,'exclusive',233,270,1,1,'5319990149480','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:33:14','2019-05-10 20:17:14',NULL),(141,'Vitalia Rye  flakes 300 gm',9,'single',19,1,21,NULL,NULL,'exclusive',188,220,1,1,'5310099015324','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:35:59','2019-04-26 21:35:59',NULL),(142,'Vitalia Quinoa Seed-250gm',9,'single',19,1,2,NULL,NULL,'exclusive',710,800,1,1,'5310099010220','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:43:58','2019-04-26 21:43:58',NULL),(143,'Vitalia Gluten Free Muesli W Fruits & Seeds 300gm',9,'single',19,1,2,NULL,NULL,'exclusive',670,735,1,1,'5310099016253','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:47:20','2019-06-21 19:58:39',NULL),(145,'Vitalia Gluten Free Muesli W Seeds, Nuts & Cocoa 300 gmm',9,'single',19,1,2,NULL,NULL,'exclusive',660,735,1,1,'5310099016284','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:50:16','2019-06-21 19:54:49',NULL),(146,'Vitalia Gluten Free Muesli W Raw Nuts & Seeds 300 gm',9,'single',19,1,2,NULL,NULL,'exclusive',1075,1200,1,1,'5310099016222','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:51:24','2019-06-21 19:57:03',NULL),(147,'Vitalia Granola Bars Honey & Almond 210gm',9,'single',19,1,3,NULL,NULL,'exclusive',280,310,1,1,'5310099006001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:53:13','2019-06-21 00:48:59',NULL),(148,'Vitalia Granola Muesli with Honey & Almonds 350gm',9,'single',19,1,1,NULL,NULL,'exclusive',471.5,535,1,1,'5310099007527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:58:10','2019-04-26 21:58:10',NULL),(149,'Vitalia Granola Muesli with Nuts 350gm',9,'single',19,1,1,NULL,NULL,'exclusive',600,670,1,1,'5310099003468','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 21:59:57','2019-06-20 20:57:45',NULL),(150,'Vitalia Corn Flakes Crunchy & Testy 250gm',9,'single',19,1,21,NULL,NULL,'exclusive',291.5,335,1,1,'5310099000733','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:01:35','2019-04-26 22:01:35',NULL),(151,'Vitalia Corn Flakes No added Suger 300gm',9,'single',19,1,21,NULL,NULL,'exclusive',413,470,1,1,'5319990149718','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:03:01','2019-04-26 22:03:01',NULL),(152,'Vitalia Chocolate Corn Flakes 500gm',9,'single',19,1,21,NULL,NULL,'exclusive',471.5,535,1,1,'5310099003062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:04:27','2019-04-26 22:04:27',NULL),(153,'Vitalia Wheat Bran flakes 300 gm',9,'single',19,1,21,NULL,NULL,'exclusive',282.5,325,1,1,'5310099001860','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:05:48','2019-04-26 22:05:48',NULL),(154,'Vitalia Super Cookies Honey & Milk 180gm',9,'single',19,1,18,NULL,NULL,'exclusive',282.5,325,1,1,'5310099018042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:08:26','2020-11-09 21:39:52',NULL),(155,'Vitalia Super Cookies Lemon, Ginger& Turmeric 180gm',9,'single',19,1,18,NULL,NULL,'exclusive',282.5,325,1,1,'5310099018059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:09:51','2020-11-09 21:41:45',NULL),(156,'Vitalia Super Cookies Nuts & Cocoa Coating 216gm',9,'single',19,1,18,NULL,NULL,'exclusive',381.5,435,1,1,'5310099018431','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:10:59','2020-11-09 21:42:33',NULL),(157,'Vitalia Gluten Free Parmesan & Spinach Crackers 75gm',9,'single',19,1,42,NULL,NULL,'exclusive',156,185,1,1,'5310099016390','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:19:58','2019-04-26 22:19:58',NULL),(158,'Vitalia Gluten Free Chili & Onions Crackers 75gm',9,'single',19,1,42,NULL,NULL,'exclusive',156.5,185,1,1,'5310099016413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:21:34','2019-04-26 22:21:34',NULL),(159,'Vitalia Green Tea with Ginseng 50gm',9,'single',19,1,37,NULL,NULL,'exclusive',300.5,345,1,1,'5319990149565','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:24:14','2019-04-26 22:24:14',NULL),(160,'Vitalia Green Tea Sencha Special 50gm',9,'single',19,1,37,NULL,NULL,'exclusive',201.5,235,1,1,'5310099016567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:25:27','2019-04-26 22:25:27',NULL),(161,'Vitalia Green Tea with Lemon & Ginger 50gm',9,'single',19,1,37,NULL,NULL,'exclusive',228.5,265,1,1,'5310099016529','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:26:44','2019-04-26 22:26:44',NULL),(162,'Vitalia Strawberry Jam Diet- 370gm',9,'single',19,1,23,NULL,NULL,'exclusive',350,400,1,1,'5319990149701','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:29:07','2019-04-26 22:29:07',NULL),(163,'Vitalia Apricot Jam Diet- 370gm',9,'single',19,1,23,NULL,NULL,'exclusive',350,400,1,1,'5319990149916','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:30:40','2019-04-26 22:30:40',NULL),(164,'Vitalia Peach Jam Diet- 370gm',9,'single',19,1,23,NULL,NULL,'exclusive',350,400,1,1,'5310099000511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:32:16','2019-04-26 22:32:16',NULL),(165,'Vitalia Go Nutri Oat Flakes 500gm',9,'single',19,1,28,NULL,NULL,'exclusive',242,280,1,1,'5310099009132','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:33:56','2019-04-26 22:33:56',NULL),(166,'Vitalia Apricot W Stevia Jam Diet- 230gm',9,'single',19,1,23,NULL,NULL,'exclusive',242,280,1,1,'5310099008234','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:36:07','2019-04-26 22:36:07',NULL),(167,'Vitalia Pure & Natural Fruits Sweetener 300gm',9,'single',19,1,35,NULL,NULL,'exclusive',350,400,1,1,'5319990149534','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:39:23','2019-04-26 22:39:23',NULL),(168,'Vitalia Unrefined Brown Suger 900gm',9,'single',19,1,35,NULL,NULL,'exclusive',422,480,1,1,'5310099009989','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:48:16','2019-04-26 22:48:16',NULL),(169,'Vitalia GMO Free Brown Suger 450gm',9,'single',19,1,35,NULL,NULL,'exclusive',240,265,1,1,'5310099011883','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:49:41','2019-06-21 20:00:45',NULL),(170,'Vitalia Brown Suger (100X5g) 500gm',9,'single',19,1,35,NULL,NULL,'exclusive',395,450,1,1,'5310099001181','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:51:08','2019-04-26 22:51:08',NULL),(171,'Orgran Gluten Free Vegetable & Rice Spiral Pasta 250gm',9,'single',19,22,30,NULL,NULL,'exclusive',620,700,1,1,'720516722301','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:56:58','2019-04-26 22:56:58',NULL),(172,'Orgran Gluten Free Quinoa penne Pasta 250gm',9,'single',19,22,30,NULL,NULL,'exclusive',710,800,1,1,'720516021695','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 22:59:14','2019-04-26 22:59:14',NULL),(173,'Orgran Gluten Free Amaretti Biscotti 150gm',9,'single',19,22,5,NULL,NULL,'exclusive',867,975,1,1,'720516021190','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:01:35','2019-04-26 23:01:35',NULL),(174,'Orgran Gluten Free Classic Choc Biscotti 150gm',9,'single',19,22,5,NULL,NULL,'exclusive',867,975,1,1,'720516021558','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:10:27','2019-04-26 23:10:27',NULL),(175,'Orgran Gluten Free Outback Animals kids Vanila cookies 175gm',9,'single',19,22,18,NULL,NULL,'exclusive',867.5,975,1,1,'720516021572','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:16:48','2019-04-26 23:16:48',NULL),(177,'Orgran Gluten Free Quinoa Crispibread with 125gm',9,'single',19,22,46,NULL,NULL,'exclusive',867.5,975,1,1,'720516022234','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:21:45','2019-04-26 23:21:45',NULL),(178,'Orgran Gluten Free Tosted Corn Crispibread 125gm',9,'single',19,22,46,NULL,NULL,'exclusive',615.5,695,1,0,'720516022050','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:23:31','2019-04-26 23:23:31',NULL),(179,'Orgran Gluten Free Tosted Buckwheat Crispibread 125gm',9,'single',19,22,46,NULL,NULL,'exclusive',615.5,695,1,1,'720516021961','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:25:14','2019-04-26 23:25:14',NULL),(180,'Orgran Gluten Free Chia Crispibread 125gm',9,'single',19,22,46,NULL,NULL,'exclusive',741.5,835,1,1,'720516021732','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:27:25','2019-04-26 23:27:25',NULL),(181,'Orgran Gluten Free Quinoa wafer crackers 100gm',9,'single',19,22,42,NULL,NULL,'exclusive',930,1045,1,0,'720516023095','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:30:30','2019-04-26 23:30:30',NULL),(182,'Peacock Rice Vermicelli Single serve Pack 400gm',9,'single',19,23,27,NULL,NULL,'exclusive',390.5,445,1,1,'8887133308409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:32:15','2019-04-26 23:32:15',NULL),(183,'Peacock Rice Vermicelli 300gm',9,'single',19,23,27,NULL,NULL,'exclusive',170,200,1,1,'8887133343387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:34:50','2019-04-26 23:34:50',NULL),(184,'Bob\'s Red Mill Gluten Free 10 Grain Pancake & Waffle 26oz (6)',9,'single',19,4,46,NULL,NULL,'exclusive',966.5,1085,1,1,'039978002044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:39:12','2019-04-26 23:39:12',NULL),(185,'Bob\'s Red Mill Gluten Free Oats Rolled Extra Thick 16oz',9,'single',19,4,28,NULL,NULL,'exclusive',764,860,1,1,'039978029546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:41:40','2019-04-26 23:41:40',NULL),(186,'Tabasco Pepper Sauce (Red) 60ml',9,'single',19,32,32,NULL,NULL,'exclusive',180,250,1,1,'011210000018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:43:58','2019-05-25 18:39:55',NULL),(187,'Kikkoman Soy Sauce 150ml',9,'single',19,17,32,NULL,NULL,'exclusive',206,240,1,1,'49645309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:45:44','2019-04-26 23:45:44',NULL),(188,'Kikkoman Soy Sauce 600ml',9,'single',19,17,32,NULL,NULL,'exclusive',413,470,1,1,'4901515118586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:47:53','2019-04-26 23:47:53',NULL),(189,'Kikkoman Soy Sauce Special Fragrance 600ml',9,'single',19,17,32,NULL,NULL,'exclusive',413,470,1,1,'4901515118579','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:49:38','2019-04-26 23:49:38',NULL),(190,'Kikkoman Soy Sauce 1ltr',9,'single',19,17,32,NULL,NULL,'exclusive',557,630,1,1,'4901515118128','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:50:47','2019-04-26 23:50:47',NULL),(191,'San Remo Spicy Tomato & Capsicum  Pasta Sauce 500gm',9,'single',19,28,32,NULL,NULL,'exclusive',305,350,1,1,'9310155003759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:53:21','2019-04-26 23:53:21',NULL),(192,'San Remo Tomato, Onion & Garlic  Pasta Sauce 500gm',9,'single',19,28,32,NULL,NULL,'exclusive',305,350,1,1,'9310155170413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:54:46','2019-04-26 23:54:46',NULL),(193,'San Remo Bolognese & Mushroom  Pasta Sauce 500gm',9,'single',19,28,32,NULL,NULL,'exclusive',305,350,1,1,'9310155003711','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-26 23:55:54','2019-04-26 23:55:54',NULL),(194,'Iliada Kalamata Extra Virgin Olive Oil 750ml',9,'single',19,16,29,NULL,NULL,'exclusive',800,900,1,1,'5201043112605','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:00:32','2019-04-27 00:00:32',NULL),(195,'Iliada Kalamata Extra Virgin Olive Oil 500ml',9,'single',19,16,29,NULL,NULL,'exclusive',530,600,1,1,'5201043112612','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:03:12','2019-04-27 00:03:12',NULL),(196,'Iliada Kalamata Greek Extra Virgin Olive Oil 500ml',9,'single',19,16,29,NULL,NULL,'exclusive',530,600,1,1,'5201043115064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:04:34','2019-04-27 00:04:34',NULL),(197,'Boncafe 100% pure Gurmet Coffee 500gm',9,'single',19,5,16,NULL,NULL,'exclusive',1430,1600,1,1,'8888089101403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:07:22','2019-04-27 00:07:22',NULL),(199,'San Remo Fusillini Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155307437','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:10:03','2019-04-27 00:10:03',NULL),(200,'San Remo Macaroni Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155204132','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:11:25','2019-04-27 00:11:25',NULL),(201,'San Remo Panne Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155202336','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:34:36','2019-04-27 00:34:36',NULL),(202,'San Remo Large Shells Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155203333','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:35:45','2019-04-27 00:35:45',NULL),(203,'San Remo Small Shells Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155203432','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:37:01','2019-04-27 00:37:01',NULL),(204,'San Remo Spirals Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155202138','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:38:14','2019-04-27 00:38:14',NULL),(205,'San Remo Large Spirals Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155204231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:39:40','2019-04-27 00:39:40',NULL),(206,'San Remo Bowties Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155201032','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:41:46','2019-04-27 00:41:46',NULL),(207,'San Remo Elbows Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155203838','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:43:15','2019-04-27 00:43:15',NULL),(208,'San Remo Spaghetti 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',170,200,1,1,'9310155100434','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:45:48','2019-04-27 00:45:48',NULL),(209,'San Remo Fettuccine 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',224,260,1,1,'9310155101035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:48:49','2019-04-27 00:48:49',NULL),(210,'San Remo Gluten Free  Spaghetti-350gm',9,'single',19,28,30,NULL,NULL,'exclusive',741.5,835,1,1,'9310155009553','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:51:12','2019-04-27 00:51:12',NULL),(211,'San Remo Gluten Free Penne-350gm',9,'single',19,28,30,NULL,NULL,'exclusive',741.5,835,1,1,'9310155009577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:52:35','2019-04-27 00:52:35',NULL),(212,'San Remo Gluten Free  Spiral 350gm',9,'single',19,28,30,NULL,NULL,'exclusive',741.5,835,1,1,'9310155009652','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 00:54:25','2019-04-27 00:54:25',NULL),(213,'Clorox Bleach(Lavenderl) 1ltr',9,'single',19,34,48,NULL,NULL,'exclusive',310,410,1,1,'9556823150299','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 01:13:56','2019-05-25 21:22:27',NULL),(214,'Clorox Bleach(Orginal) 500ml',9,'single',19,34,48,NULL,NULL,'exclusive',110,135,1,1,'9556823122258','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 01:15:38','2019-05-25 21:19:45',NULL),(215,'Clorox Bleach(Lemon) 500ml',9,'single',19,34,48,NULL,NULL,'exclusive',110,135,1,1,'9556823130284','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 01:17:25','2019-05-25 21:18:56',NULL),(216,'Vitalia Green clay for face & body 500 gm',9,'single',19,1,47,NULL,NULL,'exclusive',750.5,845,1,1,'5310099000023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 01:20:27','2019-05-09 20:22:45',NULL),(217,'S&W Whole Egg Real Mayonnaise 236gm',9,'single',19,27,25,NULL,NULL,'exclusive',215,250,1,1,'8888111710108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:30:12','2019-09-10 21:05:05',NULL),(218,'S&W Whole Egg Real Mayonnaise 473gm',9,'single',19,27,25,NULL,NULL,'exclusive',350,425,1,1,'8888111710115','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:32:09','2019-09-10 21:03:24',NULL),(219,'S&W Whole Egg Real Mayonnaise 946gm',9,'single',19,27,25,NULL,NULL,'exclusive',750,750,1,1,'8888111710122','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:34:25','2019-09-10 21:01:40',NULL),(220,'Hosen Fruit Cocktail Fiesta in Syrup-836gm',9,'single',19,14,43,NULL,NULL,'exclusive',180,250,1,1,'8888192820758','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:46:53','2019-05-08 23:56:10',NULL),(221,'Hosen Fruit Cocktail Premium in Syrup-420gm',9,'single',19,14,43,NULL,NULL,'exclusive',210.5,245,1,1,'8888192820772','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:49:47','2019-04-27 16:49:47',NULL),(222,'Hosen Fruit Cocktail Premium in Syrup-825gm',9,'single',19,14,43,NULL,NULL,'exclusive',341,390,1,1,'8888192820628','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:51:20','2019-04-27 16:51:20',NULL),(224,'Hosen Baby Gharkin Orginal-350gm',9,'single',19,14,11,NULL,NULL,'exclusive',206,240,1,1,'8888192821434','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:57:39','2019-04-27 16:57:39',NULL),(225,'Hosen Baby Gharkin Orginal-680gm',9,'single',19,14,11,NULL,NULL,'exclusive',230,267,1,1,'8888192821441','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 16:59:03','2019-05-25 18:56:01',NULL),(226,'Hosen Bamboo Shoot-552gm',9,'single',19,14,11,NULL,NULL,'exclusive',110,145,1,1,'8888192821311','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:01:04','2019-05-25 20:38:51',NULL),(227,'Hosen Mixed Vegetables-400gm',9,'single',19,14,11,NULL,NULL,'exclusive',80,100,1,1,'8888192821342','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:02:00','2019-04-27 17:02:00',NULL),(228,'Hosen Baked Beans in Tomato Sauce-425gm',9,'single',19,14,11,NULL,NULL,'exclusive',116,140,1,1,'8888192821076','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:03:01','2019-04-27 17:03:01',NULL),(229,'Hosen Garbanzo Beans Chick Peas-425gm',9,'single',19,14,11,NULL,NULL,'exclusive',152,180,1,1,'8888192821601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:04:16','2019-04-27 17:04:16',NULL),(230,'Hosen Red Kidney Beans in Brine-425gm',9,'single',19,14,11,NULL,NULL,'exclusive',140.3,167,1,1,'8888192821588','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:06:31','2019-04-27 17:06:31',NULL),(231,'Hosen Asparagus-430gm',9,'single',19,14,11,NULL,NULL,'exclusive',296,340,1,1,'8888192821175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:07:45','2019-04-27 17:07:45',NULL),(232,'Hosen Cream Styled Corn-425gm',9,'single',19,14,11,NULL,NULL,'exclusive',102.5,125,1,1,'8888192815112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:08:49','2019-04-27 17:08:49',NULL),(233,'Hosen Whole Kernel Corn(Sweet Corn)-400gm',9,'single',19,14,11,NULL,NULL,'exclusive',90,120,1,1,'8888192815013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:09:56','2019-05-25 21:08:50',NULL),(234,'Hosen Baby Corn Young Corn Cut)-400gm',9,'single',19,14,11,NULL,NULL,'exclusive',105,135,1,1,'8888192815211','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:11:01','2019-05-25 21:16:25',NULL),(235,'Hosen Baby Corn (Yoing Corn Spear)-425gm',9,'single',19,14,11,NULL,NULL,'exclusive',129.5,155,1,1,'8888192815310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:13:00','2019-04-27 17:13:00',NULL),(236,'Hosen Green Peas Choice Whole-397gm',9,'single',19,14,11,NULL,NULL,'exclusive',75.5,95,1,1,'8888192821182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:14:09','2019-04-27 17:14:09',NULL),(237,'Hosen Mushroom Slice Pieces & Stems 425gm',9,'single',19,14,11,NULL,NULL,'exclusive',110,140,1,1,'8888192821083','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:15:10','2019-05-25 20:51:15',NULL),(238,'Hosen Mushroom Choice Whole-2840gm',9,'single',19,14,11,NULL,NULL,'exclusive',775,1035,1,1,'8888192821120','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:17:35','2019-05-09 23:46:46',NULL),(239,'Hosen Bailing Mushooms-815gm',9,'single',19,14,11,NULL,NULL,'exclusive',350,400,1,1,'8888192821212','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:20:22','2019-04-27 17:20:22',NULL),(240,'Hosen Mushroom Choice Whole-850gm',9,'single',19,14,11,NULL,NULL,'exclusive',225,315,1,1,'8888192821380','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:24:46','2019-05-25 20:53:01',NULL),(241,'Hosen Mushroom Choice Whole-425gm',9,'single',19,14,11,NULL,NULL,'exclusive',116,140,1,1,'8888192815419','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:25:41','2019-04-27 17:25:41',NULL),(242,'Hosen Mushroom Choice Whole-184gm',9,'single',19,14,11,NULL,NULL,'exclusive',90,125,1,1,'8888192821236','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:26:38','2019-05-25 20:52:06',NULL),(243,'Scheweps Ginger Ale-320ml',9,'single',19,29,34,NULL,NULL,'exclusive',110,140,1,1,'8888002066000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:28:10','2019-10-24 20:24:18',NULL),(244,'Scheweps Tonic Water-320ml',9,'single',19,29,34,NULL,NULL,'exclusive',90,140,1,1,'8888002065003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:29:41','2019-08-09 17:59:28',NULL),(245,'Scheweps Soda Water-320ml',9,'single',19,29,34,NULL,NULL,'exclusive',90,140,1,1,'8888002064006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:30:37','2019-08-09 17:57:52',NULL),(246,'Scheweps Bitter Lemon-330ml',9,'single',19,29,34,NULL,NULL,'exclusive',90,140,1,1,'8888002067007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:31:45','2019-08-09 17:58:39',NULL),(247,'Mountain Dew Can-320ml',9,'single',19,35,34,NULL,NULL,'exclusive',85,135,1,1,'9556404011032','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:34:34','2019-08-09 18:06:25',NULL),(248,'Fanta Can (Grape)-320ml',9,'single',19,36,34,NULL,NULL,'exclusive',85,135,1,1,'8888002084004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:36:08','2019-08-09 18:03:58',NULL),(249,'Fanta Can (Strawberry)-320ml',9,'single',19,36,34,NULL,NULL,'exclusive',90,135,1,1,'8888002085001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:37:19','2019-08-09 18:05:18',NULL),(250,'Pepsi Cola (Regular) Can-320ml',9,'single',19,24,34,NULL,NULL,'exclusive',85,135,1,1,'9556404001033','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:38:29','2019-08-09 18:06:04',NULL),(251,'7 Up Can-330 ml',9,'single',19,37,34,NULL,NULL,'exclusive',85,135,1,1,'9556404007035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,'1595491696_download.jpg',NULL,36,NULL,'2019-04-27 17:39:58','2020-07-23 18:09:33',NULL),(252,'Sprite Can-320ml',9,'single',19,38,34,NULL,NULL,'exclusive',85,135,1,1,'9555589200668','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:41:22','2019-08-09 18:06:55',NULL),(253,'Coca Cola no sugar Can-320ml',9,'single',19,6,34,NULL,NULL,'exclusive',90,140,1,1,'8888002087005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:42:25','2019-08-09 18:00:24',NULL),(254,'Coke Lite Can-320 ml',9,'single',19,6,34,NULL,NULL,'exclusive',90,140,1,1,'9555589200514','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:43:43','2019-08-09 18:00:02',NULL),(255,'Coca Cola Can-320ml',9,'single',19,6,34,NULL,NULL,'exclusive',85,135,1,1,'8888002076009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:45:03','2019-08-09 18:05:40',NULL),(256,'Delmonte Prune Juice 30oz',9,'single',19,8,24,NULL,NULL,'exclusive',651.5,735,1,1,'8887333110116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:48:18','2020-07-22 13:52:00',NULL),(257,'Delmonte Pitted Prune 283gm',9,'single',19,8,44,NULL,NULL,'exclusive',489.5,555,1,1,'8887333110130','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:52:30','2019-05-02 17:53:15',NULL),(258,'Hosen Select Chopped Tomato-400gm',9,'single',19,14,11,NULL,NULL,'exclusive',120.5,145,1,1,'8888192951544','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:55:36','2019-04-27 17:55:36',NULL),(259,'Hosen Peaches Half in Syrup-825gm',9,'single',19,14,43,NULL,NULL,'exclusive',363.5,415,1,1,'8888192820482','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:57:24','2019-04-27 17:57:24',NULL),(260,'Hosen Apricots Half in Syrup-825gm',9,'single',19,14,43,NULL,NULL,'exclusive',287,330,1,1,'8888192840107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:58:39','2020-07-23 00:08:03',NULL),(261,'Hosen Pears Half in Syrup-825gm',9,'single',19,14,43,NULL,NULL,'exclusive',341,390,1,1,'8888192840121','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 17:59:56','2019-04-27 17:59:56',NULL),(262,'Hosen Pineapple slices in Syrup-565gm',9,'single',19,14,43,NULL,NULL,'exclusive',165.5,195,1,1,'8888192820109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:01:04','2019-04-27 18:01:04',NULL),(263,'Hosen Pineapple Cubes in Syrup-565gm',9,'single',19,14,43,NULL,NULL,'exclusive',170,200,1,1,'8888192820253','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:01:51','2020-07-23 00:11:46',NULL),(264,'Hosen Rambutan in Syrup-565gm',9,'single',19,14,43,NULL,NULL,'exclusive',220,390,1,1,'8888192820352','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:04:27','2019-05-25 20:26:56',NULL),(265,'Hosen Rambutan Stuffed with Pineapple-565gm',9,'single',19,14,43,NULL,NULL,'exclusive',270,350,1,1,'8888192820307','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:13:56','2019-05-25 20:28:07',NULL),(266,'Evian Water 500ml',9,'single',19,10,40,NULL,NULL,'exclusive',100,105,1,1,'3068320055008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:16:21','2019-08-04 16:55:52',NULL),(267,'Evian Water 1.5Ltr',9,'single',19,10,40,NULL,NULL,'exclusive',220,270,1,1,'3068320085005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:17:26','2019-08-04 16:54:18',NULL),(268,'Apple Cider Veneger (Heinz) 16oz',9,'single',19,13,39,NULL,NULL,'exclusive',233,270,1,1,'013000008129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:21:34','2019-04-27 18:21:34',NULL),(269,'White Vineger (Heinz) 16oz',9,'single',19,13,39,NULL,NULL,'exclusive',218.6,254,1,1,'013000008525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:23:54','2019-04-27 18:23:54',NULL),(270,'White Veneger (Heinz) 946ml',9,'single',19,13,39,NULL,NULL,'exclusive',327.5,375,1,1,'013000008549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:25:05','2019-04-27 18:25:05',NULL),(271,'SIS White Suger Sachet (100X5) 500gm',9,'single',19,30,35,NULL,NULL,'exclusive',220,280,1,1,'8888167027854','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:27:18','2019-05-09 23:51:02',NULL),(272,'SIS Super Fine Icing Suger 500gm',9,'single',19,30,35,NULL,NULL,'exclusive',185,230,1,1,'8888167033992','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:28:20','2020-07-23 00:35:30',NULL),(273,'SIS Raw Suger Cubes 454gm',9,'single',19,30,35,NULL,NULL,'exclusive',270,335,1,1,'8888167124980','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:29:57','2020-07-23 00:34:31',NULL),(274,'SIS Natural Granulated Raw Suger Sachet (100X5gm)500gm',9,'single',19,30,35,NULL,NULL,'exclusive',300,395,1,1,'8888167127851','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:31:24','2019-05-09 23:49:20',NULL),(275,'Sis Brown Sugar 800gm',9,'single',19,30,35,NULL,NULL,'exclusive',280,375,1,1,'8888167113014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:32:34','2019-06-16 18:24:33',NULL),(276,'Oyster Sauce (Bachun) 350ml',9,'single',19,39,32,NULL,NULL,'exclusive',220,290,1,1,'8888209328154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:34:28','2019-05-26 01:00:50',NULL),(277,'B B Q Sauce (Hunt\'s) 510gm',9,'single',19,15,32,NULL,NULL,'exclusive',350,400,1,1,'027000609019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 18:35:53','2019-04-27 18:35:53',NULL),(278,'Ferench\'s Yellow Mustard, Glass BTL 255gm',9,'single',19,11,32,NULL,NULL,'exclusive',210,275,1,1,'041500002248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:41:27','2019-05-21 16:31:15',NULL),(279,'Kikkoman Soy Sauce1.6ltr',9,'single',19,17,32,NULL,NULL,'exclusive',710,800,1,1,'4901515118425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:43:39','2019-04-27 19:43:39',NULL),(280,'Rice Vermichili - (Long Ku) 250gm',9,'single',19,19,27,NULL,NULL,'exclusive',98,120,1,1,'8885004123427','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:45:02','2019-04-27 19:45:02',NULL),(281,'Highway Creamy Peanut Butter-510gm',9,'single',19,14,6,NULL,NULL,'exclusive',440,500,1,1,'8888192501572','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:47:06','2019-04-27 19:47:06',NULL),(282,'Highway Crunchy Peanut Butter-510gm',9,'single',19,14,6,NULL,NULL,'exclusive',440,500,1,1,'8888192501589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:48:25','2019-04-27 19:48:25',NULL),(283,'Highway Corned Beef-340gm',9,'single',19,14,10,NULL,NULL,'exclusive',260,300,1,1,'8888192501633','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:49:56','2019-04-27 19:49:56',NULL),(284,'Fortune Tuna Chunk in Oil-185gm',9,'single',19,40,8,NULL,NULL,'exclusive',179,210,1,1,'8888192005704','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:52:02','2019-04-27 19:52:02',NULL),(285,'Hosen Coconut Milk Lite-400 ml',9,'single',19,14,26,NULL,NULL,'exclusive',84.5,105,1,1,'8888192901600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:53:44','2019-05-26 22:23:06',NULL),(286,'Hosen Coconut Milk Rich & Creamy-400ml',9,'single',19,14,26,NULL,NULL,'exclusive',138.5,165,1,1,'8888192901617','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:54:58','2019-04-27 19:54:58',NULL),(287,'Hosen Black Olive Pitted-345gm',9,'single',19,14,49,NULL,NULL,'exclusive',170,200,1,1,'8888192951506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:57:46','2020-07-23 00:18:34',NULL),(288,'Hosen Green Olive Pitted-345gm',9,'single',19,14,49,NULL,NULL,'exclusive',215,250,1,1,'8888192951414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 19:59:30','2019-04-27 19:59:30',NULL),(289,'Hosen Black Olive Whole-350gm',9,'single',19,14,49,NULL,NULL,'exclusive',188,220,1,1,'8888192951483','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:01:32','2019-04-27 20:01:32',NULL),(290,'Hosen Green Olive Whole-350gm',9,'single',19,14,49,NULL,NULL,'exclusive',188,220,1,1,'8888192951421','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:03:05','2019-04-27 20:03:05',NULL),(291,'Hosen Green Marachino Cherries-737gm',9,'single',19,14,43,NULL,NULL,'exclusive',590.3,667,1,1,'8888192501800','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:05:29','2020-07-23 00:17:06',NULL),(292,'Hosen Longan in Syrup-234gm',9,'single',19,14,43,NULL,NULL,'exclusive',135,180,1,1,'8888192931485','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:07:34','2019-05-25 20:46:44',NULL),(293,'Del Monte Yellow Sliced Peaches in Heavy Syrup-825gm',9,'single',19,8,43,NULL,NULL,'exclusive',314,360,1,1,'024000010623','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:11:14','2019-04-27 20:11:14',NULL),(294,'Del Monte Slices Pineapple in Heavy Syrup-567gm',9,'single',19,8,43,NULL,NULL,'exclusive',237.5,275,1,1,'024000012313','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:15:37','2019-04-27 20:15:37',NULL),(296,'Country Fresh Nuts Cocktail (Roasted & Salted)-130gm',9,'single',19,7,9,NULL,NULL,'exclusive',240,320,1,1,'8423371006082','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:36:01','2019-04-27 20:36:01',NULL),(297,'Country Fresh Almonds Nust (Roasted & Salted)-130gm',9,'single',19,7,9,NULL,NULL,'exclusive',232,310,1,1,'8423371006068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:37:28','2019-04-27 20:37:28',NULL),(298,'Country Fresh Cashews  Nust (Roasted & Salted)-130gm',9,'single',19,7,9,NULL,NULL,'exclusive',300,400,1,1,'8423371006075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:38:51','2019-04-27 20:38:51',NULL),(299,'Country Fresh Pistachio Nust (Roasted & Salted)-130gm',9,'single',19,7,9,NULL,NULL,'exclusive',315,420,1,1,'8423371006099','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:39:58','2019-04-27 20:39:58',NULL),(300,'Ligo Potato Chips Sour Cream & Onion  Flavour 160gm',9,'single',19,18,14,NULL,NULL,'exclusive',155,215,1,1,'072810271963','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:41:32','2019-04-27 20:41:32',NULL),(301,'Ligo Potato Chips Cheese  Flavour 160gm',9,'single',19,18,14,NULL,NULL,'exclusive',155,215,1,1,'072810272250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:43:04','2019-04-27 20:43:04',NULL),(302,'Ligo Potato Chips Barbecue  Flavour 160gm',9,'single',19,18,14,NULL,NULL,'exclusive',155,215,1,1,'072810271949','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:44:34','2019-04-27 20:44:34',NULL),(303,'Ligo Potato Chips Original Flavour 160gm',9,'single',19,18,14,NULL,NULL,'exclusive',155,215,1,1,'072810271925','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:47:04','2019-04-27 20:47:04',NULL),(304,'Red Bull Energy Drink (Austria) 250Ml',9,'single',19,26,20,NULL,NULL,'exclusive',2230,240,1,1,'90162602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:51:07','2019-08-04 16:59:00',NULL),(305,'Lotte Choco Pie 18Packs 504gm',9,'single',19,20,5,NULL,NULL,'exclusive',500,500,1,1,'8901123005410','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:52:25','2019-05-07 22:07:28',NULL),(306,'Don Simon Sparkling Red Grape Drink 750ml',9,'single',19,9,12,NULL,NULL,'exclusive',250,350,1,1,'8410261491028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 20:54:34','2019-04-27 20:54:34',NULL),(307,'Don Simon Sparkling White Grape Drink 750ml',9,'single',19,9,12,NULL,NULL,'exclusive',250,350,1,1,'8410261493022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:01:00','2019-04-27 21:01:00',NULL),(308,'Pure Heaven White Grape Drink 750ml',9,'single',19,41,12,NULL,NULL,'exclusive',335,435,1,1,'5032619300023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:05:33','2019-05-03 22:06:18',NULL),(309,'Lotte Sacsac Orange Pulpe Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056389017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:07:12','2019-05-14 16:04:48',NULL),(310,'Lotte Sacsac Grape Pulpe Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',60,90,1,1,'8801056298012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:08:23','2019-05-16 23:36:54',NULL),(311,'Lotte Sweetened Apple Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056012731','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:09:39','2019-05-14 16:05:48',NULL),(312,'Lotte Sweetened White Guava Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056011406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:10:46','2019-05-14 16:07:49',NULL),(313,'Lotte Sweetened Peach Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056012106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:11:49','2019-05-14 16:07:24',NULL),(314,'Lotte Sweetened Mango Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056002107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:12:58','2019-05-14 16:06:53',NULL),(315,'Lotte Sweetened Four Seasons Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056003715','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:14:16','2019-05-14 16:06:29',NULL),(316,'Lotte Sweetened Aloe  Drink-240ml',9,'single',19,20,24,NULL,NULL,'exclusive',70,90,1,1,'8801056015442','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:15:12','2019-05-14 16:05:13',NULL),(317,'Biondi Spaghetti No.4 Pasta-500gm',9,'single',19,3,30,NULL,NULL,'exclusive',85,130,1,1,'9310155008433','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:25:17','2019-04-27 21:25:17',NULL),(318,'Biondi Macaroni No.38 Pasta-500gm',9,'single',19,3,30,NULL,NULL,'exclusive',85,130,1,1,'9310155008501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:27:24','2019-04-27 21:27:24',NULL),(319,'Biondi Spirals No.16 Pasta-500gm',9,'single',19,3,30,NULL,NULL,'exclusive',85,130,1,1,'9310155008464','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:29:04','2019-04-27 21:29:04',NULL),(320,'Biondi Penne Rigate No.18 Pasta-500gm',9,'single',19,3,30,NULL,NULL,'exclusive',85,130,1,1,'9310155008488','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:30:24','2019-04-27 21:30:24',NULL),(321,'Biondi Elbows No.35 Pasta-500gm',9,'single',19,3,30,NULL,NULL,'exclusive',85,130,1,1,'9310155008495','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:31:47','2019-04-27 21:31:47',NULL),(322,'Sunbeam Sunflower Oil 2ltr',9,'single',19,31,29,NULL,NULL,'exclusive',460,575,1,1,'8888011020154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:33:19','2020-09-08 23:33:10',NULL),(323,'Sunbeam Sunflower Oil 5ltr',9,'single',19,31,29,NULL,NULL,'exclusive',1100,1325,1,1,'8888011020413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:34:53','2019-12-24 17:14:02',NULL),(324,'Lotte Cool Mint Peppermint Chewing Gum10.8gm',9,'single',19,20,22,NULL,NULL,'exclusive',20,50,1,1,'8801062322855','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:42:13','2019-06-29 22:21:23',NULL),(325,'Lotte Gum Banana Flavor Stick-12.5gm',9,'single',19,20,22,NULL,NULL,'exclusive',7.5,10,1,1,'8801062118014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:43:35','2019-04-27 21:43:35',NULL),(326,'Lotte Gum Spearmint Flavor Stick-12.5gm',9,'single',19,20,22,NULL,NULL,'exclusive',7.5,10,1,1,'8801062118090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:45:34','2019-04-27 21:45:34',NULL),(327,'Lotte Gum Grape Flavor Stick-12.5gm',9,'single',19,20,22,NULL,NULL,'exclusive',7.5,10,1,1,'8801062118052','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:46:45','2019-04-27 21:46:45',NULL),(328,'Lotte Gum Wooly Booly Gum Stick-12.5gm',9,'single',19,20,22,NULL,NULL,'exclusive',14,20,1,1,'8801062212156','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 21:48:16','2019-04-27 21:48:16',NULL),(329,'Chicken Stock Powder 2.5 kg',9,'single',19,42,50,NULL,NULL,'exclusive',2200,2200,1,1,'8888050330009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:01:32','2019-04-27 23:01:32',NULL),(330,'Oregano Dry Leaves 500gm',9,'single',19,43,50,NULL,NULL,'exclusive',950,950,1,1,'4027400320602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:09:04','2019-04-27 23:09:04',NULL),(331,'Remia Dijon Mustard',9,'single',19,44,32,NULL,NULL,'exclusive',280,280,1,1,'8710448562030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:15:17','2019-04-27 23:15:17',NULL),(332,'St. Delfour Raspberry Jam 284gm',9,'single',19,45,23,NULL,NULL,'exclusive',300,300,1,1,'084380957741','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:18:03','2019-04-27 23:18:03',NULL),(333,'Lacy\"s Baking Paper 40mX100m',9,'single',19,46,48,NULL,NULL,'exclusive',1600,1600,1,1,'8888417002631','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:22:46','2019-04-27 23:22:46',NULL),(334,'Lacy\'s Aluminium Foil (All Purpose) 300mX45cm',9,'single',19,46,48,NULL,NULL,'exclusive',2700,2700,1,1,'8888417003188','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:25:45','2019-04-27 23:25:45',NULL),(335,'Lacy\'s Cling Warp 45cmX300m',9,'single',19,46,48,NULL,NULL,'exclusive',720,720,1,1,'8888417003133','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:32:28','2019-04-27 23:32:28',NULL),(336,'Reynold Aluminium Foil -300mX45cm',9,'single',19,47,48,NULL,NULL,'exclusive',2842,2900,1,1,'10027901026158','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:35:41','2019-04-27 23:35:41',NULL),(337,'Reynold Cling Warp -300mX45cm',9,'single',19,47,48,NULL,NULL,'exclusive',720,720,1,1,'10027901029043','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:37:03','2019-04-27 23:37:03',NULL),(338,'Barilla Pesti Genovese -190ml',9,'single',19,48,32,NULL,NULL,'exclusive',587,587,1,1,'8076809513753','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:40:06','2019-04-27 23:40:06',NULL),(339,'Colmans English Mustard-100gm',9,'single',19,49,32,NULL,NULL,'exclusive',384,384,1,1,'50147311','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:43:21','2019-04-27 23:43:21',NULL),(340,'Heniz Tomato Ketchup-3.23kg',9,'single',19,13,45,NULL,NULL,'exclusive',1080,1080,1,1,'013000678506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:45:43','2019-04-27 23:45:43',NULL),(341,'Heniz Tomato Paste-3.15kg',9,'single',19,13,31,NULL,NULL,'exclusive',1080,1080,1,1,'013000573108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:48:29','2019-04-27 23:48:29',NULL),(342,'Tahani Paste 350gm',9,'single',19,50,31,NULL,NULL,'exclusive',480,480,1,1,'3880008900000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:51:47','2019-04-27 23:51:47',NULL),(343,'Tom Yam Paste 1.5kg Jar',9,'single',19,51,31,NULL,NULL,'exclusive',1400,1400,1,1,'9556024709982','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:54:13','2019-04-27 23:54:13',NULL),(344,'Maple  Syrup 12.5Oz',9,'single',19,52,36,NULL,NULL,'exclusive',1250,1250,1,1,'060501587615','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-27 23:57:03','2019-04-27 23:57:03',NULL),(345,'Casa Fiesta Jalapeno Slice Pepper (All Natural)-340gm',9,'single',19,53,11,NULL,NULL,'exclusive',300,300,1,1,'017600087317','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:02:41','2019-05-09 17:16:32',NULL),(346,'Color Paste Egg Yellow  Jar-3kg',9,'single',19,54,31,NULL,NULL,'exclusive',2880,2880,1,1,'8888263332500','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:08:25','2019-04-28 00:08:25',NULL),(347,'Color Paste Orange Yellow  Jar-3kg',9,'single',19,54,31,NULL,NULL,'exclusive',2880,2880,1,1,'8888263332906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:10:45','2019-04-28 00:10:45',NULL),(348,'Color Paste Rose Pink Jar-3kg',9,'single',19,54,31,NULL,NULL,'exclusive',2880,2880,1,1,'8888263321504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:12:59','2019-04-28 00:12:59',NULL),(349,'Color Paste Sky Blue Jar-3kg',9,'single',19,54,31,NULL,NULL,'exclusive',2880,2880,1,1,'8888263333309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:14:45','2019-04-28 00:14:45',NULL),(350,'Color Paste Violate Jar-3kg',9,'single',19,54,31,NULL,NULL,'exclusive',2880,2880,1,1,'8888263416323','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:17:01','2019-04-28 00:17:01',NULL),(351,'Redman Baking Powder Double Action-5kg',9,'single',19,54,51,NULL,NULL,'exclusive',3100,3100,1,1,'8888263437182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:23:36','2019-04-28 00:23:36',NULL),(352,'Redman Blueberry Pie Filling Wild Whole-2.7kg',9,'single',19,54,43,NULL,NULL,'exclusive',2310,2310,1,1,'8888263417108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:27:02','2019-04-28 00:27:02',NULL),(353,'Redman Cherries Glace Whole Red -5kg',9,'single',19,54,51,NULL,NULL,'exclusive',3250,3250,1,1,'8888263496929','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:33:23','2019-04-28 00:33:23',NULL),(354,'Redman  Dragees Mette Gold Color -800gm',9,'single',19,54,51,NULL,NULL,'exclusive',2176,2176,1,1,'8888263503375','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:35:47','2019-04-28 00:35:47',NULL),(355,'Redman Flavour Lemon-1kg',9,'single',19,54,51,NULL,NULL,'exclusive',2800,2800,1,1,'8888263388002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:38:01','2019-04-28 00:38:01',NULL),(356,'Redman Flavour orange-1kg',9,'single',19,54,51,NULL,NULL,'exclusive',2800,2800,1,1,'8888263335808','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:39:42','2019-04-28 00:39:42',NULL),(357,'Redman Flour  Dark Rye-1kg',9,'single',19,54,51,NULL,NULL,'exclusive',750,750,1,1,'8888263463747','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:41:50','2019-04-28 00:41:50',NULL),(358,'Redman Marachino  Cherries w stem  Red-4.2kg',9,'single',19,54,51,NULL,NULL,'exclusive',2200,2200,1,1,'8888263100321','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:56:37','2019-04-28 00:56:37',NULL),(359,'Redman Vanila Powder -500gm',9,'single',19,54,51,NULL,NULL,'exclusive',1500,1500,1,1,'8888263503320','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 00:59:57','2019-04-28 00:59:57',NULL),(361,'Foster Clarks IFD 2.5kg Tub Orange',9,'single',19,57,52,NULL,NULL,'exclusive',1150,1580,1,1,'5352101494048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 17:41:50','2019-05-08 21:57:54',NULL),(362,'Munchy\'s The Tour Assorted Biscuit can 700gm',9,'single',19,59,5,NULL,NULL,'exclusive',600,850,1,1,'9556439881525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 17:56:23','2019-05-03 19:12:27',NULL),(363,'Munchy\'s Topmix Assorted Biscuit 700gm',9,'single',19,59,5,NULL,NULL,'exclusive',600,825,1,1,'9556439880610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 17:57:41','2020-09-05 19:56:55',NULL),(365,'Munchy\'s Vege Crackers 390gm',9,'single',19,59,42,NULL,NULL,'exclusive',265,350,1,1,'9556439882331','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 17:58:58','2019-05-03 19:10:26',NULL),(366,'Munchy\'s Cream Crackers 300 gm',9,'single',19,59,5,NULL,NULL,'exclusive',265,350,1,1,'9556439880979','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:15:54','2020-09-09 18:11:42',NULL),(367,'Lexus Choco Coated Chocolate 200gm',9,'single',19,59,5,NULL,NULL,'exclusive',210,295,1,1,'9556439886797','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:22:39','2019-05-03 19:00:27',NULL),(368,'Foster Clarks IFD 2.5kg Tub Mango',9,'single',19,57,52,NULL,NULL,'exclusive',1150,1580,1,1,'5352101630958','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:42:21','2019-05-08 16:44:35',NULL),(369,'Captain Munch Choc Chip Original 180gm',9,'single',19,59,18,NULL,NULL,'exclusive',245,295,1,1,'9556439886605','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:45:30','2019-05-03 18:57:13',NULL),(370,'Munchy\'s C.Munch Choc Chip Double 180gm',9,'single',19,59,18,NULL,NULL,'exclusive',245,295,1,1,'9556439886582','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:48:46','2019-05-03 18:59:28',NULL),(371,'Lexus  Vegetable Calcium  Cracker(Poly)',9,'single',19,59,42,NULL,NULL,'exclusive',180,275,1,1,'9556439881990','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:50:58','2019-08-05 19:23:05',NULL),(372,'Foster Clarks IFD 900 Orange',9,'single',19,57,52,NULL,NULL,'exclusive',485,590,1,1,'5352101869167','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:52:03','2019-04-28 18:52:03',NULL),(373,'Oat Krunch Chunky Hazelnut 208gm',9,'single',19,59,42,NULL,NULL,'exclusive',210,275,1,1,'9556439885189','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:53:29','2019-05-08 18:18:09',NULL),(374,'Foster Clarks IFD 900 Mango',9,'single',19,57,52,NULL,NULL,'exclusive',485,590,1,1,'5352101339783','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:54:27','2019-04-28 18:54:27',NULL),(375,'Munchy\'s Oat Krunch D. Chocolate 208gm',9,'single',19,59,42,NULL,NULL,'exclusive',300,275,1,1,'9556439885165','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:54:51','2019-09-22 22:03:07',NULL),(376,'Munchy\'s Lexus Chocolate Sandwich 225gm',9,'single',19,59,42,NULL,NULL,'exclusive',245,325,1,1,'9556439882027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:56:36','2019-05-03 18:39:11',NULL),(377,'Foster Clarks IFD 900 Lemon',9,'single',19,57,52,NULL,NULL,'exclusive',590,590,1,1,'5352101985324','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:57:06','2019-04-28 18:57:06',NULL),(378,'Munchy\'s Lexus Cheese Sandwich 225 gm',9,'single',19,59,42,NULL,NULL,'exclusive',245,325,1,1,'9556439882010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:57:40','2019-05-03 18:37:33',NULL),(379,'Munchy\'s Lexus Peanut Butter Sandwich 225gm',9,'single',19,59,42,NULL,NULL,'exclusive',245,325,1,1,'9556439882003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:59:00','2019-05-03 18:35:30',NULL),(380,'Foster Clarks IFD 750 gm Jar Orange',9,'single',19,57,52,NULL,NULL,'exclusive',450,530,1,1,'5352101157943','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 18:59:14','2019-04-28 18:59:14',NULL),(381,'Lexus Vegetable Calcium  Cracker (Extra 25%)',9,'single',19,59,42,NULL,NULL,'exclusive',200,250,1,1,'9556439880641','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:00:00','2019-04-28 19:00:00',NULL),(382,'Foster Clarks IFD 750 gm Jar Mango',9,'single',19,57,52,NULL,NULL,'exclusive',520,530,1,1,'074265019497','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:01:39','2019-09-09 00:09:45',NULL),(383,'Cyprina Red Grape Juice 250ml',9,'single',19,60,24,NULL,NULL,'exclusive',65,85,1,1,'52920936','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:01:44','2019-04-28 19:01:44',NULL),(384,'Cyprina Apple Juice 250ml',9,'single',19,60,24,NULL,NULL,'exclusive',65,85,1,1,'52920950','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:03:41','2019-04-28 19:03:41',NULL),(385,'Foster Clarks IFD 750 gm Jar Lemon',9,'single',19,57,52,NULL,NULL,'exclusive',520,530,1,0,'5352101180644','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:05:06','2019-09-09 00:11:41',NULL),(386,'Cyprina Mango Nectar (SQ) 1Lt',9,'single',19,60,24,NULL,NULL,'exclusive',300,375,1,1,'5290074003136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:05:29','2019-04-28 19:05:29',NULL),(387,'Cyprina Orange  Vit CAE (SQ) 1Lt',9,'single',19,60,24,NULL,NULL,'exclusive',300,375,1,1,'5290074001705','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:06:46','2019-04-28 19:06:46',NULL),(388,'Foster Clarks IFD 750 gm Jar Pineapple',9,'single',19,57,52,NULL,NULL,'exclusive',450,530,1,1,'5352101440199','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:06:54','2019-04-28 19:06:54',NULL),(389,'Foster Clarks IFD 750 gm Jar Marinda',9,'single',19,57,52,NULL,NULL,'exclusive',465,530,1,1,'5352101564796','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:08:41','2019-05-07 22:26:49',NULL),(390,'Sunlico RBD Sunflower Seed Oil 5.5Ltr',9,'single',19,61,29,NULL,NULL,'exclusive',1100,1200,1,1,'9556145975037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:09:36','2019-04-28 19:09:36',NULL),(391,'Sunlico RBD Sunflower Seed Oil 2ltr',9,'single',19,61,29,NULL,NULL,'exclusive',450,475,1,1,'9556145975020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:11:01','2019-04-28 19:11:01',NULL),(392,'Foster Clarks IFD 750 gm Jar Peach & Appricot',9,'single',19,57,52,NULL,NULL,'exclusive',450,530,1,1,'5352101312793','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:11:32','2019-04-28 19:11:32',NULL),(393,'Sunlico RBD Sunflower Seed Oil 1ltr',9,'single',19,61,29,NULL,NULL,'exclusive',240,280,1,1,'9556145112012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:13:00','2019-04-28 19:13:00',NULL),(394,'WALKERS P.BUTTER SHORTBREAD BIS 150G',9,'single',19,62,46,NULL,NULL,'exclusive',500,570,1,1,'039047001152','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:15:26','2019-04-28 19:15:26',NULL),(396,'RITTER SPORTS FINE MILK CHO 100GM',9,'single',19,64,15,NULL,NULL,'exclusive',245,275,1,1,'4000417021007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:21:36','2019-04-28 19:21:36',NULL),(397,'RITTER SPORTS COCONUT 100GM',9,'single',19,64,15,NULL,NULL,'exclusive',245,275,1,1,'4000417298003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:22:32','2019-04-28 19:22:32',NULL),(398,'RITTER SPORTS HAZELNUTS 100GM',9,'single',19,64,15,NULL,NULL,'exclusive',245,275,1,1,'4000417222008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:23:47','2019-04-28 19:23:47',NULL),(399,'MALTESERS BOX 360GM',9,'single',19,65,15,NULL,NULL,'exclusive',800,900,1,1,'5000159434515','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:25:34','2019-04-28 19:25:34',NULL),(400,'CELEBRATIONS POUCH 450GM',9,'single',19,66,15,NULL,NULL,'exclusive',1050,1200,1,1,'5000159415316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:27:32','2019-04-28 19:27:32',NULL),(401,'SKICKERS 6PCS 300GM',9,'single',19,67,15,NULL,NULL,'exclusive',496,550,1,1,'5000159404259','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:29:27','2019-04-28 19:29:27',NULL),(402,'Super Mini Mix Pouch 650 gm',9,'single',19,68,15,NULL,NULL,'exclusive',1350,1500,1,1,'5000159365369','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:33:34','2019-04-28 19:33:34',NULL),(403,'KINDER CHOCOLATE 8BAR 100GM',9,'single',19,69,15,NULL,NULL,'exclusive',345,390,1,1,'80177616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:35:30','2019-04-28 19:35:30',NULL),(404,'KINDER MAXI 210GM',9,'single',19,69,15,NULL,NULL,'exclusive',475,535,1,1,'4008400221021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:37:36','2019-04-28 19:37:36',NULL),(405,'Camel Shandong Garlic Groundnuts  130g',9,'single',19,58,53,NULL,NULL,'exclusive',150,170,1,1,'8888112140089','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:40:15','2019-04-28 19:40:15',NULL),(406,'Camel Shandong Groundnuts 150gm PKT',9,'single',19,58,53,NULL,NULL,'exclusive',150,170,1,1,'8888112143004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:42:13','2019-04-28 19:42:13',NULL),(407,'Camel Roasted Groundnuts  120gm PKT',9,'single',19,58,53,NULL,NULL,'exclusive',150,170,1,1,'8888112352086','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:43:21','2019-04-28 19:43:21',NULL),(408,'CAMEL WASABI COATED GREEN PEAS 130G CAN',9,'single',19,58,53,NULL,NULL,'exclusive',150,220,1,1,'8888112100199','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:47:30','2019-04-28 19:47:30',NULL),(409,'CAMEL  ROASTED CASHEW 400G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',1050,1150,1,1,'8888112015059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:49:34','2019-04-28 19:49:34',NULL),(410,'Borges Sunflower Oil 5 ltr',9,'single',19,70,29,NULL,NULL,'exclusive',1150,1280,1,1,'8410179013398','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:51:15','2019-04-28 19:51:15',NULL),(411,'CAMEL NATURAL BAKED PISTACHIOS 400G PKT',9,'single',19,53,53,NULL,NULL,'exclusive',1050,1150,1,1,'8888112025058','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:52:02','2019-04-28 19:52:02',NULL),(412,'CAMEL MIXED SNACKS 300G PKT SG',9,'single',19,58,53,NULL,NULL,'exclusive',410,620,1,1,'8888112075008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:53:40','2019-04-28 19:53:40',NULL),(413,'Mister Potato Crisps 45 gm Original',9,'single',19,71,14,NULL,NULL,'exclusive',85,100,1,1,'9557062321129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:54:27','2019-04-28 19:54:27',NULL),(414,'CAMEL MIXED SNACKS 150G PKT SG',9,'single',19,58,53,NULL,NULL,'exclusive',240,325,1,1,'8888112070102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:55:18','2019-08-09 15:38:07',NULL),(415,'Mister Potato Crisps 45 gm Hot & Spicy',9,'single',19,71,14,NULL,NULL,'exclusive',85,100,1,1,'9557062321150','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:56:42','2019-04-28 19:56:42',NULL),(416,'CAMEL ROASTED PEANUTS 150G  PKT',9,'single',19,58,53,NULL,NULL,'exclusive',245,325,1,1,'8888112030137','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:56:49','2019-04-28 19:56:49',NULL),(417,'Mister Potato Crisps 100 gm Original',9,'single',19,71,14,NULL,NULL,'exclusive',140,150,1,1,'9557062331128','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 19:58:58','2019-04-28 19:58:58',NULL),(418,'CAMEL MIXED SNACKS 130G CAN',9,'single',19,58,9,NULL,NULL,'exclusive',275,380,1,1,'8888112070256','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:00:23','2019-04-28 20:00:23',NULL),(419,'Mister Potato Crisps 75 gm BBQ',9,'single',19,71,14,NULL,NULL,'exclusive',110,120,1,1,'9557062301169','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:02:13','2019-04-28 20:02:13',NULL),(420,'CAMEL CRACKER PEANUTS 130G',9,'single',19,58,9,NULL,NULL,'exclusive',275,380,1,1,'8888112060103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:02:15','2019-04-28 20:02:15',NULL),(421,'CAMEL NATURAL NUTTY BERRIES 150G',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112070966','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:04:22','2019-04-28 20:04:22',NULL),(422,'Mister Potato Crisps 75 gm Sour Cream & Onion',9,'single',19,71,14,NULL,NULL,'exclusive',110,120,1,1,'9557062301152','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:04:25','2019-04-28 20:04:25',NULL),(423,'Camel Natural Baked Almond 150g PKT',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112080149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:06:04','2019-04-28 20:06:04',NULL),(424,'Mister Potato Crisps 75 gm Original',9,'single',19,71,14,NULL,NULL,'exclusive',110,120,1,1,'9557062301145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:06:34','2019-04-28 20:06:34',NULL),(425,'Camel Smoked Almond 150g PKT',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112080354','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:07:50','2019-04-28 20:07:50',NULL),(426,'CAMEL NATURAL CASHEW 150G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112010283','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:09:24','2019-04-28 20:09:24',NULL),(427,'Mister Potato Crisps 100 gm Hot & Spicy',9,'single',19,71,14,NULL,NULL,'exclusive',140,150,1,1,'9557062331159','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:10:28','2019-04-28 20:10:28',NULL),(428,'CAMEL CASHEW NUTS ROASTED 150G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112013000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:13:03','2019-04-28 20:13:03',NULL),(429,'Mister Potato Crisps 100 gm BBQ',9,'single',19,71,14,NULL,NULL,'exclusive',140,150,1,1,'9557062331142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:13:25','2019-04-28 20:13:25',NULL),(430,'CAMEL NATURAL PISTACHIOS 150G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112023009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:15:14','2019-04-28 20:15:14',NULL),(431,'Meiji Hello Panda 260 gm Double Choco',9,'single',19,72,5,NULL,NULL,'exclusive',450,485,1,1,'8888077102139','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:17:04','2019-04-28 20:17:04',NULL),(432,'CAMEL NATURAL COCKTAIL MIX 150G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',410,550,1,1,'8888112780148','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:17:05','2019-04-28 20:17:05',NULL),(433,'CAMEL MIXED NUTS ROYAL 130G CAN',9,'single',19,58,9,NULL,NULL,'exclusive',375,450,1,1,'8888112070331','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:18:27','2019-04-28 20:18:27',NULL),(434,'Meiji Hello Panda 260 gm Choco',9,'single',19,72,5,NULL,NULL,'exclusive',450,485,1,1,'8888077102078','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:19:23','2019-04-28 20:19:23',NULL),(435,'CAMEL COCKTAIL MIX NATURAL 130G CAN',9,'single',19,58,9,NULL,NULL,'exclusive',375,450,1,1,'8888112780315','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:19:31','2019-04-28 20:19:31',NULL),(436,'CAMEL NATURAL PISTCHIOS 130G SG',9,'single',19,58,9,NULL,NULL,'exclusive',375,450,1,1,'8888112020169','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:21:05','2019-04-28 20:21:05',NULL),(437,'Meiji Hello Panda 50 gm Strawberry',9,'single',19,72,5,NULL,NULL,'exclusive',95,100,1,1,'8888077102092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:21:42','2019-04-28 20:21:42',NULL),(438,'CAMEL MIXED NUTS LUXURY 130G CAN',9,'single',19,58,9,NULL,NULL,'exclusive',375,450,1,1,'8888112070348','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:22:20','2019-04-28 20:22:20',NULL),(439,'Meiji Hello Panda 50 gm Milk',9,'single',19,72,5,NULL,NULL,'exclusive',95,100,1,1,'8888077108032','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:23:33','2019-04-28 20:23:33',NULL),(441,'Meiji Hello Panda 50 gm Double Choco',9,'single',19,72,5,NULL,NULL,'exclusive',95,100,1,1,'8888077102108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:24:58','2019-04-28 20:24:58',NULL),(442,'CAMEL CRACKER PEANUTS 40 PKT',9,'single',19,58,53,NULL,NULL,'exclusive',75,85,1,1,'8888112061001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:25:24','2019-04-28 20:25:24',NULL),(443,'Meiji Hello Panda 50 gm Choco',9,'single',19,72,5,NULL,NULL,'exclusive',95,100,1,1,'8888077102023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:26:06','2019-04-28 20:26:06',NULL),(444,'CAMEL PEANUTS ROASTED 40G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',75,85,1,1,'8888112031103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:26:25','2019-04-28 20:26:25',NULL),(445,'Camel Mixed Snacks 40G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',75,85,1,1,'8888112071000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:27:30','2019-04-28 20:27:30',NULL),(446,'Borges Olive Oil 1 ltr Extra Virgin',9,'single',19,70,29,NULL,NULL,'exclusive',850,860,1,1,'8410179100012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:28:16','2019-09-10 22:40:43',NULL),(447,'Camel Natural Pistachios 40G PKT',9,'single',19,58,53,NULL,NULL,'exclusive',105,120,1,1,'8888112021005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:28:32','2019-04-28 20:28:32',NULL),(448,'Borges Olive Oil 250 ml Extra Lite',9,'single',19,70,NULL,NULL,NULL,'exclusive',230,235,1,1,'8410179300849','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:33:15','2019-05-26 22:16:05',NULL),(449,'Borges Olive Oil 250 ml Extra Virgin',9,'single',19,70,NULL,NULL,NULL,'exclusive',250,260,1,1,'8410179100050','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:34:38','2019-04-28 20:34:38',NULL),(450,'Calypso Mayonnaise 450 ml',9,'single',19,73,25,NULL,NULL,'exclusive',340,355,1,1,'5352101003103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:41:08','2019-04-28 20:41:08',NULL),(451,'Calypso Mayolite 250 ml',9,'single',19,73,25,NULL,NULL,'exclusive',195,200,1,1,'5352101210334','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:43:08','2019-04-28 20:43:08',NULL),(452,'Calypso Mayonnaise 250 ml',9,'single',19,73,25,NULL,NULL,'exclusive',195,200,1,1,'5352101773167','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:44:46','2019-04-28 20:44:46',NULL),(454,'Calypso Mayonnaise 1000 ml',9,'single',19,73,25,NULL,NULL,'exclusive',640,700,1,1,'5352101392009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:49:36','2019-04-28 20:49:36',NULL),(455,'Calypso Mustard 200 ml',9,'single',19,73,32,NULL,NULL,'exclusive',170,160,1,1,'5352101136658','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:52:23','2019-04-28 20:52:23',NULL),(456,'Umami Sauce 300 ml Chili',9,'single',19,74,32,NULL,NULL,'exclusive',115,120,1,1,'8850534003211','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:54:42','2019-04-28 20:54:42',NULL),(457,'Umami Sauce 300 ml Spring Roll',9,'single',19,74,32,NULL,NULL,'exclusive',170,180,1,1,'8850534100217','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:57:41','2019-04-28 20:57:41',NULL),(458,'Umami Tomato Ketchup 300 ml',9,'single',19,74,32,NULL,NULL,'exclusive',115,120,1,1,'8850534100200','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 20:59:10','2019-04-28 20:59:10',NULL),(459,'Foster Clarks Corn Flour 400 gm Pack',9,'single',19,57,51,NULL,NULL,'exclusive',110,115,1,1,'5352101910814','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:05:33','2019-04-28 21:05:33',NULL),(460,'Sunlee Egg Roll Sauce 750mi',9,'single',19,75,32,NULL,NULL,'exclusive',350,420,1,1,'761934045092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:06:49','2019-04-28 21:06:49',NULL),(461,'Foster Clarks Jelly Crystal/Dessert 85 gm Strawberry',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101006777','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:07:50','2019-04-28 21:07:50',NULL),(462,'Sunlee Sweet Chilli Sauce 750ml',9,'single',19,75,32,NULL,NULL,'exclusive',310,375,1,1,'761934145037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:09:02','2019-04-28 21:09:02',NULL),(463,'Foster Clarks Jelly Crystal/Dessert 85 gm Banana',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101006531','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:09:33','2019-04-28 21:09:33',NULL),(464,'Sunlee Sweet Chilli Sauce 300ml',9,'single',19,75,32,NULL,NULL,'exclusive',135,165,1,1,'761934145013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:10:13','2019-04-28 21:10:13',NULL),(465,'Foster Clarks Jelly Crystal/Dessert 85 gm Lime',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101012822','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:11:20','2019-04-28 21:11:20',NULL),(466,'Sunlee Dark Soya Sauce  630ml',9,'single',19,75,32,NULL,NULL,'exclusive',300,360,1,1,'761934045467','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:11:38','2019-04-28 21:11:38',NULL),(467,'Sunlee Oyster Sauce  630ml',9,'single',19,75,32,NULL,NULL,'exclusive',300,370,1,1,'761934045306','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:13:03','2019-04-28 21:13:03',NULL),(468,'Foster Clarks Jelly Crystal/Dessert 85 gm Cherry',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101009372','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:13:26','2019-04-28 21:13:26',NULL),(469,'Sunlee Coconut Juice 310ml',9,'single',19,75,24,NULL,NULL,'exclusive',105,125,1,1,'761934037035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:14:17','2019-04-28 21:14:17',NULL),(470,'Foster Clarks Baking Powder 110 gm',9,'single',19,57,51,NULL,NULL,'exclusive',80,85,1,1,'5352101825736','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:15:02','2019-04-28 21:15:02',NULL),(471,'Sunlee Rice Stick  400gm',9,'single',19,75,27,NULL,NULL,'exclusive',190,230,1,1,'761934111742','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:15:44','2019-04-28 21:15:44',NULL),(472,'Foster Clarks Bicarbonate Of Soda 150 gm',9,'single',19,57,51,NULL,NULL,'exclusive',110,115,1,1,'5352101665769','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:16:48','2019-04-28 21:16:48',NULL),(473,'Sunlee Jasmine Rice  5kg',9,'single',19,75,54,NULL,NULL,'exclusive',985,1145,1,1,'8858741211719','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:18:21','2019-04-28 21:18:21',NULL),(474,'Foster Clarks Cuatard Powder 300 gm',9,'single',19,57,51,NULL,NULL,'exclusive',150,170,1,1,'5352101719813','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:18:49','2019-04-28 21:18:49',NULL),(475,'Foster Clarks Baking Powder 225 gm',9,'single',19,57,51,NULL,NULL,'exclusive',140,150,1,1,'5352101142611','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:20:44','2019-04-28 21:20:44',NULL),(476,'V Food Variety Vanila Flav 260gm',9,'single',19,76,18,NULL,NULL,'exclusive',250,300,1,1,'8858223007625','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:20:51','2019-04-28 21:20:51',NULL),(477,'V Food Variety Chocolate  260gm',9,'single',19,76,18,NULL,NULL,'exclusive',250,300,1,1,'8858223007618','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:22:19','2019-04-28 21:22:19',NULL),(478,'Foster Clarks Jam 450 gm Raspberry',9,'single',19,57,23,NULL,NULL,'exclusive',450,490,1,1,'5352101999253','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:23:02','2019-04-28 21:23:02',NULL),(479,'V Food Corn Snack BBQ 48gm',9,'single',19,76,44,NULL,NULL,'exclusive',85,100,1,1,'8858223012346','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:23:51','2019-04-28 21:23:51',NULL),(480,'Foster Clarks Jam 450 gm Marmalade',9,'single',19,57,23,NULL,NULL,'exclusive',480,490,1,1,'5352101855917','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:24:55','2019-09-10 22:22:34',NULL),(481,'V Food Corn Snack Honey Butter 48g',9,'single',19,76,44,NULL,NULL,'exclusive',85,100,1,1,'8858223012353','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:25:23','2019-04-28 21:25:23',NULL),(482,'V Food Corn Snack Tomyum 48g',9,'single',19,76,44,NULL,NULL,'exclusive',85,100,1,1,'8858223011998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:26:33','2019-04-28 21:26:33',NULL),(483,'Foster Clarks IFD 450 gm Jar Pineapple',9,'single',19,57,52,NULL,NULL,'exclusive',285,320,1,1,'5352101501890','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:27:34','2019-05-09 17:04:06',NULL),(484,'V Food Mr. Mee Orange  25g',9,'single',19,76,5,NULL,NULL,'exclusive',35,41,1,1,'8858223011837','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:28:21','2019-04-28 21:28:21',NULL),(485,'Foster Clarks IFD 450 gm Jar Orange',9,'single',19,57,52,NULL,NULL,'exclusive',310,320,1,1,'5352101003639','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:29:10','2019-09-09 00:12:49',NULL),(486,'V Food Mr. Mee Milk  25g',9,'single',19,76,5,NULL,NULL,'exclusive',35,41,1,1,'8858223011820','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:29:21','2019-04-28 21:29:21',NULL),(487,'Foster Clarks IFD 450 gm Jar Mango',9,'single',19,57,52,NULL,NULL,'exclusive',310,320,1,1,'5352101037344','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:30:50','2019-09-09 00:13:54',NULL),(488,'V Food Grace Classic Buiscuits Tin 400g',9,'single',19,76,5,NULL,NULL,'exclusive',550,650,1,1,'8858223012858','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:31:13','2019-04-28 21:31:13',NULL),(489,'Foster Clarks Corn Flour 400 gm Tin',9,'single',19,57,NULL,NULL,NULL,'exclusive',185,200,1,1,'5352101958397','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:32:38','2019-04-28 21:32:38',NULL),(490,'V Food Orange Wafers Pkt 100g',9,'single',19,76,55,NULL,NULL,'exclusive',145,175,1,0,'8858223008523','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:34:34','2019-04-28 21:34:34',NULL),(491,'Foster Clarks Essence 28 ml Lemon',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101560125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:36:00','2019-04-28 21:36:00',NULL),(492,'V Food Milk Wafers Pkt 100g',9,'single',19,76,55,NULL,NULL,'exclusive',165,175,1,1,'8858223008516','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:36:16','2019-09-23 22:18:58',NULL),(493,'V Food Chocolate Wafers Pkt 100g',9,'single',19,76,55,NULL,NULL,'exclusive',145,175,1,1,'8858223008578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:38:03','2019-04-28 21:38:03',NULL),(494,'Foster Clarks Essence 28 ml Orange',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101787812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:38:18','2019-04-28 21:41:15',NULL),(495,'Royal Wafer Mango Cream 130g',9,'single',19,78,NULL,NULL,NULL,'exclusive',210,253,1,1,'8858223010328','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:40:42','2019-04-28 21:40:42',NULL),(496,'Royal Wafer Chocolate Cream 130g',9,'single',19,78,55,NULL,NULL,'exclusive',210,253,1,1,'8858223010830','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:42:28','2019-04-28 21:42:28',NULL),(497,'Foster Clarks Food Colour 28 ml Green',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101414022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:44:03','2019-04-28 21:44:03',NULL),(498,'I Mee Cup Noddles (Shrimp) 65g',9,'single',19,79,27,NULL,NULL,'exclusive',110,130,1,1,'8858829601746','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:44:30','2019-04-28 21:44:30',NULL),(499,'Foster Clarks Food Colour 28 ml Blue',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101196515','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:45:45','2019-04-28 21:45:45',NULL),(500,'I Mee Cup Noddles (Vegetable) 65g',9,'single',19,79,27,NULL,NULL,'exclusive',110,130,1,1,'8858829601753','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:46:04','2019-04-28 21:46:04',NULL),(501,'I Mee Cup Noddles (Oriental Beef) 65g',9,'single',19,79,27,NULL,NULL,'exclusive',110,130,1,1,'8858829601135','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:47:10','2019-04-28 21:47:10',NULL),(502,'Foster Clarks Essence 28 ml Mango',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101139512','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:47:33','2019-04-28 21:47:33',NULL),(503,'I Mee Cup Noddles (Chicken) 65g',9,'single',19,79,27,NULL,NULL,'exclusive',110,130,1,1,'8858829601739','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:48:32','2019-04-28 21:49:20',NULL),(504,'Foster Clarks Essence 28 ml Strawberry',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101204616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:49:24','2019-04-28 21:49:24',NULL),(505,'I Mee Cup Noddles (Chicken Curry) 65g',9,'single',19,79,27,NULL,NULL,'exclusive',110,130,1,1,'8858829601142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:50:22','2019-04-28 21:50:22',NULL),(506,'Foster Clarks Food Colour 28 ml Yellow',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101732331','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:50:55','2019-04-28 21:50:55',NULL),(507,'I Mee Cup Noddles (Tomyum)  65g',9,'single',19,79,27,NULL,NULL,'exclusive',110,130,1,1,'8858829601173','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:51:39','2019-04-28 21:51:39',NULL),(508,'Foster Clarks Food Colour 28 ml Red',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101557224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 21:52:05','2019-04-28 21:52:05',NULL),(509,'Foster Clarks Jelly Crystal/Dessert 85 gm Orange',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101007835','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 22:00:12','2019-04-28 22:00:12',NULL),(510,'Foster Clarks Jelly Crystal/Dessert 85 gm Mango',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101674785','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 22:02:06','2019-04-28 22:02:06',NULL),(511,'Foster Clarks Jelly Crystal/Dessert 85 gm Lemon',9,'single',19,57,51,NULL,NULL,'exclusive',70,75,1,1,'5352101727498','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 22:04:12','2019-04-28 22:04:12',NULL),(512,'Foster Clarks Essence 28 ml Chocolate',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101283352','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 22:09:13','2019-07-04 19:08:50',NULL),(513,'Foster Clarks Corn Flour 200 gm',9,'single',19,57,51,NULL,NULL,'exclusive',65,70,1,1,'5352101947193','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 22:11:34','2019-04-28 22:11:34',NULL),(514,'Grante 100% Pure Pomegranate Juice 750 ml',9,'single',19,80,24,NULL,NULL,'exclusive',400,490,1,1,'4760041300021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:11:09','2019-05-21 20:54:20',NULL),(515,'Grante 100% Pure Pomegranate & Grape Juice 750 ml',9,'single',19,80,24,NULL,NULL,'exclusive',400,490,1,1,'4760041300359','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:14:11','2019-05-21 20:52:42',NULL),(516,'Masafi Tropical Juice 2ltr6291001010042',9,'single',19,81,24,NULL,NULL,'exclusive',550,700,1,1,'810135101110','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:17:22','2019-08-05 15:35:16',NULL),(517,'Ceres Hanepoot 100% Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:17:42','2019-04-28 23:17:42',NULL),(518,'Masafi Apple Juice  2ltr',9,'single',19,81,24,NULL,NULL,'exclusive',550,700,1,1,'6291001010028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:19:11','2019-08-05 15:29:58',NULL),(519,'Ceres Red Grape 100% Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100073','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:19:55','2019-04-28 23:19:55',NULL),(520,'Masafi Mango Juice 2ltr',9,'single',19,81,24,NULL,NULL,'exclusive',550,700,1,1,'6291001010035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:20:53','2019-08-05 15:31:56',NULL),(521,'Ceres Passion Fruit Juice 1 L',9,'single',19,82,NULL,NULL,NULL,'exclusive',330,375,1,1,'6001240100127','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:21:45','2019-04-28 23:21:45',NULL),(522,'Masafi Orange Juice 2ltr',9,'single',19,81,24,NULL,NULL,'exclusive',550,700,1,1,'6291001008766','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:22:49','2019-08-05 15:34:04',NULL),(523,'Ceres Lychee 100% Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100295','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:23:54','2019-04-28 23:23:54',NULL),(524,'Masafi Tropical Juice 1ltr',9,'single',19,81,24,NULL,NULL,'exclusive',300,375,1,1,'6291001010080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:25:50','2019-08-05 15:34:45',NULL),(525,'Ceres Guava 100% Juice',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:25:59','2019-04-28 23:25:59',NULL),(526,'Ceres Cranberry & Kiwi Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100288','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:27:14','2019-04-28 23:27:14',NULL),(527,'Masafi Apple Juice 1 lit',9,'single',19,81,24,NULL,NULL,'exclusive',300,375,1,1,'6291001010066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:27:15','2019-08-05 15:30:49',NULL),(528,'Ceres Mango 100% Juice 1 L',9,'single',19,NULL,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100257','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:28:35','2019-04-28 23:28:35',NULL),(529,'Masafi Mango Juice 1 lit',9,'single',19,81,24,NULL,NULL,'exclusive',300,375,1,1,'6291001010073','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:28:47','2019-08-05 15:31:24',NULL),(530,'Masafi Orange Juice 1ltr',9,'single',19,81,24,NULL,NULL,'exclusive',300,375,1,1,'6291001014200','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:30:17','2019-08-05 15:32:45',NULL),(531,'Ceres Orange 100% Juice 1 L',9,'single',19,NULL,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:31:42','2019-04-28 23:31:42',NULL),(532,'Ceres Apple 100% Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:33:49','2019-04-28 23:33:49',NULL),(533,'Ceres Pineapple 100% Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:35:43','2019-04-28 23:35:43',NULL),(534,'Ceres Orange 100% Juice 200 ml',9,'single',19,82,24,NULL,NULL,'exclusive',80,85,1,1,'6001240200056','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:40:31','2019-04-28 23:40:31',NULL),(535,'Ceres Apple 100% Juice 200 ml',9,'single',19,82,24,NULL,NULL,'exclusive',80,85,1,1,'6001240200018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:42:23','2019-04-28 23:42:23',NULL),(536,'Ceres Mango Juice 200 ml',9,'single',19,NULL,24,NULL,NULL,'exclusive',80,85,1,1,'6001240200254','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:47:06','2019-04-28 23:47:06',NULL),(537,'Dewland\'s Red Grape Juice 1ltr',9,'single',19,83,24,NULL,NULL,'exclusive',300,365,1,1,'6007359000532','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:50:44','2019-04-28 23:50:44',NULL),(538,'Dewland\'s Passion Fruits Juice  1ltr',9,'single',19,83,24,NULL,NULL,'exclusive',300,375,1,1,'6007359000594','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:52:42','2019-04-29 00:00:12',NULL),(539,'Dewland\'s Mango  Juice 1ltr',9,'single',19,83,24,NULL,NULL,'exclusive',300,375,1,1,'6007359000570','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:54:03','2019-04-28 23:54:03',NULL),(540,'Dewland\'s Fruits Cocktail  Juice  1ltr',9,'single',19,83,24,NULL,NULL,'exclusive',300,365,1,1,'6007359000563','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:56:22','2019-04-28 23:58:09',NULL),(541,'Dewland\'s Apple Juice  1ltr',9,'single',19,83,24,NULL,NULL,'exclusive',300,265,1,1,'6007359000525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-28 23:57:29','2019-04-28 23:57:29',NULL),(542,'C V Mallow OMICO STRAWBERRY SANDWICH COOKIE 100g',9,'single',19,85,18,NULL,NULL,'exclusive',105,125,1,1,'9556793600046','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:42:08','2019-04-29 18:46:01',NULL),(543,'C V Mallow OMICO CHOCOLATE SANDWICH COOKIE 100g',9,'single',19,85,18,NULL,NULL,'exclusive',105,125,1,1,'9556793600008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:45:20','2019-04-29 18:45:20',NULL),(544,'C V Mallow OMICO MILK SANDWICH COOKIE 100g',9,'single',19,85,18,NULL,NULL,'exclusive',105,125,1,1,'9556793600022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:48:10','2019-04-29 18:48:10',NULL),(545,'Cowhead Pure Milk 1lt',9,'single',19,84,NULL,NULL,NULL,'exclusive',185,200,1,1,'8888440000048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:48:11','2020-09-08 16:20:05',NULL),(546,'Cowhead Low Fat 1lt',9,'single',19,84,26,NULL,NULL,'exclusive',190,220,1,1,'8888440007108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:50:17','2019-10-18 21:18:03',NULL),(547,'C V Mallow ICE CREAMS CONE CHOCOLATE STEAM BUNS 22g',9,'single',19,85,15,NULL,NULL,'exclusive',35,45,1,1,'9556793700074','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:51:38','2019-04-29 18:51:38',NULL),(548,'Cowhead Chocolate Milk 1lt',9,'single',19,84,26,NULL,NULL,'exclusive',210,265,1,1,'8888440001762','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:51:51','2020-09-15 15:52:28',NULL),(549,'C V Mallow ICE CREAMS CONE CHOCOLATE RiCE CRISPY 22g',9,'single',19,85,18,NULL,NULL,'exclusive',35,45,1,1,'9556793700036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:52:38','2019-04-29 18:52:38',NULL),(550,'MILO 600GM',9,'single',19,63,4,NULL,NULL,'exclusive',410,490,1,1,'8850127009873','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:55:22','2019-04-29 18:55:22',NULL),(551,'MILO 300GM',9,'single',19,63,4,NULL,NULL,'exclusive',210,255,1,1,'8850127010213','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:56:51','2019-04-29 18:56:51',NULL),(552,'TIM TAM BISCUIT ( CHOCO CHOCOLATE ) 94.5g',9,'single',19,86,5,NULL,NULL,'exclusive',105,130,1,1,'8886015428136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:58:44','2019-04-29 18:58:44',NULL),(553,'Oreo Mini Biscuit 65gm Chocolate',9,'single',19,87,5,NULL,NULL,'exclusive',90,105,1,1,'7622300761363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 18:59:01','2020-09-18 01:25:08',NULL),(554,'FOXS CANDY ( FRUIT) Tin 180g',9,'single',19,88,7,NULL,NULL,'exclusive',175,185,1,1,'8992696415409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:00:58','2019-08-31 16:15:07',NULL),(556,'Nestle Coffee Mate Jar 400gm',9,'single',19,63,37,NULL,NULL,'exclusive',260,280,1,1,'8850124011053','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:02:32','2019-06-28 20:09:36',NULL),(557,'FOXS CANDY  ( MINTS ) 90g',9,'single',19,88,7,NULL,NULL,'exclusive',75,90,1,1,'8992696418967','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:02:57','2019-04-29 19:02:57',NULL),(558,'FOXS CANDY  ( FRUITY MINTS ) 90g',9,'single',19,88,7,NULL,NULL,'exclusive',75,90,1,1,'8992696416611','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:04:06','2019-04-29 19:04:06',NULL),(559,'FOXS CANDY  ( FRUITS ) 90g',9,'single',19,88,7,NULL,NULL,'exclusive',75,90,1,1,'8992696418936','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:05:11','2019-04-29 19:05:11',NULL),(560,'FOXS CANDY  ( BERRIES )  90g',9,'single',19,88,7,NULL,NULL,'exclusive',75,90,1,1,'8992696417250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:06:35','2019-04-29 19:06:35',NULL),(561,'Nestle Milo 400gm Tin',9,'single',19,63,52,NULL,NULL,'exclusive',290,345,1,1,'8888082117722','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:06:39','2020-09-16 21:54:56',NULL),(562,'Cowhead Danish Butter Cookies 400gm',9,'single',19,84,18,NULL,NULL,'exclusive',555,670,1,1,'8888440010627','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:13:54','2019-04-29 19:16:36',NULL),(563,'Cowhead Danish Butter Cookies 150gm',9,'single',19,84,18,NULL,NULL,'exclusive',255,310,1,1,'8888440010610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:15:51','2019-04-29 19:15:51',NULL),(564,'Al-Shifa Black Forest Honey 250 ml',9,'single',19,89,56,NULL,NULL,'exclusive',535,600,1,1,'6281073210549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:25:50','2019-05-18 15:46:54',NULL),(565,'Inci Sunflower Oil  5ltr',9,'single',19,90,29,NULL,NULL,'exclusive',940,1190,1,1,'8697413482886','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:25:52','2020-07-18 16:28:20',NULL),(566,'Al-Shifa Black Forest Honey 125 ml',9,'single',19,89,56,NULL,NULL,'exclusive',310,360,1,0,'6281073210785','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:27:34','2019-05-18 15:46:32',NULL),(567,'Mutlu Pasta- Penne 500g',9,'single',19,91,30,NULL,NULL,'exclusive',90,130,1,1,'8690946190006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:32:25','2019-05-03 16:54:45',NULL),(568,'Mutlu Pasta- Big Perline 500g',9,'single',19,91,30,NULL,NULL,'exclusive',90,130,1,1,'8690946250182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:36:08','2019-04-29 19:36:08',NULL),(569,'Mutlu Pasta- Fusilli 500g',9,'single',19,91,30,NULL,NULL,'exclusive',90,130,1,1,'8690946250168','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:38:51','2019-04-29 19:38:51',NULL),(570,'Mutlu Pasta- Spaghetti 500g',9,'single',19,91,30,NULL,NULL,'exclusive',90,130,1,1,'8690946250014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:44:56','2019-04-29 19:44:56',NULL),(571,'Hibiscus Red kidney beans 425g',9,'single',19,92,11,NULL,NULL,'exclusive',70,95,1,1,'6935789874150','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:50:31','2019-04-29 19:50:31',NULL),(572,'Hibiscus Green Peas 425g',9,'single',19,92,11,NULL,NULL,'exclusive',65,80,1,1,'6935789874167','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:52:05','2019-04-29 19:52:05',NULL),(573,'Hibiscus Sweet Corn 425g',9,'single',19,92,11,NULL,NULL,'exclusive',55,65,1,1,'8848701050779','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:54:04','2019-04-29 19:54:04',NULL),(574,'Champion Mushroom  400g',9,'single',19,93,11,NULL,NULL,'exclusive',65,80,1,1,'6932017121208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:56:26','2019-05-10 20:20:25',NULL),(575,'Hibiscus Mushroom (Whole) 425g',9,'single',19,92,11,NULL,NULL,'exclusive',70,85,1,1,'6935789050677','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 19:58:35','2019-04-29 19:58:35',NULL),(576,'Yowe Bread Crumbs 200g',9,'single',19,94,51,NULL,NULL,'exclusive',85,100,1,1,'9555218702563','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:02:15','2019-04-29 20:02:15',NULL),(577,'Saporito BBQ Sauce 510g',9,'single',19,95,32,NULL,NULL,'exclusive',255,305,1,1,'9555218709739','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:03:46','2019-04-29 20:03:46',NULL),(578,'Ayum Tuna Mayonaise  185g',9,'single',19,96,25,NULL,NULL,'exclusive',285,345,1,11,'9556041604246','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:05:26','2019-04-29 20:05:26',NULL),(579,'Ayum Tuna Lite Chunk in Olive Oil 185 g',9,'single',19,96,8,NULL,NULL,'exclusive',285,345,1,1,'9556041604505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:06:59','2019-05-26 22:15:24',NULL),(580,'Ayum Tuna in Sunflower Oil 185g',9,'single',19,96,8,NULL,NULL,'exclusive',285,345,1,1,'9556041604208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:08:09','2019-04-29 20:08:09',NULL),(581,'Pure Heaven Sparkling 100% Red Grape 750ml',9,'single',19,41,12,NULL,NULL,'exclusive',335,400,1,1,'5032619300009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:11:06','2019-04-29 20:23:08',NULL),(582,'Premier Salute Red Grape Drinks 750ml',9,'single',19,97,12,NULL,NULL,'exclusive',335,400,1,1,'8410635294026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:26:50','2019-04-29 20:26:50',NULL),(583,'Premier Salute Peach Drinks 750ml',9,'single',19,97,12,NULL,NULL,'exclusive',330,400,1,1,'5410746064641','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:28:05','2019-04-29 20:28:05',NULL),(584,'Star Jus Mango 2 Lt',9,'single',19,98,24,NULL,NULL,'exclusive',465,560,1,0,'9555038403688','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:35:54','2019-04-29 20:35:54',NULL),(585,'Star Jus Mango 1 Lt',9,'single',19,98,24,NULL,NULL,'exclusive',250,300,1,1,'9555038403169','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:36:55','2019-04-29 20:36:55',NULL),(586,'Nestle Coffee Mate 1kg',9,'single',19,63,37,NULL,NULL,'exclusive',390,490,1,1,'8850124074553','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:45:02','2019-06-16 18:28:56',NULL),(587,'Quaker White Oats 500gm',9,'single',19,99,28,NULL,NULL,'exclusive',230,270,1,1,'8710100101218','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:49:05','2019-04-29 20:49:05',NULL),(588,'Kopiko Cappuccino Candy 150gm',9,'single',19,100,7,NULL,NULL,'exclusive',75,90,1,1,'8996001320136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 20:54:00','2019-04-29 20:54:00',NULL),(589,'Pringles Original 149 gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,250,1,1,'038000138416','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:04:57','2019-06-20 16:30:52',NULL),(590,'GuyLian Gourmet Chocolate 215g',9,'single',19,102,15,NULL,NULL,'exclusive',920,1300,1,1,'5410976619017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:21:39','2019-04-29 21:21:39',NULL),(591,'GuyLian Belgian Original Sea Shell  125g',9,'single',19,102,15,NULL,NULL,'exclusive',515,620,1,1,'5410976321019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:24:44','2019-08-05 17:32:49',NULL),(592,'Biondi Trivelle No.17 Pasta-500gm',9,'single',19,3,30,NULL,NULL,'exclusive',90,130,1,1,'9310155008471','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:27:01','2019-05-08 21:38:07',NULL),(593,'GuyLian La Belgian Trufflina 90g',9,'single',19,102,15,NULL,NULL,'exclusive',485,600,1,1,'5410976293019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:27:43','2019-08-05 17:34:34',NULL),(594,'GuyLian La Treffilna Chocolate  180g',9,'single',19,102,15,NULL,NULL,'exclusive',885,1200,1,1,'5410976539124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:29:30','2019-04-29 21:29:30',NULL),(595,'GuyLian Chocolate  250g',9,'single',19,102,15,NULL,NULL,'exclusive',975,1350,1,1,'5410976140122','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:31:16','2019-08-05 17:32:13',NULL),(596,'GuyLian Belgian Chocolate Less Exclu 305g',9,'single',19,102,15,NULL,NULL,'exclusive',1360,1700,1,1,'5410976620013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:33:43','2019-08-05 17:36:32',NULL),(597,'Lotte Choco Pie 12Packs 336gm',9,'single',19,20,5,NULL,NULL,'exclusive',0,0,1,1,'8901123005403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:33:51','2019-04-29 21:33:51',NULL),(598,'GuyLian Belgian Chocolate Opus 180g',9,'single',19,102,15,NULL,NULL,'exclusive',885,1200,1,1,'5410976271017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:35:14','2019-08-05 17:35:28',NULL),(600,'Fox Candy tin Barries 180g',9,'single',19,88,7,NULL,NULL,'exclusive',165,220,1,1,'8992696418509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:36:49','2019-07-30 16:57:43',NULL),(601,'Pringles Sour Cream & Onion 150gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,250,1,1,'8000138430','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:37:15','2019-04-29 21:37:15',NULL),(602,'Fox candy Tin Fruty  Mint 180g',9,'single',19,88,7,NULL,NULL,'exclusive',155,190,1,1,'8992696418912','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:38:59','2019-04-29 21:38:59',NULL),(603,'Lipton green Tea Classic 100pcs 150g',9,'single',19,103,37,NULL,NULL,'exclusive',550,650,1,1,'6281006863965','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:42:09','2020-09-08 16:41:05',NULL),(604,'Pringles Sour Cream & Onion 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,250,1,1,'038000138430','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:43:16','2019-06-20 16:33:02',NULL),(605,'BIG BBUL FILIFULY GUM WATERMELON 11g',9,'single',19,104,22,NULL,NULL,'exclusive',78,100,1,1,'6921211112068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:44:37','2019-07-30 16:41:42',NULL),(606,'Pringles Pizza 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',200,250,1,1,'038000138638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:45:16','2019-08-06 19:52:51',NULL),(607,'BIG BBUL FILIFULY GUM GRAP 11g',9,'single',19,104,22,NULL,NULL,'exclusive',78,100,1,1,'6921211112006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:45:46','2019-07-30 16:44:26',NULL),(608,'Pringles Honey Mustard 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',200,250,1,1,'038000183928','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:46:53','2019-08-06 19:51:44',NULL),(609,'BIG BBUL FILIFULY GUM STRAWBERRY 11g',9,'single',19,104,22,NULL,NULL,'exclusive',78,100,1,1,'6921211111559','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:46:58','2019-07-30 16:43:32',NULL),(610,'BIG BBUL FILIFULY GUM FRUIT 11g',9,'single',19,104,22,NULL,NULL,'exclusive',78,100,1,1,'6921211111467','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:48:11','2019-07-30 16:45:17',NULL),(611,'Pringles Ranch 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',200,250,1,1,'038000138720','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:49:18','2019-08-06 19:52:14',NULL),(612,'ZED LOLY POP JAR STRAWBERRY  25g',9,'single',19,106,57,NULL,NULL,'exclusive',45,50,1,1,'53993540','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:53:30','2019-05-08 22:21:05',NULL),(613,'ZED LOLY POP JAR COLA 25g',9,'single',19,106,57,NULL,NULL,'exclusive',45,50,1,1,'53993557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:56:20','2019-05-08 22:23:05',NULL),(614,'Hosen Lychee in Syrup-565gm',9,'single',19,14,43,NULL,NULL,'exclusive',0,0,1,1,'8888192820055','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 21:58:57','2020-07-23 00:13:28',NULL),(615,'WALWEL FRESH & FRUITY PURE FRUIT 800g',9,'single',19,108,7,NULL,NULL,'exclusive',1100,1300,1,1,'5900102018055','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:01:55','2019-04-29 22:01:55',NULL),(616,'WALWEL FRESH & FRUITY KWASNE 800g',9,'single',19,108,7,NULL,NULL,'exclusive',1100,1300,1,1,'5900102019267','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:03:56','2019-04-29 22:03:56',NULL),(617,'Trident Tropical Twist Gum 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',100,145,1,1,'070221008727','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:05:55','2019-04-29 22:05:55',NULL),(618,'Hosen Green Stuffed Olive-350gm',9,'single',19,14,11,NULL,NULL,'exclusive',0,0,1,1,'8888192951407','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:07:16','2019-04-29 22:07:16',NULL),(619,'Trident Cinnamon Gum 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',100,145,1,1,'070221008642','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:07:34','2019-04-29 22:07:34',NULL),(620,'Nuttos Organic Mixed Nuts 400gm',9,'single',19,107,53,NULL,NULL,'exclusive',580,610,1,1,'9555047104385','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:07:55','2019-06-29 16:47:32',NULL),(621,'Trident Watermelon Twist Gum 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',100,145,1,1,'070221008741','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:08:30','2019-04-29 22:08:30',NULL),(622,'Galaxy Minis 400g',9,'single',19,110,15,NULL,NULL,'exclusive',950,1125,1,1,'6294001824572','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:11:12','2019-04-29 22:11:12',NULL),(624,'Galaxy milk Hazelnut pkt 150g',9,'single',19,110,15,NULL,NULL,'exclusive',500,620,1,1,'6294001820338','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:17:09','2019-04-29 22:17:09',NULL),(625,'Galaxy White 40g',9,'single',19,110,3,NULL,NULL,'exclusive',100,120,1,1,'6294001824176','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:18:38','2019-04-29 22:18:38',NULL),(626,'Galaxy Hazelnut 40g',9,'single',19,110,3,NULL,NULL,'exclusive',100,120,1,1,'6221134000986','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:19:53','2019-04-29 22:19:53',NULL),(627,'Galaxy Caramel 40g',9,'single',19,110,3,NULL,NULL,'exclusive',100,120,1,1,'6294001821670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:21:14','2019-04-29 22:21:14',NULL),(628,'Galaxy Smooth milk 40g',9,'single',19,110,3,NULL,NULL,'exclusive',105,120,1,1,'6221134001068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:22:18','2019-08-31 15:59:33',NULL),(629,'Good Morning Coffee 50gm',9,'single',19,112,16,NULL,NULL,'exclusive',140,140,1,1,'8904140400060','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:26:00','2019-04-29 22:26:00',NULL),(630,'Hersheys Kisses Cookies milk 40g',9,'single',19,111,3,NULL,NULL,'exclusive',100,125,1,1,'753854500102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:27:58','2019-04-29 22:27:58',NULL),(631,'Nescafe Original 200gm',9,'single',19,63,16,NULL,NULL,'exclusive',335,335,1,1,'8992696406711','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:28:31','2019-04-29 22:28:31',NULL),(632,'Hersheys Kisses Cookies & Cream 40g',9,'single',19,111,3,NULL,NULL,'exclusive',100,120,1,1,'753854500089','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:29:29','2019-04-29 22:29:29',NULL),(633,'Hersheys Kisses Cookies chocolate 40g',9,'single',19,111,3,NULL,NULL,'exclusive',100,120,1,1,'753854500065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:32:04','2019-04-29 22:32:04',NULL),(634,'Mellow Twist 160g',9,'single',19,113,15,NULL,NULL,'exclusive',330,440,1,1,'5032860010450','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:36:09','2019-04-29 22:36:09',NULL),(635,'Sweet Zone Mighty Mallows 140g',9,'single',19,113,15,NULL,NULL,'exclusive',225,300,1,1,'5032860040396','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:37:38','2019-05-10 18:21:50',NULL),(636,'Love Candy Strawberry MINT 150gm',9,'single',19,114,7,NULL,NULL,'exclusive',85,85,1,1,'8850632200260','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:37:38','2019-04-29 22:53:30',NULL),(637,'Love Candy Mango 150gm',9,'single',19,114,7,NULL,NULL,'exclusive',85,85,1,1,'8850632200062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:39:39','2019-04-29 22:39:39',NULL),(638,'Kinder Bueno  White 39g',9,'single',19,69,3,NULL,NULL,'exclusive',100,120,1,1,'80761761','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:40:15','2020-10-26 18:15:00',NULL),(639,'Kinder Bueno 43g',9,'single',19,69,3,NULL,NULL,'exclusive',100,120,1,1,'80052760','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:41:42','2019-04-29 22:41:42',NULL),(640,'Ferrero Rocher T-3 ( 37.5gm)-48 pcs',9,'single',19,115,15,NULL,NULL,'exclusive',120,145,1,1,'80050278','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:44:14','2019-05-13 21:28:22',NULL),(641,'Ferrero Raffaello T-3  (30gm)-48 pcs',9,'single',19,115,15,NULL,NULL,'exclusive',120,145,1,1,'80052487','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:45:33','2019-04-29 22:45:33',NULL),(642,'Ferrero Rocher Collection T-20 (269.4g)',9,'single',19,115,15,NULL,NULL,'exclusive',1450,1650,1,1,'8000500247167','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:48:46','2019-04-29 22:48:46',NULL),(643,'Ferrero RocherChocolate t. 16 (200g)',9,'single',19,115,15,NULL,NULL,'exclusive',600,700,1,1,'8000500037874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:50:18','2019-04-29 22:50:18',NULL),(644,'Toblerone Yellow Chocolate 50g',9,'single',19,116,15,NULL,NULL,'exclusive',100,105,1,1,'76145513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:54:49','2019-04-29 22:54:49',NULL),(645,'Toblerone Mini Swiss Milk Chocolate pkt 200g',9,'single',19,116,15,NULL,NULL,'exclusive',365,495,1,1,'7622210392589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:56:18','2019-04-29 22:56:18',NULL),(646,'Love Candy Strawberry  Sweet 150gm',9,'single',19,114,7,NULL,NULL,'exclusive',85,85,1,1,'8850632200017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:56:39','2019-05-03 22:41:11',NULL),(647,'Toblerone Yellow Chocolate 35g',9,'single',19,116,15,NULL,NULL,'exclusive',75,95,1,1,'76145759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:58:56','2019-04-29 22:58:56',NULL),(648,'Love Candy Orange 150gm',9,'single',19,114,7,NULL,NULL,'exclusive',85,85,1,1,'8850632203629','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 22:59:06','2019-05-03 22:45:28',NULL),(649,'Toblerone Chocolate 100gm Dark',9,'single',19,116,15,NULL,NULL,'exclusive',175,245,1,1,'7614500010617','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:01:13','2020-10-02 21:44:25',NULL),(650,'Toblerone Chocolate 100gm White',9,'single',19,116,15,NULL,NULL,'exclusive',175,245,1,1,'7614500010310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:03:05','2020-07-18 20:51:33',NULL),(651,'Toblerone Chocolate 100gm',9,'single',19,116,15,NULL,NULL,'exclusive',175,245,1,1,'7614500010013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:05:37','2020-10-02 21:45:04',NULL),(652,'China Candy Apple 100gm',9,'single',19,NULL,7,NULL,NULL,'exclusive',75,75,1,1,'6930243001158','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:05:37','2019-04-29 23:05:37',NULL),(653,'Nestle kitkat mini moments 272.5g',9,'single',19,63,15,NULL,NULL,'exclusive',920,1125,1,1,'6294003574147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:08:09','2019-05-13 23:33:41',NULL),(654,'China Candy Orange  100gm',9,'single',19,NULL,7,NULL,NULL,'exclusive',75,75,1,1,'6930243001141','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:10:01','2019-04-29 23:10:01',NULL),(655,'Nestle Quality Street Choco.&Toffe 480g',9,'single',19,63,15,NULL,NULL,'exclusive',950,1100,1,1,'5000189327290','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:10:23','2019-04-29 23:10:23',NULL),(656,'Nestle Quality Street Choco.&Toffe 240g',9,'single',19,63,15,NULL,NULL,'exclusive',550,650,1,1,'50251100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:11:52','2019-04-29 23:11:52',NULL),(657,'Snickers 50gm',9,'single',19,117,15,NULL,NULL,'exclusive',50,50,1,1,'5000159461122','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:13:10','2019-04-29 23:13:10',NULL),(658,'Nestle Kit Kat 4 Finger Normal 41.50g',9,'single',19,63,15,NULL,NULL,'exclusive',60,95,1,1,'40052410','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:14:09','2019-04-29 23:14:09',NULL),(659,'Nestle Kit Kat 2 Finger 20.5g',9,'single',19,63,15,NULL,NULL,'exclusive',35,42,1,1,'6294003532956','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:15:53','2019-04-29 23:15:53',NULL),(660,'Bounty Chocolate Bar 57gm',9,'single',19,118,15,NULL,NULL,'exclusive',60,60,1,1,'40111216','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:16:33','2019-04-29 23:16:33',NULL),(661,'Nestle Kitkat 4 finger white  41.5g',9,'single',19,63,15,NULL,NULL,'exclusive',80,110,1,1,'7613035510999','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:17:30','2019-04-29 23:17:30',NULL),(662,'Nestle Kitkat 4 finger Dark  41.5g',9,'single',19,63,15,NULL,NULL,'exclusive',90,110,1,1,'7613035510104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:19:09','2019-11-02 22:06:40',NULL),(663,'Soan Papdi Smooth & Soft 500gm',9,'single',19,119,17,NULL,NULL,'exclusive',195,195,1,1,'8901721001500','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:20:42','2019-04-29 23:20:42',NULL),(664,'Celebration bottle 320g',9,'single',19,66,15,NULL,NULL,'exclusive',950,1100,1,1,'5000159432504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:21:52','2019-04-29 23:21:52',NULL),(665,'Soan Papdi Smooth & Soft 200gm',9,'single',19,119,17,NULL,NULL,'exclusive',100,100,1,1,'8901721001517','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:24:05','2019-04-29 23:24:05',NULL),(666,'Maltesers Chocolate 37g',9,'single',19,65,15,NULL,NULL,'exclusive',80,105,1,1,'5000159020312','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:25:17','2019-04-29 23:25:17',NULL),(667,'Snickers minis Pkt 500g',9,'single',19,120,15,NULL,NULL,'exclusive',850,1100,1,1,'5000159364874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:27:23','2019-04-29 23:27:23',NULL),(668,'Bounty minis Pkt 500g',9,'single',19,122,NULL,NULL,NULL,'exclusive',900,1100,1,1,'5000159364898','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:29:21','2019-09-29 15:03:51',NULL),(669,'Nutcandy Sakura Plum',9,'single',19,121,51,NULL,NULL,'exclusive',205,205,1,1,'8855282101448','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:29:25','2020-08-27 23:04:00',NULL),(670,'Cho Cho Chocolate Strawberry Cup 40gm',9,'single',19,123,15,NULL,NULL,'exclusive',45,55,1,1,'8992952924461','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:37:32','2019-04-30 22:39:17',NULL),(671,'Twix minis pkt 500g',9,'single',19,124,15,NULL,NULL,'exclusive',850,1100,1,1,'5000159364911','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:41:07','2019-04-29 23:41:07',NULL),(672,'Mars Miniatures Chocolates pkt 500g',9,'single',19,125,15,NULL,NULL,'exclusive',850,1100,1,1,'5000159364850','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:44:30','2019-04-29 23:44:30',NULL),(673,'Pringles Original 42gm',9,'single',19,101,14,NULL,NULL,'exclusive',85,85,1,1,'8886467100260','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:50:10','2019-04-29 23:50:10',NULL),(674,'Skittles Fruits Chocolates pkt 55g',9,'single',19,126,15,NULL,NULL,'exclusive',90,124,1,1,'50159338','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:50:11','2019-04-29 23:50:11',NULL),(675,'Skittles Crazy Sours Chocolate pkt 55g',9,'single',19,126,15,NULL,NULL,'exclusive',90,124,1,0,'5000159314985','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:51:40','2019-04-29 23:51:40',NULL),(676,'Pringles Sour Cream & Onion 42gm',9,'single',19,101,14,NULL,NULL,'exclusive',85,85,1,1,'8886467100246','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:51:55','2019-04-29 23:51:55',NULL),(677,'Mars Miniatures Chocolates pkt 220 gm',9,'single',19,125,15,NULL,NULL,'exclusive',450,550,1,1,'5000159452847','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:54:56','2019-08-31 16:04:45',NULL),(678,'Twix Miniatures Chocolates pkt 220g',9,'single',19,124,15,NULL,NULL,'exclusive',420,550,1,1,'5000159452885','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:56:12','2019-04-29 23:56:12',NULL),(679,'Snickers Miniatures Chocolates pkt 220g',9,'single',19,120,15,NULL,NULL,'exclusive',450,550,1,1,'5000159452861','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-29 23:57:40','2019-08-31 16:07:06',NULL),(680,'Bounty Miniatures Chocolates pkt 220g',9,'single',19,122,15,NULL,NULL,'exclusive',445,550,1,1,'5000159452908','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:01:37','2019-07-30 17:41:50',NULL),(681,'Celebrations Chocolate Pkt 240g',9,'single',19,66,15,NULL,NULL,'exclusive',620,650,1,1,'5000159440622','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:02:52','2019-08-31 16:08:38',NULL),(682,'Celebrations Chocolate Box pkt 380g',9,'single',19,66,15,NULL,NULL,'exclusive',950,1100,1,1,'5000159457897','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:04:50','2019-08-31 15:35:07',NULL),(683,'Celebrations Chocolate B0x pkt 240g',9,'single',19,66,15,NULL,NULL,'exclusive',550,750,1,1,'5000159457873','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:06:39','2019-04-30 00:06:39',NULL),(684,'M&M Tin',9,'single',19,127,15,NULL,NULL,'exclusive',600,700,1,1,'5000159489171','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:08:04','2019-04-30 00:08:04',NULL),(685,'Vitalia Vegetal Cocoa Cream-230gm',9,'single',19,1,41,NULL,NULL,'exclusive',0,0,1,1,'5310099002195','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:08:48','2019-04-30 00:08:48',NULL),(686,'M&M Peanut 45g',9,'single',19,127,15,NULL,NULL,'exclusive',80,80,1,1,'40111445','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:10:59','2020-11-10 23:40:48',NULL),(687,'M&M Choco Chocolate  55g',9,'single',19,127,15,NULL,NULL,'exclusive',80,80,1,1,'40111490','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:12:55','2020-11-06 22:01:37',NULL),(688,'Kikkoman Japanese Grill 250ml',9,'single',19,17,32,NULL,NULL,'exclusive',0,0,1,1,'4501515359330','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:19:32','2019-04-30 00:19:32',NULL),(689,'Kellogs Choccos 250gm',9,'single',19,128,21,NULL,NULL,'exclusive',235,280,1,1,'8901499007957','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:21:17','2019-10-03 14:42:59',NULL),(691,'Kikkoman Teriyaki Marinda Original -250ml',9,'single',19,17,32,NULL,NULL,'exclusive',440,500,1,1,'4901515331794','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:22:29','2019-05-16 01:41:20',NULL),(692,'Kikkoman Teriyaki Marinda Think -250ml',9,'single',19,17,32,NULL,NULL,'exclusive',440,500,1,1,'4901515339813','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:24:47','2019-05-16 01:41:58',NULL),(693,'Kellogs Choccos Crunchy Bites 390gm',9,'single',19,128,21,NULL,NULL,'exclusive',350,350,1,0,'8901499008817','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:27:14','2019-04-30 00:27:14',NULL),(694,'Twix Chocolate  50g',9,'single',19,124,15,NULL,NULL,'exclusive',80,103,1,1,'5000159459228','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:28:19','2019-04-30 00:28:19',NULL),(695,'Cadbury Bubble 28g',9,'single',19,129,15,NULL,NULL,'exclusive',90,120,1,1,'7622210077660','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:30:28','2019-04-30 00:30:28',NULL),(696,'Kellogs Corn Flakes 250 gm',9,'single',19,128,21,NULL,NULL,'exclusive',195,195,1,1,'8901499008183','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:30:41','2019-04-30 00:30:41',NULL),(697,'Cadbury Bubble 87g',9,'single',19,129,15,NULL,NULL,'exclusive',210,280,1,1,'7622210077691','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:32:32','2019-04-30 00:32:32',NULL),(698,'Cadbury Eclairs Gift Box 420g',9,'single',19,129,15,NULL,NULL,'exclusive',525,899,1,1,'7622210307866','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:34:35','2019-04-30 00:34:35',NULL),(699,'Kellogs Muesli Crunchy Fruit & Nut 500gm',9,'single',19,128,21,NULL,NULL,'exclusive',590,590,1,1,'8901499008428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:35:59','2019-04-30 00:35:59',NULL),(700,'Cadbury Flake 32g',9,'single',19,129,15,NULL,NULL,'exclusive',80,100,1,1,'50312351','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:36:17','2019-04-30 00:36:17',NULL),(701,'Cadbury Twirl 43g',9,'single',19,129,15,NULL,NULL,'exclusive',80,108,1,1,'50312719','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:38:42','2019-04-30 00:38:42',NULL),(702,'Vitalia Crunchy Muesli with Banana and Chocolate 320gm',9,'single',19,1,1,NULL,NULL,'exclusive',0,0,1,1,'5310099008531','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:39:10','2019-04-30 00:39:10',NULL),(703,'Kellogs Muesli Nut Delight 500gm',9,'single',19,128,21,NULL,NULL,'exclusive',580,580,1,1,'8901499008404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:40:51','2019-04-30 00:40:51',NULL),(704,'Cadbury Bournville  180g',9,'single',19,129,15,NULL,NULL,'exclusive',320,425,1,1,'7622210249661','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:41:28','2019-04-30 00:41:28',NULL),(705,'Cadbury Dairymilk Caramel 45g',9,'single',19,129,15,NULL,NULL,'exclusive',80,115,1,1,'7622300743703','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:43:25','2019-04-30 00:43:25',NULL),(706,'Cadbury Fruit & Nut 49g',9,'single',19,129,15,NULL,NULL,'exclusive',80,115,1,1,'50312610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:45:13','2019-04-30 00:45:13',NULL),(707,'Cadbury Dairy milk 45g',9,'single',19,129,15,NULL,NULL,'exclusive',80,115,1,1,'7622300743574','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:46:27','2019-04-30 00:46:27',NULL),(708,'Cadbury Whole Nut 45g',9,'single',19,129,15,NULL,NULL,'exclusive',80,115,1,1,'96133262','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:47:20','2019-04-30 00:47:20',NULL),(709,'Cadbury Oreo chocolate  120g',9,'single',19,129,15,NULL,NULL,'exclusive',220,285,1,1,'7622300754136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:48:49','2019-04-30 00:48:49',NULL),(710,'Cadbury Whole Nut 120g',9,'single',19,129,15,NULL,NULL,'exclusive',210,280,1,1,'5034660521877','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:50:22','2019-04-30 00:50:22',NULL),(711,'Cadbury Dairy Milk 110g',9,'single',19,129,15,NULL,NULL,'exclusive',210,280,1,1,'7622210521811','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:51:57','2019-04-30 00:51:57',NULL),(712,'Kellogs Oats 500gm',9,'single',19,128,21,NULL,NULL,'exclusive',300,300,1,1,'8901499008527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:53:01','2019-04-30 00:53:01',NULL),(713,'Cadbury Fruit & Nut 110g',9,'single',19,129,15,NULL,NULL,'exclusive',210,280,1,1,'7622210644817','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:53:11','2019-04-30 00:53:11',NULL),(714,'Cadbury Dairymilk Caramel 200g',9,'single',19,129,15,NULL,NULL,'exclusive',320,415,1,1,'7622300734824','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:54:26','2019-04-30 00:54:26',NULL),(715,'Cadbury Dairymilk Whole& Nut 200g',9,'single',19,129,15,NULL,NULL,'exclusive',320,415,1,1,'7622300736033','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:55:34','2019-04-30 00:55:34',NULL),(716,'Cadbury Dairymilk Fruit & Nut 200g',9,'single',19,129,15,NULL,NULL,'exclusive',320,415,1,1,'7622300736675','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:56:38','2019-04-30 00:56:38',NULL),(717,'Cadbury Dairymilk 200g',9,'single',19,129,15,NULL,NULL,'exclusive',320,415,1,1,'7622300736224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 00:58:45','2019-04-30 00:58:45',NULL),(718,'Wrigleys Eclipse Mints Winterforest 35g',9,'single',19,130,22,NULL,NULL,'exclusive',150,199,1,1,'9555192507314','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:05:49','2019-04-30 16:05:49',NULL),(719,'Wrigleys Eclipse Mints Spearmint 35g',9,'single',19,130,22,NULL,NULL,'exclusive',150,220,1,1,'9555192507215','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:08:32','2019-04-30 16:08:32',NULL),(720,'Wrigleys Eclipse Mints Peperrmint 35g',9,'single',19,130,22,NULL,NULL,'exclusive',150,199,1,1,'9555192507116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:10:35','2019-04-30 16:10:35',NULL),(721,'Nestle Smarties mini JAR 38g',9,'single',19,63,15,NULL,NULL,'exclusive',85,100,1,1,'50249466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:12:41','2019-08-31 15:37:39',NULL),(722,'Nestle Cerelac Mixed Fruit & Wheat 1 kg (8 months)',9,'single',19,63,26,NULL,NULL,'exclusive',1150,1300,1,1,'8410100181523','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:18:27','2019-05-13 01:00:15',NULL),(723,'Nestle Cerelac Honey & wheat 1 kg (12 months)',9,'single',19,63,26,NULL,NULL,'exclusive',1150,1300,1,1,'7616100581535','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:20:26','2019-05-13 00:58:57',NULL),(724,'Hersheys Kisses Cookies Hazel Nut 150g',9,'single',19,111,15,NULL,NULL,'exclusive',500,620,1,1,'6942836713027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:23:15','2019-04-30 16:23:15',NULL),(725,'Hersheys Kisses Cookies Almond 150g',9,'single',19,111,15,NULL,NULL,'exclusive',500,620,1,1,'6942836713010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:24:36','2019-04-30 16:24:36',NULL),(726,'Kellogs Special K Original 290gm',9,'single',19,128,21,NULL,NULL,'exclusive',265,265,1,1,'8901499008206','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:25:19','2019-05-03 00:50:25',NULL),(727,'Hersheys Kisses Cookies & Cream 150g',9,'single',19,111,15,NULL,NULL,'exclusive',500,620,1,1,'6942836713034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:27:41','2019-04-30 16:27:41',NULL),(728,'Kellogs Special K Original 435gm',9,'single',19,128,21,NULL,NULL,'exclusive',390,390,1,1,'8901499008459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:28:21','2019-05-03 00:51:00',NULL),(729,'Pringles Cheesy Cheese 147gm',9,'single',19,101,14,NULL,NULL,'exclusive',195,195,1,1,'8886467100093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:30:17','2019-04-30 16:30:17',NULL),(730,'Hersheys Kisses Cookies milk 150g',9,'single',19,111,15,NULL,NULL,'exclusive',500,620,1,1,'6942836713003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:31:07','2019-04-30 16:31:07',NULL),(731,'Pringles Hot & Spicy 147gm',9,'single',19,101,14,NULL,NULL,'exclusive',195,195,1,0,'8886467100116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:31:29','2019-04-30 16:31:29',NULL),(732,'Kinder Joy Lei 20gm',9,'single',19,131,15,NULL,NULL,'exclusive',60,70,1,1,'80768258','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:48:25','2020-07-19 22:58:26',NULL),(733,'Kinder Joy Lui 20gm',9,'single',19,131,15,NULL,NULL,'exclusive',55,70,1,1,'80974482','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:50:26','2019-05-24 15:30:51',NULL),(734,'Nutella 350gm',9,'single',19,132,51,NULL,NULL,'exclusive',340,450,1,1,'80177173','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:53:26','2019-07-02 00:45:52',NULL),(735,'Cowhead Instant Full Cream Milk 2.5kg',9,'single',19,84,26,NULL,NULL,'exclusive',2250,2870,1,1,'8888440001922','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:54:06','2020-09-08 16:16:31',NULL),(736,'Tic Tac Mint 7.7gm',9,'single',19,133,7,NULL,NULL,'exclusive',25,25,1,1,'8000500257319','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:55:53','2019-04-30 16:55:53',NULL),(737,'Cowhead Instant Full Cream Milk 1.8kg',9,'single',19,84,26,NULL,NULL,'exclusive',1900,2400,1,1,'8888440001939','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:56:14','2019-04-30 16:56:14',NULL),(738,'Tic Tac Orange 7.7gm',9,'single',19,133,7,NULL,NULL,'exclusive',25,25,1,1,'8000500257340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:57:09','2019-04-30 16:57:09',NULL),(739,'Cowhead Instant Low Fat Powder Milk 2kg',9,'single',19,84,26,NULL,NULL,'exclusive',2270,2870,1,1,'8888440003001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:58:19','2019-04-30 16:58:19',NULL),(740,'Tic Tac Saunf Flavour  7.7gm',9,'single',19,133,7,NULL,NULL,'exclusive',25,25,1,1,'8000500275009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 16:58:51','2019-04-30 16:58:51',NULL),(741,'Cowhead Instant Low Fat Powder Milk 1kg',9,'single',19,84,26,NULL,NULL,'exclusive',1120,1400,1,1,'8888440002998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 17:00:00','2019-04-30 17:00:00',NULL),(742,'Cowhead Instant Low Fat Powder Milk 500g',9,'single',19,84,26,NULL,NULL,'exclusive',580,710,1,1,'8888440008730','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 17:01:14','2019-04-30 17:01:14',NULL),(743,'Bauli Moonfils Choco 47gm',9,'single',19,134,17,NULL,NULL,'exclusive',35,35,1,1,'8906005618658','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 17:01:23','2019-04-30 17:05:06',NULL),(744,'Bauli Moonfils Strawberry 47gm',9,'single',19,134,17,NULL,NULL,'exclusive',35,35,1,1,'8906005618801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 17:04:27','2019-04-30 17:04:27',NULL),(745,'Baulil Moonfils Vanilla 47gm',9,'single',19,134,17,NULL,NULL,'exclusive',35,35,1,0,'8908009419019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 17:06:34','2019-04-30 17:06:34',NULL),(746,'Pop Corn Butter(Poppin)100gm',9,'single',19,135,58,NULL,NULL,'exclusive',135,160,1,1,'9310273721375','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:19:17','2019-04-30 19:19:17',NULL),(747,'Pop Corn Butter Lighit(Poppin)85gm',9,'single',19,135,58,NULL,NULL,'exclusive',135,160,1,1,'9310273211456','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:22:12','2019-04-30 19:22:12',NULL),(748,'Cottee\'s Breakfast Marmalade 500gm',9,'single',19,136,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801519','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:24:41','2019-05-03 16:19:24',NULL),(749,'Carnetion Milk 405g',9,'single',19,137,26,NULL,NULL,'exclusive',90,135,1,1,'8850124018205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:25:29','2019-04-30 19:25:29',NULL),(750,'Cottee\'s Strawberry Jam  500gm',9,'single',19,136,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801533','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:26:38','2019-05-03 16:16:22',NULL),(751,'Remia Garlic sauce 250ml',9,'single',19,44,32,NULL,NULL,'exclusive',135,180,1,1,'8710448564041','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:27:17','2020-08-18 19:09:27',NULL),(752,'Cottee\'s  Blackberry Jam 500gm',9,'single',19,136,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:28:26','2019-05-03 16:15:44',NULL),(753,'Remia Salad Dressing Garlic Sauce 250ml',9,'single',19,44,32,NULL,NULL,'exclusive',135,180,1,1,'8710448595809','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:29:10','2019-04-30 19:29:10',NULL),(754,'Remia Salad Dressing Blue Cheese 250ml',9,'single',19,44,32,NULL,NULL,'exclusive',135,180,1,1,'8710448595786','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:31:56','2019-04-30 19:31:56',NULL),(755,'Remia Salad Dressing French 250ml',9,'single',19,44,32,NULL,NULL,'exclusive',135,180,1,1,'8710448095798','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:33:09','2019-04-30 19:33:09',NULL),(756,'Remia Salad Dressing Italian 250ml',9,'single',19,44,32,NULL,NULL,'exclusive',135,180,1,1,'8710448595823','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:34:51','2019-04-30 19:34:51',NULL),(757,'Nescafe Gold 200Gm',9,'single',19,138,16,NULL,NULL,'exclusive',710,720,1,1,'7613036394109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:38:23','2019-04-30 19:38:23',NULL),(758,'Figaro Capers in Vinegar 100gm',9,'single',19,12,39,NULL,NULL,'exclusive',125,175,1,1,'8410159301101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:40:28','2019-04-30 19:40:28',NULL),(759,'Figaro Pitted Black Olive340gm',9,'single',19,12,49,NULL,NULL,'exclusive',125,160,1,1,'8410159006662','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:41:51','2019-04-30 19:41:51',NULL),(760,'Figaro Stuffed Green Olive340gm',9,'single',19,12,49,NULL,NULL,'exclusive',125,140,1,1,'8410159016586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:44:50','2019-07-15 17:00:54',NULL),(761,'Macaroni Filini(Victoria)500gm',9,'single',19,139,30,NULL,NULL,'exclusive',125,200,1,1,'8000483301313','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:48:11','2019-04-30 19:48:11',NULL),(762,'Cottee\'s Apricot  Jam 500gm',9,'single',19,136,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801564','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:50:05','2019-05-03 16:17:30',NULL),(763,'Macaroni Rigatoni(Victoria)500gm',9,'single',19,139,30,NULL,NULL,'exclusive',125,200,1,1,'8000483301214','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:50:11','2019-04-30 19:50:11',NULL),(764,'Macaroni Fusilli Tricolore(Victoria)500gm',9,'single',19,139,30,NULL,NULL,'exclusive',170,200,1,1,'8000483301269','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:51:30','2019-07-15 16:59:39',NULL),(765,'Cottee\'s Fruit of The Forrest Jam  500gm',9,'single',19,136,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:52:09','2019-05-03 16:14:51',NULL),(766,'Macaroni Farfalle(Victoria)500gm',9,'single',19,139,30,NULL,NULL,'exclusive',125,200,1,1,'8000483301092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:53:07','2019-04-30 19:53:07',NULL),(767,'Cottee\'s Strawberry Jam 250gm',9,'single',19,136,NULL,NULL,NULL,'exclusive',305,370,1,1,'94547214','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:54:16','2019-04-30 19:54:16',NULL),(768,'Macaroni Pipe Rigate(Victoria)500gm',9,'single',19,139,30,NULL,NULL,'exclusive',125,200,1,1,'8000483301436','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:54:41','2019-04-30 19:54:41',NULL),(769,'Nanas Sweet Corn 425Gm',9,'single',19,140,11,NULL,NULL,'exclusive',60,100,1,1,'8858702715140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:56:03','2019-04-30 19:56:03',NULL),(770,'Cottee\'s Raspbetty Jam 250gm',9,'single',19,136,23,NULL,NULL,'exclusive',305,370,1,1,'94547238','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:56:11','2019-04-30 19:56:11',NULL),(771,'Golden Cricle Prune Juice 1 Lit',9,'single',19,141,24,NULL,NULL,'exclusive',390,435,1,1,'9310179199414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:57:46','2019-07-25 15:14:33',NULL),(772,'Pauls (UHT) Low Fat Milk 1Lit',9,'single',19,142,26,NULL,NULL,'exclusive',180,215,1,1,'9310036003205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 19:59:35','2019-04-30 19:59:35',NULL),(774,'Heinz Vanilla Custard Glass 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93657723','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:01:49','2020-08-13 00:53:36',NULL),(775,'Pauls (UHT) Full Cream Milk 1Lit',9,'single',19,142,26,NULL,NULL,'exclusive',180,215,1,1,'9310036016878','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:04:17','2020-08-13 00:42:57',NULL),(776,'Heinz Banana Custard Glass 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',170,170,1,1,'93657860','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:04:23','2020-07-22 22:08:24',NULL),(777,'Soya Milk(So good)Regular 1Ltr',9,'single',19,143,26,NULL,NULL,'exclusive',250,310,1,1,'9300652510911','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:06:47','2020-08-13 00:41:31',NULL),(778,'Heinz Chocolate Custard Glass 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,170,1,1,'93548311','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:07:33','2019-04-30 20:07:33',NULL),(779,'IXL Apricot Jam 480gm',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003280','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:08:01','2019-05-03 16:37:55',NULL),(780,'IXL Fruit Of The Forest Jam 480gm',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003297','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:09:16','2019-05-03 16:32:53',NULL),(781,'Heinz Egg Custard Glass 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,170,1,1,'93548304','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:10:16','2020-07-22 22:09:23',NULL),(782,'IXL Breakfast Marmalade Jam 480gm',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003273','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:10:58','2019-05-03 16:39:45',NULL),(783,'IXL Strawberry Jam480gm',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003259','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:11:53','2019-05-03 16:39:01',NULL),(784,'Heinz Summer Fruit Gell Glass 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93657648','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:12:01','2019-05-03 15:36:57',NULL),(785,'Heinz Creamy Bana Glass 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93412292','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:13:15','2020-07-22 22:09:43',NULL),(786,'IXL Raspberry Jam 480gm',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003266','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:14:13','2019-05-03 16:31:34',NULL),(787,'Heinz Pear & Banana 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93412193','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:14:38','2019-05-03 15:41:00',NULL),(788,'Heinz Apple Custard 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93657037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:15:59','2019-05-03 15:42:43',NULL),(789,'Heinz Pear Custard 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93657488','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:17:56','2020-07-22 22:10:06',NULL),(790,'Heinz Apple & Mango 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,0,'93772044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:19:02','2019-05-03 15:39:50',NULL),(791,'Heinz Pumkin, Potato & Beef 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,170,1,1,'93772020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:20:12','2020-07-22 22:10:29',NULL),(792,'Heinz Golden Sweet Corn & Chicken 110 gm',9,'single',19,13,64,NULL,NULL,'exclusive',110,165,1,1,'93772037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:21:28','2019-05-03 15:44:23',NULL),(794,'Heinz Parsnip Carrot & Sweet Potato 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,170,1,1,'93772006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:22:55','2019-04-30 20:22:55',NULL),(795,'Heinz Apple & Banana Cereal  110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,170,1,1,'93426107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:24:13','2019-04-30 20:24:13',NULL),(796,'Heinz Apple & Blueberry Muesli 110 gm',9,'single',19,13,59,NULL,NULL,'exclusive',110,165,1,1,'93772051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:26:08','2019-05-03 15:38:33',NULL),(797,'Figaro Pitted Green Olive 340gm',9,'single',19,12,49,NULL,NULL,'exclusive',125,150,1,1,'8410159040147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:28:08','2019-04-30 20:28:08',NULL),(798,'Nescafe Gold 100 gm',9,'single',19,138,16,NULL,NULL,'exclusive',400,465,1,1,'7613036310116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 20:33:14','2019-07-16 21:20:18',NULL),(799,'Nescafe Coffee Gold 50 gm',9,'single',19,138,NULL,NULL,NULL,'exclusive',265,320,1,1,'7613036299008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:16:06','2019-04-30 21:16:06',NULL),(800,'Heinz Chicken & Vegetable Risotto 170 gm',9,'single',19,13,59,NULL,NULL,'exclusive',180,254,1,1,'9300657161415','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:20:19','2019-04-30 21:20:19',NULL),(801,'Heinz Beef & Vegetable Casserole 170 gm',9,'single',19,13,59,NULL,NULL,'exclusive',180,254,1,1,'9300657161569','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:21:49','2019-04-30 21:21:49',NULL),(802,'Heinz Tender Beef With Vegetable Mush 170 gm',9,'single',19,13,59,NULL,NULL,'exclusive',180,215,1,1,'9300657162511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:23:21','2019-05-03 16:23:21',NULL),(803,'Heinz Little Kids (Apple & Blueberry) Cereal 90 gm',9,'single',19,13,59,NULL,NULL,'exclusive',335,400,1,1,'9300657154929','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:26:40','2019-04-30 21:26:40',NULL),(804,'Heinz Little Kids (Apple & Strawberry) Cereal 90 gm',9,'single',19,13,59,NULL,NULL,'exclusive',335,400,1,1,'9300657154981','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:31:57','2019-04-30 21:31:57',NULL),(805,'Super Bee Organic Honey 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',780,1000,1,1,'9322050001709','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:33:48','2019-04-30 21:33:48',NULL),(806,'Super Bee Honey & Ginger 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',1000,1200,1,1,'9322050000832','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:35:38','2019-04-30 21:35:38',NULL),(807,'Super Bee Honey (Floral Blend) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',670,800,1,1,'9322050000818','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:37:03','2019-04-30 21:37:03',NULL),(808,'Super Bee Honey (Eucalyptus) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',670,800,1,1,'9322050002539','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:38:35','2019-04-30 21:38:35',NULL),(809,'Super Bee Honey (Iron Bark) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',670,800,1,1,'9322050000733','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:39:59','2019-04-30 21:39:59',NULL),(810,'Super Bee Honey (Rain Forest) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',670,800,1,0,'9322050000764','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:41:08','2019-04-30 21:41:08',NULL),(811,'Super Bee Honey (Yellow Box) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',780,935,1,1,'9322050001464','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:42:44','2019-04-30 21:42:44',NULL),(812,'Super Bee Pure Honey Squeeze 375 gm',9,'single',19,144,56,NULL,NULL,'exclusive',555,668,1,1,'9322050006858','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:44:54','2019-04-30 21:44:54',NULL),(813,'Super Bee Pure Honey Jar 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',645,775,1,1,'9322050001006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:47:04','2020-10-30 19:34:40',NULL),(814,'Gerber Apple Juice 946 ml',9,'single',19,145,24,NULL,NULL,'exclusive',445,445,1,1,'015000020712','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:48:33','2020-09-17 19:09:10',NULL),(815,'Gerber Mixed Fruit Juice 946 ml',9,'single',19,145,24,NULL,NULL,'exclusive',445,445,1,1,'015000020781','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:49:59','2019-04-30 21:49:59',NULL),(816,'Gerber White Grape Juice 946 ml',9,'single',19,145,24,NULL,NULL,'exclusive',445,445,1,1,'015000020729','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:51:48','2020-09-17 19:08:07',NULL),(817,'Gerber Oatmeal Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',410,445,1,1,'015000070014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:53:17','2019-05-21 22:00:05',NULL),(818,'Wrigley\'s Extra Cool Breeze-42gm',9,'single',19,130,22,NULL,NULL,'exclusive',145,175,1,1,'4009900408134','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:53:51','2019-04-30 21:53:51',NULL),(819,'Gerber Rice Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',410,445,1,1,'015000070007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:54:31','2019-05-21 22:03:55',NULL),(820,'Wrigley\'s Extra Strawberry Flv-42gm',9,'single',19,130,22,NULL,NULL,'exclusive',145,175,1,1,'4009900470575','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:55:01','2019-04-30 21:55:01',NULL),(821,'Gerber Barly Single Grain Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',420,445,1,1,'015000070021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:56:10','2019-05-27 21:41:29',NULL),(822,'Wrigley\'s Extra Peppermint-42gm',9,'single',19,130,22,NULL,NULL,'exclusive',145,175,1,1,'4009900359245','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:57:29','2019-04-30 21:57:29',NULL),(823,'Wrigley\'s Extra spearmint-42gm',9,'single',19,130,22,NULL,NULL,'exclusive',145,175,1,1,'4009900015363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 21:58:32','2019-04-30 21:58:32',NULL),(824,'Wrigley\'s Extra spearmint 60 Pieces -84gm',9,'single',19,130,22,NULL,NULL,'exclusive',280,335,1,1,'4009900482776','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:00:00','2019-04-30 22:00:00',NULL),(825,'Wrigley\'s Extra Peppermint 60 Pieces -84gm',9,'single',19,130,22,NULL,NULL,'exclusive',280,335,1,1,'4009900482806','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:01:51','2019-04-30 22:01:51',NULL),(826,'Gerber Organic Rice Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:02:57','2019-05-21 22:13:17',NULL),(827,'Wrigley\'s Extra Cool Breeze 60 Pieces-84gm',9,'single',19,130,22,NULL,NULL,'exclusive',280,335,1,1,'4009900513906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:03:05','2019-04-30 22:03:05',NULL),(828,'Storck Werther\'s orginal Butter Candies-135gm',9,'single',19,146,7,NULL,NULL,'exclusive',245,295,1,1,'4014400910063','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:06:51','2019-04-30 22:06:51',NULL),(829,'Storck Werther\'s orginal S.Free Butter Candies-80gm',9,'single',19,146,7,NULL,NULL,'exclusive',245,295,1,1,'4014400914696','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:08:30','2019-04-30 22:08:30',NULL),(830,'Chewing Gum Wrigley\'s Hubba Bubba Fancy Fruit Flv-56gm',9,'single',19,130,22,NULL,NULL,'exclusive',155,185,1,1,'4009900379564','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:10:45','2019-04-30 22:10:45',NULL),(831,'Chewing Gum Wrigley\'s Hubba Bubba Snappy Straw. Flv-56gm',9,'single',19,130,22,NULL,NULL,'exclusive',155,185,1,1,'4009900381352','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:13:40','2019-04-30 22:13:40',NULL),(832,'Chewing Gum Wrigley\'s Hubba Bubba Cola Flv-56gm',9,'single',19,130,22,NULL,NULL,'exclusive',155,185,1,1,'4009900476812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:14:39','2019-04-30 22:14:39',NULL),(833,'Kinder Surprise-(3X20g)=60gm',9,'single',19,NULL,15,NULL,NULL,'exclusive',310,375,1,1,'8000500026731','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:18:17','2019-04-30 22:18:17',NULL),(834,'Mars No Added Sugar-376ml',9,'single',19,117,26,NULL,NULL,'exclusive',445,535,1,1,'5060122038874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:21:08','2019-04-30 22:21:08',NULL),(835,'Galaxy No Added Sugar-376ml',9,'single',19,110,26,NULL,NULL,'exclusive',445,535,1,1,'5060122038911','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:22:10','2019-04-30 22:22:10',NULL),(836,'Baby Looney Tunes Marshmallows-200gm',9,'single',19,147,15,NULL,NULL,'exclusive',200,240,1,1,'8888047737682','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:25:08','2019-04-30 22:25:08',NULL),(837,'Chupa Chup Mini-90gm',9,'single',19,148,15,NULL,NULL,'exclusive',265,240,1,1,'8410031960952','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:28:53','2019-09-10 17:37:22',NULL),(838,'Cho Cho Wafer Snack Vanila-40gm',9,'single',19,123,55,NULL,NULL,'exclusive',45,55,1,1,'8992952924669','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:30:31','2019-04-30 22:30:31',NULL),(839,'Chupa Chup -11gm',9,'single',19,148,15,NULL,NULL,'exclusive',25,26,1,1,'8410031939866','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 22:41:37','2019-04-30 22:41:37',NULL),(840,'Green Tea All Natural 40gm',9,'single',19,149,37,NULL,NULL,'exclusive',255,315,1,1,'9312631151930','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-04-30 23:37:19','2019-04-30 23:37:19',NULL),(841,'Pure Ceylon Tea Premium 50gm',9,'single',19,149,37,NULL,NULL,'exclusive',255,315,1,1,'9312631801101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 15:47:27','2019-05-02 15:47:27',NULL),(842,'Lemon Black Tea 30 gm',9,'single',19,149,37,NULL,NULL,'exclusive',270,325,1,1,'9312631142129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 15:53:50','2019-05-02 15:53:50',NULL),(843,'Jasmin  Tea Food Service Pack 50gm',9,'single',19,149,37,NULL,NULL,'exclusive',330,400,1,1,'9312631833218','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 15:55:51','2019-05-19 16:33:56',NULL),(844,'Premium Ceylon Tea 100 gm',9,'single',19,149,37,NULL,NULL,'exclusive',375,455,1,1,'9312631801552','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 15:56:55','2019-05-02 15:56:55',NULL),(845,'Green Tea With Ginger 40gm',9,'single',19,149,37,NULL,NULL,'exclusive',285,350,1,1,'9312631151985','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 15:58:27','2019-05-02 15:58:27',NULL),(846,'Pure Camomile  Tea Food Service Pack 37.5gm',9,'single',19,149,37,NULL,NULL,'exclusive',350,430,1,1,'9312631834024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:02:35','2019-05-02 16:02:35',NULL),(847,'Earl Grey Food Service 37.5 gm',9,'single',19,149,37,NULL,NULL,'exclusive',360,440,1,1,'9312631833072','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:03:48','2019-05-02 16:05:54',NULL),(848,'Earl Grey tea 50 gm',9,'single',19,149,37,NULL,NULL,'exclusive',360,440,1,1,'9312631124842','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:06:46','2019-05-02 16:06:46',NULL),(849,'Pure green Tea Food Service 50 gm',9,'single',19,149,37,NULL,NULL,'exclusive',285,350,1,1,'9312631830668','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:08:32','2019-05-02 16:08:32',NULL),(850,'Green Tea With Cardamon 40gm',9,'single',19,149,37,NULL,NULL,'exclusive',285,350,1,1,'9312631152005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:09:40','2019-05-02 16:09:40',NULL),(851,'Dilmah Premium Ceylon Tea 400 gm',9,'single',19,149,37,NULL,NULL,'exclusive',875,1060,1,1,'9312631127669','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:10:58','2019-05-19 16:38:01',NULL),(852,'Green Tea With Moroccomn Mint 40gm',9,'single',19,149,37,NULL,NULL,'exclusive',285,350,1,1,'9312631151947','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:12:07','2019-05-02 16:12:07',NULL),(853,'Green Tea With Cinnamon 40gm',9,'single',19,149,37,NULL,NULL,'exclusive',285,350,1,1,'9312631151992','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:12:56','2019-05-02 16:12:56',NULL),(854,'Ginger & Honey Black Tea 30 gm',9,'single',19,149,37,NULL,NULL,'exclusive',285,350,1,1,'9312631142112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:13:49','2019-05-02 16:13:49',NULL),(855,'English Breakfast Food Service 50 gm',9,'single',19,149,37,NULL,NULL,'exclusive',310,375,1,1,'9312631833065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:14:59','2019-05-02 16:14:59',NULL),(856,'English Breakfast 50 gm',9,'single',19,149,37,NULL,NULL,'exclusive',305,375,1,1,'9312631124835','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:15:45','2019-05-02 16:15:45',NULL),(857,'American Garden Red  Kidney Beans 425g',9,'single',19,150,11,NULL,NULL,'exclusive',100,120,1,1,'717273501188','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:17:40','2019-05-09 16:46:13',NULL),(858,'American Garden Mushroon Whole-Can 425g',9,'single',19,150,11,NULL,NULL,'exclusive',100,120,1,1,'717273701700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:18:53','2019-05-09 16:43:40',NULL),(859,'American Garden Peanut Butter Creamy 510g',9,'single',19,150,6,NULL,NULL,'exclusive',420,510,1,1,'717273501546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:19:59','2019-05-09 16:45:23',NULL),(860,'American Garden Real Mayonnaise 473 g',9,'single',19,150,25,NULL,NULL,'exclusive',255,405,1,1,'017273504494','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:21:01','2019-05-18 15:50:56',NULL),(861,'American Garden Real Mayonnaise 887g',9,'single',19,150,25,NULL,NULL,'exclusive',385,470,1,1,'017273504517','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:22:33','2019-05-09 16:40:34',NULL),(862,'American Garden BBQ Sauce 510g',9,'single',19,150,32,NULL,NULL,'exclusive',255,305,1,1,'717273501577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:23:34','2019-05-09 16:42:53',NULL),(863,'American Garden Apple Cider Vinegar 473 g',9,'single',19,150,39,NULL,NULL,'exclusive',130,160,1,1,'717273501782','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 16:24:55','2019-05-18 15:51:23',NULL),(864,'Lotte Gum Pepermint Flavor Stick-12.5gm',9,'single',19,20,22,NULL,NULL,'exclusive',7.5,10,1,1,'8801062118076','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:22:51','2019-05-02 17:22:51',NULL),(865,'Horlicks Original Lite Chocolate 500 g',9,'single',19,151,60,NULL,NULL,'exclusive',450,650,1,1,'5000347098406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:27:15','2019-05-26 22:22:23',NULL),(866,'Horlicks Original Lite 500 g',9,'single',19,151,60,NULL,NULL,'exclusive',470,650,1,1,'5000347098390','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:29:21','2019-05-26 22:21:50',NULL),(867,'Twinings Earl Grey Tea 125g 50 Bags',9,'single',19,152,37,NULL,NULL,'exclusive',440,535,1,1,'070177010713','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:31:39','2019-05-02 17:31:39',NULL),(868,'Twinings Earl Grey Tea 250g 100bags',9,'single',19,152,37,NULL,NULL,'exclusive',700,870,1,1,'070177018016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:33:11','2019-05-02 17:33:11',NULL),(869,'Ribena Blackurrant Juice 850ml',9,'single',19,153,24,NULL,NULL,'exclusive',440,535,1,1,'5054267003378','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:34:54','2019-05-02 17:34:54',NULL),(870,'Ribena Blackurrant Juice 600ml',9,'single',19,153,24,NULL,NULL,'exclusive',340,415,1,1,'5054267001978','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:36:17','2019-05-02 17:36:17',NULL),(871,'Cadbury Drinking Chocolate 500Gm',9,'single',19,129,15,NULL,NULL,'exclusive',385,495,1,1,'5000312000687','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:38:34','2020-09-17 17:16:56',NULL),(872,'Canderel Sugar 40g',9,'single',19,154,35,NULL,NULL,'exclusive',155,185,1,1,'7640110700068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:40:53','2019-05-02 17:40:53',NULL),(873,'Kellogg`s Frosties 500 gm',9,'single',19,128,61,NULL,NULL,'exclusive',520,635,1,1,'5053827170017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:44:00','2019-05-02 17:44:00',NULL),(874,'Stute Diabetic Raspberry Jam 430Gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,375,1,1,'4006424022334','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:45:32','2019-05-02 17:45:32',NULL),(875,'Kelloggs Coco Pops 510gm',9,'single',19,128,62,NULL,NULL,'exclusive',590,720,1,1,'5053827173070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:48:40','2019-05-02 17:48:40',NULL),(876,'Kelloggs Corn Flakes 550gm',9,'single',19,128,21,NULL,NULL,'exclusive',410,460,1,1,'5053827171472','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:50:17','2019-07-10 00:41:18',NULL),(877,'KELLOGGS Crunchy Nut 500gm',9,'single',19,128,53,NULL,NULL,'exclusive',570,695,1,1,'5053827169899','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:54:35','2019-05-02 17:54:35',NULL),(878,'Alpen No Added Sugar 560 gm',9,'single',19,156,1,NULL,NULL,'exclusive',570,695,1,1,'5010029201246','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:55:59','2019-05-18 15:49:49',NULL),(879,'S&W Kidney beans-432gm',9,'single',19,27,11,NULL,NULL,'exclusive',215,250,1,1,'011194390242','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 17:59:43','2019-05-02 17:59:43',NULL),(880,'Knorr Chicken & Leek Soup 60g',9,'single',19,42,63,NULL,NULL,'exclusive',120,145,1,1,'8712566248186','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:02:06','2019-05-02 18:02:06',NULL),(881,'Knorr Broccoli & Stilton Soup 60g',9,'single',19,42,63,NULL,NULL,'exclusive',120,145,1,1,'8712566248063','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:04:01','2019-05-02 18:04:01',NULL),(882,'Knorr Super Chicken Noodle Soup 51g',9,'single',19,42,63,NULL,NULL,'exclusive',120,120,1,1,'8712566247905','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:09:47','2019-05-02 18:09:47',NULL),(883,'Knorr Florida Spring Vegetable Soup 48g',9,'single',19,42,63,NULL,NULL,'exclusive',145,170,1,1,'8712566247868','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:12:06','2019-08-06 15:12:02',NULL),(884,'S&W CRUSHED TOMATOES 794G',9,'single',19,27,11,NULL,NULL,'exclusive',198,275,1,1,'011194365257','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:15:48','2019-05-02 18:15:48',NULL),(885,'S&W Pear Halves in Syrup-825gm',9,'single',19,27,43,NULL,NULL,'exclusive',341,390,1,1,'011194204129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:21:50','2019-07-23 16:36:20',NULL),(886,'Kellogg`s Corn Flakes 750gm',9,'single',19,128,21,NULL,NULL,'exclusive',570,735,1,1,'4003994112427','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:25:32','2019-05-12 19:46:14',NULL),(887,'RUBICON JUICE MANGO 330ML',9,'single',19,157,24,NULL,NULL,'exclusive',100,115,1,1,'5011898002019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:30:24','2019-06-25 15:19:54',NULL),(888,'RUBICON JUICE LYCHEE 330ML',9,'single',19,157,24,NULL,NULL,'exclusive',100,115,1,1,'5011898003016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:31:44','2019-06-25 15:18:47',NULL),(889,'Alpen Original muesli Sugar 375 g',9,'single',19,156,1,NULL,NULL,'exclusive',340,465,1,1,'5010029020021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:33:24','2019-05-30 00:14:48',NULL),(890,'Robinsons Orange Barley Water 850 ML',9,'single',19,158,24,NULL,NULL,'exclusive',335,400,1,1,'5010102113275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:35:43','2019-05-30 23:40:58',NULL),(891,'SPLENDA TABLET 100 PC',9,'single',19,159,NULL,NULL,NULL,'exclusive',150,180,1,1,'722776000380','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:42:04','2019-05-02 18:42:04',NULL),(892,'PG TEA Original 232gm ',9,'single',19,160,37,NULL,NULL,'exclusive',445,535,1,1,'8712100739217','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:43:42','2019-05-02 18:43:42',NULL),(893,'PG TEA 696 gm',9,'single',19,160,37,NULL,NULL,'exclusive',890,1070,1,1,'8712100739613','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:44:55','2019-05-02 18:44:55',NULL),(894,'BAXTERS CREAM OF CHICKEN 400gm',9,'single',19,161,41,NULL,NULL,'exclusive',285,340,1,1,'5012427143104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:46:40','2019-05-02 18:46:40',NULL),(895,'BAXTERS CREAM OF MUSHROOM 400G',9,'single',19,161,41,NULL,NULL,'exclusive',285,340,1,1,'5012427143807','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:47:56','2019-05-02 18:47:56',NULL),(896,'BAXTERS CREAM OF TOMATO 400G',9,'single',19,161,41,NULL,NULL,'exclusive',280,335,1,1,'5012427142701','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 18:49:01','2019-05-02 18:49:01',NULL),(897,'San Remo  Elbows Pasta 250gm',9,'single',19,28,30,NULL,NULL,'exclusive',80,100,1,1,'9310155001731','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 19:12:21','2019-05-02 19:12:21',NULL),(898,'San Remo Penne  Pasta 250gm',9,'single',19,28,30,NULL,NULL,'exclusive',80,100,1,1,'9310155008952','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 19:13:50','2019-05-02 19:13:50',NULL),(899,'Biondi Fettuccine Pasta 500gm',9,'single',19,3,31,NULL,NULL,'exclusive',110,150,1,1,'9310155008457','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 19:30:49','2019-05-02 19:30:49',NULL),(900,'Black & Gold MILK F/CRM UHT 1 lt',9,'single',19,162,26,NULL,NULL,'exclusive',160,195,1,1,'9310077217807','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:08:40','2019-05-09 16:20:53',NULL),(901,'Black & Gold MILK L/LF RF 1 Lt',9,'single',19,162,26,NULL,NULL,'exclusive',190,225,1,1,'9310077254093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:10:29','2019-05-09 16:22:01',NULL),(902,'FANTASTIC CUP NDL BBQ BEEF 70gm',9,'single',19,163,27,NULL,NULL,'exclusive',165,200,1,1,'9310155602983','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:15:26','2019-05-02 20:15:26',NULL),(903,'FANTASTIC CUP NDL BEEF 70g',9,'single',19,163,27,NULL,NULL,'exclusive',165,200,1,1,'9310155610506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:17:21','2019-05-02 20:17:21',NULL),(904,'FANTASTIC CUP NDL CHICKEN 70g',9,'single',19,163,27,NULL,NULL,'exclusive',165,200,1,1,'9310155620505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:18:53','2019-05-02 20:18:53',NULL),(905,'FANTASTIC CUP NDL CHK CHOW 70g',9,'single',19,163,27,NULL,NULL,'exclusive',165,200,1,1,'9310155002141','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:20:02','2019-05-02 20:20:02',NULL),(906,'FANTASTIC CUP NDL CHK CORN 70g',9,'single',19,163,27,NULL,NULL,'exclusive',165,200,1,1,'9310155630504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:21:12','2019-05-02 20:21:12',NULL),(907,'FANTASTIC CUP NDL ORIENTAL 70g',9,'single',19,163,27,NULL,NULL,'exclusive',165,200,1,1,'9310155680509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:22:19','2019-05-02 20:22:19',NULL),(908,'C/WELL VINEGAR BRN/MALT 750ml',9,'single',19,164,39,NULL,NULL,'exclusive',365,440,1,1,'9310159522300','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:25:28','2019-05-02 20:25:28',NULL),(909,'C/WELL VINEGAR WHITE 750ML',9,'single',19,164,39,NULL,NULL,'exclusive',315,385,1,1,'9310159531906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:26:52','2019-05-02 20:26:52',NULL),(910,'CAPILANO HONEY UD PACKS',9,'single',19,165,56,NULL,NULL,'exclusive',485,590,1,1,'9300677002385','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:31:45','2019-05-02 20:31:45',NULL),(911,'CAPILANO HONEY UD PACKS 500GM',9,'single',19,165,56,NULL,NULL,'exclusive',600,715,1,1,'9300677002286','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:33:13','2019-05-02 21:54:54',NULL),(912,'CAPILANO HONEY SQZ YL/BO',9,'single',19,165,56,NULL,NULL,'exclusive',460,560,1,1,'9300677006529','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:39:06','2019-05-02 21:57:17',NULL),(913,'CAPILANO HONEY SQZ CLEAR',9,'single',19,165,56,NULL,NULL,'exclusive',460,560,1,1,'9300677006536','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:40:57','2019-05-02 21:56:41',NULL),(914,'CAPILANO HONEY PURE PET 250g',9,'single',19,165,56,NULL,NULL,'exclusive',320,390,1,1,'9300677000442','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 20:47:03','2019-05-02 20:47:03',NULL),(915,'CAPILANO HONEY CLEAR 500g',9,'single',19,165,56,NULL,NULL,'exclusive',595,695,1,1,'93677035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:00:43','2019-05-02 22:00:43',NULL),(916,'HEINZ SCE HONEY MUSTARD 220ml',9,'single',19,13,48,NULL,NULL,'exclusive',250,300,1,1,'9300657114435','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:02:41','2019-05-10 18:31:45',NULL),(917,'HEINZ SCE KETCHUP TOM R/SUG 500ml',9,'single',19,13,45,NULL,NULL,'exclusive',335,410,1,1,'9300657114411','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:05:53','2019-05-10 18:32:08',NULL),(918,'Heinz SCE BBQ 500ml',9,'single',19,13,32,NULL,NULL,'exclusive',335,415,1,1,'9300657243081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:07:54','2019-05-10 18:29:50',NULL),(919,'Heinz SCE BBQ SMOKEY 500ml',9,'single',19,13,32,NULL,NULL,'exclusive',335,415,1,1,'9300657155766','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:09:25','2019-05-10 18:30:43',NULL),(920,'HEINZ SCE KETCHUP TOMATO 1ltr',9,'single',19,13,45,NULL,NULL,'exclusive',480,550,1,1,'9300657016555','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:13:37','2020-07-22 22:11:08',NULL),(921,'HEINZ SCE KETCHUP TOMATO 500ml',9,'single',19,13,45,NULL,NULL,'exclusive',335,415,1,1,'9300657114046','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:17:14','2019-05-10 18:33:03',NULL),(922,'HEINZ SCE TOMATO BIG RED 500ml',9,'single',19,13,32,NULL,NULL,'exclusive',415,510,1,1,'9300657243074','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:18:48','2019-05-10 18:33:29',NULL),(923,'Heinz SCE BBQ CLASSIC 400ml',9,'single',19,13,32,NULL,NULL,'exclusive',355,425,1,1,'9300657114442','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:21:20','2019-05-10 18:30:21',NULL),(924,'HEINZ SCE BBQ SPICY 400ml',9,'single',19,13,32,NULL,NULL,'exclusive',355,425,1,1,'9300657114428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:22:29','2019-05-10 18:31:20',NULL),(925,'FOUNT SCE CHILLI HOT 250ml',9,'single',19,166,32,NULL,NULL,'exclusive',230,280,1,1,'9300681002081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:24:51','2019-05-02 22:24:51',NULL),(926,'FOUNT SCE SPICY RED 250ML',9,'single',19,166,32,NULL,NULL,'exclusive',230,280,1,1,'93681117','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:25:51','2019-05-02 22:25:51',NULL),(927,'FOUNT SCE STEAK 250ML',9,'single',19,166,32,NULL,NULL,'exclusive',230,280,1,1,'93681124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:27:01','2019-05-02 22:27:01',NULL),(928,'FOUNT SCE SQZ CHILLI SWT  500ML',9,'single',19,166,32,NULL,NULL,'exclusive',365,440,1,1,'9300681008403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:28:56','2019-05-02 22:28:56',NULL),(929,'POP TOPS DRK TROPICAL   250ML',9,'single',19,167,24,NULL,NULL,'exclusive',125,160,1,1,'9315626999760','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:31:37','2019-05-02 22:31:37',NULL),(930,'POP TOPS DRK ORANGE    250ML',9,'single',19,167,24,NULL,NULL,'exclusive',125,160,1,1,'9315626999920','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:32:49','2019-05-02 22:32:49',NULL),(931,'POP TOPS DRK APPLE     250ML',9,'single',19,167,24,NULL,NULL,'exclusive',125,160,1,1,'9315626999951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:34:01','2019-05-02 22:34:01',NULL),(932,'POP TOPS DRK APP/BLACK  250ML',9,'single',19,167,24,NULL,NULL,'exclusive',125,160,1,1,'9315626999944','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-02 22:35:55','2019-05-02 22:35:55',NULL),(933,'Golden Circle Delicious Tropical Punch 1 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',340,395,1,1,'9310179006699','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:23:54','2019-05-26 20:38:33',NULL),(934,'Golden Circle Dark Apple 1 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',340,395,1,1,'9310179009300','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:25:18','2019-05-26 20:24:14',NULL),(935,'Golden Circle Dark Orange 1 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',340,395,1,1,'9310179006682','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:26:43','2019-05-26 20:25:34',NULL),(936,'Golden Circle Juice Pear/Apple/Raspberry  2 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',650,750,1,1,'9310179188067','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:28:51','2019-05-26 20:46:25',NULL),(937,'Golden Circle Juice Orange Pet 2 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',650,750,1,1,'9310179008587','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:30:21','2019-05-26 20:43:14',NULL),(938,'Golden Circle Juice Apple/Mango Pet 2 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',650,750,1,1,'9310179008594','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:32:07','2019-06-16 17:17:22',NULL),(939,'Golden Circle Juice Apple Pet 2 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',600,750,1,1,'9310179008624','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:33:35','2019-06-28 22:35:25',NULL),(940,'Golden Circle Juice Orange/Mango Juice Pet 2 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',600,750,1,1,'9310179188081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:36:57','2019-06-28 22:35:49',NULL),(941,'Golden Circle Juice Tropical Pet 2 Lt',9,'single',19,141,24,NULL,NULL,'exclusive',650,750,1,1,'9310179008600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:38:13','2019-05-26 20:48:26',NULL),(942,'BERRI JCE GRAPE 2ltr',9,'single',19,168,24,NULL,NULL,'exclusive',660,760,1,1,'9310113900649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:41:24','2019-05-03 00:41:24',NULL),(943,'BERRI JCE APPLE  2LTR',9,'single',19,168,24,NULL,NULL,'exclusive',620,760,1,1,'9310113902728','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:42:26','2019-06-28 22:36:43',NULL),(944,'BERRI JCE ORANGE 2LTR',9,'single',19,168,24,NULL,NULL,'exclusive',620,760,1,1,'9310113902735','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 00:43:50','2019-07-11 20:30:10',NULL),(945,'KELL COCO POPS 375G',9,'single',19,128,62,NULL,NULL,'exclusive',625,760,1,1,'9310055536333','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:03:59','2019-05-03 01:03:59',NULL),(946,'KELL CORN FLAKES 220G',9,'single',19,128,21,NULL,NULL,'exclusive',335,415,1,1,'9310055536340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:05:29','2019-05-03 01:05:29',NULL),(947,'KELL CORN FLAKES 380G',9,'single',19,128,21,NULL,NULL,'exclusive',490,670,1,1,'9310055537224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:06:49','2019-05-03 01:06:49',NULL),(948,'KELL CORN FLAKES 725G',9,'single',19,128,21,NULL,NULL,'exclusive',825,1000,1,1,'9310055559653','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:08:06','2019-05-03 01:08:06',NULL),(949,'KELL FROOT LOOPS 285G',9,'single',19,128,59,NULL,NULL,'exclusive',590,720,1,1,'9310055536586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:11:17','2019-05-03 01:11:17',NULL),(950,'KELL FROOT LOOPS 500G',9,'single',19,128,64,NULL,NULL,'exclusive',790,960,1,1,'9310055537279','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:12:56','2019-05-03 01:12:56',NULL),(951,'KELL RICE BUBBLES 410G',9,'single',19,128,64,NULL,NULL,'exclusive',495,600,1,1,'9310055537392','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:15:15','2019-05-03 01:15:15',NULL),(952,'KELL SPECIAL K 300G',9,'single',19,128,64,NULL,NULL,'exclusive',520,625,1,1,'9310055536449','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:16:40','2019-05-03 01:16:40',NULL),(953,'KELL SULTANA BRAN 420G',9,'single',19,128,64,NULL,NULL,'exclusive',525,640,1,1,'9310055536364','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:19:19','2019-05-03 01:19:19',NULL),(954,'KELL FROSTIES 350G',9,'single',19,128,64,NULL,NULL,'exclusive',485,585,1,1,'9310055536593','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 01:20:37','2019-05-03 01:20:37',NULL),(955,'Heinz  B/FOOD  A/A CUST STRW BANANA 110g',9,'single',19,13,64,NULL,NULL,'exclusive',110,165,1,1,'93206570','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 15:34:01','2020-07-22 22:08:59',NULL),(956,'Heinz  B/FOOD SIMPLY BANANA CUST PCH 120g',9,'single',19,13,64,NULL,NULL,'exclusive',150,185,1,1,'9300657160357','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 15:47:50','2019-05-10 18:28:45',NULL),(957,'Heinz B/FOOD  SIMPLY VAN CUSTARD 120g',9,'single',19,13,64,NULL,NULL,'exclusive',150,185,1,1,'9300657160340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 15:49:59','2019-05-10 18:29:13',NULL),(958,'Heinz  B/FOOD APPLE & OATMEAL 170g',9,'single',19,13,64,NULL,NULL,'exclusive',180,215,1,1,'9300657161538','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 15:52:30','2019-05-10 18:28:18',NULL),(959,'Heinz  B/ FOOD ORG PUMP RIC SPIN 170g',9,'single',19,13,64,NULL,NULL,'exclusive',180,215,1,1,'9300657162573','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 15:54:22','2019-05-10 18:27:15',NULL),(960,'Cottee\'s JAM PLUM  500g',9,'single',19,169,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801571','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:05:40','2019-07-03 19:44:04',NULL),(961,'Cottees JAM RASBERRY 500G',9,'single',19,169,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801540','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:10:25','2019-07-03 19:44:41',NULL),(962,'Cottees JAM MARM GINGER 500G',9,'single',19,169,23,NULL,NULL,'exclusive',510,640,1,1,'9300657801496','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:12:26','2019-07-03 19:43:14',NULL),(963,'IXL JAM PLUM 480G',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:28:12','2019-05-03 16:28:12',NULL),(964,'IXL JAM BLACKBERRY 480G',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003327','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:37:04','2019-05-03 16:37:04',NULL),(965,'IXL MARM GINGER 480G',9,'single',19,56,23,NULL,NULL,'exclusive',485,585,1,1,'9310013003303','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:41:46','2019-05-03 16:41:46',NULL),(966,'LEGGOS PASSATA ITAL HERB 700G',9,'single',19,170,32,NULL,NULL,'exclusive',530,645,1,1,'9300645019636','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:46:38','2019-05-03 16:46:38',NULL),(967,'LEGGOS PICKLES MUSTARD 500G',9,'single',19,170,32,NULL,NULL,'exclusive',350,425,1,1,'93645034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:48:54','2019-05-03 16:48:54',NULL),(968,'LEGGOS SQZ SCE PIZZA 400g',9,'single',19,170,32,NULL,NULL,'exclusive',430,525,1,1,'9300645014501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:52:17','2019-05-03 16:52:17',NULL),(969,'LEGGOS SQZ SCE PIZZA BBQ 400g',9,'single',19,170,32,NULL,NULL,'exclusive',430,525,1,1,'9300645014686','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:55:02','2019-05-03 16:55:02',NULL),(970,'LEGGOS TOM/PSTE GLASS 375g',9,'single',19,170,31,NULL,NULL,'exclusive',355,435,1,1,'93645096','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 16:57:05','2019-05-03 16:57:05',NULL),(971,'MF MUSTARD ENGLISH MILD 175G',9,'single',19,171,51,NULL,NULL,'exclusive',300,375,1,1,'93718660','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:05:18','2019-05-03 17:05:18',NULL),(972,'MF MUSTARD FRENCH 175G',9,'single',19,171,51,NULL,NULL,'exclusive',300,375,1,1,'93718677','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:06:20','2019-05-03 17:06:20',NULL),(973,'MF SCE CHILLI SWT SQZY 500ml',9,'single',19,171,32,NULL,NULL,'exclusive',315,385,1,1,'9310012024248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:08:15','2019-05-03 17:08:59',NULL),(974,'Freshwel Jelly Crystals 80gm (Mixed Fruits )',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529004216','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:09:44','2019-05-03 17:09:44',NULL),(975,'MASTERFOODS BARBECUE SAUCE SPICY 500ml',9,'single',19,171,32,NULL,NULL,'exclusive',395,480,1,1,'9310012043942','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:10:05','2019-08-24 19:53:42',NULL),(976,'Freshwel Jelly Crystals 80gm (Mango)',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529013089','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:11:07','2019-05-03 17:11:07',NULL),(977,'Freshwel Jelly Crystals 80gm (Raspberry )',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529013010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:12:37','2019-05-03 17:12:37',NULL),(978,'Freshwel Jelly Crystals 80gm (Banana )',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529013072','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:14:32','2019-05-03 17:14:32',NULL),(979,'Freshwel Jelly Crystals 80gm (Cherry )',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529013034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:16:05','2019-05-03 17:16:05',NULL),(980,'SANITARIUM UP&GO VANILLA  250 ml',9,'single',19,143,26,NULL,NULL,'exclusive',170,215,1,1,'9300652010589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:17:12','2019-05-15 19:23:04',NULL),(981,'NUTELLA HAZELNUT SPREAD COCOA 220G',9,'single',19,132,41,NULL,NULL,'exclusive',270,315,1,1,'9300698000643','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:18:53','2019-05-03 17:18:53',NULL),(982,'Freshwel Jelly Crystals 80gm (Orange )',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529013058','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:19:13','2019-05-03 17:19:13',NULL),(983,'Freshwel Jelly Crystals 80gm (Strawberry)',9,'single',19,172,51,NULL,NULL,'exclusive',80,95,1,1,'054529013027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 17:21:28','2019-05-03 17:21:28',NULL),(984,'Stute Superior Cranberry Juice Drink 1 lt',9,'single',19,155,24,NULL,NULL,'exclusive',280,335,1,1,'4006424185558','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 18:26:08','2020-08-27 23:13:18',NULL),(985,'Munchy\'s Oat Krunch Strawberry & Blackcurrent 208gm',9,'single',19,59,42,NULL,NULL,'exclusive',210,275,1,1,'9556439885141','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 18:48:01','2020-09-26 21:52:13',NULL),(986,'Munchys Oat Krunch Nutty Chocolate  208gm',9,'single',19,59,42,NULL,NULL,'exclusive',210,275,1,1,'9556439890817','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 18:54:26','2019-05-08 18:17:37',NULL),(987,'Munchy\'s Cracker Sandwich Butter Flav Cream 313gm',9,'single',19,59,42,NULL,NULL,'exclusive',265,350,1,1,'9556439887138','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 19:05:41','2019-05-03 19:05:41',NULL),(988,'Grante 100% Pure Pomegranate  and Cherry Juice 750',9,'single',19,80,24,NULL,NULL,'exclusive',400,490,1,1,'4760041300519','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:08:06','2019-05-21 20:53:18',NULL),(989,'Monin Blue Curacao Syrup 250ml',9,'single',19,173,15,NULL,NULL,'exclusive',330,330,1,1,'3052910015459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:40:17','2019-05-03 20:40:17',NULL),(990,'Monin Strawberry Syrup 250ml',9,'single',19,173,15,NULL,NULL,'exclusive',330,330,1,1,'3052910051297','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:42:40','2019-05-03 20:42:40',NULL),(991,'Monin Caramel Syrup 250ml',9,'single',19,173,36,NULL,NULL,'exclusive',330,330,1,1,'3052910013677','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:44:56','2019-05-03 20:44:56',NULL),(992,'Monin Hazelnut Syrup 250ml',9,'single',19,173,36,NULL,NULL,'exclusive',330,330,1,1,'3052910013745','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:46:21','2019-05-03 20:46:21',NULL),(993,'Monin Fruit Mix Strawberry 500ml',9,'single',19,173,36,NULL,NULL,'exclusive',715,870,1,1,'3052910036355','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:49:15','2019-05-03 20:49:15',NULL),(994,'Monin Fruit Mix Peach 500ml',9,'single',19,173,36,NULL,NULL,'exclusive',715,870,1,1,'3052910036379','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:51:03','2019-05-03 20:51:03',NULL),(995,'Monin Fruit Mix Mango 500ml',9,'single',19,173,36,NULL,NULL,'exclusive',715,870,1,1,'3052911217807','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:52:08','2019-05-03 20:52:08',NULL),(996,'Monin Fruit Mix Passion Fuit 500ml',9,'single',19,173,36,NULL,NULL,'exclusive',715,870,1,1,'3052910607005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:53:38','2019-05-03 20:53:38',NULL),(997,'Monin Caramel Sauce 500 ml',9,'single',19,173,36,NULL,NULL,'exclusive',660,800,1,1,'3052910044206','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:56:32','2019-05-03 20:56:32',NULL),(998,'Monin Dark Chocolate Sauce 500gm',9,'single',19,173,36,NULL,NULL,'exclusive',590,720,1,1,'3052910044220','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 20:58:23','2019-05-03 20:58:23',NULL),(999,'Foster Clarks Lemon 2.5 kg',9,'single',19,57,52,NULL,NULL,'exclusive',1150,1580,1,1,'5352101468322','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 21:58:12','2019-05-09 18:50:22',NULL),(1000,'Lay\'s Large- ASCO 52gm',9,'single',19,174,14,NULL,NULL,'exclusive',45,50,1,1,'8901491101813','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:14:17','2019-05-13 19:05:55',NULL),(1001,'OATS 1kg Pack',9,'single',19,99,28,NULL,NULL,'exclusive',550,575,1,1,'8901491204392','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:20:17','2020-07-19 23:15:29',NULL),(1002,'OATS Homestyle Masala 40g',9,'single',19,99,28,NULL,NULL,'exclusive',45,45,1,1,'8901491702621','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:23:05','2019-05-03 22:23:05',NULL),(1003,'OATS Kesar With Kishmish 40g',9,'single',19,99,28,NULL,NULL,'exclusive',45,45,1,1,'8901491702676','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:25:47','2019-05-03 22:25:47',NULL),(1004,'OATS Strawberry With apple 40gm',9,'single',19,99,28,NULL,NULL,'exclusive',45,45,1,1,'8901491702645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:28:33','2019-05-03 22:28:33',NULL),(1005,'OATS Tomato Veggie Surprise 40gm',9,'single',19,99,28,NULL,NULL,'exclusive',45,45,1,1,'8901491702911','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:30:42','2019-05-03 22:30:42',NULL),(1006,'Pringles Sour Cream & Onion 40gm',9,'single',19,101,14,NULL,NULL,'exclusive',85,100,1,1,'038000845529','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:57:22','2019-05-25 20:50:10',NULL),(1007,'GOLDEN GARDEN -SAKURA PLUM',9,'single',19,175,65,NULL,NULL,'exclusive',230,250,1,1,'6958147130002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:58:55','2019-05-03 22:58:55',NULL),(1008,'Pringles Original 37gm',9,'single',19,101,14,NULL,NULL,'exclusive',85,85,1,1,'038000845512','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 22:59:49','2019-05-03 22:59:49',NULL),(1010,'GOLDEN GARDEN -GREEN PLUM 220G',9,'single',19,175,65,NULL,NULL,'exclusive',230,250,1,1,'6958147106250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:01:50','2019-05-03 23:01:50',NULL),(1011,'GOLDEN GARDEN -CHERRY PLUM 220G',9,'single',19,175,65,NULL,NULL,'exclusive',230,250,1,1,'6958147106199','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:03:08','2019-05-03 23:03:08',NULL),(1012,'GOLDEN GARDEN -BLUEBERRY PLUM 220G',9,'single',19,175,65,NULL,NULL,'exclusive',230,250,1,1,'6958147106182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:04:50','2019-05-03 23:04:50',NULL),(1013,'GOLDEN GARDEN -BANBIAN PLUM 220G',9,'single',19,175,65,NULL,NULL,'exclusive',230,250,1,1,'6958147130019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:06:32','2019-05-03 23:06:32',NULL),(1014,'GOLDEN GARDEN -RED PLUM 220G',9,'single',19,175,65,NULL,NULL,'exclusive',230,250,1,1,'6958147106212','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:18:48','2019-05-03 23:18:48',NULL),(1015,'Olitalia Sunflower Oil 1lt',9,'single',19,NULL,29,NULL,NULL,'exclusive',255,265,1,1,'8007150900015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:54:17','2019-05-03 23:54:17',NULL),(1016,'Olitalia Sunflower Oil 2lt',9,'single',19,176,NULL,NULL,NULL,'exclusive',500,520,1,1,'8007150903504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:56:23','2019-05-03 23:56:23',NULL),(1017,'Olitalia Sunflower Oil 3lt',9,'single',19,176,29,NULL,NULL,'exclusive',750,775,1,1,'8007150906802','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-03 23:58:36','2019-05-03 23:58:36',NULL),(1018,'Olitalia Sunflower Oil 5lt',9,'single',19,176,29,NULL,NULL,'exclusive',1120,1270,1,1,'8007150900930','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:00:39','2019-05-04 00:00:39',NULL),(1019,'Olitalia Extra Virgin Olive Oil 500ml',9,'single',19,176,29,NULL,NULL,'exclusive',450,460,1,1,'657738000484','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:02:59','2019-05-04 00:02:59',NULL),(1020,'Olitalia Extra Virgin Olive Oil 1lt',9,'single',19,176,29,NULL,NULL,'exclusive',830,860,1,1,'657738000408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:04:32','2020-10-10 19:22:20',NULL),(1021,'Olitalia Pure Olive Oil Regular 100ml',9,'single',19,176,29,NULL,NULL,'exclusive',160,180,1,1,'8007150900428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:06:39','2019-05-04 00:06:39',NULL),(1022,'Olitalia Pomace Olive Oil 500ml',9,'single',19,176,29,NULL,NULL,'exclusive',340,340,1,1,'8007150902996','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:09:21','2019-05-04 00:09:21',NULL),(1023,'Olitalia Pomace Olive Oil 1lt',9,'single',19,176,29,NULL,NULL,'exclusive',600,620,1,1,'8007150902941','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:11:54','2020-10-10 19:21:53',NULL),(1024,'Tong Garden Salted Almonds 35gm',9,'single',19,177,53,NULL,NULL,'exclusive',95,100,1,1,'8850291290510','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:14:13','2019-05-04 00:14:13',NULL),(1025,'Tong Garden Salted Almonds-Can 140gm',9,'single',19,177,53,NULL,NULL,'exclusive',380,420,1,1,'8850291291500','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:15:52','2019-05-04 00:15:52',NULL),(1026,'Tong Garden Salted Cashew Nuts  40gm',9,'single',19,177,53,NULL,NULL,'exclusive',95,100,1,1,'8850291210464','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:22:38','2019-05-04 00:22:38',NULL),(1027,'Tong Garden Salted Cashew Nuts Can 150gm',9,'single',19,177,9,NULL,NULL,'exclusive',380,420,1,1,'8850291211409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:24:33','2019-05-04 00:24:33',NULL),(1028,'Tong Garden Salted Cocktails Nuts 40gm',9,'single',19,177,53,NULL,NULL,'exclusive',95,100,1,1,'8850291530463','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:27:36','2019-05-04 00:27:36',NULL),(1029,'Tong Garden Salted Cocktail Nuts Can 150gm',9,'single',19,177,53,NULL,NULL,'exclusive',380,420,1,1,'8850291531309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:30:26','2019-05-04 00:30:26',NULL),(1030,'Tong Garden Salted Pistachios 30gm',9,'single',19,177,9,NULL,NULL,'exclusive',95,100,1,1,'8850291010408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:33:23','2019-07-25 14:55:45',NULL),(1031,'Tong Garden Salted Pistachios 130gm',9,'single',19,177,9,NULL,NULL,'exclusive',380,420,1,1,'8850291281303','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:35:02','2019-07-25 14:55:23',NULL),(1032,'Tong Garden Salted Peanuts 150gm',9,'single',19,177,9,NULL,NULL,'exclusive',230,250,1,1,'8850291111600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:36:55','2019-07-25 14:54:53',NULL),(1033,'Tong Garden Sakura Plum Jar 200gm',9,'single',19,NULL,43,NULL,NULL,'exclusive',230,250,1,1,'8850291104909','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 00:38:38','2019-05-04 00:38:38',NULL),(1034,'Quaker Instant Oatmeal 1kg',9,'single',19,99,28,NULL,NULL,'exclusive',510,600,1,1,'9556174802175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 16:06:36','2020-08-27 23:24:35',NULL),(1035,'HORLICKS  Traditional 500gm',9,'single',19,151,60,NULL,NULL,'exclusive',430,500,1,1,'5000347098376','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 16:11:46','2019-05-04 16:11:46',NULL),(1036,'Hibiscus whole Baby Corn in Brine 425 gm',9,'single',19,92,11,NULL,NULL,'exclusive',75,95,1,1,'8848702050778','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 16:15:11','2019-05-04 16:15:11',NULL),(1037,'Nutcandy Salted Cashew Nuts 140g',9,'single',19,121,9,NULL,NULL,'exclusive',330,375,1,1,'8855282101400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 16:27:57','2020-08-27 22:57:21',NULL),(1038,'Nutcandy Salted Pistachios 140g',9,'single',19,121,9,NULL,NULL,'exclusive',355,400,1,1,'8855282101646','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 16:50:06','2020-09-24 14:32:58',NULL),(1039,'Nutcandy Wasabi Coated Green Peas 180 gm',9,'single',19,121,9,NULL,NULL,'exclusive',190,215,1,1,'8855282100915','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 16:54:51','2020-09-24 14:37:51',NULL),(1041,'No1 YUMNUTS 500G',9,'single',19,180,53,NULL,NULL,'exclusive',420,475,1,1,'8850291109423','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 17:54:18','2020-08-27 22:52:55',NULL),(1042,'No 1 SALTED PEANUTS 400G',9,'single',19,180,53,NULL,NULL,'exclusive',415,460,1,1,'8850291110177','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:05:20','2020-08-27 22:51:54',NULL),(1043,'NO 1 Party Snack 28 gm',9,'single',19,180,53,NULL,NULL,'exclusive',120,125,1,1,'8850291106088','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:12:23','2020-08-27 22:50:12',NULL),(1045,'NO 1 Salted Peanut 110g',9,'single',19,180,53,NULL,NULL,'exclusive',120,125,1,1,'8850291105982','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:19:21','2019-07-20 19:42:47',NULL),(1046,'NO 1 Cuttlefish Cotated Green Peas 110g',9,'single',19,180,53,NULL,NULL,'exclusive',110,125,1,1,'8850291106064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:23:20','2019-05-04 18:23:20',NULL),(1047,'NO 1 Salted Cashew 35g',9,'single',19,180,53,NULL,NULL,'exclusive',85,95,1,1,'8855282101035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:27:43','2020-09-24 14:30:21',NULL),(1048,'NO 1 Salted Pistachios 35g',9,'single',19,180,53,NULL,NULL,'exclusive',85,95,1,1,'8855282100885','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:29:59','2019-05-04 18:29:59',NULL),(1050,'NO 1 Sesame Coated P With Cra. 50g',9,'single',19,180,53,NULL,NULL,'exclusive',55,60,1,1,'8850291110344','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:33:49','2019-05-04 18:33:49',NULL),(1051,'NO 1 Salted Cashew 128g',9,'single',19,180,53,NULL,NULL,'exclusive',260,295,1,1,'8850291105937','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:38:32','2019-05-04 18:38:32',NULL),(1052,'NO 1 Honey Almonds 128g',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',260,295,1,1,'8850291105975','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:42:34','2019-05-04 18:42:34',NULL),(1053,'NO 1 Salted Cocktail Nuts 128g',9,'single',19,180,53,NULL,NULL,'exclusive',260,295,1,1,'8850291105951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:47:13','2020-08-27 22:55:34',NULL),(1054,'Daily Fresh Sakura Plum 200gm',9,'single',19,178,65,NULL,NULL,'exclusive',155,175,1,1,'8094','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 18:51:35','2020-09-24 14:44:05',NULL),(1055,'Bragg Organic Apple Cider Vinagar 473ml',9,'single',19,181,39,NULL,NULL,'exclusive',430,490,1,1,'074305001161','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 19:10:37','2020-09-08 21:30:42',NULL),(1056,'Bragg Organic Apple Cider Vinagar 946ml',9,'single',19,181,39,NULL,NULL,'exclusive',855,975,1,1,'074305001321','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 19:12:28','2020-09-08 21:30:21',NULL),(1057,'NUTELLA Ferrero  COCOA 750g',9,'single',19,132,41,NULL,NULL,'exclusive',680,775,1,1,'4008400404127','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 19:25:43','2019-12-02 16:12:01',NULL),(1058,'Dewberry Blueberry Flv 432g (12X36g)',9,'single',19,182,5,NULL,NULL,'exclusive',375,425,1,1,'8850309201705','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 19:32:08','2019-05-04 19:32:08',NULL),(1059,'Dewberry Strawberry Flv 432g (12X36g)',9,'single',19,182,5,NULL,NULL,'exclusive',375,425,1,1,'8850309201743','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 19:36:47','2019-05-04 19:36:47',NULL),(1060,'BOUNTY 285GM 5 packs',9,'single',19,118,15,NULL,NULL,'exclusive',450,490,1,1,'5000159434539','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 20:05:49','2019-05-04 20:05:49',NULL),(1062,'Freshwel Quorma Masala 50g',9,'single',19,172,66,NULL,NULL,'exclusive',75,83,1,1,'054529006401','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:23:33','2019-05-04 21:23:33',NULL),(1063,'Freshwel Tikka Boti BBQ Masala 50g',9,'single',19,183,66,NULL,NULL,'exclusive',75,83,1,1,'054529507113','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:26:57','2019-05-04 21:26:57',NULL),(1064,'Freshwel Bombay Biryani Masala 60g',9,'single',19,183,66,NULL,NULL,'exclusive',80,90,1,1,'054529006333','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:29:53','2019-05-04 21:29:53',NULL),(1065,'Freshwel Chicken Biryani Masala 60g',9,'single',19,183,66,NULL,NULL,'exclusive',80,90,1,1,'054529506970','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:33:14','2019-05-04 21:33:14',NULL),(1066,'Freshwel Mutton Biryani Masala 60g',9,'single',19,183,66,NULL,NULL,'exclusive',80,90,1,1,'054529506949','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:35:53','2019-05-04 21:35:53',NULL),(1067,'Pedia Sure 1600 gm',9,'single',19,184,67,NULL,NULL,'exclusive',3000,3100,1,1,'8886451085603','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:36:49','2020-09-08 16:26:27',NULL),(1068,'Freshwel Sindhi Biryani Masala 60g',9,'single',19,183,66,NULL,NULL,'exclusive',80,90,1,1,'054529006579','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:37:52','2019-05-04 21:37:52',NULL),(1069,'Pedia Sure Complete 900 gm',9,'single',19,184,67,NULL,NULL,'exclusive',1590,1700,1,1,'8886451085177','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:39:13','2020-09-08 16:25:20',NULL),(1070,'Freshwel Pullao Biryani Masala 75g',9,'single',19,183,66,NULL,NULL,'exclusive',80,90,1,1,'054529506932','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:40:26','2019-05-04 21:40:26',NULL),(1071,'Pedia Sure Vanilla Flavour Jar 1 kg',9,'single',19,184,67,NULL,NULL,'exclusive',1600,1645,1,1,'8904145911660','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:42:46','2019-05-04 21:42:46',NULL),(1072,'Freshwel Haleem  Masala 100g',9,'single',19,183,66,NULL,NULL,'exclusive',75,83,1,1,'7014182006371','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:42:51','2019-05-04 21:42:51',NULL),(1073,'Pedia Sure Cookies & Cream Flavour 400 gm',9,'single',19,184,67,NULL,NULL,'exclusive',680,740,1,1,'8904145911776','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:48:14','2019-05-21 02:38:31',NULL),(1074,'Freshwel Chat  Masala 50g',9,'single',19,183,66,NULL,NULL,'exclusive',75,83,1,1,'054529006340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:51:26','2019-05-04 21:51:26',NULL),(1075,'Pedia Sure Vanilla Flavour jar 400 gm',9,'single',19,184,67,NULL,NULL,'exclusive',735,746,1,1,'8904145911653','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:51:34','2019-05-04 21:51:34',NULL),(1077,'Pedia Sure Chocolate Jar 400 gm',9,'single',19,184,67,NULL,NULL,'exclusive',735,746,1,1,'8904145911684','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:53:56','2019-05-04 21:53:56',NULL),(1078,'Freshwel Chicken Tikka BBQ Masala 50g',9,'single',19,183,66,NULL,NULL,'exclusive',75,83,1,1,'054529507069','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:54:06','2019-05-04 21:54:06',NULL),(1079,'Freshwel Tandoori Masala 50g',9,'single',19,183,66,NULL,NULL,'exclusive',75,83,1,1,'054529006524','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:55:11','2019-05-04 21:55:11',NULL),(1080,'Freshwel Crème Caramel 85g',9,'single',19,183,41,NULL,NULL,'exclusive',70,75,1,1,'054529013317','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 21:57:00','2019-05-04 21:57:00',NULL),(1081,'Ensure Vanilla Flavour Jar 400 gm',9,'single',19,185,67,NULL,NULL,'exclusive',690,698,1,1,'8904145911257','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:00:03','2020-10-21 14:41:26',NULL),(1082,'Ensure Plus vanilla flavor Jar 400 gm',9,'single',19,185,67,NULL,NULL,'exclusive',785,796,1,1,'8904145911509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:02:32','2019-05-04 22:02:32',NULL),(1083,'Ensure Diabetes Care Vanilla Flavor 400 gm',9,'single',19,185,67,NULL,NULL,'exclusive',915,881,1,1,'8904145911400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:05:50','2019-09-24 18:32:47',NULL),(1084,'Freshwel Haleem Masala 100 gm',9,'single',19,172,66,NULL,NULL,'exclusive',75,83,1,1,'054529006371','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:10:38','2019-05-04 22:10:38',NULL),(1085,'Ensure Vanilla Flavor 1 kg',9,'single',19,185,67,NULL,NULL,'exclusive',1575,1605,1,1,'8904145911271','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:14:23','2019-05-04 22:14:23',NULL),(1086,'Freshwel Chicken  Masala 50g',9,'single',19,183,66,NULL,NULL,'exclusive',75,83,1,1,'054529006357','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:14:58','2019-05-04 22:14:58',NULL),(1087,'Complan Chocolate jar 450 gm',9,'single',19,186,67,NULL,NULL,'exclusive',490,500,1,1,'8901542000256','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:35:17','2019-05-04 22:35:17',NULL),(1088,'Complan Chocolate Box 350 gm',9,'single',19,186,67,NULL,NULL,'exclusive',380,385,1,1,'8901542000461','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:37:25','2019-05-04 22:37:25',NULL),(1089,'Glucon-D Lime 400 gm',9,'single',19,187,52,NULL,NULL,'exclusive',230,240,1,1,'8901542013140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:39:48','2019-05-04 22:39:48',NULL),(1090,'Glucon D Orange 400 gm',9,'single',19,187,52,NULL,NULL,'exclusive',230,240,1,1,'8901542013010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:43:14','2019-05-04 22:43:14',NULL),(1095,'Pop Corn Triple Butter(Poppin)100gm',9,'single',19,135,58,NULL,NULL,'exclusive',135,160,1,1,'9310273211739','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 22:53:06','2019-05-04 22:53:06',NULL),(1096,'Snickers Fun size 18 gm x 40 pcs',9,'single',19,120,15,NULL,NULL,'exclusive',720,800,1,1,'40111308','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-04 23:55:49','2019-05-09 17:45:14',NULL),(1097,'Snickers Share Pack 180 gm',9,'single',19,120,15,NULL,NULL,'exclusive',210,225,1,1,'3340442514145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:01:30','2019-05-05 00:01:30',NULL),(1098,'Snickers Minis 150 gm',9,'single',19,120,15,NULL,NULL,'exclusive',230,2350,1,1,'4011100037915','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:06:23','2019-05-05 00:06:23',NULL),(1099,'Britannia Digestive Biscuits 400 gm',9,'single',19,188,5,NULL,NULL,'exclusive',280,300,1,1,'8901063151024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:12:19','2019-05-05 00:12:19',NULL),(1100,'Britannia Chocolate Flavored 175 gm',9,'single',19,188,55,NULL,NULL,'exclusive',175,180,1,1,'8901063151048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:14:25','2019-05-05 00:14:25',NULL),(1101,'Britannia Wafer Hazelnut 175 gm',9,'single',19,188,55,NULL,NULL,'exclusive',175,186,1,1,'8901063151031','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:16:17','2019-05-05 00:16:17',NULL),(1102,'Britannia Milk Caramel Flavored',9,'single',19,188,55,NULL,NULL,'exclusive',175,188,1,1,'8901063151208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:17:56','2019-05-05 00:17:56',NULL),(1103,'ACT II Butter Delite Flavor 70 gm',9,'single',19,189,58,NULL,NULL,'exclusive',45,55,1,1,'8901512541901','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:52:29','2019-05-05 00:53:51',NULL),(1104,'ACT II Butter Pepper Flavor 70 gm',9,'single',19,189,58,NULL,NULL,'exclusive',45,55,1,1,'8901512540508','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 00:55:31','2019-05-05 00:55:31',NULL),(1105,'ACT II  Xtreme Butter Flavor 70 gm',9,'single',19,189,58,NULL,NULL,'exclusive',45,55,1,1,'8901512546104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 01:03:39','2019-05-06 20:38:02',NULL),(1106,'ACT II Movie Theater  Butter  Flavor 70 gm',9,'single',19,189,58,NULL,NULL,'exclusive',55,55,1,1,'8901512556301','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 01:05:53','2019-05-05 01:05:53',NULL),(1107,'ACT II Natural Popcorn 99 gm',9,'single',19,189,58,NULL,NULL,'exclusive',100,110,1,1,'8901512500601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 01:10:47','2019-05-05 01:10:47',NULL),(1108,'Act II Butter Flavor 99 gm',9,'single',19,189,58,NULL,NULL,'exclusive',110,110,1,1,'8901512500205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 01:13:19','2019-05-05 01:13:19',NULL),(1109,'Act II Butter Lovers Flavor 99 gm',9,'single',19,189,58,NULL,NULL,'exclusive',110,110,1,1,'8901512500403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 01:15:31','2019-05-05 01:15:31',NULL),(1110,'Lacy\'s Aluminium foil (Heavy Duty) 300mX45cm',9,'single',19,46,48,NULL,NULL,'exclusive',3900,3900,1,1,'017581067124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 16:44:29','2019-05-05 16:44:29',NULL),(1111,'Wrigleys Eclipse Mints Blackcurrant  35g',9,'single',19,130,22,NULL,NULL,'exclusive',150,199,1,1,'9555192507529','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 21:14:59','2019-05-05 21:14:59',NULL),(1112,'Galaxy milk  pkt 150g',9,'single',19,110,15,NULL,NULL,'exclusive',500,500,1,1,'6294001820314','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 21:39:53','2019-05-05 21:39:53',NULL),(1113,'Trident Spearmint Gum 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',145,145,1,1,'070221008703','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 21:46:05','2019-10-11 18:34:46',NULL),(1114,'CH Green Peas 150 gm',9,'single',19,191,53,NULL,NULL,'exclusive',180,210,1,1,'8888100192007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 22:29:25','2019-05-05 22:29:25',NULL),(1115,'CH Salted Peanuts 150 gm',9,'single',19,191,53,NULL,NULL,'exclusive',180,210,1,1,'8888100212002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 22:33:39','2019-05-05 22:33:39',NULL),(1116,'CH Peanut Cheese Ball 150 gm',9,'single',19,191,53,NULL,NULL,'exclusive',200,230,1,1,'8888100081509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 22:37:11','2019-05-05 22:37:11',NULL),(1117,'CH Peanut Crackers 150 gm',9,'single',19,191,53,NULL,NULL,'exclusive',200,230,1,1,'8888100132003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 22:38:19','2019-05-05 22:38:19',NULL),(1118,'CH Mixed Nuts 150 gm',9,'single',19,191,53,NULL,NULL,'exclusive',215,250,1,1,'8888100052004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 22:51:16','2019-05-05 22:51:16',NULL),(1119,'CH Mixted Nuts 500 gm',9,'single',19,191,53,NULL,NULL,'exclusive',600,695,1,1,'8888100455003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 22:52:57','2019-05-05 22:52:57',NULL),(1120,'Morde Dark Chocolate CHD45-500 gm',9,'single',19,192,15,NULL,NULL,'exclusive',450,500,1,1,'8906051680005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:09:54','2019-05-05 23:09:54',NULL),(1121,'Orsa Caramel Syrup-750 ml',9,'single',19,193,36,NULL,NULL,'exclusive',945,1050,1,1,'8057829312076','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:17:49','2019-05-05 23:17:49',NULL),(1122,'Orsa Green Mint Syrup-750 ml',9,'single',19,193,36,NULL,NULL,'exclusive',945,1050,1,1,'8057829310744','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:19:39','2019-05-05 23:19:39',NULL),(1123,'Orsa Hazelnut Syrup-750 ml',9,'single',19,193,36,NULL,NULL,'exclusive',945,1050,1,1,'8057829310737','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:21:05','2019-05-05 23:21:05',NULL),(1124,'Quaker Oats 500 gm Pack',9,'single',19,99,28,NULL,NULL,'exclusive',240,265,1,1,'8901491702898','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:21:48','2019-10-21 18:31:53',NULL),(1125,'Orsa Vanilla Syrup-750 ml',9,'single',19,193,36,NULL,NULL,'exclusive',945,1050,1,1,'8057829312083','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:22:03','2019-05-05 23:22:03',NULL),(1126,'Doritos Heatwave 35 gm',9,'single',19,194,14,NULL,NULL,'exclusive',65,65,1,1,'8901491990264','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:24:09','2019-05-05 23:24:09',NULL),(1128,'Doritos Spicy Sweet Chilli 75 gm',9,'single',19,194,14,NULL,NULL,'exclusive',115,125,1,1,'8901491990097','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:34:04','2019-05-05 23:34:04',NULL),(1129,'Lay\'s Spanish Tomato Tango 52 gm',9,'single',19,46,14,NULL,NULL,'exclusive',50,50,1,1,'8901491101820','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:36:19','2019-06-04 17:29:30',NULL),(1130,'Lay\'s Classic Salted 25 gm',9,'single',19,46,14,NULL,NULL,'exclusive',25,25,1,1,'8901491503013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:38:01','2019-05-08 17:34:59',NULL),(1131,'Doritos Spicy Sweet Chilli 150 gm',9,'single',19,194,14,NULL,NULL,'exclusive',240,250,1,1,'8901491990035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-05 23:41:49','2019-05-05 23:41:49',NULL),(1132,'Morde Dark Compound COD15-2.1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',1,1450,1,1,'100002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:27:25','2019-05-06 00:27:25',NULL),(1133,'Morde Milk Compound COM21-2.1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',1305,1450,1,1,'100003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:29:01','2019-05-06 00:29:01',NULL),(1134,'Morde White Compound COW33-2.1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',1305,1450,1,1,'100004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:30:31','2019-05-06 00:30:31',NULL),(1135,'Morde White Compound COW33-2.1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',1305,1450,1,1,'100004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:30:32','2019-05-06 00:30:32',NULL),(1136,'Morde Compound Mango COOFL07-500 gm',9,'single',19,190,15,NULL,NULL,'exclusive',378,420,1,1,'100005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:31:50','2019-05-06 00:31:50',NULL),(1137,'Morde Compound Strawberry COOFL08-500 gm',9,'single',19,190,15,NULL,NULL,'exclusive',378,420,1,1,'100006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:32:53','2019-05-06 00:32:53',NULL),(1138,'Morde Compound Orange COOFL06-500 gm',9,'single',19,190,15,NULL,NULL,'exclusive',378,420,1,1,'100007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:33:53','2019-05-06 00:33:53',NULL),(1139,'Morde Priya Choco Strand STD-1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',684,760,1,1,'100008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:35:22','2019-05-06 00:35:22',NULL),(1140,'Morde Choco Filling Coffee FL CF3-1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',936,1040,1,1,'100009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:36:44','2019-05-06 00:36:44',NULL),(1141,'Morde Choco Filling Caramel  FL CRL-1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',936,1040,1,1,'100010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:38:07','2019-05-06 00:38:07',NULL),(1142,'Morde Choco Filling Hazelnut  FLH16-1 kg',9,'single',19,190,15,NULL,NULL,'exclusive',1530,1700,1,1,'100011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 00:40:18','2019-05-06 00:40:18',NULL),(1148,'Orgran Apple Cinnamon & Pancake Mix 375 gm',9,'single',19,22,51,NULL,NULL,'exclusive',867.5,975,1,1,'720516020216','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 16:44:33','2019-05-06 16:44:33',NULL),(1149,'Orgran Buckwheat Pancake Mix 375gm',9,'single',19,22,51,NULL,NULL,'exclusive',867.5,975,1,1,'720516010712','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 16:47:24','2019-05-06 16:47:24',NULL),(1150,'Orgran Plain Flour All Purpose 500gm',9,'single',19,22,51,NULL,NULL,'exclusive',777.5,875,1,1,'720516020551','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 16:50:28','2019-05-09 16:14:19',NULL),(1151,'Orgran Itsy bristy Brars 175g',9,'single',19,22,5,NULL,NULL,'exclusive',867.5,975,1,1,'720516021756','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:02:05','2019-05-06 17:02:05',NULL),(1152,'Organ Gluten Outback Animals Cookies Chocolate 175 gm',9,'single',19,22,18,NULL,NULL,'exclusive',867.5,975,1,1,'720516021459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:21:44','2019-05-06 17:21:44',NULL),(1153,'Comfort Ultra Pure White 800 gm',9,'single',19,195,48,NULL,NULL,'exclusive',390,445,1,1,'8934868093190','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:36:36','2019-05-25 21:47:26',NULL),(1154,'Fab Perfect Detergent 2.3 kg',9,'single',19,196,48,NULL,NULL,'exclusive',885,1180,1,1,'4902430774031','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:45:41','2019-05-12 21:42:08',NULL),(1155,'Breeze Liquid Detergent 2.6 lt Power Clean',9,'single',19,197,48,NULL,NULL,'exclusive',1030,1375,1,1,'9556126648790','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:52:04','2020-09-08 21:37:00',NULL),(1156,'Aluminium Foil (Diamond) 37.5sft',9,'single',19,198,48,NULL,NULL,'exclusive',340,390,1,1,'010900000871','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:57:27','2019-05-06 17:57:27',NULL),(1157,'Glad Cling Wrap 200sft',9,'single',19,199,48,NULL,NULL,'exclusive',368,420,1,1,'012587000205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 17:59:19','2019-05-06 17:59:19',NULL),(1158,'Cowhead UHT Milk Lactose Free 1 lit',9,'single',19,84,26,NULL,NULL,'exclusive',210,265,1,1,'8888440008716','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 18:20:45','2020-09-08 16:21:59',NULL),(1159,'Cocoa Lab Chocolate CLJW 001 88 gm',9,'single',19,200,15,NULL,NULL,'exclusive',160,195,1,1,'100012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:24:45','2019-05-06 20:24:45',NULL),(1160,'Cocoa Lab Chocolate CB Sweet Love 60 gm',9,'single',19,200,15,NULL,NULL,'exclusive',100,125,1,1,'100013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:27:28','2019-05-06 20:27:28',NULL),(1161,'Cocoa Lab Chocolate CD1801 Date Chocolate 160 gm',9,'single',19,200,15,NULL,NULL,'exclusive',200,250,1,1,'100014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:28:51','2019-05-06 20:28:51',NULL),(1162,'Cocoa Lab Chocolate CLM006 117 gm',9,'single',19,200,15,NULL,NULL,'exclusive',370,475,1,1,'100015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:30:33','2019-05-06 20:30:33',NULL),(1163,'Cocoa Lab Chocolate CLSS007 100 gm',9,'single',19,200,15,NULL,NULL,'exclusive',310,390,1,1,'100016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:31:48','2019-05-06 20:31:48',NULL),(1164,'Cocoa Lab Chocolate Glass CG1815 150 gm',9,'single',19,200,15,NULL,NULL,'exclusive',300,385,1,1,'100017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:33:56','2019-06-17 19:01:37',NULL),(1165,'Cocoa Lab Chocolate CB1801 Sweet Love',9,'single',19,200,15,NULL,NULL,'exclusive',1020,1300,1,1,'100018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:35:19','2019-05-06 20:35:19',NULL),(1166,'Cocoa Lab Chocolate CB1701 H/B Bar 160 gm',9,'single',19,200,15,NULL,NULL,'exclusive',200,250,1,1,'100019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:36:17','2019-05-06 20:36:17',NULL),(1167,'Cocoa Lab CB Baby Boy 120 gm',9,'single',19,200,15,NULL,NULL,'exclusive',175,220,1,1,'100020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 20:37:11','2019-06-17 19:02:47',NULL),(1168,'NESTLE EVERYDAY Pouch  500 gm',9,'single',19,63,26,NULL,NULL,'exclusive',280,280,1,1,'8941100293720','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:02:31','2020-11-16 18:16:52',NULL),(1169,'MILO Cereal BIB 330 gm',9,'single',19,63,67,NULL,NULL,'exclusive',360,360,1,1,'4800361291446','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:08:59','2019-05-06 21:08:59',NULL),(1170,'NIDO 3+  350 gm',9,'single',19,63,67,NULL,NULL,'exclusive',350,350,1,1,'8941100292952','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:11:26','2019-05-06 21:11:26',NULL),(1171,'NIDO 1+  350 gm',9,'single',19,63,67,NULL,NULL,'exclusive',350,350,1,1,'8941100292945','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:15:30','2019-05-06 21:15:30',NULL),(1173,'NIDO Fortified BIB  350 gm',9,'single',19,63,67,NULL,NULL,'exclusive',260,260,1,1,'8941100292907','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:20:35','2019-05-06 21:20:35',NULL),(1174,'NIDO Fortified BIB  700 gm',9,'single',19,63,67,NULL,NULL,'exclusive',510,510,1,1,'8941100292969','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:27:34','2019-05-07 16:01:06',NULL),(1175,'NIDO Fortified Tin 2.5 kg',9,'single',19,63,67,NULL,NULL,'exclusive',2290,2290,1,1,'8941100290507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 21:32:44','2019-05-06 21:32:44',NULL),(1176,'NIDO Fortified Tin  900 gm',9,'single',19,63,67,NULL,NULL,'exclusive',890,890,1,1,'8941100290293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:38:15','2019-05-06 22:38:15',NULL),(1177,'Nestea Ice Tea Lemon 500 gm',9,'single',19,63,37,NULL,NULL,'exclusive',280,300,1,1,'8941100292037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:41:35','2019-05-12 00:09:24',NULL),(1178,'Nestle Coco Krunch  Big 330 gm',9,'single',19,63,21,NULL,NULL,'exclusive',340,350,1,1,'4800361000239','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:44:56','2019-06-25 23:15:15',NULL),(1179,'Nestle Coco Krunch  Small 170 gm',9,'single',19,63,21,NULL,NULL,'exclusive',200,200,1,1,'4800361002851','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:46:36','2019-05-06 22:46:36',NULL),(1180,'Nestle Corn Flakes 275 gm',9,'single',19,63,21,NULL,NULL,'exclusive',320,330,1,1,'4800361005500','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:47:58','2019-06-25 23:16:05',NULL),(1181,'Nestle koko crunch Duo 330 gm',9,'single',19,63,21,NULL,NULL,'exclusive',350,350,1,1,'4800361356367','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:49:58','2019-05-07 15:49:24',NULL),(1182,'Nestle Cerelac Rice & Milk 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',290,290,1,1,'8941100293546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:52:57','2019-05-06 22:52:57',NULL),(1183,'Nestle Cerelac Rice & Potato With Chicken 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',400,400,1,1,'8941100293485','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:55:31','2019-05-06 22:55:31',NULL),(1184,'Nestle Cerelac  5 Fruits & Multigrain 350 gm',9,'single',19,63,59,NULL,NULL,'exclusive',450,450,1,1,'8941100293942','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:57:24','2019-05-06 22:57:24',NULL),(1185,'Nestle Cerelac Wheat & Mixed Fruits 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',375,375,1,1,'8941100293522','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 22:58:47','2019-05-06 22:58:47',NULL),(1186,'Nestle Cerelac  Wheat With Apple & Cherry 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',350,350,1,1,'8941100293478','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:00:37','2019-05-06 23:00:37',NULL),(1188,'Nestle Cerelac Wheat With Apple & CF 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',400,400,1,1,'8941100293461','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:01:56','2019-05-06 23:01:56',NULL),(1190,'Nestle Cerelac  Wheat With 3 Fruits 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',325,325,1,1,'8941100293454','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:38:46','2019-05-06 23:38:46',NULL),(1192,'Nestle Cerelac  With Honey  & Dates 350 gm',9,'single',19,63,64,NULL,NULL,'exclusive',400,400,1,1,'8941100293805','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:40:20','2019-05-06 23:40:20',NULL),(1194,'Nestle Cerelac  Wheat & Milk 400 gm',9,'single',19,63,59,NULL,NULL,'exclusive',300,300,1,1,'8941100293508','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:41:34','2019-05-06 23:41:34',NULL),(1195,'Nestle Coffee Mate 450 gm',9,'single',19,63,16,NULL,NULL,'exclusive',270,270,1,1,'8941100294093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:42:50','2019-05-06 23:42:50',NULL),(1196,'Lactogen 4 350 gm',9,'single',19,63,59,NULL,NULL,'exclusive',450,450,1,1,'4800361407861','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:53:31','2019-05-06 23:53:31',NULL),(1198,'Nestle Nan 3 350 gm',9,'single',19,63,59,NULL,NULL,'exclusive',620,620,1,1,'4800361405768','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-06 23:59:29','2019-05-06 23:59:29',NULL),(1199,'Nestle Nan 4 350 gm',9,'single',19,63,59,NULL,NULL,'exclusive',600,600,1,1,'4800361405782','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:01:26','2019-05-07 00:01:26',NULL),(1200,'Nestle Nan 1 400 gm TIN',9,'single',19,63,59,NULL,NULL,'exclusive',830,830,1,1,'4800361370448','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:03:20','2019-05-07 00:03:20',NULL),(1201,'Nestle Nan 2  400 gm TIN',9,'single',19,63,59,NULL,NULL,'exclusive',830,830,1,1,'4800361375696','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:05:48','2019-05-07 00:05:48',NULL),(1202,'Maggi Oyster Sauce 350 gm',9,'single',19,63,32,NULL,NULL,'exclusive',130,150,1,1,'8934804004044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:07:45','2019-05-26 00:45:15',NULL),(1204,'Maggi Soya Sauce 700 ml',9,'single',19,63,32,NULL,NULL,'exclusive',220,220,1,1,'8934804026817','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:09:32','2019-05-07 00:09:32',NULL),(1206,'Maggi Noodles 496 gm',9,'single',19,63,27,NULL,NULL,'exclusive',130,130,1,1,'8941100294420','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:16:17','2019-05-07 00:16:17',NULL),(1207,'Maggi Noodles Masala 248 gm',9,'single',19,63,27,NULL,NULL,'exclusive',66,66,1,1,'8941100292846','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:20:33','2019-05-07 00:20:33',NULL),(1208,'Maggi Noodles Curry 248 gm',9,'single',19,63,27,NULL,NULL,'exclusive',66,66,1,1,'8941100292860','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:21:34','2019-05-07 00:21:34',NULL),(1209,'Maggi Noodles Curry 496 gm',9,'single',19,63,27,NULL,NULL,'exclusive',130,130,1,1,'8941100292877','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:22:41','2019-05-07 00:22:41',NULL),(1211,'Maggi Soup chicken 25 gm',9,'single',19,63,63,NULL,NULL,'exclusive',35,35,1,1,'8941100291344','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:24:11','2019-05-07 00:24:11',NULL),(1212,'Maggi Soup Thai 25 gm',9,'single',19,63,63,NULL,NULL,'exclusive',35,35,1,1,'8941100291351','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:25:05','2019-05-07 00:25:05',NULL),(1213,'Maggi Soup Vegetable 25 gm',9,'single',19,63,63,NULL,NULL,'exclusive',35,35,1,1,'8941100291368','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:26:27','2019-05-07 00:26:27',NULL),(1214,'Maggi Saad E Magic 4 gm',9,'single',19,63,66,NULL,NULL,'exclusive',5,5,1,1,'8941100291924','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:28:31','2019-05-07 00:28:31',NULL),(1216,'Lactogen 2 350gm',9,'single',19,63,59,NULL,NULL,'exclusive',490,490,1,1,'8901058860054','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:30:43','2019-05-07 00:30:43',NULL),(1217,'Lactogen 1 350 gm',9,'single',19,63,59,NULL,NULL,'exclusive',490,490,1,1,'8901058860030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:31:45','2019-05-07 00:55:13',NULL),(1218,'Lactogen 3 350gm',9,'single',19,63,59,NULL,NULL,'exclusive',480,480,1,1,'8901058860085','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:33:09','2019-05-07 00:33:09',NULL),(1220,'Lactogen 3 400 gm tin',9,'single',19,63,59,NULL,NULL,'exclusive',600,600,1,1,'8901058860092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:34:11','2019-05-07 16:07:06',NULL),(1221,'Lactogen 1 400 gm tin',9,'single',19,63,59,NULL,NULL,'exclusive',610,610,1,2,'8901058860047','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:35:18','2019-05-07 00:35:18',NULL),(1222,'Lactogen 2 400 gm tin',9,'single',19,63,59,NULL,NULL,'exclusive',610,610,1,1,'8901058860061','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:36:15','2019-05-07 00:36:15',NULL),(1224,'Nescafe Classic Jar 200 gm',9,'single',19,63,16,NULL,NULL,'exclusive',495,495,1,1,'8901058841091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:37:51','2020-09-18 21:31:15',NULL),(1225,'Nescafe Classic 100 gm',9,'single',19,138,16,NULL,NULL,'exclusive',300,300,1,1,'8941100294161','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:38:58','2019-05-07 00:38:58',NULL),(1226,'Nescafe Classic Jar 50 gm',9,'single',19,138,16,NULL,NULL,'exclusive',165,165,1,1,'8901058841138','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-07 00:41:01','2019-05-07 00:41:01',NULL),(1227,'NESTLE MINI MIX 520GM',9,'single',19,63,15,NULL,NULL,'exclusive',1300,1500,1,1,'7613036321044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-08 17:28:13','2019-05-08 17:28:13',NULL),(1228,'Purefig Stevia 100 gm',9,'single',19,201,35,NULL,NULL,'exclusive',850,950,1,1,'325367126836','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-09 20:54:07','2019-05-09 20:54:07',NULL),(1229,'Stute Superior Cranberry Juice Drink 1.5 lt',9,'single',19,155,24,NULL,NULL,'exclusive',390,480,1,1,'4006424010201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:42:14','2019-05-10 23:42:14',NULL),(1230,'Sunquick Campuran Mangga Mixed Mango Juice 840 ml',9,'single',19,202,24,NULL,NULL,'exclusive',470,570,1,1,'9556107333103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:43:31','2019-05-10 23:46:49',NULL),(1231,'Sunquick Lemon Juice 840 ml',9,'single',19,202,24,NULL,NULL,'exclusive',470,570,1,1,'9556107305100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:45:42','2019-05-10 23:45:42',NULL),(1232,'Sunquick Oren Orange Juice 840 ml',9,'single',19,202,24,NULL,NULL,'exclusive',470,550,1,1,'9556107301102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:48:02','2019-07-20 16:20:28',NULL),(1233,'Stute Raspberry Extra Jam 340 gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,350,1,1,'4006424270223','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:49:30','2019-05-10 23:49:30',NULL),(1235,'Stute Fine Cut Orange Marmalade Jam 340 gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,350,1,1,'4006424270667','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:51:25','2019-05-10 23:51:25',NULL),(1236,'Stute Strawberry Consewe Jam 340 gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,350,1,1,'4006424270117','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:52:27','2019-05-10 23:52:27',NULL),(1237,'Stute No Sugar Added Fine Cut Orange Jam 430 gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,375,1,1,'4006424022686','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:54:02','2019-05-10 23:54:02',NULL),(1238,'Sture No Sugar Added Strawberry Extra Jam 430 gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,375,1,1,'4006424022365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-10 23:55:17','2019-05-10 23:55:17',NULL),(1239,'Molfix Pants XXL 15-22 kg (42 p)',9,'single',19,203,68,NULL,NULL,'exclusive',1450,1850,1,1,'8690536842735 3','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 17:56:07','2019-05-16 01:50:03',NULL),(1240,'Molifix Pants XL 12-17 kg (48 p)',9,'single',19,203,68,NULL,NULL,'exclusive',1290,1620,1,1,'8690536842728','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 17:59:34','2020-02-22 14:41:49',NULL),(1241,'Molifix Pants L 9-14kg (52p)',9,'single',19,203,68,NULL,NULL,'exclusive',1190,1525,1,1,'8690536842711','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 18:02:54','2020-02-22 14:51:39',NULL),(1242,'Molifix Pants M 6-11kg (60p)',9,'single',19,203,68,NULL,NULL,'exclusive',1170,1500,1,1,'8690536842704','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 18:05:06','2020-02-22 15:05:26',NULL),(1243,'Molifix Maxi L 7-14kg (60p)',9,'single',19,203,68,NULL,NULL,'exclusive',1280,1650,1,1,'8690536813285','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 18:51:39','2019-05-11 18:51:39',NULL),(1244,'Molifix Junior XL 11-18kg (44p)',9,'single',19,203,68,NULL,NULL,'exclusive',1280,1650,1,1,'8690536813322','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 18:55:05','2019-05-11 18:55:05',NULL),(1245,'Molifix Extra Large XXL 15+kg (36p)',9,'single',19,203,68,NULL,NULL,'exclusive',1280,1650,1,1,'8690536815197','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 18:57:17','2019-05-11 18:57:17',NULL),(1246,'Molfix  Baby Wet Wipes  60 ps',9,'single',19,203,69,NULL,NULL,'exclusive',180,220,1,1,'8690536855100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 19:05:04','2019-05-11 19:05:04',NULL),(1247,'New Molfix Mini 3-6 kg (40 pcs)',9,'single',19,203,68,NULL,NULL,'exclusive',695,900,1,1,'6224007557174','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 19:15:53','2019-05-11 19:15:53',NULL),(1248,'New Molfix New Born 2-5 kg (44 pcs )',9,'single',19,203,68,NULL,NULL,'exclusive',695,900,1,1,'8690536814527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 19:20:39','2019-05-11 19:20:39',NULL),(1249,'New Molfix New Born 2-5 kg (62 pcs)',9,'single',19,203,68,NULL,NULL,'exclusive',1070,1420,1,1,'8690536804788','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 19:22:41','2019-05-11 19:22:41',NULL),(1250,'Molfix Diapers 4-9 kg(68 pcs)',9,'single',19,203,68,NULL,NULL,'exclusive',1280,1650,1,1,'8690536813407','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-11 19:36:11','2019-05-11 19:36:11',NULL),(1251,'Virginia Green Asparagus 425 gm',9,'single',19,204,11,NULL,NULL,'exclusive',250,335,1,1,'6905008704254','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:29:11','2019-05-12 00:29:11',NULL),(1252,'Virginia Tropical Fruit Cocktail 840 gm',9,'single',19,204,43,NULL,NULL,'exclusive',225,300,1,1,'8805001108258','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:34:25','2019-05-12 00:34:25',NULL),(1253,'Virginia BBQ Sauce 510 ml',9,'single',19,204,32,NULL,NULL,'exclusive',250,335,1,1,'6291050085107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:35:24','2019-05-12 00:35:24',NULL),(1254,'Virginia Slice Jalapeno Pepper-G/Jar 680gm',9,'single',19,204,11,NULL,NULL,'exclusive',250,335,1,1,'8901050036808','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:36:55','2019-05-12 00:36:55',NULL),(1255,'Virginia Whole Jalapeno Pepper-G/Jar 680gm',9,'single',19,204,11,NULL,NULL,'exclusive',250,335,1,1,'8901050056806','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:38:01','2019-05-12 00:38:01',NULL),(1256,'Virginia Yellow Peaches Halves 820 gm',9,'single',19,204,43,NULL,NULL,'exclusive',250,320,1,1,'6905001028203','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:40:11','2019-05-12 00:40:11',NULL),(1257,'Virginia Yellow Peach Halves 425 gm',9,'single',19,204,43,NULL,NULL,'exclusive',125,170,1,1,'6905003204254','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:41:47','2019-05-12 00:41:47',NULL),(1258,'Virginia  Peanut Butter Creamy 510 gm',9,'single',19,204,6,NULL,NULL,'exclusive',240,320,1,1,'8901050095102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:43:20','2019-05-12 00:43:20',NULL),(1259,'Virginia Peanut Butter Honey 340 gm',9,'single',19,204,6,NULL,NULL,'exclusive',250,335,1,1,'8901050053409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:44:14','2019-05-12 00:44:14',NULL),(1260,'Virginia Baked Beans 400gm',9,'single',19,204,11,NULL,NULL,'exclusive',80,100,1,1,'6291080014009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:45:51','2019-07-15 16:37:48',NULL),(1261,'Virginia  Australian Pure Honey 400 gm',9,'single',19,139,56,NULL,NULL,'exclusive',235,315,1,1,'8901062675408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:46:52','2019-05-12 00:46:52',NULL),(1262,'Virginia Australian Black Forest Honey - Glass Jar 500 gm',9,'single',19,204,56,NULL,NULL,'exclusive',850,1135,1,1,'9300675935005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:47:57','2019-05-12 16:10:29',NULL),(1263,'Virginia Australian Honey Ginger - Glass Jar 500 gm',9,'single',19,204,56,NULL,NULL,'exclusive',800,1070,1,1,'9300675915007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:49:25','2019-05-12 00:49:25',NULL),(1264,'Virginia  Green Peas 400 gm',9,'single',19,139,11,NULL,NULL,'exclusive',60,80,1,1,'6291080064004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:51:52','2019-05-12 00:51:52',NULL),(1265,'Virginia Mixed Vegetable 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',70,95,1,1,'8005500184009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:52:44','2019-05-12 00:52:44',NULL),(1266,'Virginia Pinto Beans 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',145,195,1,1,'8005500244000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:53:37','2019-05-12 00:53:37',NULL),(1267,'Virginia Chick Peas 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',100,135,1,11,'8005500164001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:54:52','2019-05-12 00:54:52',NULL),(1268,'Virginia White Beans 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',145,195,1,1,'8005500204004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:55:58','2019-05-12 00:55:58',NULL),(1269,'Virginia Evaported Milk 410 gm',9,'single',19,204,26,NULL,NULL,'exclusive',90,120,1,1,'6291050094109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:56:53','2019-05-12 00:56:53',NULL),(1270,'Virginia  Mayonnaise Jar 8 Oz',9,'single',19,204,25,NULL,NULL,'exclusive',80,110,1,1,'6291105008082','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:58:18','2019-05-12 00:58:18',NULL),(1271,'Virginia Dates Juice 280 ml',9,'single',19,204,24,NULL,NULL,'exclusive',150,200,1,1,'8806001042801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 00:59:21','2019-05-12 00:59:21',NULL),(1272,'Virginia Black Olive Whole - Jar 200 gm',9,'single',19,204,49,NULL,NULL,'exclusive',150,200,1,1,'8450063702007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:00:27','2019-05-12 01:00:27',NULL),(1273,'Virginia Peanut Butter Chocolate 340 gm',9,'single',19,204,6,NULL,NULL,'exclusive',250,335,1,1,'8901050073407','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:01:42','2019-05-12 01:01:42',NULL),(1274,'Virginia  Pomace Olive Oil - G/ Bottle 250 ml',9,'single',19,204,29,NULL,NULL,'exclusive',255,335,1,1,'8450098342506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:05:32','2019-05-12 01:05:32',NULL),(1275,'Virginia Extra Virgin Olive Oil 250 ml',9,'single',19,204,29,NULL,NULL,'exclusive',335,430,1,1,'8450098359252','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:07:35','2019-05-12 01:07:35',NULL),(1276,'Virginia Australian Honey Lemon - Glass Jar 500 gm',9,'single',19,204,56,NULL,NULL,'exclusive',800,1070,1,1,'9300675925006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:08:51','2019-05-12 01:08:51',NULL),(1277,'AMERICAN CHOICE MUSHROOM WHOLE 2840 Gm',9,'single',19,205,11,NULL,NULL,'exclusive',575,1035,1,1,'6922338976793','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:12:27','2019-07-16 14:25:34',NULL),(1278,'Virginia Strawberry Syrup 624 gm',9,'single',19,204,36,NULL,NULL,'exclusive',230,310,1,1,'6291080026248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:16:18','2019-05-12 01:16:18',NULL),(1279,'Virginia Australian Honey - Glass Jar 500 gm',9,'single',19,204,56,NULL,NULL,'exclusive',580,775,1,1,'9300675955003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:20:05','2019-05-12 01:20:05',NULL),(1280,'Riona Mushroom Peas & Stems 400 gm',9,'single',19,206,11,NULL,NULL,'exclusive',70,95,1,1,'6906001494005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:22:16','2019-05-12 01:22:16',NULL),(1281,'Virginia Mushroom Whole 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',65,90,1,1,'6905001004009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:25:15','2019-05-12 01:25:15',NULL),(1282,'Virginia Pineapple Slice 565 gm',9,'single',19,204,43,NULL,NULL,'exclusive',120,160,1,1,'8805001056511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:27:39','2019-05-12 01:27:39',NULL),(1283,'Virginia Green Olive Whole - Jar 200 gm',9,'single',19,204,49,NULL,NULL,'exclusive',160,215,1,1,'8450083702001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:30:01','2019-05-12 01:30:01',NULL),(1284,'Virginia Red Kidney Beans 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',100,135,1,1,'6291080024008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:31:06','2019-05-12 01:31:06',NULL),(1285,'Virginia Pear Halves 425 gm',9,'single',19,204,43,NULL,NULL,'exclusive',125,170,1,1,'6905004304250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:32:21','2019-05-12 01:32:21',NULL),(1286,'Virginia Whole kernel (Sweet ) Corn 425 gm',9,'single',19,204,11,NULL,NULL,'exclusive',75,100,1,1,'8805001042514','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:34:57','2019-05-12 01:34:57',NULL),(1287,'Virginia  Peanut Butter Crunchy 510 gm',9,'single',19,204,6,NULL,NULL,'exclusive',240,320,1,1,'8901050085103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:36:25','2019-05-12 01:36:25',NULL),(1288,'Virginia  Peanut Butter Crunchy 340 gm',9,'single',19,204,6,NULL,NULL,'exclusive',175,235,1,1,'8901050083406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:37:51','2019-05-12 01:37:51',NULL),(1289,'Virginia Cream Style Corn 425 gm',9,'single',19,204,11,NULL,NULL,'exclusive',115,155,1,1,'8805001042521','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:39:15','2019-05-12 01:39:15',NULL),(1290,'Virginia Young  Baby Corn Whole 400 gm',9,'single',19,204,11,NULL,NULL,'exclusive',100,135,1,1,'6905002104005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:41:12','2019-05-12 01:41:12',NULL),(1291,'Virginia Golden Cream 170 ml',9,'single',19,204,41,NULL,NULL,'exclusive',75,100,1,1,'6291050081703','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:43:03','2019-05-12 01:43:03',NULL),(1292,'Virginia Extra Virgin Olive Oil 500 ml',9,'single',19,204,29,NULL,NULL,'exclusive',640,820,1,1,'8450098359504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:44:40','2019-05-12 01:44:40',NULL),(1293,'Virginia  Mayonnaise Jar  32 oz',9,'single',19,204,25,NULL,NULL,'exclusive',230,310,1,1,'6291105508322','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:45:36','2019-05-12 01:45:36',NULL),(1294,'Virginia  Mayonnaise Jar 16 oz',9,'single',19,204,25,NULL,NULL,'exclusive',130,175,1,1,'6291105008167','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:46:32','2019-05-12 01:46:32',NULL),(1296,'Virginia Chocolate Syrup 624 gm',9,'single',19,204,36,NULL,NULL,'exclusive',250,335,1,1,'6291080016249','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:49:06','2019-05-12 01:49:06',NULL),(1297,'Virginia Lychee in Syrup 565 gm',9,'single',19,204,43,NULL,NULL,'exclusive',200,270,1,1,'6905002015653','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:51:11','2019-05-12 01:51:11',NULL),(1298,'Virginia AUSTRALIAN Honey Acacia - Glass Jar 500 gm',9,'single',19,204,56,NULL,NULL,'exclusive',850,1135,1,1,'9300675945004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:52:25','2019-05-12 01:52:25',NULL),(1299,'Virginia Pomace Olive Oil - G/ Bottle 500 ml',9,'single',19,204,29,NULL,NULL,'exclusive',410,535,1,1,'8450098345002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:54:22','2019-05-12 01:54:22',NULL),(1300,'Virginia Oyster Sauce 710 gm',9,'single',19,204,32,NULL,NULL,'exclusive',180,240,1,1,'6290500347109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:56:30','2019-05-12 01:56:30',NULL),(1301,'Virginia Fish Sauce 625 ml',9,'single',19,204,32,NULL,NULL,'exclusive',180,240,1,1,'6290500346256','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:58:04','2019-05-12 01:58:04',NULL),(1302,'Virginia Chick Peas Glass Bottle 370 gm',9,'single',19,204,11,NULL,NULL,'exclusive',150,200,1,1,'8450010983701','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 01:59:41','2019-05-12 01:59:41',NULL),(1303,'Virginia German White Oats 400 gm',9,'single',19,204,43,NULL,NULL,'exclusive',230,240,1,1,'4004409754003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 02:05:03','2019-10-20 18:51:51',NULL),(1304,'Virginia Fruit Cocktail 425 gm',9,'single',19,204,43,NULL,NULL,'exclusive',130,175,1,1,'6905005404256','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 02:06:54','2019-05-12 02:06:54',NULL),(1305,'Comfort Softener Touch of love( Lilac-Blue) 2 lt',9,'single',19,195,70,NULL,NULL,'exclusive',475,635,1,1,'9556126604796','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:33:00','2020-09-08 21:41:18',NULL),(1306,'Comfort Softener Pure Natural Gentle (White) 2 lt',9,'single',19,195,70,NULL,NULL,'exclusive',475,635,1,1,'9556126605953','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:34:24','2019-05-12 19:34:24',NULL),(1307,'Comfort Softener Kiss of flower (Rose-Pink)2 lt',9,'single',19,195,70,NULL,NULL,'exclusive',475,635,1,1,'9556126604789','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:36:32','2020-09-08 21:42:56',NULL),(1308,'Comfort Softener Sense of pleasure(Jasmine-Purple)  2 lt',9,'single',19,195,70,NULL,NULL,'exclusive',475,635,1,1,'9556126639330','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:41:50','2019-05-12 19:41:50',NULL),(1309,'Comfort Ultra- Morning Fresh-800 ml',9,'single',19,195,70,NULL,NULL,'exclusive',390,520,1,1,'8934868093121','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:45:06','2019-05-12 19:45:06',NULL),(1310,'Comfort Ultra- Blossom Fresh-800 ml',9,'single',19,195,70,NULL,NULL,'exclusive',390,520,1,1,'8934868093084','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:46:37','2019-05-12 19:46:37',NULL),(1311,'Comfort Ultra- Anti Bac-800 ml',9,'single',19,195,70,NULL,NULL,'exclusive',390,520,1,1,'8934868093053','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:48:19','2019-05-12 19:48:19',NULL),(1312,'Softland Fabric Softener 2 lt- FLORAL FANTASY',9,'single',19,207,70,NULL,NULL,'exclusive',410,545,1,1,'9556031065309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:52:26','2019-05-12 19:52:26',NULL),(1313,'Softland Fabric Softener 2 lt -Lavender Fresh',9,'single',19,207,70,NULL,NULL,'exclusive',410,545,1,1,'9556031065323','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:54:24','2019-05-12 19:54:24',NULL),(1314,'Fab Color Power Clean Detergent 2.1 kg',9,'single',19,196,70,NULL,NULL,'exclusive',885,1180,1,1,'4902430773331','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 19:58:19','2019-05-12 19:58:19',NULL),(1315,'Fab Anti Bacterial Power Clean  Detergent 2.1 kg',9,'single',19,196,70,NULL,NULL,'exclusive',885,1180,1,1,'4902430773324','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:00:08','2019-05-12 20:00:08',NULL),(1316,'Persil Detergent 3 kg',9,'single',19,208,70,NULL,NULL,'exclusive',1270,1695,1,1,'9556126642651','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:02:30','2020-10-05 15:55:41',NULL),(1317,'Breeze Detergent Power Clean 2.5 kg',9,'single',19,197,70,NULL,NULL,'exclusive',815,1085,1,1,'8851932212786','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:04:27','2020-09-08 21:40:10',NULL),(1318,'Breeze Detergent Color Care 2.3 kg',9,'single',19,197,70,NULL,NULL,'exclusive',815,1085,1,1,'8851932212793','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:06:32','2020-02-05 14:50:37',NULL),(1319,'Breeze Detergent Goodbye Musty 2.3 kg',9,'single',19,197,NULL,NULL,NULL,'exclusive',815,1085,1,1,'8851932213301','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:08:35','2019-05-12 20:08:35',NULL),(1320,'Breeze Liquid Detergent 1.8 lt Power Clean',9,'single',19,197,70,NULL,NULL,'exclusive',670,895,1,1,'9556126648851','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:10:15','2019-05-12 20:10:15',NULL),(1321,'Breeze Liquid Detergent 1.8 lt Color Care',9,'single',19,197,70,NULL,NULL,'exclusive',670,895,1,1,'9556126648868','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 20:12:08','2019-05-12 20:12:08',NULL),(1323,'Breeze Liquid Detergent 2.6 lt Color Care',9,'single',19,197,70,NULL,NULL,'exclusive',1030,1375,1,1,'9556126648806','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:23:58','2019-05-12 21:23:58',NULL),(1324,'Persil Liquid Detergent 3ltr',9,'single',19,208,70,NULL,NULL,'exclusive',1200,1850,1,1,'9556126642552','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:25:53','2020-09-08 21:38:27',NULL),(1325,'Clorox Bleach(Original) 1 lt',9,'single',19,34,70,NULL,NULL,'exclusive',310,410,1,1,'9556823122265','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:27:36','2019-05-12 21:27:36',NULL),(1326,'Clorox Bleach(Original) 2 lt',9,'single',19,34,70,NULL,NULL,'exclusive',400,520,1,1,'9556823122272','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:29:29','2019-05-25 21:25:36',NULL),(1327,'Clorox Bleach(Original) 4 lt',9,'single',19,34,70,NULL,NULL,'exclusive',690,910,1,1,'9556823135784','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:31:02','2019-05-12 21:31:02',NULL),(1328,'Lotte Color Chewing Gum 12.6 gm',9,'single',19,20,22,NULL,NULL,'exclusive',10,15,1,1,'8801062118557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:50:18','2019-05-12 21:50:18',NULL),(1329,'Lotte Xylitol BT Original 86 gm',9,'single',19,20,22,NULL,NULL,'exclusive',315,315,1,1,'845502021012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:54:12','2019-05-12 21:54:12',NULL),(1330,'Lotte Xylitol BT Power Mint 86 gm',9,'single',19,20,NULL,NULL,NULL,'exclusive',310,310,1,1,'845502021029','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 21:57:26','2019-05-12 21:57:26',NULL),(1331,'Olitalia Extra Virgin Olive Oil 5 li Tin',9,'single',19,176,29,NULL,NULL,'exclusive',3850,4000,1,1,'8007150902811','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 22:05:47','2020-09-08 21:32:27',NULL),(1332,'Olitalia Pomace Olive Oil 250 ml',9,'single',19,176,29,NULL,NULL,'exclusive',300,340,1,1,'8007150905317','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 22:13:03','2019-05-12 22:13:56',NULL),(1333,'Olitalia Pomace Olive Oil Tin 5 lt',9,'single',19,176,29,NULL,NULL,'exclusive',2650,2800,1,1,'8007150902835','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 22:19:47','2019-12-14 21:06:21',NULL),(1334,'Calypso Mayonnaise 500 ml',9,'single',19,73,25,NULL,NULL,'exclusive',350,375,1,1,'5352101880643','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-12 23:53:36','2019-05-12 23:53:36',NULL),(1335,'Nestle Lactogen 1 (1.8 kg)',9,'single',19,63,59,NULL,NULL,'exclusive',2200,2300,1,1,'4800361406215','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:07:57','2019-10-11 20:08:40',NULL),(1336,'Nestle Lactogen 2 (1.8 kg)',9,'single',19,63,59,NULL,NULL,'exclusive',2400,2030,1,1,'4800361406277','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:09:43','2019-10-29 15:17:30',NULL),(1337,'Nestle Lactogen 3 (1.8 kg)',9,'single',19,63,59,NULL,NULL,'exclusive',2320,1950,1,1,'4800361406338','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:11:45','2019-11-16 22:32:06',NULL),(1338,'Nestle Nido One Plus 400 gm (1-3 years)',9,'single',19,63,59,NULL,NULL,'exclusive',630,630,1,1,'7616100377145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:14:52','2019-05-13 01:14:52',NULL),(1339,'Nestle Nido One Plus 900 gm (1-3 years)',9,'single',19,63,59,NULL,NULL,'exclusive',1250,1250,1,1,'7616100593255','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:17:31','2019-05-13 01:17:31',NULL),(1340,'Nestle Nido Three Plus 1800 gm (3-5 years)',9,'single',19,63,59,NULL,NULL,'exclusive',2750,2750,1,1,'9556001013835','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:19:36','2019-05-13 16:04:06',NULL),(1341,'Nestle Nido Fortified 900 gm',9,'single',19,63,59,NULL,NULL,'exclusive',1200,1200,1,1,'7616100388318','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:22:08','2019-05-13 01:22:08',NULL),(1342,'Nestle Nan 1 800 gm',9,'single',19,63,59,NULL,NULL,'exclusive',2280,2050,1,1,'7613036141949','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:25:59','2019-10-12 20:15:50',NULL),(1343,'Nestle Nan 2 (800 gm)',9,'single',19,63,59,NULL,NULL,'exclusive',2050,2050,1,1,'7613035507272','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:27:18','2019-05-25 02:52:47',NULL),(1344,'Nestle Nan 3 (800 gm)',9,'single',19,63,59,NULL,NULL,'exclusive',1950,1950,1,1,'7613035502147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:28:45','2019-05-13 01:28:45',NULL),(1345,'Similac 1 (900 gm)',9,'single',19,209,59,NULL,NULL,'exclusive',0,0,1,1,'5391523051965','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:32:11','2019-06-02 21:16:32',NULL),(1346,'Similac 2 (900 gm)',9,'single',19,209,59,NULL,NULL,'exclusive',2300,2300,1,1,'5391523051989','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:33:32','2019-05-13 01:33:32',NULL),(1347,'Similac 3 (900 gm)',9,'single',19,209,59,NULL,NULL,'exclusive',0,0,1,1,'5391523052047','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:34:59','2019-06-02 21:18:11',NULL),(1348,'Nestle Nido Fortified Full Cream Pack (2250 gm)',9,'single',19,63,59,NULL,NULL,'exclusive',1750,1790,1,1,'6211002513403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:37:54','2019-05-20 00:51:39',NULL),(1349,'Huggies Dry Diapers XL 11-16 kg (48 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1350,1200,1,1,'8888336023328','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:41:53','2019-10-06 15:05:40',NULL),(1350,'Huggies Dry Diapers L 9-14 kg (60 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1350,1200,1,1,'8888336023311','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:44:08','2019-10-06 15:04:19',NULL),(1351,'Huggies Dry Diapers S  4-8 kg (60 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1200,1200,1,1,'8888336015002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:45:53','2019-05-13 01:45:53',NULL),(1352,'Huggies Dry Diapers XXL 14 kg (40 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1350,1200,1,1,'8888336019147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:48:06','2019-10-06 15:16:21',NULL),(1353,'Huggies Dry Diapers  NB 5 kg (64 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1200,1200,1,1,'8888336014999','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:49:42','2019-05-13 01:49:42',NULL),(1354,'Huggies Dry Diapers M 6-11 kg (72 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1350,1200,1,1,'8888336023304','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 01:51:42','2019-10-06 15:03:03',NULL),(1355,'Arla Sandwich Slices 200 gm',9,'single',19,211,13,NULL,NULL,'exclusive',180,180,1,1,'5711953023262','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:13:56','2019-05-13 19:13:56',NULL),(1356,'Arla Burger Slice 200 gm',9,'single',19,211,13,NULL,NULL,'exclusive',180,180,1,1,'5711953023408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:15:09','2019-05-13 19:15:09',NULL),(1357,'Arla Castello Blue Cheese 100 gm',9,'single',19,211,13,NULL,NULL,'exclusive',225,225,1,1,'5760466736152','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:16:34','2019-05-13 19:16:34',NULL),(1358,'Cowhead Slice Cheese White 1 kg (84 Slices)',9,'single',19,84,13,NULL,NULL,'exclusive',860,860,1,1,'8888440010511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:28:39','2019-05-13 19:28:39',NULL),(1359,'Cowhead Slice Cheese Yellow 1 kg',9,'single',19,84,13,NULL,NULL,'exclusive',860,860,1,1,'100021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:29:36','2019-05-13 19:29:36',NULL),(1360,'Lurpak Salted Butter 200 gm',9,'single',19,212,6,NULL,NULL,'exclusive',280,280,1,1,'5740900832305','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:31:26','2019-05-13 19:31:26',NULL),(1361,'Lurpak Unsalted Butter 200 gm',9,'single',19,212,6,NULL,NULL,'exclusive',280,280,1,1,'5740900835306','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:32:45','2019-05-13 19:32:45',NULL),(1362,'Milac Gold Whipping Cream 1 Lt',9,'single',19,213,41,NULL,NULL,'exclusive',560,560,1,1,'5010652998476','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:34:04','2019-05-13 19:34:04',NULL),(1363,'Kinder Country Mini 79 Pcs',9,'single',19,69,15,NULL,NULL,'exclusive',1220,1350,1,1,'8000500229620','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:41:51','2019-05-13 19:41:51',NULL),(1364,'Nestle Kitkat Wellness Breaker 517 gm',9,'single',19,63,15,NULL,NULL,'exclusive',1220,1350,1,1,'7613035028760','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:44:52','2019-05-13 19:44:52',NULL),(1365,'Nestle Kitkat Adventure Mix 473 gm',9,'single',19,63,15,NULL,NULL,'exclusive',1220,1350,1,1,'7613036320726','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:47:09','2019-05-13 19:47:09',NULL),(1366,'Ferrero Golden Gallery 206 gm',9,'single',19,115,15,NULL,NULL,'exclusive',1120,1120,1,1,'8000500262429','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:49:22','2019-05-13 19:49:22',NULL),(1367,'Lindt Lindor Box 400 gm',9,'single',19,214,15,NULL,NULL,'exclusive',1760,1920,1,1,'7610400084789','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:52:36','2019-05-13 19:52:36',NULL),(1368,'Nestle Kitkat Orange 9 pack',9,'single',19,63,15,NULL,NULL,'exclusive',360,400,1,1,'7613036099325','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 19:55:32','2019-05-13 19:55:32',NULL),(1369,'Nestle Kitkat All About You 2 finger Bar',9,'single',19,NULL,15,NULL,NULL,'exclusive',135,160,1,1,'6294003571061','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:04:15','2019-07-30 17:25:13',NULL),(1370,'Ferrero Rafaello T23 230 gm',9,'single',19,215,15,NULL,NULL,'exclusive',890,1000,1,1,'4008400183022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:08:14','2019-05-13 21:51:59',NULL),(1371,'Lay\'s Stax Sour Cream & Onion 155.9 gm',9,'single',19,174,14,NULL,NULL,'exclusive',200,240,1,1,'028400055154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:12:49','2019-05-20 20:36:54',NULL),(1372,'Nestle Kitkat Mini Moments 203 gm',9,'single',19,63,15,NULL,NULL,'exclusive',890,1000,1,1,'6294003568665','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:15:27','2019-05-13 20:15:27',NULL),(1373,'Lolly Sweet Candy Big',9,'single',19,216,57,NULL,NULL,'exclusive',160,175,1,1,'8809100560023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:23:56','2019-05-13 20:23:56',NULL),(1374,'Nestle Kitkat Chunky Peanut Butter 42 gm',9,'single',19,63,14,NULL,NULL,'exclusive',85,100,1,1,'3800020415009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:28:37','2019-08-31 15:39:12',NULL),(1375,'Lolly Sweet Candy Small',9,'single',19,NULL,57,NULL,NULL,'exclusive',85,90,1,1,'8809100560016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:31:19','2019-05-13 22:13:27',NULL),(1376,'Lay\'s  Stax Chips Original 163 gm',9,'single',19,174,14,NULL,NULL,'exclusive',200,240,1,1,'028400055093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:37:45','2019-05-20 20:34:23',NULL),(1377,'Tropicana Twister Orange Fruit Drink 500 ml',9,'single',19,217,24,NULL,NULL,'exclusive',110,120,1,1,'9556404115075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:40:21','2020-11-20 19:23:24',NULL),(1378,'Tropicana Twister Apple Fruit Drink 500 ml',9,'single',19,217,24,NULL,NULL,'exclusive',110,120,1,1,'9556404115143','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:41:55','2020-11-20 19:22:47',NULL),(1379,'Tropicana Twister Orange Fruit Drink 1.5 Lt',9,'single',19,217,24,NULL,NULL,'exclusive',350,350,1,1,'9556404115044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:43:40','2019-05-13 20:57:43',NULL),(1380,'Nestle Kitkat Singles 182 gm',9,'single',19,63,15,NULL,NULL,'exclusive',470,500,1,1,'3800020422588','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:46:25','2019-05-13 20:46:25',NULL),(1381,'Toblerone Mini Mix  744 gm',9,'single',19,116,15,NULL,NULL,'exclusive',1650,1850,1,1,'7622210392480','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:49:54','2019-05-13 20:49:54',NULL),(1382,'Nestle All About You  Coconut',9,'single',19,63,15,NULL,NULL,'exclusive',135,160,1,1,'6294003571009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 20:54:30','2019-07-30 17:20:32',NULL),(1383,'Snickers Crisper 40 gm',9,'single',19,120,15,NULL,NULL,'exclusive',115,125,1,1,'040000530824','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 21:00:53','2019-05-13 21:00:53',NULL),(1384,'Morde Priya Choco Strand 200 gm',9,'single',19,190,15,NULL,NULL,'exclusive',140,155,1,1,'8906051681606','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 21:10:26','2019-05-13 21:10:26',NULL),(1385,'Kinder Chocolate Mini 460 gm',9,'single',19,NULL,15,NULL,NULL,'exclusive',1220,1350,1,1,'8000500229583','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 21:34:38','2019-05-13 21:34:38',NULL),(1386,'Ferrero Rocher T 48  600 gm',9,'single',19,115,15,NULL,NULL,'exclusive',2300,2520,1,1,'8000500231364','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 21:37:32','2019-05-13 21:37:32',NULL),(1387,'Flora Margarine 250 gm  Tub',9,'single',19,218,NULL,NULL,NULL,'exclusive',225,225,1,1,'4892218000295','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:25:40','2019-05-13 23:25:40',NULL),(1388,'Flora Margarine 500 gm Tub',9,'single',19,218,6,NULL,NULL,'exclusive',370,370,1,1,'4892218000486','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:27:15','2019-05-13 23:27:15',NULL),(1389,'Bon Appetite Slice Cheese 170 gm',9,'single',19,326,13,NULL,NULL,'exclusive',195,195,1,1,'9310264911839','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:36:22','2020-08-13 00:28:48',NULL),(1390,'Melbourne Sandwich Slice Cheese  200 gm',9,'single',19,220,13,NULL,NULL,'exclusive',220,220,1,1,'9310264910849','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:38:42','2020-08-13 00:30:22',NULL),(1391,'Melbourne Slice Cheese 250 gm',9,'single',19,220,13,NULL,NULL,'exclusive',255,255,1,1,'9310264910825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:40:41','2019-05-13 23:43:19',NULL),(1392,'Florida Mozzarella Cheese 250 gm',9,'single',19,221,13,NULL,NULL,'exclusive',515,515,1,1,'9312056000035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:42:36','2019-05-13 23:42:36',NULL),(1393,'Florida Parmesan Cheese 100 gm',9,'single',19,221,13,NULL,NULL,'exclusive',285,285,1,1,'9312056100025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:45:34','2019-05-13 23:45:34',NULL),(1394,'Heinz Garden Green Peas Frozen 500 gm',9,'single',19,13,71,NULL,NULL,'exclusive',240,240,1,1,'9300657793029','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-13 23:48:58','2019-05-13 23:48:58',NULL),(1395,'Huggies Dry Pants M 6-12 kg (64 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1120,1400,1,1,'8888336014203','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:06:40','2020-09-08 20:11:38',NULL),(1396,'Huggies  Dry Pants S 4-8 kg (68 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1120,1400,1,1,'8888336021133','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:16:13','2019-07-23 18:42:51',NULL),(1397,'Huggies Dry Pants L 9-14 kg (52 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1120,1400,1,1,'8888336014197','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:19:16','2020-09-08 16:31:09',NULL),(1398,'Huggies Dry Pants XL  12-17 kg (42 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1120,1400,1,1,'8888336014210','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:20:52','2020-09-08 20:11:20',NULL),(1399,'Huggies Dry Pants XXL 15-25 kg (32 pcs)',9,'single',19,210,68,NULL,NULL,'exclusive',1120,1400,1,1,'8888336014227','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:22:34','2019-07-22 15:03:36',NULL),(1400,'Orkide Sunflower Oil 1 Lt',9,'single',19,222,29,NULL,NULL,'exclusive',230,260,1,1,'8691313010248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:44:02','2019-05-14 00:44:02',NULL),(1401,'Orkide Sunflower Oil 5 Lt',9,'single',19,222,29,NULL,NULL,'exclusive',1050,1050,1,1,'8691313987649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 00:46:08','2019-05-14 00:46:08',NULL),(1402,'Orkide Pure Olive Oil 250 ml glass',9,'single',19,222,29,NULL,NULL,'exclusive',230,280,1,1,'8691313020506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:40:21','2019-05-14 01:40:21',NULL),(1403,'Orkide Olive Oil 250 ml Pet',9,'single',19,222,29,NULL,NULL,'exclusive',210,245,1,1,'8691313020124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:42:02','2019-05-14 01:42:02',NULL),(1404,'Safe Adult Pants M (10 pcs)',9,'single',19,223,68,NULL,NULL,'exclusive',850,1025,1,1,'8941133200351','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:47:06','2019-05-14 01:47:06',NULL),(1405,'Safe Adult Pants L (10 pcs)',9,'single',19,223,68,NULL,NULL,'exclusive',900,1085,1,1,'8941133200368','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:48:44','2019-05-14 01:48:44',NULL),(1406,'Glory Adult Diaper M (10 pcs)',9,'single',19,224,68,NULL,NULL,'exclusive',750,860,1,1,'8941133200474','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:52:57','2019-05-14 01:52:57',NULL),(1407,'Glory Adult Diaper L (8 pcs)',9,'single',19,224,68,NULL,NULL,'exclusive',750,860,1,1,'6941326208951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:55:05','2019-05-14 01:55:05',NULL),(1408,'Glory Adult Diaper M (20 pcs)',9,'single',19,224,68,NULL,NULL,'exclusive',1400,1690,1,1,'8941133200504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 01:56:40','2019-05-14 01:56:40',NULL),(1409,'Avonee Diaper Maxi L 7-18 kg (50 pcs)',9,'single',19,225,68,NULL,NULL,'exclusive',1000,1360,1,1,'8941133200320','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 02:02:08','2019-05-14 02:02:08',NULL),(1410,'Avonee Diaper Junior XL 11-25 kg (48 pcs)',9,'single',19,225,68,NULL,NULL,'exclusive',1000,1360,1,1,'8941133200337','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 02:05:24','2019-05-14 02:05:24',NULL),(1411,'Avonee Diaper XXL 16+kg (44 pcs)',9,'single',19,225,68,NULL,NULL,'exclusive',1000,1360,1,1,'8941133200344','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 02:07:56','2019-05-14 02:07:56',NULL),(1412,'Love Baby  Diaper Maxi 7-18 kg (50 pcs)',9,'single',19,226,68,NULL,NULL,'exclusive',950,1260,1,1,'8941133200085','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 15:55:48','2019-05-14 15:55:48',NULL),(1413,'Love Baby Diaper Junior XL 11-25 kg (48 pcs)',9,'single',19,226,68,NULL,NULL,'exclusive',950,1260,1,1,'8941133200801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:01:32','2020-07-21 17:59:20',NULL),(1414,'Love Baby Diaper  XXL 16+ kg (48 pcs)',9,'single',19,226,68,NULL,NULL,'exclusive',950,1260,1,1,'8941133200108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:19:24','2019-05-14 16:19:24',NULL),(1415,'Safe Baby Wet Wipes 80 pcs',9,'single',19,223,69,NULL,NULL,'exclusive',125,150,1,1,'6954902700077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:21:18','2019-05-14 16:21:18',NULL),(1416,'Safe Baby Wet Wipes 120 pcs',9,'single',19,223,69,NULL,NULL,'exclusive',180,220,1,1,'6954902700084','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:33:42','2019-05-14 16:33:42',NULL),(1417,'Sweety Fit Pantz  M 6-11 kg (64 pcs)',9,'single',19,227,68,NULL,NULL,'exclusive',1050,1565,1,1,'8941133200887','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:37:16','2019-05-14 16:37:16',NULL),(1418,'Sweety Fit Pantz  L 9-14 kg (60 pcs)',9,'single',19,227,68,NULL,NULL,'exclusive',1200,1725,1,1,'8941133200894','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:39:24','2019-05-14 16:39:24',NULL),(1419,'Sweety Fit Pantz  XXL 15-25 kg (52 pcs)',9,'single',19,227,68,NULL,NULL,'exclusive',1610,2480,1,1,'8941133200917','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:41:10','2019-05-14 16:46:37',NULL),(1420,'Sweety Fit Pantz  XL 12-17 kg (56 pcs)',9,'single',19,227,68,NULL,NULL,'exclusive',1380,1925,1,1,'8941133200900','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:49:15','2019-05-14 16:49:15',NULL),(1421,'Relax Adult Diaper M (10 pcs )',9,'single',19,228,68,NULL,NULL,'exclusive',650,800,1,1,'6933192275212','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 16:57:29','2019-05-14 16:57:29',NULL),(1422,'Relax Adult Diaper Large (8 pcs)',9,'single',19,228,68,NULL,NULL,'exclusive',650,800,1,1,'6933192275229','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 17:00:30','2019-05-14 17:00:30',NULL),(1423,'Pozzy Wet Wipes',9,'single',19,229,69,NULL,NULL,'exclusive',160,210,1,1,'8690239033638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 17:08:28','2019-05-14 17:08:28',NULL),(1424,'Prabhuji Lachha Semai 500 gm',9,'single',19,119,72,NULL,NULL,'exclusive',250,350,1,1,'8901721004617','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 18:05:55','2019-06-16 19:56:32',NULL),(1425,'Oreo Mini Biscuits Strawberry 65 gm',9,'single',19,87,5,NULL,NULL,'exclusive',90,105,1,1,'7622210462534','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 20:02:39','2020-09-18 01:24:27',NULL),(1426,'Oreo Mini Biscuit 65gm Vanilla',9,'single',19,87,5,NULL,NULL,'exclusive',90,105,1,1,'7622300761349','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 20:04:55','2020-09-18 01:23:38',NULL),(1427,'Meadow Fresh Full Cream Milk 1 Lt',9,'single',19,230,26,NULL,NULL,'exclusive',170,200,1,1,'9415522285001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 20:41:38','2019-07-22 17:57:31',NULL),(1428,'Meadow Fresh Low Fat Milk 1 Lt',9,'single',19,230,26,NULL,NULL,'exclusive',190,190,1,1,'9415522001274','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 20:43:33','2019-05-14 20:43:33',NULL),(1429,'Meadow Fresh Choco Choc  250 ml',9,'single',19,230,26,NULL,NULL,'exclusive',80,80,1,1,'9415522001533','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 20:47:20','2019-05-14 20:47:20',NULL),(1430,'Foster Clarks  Mango 750 gm',9,'single',19,57,52,NULL,NULL,'exclusive',465,530,1,1,'5352101671111','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 21:10:47','2019-05-14 21:10:47',NULL),(1431,'Shan Biryani Masala  50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821122124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:25:46','2019-05-14 23:25:46',NULL),(1432,'Shan Pilau Masala  50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821041142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:27:32','2019-05-14 23:27:32',NULL),(1433,'Shan Special Bombay Biryani 60 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821001146','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:29:40','2019-05-14 23:36:13',NULL),(1434,'Shan Malay Chicken Biryani  60 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821034021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:31:15','2019-05-14 23:37:07',NULL),(1435,'Shan Memoni Mutton Biryani 60 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821042026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:34:03','2019-05-14 23:37:45',NULL),(1436,'Shan Sindhi Biryani 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821019141','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:35:36','2019-05-14 23:38:25',NULL),(1437,'Shan Chicken Tikka 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821013149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:40:12','2019-05-14 23:40:12',NULL),(1438,'Shan Seek Kabab 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821035141','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:42:01','2019-05-14 23:42:01',NULL),(1439,'Shan Tandoori Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821030016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:43:41','2019-05-14 23:43:41',NULL),(1440,'Shan Bihari Kabab Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821044020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:45:14','2019-05-14 23:45:14',NULL),(1441,'Shan Tikka 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821099099','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:47:40','2019-05-14 23:47:40',NULL),(1442,'Shan Tikka Seekh Kabab 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821012029','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-14 23:49:03','2019-05-14 23:49:03',NULL),(1443,'Four Seasons Basmati Rice 1 kg',9,'single',19,231,54,NULL,NULL,'exclusive',210,220,1,1,'100022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:09:32','2019-05-15 00:09:32',NULL),(1444,'Shan Fried Fish Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821009142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:10:56','2019-05-15 00:10:56',NULL),(1445,'Shan Sami Kabab 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821023148','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:12:20','2019-05-15 00:12:20',NULL),(1446,'Shan Nihari Masala 60 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821005144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:13:33','2019-05-15 00:13:33',NULL),(1447,'Shan Paya Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821015143','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:14:36','2019-05-15 00:14:36',NULL),(1448,'Shan Chaat Masala 100 gm',9,'single',19,231,66,NULL,NULL,'exclusive',100,110,1,1,'788821026040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:16:00','2019-05-15 00:41:25',NULL),(1449,'Shan Achar Gost',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821021144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:18:27','2019-05-15 00:18:27',NULL),(1450,'Shan Chicken Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821007148','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:19:48','2019-05-15 00:19:48',NULL),(1451,'Shan Korma Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821003140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:21:11','2019-05-15 00:21:11',NULL),(1452,'Shan Meat Masala 100 gm',9,'single',19,231,66,NULL,NULL,'exclusive',100,110,1,1,'788821102027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:23:50','2019-05-15 00:36:22',NULL),(1453,'Shan Karahi Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821011145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:25:01','2019-05-15 00:25:01',NULL),(1454,'Badshahi  Rice Basmati 1 kg',9,'single',19,231,54,NULL,NULL,'exclusive',220,230,1,1,'100023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:26:50','2019-05-15 00:26:50',NULL),(1455,'Vixol White 450 ml',9,'single',19,232,48,NULL,NULL,'exclusive',120,145,1,1,'8850092010065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 00:57:28','2019-05-15 01:01:03',NULL),(1456,'Vixol Pink 450 ml',9,'single',19,232,48,NULL,NULL,'exclusive',120,145,1,1,'8850092012069','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:00:33','2019-05-15 01:00:33',NULL),(1457,'Vixol Smart 450 ml',9,'single',19,232,48,NULL,NULL,'exclusive',120,145,1,1,'8850092016111','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:02:46','2019-05-15 01:02:46',NULL),(1458,'Vixol White 900 ml',9,'single',19,232,48,NULL,NULL,'exclusive',210,250,1,1,'8850092010201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:04:00','2019-05-15 01:04:00',NULL),(1460,'Vixol Red 900 ml',9,'single',19,232,48,NULL,NULL,'exclusive',210,250,1,1,'8850092011208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:06:43','2019-05-15 01:06:43',NULL),(1461,'Whiz Shield Tech Floor Cleaner 900 ml Blue',9,'single',19,233,48,NULL,NULL,'exclusive',260,300,1,1,'8850092124205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:11:00','2019-05-15 01:11:00',NULL),(1462,'Whiz Shield Tech Floor Cleaner 900 ml Pink',9,'single',19,233,48,NULL,NULL,'exclusive',260,300,1,1,'8850092122201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:12:07','2019-05-15 01:12:07',NULL),(1463,'Whiz Shield Tech Floor Cleaner 900 ml Violet',9,'single',19,233,48,NULL,NULL,'exclusive',260,300,1,1,'8850092126209','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:16:05','2019-05-15 01:16:05',NULL),(1464,'Whiz No Dust Glass Cleaner 360 ml Pink',9,'single',19,233,48,NULL,NULL,'exclusive',140,165,1,1,'8850092092030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:18:28','2019-05-15 01:18:28',NULL),(1465,'Whiz No Dust Glass Cleaner 520 ml Pink',9,'single',19,233,48,NULL,NULL,'exclusive',200,240,1,1,'8850092092115','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:20:49','2019-05-15 01:20:49',NULL),(1466,'Hygiene Fresh Ocean Perfumed Smooth Starch 550 ml',9,'single',19,234,48,NULL,NULL,'exclusive',210,250,1,1,'8850092224103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:23:47','2019-05-15 01:23:47',NULL),(1467,'Hygiene Pink Blossom Perfumed Smooth Starch 550 ml',9,'single',19,234,48,NULL,NULL,'exclusive',210,250,1,1,'8850092222109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:25:15','2019-05-15 01:25:15',NULL),(1468,'Hygiene Fabric Freshener Blue Fresh 8 gm',9,'single',19,234,48,NULL,NULL,'exclusive',110,130,1,1,'8850092303020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:29:28','2019-05-15 01:29:28',NULL),(1469,'Hygiene Fabric Freshener Pink Sweet 8 gm',9,'single',19,234,48,NULL,NULL,'exclusive',110,130,1,1,'8850092302023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:31:32','2019-05-15 01:31:32',NULL),(1470,'Hygiene Fabric Freshener Violet Soft 8 gm',9,'single',19,234,48,NULL,NULL,'exclusive',110,130,1,1,'8850092306021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:33:25','2019-05-15 01:33:25',NULL),(1471,'Kikco Halal Fruit Cordial 1 Lt (Rose )',9,'single',19,235,24,NULL,NULL,'exclusive',275,325,1,1,'9555038404982','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:35:32','2019-05-15 01:43:50',NULL),(1472,'Kikco Halal Fruit Cordial 2 Lt (Mango)',9,'single',19,235,24,NULL,NULL,'exclusive',530,625,1,1,'9555392004118','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:38:05','2019-05-15 01:43:06',NULL),(1473,'Kikco Halal Fruit Cordial 2 Lt (Orange)',9,'single',19,235,24,NULL,NULL,'exclusive',530,625,1,1,'9555392004880','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:42:27','2019-05-15 01:42:27',NULL),(1474,'Kikco Halal Fruit Cordial 2 Lt (Rose)',9,'single',19,235,24,NULL,NULL,'exclusive',530,620,1,1,'9555038404913','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 01:45:11','2019-05-15 01:45:11',NULL),(1475,'SANITARIUM UP&GO CHOCOLATE 250 ml',9,'single',19,143,26,NULL,NULL,'exclusive',170,215,1,1,'9300652002645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 19:19:58','2019-05-15 19:22:45',NULL),(1476,'Devondale Moo Chocolate  Milk 200 ml',9,'single',19,236,26,NULL,NULL,'exclusive',130,150,1,1,'93639064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 19:53:15','2019-05-15 19:53:58',NULL),(1477,'Devondale Moo Strawberry Milk 200 ml',9,'single',19,236,26,NULL,NULL,'exclusive',130,150,1,1,'9300639605333','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 19:55:16','2019-05-15 19:55:16',NULL),(1478,'Umami BBQ Sauce 300 ml',9,'single',19,74,32,NULL,NULL,'exclusive',165,180,1,1,'8850534100309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 21:30:59','2019-05-20 22:28:09',NULL),(1479,'Borges Black Pitted Olives 340 gm',9,'single',19,70,49,NULL,NULL,'exclusive',155,165,1,1,'8410179012025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 21:36:02','2019-05-15 21:36:02',NULL),(1480,'Borges Black Whole Olives 200 gm',9,'single',19,70,49,NULL,NULL,'exclusive',160,170,1,1,'8410179012032','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 21:51:48','2019-05-15 21:51:48',NULL),(1481,'Borges Green Whole Olives 350 gm',9,'single',19,70,49,NULL,NULL,'exclusive',160,170,1,1,'8410179012056','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 21:53:38','2019-05-15 21:53:38',NULL),(1482,'Baby Looney Tunes Marshmallows-200 gm',9,'single',19,237,15,NULL,NULL,'exclusive',200,240,1,1,'8888047737620','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-15 23:49:08','2019-05-15 23:49:08',NULL),(1483,'Vixol Pink 900 ml',9,'single',19,232,48,NULL,NULL,'exclusive',210,250,1,1,'8850092012205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 01:29:03','2019-05-16 01:29:03',NULL),(1485,'Kazi & Kazi Black Tea 80 gm',9,'single',19,238,37,NULL,NULL,'exclusive',125,125,1,1,'8941133000562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:04:25','2019-05-16 20:05:10',NULL),(1486,'Kazi & Kazi Pristine Black Tea 200 gm',9,'single',19,238,37,NULL,NULL,'exclusive',140,140,1,1,'8941133000586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:07:55','2019-05-16 20:07:55',NULL),(1487,'Kazi & Kazi Green Tea 6o gm',9,'single',19,238,37,NULL,NULL,'exclusive',160,160,1,1,'8941133000593','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:09:35','2019-05-16 20:09:35',NULL),(1488,'Kazi & Kazi Tulsi Tea 6o gm',9,'single',19,238,37,NULL,NULL,'exclusive',150,150,1,1,'8941133000609','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:11:24','2019-05-16 20:11:24',NULL),(1489,'Kazi & Kazi Orthodox Black Tea 100 gm',9,'single',19,238,37,NULL,NULL,'exclusive',170,170,1,1,'8941133000630','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:13:12','2019-05-16 20:13:12',NULL),(1490,'Kazi & Kazi Ginger Tea 6o gm',9,'single',19,238,37,NULL,NULL,'exclusive',150,150,1,1,'8941133000647','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:14:44','2019-05-16 20:14:44',NULL),(1491,'Kazi & Kazi Orthodox Green Tea 100 gm',9,'single',19,238,37,NULL,NULL,'exclusive',180,180,1,1,'8941133000654','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:17:07','2019-05-16 20:17:07',NULL),(1492,'Kazi & Kazi Jasmine Green Tea 60 gm',9,'single',19,238,37,NULL,NULL,'exclusive',160,160,1,1,'8941133000661','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:19:00','2019-05-16 20:19:00',NULL),(1493,'Kazi & Kazi First Flush Black Tea 100 gm',9,'single',19,238,37,NULL,NULL,'exclusive',200,200,1,1,'8941133000685','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:22:43','2019-05-16 20:22:43',NULL),(1494,'Kazi & Kazi Medley Tea 6o gm',9,'single',19,238,37,NULL,NULL,'exclusive',150,150,1,1,'8941133000616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:25:12','2019-05-16 20:25:12',NULL),(1495,'Kazi & Kazi Green Lemongrass Tea 60 gm',9,'single',19,238,37,NULL,NULL,'exclusive',160,160,1,1,'8941133000722','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:27:11','2019-05-16 20:27:11',NULL),(1496,'Nestle Nido Fortified Full Cream Milk Tin 2500 gm',9,'single',19,63,26,NULL,NULL,'exclusive',2450,2580,1,1,'7616100011568','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:51:25','2019-06-29 21:58:35',NULL),(1497,'Dano Full Cream Milk Powder Tin 2500 gm',9,'single',19,239,26,NULL,NULL,'exclusive',2300,2400,1,1,'5760466902779','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-16 20:53:47','2020-07-18 16:30:50',NULL),(1498,'Twinings Morning Tea',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177176174','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 14:56:45','2020-09-08 16:39:49',NULL),(1499,'CRUNCHOS Cashew Fried & Salted 200Gm',9,'single',19,240,53,NULL,NULL,'exclusive',515,515,1,1,'5038572600194','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 15:56:59','2019-05-17 15:56:59',NULL),(1500,'TIFFANY Sugar Free Orange Flv Cream Biscuit 162gm',9,'single',19,242,5,NULL,NULL,'exclusive',210,210,1,1,'6291003004742','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:03:47','2019-05-17 16:03:47',NULL),(1501,'RANI Fruit Drink Apple 1.5Ltr',9,'single',19,243,24,NULL,NULL,'exclusive',330,330,1,1,'6281034000127','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:13:39','2019-05-17 16:13:39',NULL),(1502,'RANI Fruit Drink Orange 1.5Ltr',9,'single',19,243,24,NULL,NULL,'exclusive',330,330,1,1,'6281034900090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:14:59','2019-05-17 16:14:59',NULL),(1503,'RANI Fruit Drink Orange 200ml',9,'single',19,243,24,NULL,NULL,'exclusive',85,85,1,1,'6281034900441','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:18:17','2019-05-17 16:18:17',NULL),(1504,'RANI Fruit Drink Apple 200ml',9,'single',19,243,24,NULL,NULL,'exclusive',85,85,1,1,'6281034016272','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:22:46','2019-05-17 16:22:46',NULL),(1505,'RANI Fruit Drink Mango 200ml',9,'single',19,243,24,NULL,NULL,'exclusive',85,85,1,1,'6281034016210','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:25:31','2019-05-17 16:25:31',NULL),(1506,'RANI Fruit Drink cocktail 200ml',9,'single',19,243,24,NULL,NULL,'exclusive',85,85,1,1,'6281034900854','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:26:34','2019-05-17 16:26:34',NULL),(1507,'CRUNCHOS Cashew Fried & Salted 350Gm',9,'single',19,240,53,NULL,NULL,'exclusive',850,850,1,1,'5038572600200','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:32:22','2019-05-17 16:32:22',NULL),(1508,'CRUNCHOS Assorted Mix Nuts Fried & Salted 350Gm',9,'single',19,240,53,NULL,NULL,'exclusive',850,850,1,1,'5038572600033','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:33:46','2019-05-17 16:33:46',NULL),(1509,'CRUNCHOS Pistachio Rosted & Salted 350Gm',9,'single',19,240,53,NULL,NULL,'exclusive',850,850,1,1,'5038572600170','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:35:39','2019-05-17 16:35:39',NULL),(1510,'CRUNCHOS Assorted Mix Nuts Fried & Salted 200ml',9,'single',19,240,9,NULL,NULL,'exclusive',515,515,1,1,'5038572600026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:38:26','2019-05-17 16:38:26',NULL),(1511,'CRUNCHOS Pistachio Rosted & Salted 200Gm',9,'single',19,240,9,NULL,NULL,'exclusive',515,515,1,1,'5038572600163','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:39:50','2019-05-17 16:39:50',NULL),(1512,'LONDON Pie Blackcurrent Flv 360gm (20pcs)',9,'single',19,244,73,NULL,NULL,'exclusive',340,340,1,1,'9556055663338','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:53:10','2019-05-17 16:53:10',NULL),(1513,'LONDON Pie Choco Flv 360gm (20pcs)',9,'single',19,244,73,NULL,NULL,'exclusive',340,340,1,1,'9556055663536','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:54:54','2019-05-17 16:54:54',NULL),(1514,'LONDON Pie Strawberry Flv 360gm (20pcs)',9,'single',19,244,73,NULL,NULL,'exclusive',340,340,1,1,'9556055663239','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:56:09','2019-05-17 16:56:09',NULL),(1515,'LONDON Pie Custard Cake 360gm (20pcs)',9,'single',19,244,73,NULL,NULL,'exclusive',340,340,1,1,'9556055663437','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 16:57:57','2019-05-17 16:57:57',NULL),(1516,'TIFFANY Delights Butter cookies 810gm',9,'single',19,241,18,NULL,NULL,'exclusive',1000,1000,1,1,'6291003006890','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:01:48','2019-05-17 17:01:48',NULL),(1517,'Danisa Traditional Butter cookies 375gm',9,'single',19,245,18,NULL,NULL,'exclusive',560,560,1,1,'8886001012295','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:06:09','2019-05-17 17:06:09',NULL),(1518,'Danisa Traditional Butter cookies 750gm',9,'single',19,245,18,NULL,NULL,'exclusive',980,980,1,1,'8886001012301','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:08:00','2019-05-17 17:08:00',NULL),(1519,'BASSO Pomace Olive Oil 5Ltr Tin',9,'single',19,246,29,NULL,NULL,'exclusive',2600,2780,1,1,'8004123000178','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:15:05','2019-05-17 17:15:05',NULL),(1520,'BASSO Pomace Olive Oil 1Ltr',9,'single',19,246,29,NULL,NULL,'exclusive',580,650,1,1,'049248016558','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:18:41','2019-05-17 17:18:41',NULL),(1521,'BASSO Extra Virgin Olive Oil 1Ltr',9,'single',19,246,29,NULL,NULL,'exclusive',790,875,1,1,'049248015131','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:21:34','2019-05-17 17:21:34',NULL),(1522,'BASSO Fortified Olive Oil 5Ltr',9,'single',19,246,29,NULL,NULL,'exclusive',1200,1350,1,1,'8004123000468','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:43:00','2019-05-25 23:38:04',NULL),(1523,'BASSO Pomace Olive Oil 5Ltr Pet',9,'single',19,246,29,NULL,NULL,'exclusive',2450,2690,1,1,'8004123002769','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 17:47:09','2019-05-17 17:47:09',NULL),(1524,'BASSO Fortified Sunflower Oil 5Ltr  pet',9,'single',19,246,29,NULL,NULL,'exclusive',1050,1200,1,1,'8004123009799','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 18:02:34','2019-09-11 00:38:10',NULL),(1525,'BASSO Extra Virgin Olive Oil 5ltr Pet',9,'single',19,246,29,NULL,NULL,'exclusive',3600,3800,1,1,'8004123002691','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 18:07:01','2019-05-17 18:07:01',NULL),(1526,'Noor Sunflower Oil 1.8ltr',9,'single',19,247,29,NULL,NULL,'exclusive',400,450,1,1,'6291003054624','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 18:10:51','2019-05-17 18:10:51',NULL),(1527,'Noor Sunflower Oil 5ltr',9,'single',19,247,29,NULL,NULL,'exclusive',920,1050,1,1,'6291003124471','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 18:12:37','2019-05-17 18:12:37',NULL),(1528,'ALFA Mayonnaise 8 oz',9,'single',19,248,25,NULL,NULL,'exclusive',85,85,1,1,'6291003191015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:20:37','2020-07-20 23:17:56',NULL),(1529,'ALFA Mayonnaise 32 oz',9,'single',19,248,25,NULL,NULL,'exclusive',250,250,1,1,'6291003191022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:22:45','2019-05-18 15:49:20',NULL),(1530,'TIFFANY  Crunch Vanilla Wafers 76gm',9,'single',19,242,55,NULL,NULL,'exclusive',70,70,1,1,'6291003005657','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:28:41','2019-05-17 19:34:37',NULL),(1531,'TIFFANY  Crunch Chocolate Wafers 76gm',9,'single',19,242,55,NULL,NULL,'exclusive',70,70,1,1,'6291003005862','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:30:03','2019-05-17 19:35:09',NULL),(1532,'TIFFANY  Crunch Strawberry Wafers 76gm',9,'single',19,241,55,NULL,NULL,'exclusive',70,70,1,1,'6291003005855','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:31:21','2019-05-17 19:35:35',NULL),(1533,'TIFFANY  Crunch Hazelnut Wafers 76gm',9,'single',19,241,47,NULL,NULL,'exclusive',70,70,1,1,'6291003007101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:32:52','2019-05-17 19:32:52',NULL),(1534,'TIFFANY  Crunch Orange  Wafers 76gm',9,'single',19,241,55,NULL,NULL,'exclusive',70,70,1,1,'6291003005640','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:33:59','2019-05-17 19:33:59',NULL),(1535,'TWININGS Jasmine Green Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',340,340,1,1,'070177173418','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:40:44','2019-05-17 19:40:44',NULL),(1536,'TIFFANY Marrie 100gm',9,'single',19,241,5,NULL,NULL,'exclusive',100,100,1,1,'6291003000102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:44:04','2019-05-17 19:44:04',NULL),(1537,'TIFFANY Marrie 200gm',9,'single',19,241,5,NULL,NULL,'exclusive',210,230,1,1,'6291003000119','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:45:47','2019-06-27 16:35:49',NULL),(1538,'TIFFANY  Delights Bourbon 200gm',9,'single',19,242,5,NULL,NULL,'exclusive',210,210,1,1,'6291003000577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:48:46','2019-05-17 19:52:37',NULL),(1539,'TIFFANY  Delights Shortbreads 200gm',9,'single',19,241,5,NULL,NULL,'exclusive',210,210,1,1,'6291003000584','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:51:04','2019-05-17 19:51:04',NULL),(1540,'TIFFANY  Delights Ginger Nuts 200gm',9,'single',19,241,5,NULL,NULL,'exclusive',210,210,1,1,'6291003000553','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:54:25','2019-05-17 19:54:25',NULL),(1541,'HP Sauce',9,'single',19,249,32,NULL,NULL,'exclusive',180,180,1,1,'5000111001007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 19:57:31','2019-05-17 19:57:31',NULL),(1542,'OGARDEN Aloe Vera 1.5ltr',9,'single',19,250,24,NULL,NULL,'exclusive',445,445,1,1,'8809125062861','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:02:23','2019-05-17 20:02:23',NULL),(1543,'FOLEP & COURT Assorted Eclairs 600gm',9,'single',19,251,15,NULL,NULL,'exclusive',660,660,1,1,'9501034796002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:07:18','2019-05-17 20:07:18',NULL),(1544,'ALFA Mayonnaise 16 oz',9,'single',19,248,25,NULL,NULL,'exclusive',140,140,1,1,'6291003191275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:19:14','2019-05-18 15:47:23',NULL),(1547,'TWININGS Mint Green Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',340,340,1,1,'070177173388','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:25:13','2019-05-17 20:25:13',NULL),(1548,'TWININGS English Breakfast Green Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',340,340,1,1,'070177074579','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:26:53','2019-05-17 20:26:53',NULL),(1549,'CHIKO Eclair 400gm',9,'single',19,252,15,NULL,NULL,'exclusive',450,450,1,1,'9501034779357','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:29:53','2019-05-17 20:29:53',NULL),(1550,'KRAFT Chedduar Cheese 480gm',9,'single',19,253,13,NULL,NULL,'exclusive',570,570,1,1,'7622210852465','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:33:23','2019-05-17 20:33:23',NULL),(1551,'KRAFT Cheddar Cheese 230 gm',9,'single',19,253,13,NULL,NULL,'exclusive',300,300,1,1,'7622210852427','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:34:49','2019-05-18 15:39:47',NULL),(1552,'ALMARAI Processed Cream Cheese 200 gm',9,'single',19,254,13,NULL,NULL,'exclusive',300,300,1,1,'6281007043359','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:49:19','2019-05-18 15:43:20',NULL),(1553,'LIPTON Green Tea Classic 100gm',9,'single',19,103,37,NULL,NULL,'exclusive',550,550,1,1,'6281006850989','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 20:58:55','2020-11-19 20:19:24',NULL),(1554,'LIPTON Green Tea Lemon 100gm',9,'single',19,103,37,NULL,NULL,'exclusive',550,550,1,1,'6281006851023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:00:18','2019-05-17 21:00:18',NULL),(1555,'TWININGS Earl Grey Tea 50 gm',9,'single',19,152,37,NULL,NULL,'exclusive',340,340,1,1,'070177074562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:03:03','2019-05-18 15:43:58',NULL),(1556,'HERSHEYS Syrup Caramel 623gm',9,'single',19,111,36,NULL,NULL,'exclusive',310,310,1,1,'03436602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:12:27','2019-05-17 21:12:27',NULL),(1557,'OVALTINE Chocolate Flv 400gm',9,'single',19,255,20,NULL,NULL,'exclusive',380,380,1,1,'8850086191404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:17:31','2020-10-20 17:13:30',NULL),(1558,'BASSO Italian Skincare Extract Orange 100 ml',9,'single',19,246,29,NULL,NULL,'exclusive',160,175,1,1,'8004123012195','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:20:33','2019-05-20 23:58:47',NULL),(1559,'BASSO Italian Skincare Extract Orange oil 250 ml',9,'single',19,246,29,NULL,NULL,'exclusive',340,335,1,1,'8004123012171','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:22:11','2019-11-19 17:04:21',NULL),(1560,'TIFFANY Sugar Free Oatmeal Cookies 150gm',9,'single',19,241,18,NULL,NULL,'exclusive',210,210,1,1,'6291003004773','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:43:46','2019-05-18 15:36:24',NULL),(1561,'ASCEL  Vegetable Ghee 500 gm',9,'single',19,256,74,NULL,NULL,'exclusive',225,225,1,1,'631583101015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:49:52','2019-05-18 15:45:16',NULL),(1562,'ASCEL  Vegetable Ghee 1kg',9,'single',19,256,74,NULL,NULL,'exclusive',450,450,1,1,'631583101855','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:51:18','2019-05-17 21:51:18',NULL),(1563,'COLOMBINA BonBon Bum Assorted 1700gm (100Pcs)',9,'single',19,257,15,NULL,NULL,'exclusive',15,15,1,1,'7702011111463','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 21:56:42','2019-05-17 21:56:42',NULL),(1564,'TIFFANY  Delights Chocolate Chip 200gm',9,'single',19,241,18,NULL,NULL,'exclusive',170,170,1,1,'629100310347','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 22:05:12','2019-05-17 22:05:12',NULL),(1565,'ALMARAI Processed Cream Cheese  500 gm',9,'single',19,254,13,NULL,NULL,'exclusive',570,570,1,1,'6281007042765','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 22:09:37','2019-05-18 15:44:42',NULL),(1566,'TIFFANY  Delights Butter Cookies 405gm',9,'single',19,241,18,NULL,NULL,'exclusive',540,540,1,1,'6291003006678','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 22:20:37','2019-05-17 22:20:37',NULL),(1567,'TIFFANY Sugar Free Lemon Flv Cream Biscuit 162gm',9,'single',19,241,5,NULL,NULL,'exclusive',210,210,1,1,'6291003004759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 23:43:39','2019-05-17 23:43:39',NULL),(1568,'TIFFANY Sugar Free Chocolate Flv Cream Biscuit 162gm',9,'single',19,241,5,NULL,NULL,'exclusive',210,210,1,1,'6291003004766','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-17 23:45:35','2019-05-17 23:45:35',NULL),(1569,'TIFFANY Break chocolate 372gm',9,'single',19,241,15,NULL,NULL,'exclusive',45,60,1,1,'6291003203527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 00:22:12','2019-08-04 16:30:30',NULL),(1570,'TIFFANY Take 5 564gm',9,'single',19,241,15,NULL,NULL,'exclusive',25,25,1,1,'6291003043109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 00:34:10','2019-05-18 00:34:10',NULL),(1572,'Voi Wet Baby Wipes Cream Lotion120 pc',9,'single',19,259,69,NULL,NULL,'exclusive',180,220,1,1,'8681608220063','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 19:00:19','2020-07-21 19:49:24',NULL),(1573,'Voi Wet Wipes Blue Passion 120 pcs',9,'single',19,259,69,NULL,NULL,'exclusive',180,220,1,1,'8681608220681','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 19:01:58','2020-07-21 19:51:02',NULL),(1574,'Voi Wet Wipes Family 120 pcs',9,'single',19,NULL,69,NULL,NULL,'exclusive',180,220,1,1,'8681608220070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 19:08:06','2020-07-21 19:50:30',NULL),(1575,'Voi Wet Wipes Waterfall 120 pcs',9,'single',19,259,69,NULL,NULL,'exclusive',180,220,1,1,'8681608220575','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 19:09:43','2020-07-21 19:50:02',NULL),(1576,'Voi Cleaning Wet Wipes 15 pcs',9,'single',19,259,69,NULL,NULL,'exclusive',45,50,1,1,'8681608220841','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 19:14:45','2019-05-18 19:34:40',NULL),(1577,'Chupa Chups 12 gm',9,'single',19,148,57,NULL,NULL,'exclusive',30,40,1,1,'8410031950656','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 19:47:41','2019-11-02 18:28:35',NULL),(1578,'Cadbury Dairy Milk Hazelnut 165 gm',9,'single',19,129,15,NULL,NULL,'exclusive',210,225,1,1,'7622210400277','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 20:33:09','2019-05-27 19:59:50',NULL),(1579,'Cadbury Dairy Milk Honeycomb & Nuts 165 gm',9,'single',19,129,15,NULL,NULL,'exclusive',225,225,1,1,'7622210631732','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 20:35:09','2020-07-21 19:22:48',NULL),(1580,'Cadbury Dairy Milk Roast Almond 165 gm',9,'single',19,129,15,NULL,NULL,'exclusive',210,225,1,1,'7622210400291','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 20:37:10','2020-07-19 16:04:51',NULL),(1581,'Cadbury Dairy Milk Black Forest 165 gm',9,'single',19,129,15,NULL,NULL,'exclusive',210,225,1,1,'7622210400284','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 20:38:35','2020-07-19 16:07:20',NULL),(1582,'Cadbury Dairy Milk Fruit & Nut 165 gm',9,'single',19,129,15,NULL,NULL,'exclusive',210,225,1,1,'7622210410511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 20:40:06','2020-07-21 19:21:53',NULL),(1583,'Apollo Milk Wafer Cream 12 gm',9,'single',19,260,55,NULL,NULL,'exclusive',10,10,1,1,'726165673049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 20:51:59','2019-05-18 20:51:59',NULL),(1584,'Mentos Pure Fresh Wintergreen Mint Flv Gum 29.7 gm',9,'single',19,261,22,NULL,NULL,'exclusive',100,100,1,1,'8935001708964','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-18 23:44:14','2019-05-18 23:44:14',NULL),(1585,'Mentos Pure Fresh Lime Mint Flv Gum 29.7 gm',9,'single',19,261,22,NULL,NULL,'exclusive',100,100,1,1,'8935001721925','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 00:54:33','2019-05-19 00:54:33',NULL),(1586,'Mentos Pure Fresh Strong Mint Flv Gum 29.7 gm',9,'single',19,261,22,NULL,NULL,'exclusive',100,100,1,1,'8935001722571','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 00:58:12','2019-05-19 00:58:12',NULL),(1587,'Mentos Pure Berry Lime Mint Flv Gum 29.7 gm',9,'single',19,261,22,NULL,NULL,'exclusive',100,100,1,1,'8935001707387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 00:59:58','2019-05-19 00:59:58',NULL),(1588,'Mentos Pure Fresh Mint Flv Gum 29.7 gm',9,'single',19,261,22,NULL,NULL,'exclusive',100,100,1,1,'8935001708988','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 01:01:43','2019-05-19 01:01:43',NULL),(1589,'Cowhead Slim Milk 1 lt',9,'single',19,84,26,NULL,NULL,'exclusive',195,210,1,1,'8888440005647','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 16:44:59','2020-09-08 16:21:39',NULL),(1590,'Snickers Snake 32 gm',9,'single',19,120,15,NULL,NULL,'exclusive',40,40,1,1,'6294001813316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 18:51:46','2019-05-19 18:51:46',NULL),(1591,'Mars Chocolate Bar 51 gm',9,'single',19,117,15,NULL,NULL,'exclusive',65,70,1,1,'5000159407236','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 19:07:16','2019-05-20 02:15:56',NULL),(1592,'Britannia Sugar Free Digestive Biscuit 350 gm',9,'single',19,188,5,NULL,NULL,'exclusive',265,279,1,1,'6291007902198','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 19:11:44','2019-05-19 19:11:44',NULL),(1593,'ACT II Classic Salted Popcorn 50 gm',9,'single',19,189,58,NULL,NULL,'exclusive',20,20,1,1,'710535347449','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 19:19:08','2019-05-19 19:19:08',NULL),(1594,'ACT II Golden Sizzle- Popping Corn 50 gm',9,'single',19,189,58,NULL,NULL,'exclusive',20,20,1,1,'710535347456','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 19:22:52','2019-05-19 19:22:52',NULL),(1595,'Ensure 200 gm (Double) Gift Pack',9,'single',19,185,19,NULL,NULL,'exclusive',690,694,1,1,'100024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 19:56:34','2019-05-19 19:56:34',NULL),(1596,'Mentos Cool Chews Lime Mint 38 gm',9,'single',19,261,22,NULL,NULL,'exclusive',130,130,1,1,'6921211101321','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 20:27:15','2019-05-20 01:52:08',NULL),(1597,'Mentos Cool Chews Fresh Mint 38 gm',9,'single',19,261,22,NULL,NULL,'exclusive',125,130,1,1,'8710800970688','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 20:29:47','2019-05-20 03:07:59',NULL),(1598,'Mentos Cool Chews Berry Mint 38 gm',9,'single',19,261,22,NULL,NULL,'exclusive',130,130,1,1,'8935001723530','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-19 20:31:20','2019-05-20 01:51:07',NULL),(1599,'Heniz First Steps Gluten Free Multigrain With Carrot,Sweetcorn & Cheese 7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157141453','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:06:47','2019-05-20 17:44:36',NULL),(1600,'Heinz First Step No Added Sugar Peachy Porridge 7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,550,1,1,'5000157077042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:10:16','2020-11-10 18:42:59',NULL),(1601,'Heinz First Steps No Added Sugar Creamy Oat & Apple Porridge 4+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157076991','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:21:05','2020-11-10 18:42:24',NULL),(1602,'Heinz First Step No Added Sugar Creamy Fruit & Yogurt Porridge 4+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157076984','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:23:50','2019-05-20 17:44:14',NULL),(1603,'Heinz First Step No Added Sugar Creamy Peach & Apricot Porridge 7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157077004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:28:07','2019-05-20 17:43:45',NULL),(1604,'Heinz First Step No Added Sugar Summer Fruit Porridge 7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,550,1,1,'5000157077059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:33:34','2020-11-10 18:43:22',NULL),(1605,'Heinz First Step Gluten Free Baby Rice With Garden Veg 4+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',480,550,1,1,'5000157141316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:38:46','2019-05-27 20:31:19',NULL),(1606,'Heinz First Step No Added Sugar Baby Porridge 4+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,550,1,1,'5000157076977','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:40:28','2020-11-10 18:44:12',NULL),(1607,'Heinz First Step No Added Creamy Banana Porridge 4+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157077011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:42:17','2020-11-10 18:44:42',NULL),(1608,'Heinz First Step No Added Sugar Blueberry Porridge 7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,550,1,1,'5000157077028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:43:40','2020-11-10 18:43:49',NULL),(1609,'Heinz First Step Gluten Free Multigrain With Cauliflower,Broccoli & Cheese 4+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157141477','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:47:11','2019-05-20 17:42:19',NULL),(1610,'Heinz First Step With Small Pieces Cheesy Veg With Pasta  7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157141293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 00:51:49','2019-05-20 17:43:20',NULL),(1611,'Cadbury Dairy Milk Chocolate 165 gm',9,'single',19,129,15,NULL,NULL,'exclusive',210,225,1,1,'7622210410474','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 01:49:37','2020-07-19 16:06:55',NULL),(1612,'Nestle KitKat Chunky Mini 15 pcs 250 gm',9,'single',19,63,15,NULL,NULL,'exclusive',450,500,1,1,'4005500049623','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 02:19:57','2019-05-20 02:19:57',NULL),(1613,'Sweet Zone Fruity Mallows 140 gm',9,'single',19,113,22,NULL,NULL,'exclusive',325,440,1,1,'5032860010405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 02:44:57','2019-05-20 02:44:57',NULL),(1614,'Maynards Bassetts Jelly Babies 400 gm',9,'single',19,262,15,NULL,NULL,'exclusive',450,500,1,1,'7622210753366','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 02:50:22','2019-05-20 02:50:22',NULL),(1615,'Haribo Goldbears 250 gm',9,'single',19,263,15,NULL,NULL,'exclusive',450,500,1,1,'4001686305638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 02:54:53','2019-05-20 02:54:53',NULL),(1616,'Galaxy Fruit & Nut Chocolate 40 gm',9,'single',19,110,15,NULL,NULL,'exclusive',105,120,1,1,'6221134001129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 03:00:32','2019-08-31 15:57:47',NULL),(1617,'Farley\'s Rusks Original 150 gm',9,'single',19,13,59,NULL,NULL,'exclusive',400,450,1,1,'5000218005670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 16:33:00','2019-05-20 16:33:00',NULL),(1618,'Gerber Organic Banana 113 gm',9,'single',19,145,59,NULL,NULL,'exclusive',135,150,1,1,'01528107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 16:36:46','2019-05-20 16:36:46',NULL),(1619,'Cow & Gate Egg Custard 125 gm',9,'single',19,264,59,NULL,NULL,'exclusive',135,150,1,1,'5900852925184','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 16:39:33','2019-05-20 16:39:33',NULL),(1620,'Heinz By Nature Cheesy Tomato Pasta 120 gm',9,'single',19,13,59,NULL,NULL,'exclusive',135,150,1,1,'5000157140456','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 16:42:00','2019-05-20 16:42:00',NULL),(1621,'Choco Mira Chocolate Dates With Almond 300 gm',9,'single',19,265,15,NULL,NULL,'exclusive',600,650,1,1,'8010712505567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 16:54:18','2019-05-20 16:54:18',NULL),(1622,'Heinz Baby Pasta Stars 7+ 250 gm',9,'single',19,13,30,NULL,NULL,'exclusive',400,450,1,1,'5000157070470','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 17:00:25','2019-05-20 17:00:25',NULL),(1623,'Heinz First Steps No Added Sugar Oaty Banana Porridge 7+ (240 gm)',9,'single',19,13,59,NULL,NULL,'exclusive',500,600,1,1,'5000157077035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 17:40:27','2019-05-20 17:40:27',NULL),(1624,'Snow Queen Jelly Pyramid 100 gm',9,'single',19,266,15,NULL,NULL,'exclusive',100,120,1,1,'8852028353062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 17:46:58','2019-05-21 19:00:06',NULL),(1625,'Farley\'s Rusks Original 300 gm',9,'single',19,13,59,NULL,NULL,'exclusive',550,650,1,1,'5000218005687','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 17:49:51','2019-05-20 17:49:51',NULL),(1626,'Lay\'s Classic 184.2 gm',9,'single',19,174,14,NULL,NULL,'exclusive',385,425,1,1,'028400017145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:26:10','2019-06-23 20:35:30',NULL),(1627,'Lay\'s Sour Cream & Onion 184.2 gm',9,'single',19,174,14,NULL,NULL,'exclusive',385,425,1,1,'028400017015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:28:36','2019-06-23 20:44:27',NULL),(1628,'Lay\'s Salt & Vinegar 184.2 gm',9,'single',19,174,14,NULL,NULL,'exclusive',385,425,1,1,'028400017503','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:30:16','2019-05-20 20:30:16',NULL),(1629,'Lay\'s Barbecue 184.2 gm',9,'single',19,174,14,NULL,NULL,'exclusive',385,425,1,1,'028400017688','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:31:42','2019-06-23 20:33:48',NULL),(1630,'Lay\'s Stax Chips Cheddar  155.9 gm',9,'single',19,174,14,NULL,NULL,'exclusive',200,250,1,1,'028400055116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:40:14','2019-05-20 20:40:14',NULL),(1631,'Lay\'s Stax Chips Salt & Vinegar  155.9 gm',9,'single',19,174,14,NULL,NULL,'exclusive',200,250,1,1,'028400055147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:41:39','2019-05-20 20:41:39',NULL),(1632,'Doritos Spicy Nacho 198.4 gm',9,'single',19,194,14,NULL,NULL,'exclusive',380,425,1,1,'028400003575','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:44:46','2019-05-20 20:44:46',NULL),(1633,'Doritose Nacho Cheese 198.4 gm',9,'single',19,194,14,NULL,NULL,'exclusive',380,425,1,1,'028400017299','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:47:47','2019-05-20 20:47:47',NULL),(1634,'Doritose Nacho Cheese 60.2 gm',9,'single',19,194,14,NULL,NULL,'exclusive',105,115,1,1,'028400012102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:53:05','2019-05-20 20:53:05',NULL),(1635,'Cheetos Crunchy 226.8 gm',9,'single',19,267,14,NULL,NULL,'exclusive',380,380,1,1,'028400017244','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:56:36','2019-05-20 20:56:36',NULL),(1636,'Cheetos Flamin Hot Crunchy 226.8 gm',9,'single',19,267,14,NULL,NULL,'exclusive',380,425,1,1,'028400069601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 20:58:50','2019-05-20 20:58:50',NULL),(1637,'Cheetos Flamin Hot Crunchy 226.8 gm',9,'single',19,267,14,NULL,NULL,'exclusive',175,195,1,1,'028400037174','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-20 21:00:50','2019-05-20 21:00:50',NULL),(1638,'Cowhead Fruits & Nuts Butter Cookies Tin 400 gm',9,'single',19,84,18,NULL,NULL,'exclusive',660,825,1,1,'8888440010719','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 15:57:11','2019-07-01 17:08:34',NULL),(1639,'Cowhead Butter Milk Cookies 350 gm',9,'single',19,84,26,NULL,NULL,'exclusive',445,560,1,1,'8888440010054','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:05:42','2019-05-21 16:05:42',NULL),(1640,'Clover Good Hope Soy Milk Regular 1 lt',9,'single',19,268,26,NULL,NULL,'exclusive',290,350,1,1,'6007359000730','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:13:15','2019-05-21 16:13:15',NULL),(1641,'Nestle Cerelac Rice 6 Months 500 gm',9,'single',19,63,59,NULL,NULL,'exclusive',600,600,1,1,'9556001171733','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:30:27','2019-05-21 16:30:27',NULL),(1642,'Nestle Cerelac Wheat & Honey 6 Months 500 gm',9,'single',19,63,59,NULL,NULL,'exclusive',600,600,1,1,'9556001171771','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:32:06','2019-05-21 16:32:06',NULL),(1643,'Pampers Sensitive Protect Wet Wipes 56 pcs',9,'single',19,270,69,NULL,NULL,'exclusive',250,250,1,1,'4015400621966','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:40:06','2019-05-21 16:40:06',NULL),(1644,'Pampers Prime Temiz ve Ferah 64 Pcs',9,'single',19,270,69,NULL,NULL,'exclusive',250,250,1,1,'4015400517276','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:42:57','2019-05-21 16:42:57',NULL),(1645,'Nivea Baby Soft & Cream Wet Wipes 63 pcs',9,'single',19,271,69,NULL,NULL,'exclusive',265,265,1,1,'4005808862443','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:46:16','2019-05-21 16:46:16',NULL),(1646,'SMA Pro 2 Milk 800 gm',9,'single',19,269,59,NULL,NULL,'exclusive',1440,1440,1,1,'7613035477742','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:47:24','2019-05-21 16:47:24',NULL),(1647,'SMA Pro 3 Milk 800 gm',9,'single',19,269,59,NULL,NULL,'exclusive',1440,1440,1,1,'7613035457621','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:48:42','2019-05-21 16:48:42',NULL),(1648,'Kellogg\'s Variety Pack',9,'single',19,128,59,NULL,NULL,'exclusive',340,340,1,1,'5000127533196','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:50:46','2019-05-21 16:50:46',NULL),(1649,'Cow & Gate My First Muesli 330 gm',9,'single',19,264,59,NULL,NULL,'exclusive',480,480,1,1,'5000378999420','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:52:59','2019-05-21 16:52:59',NULL),(1650,'Cow & Gate My First Banana Muesli 330 gm',9,'single',19,264,59,NULL,NULL,'exclusive',480,480,1,1,'5051594001077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:55:01','2019-06-16 22:26:39',NULL),(1651,'Cadbury Dairy Milk Wholenut 200 gm',9,'single',19,129,15,NULL,NULL,'exclusive',375,375,1,1,'7622300735999','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:57:21','2019-05-21 16:57:21',NULL),(1652,'Cadbury Dairy Milk Fruit & Nut 200 gm',9,'single',19,129,15,NULL,NULL,'exclusive',375,375,1,1,'7622300736019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 16:58:58','2019-05-21 16:58:58',NULL),(1653,'Cow & Gate Apple & Pear 4 Pc (4-6+ months)',9,'single',19,264,59,NULL,NULL,'exclusive',460,460,1,1,'5000378998416','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:02:39','2019-05-21 17:05:41',NULL),(1654,'Cow & Gate Apple & Banana 4 Pc (4-6+ months)',9,'single',19,264,59,NULL,NULL,'exclusive',460,460,1,1,'5000378998393','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:05:00','2019-05-21 17:05:00',NULL),(1655,'Cow & Gate Apple & Plum 4 Pc (4-6+ months)',9,'single',19,264,59,NULL,NULL,'exclusive',460,460,1,1,'5000378998744','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:07:07','2019-05-21 17:07:07',NULL),(1656,'Heinz Pear & Apple Custard 4 Pcs ( 4+ Months)',9,'single',19,13,59,NULL,NULL,'exclusive',460,460,1,1,'5000157079985','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:13:48','2019-05-21 17:13:48',NULL),(1657,'Cow & Gate Apple,Mango & Passion Fruit  4 Pc (4-6+ months)',9,'single',19,264,59,NULL,NULL,'exclusive',460,460,1,1,'3041091265562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:15:29','2019-05-21 17:15:29',NULL),(1658,'Cow & Gate Fruit Cocktail 4 Pc (4-6+ months)',9,'single',19,264,59,NULL,NULL,'exclusive',460,460,1,1,'5000378998454','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:17:24','2019-05-21 17:17:24',NULL),(1659,'Ella\'s Kitchen Apple Cinnamon Crumble 6+ (4 pcs)',9,'single',19,272,59,NULL,NULL,'exclusive',480,480,1,1,'5060107339262','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:23:22','2019-05-21 17:23:22',NULL),(1660,'Ella\'s Kitchen Banna Vanilla  6+ (4 pcs)',9,'single',19,272,59,NULL,NULL,'exclusive',480,480,1,1,'5060107339248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:25:53','2019-05-21 17:25:53',NULL),(1661,'Pampers Baby-Dry Nappy Pants Jumbo Pack 5 (60 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001841159706','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:36:58','2019-05-21 17:36:58',NULL),(1662,'Pampers Baby-Dry Jumbo Pack Diaper 5 (72 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'4015400695691','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:43:06','2019-05-21 17:43:06',NULL),(1663,'Pampers Baby-Dry Diaper Jumbo Pack 8 (52 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001090672285','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:46:04','2019-05-21 17:46:04',NULL),(1664,'Pampers Baby-Dry Diaper Jumbo Pack 6 (62 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001090368553','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:48:13','2019-05-21 17:48:13',NULL),(1665,'Pampers Baby-Dry diaper Jumbo Pack 4 (86 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001090156839','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:50:20','2019-05-21 17:50:20',NULL),(1666,'Pampers Baby-Dry Nappy Pants Jumbo Pack 6 (52 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001841159584','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:52:20','2019-05-21 17:52:20',NULL),(1667,'Pampers Baby-Dry Nappy Pants Jumbo Pack 7 (48 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001841159652','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:53:56','2019-05-21 17:53:56',NULL),(1668,'Pampers Baby-Dry Diaper Jumbo Pack 7 (58 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001090406507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 17:58:02','2019-05-21 17:58:02',NULL),(1669,'Pampers Baby-Dry Diaper Jumbo Pack 5+ (68 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'4015400695714','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 18:00:11','2019-05-21 18:00:11',NULL),(1670,'Snow Queen Jelly Roll 100 gm',9,'single',19,266,15,NULL,NULL,'exclusive',100,120,1,1,'8852028362101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 19:02:33','2019-05-21 19:02:33',NULL),(1671,'Snow Queen Jelly Sandwich 100 gm',9,'single',19,266,15,NULL,NULL,'exclusive',100,120,1,1,'8852028322105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 19:03:49','2019-05-21 19:03:49',NULL),(1672,'Cadbury Oreo Chocolate Sandwich Biscuits Original 50 gm',9,'single',19,87,5,NULL,NULL,'exclusive',25,25,1,1,'8901233013091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 19:54:10','2019-06-15 19:50:09',NULL),(1673,'Mango Bar',9,'single',19,273,75,NULL,NULL,'exclusive',580,580,1,1,'100025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 19:55:04','2019-05-21 19:55:04',NULL),(1674,'Pampers Baby-Dry Nappy Pants Jambo Pack 4 (74 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001841159676','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 20:36:10','2019-05-21 20:36:10',NULL),(1675,'Pampers Baby-Dry Nappy Pants Jumbo Pack 3 (80 pcs)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001090706485','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 20:38:12','2019-05-21 20:38:12',NULL),(1676,'Ceres Ruby Grapefruit  100% Juice 1 L',9,'single',19,82,24,NULL,NULL,'exclusive',330,375,1,1,'6001240100417','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 20:47:52','2019-05-21 20:47:52',NULL),(1677,'Grante 100% Pure Pomegranate,Grape & Apple Juice 750 ml',9,'single',19,80,24,NULL,NULL,'exclusive',400,490,1,1,'4760041300434','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 20:51:57','2019-05-21 20:51:57',NULL),(1678,'Gerber Probiotic Oatmeal Banana Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070083','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 21:58:45','2019-05-21 22:13:54',NULL),(1679,'Garber Probiotic Rice Banana Apple Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070076','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 22:10:12','2019-05-21 22:14:18',NULL),(1680,'Gerber Beef and Gravy 2nd Foods 71 gm',9,'single',19,145,59,NULL,NULL,'exclusive',150,150,1,1,'015000012144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 22:18:22','2019-05-21 22:18:22',NULL),(1681,'Gerber Turkey and Gravy 71 gm',9,'single',19,145,59,NULL,NULL,'exclusive',150,150,1,1,'015000012175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 22:19:43','2019-05-21 22:19:43',NULL),(1682,'Gerber Chicken and Gravy 2nd Foods 71 gm',9,'single',19,145,59,NULL,NULL,'exclusive',150,150,1,1,'015000012120','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 22:24:49','2019-05-21 22:24:49',NULL),(1683,'Gerber Organic Puffs Apple 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000048273','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 22:29:49','2019-07-24 16:46:43',NULL),(1684,'Gerber Organic Puffs Cranberry Orange 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,285,1,1,'015000045630','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:22:50','2019-05-21 23:22:50',NULL),(1685,'Gerber Puffs Apple Cinnamon 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045265','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:26:45','2019-07-24 16:47:03',NULL),(1686,'Gerber Puffs Banana 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045210','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:29:27','2019-07-24 16:47:33',NULL),(1687,'Gerber  Puffs Cereal Snack Blueberry 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045296','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:32:58','2019-07-24 16:47:57',NULL),(1688,'Gerber  Puffs Cereal Snack Peach 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045258','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:34:19','2019-07-24 16:48:20',NULL),(1689,'Gerber  Puffs Cereal Strawberry Apple 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045203','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:36:34','2019-07-24 16:48:43',NULL),(1690,'Gerber  Puffs Cereal Snack Sweet Potato 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045227','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:38:33','2019-07-24 16:49:00',NULL),(1691,'Gerber  Puffs Cereal Vanilla 42 gm',9,'single',19,145,59,NULL,NULL,'exclusive',285,480,1,1,'015000045289','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:39:31','2019-07-24 16:49:24',NULL),(1692,'Gerber Organic Apple Juice 118 ml',9,'single',19,145,59,NULL,NULL,'exclusive',140,140,1,1,'045500871071','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:42:17','2019-05-21 23:42:17',NULL),(1693,'Gerber Multi Grain Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',460,500,1,1,'015000070038','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-21 23:45:36','2019-07-19 20:43:23',NULL),(1694,'Gerber Whole Wheat Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',420,500,1,1,'015000070045','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:00:25','2019-07-24 16:50:28',NULL),(1695,'Gerber Oatmeal Single Grain Cereal 454 gm',9,'single',19,145,59,NULL,NULL,'exclusive',730,900,1,1,'015000070519','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:03:46','2020-07-22 22:11:47',NULL),(1696,'Gerber Rice Single Grain Cereal 454 gm',9,'single',19,145,59,NULL,NULL,'exclusive',730,750,1,1,'015000070502','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:05:58','2019-05-27 21:44:15',NULL),(1697,'Gerber Pear Juice 946 ml',9,'single',19,145,24,NULL,NULL,'exclusive',445,445,1,1,'015000020842','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:16:51','2019-05-22 00:16:51',NULL),(1698,'Gerber Probiotic Oatmeal Peach Apple Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:20:43','2019-05-22 00:20:43',NULL),(1699,'Gerber Hearty Bits Multigrain Banana Apple Strawberry 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070359','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:24:24','2019-05-22 00:24:24',NULL),(1700,'Gerber Multi Grain Cereal 454 gm',9,'single',19,145,59,NULL,NULL,'exclusive',730,900,1,1,'015000070526','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:27:33','2020-07-22 22:12:12',NULL),(1701,'Gerber DHA & Probiotic Rice Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070052','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:30:44','2019-05-22 00:30:44',NULL),(1702,'Gerber Organic Oatmeal Single Grain Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,535,1,1,'015000070212','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:32:28','2019-05-22 00:32:28',NULL),(1703,'Cow & Gate 1 (800 gm)',9,'single',19,264,59,NULL,NULL,'exclusive',1450,1470,1,1,'5051594006874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:57:37','2019-10-08 14:48:54',NULL),(1704,'Cow & Gate 2 (800 gm)',9,'single',19,264,59,NULL,NULL,'exclusive',1450,1400,1,1,'5051594006881','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 00:59:41','2019-10-08 14:50:51',NULL),(1705,'Cow & Gate 3 (800 gm)',9,'single',19,264,59,NULL,NULL,'exclusive',1450,1600,1,1,'5051594006867','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:01:22','2019-10-08 14:51:55',NULL),(1706,'Cow & Gate 4 (800 gm)',9,'single',19,264,59,NULL,NULL,'exclusive',1400,1400,1,1,'5051594001930','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:02:39','2019-05-22 01:02:39',NULL),(1707,'Aptamil 1 (800 gm)',9,'single',19,274,59,NULL,NULL,'exclusive',1600,1600,1,1,'5051594006812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:08:26','2019-05-22 01:08:26',NULL),(1708,'Aptamil 2 (800 gm)',9,'single',19,274,59,NULL,NULL,'exclusive',1600,1600,1,1,'5051594006829','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:10:05','2019-05-22 01:10:05',NULL),(1709,'Aptamil 3 (800 gm)',9,'single',19,274,59,NULL,NULL,'exclusive',1600,1600,1,1,'5051594006805','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:11:26','2019-10-08 14:55:24',NULL),(1710,'Aptamil 4 (800 gm)',9,'single',19,NULL,59,NULL,NULL,'exclusive',1600,1600,1,1,'5051594001954','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:12:49','2019-05-22 01:12:49',NULL),(1711,'Golden Drop Sunflower Oil 1 Lt',9,'single',19,175,29,NULL,NULL,'exclusive',250,260,1,1,'4820001118292','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:29:55','2019-05-22 01:29:55',NULL),(1712,'Golden Drop Sunflower Oil 3 Lt',9,'single',19,175,29,NULL,NULL,'exclusive',700,770,1,1,'4820001118315','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:33:00','2019-05-22 01:33:00',NULL),(1713,'Golden Drop Sunflower Oil 5 Lt',9,'single',19,175,29,NULL,NULL,'exclusive',1100,1260,1,1,'4820001117165','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-22 01:34:19','2019-05-22 01:34:19',NULL),(1714,'Mamy Poko Pants Extra Absorb XXL 22 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',760,800,1,1,'8993189271700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 00:57:02','2019-07-20 15:34:39',NULL),(1715,'Mamy Poko Pants Extra Absorb S 60 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',1080,1080,1,1,'8903622037152','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 00:59:44','2019-05-23 00:59:44',NULL),(1716,'Mamy Poko Pants Extra Absorb M 56 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',1080,1080,1,1,'8903622037251','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 01:09:25','2019-05-23 01:09:25',NULL),(1717,'Mamy Poko Pants Extra Absorb XL 38 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',1080,1080,1,1,'8903622031587','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 01:14:40','2019-05-23 01:14:40',NULL),(1718,'Tipco 100% Apple Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',380,425,1,1,'8850779100393','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:20:59','2019-12-02 16:05:57',NULL),(1719,'Tipco 100% Si Thong Orange Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,425,1,1,'8851013787493','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:23:03','2019-05-23 18:23:03',NULL),(1720,'Tipco 100% Medley Orange Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,425,1,1,'8851013785499','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:24:31','2019-05-23 18:24:31',NULL),(1721,'Tipco 100% Pomegranate Mixed Fruit Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,425,1,1,'8851013767495','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:26:22','2019-05-23 18:26:22',NULL),(1722,'Tipco 100% Red Grape Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,425,1,1,'8851013797492','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:28:07','2019-05-23 18:28:07',NULL),(1723,'Tipco 100% Mango Mixed Fruit Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,425,1,1,'8850779100133','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:29:59','2019-05-23 18:29:59',NULL),(1724,'Tipco 100% Veggie Aloe Vera Juice With Gel Minced 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,425,1,1,'8851013788490','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-23 18:32:23','2019-05-23 18:32:23',NULL),(1726,'Nestle Kitkat Chunky 160 gm',9,'single',19,63,15,NULL,NULL,'exclusive',250,280,1,1,'6294003582753','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 01:58:26','2019-05-24 01:58:26',NULL),(1727,'Asda Milk Chocolate 100 gm',9,'single',19,277,15,NULL,NULL,'exclusive',110,150,1,1,'5054070864555','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 01:59:59','2019-05-24 01:59:59',NULL),(1728,'Asda Dark Chocolate 100 gm',9,'single',19,277,15,NULL,NULL,'exclusive',110,150,1,1,'5051413516133','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 02:01:10','2019-05-24 02:01:10',NULL),(1729,'Nestle Kit Kat Original 186gm',9,'single',19,63,15,NULL,NULL,'exclusive',290,295,1,1,'7613036099400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 15:09:26','2019-05-24 15:09:26',NULL),(1730,'Twix 5X(2X25gm)',9,'single',19,124,15,NULL,NULL,'exclusive',290,295,1,1,'5000159462594','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 15:13:22','2019-05-24 15:13:22',NULL),(1731,'Nestle Kit Kat 246gm',9,'single',19,63,15,NULL,NULL,'exclusive',345,350,1,1,'6294003557546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 15:16:04','2019-05-24 15:16:04',NULL),(1732,'Nestle Lactogen 2 (1.8 kg)',9,'single',19,63,59,NULL,NULL,'exclusive',2020,2080,1,1,'4800361382205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-24 22:32:56','2019-06-16 18:59:12',NULL),(1733,'Nestle Nan 3 800gm',9,'single',19,63,59,NULL,NULL,'exclusive',2050,0,1,1,'7613036487306','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-25 02:05:59','2019-10-08 14:46:40',NULL),(1734,'Nescafe Latte 180 ml',9,'single',19,138,16,NULL,NULL,'exclusive',90,90,1,1,'8850124025258','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 01:17:50','2019-05-26 01:17:50',NULL),(1735,'Nestle Milo Hi-Cal 240 ml Can',9,'single',19,63,52,NULL,NULL,'exclusive',100,100,1,1,'9556001081278','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 01:20:57','2019-05-26 01:20:57',NULL),(1736,'Ritz Crackers 300 gm',9,'single',19,278,42,NULL,NULL,'exclusive',270,270,1,1,'8992760211036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 01:22:45','2019-05-26 01:22:45',NULL),(1737,'Ramen Kimchi Noodle Soup 600 gm',9,'single',19,279,27,NULL,NULL,'exclusive',630,700,1,1,'4710145211037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 01:25:14','2020-07-18 16:30:09',NULL),(1738,'Briggen Corn Flakes 500 gm',9,'single',19,280,21,NULL,NULL,'exclusive',430,430,1,1,'4008713707526','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 01:27:55','2019-05-26 01:27:55',NULL),(1739,'Tropicana Twister Apple 1.5 lt',9,'single',19,217,24,NULL,NULL,'exclusive',0,0,1,1,'9556404115112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 01:30:16','2019-05-26 01:30:16',NULL),(1740,'Sunfeast Dark Fantasy Choco Fills',9,'single',19,281,5,NULL,NULL,'exclusive',60,65,1,1,'8901725132873','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-26 17:16:38','2019-06-16 18:26:16',NULL),(1741,'Lay\'s American Style Cream & Onion Flavour 25 gm',9,'single',19,174,14,NULL,NULL,'exclusive',25,25,1,1,'8901491503037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 18:14:11','2019-05-27 18:14:11',NULL),(1742,'Lay\'s Classic Salted 52 gm',9,'single',19,174,14,NULL,NULL,'exclusive',45,50,1,1,'8901491101837','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 18:16:14','2019-06-15 22:28:21',NULL),(1743,'Lotte Spout Peppermint Gum 23.8 gm',9,'single',19,20,22,NULL,NULL,'exclusive',25,25,1,1,'8801062118298','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 19:07:55','2019-05-27 19:07:55',NULL),(1744,'Lotte Spout Spearmint Gum 23.8 gm',9,'single',19,20,22,NULL,NULL,'exclusive',25,25,1,1,'8801062118274','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 19:21:43','2019-05-27 19:21:43',NULL),(1745,'Lotte Spout Cinnamon Gum 23.8 gm',9,'single',19,20,22,NULL,NULL,'exclusive',25,25,1,1,'8801062118250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 19:22:49','2019-05-27 19:22:49',NULL),(1746,'Lotte Spout Banana Gum 23.8 gm',9,'single',19,20,22,NULL,NULL,'exclusive',25,25,1,1,'8801062119288','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 19:23:50','2019-05-27 19:23:50',NULL),(1747,'Lotte Spout Grape Gum 23.8 gm',9,'single',19,20,22,NULL,NULL,'exclusive',25,25,1,1,'8801062119325','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 19:25:00','2019-05-27 19:25:00',NULL),(1748,'Lotte Spout Strawberry Gum 23.8 gm',9,'single',19,20,22,NULL,NULL,'exclusive',23,25,1,1,'8801062119301','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-27 19:26:09','2019-06-23 16:16:16',NULL),(1749,'Junior Horlicks Stage 1 Original 500 gm',9,'single',19,151,60,NULL,NULL,'exclusive',500,460,1,1,'8901571002429','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 00:41:45','2019-10-08 15:16:07',NULL),(1750,'Junior Horlicks Stage 2 Original 500 gm',9,'single',19,151,60,NULL,NULL,'exclusive',500,460,1,1,'8901571005802','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 00:43:42','2019-10-08 15:16:55',NULL),(1751,'Cadbury Oreo Biscuits Choco Cream Flavour 120 gm',9,'single',19,129,5,NULL,NULL,'exclusive',65,65,1,1,'8901233025162','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 00:46:42','2019-05-28 00:46:42',NULL),(1752,'Cadbury Oreo Biscuits Original Flavour 120 gm',9,'single',19,129,5,NULL,NULL,'exclusive',65,65,1,1,'8901233025155','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 00:48:36','2019-05-28 00:48:36',NULL),(1753,'Chewy Dragees Mentos Sour Mix Fruit Flavour 120 gm',9,'single',19,261,22,NULL,NULL,'exclusive',150,150,1,1,'6921211102731','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 20:24:24','2019-05-28 21:52:05',NULL),(1754,'Chewy Dragees Mentos Yoghut Fruit Flavour 120 gm',9,'single',19,261,22,NULL,NULL,'exclusive',0,0,1,1,'1754','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 20:26:27','2019-05-28 20:26:27',NULL),(1755,'Chewy Dragees Mentos Grape Flavour 120 gm',9,'single',19,261,22,NULL,NULL,'exclusive',0,0,1,1,'8935001708414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 20:28:26','2019-05-28 20:28:26',NULL),(1756,'Chewy Dragees Mentos Mint Flavour 120 gm',9,'single',19,261,22,NULL,NULL,'exclusive',0,0,1,1,'8935001711001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 21:42:41','2019-05-28 21:42:41',NULL),(1757,'Chewy Dragees Mentos Yoghut Fruit Flavour 120 gm',9,'single',19,261,22,NULL,NULL,'exclusive',150,150,1,1,'6921211102762','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 21:51:19','2019-05-28 21:51:19',NULL),(1758,'Nestle Lactogrow 3 650 gm',9,'single',19,63,59,NULL,NULL,'exclusive',770,800,1,1,'4800361406413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-28 22:08:23','2019-06-16 19:01:48',NULL),(1759,'Delicia Italian Truffles Cocoa Caramel 450 gm',9,'single',19,282,15,NULL,NULL,'exclusive',1150,1150,1,1,'852470002349','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-29 01:30:06','2019-05-29 01:30:06',NULL),(1760,'Ferrero Rocher T24',9,'single',19,115,15,NULL,NULL,'exclusive',0,0,1,1,'8000500009673','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-29 18:04:02','2020-09-17 15:56:15',NULL),(1761,'V-Water 550ml',9,'single',19,283,40,NULL,NULL,'exclusive',15,17,1,1,'12','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-29 22:27:24','2019-05-29 22:27:24',NULL),(1762,'Shan haleem Masala 50g',9,'single',19,231,66,NULL,NULL,'exclusive',0,0,1,1,'788821067142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 00:27:47','2019-05-30 00:27:47',NULL),(1763,'Santarium So Good Soy Milk Vanilla Bliss Flavour  1 Lt',9,'single',19,143,26,NULL,NULL,'exclusive',250,310,1,1,'9300652013955','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 18:36:37','2020-08-13 00:42:10',NULL),(1764,'Pauls (UHT) Skimmed Milk 1 Lt',9,'single',19,142,26,NULL,NULL,'exclusive',180,215,1,1,'9310036017080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 18:48:50','2019-05-30 18:48:50',NULL),(1765,'Nautilus Tuna Chunks in Spring Water 185 gm',9,'single',19,284,8,NULL,NULL,'exclusive',150,150,1,1,'8850229100102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 18:55:34','2019-05-30 18:55:34',NULL),(1766,'Nautilus Tuna Steak in Soybean Oil 185 gm',9,'single',19,284,8,NULL,NULL,'exclusive',150,150,1,1,'8850229100010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 18:59:02','2019-05-30 18:59:02',NULL),(1767,'Nautilus Sandwich Tuna in Soybean Oil 185 gm',9,'single',19,284,8,NULL,NULL,'exclusive',150,150,1,1,'8850229100126','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 19:00:42','2019-05-30 19:00:42',NULL),(1768,'Nautilus Tuna in Mayonnaise 185 gm',9,'single',19,284,8,NULL,NULL,'exclusive',150,150,1,1,'8850229100027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 19:02:05','2019-05-30 19:02:05',NULL),(1769,'Davidoff Coffee Fine Aroma 100 gm',9,'single',19,285,16,NULL,NULL,'exclusive',430,520,1,1,'4006067084263','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 19:10:43','2020-09-05 19:55:03',NULL),(1770,'Davidoff Coffee Rich Aroma 100 gm',9,'single',19,285,16,NULL,NULL,'exclusive',450,520,1,1,'4006067084188','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 19:12:59','2020-09-05 19:55:29',NULL),(1771,'Davidoff Coffee Expresso 100 gm',9,'single',19,285,16,NULL,NULL,'exclusive',430,520,1,1,'4006067061288','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 19:15:07','2020-09-05 19:54:38',NULL),(1772,'Nutcandy Wasabi Coated Green Peas 50 gm',9,'single',19,121,53,NULL,NULL,'exclusive',0,0,1,1,'8855282100595','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 20:12:36','2020-09-24 14:40:47',NULL),(1773,'No 1 Salted Green Peas 128 gm',9,'single',19,180,53,NULL,NULL,'exclusive',0,0,1,1,'8850291106071','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-30 20:27:58','2019-05-30 20:27:58',NULL),(1774,'Vitalia Green Tea with Ginseng 50 gm',9,'single',19,1,37,NULL,NULL,'exclusive',310,345,1,1,'5310099016505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-05-31 16:28:50','2019-05-31 16:28:50',NULL),(1775,'Lotte Xylitol Original 87 gm',9,'single',19,20,22,NULL,NULL,'exclusive',315,340,1,1,'8801062214792','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-01 19:20:13','2019-06-01 19:20:54',NULL),(1776,'Fanta Orange Can 320 ml',9,'single',19,6,4,NULL,NULL,'exclusive',85,135,1,1,'8888002086008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-01 19:32:42','2019-08-09 18:04:19',NULL),(1777,'Lay\'s Spanish Tomato Tango 25 gm',9,'single',19,174,14,NULL,NULL,'exclusive',25,25,1,1,'8901491503044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-04 17:24:09','2019-06-04 17:24:09',NULL),(1778,'Tropicana Twister Apple 1 lt',9,'single',19,217,24,NULL,NULL,'exclusive',0,0,1,1,'9556404120864','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 17:07:13','2019-06-15 17:07:13',NULL),(1779,'Tropicana Twister Orange Fruit Drink 1 Lt',9,'single',19,217,24,NULL,NULL,'exclusive',180,200,1,1,'9556404120840','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 17:20:35','2019-07-01 22:13:09',NULL),(1780,'IKO Assorted Oatmeal Cracker High Daily Fiber 700 gm Tin',9,'single',19,286,42,NULL,NULL,'exclusive',640,640,1,1,'9556562001777','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 18:55:19','2020-09-09 18:03:12',NULL),(1781,'IKO Sugar Fee Oat Meal Cracker Oat Bran 220 gm',9,'single',19,286,42,NULL,NULL,'exclusive',340,340,1,1,'9556562001951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:02:03','2019-06-15 19:02:03',NULL),(1782,'IKO Sugar Fee Oat Meal Crackers 9 Grains 220 gm',9,'single',19,286,42,NULL,NULL,'exclusive',340,340,1,1,'9556562001999','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:03:18','2019-06-15 19:03:18',NULL),(1783,'IKO Sugar Fee Oat Meal Cracker Pumpkin 178 gm',9,'single',19,286,42,NULL,NULL,'exclusive',230,280,1,1,'9556562001982','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:07:12','2019-06-19 01:06:06',NULL),(1784,'Khong Guan Marie Biscuit 400 gm',9,'single',19,287,5,NULL,NULL,'exclusive',280,300,1,1,'8888098200104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:10:38','2020-09-09 18:15:03',NULL),(1785,'Gatorade Lemon 515 gm',9,'single',19,288,24,NULL,NULL,'exclusive',120,170,1,1,'9556404036059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:15:56','2019-07-20 19:38:32',NULL),(1786,'Hup Seng Cream Crackers 428 gm',9,'single',19,289,42,NULL,NULL,'exclusive',280,280,1,1,'9556085302757','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:23:54','2019-06-15 19:23:54',NULL),(1787,'Julie\'s Cheese Crackers 700 gm',9,'single',19,290,42,NULL,NULL,'exclusive',600,600,1,1,'9556121000111','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:27:01','2019-06-15 19:27:01',NULL),(1788,'Foster Clark\'s Whipped Topping Mix 72 gm',9,'single',19,57,NULL,NULL,NULL,'exclusive',150,160,1,1,'5352101097287','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:40:14','2019-06-15 19:40:14',NULL),(1789,'Cadbury Oreo Chocolate Sandwich Biscuits Choco Creme Flavoured 50 gm',9,'single',19,87,5,NULL,NULL,'exclusive',25,25,1,1,'8901233022321','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 19:55:21','2019-06-15 19:55:21',NULL),(1790,'Hosen Select Gherkins Original Flavour 680 gm',9,'single',19,14,11,NULL,NULL,'exclusive',270,280,1,1,'8888192821458','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 20:23:13','2019-06-15 20:23:13',NULL),(1791,'sarowar',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',963,1070,1,0,'1791','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 20:41:03','2019-06-15 20:41:03',NULL),(1792,'Eng. A Azad',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',550,580,1,0,'1792','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-15 20:51:33','2019-06-15 20:51:33',NULL),(1794,'Amul Dark Chocolate 150 gm',9,'single',19,291,15,NULL,NULL,'exclusive',170,200,1,1,'8901262070676','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-16 17:09:04','2020-11-24 01:04:45',NULL),(1795,'Mamy Poko Pants L 9-14 (46 Pants)',9,'single',19,275,68,NULL,NULL,'exclusive',1080,1080,1,1,'8903622037350','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 00:04:34','2019-06-17 00:04:34',NULL),(1796,'Mamy Poko Pants Extra Absorb XL 12-17 kg 26 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',760,800,1,1,'8993189271694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 00:16:25','2019-07-20 15:37:14',NULL),(1797,'Fontana 100% Natural Orange Juice 1 Lt',9,'single',19,298,24,NULL,NULL,'exclusive',250,250,1,1,'5290074000616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:21:07','2019-06-17 17:22:31',NULL),(1798,'Unikai 100% Mango Nectar 1 Lt',9,'single',19,292,24,NULL,NULL,'exclusive',250,250,1,1,'6291034147319','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:31:56','2019-06-17 16:31:56',NULL),(1799,'The Juice 100% Pure Orange 1 Lt',9,'single',19,293,24,NULL,NULL,'exclusive',250,250,1,1,'5024333001096','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:37:53','2019-06-17 16:37:53',NULL),(1800,'Al Rabie Nectar Mango Nectar 1 Lt',9,'single',19,294,24,NULL,NULL,'exclusive',250,250,1,1,'6281026306008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:41:15','2019-06-17 17:26:44',NULL),(1801,'Dimes 100% Orange 1 Lt',9,'single',19,295,24,NULL,NULL,'exclusive',250,250,1,1,'8690558020142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:46:27','2019-06-17 16:46:27',NULL),(1802,'Brille Drinks Orange 1 lt',9,'single',19,296,24,NULL,NULL,'exclusive',250,250,1,1,'6950943577852','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:51:14','2019-06-17 16:51:14',NULL),(1803,'Sunfresh Orange Juice Drink 1 Lt',9,'single',19,297,24,NULL,NULL,'exclusive',250,250,1,1,'8888265001404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:56:04','2019-06-17 16:56:04',NULL),(1804,'Al Rabie Premium Nectar Orange & Peach 1 Lt',9,'single',19,294,24,NULL,NULL,'exclusive',250,250,1,1,'6281026310609','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 16:58:26','2019-06-17 16:58:26',NULL),(1805,'Al Rabie Juice Apple 1 Lt',9,'single',19,294,24,NULL,NULL,'exclusive',250,250,1,1,'6281026305209','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:00:22','2019-06-17 17:00:22',NULL),(1806,'Al Rabie Juice Orange 1 lt',9,'single',19,294,24,NULL,NULL,'exclusive',250,250,1,1,'6281026305001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:03:52','2019-06-17 17:03:52',NULL),(1807,'Al Rabie Premium Drink Lemon & Mint 1 Lt',9,'single',19,294,24,NULL,NULL,'exclusive',250,250,1,1,'6281026311552','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:13:53','2019-06-17 17:13:53',NULL),(1808,'Unikai 100% Orange Juice 1 Lt',9,'single',19,292,24,NULL,NULL,'exclusive',250,250,1,1,'6291034147302','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:16:01','2019-06-17 17:16:01',NULL),(1809,'Al Rabie Tomato Juice 1 Lt',9,'single',19,294,NULL,NULL,NULL,'exclusive',250,250,1,1,'6281026306404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:18:58','2019-06-17 17:18:58',NULL),(1810,'Al Rabie Nectar Fruit Cocktail 1 Lt',9,'single',19,294,24,NULL,NULL,'exclusive',250,250,1,1,'6281026306206','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:20:51','2019-06-17 17:20:51',NULL),(1811,'Fontana 100% Natural Apple Juice 1 Lt',9,'single',19,298,24,NULL,NULL,'exclusive',250,250,1,1,'5290074000814','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 17:32:56','2019-06-17 17:32:56',NULL),(1812,'Cocoa Lab Chocolate 24 gm',9,'single',19,200,15,NULL,NULL,'exclusive',50,60,1,1,'100026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 19:16:53','2019-06-17 19:27:24',NULL),(1814,'Cocoa Lab Chocolate 52 gm',9,'single',19,200,15,NULL,NULL,'exclusive',180,215,1,1,'100027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 19:26:28','2019-06-17 19:26:28',NULL),(1815,'Cocoa Lab Chocolate 72 gm/52 gm',9,'single',19,200,24,NULL,NULL,'exclusive',160,215,1,1,'100028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 19:31:24','2019-06-17 20:33:20',NULL),(1816,'Crown Real Mayonnaise Fancy 946 ml',9,'single',19,299,25,NULL,NULL,'exclusive',630,660,1,1,'012656110279','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 20:38:05','2019-06-17 20:38:05',NULL),(1817,'Crown Real Mayonnaise Fancy 237 ml',9,'single',19,299,25,NULL,NULL,'exclusive',210,230,1,1,'012656110309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 20:41:19','2019-06-17 20:41:19',NULL),(1818,'Crown Peanut Butter Chunky 510 gm',9,'single',19,299,6,NULL,NULL,'exclusive',410,460,1,1,'012656707400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 20:46:46','2019-06-17 20:46:46',NULL),(1819,'Crown Peanut Butter Smooth & Creamy 340 gm',9,'single',19,299,6,NULL,NULL,'exclusive',300,350,1,1,'012656707370','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 21:00:25','2019-06-17 21:00:25',NULL),(1820,'Crown Peanut Butter Chunky 340 gm',9,'single',19,299,6,NULL,NULL,'exclusive',300,350,1,1,'012656707387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 21:34:14','2019-06-17 21:34:14',NULL),(1821,'Freshlife Adult Diaper medium (30pcs)',9,'single',19,300,68,NULL,NULL,'exclusive',1800,2150,1,1,'8697512322908','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 21:40:22','2019-06-17 21:40:22',NULL),(1823,'Freshlife Adult Diaper large (30pcs)',9,'single',19,300,68,NULL,NULL,'exclusive',2150,2550,1,1,'8697512322892','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:03:35','2019-06-17 22:03:35',NULL),(1824,'Freshmaker wet wipes fliptop (120)',9,'single',19,301,68,NULL,NULL,'exclusive',180,205,1,1,'8697817871293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:13:44','2019-06-17 22:13:44',NULL),(1825,'Happyfresh Wet Wipes Fliptop (120)',9,'single',19,302,68,NULL,NULL,'exclusive',180,205,1,1,'8697420534479','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:19:40','2019-06-17 22:19:40',NULL),(1826,'Nannys Wet Wipes 72pcs',9,'single',19,303,68,NULL,NULL,'exclusive',330,365,1,1,'5290005001538','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:23:37','2019-06-17 22:23:37',NULL),(1827,'Crown Fun Pop Extra Butter 297 gm',9,'single',19,299,58,NULL,NULL,'exclusive',200,240,1,1,'012656003656','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:30:40','2019-06-17 22:30:40',NULL),(1828,'Crown Fun Pop Butter 297 gm',9,'single',19,NULL,58,NULL,NULL,'exclusive',200,240,1,1,'012656003632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:40:51','2019-06-17 22:40:51',NULL),(1829,'Crown Fun Pop Sweet Corn 297 gm',9,'single',19,299,58,NULL,NULL,'exclusive',200,240,1,1,'012656003694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:45:10','2019-06-17 22:45:10',NULL),(1830,'Crown Fun Pop Jalapeno Butter 297 gm',9,'single',19,299,58,NULL,NULL,'exclusive',200,240,1,1,'012656003670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:51:52','2019-06-17 22:51:52',NULL),(1831,'Crown Fun Pop Natural Popcorn 297 gm',9,'single',19,299,58,NULL,NULL,'exclusive',200,240,1,1,'012656003649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 22:56:00','2019-06-17 22:56:00',NULL),(1832,'Nutkao Fantasia Di Cacao 200 gm',9,'single',19,305,51,NULL,NULL,'exclusive',280,280,1,1,'8008245002386','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:01:29','2019-06-17 23:01:29',NULL),(1833,'Nutkao Fantasia 300 gm',9,'single',19,305,51,NULL,NULL,'exclusive',500,565,1,1,'8008245000191','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:03:41','2019-06-17 23:08:06',NULL),(1834,'Nutkao Snack 52 gm',9,'single',19,305,42,NULL,NULL,'exclusive',80,90,1,1,'8008245001167','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:06:08','2019-06-17 23:06:08',NULL),(1835,'Prosperity Egg Noodle 454 gm',9,'single',19,306,27,NULL,NULL,'exclusive',190,225,1,1,'6923052620245','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:21:20','2019-06-17 23:21:20',NULL),(1836,'Prosperity Pumpkin Noodle 454 gm',9,'single',19,306,27,NULL,NULL,'exclusive',190,225,1,1,'6923052620306','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:23:36','2019-06-17 23:24:15',NULL),(1837,'Prosperity Tomato Noodle 454 gm',9,'single',19,306,27,NULL,NULL,'exclusive',190,225,1,1,'6923052620283','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:26:13','2019-06-17 23:26:13',NULL),(1838,'Prosperity Carrot Noodle 454 gm',9,'single',19,306,27,NULL,NULL,'exclusive',190,225,1,1,'6923052620290','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:28:38','2019-06-17 23:28:38',NULL),(1839,'Olivital Extra Virgin Olive Oil 1 Lt',9,'single',19,307,29,NULL,NULL,'exclusive',700,775,1,1,'8003250000846','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:34:21','2019-06-17 23:34:21',NULL),(1840,'Olivital Extra Virgin Olive Oil 5 Lt',9,'single',19,307,29,NULL,NULL,'exclusive',3300,3650,1,1,'8003250000556','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-17 23:54:07','2019-06-17 23:54:07',NULL),(1841,'Olivital Pomace Olive Oil 5 Lt',9,'single',19,307,29,NULL,NULL,'exclusive',2400,2625,1,1,'8003250000587','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 00:02:18','2019-06-18 00:02:18',NULL),(1842,'Smart Care Adult Diaper M 10 Pcs',9,'single',19,304,68,NULL,NULL,'exclusive',750,750,1,1,'100029','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 00:34:54','2019-06-18 00:34:54',NULL),(1843,'Nannys flexicare 6 junior 24pcs',9,'single',19,303,68,NULL,NULL,'exclusive',1400,1400,1,1,'5290005001309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 00:36:13','2019-06-18 00:36:13',NULL),(1845,'Nannys flexicare NB 44pcs',9,'single',19,303,68,NULL,NULL,'exclusive',1255,1255,1,0,'5290005000852','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 00:38:13','2019-06-18 00:38:13',NULL),(1846,'Smart Care Adult Diaper L 10 Pcs',9,'single',19,304,68,NULL,NULL,'exclusive',800,800,1,1,'100030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 00:38:21','2019-06-18 00:38:21',NULL),(1847,'Nannys Flexicare Diaper 8-18 kg (46 Pcs)',9,'single',19,303,68,NULL,NULL,'exclusive',1615,1615,1,1,'5290005001514','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 00:57:00','2019-06-18 00:57:00',NULL),(1848,'Arla Danish White 500gm',9,'single',19,211,13,NULL,NULL,'exclusive',385,400,1,1,'5760466799928','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 18:54:47','2019-06-18 18:55:14',NULL),(1849,'Emmi Semi Skimmed milk',9,'single',19,308,26,NULL,NULL,'exclusive',265,280,1,1,'7610900012237','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 18:58:43','2019-06-18 18:58:43',NULL),(1850,'Emmi Whole Milk 1lit',9,'single',19,308,26,NULL,NULL,'exclusive',265,280,1,1,'7610900002900','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:01:45','2019-06-18 19:01:45',NULL),(1851,'Wang-Fu Pure Tahini 350 gm',9,'single',19,309,31,NULL,NULL,'exclusive',480,480,1,1,'888645431951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:25:10','2019-06-18 19:25:10',NULL),(1852,'Devondale Moo Chocolate Milk 200 ml',9,'single',19,236,26,NULL,NULL,'exclusive',130,150,1,1,'9300639601656','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:28:31','2019-06-18 19:28:31',NULL),(1853,'Pringles Cheddar Cheese 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,250,1,1,'038000138577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:33:14','2019-06-18 19:33:14',NULL),(1854,'Nescafe Gold 200 gm',9,'single',19,138,16,NULL,NULL,'exclusive',700,720,1,1,'7613036305846','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:35:45','2019-08-25 20:43:38',NULL),(1855,'Kitkat Chunky Cocoa Plan 160 gm',9,'single',19,63,15,NULL,NULL,'exclusive',250,280,1,1,'7613034968340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:40:16','2019-06-18 19:40:16',NULL),(1856,'Foster Clark\'s Custerd Powder',9,'single',19,57,51,NULL,NULL,'exclusive',80,85,1,1,'5352101007040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:41:50','2019-06-18 19:41:50',NULL),(1857,'Toblenone Tiny Swiss White Chocolate 200gm',9,'single',19,116,15,NULL,NULL,'exclusive',365,495,1,1,'7622210392565','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:47:13','2019-06-18 19:47:13',NULL),(1858,'CHIKO Eclair Hazelnut 400gm',9,'single',19,129,15,NULL,NULL,'exclusive',450,450,1,1,'9501034774093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:48:54','2019-06-18 19:48:54',NULL),(1859,'Foster Clark\'s Creme Caramel 21gm',9,'single',19,57,51,NULL,NULL,'exclusive',70,70,1,1,'5352101422614','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:49:18','2019-06-18 19:49:18',NULL),(1860,'Kopico Cofffe Candy 150 gm',9,'single',19,100,15,NULL,NULL,'exclusive',75,90,1,1,'8996001320051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:51:12','2019-06-18 19:51:12',NULL),(1861,'Daily Fresh Love Palm',9,'single',19,178,43,NULL,NULL,'exclusive',155,175,1,1,'8095','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 19:55:30','2019-06-18 19:55:30',NULL),(1862,'Foster Clark\'s Lemon Essence 28ml',9,'single',19,57,51,NULL,NULL,'exclusive',55,60,1,1,'5352101560781','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:11:46','2019-06-18 21:11:46',NULL),(1863,'Meiji Hello Panda Strawberry 260gm',9,'single',19,72,5,NULL,NULL,'exclusive',450,485,1,1,'795249091369','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:19:46','2019-06-18 21:19:46',NULL),(1864,'Meiji Hello Panda Milk 260gm',9,'single',19,72,5,NULL,NULL,'exclusive',450,485,1,1,'008077102238','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:22:20','2019-06-18 21:22:20',NULL),(1865,'Meiji Hello Panda Assortment 260gm',9,'single',19,72,5,NULL,NULL,'exclusive',450,485,1,1,'8888077800455','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:24:58','2019-06-18 21:24:58',NULL),(1866,'Umami Sweet Chili Sauce 300ml',9,'single',19,74,32,NULL,NULL,'exclusive',145,155,1,1,'8850534003112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:30:06','2019-06-18 21:30:06',NULL),(1867,'Al-Seedawi Eclairs Chocolate 300gm',9,'single',19,310,15,NULL,NULL,'exclusive',330,400,1,1,'6271028081621','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:54:16','2019-06-18 21:54:16',NULL),(1868,'Al-Seedawi Eclairs milk Chocolate 300gm',9,'single',19,310,15,NULL,NULL,'exclusive',330,400,1,1,'6271028081874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:55:59','2019-06-18 21:55:59',NULL),(1869,'Al-Seedawi Milco Toffee - 400gm',9,'single',19,310,15,NULL,NULL,'exclusive',400,485,1,1,'6271028081119','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 21:58:19','2019-06-18 21:58:19',NULL),(1870,'Al-Seedawi Fruita Toffee 400gm',9,'single',19,310,15,NULL,NULL,'exclusive',400,450,1,1,'6271028081447','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:00:00','2019-06-18 22:00:00',NULL),(1871,'Al-Seedawi Choco drops 400gm',9,'single',19,310,15,NULL,NULL,'exclusive',400,485,1,1,'6271028080600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:01:15','2019-06-18 22:01:15',NULL),(1872,'Al-Seedawi Fruita Toffee 150gm',9,'single',19,310,15,NULL,NULL,'exclusive',150,180,1,1,'6271028085827','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:02:22','2019-06-18 22:02:22',NULL),(1873,'Al-Seedawi Eclairs Love box',9,'single',19,310,15,NULL,NULL,'exclusive',340,450,1,1,'6271028085841','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:05:57','2019-06-18 22:05:57',NULL),(1874,'Al-Seedawi Eclairs Milk Box',9,'single',19,310,15,NULL,NULL,'exclusive',600,700,1,1,'6271028085834','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:07:47','2019-06-18 22:07:47',NULL),(1875,'Al-Seedawi Happy pop 1100gm',9,'single',19,310,15,NULL,NULL,'exclusive',780,950,1,1,'6271028080525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:09:22','2019-06-18 22:09:22',NULL),(1876,'Al-Seedawi Happy pop max gum 960gm',9,'single',19,NULL,15,NULL,NULL,'exclusive',660,800,1,1,'6271028080518','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-18 22:12:28','2019-06-18 22:12:28',NULL),(1878,'Pringles BBQ 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',200,250,1,1,'038000183713','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 16:36:05','2019-08-06 19:51:04',NULL),(1879,'Pringles Jalapeno Potato Chips 158 gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,250,1,1,'038000138874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 16:40:30','2019-06-20 16:40:30',NULL),(1880,'Pringles Loaded Baked Potato Chips 150gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,250,1,1,'038000138898','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 16:43:05','2019-06-20 16:43:05',NULL),(1881,'Nescafe Original (3 in 1) 150gm',9,'single',19,63,16,NULL,NULL,'exclusive',95,95,1,1,'8941100293584','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 17:54:21','2019-06-20 17:54:21',NULL),(1882,'Nestle Cerelac Rice & Carrot with chicken 350gm',9,'single',19,63,64,NULL,NULL,'exclusive',350,350,1,1,'8941100294772','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 17:59:53','2019-06-20 17:59:53',NULL),(1883,'Nestle Cerelac Whea & Vegitables With Chicken 400gm',9,'single',19,63,64,NULL,NULL,'exclusive',400,400,1,1,'8941100293812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 18:12:45','2019-06-20 18:12:45',NULL),(1884,'Vitalia Crunchy muesli with cranberry 600g',9,'single',19,1,1,NULL,NULL,'exclusive',520,580,1,1,'5310099003208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 19:47:38','2019-06-20 19:47:38',NULL),(1885,'Vitalia Sesame Seeds Integral 100gm',9,'single',19,1,2,NULL,NULL,'exclusive',140,160,1,1,'5319990149190','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 19:58:36','2019-06-20 19:58:36',NULL),(1886,'Vitalia Dried Cranberry 100gm',9,'single',19,NULL,76,NULL,NULL,'exclusive',375,415,1,1,'5310099002188','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:03:28','2019-06-21 18:35:18',NULL),(1887,'Vitalia Dried Papaya 100gm',9,'single',19,1,76,NULL,NULL,'exclusive',210,235,1,1,'5310099000313','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:06:58','2019-06-21 18:34:45',NULL),(1888,'Vitalia Dried Pineapple 100gm',9,'single',19,1,76,NULL,NULL,'exclusive',180,200,1,1,'5310099000290','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:09:10','2019-06-20 20:24:01',NULL),(1889,'Vitalia Crunchy Muesli With Blackberry & Raspberry 375 gm',9,'single',19,1,1,NULL,NULL,'exclusive',380,425,1,1,'5310099000962','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:19:18','2019-06-20 20:19:18',NULL),(1890,'Vitalia Crunchy Muesli with Banana & Chocolate 375 gm',9,'single',19,1,1,NULL,NULL,'exclusive',380,425,1,1,'5310099000986','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:22:27','2019-06-20 20:22:27',NULL),(1891,'Vitalia Flax Seed 100gm',9,'single',19,1,2,NULL,NULL,'exclusive',90,100,1,0,'5319990149619','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:22:41','2019-06-21 18:19:22',NULL),(1892,'Vitalia Crunchy Muesli With Apple & Hazelnut 375 gm',9,'single',19,1,1,NULL,NULL,'exclusive',380,425,1,1,'5310099000979','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:27:21','2019-06-20 20:27:21',NULL),(1893,'Vitalia Crunchy Muesli 30% Less Calories 250 gm',9,'single',19,1,1,NULL,NULL,'exclusive',340,380,1,1,'5310099005349','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:45:48','2019-06-20 20:45:48',NULL),(1894,'Vitalia Multigrain Flakes With Chocolate and Chia seed 300 gm',9,'single',19,1,NULL,NULL,NULL,'exclusive',380,420,1,1,'5310099009903','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:49:17','2019-06-20 20:49:17',NULL),(1895,'Vitalia Multigrain Flakes With 30% Fruits 300 g',9,'single',19,1,1,NULL,NULL,'exclusive',380,426,1,1,'5310099007398','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 20:53:09','2019-06-20 20:53:09',NULL),(1896,'Vitalia Granola Muesli With Honey & Almond 500 gm',9,'single',19,1,1,NULL,NULL,'exclusive',600,670,1,1,'5310099010787','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:02:27','2019-06-20 21:02:27',NULL),(1897,'Vitalia Take Away Muesli Granola With Banana & Chocolate  90 gm',9,'single',19,1,1,NULL,NULL,'exclusive',180,200,1,1,'5310099010602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:15:22','2019-06-20 21:20:37',NULL),(1898,'Vitalia Take Away Muesli Granola With Walnuts, Hazelnuts & Almonds 90 gm',9,'single',19,1,1,NULL,NULL,'exclusive',180,200,1,1,'5310099010640','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:19:44','2019-06-20 21:19:44',NULL),(1899,'Vitalia Take Away Muesli Chocolate 110 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5310099010619','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:26:17','2019-06-20 21:31:46',NULL),(1900,'Vitalia Take Away Instant Oatmeal  Raspberry 85 gm',9,'single',19,1,1,NULL,NULL,'exclusive',170,190,1,1,'5310099010664','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:31:05','2019-06-20 21:31:05',NULL),(1901,'Vitalia Take Away Muesli Tropical Fruit 90 gm',9,'single',19,1,1,NULL,NULL,'exclusive',195,215,1,1,'5310099012477','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:35:08','2019-06-20 21:35:08',NULL),(1902,'Vitalia Take Away Muesli Slimline 90 gm',9,'single',19,1,1,NULL,NULL,'exclusive',180,200,1,1,'5310099012484','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:37:51','2019-06-20 21:37:51',NULL),(1903,'Vitalia Go Nutri Cornflakes No Added Sugar 250 gm',9,'single',19,1,1,NULL,NULL,'exclusive',450,500,1,1,'5310099009880','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:43:09','2019-07-13 22:20:43',NULL),(1904,'Vitalia Barley flakes 250 gm',9,'single',19,1,1,NULL,NULL,'exclusive',200,220,1,1,'5310099015300','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:48:09','2019-06-20 21:48:09',NULL),(1905,'Vitalia Puffed Wheat Sweetened With Fructose 85 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5310099000610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:54:37','2019-06-20 21:54:37',NULL),(1906,'Vitalia Puffed Rice Sweetened With Fructose 135 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5310099000597','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 21:57:21','2019-06-20 21:57:21',NULL),(1907,'Vitalia Puffed Rye Sweetened With Fructose 100 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5310099000719','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:00:07','2019-06-20 22:00:07',NULL),(1908,'Vitalia Puffed Barley Sweetened With Fructose 125 gm',9,'single',19,1,1,NULL,NULL,'exclusive',150,165,1,1,'5310099000917','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:02:53','2019-06-20 22:15:27',NULL),(1909,'Vitalia Puffed Barly Sweetened With Fructose 140 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5310099000603','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:05:41','2019-06-20 22:05:41',NULL),(1910,'Vitalia Puffed 4 Grains With Fructose 100 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5310099000993','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:08:32','2019-06-20 22:08:32',NULL),(1911,'Vitalia Puffed Rice Neutral 100 gm',9,'single',19,1,1,NULL,NULL,'exclusive',210,235,1,1,'5319990149831','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:12:36','2019-06-20 22:12:36',NULL),(1912,'Vitalia Corn Cakes 130 gm',9,'single',19,1,1,NULL,NULL,'exclusive',200,225,1,1,'5310099010367','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:20:30','2019-06-20 22:20:30',NULL),(1913,'Vitalia Multigrain cakes 100 gm',9,'single',19,1,1,NULL,NULL,'exclusive',200,225,1,1,'5310099010350','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:24:06','2019-06-20 22:24:06',NULL),(1914,'Vitalia Rice cakes 100 gm',9,'single',19,1,1,NULL,NULL,'exclusive',190,215,1,1,'5310099010428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:27:27','2019-06-20 22:27:27',NULL),(1915,'Vitalia Smoothie Antioxidant Berry 150 gm',9,'single',19,1,52,NULL,NULL,'exclusive',420,465,1,1,'5310099018578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:35:56','2019-06-20 22:35:56',NULL),(1916,'Vitalia Smoothie Slim & Diet 150 gm',9,'single',19,1,52,NULL,NULL,'exclusive',420,465,1,1,'5310099018592','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:38:22','2019-06-20 22:38:22',NULL),(1917,'Vitalia Smoothie Immuno Boost 150 gm',9,'single',19,1,52,NULL,NULL,'exclusive',420,465,1,1,'5310099018615','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:41:33','2019-06-20 22:41:33',NULL),(1918,'Vitalia Smoothie Green Detox 150 gm',9,'single',19,1,52,NULL,NULL,'exclusive',420,465,1,1,'5310099018639','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:44:06','2019-06-20 22:44:06',NULL),(1919,'Vitalia Smoothie Cocoa Pea Protein 150 gm',9,'single',19,NULL,52,NULL,NULL,'exclusive',420,465,1,1,'5310099018653','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:46:28','2019-06-20 22:46:28',NULL),(1920,'Vitalia RAW Bar With Date, Almond, Chia & Cocoa 30 gm',9,'single',19,1,3,NULL,NULL,'exclusive',120,135,1,1,'8464218018363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 22:56:24','2019-06-20 22:56:24',NULL),(1921,'Vitalia Raw Bar Date,Almond,Chia & Cocoa 30 gm',9,'single',19,1,3,NULL,NULL,'exclusive',120,135,1,1,'5310099018363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:00:00','2019-06-20 23:00:00',NULL),(1922,'Vitalia Raw Bar Fig,Date,Cashew & Amaranth 30 gm',9,'single',19,1,3,NULL,NULL,'exclusive',120,135,1,1,'5310099018370','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:03:15','2019-06-20 23:03:15',NULL),(1923,'Vitalia Raw Bar Date,Walnut,Strawberry & Quinoa 30 gm',9,'single',19,1,3,NULL,NULL,'exclusive',120,135,1,1,'5310099018387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:06:06','2019-06-20 23:06:06',NULL),(1924,'Vitalia Muesli Bars Cranberry 180 gm',9,'single',19,1,3,NULL,NULL,'exclusive',225,250,1,1,'5310099004748','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:09:31','2019-06-20 23:09:31',NULL),(1925,'Vitalia Go Nutri  Muesli Bar  Banana 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,40,1,1,'5310099009156','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:13:13','2020-01-20 17:20:06',NULL),(1926,'Vitalia Go Nutri Muesli Bar Apricot & Cocoa Coating 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',45,50,1,1,'5310099009811','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:18:12','2019-06-20 23:18:12',NULL),(1927,'Vitalia Go Nutri Muesli Bar With Apple 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',45,50,1,1,'5310099012217','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:21:34','2019-06-20 23:21:34',NULL),(1928,'Vitalia Go Nutri Muesli Bar With Cranberry & White Cream 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,40,1,1,'5310099016642','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:25:10','2019-06-20 23:25:10',NULL),(1929,'Vitalia Go Nutri Muesli Bar With Strawberry & White Cream 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,40,1,1,'5310099016680','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:32:20','2019-06-20 23:32:20',NULL),(1930,'Vitalia Go Nutri Muesli Bar With Raisins & Cocoa 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,40,1,1,'5310099012200','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:43:25','2019-06-20 23:43:25',NULL),(1931,'Vitalia Go Nutri Muesli Bar With Black Berry & White Cream 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',35,40,1,1,'5310099016727','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:46:12','2019-06-20 23:46:12',NULL),(1932,'Vitalia Antioxident Bar,Orange & Dark Choco- 180 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1,'5310099005752','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-20 23:49:48','2019-06-20 23:49:48',NULL),(1933,'Vitalia Red Fruit Bar Raspberry & Strawberry 35 gm',9,'single',19,1,3,NULL,NULL,'exclusive',65,70,1,1,'5310099005684','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:11:08','2019-06-21 00:11:08',NULL),(1934,'Vitalia Red Fruit Bar Raspberry & Strawberry 210 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1,'5310099005745','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:14:32','2019-06-21 00:14:32',NULL),(1935,'Vitalia Slim & Beauty bar 180 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1,'5310099005769','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:19:15','2019-06-21 00:19:15',NULL),(1936,'Vitalia Coffee & Nuts Bar 30 gm',9,'single',19,1,3,NULL,NULL,'exclusive',65,70,1,1,'5310099012033','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:22:37','2019-06-21 00:22:37',NULL),(1937,'Vitalia Coffee & Nuts Bar 180 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1,'5310099012064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:24:53','2019-06-21 00:24:53',NULL),(1938,'Vitalia Cranberry Plum Bar 35 gm',9,'single',19,1,3,NULL,NULL,'exclusive',65,70,1,1,'5310099016772','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:31:57','2019-06-21 00:31:57',NULL),(1939,'Vitalia Cranberry Plum Bar 210 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1279,'5310099016765','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:34:18','2019-06-21 00:34:18',NULL),(1940,'Vitalia Multigrain Bars With Strawberry & Pomegranate 150 gm',9,'single',19,1,3,NULL,NULL,'exclusive',280,310,1,1,'5310099007350','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:52:46','2019-06-21 00:52:46',NULL),(1941,'Vitalia Multigrain Bar With Strawberry & Pomegranate 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',55,60,1,1,'5310099007336','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 00:59:29','2019-06-21 00:59:29',NULL),(1942,'Vitalia Multigrain Flake Bars With Chocolate 150gm',9,'single',19,1,3,NULL,NULL,'exclusive',280,310,1,1,'5310099007343','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 01:01:40','2019-06-21 01:01:40',NULL),(1943,'Vitalia Multigrain Bar Chocolate 25 gm',9,'single',19,1,3,NULL,NULL,'exclusive',55,60,1,1,'5310099007329','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 01:04:31','2019-06-21 01:04:31',NULL),(1944,'Vitalia Bites Mini Granola Bars Vanilla & Dark Chocolate 144 gm',9,'single',19,1,3,NULL,NULL,'exclusive',375,715,1,1,'5310099009149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 01:08:22','2019-06-21 01:08:22',NULL),(1945,'Vitalia Bites Mini Muesli Bars Coconut & Dark Chocolate 144 gm',9,'single',19,1,3,NULL,NULL,'exclusive',375,715,1,1,'5310099009101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:16:29','2019-06-21 15:16:29',NULL),(1946,'Vitalia Sport Bar Dark Chocolate Coated 60 gm',9,'single',19,1,3,NULL,NULL,'exclusive',300,335,1,1,'5310099010244','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:19:00','2019-06-21 15:24:02',NULL),(1947,'Vitalia Sport Bar Milk Chocolate & Peanuts 60 gm',9,'single',19,1,3,NULL,NULL,'exclusive',300,335,1,1,'5310099011692','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:27:06','2019-06-21 15:27:06',NULL),(1948,'Vitalia Sport Bar White Chocolate & Pineapple 60 gm',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',300,335,1,1,'1948','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:29:14','2019-06-21 15:29:14',NULL),(1949,'Vitalia Pingvi Crunchy Cereal Bar Coated With Milk Chocolate 20 gm',9,'single',19,1,3,NULL,NULL,'exclusive',65,70,1,1,'5310099013634','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:34:58','2019-06-21 15:34:58',NULL),(1951,'Vitalia Pingvi Crunchy Cereal Bar Coated With White Chocolate 20 gm',9,'single',19,1,3,NULL,NULL,'exclusive',65,70,1,1,'5310099013627','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:39:12','2019-06-21 15:39:12',NULL),(1952,'Vitalia Pingvi Crunchy Cereal Bar Coated With Milk Chocolate 120 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1,'5310099013757','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:44:26','2019-06-21 15:44:26',NULL),(1953,'Vitalia Pingvi Crunchy Cereal Bar Coated With White Chocolate 120 gm',9,'single',19,1,3,NULL,NULL,'exclusive',345,385,1,1,'5310099013740','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:46:45','2019-06-21 15:46:45',NULL),(1954,'Vitalia Roasted Soya Beans 75gm',9,'single',19,1,2,NULL,NULL,'exclusive',105,120,1,0,'5310099000931','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:49:58','2019-06-21 15:49:58',NULL),(1955,'Vitalia Go Nutri Instant Oat Meal With Cranberry & Quinoa 60 gm',9,'single',19,1,28,NULL,NULL,'exclusive',70,80,1,1,'5310099017960','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:51:16','2020-01-20 17:38:37',NULL),(1956,'Vitalia Go Nutri Oat Meal Chia & Caramel 60gm',9,'single',19,1,28,NULL,NULL,'exclusive',70,80,1,1,'5310099017977','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:52:53','2019-06-21 16:19:17',NULL),(1957,'Vitalia White Chocolate & Pineapple 60 gm',9,'single',19,1,3,NULL,NULL,'exclusive',300,335,1,1,'5310099010237','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:55:40','2019-06-21 15:55:40',NULL),(1958,'Vitalia Go Nutri Oat Meal Banna,Chocolate & Quina 60gmgm',9,'single',19,1,28,NULL,NULL,'exclusive',70,80,1,1,'5310099017984','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 15:56:31','2019-06-21 15:56:31',NULL),(1959,'Vitalia Gluten Free oat meal apple & Cinnamon 60gm',9,'single',19,1,28,NULL,NULL,'exclusive',120,135,1,1,'5310099018752','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:00:09','2019-06-21 16:00:09',NULL),(1960,'Vitalia Gluten Free Oat Meal Strawberry 60gm',9,'single',19,1,28,NULL,NULL,'exclusive',120,135,1,1,'5310099018738','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:04:10','2019-06-21 16:04:10',NULL),(1961,'Vitalia Pumpkin Seed 75gm',9,'single',19,1,2,NULL,NULL,'exclusive',265,295,1,1,'5310099000948','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:06:22','2019-06-21 16:06:22',NULL),(1962,'Vitalia Sunfloer Sedd 100gm',9,'single',19,1,2,NULL,NULL,'exclusive',130,145,1,1,'5319990149633','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:08:25','2019-06-21 16:08:25',NULL),(1963,'Vitalia Energo Mix 50gm',9,'single',19,1,2,NULL,NULL,'exclusive',120,135,1,1,'5310099000399','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:10:57','2019-06-21 16:10:57',NULL),(1964,'Vitalia Slim & Fit Tea 50gm',9,'single',19,1,37,NULL,NULL,'exclusive',320,355,1,1,'5310099016543','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:15:48','2019-06-21 16:15:48',NULL),(1965,'Vitalia Cranberry Tea 100gm',9,'single',19,1,37,NULL,NULL,'exclusive',420,465,1,1,'5310099004502','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:18:10','2019-06-25 00:06:09',NULL),(1966,'Vitalia gluten Free With Pea Protein Crackers 90gm',9,'single',19,1,42,NULL,NULL,'exclusive',145,160,1,1,'5310099018677','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:28:59','2019-06-21 16:28:59',NULL),(1967,'Vitalia Salty Oat Crakers 2go With Basi & Seeds 150gm',9,'single',19,1,42,NULL,NULL,'exclusive',180,200,1,1,'5310099011722','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:33:16','2019-06-21 16:33:16',NULL),(1968,'Vitalia Salty Oat Crakers 2go With Mixed Vegetables & Pumpkin Seeds 150gm',9,'single',19,1,42,NULL,NULL,'exclusive',180,200,1,1,'5310099008845','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:35:35','2019-06-21 16:35:35',NULL),(1969,'Lotte Choco Pie 6 Packs 168 gm',9,'single',19,20,73,NULL,NULL,'exclusive',150,180,1,1,'8901123005397','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:37:14','2019-06-21 16:37:14',NULL),(1970,'Vitalia Salty Oat Crakers 2go With Sesame Seeds & Oregano 150gm',9,'single',19,1,42,NULL,NULL,'exclusive',180,200,1,1,'5310099008852','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:37:32','2019-06-21 16:37:32',NULL),(1971,'Vitalia Sovita Soy Drink Powder Vanilla 300gm',9,'single',19,1,52,NULL,NULL,'exclusive',415,5319990149688,1,1,'5319990149688','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 16:47:36','2019-06-21 16:47:36',NULL),(1972,'Vitalia Flax Seed Ground 180gm',9,'single',19,1,2,NULL,NULL,'exclusive',240,265,1,1,'5310099006902','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:04:59','2019-06-21 18:04:59',NULL),(1973,'Vitalia Go Nutri Mini Oat Crakers  Crunchy & Tasty 100gm',9,'single',19,1,42,NULL,NULL,'exclusive',130,145,1,1,'5310099011760','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:10:52','2019-06-21 18:10:52',NULL),(1974,'Vitalia Gluten Free Corn Penne Rigate Pasta 250gm',9,'single',19,1,30,NULL,NULL,'exclusive',325,360,1,1,'5310099014808','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:25:27','2019-06-21 18:25:27',NULL),(1975,'Vitalia Pumpkin Seed 50 gm',9,'single',19,1,2,NULL,NULL,'exclusive',240,265,1,1,'5310099000412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:25:41','2019-06-21 18:25:41',NULL),(1976,'Vitalia Gluten Free Corn Fusilli Pasta 250gm',9,'single',19,1,30,NULL,NULL,'exclusive',325,360,1,1,'5310099014792','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:27:56','2019-06-21 18:27:56',NULL),(1977,'Vitalia Gluten Free Corn Spaghetti pasta 250gm',9,'single',19,1,30,NULL,NULL,'exclusive',325,360,1,1,'5310099014815','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:29:37','2019-06-21 18:29:37',NULL),(1978,'Vitalia Sovita Soy Drink Powder 9 Vitamins 300gm',9,'single',19,1,52,NULL,NULL,'exclusive',415,465,1,1,'5319990149466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:32:19','2019-06-21 18:32:19',NULL),(1979,'Vitalia Sovita Soy Drink Powder Natural 300gm',9,'single',19,1,52,NULL,NULL,'exclusive',415,465,1,1,'5319990149459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:34:06','2019-06-21 18:34:06',NULL),(1980,'Vitalia Sport Muesli Chocolate & Coconut 350gm',9,'single',19,1,1,NULL,NULL,'exclusive',665,735,1,1,'5310099010381','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:37:34','2019-06-21 18:37:34',NULL),(1981,'Vitalia Diet Jam Extra Blackberry 370 gm',9,'single',19,1,23,NULL,NULL,'exclusive',375,415,1,1,'5319990149787','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:40:36','2019-06-21 18:40:36',NULL),(1982,'Vitalia Glute Free Soup Mix vegetables 100gm',9,'single',19,1,63,NULL,NULL,'exclusive',240,265,1,1,'5310099016048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:42:17','2019-06-21 18:42:17',NULL),(1983,'Vitalia Gluten  Soup Seeds 100gm',9,'single',19,1,63,NULL,NULL,'exclusive',240,265,1,1,'5310099016062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:45:01','2019-06-21 18:45:01',NULL),(1984,'Vitalia Jam Plum Extra With Stevia 230 gm',9,'single',19,1,23,NULL,NULL,'exclusive',300,335,1,1,'5310099009491','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:45:28','2019-06-21 18:45:28',NULL),(1985,'Vitalia Organic Coconut Oil 370ml',9,'single',19,1,29,NULL,NULL,'exclusive',1260,1400,1,1,'5310099013160','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:49:28','2019-06-21 18:49:28',NULL),(1986,'Vitalia Sweet Stevia 100 gm',9,'single',19,1,35,NULL,NULL,'exclusive',415,465,1,1,'5310099008364','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:52:44','2019-06-21 18:52:44',NULL),(1987,'Vitalia Cocomut Milk Powder 80gm',9,'single',19,1,26,NULL,NULL,'exclusive',540,600,1,1,'5310099016024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:54:04','2019-06-21 18:54:04',NULL),(1988,'Vitalia O rganic Almond Milk Powder 80gm',9,'single',19,1,26,NULL,NULL,'exclusive',720,800,1,1,'5310099016000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 18:55:59','2019-06-21 18:55:59',NULL),(1989,'Vitalia Granola Muesli With Nuts 500 gm',9,'single',19,1,1,NULL,NULL,'exclusive',600,670,1,1,'5310099010770','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 19:48:46','2019-06-21 20:17:58',NULL),(1990,'Hosen Gingko Nuts Boiled & Shelled 397 gm',9,'single',19,14,11,NULL,NULL,'exclusive',160,190,1,1,'8888192821106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 21:10:25','2019-06-21 21:10:25',NULL),(1991,'Mili Green Peas 397 gm',9,'single',19,311,11,NULL,NULL,'exclusive',70,80,1,1,'8888140031250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 21:20:16','2019-06-21 21:20:16',NULL),(1992,'Perrier Water 330 ml',9,'single',19,25,40,NULL,NULL,'exclusive',110,125,1,1,'7613035477834','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 21:34:20','2019-06-21 21:34:20',NULL),(1993,'Multi Grain Cheerios 1.5 kg (Gluten Free)',9,'single',19,312,21,NULL,NULL,'exclusive',1160,1290,1,1,'016000401051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 22:09:16','2019-06-21 22:16:56',NULL),(1994,'Cheerios Honey Nut 1 kg (Gluten Free)',9,'single',19,312,21,NULL,NULL,'exclusive',1250,1390,1,1,'016000401068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 22:12:22','2019-06-21 22:12:22',NULL),(1995,'Lucky Charms Gluten Free 1.3 kg',9,'single',19,312,21,NULL,NULL,'exclusive',1160,1290,1,1,'016000438194','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 22:16:14','2019-06-21 22:16:14',NULL),(1996,'Cheerios 100% Whole Grain Oats Gluten Free 1.1 kg',9,'single',19,267,21,NULL,NULL,'exclusive',1160,1290,1,1,'016000435094','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-21 22:19:42','2019-06-21 22:19:42',NULL),(1997,'Act ii Magic Butter Flavour 30gm',9,'single',19,189,58,NULL,NULL,'exclusive',20,20,1,1,'8901512540805','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 16:39:11','2019-06-22 16:39:11',NULL),(1998,'Act ii Chilli Surprise Flavour 30gm',9,'single',19,189,58,NULL,NULL,'exclusive',20,20,1,1,'8901512540409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 16:43:44','2019-06-22 16:43:44',NULL),(1999,'Act ii Butter Lovers Flavour 33gm',9,'single',19,189,58,NULL,NULL,'exclusive',45,45,1,1,'8901512507501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 16:51:07','2019-06-22 16:51:07',NULL),(2000,'Act ii Natural flavour popcorn 33gm',9,'single',19,189,58,NULL,NULL,'exclusive',45,45,1,1,'8901512507709','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 16:53:52','2019-06-22 16:53:52',NULL),(2001,'Pediasure Cookies & Cream Flavour  Combo pac',9,'single',19,313,59,NULL,NULL,'exclusive',740,740,1,1,'123456','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 18:06:26','2019-06-22 18:06:26',NULL),(2002,'Good day Cappuccino Box 750gm',9,'single',19,314,16,NULL,NULL,'exclusive',850,900,1,1,'8991002103771','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 19:53:31','2020-08-24 20:14:09',NULL),(2003,'Good day Coffee Freeze Box 300gm',9,'single',19,314,16,NULL,NULL,'exclusive',0,0,1,1,'8991002103740','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 19:55:56','2019-06-22 19:55:56',NULL),(2004,'Kapalapi Grande White Bag 400gm',9,'single',19,314,16,NULL,NULL,'exclusive',0,0,1,1,'8991002115156','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-22 19:57:54','2019-06-22 19:57:54',NULL),(2005,'Ramen Hot  Stir Fried Noodle Chicken Flavour 700gm',9,'single',19,279,27,NULL,NULL,'exclusive',630,650,1,1,'8801073140578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:21:41','2020-09-05 19:57:34',NULL),(2006,'Shoon Fatt Lavish Vegitable Crakers 200gm',9,'single',19,315,42,NULL,NULL,'exclusive',250,265,1,1,'9556184200275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:26:08','2019-06-23 01:26:08',NULL),(2007,'Shoon Fatt light Treat Cream Crakers Special 200gm',9,'single',19,315,42,NULL,NULL,'exclusive',250,265,1,1,'9556184200312','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:28:49','2019-06-23 01:28:49',NULL),(2008,'Tays Bakers Nitchi Premium Wafer Stick Cappuccino 330gm',9,'single',19,316,55,NULL,NULL,'exclusive',375,385,1,1,'8994391012075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:33:15','2019-06-23 01:33:15',NULL),(2009,'Hosen Honey 400gm',9,'single',19,14,56,NULL,NULL,'exclusive',270,285,1,1,'8888192901884','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:41:00','2019-06-23 01:41:00',NULL),(2010,'Dano Sterilized Cream 170gm',9,'single',19,239,51,NULL,NULL,'exclusive',85,95,1,1,'5711953012648','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:44:40','2020-06-24 16:17:34',NULL),(2011,'Cadburry Milk Chocolate Spread 700gm',9,'single',19,129,15,NULL,NULL,'exclusive',650,680,1,1,'5060391620879','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:48:26','2019-06-23 01:48:26',NULL),(2012,'Seedless Red Plum 130gm',9,'single',19,317,76,NULL,NULL,'exclusive',125,135,1,1,'6947593103838','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 01:51:09','2019-06-23 01:51:46',NULL),(2013,'Doritos Spicy Nacho 31.8gm',9,'single',19,194,14,NULL,NULL,'exclusive',85,90,1,1,'028400003568','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 19:44:47','2019-06-23 19:44:47',NULL),(2014,'Doritos Nacho Cheese 31.8gm',9,'single',19,194,14,NULL,NULL,'exclusive',85,90,1,1,'028400019903','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 19:47:52','2019-06-23 19:47:52',NULL),(2015,'Tostitos Chunky Salsa MIld 439.4gm',9,'single',19,318,32,NULL,NULL,'exclusive',390,420,1,1,'028400055970','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 20:08:10','2019-06-23 20:08:10',NULL),(2016,'Tostitos Chunky Salsa Medium 439.4gm',9,'single',19,318,32,NULL,NULL,'exclusive',390,420,1,1,'028400055987','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 20:14:06','2019-06-23 20:14:06',NULL),(2017,'Tostitos Chunky Habanero hot salsa 439.4gm',9,'single',19,318,32,NULL,NULL,'exclusive',390,420,1,1,'028400589253','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 20:23:11','2019-06-23 20:23:11',NULL),(2018,'Tostitos  salsa con Queso Medium 425.2gm',9,'single',19,318,32,NULL,NULL,'exclusive',390,420,1,1,'028400070980','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-23 20:25:50','2019-06-23 20:25:50',NULL),(2019,'Vitalia Diet Apricot Compote',9,'single',19,1,43,NULL,NULL,'exclusive',475,535,1,1,'5310099000481','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-24 19:04:37','2019-06-24 19:04:37',NULL),(2020,'Vitalia Diet Peach compote 570gm',9,'single',19,1,43,NULL,NULL,'exclusive',475,535,1,1,'5310099000498','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-24 19:10:00','2019-06-24 19:10:00',NULL),(2021,'RUBICON GUAVA 330ML',9,'single',19,157,24,NULL,NULL,'exclusive',95,115,1,1,'5000382042006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 15:23:28','2019-06-25 15:23:28',NULL),(2022,'CADBURRY DRINKING CHOCOLATE 250GM',9,'single',19,129,15,NULL,NULL,'exclusive',220,240,1,1,'5000312000670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 15:30:08','2019-06-25 15:30:08',NULL),(2023,'NANSI ASSORTED CHOCOLATE BOX 350GM',9,'single',19,319,15,NULL,NULL,'exclusive',440,475,1,1,'8698849551832','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 15:43:23','2019-06-25 15:43:23',NULL),(2024,'NANSI LOVE BOX  MILK 450GM',9,'single',19,319,15,NULL,NULL,'exclusive',550,630,1,1,'8698849551184','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 15:46:24','2019-06-25 15:48:30',NULL),(2025,'NANSI LOVE BOX HAZELNUT 450GM',9,'single',19,319,15,NULL,NULL,'exclusive',550,630,1,1,'8698849551160','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 15:51:38','2019-06-25 15:51:38',NULL),(2026,'NANSI LOVE BOX  COCONUT  450GM',9,'single',19,319,15,NULL,NULL,'exclusive',550,630,1,1,'8698849551177','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 15:55:34','2019-06-25 15:55:34',NULL),(2027,'VIGOS COMPOUND CHOCOLATE 500GM',9,'single',19,320,15,NULL,NULL,'exclusive',680,730,1,1,'8698849550378','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:01:08','2019-06-25 16:01:08',NULL),(2028,'VIGOS MILK COMPOUND CHOCOLATE 500GM',9,'single',19,320,15,NULL,NULL,'exclusive',800,850,1,1,'8698849550460','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:14:30','2019-06-25 16:20:41',NULL),(2029,'VIGOS HAZELNUT COMPOUND CHOCOLATE 600GM',9,'single',19,320,15,NULL,NULL,'exclusive',800,850,1,1,'8698849550446','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:17:49','2019-06-25 16:17:49',NULL),(2030,'VIGOS COCONUT COMPOUND CHOCOLATE 600GM',9,'single',19,320,15,NULL,NULL,'exclusive',800,850,1,1,'8698849550453','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:23:48','2019-06-25 16:23:48',NULL),(2031,'VIGOS MODERN MILK COMPOUND CHOCOLATE 550GM',9,'single',19,320,15,NULL,NULL,'exclusive',750,800,1,1,'8698849551641','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:28:42','2019-06-25 16:28:42',NULL),(2032,'VIGOS MODERN COCONUT COMPOUND CHOCOLATE 550GM',9,'single',19,320,15,NULL,NULL,'exclusive',750,800,1,1,'8698849551634','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:41:12','2019-06-25 16:41:12',NULL),(2033,'VIGOS MODERN HAZELNUT COMPOUND CHOCOLATE 550GM',9,'single',19,320,15,NULL,NULL,'exclusive',750,800,1,1,'8698849551627','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:45:57','2019-06-25 16:45:57',NULL),(2034,'RUBICON MANGO 330ML',9,'single',19,157,24,NULL,NULL,'exclusive',95,115,1,1,'5000382041962','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 16:57:28','2019-06-25 16:57:28',NULL),(2035,'Meadow Fresh Strawberry UHT Milk 250ml',9,'single',19,230,26,NULL,NULL,'exclusive',75,90,1,1,'9415522001564','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-25 20:08:56','2019-06-25 20:08:56',NULL),(2036,'8000500257401',9,'single',19,133,22,NULL,NULL,'exclusive',0,0,1,1,'2036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:02:59','2020-02-17 23:00:24',NULL),(2037,'Kelloggs Corn Flakes 250g',9,'single',19,128,21,NULL,NULL,'exclusive',0,0,1,1,'8901499008343','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:09:16','2019-06-29 18:31:19',NULL),(2038,'Kelloggs Froot Loops 300G',9,'single',19,128,21,NULL,NULL,'exclusive',0,0,1,1,'8852756304046','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:11:08','2019-06-29 18:28:14',NULL),(2039,'Kelloggs Frosties 300gm',9,'single',19,128,21,NULL,NULL,'exclusive',0,0,1,1,'8852756304060','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:13:22','2019-06-29 18:29:30',NULL),(2040,'Kelloggs Special Red berries 500g',9,'single',19,128,21,NULL,NULL,'exclusive',0,0,1,1,'5000127521056','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:14:46','2019-06-29 18:30:22',NULL),(2041,'Pringles Sour Cream & Onion 147g',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'8886467100086','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:17:34','2020-03-09 19:36:29',NULL),(2042,'Pringles Cheesy Cheese 42G',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'8886467105814','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 18:18:52','2019-06-29 18:18:52',NULL),(2043,'Hosen Plam fruit In Syrup 565gm',9,'single',19,14,43,NULL,NULL,'exclusive',250,335,1,1,'8888192820406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:10:38','2019-06-29 19:10:38',NULL),(2044,'Hosen Mushroom Straw 425gm',9,'single',19,14,11,NULL,NULL,'exclusive',100,134,1,1,'888819281548898','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:13:44','2019-06-29 19:13:44',NULL),(2045,'Hosen Tomato Paste  400gm',9,'single',19,14,31,NULL,NULL,'exclusive',115,155,1,1,'8888192951735','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:18:48','2019-06-29 19:19:24',NULL),(2046,'Hosen Mandarin Orange In Syrup 312gm',9,'single',19,14,43,NULL,NULL,'exclusive',105,140,1,1,'8888192820680','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:22:29','2019-06-29 19:22:29',NULL),(2047,'S&W Pitted Large Ripe Olive 396gm',9,'single',19,27,49,NULL,NULL,'exclusive',112,150,1,1,'011194564407','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:25:35','2019-06-29 19:25:35',NULL),(2048,'Hosen Logan  in Syrup 565gm',9,'single',19,14,43,NULL,NULL,'exclusive',175,247,1,1,'8888192820017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:28:15','2019-06-29 19:28:15',NULL),(2049,'Del Monte Fruit Cocktail in Heavy Syrup 825gm',9,'single',19,8,43,NULL,NULL,'exclusive',235,315,1,1,'024000010920','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:32:52','2019-06-29 19:32:52',NULL),(2050,'Star Jus Orange 1 ltr',9,'single',19,98,24,NULL,NULL,'exclusive',0,0,1,1,'9555038403138','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 19:38:17','2019-06-29 19:38:17',NULL),(2051,'Rubicon Guava 1lit',9,'single',19,157,24,NULL,NULL,'exclusive',295,320,1,1,'5000382104957','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:11:04','2019-06-29 20:11:04',NULL),(2052,'Rubicon lychee Juice 1Lt',9,'single',19,157,24,NULL,NULL,'exclusive',295,320,1,1,'5000382105114','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:12:51','2019-06-29 20:12:51',NULL),(2053,'Rubicon Mango 1lit',9,'single',19,157,24,NULL,NULL,'exclusive',295,320,1,1,'5000382104872','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:35:39','2019-06-29 20:35:39',NULL),(2054,'Rubicon Pomegrante  1lit',9,'single',19,157,24,NULL,NULL,'exclusive',295,320,1,1,'5000382104971','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:37:23','2019-06-29 20:37:23',NULL),(2055,'Pure Heaven Apple Juice 1lit',9,'single',19,41,24,NULL,NULL,'exclusive',250,270,1,1,'5032619737584','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:40:25','2019-06-29 20:40:25',NULL),(2056,'Pure Heaven Mango Juice 1lit',9,'single',19,41,24,NULL,NULL,'exclusive',250,270,1,1,'5032619737546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:43:03','2019-06-29 20:43:03',NULL),(2057,'Pure Heaven Cranberry  Juice 1lit',9,'single',19,41,NULL,NULL,NULL,'exclusive',250,270,1,1,'5032619737508','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:44:18','2019-06-29 20:44:18',NULL),(2058,'Kelloggs Rice Krispies 510gm',9,'single',19,128,21,NULL,NULL,'exclusive',485,520,1,1,'5053827169981','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 20:47:11','2019-06-29 20:47:11',NULL),(2059,'Hosen Mushroom Choice Whole 425gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',50,140,1,1,'100031','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:09:16','2019-07-23 15:57:07',NULL),(2060,'Hosen Mushroom Choice Whole (SD)-850gm',9,'single',19,14,11,NULL,NULL,'exclusive',115,315,1,1,'100032','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:15:32','2019-06-29 21:15:32',NULL),(2061,'Hosen Mushroom Pieces & Stems (SD)- 425gm',9,'single',19,14,11,NULL,NULL,'exclusive',70,140,1,1,'100033','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:22:15','2019-07-09 20:51:43',NULL),(2062,'Star Jus Blackcurrant 1 Ltr',9,'single',19,98,24,NULL,NULL,'exclusive',0,0,1,1,'9555038403725','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:33:54','2019-06-29 21:33:54',NULL),(2063,'Hosen Mushroom Slice Pieces & Stems (SD) 425gm',9,'single',19,14,11,NULL,NULL,'exclusive',70,140,1,1,'100034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:35:01','2019-07-09 20:53:04',NULL),(2064,'Hosen Gingko Nuts Boiled & Shelled (SD) 397 gm',9,'single',19,14,11,NULL,NULL,'exclusive',85,190,1,1,'100035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:38:29','2019-06-29 21:38:29',NULL),(2065,'Hosen Green Peas Choice Whole (SD) -397gm',9,'single',19,14,11,NULL,NULL,'exclusive',45,95,1,1,'100036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:40:54','2019-06-29 21:40:54',NULL),(2066,'Hosen Baby Corn (Yoing Corn Spear) (SD) -425gm',9,'single',19,14,11,NULL,NULL,'exclusive',70,155,1,1,'100037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:51:55','2019-06-29 21:51:55',NULL),(2067,'Tang Orange 2.5kg',9,'single',19,321,52,NULL,NULL,'exclusive',0,0,1,1,'7622210614445','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:52:30','2019-06-29 21:52:30',NULL),(2068,'Hosen Baby Corn Cut (SD)-400 gm',9,'single',19,14,11,NULL,NULL,'exclusive',55,135,1,1,'100038','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:55:09','2019-06-29 21:55:09',NULL),(2069,'Hosen Whole Kernel Corn(Sweet Corn) (SD) -400gm',9,'single',19,14,11,NULL,NULL,'exclusive',45,120,1,1,'100039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 21:58:37','2019-06-29 21:58:37',NULL),(2070,'Hosen Cream Styled Corn (SD) -425gm',9,'single',19,14,11,NULL,NULL,'exclusive',60,125,1,1,'100040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:00:58','2019-07-09 15:56:51',NULL),(2071,'Hosen Red Kidney Beans in Brine (SD) -425gm',9,'single',19,14,11,NULL,NULL,'exclusive',75,167,1,1,'100041','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:06:00','2019-06-29 22:06:00',NULL),(2072,'Hosen Chick Peas (SD) -425gm',9,'single',19,14,11,NULL,NULL,'exclusive',80,180,1,1,'100042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:10:00','2019-06-29 22:10:00',NULL),(2073,'Hosen Baked Beans in Tomato Sauce (SD) -425gm',9,'single',19,14,11,NULL,NULL,'exclusive',65,140,1,1,'100043','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:12:51','2019-06-29 22:12:51',NULL),(2074,'Hosen Mixed Vegetables 400gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',45,100,1,1,'100044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:14:48','2019-07-23 16:03:35',NULL),(2076,'S&W Tomato Paste (SD) 170gm',9,'single',19,27,11,NULL,NULL,'exclusive',70,150,1,1,'100058','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:22:13','2019-06-29 22:22:13',NULL),(2077,'Hosen Tomato Paste 400gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',75,155,1,1,'100045','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:28:56','2019-07-23 15:59:38',NULL),(2078,'Hosen Fruit Cocktail Premium in Syrup 825gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',175,245,1,1,'100046','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:39:12','2019-07-23 16:01:17',NULL),(2079,'xyz',9,'single',19,1,1,NULL,NULL,'exclusive',0,0,1,1,'2079','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 22:43:19','2019-06-29 22:43:19',NULL),(2080,'Hosen Fruit Cocktail Premium in Syrup (SD) -420gm',9,'single',19,14,11,NULL,NULL,'exclusive',110,245,1,1,'100047','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:21:42','2019-06-29 23:32:12',NULL),(2081,'Hosen Pineapple slices in Syrup 565gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',90,195,1,1,'100049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:26:07','2019-07-23 16:00:31',NULL),(2082,'Hosen Pears Half in Syrup 825gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',175,390,1,1,'100048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:34:03','2019-07-23 16:02:49',NULL),(2083,'Hosen Pineapple Cubes in Syrup (SD) -565gm',9,'single',19,14,11,NULL,NULL,'exclusive',90,200,1,1,'100050','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:40:48','2019-06-30 01:02:30',NULL),(2084,'Hosen Rambutan in Syrup (SD) -565gm',9,'single',19,14,11,NULL,NULL,'exclusive',115,290,1,1,'100051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:42:57','2019-06-29 23:42:57',NULL),(2085,'Hosen Rambutan Stuffed with Pineapple 565gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',140,350,1,1,'100052','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:44:36','2019-07-23 16:02:13',NULL),(2086,'Hosen Logan  in Syrup  (SD) 565gm',9,'single',19,14,11,NULL,NULL,'exclusive',110,247,1,1,'100053','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:53:42','2019-06-29 23:53:42',NULL),(2087,'Hosen Plam fruit In Syrup 565gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',150,250,1,1,'100054','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:55:17','2019-07-23 15:58:24',NULL),(2088,'Hosen Honey Sea Coconut 565  (SD) gm',9,'single',19,14,11,NULL,NULL,'exclusive',150,360,1,1,'100055','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:57:15','2019-06-29 23:57:15',NULL),(2089,'Hosen Mandarin Orange In Syrup (SD) 312gm',9,'single',19,14,11,NULL,NULL,'exclusive',65,140,1,1,'100056','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-29 23:59:59','2019-06-29 23:59:59',NULL),(2090,'S&W Garbanzo Beans (SD) -439gm',9,'single',19,27,11,NULL,NULL,'exclusive',110,140,1,1,'100057','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 00:01:35','2019-06-30 00:01:35',NULL),(2091,'S&W Pitted Large Ripe Olive (SD) 396gm',9,'single',19,27,11,NULL,NULL,'exclusive',70,150,1,1,'100059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 00:24:37','2019-06-30 00:24:37',NULL),(2092,'Del Monte Four Season Cheese Pasta Sauce (SD) -680 gm',9,'single',19,8,11,NULL,NULL,'exclusive',160,400,1,1,'100060','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 00:26:11','2019-06-30 00:26:11',NULL),(2093,'Del Monte Mushroom Pasta Sauce (SD) -680 gm',9,'single',19,8,11,NULL,NULL,'exclusive',160,400,1,1,'100061','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 00:27:38','2019-06-30 00:27:38',NULL),(2094,'Del Monte Fruit Cocktail in Heavy Syrup (SD)- 825gm',9,'single',19,8,11,NULL,NULL,'exclusive',145,315,1,1,'100062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 00:35:23','2019-06-30 00:35:23',NULL),(2095,'Cyprina 100% Natural Orange Juice 1 Lt',9,'single',19,60,24,NULL,NULL,'exclusive',300,350,1,1,'5290074000494','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 18:07:03','2019-06-30 18:07:03',NULL),(2096,'Cyprina 100% Natural Apple Juice 1 Lt',9,'single',19,60,24,NULL,NULL,'exclusive',300,375,1,1,'5290074000548','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 18:10:09','2019-06-30 18:10:09',NULL),(2097,'Cyprina Red Grape Juicen 1Ltr',9,'single',19,60,24,NULL,NULL,'exclusive',0,0,1,1,'5290074000524','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 18:15:21','2019-06-30 18:15:21',NULL),(2098,'Cyprina Cranberry Juice 1ltr',9,'single',19,60,24,NULL,NULL,'exclusive',0,0,1,1,'5290074002405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 18:20:00','2019-06-30 18:20:00',NULL),(2099,'Cyprina Tropical Juice 250ml',9,'single',19,60,24,NULL,NULL,'exclusive',0,0,1,1,'52920943','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 18:22:23','2019-06-30 18:22:23',NULL),(2100,'Munchy\'s Funmix 295gm',9,'single',19,59,5,NULL,NULL,'exclusive',245,350,1,1,'9556439881068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 18:29:13','2020-06-30 14:46:45',NULL),(2101,'Cadbury Dairy Milk Silk Hazelnut 58 gm',9,'single',19,129,15,NULL,NULL,'exclusive',110,140,1,1,'8901233031446','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 21:06:30','2019-06-30 21:07:26',NULL),(2102,'Cadbury Dairy Silk Bubbly 120 gm',9,'single',19,129,15,NULL,NULL,'exclusive',240,280,1,1,'8901233034324','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 21:11:19','2019-06-30 21:11:19',NULL),(2103,'Amul Kool kesar 180 ml',9,'single',19,322,24,NULL,NULL,'exclusive',60,60,1,1,'8901262152211','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-06-30 21:33:47','2019-06-30 21:35:05',NULL),(2104,'Deka Wafer Roll Choco Choco360 gm',9,'single',19,323,55,NULL,NULL,'exclusive',370,420,1,1,'8995077603778','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 16:24:25','2019-07-01 16:24:25',NULL),(2105,'Cowhead Organic Oat Bran 400 gm',9,'single',19,84,28,NULL,NULL,'exclusive',360,440,1,1,'8888440010092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 16:27:54','2019-07-01 16:27:54',NULL),(2106,'Cowhead Organic Oat For Rice 500 gm',9,'single',19,84,28,NULL,NULL,'exclusive',360,440,1,1,'8888440010085','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 16:38:34','2019-07-01 16:38:34',NULL),(2107,'Cowhead Organic Rolled Oats 500 gm',9,'single',19,84,28,NULL,NULL,'exclusive',360,420,1,1,'8888440007238','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 16:41:33','2019-07-01 16:41:33',NULL),(2108,'Cowhead Organic Rolled Oats Baby Oats Instant 500 gm',9,'single',19,84,28,NULL,NULL,'exclusive',360,420,1,1,'8888440007245','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 16:45:44','2020-11-20 23:36:51',NULL),(2109,'Lacy\'s Zipbag Gallon  Size (260 mm x 280 mm)',9,'single',19,46,48,NULL,NULL,'exclusive',200,220,1,1,'8888417002037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 16:59:35','2019-07-01 16:59:35',NULL),(2110,'Lacy\'s Zipbag Jumbo Size (330 mm X 380 mm)',9,'single',19,174,48,NULL,NULL,'exclusive',200,220,1,1,'8888417002044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 17:02:01','2019-07-01 17:02:01',NULL),(2111,'Cowhead Butter Milk Cookies Trans Fat Free 210 gm',9,'single',19,84,18,NULL,NULL,'exclusive',260,308,1,1,'8888440010450','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 17:11:17','2019-07-01 17:11:17',NULL),(2112,'Lurpak Butter Unsalted 200 gm',9,'single',19,212,6,NULL,NULL,'exclusive',280,280,1,1,'5740900884304','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 18:02:09','2020-03-09 20:01:49',NULL),(2113,'Lurpak Butter Salted 200 gm',9,'single',19,212,6,NULL,NULL,'exclusive',280,280,1,1,'5740900861305','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 18:04:15','2020-03-09 20:03:30',NULL),(2114,'Pasta Zara Farfalle 500 gm',9,'single',19,324,30,NULL,NULL,'exclusive',155,180,1,1,'8004350130310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 19:26:37','2019-07-01 19:26:37',NULL),(2115,'Pasta Zara Spiral 500 gm',9,'single',19,324,30,NULL,NULL,'exclusive',155,180,1,1,'8004350130570','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 19:28:13','2019-07-01 19:28:13',NULL),(2116,'Pasta Zara Conchiglile 500 gm',9,'single',19,324,NULL,NULL,NULL,'exclusive',145,180,1,1,'8004350130549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 20:23:47','2019-07-01 20:30:32',NULL),(2117,'ALSHIFA Natural Honey 1 kg',9,'single',19,89,56,NULL,NULL,'exclusive',1080,1265,1,1,'6281073210228','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 21:10:55','2020-06-24 16:15:29',NULL),(2118,'ALSHIFA Natural Honey 750 gm',9,'single',19,89,56,NULL,NULL,'exclusive',850,985,1,1,'6281073210341','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 21:19:24','2019-07-16 20:22:32',NULL),(2119,'ALSHIFA Natural Honey 500 gm',9,'single',19,89,56,NULL,NULL,'exclusive',630,710,1,1,'6281073210181','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 21:22:15','2020-09-29 13:57:10',NULL),(2120,'ALSHIFA Black Forest Honey 1 kg',9,'single',19,89,56,NULL,NULL,'exclusive',1720,2060,1,1,'6281073210600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 21:28:34','2019-07-16 20:15:17',NULL),(2121,'ALSHIFA Black Forest Honey 500 gm',9,'single',19,89,56,NULL,NULL,'exclusive',950,1160,1,1,'6281073210587','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 21:59:32','2019-07-16 20:17:09',NULL),(2122,'Amul Pasteurised Butter 200 gm',9,'single',19,291,6,NULL,NULL,'exclusive',210,0,1,1,'8901262010320','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 22:24:07','2020-07-12 14:00:18',NULL),(2123,'Bega Gourmet Slices Cheese 200 gm',9,'single',19,326,13,NULL,NULL,'exclusive',235,220,1,1,'9310264911266','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 22:28:09','2019-12-23 00:50:06',NULL),(2124,'Bega Black Pepper Slices Cheese 200 gm',9,'single',19,326,13,NULL,NULL,'exclusive',230,250,1,1,'9310264911075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 22:32:22','2019-07-01 23:09:06',NULL),(2125,'Bega Burger Slices Yellow Cheese 1kg',9,'single',19,326,13,NULL,NULL,'exclusive',900,1100,1,1,'9310264913703','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 22:43:35','2019-07-01 23:10:01',NULL),(2126,'Bega Burger slices White Cheese 1kg',9,'single',19,326,13,NULL,NULL,'exclusive',870,1050,1,1,'9310264913697','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 22:54:19','2019-07-01 23:09:34',NULL),(2127,'Bega Super Slices 250 gm',9,'single',19,326,13,NULL,NULL,'exclusive',290,300,1,1,'9310052751203','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 23:38:42','2019-10-15 22:12:14',NULL),(2128,'Oreo Chocolate Cream Biscuite 137gm',9,'single',19,129,5,NULL,NULL,'exclusive',88,110,1,1,'8992760223015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 23:52:32','2019-11-09 00:32:02',NULL),(2129,'Nutella 825gm',9,'single',19,115,15,NULL,NULL,'exclusive',650,700,1,1,'80050346','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 23:56:53','2019-07-01 23:56:53',NULL),(2130,'Nestle Cream 160gm',9,'single',19,63,41,NULL,NULL,'exclusive',93,105,1,1,'7891000040874','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-01 23:59:04','2019-07-01 23:59:04',NULL),(2131,'American Harvest Basil Seed Drink Cocktail 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044004796','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 00:11:32','2020-09-08 16:46:28',NULL),(2132,'American Harvest Basil Seed Drink Pomegrante 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044004802','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 00:20:33','2020-09-08 16:46:44',NULL),(2133,'American Harvest Basil Seed Drink Strawberry  290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044004789','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 00:24:29','2020-09-08 16:46:12',NULL),(2134,'American Harvest Basil Seed Drink  Honey 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044004741','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 00:26:02','2019-07-27 01:24:44',NULL),(2135,'Jazz uk Harvest Basil Seed Drink Apple/watermelon 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044006806','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 14:54:28','2020-10-02 21:51:38',NULL),(2136,'American Harvest Basil Seed Drink  lemon mint  290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,100,1,1,'8855044037961','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:01:57','2019-07-05 20:59:48',NULL),(2137,'Jazz uk Harvest Basil Seed Drink  Pineapple 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044004758','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:24:44','2020-10-02 21:49:48',NULL),(2138,'JAZZ UK Harvest Basil Seed Drink  White Grap 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044006837','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:26:08','2020-10-02 21:40:09',NULL),(2139,'American Harvest Basil Seed Drink  Lychee  290ml',9,'single',19,327,24,NULL,NULL,'exclusive',88,120,1,1,'8855044004727','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:27:37','2019-07-27 01:27:02',NULL),(2140,'Oreo Strawberry Cream 137Gm',9,'single',19,129,5,NULL,NULL,'exclusive',88,110,1,1,'7622300136055','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:37:03','2020-06-24 16:13:48',NULL),(2141,'Oreo Original 137gm',9,'single',19,129,5,NULL,NULL,'exclusive',95,110,1,1,'8992760221028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:42:44','2019-07-02 18:33:45',NULL),(2142,'Oreo Peanut Butter & Chocolate 137gm',9,'single',19,129,5,NULL,NULL,'exclusive',98,110,1,1,'8992760121090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:51:21','2019-07-02 18:33:02',NULL),(2143,'London pie cake Coconut Flavoure 20x20gm',9,'single',19,244,73,NULL,NULL,'exclusive',330,365,1,1,'9556055663550','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 15:56:16','2019-07-02 15:56:16',NULL),(2144,'Rani Fruit Drink Mango 1.5lit',9,'single',19,243,24,NULL,NULL,'exclusive',320,350,1,1,'6281034016425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 16:24:59','2019-07-02 16:24:59',NULL),(2145,'Quaker Oats 500gm tin',9,'single',19,99,28,NULL,NULL,'exclusive',220,240,1,1,'6290400030095','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 16:43:54','2019-07-02 16:43:54',NULL),(2146,'Philadelphia Original Cream Cheese Block 250 gm',9,'single',19,328,13,NULL,NULL,'exclusive',350,400,1,1,'9300650430419','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 18:08:23','2019-07-02 18:08:23',NULL),(2147,'Heniz First Steps With Apricot & Peach Muesli 10+  260gm',9,'single',19,13,64,NULL,NULL,'exclusive',470,600,1,1,'5000157141330','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 20:39:11','2019-07-02 20:39:11',NULL),(2148,'Heniz First Steps With Mixed Berry Muesli 10+ 260gm',9,'single',19,13,64,NULL,NULL,'exclusive',475,600,1,1,'5000157141439','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 21:07:27','2019-07-02 21:07:27',NULL),(2149,'Skittles Fruits 45 gm',9,'single',19,126,15,NULL,NULL,'exclusive',90,125,1,1,'4009900522120','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 21:46:58','2019-07-02 21:46:58',NULL),(2150,'Toblerone Fruit & Nut 100 gm',9,'single',19,116,15,NULL,NULL,'exclusive',175,245,1,1,'7622300107949','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 21:50:57','2019-07-02 21:50:57',NULL),(2151,'Nestle Kitkat 4 finger Dark 41.5g',9,'single',19,63,15,NULL,NULL,'exclusive',80,110,1,1,'7613035220324','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 22:00:32','2019-07-02 22:00:32',NULL),(2152,'Ocean Spray Cranberry Classic Juice Drink 1 Lt',9,'single',19,NULL,24,NULL,NULL,'exclusive',310,350,1,1,'031200041043','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 22:21:48','2019-07-02 22:21:48',NULL),(2153,'Ocean Spray Cranberry Raspberry Juice Drink 1 Lt',9,'single',19,329,24,NULL,NULL,'exclusive',310,350,1,1,'031200471109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 22:25:45','2019-07-02 22:25:45',NULL),(2154,'Canderel Sugar 75gm',9,'single',19,154,35,NULL,NULL,'exclusive',240,260,1,1,'7640110700075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 22:36:58','2019-07-02 22:36:58',NULL),(2155,'Cadbury Cocoa Powder 125 gm',9,'single',19,129,51,NULL,NULL,'exclusive',190,210,1,1,'5000312000694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 22:57:32','2019-07-02 22:57:32',NULL),(2156,'Cadbury Cocoa Powder 250 gm',9,'single',19,129,51,NULL,NULL,'exclusive',300,330,1,1,'5000312000700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 22:59:40','2019-07-02 22:59:40',NULL),(2157,'Dewberry Sandwich Cookies Strawberry  105 gm',9,'single',19,182,18,NULL,NULL,'exclusive',120,140,1,1,'8850309202269','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 23:10:00','2019-07-02 23:10:00',NULL),(2158,'Dewberry Sandwich Cookies Blueberry 105 gm',9,'single',19,182,18,NULL,NULL,'exclusive',120,140,1,1,'8850309202276','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 23:13:45','2019-07-02 23:13:45',NULL),(2159,'Tong Garden Freshly Roasted Nuts 1 kg',9,'single',19,177,53,NULL,NULL,'exclusive',950,1000,1,1,'013256110003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 23:39:35','2020-03-16 20:08:03',NULL),(2160,'Weetabix Biscuits 100 gm',9,'single',19,330,5,NULL,NULL,'exclusive',250,280,1,1,'5010029000504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 23:42:18','2020-06-13 14:57:25',NULL),(2161,'Bachun Pure Sesame Oil 320 ml',9,'single',19,2,29,NULL,NULL,'exclusive',360,400,1,1,'8888209328925','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 23:47:21','2019-07-02 23:47:21',NULL),(2162,'Nestle Milo Original 240 ml',9,'single',19,63,4,NULL,NULL,'exclusive',100,120,1,1,'9556001051509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-02 23:49:48','2019-07-02 23:49:48',NULL),(2163,'Oateo Instant Oats 50gm B2G1 Free',9,'single',19,331,28,NULL,NULL,'exclusive',65,70,1,1,'4796918130194','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-03 15:20:57','2019-07-07 19:29:49',NULL),(2164,'Oateo Oat Flour 500gm',9,'single',19,331,77,NULL,NULL,'exclusive',360,400,1,1,'4796918130170','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-03 15:25:14','2019-07-03 15:25:14',NULL),(2165,'Oateo Steel Cut Oats 500gm',9,'single',19,331,28,NULL,NULL,'exclusive',360,400,1,1,'4796918130125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-03 15:26:53','2019-07-03 15:26:53',NULL),(2166,'Oteao Rolled Oats 500gm',9,'single',19,331,28,NULL,NULL,'exclusive',360,400,1,1,'4796918130026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-03 15:28:33','2019-07-03 15:28:33',NULL),(2167,'Foster Clarks Corn Flour 400 gm Tin',9,'single',19,57,77,NULL,NULL,'exclusive',0,0,1,1,'5352101708640','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-04 19:01:51','2019-07-04 19:01:51',NULL),(2168,'Foster Clarks Essence 28 ml vanilla',9,'single',19,57,51,NULL,NULL,'exclusive',0,0,1,1,'5352101434501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-04 19:06:48','2019-07-04 19:06:48',NULL),(2169,'Arla Slices  Cheese 1000g',9,'single',19,211,13,NULL,NULL,'exclusive',0,0,1,1,'9009301002738','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-04 19:51:59','2019-07-04 19:51:59',NULL),(2170,'Pampers Baby-Dry diaper Jumbo Pack 3 (100 PCS)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'8001090268679','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-06 21:14:55','2019-07-06 21:14:55',NULL),(2171,'Pampers Baby-Dry diaper Jumbo Pack 4+ (76 PCS)',9,'single',19,270,68,NULL,NULL,'exclusive',1980,1980,1,1,'4015400695677','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-06 21:15:59','2019-07-06 21:15:59',NULL),(2172,'Harvey Fresh Lactose Free SKIM Milk 1Ltr',9,'single',19,332,26,NULL,NULL,'exclusive',250,275,1,1,'9311697101712','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-06 21:35:10','2019-07-06 21:35:10',NULL),(2173,'Harvey Fresh Full Cream Milk 1Ltr',9,'single',19,332,26,NULL,NULL,'exclusive',180,220,1,1,'9311697100173','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-06 21:37:11','2019-10-21 19:55:22',NULL),(2174,'Harvey Fresh  SKIM Milk 1Ltr',9,'single',19,332,26,NULL,NULL,'exclusive',225,250,1,1,'9311697101583','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-06 21:39:07','2019-07-06 21:39:07',NULL),(2175,'Harvey Fresh Low Fat Milk 1Ltr',9,'single',19,332,26,NULL,NULL,'exclusive',210,235,1,1,'9311697104362','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-06 21:40:42','2019-07-06 21:40:42',NULL),(2176,'Cocalab Chocolate Dark & Roasted 100g',9,'single',19,200,15,NULL,NULL,'exclusive',0,0,1,1,'9201906001011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-07 19:02:23','2019-07-07 19:02:23',NULL),(2177,'American Garden Mushroom 1.5kg',9,'single',19,150,11,NULL,NULL,'exclusive',570,650,1,1,'717273701144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-08 19:44:50','2019-07-23 18:49:13',NULL),(2178,'Lindt swiss Classic Milk White chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',325,370,1,1,'7610400070195','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-09 23:18:18','2019-07-09 23:18:18',NULL),(2179,'Lindt Excellence 99% Dark Chocolate 50gm',9,'single',19,214,15,NULL,NULL,'exclusive',325,370,1,1,'3046920028721','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-09 23:40:27','2019-07-09 23:40:27',NULL),(2180,'Lindt  Excellence 70% Dark Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',325,370,1,1,'3046920028004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-09 23:44:14','2020-02-22 22:29:58',NULL),(2181,'Lindt Excellence Dark Chocolate 85% 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',325,370,1,1,'3046920028363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-09 23:50:36','2019-07-09 23:50:36',NULL),(2182,'Lindt Excellence 90% Dark Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,370,1,1,'3046920029759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-09 23:54:35','2020-02-22 22:30:41',NULL),(2183,'Belgian Milk Hazelnuts Chocolate NSA 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',310,345,1,1,'5413121359981','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-09 23:58:56','2019-07-09 23:58:56',NULL),(2184,'Belgian Milk Chocolate NSA 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',310,345,1,1,'5413121356829','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:03:17','2019-07-10 00:03:17',NULL),(2185,'CAMEL ROASTED PEANUTS Tin 130G',9,'single',19,58,53,NULL,NULL,'exclusive',275,380,1,1,'8888112030090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:12:43','2019-07-10 00:22:23',NULL),(2186,'CAMEL Smoked Almonds Tin 130G',9,'single',19,58,9,NULL,NULL,'exclusive',370,450,1,1,'8888112080309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:16:32','2019-07-10 00:22:04',NULL),(2187,'CAMEL CASHEW NUTS ROASTED Tin 130G',9,'single',19,58,9,NULL,NULL,'exclusive',370,450,1,1,'8888112010382','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:18:44','2019-07-10 00:21:43',NULL),(2188,'CAMEL Natural Sweet & Nutty Mix Tin 130G',9,'single',19,58,9,NULL,NULL,'exclusive',370,450,1,1,'8888112780322','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:21:17','2019-07-10 00:21:17',NULL),(2189,'Nestle Honey Flakes 500 gm',9,'single',19,63,21,NULL,NULL,'exclusive',495,560,1,1,'7613034859020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:38:00','2019-07-10 00:38:00',NULL),(2190,'Kellogg\'s Corn Flakes 1 kg',9,'single',19,128,21,NULL,NULL,'exclusive',660,750,1,1,'5000127014084','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:40:03','2019-07-10 00:40:03',NULL),(2191,'Kellogg\'s Frosties 750 gm',9,'single',19,128,21,NULL,NULL,'exclusive',495,560,1,1,'5000127153950','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:44:27','2019-07-10 00:44:27',NULL),(2192,'Kellogg\'s Coco Pops 720 gm',9,'single',19,128,21,NULL,NULL,'exclusive',605,690,1,1,'5053827173025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:46:25','2019-07-10 00:46:25',NULL),(2193,'Extra Vargin Olive oil 1 Ltr',9,'single',19,334,29,NULL,NULL,'exclusive',770,875,1,1,'8002210500303','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:52:00','2019-07-10 00:52:00',NULL),(2194,'Nestle Cheerios Fibre 600 gm',9,'single',19,63,21,NULL,NULL,'exclusive',605,690,1,1,'5011476100885','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 00:54:16','2019-07-10 00:54:16',NULL),(2195,'Caffe Boasi Super Crema 1 kg',9,'single',19,335,16,NULL,NULL,'exclusive',1590,1875,1,1,'8003370071108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:07:31','2019-07-10 01:07:31',NULL),(2196,'Caffe Boasi Riserva Special  Crema 1 kg',9,'single',19,335,16,NULL,NULL,'exclusive',1800,2125,1,1,'8003370411010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:10:38','2019-07-10 01:10:38',NULL),(2197,'Must Espresso Italiano Forever  1kg',9,'single',19,336,16,NULL,NULL,'exclusive',1800,2125,1,1,'8056370766031','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:14:45','2019-07-10 01:14:45',NULL),(2198,'Must Espresso Italiano Cremoso  1kg',9,'single',19,336,16,NULL,NULL,'exclusive',1700,2000,1,1,'8056370766000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:17:56','2019-07-10 01:17:56',NULL),(2199,'Monin Vanilla Syrup 1ltr',9,'single',19,173,36,NULL,NULL,'exclusive',1320,1500,1,1,'3052910000929','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:22:30','2019-07-10 01:22:30',NULL),(2200,'Monin Bleu Curacao Syrup 1ltr',9,'single',19,173,36,NULL,NULL,'exclusive',1320,1500,1,1,'3052910056025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:24:59','2019-07-10 01:24:59',NULL),(2201,'Monin Pomme Verte green Apple Syrup 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',925,1050,1,1,'3052910015107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:28:53','2019-07-10 01:28:53',NULL),(2202,'Monin Mojito Mint Syrup 1ltr',9,'single',19,173,36,NULL,NULL,'exclusive',1320,1500,1,1,'3052910516062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:32:21','2019-07-10 01:32:21',NULL),(2203,'Monin Hazel Nut Syrup 1ltr',9,'single',19,173,36,NULL,NULL,'exclusive',1320,1500,1,1,'3052910001254','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:36:36','2019-07-10 01:36:36',NULL),(2204,'Monin Peach Syrup 1ltr',9,'single',19,173,36,NULL,NULL,'exclusive',1320,1500,1,1,'3052910056179','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:39:42','2019-07-10 01:39:42',NULL),(2205,'Monin Citron Vert Lime Syrup 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',770,875,1,1,'3052911197000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:43:51','2019-07-10 01:43:51',NULL),(2206,'Monin Pomegranate Syrup 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',925,1050,1,1,'3052911268694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:46:02','2019-07-10 01:46:02',NULL),(2207,'Monin Mango Tea Syrup 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',770,875,1,1,'3052910015701','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:49:40','2019-07-10 01:49:40',NULL),(2208,'Monin Raspberry Tea Syrup 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',770,875,1,1,'3052911197819','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:52:25','2019-07-10 01:52:25',NULL),(2209,'Monin Peach Tea Syrup 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',770,875,1,1,'3052911197550','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 01:54:02','2019-07-10 01:54:02',NULL),(2210,'Plum Chutney 400gm',9,'single',19,231,23,NULL,NULL,'exclusive',150,160,1,1,'788821000859','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 20:23:09','2019-07-10 20:23:09',NULL),(2211,'Shan Karachi Beef Biryani Masala 60 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821032027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 21:03:48','2019-07-10 21:03:48',NULL),(2212,'Four Seasons Basmati 1kg',9,'single',19,338,54,NULL,NULL,'exclusive',240,250,1,1,'12345678','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 21:40:41','2019-07-10 21:40:41',NULL),(2213,'Badshahi Basmati Rice 1kg',9,'single',19,339,54,NULL,NULL,'exclusive',250,260,1,1,'1234567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 21:43:28','2019-07-10 21:43:28',NULL),(2214,'Shan Fish Masala 50 gm',9,'single',19,231,66,NULL,NULL,'exclusive',90,95,1,1,'788821004239','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 21:45:54','2019-07-10 21:45:54',NULL),(2215,'Kurkure British Style Salt & Papper 45gm',9,'single',19,340,14,NULL,NULL,'exclusive',25,25,1,1,'710535945751','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 21:56:16','2019-07-10 21:56:58',NULL),(2216,'Kurkure British Style Salt & Papper 90gm',9,'single',19,340,14,NULL,NULL,'exclusive',45,50,1,1,'710535945768','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-10 21:57:51','2019-07-10 21:57:51',NULL),(2217,'Pure Corn Oil Vitamixed 3.78 Ltr',9,'single',19,337,29,NULL,NULL,'exclusive',920,980,1,1,'8592780060432','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 13:38:32','2019-07-15 16:06:44',NULL),(2218,'Pasta Bake With Creamy S. Tomato & Garlic 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:05:56','2020-08-13 00:44:28',NULL),(2219,'Pasta Bake Pizza Supreme With M. O.& Capsicum500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645107517','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:09:10','2019-07-15 16:09:33',NULL),(2220,'Pasta Bake With Tomato Ricotta & Spinach 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:11:50','2020-08-13 00:45:16',NULL),(2221,'Pasta Bake Bolognese With Bacon  500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111132','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:13:56','2019-07-15 16:11:42',NULL),(2222,'Tuna Bake With Spinach & Garlic  500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111286','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:16:14','2019-07-15 16:12:08',NULL),(2223,'Leggos Pesto Sundried Tomato 190gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'93352208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:19:25','2020-08-13 00:45:54',NULL),(2224,'Leggos Bolognese With Chunky Tomato,G & Herbs 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:23:41','2020-08-13 00:47:35',NULL),(2225,'Leggos Alfredo Pasta Sauce 490gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:25:28','2020-08-13 00:48:36',NULL),(2226,'Leggos Napoletana Pasta Sauce 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645110227','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:27:03','2020-08-13 00:49:30',NULL),(2227,'Leggos Bolognese Mushroom Pasta Sauce 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111187','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:28:32','2020-08-13 00:50:10',NULL),(2228,'Pasta Bake With Creamy S. Tomato & Mozzarella 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,450,1,1,'9300645111309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:30:36','2019-07-15 16:22:29',NULL),(2229,'Carmans Classic Fruit & Nut Muesli 500gm',9,'single',19,341,1,NULL,NULL,'exclusive',700,825,1,1,'9319133331389','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:34:05','2019-07-15 16:23:44',NULL),(2230,'Lowan Whole Foods Swiss Muesli 750gm',9,'single',19,342,1,NULL,NULL,'exclusive',730,865,1,1,'9310273257492','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:36:43','2019-07-11 14:36:43',NULL),(2231,'Lowan Whole Foods Tropical Muesli 750gm',9,'single',19,342,1,NULL,NULL,'exclusive',730,865,1,1,'9310273257577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:39:09','2019-07-11 14:39:09',NULL),(2232,'Lowan Whole Food Apricot & Almond Muesli 750gm',9,'single',19,342,1,NULL,NULL,'exclusive',730,865,1,1,'9310273257539','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:41:00','2019-07-11 14:41:00',NULL),(2233,'Lowan Whole Foods Fruit & Nut Muesli 750gm',9,'single',19,342,32,NULL,NULL,'exclusive',730,865,1,1,'9310273257614','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 14:42:32','2019-07-11 14:42:32',NULL),(2234,'Whole Grain Quick Oats 1kg',9,'single',19,342,28,NULL,NULL,'exclusive',790,930,1,1,'9310273275007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:12:02','2019-07-11 15:12:02',NULL),(2235,'Victoria Spaghetti Pasta 500gm',9,'single',19,139,30,NULL,NULL,'exclusive',125,145,1,1,'8000483301016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:15:50','2019-07-11 15:15:50',NULL),(2236,'Victoria Spaghetti Linguine 500gm',9,'single',19,139,30,NULL,NULL,'exclusive',125,145,1,1,'8000483301207','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:19:38','2019-07-11 15:19:38',NULL),(2237,'Figaro Plain  Green Olive 340gm',9,'single',19,12,49,NULL,NULL,'exclusive',120,140,1,1,'8410159047375','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:28:41','2019-07-11 15:28:41',NULL),(2238,'Heinz Sandwich Spread 450gm',9,'single',19,13,32,NULL,NULL,'exclusive',550,640,1,1,'8715700421049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:31:25','2019-07-11 15:31:25',NULL),(2239,'LEA & PERRINS Sauce 290gm',9,'single',19,343,32,NULL,NULL,'exclusive',200,240,1,1,'5000111045414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:38:43','2019-07-11 15:38:43',NULL),(2240,'Lavazza Caffe Espresso 250gm',9,'single',19,344,16,NULL,NULL,'exclusive',690,800,1,1,'8000070012837','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:43:16','2019-07-11 15:43:16',NULL),(2241,'Lavazza Crema E Gusto 250gm',9,'single',19,344,16,NULL,NULL,'exclusive',575,665,1,1,'8000070038868','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:45:14','2019-07-11 15:45:14',NULL),(2242,'A1 sauce 240gm',9,'single',19,345,32,NULL,NULL,'exclusive',200,240,1,1,'49878431','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:46:38','2019-07-11 15:46:38',NULL),(2243,'Remia Mayonnaise 250ml',9,'single',19,44,25,NULL,NULL,'exclusive',135,160,1,1,'8710448562276','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:48:38','2019-07-11 15:48:38',NULL),(2244,'Remia Mayonnaise 500ml',9,'single',19,44,25,NULL,NULL,'exclusive',250,290,1,1,'8710448562283','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 15:56:28','2019-07-11 15:56:28',NULL),(2245,'Fish Sauce 750ml',9,'single',19,346,32,NULL,NULL,'exclusive',180,210,1,1,'8855362001040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:14:33','2019-07-11 16:14:33',NULL),(2246,'Maggi Sissoning 200gm',9,'single',19,63,32,NULL,NULL,'exclusive',95,110,1,1,'8850124065414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:19:04','2019-07-11 16:19:04',NULL),(2247,'Soya Sauce 700ml',9,'single',19,347,32,NULL,NULL,'exclusive',200,240,1,1,'8850206011025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:23:00','2019-07-11 16:23:00',NULL),(2248,'Super Bee Honey (Macadamia) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',790,930,1,1,'9322050000788','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:26:28','2019-07-11 16:26:51',NULL),(2249,'Super Bee Honey (Tasmanian ) 500 gm',9,'single',19,144,56,NULL,NULL,'exclusive',970,1130,1,1,'9322050000757','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:28:50','2019-07-11 16:28:50',NULL),(2250,'Kraft Cream Cheese Spread Original 500 gm',9,'single',19,253,13,NULL,NULL,'exclusive',575,665,1,1,'9300657660123','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:31:16','2019-07-11 16:31:16',NULL),(2251,'Kraft Cream Cheese Spread Original 250 gm',9,'single',19,253,13,NULL,NULL,'exclusive',310,360,1,1,'9300657660130','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:32:35','2019-07-11 16:32:35',NULL),(2252,'Kraft Peanut Butter Smooth 375gm',9,'single',19,253,6,NULL,NULL,'exclusive',460,530,1,1,'9300657660628','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-11 16:34:05','2019-07-11 16:34:05',NULL),(2253,'Pran Mango Bar 14x30=420gm',9,'single',19,NULL,76,NULL,NULL,'exclusive',195,210,1,1,'831730003272','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-12 15:38:49','2019-07-12 15:38:49',NULL),(2254,'Well Food Butter Toast 250gm',9,'single',19,348,78,NULL,NULL,'exclusive',85,90,1,1,'65089170','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:11:57','2019-07-13 14:11:57',NULL),(2255,'Well Food Mint Leaf Toast 250gm',9,'single',19,348,78,NULL,NULL,'exclusive',80,90,1,1,'01758106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:20:31','2019-07-13 14:20:31',NULL),(2256,'Well Food Chanachur 200gm',9,'single',19,348,79,NULL,NULL,'exclusive',65,70,1,1,'017581','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:26:26','2019-07-13 14:26:26',NULL),(2257,'Well Food Sugar Free Cookies 300gm',9,'single',19,348,18,NULL,NULL,'exclusive',190,210,1,1,'65089231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:28:11','2019-07-13 14:28:11',NULL),(2258,'Well Food Mini Chanachur 400gm',9,'single',19,348,79,NULL,NULL,'exclusive',105,115,1,1,'0175811','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:30:09','2019-07-13 14:30:09',NULL),(2259,'Well Food Bela Biscuit  400gm',9,'single',19,348,5,NULL,NULL,'exclusive',90,100,1,1,'98609451','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:31:51','2019-07-13 14:31:51',NULL),(2260,'Well Food Milk Salt Cookies 300gm',9,'single',19,348,18,NULL,NULL,'exclusive',190,210,1,1,'65089262','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:33:13','2019-07-13 14:40:41',NULL),(2261,'Well Food Butter Salt Cookies 300gm',9,'single',19,348,18,NULL,NULL,'exclusive',200,220,1,1,'5061728394999','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:34:42','2019-07-13 14:34:42',NULL),(2262,'Well Food Dry Cake Premium 300gm',9,'single',19,348,73,NULL,NULL,'exclusive',200,220,1,1,'65089248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:36:36','2019-07-13 14:36:36',NULL),(2263,'Well Food Chocolate cake Rusk 300gm',9,'single',19,348,73,NULL,NULL,'exclusive',200,220,1,1,'5254767849296','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:38:20','2019-07-13 14:38:20',NULL),(2264,'Well Food Horli Plus 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',200,220,1,1,'98608645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-13 14:39:57','2019-07-13 14:39:57',NULL),(2265,'Mamy Poko Pants Extra Absorb L 62 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',1580,1580,1,1,'8903622197252','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-16 20:58:54','2019-07-16 20:58:54',NULL),(2266,'Mamy Poko Pants Extra Absorb XL 56 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',1580,1580,1,1,'8903622000316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-16 21:00:24','2019-07-16 21:00:24',NULL),(2267,'Mamy Poko Pants Extra Absorb S 42 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',760,800,1,1,'8903622037145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-16 21:06:26','2019-07-20 15:35:39',NULL),(2268,'Mamy Poko Pants Extra Absorb M 40 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',760,800,1,1,'8903622037244','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-16 21:08:02','2019-07-20 15:36:08',NULL),(2269,'Mamy Poko Pants Extra Absorb L 32 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',760,800,1,1,'8903622037343','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-16 21:10:12','2019-07-20 15:36:51',NULL),(2270,'Mamy Poko Pants Extra Absorb XXXL 7 Pants',9,'single',19,275,68,NULL,NULL,'exclusive',550,550,1,1,'8903622032706','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-16 21:12:49','2019-07-16 21:12:49',NULL),(2271,'Well Food Fruit N Nut Dark Chocolate 200 gm',9,'single',19,348,15,NULL,NULL,'exclusive',250,295,1,1,'171846874107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 18:55:28','2019-07-17 19:00:42',NULL),(2272,'Well Food Bigbite Chocolate 180 gm',9,'single',19,348,15,NULL,NULL,'exclusive',220,250,1,1,'2546987132320','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:01:23','2019-07-17 19:01:23',NULL),(2273,'Good Day Vanila Latte 20gm',9,'single',19,314,16,NULL,NULL,'exclusive',105,125,1,1,'8991002103320','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:10:42','2019-07-17 19:10:42',NULL),(2274,'Good Day Coffee Freeze Box 30gm',9,'single',19,314,16,NULL,NULL,'exclusive',147,175,1,1,'8991002103726','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:12:08','2019-08-04 20:33:53',NULL),(2275,'Good Day Chococino Coffee 20gm',9,'single',19,314,16,NULL,NULL,'exclusive',105,125,1,1,'8991002103825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:13:11','2019-07-17 19:13:11',NULL),(2276,'Good Day Cappuccino Box 125gm',9,'single',19,314,16,NULL,NULL,'exclusive',135,160,1,1,'8991002103788','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:15:07','2019-07-17 19:15:07',NULL),(2277,'Kapalapi Grande White Box 20gm',9,'single',19,349,16,NULL,NULL,'exclusive',105,125,1,1,'8991002115163','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:20:35','2019-07-17 19:20:35',NULL),(2278,'Good Day Nabati Cheese Wafer 37gm',9,'single',19,350,55,NULL,NULL,'exclusive',35,40,1,1,'8993175538398','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:23:29','2019-07-17 19:23:29',NULL),(2279,'Good Day Nabati Choco Wafer 37gm',9,'single',19,351,55,NULL,NULL,'exclusive',35,40,1,1,'8908008674082','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-17 19:25:11','2019-07-17 19:25:11',NULL),(2280,'Dr.OETKER BRIGHT&BOLD MIX 89GM',9,'single',19,352,15,NULL,NULL,'exclusive',455,530,1,1,'96148259','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:13:14','2019-07-18 16:13:14',NULL),(2281,'DR OETKER SUPER HERO MIX 76GM',9,'single',19,352,15,NULL,NULL,'exclusive',455,530,1,1,'96133132','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:14:35','2019-07-18 16:14:35',NULL),(2282,'DR.OETKER CHOCOLATEY MIX 76GM',9,'single',19,352,15,NULL,NULL,'exclusive',455,530,1,1,'96133125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:16:11','2019-07-18 16:16:11',NULL),(2283,'DR.OETKER FAIRY MIX 77GM',9,'single',19,352,15,NULL,NULL,'exclusive',455,530,1,1,'96133149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:18:21','2019-07-18 16:18:21',NULL),(2284,'FERRERO NUTELLA&GO 48G',9,'single',19,132,15,NULL,NULL,'exclusive',210,250,1,1,'5020411121182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:22:03','2020-03-09 15:27:18',NULL),(2285,'GULLON SUGER FREE MARIA BISCUITES 400GM',9,'single',19,353,5,NULL,NULL,'exclusive',495,575,1,1,'8410376040739','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:25:41','2019-07-18 16:25:41',NULL),(2286,'GULLON SUGER FREE DIGESTIVE BISCUITES 250GM',9,'single',19,353,5,NULL,NULL,'exclusive',420,485,1,1,'8410376049602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:28:26','2019-07-18 16:28:26',NULL),(2287,'GULLON SUGAR FREE SHORTBREAD BISCUITS 330 GM',9,'single',19,353,5,NULL,NULL,'exclusive',495,570,1,1,'8410376039702','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:30:09','2019-07-18 16:30:09',NULL),(2288,'HARIBO GOLDBEARS GUM 100GM',9,'single',19,263,22,NULL,NULL,'exclusive',285,330,1,1,'8691216020696','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:40:38','2019-07-18 16:40:38',NULL),(2289,'HARIBO HAPPY COLA SOUR GUM 100 GM',9,'single',19,263,22,NULL,NULL,'exclusive',285,330,1,1,'8691216020818','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:41:57','2019-07-18 16:41:57',NULL),(2290,'HEINZ TARTAR SAUCE 220 ML',9,'single',19,13,32,NULL,NULL,'exclusive',390,450,1,1,'5000157074218','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:44:36','2019-07-18 16:44:36',NULL),(2291,'Hellmann\'s Garlic & Herb Sauce 250ml',9,'single',19,354,32,NULL,NULL,'exclusive',435,500,1,1,'8712100891908','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:47:09','2019-07-18 16:47:09',NULL),(2292,'Hellmann\'s Roasted Garlic Mayonnaise 250ml',9,'single',19,354,25,NULL,NULL,'exclusive',435,500,1,1,'8712566065714','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:48:44','2019-07-18 16:48:44',NULL),(2293,'Hellmann\'s Real Mayonnaise 250ml',9,'single',19,354,25,NULL,NULL,'exclusive',435,500,1,1,'8711200576425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:49:54','2019-07-18 16:49:54',NULL),(2294,'Hellmann\'s  Chilli Mayonnaise 250ml',9,'single',19,354,25,NULL,NULL,'exclusive',435,500,1,1,'8712566067916','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:51:30','2019-07-18 16:51:30',NULL),(2295,'MAMA BEEF FLAVOUR CUP NOODLES 70GM',9,'single',19,355,27,NULL,NULL,'exclusive',140,160,1,1,'8850987123429','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:54:38','2019-07-18 16:54:38',NULL),(2296,'MAMA CHICKEN FLAVOUR CUP NOODLES 70GM',9,'single',19,355,27,NULL,NULL,'exclusive',140,160,1,1,'8850987123412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:55:50','2019-07-18 16:55:50',NULL),(2297,'MAMA CHICKEN FLAVOUR NOODLES 90GM',9,'single',19,355,27,NULL,NULL,'exclusive',115,135,1,1,'8850987128561','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 16:57:42','2019-07-18 16:57:42',NULL),(2298,'MAMA HOT & SPICY ORIENTAL NOODLES 90GM',9,'single',19,355,27,NULL,NULL,'exclusive',115,135,1,1,'8850987131264','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:03:07','2019-07-18 17:03:07',NULL),(2299,'MAMA KIMCHI FLAVOUR ORIENTAL NOODLES 90GM',9,'single',19,355,27,NULL,NULL,'exclusive',115,135,1,0,'8850987131240','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:04:54','2019-07-18 17:04:54',NULL),(2300,'MAMA SHRIMP CREAMY TOM YUM FLAVOUR NOODLES 90GM',9,'single',19,355,27,NULL,NULL,'exclusive',115,135,1,1,'8850987128547','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:06:58','2019-07-18 17:06:58',NULL),(2301,'MAMA SHRIMP TOM YUM FLAVOUR CUP NOODLES 70GM',9,'single',19,355,27,NULL,NULL,'exclusive',140,160,1,1,'8850987123528','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:08:01','2019-07-18 17:08:01',NULL),(2302,'MAMA SHRIMP TOM YUM FLAVOUR NOODLES 90GM',9,'single',19,355,27,NULL,NULL,'exclusive',115,135,1,1,'8850987131776','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:09:37','2019-07-18 17:09:37',NULL),(2303,'NANDOS PERI-PERI COAT & COOK HOT 120GM',9,'single',19,356,32,NULL,NULL,'exclusive',285,335,1,1,'6003770003954','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:12:11','2019-07-18 17:12:11',NULL),(2304,'OREO CHOCO BROWNIA BISCUITS 154GM',9,'single',19,87,5,NULL,NULL,'exclusive',230,265,1,1,'7622210693303','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:13:59','2019-07-18 17:13:59',NULL),(2305,'OREO DOUBLE CREAM BISCUITS 157GM',9,'single',19,87,5,NULL,NULL,'exclusive',230,265,1,1,'7622210148483','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:27:38','2019-07-18 17:27:38',NULL),(2306,'OREO GOLDEN BISCUITS 154GM',9,'single',19,87,5,NULL,NULL,'exclusive',230,265,1,1,'7622210464729','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:29:31','2019-07-18 17:29:31',NULL),(2307,'OREO ORIGINAL BISCUITS 154GM',9,'single',19,87,5,NULL,NULL,'exclusive',230,265,1,1,'7622300315283','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:30:38','2019-07-18 17:30:38',NULL),(2308,'OREO STRAWBERRY BISCUITS 154GM',9,'single',19,87,5,NULL,NULL,'exclusive',230,265,1,1,'7622210635105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:33:25','2019-07-18 17:33:25',NULL),(2309,'RITZ BAKERY ORIGINAL 200GM',9,'single',19,278,42,NULL,NULL,'exclusive',425,490,1,1,'7622210157324','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:38:42','2019-07-18 17:38:42',NULL),(2310,'TESCO DIGESTIVES BISCUITS 400GM',9,'single',19,357,5,NULL,NULL,'exclusive',370,425,1,1,'5052004062466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:40:09','2019-07-18 17:40:09',NULL),(2311,'TESCO PEANUT COOKIES 200GM',9,'single',19,357,18,NULL,NULL,'exclusive',395,460,1,1,'5057545985007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:41:32','2019-07-18 17:41:32',NULL),(2312,'TESCO S ROCK SALT GRINDER 100GM',9,'single',19,357,80,NULL,NULL,'exclusive',600,690,1,1,'5054269552034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:43:56','2019-07-18 17:43:56',NULL),(2313,'TESCO THOUSAND ISLAND DRESSING 250 ML',9,'single',19,357,32,NULL,NULL,'exclusive',355,410,1,1,'5051622956102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:45:37','2019-07-18 17:45:37',NULL),(2314,'TRIDENT SUGAR FREE SPEARMINT 27GM',9,'single',19,109,22,NULL,NULL,'exclusive',205,240,1,1,'50098798','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:47:26','2019-07-18 17:47:26',NULL),(2315,'TRIDENT SUGAR FREE TROPICAL TWIST 27GM',9,'single',19,109,22,NULL,NULL,'exclusive',205,240,1,1,'50075058','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:49:07','2019-11-11 20:34:23',NULL),(2316,'WRIGLEYS EXTRA PEPPERMINT 5 PACK 70GM',9,'single',19,130,22,NULL,NULL,'exclusive',380,440,1,1,'4009900362849','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 17:50:45','2019-07-18 17:50:45',NULL),(2317,'Hosen Honey 1 kg',9,'single',19,14,56,NULL,NULL,'exclusive',530,600,1,1,'8888192901853','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 18:51:17','2020-06-24 15:25:25',NULL),(2318,'Hosen Honey 500 gm',9,'single',19,14,56,NULL,NULL,'exclusive',300,350,1,1,'8888192901860','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-18 18:55:09','2020-06-24 15:26:50',NULL),(2319,'Cadbury perk 13gm',9,'single',19,129,NULL,NULL,NULL,'exclusive',12,20,1,1,'8901233024042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-19 19:56:34','2019-07-19 19:56:34',NULL),(2320,'Safari 12 gm',9,'single',19,358,55,NULL,NULL,'exclusive',12,20,1,1,'8903361329839','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-19 20:00:15','2019-07-19 20:00:15',NULL),(2321,'cadbury bourn vita biscuits',9,'single',19,129,5,NULL,NULL,'exclusive',23,30,1,1,'8901233034409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-19 20:04:45','2019-07-19 20:04:45',NULL),(2322,'Gatorade Quiet Storm 515 gm',9,'single',19,288,24,NULL,NULL,'exclusive',120,170,1,1,'9556404115525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 14:35:23','2019-07-20 19:39:09',NULL),(2323,'Hershey\'s Chocolate Syrup 680gm',9,'single',19,111,36,NULL,NULL,'exclusive',360,420,1,1,'03431209','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 14:37:52','2020-09-27 18:31:04',NULL),(2324,'Hershey\'s Strawberry Syrup 623gm',9,'single',19,111,36,NULL,NULL,'exclusive',330,380,1,1,'03431801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 14:39:23','2020-09-07 19:45:57',NULL),(2325,'Nescafe Classic 50gm',9,'single',19,138,16,NULL,NULL,'exclusive',165,190,1,1,'7891000312704','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 14:44:16','2019-07-20 14:44:16',NULL),(2326,'Nescafe Classic 100gm',9,'single',19,138,16,NULL,NULL,'exclusive',285,330,1,1,'7891000085349','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 14:45:11','2019-07-20 14:45:11',NULL),(2327,'Nestle Milo 1kg',9,'single',19,63,52,NULL,NULL,'exclusive',655,760,1,1,'9556001004673','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 14:51:55','2019-07-20 14:51:55',NULL),(2328,'Multigrain Flakes Natur 750gm',9,'single',19,359,21,NULL,NULL,'exclusive',630,710,1,1,'4008713708066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-20 15:07:31','2019-07-20 15:08:49',NULL),(2329,'Skittles fruit  196gm',9,'single',19,126,15,NULL,NULL,'exclusive',375,450,1,1,'4009900525978','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:24:33','2019-07-22 14:24:33',NULL),(2330,'Skittles crazy sour 45gm',9,'single',19,126,15,NULL,NULL,'exclusive',90,116,1,1,'4009900522106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:25:42','2019-07-22 14:25:42',NULL),(2331,'Kit Kat 4 finger 41.5gm',9,'single',19,63,15,NULL,NULL,'exclusive',65,95,1,1,'40345116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:37:46','2019-07-22 14:37:46',NULL),(2332,'M&m peanut jar 100gm',9,'single',19,127,15,NULL,NULL,'exclusive',285,400,1,1,'6914973603448','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:39:58','2019-07-22 14:39:58',NULL),(2333,'M&m chocolate jar 100gm',9,'single',19,127,15,NULL,NULL,'exclusive',285,400,1,1,'6914973603424','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:40:40','2019-07-22 14:40:40',NULL),(2334,'Haribo Berries 160gm',9,'single',19,360,15,NULL,NULL,'exclusive',315,350,1,1,'8691216025080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:42:17','2019-07-22 14:42:17',NULL),(2335,'Nestle kit Kat single 152gm',9,'single',19,63,15,NULL,NULL,'exclusive',470,550,1,1,'3800020456484','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:43:17','2019-09-29 15:02:19',NULL),(2336,'M & m tube 37 g',9,'single',19,127,15,NULL,NULL,'exclusive',120,145,1,1,'04051806','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:44:08','2019-07-22 14:44:08',NULL),(2337,'Raffaello t 15  150gm',9,'single',19,215,15,NULL,NULL,'exclusive',575,700,1,1,'8000500023976','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:45:24','2019-07-22 14:45:24',NULL),(2338,'Snickers peanut butter 50.5g',9,'single',19,120,15,NULL,NULL,'exclusive',115,145,1,1,'040000546856','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 14:46:58','2020-09-17 17:15:44',NULL),(2339,'Mamy Poko Pants Boys M-64',9,'single',19,275,68,NULL,NULL,'exclusive',1720,2500,1,1,'8851111401093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:36:24','2019-07-22 19:36:24',NULL),(2340,'Mamy Poko Pants Girls M-64',9,'single',19,275,68,NULL,NULL,'exclusive',1720,2500,1,1,'8993189273377','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:38:01','2019-07-22 19:38:01',NULL),(2341,'Mamy Poko Pants Boys L-52',9,'single',19,275,68,NULL,NULL,'exclusive',1720,2500,1,1,'8851111401628','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:38:56','2019-07-22 19:38:56',NULL),(2342,'LATINA 100% APPLE JUICE 1 LIT',9,'single',19,361,24,NULL,NULL,'exclusive',138,150,1,1,'846656011676','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:39:45','2019-07-22 19:39:45',NULL),(2343,'Mamy Poko Pants Girls L-52',9,'single',19,275,68,NULL,NULL,'exclusive',1720,2500,1,1,'8851111401635','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:39:46','2019-07-22 19:39:46',NULL),(2344,'Mamy Poko Pants Boys XL-46',9,'single',19,275,68,NULL,NULL,'exclusive',1720,2500,1,1,'8851111401727','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:41:08','2019-07-22 19:41:08',NULL),(2345,'Mamy Poko Pants Girls XL-46',9,'single',19,275,68,NULL,NULL,'exclusive',1720,2500,1,1,'8851111401734','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-22 19:42:08','2019-07-22 19:42:08',NULL),(2346,'Hosen Peaches Half in Syrup 825gm (SD)',9,'single',19,14,43,NULL,NULL,'exclusive',185,185,1,1,'100063','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:00:43','2019-07-24 14:00:43',NULL),(2347,'Hosen Coconut Milk Light 400ml (SD)',9,'single',19,14,26,NULL,NULL,'exclusive',50,105,1,1,'100064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:03:31','2019-07-24 14:03:31',NULL),(2348,'Hosen Coconut Milk Rich & Creamy 400ml (SD)',9,'single',19,14,26,NULL,NULL,'exclusive',75,165,1,1,'100065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:04:49','2019-07-24 14:04:49',NULL),(2349,'Hosen Mushroom Choice Whole 184gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',45,125,1,1,'100066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:07:02','2019-07-24 14:07:02',NULL),(2350,'Hosen Bamboo Shoot 552gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',60,145,1,1,'100067','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:09:33','2019-07-24 14:09:33',NULL),(2351,'Hosen Longan in Syrup 234gm (SD)',9,'single',19,14,43,NULL,NULL,'exclusive',70,180,1,1,'100068','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:11:07','2019-07-24 14:11:07',NULL),(2352,'Hosen Sardine in Tomato Sauce 425gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',90,280,1,1,'100069','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:12:49','2019-07-24 14:12:49',NULL),(2353,'Hosen Garbanzo Beans Chick Peas 425gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',80,180,1,1,'100070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:15:17','2019-07-24 14:15:17',NULL),(2354,'Hosen Mushroom Bailing- 815gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',150,400,1,1,'100071','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:16:51','2019-07-24 14:16:51',NULL),(2355,'Hosen Fruit Cocktail Fiesta in Syrup 836gm (SD)',9,'single',19,14,43,NULL,NULL,'exclusive',90,250,1,1,'100072','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:19:39','2019-07-24 14:19:39',NULL),(2356,'Hosen Asparagus 430gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',150,340,1,1,'100073','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:23:09','2019-07-24 14:23:09',NULL),(2357,'Hosen Apricots Half in Syrup 825gm (SD)',9,'single',19,14,43,NULL,NULL,'exclusive',150,330,1,1,'100074','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:24:58','2019-07-24 14:24:58',NULL),(2358,'S&W Pear Halves in Syrup-825gm (SD)',9,'single',19,27,43,NULL,NULL,'exclusive',175,390,1,1,'100075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:40:11','2019-07-24 14:40:11',NULL),(2359,'S&W Butter Beans 425gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',135,300,1,1,'100076','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:43:27','2019-07-24 14:43:27',NULL),(2360,'S&W Peach Halves Extra Firm In Syrup 420gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',70,155,1,1,'100077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:45:48','2019-07-24 14:45:48',NULL),(2361,'S&W Whole Kernel Corn 432gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',70,165,1,1,'100078','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:47:33','2019-07-24 14:47:33',NULL),(2362,'S&W Dark Sweet Cherries in Heavy Syrup 439gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',180,465,1,1,'100079','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:58:14','2019-07-24 14:58:14',NULL),(2363,'S&W Whole Peeled Tomatoes 411gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',70,155,1,1,'100080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 14:59:41','2019-07-24 14:59:41',NULL),(2364,'S & W Pinto Beans 425gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',110,250,1,1,'100081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 15:01:13','2019-07-24 15:01:13',NULL),(2365,'S&W Chili Beans 439gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',135,300,1,1,'100082','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:45:23','2019-07-24 16:45:23',NULL),(2366,'S&W Cranberry Sauce 397gm (SD)',9,'single',19,27,32,NULL,NULL,'exclusive',230,515,1,1,'100083','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:46:29','2019-07-24 16:46:29',NULL),(2367,'S&W Orchard Fruit Cocktail in Heavy Syrup 420gm (SD)',9,'single',19,27,43,NULL,NULL,'exclusive',180,245,1,1,'100084','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:47:44','2019-07-24 16:47:44',NULL),(2368,'S&W Distelled White Vinegar 473ml (SD)',9,'single',19,27,39,NULL,NULL,'exclusive',95,210,1,1,'100085','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:49:11','2019-07-24 16:49:11',NULL),(2369,'S&W Crushed Tomatoes 794gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',110,275,1,1,'100086','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:50:10','2019-07-24 16:50:10',NULL),(2370,'Del Monte Yellow Sliced Peaches in Heavy Syrup-825gm (SD)',9,'single',19,8,43,NULL,NULL,'exclusive',160,360,1,1,'100087','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:51:03','2019-07-24 16:51:03',NULL),(2371,'Del Monte Pear Halves in Heavy Syrup-432gm (SD)',9,'single',19,8,43,NULL,NULL,'exclusive',115,255,1,1,'100088','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 16:55:13','2019-07-24 16:55:13',NULL),(2372,'Del Monte Sweet Peas  425gm (SD)',9,'single',19,8,11,NULL,NULL,'exclusive',75,167,1,1,'100089','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:03:18','2019-07-24 17:03:18',NULL),(2373,'Del Monte Whole Kernel Corn 432gm (SD)',9,'single',19,8,11,NULL,NULL,'exclusive',60,135,1,1,'100090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:07:07','2019-07-24 17:07:07',NULL),(2374,'Del Monte Yellow Peach Halves In Heavy Syrup 825gm (SD)',9,'single',19,8,43,NULL,NULL,'exclusive',160,360,1,1,'100091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:08:23','2019-07-24 17:08:23',NULL),(2375,'Del Monte Yellow Sliced Peaches in Heavy Syrup-825gm',9,'single',19,8,43,NULL,NULL,'exclusive',160,360,1,1,'100092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:09:16','2019-07-24 17:09:16',NULL),(2376,'Del Monte Fiesta Fruit Cocktail  850gm (SD)',9,'single',19,8,43,NULL,NULL,'exclusive',100,240,1,1,'100093','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:11:30','2019-07-24 17:11:30',NULL),(2377,'Del Monte Prune Juice 30 Oz (SD)',9,'single',19,8,24,NULL,NULL,'exclusive',300,735,1,1,'100094','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:14:36','2019-07-24 17:14:36',NULL),(2378,'Virginia Chick Peas 400gm (SD)',9,'single',19,204,11,NULL,NULL,'exclusive',135,135,1,1,'100102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:16:00','2019-07-24 17:16:00',NULL),(2379,'Vitalia Strawberry Jam Diet 370gm (SD)',9,'single',19,1,23,NULL,NULL,'exclusive',180,465,1,1,'100097','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:17:16','2019-07-24 17:17:16',NULL),(2380,'Vitalia Apricot Jam Diet 370gm (SD)',9,'single',19,1,23,NULL,NULL,'exclusive',180,400,1,1,'100098','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:18:15','2019-07-24 17:18:15',NULL),(2381,'Peacock Rice Vermicelli 300gm (SD)',9,'single',19,23,27,NULL,NULL,'exclusive',90,200,1,1,'100100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 17:20:22','2019-07-24 17:20:22',NULL),(2382,'Lazzat Biryani Masala 50gm',9,'single',19,363,66,NULL,NULL,'exclusive',75,82,1,1,'654561032279','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:00:59','2019-07-24 20:04:46',NULL),(2383,'Lazzat Tandoori Chicken BBQ Masala 50gm',9,'single',19,363,66,NULL,NULL,'exclusive',75,82,1,1,'654561032293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:03:44','2019-07-24 20:05:53',NULL),(2384,'Lazzat Chaat Masala 50gm',9,'single',19,363,66,NULL,NULL,'exclusive',75,82,1,1,'654561032446','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:06:31','2019-07-24 20:06:31',NULL),(2385,'Lazzat Chili Garlic Sauce 330gm',9,'single',19,363,32,NULL,NULL,'exclusive',170,190,1,1,'654561031562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:07:57','2019-07-24 20:07:57',NULL),(2386,'Lazzat Sweet Chili Sauce 380gm',9,'single',19,363,32,NULL,NULL,'exclusive',170,190,1,1,'654561032804','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:08:47','2019-07-24 20:08:47',NULL),(2387,'Lazzat Tomato Ketchup 330gm',9,'single',19,363,45,NULL,NULL,'exclusive',170,190,1,1,'654561033818','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:09:46','2019-07-24 20:09:46',NULL),(2388,'Perla Adult Diaper M 8 pcs',9,'single',19,364,68,NULL,NULL,'exclusive',610,700,1,1,'8681146510145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:23:31','2019-07-24 20:23:31',NULL),(2389,'Perla Adult Diaper M 30 pcs',9,'single',19,364,68,NULL,NULL,'exclusive',250,2250,1,1,'8681146510077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:24:52','2019-07-24 20:24:52',NULL),(2390,'Perla Adult Diaper L 7 pcs',9,'single',19,364,68,NULL,NULL,'exclusive',610,700,1,1,'8681146510138','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:25:37','2019-07-24 20:25:37',NULL),(2391,'Perla Adult Diaper L 30 pcs',9,'single',19,364,68,NULL,NULL,'exclusive',2300,2300,1,1,'8681146510060','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-24 20:26:53','2019-07-24 20:26:53',NULL),(2392,'Tong Garden Salted Cashew Nuts Pouch 160gm',9,'single',19,177,53,NULL,NULL,'exclusive',430,450,1,1,'8850291211607','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-27 20:34:22','2019-07-27 20:34:22',NULL),(2393,'Tong Garden Salted Cashew Nuts Pouch 400gm',9,'single',19,177,53,NULL,NULL,'exclusive',1065,1100,1,1,'8850291100512','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-27 20:36:10','2019-07-27 20:36:10',NULL),(2394,'Tong Garden Salted Cocktail Nuts Pouch 160gm',9,'single',19,177,53,NULL,NULL,'exclusive',430,450,1,1,'8850291101175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-27 20:37:43','2019-07-27 20:37:43',NULL),(2395,'Tong Garden Salted Cocktail Nuts Pouch 400gm',9,'single',19,177,53,NULL,NULL,'exclusive',1065,1100,1,1,'8850291100529','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-27 20:46:08','2019-07-27 20:46:08',NULL),(2396,'Tong Garden Wasabi Green Peas Can 180gm',9,'single',19,177,53,NULL,NULL,'exclusive',200,220,1,1,'8850291102165','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-27 21:19:51','2019-07-27 21:19:51',NULL),(2397,'Tong Garden Salted Peanut Pouch 160gm',9,'single',19,177,53,NULL,NULL,'exclusive',265,280,1,1,'8850291111808','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 13:55:01','2019-07-28 13:55:01',NULL),(2398,'Tong Garden Salted Peanut Pouch 400gm',9,'single',19,177,53,NULL,NULL,'exclusive',650,680,1,1,'8850291100437','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 13:55:44','2019-12-14 21:09:20',NULL),(2399,'Tong Garden Party Snack Pouch 500gm',9,'single',19,177,53,NULL,NULL,'exclusive',650,680,1,1,'8850291100499','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 13:56:29','2019-07-28 13:56:29',NULL),(2400,'Pasta Zara Chifferi Rigati 500gm',9,'single',19,324,30,NULL,NULL,'exclusive',155,180,1,1,'8004350130556','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 13:57:49','2019-07-28 13:57:49',NULL),(2401,'Pasta Zara Penne Rigate 500gm',9,'single',19,324,30,NULL,NULL,'exclusive',155,180,1,1,'8004350130495','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 13:59:01','2019-07-28 13:59:01',NULL),(2402,'Pasta Zara Spaghetti 500gm',9,'single',19,324,30,NULL,NULL,'exclusive',155,180,1,1,'8004350130037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:00:02','2019-07-28 14:00:02',NULL),(2403,'Maggi Noodles Masala 744gm (12X62)',9,'single',19,63,27,NULL,NULL,'exclusive',195,195,1,1,'8941100294857','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:09:26','2019-09-28 17:39:43',NULL),(2404,'Nescafe Classic  200gm',9,'single',19,138,16,NULL,NULL,'exclusive',330,350,1,1,'8901058826784','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:12:44','2019-07-28 14:12:44',NULL),(2405,'BATCHELORS CUP SOUP CHICKEN  81GM',9,'single',19,365,63,NULL,NULL,'exclusive',330,380,1,1,'5000354911514','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:26:14','2019-07-28 14:26:14',NULL),(2406,'BATCHELORS CUP SOUP CREAM OF VEGETABLE 122GM',9,'single',19,365,63,NULL,NULL,'exclusive',330,380,1,1,'5000354911538','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:27:41','2019-07-28 14:27:41',NULL),(2407,'BATCHELORS  CUP SOUP TOMATO  93GM',9,'single',19,365,63,NULL,NULL,'exclusive',330,380,1,1,'5000354911484','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:28:39','2019-07-28 14:28:39',NULL),(2408,'CHUPA CHUP LOLLYS',9,'single',19,148,57,NULL,NULL,'exclusive',30,35,1,1,'8410031918700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:33:27','2019-09-09 15:58:58',NULL),(2409,'DORITOS HOT SALSA 300gm',9,'single',19,194,32,NULL,NULL,'exclusive',545,630,1,1,'5000328601380','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:35:22','2019-07-28 14:35:22',NULL),(2410,'DORITOS SOUR CREAM 300G',9,'single',19,194,41,NULL,NULL,'exclusive',545,630,1,1,'5000328637327','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:36:47','2019-07-28 14:36:47',NULL),(2411,'Hellmans Chunky Burger Sauce 250ml',9,'single',19,354,32,NULL,NULL,'exclusive',460,530,1,1,'8712100891779','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:38:00','2019-07-28 14:38:00',NULL),(2412,'MC-VITIES DIGESTIVE BISCUITS ORIGINAL 400 GM',9,'single',19,366,5,NULL,NULL,'exclusive',460,530,1,1,'5000168199474','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:50:49','2019-07-28 14:50:49',NULL),(2413,'MC-VITES RICH TEA CLASSICS 300GM',9,'single',19,366,5,NULL,NULL,'exclusive',345,400,1,0,'5000168199511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:52:44','2019-07-28 14:52:44',NULL),(2414,'Oreo Original 66gm',9,'single',19,87,5,NULL,NULL,'exclusive',155,180,1,1,'7622300160692','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:54:17','2019-07-28 14:54:17',NULL),(2415,'REESES 3 PEANUT BUTTER CUPS 51GM',9,'single',19,367,15,NULL,NULL,'exclusive',250,290,1,1,'034000440887','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:56:01','2019-07-28 14:56:01',NULL),(2416,'REESES NUT BAR 47G',9,'single',19,367,15,NULL,NULL,'exclusive',230,265,1,1,'034000109197','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:57:26','2019-07-28 14:57:26',NULL),(2417,'REESES STICK 42GM',9,'single',19,367,15,NULL,NULL,'exclusive',250,290,1,1,'034000151271','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 14:58:10','2019-07-28 14:58:10',NULL),(2418,'TESCO FAT FREE VINAIGER DRESSING 25OML',9,'single',19,357,39,NULL,NULL,'exclusive',370,425,1,1,'5054775702305','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 15:00:10','2019-07-28 15:00:10',NULL),(2419,'TESCO HONEY  & MUSTARD DRESSING 250 ML',9,'single',19,357,32,NULL,NULL,'exclusive',370,425,1,1,'5051622956126','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 15:01:12','2019-07-28 15:01:12',NULL),(2420,'pauls whipping cream 250 ml',9,'single',19,142,51,NULL,NULL,'exclusive',275,300,1,1,'9310036041085','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 19:07:45','2019-07-28 19:07:45',NULL),(2421,'Golden Cricle apple Juice 1 Lit',9,'single',19,141,24,NULL,NULL,'exclusive',340,380,1,1,'9310179088299','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-28 19:14:13','2019-07-28 19:14:13',NULL),(2422,'mars 33gm russia',9,'single',19,125,15,NULL,NULL,'exclusive',52,60,1,1,'6294001813392','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:21:27','2019-07-30 15:21:27',NULL),(2423,'nestle kitkat 40gm',9,'single',19,63,15,NULL,NULL,'exclusive',90,110,1,1,'3800020432259','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:24:46','2019-07-30 15:24:46',NULL),(2424,'Heinz fruity medley custard (4+ month)',9,'single',19,13,64,NULL,NULL,'exclusive',530,600,1,1,'5000157140005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:31:04','2019-07-30 15:31:04',NULL),(2425,'Heinz fruity medley custard (4+ month)',9,'single',19,13,64,NULL,NULL,'exclusive',530,600,1,1,'5000157140005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:31:05','2019-07-30 15:31:05',NULL),(2426,'heinz Apple & oat pudding (4+month)',9,'single',19,13,59,NULL,NULL,'exclusive',530,600,1,1,'5000157140036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:39:47','2019-07-30 15:39:47',NULL),(2427,'heinz Apple & oat pudding (4+month)',9,'single',19,13,59,NULL,NULL,'exclusive',530,600,1,1,'5000157140036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:39:49','2019-07-30 15:39:49',NULL),(2428,'Heinz Fruity banana custard (4+ month)',9,'single',19,13,64,NULL,NULL,'exclusive',530,600,1,1,'5000157079992','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:41:40','2019-07-30 15:41:40',NULL),(2429,'heinz  apple & strawberry  100gm (4+month)',9,'single',19,13,64,NULL,NULL,'exclusive',195,250,1,1,'5000157140081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:46:17','2019-07-30 15:46:17',NULL),(2430,'heinz  apple & strawberry  100gm (4+month)',9,'single',19,13,64,NULL,NULL,'exclusive',195,250,1,1,'5000157140081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:46:19','2019-07-30 15:46:19',NULL),(2431,'heinz  apple & Blueberries  100gm (4+month)',9,'single',19,13,64,NULL,NULL,'exclusive',195,250,1,1,'5000157079923','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:49:47','2019-07-30 15:49:47',NULL),(2432,'Farley,s biscotti Strawberry & peach 60gm',9,'single',19,368,64,NULL,NULL,'exclusive',200,295,1,1,'5000157076878','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 15:54:31','2019-07-30 15:54:31',NULL),(2433,'Heinz golden Multigrain biscotti snack 60gm',9,'single',19,13,64,NULL,NULL,'exclusive',200,295,1,1,'5000157075604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 16:00:27','2019-07-30 16:00:27',NULL),(2434,'Heinz golden Multigrain biscotti snack 60gm',9,'single',19,13,64,NULL,NULL,'exclusive',200,295,1,1,'5000157075604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 16:00:28','2019-07-30 16:00:28',NULL),(2435,'Heinz apple Biscotti 60gm',9,'single',19,13,64,NULL,NULL,'exclusive',200,295,1,1,'5000157067845','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 16:01:42','2019-07-30 16:01:42',NULL),(2436,'Kinder Chocolate 400gm',9,'single',19,69,15,NULL,NULL,'exclusive',1140,1300,1,1,'8000500051795','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 16:11:38','2019-07-30 16:11:38',NULL),(2437,'maltesers 175gm',9,'single',19,65,15,NULL,NULL,'exclusive',460,550,1,1,'5000159031103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 17:01:14','2019-07-30 17:01:14',NULL),(2438,'galaxy crispy chocolate 36 gm',9,'single',19,110,15,NULL,NULL,'exclusive',105,120,1,1,'6294001800279','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 17:13:17','2019-08-31 15:58:34',NULL),(2439,'kitkia all about you 43 gm',9,'single',19,63,15,NULL,NULL,'exclusive',140,160,1,1,'6294003571030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 17:23:16','2019-07-30 17:23:16',NULL),(2440,'kitkia all about you 43 gm',9,'single',19,63,15,NULL,NULL,'exclusive',140,160,1,1,'6294003571030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 17:23:17','2019-07-30 17:23:17',NULL),(2441,'Twix  25 gm egypt',9,'single',19,124,15,NULL,NULL,'exclusive',53,70,1,1,'5000159459273','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 17:44:19','2019-07-30 17:44:19',NULL),(2442,'Nuttella Chocolate Spread 680gm',9,'single',19,132,41,NULL,NULL,'exclusive',630,730,1,1,'8000500220412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 19:28:35','2019-07-30 19:28:35',NULL),(2443,'Ocean Spray Cranberry Classic Juice 1.5 Ltr',9,'single',19,369,24,NULL,NULL,'exclusive',480,560,1,1,'9331200430535','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 19:30:59','2019-07-30 19:30:59',NULL),(2444,'Nescafe Gold Rich & Smooth   200gm',9,'single',19,138,16,NULL,NULL,'exclusive',690,800,1,1,'8801055706426','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 19:34:33','2019-07-30 19:34:33',NULL),(2445,'Crown Almond Nut 250gm',9,'single',19,299,53,NULL,NULL,'exclusive',250,250,1,1,'120001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 20:47:38','2019-07-30 20:47:38',NULL),(2446,'Crown Almond Nut 500gm',9,'single',19,299,53,NULL,NULL,'exclusive',500,500,1,1,'120002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 20:48:52','2019-07-30 20:48:52',NULL),(2447,'Crown Almond Nut 100gm',9,'single',19,299,53,NULL,NULL,'exclusive',100,100,1,1,'120003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 20:50:29','2019-07-30 20:50:29',NULL),(2448,'Elephant Unsalted Cashew Nut 250gm',9,'single',19,370,53,NULL,NULL,'exclusive',300,300,1,1,'120004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 20:58:42','2019-07-30 20:58:42',NULL),(2449,'Elephant Unsalted Cashe Nut 400gm',9,'single',19,370,53,NULL,NULL,'exclusive',480,480,1,1,'120005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:00:01','2019-07-30 21:00:01',NULL),(2450,'Elephant Unsalted Cashwe Nut 100gm',9,'single',19,370,53,NULL,NULL,'exclusive',120,120,1,1,'120006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:01:04','2019-07-30 21:01:04',NULL),(2451,'Mumtaz Pistachio 200gm',9,'single',19,371,53,NULL,NULL,'exclusive',500,500,1,1,'120007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:02:40','2019-07-30 21:02:40',NULL),(2452,'Mumtaz Pistachio 300gm',9,'single',19,371,53,NULL,NULL,'exclusive',750,750,1,1,'120008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:03:46','2019-08-03 16:13:13',NULL),(2453,'Mumtaz Pistachio 100gm',9,'single',19,371,53,NULL,NULL,'exclusive',250,250,1,1,'120009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:04:42','2019-07-30 21:04:42',NULL),(2454,'Elephant Salted Cashwe Nut 250gm',9,'single',19,370,53,NULL,NULL,'exclusive',350,350,1,1,'120010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:06:03','2019-07-30 21:06:03',NULL),(2455,'Elephant Salted Cashwe Nut 400gm',9,'single',19,370,53,NULL,NULL,'exclusive',560,560,1,1,'120011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:06:54','2019-07-30 21:06:54',NULL),(2456,'Elephant Salted Cashwe Nut 100gm',9,'single',19,370,53,NULL,NULL,'exclusive',140,140,1,1,'120012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:07:54','2019-07-30 21:07:54',NULL),(2457,'Golden Raisins 200gm',9,'single',19,372,50,NULL,NULL,'exclusive',70,70,1,1,'120013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:10:28','2019-07-30 21:10:28',NULL),(2458,'Golden Raisins 300gm',9,'single',19,372,50,NULL,NULL,'exclusive',110,110,1,1,'120014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:11:36','2019-07-30 21:11:36',NULL),(2459,'Golden Raisins 100gm',9,'single',19,372,50,NULL,NULL,'exclusive',40,50,1,1,'120015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:20:15','2019-08-03 15:15:11',NULL),(2460,'Lion Alubokhara 200gm',9,'single',19,373,50,NULL,NULL,'exclusive',75,75,1,1,'120016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:24:24','2019-07-30 21:24:24',NULL),(2461,'Lion Alubokhara 300gm',9,'single',19,373,50,NULL,NULL,'exclusive',105,115,1,1,'120017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:25:43','2019-10-05 01:05:09',NULL),(2462,'Lion Alubokhara 100gm',9,'single',19,373,50,NULL,NULL,'exclusive',40,40,1,1,'120018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:27:26','2019-07-30 21:27:26',NULL),(2463,'Alach Chinabadam 200gm',9,'single',19,273,50,NULL,NULL,'exclusive',50,50,1,1,'120019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:29:18','2020-03-19 14:10:22',NULL),(2464,'Alach Chinabadam 400gm',9,'single',19,273,50,NULL,NULL,'exclusive',100,100,1,1,'120020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:31:00','2020-10-05 18:05:12',NULL),(2465,'Alach Chinabadam 100gm',9,'single',19,273,50,NULL,NULL,'exclusive',25,25,1,1,'120021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:32:28','2019-07-30 21:32:28',NULL),(2466,'California Walnut 250gm',9,'single',19,374,53,NULL,NULL,'exclusive',360,360,1,1,'120022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:34:22','2019-07-30 21:34:22',NULL),(2467,'California Walnut 300gm',9,'single',19,374,53,NULL,NULL,'exclusive',435,435,1,1,'120023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:35:57','2019-07-30 21:35:57',NULL),(2468,'California Walnut 100gm',9,'single',19,374,53,NULL,NULL,'exclusive',150,150,1,1,'120025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:36:39','2019-07-30 21:36:39',NULL),(2469,'Agar Agar Powder 100gm',9,'single',19,375,17,NULL,NULL,'exclusive',250,250,1,1,'120024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-30 21:37:09','2019-07-30 21:37:09',NULL),(2470,'Dairy Milk Silk Fruit & Nut 137gm',9,'single',19,129,15,NULL,NULL,'exclusive',245,285,1,1,'8901233034249','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:06:40','2019-07-31 20:06:40',NULL),(2471,'Dairy Milk Silk Fruit & Nut 55gm',9,'single',19,129,15,NULL,NULL,'exclusive',105,120,1,1,'8901233034225','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:08:33','2019-07-31 20:08:33',NULL),(2472,'Kitkat 18.5gm',9,'single',19,63,15,NULL,NULL,'exclusive',30,40,1,1,'8901058857221','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:10:58','2019-07-31 20:10:58',NULL),(2473,'Kitkat 28.3gm',9,'single',19,63,15,NULL,NULL,'exclusive',40,50,1,1,'8901058857245','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:12:15','2019-07-31 20:12:15',NULL),(2474,'Kitkat 38.3gm',9,'single',19,63,15,NULL,NULL,'exclusive',50,60,1,1,'8901058857269','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:13:31','2019-07-31 20:13:31',NULL),(2475,'Cho Cho Chocolate Bar 12gm',9,'single',19,123,15,NULL,NULL,'exclusive',15,20,1,1,'8992952132507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:17:22','2019-07-31 20:17:22',NULL),(2476,'Nocilla  Chocolate Spread 200gm',9,'single',19,376,41,NULL,NULL,'exclusive',240,250,1,1,'8410014896902','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:20:53','2019-07-31 20:20:53',NULL),(2477,'Sweet Cream Candy 320gm',9,'single',19,377,7,NULL,NULL,'exclusive',285,330,1,1,'6921101219877','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 20:36:51','2019-07-31 20:36:51',NULL),(2478,'Peanut Butter Crunchy 340gm',9,'single',19,378,6,NULL,NULL,'exclusive',310,325,1,1,'6294002406388','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 21:00:55','2019-07-31 21:01:19',NULL),(2479,'Peanut Butter Creamy 340gm',9,'single',19,378,6,NULL,NULL,'exclusive',310,325,1,1,'6294002406340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-07-31 21:02:25','2019-07-31 21:02:25',NULL),(2480,'Nestle kit Kat Wafer 18gm',9,'single',19,63,15,NULL,NULL,'exclusive',30,40,1,1,'89005637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-01 15:01:49','2019-08-01 15:01:49',NULL),(2481,'Moussy Classic Malt Beverage 330ml',9,'single',19,379,4,NULL,NULL,'exclusive',180,200,1,1,'76162817','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-01 16:29:14','2019-08-31 17:45:46',NULL),(2482,'Glory Adult Pants M (10 pcs)',9,'single',19,224,68,NULL,NULL,'exclusive',750,860,1,1,'6941326208937','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 00:04:43','2019-08-04 00:04:43',NULL),(2483,'Love Baby Maxi 7-18kg L(50)',9,'single',19,226,68,NULL,NULL,'exclusive',950,1260,1,1,'8941133200825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 00:07:58','2019-08-04 00:07:58',NULL),(2484,'Love Baby Diaper  XXL 16-30 kg (44 pcs)',9,'single',19,226,68,NULL,NULL,'exclusive',950,1260,1,1,'8941133200818','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 00:10:14','2020-07-21 17:57:40',NULL),(2485,'Glory Adult Diaper M (30)',9,'single',19,224,68,NULL,NULL,'exclusive',2160,2600,1,1,'6941326209491','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 00:13:56','2019-08-04 00:13:56',NULL),(2486,'Glory Adult Diaper L (30)',9,'single',19,224,68,NULL,NULL,'exclusive',2720,3200,1,1,'6941326209507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 00:15:14','2019-08-04 00:15:14',NULL),(2487,'American Harvest Basil Seed Drink Mango 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',100,120,1,1,'8855044004765','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 17:28:43','2020-09-08 16:45:20',NULL),(2488,'American Harvest Basil Seed Drink Blueberry 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',100,120,1,1,'8855044006462','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 17:30:09','2020-09-08 16:45:55',NULL),(2489,'American Harvest Basil Seed Drink Orange 290m',9,'single',19,327,24,NULL,NULL,'exclusive',100,120,1,1,'8855044006820','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 17:31:40','2020-10-02 21:46:37',NULL),(2490,'American Harvest Basil Seed Drink Peach 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',100,120,1,1,'8855044004772','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 17:34:20','2019-08-04 17:34:20',NULL),(2491,'American Harvest Basil Seed Drink Apricot 290ml',9,'single',19,327,24,NULL,NULL,'exclusive',100,120,1,1,'8855044006813','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 17:36:26','2019-08-04 17:36:26',NULL),(2492,'cadbury dairy milk  450gm',9,'single',19,129,15,NULL,NULL,'exclusive',780,900,1,1,'7622210478351','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 18:33:59','2019-08-04 18:33:59',NULL),(2493,'Toblerone tiny 200gm',9,'single',19,116,NULL,NULL,NULL,'exclusive',285,300,1,1,'7622200009176','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 18:36:35','2020-09-17 16:01:10',NULL),(2494,'TIFFANY Delights Chocolate Chip Cookies 100gm',9,'single',19,242,18,NULL,NULL,'exclusive',170,200,1,1,'6291003010675','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:05:47','2019-08-04 19:05:47',NULL),(2495,'Tiffany Crunch n Cream Orange wafer153gm',9,'single',19,241,55,NULL,NULL,'exclusive',125,145,1,0,'6291003005626','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:12:49','2019-09-11 00:12:37',NULL),(2496,'Tiffany Whole Wheat Rusks 335gm',9,'single',19,242,78,NULL,NULL,'exclusive',320,360,1,1,'6291003012044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:15:03','2019-08-04 19:15:03',NULL),(2497,'Tiffany Milk Rusks 335gm',9,'single',19,241,78,NULL,NULL,'exclusive',320,360,1,1,'6291003012037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:16:48','2019-08-04 19:16:48',NULL),(2498,'American Green Bee Honey 1kg',9,'single',19,380,56,NULL,NULL,'exclusive',975,1100,1,1,'003004575451','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:19:16','2019-09-02 16:02:34',NULL),(2499,'Allah Shafi Honey 500gm',9,'single',19,381,56,NULL,NULL,'exclusive',515,600,1,1,'4891460223704','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:21:26','2019-08-04 19:21:26',NULL),(2500,'Allah Shafi Honey 250gm',9,'single',19,381,56,NULL,NULL,'exclusive',275,325,1,1,'4891460223742','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:22:54','2019-08-04 19:22:54',NULL),(2501,'Allah Safi Honey Tube 375gm',9,'single',19,381,56,NULL,NULL,'exclusive',400,450,1,1,'4891460223735','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:24:24','2019-08-04 19:24:24',NULL),(2502,'Weetabix 430gm',9,'single',19,330,18,NULL,NULL,'exclusive',460,520,1,1,'5010029000023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:26:02','2019-08-04 19:26:02',NULL),(2503,'Ascel Ghee Pure Butter  800gm',9,'single',19,256,74,NULL,NULL,'exclusive',900,1050,1,1,'631583102562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:28:05','2019-08-04 19:28:05',NULL),(2504,'Quaker White Oats 500gm tin',9,'single',19,99,28,NULL,NULL,'exclusive',230,250,1,1,'5000108943310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:31:22','2019-08-04 19:31:22',NULL),(2505,'Alfa Mayonnaise Tube 500ml',9,'single',19,248,25,NULL,NULL,'exclusive',185,220,1,1,'6291003162947','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:33:16','2019-08-04 19:33:16',NULL),(2506,'Tifffany Faro Crispy Wafer 540gm',9,'single',19,241,55,NULL,NULL,'exclusive',45,50,1,1,'6291003085895','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:35:58','2019-08-04 19:35:58',NULL),(2507,'Mini Biscuits Jar 150gm',9,'single',19,382,5,NULL,NULL,'exclusive',300,350,1,1,'8858223019758','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-04 19:37:39','2019-08-04 19:37:39',NULL),(2508,'GuyLian Belgian Original Sea Shell 65g',9,'single',19,102,15,NULL,NULL,'exclusive',300,335,1,1,'5410976080428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 14:56:57','2019-08-05 14:56:57',NULL),(2509,'GuyLian Belgian Chocolate Opus 90g',9,'single',19,102,15,NULL,NULL,'exclusive',485,535,1,1,'5410976279013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:02:50','2019-08-05 15:02:50',NULL),(2510,'GuyLian Belgian Chocolate Milk 140gm',9,'single',19,102,15,NULL,NULL,'exclusive',660,720,1,1,'5410976452010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:09:35','2019-08-05 15:09:35',NULL),(2511,'GuyLian Belgian Chocolate Sea Horse Selection 154gm',9,'single',19,102,15,NULL,NULL,'exclusive',660,720,1,1,'5410976937012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:12:10','2019-08-05 15:12:10',NULL),(2512,'GuyLian Belgian Chocolate Cranberry Bar 100gm',9,'single',19,102,15,NULL,NULL,'exclusive',345,375,1,1,'5410976807018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:15:20','2019-08-05 15:15:20',NULL),(2513,'GuyLian Belgian Dark  Chocolate Bar 100gm',9,'single',19,102,15,NULL,NULL,'exclusive',345,375,1,1,'5410976821014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:17:00','2019-08-05 15:17:00',NULL),(2514,'GuyLian Belgian Chocolate Milk & Hazelnuts 100gm',9,'single',19,102,15,NULL,NULL,'exclusive',310,340,1,1,'5410976825012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:18:32','2019-08-05 15:18:32',NULL),(2515,'GuyLian Belgian dark 72% Chocolate 100gm',9,'single',19,102,15,NULL,NULL,'exclusive',310,340,1,1,'5410976826019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:21:53','2019-08-05 15:21:53',NULL),(2516,'GuyLian Belgian Milk & Almond Chocolate 100gm',9,'single',19,102,15,NULL,NULL,'exclusive',310,340,1,1,'5410976827016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:28:11','2019-08-05 15:28:11',NULL),(2517,'GuyLian Belgian Cranberry  Chocolate 150gm',9,'single',19,102,15,NULL,NULL,'exclusive',590,645,1,1,'5410976950011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:33:13','2019-08-05 15:33:13',NULL),(2518,'GuyLian Belgian Blueberries  Chocolate 150gm',9,'single',19,102,15,NULL,NULL,'exclusive',590,645,1,1,'5410976951018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:34:35','2019-08-05 15:34:35',NULL),(2519,'GuyLian Belgian Raisins Chocolate 150gm',9,'single',19,102,15,NULL,NULL,'exclusive',590,645,1,1,'5410976952015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:35:46','2019-08-05 15:35:46',NULL),(2520,'GuyLian Belgian Chocolate Master Selection 200gm',9,'single',19,102,15,NULL,NULL,'exclusive',1265,1375,1,1,'5410976172017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:38:29','2019-08-05 15:38:29',NULL),(2521,'GuyLian Belgian Window Box 500gm',9,'single',19,102,15,NULL,NULL,'exclusive',2020,2200,1,1,'5410976040064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:41:27','2019-08-05 15:41:27',NULL),(2522,'GuyLian Belgian Chocolate Classic  430gm',9,'single',19,102,15,NULL,NULL,'exclusive',1885,2050,1,1,'5410976402015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:43:43','2019-08-05 15:43:43',NULL),(2523,'GuyLian Belgian  Chocolate Deluxe Assortment  174gm',9,'single',19,102,15,NULL,NULL,'exclusive',885,965,1,1,'5410976690016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:46:35','2019-08-05 15:46:35',NULL),(2524,'GuyLian Belgian Chocolate Bar 35gm',9,'single',19,102,15,NULL,NULL,'exclusive',110,120,1,1,'5410976980018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:49:35','2019-08-05 15:49:35',NULL),(2525,'GuyLian Belgian Chocolate Original Praline  84gm',9,'single',19,102,15,NULL,NULL,'exclusive',400,430,1,1,'5410976470014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:52:14','2019-08-05 15:52:14',NULL),(2526,'GuyLian Belgian Chocolate Truffle 84gm',9,'single',19,102,15,NULL,NULL,'exclusive',400,430,1,1,'5410976903017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 15:53:38','2019-08-05 15:53:38',NULL),(2527,'Harvey Fresh Lactose Free Full Cream Milk 1Ltr',9,'single',19,332,26,NULL,NULL,'exclusive',250,275,1,1,'9311697100135','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-05 18:11:13','2019-08-05 18:11:13',NULL),(2528,'black bourbon (CHOCO CREAM) 100gm',9,'single',19,383,5,NULL,NULL,'exclusive',70,90,1,1,'8901719112492','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-06 23:01:19','2020-03-12 20:43:02',NULL),(2529,'black bourbon (vanilla)100gm',9,'single',19,383,5,NULL,NULL,'exclusive',70,90,1,1,'8901719112485','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-06 23:02:57','2019-08-06 23:02:57',NULL),(2530,'Heart light Canola Oil 3Lt',9,'single',19,384,29,NULL,NULL,'exclusive',1200,1350,1,1,'056128443045','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 02:57:57','2019-08-08 02:57:57',NULL),(2531,'Gota de Oro extra virgin olive oil 500 ML',9,'single',19,385,29,NULL,NULL,'exclusive',460,480,1,1,'8411710661177','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 03:01:18','2019-08-08 03:01:18',NULL),(2532,'Gota de Oro extra virgin olive oil 1 Lt',9,'single',19,385,29,NULL,NULL,'exclusive',820,850,1,1,'8411710661191','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 03:02:23','2019-08-08 03:02:23',NULL),(2533,'Gota de Oro Skin Care Olive Oil 100 ML',9,'single',19,385,29,NULL,NULL,'exclusive',145,180,1,1,'8411710313502','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 03:03:31','2019-08-08 03:03:31',NULL),(2534,'Only Organic Pear & Mango 120gm',9,'single',19,386,64,NULL,NULL,'exclusive',150,185,1,1,'9403145303196','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 13:51:22','2019-08-08 13:51:22',NULL),(2535,'Praise Balsamic Dressing 330ml',9,'single',19,387,32,NULL,NULL,'exclusive',250,290,1,1,'9310047206282','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 14:02:09','2019-08-08 14:02:09',NULL),(2536,'Praise Italian Dressing 330ml',9,'single',19,387,32,NULL,NULL,'exclusive',250,290,1,1,'9310047206275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 14:03:37','2019-08-08 14:03:37',NULL),(2537,'Lindt Excellence Mint Intense Dark Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,370,1,1,'3046920028752','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:08:58','2019-10-03 17:02:13',NULL),(2538,'Lind Lindor Extra Dark chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400074155','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:11:19','2019-08-08 22:11:19',NULL),(2539,'Lind Excellence A Touch of Sea Salt Dark Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,370,1,1,'3046920029674','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:14:13','2019-10-03 17:01:15',NULL),(2540,'Lindt Hello Milk chocolate hearts 45gm',9,'single',19,214,15,NULL,NULL,'exclusive',415,475,1,1,'4000539221002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:18:42','2019-08-08 22:18:42',NULL),(2541,'Lindt Swiss Classic Drak Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400010108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:24:55','2019-08-08 22:24:55',NULL),(2542,'Lindt Lindor Milk chocolate 100',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400014649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:29:43','2019-08-08 22:29:43',NULL),(2543,'Lindt Extra Creamy Milk chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400010481','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:37:09','2019-08-08 22:37:09',NULL),(2544,'Lindt Mild 70% coca Dark chocolate',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'3046920029780','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:41:18','2019-08-08 22:41:18',NULL),(2545,'Lindt Black Currant dark chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400080552','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:43:21','2019-08-08 22:43:21',NULL),(2546,'Lindt Black Currant dark chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400080552','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:43:22','2019-08-08 22:43:22',NULL),(2547,'Lindt Hello Salted Caramel milk chocolate  100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'4000539224607','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:51:00','2019-08-08 22:51:00',NULL),(2548,'Lindt Swiss classic Dark Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',320,370,1,1,'7610400070188','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:54:19','2019-08-08 22:54:19',NULL),(2549,'Belgian Dark Chocolate 135gm',9,'single',19,333,15,NULL,NULL,'exclusive',400,480,1,1,'5413121361670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 22:56:45','2019-08-08 22:56:45',NULL),(2550,'Belgian Truffle fantasy Filling chocolate 135gm',9,'single',19,333,15,NULL,NULL,'exclusive',400,480,1,1,'5413121361687','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:05:43','2019-08-08 23:05:43',NULL),(2551,'Belgian Original chocolate 135gm',9,'single',19,333,15,NULL,NULL,'exclusive',400,480,1,1,'5413121361694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:09:28','2019-08-08 23:09:28',NULL),(2552,'Belgian Milk Chocolate 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121355105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:14:25','2019-08-08 23:14:25',NULL),(2553,'Belgian NSA Dark Chocolate 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121356737','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:23:21','2019-08-08 23:23:21',NULL),(2554,'belgian NSA Dark With almonds',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121359998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:38:56','2019-08-08 23:38:56',NULL),(2555,'belgian NSA Dark With almonds',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121359998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:38:58','2019-08-08 23:38:58',NULL),(2556,'Belgian Dark 85% chocolate 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121358694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:48:06','2019-08-08 23:48:06',NULL),(2557,'Belgian cocoa Nibs 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121355099','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-08 23:52:00','2019-08-08 23:52:00',NULL),(2558,'Belgian Dark Himalayan salt chocolate 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',300,350,1,1,'5413121362479','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-09 01:15:42','2019-08-09 01:15:42',NULL),(2559,'Lacy\'s Gloves all purpose 100pcs',9,'single',19,46,48,NULL,NULL,'exclusive',245,286,1,1,'8888417002532','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-09 01:38:40','2019-08-09 01:38:40',NULL),(2560,'Camel Coated Green Peas 40gm',9,'single',19,58,53,NULL,NULL,'exclusive',70,85,1,1,'8888112100014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-09 01:43:31','2019-08-09 01:43:31',NULL),(2561,'Camel Roasted Almonds 40gm',9,'single',19,58,53,NULL,NULL,'exclusive',100,120,1,1,'8888112081108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-09 01:48:13','2019-08-09 01:48:13',NULL),(2562,'Belgian Vanilla chocolate 135gm',9,'single',19,333,15,NULL,NULL,'exclusive',410,480,1,1,'5413121361700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-09 01:51:47','2019-08-09 01:51:47',NULL),(2563,'Lindt Lindor 60% cocoa Dark Chocolate 200gm',9,'single',19,214,15,NULL,NULL,'exclusive',740,850,1,1,'8003340091280','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-09 01:54:17','2019-08-09 01:54:17',NULL),(2564,'Hellmans Garlic kabab Sauce 256gm',9,'single',19,354,32,NULL,NULL,'exclusive',440,500,1,1,'8714100673355','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-10 16:27:55','2019-08-10 16:27:55',NULL),(2565,'Oreo Original 154gm',9,'single',19,87,5,NULL,NULL,'exclusive',225,250,1,1,'7622210158789','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-10 16:31:56','2019-08-10 16:31:56',NULL),(2566,'Pedia Sure Vanilla Delight 200gm',9,'single',19,388,64,NULL,NULL,'exclusive',400,411,1,1,'8904145911646','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-10 17:34:30','2019-08-10 17:47:44',NULL),(2567,'Pedia Sure Cookies & Cream Flavour 200gm',9,'single',19,388,64,NULL,NULL,'exclusive',405,414,1,1,'8904145911769','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-10 18:04:17','2019-08-10 18:04:17',NULL),(2568,'Similac (1) 503gm',9,'single',19,388,64,NULL,NULL,'exclusive',650,660,1,1,'8904145911578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-10 18:17:08','2019-08-10 18:17:08',NULL),(2569,'Similac (2) 443gm',9,'single',19,388,64,NULL,NULL,'exclusive',650,658,1,1,'8904145911585','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-10 18:22:27','2020-10-21 14:40:54',NULL),(2570,'Doritos cool ranch 198.4gm',9,'single',19,194,14,NULL,NULL,'exclusive',375,0,1,1,'028400017091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-25 15:22:05','2019-08-25 15:22:05',NULL),(2571,'Nescafe Original Duplo Filter 230gm',9,'single',19,138,16,NULL,NULL,'exclusive',400,0,1,1,'7891000260388','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-28 20:48:23','2019-08-28 20:48:23',NULL),(2572,'Horlicks Original 1kg',9,'single',19,151,60,NULL,NULL,'exclusive',680,0,1,1,'9556019003828','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-28 20:53:35','2019-10-22 22:40:37',NULL),(2573,'ST. Dalfour Four Fruits 284g',9,'single',19,45,23,NULL,NULL,'exclusive',435,0,1,1,'084380957840','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-28 20:57:37','2019-08-28 20:58:53',NULL),(2574,'ST. Dalfour Wild Blueberry  284g',9,'single',19,45,23,NULL,NULL,'exclusive',450,0,1,0,'084380957246','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-28 21:02:02','2019-08-28 21:02:02',NULL),(2575,'ST. Dalfour Strawberry  284g',9,'single',19,45,23,NULL,NULL,'exclusive',450,0,1,1,'084380957444','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-28 21:06:16','2019-08-28 21:06:16',NULL),(2576,'Cadbury Milk Chocolate Spread 400g',9,'single',19,129,15,NULL,NULL,'exclusive',345,0,1,1,'5000183501108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:03:14','2019-08-29 13:03:14',NULL),(2577,'Extra Virgin Coconut oil 250ml',9,'single',19,389,29,NULL,NULL,'exclusive',565,0,1,1,'8906064703692','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:07:13','2019-08-29 13:07:13',NULL),(2578,'Extra Virgin Coconut oil 500ml',9,'single',19,389,29,NULL,NULL,'exclusive',1100,0,1,1,'8906064703456','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:10:54','2019-08-29 13:10:54',NULL),(2579,'Jack n Jill Dewberry Blueberry 36g',9,'single',19,182,5,NULL,NULL,'exclusive',35,0,1,1,'8850309201699','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:20:26','2019-08-29 13:20:26',NULL),(2580,'Jack n Jill Dewberry Strawberry 36g',9,'single',19,182,5,NULL,NULL,'exclusive',35,0,1,1,'8850309201736','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:22:41','2019-08-29 13:22:41',NULL),(2581,'Oyster Sauce Barchun 350ml',9,'single',19,39,32,NULL,NULL,'exclusive',120,0,1,1,'6988209328160','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:28:59','2019-08-29 13:28:59',NULL),(2582,'Hung Sweet Chilli Sauce 340g',9,'single',19,390,32,NULL,NULL,'exclusive',140,0,1,1,'8852633411409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:32:53','2019-08-29 13:32:53',NULL),(2583,'Cadbury 5Star 22.4gm',9,'single',19,129,15,NULL,NULL,'exclusive',20,0,1,1,'8901233028514','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:50:15','2019-08-29 13:50:15',NULL),(2584,'Cadbury Dairy Milk Chocolate 25.3g',9,'single',19,129,15,NULL,NULL,'exclusive',50,0,1,1,'8901233028392','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 13:58:07','2019-08-29 13:58:07',NULL),(2585,'Cadbury Perk 14.3g',9,'single',19,129,15,NULL,NULL,'exclusive',15,0,1,1,'8901233030272','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:03:17','2019-08-29 14:03:17',NULL),(2586,'Cadbury Dairy Milk Chocolate 13.2g',9,'single',19,129,15,NULL,NULL,'exclusive',15,0,1,1,'8901233030548','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:05:48','2019-08-29 14:05:48',NULL),(2587,'Cadbury 5Star 43gm',9,'single',19,129,15,NULL,NULL,'exclusive',50,0,1,1,'8901233030937','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:08:21','2020-02-18 20:40:10',NULL),(2588,'Cadbury Dairy Milk Oreo Chocolate 60g',9,'single',19,129,15,NULL,NULL,'exclusive',120,0,1,1,'8901233033525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:14:29','2020-10-09 19:21:25',NULL),(2589,'Cadbury Dairy Milk Silk Bubbly  Chocolate 50g',9,'single',19,129,15,NULL,NULL,'exclusive',120,0,1,1,'8901233034300','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:17:07','2019-08-29 14:17:07',NULL),(2590,'Cadbury Dairy Milk silk Chocolate 60g',9,'single',19,129,15,NULL,NULL,'exclusive',110,0,1,1,'8901233034188','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:21:17','2019-08-29 14:21:17',NULL),(2591,'Cadbury Bourn Vita 500gm',9,'single',19,129,52,NULL,NULL,'exclusive',420,0,1,1,'8901233035154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:26:25','2019-08-29 14:26:25',NULL),(2592,'Cadbury Bourn Vita 200gm',9,'single',19,129,52,NULL,NULL,'exclusive',195,0,1,1,'8901233035130','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:27:52','2019-08-29 14:27:52',NULL),(2593,'Slim Noodles 9Cal. 270gm',9,'single',19,391,27,NULL,NULL,'exclusive',265,0,1,1,'709112457565','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 14:59:07','2019-08-29 14:59:07',NULL),(2594,'Slim Noodles 35Cal. 200gm',9,'single',19,391,27,NULL,NULL,'exclusive',260,0,1,1,'609728699574','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:01:19','2019-08-29 15:01:19',NULL),(2595,'Slim Fettuccine 9Cal. 270gm',9,'single',19,391,30,NULL,NULL,'exclusive',265,0,1,1,'709112457596','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:03:05','2019-08-29 15:03:05',NULL),(2596,'Slim Fettuccine Pasta 35Cal. 200gm',9,'single',19,391,30,NULL,NULL,'exclusive',260,0,1,1,'609728699666','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:05:09','2019-08-29 15:05:09',NULL),(2597,'Slim Penne Pasta 9Cal. 270gm',9,'single',19,391,30,NULL,NULL,'exclusive',265,0,1,1,'709112457572','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:06:52','2019-08-29 15:06:52',NULL),(2598,'Slim Penne Pasta 35Cal. 200gm',9,'single',19,391,30,NULL,NULL,'exclusive',260,0,1,1,'609728699635','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:08:07','2019-08-29 15:08:07',NULL),(2599,'Slim Spaghetti Pasta 9Cal. 270gm',9,'single',19,391,30,NULL,NULL,'exclusive',260,0,1,1,'709112457589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:09:53','2019-08-29 15:09:53',NULL),(2600,'Slim Spaghetti Pasta 35Cal. 200gm',9,'single',19,391,30,NULL,NULL,'exclusive',260,0,1,1,'609728699659','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:11:10','2019-08-29 15:11:10',NULL),(2601,'Slim Rice 9Cal. 270gm',9,'single',19,391,54,NULL,NULL,'exclusive',265,0,1,1,'709112457237','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:12:32','2019-08-29 15:12:32',NULL),(2602,'Slim Rice 35Cal. 200gm',9,'single',19,391,54,NULL,NULL,'exclusive',260,0,1,1,'609728699611','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:13:46','2019-08-29 15:13:46',NULL),(2603,'Don Simon Strawberry Milkshake 200ml',9,'single',19,9,24,NULL,NULL,'exclusive',50,0,1,1,'01766694503','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:34:09','2019-09-10 21:29:18',NULL),(2604,'V. Crunchy Muesli W Cranberry 600gm',9,'single',19,1,1,NULL,NULL,'exclusive',290,0,1,1,'01766694592','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:36:31','2019-08-29 15:36:31',NULL),(2605,'S&W Chunk Light Tuna Veg. oil 170gm',9,'single',19,27,8,NULL,NULL,'exclusive',260,0,1,1,'011194508074','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:40:18','2019-08-29 15:40:18',NULL),(2606,'H. Mackerel In Tomato Sauce 425g',9,'single',19,14,8,NULL,NULL,'exclusive',260,0,1,1,'8888192801061','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 15:42:06','2019-08-29 15:42:06',NULL),(2607,'Amul Fruite n Nut Dark Chocolate 150gm',9,'single',19,291,15,NULL,NULL,'exclusive',170,0,1,1,'8901262070539','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 17:20:12','2020-07-21 21:36:06',NULL),(2608,'Nut Crisp 500gm',9,'single',19,392,15,NULL,NULL,'exclusive',470,0,1,1,'9556920002392','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 17:43:10','2019-10-29 15:49:08',NULL),(2609,'Lactozen 2 tin 400gm',9,'single',19,63,59,NULL,NULL,'exclusive',600,0,1,1,'8901058865998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 22:30:17','2019-08-29 22:30:17',NULL),(2610,'Lactogen 3 bib 350gm',9,'single',19,63,59,NULL,NULL,'exclusive',480,0,1,1,'8901058865974','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 22:37:50','2019-08-29 22:37:50',NULL),(2611,'nestle nido forti grow 350gm',9,'single',19,63,59,NULL,NULL,'exclusive',255,0,1,1,'8941100293058','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-29 22:53:28','2019-08-29 22:53:28',NULL),(2612,'Cowhead Pure Milk 1lt',9,'single',19,84,26,NULL,NULL,'exclusive',175,0,1,1,'8888440010009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-30 18:35:05','2019-10-05 14:40:40',NULL),(2613,'Heinz So yummy 7+ banna biscuite 60gm',9,'single',19,13,59,NULL,NULL,'exclusive',205,0,1,1,'5000157070609','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 01:50:32','2019-08-31 01:50:32',NULL),(2614,'heinz Strawberry banana biscuite 60gm',9,'single',19,13,64,NULL,NULL,'exclusive',205,0,1,1,'5000157076786','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 02:00:37','2019-08-31 02:00:37',NULL),(2615,'Heinz so yummy chocolate biscotti 60gm',9,'single',19,13,64,NULL,NULL,'exclusive',205,0,1,1,'5000157065759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 02:03:42','2019-08-31 02:03:42',NULL),(2616,'cadburry Milk Tray 360gm',9,'single',19,129,15,NULL,NULL,'exclusive',1000,0,1,1,'7622210432391','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 15:08:28','2019-08-31 15:08:28',NULL),(2617,'Nestle Dairy box 360gm',9,'single',19,63,15,NULL,NULL,'exclusive',1000,0,1,1,'7613034259271','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 15:27:21','2019-08-31 15:27:21',NULL),(2618,'Nestle Dairy box 180 gm',9,'single',19,63,15,NULL,NULL,'exclusive',600,0,1,1,'7613034259301','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 15:29:36','2019-08-31 15:29:36',NULL),(2619,'cadburry fruite & nut 110gm',9,'single',19,129,15,NULL,NULL,'exclusive',210,0,1,1,'7622210644800','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 16:25:40','2019-11-16 21:46:31',NULL),(2620,'cadbury dairy milk carame 120gm',9,'single',19,129,15,NULL,NULL,'exclusive',220,0,1,1,'7622300737931','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 16:30:26','2019-08-31 16:30:26',NULL),(2621,'csadbury dairy milk  110 gm',9,'single',19,129,15,NULL,NULL,'exclusive',220,0,1,1,'7622300845759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-08-31 16:33:40','2019-08-31 16:33:40',NULL),(2622,'Tiara Backing powder 110gm',9,'single',19,393,51,NULL,NULL,'exclusive',76,0,1,1,'5352102085900','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 15:48:27','2019-09-01 15:48:27',NULL),(2623,'Tiara Creme Caramel 50g',9,'single',19,393,51,NULL,NULL,'exclusive',75,0,1,1,'5352102412812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 15:52:13','2019-09-01 15:52:13',NULL),(2624,'Tiara Custard Powder 300gm',9,'single',19,393,51,NULL,NULL,'exclusive',160,0,1,1,'5352102310996','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 15:54:34','2019-09-01 15:54:34',NULL),(2625,'Tiara orange jelly dessert 85gm',9,'single',19,393,51,NULL,NULL,'exclusive',85,0,1,1,'5352102639165','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 15:56:20','2019-09-01 15:56:20',NULL),(2626,'Tiara Strawberry jelly dessert 85gm',9,'single',19,393,51,NULL,NULL,'exclusive',85,0,1,1,'5352102877468','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 15:57:51','2019-09-01 15:57:51',NULL),(2627,'Tiara Vanilla essence 28ml',9,'single',19,393,51,NULL,NULL,'exclusive',58,0,1,1,'5352102801388','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 16:07:43','2020-07-13 20:57:02',NULL),(2628,'Tiara White 500gm',9,'single',19,393,51,NULL,NULL,'exclusive',255,0,1,1,'5352102492104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-01 16:10:32','2019-09-01 16:10:32',NULL),(2629,'Olitalia Extra Virgin Olive Oil 250ml',9,'single',19,176,29,NULL,NULL,'exclusive',270,0,1,1,'8007150901784','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-09 21:23:45','2019-09-09 21:23:45',NULL),(2630,'Chupa Chup Sour Infernal 120gm',9,'single',19,148,15,NULL,NULL,'exclusive',265,0,1,1,'8723400784692','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-09 22:35:43','2019-09-09 22:35:43',NULL),(2631,'Doritos Mild Salsa 300gm',9,'single',19,194,32,NULL,NULL,'exclusive',545,0,1,1,'5000328697796','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-09 22:48:27','2019-09-09 22:48:27',NULL),(2632,'Nando\'s Mayonnaise Hot 265gm',9,'single',19,356,25,NULL,NULL,'exclusive',550,0,1,1,'6003770009154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-09 23:05:10','2019-09-09 23:09:31',NULL),(2633,'NANDOS PERI-PERI COAT & COOK MEDIUM 120GM',9,'single',19,356,25,NULL,NULL,'exclusive',285,0,1,1,'6003770007518','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-09 23:39:30','2019-09-09 23:39:30',NULL),(2634,'NANDOS PERI-PERI COAT & COOK LEMON&HERB 120GM',9,'single',19,356,32,NULL,NULL,'exclusive',285,0,1,1,'6003770003947','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 00:11:10','2019-09-10 00:11:10',NULL),(2635,'NESCAFE GOLD CAPPUCCINO 136GM',9,'single',19,138,16,NULL,NULL,'exclusive',445,0,1,1,'7613036002479','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 00:20:26','2019-09-10 00:20:26',NULL),(2636,'NESCAFE GOLD CARAMEL LATTE 136GM',9,'single',19,138,16,NULL,NULL,'exclusive',445,0,1,1,'7613034309563','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 00:25:27','2019-09-10 00:25:43',NULL),(2637,'NESCAFE GOLD DOUBLE CHOC MOCHA 136GM',9,'single',19,138,16,NULL,NULL,'exclusive',445,0,1,1,'7613034310477','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 00:29:26','2019-09-10 00:29:26',NULL),(2638,'NESCAFE GOLD  LATTE 136GM',9,'single',19,138,16,NULL,NULL,'exclusive',445,0,1,1,'7613034309273','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 00:32:47','2019-09-10 00:39:53',NULL),(2639,'Oreo Peanut Butter  154gm',9,'single',19,87,5,NULL,NULL,'exclusive',230,0,1,1,'7622210449627','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 16:49:40','2019-09-10 16:54:33',NULL),(2640,'TRIDENT SUGAR FREE STRAWBERRY GUM 27GM',9,'single',19,109,22,NULL,NULL,'exclusive',205,0,1,1,'50098781','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 17:25:05','2020-07-17 16:59:05',NULL),(2641,'Haribo Phantasia Fantastik Gum 100gm',9,'single',19,360,22,NULL,NULL,'exclusive',285,0,1,1,'8691216018181','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 17:34:17','2019-09-10 17:34:17',NULL),(2642,'Uncle Bran\'s Tempura Flour 500gm',9,'single',19,394,77,NULL,NULL,'exclusive',190,0,1,1,'8850297990230','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 19:33:13','2019-09-10 19:33:13',NULL),(2643,'Uncle Bran\'s Bread Crumbs 200gm',9,'single',19,394,77,NULL,NULL,'exclusive',165,0,1,1,'8850297990025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 19:37:11','2019-09-10 19:37:11',NULL),(2644,'Calypso Salad Cream 285gm',9,'single',19,73,32,NULL,NULL,'exclusive',205,0,1,1,'5352101433689','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 20:42:19','2019-09-10 20:42:19',NULL),(2645,'Foster Clarks Essence 28 ml Banana',9,'single',19,57,51,NULL,NULL,'exclusive',55,0,1,1,'5352101461170','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 20:48:06','2019-09-10 20:48:06',NULL),(2646,'FOSTER CLARK\'S Strawberry Jam 450gm',9,'single',19,57,23,NULL,NULL,'exclusive',480,0,1,1,'5352101766701','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 20:56:18','2019-09-10 20:56:18',NULL),(2647,'Foster Clark\'s Mixed Fruit Jam 450gm',9,'single',19,57,23,NULL,NULL,'exclusive',480,0,1,1,'5352101430558','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 21:01:02','2019-09-10 21:01:02',NULL),(2648,'Foster Clark\'s Cherry Jam 450gm',9,'single',19,57,32,NULL,NULL,'exclusive',480,0,1,1,'5352101025617','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 21:05:33','2019-09-10 21:05:33',NULL),(2649,'Borges Olive Oil Extra Light 500ml',9,'single',19,70,29,NULL,NULL,'exclusive',420,0,1,1,'8410179300825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 21:17:03','2019-09-10 21:17:03',NULL),(2650,'Borges Extra Light Olive Oil 1lt',9,'single',19,70,29,NULL,NULL,'exclusive',770,0,1,1,'8410179300801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 21:21:17','2019-09-10 21:21:17',NULL),(2651,'Borges Sunflower Oil 1lt',9,'single',19,70,29,NULL,NULL,'exclusive',265,0,1,0,'8410179202006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 21:29:10','2019-09-10 21:29:10',NULL),(2652,'Borges Sunflower Oil 2lt',9,'single',19,70,29,NULL,NULL,'exclusive',520,0,1,1,'8410179013404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 21:38:36','2019-09-10 21:38:36',NULL),(2653,'Meiji Yan Yan Chocolate 50gm',9,'single',19,72,5,NULL,NULL,'exclusive',95,0,1,1,'8888077101101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 22:04:32','2019-09-10 22:04:32',NULL),(2654,'Meiji Yan Yan Strawberry 50gm',9,'single',19,72,5,NULL,NULL,'exclusive',95,0,1,1,'8888077101125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 22:07:40','2019-09-10 22:07:40',NULL),(2655,'American Garden Yellow Mustard 227gm',9,'single',19,150,32,NULL,NULL,'exclusive',130,0,1,1,'01727350255','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 23:41:55','2019-09-10 23:41:55',NULL),(2656,'Tiffany Wafer Chocolate 153gm',9,'single',19,241,55,NULL,NULL,'exclusive',125,0,1,1,'6291003005602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 23:47:28','2019-09-10 23:59:45',NULL),(2657,'Tiffany Wafer Vanilla 153gm',9,'single',19,241,55,NULL,NULL,'exclusive',130,0,1,1,'6291003005633','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 23:50:09','2019-09-10 23:50:09',NULL),(2658,'Tiffany Wafer Strawberry 153gm',9,'single',19,241,55,NULL,NULL,'exclusive',0,0,1,1,'6291003005619','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 23:52:12','2019-09-10 23:52:12',NULL),(2659,'Tiffany Wafer Hazelnut 153gm',9,'single',19,241,55,NULL,NULL,'exclusive',0,0,1,1,'6291003007095','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-10 23:57:02','2019-09-10 23:57:02',NULL),(2660,'Basso Extra Virgin Olive Oil 500ml',9,'single',19,246,29,NULL,NULL,'exclusive',450,0,1,1,'049248011256','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-11 00:44:47','2019-09-11 00:44:47',NULL),(2661,'Basso Pomace Olive Oil 500ml',9,'single',19,246,29,NULL,NULL,'exclusive',330,0,1,1,'8004123002752','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-11 00:50:39','2019-09-11 00:50:39',NULL),(2662,'Basso Extra Virgin Olive Oil 250ml',9,'single',19,246,29,NULL,NULL,'exclusive',260,0,1,1,'049248011522','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-11 00:54:52','2019-09-11 00:54:52',NULL),(2663,'Noor Sunflower Oil 3lt',9,'single',19,247,29,NULL,NULL,'exclusive',650,0,1,1,'6291003051166','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-11 01:00:56','2019-09-11 01:00:56',NULL),(2664,'Twinings Green Tea & Lemon 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',340,0,1,1,'070177173401','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-11 01:06:28','2019-09-11 01:06:28',NULL),(2665,'Twinings Green Tea Pure 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',340,0,1,1,'07017717339','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-11 01:09:59','2019-09-11 01:09:59',NULL),(2667,'Basundhara Paper Napkin 100pcs',9,'single',19,395,48,NULL,NULL,'exclusive',55,0,1,1,'8941193041031','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 17:47:47','2019-09-12 17:47:47',NULL),(2668,'Basundhara Facial Tissue Perfumed 240pcs',9,'single',19,395,48,NULL,NULL,'exclusive',60,0,1,1,'8941193073162','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 17:50:25','2019-09-12 17:50:25',NULL),(2669,'Del Monte Cranberry Juice 946ml',9,'single',19,8,24,NULL,NULL,'exclusive',750,0,1,1,'8887333190057','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 17:52:23','2019-09-12 17:52:23',NULL),(2671,'Basundhara Toilet Tissue White',9,'single',19,395,48,NULL,NULL,'exclusive',17,0,1,1,'8941193067024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 17:57:20','2019-09-12 17:57:20',NULL),(2672,'Basundhara Toilet Tissu Gold',9,'single',19,395,48,NULL,NULL,'exclusive',25,0,1,1,'8941193067017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 18:26:28','2019-09-12 18:26:28',NULL),(2673,'Basundhara Kitchen Towel',9,'single',19,395,48,NULL,NULL,'exclusive',57,0,1,1,'8941193078020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 18:31:37','2019-09-12 18:31:37',NULL),(2674,'Basundhara Hand Towel 250pcs',9,'single',19,NULL,48,NULL,NULL,'exclusive',75,0,1,1,'8941193064106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 18:37:50','2019-09-12 18:37:50',NULL),(2675,'Basundhara Paper Towel 250pcs',9,'single',19,395,48,NULL,NULL,'exclusive',75,0,1,1,'8941193078518','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 18:41:51','2019-09-12 18:41:51',NULL),(2676,'Hosen Chick Peas 400gm',9,'single',19,14,11,NULL,NULL,'exclusive',150,0,1,1,'8888192821748','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 19:08:47','2019-09-12 19:08:47',NULL),(2677,'Hosen  Whole Peeled Tomato Pelati 400gm',9,'single',19,14,11,NULL,NULL,'exclusive',125,0,1,1,'8888192951537','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 19:14:30','2019-09-12 19:14:30',NULL),(2678,'Hosen Whole Peeled Tomato Pelati 800gm',9,'single',19,14,11,NULL,NULL,'exclusive',230,0,1,1,'8888192951520','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 19:15:49','2019-09-12 19:15:49',NULL),(2679,'Hosen Red Maraschino Cherries 735gm',9,'single',19,14,43,NULL,NULL,'exclusive',625,0,1,1,'8888192501794','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 19:54:51','2020-07-23 00:14:03',NULL),(2680,'Hosen Red Maraschino Cherries 284gm',9,'single',19,14,11,NULL,NULL,'exclusive',360,0,1,1,'8888192501817','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 19:57:15','2020-07-23 00:15:37',NULL),(2681,'Hosen Black Olive Sliced-345gm',9,'single',19,14,49,NULL,NULL,'exclusive',225,0,1,1,'8888192951490','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 19:59:20','2019-09-12 19:59:20',NULL),(2682,'Twin Valley Coconut Milk 400ml',9,'single',19,396,26,NULL,NULL,'exclusive',135,0,1,1,'8887512004007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 20:07:33','2019-09-12 20:07:33',NULL),(2683,'Highway Hazelnut Spread W Cocoa 400gm',9,'single',19,14,6,NULL,NULL,'exclusive',600,0,1,1,'8888192501596','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 20:10:07','2019-09-12 20:10:07',NULL),(2684,'Horlicks Original 1.2kg',9,'single',19,151,60,NULL,NULL,'exclusive',0,0,1,1,'9556019245174','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 20:16:45','2019-09-12 20:16:45',NULL),(2685,'Del Monte Fruit Snacks Cranberries 170gm',9,'single',19,8,65,NULL,NULL,'exclusive',400,0,1,1,'8887333110215','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 20:19:43','2019-09-12 20:19:43',NULL),(2686,'Del Monte Fruit Snacks Sun Dried Raisins  170gm',9,'single',19,8,65,NULL,NULL,'exclusive',500,0,1,1,'8887333110154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 20:21:14','2019-09-12 20:21:14',NULL),(2687,'S&W Apple Cider Vinegar Organic W The Mother 473ml',9,'single',19,27,39,NULL,NULL,'exclusive',650,0,1,1,'8888111960046','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 20:23:59','2020-07-22 22:19:16',NULL),(2688,'Orgran GF Vorn & Vegetable Shells 250gm',9,'single',19,22,30,NULL,NULL,'exclusive',630,0,1,1,'720516720451','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:15:16','2019-09-12 21:15:16',NULL),(2689,'Orgran GF Buckwheat Spirals 250gm',9,'single',19,22,30,NULL,NULL,'exclusive',630,0,1,1,'720516722042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:18:00','2019-09-12 21:18:00',NULL),(2690,'Orgran GF Kids Rice & Corn Veg Pasta 200gm',9,'single',19,22,30,NULL,NULL,'exclusive',780,0,1,1,'720516021251','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:22:07','2019-09-12 21:22:07',NULL),(2691,'Orgran GF  Self Raising Flour 500gm',9,'single',19,22,77,NULL,NULL,'exclusive',780,0,1,1,'720516020513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:24:04','2019-09-12 21:24:04',NULL),(2692,'Orgran GF Chocolate Muffin Mix  375gm',9,'single',19,22,48,NULL,NULL,'exclusive',940,0,1,1,'720516021121','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:27:15','2019-09-12 21:27:15',NULL),(2693,'Orgran Chia Wafer Crackers 100gm',9,'single',19,22,42,NULL,NULL,'exclusive',940,0,1,1,'720516023309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:30:10','2019-09-12 21:30:10',NULL),(2694,'Peacock Basmati Rice Spaghetti 200gm',9,'single',19,23,30,NULL,NULL,'exclusive',375,0,1,1,'810791011358','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:39:19','2019-09-12 21:39:19',NULL),(2695,'Bob\'s Red Mill Extra Thick Rolled Oats 454gm',9,'single',19,4,28,NULL,NULL,'exclusive',770,0,1,1,'039978041555','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:43:40','2019-09-12 21:43:40',NULL),(2696,'Bob\'s Red Mill Traditional Pearl Couscous 453g',9,'single',19,4,48,NULL,NULL,'exclusive',920,0,1,1,'039978004963','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:46:53','2019-09-12 21:46:53',NULL),(2697,'Bob\'s Red Mill Yellow Popcorn 850gm',9,'single',19,4,58,NULL,NULL,'exclusive',940,0,1,1,'039978023070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:52:15','2019-09-12 21:52:15',NULL),(2698,'Kellogg\'s All Brand 315g',9,'single',19,128,48,NULL,NULL,'exclusive',435,0,1,1,'9310055414242','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:54:19','2019-09-12 21:54:19',NULL),(2699,'SIS White sugar 2kg',9,'single',19,30,35,NULL,NULL,'exclusive',500,0,1,1,'8888167023023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:56:39','2019-09-12 21:56:39',NULL),(2700,'SIS White sugar 1kg',9,'single',19,30,35,NULL,NULL,'exclusive',250,0,1,1,'8888167023016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:58:01','2019-09-12 21:58:01',NULL),(2701,'SIS White sugar Cubes 454gm',9,'single',19,30,35,NULL,NULL,'exclusive',210,0,1,1,'8888167217989','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-12 21:59:44','2020-07-23 00:32:56',NULL),(2702,'Oateo Instant Oats Jar 1kg',9,'single',19,331,28,NULL,NULL,'exclusive',535,0,1,1,'4796918130057','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:15:42','2019-09-15 23:58:38',NULL),(2703,'Oateo Instant Oats Jar 500g',9,'single',19,331,28,NULL,NULL,'exclusive',300,0,1,1,'4796918130040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:18:21','2019-09-15 23:18:21',NULL),(2704,'Oateo Instant Oats 1kg pp',9,'single',19,331,28,NULL,NULL,'exclusive',495,0,1,1,'4796918130019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:21:33','2019-09-15 23:21:33',NULL),(2705,'Oateo Instant Oats 500g pp',9,'single',19,331,28,NULL,NULL,'exclusive',200,0,1,1,'4796918130118','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:26:54','2019-09-15 23:26:54',NULL),(2706,'Oateo Instant Oats Tin 500g',9,'single',19,331,28,NULL,NULL,'exclusive',325,0,1,1,'4796918130064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:29:13','2019-09-15 23:29:13',NULL),(2707,'Tiara Mango 2.5kg',9,'single',19,57,52,NULL,NULL,'exclusive',1400,0,1,1,'5352102000279','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:54:56','2019-09-15 23:54:56',NULL),(2708,'Tiara Orange 2.5kg',9,'single',19,57,52,NULL,NULL,'exclusive',1400,0,1,1,'5352102067883','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-15 23:56:00','2019-09-15 23:56:00',NULL),(2709,'Camel Smoked Almonds 40gm',9,'single',19,58,53,NULL,NULL,'exclusive',110,0,1,1,'8888112080125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:36:39','2019-10-03 17:25:37',NULL),(2710,'Lindt Lindor Hazelnut 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',325,0,1,1,'7610400068369','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:41:01','2019-09-16 00:41:01',NULL),(2711,'Lindt swiss Classic Milk chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',325,0,1,1,'7610400010016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:43:45','2019-09-16 00:43:45',NULL),(2712,'Belgian Dark 72% 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',310,0,1,1,'5413121355082','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:46:24','2019-09-16 00:46:24',NULL),(2713,'Belgian Dark 50% 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',310,0,1,1,'5413121361366','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:47:52','2019-09-16 00:47:52',NULL),(2714,'Belgian Milk Salted Cramel 100gm',9,'single',19,333,15,NULL,NULL,'exclusive',310,0,1,1,'5413121362486','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:49:24','2019-09-16 00:49:24',NULL),(2715,'Cadbury Boost 48.5gm',9,'single',19,129,15,NULL,NULL,'exclusive',100,0,1,1,'5034660522782','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 00:59:21','2019-09-16 00:59:21',NULL),(2716,'Zipbag Lacy\'s Sandwich 24X50s',9,'single',19,397,48,NULL,NULL,'exclusive',260,0,1,1,'8888417002013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 01:03:12','2019-09-16 01:03:12',NULL),(2717,'Zipbag Lacy\'s Quart 24X25s',9,'single',19,397,48,NULL,NULL,'exclusive',230,0,1,1,'8888417002020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 01:04:43','2019-09-16 01:04:43',NULL),(2718,'Lacy\'s Aluminium Foil 25sft',9,'single',19,397,48,NULL,NULL,'exclusive',170,0,1,1,'8888417001139','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 01:08:01','2019-09-16 01:08:01',NULL),(2719,'Tipco 100% Sai Nam Phueng Orange Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,0,1,1,'8851013778491','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 01:48:08','2019-09-16 01:48:08',NULL),(2720,'Tipco Tangerine Thong Orange Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',400,0,1,1,'8851013794491','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 01:50:32','2020-10-13 17:47:18',NULL),(2721,'Munchy\'s Topmix 295gm',9,'single',19,59,5,NULL,NULL,'exclusive',320,0,1,1,'9556439881600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 01:59:04','2019-09-16 01:59:04',NULL),(2722,'act ii butter delite 70 gm',9,'single',19,189,44,NULL,NULL,'exclusive',35,0,1,1,'710535347470','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-16 19:47:58','2019-09-16 19:47:58',NULL),(2723,'Well Food Butter Toast Rusk  250gm',9,'single',19,348,78,NULL,NULL,'exclusive',80,0,1,1,'167806263357','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 19:59:09','2019-09-18 19:59:09',NULL),(2724,'Well Food Plain Toast Rusk  250gm',9,'single',19,348,78,NULL,NULL,'exclusive',80,0,1,1,'167806263340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:01:07','2019-09-18 20:01:07',NULL),(2725,'Well Food Sugar Free Toast  300gm',9,'single',19,348,78,NULL,NULL,'exclusive',80,0,1,1,'98609277','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:02:42','2019-09-18 20:02:42',NULL),(2726,'Well Food Mint Leaf Toast  250gm',9,'single',19,348,78,NULL,NULL,'exclusive',85,0,1,1,'312456789980','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:04:22','2019-09-18 20:04:22',NULL),(2727,'Well Food Oval Plus 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',200,0,1,1,'98608638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:16:01','2019-09-18 20:16:01',NULL),(2728,'Well Food Horli Plus 150gm',9,'single',19,348,5,NULL,NULL,'exclusive',105,0,1,1,'01857986','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:17:42','2019-09-18 20:17:42',NULL),(2729,'Well Food Oval Plus 150gm',9,'single',19,348,5,NULL,NULL,'exclusive',105,0,1,1,'89240175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:19:34','2019-09-18 20:19:34',NULL),(2730,'Well Food Live Lite Biscuit  150gm',9,'single',19,348,5,NULL,NULL,'exclusive',175,0,1,1,'5061728394050','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 20:21:35','2019-09-18 20:21:35',NULL),(2731,'China Candy Cola  100gm',9,'single',19,216,7,NULL,NULL,'exclusive',70,0,1,1,'6930243001110','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 21:09:25','2019-09-18 21:09:25',NULL),(2732,'China Candy Pinapple 100gm',9,'single',19,216,7,NULL,NULL,'exclusive',70,0,1,1,'6930243001127','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 21:11:11','2019-09-18 21:11:11',NULL),(2733,'China Candy Grape 100gm',9,'single',19,216,7,NULL,NULL,'exclusive',70,0,1,1,'6930243001134','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 21:18:34','2019-09-18 21:18:34',NULL),(2734,'China Candy Litchi 100gm',9,'single',19,216,7,NULL,NULL,'exclusive',70,0,1,1,'6930243001165','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 21:19:51','2019-09-18 21:19:51',NULL),(2735,'Olivital Pomace Olive Oil 1 Lt',9,'single',19,307,29,NULL,NULL,'exclusive',550,0,1,1,'8003250001386','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 21:25:56','2019-09-18 21:25:56',NULL),(2736,'Tayas Almond Special 700gm',9,'single',19,398,15,NULL,NULL,'exclusive',900,0,1,1,'8690997134189','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 23:40:52','2019-09-18 23:40:52',NULL),(2737,'Tayas Magic 700gm',9,'single',19,398,15,NULL,NULL,'exclusive',900,0,1,1,'8690997134332','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 23:47:03','2019-09-18 23:47:03',NULL),(2738,'TAYAS Orient  Luxury 600gm',9,'single',19,398,15,NULL,NULL,'exclusive',900,0,1,1,'8690997135537','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 23:49:18','2019-09-18 23:49:18',NULL),(2739,'TAYAS Orient Special 600gm',9,'single',19,398,15,NULL,NULL,'exclusive',900,0,1,1,'8690997135506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 23:51:17','2019-09-18 23:51:17',NULL),(2740,'Fantasia Umbrella 32gm',9,'single',19,399,15,NULL,NULL,'exclusive',80,0,1,1,'1564856784525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 23:54:24','2019-09-18 23:54:24',NULL),(2741,'Bifa Chocolate 180gm',9,'single',19,400,15,NULL,NULL,'exclusive',270,0,1,1,'8690562115629','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-18 23:58:51','2019-09-18 23:58:51',NULL),(2742,'Bifa Chocolate 260gm',9,'single',19,400,15,NULL,NULL,'exclusive',390,0,1,1,'01796976780','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:05:49','2019-09-19 00:05:49',NULL),(2743,'Evliya 500gm',9,'single',19,401,15,NULL,NULL,'exclusive',460,0,1,1,'8680052611182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:08:58','2019-09-19 00:08:58',NULL),(2744,'Evliya Meda  1kg',9,'single',19,401,15,NULL,NULL,'exclusive',880,0,1,1,'8680052608717','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:11:19','2019-09-19 00:11:19',NULL),(2745,'Evliya Twist Chocolate  1kg',9,'single',19,401,15,NULL,NULL,'exclusive',880,0,1,1,'8680052621242','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:13:24','2019-09-19 00:13:24',NULL),(2746,'Evliya Davet Chocolate  1kg jar',9,'single',19,401,15,NULL,NULL,'exclusive',880,0,1,1,'8680052608199','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:15:21','2020-01-22 15:40:48',NULL),(2747,'Evliya Sultan Chocolate  1kg',9,'single',19,401,15,NULL,NULL,'exclusive',880,0,1,1,'8680052608878','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:17:37','2019-09-19 00:17:37',NULL),(2748,'BRAWO Sprinter Bar 50gm',9,'single',19,402,15,NULL,NULL,'exclusive',60,0,1,1,'8691720026900','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:21:37','2019-09-19 00:21:37',NULL),(2749,'ANI Brawo  Bar 50gm',9,'single',19,402,15,NULL,NULL,'exclusive',60,0,1,1,'8691720026849','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:23:42','2019-09-19 00:23:42',NULL),(2750,'ANI Coco Romeo 48gm',9,'single',19,403,15,NULL,NULL,'exclusive',55,0,1,1,'8691720020199','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:25:39','2019-09-19 00:25:39',NULL),(2751,'ANI LINO Bar 46gm',9,'single',19,403,15,NULL,NULL,'exclusive',55,0,1,1,'8691720022339','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:27:07','2019-09-19 00:27:07',NULL),(2752,'Bifa Chocolate Box 320gm',9,'single',19,400,15,NULL,NULL,'exclusive',450,0,1,1,'01787668416','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:31:11','2019-09-19 00:31:11',NULL),(2753,'Bifa Chocolate Box 240gm',9,'single',19,400,15,NULL,NULL,'exclusive',360,0,1,1,'01766694536','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 00:32:40','2019-09-19 00:32:40',NULL),(2754,'Vitalia GF Crackers 90gm',9,'single',19,1,42,NULL,NULL,'exclusive',170,0,1,1,'5310099018691','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-19 01:54:02','2019-09-19 01:54:02',NULL),(2755,'Nescafe Gold Rica & Suare 200gm',9,'single',19,138,37,NULL,NULL,'exclusive',690,0,1,1,'7613035267473','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-21 16:16:13','2019-09-21 16:16:13',NULL),(2756,'Cadbury Dairy milk Crispello 34gm',9,'single',19,129,15,NULL,NULL,'exclusive',52,0,1,1,'8901233031521','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-21 21:58:58','2019-09-21 21:58:58',NULL),(2757,'Lactogen 3 400 gm tin new',9,'single',19,63,NULL,NULL,NULL,'exclusive',590,0,1,1,'8901058865967','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 18:07:01','2019-09-22 18:07:01',NULL),(2758,'Best Tomato Ketchup 330gm',9,'single',19,404,32,NULL,NULL,'exclusive',105,0,1,1,'9556086001208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 18:41:44','2019-09-22 18:41:44',NULL),(2759,'Best\'s Chilli Sauce 340gm',9,'single',19,405,NULL,NULL,NULL,'exclusive',110,0,1,1,'9556086000003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 18:46:15','2019-09-22 18:46:15',NULL),(2760,'best\'s Tomato ketchup 685gm',9,'single',19,405,32,NULL,NULL,'exclusive',245,0,1,1,'9556086000577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 18:58:30','2019-09-22 18:58:30',NULL),(2761,'best\'s Chilli Sauce 725gm',9,'single',19,405,32,NULL,NULL,'exclusive',265,0,1,1,'9556086010170','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:17:13','2019-09-22 19:17:13',NULL),(2762,'Best\'s Tomato Puree 420gm',9,'single',19,405,32,NULL,NULL,'exclusive',135,0,1,1,'4607035892363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:23:25','2019-09-22 19:23:25',NULL),(2763,'Life Soya Sauce Light  210ml',9,'single',19,406,32,NULL,NULL,'exclusive',120,0,1,1,'9556086013805','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:27:01','2019-09-22 19:27:01',NULL),(2764,'Life Soya Sauce Light  410ml',9,'single',19,406,32,NULL,NULL,'exclusive',215,0,1,1,'9556086013812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:29:11','2019-09-22 19:29:11',NULL),(2765,'Life Soya Sauce Dark  210gm',9,'single',19,406,32,NULL,NULL,'exclusive',130,0,1,1,'9556086013706','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:36:40','2019-09-22 19:36:40',NULL),(2766,'Life Soya Sauce Dark  410ml',9,'single',19,406,32,NULL,NULL,'exclusive',250,0,1,1,'9556086013713','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:38:47','2019-09-22 19:38:47',NULL),(2767,'life oyester sauce 250g',9,'single',19,406,32,NULL,NULL,'exclusive',130,0,1,1,'9556086012662','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 19:59:30','2019-09-22 19:59:30',NULL),(2768,'life oyeste sauce 510g',9,'single',19,406,32,NULL,NULL,'exclusive',245,0,1,1,'9556086012679','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:17:30','2019-09-22 20:17:30',NULL),(2769,'life bbq sauce 250gm',9,'single',19,406,32,NULL,NULL,'exclusive',140,0,1,1,'9556086090615','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:23:59','2019-09-22 20:23:59',NULL),(2770,'best\'s mushroom 425gm',9,'single',19,405,11,NULL,NULL,'exclusive',100,0,1,1,'6918292551947','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:40:30','2020-07-07 17:53:25',NULL),(2771,'best\'s baby corn 425gm',9,'single',19,405,11,NULL,NULL,'exclusive',90,0,1,1,'6935684128129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:42:26','2019-09-22 20:42:26',NULL),(2772,'best\'s sweet corn 425gm',9,'single',19,405,11,NULL,NULL,'exclusive',75,0,1,1,'6918298362653','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:44:14','2019-09-22 20:44:14',NULL),(2773,'best\'s strawberry conserve 450gm',9,'single',19,405,23,NULL,NULL,'exclusive',380,0,1,1,'9557008634542','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:52:43','2019-09-22 20:52:43',NULL),(2774,'best\'s blueberry conserve 450gm',9,'single',19,405,23,NULL,NULL,'exclusive',380,0,1,1,'9557008634511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:54:58','2019-09-22 20:54:58',NULL),(2775,'best\'s orange marmalade 450gm',9,'single',19,405,23,NULL,NULL,'exclusive',380,0,1,1,'9557008634535','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:56:28','2019-09-22 20:56:28',NULL),(2776,'best\'s mixed fruite conserve 450 gm',9,'single',19,405,23,NULL,NULL,'exclusive',380,0,1,1,'9557008634528','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 20:58:28','2019-09-22 20:58:28',NULL),(2777,'best\'s chunky peanut spread 330gm',9,'single',19,405,6,NULL,NULL,'exclusive',280,0,1,1,'9555258803305','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:02:17','2019-09-22 21:02:17',NULL),(2778,'best\'s chunky peanut spread 170gm',9,'single',19,405,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803282','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:04:42','2019-09-22 21:04:42',NULL),(2779,'best\'s creamy peanut spread 330gm',9,'single',19,405,6,NULL,NULL,'exclusive',280,0,1,1,'9555258803312','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:07:04','2019-09-22 21:07:04',NULL),(2780,'best\'s creamy peanut spread 170gm',9,'single',19,405,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803299','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:08:26','2019-09-22 21:08:26',NULL),(2781,'best\'s creamy peanut spread 170gm',9,'single',19,405,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803299','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:08:27','2019-09-22 21:08:27',NULL),(2782,'best\'s peanut spread chocolate 175gm',9,'single',19,405,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803268','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:10:23','2019-09-22 21:10:23',NULL),(2783,'best\'s peanut blueberry stripes 175gm',9,'single',19,405,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803251','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:12:44','2019-09-22 21:12:44',NULL),(2784,'best\'s peanut spread strawberry stripes 175gm',9,'single',19,405,6,NULL,NULL,'exclusive',155,0,1,1,'4717408803275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:14:17','2019-09-22 21:14:17',NULL),(2785,'best\'s Chilli & Garlic Sause 320gm',9,'single',19,405,32,NULL,NULL,'exclusive',120,0,1,1,'9556086002304','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:25:58','2019-09-22 21:25:58',NULL),(2786,'best\'s Chilli & Garlic Sause 320gm',9,'single',19,405,32,NULL,NULL,'exclusive',120,0,1,1,'9556086002304','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:25:58','2019-09-22 21:25:58',NULL),(2787,'best\'s peanut spread strawberry stripes 175gm',9,'single',19,NULL,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:34:22','2019-09-22 21:34:22',NULL),(2788,'best\'s peanut spread strawberry stripes 175gm',9,'single',19,NULL,6,NULL,NULL,'exclusive',155,0,1,1,'9555258803275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-22 21:34:23','2019-09-22 21:34:23',NULL),(2790,'v food celebreat assorted biscuite  400gm',9,'single',19,76,5,NULL,NULL,'exclusive',620,0,1,1,'8858223010342','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 21:41:59','2019-09-23 21:41:59',NULL),(2791,'v food celebreat assorted biscuite  400gm',9,'single',19,76,5,NULL,NULL,'exclusive',620,0,1,1,'8858223010342','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 21:41:59','2019-09-23 21:41:59',NULL),(2792,'v food mr mee chocolate mint 25g',9,'single',19,76,5,NULL,NULL,'exclusive',39,0,1,1,'8858223011370','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 21:50:30','2019-09-23 21:50:30',NULL),(2793,'mr mee strawberry biscuite 25 gm',9,'single',19,76,5,NULL,NULL,'exclusive',39,0,1,1,'8858223011387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 21:55:42','2019-09-23 21:55:42',NULL),(2794,'dear teddy flower biscuite with coconut cream 150g',9,'single',19,76,5,NULL,NULL,'exclusive',300,0,1,1,'8858223014425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 21:59:05','2019-09-23 21:59:05',NULL),(2795,'dear teddy sweet heart biscuite with coffee cream 150g',9,'single',19,76,5,NULL,NULL,'exclusive',300,0,1,1,'8858223014548','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 22:06:57','2019-09-23 22:06:57',NULL),(2796,'Royal wafer strawberry cream 125g',9,'single',19,76,55,NULL,NULL,'exclusive',220,0,1,1,'8858223010847','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-23 22:14:30','2019-09-23 22:14:30',NULL),(2797,'Lay;s mesquite BBQ 155.9g',9,'single',19,174,14,NULL,NULL,'exclusive',195,0,1,1,'028400055109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-24 16:21:52','2019-09-24 16:21:52',NULL),(2798,'Heinz Tomato Ketchup 300gm',9,'single',19,13,32,NULL,NULL,'exclusive',155,0,1,1,'2798','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-24 16:51:15','2020-06-29 16:48:48',NULL),(2799,'Heinz Chili Sauce 310gm',9,'single',19,13,32,NULL,NULL,'exclusive',155,0,1,1,'2799','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-24 16:53:03','2019-09-26 21:24:23',NULL),(2800,'Hibiscus Sweet Kernel Corn 400g',9,'single',19,92,11,NULL,NULL,'exclusive',65,0,1,1,'8848701050816','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 13:49:16','2019-09-26 13:49:16',NULL),(2801,'champion Choice Whole Mushroom 2840g',9,'single',19,93,11,NULL,NULL,'exclusive',520,0,1,1,'6932017121215','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 13:58:23','2020-03-14 19:07:47',NULL),(2802,'Cadbury Dairy Milk Silk Chocolate 150g',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'8901233034201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 14:47:33','2019-09-26 14:47:33',NULL),(2803,'Cadbury Lickables 20gm',9,'single',19,129,15,NULL,NULL,'exclusive',80,0,1,1,'8901233030470','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 14:59:01','2019-09-26 14:59:01',NULL),(2804,'Cadbury Choclairs 196gm',9,'single',19,129,15,NULL,NULL,'exclusive',130,0,1,1,'8901233023489','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 15:05:32','2019-09-26 15:05:32',NULL),(2805,'Cinnamon (Daruchini) 300gm',9,'single',19,407,66,NULL,NULL,'exclusive',150,0,1,1,'120101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:04:48','2019-09-26 19:04:48',NULL),(2806,'Cinnamon (Daruchini) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',100,0,1,1,'120102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:06:24','2019-09-26 19:06:24',NULL),(2807,'Cinnamon (Daruchini) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',50,0,1,1,'120103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:07:28','2019-09-26 19:07:28',NULL),(2808,'Cardamom (Elach) P1 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',710,0,1,1,'120104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:09:15','2020-01-27 17:32:36',NULL),(2809,'Cardamom (Elach) P1 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',355,0,1,1,'120105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:16:18','2020-01-27 17:32:19',NULL),(2810,'Cardamom (Elach) JBB 100gm',9,'single',19,273,66,NULL,NULL,'exclusive',265,0,1,1,'120145','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:18:13','2020-01-27 17:30:58',NULL),(2811,'Cardamom (Elach) JBB 200gm',9,'single',19,273,66,NULL,NULL,'exclusive',700,0,1,1,'120144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:19:23','2020-01-27 17:30:00',NULL),(2812,'Cumin (Zira) (Turkey) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',100,0,1,1,'120106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:19:26','2019-09-26 19:19:26',NULL),(2813,'Cardamom (Elach) JBC 100gm',9,'single',19,273,66,NULL,NULL,'exclusive',300,0,1,1,'120143','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:22:23','2020-01-27 17:31:23',NULL),(2814,'Cardamom (Elach) JBC 200gm',9,'single',19,273,66,NULL,NULL,'exclusive',600,0,1,1,'120142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:23:33','2020-01-27 17:31:52',NULL),(2815,'Cumin (Zira) (Turkey) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',50,0,1,1,'120107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:23:37','2019-09-26 19:23:37',NULL),(2816,'Green Raisin (Kismis) 150gm',9,'single',19,273,66,NULL,NULL,'exclusive',70,0,1,1,'120141','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:24:46','2020-07-17 21:58:10',NULL),(2817,'Clove (Lobongo) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',200,0,1,1,'120109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:26:15','2019-09-26 19:26:15',NULL),(2818,'Clove (Lobongo) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',100,0,1,1,'120110','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:27:17','2019-09-26 19:27:17',NULL),(2819,'Green Raisin (Kismis) 300gm',9,'single',19,273,66,NULL,NULL,'exclusive',135,0,1,1,'120140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:32:52','2019-09-26 19:32:52',NULL),(2820,'Green Raisin (Kismis) 500gm',9,'single',19,273,66,NULL,NULL,'exclusive',225,0,1,1,'120139','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:33:43','2019-09-26 19:33:43',NULL),(2821,'Popy Seed (Posto) 100gm',9,'single',19,273,66,NULL,NULL,'exclusive',140,0,1,1,'120138','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:34:41','2019-09-26 19:34:41',NULL),(2822,'White Pepper (Sada Golmorich) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',160,0,1,1,'120108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:52:34','2019-09-26 19:52:34',NULL),(2823,'White Pepper (Sada Golmorich) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',80,0,1,1,'120111','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:54:20','2019-09-26 19:54:20',NULL),(2824,'Black Pepper (Kalo Golmorich) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',100,0,1,1,'120112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:55:42','2019-09-26 19:55:42',NULL),(2825,'Black Pepper (Kalo Golmorich) 100gm',9,'single',19,NULL,66,NULL,NULL,'exclusive',50,0,1,1,'120113','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:56:36','2019-09-26 19:56:36',NULL),(2826,'Mace (Joyitri) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',600,0,1,1,'120114','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:58:11','2019-09-26 19:58:11',NULL),(2827,'Mace (Joyitri) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',300,0,1,1,'120115','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 19:59:14','2019-09-26 19:59:14',NULL),(2828,'Nutmeg (Jaifol) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',240,0,1,1,'120116','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:03:48','2019-09-26 20:03:48',NULL),(2829,'Nutmeg (Jaifol) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',120,0,1,1,'120117','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:04:54','2019-09-26 20:04:54',NULL),(2830,'Golden Raisin (Kishmish) 500gm',9,'single',19,372,65,NULL,NULL,'exclusive',175,0,1,1,'120118','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:06:55','2019-09-26 20:06:55',NULL),(2831,'Golden Raisin (Kishmish) 150gm',9,'single',19,372,65,NULL,NULL,'exclusive',55,0,1,1,'120119','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:09:06','2019-09-26 20:09:06',NULL),(2832,'Lion Alubokhara 500gm',9,'single',19,373,66,NULL,NULL,'exclusive',175,0,1,1,'120120','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:15:04','2020-01-29 00:09:54',NULL),(2833,'Lion Alubokhara 150gm',9,'single',19,407,66,NULL,NULL,'exclusive',55,0,1,1,'120121','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:17:21','2019-09-26 20:17:21',NULL),(2834,'Ispaghula Husk (Isapgul) 200gm',9,'single',19,160,52,NULL,NULL,'exclusive',180,0,1,1,'120122','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:19:00','2019-09-26 20:19:00',NULL),(2835,'Ispaghula Husk (Isapgul) 100gm',9,'single',19,160,52,NULL,NULL,'exclusive',90,0,1,1,'120123','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:20:02','2019-09-26 20:20:02',NULL),(2836,'Black Cumin (Kalo Zira) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',50,0,1,1,'120124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:21:27','2019-09-26 20:21:27',NULL),(2837,'Black Cumin (Kalo Zira) 100gm',9,'single',19,407,66,NULL,NULL,'exclusive',25,0,1,1,'120125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:22:23','2019-09-26 20:22:23',NULL),(2838,'Crown Almond Nut 300gm',9,'single',19,299,53,NULL,NULL,'exclusive',300,0,1,1,'120126','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:24:24','2019-09-26 20:24:24',NULL),(2839,'Crown Almond Nut 150gm',9,'single',19,299,53,NULL,NULL,'exclusive',150,0,1,1,'120127','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:25:58','2019-09-26 20:25:58',NULL),(2840,'Elephant Unsalted Cashwe Nut 500gm',9,'single',19,370,53,NULL,NULL,'exclusive',500,0,1,1,'120128','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:27:16','2019-09-26 20:27:16',NULL),(2841,'Elephant Unsalted Cashwe Nut 300gm',9,'single',19,370,53,NULL,NULL,'exclusive',300,0,1,1,'120129','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:28:18','2020-02-03 13:52:07',NULL),(2842,'Elephant Unsalted Cashwe Nut 150gm',9,'single',19,370,53,NULL,NULL,'exclusive',150,0,1,1,'120130','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:29:57','2020-01-28 23:58:13',NULL),(2843,'Elephant Salted Cashwe Nut 500gm',9,'single',19,370,53,NULL,NULL,'exclusive',700,0,1,1,'120131','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:31:36','2019-09-26 20:31:36',NULL),(2844,'Elephant Salted Cashwe Nut 300gm',9,'single',19,370,53,NULL,NULL,'exclusive',420,0,1,1,'120132','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:32:36','2019-09-26 20:32:36',NULL),(2845,'Elephant Salted Cashwe Nut 150gm',9,'single',19,370,53,NULL,NULL,'exclusive',210,0,1,1,'120133','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:33:35','2019-09-26 20:33:35',NULL),(2846,'California Walnut 500gm',9,'single',19,374,53,NULL,NULL,'exclusive',750,0,1,1,'120134','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:35:27','2019-09-26 20:35:27',NULL),(2847,'California Walnut 150gm',9,'single',19,374,NULL,NULL,NULL,'exclusive',225,0,1,1,'120135','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:37:33','2019-09-26 20:37:33',NULL),(2848,'Cumin (Zira) (Pakistani) 300gm',9,'single',19,407,66,NULL,NULL,'exclusive',120,0,1,1,'120136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:38:48','2019-09-26 20:38:48',NULL),(2849,'Cumin (Zira) (Pakistani) 200gm',9,'single',19,407,66,NULL,NULL,'exclusive',80,0,1,1,'120137','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 20:40:31','2019-09-26 20:40:31',NULL),(2850,'maggi nodles kari  79g  ma',9,'single',19,408,27,NULL,NULL,'exclusive',39,0,1,1,'9556001128836','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 21:47:14','2019-09-26 21:47:14',NULL),(2851,'Nescafe Original 532gm (Malasia)',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'9556001257222','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-26 22:00:17','2019-09-26 22:00:17',NULL),(2852,'Pistachio Nust  (Roasted & Salted)-100gm',9,'single',19,7,53,NULL,NULL,'exclusive',200,0,1,1,'120150','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 16:43:55','2019-10-09 15:13:04',NULL),(2853,'Pistachio Nust  (Roasted & Salted)-200gm',9,'single',19,7,53,NULL,NULL,'exclusive',400,0,1,1,'120149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 16:44:46','2019-10-09 15:13:40',NULL),(2854,'Pistachio Nust  (Roasted & Salted)-300gm',9,'single',19,7,53,NULL,NULL,'exclusive',600,0,1,1,'120148','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 16:45:37','2019-10-09 15:14:10',NULL),(2855,'Dried Mushroom 300gm',9,'single',19,216,82,NULL,NULL,'exclusive',495,0,1,1,'120146','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 16:48:30','2019-09-28 16:48:30',NULL),(2856,'Dried Mushroom 200gm',9,'single',19,216,82,NULL,NULL,'exclusive',330,0,1,1,'120147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 16:50:03','2019-09-28 16:50:03',NULL),(2857,'Dried Mushroom 100gm',9,'single',19,216,82,NULL,NULL,'exclusive',165,0,1,1,'120151','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 16:51:17','2019-09-28 16:51:17',NULL),(2858,'fox\'s Glacier mints 200g',9,'single',19,88,7,NULL,NULL,'exclusive',275,0,1,1,'5000314120543','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 19:35:35','2019-09-29 15:01:34',NULL),(2859,'erko mallow world 150 g',9,'single',19,147,5,NULL,NULL,'exclusive',250,0,1,1,'6925925901796','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 20:10:40','2019-09-28 20:10:40',NULL),(2860,'erko mallow world 150 g',9,'single',19,147,5,NULL,NULL,'exclusive',250,0,1,1,'6925925901796','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 20:10:40','2019-09-28 20:10:40',NULL),(2861,'daim milk chocolate 280g',9,'single',19,409,15,NULL,NULL,'exclusive',780,0,1,1,'7622210677228','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 20:13:59','2019-09-28 20:13:59',NULL),(2862,'kit kat mini',9,'single',19,63,15,NULL,NULL,'exclusive',32,0,1,1,'50189205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-28 20:54:13','2019-09-28 20:54:13',NULL),(2863,'doritos nacho cheese flavour 75 g',9,'single',19,194,NULL,NULL,NULL,'exclusive',115,0,1,1,'8901491000147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 15:58:16','2019-09-30 14:36:32',NULL),(2864,'kurkure chilli chatka 90g',9,'single',19,340,14,NULL,NULL,'exclusive',45,0,1,1,'8901491366953','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 16:01:28','2019-09-29 16:01:28',NULL),(2866,'kurkure american style cream & onion  90g',9,'single',19,340,14,NULL,NULL,'exclusive',45,0,1,1,'8901491368223','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 16:05:30','2019-09-30 14:39:19',NULL),(2867,'kurkure spanish tomato tango  90g',9,'single',19,340,14,NULL,NULL,'exclusive',45,0,1,1,'710535945706','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 16:08:17','2019-09-29 16:08:17',NULL),(2868,'kurkure massala munch 90g',9,'single',19,340,14,NULL,NULL,'exclusive',45,0,1,1,'8901491366946','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 16:11:02','2019-09-29 16:11:02',NULL),(2869,'haribo warm solucan',9,'single',19,263,22,NULL,NULL,'exclusive',285,0,1,1,'8691216020832','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:06:33','2019-09-29 20:06:33',NULL),(2870,'chupa chups sour infernals 150g',9,'single',19,148,22,NULL,NULL,'exclusive',295,0,1,1,'8003440992395','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:25:02','2019-09-29 20:25:02',NULL),(2871,'skittles fruits 100g',9,'single',19,126,15,NULL,NULL,'exclusive',300,0,1,1,'4009900482967','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:37:20','2019-09-29 20:37:20',NULL),(2872,'tic tac orange uk 18g',9,'single',19,133,7,NULL,NULL,'exclusive',75,0,1,1,'80052333','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:49:13','2019-09-29 20:49:13',NULL),(2873,'tic tac strawberry mix 18g',9,'single',19,133,7,NULL,NULL,'exclusive',75,0,1,1,'80800019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:51:25','2019-09-29 20:51:25',NULL),(2874,'tic tsac cherry-cola 18g',9,'single',19,133,7,NULL,NULL,'exclusive',75,0,1,1,'80799672','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:53:19','2019-09-29 20:53:19',NULL),(2875,'john west tuna chunk in sun flower oil 95g',9,'single',19,410,8,NULL,NULL,'exclusive',270,0,1,1,'2875','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 20:58:13','2019-09-29 20:58:13',NULL),(2876,'john west tuna chunk  in brine 145g',9,'single',19,410,8,NULL,NULL,'exclusive',270,0,1,1,'2876','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 21:07:53','2019-09-29 21:07:53',NULL),(2877,'john west sardines in sunflower oil 120g',9,'single',19,410,8,NULL,NULL,'exclusive',270,0,1,1,'5000171030696','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 21:10:08','2019-09-29 21:10:08',NULL),(2878,'john west sardines in tomato sauce 120g',9,'single',19,410,8,NULL,NULL,'exclusive',270,0,1,1,'5000171010209','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-29 21:11:57','2019-09-29 21:11:57',NULL),(2879,'Goldenmark Chocolate Milk Coconut-2kg',9,'single',19,411,15,NULL,NULL,'exclusive',1800,0,1,1,'8697671953913','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:40:08','2019-09-30 16:40:08',NULL),(2880,'Goldenmark Chocolate Milk Strawbery-2kg',9,'single',19,411,15,NULL,NULL,'exclusive',1800,0,1,1,'8697671953937','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:43:08','2019-09-30 16:43:08',NULL),(2881,'Goldenmark Chocolate Milk Vanila-2kg',9,'single',19,411,15,NULL,NULL,'exclusive',1800,0,1,1,'8697671953920','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:44:40','2019-09-30 16:44:40',NULL),(2882,'Goldenmark Angelito-1kg',9,'single',19,411,15,NULL,NULL,'exclusive',950,0,1,1,'8699905720223','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:46:24','2019-09-30 16:46:24',NULL),(2883,'Goldenmark Five Star-1kg',9,'single',19,411,15,NULL,NULL,'exclusive',950,0,1,1,'8699905720193','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:47:31','2019-09-30 16:47:31',NULL),(2884,'Goldenmark Piero-1kg',9,'single',19,411,15,NULL,NULL,'exclusive',950,0,1,1,'8699905720186','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:48:29','2019-09-30 16:48:29',NULL),(2885,'Goldenmark Yummex-1kq',9,'single',19,411,15,NULL,NULL,'exclusive',950,0,1,1,'8699905720216','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:49:59','2019-09-30 16:49:59',NULL),(2886,'Goldmark I Love Fruit Candy-1kg',9,'single',19,411,15,NULL,NULL,'exclusive',850,0,1,1,'8699905720650','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:51:10','2019-09-30 16:51:10',NULL),(2887,'Goldenmark Chocolate Milk Hazelnut-2kg',9,'single',19,411,15,NULL,NULL,'exclusive',1800,0,1,1,'8697671953906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-09-30 16:53:34','2019-09-30 16:53:34',NULL),(2888,'American Harvest Basil Seed Drink Red Grape 290m',9,'single',19,412,24,NULL,NULL,'exclusive',100,0,1,1,'8858908310590','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:01:20','2019-10-02 20:01:20',NULL),(2889,'Nescafe Classic  50gm',9,'single',19,138,16,NULL,NULL,'exclusive',170,0,1,1,'7891000071809','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:07:18','2019-10-02 20:07:18',NULL),(2890,'Nescafe Classic  100gm',9,'single',19,138,16,NULL,NULL,'exclusive',290,0,1,1,'7891000071786','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:09:56','2019-10-02 20:09:56',NULL),(2891,'Cream Crackers 600gm',9,'single',19,413,42,NULL,NULL,'exclusive',780,0,1,1,'9556184060039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:26:48','2019-10-02 20:26:48',NULL),(2892,'Stute Blackcurrant Consewe Jam 340gm',9,'single',19,155,23,NULL,NULL,'exclusive',310,0,1,1,'4006424270445','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:42:39','2019-10-02 20:42:39',NULL),(2893,'Stute Blackcurrant Consewe Extra Jam 430gm',9,'single',19,155,23,NULL,NULL,'exclusive',320,0,1,1,'4006424022372','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:44:21','2019-10-02 20:44:21',NULL),(2894,'Julie\'s Cheese Sandwich 168gm',9,'single',19,290,5,NULL,NULL,'exclusive',260,0,1,1,'9556121003051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:51:21','2020-07-16 13:50:35',NULL),(2895,'Tempura Batter Mix 500gm',9,'single',19,414,6,NULL,NULL,'exclusive',120,0,1,1,'8852633333503','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 20:59:24','2019-10-02 20:59:24',NULL),(2896,'California Black Raisins 1kg',9,'single',19,415,65,NULL,NULL,'exclusive',1050,0,1,1,'924749','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:04:52','2019-10-02 21:04:52',NULL),(2897,'Monin Litchi Syrup 70cl',9,'single',19,173,36,NULL,NULL,'exclusive',900,0,1,1,'3052911225567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:16:03','2019-10-02 21:19:50',NULL),(2898,'Monin Fruit de la Passion Syrup 70cl',9,'single',19,173,36,NULL,NULL,'exclusive',1050,0,1,1,'3052910056339','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:18:45','2019-10-02 21:18:45',NULL),(2899,'Monin Vanilla Syrup 70cl',9,'single',19,173,36,NULL,NULL,'exclusive',940,0,1,1,'3052910056469','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:23:04','2019-10-02 21:23:04',NULL),(2900,'Monin KiWi Syrup 70cl',9,'single',19,173,36,NULL,NULL,'exclusive',940,0,1,1,'3052910056438','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:24:25','2019-10-02 21:24:25',NULL),(2901,'Monin Watermelon Syrup 70cl',9,'single',19,173,36,NULL,NULL,'exclusive',925,0,1,1,'3052910018924','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:26:10','2019-10-02 21:26:10',NULL),(2902,'Cowhead Cappuccino butter Cookies 150g',9,'single',19,84,18,NULL,NULL,'exclusive',240,0,1,1,'8888440010726','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:30:20','2019-10-02 21:30:20',NULL),(2903,'Cowhead Green tea  butter Cookies 150g',9,'single',19,84,18,NULL,NULL,'exclusive',240,0,1,1,'8888440008754','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:36:13','2019-10-02 21:36:13',NULL),(2904,'Cowhead Crispy Cheese Crackers butter Cookies 208g',9,'single',19,84,42,NULL,NULL,'exclusive',350,0,1,1,'8888440007962','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:43:25','2019-10-02 21:45:19',NULL),(2905,'Cowhead Peanut butter Crackers  190g',9,'single',19,84,42,NULL,NULL,'exclusive',240,0,1,1,'8888440007139','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:49:30','2019-10-02 21:49:30',NULL),(2906,'Cowhead  Wheat Bran Crackers 178g',9,'single',19,84,42,NULL,NULL,'exclusive',200,0,1,1,'8888440007016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:52:12','2019-10-02 21:52:12',NULL),(2907,'Cowhead Natural Oats 178g',9,'single',19,84,28,NULL,NULL,'exclusive',200,0,1,1,'8888440007023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 21:55:03','2019-10-02 21:55:03',NULL),(2908,'Sanitarium Weet-Bix 375gm',9,'single',19,416,52,NULL,NULL,'exclusive',400,0,1,1,'9300652010374','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:02:38','2020-08-13 00:36:30',NULL),(2909,'Sanitarium Weet-Bix  Bites 500gm',9,'single',19,143,44,NULL,NULL,'exclusive',575,0,1,1,'9300652801293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:04:48','2020-08-13 00:39:51',NULL),(2910,'Sanitarium Weet-Bix Bites C.H 510gm',9,'single',19,143,44,NULL,NULL,'exclusive',575,0,1,1,'9300652801309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:06:27','2019-10-02 23:06:27',NULL),(2911,'So Good Almond Original Milk 1Ltr',9,'single',19,416,26,NULL,NULL,'exclusive',350,0,1,1,'9300652803020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:10:13','2019-10-02 23:10:13',NULL),(2912,'Sanitarium Weet-Bix 575gm',9,'single',19,143,44,NULL,NULL,'exclusive',650,0,1,1,'9300652805048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:12:53','2019-10-02 23:12:53',NULL),(2913,'Golden Circle Sparkling Crisp Apple 750ml',9,'single',19,141,24,NULL,NULL,'exclusive',450,0,1,1,'9310179002837','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:17:08','2019-10-02 23:17:08',NULL),(2914,'Golden Circle Sparkling Crisp Apple .T Punch 750ml',9,'single',19,141,24,NULL,NULL,'exclusive',450,0,1,1,'9310179002868','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:27:01','2019-10-02 23:27:01',NULL),(2915,'Golden Circle Sparkling Crisp Apple 250ml',9,'single',19,141,24,NULL,NULL,'exclusive',140,0,1,1,'9310179002912','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:28:17','2019-10-02 23:28:17',NULL),(2916,'Golden Circle Sparkling Crisp Apple .T Punch 250ml',9,'single',19,141,24,NULL,NULL,'exclusive',130,0,1,1,'9310179002950','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:29:33','2019-10-02 23:29:33',NULL),(2917,'Leggo\'s Vegetable W Carrot Capsicum 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,0,1,1,'9300645111217','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:33:04','2019-10-02 23:33:04',NULL),(2918,'Leggos Pesto Basil 190gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,0,1,1,'93352192','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:34:46','2020-08-13 00:46:51',NULL),(2919,'Leggos Roasted garlic Sauce 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,0,1,1,'9300645111231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:37:02','2020-08-13 00:50:53',NULL),(2920,'Leggos Carbonara  Sauce 500gm',9,'single',19,170,32,NULL,NULL,'exclusive',390,0,1,1,'9300645111262','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:38:56','2019-10-02 23:38:56',NULL),(2921,'Whole Kernel Corn 425gm',9,'single',19,417,11,NULL,NULL,'exclusive',65,0,1,1,'5601522477513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-02 23:41:19','2019-10-02 23:41:19',NULL),(2922,'Remia Thousand Island Dressing 250ml',9,'single',19,44,32,NULL,NULL,'exclusive',150,0,1,1,'8710448595779','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:10:36','2019-10-03 00:10:36',NULL),(2923,'Heinz Beanz 415gm',9,'single',19,13,11,NULL,NULL,'exclusive',100,0,1,1,'0173644487','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:16:17','2019-10-03 00:16:17',NULL),(2925,'Kraft Cream Cheese Spread Cheddar 250 gm',9,'single',19,253,13,NULL,NULL,'exclusive',300,0,1,1,'9300657660147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:21:19','2019-10-03 00:21:19',NULL),(2926,'Kraft Cream Cheese Spread Cheddar 500 gm',9,'single',19,253,13,NULL,NULL,'exclusive',600,0,1,1,'9300657660208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:22:36','2019-10-03 00:22:36',NULL),(2927,'Kraft Cream Cheese Cheddar 500 gm',9,'single',19,253,13,NULL,NULL,'exclusive',680,0,1,1,'9300657660185','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:24:34','2019-10-03 00:24:34',NULL),(2928,'Leggos Tomato Puree 410gm',9,'single',19,170,11,NULL,NULL,'exclusive',115,0,1,1,'9300645024067','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:28:55','2019-10-03 00:28:55',NULL),(2929,'Gerber Oatmeal Apple Cinamon Cereal 227 gm',9,'single',19,145,59,NULL,NULL,'exclusive',500,0,1,1,'015000070304','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 00:51:16','2019-10-03 00:51:16',NULL),(2930,'Kellogg\'s  Chocos 375gm',9,'single',19,128,21,NULL,NULL,'exclusive',325,0,1,1,'8901499007964','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 14:47:31','2019-10-03 14:47:31',NULL),(2931,'Kellogg\'s Corn Flakes  475gm',9,'single',19,128,21,NULL,NULL,'exclusive',365,0,1,1,'8901499008190','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 14:53:17','2019-10-03 14:53:17',NULL),(2932,'Kellogg\'s Crunchy Granola Almonds  150gm',9,'single',19,128,28,NULL,NULL,'exclusive',240,0,1,1,'8901499009722','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 14:58:06','2019-10-03 14:58:06',NULL),(2933,'Kellogg\'s  Froot Loops 160gm',9,'single',19,128,28,NULL,NULL,'exclusive',350,0,1,1,'8852756303049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 15:02:03','2019-10-03 15:02:03',NULL),(2934,'Kellogg\'s  Special K Multigrain oats & Honey 435gm',9,'single',19,128,21,NULL,NULL,'exclusive',400,0,1,1,'8901499008923','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 15:07:13','2019-10-03 15:07:13',NULL),(2935,'Pringles Original Chips 147gm',9,'single',19,101,14,NULL,NULL,'exclusive',180,0,1,1,'8886467100079','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 15:14:39','2020-03-09 19:35:44',NULL),(2936,'Belgian Dark Chocolate SeaShells 250gm',9,'single',19,333,15,NULL,NULL,'exclusive',750,0,1,1,'5413121359844','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 16:52:23','2019-10-03 16:52:23',NULL),(2937,'Lindt Excellence Cherry Intense 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,0,1,1,'7610400080354','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:04:41','2019-10-03 17:04:41',NULL),(2938,'Lindt Excellence Strawberry  Intense 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,0,1,1,'3046920027458','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:08:08','2019-10-03 17:08:35',NULL),(2939,'Lindt Excellence Orange Intense 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,0,1,1,'3046920028370','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:10:46','2019-10-03 17:10:46',NULL),(2940,'Lindt swiss Classic Almonds chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,0,1,1,'7610400014038','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:17:11','2019-10-03 17:17:11',NULL),(2941,'Lindt swiss Classic Hazelnuts  chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',340,0,1,1,'7610400010023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:18:21','2019-10-03 17:18:21',NULL),(2943,'Camel Roasted cashews  40gm',9,'single',19,58,53,NULL,NULL,'exclusive',120,0,1,1,'8888112011006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:23:32','2019-10-03 17:24:43',NULL),(2944,'Cassava chips Original 150gm',9,'single',19,418,14,NULL,NULL,'exclusive',270,0,1,1,'8888112000284','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:32:18','2019-10-03 17:32:18',NULL),(2945,'Cassava chips Spicy  150gm',9,'single',19,418,14,NULL,NULL,'exclusive',270,0,1,1,'8888112000277','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-03 17:33:09','2019-10-03 17:33:09',NULL),(2946,'sunfeast Bounce tangy orange 41g',9,'single',19,281,5,NULL,NULL,'exclusive',15,0,1,1,'8901725133511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-04 00:36:04','2019-10-11 20:56:21',NULL),(2947,'NIDO 1+ 1800G',9,'single',19,63,64,NULL,NULL,'exclusive',3100,0,1,1,'6294003575274','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 14:54:25','2020-01-04 19:40:39',NULL),(2948,'NIDO 1+ 900G',9,'single',19,63,64,NULL,NULL,'exclusive',1690,0,1,1,'6294003575250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 14:56:12','2020-03-17 17:52:00',NULL),(2949,'act ii  magical popcorn tub 130g',9,'single',19,189,NULL,NULL,NULL,'exclusive',165,0,1,1,'8901512506801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 20:21:13','2019-10-06 20:21:13',NULL),(2950,'Act ii Butter Lovers Flavour 33gm',9,'single',19,189,44,NULL,NULL,'exclusive',45,0,1,1,'8901512507600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 20:27:24','2019-10-06 20:28:29',NULL),(2951,'act ii caramel bliss 70g',9,'single',19,189,44,NULL,NULL,'exclusive',150,0,1,1,'8901512562906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 20:32:06','2019-10-06 20:32:06',NULL),(2952,'act ii caramel bliss 70g',9,'single',19,189,44,NULL,NULL,'exclusive',150,0,1,1,'8901512562906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 20:32:07','2019-10-06 20:32:07',NULL),(2953,'act ii caramel bliss nutty popcorn 80g',9,'single',19,189,44,NULL,NULL,'exclusive',170,0,1,1,'8901512555007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 20:42:30','2019-10-06 20:42:30',NULL),(2954,'Sunfeast bounce choco cream 41g',9,'single',19,281,5,NULL,NULL,'exclusive',15,0,1,1,'8901725133535','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 21:07:50','2019-10-11 20:55:56',NULL),(2955,'Crown Real Mayonnaise 473gm',9,'single',19,299,25,NULL,NULL,'exclusive',0,0,1,1,'012656110262','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 21:44:07','2019-10-06 21:44:07',NULL),(2956,'Kokola Majorico Wafer Roll 300gm',9,'single',19,419,55,NULL,NULL,'exclusive',0,0,1,1,'8998389162230','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 21:54:01','2019-10-06 21:54:01',NULL),(2957,'Kokola Majorico Wafer Roll 300gm',9,'single',19,419,NULL,NULL,NULL,'exclusive',0,0,1,1,'8998389162247','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 21:55:31','2019-10-06 21:55:31',NULL),(2958,'Kokola Mojorico Wafer Roll 300gm',9,'single',19,419,55,NULL,NULL,'exclusive',0,0,1,1,'8998389162261','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 21:56:50','2019-10-06 21:56:50',NULL),(2959,'Kokola Kukis\'n Krim Vanilla 400gm',9,'single',19,419,18,NULL,NULL,'exclusive',0,0,1,1,'8998389622413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:00:13','2019-10-06 22:00:13',NULL),(2960,'Kokola Chocolate Crackers 400gm',9,'single',19,419,42,NULL,NULL,'exclusive',545,0,1,1,'8998389132011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:01:58','2019-10-06 22:01:58',NULL),(2961,'Kokola Cheese Crackers 400gm',9,'single',19,419,42,NULL,NULL,'exclusive',545,0,1,1,'8998389632023','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:03:14','2019-10-06 22:03:14',NULL),(2962,'Kokola Montego Gold Double Choco Cookies 225gm',9,'single',19,419,18,NULL,NULL,'exclusive',315,0,1,1,'8998389124115','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:05:57','2019-10-06 22:05:57',NULL),(2963,'Kokola Montego Gold  Choco Banana Cookies 225gm',9,'single',19,419,18,NULL,NULL,'exclusive',315,0,1,1,'8998389124108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:17:03','2019-10-06 22:17:03',NULL),(2964,'Kokola Mini Choco Chips 150gm',9,'single',19,419,18,NULL,NULL,'exclusive',250,0,1,1,'8998389621386','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:19:59','2019-10-06 22:19:59',NULL),(2965,'Harvey Fresh UHT Apple Juice 1lt',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697100104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:46:01','2019-11-16 01:46:47',NULL),(2966,'Harvey Fresh UHT Orange Juice 1lt',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697100128','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:46:52','2019-11-16 01:48:05',NULL),(2967,'Harvey Fresh UHT Tropical Juice 1lt',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697101316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:47:36','2019-11-16 01:47:42',NULL),(2968,'Harvey Fresh UHT Apple Juice 250ml',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697107745','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:48:52','2019-10-06 22:48:52',NULL),(2969,'Harvey Fresh UHT Orange Juice 250ml',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697107738','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:49:50','2019-10-06 22:49:50',NULL),(2970,'Harvey Fresh UHT Tropical Juice 250ml',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697107752','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:50:40','2019-10-06 22:50:40',NULL),(2971,'Harvey Fresh UHT Apple & Balack Currant Juice 250ml',9,'single',19,332,24,NULL,NULL,'exclusive',0,0,1,1,'9311697108865','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-06 22:51:24','2019-10-06 22:51:24',NULL),(2972,'TAYAS Nitchi Wafer Stick Chocolate 330gm',9,'single',19,398,55,NULL,NULL,'exclusive',0,0,1,1,'8994391010743','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-07 00:24:18','2020-06-30 14:48:21',NULL),(2973,'Sunquick Campuran Tropical Juice 840 ml',9,'single',19,202,24,NULL,NULL,'exclusive',0,0,1,1,'9556107308101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-07 00:31:01','2019-10-07 00:31:01',NULL),(2974,'Sunquick Gold Blackcurrant 840 ml',9,'single',19,202,24,NULL,NULL,'exclusive',0,0,1,1,'9556107303106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-07 00:32:33','2019-10-07 00:32:33',NULL),(2975,'amul kool kesr 200ML',9,'single',19,291,26,NULL,NULL,'exclusive',75,0,1,1,'8901262150491','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-08 15:13:49','2019-10-08 15:13:49',NULL),(2976,'best tomato ketchup jar 4lit',9,'single',19,404,32,NULL,NULL,'exclusive',1150,0,1,1,'9556086001246','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-08 16:38:15','2019-10-08 16:38:15',NULL),(2977,'best chilli sauce jar 4lit',9,'single',19,404,32,NULL,NULL,'exclusive',1260,0,1,1,'9556086000140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-08 16:40:30','2019-10-08 16:40:30',NULL),(2978,'neelam rozana extra long grain aromatic rice 1kg',9,'single',19,420,54,NULL,NULL,'exclusive',205,0,1,1,'8901943006505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-08 16:51:41','2019-10-08 16:51:41',NULL),(2979,'empire bashmati rice 1 kg',9,'single',19,420,54,NULL,NULL,'exclusive',270,0,1,1,'8901943000114','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-08 16:55:22','2019-10-08 16:55:22',NULL),(2980,'FinCarre Dark Chocolate 100gm',9,'single',19,421,15,NULL,NULL,'exclusive',150,0,1,1,'20005832','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:06:00','2020-03-12 20:38:11',NULL),(2981,'FinCarre Milk Chocolate 100gm',9,'single',19,421,15,NULL,NULL,'exclusive',150,0,1,1,'20005825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:13:15','2020-03-12 20:37:48',NULL),(2982,'FinCarre White Chocolate 100gm',9,'single',19,421,15,NULL,NULL,'exclusive',150,0,1,1,'20368197','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:14:09','2020-03-12 20:37:25',NULL),(2983,'Nestle kitKat Chunky 4X 160gm',9,'single',19,63,15,NULL,NULL,'exclusive',250,0,1,1,'7613036245142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:25:31','2020-03-12 20:23:41',NULL),(2984,'Trident Cinnamon Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',140,0,1,1,'012546011471','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:39:43','2019-10-11 18:35:15',NULL),(2985,'Trident Original  Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',110,0,1,1,'070221008673','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:41:32','2019-10-10 15:41:32',NULL),(2986,'Trident Spearmint Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',110,0,1,1,'070221008697','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:43:27','2019-10-10 15:43:27',NULL),(2987,'Tower gate All Butter Shortbread 210gm',9,'single',19,423,6,NULL,NULL,'exclusive',225,0,1,1,'20114329','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 15:58:08','2020-03-12 20:49:57',NULL),(2988,'Almarai  Cheese Triangles 120gm',9,'single',19,254,13,NULL,NULL,'exclusive',140,0,1,1,'6281007032759','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 16:02:10','2020-09-17 16:31:20',NULL),(2989,'Trident Original  Gum 14',9,'single',19,109,22,NULL,NULL,'exclusive',140,0,1,1,'070221008680','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 16:10:54','2019-10-11 18:35:36',NULL),(2990,'Masafi  Cranberry Juice 1 lit',9,'single',19,81,24,NULL,NULL,'exclusive',320,0,1,1,'6291001014934','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 16:54:29','2019-10-10 16:54:29',NULL),(2991,'Cadbury  GEMS 17.8gm',9,'single',19,129,15,NULL,NULL,'exclusive',80,0,1,1,'8901233033877','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:15:21','2019-10-10 17:15:21',NULL),(2992,'Cadbury GEMS 17.8gm',9,'single',19,129,15,NULL,NULL,'exclusive',80,0,1,1,'8901233033211','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:17:26','2019-10-10 17:17:26',NULL),(2993,'Oreo ice Cream Biscuit 137gm',9,'single',19,87,5,NULL,NULL,'exclusive',100,0,1,1,'7622300442507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:21:34','2019-10-10 17:21:34',NULL),(2994,'Maccoffee gold 100gm',9,'single',19,NULL,16,NULL,NULL,'exclusive',435,0,1,1,'8887290130097','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:21:58','2019-10-10 17:21:58',NULL),(2995,'Maccoffee original 100gm',9,'single',19,424,16,NULL,NULL,'exclusive',335,0,1,1,'8887290130028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:26:45','2019-10-10 17:26:45',NULL),(2996,'Sammi Aloe Drink  1.5ltr',9,'single',19,425,24,NULL,NULL,'exclusive',460,0,1,1,'8801887800675','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:32:13','2019-10-10 17:43:37',NULL),(2997,'Stute Superior Cranberry 1.5ltr',9,'single',19,155,24,NULL,NULL,'exclusive',414,0,1,1,'2997','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:35:31','2019-10-10 17:35:31',NULL),(2998,'Maccoffee Original3b1 (16pcs)',9,'single',19,424,16,NULL,NULL,'exclusive',180,0,1,1,'2998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:42:28','2019-10-10 17:42:28',NULL),(2999,'Maccoffee coffee n creamer 2b1(20pcs)',9,'single',19,424,16,NULL,NULL,'exclusive',290,0,1,1,'2999','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:46:48','2019-10-10 17:46:48',NULL),(3001,'Oat choco original 400gm premium',9,'single',19,392,3,NULL,NULL,'exclusive',440,0,1,1,'9556920001425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 17:57:23','2019-10-10 17:57:23',NULL),(3002,'mactea  lemon 20 packet',9,'single',19,424,NULL,NULL,NULL,'exclusive',185,0,1,1,'8887290105019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:07:29','2019-10-10 18:07:29',NULL),(3003,'Maccoffee pouch strong 20packet',9,'single',19,424,16,NULL,NULL,'exclusive',300,0,1,1,'8887290101080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:10:57','2019-10-10 20:02:33',NULL),(3004,'rico mix fruits pudding packet -250gm',9,'single',19,426,15,NULL,NULL,'exclusive',110,0,1,1,'9556619116669','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:17:51','2019-10-10 18:17:51',NULL),(3005,'maccoffee capppuccino creamy-8 pcs',9,'single',19,424,16,NULL,NULL,'exclusive',150,0,1,1,'8887290151405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:20:28','2019-10-10 18:20:28',NULL),(3006,'twinfish original oatchoco 200gm',9,'single',19,392,3,NULL,NULL,'exclusive',240,0,1,1,'9556920002668','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:23:20','2019-10-10 18:23:20',NULL),(3007,'rico assorted pudding tray 570gm',9,'single',19,427,59,NULL,NULL,'exclusive',255,0,1,1,'9556619117567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:27:26','2019-10-10 18:27:26',NULL),(3008,'khong guan saltcheese crackers-200gm',9,'single',19,287,5,NULL,NULL,'exclusive',160,0,1,1,'8888166321106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:30:22','2020-09-09 18:12:50',NULL),(3009,'maccoffee white coffee-12pcs',9,'single',19,424,16,NULL,NULL,'exclusive',15,0,1,1,'8887290130547','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:33:30','2019-10-10 18:33:30',NULL),(3010,'maccoffee classic tin-200gm',9,'single',19,424,16,NULL,NULL,'exclusive',400,0,1,1,'8887290130387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:35:18','2019-10-10 18:35:18',NULL),(3011,'maccoffee original jar -200gm',9,'single',19,424,16,NULL,NULL,'exclusive',530,0,1,1,'8887290129992','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:38:07','2019-10-10 18:38:07',NULL),(3012,'maccoffee original jar-50gm',9,'single',19,424,16,NULL,NULL,'exclusive',195,0,1,0,'8887290129985','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:40:08','2019-10-10 18:40:08',NULL),(3013,'deka wafer roll tin choco nut-360gm',9,'single',19,323,55,NULL,NULL,'exclusive',415,0,1,1,'8995077603785','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:43:30','2019-10-10 18:43:30',NULL),(3014,'frixe chocolate roll tin- 370 gm',9,'single',19,428,55,NULL,NULL,'exclusive',390,0,1,1,'8993083929097','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:48:24','2019-10-10 18:48:24',NULL),(3015,'frixe cappucino roll tin-370gm',9,'single',19,428,55,NULL,NULL,'exclusive',390,0,1,1,'8993083929110','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:49:51','2019-10-10 18:49:51',NULL),(3016,'frixe vanilla roll tin-370gm',9,'single',19,428,55,NULL,NULL,'exclusive',390,0,1,1,'8993083929103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:51:13','2019-10-10 18:51:13',NULL),(3017,'deka wafer roll tin chocobanana',9,'single',19,323,55,NULL,NULL,'exclusive',415,0,1,1,'8995077609008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:54:12','2019-10-10 18:54:12',NULL),(3018,'tova strawberry jam- 450gm',9,'single',19,429,23,NULL,NULL,'exclusive',345,0,1,1,'8711173007605','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:56:31','2019-10-10 18:56:31',NULL),(3019,'maccoffee gold jar-50gm',9,'single',19,424,16,NULL,NULL,'exclusive',265,0,1,1,'8887290130257','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 18:58:43','2019-10-10 18:58:43',NULL),(3020,'rico mix fruits pudding packet -750gm',9,'single',19,427,7,NULL,NULL,'exclusive',280,0,1,1,'9556619116539','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 19:04:20','2019-10-10 19:04:20',NULL),(3021,'mace coffee coffee&creamer 20pcs',9,'single',19,424,16,NULL,NULL,'exclusive',0,0,1,1200,'8887290101295','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 19:21:20','2019-10-10 19:24:00',NULL),(3022,'Maccoffee original 16pkt',9,'single',19,424,16,NULL,NULL,'exclusive',0,0,1,1,'8887290140041','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 19:27:58','2019-10-10 19:27:58',NULL),(3023,'Maccoffee original 50gmpoucs',9,'single',19,424,16,NULL,NULL,'exclusive',0,0,1,1,'8887290130080','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 19:35:16','2019-10-10 19:35:16',NULL),(3024,'tova mix fruit jam- 450gm',9,'single',19,429,23,NULL,NULL,'exclusive',0,0,1,1,'8711173007650','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 19:48:44','2019-10-10 19:48:44',NULL),(3025,'Cashew Nut 500gm',9,'single',19,273,53,NULL,NULL,'exclusive',475,0,1,1,'120201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:49:03','2019-10-10 20:49:03',NULL),(3026,'Cashew Nut300gm',9,'single',19,273,53,NULL,NULL,'exclusive',285,0,1,1,'120202','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:50:02','2019-10-10 20:50:02',NULL),(3027,'Cashew Nut 150gm',9,'single',19,273,53,NULL,NULL,'exclusive',145,0,1,1,'120203','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:50:49','2019-10-10 20:50:49',NULL),(3028,'Ispaghula Husk (Isapgul) M 200gm',9,'single',19,273,66,NULL,NULL,'exclusive',130,0,1,1,'120204','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:52:32','2019-10-10 20:52:32',NULL),(3029,'Ispaghula Husk (Isapgul) M 100gm',9,'single',19,273,66,NULL,NULL,'exclusive',65,0,1,1,'120205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:53:24','2019-10-10 20:53:24',NULL),(3030,'Nutmeg (Jaifol) L 200gm',9,'single',19,273,66,NULL,NULL,'exclusive',130,0,1,1,'120206','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:54:55','2019-10-10 20:54:55',NULL),(3031,'Nutmeg (Jaifol) L 100gm',9,'single',19,273,66,NULL,NULL,'exclusive',65,0,1,1,'120207','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:56:04','2019-10-10 20:56:04',NULL),(3032,'Chia Seed (Tokma) 200gm',9,'single',19,273,2,NULL,NULL,'exclusive',100,0,1,1,'120208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:57:30','2019-10-10 20:57:30',NULL),(3033,'Chia Seed (Tokma) 100gm',9,'single',19,273,2,NULL,NULL,'exclusive',50,0,1,1,'120209','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-10 20:58:15','2019-10-10 20:58:15',NULL),(3034,'Lale Milk Chocolate',9,'single',19,430,NULL,NULL,NULL,'exclusive',0,0,1,1,'001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-11 15:22:50','2019-10-11 15:22:50',NULL),(3035,'Aksu Chocolate Single Joy 500gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'8697413803285','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-11 16:40:46','2020-07-18 23:19:20',NULL),(3036,'Aksu Chocolate ( carmelo) yellow',9,'single',19,431,NULL,NULL,NULL,'exclusive',0,0,1,1,'8697413801533','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-11 16:44:14','2019-10-11 16:44:14',NULL),(3037,'Aksu Chocolate ( carmelo) yellow 500Pk',9,'single',19,431,NULL,NULL,NULL,'exclusive',0,0,1,1,'8697413801534','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-11 16:45:55','2019-10-11 16:45:55',NULL),(3038,'Aksu Chocolate ( Assorted) 500Pk',9,'single',19,431,NULL,NULL,NULL,'exclusive',0,0,1,1,'8697413801977','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-11 16:47:04','2019-10-11 16:47:04',NULL),(3039,'Kitkat Crispy Caramel Pieces 18X  351gm',9,'single',19,63,15,NULL,NULL,'exclusive',1000,0,1,1,'6294003571610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 16:37:24','2019-10-12 16:37:24',NULL),(3040,'Kitkat Crunchy Cookie Pieces 351gm',9,'single',19,63,15,NULL,NULL,'exclusive',1000,0,1,1,'6294003569013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 16:40:03','2019-10-12 16:40:03',NULL),(3041,'Kitkat Crunchy Hazelnut Pieces 351gm',9,'single',19,63,15,NULL,NULL,'exclusive',1000,0,1,1,'6294003571689','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 16:42:52','2019-10-12 16:42:52',NULL),(3042,'Loacker Napolitaner Wafer 450gm',9,'single',19,432,55,NULL,NULL,'exclusive',1050,0,1,1,'8000380145096','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 16:54:15','2019-10-12 16:54:15',NULL),(3043,'Kitkat Chunky Milk 240gm',9,'single',19,63,15,NULL,NULL,'exclusive',470,0,1,1,'3800020433645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 16:56:59','2019-10-12 16:56:59',NULL),(3044,'Galaxy Smooth Dark 40gm',9,'single',19,110,15,NULL,NULL,'exclusive',120,0,1,1,'6294001815266','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 17:43:55','2019-10-12 17:43:55',NULL),(3045,'Galaxy  Dark Chocolate Creme 38gm',9,'single',19,110,15,NULL,NULL,'exclusive',120,0,1,1,'6294001827672','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 17:46:10','2019-10-12 17:46:10',NULL),(3046,'Galaxy Vanilla Creme   38gm',9,'single',19,110,15,NULL,NULL,'exclusive',120,0,1,1,'6221134006285','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 17:48:39','2019-10-12 17:48:39',NULL),(3047,'Kinder Bueno Mini Mix 205gm',9,'single',19,69,15,NULL,NULL,'exclusive',900,0,1,1,'8000500310847','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 18:01:13','2019-10-12 18:01:13',NULL),(3048,'Kinder Chocolate 120gm',9,'single',19,69,15,NULL,NULL,'exclusive',550,0,1,1,'8000500256213','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 18:05:19','2020-09-17 16:07:56',NULL),(3049,'Nestle Kitkat Mini 217gm',9,'single',19,63,15,NULL,NULL,'exclusive',620,0,1,1,'7613033110603','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:13:07','2019-10-12 19:13:07',NULL),(3050,'Mentos White Gum 38pcs',9,'single',19,433,22,NULL,NULL,'exclusive',280,0,1,1,'8935001706588','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:17:53','2019-10-12 19:17:53',NULL),(3051,'Lollipop 85gm',9,'single',19,434,57,NULL,NULL,'exclusive',180,0,1,1,'6939501804371','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:23:56','2019-10-12 19:23:56',NULL),(3052,'Mentos Rainbow 29gm',9,'single',19,261,15,NULL,NULL,'exclusive',50,0,1,1,'8990800015347','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:38:39','2019-10-12 19:38:39',NULL),(3053,'Mentos Say Hello Min 29gm',9,'single',19,261,22,NULL,NULL,'exclusive',50,0,1,1,'8990800015224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:40:48','2019-10-12 19:40:48',NULL),(3054,'Mentos Say Hello Fruit 29gm',9,'single',19,261,22,NULL,NULL,'exclusive',50,0,1,1,'8990800015255','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:41:55','2019-10-12 19:41:55',NULL),(3055,'Mentos Strawberry 29gm',9,'single',19,261,22,NULL,NULL,'exclusive',50,0,1,1,'8990800015286','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:46:15','2019-10-12 19:46:15',NULL),(3056,'Mentos Tutti Frutti 29gm',9,'single',19,261,22,NULL,NULL,'exclusive',50,0,1,1,'8990800015316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:47:51','2019-10-12 19:47:51',NULL),(3057,'Mentos Watermelon  29gm',9,'single',19,261,22,NULL,NULL,'exclusive',50,0,1,1,'8990800017112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:49:01','2019-10-12 19:49:01',NULL),(3058,'Kinder Bueno 215gm',9,'single',19,69,15,NULL,NULL,'exclusive',480,0,1,1,'8000500199541','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:53:30','2019-10-12 19:53:30',NULL),(3059,'Kinder Chocolate 50gm',9,'single',19,69,15,NULL,NULL,'exclusive',135,0,1,1,'80177609','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 19:56:08','2019-10-12 19:56:08',NULL),(3060,'similac 2 800g',9,'single',19,209,64,NULL,NULL,'exclusive',2350,0,1,1,'2327723057240','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:04:41','2019-10-12 20:04:41',NULL),(3061,'Kinder Chocolate W Ceeals 211.5gm',9,'single',19,69,15,NULL,NULL,'exclusive',750,0,1,1,'4008400260921','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:06:25','2019-10-12 20:06:25',NULL),(3062,'Chupa Chups Mini 210gm',9,'single',19,148,57,NULL,NULL,'exclusive',620,0,1,1,'8410031936988','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:10:49','2019-10-12 20:10:49',NULL),(3063,'Loacker Cremkakao Wafer 45gm',9,'single',19,432,55,NULL,NULL,'exclusive',130,0,1,1,'80001263','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:16:07','2019-10-12 20:16:07',NULL),(3064,'Loacker Napolitaner Wafer 45gm',9,'single',19,432,55,NULL,NULL,'exclusive',130,0,1,1,'80001218','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:20:21','2019-10-12 20:20:21',NULL),(3065,'Gardena Hazelnut 38gm',9,'single',19,432,55,NULL,NULL,'exclusive',130,0,1,1,'80001287','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:21:45','2019-10-12 20:21:45',NULL),(3066,'nestle nan 2 imp 800',9,'single',19,63,64,NULL,NULL,'exclusive',2300,0,1,1,'7613036848039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:22:05','2019-11-11 17:30:42',NULL),(3067,'Gardena Coconut Wafer 38gm',9,'single',19,432,55,NULL,NULL,'exclusive',130,0,1,1,'1','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:22:57','2019-10-12 20:22:57',NULL),(3068,'Gardena Coconut Wafer 38gm',9,'single',19,432,55,NULL,NULL,'exclusive',130,0,1,1,'80001485','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:23:52','2019-10-12 20:23:52',NULL),(3069,'Gardena Chocolate Wafer 38gm',9,'single',19,432,55,NULL,NULL,'exclusive',130,0,1,1,'80001461','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:24:52','2019-10-12 20:24:52',NULL),(3070,'similac gold 800g',9,'single',19,388,64,NULL,NULL,'exclusive',2250,0,1,1,'5391523057240','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 20:31:56','2020-01-04 19:43:12',NULL),(3071,'Foster Clarks Custard Powder 450gm',9,'single',19,57,52,NULL,NULL,'exclusive',235,0,1,1,'5352101542893','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 21:02:34','2019-10-12 21:02:34',NULL),(3072,'Foster Clark\'s Baking  Powder 450gm',9,'single',19,57,48,NULL,NULL,'exclusive',260,0,1,1,'5352101013010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 21:07:29','2019-10-12 21:07:29',NULL),(3073,'Borges Olive Oil Extra Virgin 500ml',9,'single',19,70,29,NULL,NULL,'exclusive',500,0,1,1,'8410179100036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 21:23:01','2019-10-12 21:23:01',NULL),(3074,'doritos spicy sweet chilli 92.1g',9,'single',19,194,44,NULL,NULL,'exclusive',200,0,1,1,'028400077682','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-12 22:04:38','2019-10-12 22:04:38',NULL),(3075,'Virgina G G Basil Seed Drinks Banana Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001048295','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 19:55:21','2019-10-13 19:55:21',NULL),(3076,'Virgina G G Basil Seed Drinks Lychee Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001051295','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 19:56:27','2019-10-13 19:56:27',NULL),(3077,'Virgina G G Basil Seed Drinks Mango Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001046291','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 19:57:37','2019-10-13 19:57:37',NULL),(3078,'Virgina G G Basil Seed Drinks Mixed Fruit Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001041296','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 19:59:31','2019-10-13 19:59:31',NULL),(3079,'Virginia G G Basil Seed Drinks Orange Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001044297','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:00:40','2019-10-13 20:00:40',NULL),(3080,'Virginia G G Basil Seed Drinks Pineapple Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001045294','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:02:08','2019-10-13 20:02:08',NULL),(3081,'Virginia G G Basil Seed Drinks Strawberry Flv 290ml',9,'single',19,204,24,NULL,NULL,'exclusive',85,0,1,1,'8805001047298','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:03:05','2019-10-13 20:03:05',NULL),(3082,'Virginia G G  Orange Juice Flv 240ml',9,'single',19,204,24,NULL,NULL,'exclusive',75,0,1,1,'6291080062406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:07:26','2019-10-13 20:07:26',NULL),(3083,'Virginia G G  Peach Juice  240ml',9,'single',19,204,24,NULL,NULL,'exclusive',75,0,1,1,'6291080072405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:08:41','2019-10-13 20:08:41',NULL),(3084,'Virginia G G  Pineapple Juice  240ml',9,'single',19,204,24,NULL,NULL,'exclusive',75,0,1,1,'6291080092403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:10:18','2019-10-13 20:10:18',NULL),(3085,'Virginia Classic Mayonnaise 500ml',9,'single',19,204,25,NULL,NULL,'exclusive',220,0,1,1,'6291105008501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:24:54','2019-10-13 20:24:54',NULL),(3086,'Virginia G G  Light Flakes Tuna 185gm',9,'single',19,204,8,NULL,NULL,'exclusive',130,0,1,1,'8805006541852','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:36:29','2019-10-13 20:36:29',NULL),(3087,'Virginia G G Light Meat Tuna 185gm',9,'single',19,204,8,NULL,NULL,'exclusive',190,0,1,1,'8805004561852','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 20:57:37','2019-10-13 20:57:37',NULL),(3088,'Virginia G G Sardines Natural oil 155gm',9,'single',19,204,29,NULL,NULL,'exclusive',160,0,1,1,'8805001401557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:00:39','2019-10-13 21:00:39',NULL),(3089,'Virginia G G Sardines Tomato Sauce 155gm',9,'single',19,204,32,NULL,NULL,'exclusive',160,0,1,1,'8805001201553','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:02:27','2019-10-13 21:02:27',NULL),(3090,'Virginia G G Sardines Tomato Sauce W Chili oil 155gm',9,'single',19,204,32,NULL,NULL,'exclusive',160,0,1,1,'8805001301550','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:03:38','2019-10-13 21:03:38',NULL),(3091,'Virginia G G Hot Sauce 88ml',9,'single',19,204,32,NULL,NULL,'exclusive',70,0,1,1,'9501026100886','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:09:25','2019-10-13 21:09:25',NULL),(3092,'Virginia G G Bold & Spice Sriracha Sauce-200g',9,'single',19,204,32,NULL,NULL,'exclusive',220,0,1,1,'8903050042001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:11:58','2019-10-13 21:11:58',NULL),(3093,'Virginia G G Garlic Sauce-190gm',9,'single',19,204,32,NULL,NULL,'exclusive',220,0,1,1,'8903050082007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:12:59','2019-10-13 21:12:59',NULL),(3094,'Virginia G G Teriyaki Japanese Cuisine-200gm',9,'single',19,204,32,NULL,NULL,'exclusive',250,0,1,1,'8903050022003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:14:55','2019-10-13 21:14:55',NULL),(3095,'Virginia G G Tomato Ketchuo-340gm',9,'single',19,204,45,NULL,NULL,'exclusive',95,0,1,1,'6905006573401','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:17:59','2019-10-13 21:17:59',NULL),(3096,'Virginia G G Soy Sauce-150ml',9,'single',19,204,32,NULL,NULL,'exclusive',120,0,1,1,'6905003409154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:20:15','2019-10-13 21:20:15',NULL),(3097,'Virginia G G Spanish Extra Virgin Olive Oil-10ltr',9,'single',19,204,29,NULL,NULL,'exclusive',6500,0,1,1,'6299009876103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:24:51','2019-10-13 21:24:51',NULL),(3098,'Virginia G G Pitted Black Olives-340gm',9,'single',19,204,49,NULL,NULL,'exclusive',180,0,1,1,'6225009773609','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:26:44','2019-10-13 21:26:44',NULL),(3099,'Virginia G G Pitted Green Olives-340gm',9,'single',19,204,49,NULL,NULL,'exclusive',190,0,1,1,'6225008663604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:28:29','2019-10-13 21:28:29',NULL),(3100,'Virginia G G Sliced Green Olives-340gm',9,'single',19,204,49,NULL,NULL,'exclusive',170,0,1,1,'6225008683602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:30:04','2019-10-13 21:30:04',NULL),(3101,'Virginia G G Sliced Black Olives-340gm',9,'single',19,204,49,NULL,NULL,'exclusive',165,0,1,1,'6225009793607','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-13 21:31:51','2019-10-13 21:31:51',NULL),(3102,'Promess Whole Milk 1ltr',9,'single',19,435,26,NULL,NULL,'exclusive',320,0,1,1,'3102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-14 19:35:28','2019-10-14 19:35:28',NULL),(3103,'Promess Whole Milk 1ltr',9,'single',19,435,26,NULL,NULL,'exclusive',190,0,1,1,'3760128640041','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-14 19:36:10','2019-11-22 16:05:40',NULL),(3104,'Promess Semi-Skimmed  Milk 1ltr',9,'single',19,435,26,NULL,NULL,'exclusive',220,0,1,1,'3760128640133','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-14 19:37:34','2019-11-22 16:08:22',NULL),(3105,'Promess Skimmed Milk 1ltr',9,'single',19,435,26,NULL,NULL,'exclusive',220,0,1,1,'3760128640140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-14 19:38:30','2019-11-22 16:07:54',NULL),(3106,'Shezan Mango Bar',9,'single',19,329,NULL,NULL,NULL,'exclusive',0,0,1,2147483647,'3106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-14 20:39:42','2019-10-14 20:39:42',NULL),(3107,'basundhara hand towel 250pcs*1ply',9,'single',19,395,69,NULL,NULL,'exclusive',70,0,1,1,'8941193064160','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 15:19:36','2019-10-15 15:19:36',NULL),(3108,'Amul milk chocolate smooth and creamy 150g',9,'single',19,291,15,NULL,NULL,'exclusive',175,0,1,1,'8901262070430','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 15:45:43','2020-07-21 21:36:33',NULL),(3109,'Arla whole milk 1lit',9,'single',19,211,26,NULL,NULL,'exclusive',170,0,1,1,'5709310050303','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:04:20','2019-10-15 17:04:20',NULL),(3110,'arla low fat milk 1lit',9,'single',19,211,26,NULL,NULL,'exclusive',170,0,1,1,'5709310051614','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:06:18','2019-10-15 17:06:18',NULL),(3111,'american garden popcorn natural 273g',9,'single',19,150,44,NULL,NULL,'exclusive',200,0,1,1,'017273550309','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:08:28','2019-10-15 17:09:11',NULL),(3112,'american garden popcorn cheese  273g',9,'single',19,150,44,NULL,NULL,'exclusive',200,0,1,1,'017273550361','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:11:28','2019-10-15 17:11:28',NULL),(3113,'american garden popcorn butter 273g',9,'single',19,150,44,NULL,NULL,'exclusive',200,0,1,1,'017273550316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:15:08','2019-10-15 17:15:08',NULL),(3114,'american Garden Thousand Island Dressing 267ml',9,'single',19,150,32,NULL,NULL,'exclusive',205,0,1,1,'717273504820','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:19:45','2019-10-15 17:19:45',NULL),(3115,'American Garden Creamy Caesar Dressing 473ml',9,'single',19,150,32,NULL,NULL,'exclusive',305,0,1,1,'717273504851','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:23:46','2019-10-15 17:23:46',NULL),(3116,'American Garden Jalapeno pepper Slice 454 g',9,'single',19,150,32,NULL,NULL,'exclusive',240,0,1,1,'717273504219','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:25:52','2019-10-15 17:25:52',NULL),(3117,'Quality mozzarella premium cheese 250g',9,'single',19,436,13,NULL,NULL,'exclusive',170,0,1,1,'8941136004703','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-15 17:49:36','2020-01-04 19:30:49',NULL),(3118,'Good Day Mocachino 20gm',9,'single',19,314,16,NULL,NULL,'exclusive',0,0,1,1,'3118','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-16 14:50:28','2019-10-16 14:50:28',NULL),(3119,'Good Day Mocachino 20gm',9,'single',19,314,16,NULL,NULL,'exclusive',110,0,1,1,'8991002103221','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-16 14:52:00','2019-10-16 14:52:00',NULL),(3120,'Mmay Poko Pants Extra Absorb L64 (9-14)kg',9,'single',19,275,68,NULL,NULL,'exclusive',1500,0,1,1,'8903622000286','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-16 15:28:07','2019-10-16 15:28:07',NULL),(3121,'Nestle Cerelac Honey & Wheat (12m) 400gm',9,'single',19,63,83,NULL,NULL,'exclusive',500,0,1,1,'7616100756865','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-16 15:39:50','2019-10-16 15:39:50',NULL),(3122,'Nestle Cerelac Mixed Fruits & Wheat (8m) 400gm',9,'single',19,63,83,NULL,NULL,'exclusive',450,0,1,1,'8410100181509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-16 15:41:39','2019-10-16 15:41:39',NULL),(3123,'Avena Oat Milk Snacks Bar 120gm',9,'single',19,437,3,NULL,NULL,'exclusive',140,0,1,1,'6928115015280','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-17 13:23:19','2019-10-17 13:23:19',NULL),(3124,'Zeeba Premium Basmati Rice 1kg',9,'single',19,438,54,NULL,NULL,'exclusive',300,0,1,1,'8906076271530','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-19 19:19:29','2019-10-19 19:19:29',NULL),(3125,'lowan rolled oats',9,'single',19,342,1,NULL,NULL,'exclusive',750,0,1,1,'9310598300255','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 15:36:21','2020-08-13 00:51:50',NULL),(3126,'Salted Cashew Nut 200gm',9,'single',19,273,53,NULL,NULL,'exclusive',235,0,1,1,'120210','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 15:46:48','2019-10-20 15:46:48',NULL),(3127,'Salted Cashew Nut 100gm',9,'single',19,273,53,NULL,NULL,'exclusive',120,0,1,1,'120211','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 15:48:10','2019-10-20 15:48:10',NULL),(3128,'Maryam Dates 500gm',9,'single',19,273,84,NULL,NULL,'exclusive',400,0,1,1,'120212','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 15:50:33','2019-10-20 15:50:33',NULL),(3129,'Maryam Dates 250gm',9,'single',19,273,84,NULL,NULL,'exclusive',200,0,1,1,'120213','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 15:51:43','2019-10-20 15:51:43',NULL),(3130,'nestle ceregrow multigrain & 5 fruites cereal with milk 300g',9,'single',19,63,64,NULL,NULL,'exclusive',340,0,1,1,'8901058867916','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 19:24:10','2019-10-20 19:24:10',NULL),(3131,'maggi saad a magic 48g',9,'single',19,408,50,NULL,NULL,'exclusive',50,0,1,1,'8941100294871','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 19:45:17','2019-10-20 19:45:17',NULL),(3132,'Nescafe Original (3 in 1) 150gm pouch',9,'single',19,63,37,NULL,NULL,'exclusive',100,0,1,1,'8941100294888','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 19:50:03','2019-10-20 19:50:03',NULL),(3133,'Nescafe Classic Jar 200 gm combo',9,'single',19,63,37,NULL,NULL,'exclusive',475,0,1,1,'8941100293652','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-20 19:52:52','2019-10-20 19:52:52',NULL),(3134,'dryper dry pantz l (9-14)',9,'single',19,210,NULL,NULL,NULL,'exclusive',1150,0,1,1,'3134','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 15:18:22','2019-10-21 15:19:05',NULL),(3135,'Cadbury Fabulous Fingers 110gm',9,'single',19,129,15,NULL,NULL,'exclusive',250,0,1,1,'7622210817686','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:22:32','2019-10-21 17:22:32',NULL),(3136,'Chupa Chups Melody Pops 60gm',9,'single',19,148,15,NULL,NULL,'exclusive',400,0,1,1,'8410031934892','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:29:01','2019-10-21 17:29:01',NULL),(3137,'DORITOS Nacho Cheese 300gm',9,'single',19,194,6,NULL,NULL,'exclusive',545,0,1,1,'5000328181844','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:31:44','2019-10-21 17:31:44',NULL),(3138,'GULLON Chocolate Cream Sandwich Cookies 250gm',9,'single',19,353,5,NULL,NULL,'exclusive',380,0,1,1,'8410376048148','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:36:56','2019-10-21 17:36:56',NULL),(3139,'GULLON GF Senza Crackers 200gm',9,'single',19,353,42,NULL,NULL,'exclusive',350,0,1,1,'8410376045017','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:39:09','2019-10-21 17:39:09',NULL),(3140,'GULLON sugar Free Vanilla Fla Wafer 210gm',9,'single',19,353,55,NULL,NULL,'exclusive',400,0,1,1,'8410376039740','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:43:44','2019-10-21 17:43:44',NULL),(3141,'GULLON sugar Free Chocolate Fla Wafer 210gm',9,'single',19,353,55,NULL,NULL,'exclusive',450,0,1,1,'8410376043365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:46:06','2019-10-21 17:46:06',NULL),(3142,'Hellmann\'s Chilli Garlic Sauce 256ml',9,'single',19,354,32,NULL,NULL,'exclusive',435,0,1,1,'8712100891816','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:49:14','2019-10-21 17:49:14',NULL),(3143,'Tuc Cheese Sandwich 150gm',9,'single',19,439,5,NULL,NULL,'exclusive',300,0,1,1,'5000168168302','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:52:32','2019-10-21 17:52:32',NULL),(3144,'Kellogg\'s  Pop Tarts Chocotastic 400gm',9,'single',19,128,15,NULL,NULL,'exclusive',700,0,1,1,'5050083174513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 17:59:20','2019-10-21 17:59:20',NULL),(3145,'Kellogg\'s Pop Tarts Strawberry 400gm',9,'single',19,128,15,NULL,NULL,'exclusive',0,0,1,1,'5050083174469','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 18:05:24','2019-10-21 18:05:24',NULL),(3146,'LAYS 3D MEXICAN STYLE TOMATO 30G',9,'single',19,174,44,NULL,NULL,'exclusive',20,0,1,1,'745114334091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 18:27:42','2019-10-21 18:27:42',NULL),(3147,'LAYS PASTAZZ ITALIAN STYLE HERB & ONION 30GM',9,'single',19,174,44,NULL,NULL,'exclusive',20,0,1,1,'745114334077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 18:29:35','2019-10-21 18:29:35',NULL),(3148,'M&S Digestives Biscuit 400gm',9,'single',19,440,5,NULL,NULL,'exclusive',360,0,1,1,'00741095','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 18:59:18','2020-10-21 13:59:56',NULL),(3149,'M&S 10 All Butter Belgian Chocolate Chunk Cookies 225gm',9,'single',19,440,18,NULL,NULL,'exclusive',480,0,1,1,'00011679','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 19:08:47','2019-10-21 19:08:47',NULL),(3150,'M&S 10 All Triple Belgian Chocolate Chunk Cookies 225gm',9,'single',19,440,18,NULL,NULL,'exclusive',480,0,1,1,'00011747','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 19:11:32','2019-10-21 19:11:32',NULL),(3151,'Nando\'s Mayonnaise Mild 265gm',9,'single',19,356,25,NULL,NULL,'exclusive',550,0,1,1,'6003770009130','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 19:15:57','2019-10-21 19:15:57',NULL),(3152,'OREO Birthday Party  BISCUITS 154GM',9,'single',19,87,5,NULL,NULL,'exclusive',230,0,1,1,'7622210839442','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 19:19:09','2019-10-21 19:19:09',NULL),(3153,'Starbucks Frappuccino Coffee Drinks Vanilla 250ml+',9,'single',19,441,16,NULL,NULL,'exclusive',520,0,1,1,'5760466976282','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 19:26:05','2019-10-21 19:26:05',NULL),(3154,'TESCO Garlic & Herb DRESSING 250 ML',9,'single',19,357,32,NULL,NULL,'exclusive',370,0,1,1,'5051622956027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-21 19:29:00','2019-10-21 19:29:00',NULL),(3155,'cocoalab chocolate 450gm',9,'single',19,200,15,NULL,NULL,'exclusive',920,0,1,1,'cb1801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:35:32','2019-10-22 19:35:32',NULL),(3156,'cocoalab chocolate  157G',9,'single',19,200,15,NULL,NULL,'exclusive',300,0,1,1,'CLMC10','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:39:44','2019-10-22 19:39:44',NULL),(3157,'COCOALAB CHOCOLATE 200G',9,'single',19,200,15,NULL,NULL,'exclusive',430,0,1,1,'CG1815','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:42:00','2019-10-22 19:42:00',NULL),(3158,'COCOALAB CHOCOLATE 158G',9,'single',19,200,15,NULL,NULL,'exclusive',350,0,1,1,'CG1814','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:48:09','2019-10-22 19:48:09',NULL),(3159,'COCOALAB CHOCOLATE 184GM',9,'single',19,200,15,NULL,NULL,'exclusive',410,0,1,1,'CG1816','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:52:16','2019-10-22 19:52:16',NULL),(3160,'COCOALAB CHOCOLATE 45G',9,'single',19,200,15,NULL,NULL,'exclusive',95,0,1,1,'CB1824','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:54:50','2019-10-22 19:54:50',NULL),(3161,'COCOLAB CHOCOLATE 52G',9,'single',19,200,15,NULL,NULL,'exclusive',145,0,1,1,'CG1803','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 19:57:22','2019-10-22 19:57:22',NULL),(3162,'COCOLAB CHOCOLATE 117 G',9,'single',19,200,15,NULL,NULL,'exclusive',280,0,1,1,'CLM006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 20:02:48','2019-10-22 20:02:48',NULL),(3163,'COCOLAB CHOCOLATE 52GM',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',150,0,1,1,'CLJW001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-22 20:27:18','2019-10-22 20:27:18',NULL),(3164,'Lindt Lindor Milk Chocolate Bar 38gm',9,'single',19,214,15,NULL,NULL,'exclusive',165,0,1,1,'4000539363108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-24 15:50:17','2019-10-24 15:50:17',NULL),(3165,'CERELAC MULTIGRAIN 7 GARDEN VEGETABLES 250G',9,'single',19,63,64,NULL,NULL,'exclusive',380,0,1,1,'9556001171443','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-24 17:45:04','2019-10-24 17:45:04',NULL),(3166,'CERELAC RICE & CHICKEN 250G',9,'single',19,63,59,NULL,NULL,'exclusive',380,0,1,1,'9556001129239','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-24 17:46:04','2019-10-24 17:46:04',NULL),(3167,'CERELAC OAT, WHEAT & PRUNES 250G',9,'single',19,63,59,NULL,NULL,'exclusive',380,0,1,1,'9556001172969','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-24 17:47:31','2019-10-24 17:47:31',NULL),(3168,'CERELAC OAT, WHEAT & PRUNES 250G',9,'single',19,63,59,NULL,NULL,'exclusive',380,0,1,1,'9556001172969','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-24 17:47:32','2019-10-24 17:47:32',NULL),(3169,'monin strawberry 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',900,0,1,1,'3052910056261','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-26 17:24:18','2019-10-26 17:24:18',NULL),(3170,'monin wild mint 700ml',9,'single',19,173,36,NULL,NULL,'exclusive',900,0,1,1,'3052910015961','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-26 17:25:43','2019-10-26 17:25:43',NULL),(3171,'kitkat chunky 4bar ma',9,'single',19,63,15,NULL,NULL,'exclusive',260,0,1,1,'7613037051179','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-26 20:19:55','2020-03-12 20:24:00',NULL),(3172,'similac 1 gold 800g',9,'single',19,388,64,NULL,NULL,'exclusive',2200,0,1,1,'5391523057226','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-26 22:23:06','2019-10-26 22:23:06',NULL),(3173,'similac 4 gold 900g',9,'single',19,388,64,NULL,NULL,'exclusive',2300,0,1,1,'5391523052016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-26 22:41:53','2020-01-04 19:43:43',NULL),(3174,'rani float mango 240ml',9,'single',19,243,24,NULL,NULL,'exclusive',75,0,1,1,'6281034903572','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-27 17:06:52','2019-10-27 17:06:52',NULL),(3175,'rani orange drink 240ml',9,'single',19,243,24,NULL,NULL,'exclusive',75,0,1,1,'6281034016029','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-27 17:08:35','2019-10-27 17:08:35',NULL),(3176,'rani strawberry 240ml',9,'single',19,243,24,NULL,NULL,'exclusive',75,0,1,1,'6281034903930','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-27 17:10:22','2019-10-27 17:10:22',NULL),(3177,'rani pineapple 240ml',9,'single',19,243,24,NULL,NULL,'exclusive',75,0,1,1,'6281034900182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-27 17:13:21','2019-10-27 17:13:21',NULL),(3178,'rani peach 240ml drink',9,'single',19,243,24,NULL,NULL,'exclusive',75,0,1,1,'6281034900175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-27 17:15:09','2019-10-27 17:15:09',NULL),(3179,'Haldiram\'s  Elachi Soan Papdi 500g',9,'single',19,119,44,NULL,NULL,'exclusive',230,0,1,1,'8901721500416','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-29 15:11:03','2019-10-29 15:11:03',NULL),(3180,'nuts crisp 500gm',9,'single',19,442,15,NULL,NULL,'exclusive',470,0,1,1,'6930058650343','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-29 15:59:06','2019-10-29 15:59:06',NULL),(3181,'Hibiscus Mushroom (Whole) 2840gm',9,'single',19,92,11,NULL,NULL,'exclusive',580,0,1,1,'6935789557718','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 14:26:34','2020-03-14 19:05:20',NULL),(3182,'Nescafe Gold  100gm',9,'single',19,138,16,NULL,NULL,'exclusive',410,0,1,1,'5601001324109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 14:54:49','2019-10-30 14:54:49',NULL),(3183,'Nescafe Gold 50gm',9,'single',19,138,16,NULL,NULL,'exclusive',280,0,1,1,'46204837','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:16:59','2019-10-30 15:16:59',NULL),(3184,'Davidoff Coffee 100gm',9,'single',19,285,16,NULL,NULL,'exclusive',450,0,1,1,'4006067060977','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:21:17','2019-10-30 15:21:17',NULL),(3185,'Twinings Green Tea Earl Grey 40gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177173296','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:24:47','2019-10-30 15:24:47',NULL),(3186,'Tiffany Deluxe Toffee 325gm',9,'single',19,241,15,NULL,NULL,'exclusive',200,0,1,1,'6291003081224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:31:20','2019-10-30 15:31:20',NULL),(3187,'Tiffany Deluxe Toffee 600gm',9,'single',19,241,15,NULL,NULL,'exclusive',360,0,1,1,'6291003070105','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:32:53','2020-09-20 17:54:35',NULL),(3188,'Tiffany Deluxe Toffee Box 300gm',9,'single',19,241,15,NULL,NULL,'exclusive',250,0,1,1,'6291003080715','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:34:49','2020-07-17 21:20:59',NULL),(3189,'Allah Shafi Honey  1kg',9,'single',19,381,56,NULL,NULL,'exclusive',950,0,1,1,'4891460223711','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:49:37','2019-10-30 15:49:37',NULL),(3190,'ASCEL Pure Butter Ghee 800gm',9,'single',19,256,74,NULL,NULL,'exclusive',950,0,1,1,'6291113102468','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:54:02','2019-10-30 15:54:02',NULL),(3191,'ASCEL Pure Butter Ghee 400gm',9,'single',19,256,74,NULL,NULL,'exclusive',500,0,1,1,'6291113102444','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 15:55:49','2019-10-30 15:55:49',NULL),(3192,'Hershey\'s Cookies \'N\' Creme 160gm',9,'single',19,111,15,NULL,NULL,'exclusive',350,0,1,1,'753854500119','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:12:20','2019-10-30 20:12:20',NULL),(3193,'Haldiram\'s Ghee Soan Papdi 500g',9,'single',19,119,44,NULL,NULL,'exclusive',350,0,1,1,'8901721500409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:17:59','2019-10-30 20:17:59',NULL),(3194,'Parle Hide & Seek 120gm',9,'single',19,383,18,NULL,NULL,'exclusive',80,0,1,1,'8901719105913','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:20:43','2020-07-12 14:07:37',NULL),(3195,'TESCO Intense Dark Chocolate Rich 85% Cocoa 100gm',9,'single',19,357,15,NULL,NULL,'exclusive',230,0,1,1,'5057753211721','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:24:53','2019-10-30 20:24:53',NULL),(3196,'TESCO Classic Dark Chocolate Rich 74% Cocoa 100gm',9,'single',19,357,15,NULL,NULL,'exclusive',230,0,1,1,'5057753211707','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:26:55','2020-11-10 17:44:07',NULL),(3197,'Ms Molly\'s Plain Chocolate 100gm',9,'single',19,357,15,NULL,NULL,'exclusive',150,0,1,1,'5057753211844','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:31:51','2020-03-12 20:55:04',NULL),(3198,'Ms Molly\'s White Chocolate 100gm',9,'single',19,357,15,NULL,NULL,'exclusive',150,0,1,1,'5057753211905','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:32:43','2020-03-12 20:54:15',NULL),(3199,'Ms Molly\'s Milk Chocolate 100gm',9,'single',19,357,15,NULL,NULL,'exclusive',150,0,1,1,'5057753211820','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:33:54','2020-03-12 20:54:38',NULL),(3200,'Kinder bueno White 39gm',9,'single',19,69,3,NULL,NULL,'exclusive',90,0,1,1,'8000500282397','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 20:37:01','2019-10-30 20:37:01',NULL),(3201,'Rainbow Nerds 141.7gm',9,'single',19,443,67,NULL,NULL,'exclusive',300,0,1,1,'079200558338','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 21:01:40','2019-10-30 21:01:40',NULL),(3202,'Extra Mega Peppermint 10 Cubes',9,'single',19,444,22,NULL,NULL,'exclusive',130,0,1,1,'4009900531399','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 21:06:05','2019-10-30 21:06:05',NULL),(3203,'Extra Mega Spearmint 10 Cubes',9,'single',19,444,22,NULL,NULL,'exclusive',130,0,1,1,'4009900531429','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 21:07:19','2019-10-30 21:07:19',NULL),(3204,'MC-VITIE\'S Victoria 550GM',9,'single',19,366,18,NULL,NULL,'exclusive',680,0,1,1,'5000168215495','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 21:10:15','2019-10-30 21:10:15',NULL),(3205,'REESES Nutrageous 47gm',9,'single',19,367,3,NULL,NULL,'exclusive',150,0,1,1,'034000109418','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 21:13:41','2019-10-30 21:13:41',NULL),(3206,'A+ Hosan Aloe Vera Original 1.5ltr',9,'single',19,445,24,NULL,NULL,'exclusive',500,0,1,1,'8809059291993','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:06:51','2019-10-30 22:06:51',NULL),(3207,'Capri- Sun Strawberry Drink 200ml',9,'single',19,446,24,NULL,NULL,'exclusive',70,0,1,1,'6291100850341','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:11:24','2019-10-30 22:11:24',NULL),(3208,'Capri- Sun Orange Drink 200ml',9,'single',19,446,24,NULL,NULL,'exclusive',70,0,1,1,'6291100850327','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:12:35','2019-10-30 22:12:35',NULL),(3209,'Capri- Sun Mango Drink 200ml',9,'single',19,446,24,NULL,NULL,'exclusive',70,0,1,1,'6291100850334','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:13:41','2019-10-30 22:13:41',NULL),(3210,'Capri- Sun Orange Juice 330ml',9,'single',19,446,24,NULL,NULL,'exclusive',175,0,1,1,'5449000009173','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:16:22','2019-10-30 22:16:22',NULL),(3211,'Dr.XYLITOL Grape 32gm',9,'single',19,447,22,NULL,NULL,'exclusive',120,0,1,1,'8936036024432','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:18:43','2019-10-30 22:18:43',NULL),(3212,'Dr.XYLITOL lemon Mint 32gm',9,'single',19,447,22,NULL,NULL,'exclusive',120,0,1,1,'8936036024425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:20:05','2019-10-30 22:20:05',NULL),(3213,'Kelloggs Rice Krispies Multigrain 350gm',9,'single',19,128,21,NULL,NULL,'exclusive',480,0,1,1,'5053827209144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:26:40','2019-10-30 22:26:40',NULL),(3214,'Kelloggs Special K Red Berries 360gm',9,'single',19,128,21,NULL,NULL,'exclusive',550,0,1,1,'5053827195331','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:28:53','2019-10-30 22:28:53',NULL),(3215,'Nestle Golden Nuggets 375gm',9,'single',19,63,21,NULL,NULL,'exclusive',550,0,1,1,'5000243729091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:32:48','2019-10-30 22:32:48',NULL),(3216,'Stute Mango Juice 1.5ltr',9,'single',19,155,24,NULL,NULL,'exclusive',450,0,1,1,'4006424906689','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:34:52','2019-10-30 22:34:52',NULL),(3217,'Ocean Spray Cranberry Classic Juice 1ltr',9,'single',19,329,24,NULL,NULL,'exclusive',330,0,1,1,'031200468932','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:36:54','2019-10-30 22:36:54',NULL),(3218,'Darda Super Mix Pop Corn 55gm',9,'single',19,448,58,NULL,NULL,'exclusive',135,0,1,1,'8809027555270','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:40:52','2019-10-30 22:40:52',NULL),(3219,'A+HOSAN Bread Crumbs 200gm',9,'single',19,445,48,NULL,NULL,'exclusive',110,0,1,1,'8809052916039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:43:11','2019-10-30 22:43:11',NULL),(3220,'Orion Custard Soft cake 276gm',9,'single',19,449,73,NULL,NULL,'exclusive',440,0,1,1,'8936036020137','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:46:14','2019-10-30 22:46:14',NULL),(3221,'ORION Choco pie 168gm',9,'single',19,449,73,NULL,NULL,'exclusive',220,0,1,1,'8801117807610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 22:49:27','2019-10-30 22:49:27',NULL),(3222,'Nongshim Soon Viggle Ramyun Soup 112gm',9,'single',19,450,63,NULL,NULL,'exclusive',135,0,1,1,'8801043022705','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 23:48:39','2019-10-30 23:48:39',NULL),(3223,'Kimchi Ramyun Cup soup 75gm',9,'single',19,450,63,NULL,NULL,'exclusive',120,0,1,1,'8801043028158','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 23:50:25','2019-10-30 23:50:25',NULL),(3224,'Shin Cup Noodle soup 68gm',9,'single',19,450,63,NULL,NULL,'exclusive',110,0,1,1,'031146016792','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 23:52:08','2019-10-30 23:52:08',NULL),(3225,'Nongshim Noodle\'s Hot FLA 65gm',9,'single',19,450,27,NULL,NULL,'exclusive',110,0,1,1,'031146272143','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 23:53:33','2019-10-30 23:53:33',NULL),(3226,'Nongshim Noodle\'s Chicken FLA 65gm',9,'single',19,450,27,NULL,NULL,'exclusive',110,0,1,1,'031146272112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 23:54:38','2019-10-30 23:54:38',NULL),(3227,'Shin Cup Noodle soup/Mee 120gm',9,'single',19,450,27,NULL,NULL,'exclusive',135,0,1,1,'031146150601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-30 23:58:25','2019-10-30 23:58:25',NULL),(3228,'nan al 110',9,'single',19,63,59,NULL,NULL,'exclusive',740,0,1,1,'7613034898098','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-31 22:27:36','2019-10-31 22:27:36',NULL),(3229,'nestle coffe mate 450g',9,'single',19,63,16,NULL,NULL,'exclusive',265,0,1,1,'8941100294512','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-10-31 22:33:39','2019-10-31 22:33:39',NULL),(3230,'IKO S/F 9 Grain Oatmeal Crackers 178gm',9,'single',19,286,42,NULL,NULL,'exclusive',290,0,1,1,'9556562002958','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-02 20:11:39','2019-11-02 20:11:39',NULL),(3231,'IKO S/F Original Grain Oatmeal Crackers 178gm',9,'single',19,286,42,NULL,NULL,'exclusive',290,0,1,1,'9556562001975','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-02 20:16:10','2019-11-02 20:16:10',NULL),(3232,'IKO Assorted Oat Calcium Oatmeal Crackers 700 gm Tin',9,'single',19,286,42,NULL,NULL,'exclusive',720,0,1,1,'9556562001272','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-02 20:22:24','2020-11-15 16:59:19',NULL),(3233,'Gatorade Lemon Lime 500ml',9,'single',19,288,24,NULL,NULL,'exclusive',145,0,1,1,'8858998587025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-02 20:56:54','2019-11-02 20:56:54',NULL),(3234,'Mango Tang 1kg',9,'single',19,321,52,NULL,NULL,'exclusive',500,0,1,1,'7622210369901','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 14:13:47','2019-11-03 14:13:47',NULL),(3235,'Orange Tang 1kg',9,'single',19,321,52,NULL,NULL,'exclusive',500,0,1,1,'7622210369864','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 14:15:15','2019-11-03 14:15:15',NULL),(3236,'Kraft Processed Cheddar Cheese 190gm',9,'single',19,253,13,NULL,NULL,'exclusive',250,0,1,1,'7622210852403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 14:27:38','2019-11-03 14:27:38',NULL),(3237,'Nutella 630gm',9,'single',19,132,41,NULL,NULL,'exclusive',750,0,1,1,'59032823','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 14:33:19','2019-11-03 14:33:19',NULL),(3238,'Riocoffee Garlic Biscuit 250gm',9,'single',19,451,5,NULL,NULL,'exclusive',80,0,1,1,'5124896347584','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:02:24','2019-12-05 02:36:13',NULL),(3239,'Riocoffee Butter Toast 250gm',9,'single',19,451,78,NULL,NULL,'exclusive',80,0,1,1,'20122013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:09:54','2019-11-03 15:09:54',NULL),(3240,'Riocoffee Garlic Toast 250gm',9,'single',19,451,78,NULL,NULL,'exclusive',80,0,1,1,'20122014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:14:07','2019-11-03 15:14:07',NULL),(3241,'Riocoffee Dry Cake 300gm',9,'single',19,451,73,NULL,NULL,'exclusive',200,0,1,1,'2548998612549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:16:13','2019-11-03 15:16:13',NULL),(3242,'Riocoffee Sugar Free Toast 200gm',9,'single',19,451,78,NULL,NULL,'exclusive',75,0,1,1,'20122015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:19:14','2019-11-03 15:19:14',NULL),(3243,'Riocoffee Chocolate Dry Cake 300gm',9,'single',19,451,73,NULL,NULL,'exclusive',200,0,1,1,'2548998998469','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:22:15','2019-11-03 15:22:15',NULL),(3244,'Well Food Butter  Cookies 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',190,0,1,1,'65089149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:23:45','2019-11-03 15:23:45',NULL),(3245,'Riocoffee Sugar Free Biscuit 300gm',9,'single',19,451,5,NULL,NULL,'exclusive',190,0,1,1,'2544574998465','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:26:38','2019-11-03 15:26:38',NULL),(3246,'Riocoffee Butter Salt Cookies 300gm',9,'single',19,451,18,NULL,NULL,'exclusive',190,0,1,1,'2548998636521','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:29:18','2019-11-03 15:29:18',NULL),(3247,'Riocoffee Butter Cookies 300gm',9,'single',19,451,18,NULL,NULL,'exclusive',190,0,1,1,'2548998611146','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:30:24','2019-11-03 15:30:24',NULL),(3248,'Well Food Coconut Cookies 300gm',9,'single',19,348,18,NULL,NULL,'exclusive',190,0,1,1,'65089125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:31:50','2019-11-03 15:31:50',NULL),(3249,'WELL FOOD Garlic Toast 200gm',9,'single',19,348,78,NULL,NULL,'exclusive',75,0,1,1,'312456789850','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 15:37:25','2019-11-03 15:40:30',NULL),(3250,'Coca Cola Light SD 320ml',9,'single',19,6,4,NULL,NULL,'exclusive',70,0,1,1,'0183365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:13:56','2019-11-03 21:13:56',NULL),(3251,'Slim Noodles 35Cal. 200gm (Sd)',9,'single',19,391,27,NULL,NULL,'exclusive',150,0,1,1,'0183368','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:17:03','2019-11-03 21:17:03',NULL),(3252,'Slim Noodles 9Cal. 270gm (Sd)',9,'single',19,391,27,NULL,NULL,'exclusive',150,0,1,1,'0183310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:21:03','2019-11-03 21:21:03',NULL),(3253,'Green Peas Mili (Sd)',9,'single',19,311,11,NULL,NULL,'exclusive',40,0,1,1,'0183336','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:24:41','2019-11-03 21:24:41',NULL),(3254,'Coca Zero SD 320ml',9,'single',19,6,4,NULL,NULL,'exclusive',70,0,1,1,'018936','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:29:03','2020-01-04 19:53:12',NULL),(3255,'Del monte Yellow Peach Halves 825gm (Sd)',9,'single',19,8,43,NULL,NULL,'exclusive',180,0,1,1,'01745685','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:37:15','2019-11-03 21:37:15',NULL),(3256,'TWIN VALLEY Coconut Milk 400ml (Sd)',9,'single',19,396,26,NULL,NULL,'exclusive',75,0,1,1,'01745695','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 21:44:42','2019-11-03 21:44:42',NULL),(3257,'Riona Mushrooms Pice & Stems 400gm (Sd)',9,'single',19,206,11,NULL,NULL,'exclusive',45,0,1,1,'98765','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:00:28','2019-11-03 22:00:28',NULL),(3258,'Quaker White Oats 500gm  SD',9,'single',19,99,28,NULL,NULL,'exclusive',135,0,1,1,'456321','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:19:04','2019-11-03 22:19:04',NULL),(3259,'Coca cola Classic 320ml',9,'single',19,6,4,NULL,NULL,'exclusive',70,0,1,1,'951357','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:29:12','2019-11-03 22:29:12',NULL),(3260,'Hosen Straw mushroom 425gm SD',9,'single',19,14,11,NULL,NULL,'exclusive',75,0,1,1,'85296','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:40:35','2020-10-18 21:59:14',NULL),(3261,'7up 320 ml SD',9,'single',19,37,4,NULL,NULL,'exclusive',70,0,1,1,'852100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:44:13','2019-11-23 21:03:20',NULL),(3262,'Evian Water 500ml sd',9,'single',19,10,40,NULL,NULL,'exclusive',60,0,1,1,'8521452','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:50:45','2019-11-03 22:50:45',NULL),(3263,'Virginia Red Kidney Beans 400gm sd',9,'single',19,204,11,NULL,NULL,'exclusive',70,0,1,1,'8521457','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 22:54:18','2019-11-03 22:54:18',NULL),(3264,'Hosen Logan in Syrup (SD) 234gm',9,'single',19,14,43,NULL,NULL,'exclusive',90,0,1,1,'86245','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 23:03:52','2019-11-03 23:03:52',NULL),(3265,'Virginia G G  Lychee 565gm SD',9,'single',19,204,43,NULL,NULL,'exclusive',100,0,1,1,'158264','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-03 23:43:26','2019-11-03 23:44:41',NULL),(3266,'Sprite 320ml SD',9,'single',19,6,4,NULL,NULL,'exclusive',70,0,1,1,'93825','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-04 00:08:55','2019-11-04 00:08:55',NULL),(3267,'Schweppes Tonic Water 320ml Sd',9,'single',19,29,34,NULL,NULL,'exclusive',70,0,1,1,'1477412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-04 00:25:39','2019-11-04 00:25:39',NULL),(3268,'Virginia Mushroom Choice Whole 400gm SD',9,'single',19,204,11,NULL,NULL,'exclusive',50,0,1,1,'7865124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-04 01:32:48','2019-11-04 01:32:48',NULL),(3269,'Schweppes Soda Water 320ml Sd',9,'single',19,29,34,NULL,NULL,'exclusive',70,0,1,1,'956832','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-04 01:49:08','2019-11-04 01:49:08',NULL),(3270,'Schweppes Ginger Ale 320ml Sd',9,'single',19,29,34,NULL,NULL,'exclusive',70,0,1,1,'956895','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-04 01:52:09','2019-11-04 01:52:09',NULL),(3271,'Ferrero Rocher 62.5 gm',9,'single',19,115,15,NULL,NULL,'exclusive',200,0,1,1,'80135906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-13 18:17:46','2019-11-13 18:17:46',NULL),(3272,'Olitalia Pomace Olive Orange Extract Oil 250 ml',9,'single',19,176,29,NULL,NULL,'exclusive',350,0,1,1,'8007150906000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-13 21:07:00','2019-11-13 21:07:00',NULL),(3273,'Olitalia Fortifited Blended oil 5LTR',9,'single',19,176,29,NULL,NULL,'exclusive',2600,0,1,1,'8007150907373','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-13 21:16:28','2019-11-13 21:16:28',NULL),(3274,'Pasta Zara Vermicelli 500gm',9,'single',19,324,30,NULL,NULL,'exclusive',170,0,1,1,'8004350130051','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-13 21:24:25','2019-11-13 21:24:25',NULL),(3275,'Basso Olive Oil 8.5 FL.Oz',9,'single',19,246,29,NULL,NULL,'exclusive',350,0,1,1,'049248016695','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-13 21:29:38','2019-11-13 21:29:38',NULL),(3276,'Heinz Straw,Banana,Ras,& Apple 100gm',9,'single',19,13,24,NULL,NULL,'exclusive',220,0,1,1,'5000157079947','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 20:12:46','2019-11-14 20:12:46',NULL),(3277,'Heinz Apple,Pear & Banana 100gm',9,'single',19,13,24,NULL,NULL,'exclusive',220,0,1,1,'5000157079961','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 20:14:25','2019-11-14 20:14:25',NULL),(3278,'Heinz  Apple & Mango100gm',9,'single',19,13,24,NULL,NULL,'exclusive',220,0,1,1,'5000157079930','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 20:18:12','2019-11-14 20:18:12',NULL),(3279,'Lolypop Big All 85gm',9,'single',19,434,57,NULL,NULL,'exclusive',180,0,1,1,'6939501808317','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 20:35:05','2019-11-14 20:35:05',NULL),(3280,'Lechao Marshmallow 15gm',9,'single',19,452,15,NULL,NULL,'exclusive',65,0,1,1,'6925448107477','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 20:57:49','2019-11-14 20:57:49',NULL),(3281,'Lechao Love Marshmallow 15gm',9,'single',19,452,15,NULL,NULL,'exclusive',65,0,1,1,'6925448112006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 21:00:07','2019-11-14 21:00:07',NULL),(3282,'Hersheys \'Cookies N Chocolate  24X12.7gm',9,'single',19,111,15,NULL,NULL,'exclusive',1100,0,1,1,'6297000673400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 21:12:36','2019-11-14 21:12:36',NULL),(3283,'Kitkat Mini Moments Desserts 255gm',9,'single',19,63,15,NULL,NULL,'exclusive',1150,0,1,1,'6294003573942','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 21:19:34','2019-11-14 21:19:34',NULL),(3284,'Kitkat Mini Moments  272.5gm',9,'single',19,63,15,NULL,NULL,'exclusive',1150,0,1,1,'6294003574062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 21:21:41','2019-11-14 21:21:41',NULL),(3285,'Kinder Chocolate W Cereals 23.5gm',9,'single',19,69,15,NULL,NULL,'exclusive',65,0,1,1,'80177180','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 21:30:59','2019-11-14 21:30:59',NULL),(3286,'fox\'s GlacierFruits 130gm',9,'single',19,88,15,NULL,NULL,'exclusive',230,0,1,1,'5000314009589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-14 21:35:36','2019-11-14 21:35:36',NULL),(3287,'Kinder Surprise 80gm',9,'single',19,69,15,NULL,NULL,'exclusive',580,0,1,1,'8000500082928','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 15:34:02','2019-11-16 15:34:02',NULL),(3288,'Nestle Quality Street 240gm',9,'single',19,63,15,NULL,NULL,'exclusive',580,0,1,1,'7613036881340','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 15:49:50','2019-11-16 15:49:50',NULL),(3289,'Skittles Crazy Sours 196gm',9,'single',19,126,15,NULL,NULL,'exclusive',380,0,1,1,'4009900525992','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 15:53:30','2019-11-16 15:53:30',NULL),(3290,'Heinz So yummy 7+ Mango & Apricot  biscuit 60gm',9,'single',19,13,5,NULL,NULL,'exclusive',285,0,1,1,'5000157075024','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 16:37:17','2019-11-16 16:37:17',NULL),(3291,'Heinz First Step Baby Rice 4+ (240 gm)',9,'single',19,13,64,NULL,NULL,'exclusive',510,0,1,1,'5000157076960','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 16:43:41','2019-11-16 16:43:41',NULL),(3292,'Cadbury Bourn Vita Biscuits 120gm',9,'single',19,129,5,NULL,NULL,'exclusive',80,0,1,1,'8901233022543','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 18:39:01','2019-11-16 18:39:01',NULL),(3293,'Danish Milk Choc 140gm',9,'single',19,453,15,NULL,NULL,'exclusive',170,0,1,1,'8888047869161','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 18:45:59','2019-11-16 18:45:59',NULL),(3294,'Extra Spearmint 14gm',9,'single',19,130,22,NULL,NULL,'exclusive',20,0,1,1,'50173686','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 19:09:58','2019-11-16 19:09:58',NULL),(3295,'Extra Strawberry  14gm',9,'single',19,130,22,NULL,NULL,'exclusive',20,0,1,1,'42112907','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 19:14:09','2019-11-16 19:14:09',NULL),(3296,'Extra Cool Breeze 14gm',9,'single',19,130,22,NULL,NULL,'exclusive',20,0,1,1,'42070719','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 19:15:56','2019-11-16 19:15:56',NULL),(3297,'Kellogg\'s All Brand 315g sd',9,'single',19,128,1,NULL,NULL,'exclusive',135,0,1,1,'14785236','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:07:25','2019-11-16 21:07:25',NULL),(3298,'Don Simon Pure Squeezed Orange (Sin Pulp) Juice 1lt SD',9,'single',19,9,24,NULL,NULL,'exclusive',225,0,1,1,'14785289','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:10:45','2019-11-16 21:10:45',NULL),(3299,'Don Simon Pure Squeezed Orange (Corn Pulp) Juice 1lt SD',9,'single',19,9,24,NULL,NULL,'exclusive',225,0,1,1,'147852890','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:13:24','2019-11-16 21:13:24',NULL),(3300,'Don Simon Squeezed Lemon Lite Juice Drink 330 ml SD',9,'single',19,9,24,NULL,NULL,'exclusive',60,0,1,1,'147852364','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:15:08','2019-11-16 21:15:08',NULL),(3301,'Don Simon Tropical Juice Drink 330ml Sd',9,'single',19,9,24,NULL,NULL,'exclusive',60,0,1,1,'147852951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:16:44','2019-11-16 21:16:44',NULL),(3302,'Don Simon Tomato Juice 1ltr SD',9,'single',19,9,24,NULL,NULL,'exclusive',195,0,1,1,'147852989','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:19:02','2019-11-16 21:19:02',NULL),(3303,'Vitalia Gluten Free Chili & Onions Crackers 75gm SD',9,'single',19,1,42,NULL,NULL,'exclusive',95,0,1,1,'0001424','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:22:19','2019-11-16 21:22:19',NULL),(3304,'Vitalia Raw Bar Date,Walnut,Strawberry & Quinoa 30 gm SD',9,'single',19,1,3,NULL,NULL,'exclusive',70,0,1,1,'00014369','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:24:12','2019-11-16 21:24:12',NULL),(3305,'Vitalia Raw Bar Fig,Date,Cashew & Amaranth 30 gm SD',9,'single',19,1,3,NULL,NULL,'exclusive',70,0,1,1,'00014784','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:25:45','2019-11-16 21:25:45',NULL),(3306,'Biondi Fettuccine Pasta 500gm SD',9,'single',19,3,30,NULL,NULL,'exclusive',75,0,1,1,'00014365798','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 21:27:40','2019-11-16 21:27:40',NULL),(3307,'Ong\'s Teriaki Sauce 210ml',9,'single',19,2,32,NULL,NULL,'exclusive',250,0,1,1,'8888209180615','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:08:06','2019-11-16 22:08:06',NULL),(3308,'Ong\'s Teriaki Thick Sauce 227gm',9,'single',19,2,32,NULL,NULL,'exclusive',250,0,1,1,'8888209183517','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:09:59','2019-11-16 22:09:59',NULL),(3309,'Ong\'s Dark Soy Sauce 210ml',9,'single',19,2,32,NULL,NULL,'exclusive',200,0,1,1,'8888209182411','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:11:46','2019-11-16 22:11:46',NULL),(3310,'Ong\'s Light Soy Sauce 210ml',9,'single',19,2,32,NULL,NULL,'exclusive',200,0,1,1,'8888209182312','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:13:00','2019-11-16 22:13:00',NULL),(3311,'Ong\'s Plum Sauce 255gm',9,'single',19,2,32,NULL,NULL,'exclusive',250,0,1,1,'8888209181117','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:14:44','2019-11-16 22:14:44',NULL),(3312,'Ong\'s Sweet & Sour Sauce 227gm',9,'single',19,2,32,NULL,NULL,'exclusive',200,0,1,1,'8888209181216','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:17:37','2019-11-16 22:17:37',NULL),(3313,'Ong\'s Garlic Chili Sauce 227gm',9,'single',19,2,32,NULL,NULL,'exclusive',235,0,1,1,'8888209181315','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:19:36','2019-11-16 22:19:36',NULL),(3314,'Ong\'s Hot Chilli Sauce 227gm',9,'single',19,2,32,NULL,NULL,'exclusive',215,0,1,1,'8888209181414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:21:18','2019-11-16 22:21:18',NULL),(3315,'Ong\'s Sweet Thai Chilli Sauce 255gm',9,'single',19,2,32,NULL,NULL,'exclusive',180,0,1,1,'8888209182015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:23:08','2019-11-16 22:23:08',NULL),(3316,'Ong\'s Black Pepper Sauce 227gm',9,'single',19,2,32,NULL,NULL,'exclusive',265,0,1,1,'8888209183210','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:25:49','2019-11-16 22:25:49',NULL),(3317,'Ong\'s Sambal Oelek Sauce 240gm',9,'single',19,2,32,NULL,NULL,'exclusive',250,0,1,1,'8888209182114','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:27:17','2019-11-16 22:27:17',NULL),(3318,'Sesame Oil 640ml',9,'single',19,2,32,NULL,NULL,'exclusive',710,0,1,1,'8888209328895','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-16 22:29:17','2019-11-16 22:29:17',NULL),(3319,'Herman Cake Mix Vanilla 500gm',9,'single',19,378,77,NULL,NULL,'exclusive',270,0,1,1,'6294002406227','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 19:20:01','2019-11-17 19:20:01',NULL),(3320,'Herman Cake Mix Chocolate  500gm',9,'single',19,378,77,NULL,NULL,'exclusive',270,0,1,1,'6294002406197','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 19:21:36','2019-11-17 19:21:36',NULL),(3321,'Lurpak spreadable butter 250g',9,'single',19,212,13,NULL,NULL,'exclusive',330,0,1,1,'5740900804302','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 20:05:36','2019-11-17 20:05:36',NULL),(3322,'Cyprina Orange 250ml',9,'single',19,60,24,NULL,NULL,'exclusive',75,0,1,1,'52920905','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 21:52:36','2019-11-17 21:52:36',NULL),(3323,'Munchy\'s Funmix Tin 700gm',9,'single',19,59,5,NULL,NULL,'exclusive',850,0,1,1,'9556439880856','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 21:56:51','2020-09-05 19:56:31',NULL),(3324,'Munchy\'s Choco Original 235gm',9,'single',19,59,5,NULL,NULL,'exclusive',325,0,1,1,'9556439891906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 22:07:07','2019-11-17 22:07:07',NULL),(3325,'Munchy\'s Dobule Choc  235gm',9,'single',19,59,5,NULL,NULL,'exclusive',325,0,1,1,'9556439891913','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 22:09:33','2019-11-17 22:09:33',NULL),(3326,'Perrier Water 750ml',9,'single',19,25,40,NULL,NULL,'exclusive',250,0,1,1,'3179730010515','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 22:37:41','2019-11-17 22:37:41',NULL),(3327,'Perrier Water 330ml',9,'single',19,25,40,NULL,NULL,'exclusive',150,0,1,1,'3179730010041','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 22:38:49','2019-11-17 22:38:49',NULL),(3328,'Perrier Water lemon 330ml',9,'single',19,25,40,NULL,NULL,'exclusive',160,0,1,1,'3179730010591','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 22:39:58','2019-11-17 22:39:58',NULL),(3329,'Don Simon Mango Juice 1.5ltr',9,'single',19,9,24,NULL,NULL,'exclusive',515,0,1,1,'8410261650074','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 23:08:28','2019-11-17 23:08:28',NULL),(3330,'Don Simon Orange no Sugar Juice Drink 1.5ltr',9,'single',19,9,24,NULL,NULL,'exclusive',515,0,1,1,'8410261650036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 23:10:16','2019-11-17 23:10:16',NULL),(3331,'Don Simon Pomelo Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',350,0,1,1,'8410261606101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 23:16:48','2019-11-17 23:16:48',NULL),(3332,'Don Simon Red Grape  Juice 1ltr',9,'single',19,9,24,NULL,NULL,'exclusive',350,0,1,1,'8410261071114','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-17 23:17:49','2019-11-17 23:17:49',NULL),(3333,'Cowhead  Full Cream Milk Powder 900gm',9,'single',19,84,26,NULL,NULL,'exclusive',1400,0,1,1,'8888440001915','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 00:39:43','2020-09-08 16:18:23',NULL),(3334,'Farmland Tuna Flakes in soya oil 185gm',9,'single',19,454,8,NULL,NULL,'exclusive',100,0,1,1,'8888440000291','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 00:44:38','2019-11-19 00:44:38',NULL),(3335,'Farmland Tuna Onion in soya oil 185gm',9,'single',19,454,8,NULL,NULL,'exclusive',120,0,1,1,'8888440000314','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 00:46:23','2019-11-19 00:46:23',NULL),(3336,'Bega Butter Salted 250gm',9,'single',19,326,6,NULL,NULL,'exclusive',300,0,1,1,'9311000999883','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 01:12:24','2019-11-19 01:12:24',NULL),(3337,'Lowan Whole Food Muesli  Original 750gm',9,'single',19,342,1,NULL,NULL,'exclusive',730,0,1,1,'9310273257652','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 01:26:58','2019-11-19 01:26:58',NULL),(3338,'Superbee Raw Honey 500gm',9,'single',19,144,56,NULL,NULL,'exclusive',850,0,1,1,'9322050003499','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 01:31:34','2019-11-19 01:31:34',NULL),(3339,'Superbee Raw Honey 1kg',9,'single',19,144,56,NULL,NULL,'exclusive',1400,0,1,1,'9322050003604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 01:34:14','2019-11-19 01:34:14',NULL),(3340,'Virginia G G  Whole black Olives 360gm',9,'single',19,204,49,NULL,NULL,'exclusive',170,0,1,1,'6225009753601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 15:06:30','2019-11-19 15:06:30',NULL),(3341,'Lavache Qui rit Cheese  24protin',9,'single',19,455,13,NULL,NULL,'exclusive',450,0,1,1,'3073780574310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 15:54:12','2019-11-19 15:54:12',NULL),(3342,'Gummi Pizza 15gm',9,'single',19,456,22,NULL,NULL,'exclusive',25,0,1,1,'8992741945271','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 15:58:32','2019-11-19 15:58:32',NULL),(3343,'Cadbury Celebrations Box 650gm',9,'single',19,129,15,NULL,NULL,'exclusive',1050,0,1,1,'5000159511735','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 16:11:48','2019-11-19 16:11:48',NULL),(3344,'Horlicks Classic Malt 500gm',9,'single',19,151,60,NULL,NULL,'exclusive',450,0,1,1,'8901571001354','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 16:14:40','2019-11-19 16:14:40',NULL),(3345,'Cadbury  Wispa Biscuit 124gm',9,'single',19,129,5,NULL,NULL,'exclusive',270,0,1,1,'7622210836090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:34:17','2019-11-19 17:34:17',NULL),(3346,'Cadbury  Milk Tray  78gm',9,'single',19,129,15,NULL,NULL,'exclusive',270,0,1,1,'7622210432087','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:37:11','2019-11-19 17:37:11',NULL),(3347,'Shortbread Collection 210gm',9,'single',19,457,46,NULL,NULL,'exclusive',380,0,1,1,'5010909004646','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:41:35','2019-11-19 17:41:35',NULL),(3348,'MC-VITIES Cookies Choc Chip 150gm',9,'single',19,366,18,NULL,NULL,'exclusive',300,0,1,1,'5000168183510','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:44:07','2019-11-19 17:44:07',NULL),(3349,'MC-VITIES Cookies White Choc Chip 150gm',9,'single',19,366,18,NULL,NULL,'exclusive',300,0,1,1,'5000168183718','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:47:22','2019-11-19 17:47:22',NULL),(3350,'Werther\'s Original Butter candy 65gm',9,'single',19,146,7,NULL,NULL,'exclusive',220,0,1,1,'4014400927290','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:50:49','2019-11-19 17:50:49',NULL),(3351,'Werther\'s Original Creamy candy 65gm',9,'single',19,146,7,NULL,NULL,'exclusive',250,0,1,1,'4014400927283','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:52:53','2019-11-19 17:52:53',NULL),(3352,'Fox\'s Melts Viennese Chocolate 180gm',9,'single',19,88,5,NULL,NULL,'exclusive',340,0,1,1,'5010035066525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 17:55:06','2019-11-19 17:55:06',NULL),(3353,'Baby Organic Mini Pasta Shells 250gm',9,'single',19,458,30,NULL,NULL,'exclusive',390,0,1,1,'5045095803698','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:05:23','2020-03-12 21:39:35',NULL),(3354,'Baby Organic Gluten free Mini Star  250gm',9,'single',19,458,30,NULL,NULL,'exclusive',390,0,1,1,'5045095803728','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:07:13','2020-03-12 21:40:00',NULL),(3355,'M&m Double Chocolate Cookies 180gm',9,'single',19,127,18,NULL,NULL,'exclusive',450,0,1,1,'5060402904738','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:09:37','2019-11-19 18:09:37',NULL),(3356,'Crispy Slices Forest Fruit 218gm',9,'single',19,459,5,NULL,NULL,'exclusive',350,0,1,1,'5000168182384','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:12:28','2019-11-19 18:12:28',NULL),(3357,'M&S Chocolate Dutch Shortcake 150gm',9,'single',19,440,73,NULL,NULL,'exclusive',350,0,1,1,'00545426','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:15:46','2019-11-19 18:15:46',NULL),(3358,'M&S Dutch Shortcake 150gm',9,'single',19,440,73,NULL,NULL,'exclusive',350,0,1,1,'00244831','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:18:21','2019-11-19 18:18:21',NULL),(3359,'Tower Gate Jam & Cream Biscuit 150gm',9,'single',19,423,5,NULL,NULL,'exclusive',230,0,1,1,'20423001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:23:36','2019-11-19 18:23:36',NULL),(3360,'Bradburys Pumpkin Seeds 125gm',9,'single',19,460,2,NULL,NULL,'exclusive',350,0,1,1,'10596722','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:26:23','2019-11-19 18:26:23',NULL),(3361,'Bradburys  Sunflower Seeds 250gm',9,'single',19,460,2,NULL,NULL,'exclusive',420,0,1,1,'10596715','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:34:08','2019-11-19 18:36:59',NULL),(3362,'Tesco flax Seed 135gm',9,'single',19,357,2,NULL,NULL,'exclusive',350,0,1,1,'5057967049592','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:38:27','2019-11-19 18:38:27',NULL),(3363,'Tesco Chia  Seed 135gm',9,'single',19,357,2,NULL,NULL,'exclusive',350,0,1,1,'5057967049516','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:41:50','2019-11-19 18:41:50',NULL),(3364,'Golden Sunrise Foods  200gm',9,'single',19,372,2,NULL,NULL,'exclusive',400,0,1,1,'5065000009359','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:46:18','2019-11-19 18:46:18',NULL),(3365,'Bradburys  Chia Seeds 200gm',9,'single',19,460,2,NULL,NULL,'exclusive',420,0,1,1,'10416853','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 18:48:54','2019-11-19 18:48:54',NULL),(3366,'Crownfleld  Milled Linseed 225gm',9,'single',19,461,2,NULL,NULL,'exclusive',450,0,1,1,'20439231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:26:34','2019-11-19 19:26:34',NULL),(3367,'Gullan Sugar Free Choc chip Cookies 150gm',9,'single',19,353,18,NULL,NULL,'exclusive',350,0,1,1,'8410376052893','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:28:36','2019-11-19 19:28:36',NULL),(3368,'M&S Pure Honey Light 340gm',9,'single',19,440,56,NULL,NULL,'exclusive',620,0,1,1,'00819268','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:33:05','2019-11-19 19:33:05',NULL),(3369,'Mars Chocolate Cookies 162gm',9,'single',19,117,18,NULL,NULL,'exclusive',450,0,1,1,'5060402908040','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:34:58','2019-11-19 19:34:58',NULL),(3370,'Tower Gate Digestives Biscuit 400gm',9,'single',19,423,5,NULL,NULL,'exclusive',320,0,1,1,'20891077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:41:10','2019-11-19 19:41:10',NULL),(3371,'Gullon Mega Duo Chocolate Biscuit 500gm',9,'single',19,353,5,NULL,NULL,'exclusive',600,0,1,1,'8410376017113','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:54:12','2019-11-19 19:54:12',NULL),(3372,'Twix Soft Centres Biscuit 144gm',9,'single',19,124,5,NULL,NULL,'exclusive',450,0,1,1,'5060402906459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:57:18','2019-11-19 19:57:18',NULL),(3373,'Bounty Soft Baked Cookies 180gm',9,'single',19,118,18,NULL,NULL,'exclusive',450,0,1,1,'5060402904752','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 19:58:45','2019-11-19 19:58:45',NULL),(3374,'Galaxy white Chocolate Cookies 180gm',9,'single',19,110,18,NULL,NULL,'exclusive',450,0,1,1,'5060402908163','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-19 20:00:39','2019-11-19 20:00:39',NULL),(3375,'Samyang Hot Chicken FLv 700gm',9,'single',19,279,27,NULL,NULL,'exclusive',640,0,1,1,'8801073141896','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:20:42','2020-07-19 16:06:09',NULL),(3376,'NANDO\'S Peri- Peri Table sauce',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000489','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:33:48','2019-11-21 19:33:48',NULL),(3377,'NANDO\'S Peri- Peri Garlic sauce',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:36:33','2019-11-21 19:36:33',NULL),(3378,'NANDO\'S Peri- Peri Wild Herb sauce',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:38:15','2019-11-21 19:38:15',NULL),(3379,'NANDO\'S Peri- Peri Exra Mild sauce',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770002414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:40:15','2019-11-21 19:40:15',NULL),(3380,'NANDO\'S Peri- Peri Extra Hot sauce',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:43:16','2019-11-21 19:43:16',NULL),(3381,'NANDO\'S Peri- Peri Mango & lime sauce 250gm',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770007365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:44:56','2019-11-21 19:44:56',NULL),(3382,'NANDO\'S Peri- Peri Mild sauce 250gm',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770003091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:46:03','2019-11-21 19:46:03',NULL),(3383,'NANDO\'S Peri- Peri Medium sauce 250gm',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000168','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:47:27','2019-11-21 19:47:27',NULL),(3384,'NANDO\'S Peri- Peri Pepper sauce 250gm',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000496','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:50:03','2019-11-21 19:50:03',NULL),(3385,'NANDO\'S Peri- Peri Hot sauce 250gm',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770000663','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:51:27','2020-03-12 21:55:10',NULL),(3386,'NANDO\'S Peri- Peri xx hot sauce 250gm',9,'single',19,356,32,NULL,NULL,'exclusive',450,0,1,1,'6003770002674','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:52:57','2019-11-21 19:52:57',NULL),(3387,'Silver Bird Fruit Mix 200gm',9,'single',19,462,65,NULL,NULL,'exclusive',300,0,1,1,'9556090040026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:56:25','2019-11-21 19:56:25',NULL),(3388,'Silver Bird Chocolate Chips 200gm',9,'single',19,462,15,NULL,NULL,'exclusive',300,0,1,1,'9556090024149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 19:58:52','2020-08-27 23:26:25',NULL),(3389,'IKO S/F Oat Bran Oatmeal Crackers 178gm',9,'single',19,286,42,NULL,NULL,'exclusive',290,0,1,1,'9556562004860','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 20:11:16','2019-11-21 20:11:16',NULL),(3390,'Beef Franks 340gm',9,'single',19,463,71,NULL,NULL,'exclusive',230,0,1,1,'9555474300527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:33:42','2020-03-09 20:05:52',NULL),(3391,'Chicken  Franks 340gm',9,'single',19,463,71,NULL,NULL,'exclusive',180,0,1,1,'9555474302637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:40:57','2020-03-09 20:06:58',NULL),(3392,'Chicken Burger ayam 420gm',9,'single',19,464,71,NULL,NULL,'exclusive',230,0,1,1,'9556210050010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:43:47','2020-03-09 20:04:28',NULL),(3393,'Beef Burger ayam 420gm',9,'single',19,464,71,NULL,NULL,'exclusive',230,0,1,1,'9556210100036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:47:16','2020-08-25 16:26:20',NULL),(3394,'Ramly  Chicken Nugget 500gm',9,'single',19,464,71,NULL,NULL,'exclusive',330,0,1,1,'9556210350035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:50:02','2020-08-25 16:24:54',NULL),(3395,'Ramly  Chicken Nugget 1kg',9,'single',19,464,71,NULL,NULL,'exclusive',650,0,1,1,'9556210350042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:54:32','2020-08-25 16:23:57',NULL),(3396,'Star Frites 1Kg',9,'single',19,465,71,NULL,NULL,'exclusive',270,0,1,1,'8710679127398','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 21:58:13','2020-03-09 20:08:42',NULL),(3397,'Watties Mixed Vegetable 500gm',9,'single',19,466,71,NULL,NULL,'exclusive',250,0,1,1,'9414323809034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 22:00:53','2020-09-08 21:45:07',NULL),(3398,'Watties Sweet Corn 500gm',9,'single',19,466,71,NULL,NULL,'exclusive',320,0,1,1,'9400547025350','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 22:02:45','2019-11-21 22:02:45',NULL),(3399,'WestGold Butter Unsalted 250gm',9,'single',19,467,6,NULL,NULL,'exclusive',330,0,1,1,'9421016151059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 22:06:01','2020-08-25 16:22:17',NULL),(3400,'WestGold Butter salted 250gm',9,'single',19,467,6,NULL,NULL,'exclusive',330,0,1,1,'9421016151042','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 22:08:11','2020-08-25 16:23:10',NULL),(3401,'Beqa Super Slim 250gm',9,'single',19,468,71,NULL,NULL,'exclusive',300,0,1,1,'9310052751227','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 22:11:57','2019-11-21 22:11:57',NULL),(3402,'Beqa BBQ Slice 250gm',9,'single',19,468,71,NULL,NULL,'exclusive',250,0,1,1,'9310264911945','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-21 22:13:25','2019-11-21 22:13:25',NULL),(3403,'Cadbury Dairy Milk Silk Oreo 130gm',9,'single',19,129,15,NULL,NULL,'exclusive',300,0,1,1,'8901233033549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-11-27 20:26:19','2019-11-27 20:26:19',NULL),(3404,'Crown Real Mayonnaise 237gm',9,'single',19,299,25,NULL,NULL,'exclusive',0,0,1,1,'012656110255','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 16:21:10','2019-12-04 16:21:10',NULL),(3405,'Nutkao Fantasia 600 gm',9,'single',19,305,15,NULL,NULL,'exclusive',0,0,1,1,'8008245002065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 16:30:55','2020-06-19 19:29:40',NULL),(3406,'Fontana 100% Natural Mango Juice 1 Lt',9,'single',19,298,24,NULL,NULL,'exclusive',0,0,1,1,'5290074000777','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 16:33:59','2019-12-04 16:33:59',NULL),(3407,'Bonjour Jam Forest Fruits 450Gm',9,'single',19,470,NULL,NULL,NULL,'exclusive',0,0,1,1,'5202658201906','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 16:43:27','2019-12-04 16:43:27',NULL),(3408,'Bonjour Jam Strawberry  450Gm',9,'single',19,470,23,NULL,NULL,'exclusive',0,0,1,1,'3408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 16:44:34','2019-12-04 16:44:34',NULL),(3409,'Bonjour Jam Orange 450Gm',9,'single',19,470,23,NULL,NULL,'exclusive',0,0,1,1,'5202658201944','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 16:45:30','2019-12-04 16:45:30',NULL),(3410,'Italpasta 500Gm',9,'single',19,469,30,NULL,NULL,'exclusive',0,0,1,1,'8009940000882','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 17:01:06','2019-12-04 17:01:06',NULL),(3411,'Italpasta 500gm',9,'single',19,469,30,NULL,NULL,'exclusive',0,0,1,1,'8009940000578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 17:03:10','2019-12-04 17:03:10',NULL),(3412,'italpasta 500gm',9,'single',19,469,30,NULL,NULL,'exclusive',0,0,1,1,'8009940079994','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 17:04:39','2019-12-04 17:04:39',NULL),(3413,'Italpasta 500gm',9,'single',19,469,30,NULL,NULL,'exclusive',0,0,1,1,'8009940000462','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 17:06:12','2019-12-04 17:06:12',NULL),(3414,'Bonjour Jam Strawberry  450Gm',9,'single',19,470,23,NULL,NULL,'exclusive',0,0,1,1,'5202658201951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 17:12:32','2019-12-04 17:12:32',NULL),(3415,'Kellorggs K Special 535gm',9,'single',19,128,59,NULL,NULL,'exclusive',0,0,1,1,'9310055537408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:37:54','2019-12-04 18:37:54',NULL),(3416,'Nestle Nesquik 650gm',9,'single',19,63,59,NULL,NULL,'exclusive',0,0,1,1,'4800361334341','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:39:51','2019-12-04 18:39:51',NULL),(3417,'Sanit Weet Bix Multigrain 575gm',9,'single',19,416,59,NULL,NULL,'exclusive',0,0,1,1,'9300652014396','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:46:35','2019-12-04 18:46:35',NULL),(3418,'Parise DRS 1000 Island 330ml',9,'single',19,387,32,NULL,NULL,'exclusive',0,0,1,1,'9310047206312','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:49:49','2019-12-04 18:49:49',NULL),(3419,'Twinings Earl Grey 20gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177050603','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:52:51','2019-12-04 18:52:51',NULL),(3420,'Twinings English Breakfast  20gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177050610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:54:00','2019-12-04 18:54:00',NULL),(3421,'Twinings Pure Green Tea 20gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177244286','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:54:48','2019-12-04 18:54:48',NULL),(3422,'Twinings Earl Grey 200gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177025694','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:56:32','2020-09-08 16:40:41',NULL),(3423,'Twinings English Breakfast 200gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177106348','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:57:47','2020-09-08 16:40:08',NULL),(3424,'Twinings english Breakfast 100b 200gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177025700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 18:59:27','2020-09-08 16:40:24',NULL),(3425,'Twinings Green Tea 150gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177261863','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:00:48','2019-12-04 19:00:48',NULL),(3426,'Twinings Irish Breakfast 200gm',9,'single',19,152,37,NULL,NULL,'exclusive',0,0,1,1,'070177043117','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:02:01','2020-09-08 16:39:32',NULL),(3427,'Kirks Soda 375ml',9,'single',19,471,20,NULL,NULL,'exclusive',0,0,1,1,'9300624008231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:06:28','2019-12-04 19:06:28',NULL),(3428,'Kirks Ginger  375ml',9,'single',19,471,20,NULL,NULL,'exclusive',0,0,1,1,'9300624611936','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:08:14','2019-12-04 19:08:14',NULL),(3429,'Kirks Lemon  375ml',9,'single',19,471,20,NULL,NULL,'exclusive',0,0,1,1,'9300624610939','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:08:58','2019-12-04 19:08:58',NULL),(3430,'Kirks Pasito 375ml',9,'single',19,471,20,NULL,NULL,'exclusive',0,0,1,1,'9300624612131','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:09:55','2019-12-04 19:09:55',NULL),(3431,'Coca Cola Classic 375ml',9,'single',19,6,34,NULL,NULL,'exclusive',0,0,1,1,'9300675001410','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:12:04','2019-12-04 19:12:04',NULL),(3432,'Starburst Babies 180gm',9,'single',19,472,22,NULL,NULL,'exclusive',0,0,1,1,'9300613107723','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:17:07','2019-12-04 19:17:07',NULL),(3433,'Starburst Babies 180gm',9,'single',19,472,22,NULL,NULL,'exclusive',0,0,1,1,'9300682034081','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:17:54','2019-12-04 19:17:54',NULL),(3434,'Starburst Babies 180gm',9,'single',19,472,22,NULL,NULL,'exclusive',0,0,1,1,'9300682017428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:18:55','2019-12-04 19:18:55',NULL),(3435,'Starburst Babies 180gm',9,'single',19,472,22,NULL,NULL,'exclusive',0,0,1,1,'9300682017466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:19:29','2019-12-04 19:19:29',NULL),(3436,'Goldn canola Oil 4ltr',9,'single',19,473,29,NULL,NULL,'exclusive',0,0,1,1,'9310047140845','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 19:35:07','2019-12-04 19:35:07',NULL),(3437,'Life Chill Sauce 340gm',9,'single',19,406,32,NULL,NULL,'exclusive',0,0,1,1,'9556086011900','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 20:28:29','2019-12-04 20:28:29',NULL),(3438,'Kelloggs Real Honey 300gm',9,'single',19,128,59,NULL,NULL,'exclusive',0,0,1,1,'8901499008312','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 20:58:49','2019-12-04 20:58:49',NULL),(3439,'Kelloggs Chocos 700gm',9,'single',19,128,59,NULL,NULL,'exclusive',0,0,1,1,'8901499007971','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 21:03:04','2020-03-09 19:49:28',NULL),(3440,'Pringles Sweet Chili 147gm',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'8886467114793','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 21:12:24','2020-03-09 19:38:21',NULL),(3441,'Pringles Tom Yum  147gm',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'8886467114786','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 21:13:17','2020-03-09 19:42:43',NULL),(3442,'Pringles BBQ 147gm',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'8886467100109','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 21:14:04','2019-12-04 21:14:04',NULL),(3443,'Kelloggs Oats 1kg',9,'single',19,128,NULL,NULL,NULL,'exclusive',0,0,1,1,'8901499007728','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 21:16:45','2020-03-09 19:51:17',NULL),(3444,'Nescafe Classic 200gm',9,'single',19,63,16,NULL,NULL,'exclusive',0,0,1,1,'8941100294918','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 22:03:09','2019-12-04 22:03:09',NULL),(3445,'Lavache Qui rit Cheese  24protin',9,'single',19,344,13,NULL,NULL,'exclusive',0,0,1,1,'3073786155186','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 22:39:35','2020-03-12 20:06:09',NULL),(3446,'Lavache Qui rit Cheese  32protin',9,'single',19,455,13,NULL,NULL,'exclusive',0,0,1,1,'3073780593083','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 22:40:58','2019-12-04 22:40:58',NULL),(3447,'Tesco Sesame Seeds 300gm',9,'single',19,357,2,NULL,NULL,'exclusive',0,0,1,1,'5051140110505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 22:49:20','2019-12-04 22:49:20',NULL),(3448,'Alesto Seed Mix 200gm',9,'single',19,357,2,NULL,NULL,'exclusive',0,0,1,1,'20636432','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 22:54:58','2019-12-04 22:54:58',NULL),(3449,'Nongshin Shin rantun 600gm',9,'single',19,450,27,NULL,NULL,'exclusive',0,0,1,1,'031146157365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 23:50:03','2019-12-04 23:50:03',NULL),(3450,'Nongshim kimchi Ramyum 600gm',9,'single',19,450,27,NULL,NULL,'exclusive',0,0,1,1,'031146031566','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-04 23:54:09','2019-12-04 23:54:09',NULL),(3451,'red White Macaroni Cheese 206gm',9,'single',19,474,27,NULL,NULL,'exclusive',0,0,1,1,'3451','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:04:22','2019-12-05 00:04:22',NULL),(3452,'Oliya Sunflower Oil 5 ltr',9,'single',19,475,29,NULL,NULL,'exclusive',0,0,1,1,'8690983042597','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:05:37','2019-12-05 00:05:37',NULL),(3453,'Ocean Spray Cranberry Orginal Juice 1.89ltrtr',9,'single',19,329,24,NULL,NULL,'exclusive',0,0,1,1,'031200200075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:08:03','2019-12-05 00:08:03',NULL),(3454,'Dairy Milk Silk Roast Almond 137gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'8901233031507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:21:31','2019-12-05 00:21:31',NULL),(3455,'Orbit Gun 404gm',9,'single',19,476,22,NULL,NULL,'exclusive',0,0,1,1,'89007587','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:36:31','2020-03-17 23:12:16',NULL),(3456,'Orbit Gun 404gm',9,'single',19,476,22,NULL,NULL,'exclusive',0,0,1,1,'89007617','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:37:05','2019-12-05 00:37:05',NULL),(3457,'Orbit Gun 404gm',9,'single',19,476,22,NULL,NULL,'exclusive',0,0,1,1,'89007570','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:37:35','2019-12-05 00:37:35',NULL),(3458,'Smarties Gum 152gm',9,'single',19,63,22,NULL,NULL,'exclusive',0,0,1,1,'7613033538452','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:39:41','2020-03-12 20:40:07',NULL),(3459,'Cadbury Dairy Milk Chocolate 90 gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'7622210335647','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:42:12','2019-12-05 00:42:12',NULL),(3460,'Fancy Umbrella 32gm',9,'single',19,266,15,NULL,NULL,'exclusive',0,0,1,1,'8858870101219','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:43:38','2019-12-05 00:43:38',NULL),(3461,'Extra Gun 56gm',9,'single',19,478,22,NULL,NULL,'exclusive',0,0,1,1,'3461','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:44:45','2019-12-05 00:44:45',NULL),(3462,'Extra Gun 56gm',9,'single',19,478,22,NULL,NULL,'exclusive',0,0,1,1,'9555192504344','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:45:13','2019-12-05 00:45:13',NULL),(3463,'Extra Gun 56gm',9,'single',19,478,22,NULL,NULL,'exclusive',0,0,1,1,'9555192501909','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:45:47','2019-12-05 00:45:47',NULL),(3464,'Extra Peppermint 14gm',9,'single',19,478,22,NULL,NULL,'exclusive',0,0,1,1,'40099361','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 00:47:27','2019-12-05 00:47:27',NULL),(3465,'Well Food Special Chanachur 400gm',9,'single',19,348,79,NULL,NULL,'exclusive',0,0,1,1,'167806263289','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 01:55:00','2019-12-05 01:55:00',NULL),(3466,'Well Food  Chanachur 400gm',9,'single',19,348,79,NULL,NULL,'exclusive',0,0,1,1,'65089361','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 01:56:21','2019-12-05 01:56:21',NULL),(3467,'Riocoffee Butter Tost Biscuit 200gm',9,'single',19,348,5,NULL,NULL,'exclusive',0,0,1,1,'5124896347585','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:03:57','2019-12-05 02:03:57',NULL),(3468,'Well Food Dry Cake Horlicks 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',0,0,1,1,'65089255','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:14:39','2019-12-05 02:14:39',NULL),(3469,'Well Food Ovaltine 3600gm',9,'single',19,348,5,NULL,NULL,'exclusive',0,0,1,1,'65089286','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:16:19','2019-12-05 02:16:19',NULL),(3470,'Riocoffee Ovaltin Biscuit 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',0,0,1,1,'2548998611252','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:19:41','2019-12-05 02:19:41',NULL),(3471,'Riocoffee Chocolate Chips Biscuit 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',0,0,1,1,'2544574933473','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:21:18','2019-12-05 02:21:18',NULL),(3472,'Riocoffee  Horli+ Biscuit 300gm',9,'single',19,348,5,NULL,NULL,'exclusive',0,0,1,4,'2548998657526','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:31:50','2019-12-05 02:31:50',NULL),(3473,'Cadbury Choc Chip Cookies 135gm',9,'single',19,129,5,NULL,NULL,'exclusive',0,0,1,1,'7622210809049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:47:19','2019-12-05 02:47:19',NULL),(3474,'M&S Chocolate Chip Cookies 400gm',9,'single',19,440,5,NULL,NULL,'exclusive',0,0,1,1,'00469265','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:48:59','2019-12-05 02:48:59',NULL),(3475,'Hershey ICE Brakers Gum 42gm',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'03400704','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:53:51','2020-07-12 13:41:54',NULL),(3476,'Hershey ICE Brakers Gum 42gm',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'03466506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:55:01','2019-12-05 02:55:01',NULL),(3477,'Hershey ICE Brakers Gum 42gm',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'034000722297','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:55:35','2019-12-05 02:55:35',NULL),(3478,'Hershey ICE Brakers Gum 42gm',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'03400607','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:57:47','2019-12-05 02:57:47',NULL),(3479,'Hershey ICE Brakers Gum 42gm',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'034000722310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:58:21','2019-12-05 02:58:21',NULL),(3480,'Wrigles Extra Gum 15 sticks',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'02289106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 02:59:47','2019-12-05 02:59:47',NULL),(3481,'Wrigles Extra Gum 15 sticks',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'02284004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 03:00:19','2019-12-05 03:00:19',NULL),(3482,'Wrigles Extra Gum 15 sticks',9,'single',19,111,22,NULL,NULL,'exclusive',0,0,1,1,'02289805','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 03:01:01','2019-12-05 03:01:01',NULL),(3483,'Hershey galaxy Biscuit 180gm',9,'single',19,111,5,NULL,NULL,'exclusive',0,0,1,1,'5060402904776','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 03:04:16','2019-12-05 03:04:16',NULL),(3484,'Guylian NSA Milk 100gm',9,'single',19,102,15,NULL,NULL,'exclusive',0,0,1,1,'5410976811015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:19:42','2019-12-05 15:19:42',NULL),(3485,'Nutella Go 52gm',9,'single',19,132,NULL,NULL,NULL,'exclusive',0,0,1,1,'009800800056','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:27:33','2019-12-05 15:27:33',NULL),(3486,'Ice Cream Lollipop 20gm',9,'single',19,85,15,NULL,NULL,'exclusive',0,0,1,1,'6936756212678','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:32:18','2019-12-05 15:32:18',NULL),(3487,'Round Lollpop 30gm',9,'single',19,85,15,NULL,NULL,'exclusive',0,0,1,1,'6933227301121','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:34:00','2019-12-05 15:34:00',NULL),(3488,'Trident Watermelon Gum 18',9,'single',19,109,22,NULL,NULL,'exclusive',0,0,1,1,'012546011136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:37:40','2019-12-05 15:37:40',NULL),(3489,'Trident Tropical Gum18',9,'single',19,109,22,NULL,NULL,'exclusive',0,0,1,1,'012546011112','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:38:38','2019-12-05 15:38:38',NULL),(3490,'Super Mni Mixed 500gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'5000159301022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:40:33','2019-12-05 15:40:33',NULL),(3491,'M&M Peanut 180gm',9,'single',19,127,15,NULL,NULL,'exclusive',0,0,1,1,'040000488088','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:45:07','2019-12-05 15:45:07',NULL),(3492,'M&M Chocolate 180gm',9,'single',19,127,15,NULL,NULL,'exclusive',0,0,1,1,'040000488064','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:48:18','2019-12-05 15:48:18',NULL),(3493,'KItkat Orange 20.7gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'50426362','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:57:42','2019-12-05 15:57:42',NULL),(3494,'Kitkat Chunky 40gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'3800020456293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 15:59:06','2019-12-05 15:59:06',NULL),(3495,'Pringles BBQ 40gm',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'038000183737','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:19:07','2020-08-29 20:03:31',NULL),(3496,'Pringles Cheese 40gm',9,'single',19,101,14,NULL,NULL,'exclusive',0,0,1,1,'038000845536','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:19:58','2019-12-05 17:19:58',NULL),(3497,'Starjus Juice 2ltr',9,'single',19,98,24,NULL,NULL,'exclusive',0,0,1,1,'9555038403381','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:24:40','2019-12-05 17:24:40',NULL),(3498,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455008208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:29:20','2019-12-05 17:29:20',NULL),(3499,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455000738','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:30:00','2019-12-05 17:30:00',NULL),(3500,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455006006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:30:53','2019-12-05 17:30:53',NULL),(3501,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455000707','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:32:31','2019-12-05 17:32:31',NULL),(3502,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455001209','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:33:16','2019-12-05 17:33:16',NULL),(3503,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455001698','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:34:10','2019-12-05 17:34:10',NULL),(3504,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455008505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:34:45','2019-12-05 17:34:45',NULL),(3505,'Paone Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455003401','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 17:35:19','2019-12-05 17:35:19',NULL),(3506,'Santa Isabel Green Cocktail 750ml',9,'single',19,480,12,NULL,NULL,'exclusive',0,0,1,1,'8431101994943','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 19:26:40','2019-12-05 19:26:40',NULL),(3507,'Santa Isabel Pink Cocktail 750ml',9,'single',19,480,12,NULL,NULL,'exclusive',0,0,1,1,'8431101994950','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 19:27:31','2019-12-05 19:27:31',NULL),(3508,'Santa Isabel Blue Cocktail 750ml',9,'single',19,480,12,NULL,NULL,'exclusive',0,0,1,1,'8431101996299','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 19:28:11','2019-12-05 19:28:11',NULL),(3509,'Santa Isabel Red Grape 750ml',9,'single',19,480,12,NULL,NULL,'exclusive',0,0,1,1,'8431101996282','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 19:29:03','2019-12-05 19:29:03',NULL),(3510,'Santa Isabel White Grape 750ml',9,'single',19,480,12,NULL,NULL,'exclusive',0,0,1,1,'8431101996275','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-05 19:29:59','2019-12-05 19:29:59',NULL),(3511,'Stute Aoricot Jam 430gm',9,'single',19,155,23,NULL,NULL,'exclusive',0,0,1,1,'4006424022389','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:01:34','2019-12-10 16:01:34',NULL),(3512,'Tong Garden Freshly Roasted 1kg',9,'single',19,177,9,NULL,NULL,'exclusive',0,0,1,1,'013256210000','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:04:07','2020-01-04 19:25:31',NULL),(3513,'Don Simon Iced Tea Peach  330ml',9,'single',19,9,24,NULL,NULL,'exclusive',0,0,1,1,'8410261721002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:12:35','2019-12-10 16:12:35',NULL),(3514,'Don Simon Iced Tea Lemon 330m',9,'single',19,9,24,NULL,NULL,'exclusive',0,0,1,1,'8410261720005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:13:41','2019-12-10 16:13:41',NULL),(3515,'Sundrop Peanut Butter 200gm',9,'single',19,481,6,NULL,NULL,'exclusive',0,0,1,1,'8901512141804','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:30:47','2019-12-10 16:30:47',NULL),(3516,'Sundrop Peanut Butter 508gm',9,'single',19,481,6,NULL,NULL,'exclusive',0,0,1,1,'8901512881106','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:31:40','2019-12-10 16:31:40',NULL),(3517,'Sundrop Peanut Butter With Jelly 340gm',9,'single',19,481,6,NULL,NULL,'exclusive',0,0,1,1,'8901512146809','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:32:57','2019-12-10 16:32:57',NULL),(3518,'Sundrop Peanut Butter With Choco 340gm',9,'single',19,481,6,NULL,NULL,'exclusive',0,0,1,1,'8901512916204','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:34:00','2019-12-10 16:34:00',NULL),(3519,'Sundrop Cocoa Nut 350gm',9,'single',19,481,15,NULL,NULL,'exclusive',0,0,1,1,'8901512916600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 16:35:24','2019-12-10 16:35:24',NULL),(3520,'Aksu joy Assorted Chocolate 300gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'8697413808372','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 17:12:46','2019-12-10 17:12:46',NULL),(3521,'Aksu Armin Assorted Chocolate 300gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'8697413805760','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 17:14:14','2019-12-10 17:14:14',NULL),(3522,'Aksu Vavien Assorted Chocolate 250gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'8697413801991','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 17:26:23','2019-12-10 17:33:39',NULL),(3523,'Aksu Carmelo Assorted Chocolate 200gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'8697413805036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 17:28:28','2020-09-07 23:43:10',NULL),(3524,'Aksu Nostalji Assorted Chocolate 300gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'8697413805241','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 17:30:29','2020-02-04 14:17:28',NULL),(3525,'Aksu Vavien Assorted Chocolate 250gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'86974138052412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 18:06:11','2019-12-10 18:06:11',NULL),(3526,'Aksu Nostalji Assorted Chocolate 250gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'86974138052413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 18:07:55','2019-12-10 18:07:55',NULL),(3527,'Aksu Armin Assorted Chocolate 250gm',9,'single',19,431,15,NULL,NULL,'exclusive',0,0,1,1,'86974138057604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 18:10:04','2019-12-10 18:10:04',NULL),(3528,'Joly Adultes Diapers 30pc',9,'single',19,203,68,NULL,NULL,'exclusive',0,0,1,1,'8690536804030','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 18:21:14','2019-12-10 18:21:14',NULL),(3529,'Ramen Hot Stir Fried Noodle Chicken Flavour 140gm',9,'single',19,279,27,NULL,NULL,'exclusive',0,0,1,1,'8801073110502','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 18:48:19','2020-07-18 16:29:49',NULL),(3530,'Coca Cola Classic SD 320ml',9,'single',19,6,34,NULL,NULL,'exclusive',0,0,1,1,'88880020760091','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 19:30:01','2020-02-18 18:20:04',NULL),(3531,'Hosen Cream Styled Corn SD 425gm',9,'single',19,14,11,NULL,NULL,'exclusive',0,0,1,1,'88881928151121','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 19:53:04','2019-12-10 19:53:04',NULL),(3532,'Hosen Mushroom  (SD) 2840gm',9,'single',19,14,11,NULL,NULL,'exclusive',0,0,1,1,'88881328211201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-10 20:00:42','2019-12-10 20:00:42',NULL),(3533,'Nescafe Gold 100gm',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'46204813','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 20:10:51','2019-12-11 20:10:51',NULL),(3534,'Complan Chocolate Jar 500gm',9,'single',19,186,59,NULL,NULL,'exclusive',0,0,1,1,'8901542001932','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 20:51:05','2019-12-11 20:53:12',NULL),(3535,'Complan Chocolate Jar 200gm',9,'single',19,186,59,NULL,NULL,'exclusive',0,0,1,1,'8901542000027','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 20:52:24','2019-12-11 20:52:24',NULL),(3536,'Complan Classic 350gm',9,'single',19,186,59,NULL,NULL,'exclusive',0,0,1,1,'8901542000478','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 20:56:20','2020-03-09 17:24:46',NULL),(3537,'Cadbury Bourn Vita Biscuits 46.5gm',9,'single',19,129,5,NULL,NULL,'exclusive',0,0,1,1,'8901233022536','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 21:20:03','2019-12-11 21:20:03',NULL),(3538,'Florex English Garden 2 ltr',9,'single',19,482,48,NULL,NULL,'exclusive',0,0,1,1,'8888267231014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 21:35:55','2019-12-11 21:35:55',NULL),(3539,'Florex Lavender 2 ltr',9,'single',19,482,48,NULL,NULL,'exclusive',0,0,1,1,'8888267231090','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-11 21:42:56','2019-12-11 21:42:56',NULL),(3540,'Virginia G G Australian Pure Honey 1kg',9,'single',19,204,56,NULL,NULL,'exclusive',0,0,1,1,'8901062675019','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 15:51:10','2019-12-12 15:51:10',NULL),(3541,'Vitalia Granola Muesli with Nuts 350gm',9,'single',19,1,1,NULL,NULL,'exclusive',0,0,1,1,'5310099010282','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 15:55:32','2019-12-12 15:55:32',NULL),(3542,'Indian Peanut 500gm',9,'single',19,273,53,NULL,NULL,'exclusive',0,0,1,1,'130002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 19:04:46','2019-12-12 19:04:46',NULL),(3543,'Indian Peanut300gm',9,'single',19,273,53,NULL,NULL,'exclusive',0,0,1,1,'130003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 19:05:36','2019-12-12 19:05:36',NULL),(3544,'Indian Peanut 150gm',9,'single',19,273,53,NULL,NULL,'exclusive',0,0,1,1,'130004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 19:06:22','2019-12-12 19:06:22',NULL),(3545,'Indian Open Peanut  500gm',9,'single',19,273,53,NULL,NULL,'exclusive',0,0,1,1,'130005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 19:07:10','2019-12-12 19:07:10',NULL),(3546,'Indian Open Peanut  300gm',9,'single',19,273,53,NULL,NULL,'exclusive',0,0,1,1,'130006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 19:08:02','2019-12-12 19:08:02',NULL),(3547,'Indian Open Peanut  150gm',9,'single',19,273,53,NULL,NULL,'exclusive',0,0,1,1,'130007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 19:08:53','2019-12-12 19:08:53',NULL),(3548,'Vitalia 4 Ground seed 170g',9,'single',19,1,2,NULL,NULL,'exclusive',0,0,1,1,'5310099005882','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 20:21:55','2019-12-12 20:21:55',NULL),(3550,'I love Fruits Candy 200gm',9,'single',19,411,7,NULL,NULL,'exclusive',0,0,1,1,'86999057206501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-12 23:12:37','2019-12-12 23:12:37',NULL),(3551,'Ensure  vanilla flavor box 1kg',9,'single',19,185,26,NULL,NULL,'exclusive',0,0,1,1,'8904145912063','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-18 16:12:45','2019-12-18 16:17:02',NULL),(3552,'Sir Glass Cleaner 500ml',9,'single',19,483,85,NULL,NULL,'exclusive',0,0,1,1,'8693023052907','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-18 17:09:58','2019-12-18 17:09:58',NULL),(3553,'Doritos Sweet Chilli flavour 75 g',9,'single',19,194,14,NULL,NULL,'exclusive',0,0,1,1,'8901491000178','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-18 17:24:11','2019-12-18 17:24:11',NULL),(3554,'Doritos nacho cheese flavour 75 g',9,'single',19,194,14,NULL,NULL,'exclusive',0,0,1,1,'8901491000154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-18 17:29:58','2019-12-18 17:29:58',NULL),(3555,'Doritos nacho cheese flavour 44 g',9,'single',19,194,14,NULL,NULL,'exclusive',0,0,1,1,'8901491000192','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-18 17:31:22','2019-12-18 17:31:22',NULL),(3556,'Doritos Sweet Chilli flavour 44gm',9,'single',19,194,14,NULL,NULL,'exclusive',0,0,1,1,'8901491000208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-18 17:32:40','2019-12-18 17:32:40',NULL),(3557,'maggi masala nodles 992gm',9,'single',19,63,27,NULL,NULL,'exclusive',245,0,1,1,'8941100294895','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 16:42:15','2019-12-26 16:42:15',NULL),(3558,'nido 1+   350gm',9,'single',19,63,64,NULL,NULL,'exclusive',355,0,1,1,'8941100294727','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 16:46:10','2019-12-26 16:46:10',NULL),(3559,'Olife Sunflower Oil 5ltr',9,'single',19,31,29,NULL,NULL,'exclusive',0,0,1,1,'9555490310432','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 17:42:05','2019-12-26 17:42:05',NULL),(3560,'Olife Sunflower Oil 2ltr',9,'single',19,31,29,NULL,NULL,'exclusive',0,0,1,1,'9555490310425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 17:43:39','2019-12-26 17:43:39',NULL),(3561,'beef momo 300gm',9,'single',19,484,71,NULL,NULL,'exclusive',310,0,1,1,'8908011441442','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 20:04:14','2019-12-26 20:04:14',NULL),(3562,'BEEF MOMO 600GM',9,'single',19,484,71,NULL,NULL,'exclusive',620,0,1,1,'8908011441459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 20:06:11','2019-12-26 20:06:11',NULL),(3563,'CHICKEN MOMO 300GM',9,'single',19,484,71,NULL,NULL,'exclusive',270,0,1,1,'8908011441466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 20:08:17','2019-12-26 20:08:17',NULL),(3564,'CHIKEN MOMO 600GM',9,'single',19,484,71,NULL,NULL,'exclusive',515,0,1,1,'8908011441473','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-26 20:10:06','2019-12-26 20:10:06',NULL),(3565,'NIDO 1+ 400GM IMP',9,'single',19,63,64,NULL,NULL,'exclusive',860,0,1,1,'6294003575236','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-27 01:18:33','2020-03-07 20:38:07',NULL),(3566,'MACCAIN FRENCHFRIES 2.5 KG',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',250,0,1,1,'8906000610107','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-27 01:36:38','2019-12-27 01:36:38',NULL),(3567,'AMERICAN GARDEN LITE MAYONISE 473 ML',9,'single',19,150,NULL,NULL,NULL,'exclusive',280,0,1,1,'017273504630','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-27 01:39:18','2019-12-27 01:39:18',NULL),(3568,'Pure Haven Apple Sparkling Celebration Drink 750ml',9,'single',19,41,24,NULL,NULL,'exclusive',390,0,1,1,'5032619310022','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:16:09','2019-12-28 15:16:09',NULL),(3569,'Stute Thick Cut Orange Jam 430Gm',9,'single',19,155,23,NULL,NULL,'exclusive',320,0,1,1,'4006424022693','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:28:57','2019-12-28 15:28:57',NULL),(3570,'Kellogg`s Corn Flakes  500gm',9,'single',19,128,21,NULL,NULL,'exclusive',450,0,1,1,'4003994111901','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:35:37','2019-12-28 15:35:37',NULL),(3571,'Kellogg\'s Frosties  500gm',9,'single',19,128,21,NULL,NULL,'exclusive',530,0,1,1,'4003994124154','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:39:09','2019-12-28 15:39:09',NULL),(3572,'Kellogg\'s  Special K Classic 500gm',9,'single',19,128,21,NULL,NULL,'exclusive',520,0,1,1,'5050083190612','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:42:24','2019-12-28 15:42:24',NULL),(3573,'Kellogg\'s  Choco Pops 500gm',9,'single',19,128,21,NULL,NULL,'exclusive',530,0,1,1,'5050083509247','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:44:49','2019-12-28 15:44:49',NULL),(3574,'Kellogg\'s  Variety Pack 191gm',9,'single',19,128,21,NULL,NULL,'exclusive',360,0,1,1,'5053827191753','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:53:30','2019-12-28 15:53:30',NULL),(3575,'Weetabix 430gm',9,'single',19,330,5,NULL,NULL,'exclusive',450,0,1,1,'5010029000016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-28 15:57:28','2020-06-13 14:57:00',NULL),(3576,'Kikat 12X20.5 gm',9,'single',19,63,15,NULL,NULL,'exclusive',350,0,1,1,'6294003557560','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 17:11:27','2020-03-12 20:33:38',NULL),(3577,'Fruit Pizza 15gm',9,'single',19,456,22,NULL,NULL,'exclusive',25,0,1,1,'8992741904049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 17:19:37','2019-12-29 17:19:37',NULL),(3578,'Rainbow  Umbrella 32gm',9,'single',19,266,22,NULL,NULL,'exclusive',70,0,1,1,'8852028322044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 17:23:13','2019-12-29 17:23:13',NULL),(3579,'Nestle Kitkat 4 finger Dark 41.5g',9,'single',19,63,15,NULL,NULL,'exclusive',90,0,1,1,'7613035510128','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 17:27:46','2020-03-12 20:20:34',NULL),(3580,'Wrigles Extra Sweet Mint 56gm',9,'single',19,130,22,NULL,NULL,'exclusive',220,0,1,1,'9555192504443','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 17:41:21','2019-12-29 17:41:21',NULL),(3581,'Horlicks Chocolate  500gm',9,'single',19,151,60,NULL,NULL,'exclusive',450,0,1,1,'8901571000036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 17:46:23','2019-12-29 17:46:23',NULL),(3582,'olitalia Olive Oil 100ml',9,'single',19,176,29,NULL,NULL,'exclusive',200,0,1,1,'8007150903511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 18:04:23','2019-12-29 18:04:23',NULL),(3583,'Tong Garden Party Snacks 180gm',9,'single',19,177,53,NULL,NULL,'exclusive',240,0,1,1,'8850291103544','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 18:16:13','2019-12-29 18:16:13',NULL),(3584,'Tong garden Masala 180gm tin',9,'single',19,177,9,NULL,NULL,'exclusive',210,0,1,1,'8850291107757','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 18:18:19','2019-12-29 18:18:19',NULL),(3585,'Aaba Premium Basmoti rice 1kg',9,'single',19,485,54,NULL,NULL,'exclusive',300,0,1,1,'8906117000099','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 18:22:08','2019-12-29 18:22:08',NULL),(3586,'Aaba Premium Basmoti rice 5kg',9,'single',19,485,54,NULL,NULL,'exclusive',1550,0,1,1,'8906117000082','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 18:23:40','2019-12-29 18:23:40',NULL),(3587,'ORION Choco pie 336gm',9,'single',19,449,73,NULL,NULL,'exclusive',470,0,1,1,'8801117807634','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 19:43:21','2019-12-29 19:43:21',NULL),(3588,'ORION Custard 138gm',9,'single',19,449,73,NULL,NULL,'exclusive',260,0,1,1,'8936036020120','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 19:50:13','2019-12-29 19:50:13',NULL),(3589,'Power ADE Mountain Blast 600ml',9,'single',19,486,34,NULL,NULL,'exclusive',220,0,1,1,'8801094362706','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 19:57:08','2019-12-29 19:57:08',NULL),(3590,'Strabucks Frappuccino Mocha 281ml',9,'single',19,487,16,NULL,NULL,'exclusive',330,0,1,1,'8801037086195','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:00:48','2019-12-29 20:00:48',NULL),(3591,'Capri- Sun Orange Juice 200ml',9,'single',19,446,24,NULL,NULL,'exclusive',90,0,1,1,'8801043650311','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:06:42','2019-12-29 20:06:42',NULL),(3592,'Kellogg\'s  Hershey\'s 500gm',9,'single',19,111,21,NULL,NULL,'exclusive',900,0,1,1,'8801083445014','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:09:03','2019-12-29 20:09:03',NULL),(3593,'Haitai Saltine Crackers 141gm',9,'single',19,488,42,NULL,NULL,'exclusive',250,0,1,1,'8801019300981','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:12:49','2019-12-29 20:12:49',NULL),(3594,'Haitai Orginal Crackers 172gm',9,'single',19,488,42,NULL,NULL,'exclusive',250,0,1,1,'8801019300950','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:14:40','2019-12-29 20:14:40',NULL),(3595,'Virginia G G Dates Juice  240ml SD',9,'single',19,204,24,NULL,NULL,'exclusive',100,0,1,1,'79954666','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:42:07','2019-12-29 20:42:07',NULL),(3596,'Shri varalakshmi Garlic Pappad 500gm',9,'single',19,489,86,NULL,NULL,'exclusive',180,0,1,1,'8906022340532','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 20:58:57','2019-12-29 20:58:57',NULL),(3597,'Shri varalakshmi Red Chilli Pappad 500gm',9,'single',19,489,86,NULL,NULL,'exclusive',180,0,1,1,'8906022340549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 21:00:56','2019-12-29 21:00:56',NULL),(3598,'Shri varalakshmi Green Chilli Pappad 500gm',9,'single',19,489,86,NULL,NULL,'exclusive',180,0,1,1,'8906022340570','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 21:03:04','2019-12-29 21:03:04',NULL),(3599,'Clorox Bleach(Lemon) 1 lt',9,'single',19,34,85,NULL,NULL,'exclusive',350,0,1,1,'9556823145059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 21:24:11','2019-12-29 21:24:11',NULL),(3600,'Mr. Hung Sweet Chili sauce 700ml',9,'single',19,414,32,NULL,NULL,'exclusive',270,0,1,1,'8852633640908','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-29 21:57:28','2019-12-29 21:57:28',NULL),(3601,'Water Melon Lollipop 15gm',9,'single',19,490,57,NULL,NULL,'exclusive',75,0,1,1,'6932043895685','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 14:32:18','2019-12-30 14:32:18',NULL),(3602,'Sunflower Lollipop 35gm',9,'single',19,491,57,NULL,NULL,'exclusive',75,0,1,1,'6933227300377','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 14:36:06','2019-12-30 14:36:06',NULL),(3603,'Nutella B-Ready Bar 22gm',9,'single',19,132,NULL,NULL,NULL,'exclusive',55,0,1,1,'8000500224281','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 14:47:45','2019-12-30 14:47:45',NULL),(3604,'Twix White Bar 46gm',9,'single',19,124,3,NULL,NULL,'exclusive',100,0,1,1,'5000159486972','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 14:51:51','2019-12-30 14:51:51',NULL),(3605,'M&M Crunchy Honey comb 150gm',9,'single',19,127,15,NULL,NULL,'exclusive',480,0,1,1,'9300682054362','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 14:57:51','2019-12-30 14:57:51',NULL),(3606,'M&M Crispy 150gm',9,'single',19,127,15,NULL,NULL,'exclusive',480,0,1,1,'9300682049306','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 14:59:41','2019-12-30 14:59:41',NULL),(3607,'Maltesers Teasers Dark Chocolate 146gm',9,'single',19,65,15,NULL,NULL,'exclusive',480,0,1,1,'9300682052092','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:05:31','2019-12-30 15:05:31',NULL),(3608,'Taj Premium Dried figs 500gm',9,'single',19,492,5,NULL,NULL,'exclusive',880,0,1,1,'8597576352104','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:09:38','2019-12-30 15:09:38',NULL),(3609,'Dried apricots 350gm',9,'single',19,493,76,NULL,NULL,'exclusive',420,0,1,1,'8681812070850','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:13:10','2019-12-30 15:13:10',NULL),(3610,'Twix Creamy Peanut Butter Bar 47.6gm',9,'single',19,124,3,NULL,NULL,'exclusive',120,0,1,1,'7896423472400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:16:19','2019-12-30 15:16:19',NULL),(3611,'Lick Me Lollipop 60gm',9,'single',19,434,57,NULL,NULL,'exclusive',130,0,1,1,'6935543220612','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:21:59','2019-12-30 15:21:59',NULL),(3612,'Lollipop 19gm',9,'single',19,434,57,NULL,NULL,'exclusive',50,0,1,1,'6954302905171','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:26:56','2019-12-30 15:26:56',NULL),(3613,'Mini Ball Lollipop 30gm',9,'single',19,434,57,NULL,NULL,'exclusive',70,0,1,1,'6954302979400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:37:36','2019-12-30 15:37:36',NULL),(3614,'Jelly pop lollipop 17gm',9,'single',19,434,57,NULL,NULL,'exclusive',60,0,1,1,'6930813303637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:40:03','2019-12-30 15:40:03',NULL),(3615,'Jelly Bean Lollipop 20gm',9,'single',19,434,57,NULL,NULL,'exclusive',75,0,1,1,'6958482111605','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:55:45','2019-12-30 15:55:45',NULL),(3616,'Horlicks Original Traditional Milk Drink 2kg',9,'single',19,151,60,NULL,NULL,'exclusive',2100,0,1,1,'5000134041783','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 15:58:33','2019-12-30 15:58:33',NULL),(3617,'Kitkat Dark 9 Bars',9,'single',19,63,15,NULL,NULL,'exclusive',330,0,1,1,'7613036099387','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:02:43','2019-12-30 16:02:43',NULL),(3618,'Kitkat Lemon Drizzle 9 Bars',9,'single',19,63,15,NULL,NULL,'exclusive',330,0,1,1,'7613036187824','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:04:45','2019-12-30 16:04:45',NULL),(3619,'Milka Alpine milk Bar 100gm',9,'single',19,494,15,NULL,NULL,'exclusive',360,0,1,1,'7622210476838','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:07:24','2019-12-30 16:07:24',NULL),(3620,'Milka confetti Bar 100gm',9,'single',19,494,15,NULL,NULL,'exclusive',360,0,1,1,'7622210163899','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:17:56','2019-12-30 16:17:56',NULL),(3621,'Milka Chocolate Balanco Bar 100gm',9,'single',19,494,15,NULL,NULL,'exclusive',330,0,1,1,'4025700001962','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:19:59','2019-12-30 16:19:59',NULL),(3622,'Milka Chips Ahoy Bar 100gm',9,'single',19,494,15,NULL,NULL,'exclusive',330,0,1,1,'7622210269249','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:21:28','2019-12-30 16:21:28',NULL),(3623,'Milka Oreo  Bar 100gm',9,'single',19,494,15,NULL,NULL,'exclusive',330,0,1,1,'7622210953421','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:23:12','2019-12-30 16:23:12',NULL),(3624,'Twinings Four Red Fruits Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177084738','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:25:57','2019-12-30 16:25:57',NULL),(3625,'Twinings Vanilla  Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177084769','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:27:51','2019-12-30 16:27:51',NULL),(3626,'Twinings Wild Berry Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177084806','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:29:25','2019-12-30 16:29:25',NULL),(3627,'Twinings Peach Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177055639','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:30:29','2019-12-30 16:30:29',NULL),(3628,'Twinings Blackcurrant  Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177084745','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:31:45','2019-12-30 16:31:45',NULL),(3629,'Twinings Apple, Cina & Raisin Tea 50gm',9,'single',19,152,37,NULL,NULL,'exclusive',330,0,1,1,'070177084813','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 16:33:08','2019-12-30 16:33:08',NULL),(3630,'Cadbury 5 Star 22.4gm',9,'single',19,129,15,NULL,NULL,'exclusive',20,0,1,1,'8901233036625','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-30 19:22:49','2019-12-30 19:22:49',NULL),(3631,'Tower Gate Bourbon Creams 400gm',9,'single',19,423,5,NULL,NULL,'exclusive',470,0,1,1,'20018979','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 16:33:45','2019-12-31 16:33:45',NULL),(3632,'Tower Gate malted Milk 200gm',9,'single',19,423,5,NULL,NULL,'exclusive',190,0,1,1,'20422998','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 16:39:10','2019-12-31 16:39:10',NULL),(3633,'Cadbury Dairymilk Marycllous 180g',9,'single',19,129,15,NULL,NULL,'exclusive',375,0,1,1,'7622210464507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 16:44:25','2019-12-31 16:45:42',NULL),(3634,'Cadbury Dairymilk tiffin 200g',9,'single',19,129,15,NULL,NULL,'exclusive',375,0,1,1,'7622210777423','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 16:47:09','2019-12-31 16:47:09',NULL),(3635,'Siro S.F. Vanilla wafers 260gm',9,'single',19,495,55,NULL,NULL,'exclusive',430,0,1,1,'8410156976647','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 16:58:04','2019-12-31 16:58:04',NULL),(3636,'Siro S.F. Digestive Biscuit   260gm',9,'single',19,495,5,NULL,NULL,'exclusive',500,0,1,1,'8410156976616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 17:00:33','2019-12-31 17:00:33',NULL),(3637,'TESCO Clear Honey 340gm',9,'single',19,357,56,NULL,NULL,'exclusive',500,0,1,1,'5052909732600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 17:03:39','2019-12-31 17:03:39',NULL),(3638,'Australian Instant Milk Powder 1kg',9,'single',19,496,26,NULL,NULL,'exclusive',1150,0,1,1,'9310053104978','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:01:51','2019-12-31 18:01:51',NULL),(3639,'Australian Protein  Instant Milk Powder 1kg',9,'single',19,496,26,NULL,NULL,'exclusive',1150,0,1,1,'9310053104985','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:03:50','2019-12-31 18:03:50',NULL),(3640,'Nestle NAN Comfort3  800gm',9,'single',19,63,26,NULL,NULL,'exclusive',2400,0,1,1,'7613035092020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:06:52','2019-12-31 18:06:52',NULL),(3641,'Nestle NAN Comfort2  800gm',9,'single',19,63,26,NULL,NULL,'exclusive',2200,0,1,1,'7613033975066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:09:26','2019-12-31 18:09:26',NULL),(3642,'Nestle NAN Comfort1  800gm',9,'single',19,63,26,NULL,NULL,'exclusive',2200,0,1,1,'7613033975097','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:10:51','2019-12-31 18:10:51',NULL),(3643,'TESCO Marshmallows 200gm',9,'single',19,357,7,NULL,NULL,'exclusive',280,0,1,1,'5010204313771','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:15:15','2019-12-31 18:15:15',NULL),(3644,'WRIGLES EXTRA PEPPERMINT 64 GM',9,'single',19,130,22,NULL,NULL,'exclusive',270,0,1,1,'4009900483513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:20:49','2019-12-31 18:20:49',NULL),(3645,'WRIGLES EXTRA SPEARMINT 64 GM',9,'single',19,130,22,NULL,NULL,'exclusive',270,0,1,1,'4009900497503','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:22:11','2019-12-31 18:22:11',NULL),(3646,'Mars X4 135.2gm',9,'single',19,125,15,NULL,NULL,'exclusive',300,0,1,1,'5000159513142','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:28:25','2019-12-31 18:28:25',NULL),(3647,'SNICKERS 4 BARS-142 GM',9,'single',19,120,3,NULL,NULL,'exclusive',300,0,1,1,'5000159513159','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2019-12-31 18:29:49','2019-12-31 18:29:49',NULL),(3648,'Nescafe Gold Decaff 100gm',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'7613036069830','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 21:31:55','2020-01-01 21:31:55',NULL),(3649,'Golden nut With Honey 420gm',9,'single',19,372,53,NULL,NULL,'exclusive',0,0,1,1,'8697435521204','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 21:34:02','2020-01-01 21:34:02',NULL),(3650,'Golden nut With Honey 720gm',9,'single',19,372,53,NULL,NULL,'exclusive',0,0,1,1,'8697435520245','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 21:36:47','2020-01-01 21:36:47',NULL),(3651,'A.G. Chunky Peanut Butter 510gm',9,'single',19,150,6,NULL,NULL,'exclusive',0,0,1,1,'689076384391','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 21:45:02','2020-01-01 21:45:02',NULL),(3652,'A.G. Creamy Peanut Butter 510gm',9,'single',19,150,6,NULL,NULL,'exclusive',0,0,1,1,'705105559643','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 21:47:55','2020-01-01 21:47:55',NULL),(3653,'A.G. Coconut milk 400gm',9,'single',19,150,26,NULL,NULL,'exclusive',0,0,1,1,'8858908300393','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 21:51:28','2020-01-01 21:51:28',NULL),(3654,'Quaker Whole Oats 700gm',9,'single',19,99,28,NULL,NULL,'exclusive',0,0,1,1,'6291003173981','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:00:44','2020-01-01 22:00:44',NULL),(3655,'Maggi Chicken Stock 20gm',9,'single',19,408,66,NULL,NULL,'exclusive',0,0,1,1,'6221007004066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:05:50','2020-01-01 22:05:50',NULL),(3656,'Knorr Chicken stock 20gm',9,'single',19,42,66,NULL,NULL,'exclusive',0,0,1,1,'6221048800191','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:09:00','2020-01-01 22:09:00',NULL),(3657,'Pledge natural Beauty 350gm',9,'single',19,497,87,NULL,NULL,'exclusive',0,0,1,1,'8992779011405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:22:57','2020-01-01 22:22:57',NULL),(3658,'Eac-cheta 17gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6922577100034','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:28:53','2020-01-01 22:28:53',NULL),(3659,'Mamy Poko Pants Extra absorb s-58',9,'single',19,275,68,NULL,NULL,'exclusive',0,0,1,1,'8903622000811','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:40:58','2020-01-01 22:40:58',NULL),(3660,'Mamy Poko Pants Extra absorb M-52',9,'single',19,275,68,NULL,NULL,'exclusive',0,0,1,1,'8903622000880','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:45:15','2020-01-01 22:45:15',NULL),(3661,'Mamy Poko Pants Extra absorb L-44',9,'single',19,275,68,NULL,NULL,'exclusive',0,0,1,1,'8903622000934','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 22:49:32','2020-01-01 22:49:32',NULL),(3662,'Mamy Poko Pants Extra absorb xxxl-24',9,'single',19,275,68,NULL,NULL,'exclusive',0,0,1,1,'8903622000354','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-01 23:00:37','2020-01-01 23:00:37',NULL),(3663,'Crown Peanut Butter Creamy 510 gm',9,'single',19,299,6,NULL,NULL,'exclusive',0,0,1,1,'012656707394','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-05 16:45:52','2020-01-05 16:45:52',NULL),(3664,'Italpasta Lasagne seet 500Gm',9,'single',19,469,30,NULL,NULL,'exclusive',0,0,1,1,'8009940031404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-05 17:02:50','2020-01-05 17:02:50',NULL),(3665,'Italpasta Spaghetti 500gm',9,'single',19,469,30,NULL,NULL,'exclusive',0,0,1,1,'8009940000035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-05 17:37:57','2020-01-05 17:37:57',NULL),(3666,'CH satay Broad Beans 150gm',9,'single',19,191,53,NULL,NULL,'exclusive',0,0,1,1,'8888100332007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-08 18:40:15','2020-01-08 18:40:15',NULL),(3667,'Golden circle Cranberry Fruit Drink 1Ltr',9,'single',19,141,24,NULL,NULL,'exclusive',0,0,1,1,'9310179199407','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-09 21:23:51','2020-01-09 21:23:51',NULL),(3668,'Lucy Bee Extra raw coconut oil 300gm',9,'single',19,498,29,NULL,NULL,'exclusive',0,0,1,1,'5060302580049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:07:15','2020-01-12 17:07:15',NULL),(3669,'Lucy Bee Extra raw coconut oil 500gm',9,'single',19,498,29,NULL,NULL,'exclusive',0,0,1,1,'5060302580001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:09:38','2020-01-12 17:09:38',NULL),(3670,'Tiana Fairtrade Organics oil 250ml',9,'single',19,499,29,NULL,NULL,'exclusive',0,0,1,1,'5060043610586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:13:28','2020-01-12 17:13:28',NULL),(3671,'Tiana Fairtrade Organics oil 350ml',9,'single',19,499,29,NULL,NULL,'exclusive',0,0,1,1,'5060043610821','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:21:41','2020-01-12 17:21:41',NULL),(3672,'Tiana Fairtrade extra Organics oil 350ml',9,'single',19,499,29,NULL,NULL,'exclusive',0,0,1,1,'5060043610395','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:23:52','2020-01-12 17:23:52',NULL),(3673,'Coco Fresh Coconut oil 500ml',9,'single',19,500,29,NULL,NULL,'exclusive',0,0,1,1,'5020580269227','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:26:44','2020-01-12 17:26:44',NULL),(3674,'Lago Saroiardi Lady fingers 200gm',9,'single',19,501,5,NULL,NULL,'exclusive',0,0,1,1,'8004800008152','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:30:54','2020-01-12 17:30:54',NULL),(3675,'Tiramisu Biscuit 200gm',9,'single',19,502,5,NULL,NULL,'exclusive',0,0,1,1,'8002720001901','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:33:27','2020-01-12 17:33:27',NULL),(3676,'Alesto Fruity Linseed Mix 150gm',9,'single',19,503,2,NULL,NULL,'exclusive',0,0,1,1,'20282424','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:38:16','2020-01-12 17:38:16',NULL),(3677,'Alesto Milled Chia Seeds  150gm',9,'single',19,503,2,NULL,NULL,'exclusive',0,0,1,1,'20719401','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:41:39','2020-01-12 17:41:39',NULL),(3678,'Ricola Lemon Mint 45gm',9,'single',19,504,22,NULL,NULL,'exclusive',0,0,1,1,'7610700612507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:44:30','2020-01-12 17:44:30',NULL),(3679,'Ricola  Original Mint 45gm',9,'single',19,504,22,NULL,NULL,'exclusive',0,0,1,1,'7610700614266','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:45:59','2020-01-12 17:45:59',NULL),(3680,'Ricola  Mountain Mint 45gm',9,'single',19,504,22,NULL,NULL,'exclusive',0,0,1,1,'7610700948576','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:47:29','2020-01-12 17:47:29',NULL),(3681,'Ricola Elder-flower 45gm',9,'single',19,504,22,NULL,NULL,'exclusive',0,0,1,1,'7610700612859','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:49:46','2020-01-12 17:49:46',NULL),(3682,'Aptamil Oats,Aplle & Plum Muesli 275gm',9,'single',19,274,1,NULL,NULL,'exclusive',0,0,1,1,'5051594003651','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:54:41','2020-01-12 17:54:41',NULL),(3683,'Aptamil Multigrain Fruit Muesli 275gm',9,'single',19,274,1,NULL,NULL,'exclusive',0,0,1,1,'5051594003637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 17:56:55','2020-01-12 17:56:55',NULL),(3684,'Asda Instant Coffee 100gm',9,'single',19,277,16,NULL,NULL,'exclusive',0,0,1,1,'21084638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 18:00:02','2020-01-12 18:00:02',NULL),(3685,'Gales Clear honey 300gm',9,'single',19,505,56,NULL,NULL,'exclusive',0,0,1,1,'5060391623689','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 18:02:12','2020-01-12 18:02:12',NULL),(3686,'Haribo Spaghetti Zing Strawberry 160gm',9,'single',19,263,22,NULL,NULL,'exclusive',0,0,1,1,'5012035956011','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 18:05:06','2020-01-12 18:05:06',NULL),(3687,'Lavache Qui rit Cheese 16 protin',9,'single',19,455,13,NULL,NULL,'exclusive',0,0,1,1,'3073780574242','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 18:31:21','2020-01-12 18:31:21',NULL),(3688,'Lavache Qui rit Cheese 24 protin',9,'single',19,455,13,NULL,NULL,'exclusive',0,0,1,1,'3073781073638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 18:33:18','2020-01-12 18:33:18',NULL),(3689,'Al Shafi Natural Honey 1kg',9,'single',19,506,56,NULL,NULL,'exclusive',0,0,1,1,'8906021925075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 22:05:49','2020-01-12 22:05:49',NULL),(3690,'Al Shafi Natural Honey 500gm',9,'single',19,506,56,NULL,NULL,'exclusive',0,0,1,1,'8906021924269','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-12 22:10:36','2020-01-12 22:10:36',NULL),(3691,'Durakan Gumy XXL lollipop',9,'single',19,507,57,NULL,NULL,'exclusive',0,0,1,1,'8691506352018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 00:25:04','2020-01-13 00:25:04',NULL),(3692,'Dura U Pops Lollipop',9,'single',19,507,57,NULL,NULL,'exclusive',0,0,1,1,'8691506506015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 00:27:28','2020-01-13 00:27:28',NULL),(3693,'banana lollipop',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6939343200065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 00:51:49','2020-01-13 00:51:49',NULL),(3694,'Love lollipop 19gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6954302905164','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 01:09:14','2020-01-13 01:09:14',NULL),(3695,'Toblerone T tiny Dark Chocolate 272gm',9,'single',19,116,15,NULL,NULL,'exclusive',0,0,1,1,'7622210496010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 01:12:31','2020-01-13 01:12:31',NULL),(3696,'Toblerone T tiny Dark Milk Chocolate 272gm',9,'single',19,116,15,NULL,NULL,'exclusive',0,0,1,1,'7622210496041','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 01:14:08','2020-01-13 01:14:08',NULL),(3697,'Tang Orange 2.5kg',9,'single',19,321,52,NULL,NULL,'exclusive',0,0,1,1,'7622300489922','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 01:16:33','2020-01-13 01:16:33',NULL),(3698,'Sesame oil  840ml SD',9,'single',19,2,29,NULL,NULL,'exclusive',0,0,1,1,'m12345','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:24:21','2020-01-13 17:24:21',NULL),(3699,'Del Monte Sliced Pineapple 567gm',9,'single',19,8,43,NULL,NULL,'exclusive',0,0,1,1,'l1452','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:31:28','2020-01-13 17:31:28',NULL),(3700,'Don Simon Apple Juice 1ltr SD',9,'single',19,9,24,NULL,NULL,'exclusive',0,0,1,1,'lo12354','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:34:39','2020-01-13 17:34:39',NULL),(3701,'Don Simon Mango Juice 1ltr SD',9,'single',19,9,24,NULL,NULL,'exclusive',0,0,1,1,'op4265543','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:39:33','2020-01-13 17:39:33',NULL),(3702,'Don Simon Orange Juice 1ltr SD',9,'single',19,9,24,NULL,NULL,'exclusive',0,0,1,1,'wer85230','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:42:09','2020-01-13 17:42:09',NULL),(3703,'Hosen evaporated Milk  (SD)',9,'single',19,14,26,NULL,NULL,'exclusive',0,0,1,1,'fg133645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:54:24','2020-01-13 17:54:24',NULL),(3704,'Hosen Garbanzo beans 425gm (SD)',9,'single',19,14,11,NULL,NULL,'exclusive',0,0,1,1,'cgy1597','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 17:56:38','2020-01-13 17:56:38',NULL),(3705,'Peacock Rice Vermicelli 400gm (SD)',9,'single',19,23,27,NULL,NULL,'exclusive',0,0,1,1,'dfh23546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:11:59','2020-01-13 18:11:59',NULL),(3706,'S & W Blueberries 425gm (SD)',9,'single',19,27,43,NULL,NULL,'exclusive',0,0,1,1,'asd2586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:14:59','2020-01-13 18:14:59',NULL),(3707,'S & W Cream Style corn 418gm (SD)',9,'single',19,27,11,NULL,NULL,'exclusive',0,0,1,1,'vue827','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:20:08','2020-01-13 18:20:08',NULL),(3708,'S&W Tomato Paste 170gm (SD)',9,'single',19,27,31,NULL,NULL,'exclusive',0,0,1,1,'weop147','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:29:15','2020-01-13 18:29:15',NULL),(3709,'San Remo Fusillni  Pasta 500gm sd',9,'single',19,28,30,NULL,NULL,'exclusive',0,0,1,1,'jklr2589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:33:24','2020-01-13 18:33:24',NULL),(3710,'San Remo Macaroni Pasta 500gm sd',9,'single',19,28,30,NULL,NULL,'exclusive',0,0,1,1,'nmlo85310','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:35:02','2020-01-13 18:35:02',NULL),(3711,'virgina G G Strawberry Syrup 624gm',9,'single',19,204,36,NULL,NULL,'exclusive',0,0,1,1,'ybhg8527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:47:21','2020-01-13 18:47:21',NULL),(3712,'virgina G G Green Peas 400gm',9,'single',19,204,43,NULL,NULL,'exclusive',0,0,1,1,'mdrx357','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:50:55','2020-01-13 18:50:55',NULL),(3713,'virgina G G Chick Peas 400gm',9,'single',19,204,11,NULL,NULL,'exclusive',0,0,1,1,'urtb9365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-13 18:53:14','2020-01-13 18:53:14',NULL),(3714,'Lindt  Hello Cookies Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',0,0,1,1,'4000539221804','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 17:41:19','2020-01-14 17:41:19',NULL),(3715,'Lindt Hello Nougat Chocolate 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',0,0,1,1,'4000539222108','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 17:42:56','2020-01-14 17:42:56',NULL),(3716,'Siro S F Oaty Biscuits 387gm',9,'single',19,495,5,NULL,NULL,'exclusive',0,0,1,1,'8410156976623','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 18:40:45','2020-01-14 18:40:45',NULL),(3717,'Gullon S F Dark Choc Digestive Biscuits 270gm',9,'single',19,353,5,NULL,NULL,'exclusive',0,0,1,1,'8410376047028','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 18:48:56','2020-01-14 18:48:56',NULL),(3718,'Douwe Egberts 190g',9,'single',19,508,16,NULL,NULL,'exclusive',0,0,1,1,'8711000279472','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 20:20:44','2020-01-14 20:20:44',NULL),(3719,'Kitkat 27.5gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'8901058144345','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 20:41:59','2020-01-14 20:41:59',NULL),(3720,'Kitkat 37.3g',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'8901058143102','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-14 20:44:33','2020-01-14 20:44:33',NULL),(3721,'Jazz uk Harvest Basil Seed Drink SF Mango 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310606','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-15 00:45:30','2020-10-02 21:49:01',NULL),(3722,'Jazz uk Harvest Basil Seed Drink Pomegranate  290ml',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310743','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:25:16','2020-10-02 21:41:10',NULL),(3723,'American Harvest Basil Seed Drink Blueberry 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310583','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:26:55','2020-01-16 13:26:55',NULL),(3724,'JAZZ UK Basil Seed Drink Honey 256gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310750','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:28:32','2020-10-02 21:38:43',NULL),(3725,'Jazz uk Harvest Basil Seed Drink Apple 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:29:46','2020-10-02 21:50:32',NULL),(3726,'American Harvest Basil Seed Drink orange S F 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310248','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:30:57','2020-01-16 13:30:57',NULL),(3727,'American Harvest Basil Seed Drink Lychee SF 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310613','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:32:16','2020-01-16 13:32:16',NULL),(3728,'American Harvest Basil Seed Drink Lemon 256gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908309761','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:33:06','2020-10-02 21:47:18',NULL),(3729,'American Harvest Basil Seed Drink Watermelon 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310569','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:33:50','2020-01-16 13:33:50',NULL),(3730,'American Harvest Basil Seed Drink strawberry 174gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908310576','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:34:46','2020-01-16 13:34:46',NULL),(3731,'Jazz uk Basil Seed Drink Tamarind 256gm',9,'single',19,327,24,NULL,NULL,'exclusive',0,0,1,1,'8858908311160','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:36:03','2020-10-02 21:39:25',NULL),(3732,'Mars Minis Chocolates pkt 234 gm',9,'single',19,125,15,NULL,NULL,'exclusive',0,0,1,1,'6294001826361','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:42:27','2020-01-16 13:42:27',NULL),(3733,'Bounty Minis Chocolates pkt 427.5g',9,'single',19,122,15,NULL,NULL,'exclusive',0,0,1,1,'6294001820680','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 13:44:13','2020-01-16 13:44:13',NULL),(3734,'Cadbury Dairy milk hazelnut  40gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'9556182104025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:04:10','2020-01-16 14:04:10',NULL),(3735,'Cadbury Dairy milk Chocolate  40gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'9556182104001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:05:49','2020-01-16 14:05:49',NULL),(3736,'Cadbury Dairy milk almond 40gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'9556182104018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:06:45','2020-01-16 14:06:45',NULL),(3737,'Cadbury Dairy milk Fruit & Nut 40gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'9556182104049','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:07:53','2020-01-16 14:07:53',NULL),(3738,'Twix White Minis 303ggm',9,'single',19,124,15,NULL,NULL,'exclusive',0,0,1,1,'5000159483247','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:12:26','2020-01-16 14:12:26',NULL),(3739,'Nestle Kitkat mini 250gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'6294003545604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:16:18','2020-01-16 14:16:18',NULL),(3740,'Nestle Smarties Mini  216gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'7613032705497','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:18:54','2020-01-16 14:18:54',NULL),(3741,'Roshen Konafetto Cocoa & Milk 156gm',9,'single',19,509,55,NULL,NULL,'exclusive',0,0,1,1,'4823077618178','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:22:11','2020-01-16 14:22:11',NULL),(3742,'Roshen Konafetto Hazelnut 156gm',9,'single',19,509,55,NULL,NULL,'exclusive',0,0,1,1,'4823077618185','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:24:57','2020-01-16 14:24:57',NULL),(3743,'Nestle Quality Street 450gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'7613036881265','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 14:29:53','2020-01-16 14:29:53',NULL),(3744,'Pampers p. Protection 2 (68Pc)',9,'single',19,270,68,NULL,NULL,'exclusive',0,0,1,1,'4015400849155','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 20:20:16','2020-01-16 20:20:16',NULL),(3745,'Pampers p. Protection 5 (47Pc)',9,'single',19,270,68,NULL,NULL,'exclusive',0,0,1,1,'4015400849285','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-16 20:21:14','2020-01-16 20:21:14',NULL),(3746,'Snickers Fun size 360gm',9,'single',19,120,3,NULL,NULL,'exclusive',0,0,1,1,'Snickers360','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-18 16:17:54','2020-01-18 16:17:54',NULL),(3747,'Kellogg\'s  Chocos  moons & Stars 350gm',9,'single',19,128,64,NULL,NULL,'exclusive',0,0,1,1,'8901499008015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-18 16:27:36','2020-01-18 16:27:36',NULL),(3748,'Kellogg\'s  Granola almonds & Cranberry  460gm',9,'single',19,128,1,NULL,NULL,'exclusive',0,0,1,1,'8901499009715','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-18 16:33:56','2020-01-18 16:33:56',NULL),(3749,'Maggi masla Blast noodles 504gm',9,'single',19,408,27,NULL,NULL,'exclusive',0,0,1,1,'8941100294956','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-18 22:05:49','2020-01-18 22:05:49',NULL),(3750,'Tiffany Delights Chocolate Cookies 100gm',9,'single',19,242,18,NULL,NULL,'exclusive',0,0,1,1,'6291003010347','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-19 01:26:26','2020-01-19 01:26:26',NULL),(3751,'San Remo cous cous Pasta 500gm',9,'single',19,28,30,NULL,NULL,'exclusive',0,0,1,1,'9310155305037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-21 17:33:10','2020-01-21 17:33:10',NULL),(3752,'Balloon Candy toffy Fruit flv 35p',9,'single',19,510,7,NULL,NULL,'exclusive',0,0,1,1,'8854327000036','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 15:23:05','2020-01-22 15:23:05',NULL),(3753,'Evliya Chocolate 500gm',9,'single',19,401,15,NULL,NULL,'exclusive',0,0,1,1,'8680052611175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 15:32:42','2020-01-22 15:32:42',NULL),(3754,'Evliya Davet Chocolate  1kg',9,'single',19,401,15,NULL,NULL,'exclusive',0,0,1,1,'8680052608205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 15:36:45','2020-01-22 15:36:45',NULL),(3755,'Bifa Chocolate 260gm',9,'single',19,400,15,NULL,NULL,'exclusive',0,0,1,1,'360400430','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 15:52:09','2020-01-22 15:52:09',NULL),(3756,'Bifa Chocolate 320gm',9,'single',19,400,15,NULL,NULL,'exclusive',0,0,1,1,'320470500','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 15:55:13','2020-01-22 15:55:13',NULL),(3757,'Bifa Chocolate 360gm',9,'single',19,400,15,NULL,NULL,'exclusive',0,0,1,1,'3757','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 16:02:02','2020-01-22 16:02:02',NULL),(3758,'Bifa Chocolate 360gm',9,'single',19,400,15,NULL,NULL,'exclusive',0,0,1,1,'480580650','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 16:03:14','2020-01-22 16:03:14',NULL),(3759,'TAYAS Orient  Chocolate Jar 1kg',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997136176','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 16:34:58','2020-01-22 16:34:58',NULL),(3760,'Tayas love Special chocolate 1kg',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997117175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-22 16:38:27','2020-01-22 16:38:27',NULL),(3761,'Good Day mocacinno Coffee 20gm',9,'single',19,314,16,NULL,NULL,'exclusive',0,0,1,1,'8991002103238','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-23 13:31:25','2020-01-23 13:31:25',NULL),(3762,'Tipco 100% Cranberry Mixed Fruit Juice 1 Lt',9,'single',19,276,24,NULL,NULL,'exclusive',0,0,1,1,'8851013768492','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-25 17:45:07','2020-01-25 17:45:07',NULL),(3763,'Good Day Mocachino Combo',9,'single',19,314,16,NULL,NULL,'exclusive',0,0,1,1,'08072021','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-25 20:16:27','2020-01-25 20:16:27',NULL),(3764,'Virginia Classic Mayonnaise 500ml sd',9,'single',19,204,25,NULL,NULL,'exclusive',0,0,1,1,'231220','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 13:32:27','2020-01-27 13:32:27',NULL),(3765,'Virgina G G Basil Seed Drinks Lychee Flv 290ml SD',9,'single',19,204,24,NULL,NULL,'exclusive',0,0,1,1,'vir26421','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 13:36:31','2020-01-27 13:36:31',NULL),(3766,'Virgina G G Basil Seed Drinks Orange Flv 290ml SD',9,'single',19,204,24,NULL,NULL,'exclusive',0,0,1,1,'orng258951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 13:39:56','2020-01-27 13:39:56',NULL),(3767,'Virginia Golden Cream 170 ml SD',9,'single',19,204,41,NULL,NULL,'exclusive',0,0,1,1,'gold25873654','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 13:44:48','2020-01-27 13:44:48',NULL),(3768,'Virginia G G Spanish Green Olive 370g SD',9,'single',19,204,49,NULL,NULL,'exclusive',0,0,1,1,'olive14753','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 13:49:46','2020-01-27 13:49:46',NULL),(3769,'Hosen peaches half 825gm',9,'single',19,14,43,NULL,NULL,'exclusive',0,0,1,1,'peasces36526','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:00:57','2020-07-23 00:06:08',NULL),(3770,'Hosen  Whole Peeled Tomato Pelati 400gm SD',9,'single',19,14,11,NULL,NULL,'exclusive',0,0,1,1,'peeled23136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:07:45','2020-01-27 14:07:45',NULL),(3771,'Hosen Lychee 560gm SD',9,'single',19,14,43,NULL,NULL,'exclusive',0,0,1,1,'Lychee 025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:26:21','2020-01-27 14:26:21',NULL),(3772,'Hosen Red Maraschino Cherries 284gm SD',9,'single',19,14,43,NULL,NULL,'exclusive',0,0,1,1,'Chery360','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:31:15','2020-01-27 14:31:15',NULL),(3773,'Hosen Green Olive Pitted 345sd',9,'single',19,14,49,NULL,NULL,'exclusive',0,0,1,1,'h.olive250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:46:27','2020-01-27 14:46:27',NULL),(3774,'Orgran GF Rice & Corn Tortelli 250g Sd',9,'single',19,22,30,NULL,NULL,'exclusive',0,0,1,1,'3774','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:49:43','2020-01-27 14:49:43',NULL),(3775,'Orgran GF Rice & Corn Tortelli 250g Sd',9,'single',19,22,30,NULL,NULL,'exclusive',0,0,1,1,'organ988','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 14:50:36','2020-01-27 14:50:36',NULL),(3776,'virgina G G White Oats 400gm SD',9,'single',19,204,28,NULL,NULL,'exclusive',0,0,1,1,'Oats250','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:09:01','2020-01-27 15:09:01',NULL),(3777,'Vitalia Coffee & Nut Bar 30gm SD',9,'single',19,1,3,NULL,NULL,'exclusive',0,0,1,1,'Bar2565','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:11:14','2020-01-27 15:11:14',NULL),(3778,'Hunts BBQ Sauce 510g SD',9,'single',19,15,32,NULL,NULL,'exclusive',0,0,1,1,'BBQ8963','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:15:17','2020-01-27 15:15:17',NULL),(3779,'Pepsi Cola 330ml SD',9,'single',19,24,4,NULL,NULL,'exclusive',0,0,1,1,'Pepsi623','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:25:14','2020-01-27 15:25:14',NULL),(3780,'Don Simon Pineapple Juice 1.5ltr Sd',9,'single',19,9,24,NULL,NULL,'exclusive',0,0,1,1,'don8523','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:28:25','2020-01-27 15:28:25',NULL),(3781,'Barilla Pesti 190ml Sd',9,'single',19,48,32,NULL,NULL,'exclusive',0,0,1,1,'Barilla25895','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:36:02','2020-01-27 15:36:02',NULL),(3782,'Lotte xylitol Original 16gm SD',9,'single',19,20,22,NULL,NULL,'exclusive',0,0,1,1,'Lotte7845','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:40:11','2020-01-27 15:40:11',NULL),(3783,'Promess Semi-Skimmed  Milk 1ltr Sd',9,'single',19,435,26,NULL,NULL,'exclusive',0,0,1,1,'Prommess9637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:50:17','2020-01-27 15:50:17',NULL),(3784,'Promess Skimmed  Milk 1ltr SD',9,'single',19,435,26,NULL,NULL,'exclusive',0,0,1,1,'Prommess85201o','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 15:52:36','2020-01-27 15:52:36',NULL),(3785,'Ligo Sour Cream & onion flv 160gm Sd',9,'single',19,18,14,NULL,NULL,'exclusive',0,0,1,1,'Ligo741689','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-27 16:23:01','2020-01-27 16:23:01',NULL),(3786,'Pedia Sure complete 400g',9,'single',19,388,64,NULL,NULL,'exclusive',0,0,1,1,'8886451085160','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-28 19:53:39','2020-09-17 17:21:05',NULL),(3787,'Ferrero Rocher 200gm',9,'single',19,115,15,NULL,NULL,'exclusive',0,0,1,1,'8000500003787','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 20:18:38','2020-01-28 20:18:38',NULL),(3788,'Cadbury Dairy Milk Daim Chocolate 120g',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'7622210431769','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 20:37:45','2020-01-28 20:37:45',NULL),(3789,'Cadbury Dairy Milk Oreo Chocolate 120g',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'7622210431646','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 20:39:46','2020-01-28 20:39:46',NULL),(3790,'Cadbury Dairy Milk Caramel Chocolate 120g',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'7622300737900','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 20:41:28','2020-01-28 20:41:28',NULL),(3791,'Munchy\'s Lexus Chocolate Sandwich 190gm',9,'single',19,59,5,NULL,NULL,'exclusive',0,0,1,1,'Munchy2569','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 22:39:23','2020-01-28 22:39:23',NULL),(3792,'Hup Seng Cream Crackers 225gm',9,'single',19,289,42,NULL,NULL,'exclusive',0,0,1,1,'9556085303914','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 22:48:52','2020-01-28 22:48:52',NULL),(3793,'Hup Seng Cream Crackers 125gm',9,'single',19,289,42,NULL,NULL,'exclusive',0,0,1,1,'9556085302726','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 22:51:01','2020-01-28 22:51:01',NULL),(3794,'Ori Happy Family Assorted Biscuit 650gm',9,'single',19,511,5,NULL,NULL,'exclusive',0,0,1,1,'9556562003207','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 23:18:10','2020-07-26 19:47:37',NULL),(3795,'Ori Salted Savoury Crackers 200gm',9,'single',19,511,5,NULL,NULL,'exclusive',0,0,1,1,'9556562006031','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 23:27:50','2020-01-28 23:27:50',NULL),(3796,'Ori Sarapan Susu Bis 200gm',9,'single',19,511,5,NULL,NULL,'exclusive',0,0,1,1,'9556562006055','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 23:29:58','2020-01-28 23:34:32',NULL),(3797,'Ori Sarapan Chocolate Bis 200gm',9,'single',19,511,5,NULL,NULL,'exclusive',0,0,1,1,'9556562006048','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 23:32:36','2020-01-28 23:32:36',NULL),(3798,'London Roll Choco Flv 20gm',9,'single',19,244,73,NULL,NULL,'exclusive',0,0,1,1,'9556055666124','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 23:50:11','2020-01-28 23:50:11',NULL),(3799,'London Roll Double Choco Milk Flv 20gm',9,'single',19,244,73,NULL,NULL,'exclusive',0,0,1,1,'9556218126779','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-28 23:52:07','2020-01-28 23:52:07',NULL),(3800,'Royel Fresh Mixed Dry Food 220gm',9,'single',19,77,65,NULL,NULL,'exclusive',0,0,1,1,'3641263761047','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 00:01:52','2020-01-29 00:01:52',NULL),(3801,'Thai Mixed Dry Food 135gm',9,'single',19,77,65,NULL,NULL,'exclusive',0,0,1,1,'Thai1258','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 00:05:18','2020-01-29 00:05:18',NULL),(3802,'You love You lollipop 100gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6935543210125','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:01:23','2020-01-29 01:02:16',NULL),(3803,'Frog Lollipop 50gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'9969806906316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:05:23','2020-01-29 01:05:23',NULL),(3804,'Lady Bug Lollipop 50gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6969946906231','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:07:26','2020-01-29 01:07:26',NULL),(3805,'Flamingo Lollipop 50gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6969946906217','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:10:36','2020-01-29 01:10:36',NULL),(3806,'Bonny Pops 50gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6969946906170','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:12:00','2020-01-29 01:12:00',NULL),(3807,'Spiral Lollipop 50gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6924736400146','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:13:19','2020-01-29 01:13:19',NULL),(3808,'Ferrero Rocher T-8',9,'single',19,115,15,NULL,NULL,'exclusive',0,0,1,1,'8000500313183','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:17:04','2020-01-29 01:17:04',NULL),(3809,'Ritter Sport Kaffeesplitter  Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417927002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:44:49','2020-01-29 01:44:49',NULL),(3810,'Ritter Sport 55% Die miled Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417931009','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:46:58','2020-01-29 01:46:58',NULL),(3811,'Ritter Sport Weisse Mandel Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417706003','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:48:57','2020-01-29 01:48:57',NULL),(3812,'Ritter Sport Ganze Mandel Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417703002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:50:09','2020-01-29 01:50:09',NULL),(3813,'Ritter Sport Dunkle Voll Nuss Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417702005','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:51:16','2020-01-29 01:51:16',NULL),(3814,'Ritter Sport Alpenmilch Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417018007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:52:38','2020-01-29 01:52:38',NULL),(3815,'Ritter Sport Weiss+Crisp Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417292001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:54:07','2020-01-29 01:54:07',NULL),(3816,'Ritter Sport Knusperflakes Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417011008','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:55:11','2020-01-29 01:55:11',NULL),(3817,'Ritter Sport Waffel Bar 100gm',9,'single',19,64,3,NULL,NULL,'exclusive',0,0,1,1,'4000417220004','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 01:56:09','2020-01-29 01:56:09',NULL),(3818,'Cadbury  Cookies 150gm',9,'single',19,129,18,NULL,NULL,'exclusive',0,0,1,1,'7622210934222','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 02:00:04','2020-01-29 02:00:04',NULL),(3819,'Hershey\'s Kisses Milk Chocolate 250gm',9,'single',19,111,15,NULL,NULL,'exclusive',0,0,1,1,'6942836713065','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:02:25','2020-01-29 15:02:25',NULL),(3820,'Quality Street  Toffeess 231gm',9,'single',19,436,15,NULL,NULL,'exclusive',0,0,1,1,'7613036881326','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:04:55','2020-01-29 15:04:55',NULL),(3821,'Maltesers Teasers 450gm',9,'single',19,65,15,NULL,NULL,'exclusive',0,0,1,1,'5000159475853','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:11:37','2020-01-29 15:11:37',NULL),(3822,'Celebrations Chocolate Pkt 365g',9,'single',19,66,15,NULL,NULL,'exclusive',0,0,1,1,'5000159501163','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:15:10','2020-01-29 15:15:10',NULL),(3823,'Bounty Miniatures Chocolates pkt 399g',9,'single',19,122,15,NULL,NULL,'exclusive',0,0,1,1,'6294001831044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:17:06','2020-01-29 15:17:06',NULL),(3824,'Twix Miniatures Chocolates pkt 260g',9,'single',19,124,15,NULL,NULL,'exclusive',0,0,1,1,'6294001830948','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:19:26','2020-01-29 15:19:26',NULL),(3825,'Snickers Miniatures Chocolates pkt 255g',9,'single',19,120,15,NULL,NULL,'exclusive',0,0,1,1,'6294001830887','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:22:10','2020-01-29 15:22:10',NULL),(3826,'Mars Minis Chocolates pkt 247gm',9,'single',19,125,15,NULL,NULL,'exclusive',0,0,1,1,'6294001830986','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:23:48','2020-01-29 15:23:48',NULL),(3827,'Cadbury Break Bar 364gm',9,'single',19,129,3,NULL,NULL,'exclusive',0,0,1,1,'7622210596383','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:25:23','2020-01-29 15:25:23',NULL),(3828,'Hershey\'s Cookies \'N\' Creme 242gm',9,'single',19,111,18,NULL,NULL,'exclusive',0,0,1,1,'6942836714208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:26:59','2020-01-29 15:26:59',NULL),(3829,'Hershey\'s Miniatures 294gm',9,'single',19,111,15,NULL,NULL,'exclusive',0,0,1,1,'034000214907','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:30:01','2020-01-29 15:30:01',NULL),(3830,'Hershey\'s Kisses Caramel 286gm',9,'single',19,111,15,NULL,NULL,'exclusive',0,0,1,1,'034000126293','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:31:23','2020-01-29 15:31:23',NULL),(3831,'Hershey\'s Kisses Milk Chocolate 306gm',9,'single',19,111,15,NULL,NULL,'exclusive',0,0,1,1,'034000140589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:32:52','2020-01-29 15:32:52',NULL),(3832,'Milka Biscuit Collection 350gm',9,'single',19,494,5,NULL,NULL,'exclusive',0,0,1,1,'7622210510044','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 15:34:46','2020-01-29 15:34:46',NULL),(3833,'Nestle Chokella 400gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'8690632056913','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 16:35:23','2020-01-29 16:35:23',NULL),(3834,'M&M Crispy 350gm',9,'single',19,127,15,NULL,NULL,'exclusive',0,0,1,1,'5060402905537','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 16:43:31','2020-01-29 16:43:31',NULL),(3835,'Maltesers Crunchy  350gm',9,'single',19,65,15,NULL,NULL,'exclusive',0,0,1,1,'5060402905513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:07:35','2020-01-29 17:07:35',NULL),(3836,'Ferrero Rocher Collection T-24',9,'single',19,115,15,NULL,NULL,'exclusive',0,0,1,1,'8000500178669','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:09:06','2020-01-29 17:09:06',NULL),(3837,'Dairy Milk Marvellous 38Gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'7622210327826','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:11:11','2020-02-17 23:19:57',NULL),(3838,'Trident Spearmint Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',0,0,1,1,'012546011075','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:15:49','2020-01-29 17:15:49',NULL),(3839,'Wrigles Extra Sweet watermelon Gum 15 sticks',9,'single',19,130,22,NULL,NULL,'exclusive',0,0,1,1,'02283801','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:18:13','2020-01-29 17:18:13',NULL),(3840,'Wrigles Extra Classic Bubbly  Gum 15 sticks',9,'single',19,130,22,NULL,NULL,'exclusive',0,0,1,1,'02284509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:19:29','2020-01-29 17:19:29',NULL),(3841,'Wrigles Extra Smooth mint Gum 15 sticks',9,'single',19,130,22,NULL,NULL,'exclusive',0,0,1,1,'022000014139','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:20:14','2020-01-29 17:20:14',NULL),(3842,'Twix Top Bar 21gm',9,'single',19,124,3,NULL,NULL,'exclusive',0,0,1,1,'5900951251849','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:30:46','2020-01-29 17:30:46',NULL),(3843,'Nestle Lion 2Bar',9,'single',19,63,3,NULL,NULL,'exclusive',0,0,1,1,'7613034275349','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:33:18','2020-01-29 17:33:18',NULL),(3844,'Kitkat Crunchy Bar 40gm',9,'single',19,63,3,NULL,NULL,'exclusive',0,0,1,1,'3800020423578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:37:32','2020-01-29 17:37:32',NULL),(3845,'Nestle Tola 31gm',9,'single',19,63,3,NULL,NULL,'exclusive',0,0,1,1,'6294003544690','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:39:23','2020-01-29 17:39:23',NULL),(3846,'Nestle Kitkat Cookie Crumble 19.5gm',9,'single',19,63,3,NULL,NULL,'exclusive',0,0,1,1,'6294003569006','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:52:16','2020-01-29 17:52:16',NULL),(3847,'Kitkat Chunky Cramel  42gm',9,'single',19,63,3,NULL,NULL,'exclusive',0,0,1,1,'6294003588274','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 17:57:37','2020-01-29 17:57:37',NULL),(3848,'Galaxy Smooth Milk 90gm',9,'single',19,110,3,NULL,NULL,'exclusive',0,0,1,1,'6294001821700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 18:00:02','2020-01-29 18:00:02',NULL),(3849,'Kinder Maxi 21gm',9,'single',19,69,3,NULL,NULL,'exclusive',0,0,1,1,'40084077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 18:16:41','2020-01-29 18:16:41',NULL),(3850,'Almarai Milk Powder 900g Tin',9,'single',19,254,26,NULL,NULL,'exclusive',0,0,1,1,'6281007038614','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 18:21:20','2020-09-08 16:17:53',NULL),(3851,'Almarai Milk Powder 2.5kg Tin',9,'single',19,254,26,NULL,NULL,'exclusive',0,0,1,1,'6281007038591','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 18:24:00','2020-09-08 16:17:12',NULL),(3852,'Trident Strawberry Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',0,0,1,1,'012546011648','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 19:05:59','2020-01-29 19:05:59',NULL),(3853,'Trident Original Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',0,0,1,1,'012546011099','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 19:06:42','2020-01-29 19:06:42',NULL),(3854,'Trident Bubble gum Fla 14 Sticks',9,'single',19,109,22,NULL,NULL,'exclusive',0,0,1,1,'012546011440','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-01-29 19:07:25','2020-01-29 19:07:25',NULL),(3855,'Ceres 100% juice red grap 200ml',9,'single',19,82,24,NULL,NULL,'exclusive',0,0,1,1,'6001240200070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 15:49:33','2020-01-31 15:49:33',NULL),(3856,'Ceres 100% juice red grap 200ml',9,'single',19,82,24,NULL,NULL,'exclusive',0,0,1,1,'6001240200070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 15:49:34','2020-01-31 15:49:34',NULL),(3857,'Ceres Delight apple juice 1lit',9,'single',19,82,24,NULL,NULL,'exclusive',0,0,1,1,'6001240231166','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 15:52:51','2020-01-31 15:52:51',NULL),(3858,'Grante 100% pure quince juice 750ml',9,'single',19,80,24,NULL,NULL,'exclusive',0,0,1,1,'4760041300038','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 15:56:23','2020-01-31 15:56:23',NULL),(3859,'Grante 100% apple and feijoa juice 750ml',9,'single',19,80,24,NULL,NULL,'exclusive',0,0,1,1,'4760041300748','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 15:58:46','2020-01-31 15:58:46',NULL),(3860,'Grante  pomegrante nectar',9,'single',19,80,24,NULL,NULL,'exclusive',0,0,1,1,'4760041300458','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:02:08','2020-01-31 16:02:08',NULL),(3861,'Grante Sweet Cherry nectar',9,'single',19,80,24,NULL,NULL,'exclusive',0,0,1,1,'4760041300892','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:05:55','2020-01-31 16:05:55',NULL),(3862,'Grante Feijoa nectar 1lit',9,'single',19,80,24,NULL,NULL,'exclusive',0,0,1,1,'4760041300632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:07:39','2020-01-31 16:07:39',NULL),(3863,'Sabroso Extra virgin olive oil 1lit',9,'single',19,512,29,NULL,NULL,'exclusive',0,0,1,1,'8420701502016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:10:15','2020-01-31 16:10:15',NULL),(3864,'Sabroso pomace olive oil 1 lit',9,'single',19,512,29,NULL,NULL,'exclusive',0,0,1,1,'8420701503013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:11:57','2020-01-31 16:11:57',NULL),(3865,'Sabroso pomace olive oil 2lit',9,'single',19,512,29,NULL,NULL,'exclusive',0,0,1,1,'8420701503464','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:14:28','2020-01-31 16:14:28',NULL),(3866,'sabroso pomace olive oil 5lit',9,'single',19,512,29,NULL,NULL,'exclusive',0,0,1,1,'8420701503037','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:20:37','2020-01-31 16:20:37',NULL),(3867,'Sabroso pomace olive oil 250ml',9,'single',19,512,29,NULL,NULL,'exclusive',0,0,1,1,'8420701503136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-01-31 16:23:32','2020-01-31 16:23:32',NULL),(3868,'LONDON Pie Choco Flv  (24pcs)',9,'single',19,244,NULL,NULL,NULL,'exclusive',0,0,1,1,'9556218126823','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-02-02 17:30:19','2020-02-02 17:30:19',NULL),(3869,'LONDON Pie Roll Coconut Cake (24pcs)',9,'single',19,244,5,NULL,NULL,'exclusive',0,0,1,1,'9556218126847','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-02-02 17:31:48','2020-02-02 17:31:48',NULL),(3870,'London Roll Double Choco Milk Flv (24pcs)',9,'single',19,244,5,NULL,NULL,'exclusive',0,0,1,1,'9556218126786','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-02-02 17:32:49','2020-02-02 17:32:49',NULL),(3871,'London Roll Coconut  Milk Flv 20gm',9,'single',19,244,5,NULL,NULL,'exclusive',0,0,1,1,'9556218126946','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-02-02 17:36:05','2020-02-02 17:36:05',NULL),(3872,'Borges Apple Cider vinegar 500ml',9,'single',19,70,39,NULL,NULL,'exclusive',0,0,1,1,'8410179308128','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-06 13:47:07','2020-02-06 13:47:07',NULL),(3873,'Foster Clarks Vanilla Cake Mix 500gm',9,'single',19,57,51,NULL,NULL,'exclusive',0,0,1,1,'5352101004117','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-06 13:55:38','2020-02-06 13:55:38',NULL),(3874,'Foster Clarks Milk Chocolate  Cake Mix 500gm',9,'single',19,57,51,NULL,NULL,'exclusive',0,0,1,1,'5352101363856','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-06 13:59:55','2020-02-06 13:59:55',NULL),(3875,'Foster Clarks Dark Chocolate Cake Mix 500gm',9,'single',19,57,51,NULL,NULL,'exclusive',0,0,1,1,'5352101003554','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-06 14:02:10','2020-02-06 14:02:10',NULL),(3876,'CAPILANO manuka5+ HONEY  250g',9,'single',19,165,56,NULL,NULL,'exclusive',0,0,1,1,'9300677008370','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:00:10','2020-02-09 14:00:10',NULL),(3877,'CAPILANO Manuka HONEY 340g',9,'single',19,165,56,NULL,NULL,'exclusive',0,0,1,1,'9300677008721','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:01:38','2020-02-09 14:01:38',NULL),(3878,'CAPILANO Creamed HONEY 500g',9,'single',19,165,56,NULL,NULL,'exclusive',0,0,1,1,'93677110','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:03:18','2020-02-09 14:03:18',NULL),(3879,'BERRI Apricot Drink 2LTR',9,'single',19,168,24,NULL,NULL,'exclusive',0,0,1,1,'9310113900632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:07:08','2020-02-09 14:07:08',NULL),(3880,'Only Organic Apple,Banana & Mango 120gm',9,'single',19,386,64,NULL,NULL,'exclusive',0,0,1,1,'9403145302748','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:47:27','2020-02-09 14:47:27',NULL),(3881,'Only Organic Pear,Banana & Apple  120gm',9,'single',19,386,64,NULL,NULL,'exclusive',0,0,1,1,'9403145302755','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:48:49','2020-02-09 14:48:49',NULL),(3882,'Only Organic Banana, Blueberry & Quinoa 120gm',9,'single',19,386,64,NULL,NULL,'exclusive',0,0,1,1,'9403145303714','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:50:22','2020-02-09 14:50:22',NULL),(3883,'Only Organic Banana,Raspberry & Vanilla 120gm',9,'single',19,386,64,NULL,NULL,'exclusive',0,0,1,1,'9403145302779','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:51:44','2020-02-09 14:51:44',NULL),(3884,'Only Organic Vanilla Beans Custard 120gm',9,'single',19,386,64,NULL,NULL,'exclusive',0,0,1,1,'9403145303172','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 14:53:12','2020-02-09 14:53:12',NULL),(3885,'Sanitarium Weet-Bix Blends  375gm',9,'single',19,143,18,NULL,NULL,'exclusive',0,0,1,1,'9300652006520','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:18:51','2020-08-13 00:38:26',NULL),(3886,'Heinz Spicy Peri Peri Mayonnaise 295ml',9,'single',19,13,25,NULL,NULL,'exclusive',0,0,1,1,'9300657021696','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:20:57','2020-02-09 15:20:57',NULL),(3887,'Zoosh Tangy Classic Mayo 525gm',9,'single',19,513,25,NULL,NULL,'exclusive',0,0,1,1,'9352042001066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:22:21','2020-02-09 15:22:21',NULL),(3888,'Sanitarium Crunchy Peanut Butter 500gm',9,'single',19,416,6,NULL,NULL,'exclusive',0,0,1,1,'9300652012224','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:25:16','2020-02-09 15:25:16',NULL),(3889,'Sanitarium Smoth Peanut Butter 500gm',9,'single',19,143,6,NULL,NULL,'exclusive',0,0,1,1,'9300652012217','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:26:32','2020-02-09 15:26:32',NULL),(3890,'Nutella Hazelnut W Cocoa 400gm',9,'single',19,132,41,NULL,NULL,'exclusive',0,0,1,1,'9300698000216','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:28:22','2020-02-09 15:28:22',NULL),(3891,'harppic Marine splash',9,'single',19,514,48,NULL,NULL,'exclusive',0,0,1,1,'9300701234157','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:31:53','2020-02-09 15:31:53',NULL),(3892,'Harppic Summer Breeze',9,'single',19,514,48,NULL,NULL,'exclusive',0,0,1,1,'9300701228026','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 15:59:35','2020-02-09 15:59:35',NULL),(3893,'harppic Tropical Blossom',9,'single',19,514,48,NULL,NULL,'exclusive',0,0,1,1,'9300701234140','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:02:01','2020-02-09 16:02:01',NULL),(3894,'Harpic Fresh Power Marine Splash 700ml',9,'single',19,514,85,NULL,NULL,'exclusive',0,0,1,1,'9300701225063','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:05:22','2020-02-09 16:05:22',NULL),(3895,'Harpic Fresh Power Tropical Blossom 700ml',9,'single',19,514,85,NULL,NULL,'exclusive',0,0,1,1,'9300701225087','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:06:46','2020-02-09 16:06:46',NULL),(3896,'Harpic Fresh Power Summer Breeze 700ml',9,'single',19,514,85,NULL,NULL,'exclusive',0,0,1,1,'9300701225070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:07:43','2020-02-09 16:07:43',NULL),(3897,'Napsan Vanish Oxi Action Pro 900gm',9,'single',19,515,85,NULL,NULL,'exclusive',0,0,1,1,'9300701708498','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:44:47','2020-02-09 16:44:47',NULL),(3898,'Napisan Vanish Oxi Action Pro Gel 950gml',9,'single',19,515,85,NULL,NULL,'exclusive',0,0,1,1,'9300701223113','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:47:48','2020-02-09 16:48:34',NULL),(3899,'Fab Fresh Blossom 2kg',9,'single',19,196,88,NULL,NULL,'exclusive',0,0,1,1,'9350376000472','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:57:11','2020-02-09 16:57:11',NULL),(3900,'Fab Fresh Frangipani 2kg',9,'single',19,196,88,NULL,NULL,'exclusive',0,0,1,1,'9350376000540','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 16:58:30','2020-02-09 16:58:30',NULL),(3901,'Fab Fresh Perfume Indulgence 2kg',9,'single',19,196,88,NULL,NULL,'exclusive',0,0,1,1,'9350376000632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-09 17:01:37','2020-02-09 17:01:37',NULL),(3902,'Lose Mango bar',9,'single',19,516,3,NULL,NULL,'exclusive',0,0,1,1,'00001234','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-11 16:25:14','2020-02-11 16:25:14',NULL),(3903,'Mace (Joyitri) 50gm',9,'single',19,407,66,NULL,NULL,'exclusive',0,0,1,1,'0000012','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-11 16:31:11','2020-02-11 16:31:11',NULL),(3904,'Good day Cappuccino 25gm',9,'single',19,314,16,NULL,NULL,'exclusive',0,0,1,1,'8991002103085','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-11 21:20:48','2020-02-11 21:20:48',NULL),(3905,'Heinz Fruity banana Yogurt (4+ month)',9,'single',19,13,64,NULL,NULL,'exclusive',0,0,1,1,'5000157142917','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-11 21:45:06','2020-02-11 21:45:06',NULL),(3906,'Cartoon  Lollipop Tom & Jerry 55gm',9,'single',19,434,57,NULL,NULL,'exclusive',0,0,1,1,'6939501808256','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-11 21:55:51','2020-02-11 21:55:51',NULL),(3907,'Huggies Wonder Pants S-42',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009616724','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:03:28','2020-02-15 17:03:28',NULL),(3908,'Huggies Wonder Pants M-38',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009616601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:04:36','2020-02-15 17:04:36',NULL),(3909,'Huggies Wonder Pants L-32',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009616663','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:06:02','2020-02-15 17:06:02',NULL),(3910,'Huggies Wonder Pants XL-28',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009616748','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:06:50','2020-02-15 17:06:50',NULL),(3911,'Huggies Wonder Pants XXL-24',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009616762','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:08:30','2020-02-15 17:08:30',NULL),(3912,'Huggies Wonder Pants M-54',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617851','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:10:09','2020-02-15 17:10:09',NULL),(3913,'Huggies Wonder Pants L-46',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617882','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:11:56','2020-02-15 17:11:56',NULL),(3914,'Huggies Wonder Pants XL-38',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617868','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:13:12','2020-02-15 17:13:12',NULL),(3915,'Huggies Wonder Pants S-76',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617134','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:14:50','2020-09-18 21:29:20',NULL),(3916,'Huggies Wonder Pants M-72',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617059','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:15:43','2020-02-15 17:15:43',NULL),(3917,'Huggies Wonder Pants L-60',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617073','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:16:57','2020-09-18 21:30:09',NULL),(3918,'Huggies Wonder Pants XL-54',9,'single',19,210,68,NULL,NULL,'exclusive',0,0,1,1,'8904009617066','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-15 17:18:16','2020-02-15 17:18:16',NULL),(3919,'Pedia Sure Complete Milk Chocolate  900gm',9,'single',19,184,64,NULL,NULL,'exclusive',0,0,1,1,'8886451085191','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 13:46:27','2020-02-17 13:46:27',NULL),(3920,'Nestle kitKat House Box Disnep 408gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'8888082151368','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 13:50:34','2020-02-17 13:50:34',NULL),(3921,'Nastle Kitkat Compass 130gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'8888082151405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 13:55:26','2020-02-17 13:55:26',NULL),(3922,'Nescafe Ipoh White Coffee (15X31)gm',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'9556001234223','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 14:20:52','2020-02-17 14:20:52',NULL),(3923,'Nescafe Ipoh White Coffee Hazelnut (15X33)gm',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'9556001245564','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 14:23:20','2020-02-17 14:23:20',NULL),(3924,'Nescafe Ipoh White Coffee Orginal (15X36)gm',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'9556001183149','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 15:14:49','2020-02-17 15:14:49',NULL),(3925,'Erko Mallow Plus Stick (20X12)gm',9,'single',19,517,22,NULL,NULL,'exclusive',0,0,1,1,'6925925027557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 16:57:40','2020-02-17 16:57:40',NULL),(3926,'gfhjghg',9,'single',19,2,1,NULL,NULL,'exclusive',0,0,1,1,'3926','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-17 20:18:25','2020-02-17 20:18:25',NULL),(3927,'cadburry dairy milk silk heart pop',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'8901233033501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-17 21:54:17','2020-02-17 21:54:17',NULL),(3930,'Cadbury Dairy Milk Roast Almond 58gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'8901233031484','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-18 21:02:26','2020-02-18 21:02:26',NULL),(3931,'capzer coffee whey protein isolate  542gm',9,'single',19,348,16,NULL,NULL,'exclusive',0,0,1,1,'604286975375','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-20 23:26:45','2020-09-08 16:32:42',NULL),(3932,'kurkure  chilli chatka 45gm',9,'single',19,340,44,NULL,NULL,'exclusive',0,0,1,1,'8901491366595','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-21 16:27:16','2020-02-21 16:27:16',NULL),(3933,'kurkure masala munch  45gm',9,'single',19,340,44,NULL,NULL,'exclusive',0,0,1,1,'8901491366557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-21 16:29:43','2020-10-24 15:08:40',NULL),(3934,'kurkure spanish tomato tango flavour 45gm',9,'single',19,340,44,NULL,NULL,'exclusive',0,0,1,1,'710535945690','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-21 16:31:43','2020-02-21 16:31:43',NULL),(3935,'kurkure  american style cream & onion 45gm',9,'single',19,340,44,NULL,NULL,'exclusive',0,0,1,1,'8901491368070','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-21 16:33:46','2020-02-21 16:33:46',NULL),(3936,'Molfix Diapers Mini 3-6 kg(80 pcs)',9,'single',19,203,68,NULL,NULL,'exclusive',0,0,1,1,'8690536814466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-22 15:12:17','2020-02-22 15:12:17',NULL),(3937,'Joly Adultes Diapers Medium 30pc',9,'single',19,270,68,NULL,NULL,'exclusive',0,0,1,1,'8690536804016','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-22 15:22:08','2020-02-22 15:22:08',NULL),(3938,'Pretzo Orginal 32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200840','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 15:57:25','2020-02-27 15:57:25',NULL),(3939,'Pretzo Orginal Tomato  32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200192','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 15:58:47','2020-02-27 15:58:47',NULL),(3940,'Pretzo Sticks  32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200734','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:00:31','2020-02-27 16:00:31',NULL),(3941,'Pretzo Cheese 32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200062','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:02:40','2020-02-27 16:02:40',NULL),(3942,'Pretzo Sticks Tomato 32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200710','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:03:39','2020-02-27 16:03:39',NULL),(3943,'Pretzo Orginal Salt 32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:04:35','2020-02-27 16:04:35',NULL),(3944,'Pretzo Sticks Salt  32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200741','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:06:30','2020-02-27 16:06:30',NULL),(3945,'Munchos Cheese 32gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200802','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:07:31','2020-02-27 16:07:31',NULL),(3946,'Pretzo Sticks Tomato 80gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200765','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:08:57','2020-02-27 16:08:57',NULL),(3947,'Pretzo Mixy Salt  80gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200055','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:10:47','2020-02-27 16:10:47',NULL),(3948,'Pretzo Mixy Chili   80gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200550','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:11:42','2020-02-27 16:11:42',NULL),(3949,'Pretzels Mixy Baked   190gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200208','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:13:49','2020-02-27 16:13:49',NULL),(3950,'Pretzels Mixy Baked  Ketchup 190gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200451','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:14:51','2020-02-27 16:14:51',NULL),(3951,'Pretzels Mixy Baked Cheese 190gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200680','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:19:24','2020-02-27 16:19:24',NULL),(3952,'Pretzels Mixy Baked  Cheese low fat 190gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200246','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:21:41','2020-02-27 16:21:41',NULL),(3953,'Pretzo Mini Sticks Salt 190gm',9,'single',19,22,14,NULL,NULL,'exclusive',0,0,1,1,'6223001200673','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-27 16:23:50','2020-02-27 16:23:50',NULL),(3954,'Zeeba Gold Basmati Rice 1kg',9,'single',19,395,54,NULL,NULL,'exclusive',0,0,1,1,'000002369','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-02-28 00:25:34','2020-02-28 00:25:34',NULL),(3955,'Cadburry dairy Milk 119gm',9,'single',19,129,15,NULL,NULL,'exclusive',0,0,1,1,'7622210286956','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 02:09:55','2020-02-28 19:43:57',NULL),(3956,'M&M 107gm',9,'single',19,127,15,NULL,NULL,'exclusive',0,0,1,1,'5000159520218','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 02:11:58','2020-03-09 20:33:32',NULL),(3957,'Milkybar 4bars',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'7613033487002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 02:14:52','2020-02-28 02:14:52',NULL),(3958,'cadburry bourn vita biscuits',9,'single',19,129,5,NULL,NULL,'exclusive',0,0,1,1,'8901233034423','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 16:44:32','2020-02-28 16:44:32',NULL),(3959,'Kinder Chocolate',9,'single',19,69,15,NULL,NULL,'exclusive',0,0,1,1,'4008400204727','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:06:19','2020-02-28 19:06:19',NULL),(3960,'Snuckers 166.8gm',9,'single',19,120,15,NULL,NULL,'exclusive',0,0,1,1,'5000159484480','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:07:23','2020-02-28 19:07:23',NULL),(3961,'FinCarre Fruit & Nut Chocolate 100g',9,'single',19,421,15,NULL,NULL,'exclusive',0,0,1,1,'20449100','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:09:47','2020-02-28 19:09:47',NULL),(3962,'Lovetts Dark 100gm',9,'single',19,421,15,NULL,NULL,'exclusive',0,0,1,1,'01145908','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:10:55','2020-02-28 19:10:55',NULL),(3963,'Simply Dark Chocolate 100gm',9,'single',19,421,15,NULL,NULL,'exclusive',0,0,1,1,'20013189','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:12:02','2020-02-28 19:12:02',NULL),(3964,'Kinder Chocolate 5bars',9,'single',19,69,15,NULL,NULL,'exclusive',0,0,1,1,'4008400221328','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:13:06','2020-02-28 19:13:06',NULL),(3965,'Nestle Kitkat Cookis  9 pack',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'7613036099349','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:14:50','2020-02-28 19:14:50',NULL),(3966,'Kitkat Lemon Dark Mint 9 Bars',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'7613036099363','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37,NULL,'2020-02-28 19:16:13','2020-02-28 19:16:13',NULL),(3967,'Well Food Special Chanachur  200gm',9,'single',19,348,79,NULL,NULL,'exclusive',0,0,1,1,'069655874855','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-01 17:55:14','2020-03-01 17:55:14',NULL),(3968,'Well Food Lachaha Shemai 400gm',9,'single',19,348,72,NULL,NULL,'exclusive',0,0,1,1,'65089446','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-01 18:00:41','2020-03-01 18:00:41',NULL),(3969,'Riocoffee Almond mocha Cookies 200gm',9,'single',19,451,18,NULL,NULL,'exclusive',0,0,1,1,'2544574007419','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-01 18:03:14','2020-03-01 18:03:14',NULL),(3970,'Riocoffee Biscotti 250gm',9,'single',19,451,5,NULL,NULL,'exclusive',0,0,1,1,'2544574064412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-01 18:05:09','2020-03-01 18:05:09',NULL),(3971,'Riocoffee Brownie cookies  200gm',9,'single',19,451,18,NULL,NULL,'exclusive',0,0,1,1,'2544574066980','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-01 18:06:56','2020-03-01 18:06:56',NULL),(3972,'Riocoffee Almond Choco fill Cookies 200gm',9,'single',19,451,18,NULL,NULL,'exclusive',0,0,1,1,'826587653220','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-01 18:10:02','2020-03-01 18:10:02',NULL),(3973,'Alach Chinabadam 150gm',9,'single',19,448,53,NULL,NULL,'exclusive',0,0,1,1,'235236','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:15:27','2020-09-29 17:21:35',NULL),(3974,'Vedan Salt 454gm',9,'single',19,407,80,NULL,NULL,'exclusive',0,0,1,1,'4710110921015','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:35:39','2020-03-03 00:35:39',NULL),(3975,'Vedan Salt 100gm',9,'single',19,407,80,NULL,NULL,'exclusive',0,0,1,1,'ved12358','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:37:44','2020-03-03 00:37:44',NULL),(3976,'Vedan Salt 50gm',9,'single',19,407,80,NULL,NULL,'exclusive',0,0,1,1,'vedan8567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:40:34','2020-03-03 00:40:34',NULL),(3977,'MK Raisin (Kishmish) 500gm',9,'single',19,407,50,NULL,NULL,'exclusive',0,0,1,1,'mk22233','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:43:45','2020-03-03 00:43:45',NULL),(3978,'MK Raisin (Kishmish) 300gm',9,'single',19,407,50,NULL,NULL,'exclusive',0,0,1,1,'mk222334','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:47:01','2020-03-03 00:47:01',NULL),(3979,'MK Raisin (Kishmish) 150gm',9,'single',19,407,50,NULL,NULL,'exclusive',0,0,1,1,'mk222335','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:48:37','2020-03-03 00:48:37',NULL),(3980,'Ispaghula Husk (Isapgul) 200gm Ls',9,'single',19,407,50,NULL,NULL,'exclusive',0,0,1,1,'sl120415','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:51:37','2020-03-03 00:51:37',NULL),(3981,'Ispaghula Husk (Isapgul) 100gm Ls',9,'single',19,407,50,NULL,NULL,'exclusive',0,0,1,1,'sl120416','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 00:52:50','2020-03-03 00:52:50',NULL),(3982,'Badiee Saffron 1gr',9,'single',19,407,66,NULL,NULL,'exclusive',0,0,1,1,'6260485000573','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-03 20:22:08','2020-03-03 20:22:08',NULL),(3983,'Lindt Excellence Extra Creamy Milk 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',0,0,1,1,'3046920011013','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 14:23:04','2020-03-04 14:23:04',NULL),(3984,'Lindt Excellence Chilli 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',0,0,1,1,'7610400070577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 14:26:09','2020-03-04 14:26:09',NULL),(3985,'Lindt Excellence Caramel Dark 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',0,0,1,1,'3046920027281','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 14:28:45','2020-03-04 14:28:45',NULL),(3986,'Lindt Excellence Cranb,Almond & Hazel Dark 100gm',9,'single',19,214,15,NULL,NULL,'exclusive',0,0,1,1,'3046920090018','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 14:32:20','2020-03-04 14:32:20',NULL),(3987,'Heinz so Yummy Carrot & Tomato ring puffs 4X15gm',9,'single',19,13,64,NULL,NULL,'exclusive',0,0,1,1,'5000157079336','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 15:02:16','2020-03-04 16:39:10',NULL),(3988,'Heinz so Yummy Sweetcorn ring puffs 4X15gm',9,'single',19,NULL,59,NULL,NULL,'exclusive',0,0,1,1,'5000157140371','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:40:43','2020-03-04 16:40:43',NULL),(3989,'Kinder Bueno 215gm',9,'single',19,69,15,NULL,NULL,'exclusive',0,0,1,1,'5020411113439','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:42:32','2020-03-04 16:42:32',NULL),(3990,'Balconi Choco Orange 350gm',9,'single',19,69,15,NULL,NULL,'exclusive',0,0,1,1,'8001585001088','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:43:51','2020-03-04 16:43:51',NULL),(3991,'M&S Rice Tea 300gm',9,'single',19,440,5,NULL,NULL,'exclusive',0,0,1,1,'00741316','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:48:11','2020-03-04 16:48:11',NULL),(3992,'Nescaffe 3in  102gm',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'7613036033480','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:49:28','2020-03-04 16:49:28',NULL),(3993,'Nescaffe Orginal 2 in 1 60GM',9,'single',19,138,16,NULL,NULL,'exclusive',0,0,1,1,'7613036033466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:50:52','2020-03-04 16:50:52',NULL),(3994,'Sondey White Chocolate Cookies 210gm',9,'single',19,357,5,NULL,NULL,'exclusive',0,0,1,1,'20301804','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:54:59','2020-03-04 16:54:59',NULL),(3995,'Sondey White Blueberry Cookies 210gm',9,'single',19,357,5,NULL,NULL,'exclusive',0,0,1,1,'40895321','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:57:28','2020-03-04 16:57:28',NULL),(3996,'Sondey White Triple Cookies 210gm',9,'single',19,357,5,NULL,NULL,'exclusive',0,0,1,1,'20927103','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:58:24','2020-03-04 16:58:24',NULL),(3997,'Sondey White Canberry  Cookies 210gm',9,'single',19,357,5,NULL,NULL,'exclusive',0,0,1,1,'20452728','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 16:59:14','2020-03-04 16:59:14',NULL),(3998,'M&S Luxury Gold 50 Teabags',9,'single',19,440,16,NULL,NULL,'exclusive',0,0,1,1,'00730792','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 17:00:31','2020-03-04 17:00:31',NULL),(3999,'Shan Himalayan Salt Pink 800gm',9,'single',19,231,80,NULL,NULL,'exclusive',0,0,1,1,'788821002365','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 17:01:56','2020-03-04 17:01:56',NULL),(4000,'Nescaffe Orginal Low fat Drinks 240ml',9,'single',19,138,34,NULL,NULL,'exclusive',0,0,1,1,'9556001047175','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:15:41','2020-03-04 17:15:41',NULL),(4001,'Lipton Lemon 300ml',9,'single',19,63,34,NULL,NULL,'exclusive',0,0,1,1,'9556404049035','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:18:21','2020-03-04 17:18:21',NULL),(4002,'A&W Saraaparilla 320ml',9,'single',19,63,34,NULL,NULL,'exclusive',0,0,1,1,'9555589200002','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:20:38','2020-03-04 17:20:38',NULL),(4003,'Tang Orange 2.04kg USA',9,'single',19,321,52,NULL,NULL,'exclusive',0,0,1,1,'043000032268','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:24:20','2020-09-08 16:15:15',NULL),(4004,'Foodex Tuong Ot sriracha 482gm',9,'single',19,171,32,NULL,NULL,'exclusive',0,0,1,1,'8852045203722','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:26:00','2020-03-04 17:26:00',NULL),(4005,'Samyang Hot 2X SpicyChicken Ramen 140gm',9,'single',19,279,27,NULL,NULL,'exclusive',0,0,1,1,'8801073113428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:34:07','2020-11-03 01:12:45',NULL),(4006,'Samyang Ramen Kimchi 140gm',9,'single',19,279,NULL,NULL,NULL,'exclusive',0,0,1,1,'074603003287','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:37:49','2020-03-04 17:37:49',NULL),(4007,'Werthers Original 110gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'4014400908947','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:41:20','2020-03-04 17:41:20',NULL),(4008,'Werthers Original Creamy 110gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'4014400912746','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:42:14','2020-03-04 17:42:14',NULL),(4009,'Werthers Original Soft Caramels 110gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'4014400923032','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:43:09','2020-03-04 17:43:09',NULL),(4010,'Werthers Original Butter Mints 110gm',9,'single',19,63,15,NULL,NULL,'exclusive',0,0,1,1,'4014400916676','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:43:52','2020-03-04 17:43:52',NULL),(4011,'Paone pasta Panne 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455006303','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 17:56:57','2020-03-04 17:56:57',NULL),(4012,'Wrigleys Eclipse Mints 35gm',9,'single',19,168,22,NULL,NULL,'exclusive',0,0,1,1,'9555192506218','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:01:40','2020-03-04 20:01:40',NULL),(4013,'Wrigleys DoubleMints Spearmint 69.6g',9,'single',19,130,22,NULL,NULL,'exclusive',0,0,1,1,'9555192502616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:04:46','2020-03-04 20:04:46',NULL),(4014,'Wrigleys DoubleMint Cool 69.6g',9,'single',19,130,22,NULL,NULL,'exclusive',0,0,1,1,'9555192502630','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:06:36','2020-03-04 20:06:36',NULL),(4015,'Extra Gun Peppermint 56gm',9,'single',19,478,22,NULL,NULL,'exclusive',0,0,1,1,'9555192503996','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:09:08','2020-03-04 20:09:08',NULL),(4016,'Toblerone Tiny 200gm',9,'single',19,116,15,NULL,NULL,'exclusive',0,0,1,1,'7622210414151','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:11:30','2020-03-04 20:11:30',NULL),(4017,'Hide Seek Choco Rolls 120gm',9,'single',19,383,5,NULL,NULL,'exclusive',0,0,1,1,'8901719103896','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:14:24','2020-03-04 20:14:24',NULL),(4018,'Hide Seek Choco Rolls 75gm',9,'single',19,383,5,NULL,NULL,'exclusive',0,0,1,1,'8901719115417','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:15:15','2020-03-04 20:15:15',NULL),(4019,'Milano Chip Cookies 75gm',9,'single',19,383,5,NULL,NULL,'exclusive',0,0,1,1,'8901719115400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:16:58','2020-03-04 20:16:58',NULL),(4020,'Cowhead Durian oat butter Cookies 150g',9,'single',19,84,5,NULL,NULL,'exclusive',0,0,1,1,'8888440009362','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:49:04','2020-03-04 20:49:04',NULL),(4021,'Cowhead Crispy Cheese 320g',9,'single',19,84,5,NULL,NULL,'exclusive',0,0,1,1,'8888440011136','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:52:33','2020-03-04 20:52:33',NULL),(4022,'Cowhead Crispy Chocolate 320g',9,'single',19,84,5,NULL,NULL,'exclusive',0,0,1,1,'8888440011143','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:56:25','2020-03-04 20:56:25',NULL),(4023,'Cowhead Croissants  Strawberry  300mg',9,'single',19,84,73,NULL,NULL,'exclusive',0,0,1,1,'8888440011204','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:58:47','2020-03-04 20:58:47',NULL),(4024,'Cowhead Croissants  Milk Cream  300mg',9,'single',19,84,73,NULL,NULL,'exclusive',0,0,1,1,'8888440011228','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 20:59:25','2020-03-04 20:59:25',NULL),(4025,'Cowhead Croissants  Chocolate   300mg',9,'single',19,84,73,NULL,NULL,'exclusive',0,0,1,1,'8888440011334','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:00:20','2020-03-04 21:00:20',NULL),(4026,'Cowhead Croissants  Apricot  300mg',9,'single',19,84,73,NULL,NULL,'exclusive',0,0,1,1,'8888440011211','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:01:39','2020-03-04 21:01:39',NULL),(4027,'Cowhead Crepes Cheese 96gm',9,'single',19,84,5,NULL,NULL,'exclusive',0,0,1,1,'8888440011150','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:05:17','2020-03-04 21:05:17',NULL),(4028,'Cowhead Yogurt Drink Strawberry 200ml',9,'single',19,84,26,NULL,NULL,'exclusive',0,0,1,1,'8888440011358','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:10:25','2020-03-04 21:10:25',NULL),(4029,'Cowhead Yogurt Drink Blueberry 200ml',9,'single',19,84,26,NULL,NULL,'exclusive',0,0,1,1,'8888440009348','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:11:23','2020-03-04 21:11:23',NULL),(4030,'Cowhead Yogurt Drink Original  200ml',9,'single',19,84,26,NULL,NULL,'exclusive',0,0,1,1,'8888440011341','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:12:18','2020-03-04 21:12:18',NULL),(4031,'Cowhead Milk Pure 200ml',9,'single',19,84,26,NULL,NULL,'exclusive',0,0,1,1,'8888440001731','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:13:17','2020-03-04 21:13:17',NULL),(4032,'Cowhead Milk Lowfat  200ml',9,'single',19,84,26,NULL,NULL,'exclusive',0,0,1,1,'8888440005951','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:14:06','2020-03-04 21:14:06',NULL),(4033,'Vitalia Crunchy Muesli with Honey & Almonds  350gm',9,'single',19,1,1,NULL,NULL,'exclusive',0,0,1,1,'5310099015867','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:26:47','2020-03-04 21:26:47',NULL),(4034,'Nutella 750gm',9,'single',19,132,6,NULL,NULL,'exclusive',0,0,1,1,'80176800','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:33:51','2020-03-04 21:33:51',NULL),(4035,'Aloevine Aloe 1.5ltr',9,'single',19,445,34,NULL,NULL,'exclusive',0,0,1,1,'896650001623','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:41:04','2020-03-04 21:41:04',NULL),(4036,'Tayas Damla Center Filled 600gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997155771','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:46:23','2020-03-04 21:46:23',NULL),(4037,'Tayas Cheesecake 300gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997184573','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:47:17','2020-03-04 21:47:17',NULL),(4038,'Tayas Tuvana 1000gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997114471','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:49:33','2020-03-04 21:49:33',NULL),(4039,'Julis Cheese Sandwich 125gm',9,'single',19,59,5,NULL,NULL,'exclusive',0,0,1,1,'9556121024025','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:52:14','2020-03-04 21:52:14',NULL),(4040,'Tayas Jess 350gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997115812','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 21:59:38','2020-03-04 21:59:38',NULL),(4041,'Paone Tortiglioni Pasta 500gm',9,'single',19,479,30,NULL,NULL,'exclusive',0,0,1,1,'8008455666907','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-04 21:59:47','2020-03-04 21:59:47',NULL),(4042,'Tayas magic 80gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997021991','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:00:58','2020-03-04 22:00:58',NULL),(4043,'Tayas Multi Fruit 170gm',9,'single',19,398,7,NULL,NULL,'exclusive',0,0,1,1,'8690997167101','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:02:40','2020-03-04 22:02:40',NULL),(4044,'Tayas Harmony 325gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997110503','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:03:46','2020-03-04 22:03:46',NULL),(4045,'Tayas Multi Fruit 1kg',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997167071','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:06:00','2020-03-04 22:06:00',NULL),(4046,'Tayas Orient Strawberry 265gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997112989','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:08:02','2020-03-04 22:08:02',NULL),(4047,'Tayas Orient Hazelnut  265gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997112972','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:08:57','2020-03-04 22:08:57',NULL),(4048,'Tayas Orient Hazelnut 250gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997113498','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:10:06','2020-03-04 22:10:06',NULL),(4049,'Tayas Orient Strawberry 250gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997134394','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:11:32','2020-03-04 22:11:32',NULL),(4050,'Tayas Tuvana 600gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997114464','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:14:24','2020-03-04 22:14:24',NULL),(4051,'Tayas Love Hazelnut 400gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997117281','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:15:33','2020-03-04 22:15:33',NULL),(4052,'Tayas Shadow 350gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997115850','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:16:25','2020-03-04 22:16:25',NULL),(4053,'Tayas Damla 300gm',9,'single',19,398,15,NULL,NULL,'exclusive',0,0,1,1,'8690997176110','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:17:34','2020-03-04 22:17:34',NULL),(4054,'Post Oreo 500gm',9,'single',19,128,21,NULL,NULL,'exclusive',0,0,1,1,'8801037065626','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:39:49','2020-03-04 22:39:49',NULL),(4055,'Post Oreo 250gm',9,'single',19,128,21,NULL,NULL,'exclusive',0,0,1,1,'8801037065619','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:40:52','2020-03-04 22:40:52',NULL),(4056,'Darda Creamy Pop Corn 65gm',9,'single',19,448,58,NULL,NULL,'exclusive',0,0,1,1,'8809027555287','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:42:33','2020-03-04 22:42:33',NULL),(4057,'Hosan Aloe Vera Original 500Ml',9,'single',19,445,34,NULL,NULL,'exclusive',0,0,1,1,'8809059291986','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:45:00','2020-03-04 22:45:00',NULL),(4058,'Pocari Sweat 245ml',9,'single',19,6,34,NULL,NULL,'exclusive',0,0,1,1,'8801097150010','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:46:09','2020-03-04 22:46:09',NULL),(4059,'Oreo Chocolate 100gm',9,'single',19,87,5,NULL,NULL,'exclusive',0,0,1,1,'8801037088205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:47:17','2020-03-04 22:47:17',NULL),(4060,'Oreo Chocolate Sandwich 100gm',9,'single',19,87,5,NULL,NULL,'exclusive',0,0,1,1,'8801037088168','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:48:12','2020-03-04 22:48:12',NULL),(4061,'Oreo Strawberry 300gm',9,'single',19,87,5,NULL,NULL,'exclusive',0,0,1,1,'8801037088267','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:49:10','2020-03-04 22:49:10',NULL),(4062,'Oreo Chocolate Sandwich 300gm',9,'single',19,87,5,NULL,NULL,'exclusive',0,0,1,1,'8801037088182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:49:59','2020-03-04 22:49:59',NULL),(4063,'Oreo Chocolate 300gm',9,'single',19,87,5,NULL,NULL,'exclusive',0,0,1,1,'8801037088229','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:52:55','2020-03-04 22:52:55',NULL),(4064,'Capri- Sun Orange Juice 200ml',9,'single',19,446,24,NULL,NULL,'exclusive',0,0,1,1,'8801043650182','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:55:18','2020-03-04 22:55:18',NULL),(4065,'Capri- Sun Safari Juice 200m',9,'single',19,446,24,NULL,NULL,'exclusive',0,0,1,1,'8801043650199','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:56:16','2020-03-04 22:56:16',NULL),(4066,'Capri- Sun Apple Juice 200m',9,'single',19,446,24,NULL,NULL,'exclusive',0,0,1,1,'8801043650700','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:57:07','2020-03-04 22:57:07',NULL),(4067,'Capri- Sun Alasa Ice Tea Juice 200ml',9,'single',19,446,24,NULL,NULL,'exclusive',0,0,1,1,'8801043650205','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 22:58:23','2020-03-04 22:58:23',NULL),(4068,'Strabucks Frappuccino Caramel 281ml',9,'single',19,472,34,NULL,NULL,'exclusive',0,0,1,1,'8801037086201','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 23:01:22','2020-03-04 23:01:22',NULL),(4069,'Strabucks Frappuccino Coffee 281ml',9,'single',19,441,34,NULL,NULL,'exclusive',0,0,1,1,'8801037026122','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2020-03-04 23:02:28','2020-03-04 23:02:28',NULL),(4070,'Nestle Nido FortiGrow Full Cream Milk Tin 900gm',9,'single',19,63,26,NULL,NULL,'exclusive',0,0,1,1,'8717896007007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-07 20:04:52','2020-03-07 20:04:52',NULL),(4071,'Nestle Nido FortiGrow Full Cream Milk Tin 900gm',9,'single',19,63,26,NULL,NULL,'exclusive',0,0,1,1,'8717896007007','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-07 20:04:53','2020-03-07 20:04:53',NULL),(4072,'Zandu Pure Haney 500gm',9,'single',19,287,56,NULL,NULL,'exclusive',0,0,1,1,'8901248749039','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-09 17:33:10','2020-03-09 17:33:10',NULL),(4073,'Kelloggs Oats 500gm',9,'single',19,128,28,NULL,NULL,'exclusive',0,0,1,1,'8901499010292','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-09 19:33:01','2020-03-09 19:33:01',NULL),(4074,'Almarai Cheese Slice Sandwich  200gm',9,'single',19,254,13,NULL,NULL,'exclusive',0,0,1,1,'6281007169202','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-09 20:11:12','2020-09-17 17:27:45',NULL),(4075,'Almarai Cheese Slice Cheddar 200gm',9,'single',19,254,13,NULL,NULL,'exclusive',0,0,1,1,'6281007026420','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-09 20:12:51','2020-03-09 20:12:51',NULL),(4076,'M&M Peanut 107gm',9,'single',19,127,15,NULL,NULL,'exclusive',0,0,1,1,'5000159472531','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-09 20:27:44','2020-03-09 20:27:44',NULL),(4077,'test12',9,'single',19,NULL,NULL,NULL,NULL,'exclusive',0,0,1,2,'4077','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-11 17:42:22','2020-03-11 17:42:22',NULL),(4078,'Avonee Pants M40',9,'single',19,225,68,NULL,NULL,'exclusive',0,0,1,1,'8941133201020','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38,NULL,'2020-03-11 