
<?php $__env->startSection('title', __( 'Supplier Product Sell' )); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>SUPPLIER WISE STOCK SUMMERY</h>
</section>
<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12 no-print">
           <form>
              <div class="col-md-4">
                  <div class="form-group">
                     <label>Supplier</label>
                     <select class="form-control" name="supplier_id" onchange="this.form.submit()">
                         <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <option value="<?php echo e($key); ?>" <?php echo e(request()->supplier_id==$key ?'selected':''); ?>><?php echo e($item); ?></option>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </select>
                  </div>
              </div>

              <div class="col-md-2">
                  <a onclick="window.print();" class="btn btn-xs btn-info" style="margin-top:26px"><i class="fa fa-print"></i></a>
                  <a class="btn btn-xs btn-info" style="margin-top:26px" id="excel"><i class="fa fa-download"></i></a>
              </div>
           </form>
       </div>
       <div class="col-md-12">
           <div class="box box-solid">
               <div class="table">
                    <table class="table table-bordered table-striped text-center">
                        <tr>
                            <th>Supplier Name</th>
                            <th colspan="2">Received</th>
                            <th colspan="2">Stock Return</th>
                            <th colspan="2">Sold</th>
                            <th colspan="2">Exchange /Void</th>
                            <th colspan="2">Balance</th>

                        </tr>

                        <tr>
                            <th></th>
                            <th>Qty</th>
                            <th>Value(Cost)</th>

                            <th>Qty</th>
                            <th>Value(Cost)</th>

                            <th>Qty</th>
                            <th>Value(Cost)</th>

                            <th>Qty</th>
                            <th>Value(Cost)</th>

                            <th>Qty</th>
                            <th>Value(Cost)</th>

                        </tr>
                        
                        <tbody>
                            <?php
                            $return_price=0;
                            $purchase_price=0;
                            $sell_price=0;
                            $remain_price=0;
                            $remain_stock=0;
                            ?>
                            <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                            <?php
                            $stock =$result->purchase_qty - $result->sell_qty;
                            $purchase_price +=$result->purchase_qty * $result->default_purchase_price;
                            $sell_price +=$result->sell_qty * $result->sell_price_inc_tax;
                            $remain_stock +=$stock;
                            $remain_price +=$stock * $result->default_purchase_price;
                            $return_price +=$result->qty_returned * $result->default_purchase_price;
                            ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($sup); ?></td>
                                <td><?php echo e(number_format($results->sum('purchase_qty'),2)); ?></td>
                                <td><?php echo e(number_format($purchase_price,2)); ?></td>
                                <td><?php echo e(number_format($results->sum('qty_returned'),2)); ?></td>
                                <td><?php echo e(number_format($return_price,2)); ?></td>
                                
                                <td><?php echo e(number_format($results->sum('sell_qty'),2)); ?></td>
                                <td><?php echo e(number_format($sell_price,2)); ?></td>
                                <td>0</td>
                                <td>0</td>
                                <td><?php echo e(number_format($remain_stock,2)); ?></td>
                                <td><?php echo e(number_format($remain_price,2)); ?></td>
                            </tr>
                            
                        </tbody>
                        
                    </table>  
                </div>
            </div>
       </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script src="//cdn.rawgit.com/rainabba/jquery-table2excel/1.1.0/dist/jquery.table2excel.min.js"></script>
<script type="text/javascript">
$('#start, #end').datepicker({  format: 'yyyy-mm-dd' });
    $("#excel").click(function () {
        $(".table").table2excel({
            exclude: '.exclude',
            filename: 'stock_summery.xls'
        });
    })
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>