<div class="modal-dialog" role="document">
  <div class="modal-content">

    <?php echo Form::open(['url' => action('UnitController@update', [$unit->id]), 'method' => 'PUT', 'id' => 'unit_edit_form' ]); ?>


    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title"><?php echo e(app('translator')->getFromJson( 'unit.edit_unit' )); ?></h4>
    </div>

    <div class="modal-body">
      <div class="form-group">
        <?php echo Form::label('actual_name', __( 'unit.name' ) . ':*'); ?>

          <?php echo Form::text('actual_name', $unit->actual_name, ['class' => 'form-control', 'required', 'placeholder' => __( 'unit.name' )]);; ?>

      </div>

      <div class="form-group">
        <?php echo Form::label('short_name', __( 'unit.short_name' ) . ':*'); ?>

          <?php echo Form::text('short_name', $unit->short_name, ['class' => 'form-control', 'placeholder' => __( 'unit.short_name' ), 'required']);; ?>

      </div>

      <div class="form-group">
        <?php echo Form::label('allow_decimal', __( 'unit.allow_decimal' ) . ':*'); ?>

          <?php echo Form::select('allow_decimal', ['1' => __('messages.yes'), '0' => __('messages.no')], $unit->allow_decimal, ['placeholder' => __( 'messages.please_select' ), 'required', 'class' => 'form-control']);; ?>

      </div>
      <div class="form-group">
        <?php echo Form::label('child_id', __( 'Parent Unit' )); ?>

        <select name="child_id" id="selectDynamic" class="chosen-select-member form-control"  placeholder="Choose Child Unit...">
            <?php $__currentLoopData = $parent_units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parent_unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($parent_unit->deleted_at ==""): ?>
            <?php if($parent_unit->id == $unit->child_id): ?>
                <option value="<?php echo e($parent_unit->id); ?>" selected> <?php echo e($parent_unit->actual_name); ?></option>
            <?php else: ?>
            <option value="<?php echo e($parent_unit->id); ?>" > <?php echo e($parent_unit->actual_name); ?></option>
            <?php endif; ?>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <option value="0" >None</option>  
          </select>
      </div>
      <div class="form-group"  id='Check' style="display:none";>
        <?php echo Form::label('child_value', __( '? Child = 1 Parent ' ) ); ?>

        <?php echo Form::text('child_value', $unit->child_value, ['class' => 'form-control', 'placeholder' => __( 'unit.name' )]);; ?>

      </div>
    </div>

    <div class="modal-footer">
      <button type="submit" class="btn btn-primary"><?php echo e(app('translator')->getFromJson( 'messages.update' )); ?></button>
      <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(app('translator')->getFromJson( 'messages.close' )); ?></button>
    </div>

    <?php echo Form::close(); ?>


  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog -->
<script>
$(document).ready( function() {
	$('#selectDynamic').change(function(){
		//console.log($(this).val());
		var bal=$(this).val();
		if( bal=="0"){
			$('#Check').hide();
		}
		else{ 
			$('#Check').show();

		}
	});
});
</script>