

<?php $__env->startSection('title', __( 'Give Attendence' )); ?>

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-11">
            
            <div class="panel panel-default">
                <div class="panel-heading">Attendance</div>
                <?php if(session()->has('message')): ?>
    <div class="alert alert-success">
        <?php echo e(session()->get('message')); ?>

    </div>
    <?php endif; ?>
    <?php
    $dt = new DateTime();
    ?>
            <?php if($hrmd): ?>
            <div class="panel-body">
                <h1 class="text-center">Todays Attendence is Given!</h1>
                </div>
            <?php else: ?>
                <div class="panel-body">
                    
                    <form class="form-horizontal" role="form" method="POST" action="<?php echo e(action('HrmAttendenceController@store')); ?>">
                        <?php echo e(csrf_field()); ?>

                        <div class="form-group<?php echo e($errors->has('date') ? ' has-error' : ''); ?>">
                            <label for="date" class="col-md-1 control-label">Date</label>
                            <div class="col-md-11">
                            <!-- <?php echo Form::date('date', null, ['class' => 'form-control', 'placeholder' => __( 'Date' )]);; ?> -->
                            <?php echo Form::text('date', \Carbon::createFromTimestamp(strtotime('now'))->format(session('business.date_format')), ['class' => 'form-control', 'readonly', 'required']);; ?>

                                <?php if($errors->has('date')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('date')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>


                        <table class="table table-hover" id="datatable">
                            <thead>
                                <tr>
                                    <th>Employee ID.</th>
                                    <th>Employee Name</th>
                                    <th>Attendance</th>
                                </tr>
                            </thead>
                            
                            <tbody>
                            <?php $__currentLoopData = $hrma; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                    <td><?php echo e($employee->employee_id); ?></td>
                                    <td><?php echo e($employee->name); ?></td>
                                    <td>
                                      <div class="form-group">
                                        <label class="radio-inline">
                                        <input type="radio" name="status-<?php echo e($employee->id); ?>" value="present"> Present</label>
                                        <label class="radio-inline">
                                        <input type="radio" name="status-<?php echo e($employee->id); ?>" value="absent"> Absent
                                        </label>
                                    </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <div class="form-group">
                            <div class="col-md-4 col-md-offset-4">
                                <button type="submit" class="btn btn-primary btn-block">
                                    Save
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<link href="<?php echo e(asset('css/jquery.dataTables.min.css')); ?>" rel="stylesheet">
<script src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>"></script>
<script type="text/javascript">
$(document).ready(function() {

    window.datatable = $('#datatable').DataTable( {
        data: [],
        columns: [
            { title: "Employee Id." },
            { title: "Employee Name" },
            { title: "Attendance" }
        ]
    });
    function load_data() {
        $.ajax({
            url: '/hrm_employees',
            dataType: 'json',
            headers: {'X-CSRF-TOKEN': window.Laravel.csrfToken },
            type: 'GET',
            data: filter_data,
            success: function(data) {
                compile_datatable(data);
            }
        });
    }

    function compile_datatable(students) {
        var compiled = [];
        // console.log('students', students);
        datatable.clear();
        $.each(students, function(index, value) {
            // console.log(compiled);
            datatable.row.add([
                value.email,
                value.first_name,
                value.last_name,
                '<div class="form-group">'+
                    '<label class="radio-inline">'+
                        '<input type="radio" name="'+value.id+'" value="1"> Present'+
                    '</label>'+
                    '<label class="radio-inline">'+
                        '<input type="radio" name="'+value.id+'" value="0"> Absent'+
                    '</label>'+
                '</div>'
            ]).draw();
        })
    }

});
</script>
  <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>