<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Q7BD-<?php echo $__env->yieldContent('title'); ?></title>
    <meta name="keywords" content="HTML5 Template">
    <meta name="description" content="Molla - Bootstrap eCommerce Template">
    <meta name="author" content="p-themes">
    <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="180x180" href="assets/images/icons/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="assets/images/icons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="assets/images/icons/favicon-16x16.png">
    <?php echo $__env->make('front.includes.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .header-bottom .menu>li>a {
        padding: 1.65rem 0rem!important;
    }
    .header-bottom .menu>li>.sf-with-ul {
        padding-right: 11px!important;
    }
    #searchResults{
        display: none;
        position: absolute;
        top: 69px;
        background: #fff;
        width: 47%;
        z-index: 999;
        padding: 5px 32px;
        color: #000;
    }
    a{
        color: #000;
    }
    a:hover{
        color: #000;
    }
    .social-iconsaz {
    position: fixed;
    bottom: 40%; /* Adjust as needed */
    right: 5px; /* Adjust as needed */
}

.social-iconsaz a {
    display: inline-block;
    margin-right: 10px; /* Adjust as needed */
    font-size: 24px;
    color: #000; /* Adjust icon color as needed */
}

.social-iconsaz a:hover {
    color: #007bff; /* Adjust hover color as needed */
}
    <?php echo $__env->yieldContent('css'); ?>
</head>

<body>
    <div class="page-wrapper">
        <?php echo $__env->make('front.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('body'); ?>

        <?php echo $__env->make('front.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('front.includes.mobie-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('front.includes.js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js" integrity="sha512-VEd+nq25CkR676O+pLBnDW09R7VQX9Mdiij052gVCp5yVH3jGtH70Ho/UUv4mJDsEdTvqRCFZg0NKGiojGnUCw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<?php if(Session::has('success')): ?>
    <script>
        toastr.success("<?php echo e(Session::get('success')); ?>");
    </script>
    <?php echo e(Session::forget('success')); ?>

<?php endif; ?>

<?php if(Session::has('error')): ?>
    <script>
        toastr.error("<?php echo e(Session::get('error')); ?>");
    </script>
    <?php echo e(Session::forget('error')); ?>

<?php endif; ?>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
</script>
<script>
    $('#searchInput').on('keyup', function() {
        var query = $(this).val();
        if (query.length >= 3) {
            $.ajax({
                url: "<?php echo e(route('search')); ?>",
                type: "POST",
                data: {
                    query: query,
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(response) {
                    $('#searchResults').empty();
                    if (response.length > 0) {
                        console.log(response.length);
                        let data = '';
                        data = '<ul>';
                            let productDetailRoute = '<?php echo e(route('product.detail', ['id' => 'placeholder'])); ?>';
                            $.each(response, function(key, value) {
                                let url = productDetailRoute.replace('placeholder', value.id);
                                let data = '<li style="list-style:none;">';
                                data += '<a href="' + url + '">';
                                data += '<div class="row">';
                                data += '<span>';
                                    data += '<img src="<?php echo e(asset('')); ?>' + value.image + '" width="50" height="50">';
                                data += '</span>';
                                data += '<div class="col-md-9">';
                                    data += '<h6 clas="m-0" style="margin: 0px;">' + value.name + '</h6>';
                                    data += '<p>' + value.sale_price + '৳</p>';
                                data += '</div>';
                                data += '</div>';
                                data += '</a>';
                                data += '</li>';
                                $('#searchResults').append(data);
                            });
                        data += '</ul>';
                        $('#searchResults').append(data);
                        $('#searchResults').css('display', 'block');
                    } else {
                        $('#searchResults').css('display', 'none');
                    }
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
        } else {
            $('#searchResults').empty().css('display', 'none');
        }
    });
</script>
<?php echo $__env->yieldContent('js'); ?>
</body>


</html>



<?php /**PATH C:\laragon\www\q7bd\q7bd\resources\views/front/master.blade.php ENDPATH**/ ?>