<?php $__env->startSection('css'); ?>
<style>
    .text-bold{
        font-weight: 700;
    }
    .text-decoration-line-through{
        text-decoration: line-through;
        color: #7a7979;
    }
    .product.product-11 a:hover{
        text-decoration: none;
        color: #6287ec;
    }
    .product.product-11 .btn-product-icon {
        color: #fff;
        border: 1px solid #ebebeb;
        background: #6287ec;
    }
    .product.product-11 .btn-product-icon:hover, .product.product-11 .btn-product-icon:focus {
        color: #fff;
        background: #6287ec;
        border: 1px solid #6287ec;
    }
    .card-footer {
        padding: 0.75rem 1.25rem;
        background-color: rgb(255 255 255) !important;
        border-top: none !important;
    }
    @media (max-width: 575px) {
        .intro-slider-container ,.intro-slide{
            height: 145px;
        }
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('body'); ?>
<div class="intro-slider-container mb-5 ">
    <div class="owl-carousel owl-simple owl-light owl-nav-inside" data-toggle="owl" data-owl-options='{"nav": true}'>
        <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="intro-slide <?php echo e($key == 0 ? 'active' : ''); ?>" style="background-image: url(<?php echo e(asset($slider->image)); ?>);"></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <!-- End .owl-carousel owl-simple -->

    <span class="slider-loader text-white"></span>
    <!-- End .slider-loader -->
</div>



    <div class="container py-5">
        <div class="row">
            <div class="col-12 text-center text-bold">
                <h4 class="text-bold">Popular Categories</h4>
                <p class="text-bold">Acquire your preferred item from the popular category!</p>
            </div>
        </div>
    </div>
    <!-- End .container -->

    <div class="container-fluid">
        <div class="categories">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-md-3 col-lg-2">
                    <div class="product product-11 text-center">
                        <a href="<?php echo e(route('sub.category.product', $subcategory->id)); ?>">
                            <div class="card text-center" style="padding: 30px;height: 202px;">
                                <div class="card-body p-0" style="height:108px">
                                    <img src="<?php echo e(asset($subcategory->image)); ?>" class="mx-auto d-block mb-2 product-image" style="width:50%">
                                </div>
                                <div class="card-footer">
                                    <h3 class="product-title"><?php echo e($subcategory->name); ?></h3>
                                </div>
                            </div>
                        </a>

                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <!-- End .row -->
        </div>
    </div>
    <!-- End .container-fluid -->

    <div class="mb-5"></div>
    <!-- End .mb-5 -->


    <div class="container-fluid">
        <div class="heading heading-center mb-3 text-bold">
            <h2 class="title text-bold">Featured Products</h2>
            <p class="text-bold">Confirm and grab your desired product!</p>
        </div>
        <div class="products">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-6 col-md-4 col-lg-3 col-xl-5col">
                    <div class="product product-11">
                        <figure class="product-media">
                            <a href="<?php echo e(route('product.detail', $product->id)); ?>">
                                <img src="<?php echo e(asset($product->image)); ?>" alt="Product image" class="product-image">
                                <img src="<?php echo e(asset($product->image)); ?>" alt="Product image" class="product-image-hover">
                            </a>

                            <div class="product-action-vertical">
                                <a href="#" class="btn-product-icon" onclick="addToCart(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>); return false;">
                                    <i class="fa-solid fa-cart-shopping"></i>
                                </a>
                                <a href="#" class="btn-product-icon" onclick="addToWishlist(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>); return false;"><i class="fa-solid fa-heart"></i></a>
                                <a href="#" class="btn-product-icon" onclick="addToCompare(<?php echo e($product->id); ?>, '<?php echo e($product->name); ?>', <?php echo e($product->price); ?>); return false;"><i class="fa-solid fa-code-compare"></i></a>
                                <a href="<?php echo e(route('product.detail', $product->id)); ?>" class="btn-product-icon"><i class="fa-solid fa-eye"></i></a>
                            </div>
                        </figure>

                        <div class="product-body text-left">
                            <h3 class="product-title mb-2"><a href="product.html"><?php echo e($product->name); ?></a></h3>
                            <div class="product-price text-left">
                                <span>৳<?php echo e($product->sale_price); ?></span> <span class="text-decoration-line-through ml-3">৳<?php echo e($product->regular_price); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
    <!-- End .container -->

    <div class="container-fluid">
        <hr class="mt-1 mb-6">
    </div>
    <!-- End .container -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>

<script>
    function addToCart(productId, productName, productPrice) {
        let formData = new FormData();
        formData.append('_token', '<?php echo e(csrf_token()); ?>');
        formData.append('product_id', productId);
        formData.append('quantity', 1);
        $.ajax({
            url: "<?php echo e(route('cart.store')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log(response);
                toastr.success('<span style="font-size:15px">Product added to cart successfully!</span>');
                location.reload();
            },
            error: function(error) {
                console.log(error);
                location.reload();
            }
        });
    }

    function addToWishlist(productId, productName, productPrice) {
        let formData = new FormData();
        formData.append('_token', '<?php echo e(csrf_token()); ?>');
        formData.append('product_id', productId);
        formData.append('quantity', 1);
        $.ajax({
            url: "<?php echo e(route('wishlist.store')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log(response);
                toastr.success('<span style="font-size:15px">Product added to wishlist successfully!</span>');
                location.reload();
            },
            error: function(error) {
                console.log(error);
                location.reload();
            }
        });
    }

    function addToCompare(productId, productName, productPrice) {
        let formData = new FormData();
        formData.append('_token', '<?php echo e(csrf_token()); ?>');
        formData.append('product_id', productId);
        formData.append('quantity', 1);
        $.ajax({
            url: "<?php echo e(route('compare.store')); ?>",
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                console.log(response);
                toastr.success('<span style="font-size:15px">Product added to compare successfully!</span>');
                location.reload();
            },
            error: function(error) {
                console.log(error);
                location.reload();
            }
        });
    }
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\q7bd\q7bd\resources\views/front/home/index.blade.php ENDPATH**/ ?>