<?php $__env->startSection('title'); ?>
    Product Atribute
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<style>
    .add-button{
        position: absolute;
        top: 32px;
        right: -21px;
    }
    .remove-button{
        position: absolute;
        top: 70px;
        right: -21px;
        display: none;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
<section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Product Atribute</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item active">Product Atribute</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
        <div class="row items-center">
            <div class="col-md-4">
                <form action="<?php echo e(route('atribute.store')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="name">Atribute Name</label>
                                <small>
                                    <?php if($errors->has('name')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" id="name" name="name" placeholder="Enter Atribute Name">
                            </div>
                            <div class="form-group" style="position: relative">
                                <label for="value">Atribute Value</label>
                                <small>
                                    <?php if($errors->has('value')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('value')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" id="value" name="value[]" placeholder="Enter Atribute Value">
                                <div class="add-button">
                                    <a href="#" class="btn btn-primary btn-sm addinput"><i class="fa-solid fa-plus"></i></a>
                                </div>
                                <div class="remove-button">
                                    <a href="#" class="btn btn-danger btn-sm removeinput"><i class="fa-solid fa-trash"></i></a>
                                </div>
                            </div>
                            <div id="inputfield">
                            </div>


                            <div class="col-12 pb-5 pt-3 text-center">
                                <input type="submit" value="Save" class="form-contol btn btn-success float-right">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title
                        ">Product Atribute List</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th style="width: 10px">#</th>
                                    <th>Atribute Name</th>
                                    <th>Atribute Value</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $atributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $atribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($key+1); ?></td>
                                        <td><?php echo e($atribute->name); ?></td>
                                        <td>
                                            <?php $__currentLoopData = $atribute->atributeValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <span class="badge badge-primary"><?php echo e($value->value); ?></span>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </td>
                                        <td>
                                            <form action="<?php echo e(route('atribute.destroy', $atribute->id)); ?>" method="post">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <a href="<?php echo e(route('atribute.edit', $atribute->id)); ?>" class="btn btn-primary"><i class="fa-solid fa-pen-to-square"></i></a>
                                                <button type="submit" class="btn btn-sm btn-danger"><i class="fa-solid fa-trash"></i></button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
  </section>
</div>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    function toggleRemoveButton() {
        var inputCount = $('#inputfield input').length;
        if (inputCount > 0) {
            $('.remove-button').show();
        } else {
            $('.remove-button').hide();
        }
    }
    $('.addinput').click(function (e) {
        e.preventDefault();
        $('#inputfield').append('<input type="text" class="form-control mb-3" name="value[]" placeholder="Enter Attribute Value">');
        toggleRemoveButton();
    });

    $('.removeinput').click(function (e) {
        e.preventDefault();
        $('#inputfield input:last-child').remove();
        toggleRemoveButton();
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\user\Workspace\yasir_it\resources\views/admin/atribute/index.blade.php ENDPATH**/ ?>