<?php $__env->startSection('title'); ?>
    Edit Category
<?php $__env->stopSection(); ?>

<?php $__env->startSection('style'); ?>
<link rel="stylesheet" href="<?php echo e(asset('/')); ?>assets/backend/plugins/summernote/summernote-bs4.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
<section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Edit Category</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="#">Categories</a></li>
            <li class="breadcrumb-item active">Edit Category</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
        <form action="<?php echo e(route('category.update', $category->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="row items-center">
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="name">Category Name</label>
                                <small>
                                    <?php if($errors->has('name')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('name')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($category->name); ?>">
                            </div>
                            <div class="form-group">
                                <label for="description">Category Description</label>
                                <small>
                                    <?php if($errors->has('description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" name="description">
                                    <?php echo $category->description; ?>

                                </textarea>
                            </div>
                            <div class="form-group">
                                <label for="topbar-heading">Topbar Heading</label>
                                <small>
                                    <?php if($errors->has('topbar_heading')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('topbar_heading')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="topbar_heading" id="topbar-heading" value="<?php echo e($category->topbar_heading); ?>">
                            </div>
                            <div class="form-group">
                                <label for="topbar-heading">Topbar Description</label>
                                <small>
                                    <?php if($errors->has('topbar_description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('topbar_description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" name="topbar_description">
                                    <?php echo $category->topbar_description; ?>

                                </textarea>
                            </div>
                            <div class="form-group">
                                <label for="topbar-heading">Bottom Description</label>
                                <small>
                                    <?php if($errors->has('bottom_description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('bottom_description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" id="summernote" name="bottom_description">
                                    <?php echo $category->bottom_description; ?>

                                </textarea>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputFile">Image</label>
                                <small>
                                    <?php if($errors->has('image')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('image')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <div class="input-group pb-3">
                                    <div class="custom-file">
                                        <input type="file" name="image" class="custom-file-input" id="exampleInputFile">
                                        <label class="custom-file-label" for="exampleInputFile">Choose file</label>
                                    </div>
                                </div>
                                <?php if(isset($category->image)): ?>
                                    <img src="<?php echo e(asset($category->image)); ?>" height="100px" width="100px" alt="">
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-body">
                            <div class="form-group">
                                <label for="parent_id">Meta Title</label>
                                <small>
                                    <?php if($errors->has('meta_title')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_title')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="meta_title" id="meta_title" value="<?php echo e($category->meta_title); ?>">
                            </div>
                            <div class="form-group">
                                <label for="parent_id">Meta URL</label>
                                <small>
                                    <?php if($errors->has('meta_url')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_url')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="meta_url" id="meta_url" value="<?php echo e($category->meta_url); ?>">
                            </div>
                            <div class="form-group">
                                <label for="parent_id">Meta Keywords</label>
                                <small>
                                    <?php if($errors->has('meta_keyword')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_keyword')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <input type="text" class="form-control" name="meta_keyword" id="meta_keyword" value="<?php echo e($category->meta_keyword); ?>">
                            </div>
                            <div class="form-group">
                                <label for="parent_id">Meta Description</label>
                                <small>
                                    <?php if($errors->has('meta_description')): ?>
                                        <div class="text-danger"><?php echo e($errors->first('meta_description')); ?></div>
                                    <?php endif; ?>
                                </small>
                                <textarea class="summernote" id="summernote" name="meta_description">
                                    <?php echo $category->meta_description; ?>

                                </textarea>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="col-12 pb-5 pt-3 text-center">
                    <input type="submit" value="Save" class="form-contol btn btn-success float-right">
                </div>
            </div>
        </form>
    </div>
  </section>
</div>
  <!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('/')); ?>assets/backend/plugins/summernote/summernote-bs4.min.js"></script>
<script>
    $(function () {
      $('.summernote').summernote()
    })
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/hescsijv/q7bd.hescbd.com/resources/views/admin/category/edit.blade.php ENDPATH**/ ?>