<?php session_start();
include ('../inc/dbcon.php');
include ('../inc/functions.php');
include ('../inc/invfunctions.php');
require_once '../vendor/autoload.php'; 
if(isset($_SESSION["axeslogin"]) && $_SESSION["axeslogin"] == true){    
$aid=$_SESSION['uid'];
$brid=$_SESSION['abrid'];
$today = strftime("%Y-%m-%d", time());    
$dtnow = date("Y-m-d h:i:s", time());     
}else{
header('Location:../index.php');
exit;    
}
?>
<?php
use YoHang88\LetterAvatar\LetterAvatar;
function get_detname($type,$id,$key){
global $con;
$sql='';    
if($type=='BA'){
$sql="SELECT tbl_bacount.id,CONCAT('BA',100+tbl_bacount.id,' - ',tbl_bank.sort,' / ',tbl_bacount.acno) AS cname,CONCAT(tbl_bank.sort,' / ',tbl_bacount.acno) AS name FROM tbl_bacount LEFT JOIN tbl_bank ON tbl_bank.id=tbl_bacount.bid WHERE tbl_bacount.id='$id'";    
}elseif($type=='PD'){
$sql="SELECT id,CONCAT(code,' - ',name) AS cname,name FROM tbl_item WHERE id='$id'";
}elseif($type=='CU'){
$sql="SELECT id,CONCAT(code,' - ',name) AS cname,name FROM tbl_customer WHERE id='$id'";     
}elseif($type=='SU'){
$sql="SELECT id,CONCAT(code,' - ',name) AS cname,name FROM tbl_supplier WHERE id='$id'";    
}elseif($type=='EM'){    
$sql="SELECT id,CONCAT(code,' - ',name) AS cname,name FROM tbl_employe WHERE id='$id'";    
}elseif($type=='LE'){
$sql="SELECT id,CONCAT(code,' - ',name) AS cname,name FROM tbl_acledger WHERE id='$id'";
}elseif($type=='MO'){
$sql="SELECT id,CONCAT(name,' - ',mobile) AS cname,name FROM tbl_acmobile WHERE id='$id'";
}elseif($type=='SE'){
$sql="SELECT id,IF(LENGTH(code)>1,CONCAT(code,' - ',name),name) AS cname,name FROM tbl_seritem WHERE id='$id'";
}elseif($type=='LO'){
$sql="SELECT id,IF(type=0,CONCAT(name,' - ',acno),CONCAT(name,' - ',mobile)) AS cname,name FROM tbl_loanid WHERE id='$id'";
}elseif($type=='UI'){
$sql="SELECT id,name,NULL AS cname FROM tbl_user WHERE id='$id'";    
}
$query=mysqli_query($con,$sql) or die(mysqli_error($con));
$row=mysqli_fetch_array($query);
if($key=='N'){    
return $row['name'];
}else{
return $row['cname'];    
}
}

function opval($type,$id,$date,$brid=''){
global $con;
if($brid!=''){
$sql="SELECT COALESCE ((SELECT SUM(debit-credit) FROM (SELECT IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,curid,xrate,apdate,brid FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep WHERE DATE(apdate) < '$date' AND (CONVERT(brid USING utf8) COLLATE utf8_general_ci)='$brid'),0) AS result";    
}else{
$sql="SELECT COALESCE ((SELECT SUM(debit-credit) FROM (SELECT IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,curid,xrate,apdate,brid FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep WHERE DATE(apdate) < '$date'),0) AS result";    
}    

$opval=mysqli_query($con,$sql) or die(mysqli_error($con));    
$opv=mysqli_fetch_array($opval);
return $opv['result'];    
}

function read_invhistory($type,$id){
global $con;
$out='';
$sql="SELECT DISTINCT apdate FROM (SELECT invno,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,brid,uid,apdate,TIME(date) AS time FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,refinv,chkno,chkdt,otnote,recon,ref,curid,xrate,apdate,brid,uid,date  FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep GROUP BY invno) AS rec ORDER BY apdate DESC,time DESC";    

$result=mysqli_query($con,$sql) or die(mysqli_error($con));   
if($result->num_rows > 0) {
$out.='<div class="row">';
$out.='<div class="col-md-12">';
$out.='<div class="alert alert-history" style="background-color: transparent !important;border: 0px  !important;max-height:550px;min-height: 550px">';
$out.='<ul class="timeline" style="margin: 10px 0 30px 0 !important;">';     
while($row=mysqli_fetch_array($result)){    
$date=$row['apdate'];
$out.='<li ><span class="label label-success">'.date("d M Y", strtotime($row['apdate']));
$out.='</span></li>';    
$sql="SELECT * FROM (SELECT invno,SUBSTRING(invno,1,3) AS invty,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,brid,uid,apdate,TIME(date) AS time FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,refinv,chkno,chkdt,otnote,recon,ref,curid,xrate,apdate,brid,uid,date  FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep GROUP BY invno) AS rec WHERE apdate='$date' ORDER BY time DESC";
$results=mysqli_query($con,$sql) or die(mysqli_error($con));
while($rows=mysqli_fetch_array($results)){
if($rows['brid']!=0){
$bname=get_fild_data('tbl_branch',$rows['brid'],'name');    
}else{
$bname='Main Branch';    
}    
if($rows['invty']=='SEL'){
$icon='Sold Invoice';
$sub='Salese...';
$data='From <strong>'.$bname.'</strong> Sales Invoice No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');   
}elseif($rows['invty']=='PUR'){
$icon='Purchase Invoice';
$sub='Purchase...';
$data='From <strong>'.$bname.'</strong> Purchase Invoice No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='SER'){
$icon='Service Invoice';
$sub='Service...';
$data='From <strong>'.$bname.'</strong> Service Invoice No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='SRE'){
$icon='Sales Return';
$sub='Return...' ;
$data='From <strong>'.$bname.'</strong> Sales Return Invoice No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='PRE'){
$icon='Paurchase Return';
$sub='Return...';
$data='From <strong>'.$bname.'</strong> Purchase Return Invoice No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='PAV'){
$icon='Payment Receipt';
$sub='Payment Paid...';
$data='From <strong>'.$bname.'</strong> Payment Voucher No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='REV'){
$icon='Collection Receipt';
$sub='Payment Received...';
$data='From <strong>'.$bname.'</strong> Received Voucher No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');
}elseif($rows['invty']=='PDR'){
$icon='Damage Purchase';
$sub='Damage Goods Purcase...';
$data='From <strong>'.$bname.'</strong> Damage Goods Purchase No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');
}elseif($rows['invty']=='JOU'){
$icon='Make Jounal';
$sub='Journal Entry...';
$data='From <strong>'.$bname.'</strong> Manual Jounal No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='BSC'){
$icon='Bad Stock Claim';
$sub='Bad Stock Claim...';
$data='From <strong>'.$bname.'</strong> Damage Goods Purchase No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}elseif($rows['invty']=='CLA'){
$icon='Warranty Claim';
$sub='Warranty settlement...';
$data='From <strong>'.$bname.'</strong> Received Voucher No <strong>'.$rows['invno'].'</strong> With Amount    <strong>'.numtolocal($rows['amount'],get_fild_data('tbl_currency','1','symbol')).'</strong> Was created By '.get_detname('UI',$rows['uid'],'N');    
}    
$out.='<li>';
$out.='<i class="fa fa-chevron-right bg-gray"></i>
<div class="timeline-item" style="background-color: transparent !important">
<span class="time"><i class="fa fa-clock-o"></i> '.$rows['time']; 
$out.='</span>';
$out.='<h3 class="timeline-header"> <a href="#">';
$out.=$sub;         
$out.='</a></h3>
<div class="timeline-body">
<p class="timeline-title">'.$icon;   
$out.='</p>'.$data;
$out.='</div></div></li>'; 
}        
}
$out.='</ul></div>';    
$out.='</div></div>';    
}else{
$out='';    
}
return $out;    
}


?>
<?php 
if(isset($_POST['cusdet'])){ 
$type=$_POST['type'];
$did=$_POST['cusid'];
$userimg = new LetterAvatar(get_detname($type,$did,'N'), '', 256);    
?>

<div class="card">
<div class="card-container">
<div class="card-item">
<div class="card-header">
<div class="card-header-bg"></div>
<img src="<?php echo $userimg; ?>" class="card-header-img">
<div class="card-header-text">
<span class="card-header-name">
<?php echo get_detname($type,$did,'N'); ?>
</span>
<span class="card-header-job">
<?php if($type=='CU'){echo get_fild_data('tbl_customer',$did,'code');}else{echo get_fild_data('tbl_supplier',$did,'code');}?>
</span>
<span class="card-header-job">
<?php if($type=='CU'){ $email=get_fild_data('tbl_customer',$did,'cemail');}else{ $email=get_fild_data('tbl_supplier',$did,'cemail');}
if(strlen($email)>1){echo $email;}
?>
</span>
<span class="card-header-job">
<?php if($type=='CU'){echo get_fild_data('tbl_customer',$did,'cnumber');}else{echo get_fild_data('tbl_supplier',$did,'cnumber');}?>
</span>
<br>
<span class="card-header-job">
<?php if($type=='CU'){ $email=get_fild_data('tbl_customer',$did,'address');}else{ $email=get_fild_data('tbl_supplier',$did,'address');}
if(strlen($email)>1){echo $email;}
?>
</span>
</div>
</div>
<ul class="card-detail">
<?php 
$sql="SELECT SUBSTRING(invno,1,3) AS invty,COUNT(*) AS inqty,ROUND(SUM(amount),2) AS totamo FROM (SELECT invno,ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))) AS amount FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,refinv,chkno,chkdt,otnote,recon,ref,curid,xrate,apdate,brid,uid,date  FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$did') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$did')) AS curep GROUP BY invno  ORDER BY apdate ASC) as res GROUP BY SUBSTRING(invno,1,3)";
$query=mysqli_query($con,$sql)or die(mysqli_error($con));
while ($row=mysqli_fetch_array($query)){
if($row['invty']=='SEL'){
$icon='Sales Invoice';    
}elseif($row['invty']=='PUR'){
$icon='Purchase Invoice';
}elseif($row['invty']=='SER'){
$icon='Service Invoice';
}elseif($row['invty']=='SRE'){
$icon='Sales Return';
}elseif($row['invty']=='PRE'){
$icon='Paurchase Return';
}elseif($row['invty']=='PAV'){
$icon='Payment Receipt';
}elseif($row['invty']=='REV'){
$icon='Collection Receipt';
}elseif($row['invty']=='CLA'){
$icon='Warranty Claim';
}elseif($row['invty']=='BSC'){
$icon='Bad Stock Claim';     
}elseif($row['invty']=='PDR'){
$icon='Damage Purchase';
}elseif($row['invty']=='JOU'){
$icon='Journal Entry';    
}    
?>
<?php if($icon!=''){?>
<li class="card-detail-li">
<p class="card-detail-txt">
<span class="card-detail-icon post">
<i class="fa fa-file-text-o"></i>
</span>
<?php echo $icon.'&nbsp;&nbsp;';?> 
</p>
<p class="card-detail-str"><?php echo $row['inqty'];?></p>
</li>
<?php } ?>
<?php } ?>
</ul>    
<div class="card-social">
  
</div>
</div>
</div>
</div>
    
<?php } ?>

<?php 
if(isset($_POST['tradet'])){ 
$type=$_POST['type'];
$did=$_POST['cusid'];    
?>
<div class="lightpage">  
<div class="axestab">
  
<ul>
<li><a href="#overview">
<span>Overview</span></a></li>
<li><a href="#pursel">
<span>Purchase / Sales</span></a></li>
<li><a href="#prodlist">
<span>Product</span></a></li>
<li><a href="#payment">
<span>Payment / Receipt</span></a></li>    
<li><a href="#statement">
<span>Statement</span></a></li>
<li><a href="#transaction">
<span>Detail Transactions</span></a></li>  
</ul>
  
<div class="tabcontents">
<div id="overview">
<?php
if($type=='SU'){
$sty=",'CLA'";
$wty="";    
}else{
$wty=",'CLA'";    
$sty="";    
}    
$sql="SELECT SUM(IF(invty IN ('PAV','PRE','SEL','SER','PDR','BSC'".$sty."),amount,(debit+jdebit))) AS debit,SUM(IF(invty IN ('PUR','REV','SRE'".$wty."),amount,(credit+jcredit))) AS credit,(SUM(IF(invty IN ('PAV','PRE','SEL','SER','PDR','BSC'".$sty."),amount,(debit+jdebit)))-SUM(IF(invty IN ('PUR','REV','SRE'".$wty."),amount,(credit+jcredit)))) AS balance FROM (SELECT SUBSTRING(invno,1,3) AS invty,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),debit,0)),2) AS debit,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),credit,0)),2) AS credit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND debit>0,debit,0)),2) AS jdebit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND credit>0,credit,0)),2) AS jcredit FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$did') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$did')) AS curep GROUP BY SUBSTRING(invno,1,3)) AS res";
$over=mysqli_query($con,$sql) or die(mysqli_error($con));    
$ost=mysqli_fetch_array($over);    
?>    
<div class="col-md-12">
<div class="row">
<div class="col-md-4">
<div class="tile wide quote">
<div class="header">
<div class="count"><?php echo numtolocal($ost['debit'],get_fild_data('tbl_currency','1','symbol'));?></div>
</div>
<div class="body">
<div class="title">Total Debit</div>
</div>
</div>    
</div>
<div class="col-md-4">
<div class="tile wide invoices">
<div class="header">
<div class="count"><?php echo numtolocal($ost['credit'],get_fild_data('tbl_currency','1','symbol'));?></div>
</div>
<div class="body">
<div class="title">Total Credit</div>
</div>
</div>    
</div>
<div class="col-md-4">
<div class="tile job">
<div class="header">
<div class="count"><?php echo numtolocal($ost['balance'],get_fild_data('tbl_currency','1','symbol'));?></div>
</div>
<div class="body">
<div class="title">Outstanding Balance</div>
</div>
</div>        
</div> 
<br> 
<br>     
</div>
<div class="row">
<br>     
<?php echo read_invhistory($type,$did);?>        
</div>    
</div>      
</div>
    
<div id="pursel">
<h2>Sales</h2>

</div>
    
<div id="prodlist">
<div class="col-md-12">
<div class="row">
<div class="cart cart-sm">     
<table class="table table-bordered table-striped" style="margin-bottom: 0;">
<thead>
<tr>
<td rowspan="2" style="text-align:left; width:100px;"><strong>Date</strong></td>
<td rowspan="2" style="text-align:left; width:90px;"><strong>Invoice</strong></td>    
<td rowspan="2" style="text-align:left; width:250px;"><strong>Particulars</strong></td>
<td rowspan="2" style="text-align:left; width:90px;"><strong>Price</strong></td>    
<td colspan="3" style="text-align:center; width:180px;"><strong>Purchase Details</strong></td>
<td colspan="3" style="text-align:center; width:180px;"><strong>Sales Details</strong></td>
<td rowspan="2" style="text-align:left; width:80px;"><strong>Discount</strong></td>
<td rowspan="2" style="text-align:left; width:80px;"><strong>Total</strong></td>    
</tr>
<tr>
<td style="text-align:left; width:60px;">Purchase</td>
<td style="text-align:left; width:60px;">Received</td>    
<td style="text-align:left; width:60px;">Return</td>
<td style="text-align:left; width:60px;">Sold</td>
<td style="text-align:left; width:60px;">Delivered</td>    
<td style="text-align:left; width:60px;">Return</td>    
</tr>    
</thead>
</table>
<div class="cart-det style-3 item" style="padding:0px;">    
<table class="table table-bordered table-striped" style="margin-bottom: 0;">    
<tbody id="tradata">
<?php
$sql="SELECT date,invno,pid,colid,sizid,IF(mods IN ('PU','PR'),cost,price) AS price,IF(mods='PU',p_qty,0) AS pqty,IF(mods IN ('PU','RC'),p_in,0) AS rqty,IF(mods='PR',p_out,0) AS prqty,IF(mods='SE',s_qty,0) AS sqty,IF(mods IN ('SE','DL'),p_out,0) AS dqty,IF(mods='SR',p_out,0) AS srqty,disamo,subtot FROM tbl_traproduct WHERE type='$type' AND tid=$did ORDER BY id ASC";    
$query=mysqli_query($con,$sql)or die(mysqli_error($con));
while ($row=mysqli_fetch_array($query)){
$name='';
$name=get_detname('PD',$row['pid'],'N');
if($row['colid']!='0'){$name.=' - '.get_fild_data('tbl_color',$row['colid'],'name');}
if($row['sizid']!='0'){$name.=' - '.get_fild_data('tbl_size',$row['sizid'],'sval');}    
?>
<tr>
<td style="text-align:left; width:100px;"><?php echo date("d M Y", strtotime($row['date']));?></td>
<td style="text-align:left; width:90px;"><strong><?php echo $row['invno'];?></strong></td>    
<td style="text-align:left; width:250px;"><?php echo $name;?></td>
<td style="text-align:right; width:90px;"><?php if($row['price']>0){echo '<strong>'.numtolocal($row['price'],'').'</strong>';}?></td>    
<td style="text-align:center; width:60px;"><?php if($row['pqty']>0){echo $row['pqty'];}?></td>
<td style="text-align:center; width:60px;"><?php if($row['rqty']>0){echo $row['rqty'];}?></td>    
<td style="text-align:center; width:60px;"><?php if($row['prqty']>0){echo $row['prqty'];}?></td>
<td style="text-align:center; width:60px;"><?php if($row['sqty']>0){echo $row['sqty'];}?></td>
<td style="text-align:center; width:60px;"><?php if($row['dqty']>0){echo $row['dqty'];}?></td>    
<td style="text-align:center; width:60px;"><?php if($row['srqty']>0){echo $row['srqty'];}?></td>    
<td style="text-align:right; width:80px;"><?php if($row['disamo']>0){echo '<strong>'.numtolocal($row['disamo'],'').'</strong>';}?></td>
<td style="text-align:right; width:80px;"><?php if($row['subtot']>0){echo '<strong>'.numtolocal($row['subtot'],'').'</strong>';}?></td>    
</tr>    
<?php } ?>
    
</tbody>    
</table>
</div>    
</div>    
</div>    

</div> 
</div>
      
<div id="statement">
<?php 
function st_opval($type,$id,$date){
global $con;
if($type=='SU'){
$sty=",'CLA'";
$wty="";    
}else{
$wty=",'CLA'";    
$sty="";    
}    
$sql="SELECT COALESCE ((SELECT (SUM(IF(invty IN ('PAV','PRE','SEL','SER','PDR','BSC'".$sty."),amount,(debit+jdebit)))-SUM(IF(invty IN ('PUR','REV','SRE'".$wty."),amount,(credit+jcredit)))) FROM (SELECT SUBSTRING(invno,1,3) AS invty,invno,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),debit,0)),2) AS debit,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),credit,0)),2) AS credit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND debit>0,debit,0)),2) AS jdebit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND credit>0,credit,0)),2) AS jcredit,apdate FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,ref,apdate,TIME(date) AS time FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep GROUP BY invno) AS rec WHERE apdate < '$date'),0) AS opval";
$opval=mysqli_query($con,$sql) or die(mysqli_error($con));    
$opv=mysqli_fetch_array($opval);
return $opv['opval'];    
}

function st_drcrbal($type,$id,$fdate,$tdate,$key){
global $con;
if($type=='SU'){
$sty=",'CLA'";
$wty="";    
}else{
$wty=",'CLA'";    
$sty="";    
}    
if($key=='D'){    
$sql="SELECT COALESCE ((SELECT SUM(IF(invty IN ('PAV','PRE','SEL','SER','PDR','BSC'".$sty."),amount,(debit+jdebit))) FROM (SELECT SUBSTRING(invno,1,3) AS invty,invno,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),debit,0)),2) AS debit,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),credit,0)),2) AS credit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND debit>0,debit,0)),2) AS jdebit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND credit>0,credit,0)),2) AS jcredit,apdate FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,ref,apdate,TIME(date) AS time FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep GROUP BY invno) AS rec WHERE apdate BETWEEN '$fdate' AND '$tdate'),0) AS result";
}else{
$sql="SELECT COALESCE ((SELECT SUM(IF(invty IN ('PUR','REV','SRE'".$wty."),amount,(credit+jcredit))) FROM (SELECT SUBSTRING(invno,1,3) AS invty,invno,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),debit,0)),2) AS debit,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),credit,0)),2) AS credit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND debit>0,debit,0)),2) AS jdebit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND credit>0,credit,0)),2) AS jcredit,apdate FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,ref,apdate,TIME(date) AS time FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$id') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$id')) AS curep GROUP BY invno) AS rec WHERE apdate BETWEEN '$fdate' AND '$tdate'),0) AS result";    
}
$opval=mysqli_query($con,$sql) or die(mysqli_error($con));    
$opv=mysqli_fetch_array($opval);
return $opv['result'];    
}    
?>
<div class="row">
<div class="col-md-3"></div> 
<div class="col-md-6">
<div class="col-md-5 col-xs-6">
<div class="form-group" >
<input type="text" class="form-control datetimepicker" id="stfrdt" value="<?php echo date('Y-m-d', strtotime('-30 days',strtotime($today)));?>" placeholder="Sales Date" autocomplete="off" readonly>
</div>
</div>
<div class="col-md-5 col-xs-6">
<div class="form-group" >
<input type="text" class="form-control datetimepicker" id="sttodtdt" value="<?php echo $today;?>" placeholder="Sales Date" autocomplete="off" readonly>
</div>    
</div>
<div class="col-md-2 col-xs-6">
<button class="btn btn-flat bg-blue trafilter" id="saveinv">Submit&nbsp;&nbsp;<i class="fa fa-filter"></i></button>    
</div>    
</div> 
<div class="col-md-3"></div>     
</div>    
<div class="invhold scrol-y" id="invhold">    
<div id="ember1236" class="ember-view">
<div class="printableArea">    
<style media="all" type="text/css">
  @font-face {
    font-family: 'WebFont-Open Sans';
    src: local(Open Sans), url(https://fonts.gstatic.com/s/opensans/v14/K88pR3goAWT7BTt32Z01m4X0hVgzZQUfRDuZrPvH3D8.woff2);
  }

  .pcs-template {
  	font-family: Open Sans, 'WebFont-Open Sans';
    font-size: 9pt;
    color: #333333;
      background:  #ffffff ;
  }

  .pcs-header-content {
    font-size: 9pt;
	color: #333333;
	background-color: #ffffff;
  }
  .pcs-template-body {
  	padding: 0 0.400000in 0 0.550000in;
  }
  .pcs-template-footer {
  	height: 0.700000in;
	font-size: 6pt;
	color: #aaaaaa;
	padding: 0 0.400000in 0 0.550000in;
	background-color: #ffffff;
  }
  .pcs-footer-content {
  word-wrap: break-word;
  color: #aaaaaa;
      border-top: 1px solid #adadad;
  }

  .pcs-label {
    color: #333333;
  }
  .pcs-entity-title {
    font-size: 16pt;
    color: #000000;
  }
  .pcs-orgname {
    font-size: 10pt;
    color: #333333;
  }
  .pcs-customer-name {
    font-size: 9pt;
    color: #333333;
  }
 .pcs-itemtable-header {
    font-size: 9pt;
    color: #ffffff;
    background-color: #3c3d3a;
  }
  .pcs-itemtable-breakword {
    word-wrap: break-word;
  }
  .pcs-taxtable-header {
    font-size: 9pt;
    color: #ffffff;
    background-color: #3c3d3a;
  }
  .breakrow-inside {
    page-break-inside: avoid;
  }
  .breakrow-after {
    page-break-after:auto;
  }
  .pcs-item-row {
    font-size: 9pt;
    border-bottom: 1px solid #adadad;
    background-color: #ffffff;
    color: #000000;
  }
  .pcs-item-sku {
    margin-top: 2px;
  	font-size: 10px;
  	color: #444444;
  }
  .pcs-item-desc {
      color: #727272;
      font-size: 9pt;
   }
  .pcs-balance {
    background-color: #f5f4f3;
    font-size: 9pt;
    color: #000000;
  }
  .pcs-totals {
    font-size: 9pt;
    color: #000000;
    background-color: #ffffff;
  }
  .pcs-notes {
    font-size: 8pt;
  }
  .pcs-terms {
    font-size: 8pt;
  }
  .pcs-header-first {
	background-color: #ffffff;
	font-size: 9pt;
	color: #333333;
      height: auto;
	}

 .pcs-status {
 	color: ;
	font-size: 15pt;
	border: 3px solid ;
	padding: 3px 8px;
 }
 .billto-section {
     padding-top: 0mm;
     padding-left: 0mm;
   }
   .shipto-section {
     padding-top: 0mm;
     padding-left: 0mm;
   }

 @page :first {
 	@top-center {
		content: element(header);
	}
    margin-top: 0.700000in;
  }

  .pcs-template-header {
	padding: 0 0.400000in 0 0.550000in;
    height: 0.700000in;
  }

  .pcs-template-fill-emptydiv {
    display: table-cell;
    content: " ";
    width: 100%;
  }


/* Additional styles for RTL compat */

/* Helper Classes */

.inline {
  display: inline-block;
}
.v-top {
  vertical-align: top;
}
.text-align-right {
  text-align: right;
}
.rtl .text-align-right {
  text-align: left;
}
.text-align-left {
  text-align: left;
}
.rtl .text-align-left {
  text-align: right;
}

/* Helper Classes End */

.item-details-inline {
  display: inline-block;
  margin: 0 10px;
  vertical-align: top;
  max-width: 70%;
}

.total-in-words-container {
  width: 100%;
  margin-top: 10px;
}
.total-in-words-label {
  vertical-align: top;
  padding: 0 10px;
}
.total-in-words-value {
  width: 170px;
}
.total-section-label {
  padding: 5px 10px 5px 0;
  vertical-align: middle;
}
.total-section-value {
  width: 120px;
  vertical-align: middle;
  padding: 10px 10px 10px 5px;
}
.rtl .total-section-value {
  padding: 10px 5px 10px 10px;
}

.tax-summary-description {
  color: #727272;
  font-size: 8pt;
}

.bharatqr-bg {
  background-color: #f4f3f8;
}

/* Overrides/Patches for RTL compat */
  .rtl th {
    text-align: inherit; /* Specifically setting th as inherit for supporting RTL */
  }
/* Overrides/Patches End */


/* Subject field styles */
.subject-block {
    margin-top: 20px;
}
.subject-block-value {
    word-wrap: break-word;
    white-space: pre-wrap;
    line-height: 14pt;
    margin-top:5px;
}
/* Subject field styles End*/
</style>
<style>
    .trclass_evenrow { background-color:#f6f5f5; }
    .trclass_oddrow { background-color: #ffffff; }

    table {
      -fs-table-paginate: paginate;
    }
    .title-section {
      float: right;
      margin-top:20px;
    }
    .rtl .title-section {
      float: left;
    }
    .pcs-itemtable-header {
      padding: 4px 4px;
    }
    .summary-section {
      float: right;
    }
    .rtl .summary-section {
      float: left;
    }
    .box-padding {
      padding:8px 4px;
    }
    </style>
<div class="pcs-template ">
<div class="pcs-template-header pcs-header-content" id="header">
<div class="pcs-template-fill-emptydiv"></div>
</div>


<div class="pcs-template-body">
<table style="line-height:18px;" cellpadding="0" cellspacing="0" border="0" width="100%">
<tbody><tr>
<td>
<img src="../img/<?php if(empty(get_cominfo('1','logo'))){echo "no_logo.png";}else{echo get_cominfo('1','logo');}?>" alt="<?php echo get_cominfo('1','name');?>" style="width:100.00px;height:87.00px;" id="logo_content">
</td>

<td width="50%" class="pcs-orgname text-align-right">
<b><?php echo get_cominfo('1','name');?></b><br>
<span style="white-space: pre-wrap;" id="tmp_org_address"><?php echo get_cominfo('1','');?></span>
</td>
</tr>
<tr>
<td colspan="2">
<table cellpadding="0" cellspacing="0" border="0" class="title-section">
<tbody><tr>
<td class="pcs-entity-title" style="padding-top:6px;line-height:30px;"><b>Statement of Accounts</b></td>
</tr>
<tr>
<td style="font-size:12px; border-top: 1px solid #000;border-bottom: 1px solid #000;" height="24" class="text-align-right"><?php echo date('d M Y', strtotime('-30 days',strtotime($today))).' To '.date("d M Y", strtotime($today));?></td>
</tr>
</tbody></table>
</td>
</tr>
<tr>
<td style="padding:20px 0px 0px 5px;">
<table cellpadding="0" cellspacing="0" border="0" width="70%">
<tbody><tr>
<td class="pcs-label"><b>To</b></td>
</tr>
<tr>
<td>
<span style="white-space: pre-wrap;" id="tmp_billing_address"><strong><span class="pcs-customer-name" id="zb-pdf-customer-detail"><?php if($type=='CU'){echo get_csinfogen($did,'tbl_customer');}else{echo get_csinfogen($did,'tbl_supplier');}?></span></strong></span>
</td>
</tr>
</tbody></table>
</td>
<td style="padding:20px 0px 30px 0px;" valign="bottom">
<table cellpadding="5" cellspacing="0" width="79%" border="0" class="summary-section">
<tbody><tr>
<td class="pcs-label" style="padding:4px 6px 4px 6px; border-bottom:1px solid #dcdcdc;" bgcolor="#e8e8e8" colspan="5"><b>Account Summary</b></td>
</tr>
<tr>
<td class="pcs-label" style="padding-top:6px;" width="50%">Opening Balance</td>
<td style="padding:6px 0px 0px 6px;" class="text-align-right"><?php echo numtolocal(st_opval($type,$did,date('Y-m-d', strtotime('-30 days',strtotime($today)))),get_fild_data('tbl_currency','1','symbol'));?></td>
</tr>
<tr>
<td class="pcs-label" style="padding-top:4px;">Debit Amount</td>
<td style="padding:6px 0px 0px 6px;" class="text-align-right"><?php echo numtolocal(st_drcrbal($type,$did,date('Y-m-d', strtotime('-30 days',strtotime($today))),$today,'D'),get_fild_data('tbl_currency','1','symbol'));?></td>
</tr>
<tr>
<td class="pcs-label">Credit Amount</td>
<td style="padding:4px 0px 2px 6px;" class="text-align-right"><?php echo numtolocal(st_drcrbal($type,$did,date('Y-m-d', strtotime('-30 days',strtotime($today))),$today,'C'),get_fild_data('tbl_currency','1','symbol'));?></td>
</tr>
<?php 
$stclbal=((st_opval($type,$did,date('Y-m-d', strtotime('-30 days',strtotime($today))))+st_drcrbal($type,$did,date('Y-m-d', strtotime('-30 days',strtotime($today))),$today,'D'))-st_drcrbal($type,$did,date('Y-m-d', strtotime('-30 days',strtotime($today))),$today,'C'))    
?>    
<tr>
<td class="pcs-label" style="padding-top:6px;border-top:1px solid #000;">Outstanding Balance</td>
<td style="padding:6px 0px 0px 6px;border-top:1px solid #000;" class="text-align-right"><?php echo numtolocal($stclbal,get_fild_data('tbl_currency','1','symbol'));?></td>
</tr>
</tbody></table>
</td>
</tr>
</tbody></table>
<table style="line-height:18px;margin-top:10px;" cellpadding="2" cellspacing="0" border="0" width="100%" class="trpadding">
<thead>
<tr height="26">
<th width="15%" class="pcs-itemtable-header"><b>Date</b></th>
<th width="14%" class="pcs-itemtable-header"><b>Transactions</b></th>
<th width="25%" class="pcs-itemtable-header"><b>Details</b></th>
<th width="13%" class="text-align-right pcs-itemtable-header"><b>Amount</b></th>
<th width="13%" class="text-align-right pcs-itemtable-header"><b>Payments</b></th>
<th width="20%" class="text-align-right pcs-itemtable-header"><b>Balance</b></th>
</tr>
</thead>
<tbody class="itemBody">
<?php
if($type=='SU'){
$sty=",'CLA'";
$wty="";    
}else{
$wty=",'CLA'";    
$sty="";    
}    
$stotdebit=0; $stotcredit=0;    
$sopdate=date('Y-m-d', strtotime('-30 days',strtotime($today)));    
$sopval=st_opval($type,$did,$sopdate);
    
$sql="SELECT apdate,invty,invno,ref,debit,credit,@b := ROUND((@b + debit - credit),2) AS balance FROM (SELECT @b := ".$sopval.") AS dummy CROSS JOIN (SELECT apdate,time,invty,invno,ref,IF(invty IN ('PAV','PRE','SEL','SER','PDR','BSC'".$sty."),amount,(debit+jdebit)) AS debit,IF(invty IN ('PUR','REV','SRE'".$wty."),amount,(credit+jcredit)) AS credit FROM (SELECT SUBSTRING(invno,1,3) AS invty,invno,ROUND(ABS(IF(SUBSTRING(invno,1,3) IN ('REV','PAV'),SUM(debit-credit),SUM(IF(type NOT IN('BA','MO') AND seid NOT IN ('LE2'),debit-credit,0)))),2) AS amount,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),debit,0)),2) AS debit,ROUND(SUM(IF(((type='LE' AND (CONVERT(opid USING utf8) COLLATE utf8_general_ci)='2') OR type IN ('BA','MO')),credit,0)),2) AS credit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND debit>0,debit,0)),2) AS jdebit,ROUND(SUM(IF(SUBSTRING(invno,1,3)='JOU' AND credit>0,credit,0)),2) AS jcredit,ref,apdate,time FROM (SELECT id,(CASE WHEN dty='$type' THEN did WHEN cty='$type' THEN cid END) AS sid,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,(CASE WHEN dty!='$type' THEN CONCAT(dty,did) WHEN cty!='$type' THEN CONCAT(cty,cid) END)  AS seid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,ref,apdate,TIME(date) AS time FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$did') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$did')) AS curep GROUP BY invno) AS rec WHERE apdate BETWEEN '$sopdate' AND '$today') AS stdata ORDER BY apdate ASC,time ASC";
?>    
<tr class="trclass_oddrow breakrow-inside breakrow-after">
<td class="box-padding"><?php echo date('d M Y', strtotime('-30 days',strtotime($today))); ?></td>
<td class="box-padding">***Opening Balance***</td>
<td class="box-padding"></td>
<td class="text-align-right box-padding"><?php echo numtolocal($sopval,'');?></td>
<td class="text-align-right box-padding"></td>
<td class="text-align-right box-padding"><?php echo numtolocal($sopval,'');?></td>
</tr> 
<?php    
$query=mysqli_query($con,$sql)or die(mysqli_error($con));
while ($row=mysqli_fetch_array($query)){
$stotdebit+=$row['debit'];
$stotcredit+=$row['credit'];
if($row['invty']=='SEL'){
$icon='Sales Invoice';    
}elseif($row['invty']=='PUR'){
$icon='Purchase Invoice';
}elseif($row['invty']=='SER'){
$icon='Service Invoice';
}elseif($row['invty']=='SRE'){
$icon='Sales Return';
}elseif($row['invty']=='PRE'){
$icon='Paurchase Return';
}elseif($row['invty']=='PAV'){
$icon='Payment Receipt';
}elseif($row['invty']=='REV'){
$icon='Collection Receipt';
}elseif($row['invty']=='CLA'){
$icon='Warranty Claim';
}elseif($row['invty']=='PDR'){
$icon='Damage Purchase';
}elseif($row['invty']=='BSC'){
$icon='Bad Stock Claim';
}elseif($row['invty']=='JOU'){
$icon='Journal Entry';    
}    
?>    
<tr class="trclass_oddrow breakrow-inside breakrow-after">
<td class="box-padding"><?php echo date("d M Y", strtotime($row['apdate']));?></td>
<td class="box-padding"><?php echo $icon.' <strong>'.$row['invno'].'</strong>';?></td>
<td class="box-padding"><?php echo $row['ref'];?></td>
<td class="text-align-right box-padding"><?php if($row['debit']>0){echo '<strong>'.numtolocal($row['debit'],'').'</strong>';}?></td>
<td class="text-align-right box-padding"><?php if($row['credit']>0){echo '<strong>'.numtolocal($row['credit'],'').'</strong>';}?></td>
<td class="text-align-right box-padding"><strong><?php if($row['balance']>0){echo numtolocal(ABS($row['balance']),'').'&nbsp;&nbsp;[ + ]';}else{echo numtolocal(ABS($row['balance']),'').'&nbsp;&nbsp;[ - ]';}?></strong></td>
</tr>
<?php } ?>
</tbody>
</table>
<table width="100%" style="border-top: 1px solid #dcdcdc;">
<tbody>
<tr>
<td></td>
<td width="50%">
<table width="100%">
<tbody>
<tr>
<td width="50%" class="box-padding" align="right" valign="middle"><b>Outstanding Balance</b></td>
<td class="box-padding" align="right" valign="middle"><strong><?php echo numtolocal($stclbal,'');?></strong></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
  
</div>
<div class="pcs-template-footer">
<div>
      
</div>  
</div>
</div>
</div>
</div>
</div>    
</div>
      
<div id="transaction">
<div class="col-md-12">
<div class="row">
<div class="col-md-3"></div> 
<div class="col-md-6">
<div class="col-md-5 col-xs-6">
<div class="form-group" >
<input type="text" class="form-control datetimepicker" id="trfrdt" value="<?php echo date('Y-m-d', strtotime('-30 days',strtotime($today)));?>" placeholder="Sales Date" autocomplete="off" readonly>
</div>
</div>
<div class="col-md-5 col-xs-6">
<div class="form-group" >
<input type="text" class="form-control datetimepicker" id="trtodtdt" value="<?php echo $today;?>" placeholder="Sales Date" autocomplete="off" readonly>
</div>    
</div>
<div class="col-md-2 col-xs-6">
<button class="btn btn-flat bg-blue trafilter" id="saveinv">Submit&nbsp;&nbsp;<i class="fa fa-filter"></i></button>    
</div>    
</div> 
<div class="col-md-3"></div>     
</div>
<div class="row">
<div class="cart cart-sm">     
<table class="table table-bordered table-striped" style="margin-bottom: 0;">
<thead>
<tr>
<td rowspan="2" style="text-align:left; width:90px;"><strong>Date</strong></td>
<td rowspan="2" style="text-align:left; width:340px;"><strong>Particulars</strong></td>
<td colspan="3" style="text-align:center; width:330px;"><strong>Transction Details</strong></td>
<td rowspan="2" style="text-align:center;"><strong>Remarks</strong></td>
</tr>
<tr>
<td style="text-align:center; width:110px;"><strong>Debit</strong></td>
<td style="text-align:center; width:110px;"><strong>Credit</strong></td>
<td style="text-align:right; width:110px;"><strong>Balance</strong></td>
</tr>
</thead>
</table>
<div class="cart-det style-3 item" style="padding:0px;">    
<table class="table table-bordered table-striped" style="margin-bottom: 0;">    
<tbody id="tradata">
<?php
$totdebit=0; $totcredit=0;    
$opdate=date('Y-m-d', strtotime('-30 days',strtotime($today)));    
$opval=opval($type,$did,$opdate);
$sql="SELECT apdate,type,opid,invno,refinv,otnote,ref,chkno,chkdt,ROUND(debit,2) AS debit,ROUND(credit,2) AS credit,@b := ROUND((@b + debit - credit),2) AS balance FROM  (SELECT @b := ".$opval.") AS dummy CROSS JOIN (SELECT id,(CASE WHEN dty='$type' THEN cty WHEN cty='$type' THEN dty END) AS type,(CASE WHEN dty!='$type' THEN did WHEN cty!='$type' THEN cid END)  AS opid,IF(dty='$type',amo,0) AS debit,IF(cty='$type',amo,0) AS credit,invno,refinv,chkno,chkdt,otnote,recon,ref,curid,xrate,apdate,brid,uid,date  FROM tbl_traledger WHERE (dty='$type' AND (CONVERT(did USING utf8) COLLATE utf8_general_ci)='$did') OR (cty='$type' AND (CONVERT(cid USING utf8) COLLATE utf8_general_ci)='$did')) AS curep WHERE apdate BETWEEN '$opdate' AND '$today' ORDER BY TIME(date) ASC,apdate ASC,(CASE type WHEN 'PD' THEN 1 WHEN 'LE' THEN (CASE opid WHEN 37 THEN 2 WHEN 42 THEN 2 WHEN 36 THEN 3 WHEN 41 THEN 3 WHEN 10 THEN 4 WHEN 25 THEN 4 WHEN 38 THEN 5 WHEN 26 THEN 5 WHEN 39 THEN 6 WHEN 27 THEN 6 WHEN 12 THEN 7 WHEN 44 THEN 7 WHEN 40 THEN 8 WHEN 43 THEN 8 WHEN 45 THEN 8 WHEN 46 THEN 8 WHEN 2 THEN 9 END) END) ASC";   
?>
<tr>
<td style="text-align:left; width:90px;"></td>    
<td style="text-align:right; width:340px;"><strong>Opening Balance</strong></td>
<td style="text-align:right; width:110px;"><strong><?php if($opval>=0){echo numtolocal(ABS($opval),'');}?></strong></td>
<td style="text-align:right; width:110px;"><strong><?php if($opval<0){echo numtolocal(ABS($opval),'');}?></strong></td>
<td style="text-align:right; width:110px;"><strong><?php if($opval>0){echo numtolocal(ABS($opval),'').'&nbsp;&nbsp;[ + ]';}else{echo numtolocal(ABS($opval),'').'&nbsp;&nbsp;[ - ]';}?></strong></td>    
<td></td>
</tr>    
<?php    
$query=mysqli_query($con,$sql)or die(mysqli_error($con));
while ($row=mysqli_fetch_array($query)){
$totdebit+=$row['debit'];
$totcredit+=$row['credit'];
?>
<tr>
<td style="text-align:left; width:90px;"><?php echo date("d M Y", strtotime($row['apdate']));?></td>
<td style="text-align:left; width:340px;"><?php if($row['opid']!=0){echo '<strong>'.$row['invno'].'</strong> > '. get_detname($row['type'],$row['opid'],'N');}else{ echo $row['otnote'];} ?></td>
<td style="text-align:right; width:110px;"><?php if($row['debit']>0){echo '<strong>'.numtolocal($row['debit'],'').'</strong>';}?></td>
<td style="text-align:right; width:110px;"><?php if($row['credit']>0){echo '<strong>'.numtolocal($row['credit'],'').'</strong>';}?></td>
<td style="text-align:right; width:110px;"><strong><?php if($row['balance']>0){echo numtolocal(ABS($row['balance']),'').'&nbsp;&nbsp;[ + ]';}else{echo numtolocal(ABS($row['balance']),'').'&nbsp;&nbsp;[ - ]';}?></strong></td>
<td><?php echo $row['ref'];?></td>    
</tr>    
<?php } ?>
<tr>
<td colspan="2"><strong>Total</strong></td>
<td style="text-align:right;"><strong><?php if($opval>=0){echo numtolocal($totdebit+$opval,'');}else{echo numtolocal($totdebit,'');}?></strong></td>
<td style="text-align:right;"><strong><?php if($opval<0){echo numtolocal($totcredit+$opval,'');}else{echo numtolocal($totcredit,'');}?></strong></td>
<td colspan="2"><strong>End Balance:&nbsp;&nbsp;<span style="color: red;font-weight: bolder;"><?php echo numtolocal(($opval+($totdebit-$totcredit)),'');?></span></strong></td>
</tr>    
</tbody>    
</table>
</div>    
</div>    
</div>    
</div>    
</div>      
</div>
</div>

</div>
<script type="text/javascript">
$(".axestab").tabs({ 
  //show: { effect: "slide", direction: "left", duration: 200, easing: "easeOutBack" } ,
  //hide: { effect: "slide", direction: "right", duration: 200, easing: "easeInQuad" } 
});
$('.datetimepicker').datepicker({format: "yyyy-mm-dd", autoclose: true, clearBtn: true, orientation: 'auto bottom'});
$("#stprint").click(function() {    
var mode = 'iframe'; //popup
var close = mode == "popup";
var options = {
mode: mode,
popClose: close
};
$("div.printableArea").printArea(options);
});    
</script>    
<?php } ?> 