<?php

/*
 *  Author   David S. Tufts
 *  Updated: Compatibility with PHP 8.1
 */

// Get parameters from $_GET or set defaults
$filepath = $_GET["filepath"] ?? "";
$text = $_GET["text"] ?? "0";
$size = $_GET["size"] ?? "20";
$orientation = $_GET["orientation"] ?? "horizontal";
$code_type = $_GET["codetype"] ?? "code128";
$print = isset($_GET["print"]) && $_GET["print"] === 'true';
$sizefactor = $_GET["sizefactor"] ?? "1";

// Call the barcode function
barcode($filepath, $text, $size, $orientation, $code_type, $print, $sizefactor);

function barcode($filepath = "", $text = "0", $size = "30", $orientation = "horizontal", $code_type = "code128", $print = true, $SizeFactor = 1) {
    // Define barcode translation table
    $code_array = [
        " "=>"212222", "!"=>"222122", "\""=>"222221", "#"=>"121223", "$"=>"121322", "%" =>"131222", "&"=>"122213", "'" =>"122312",
        "(" =>"132212", ")" =>"221213", "*" =>"221312", "+" =>"231212", ","=>"112232", "-" =>"122132", "."=>"122231", "/" =>"113222",
        "0"=>"123122", "1"=>"123221", "2"=>"223211", "3"=>"221132", "4"=>"221231", "5"=>"213212", "6"=>"223112", "7"=>"312131",
        "8"=>"311222", "9"=>"321122", ":"=>"321221", ";" =>"312212", "<"=>"322112", "="=>"322211", ">"=>"212123", "?"=>"212321",
        "@"=>"232121", "A"=>"111323", "B"=>"131123", "C"=>"131321", "D"=>"112313", "E"=>"132113", "F"=>"132311", "G"=>"211313",
        "H"=>"231113", "I"=>"231311", "J"=>"112133", "K"=>"112331", "L"=>"132131", "M"=>"113123", "N"=>"113321", "O"=>"133121",
        "P"=>"313121", "Q"=>"211331", "R"=>"231131", "S"=>"213113", "T"=>"213311", "U"=>"213131", "V"=>"311123", "W"=>"311321",
        "X"=>"331121", "Y"=>"312113", "Z"=>"312311", "["=>"332111", "\\"=>"314111", "]"=>"221411", "^"=>"431111", "_"=>"111224",
        "`"=>"111422", "a"=>"121124", "b"=>"121421", "c"=>"141122", "d"=>"141221", "e"=>"112214", "f"=>"112412", "g"=>"122114",
        "h"=>"122411", "i"=>"142112", "j"=>"142211", "k"=>"241211", "l"=>"221114", "m"=>"413111", "n"=>"241112", "o"=>"134111",
        "p"=>"111242", "q"=>"121142", "r"=>"121241", "s"=>"114212", "t"=>"124112", "u"=>"124211", "v"=>"411212", "w"=>"421112",
        "x"=>"421211", "y"=>"212141", "z"=>"214121", "{"=>"412121", "|"=>"111143", "}"=>"111341", "~"=>"131141", "DEL"=>"114113"
    ];

    // Generate the barcode string from input text
    $code_string = "";
    $chksum = 104; // Starting checksum value for Code 128

    // Loop through each character of the text to encode
    for ($i = 0; $i < strlen($text); $i++) {
        $char = $text[$i];
        if (isset($code_array[$char])) {
            $code_string .= $code_array[$char];
            $chksum += array_search($char, array_keys($code_array)) * ($i + 1);
        } else {
            die("Character '$char' not supported in Code 128.");
        }
    }

    // Add checksum character to code_string
    $chksum %= 103;
    $code_string .= $code_array[array_keys($code_array)[$chksum]];
    $code_string = "211214" . $code_string . "2331112"; // Add start and stop characters

    // Calculate image dimensions
    $code_length = strlen($code_string) * $SizeFactor;
    $text_height = $print ? 20 : 0; // Text height below barcode if printing text

    $img_width = strtolower($orientation) === "horizontal" ? $code_length : $size;
    $img_height = strtolower($orientation) === "horizontal" ? $size : $code_length;

    // Create image
    $image = imagecreate($img_width, $img_height + $text_height);
    $black = imagecolorallocate($image, 0, 0, 0);
    $white = imagecolorallocate($image, 255, 255, 255);
    imagefill($image, 0, 0, $white);

    // Print text if required
    if ($print) {
        imagestring($image, 5, 5, $img_height, $text, $black);
    }

    // Draw barcode
    $location = 0;
    for ($i = 0; $i < strlen($code_string); $i++) {
        $width = $SizeFactor * (int)$code_string[$i];
        if ($i % 2 == 0) { // Draw black bars
            imagefilledrectangle($image, $location, 0, $location + $width - 1, $img_height, $black);
        }
        $location += $width;
    }

    // Output or save image
    if ($filepath === "") {
        header('Content-type: image/png');
        imagepng($image);
    } else {
        imagepng($image, $filepath);
    }

    imagedestroy($image);
}
?>
