<?php
include ('../inc/dbcon.php');
include ('../inc/functions.php');


$date_from = isset($_POST['date_from']) && !empty($_POST['date_from']) ? $_POST['date_from'] : '';
$date_to   = isset($_POST['date_to']) && !empty($_POST['date_to']) ? $_POST['date_to'] : '';


// --- Helper function for query ---
function getRow($query, $con) {
    $result = $con->query($query);
    return $result ? $result->fetch_assoc() : ['total' => 0];
}

// --- Today’s date ---
$today = date('Y-m-d');

// --- PAYMENT / RECEIVE / EXPENSE CALCULATIONS ---
$totalPayment = getRow("SELECT SUM(amount) AS total FROM tbl_payvoucher", $con);
$totalPayment = getRow("SELECT SUM(amount) AS total FROM tbl_recvoucher", $con);
$totalExpense = getRow("SELECT SUM(amount) AS total FROM tbl_expenses", $con);

$todayPayment = getRow("SELECT SUM(amount) AS total FROM tbl_payvoucher WHERE DATE(apdate) = '$today'", $con);
$todayReceive = getRow("SELECT SUM(amount) AS total FROM tbl_recvoucher WHERE DATE(apdate) = '$today'", $con);
$todayExpense = getRow("SELECT SUM(amount) AS total FROM tbl_expenses WHERE DATE(apdate) = '$today'", $con);

// --- Output JSON ---
echo json_encode([
    "ticketing_baggage" => [
        "total_sales" => $todayPayment['total'],
        "total_receipt" => $todayReceive['total'],
        "outstanding" => $todayExpense['total']
    ],
    "visa_visa_message" => [
        "total_sales" => $totalPayment['total'],
        "total_receipt" => $totalPayment['total'],
        "outstanding" => $totalExpense['total']
    ],
    "ins_otheres" => [
        "total_sales" => 270,
        "total_receipt" => 0,
        "outstanding" => 270
    ],
    "interval" => "$date_from to $date_to"
], JSON_PRETTY_PRINT);



?>
