<?php session_start();
include('../inc/dbcon.php');
include('../inc/functions.php');
if (isset($_SESSION["axeslogin"]) && $_SESSION["axeslogin"] == true) {
    get_pagesecurity('10', 'creates', 'R');
    $_SESSION['cuPages'] = 'saving_savingcreate.php';
    $cuPage = 'saving_savingcreate.php';
    $aid = $_SESSION['uid'];
    $brid = $_SESSION['abrid'];
} else {
    header('Location:../index.php');
    exit;
}
$mhead = 'savingins';
$menuh = 'Saving';
$phead = 'savingcreate';
$page = 'Saving Create';
$dtnow = date("Y-m-d h:i:s", time());
?>

<?php
if (isset($_POST['save_saving'])) {
    $mid = remove_junk(escape($_POST['mid']));
    $code = get_genid('SA', 'SAV', 'P');
    $installment_type = remove_junk(escape($_POST['installment_type']));
    $saving_duration = remove_junk(escape($_POST['saving_duration']));
    $saving_type = remove_junk(escape($_POST['saving_type']));
    $saving_amount = remove_junk(escape($_POST['saving_amount']));
    $book_amount = remove_junk(escape($_POST['book_amount']));
    $profit_per = remove_junk(escape($_POST['profit_percentage']));
    $profit_amount = remove_junk(escape($_POST['profit_amount']));


    $profit_with_saving_amount = remove_junk(escape($_POST['profit_with_saving_amount']));
    $description = remove_junk(escape($_POST['description']));
    $status = 0;

    if (isset($_POST['mid'])) {
        $ducode = mysqli_query($con, "SELECT * FROM tbl_savings WHERE mid = '$mid' AND status= '0'");
    }

    if ($ducode->num_rows > 0) {
        save_msg('i', 'Alrady Exits A Saving! Plz try another');
        echo "<script>window.location='saving_savingcreate.php'</script>";
    } else {
        $sql = "INSERT INTO tbl_savings(mid,code,installment_type,saving_duration,saving_type,saving_amount,profit_per,profit_amount,profit_with_saving_amount,per_installment_amount,description,status,uid,date)
    VALUES ($mid,'$code','$installment_type','$saving_duration','$saving_type','$saving_amount','$profit_per','$profit_amount','$profit_with_saving_amount','$book_amount','$description','$status','$aid','$dtnow')";
        $result = mysqli_query($con, $sql) or die(mysqli_error($con));
        $efid = mysqli_affected_rows($con);
        if ($efid > 0) {
            $act = remove_junk(escape('Saving name: ' . $code));
            write_activity($aid, 'SAV', 'New Saving has been Added', $act);
            save_msg('s', 'Data Successfully Saved!');
        } else {
            save_msg('w', 'Data Fail to Saved!');
        }
        echo "<script>window.location='saving_savingcreate.php'</script>";
    }
}
?>
<?php
include('../layout/head.php');
include('../layout/header.php');
include('../layout/side_nav.php');
?>
<div class="content-wrapper">
    <?php include('../layout/page_head.php'); ?>
    <!-- Main content -->
    <section class="content">

        <div class="row">
            <div class="col-md-9">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">Add New Saving</h3>
                    </div>
                    <div class="box-body">
                        <?php echo display_msg(); ?>
                        <form action="saving_savingcreate.php" onsubmit="return validate()" enctype="multipart/form-data" method="post" accept-charset="utf-8">
                            <div class="col-md-12 popup_details_div">
                                <div class="col-md-1"></div>
                                <div class="col-md-10">
                                    <div class="col-md-12">

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Select Member</label>
                                                    <select class="form-control select2" name="mid" id="mid" required>
                                                        <option value="">-Select One-</option>
                                                        <?php
                                                        $querys = mysqli_query($con, "SELECT * FROM tbl_customer ORDER BY name ASC") or die(mysqli_error($con));
                                                        while ($rows = mysqli_fetch_array($querys)) {
                                                        ?>
                                                            <option value="<?php echo $rows['id']; ?>"><?php echo $rows['code'] . '-' . $rows['name']; ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Installment Type</label>
                                                    <select class="form-control select2" name="installment_type" id="installment_type" onchange="total_count()" required>
                                                        <option value="3">Daily</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Saving Duration</label>
                                                    <select class="form-control select2" name="saving_duration" id="saving_duration" onchange="total_count()" required>
                                                        <optgroup label="Yearly">
                                                            <option value="12">1 Year</option>
                                                            <option value="24">2 Year</option>
                                                            <option value="36">3 Year</option>
                                                            <option value="48">4 Year</option>
                                                            <option value="60">5 Year</option>
                                                            <option value="72">6 Year</option>
                                                            <option value="84">7 Year</option>
                                                            <option value="96">8 Year</option>
                                                            <option value="108">9 Year</option>
                                                            <option value="120">10 Year</option>
                                                            <option value="132">11 Year</option>
                                                            <option value="144">12 Year</option>
                                                            <option value="156">13 Year</option>
                                                            <option value="168">14 Year</option>
                                                        </optgroup>
                                                        

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Saving Type</label>
                                                    <select class="form-control select2" name="saving_type" id="saving_type">
                                                        <option value="General">General</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Book Amount</label>
                                                    <input type="text" name="book_amount" maxlength="20" onchange="total_count()" id="book_amount" class="form-control"  placeholder="e.g. 100.00" readonly/>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Saving Amount</label>
                                                    <input type="number" name="saving_amount" maxlength="18"  onchange="total_count()" id="saving_amount" class="form-control" placeholder="e.g. 5000" />
                                                </div>
                                            </div>
                                            
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Profit Percentage(%)</label>
                                                    <input type="text" name="profit_percentage" maxlength="20" onchange="total_count()" id="profit_percentage" class="form-control" onkeypress="return isNumberKey(event)" placeholder="e.g. 7" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Profit Amount</label>
                                                    <input type="text" name="profit_amount" maxlength="20" onchange="total_count()" id="profit_amount" class="form-control" onkeypress="return isNumberKey(event)" placeholder="e.g. 5000.00" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label>Total Amount</label>
                                                    <input type="text" name="profit_with_saving_amount" maxlength="20" onchange="total_count()" id="profit_with_saving_amount" class="form-control" onkeypress="return isNumberKey(event)" placeholder="e.g. 350000.00" />
                                                </div>
                                            </div>

                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Saving Description</label>
                                                    <textarea class="form-control" name="description" id="description" maxlength="200" rows="4" placeholder="Saving Description"></textarea>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                </div>
                                <div class="col-md-1"></div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="col-md-12 nopadding widgets_area"></div>
                            <div class="row" style="margin-top: 15px">
                                <div class="col-md-8 ">
                                </div>
                                <div class="col-md-4 text-right">
                                    <input type="submit" name="save_saving" id="submit" class="btn btn-flat bg-purple btn-sm" value="Save" /> <a href="saving_savinglist.php" class="btn btn-flat bg-gray  ">Close</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="row">
                    <div class="col-md-12">
                        <div class="box box-solid">
                            <div class="box-header">
                                <h3 class="box-title">History </h3>
                            </div>
                            <!-- /.box-header -->
                            <div class="box-body">
                                <?php if ($_SESSION['access'] == '1') {
                                    echo read_activity($aid, 'SAV', 'A');
                                } else {
                                    echo read_activity($aid, 'SAV', 'U');
                                } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php include('../layout/quick.php'); ?>
    </section>
    <!-- /.main content -->
</div>

<?php
include('../layout/footer.php');
?>
<!-- page script -->
<script type="text/javascript">
    function total_count() {
        var saving_duration = $('#saving_duration').val();
        var duration = parseFloat(saving_duration)/12;
        var book_amount= $('#book_amount').val();
        var saving_amount = $('#saving_amount').val();
        var new_saving_amount= saving_amount;

        var profit_percentage = $('#profit_percentage').val();
        var profit_amount = (parseFloat(new_saving_amount) * (parseFloat(profit_percentage) / 100)) * parseFloat(duration);
        var total = parseFloat(new_saving_amount) + parseFloat(profit_amount);
        $('#profit_with_saving_amount').val(total);
     

        $('#profit_amount').val(profit_amount);
        $('#saving_amount').val(new_saving_amount);
    }



    $(document).ready(function() {
        var mid = new LiveValidation('mid');
        mid.add(Validate.Presence);
       
    });

    $(document).on('change', '#mid', function() {
        id = $(this).val();
        $.ajax({
            url: 'axe_cart.php',
            type: 'post',
            data: {
                bookamount: id
            },
            dataType: 'json',
            success: function(response) {
                $('#book_amount').val(response.book_amount);
                $('#saving_amount').val(response.saving_amount);
            }
        });
    });
</script>
<!-- /page script -->

</html>