<?php
/*--------------------------------------------------------------*/
/* Function for make thumbnail
/*--------------------------------------------------------------*/
function makeThumbnail($sourcefile,$max_width, $max_height, $endfile, $type){
	// Takes the sourcefile (path/to/image.jpg) and makes a thumbnail from it
	// and places it at endfile (path/to/thumb.jpg).

	// Load image and get image size.
   
	//   
	switch($type){
		case'image/png':
			$img = imagecreatefrompng($sourcefile);
			break;
		case'image/jpeg':
			$img = imagecreatefromjpeg($sourcefile);
			break;
        case'image/jpg':
			$img = imagecreatefromjpeg($sourcefile);
			break;    
		case'image/gif':
			$img = imagecreatefromgif($sourcefile);
			break;
			default : 
			return 'Un supported format';
	}

		$width = imagesx( $img );
		$height = imagesy( $img );

	if ($width > $height) {
		if($width < $max_width)
			$newwidth = $width;
	
		else
	
		$newwidth = $max_width;	
	
	
		$divisor = $width / $newwidth;
		$newheight = floor( $height / $divisor);
	}else {
	
	 if($height < $max_height)
         $newheight = $height;
     else
		 $newheight =  $max_height;
	 
    $divisor = $height / $newheight;
    $newwidth = floor( $width / $divisor );
	}

	// Create a new temporary image.
	$tmpimg = imagecreatetruecolor( $newwidth, $newheight );

    imagealphablending($tmpimg, false);
    imagesavealpha($tmpimg, true);
	
	// Copy and resize old image into new image.
	imagecopyresampled( $tmpimg, $img, 0, 0, 0, 0, $newwidth, $newheight, $width, $height);

	// Save thumbnail into a file.

	//compressing the file


	switch($type){
	case'image/png':
		imagepng($tmpimg, $endfile, 0);
		break;
	case'image/jpeg':
		imagejpeg($tmpimg, $endfile, 100);
		break;
    case'image/jpg':
		imagejpeg($tmpimg, $endfile, 100);
		break;        
	case'image/gif':
		imagegif($tmpimg, $endfile, 0);
		break;	

	}

	// release the memory
   imagedestroy($tmpimg);
   imagedestroy($img);
	}
//User=U,Employee=E,Product=P,Company=C;
function get_upload($id,$file,$ftype){
    global $con;
    $loc='';
    $sql='';
    $item=PATHINFO(basename($file['name']));
    $ext=$item['extension'];
    $newFilename = $item['filename'] . "_" . time() . "." . $item['extension'];
    $sourcefile=$file['tmp_name'];
    $type=$file['type'];
    if($ftype=='U'){
        $sql="UPDATE tbl_user SET image='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/user/';
    }elseif($ftype=='M'){
        $sql="UPDATE tbl_seller SET mimage='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/member/';
    }elseif($ftype=='S'){
        $sql="UPDATE tbl_seller SET image1='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/member/';
    }elseif($ftype=='L'){
        $sql="UPDATE tbl_seller SET image2='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/member/';
    }elseif($ftype=='N'){
        $sql="UPDATE tbl_seller SET nimage='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/nid/';
    }elseif($ftype=='E'){
        $sql="UPDATE tbl_employe SET image='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/emp/';
    }elseif($ftype=='F'){
        $sql="UPDATE tbl_employe SET image1='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/emp/';    
    }elseif($ftype=='H'){
        $sql="UPDATE tbl_employe SET image2='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/emp/';    
    }elseif($ftype=='P'){
        $sql="UPDATE tbl_item SET image='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/product/';    
    }else{
        $sql="UPDATE tbl_company SET logo='$newFilename' WHERE id='$id' LIMIT 1";
        $loc='../img/';
    }
    $endfile=$loc.$newFilename;
    makeThumbnail($sourcefile, $max_width=300, $max_height=400, $endfile, $type);
    $result=mysqli_query($con,$sql) or die(mysqli_error($con));
}

function get_destroy($id,$type){
   global $con;
   $sql='';
   $loc='';
   $flage=0;     
    if($type=='U'){
        $sql="SELECT image FROM tbl_user WHERE id='$id' LIMIT 1";
        $loc='../img/user/';
    }elseif($type=='E'){
        $sql="SELECT image FROM tbl_employe WHERE id='$id' LIMIT 1";
        $loc='../img/emp/';
    }elseif($type=='P'){
        $sql="SELECT image FROM tbl_item WHERE id='$id' LIMIT 1";
        $loc='../img/product/';    
    }else{
        $sql="SELECT logo AS image FROM tbl_company WHERE id='$id' LIMIT 1";
        $loc='../img/';
    }
    $result=mysqli_query($con,$sql) or die(mysqli_error($con));
	$row=mysqli_fetch_array($result);
    if($row['image']!=''){
    unlink($loc.$row['image']);
    $flage=1;    
    }else{
    $flage=1;    
    }
    return $flage;
}

function get_destroye($id,$type){
    global $con;
    $sql='';
    $loc='';
    $flage=0;     
    if($type=='F'){
         $sql="SELECT image1 FROM tbl_employe WHERE id='$id' LIMIT 1";
         $loc='../img/emp/';
         $result=mysqli_query($con,$sql) or die(mysqli_error($con));
        $row=mysqli_fetch_array($result);
        if($row['image1']!=''){
        unlink($loc.$row['image1']);
        $flage=1;    
        }else{
        $flage=1;    
        }
     }elseif($type=='H'){
        $sql="SELECT image2 FROM tbl_employe WHERE id='$id' LIMIT 1";
        $loc='../img/emp/';
         $result=mysqli_query($con,$sql) or die(mysqli_error($con));
        $row=mysqli_fetch_array($result);
        if($row['image2']!=''){
        unlink($loc.$row['image2']);
        $flage=1;    
        }else{
        $flage=1;    
        }   
     }elseif($type=='M'){
        $sql="SELECT mimage FROM tbl_seller WHERE id='$id' LIMIT 1";
        $loc='../img/member/';
        $result=mysqli_query($con,$sql) or die(mysqli_error($con));
        $row=mysqli_fetch_array($result);
        if($row['mimage']!=''){
        unlink($loc.$row['mimage']);
        $flage=1;    
        }else{
        $flage=1;    
        }   
     }elseif($type=='N'){
        $sql="SELECT nimage FROM tbl_seller WHERE id='$id' LIMIT 1";
        $loc='../img/nid/';
        $result=mysqli_query($con,$sql) or die(mysqli_error($con));
        $row=mysqli_fetch_array($result);
        if($row['nimage']!=''){
        unlink($loc.$row['nimage']);
        $flage=1;    
        }else{
        $flage=1;    
        }   
     }elseif($type=='S'){
        $sql="SELECT image1 FROM tbl_seller WHERE id='$id' LIMIT 1";
        $loc='../img/member/';
        $result=mysqli_query($con,$sql) or die(mysqli_error($con));
        $row=mysqli_fetch_array($result);
        if($row['image1']!=''){
        unlink($loc.$row['image1']);
        $flage=1;    
        }else{
        $flage=1;    
        }   
     }elseif($type=='L'){
        $sql="SELECT image2 FROM tbl_seller WHERE id='$id' LIMIT 1";
        $loc='../img/member/';
        $result=mysqli_query($con,$sql) or die(mysqli_error($con));
        $row=mysqli_fetch_array($result);
        if($row['image2']!=''){
        unlink($loc.$row['image2']);
        $flage=1;    
        }else{
        $flage=1;    
        }   
     }else{
         $sql="SELECT logo AS image FROM tbl_company WHERE id='$id' LIMIT 1";
         $loc='../img/';
     }
     
     return $flage;
 }
?>