

<?php $__env->startSection('title', 'Edit User'); ?>

<?php $__env->startSection('style'); ?>
<style>
.form-label {
    font-weight: 600;
}
.required:after {
    content: ' *';
    color: red;
}
.info-section {
    background-color: #f8f9fa;
    border-radius: 5px;
    padding: 20px;
    margin-top: 20px;
}
.info-section h4 {
    color: #159abe;
    margin-bottom: 20px;
    font-size: 1.1rem;
}
.info-item {
    margin-bottom: 15px;
}
.info-label {
    font-weight: 600;
    color: #6c757d;
    font-size: 0.9rem;
}
.info-value {
    color: #2c3338;
    margin-top: 3px;
}
.badge-2fa {
    font-size: 0.8rem;
    padding: 5px 10px;
    border-radius: 15px;
}
.badge-2fa.enabled {
    background-color: #28a745;
    color: white;
}
.badge-2fa.disabled {
    background-color: #dc3545;
    color: white;
}
.recovery-codes {
    background: #f8f9fa;
    padding: 10px 15px;
    border-radius: 4px;
    border: 1px solid #dee2e6;
    margin-top: 5px;
    font-family: monospace;
}
.recovery-code {
    padding: 2px 0;
    color: #495057;
}
.form-actions {
    background-color: #fff;
    padding: 15px 0;
    margin: 20px 0;
    border-bottom: 1px solid #dee2e6;
    text-align: center;
}
.recovery-code-badge {
    display: inline-block;
    background: #e9ecef;
    color: #495057;
    padding: 4px 8px;
    border-radius: 4px;
    font-size: 0.85rem;
    margin: 2px;
    font-family: monospace;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header bg_sb_primary">
        <h3 class="card-title">Edit User: <?php echo e($user->first_name); ?> <?php echo e($user->last_name); ?></h3>
    </div>
    <div class="card-body">
        <form action="<?php echo e(route('admin.users.update', $user->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="first_name" class="form-label required">First Name</label>
                    <input type="text" class="form-control <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="first_name" name="first_name" 
                           value="<?php echo e(old('first_name', $user->first_name)); ?>" required>
                    <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="last_name" class="form-label required">Last Name</label>
                    <input type="text" class="form-control <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="last_name" name="last_name" 
                           value="<?php echo e(old('last_name', $user->last_name)); ?>" required>
                    <?php $__errorArgs = ['last_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="email" class="form-label required">Email</label>
                    <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="email" name="email" 
                           value="<?php echo e(old('email', $user->email)); ?>" required>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="phone" class="form-label">Phone</label>
                    <input type="text" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="phone" name="phone" 
                           value="<?php echo e(old('phone', $user->phone)); ?>">
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="password" class="form-label">New Password</label>
                    <input type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           id="password" name="password">
                    <small class="form-text text-muted">Leave blank to keep current password</small>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="password_confirmation" class="form-label">Confirm New Password</label>
                    <input type="password" class="form-control" 
                           id="password_confirmation" name="password_confirmation">
                </div>

                <div class="col-md-6 mb-3">
                    <label for="role" class="form-label required">Role</label>
                    <select class="form-control <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            id="role" name="role" required>
                        <option value="">Select Role</option>
                        <option value="user" <?php echo e(old('role', $user->role) == 'user' ? 'selected' : ''); ?>>User</option>
                        <option value="admin" <?php echo e(old('role', $user->role) == 'admin' ? 'selected' : ''); ?>>Admin</option>
                    </select>
                    <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="col-md-6 mb-3">
                    <div class="form-check mt-4">
                        <input type="checkbox" class="form-check-input" 
                               id="is_active" name="is_active" value="1" 
                               <?php echo e(old('is_active', $user->is_active) ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="is_active">Active Account</label>
                    </div>
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" 
                               id="email_verified" name="email_verified" value="1" 
                               <?php echo e(old('email_verified', $user->email_verified_at) ? 'checked' : ''); ?>>
                        <label class="form-check-label" for="email_verified">Email Verified</label>
                    </div>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" class="sb_btn">
                    <i class="fas fa-save"></i> Update User
                </button>
                <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-secondary">
                    <i class="fas fa-times"></i> Cancel
                </a>
            </div>

            <div class="info-section">
                <h4><i class="fas fa-info-circle"></i> Additional Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Account Created</div>
                            <div class="info-value"><?php echo e($user->created_at->format('F j, Y \a\t g:i A')); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Last Updated</div>
                            <div class="info-value"><?php echo e($user->updated_at->format('F j, Y \a\t g:i A')); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Email Verification Date</div>
                            <div class="info-value">
                                <?php if($user->email_verified_at): ?>
                                    <?php echo e($user->email_verified_at->format('F j, Y \a\t g:i A')); ?>

                                <?php else: ?>
                                    <span class="text-danger">Not verified</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Two-Factor Authentication</div>
                            <div class="info-value">
                                <?php if($user->two_factor_enabled): ?>
                                    <span class="badge-2fa enabled">
                                        <i class="fas fa-shield-alt"></i> Enabled
                                    </span>
                                    <div class="mt-2">
                                        <small class="text-muted">
                                            Confirmed at: <?php echo e($user->two_factor_confirmed_at ? $user->two_factor_confirmed_at->format('F j, Y \a\t g:i A') : 'Not confirmed'); ?>

                                        </small>
                                    </div>
                                <?php else: ?>
                                    <span class="badge-2fa disabled">
                                        <i class="fas fa-shield-alt"></i> Disabled
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Recovery Codes</div>
                            <div class="info-value">
                                <?php if($user->two_factor_recovery_codes): ?>
                                    <span class="text-success mb-2 d-block">
                                        <i class="fas fa-key"></i> Recovery codes are available
                                    </span>
                                    <div>
                                        <?php $__currentLoopData = json_decode($user->two_factor_recovery_codes); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="recovery-code-badge"><?php echo e($code); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php else: ?>
                                    <span class="text-danger">
                                        <i class="fas fa-times-circle"></i> No recovery codes generated
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if($user->shipping_addr): ?>
            <div class="info-section">
                <h4><i class="fas fa-shipping-fast"></i> Shipping Information</h4>
                <div class="row">
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Contact Person</div>
                            <div class="info-value"><?php echo e($user->shipping_addr['contact_name'] ?? 'N/A'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Contact Phone</div>
                            <div class="info-value">
                                <?php echo e($user->shipping_addr['contact_phone'] ?? 'N/A'); ?>

                                <?php if(isset($user->shipping_addr['whatsapp'])): ?>
                                    <br>
                                    <small class="text-success">
                                        <i class="fab fa-whatsapp"></i> WhatsApp: <?php echo e($user->shipping_addr['whatsapp']); ?>

                                    </small>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Contact Email</div>
                            <div class="info-value"><?php echo e($user->shipping_addr['contact_email'] ?? 'N/A'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-item">
                            <div class="info-label">Delivery Address</div>
                            <div class="info-value"><?php echo e($user->shipping_addr['address'] ?? 'N/A'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">City</div>
                            <div class="info-value"><?php echo e($user->shipping_addr['city'] ?? 'N/A'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">State</div>
                            <div class="info-value"><?php echo e($user->shipping_addr['state'] ?? 'N/A'); ?></div>
                        </div>
                        <div class="info-item">
                            <div class="info-label">Postal Code</div>
                            <div class="info-value"><?php echo e($user->shipping_addr['postal_code'] ?? 'N/A'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('admin_base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/techmind/public_html/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>